--Copyright 2006 Ryan Hamshire
--This document may be redistributed as a whole, provided it is unaltered and this copyright notice is not removed.

--================

--GLOBAL VARIABLES

--================

--category constants
--number indicates sort priority (1 is highest)
BS_SOULBOUND   = 1
BS_REAGENT     = 2
BS_CONSUMABLE  = 3
BS_QUEST       = 4
BS_TRADE       = 5
BS_QUALITY     = 6
BS_COMMON      = 7
BS_TRASH       = 8

--bag group definitions
BS_bagGroups = {
	
	--ammo pouches
	{["keywords"] = {"ammo", "shot", "bandolier"}}, 
	
	--arrow quivers
	{["keywords"] = {"quiver", "lamina"}}, 

	--enchanting bags
	{["keywords"] = {"spellfire", "enchant"}}, 

	--soul gem bags (warlock)
    {["keywords"] = {"felcloth", "shadow", "soul"}}, 

	--herbalism bags
    {["keywords"] = {"cenarius", "herb"}}, 
    
	--mining bags
	{["keywords"] = {"mining"}}, 
	
	--engineering bags
    {["keywords"] = {"toolbox"}}, 

	--gem bags
	{["keywords"] = {"jewels", "gem"}},
	
	--leather bags
	{["keywords"] = {"leather", "drum", "many"}},
	
	--all others
	["standard"] = {["keywords"] = {}}
	
	}
	
--grid of item data based on destination inventory location
BS_itemSwapGrid = {}
					
BS_sorting = false     --indicates bag rearrangement is in progress
BS_pauseRemaining = 0  --how much longer to wait before running the OnUpdate code again

--order by which categories are placed into bags
--starting from the leftmost bag
BS_categoryOrder = {
    [1] = "soulbound",
    [2] = "reagent",
    [3] = "consumable",
    [4] = "quest",
    [5] = "trade", 
	[6] = "quality",
    [7] = "common",
    [8] = "trash" }
    
--========================

--INTERFACE EVENT HANDLERS

--========================

function BS_OnLoad()

	--register slash commands
	SlashCmdList["BSbagsort"] = BS_slashBagSortHandler
  	SLASH_BSbagsort1 = '/bagsort'

	SlashCmdList["BSbanksort"] = BS_slashBankSortHandler
  	SLASH_BSbanksort1 = '/banksort'

	--initialize data
	BS_clearData()

end

function BS_OnEvent()

end

function BS_OnUpdate()

	--if true then return end

	if not BS_sorting then return end
	
	BS_pauseRemaining = BS_pauseRemaining - arg1
	
	if BS_pauseRemaining > 0 then return end

	local changesThisRound = false
	local blockedThisRound = false
	
	--for each bag in the grid
	for bagIndex in pairs(BS_itemSwapGrid) do
	
	    --for each slot in this bag
	    for slotIndex in pairs(BS_itemSwapGrid[bagIndex]) do
	    
			--(for readability)
			local destinationBag  = BS_itemSwapGrid[bagIndex][slotIndex].destinationBag
			local destinationSlot = BS_itemSwapGrid[bagIndex][slotIndex].destinationSlot

			--see if either item slot is currently locked
	        local _, _, locked1 = GetContainerItemInfo(bagIndex, slotIndex)
	        local _, _, locked2 = GetContainerItemInfo(destinationBag, destinationSlot)
	        
	        if locked1 or locked2 then
	        
	            blockedThisRound = true
	            
			--if item not already where it belongs, move it
			elseif bagIndex ~= destinationBag or slotIndex ~= destinationSlot then
			
               	PickupContainerItem(bagIndex, slotIndex)
				PickupContainerItem(destinationBag, destinationSlot)
				
				local tempItem = BS_itemSwapGrid[destinationBag][destinationSlot]
				BS_itemSwapGrid[destinationBag][destinationSlot] = BS_itemSwapGrid[bagIndex][slotIndex]
				BS_itemSwapGrid[bagIndex][slotIndex] = tempItem

				changesThisRound = true
	        
	        end
	        
		end
		
	end
	
	if not changesThisRound and not blockedThisRound then
	
	    BS_sorting = false
	    BS_clearData()

	end
	
	BS_pauseRemaining = .05

end

function BS_slashBankSortHandler()

	sortBagRange({-1, 5, 6, 7, 8, 9, 10, 11})

end

function BS_slashBagSortHandler()

	sortBagRange({0, 1, 2, 3, 4})
	
end

function sortBagRange(bagList)

	--clear any data from previous sorts
	BS_clearData()

	--assign bags to bag groups
	for slotNumIndex, slotNum in pairs(bagList) do
	
		--if bag exists
		if GetContainerNumSlots(slotNum) > 0 then
		
			--initialize the item grid for this bag (used later)
			BS_itemSwapGrid[slotNum] = {}

			local bagName

			--watch for special case for bank contents, which doesn't have a bag name
			if slotNum > -1 then

				bagName = string.lower(GetBagName(slotNum))
				
			else
			
			    bagName = ""
			    
			end
			
			--for each bag group
			local assigned = false
			for groupKey, groupData in pairs(BS_bagGroups) do

				--for each keyword in the bag group definition
				for keywordKey, keywordData in pairs(groupData.keywords) do
				
					--if the keyword is a substring of the bag name
					if string.find(bagName, keywordData) then
					
						--assign it to the current group
						table.insert(groupData.bagSlotNumbers, slotNum)
						--say("assigned " .. bagName .. " to group with[" .. keywordData .. "]")
						assigned = true
						break
						
					end
					
				end
				
			end
				
			--if not assigned, assign it to the standard bag group
			if not assigned then
				
				table.insert(BS_bagGroups["standard"].bagSlotNumbers, slotNum)
				--say("assigned " .. bagName .. " to standard bag group")
					
			end

		end
		
	end
	
	--for each bag group
	for groupKey, group in pairs(BS_bagGroups) do
	
		--initialize the list of items for this bag group
		group.itemList = {}

		--for each bag in this group
		for bagKey, bagSlot in pairs(group.bagSlotNumbers) do
		
			--for each item slot in this bag
			for itemSlot=1, GetContainerNumSlots(bagSlot) do
			
				--get a reference for the item in this location
				local itemLink = GetContainerItemLink(bagSlot, itemSlot)
				
				--if this slot is non-empty
				if itemLink ~= nil then
				
					--collect important data about the item
					local newItem   = {}
					
					--initialize the sorting string for this item
					newItem.sortString = ""
					
					--use reference from above to request more detailed information
					local itemName, _, itemRarity, _, _, itemType, itemSubType, _, itemEquipLoc, _ = GetItemInfo(itemLink)
					newItem.name = itemName
					
					--determine category
					
					--soulbound items
                   	local tooltip = getglobal("BS_toolTip")
					local owner = getglobal("Bag_Sort_Core")
                    tooltip:SetOwner(owner, ANCHOR_NONE)
					tooltip:ClearLines()
					tooltip:SetBagItem(bagSlot, itemSlot)
					local tooltipLine2 = getglobal("BS_toolTipTextLeft2"):GetText()
					tooltip:Hide()
					
					if tooltipLine2 and tooltipLine2 == "Soulbound" then
						newItem.sortString = newItem.sortString .. BS_SOULBOUND
						
					--consumable items
					elseif itemType == "Consumable" then
						newItem.sortString = newItem.sortString .. BS_CONSUMABLE
				
					--reagents
					elseif itemType == "Reagent" then
						newItem.sortString = newItem.sortString .. BS_REAGENT
				
					--trade goods
					elseif itemType == "Trade Goods" then
						newItem.sortString = newItem.sortString .. BS_TRADE
					
					--quest items
					elseif itemType == "Quest" then
						newItem.sortString = newItem.sortString .. BS_QUEST
					
					--junk
					elseif itemRarity == 0 then
						newItem.sortString = newItem.sortString .. BS_TRASH
					
					--common quality
					elseif itemRarity == 1 then
						newItem.sortString = newItem.sortString .. BS_COMMON

					--higher quality
					else
						newItem.sortString = newItem.sortString .. BS_QUALITY
						
					end
					
					--finish the sort string, placing more important information
					--closer to the start of the string
					
					newItem.sortString = newItem.sortString .. itemType .. itemSubType .. itemEquipLoc .. itemName
					
					--add this item's accumulated data to the item list for this bag group
					tinsert(group.itemList, newItem)

					--record location
					BS_itemSwapGrid[bagSlot][itemSlot] = newItem
					newItem.startBag = bagSlot
					newItem.startSlot = itemSlot
					
				end
				
			end
			
		end
		
		--sort the item list for this bag group by sort strings
		table.sort(group.itemList, function(a, b) return a.sortString < b.sortString end)
		
		--show the results for this group
		--say(group.keywords[1])
		for index, item in pairs(group.itemList) do
		
			local gridSlot = index
		
   			--record items in a grid according to their intended final placement
			for bagSlotNumberIndex, bagSlotNumber in pairs(group.bagSlotNumbers) do
		
				if gridSlot <= GetContainerNumSlots(bagSlotNumber) then
				
					BS_itemSwapGrid[item.startBag][item.startSlot].destinationBag  = bagSlotNumber
					BS_itemSwapGrid[item.startBag][item.startSlot].destinationSlot = gridSlot
					--say(BS_itemSwapGrid[item.startBag][item.startSlot].sortString .. bagSlotNumber .. ' ' .. gridSlot)
					break

				else
				
					gridSlot = gridSlot - GetContainerNumSlots(bagSlotNumber)
					
				end
	
	        end
	
	    end
	
	end
	
	--signal for sorting to begin
	BS_sorting = true
	
end

--=================

--UTILITY FUNCTIONS

--=================

function BS_clearData()

 	BS_itemSwapGrid = {}
	for groupKey, groupData in pairs(BS_bagGroups) do

    	groupData.bagSlotNumbers = {}
    	groupData.itemList = {}

	end

end

function say(text)

  DEFAULT_CHAT_FRAME:AddMessage(text)

end