﻿--[[
Name: Babble-Quest-2.2
Revision: $Rev: 79108 $
Authors(s): Kodewulf (kodewulf@gmail.com)
Website: www.wowace.com
Documentation: http://www.wowace.com/wiki/Babble-Quest-2.2
Dependencies: AceLibrary, AceLocale-2.2
License: MIT
]]

local MAJOR_VERSION = "Babble-Quest-2.2"
local MINOR_VERSION = tonumber(string.sub("$Revision: 79108 $", 12, -3))

if not AceLibrary then error(MAJOR_VERSION .. " requires AceLibrary") end
if not AceLibrary:HasInstance("AceLocale-2.2") then error(MAJOR_VERSION .. " requires AceLocale-2.2") end

local _, x = AceLibrary("AceLocale-2.2"):GetLibraryVersion()
MINOR_VERSION = MINOR_VERSION * 100000 + x

if not AceLibrary:IsNewVersion(MAJOR_VERSION, MINOR_VERSION) then return end

local BabbleQuest = AceLibrary("AceLocale-2.2"):new(MAJOR_VERSION)

BabbleQuest:RegisterTranslations("enUS", function() return {
    -- Quest names (3808)
        ["... and Bugs"] = true,
        ["... and a Batch of Ooze"] = true,
        ["...and a Time for Action"] = true,
        ["10 Tickets - Last Month's Mutton"] = true,
        ["12 Tickets - Lesser Darkmoon Prize"] = true,
        ["1200 Tickets - Amulet of the Darkmoon"] = true,
        ["1200 Tickets - Orb of the Darkmoon"] = true,
        ["40 Tickets - Greater Darkmoon Prize"] = true,
        ["40 Tickets - Schematic: Steam Tonk Controller"] = true,
        ["5 Tickets - Darkmoon Flower"] = true,
        ["5 Tickets - Minor Darkmoon Prize"] = true,
        ["50 Tickets - Darkmoon Storage Box"] = true,
        ["A Bad Egg"] = true,
        ["A Baying of Gnolls"] = true,
        ["A Better Ingredient"] = true,
        ["A Bijou for Zanza"] = true,
        ["A Binding Contract"] = true,
        ["A Bird's-Eye View"] = true,
        ["A Blue Light Bargain"] = true,
        ["A Boar's Vitality"] = true,
        ["A Boaring Time for Grulloc"] = true,
        ["A Broken Trap"] = true,
        ["A Bump in the Road"] = true,
        ["A Bundle of Hides"] = true,
        ["A Bundle of Trouble"] = true,
        ["A Burden of Souls"] = true,
        ["A Carefully Wrapped Present"] = true,
        ["A Cleansing Light"] = true,
        ["A Collection of Heads"] = true,
        ["A Convincing Disguise"] = true,
        ["A Crew Under Fire"] = true,
        ["A Crumpled Up Note"] = true,
        ["A Cry For Help"] = true,
        ["A Cure for Zahlia"] = true,
        ["A Curse Upon Both of Your Clans!"] = true,
        ["A Dandy's Best Friend"] = true,
        ["A Dark Pact"] = true,
        ["A Dark Threat Looms"] = true,
        ["A Date with Dorgok"] = true,
        ["A Daughter's Love"] = true,
        ["A Debilitating Sickness"] = true,
        ["A Defector"] = true,
        ["A Different Approach"] = true,
        ["A Dip in the Moonwell"] = true,
        ["A Dire Situation"] = true,
        ["A Discreet Inquiry"] = true,
        ["A Dwarf and His Tools"] = true,
        ["A Fate Worse Than Death"] = true,
        ["A Favor for Evershine"] = true,
        ["A Favorite Treat"] = true,
        ["A Festive Gift"] = true,
        ["A Final Blow"] = true,
        ["A Fine Egg"] = true,
        ["A Fine Mess"] = true,
        ["A Fishy Peril"] = true,
        ["A Fistful of Slivers"] = true,
        ["A Free Lunch"] = true,
        ["A Friend in Need"] = true,
        ["A Gaily Wrapped Present"] = true,
        ["A Gallon of Blood"] = true,
        ["A Gesture of Goodwill"] = true,
        ["A Ghost in the Machine"] = true,
        ["A Gift for Voren'thal"] = true,
        ["A Gnome's Assistance"] = true,
        ["A Gnome's Respite"] = true,
        ["A Good Friend"] = true,
        ["A Good Head On Your Shoulders"] = true,
        ["A Grave Situation"] = true,
        ["A Grim Discovery"] = true,
        ["A Grim Task"] = true,
        ["A Grunt's Work..."] = true,
        ["A Handful of Magic Dust"] = true,
        ["A Hasty Departure"] = true,
        ["A Haunted History"] = true,
        ["A Head Full of Ivory"] = true,
        ["A Heap of Ethereals"] = true,
        ["A Helping Hand"] = true,
        ["A Hero Is Needed"] = true,
        ["A Hero's Reward"] = true,
        ["A Hero's Welcome"] = true,
        ["A Host of Evil"] = true,
        ["A Humble Offering"] = true,
        ["A Humble Task"] = true,
        ["A Hunter's Boast"] = true,
        ["A Hunter's Challenge"] = true,
        ["A Husband's Last Battle"] = true,
        ["A Husband's Revenge"] = true,
        ["A Job Undone"] = true,
        ["A Job for an Intelligent Man"] = true,
        ["A King's Tribute"] = true,
        ["A Lack of Fear"] = true,
        ["A Land Filled with Hatred"] = true,
        ["A Lesson Learned"] = true,
        ["A Letter Undelivered"] = true,
        ["A Lingering Suspicion"] = true,
        ["A Little Dash of Seasoning"] = true,
        ["A Little Help From My Friends"] = true,
        ["A Little Slime Goes a Long Way"] = true,
        ["A Lost Master"] = true,
        ["A Map to Where?"] = true,
        ["A Message to Telaar"] = true,
        ["A Mysterious Portent"] = true,
        ["A Necessary Distraction"] = true,
        ["A New Cloak's Sheen"] = true,
        ["A New Ore Sample"] = true,
        ["A New Plague"] = true,
        ["A New Threat"] = true,
        ["A Noble Brew"] = true,
        ["A Not-So-Modest Proposal"] = true,
        ["A Pawn on the Eternal Board"] = true,
        ["A Peon's Burden"] = true,
        ["A Personal Favor"] = true,
        ["A Pilgrim's Plight"] = true,
        ["A Pilot's Revenge"] = true,
        ["A Plague Upon Thee"] = true,
        ["A Portable Power Source"] = true,
        ["A Promising Start"] = true,
        ["A Proper String"] = true,
        ["A Putrid Task"] = true,
        ["A Question of Gluttony"] = true,
        ["A Rare Bean"] = true,
        ["A Recipe For Death"] = true,
        ["A Refugee's Quandary"] = true,
        ["A Reliquary of Purity"] = true,
        ["A Restorative Draught"] = true,
        ["A Rogue's Deal"] = true,
        ["A Sacred Burial"] = true,
        ["A Scroll from Mauren"] = true,
        ["A Secret Revealed"] = true,
        ["A Shameful Waste"] = true,
        ["A Shifty Merchant"] = true,
        ["A Short Incubation"] = true,
        ["A Shred of Hope"] = true,
        ["A Sign of Hope"] = true,
        ["A Simple Request"] = true,
        ["A Simple Robe"] = true,
        ["A Small Start"] = true,
        ["A Solvent Spirit"] = true,
        ["A Somber Task"] = true,
        ["A Spirit Ally?"] = true,
        ["A Spirit Guide"] = true,
        ["A Sticky Situation"] = true,
        ["A Strange Historian"] = true,
        ["A Strange One"] = true,
        ["A Strange Red Key"] = true,
        ["A Strange Request"] = true,
        ["A Strange Weapon"] = true,
        ["A Study in Power"] = true,
        ["A Supernatural Device"] = true,
        ["A Swift Message"] = true,
        ["A Tale of Sorrow"] = true,
        ["A Task Unfinished"] = true,
        ["A Taste of Flame"] = true,
        ["A Terrible Purpose"] = true,
        ["A Threat Within"] = true,
        ["A Threat in Feralas"] = true,
        ["A Time for Negotiation..."] = true,
        ["A Traitor Among Us"] = true,
        ["A Troubled Spirit"] = true,
        ["A Troubling Breeze"] = true,
        ["A Vengeful Fate"] = true,
        ["A Visit With The Ancestors"] = true,
        ["A Visit With the Greatmother"] = true,
        ["A Visit to Gregan"] = true,
        ["A Warm Welcome"] = true,
        ["A Warrior's Training"] = true,
        ["A Watchful Eye"] = true,
        ["A Yeti of Your Own"] = true,
        ["Abandoned Hope"] = true,
        ["Abandoned Investigations"] = true,
        ["Abjurist Belmara"] = true,
        ["Above and Beyond"] = true,
        ["Abyssal Contacts"] = true,
        ["Abyssal Crests"] = true,
        ["Additional Materials"] = true,
        ["Administering the Salve"] = true,
        ["After the Ambush"] = true,
        ["Again With the Zapped Giants"] = true,
        ["Against All Odds"] = true,
        ["Against Lord Shalzaru"] = true,
        ["Against the Hatecrest"] = true,
        ["Against the Illidari"] = true,
        ["Against the Legion"] = true,
        ["Agamaggan's Agility"] = true,
        ["Agamaggan's Strength"] = true,
        ["Agamand Heirlooms"] = true,
        ["Agents of Destruction"] = true,
        ["Aggression"] = true,
        ["Agitated Spirits of Skysong"] = true,
        ["Agmond's Fate"] = true,
        ["Aiding the Outrunners"] = true,
        ["Ak'Zeloth"] = true,
        ["Akama"] = true,
        ["Akama's Promise"] = true,
        ["Akiris by the Bundle"] = true,
        ["Aldor No More"] = true,
        ["Alien Ecology"] = true,
        ["Alien Egg"] = true,
        ["Alien Predators"] = true,
        ["Alien Spirits"] = true,
        ["All Along the Watchtowers"] = true,
        ["All Clear!"] = true,
        ["All That Remains"] = true,
        ["Allegiance to Cenarion Circle"] = true,
        ["Allegiance to the Aldor"] = true,
        ["Allegiance to the Old Gods"] = true,
        ["Allegiance to the Scryers"] = true,
        ["Alliance Relations"] = true,
        ["Alliance Trauma"] = true,
        ["Alpha Strike"] = true,
        ["Altered Beings"] = true,
        ["Alther's Mill"] = true,
        ["Altruis"] = true,
        ["Amani Encroachment"] = true,
        ["Amani Invasion"] = true,
        ["Ambermill Investigations"] = true,
        ["Ammo for Rumbleshot"] = true,
        ["Amongst the Ruins"] = true,
        ["Amulet of Secrets"] = true,
        ["An Aggressive Defense"] = true,
        ["An Alternative Alternative"] = true,
        ["An Ambassador of Evil"] = true,
        ["An Ambitious Plan"] = true,
        ["An Apprentice's Enchantment"] = true,
        ["An Audacious Advance"] = true,
        ["An Audience with the Prince"] = true,
        ["An Earnest Proposition"] = true,
        ["An Easy Pickup"] = true,
        ["An Extraordinary Egg"] = true,
        ["An Imp's Request"] = true,
        ["An Improper Burial"] = true,
        ["An Introduction"] = true,
        ["An OOX of Your Own"] = true,
        ["An Old Colleague"] = true,
        ["An Old Gift"] = true,
        ["An Old History Book"] = true,
        ["An Ordinary Egg"] = true,
        ["An Orphan Looking For a Home"] = true,
        ["An Unholy Alliance"] = true,
        ["An Unnatural Drought"] = true,
        ["An Unseen Hand"] = true,
        ["An Unusual Patron"] = true,
        ["An Unwelcome Guest"] = true,
        ["An Unwelcome Presence"] = true,
        ["Anachronos"] = true,
        ["Ancient Sinew Wrapped Lamina"] = true,
        ["Ancient Spirit"] = true,
        ["Andron's Payment to Jediga"] = true,
        ["Angling to Beat the Competition"] = true,
        ["Ango'rosh Encroachment"] = true,
        ["Animist's Caress"] = true,
        ["Anok'suten"] = true,
        ["Another Heap of Ethereals"] = true,
        ["Another Message to the Wildhammer"] = true,
        ["Another Power Source?"] = true,
        ["Ansirem's Key"] = true,
        ["Answered Questions"] = true,
        ["Anthion's Old Friend"] = true,
        ["Anthion's Parting Words"] = true,
        ["Anthion's Strange Request"] = true,
        ["Apothecary Antonivich"] = true,
        ["Apothecary Zamah"] = true,
        ["Apothecary Zelana"] = true,
        ["Apprentice Angler"] = true,
        ["Apprentice's Duties"] = true,
        ["Aquatic Form"] = true,
        ["Aquementas"] = true,
        ["Ar'kelos the Guardian"] = true,
        ["Arachnophobia"] = true,
        ["Araj's Scarab"] = true,
        ["Arakkoa War Path"] = true,
        ["Arathor Basic Care Package"] = true,
        ["Arathor Standard Care Package"] = true,
        ["Arcane Feedback"] = true,
        ["Arcane Instability"] = true,
        ["Arcane Reavers"] = true,
        ["Arcane Refreshment"] = true,
        ["Arcane Runes"] = true,
        ["Arcane Tomes"] = true,
        ["Arcanite"] = true,
        ["Arconus the Insatiable"] = true,
        ["Arelion's Journal"] = true,
        ["Arelion's Mistress"] = true,
        ["Arelion's Secret"] = true,
        ["Arena Master"] = true,
        ["Arikara"] = true,
        ["Armaments for Deception"] = true,
        ["Armed and Ready"] = true,
        ["Armor Kits for the Field"] = true,
        ["Armor Scraps"] = true,
        ["Arms for the Field"] = true,
        ["Army of the Black Dragon"] = true,
        ["Arrival in Outland"] = true,
        ["Arrows Are For Sissies"] = true,
        ["Artifacts of the Blacksilt"] = true,
        ["Arugal Must Die"] = true,
        ["Arugal's Folly"] = true,
        ["Arzeth's Demise"] = true,
        ["As Water Cascades"] = true,
        ["As the Crow Flies"] = true,
        ["Ascension..."] = true,
        ["Asghar's Totem"] = true,
        ["Ashenvale Outrunners"] = true,
        ["Assassin's Contract"] = true,
        ["Assassination Plot"] = true,
        ["Assault on Fenris Isle"] = true,
        ["Assault on Zeb'Nowa"] = true,
        ["Assault on the Kolkar"] = true,
        ["Assessing the Situation"] = true,
        ["Assessing the Threat"] = true,
        ["Assisting the Consortium"] = true,
        ["Astral Knot Garment"] = true,
        ["At War With The Scarlet Crusade"] = true,
        ["Attack on Camp Narache"] = true,
        ["Attack on Firewing Point"] = true,
        ["Attack on Zeb'Tela"] = true,
        ["Attack on the Tower"] = true,
        ["Auchindoun..."] = true,
        ["Audience with the Prophet"] = true,
        ["Auntie Marlene"] = true,
        ["Aurel Goldleaf"] = true,
        ["Aurius' Reckoning"] = true,
        ["Avenge My Village"] = true,
        ["Avenger's Breastplate"] = true,
        ["Avenger's Crown"] = true,
        ["Avenger's Greaves"] = true,
        ["Avenger's Legguards"] = true,
        ["Avenger's Pauldrons"] = true,
        ["Avenging the Fallen"] = true,
        ["Avruu's Orb"] = true,
        ["Azsharite"] = true,
        ["Azure Templar"] = true,
        ["Azuregos's Magical Ledger"] = true,
        ["B'naar Console Transcription"] = true,
        ["Back to Billy"] = true,
        ["Back to Booty Bay"] = true,
        ["Back to Darnassus"] = true,
        ["Back to Thunder Bluff"] = true,
        ["Back to Uldaman"] = true,
        ["Back to the Beginning"] = true,
        ["Back to the Chief!"] = true,
        ["Bad Medicine"] = true,
        ["Badlands Reagent Run"] = true,
        ["Badlands Reagent Run II"] = true,
        ["Bailor's Ore Shipment"] = true,
        ["Balance Must Be Preserved"] = true,
        ["Band of Unending Life"] = true,
        ["Band of Vaulted Secrets"] = true,
        ["Band of Veiled Shadows"] = true,
        ["Bandits!"] = true,
        ["Bane of the Illidari"] = true,
        ["Barbaric Battlements"] = true,
        ["Barbecued Buzzard Wings"] = true,
        ["Baron Aquanis"] = true,
        ["Baron Sablemane"] = true,
        ["Baron Sablemane Has Requested Your Presence"] = true,
        ["Baron Sablemane's Poison"] = true,
        ["Baron's Demise"] = true,
        ["Barov Family Fortune"] = true,
        ["Bartleby the Drunk"] = true,
        ["Bartleby's Mug"] = true,
        ["Bartolo's Yeti Fur Cloak"] = true,
        ["Bashal'Aran"] = true,
        ["Bathran's Hair"] = true,
        ["Battle of Hillsbrad"] = true,
        ["Battle of Warsong Gulch"] = true,
        ["Battle of the Crimson Watch"] = true,
        ["Battle-Mage Dathric"] = true,
        ["Beached Sea Creature"] = true,
        ["Beached Sea Turtle"] = true,
        ["Beads for Salfa"] = true,
        ["Bearers of the Plague"] = true,
        ["Beast Training"] = true,
        ["Beasts of the Apocalypse!"] = true,
        ["Beat Bartleby"] = true,
        ["Because Kilrath is a Coward"] = true,
        ["Becoming a Mooncloth Tailor"] = true,
        ["Becoming a Parent"] = true,
        ["Becoming a Shadoweave Tailor"] = true,
        ["Becoming a Spellfire Tailor"] = true,
        ["Beer Basted Boar Ribs"] = true,
        ["Before Darkness Falls"] = true,
        ["Befouled by Satyr"] = true,
        ["Begin the Attack!"] = true,
        ["Beginnings"] = true,
        ["Behind Enemy Lines"] = true,
        ["Behomat"] = true,
        ["Bell of Dethmoora"] = true,
        ["Belt of Faith"] = true,
        ["Beneath Thrallmar"] = true,
        ["Beren's Peril"] = true,
        ["Besieged!"] = true,
        ["Betina Bigglezink"] = true,
        ["Betrayal from Within"] = true,
        ["Betrayed"] = true,
        ["Better Late Than Never"] = true,
        ["Between a Rock and a Thistlefur"] = true,
        ["Beware of Pterrordax"] = true,
        ["Big Black Mace"] = true,
        ["Big Game Hunter"] = true,
        ["Bijou's Belongings"] = true,
        ["Bijou's Reconnaissance Report"] = true,
        ["Binding the Dreadnaught"] = true,
        ["Bindings of Faith"] = true,
        ["Bingles' Missing Supplies"] = true,
        ["Birds of a Feather"] = true,
        ["Bitter Rivals"] = true,
        ["Blackfathom Villainy"] = true,
        ["Blackhand's Command"] = true,
        ["Blackmoore's Legacy"] = true,
        ["Blackrock Bounty"] = true,
        ["Blackrock Menace"] = true,
        ["Blacksting's Bane"] = true,
        ["Blade of Eternal Justice"] = true,
        ["Blade of Vaulted Secrets"] = true,
        ["Bladespire Kegger"] = true,
        ["Blast the Infernals!"] = true,
        ["Bleeding Hollow Supply Crates"] = true,
        ["Blessed Arcanite Barding"] = true,
        ["Blessed Arm"] = true,
        ["Blessing of Incineratus"] = true,
        ["Blessings of the Ancients"] = true,
        ["Blind Cazul"] = true,
        ["Blisters on The Land"] = true,
        ["Blood Crystals"] = true,
        ["Blood Elf Plans"] = true,
        ["Blood Elf Spy"] = true,
        ["Blood Feeders"] = true,
        ["Blood Shards of Agamaggan"] = true,
        ["Blood Tinged Skies"] = true,
        ["Blood Watch"] = true,
        ["Blood of the Black Dragon Champion"] = true,
        ["Bloodfury Bloodline"] = true,
        ["Bloodgem Crystals"] = true,
        ["Bloodpetal Poison"] = true,
        ["Bloodpetal Sprouts"] = true,
        ["Bloodpetal Zapper"] = true,
        ["Bloodscalp Clan Heads"] = true,
        ["Bloodscalp Ears"] = true,
        ["Bloodscalp Insight"] = true,
        ["Bloody Bone Necklaces"] = true,
        ["Bloody Imp-ossible!"] = true,
        ["Blueleaf Tubers"] = true,
        ["Boat Wreckage"] = true,
        ["Bodley's Unfortunate Fate"] = true,
        ["Body and Heart"] = true,
        ["Body of Evidence"] = true,
        ["Bodyguard for Hire"] = true,
        ["Boiling Blood"] = true,
        ["Bolstering Our Defenses"] = true,
        ["Bone Collector"] = true,
        ["Bone Fragments"] = true,
        ["Bone-Bladed Weapons"] = true,
        ["Bonechewer Blood"] = true,
        ["Bonescythe Bracers"] = true,
        ["Bonescythe Breastplate"] = true,
        ["Bonescythe Digs"] = true,
        ["Bonescythe Gauntlets"] = true,
        ["Bonescythe Helmet"] = true,
        ["Bonescythe Legplates"] = true,
        ["Bonescythe Pauldrons"] = true,
        ["Bonescythe Sabatons"] = true,
        ["Bonescythe Waistguard"] = true,
        ["Book of the Ancients"] = true,
        ["Bookie Herod"] = true,
        ["Booty Bay or Bust!"] = true,
        ["Bor Wishes to Speak"] = true,
        ["Border Crossings"] = true,
        ["Botanical Legwork"] = true,
        ["Botanist Taerix"] = true,
        ["Boulderslide Ravine"] = true,
        ["Bound for Glory"] = true,
        ["Bounty on Garrick Padfoot"] = true,
        ["Bounty on Murlocs"] = true,
        ["Bracers of Binding"] = true,
        ["Brann Bronzebeard's Lost Letter"] = true,
        ["Breaching the Path"] = true,
        ["Break Sharptusk!"] = true,
        ["Break a Few Eggs"] = true,
        ["Breaking Down Netherock"] = true,
        ["Breaking the Code"] = true,
        ["Breaking the Keystone"] = true,
        ["Breaking the Ward"] = true,
        ["Breastplate of Bloodthirst"] = true,
        ["Breastplate of the Chromatic Flight"] = true,
        ["Bride of the Embalmer"] = true,
        ["Bring Back the Mug"] = true,
        ["Bring Down the Warbringer!"] = true,
        ["Bring Me A Shrubbery!"] = true,
        ["Bring Me Another Shrubbery!"] = true,
        ["Bring Me Kel'gash's Head!"] = true,
        ["Bring Me The Egg!"] = true,
        ["Bring the End"] = true,
        ["Bring the Light"] = true,
        ["Broken Alliances"] = true,
        ["Broken Tears"] = true,
        ["Broodling Essence"] = true,
        ["Brother Against Brother"] = true,
        ["Brother Anton"] = true,
        ["Brother Carlin"] = true,
        ["Brother Paxton"] = true,
        ["Brotherhood of Thieves"] = true,
        ["Brotherhood's End"] = true,
        ["Brotherly Love"] = true,
        ["Brumeran of the Chillwind"] = true,
        ["Brutal Armor"] = true,
        ["Brutal Gauntlets"] = true,
        ["Brutal Hauberk"] = true,
        ["Brutal Helm"] = true,
        ["Brutal Legguards"] = true,
        ["Brutal Politics"] = true,
        ["Building a Perimeter"] = true,
        ["Bungle in the Jungle"] = true,
        ["Burn It Up... For the Horde!"] = true,
        ["Burning Blade Medallion"] = true,
        ["Burning Blood"] = true,
        ["Burning Shadows"] = true,
        ["Buying Time"] = true,
        ["Buzzbox 323"] = true,
        ["Buzzbox 411"] = true,
        ["Buzzbox 525"] = true,
        ["Buzzbox 827"] = true,
        ["By Any Means Necessary"] = true,
        ["C'Thun's Legacy"] = true,
        ["CLUCK!"] = true,
        ["Cabal Orders"] = true,
        ["Cache of Mau'ari"] = true,
        ["Call of Air"] = true,
        ["Call of Air - Guse's Fleet"] = true,
        ["Call of Air - Ichman's Fleet"] = true,
        ["Call of Air - Jeztor's Fleet"] = true,
        ["Call of Air - Mulverick's Fleet"] = true,
        ["Call of Air - Slidore's Fleet"] = true,
        ["Call of Air - Vipore's Fleet"] = true,
        ["Call of Earth"] = true,
        ["Call of Fire"] = true,
        ["Call of Water"] = true,
        ["Call to Arms"] = true,
        ["Calling in the Reserves"] = true,
        ["Calm Before the Storm"] = true,
        ["Camp Mojache"] = true,
        ["Can't Stay Away"] = true,
        ["Candles of Beckoning"] = true,
        ["Cannibalistic Cousins"] = true,
        ["Cannons of Rage"] = true,
        ["Cape of Eternal Justice"] = true,
        ["Captain Kelisendra's Lost Rutters"] = true,
        ["Captain Sander's Hidden Treasure"] = true,
        ["Captain Tyralius"] = true,
        ["Captain Vimes"] = true,
        ["Captives at Deatholme"] = true,
        ["Capture a Mine"] = true,
        ["Capture the Weapons"] = true,
        ["Capturing the Keystone"] = true,
        ["Capturing the Phylactery"] = true,
        ["Carendin Summons"] = true,
        ["Carnival Boots"] = true,
        ["Carnival Jerkins"] = true,
        ["Carrion Grubbage"] = true,
        ["Carry Your Weight"] = true,
        ["Castpipe's Task"] = true,
        ["Catalogue of the Wayward"] = true,
        ["Catch and Release"] = true,
        ["Catch of the Day"] = true,
        ["Caught!"] = true,
        ["Cave Mushrooms"] = true,
        ["Celebrating Good Times"] = true,
        ["Celestial Power"] = true,
        ["Cenarion Aid"] = true,
        ["Cenarion Battlegear"] = true,
        ["Cenarius' Legacy"] = true,
        ["Centaur Bounty"] = true,
        ["Centaur Bracers"] = true,
        ["Challenge Overlord Mok'Morokk"] = true,
        ["Champion's Battlegear"] = true,
        ["Chapter I"] = true,
        ["Chapter II"] = true,
        ["Chapter III"] = true,
        ["Chapter IV"] = true,
        ["Chasing A-Me 01"] = true,
        ["Chen's Empty Keg"] = true,
        ["Chicken Clucking for a Mint"] = true,
        ["Chief Engineer Scooty"] = true,
        ["Chieftain Oomooroo"] = true,
        ["Children's Week"] = true,
        ["Chillwind Horns"] = true,
        ["Chimaeric Horn"] = true,
        ["Cho'war the Pillager"] = true,
        ["Chromatic Mantle of the Dawn"] = true,
        ["Circlet of Faith"] = true,
        ["City of Light"] = true,
        ["Claim Rackmore's Treasure!"] = true,
        ["Claiming the Light"] = true,
        ["Clam Bait"] = true,
        ["Clamlette Surprise"] = true,
        ["Claws from the Deep"] = true,
        ["Cleaning up the Grounds"] = true,
        ["Cleansed Water Returns to Felwood"] = true,
        ["Cleansing Felwood"] = true,
        ["Cleansing of the Infected"] = true,
        ["Cleansing of the Orb of Orahil"] = true,
        ["Cleansing the Eye"] = true,
        ["Cleansing the Scar"] = true,
        ["Cleansing the Waters"] = true,
        ["Clearing the Way"] = true,
        ["Clefthoof Mastery"] = true,
        ["Cloak of Unending Life"] = true,
        ["Cloak of Veiled Shadows"] = true,
        ["Cloak of the Gathering Storm"] = true,
        ["Cloak of the Unseen Path"] = true,
        ["Cloth and Leather Armor"] = true,
        ["Clues in the Thicket"] = true,
        ["Coarse Weightstone"] = true,
        ["Codex of Defense"] = true,
        ["Cohlien Frostweaver"] = true,
        ["Coilfang Armaments"] = true,
        ["Coldridge Valley Mail Delivery"] = true,
        ["Coldtooth Supplies"] = true,
        ["Collecting Kelp"] = true,
        ["Collecting Memories"] = true,
        ["Collection of Goods"] = true,
        ["Collection of the Corrupt Water"] = true,
        ["Colonel Kurzen"] = true,
        ["Colossal Menace"] = true,
        ["Combining Forces"] = true,
        ["Coming of Age"] = true,
        ["Commander Gor'shak"] = true,
        ["Compendium of the Fallen"] = true,
        ["Completing the Delivery"] = true,
        ["Components for the Enchanted Gold Bloodrobe"] = true,
        ["Components of Importance"] = true,
        ["Concerns About Tuurem"] = true,
        ["Concerted Efforts"] = true,
        ["Confront Yeh'kinya"] = true,
        ["Conjurer Luminrath"] = true,
        ["Conqueror's Breastplate"] = true,
        ["Conqueror's Crown"] = true,
        ["Conqueror's Greaves"] = true,
        ["Conqueror's Legguards"] = true,
        ["Conqueror's Spaulders"] = true,
        ["Conscript of the Horde"] = true,
        ["Consecrated Letter"] = true,
        ["Consecrated Rune"] = true,
        ["Consortium Crystal Collection"] = true,
        ["Constrictor Vines"] = true,
        ["Consult Master Gadrin"] = true,
        ["Consumed by Hatred"] = true,
        ["Contact from Dalaran"] = true,
        ["Containing the Threat"] = true,
        ["Continue to Stormwind"] = true,
        ["Continued Threat"] = true,
        ["Control"] = true,
        ["Control Four Bases"] = true,
        ["Cookie's Jumbo Gumbo"] = true,
        ["Coolant Heads Prevail"] = true,
        ["Copper Modulator"] = true,
        ["Core of Elements"] = true,
        ["Corki's Gone Missing Again!"] = true,
        ["Corki's Ransom"] = true,
        ["Corrupted Soil"] = true,
        ["Corruption"] = true,
        ["Corruption of Earth and Seed"] = true,
        ["Cortello's Riddle"] = true,
        ["Costly Menace"] = true,
        ["Counterattack!"] = true,
        ["Counting Out Time"] = true,
        ["Courser Antlers"] = true,
        ["Covert Ops - Alpha"] = true,
        ["Covert Ops - Beta"] = true,
        ["Coyote Thieves"] = true,
        ["Crackin' Some Skulls"] = true,
        ["Cracking Maury's Foot"] = true,
        ["Craftsman's Writ - Brightcloth Pants"] = true,
        ["Craftsman's Writ - Dense Weightstone"] = true,
        ["Craftsman's Writ - Goblin Sapper Charge"] = true,
        ["Craftsman's Writ - Greater Arcane Protection Potion"] = true,
        ["Craftsman's Writ - Huge Thorium Battleaxe"] = true,
        ["Craftsman's Writ - Major Healing Potion"] = true,
        ["Craftsman's Writ - Major Mana Potion"] = true,
        ["Craftsman's Writ - Plated Armorfish"] = true,
        ["Craftsman's Writ - Runecloth Bag"] = true,
        ["Craftsman's Writ - Runecloth Boots"] = true,
        ["Craftsman's Writ - Runecloth Robe"] = true,
        ["Craftsman's Writ - Runic Leather Pants"] = true,
        ["Craftsman's Writ - Stonescale Eel"] = true,
        ["Craftsman's Writ - Thorium Grenade"] = true,
        ["Craftsman's Writ - Thorium Tube"] = true,
        ["Craftsman's Writ - Wicked Leather Headband"] = true,
        ["Crashing the Wickerman Festival"] = true,
        ["Creating the Pendant"] = true,
        ["Creature of the Void"] = true,
        ["Creatures of the Eco-Domes"] = true,
        ["Crime and Punishment"] = true,
        ["Crimson Crystal Clue"] = true,
        ["Crimson Templar"] = true,
        ["Critters of the Void"] = true,
        ["Crocolisk Boy and the Bearded Murloc"] = true,
        ["Crocolisk Hunting"] = true,
        ["Crossroads Conscription"] = true,
        ["Crown of the Earth"] = true,
        ["Cruel Taskmasters"] = true,
        ["Cruel's Intentions"] = true,
        ["Cruelfin's Necklace"] = true,
        ["Crush the Bloodmaul Camp"] = true,
        ["Crush the Bloodmaul Camp!"] = true,
        ["Crushridge Bounty"] = true,
        ["Crushridge Warmongers"] = true,
        ["Cry of the Thunderhawk"] = true,
        ["Crypt Fiend Parts"] = true,
        ["Cryptstalker Armor Doesn't Make Itself..."] = true,
        ["Cryptstalker Boots"] = true,
        ["Cryptstalker Girdle"] = true,
        ["Cryptstalker Handguards"] = true,
        ["Cryptstalker Headpiece"] = true,
        ["Cryptstalker Tunic"] = true,
        ["Cryptstalker Wristguards"] = true,
        ["Crystal Charge"] = true,
        ["Crystal Clear"] = true,
        ["Crystal Cluster"] = true,
        ["Crystal Force"] = true,
        ["Crystal Restore"] = true,
        ["Crystal Spire"] = true,
        ["Crystal Ward"] = true,
        ["Crystal Yield"] = true,
        ["Crystals of Power"] = true,
        ["Cuergo's Gold"] = true,
        ["Culinary Crunch"] = true,
        ["Culling the Flutterers"] = true,
        ["Culling the Threat"] = true,
        ["Culling the Wild"] = true,
        ["Curbing the Plague"] = true,
        ["Curing the Sick"] = true,
        ["Curse These Fat Fingers"] = true,
        ["Curse of the Violet Tower"] = true,
        ["Cursed Talismans"] = true,
        ["Cutting Teeth"] = true,
        ["Cutting Your Teeth"] = true,
        ["Cutting a Path"] = true,
        ["Cycle of Rebirth"] = true,
        ["Cyclonian"] = true,
        ["Da Voodoo"] = true,
        ["Dadanga is Hungry!"] = true,
        ["Daelin's Men"] = true,
        ["Dagger of Veiled Shadows"] = true,
        ["Daggerfen Deviance"] = true,
        ["Daily Delivery"] = true,
        ["Dalar's Analysis"] = true,
        ["Dalaran Patrols"] = true,
        ["Dalaran's Intentions"] = true,
        ["Dalson's Tears Cauldron"] = true,
        ["Damaged Mask"] = true,
        ["Damning Evidence"] = true,
        ["Dancing for Marzipan"] = true,
        ["Dangerous!"] = true,
        ["Dangers of the Windfury"] = true,
        ["Dar'Khan's Lieutenants"] = true,
        ["Dark Council"] = true,
        ["Dark Heart"] = true,
        ["Dark Iron Legacy"] = true,
        ["Dark Iron Scraps"] = true,
        ["Dark Storms"] = true,
        ["Dark Tidings"] = true,
        ["Dark Vessels"] = true,
        ["Darkmoon Beast Deck"] = true,
        ["Darkmoon Elementals Deck"] = true,
        ["Darkmoon Portals Deck"] = true,
        ["Darkmoon Warlords Deck"] = true,
        ["Darnassian Intrusions"] = true,
        ["Data Rescue"] = true,
        ["Dawn's Gambit"] = true,
        ["Deactivate An'owyn"] = true,
        ["Deactivating the Spire"] = true,
        ["Dead Man's Plea"] = true,
        ["Dead-tooth Jack"] = true,
        ["Deadly Desert Venom"] = true,
        ["Deadly Predators"] = true,
        ["Deadmire"] = true,
        ["Deadwood of the North"] = true,
        ["Deal With the Saboteurs"] = true,
        ["Dealing with Zeb'Sora"] = true,
        ["Dealing with the Foreman"] = true,
        ["Dealing with the Overmaster"] = true,
        ["Dearest Natalia"] = true,
        ["Death From Below"] = true,
        ["Death's Door"] = true,
        ["Death's Embrace"] = true,
        ["Deathdealer's Boots"] = true,
        ["Deathdealer's Helm"] = true,
        ["Deathdealer's Vest"] = true,
        ["Deaths in the Family"] = true,
        ["Deathstalkers in Shadowfang"] = true,
        ["Deceive thy Enemy"] = true,
        ["Decipher the Tome"] = true,
        ["Deciphering the Book"] = true,
        ["Declaration of Power"] = true,
        ["Decoy!"] = true,
        ["Deep Cover"] = true,
        ["Deep Sea Salvage"] = true,
        ["Deepmoss Spider Eggs"] = true,
        ["Deeprun Rat Roundup"] = true,
        ["Defeat Nek'rosh"] = true,
        ["Defenders of Darrowshire"] = true,
        ["Defending Fairbreeze Village"] = true,
        ["Defiler's Basic Care Package"] = true,
        ["Defiler's Standard Care Package"] = true,
        ["Defiling Uther's Tomb"] = true,
        ["Deliver Them From Evil..."] = true,
        ["Deliver Thomas' Report"] = true,
        ["Deliver the Gems"] = true,
        ["Deliver the Plans to An'telas"] = true,
        ["Deliver the Shipment"] = true,
        ["Deliver the Thread"] = true,
        ["Deliver to MacKinley"] = true,
        ["Deliveries to Sven"] = true,
        ["Delivering Daffodils"] = true,
        ["Delivering the Message"] = true,
        ["Delivering the Relic"] = true,
        ["Delivery for Marin"] = true,
        ["Delivery to Andron Gant"] = true,
        ["Delivery to Archmage Xylem"] = true,
        ["Delivery to Jes'rimon"] = true,
        ["Delivery to Magatha"] = true,
        ["Delivery to Ridgewell"] = true,
        ["Delivery to Silverpine Forest"] = true,
        ["Delivery to Tranquillien"] = true,
        ["Delivery to the Gnomes"] = true,
        ["Delivery to the North Sanctum"] = true,
        ["Delivery to the Sepulcher"] = true,
        ["Demon Dogs"] = true,
        ["Demonic Contamination"] = true,
        ["Demonic Crystal Prisons"] = true,
        ["Desert Recipe"] = true,
        ["Desperate Prayer"] = true,
        ["Destiny Calls"] = true,
        ["Destroy Morphaz"] = true,
        ["Destroy Naberius!"] = true,
        ["Destroy the Legion"] = true,
        ["Deviate Eradication"] = true,
        ["Deviate Hides"] = true,
        ["Devils in Westfall"] = true,
        ["Devourer of Souls"] = true,
        ["Devouring Plague"] = true,
        ["Diabolical Plans"] = true,
        ["Diagnosis: Critical"] = true,
        ["Diaphanous Wings"] = true,
        ["Did You Get The Note?"] = true,
        ["Did You Lose This?"] = true,
        ["Dig Rat Stew"] = true,
        ["Digging Through Bones"] = true,
        ["Digging Through the Dirt"] = true,
        ["Digging Through the Ooze"] = true,
        ["Digging for Prayer Beads"] = true,
        ["Dimensius the All-Devouring"] = true,
        ["Diplomatic Measures"] = true,
        ["Dirge's Kickin' Chimaerok Chops"] = true,
        ["Discover Rolf's Fate"] = true,
        ["Disharmony of Fire"] = true,
        ["Disharmony of Flame"] = true,
        ["Dispelling Evil"] = true,
        ["Disrupt Their Reinforcements"] = true,
        ["Disrupt the Attacks"] = true,
        ["Disruption - Forge Camp: Mageddon"] = true,
        ["Distracting Jarven"] = true,
        ["Distraction at Manaforge B'naar"] = true,
        ["Disturbance at Umbrafen Lake"] = true,
        ["Divination: Gorefiend's Armor"] = true,
        ["Divination: Gorefiend's Cloak"] = true,
        ["Divination: Gorefiend's Truncheon"] = true,
        ["Divine Retribution"] = true,
        ["Divino-matic Rod"] = true,
        ["Do My Eyes Deceive Me"] = true,
        ["Dogran's Captivity"] = true,
        ["Dolanaar Delivery"] = true,
        ["Doling Justice"] = true,
        ["Don't Drink the Water"] = true,
        ["Don't Kill the Fat One"] = true,
        ["Doom Weed"] = true,
        ["Doomcaller's Circlet"] = true,
        ["Doomcaller's Footwraps"] = true,
        ["Doomcaller's Mantle"] = true,
        ["Doomrigger's Clasp"] = true,
        ["Doomsday Candle"] = true,
        ["Doorway to the Abyss"] = true,
        ["Doras the Wind Rider Master"] = true,
        ["Dousing the Flames of Protection"] = true,
        ["Down With Daellis"] = true,
        ["Down at the Docks"] = true,
        ["Down the Coast"] = true,
        ["Down the Dead Scar"] = true,
        ["Down the Scarlet Path"] = true,
        ["Dr. Boom!"] = true,
        ["Draconic for Dummies"] = true,
        ["Draenethyst Crystals"] = true,
        ["Dragonkin Menace"] = true,
        ["Dragonmaw Shinbones"] = true,
        ["Dragonscale Leatherworking"] = true,
        ["Drain Schematics"] = true,
        ["Drakefire Amulet"] = true,
        ["Drape of Unyielding Strength"] = true,
        ["Drape of Vaulted Secrets"] = true,
        ["Dreadmaul Rock"] = true,
        ["Dreadnaught Bracers"] = true,
        ["Dreadnaught Breastplate"] = true,
        ["Dreadnaught Gauntlets"] = true,
        ["Dreadnaught Helmet"] = true,
        ["Dreadnaught Legplates"] = true,
        ["Dreadnaught Pauldrons"] = true,
        ["Dreadnaught Sabatons"] = true,
        ["Dreadnaught Waistguard"] = true,
        ["Dreadsteed of Xoroth"] = true,
        ["Dream Dust in the Swamp"] = true,
        ["Dreamwalker Boots"] = true,
        ["Dreamwalker Girdle"] = true,
        ["Dreamwalker Handguards"] = true,
        ["Dreamwalker Headpiece"] = true,
        ["Dreamwalker Legguards"] = true,
        ["Dreamwalker Spaulders"] = true,
        ["Dreamwalker Tunic"] = true,
        ["Dreamwalker Wristguards"] = true,
        ["Dressing the Part"] = true,
        ["Driftwood"] = true,
        ["Drijya Needs Your Help"] = true,
        ["Drill the Drillmaster"] = true,
        ["Drowned Sorrows"] = true,
        ["Druid of the Claw"] = true,
        ["Dry Times"] = true,
        ["Duke Nicholas Zverenhoff"] = true,
        ["Dumphry's Request"] = true,
        ["Dungar Longdrink"] = true,
        ["Dusky Crab Cakes"] = true,
        ["Dust from the Drakes"] = true,
        ["Dwarven Digging"] = true,
        ["Dwarven Justice"] = true,
        ["Dwarven Outfitters"] = true,
        ["Eagan Peltskinner"] = true,
        ["Earthen Arise"] = true,
        ["Earthen Templar"] = true,
        ["Earthshatter Boots"] = true,
        ["Easy Strider Living"] = true,
        ["Eating Damnation"] = true,
        ["Echeyakee"] = true,
        ["Echoes of War"] = true,
        ["Egg Collection"] = true,
        ["Egg Freezing"] = true,
        ["Egg Hunt"] = true,
        ["Eight-Legged Menaces"] = true,
        ["Eitrigg's Wisdom"] = true,
        ["Elanaria"] = true,
        ["Electro-Shock Goodness!"] = true,
        ["Electropellers"] = true,
        ["Elekks Are Serious Business"] = true,
        ["Elemental Bracers"] = true,
        ["Elemental Leatherworking"] = true,
        ["Elemental Power Extraction"] = true,
        ["Elemental War"] = true,
        ["Elixir of Agony"] = true,
        ["Elixir of Pain"] = true,
        ["Elixir of Suffering"] = true,
        ["Elixirs for the Bladeleafs"] = true,
        ["Elmore's Task"] = true,
        ["Elune's Tear"] = true,
        ["Elven Legends"] = true,
        ["Emberstrife"] = true,
        ["Emphasis on Sacrifice"] = true,
        ["Empty Stables"] = true,
        ["En-Ay-Es-Tee-Why"] = true,
        ["Enchanted Azsharite Fel Weaponry"] = true,
        ["Enchanted Thorium Platemail: Volume I"] = true,
        ["Enchanted Thorium Platemail: Volume II"] = true,
        ["Enchanted Thorium Platemail: Volume III"] = true,
        ["Encoded Fragments"] = true,
        ["Encroaching Gnolls"] = true,
        ["Encroaching Wildlife"] = true,
        ["Encroachment"] = true,
        ["Encrusted Tail Fins"] = true,
        ["Encrypted Letter"] = true,
        ["Encrypted Memorandum"] = true,
        ["Encrypted Parchment"] = true,
        ["Encrypted Rune"] = true,
        ["Encrypted Scroll"] = true,
        ["Encrypted Sigil"] = true,
        ["Encrypted Tablet"] = true,
        ["Encrypted Twilight Texts"] = true,
        ["Ending Their World"] = true,
        ["Ending the Bloodcurse"] = true,
        ["Enemy Booty"] = true,
        ["Enemy of my Enemy..."] = true,
        ["Enigma Boots"] = true,
        ["Enigma Circlet"] = true,
        ["Enigma Shoulderpads"] = true,
        ["Enraged Spirits"] = true,
        ["Enraged Spirits of Air"] = true,
        ["Enraged Spirits of Fire and Earth"] = true,
        ["Enraged Spirits of Water"] = true,
        ["Enraged Thunder Lizards"] = true,
        ["Enraged Wildkin"] = true,
        ["Enticing Negolash"] = true,
        ["Entry Into Karazhan"] = true,
        ["Entry Into the Citadel"] = true,
        ["Envoy to the Mag'har"] = true,
        ["Epic Armaments of Battle - Exalted Amongst the Dawn"] = true,
        ["Eradicate the Burning Legion"] = true,
        ["Erion Shadewhisper"] = true,
        ["Erion's Behest"] = true,
        ["Errand for Apothecary Zinge"] = true,
        ["Escape Through Force"] = true,
        ["Escape Through Stealth"] = true,
        ["Escape from Durnholde"] = true,
        ["Escape from Firewing Point!"] = true,
        ["Escape from Umbrafen"] = true,
        ["Escape from the Catacombs"] = true,
        ["Escape from the Staging Grounds"] = true,
        ["Escaping the Tomb"] = true,
        ["Escorting Erland"] = true,
        ["Essence for the Engines"] = true,
        ["Essence of the Exile"] = true,
        ["Essential Artificials"] = true,
        ["Establishing New Outposts"] = true,
        ["Etched Note"] = true,
        ["Etched Parchment"] = true,
        ["Etched Rune"] = true,
        ["Etched Sigil"] = true,
        ["Etched Tablet"] = true,
        ["Ethereum Data"] = true,
        ["Evershine"] = true,
        ["Everything Counts In Large Amounts"] = true,
        ["Everything Will Be Alright"] = true,
        ["Evil Bat Eyes"] = true,
        ["Evil Draws Near"] = true,
        ["Examine the Vessel"] = true,
        ["Excavation Progress Report"] = true,
        ["Excelsior"] = true,
        ["Exorcising Terrordale"] = true,
        ["Exorcising the Trees"] = true,
        ["Expedition Point"] = true,
        ["Expedition Salvation"] = true,
        ["Expert Blacksmith!"] = true,
        ["Extinguish the Firegut"] = true,
        ["Extinguishing the Idol"] = true,
        ["Eye of the Emberseer"] = true,
        ["Ezekiel"] = true,
        ["FIFTY! YEP!"] = true,
        ["Faerie Dragon Muisek"] = true,
        ["Failed Incursion"] = true,
        ["Fairbreeze Village"] = true,
        ["Falcon Watch"] = true,
        ["Falcon's Call"] = true,
        ["Fall From Grace"] = true,
        ["Fall of Dun Modr"] = true,
        ["Fallen Sky Lake"] = true,
        ["Fallen Sky Lords"] = true,
        ["Falling to Corruption"] = true,
        ["Falrin's Vendetta"] = true,
        ["Familiar Fungi"] = true,
        ["Family Tree"] = true,
        ["Farren's Proof"] = true,
        ["Farstrider Retreat"] = true,
        ["Favor of the Gronn"] = true,
        ["Favored of Elune?"] = true,
        ["Feast at the Blue Recluse"] = true,
        ["Featherbeard's Endorsement"] = true,
        ["Feathermoon Stronghold"] = true,
        ["Feathers for Grazle"] = true,
        ["Feathers for Nafien"] = true,
        ["Fei Fei's Treat"] = true,
        ["Fel Armaments"] = true,
        ["Fel Embers"] = true,
        ["Fel Orc Plans"] = true,
        ["Fel Orc Scavengers"] = true,
        ["Fel Spirits"] = true,
        ["Felbound Ancients"] = true,
        ["Felendren the Banished"] = true,
        ["Felling an Ancient Tree"] = true,
        ["Felnok Steelspring"] = true,
        ["Felspark Ravine"] = true,
        ["Felstone Field Cauldron"] = true,
        ["Felsworn Gas Mask"] = true,
        ["Fenwick Thatros"] = true,
        ["Feralas: A History"] = true,
        ["Ferocitas the Dream Eater"] = true,
        ["Fertile Spores"] = true,
        ["Fetch!"] = true,
        ["Field Duty"] = true,
        ["Fields of Grief"] = true,
        ["Fierce Enemies"] = true,
        ["Fiery Blaze Enchantments"] = true,
        ["Fiery Menace!"] = true,
        ["Fiery Plate Gauntlets"] = true,
        ["Filling the Soul Gem"] = true,
        ["Filthy Paws"] = true,
        ["Final Passage"] = true,
        ["Final Preparations"] = true,
        ["Find Acteon!"] = true,
        ["Find Agmond"] = true,
        ["Find Bingles"] = true,
        ["Find Keltus Darkleaf"] = true,
        ["Find Myranda"] = true,
        ["Find OOX-09/HL!"] = true,
        ["Find OOX-17/TN!"] = true,
        ["Find OOX-22/FE!"] = true,
        ["Find Ranshalla"] = true,
        ["Find Spy To'gun"] = true,
        ["Find the Deserter"] = true,
        ["Find the Gems"] = true,
        ["Find the Gems and Power Source"] = true,
        ["Find the Lost Guards"] = true,
        ["Find the Shattered Hand"] = true,
        ["Finding the Antidote"] = true,
        ["Finding the Keymaster"] = true,
        ["Finding the Shadowy Figure"] = true,
        ["Finding the Source"] = true,
        ["Finding the Survivors"] = true,
        ["Fine Gold Thread"] = true,
        ["Fiora Longears"] = true,
        ["Fire At Will!"] = true,
        ["Fire Hardened Mail"] = true,
        ["Fire Plume Forged"] = true,
        ["Fire Sapta"] = true,
        ["Fire Taboo"] = true,
        ["Firewing Signets"] = true,
        ["Fish in a Bucket"] = true,
        ["Flash Bomb Recipe"] = true,
        ["Flawed Power Stone"] = true,
        ["Flawless Fel Essence"] = true,
        ["Flexing for Nougat"] = true,
        ["Flight to Auberdine"] = true,
        ["Flint Shadowmore"] = true,
        ["Flora of the Eco-Domes"] = true,
        ["Flute of Xavaric"] = true,
        ["Fly to Silvermoon City"] = true,
        ["Follow the Breadcrumbs"] = true,
        ["Food for Baby"] = true,
        ["Footwraps of the Oracle"] = true,
        ["For All To See"] = true,
        ["For Great Honor"] = true,
        ["For Love Eternal"] = true,
        ["For The Horde!"] = true,
        ["For the Fallen"] = true,
        ["Forbidden Knowledge"] = true,
        ["Force Commander Danath"] = true,
        ["Forces of Jaedenar"] = true,
        ["Foreboding Plans"] = true,
        ["Forge Camp: Annihilated"] = true,
        ["Forge Camp: Mageddon"] = true,
        ["Forged Steel"] = true,
        ["Forging the Mightstone"] = true,
        ["Forging the Shaft"] = true,
        ["Forging the Weapon"] = true,
        ["Forgotten Rituals"] = true,
        ["Formal Introductions"] = true,
        ["Foror's Compendium"] = true,
        ["Forsaken Aid"] = true,
        ["Forsaken Diseases"] = true,
        ["Forsaken Duties"] = true,
        ["Forward Base: Reaver's Fall"] = true,
        ["Foul Magics"] = true,
        ["Fouled Water Spirits"] = true,
        ["Fragmented Magic"] = true,
        ["Fragments of the Orb of Orahil"] = true,
        ["Fragments of the Past"] = true,
        ["Frame of Atiesh"] = true,
        ["Free From the Hold"] = true,
        ["Free at Last"] = true,
        ["Freed from the Hive"] = true,
        ["Freedom for All Creatures"] = true,
        ["Freedom to Ruul"] = true,
        ["Fresh Meat"] = true,
        ["Fresh from the Mechanar"] = true,
        ["From The Wreckage...."] = true,
        ["From the Abyss"] = true,
        ["From the Ashes"] = true,
        ["Frostfire Belt"] = true,
        ["Frostfire Bindings"] = true,
        ["Frostfire Circlet"] = true,
        ["Frostfire Gloves"] = true,
        ["Frostfire Leggings"] = true,
        ["Frostfire Robe"] = true,
        ["Frostfire Sandals"] = true,
        ["Frostfire Shoulderpads"] = true,
        ["Frostmane Hold"] = true,
        ["Frostmaul E'ko"] = true,
        ["Frostmaw"] = true,
        ["Frostsaber E'ko"] = true,
        ["Frostsaber Provisions"] = true,
        ["Fruit of the Sea"] = true,
        ["Fuel for the Zapping"] = true,
        ["Fulgor Spores"] = true,
        ["Full Triangle"] = true,
        ["Fumping"] = true,
        ["Fungal Spores"] = true,
        ["Furlbrow's Deed"] = true,
        ["Further Concerns"] = true,
        ["Further Corruption"] = true,
        ["Further Instructions"] = true,
        ["Further Mysteries"] = true,
        ["Gadgetzan Water Survey"] = true,
        ["Gaffer Jacks"] = true,
        ["Gahrron's Withering Cauldron"] = true,
        ["Gahz'ridian"] = true,
        ["Gahz'rilla"] = true,
        ["Gaining Acceptance"] = true,
        ["Gaining Access"] = true,
        ["Gaining Mirren's Trust"] = true,
        ["Gakin's Summons"] = true,
        ["Galaen's Fate"] = true,
        ["Galaen's Journal - The Fate of Vindicator Saruan"] = true,
        ["Galen's Escape"] = true,
        ["Galgar's Cactus Apple Surprise"] = true,
        ["Galvan's Finest Pupil"] = true,
        ["Gan'rul's Summons"] = true,
        ["Gann's Reclamation"] = true,
        ["Garments of Spirituality"] = true,
        ["Garments of the Light"] = true,
        ["Garments of the Moon"] = true,
        ["Garona: A Study on Stealth and Treachery"] = true,
        ["Gateway to the Frontier"] = true,
        ["Gather Rot Blossoms"] = true,
        ["Gather the Orbs"] = true,
        ["Gathering Idols"] = true,
        ["Gathering Leather"] = true,
        ["Gathering Materials"] = true,
        ["Gathering the Cure"] = true,
        ["Gathering the Reagents"] = true,
        ["Gauging the Resonant Frequency"] = true,
        ["Gava'xi"] = true,
        ["Gavel of Infinite Wisdom"] = true,
        ["Gearing Redridge"] = true,
        ["Gelkis Alliance"] = true,
        ["General Drakkisath's Command"] = true,
        ["General Drakkisath's Demise"] = true,
        ["Genesis Boots"] = true,
        ["Genesis Helm"] = true,
        ["Genesis Shoulderpads"] = true,
        ["Genesis Trousers"] = true,
        ["Genesis Vest"] = true,
        ["Gerenzo Wrenchwhistle"] = true,
        ["Gerenzo's Orders"] = true,
        ["Get Me Out of Here!"] = true,
        ["Get the Gnomes Drunk"] = true,
        ["Get the Goblins Drunk"] = true,
        ["Get the Scoop"] = true,
        ["Getting Down to Business"] = true,
        ["Getting the Bladespire Tanked"] = true,
        ["Ghost Hair Thread"] = true,
        ["Ghost-o-plasm Round Up"] = true,
        ["Ghoulish Effigy"] = true,
        ["Give Gerard a Drink"] = true,
        ["Gizelton Caravan"] = true,
        ["Gizmo for Warug"] = true,
        ["Glowcap Mushrooms"] = true,
        ["Glowing Scorpid Blood"] = true,
        ["Glyphed Oaken Branch"] = true,
        ["Glyphic Letter"] = true,
        ["Glyphic Memorandum"] = true,
        ["Glyphic Scroll"] = true,
        ["Glyphic Tablet"] = true,
        ["Gnarlpine Corruption"] = true,
        ["Gnogaine"] = true,
        ["Gnome Engineering"] = true,
        ["Gnome Improvement"] = true,
        ["Gnomer-gooooone!"] = true,
        ["Go to the Front"] = true,
        ["Goblin Invaders"] = true,
        ["Goblin Sponsorship"] = true,
        ["Gol'dir"] = true,
        ["Gold Dust Exchange"] = true,
        ["Goldenmist Village"] = true,
        ["Goldleaf's Discovery"] = true,
        ["Goldtooth"] = true,
        ["Good Luck Charm"] = true,
        ["Good Natured Emma"] = true,
        ["Goods from Silvermoon City"] = true,
        ["Gor'tesh the Brute Lord"] = true,
        ["Gordo's Task"] = true,
        ["Gordunni Cobalt"] = true,
        ["Goretusk Liver Pie"] = true,
        ["Gorgrom the Dragon-Eater"] = true,
        ["Grand Master Dumphry"] = true,
        ["Grand Master Rohok"] = true,
        ["Grape Manifest"] = true,
        ["Grark Lorkrub"] = true,
        ["Graverobbers"] = true,
        ["Greatfather Winter is Here!"] = true,
        ["Greed"] = true,
        ["Green Fireworks"] = true,
        ["Green Iron Bracers"] = true,
        ["Grey Iron Weapons"] = true,
        ["Grillok \"Darkeye\""] = true,
        ["Grim Message"] = true,
        ["Grimand Elmore"] = true,
        ["Grimand's Armor"] = true,
        ["Grimand's Finest Work"] = true,
        ["Grime-Encrusted Ring"] = true,
        ["Grimscale Pirates!"] = true,
        ["Grimtotem Spying"] = true,
        ["Grove of the Ancients"] = true,
        ["Gryphon Master Talonaxe"] = true,
        ["Gryth Thurden"] = true,
        ["Guarded Thunderbrew Barrel"] = true,
        ["Guardians of the Altar"] = true,
        ["Guarding Secrets"] = true,
        ["Guile of the Raptor"] = true,
        ["Gurf's Dignity"] = true,
        ["Gurok the Usurper"] = true,
        ["Gyro... What?"] = true,
        ["Gyrodrillmatic Excavationators"] = true,
        ["Gyromast's Retrieval"] = true,
        ["Gyromast's Revenge"] = true,
        ["HELP!"] = true,
        ["Halgar's Summons"] = true,
        ["Hallow's End Treats for Jesper!"] = true,
        ["Hallow's End Treats for Spoops!"] = true,
        ["Hallowed Letter"] = true,
        ["Hallowed Rune"] = true,
        ["Hallowed Scroll"] = true,
        ["Hallowed Sigil"] = true,
        ["Hallowed Tablet"] = true,
        ["Hameya's Plea"] = true,
        ["Hammerfall"] = true,
        ["Hamuul Runetotem"] = true,
        ["Hand of Iruxos"] = true,
        ["Handle With Care"] = true,
        ["Hands of the Enemy"] = true,
        ["Harbinger of Doom"] = true,
        ["Harbingers of Shadowmoon"] = true,
        ["Hardened Shells"] = true,
        ["Harlan Needs a Resupply"] = true,
        ["Harnessing Shadows"] = true,
        ["Harpies Threaten"] = true,
        ["Harpy Lieutenants"] = true,
        ["Harpy Raiders"] = true,
        ["Harvesting the Fel Ammunition"] = true,
        ["Have You Ever Seen One of These?"] = true,
        ["Haze of Evil"] = true,
        ["He Called Himself Altruis..."] = true,
        ["Healing the Lake"] = true,
        ["Healthy Dragon Scale"] = true,
        ["Heart of Rage"] = true,
        ["Hearts of Zeal"] = true,
        ["Hearts of the Pure"] = true,
        ["Heartswood"] = true,
        ["Heavy Grinding Stone"] = true,
        ["Heirloom Weapon"] = true,
        ["Helcular's Revenge"] = true,
        ["Hellfire Fortifications"] = true,
        ["Help Mama Wheeler"] = true,
        ["Help Ranger Valanna!"] = true,
        ["Help Tavara"] = true,
        ["Help Watcher Biggs"] = true,
        ["Helping the Cenarion Post"] = true,
        ["Helping the Lost Find Their Way"] = true,
        ["Hemet Nesingwary Jr."] = true,
        ["Hero of the Brood"] = true,
        ["Hero of the Mag'har"] = true,
        ["Hero of the Sin'dorei"] = true,
        ["Hero of the Stormpike"] = true,
        ["Heroes of Darrowshire"] = true,
        ["Heroes of Old"] = true,
        ["Hex of Weakness"] = true,
        ["Hezrul Bloodmark"] = true,
        ["Hidden Enemies"] = true,
        ["Hidden Secrets"] = true,
        ["Hidden Treasures"] = true,
        ["High Chief Winterfall"] = true,
        ["High Sorcerer Andromath"] = true,
        ["High Value Targets"] = true,
        ["Highperch Venom"] = true,
        ["Hilary's Necklace"] = true,
        ["Hinott's Assistance"] = true,
        ["Hints of a New Plague?"] = true,
        ["Hints of the Past"] = true,
        ["Hippogryph Master Stephanos"] = true,
        ["Hippogryph Muisek"] = true,
        ["Hitting the Motherlode"] = true,
        ["Hive'Ashi Scout Report"] = true,
        ["Hive'Regal Scout Report"] = true,
        ["Hive'Zora Scout Report"] = true,
        ["Hoary Templar"] = true,
        ["Holy Bologna: What the Light Won't Tell You"] = true,
        ["Homeward Bound"] = true,
        ["Honor Students"] = true,
        ["Honor the Dead"] = true,
        ["Honor the Fallen"] = true,
        ["Honored Amongst the Clan"] = true,
        ["Honored Amongst the Guard"] = true,
        ["Honoring a Hero"] = true,
        ["Hoodoo Hex"] = true,
        ["Horde Presence"] = true,
        ["Horde Trauma"] = true,
        ["Horns of Frenzy"] = true,
        ["Host of the Hidden City"] = true,
        ["Hostile Takeover"] = true,
        ["Hot Fiery Death"] = true,
        ["Hotter than Hell"] = true,
        ["Houses of the Holy"] = true,
        ["How Big a Threat?"] = true,
        ["How to Break Into the Arcatraz"] = true,
        ["Howling in the Hills"] = true,
        ["Humbert's Sword"] = true,
        ["Humble Beginnings"] = true,
        ["Hungry!"] = true,
        ["Hunt for Yenniku"] = true,
        ["Hunt the Savages"] = true,
        ["Hunting for Ectoplasm"] = true,
        ["Hunting in Stranglethorn"] = true,
        ["Hurley Blackbreath"] = true,
        ["Hypercapacitor Gizmo"] = true,
        ["I Got Nothin' Left!"] = true,
        ["I Know A Guy..."] = true,
        ["I Must Have Them!"] = true,
        ["I See Alcaz Island In Your Future..."] = true,
        ["I See Dead Draenei"] = true,
        ["I Shoot Magic Into the Darkness"] = true,
        ["I Was A Lot Of Things..."] = true,
        ["I Work... For the Horde!"] = true,
        ["I'm Saved!"] = true,
        ["I've Got a Plant"] = true,
        ["Ice Thistle E'ko"] = true,
        ["Identify Plant Parts"] = true,
        ["Identifying the Brood"] = true,
        ["Idols of the Feralfen"] = true,
        ["Ignition"] = true,
        ["Ill Omens"] = true,
        ["Illidan's Pupil"] = true,
        ["Illidari-Bane Shard"] = true,
        ["Imbuing the Headpiece"] = true,
        ["Impending Attack"] = true,
        ["Imperial Plate Armor"] = true,
        ["Imperial Plate Belt"] = true,
        ["Imperial Plate Boots"] = true,
        ["Imperial Plate Bracer"] = true,
        ["Imperial Plate Chest"] = true,
        ["Imperial Plate Helm"] = true,
        ["Imperial Plate Leggings"] = true,
        ["Imperial Plate Shoulders"] = true,
        ["Imperial Qiraji Regalia"] = true,
        ["Improved Quality"] = true,
        ["In A Scrap With The Legion"] = true,
        ["In Defense of Frostwolf"] = true,
        ["In Defense of the King's Lands"] = true,
        ["In Dreams"] = true,
        ["In Eranikus' Own Words"] = true,
        ["In Favor of Elune"] = true,
        ["In Favor of Spirituality"] = true,
        ["In Favor of the Light"] = true,
        ["In Good Hands"] = true,
        ["In Good Taste"] = true,
        ["In Need of Felblood"] = true,
        ["In Nightmares"] = true,
        ["In Pursuit of Featherbeard"] = true,
        ["In Search of Anthion"] = true,
        ["In Search of Farahlite"] = true,
        ["In Search of Galvan"] = true,
        ["In Search of Knowledge"] = true,
        ["In Search of Menara Voidrender"] = true,
        ["In Search of Sedai"] = true,
        ["In Search of Thaelrid"] = true,
        ["In Search of The Excavation Team"] = true,
        ["In Search of The Temple"] = true,
        ["In the Name of the Light"] = true,
        ["Incendius!"] = true,
        ["Incendosaurs? Whateverosaur is More Like It"] = true,
        ["Incoming Gumdrop"] = true,
        ["Incriminating Documents"] = true,
        ["Indispensable Tools"] = true,
        ["Indurium"] = true,
        ["Indurium Ore"] = true,
        ["Ineptitude + Chemicals = Fun"] = true,
        ["Inert Scourgestones"] = true,
        ["Infallible Mind"] = true,
        ["Infiltrating Dragonmaw Fortress"] = true,
        ["Infiltrating the Castle"] = true,
        ["Infiltration"] = true,
        ["Inform Leoroxx!"] = true,
        ["Information Gathering"] = true,
        ["Ink Supplies"] = true,
        ["Inoculation"] = true,
        ["Inquire at the Inn"] = true,
        ["Insane Druids"] = true,
        ["Insect Part Analysis"] = true,
        ["Intercepting the Message"] = true,
        ["Into Occupied Territory"] = true,
        ["Into The Maw of Madness"] = true,
        ["Into The Scarlet Monastery"] = true,
        ["Into The Temple of Atal'Hakkar"] = true,
        ["Into the Breach"] = true,
        ["Into the Churning Gulch"] = true,
        ["Into the Depths"] = true,
        ["Into the Draenethyst Mine"] = true,
        ["Into the Dream"] = true,
        ["Into the Field"] = true,
        ["Into the Heart of the Labyrinth"] = true,
        ["Invaders of Alterac Valley"] = true,
        ["Invaluable Asset Zapping"] = true,
        ["Invasion Point: Annihilator"] = true,
        ["Invasion Point: Cataclysm"] = true,
        ["Investigate An'daroth"] = true,
        ["Investigate Echo Ridge"] = true,
        ["Investigate Tuurem"] = true,
        ["Investigate the Alchemist Shop"] = true,
        ["Investigate the Amani Catacombs"] = true,
        ["Investigate the Blue Recluse"] = true,
        ["Investigate the Camp"] = true,
        ["Investigate the Crash"] = true,
        ["Iron Coral"] = true,
        ["Ironband Wants You!"] = true,
        ["Ironband's Compound"] = true,
        ["Ironband's Excavation"] = true,
        ["Irondeep Supplies"] = true,
        ["Irradiated Crystal Shards"] = true,
        ["Isha Awak"] = true,
        ["Ishamuhale"] = true,
        ["Ishanah"] = true,
        ["Ishanah's Help"] = true,
        ["It's Dangerous to Go Alone"] = true,
        ["It's Just That Easy?"] = true,
        ["It's Watching You!"] = true,
        ["It's a Secret to Everybody"] = true,
        ["It's a Trap!"] = true,
        ["Items of Power"] = true,
        ["Items of Some Consequence"] = true,
        ["Ivar the Foul"] = true,
        ["Iverron's Antidote"] = true,
        ["Ivus the Forest Lord"] = true,
        ["JOB OPPORTUNITY: Culling the Competition"] = true,
        ["Jail Break!"] = true,
        ["James Hyal"] = true,
        ["Jammal'an the Prophet"] = true,
        ["Jarl Needs Eyes"] = true,
        ["Jarl Needs a Blade"] = true,
        ["Je'neu of the Earthen Ring"] = true,
        ["Jes'rimon's Payment to Jediga"] = true,
        ["Jin'Zil's Forest Magic"] = true,
        ["Jitters' Growling Gut"] = true,
        ["Job Opening: Guard Captain of Revantusk Village"] = true,
        ["Jol"] = true,
        ["Jonespyre's Request"] = true,
        ["Jorn Skyseer"] = true,
        ["Journey into Thunder Bluff"] = true,
        ["Journey to Astranaar"] = true,
        ["Journey to Hillsbrad Foothills"] = true,
        ["Journey to Honor Hold"] = true,
        ["Journey to Stonetalon Peak"] = true,
        ["Journey to Tarren Mill"] = true,
        ["Journey to Thrallmar"] = true,
        ["Journey to Undercity"] = true,
        ["Journey to the Crossroads"] = true,
        ["Journey to the Marsh"] = true,
        ["Joys of Omosh"] = true,
        ["Ju-Ju Heaps"] = true,
        ["Judgment and Redemption"] = true,
        ["Juice Delivery"] = true,
        ["Jungle Secrets"] = true,
        ["Junkboxes Needed"] = true,
        ["Just Compensation"] = true,
        ["Jyoba's Report"] = true,
        ["KILL ON SIGHT: Dark Iron Dwarves"] = true,
        ["KILL ON SIGHT: High Ranking Dark Iron Officials"] = true,
        ["Kaela's Update"] = true,
        ["Kamsis"] = true,
        ["Karabor Training Grounds"] = true,
        ["Karynaku"] = true,
        ["Kaya's Alive"] = true,
        ["Kayneth Stillwind"] = true,
        ["Keanna's Log"] = true,
        ["Keep An Eye Out"] = true,
        ["Keep Thornfang Hill Clear!"] = true,
        ["Keeper of the Flame"] = true,
        ["Keeping Pace"] = true,
        ["Keeping Up Appearances"] = true,
        ["Ken'zigla's Draught"] = true,
        ["Khadgar"] = true,
        ["Khan Dez'hepah"] = true,
        ["Khan Hratha"] = true,
        ["Khan Jehn"] = true,
        ["Khan Shaka"] = true,
        ["Kharan Mighthammer"] = true,
        ["Kharan's Tale"] = true,
        ["Kibler's Exotic Pets"] = true,
        ["Kick Them While They're Down"] = true,
        ["Kidnapped Elder Torntusk!"] = true,
        ["Kill Grundig Darkcloud"] = true,
        ["Kill the Shadow Council!"] = true,
        ["Killing the Crawlers"] = true,
        ["Kim'jael Indeed!"] = true,
        ["Kim'jael's \"Missing\" Equipment"] = true,
        ["Kindness"] = true,
        ["King of the Foulweald"] = true,
        ["Kingly Shakedown"] = true,
        ["Kirith"] = true,
        ["Kirtonos the Herald"] = true,
        ["Kitchen Assistance"] = true,
        ["Klaven's Tower"] = true,
        ["Klockmort Spannerspan"] = true,
        ["Klockmort's Creation"] = true,
        ["Klockmort's Essentials"] = true,
        ["Know Thine Enemy"] = true,
        ["Know your Enemy"] = true,
        ["Knowledge in the Deeps"] = true,
        ["Knowledge of the Orb of Orahil"] = true,
        ["Kobold Camp Cleanup"] = true,
        ["Kobold Candles"] = true,
        ["Kodo Hide Bag"] = true,
        ["Kodo Roundup"] = true,
        ["Kolkar Leaders"] = true,
        ["Krastinov's Bag of Horrors"] = true,
        ["Krasus's Compendium"] = true,
        ["Krazek's Cookery"] = true,
        ["Kris of Unspoken Names"] = true,
        ["Krom'Grul"] = true,
        ["Kroshius' Infernal Core"] = true,
        ["Kum'isha's Endeavors"] = true,
        ["Kurzen's Mystery"] = true,
        ["Lack of Surplus"] = true,
        ["Lakota'mani"] = true,
        ["Land Ho!"] = true,
        ["Lard Lost His Lunch"] = true,
        ["Larion and Muigin"] = true,
        ["Laughing Sisters"] = true,
        ["Laying Waste to the Unwanted"] = true,
        ["Lazy Peons"] = true,
        ["Leader of the Bloodscale"] = true,
        ["Leader of the Darkcrest"] = true,
        ["Leaders of the Fang"] = true,
        ["Learning from the Crystals"] = true,
        ["Learning the Language"] = true,
        ["Ledger from Tanaris"] = true,
        ["Legends of Maraudon"] = true,
        ["Leonid Barthalomew"] = true,
        ["Lethtendris's Web"] = true,
        ["Letter to Jin'Zil"] = true,
        ["Letter to Stormpike"] = true,
        ["Levixus the Soul Caller"] = true,
        ["Libram of Constitution"] = true,
        ["Libram of Focus"] = true,
        ["Libram of Protection"] = true,
        ["Libram of Rapidity"] = true,
        ["Libram of Resilience"] = true,
        ["Libram of Rumination"] = true,
        ["Libram of Tenacity"] = true,
        ["Libram of Voracity"] = true,
        ["Lieutenant Paval Reethe"] = true,
        ["Life's Finer Pleasures"] = true,
        ["Lifting the Curse"] = true,
        ["Limits of Physical Exhaustion"] = true,
        ["Lines of Communication"] = true,
        ["Linken's Adventure"] = true,
        ["Linken's Memory"] = true,
        ["Linken's Sword"] = true,
        ["Liquid Stone"] = true,
        ["Little Embers"] = true,
        ["Little Morsels"] = true,
        ["Load Lightening"] = true,
        ["Lonebrow's Journal"] = true,
        ["Long Forgotten Memories"] = true,
        ["Longtail is the Lynchpin"] = true,
        ["Look To The Stars"] = true,
        ["Look to an Old Friend"] = true,
        ["Looking Further"] = true,
        ["Looking to the Leadership"] = true,
        ["Loramus"] = true,
        ["Lord Aliden Perenolde"] = true,
        ["Lord Banehollow"] = true,
        ["Lord Maxwell Tyrosus"] = true,
        ["Lords of the Council"] = true,
        ["Lore for a Price"] = true,
        ["Losing Gracefully"] = true,
        ["Lost Armaments"] = true,
        ["Lost But Not Forgotten"] = true,
        ["Lost Deathstalkers"] = true,
        ["Lost Necklace"] = true,
        ["Lost Thunderbrew Recipe"] = true,
        ["Lost in Action"] = true,
        ["Lost in Battle"] = true,
        ["Lost!"] = true,
        ["Love Song for Narain"] = true,
        ["Love's Gift"] = true,
        ["Luck Be With You"] = true,
        ["Mac'Aree Mushroom Menagerie"] = true,
        ["MacKreel's Moonshine"] = true,
        ["Mace of Unending Life"] = true,
        ["Maelstrom's Wrath"] = true,
        ["Magatha's Payment to Jediga"] = true,
        ["Mage Summoner"] = true,
        ["Mage Training"] = true,
        ["Mage's Wand"] = true,
        ["Mage-tastic Gizmonitor"] = true,
        ["Magecraft"] = true,
        ["Magic Dust"] = true,
        ["Magic of the Arakkoa"] = true,
        ["Magical Analysis"] = true,
        ["Magical Disturbances"] = true,
        ["Magram Alliance"] = true,
        ["Mahren Skyseer"] = true,
        ["Mai'Zoth"] = true,
        ["Major Malfunction"] = true,
        ["Make Them Listen"] = true,
        ["Making Amends"] = true,
        ["Making Sense of It"] = true,
        ["Maktu's Revenge"] = true,
        ["Makuru's Vengeance"] = true,
        ["Malaise"] = true,
        ["Malevolent Remnants"] = true,
        ["Malfunction at the West Sanctum"] = true,
        ["Malin's Request"] = true,
        ["Mana Surges"] = true,
        ["Manaforge B'naar"] = true,
        ["Manaweave Robe"] = true,
        ["Manhunt"] = true,
        ["Mantle of the Oracle"] = true,
        ["Mantles of the Dawn"] = true,
        ["Maps and Runes"] = true,
        ["Marauders of Darrowshire"] = true,
        ["Marauding Crust Bursters"] = true,
        ["Marauding Wolves"] = true,
        ["Marg Speaks"] = true,
        ["Margoz"] = true,
        ["Mark V is Alive!"] = true,
        ["Marking the Path"] = true,
        ["Marks of Kil'jaeden"] = true,
        ["Marks of Sargeras"] = true,
        ["Marla's Last Wish"] = true,
        ["Marshal Haggard"] = true,
        ["Marshal Windsor"] = true,
        ["Martek the Exiled"] = true,
        ["Marvon's Workshop"] = true,
        ["Massacre at Gruul's Lair"] = true,
        ["Master Angler"] = true,
        ["Master of the Wild Leather"] = true,
        ["Mastering the Elements"] = true,
        ["Material Assistance"] = true,
        ["Material Components"] = true,
        ["Mathias and the Defias"] = true,
        ["Mathiel"] = true,
        ["Mathiel's Armor"] = true,
        ["Mathystra Relics"] = true,
        ["Matis the Cruel"] = true,
        ["Matters of Security"] = true,
        ["Maxnar Must Die!"] = true,
        ["Maxwell's Mission"] = true,
        ["Mayara Brightwing"] = true,
        ["Mazen's Behest"] = true,
        ["Mazzranache"] = true,
        ["Measuring Warp Energies"] = true,
        ["Meats to Orgrimmar"] = true,
        ["Mechanical Repair Kits"] = true,
        ["Medallion of Station"] = true,
        ["Medicinal Purpose"] = true,
        ["Medivh's Journal"] = true,
        ["Meet at the Grave"] = true,
        ["Meeting at the Blackwing Coven"] = true,
        ["Meeting with the Master"] = true,
        ["Melding of Influences"] = true,
        ["Melor Sends Word"] = true,
        ["Menacing Marshfangs"] = true,
        ["Mending Old Wounds"] = true,
        ["Menethil's Gift"] = true,
        ["Mennet Carkad"] = true,
        ["Mercenaries"] = true,
        ["Mercy for the Cursed"] = true,
        ["Message in a Bottle"] = true,
        ["Message to Freewind Post"] = true,
        ["Message to Garadar"] = true,
        ["Message to Maxwell"] = true,
        ["Message to Telaar"] = true,
        ["Message to the Daggerfen"] = true,
        ["Message to the Wildhammer"] = true,
        ["Messenger to Darkshire"] = true,
        ["Messenger to Stormwind"] = true,
        ["Messenger to Thrall"] = true,
        ["Messenger to Westfall"] = true,
        ["Messenger to the Feralfen"] = true,
        ["Metzen the Reindeer"] = true,
        ["Michael Garrett"] = true,
        ["Milly Osworth"] = true,
        ["Milly's Harvest"] = true,
        ["Miner's Fortune"] = true,
        ["Minions of the Shadow Council"] = true,
        ["Minshina's Skull"] = true,
        ["Mirages"] = true,
        ["Mirror Lake"] = true,
        ["Missing Crystals"] = true,
        ["Missing Friends"] = true,
        ["Missing In Action"] = true,
        ["Missing Mag'hari Procession"] = true,
        ["Missing Missive"] = true,
        ["Missing in the Ghostlands"] = true,
        ["Mission: Gateways Murketh and Shaadraz"] = true,
        ["Mission: Possible But Not Probable"] = true,
        ["Mission: The Abyssal Shelf"] = true,
        ["Mission: The Murketh and Shaadraz Gateways"] = true,
        ["Mist"] = true,
        ["Mo'mor the Breaker"] = true,
        ["Mok'Nathal Treats"] = true,
        ["Mok'thardin's Enchantment"] = true,
        ["Mold Rhymes With..."] = true,
        ["Moonglow Vest"] = true,
        ["Moontouched Wildkin"] = true,
        ["Mor'Ladim"] = true,
        ["Mor'zul Bloodbringer"] = true,
        ["Morbent Fel"] = true,
        ["More Arakkoa Feathers"] = true,
        ["More Armor Kits"] = true,
        ["More Bat Eyes"] = true,
        ["More Booty!"] = true,
        ["More Components of Importance"] = true,
        ["More Crystal Fragments"] = true,
        ["More Dense Grinding Stones"] = true,
        ["More Feathers"] = true,
        ["More Fertile Spores"] = true,
        ["More Firewing Signets"] = true,
        ["More Glowcaps"] = true,
        ["More Glowing Scorpid Blood"] = true,
        ["More Heads Full of Ivory"] = true,
        ["More Irradiated Crystal Shards"] = true,
        ["More Marks of Kil'jaeden"] = true,
        ["More Marks of Sargeras"] = true,
        ["More Obsidian Warbeads"] = true,
        ["More Power!"] = true,
        ["More Rotting Hearts"] = true,
        ["More Spore Sacs"] = true,
        ["More Tendrils!"] = true,
        ["More Thorium Widgets"] = true,
        ["More Venom Sacs"] = true,
        ["More Warbeads"] = true,
        ["More Warbeads!"] = true,
        ["More Wastewander Justice"] = true,
        ["More than a Pound of Flesh"] = true,
        ["Morgan Ladimore"] = true,
        ["Morgan Stern"] = true,
        ["Morganth"] = true,
        ["Morrowgrain Research"] = true,
        ["Morrowgrain to Darnassus"] = true,
        ["Morrowgrain to Feathermoon Stronghold"] = true,
        ["Morrowgrain to Thunder Bluff"] = true,
        ["Mortality Wanes"] = true,
        ["Mother's Milk"] = true,
        ["Mountain Giant Muisek"] = true,
        ["Mountaineer Stormpike's Task"] = true,
        ["Muck Diving"] = true,
        ["Mudrock Soup and Bugs"] = true,
        ["Muigin and Larion"] = true,
        ["Mura Runetotem"] = true,
        ["Murdaloc"] = true,
        ["Muren Stormpike"] = true,
        ["Murkblood Corrupters"] = true,
        ["Murkblood Invaders"] = true,
        ["Murkblood Leaders..."] = true,
        ["Murloc Poachers"] = true,
        ["Murlocs... Why Here? Why Now?"] = true,
        ["Mystery Goo"] = true,
        ["Mystery Mask"] = true,
        ["Mythology of the Titans"] = true,
        ["Myzrael's Allies"] = true,
        ["Naaru Technology"] = true,
        ["Naga at the Zoram Strand"] = true,
        ["Naladu"] = true,
        ["Nara Wildmane"] = true,
        ["Nat's Measuring Tape"] = true,
        ["Natural Armor"] = true,
        ["Natural Enemies"] = true,
        ["Natural Materials"] = true,
        ["Natural Remedies"] = true,
        ["Necklace Recovery"] = true,
        ["Need for a Cure"] = true,
        ["Needs More Cowbell"] = true,
        ["Neeka Bloodscar"] = true,
        ["Neeru Fireblade"] = true,
        ["Nefarius's Corruption"] = true,
        ["Nek'rosh's Gambit"] = true,
        ["Nekrum's Medallion"] = true,
        ["Nessa Shadowsong"] = true,
        ["Nether Gas In a Fel Fire Engine"] = true,
        ["Nether-lace Garment"] = true,
        ["Neutralizing the Nethermancers"] = true,
        ["Never Again!"] = true,
        ["Never Ask Me About My Business"] = true,
        ["New Life"] = true,
        ["New Opportunities"] = true,
        ["New Year Celebrations!"] = true,
        ["Newfound Allies"] = true,
        ["News for Fizzle"] = true,
        ["News for Rakoria"] = true,
        ["News from Zangarmarsh"] = true,
        ["News of Dogran"] = true,
        ["News of Victory"] = true,
        ["Nexus-King Salhadaar"] = true,
        ["Night Web's Hollow"] = true,
        ["No More Mushrooms!"] = true,
        ["No Time for Curiosity"] = true,
        ["Noble Deaths"] = true,
        ["Noboru the Cudgel"] = true,
        ["Nogg's Ring Redo"] = true,
        ["Noggenfogger Elixir"] = true,
        ["Noggle's Last Hope"] = true,
        ["Noggle's Lost Satchel"] = true,
        ["Nolkai's Words"] = true,
        ["Northfold Manor"] = true,
        ["Not On My Watch!"] = true,
        ["Note to William"] = true,
        ["Note to the Mayor"] = true,
        ["Nothin' Says Lovin' Like a Big Stinger"] = true,
        ["Nothing But The Truth"] = true,
        ["Now That We're Friends..."] = true,
        ["Now That We're Still Friends..."] = true,
        ["Noxious Lair Investigation"] = true,
        ["Nugget Slugs"] = true,
        ["Oakenscowl"] = true,
        ["Observing the Sporelings"] = true,
        ["Obsidian Warbeads"] = true,
        ["Oculus Illusions"] = true,
        ["Of Coursers We Know"] = true,
        ["Of Forgotten Memories"] = true,
        ["Of Lost Honor"] = true,
        ["Of Love and Family"] = true,
        ["Of Thistleheads and Eggs..."] = true,
        ["Off To Area 52"] = true,
        ["Ogre Head On A Stick = Party"] = true,
        ["Ogre Thieves"] = true,
        ["Oh Brother. . ."] = true,
        ["Old Hillsbrad"] = true,
        ["Old Whitebark's Pendant"] = true,
        ["Olemba Seed Oil"] = true,
        ["Olemba Seeds"] = true,
        ["Omarion's Handbook"] = true,
        ["On Guard in Stonetalon"] = true,
        ["On Iron Pauldrons"] = true,
        ["On Nethery Wings"] = true,
        ["On Spirit's Wings"] = true,
        ["On the Wings of a Hippogryph"] = true,
        ["Once Were Warriors"] = true,
        ["One Demon's Trash..."] = true,
        ["One Draenei's Junk..."] = true,
        ["One Shot. One Kill."] = true,
        ["Ongeku"] = true,
        ["Onin's Report"] = true,
        ["Only One May Rise"] = true,
        ["Onu"] = true,
        ["Onu is meditating"] = true,
        ["Onward to Ashenvale"] = true,
        ["Operation Recombobulation"] = true,
        ["Operation: Death to Angerforge"] = true,
        ["Operative Bijou"] = true,
        ["Oran's Gratitude"] = true,
        ["Ordanus"] = true,
        ["Order Must Be Restored"] = true,
        ["Orders from Lady Vashj"] = true,
        ["Orendil's Cure"] = true,
        ["Orm Stonehoof and the Brutal Helm"] = true,
        ["Ormer's Revenge"] = true,
        ["Oronok Torn-heart"] = true,
        ["Oronu the Elder"] = true,
        ["Ortor My Old Friend..."] = true,
        ["Oshu'gun Crystal Powder"] = true,
        ["Other Fish to Fry"] = true,
        ["Outland Sucks!"] = true,
        ["Outrider Advanced Care Package"] = true,
        ["Outrider Basic Care Package"] = true,
        ["Outrider Standard Care Package"] = true,
        ["Outside Assistance"] = true,
        ["Overlord"] = true,
        ["Overlord Gorefist"] = true,
        ["Overlord Mok'Morokk's Concern"] = true,
        ["Overmaster Pyron"] = true,
        ["Owatanka"] = true,
        ["Pacify the Centaur"] = true,
        ["Package Recovery"] = true,
        ["Package for Thurman"] = true,
        ["Paladin Training"] = true,
        ["Pamela's Doll"] = true,
        ["Panther Mastery"] = true,
        ["Paragons of Power: The Augur's Belt"] = true,
        ["Paragons of Power: The Augur's Bracers"] = true,
        ["Paragons of Power: The Augur's Hauberk"] = true,
        ["Paragons of Power: The Confessor's Bindings"] = true,
        ["Paragons of Power: The Confessor's Mantle"] = true,
        ["Paragons of Power: The Confessor's Wraps"] = true,
        ["Paragons of Power: The Demoniac's Mantle"] = true,
        ["Paragons of Power: The Demoniac's Robes"] = true,
        ["Paragons of Power: The Demoniac's Wraps"] = true,
        ["Paragons of Power: The Freethinker's Armguards"] = true,
        ["Paragons of Power: The Freethinker's Belt"] = true,
        ["Paragons of Power: The Freethinker's Breastplate"] = true,
        ["Paragons of Power: The Haruspex's Belt"] = true,
        ["Paragons of Power: The Haruspex's Bracers"] = true,
        ["Paragons of Power: The Haruspex's Tunic"] = true,
        ["Paragons of Power: The Illusionist's Mantle"] = true,
        ["Paragons of Power: The Illusionist's Robes"] = true,
        ["Paragons of Power: The Illusionist's Wraps"] = true,
        ["Paragons of Power: The Madcap's Bracers"] = true,
        ["Paragons of Power: The Madcap's Mantle"] = true,
        ["Paragons of Power: The Madcap's Tunic"] = true,
        ["Paragons of Power: The Predator's Belt"] = true,
        ["Paragons of Power: The Predator's Bracers"] = true,
        ["Paragons of Power: The Predator's Mantle"] = true,
        ["Paragons of Power: The Vindicator's Armguards"] = true,
        ["Paragons of Power: The Vindicator's Belt"] = true,
        ["Paragons of Power: The Vindicator's Breastplate"] = true,
        ["Parts for Kravel"] = true,
        ["Parts of the Swarm"] = true,
        ["Passage to Booty Bay"] = true,
        ["Passing Word of a Threat"] = true,
        ["Passing the Burden"] = true,
        ["Past Endeavors"] = true,
        ["Path of Defense"] = true,
        ["Path of the Violet Protector"] = true,
        ["Path of the Violet Restorer"] = true,
        ["Patriarch Ironjaw"] = true,
        ["Patrol Schedules"] = true,
        ["Patrolling Westfall"] = true,
        ["Pawn Captures Queen"] = true,
        ["Pay the Baron a Visit"] = true,
        ["Pearl Diving"] = true,
        ["Pelt Collection"] = true,
        ["Perfect Yeti Hide"] = true,
        ["Petty Squabbles"] = true,
        ["Pick Your Part"] = true,
        ["Picking Up Some Power Converters"] = true,
        ["Pie for Billy"] = true,
        ["Piercing the Veil"] = true,
        ["Pilfered Equipment"] = true,
        ["Pirate Hats Ahoy!"] = true,
        ["Plagued Hatchlings"] = true,
        ["Plagueheart Belt"] = true,
        ["Plagueheart Bindings"] = true,
        ["Plagueheart Leggings"] = true,
        ["Plainstrider Menace"] = true,
        ["Planting the Banner"] = true,
        ["Planting the Heart"] = true,
        ["Plants of Zangarmarsh"] = true,
        ["Plea To The Alliance"] = true,
        ["Plundering the Plunderers"] = true,
        ["Poaching from Poachers"] = true,
        ["Poison Water"] = true,
        ["Poisoned Water"] = true,
        ["Pool of Tears"] = true,
        ["Poor Old Blanchy"] = true,
        ["Portals of the Legion"] = true,
        ["Portents of Uldum"] = true,
        ["Potential Energy Source"] = true,
        ["Potential for Brain Damage = High"] = true,
        ["Powder to Ironband"] = true,
        ["Power Stones"] = true,
        ["Power in Uldaman"] = true,
        ["Power over Poison"] = true,
        ["Powering our Defenses"] = true,
        ["Practical Prey"] = true,
        ["Prayer to Elune"] = true,
        ["Precarious Predicament"] = true,
        ["Precious and Fragile Things Need Special Handling"] = true,
        ["Preparation for Ceremony"] = true,
        ["Preparing for War"] = true,
        ["Preparing the Salve"] = true,
        ["Presence of Might"] = true,
        ["Presence of Sight"] = true,
        ["Preserving Knowledge"] = true,
        ["Preying on the Predators"] = true,
        ["Pride of the Fel Horde"] = true,
        ["Pridewings of Stonetalon"] = true,
        ["Priest Training"] = true,
        ["Primal Magic"] = true,
        ["Princess Must Die!"] = true,
        ["Prison Break In"] = true,
        ["Prisoner of the Bladespire"] = true,
        ["Pristine Enchanted South Seas Kelp"] = true,
        ["Pristine Spider Silk"] = true,
        ["Pristine Yeti Hide"] = true,
        ["Proof of Allegiance"] = true,
        ["Proof of Deed"] = true,
        ["Proof of Demise"] = true,
        ["Proof of Life"] = true,
        ["Prophetic Aura"] = true,
        ["Prospect of Faith"] = true,
        ["Prospector Balmoral"] = true,
        ["Protect Kanati Greycloud"] = true,
        ["Protect Kaya"] = true,
        ["Protect the Frontier"] = true,
        ["Protecting Our Own"] = true,
        ["Protecting the Herd"] = true,
        ["Protecting the Shipment"] = true,
        ["Prove Your Hatred"] = true,
        ["Prove Your Worth"] = true,
        ["Proving Allegiance"] = true,
        ["Proving Grounds"] = true,
        ["Proving Your Strength"] = true,
        ["Proving Your Worth"] = true,
        ["Prowlers of the Barrens"] = true,
        ["Psychometric Reading"] = true,
        ["Purified!"] = true,
        ["Pursuing Terrorclaw"] = true,
        ["Pusillin and the Elder Azj'Tordin"] = true,
        ["Put Her Down"] = true,
        ["Put On Yer Kneepads..."] = true,
        ["Pyrewood Ambush"] = true,
        ["Quell The Uprising"] = true,
        ["Quenching the Blade"] = true,
        ["Questioning Reethe"] = true,
        ["Rabine Saturna"] = true,
        ["Raene's Cleansing"] = true,
        ["Rage of Ages"] = true,
        ["Rage of Blood"] = true,
        ["Ragnar Thunderbrew"] = true,
        ["Raid on the Kolkar"] = true,
        ["Raising Spirits"] = true,
        ["Raleigh and the Undercity"] = true,
        ["Ram Hide Harnesses"] = true,
        ["Ram Riding Harnesses"] = true,
        ["Rampaging Giants"] = true,
        ["Rampaging Ravagers"] = true,
        ["Ramstein"] = true,
        ["Ranger Sareyn"] = true,
        ["Raptor Horns"] = true,
        ["Raptor Mastery"] = true,
        ["Raptor Thieves"] = true,
        ["Rare Fish - Brownell's Blue Striped Racer"] = true,
        ["Rare Fish - Dezian Queenfish"] = true,
        ["Rare Fish - Keefer's Angelfish"] = true,
        ["Rat Catching"] = true,
        ["Rather Be Fishin'"] = true,
        ["Rattling the Rattlecages"] = true,
        ["Ravager Egg Roundup"] = true,
        ["Raven Hill"] = true,
        ["Razorhide"] = true,
        ["Razormaw"] = true,
        ["Razzeric's Tweaking"] = true,
        ["Reagents for Reclaimers Inc."] = true,
        ["Rear Guard Patrol"] = true,
        ["Reassignment"] = true,
        ["Recently Living"] = true,
        ["Reception from Tyrande"] = true,
        ["Recharging the Batteries"] = true,
        ["Recipe for Destruction"] = true,
        ["Recipe of the Kaldorei"] = true,
        ["Reclaimed Treasures"] = true,
        ["Reclaimers' Business in Desolace"] = true,
        ["Reclaiming Felfire Hill"] = true,
        ["Reclaiming Goods"] = true,
        ["Reclaiming Holy Grounds"] = true,
        ["Reclaiming Sunstrider Isle"] = true,
        ["Reclaiming the Charred Vale"] = true,
        ["Reclaiming the Eggs"] = true,
        ["Reclaiming the Ruins"] = true,
        ["Recover the Bones"] = true,
        ["Recover the Key!"] = true,
        ["Red Leather Bandanas"] = true,
        ["Red Linen Goods"] = true,
        ["Red Silk Bandanas"] = true,
        ["Red Snapper - Very Tasty!"] = true,
        ["Redeeming the Dead"] = true,
        ["Redemption"] = true,
        ["Redemption Boots"] = true,
        ["Redemption Girdle"] = true,
        ["Redemption Handguards"] = true,
        ["Redemption Headpiece"] = true,
        ["Redemption Tunic"] = true,
        ["Redemption Wristguards"] = true,
        ["Redridge Goulash"] = true,
        ["Redridge Rendezvous"] = true,
        ["Refuel for the Zapping"] = true,
        ["Regthar Deathgate"] = true,
        ["Reinforcements for Garadar"] = true,
        ["Rejold's New Brew"] = true,
        ["Release Them"] = true,
        ["Rellian Greenspyre"] = true,
        ["Remorseful Highborne"] = true,
        ["Replacement Phial"] = true,
        ["Replenishing the Healing Crystals"] = true,
        ["Report Back to Fizzlebub"] = true,
        ["Report from the Northern Front"] = true,
        ["Report to Anastasia"] = true,
        ["Report to Captain Helios"] = true,
        ["Report to Captain Stoutfist"] = true,
        ["Report to Doren"] = true,
        ["Report to Engineering"] = true,
        ["Report to Exarch Admetius"] = true,
        ["Report to General Kirika"] = true,
        ["Report to Goldshire"] = true,
        ["Report to Gryan Stoutmantle"] = true,
        ["Report to Hadrec"] = true,
        ["Report to Helgrum"] = true,
        ["Report to Ironforge"] = true,
        ["Report to Jennea"] = true,
        ["Report to Lanthan Perilon"] = true,
        ["Report to Magister Kaendris"] = true,
        ["Report to Marshal Bluewall"] = true,
        ["Report to Mountaineer Rockgar"] = true,
        ["Report to Nazgrel"] = true,
        ["Report to Orgnil"] = true,
        ["Report to Sen'jin Village"] = true,
        ["Report to Shadow Hunter Denjai"] = true,
        ["Report to Splintertree Post"] = true,
        ["Report to Stonebreaker Camp"] = true,
        ["Report to Tarren Mill"] = true,
        ["Report to Thomas"] = true,
        ["Report to Zor"] = true,
        ["Report to Zurai"] = true,
        ["Report to the Allerian Post"] = true,
        ["Request for Assistance"] = true,
        ["Rescue Deirom!"] = true,
        ["Rescue Dugar!"] = true,
        ["Rescue From Jaedenar"] = true,
        ["Rescue OOX-09/HL!"] = true,
        ["Rescue OOX-17/TN!"] = true,
        ["Rescue OOX-22/FE!"] = true,
        ["Rescue the Survivors!"] = true,
        ["Research Notes"] = true,
        ["Researching the Corruption"] = true,
        ["Rest and Relaxation"] = true,
        ["Resting in Pieces"] = true,
        ["Restless Activity"] = true,
        ["Restoring Fiery Flux Supplies via Heavy Leather"] = true,
        ["Restoring Fiery Flux Supplies via Iron"] = true,
        ["Restoring Fiery Flux Supplies via Kingsblood"] = true,
        ["Restoring Sanctity"] = true,
        ["Restoring the Light"] = true,
        ["Restoring the Necklace"] = true,
        ["Resupplying the Excavation"] = true,
        ["Retaking Windrunner Spire"] = true,
        ["Rethban Ore"] = true,
        ["Retribution of the Light"] = true,
        ["Retrieving the Goods"] = true,
        ["Return Trip"] = true,
        ["Return of the Ring"] = true,
        ["Return the Book"] = true,
        ["Return the Comb"] = true,
        ["Return the Reports"] = true,
        ["Return the Statuette"] = true,
        ["Return to Andormu"] = true,
        ["Return to Apothecary Zinge"] = true,
        ["Return to Arcanist Vandril"] = true,
        ["Return to Bellowfiz"] = true,
        ["Return to Bodley"] = true,
        ["Return to Brock"] = true,
        ["Return to Chillwind Camp"] = true,
        ["Return to Chromie"] = true,
        ["Return to Corporal Kaleb"] = true,
        ["Return to Deliana"] = true,
        ["Return to Denalan"] = true,
        ["Return to Feathermoon Stronghold"] = true,
        ["Return to Fel'Zerul"] = true,
        ["Return to Honor Hold"] = true,
        ["Return to Ironforge"] = true,
        ["Return to Jitters"] = true,
        ["Return to Khadgar"] = true,
        ["Return to Kristoff"] = true,
        ["Return to Lewis"] = true,
        ["Return to MacKinley"] = true,
        ["Return to Marleth"] = true,
        ["Return to Milton"] = true,
        ["Return to Mokvar"] = true,
        ["Return to Narain"] = true,
        ["Return to Nathanos"] = true,
        ["Return to Nessa"] = true,
        ["Return to Obadei"] = true,
        ["Return to Onu"] = true,
        ["Return to Podrig"] = true,
        ["Return to Primal Torntusk"] = true,
        ["Return to Quartermaster Lymel"] = true,
        ["Return to Quinn"] = true,
        ["Return to Rokag"] = true,
        ["Return to Sha'tari Base Camp"] = true,
        ["Return to Shattrath"] = true,
        ["Return to Silvermoon"] = true,
        ["Return to Sven"] = true,
        ["Return to Talionia"] = true,
        ["Return to Thalodien"] = true,
        ["Return to Thander"] = true,
        ["Return to Thrallmar"] = true,
        ["Return to Thunder Bluff"] = true,
        ["Return to Tinkee"] = true,
        ["Return to Topher Loaal"] = true,
        ["Return to Troyas"] = true,
        ["Return to Tymor"] = true,
        ["Return to Vahlarriel"] = true,
        ["Return to Verner"] = true,
        ["Return to Witch Doctor Uzer'i"] = true,
        ["Return to the Abyssal Shelf"] = true,
        ["Return to the Aldor"] = true,
        ["Return to the Blasted Lands"] = true,
        ["Return to the Bulwark"] = true,
        ["Return to the Crossroads."] = true,
        ["Return to the Greatmother"] = true,
        ["Return to the Hinterlands"] = true,
        ["Return to the Magistrate"] = true,
        ["Return to the Marsh"] = true,
        ["Return to the Scryers"] = true,
        ["Returning Home"] = true,
        ["Returning the Cleansed Orb"] = true,
        ["Returning the Favor"] = true,
        ["Returning the Lost Satchel"] = true,
        ["Reunion"] = true,
        ["Revenge of Gann"] = true,
        ["Revered Among the Sha'tar"] = true,
        ["Rhapsody Shindigger"] = true,
        ["Rhapsody's Kalimdor Kocktail"] = true,
        ["Rhapsody's Tale"] = true,
        ["Ribbly Screwspigot"] = true,
        ["Ride the Lightning"] = true,
        ["Ride to Ironforge"] = true,
        ["Ride to Orgrimmar"] = true,
        ["Ride to Thunder Bluff"] = true,
        ["Ride to the Undercity"] = true,
        ["Ridgespine Menace"] = true,
        ["Rig Wars"] = true,
        ["Rightful Repossession"] = true,
        ["Rilli Greasygob"] = true,
        ["Rin'ji is Trapped!"] = true,
        ["Rin'ji's Secret"] = true,
        ["Ring of Infinite Wisdom"] = true,
        ["Ring of Unspoken Names"] = true,
        ["Ring of the Gathering Storm"] = true,
        ["Ripple Delivery"] = true,
        ["Ripple Recovery"] = true,
        ["Rise of the Silithid"] = true,
        ["Rising Spirit"] = true,
        ["Rite of Strength"] = true,
        ["Rite of Vision"] = true,
        ["Rite of Wisdom"] = true,
        ["Rites of the Earthmother"] = true,
        ["Rituals of Power"] = true,
        ["Rituals of Strength"] = true,
        ["Riverpaw Gnoll Bounty"] = true,
        ["Rizzle's Schematics"] = true,
        ["Road to Salvation"] = true,
        ["Roadside Ambush"] = true,
        ["Rocket Car Parts"] = true,
        ["Rocknot's Ale"] = true,
        ["Rogue Training"] = true,
        ["Rogues of the Shattered Hand"] = true,
        ["Rohok's Request"] = true,
        ["Roll the Bones"] = true,
        ["Root Samples"] = true,
        ["Rot Hide Clues"] = true,
        ["Rot Hide Ichor"] = true,
        ["Rot Hide Origins"] = true,
        ["Rotten Eggs"] = true,
        ["Rotting Hearts"] = true,
        ["Rude Awakening"] = true,
        ["Ruined Kegs"] = true,
        ["Rumors for Kravel"] = true,
        ["Run a Diagnostic!"] = true,
        ["Rune Covered Tablet"] = true,
        ["Rune-Inscribed Note"] = true,
        ["Rune-Inscribed Parchment"] = true,
        ["Rune-Inscribed Tablet"] = true,
        ["Runecloth"] = true,
        ["Runewarden Deryan"] = true,
        ["Ruthless Cunning"] = true,
        ["Ruuan Weald"] = true,
        ["Ruuzel"] = true,
        ["S-A-B-O-T-A-G-E"] = true,
        ["SI:7"] = true,
        ["STOLEN: Smithing Tuyere and Lookout's Spyglass"] = true,
        ["Sabotage the Warp-Gate!"] = true,
        ["Sacred Cloth"] = true,
        ["Sacred Fire"] = true,
        ["Safeguarding the Watchers"] = true,
        ["Safety First"] = true,
        ["Safety Is Job One"] = true,
        ["Salt Flat Venom"] = true,
        ["Salt of the Scorpok"] = true,
        ["Saltheril's Haven"] = true,
        ["Salvaging the Data"] = true,
        ["Salvaging the Past"] = true,
        ["Samophlange"] = true,
        ["Samophlange Manual"] = true,
        ["Sample for Helbrim"] = true,
        ["Sara Balloo's Plea"] = true,
        ["Sarkoth"] = true,
        ["Sathrah's Sacrifice"] = true,
        ["Satyr Hooves"] = true,
        ["Satyr Horns"] = true,
        ["Satyr Slaying!"] = true,
        ["Savage Flora"] = true,
        ["Savage Fronds"] = true,
        ["Save Techbot's Brain!"] = true,
        ["Saving Princess Stillpine"] = true,
        ["Saving Sharpbeak"] = true,
        ["Saving Yenniku"] = true,
        ["Saving the Best for Last"] = true,
        ["Saving the Sporeloks"] = true,
        ["Scalding Mornbrew Delivery"] = true,
        ["Scarab Shells"] = true,
        ["Scaring Shaky"] = true,
        ["Scarlet Diversions"] = true,
        ["Scarlet Subterfuge"] = true,
        ["Scavenging Deathknell"] = true,
        ["Scepter of the Council"] = true,
        ["Sceptre of Light"] = true,
        ["Scholomance"] = true,
        ["Scourge of the Downs"] = true,
        ["Scouring the Desert"] = true,
        ["Scouting the Defenses"] = true,
        ["Scratches"] = true,
        ["Screecher Spirits"] = true,
        ["Scrounging"] = true,
        ["Scrying Goggles? No Problem!"] = true,
        ["Seal of Ascension"] = true,
        ["Sealed Azure Bag"] = true,
        ["Search More Hovels"] = true,
        ["Search Stillpine Hold"] = true,
        ["Search for Incendicite"] = true,
        ["Search for Tyranis"] = true,
        ["Searching for Evidence"] = true,
        ["Searching for Galaen"] = true,
        ["Searching for Scout Jyoba"] = true,
        ["Searching for the Lost Satchel"] = true,
        ["Seasoned Wolf Kabobs"] = true,
        ["Secret of the Circle"] = true,
        ["Secrets of the Arakkoa"] = true,
        ["Secrets of the Colossus - Ashi"] = true,
        ["Secrets of the Daggerfen"] = true,
        ["Securing the Celestial Ridge"] = true,
        ["Securing the Lines"] = true,
        ["Securing the Shaleskin Shale"] = true,
        ["Seed of Life"] = true,
        ["Seeing What Happens"] = true,
        ["Seek Huntress Kella Nightbow"] = true,
        ["Seek Out Kirrik"] = true,
        ["Seek Out Neltharaku"] = true,
        ["Seek Redemption!"] = true,
        ["Seek out SI: 7"] = true,
        ["Seek the Farstriders"] = true,
        ["Seeking Strahad"] = true,
        ["Seeking Wisdom"] = true,
        ["Seeking the Kor Gem"] = true,
        ["Seeping Corruption"] = true,
        ["Seer Udalo"] = true,
        ["Selling Fish"] = true,
        ["Senir's Observations"] = true,
        ["Sentinel Advanced Care Package"] = true,
        ["Sentinel Basic Care Package"] = true,
        ["Sentinel Standard Care Package"] = true,
        ["Separation Anxiety"] = true,
        ["Serena Bloodfeather"] = true,
        ["Sergra Darkthorn"] = true,
        ["Serpent Wild"] = true,
        ["Serpentbloom"] = true,
        ["Service to the Horde"] = true,
        ["Set Them Ablaze!"] = true,
        ["Setting Up the Bomb"] = true,
        ["Shadow Magic"] = true,
        ["Shadow of the Past"] = true,
        ["Shadoweaver"] = true,
        ["Shadowpine Weaponry"] = true,
        ["Shadowshard Fragments"] = true,
        ["Shadumbra's Head"] = true,
        ["Shaman Training"] = true,
        ["Shard of a Felhound"] = true,
        ["Shard of an Infernal"] = true,
        ["Shards of the Felvine"] = true,
        ["Shardtooth E'ko"] = true,
        ["Sharing the Knowledge"] = true,
        ["Sharing the Land"] = true,
        ["Sharptalon's Claw"] = true,
        ["Shatter Point"] = true,
        ["Shattering the Veil"] = true,
        ["Shimmer Stout"] = true,
        ["Ship Schedules"] = true,
        ["Shipment to Stormwind"] = true,
        ["Shizz Work"] = true,
        ["Shizzle's Flyer"] = true,
        ["Shoulderpads of Faith"] = true,
        ["Show Gnomercy"] = true,
        ["Show Them Gnome Mercy!"] = true,
        ["Show Your Work"] = true,
        ["Showdown"] = true,
        ["Shredding Machines"] = true,
        ["Shroud of Infinite Wisdom"] = true,
        ["Shroud of Unspoken Names"] = true,
        ["Shrouded in Nightmare"] = true,
        ["Shutting Down Manaforge Ara"] = true,
        ["Shutting Down Manaforge B'naar"] = true,
        ["Shutting Down Manaforge Coruu"] = true,
        ["Shutting Down Manaforge Duro"] = true,
        ["Shy-Rotam"] = true,
        ["Sickle of Unyielding Strength"] = true,
        ["Sigil of Arathor"] = true,
        ["Sigil of Strom"] = true,
        ["Sigil of Thoradin"] = true,
        ["Sigil of Trollbane"] = true,
        ["Signal for Pickup"] = true,
        ["Signet of Unyielding Strength"] = true,
        ["Signet of the Dukes"] = true,
        ["Signet of the Unseen Path"] = true,
        ["Signets of the Zandalar"] = true,
        ["Signs of the Legion"] = true,
        ["Silkwing Cocoons"] = true,
        ["Silver Heart"] = true,
        ["Simple Letter"] = true,
        ["Simple Memorandum"] = true,
        ["Simple Note"] = true,
        ["Simple Parchment"] = true,
        ["Simple Rune"] = true,
        ["Simple Scroll"] = true,
        ["Simple Sigil"] = true,
        ["Simple Subterfugin'"] = true,
        ["Simple Tablet"] = true,
        ["Since Time Forgotten..."] = true,
        ["Singing Blue Shards"] = true,
        ["Single Firewing Signet"] = true,
        ["Single Mark of Kil'jaeden"] = true,
        ["Single Mark of Sargeras"] = true,
        ["Sister Pamela"] = true,
        ["Situation at Sunsail Anchorage"] = true,
        ["Skeletal Fragments"] = true,
        ["Skirmish at Echo Ridge"] = true,
        ["Skulk Rock Clean-up"] = true,
        ["Skull Rock"] = true,
        ["Skullsplitter Tusks"] = true,
        ["Skymistress Gloaming"] = true,
        ["Slain by the Wretched"] = true,
        ["Slake That Thirst"] = true,
        ["Slaughter at Boulder'mok"] = true,
        ["Slay the Brood Mother"] = true,
        ["Slaying the Beast"] = true,
        ["Small Furry Paws"] = true,
        ["Smart Drinks"] = true,
        ["Smith Mathiel"] = true,
        ["Smooth as Butter"] = true,
        ["Snakestone of the Shadow Huntress"] = true,
        ["Snatch and Grab"] = true,
        ["Snickerfang Jowls"] = true,
        ["Soaked Pages"] = true,
        ["Socrethar's Shadow"] = true,
        ["Soft Bushy Tails"] = true,
        ["Solanian's Belongings"] = true,
        ["Solomon's Law"] = true,
        ["Solution to Doom"] = true,
        ["Solving the Problem"] = true,
        ["Some Assembly Required"] = true,
        ["Someone Else's Hard Work Pays Off"] = true,
        ["Soothing Spices"] = true,
        ["Soothing Turtle Bisque"] = true,
        ["Soulbound Keepsake"] = true,
        ["Source of the Corruption"] = true,
        ["Southsea Freebooters"] = true,
        ["Southsea Shakedown"] = true,
        ["Southshore"] = true,
        ["Souvenirs of Death"] = true,
        ["Spare Parts"] = true,
        ["Spawn of Jubjub"] = true,
        ["Speak to Nafien"] = true,
        ["Speak to Salfa"] = true,
        ["Speak with Anastasia"] = true,
        ["Speak with Bink"] = true,
        ["Speak with Coleman"] = true,
        ["Speak with Deino"] = true,
        ["Speak with Dillinger"] = true,
        ["Speak with Gramma"] = true,
        ["Speak with Jennea"] = true,
        ["Speak with Private Weeks"] = true,
        ["Speak with Renferrel"] = true,
        ["Speak with Rilak the Redeemed"] = true,
        ["Speak with Ruga"] = true,
        ["Speak with Scout Neftis"] = true,
        ["Speak with Sevren"] = true,
        ["Speak with Shoni"] = true,
        ["Speak with Thun'grim"] = true,
        ["Speak with Un'thuwa"] = true,
        ["Speaking of Fortitude"] = true,
        ["Speaking with Gan'zulah"] = true,
        ["Speaking with Nezzliok"] = true,
        ["Special Delivery for Gaxim"] = true,
        ["Special Forces"] = true,
        ["Spectrecles"] = true,
        ["Spellfire Robes"] = true,
        ["Spinal Dust"] = true,
        ["Spinebreaker Post"] = true,
        ["Spirit Calling"] = true,
        ["Spirit Totem"] = true,
        ["Spirit of the Boar"] = true,
        ["Spirit of the Wind"] = true,
        ["Spirits of the Drowned"] = true,
        ["Spirits of the Feralfen"] = true,
        ["Spiritual Domination"] = true,
        ["Spiritual Unrest"] = true,
        ["Spleendid!"] = true,
        ["Split Bone Necklace"] = true,
        ["Sporeggar"] = true,
        ["Sprinkle's Secret Ingredient"] = true,
        ["Squire Maltrake"] = true,
        ["Stalking the Stalkers"] = true,
        ["Stalwart's Battlegear"] = true,
        ["Standards and Practices"] = true,
        ["Starfall"] = true,
        ["Stave of the Ancients"] = true,
        ["Stealing Back the Mushrooms"] = true,
        ["Stealing Knowledge"] = true,
        ["Stealing Supplies"] = true,
        ["Stealing from Thieves"] = true,
        ["Stealth Flight"] = true,
        ["Steelsnap"] = true,
        ["Stepping Up Security"] = true,
        ["Still Believing"] = true,
        ["Stillpine Hold"] = true,
        ["Sting of the Scorpid"] = true,
        ["Stinger Venom"] = true,
        ["Stinging the Stingers"] = true,
        ["Stinglasher"] = true,
        ["Stinking Up Southshore"] = true,
        ["Stinky's Escape"] = true,
        ["Stocking Jetsteam"] = true,
        ["Stolen Booty"] = true,
        ["Stolen Silver"] = true,
        ["Stoley's Debt"] = true,
        ["Stoley's Shipment"] = true,
        ["Stone Tokens"] = true,
        ["Stonegear's Search"] = true,
        ["Stones of Binding"] = true,
        ["Stonetalon Standstill"] = true,
        ["Stopping the Spread"] = true,
        ["Stormers and Rumblers"] = true,
        ["Stormpike's Deciphering"] = true,
        ["Stormpike's Delivery"] = true,
        ["Stormpike's Order"] = true,
        ["Stormwind Ho!"] = true,
        ["Stormwind Library"] = true,
        ["Stormwind Rendezvous"] = true,
        ["Stout to Kadrell"] = true,
        ["Strained Supplies"] = true,
        ["Strange Alliance"] = true,
        ["Strange Brew"] = true,
        ["Strange Energy"] = true,
        ["Strange Findings"] = true,
        ["Strange Sources"] = true,
        ["Stranglethorn Fever"] = true,
        ["Strength of One"] = true,
        ["Striker's Diadem"] = true,
        ["Striker's Footguards"] = true,
        ["Striker's Hauberk"] = true,
        ["Stromgarde Badges"] = true,
        ["Study of the Elements: Rock"] = true,
        ["Stymying the Arakkoa"] = true,
        ["Success!"] = true,
        ["Sully Balloo's Letter"] = true,
        ["Summon Felsteed"] = true,
        ["Summoner Kanthin's Prize"] = true,
        ["Summoning Shadra"] = true,
        ["Summoning the Princess"] = true,
        ["Summons from Knight-Lord Bloodvalor"] = true,
        ["Suncrown Village"] = true,
        ["Sunfury Briefings"] = true,
        ["Sunfury Signets"] = true,
        ["Sunken Treasure"] = true,
        ["Sunscorched Shells"] = true,
        ["Suntara Stones"] = true,
        ["Super Reaper 6000"] = true,
        ["Super Sticky"] = true,
        ["Superior Armaments of Battle - Exalted Amongst the Dawn"] = true,
        ["Superior Armaments of Battle - Friend of the Dawn"] = true,
        ["Superior Armaments of Battle - Honored Amongst the Dawn"] = true,
        ["Superior Armaments of Battle - Revered Amongst the Dawn"] = true,
        ["Supervisor Fizsprocket"] = true,
        ["Supplies for Nethergarde"] = true,
        ["Supplies for the Crossroads"] = true,
        ["Supplies from Darkshire"] = true,
        ["Supplies to Auberdine"] = true,
        ["Supplies to Private Thorsen"] = true,
        ["Supplies to Tannok"] = true,
        ["Supply and Demand"] = true,
        ["Supplying the Front"] = true,
        ["Supplying the Sepulcher"] = true,
        ["Surena Caledon"] = true,
        ["Surrender to the Horde"] = true,
        ["Survey the Land"] = true,
        ["Surveying the Ruins"] = true,
        ["Suspicious Hoofprints"] = true,
        ["Sven's Camp"] = true,
        ["Sven's Revenge"] = true,
        ["Sweet Amber"] = true,
        ["Sweet Serenity"] = true,
        ["Swift Discipline"] = true,
        ["Swoop Hunting"] = true,
        ["Syndicate Assassins"] = true,
        ["Syndicate Emblems"] = true,
        ["Synthesis of Power"] = true,
        ["Tabards of the Illidari"] = true,
        ["Tabetha's Task"] = true,
        ["Tablet of the Seven"] = true,
        ["Tablets of Baa'ri"] = true,
        ["Tainted Arcane Sliver"] = true,
        ["Tainted Letter"] = true,
        ["Tainted Memorandum"] = true,
        ["Tainted Parchment"] = true,
        ["Tainted Scroll"] = true,
        ["Take Five Bases"] = true,
        ["Take Four Bases"] = true,
        ["Taken in the Night"] = true,
        ["Taking Back Silithus"] = true,
        ["Taking the Fall"] = true,
        ["Tal the Wind Rider Master"] = true,
        ["Talbuk Mastery"] = true,
        ["Talk to the Hand"] = true,
        ["Taming the Beast"] = true,
        ["Tanaris Field Sampling"] = true,
        ["Taretha's Gift"] = true,
        ["Target: Dalson's Tears"] = true,
        ["Target: Felstone Field"] = true,
        ["Target: Gahrron's Withering"] = true,
        ["Target: Hive'Ashi Defenders"] = true,
        ["Target: Hive'Ashi Sandstalkers"] = true,
        ["Target: Hive'Ashi Stingers"] = true,
        ["Target: Hive'Ashi Workers"] = true,
        ["Target: Hive'Regal Ambushers"] = true,
        ["Target: Hive'Regal Burrowers"] = true,
        ["Target: Hive'Regal Slavemakers"] = true,
        ["Target: Hive'Regal Spitfires"] = true,
        ["Target: Hive'Zora Hive Sisters"] = true,
        ["Target: Hive'Zora Reavers"] = true,
        ["Target: Hive'Zora Tunnelers"] = true,
        ["Target: Hive'Zora Waywatchers"] = true,
        ["Target: Writhing Haunt"] = true,
        ["Tear of the Earthmother"] = true,
        ["Tears of the Moon"] = true,
        ["Teldrassil"] = true,
        ["Teleport This!"] = true,
        ["Tenaron's Summons"] = true,
        ["Terokk's Legacy"] = true,
        ["Terokkarantula"] = true,
        ["Teron Gorefiend - Lore and Legend"] = true,
        ["Test Flight: Razaan's Landing"] = true,
        ["Test Flight: Ruuan Weald"] = true,
        ["Test Flight: The Singing Ridge"] = true,
        ["Test Flight: The Zephyrium Capacitorium"] = true,
        ["Test of Endurance"] = true,
        ["Test of Faith"] = true,
        ["Test of Lore"] = true,
        ["Test of Strength"] = true,
        ["Testing an Enemy's Strength"] = true,
        ["Testing for Corruption - Felwood"] = true,
        ["Testing for Impurities - Un'Goro Crater"] = true,
        ["Testing the Antidote"] = true,
        ["Testing the Prototype"] = true,
        ["Testing the Tonic"] = true,
        ["Testing the Vessel"] = true,
        ["Thadius Grimshade"] = true,
        ["Thalanaar Delivery"] = true,
        ["Tharil'zun"] = true,
        ["Tharnariun's Hope"] = true,
        ["That Little Extra Kick"] = true,
        ["That's Asking A Lot"] = true,
        ["Thazz'ril's Pick"] = true,
        ["The Absent Minded Prospector"] = true,
        ["The Active Agent"] = true,
        ["The Admiral's Orders"] = true,
        ["The Affray"] = true,
        ["The Agitated Ancestors"] = true,
        ["The Agony and the Darkness"] = true,
        ["The Algaz Gauntlet"] = true,
        ["The All-Seeing Eye of Zuldazar"] = true,
        ["The Alliance Needs Iron Bars!"] = true,
        ["The Alliance Needs Light Leather!"] = true,
        ["The Alliance Needs Linen Bandages!"] = true,
        ["The Alliance Needs Medium Leather!"] = true,
        ["The Alliance Needs More Copper Bars!"] = true,
        ["The Alliance Needs More Linen Bandages!"] = true,
        ["The Alliance Needs More Medium Leather!"] = true,
        ["The Alliance Needs More Silk Bandages!"] = true,
        ["The Alliance Needs More Spotted Yellowtail!"] = true,
        ["The Alliance Needs More Thorium Bars!"] = true,
        ["The Alliance Needs Runecloth Bandages!"] = true,
        ["The Alliance Needs Silk Bandages!"] = true,
        ["The Alliance Needs Spotted Yellowtail!"] = true,
        ["The Altar of Zul"] = true,
        ["The Ancient Egg"] = true,
        ["The Ancient Leaf"] = true,
        ["The Ancient Statuette"] = true,
        ["The Angry Scytheclaws"] = true,
        ["The Annals of Darrowshire"] = true,
        ["The Annals of Kirin'Var"] = true,
        ["The Apes of Un'Goro"] = true,
        ["The Apple Falls"] = true,
        ["The Arakkoa Threat"] = true,
        ["The Arcanist's Cookbook"] = true,
        ["The Archivist"] = true,
        ["The Archmage's Staff"] = true,
        ["The Argent Hold"] = true,
        ["The Art of Fel Reaver Maintenance"] = true,
        ["The Art of the Armorsmith"] = true,
        ["The Art of the Imbue"] = true,
        ["The Ashenvale Hunt"] = true,
        ["The Ashtongue Broken"] = true,
        ["The Ashtongue Corruptors"] = true,
        ["The Ashtongue Tribe"] = true,
        ["The Assassin"] = true,
        ["The Atal'ai Exile"] = true,
        ["The Attack!"] = true,
        ["The Azure Key"] = true,
        ["The Bait for Lar'korwi"] = true,
        ["The Balance of Light and Shadow"] = true,
        ["The Balance of Nature"] = true,
        ["The Balnir Farmstead"] = true,
        ["The Barrens Oases"] = true,
        ["The Barrens Port"] = true,
        ["The Basilisk's Bite"] = true,
        ["The Battle Horn"] = true,
        ["The Battle Plans"] = true,
        ["The Battle of Alterac"] = true,
        ["The Battle of Darrowshire"] = true,
        ["The Battleboars"] = true,
        ["The Bear Necessities"] = true,
        ["The Bearer of Bad News"] = true,
        ["The Befouled Element"] = true,
        ["The Best Defense"] = true,
        ["The Big Bone Worm"] = true,
        ["The Biggest of Them All"] = true,
        ["The Binding"] = true,
        ["The Black Morass"] = true,
        ["The Black Shield"] = true,
        ["The Blackwood Corrupted"] = true,
        ["The Bladespire Ogres"] = true,
        ["The Bladespire Threat"] = true,
        ["The Blightcaller Cometh"] = true,
        ["The Blood Elves"] = true,
        ["The Blood is Life"] = true,
        ["The Blood-Tempered Ranseur"] = true,
        ["The Bloodcurse Legacy"] = true,
        ["The Bloodcursed Naga"] = true,
        ["The Bloodmaul Ogres"] = true,
        ["The Bloodsail Buccaneers"] = true,
        ["The Boar Hunter"] = true,
        ["The Boha'mu Ruins"] = true,
        ["The Book of Fel Names"] = true,
        ["The Book of Ur"] = true,
        ["The Borrower"] = true,
        ["The Bounty of Teldrassil"] = true,
        ["The Branch of Cenarius"] = true,
        ["The Brassbolts Brothers"] = true,
        ["The Broken Sigil"] = true,
        ["The Brood of Onyxia"] = true,
        ["The Call to Command"] = true,
        ["The Calling"] = true,
        ["The Caravan Road"] = true,
        ["The Carevin Family"] = true,
        ["The Caverns of Time"] = true,
        ["The Cenarion Expedition"] = true,
        ["The Challenge"] = true,
        ["The Champion of the Banshee Queen"] = true,
        ["The Champion of the Horde"] = true,
        ["The Changing of Paths - Conqueror No More"] = true,
        ["The Changing of Paths - Protector No More"] = true,
        ["The Charge of the Dragonflights"] = true,
        ["The Chill of Death"] = true,
        ["The Cipher of Damnation"] = true,
        ["The Cipher of Damnation - Ar'tor's Charge"] = true,
        ["The Cipher of Damnation - Borak's Charge"] = true,
        ["The Cipher of Damnation - Grom'tor's Charge"] = true,
        ["The Cipher of Damnation - The First Fragment Recovered"] = true,
        ["The Cipher of Damnation - The Second Fragment Recovered"] = true,
        ["The Cipher of Damnation - The Third Fragment Recovered"] = true,
        ["The Cipher of Damnation - Truth and History"] = true,
        ["The Cliffspring River"] = true,
        ["The Coast Isn't Clear"] = true,
        ["The Coastal Menace"] = true,
        ["The Codex of Blood"] = true,
        ["The Collector"] = true,
        ["The Color of Blood"] = true,
        ["The Completed Orb of Dar'Orahil"] = true,
        ["The Completed Orb of Noh'Orahil"] = true,
        ["The Completed Robe"] = true,
        ["The Consortium Needs You!"] = true,
        ["The Corpulent One"] = true,
        ["The Corrupter"] = true,
        ["The Corruption Abroad"] = true,
        ["The Corruption of the Jadefire"] = true,
        ["The Count of the Marshes"] = true,
        ["The Cover of Darkness"] = true,
        ["The Crimson Courier"] = true,
        ["The Crone of the Kraul"] = true,
        ["The Crown of Will"] = true,
        ["The Cryo-Core"] = true,
        ["The Crystal of Zin-Malor"] = true,
        ["The Curious Visitor"] = true,
        ["The Curse of the Tides"] = true,
        ["The Cursed Crew"] = true,
        ["The Damned"] = true,
        ["The Dark Iron War"] = true,
        ["The Dark Missive"] = true,
        ["The Darkmoon Faire"] = true,
        ["The Darkreaver Menace"] = true,
        ["The Darkstone Tablet"] = true,
        ["The Daughter Who Lived"] = true,
        ["The Day After"] = true,
        ["The Dead Fields"] = true,
        ["The Dead Mire"] = true,
        ["The Dead Scar"] = true,
        ["The Deathforge"] = true,
        ["The Deathstalkers"] = true,
        ["The Deathstalkers' Report"] = true,
        ["The Decisive Striker"] = true,
        ["The Decrepit Ferry"] = true,
        ["The Defense of Grom'gol"] = true,
        ["The Defias Brotherhood"] = true,
        ["The Demon Forge"] = true,
        ["The Demon Hunter"] = true,
        ["The Demon Scarred Cloak"] = true,
        ["The Demon Seed"] = true,
        ["The Demoniac Scryer"] = true,
        ["The Den"] = true,
        ["The Den Mother"] = true,
        ["The Deserter"] = true,
        ["The Deserters"] = true,
        ["The Disgraced One"] = true,
        ["The Disruption Ends"] = true,
        ["The Divination"] = true,
        ["The Divination Scryer"] = true,
        ["The Doomed Fleet"] = true,
        ["The Dormant Shade"] = true,
        ["The Dragon's Eye"] = true,
        ["The Dread Citadel - Naxxramas"] = true,
        ["The Dread Relic"] = true,
        ["The Dreghood Elders"] = true,
        ["The Dunemaul Compound"] = true,
        ["The Dwarven Spy"] = true,
        ["The Dying Balance"] = true,
        ["The Dynamic Duo"] = true,
        ["The Earthbinder"] = true,
        ["The Eastern Kingdoms"] = true,
        ["The Eastern Plagues"] = true,
        ["The Eastern Pylon"] = true,
        ["The Ectoplasmic Distiller"] = true,
        ["The Eighteenth Pilot"] = true,
        ["The Elder Crone"] = true,
        ["The Elemental Equation"] = true,
        ["The Elusive Ironjaw"] = true,
        ["The Emerald Dream..."] = true,
        ["The Emerald Dreamcatcher"] = true,
        ["The Emitter"] = true,
        ["The Enchanted Glade"] = true,
        ["The Encroaching Wilderness"] = true,
        ["The Engraved Ring"] = true,
        ["The Ensorcelled Parchment"] = true,
        ["The Escape"] = true,
        ["The Essence of Aku'Mai"] = true,
        ["The Essence of Eranikus"] = true,
        ["The Ethereum"] = true,
        ["The Everlook Report"] = true,
        ["The Everstill Bridge"] = true,
        ["The Exorcism"] = true,
        ["The Exorcism of Colonel Jules"] = true,
        ["The Eye of Paleth"] = true,
        ["The Eyes of Grillok"] = true,
        ["The Eyes of Skettis"] = true,
        ["The Fall of Ameth'Aran"] = true,
        ["The Fall of Kel'Thuzad"] = true,
        ["The Fall of Ossirian"] = true,
        ["The Fallen Courier"] = true,
        ["The Fallen Exarch"] = true,
        ["The Family Crypt"] = true,
        ["The Family and the Fishing Pole"] = true,
        ["The Fare of Lar'korwi"] = true,
        ["The Fargodeep Mine"] = true,
        ["The Farstrider Enclave"] = true,
        ["The Fate of Flanis"] = true,
        ["The Fate of Kagrosh"] = true,
        ["The Fate of Ramaladni"] = true,
        ["The Fate of Tuurem"] = true,
        ["The Fate of Yenniku"] = true,
        ["The Fate of the Kingdom"] = true,
        ["The Feast of Winter Veil"] = true,
        ["The Fel and the Furious"] = true,
        ["The Final Code"] = true,
        ["The Final Message to the Wildhammer"] = true,
        ["The Final Piece"] = true,
        ["The Final Reagents"] = true,
        ["The Final Sample"] = true,
        ["The Final Tablets"] = true,
        ["The Finest Down"] = true,
        ["The Firewing Liaison"] = true,
        ["The Firewing Point Project"] = true,
        ["The First Trial"] = true,
        ["The First and the Last"] = true,
        ["The Flame's Casing"] = true,
        ["The Flawless Flame"] = true,
        ["The Flesh Does Not Lie"] = true,
        ["The Flesh Lies..."] = true,
        ["The Foot of the Citadel"] = true,
        ["The Force of Neltharaku"] = true,
        ["The Forging of Quel'Serrar"] = true,
        ["The Forgotten Heirloom"] = true,
        ["The Forgotten Pools"] = true,
        ["The Formation of Felbane"] = true,
        ["The Forsaken"] = true,
        ["The Four Dukes"] = true,
        ["The Fragments Within"] = true,
        ["The Fury Runs Deep"] = true,
        ["The Giant Guardian"] = true,
        ["The Glowing Fruit"] = true,
        ["The Glowing Shard"] = true,
        ["The God Hakkar"] = true,
        ["The Good Stuff"] = true,
        ["The Gordok Ogre Suit"] = true,
        ["The Gordok Taste Test"] = true,
        ["The Gordunni Orb"] = true,
        ["The Gordunni Scroll"] = true,
        ["The Grand Betrayal"] = true,
        ["The Great Fissure"] = true,
        ["The Great Fras Siabi"] = true,
        ["The Great Masquerade"] = true,
        ["The Great Moongraze Hunt"] = true,
        ["The Great Retribution"] = true,
        ["The Great Silver Deceiver"] = true,
        ["The Greatest Race of Hunters"] = true,
        ["The Green Drake"] = true,
        ["The Green Hills of Stranglethorn"] = true,
        ["The Greenwarden"] = true,
        ["The Grizzled Den"] = true,
        ["The Guns of Northwatch"] = true,
        ["The Hammer May Fall"] = true,
        ["The Hand of Gul'dan"] = true,
        ["The Hand of Rastakhan"] = true,
        ["The Hand of the Righteous"] = true,
        ["The Harvester"] = true,
        ["The Haunted Isle"] = true,
        ["The Haunted Mills"] = true,
        ["The Head of the Beast"] = true,
        ["The Heart of Darkness"] = true,
        ["The Heart of the Mountain"] = true,
        ["The Hermit"] = true,
        ["The Hidden Chamber"] = true,
        ["The Hidden Key"] = true,
        ["The Hidden Niche"] = true,
        ["The High Wilderness"] = true,
        ["The Hopeless Ones..."] = true,
        ["The Horde Needs Firebloom!"] = true,
        ["The Horde Needs Heavy Leather!"] = true,
        ["The Horde Needs Mithril Bars!"] = true,
        ["The Horde Needs More Mageweave Bandages!"] = true,
        ["The Horde Needs More Mithril Bars!"] = true,
        ["The Horde Needs More Peacebloom!"] = true,
        ["The Horde Needs More Purple Lotus!"] = true,
        ["The Horde Needs More Rugged Leather!"] = true,
        ["The Horde Needs More Runecloth Bandages!"] = true,
        ["The Horde Needs More Spotted Yellowtail!"] = true,
        ["The Horde Needs More Thick Leather!"] = true,
        ["The Horde Needs Peacebloom!"] = true,
        ["The Horde Needs Purple Lotus!"] = true,
        ["The Horde Needs Rugged Leather!"] = true,
        ["The Horde Needs Runecloth Bandages!"] = true,
        ["The Horde Needs Spotted Yellowtail!"] = true,
        ["The Horde Needs Thick Leather!"] = true,
        ["The Horde Needs Tin Bars!"] = true,
        ["The Horde Needs Wool Bandages!"] = true,
        ["The Horn of the Beast"] = true,
        ["The Horrors of Pollution"] = true,
        ["The Hound-Master"] = true,
        ["The Howling Vale"] = true,
        ["The Howling Wind"] = true,
        ["The Hunt Begins"] = true,
        ["The Hunt Completed"] = true,
        ["The Hunt Continues"] = true,
        ["The Hunter's Charm"] = true,
        ["The Hunter's Way"] = true,
        ["The Ice Guard"] = true,
        ["The Ichor of Undeath"] = true,
        ["The Impotent Leader"] = true,
        ["The Inconsolable Chieftain"] = true,
        ["The Infernal Orb"] = true,
        ["The Infested Protectors"] = true,
        ["The Instigator's Enchantment"] = true,
        ["The Ironforge Brigade Needs Explosives!"] = true,
        ["The Islander"] = true,
        ["The Isle of Dread!"] = true,
        ["The Jasperlode Mine"] = true,
        ["The Jeremiah Blues"] = true,
        ["The Jewel of Kajaro"] = true,
        ["The Karnitol Shipwreck"] = true,
        ["The Kessel Run"] = true,
        ["The Key to Freedom"] = true,
        ["The Killing Fields"] = true,
        ["The Knife Revealed"] = true,
        ["The Kolkar of Desolace"] = true,
        ["The Kurken is Lurkin'"] = true,
        ["The Kurken's Hide"] = true,
        ["The Last Barov"] = true,
        ["The Last Element"] = true,
        ["The Left Piece of Lord Valthalak's Amulet"] = true,
        ["The Legend of Stalvan"] = true,
        ["The Legion Reborn"] = true,
        ["The Lexicon Demonica"] = true,
        ["The Lich's Identity"] = true,
        ["The Light and How To Swing It"] = true,
        ["The Longbeards"] = true,
        ["The Lord of Blackrock"] = true,
        ["The Lost Caravan"] = true,
        ["The Lost Chalice"] = true,
        ["The Lost Dwarves"] = true,
        ["The Lost Fragments"] = true,
        ["The Lost Ingots"] = true,
        ["The Lost Pages"] = true,
        ["The Lost Pilot"] = true,
        ["The Lost Report"] = true,
        ["The Lost Supplies"] = true,
        ["The Lost Tablets of Mosh'aru"] = true,
        ["The Lost Tablets of Will"] = true,
        ["The Lost Tools"] = true,
        ["The Love Potion"] = true,
        ["The Madness Within"] = true,
        ["The Mag'har"] = true,
        ["The Magister's Apprentice"] = true,
        ["The Main Course!"] = true,
        ["The Mark of Quality"] = true,
        ["The Mark of the Lightbringer"] = true,
        ["The Master Planner"] = true,
        ["The Master's Glaive"] = true,
        ["The Master's Grand Design?"] = true,
        ["The Master's Touch"] = true,
        ["The Mastermind"] = true,
        ["The Matron Protectorate"] = true,
        ["The Medallion of Faith"] = true,
        ["The Mighty U'cha"] = true,
        ["The Mills Overrun"] = true,
        ["The Mind's Eye"] = true,
        ["The Mindless Ones"] = true,
        ["The Minions of Culuthas"] = true,
        ["The Missing Courier"] = true,
        ["The Missing Diplomat"] = true,
        ["The Missing Expedition"] = true,
        ["The Missing Fisherman"] = true,
        ["The Missing Merchant"] = true,
        ["The Missing Orders"] = true,
        ["The Missing Scout"] = true,
        ["The Missing Shipment"] = true,
        ["The Missing Survey Team"] = true,
        ["The Missing War Party"] = true,
        ["The Mistress Revealed"] = true,
        ["The Mithril Kid"] = true,
        ["The Mithril Order"] = true,
        ["The Molten Core"] = true,
        ["The Monogrammed Sash"] = true,
        ["The Morrow Stone"] = true,
        ["The Moss-twined Heart"] = true,
        ["The Mystery of Morrowgrain"] = true,
        ["The Name of the Beast"] = true,
        ["The Nesingwary Safari"] = true,
        ["The New Frontier"] = true,
        ["The New Springs"] = true,
        ["The Newest Member of the Family"] = true,
        ["The Night Watch"] = true,
        ["The Northern Pylon"] = true,
        ["The Ogre Threat"] = true,
        ["The Ogres of Feralas"] = true,
        ["The Old Ways"] = true,
        ["The Only Cure is More Green Glow"] = true,
        ["The Only Prescription"] = true,
        ["The Only Song I Know..."] = true,
        ["The Opening of the Dark Portal"] = true,
        ["The Orb of Soran'ruk"] = true,
        ["The Orc Report"] = true,
        ["The Orebor Harborage"] = true,
        ["The Orgrimmar Legion Needs Mojo!"] = true,
        ["The Origins of Smithing"] = true,
        ["The Outcast's Plight"] = true,
        ["The Pack Mistress"] = true,
        ["The Pariah's Instructions"] = true,
        ["The Party Never Ends"] = true,
        ["The Path of Anguish"] = true,
        ["The Path of Conquest"] = true,
        ["The Path of Glory"] = true,
        ["The Path of the Adept"] = true,
        ["The Path of the Righteous"] = true,
        ["The People's Militia"] = true,
        ["The Perfect Poison"] = true,
        ["The Perfect Stout"] = true,
        ["The Plagued Coast"] = true,
        ["The Platinum Discs"] = true,
        ["The Pledge of Secrecy"] = true,
        ["The Pools of Aggonar"] = true,
        ["The Power to Destroy..."] = true,
        ["The Powers Below"] = true,
        ["The Price of Shoes"] = true,
        ["The Princess Saved?"] = true,
        ["The Princess Trapped"] = true,
        ["The Princess's Surprise"] = true,
        ["The Principal Source"] = true,
        ["The Prison's Bindings"] = true,
        ["The Prison's Casing"] = true,
        ["The Prodigal Lich"] = true,
        ["The Prodigal Lich Returns"] = true,
        ["The Prophecy of Akida"] = true,
        ["The Prophecy of Mosh'aru"] = true,
        ["The Prophecy of Velen"] = true,
        ["The Public Servant"] = true,
        ["The Purest Water"] = true,
        ["The Qiraji Conqueror"] = true,
        ["The Ranger Lord's Behest"] = true,
        ["The Ravaged Caravan"] = true,
        ["The Real Threat"] = true,
        ["The Reason for the Season"] = true,
        ["The Red Crystal"] = true,
        ["The Red Messenger"] = true,
        ["The Relics of Wakening"] = true,
        ["The Remains of Trey Lightforge"] = true,
        ["The Reports"] = true,
        ["The Rescue"] = true,
        ["The Restless Souls"] = true,
        ["The Rethban Gauntlet"] = true,
        ["The Right Piece of Lord Valthalak's Amulet"] = true,
        ["The Ring of Blood: Brokentoe"] = true,
        ["The Ring of Blood: Rokdar the Sundered Lord"] = true,
        ["The Ring of Blood: Skra'gath"] = true,
        ["The Ring of Blood: The Blue Brothers"] = true,
        ["The Ring of Blood: The Final Challenge"] = true,
        ["The Ring of Blood: The Warmaul Champion"] = true,
        ["The Ring of Mmmrrrggglll"] = true,
        ["The Rise of the Machines"] = true,
        ["The Road to Darnassus"] = true,
        ["The Road to Falcon Watch"] = true,
        ["The Rock Flayer Matriarch"] = true,
        ["The Rod of Lianthe"] = true,
        ["The Root of All Evil"] = true,
        ["The Royal Rescue"] = true,
        ["The Ruins of Burning Blade"] = true,
        ["The Ruins of Kel'Theril"] = true,
        ["The Ruins of Solarsal"] = true,
        ["The Ruins of Stardust"] = true,
        ["The Rumormonger"] = true,
        ["The Rune of Summoning"] = true,
        ["The Runed Scroll"] = true,
        ["The Sacred Flame"] = true,
        ["The Sad Truth"] = true,
        ["The Sanctum of the Sun"] = true,
        ["The Savage Guard - Arcanum of Focus"] = true,
        ["The Savage Guard - Arcanum of Protection"] = true,
        ["The Savage Guard - Arcanum of Rapidity"] = true,
        ["The Savior of Kalimdor"] = true,
        ["The Scarlet Crusade"] = true,
        ["The Scent of Lar'korwi"] = true,
        ["The Scepter of Celebras"] = true,
        ["The Scorched Grove"] = true,
        ["The Scourge Cauldrons"] = true,
        ["The Scrimshank Redemption"] = true,
        ["The Scythe of Elune"] = true,
        ["The Search Continues"] = true,
        ["The Second Course..."] = true,
        ["The Second Rebellion"] = true,
        ["The Second Sample"] = true,
        ["The Second Trial"] = true,
        ["The Second and Third Fragments"] = true,
        ["The Seer's Relic"] = true,
        ["The Severed Head"] = true,
        ["The Shade of Elura"] = true,
        ["The Shadow Guard"] = true,
        ["The Shadow Tomb"] = true,
        ["The Shadowmoon Shuffle"] = true,
        ["The Shadowy Figure"] = true,
        ["The Shadowy Search Continues"] = true,
        ["The Sharpest Blades"] = true,
        ["The Shattered Hand"] = true,
        ["The Shattered Necklace"] = true,
        ["The Shattered Salute"] = true,
        ["The Shieldsmith"] = true,
        ["The Shimmering Frond"] = true,
        ["The Shrine of Dath'Remar"] = true,
        ["The Sigil of Krasus"] = true,
        ["The Singing Crystals"] = true,
        ["The Siren's Coral"] = true,
        ["The Sketh'lon Wreckage"] = true,
        ["The Skettis Offensive"] = true,
        ["The Slaughtered Lamb"] = true,
        ["The Sleeper Has Awakened"] = true,
        ["The Sleeping Druid"] = true,
        ["The Smallest Creatures"] = true,
        ["The Smoldering Ruins of Thaurissan"] = true,
        ["The So-Called Mark of the Lightbringer"] = true,
        ["The Softest Wings"] = true,
        ["The Soul Devices"] = true,
        ["The Spearcrafter's Hammer"] = true,
        ["The Spectral Chalice"] = true,
        ["The Spider God"] = true,
        ["The Spirit Polluted"] = true,
        ["The Spirits Have Voices"] = true,
        ["The Spirits of Southwind"] = true,
        ["The Spirits of Stonetalon"] = true,
        ["The Sporelings' Plight"] = true,
        ["The Sprouted Fronds"] = true,
        ["The Spy Revealed!"] = true,
        ["The Stagnant Oasis"] = true,
        ["The Stave of Equinex"] = true,
        ["The Stockade Riots"] = true,
        ["The Stolen Journal"] = true,
        ["The Stolen Tome"] = true,
        ["The Stone"] = true,
        ["The Stone Circle"] = true,
        ["The Stone Watcher"] = true,
        ["The Stone of the Tides"] = true,
        ["The Stones That Bind Us"] = true,
        ["The Stones of Vekh'nir"] = true,
        ["The Strength of Corruption"] = true,
        ["The Summoning"] = true,
        ["The Summoning Chamber"] = true,
        ["The Sun Gate"] = true,
        ["The Sunfury Garrison"] = true,
        ["The Sunken Temple"] = true,
        ["The Super Snapper FX"] = true,
        ["The Swamp Talker"] = true,
        ["The Swarm Grows"] = true,
        ["The Tear of the Moons"] = true,
        ["The Tempest Key"] = true,
        ["The Temple of Atal'Hakkar"] = true,
        ["The Temple of Telhamat"] = true,
        ["The Terror of Marshlight Lake"] = true,
        ["The Test of Righteousness"] = true,
        ["The Thandol Span"] = true,
        ["The Theramore Docks"] = true,
        ["The Third Fleet"] = true,
        ["The Throne of the Elements"] = true,
        ["The Thunderspike"] = true,
        ["The Tome of Divinity"] = true,
        ["The Tome of Valor"] = true,
        ["The Torch of Retribution"] = true,
        ["The Tortured Earth"] = true,
        ["The Totem of Infliction"] = true,
        ["The Totem of Kar'dash"] = true,
        ["The Totems of My Enemy"] = true,
        ["The Touch of Zanzil"] = true,
        ["The Tower of Althalaxx"] = true,
        ["The Traitor's Destruction"] = true,
        ["The Traitor's Shadow"] = true,
        ["The Trappings of a Vindicator"] = true,
        ["The Treasure of the Shen'dralar"] = true,
        ["The Trogg Threat"] = true,
        ["The Troll Cave"] = true,
        ["The Troll Witchdoctor"] = true,
        ["The True Masters"] = true,
        ["The Truth Comes Crashing Down"] = true,
        ["The Truth Unorbed"] = true,
        ["The Twilight Camp"] = true,
        ["The Twilight Lexicon"] = true,
        ["The Twilight Mystery"] = true,
        ["The Twin Clefts of Nagrand"] = true,
        ["The Twin Ziggurats"] = true,
        ["The Ultimate Bloodsport"] = true,
        ["The Ultimate Deception"] = true,
        ["The Umbrafen Tribe"] = true,
        ["The Undermarket"] = true,
        ["The Underneath"] = true,
        ["The Unending Invasion"] = true,
        ["The Unmarred Vision of Voodress"] = true,
        ["The Unsent Letter"] = true,
        ["The Unwritten Prophecy"] = true,
        ["The Vengeful Harbinger"] = true,
        ["The Venture Co."] = true,
        ["The Videre Elixir"] = true,
        ["The Vile Reef"] = true,
        ["The Warchief's Mandate"] = true,
        ["The Warden's Cage"] = true,
        ["The Warlord's Hideout"] = true,
        ["The Warp Rifts"] = true,
        ["The Warsong Reports"] = true,
        ["The Way of the Weaponsmith"] = true,
        ["The Way to Auberdine"] = true,
        ["The Wayward Apprentice"] = true,
        ["The Weathered Grave"] = true,
        ["The Weaver"] = true,
        ["The Western Pylon"] = true,
        ["The Wildlife Suffers Too"] = true,
        ["The Will of the Warchief"] = true,
        ["The Windwatcher"] = true,
        ["The Woodland Protector"] = true,
        ["The Woodpaw Gnolls"] = true,
        ["The Work of Grimand Elmore"] = true,
        ["The World At Your Feet"] = true,
        ["The World's Largest Gnome!"] = true,
        ["The Writhing Deep"] = true,
        ["The Wrong Stuff"] = true,
        ["The Zapthrottle Mote Extractor!"] = true,
        ["The Zhevra"] = true,
        ["The Zoram Strand"] = true,
        ["Theldurin the Lost"] = true,
        ["Thelsamar Blood Sausages"] = true,
        ["Theocritus' Retrieval"] = true,
        ["Theramore Spies"] = true,
        ["There Can Be Only One Response"] = true,
        ["There Is No Hope"] = true,
        ["There's No Explanation for Fashion"] = true,
        ["Therylune's Escape"] = true,
        ["Therzok"] = true,
        ["They Call Him Smiling Jim"] = true,
        ["They Call Me \"The Rooster\""] = true,
        ["They Stole Me Hookah and Me Brews!"] = true,
        ["They're Alive! Maybe..."] = true,
        ["Thick Hydra Scales"] = true,
        ["Thin the Flock"] = true,
        ["Thinning the Ranks"] = true,
        ["Thirst Unending"] = true,
        ["This Is Going to Be Hard"] = true,
        ["Thistleshrub Valley"] = true,
        ["Thorium Widget"] = true,
        ["Those Blasted Troggs!"] = true,
        ["Threat From the Sea"] = true,
        ["Threat of the Winterfall"] = true,
        ["Three Kings of Flame"] = true,
        ["Through the Dark Portal"] = true,
        ["Thule Ravenclaw"] = true,
        ["Thun'grim Firegaze"] = true,
        ["Thunderaan the Windseeker"] = true,
        ["Thunderbrew Lager"] = true,
        ["Thunderhorn Cleansing"] = true,
        ["Thunderhorn Totem"] = true,
        ["Thunderlord Clan Artifacts"] = true,
        ["Thundris Windweaver"] = true,
        ["Thwart the Dark Conclave"] = true,
        ["Thwarting Kolkar Aggression"] = true,
        ["Tiara of the Deep"] = true,
        ["Tiara of the Oracle"] = true,
        ["Tiger Mastery"] = true,
        ["Timber Worg Tails"] = true,
        ["Timberling Seeds"] = true,
        ["Timberling Sprouts"] = true,
        ["Time To Strike"] = true,
        ["Tinkee Steamboil"] = true,
        ["To Catch A Thistlehead"] = true,
        ["To Gadgetzan You Go!"] = true,
        ["To Ironforge for Yagyin's Digest"] = true,
        ["To Kill With Purpose"] = true,
        ["To Legion Hold"] = true,
        ["To Meet Mother Kashur"] = true,
        ["To Netherwing Ledge!"] = true,
        ["To Serve Kum'isha"] = true,
        ["To Show Due Judgment"] = true,
        ["To Steal From Thieves"] = true,
        ["To The Bulwark"] = true,
        ["To The Hinterlands"] = true,
        ["To Winterspring!"] = true,
        ["To the Stormspire"] = true,
        ["To the Top"] = true,
        ["To the Undercity for Yagyin's Digest"] = true,
        ["Tomb of the Lightbringer"] = true,
        ["Tomber's Supplies"] = true,
        ["Tome of Divinity"] = true,
        ["Tome of the Cabal"] = true,
        ["Too Many Mouths to Feed"] = true,
        ["Tooga's Quest"] = true,
        ["Tools for Steelgrill"] = true,
        ["Tools of the Highborne"] = true,
        ["Tools of the Trade"] = true,
        ["Torching Sunfury Hold"] = true,
        ["Torek's Assault"] = true,
        ["Torgos!"] = true,
        ["Tormented By the Past"] = true,
        ["Tormus Deepforge"] = true,
        ["Torn Bear Pelts"] = true,
        ["Torwa Pathfinder"] = true,
        ["Totem of Coo"] = true,
        ["Totem of Tikti"] = true,
        ["Totem of Vark"] = true,
        ["Totem of Yor"] = true,
        ["Touch of Weakness"] = true,
        ["Towers and Bunkers"] = true,
        ["Toxic Horrors"] = true,
        ["Toxic Test"] = true,
        ["Tracking Down the Culprits"] = true,
        ["Training the Beast"] = true,
        ["Traitor to the Bloodsail"] = true,
        ["Tramping Paws"] = true,
        ["Trampled Under Foot"] = true,
        ["Tran'rek"] = true,
        ["Translate Abercrombie's Note"] = true,
        ["Translating the Journal"] = true,
        ["Translating the Ledger"] = true,
        ["Translation to Ello"] = true,
        ["Translations..."] = true,
        ["Trapping the Light Fantastic"] = true,
        ["Travel to Azure Watch"] = true,
        ["Travel to Darkshire"] = true,
        ["Treant Muisek"] = true,
        ["Treats for Greatfather Winter"] = true,
        ["Tree's Company"] = true,
        ["Treebole Must Know"] = true,
        ["Trek to Ashenvale"] = true,
        ["Trelane's Defenses"] = true,
        ["Tremors of the Earth"] = true,
        ["Triage"] = true,
        ["Trial and Error"] = true,
        ["Trial at the Field of Giants"] = true,
        ["Triangulation Point One"] = true,
        ["Triangulation Point Two"] = true,
        ["Tribal Leatherworking"] = true,
        ["Tribes at War"] = true,
        ["Trinkets..."] = true,
        ["Trol'kalar"] = true,
        ["Troll Charm"] = true,
        ["Troll Juju"] = true,
        ["Troll Necklace Bounty"] = true,
        ["Troll Temper"] = true,
        ["Troll Witchery"] = true,
        ["Trollbane"] = true,
        ["Trollbane is Looking for You"] = true,
        ["Trolls of a Feather"] = true,
        ["Trouble In Darkshore?"] = true,
        ["Trouble at Auchindoun"] = true,
        ["Trouble at the Docks"] = true,
        ["Trouble at the Underlight Mines"] = true,
        ["Trouble in Winterspring!"] = true,
        ["Trouble in the Deeps"] = true,
        ["Troubled Spirits of Kel'Theril"] = true,
        ["Troublesome Distractions"] = true,
        ["True Believers"] = true,
        ["Trueflight Arrows"] = true,
        ["Truth or Fiction"] = true,
        ["Tumors"] = true,
        ["Tundra MacGrann's Stolen Stash"] = true,
        ["Turning Point"] = true,
        ["Turning the Tide"] = true,
        ["Twilight Battle Orders"] = true,
        ["Twilight Falls"] = true,
        ["Twilight Geolords"] = true,
        ["Twilight Marauders"] = true,
        ["Twilight Ring of Lordship"] = true,
        ["Twilight of the Dawn Runner"] = true,
        ["Twisted Evils"] = true,
        ["Twisted Hatred"] = true,
        ["Two Halves Become One"] = true,
        ["Tyrande and Remulos"] = true,
        ["Ula'elek and the Brutal Gauntlets"] = true,
        ["Ulag the Cleaver"] = true,
        ["Ulathek the Traitor"] = true,
        ["Uldaman Reagent Run"] = true,
        ["Umbrafen Eel Filets"] = true,
        ["Un'Goro Soil"] = true,
        ["Un-Life's Little Annoyances"] = true,
        ["Uncatalogued Species"] = true,
        ["Unclaimed Baggage"] = true,
        ["Uncle Carlin"] = true,
        ["Uncovering the Past"] = true,
        ["Undamaged Venom Sac"] = true,
        ["Under Whose Orders?"] = true,
        ["Under the Chitin Was..."] = true,
        ["Underbelly Scales"] = true,
        ["Undercutting the Competition"] = true,
        ["Underground Assault"] = true,
        ["Underlight Ore Samples"] = true,
        ["Understanding the Mok'Nathal"] = true,
        ["Underworld Loam"] = true,
        ["Unexpected Results"] = true,
        ["Unfinished Business"] = true,
        ["Unfortunate Measures"] = true,
        ["Uniting the Shattered Amulet"] = true,
        ["Unlocking the Compendium"] = true,
        ["Unruly Neighbors"] = true,
        ["Unstable Mana Crystals"] = true,
        ["Until Death Do Us Part"] = true,
        ["Up to Snuff"] = true,
        ["Update for Sentinel Thenysil"] = true,
        ["Ur's Treatise on Shadow Magic"] = true,
        ["Urgent Delivery"] = true,
        ["Urgent Delivery!"] = true,
        ["Urok Doomhowl"] = true,
        ["Ursal the Mauler"] = true,
        ["Ursangous's Paw"] = true,
        ["Ursius of the Shardtooth"] = true,
        ["Us or Them"] = true,
        ["Vahlarriel's Search"] = true,
        ["Valik"] = true,
        ["Vanquish the Betrayers"] = true,
        ["Vanquishing Aquantion"] = true,
        ["Veil Lithic: Preemptive Strike"] = true,
        ["Veil Rhaze: Unliving Evil"] = true,
        ["Veil Shalas: Signal Fires"] = true,
        ["Veil Skith: Darkstone of Terokk"] = true,
        ["Vejrek"] = true,
        ["Velinde Starsong"] = true,
        ["Velinde's Effects"] = true,
        ["Velora Nitely and the Brutal Legguards"] = true,
        ["Vengeance on the Northspring"] = true,
        ["Venom Bottles"] = true,
        ["Venom to the Undercity"] = true,
        ["Venture Company Mining"] = true,
        ["Verdant Sigil"] = true,
        ["Verifying the Corruption"] = true,
        ["Verog the Dervish"] = true,
        ["Vessels of Power"] = true,
        ["Vestments of the Wolf Spirit"] = true,
        ["Veteran Uzzek"] = true,
        ["Veteran's Battlegear"] = true,
        ["Vibrant Plumes"] = true,
        ["Victims of Corruption"] = true,
        ["Victory for the Alliance"] = true,
        ["Victory for the Horde"] = true,
        ["Vile Familiars"] = true,
        ["Vile Idolatry"] = true,
        ["Vile Plans"] = true,
        ["Vile Satyr! Dryads in Danger!"] = true,
        ["Vilebranch Hooligans"] = true,
        ["Villains of Darrowshire"] = true,
        ["Vindicator Aldar"] = true,
        ["Vindicator's Rest"] = true,
        ["Vision Guide"] = true,
        ["Vision of the Dead"] = true,
        ["Visit the Herbalist"] = true,
        ["Vital Intelligence"] = true,
        ["Vital Supplies"] = true,
        ["Vivian Lagrave"] = true,
        ["Vivian Lagrave and the Darkstone Tablet"] = true,
        ["Void Ridge"] = true,
        ["Voidwalkers Gone Wild"] = true,
        ["Volatile Mutations"] = true,
        ["Volcanic Activity"] = true,
        ["Volunteer's Battlegear"] = true,
        ["Voodoo Dues"] = true,
        ["Voodoo Feathers"] = true,
        ["Voren'thal's Visions"] = true,
        ["Vorlus Vilehoof"] = true,
        ["Vorrel's Revenge"] = true,
        ["Vorsha the Lasher"] = true,
        ["Vulture's Vigor"] = true,
        ["Vyletongue Corruption"] = true,
        ["Vyral the Vile"] = true,
        ["Vyrin's Revenge"] = true,
        ["WANTED: Andre Firebeard"] = true,
        ["WANTED: Baron Longshore"] = true,
        ["WANTED: Baron Vardus"] = true,
        ["WANTED: Boss Grog'ak"] = true,
        ["WANTED: Caliph Scorpidsting"] = true,
        ["WANTED: Chok'sul"] = true,
        ["WANTED: Deathclaw"] = true,
        ["WANTED: Murkdeep!"] = true,
        ["WANTED: Overseer Maltorius"] = true,
        ["WANTED: Syndicate Personnel"] = true,
        ["Wait for Sirra to Finish"] = true,
        ["Waking Legends"] = true,
        ["Wand over Fist"] = true,
        ["Wand to Bethor"] = true,
        ["Wandering Shay"] = true,
        ["Wanted - Arnak Grimtotem"] = true,
        ["Wanted! Marez Cowl"] = true,
        ["Wanted! Otto and Falconcrest"] = true,
        ["Wanted: Annihilator Servo!"] = true,
        ["Wanted: Blacktalon the Savage"] = true,
        ["Wanted: Bonelashers Dead!"] = true,
        ["Wanted: Chieftain Mummaki"] = true,
        ["Wanted: DWARVES!"] = true,
        ["Wanted: Durn the Hungerer"] = true,
        ["Wanted: Gath'Ilzogg"] = true,
        ["Wanted: Giselda the Crone"] = true,
        ["Wanted: Knucklerot and Luzran"] = true,
        ["Wanted: Lieutenant Fangore"] = true,
        ["Wanted: Maggot Eye"] = true,
        ["Wanted: Thaelis the Hungerer"] = true,
        ["Wanted: Vile Priestess Hexx and Her Minions"] = true,
        ["Wanted: Worg Master Kruush"] = true,
        ["Wanted: Zorbo the Advisor"] = true,
        ["Wanted: \"Hogger\""] = true,
        ["War Banners"] = true,
        ["War at Sea"] = true,
        ["War on Deatholme"] = true,
        ["War on the Shadowsworn"] = true,
        ["War on the Warmaul"] = true,
        ["War on the Woodpaw"] = true,
        ["Warden Hamoot"] = true,
        ["Warlock Training"] = true,
        ["Warlord Krellian"] = true,
        ["Warlord Sriss'tiz"] = true,
        ["Warlord of the Bleeding Hollow"] = true,
        ["Warlord's Command"] = true,
        ["Warn Area 52!"] = true,
        ["Warn Your People"] = true,
        ["Warning Fairbreeze Village"] = true,
        ["Warning the Cenarion Circle"] = true,
        ["Warp-Raider Nesaad"] = true,
        ["Warrior Kinship"] = true,
        ["Warrior Training"] = true,
        ["Warsong Outrider Update"] = true,
        ["Warsong Runner Update"] = true,
        ["Warsong Saw Blades"] = true,
        ["Warsong Scout Update"] = true,
        ["Warsong Supplies"] = true,
        ["Washed Ashore"] = true,
        ["Washte Pawne"] = true,
        ["Wasteland"] = true,
        ["Wastewander Justice"] = true,
        ["Watcher Leesa'oh"] = true,
        ["Water Elementals"] = true,
        ["Water Pouch Bounty"] = true,
        ["Waters of Xavian"] = true,
        ["Weaken the Ramparts"] = true,
        ["Weapons of Choice"] = true,
        ["Weapons of Elunite"] = true,
        ["Weapons of Spirit"] = true,
        ["Webwood Egg"] = true,
        ["Webwood Venom"] = true,
        ["Welcome to the Jungle"] = true,
        ["Welcome!"] = true,
        ["Welcoming the Wolf Spirit"] = true,
        ["Well of Corruption"] = true,
        ["Wenikee Boltbucket"] = true,
        ["Westbrook Garrison Needs Help!"] = true,
        ["Westfall Stew"] = true,
        ["Wharfmaster Dizzywig"] = true,
        ["What Are These Things?"] = true,
        ["What Argus Means to Me"] = true,
        ["What Book? I Don't See Any Book."] = true,
        ["What Comes Around..."] = true,
        ["What Happens in Terokkar Stays in Terokkar"] = true,
        ["What Is Going On?"] = true,
        ["What Must Be Done..."] = true,
        ["What Niby Commands"] = true,
        ["What Strange Creatures..."] = true,
        ["What Tomorrow Brings"] = true,
        ["What We Don't Know..."] = true,
        ["What We Know..."] = true,
        ["What the Flux?"] = true,
        ["What the Soul Sees"] = true,
        ["What the Wind Carries"] = true,
        ["What's Wrong at Cenarion Thicket?"] = true,
        ["Wheel of the Black March"] = true,
        ["Whelps of the Wyrmcult"] = true,
        ["When Nature Goes Too Far"] = true,
        ["When Spirits Speak"] = true,
        ["When This Mine's a-Rockin'"] = true,
        ["When Worlds Collide..."] = true,
        ["When the Cows Come Home"] = true,
        ["Where Did Those Darn Gnomes Go?"] = true,
        ["Where's Wyllithen?"] = true,
        ["Whirlwind Weapon"] = true,
        ["Whirring Bronze Gizmo"] = true,
        ["Whiskey Slim's Lost Grog"] = true,
        ["Whispers of the Raven God"] = true,
        ["Whispers on the Wind"] = true,
        ["Whitebark's Memory"] = true,
        ["Who Are They?"] = true,
        ["Wild Guardians"] = true,
        ["Wild Hearts"] = true,
        ["Wild Leather Armor"] = true,
        ["Wild Leather Boots"] = true,
        ["Wild Leather Helmet"] = true,
        ["Wild Leather Leggings"] = true,
        ["Wild Leather Shoulders"] = true,
        ["Wild Leather Vest"] = true,
        ["Wildeyes"] = true,
        ["Wildkin E'ko"] = true,
        ["Wildkin of Elune"] = true,
        ["Wildmane Cleansing"] = true,
        ["Wildmane Totem"] = true,
        ["Williden's Journal"] = true,
        ["Willix the Importer"] = true,
        ["Wind Rider"] = true,
        ["Wind Trader Lathrai"] = true,
        ["Windows to the Source"] = true,
        ["Windroc Mastery"] = true,
        ["Windrunner Village"] = true,
        ["Winds in the Desert"] = true,
        ["Wine Shop Advert"] = true,
        ["Wing Commander Gryphongar"] = true,
        ["Winter's Presents"] = true,
        ["Winterfall Activity"] = true,
        ["Winterfall E'ko"] = true,
        ["Winterfall Firewater"] = true,
        ["Winterfall Intrusion"] = true,
        ["Winterfall Ritual Totem"] = true,
        ["Winterfall Runners"] = true,
        ["Winterhoof Cleansing"] = true,
        ["Wisdom of Agamaggan"] = true,
        ["Witherbark Cages"] = true,
        ["Withered Basidium"] = true,
        ["Withered Flesh"] = true,
        ["Wolves Across the Border"] = true,
        ["Wolves at Our Heels"] = true,
        ["Woodpaw Investigation"] = true,
        ["Word from Azure Watch"] = true,
        ["Word from the Spire"] = true,
        ["Words of the High Chief"] = true,
        ["Worgen in the Woods"] = true,
        ["Worth Its Weight in Gold"] = true,
        ["Wounded Ancients"] = true,
        ["Wrath of the Blue Flight"] = true,
        ["Wrenix of Ratchet"] = true,
        ["Wretched Ringleader"] = true,
        ["Writ of Safe Passage"] = true,
        ["Writhing Haunt Cauldron"] = true,
        ["Wyrmskull Watcher"] = true,
        ["Xorothian Stardust"] = true,
        ["Xylem's Payment to Jediga"] = true,
        ["Yorus Barleybrew"] = true,
        ["You Have Served Us Well"] = true,
        ["You Survived!"] = true,
        ["You Too Good."] = true,
        ["You're Fired!"] = true,
        ["You're Hired!"] = true,
        ["You're a Mean One..."] = true,
        ["Young Crocolisk Skins"] = true,
        ["Young Lovers"] = true,
        ["Your Fortune Awaits You..."] = true,
        ["Your Place In The World"] = true,
        ["Ysera's Tears"] = true,
        ["Yuka Screwspigot"] = true,
        ["Zaeldarr the Outcast"] = true,
        ["Zalazane"] = true,
        ["Zamek's Distraction"] = true,
        ["Zandalarian Shadow Mastery Talisman"] = true,
        ["Zando'zan"] = true,
        ["Zanzil's Mixture and a Fool's Stout"] = true,
        ["Zanzil's Secret"] = true,
        ["Zapped Giants"] = true,
        ["Zapper Fuel"] = true,
        ["Zenn's Bidding"] = true,
        ["Zeth'Gor Must Burn!"] = true,
        ["Zinge's Delivery"] = true,
        ["Ziz Fizziks"] = true,
        ["Zombie Juice"] = true,
        ["Zukk'ash Infestation"] = true,
        ["Zukk'ash Report"] = true,
        ["Zul'Marosh"] = true,
        ["Zuluhed the Whacked"] = true,
        ["\"Pretty Boy\" Duncan"] = true,
        ["rAnS0m"] = true,
} end)

BabbleQuest:RegisterTranslations("deDE", function() return {
	-- Quest names (3808)
	-- translation by Warloxx (updated by Farook)
	["... and Bugs"] = "...und Käfer",
	["... and a Batch of Ooze"] = "...und eine Menge Brühschlammer",
	["...and a Time for Action"] = "...und Zeit zu Handeln",
	["10 Tickets - Last Month's Mutton"] = "10 Lose - Hammel des letzten Monats",
	["12 Tickets - Lesser Darkmoon Prize"] = "12 Lose - Geringer Dunkelmond-Preis",
	["1200 Tickets - Amulet of the Darkmoon"] = "1200 Lose - Amulett des Dunkelmonds",
	["1200 Tickets - Orb of the Darkmoon"] = "1200 Lose - Kugel des Dunkelmonds",
	["40 Tickets - Greater Darkmoon Prize"] = "40 Lose - Großer Dunkelmond-Preis",
	["40 Tickets - Schematic: Steam Tonk Controller"] = "40 Lose - Bauplan: Dampfpanzersteuerung",
	["5 Tickets - Darkmoon Flower"] = "5 Lose - Dunkelmond-Blume",
	["5 Tickets - Minor Darkmoon Prize"] = "5 Lose - Kleiner Dunkelmond-Preis",
	["50 Tickets - Darkmoon Storage Box"] = "50 Lose - Dunkelmond-Lagerbehälter",
	["A Bad Egg"] = "Ein schlechtes Ei",
	["A Baying of Gnolls"] = "Das Bellen der Gnolle",
	["A Better Ingredient"] = "Eine bessere Zutat",
	["A Bijou for Zanza"] = "Ein Schmuckstück für Zanza",
	["A Binding Contract"] = "Ein verbindlicher Vertrag",
	["A Bird's-Eye View"] = "Aus der Vogelperspektive",
	["A Blue Light Bargain"] = "Ein Sonderangebot",
	["A Boar's Vitality"] = "Lebenskraft des Ebers",
	["A Boaring Time for Grulloc"] = "Grulloc einen Eber aufbinden",
	["A Broken Trap"] = "Die beschädigte Falle",
	["A Bump in the Road"] = "Eine Straßenunebenheit",
	["A Bundle of Hides"] = "Ein Bündel Bälge",
	["A Bundle of Trouble"] = "Ein Bündel Probleme",
	["A Burden of Souls"] = "Eine Last auf der Seele",
	["A Carefully Wrapped Present"] = "sorgfältig verpacktes Geschenk",
	["A Cleansing Light"] = "Ein reinigendes Licht",
	["A Collection of Heads"] = "Die Schädelsammlung",
	["A Convincing Disguise"] = "Eine überzeugende Verkleidung",
	["A Crew Under Fire"] = "Eine Mannschaft in Bedrängnis",
	["A Crumpled Up Note"] = "Eine zusammengeknüllte Notiz",
	["A Cry For Help"] = "Ein Hilferuf",
	["A Cure for Zahlia"] = "Ein Heilmittel für Zahlia",
	["A Curse Upon Both of Your Clans!"] = "Verflucht seien Eure beiden Klans!",
	["A Dandy's Best Friend"] = "A Dandy's Best Friend", --Missing translation
	["A Dark Pact"] = "Ein dunkler Pakt",
	["A Dark Threat Looms"] = "Eine dunkle Bedrohung",
	["A Date with Dorgok"] = "Ein Treffen mit Dorgok",
	["A Daughter's Love"] = "Die Liebe einer Tochter",
	["A Debilitating Sickness"] = "Eine erschöpfende Krankheit",
	["A Defector"] = "Ein Abtrünniger",
	["A Different Approach"] = "Eine andere Lösung",
	["A Dip in the Moonwell"] = "Ein Tauchgang im Mondbrunnen",
	["A Dire Situation"] = "Eine düstere Lage",
	["A Discreet Inquiry"] = "Eine diskrete Anfrage",
	["A Dwarf and His Tools"] = "Ein Zwerg und sein Werkzeug",
	["A Fate Worse Than Death"] = "Schlimmer als der Tod",
	["A Favor for Evershine"] = "Ein Gefallen für etwas Immerschimmer",
	["A Favorite Treat"] = "Lieblingsleckerli",
	["A Festive Gift"] = "Festtagsgeschenk",
	["A Final Blow"] = "Der endgültige Schlag",
	["A Fine Egg"] = "Ein gutes Ei",
	["A Fine Mess"] = "Eine schöne Bescherung",
	["A Fishy Peril"] = "Gefahr aus dem Wasser",
	["A Fistful of Slivers"] = "Eine Hand voll Fragmente",
	["A Free Lunch"] = "Ein geschenktes Mittagessen",
	["A Friend in Need"] = "Ein Freund in Not",
	["A Gaily Wrapped Present"] = "fröhlich verpacktes Geschenk",
	["A Gallon of Blood"] = "Eine Gallone Blut",
	["A Gesture of Goodwill"] = "Eine Geste des guten Willens",
	["A Ghost in the Machine"] = "Spiritus ex machina",
	["A Gift for Voren'thal"] = "Ein Geschenk für Voren'thal",
	["A Gnome's Assistance"] = "Die Hilfe des Gnoms",
	["A Gnome's Respite"] = "Der Aufschub des Gnoms",
	["A Good Friend"] = "Ein guter Freund",
	["A Good Head On Your Shoulders"] = "Ein schlauer Kopf auf den Schultern",
	["A Grave Situation"] = "Grabesstille",
	["A Grim Discovery"] = "Eine grausige Entdeckung",
	["A Grim Task"] = "Eine grausige Aufgabe",
	["A Grunt's Work..."] = "Routinearbeiten",
	["A Handful of Magic Dust"] = "A Handful of Magic Dust", --Missing translation
	["A Hasty Departure"] = "A Hasty Departure", --Missing translation
	["A Haunted History"] = "Eine Spukgeschichte",
	["A Head Full of Ivory"] = "Ein ganzer Kopf voll Elfenbein",
	["A Heap of Ethereals"] = "Ein Hügel voll Astraler",
	["A Helping Hand"] = "Eine helfende Hand",
	["A Hero Is Needed"] = "Wir brauchen einen Helden!",
	["A Hero's Reward"] = "Die Belohnung eines Helden",
	["A Hero's Welcome"] = "Der Empfang eines Helden",
	["A Host of Evil"] = "Ein Hort des Bösen",
	["A Humble Offering"] = "Eine bescheidene Darbringung",
	["A Humble Task"] = "Eine bescheidene Bitte",
	["A Hunter's Boast"] = "Das Prahlen eines Jägers",
	["A Hunter's Challenge"] = "Die Herausforderung eines Jägers",
	["A Husband's Last Battle"] = "Eines Ehemanns letzter Kampf",
	["A Husband's Revenge"] = "Rache eines Ehemanns",
	["A Job Undone"] = "Unerledigte Arbeit",
	["A Job for an Intelligent Man"] = "Eine Aufgabe für einen intelligenten Helden",
	["A King's Tribute"] = "Ehrerbietung von einem König",
	["A Lack of Fear"] = "Furchtlos",
	["A Land Filled with Hatred"] = "Ein Land voller Hass",
	["A Lesson Learned"] = "Eine Lektion gelernt",
	["A Letter Undelivered"] = "Ein nie zugestellter Brief",
	["A Lingering Suspicion"] = "Ein hartnäckiger Verdacht",
	["A Little Dash of Seasoning"] = "In der Würze liegt der Tod",
	["A Little Help From My Friends"] = "Etwas Hilfe von guten Freunden",
	["A Little Slime Goes a Long Way"] = "Brühschlammer auf Abwegen",
	["A Lost Master"] = "Ein verirrter Meister",
	["A Map to Where?"] = "Wohin führt die Karte?",
	["A Message to Telaar"] = "Eine Botschaft für Telaar",
	["A Mysterious Portent"] = "Ein mysteriöses Omen",
	["A Necessary Distraction"] = "Eine notwendige Ablenkung",
	["A New Cloak's Sheen"] = "Schimmer für einen neuen Umhang",
	["A New Ore Sample"] = "Eine neue Erzprobe",
	["A New Plague"] = "Eine neue Seuche",
	["A New Threat"] = "Eine neue Bedrohung",
	["A Noble Brew"] = "Ein nobles Bräu",
	["A Not-So-Modest Proposal"] = "Ein nicht-so-bescheidenes Angebot",
	["A Pawn on the Eternal Board"] = "Eine Spielfigur auf dem Schachbrett der Ewigkeit",
	["A Peon's Burden"] = "Die Bürde eines Peons",
	["A Personal Favor"] = "Ein persönlicher Gefallen",
	["A Pilgrim's Plight"] = "Die Pflicht eines Pilgers",
	["A Pilot's Revenge"] = "Pilotenrache",
	["A Plague Upon Thee"] = "Eine Plage komme über Euch",
	["A Portable Power Source"] = "Eine portable Energiequelle",
	["A Promising Start"] = "Ein viel versprechender Anfang",
	["A Proper String"] = "Die passende Sehne",
	["A Putrid Task"] = "Eine eitrige Aufgabe",
	["A Question of Gluttony"] = "Eine Frage der Fressgier",
	["A Rare Bean"] = "Eine seltene Bohne",
	["A Recipe For Death"] = "Rezept für den Tod",
	["A Refugee's Quandary"] = "Dilemma eines Flüchtlings",
	["A Reliquary of Purity"] = "Ein Reliquiar der Reinheit",
	["A Restorative Draught"] = "Ein Regenerationsgebräu",
	["A Rogue's Deal"] = "Ein Schurkenhandel",
	["A Sacred Burial"] = "Eine heilige Bestattung",
	["A Scroll from Mauren"] = "Eine Rolle von Mauren",
	["A Secret Revealed"] = "Ein gelüftetes Geheimnis",
	["A Shameful Waste"] = "Eine schändliche Verschwendung",
	["A Shifty Merchant"] = "Ein verschlagener Händler",
	["A Short Incubation"] = "Kurz vor dem Schlüpfen",
	["A Shred of Hope"] = "Ein Funken Hoffnung",
	["A Sign of Hope"] = "Ein Hoffnungsschimmer",
	["A Simple Request"] = "Ein simples Anliegen",
	["A Simple Robe"] = "Eine einfache Robe",
	["A Small Start"] = "Ein kleiner Anfang",
	["A Solvent Spirit"] = "Ein geistvolles Getränk",
	["A Somber Task"] = "Eine traurige Aufgabe",
	["A Spirit Ally?"] = "Ein verbündeter Geist?",
	["A Spirit Guide"] = "Spirituelle Führung",
	["A Sticky Situation"] = "Eine schwierige Situation",
	["A Strange Historian"] = "Ein seltsamer Historiker",
	["A Strange One"] = "Eine seltsame Person",
	["A Strange Red Key"] = "Ein merkwürdiger roter Schlüssel",
	["A Strange Request"] = "Eine seltsame Anforderung",
	["A Strange Weapon"] = "Eine seltsame Waffe",
	["A Study in Power"] = "Eine Studie der Macht",
	["A Supernatural Device"] = "Ein übernatürlicher Apparat",
	["A Swift Message"] = "Eine eilige Nachricht",
	["A Tale of Sorrow"] = "Eine Geschichte voller Leid",
	["A Task Unfinished"] = "Eine unvollendete Aufgabe",
	["A Taste of Flame"] = "Eine Kostprobe der Flamme",
	["A Terrible Purpose"] = "Ein teuflischer Plan",
	["A Threat Within"] = "Die Bedrohung von innen",
	["A Threat in Feralas"] = "Eine Bedrohung in Feralas",
	["A Time for Negotiation..."] = "Zeit zu verhandeln...",
	["A Traitor Among Us"] = "Ein Verräter unter uns",
	["A Troubled Spirit"] = "Ein geplagter Geist",
	["A Troubling Breeze"] = "Ein beunruhigender Wind",
	["A Vengeful Fate"] = "Ein schreckliches Schicksal",
	["A Visit With The Ancestors"] = "Ein Besuch bei den Ahnen",
	["A Visit With the Greatmother"] = "Ein Besuch bei der Großmutter",
	["A Visit to Gregan"] = "Ein Besuch bei Gregan",
	["A Warm Welcome"] = "Ein herzliches Willkommen",
	["A Warrior's Training"] = "Die Ausbildung eines Kriegers",
	["A Watchful Eye"] = "Ein wachsames Auge",
	["A Yeti of Your Own"] = "Euer eigener Yeti",
	["Abandoned Hope"] = "Verlorene Hoffnung",
	["Abandoned Investigations"] = "Aufgegebene Untersuchungen",
	["Abjurist Belmara"] = "Bannzauberin Belmara",
	["Above and Beyond"] = "Übertroffen",
	["Abyssal Contacts"] = "Abyssische Kontakte",
	["Abyssal Crests"] = "Abyssische Wappen",
	["Additional Materials"] = "Zusätzliche Materialien",
	["Administering the Salve"] = "Salbe verabreichen",
	["After the Ambush"] = "Nach dem Hinterhalt",
	["Again With the Zapped Giants"] = "Und wieder unter den geschrumpften Riesen",
	["Against All Odds"] = "Gegen alles und jeden",
	["Against Lord Shalzaru"] = "Gegen Lord Shalzaru",
	["Against the Hatecrest"] = "Gegen die Hasskämme",
	["Against the Illidari"] = "Gegen die Illidari",
	["Against the Legion"] = "Gegen die Legion",
	["Agamaggan's Agility"] = "Agammagans Beweglichkeit",
	["Agamaggan's Strength"] = "Agammagans Kraft",
	["Agamand Heirlooms"] = "Agamand-Erbstücke",
	["Agents of Destruction"] = "Agenten der Zerstörung",
	["Aggression"] = "Aggressivität",
	["Agitated Spirits of Skysong"] = "Aufgebrachte Geister des Himmelsweisensees",
	["Agmond's Fate"] = "Agmonds Schicksal",
	["Aiding the Outrunners"] = "Unterstützung für die Kundschafter",
	["Ak'Zeloth"] = "Ak'Zeloth",
	["Akama"] = "Akama",
	["Akama's Promise"] = "Akamas Versprechen",
	["Akiris by the Bundle"] = "Bündelweise Akiris",
	["Aldor No More"] = "Nie mehr Aldor",
	["Alien Ecology"] = "Eine fremdartige Ökologie",
	["Alien Egg"] = "Fremdartiges Ei",
	["Alien Predators"] = "Raubtiere aus einer anderen Welt",
	["Alien Spirits"] = "Fremde Geister",
	["All Along the Watchtowers"] = "Turm um Turm",
	["All Clear!"] = "Freie Bahn!",
	["All That Remains"] = "Was noch bleibt",
	["Allegiance to Cenarion Circle"] = "Treue zum Zirkel des Cenarius",
	["Allegiance to the Aldor"] = "Loyalität gegenüber den Aldor",
	["Allegiance to the Old Gods"] = "Treue zu den Alten Göttern",
	["Allegiance to the Scryers"] = "Loyalität gegenüber den Sehern",
	["Alliance Relations"] = "Allianzbeziehungen",
	["Alliance Trauma"] = "Traumachirurg der Allianz",
	["Alpha Strike"] = "Schlag gegen die Alphas",
	["Altered Beings"] = "Veränderte Wesen",
	["Alther's Mill"] = "Althers Mühle",
	["Altruis"] = "Altruis",
	["Amani Encroachment"] = "Amaniübergriff",
	["Amani Invasion"] = "Angriff der Amani",
	["Ambermill Investigations"] = "Nachforschungen in Mühlenbern",
	["Ammo for Rumbleshot"] = "Munition für Schlingerschuss",
	["Amongst the Ruins"] = "Inmitten der Ruinen",
	["Amulet of Secrets"] = "Amulett der Geheimnisse",
	["An Aggressive Defense"] = "Eine aggressive Verteidigung",
	["An Alternative Alternative"] = "Eine alternative Alternative",
	["An Ambassador of Evil"] = "Ein Botschafter des Bösen",
	["An Ambitious Plan"] = "Ein gewagter Plan",
	["An Apprentice's Enchantment"] = "Des Lehrlings Verzauberung",
	["An Audacious Advance"] = "Ein kühner Angriff",
	["An Audience with the Prince"] = "Eine Audienz beim Prinzen",
	["An Earnest Proposition"] = "Ein aufrichtiges Angebot",
	["An Easy Pickup"] = "Eine einfache Ladung",
	["An Extraordinary Egg"] = "Ein außergewöhnliches Ei",
	["An Imp's Request"] = "Die Bitte eines Wichtels",
	["An Improper Burial"] = "Ein unangemessenes Begräbnis",
	["An Introduction"] = "Eine Einführung",
	["An OOX of Your Own"] = "Ein eigener OOX",
	["An Old Colleague"] = "Ein alter Kollege",
	["An Old Gift"] = "Ein altes Geschenk",
	["An Old History Book"] = "Ein altes Geschichtsbuch",
	["An Ordinary Egg"] = "Ein gewöhnliches Ei",
	["An Orphan Looking For a Home"] = "Waise sucht Zuhause",
	["An Unholy Alliance"] = "Eine unheilige Allianz",
	["An Unnatural Drought"] = "Eine unnatürliche Dürre",
	["An Unseen Hand"] = "Eine ungesehene Hand",
	["An Unusual Patron"] = "Ein ungewöhnlicher Patron",
	["An Unwelcome Guest"] = "Ein ungebetener Gast",
	["An Unwelcome Presence"] = "Unangenehme Gesellschaft",
	["Anachronos"] = "Anachronos",
	["Ancient Sinew Wrapped Lamina"] = "Uraltes in Sehnen eingewickeltes Laminablatt",
	["Ancient Spirit"] = "Alter Geist",
	["Andron's Payment to Jediga"] = "Androns Bezahlung für Jediga",
	["Angling to Beat the Competition"] = "Anglerunglück",
	["Ango'rosh Encroachment"] = "Vordringen der Ango'rosh",
	["Animist's Caress"] = "Liebkosung des Animisten",
	["Anok'suten"] = "Anok'suten",
	["Another Heap of Ethereals"] = "Noch ein Hügel voller Astraler",
	["Another Message to the Wildhammer"] = "Eine weitere Botschaft an die Wildhämmer",
	["Another Power Source?"] = "Eine weitere Kraftquelle?",
	["Ansirem's Key"] = "Ansirems Schlüssel",
	["Answered Questions"] = "Beantwortete Fragen",
	["Anthion's Old Friend"] = "Anthions alter Freund",
	["Anthion's Parting Words"] = "Anthions Abschiedsworte",
	["Anthion's Strange Request"] = "Anthions merkwürdige Anforderung",
	["Apothecary Antonivich"] = "Apotheker Antonivich",
	["Apothecary Zamah"] = "Apothekerin Zamah",
	["Apothecary Zelana"] = "Apothekerin Zelana",
	["Apprentice Angler"] = "Anglerlehrling",
	["Apprentice's Duties"] = "Lehrlingspflichten",
	["Aquatic Form"] = "Wassergestalt",
	["Aquementas"] = "Aquementas",
	["Ar'kelos the Guardian"] = "Arkelos der Wächter",
	["Arachnophobia"] = "Arachnophobie",
	["Araj's Scarab"] = "Arajs Skarabäus",
	["Arakkoa War Path"] = "Der Kriegspfad der Arakkoa",
	["Arathor Basic Care Package"] = "Basisüberlebenspaket von Arathor",
	["Arathor Standard Care Package"] = "Standardüberlebenspaket von Arathor",
	["Arcane Feedback"] = "Arkane Rückkopplung",
	["Arcane Instability"] = "Arkane Instabilität",
	["Arcane Reavers"] = "Arkanhäscher",
	["Arcane Refreshment"] = "Arcane Erfrischung",
	["Arcane Runes"] = "Arkane Runen",
	["Arcane Tomes"] = "Arkane Folianten",
	["Arcanite"] = "Arkanit",
	["Arconus the Insatiable"] = "Arconus der Unersättliche",
	["Arelion's Journal"] = "Arelions Tagebuch",
	["Arelion's Mistress"] = "Arelions Geliebte",
	["Arelion's Secret"] = "Arelions Geheimnis",
	["Arena Master"] = "Meister der Arena",
	["Arikara"] = "Arikara",
	["Armaments for Deception"] = "Waffen zur Täuschung",
	["Armed and Ready"] = "Bewaffnet und bereit",
	["Armor Kits for the Field"] = "Rüstungssets für den Feldeinsatz",
	["Armor Scraps"] = "Mehr Rüstungsfetzen",
	["Arms for the Field"] = "Waffen für den Feldeinsatz",
	["Army of the Black Dragon"] = "Armee des schwarzen Großdrachen",
	["Arrival in Outland"] = "Ankunft in der Scherbenwelt",
	["Arrows Are For Sissies"] = "Pfeile sind was für Memmen",
	["Artifacts of the Blacksilt"] = "Schwarzschlammartefakte",
	["Arugal Must Die"] = "Arugal muss sterben",
	["Arugal's Folly"] = "Arugals Torheit",
	["Arzeth's Demise"] = "Arzeths Untergang",
	["As Water Cascades"] = "Wenn das Wasser fließt",
	["As the Crow Flies"] = "Der Flug der Krähe",
	["Ascension..."] = "Aufstieg...",
	["Asghar's Totem"] = "Asghars Totem",
	["Ashenvale Outrunners"] = "Die Kundschafter des Eschentals",
	["Assassin's Contract"] = "Auftragsmördervertrag",
	["Assassination Plot"] = "Auftragsmordplan",
	["Assault on Fenris Isle"] = "Sturm auf die Insel Fenris",
	["Assault on Zeb'Nowa"] = "Angriff auf Zeb'Nowa",
	["Assault on the Kolkar"] = "Angriff auf die Kolkar",
	["Assessing the Situation"] = "Einschätzung der Situation",
	["Assessing the Threat"] = "Einschätzung der Gefahr",
	["Assisting the Consortium"] = "Dem Konsortium helfen",
	["Astral Knot Garment"] = "Astralknotengewand",
	["At War With The Scarlet Crusade"] = "Im Krieg mit dem Scharlachroten Kreuzzug",
	["Attack on Camp Narache"] = "Angriff auf Camp Narache",
	["Attack on Firewing Point"] = "Angriff auf den Posten der Feuerschwingen",
	["Attack on Zeb'Tela"] = "Angriff auf Zeb'Tela",
	["Attack on the Tower"] = "Angriff auf den Turm",
	["Auchindoun..."] = "Auchindoun...",
	["Audience with the Prophet"] = "Audienz beim Propheten",
	["Auntie Marlene"] = "Tante Marlene",
	["Aurel Goldleaf"] = "Aurel Goldblatt",
	["Aurius' Reckoning"] = "Aurius' Abrechnung",
	["Avenge My Village"] = "Rächt mein Dorf",
	["Avenger's Breastplate"] = "Brustplatte des Rächers",
	["Avenger's Crown"] = "Krone des Rächers",
	["Avenger's Greaves"] = "Schienbeinschützer des Rächers",
	["Avenger's Legguards"] = "Beinschützer des Rächers",
	["Avenger's Pauldrons"] = "Schulterstücke des Rächers",
	["Avenging the Fallen"] = "Die Gefallenen rächen",
	["Avruu's Orb"] = "Avruus Kugel",
	["Azsharite"] = "Azsharit",
	["Azure Templar"] = "Azurblauer Templer",
	["Azuregos's Magical Ledger"] = "Azuregos' magisches Buch",
	["B'naar Console Transcription"] = "Steuerungsabschrift von B'naar",
	["Back to Billy"] = "Zurück zu Billy",
	["Back to Booty Bay"] = "Zurück nach Beutebucht",
	["Back to Darnassus"] = "Zurück nach Darnassus",
	["Back to Thunder Bluff"] = "Zurück nach Donnerfels",
	["Back to Uldaman"] = "Rückkehr nach Uldaman",
	["Back to the Beginning"] = "Zurück zum Anfang",
	["Back to the Chief!"] = "Zurück zum Chef!",
	["Bad Medicine"] = "Schlechte Medizin",
	["Badlands Reagent Run"] = "Reagenziensuche im Ödland",
	["Badlands Reagent Run II"] = "Reagenziensuche im Ödland II",
	["Bailor's Ore Shipment"] = "Bailors Erzlieferung",
	["Balance Must Be Preserved"] = "Das Gleichgewicht muss erhalten bleiben",
	["Band of Unending Life"] = "Band des endlosen Lebens",
	["Band of Vaulted Secrets"] = "Band des behüteten Geheimnisse",
	["Band of Veiled Shadows"] = "Band der Schattenschleier",
	["Bandits!"] = "Banditen!",
	["Bane of the Illidari"] = "Bann der Illidari",
	["Barbaric Battlements"] = "Barbarische Waffenschmiedekunst",
	["Barbecued Buzzard Wings"] = "Gegrillte Bussardflügel",
	["Baron Aquanis"] = "Baron Aquanis",
	["Baron Sablemane"] = "Baron Zobelmähne",
	["Baron Sablemane Has Requested Your Presence"] = "Baron Zobelmähne verlangt nach Euch",
	["Baron Sablemane's Poison"] = "Baron Zobelmähnes Gift",
	["Baron's Demise"] = "Ableben des Barons",
	["Barov Family Fortune"] = "Das Familienvermögen der Barovs",
	["Bartleby the Drunk"] = "Bartleby der Trunkenbold",
	["Bartleby's Mug"] = "Bartlebys Becher",
	["Bartolo's Yeti Fur Cloak"] = "Bartolos Yetifellumhang",
	["Bashal'Aran"] = "Bashal'Aran",
	["Bathran's Hair"] = "Bathranshaar",
	["Battle of Hillsbrad"] = "Kampf um das Hügelland",
	["Battle of Warsong Gulch"] = "Schlacht der Kriegshymnenschlucht",
	["Battle of the Crimson Watch"] = "Die Schlacht an der Purpurwacht",
	["Battle-Mage Dathric"] = "Kampfmagier Dathric",
	["Beached Sea Creature"] = "Gestrandete Meereskreatur",
	["Beached Sea Turtle"] = "Gestrandete Meeresschildkröte",
	["Beads for Salfa"] = "Perlen für Salfa",
	["Bearers of the Plague"] = "Überträger der Seuche",
	["Beast Training"] = "Bestienausbildung",
	["Beasts of the Apocalypse!"] = "Biester aus der Apokalypse!",
	["Beat Bartleby"] = "Besiegt Bartleby",
	["Because Kilrath is a Coward"] = "Weil Kilrath ein Feigling ist",
	["Becoming a Mooncloth Tailor"] = "Wie man ein Mondstoffschneider wird",
	["Becoming a Parent"] = "Elternfreuden",
	["Becoming a Shadoweave Tailor"] = "Wie man ein Schattenzwirnschneider wird",
	["Becoming a Spellfire Tailor"] = "Wie man ein Zauberfeuerschneider wird",
	["Beer Basted Boar Ribs"] = "Eberrippchen in Biersauce",
	["Before Darkness Falls"] = "Bevor die Dunkelheit sich senkt",
	["Befouled by Satyr"] = "Beschmutzt durch Satyrn",
	["Begin the Attack!"] = "Der Angriff soll beginnen!",
	["Beginnings"] = "Anfänge",
	["Behind Enemy Lines"] = "Hinter feindlichen Linien",
	["Behomat"] = "Behomat",
	["Bell of Dethmoora"] = "Die Glocke von Dethmoora",
	["Belt of Faith"] = "Gürtel des Glaubens",
	["Beneath Thrallmar"] = "Unter Thrallmar",
	["Beren's Peril"] = "Berens List",
	["Besieged!"] = "Belagert!",
	["Betina Bigglezink"] = "Betina Moppelzink",
	["Betrayal from Within"] = "Verräter in den eigenen Reihen",
	["Betrayed"] = "Verraten",
	["Better Late Than Never"] = "Besser spät als nie",
	["Between a Rock and a Thistlefur"] = "Hart auf hart",
	["Beware of Pterrordax"] = "Vorsich",
	["Big Black Mace"] = "Großer schwarzer Streitkolben",
	["Big Game Hunter"] = "Großwildjagd",
	["Bijou's Belongings"] = "Bijous Habseligkeiten",
	["Bijou's Reconnaissance Report"] = "Bijous Aufklärungsbericht",
	["Binding the Dreadnaught"] = "Bindung des Schreckenspanzers",
	["Bindings of Faith"] = "Bindungen des Glaubens",
	["Bingles' Missing Supplies"] = "Bingles' verschwundene Werkzeuge",
	["Birds of a Feather"] = "Kommt ein Vogel geflogen",
	["Bitter Rivals"] = "Bittere Rivalen",
	["Blackfathom Villainy"] = "Schurkerei in der Tiefschwarzen Grotte",
	["Blackhand's Command"] = "Schwarzfausts Befehl",
	["Blackmoore's Legacy"] = "Schwarzmoors Vermächtnis",
	["Blackrock Bounty"] = "Kopfgeld auf den Schwarzfelsklan",
	["Blackrock Menace"] = "Bedrohung durch den Schwarzfelsklan",
	["Blacksting's Bane"] = "Schwarzsichels Fluch",
	["Blade of Eternal Justice"] = "Klinge der ewigen Gerechtigkeit",
	["Blade of Vaulted Secrets"] = "Klinge der behüteten Geheimnisse",
	["Bladespire Kegger"] = "Saufgelage der Speerspießer",
	["Blast the Infernals!"] = "Jagt die Höllenbestien in die Luft!",
	["Bleeding Hollow Supply Crates"] = "Vorratskisten des Blutenden Auges",
	["Blessed Arcanite Barding"] = "Gesegnetes Arkanitpferdegeschirr",
	["Blessed Arm"] = "Gesegnete Waffe",
	["Blessing of Incineratus"] = "Segen des Incendius",
	["Blessings of the Ancients"] = "Der Segen der Uralten",
	["Blind Cazul"] = "Der blinde Cazul",
	["Blisters on The Land"] = "Schwärendes Land",
	["Blood Crystals"] = "Blutkristalle",
	["Blood Elf Plans"] = "Blutelfenpläne",
	["Blood Elf Spy"] = "Blutelfenspionage",
	["Blood Feeders"] = "Blutfresser",
	["Blood Shards of Agamaggan"] = "Blutsplitter von Agammagan",
	["Blood Tinged Skies"] = "Blutgefärbter Himmel",
	["Blood Watch"] = "Blutwacht",
	["Blood of the Black Dragon Champion"] = "Blut des schwarzen Großdrachen-Helden",
	["Bloodfury Bloodline"] = "Blutfuriengeschlecht",
	["Bloodgem Crystals"] = "Blutjuwelenkristalle",
	["Bloodpetal Poison"] = "Blutblütengift",
	["Bloodpetal Sprouts"] = "Blutblütensprösslinge",
	["Bloodpetal Zapper"] = "Blutblütenschrumpfer",
	["Bloodscalp Clan Heads"] = "Köpfe des Blutskalpklans",
	["Bloodscalp Ears"] = "Ohren der Blutskalpe",
	["Bloodscalp Insight"] = "Erkenntnisse über die Blutskalpe",
	["Bloody Bone Necklaces"] = "Blutige Knochenhalskette",
	["Bloody Imp-ossible!"] = "Verwichtelt und zugenäht!",
	["Blueleaf Tubers"] = "Blaulaubknollen",
	["Boat Wreckage"] = "Havarie",
	["Bodley's Unfortunate Fate"] = "Bodleys trauriges Schicksal",
	["Body and Heart"] = "Körper und Herz",
	["Body of Evidence"] = "Beweismaterial",
	["Bodyguard for Hire"] = "Leibwache zu mieten",
	["Boiling Blood"] = "Kochendes Blut",
	["Bolstering Our Defenses"] = "Verstärkung der Verteidigung",
	["Bone Collector"] = "Knochensammler",
	["Bone Fragments"] = "Knochenfragmente",
	["Bone-Bladed Weapons"] = "Knochenklingenwaffen",
	["Bonechewer Blood"] = "Blut der Knochenmalmer",
	["Bonescythe Bracers"] = "Armschienen der Knochensense",
	["Bonescythe Breastplate"] = "Brustplatte der Knochensense",
	["Bonescythe Digs"] = "Knochensensenjagd",
	["Bonescythe Gauntlets"] = "Stulpen der Knochensense",
	["Bonescythe Helmet"] = "Helm der Knochensense",
	["Bonescythe Legplates"] = "Beinplatten der Knochensense",
	["Bonescythe Pauldrons"] = "Schulterstücke der Knochensense",
	["Bonescythe Sabatons"] = "Sabatons der Knochensense",
	["Bonescythe Waistguard"] = "Taillenschutz der Knochensense",
	["Book of the Ancients"] = "Buch der Uralten",
	["Bookie Herod"] = "Buchmacher Herod",
	["Booty Bay or Bust!"] = "Auf nach Beutebucht!",
	["Bor Wishes to Speak"] = "Bor möchte Euch sprechen",
	["Border Crossings"] = "Grenzübergänge",
	["Botanical Legwork"] = "Botanische Hilfsarbeit",
	["Botanist Taerix"] = "Botanikerin Taerix",
	["Boulderslide Ravine"] = "Steinschlagklamm",
	["Bound for Glory"] = "Für Ruhm bestimmt",
	["Bounty on Garrick Padfoot"] = "Kopfgeld auf Garrick Schleichfuß",
	["Bounty on Murlocs"] = "Kopfgeld auf die Murlocs",
	["Bracers of Binding"] = "Armschienen der Bindung",
	["Brann Bronzebeard's Lost Letter"] = "Der verlorene Brief von Brann Bronzebart",
	["Breaching the Path"] = "Den Pfad bereinigen",
	["Break Sharptusk!"] = "Tötet Spitzhauer!",
	["Break a Few Eggs"] = "Zerbrecht ein paar Eier",
	["Breaking Down Netherock"] = "Netherbrock zerschmettern",
	["Breaking the Code"] = "Knackt den Kode",
	["Breaking the Keystone"] = "Den Hauptstein zerbrechen",
	["Breaking the Ward"] = "Den Zauberschutz brechen",
	["Breastplate of Bloodthirst"] = "Brustplatte des Blutdurstes",
	["Breastplate of the Chromatic Flight"] = "Brustplatte des Chromatischen Drachenschwarms",
	["Bride of the Embalmer"] = "Braut des Einbalsamierers",
	["Bring Back the Mug"] = "Den Becher zurückbringen",
	["Bring Down the Warbringer!"] = "Nieder mit dem Kriegshetzer!",
	["Bring Me A Shrubbery!"] = "Bringt mir ein Gebüsch!",
	["Bring Me Another Shrubbery!"] = "Bringt mir ein weiteres Gebüsch!",
	["Bring Me Kel'gash's Head!"] = "Bringt mir Kel'gashs Kopf!",
	["Bring Me The Egg!"] = "Bringt mir das Ei!",
	["Bring the End"] = "Das Ende bringen",
	["Bring the Light"] = "Das Licht bringen",
	["Broken Alliances"] = "Zerbrochene Allianzen",
	["Broken Tears"] = "Zerbrochene Tränen",
	["Broodling Essence"] = "Brutlingessenz",
	["Brother Against Brother"] = "Bruder gegen Bruder",
	["Brother Anton"] = "Bruder Anton",
	["Brother Carlin"] = "Bruder Carlin",
	["Brother Paxton"] = "Bruder Paxton",
	["Brotherhood of Thieves"] = "Bruderschaft der Diebe",
	["Brotherhood's End"] = "Das Ende der Bruderschaft",
	["Brotherly Love"] = "Bruderliebe",
	["Brumeran of the Chillwind"] = "Brumeran von den Eiswindschimären",
	["Brutal Armor"] = "Brutale Rüstung",
	["Brutal Gauntlets"] = "Brutale Stulpen",
	["Brutal Hauberk"] = "Brutal Hauberk",
	["Brutal Helm"] = "Brutaler Helm",
	["Brutal Legguards"] = "Brutal Legguards",
	["Brutal Politics"] = "Brutale Politik",
	["Building a Perimeter"] = "Eine Verteidigung errichten",
	["Bungle in the Jungle"] = "Dschungelei",
	["Burn It Up... For the Horde!"] = "Zündet es an... für die Horde!",
	["Burning Blade Medallion"] = "Medaillon der Brennenden Klinge",
	["Burning Blood"] = "Brennendes Blut",
	["Burning Shadows"] = "Brennende Schatten",
	["Buying Time"] = "Spiel auf Zeit",
	["Buzzbox 323"] = "Dröhnkiste 323",
	["Buzzbox 411"] = "Dröhnkiste 411",
	["Buzzbox 525"] = "Dröhnkiste 525",
	["Buzzbox 827"] = "Dröhnkiste 827",
	["By Any Means Necessary"] = "Mit allen Mitteln",
	["C'Thun's Legacy"] = "C'Thuns Vermächnis",
	["CLUCK!"] = "GLUCK!",
	["Cabal Orders"] = "Befehle der Kabale",
	["Cache of Mau'ari"] = "Behälter von Mau'ari",
	["Call of Air"] = "Ruf der Luft",
	["Call of Air - Guse's Fleet"] = "Ruf der Lüfte - Guses Luftflotte",
	["Call of Air - Ichman's Fleet"] = "Ruf der Lüfte - Ichmans Luftflotte",
	["Call of Air - Jeztor's Fleet"] = "Ruf der Lüfte - Jeztors Luftflotte",
	["Call of Air - Mulverick's Fleet"] = "Ruf der Lüfte - Mulvericks Luftflotte",
	["Call of Air - Slidore's Fleet"] = "Ruf der Lüfte - Erzrutschs Luftflotte",
	["Call of Air - Vipore's Fleet"] = "Ruf der Lüfte - Vipores Luftflotte",
	["Call of Earth"] = "Ruf der Erde",
	["Call of Fire"] = "Ruf des Feuers",
	["Call of Water"] = "Ruf des Wassers",
	["Call to Arms"] = "Zu den Waffen",
	["Calling in the Reserves"] = "Hinzurufen der Reserve",
	["Calm Before the Storm"] = "Die Ruhe vor dem Sturm",
	["Camp Mojache"] = "Camp Mojache",
	["Can't Stay Away"] = "Kann es einfach nicht lassen",
	["Candles of Beckoning"] = "Kerze des Heranlockens",
	["Cannibalistic Cousins"] = "Kannibalistische Vettern",
	["Cannons of Rage"] = "Kanonen des Zorns",
	["Cape of Eternal Justice"] = "Cape der ewigen Gerechtigkeit",
	["Captain Kelisendra's Lost Rutters"] = "Kapitän Kelisendras verlorene Seekarten",
	["Captain Sander's Hidden Treasure"] = "Käpt'n Sanders Versteckter Schatz",
	["Captain Tyralius"] = "Hauptmann Tyralius",
	["Captain Vimes"] = "Captain Mumm",
	["Captives at Deatholme"] = "Gefangene der Todesfestung",
	["Capture a Mine"] = "Eine Mine besetzen",
	["Capture the Weapons"] = "Beschafft die Waffen",
	["Capturing the Keystone"] = "Den Schlüsselstein erobern",
	["Capturing the Phylactery"] = "Das Phylakterium entwenden",
	["Carendin Summons"] = "Carendin ruft",
	["Carnival Boots"] = "Jahrmarktsstiefel",
	["Carnival Jerkins"] = "Jahrmarktswämser",
	["Carrion Grubbage"] = "Aassammlung",
	["Carry Your Weight"] = "Akzeptiert Euer Schicksal",
	["Castpipe's Task"] = "Gussmuffs Auftrag",
	["Catalogue of the Wayward"] = "Verzeichnis der Abtrünnigen",
	["Catch and Release"] = "Kurz geschnappt",
	["Catch of the Day"] = "Der Fang des Tages",
	["Caught!"] = "Eingesperrt!",
	["Cave Mushrooms"] = "Höhlenpilze",
	["Celebrating Good Times"] = "Gute Zeiten feiern",
	["Celestial Power"] = "Himmlische Macht",
	["Cenarion Aid"] = "Cenarische Hilfe",
	["Cenarion Battlegear"] = "Schlachtrüstung des Cenarius",
	["Cenarius' Legacy"] = "Cenarius' Vermächtnis",
	["Centaur Bounty"] = "Zentaurenkopfgeld",
	["Centaur Bracers"] = "Zentaurenarmschienen",
	["Challenge Overlord Mok'Morokk"] = "Fordert Oberanführer Mok'Morokk heraus",
	["Champion's Battlegear"] = "Schlachtrüstung des Feldherrn",
	["Chapter I"] = "Kapitel I",
	["Chapter II"] = "Kapitel II",
	["Chapter III"] = "Kapitel III",
	["Chapter IV"] = "Kapitel IV",
	["Chasing A-Me 01"] = "Chasing A-Me 01",
	["Chen's Empty Keg"] = "Chens leeres Fässchen",
	["Chicken Clucking for a Mint"] = "Hühnchengegacker für ein Pfefferminzbonbon",
	["Chief Engineer Scooty"] = "Chefingenieur Scooty",
	["Chieftain Oomooroo"] = "Häuptling Oomooroo",
	["Children's Week"] = "Die Kinderwoche",
	["Chillwind Horns"] = "Hörner der Eiswindschimären",
	["Chimaeric Horn"] = "Schimärenhorn",
	["Cho'war the Pillager"] = "Cho'war der Plünderer",
	["Chromatic Mantle of the Dawn"] = "Der Chromatische Mantel der Dämmerung",
	["Circlet of Faith"] = "Reif des Glaubens",
	["City of Light"] = "Stadt des Lichts",
	["Claim Rackmore's Treasure!"] = "Nehmt Rackmores Schatz!",
	["Claiming the Light"] = "Die Beherrschung des Lichts",
	["Clam Bait"] = "Muschelköder",
	["Clamlette Surprise"] = "Muschelette Surprise",
	["Claws from the Deep"] = "Klauen aus der Tiefe",
	["Cleaning up the Grounds"] = "Sicherung des Grunds",
	["Cleansed Water Returns to Felwood"] = "Gesäubertes Wasser wird zum Teufelswald gebracht",
	["Cleansing Felwood"] = "Den Teufelswald säubern",
	["Cleansing of the Infected"] = "Ausrottung der Infizierten",
	["Cleansing of the Orb of Orahil"] = "Die Säuberung der Kugel von Orahil",
	["Cleansing the Eye"] = "Die Reinigung des Auges",
	["Cleansing the Scar"] = "Ordnung in der Schneise",
	["Cleansing the Waters"] = "Reinigung des Wassers",
	["Clearing the Way"] = "Den Weg frei machen",
	["Clefthoof Mastery"] = "Beherrschen der Grollhufjagd",
	["Cloak of Unending Life"] = "Umhang des endlosen Lebens",
	["Cloak of Veiled Shadows"] = "Umhang der Schattenschleier",
	["Cloak of the Gathering Storm"] = "Umhang der aufziehenden Stürme",
	["Cloak of the Unseen Path"] = "Umhang des unsichtbaren Pfads",
	["Cloth and Leather Armor"] = "Rüstung aus Tuch und aus Leder",
	["Clues in the Thicket"] = "Hinweise im Dickicht",
	["Coarse Weightstone"] = "Grober Gewichtsstein",
	["Codex of Defense"] = "Kodex der Verteidigung",
	["Cohlien Frostweaver"] = "Cohlien Frostwirker",
	["Coilfang Armaments"] = "Waffen des Echsenkessels",
	["Coldridge Valley Mail Delivery"] = "Postbeförderung im Eisklammtal",
	["Coldtooth Supplies"] = "Vorräte der Eisbeißermine",
	["Collecting Kelp"] = "Die Suche nach dem Tang",
	["Collecting Memories"] = "Die Suche nach Andenken",
	["Collection of Goods"] = "Fünf Dinge",
	["Collection of the Corrupt Water"] = "Verderbtes Wasser sammeln",
	["Colonel Kurzen"] = "Colonel Kurzen",
	["Colossal Menace"] = "Eine kolossale Bedrohung",
	["Combining Forces"] = "Mit vereinten Kräften",
	["Coming of Age"] = "Reiferwerden",
	["Commander Gor'shak"] = "Kommandant Gor'shak",
	["Compendium of the Fallen"] = "Kompendium der Gefallenen",
	["Completing the Delivery"] = "Erfolgreiche Lieferung",
	["Components for the Enchanted Gold Bloodrobe"] = "Komponenten für die verzauberte Goldblutrobe",
	["Components of Importance"] = "Komponenten von großer Wichtigkeit",
	["Concerns About Tuurem"] = "Sorgen um Tuurem",
	["Concerted Efforts"] = "Gemeinsames Bestreben",
	["Confront Yeh'kinya"] = "Konfrontiert Yeh'kinya",
	["Conjurer Luminrath"] = "Beschwörer Luminrath",
	["Conqueror's Breastplate"] = "Brustplatte des Eroberers",
	["Conqueror's Crown"] = "Krone des Eroberers",
	["Conqueror's Greaves"] = "Schienbeinschützer des Eroberers",
	["Conqueror's Legguards"] = "Beinschützer des Eroberers",
	["Conqueror's Spaulders"] = "Schiftung des Eroberers",
	["Conscript of the Horde"] = "Freiwilliger der Horde",
	["Consecrated Letter"] = "Geweihter Brief",
	["Consecrated Rune"] = "Geweihte Rune",
	["Consortium Crystal Collection"] = "Kristallsammlung des Konsortiums",
	["Constrictor Vines"] = "Würgeranken",
	["Consult Master Gadrin"] = "Konsultiert Meister Gadrin",
	["Consumed by Hatred"] = "Von Hass zerfressen",
	["Contact from Dalaran"] = "Dalarankontaktpersonen",
	["Containing the Threat"] = "Die Bedrohung bekämpfen",
	["Continue to Stormwind"] = "Weiter nach Sturmwind",
	["Continued Threat"] = "Fortwährende Gefahr",
	["Control"] = "Kontrolliert fünf Stützpunkte",
	["Control Four Bases"] = "Kontrolliert vier Stützpunkte",
	["Cookie's Jumbo Gumbo"] = "Kräckas Jumboeintopf",
	["Coolant Heads Prevail"] = "Kühlaufsätze setzen sich durch",
	["Copper Modulator"] = "Kupfermodulator",
	["Core of Elements"] = "Kern der Elemente",
	["Corki's Gone Missing Again!"] = "Corki wird schon wieder vermisst!",
	["Corki's Ransom"] = "Corkis Lösegeld",
	["Corrupted Soil"] = "Besudelte Erde",
	["Corruption"] = "Verderbnis",
	["Corruption of Earth and Seed"] = "Verderbnis von Erde und Samenkorn",
	["Cortello's Riddle"] = "Cortellos Rätsel",
	["Costly Menace"] = "Teure Bedrohung",
	["Counterattack!"] = "Gegenangriff!",
	["Counting Out Time"] = "Tempus fugit",
	["Courser Antlers"] = "Gehörnte Renner",
	["Covert Ops - Alpha"] = "Geheimoperation Alpha",
	["Covert Ops - Beta"] = "Geheimoperation Beta",
	["Coyote Thieves"] = "Kojoten-Diebe",
	["Crackin' Some Skulls"] = "Ein paar Schädel spalten",
	["Cracking Maury's Foot"] = "Maurys Fuß aufbrechen",
	["Craftsman's Writ - Brightcloth Pants"] = "Handwerksverfügung - Hellstoffhose",
	["Craftsman's Writ - Dense Weightstone"] = "Handwerksverfügung - Verdichteter Gewichtsstein",
	["Craftsman's Writ - Goblin Sapper Charge"] = "Handwerksverfügung - Goblinpioniersprengladung",
	["Craftsman's Writ - Greater Arcane Protection Potion"] = "Handwerksverfügung - Großer Arkanschutztrank",
	["Craftsman's Writ - Huge Thorium Battleaxe"] = "Handwerksverfügung - Gewaltige Thoriumstreitaxt",
	["Craftsman's Writ - Major Healing Potion"] = "Handwerksverfügung - Erheblicher Heiltrank",
	["Craftsman's Writ - Major Mana Potion"] = "Handwerksverfügung - Erheblicher Manatrank",
	["Craftsman's Writ - Plated Armorfish"] = "Handwerksverfügung - Panzerfisch",
	["Craftsman's Writ - Runecloth Bag"] = "Handwerksverfügung - Runenstofftasche",
	["Craftsman's Writ - Runecloth Boots"] = "Handwerksverfügung - Runenstoffstiefel",
	["Craftsman's Writ - Runecloth Robe"] = "Handwerksverfügung - Runenstoffrobe",
	["Craftsman's Writ - Runic Leather Pants"] = "Handwerksverfügung - Runenverzierte Lederhose",
	["Craftsman's Writ - Stonescale Eel"] = "Handwerksverfügung - Steinschuppenaal",
	["Craftsman's Writ - Thorium Grenade"] = "Handwerksverfügung - Thoriumgranate",
	["Craftsman's Writ - Thorium Tube"] = "Handwerksverfügung - Thoriumröhre",
	["Craftsman's Writ - Wicked Leather Headband"] = "Handwerksverfügung - Tückisches Lederstirnband",
	["Crashing the Wickerman Festival"] = "Bespitzelt das Fest des Weidenmanns",
	["Creating the Pendant"] = "Die Herstellung des Anhängers",
	["Creature of the Void"] = "Kreatur der Leere",
	["Creatures of the Eco-Domes"] = "Fauna der Biokuppel",
	["Crime and Punishment"] = "Verbrechen und Strafe",
	["Crimson Crystal Clue"] = "Hinweise des purpurnen Kristalls",
	["Crimson Templar"] = "Purpurroter Templer",
	["Critters of the Void"] = "Geschöpfe aus der Leere",
	["Crocolisk Boy and the Bearded Murloc"] = "Der Krokilisken-Junge und der bärtige Murloc",
	["Crocolisk Hunting"] = "Krokiliskenjagd",
	["Crossroads Conscription"] = "Wegekreuzwehrpflicht",
	["Crown of the Earth"] = "Krone der Erde",
	["Cruel Taskmasters"] = "Die Grausamkeit der Zuchtmeister",
	["Cruel's Intentions"] = "Grausame Pläne",
	["Cruelfin's Necklace"] = "Schandflosses Anhänger",
	["Crush the Bloodmaul Camp"] = "Vernichtet das Lager der Blutschläger!",
	["Crush the Bloodmaul Camp!"] = "Vernichtet das Lager der Blutschläger!",
	["Crushridge Bounty"] = "Trümmergratkopfgeld",
	["Crushridge Warmongers"] = "Kriegstreiber der Trümmergratoger",
	["Cry of the Thunderhawk"] = "Der Ruf des Donnerfalken",
	["Crypt Fiend Parts"] = "Teile eines Gruftscheusals",
	["Cryptstalker Armor Doesn't Make Itself..."] = "Was man für Gruftpirscherrüstung braucht...",
	["Cryptstalker Boots"] = "Stiefel des Gruftpirschers",
	["Cryptstalker Girdle"] = "Gurt des Gruftpirschers",
	["Cryptstalker Handguards"] = "Handschützer des Gruftpirschers",
	["Cryptstalker Headpiece"] = "Kopfstück des Gruftpirschers",
	["Cryptstalker Tunic"] = "Tunika des Gruftpirschers",
	["Cryptstalker Wristguards"] = "Handgelenksschutz des Gruftpirschers",
	["Crystal Charge"] = "Kristallsprengladung",
	["Crystal Clear"] = "Kristallklar",
	["Crystal Cluster"] = "Haufenweise Kristalle",
	["Crystal Force"] = "Kristallkraft",
	["Crystal Restore"] = "Kristallflicker",
	["Crystal Spire"] = "Kristallspitze",
	["Crystal Ward"] = "Kristallbarriere",
	["Crystal Yield"] = "Kristallschwächer",
	["Crystals of Power"] = "Machtkristalle",
	["Cuergo's Gold"] = "Cuergos Gold",
	["Culinary Crunch"] = "Knusperkost",
	["Culling the Flutterers"] = "Ausmerzen der Falter",
	["Culling the Threat"] = "Die Auswahl der Bedrohung",
	["Culling the Wild"] = "Die Verderbnis ausmerzen",
	["Curbing the Plague"] = "Gebietet der Seuche Einhalt",
	["Curing the Sick"] = "Heilung der Kranken",
	["Curse These Fat Fingers"] = "Verdammt seien diese fetten Finger",
	["Curse of the Violet Tower"] = "Der Fluch des violetten Turms",
	["Cursed Talismans"] = "Verfluchte Talismane",
	["Cutting Teeth"] = "Scharfe Zähne",
	["Cutting Your Teeth"] = "Zähne zeigen",
	["Cutting a Path"] = "Eine Schneise schlagen",
	["Cycle of Rebirth"] = "Zyklus der Wiedergeburt",
	["Cyclonian"] = "Cyclonian",
	["Da Voodoo"] = "Die Macht des Voodoos",
	["Dadanga is Hungry!"] = "Dadanga ist hungrig!",
	["Daelin's Men"] = "Daelins Männer",
	["Dagger of Veiled Shadows"] = "Dolch der Schattenschleier",
	["Daggerfen Deviance"] = "Dolchfennkrise",
	["Daily Delivery"] = "Tägliche Lieferung",
	["Dalar's Analysis"] = "Dalars Analyse",
	["Dalaran Patrols"] = "Patrouillen von Dalaran",
	["Dalaran's Intentions"] = "Dalaran Absichten",
	["Dalson's Tears Cauldron"] = "Der Kessel von Dalsons Tränenfeld",
	["Damaged Mask"] = "Die beschädigte Maske",
	["Damning Evidence"] = "Eindeutige Beweise",
	["Dancing for Marzipan"] = "Tanzen für Marzipan",
	["Dangerous!"] = "Gefährlich!",
	["Dangers of the Windfury"] = "Windfuriengefahr",
	["Dar'Khan's Lieutenants"] = "Dar'Khans Gefolgschaft",
	["Dark Council"] = "Der Dunkle Rat",
	["Dark Heart"] = "Dunkles Herz",
	["Dark Iron Legacy"] = "Dunkeleisenerbe",
	["Dark Iron Scraps"] = "Dunkeleisenfragmente",
	["Dark Storms"] = "Dunkle Stürme",
	["Dark Tidings"] = "Düstere Neuigkeiten",
	["Dark Vessels"] = "Dunkle Gefäße",
	["Darkmoon Beast Deck"] = "Bestienkartenset des Dunkelmond-Jahrmarkts",
	["Darkmoon Elementals Deck"] = "Elementarkartenset des Dunkelmond-Jahrmarkts",
	["Darkmoon Portals Deck"] = "Portalkartenset des Dunkelmond-Jahrmarkts",
	["Darkmoon Warlords Deck"] = "Kriegsfürstenkartenset des Dunkelmond-Jahrmarkts",
	["Darnassian Intrusions"] = "Darnassische Eindringlinge",
	["Data Rescue"] = "Datenrettung",
	["Dawn's Gambit"] = "Dämmerungstrickfalle",
	["Deactivate An'owyn"] = "Die Abschaltung von An'owyn",
	["Deactivating the Spire"] = "Deaktivierung des Turms",
	["Dead Man's Plea"] = "Die letzte Bitte eines toten Mannes",
	["Dead-tooth Jack"] = "Stumpfzahn Jack",
	["Deadly Desert Venom"] = "Tödliches Wüstengift",
	["Deadly Predators"] = "Tödliche Raubtiere",
	["Deadmire"] = "Schlammwühler",
	["Deadwood of the North"] = "Totenwaldfelle des Nordens",
	["Deal With the Saboteurs"] = "Die Saboteure ausschalten",
	["Dealing with Zeb'Sora"] = "Maßnahmen gegen Zeb'Sora",
	["Dealing with the Foreman"] = "Den Großknecht erledigen",
	["Dealing with the Overmaster"] = "Den Übermeister erledigen",
	["Dearest Natalia"] = "Liebste Natalia",
	["Death From Below"] = "Tod von unten",
	["Death's Door"] = "Die Schwelle des Todes",
	["Death's Embrace"] = "Umarmung des Todes",
	["Deathdealer's Boots"] = "Stiefel des Todesboten",
	["Deathdealer's Helm"] = "Helm des Todesboten",
	["Deathdealer's Vest"] = "Weste des Todesboten",
	["Deaths in the Family"] = "Todesfälle in der Familie",
	["Deathstalkers in Shadowfang"] = "Todespirscher in Burg Schattenfang",
	["Deceive thy Enemy"] = "Täuscht den Feind",
	["Decipher the Tome"] = "Den Folianten entziffern",
	["Deciphering the Book"] = "Entziffern des Buchs",
	["Declaration of Power"] = "Demonstration der Macht",
	["Decoy!"] = "Lockvogel!",
	["Deep Cover"] = "Undercover",
	["Deep Sea Salvage"] = "Tiefsee-Bergung",
	["Deepmoss Spider Eggs"] = "Eier der Kluftmoosspinnen",
	["Deeprun Rat Roundup"] = "Tiefenbahn-Ratten-Razzia",
	["Defeat Nek'rosh"] = "Sieg über Nek'rosh",
	["Defenders of Darrowshire"] = "Verteidiger von Darroheim",
	["Defending Fairbreeze Village"] = "Die Verteidigung von Morgenluft",
	["Defiler's Basic Care Package"] = "Basisüberlebenspaket der Entweihten",
	["Defiler's Standard Care Package"] = "Standardüberlebenspaket der Entweihten",
	["Defiling Uther's Tomb"] = "Entweiht Uthers Grabmal",
	["Deliver Them From Evil..."] = "Unheilvolle Mitteilung",
	["Deliver Thomas' Report"] = "Zustellung von Thomas' Bericht",
	["Deliver the Gems"] = "Ablieferung der Edelsteine",
	["Deliver the Plans to An'telas"] = "Bringt die Pläne nach An'telas",
	["Deliver the Shipment"] = "Überbringen der Lieferung",
	["Deliver the Thread"] = "Abliefern des Fadens",
	["Deliver to MacKinley"] = "Lieferung für MacKinley",
	["Deliveries to Sven"] = "Lieferung an Sven",
	["Delivering Daffodils"] = "Narzissen für eine Dame",
	["Delivering the Message"] = "Die Nachricht überbringen",
	["Delivering the Relic"] = "Überbringung des Relikts",
	["Delivery for Marin"] = "Lieferung für Marin",
	["Delivery to Andron Gant"] = "Lieferung an Andron Gant",
	["Delivery to Archmage Xylem"] = "Lieferung für Erzmagier Xylem",
	["Delivery to Jes'rimon"] = "Lieferung an Jes'rimon",
	["Delivery to Magatha"] = "Lieferung an Magatha",
	["Delivery to Ridgewell"] = "Lieferung an Kronenbrunn",
	["Delivery to Silverpine Forest"] = "Lieferung in den Silberwald",
	["Delivery to Tranquillien"] = "Zustellung nach Tristessa",
	["Delivery to the Gnomes"] = "Lieferung für die Gnome",
	["Delivery to the North Sanctum"] = "Lieferung an das Sanktum des Nordens",
	["Delivery to the Sepulcher"] = "Lieferung an das Grabmal",
	["Demon Dogs"] = "Dämonenhunde",
	["Demonic Contamination"] = "Dämonische Verderbnis",
	["Demonic Crystal Prisons"] = "Dämonische Kristallgefängnisse",
	["Desert Recipe"] = "Wüstenrezept",
	["Desperate Prayer"] = "Verzweifeltes Gebet",
	["Destiny Calls"] = "Das Schicksal ruft",
	["Destroy Morphaz"] = "Vernichtet Morphaz",
	["Destroy Naberius!"] = "Vernichtet Naberius!",
	["Destroy the Legion"] = "Zerstört die Legion",
	["Deviate Eradication"] = "Ausrottung der Deviat",
	["Deviate Hides"] = "Deviatbälge",
	["Devils in Westfall"] = "Teufel in Westfall",
	["Devourer of Souls"] = "Verschlinger der Seelen",
	["Devouring Plague"] = "Verschlingende Seuche",
	["Diabolical Plans"] = "Teuflische Pläne",
	["Diagnosis: Critical"] = "Diagnose: kritisch",
	["Diaphanous Wings"] = "Lichtdurchlässige Flügel",
	["Did You Get The Note?"] = "Ihr seid eingeladen!",
	["Did You Lose This?"] = "Habt Ihr das verloren?",
	["Dig Rat Stew"] = "Grubenratteneintopf",
	["Digging Through Bones"] = "In den Knochen wühlen",
	["Digging Through the Dirt"] = "Graben in der Erde",
	["Digging Through the Ooze"] = "Stochern im Brühschlamm",
	["Digging for Prayer Beads"] = "Nach Gebetsperlen graben",
	["Dimensius the All-Devouring"] = "Dimensius der alles Verschlingende",
	["Diplomatic Measures"] = "Diplomatische Maßnahmen",
	["Dirge's Kickin' Chimaerok Chops"] = "Dirges abgefahrene Chimaerokkoteletts",
	["Discover Rolf's Fate"] = "Rolfs Schicksal",
	["Disharmony of Fire"] = "Disharmonie des Feuers",
	["Disharmony of Flame"] = "Disharmonie der Flamme",
	["Dispelling Evil"] = "Austreibung des Bösen",
	["Disrupt Their Reinforcements"] = "Die Kommunikation unterbrechen",
	["Disrupt the Attacks"] = "Vereitelung der Angriffe",
	["Disruption - Forge Camp: Mageddon"] = "Konstruktionslager: Mageddon unterbrechen",
	["Distracting Jarven"] = "Jarvens Ablenkung",
	["Distraction at Manaforge B'naar"] = "Ablenkung in der Manaschmiede B'naar",
	["Disturbance at Umbrafen Lake"] = "Anomalie am Umbrafennsee",
	["Divination: Gorefiend's Armor"] = "Hellsicht: Blutschattens Rüstung",
	["Divination: Gorefiend's Cloak"] = "Hellsicht: Blutschattens Umhang",
	["Divination: Gorefiend's Truncheon"] = "Hellsicht: Blutschattens Schlagstock",
	["Divine Retribution"] = "Göttliche Vergeltung",
	["Divino-matic Rod"] = "Wünschel-mato-Rute",
	["Do My Eyes Deceive Me"] = "Kann ich meinen Augen trauen?",
	["Dogran's Captivity"] = "Dograns Gefangenschaft",
	["Dolanaar Delivery"] = "Lieferung für Dolanaar",
	["Doling Justice"] = "Gerechtigkeit üben",
	["Don't Drink the Water"] = "Trinkt nicht das Wasser",
	["Don't Kill the Fat One"] = "Nicht den Fetten töten!",
	["Doom Weed"] = "Verdammniskraut",
	["Doomcaller's Circlet"] = "Reif des Verdammnisrufers",
	["Doomcaller's Footwraps"] = "Fußlappen des Verdammnisrufers",
	["Doomcaller's Mantle"] = "Mantel des Verdammnisrufers",
	["Doomrigger's Clasp"] = "Doomriggers Schnalle",
	["Doomsday Candle"] = "Die Altarkerze des Jüngsten Gerichts",
	["Doorway to the Abyss"] = "Die Schwelle zum Abgrund",
	["Doras the Wind Rider Master"] = "Doras der Windreitermeister",
	["Dousing the Flames of Protection"] = "Übergießen der Flammen des Schutzes",
	["Down With Daellis"] = "Nieder mit Daellis",
	["Down at the Docks"] = "Unten an den Docks",
	["Down the Coast"] = "Die Küste entlang",
	["Down the Dead Scar"] = "Entlang der Todesschneise",
	["Down the Scarlet Path"] = "Auf dem scharlachroten Pfad",
	["Dr. Boom!"] = "Dr. Bumm!",
	["Draconic for Dummies"] = "Drachisch für Dummies",
	["Draenethyst Crystals"] = "Draenethystkristalle",
	["Dragonkin Menace"] = "Drachkin-Bedrohung",
	["Dragonmaw Shinbones"] = "Schienbeinknochen der Drachenmalorcs",
	["Dragonscale Leatherworking"] = "Drachenlederverarbeitung",
	["Drain Schematics"] = "Kanalisationspläne",
	["Drakefire Amulet"] = "Drachenfeueramulett",
	["Drape of Unyielding Strength"] = "Tuch der unnachgiebigen Stärke",
	["Drape of Vaulted Secrets"] = "Tuch der behüteten Geheimnisse",
	["Dreadmaul Rock"] = "Schreckensfels",
	["Dreadnaught Bracers"] = "Armschienen des Schreckenspanzers",
	["Dreadnaught Breastplate"] = "Brustplatte des Schreckenspanzers",
	["Dreadnaught Gauntlets"] = "Stulpen des Schreckenspanzers",
	["Dreadnaught Helmet"] = "Helm des Schreckenspanzers",
	["Dreadnaught Legplates"] = "Beinplatten des Schreckenspanzers",
	["Dreadnaught Pauldrons"] = "Schulterstücke des Schreckenspanzers",
	["Dreadnaught Sabatons"] = "Sabatons des Schreckenspanzers",
	["Dreadnaught Waistguard"] = "Taillenschutz des Schreckenspanzers",
	["Dreadsteed of Xoroth"] = "Schreckensross von Xoroth",
	["Dream Dust in the Swamp"] = "Traumstaub im Sumpf",
	["Dreamwalker Boots"] = "Stiefel des Traumwandlers",
	["Dreamwalker Girdle"] = "Gurt des Traumwandlers",
	["Dreamwalker Handguards"] = "Handschützer des Traumwandlers",
	["Dreamwalker Headpiece"] = "Kopfstück des Traumwandlers",
	["Dreamwalker Legguards"] = "Beinschützer des Traumwandlers",
	["Dreamwalker Spaulders"] = "Schiftung des Traumwandlers",
	["Dreamwalker Tunic"] = "Tunika des Traumwandlers",
	["Dreamwalker Wristguards"] = "Handgelenksschutz des Traumwandlers",
	["Dressing the Part"] = "Kleider machen Seebären",
	["Driftwood"] = "Treibholz",
	["Drijya Needs Your Help"] = "Drijya braucht Eure Hilfe",
	["Drill the Drillmaster"] = "Die Züchtigung des Drillmeisters",
	["Drowned Sorrows"] = "Ertrunkene Trauer",
	["Druid of the Claw"] = "Druide der Klaue",
	["Dry Times"] = "Trockene Zeiten",
	["Duke Nicholas Zverenhoff"] = "Fürst Nicholas Zverenhoff",
	["Dumphry's Request"] = "Dumphrys Bitte",
	["Dungar Longdrink"] = "Dungar Trinkfest",
	["Dusky Crab Cakes"] = "Schwärzliche Krebsküchlein",
	["Dust from the Drakes"] = "Drachenstaub",
	["Dwarven Digging"] = "Zwergenbuddelei",
	["Dwarven Justice"] = "Zwergengerechtigkeit",
	["Dwarven Outfitters"] = "Zwergenausstatter",
	["Eagan Peltskinner"] = "Eagan Pelzschneider",
	["Earthen Arise"] = "Der Irdene erhebt sich",
	["Earthen Templar"] = "Irdener Templer",
	["Earthshatter Boots"] = "Stiefel des Erdspalters",
	["Easy Strider Living"] = "Schreitereintopf",
	["Eating Damnation"] = "Verdammnis schmecken",
	["Echeyakee"] = "Echeyakee",
	["Echoes of War"] = "Echo des Krieges",
	["Egg Collection"] = "Eiersammlung",
	["Egg Freezing"] = "Ei-Frosten",
	["Egg Hunt"] = "Eierjagd",
	["Eight-Legged Menaces"] = "Gefahr auf acht Beinen",
	["Eitrigg's Wisdom"] = "Etriggs Weisheit",
	["Elanaria"] = "Elanaria",
	["Electro-Shock Goodness!"] = "Elektroschock!",
	["Electropellers"] = "Elektropeller",
	["Elekks Are Serious Business"] = "Elekk sind starker Tobak",
	["Elemental Bracers"] = "Elementararmschienen",
	["Elemental Leatherworking"] = "Elementarlederverarbeitung",
	["Elemental Power Extraction"] = "Elementarenergieextraktor",
	["Elemental War"] = "Krieg der Elementare",
	["Elixir of Agony"] = "Elixier der Pein",
	["Elixir of Pain"] = "Elixier der Schmerzen",
	["Elixir of Suffering"] = "Elixier des Leidens",
	["Elixirs for the Bladeleafs"] = "Elixiere für die Messerblatts",
	["Elmore's Task"] = "Elmores Aufgabe",
	["Elune's Tear"] = "Elunes Träne",
	["Elven Legends"] = "Elfische Legenden",
	["Emberstrife"] = "Aschenschwinge",
	["Emphasis on Sacrifice"] = "Ein Opfer darbieten",
	["Empty Stables"] = "Verwaiste Ställe",
	["En-Ay-Es-Tee-Why"] = "Be-Öh-Es-Eh",
	["Enchanted Azsharite Fel Weaponry"] = "Verzauberte Azsharitteufelswaffe",
	["Enchanted Thorium Platemail: Volume I"] = "Verzauberter Thoriumplattenpanzer: Band I",
	["Enchanted Thorium Platemail: Volume II"] = "Verzauberter Thoriumplattenpanzer: Band II",
	["Enchanted Thorium Platemail: Volume III"] = "Verzauberter Thoriumplattenpanzer: Band III",
	["Encoded Fragments"] = "Verschlüsselte Fragmente",
	["Encroaching Gnolls"] = "Eindringende Gnolle",
	["Encroaching Wildlife"] = "Lauernde Tierwelt",
	["Encroachment"] = "Übergriff",
	["Encrusted Tail Fins"] = "Verkrustete Schwanzflossen",
	["Encrypted Letter"] = "Verschlüsselter Brief",
	["Encrypted Memorandum"] = "Verschlüsseltes Memorandum",
	["Encrypted Parchment"] = "Verschlüsseltes Pergament",
	["Encrypted Rune"] = "Verschlüsselte Rune",
	["Encrypted Scroll"] = "Verschlüsselte Rolle",
	["Encrypted Sigil"] = "Verschlüsselte Siegelzeichen",
	["Encrypted Tablet"] = "Verschlüsselte Schrifttafel",
	["Encrypted Twilight Texts"] = "Verschlüsselte Schattenhammertexte",
	["Ending Their World"] = "Ihre Welt enden lassen",
	["Ending the Bloodcurse"] = "Beendigung des Blutfluchs",
	["Enemy Booty"] = "Beutezug im Feindesland",
	["Enemy of my Enemy..."] = "Der Feind meines Feindes...",
	["Enigma Boots"] = "Stiefel des Mysteriums",
	["Enigma Circlet"] = "Reif des Mysteriums",
	["Enigma Shoulderpads"] = "Schulterpolster des Mysteriums",
	["Enraged Spirits"] = "Wütende Geister",
	["Enraged Spirits of Air"] = "Wütende Geister der Luft",
	["Enraged Spirits of Fire and Earth"] = "Wütende Geister des Feuers und der Erde",
	["Enraged Spirits of Water"] = "Wütende Geister des Wassers",
	["Enraged Thunder Lizards"] = "Wütende Donnerechsen",
	["Enraged Wildkin"] = "Wütende Wildekin",
	["Enticing Negolash"] = "Negolash anlocken",
	["Entry Into Karazhan"] = "Nach Karazhan",
	["Entry Into the Citadel"] = "Zugang zur Zitadelle",
	["Envoy to the Mag'har"] = "Entsandt zu den Mag'har",
	["Epic Armaments of Battle - Exalted Amongst the Dawn"] = "Epische Kampfausrüstung - Ehrfurcht der Dämmerung",
	["Eradicate the Burning Legion"] = "Die Brennende Legion ausrotten",
	["Erion Shadewhisper"] = "Erion Schattenflüsterer",
	["Erion's Behest"] = "Erions Befehl",
	["Errand for Apothecary Zinge"] = "Kurierdienst für Apothekerin Zinge",
	["Escape Through Force"] = "Flucht durch Gewalt",
	["Escape Through Stealth"] = "Flucht durch Verstohlenheit",
	["Escape from Durnholde"] = "Flucht aus Durnholde",
	["Escape from Firewing Point!"] = "Ausbruch aus dem Posten der Feuerschwingen!",
	["Escape from Umbrafen"] = "Flucht aus Umbrafenn",
	["Escape from the Catacombs"] = "Flucht aus den Katakomben",
	["Escape from the Staging Grounds"] = "Ausbruch aus dem Stützpunkt",
	["Escaping the Tomb"] = "Flucht aus dem Grab",
	["Escorting Erland"] = "Eskorte für Erland",
	["Essence for the Engines"] = "Essenzen für die Motoren",
	["Essence of the Exile"] = "Essenz der Verbannung",
	["Essential Artificials"] = "Grundlegende Artifixe",
	["Establishing New Outposts"] = "Mehr Befestigungen",
	["Etched Note"] = "Geätzte Notiz",
	["Etched Parchment"] = "Geätztes Pergament",
	["Etched Rune"] = "Geätzte Rune",
	["Etched Sigil"] = "Geätztes Siegelzeichen",
	["Etched Tablet"] = "Geätzte Schrifttafel",
	["Ethereum Data"] = "Daten der Astralen",
	["Evershine"] = "Immerschimmer",
	["Everything Counts In Large Amounts"] = "Im Dutzend besser",
	["Everything Will Be Alright"] = "Alles wird gut",
	["Evil Bat Eyes"] = "Böse Fledermausaugen",
	["Evil Draws Near"] = "Das Böse rückt näher",
	["Examine the Vessel"] = "Untersuchung des Gefäßes",
	["Excavation Progress Report"] = "Bericht über den Fortschritt der Ausgrabungen",
	["Excelsior"] = "Exzelsior",
	["Exorcising Terrordale"] = "Der Exorzismus des Schreckenstals",
	["Exorcising the Trees"] = "Der Exorzismus der Bäume",
	["Expedition Point"] = "Expeditionsposten",
	["Expedition Salvation"] = "Rettungsexpedition",
	["Expert Blacksmith!"] = "Schmiedkunstexperte!",
	["Extinguish the Firegut"] = "Die Feuermagenoger auslöschen",
	["Extinguishing the Idol"] = "Ausschalten des Götzen",
	["Eye of the Emberseer"] = "Auge des Glutsehers",
	["Ezekiel"] = "Ezekiel",
	["FIFTY! YEP!"] = "FÜNFZIG! Jawoll!",
	["Faerie Dragon Muisek"] = "Muisek von Feendrachen",
	["Failed Incursion"] = "Fehlgeschlagene Operation",
	["Fairbreeze Village"] = "Morgenluft",
	["Falcon Watch"] = "Falkenwacht",
	["Falcon's Call"] = "Ruf des Falken",
	["Fall From Grace"] = "In Ungnade fallen",
	["Fall of Dun Modr"] = "Der Fall von Dun Modr",
	["Fallen Sky Lake"] = "Der Himmelssturzsee",
	["Fallen Sky Lords"] = "Gefallene Himmelsstürmer",
	["Falling to Corruption"] = "Der Verderbnis erliegen",
	["Falrin's Vendetta"] = "Falrins Rachefeldzug",
	["Familiar Fungi"] = "Bekannter Pilz",
	["Family Tree"] = "Stammbaum",
	["Farren's Proof"] = "Farrens Beweis",
	["Farstrider Retreat"] = "Zuflucht der Weltenwanderer",
	["Favor of the Gronn"] = "Die Gunst der Gronn",
	["Favored of Elune?"] = "Elunes Lieblinge?",
	["Feast at the Blue Recluse"] = "Festmahl im Blauen Eremiten",
	["Featherbeard's Endorsement"] = "Federbarts Unterstützung",
	["Feathermoon Stronghold"] = "Die Mondfederfeste",
	["Feathers for Grazle"] = "Federn für Grazle",
	["Feathers for Nafien"] = "Federn für Nafien",
	["Fei Fei's Treat"] = "Fei-Feis Belohnung",
	["Fel Armaments"] = "Teuflische Waffen",
	["Fel Embers"] = "Teufelsglut",
	["Fel Orc Plans"] = "Höllenorcpläne",
	["Fel Orc Scavengers"] = "Plünderer der Höllenorcs",
	["Fel Spirits"] = "Höllengeister",
	["Felbound Ancients"] = "Gebundene Urtume",
	["Felendren the Banished"] = "Felendren der Verbannte",
	["Felling an Ancient Tree"] = "Einen uralten Baum fällen",
	["Felnok Steelspring"] = "Felnok Stahlfeder",
	["Felspark Ravine"] = "Teufelsfunkenklamm",
	["Felstone Field Cauldron"] = "Der Kessel des Teufelssteinfelds",
	["Felsworn Gas Mask"] = "Die Gasmaske der Teufelsbrut",
	["Fenwick Thatros"] = "Fenwick Thatros",
	["Feralas: A History"] = "Feralas: Ein historischer Abriss",
	["Ferocitas the Dream Eater"] = "Ferocitas der Traumfresser",
	["Fertile Spores"] = "Fruchtbare Sporen",
	["Fetch!"] = "Fangt!",
	["Field Duty"] = "Felddienst",
	["Fields of Grief"] = "Felder des Kummers",
	["Fierce Enemies"] = "Grimmige Feinde",
	["Fiery Blaze Enchantments"] = "Feuerverzauberungen",
	["Fiery Menace!"] = "Feurige Bedrohung!",
	["Fiery Plate Gauntlets"] = "Feurige Plattenstulpen",
	["Filling the Soul Gem"] = "Den Seelenedelstein füllen",
	["Filthy Paws"] = "Schmutzige Pfoten",
	["Final Passage"] = "Letzte Überfahrt",
	["Final Preparations"] = "Letzte Vorbereitungen",
	["Find Acteon!"] = "Findet Acteon!",
	["Find Agmond"] = "Sucht Agmond",
	["Find Bingles"] = "Sucht Bingles",
	["Find Keltus Darkleaf"] = "Findet Keltus Dunkellaub",
	["Find Myranda"] = "Myranda suchen",
	["Find OOX-09/HL!"] = "Sucht OOX-09/HL!",
	["Find OOX-17/TN!"] = "Findet OOX-17/TN!",
	["Find OOX-22/FE!"] = "Findet OOX-22/FE!",
	["Find Ranshalla"] = "Ranshalla suchen",
	["Find Spy To'gun"] = "Findet Spion To'gun",
	["Find the Deserter"] = "Findet den Deserteur",
	["Find the Gems"] = "Suche nach den Edelsteinen",
	["Find the Gems and Power Source"] = "Findet die Edelsteine und die Kraftquelle",
	["Find the Lost Guards"] = "Suche nach den vermissten Wachen",
	["Find the Shattered Hand"] = "Suche nach der Zerschmetterten Hand",
	["Finding the Antidote"] = "Suche nach dem Gegengift",
	["Finding the Keymaster"] = "Den Schlüsselmeister finden",
	["Finding the Shadowy Figure"] = "Auf der Suche nach der Schattengestalt",
	["Finding the Source"] = "Die Quelle finden",
	["Finding the Survivors"] = "Findet die Überlebenden",
	["Fine Gold Thread"] = "Feiner Goldfaden",
	["Fiora Longears"] = "Fiora Langohr",
	["Fire At Will!"] = "Feuer frei!",
	["Fire Hardened Mail"] = "Feuergehärteter Panzer",
	["Fire Plume Forged"] = "Feuersäulen geschmiedet",
	["Fire Sapta"] = "Feuersapta",
	["Fire Taboo"] = "Feuer-Tabu",
	["Firewing Signets"] = "Siegel der Feuerschwingen",
	["Fish in a Bucket"] = "Fisch im Eimer",
	["Flash Bomb Recipe"] = "Blitzstrahlbombenanleitung",
	["Flawed Power Stone"] = "Fehlerhafter Kraftstein",
	["Flawless Fel Essence"] = "Reine Teufelsessenz",
	["Flexing for Nougat"] = "Muskelspiel für Nugat",
	["Flight to Auberdine"] = "Flug nach Auberdine",
	["Flint Shadowmore"] = "Flint Schattenmoor",
	["Flora of the Eco-Domes"] = "Flora der Biokuppel",
	["Flute of Xavaric"] = "Flöte des Xavaric",
	["Fly to Silvermoon City"] = "Fliegt nach Silbermond",
	["Follow the Breadcrumbs"] = "Folget den Brotkrumen",
	["Food for Baby"] = "Essen für das Baby",
	["Footwraps of the Oracle"] = "Fußlappen des Orakels",
	["For All To See"] = "Für alle sichtbar",
	["For Great Honor"] = "Große Ehre",
	["For Love Eternal"] = "In ewiger Liebe",
	["For The Horde!"] = "Für die Horde!",
	["For the Fallen"] = "Für die Gefallenen",
	["Forbidden Knowledge"] = "Verbotenes Wissen",
	["Force Commander Danath"] = "Truppenkommandant Danath",
	["Forces of Jaedenar"] = "Streitmacht von Jaedenar",
	["Foreboding Plans"] = "Furchteinflößende Pläne",
	["Forge Camp: Annihilated"] = "Konstruktionslager: zerstört",
	["Forge Camp: Mageddon"] = "Konstruktionslager: Mageddon",
	["Forged Steel"] = "Geschmiedeter Stahl",
	["Forging the Mightstone"] = "Erschaffung des Steins der Macht",
	["Forging the Shaft"] = "Das Schmieden des Schafts",
	["Forging the Weapon"] = "Das Schmieden der Waffe",
	["Forgotten Rituals"] = "Vergessene Rituale",
	["Formal Introductions"] = "Formelle Vorstellung",
	["Foror's Compendium"] = "Forors Kompendium",
	["Forsaken Aid"] = "Die Hilfe der Verlassenen",
	["Forsaken Diseases"] = "Verlassenenkrankheit",
	["Forsaken Duties"] = "Verlassenen-Pflichten",
	["Forward Base: Reaver's Fall"] = "Vorposten: Häschersturz",
	["Foul Magics"] = "Elende Magien",
	["Fouled Water Spirits"] = "Besudelte Wassergeister",
	["Fragmented Magic"] = "Gespaltene Magie",
	["Fragments of the Orb of Orahil"] = "Fragmente der Kugel von Orahil",
	["Fragments of the Past"] = "Fragmente der Vergangenheit",
	["Frame of Atiesh"] = "Grundstab von Atiesh",
	["Free From the Hold"] = "Aus der Gefangenschaft befreit",
	["Free at Last"] = "Endlich frei",
	["Freed from the Hive"] = "Flucht aus dem Schwarmbau",
	["Freedom for All Creatures"] = "Freiheit für alle Kreaturen",
	["Freedom to Ruul"] = "Freiheit für Ruul",
	["Fresh Meat"] = "Frischfleisch",
	["Fresh from the Mechanar"] = "Frisch von der Mechanar",
	["From The Wreckage...."] = "Aus den Wrackteilen geborgen...",
	["From the Abyss"] = "Aus dem Abgrund",
	["From the Ashes"] = "Aus der Asche",
	["Frostfire Belt"] = "Frostfeuergürtel",
	["Frostfire Bindings"] = "Frostfeuerbindungen",
	["Frostfire Circlet"] = "Frostfeuerreif",
	["Frostfire Gloves"] = "Frostfeuerhandschuhe",
	["Frostfire Leggings"] = "Frostfeuergamaschen",
	["Frostfire Robe"] = "Frostfeuerrobe",
	["Frostfire Sandals"] = "Frostfeuersandalen",
	["Frostfire Shoulderpads"] = "Frostfeuerschulterpolster",
	["Frostmane Hold"] = "Höhle der Frostmähnen",
	["Frostmaul E'ko"] = "E'ko der Frosthagelriesen",
	["Frostmaw"] = "Frostrachen",
	["Frostsaber E'ko"] = "E'ko der Frostsäbler",
	["Frostsaber Provisions"] = "Frostsäblerverpflegung",
	["Fruit of the Sea"] = "Meeresfrüchte",
	["Fuel for the Zapping"] = "Treibstoff fürs Schrumpfen",
	["Fulgor Spores"] = "Fulgorsporen",
	["Full Triangle"] = "Das volle Dreieck",
	["Fumping"] = "Stampfen",
	["Fungal Spores"] = "Pilzsporen",
	["Furlbrow's Deed"] = "Brauenwirbels Urkunde",
	["Further Concerns"] = "Weitere Sorgen",
	["Further Corruption"] = "Weitere Verderbnis",
	["Further Instructions"] = "Weitere Instruktionen",
	["Further Mysteries"] = "Weitere Geheimnisse",
	["Gadgetzan Water Survey"] = "Gadgetzan Wassersondierung",
	["Gaffer Jacks"] = "Klemmmuffen",
	["Gahrron's Withering Cauldron"] = "Der Kessel von Gahrrons Trauerfeld",
	["Gahz'ridian"] = "Gahz'ridian",
	["Gahz'rilla"] = "Gahz'rilla",
	["Gaining Acceptance"] = "Erlangte Anerkennung",
	["Gaining Access"] = "Zugang erlangen",
	["Gaining Mirren's Trust"] = "Mirrens Vertrauen erlangen",
	["Gakin's Summons"] = "Gakins Beschwörung",
	["Galaen's Fate"] = "Galaens Schicksal",
	["Galaen's Journal - The Fate of Vindicator Saruan"] = "Galaens Tagebuch - Das Schicksal von Verteidiger Saruan",
	["Galen's Escape"] = "Galens Flucht",
	["Galgar's Cactus Apple Surprise"] = "Galgars Kaktusapfel Surprise",
	["Galvan's Finest Pupil"] = "Galvans bester Schüler",
	["Gan'rul's Summons"] = "Gan'ruls Beschwörung",
	["Gann's Reclamation"] = "Ganns Rekultivierung",
	["Garments of Spirituality"] = "Gewänder der Spiritualität",
	["Garments of the Light"] = "Gewänder des Lichts",
	["Garments of the Moon"] = "Gewänder des Mondes",
	["Garona: A Study on Stealth and Treachery"] = "Garona: Eine Studie über Heimlichkeit und Verrat",
	["Gateway to the Frontier"] = "Das Tor zur Grenze",
	["Gather Rot Blossoms"] = "Das Sammeln von Faulblüten",
	["Gather the Orbs"] = "Sammelt die Kugeln",
	["Gathering Idols"] = "Götzen sammeln",
	["Gathering Leather"] = "Leder sammeln",
	["Gathering Materials"] = "Materialsammlung",
	["Gathering the Cure"] = "Das Heilmittel sammeln",
	["Gathering the Reagents"] = "Die Reagenzien sammeln",
	["Gauging the Resonant Frequency"] = "Die Klangfrequenz messen",
	["Gava'xi"] = "Gava'xi",
	["Gavel of Infinite Wisdom"] = "Hammer der unendlichen Weisheit",
	["Gearing Redridge"] = "Die Aufrüstung im Rotkammgebirge",
	["Gelkis Alliance"] = "Allianz mit den Gelkis",
	["General Drakkisath's Command"] = "General Drakkisaths Befehl",
	["General Drakkisath's Demise"] = "General Drakkisaths Niedergang",
	["Genesis Boots"] = "Stiefel der Genesis",
	["Genesis Helm"] = "Helm der Genesis",
	["Genesis Shoulderpads"] = "Schulterpolster der Genesis",
	["Genesis Trousers"] = "Beinkleider der Genesis",
	["Genesis Vest"] = "Weste der Genesis",
	["Gerenzo Wrenchwhistle"] = "Gerenzo Pfeifzang",
	["Gerenzo's Orders"] = "Gerenzos Befehle",
	["Get Me Out of Here!"] = "Holt mich hier raus!",
	["Get the Gnomes Drunk"] = "Die Gnome betrunken machen",
	["Get the Goblins Drunk"] = "Die Goblins betrunken machen",
	["Get the Scoop"] = "Der Knüller schlechthin",
	["Getting Down to Business"] = "Zur Sache",
	["Getting the Bladespire Tanked"] = "Die Speerspießer abfüllen",
	["Ghost Hair Thread"] = "Geisterhaarfaden",
	["Ghost-o-plasm Round Up"] = "Geisterplasmasuche",
	["Ghoulish Effigy"] = "Ein Ghulbildnis",
	["Give Gerard a Drink"] = "Etwas zu trinken für Gerard",
	["Gizelton Caravan"] = "Gizeltons Karawane",
	["Gizmo for Warug"] = "Gizmo für Warug",
	["Glowcap Mushrooms"] = "Glühkappenpilze",
	["Glowing Scorpid Blood"] = "Leuchtendes Skorpidblut",
	["Glyphed Oaken Branch"] = "Glyphenverzierter Eichenast",
	["Glyphic Letter"] = "Glyphenbrief",
	["Glyphic Memorandum"] = "Glyphenmemorandum",
	["Glyphic Scroll"] = "Glyphenrolle",
	["Glyphic Tablet"] = "Glyphenschrifttafel",
	["Gnarlpine Corruption"] = "Die Verderbnis der Knarzklauen",
	["Gnogaine"] = "Gnogaine",
	["Gnome Engineering"] = "Gnomeningenieurskunst",
	["Gnome Improvement"] = "Gnomenverbesserungen",
	["Gnomer-gooooone!"] = "Gnomer-weeeeg!",
	["Go to the Front"] = "Geht zur Front",
	["Goblin Invaders"] = "Goblineindringlinge",
	["Goblin Sponsorship"] = "Goblinsponsoring",
	["Gol'dir"] = "Gol'dir",
	["Gold Dust Exchange"] = "Tauschhandel mit Goldstaub",
	["Goldenmist Village"] = "Goldnebel",
	["Goldleaf's Discovery"] = "Goldblatts Entdeckung",
	["Goldtooth"] = "Goldzahn",
	["Good Luck Charm"] = "Glücksbringer",
	["Good Natured Emma"] = "Emma die Nette",
	["Goods from Silvermoon City"] = "Waren von Silbermond",
	["Gor'tesh the Brute Lord"] = "Gor'tesh der Schläger-Lord",
	["Gordo's Task"] = "Gordos Aufgabe",
	["Gordunni Cobalt"] = "Gordunnikobalt",
	["Goretusk Liver Pie"] = "Pastete aus Geiferzahnleber",
	["Gorgrom the Dragon-Eater"] = "Gorgrom der Drachenfresser",
	["Grand Master Dumphry"] = "Großmeister Dumphry",
	["Grand Master Rohok"] = "Großmeister Rohok",
	["Grape Manifest"] = "Traubenliste",
	["Grark Lorkrub"] = "Grark Lorkrub",
	["Graverobbers"] = "Grabräuber",
	["Greatfather Winter is Here!"] = "Altvater Winter ist hier!",
	["Greed"] = "Gier",
	["Green Fireworks"] = "Grünes Feuerwerk",
	["Green Iron Bracers"] = "Grüne Eisenarmschienen",
	["Grey Iron Weapons"] = "Waffen aus grauem Eisen",
	["Grillok \"Darkeye\""] = "Grillok 'Finsterauge'",
	["Grim Message"] = "Grausige Botschaft",
	["Grimand Elmore"] = "Grimand Elmore",
	["Grimand's Armor"] = "Grimands Rüstung",
	["Grimand's Finest Work"] = "Grimands feinste Arbeit",
	["Grime-Encrusted Ring"] = "Schmutzverkrusteter Ring",
	["Grimscale Pirates!"] = "Piraten der Grimmschuppen!",
	["Grimtotem Spying"] = "Grimmtotemspionage",
	["Grove of the Ancients"] = "Der Hain der Uralten",
	["Gryphon Master Talonaxe"] = "Greifenmeister Krallenaxt",
	["Gryth Thurden"] = "Gryth Thurden",
	["Guarded Thunderbrew Barrel"] = "Das bewachte Fass mit Donnerbier",
	["Guardians of the Altar"] = "Wächter des Altars",
	["Guarding Secrets"] = "Geheimnisse bewachen",
	["Guile of the Raptor"] = "Arglist des Raptors",
	["Gurf's Dignity"] = "Gurfs Würde",
	["Gurok the Usurper"] = "Gurok der Thronräuber",
	["Gyro... What?"] = "Gyro... Was?",
	["Gyrodrillmatic Excavationators"] = "Gyrobohrmatische Exkavation",
	["Gyromast's Retrieval"] = "Gyromasts Rettung",
	["Gyromast's Revenge"] = "Gyromasts Rache",
	["HELP!"] = "Die Allianz braucht Euch!",
	["Halgar's Summons"] = "Halgars Beschwörung",
	["Hallow's End Treats for Jesper!"] = "Schlotternachtssüßigkeiten für Jesper!",
	["Hallow's End Treats for Spoops!"] = "Schlotternachtssüßigkeiten für Spuks!",
	["Hallowed Letter"] = "Geheiligter Brief",
	["Hallowed Rune"] = "Geheiligte Rune",
	["Hallowed Scroll"] = "Geheiligte Rolle",
	["Hallowed Sigil"] = "Geheiligtes Siegelzeichen",
	["Hallowed Tablet"] = "Geheiligte Schrifttafel",
	["Hameya's Plea"] = "Hameyas Bitte",
	["Hammerfall"] = "Hammerfall",
	["Hamuul Runetotem"] = "Hamuul Runentotem",
	["Hand of Iruxos"] = "Hand von Iruxos",
	["Handle With Care"] = "Vorsichtig behandeln",
	["Hands of the Enemy"] = "Hände des Feindes",
	["Harbinger of Doom"] = "Herold der Verdammnis",
	["Harbingers of Shadowmoon"] = "Herolde des Schattenmondklans",
	["Hardened Shells"] = "Gehärtete Schalen",
	["Harlan Needs a Resupply"] = "Harlan braucht Nachschub",
	["Harnessing Shadows"] = "Schatten einspannen",
	["Harpies Threaten"] = "Harpyien drohen",
	["Harpy Lieutenants"] = "Offiziere der Harpyien",
	["Harpy Raiders"] = "Räuberische Harpyien",
	["Harvesting the Fel Ammunition"] = "Teufelsmunition",
	["Have You Ever Seen One of These?"] = "Habt Ihr sowas schon mal gesehen?",
	["Haze of Evil"] = "Der Dunst des Bösen",
	["He Called Himself Altruis..."] = "Er nannte sich Altruis...",
	["Healing the Lake"] = "Die Heilung des Sees",
	["Healthy Dragon Scale"] = "Gesunde Großdrachenschuppe",
	["Heart of Rage"] = "Im Herzen des Hasses",
	["Hearts of Zeal"] = "Herzen des Eifers",
	["Hearts of the Pure"] = "Herzen der Reinen",
	["Heartswood"] = "Herzholz",
	["Heavy Grinding Stone"] = "Schwerer Schleifstein",
	["Heirloom Weapon"] = "Erbstückwaffe",
	["Helcular's Revenge"] = "Helculars Rache",
	["Hellfire Fortifications"] = "Höllenfeuerbefestigungen",
	["Help Mama Wheeler"] = "Helft Mama Mauschel",
	["Help Ranger Valanna!"] = "Hilfe für Waldläuferin Valanna!",
	["Help Tavara"] = "Helft Tavara",
	["Help Watcher Biggs"] = "Helft Behüter Biggs",
	["Helping the Cenarion Post"] = "Dem Posten des Cenarius helfen",
	["Helping the Lost Find Their Way"] = "Den Verirrten den Weg zeigen",
	["Hemet Nesingwary Jr."] = "Hemet Nesingwary Jr.",
	["Hero of the Brood"] = "Held des Schwarms",
	["Hero of the Mag'har"] = "Held der Mag'har",
	["Hero of the Sin'dorei"] = "Held der Sin'dorei",
	["Hero of the Stormpike"] = "Held der Sturmlanzen",
	["Heroes of Darrowshire"] = "Helden von Darroheim",
	["Heroes of Old"] = "Helden der Vergangenheit",
	["Hex of Weakness"] = "Verhexung der Schwäche",
	["Hezrul Bloodmark"] = "Hezrul Blutmal",
	["Hidden Enemies"] = "Verborgene Feinde",
	["Hidden Secrets"] = "Verborgene Geheimnisse",
	["Hidden Treasures"] = "Versteckte Schätze",
	["High Chief Winterfall"] = "Oberhäuptling der Winterfelle",
	["High Sorcerer Andromath"] = "Zaubermeister Andromath",
	["High Value Targets"] = "Hochrangige Ziele",
	["Highperch Venom"] = "Steilhanggift",
	["Hilary's Necklace"] = "Hilarys Halskette",
	["Hinott's Assistance"] = "Hinotts Hilfe",
	["Hints of a New Plague?"] = "Hinweise auf eine neue Seuche?",
	["Hints of the Past"] = "Die Vergangenheit erwacht",
	["Hippogryph Master Stephanos"] = "Hippogryphenmeister Stephanos",
	["Hippogryph Muisek"] = "Muisek von Hippogryphen",
	["Hitting the Motherlode"] = "Die Kristallader anzapfen",
	["Hive'Ashi Scout Report"] = "Späherbericht des Ashischwarms",
	["Hive'Regal Scout Report"] = "Späherbericht des Regalschwarms",
	["Hive'Zora Scout Report"] = "Späherbericht des Zoraschwarms",
	["Hoary Templar"] = "Weißgrauer Templer",
	["Holy Bologna: What the Light Won't Tell You"] = "Heiliger Fleischklops: Was das Licht Dir nicht erzählt",
	["Homeward Bound"] = "Auf der Heimreise",
	["Honor Students"] = "Ehrenstudenten",
	["Honor the Dead"] = "Ehret die Toten",
	["Honor the Fallen"] = "Die Gefallenen ehren",
	["Honored Amongst the Clan"] = "Ehre innerhalb des Klans",
	["Honored Amongst the Guard"] = "Ehre innerhalb der Garde",
	["Honoring a Hero"] = "Die Ehrung eines Helden",
	["Hoodoo Hex"] = "Verhexung des Hoodoo",
	["Horde Presence"] = "Hordenpräsenz",
	["Horde Trauma"] = "Traumachirurg der Horde",
	["Horns of Frenzy"] = "Hörner der Raserei",
	["Host of the Hidden City"] = "Host of the Hidden City", --Missing translation
	["Hostile Takeover"] = "Feindliche Übernahme",
	["Hot Fiery Death"] = "Heiße",
	["Hotter than Hell"] = "Heißer als die Hölle",
	["Houses of the Holy"] = "Häuser der Heiligen",
	["How Big a Threat?"] = "Wie groß ist die Bedrohung?",
	["How to Break Into the Arcatraz"] = "Wie man in Arkatraz einbricht",
	["Howling in the Hills"] = "Geheul in den Hügeln",
	["Humbert's Sword"] = "Humberts Schwert",
	["Humble Beginnings"] = "Ein bescheidener Anfang",
	["Hungry!"] = "Hunger!",
	["Hunt for Yenniku"] = "Die Suche nach Yenniku",
	["Hunt the Savages"] = "Jagt die Wilden",
	["Hunting for Ectoplasm"] = "Ektoplasmajagd",
	["Hunting in Stranglethorn"] = "Jagd im Schlingendorntal",
	["Hurley Blackbreath"] = "Hurley Pestatem",
	["Hypercapacitor Gizmo"] = "Hyperkondensator-Dingsda",
	["I Got Nothin' Left!"] = "Ich hab nix mehr!",
	["I Know A Guy..."] = "Ich kenne einen Typen...",
	["I Must Have Them!"] = "Ich muss sie haben!",
	["I See Alcaz Island In Your Future..."] = "Ich sehe die Insel Alcaz in Eurer Zukunft",
	["I See Dead Draenei"] = "Ich sehe tote Draenei",
	["I Shoot Magic Into the Darkness"] = "Licht ins Dunkel bringen",
	["I Was A Lot Of Things..."] = "Ich war schon vieles...",
	["I Work... For the Horde!"] = "Ich arbeite... für die Horde!",
	["I'm Saved!"] = "Ich bin gerettet!",
	["I've Got a Plant"] = "Einen Plan aus Hecken",
	["Ice Thistle E'ko"] = "E'ko der Eisdistelyetis",
	["Identify Plant Parts"] = "Pflanzenteile identifizieren",
	["Identifying the Brood"] = "Die Brut identifizieren",
	["Idols of the Feralfen"] = "Götzen des Wildfennstamms",
	["Ignition"] = "Zündung",
	["Ill Omens"] = "Schwarze Magie",
	["Illidan's Pupil"] = "Illidans Schüler",
	["Illidari-Bane Shard"] = "Splitter des Illidaribanns",
	["Imbuing the Headpiece"] = "Das Kopfstück mit Magie erfüllen",
	["Impending Attack"] = "Drohender Angriff",
	["Imperial Plate Armor"] = "Imperiale Plattenrüstung",
	["Imperial Plate Belt"] = "Imperialer Plattengürtel",
	["Imperial Plate Boots"] = "Imperiale Plattenstiefel",
	["Imperial Plate Bracer"] = "Imperiale Plattenarmschienen",
	["Imperial Plate Chest"] = "Handwerksverfügung - Imperiale Plattenrüstung",
	["Imperial Plate Helm"] = "Imperialer Plattenhelm",
	["Imperial Plate Leggings"] = "Imperiale Plattengamaschen",
	["Imperial Plate Shoulders"] = "Imperiale Plattenschultern",
	["Imperial Qiraji Regalia"] = "Imperiale Qirajiinsignien",
	["Improved Quality"] = "Beste Qualität",
	["In A Scrap With The Legion"] = "Legion in Trümmern",
	["In Defense of Frostwolf"] = "Die Verteidigung der Frostwölfe",
	["In Defense of the King's Lands"] = "Verteidigung der Länder des Königs",
	["In Dreams"] = "In den Träumen",
	["In Eranikus' Own Words"] = "Mit Eranikus' eigenen Worten",
	["In Favor of Elune"] = "Elune geneigt",
	["In Favor of Spirituality"] = "Der Spiritualität geneigt",
	["In Favor of the Light"] = "Dem Licht geneigt",
	["In Good Hands"] = "In guten Händen",
	["In Good Taste"] = "Dem guten Geschmacke",
	["In Need of Felblood"] = "Die Suche nach Teufelsblut",
	["In Nightmares"] = "Alptraum",
	["In Pursuit of Featherbeard"] = "Suche nach Federbart",
	["In Search of Anthion"] = "Suche nach Anthion",
	["In Search of Farahlite"] = "Auf der Suche nach Farahlit",
	["In Search of Galvan"] = "Auf der Suche nach Galvan",
	["In Search of Knowledge"] = "Auf der Suche nach Wissen",
	["In Search of Menara Voidrender"] = "Auf der Suche nach Menara Leerbringer",
	["In Search of Sedai"] = "Die Suche nach Sedai",
	["In Search of Thaelrid"] = "Auf der Suche nach Thaelrid",
	["In Search of The Excavation Team"] = "Auf der Suche nach dem Ausgrabungstrupp",
	["In Search of The Temple"] = "Auf der Suche nach dem Tempel",
	["In the Name of the Light"] = "Im Namen des Lichts",
	["Incendius!"] = "Incendius!",
	["Incendosaurs? Whateverosaur is More Like It"] = "Incendosaurier? Was-auch-immer-Saurier?",
	["Incoming Gumdrop"] = "Kaugummikugelexpress",
	["Incriminating Documents"] = "Belastende Dokumente",
	["Indispensable Tools"] = "Unverzichtbare Werkzeuge",
	["Indurium"] = "Indurium",
	["Indurium Ore"] = "Induriumerz",
	["Ineptitude + Chemicals = Fun"] = "Stümperhaftigkeit + Chemikalien = Riesenspaß!",
	["Inert Scourgestones"] = "Gereinigte Geißelsteine",
	["Infallible Mind"] = "Unfehlbare Gedanken",
	["Infiltrating Dragonmaw Fortress"] = "Unterwanderung der Festung des Drachenmals",
	["Infiltrating the Castle"] = "Eindringen ins Schloss",
	["Infiltration"] = "Unterwanderung",
	["Inform Leoroxx!"] = "Informiert Leoroxx!",
	["Information Gathering"] = "Informationen sammeln",
	["Ink Supplies"] = "Tinten-Zutaten",
	["Inoculation"] = "Immunisierung",
	["Inquire at the Inn"] = "Nachforschungen im Gasthaus",
	["Insane Druids"] = "Irrsinnige Druiden",
	["Insect Part Analysis"] = "Insektenteil-Analyse",
	["Intercepting the Message"] = "Abfangen der Nachricht",
	["Into Occupied Territory"] = "In besetztem Gebiet",
	["Into The Maw of Madness"] = "Der Schlund des Wahnsinns",
	["Into The Scarlet Monastery"] = "In das Scharlachrote Kloster",
	["Into The Temple of Atal'Hakkar"] = "Im Tempel von Atal'Hakkar",
	["Into the Breach"] = "Auf in den Kampf!",
	["Into the Churning Gulch"] = "In die Grabenschlucht",
	["Into the Depths"] = "In die Tiefen",
	["Into the Draenethyst Mine"] = "In die Draenethystmine",
	["Into the Dream"] = "Im Traum",
	["Into the Field"] = "Auf ins Feld",
	["Into the Heart of the Labyrinth"] = "In das Herz des Labyrinths",
	["Invaders of Alterac Valley"] = "Die Invasoren des Alteractals",
	["Invaluable Asset Zapping"] = "Unschätzbare Ausrüstung beamen",
	["Invasion Point: Annihilator"] = "Invasionspunkt: Vernichter",
	["Invasion Point: Cataclysm"] = "Invasionspunkt: Katastrophe",
	["Investigate An'daroth"] = "Untersucht An'daroth",
	["Investigate Echo Ridge"] = "Überprüfung der Echokammmine",
	["Investigate Tuurem"] = "Untersuchung von Tuurem",
	["Investigate the Alchemist Shop"] = "Untersuchungen im Alchimistenladen",
	["Investigate the Amani Catacombs"] = "Untersucht die Amanikatakomben",
	["Investigate the Blue Recluse"] = "Untersuchungen im Blauen Eremiten",
	["Investigate the Camp"] = "Untersuchung des Lagers",
	["Investigate the Crash"] = "Untersuchung der Absturzstelle",
	["Iron Coral"] = "Eisenkoralle",
	["Ironband Wants You!"] = "Eisenband sucht Euch!",
	["Ironband's Compound"] = "Eisenbands Truppenlager",
	["Ironband's Excavation"] = "Eisenbands Ausgrabungsstätte",
	["Irondeep Supplies"] = "Vorräte der Eisenschachtmine",
	["Irradiated Crystal Shards"] = "Bestrahlte Kristallsplitter",
	["Isha Awak"] = "Isha Awak",
	["Ishamuhale"] = "Ishamuhale",
	["Ishanah"] = "Ishanah",
	["Ishanah's Help"] = "Ishanahs Hilfe",
	["It's Dangerous to Go Alone"] = "Allein ist es gefährlich",
	["It's Just That Easy?"] = "So einfach ist das?",
	["It's Watching You!"] = "Es beobachtet Euch!",
	["It's a Secret to Everybody"] = "Es ist für jeden ein Geheimnis",
	["It's a Trap!"] = "Das ist eine Falle!",
	["Items of Power"] = "Gegenstände der Macht",
	["Items of Some Consequence"] = "Nicht unwichtige Gegenstände",
	["Ivar the Foul"] = "Ivar der Verfaulte",
	["Iverron's Antidote"] = "Iverrons Gegengift",
	["Ivus the Forest Lord"] = "Ivus der Waldfürst",
	["JOB OPPORTUNITY: Culling the Competition"] = "STELLE ZU VERGEBEN: Erledige die Konkurrenz",
	["Jail Break!"] = "Gefängnisausbruch!",
	["James Hyal"] = "James Hyal",
	["Jammal'an the Prophet"] = "Jammal'an der Prophet",
	["Jarl Needs Eyes"] = "Jarl braucht Augen",
	["Jarl Needs a Blade"] = "Jarl braucht eine Klinge",
	["Je'neu of the Earthen Ring"] = "Je'neu vom Irdenen Ring",
	["Jes'rimon's Payment to Jediga"] = "Jes'rimons Bezahlung für Jediga",
	["Jin'Zil's Forest Magic"] = "Jin'Zils Waldmagie",
	["Jitters' Growling Gut"] = "Bibbers' knurrender Magen",
	["Job Opening: Guard Captain of Revantusk Village"] = "Offener Posten: Wachbefehlshaber der Bruchhauer",
	["Jol"] = "Jol",
	["Jonespyre's Request"] = "Lebenshands Bitte",
	["Jorn Skyseer"] = "Jorn Himmelsdeuter",
	["Journey into Thunder Bluff"] = "Reise nach Donnerfels",
	["Journey to Astranaar"] = "Reise nach Astranaar",
	["Journey to Hillsbrad Foothills"] = "Reise in das Vorgebirge des Hügellands",
	["Journey to Honor Hold"] = "Reise zur Ehrenfeste",
	["Journey to Stonetalon Peak"] = "Reise zum Steinkrallengipfel",
	["Journey to Tarren Mill"] = "Reise nach Tarrens Mühle",
	["Journey to Thrallmar"] = "Reise nach Thrallmar",
	["Journey to Undercity"] = "Reise nach Unterstadt",
	["Journey to the Crossroads"] = "Reise zum Wegekreuz",
	["Journey to the Marsh"] = "Reise in die Marschen",
	["Joys of Omosh"] = "Freude der Omoshs",
	["Ju-Ju Heaps"] = "Jujuhaufen",
	["Judgment and Redemption"] = "Gerechtigkeit und Erlösung",
	["Juice Delivery"] = "Saftlieferung",
	["Jungle Secrets"] = "Geheimnisse im Dschungel",
	["Junkboxes Needed"] = "Plunderkisten benötigt",
	["Just Compensation"] = "Die angemessene Entlohnung",
	["Jyoba's Report"] = "Jyobas Bericht",
	["KILL ON SIGHT: Dark Iron Dwarves"] = "SOFORT TÖTEN: Dunkeleisenzwerge",
	["KILL ON SIGHT: High Ranking Dark Iron Officials"] = "SOFORT TÖTEN: Hochrangige Führungskräfte der Dunkeleisenzwerge",
	["Kaela's Update"] = "Kaelas Update",
	["Kamsis"] = "Kamsis",
	["Karabor Training Grounds"] = "Ausbildungsgelände von Karabor",
	["Karynaku"] = "Karynaku",
	["Kaya's Alive"] = "Kaya lebt",
	["Kayneth Stillwind"] = "Kayneth Stillwind",
	["Keanna's Log"] = "Keannas Aufzeichnungen",
	["Keep An Eye Out"] = "Ein Auge offen halten",
	["Keep Thornfang Hill Clear!"] = "Haltet den Dornnebelhügel sauber!",
	["Keeper of the Flame"] = "Bewahrer der Flamme",
	["Keeping Pace"] = "Tempo halten",
	["Keeping Up Appearances"] = "Den Schein wahren",
	["Ken'zigla's Draught"] = "Ken'ziglas Trunk",
	["Khadgar"] = "Khadgar",
	["Khan Dez'hepah"] = "Khan Dez'hepah",
	["Khan Hratha"] = "Khan Hratha",
	["Khan Jehn"] = "Khan Jehn",
	["Khan Shaka"] = "Khan Shaka",
	["Kharan Mighthammer"] = "Kharan Hammermacht",
	["Kharan's Tale"] = "Kharans Geschichte",
	["Kibler's Exotic Pets"] = "Kiblers Exotische Tiere",
	["Kick Them While They're Down"] = "Tretet si",
	["Kidnapped Elder Torntusk!"] = "Die Entführung des Ältesten Stumpfhauer",
	["Kill Grundig Darkcloud"] = "Tötet Grundig Finsterwolke",
	["Kill the Shadow Council!"] = "Tötet den Schattenrat!",
	["Killing the Crawlers"] = "Die Krabbler erschlagen",
	["Kim'jael Indeed!"] = "Kim'jae",
	["Kim'jael's \"Missing\" Equipment"] = "Kim'jaels 'fehlende' Ausrüstung",
	["Kindness"] = "Freundlichkeit",
	["King of the Foulweald"] = "König der Fäulnisklauen",
	["Kingly Shakedown"] = "Königliche Erpressung",
	["Kirith"] = "Kirith",
	["Kirtonos the Herald"] = "Kirtonos der Herold",
	["Kitchen Assistance"] = "Küchengehilfe",
	["Klaven's Tower"] = "Klavens Turm",
	["Klockmort Spannerspan"] = "Klockmort Spannsplint",
	["Klockmort's Creation"] = "Klockmorts Kreation",
	["Klockmort's Essentials"] = "Klockmorts Grundlagen",
	["Know Thine Enemy"] = "Kenne deinen Feind",
	["Know your Enemy"] = "Den Feind kennen",
	["Knowledge in the Deeps"] = "Wissen in der Tiefe",
	["Knowledge of the Orb of Orahil"] = "Wissen der Kugel von Orahil",
	["Kobold Camp Cleanup"] = "Säuberung im Koboldlager",
	["Kobold Candles"] = "Koboldkerzen",
	["Kodo Hide Bag"] = "Kodobalgtasche",
	["Kodo Roundup"] = "Kodozusammentrieb",
	["Kolkar Leaders"] = "Anführer der Kolkar",
	["Krastinov's Bag of Horrors"] = "Krastinovs Tasche der Schrecken",
	["Krasus's Compendium"] = "Krasus' Kompendium",
	["Krazek's Cookery"] = "Kochen mit Krazek",
	["Kris of Unspoken Names"] = "Kris der ungesagten Namen",
	["Krom'Grul"] = "Krom'Grul",
	["Kroshius' Infernal Core"] = "Kroshius Höllenbestienkern",
	["Kum'isha's Endeavors"] = "Kum'ishas Bemühungen",
	["Kurzen's Mystery"] = "Das Geheimnis um Kurzen",
	["Lack of Surplus"] = "Mangelnde Reserven",
	["Lakota'mani"] = "Lakota'mani",
	["Land Ho!"] = "Land Ho!",
	["Lard Lost His Lunch"] = "Lards vergessene Brotzeit",
	["Larion and Muigin"] = "Larion und Muigin",
	["Laughing Sisters"] = "Lachende Schwestern",
	["Laying Waste to the Unwanted"] = "Die Unerwünschten zerstören",
	["Lazy Peons"] = "Faule Peons",
	["Leader of the Bloodscale"] = "Anführerin der Blutschuppen",
	["Leader of the Darkcrest"] = "Anführer der Dunkelkämme",
	["Leaders of the Fang"] = "Anführer der Giftzähne",
	["Learning from the Crystals"] = "Von den Kristallen lernen",
	["Learning the Language"] = "Erlernen der Sprache",
	["Ledger from Tanaris"] = "Geschäftsbuch aus Tanaris",
	["Legends of Maraudon"] = "Legenden von Maraudon",
	["Leonid Barthalomew"] = "Leonidas Bartholomäus",
	["Lethtendris's Web"] = "Lethtendris' Netz",
	["Letter to Jin'Zil"] = "Brief an Jin'Zil",
	["Letter to Stormpike"] = "Brief an Sturmlanze",
	["Levixus the Soul Caller"] = "Levixus der Seelenrufer",
	["Libram of Constitution"] = "Buchband der Konstitution",
	["Libram of Focus"] = "Buchband des Fokus",
	["Libram of Protection"] = "Buchband des Schutzes",
	["Libram of Rapidity"] = "Buchband der Schnelligkeit",
	["Libram of Resilience"] = "Buchband der Abhärtung",
	["Libram of Rumination"] = "Buchband des Nachsinnens",
	["Libram of Tenacity"] = "Buchband der Hartnäckigkeit",
	["Libram of Voracity"] = "Buchband der Gier",
	["Lieutenant Paval Reethe"] = "Leutnant Paval Reethe",
	["Life's Finer Pleasures"] = "Die feinen Freuden im Leben",
	["Lifting the Curse"] = "Brechen des Fluchs",
	["Limits of Physical Exhaustion"] = "Grenze der Erschöpfung",
	["Lines of Communication"] = "Nachrichtenwege",
	["Linken's Adventure"] = "Linkens Abenteuer",
	["Linken's Memory"] = "Linkens Andenken",
	["Linken's Sword"] = "Linkens Schwert",
	["Liquid Stone"] = "Flüssigstein",
	["Little Embers"] = "Kleine Funken",
	["Little Morsels"] = "Kleine Häppchen",
	["Load Lightening"] = "Gewicht reduzieren",
	["Lonebrow's Journal"] = "Einbraues Tagebuch",
	["Long Forgotten Memories"] = "Lang Vergessenes",
	["Longtail is the Lynchpin"] = "Langschweif ist der springende Punkt",
	["Look To The Stars"] = "Der Blick zu den Sternen",
	["Look to an Old Friend"] = "Auf einen alten Freund verlassen",
	["Looking Further"] = "Weitere Beobachtungen",
	["Looking to the Leadership"] = "Suche nach den Anführern",
	["Loramus"] = "Loramus",
	["Lord Aliden Perenolde"] = "Lord Aliden Perenolde",
	["Lord Banehollow"] = "Lord Schattenfluch",
	["Lord Maxwell Tyrosus"] = "Lord Maxwell Tyrosus",
	["Lords of the Council"] = "Lords des Rates",
	["Lore for a Price"] = "Lehren haben ihren Preis",
	["Losing Gracefully"] = "In Würde verlieren",
	["Lost Armaments"] = "Zurückgelassene Waffen",
	["Lost But Not Forgotten"] = "Verlore",
	["Lost Deathstalkers"] = "Die verlorenen Todespirscher",
	["Lost Necklace"] = "Die verlorene Halskette",
	["Lost Thunderbrew Recipe"] = "Verlorenes Donnerbräurezept",
	["Lost in Action"] = "Bei der Arbeit verschollen",
	["Lost in Battle"] = "In der Schlacht vermisst",
	["Lost!"] = "Verloren!",
	["Love Song for Narain"] = "Liebesbrief für Narain",
	["Love's Gift"] = "Die Liebesgabe",
	["Luck Be With You"] = "Das Glück sei mit Euch",
	["Mac'Aree Mushroom Menagerie"] = "Pilzsammlung von Mac'Aree",
	["MacKreel's Moonshine"] = "MacKreels Fusel",
	["Mace of Unending Life"] = "Streitkolben des endlosen Lebens",
	["Maelstrom's Wrath"] = "Maelstroms Zorn",
	["Magatha's Payment to Jediga"] = "Magathas Bezahlung für Jediga",
	["Mage Summoner"] = "Magier-Beschwörer",
	["Mage Training"] = "Ausbildung zum Magier",
	["Mage's Wand"] = "Der Zauberstab des Magiers",
	["Mage-tastic Gizmonitor"] = "Magitastischer Gizmonitor",
	["Magecraft"] = "Geschick der Magier",
	["Magic Dust"] = "Magischer Staub",
	["Magic of the Arakkoa"] = "Die Magie der Arakkoa",
	["Magical Analysis"] = "Magische Analyse",
	["Magical Disturbances"] = "Magische Störungen",
	["Magram Alliance"] = "Allianz mit den Magram",
	["Mahren Skyseer"] = "Mahren Himmelsdeuter",
	["Mai'Zoth"] = "Mai'Zoth",
	["Major Malfunction"] = "Schwere Fehlfunktion",
	["Make Them Listen"] = "Bringt sie zum Zuhören",
	["Making Amends"] = "Wiedergutmachung",
	["Making Sense of It"] = "Die Sache verstehen",
	["Maktu's Revenge"] = "Maktus Rache",
	["Makuru's Vengeance"] = "Makurus Rache",
	["Malaise"] = "Fauler Zauber",
	["Malevolent Remnants"] = "Bösartige Überbleibsel",
	["Malfunction at the West Sanctum"] = "Zwischenfall beim Sanktum des Westens",
	["Malin's Request"] = "Malins Gesuch",
	["Mana Surges"] = "Manawogen",
	["Manaforge B'naar"] = "Manaschmiede B'naar",
	["Manaweave Robe"] = "Managewirkte Robe",
	["Manhunt"] = "Menschenjagd",
	["Mantle of the Oracle"] = "Mantel des Orakels",
	["Mantles of the Dawn"] = "Mäntel der Dämmerung",
	["Maps and Runes"] = "Karten und Runen",
	["Marauders of Darrowshire"] = "Marodeure von Darroheim",
	["Marauding Crust Bursters"] = "Marauding Crust Bursters", --Missing translation
	["Marauding Wolves"] = "Marodierende Wölfe",
	["Marg Speaks"] = "Marg spricht",
	["Margoz"] = "Margoz",
	["Mark V is Alive!"] = "Nummer V lebt!",
	["Marking the Path"] = "Den Weg kennzeichnen",
	["Marks of Kil'jaeden"] = "Male von Kil'jaeden",
	["Marks of Sargeras"] = "Mal des Sargeras",
	["Marla's Last Wish"] = "Marlas letzter Wunsch",
	["Marshal Haggard"] = "Marschall Haggard",
	["Marshal Windsor"] = "Marschall Windsor",
	["Martek the Exiled"] = "Martek der Verbannte",
	["Marvon's Workshop"] = "Marvons Werkstatt",
	["Massacre at Gruul's Lair"] = "Massaker in Gruuls Unterschlupf",
	["Master Angler"] = "Anglermeister",
	["Master of the Wild Leather"] = "Meister des Wildleders",
	["Mastering the Elements"] = "Die Beherrschung der Elemente",
	["Material Assistance"] = "Materielle Unterstützung",
	["Material Components"] = "Zutaten sammeln",
	["Mathias and the Defias"] = "Mathias und die Defias",
	["Mathiel"] = "Mathiel",
	["Mathiel's Armor"] = "Mathiels Rüstung",
	["Mathystra Relics"] = "Relikte von Mathystra",
	["Matis the Cruel"] = "Matis der Grausame",
	["Matters of Security"] = "Eine Frage der Sicherheit",
	["Maxnar Must Die!"] = "Maxnar muss sterben!",
	["Maxwell's Mission"] = "Maxwells Mission",
	["Mayara Brightwing"] = "Mayara Wolkenglanz",
	["Mazen's Behest"] = "Mazens Befehl",
	["Mazzranache"] = "Mazzranache",
	["Measuring Warp Energies"] = "Warpenergien messen",
	["Meats to Orgrimmar"] = "Fleisch für Orgrimmar",
	["Mechanical Repair Kits"] = "Mechanische Repariersets",
	["Medallion of Station"] = "Das Standesmedallion",
	["Medicinal Purpose"] = "Medizinische Notwendigkeit",
	["Medivh's Journal"] = "Medivhs Tagebuch",
	["Meet at the Grave"] = "Treffen am Grab",
	["Meeting at the Blackwing Coven"] = "Treffen am Pechschwingenkoven",
	["Meeting with the Master"] = "Treffen mit dem Meister",
	["Melding of Influences"] = "Vereinigung von Einflüssen",
	["Melor Sends Word"] = "Melor schickt Kunde",
	["Menacing Marshfangs"] = "Bedrohliche Marschenfänge",
	["Mending Old Wounds"] = "Heilen alter Wunden",
	["Menethil's Gift"] = "Menethils Geschenk",
	["Mennet Carkad"] = "Mennet Carkad",
	["Mercenaries"] = "Söldner",
	["Mercy for the Cursed"] = "Mitleid mit den Verfluchten",
	["Message in a Bottle"] = "Flaschenpost",
	["Message to Freewind Post"] = "Nachricht zum Freiwindposten",
	["Message to Garadar"] = "Nachricht für Garadar",
	["Message to Maxwell"] = "Nachricht an Maxwell",
	["Message to Telaar"] = "Nachricht für Telaar",
	["Message to the Daggerfen"] = "Nachricht für Dolchfenn",
	["Message to the Wildhammer"] = "Eine Botschaft an die Wildhämmer",
	["Messenger to Darkshire"] = "Botschaft nach Dunkelhain",
	["Messenger to Stormwind"] = "Botschaft nach Sturmwind",
	["Messenger to Thrall"] = "Bote für Thrall",
	["Messenger to Westfall"] = "Botschaft nach Westfall",
	["Messenger to the Feralfen"] = "Botschaft für den Wildfennstamm",
	["Metzen the Reindeer"] = "Metzen das Rentier",
	["Michael Garrett"] = "Michael Garrett",
	["Milly Osworth"] = "Milly Geltmark",
	["Milly's Harvest"] = "Millys Ernte",
	["Miner's Fortune"] = "Des Minenarbeiters Vermögen",
	["Minions of the Shadow Council"] = "Diener des Schattenrats",
	["Minshina's Skull"] = "Minshinas Schädel",
	["Mirages"] = "Illusionen",
	["Mirror Lake"] = "Spiegelsee",
	["Missing Crystals"] = "Vermisste Kristalle",
	["Missing Friends"] = "Vermisste Freunde",
	["Missing In Action"] = "Vermisst",
	["Missing Mag'hari Procession"] = "Verschollene mag'harische Prozession",
	["Missing Missive"] = "Fehlender Schriftverkehr",
	["Missing in the Ghostlands"] = "Verschollen in den Geisterlanden",
	["Mission: Gateways Murketh and Shaadraz"] = "Mission: Tore Murketh und Shaadraz",
	["Mission: Possible But Not Probable"] = "Mission: möglic",
	["Mission: The Abyssal Shelf"] = "Mission: Die abyssische Untiefe",
	["Mission: The Murketh and Shaadraz Gateways"] = "Mission: Tor Murketh und Tor Shaadraz",
	["Mist"] = "Meisterin der Illusionen",
	["Mo'mor the Breaker"] = "Mo'mor der Brecher",
	["Mok'Nathal Treats"] = "Leckerbissen der Mok'Nathal",
	["Mok'thardin's Enchantment"] = "Mok'Thardins Verzauberung",
	["Mold Rhymes With..."] = "Sold reimt sich auf...",
	["Moonglow Vest"] = "Mondscheinweste",
	["Moontouched Wildkin"] = "Mondbestrahltes Wildekin",
	["Mor'Ladim"] = "Mor'Ladim",
	["Mor'zul Bloodbringer"] = "Mor'zul Blutbringer",
	["Morbent Fel"] = "Morbent Teufels",
	["More Arakkoa Feathers"] = "More Arakkoa Feathers", --Missing translation
	["More Armor Kits"] = "Mehr Rüstungssets",
	["More Bat Eyes"] = "Mehr Fledermausaugen",
	["More Booty!"] = "Mehr Beute!",
	["More Components of Importance"] = "Mehr Komponenten von großer Wichtigkeit",
	["More Crystal Fragments"] = "Noch mehr Kristallfragmente",
	["More Dense Grinding Stones"] = "Mehr verdichtete Schleifsteine",
	["More Feathers"] = "Mehr Federn",
	["More Fertile Spores"] = "Noch mehr fruchtbare Sporen",
	["More Firewing Signets"] = "Mehr Siegel der Feuerschwingen",
	["More Glowcaps"] = "Noch mehr Glühkappen",
	["More Glowing Scorpid Blood"] = "Mehr leuchtendes Skorpidblut",
	["More Heads Full of Ivory"] = "Noch mehr Elfenbein",
	["More Irradiated Crystal Shards"] = "Mehr bestrahlte Kristallsplitter",
	["More Marks of Kil'jaeden"] = "Mehr Male von Kil'jaeden",
	["More Marks of Sargeras"] = "Mehr Male des Sargeras",
	["More Obsidian Warbeads"] = "Noch mehr Obsidiankriegsperlen",
	["More Power!"] = "More Power!", --Missing translation
	["More Rotting Hearts"] = "Mehr faulende Herzen",
	["More Spore Sacs"] = "Noch ein paar Sporensäcke",
	["More Tendrils!"] = "Mehr Ranken!",
	["More Thorium Widgets"] = "Mehr Thoriumapparate",
	["More Venom Sacs"] = "Mehr Giftbeutel",
	["More Warbeads"] = "Mehr Kriegsperlen",
	["More Warbeads!"] = "Mehr Kriegsperlen!",
	["More Wastewander Justice"] = "Noch mehr Wüstenläufergerechtigkeit",
	["More than a Pound of Flesh"] = "Ein Pfund Geschnetzeltes",
	["Morgan Ladimore"] = "Morgan Ladimore",
	["Morgan Stern"] = "Morgan Stern",
	["Morganth"] = "Morganth",
	["Morrowgrain Research"] = "Morgenkornforschung",
	["Morrowgrain to Darnassus"] = "Morgenkorn nach Darnassus",
	["Morrowgrain to Feathermoon Stronghold"] = "Morgenkorn für die Mondfederfeste",
	["Morrowgrain to Thunder Bluff"] = "Morgenkorn nach Donnerfels",
	["Mortality Wanes"] = "Die Sterblichkeit schwindet",
	["Mother's Milk"] = "Muttermilch",
	["Mountain Giant Muisek"] = "Muisek von Bergriesen",
	["Mountaineer Stormpike's Task"] = "Gebirgsjäger Sturmlanzes Aufgabe",
	["Muck Diving"] = "Schlammtauchen",
	["Mudrock Soup and Bugs"] = "Schlammpanzersuppe mit Käfern",
	["Muigin and Larion"] = "Muigin und Larion",
	["Mura Runetotem"] = "Mura Runentotem",
	["Murdaloc"] = "Murdaloc",
	["Muren Stormpike"] = "Muren Sturmlanze",
	["Murkblood Corrupters"] = "Bösewichte der Finsterblut",
	["Murkblood Invaders"] = "Eindringlinge der Finsterblut",
	["Murkblood Leaders..."] = "Anführer der Finsterblut...",
	["Murloc Poachers"] = "Murlocwilderer",
	["Murlocs... Why Here? Why Now?"] = "Murlocs... Warum hier? Warum jetzt?",
	["Mystery Goo"] = "Geheimnisvoller Glibber",
	["Mystery Mask"] = "Die geheimnisvolle Maske",
	["Mythology of the Titans"] = "Mythologie der Titanen",
	["Myzrael's Allies"] = "Myzraels Verbündete",
	["Naaru Technology"] = "Die Technologie der Naaru",
	["Naga at the Zoram Strand"] = "Die Naga am Zoramstrand",
	["Naladu"] = "Naladu",
	["Nara Wildmane"] = "Nara Wildmähne",
	["Nat's Measuring Tape"] = "Nats Maßband",
	["Natural Armor"] = "Natürliche Rüstung",
	["Natural Enemies"] = "Natürliche Feinde",
	["Natural Materials"] = "Natürliche Materialien",
	["Natural Remedies"] = "Natürliche Heilmittel",
	["Necklace Recovery"] = "Wiederbeschaffung der Halskette",
	["Need for a Cure"] = "Heilmittel benötigt",
	["Needs More Cowbell"] = "Etwas mehr Klang bitte",
	["Neeka Bloodscar"] = "Neeka Blutnarbe",
	["Neeru Fireblade"] = "Neeru Feuerklinge",
	["Nefarius's Corruption"] = "Nefarius' Verderbnis",
	["Nek'rosh's Gambit"] = "Nek'roshs Schachzug",
	["Nekrum's Medallion"] = "Nekrums Medaillon",
	["Nessa Shadowsong"] = "Nessa Schattensang",
	["Nether Gas In a Fel Fire Engine"] = "Nethergas in einem Teufelsfeuermotor",
	["Nether-lace Garment"] = "Netherspitzengewand",
	["Neutralizing the Nethermancers"] = "Die Nethermanten neutralisieren",
	["Never Again!"] = "Nie wieder!",
	["Never Ask Me About My Business"] = "Fragt mich nie nach meinen Angelegenheiten",
	["New Life"] = "Neues Leben",
	["New Opportunities"] = "Neue Möglichkeiten",
	["New Year Celebrations!"] = "Neujahrsfeier!",
	["Newfound Allies"] = "Neue Verbündete",
	["News for Fizzle"] = "Neuigkeiten für Zischel",
	["News for Rakoria"] = "Nachrichten für Rakoria",
	["News from Zangarmarsh"] = "Nachricht aus den Zangarmarschen",
	["News of Dogran"] = "Neuigkeiten von Dogran",
	["News of Victory"] = "Nachricht vom Sieg",
	["Nexus-King Salhadaar"] = "Nexuskönig Salhadaar",
	["Night Web's Hollow"] = "Nachtweber",
	["No More Mushrooms!"] = "Keine Pilze mehr!",
	["No Time for Curiosity"] = "Keine Zeit für Neugier",
	["Noble Deaths"] = "Tod der Edlen",
	["Noboru the Cudgel"] = "Noboru der Knüppel",
	["Nogg's Ring Redo"] = "Noggs Ringerneuerung",
	["Noggenfogger Elixir"] = "Noggenfoggers Elixier",
	["Noggle's Last Hope"] = "Noggles letzte Hoffnung",
	["Noggle's Lost Satchel"] = "Noggles verlorener Ranzen",
	["Nolkai's Words"] = "Nolkais Worte",
	["Northfold Manor"] = "Nordhof",
	["Not On My Watch!"] = "Nicht solange ich hier wache!",
	["Note to William"] = "Nachricht an William",
	["Note to the Mayor"] = "Ein Brief für den Bürgermeister",
	["Nothin' Says Lovin' Like a Big Stinger"] = "Liebe ist ein großer Stachel",
	["Nothing But The Truth"] = "Nichts als die Wahrheit",
	["Now That We're Friends..."] = "Jetzt, da wir Freunde sind...",
	["Now That We're Still Friends..."] = "Jetzt, da wir immer noch Freunde sind...",
	["Noxious Lair Investigation"] = "Erkundung des Giftigen Unterschlupfes",
	["Nugget Slugs"] = "Schraubnieten",
	["Oakenscowl"] = "Grimmeiche",
	["Observing the Sporelings"] = "Sporlinge beobachten",
	["Obsidian Warbeads"] = "Obsidiankriegsperlen",
	["Oculus Illusions"] = "Oculus-Illusionen",
	["Of Coursers We Know"] = "Renner für einen höheren Zweck",
	["Of Forgotten Memories"] = "Von vergessenen Erinnerungen",
	["Of Lost Honor"] = "Von verlorener Ehre",
	["Of Love and Family"] = "Von Liebe und Familie",
	["Of Thistleheads and Eggs..."] = "Von Distelköpfen und Eiern...",
	["Off To Area 52"] = "Auf nach Area 52",
	["Ogre Head On A Stick = Party"] = "Ogerkopf auf einem Pfahl = Party",
	["Ogre Thieves"] = "Ogerdiebe",
	["Oh Brother. . ."] = "Oh Bruder...",
	["Old Hillsbrad"] = "Das alte Hügelland",
	["Old Whitebark's Pendant"] = "Weißborkes Anhänger",
	["Olemba Seed Oil"] = "Olembaöl",
	["Olemba Seeds"] = "Olembasamen",
	["Omarion's Handbook"] = "Omarions Leitfaden",
	["On Guard in Stonetalon"] = "Wache halten im Steinkrallengebirge",
	["On Iron Pauldrons"] = "Über Eisenschulterstücke",
	["On Nethery Wings"] = "Auf netherischen Schwingen",
	["On Spirit's Wings"] = "Auf geisterhaften Schwingen",
	["On the Wings of a Hippogryph"] = "Auf dem Rücken eines Hippogryphen",
	["Once Were Warriors"] = "Chroniken eines Kriegers",
	["One Demon's Trash..."] = "Der Müll eines Dämons",
	["One Draenei's Junk..."] = "Des einen Draeneis Plunder...",
	["One Shot. One Kill."] = "Ein Schuss, ein Treffer",
	["Ongeku"] = "Ongeku",
	["Onin's Report"] = "Onins Bericht",
	["Only One May Rise"] = "Nur einer kann sich erheben",
	["Onu"] = "Onu",
	["Onu is meditating"] = "Onu meditiert",
	["Onward to Ashenvale"] = "Auf ins Eschental!",
	["Operation Recombobulation"] = "Operation Rekombobulationsgerät",
	["Operation: Death to Angerforge"] = "Operation: Tod dem Zornesschmied",
	["Operative Bijou"] = "Agentin Bijou",
	["Oran's Gratitude"] = "Orans Dankbarkeit",
	["Ordanus"] = "Ordanus",
	["Order Must Be Restored"] = "Ordnung muss wieder hergestellt werden",
	["Orders from Lady Vashj"] = "Befehle von Lady Vashj",
	["Orendil's Cure"] = "Orendils Heilmittel",
	["Orm Stonehoof and the Brutal Helm"] = "Orm Steinhuf und der brutale Helm",
	["Ormer's Revenge"] = "Ormers Rache",
	["Oronok Torn-heart"] = "Oronok Herzeleid",
	["Oronu the Elder"] = "Oronu der Älteste",
	["Ortor My Old Friend..."] = "Mein alter Freund Ortor...",
	["Oshu'gun Crystal Powder"] = "Kristallpulver von Oshu'gun",
	["Other Fish to Fry"] = "Andere Fische zu grillen",
	["Outland Sucks!"] = "Die Scherbenwelt ist doof",
	["Outrider Advanced Care Package"] = "Verbessertes Überlebenspaket der Vorhut",
	["Outrider Basic Care Package"] = "Basisüberlebenspaket der Vorhut",
	["Outrider Standard Care Package"] = "Standardüberlebenspaket der Vorhut",
	["Outside Assistance"] = "Hilfe von außen",
	["Overlord"] = "Oberanführer",
	["Overlord Gorefist"] = "Oberanführer Schmetterfaust",
	["Overlord Mok'Morokk's Concern"] = "Oberanführer Mok'Morokks Sorgen",
	["Overmaster Pyron"] = "Übermeister Pyron",
	["Owatanka"] = "Owatanka",
	["Pacify the Centaur"] = "Befriedung der Zentauren",
	["Package Recovery"] = "Bergung des Päckchens",
	["Package for Thurman"] = "Eine Lieferung für Thurman",
	["Paladin Training"] = "Ausbildung zum Paladin",
	["Pamela's Doll"] = "Pamelas Puppe",
	["Panther Mastery"] = "Beherrschen der Pantherjagd",
	["Paragons of Power: The Augur's Belt"] = "Symbole der Macht: Der Gürtel des Weissagers",
	["Paragons of Power: The Augur's Bracers"] = "Symbole der Macht: Die Armschienen des Weissagers",
	["Paragons of Power: The Augur's Hauberk"] = "Symbole der Macht: Die Halsberge des Weissagers",
	["Paragons of Power: The Confessor's Bindings"] = "Symbole der Macht: Die Bindungen des Glaubenshüters",
	["Paragons of Power: The Confessor's Mantle"] = "Symbole der Macht: Der Mantel des Glaubenshüters",
	["Paragons of Power: The Confessor's Wraps"] = "Symbole der Macht: Die Handlappen des Glaubenshüters",
	["Paragons of Power: The Demoniac's Mantle"] = "Symbole der Macht: Der Mantel des Besessenen",
	["Paragons of Power: The Demoniac's Robes"] = "Symbole der Macht: Die Roben des Besessenen",
	["Paragons of Power: The Demoniac's Wraps"] = "Symbole der Macht: Die Handlappen des Besessenen",
	["Paragons of Power: The Freethinker's Armguards"] = "Symbole der Macht: Die Armschützer des Freidenkers",
	["Paragons of Power: The Freethinker's Belt"] = "Symbole der Macht: Der Gürtel des Freidenkers",
	["Paragons of Power: The Freethinker's Breastplate"] = "Symbole der Macht: Die Brustplatte des Freidenkers",
	["Paragons of Power: The Haruspex's Belt"] = "Symbole der Macht: Der Haruspexgürtel",
	["Paragons of Power: The Haruspex's Bracers"] = "Symbole der Macht: Die Haruspexarmschienen",
	["Paragons of Power: The Haruspex's Tunic"] = "Symbole der Macht: Die Haruspextunika",
	["Paragons of Power: The Illusionist's Mantle"] = "Symbole der Macht: Der Mantel des Illusionisten",
	["Paragons of Power: The Illusionist's Robes"] = "Symbole der Macht: Die Roben des Illusionisten",
	["Paragons of Power: The Illusionist's Wraps"] = "Symbole der Macht: Die Handlappen des Illusionisten",
	["Paragons of Power: The Madcap's Bracers"] = "Symbole der Macht: Die Armschienen des Wildfangs",
	["Paragons of Power: The Madcap's Mantle"] = "Symbole der Macht: Der Mantel des Wildfangs",
	["Paragons of Power: The Madcap's Tunic"] = "Symbole der Macht: Die Tunika des Wildfangs",
	["Paragons of Power: The Predator's Belt"] = "Symbole der Macht: Der Gürtel des Raubtiers",
	["Paragons of Power: The Predator's Bracers"] = "Symbole der Macht: Die Armschienen des Raubtiers",
	["Paragons of Power: The Predator's Mantle"] = "Symbole der Macht: Der Mantel des Raubtiers",
	["Paragons of Power: The Vindicator's Armguards"] = "Symbole der Macht: Die Armschützer des Vollstreckers",
	["Paragons of Power: The Vindicator's Belt"] = "Symbole der Macht: Der Gürtel des Vollstreckers",
	["Paragons of Power: The Vindicator's Breastplate"] = "Symbole der Macht: Die Brustplatte des Vollstreckers",
	["Parts for Kravel"] = "Teile für Kravel",
	["Parts of the Swarm"] = "Teile des Schwarms",
	["Passage to Booty Bay"] = "Passage nach Beutebucht",
	["Passing Word of a Threat"] = "Kunde über die Bedrohung breitet sich aus",
	["Passing the Burden"] = "Die Bürde weitergeben",
	["Past Endeavors"] = "Frühere Abenteuer",
	["Path of Defense"] = "Weg der Verteidigung",
	["Path of the Violet Protector"] = "Der Pfad des violetten Beschützers",
	["Path of the Violet Restorer"] = "Der Pfad des violetten Bewahrers",
	["Patriarch Ironjaw"] = "Patriarch Eisenkiefer",
	["Patrol Schedules"] = "Patrouillen-Pläne",
	["Patrolling Westfall"] = "Auf Patrouille durch Westfall",
	["Pawn Captures Queen"] = "Bauer schlägt Dame",
	["Pay the Baron a Visit"] = "Dem Baron einen Besuch abstatten",
	["Pearl Diving"] = "Perlentauchen",
	["Pelt Collection"] = "Pelzjagd",
	["Perfect Yeti Hide"] = "Perfekter Yetibalg",
	["Petty Squabbles"] = "Kleinliches Gezänk",
	["Pick Your Part"] = "Wählt Eure Rolle",
	["Picking Up Some Power Converters"] = "Ein paar Stromwandler besorgen",
	["Pie for Billy"] = "Pastete für Billy",
	["Piercing the Veil"] = "Der zerrissene Schleier",
	["Pilfered Equipment"] = "Gestohlene Ausrüstung",
	["Pirate Hats Ahoy!"] = "Piratenhüte Ahoy!",
	["Plagued Hatchlings"] = "Verseuchte Jungtiere",
	["Plagueheart Belt"] = "Gürtel des verseuchten Herzens",
	["Plagueheart Bindings"] = "Bindungen des verseuchten Herzens",
	["Plagueheart Leggings"] = "Gamaschen des verseuchten Herzens",
	["Plainstrider Menace"] = "Ebenenschreiterbedrohung",
	["Planting the Banner"] = "Das Banner aufstellen",
	["Planting the Heart"] = "Das Einpflanzen des Herzens",
	["Plants of Zangarmarsh"] = "Pflanzen der Zangarmarschen",
	["Plea To The Alliance"] = "Hilfegesuch an die Allianz",
	["Plundering the Plunderers"] = "Das Ausplündern der Plünderer",
	["Poaching from Poachers"] = "Wilderer wildern",
	["Poison Water"] = "Vergiftetes Wasser",
	["Poisoned Water"] = "Vergiftetes Wasser",
	["Pool of Tears"] = "Der Tränenteich",
	["Poor Old Blanchy"] = "Die arme Graumähne",
	["Portals of the Legion"] = "Portale der Legion",
	["Portents of Uldum"] = "Omen von Uldum",
	["Potential Energy Source"] = "Mögliche Energiequelle",
	["Potential for Brain Damage = High"] = "Hirnschadengefahr = hoch",
	["Powder to Ironband"] = "Pulver für Eisenband",
	["Power Stones"] = "Kraftsteine",
	["Power in Uldaman"] = "Macht in Uldaman",
	["Power over Poison"] = "Macht über Gift",
	["Powering our Defenses"] = "Wiederaufladen der Verteidigung",
	["Practical Prey"] = "Praktische Beute",
	["Prayer to Elune"] = "Gebet an Elune",
	["Precarious Predicament"] = "Gefährliche Zwickmühle",
	["Precious and Fragile Things Need Special Handling"] = "Besondere Handhabung für kostbare und zerbrechliche Dinge",
	["Preparation for Ceremony"] = "Vorbereitungen auf die Zeremonie",
	["Preparing for War"] = "Kriegsvorbereitungen",
	["Preparing the Salve"] = "Herstellung der Salbe",
	["Presence of Might"] = "Präsenz der Macht",
	["Presence of Sight"] = "Allgegenwärtige Sicht",
	["Preserving Knowledge"] = "Wissen bewahren",
	["Preying on the Predators"] = "Die Raubtiere zur Beute machen",
	["Pride of the Fel Horde"] = "Der Stolz der Höllenhorde",
	["Pridewings of Stonetalon"] = "Prachtschwingen des Steinkrallengebirges",
	["Priest Training"] = "Ausbildung zum Priester",
	["Primal Magic"] = "Primal Magic", --Missing translation
	["Princess Must Die!"] = "Prinzessin muss sterben!",
	["Prison Break In"] = "Gefängniseinbruch",
	["Prisoner of the Bladespire"] = "Gefangener der Speerspießer",
	["Pristine Enchanted South Seas Kelp"] = "Reiner verzauberter Südmeertang",
	["Pristine Spider Silk"] = "Makellose Spinnenseide",
	["Pristine Yeti Hide"] = "Makelloser Yetibalg",
	["Proof of Allegiance"] = "Ein Beweis der Treue",
	["Proof of Deed"] = "Besitznachweis",
	["Proof of Demise"] = "Beweise des Ablebens",
	["Proof of Life"] = "Lebensbeweis",
	["Prophetic Aura"] = "Prophetische Aura",
	["Prospect of Faith"] = "Ein Funken Hoffnung",
	["Prospector Balmoral"] = "Prospector Balmoral", --Missing translation
	["Protect Kanati Greycloud"] = "Kanati Grauwolke schützen",
	["Protect Kaya"] = "Schützt Kaya",
	["Protect the Frontier"] = "Grenzschutz",
	["Protecting Our Own"] = "Die Eigenen schützen",
	["Protecting the Herd"] = "Die Herde beschützen",
	["Protecting the Shipment"] = "Beschützen der Fracht",
	["Prove Your Hatred"] = "Beweist Euren Hass!",
	["Prove Your Worth"] = "Wertbeweis",
	["Proving Allegiance"] = "Treuebeweis",
	["Proving Grounds"] = "Flaggenjagd",
	["Proving Your Strength"] = "Stärke beweisen",
	["Proving Your Worth"] = "Bewährungsprobe",
	["Prowlers of the Barrens"] = "Streuner des Brachlandes",
	["Psychometric Reading"] = "Psychometrie-Sitzung",
	["Purified!"] = "Geläutert!",
	["Pursuing Terrorclaw"] = "Jagd auf Terrorklaue",
	["Pusillin and the Elder Azj'Tordin"] = "Pusillin und der Älteste Azj'Tordin",
	["Put Her Down"] = "Stellt sie ab",
	["Put On Yer Kneepads..."] = "Zieht Eure Knieschoner an...",
	["Pyrewood Ambush"] = "Hinterhalt in Lohenscheit",
	["Quell The Uprising"] = "Niederschlagung des Aufstandes",
	["Quenching the Blade"] = "Die Waffe härten",
	["Questioning Reethe"] = "Befragt Reethe",
	["Rabine Saturna"] = "Rabine Saturna",
	["Raene's Cleansing"] = "Raenes Säuberung",
	["Rage of Ages"] = "Wut der Zeiten",
	["Rage of Blood"] = "Kochendes Blut",
	["Ragnar Thunderbrew"] = "Ragnar Donnerbräu",
	["Raid on the Kolkar"] = "Überfall auf die Kolkar",
	["Raising Spirits"] = "Mut machen",
	["Raleigh and the Undercity"] = "Raleigh und Unterstadt",
	["Ram Hide Harnesses"] = "Widderledernes Zaumzeug",
	["Ram Riding Harnesses"] = "Widderzaumzeug",
	["Rampaging Giants"] = "Tobende Riesen",
	["Rampaging Ravagers"] = "Tobende Felshetzer",
	["Ramstein"] = "Ramstein",
	["Ranger Sareyn"] = "Waldläuferin Sareyn",
	["Raptor Horns"] = "Raptorhörner",
	["Raptor Mastery"] = "Beherrschen der Raptorenjagd",
	["Raptor Thieves"] = "Raptorendiebe",
	["Rare Fish - Brownell's Blue Striped Racer"] = "Besonderer Fisch - Braunells blaugestreifter Flitzerfisch",
	["Rare Fish - Dezian Queenfish"] = "Besonderer Fisch - Dezianischer Königinnenfisch",
	["Rare Fish - Keefer's Angelfish"] = "Besonderer Fisch - Kiefers Engelfisch",
	["Rat Catching"] = "Rattenfang",
	["Rather Be Fishin'"] = "Ich würd' lieber angeln",
	["Rattling the Rattlecages"] = "Klappernde Skelette",
	["Ravager Egg Roundup"] = "Felshetzereier sammeln",
	["Raven Hill"] = "Rabenflucht",
	["Razorhide"] = "Klingenhaut",
	["Razormaw"] = "Messerrachen",
	["Razzeric's Tweaking"] = "Razzerics Basteln",
	["Reagents for Reclaimers Inc."] = "Reagenzien für die Wiederholer AG",
	["Rear Guard Patrol"] = "Patrouille zur Rückendeckung",
	["Reassignment"] = "Versetzungen",
	["Recently Living"] = "Noch lebendig",
	["Reception from Tyrande"] = "Tyrandes Empfang",
	["Recharging the Batteries"] = "Batterien aufladen",
	["Recipe for Destruction"] = "Anleitung zur Zerstörung",
	["Recipe of the Kaldorei"] = "Rezept der Kaldorei",
	["Reclaimed Treasures"] = "Wiederbeschaffte Schätze",
	["Reclaimers' Business in Desolace"] = "Die Geschäfte der Wiederholer in Desolace",
	["Reclaiming Felfire Hill"] = "Die Rückeroberung des Dämonenhügels",
	["Reclaiming Goods"] = "Waren-Wiederbeschaffung",
	["Reclaiming Holy Grounds"] = "Rückforderung geheiligten Bodens",
	["Reclaiming Sunstrider Isle"] = "Rückeroberung der Insel der Sonnenwanderer",
	["Reclaiming the Charred Vale"] = "Die Rückeroberung des verbrannten Tals",
	["Reclaiming the Eggs"] = "Wiedererlangen der Eier",
	["Reclaiming the Ruins"] = "Die Rückeroberung der Ruinen",
	["Recover the Bones"] = "Die Knochen zurückholen",
	["Recover the Key!"] = "Erlangt den Schlüssel!",
	["Red Leather Bandanas"] = "Rote Lederkopftücher",
	["Red Linen Goods"] = "Rote Leinenwaren",
	["Red Silk Bandanas"] = "Rote Seidenkopftücher",
	["Red Snapper - Very Tasty!"] = "Schnapper - seh",
	["Redeeming the Dead"] = "Die Erlösung der Toten",
	["Redemption"] = "Beinschützer der Erlösung",
	["Redemption Boots"] = "Stiefel der Erlösung",
	["Redemption Girdle"] = "Gurt der Erlösung",
	["Redemption Handguards"] = "Handschützer der Erlösung",
	["Redemption Headpiece"] = "Kopfstück der Erlösung",
	["Redemption Tunic"] = "Tunika der Erlösung",
	["Redemption Wristguards"] = "Handgelenksschutz der Erlösung",
	["Redridge Goulash"] = "Rotkammgulasch",
	["Redridge Rendezvous"] = "Rendezvous im Rotkammgebirge",
	["Refuel for the Zapping"] = "Neuer Treibstoff fürs Schrumpfen",
	["Regthar Deathgate"] = "Regthar Totenfurt",
	["Reinforcements for Garadar"] = "Verstärkung für Garadar",
	["Rejold's New Brew"] = "Rejolds neues Gebräu",
	["Release Them"] = "Erlöst sie",
	["Rellian Greenspyre"] = "Rellian Grünwipfel",
	["Remorseful Highborne"] = "Reuevolle Hochgeborene",
	["Replacement Phial"] = "Ersatzphiole",
	["Replenishing the Healing Crystals"] = "Wiederaufladen der Heilkristalle",
	["Report Back to Fizzlebub"] = "Meldet Euch bei Zischelbub",
	["Report from the Northern Front"] = "Bericht von der Nordfront",
	["Report to Anastasia"] = "Meldung bei Anastasia",
	["Report to Captain Helios"] = "Meldung bei Captain Helios",
	["Report to Captain Stoutfist"] = "Meldung bei Captain Starkfaust",
	["Report to Doren"] = "Meldung bei Doren",
	["Report to Engineering"] = "Meldung beim Chefingenieur",
	["Report to Exarch Admetius"] = "Erstattet Exarch Admetius Bericht",
	["Report to General Kirika"] = "Meldung bei General Kirika",
	["Report to Goldshire"] = "Meldung in Goldhain",
	["Report to Gryan Stoutmantle"] = "Meldung bei Gryan Starkmantel",
	["Report to Hadrec"] = "Meldung bei Hadrec",
	["Report to Helgrum"] = "Bericht für Helgrum",
	["Report to Ironforge"] = "Meldung in Eisenschmiede",
	["Report to Jennea"] = "Meldung bei Jennea",
	["Report to Lanthan Perilon"] = "Berichterstattung an Lanthan Perilon",
	["Report to Magister Kaendris"] = "Bericht an Magister Kaendris",
	["Report to Marshal Bluewall"] = "Meldung bei Marschall Himmelswand",
	["Report to Mountaineer Rockgar"] = "Meldung bei Gebirgsjäger Felsgar",
	["Report to Nazgrel"] = "Bericht an Nazgrel",
	["Report to Orgnil"] = "Bericht an Orgnil",
	["Report to Sen'jin Village"] = "Bericht erstatten in Sen'jin",
	["Report to Shadow Hunter Denjai"] = "Bericht an Schattenjäger Denjai",
	["Report to Splintertree Post"] = "Bericht an den Splitterholzposten",
	["Report to Stonebreaker Camp"] = "Meldung beim Steinbrecherlager",
	["Report to Tarren Mill"] = "Bericht an Tarrens Mühle",
	["Report to Thomas"] = "Meldung an Thomas",
	["Report to Zor"] = "Bei Zor melden",
	["Report to Zurai"] = "Bericht an Zurai",
	["Report to the Allerian Post"] = "Meldung bei Allerias Posten",
	["Request for Assistance"] = "Bitte um Unterstützung",
	["Rescue Deirom!"] = "Rescue Deirom!", --Missing translation
	["Rescue Dugar!"] = "Rescue Dugar!", --Missing translation
	["Rescue From Jaedenar"] = "Rettung aus Jaedenar",
	["Rescue OOX-09/HL!"] = "Rettet OOX-09/HL!",
	["Rescue OOX-17/TN!"] = "Rettet OOX-17/TN!",
	["Rescue OOX-22/FE!"] = "Die Rettung von OOX-22/FE",
	["Rescue the Survivors!"] = "Rettet die Überlebenden!",
	["Research Notes"] = "Forschungsnotizen",
	["Researching the Corruption"] = "Erforschung der Verderbnis",
	["Rest and Relaxation"] = "Ruhe und Entspannung",
	["Resting in Pieces"] = "In Stücken begraben",
	["Restless Activity"] = "Rastlose Aktivität",
	["Restoring Fiery Flux Supplies via Heavy Leather"] = "Nachschub an feurigem Fluxus: Schweres Leder",
	["Restoring Fiery Flux Supplies via Iron"] = "Nachschub an feurigem Fluxus: Eisen",
	["Restoring Fiery Flux Supplies via Kingsblood"] = "Nachschub an feurigem Fluxus: Königsblut",
	["Restoring Sanctity"] = "Wiederherstellung der Heiligkeit",
	["Restoring the Light"] = "Das Licht wiederherstellen",
	["Restoring the Necklace"] = "Restaurierung der Halskette",
	["Resupplying the Excavation"] = "Nachschub für die Ausgrabungsstätte",
	["Retaking Windrunner Spire"] = "Rückeroberung des Windläuferturms",
	["Rethban Ore"] = "Rethbanerz",
	["Retribution of the Light"] = "Vergeltung des Lichts",
	["Retrieving the Goods"] = "Die Waren zurückholen",
	["Return Trip"] = "Rückreise",
	["Return of the Ring"] = "Die Rückkehr des Rings",
	["Return the Book"] = "Rückgabe des Buches",
	["Return the Comb"] = "Rückkehr mit dem Kamm",
	["Return the Reports"] = "Überbringen der Berichte",
	["Return the Statuette"] = "Rückgabe der Statuette",
	["Return to Andormu"] = "Rückkehr zu Andormu",
	["Return to Apothecary Zinge"] = "Kehrt zu Apothekerin Zinge zurück",
	["Return to Arcanist Vandril"] = "Rückkehr zu Arkanist Vandril",
	["Return to Bellowfiz"] = "Rückkehr zu Bellfiz",
	["Return to Bodley"] = "Rückkehr zu Bodley",
	["Return to Brock"] = "Rückkehr zu Brock",
	["Return to Chillwind Camp"] = "Rückkehr zum Zugwindlager",
	["Return to Chromie"] = "Rückkehr zu Chromie",
	["Return to Corporal Kaleb"] = "Rückkehr zu Korporal Kaleb",
	["Return to Deliana"] = "Rückkehr zu Deliana",
	["Return to Denalan"] = "Rückkehr zu Denalan",
	["Return to Feathermoon Stronghold"] = "Kehrt zur Mondfederfeste zurück",
	["Return to Fel'Zerul"] = "Rückkehr zu Fel'Zerul",
	["Return to Honor Hold"] = "Rückkehr zur Ehrenfeste",
	["Return to Ironforge"] = "Rückkehr nach Eisenschmiede",
	["Return to Jitters"] = "Rückkehr zu Bibbers",
	["Return to Khadgar"] = "Rückkehr zu Khadgar",
	["Return to Kristoff"] = "Rückkehr zu Kristoff",
	["Return to Lewis"] = "Zurück zu Lewis",
	["Return to MacKinley"] = "Rückkehr zu MacKinley",
	["Return to Marleth"] = "Rückkehr zu Marleth",
	["Return to Milton"] = "Rückkehr zu Milton",
	["Return to Mokvar"] = "Rückkehr zu Mokvar",
	["Return to Narain"] = "Rückkehr zu Narain",
	["Return to Nathanos"] = "Kehrt zu Nathanos zurück.",
	["Return to Nessa"] = "Rückkehr zu Nessa",
	["Return to Obadei"] = "Rückkehr zu Obadei",
	["Return to Onu"] = "Rückkehr zu Onu",
	["Return to Podrig"] = "Rückkehr zu Podrig",
	["Return to Primal Torntusk"] = "Rückkehr zu Ura Stumpfhauer",
	["Return to Quartermaster Lymel"] = "Zurück zu Rüstmeisterin Lymel",
	["Return to Quinn"] = "Rückkehr zu Quinn",
	["Return to Rokag"] = "Rückkehr zu Rokag",
	["Return to Sha'tari Base Camp"] = "Rückkehr zum Basislager der Sha'tari",
	["Return to Shattrath"] = "Rückkehr nach Shattrath",
	["Return to Silvermoon"] = "Rückkehr nach Silbermond",
	["Return to Sven"] = "Rückkehr zu Sven",
	["Return to Talionia"] = "Rückkehr zu Talionia",
	["Return to Thalodien"] = "Rückkehr zu Thalodien",
	["Return to Thander"] = "Rückkehr zu Thander",
	["Return to Thrallmar"] = "Rückkehr nach Thrallmar",
	["Return to Thunder Bluff"] = "Rückkehr nach Donnerfels",
	["Return to Tinkee"] = "Rückkehr zu Tinkee",
	["Return to Topher Loaal"] = "Zurück zu Tohper Loaal",
	["Return to Troyas"] = "Rückkehr zu Troyas",
	["Return to Tymor"] = "Rückkehr zu Magier Tymor",
	["Return to Vahlarriel"] = "Rückkehr zu Vahlarriel",
	["Return to Verner"] = "Zurück zu Verner",
	["Return to Witch Doctor Uzer'i"] = "Kehrt zu Hexendoktor Uzer'i zurück",
	["Return to the Abyssal Shelf"] = "Rückkehr zur abyssischen Untiefe",
	["Return to the Aldor"] = "Rückkehr zu den Aldor",
	["Return to the Blasted Lands"] = "Rückkehr in die verwüsteten Lande",
	["Return to the Bulwark"] = "Rückkehr zum Bollwerk",
	["Return to the Crossroads."] = "Kehrt zum Wegekreuz zurück",
	["Return to the Greatmother"] = "Rückkehr zur Großmutter",
	["Return to the Hinterlands"] = "Rückkehr ins Hinterland",
	["Return to the Magistrate"] = "Rückkehr zum Magistrat",
	["Return to the Marsh"] = "Rückkehr in die Marschen",
	["Return to the Scryers"] = "Rückkehr zu den Sehern",
	["Returning Home"] = "Heimkehr",
	["Returning the Cleansed Orb"] = "Ablieferung der gesäuberten Kugel",
	["Returning the Favor"] = "Sich für den Gefallen revanchieren",
	["Returning the Lost Satchel"] = "Wiederbeschaffung des verloren gegangenen Ranzens",
	["Reunion"] = "Zusammenführung",
	["Revenge of Gann"] = "Ganns Rache",
	["Revered Among the Sha'tar"] = "Revered Among the Sha'tar", --Missing translation
	["Rhapsody Shindigger"] = "Rhapsodie Kniegräber",
	["Rhapsody's Kalimdor Kocktail"] = "Rhapsodies Kalimdor-Cocktail",
	["Rhapsody's Tale"] = "Rhapsodies Geschichte",
	["Ribbly Screwspigot"] = "Ribbly Schraubstutz",
	["Ride the Lightning"] = "Lasst sie abblitzen!",
	["Ride to Ironforge"] = "Flug nach Eisenschmiede",
	["Ride to Orgrimmar"] = "Flug nach Orgrimmar",
	["Ride to Thunder Bluff"] = "Flug nach Donnerfels",
	["Ride to the Undercity"] = "Flug nach Unterstadt",
	["Ridgespine Menace"] = "Gratwirbelbedrohung",
	["Rig Wars"] = "Maschinenkriege",
	["Rightful Repossession"] = "Rechtmäßiger Besitz",
	["Rilli Greasygob"] = "Rilli Schmierklump",
	["Rin'ji is Trapped!"] = "Rin'ji steckt in der Falle!",
	["Rin'ji's Secret"] = "Rin'jis Geheimnis",
	["Ring of Infinite Wisdom"] = "Ring der unendlichen Weisheit",
	["Ring of Unspoken Names"] = "Ring der ungesagten Namen",
	["Ring of the Gathering Storm"] = "Ring der aufziehenden Stürme",
	["Ripple Delivery"] = "Weinlieferung",
	["Ripple Recovery"] = "Bergung der Welle",
	["Rise of the Silithid"] = "Aufstieg der Silithiden",
	["Rising Spirit"] = "Steigerung des Geistes",
	["Rite of Strength"] = "Ritus der Kraft",
	["Rite of Vision"] = "Ritus der Sicht",
	["Rite of Wisdom"] = "Ritus der Weisheit",
	["Rites of the Earthmother"] = "Riten der Erdenmutter",
	["Rituals of Power"] = "Rituale der Macht",
	["Rituals of Strength"] = "Rituale der Stärke",
	["Riverpaw Gnoll Bounty"] = "Kopfgeld auf die Flusspfotengnolle",
	["Rizzle's Schematics"] = "Rizzles Baupläne",
	["Road to Salvation"] = "Straße der Rettung",
	["Roadside Ambush"] = "Hinterhalt am Straßenrand",
	["Rocket Car Parts"] = "Raketenwagenteile",
	["Rocknot's Ale"] = "Rocknots Bier",
	["Rogue Training"] = "Ausbildung zum Schurken",
	["Rogues of the Shattered Hand"] = "Schurken der Zerschmetterten Hand",
	["Rohok's Request"] = "Rohoks Bitte",
	["Roll the Bones"] = "Knochenklappern",
	["Root Samples"] = "Wurzelproben",
	["Rot Hide Clues"] = "Auf den Spuren der Moderfelle",
	["Rot Hide Ichor"] = "Moderfellsekret",
	["Rot Hide Origins"] = "Die Ursprünge der Moderfelle",
	["Rotten Eggs"] = "Faule Eier",
	["Rotting Hearts"] = "Faulende Herzen",
	["Rude Awakening"] = "Unsanftes Erwachen",
	["Ruined Kegs"] = "Verdorbenes Bier",
	["Rumors for Kravel"] = "Gerüchte für Kravel",
	["Run a Diagnostic!"] = "Führt eine Diagnose durch!",
	["Rune Covered Tablet"] = "Runenbesetzte Schrifttafel",
	["Rune-Inscribed Note"] = "Mit Runen beschriftete Notiz",
	["Rune-Inscribed Parchment"] = "Mit Runen beschriftetes Pergament",
	["Rune-Inscribed Tablet"] = "Mit Runen beschriftete Schrifttafel",
	["Runecloth"] = "Noch mehr Runenstoff",
	["Runewarden Deryan"] = "Runenwächter Deryan",
	["Ruthless Cunning"] = "Erbarmungslose Gerissenheit",
	["Ruuan Weald"] = "Der Ruuanwald",
	["Ruuzel"] = "Ruuzel",
	["S-A-B-O-T-A-G-E"] = "S-A-B-O-T-A-G-E",
	["SI:7"] = "Der SI:7",
	["STOLEN: Smithing Tuyere and Lookout's Spyglass"] = "GESTOHLEN: Schmiedewindform und ein Ausguckhandfernrohr",
	["Sabotage the Warp-Gate!"] = "Sabotage am Warptor!",
	["Sacred Cloth"] = "Hochheiliger Stoff",
	["Sacred Fire"] = "Hochheiliges Feuer",
	["Safeguarding the Watchers"] = "Schützt die Behüter",
	["Safety First"] = "Sicherheit zuerst",
	["Safety Is Job One"] = "Sicherheit geht vor",
	["Salt Flat Venom"] = "Salziges Gift",
	["Salt of the Scorpok"] = "Salz der Skorpok",
	["Saltheril's Haven"] = "Saltherils Hafen",
	["Salvaging the Data"] = "Bergung der Daten",
	["Salvaging the Past"] = "Reise zum vergessenen Sanktum",
	["Samophlange"] = "Samophlang",
	["Samophlange Manual"] = "Samophlanghandbuch",
	["Sample for Helbrim"] = "Probe für Helbrim",
	["Sara Balloo's Plea"] = "Sara Balloos Hilfegesuch",
	["Sarkoth"] = "Sarkoth",
	["Sathrah's Sacrifice"] = "Sathrahs Opferung",
	["Satyr Hooves"] = "Satyrhufe",
	["Satyr Horns"] = "Satyrhörner",
	["Satyr Slaying!"] = "Satyrn schlachten!",
	["Savage Flora"] = "Wildpflanzen",
	["Savage Fronds"] = "Wildwedel",
	["Save Techbot's Brain!"] = "Rettet Techbots Hirn!",
	["Saving Princess Stillpine"] = "Rettet die Prinzessin der Tannenruhfeste",
	["Saving Sharpbeak"] = "Scharfschnabels Rettung",
	["Saving Yenniku"] = "Yennikus Rettung",
	["Saving the Best for Last"] = "Das Beste gibt's zum Schluss",
	["Saving the Sporeloks"] = "Rettung der Sporloks",
	["Scalding Mornbrew Delivery"] = "Lieferung des kochend heißen Morgengebräus",
	["Scarab Shells"] = "Skarabäuspanzerschalen",
	["Scaring Shaky"] = "Zitterhand Angst einjagen",
	["Scarlet Diversions"] = "Scharlachrote Ablenkung",
	["Scarlet Subterfuge"] = "Scharlachrote Täuschung",
	["Scavenging Deathknell"] = "Beutesuche in Todesend",
	["Scepter of the Council"] = "Szepter des Rates",
	["Sceptre of Light"] = "Szepter des Lichts",
	["Scholomance"] = "Scholomance",
	["Scourge of the Downs"] = "Geißel der Niederungen",
	["Scouring the Desert"] = "Durchkämmen der Wüste",
	["Scouting the Defenses"] = "Scouting the Defenses", --Missing translation
	["Scratches"] = "Gekritzel",
	["Screecher Spirits"] = "Kreischergeister",
	["Scrounging"] = "Schnorrerei",
	["Scrying Goggles? No Problem!"] = "Wahrsagerbrille? Kein Problem!",
	["Seal of Ascension"] = "Siegel des Aufstiegs",
	["Sealed Azure Bag"] = "Die versiegelte azurblaue Tasche",
	["Search More Hovels"] = "Suche in weiteren Hütten",
	["Search Stillpine Hold"] = "Sucht in der Tannenruhfeste",
	["Search for Incendicite"] = "Auf der Suche nach Pyrophor",
	["Search for Tyranis"] = "Suche nach Tyranis",
	["Searching for Evidence"] = "Auf der Suche nach Beweisen",
	["Searching for Galaen"] = "Suche nach Galaen",
	["Searching for Scout Jyoba"] = "Auf der Suche nach Späher Jyoba",
	["Searching for the Lost Satchel"] = "Die Suche nach dem verloren gegangenen Ranzen",
	["Seasoned Wolf Kabobs"] = "Gewürzter Wolfskebab",
	["Secret of the Circle"] = "Das Geheimnis des Kreises",
	["Secrets of the Arakkoa"] = "Geheimnisse der Arakkoa",
	["Secrets of the Colossus - Ashi"] = "Geheimnisse des Kolosses - Ashi",
	["Secrets of the Daggerfen"] = "Geheimnisse des Dolchfennstamms",
	["Securing the Celestial Ridge"] = "Den Sternensturz sichern",
	["Securing the Lines"] = "Sicherung der Linien",
	["Securing the Shaleskin Shale"] = "Schieferhautschiefer",
	["Seed of Life"] = "Samenkorn des Lebens",
	["Seeing What Happens"] = "Mal sehe",
	["Seek Huntress Kella Nightbow"] = "Sucht Jägerin Kella Nachtbogen auf",
	["Seek Out Kirrik"] = "Sucht Kirrik",
	["Seek Out Neltharaku"] = "Sucht Neltharaku auf",
	["Seek Redemption!"] = "Sucht Befreiung!",
	["Seek out SI: 7"] = "Aufsuchen des SI: 7",
	["Seek the Farstriders"] = "Sucht die Weltenwanderer auf",
	["Seeking Strahad"] = "Die Suche nach Strahad",
	["Seeking Wisdom"] = "Auf der Suche nach Weisheit",
	["Seeking the Kor Gem"] = "Suche nach dem Koredelstein",
	["Seeping Corruption"] = "Verbreitete Verderbnis",
	["Seer Udalo"] = "Seher Udalo",
	["Selling Fish"] = "Fischhandel",
	["Senir's Observations"] = "Senirs Beobachtungen",
	["Sentinel Advanced Care Package"] = "Verbessertes Überlebenspaket der Schildwache",
	["Sentinel Basic Care Package"] = "Basisüberlebenspaket der Schildwache",
	["Sentinel Standard Care Package"] = "Standardüberlebenspaket der Schildwache",
	["Separation Anxiety"] = "Die getrennten Brüder",
	["Serena Bloodfeather"] = "Serena Blutfeder",
	["Sergra Darkthorn"] = "Sergra Dunkeldorn",
	["Serpent Wild"] = "Wilde Schlange",
	["Serpentbloom"] = "Schlangenflaum",
	["Service to the Horde"] = "Dienst an der Horde",
	["Set Them Ablaze!"] = "Setzt sie in Brand!",
	["Setting Up the Bomb"] = "Die Bombe bauen",
	["Shadow Magic"] = "Schattenmagie",
	["Shadow of the Past"] = "Schatten der Vergangenheit",
	["Shadoweaver"] = "Schattenweber",
	["Shadowpine Weaponry"] = "Das Arsenal der Waldschattentrolle",
	["Shadowshard Fragments"] = "Schattensplitter",
	["Shadumbra's Head"] = "Schattumbras Kopf",
	["Shaman Training"] = "Ausbildung zum Schamanen",
	["Shard of a Felhound"] = "Splitter eines Teufelshundes",
	["Shard of an Infernal"] = "Splitter einer Höllenbestie",
	["Shards of the Felvine"] = "Die Splitter der Teufelsranke",
	["Shardtooth E'ko"] = "E'ko eines Splitterzahns",
	["Sharing the Knowledge"] = "Geteiltes Wissen",
	["Sharing the Land"] = "Gemeinsame Nutzung des Landes",
	["Sharptalon's Claw"] = "Klaue von Scharfkralle",
	["Shatter Point"] = "Trümmerposten",
	["Shattering the Veil"] = "Die Maskerade durchschauen",
	["Shimmer Stout"] = "Schimmerstarkbier",
	["Ship Schedules"] = "Schiffzeitpläne",
	["Shipment to Stormwind"] = "Lieferung nach Sturmwind",
	["Shizz Work"] = "Drecksarbeit",
	["Shizzle's Flyer"] = "Sappalots Flieger",
	["Shoulderpads of Faith"] = "Schulterpolster des Glaubens",
	["Show Gnomercy"] = "Keine Gnade mit dem Gnom",
	["Show Them Gnome Mercy!"] = "Ein Gnom kennt kein Erbarmen!",
	["Show Your Work"] = "Zeigt Eure Arbeit",
	["Showdown"] = "Finale",
	["Shredding Machines"] = "Schreddermaschinen",
	["Shroud of Infinite Wisdom"] = "Schleier der unendlichen Weisheit",
	["Shroud of Unspoken Names"] = "Schleier der ungesagten Namen",
	["Shrouded in Nightmare"] = "Eingehüllt in Alpträume",
	["Shutting Down Manaforge Ara"] = "Manaschmiede Ara abschalten",
	["Shutting Down Manaforge B'naar"] = "Manaschmiede B'naar abschalten",
	["Shutting Down Manaforge Coruu"] = "Manaschmiede Coruu abschalten",
	["Shutting Down Manaforge Duro"] = "Manaschmiede Duro abschalten",
	["Shy-Rotam"] = "Shy-Rotam",
	["Sickle of Unyielding Strength"] = "Sichel der unnachgiebigen Stärke",
	["Sigil of Arathor"] = "Siegelzeichen von Arathor",
	["Sigil of Strom"] = "Siegelzeichen von Strom",
	["Sigil of Thoradin"] = "Siegelzeichen des Thoradin",
	["Sigil of Trollbane"] = "Siegelzeichen von Trollbann",
	["Signal for Pickup"] = "Signal zum Abholen",
	["Signet of Unyielding Strength"] = "Siegel der unnachgiebigen Stärke",
	["Signet of the Dukes"] = "Siegel der Fürsten",
	["Signet of the Unseen Path"] = "Siegel des unsichtbaren Pfads",
	["Signets of the Zandalar"] = "Das Siegel der Zandalar",
	["Signs of the Legion"] = "Zeichen der Legion",
	["Silkwing Cocoons"] = "Seidenflügelkokons",
	["Silver Heart"] = "Silberherz",
	["Simple Letter"] = "Einfacher Brief",
	["Simple Memorandum"] = "Einfaches Memorandum",
	["Simple Note"] = "Einfache Notiz",
	["Simple Parchment"] = "Einfaches Pergament",
	["Simple Rune"] = "Einfache Rune",
	["Simple Scroll"] = "Einfache Rolle",
	["Simple Sigil"] = "Einfaches Siegelzeichen",
	["Simple Subterfugin'"] = "Einfache List",
	["Simple Tablet"] = "Einfache Schrifttafel",
	["Since Time Forgotten..."] = "Seit ich denken kann...",
	["Singing Blue Shards"] = "Singende blaue Splitter",
	["Single Firewing Signet"] = "Einzelne Siegel der Feuerschwingen",
	["Single Mark of Kil'jaeden"] = "Einzelne Male von Kil'jaeden",
	["Single Mark of Sargeras"] = "Einzelne Male des Sageras",
	["Sister Pamela"] = "Schwester Pamela",
	["Situation at Sunsail Anchorage"] = "Vorfall beim Ankerplatz der Sonnensegel",
	["Skeletal Fragments"] = "Skelettfragmente",
	["Skirmish at Echo Ridge"] = "Scharmützel in der Echokammmine",
	["Skulk Rock Clean-up"] = "Den Lauerfels aufräumen",
	["Skull Rock"] = "Die Knochenhöhle",
	["Skullsplitter Tusks"] = "Hauer der Schädelspalter",
	["Skymistress Gloaming"] = "Himmelsmeisterin Abendlicht",
	["Slain by the Wretched"] = "Von den Getriebenen getötet",
	["Slake That Thirst"] = "Durstlöscher",
	["Slaughter at Boulder'mok"] = "Gemetzel in Fels'mok",
	["Slay the Brood Mother"] = "Tötet die Brutmutter",
	["Slaying the Beast"] = "Vernichtung der Bestie",
	["Small Furry Paws"] = "Kleine pelzige Tatzen",
	["Smart Drinks"] = "Klugheitstränke",
	["Smith Mathiel"] = "Schmied Mathiel",
	["Smooth as Butter"] = "So weich wie Butter",
	["Snakestone of the Shadow Huntress"] = "Schlangenstein der Schattenjägerin",
	["Snatch and Grab"] = "Schneller Eingriff",
	["Snickerfang Jowls"] = "Kicherfangunterkiefer",
	["Soaked Pages"] = "Aufgeweichte Seiten",
	["Socrethar's Shadow"] = "Socrethars Schatten",
	["Soft Bushy Tails"] = "Weiche buschige Schwänze",
	["Solanian's Belongings"] = "Solanians Habe",
	["Solomon's Law"] = "Das Gesetz des Solomon",
	["Solution to Doom"] = "Lösung der Verdammnis",
	["Solving the Problem"] = "Die Lösung des Problems",
	["Some Assembly Required"] = "Etwas Zusammenbau benötigt",
	["Someone Else's Hard Work Pays Off"] = "Jemandes Arbeit zahlt sich aus",
	["Soothing Spices"] = "Feine Gewürze",
	["Soothing Turtle Bisque"] = "Milde Schildkrötensuppe",
	["Soulbound Keepsake"] = "Seelengebundenes Andenken",
	["Source of the Corruption"] = "Die Quelle der Verderbtheit",
	["Southsea Freebooters"] = "Südmeerfreibeuter",
	["Southsea Shakedown"] = "Gaunerei und Erpressung im Südmeer",
	["Southshore"] = "Süderstade",
	["Souvenirs of Death"] = "Andenken des Todes",
	["Spare Parts"] = "Ersatzteile",
	["Spawn of Jubjub"] = "Jubjubs Nachwuchs",
	["Speak to Nafien"] = "Sprecht mit Nafien",
	["Speak to Salfa"] = "Sprecht mit Salfa",
	["Speak with Anastasia"] = "Gespräch mit Anastasia",
	["Speak with Bink"] = "Gespräch mit Bink",
	["Speak with Coleman"] = "Gespräch mit Coleman",
	["Speak with Deino"] = "Gespräch mit Deino",
	["Speak with Dillinger"] = "Gespräch mit Dillinger",
	["Speak with Gramma"] = "Gespräch mit Oma",
	["Speak with Jennea"] = "Gespräch mit Jennea",
	["Speak with Private Weeks"] = "Sprecht mit Gefreiter Wöch",
	["Speak with Renferrel"] = "Sprecht mit Renferrel",
	["Speak with Rilak the Redeemed"] = "Sprecht mit Rilak dem Erlösten",
	["Speak with Ruga"] = "Gespräch mit Ruga",
	["Speak with Scout Neftis"] = "Sprecht mit Späherin Neftis",
	["Speak with Sevren"] = "Gespräch mit Sevren",
	["Speak with Shoni"] = "Sprecht mit Shoni",
	["Speak with Thun'grim"] = "Gespräch mit Thun'grim",
	["Speak with Un'thuwa"] = "Gespräch mit Un'thuwa",
	["Speaking of Fortitude"] = "Reden über Kraft",
	["Speaking with Gan'zulah"] = "Mit Gan'zulah sprechen",
	["Speaking with Nezzliok"] = "Mit Nezzliok sprechen",
	["Special Delivery for Gaxim"] = "Speziallieferung für Gaxim",
	["Special Forces"] = "Spezialtruppe",
	["Spectrecles"] = "Geisterbrille",
	["Spellfire Robes"] = "Roben des Zauberfeuers",
	["Spinal Dust"] = "Mehr Wirbelknochenstaub",
	["Spinebreaker Post"] = "Der Rückenbrechergrat",
	["Spirit Calling"] = "Geisteranrufung",
	["Spirit Totem"] = "Geistertotem",
	["Spirit of the Boar"] = "Geist des Ebers",
	["Spirit of the Wind"] = "Geist des Windes",
	["Spirits of the Drowned"] = "Geister der Ertrunkenen",
	["Spirits of the Feralfen"] = "Geister der Wildfenn",
	["Spiritual Domination"] = "Geistige Beherrschung",
	["Spiritual Unrest"] = "Spirituelle Unruhe",
	["Spleendid!"] = "Demilziös!",
	["Split Bone Necklace"] = "Spaltknochenhalskette",
	["Sporeggar"] = "Sporeggar",
	["Sprinkle's Secret Ingredient"] = "Sprinkels Geheimzutat",
	["Squire Maltrake"] = "Knappe Malzdarr",
	["Stalking the Stalkers"] = "Die Pirsch auf die Pirscher",
	["Stalwart's Battlegear"] = "Schlachtrüstung des Gefolgsmanns",
	["Standards and Practices"] = "Standarten",
	["Starfall"] = "Sternfall",
	["Stave of the Ancients"] = "Holzstab der Uralten",
	["Stealing Back the Mushrooms"] = "Die Pilze zurückstehlen",
	["Stealing Knowledge"] = "Wissen stehlen",
	["Stealing Supplies"] = "Diebstahl von Vorräten",
	["Stealing from Thieves"] = "Von Dieben stehlen",
	["Stealth Flight"] = "Heimlicher Flug",
	["Steelsnap"] = "Stahlbiss",
	["Stepping Up Security"] = "Verstärkte Sicherheit",
	["Still Believing"] = "Fester Glauben",
	["Stillpine Hold"] = "Tannenruhfeste",
	["Sting of the Scorpid"] = "Stich des Skorpiden",
	["Stinger Venom"] = "Blutergift",
	["Stinging the Stingers"] = "Tückische Mücken",
	["Stinglasher"] = "Zornstachel",
	["Stinking Up Southshore"] = "Die Verpestung von Süderstade",
	["Stinky's Escape"] = "Stinkis Flucht",
	["Stocking Jetsteam"] = "Vorräte für Jetsteam",
	["Stolen Booty"] = "Gestohlene Beute",
	["Stolen Silver"] = "Gestohlenes Silber",
	["Stoley's Debt"] = "Stoleys Schuld",
	["Stoley's Shipment"] = "Stoleys Lieferung",
	["Stone Tokens"] = "Steinmarken",
	["Stonegear's Search"] = "Steinsegels Suche",
	["Stones of Binding"] = "Steine der Bindung",
	["Stonetalon Standstill"] = "Stillstand am Steinkrallenpfad",
	["Stopping the Spread"] = "Die Ausbreitung eindämmen",
	["Stormers and Rumblers"] = "Stürmer und Rumpler",
	["Stormpike's Deciphering"] = "Sturmlanzes Entschlüsselung",
	["Stormpike's Delivery"] = "Sturmlanzes Lieferung",
	["Stormpike's Order"] = "Sturmlanzes Bestellung",
	["Stormwind Ho!"] = "Sturmwind Ho!",
	["Stormwind Library"] = "Bibliothek von Sturmwind",
	["Stormwind Rendezvous"] = "Treffen in Sturmwind",
	["Stout to Kadrell"] = "Starkbier für Kadrell",
	["Strained Supplies"] = "Schwindende Vorräte",
	["Strange Alliance"] = "Seltsame Allianz",
	["Strange Brew"] = "Merkwürdiges Gebräu",
	["Strange Energy"] = "Fremde Energien",
	["Strange Findings"] = "Seltsame Funde",
	["Strange Sources"] = "Sonderbare Quellen",
	["Stranglethorn Fever"] = "Schlingendornfieber",
	["Strength of One"] = "Die Stärke des Einen",
	["Striker's Diadem"] = "Diadem des Hetzers",
	["Striker's Footguards"] = "Fußschützer des Hetzers",
	["Striker's Hauberk"] = "Halsberge des Hetzers",
	["Stromgarde Badges"] = "Abzeichen von Stromgarde",
	["Study of the Elements: Rock"] = "Element-Studie: Fels",
	["Stymying the Arakkoa"] = "Die Arakkoa hindern",
	["Success!"] = "Erfolg!",
	["Sully Balloo's Letter"] = "Sully Balloos Brief",
	["Summon Felsteed"] = "Teufelsross beschwören",
	["Summoner Kanthin's Prize"] = "Beschwörer Kanthins Preis",
	["Summoning Shadra"] = "Die Beschwörung von Shadra",
	["Summoning the Princess"] = "Beschwören der Prinzessin",
	["Summons from Knight-Lord Bloodvalor"] = "Aufforderung des Ritterfürsten Heldenblut",
	["Suncrown Village"] = "Sonnenkuppe",
	["Sunfury Briefings"] = "Anweisungen des Sonnenzorns",
	["Sunfury Signets"] = "Mehr Siegel des Sonnenzorns",
	["Sunken Treasure"] = "Versunkener Schatz",
	["Sunscorched Shells"] = "Sonnenverbrannte Schalen",
	["Suntara Stones"] = "Suntarasteine",
	["Super Reaper 6000"] = "Superschnitter 6000",
	["Super Sticky"] = "Superkleber",
	["Superior Armaments of Battle - Exalted Amongst the Dawn"] = "Überragende Kampfausrüstung - Ehrfurcht der Dämmerung",
	["Superior Armaments of Battle - Friend of the Dawn"] = "Überragende Kampfausrüstung - Freund der Dämmerung",
	["Superior Armaments of Battle - Honored Amongst the Dawn"] = "Überragende Kampfausrüstung - Wohlwollen der Dämmerung",
	["Superior Armaments of Battle - Revered Amongst the Dawn"] = "Überragende Kampfausrüstung - Respekt der Dämmerung",
	["Supervisor Fizsprocket"] = "Vorsteher Zischelspross",
	["Supplies for Nethergarde"] = "Vorräte für Nethergarde",
	["Supplies for the Crossroads"] = "Vorräte für das Wegekreuz",
	["Supplies from Darkshire"] = "Lieferung aus Dunkelhain",
	["Supplies to Auberdine"] = "Nachschub für Auberdine",
	["Supplies to Private Thorsen"] = "Vorräte für den Gefreiten Thorsen",
	["Supplies to Tannok"] = "Vorräte für Tannok",
	["Supply and Demand"] = "Angebot und Nachfrage",
	["Supplying the Front"] = "Nachschub für die Front",
	["Supplying the Sepulcher"] = "Nachschub für das Grabmal",
	["Surena Caledon"] = "Surena Caledon",
	["Surrender to the Horde"] = "Auslieferung an die Horde",
	["Survey the Land"] = "Inspektion des Lagers",
	["Surveying the Ruins"] = "Die Ruinen beobachten",
	["Suspicious Hoofprints"] = "Verdächtige Hufabdrücke",
	["Sven's Camp"] = "Svens Lager",
	["Sven's Revenge"] = "Svens Rache",
	["Sweet Amber"] = "Goldbrauner Samt",
	["Sweet Serenity"] = "Süße Beschaulichkeit",
	["Swift Discipline"] = "Disziplin muss sein",
	["Swoop Hunting"] = "Sturzfliegerjagd",
	["Syndicate Assassins"] = "Auftragsmörder des Syndikats",
	["Syndicate Emblems"] = "Syndikatsembleme",
	["Synthesis of Power"] = "Bündelung der Macht",
	["Tabards of the Illidari"] = "Wappenröcke der Illidari",
	["Tabetha's Task"] = "Tabethas Aufgabe",
	["Tablet of the Seven"] = "Schrifttafel der Sieben",
	["Tablets of Baa'ri"] = "Schrifttafeln von Baa'ri",
	["Tainted Arcane Sliver"] = "Besudelter Arkanspan",
	["Tainted Letter"] = "Besudelter Brief",
	["Tainted Memorandum"] = "Besudeltes Memorandum",
	["Tainted Parchment"] = "Besudeltes Pergament",
	["Tainted Scroll"] = "Besudelte Rolle",
	["Take Five Bases"] = "Erobert fünf Stützpunkte",
	["Take Four Bases"] = "Erobert vier Stützpunkte",
	["Taken in the Night"] = "Bei Nacht verschleppt",
	["Taking Back Silithus"] = "Die Rückeroberung von Silithus",
	["Taking the Fall"] = "Die Sache ausbaden",
	["Tal the Wind Rider Master"] = "Tal der Windreitermeister",
	["Talbuk Mastery"] = "Beherrschen der Talbukjagd",
	["Talk to the Hand"] = "Sprecht zu der Hand",
	["Taming the Beast"] = "Die Zähmung der Bestie",
	["Tanaris Field Sampling"] = "Tanaris-Feldproben",
	["Taretha's Gift"] = "Tarethas Geschenk",
	["Target: Dalson's Tears"] = "Ziel: Dalsons Tränenfeld",
	["Target: Felstone Field"] = "Ziel: Teufelssteinfeld",
	["Target: Gahrron's Withering"] = "Ziel: Gahrrons Trauerfeld",
	["Target: Hive'Ashi Defenders"] = "Ziel: Verteidiger des Ashischwarms",
	["Target: Hive'Ashi Sandstalkers"] = "Ziel: Sandpirscher des Ashischwarms",
	["Target: Hive'Ashi Stingers"] = "Ziel: Stecher des Ashischwarms",
	["Target: Hive'Ashi Workers"] = "Ziel: Arbeiter des Ashischwarms",
	["Target: Hive'Regal Ambushers"] = "Ziel: Wegelagerer des Regalschwarms",
	["Target: Hive'Regal Burrowers"] = "Ziel: Einbuddler des Regalschwarms",
	["Target: Hive'Regal Slavemakers"] = "Ziel: Sklavenjäger des Regalschwarms",
	["Target: Hive'Regal Spitfires"] = "Ziel: Feuerspucker des Regalschwarms",
	["Target: Hive'Zora Hive Sisters"] = "Ziel: Schwestern des Zoraschwarms",
	["Target: Hive'Zora Reavers"] = "Ziel: Häscher des Zoraschwarms",
	["Target: Hive'Zora Tunnelers"] = "Ziel: Tunnelgräber des Zoraschwarms",
	["Target: Hive'Zora Waywatchers"] = "Ziel: Wegbehüter des Zoraschwarms",
	["Target: Writhing Haunt"] = "Ziel: Das trostlose Feld",
	["Tear of the Earthmother"] = "Träne der Erdenmutter",
	["Tears of the Moon"] = "Tränen des Mondes",
	["Teldrassil"] = "Teldrassil",
	["Teleport This!"] = "Teleportiert das!",
	["Tenaron's Summons"] = "Tenarons Einladung",
	["Terokk's Legacy"] = "Terokks Erbe",
	["Terokkarantula"] = "Terokkarantula",
	["Teron Gorefiend - Lore and Legend"] = "Teron Blutschatten - Geschichte und Mythos",
	["Test Flight: Razaan's Landing"] = "Testflug: Razaans Landeplatz",
	["Test Flight: Ruuan Weald"] = "Testflug: Ruuanwald",
	["Test Flight: The Singing Ridge"] = "Testflug: Der singende Bergrücken",
	["Test Flight: The Zephyrium Capacitorium"] = "Testflug: Das Zephyriumkapazitorium",
	["Test of Endurance"] = "Test der Belastbarkeit",
	["Test of Faith"] = "Test des Glaubens",
	["Test of Lore"] = "Test der Lehre",
	["Test of Strength"] = "Test der Kraft",
	["Testing an Enemy's Strength"] = "Die Kraft des Feindes wird auf die Probe gestellt",
	["Testing for Corruption - Felwood"] = "Test für Verderbnis - Teufelswald",
	["Testing for Impurities - Un'Goro Crater"] = "Test auf Unreinheiten - Krater von Un'Goro",
	["Testing the Antidote"] = "Das Gegengift testen",
	["Testing the Prototype"] = "Den Prototyp testen",
	["Testing the Tonic"] = "Das Tonikum testen",
	["Testing the Vessel"] = "Das Gefäß wird getestet",
	["Thadius Grimshade"] = "Thadius Grimmschatten",
	["Thalanaar Delivery"] = "Thalanaar-Lieferung",
	["Tharil'zun"] = "Tharil'zun",
	["Tharnariun's Hope"] = "Tharnariuns Hoffnung",
	["That Little Extra Kick"] = "Der kleine Extrakick",
	["That's Asking A Lot"] = "Das ist viel verlangt",
	["Thazz'ril's Pick"] = "Thazz'rils Hacke",
	["The Absent Minded Prospector"] = "Der geistesabwesende Ausgrabungsleiter",
	["The Active Agent"] = "Der aktive Wirkstoff",
	["The Admiral's Orders"] = "Die Befehle des Admirals",
	["The Affray"] = "Der Ringkampf",
	["The Agitated Ancestors"] = "Die aufgebrachten Ahnen",
	["The Agony and the Darkness"] = "Das Leid und die Dunkelheit",
	["The Algaz Gauntlet"] = "Der Algaz-Spießrutenlauf",
	["The All-Seeing Eye of Zuldazar"] = "Das allsehende Auge von Zuldazar",
	["The Alliance Needs Iron Bars!"] = "Die Allianz braucht Eisenbarren!",
	["The Alliance Needs Light Leather!"] = "Die Allianz braucht leichtes Leder!",
	["The Alliance Needs Linen Bandages!"] = "Die Allianz braucht Leinenverbände!",
	["The Alliance Needs Medium Leather!"] = "Die Allianz braucht mittleres Leder!",
	["The Alliance Needs More Copper Bars!"] = "Die Allianz braucht mehr Kupferbarren!",
	["The Alliance Needs More Linen Bandages!"] = "Die Allianz braucht mehr Leinenverbände!",
	["The Alliance Needs More Medium Leather!"] = "Die Allianz braucht mehr mittleres Leder!",
	["The Alliance Needs More Silk Bandages!"] = "Die Allianz braucht mehr Seidenverbände!",
	["The Alliance Needs More Spotted Yellowtail!"] = "Die Allianz braucht mehr Tüpfelgelbschwänze!",
	["The Alliance Needs More Thorium Bars!"] = "Die Allianz braucht mehr Thoriumbarren!",
	["The Alliance Needs Runecloth Bandages!"] = "Die Allianz braucht Runenstoffverbände!",
	["The Alliance Needs Silk Bandages!"] = "Die Allianz braucht Seidenverbände!",
	["The Alliance Needs Spotted Yellowtail!"] = "Die Allianz braucht Tüpfelgelbschwänze!",
	["The Altar of Zul"] = "Der Altar von Zul",
	["The Ancient Egg"] = "Das uralte Ei",
	["The Ancient Leaf"] = "Das uralte Blatt",
	["The Ancient Statuette"] = "Die antike Statuette",
	["The Angry Scytheclaws"] = "Die wütenden Sensenklauen",
	["The Annals of Darrowshire"] = "Die Annalen von Darroheim",
	["The Annals of Kirin'Var"] = "Die Annalen von Kirin'Var",
	["The Apes of Un'Goro"] = "Die Affen von Un'Goro",
	["The Apple Falls"] = "Der Apfel fällt",
	["The Arakkoa Threat"] = "Die Arakkoabedrohung",
	["The Arcanist's Cookbook"] = "Das Arkanistenkochbuch",
	["The Archivist"] = "Der Archivar",
	["The Archmage's Staff"] = "Der Stab des Erzmagiers",
	["The Argent Hold"] = "Der Argentumtresor",
	["The Art of Fel Reaver Maintenance"] = "Die Kunst der Teufelshäscherwartung",
	["The Art of the Armorsmith"] = "Die Kunst des Rüstungsschmiedes",
	["The Art of the Imbue"] = "Die Kunst der Magieerfüllung",
	["The Ashenvale Hunt"] = "Die Jagd im Eschental",
	["The Ashtongue Broken"] = "Die Aschenzungen",
	["The Ashtongue Corruptors"] = "Die Verderber der Aschenzungen",
	["The Ashtongue Tribe"] = "Die Aschenzungen",
	["The Assassin"] = "Der Assassine",
	["The Atal'ai Exile"] = "Der Verbannte der Atal'ai",
	["The Attack!"] = "Startet den Angriff!",
	["The Azure Key"] = "Der azurblaue Schlüssel",
	["The Bait for Lar'korwi"] = "Ein Köder für Lar'korwi",
	["The Balance of Light and Shadow"] = "Die Waage von Licht und Schatten",
	["The Balance of Nature"] = "Das Gleichgewicht der Natur",
	["The Balnir Farmstead"] = "Balnirs Bauernhof",
	["The Barrens Oases"] = "Die Oasen des Brachlandes",
	["The Barrens Port"] = "Der Brachlandhafen",
	["The Basilisk's Bite"] = "Der Biss des Basilisken",
	["The Battle Horn"] = "Das Kampfhorn",
	["The Battle Plans"] = "Die Schlachtpläne",
	["The Battle of Alterac"] = "Die Schlacht um Alterac",
	["The Battle of Darrowshire"] = "Die Schlacht um Darroheim",
	["The Battleboars"] = "Die Kampfeber",
	["The Bear Necessities"] = "Bärdarfsgüter",
	["The Bearer of Bad News"] = "Der Überbringer schlechter Botschaften...",
	["The Befouled Element"] = "Das beschmutzte Element",
	["The Best Defense"] = "Die beste Verteidigung",
	["The Big Bone Worm"] = "Der große Knochenwurm",
	["The Biggest of Them All"] = "Der Größte von allen",
	["The Binding"] = "Die Bindung",
	["The Black Morass"] = "Der schwarze Morast",
	["The Black Shield"] = "Der Schwarze Schild",
	["The Blackwood Corrupted"] = "Die verderbten Schwarzfelle",
	["The Bladespire Ogres"] = "Die Oger der Speerspießer",
	["The Bladespire Threat"] = "Die Speerspießerbedrohung",
	["The Blightcaller Cometh"] = "Der Pestrufer kommt",
	["The Blood Elves"] = "Die Blutelfen",
	["The Blood is Life"] = "Blut bedeutet Leben",
	["The Blood-Tempered Ranseur"] = "Der blutgehärtete Ranseur",
	["The Bloodcurse Legacy"] = "Das Vermächtnis des Blutfluchs",
	["The Bloodcursed Naga"] = "Die Naga des Blutfluchs",
	["The Bloodmaul Ogres"] = "Die Oger der Blutschläger",
	["The Bloodsail Buccaneers"] = "Die Blutsegelbukaniere",
	["The Boar Hunter"] = "Der Eberjäger",
	["The Boha'mu Ruins"] = "Die Ruinen von Boha'mu",
	["The Book of Fel Names"] = "Das Buch der teuflischen Namen",
	["The Book of Ur"] = "Das Buch von Ur",
	["The Borrower"] = "Der Borger",
	["The Bounty of Teldrassil"] = "Die Arten von Teldrassil",
	["The Branch of Cenarius"] = "Der Zweig des Cenarius",
	["The Brassbolts Brothers"] = "Die Brüder Kupferbolz",
	["The Broken Sigil"] = "Das zerbrochene Siegelzeichen",
	["The Brood of Onyxia"] = "Die Brut von Onyxia",
	["The Call to Command"] = "Der Befehl",
	["The Calling"] = "Die Anrufung",
	["The Caravan Road"] = "Die Karawanenstraße",
	["The Carevin Family"] = "Die Familie Treuwein",
	["The Caverns of Time"] = "Die Höhlen der Zeit",
	["The Cenarion Expedition"] = "Die Expedition des Cenarius",
	["The Challenge"] = "Die Herausforderung",
	["The Champion of the Banshee Queen"] = "Der Champion der Bansheekönigin",
	["The Champion of the Horde"] = "Der Champion der Horde",
	["The Changing of Paths - Conqueror No More"] = "Den Pfad wechseln - Kein Eroberer mehr",
	["The Changing of Paths - Protector No More"] = "Den Pfad wechseln - Kein Beschützer mehr",
	["The Charge of the Dragonflights"] = "Der Bund der Drachenschwärme",
	["The Chill of Death"] = "Die Kälte des Todes",
	["The Cipher of Damnation"] = "Die Litanei der Verdammnis",
	["The Cipher of Damnation - Ar'tor's Charge"] = "Die Litanei der Verdammnis - Ar'tors Angriff",
	["The Cipher of Damnation - Borak's Charge"] = "Die Litanei der Verdammnis - Boraks Angriff",
	["The Cipher of Damnation - Grom'tor's Charge"] = "Die Litanei der Verdammnis - Grom'tors Angriff",
	["The Cipher of Damnation - The First Fragment Recovered"] = "Die Litanei der Verdammnis - Erster Teil",
	["The Cipher of Damnation - The Second Fragment Recovered"] = "Die Litanei der Verdammnis - Zweiter Teil",
	["The Cipher of Damnation - The Third Fragment Recovered"] = "Die Litanei der Verdammnis - Dritter Teil",
	["The Cipher of Damnation - Truth and History"] = "Die Litanei der Verdammnis - Wahrheit und Geschichte",
	["The Cliffspring River"] = "Der Klippenquell",
	["The Coast Isn't Clear"] = "Ärger an der Küste",
	["The Coastal Menace"] = "Bedrohung an der Küste",
	["The Codex of Blood"] = "Der Kodex des Blutes",
	["The Collector"] = "Der Sammler",
	["The Color of Blood"] = "Die Farbe von Blut",
	["The Completed Orb of Dar'Orahil"] = "Die fertig gestellte Kugel von Dar'Orahil",
	["The Completed Orb of Noh'Orahil"] = "Die fertig gestellte Kugel von Noh'Orahil",
	["The Completed Robe"] = "Die fertig gestellte Robe",
	["The Consortium Needs You!"] = "Das Konsortium braucht Euch!",
	["The Corpulent One"] = "Der Korpulente",
	["The Corrupter"] = "Der Verderber",
	["The Corruption Abroad"] = "Verderbnis in der Fremde",
	["The Corruption of the Jadefire"] = "Die Verderbnis der Jadefeuer",
	["The Count of the Marshes"] = "Der Graf der Marschen",
	["The Cover of Darkness"] = "Der Mantel der Dunkelheit",
	["The Crimson Courier"] = "Der Purpurrote Kurier",
	["The Crone of the Kraul"] = "Die Greisin des Krals",
	["The Crown of Will"] = "Die Krone des Willens",
	["The Cryo-Core"] = "Der Kryokern",
	["The Crystal of Zin-Malor"] = "Der Kristall von Zin-Malor",
	["The Curious Visitor"] = "Der seltsame Besucher",
	["The Curse of the Tides"] = "Der Fluch der Gezeiten",
	["The Cursed Crew"] = "Die verfluchte Crew",
	["The Damned"] = "Die Verdammten",
	["The Dark Iron War"] = "Der Dunkeleisenkrieg",
	["The Dark Missive"] = "Der dunkle Schriftwechsel",
	["The Darkmoon Faire"] = "Der Dunkelmond-Jahrmarkt",
	["The Darkreaver Menace"] = "Die Bedrohung durch Schattensichel",
	["The Darkstone Tablet"] = "Die Dunkelsteinschrifttafel",
	["The Daughter Who Lived"] = "Die überlebende Tochter",
	["The Day After"] = "Der Tag danach",
	["The Dead Fields"] = "Das Todesfeld",
	["The Dead Mire"] = "Das Todesmoor",
	["The Dead Scar"] = "Die Todesschneise",
	["The Deathforge"] = "Die Todesschmiede",
	["The Deathstalkers"] = "Die Todespirscher",
	["The Deathstalkers' Report"] = "Der Bericht der Todespirscher",
	["The Decisive Striker"] = "Der Entscheidungsschlag",
	["The Decrepit Ferry"] = "Die verfallene Fähre",
	["The Defense of Grom'gol"] = "Die Verteidigung von Grom'gol",
	["The Defias Brotherhood"] = "Die Bruderschaft der Defias",
	["The Demon Forge"] = "Die Dämonenschmiede",
	["The Demon Hunter"] = "Der Dämonenjäger",
	["The Demon Scarred Cloak"] = "Der Dämonennarbenumhang",
	["The Demon Seed"] = "Die Dämonensaat",
	["The Demoniac Scryer"] = "Der dämonische Seher",
	["The Den"] = "Der Höhlenbau",
	["The Den Mother"] = "Die Höhlenmutter",
	["The Deserter"] = "Der Deserteur",
	["The Deserters"] = "Die Deserteure",
	["The Disgraced One"] = "Der Entehrte",
	["The Disruption Ends"] = "Das Ende der Unterbrechungen",
	["The Divination"] = "Der Rutengang",
	["The Divination Scryer"] = "Das Orakel der Anrufung",
	["The Doomed Fleet"] = "Die verlorene Flotte",
	["The Dormant Shade"] = "Der Schlummernde Schatten",
	["The Dragon's Eye"] = "Das Großdrachenauge",
	["The Dread Citadel - Naxxramas"] = "Die Zitadelle des Schreckens - Naxxramas",
	["The Dread Relic"] = "Das Schreckensrelikt",
	["The Dreghood Elders"] = "Die Ältesten des Lumpenpacks",
	["The Dunemaul Compound"] = "Das Truppenlager der Dünenbrecher",
	["The Dwarven Spy"] = "Der zwergische Spion",
	["The Dying Balance"] = "Aus dem Gleichgewicht geraten",
	["The Dynamic Duo"] = "Das dynamische Duo",
	["The Earthbinder"] = "Die Erdbinderin",
	["The Eastern Kingdoms"] = "Das östliche Königreich",
	["The Eastern Plagues"] = "Die östlichen Pestländer",
	["The Eastern Pylon"] = "Der Ostpylon",
	["The Ectoplasmic Distiller"] = "Der Ektoplasmadestillierer",
	["The Eighteenth Pilot"] = "Der achtzehnte Rennfahrer",
	["The Elder Crone"] = "Die Ältestengreisin",
	["The Elemental Equation"] = "Die Elementargleichung",
	["The Elusive Ironjaw"] = "Der schwer zu fassende Eisenkiefer",
	["The Emerald Dream..."] = "Der Smaragdgrüne Traum",
	["The Emerald Dreamcatcher"] = "Der smaragdgrüne Traumfänger",
	["The Emitter"] = "Der Emitter",
	["The Enchanted Glade"] = "Die verzauberte Lichtung",
	["The Encroaching Wilderness"] = "Die nahende Wildnis",
	["The Engraved Ring"] = "Der gravierte Ring",
	["The Ensorcelled Parchment"] = "Das Verhexte Pergament",
	["The Escape"] = "Die Flucht",
	["The Essence of Aku'Mai"] = "Die Essenz von Aku'mai",
	["The Essence of Eranikus"] = "Die Essenz des Eranikus",
	["The Ethereum"] = "Das Astraleum",
	["The Everlook Report"] = "Der Bericht der Ewigen Warte",
	["The Everstill Bridge"] = "Die Immerruhbrücke",
	["The Exorcism"] = "Die Austreibung",
	["The Exorcism of Colonel Jules"] = "Der Exorzismus des Oberst Jules",
	["The Eye of Paleth"] = "Das Auge von Paleth",
	["The Eyes of Grillok"] = "Die Augen von Grillok",
	["The Eyes of Skettis"] = "Die Augen von Skettis",
	["The Fall of Ameth'Aran"] = "Der Untergang von Ameth'Aran",
	["The Fall of Kel'Thuzad"] = "Der Fall von Kel'Thuzad",
	["The Fall of Ossirian"] = "Der Untergang von Ossirian",
	["The Fallen Courier"] = "Der sterbende Kurier",
	["The Fallen Exarch"] = "Der gefallene Exarch",
	["The Family Crypt"] = "Die Familiengruft",
	["The Family and the Fishing Pole"] = "Die Familie und die Angel",
	["The Fare of Lar'korwi"] = "Lar'korwis Mahl",
	["The Fargodeep Mine"] = "Die Tiefenschachtmine",
	["The Farstrider Enclave"] = "Die Enklave der Weltenwanderer",
	["The Fate of Flanis"] = "Flanis' Schicksal",
	["The Fate of Kagrosh"] = "Kagroshs Schicksal",
	["The Fate of Ramaladni"] = "Ramaladnis Schicksal",
	["The Fate of Tuurem"] = "Das Schicksal von Tuurem",
	["The Fate of Yenniku"] = "Yennikus Schicksal",
	["The Fate of the Kingdom"] = "Das Schicksal des Königreichs",
	["The Feast of Winter Veil"] = "Das Winterhauchfest",
	["The Fel and the Furious"] = "Teufelshäscherdrift",
	["The Final Code"] = "Der finale Code",
	["The Final Message to the Wildhammer"] = "Die letzte Botschaft an die Wildhämmer",
	["The Final Piece"] = "Das letzte Stück",
	["The Final Reagents"] = "The Final Reagents", --Missing translation
	["The Final Sample"] = "Die letzte Probe",
	["The Final Tablets"] = "Die letzten Schrifttafeln",
	["The Finest Down"] = "Feinste Daunen",
	["The Firewing Liaison"] = "Vermittler der Feuerschwingen",
	["The Firewing Point Project"] = "The Firewing Point Project", --Missing translation
	["The First Trial"] = "Die erste Prüfung",
	["The First and the Last"] = "Der Erste und Letzte",
	["The Flame's Casing"] = "Die Ummantelung der Flamme",
	["The Flawless Flame"] = "Die fehlerlose Flamme",
	["The Flesh Does Not Lie"] = "Das Fleisch lügt nicht",
	["The Flesh Lies..."] = "Fleisch geworden",
	["The Foot of the Citadel"] = "Am Fuße der Zitadelle",
	["The Force of Neltharaku"] = "Die Macht Neltharakus",
	["The Forging of Quel'Serrar"] = "Das Schmieden von Quel'Serrar",
	["The Forgotten Heirloom"] = "Das vergessene Erbstück",
	["The Forgotten Pools"] = "Die vergessenen Teiche",
	["The Formation of Felbane"] = "Die Herstellung von Teufelsbann",
	["The Forsaken"] = "Die Verlassenen",
	["The Four Dukes"] = "Die vier Fürsten",
	["The Fragments Within"] = "Die Fragmente im Inneren",
	["The Fury Runs Deep"] = "Tief empfundener Zorn",
	["The Giant Guardian"] = "Der Riesenwächter",
	["The Glowing Fruit"] = "Die leuchtende Frucht",
	["The Glowing Shard"] = "Der leuchtende Splitter",
	["The God Hakkar"] = "Der Gott Hakkar",
	["The Good Stuff"] = "Feine Sachen",
	["The Gordok Ogre Suit"] = "Der Ogeranzug der Gordok",
	["The Gordok Taste Test"] = "Der Gordokgeschmackstest",
	["The Gordunni Orb"] = "Die Gordunnikugel",
	["The Gordunni Scroll"] = "Die Gordunnischriftrolle",
	["The Grand Betrayal"] = "Der große Verrat",
	["The Great Fissure"] = "Die große Kluft",
	["The Great Fras Siabi"] = "Der große Fras Siabi",
	["The Great Masquerade"] = "Die große Maskerade",
	["The Great Moongraze Hunt"] = "Die große Mondweidenjagd",
	["The Great Retribution"] = "Die große Vergeltung",
	["The Great Silver Deceiver"] = "Der große silberne Betrüger",
	["The Greatest Race of Hunters"] = "Das größte Volk von Jägern",
	["The Green Drake"] = "Der grüne Drache",
	["The Green Hills of Stranglethorn"] = "Die Grünen Hügel des Schlingendorntals",
	["The Greenwarden"] = "Der Sumpfhüter",
	["The Grizzled Den"] = "Der Graufelsbau",
	["The Guns of Northwatch"] = "Die Kanonen von Nordwacht",
	["The Hammer May Fall"] = "Der Hammer kann fallen",
	["The Hand of Gul'dan"] = "Die Hand von Gul'dan",
	["The Hand of Rastakhan"] = "Die Hand von Rastakhan",
	["The Hand of the Righteous"] = "Die Hand der Gerechtigkeit",
	["The Harvester"] = "Der Ernter",
	["The Haunted Isle"] = "Die Spukinsel",
	["The Haunted Mills"] = "Die Spukmühle",
	["The Head of the Beast"] = "Der Kopf des Ganzen",
	["The Heart of Darkness"] = "Das Herz der Dunkelheit",
	["The Heart of the Mountain"] = "Das Herz des Berges",
	["The Hermit"] = "Der Einsiedler",
	["The Hidden Chamber"] = "Die geheime Kammer",
	["The Hidden Key"] = "Der versteckte Schlüssel",
	["The Hidden Niche"] = "Die versteckte Nische",
	["The High Wilderness"] = "Die obere Wildnis",
	["The Hopeless Ones..."] = "Die Hoffnungslosen...",
	["The Horde Needs Firebloom!"] = "Die Horde braucht Feuerblüten!",
	["The Horde Needs Heavy Leather!"] = "Die Horde braucht schweres Leder!",
	["The Horde Needs Mithril Bars!"] = "Die Horde braucht Mithrilbarren!",
	["The Horde Needs More Mageweave Bandages!"] = "Die Horde braucht mehr Magiestoffverbände!",
	["The Horde Needs More Mithril Bars!"] = "Die Horde braucht mehr Mithrilbarren!",
	["The Horde Needs More Peacebloom!"] = "Die Horde braucht mehr Friedensblumen!",
	["The Horde Needs More Purple Lotus!"] = "Die Horde braucht mehr lila Lotus!",
	["The Horde Needs More Rugged Leather!"] = "Die Horde braucht mehr unverwüstliches Leder!",
	["The Horde Needs More Runecloth Bandages!"] = "Die Horde braucht mehr Runenstoffverbände!",
	["The Horde Needs More Spotted Yellowtail!"] = "Die Horde braucht mehr Tüpfelgelbschwänze!",
	["The Horde Needs More Thick Leather!"] = "Die Horde braucht mehr dickes Leder!",
	["The Horde Needs Peacebloom!"] = "Die Horde braucht Friedensblumen!",
	["The Horde Needs Purple Lotus!"] = "Die Horde braucht lila Lotus!",
	["The Horde Needs Rugged Leather!"] = "Die Horde braucht unverwüstliches Leder!",
	["The Horde Needs Runecloth Bandages!"] = "Die Horde braucht Runenstoffverbände!",
	["The Horde Needs Spotted Yellowtail!"] = "Die Horde braucht Tüpfelgelbschwänze!",
	["The Horde Needs Thick Leather!"] = "Die Horde braucht dickes Leder!",
	["The Horde Needs Tin Bars!"] = "Die Horde braucht Zinnbarren!",
	["The Horde Needs Wool Bandages!"] = "Die Horde braucht Wollverbände!",
	["The Horn of the Beast"] = "Das Horn der Bestie",
	["The Horrors of Pollution"] = "Die Schrecken der Verschmutzung",
	["The Hound-Master"] = "Der Hundehetzer",
	["The Howling Vale"] = "Das heulende Tal",
	["The Howling Wind"] = "Der heulende Wind",
	["The Hunt Begins"] = "Die Jagd beginnt",
	["The Hunt Completed"] = "Die Jagd ist abgeschlossen",
	["The Hunt Continues"] = "Die Jagd geht weiter",
	["The Hunter's Charm"] = "Der Talisman des Jägers",
	["The Hunter's Way"] = "Der Weg der Jäger",
	["The Ice Guard"] = "Der Eiswächter",
	["The Ichor of Undeath"] = "Sekret des Untodes",
	["The Impotent Leader"] = "Der unfähige Anführer",
	["The Inconsolable Chieftain"] = "Der untröstliche Häuptling",
	["The Infernal Orb"] = "Die Höllenkugel",
	["The Infested Protectors"] = "Die verseuchten Beschützer",
	["The Instigator's Enchantment"] = "Die Verzauberung des Aufhetzers",
	["The Ironforge Brigade Needs Explosives!"] = "Die Eisenschmiedebrigade braucht Sprengstoff!",
	["The Islander"] = "Der Inselbewohner",
	["The Isle of Dread!"] = "Die Insel des Schreckens!",
	["The Jasperlode Mine"] = "Die Jaspismine",
	["The Jeremiah Blues"] = "Der Jammer des Jeremiah",
	["The Jewel of Kajaro"] = "Das Juwel von Kajaro",
	["The Karnitol Shipwreck"] = "Karnitols Schiffbruch",
	["The Kessel Run"] = "Der Korsallauf",
	["The Key to Freedom"] = "Der Schlüssel zur Freiheit",
	["The Killing Fields"] = "Tod auf den Feldern",
	["The Knife Revealed"] = "Das wieder aufgetauchte Messer",
	["The Kolkar of Desolace"] = "Die Kolkar von Desolace",
	["The Kurken is Lurkin'"] = "Kurken lauert",
	["The Kurken's Hide"] = "Kurkens Balg",
	["The Last Barov"] = "Der letzte Barov",
	["The Last Element"] = "Das letzte Element",
	["The Left Piece of Lord Valthalak's Amulet"] = "Das linke Stück von Lord Valthalaks Amulett",
	["The Legend of Stalvan"] = "Die Legende von Stalvan",
	["The Legion Reborn"] = "Wiedergeburt der Brennenden Legion",
	["The Lexicon Demonica"] = "Encyclopaedia Daemonica",
	["The Lich's Identity"] = "Die Identität des Lichs",
	["The Light and How To Swing It"] = "Vom Licht und wie man es schwingt",
	["The Longbeards"] = "Die Langbarts",
	["The Lord of Blackrock"] = "Der Herrscher des Schwarzfels",
	["The Lost Caravan"] = "Die verlorene Karawane",
	["The Lost Chalice"] = "Elunes Kelch",
	["The Lost Dwarves"] = "Die verschollenen Zwerge",
	["The Lost Fragments"] = "Die verlorenen Fragmente",
	["The Lost Ingots"] = "Die verlorenen Blöcke",
	["The Lost Pages"] = "Die verlorenen Seiten",
	["The Lost Pilot"] = "Der vermisste Pilot",
	["The Lost Report"] = "Der verlorene Bericht",
	["The Lost Supplies"] = "Die verlorenen Vorräte",
	["The Lost Tablets of Mosh'aru"] = "Die verlorenen Schrifttafeln von Mosh'aru",
	["The Lost Tablets of Will"] = "Die verlorene Tafel des Willens",
	["The Lost Tools"] = "Die verlorenen Werkzeuge",
	["The Love Potion"] = "Der Liebestrank",
	["The Madness Within"] = "Der innere Wahnsinn",
	["The Mag'har"] = "Die Mag'har",
	["The Magister's Apprentice"] = "Der Lehrling des Magisters",
	["The Main Course!"] = "Das Hauptgericht!",
	["The Mark of Quality"] = "Das Zeichen der Qualität",
	["The Mark of the Lightbringer"] = "Das Mal des Lichtbringers",
	["The Master Planner"] = "Der Meisterplaner",
	["The Master's Glaive"] = "Die Meistergleve",
	["The Master's Grand Design?"] = "Der große Plan des Meisters?",
	["The Master's Touch"] = "Die Berührung des Meisters",
	["The Mastermind"] = "Das Genie",
	["The Matron Protectorate"] = "Die oberste Beschützerin",
	["The Medallion of Faith"] = "Das Medaillon des Glaubens",
	["The Mighty U'cha"] = "Der mächtige U'cha",
	["The Mills Overrun"] = "Die überrannte Mühle",
	["The Mind's Eye"] = "Das Gedankenauge",
	["The Mindless Ones"] = "Die Hirnlosen",
	["The Minions of Culuthas"] = "Diener von Culuthas",
	["The Missing Courier"] = "Der vermisste Kurier",
	["The Missing Diplomat"] = "Der vermisste Diplomat",
	["The Missing Expedition"] = "Forschungsreise in den Tod",
	["The Missing Fisherman"] = "Der vermisste Fischer",
	["The Missing Merchant"] = "The Missing Merchant", --Missing translation
	["The Missing Orders"] = "Die fehlenden Befehle",
	["The Missing Scout"] = "Der vermisste Späher",
	["The Missing Shipment"] = "Die verloren gegangene Lieferung",
	["The Missing Survey Team"] = "Das vermisste Vermessungsteam",
	["The Missing War Party"] = "Der verschollene Kampftrupp",
	["The Mistress Revealed"] = "Die enttarnte Geliebte",
	["The Mithril Kid"] = "Mithril-Kid",
	["The Mithril Order"] = "Der Mithrilorden",
	["The Molten Core"] = "Der geschmolzene Kern",
	["The Monogrammed Sash"] = "Die Schärpe mit Monogramm",
	["The Morrow Stone"] = "Der Morgenstein",
	["The Moss-twined Heart"] = "Das moosumschlungene Herz",
	["The Mystery of Morrowgrain"] = "Das Geheimnis des Morgenkorns",
	["The Name of the Beast"] = "Der Name der Bestie",
	["The Nesingwary Safari"] = "Nesingwarys Safari",
	["The New Frontier"] = "Die neue Grenze",
	["The New Springs"] = "Die neuen Quellen",
	["The Newest Member of the Family"] = "Das neueste Mitglied der Familie",
	["The Night Watch"] = "Die Nachtwache",
	["The Northern Pylon"] = "Der Nordpylon",
	["The Ogre Threat"] = "Die Ogerbedrohung",
	["The Ogres of Feralas"] = "Die Oger von Feralas",
	["The Old Ways"] = "Die alten Traditionen",
	["The Only Cure is More Green Glow"] = "Das einzige Heilmittel ist mehr grünes Leuchten",
	["The Only Prescription"] = "Der einzige Weg",
	["The Only Song I Know..."] = "Das Einzig",
	["The Opening of the Dark Portal"] = "Die Öffnung des Dunklen Portals",
	["The Orb of Soran'ruk"] = "Die Kugel von Soran'ruk",
	["The Orc Report"] = "Der Orcbericht",
	["The Orebor Harborage"] = "Die Oreoborzuflucht",
	["The Orgrimmar Legion Needs Mojo!"] = "Die Orgrimmarlegion braucht Mojo!",
	["The Origins of Smithing"] = "Die Herkunft der Schmiedekunst",
	["The Outcast's Plight"] = "Die Pflicht eines Ausgestoßenen",
	["The Pack Mistress"] = "Die Herrin der Meute",
	["The Pariah's Instructions"] = "Die Anweisungen des Pariahs",
	["The Party Never Ends"] = "Die Feier ist nie zu Ende",
	["The Path of Anguish"] = "Der Pfad der Pein",
	["The Path of Conquest"] = "Der Pfad der Eroberung",
	["The Path of Glory"] = "Der Pfad des Ruhms",
	["The Path of the Adept"] = "Der Pfad des Adepten",
	["The Path of the Righteous"] = "Der Pfad des Gerechten",
	["The People's Militia"] = "Die Volksmiliz",
	["The Perfect Poison"] = "Das perfekte Gift",
	["The Perfect Stout"] = "Das Perfekte Starkbier",
	["The Plagued Coast"] = "Die verseuchte Küste",
	["The Platinum Discs"] = "Die Platinscheiben",
	["The Pledge of Secrecy"] = "Der Schwur der Geheimhaltung",
	["The Pools of Aggonar"] = "Die Teiche von Aggonar",
	["The Power to Destroy..."] = "Die Macht der Zerstörung...",
	["The Powers Below"] = "Die Macht in der Tiefe",
	["The Price of Shoes"] = "Der Preis für Hufeisen",
	["The Princess Saved?"] = "Ist die Prinzessin gerettet?",
	["The Princess Trapped"] = "Die gefangene Prinzessin",
	["The Princess's Surprise"] = "Die Überraschung der Prinzessin",
	["The Principal Source"] = "Die eigentliche Ursache",
	["The Prison's Bindings"] = "Das Fundament des Gefängnisses",
	["The Prison's Casing"] = "Die Gefängnishülle",
	["The Prodigal Lich"] = "Der abtrünnige Lich",
	["The Prodigal Lich Returns"] = "Die Rückkehr des abtrünnigen Lichs",
	["The Prophecy of Akida"] = "Die Prophezeiung von Akida",
	["The Prophecy of Mosh'aru"] = "Die Prophezeiung von Mosh'aru",
	["The Prophecy of Velen"] = "Die Prophezeiung von Velen",
	["The Public Servant"] = "Im Dienste des Volkes",
	["The Purest Water"] = "Das reinste Wasser",
	["The Qiraji Conqueror"] = "Der Eroberer der Qiraji",
	["The Ranger Lord's Behest"] = "Das Ersuchen des Waldläuferlords",
	["The Ravaged Caravan"] = "Die überfallene Karawane",
	["The Real Threat"] = "Die echte Bedrohung",
	["The Reason for the Season"] = "Der Anlass für die Feiertage",
	["The Red Crystal"] = "Der rote Kristall",
	["The Red Messenger"] = "Der Rote Bote",
	["The Relics of Wakening"] = "Die Relikte des Erwachens",
	["The Remains of Trey Lightforge"] = "Die Überreste von Trey Lichtschmied",
	["The Reports"] = "Die Berichte",
	["The Rescue"] = "Die Rettung",
	["The Restless Souls"] = "Die ruhelosen Seelen",
	["The Rethban Gauntlet"] = "Der Rethbanspießrutenlauf",
	["The Right Piece of Lord Valthalak's Amulet"] = "Das rechte Stück von Lord Valthalaks Amulett",
	["The Ring of Blood: Brokentoe"] = "Der Ring des Blutes: Schmetterzehe",
	["The Ring of Blood: Rokdar the Sundered Lord"] = "Der Ring des Blutes: Rokdar der Zerklüftete",
	["The Ring of Blood: Skra'gath"] = "Der Ring des Blutes: Skra'gath",
	["The Ring of Blood: The Blue Brothers"] = "Der Ring des Blutes: Die Blaumänner",
	["The Ring of Blood: The Final Challenge"] = "Der Ring des Blutes: die letzte Herausforderung",
	["The Ring of Blood: The Warmaul Champion"] = "Der Ring des Blutes: Champion der Totschläger",
	["The Ring of Mmmrrrggglll"] = "Mmmrrrgggllls Ring",
	["The Rise of the Machines"] = "Aufstieg der Maschinen",
	["The Road to Darnassus"] = "Die Straße nach Darnassus",
	["The Road to Falcon Watch"] = "Der Weg zur Falkenwacht",
	["The Rock Flayer Matriarch"] = "Die Felsklauenmatriarchin",
	["The Rod of Lianthe"] = "Die Rute von Lianthe",
	["The Root of All Evil"] = "Die Wurzel alles Bösen",
	["The Royal Rescue"] = "Die königliche Rettung",
	["The Ruins of Burning Blade"] = "Die Ruinen der Brennenden Klinge",
	["The Ruins of Kel'Theril"] = "Die Ruinen von Kel'Theril",
	["The Ruins of Solarsal"] = "Die Ruinen von Solarsal",
	["The Ruins of Stardust"] = "Die Sternenstaubruinen",
	["The Rumormonger"] = "Der Gerüchteverbreiter",
	["The Rune of Summoning"] = "Beschwörungsrune",
	["The Runed Scroll"] = "Die runenverzierte Rolle",
	["The Sacred Flame"] = "Die heilige Flamme",
	["The Sad Truth"] = "Die traurige Wahrheit",
	["The Sanctum of the Sun"] = "Das Sanktum der Sonne",
	["The Savage Guard - Arcanum of Focus"] = "Der Greuelwächter - Arkanum des Fokus",
	["The Savage Guard - Arcanum of Protection"] = "Der Greuelwächter - Arkanum des Schutzes",
	["The Savage Guard - Arcanum of Rapidity"] = "Der Greuelwächter - Arkanum der Schnelligkeit",
	["The Savior of Kalimdor"] = "Der Retter von Kalimdor",
	["The Scarlet Crusade"] = "Der Scharlachrote Kreuzzug",
	["The Scent of Lar'korwi"] = "Lar'korwis Fährte",
	["The Scepter of Celebras"] = "Das Szepter von Celebras",
	["The Scorched Grove"] = "Der versengte Hain",
	["The Scourge Cauldrons"] = "Die Geißelkessel",
	["The Scrimshank Redemption"] = "Die Erlösung von Kieselschliff",
	["The Scythe of Elune"] = "Die Sense von Elune",
	["The Search Continues"] = "Die Suche geht weiter",
	["The Second Course..."] = "Der zweite Gang...",
	["The Second Rebellion"] = "Die zweite Rebellion",
	["The Second Sample"] = "Die zweite Probe",
	["The Second Trial"] = "Die zweite Prüfung",
	["The Second and Third Fragments"] = "Das zweite und das dritte Fragment",
	["The Seer's Relic"] = "Das Relikt des Sehers",
	["The Severed Head"] = "Der abgetrennte Kopf",
	["The Shade of Elura"] = "Eluras Schemen",
	["The Shadow Guard"] = "Der Schattenwächter",
	["The Shadow Tomb"] = "Das Schattengrab",
	["The Shadowmoon Shuffle"] = "Unterwürfigkeit in Schattenmond",
	["The Shadowy Figure"] = "Die Schattengestalt",
	["The Shadowy Search Continues"] = "Die Schattensuche geht weiter",
	["The Sharpest Blades"] = "Die schärfsten Klingen",
	["The Shattered Hand"] = "Die Zerschmetterte Hand",
	["The Shattered Necklace"] = "Die zerrissene Halskette",
	["The Shattered Salute"] = "Der Gruß der Zerschmetterten Hand",
	["The Shieldsmith"] = "Der Schildschmied",
	["The Shimmering Frond"] = "Der schimmernde Wedel",
	["The Shrine of Dath'Remar"] = "Der Schrein von Dath'Remar",
	["The Sigil of Krasus"] = "Das Siegel von Krasus",
	["The Singing Crystals"] = "Die singenden Kristalle",
	["The Siren's Coral"] = "Die Koralle der Sirenen",
	["The Sketh'lon Wreckage"] = "Das Wrack der Sketh'lon",
	["The Skettis Offensive"] = "Offensive aus Skettis",
	["The Slaughtered Lamb"] = "Zum Geschlachteten Lamm",
	["The Sleeper Has Awakened"] = "Der Schläfer ist erwacht",
	["The Sleeping Druid"] = "Der schlafende Druide",
	["The Smallest Creatures"] = "Die kleinsten Wesen",
	["The Smoldering Ruins of Thaurissan"] = "Die glimmenden Ruinen von Thaurissan",
	["The So-Called Mark of the Lightbringer"] = "Das sogenannte Mal des Lichtbringers",
	["The Softest Wings"] = "Die weichsten Flügel",
	["The Soul Devices"] = "Seeleninstrumente",
	["The Spearcrafter's Hammer"] = "Der Hammer des Speermachers",
	["The Spectral Chalice"] = "Der spektrale Kelch",
	["The Spider God"] = "Der Spinnengott",
	["The Spirit Polluted"] = "Der verschmutzte Geist",
	["The Spirits Have Voices"] = "Die Stimme der Geister",
	["The Spirits of Southwind"] = "Die Geister vom Südwindposten",
	["The Spirits of Stonetalon"] = "Die Geister des Steinkrallengebirges",
	["The Sporelings' Plight"] = "Die Misere der Sporlinge",
	["The Sprouted Fronds"] = "Die sprießenden Wedel",
	["The Spy Revealed!"] = "Der entlarvte Spion",
	["The Stagnant Oasis"] = "Die brackige Oase",
	["The Stave of Equinex"] = "Der Stock von Equinex",
	["The Stockade Riots"] = "Aufstand im Verlies",
	["The Stolen Journal"] = "Das gestohlene Tagebuch",
	["The Stolen Tome"] = "Der gestohlene Foliant",
	["The Stone"] = "Der Stein",
	["The Stone Circle"] = "Der runde Stein",
	["The Stone Watcher"] = "Der Steinbehüter",
	["The Stone of the Tides"] = "Der Stein der Gezeiten",
	["The Stones That Bind Us"] = "Die Stein",
	["The Stones of Vekh'nir"] = "Die Steine der Vekh'nir",
	["The Strength of Corruption"] = "Die Kraft der Verderbnis",
	["The Summoning"] = "Die Beschwörung",
	["The Summoning Chamber"] = "Die Beschwörungskammer",
	["The Sun Gate"] = "Das Sonnentor",
	["The Sunfury Garrison"] = "Die Garnison des Sonnenzornpostens",
	["The Sunken Temple"] = "Der Versunkene Tempel",
	["The Super Snapper FX"] = "Der Superschnapper FX",
	["The Swamp Talker"] = "Der Sumpfredner",
	["The Swarm Grows"] = "Der Schwarm wächst",
	["The Tear of the Moons"] = "Die Träne der Monde",
	["The Tempest Key"] = "Der Schlüssel der Stürme",
	["The Temple of Atal'Hakkar"] = "Der Tempel von Atal'Hakkar",
	["The Temple of Telhamat"] = "Der Tempel von Telhamat",
	["The Terror of Marshlight Lake"] = "Der Schrecken des Sumpflichtsees",
	["The Test of Righteousness"] = "Die Prüfung der Rechtschaffenheit",
	["The Thandol Span"] = "Der Thandolübergang",
	["The Theramore Docks"] = "Die Docks von Theramore",
	["The Third Fleet"] = "Die Dritte Flotte",
	["The Throne of the Elements"] = "Der Thron der Elemente",
	["The Thunderspike"] = "Die Donnerlanze",
	["The Tome of Divinity"] = "Der Foliant der Offenbarung",
	["The Tome of Valor"] = "Der Foliant der Ehre",
	["The Torch of Retribution"] = "Die Fackel der Vergeltung",
	["The Tortured Earth"] = "Die gequälte Erde",
	["The Totem of Infliction"] = "Das Totem des Gegenschlages",
	["The Totem of Kar'dash"] = "Das Totem von Kar'dash",
	["The Totems of My Enemy"] = "Die Totems meines Feindes",
	["The Touch of Zanzil"] = "Die Berührung von Zanzil",
	["The Tower of Althalaxx"] = "Der Turm von Althalaxx",
	["The Traitor's Destruction"] = "Der Tod des Verräters",
	["The Traitor's Shadow"] = "Schatten des Verräters",
	["The Trappings of a Vindicator"] = "Die Gefangenschaft der Verteidigerin",
	["The Treasure of the Shen'dralar"] = "Der Schatz der Shen'dralar",
	["The Trogg Threat"] = "Die Bedrohung durch die Troggs",
	["The Troll Cave"] = "Die Trollhöhle",
	["The Troll Witchdoctor"] = "Der Trollhexendoktor",
	["The True Masters"] = "Die wahren Meister",
	["The Truth Comes Crashing Down"] = "Die Wahrheit zeigt sich mit Macht",
	["The Truth Unorbed"] = "Die kugellose Wahrheit",
	["The Twilight Camp"] = "Das Lager des Schattenhammers",
	["The Twilight Lexicon"] = "Das Lexikon des Schattenhammerklans",
	["The Twilight Mystery"] = "Das Geheimnis des Schattenhammerklans",
	["The Twin Clefts of Nagrand"] = "Die Zwillingsschluchten von Nagrand",
	["The Twin Ziggurats"] = "Die Zwillingsziggurate",
	["The Ultimate Bloodsport"] = "Die ultimative Beute",
	["The Ultimate Deception"] = "Die ultimative Täuschung",
	["The Umbrafen Tribe"] = "Der Umbrafennstamm",
	["The Undermarket"] = "Der Untermarkt",
	["The Underneath"] = "Im Untergrund",
	["The Unending Invasion"] = "Die unendliche Invasion",
	["The Unmarred Vision of Voodress"] = "Die unversehrte Vision von Voodress",
	["The Unsent Letter"] = "Der nie verschickte Brief",
	["The Unwritten Prophecy"] = "Die ungeschriebene Prophezeiung",
	["The Vengeful Harbinger"] = "Der rachsüchtige Herold",
	["The Venture Co."] = "Die Venture Company",
	["The Videre Elixir"] = "Das Videre-Elixier",
	["The Vile Reef"] = "Das finstere Riff",
	["The Warchief's Mandate"] = "Das Anliegen des Kriegshäuptlings",
	["The Warden's Cage"] = "Der Kerker des Wächters",
	["The Warlord's Hideout"] = "Das Versteck des Kriegsherren",
	["The Warp Rifts"] = "Sphärenrisse",
	["The Warsong Reports"] = "Die Berichte des Kriegshymnenklans",
	["The Way of the Weaponsmith"] = "Der Weg des Waffenschmieds...",
	["The Way to Auberdine"] = "Der Weg nach Auberdine",
	["The Wayward Apprentice"] = "Der eigensinnige Lehrling",
	["The Weathered Grave"] = "Das verwitterte Grab",
	["The Weaver"] = "Der Wirker",
	["The Western Pylon"] = "Der Westpylon",
	["The Wildlife Suffers Too"] = "Die Tierwelt leidet auch",
	["The Will of the Warchief"] = "Der Wille des Kriegshäuptlings",
	["The Windwatcher"] = "Der Windbehüter",
	["The Woodland Protector"] = "Die Beschützerin des Waldlandes",
	["The Woodpaw Gnolls"] = "Die Waldpfotengnolle",
	["The Work of Grimand Elmore"] = "Grimand Elmores Werk",
	["The World At Your Feet"] = "Die Welt zu Euren Füßen",
	["The World's Largest Gnome!"] = "Der größte Gnom der Welt!",
	["The Writhing Deep"] = "Die verwundene Tiefe",
	["The Wrong Stuff"] = "Das richtige Zeug",
	["The Zapthrottle Mote Extractor!"] = "Der schockdrosselnde Partikelextraktor!",
	["The Zhevra"] = "Die Zhevras",
	["The Zoram Strand"] = "Der Zoramstrand",
	["Theldurin the Lost"] = "Theldurin der Verirrte",
	["Thelsamar Blood Sausages"] = "Blutwurst aus Thelsamar",
	["Theocritus' Retrieval"] = "Wiederbeschaffung für Theocritus",
	["Theramore Spies"] = "Theramores Spione",
	["There Can Be Only One Response"] = "Es kann nur eine Antwort geben",
	["There Is No Hope"] = "Es gibt keine Hoffnung",
	["There's No Explanation for Fashion"] = "Mode kann man nicht erklären",
	["Therylune's Escape"] = "Therylunes Flucht",
	["Therzok"] = "Therzok",
	["They Call Him Smiling Jim"] = "Sie nennen ihn den lächelnden Jim",
	["They Call Me \"The Rooster\""] = "Sie nennen mich \"den Schleifer\"",
	["They Stole Me Hookah and Me Brews!"] = "Die ham meine Pfeife und mein Gesöff geklaut!",
	["They're Alive! Maybe..."] = "Sie leben! Vielleicht...",
	["Thick Hydra Scales"] = "Dicke Hydraschuppen",
	["Thin the Flock"] = "Die Herde ausdünnen",
	["Thinning the Ranks"] = "Die Reihen lichten",
	["Thirst Unending"] = "Unstillbarer Durst",
	["This Is Going to Be Hard"] = "Das wird schwierig",
	["Thistleshrub Valley"] = "Disteltal",
	["Thorium Widget"] = "Thoriumapparat",
	["Those Blasted Troggs!"] = "Diese verfluchten Troggs!",
	["Threat From the Sea"] = "Gefahr aus dem Meer",
	["Threat of the Winterfall"] = "Bedrohung durch die Winterfelle",
	["Three Kings of Flame"] = "Die drei Könige der Flammen",
	["Through the Dark Portal"] = "Durch das Dunkle Portal",
	["Thule Ravenclaw"] = "Thule Rabenklaue",
	["Thun'grim Firegaze"] = "Thun'grim Brandblick",
	["Thunderaan the Windseeker"] = "Donneraan der Windsucher",
	["Thunderbrew Lager"] = "Donnerbräu Lagerbier",
	["Thunderhorn Cleansing"] = "Donnerhornsäuberung",
	["Thunderhorn Totem"] = "Totem der Donnerhörner",
	["Thunderlord Clan Artifacts"] = "Artefakte der Donnerfürsten",
	["Thundris Windweaver"] = "Thundris Windwirker",
	["Thwart the Dark Conclave"] = "Dem Dunklen Rat in die Quere kommen",
	["Thwarting Kolkar Aggression"] = "Vereitelung der Kolkaraggression",
	["Tiara of the Deep"] = "Tiara der Tiefen",
	["Tiara of the Oracle"] = "Tiara des Orakels",
	["Tiger Mastery"] = "Beherrschen der Tigerjagd",
	["Timber Worg Tails"] = "Waldworgschwänze",
	["Timberling Seeds"] = "Bäumlingssamenkörner",
	["Timberling Sprouts"] = "Bäumlingssprosse",
	["Time To Strike"] = "Zeit zum Zuschlagen",
	["Tinkee Steamboil"] = "Tinkee Kesseldampf",
	["To Catch A Thistlehead"] = "Einen Distelsüchtigen fangen",
	["To Gadgetzan You Go!"] = "Ab mit Euch nach Gadgetzan!",
	["To Ironforge for Yagyin's Digest"] = "Auf nach Eisenschmiede zu 'Yagyins Zusammenstellung'",
	["To Kill With Purpose"] = "Töten zu einem bestimmten Zweck",
	["To Legion Hold"] = "Zur Feste der Legion",
	["To Meet Mother Kashur"] = "Mutter Kashur treffen",
	["To Netherwing Ledge!"] = "Zur Netherschwingenscherbe!",
	["To Serve Kum'isha"] = "Ein Dienst für Kum'isha",
	["To Show Due Judgment"] = "Lass Gerechtigkeit walten",
	["To Steal From Thieves"] = "Von Dieben stehlen",
	["To The Bulwark"] = "Zum Bollwerk",
	["To The Hinterlands"] = "Ins Hinterland",
	["To Winterspring!"] = "Nach Winterquell!",
	["To the Stormspire"] = "Zur Sturmsäule",
	["To the Top"] = "An die Spitze",
	["To the Undercity for Yagyin's Digest"] = "Auf nach Unterstadt zu 'Yagyins Zusammenstellung'",
	["Tomb of the Lightbringer"] = "Das Grab des Lichtbringers",
	["Tomber's Supplies"] = "Tombers Vorräte",
	["Tome of Divinity"] = "Foliant der Offenbarung",
	["Tome of the Cabal"] = "Foliant der Kabale",
	["Too Many Mouths to Feed"] = "Zu viele Mäuler zu stopfen",
	["Tooga's Quest"] = "Toogas Bitte",
	["Tools for Steelgrill"] = "Werkzeuge für Stahlrost",
	["Tools of the Highborne"] = "Werkzeuge der Hochgeborenen",
	["Tools of the Trade"] = "Werkzeuge des Handwerks",
	["Torching Sunfury Hold"] = "Den Sonnenzornposten anzünden",
	["Torek's Assault"] = "Toreks Angriff",
	["Torgos!"] = "Torgos!",
	["Tormented By the Past"] = "Gequält von der Vergangenheit",
	["Tormus Deepforge"] = "Tormus Tiefenschmied",
	["Torn Bear Pelts"] = "Zerrissene Bärenpelze",
	["Torwa Pathfinder"] = "Torwa Pfadfinder",
	["Totem of Coo"] = "Totem von Coo",
	["Totem of Tikti"] = "Totem von Tikti",
	["Totem of Vark"] = "Totem von Vark",
	["Totem of Yor"] = "Totem von Yor",
	["Touch of Weakness"] = "Berührung der Schwäche",
	["Towers and Bunkers"] = "Türme und Bunker",
	["Toxic Horrors"] = "Toxinschrecken",
	["Toxic Test"] = "Giftexperiment",
	["Tracking Down the Culprits"] = "Tracking Down the Culprits", --Missing translation
	["Training the Beast"] = "Die Ausbildung des Tiers",
	["Traitor to the Bloodsail"] = "Verrat am Blutsegel",
	["Tramping Paws"] = "Stapfende Pfoten",
	["Trampled Under Foot"] = "In den Boden getrampelt",
	["Tran'rek"] = "Tran'rek",
	["Translate Abercrombie's Note"] = "Übersetzung von Calvinius' Notiz",
	["Translating the Journal"] = "Übersetzung des Tagebuchs",
	["Translating the Ledger"] = "Übersetzung des Buchs",
	["Translation to Ello"] = "Übersetzung für Ello",
	["Translations..."] = "Übersetzungen...",
	["Trapping the Light Fantastic"] = "Das Licht der Phantasie einfangen",
	["Travel to Azure Watch"] = "Reise zur Azurwacht",
	["Travel to Darkshire"] = "Reist nach Dunkelhain",
	["Treant Muisek"] = "Muisek von Treants",
	["Treats for Greatfather Winter"] = "Leckereien für Altvater Winter",
	["Tree's Company"] = "Laubangriff",
	["Treebole Must Know"] = "Baumriese muss es wissen",
	["Trek to Ashenvale"] = "Marsch ins Eschental",
	["Trelane's Defenses"] = "Trelanes Verteidigung",
	["Tremors of the Earth"] = "Erdbeben",
	["Triage"] = "Triage",
	["Trial and Error"] = "Probieren geht über Studieren",
	["Trial at the Field of Giants"] = "Prüfung auf dem Feld der Riesen",
	["Triangulation Point One"] = "Triangulationspunkt Eins",
	["Triangulation Point Two"] = "Triangulationspunkt Zwei",
	["Tribal Leatherworking"] = "Stammeslederverarbeitung",
	["Tribes at War"] = "Stämme im Krieg",
	["Trinkets..."] = "Plunder...",
	["Trol'kalar"] = "Trol'kalar",
	["Troll Charm"] = "Trollglücksbringer",
	["Troll Juju"] = "Trolljuju",
	["Troll Necklace Bounty"] = "geld für Trollhalsketten",
	["Troll Temper"] = "Trollaushärter",
	["Troll Witchery"] = "Trollhexerei",
	["Trollbane"] = "Trollbann",
	["Trollbane is Looking for You"] = "Trollbann sucht Euch",
	["Trolls of a Feather"] = "Federn von Trollen",
	["Trouble In Darkshore?"] = "Ärger in Dunkelküste?",
	["Trouble at Auchindoun"] = "Ärger in Auchindoun",
	["Trouble at the Docks"] = "Ärger auf den Docks",
	["Trouble at the Underlight Mines"] = "Ärger in den Grubenlichtminen",
	["Trouble in Winterspring!"] = "Probleme in Winterquell",
	["Trouble in the Deeps"] = "Ärger in der Tiefe",
	["Troubled Spirits of Kel'Theril"] = "Die gequälten Seelen von Kel'Theril",
	["Troublesome Distractions"] = "Störende Ablenkung",
	["True Believers"] = "Wahrer Glauben",
	["Trueflight Arrows"] = "Treffsichere Pfeile",
	["Truth or Fiction"] = "Was ist wahr?",
	["Tumors"] = "Tumore",
	["Tundra MacGrann's Stolen Stash"] = "Tundra MacGranns gestohlene Vorräte",
	["Turning Point"] = "Der Wendepunkt",
	["Turning the Tide"] = "Das Schicksal wenden",
	["Twilight Battle Orders"] = "Schlachtordnungen des Schattenhammerklans",
	["Twilight Falls"] = "Schatten des Hammers",
	["Twilight Geolords"] = "Geolords des Schattenhammers",
	["Twilight Marauders"] = "Marodeure des Schattenhammers",
	["Twilight Ring of Lordship"] = "Herrschaftsring des Schattenhammerklans",
	["Twilight of the Dawn Runner"] = "Der Untergang der Morgenbö",
	["Twisted Evils"] = "Dunkles Böses",
	["Twisted Hatred"] = "Krankhafter Hass",
	["Two Halves Become One"] = "Zwei Hälften vereint",
	["Tyrande and Remulos"] = "Tyrande und Remulos",
	["Ula'elek and the Brutal Gauntlets"] = "Ula'elek und die brutalen Stulpen",
	["Ulag the Cleaver"] = "Ulag der Spalter",
	["Ulathek the Traitor"] = "Ulathek der Verräter",
	["Uldaman Reagent Run"] = "Reagenzsuche in Uldaman",
	["Umbrafen Eel Filets"] = "Aalfilets von Umbrafenn",
	["Un'Goro Soil"] = "Erde von Un'Goro",
	["Un-Life's Little Annoyances"] = "Die kleinen Ärgernisse des Un-Lebens",
	["Uncatalogued Species"] = "Nicht katalogisierte Gattung",
	["Unclaimed Baggage"] = "Unabgeholtes Gepäck",
	["Uncle Carlin"] = "Onkel Carlin",
	["Uncovering the Past"] = "Enthüllung der Vergangenheit",
	["Undamaged Venom Sac"] = "Unbeschädigter Giftbeutel",
	["Under Whose Orders?"] = "Under Whose Orders?", --Missing translation
	["Under the Chitin Was..."] = "Unter dem Chitin war...",
	["Underbelly Scales"] = "Bauchschuppen",
	["Undercutting the Competition"] = "Die Konkurrenz untergraben",
	["Underground Assault"] = "Unterirdischer Angriff",
	["Underlight Ore Samples"] = "Grubenlichterzproben",
	["Understanding the Mok'Nathal"] = "Verständnis für die Mok'Nathal",
	["Underworld Loam"] = "Unterweltlehm",
	["Unexpected Results"] = "Ungewöhnliche Ergebnisse",
	["Unfinished Business"] = "Offene Rechnungen",
	["Unfortunate Measures"] = "Bedauerliche Maßnahmen",
	["Uniting the Shattered Amulet"] = "Das zerbrochene Amulett vereinen",
	["Unlocking the Compendium"] = "Das Kompendium öffnen",
	["Unruly Neighbors"] = "Widerspenstige Nachbarn",
	["Unstable Mana Crystals"] = "Instabile Manakristalle",
	["Until Death Do Us Part"] = "Bis dass der Tod uns scheidet",
	["Up to Snuff"] = "Auf dem Schnupftabak",
	["Update for Sentinel Thenysil"] = "Neuigkeiten für Schildwache Thenysil",
	["Ur's Treatise on Shadow Magic"] = "Urs Abhandlung über Schattenmagie",
	["Urgent Delivery"] = "Dringende Nachricht",
	["Urgent Delivery!"] = "Eilige Lieferung!",
	["Urok Doomhowl"] = "Urok Schreckensbote",
	["Ursal the Mauler"] = "Ursal der Raufer",
	["Ursangous's Paw"] = "Ursangus' Tatze",
	["Ursius of the Shardtooth"] = "Ursius von den Splitterzahnbären",
	["Us or Them"] = "Sie oder wir",
	["Vahlarriel's Search"] = "Vahlarriels Suche",
	["Valik"] = "Valik",
	["Vanquish the Betrayers"] = "Vernichtet die Verräter",
	["Vanquishing Aquantion"] = "Aquantion bezwingen",
	["Veil Lithic: Preemptive Strike"] = "Präventivschlag gegen das Lithicversteck",
	["Veil Rhaze: Unliving Evil"] = "Das untote Böse des Rhazeverstecks",
	["Veil Shalas: Signal Fires"] = "Signalfeuer des Shalasverstecks",
	["Veil Skith: Darkstone of Terokk"] = "Dunkelstein des Skithverstecks",
	["Vejrek"] = "Vejrek",
	["Velinde Starsong"] = "Velinde Sternensang",
	["Velinde's Effects"] = "Velindes Besitztümer",
	["Velora Nitely and the Brutal Legguards"] = "Velora Nachtens und die brutalen Beinschützer",
	["Vengeance on the Northspring"] = "Rache an den Nordschwingen",
	["Venom Bottles"] = "Giftflaschen",
	["Venom to the Undercity"] = "Gift für Unterstadt",
	["Venture Company Mining"] = "Venture Company-Bergbau",
	["Verdant Sigil"] = "Tiefgrünes Siegelzeichen",
	["Verifying the Corruption"] = "Die Verderbnis überprüfen",
	["Verog the Dervish"] = "Verog der Derwisch",
	["Vessels of Power"] = "Gefäße der Macht",
	["Vestments of the Wolf Spirit"] = "Gewänder des Wolfgeistes",
	["Veteran Uzzek"] = "Veteran Uzzek",
	["Veteran's Battlegear"] = "Schlachtrüstung des Veteranen",
	["Vibrant Plumes"] = "Farbenprächtige Federbüsche",
	["Victims of Corruption"] = "Opfer der Verderbnis",
	["Victory for the Alliance"] = "Sieg für die Allianz",
	["Victory for the Horde"] = "Sieg für die Horde",
	["Vile Familiars"] = "Üble Familiare",
	["Vile Idolatry"] = "Abscheulicher Götzendienst",
	["Vile Plans"] = "Boshafte Pläne",
	["Vile Satyr! Dryads in Danger!"] = "Elende Satyrn! Die Dryaden sind in Gefahr!",
	["Vilebranch Hooligans"] = "Schläger der Blutfratzen",
	["Villains of Darrowshire"] = "Bösewichte von Darroheim",
	["Vindicator Aldar"] = "Verteidiger Aldar",
	["Vindicator's Rest"] = "Verteidigers Ruh'",
	["Vision Guide"] = "Wegweisende Visionen",
	["Vision of the Dead"] = "Vision der Toten",
	["Visit the Herbalist"] = "Besuch im Kräuterladen",
	["Vital Intelligence"] = "Entscheidende Informationen",
	["Vital Supplies"] = "Überaus wichtige Vorräte",
	["Vivian Lagrave"] = "Vivian Lagrave",
	["Vivian Lagrave and the Darkstone Tablet"] = "Vivian Lagrave und die Dunkelsteinschrifttafel",
	["Void Ridge"] = "Der Leerengrat",
	["Voidwalkers Gone Wild"] = "Wilde Leerwandler",
	["Volatile Mutations"] = "Unberechenbare Mutanten",
	["Volcanic Activity"] = "Vulkanische Aktivität",
	["Volunteer's Battlegear"] = "Schlachtrüstung des Kriegsfreiwilligen",
	["Voodoo Dues"] = "Voodooschulden",
	["Voodoo Feathers"] = "Voodoofedern",
	["Voren'thal's Visions"] = "Voren'thals Visionen",
	["Vorlus Vilehoof"] = "Vorlus Elendshuf",
	["Vorrel's Revenge"] = "Vorrels Rache",
	["Vorsha the Lasher"] = "Vorsha die Peitscherin",
	["Vulture's Vigor"] = "Lebensenergie des Geiers",
	["Vyletongue Corruption"] = "Schlangenzunges Verderbnis",
	["Vyral the Vile"] = "Vyral der Üble",
	["Vyrin's Revenge"] = "Vyrins Rache",
	["WANTED: Andre Firebeard"] = "GESUCHT: Andre Feuerbart",
	["WANTED: Baron Longshore"] = "GESUCHT: Baron Küstenschipper",
	["WANTED: Baron Vardus"] = "GESUCHT: Baron Vardus",
	["WANTED: Boss Grog'ak"] = "GESUCHT: Boss Grog'ak",
	["WANTED: Caliph Scorpidsting"] = "GESUCHT: Kalif Skorpidstich",
	["WANTED: Chok'sul"] = "GESUCHT: Chok'sul",
	["WANTED: Deathclaw"] = "GESUCHT: Todespranke",
	["WANTED: Murkdeep!"] = "GESUCHT: Gurgelbacke!",
	["WANTED: Overseer Maltorius"] = "GESUCHT: Vorarbeiter Maltorius",
	["WANTED: Syndicate Personnel"] = "GESUCHT: Syndikatspersonal",
	["Wait for Sirra to Finish"] = "Warte",
	["Waking Legends"] = "Legenden erwachen",
	["Wand over Fist"] = "Zauberstab gegen Faust",
	["Wand to Bethor"] = "Zauberstab an Bethor",
	["Wandering Shay"] = "Streunende Shay",
	["Wanted - Arnak Grimtotem"] = "GESUCHT: Arnak Grimmtotem",
	["Wanted! Marez Cowl"] = "GESUCHT: Marez Schattenkutte",
	["Wanted! Otto and Falconcrest"] = "GESUCHT: Falkenstein und Otto",
	["Wanted: Annihilator Servo!"] = "Gesucht: Vernichter Servo!",
	["Wanted: Blacktalon the Savage"] = "Gesucht: Schwarzkralle die Wilde",
	["Wanted: Bonelashers Dead!"] = "Aufruf: Tötet die Knochenpeitscher!",
	["Wanted: Chieftain Mummaki"] = "Gesucht: Häuptling Mummaki",
	["Wanted: DWARVES!"] = "GESUCHT: ZWERGE!",
	["Wanted: Durn the Hungerer"] = "Gesucht: Durn der Nimmersatte",
	["Wanted: Gath'Ilzogg"] = "GESUCHT: Gath'Ilzogg",
	["Wanted: Giselda the Crone"] = "Gesucht: Giselda die Alte",
	["Wanted: Knucklerot and Luzran"] = "Gesucht: Faulbein und Luzran",
	["Wanted: Lieutenant Fangore"] = "GESUCHT: Leutnant Fangor",
	["Wanted: Maggot Eye"] = "GESUCHT: Madenauge",
	["Wanted: Thaelis the Hungerer"] = "Gesucht: Thaelis der Manadurstige",
	["Wanted: Vile Priestess Hexx and Her Minions"] = "GESUCHT: Üble Priesterin Hexx und ihre Diener",
	["Wanted: Worg Master Kruush"] = "Gesucht: Worgmeister Kruush",
	["Wanted: Zorbo the Advisor"] = "Gesucht: Zorbo der Berater",
	["Wanted: \"Hogger\""] = "GESUCHT: \"Hogger\"",
	["War Banners"] = "Kriegsflaggen",
	["War at Sea"] = "Krieg zur See",
	["War on Deatholme"] = "Krieg gegen die Todesfestung",
	["War on the Shadowsworn"] = "Krieg den Schattenanbetern",
	["War on the Warmaul"] = "Krieg den Totschlägern",
	["War on the Woodpaw"] = "Krieg gegen die Waldpfoten",
	["Warden Hamoot"] = "Aufseher Hamuht",
	["Warlock Training"] = "Ausbildung zum Hexenmeister",
	["Warlord Krellian"] = "Kriegsherr Krellian",
	["Warlord Sriss'tiz"] = "Kriegsherr Sriss'tiz",
	["Warlord of the Bleeding Hollow"] = "Kriegsherr des Blutenden Auges",
	["Warlord's Command"] = "Befehl des Kriegsherrn",
	["Warn Area 52!"] = "Warnt Area 52!",
	["Warn Your People"] = "Warnt vor der Gefahr",
	["Warning Fairbreeze Village"] = "Warnt Morgenluft",
	["Warning the Cenarion Circle"] = "Den Zirkel des Cenarius warnen",
	["Warp-Raider Nesaad"] = "Sphärenräuber Nesaad",
	["Warrior Kinship"] = "Kriegerverwandtschaft",
	["Warrior Training"] = "Ausbildung zum Krieger",
	["Warsong Outrider Update"] = "Update für Vorhut des Kriegshymnenklans",
	["Warsong Runner Update"] = "Update für Läufer des Kriegshymnenklans",
	["Warsong Saw Blades"] = "Sägeblätter des Kriegshymnenklans",
	["Warsong Scout Update"] = "Update für Späher des Kriegshymnenklans",
	["Warsong Supplies"] = "Nachschub des Kriegshymnenklans",
	["Washed Ashore"] = "An Land gespült",
	["Washte Pawne"] = "Washte Pawne",
	["Wasteland"] = "Einöde",
	["Wastewander Justice"] = "Wüstenläufergerechtigkeit",
	["Watcher Leesa'oh"] = "Behüterin Lessa'oh",
	["Water Elementals"] = "Wasserelementare",
	["Water Pouch Bounty"] = "Wasserbeutelkopfgeld",
	["Waters of Xavian"] = "Wasser von Xavian",
	["Weaken the Ramparts"] = "Die Bollwerke schwächen",
	["Weapons of Choice"] = "Ausgewählte Waffen",
	["Weapons of Elunite"] = "Waffen aus Elunit",
	["Weapons of Spirit"] = "Waffen des Geistes",
	["Webwood Egg"] = "Waldweberei",
	["Webwood Venom"] = "Waldwebergift",
	["Welcome to the Jungle"] = "Willkommen im Dschungel",
	["Welcome!"] = "Willkommen!",
	["Welcoming the Wolf Spirit"] = "Willkommen Wolfgeist!",
	["Well of Corruption"] = "Brunnen der Verderbnis",
	["Wenikee Boltbucket"] = "Wenikee Kübelbolz",
	["Westbrook Garrison Needs Help!"] = "Hilfe für die Weststromgarnison",
	["Westfall Stew"] = "Westfalleintopf",
	["Wharfmaster Dizzywig"] = "Werftmeister Flunkerblick",
	["What Are These Things?"] = "Was ist das?",
	["What Argus Means to Me"] = "Was Argus für mich bedeutet",
	["What Book? I Don't See Any Book."] = "Welches Buch? Ich sehe kein Buch.",
	["What Comes Around..."] = "Verbrechen lohnt sich nicht",
	["What Happens in Terokkar Stays in Terokkar"] = "Was in Terokkar geschieh",
	["What Is Going On?"] = "Was ist los?",
	["What Must Be Done..."] = "Was getan werden muss...",
	["What Niby Commands"] = "Nibys Anweisungen",
	["What Strange Creatures..."] = "Welch merkwürdige Wesen...",
	["What Tomorrow Brings"] = "Was uns morgen erwartet",
	["What We Don't Know..."] = "Was wir nicht wissen...",
	["What We Know..."] = "Was wir wissen...",
	["What the Flux?"] = "Was zum Fluxus?!",
	["What the Soul Sees"] = "Was die Seele sieht",
	["What the Wind Carries"] = "Was der Wind erzählt",
	["What's Wrong at Cenarion Thicket?"] = "Was ist los mit dem Cenariusdickicht?",
	["Wheel of the Black March"] = "Das Rad des Schwarzen Marsches",
	["Whelps of the Wyrmcult"] = "Welpen des Wyrmkults",
	["When Nature Goes Too Far"] = "Wenn die Natur zu weit geht",
	["When Spirits Speak"] = "Wenn Geister sprechen",
	["When This Mine's a-Rockin'"] = "Bringt diese Mine zum Beben!",
	["When Worlds Collide..."] = "Wenn Welten kollidieren...",
	["When the Cows Come Home"] = "Almabtrieb",
	["Where Did Those Darn Gnomes Go?"] = "Wo sind diese verdammten Gnome hin?",
	["Where's Wyllithen?"] = "Wo ist Wyllithen?",
	["Whirlwind Weapon"] = "Wirbelwaffe",
	["Whirring Bronze Gizmo"] = "Surrendes bronzenes Dingsda",
	["Whiskey Slim's Lost Grog"] = "Klein Whiskeys verlorener Grog",
	["Whispers of the Raven God"] = "Das Flüstern des Rabengottes",
	["Whispers on the Wind"] = "Das Flüstern im Wind",
	["Whitebark's Memory"] = "Weißborkes Erinnerung",
	["Who Are They?"] = "Wer sind sie?",
	["Wild Guardians"] = "Wilde Wächter",
	["Wild Hearts"] = "Wilde Herzen",
	["Wild Leather Armor"] = "Wildlederrüstung",
	["Wild Leather Boots"] = "Wildlederstiefel",
	["Wild Leather Helmet"] = "Wildlederhelm",
	["Wild Leather Leggings"] = "Wildledergamaschen",
	["Wild Leather Shoulders"] = "Wildlederschultern",
	["Wild Leather Vest"] = "Wildlederweste",
	["Wildeyes"] = "Wildaug",
	["Wildkin E'ko"] = "E'ko der Wildekin",
	["Wildkin of Elune"] = "Wildekin von Elune",
	["Wildmane Cleansing"] = "Wildmähnensäuberung",
	["Wildmane Totem"] = "Totem der Wildmähnen",
	["Williden's Journal"] = "Willidens Tagebuch",
	["Willix the Importer"] = "Willix der Importeur",
	["Wind Rider"] = "Windreiter",
	["Wind Trader Lathrai"] = "Windhändler Lathrai",
	["Windows to the Source"] = "Schlüssel zur Macht",
	["Windroc Mastery"] = "Beherrschen der Windrocjagd",
	["Windrunner Village"] = "Windläuferdorf",
	["Winds in the Desert"] = "Wind in der Wüste",
	["Wine Shop Advert"] = "Weinladen-Werbung",
	["Wing Commander Gryphongar"] = "Schwadronskommandant Greifgar",
	["Winter's Presents"] = "Winters Geschenke",
	["Winterfall Activity"] = "Aktivität der Winterfelle",
	["Winterfall E'ko"] = "E'ko der Winterfelle",
	["Winterfall Firewater"] = "Feuerwasser der Winterfelle",
	["Winterfall Intrusion"] = "Eindringlinge der Winterfelle",
	["Winterfall Ritual Totem"] = "Ritualtotem der Winterfelle",
	["Winterfall Runners"] = "Läufer der Winterfelle",
	["Winterhoof Cleansing"] = "Winterhufsäuberung",
	["Wisdom of Agamaggan"] = "Weisheit von Agammagan",
	["Witherbark Cages"] = "Käfige der Bleichborken",
	["Withered Basidium"] = "Siechendes Basidium",
	["Withered Flesh"] = "Siechendes Fleisch",
	["Wolves Across the Border"] = "Wölfe an der Grenze",
	["Wolves at Our Heels"] = "Wölfe auf den Fersen",
	["Woodpaw Investigation"] = "Waldpfotennachforschung",
	["Word from Azure Watch"] = "Nachricht von der Azurwacht",
	["Word from the Spire"] = "Nachricht vom Turm",
	["Words of the High Chief"] = "Worte des Oberhäuptlings",
	["Worgen in the Woods"] = "Worgs in den Wäldern",
	["Worth Its Weight in Gold"] = "Das Gewicht in Gold wert",
	["Wounded Ancients"] = "Verletzte Urtume",
	["Wrath of the Blue Flight"] = "Der Zorn des blauen Drachenschwarms",
	["Wrenix of Ratchet"] = "Wrenix aus Ratschet",
	["Wretched Ringleader"] = "Rädelsführer der Getriebenen",
	["Writ of Safe Passage"] = "Verfügung des freien Geleits",
	["Writhing Haunt Cauldron"] = "Der Kessel des trostlosen Felds",
	["Wyrmskull Watcher"] = "Behüter des Wyrmschädels",
	["Xorothian Stardust"] = "Xorothianischer Sternenstaub",
	["Xylem's Payment to Jediga"] = "Xylems Bezahlung für Jediga",
	["Yorus Barleybrew"] = "Yorus Gerstenbräu",
	["You Have Served Us Well"] = "Ihr habt uns gut gedient",
	["You Survived!"] = "Ihr habt überlebt!",
	["You Too Good."] = "Ihr zu gut",
	["You're Fired!"] = "Ihr seid gefeuert!",
	["You're Hired!"] = "Ihr seid eingestellt!",
	["You're a Mean One..."] = "So was Gemeines...",
	["Young Crocolisk Skins"] = "Häute junger Krokilisken",
	["Young Lovers"] = "Junge Liebende",
	["Your Fortune Awaits You..."] = "Euer Schicksal erwartet Euch...",
	["Your Place In The World"] = "Euer Platz in der Welt",
	["Ysera's Tears"] = "Yseras Tränen",
	["Yuka Screwspigot"] = "Yuka Schraubstutz",
	["Zaeldarr the Outcast"] = "Zaeldarr der Ausgestoßene",
	["Zalazane"] = "Zalazane",
	["Zamek's Distraction"] = "Zameks Ablenkungsmanöver",
	["Zandalarian Shadow Mastery Talisman"] = "Zandalarianischer Schattentalisman der Beherrschung",
	["Zando'zan"] = "Zando'zan",
	["Zanzil's Mixture and a Fool's Stout"] = "Zanzils Mixtur und Fools Starkbier",
	["Zanzil's Secret"] = "Zanzils Geheimnis",
	["Zapped Giants"] = "Geschrumpfte Riesen",
	["Zapper Fuel"] = "Schrumpftreibstoff",
	["Zenn's Bidding"] = "Zenns Aufträge",
	["Zeth'Gor Must Burn!"] = "Zeth'Gor muss brennen!",
	["Zinge's Delivery"] = "Zinges Lieferung",
	["Ziz Fizziks"] = "Ziz Fizziks",
	["Zombie Juice"] = "Zombiesaft",
	["Zukk'ash Infestation"] = "Zukk'ash-Plage",
	["Zukk'ash Report"] = "Bericht über die Zukk'ash",
	["Zul'Marosh"] = "Zul'Marosh",
	["Zuluhed the Whacked"] = "Zuluhed der Geschlagene",
	["\"Pretty Boy\" Duncan"] = "Schönling Duncan",
	["rAnS0m"] = "lÖsEGeLd",
} end)

BabbleQuest:RegisterTranslations("zhCN", function() return {
    -- Quest names (3808)
    -- Chinese Translation 月色狼影@CWDG
    -- CWDG site: http://Cwowaddon.com
		["... and Bugs"] = "还有螃蟹！",
		["... and a Batch of Ooze"] = "一大堆软泥怪",
		["...and a Time for Action"] = "...and a Time for Action",
		["10 Tickets - Last Month's Mutton"] = "10张奖券 - 上个月的羊肉",
		["12 Tickets - Lesser Darkmoon Prize"] = "12张奖券 - 普通奖品",
		["1200 Tickets - Amulet of the Darkmoon"] = "1200 Tickets - Amulet of the Darkmoon",
		["1200 Tickets - Orb of the Darkmoon"] = "1200张奖券 - 暗月宝珠",
		["40 Tickets - Greater Darkmoon Prize"] = "40张奖券 - 高级奖品",
		["40 Tickets - Schematic: Steam Tonk Controller"] = "40 Tickets - Schematic: Steam Tonk Controller",
		["5 Tickets - Darkmoon Flower"] = "5张奖券 - 暗月花束",
		["5 Tickets - Minor Darkmoon Prize"] = "5张奖券 - 小奖品",
		["50 Tickets - Darkmoon Storage Box"] = "50张奖券 - 暗月储物箱",
		["A Bad Egg"] = "坏掉的蛋",
		["A Baying of Gnolls"] = "豺狼人的乱吠",
		["A Better Ingredient"] = "更好的材料",
		["A Bijou for Zanza"] = "赞扎的宝石",
		["A Binding Contract"] = "瑟银兄弟会契约",
		["A Bird's-Eye View"] = "A Bird's-Eye View",
		["A Blue Light Bargain"] = "君王板甲的设计图",
		["A Boar's Vitality"] = "野猪的活力",
		["A Boaring Time for Grulloc"] = "A Boaring Time for Grulloc",
		["A Broken Trap"] = "破碎的陷阱",
		["A Bump in the Road"] = "安全隐患",
		["A Bundle of Hides"] = "一捆兽皮",
		["A Bundle of Trouble"] = "木材危机",
		["A Burden of Souls"] = "A Burden of Souls",
		["A Carefully Wrapped Present"] = "精心包裹的礼物",
		["A Cleansing Light"] = "A Cleansing Light",
		["A Collection of Heads"] = "祭司的头颅",
		["A Convincing Disguise"] = "A Convincing Disguise",
		["A Crew Under Fire"] = "危难中的船长",
		["A Crumpled Up Note"] = "弄皱的便笺",
		["A Cry For Help"] = "A Cry For Help",
		["A Cure for Zahlia"] = "A Cure for Zahlia",
		["A Curse Upon Both of Your Clans!"] = "A Curse Upon Both of Your Clans!",
		["A Dandy's Best Friend"] = "A Dandy's Best Friend",
		["A Dark Pact"] = "A Dark Pact",
		["A Dark Threat Looms"] = "水坝危机",
		["A Date with Dorgok"] = "A Date with Dorgok",
		["A Daughter's Love"] = "女儿的爱",
		["A Debilitating Sickness"] = "A Debilitating Sickness",
		["A Defector"] = "A Defector",
		["A Different Approach"] = "A Different Approach",
		["A Dip in the Moonwell"] = "A Dip in the Moonwell",
		["A Dire Situation"] = "A Dire Situation",
		["A Discreet Inquiry"] = "A Discreet Inquiry",
		["A Dwarf and His Tools"] = "矮人的工具",
		["A Fate Worse Than Death"] = "A Fate Worse Than Death",
		["A Favor for Evershine"] = "艾沃沙酒",
		["A Favorite Treat"] = "A Favorite Treat",
		["A Festive Gift"] = "节日礼物",
		["A Final Blow"] = "最终一击",
		["A Fine Egg"] = "优良的蛋",
		["A Fine Mess"] = "一团混乱",
		["A Fishy Peril"] = "鱼人的威胁",
		["A Fistful of Slivers"] = "奥术薄片",
		["A Free Lunch"] = "免费的午餐",
		["A Friend in Need"] = "需要帮助的朋友",
		["A Gaily Wrapped Present"] = "华丽的礼物",
		["A Gallon of Blood"] = "联盟之血",
		["A Gesture of Goodwill"] = "善意的表示",
		["A Ghost in the Machine"] = "A Ghost in the Machine",
		["A Gift for Voren'thal"] = "A Gift for Voren'thal",
		["A Gnome's Assistance"] = "侏儒的援助",
		["A Gnome's Respite"] = "侏儒学者",
		["A Good Friend"] = "好朋友",
		["A Good Head On Your Shoulders"] = "罩帽和护肩",
		["A Grave Situation"] = "寻找墓碑",
		["A Grim Discovery"] = "可怕的发现",
		["A Grim Task"] = "艰巨的任务",
		["A Grunt's Work..."] = "A Grunt's Work...",
		["A Handful of Magic Dust"] = "A Handful of Magic Dust",
		["A Hasty Departure"] = "A Hasty Departure",
		["A Haunted History"] = "A Haunted History",
		["A Head Full of Ivory"] = "A Head Full of Ivory",
		["A Heap of Ethereals"] = "A Heap of Ethereals",
		["A Helping Hand"] = "援助之手",
		["A Hero Is Needed"] = "A Hero Is Needed",
		["A Hero's Reward"] = "英雄的奖赏",
		["A Hero's Welcome"] = "羽月将军的欢迎",
		["A Host of Evil"] = "邪恶之地",
		["A Humble Offering"] = "谦卑的馈赠",
		["A Humble Task"] = "一件琐事",
		["A Hunter's Boast"] = "自豪的猎人",
		["A Hunter's Challenge"] = "猎人的挑战",
		["A Husband's Last Battle"] = "最后一战",
		["A Husband's Revenge"] = "丈夫的复仇",
		["A Job Undone"] = "A Job Undone",
		["A Job for an Intelligent Man"] = "A Job for an Intelligent Man",
		["A King's Tribute"] = "国王的礼物",
		["A Lack of Fear"] = "毫无畏惧",
		["A Land Filled with Hatred"] = "充满仇恨的土地",
		["A Lesson Learned"] = "A Lesson Learned",
		["A Letter Undelivered"] = "未寄出的信件",
		["A Lingering Suspicion"] = "A Lingering Suspicion",
		["A Little Dash of Seasoning"] = "A Little Dash of Seasoning",
		["A Little Help From My Friends"] = "朋友的帮助",
		["A Little Slime Goes a Long Way"] = "远方的软泥怪",
		["A Lost Master"] = "失踪的主人",
		["A Map to Where?"] = "A Map to Where?",
		["A Message to Telaar"] = "A Message to Telaar",
		["A Mysterious Portent"] = "A Mysterious Portent",
		["A Necessary Distraction"] = "A Necessary Distraction",
		["A New Cloak's Sheen"] = "新斗篷的光辉",
		["A New Ore Sample"] = "新的矿石样本",
		["A New Plague"] = "新的瘟疫",
		["A New Threat"] = "新的威胁",
		["A Noble Brew"] = "名酿",
		["A Not-So-Modest Proposal"] = "A Not-So-Modest Proposal",
		["A Pawn on the Eternal Board"] = "往日的回忆",
		["A Peon's Burden"] = "苦工的重担",
		["A Personal Favor"] = "A Personal Favor",
		["A Pilgrim's Plight"] = "A Pilgrim's Plight",
		["A Pilot's Revenge"] = "驾驶员的复仇",
		["A Plague Upon Thee"] = "瘟疫与你",
		["A Portable Power Source"] = "便携的能量源",
		["A Promising Start"] = "A Promising Start",
		["A Proper String"] = "合适的弓弦",
		["A Putrid Task"] = "腐烂的爪子",
		["A Question of Gluttony"] = "A Question of Gluttony",
		["A Rare Bean"] = "A Rare Bean",
		["A Recipe For Death"] = "致命的配方",
		["A Refugee's Quandary"] = "逃难者的困境",
		["A Reliquary of Purity"] = "净化之匣",
		["A Restorative Draught"] = "A Restorative Draught",
		["A Rogue's Deal"] = "盗贼的交易",
		["A Sacred Burial"] = "神圣的墓地",
		["A Scroll from Mauren"] = "马伦的卷轴",
		["A Secret Revealed"] = "A Secret Revealed",
		["A Shameful Waste"] = "可耻的浪费",
		["A Shifty Merchant"] = "小巧的商人",
		["A Short Incubation"] = "即将孵化",
		["A Shred of Hope"] = "一丝希望",
		["A Sign of Hope"] = "一线希望",
		["A Simple Request"] = "简单的要求",
		["A Simple Robe"] = "A Simple Robe",
		["A Small Start"] = "第三类接触",
		["A Solvent Spirit"] = "沃纳尔大师",
		["A Somber Task"] = "A Somber Task",
		["A Spirit Ally?"] = "A Spirit Ally?",
		["A Spirit Guide"] = "A Spirit Guide",
		["A Sticky Situation"] = "收集蜜糖",
		["A Strange Historian"] = "古怪的历史学家",
		["A Strange One"] = "奇怪的家伙",
		["A Strange Red Key"] = "奇怪的红钥匙",
		["A Strange Request"] = "奇怪的要求",
		["A Strange Weapon"] = "A Strange Weapon",
		["A Study in Power"] = "A Study in Power",
		["A Supernatural Device"] = "超自然的设备",
		["A Swift Message"] = "快递消息",
		["A Tale of Sorrow"] = "悲伤的故事",
		["A Task Unfinished"] = "未完的任务",
		["A Taste of Flame"] = "烈焰精华",
		["A Terrible Purpose"] = "摆脱困境",
		["A Threat Within"] = "身边的危机",
		["A Threat in Feralas"] = "菲拉斯的危机",
		["A Time for Negotiation..."] = "A Time for Negotiation...",
		["A Traitor Among Us"] = "A Traitor Among Us",
		["A Troubled Spirit"] = "困扰的灵魂",
		["A Troubling Breeze"] = "烦恼之风",
		["A Vengeful Fate"] = "奥尔德的报复",
		["A Visit With The Ancestors"] = "A Visit With The Ancestors",
		["A Visit With the Greatmother"] = "A Visit With the Greatmother",
		["A Visit to Gregan"] = "造访格雷甘",
		["A Warm Welcome"] = "A Warm Welcome",
		["A Warrior's Training"] = "战士的训练",
		["A Watchful Eye"] = "法师的眼线",
		["A Yeti of Your Own"] = "你自己的机械雪人",
		["Abandoned Hope"] = "被遗弃的希望",
		["Abandoned Investigations"] = "Abandoned Investigations",
		["Abjurist Belmara"] = "防御法师贝尔玛拉",
		["Above and Beyond"] = "超越",
		["Abyssal Contacts"] = "深渊联络",
		["Abyssal Crests"] = "深渊纹章",
		["Additional Materials"] = "Additional Materials",
		["Administering the Salve"] = "Administering the Salve",
		["After the Ambush"] = "恶战之后",
		["Again With the Zapped Giants"] = "更多被缩小的巨人！",
		["Against All Odds"] = "Against All Odds",
		["Against Lord Shalzaru"] = "击败沙尔扎鲁",
		["Against the Hatecrest"] = "憎世纳迦之战",
		["Against the Illidari"] = "Against the Illidari",
		["Against the Legion"] = "Against the Legion",
		["Agamaggan's Agility"] = "阿迦玛甘的敏捷",
		["Agamaggan's Strength"] = "阿迦玛甘的力量",
		["Agamand Heirlooms"] = "阿加曼德家传武器",
		["Agents of Destruction"] = "毁灭的使者",
		["Aggression"] = "侵略",
		["Agitated Spirits of Skysong"] = "Agitated Spirits of Skysong",
		["Agmond's Fate"] = "阿戈莫德的命运",
		["Aiding the Outrunners"] = "Aiding the Outrunners",
		["Ak'Zeloth"] = "雅克塞罗斯",
		["Akama"] = "阿卡玛",
		["Akama's Promise"] = "Akama's Promise",
		["Akiris by the Bundle"] = "一捆海蛇草",
		["Aldor No More"] = "Aldor No More",
		["Alien Ecology"] = "异型的生态",
		["Alien Egg"] = "异型卵",
		["Alien Predators"] = "Alien Predators",
		["Alien Spirits"] = "Alien Spirits",
		["All Along the Watchtowers"] = "标记哨塔",
		["All Clear!"] = "All Clear!",
		["All That Remains"] = "遗体",
		["Allegiance to Cenarion Circle"] = "塞纳里奥议会的盟友",
		["Allegiance to the Aldor"] = "Allegiance to the Aldor",
		["Allegiance to the Old Gods"] = "上古之神的仆从",
		["Allegiance to the Scryers"] = "Allegiance to the Scryers",
		["Alliance Relations"] = "联盟关系",
		["Alliance Trauma"] = "联盟医疗队",
		["Alpha Strike"] = "突然袭击",
		["Altered Beings"] = "变异的生物",
		["Alther's Mill"] = "奥瑟尔伐木场",
		["Altruis"] = "Altruis",
		["Amani Encroachment"] = "Amani Encroachment",
		["Amani Invasion"] = "Amani Invasion",
		["Ambermill Investigations"] = "调查安伯米尔",
		["Ammo for Rumbleshot"] = "海格纳的弹药",
		["Amongst the Ruins"] = "废墟之间",
		["Amulet of Secrets"] = "铁趾的护符",
		["An Aggressive Defense"] = "先发制人",
		["An Alternative Alternative"] = "备选方案的备选方案",
		["An Ambassador of Evil"] = "邪恶的使者",
		["An Ambitious Plan"] = "An Ambitious Plan",
		["An Apprentice's Enchantment"] = "学徒的魔法",
		["An Audacious Advance"] = "An Audacious Advance",
		["An Audience with the Prince"] = "An Audience with the Prince",
		["An Earnest Proposition"] = "热心的建议",
		["An Easy Pickup"] = "简单的接收任务",
		["An Extraordinary Egg"] = "特别的蛋",
		["An Imp's Request"] = "小鬼的要求",
		["An Improper Burial"] = "An Improper Burial",
		["An Introduction"] = "介绍",
		["An OOX of Your Own"] = "你自己的OOX",
		["An Old Colleague"] = "老同事",
		["An Old Gift"] = "An Old Gift",
		["An Old History Book"] = "一本破旧的历史书",
		["An Ordinary Egg"] = "普通的蛋",
		["An Orphan Looking For a Home"] = "领养孤儿",
		["An Unholy Alliance"] = "邪恶的盟友",
		["An Unnatural Drought"] = "An Unnatural Drought",
		["An Unseen Hand"] = "An Unseen Hand",
		["An Unusual Patron"] = "An Unusual Patron",
		["An Unwelcome Guest"] = "不速之客",
		["An Unwelcome Presence"] = "An Unwelcome Presence",
		["Anachronos"] = "阿纳克洛斯",
		["Ancient Sinew Wrapped Lamina"] = "龙筋箭袋",
		["Ancient Spirit"] = "远古之灵",
		["Andron's Payment to Jediga"] = "安德隆的报酬",
		["Angling to Beat the Competition"] = "Angling to Beat the Competition",
		["Ango'rosh Encroachment"] = "Ango'rosh Encroachment",
		["Animist's Caress"] = "灵魂的安抚",
		["Anok'suten"] = "阿诺克苏塔",
		["Another Heap of Ethereals"] = "Another Heap of Ethereals",
		["Another Message to the Wildhammer"] = "又一个给蛮锤部族的警告",
		["Another Power Source?"] = "另一个能量源？",
		["Ansirem's Key"] = "安斯雷姆的钥匙",
		["Answered Questions"] = "问题的答案",
		["Anthion's Old Friend"] = "安泰恩的老朋友",
		["Anthion's Parting Words"] = "告别安泰恩",
		["Anthion's Strange Request"] = "安泰恩的奇怪请求",
		["Apothecary Antonivich"] = "药剂师安东尼维奇",
		["Apothecary Zamah"] = "药剂师扎玛",
		["Apothecary Zelana"] = "药剂师塞兰娜",
		["Apprentice Angler"] = "钓鱼学徒",
		["Apprentice's Duties"] = "学徒的职责",
		["Aquatic Form"] = "水栖形态",
		["Aquementas"] = "亚奎门塔斯",
		["Ar'kelos the Guardian"] = "Ar'kelos the Guardian",
		["Arachnophobia"] = "贝瑟莱斯",
		["Araj's Scarab"] = "阿拉基的圣甲虫",
		["Arakkoa War Path"] = "Arakkoa War Path",
		["Arathor Basic Care Package"] = "阿拉索基本医疗包",
		["Arathor Standard Care Package"] = "阿拉索标准医疗包",
		["Arcane Feedback"] = "奥术回馈者",
		["Arcane Instability"] = "奥术增效",
		["Arcane Reavers"] = "Arcane Reavers",
		["Arcane Refreshment"] = "久违的法师",
		["Arcane Runes"] = "奥术符文",
		["Arcane Tomes"] = "Arcane Tomes",
		["Arcanite"] = "奥金锭",
		["Arconus the Insatiable"] = "贪婪者阿克努斯",
		["Arelion's Journal"] = "埃雷利恩的日记",
		["Arelion's Mistress"] = "Arelion's Mistress",
		["Arelion's Secret"] = "Arelion's Secret",
		["Arena Master"] = "竞技场高手饰物",
		["Arikara"] = "阿利卡拉",
		["Armaments for Deception"] = "Armaments for Deception",
		["Armed and Ready"] = "整装待发",
		["Armor Kits for the Field"] = "战场上的护甲片",
		["Armor Scraps"] = "护甲碎片",
		["Arms for the Field"] = "战场上的武器",
		["Army of the Black Dragon"] = "黑龙军团",
		["Arrival in Outland"] = "Arrival in Outland",
		["Arrows Are For Sissies"] = "胆小鬼才用弓箭！",
		["Artifacts of the Blacksilt"] = "Artifacts of the Blacksilt",
		["Arugal Must Die"] = "除掉阿鲁高",
		["Arugal's Folly"] = "阿鲁高的愚行",
		["Arzeth's Demise"] = "Arzeth's Demise",
		["As Water Cascades"] = "清洗水晶",
		["As the Crow Flies"] = "As the Crow Flies",
		["Ascension..."] = "晋升……",
		["Asghar's Totem"] = "Asghar's Totem",
		["Ashenvale Outrunners"] = "灰谷先驱者",
		["Assassin's Contract"] = "刺客的契约",
		["Assassination Plot"] = "暗杀计划",
		["Assault on Fenris Isle"] = "突袭芬里斯岛",
		["Assault on Zeb'Nowa"] = "Assault on Zeb'Nowa",
		["Assault on the Kolkar"] = "突袭科卡尔部族",
		["Assessing the Situation"] = "Assessing the Situation",
		["Assessing the Threat"] = "审时度势",
		["Assisting the Consortium"] = "Assisting the Consortium",
		["Astral Knot Garment"] = "Astral Knot Garment",
		["At War With The Scarlet Crusade"] = "与血色十字军的战争",
		["Attack on Camp Narache"] = "纳拉其营地的危机",
		["Attack on Firewing Point"] = "Attack on Firewing Point",
		["Attack on Zeb'Tela"] = "Attack on Zeb'Tela",
		["Attack on the Tower"] = "进攻高塔",
		["Auchindoun..."] = "Auchindoun...",
		["Audience with the Prophet"] = "Audience with the Prophet",
		["Auntie Marlene"] = "玛莱恩姑妈",
		["Aurel Goldleaf"] = "奥蕾尔·金叶",
		["Aurius' Reckoning"] = "奥里克斯的清算",
		["Avenge My Village"] = "为我的村庄复仇",
		["Avenger's Breastplate"] = "复仇者的胸甲",
		["Avenger's Crown"] = "复仇者的王冠",
		["Avenger's Greaves"] = "复仇者的胫甲",
		["Avenger's Legguards"] = "复仇者的护腿",
		["Avenger's Pauldrons"] = "复仇者的护肩",
		["Avenging the Fallen"] = "死者的复仇",
		["Avruu's Orb"] = "亚维鲁的宝珠",
		["Azsharite"] = "艾萨拉水晶",
		["Azure Templar"] = "碧蓝圣殿骑士",
		["Azuregos's Magical Ledger"] = "艾索雷葛斯的魔法账本",
		["B'naar Console Transcription"] = "布纳尔控制台拓文",
		["Back to Billy"] = "比利的馅饼",
		["Back to Booty Bay"] = "返回藏宝海湾",
		["Back to Darnassus"] = "返回达纳苏斯",
		["Back to Thunder Bluff"] = "返回雷霆崖",
		["Back to Uldaman"] = "回到奥达曼",
		["Back to the Beginning"] = "Back to the Beginning",
		["Back to the Chief!"] = "Back to the Chief!",
		["Bad Medicine"] = "库尔森的药物",
		["Badlands Reagent Run"] = "荒芜之地的材料",
		["Badlands Reagent Run II"] = "荒芜之地的材料 II",
		["Bailor's Ore Shipment"] = "白洛尔的矿石",
		["Balance Must Be Preserved"] = "Balance Must Be Preserved",
		["Band of Unending Life"] = "不灭生命之戒",
		["Band of Vaulted Secrets"] = "魔法秘密之戒",
		["Band of Veiled Shadows"] = "笼罩阴影之戒",
		["Bandits!"] = "强盗！",
		["Bane of the Illidari"] = "Bane of the Illidari",
		["Barbaric Battlements"] = "野人装甲",
		["Barbecued Buzzard Wings"] = "烧烤秃鹰翅膀",
		["Baron Aquanis"] = "阿奎尼斯男爵",
		["Baron Sablemane"] = "萨博迈恩男爵",
		["Baron Sablemane Has Requested Your Presence"] = "Baron Sablemane Has Requested Your Presence",
		["Baron Sablemane's Poison"] = "萨博迈恩男爵的毒药",
		["Baron's Demise"] = "男爵之死",
		["Barov Family Fortune"] = "巴罗夫家族的宝藏",
		["Bartleby the Drunk"] = "醉鬼巴特莱比",
		["Bartleby's Mug"] = "巴特莱比的酒杯",
		["Bartolo's Yeti Fur Cloak"] = "巴图罗的雪人毛皮披风",
		["Bashal'Aran"] = "巴莎兰",
		["Bathran's Hair"] = "巴斯兰的头发",
		["Battle of Hillsbrad"] = "希尔斯布莱德之战",
		["Battle of Warsong Gulch"] = "峡谷中的战斗",
		["Battle of the Crimson Watch"] = "Battle of the Crimson Watch",
		["Battle-Mage Dathric"] = "战斗法师达斯利克",
		["Beached Sea Creature"] = "搁浅的海洋生物",
		["Beached Sea Turtle"] = "搁浅的海龟",
		["Beads for Salfa"] = "给萨尔法的珠串",
		["Bearers of the Plague"] = "Bearers of the Plague",
		["Beast Training"] = "训练野兽",
		["Beasts of the Apocalypse!"] = "Beasts of the Apocalypse!",
		["Beat Bartleby"] = "击败巴特莱比",
		["Because Kilrath is a Coward"] = "Because Kilrath is a Coward",
		["Becoming a Mooncloth Tailor"] = "Becoming a Mooncloth Tailor",
		["Becoming a Parent"] = "为人父母",
		["Becoming a Shadoweave Tailor"] = "Becoming a Shadoweave Tailor",
		["Becoming a Spellfire Tailor"] = "Becoming a Spellfire Tailor",
		["Beer Basted Boar Ribs"] = "啤酒烤猪排",
		["Before Darkness Falls"] = "Before Darkness Falls",
		["Befouled by Satyr"] = "萨特的威胁",
		["Begin the Attack!"] = "Begin the Attack!",
		["Beginnings"] = "开端",
		["Behind Enemy Lines"] = "Behind Enemy Lines",
		["Behomat"] = "贝霍玛特",
		["Bell of Dethmoora"] = "达斯莫拉之铃",
		["Belt of Faith"] = "信仰腰带",
		["Beneath Thrallmar"] = "Beneath Thrallmar",
		["Beren's Peril"] = "博伦的巢穴",
		["Besieged!"] = "Besieged!",
		["Betina Bigglezink"] = "贝蒂娜·比格辛克",
		["Betrayal from Within"] = "内奸",
		["Betrayed"] = "叛徒",
		["Better Late Than Never"] = "迟到总比不到好",
		["Between a Rock and a Thistlefur"] = "蓟皮熊怪的麻烦",
		["Beware of Pterrordax"] = "当心翼手龙",
		["Big Black Mace"] = "巨型黑色锤",
		["Big Game Hunter"] = "王牌猎人",
		["Bijou's Belongings"] = "比修的装置",
		["Bijou's Reconnaissance Report"] = "比修的侦察报告",
		["Binding the Dreadnaught"] = "无畏护甲的材料",
		["Bindings of Faith"] = "信仰腕轮",
		["Bingles' Missing Supplies"] = "宾格斯的补给品",
		["Birds of a Feather"] = "Birds of a Feather",
		["Bitter Rivals"] = "针锋相对",
		["Blackfathom Villainy"] = "黑暗深渊中的邪恶",
		["Blackhand's Command"] = "黑手的命令",
		["Blackmoore's Legacy"] = "布莱克摩尔的余孽",
		["Blackrock Bounty"] = "悬赏：黑石氏族",
		["Blackrock Menace"] = "黑石氏族的威胁",
		["Blacksting's Bane"] = "Blacksting's Bane",
		["Blade of Eternal Justice"] = "永恒公正长剑",
		["Blade of Vaulted Secrets"] = "魔法秘密之刃",
		["Bladespire Kegger"] = "Bladespire Kegger",
		["Blast the Infernals!"] = "Blast the Infernals!",
		["Bleeding Hollow Supply Crates"] = "Bleeding Hollow Supply Crates",
		["Blessed Arcanite Barding"] = "被祝福的奥金马铠",
		["Blessed Arm"] = "格瑞曼德·艾尔默",
		["Blessing of Incineratus"] = "Blessing of Incineratus",
		["Blessings of the Ancients"] = "Blessings of the Ancients",
		["Blind Cazul"] = "盲眼卡祖尔",
		["Blisters on The Land"] = "大地上的脓疱",
		["Blood Crystals"] = "Blood Crystals",
		["Blood Elf Plans"] = "血精灵计划书",
		["Blood Elf Spy"] = "血精灵间谍",
		["Blood Feeders"] = "盗窃的蜘蛛",
		["Blood Shards of Agamaggan"] = "阿迦玛甘的血岩碎片",
		["Blood Tinged Skies"] = "血染的天空",
		["Blood Watch"] = "秘血岗哨",
		["Blood of the Black Dragon Champion"] = "黑龙勇士之血",
		["Bloodfury Bloodline"] = "血怒一族",
		["Bloodgem Crystals"] = "Bloodgem Crystals",
		["Bloodpetal Poison"] = "血瓣花毒药",
		["Bloodpetal Sprouts"] = "血瓣花苗",
		["Bloodpetal Zapper"] = "血瓣花除草器",
		["Bloodscalp Clan Heads"] = "血顶之颅",
		["Bloodscalp Ears"] = "血顶巨魔的耳朵",
		["Bloodscalp Insight"] = "血顶巨魔的魔法",
		["Bloody Bone Necklaces"] = "染血的白骨项链",
		["Bloody Imp-ossible!"] = "Bloody Imp-ossible!",
		["Blueleaf Tubers"] = "蓝叶薯",
		["Boat Wreckage"] = "船只的残骸",
		["Bodley's Unfortunate Fate"] = "伯德雷的不幸",
		["Body and Heart"] = "身心之力",
		["Body of Evidence"] = "Body of Evidence",
		["Bodyguard for Hire"] = "雇佣保镖",
		["Boiling Blood"] = "沸腾之血",
		["Bolstering Our Defenses"] = "加强防御",
		["Bone Collector"] = "集骨者",
		["Bone Fragments"] = "白骨碎片",
		["Bone-Bladed Weapons"] = "骨刃武器",
		["Bonechewer Blood"] = "噬骨之血",
		["Bonescythe Bracers"] = "骨镰护腕",
		["Bonescythe Breastplate"] = "骨镰胸甲",
		["Bonescythe Digs"] = "骨镰的材料",
		["Bonescythe Gauntlets"] = "骨镰护手",
		["Bonescythe Helmet"] = "骨镰头盔",
		["Bonescythe Legplates"] = "骨镰腿甲",
		["Bonescythe Pauldrons"] = "骨镰肩铠",
		["Bonescythe Sabatons"] = "骨镰马靴",
		["Bonescythe Waistguard"] = "骨镰护腰",
		["Book of the Ancients"] = "上古之书",
		["Bookie Herod"] = "书呆子赫罗德",
		["Booty Bay or Bust!"] = "藏宝海湾之旅！",
		["Bor Wishes to Speak"] = "与鲍尔谈话",
		["Border Crossings"] = "越境",
		["Botanical Legwork"] = "跑腿采花",
		["Botanist Taerix"] = "植物学家塔蕾克丝",
		["Boulderslide Ravine"] = "滚岩峡谷",
		["Bound for Glory"] = "Bound for Glory",
		["Bounty on Garrick Padfoot"] = "加瑞克·帕德弗特的赏金",
		["Bounty on Murlocs"] = "悬赏鱼人",
		["Bracers of Binding"] = "地缚护腕",
		["Brann Bronzebeard's Lost Letter"] = "布莱恩·铜须的信件",
		["Breaching the Path"] = "Breaching the Path",
		["Break Sharptusk!"] = "刺鬃酋长",
		["Break a Few Eggs"] = "恐龙蛋大餐",
		["Breaking Down Netherock"] = "Breaking Down Netherock",
		["Breaking the Code"] = "破译密码",
		["Breaking the Keystone"] = "打开钥匙之石",
		["Breaking the Ward"] = "破坏结界",
		["Breastplate of Bloodthirst"] = "嗜血胸甲",
		["Breastplate of the Chromatic Flight"] = "多彩巨龙胸甲",
		["Bride of the Embalmer"] = "藏尸者的妻子",
		["Bring Back the Mug"] = "归还酒杯",
		["Bring Down the Warbringer!"] = "Bring Down the Warbringer!",
		["Bring Me A Shrubbery!"] = "Bring Me A Shrubbery!",
		["Bring Me Another Shrubbery!"] = "Bring Me Another Shrubbery!",
		["Bring Me Kel'gash's Head!"] = "Bring Me Kel'gash's Head!",
		["Bring Me The Egg!"] = "Bring Me The Egg!",
		["Bring the End"] = "寒冰之王",
		["Bring the Light"] = "与圣光同在",
		["Broken Alliances"] = "破碎的联盟",
		["Broken Tears"] = "破碎之泪",
		["Broodling Essence"] = "雏龙精华",
		["Brother Against Brother"] = "Brother Against Brother",
		["Brother Anton"] = "安东修士",
		["Brother Carlin"] = "卡林·雷德帕斯",
		["Brother Paxton"] = "帕克斯顿修士",
		["Brotherhood of Thieves"] = "盗贼兄弟会",
		["Brotherhood's End"] = "兄弟会的灭亡",
		["Brotherly Love"] = "兄弟情深",
		["Brumeran of the Chillwind"] = "冰风奇美拉布鲁米兰",
		["Brutal Armor"] = "野蛮护甲",
		["Brutal Gauntlets"] = "野蛮护手",
		["Brutal Hauberk"] = "野蛮锁甲",
		["Brutal Helm"] = "野蛮头盔",
		["Brutal Legguards"] = "野蛮腿甲",
		["Brutal Politics"] = "野蛮外交",
		["Building a Perimeter"] = "Building a Perimeter",
		["Bungle in the Jungle"] = "擒虫先擒王",
		["Burn It Up... For the Horde!"] = "Burn It Up... For the Horde!",
		["Burning Blade Medallion"] = "火刃奖章",
		["Burning Blood"] = "燃烧之血",
		["Burning Shadows"] = "燃烧之影",
		["Buying Time"] = "Buying Time",
		["Buzzbox 323"] = "传声盒323号",
		["Buzzbox 411"] = "传声盒411号",
		["Buzzbox 525"] = "传声盒525号",
		["Buzzbox 827"] = "传声盒827号",
		["By Any Means Necessary"] = "By Any Means Necessary",
		["C'Thun's Legacy"] = "C'Thun's Legacy",
		["CLUCK!"] = "咕咕嘎！",
		["Cabal Orders"] = "秘教的命令",
		["Cache of Mau'ari"] = "玛艾里的容器",
		["Call of Air"] = "空气的召唤",
		["Call of Air - Guse's Fleet"] = "天空的召唤 - 古斯的部队",
		["Call of Air - Ichman's Fleet"] = "天空的召唤 - 艾克曼的空军",
		["Call of Air - Jeztor's Fleet"] = "天空的召唤 - 杰斯托的部队",
		["Call of Air - Mulverick's Fleet"] = "天空的召唤 - 穆维里克的部队",
		["Call of Air - Slidore's Fleet"] = "天空的召唤 - 斯里多尔的空军",
		["Call of Air - Vipore's Fleet"] = "天空的召唤 - 维波里的空军",
		["Call of Earth"] = "大地的召唤",
		["Call of Fire"] = "火焰的召唤",
		["Call of Water"] = "水之召唤",
		["Call to Arms"] = "短兵相接",
		["Calling in the Reserves"] = "召回卫兵",
		["Calm Before the Storm"] = "临危不惧",
		["Camp Mojache"] = "莫沙彻营地",
		["Can't Stay Away"] = "Can't Stay Away",
		["Candles of Beckoning"] = "诱灵蜡烛",
		["Cannibalistic Cousins"] = "野蛮的亲戚",
		["Cannons of Rage"] = "Cannons of Rage",
		["Cape of Eternal Justice"] = "永恒公正斗篷",
		["Captain Kelisendra's Lost Rutters"] = "凯莉森德拉船长的航海图",
		["Captain Sander's Hidden Treasure"] = "杉德尔船长的宝藏",
		["Captain Tyralius"] = "泰拉留斯上尉",
		["Captain Vimes"] = "维米斯队长",
		["Captives at Deatholme"] = "Captives at Deatholme",
		["Capture a Mine"] = "占领矿洞",
		["Capture the Weapons"] = "Capture the Weapons",
		["Capturing the Keystone"] = "Capturing the Keystone",
		["Capturing the Phylactery"] = "Capturing the Phylactery",
		["Carendin Summons"] = "Carendin Summons",
		["Carnival Boots"] = "Carnival Boots",
		["Carnival Jerkins"] = "Carnival Jerkins",
		["Carrion Grubbage"] = "腐肉虫",
		["Carry Your Weight"] = "新的背包",
		["Castpipe's Task"] = "卡斯派普的任务",
		["Catalogue of the Wayward"] = "游荡者目录",
		["Catch and Release"] = "Catch and Release",
		["Catch of the Day"] = "食鱼度日",
		["Caught!"] = "被锁起来的矮人",
		["Cave Mushrooms"] = "洞中的蘑菇",
		["Celebrating Good Times"] = "英雄庆典",
		["Celestial Power"] = "苍穹之力",
		["Cenarion Aid"] = "塞纳里奥议会的求助",
		["Cenarion Battlegear"] = "塞纳里奥的装备",
		["Cenarius' Legacy"] = "塞纳留斯的遗产",
		["Centaur Bounty"] = "悬赏半人马",
		["Centaur Bracers"] = "半人马护腕",
		["Challenge Overlord Mok'Morokk"] = "挑战莫格穆洛克",
		["Champion's Battlegear"] = "勇士的装备",
		["Chapter I"] = "荆棘谷的青山 - 第一章",
		["Chapter II"] = "荆棘谷的青山 - 第二章",
		["Chapter III"] = "荆棘谷的青山 - 第三章",
		["Chapter IV"] = "荆棘谷的青山 - 第四章",
		["Chasing A-Me 01"] = "找回A-Me 01",
		["Chen's Empty Keg"] = "老陈的空酒桶",
		["Chicken Clucking for a Mint"] = "学小鸡，换糖果",
		["Chief Engineer Scooty"] = "主工程师斯库提",
		["Chieftain Oomooroo"] = "欧莫鲁酋长",
		["Children's Week"] = "儿童周",
		["Chillwind Horns"] = "冰风奇美拉角",
		["Chimaeric Horn"] = "奇美拉之角",
		["Cho'war the Pillager"] = "掠夺者考瓦尔",
		["Chromatic Mantle of the Dawn"] = "多彩黎明衬肩",
		["Circlet of Faith"] = "信仰头环",
		["City of Light"] = "City of Light",
		["Claim Rackmore's Treasure!"] = "拉克摩尔的财宝！",
		["Claiming the Light"] = "Claiming the Light",
		["Clam Bait"] = "蚌肉鱼饵",
		["Clamlette Surprise"] = "蚌肉大餐",
		["Claws from the Deep"] = "海中的鱼人",
		["Cleaning up the Grounds"] = "Cleaning up the Grounds",
		["Cleansed Water Returns to Felwood"] = "净化过的水",
		["Cleansing Felwood"] = "净化费伍德",
		["Cleansing of the Infected"] = "清除疫病",
		["Cleansing of the Orb of Orahil"] = "奥拉赫宝珠的净化",
		["Cleansing the Eye"] = "净化帕雷斯之眼",
		["Cleansing the Scar"] = "Cleansing the Scar",
		["Cleansing the Waters"] = "Cleansing the Waters",
		["Clearing the Way"] = "Clearing the Way",
		["Clefthoof Mastery"] = "Clefthoof Mastery",
		["Cloak of Unending Life"] = "不灭生命披风",
		["Cloak of Veiled Shadows"] = "笼罩阴影披风",
		["Cloak of the Gathering Storm"] = "聚集风暴披风",
		["Cloak of the Unseen Path"] = "隐秘通途披风",
		["Cloth and Leather Armor"] = "布甲和皮甲",
		["Clues in the Thicket"] = "Clues in the Thicket",
		["Coarse Weightstone"] = "粗制平衡石",
		["Codex of Defense"] = "防御宝典",
		["Cohlien Frostweaver"] = "考利恩·霜纹",
		["Coilfang Armaments"] = "盘牙武器",
		["Coldridge Valley Mail Delivery"] = "寒脊山谷的送信任务",
		["Coldtooth Supplies"] = "冷齿补给品",
		["Collecting Kelp"] = "收集海藻",
		["Collecting Memories"] = "收集记忆",
		["Collection of Goods"] = "收集材料",
		["Collection of the Corrupt Water"] = "收集堕落之水",
		["Colonel Kurzen"] = "库尔森上校",
		["Colossal Menace"] = "Colossal Menace",
		["Combining Forces"] = "Combining Forces",
		["Coming of Age"] = "成年",
		["Commander Gor'shak"] = "指挥官哥沙克",
		["Compendium of the Fallen"] = "堕落者纲要",
		["Completing the Delivery"] = "Completing the Delivery",
		["Components for the Enchanted Gold Bloodrobe"] = "魔化金线血袍",
		["Components of Importance"] = "重要的材料",
		["Concerns About Tuurem"] = "Concerns About Tuurem",
		["Concerted Efforts"] = "共同的努力",
		["Confront Yeh'kinya"] = "面对叶基亚",
		["Conjurer Luminrath"] = "咒术师鲁米拉斯",
		["Conqueror's Breastplate"] = "征服者的胸甲",
		["Conqueror's Crown"] = "征服者的皇冠",
		["Conqueror's Greaves"] = "征服者的胫甲",
		["Conqueror's Legguards"] = "征服者的腿铠",
		["Conqueror's Spaulders"] = "征服者的肩铠",
		["Conscript of the Horde"] = "部落的新兵",
		["Consecrated Letter"] = "圣洁信件",
		["Consecrated Rune"] = "神圣符文",
		["Consortium Crystal Collection"] = "Consortium Crystal Collection",
		["Constrictor Vines"] = "Constrictor Vines",
		["Consult Master Gadrin"] = "请教加德林大师",
		["Consumed by Hatred"] = "复仇的怒火",
		["Contact from Dalaran"] = "Contact from Dalaran",
		["Containing the Threat"] = "Containing the Threat",
		["Continue to Stormwind"] = "赶赴暴风城",
		["Continued Threat"] = "海中的威胁",
		["Control"] = "Control",
		["Control Four Bases"] = "控制四座基地",
		["Cookie's Jumbo Gumbo"] = "曲奇的大餐",
		["Coolant Heads Prevail"] = "至关重要的冷却剂",
		["Copper Modulator"] = "铜质调节器",
		["Core of Elements"] = "元素之核",
		["Corki's Gone Missing Again!"] = "Corki's Gone Missing Again!",
		["Corki's Ransom"] = "Corki's Ransom",
		["Corrupted Soil"] = "Corrupted Soil",
		["Corruption"] = "腐蚀术",
		["Corruption of Earth and Seed"] = "大地的污染",
		["Cortello's Riddle"] = "科泰罗的谜题",
		["Costly Menace"] = "损失惨重",
		["Counterattack!"] = "人马无双！",
		["Counting Out Time"] = "找回时间",
		["Courser Antlers"] = "苔蹄快步者的鹿角",
		["Covert Ops - Alpha"] = "隐秘行动：A",
		["Covert Ops - Beta"] = "隐秘行动：B",
		["Coyote Thieves"] = "捕猎山狗",
		["Crackin' Some Skulls"] = "Crackin' Some Skulls",
		["Cracking Maury's Foot"] = "玛雷的腿",
		["Craftsman's Writ - Brightcloth Pants"] = "工匠文书 - 亮布短裤",
		["Craftsman's Writ - Dense Weightstone"] = "工匠文书 - 致密平衡石",
		["Craftsman's Writ - Goblin Sapper Charge"] = "工匠文书 - 地精工兵炸药",
		["Craftsman's Writ - Greater Arcane Protection Potion"] = "工匠文书 - 强效奥术防护药水",
		["Craftsman's Writ - Huge Thorium Battleaxe"] = "工匠文书 - 巨型瑟银战斧",
		["Craftsman's Writ - Major Healing Potion"] = "工匠文书 - 特效治疗药水",
		["Craftsman's Writ - Major Mana Potion"] = "工匠文书 - 特效法力药水",
		["Craftsman's Writ - Plated Armorfish"] = "工匠文书 - 板鳞鱼",
		["Craftsman's Writ - Runecloth Bag"] = "工匠文书 - 符文布包",
		["Craftsman's Writ - Runecloth Boots"] = "工匠文书 - 符文布靴",
		["Craftsman's Writ - Runecloth Robe"] = "工匠文书 - 符文布袍",
		["Craftsman's Writ - Runic Leather Pants"] = "工匠文书 - 符文皮甲短裤",
		["Craftsman's Writ - Stonescale Eel"] = "工匠文书 - 石鳞鳗",
		["Craftsman's Writ - Thorium Grenade"] = "工匠文书 - 瑟银手榴弹",
		["Craftsman's Writ - Thorium Tube"] = "工匠文书 - 瑟银管",
		["Craftsman's Writ - Wicked Leather Headband"] = "工匠文书 - 邪恶皮甲头环",
		["Crashing the Wickerman Festival"] = "稻草人的节日",
		["Creating the Pendant"] = "Creating the Pendant",
		["Creature of the Void"] = "虚空中的生物",
		["Creatures of the Eco-Domes"] = "Creatures of the Eco-Domes",
		["Crime and Punishment"] = "罪与罚",
		["Crimson Crystal Clue"] = "Crimson Crystal Clue",
		["Crimson Templar"] = "赤红圣殿骑士",
		["Critters of the Void"] = "Critters of the Void",
		["Crocolisk Boy and the Bearded Murloc"] = "Crocolisk Boy and the Bearded Murloc",
		["Crocolisk Hunting"] = "捕猎鳄鱼",
		["Crossroads Conscription"] = "十字路口征兵",
		["Crown of the Earth"] = "大地之冠",
		["Cruel Taskmasters"] = "Cruel Taskmasters",
		["Cruel's Intentions"] = "Cruel's Intentions",
		["Cruelfin's Necklace"] = "Cruelfin's Necklace",
		["Crush the Bloodmaul Camp"] = "Crush the Bloodmaul Camp",
		["Crush the Bloodmaul Camp!"] = "Crush the Bloodmaul Camp!",
		["Crushridge Bounty"] = "破碎岭食人魔",
		["Crushridge Warmongers"] = "破碎岭好战者",
		["Cry of the Thunderhawk"] = "雷鹰的嘶鸣",
		["Crypt Fiend Parts"] = "地穴魔的碎片",
		["Cryptstalker Armor Doesn't Make Itself..."] = "地穴追猎者护甲的材料……",
		["Cryptstalker Boots"] = "地穴追猎者长靴",
		["Cryptstalker Girdle"] = "地穴追猎者束带",
		["Cryptstalker Handguards"] = "地穴追猎者护手",
		["Cryptstalker Headpiece"] = "地穴追猎者头饰",
		["Cryptstalker Tunic"] = "地穴追猎者外套",
		["Cryptstalker Wristguards"] = "地穴追猎者护腕",
		["Crystal Charge"] = "爆炸水晶",
		["Crystal Clear"] = "Crystal Clear",
		["Crystal Cluster"] = "水晶簇",
		["Crystal Force"] = "精神水晶",
		["Crystal Restore"] = "恢复水晶",
		["Crystal Spire"] = "尖刺水晶",
		["Crystal Ward"] = "防御水晶",
		["Crystal Yield"] = "破甲水晶",
		["Crystals of Power"] = "能量水晶",
		["Cuergo's Gold"] = "科尔戈的黄金",
		["Culinary Crunch"] = "Culinary Crunch",
		["Culling the Flutterers"] = "Culling the Flutterers",
		["Culling the Threat"] = "解除威胁",
		["Culling the Wild"] = "Culling the Wild",
		["Curbing the Plague"] = "Curbing the Plague",
		["Curing the Sick"] = "消除疾病",
		["Curse These Fat Fingers"] = "该死的手指头！",
		["Curse of the Violet Tower"] = "紫罗兰塔的诅咒",
		["Cursed Talismans"] = "Cursed Talismans",
		["Cutting Teeth"] = "小试身手",
		["Cutting Your Teeth"] = "Cutting Your Teeth",
		["Cutting a Path"] = "Cutting a Path",
		["Cycle of Rebirth"] = "生生不息",
		["Cyclonian"] = "塞克隆尼亚",
		["Da Voodoo"] = "巫毒羽毛",
		["Dadanga is Hungry!"] = "达丹加饿了！",
		["Daelin's Men"] = "戴林的下属",
		["Dagger of Veiled Shadows"] = "笼罩阴影匕首",
		["Daggerfen Deviance"] = "Daggerfen Deviance",
		["Daily Delivery"] = "日常供货",
		["Dalar's Analysis"] = "达拉尔的推理",
		["Dalaran Patrols"] = "达拉然巡逻队",
		["Dalaran's Intentions"] = "达拉然的意图",
		["Dalson's Tears Cauldron"] = "达尔松之泪的瘟疫之锅",
		["Damaged Mask"] = "损坏的面具",
		["Damning Evidence"] = "Damning Evidence",
		["Dancing for Marzipan"] = "跳跳舞，换糖果",
		["Dangerous!"] = "危险！",
		["Dangers of the Windfury"] = "风怒鹰身人",
		["Dar'Khan's Lieutenants"] = "Dar'Khan's Lieutenants",
		["Dark Council"] = "黑暗议会",
		["Dark Heart"] = "黑暗之心",
		["Dark Iron Legacy"] = "黑铁的遗产",
		["Dark Iron Scraps"] = "黑铁碎片",
		["Dark Storms"] = "黑暗风暴",
		["Dark Tidings"] = "Dark Tidings",
		["Dark Vessels"] = "黑暗之瓶",
		["Darkmoon Beast Deck"] = "暗月野兽套牌",
		["Darkmoon Elementals Deck"] = "暗月元素套牌",
		["Darkmoon Portals Deck"] = "暗月入口套牌",
		["Darkmoon Warlords Deck"] = "暗月督军套牌",
		["Darnassian Intrusions"] = "达纳苏斯的侵扰",
		["Data Rescue"] = "抢救数据",
		["Dawn's Gambit"] = "黎明先锋",
		["Deactivate An'owyn"] = "Deactivate An'owyn",
		["Deactivating the Spire"] = "Deactivating the Spire",
		["Dead Man's Plea"] = "死人的请求",
		["Dead-tooth Jack"] = "蛀牙杰克",
		["Deadly Desert Venom"] = "沙漠中的剧毒",
		["Deadly Predators"] = "Deadly Predators",
		["Deadmire"] = "死沼巨鳄",
		["Deadwood of the North"] = "北方的死木熊怪",
		["Deal With the Saboteurs"] = "Deal With the Saboteurs",
		["Dealing with Zeb'Sora"] = "Dealing with Zeb'Sora",
		["Dealing with the Foreman"] = "Dealing with the Foreman",
		["Dealing with the Overmaster"] = "Dealing with the Overmaster",
		["Dearest Natalia"] = "亲爱的纳塔莉亚",
		["Death From Below"] = "水下伏兵",
		["Death's Door"] = "死亡之门",
		["Death's Embrace"] = "死亡的拥抱",
		["Deathdealer's Boots"] = "死亡执行者的长靴",
		["Deathdealer's Helm"] = "死亡执行者的头盔",
		["Deathdealer's Vest"] = "死亡执行者的胸甲",
		["Deaths in the Family"] = "阿加曼德家族",
		["Deathstalkers in Shadowfang"] = "影牙城堡里的亡灵哨兵",
		["Deceive thy Enemy"] = "Deceive thy Enemy",
		["Decipher the Tome"] = "Decipher the Tome",
		["Deciphering the Book"] = "Deciphering the Book",
		["Declaration of Power"] = "Declaration of Power",
		["Decoy!"] = "螳螂捕蝉！",
		["Deep Cover"] = "卧底密探",
		["Deep Sea Salvage"] = "深海打捞",
		["Deepmoss Spider Eggs"] = "深苔蜘蛛的卵",
		["Deeprun Rat Roundup"] = "捕捉矿道老鼠",
		["Defeat Nek'rosh"] = "击败纳克罗什",
		["Defenders of Darrowshire"] = "达隆郡的保卫者",
		["Defending Fairbreeze Village"] = "Defending Fairbreeze Village",
		["Defiler's Basic Care Package"] = "污染者基本医疗包",
		["Defiler's Standard Care Package"] = "污染者的标准医疗包",
		["Defiling Uther's Tomb"] = "Defiling Uther's Tomb",
		["Deliver Them From Evil..."] = "邪恶的书信",
		["Deliver Thomas' Report"] = "托马斯的报告",
		["Deliver the Gems"] = "Deliver the Gems",
		["Deliver the Plans to An'telas"] = "Deliver the Plans to An'telas",
		["Deliver the Shipment"] = "运送货物",
		["Deliver the Thread"] = "幽灵的发丝",
		["Deliver to MacKinley"] = "给马克基雷的货物",
		["Deliveries to Sven"] = "斯温的货物",
		["Delivering Daffodils"] = "水仙诉衷情",
		["Delivering the Message"] = "Delivering the Message",
		["Delivering the Relic"] = "递送遗物",
		["Delivery for Marin"] = "给马林的粉末",
		["Delivery to Andron Gant"] = "安德隆·甘特的石版",
		["Delivery to Archmage Xylem"] = "大法师克希雷姆的石版",
		["Delivery to Jes'rimon"] = "杰斯雷蒙的石版",
		["Delivery to Magatha"] = "玛加萨的石版",
		["Delivery to Ridgewell"] = "瑞治维尔的箱子",
		["Delivery to Silverpine Forest"] = "给银松森林送信",
		["Delivery to Tranquillien"] = "Delivery to Tranquillien",
		["Delivery to the Gnomes"] = "侏儒的货物",
		["Delivery to the North Sanctum"] = "送往北部圣殿的信",
		["Delivery to the Sepulcher"] = "Delivery to the Sepulcher",
		["Demon Dogs"] = "恶魔之犬",
		["Demonic Contamination"] = "Demonic Contamination",
		["Demonic Crystal Prisons"] = "Demonic Crystal Prisons",
		["Desert Recipe"] = "沙漠食谱",
		["Desperate Prayer"] = "绝望祷言",
		["Destiny Calls"] = "命运的召唤",
		["Destroy Morphaz"] = "毁灭摩弗拉斯",
		["Destroy Naberius!"] = "Destroy Naberius!",
		["Destroy the Legion"] = "毁灭燃烧军团",
		["Deviate Eradication"] = "清除变异者",
		["Deviate Hides"] = "变异皮革",
		["Devils in Westfall"] = "西部荒野中的恶魔",
		["Devourer of Souls"] = "噬魂者",
		["Devouring Plague"] = "噬灵瘟疫",
		["Diabolical Plans"] = "恶魔的计划",
		["Diagnosis: Critical"] = "Diagnosis: Critical",
		["Diaphanous Wings"] = "Diaphanous Wings",
		["Did You Get The Note?"] = "Did You Get The Note?",
		["Did You Lose This?"] = "秘银会的认可",
		["Dig Rat Stew"] = "掘地鼠炖肉",
		["Digging Through Bones"] = "Digging Through Bones",
		["Digging Through the Dirt"] = "掘墓",
		["Digging Through the Ooze"] = "搜寻软泥怪",
		["Digging for Prayer Beads"] = "Digging for Prayer Beads",
		["Dimensius the All-Devouring"] = "诸界吞噬者迪门修斯",
		["Diplomatic Measures"] = "Diplomatic Measures",
		["Dirge's Kickin' Chimaerok Chops"] = "迪尔格的超美味奇美拉肉片",
		["Discover Rolf's Fate"] = "罗尔夫的下落",
		["Disharmony of Fire"] = "不和谐的火焰",
		["Disharmony of Flame"] = "不和谐的烈焰",
		["Dispelling Evil"] = "驱散邪恶",
		["Disrupt Their Reinforcements"] = "Disrupt Their Reinforcements",
		["Disrupt the Attacks"] = "野猪人的袭击",
		["Disruption - Forge Camp: Mageddon"] = "Disruption - Forge Camp: Mageddon",
		["Distracting Jarven"] = "加文的爱好",
		["Distraction at Manaforge B'naar"] = "Distraction at Manaforge B'naar",
		["Disturbance at Umbrafen Lake"] = "Disturbance at Umbrafen Lake",
		["Divination: Gorefiend's Armor"] = "Divination: Gorefiend's Armor",
		["Divination: Gorefiend's Cloak"] = "Divination: Gorefiend's Cloak",
		["Divination: Gorefiend's Truncheon"] = "Divination: Gorefiend's Truncheon",
		["Divine Retribution"] = "神圣的惩戒",
		["Divino-matic Rod"] = "探水棒",
		["Do My Eyes Deceive Me"] = "Do My Eyes Deceive Me",
		["Dogran's Captivity"] = "多格兰之囚",
		["Dolanaar Delivery"] = "多兰纳尔的货物",
		["Doling Justice"] = "菲拉斯的正义",
		["Don't Drink the Water"] = "Don't Drink the Water",
		["Don't Kill the Fat One"] = "Don't Kill the Fat One",
		["Doom Weed"] = "末日草",
		["Doomcaller's Circlet"] = "厄运召唤者的头饰",
		["Doomcaller's Footwraps"] = "厄运召唤者的裹足",
		["Doomcaller's Mantle"] = "厄运召唤者的衬肩",
		["Doomrigger's Clasp"] = "末日扣环",
		["Doomsday Candle"] = "末日蜡烛",
		["Doorway to the Abyss"] = "Doorway to the Abyss",
		["Doras the Wind Rider Master"] = "双足飞龙管理员多拉斯",
		["Dousing the Flames of Protection"] = "熄灭火焰",
		["Down With Daellis"] = "Down With Daellis",
		["Down at the Docks"] = "降帆靠港",
		["Down the Coast"] = "清理海岸",
		["Down the Dead Scar"] = "Down the Dead Scar",
		["Down the Scarlet Path"] = "血色之路",
		["Dr. Boom!"] = "合成法师装备1！",
		["Draconic for Dummies"] = "龙语傻瓜教程",
		["Draenethyst Crystals"] = "德莱尼水晶",
		["Dragonkin Menace"] = "黑龙的威胁",
		["Dragonmaw Shinbones"] = "龙喉胫骨",
		["Dragonscale Leatherworking"] = "龙鳞制皮",
		["Drain Schematics"] = "抽水泵结构图",
		["Drakefire Amulet"] = "龙火护符",
		["Drape of Unyielding Strength"] = "坚定力量披风",
		["Drape of Vaulted Secrets"] = "魔法秘密披风",
		["Dreadmaul Rock"] = "巨槌石",
		["Dreadnaught Bracers"] = "无畏护腕",
		["Dreadnaught Breastplate"] = "无畏胸甲",
		["Dreadnaught Gauntlets"] = "无畏手套",
		["Dreadnaught Helmet"] = "无畏头盔",
		["Dreadnaught Legplates"] = "无畏腿铠",
		["Dreadnaught Pauldrons"] = "无畏肩铠",
		["Dreadnaught Sabatons"] = "无畏马靴",
		["Dreadnaught Waistguard"] = "无畏腰带",
		["Dreadsteed of Xoroth"] = "克索诺斯恐惧战马",
		["Dream Dust in the Swamp"] = "梦境之尘",
		["Dreamwalker Boots"] = "梦游者长靴",
		["Dreamwalker Girdle"] = "梦游者束带",
		["Dreamwalker Handguards"] = "梦游者护手",
		["Dreamwalker Headpiece"] = "梦游者头饰",
		["Dreamwalker Legguards"] = "梦游者护腿",
		["Dreamwalker Spaulders"] = "梦游者肩饰",
		["Dreamwalker Tunic"] = "梦游者外套",
		["Dreamwalker Wristguards"] = "梦游者腕甲",
		["Dressing the Part"] = "Dressing the Part",
		["Driftwood"] = "晒干的流木",
		["Drijya Needs Your Help"] = "Drijya Needs Your Help",
		["Drill the Drillmaster"] = "Drill the Drillmaster",
		["Drowned Sorrows"] = "船长的复仇",
		["Druid of the Claw"] = "利爪德鲁伊",
		["Dry Times"] = "旱季",
		["Duke Nicholas Zverenhoff"] = "尼古拉斯·瑟伦霍夫公爵",
		["Dumphry's Request"] = "Dumphry's Request",
		["Dungar Longdrink"] = "杜加尔·朗德瑞克",
		["Dusky Crab Cakes"] = "黑蟹蛋糕",
		["Dust from the Drakes"] = "Dust from the Drakes",
		["Dwarven Digging"] = "矮人的挖掘场",
		["Dwarven Justice"] = "矮人的正义",
		["Dwarven Outfitters"] = "矮人的交易",
		["Eagan Peltskinner"] = "伊根·派特斯金纳",
		["Earthen Arise"] = "土灵的觉醒",
		["Earthen Templar"] = "土色圣殿骑士",
		["Earthshatter Boots"] = "碎地者长靴",
		["Easy Strider Living"] = "炖陆行鸟",
		["Eating Damnation"] = "Eating Damnation",
		["Echeyakee"] = "埃其亚基",
		["Echoes of War"] = "战争的回响",
		["Egg Collection"] = "收集龙蛋",
		["Egg Freezing"] = "冷冻龙蛋",
		["Egg Hunt"] = "蝎卵",
		["Eight-Legged Menaces"] = "蜘蛛的威胁",
		["Eitrigg's Wisdom"] = "伊崔格的智慧",
		["Elanaria"] = "艾兰娜瑞",
		["Electro-Shock Goodness!"] = "电磁冲击！",
		["Electropellers"] = "导电器",
		["Elekks Are Serious Business"] = "雷象可不是好玩的！",
		["Elemental Bracers"] = "元素护腕",
		["Elemental Leatherworking"] = "元素制皮",
		["Elemental Power Extraction"] = "Elemental Power Extraction",
		["Elemental War"] = "元素战争",
		["Elixir of Agony"] = "苦楚药剂",
		["Elixir of Pain"] = "痛苦药剂",
		["Elixir of Suffering"] = "受难药剂",
		["Elixirs for the Bladeleafs"] = "刃叶的药剂",
		["Elmore's Task"] = "艾尔默的任务",
		["Elune's Tear"] = "月神之泪",
		["Elven Legends"] = "精灵的传说",
		["Emberstrife"] = "埃博斯塔夫",
		["Emphasis on Sacrifice"] = "牺牲精神",
		["Empty Stables"] = "补充坐骑",
		["En-Ay-Es-Tee-Why"] = "蜘蛛卵",
		["Enchanted Azsharite Fel Weaponry"] = "魔化艾萨拉水晶武器",
		["Enchanted Thorium Platemail: Volume I"] = "魔化瑟银板甲：第一卷",
		["Enchanted Thorium Platemail: Volume II"] = "魔化瑟银板甲：第二卷",
		["Enchanted Thorium Platemail: Volume III"] = "Enchanted Thorium Platemail: Volume III",
		["Encoded Fragments"] = "密文碎片",
		["Encroaching Gnolls"] = "豺狼人的入侵",
		["Encroaching Wildlife"] = "逼近的野兽",
		["Encroachment"] = "野猪人的进犯",
		["Encrusted Tail Fins"] = "坚硬的尾鳍",
		["Encrypted Letter"] = "密文信件",
		["Encrypted Memorandum"] = "密文备忘录",
		["Encrypted Parchment"] = "密文羊皮纸",
		["Encrypted Rune"] = "密文符文",
		["Encrypted Scroll"] = "密文卷轴",
		["Encrypted Sigil"] = "密文符记",
		["Encrypted Tablet"] = "密文石板",
		["Encrypted Twilight Texts"] = "暮光密文信",
		["Ending Their World"] = "Ending Their World",
		["Ending the Bloodcurse"] = "Ending the Bloodcurse",
		["Enemy Booty"] = "敌人的物资",
		["Enemy of my Enemy..."] = "Enemy of my Enemy...",
		["Enigma Boots"] = "神秘长靴",
		["Enigma Circlet"] = "神秘头饰",
		["Enigma Shoulderpads"] = "神秘肩垫",
		["Enraged Spirits"] = "怒灵",
		["Enraged Spirits of Air"] = "Enraged Spirits of Air",
		["Enraged Spirits of Fire and Earth"] = "Enraged Spirits of Fire and Earth",
		["Enraged Spirits of Water"] = "Enraged Spirits of Water",
		["Enraged Thunder Lizards"] = "被激怒的雷霆蜥蜴",
		["Enraged Wildkin"] = "被激怒的枭兽",
		["Enticing Negolash"] = "引诱奈古拉什",
		["Entry Into Karazhan"] = "Entry Into Karazhan",
		["Entry Into the Citadel"] = "Entry Into the Citadel",
		["Envoy to the Mag'har"] = "Envoy to the Mag'har",
		["Epic Armaments of Battle - Exalted Amongst the Dawn"] = "史诗级的作战装备 - 银色黎明崇拜",
		["Eradicate the Burning Legion"] = "Eradicate the Burning Legion",
		["Erion Shadewhisper"] = "艾瑞安·影语",
		["Erion's Behest"] = "艾瑞安的命令",
		["Errand for Apothecary Zinge"] = "金格的货物",
		["Escape Through Force"] = "杀出重围",
		["Escape Through Stealth"] = "Escape Through Stealth",
		["Escape from Durnholde"] = "Escape from Durnholde",
		["Escape from Firewing Point!"] = "Escape from Firewing Point!",
		["Escape from Umbrafen"] = "Escape from Umbrafen",
		["Escape from the Catacombs"] = "Escape from the Catacombs",
		["Escape from the Staging Grounds"] = "Escape from the Staging Grounds",
		["Escaping the Tomb"] = "Escaping the Tomb",
		["Escorting Erland"] = "护送埃兰德",
		["Essence for the Engines"] = "Essence for the Engines",
		["Essence of the Exile"] = "流放精华",
		["Essential Artificials"] = "基础模组",
		["Establishing New Outposts"] = "建立新据点",
		["Etched Note"] = "风化便笺",
		["Etched Parchment"] = "风蚀羊皮纸",
		["Etched Rune"] = "风蚀符文",
		["Etched Sigil"] = "风化符记",
		["Etched Tablet"] = "风蚀石板",
		["Ethereum Data"] = "Ethereum Data",
		["Evershine"] = "艾沃沙酒",
		["Everything Counts In Large Amounts"] = "多多益善",
		["Everything Will Be Alright"] = "Everything Will Be Alright",
		["Evil Bat Eyes"] = "邪恶的蝙蝠眼",
		["Evil Draws Near"] = "Evil Draws Near",
		["Examine the Vessel"] = "Examine the Vessel",
		["Excavation Progress Report"] = "挖掘进度报告",
		["Excelsior"] = "刨花皮靴",
		["Exorcising Terrordale"] = "恐惧谷的灵魂",
		["Exorcising the Trees"] = "Exorcising the Trees",
		["Expedition Point"] = "远征军岗哨",
		["Expedition Salvation"] = "抢救物资",
		["Expert Blacksmith!"] = "Expert Blacksmith!",
		["Extinguish the Firegut"] = "消灭火腹食人魔",
		["Extinguishing the Idol"] = "封印神像",
		["Eye of the Emberseer"] = "艾博希尔之眼",
		["Ezekiel"] = "伊瑟基尔",
		["FIFTY! YEP!"] = "五十个！",
		["Faerie Dragon Muisek"] = "精灵龙灵魂精华",
		["Failed Incursion"] = "Failed Incursion",
		["Fairbreeze Village"] = "晴风村",
		["Falcon Watch"] = "猎鹰岗哨",
		["Falcon's Call"] = "猎鹰的召唤",
		["Fall From Grace"] = "失落的荣耀",
		["Fall of Dun Modr"] = "丹莫德的陷落",
		["Fallen Sky Lake"] = "坠星湖",
		["Fallen Sky Lords"] = "被捕的空军指挥官",
		["Falling to Corruption"] = "堕落熊怪",
		["Falrin's Vendetta"] = "法尔林的复仇",
		["Familiar Fungi"] = "Familiar Fungi",
		["Family Tree"] = "兄弟",
		["Farren's Proof"] = "法尔林的证据",
		["Farstrider Retreat"] = "远行者居所",
		["Favor of the Gronn"] = "Favor of the Gronn",
		["Favored of Elune?"] = "月神之兽？",
		["Feast at the Blue Recluse"] = "Feast at the Blue Recluse",
		["Featherbeard's Endorsement"] = "羽须的认可",
		["Feathermoon Stronghold"] = "羽月要塞",
		["Feathers for Grazle"] = "给格拉兹的羽毛",
		["Feathers for Nafien"] = "给纳菲恩的羽毛",
		["Fei Fei's Treat"] = "Fei Fei's Treat",
		["Fel Armaments"] = "Fel Armaments",
		["Fel Embers"] = "Fel Embers",
		["Fel Orc Plans"] = "邪兽人的计划",
		["Fel Orc Scavengers"] = "Fel Orc Scavengers",
		["Fel Spirits"] = "Fel Spirits",
		["Felbound Ancients"] = "被禁锢的古树",
		["Felendren the Banished"] = "放逐者菲伦德雷",
		["Felling an Ancient Tree"] = "Felling an Ancient Tree",
		["Felnok Steelspring"] = "菲诺克",
		["Felspark Ravine"] = "魔火峡谷",
		["Felstone Field Cauldron"] = "费尔斯通农场的瘟疫之锅",
		["Felsworn Gas Mask"] = "魔誓防毒面具",
		["Fenwick Thatros"] = "芬维克·萨托斯",
		["Feralas: A History"] = "菲拉斯的历史",
		["Ferocitas the Dream Eater"] = "噬梦者菲罗斯塔",
		["Fertile Spores"] = "成熟的孢子",
		["Fetch!"] = "接着！",
		["Field Duty"] = "战地任务",
		["Fields of Grief"] = "悲伤之地",
		["Fierce Enemies"] = "Fierce Enemies",
		["Fiery Blaze Enchantments"] = "黑龙之火",
		["Fiery Menace!"] = "熔岩蜘蛛的威胁！",
		["Fiery Plate Gauntlets"] = "炽热板甲护手",
		["Filling the Soul Gem"] = "Filling the Soul Gem",
		["Filthy Paws"] = "肮脏的爪子",
		["Final Passage"] = "通过试炼",
		["Final Preparations"] = "最后的准备",
		["Find Acteon!"] = "找到艾克提恩！",
		["Find Agmond"] = "寻找阿戈莫德",
		["Find Bingles"] = "寻找宾格斯",
		["Find Keltus Darkleaf"] = "Find Keltus Darkleaf",
		["Find Myranda"] = "寻找麦兰达",
		["Find OOX-09/HL!"] = "找到OOX-09/HL！",
		["Find OOX-17/TN!"] = "寻找OOX-17/TN！",
		["Find OOX-22/FE!"] = "寻找OOX-22/FE！",
		["Find Ranshalla"] = "兰莎尔拉",
		["Find Spy To'gun"] = "Find Spy To'gun",
		["Find the Deserter"] = "Find the Deserter",
		["Find the Gems"] = "寻找宝石",
		["Find the Gems and Power Source"] = "寻找宝贝",
		["Find the Lost Guards"] = "失踪的卫兵",
		["Find the Shattered Hand"] = "寻找碎手氏族",
		["Finding the Antidote"] = "寻找解毒剂",
		["Finding the Keymaster"] = "Finding the Keymaster",
		["Finding the Shadowy Figure"] = "搜寻乌鸦岭",
		["Finding the Source"] = "究根问底",
		["Finding the Survivors"] = "Finding the Survivors",
		["Fine Gold Thread"] = "优质金线",
		["Fiora Longears"] = "菲欧拉·长耳",
		["Fire At Will!"] = "Fire At Will!",
		["Fire Hardened Mail"] = "弗伦的铠甲",
		["Fire Plume Forged"] = "火羽山",
		["Fire Sapta"] = "火焰灵契",
		["Fire Taboo"] = "火焰管制",
		["Firewing Signets"] = "Firewing Signets",
		["Fish in a Bucket"] = "坐享其成",
		["Flash Bomb Recipe"] = "闪光弹的制法",
		["Flawed Power Stone"] = "有瑕疵的能量石",
		["Flawless Fel Essence"] = "无暇的恶魔精华",
		["Flexing for Nougat"] = "显肌肉，换糖果",
		["Flight to Auberdine"] = "飞往奥伯丁",
		["Flint Shadowmore"] = "弗林特·沙多摩尔",
		["Flora of the Eco-Domes"] = "Flora of the Eco-Domes",
		["Flute of Xavaric"] = "萨瓦里克长笛",
		["Fly to Silvermoon City"] = "Fly to Silvermoon City",
		["Follow the Breadcrumbs"] = "Follow the Breadcrumbs",
		["Food for Baby"] = "小精龙的食物",
		["Footwraps of the Oracle"] = "神谕者的裹足",
		["For All To See"] = "万众敬仰",
		["For Great Honor"] = "无上的荣耀",
		["For Love Eternal"] = "永志不渝",
		["For The Horde!"] = "为部落而战！",
		["For the Fallen"] = "For the Fallen",
		["Forbidden Knowledge"] = "禁断的知识",
		["Force Commander Danath"] = "Force Commander Danath",
		["Forces of Jaedenar"] = "加德纳尔的势力",
		["Foreboding Plans"] = "预备行动计划",
		["Forge Camp: Annihilated"] = "Forge Camp: Annihilated",
		["Forge Camp: Mageddon"] = "铸魔营地：暴虐",
		["Forged Steel"] = "锻造好的钢锭",
		["Forging the Mightstone"] = "铸造力量之石",
		["Forging the Shaft"] = "铸造火炬杆",
		["Forging the Weapon"] = "Forging the Weapon",
		["Forgotten Rituals"] = "Forgotten Rituals",
		["Formal Introductions"] = "Formal Introductions",
		["Foror's Compendium"] = "Foror's Compendium",
		["Forsaken Aid"] = "被遗忘者的援助",
		["Forsaken Diseases"] = "被遗忘者的病菌",
		["Forsaken Duties"] = "亡灵卫兵的职责",
		["Forward Base: Reaver's Fall"] = "Forward Base: Reaver's Fall",
		["Foul Magics"] = "邪恶的魔法",
		["Fouled Water Spirits"] = "Fouled Water Spirits",
		["Fragmented Magic"] = "魔法的碎片",
		["Fragments of the Orb of Orahil"] = "宝珠碎片",
		["Fragments of the Past"] = "历史的残片",
		["Frame of Atiesh"] = "埃提耶什的杖柄",
		["Free From the Hold"] = "逃离监牢",
		["Free at Last"] = "终获自由",
		["Freed from the Hive"] = "逃离虫巢",
		["Freedom for All Creatures"] = "精灵龙的自由",
		["Freedom to Ruul"] = "鲁尔的自由",
		["Fresh Meat"] = "新鲜的螃蟹腿",
		["Fresh from the Mechanar"] = "Fresh from the Mechanar",
		["From The Wreckage...."] = "海底沉船",
		["From the Abyss"] = "From the Abyss",
		["From the Ashes"] = "From the Ashes",
		["Frostfire Belt"] = "霜火腰带",
		["Frostfire Bindings"] = "霜火腕轮",
		["Frostfire Circlet"] = "霜火头饰",
		["Frostfire Gloves"] = "霜火手套",
		["Frostfire Leggings"] = "霜火护腿",
		["Frostfire Robe"] = "霜火长袍",
		["Frostfire Sandals"] = "霜火便鞋",
		["Frostfire Shoulderpads"] = "霜火肩垫",
		["Frostmane Hold"] = "霜鬃巨魔要塞",
		["Frostmaul E'ko"] = "霜槌魂精",
		["Frostmaw"] = "霜喉雪人",
		["Frostsaber E'ko"] = "霜刃魂精",
		["Frostsaber Provisions"] = "霜刃豹的食物",
		["Fruit of the Sea"] = "海中的水果",
		["Fuel for the Zapping"] = "压缩器的动力",
		["Fulgor Spores"] = "Fulgor Spores",
		["Full Triangle"] = "Full Triangle",
		["Fumping"] = "击鼓",
		["Fungal Spores"] = "菌类孢子",
		["Furlbrow's Deed"] = "法布隆的地契",
		["Further Concerns"] = "卫兵托马斯",
		["Further Corruption"] = "更深重的堕落",
		["Further Instructions"] = "新的指示",
		["Further Mysteries"] = "更大的谜团",
		["Gadgetzan Water Survey"] = "加基森水业公司",
		["Gaffer Jacks"] = "小齿轮",
		["Gahrron's Withering Cauldron"] = "盖罗恩农场的瘟疫之锅",
		["Gahz'ridian"] = "加兹瑞迪安",
		["Gahz'rilla"] = "加兹瑞拉",
		["Gaining Acceptance"] = "获得信任",
		["Gaining Access"] = "Gaining Access",
		["Gaining Mirren's Trust"] = "Gaining Mirren's Trust",
		["Gakin's Summons"] = "加科因的召唤",
		["Galaen's Fate"] = "Galaen's Fate",
		["Galaen's Journal - The Fate of Vindicator Saruan"] = "Galaen's Journal - The Fate of Vindicator Saruan",
		["Galen's Escape"] = "加林的逃亡",
		["Galgar's Cactus Apple Surprise"] = "戈加尔的清凉果",
		["Galvan's Finest Pupil"] = "Galvan's Finest Pupil",
		["Gan'rul's Summons"] = "甘鲁尔的召唤",
		["Gann's Reclamation"] = "加恩的报复",
		["Garments of Spirituality"] = "灵魂之衣",
		["Garments of the Light"] = "圣光之衣",
		["Garments of the Moon"] = "Garments of the Moon",
		["Garona: A Study on Stealth and Treachery"] = "迦罗娜：潜行与诡计研究",
		["Gateway to the Frontier"] = "前线之门",
		["Gather Rot Blossoms"] = "收集腐败之花",
		["Gather the Orbs"] = "Gather the Orbs",
		["Gathering Idols"] = "收集石像",
		["Gathering Leather"] = "收集皮革",
		["Gathering Materials"] = "收集原料",
		["Gathering the Cure"] = "收集解药",
		["Gathering the Reagents"] = "Gathering the Reagents",
		["Gauging the Resonant Frequency"] = "Gauging the Resonant Frequency",
		["Gava'xi"] = "加瓦克希",
		["Gavel of Infinite Wisdom"] = "无尽智慧之锤",
		["Gearing Redridge"] = "赤脊山的补给",
		["Gelkis Alliance"] = "吉尔吉斯部族",
		["General Drakkisath's Command"] = "达基萨斯将军的命令",
		["General Drakkisath's Demise"] = "达基萨斯将军之死",
		["Genesis Boots"] = "起源长靴",
		["Genesis Helm"] = "起源头盔",
		["Genesis Shoulderpads"] = "起源护肩",
		["Genesis Trousers"] = "起源长裤",
		["Genesis Vest"] = "起源外套",
		["Gerenzo Wrenchwhistle"] = "格雷苏",
		["Gerenzo's Orders"] = "格雷苏的要求",
		["Get Me Out of Here!"] = "救我出去！",
		["Get the Gnomes Drunk"] = "灌醉侏儒",
		["Get the Goblins Drunk"] = "灌醉地精",
		["Get the Scoop"] = "解封咒语",
		["Getting Down to Business"] = "Getting Down to Business",
		["Getting the Bladespire Tanked"] = "Getting the Bladespire Tanked",
		["Ghost Hair Thread"] = "幽灵的发丝",
		["Ghost-o-plasm Round Up"] = "幽灵电浆",
		["Ghoulish Effigy"] = "食尸鬼假人",
		["Give Gerard a Drink"] = "葛拉德的饮料",
		["Gizelton Caravan"] = "基泽尔顿车队",
		["Gizmo for Warug"] = "瓦鲁格的玩具",
		["Glowcap Mushrooms"] = "Glowcap Mushrooms",
		["Glowing Scorpid Blood"] = "发光的蝎血",
		["Glyphed Oaken Branch"] = "雕文橡木枝",
		["Glyphic Letter"] = "雕文信件",
		["Glyphic Memorandum"] = "雕文备忘录",
		["Glyphic Scroll"] = "雕文卷轴",
		["Glyphic Tablet"] = "雕文石板",
		["Gnarlpine Corruption"] = "瘤背熊怪的堕落",
		["Gnogaine"] = "诺恩",
		["Gnome Engineering"] = "侏儒工程学",
		["Gnome Improvement"] = "侏儒的手艺",
		["Gnomer-gooooone!"] = "出发！诺莫瑞根！",
		["Go to the Front"] = "Go to the Front",
		["Goblin Invaders"] = "地精侵略者",
		["Goblin Sponsorship"] = "地精赞助商",
		["Gol'dir"] = "高迪尔",
		["Gold Dust Exchange"] = "金砂交易",
		["Goldenmist Village"] = "金雾村",
		["Goldleaf's Discovery"] = "金叶的发现",
		["Goldtooth"] = "金牙",
		["Good Luck Charm"] = "好运护符",
		["Good Natured Emma"] = "善良的艾玛",
		["Goods from Silvermoon City"] = "Goods from Silvermoon City",
		["Gor'tesh the Brute Lord"] = "蛮王戈泰什",
		["Gordo's Task"] = "葛尔多的任务",
		["Gordunni Cobalt"] = "戈杜尼钴矿石",
		["Goretusk Liver Pie"] = "猪肝馅饼",
		["Gorgrom the Dragon-Eater"] = "食龙者高格鲁姆",
		["Grand Master Dumphry"] = "Grand Master Dumphry",
		["Grand Master Rohok"] = "Grand Master Rohok",
		["Grape Manifest"] = "葡萄出货单",
		["Grark Lorkrub"] = "格拉克·洛克鲁布",
		["Graverobbers"] = "盗墓贼",
		["Greatfather Winter is Here!"] = "冬天爷爷来了！",
		["Greed"] = "Greed",
		["Green Fireworks"] = "Green Fireworks",
		["Green Iron Bracers"] = "绿铁护腕",
		["Grey Iron Weapons"] = "灰铁武器",
		["Grillok \"Darkeye\""] = "Grillok \"Darkeye\"",
		["Grim Message"] = "可怕的消息",
		["Grimand Elmore"] = "格瑞曼德·艾尔默",
		["Grimand's Armor"] = "Grimand's Armor",
		["Grimand's Finest Work"] = "艾尔默的手艺",
		["Grime-Encrusted Ring"] = "脏兮兮的戒指",
		["Grimscale Pirates!"] = "Grimscale Pirates!",
		["Grimtotem Spying"] = "恐怖图腾的密信",
		["Grove of the Ancients"] = "古树之林",
		["Gryphon Master Talonaxe"] = "狮鹫管理员沙拉克·鹰斧",
		["Gryth Thurden"] = "格莱斯·瑟登",
		["Guarded Thunderbrew Barrel"] = "戒备森严",
		["Guardians of the Altar"] = "祭坛守护者",
		["Guarding Secrets"] = "守护秘密",
		["Guile of the Raptor"] = "迅猛龙的狡诈",
		["Gurf's Dignity"] = "古尔弗的尊严",
		["Gurok the Usurper"] = "侵占者古罗克",
		["Gyro... What?"] = "发条式什么什么仪",
		["Gyrodrillmatic Excavationators"] = "陀螺式挖掘机",
		["Gyromast's Retrieval"] = "基尔卡克的钥匙",
		["Gyromast's Revenge"] = "基尔卡克的报复",
		["HELP!"] = "HELP!",
		["Halgar's Summons"] = "哈加尔的召唤",
		["Hallow's End Treats for Jesper!"] = "Hallow's End Treats for Jesper!",
		["Hallow's End Treats for Spoops!"] = "斯波普斯的万圣节糖果！",
		["Hallowed Letter"] = "神圣信件",
		["Hallowed Rune"] = "神圣符文",
		["Hallowed Scroll"] = "神圣卷轴",
		["Hallowed Sigil"] = "神圣符记",
		["Hallowed Tablet"] = "神圣石板",
		["Hameya's Plea"] = "哈米亚的请求",
		["Hammerfall"] = "落锤镇",
		["Hamuul Runetotem"] = "哈缪尔·符文图腾",
		["Hand of Iruxos"] = "伊鲁克斯之手",
		["Handle With Care"] = "小心运送",
		["Hands of the Enemy"] = "敌人之手",
		["Harbinger of Doom"] = "末日先驱",
		["Harbingers of Shadowmoon"] = "Harbingers of Shadowmoon",
		["Hardened Shells"] = "硬化龟壳",
		["Harlan Needs a Resupply"] = "哈兰需要供货",
		["Harnessing Shadows"] = "束缚之影",
		["Harpies Threaten"] = "鹰身人的威胁",
		["Harpy Lieutenants"] = "鹰身人首领",
		["Harpy Raiders"] = "鹰身强盗",
		["Harvesting the Fel Ammunition"] = "Harvesting the Fel Ammunition",
		["Have You Ever Seen One of These?"] = "Have You Ever Seen One of These?",
		["Haze of Evil"] = "邪恶之雾",
		["He Called Himself Altruis..."] = "He Called Himself Altruis...",
		["Healing the Lake"] = "净化湖水",
		["Healthy Dragon Scale"] = "健康的龙鳞",
		["Heart of Rage"] = "Heart of Rage",
		["Hearts of Zeal"] = "狂热之心",
		["Hearts of the Pure"] = "纯洁者之心",
		["Heartswood"] = "同心树",
		["Heavy Grinding Stone"] = "重砂轮",
		["Heirloom Weapon"] = "祖传武器",
		["Helcular's Revenge"] = "赫尔库拉的复仇",
		["Hellfire Fortifications"] = "Hellfire Fortifications",
		["Help Mama Wheeler"] = "Help Mama Wheeler",
		["Help Ranger Valanna!"] = "Help Ranger Valanna!",
		["Help Tavara"] = "Help Tavara",
		["Help Watcher Biggs"] = "帮助卫兵比格斯",
		["Helping the Cenarion Post"] = "Helping the Cenarion Post",
		["Helping the Lost Find Their Way"] = "Helping the Lost Find Their Way",
		["Hemet Nesingwary Jr."] = "赫米特·奈辛瓦里二世",
		["Hero of the Brood"] = "Hero of the Brood",
		["Hero of the Mag'har"] = "Hero of the Mag'har",
		["Hero of the Sin'dorei"] = "Hero of the Sin'dorei",
		["Hero of the Stormpike"] = "雷矛英雄",
		["Heroes of Darrowshire"] = "达隆郡的英雄",
		["Heroes of Old"] = "古代英雄",
		["Hex of Weakness"] = "虚弱妖术",
		["Hezrul Bloodmark"] = "赫兹鲁尔·血印",
		["Hidden Enemies"] = "隐藏的敌人",
		["Hidden Secrets"] = "隐藏的秘密",
		["Hidden Treasures"] = "隐藏的宝藏",
		["High Chief Winterfall"] = "冬泉酋长",
		["High Sorcerer Andromath"] = "高阶巫师安多玛斯",
		["High Value Targets"] = "High Value Targets",
		["Highperch Venom"] = "风巢双足飞龙的毒囊",
		["Hilary's Necklace"] = "希拉里的项链",
		["Hinott's Assistance"] = "希诺特的帮助",
		["Hints of a New Plague?"] = "新的瘟疫？",
		["Hints of the Past"] = "Hints of the Past",
		["Hippogryph Master Stephanos"] = "Hippogryph Master Stephanos",
		["Hippogryph Muisek"] = "角鹰兽灵魂精华",
		["Hitting the Motherlode"] = "Hitting the Motherlode",
		["Hive'Ashi Scout Report"] = "亚什虫巢侦查报告",
		["Hive'Regal Scout Report"] = "雷戈虫巢侦查报告",
		["Hive'Zora Scout Report"] = "佐拉虫巢侦查报告",
		["Hoary Templar"] = "苍白圣殿骑士",
		["Holy Bologna: What the Light Won't Tell You"] = "光明不会告诉你的事情",
		["Homeward Bound"] = "回家",
		["Honor Students"] = "荣誉学员",
		["Honor the Dead"] = "逝者的荣耀",
		["Honor the Fallen"] = "Honor the Fallen",
		["Honored Amongst the Clan"] = "氏族的尊敬",
		["Honored Amongst the Guard"] = "卫兵的尊敬",
		["Honoring a Hero"] = "缅怀英雄",
		["Hoodoo Hex"] = "不祥的妖术",
		["Horde Presence"] = "部落的示威",
		["Horde Trauma"] = "部落医疗队",
		["Horns of Frenzy"] = "疯狂之角",
		["Host of the Hidden City"] = "Host of the Hidden City",
		["Hostile Takeover"] = "恶性竞争",
		["Hot Fiery Death"] = "Hot Fiery Death",
		["Hotter than Hell"] = "Hotter than Hell",
		["Houses of the Holy"] = "神圣之屋",
		["How Big a Threat?"] = "熊怪的威胁",
		["How to Break Into the Arcatraz"] = "如何杀入禁魔监狱",
		["Howling in the Hills"] = "群山中的嚎叫",
		["Humbert's Sword"] = "亨伯特的长剑",
		["Humble Beginnings"] = "童年的记忆",
		["Hungry!"] = "饿！",
		["Hunt for Yenniku"] = "耶尼库的下落",
		["Hunt the Savages"] = "野蛮的枭兽",
		["Hunting for Ectoplasm"] = "猎取灵质",
		["Hunting in Stranglethorn"] = "荆棘谷狩猎",
		["Hurley Blackbreath"] = "霍尔雷·黑须",
		["Hypercapacitor Gizmo"] = "超适应齿轮",
		["I Got Nothin' Left!"] = "青出于蓝！",
		["I Know A Guy..."] = "我认识一个家伙…",
		["I Must Have Them!"] = "I Must Have Them!",
		["I See Alcaz Island In Your Future..."] = "奥卡兹岛在你前方……",
		["I See Dead Draenei"] = "I See Dead Draenei",
		["I Shoot Magic Into the Darkness"] = "I Shoot Magic Into the Darkness",
		["I Was A Lot Of Things..."] = "I Was A Lot Of Things...",
		["I Work... For the Horde!"] = "I Work... For the Horde!",
		["I'm Saved!"] = "I'm Saved!",
		["I've Got a Plant"] = "天才的方案！",
		["Ice Thistle E'ko"] = "冰草魂精",
		["Identify Plant Parts"] = "Identify Plant Parts",
		["Identifying the Brood"] = "群龙之首",
		["Idols of the Feralfen"] = "Idols of the Feralfen",
		["Ignition"] = "打火钥匙",
		["Ill Omens"] = "Ill Omens",
		["Illidan's Pupil"] = "Illidan's Pupil",
		["Illidari-Bane Shard"] = "伊利达雷斩除碎片",
		["Imbuing the Headpiece"] = "Imbuing the Headpiece",
		["Impending Attack"] = "Impending Attack",
		["Imperial Plate Armor"] = "Imperial Plate Armor",
		["Imperial Plate Belt"] = "君王板甲腰带",
		["Imperial Plate Boots"] = "君王板甲战靴",
		["Imperial Plate Bracer"] = "君王板甲护腕",
		["Imperial Plate Chest"] = "君王板甲护胸",
		["Imperial Plate Helm"] = "君王板甲头盔",
		["Imperial Plate Leggings"] = "君王板甲护腿",
		["Imperial Plate Shoulders"] = "君王板甲护肩",
		["Imperial Qiraji Regalia"] = "其拉帝王徽记",
		["Improved Quality"] = "更高的品质",
		["In A Scrap With The Legion"] = "In A Scrap With The Legion",
		["In Defense of Frostwolf"] = "保卫霜狼氏族",
		["In Defense of the King's Lands"] = "保卫国王的领土",
		["In Dreams"] = "在梦中",
		["In Eranikus' Own Words"] = "帮助伊兰尼库斯",
		["In Favor of Elune"] = "月神的恩赐",
		["In Favor of Spirituality"] = "部族的传统",
		["In Favor of the Light"] = "圣光的恩赐",
		["In Good Hands"] = "In Good Hands",
		["In Good Taste"] = "好味道",
		["In Need of Felblood"] = "In Need of Felblood",
		["In Nightmares"] = "在噩梦中",
		["In Pursuit of Featherbeard"] = "追踪羽须",
		["In Search of Anthion"] = "寻找安泰恩",
		["In Search of Farahlite"] = "寻找法兰石",
		["In Search of Galvan"] = "寻找加尔文",
		["In Search of Knowledge"] = "寻找知识",
		["In Search of Menara Voidrender"] = "寻找梅纳拉·沃伦德",
		["In Search of Sedai"] = "In Search of Sedai",
		["In Search of Thaelrid"] = "寻找塞尔瑞德",
		["In Search of The Excavation Team"] = "寻找挖掘队",
		["In Search of The Temple"] = "调查神庙",
		["In the Name of the Light"] = "以圣光之名",
		["Incendius!"] = "伊森迪奥斯！",
		["Incendosaurs? Whateverosaur is More Like It"] = "熏火龙",
		["Incoming Gumdrop"] = "学火车，换糖果",
		["Incriminating Documents"] = "秘密文件",
		["Indispensable Tools"] = "Indispensable Tools",
		["Indurium"] = "精铁碎片",
		["Indurium Ore"] = "精铁矿石",
		["Ineptitude + Chemicals = Fun"] = "失职+药剂=快乐",
		["Inert Scourgestones"] = "惰性天灾石",
		["Infallible Mind"] = "坚定信念",
		["Infiltrating Dragonmaw Fortress"] = "Infiltrating Dragonmaw Fortress",
		["Infiltrating the Castle"] = "潜入城堡",
		["Infiltration"] = "秘密潜入",
		["Inform Leoroxx!"] = "Inform Leoroxx!",
		["Information Gathering"] = "Information Gathering",
		["Ink Supplies"] = "墨水短缺",
		["Inoculation"] = "疫苗",
		["Inquire at the Inn"] = "调查旅店",
		["Insane Druids"] = "疯狂的德鲁伊",
		["Insect Part Analysis"] = "昆虫研究",
		["Intercepting the Message"] = "Intercepting the Message",
		["Into Occupied Territory"] = "Into Occupied Territory",
		["Into The Maw of Madness"] = "深入疯狂之口",
		["Into The Scarlet Monastery"] = "深入血色修道院",
		["Into The Temple of Atal'Hakkar"] = "进入阿塔哈卡神庙",
		["Into the Breach"] = "勇往直前",
		["Into the Churning Gulch"] = "Into the Churning Gulch",
		["Into the Depths"] = "深入神庙",
		["Into the Draenethyst Mine"] = "Into the Draenethyst Mine",
		["Into the Dream"] = "Into the Dream",
		["Into the Field"] = "进入沙漠",
		["Into the Heart of the Labyrinth"] = "Into the Heart of the Labyrinth",
		["Invaders of Alterac Valley"] = "奥特兰克的入侵者",
		["Invaluable Asset Zapping"] = "Invaluable Asset Zapping",
		["Invasion Point: Annihilator"] = "登陆场：歼灭",
		["Invasion Point: Cataclysm"] = "登陆场：灾难",
		["Investigate An'daroth"] = "Investigate An'daroth",
		["Investigate Echo Ridge"] = "回音山调查行动",
		["Investigate Tuurem"] = "Investigate Tuurem",
		["Investigate the Alchemist Shop"] = "调查炼金店",
		["Investigate the Amani Catacombs"] = "Investigate the Amani Catacombs",
		["Investigate the Blue Recluse"] = "Investigate the Blue Recluse",
		["Investigate the Camp"] = "调查营地",
		["Investigate the Crash"] = "Investigate the Crash",
		["Iron Coral"] = "铁珊瑚",
		["Ironband Wants You!"] = "铁环挖掘场需要你！",
		["Ironband's Compound"] = "铁环营地",
		["Ironband's Excavation"] = "铁环挖掘场",
		["Irondeep Supplies"] = "深铁矿洞补给品",
		["Irradiated Crystal Shards"] = "Irradiated Crystal Shards",
		["Isha Awak"] = "依沙瓦克",
		["Ishamuhale"] = "伊沙姆哈尔",
		["Ishanah"] = "伊沙娜",
		["Ishanah's Help"] = "Ishanah's Help",
		["It's Dangerous to Go Alone"] = "结伴而行",
		["It's Just That Easy?"] = "It's Just That Easy?",
		["It's Watching You!"] = "It's Watching You!",
		["It's a Secret to Everybody"] = "无人知晓的秘密",
		["It's a Trap!"] = "It's a Trap!",
		["Items of Power"] = "强大的物品",
		["Items of Some Consequence"] = "必备物品",
		["Ivar the Foul"] = "邪恶的伊瓦",
		["Iverron's Antidote"] = "埃沃隆的解药",
		["Ivus the Forest Lord"] = "森林之王伊弗斯",
		["JOB OPPORTUNITY: Culling the Competition"] = "工作机会：肃清竞争对手",
		["Jail Break!"] = "冲破牢笼！",
		["James Hyal"] = "詹姆斯·海厄尔",
		["Jammal'an the Prophet"] = "预言者迦玛兰",
		["Jarl Needs Eyes"] = "加尔和蜘蛛眼",
		["Jarl Needs a Blade"] = "加尔的剑",
		["Je'neu of the Earthen Ring"] = "大地之环的耶努萨克雷",
		["Jes'rimon's Payment to Jediga"] = "杰斯雷蒙的报酬",
		["Jin'Zil's Forest Magic"] = "金吉尔的森林魔法",
		["Jitters' Growling Gut"] = "饥肠辘辘的基特斯",
		["Job Opening: Guard Captain of Revantusk Village"] = "职位空缺：恶齿村卫兵队长",
		["Jol"] = "约尔",
		["Jonespyre's Request"] = "奎恩提斯的请求",
		["Jorn Skyseer"] = "乔恩·星眼",
		["Journey into Thunder Bluff"] = "雷霆崖之旅",
		["Journey to Astranaar"] = "通往阿斯特兰纳的旅途",
		["Journey to Hillsbrad Foothills"] = "前往希尔斯布莱德丘陵",
		["Journey to Honor Hold"] = "Journey to Honor Hold",
		["Journey to Stonetalon Peak"] = "石爪峰之旅",
		["Journey to Tarren Mill"] = "塔伦米尔之旅",
		["Journey to Thrallmar"] = "Journey to Thrallmar",
		["Journey to Undercity"] = "Journey to Undercity",
		["Journey to the Crossroads"] = "十字路口之旅",
		["Journey to the Marsh"] = "沼泽之旅",
		["Joys of Omosh"] = "沃姆什的喜悦",
		["Ju-Ju Heaps"] = "魂能骨堆",
		["Judgment and Redemption"] = "审判和救赎",
		["Juice Delivery"] = "僵尸酒",
		["Jungle Secrets"] = "丛林中的秘密",
		["Junkboxes Needed"] = "垃圾箱",
		["Just Compensation"] = "小小的补偿",
		["Jyoba's Report"] = "Jyoba's Report",
		["KILL ON SIGHT: Dark Iron Dwarves"] = "格杀勿论：黑铁矮人",
		["KILL ON SIGHT: High Ranking Dark Iron Officials"] = "格杀勿论：高阶黑铁军官",
		["Kaela's Update"] = "向凯拉回报",
		["Kamsis"] = "卡姆希丝",
		["Karabor Training Grounds"] = "Karabor Training Grounds",
		["Karynaku"] = "卡瑞纳库",
		["Kaya's Alive"] = "卡雅还活着",
		["Kayneth Stillwind"] = "凯尼斯·静风",
		["Keanna's Log"] = "金娜的日记",
		["Keep An Eye Out"] = "海盗的眼睛",
		["Keep Thornfang Hill Clear!"] = "Keep Thornfang Hill Clear!",
		["Keeper of the Flame"] = "长明的灯塔",
		["Keeping Pace"] = "跟上节奏",
		["Keeping Up Appearances"] = "Keeping Up Appearances",
		["Ken'zigla's Draught"] = "肯兹格拉的伤药",
		["Khadgar"] = "卡德加",
		["Khan Dez'hepah"] = "戴兹帕可汗",
		["Khan Hratha"] = "赫鲁萨可汗",
		["Khan Jehn"] = "杰恩可汗",
		["Khan Shaka"] = "沙卡可汗",
		["Kharan Mighthammer"] = "卡兰·巨锤",
		["Kharan's Tale"] = "卡兰的故事",
		["Kibler's Exotic Pets"] = "基布雷尔的特殊宠物",
		["Kick Them While They're Down"] = "Kick Them While They're Down",
		["Kidnapped Elder Torntusk!"] = "被绑架的断齿长者！",
		["Kill Grundig Darkcloud"] = "杀死格鲁迪格·暗云",
		["Kill the Shadow Council!"] = "Kill the Shadow Council!",
		["Killing the Crawlers"] = "Killing the Crawlers",
		["Kim'jael Indeed!"] = "我就是基姆加尔！",
		["Kim'jael's \"Missing\" Equipment"] = "Kim'jael's \"Missing\" Equipment",
		["Kindness"] = "Kindness",
		["King of the Foulweald"] = "污林熊怪之王",
		["Kingly Shakedown"] = "国王的搜查",
		["Kirith"] = "基利斯",
		["Kirtonos the Herald"] = "传令官基尔图诺斯",
		["Kitchen Assistance"] = "下厨",
		["Klaven's Tower"] = "克拉文之塔",
		["Klockmort Spannerspan"] = "科罗莫特·钢尺",
		["Klockmort's Creation"] = "Klockmort's Creation",
		["Klockmort's Essentials"] = "帮助科劳莫特",
		["Know Thine Enemy"] = "Know Thine Enemy",
		["Know your Enemy"] = "Know your Enemy",
		["Knowledge in the Deeps"] = "深渊中的知识",
		["Knowledge of the Orb of Orahil"] = "奥拉赫宝珠",
		["Kobold Camp Cleanup"] = "剿灭狗头人",
		["Kobold Candles"] = "狗头人的蜡烛",
		["Kodo Hide Bag"] = "科多兽皮包",
		["Kodo Roundup"] = "诱捕科多兽",
		["Kolkar Leaders"] = "科卡尔首领",
		["Krastinov's Bag of Horrors"] = "卡斯迪诺夫的恐惧之袋",
		["Krasus's Compendium"] = "克拉苏斯的魔法纲要",
		["Krazek's Cookery"] = "克拉兹克的烹调锅",
		["Kris of Unspoken Names"] = "禁断邪语短剑",
		["Krom'Grul"] = "克罗格鲁尔",
		["Kroshius' Infernal Core"] = "克罗苏斯的恶魔之核",
		["Kum'isha's Endeavors"] = "库米沙的努力",
		["Kurzen's Mystery"] = "库尔森的秘密",
		["Lack of Surplus"] = "缺乏补给",
		["Lakota'mani"] = "拉克塔曼尼",
		["Land Ho!"] = "法迪尔海湾",
		["Lard Lost His Lunch"] = "拉尔德的午餐",
		["Larion and Muigin"] = "拉瑞安和穆尔金",
		["Laughing Sisters"] = "欢笑的姐妹",
		["Laying Waste to the Unwanted"] = "Laying Waste to the Unwanted",
		["Lazy Peons"] = "懒惰的苦工",
		["Leader of the Bloodscale"] = "Leader of the Bloodscale",
		["Leader of the Darkcrest"] = "Leader of the Darkcrest",
		["Leaders of the Fang"] = "尖牙德鲁伊",
		["Learning from the Crystals"] = "Learning from the Crystals",
		["Learning the Language"] = "学外语……",
		["Ledger from Tanaris"] = "塔纳利斯的账本",
		["Legends of Maraudon"] = "玛拉顿的传说",
		["Leonid Barthalomew"] = "莱尼德·巴萨罗梅",
		["Lethtendris's Web"] = "蕾瑟塔蒂丝的网",
		["Letter to Jin'Zil"] = "写给金吉尔的信",
		["Letter to Stormpike"] = "铁炉堡的译码者",
		["Levixus the Soul Caller"] = "Levixus the Soul Caller",
		["Libram of Constitution"] = "体质圣契",
		["Libram of Focus"] = "专注圣典",
		["Libram of Protection"] = "防护圣典",
		["Libram of Rapidity"] = "急速圣典",
		["Libram of Resilience"] = "恢复圣契",
		["Libram of Rumination"] = "沉思圣契",
		["Libram of Tenacity"] = "坚韧圣契",
		["Libram of Voracity"] = "贪婪圣契",
		["Lieutenant Paval Reethe"] = "帕瓦尔·雷瑟上尉",
		["Life's Finer Pleasures"] = "Life's Finer Pleasures",
		["Lifting the Curse"] = "解除诅咒",
		["Limits of Physical Exhaustion"] = "Limits of Physical Exhaustion",
		["Lines of Communication"] = "联络中心",
		["Linken's Adventure"] = "林克的冒险",
		["Linken's Memory"] = "林克的记忆",
		["Linken's Sword"] = "林克的剑",
		["Liquid Stone"] = "卢希恩的药水",
		["Little Embers"] = "Little Embers",
		["Little Morsels"] = "Little Morsels",
		["Load Lightening"] = "减轻负重",
		["Lonebrow's Journal"] = "亨里格·独眉的日记",
		["Long Forgotten Memories"] = "久远的记忆",
		["Longtail is the Lynchpin"] = "Longtail is the Lynchpin",
		["Look To The Stars"] = "仰望星空",
		["Look to an Old Friend"] = "老朋友",
		["Looking Further"] = "监视",
		["Looking to the Leadership"] = "Looking to the Leadership",
		["Loramus"] = "洛拉姆斯",
		["Lord Aliden Perenolde"] = "奥里登·匹瑞诺德领主",
		["Lord Banehollow"] = "魔王贝恩霍勒",
		["Lord Maxwell Tyrosus"] = "玛克斯韦尔·泰罗索斯男爵",
		["Lords of the Council"] = "议会的领主",
		["Lore for a Price"] = "昂贵的知识",
		["Losing Gracefully"] = "Losing Gracefully",
		["Lost Armaments"] = "Lost Armaments",
		["Lost But Not Forgotten"] = "丢失的孩子",
		["Lost Deathstalkers"] = "失踪的亡灵哨兵",
		["Lost Necklace"] = "丢失的项链",
		["Lost Thunderbrew Recipe"] = "遗失的雷酒秘方",
		["Lost in Action"] = "Lost in Action",
		["Lost in Battle"] = "在战斗中失踪",
		["Lost!"] = "走丢了！",
		["Love Song for Narain"] = "唱给纳瑞安的情歌",
		["Love's Gift"] = "爱的礼物",
		["Luck Be With You"] = "祝你好运",
		["Mac'Aree Mushroom Menagerie"] = "Mac'Aree Mushroom Menagerie",
		["MacKreel's Moonshine"] = "马克里尔的月光酒",
		["Mace of Unending Life"] = "不灭生命之锤",
		["Maelstrom's Wrath"] = "漩涡之怒",
		["Magatha's Payment to Jediga"] = "玛加萨的报酬",
		["Mage Summoner"] = "召唤者",
		["Mage Training"] = "Mage Training",
		["Mage's Wand"] = "法师的魔杖",
		["Mage-tastic Gizmonitor"] = "法师文档存储器",
		["Magecraft"] = "法师的会见",
		["Magic Dust"] = "魔尘",
		["Magic of the Arakkoa"] = "Magic of the Arakkoa",
		["Magical Analysis"] = "魔法分析",
		["Magical Disturbances"] = "Magical Disturbances",
		["Magram Alliance"] = "玛格拉姆部族",
		["Mahren Skyseer"] = "玛伦·星眼",
		["Mai'Zoth"] = "麦佐斯",
		["Major Malfunction"] = "Major Malfunction",
		["Make Them Listen"] = "Make Them Listen",
		["Making Amends"] = "Making Amends",
		["Making Sense of It"] = "分析水晶塔",
		["Maktu's Revenge"] = "Maktu's Revenge",
		["Makuru's Vengeance"] = "Makuru's Vengeance",
		["Malaise"] = "Malaise",
		["Malevolent Remnants"] = "Malevolent Remnants",
		["Malfunction at the West Sanctum"] = "Malfunction at the West Sanctum",
		["Malin's Request"] = "马林的要求",
		["Mana Surges"] = "法力怒灵",
		["Manaforge B'naar"] = "法力熔炉：布纳尔",
		["Manaweave Robe"] = "法纹长袍",
		["Manhunt"] = "猎杀收货人",
		["Mantle of the Oracle"] = "神谕者的衬肩",
		["Mantles of the Dawn"] = "黎明衬肩",
		["Maps and Runes"] = "地图与符记",
		["Marauders of Darrowshire"] = "达隆郡的掠夺者",
		["Marauding Crust Bursters"] = "Marauding Crust Bursters",
		["Marauding Wolves"] = "Marauding Wolves",
		["Marg Speaks"] = "玛尔格的嘱托",
		["Margoz"] = "玛高兹",
		["Mark V is Alive!"] = "Mark V is Alive!",
		["Marking the Path"] = "Marking the Path",
		["Marks of Kil'jaeden"] = "Marks of Kil'jaeden",
		["Marks of Sargeras"] = "Marks of Sargeras",
		["Marla's Last Wish"] = "玛拉的遗愿",
		["Marshal Haggard"] = "治安官哈迦德",
		["Marshal Windsor"] = "温德索尔元帅",
		["Martek the Exiled"] = "流放者马特克",
		["Marvon's Workshop"] = "玛尔冯的车间",
		["Massacre at Gruul's Lair"] = "Massacre at Gruul's Lair",
		["Master Angler"] = "钓鱼大师",
		["Master of the Wild Leather"] = "蛮皮护甲大师",
		["Mastering the Elements"] = "Mastering the Elements",
		["Material Assistance"] = "收集材料",
		["Material Components"] = "Material Components",
		["Mathias and the Defias"] = "马迪亚斯和迪菲亚盗贼",
		["Mathiel"] = "玛希尔",
		["Mathiel's Armor"] = "Mathiel's Armor",
		["Mathystra Relics"] = "玛塞斯特拉遗物",
		["Matis the Cruel"] = "残忍的玛提斯",
		["Matters of Security"] = "新手任务",
		["Maxnar Must Die!"] = "Maxnar Must Die!",
		["Maxwell's Mission"] = "麦克斯韦尔的任务",
		["Mayara Brightwing"] = "玛亚拉·布莱特文",
		["Mazen's Behest"] = "马森的请求",
		["Mazzranache"] = "马兹拉纳其",
		["Measuring Warp Energies"] = "Measuring Warp Energies",
		["Meats to Orgrimmar"] = "送往奥格瑞玛的肉",
		["Mechanical Repair Kits"] = "Mechanical Repair Kits",
		["Medallion of Station"] = "身份勋章",
		["Medicinal Purpose"] = "医疗材料",
		["Medivh's Journal"] = "麦迪文的日记",
		["Meet at the Grave"] = "墓地相见",
		["Meeting at the Blackwing Coven"] = "Meeting at the Blackwing Coven",
		["Meeting with the Master"] = "见到主人",
		["Melding of Influences"] = "融合软泥怪",
		["Melor Sends Word"] = "梅洛的关注",
		["Menacing Marshfangs"] = "Menacing Marshfangs",
		["Mending Old Wounds"] = "Mending Old Wounds",
		["Menethil's Gift"] = "米奈希尔的礼物",
		["Mennet Carkad"] = "米奈特·卡加德",
		["Mercenaries"] = "雇佣兵",
		["Mercy for the Cursed"] = "阿弗恩的怜悯",
		["Message in a Bottle"] = "瓶中信",
		["Message to Freewind Post"] = "给乱风岗的紧急信件",
		["Message to Garadar"] = "Message to Garadar",
		["Message to Maxwell"] = "Message to Maxwell",
		["Message to Telaar"] = "Message to Telaar",
		["Message to the Daggerfen"] = "Message to the Daggerfen",
		["Message to the Wildhammer"] = "给蛮锤部族的警告",
		["Messenger to Darkshire"] = "送往夜色镇的信",
		["Messenger to Stormwind"] = "送往暴风城的信",
		["Messenger to Thrall"] = "Messenger to Thrall",
		["Messenger to Westfall"] = "送往西部荒野的信",
		["Messenger to the Feralfen"] = "Messenger to the Feralfen",
		["Metzen the Reindeer"] = "驯鹿梅森",
		["Michael Garrett"] = "迈克尔·加勒特",
		["Milly Osworth"] = "米莉·奥斯沃斯",
		["Milly's Harvest"] = "米莉的葡萄",
		["Miner's Fortune"] = "矿工的宝贝",
		["Minions of the Shadow Council"] = "Minions of the Shadow Council",
		["Minshina's Skull"] = "明希纳的颅骨",
		["Mirages"] = "饥肠辘辘",
		["Mirror Lake"] = "明镜湖",
		["Missing Crystals"] = "遗失的水晶",
		["Missing Friends"] = "Missing Friends",
		["Missing In Action"] = "失踪人员",
		["Missing Mag'hari Procession"] = "Missing Mag'hari Procession",
		["Missing Missive"] = "Missing Missive",
		["Missing in the Ghostlands"] = "Missing in the Ghostlands",
		["Mission: Gateways Murketh and Shaadraz"] = "Mission: Gateways Murketh and Shaadraz",
		["Mission: Possible But Not Probable"] = "基本不可能的任务",
		["Mission: The Abyssal Shelf"] = "Mission: The Abyssal Shelf",
		["Mission: The Murketh and Shaadraz Gateways"] = "Mission: The Murketh and Shaadraz Gateways",
		["Mist"] = "密斯特",
		["Mo'mor the Breaker"] = "击碎者姆摩尔",
		["Mok'Nathal Treats"] = "Mok'Nathal Treats",
		["Mok'thardin's Enchantment"] = "摩克萨尔丁的魔法",
		["Mold Rhymes With..."] = "昂贵的模具",
		["Moonglow Vest"] = "月光外衣",
		["Moontouched Wildkin"] = "月光羽毛",
		["Mor'Ladim"] = "摩拉迪姆",
		["Mor'zul Bloodbringer"] = "莫苏尔·召血者",
		["Morbent Fel"] = "摩本特·费尔",
		["More Arakkoa Feathers"] = "More Arakkoa Feathers",
		["More Armor Kits"] = "More Armor Kits",
		["More Bat Eyes"] = "More Bat Eyes",
		["More Booty!"] = "取之于敌",
		["More Components of Importance"] = "More Components of Importance",
		["More Crystal Fragments"] = "More Crystal Fragments",
		["More Dense Grinding Stones"] = "更多致密砂轮",
		["More Feathers"] = "More Feathers",
		["More Fertile Spores"] = "More Fertile Spores",
		["More Firewing Signets"] = "More Firewing Signets",
		["More Glowcaps"] = "More Glowcaps",
		["More Glowing Scorpid Blood"] = "More Glowing Scorpid Blood",
		["More Heads Full of Ivory"] = "More Heads Full of Ivory",
		["More Irradiated Crystal Shards"] = "More Irradiated Crystal Shards",
		["More Marks of Kil'jaeden"] = "More Marks of Kil'jaeden",
		["More Marks of Sargeras"] = "More Marks of Sargeras",
		["More Obsidian Warbeads"] = "More Obsidian Warbeads",
		["More Power!"] = "More Power!",
		["More Rotting Hearts"] = "More Rotting Hearts",
		["More Spore Sacs"] = "More Spore Sacs",
		["More Tendrils!"] = "More Tendrils!",
		["More Thorium Widgets"] = "More Thorium Widgets",
		["More Venom Sacs"] = "More Venom Sacs",
		["More Warbeads"] = "More Warbeads",
		["More Warbeads!"] = "More Warbeads!",
		["More Wastewander Justice"] = "废土的公正",
		["More than a Pound of Flesh"] = "More than a Pound of Flesh",
		["Morgan Ladimore"] = "摩根·拉迪莫尔",
		["Morgan Stern"] = "摩根·斯特恩",
		["Morganth"] = "莫甘斯",
		["Morrowgrain Research"] = "晨光麦研究",
		["Morrowgrain to Darnassus"] = "达纳苏斯的晨光麦",
		["Morrowgrain to Feathermoon Stronghold"] = "羽月要塞的晨光麦",
		["Morrowgrain to Thunder Bluff"] = "雷霆崖的晨光麦",
		["Mortality Wanes"] = "临终遗言",
		["Mother's Milk"] = "蛛后的乳汁",
		["Mountain Giant Muisek"] = "山岭巨人灵魂精华",
		["Mountaineer Stormpike's Task"] = "巡山人卡尔·雷矛的任务",
		["Muck Diving"] = "Muck Diving",
		["Mudrock Soup and Bugs"] = "泥石龟蟹汤",
		["Muigin and Larion"] = "穆尔金和拉瑞安",
		["Mura Runetotem"] = "茉拉·符文图腾",
		["Murdaloc"] = "莫达洛克",
		["Muren Stormpike"] = "穆伦·雷矛",
		["Murkblood Corrupters"] = "Murkblood Corrupters",
		["Murkblood Invaders"] = "Murkblood Invaders",
		["Murkblood Leaders..."] = "Murkblood Leaders...",
		["Murloc Poachers"] = "鱼人偷猎者",
		["Murlocs... Why Here? Why Now?"] = "Murlocs... Why Here? Why Now?",
		["Mystery Goo"] = "神秘的粘液",
		["Mystery Mask"] = "神秘的面具",
		["Mythology of the Titans"] = "泰坦神话",
		["Myzrael's Allies"] = "密斯莱尔的盟友",
		["Naaru Technology"] = "Naaru Technology",
		["Naga at the Zoram Strand"] = "佐拉姆海岸的纳迦",
		["Naladu"] = "纳拉杜",
		["Nara Wildmane"] = "纳拉·蛮鬃",
		["Nat's Measuring Tape"] = "纳特的卷尺",
		["Natural Armor"] = "自然护甲",
		["Natural Enemies"] = "Natural Enemies",
		["Natural Materials"] = "天然材料",
		["Natural Remedies"] = "Natural Remedies",
		["Necklace Recovery"] = "搜寻项链",
		["Need for a Cure"] = "救命如救火",
		["Needs More Cowbell"] = "Needs More Cowbell",
		["Neeka Bloodscar"] = "尼卡·血痕",
		["Neeru Fireblade"] = "尼尔鲁·火刃",
		["Nefarius's Corruption"] = "奈法里奥斯的腐蚀",
		["Nek'rosh's Gambit"] = "纳克罗什的优势",
		["Nekrum's Medallion"] = "耐克鲁姆的徽章",
		["Nessa Shadowsong"] = "尼莎·影歌",
		["Nether Gas In a Fel Fire Engine"] = "Nether Gas In a Fel Fire Engine",
		["Nether-lace Garment"] = "虚灵长袍",
		["Neutralizing the Nethermancers"] = "Neutralizing the Nethermancers",
		["Never Again!"] = "休想！",
		["Never Ask Me About My Business"] = "少管闲事",
		["New Life"] = "新的生命",
		["New Opportunities"] = "New Opportunities",
		["New Year Celebrations!"] = "庆祝新年！",
		["Newfound Allies"] = "Newfound Allies",
		["News for Fizzle"] = "回复菲兹尔",
		["News for Rakoria"] = "News for Rakoria",
		["News from Zangarmarsh"] = "News from Zangarmarsh",
		["News of Dogran"] = "多格兰的消息",
		["News of Victory"] = "News of Victory",
		["Nexus-King Salhadaar"] = "节点之王萨哈达尔",
		["Night Web's Hollow"] = "夜行蜘蛛洞穴",
		["No More Mushrooms!"] = "No More Mushrooms!",
		["No Time for Curiosity"] = "No Time for Curiosity",
		["Noble Deaths"] = "贵族之死",
		["Noboru the Cudgel"] = "木棒诺博鲁",
		["Nogg's Ring Redo"] = "诺格的手艺",
		["Noggenfogger Elixir"] = "诺格弗格药剂",
		["Noggle's Last Hope"] = "诺格的最后一线希望",
		["Noggle's Lost Satchel"] = "诺格的背包",
		["Nolkai's Words"] = "Nolkai's Words",
		["Northfold Manor"] = "诺斯弗德农场",
		["Not On My Watch!"] = "Not On My Watch!",
		["Note to William"] = "给威廉·匹斯特的信",
		["Note to the Mayor"] = "给镇长的信",
		["Nothin' Says Lovin' Like a Big Stinger"] = "Nothin' Says Lovin' Like a Big Stinger",
		["Nothing But The Truth"] = "真言药水",
		["Now That We're Friends..."] = "Now That We're Friends...",
		["Now That We're Still Friends..."] = "Now That We're Still Friends...",
		["Noxious Lair Investigation"] = "腐化之巢",
		["Nugget Slugs"] = "高强度齿轮",
		["Oakenscowl"] = "奥肯斯古尔",
		["Observing the Sporelings"] = "Observing the Sporelings",
		["Obsidian Warbeads"] = "黑曜石作战念珠",
		["Oculus Illusions"] = "黑龙幻象",
		["Of Coursers We Know"] = "苔蹄快步者",
		["Of Forgotten Memories"] = "遗忘的记忆",
		["Of Lost Honor"] = "失落的荣耀",
		["Of Love and Family"] = "爱与家庭",
		["Of Thistleheads and Eggs..."] = "Of Thistleheads and Eggs...",
		["Off To Area 52"] = "Off To Area 52",
		["Ogre Head On A Stick = Party"] = "枭首示众",
		["Ogre Thieves"] = "食人魔盗贼",
		["Oh Brother. . ."] = "我的兄弟……",
		["Old Hillsbrad"] = "Old Hillsbrad",
		["Old Whitebark's Pendant"] = "怀特巴克的坠饰",
		["Olemba Seed Oil"] = "Olemba Seed Oil",
		["Olemba Seeds"] = "Olemba Seeds",
		["Omarion's Handbook"] = "奥玛里恩的手册",
		["On Guard in Stonetalon"] = "守卫石爪山",
		["On Iron Pauldrons"] = "铁肩铠",
		["On Nethery Wings"] = "On Nethery Wings",
		["On Spirit's Wings"] = "On Spirit's Wings",
		["On the Wings of a Hippogryph"] = "On the Wings of a Hippogryph",
		["Once Were Warriors"] = "Once Were Warriors",
		["One Demon's Trash..."] = "One Demon's Trash...",
		["One Draenei's Junk..."] = "德莱尼的垃圾…",
		["One Shot. One Kill."] = "One Shot. One Kill.",
		["Ongeku"] = "盎格库尔",
		["Onin's Report"] = "奥宁的报告",
		["Only One May Rise"] = "唯一的领袖",
		["Onu"] = "安努",
		["Onu is meditating"] = "正在冥想的安努",
		["Onward to Ashenvale"] = "Onward to Ashenvale",
		["Operation Recombobulation"] = "自动净化装置",
		["Operation: Death to Angerforge"] = "行动：杀死安格弗将军",
		["Operative Bijou"] = "狡猾的比修",
		["Oran's Gratitude"] = "奥兰的感谢",
		["Ordanus"] = "奥达努斯",
		["Order Must Be Restored"] = "重铸秩序",
		["Orders from Lady Vashj"] = "瓦丝琪女王的命令",
		["Orendil's Cure"] = "奥雷迪尔的药剂",
		["Orm Stonehoof and the Brutal Helm"] = "奥姆·石蹄和野蛮头盔",
		["Ormer's Revenge"] = "奥莫尔的复仇",
		["Oronok Torn-heart"] = "欧鲁诺克·裂心",
		["Oronu the Elder"] = "长者奥洛努",
		["Ortor My Old Friend..."] = "Ortor My Old Friend...",
		["Oshu'gun Crystal Powder"] = "Oshu'gun Crystal Powder",
		["Other Fish to Fry"] = "另一种鱼",
		["Outland Sucks!"] = "Outland Sucks!",
		["Outrider Advanced Care Package"] = "斥候高级护理包",
		["Outrider Basic Care Package"] = "斥候基础护理包",
		["Outrider Standard Care Package"] = "斥候标准护理包",
		["Outside Assistance"] = "Outside Assistance",
		["Overlord"] = "Overlord",
		["Overlord Gorefist"] = "戈尔费斯大王",
		["Overlord Mok'Morokk's Concern"] = "莫格穆洛克的任务",
		["Overmaster Pyron"] = "征服者派隆",
		["Owatanka"] = "奥瓦坦卡",
		["Pacify the Centaur"] = "清除半人马",
		["Package Recovery"] = "Package Recovery",
		["Package for Thurman"] = "萨尔曼的针线包",
		["Paladin Training"] = "圣骑士训练",
		["Pamela's Doll"] = "帕米拉的洋娃娃",
		["Panther Mastery"] = "猎豹",
		["Paragons of Power: The Augur's Belt"] = "权力珍宝：预言者腰带",
		["Paragons of Power: The Augur's Bracers"] = "权力珍宝：预言者护腕",
		["Paragons of Power: The Augur's Hauberk"] = "权力珍宝：预言者外套",
		["Paragons of Power: The Confessor's Bindings"] = "权力珍宝：忏悔者腰带",
		["Paragons of Power: The Confessor's Mantle"] = "权力珍宝：忏悔者衬肩",
		["Paragons of Power: The Confessor's Wraps"] = "权力珍宝：忏悔者裹布",
		["Paragons of Power: The Demoniac's Mantle"] = "权力珍宝：恶魔师衬肩",
		["Paragons of Power: The Demoniac's Robes"] = "权力珍宝：恶魔师长袍",
		["Paragons of Power: The Demoniac's Wraps"] = "权力珍宝：恶魔师裹带",
		["Paragons of Power: The Freethinker's Armguards"] = "权力珍宝：思考者护臂",
		["Paragons of Power: The Freethinker's Belt"] = "权力珍宝：思考者腰带",
		["Paragons of Power: The Freethinker's Breastplate"] = "权力珍宝：思考者胸甲",
		["Paragons of Power: The Haruspex's Belt"] = "权力珍宝：占卜师腰带",
		["Paragons of Power: The Haruspex's Bracers"] = "权力珍宝：占卜师护腕",
		["Paragons of Power: The Haruspex's Tunic"] = "权力珍宝：占卜师外套",
		["Paragons of Power: The Illusionist's Mantle"] = "权力珍宝：幻术师衬肩",
		["Paragons of Power: The Illusionist's Robes"] = "权力珍宝：幻术师长袍",
		["Paragons of Power: The Illusionist's Wraps"] = "权力珍宝：幻术师裹布",
		["Paragons of Power: The Madcap's Bracers"] = "权力珍宝：狂妄者护腕",
		["Paragons of Power: The Madcap's Mantle"] = "权力珍宝：狂妄者衬肩",
		["Paragons of Power: The Madcap's Tunic"] = "权力珍宝：狂妄者外套",
		["Paragons of Power: The Predator's Belt"] = "权力珍宝：捕猎者腰带",
		["Paragons of Power: The Predator's Bracers"] = "权力珍宝：捕猎者护腕",
		["Paragons of Power: The Predator's Mantle"] = "权力珍宝：捕猎者衬肩",
		["Paragons of Power: The Vindicator's Armguards"] = "权力珍宝：辩护者护臂",
		["Paragons of Power: The Vindicator's Belt"] = "权力珍宝：辩护者腰带",
		["Paragons of Power: The Vindicator's Breastplate"] = "权力珍宝：辩护者胸甲",
		["Parts for Kravel"] = "给克拉维尔的零件",
		["Parts of the Swarm"] = "虫群的样本",
		["Passage to Booty Bay"] = "藏宝海湾的航道",
		["Passing Word of a Threat"] = "亡者的警告",
		["Passing the Burden"] = "委以重任",
		["Past Endeavors"] = "以往的努力",
		["Path of Defense"] = "防御之道",
		["Path of the Violet Protector"] = "Path of the Violet Protector",
		["Path of the Violet Restorer"] = "Path of the Violet Restorer",
		["Patriarch Ironjaw"] = "Patriarch Ironjaw",
		["Patrol Schedules"] = "巡逻时间表",
		["Patrolling Westfall"] = "西部荒野的豺狼人",
		["Pawn Captures Queen"] = "捕捉皇后",
		["Pay the Baron a Visit"] = "Pay the Baron a Visit",
		["Pearl Diving"] = "潜水采珍珠",
		["Pelt Collection"] = "Pelt Collection",
		["Perfect Yeti Hide"] = "完美的雪人毛皮",
		["Petty Squabbles"] = "争论",
		["Pick Your Part"] = "Pick Your Part",
		["Picking Up Some Power Converters"] = "Picking Up Some Power Converters",
		["Pie for Billy"] = "比利的馅饼",
		["Piercing the Veil"] = "控制小鬼",
		["Pilfered Equipment"] = "Pilfered Equipment",
		["Pirate Hats Ahoy!"] = "海盗的帽子！",
		["Plagued Hatchlings"] = "瘟疫之龙",
		["Plagueheart Belt"] = "瘟疫之心腰带",
		["Plagueheart Bindings"] = "瘟疫之心腕轮",
		["Plagueheart Leggings"] = "瘟疫之心护腿",
		["Plainstrider Menace"] = "平原陆行鸟的威胁",
		["Planting the Banner"] = "Planting the Banner",
		["Planting the Heart"] = "培养心脏",
		["Plants of Zangarmarsh"] = "Plants of Zangarmarsh",
		["Plea To The Alliance"] = "请求援助",
		["Plundering the Plunderers"] = "抢劫海盗",
		["Poaching from Poachers"] = "Poaching from Poachers",
		["Poison Water"] = "毒水",
		["Poisoned Water"] = "被囚禁的水元素",
		["Pool of Tears"] = "泪水之池",
		["Poor Old Blanchy"] = "老马布兰契",
		["Portals of the Legion"] = "燃烧军团的传送门",
		["Portents of Uldum"] = "奥丹姆的线索",
		["Potential Energy Source"] = "Potential Energy Source",
		["Potential for Brain Damage = High"] = "Potential for Brain Damage = High",
		["Powder to Ironband"] = "铁环的火药",
		["Power Stones"] = "能量石",
		["Power in Uldaman"] = "奥达曼的能量源",
		["Power over Poison"] = "解毒之术",
		["Powering our Defenses"] = "Powering our Defenses",
		["Practical Prey"] = "生活所需的虎皮",
		["Prayer to Elune"] = "艾露恩祷言",
		["Precarious Predicament"] = "押送囚徒",
		["Precious and Fragile Things Need Special Handling"] = "贵重物品，小心轻放",
		["Preparation for Ceremony"] = "准备典礼",
		["Preparing for War"] = "Preparing for War",
		["Preparing the Salve"] = "Preparing the Salve",
		["Presence of Might"] = "力量的证明",
		["Presence of Sight"] = "魔法的视域",
		["Preserving Knowledge"] = "保全书籍",
		["Preying on the Predators"] = "猎杀狼群",
		["Pride of the Fel Horde"] = "Pride of the Fel Horde",
		["Pridewings of Stonetalon"] = "石爪山的双足飞龙",
		["Priest Training"] = "Priest Training",
		["Primal Magic"] = "Primal Magic",
		["Princess Must Die!"] = "公主必须死！",
		["Prison Break In"] = "入室偷窃",
		["Prisoner of the Bladespire"] = "Prisoner of the Bladespire",
		["Pristine Enchanted South Seas Kelp"] = "原始南海魔化海藻",
		["Pristine Spider Silk"] = "新鲜的蜘蛛丝",
		["Pristine Yeti Hide"] = "原始雪人毛皮",
		["Proof of Allegiance"] = "Proof of Allegiance",
		["Proof of Deed"] = "索里奥斯的证明信",
		["Proof of Demise"] = "死亡证明",
		["Proof of Life"] = "生命的证据",
		["Prophetic Aura"] = "预言的光环",
		["Prospect of Faith"] = "铁趾的遗愿",
		["Prospector Balmoral"] = "勘测员巴莫拉尔",
		["Protect Kanati Greycloud"] = "保护卡纳提·灰云",
		["Protect Kaya"] = "保护卡雅",
		["Protect the Frontier"] = "保卫边境",
		["Protecting Our Own"] = "Protecting Our Own",
		["Protecting the Herd"] = "保护牲畜",
		["Protecting the Shipment"] = "护送货物",
		["Prove Your Hatred"] = "Prove Your Hatred",
		["Prove Your Worth"] = "证明你的价值",
		["Proving Allegiance"] = "证明忠诚",
		["Proving Grounds"] = "实验场",
		["Proving Your Strength"] = "Proving Your Strength",
		["Proving Your Worth"] = "证明你的实力",
		["Prowlers of the Barrens"] = "草原上的徘徊者",
		["Psychometric Reading"] = "心灵占卜术",
		["Purified!"] = "净化！",
		["Pursuing Terrorclaw"] = "Pursuing Terrorclaw",
		["Pusillin and the Elder Azj'Tordin"] = "普希林和埃斯托尔迪",
		["Put Her Down"] = "座狼之源",
		["Put On Yer Kneepads..."] = "Put On Yer Kneepads...",
		["Pyrewood Ambush"] = "焚木村中的伏击",
		["Quell The Uprising"] = "镇压暴动",
		["Quenching the Blade"] = "Quenching the Blade",
		["Questioning Reethe"] = "盘问雷瑟",
		["Rabine Saturna"] = "拉比恩·萨图纳",
		["Raene's Cleansing"] = "莱恩的净化",
		["Rage of Ages"] = "远古之怒",
		["Rage of Blood"] = "血之狂暴",
		["Ragnar Thunderbrew"] = "拉格纳·雷酒",
		["Raid on the Kolkar"] = "突袭科卡尔",
		["Raising Spirits"] = "振奋精神",
		["Raleigh and the Undercity"] = "拉林夫与幽暗城",
		["Ram Hide Harnesses"] = "羊皮坐具",
		["Ram Riding Harnesses"] = "山羊坐具",
		["Rampaging Giants"] = "狂暴的巨人",
		["Rampaging Ravagers"] = "Rampaging Ravagers",
		["Ramstein"] = "吞咽者拉姆斯登",
		["Ranger Sareyn"] = "游侠萨蕾恩",
		["Raptor Horns"] = "迅猛龙角",
		["Raptor Mastery"] = "猎龙",
		["Raptor Thieves"] = "偷钱的迅猛龙",
		["Rare Fish - Brownell's Blue Striped Racer"] = "稀有鱼类 - 布隆奈尔蓝斑鱼",
		["Rare Fish - Dezian Queenfish"] = "Rare Fish - Dezian Queenfish",
		["Rare Fish - Keefer's Angelfish"] = "稀有鱼类 - 基佛天使鱼",
		["Rat Catching"] = "狗头人的耳朵",
		["Rather Be Fishin'"] = "Rather Be Fishin'",
		["Rattling the Rattlecages"] = "断骨骷髅",
		["Ravager Egg Roundup"] = "Ravager Egg Roundup",
		["Raven Hill"] = "乌鸦岭",
		["Razorhide"] = "野猪之皮",
		["Razormaw"] = "刺喉",
		["Razzeric's Tweaking"] = "拉泽瑞克的调整",
		["Reagents for Reclaimers Inc."] = "寻物公司的委托",
		["Rear Guard Patrol"] = "巡查后方",
		["Reassignment"] = "人事调动",
		["Recently Living"] = "Recently Living",
		["Reception from Tyrande"] = "泰兰德的接待",
		["Recharging the Batteries"] = "Recharging the Batteries",
		["Recipe for Destruction"] = "Recipe for Destruction",
		["Recipe of the Kaldorei"] = "卡多雷的菜谱",
		["Reclaimed Treasures"] = "寻找宝物",
		["Reclaimers' Business in Desolace"] = "寻物公司的业务",
		["Reclaiming Felfire Hill"] = "夺回冥火岭",
		["Reclaiming Goods"] = "夺回雕像",
		["Reclaiming Holy Grounds"] = "Reclaiming Holy Grounds",
		["Reclaiming Sunstrider Isle"] = "夺回逐日岛",
		["Reclaiming the Charred Vale"] = "夺回焦炭谷",
		["Reclaiming the Eggs"] = "夺回狮鹫卵",
		["Reclaiming the Ruins"] = "夺回废墟",
		["Recover the Bones"] = "Recover the Bones",
		["Recover the Key!"] = "找回钥匙！",
		["Red Leather Bandanas"] = "红色皮质面罩",
		["Red Linen Goods"] = "红色亚麻布",
		["Red Silk Bandanas"] = "红色丝质面罩",
		["Red Snapper - Very Tasty!"] = "美味的红钳鱼",
		["Redeeming the Dead"] = "Redeeming the Dead",
		["Redemption"] = "救赎",
		["Redemption Boots"] = "救赎长靴",
		["Redemption Girdle"] = "救赎束带",
		["Redemption Handguards"] = "救赎护手",
		["Redemption Headpiece"] = "救赎头饰",
		["Redemption Tunic"] = "救赎外套",
		["Redemption Wristguards"] = "救赎护腕",
		["Redridge Goulash"] = "赤脊山炖肉",
		["Redridge Rendezvous"] = "赤脊山的联络员",
		["Refuel for the Zapping"] = "补充动力",
		["Regthar Deathgate"] = "雷戈萨·死门",
		["Reinforcements for Garadar"] = "Reinforcements for Garadar",
		["Rejold's New Brew"] = "雷杰德的新酒",
		["Release Them"] = "释放他们",
		["Rellian Greenspyre"] = "雷利亚·绿树",
		["Remorseful Highborne"] = "悔恨的上层精灵",
		["Replacement Phial"] = "占卜之瓶 ",
		["Replenishing the Healing Crystals"] = "补充治疗水晶",
		["Report Back to Fizzlebub"] = "向菲兹巴布报告",
		["Report from the Northern Front"] = "北方前线的报告",
		["Report to Anastasia"] = "向安娜斯塔西娅报告",
		["Report to Captain Helios"] = "Report to Captain Helios",
		["Report to Captain Stoutfist"] = "向斯托菲队长报告",
		["Report to Doren"] = "向多伦报告",
		["Report to Engineering"] = "Report to Engineering",
		["Report to Exarch Admetius"] = "Report to Exarch Admetius",
		["Report to General Kirika"] = "向吉里卡将军报到",
		["Report to Goldshire"] = "去闪金镇报到",
		["Report to Gryan Stoutmantle"] = "向格里安·斯托曼报到",
		["Report to Hadrec"] = "给哈德瑞克的报告",
		["Report to Helgrum"] = "向赫格拉姆报到",
		["Report to Ironforge"] = "向铁炉堡报告",
		["Report to Jennea"] = "向詹妮亚报告",
		["Report to Lanthan Perilon"] = "Report to Lanthan Perilon",
		["Report to Magister Kaendris"] = "Report to Magister Kaendris",
		["Report to Marshal Bluewall"] = "向布鲁沃尔元帅报告",
		["Report to Mountaineer Rockgar"] = "向巡山人罗克加报告",
		["Report to Nazgrel"] = "Report to Nazgrel",
		["Report to Orgnil"] = "向奥戈尼尔报告",
		["Report to Sen'jin Village"] = "去森金村报到",
		["Report to Shadow Hunter Denjai"] = "Report to Shadow Hunter Denjai",
		["Report to Splintertree Post"] = "Report to Splintertree Post",
		["Report to Stonebreaker Camp"] = "Report to Stonebreaker Camp",
		["Report to Tarren Mill"] = "Report to Tarren Mill",
		["Report to Thomas"] = "回复托马斯",
		["Report to Zor"] = "向佐尔报告",
		["Report to Zurai"] = "Report to Zurai",
		["Report to the Allerian Post"] = "Report to the Allerian Post",
		["Request for Assistance"] = "Request for Assistance",
		["Rescue Deirom!"] = "Rescue Deirom!",
		["Rescue Dugar!"] = "Rescue Dugar!",
		["Rescue From Jaedenar"] = "逃出加德纳尔",
		["Rescue OOX-09/HL!"] = "拯救OOX-09/HL！",
		["Rescue OOX-17/TN!"] = "拯救OOX-17/TN！",
		["Rescue OOX-22/FE!"] = "拯救OOX-22/FE！",
		["Rescue the Survivors!"] = "拯救幸存者！",
		["Research Notes"] = "研究笔记",
		["Researching the Corruption"] = "研究堕落",
		["Rest and Relaxation"] = "休息和放松",
		["Resting in Pieces"] = "支离破碎",
		["Restless Activity"] = "Restless Activity",
		["Restoring Fiery Flux Supplies via Heavy Leather"] = "炽热助熔剂的补给：重皮",
		["Restoring Fiery Flux Supplies via Iron"] = "炽热助熔剂的补给：铁锭",
		["Restoring Fiery Flux Supplies via Kingsblood"] = "炽热助熔剂的补给：皇血草",
		["Restoring Sanctity"] = "Restoring Sanctity",
		["Restoring the Light"] = "Restoring the Light",
		["Restoring the Necklace"] = "修复项链",
		["Resupplying the Excavation"] = "挖掘场的补给品",
		["Retaking Windrunner Spire"] = "Retaking Windrunner Spire",
		["Rethban Ore"] = "瑞斯班矿石",
		["Retribution of the Light"] = "光明的惩戒",
		["Retrieving the Goods"] = "Retrieving the Goods",
		["Return Trip"] = "回程",
		["Return of the Ring"] = "戒指归来",
		["Return the Book"] = "归还书籍",
		["Return the Comb"] = "归还梳子",
		["Return the Reports"] = "Return the Reports",
		["Return the Statuette"] = "归还雕像",
		["Return to Andormu"] = "Return to Andormu",
		["Return to Apothecary Zinge"] = "向药剂师金格回报",
		["Return to Arcanist Vandril"] = "Return to Arcanist Vandril",
		["Return to Bellowfiz"] = "艾沃沙酒",
		["Return to Bodley"] = "Return to Bodley",
		["Return to Brock"] = "向布洛克回复",
		["Return to Chillwind Camp"] = "返回冰风岗",
		["Return to Chromie"] = "返回克罗米身边",
		["Return to Corporal Kaleb"] = "向卡雷布下士回报",
		["Return to Deliana"] = "向德莉亚娜回复",
		["Return to Denalan"] = "向德纳兰回报",
		["Return to Feathermoon Stronghold"] = "返回羽月要塞",
		["Return to Fel'Zerul"] = "向费泽鲁尔复命",
		["Return to Honor Hold"] = "Return to Honor Hold",
		["Return to Ironforge"] = "返回铁炉堡",
		["Return to Jitters"] = "基特斯的美餐",
		["Return to Khadgar"] = "Return to Khadgar",
		["Return to Kristoff"] = "克里斯托弗的书",
		["Return to Lewis"] = "返回西部荒野",
		["Return to MacKinley"] = "向马克基雷回报",
		["Return to Marleth"] = "向马莱斯回报",
		["Return to Milton"] = "向米尔顿回复",
		["Return to Mokvar"] = "Return to Mokvar",
		["Return to Narain"] = "向纳瑞安回复",
		["Return to Nathanos"] = "向纳萨诺斯复命",
		["Return to Nessa"] = "飞回泰达希尔",
		["Return to Obadei"] = "Return to Obadei",
		["Return to Onu"] = "向安努回复",
		["Return to Podrig"] = "向博迪瑞格回报",
		["Return to Primal Torntusk"] = "向断齿族长复命",
		["Return to Quartermaster Lymel"] = "Return to Quartermaster Lymel",
		["Return to Quinn"] = "回到奎恩身旁",
		["Return to Rokag"] = "Return to Rokag",
		["Return to Sha'tari Base Camp"] = "Return to Sha'tari Base Camp",
		["Return to Shattrath"] = "Return to Shattrath",
		["Return to Silvermoon"] = "Return to Silvermoon",
		["Return to Sven"] = "回复斯温",
		["Return to Talionia"] = "Return to Talionia",
		["Return to Thalodien"] = "Return to Thalodien",
		["Return to Thander"] = "Return to Thander",
		["Return to Thrallmar"] = "Return to Thrallmar",
		["Return to Thunder Bluff"] = "返回雷霆崖",
		["Return to Tinkee"] = "返回丁奇身边",
		["Return to Topher Loaal"] = "Return to Topher Loaal",
		["Return to Troyas"] = "向特洛亚斯回复",
		["Return to Tymor"] = "向法师泰摩尔回复",
		["Return to Vahlarriel"] = "回复瓦拉里尔",
		["Return to Verner"] = "回复弗纳",
		["Return to Witch Doctor Uzer'i"] = "向巫医尤克里回复",
		["Return to the Abyssal Shelf"] = "Return to the Abyssal Shelf",
		["Return to the Aldor"] = "Return to the Aldor",
		["Return to the Blasted Lands"] = "返回诅咒之地",
		["Return to the Bulwark"] = "返回亡灵壁垒",
		["Return to the Crossroads."] = "返回十字路口",
		["Return to the Greatmother"] = "Return to the Greatmother",
		["Return to the Hinterlands"] = "返回辛特兰",
		["Return to the Magistrate"] = "向塞弗伦回报",
		["Return to the Marsh"] = "返回沼泽",
		["Return to the Scryers"] = "Return to the Scryers",
		["Returning Home"] = "Returning Home",
		["Returning the Cleansed Orb"] = "归还净化过的宝珠",
		["Returning the Favor"] = "Returning the Favor",
		["Returning the Lost Satchel"] = "归还背包",
		["Reunion"] = "Reunion",
		["Revenge of Gann"] = "加恩的报复",
		["Revered Among the Sha'tar"] = "Revered Among the Sha'tar",
		["Rhapsody Shindigger"] = "拉普索迪·铁铲",
		["Rhapsody's Kalimdor Kocktail"] = "拉普索迪的卡利姆多鸡尾酒",
		["Rhapsody's Tale"] = "拉普索迪的故事",
		["Ribbly Screwspigot"] = "雷布里·斯库比格特",
		["Ride the Lightning"] = "Ride the Lightning",
		["Ride to Ironforge"] = "飞往铁炉堡",
		["Ride to Orgrimmar"] = "飞往奥格瑞玛",
		["Ride to Thunder Bluff"] = "飞往雷霆崖",
		["Ride to the Undercity"] = "飞往幽暗城",
		["Ridgespine Menace"] = "Ridgespine Menace",
		["Rig Wars"] = "设备之战",
		["Rightful Repossession"] = "Rightful Repossession",
		["Rilli Greasygob"] = "雷里·格里斯高布",
		["Rin'ji is Trapped!"] = "林吉被困住了！",
		["Rin'ji's Secret"] = "林吉的秘密",
		["Ring of Infinite Wisdom"] = "无尽智慧之戒",
		["Ring of Unspoken Names"] = "禁断邪语之戒",
		["Ring of the Gathering Storm"] = "聚集风暴之戒",
		["Ripple Delivery"] = "送回蜜酒",
		["Ripple Recovery"] = "寻找蜜酒",
		["Rise of the Silithid"] = "异种蝎的崛起",
		["Rising Spirit"] = "高涨士气",
		["Rite of Strength"] = "力量仪祭",
		["Rite of Vision"] = "幻象仪祭",
		["Rite of Wisdom"] = "智慧仪祭",
		["Rites of the Earthmother"] = "大地之母仪祭",
		["Rituals of Power"] = "能量仪祭",
		["Rituals of Strength"] = "力量仪式",
		["Riverpaw Gnoll Bounty"] = "悬赏河爪豺狼人",
		["Rizzle's Schematics"] = "瑞兹尔的图表",
		["Road to Salvation"] = "救赎之路",
		["Roadside Ambush"] = "Roadside Ambush",
		["Rocket Car Parts"] = "火箭车零件",
		["Rocknot's Ale"] = "罗克诺特的麦酒",
		["Rogue Training"] = "Rogue Training",
		["Rogues of the Shattered Hand"] = "Rogues of the Shattered Hand",
		["Rohok's Request"] = "Rohok's Request",
		["Roll the Bones"] = "挖骨头",
		["Root Samples"] = "根须样本",
		["Rot Hide Clues"] = "线索",
		["Rot Hide Ichor"] = "腐皮豺狼人的脓液",
		["Rot Hide Origins"] = "腐皮豺狼人的产生",
		["Rotten Eggs"] = "烂鸡蛋",
		["Rotting Hearts"] = "Rotting Hearts",
		["Rude Awakening"] = "突然醒来",
		["Ruined Kegs"] = "Ruined Kegs",
		["Rumors for Kravel"] = "地精的谣言",
		["Run a Diagnostic!"] = "Run a Diagnostic!",
		["Rune Covered Tablet"] = "写满符文的石板",
		["Rune-Inscribed Note"] = "符文便笺",
		["Rune-Inscribed Parchment"] = "符文羊皮纸",
		["Rune-Inscribed Tablet"] = "符文石板",
		["Runecloth"] = "符文布",
		["Runewarden Deryan"] = "符文看守者德尔雅",
		["Ruthless Cunning"] = "Ruthless Cunning",
		["Ruuan Weald"] = "卢安荒野",
		["Ruuzel"] = "卢泽尔",
		["S-A-B-O-T-A-G-E"] = "S-A-B-O-T-A-G-E",
		["SI:7"] = "SI:7",
		["STOLEN: Smithing Tuyere and Lookout's Spyglass"] = "被盗：鼓风机和望远镜",
		["Sabotage the Warp-Gate!"] = "Sabotage the Warp-Gate!",
		["Sacred Cloth"] = "神圣的月布",
		["Sacred Fire"] = "神圣之火",
		["Safeguarding the Watchers"] = "Safeguarding the Watchers",
		["Safety First"] = "安全第一",
		["Safety Is Job One"] = "Safety Is Job One",
		["Salt Flat Venom"] = "含盐的蝎毒",
		["Salt of the Scorpok"] = "Salt of the Scorpok",
		["Saltheril's Haven"] = "萨瑟利尔庄园",
		["Salvaging the Data"] = "Salvaging the Data",
		["Salvaging the Past"] = "Salvaging the Past",
		["Samophlange"] = "主动式负载平衡器",
		["Samophlange Manual"] = "主动式负载平衡器说明书",
		["Sample for Helbrim"] = "给赫布瑞姆的样本",
		["Sara Balloo's Plea"] = "萨拉·巴鲁的请求",
		["Sarkoth"] = "萨科斯",
		["Sathrah's Sacrifice"] = "萨丝拉的祭品",
		["Satyr Hooves"] = "萨特之蹄",
		["Satyr Horns"] = "萨特的角",
		["Satyr Slaying!"] = "猎杀萨特！",
		["Savage Flora"] = "蛮荒之叶",
		["Savage Fronds"] = "蛮荒之叶",
		["Save Techbot's Brain!"] = "拯救尖端机器人！",
		["Saving Princess Stillpine"] = "Saving Princess Stillpine",
		["Saving Sharpbeak"] = "拯救沙普比克",
		["Saving Yenniku"] = "拯救耶尼库",
		["Saving the Best for Last"] = "Saving the Best for Last",
		["Saving the Sporeloks"] = "Saving the Sporeloks",
		["Scalding Mornbrew Delivery"] = "热酒快递",
		["Scarab Shells"] = "圣甲虫的壳",
		["Scaring Shaky"] = "吓唬病鬼",
		["Scarlet Diversions"] = "误导血色十字军",
		["Scarlet Subterfuge"] = "血色幻象",
		["Scavenging Deathknell"] = "捡破烂",
		["Scepter of the Council"] = "议会的节杖",
		["Sceptre of Light"] = "圣光节杖",
		["Scholomance"] = "通灵学院",
		["Scourge of the Downs"] = "剃刀高地的亡灵天灾",
		["Scouring the Desert"] = "横扫沙漠",
		["Scouting the Defenses"] = "Scouting the Defenses",
		["Scratches"] = "Scratches",
		["Screecher Spirits"] = "尖啸者的灵魂",
		["Scrounging"] = "搜集行动",
		["Scrying Goggles? No Problem!"] = "占卜眼镜？没问题！",
		["Seal of Ascension"] = "晋升印章",
		["Sealed Azure Bag"] = "密封的蓝袋子",
		["Search More Hovels"] = "搜寻雕像",
		["Search Stillpine Hold"] = "Search Stillpine Hold",
		["Search for Incendicite"] = "火岩矿石",
		["Search for Tyranis"] = "寻找泰拉尼斯",
		["Searching for Evidence"] = "Searching for Evidence",
		["Searching for Galaen"] = "Searching for Galaen",
		["Searching for Scout Jyoba"] = "Searching for Scout Jyoba",
		["Searching for the Lost Satchel"] = "寻找背包",
		["Seasoned Wolf Kabobs"] = "干烤狼肉串",
		["Secret of the Circle"] = "雕像群的秘密",
		["Secrets of the Arakkoa"] = "Secrets of the Arakkoa",
		["Secrets of the Colossus - Ashi"] = "Secrets of the Colossus - Ashi",
		["Secrets of the Daggerfen"] = "Secrets of the Daggerfen",
		["Securing the Celestial Ridge"] = "Securing the Celestial Ridge",
		["Securing the Lines"] = "保卫商路",
		["Securing the Shaleskin Shale"] = "Securing the Shaleskin Shale",
		["Seed of Life"] = "生命之种",
		["Seeing What Happens"] = "拭目以待",
		["Seek Huntress Kella Nightbow"] = "Seek Huntress Kella Nightbow",
		["Seek Out Kirrik"] = "Seek Out Kirrik",
		["Seek Out Neltharaku"] = "Seek Out Neltharaku",
		["Seek Redemption!"] = "寻求救赎！",
		["Seek out SI: 7"] = "军情七处",
		["Seek the Farstriders"] = "Seek the Farstriders",
		["Seeking Strahad"] = "寻找斯坦哈德",
		["Seeking Wisdom"] = "寻求指引",
		["Seeking the Kor Gem"] = "寻找科尔宝石",
		["Seeping Corruption"] = "堕落之水",
		["Seer Udalo"] = "Seer Udalo",
		["Selling Fish"] = "卖鱼",
		["Senir's Observations"] = "森内尔的观察站",
		["Sentinel Advanced Care Package"] = "哨兵高级护理包",
		["Sentinel Basic Care Package"] = "哨兵基础护理包",
		["Sentinel Standard Care Package"] = "哨兵标准护理包",
		["Separation Anxiety"] = "解除焦虑",
		["Serena Bloodfeather"] = "塞瑞娜·血羽",
		["Sergra Darkthorn"] = "瑟格拉·黑棘",
		["Serpent Wild"] = "狂热之蛇",
		["Serpentbloom"] = "毒蛇花",
		["Service to the Horde"] = "为部落效力",
		["Set Them Ablaze!"] = "烧掉它们！",
		["Setting Up the Bomb"] = "Setting Up the Bomb",
		["Shadow Magic"] = "暗影魔法",
		["Shadow of the Past"] = "往日的阴影",
		["Shadoweaver"] = "暗影蛛丝",
		["Shadowpine Weaponry"] = "Shadowpine Weaponry",
		["Shadowshard Fragments"] = "暗影残片",
		["Shadumbra's Head"] = "萨杜布拉的头颅",
		["Shaman Training"] = "萨满祭司训练",
		["Shard of a Felhound"] = "地狱犬的灵魂",
		["Shard of an Infernal"] = "地狱火的灵魂",
		["Shards of the Felvine"] = "魔藤碎片",
		["Shardtooth E'ko"] = "碎齿魂精",
		["Sharing the Knowledge"] = "分享知识",
		["Sharing the Land"] = "土地之争",
		["Sharptalon's Claw"] = "沙普塔隆的爪子",
		["Shatter Point"] = "破碎岗哨",
		["Shattering the Veil"] = "Shattering the Veil",
		["Shimmer Stout"] = "微光酒",
		["Ship Schedules"] = "船运时刻表",
		["Shipment to Stormwind"] = "送往暴风城的货物",
		["Shizz Work"] = "Shizz Work",
		["Shizzle's Flyer"] = "希兹尔的的飞行器",
		["Shoulderpads of Faith"] = "信仰肩垫",
		["Show Gnomercy"] = "绳侏儒以法",
		["Show Them Gnome Mercy!"] = "Show Them Gnome Mercy!",
		["Show Your Work"] = "工作成果",
		["Showdown"] = "Showdown",
		["Shredding Machines"] = "伐木机",
		["Shroud of Infinite Wisdom"] = "无尽智慧披风",
		["Shroud of Unspoken Names"] = "禁断邪语披风",
		["Shrouded in Nightmare"] = "梦魇的缠绕",
		["Shutting Down Manaforge Ara"] = "Shutting Down Manaforge Ara",
		["Shutting Down Manaforge B'naar"] = "Shutting Down Manaforge B'naar",
		["Shutting Down Manaforge Coruu"] = "合成法师装备1！",
		["Shutting Down Manaforge Duro"] = "Shutting Down Manaforge Duro",
		["Shy-Rotam"] = "希洛塔姆",
		["Sickle of Unyielding Strength"] = "坚定力量之镰",
		["Sigil of Arathor"] = "阿拉索符印",
		["Sigil of Strom"] = "激流堡符印",
		["Sigil of Thoradin"] = "索拉丁符印",
		["Sigil of Trollbane"] = "托尔贝恩符印",
		["Signal for Pickup"] = "信号发射器",
		["Signet of Unyielding Strength"] = "坚定力量之戒",
		["Signet of the Dukes"] = "公爵的徽记",
		["Signet of the Unseen Path"] = "隐秘通途之戒",
		["Signets of the Zandalar"] = "赞达拉的徽记",
		["Signs of the Legion"] = "Signs of the Legion",
		["Silkwing Cocoons"] = "Silkwing Cocoons",
		["Silver Heart"] = "银爪铁心",
		["Simple Letter"] = "简要的信件",
		["Simple Memorandum"] = "简易备忘录",
		["Simple Note"] = "简易便笺",
		["Simple Parchment"] = "简易羊皮纸",
		["Simple Rune"] = "简易符文",
		["Simple Scroll"] = "简易卷轴",
		["Simple Sigil"] = "简易符记",
		["Simple Subterfugin'"] = "国王的财宝",
		["Simple Tablet"] = "普通石板",
		["Since Time Forgotten..."] = "Since Time Forgotten...",
		["Singing Blue Shards"] = "歌唱水晶碎片",
		["Single Firewing Signet"] = "Single Firewing Signet",
		["Single Mark of Kil'jaeden"] = "Single Mark of Kil'jaeden",
		["Single Mark of Sargeras"] = "Single Mark of Sargeras",
		["Sister Pamela"] = "小妹妹帕米拉",
		["Situation at Sunsail Anchorage"] = "Situation at Sunsail Anchorage",
		["Skeletal Fragments"] = "骸骨碎片",
		["Skirmish at Echo Ridge"] = "回音山清剿行动",
		["Skulk Rock Clean-up"] = "清理隐匿石",
		["Skull Rock"] = "骷髅石",
		["Skullsplitter Tusks"] = "劈颅巨魔的獠牙",
		["Skymistress Gloaming"] = "葛拉米",
		["Slain by the Wretched"] = "Slain by the Wretched",
		["Slake That Thirst"] = "口渴的比格维兹",
		["Slaughter at Boulder'mok"] = "Slaughter at Boulder'mok",
		["Slay the Brood Mother"] = "Slay the Brood Mother",
		["Slaying the Beast"] = "饥饿者塔拉加曼",
		["Small Furry Paws"] = "毛茸茸的小爪子",
		["Smart Drinks"] = "智慧饮料",
		["Smith Mathiel"] = "铁匠玛希尔",
		["Smooth as Butter"] = "Smooth as Butter",
		["Snakestone of the Shadow Huntress"] = "沃什加斯的蛇石",
		["Snatch and Grab"] = "连偷带抢",
		["Snickerfang Jowls"] = "弯牙土狼的颚骨",
		["Soaked Pages"] = "Soaked Pages",
		["Socrethar's Shadow"] = "Socrethar's Shadow",
		["Soft Bushy Tails"] = "柔软的狼尾",
		["Solanian's Belongings"] = "索兰尼亚的物品",
		["Solomon's Law"] = "所罗门的律法",
		["Solution to Doom"] = "化解灾难",
		["Solving the Problem"] = "Solving the Problem",
		["Some Assembly Required"] = "收集鳄鱼皮",
		["Someone Else's Hard Work Pays Off"] = "Someone Else's Hard Work Pays Off",
		["Soothing Spices"] = "舒心草",
		["Soothing Turtle Bisque"] = "海龟汤",
		["Soulbound Keepsake"] = "禁锢灵魂的遗物",
		["Source of the Corruption"] = "Source of the Corruption",
		["Southsea Freebooters"] = "南海海盗",
		["Southsea Shakedown"] = "南海复仇",
		["Southshore"] = "南海镇",
		["Souvenirs of Death"] = "死亡的纪念品",
		["Spare Parts"] = "备用零件",
		["Spawn of Jubjub"] = "加布加布",
		["Speak to Nafien"] = "与纳菲恩交谈",
		["Speak to Salfa"] = "与萨尔法交谈",
		["Speak with Anastasia"] = "安娜斯塔西娅",
		["Speak with Bink"] = "和彬克交谈",
		["Speak with Coleman"] = "库勒曼",
		["Speak with Deino"] = "巨魔法师迪诺",
		["Speak with Dillinger"] = "迪林格尔",
		["Speak with Gramma"] = "托米的祖母",
		["Speak with Jennea"] = "Speak with Jennea",
		["Speak with Private Weeks"] = "Speak with Private Weeks",
		["Speak with Renferrel"] = "与伦弗利尔会面",
		["Speak with Rilak the Redeemed"] = "Speak with Rilak the Redeemed",
		["Speak with Ruga"] = "和鲁迦交谈",
		["Speak with Scout Neftis"] = "Speak with Scout Neftis",
		["Speak with Sevren"] = "与塞弗伦交谈",
		["Speak with Shoni"] = "沉默的舒尼",
		["Speak with Thun'grim"] = "和索恩格瑞姆交谈",
		["Speak with Un'thuwa"] = "安苏瓦",
		["Speaking of Fortitude"] = "关于坚韧的演讲",
		["Speaking with Gan'zulah"] = "甘祖拉恩",
		["Speaking with Nezzliok"] = "奈兹里奥克",
		["Special Delivery for Gaxim"] = "给加克希姆的特快专递",
		["Special Forces"] = "特种部队",
		["Spectrecles"] = "幽灵眼镜",
		["Spellfire Robes"] = "魔焰长袍",
		["Spinal Dust"] = "脊骨之尘",
		["Spinebreaker Post"] = "断背岗哨",
		["Spirit Calling"] = "灵魂召唤",
		["Spirit Totem"] = "灵魂图腾",
		["Spirit of the Boar"] = "野猪之魂",
		["Spirit of the Wind"] = "风之魂",
		["Spirits of the Drowned"] = "Spirits of the Drowned",
		["Spirits of the Feralfen"] = "Spirits of the Feralfen",
		["Spiritual Domination"] = "精神矍铄",
		["Spiritual Unrest"] = "永不安息的灵魂",
		["Spleendid!"] = "Spleendid!",
		["Split Bone Necklace"] = "裂骨项链",
		["Sporeggar"] = "孢子村",
		["Sprinkle's Secret Ingredient"] = "斯普琳科的秘密佐料",
		["Squire Maltrake"] = "侍卫玛特拉克",
		["Stalking the Stalkers"] = "银鬃捕猎者",
		["Stalwart's Battlegear"] = "忠诚者的装备",
		["Standards and Practices"] = "Standards and Practices",
		["Starfall"] = "星辰坠落",
		["Stave of the Ancients"] = "古树的手杖",
		["Stealing Back the Mushrooms"] = "Stealing Back the Mushrooms",
		["Stealing Knowledge"] = "偷窃知识",
		["Stealing Supplies"] = "偷取物资",
		["Stealing from Thieves"] = "Stealing from Thieves",
		["Stealth Flight"] = "隐秘飞行",
		["Steelsnap"] = "钢齿土狼",
		["Stepping Up Security"] = "确保安全",
		["Still Believing"] = "更多的读物",
		["Stillpine Hold"] = "止松要塞",
		["Sting of the Scorpid"] = "工蝎的尾巴",
		["Stinger Venom"] = "Stinger Venom",
		["Stinging the Stingers"] = "Stinging the Stingers",
		["Stinglasher"] = "毒刺鞭笞者",
		["Stinking Up Southshore"] = "Stinking Up Southshore",
		["Stinky's Escape"] = "伊格纳兹的逃亡",
		["Stocking Jetsteam"] = "贝尔丁的补给",
		["Stolen Booty"] = "被窃的货物",
		["Stolen Silver"] = "被偷走的银币",
		["Stoley's Debt"] = "斯杜雷的债务",
		["Stoley's Shipment"] = "斯杜雷的货物",
		["Stone Tokens"] = "石雕",
		["Stonegear's Search"] = "迪恩·石轮的梦想",
		["Stones of Binding"] = "禁锢之石",
		["Stonetalon Standstill"] = "石爪山的困境",
		["Stopping the Spread"] = "Stopping the Spread",
		["Stormers and Rumblers"] = "雷暴和磐石",
		["Stormpike's Deciphering"] = "解码高手",
		["Stormpike's Delivery"] = "雷矛的包裹",
		["Stormpike's Order"] = "卡尔·雷矛的订单",
		["Stormwind Ho!"] = "升官之道",
		["Stormwind Library"] = "暴风城图书馆",
		["Stormwind Rendezvous"] = "集合在暴风城",
		["Stout to Kadrell"] = "卡德雷尔的酒",
		["Strained Supplies"] = "Strained Supplies",
		["Strange Alliance"] = "奇怪的联盟",
		["Strange Brew"] = "Strange Brew",
		["Strange Energy"] = "Strange Energy",
		["Strange Findings"] = "奇怪的发现",
		["Strange Sources"] = "奇怪的源头",
		["Stranglethorn Fever"] = "荆棘谷热疫",
		["Strength of One"] = "Strength of One",
		["Striker's Diadem"] = "攻击者的王冠",
		["Striker's Footguards"] = "攻击者的足甲",
		["Striker's Hauberk"] = "攻击者的护甲",
		["Stromgarde Badges"] = "激流堡徽章",
		["Study of the Elements: Rock"] = "研究石元素",
		["Stymying the Arakkoa"] = "Stymying the Arakkoa",
		["Success!"] = "Success!",
		["Sully Balloo's Letter"] = "苏利·巴鲁的信",
		["Summon Felsteed"] = "召唤地狱战马",
		["Summoner Kanthin's Prize"] = "Summoner Kanthin's Prize",
		["Summoning Shadra"] = "召唤沙德拉",
		["Summoning the Princess"] = "召唤大地公主",
		["Summons from Knight-Lord Bloodvalor"] = "Summons from Knight-Lord Bloodvalor",
		["Suncrown Village"] = "日冕村",
		["Sunfury Briefings"] = "Sunfury Briefings",
		["Sunfury Signets"] = "Sunfury Signets",
		["Sunken Treasure"] = "水下宝藏",
		["Sunscorched Shells"] = "晒焦的蛋壳",
		["Suntara Stones"] = "苏塔拉之石",
		["Super Reaper 6000"] = "超级收割机6000",
		["Super Sticky"] = "极度粘稠的沥青",
		["Superior Armaments of Battle - Exalted Amongst the Dawn"] = "精良的作战装备 - 银色黎明崇拜",
		["Superior Armaments of Battle - Friend of the Dawn"] = "精良的作战装备 - 银色黎明友善",
		["Superior Armaments of Battle - Honored Amongst the Dawn"] = "精良的作战装备 - 银色黎明尊敬",
		["Superior Armaments of Battle - Revered Amongst the Dawn"] = "精良的作战装备 - 银色黎明崇敬",
		["Supervisor Fizsprocket"] = "菲兹普罗克主管",
		["Supplies for Nethergarde"] = "守望堡的物资",
		["Supplies for the Crossroads"] = "十字路口的补给品",
		["Supplies from Darkshire"] = "来自夜色镇的货物",
		["Supplies to Auberdine"] = "奥伯丁的补给品",
		["Supplies to Private Thorsen"] = "列兵索尔森的补给物资",
		["Supplies to Tannok"] = "塔诺克的补给品",
		["Supply and Demand"] = "供与求",
		["Supplying the Front"] = "前线的补给",
		["Supplying the Sepulcher"] = "瑟伯切尔的补给",
		["Surena Caledon"] = "苏伦娜·凯尔东",
		["Surrender to the Horde"] = "Surrender to the Horde",
		["Survey the Land"] = "Survey the Land",
		["Surveying the Ruins"] = "Surveying the Ruins",
		["Suspicious Hoofprints"] = "可疑的蹄印",
		["Sven's Camp"] = "斯温的营地",
		["Sven's Revenge"] = "斯温的复仇",
		["Sweet Amber"] = "琥珀酒",
		["Sweet Serenity"] = "甜美的平静",
		["Swift Discipline"] = "Swift Discipline",
		["Swoop Hunting"] = "猎捕猛鹫",
		["Syndicate Assassins"] = "辛迪加刺客",
		["Syndicate Emblems"] = "辛迪加徽章",
		["Synthesis of Power"] = "Synthesis of Power",
		["Tabards of the Illidari"] = "Tabards of the Illidari",
		["Tabetha's Task"] = "塔贝萨的任务",
		["Tablet of the Seven"] = "七贤石板",
		["Tablets of Baa'ri"] = "巴尔里石板",
		["Tainted Arcane Sliver"] = "被污染的奥术薄片",
		["Tainted Letter"] = "被污染的信件",
		["Tainted Memorandum"] = "被污染的备忘录",
		["Tainted Parchment"] = "被污染的羊皮纸",
		["Tainted Scroll"] = "被污染的卷轴",
		["Take Five Bases"] = "夺取五座基地",
		["Take Four Bases"] = "夺取四座基地",
		["Taken in the Night"] = "Taken in the Night",
		["Taking Back Silithus"] = "夺回希利苏斯",
		["Taking the Fall"] = "Taking the Fall",
		["Tal the Wind Rider Master"] = "双足飞龙管理员塔尔",
		["Talbuk Mastery"] = "Talbuk Mastery",
		["Talk to the Hand"] = "Talk to the Hand",
		["Taming the Beast"] = "驯服野兽",
		["Tanaris Field Sampling"] = "塔纳利斯的样本",
		["Taretha's Gift"] = "塔蕾莎的礼物",
		["Target: Dalson's Tears"] = "目标：达尔松之泪",
		["Target: Felstone Field"] = "目标：费尔斯通农场",
		["Target: Gahrron's Withering"] = "目标：盖罗恩农场",
		["Target: Hive'Ashi Defenders"] = "目标：亚什工蝎",
		["Target: Hive'Ashi Sandstalkers"] = "目标：亚什沙行者",
		["Target: Hive'Ashi Stingers"] = "目标：亚什毒蝎",
		["Target: Hive'Ashi Workers"] = "目标：亚什工蝎",
		["Target: Hive'Regal Ambushers"] = "目标：雷戈伏击者",
		["Target: Hive'Regal Burrowers"] = "目标：雷戈掘洞者",
		["Target: Hive'Regal Slavemakers"] = "目标：雷戈制奴者",
		["Target: Hive'Regal Spitfires"] = "目标：雷戈喷火者",
		["Target: Hive'Zora Hive Sisters"] = "目标：佐拉雌蝎",
		["Target: Hive'Zora Reavers"] = "目标：佐拉掠夺者",
		["Target: Hive'Zora Tunnelers"] = "目标：佐拉坑道蝎",
		["Target: Hive'Zora Waywatchers"] = "目标：佐拉守卫",
		["Target: Writhing Haunt"] = "目标：嚎哭鬼屋",
		["Tear of the Earthmother"] = "大地之母的眼泪",
		["Tears of the Moon"] = "月神的泪水",
		["Teldrassil"] = "泰达希尔",
		["Teleport This!"] = "Teleport This!",
		["Tenaron's Summons"] = "特纳隆的召唤",
		["Terokk's Legacy"] = "Terokk's Legacy",
		["Terokkarantula"] = "泰罗卡狼蛛",
		["Teron Gorefiend - Lore and Legend"] = "Teron Gorefiend - Lore and Legend",
		["Test Flight: Razaan's Landing"] = "Test Flight: Razaan's Landing",
		["Test Flight: Ruuan Weald"] = "Test Flight: Ruuan Weald",
		["Test Flight: The Singing Ridge"] = "Test Flight: The Singing Ridge",
		["Test Flight: The Zephyrium Capacitorium"] = "Test Flight: The Zephyrium Capacitorium",
		["Test of Endurance"] = "耐力的试炼",
		["Test of Faith"] = "信仰的试炼",
		["Test of Lore"] = "知识试炼",
		["Test of Strength"] = "力量的试炼",
		["Testing an Enemy's Strength"] = "试探敌人",
		["Testing for Corruption - Felwood"] = "堕落检测 - 费伍德森林",
		["Testing for Impurities - Un'Goro Crater"] = "杂质检测 - 安戈洛环形山",
		["Testing the Antidote"] = "Testing the Antidote",
		["Testing the Prototype"] = "测试原型",
		["Testing the Tonic"] = "Testing the Tonic",
		["Testing the Vessel"] = "测试容器",
		["Thadius Grimshade"] = "萨迪斯·格希德",
		["Thalanaar Delivery"] = "萨兰纳尔的货物",
		["Tharil'zun"] = "萨瑞尔祖恩",
		["Tharnariun's Hope"] = "萨纳瑞恩的希望",
		["That Little Extra Kick"] = "一点添加剂",
		["That's Asking A Lot"] = "狮子大开口",
		["Thazz'ril's Pick"] = "塔兹利尔的镐",
		["The Absent Minded Prospector"] = "健忘的勘察员",
		["The Active Agent"] = "活跃的探子",
		["The Admiral's Orders"] = "将军的命令",
		["The Affray"] = "格斗考验",
		["The Agitated Ancestors"] = "The Agitated Ancestors",
		["The Agony and the Darkness"] = "The Agony and the Darkness",
		["The Algaz Gauntlet"] = "丹奥加兹告急",
		["The All-Seeing Eye of Zuldazar"] = "祖达萨全视之眼",
		["The Alliance Needs Iron Bars!"] = "The Alliance Needs Iron Bars!",
		["The Alliance Needs Light Leather!"] = "The Alliance Needs Light Leather!",
		["The Alliance Needs Linen Bandages!"] = "联盟需要亚麻绷带！",
		["The Alliance Needs Medium Leather!"] = "The Alliance Needs Medium Leather!",
		["The Alliance Needs More Copper Bars!"] = "The Alliance Needs More Copper Bars!",
		["The Alliance Needs More Linen Bandages!"] = "联盟需要更多亚麻绷带！",
		["The Alliance Needs More Medium Leather!"] = "The Alliance Needs More Medium Leather!",
		["The Alliance Needs More Silk Bandages!"] = "The Alliance Needs More Silk Bandages!",
		["The Alliance Needs More Spotted Yellowtail!"] = "The Alliance Needs More Spotted Yellowtail!",
		["The Alliance Needs More Thorium Bars!"] = "The Alliance Needs More Thorium Bars!",
		["The Alliance Needs Runecloth Bandages!"] = "The Alliance Needs Runecloth Bandages!",
		["The Alliance Needs Silk Bandages!"] = "The Alliance Needs Silk Bandages!",
		["The Alliance Needs Spotted Yellowtail!"] = "The Alliance Needs Spotted Yellowtail!",
		["The Altar of Zul"] = "祖尔祭坛",
		["The Ancient Egg"] = "远古之卵",
		["The Ancient Leaf"] = "远古石叶",
		["The Ancient Statuette"] = "远古雕像",
		["The Angry Scytheclaws"] = "狂暴的镰爪龙",
		["The Annals of Darrowshire"] = "达隆郡的历史",
		["The Annals of Kirin'Var"] = "The Annals of Kirin'Var",
		["The Apes of Un'Goro"] = "安戈洛的猩猩",
		["The Apple Falls"] = "詹诺克的花",
		["The Arakkoa Threat"] = "The Arakkoa Threat",
		["The Arcanist's Cookbook"] = "奥法师的食谱",
		["The Archivist"] = "档案管理员",
		["The Archmage's Staff"] = "The Archmage's Staff",
		["The Argent Hold"] = "银色黎明宝箱",
		["The Art of Fel Reaver Maintenance"] = "魔能机甲维修窍门大全",
		["The Art of the Armorsmith"] = "铸造护甲的艺术",
		["The Art of the Imbue"] = "The Art of the Imbue",
		["The Ashenvale Hunt"] = "灰谷狩猎",
		["The Ashtongue Broken"] = "The Ashtongue Broken",
		["The Ashtongue Corruptors"] = "The Ashtongue Corruptors",
		["The Ashtongue Tribe"] = "The Ashtongue Tribe",
		["The Assassin"] = "The Assassin",
		["The Atal'ai Exile"] = "阿塔莱流放者",
		["The Attack!"] = "伏击！",
		["The Azure Key"] = "碧蓝钥匙",
		["The Bait for Lar'korwi"] = "拉克维的诱饵",
		["The Balance of Light and Shadow"] = "光与影的平衡",
		["The Balance of Nature"] = "自然的平衡",
		["The Balnir Farmstead"] = "巴尼尔农场",
		["The Barrens Oases"] = "贫瘠之地的绿洲",
		["The Barrens Port"] = "贫瘠之地的港口",
		["The Basilisk's Bite"] = "石化蜥蜴的大脑",
		["The Battle Horn"] = "The Battle Horn",
		["The Battle Plans"] = "作战计划",
		["The Battle of Alterac"] = "奥特兰克的战斗",
		["The Battle of Darrowshire"] = "达隆郡的战斗",
		["The Battleboars"] = "斗猪",
		["The Bear Necessities"] = "The Bear Necessities",
		["The Bearer of Bad News"] = "糟糕的消息",
		["The Befouled Element"] = "被污染的水元素",
		["The Best Defense"] = "The Best Defense",
		["The Big Bone Worm"] = "The Big Bone Worm",
		["The Biggest of Them All"] = "The Biggest of Them All",
		["The Binding"] = "誓缚",
		["The Black Morass"] = "黑色沼泽",
		["The Black Shield"] = "黑色盾牌",
		["The Blackwood Corrupted"] = "黑木熊怪的堕落",
		["The Bladespire Ogres"] = "The Bladespire Ogres",
		["The Bladespire Threat"] = "The Bladespire Threat",
		["The Blightcaller Cometh"] = "凋零者",
		["The Blood Elves"] = "血精灵",
		["The Blood is Life"] = "The Blood is Life",
		["The Blood-Tempered Ranseur"] = "The Blood-Tempered Ranseur",
		["The Bloodcurse Legacy"] = "The Bloodcurse Legacy",
		["The Bloodcursed Naga"] = "The Bloodcursed Naga",
		["The Bloodmaul Ogres"] = "The Bloodmaul Ogres",
		["The Bloodsail Buccaneers"] = "血帆海盗",
		["The Boar Hunter"] = "猎杀野猪",
		["The Boha'mu Ruins"] = "The Boha'mu Ruins",
		["The Book of Fel Names"] = "恶魔名册",
		["The Book of Ur"] = "乌尔之书",
		["The Borrower"] = "海龟照片",
		["The Bounty of Teldrassil"] = "泰达希尔的渔业",
		["The Branch of Cenarius"] = "塞纳留斯的树枝",
		["The Brassbolts Brothers"] = "防撞头盔",
		["The Broken Sigil"] = "破碎的符印",
		["The Brood of Onyxia"] = "奥妮克希亚的血脉",
		["The Call to Command"] = "上级的命令",
		["The Calling"] = "召唤",
		["The Caravan Road"] = "商队通路",
		["The Carevin Family"] = "卡尔文家族",
		["The Caverns of Time"] = "The Caverns of Time",
		["The Cenarion Expedition"] = "The Cenarion Expedition",
		["The Challenge"] = "挑战",
		["The Champion of the Banshee Queen"] = "女妖之王的勇士",
		["The Champion of the Horde"] = "部落的勇士",
		["The Changing of Paths - Conqueror No More"] = "The Changing of Paths - Conqueror No More",
		["The Changing of Paths - Protector No More"] = "The Changing of Paths - Protector No More",
		["The Charge of the Dragonflights"] = "守护之龙",
		["The Chill of Death"] = "死亡之寒",
		["The Cipher of Damnation"] = "诅咒密码",
		["The Cipher of Damnation - Ar'tor's Charge"] = "The Cipher of Damnation - Ar'tor's Charge",
		["The Cipher of Damnation - Borak's Charge"] = "诅咒密码 - 伯拉克的命令",
		["The Cipher of Damnation - Grom'tor's Charge"] = "The Cipher of Damnation - Grom'tor's Charge",
		["The Cipher of Damnation - The First Fragment Recovered"] = "The Cipher of Damnation - The First Fragment Recovered",
		["The Cipher of Damnation - The Second Fragment Recovered"] = "The Cipher of Damnation - The Second Fragment Recovered",
		["The Cipher of Damnation - The Third Fragment Recovered"] = "The Cipher of Damnation - The Third Fragment Recovered",
		["The Cipher of Damnation - Truth and History"] = "The Cipher of Damnation - Truth and History",
		["The Cliffspring River"] = "壁泉河",
		["The Coast Isn't Clear"] = "清理海岸",
		["The Coastal Menace"] = "海岸上的威胁",
		["The Codex of Blood"] = "The Codex of Blood",
		["The Collector"] = "收货人",
		["The Color of Blood"] = "鲜血的颜色",
		["The Completed Orb of Dar'Orahil"] = "达奥拉赫宝珠",
		["The Completed Orb of Noh'Orahil"] = "诺奥拉赫宝珠",
		["The Completed Robe"] = "完成金线血袍",
		["The Consortium Needs You!"] = "The Consortium Needs You!",
		["The Corpulent One"] = "肥大的食腐虫",
		["The Corrupter"] = "堕落者",
		["The Corruption Abroad"] = "遥远的旅途",
		["The Corruption of the Jadefire"] = "碧火萨特",
		["The Count of the Marshes"] = "The Count of the Marshes",
		["The Cover of Darkness"] = "黑暗笼罩",
		["The Crimson Courier"] = "红衣信使",
		["The Crone of the Kraul"] = "卡尔加·刺肋",
		["The Crown of Will"] = "意志之冠",
		["The Cryo-Core"] = "冷却核心",
		["The Crystal of Zin-Malor"] = "辛玛洛水晶",
		["The Curious Visitor"] = "好奇的访客",
		["The Curse of the Tides"] = "海潮的诅咒",
		["The Cursed Crew"] = "被诅咒的船员",
		["The Damned"] = "被诅咒者",
		["The Dark Iron War"] = "黑铁战争",
		["The Dark Missive"] = "The Dark Missive",
		["The Darkmoon Faire"] = "暗月马戏团",
		["The Darkreaver Menace"] = "达克雷尔的威胁",
		["The Darkstone Tablet"] = "黑暗石板",
		["The Daughter Who Lived"] = "幸存的女儿",
		["The Day After"] = "灾难之后",
		["The Dead Fields"] = "亡者农场",
		["The Dead Mire"] = "死亡泥潭",
		["The Dead Scar"] = "死亡之痕",
		["The Deathforge"] = "死亡熔炉",
		["The Deathstalkers"] = "亡灵哨兵",
		["The Deathstalkers' Report"] = "亡灵哨兵的报告",
		["The Decisive Striker"] = "决定性的打击",
		["The Decrepit Ferry"] = "破旧渡口",
		["The Defense of Grom'gol"] = "格罗姆高保卫战",
		["The Defias Brotherhood"] = "迪菲亚兄弟会",
		["The Demon Forge"] = "恶魔熔炉",
		["The Demon Hunter"] = "恶魔猎手",
		["The Demon Scarred Cloak"] = "恶魔之伤",
		["The Demon Seed"] = "恶魔之种",
		["The Demoniac Scryer"] = "The Demoniac Scryer",
		["The Den"] = "大兽穴",
		["The Den Mother"] = "The Den Mother",
		["The Deserter"] = "沙漠隐士",
		["The Deserters"] = "背叛者",
		["The Disgraced One"] = "悔恨的战士",
		["The Disruption Ends"] = "野猪人的头目",
		["The Divination"] = "占卜",
		["The Divination Scryer"] = "预言水晶球",
		["The Doomed Fleet"] = "被诅咒的舰队",
		["The Dormant Shade"] = "潜伏的阴影",
		["The Dragon's Eye"] = "巨龙之眼",
		["The Dread Citadel - Naxxramas"] = "恐怖之城，纳克萨玛斯",
		["The Dread Relic"] = "The Dread Relic",
		["The Dreghood Elders"] = "The Dreghood Elders",
		["The Dunemaul Compound"] = "砂槌食人魔",
		["The Dwarven Spy"] = "The Dwarven Spy",
		["The Dying Balance"] = "The Dying Balance",
		["The Dynamic Duo"] = "The Dynamic Duo",
		["The Earthbinder"] = "The Earthbinder",
		["The Eastern Kingdoms"] = "东部王国",
		["The Eastern Plagues"] = "东部的瘟疫",
		["The Eastern Pylon"] = "东部水晶塔",
		["The Ectoplasmic Distiller"] = "灵质提纯器",
		["The Eighteenth Pilot"] = "第十八个驾驶员",
		["The Elder Crone"] = "长者",
		["The Elemental Equation"] = "元素交易",
		["The Elusive Ironjaw"] = "The Elusive Ironjaw",
		["The Emerald Dream..."] = "翡翠梦境……",
		["The Emerald Dreamcatcher"] = "翡翠摄梦符",
		["The Emitter"] = "图像发射器",
		["The Enchanted Glade"] = "神谕林地",
		["The Encroaching Wilderness"] = "The Encroaching Wilderness",
		["The Engraved Ring"] = "黛丽娅的戒指",
		["The Ensorcelled Parchment"] = "附有魔法的羊皮纸",
		["The Escape"] = "梅贝尔的隐形水",
		["The Essence of Aku'Mai"] = "阿库麦尔水晶",
		["The Essence of Eranikus"] = "伊兰尼库斯精华",
		["The Ethereum"] = "The Ethereum",
		["The Everlook Report"] = "永望镇报告",
		["The Everstill Bridge"] = "止水湖上的桥",
		["The Exorcism"] = "驱除魔鬼",
		["The Exorcism of Colonel Jules"] = "The Exorcism of Colonel Jules",
		["The Eye of Paleth"] = "帕雷斯之眼",
		["The Eyes of Grillok"] = "The Eyes of Grillok",
		["The Eyes of Skettis"] = "The Eyes of Skettis",
		["The Fall of Ameth'Aran"] = "亚米萨兰的毁灭",
		["The Fall of Kel'Thuzad"] = "克尔苏加德的末日",
		["The Fall of Ossirian"] = "The Fall of Ossirian",
		["The Fallen Courier"] = "The Fallen Courier",
		["The Fallen Exarch"] = "The Fallen Exarch",
		["The Family Crypt"] = "家族墓穴",
		["The Family and the Fishing Pole"] = "钓鱼世家",
		["The Fare of Lar'korwi"] = "拉克维的食物",
		["The Fargodeep Mine"] = "法戈第矿洞",
		["The Farstrider Enclave"] = "The Farstrider Enclave",
		["The Fate of Flanis"] = "The Fate of Flanis",
		["The Fate of Kagrosh"] = "The Fate of Kagrosh",
		["The Fate of Ramaladni"] = "拉玛兰迪的命运",
		["The Fate of Tuurem"] = "The Fate of Tuurem",
		["The Fate of Yenniku"] = "耶尼库的命运",
		["The Fate of the Kingdom"] = "王国的命运",
		["The Feast of Winter Veil"] = "冬幕大餐",
		["The Fel and the Furious"] = "The Fel and the Furious",
		["The Final Code"] = "终极密码",
		["The Final Message to the Wildhammer"] = "给蛮锤部族的最后警告",
		["The Final Piece"] = "最后一片",
		["The Final Reagents"] = "The Final Reagents",
		["The Final Sample"] = "The Final Sample",
		["The Final Tablets"] = "最后的石板",
		["The Finest Down"] = "The Finest Down",
		["The Firewing Liaison"] = "The Firewing Liaison",
		["The Firewing Point Project"] = "The Firewing Point Project",
		["The First Trial"] = "The First Trial",
		["The First and the Last"] = "第一个和最后一个",
		["The Flame's Casing"] = "烈焰之盒",
		["The Flawless Flame"] = "无瑕之焰",
		["The Flesh Does Not Lie"] = "血肉不会撒谎",
		["The Flesh Lies..."] = "The Flesh Lies...",
		["The Foot of the Citadel"] = "The Foot of the Citadel",
		["The Force of Neltharaku"] = "The Force of Neltharaku",
		["The Forging of Quel'Serrar"] = "铸造奎尔塞拉",
		["The Forgotten Heirloom"] = "遗失的怀表",
		["The Forgotten Pools"] = "遗忘之池",
		["The Formation of Felbane"] = "武器的铸造",
		["The Forsaken"] = "The Forsaken",
		["The Four Dukes"] = "四个公爵",
		["The Fragments Within"] = "水晶中的碎骨",
		["The Fury Runs Deep"] = "卡姆·深怒",
		["The Giant Guardian"] = "大保姆",
		["The Glowing Fruit"] = "发光的水果",
		["The Glowing Shard"] = "发光的碎片",
		["The God Hakkar"] = "神灵哈卡",
		["The Good Stuff"] = "好东西",
		["The Gordok Ogre Suit"] = "戈多克食人魔装",
		["The Gordok Taste Test"] = "戈多克好酒",
		["The Gordunni Orb"] = "戈杜尼宝珠",
		["The Gordunni Scroll"] = "戈杜尼卷轴",
		["The Grand Betrayal"] = "大叛徒",
		["The Great Fissure"] = "大裂隙",
		["The Great Fras Siabi"] = "弗拉斯·希亚比",
		["The Great Masquerade"] = "潜藏者",
		["The Great Moongraze Hunt"] = "狩猎月痕鹿",
		["The Great Retribution"] = "The Great Retribution",
		["The Great Silver Deceiver"] = "The Great Silver Deceiver",
		["The Greatest Race of Hunters"] = "最伟大的猎手",
		["The Green Drake"] = "神庙中的绿龙",
		["The Green Hills of Stranglethorn"] = "荆棘谷的青山",
		["The Greenwarden"] = "绿色守卫者",
		["The Grizzled Den"] = "灰色洞穴",
		["The Guns of Northwatch"] = "北方城堡的火炮",
		["The Hammer May Fall"] = "落锤之战",
		["The Hand of Gul'dan"] = "古尔丹之手",
		["The Hand of Rastakhan"] = "拉斯塔哈之手",
		["The Hand of the Righteous"] = "正义之手",
		["The Harvester"] = "收割者",
		["The Haunted Isle"] = "幽灵岛",
		["The Haunted Mills"] = "闹鬼的磨坊",
		["The Head of the Beast"] = "禽兽的首级",
		["The Heart of Darkness"] = "The Heart of Darkness",
		["The Heart of the Mountain"] = "山脉之心",
		["The Hermit"] = "隐士",
		["The Hidden Chamber"] = "密室",
		["The Hidden Key"] = "隐藏的钥匙",
		["The Hidden Niche"] = "密室",
		["The High Wilderness"] = "高原荒野",
		["The Hopeless Ones..."] = "The Hopeless Ones...",
		["The Horde Needs Firebloom!"] = "部落需要火焰花！",
		["The Horde Needs Heavy Leather!"] = "部落需要重皮！",
		["The Horde Needs Mithril Bars!"] = "部落需要秘银锭！",
		["The Horde Needs More Mageweave Bandages!"] = "The Horde Needs More Mageweave Bandages!",
		["The Horde Needs More Mithril Bars!"] = "The Horde Needs More Mithril Bars!",
		["The Horde Needs More Peacebloom!"] = "The Horde Needs More Peacebloom!",
		["The Horde Needs More Purple Lotus!"] = "The Horde Needs More Purple Lotus!",
		["The Horde Needs More Rugged Leather!"] = "The Horde Needs More Rugged Leather!",
		["The Horde Needs More Runecloth Bandages!"] = "The Horde Needs More Runecloth Bandages!",
		["The Horde Needs More Spotted Yellowtail!"] = "The Horde Needs More Spotted Yellowtail!",
		["The Horde Needs More Thick Leather!"] = "The Horde Needs More Thick Leather!",
		["The Horde Needs Peacebloom!"] = "部落需要宁神花！",
		["The Horde Needs Purple Lotus!"] = "部落需要紫莲花！",
		["The Horde Needs Rugged Leather!"] = "部落需要硬甲皮！",
		["The Horde Needs Runecloth Bandages!"] = "部落需要符文布绷带！",
		["The Horde Needs Spotted Yellowtail!"] = "部落需要斑点黄尾鱼！",
		["The Horde Needs Thick Leather!"] = "部落需要厚皮！",
		["The Horde Needs Tin Bars!"] = "部落需要锡锭！",
		["The Horde Needs Wool Bandages!"] = "部落需要绒线绷带！",
		["The Horn of the Beast"] = "玛尔戈的巨角",
		["The Horrors of Pollution"] = "The Horrors of Pollution",
		["The Hound-Master"] = "The Hound-Master",
		["The Howling Vale"] = "狼嚎谷",
		["The Howling Wind"] = "The Howling Wind",
		["The Hunt Begins"] = "开始狩猎",
		["The Hunt Completed"] = "完成狩猎",
		["The Hunt Continues"] = "继续狩猎",
		["The Hunter's Charm"] = "猎人的护符",
		["The Hunter's Way"] = "猎人之道",
		["The Ice Guard"] = "寒冰戒卫",
		["The Ichor of Undeath"] = "亡灵的腐液",
		["The Impotent Leader"] = "The Impotent Leader",
		["The Inconsolable Chieftain"] = "The Inconsolable Chieftain",
		["The Infernal Orb"] = "地狱火宝珠",
		["The Infested Protectors"] = "The Infested Protectors",
		["The Instigator's Enchantment"] = "旗帜上的附魔",
		["The Ironforge Brigade Needs Explosives!"] = "铁炉堡军团需要爆炸品！",
		["The Islander"] = "岛民",
		["The Isle of Dread!"] = "恐怖之岛！",
		["The Jasperlode Mine"] = "玉石矿洞",
		["The Jeremiah Blues"] = "杰雷米亚的忧伤",
		["The Jewel of Kajaro"] = "卡亚罗的珠宝",
		["The Karnitol Shipwreck"] = "卡尼托的海难",
		["The Kessel Run"] = "The Kessel Run",
		["The Key to Freedom"] = "自由的钥匙",
		["The Killing Fields"] = "清理荒野",
		["The Knife Revealed"] = "奎恩提斯的技艺",
		["The Kolkar of Desolace"] = "凄凉之地的科卡尔部族",
		["The Kurken is Lurkin'"] = "The Kurken is Lurkin'",
		["The Kurken's Hide"] = "库肯的毛皮",
		["The Last Barov"] = "巴罗夫的继承人",
		["The Last Element"] = "最后的元素",
		["The Left Piece of Lord Valthalak's Amulet"] = "瓦塔拉克饰品的左瓣",
		["The Legend of Stalvan"] = "斯塔文的传说",
		["The Legion Reborn"] = "The Legion Reborn",
		["The Lexicon Demonica"] = "The Lexicon Demonica",
		["The Lich's Identity"] = "巫妖的身份",
		["The Light and How To Swing It"] = "圣光之力",
		["The Longbeards"] = "The Longbeards",
		["The Lord of Blackrock"] = "黑石之王",
		["The Lost Caravan"] = "丢失的货物",
		["The Lost Chalice"] = "失落的圣杯",
		["The Lost Dwarves"] = "失踪的矮人",
		["The Lost Fragments"] = "遗失的卷轴碎片",
		["The Lost Ingots"] = "丢失的铁锭",
		["The Lost Pages"] = "丢失的书页",
		["The Lost Pilot"] = "失踪的驾驶员",
		["The Lost Report"] = "遗失的报告",
		["The Lost Supplies"] = "遗失的补给品",
		["The Lost Tablets of Mosh'aru"] = "失落的摩沙鲁石板",
		["The Lost Tablets of Will"] = "意志石板",
		["The Lost Tools"] = "丢失的工具",
		["The Love Potion"] = "爱情药水",
		["The Madness Within"] = "伊莫塔尔的疯狂",
		["The Mag'har"] = "The Mag'har",
		["The Magister's Apprentice"] = "The Magister's Apprentice",
		["The Main Course!"] = "The Main Course!",
		["The Mark of Quality"] = "质量的保证",
		["The Mark of the Lightbringer"] = "光明使者的印记",
		["The Master Planner"] = "The Master Planner",
		["The Master's Glaive"] = "主宰之剑",
		["The Master's Grand Design?"] = "The Master's Grand Design?",
		["The Master's Touch"] = "The Master's Touch",
		["The Mastermind"] = "The Mastermind",
		["The Matron Protectorate"] = "监护者",
		["The Medallion of Faith"] = "信仰奖章",
		["The Mighty U'cha"] = "强大的尤尔查",
		["The Mills Overrun"] = "磨坊告急",
		["The Mind's Eye"] = "心灵之眼",
		["The Mindless Ones"] = "无脑的僵尸",
		["The Minions of Culuthas"] = "The Minions of Culuthas",
		["The Missing Courier"] = "失踪的信使",
		["The Missing Diplomat"] = "失踪的使节",
		["The Missing Expedition"] = "The Missing Expedition",
		["The Missing Fisherman"] = "失踪的渔夫",
		["The Missing Merchant"] = "The Missing Merchant",
		["The Missing Orders"] = "丢失的命令",
		["The Missing Scout"] = "失踪的斥候",
		["The Missing Shipment"] = "丢失的货物",
		["The Missing Survey Team"] = "The Missing Survey Team",
		["The Missing War Party"] = "The Missing War Party",
		["The Mistress Revealed"] = "The Mistress Revealed",
		["The Mithril Kid"] = "秘银小子",
		["The Mithril Order"] = "秘银会",
		["The Molten Core"] = "熔火之心",
		["The Monogrammed Sash"] = "刺着字母的腰带",
		["The Morrow Stone"] = "晨光石",
		["The Moss-twined Heart"] = "布满苔藓的心脏",
		["The Mystery of Morrowgrain"] = "晨光麦的秘密",
		["The Name of the Beast"] = "恶魔之名",
		["The Nesingwary Safari"] = "The Nesingwary Safari",
		["The New Frontier"] = "新的边疆",
		["The New Springs"] = "新的泉水",
		["The Newest Member of the Family"] = "新的生命",
		["The Night Watch"] = "守夜人",
		["The Northern Pylon"] = "北部水晶塔",
		["The Ogre Threat"] = "The Ogre Threat",
		["The Ogres of Feralas"] = "菲拉斯的食人魔",
		["The Old Ways"] = "古老的技艺",
		["The Only Cure is More Green Glow"] = "更多的辐射尘！",
		["The Only Prescription"] = "唯一的方案",
		["The Only Song I Know..."] = "我只会唱这一首歌……",
		["The Opening of the Dark Portal"] = "The Opening of the Dark Portal",
		["The Orb of Soran'ruk"] = "索兰鲁克宝珠",
		["The Orc Report"] = "兽人的报告",
		["The Orebor Harborage"] = "The Orebor Harborage",
		["The Orgrimmar Legion Needs Mojo!"] = "奥格瑞玛军团需要魔精！",
		["The Origins of Smithing"] = "锻造的本源",
		["The Outcast's Plight"] = "The Outcast's Plight",
		["The Pack Mistress"] = "座狼的首领",
		["The Pariah's Instructions"] = "贱民的指引",
		["The Party Never Ends"] = "The Party Never Ends",
		["The Path of Anguish"] = "苦痛之路",
		["The Path of Conquest"] = "征服之路",
		["The Path of Glory"] = "荣耀之路",
		["The Path of the Adept"] = "The Path of the Adept",
		["The Path of the Righteous"] = "正义之路",
		["The People's Militia"] = "西部荒野人民军",
		["The Perfect Poison"] = "完美的毒药",
		["The Perfect Stout"] = "完美烈酒",
		["The Plagued Coast"] = "The Plagued Coast",
		["The Platinum Discs"] = "白金圆盘",
		["The Pledge of Secrecy"] = "保密协议",
		["The Pools of Aggonar"] = "The Pools of Aggonar",
		["The Power to Destroy..."] = "毁灭之力",
		["The Powers Below"] = "深渊之神",
		["The Price of Shoes"] = "马掌",
		["The Princess Saved?"] = "拯救公主？",
		["The Princess Trapped"] = "被困的公主",
		["The Princess's Surprise"] = "语出惊人的公主",
		["The Principal Source"] = "毒水之源",
		["The Prison's Bindings"] = "监牢之链",
		["The Prison's Casing"] = "监牢之壁",
		["The Prodigal Lich"] = "流浪的巫妖",
		["The Prodigal Lich Returns"] = "巫妖归顺",
		["The Prophecy of Akida"] = "The Prophecy of Akida",
		["The Prophecy of Mosh'aru"] = "摩沙鲁的预言",
		["The Prophecy of Velen"] = "维伦的预言",
		["The Public Servant"] = "公众之仆",
		["The Purest Water"] = "The Purest Water",
		["The Qiraji Conqueror"] = "其拉虫人的征服者",
		["The Ranger Lord's Behest"] = "游侠之王的命令",
		["The Ravaged Caravan"] = "被破坏的货车",
		["The Real Threat"] = "真正的威胁",
		["The Reason for the Season"] = "冬幕节的意义",
		["The Red Crystal"] = "红色水晶",
		["The Red Messenger"] = "十字军信使",
		["The Relics of Wakening"] = "唤醒圣物",
		["The Remains of Trey Lightforge"] = "特雷·莱弗治的残骸",
		["The Reports"] = "森内尔的报告",
		["The Rescue"] = "拯救行动",
		["The Restless Souls"] = "永不安息的灵魂",
		["The Rethban Gauntlet"] = "往返瑞斯班洞穴",
		["The Right Piece of Lord Valthalak's Amulet"] = "瓦塔拉克饰品的右瓣",
		["The Ring of Blood: Brokentoe"] = "The Ring of Blood: Brokentoe",
		["The Ring of Blood: Rokdar the Sundered Lord"] = "The Ring of Blood: Rokdar the Sundered Lord",
		["The Ring of Blood: Skra'gath"] = "The Ring of Blood: Skra'gath",
		["The Ring of Blood: The Blue Brothers"] = "The Ring of Blood: The Blue Brothers",
		["The Ring of Blood: The Final Challenge"] = "The Ring of Blood: The Final Challenge",
		["The Ring of Blood: The Warmaul Champion"] = "The Ring of Blood: The Warmaul Champion",
		["The Ring of Mmmrrrggglll"] = "The Ring of Mmmrrrggglll",
		["The Rise of the Machines"] = "机器的崛起",
		["The Road to Darnassus"] = "达纳苏斯之路",
		["The Road to Falcon Watch"] = "The Road to Falcon Watch",
		["The Rock Flayer Matriarch"] = "The Rock Flayer Matriarch",
		["The Rod of Lianthe"] = "The Rod of Lianthe",
		["The Root of All Evil"] = "万恶之源",
		["The Royal Rescue"] = "拯救公主",
		["The Ruins of Burning Blade"] = "The Ruins of Burning Blade",
		["The Ruins of Kel'Theril"] = "凯斯利尔废墟",
		["The Ruins of Solarsal"] = "The Ruins of Solarsal",
		["The Ruins of Stardust"] = "星尘废墟",
		["The Rumormonger"] = "车手的传闻",
		["The Rune of Summoning"] = "The Rune of Summoning",
		["The Runed Scroll"] = "符文卷轴",
		["The Sacred Flame"] = "神圣之火",
		["The Sad Truth"] = "The Sad Truth",
		["The Sanctum of the Sun"] = "The Sanctum of the Sun",
		["The Savage Guard - Arcanum of Focus"] = "野性戒卫 - 专注秘药",
		["The Savage Guard - Arcanum of Protection"] = "野性戒卫 - 防护秘药",
		["The Savage Guard - Arcanum of Rapidity"] = "野性戒卫 - 急速秘药",
		["The Savior of Kalimdor"] = "The Savior of Kalimdor",
		["The Scarlet Crusade"] = "血色十字军",
		["The Scent of Lar'korwi"] = "拉克维的气味",
		["The Scepter of Celebras"] = "塞雷布拉斯节杖",
		["The Scorched Grove"] = "焦痕谷",
		["The Scourge Cauldrons"] = "瘟疫之锅",
		["The Scrimshank Redemption"] = "谢申克的救赎",
		["The Scythe of Elune"] = "月神的镰刀",
		["The Search Continues"] = "继续搜寻",
		["The Second Course..."] = "The Second Course...",
		["The Second Rebellion"] = "以彼之道还施彼身",
		["The Second Sample"] = "The Second Sample",
		["The Second Trial"] = "The Second Trial",
		["The Second and Third Fragments"] = "The Second and Third Fragments",
		["The Seer's Relic"] = "The Seer's Relic",
		["The Severed Head"] = "被斩下的头颅",
		["The Shade of Elura"] = "艾鲁拉的阴影",
		["The Shadow Guard"] = "暗影戒卫",
		["The Shadow Tomb"] = "The Shadow Tomb",
		["The Shadowmoon Shuffle"] = "The Shadowmoon Shuffle",
		["The Shadowy Figure"] = "模糊的人影",
		["The Shadowy Search Continues"] = "继续搜寻",
		["The Sharpest Blades"] = "The Sharpest Blades",
		["The Shattered Hand"] = "碎手氏族",
		["The Shattered Necklace"] = "破碎的项链",
		["The Shattered Salute"] = "碎手军礼",
		["The Shieldsmith"] = "铸盾师",
		["The Shimmering Frond"] = "发光的树叶",
		["The Shrine of Dath'Remar"] = "达斯雷玛的神龛",
		["The Sigil of Krasus"] = "The Sigil of Krasus",
		["The Singing Crystals"] = "歌唱水晶",
		["The Siren's Coral"] = "纳迦的珊瑚",
		["The Sketh'lon Wreckage"] = "The Sketh'lon Wreckage",
		["The Skettis Offensive"] = "The Skettis Offensive",
		["The Slaughtered Lamb"] = "已宰的羔羊",
		["The Sleeper Has Awakened"] = "昏昏欲睡",
		["The Sleeping Druid"] = "沉睡的德鲁伊",
		["The Smallest Creatures"] = "The Smallest Creatures",
		["The Smoldering Ruins of Thaurissan"] = "索瑞森废墟",
		["The So-Called Mark of the Lightbringer"] = "The So-Called Mark of the Lightbringer",
		["The Softest Wings"] = "The Softest Wings",
		["The Soul Devices"] = "The Soul Devices",
		["The Spearcrafter's Hammer"] = "The Spearcrafter's Hammer",
		["The Spectral Chalice"] = "The Spectral Chalice",
		["The Spider God"] = "蜘蛛之神",
		["The Spirit Polluted"] = "The Spirit Polluted",
		["The Spirits Have Voices"] = "The Spirits Have Voices",
		["The Spirits of Southwind"] = "南风村的灵魂",
		["The Spirits of Stonetalon"] = "石爪之灵",
		["The Sporelings' Plight"] = "The Sporelings' Plight",
		["The Sprouted Fronds"] = "发芽的树叶",
		["The Spy Revealed!"] = "找出内鬼！",
		["The Stagnant Oasis"] = "死水绿洲",
		["The Stave of Equinex"] = "艾奎尼克斯法杖",
		["The Stockade Riots"] = "监狱暴动",
		["The Stolen Journal"] = "被窃取的日记",
		["The Stolen Tome"] = "失窃的典籍",
		["The Stone"] = "The Stone",
		["The Stone Circle"] = "石环",
		["The Stone Watcher"] = "石头卫士",
		["The Stone of the Tides"] = "海潮之石",
		["The Stones That Bind Us"] = "禁锢我们的石头",
		["The Stones of Vekh'nir"] = "The Stones of Vekh'nir",
		["The Strength of Corruption"] = "堕落的力量",
		["The Summoning"] = "召唤",
		["The Summoning Chamber"] = "The Summoning Chamber",
		["The Sun Gate"] = "The Sun Gate",
		["The Sunfury Garrison"] = "The Sunfury Garrison",
		["The Sunken Temple"] = "沉没的神庙",
		["The Super Snapper FX"] = "超级摄影器FX",
		["The Swamp Talker"] = "沼泽空谈者",
		["The Swarm Grows"] = "疯狂的虫群",
		["The Tear of the Moons"] = "众月之泪",
		["The Tempest Key"] = "风暴钥匙",
		["The Temple of Atal'Hakkar"] = "阿塔哈卡神庙",
		["The Temple of Telhamat"] = "The Temple of Telhamat",
		["The Terror of Marshlight Lake"] = "The Terror of Marshlight Lake",
		["The Test of Righteousness"] = "正义试炼",
		["The Thandol Span"] = "萨多尔大桥",
		["The Theramore Docks"] = "塞拉摩码头",
		["The Third Fleet"] = "第三舰队",
		["The Throne of the Elements"] = "The Throne of the Elements",
		["The Thunderspike"] = "雷霆之刺",
		["The Tome of Divinity"] = "圣洁之书",
		["The Tome of Valor"] = "勇气之书",
		["The Torch of Retribution"] = "惩戒火炬",
		["The Tortured Earth"] = "The Tortured Earth",
		["The Totem of Infliction"] = "惩罚图腾",
		["The Totem of Kar'dash"] = "The Totem of Kar'dash",
		["The Totems of My Enemy"] = "The Totems of My Enemy",
		["The Touch of Zanzil"] = "赞吉尔之触",
		["The Tower of Althalaxx"] = "奥萨拉克斯之塔",
		["The Traitor's Destruction"] = "The Traitor's Destruction",
		["The Traitor's Shadow"] = "The Traitor's Shadow",
		["The Trappings of a Vindicator"] = "The Trappings of a Vindicator",
		["The Treasure of the Shen'dralar"] = "辛德拉的宝藏",
		["The Trogg Threat"] = "穴居人的威胁",
		["The Troll Cave"] = "巨魔洞穴",
		["The Troll Witchdoctor"] = "巨魔巫医",
		["The True Masters"] = "真正的主人",
		["The Truth Comes Crashing Down"] = "可怕的真相",
		["The Truth Unorbed"] = "The Truth Unorbed",
		["The Twilight Camp"] = "暮光之锤的营地",
		["The Twilight Lexicon"] = "暮光词典",
		["The Twilight Mystery"] = "暮光的秘密",
		["The Twin Clefts of Nagrand"] = "The Twin Clefts of Nagrand",
		["The Twin Ziggurats"] = "The Twin Ziggurats",
		["The Ultimate Bloodsport"] = "The Ultimate Bloodsport",
		["The Ultimate Deception"] = "沙漠生存包",
		["The Umbrafen Tribe"] = "The Umbrafen Tribe",
		["The Undermarket"] = "黑市交易",
		["The Underneath"] = "The Underneath",
		["The Unending Invasion"] = "The Unending Invasion",
		["The Unmarred Vision of Voodress"] = "完美巫毒幻象",
		["The Unsent Letter"] = "未寄出的信",
		["The Unwritten Prophecy"] = "The Unwritten Prophecy",
		["The Vengeful Harbinger"] = "The Vengeful Harbinger",
		["The Venture Co."] = "风险投资公司",
		["The Videre Elixir"] = "视灵药剂",
		["The Vile Reef"] = "暗礁海",
		["The Warchief's Mandate"] = "The Warchief's Mandate",
		["The Warden's Cage"] = "The Warden's Cage",
		["The Warlord's Hideout"] = "The Warlord's Hideout",
		["The Warp Rifts"] = "The Warp Rifts",
		["The Warsong Reports"] = "战歌报告",
		["The Way of the Weaponsmith"] = "武器铸造师之道",
		["The Way to Auberdine"] = "The Way to Auberdine",
		["The Wayward Apprentice"] = "The Wayward Apprentice",
		["The Weathered Grave"] = "饱经风霜的墓碑",
		["The Weaver"] = "法师的头领",
		["The Western Pylon"] = "西部水晶塔",
		["The Wildlife Suffers Too"] = "大自然的苦楚",
		["The Will of the Warchief"] = "The Will of the Warchief",
		["The Windwatcher"] = "捕风者",
		["The Woodland Protector"] = "森林守护者",
		["The Woodpaw Gnolls"] = "木爪豺狼人",
		["The Work of Grimand Elmore"] = "格瑞曼德·艾尔默",
		["The World At Your Feet"] = "世界在你脚下",
		["The World's Largest Gnome!"] = "The World's Largest Gnome!",
		["The Writhing Deep"] = "痛苦深渊",
		["The Wrong Stuff"] = "奇怪的材料",
		["The Zapthrottle Mote Extractor!"] = "The Zapthrottle Mote Extractor!",
		["The Zhevra"] = "斑马的威胁",
		["The Zoram Strand"] = "佐拉姆海岸",
		["Theldurin the Lost"] = "迷失者塞尔杜林",
		["Thelsamar Blood Sausages"] = "塞尔萨玛血肠",
		["Theocritus' Retrieval"] = "塞欧克瑞图斯的坠饰",
		["Theramore Spies"] = "塞拉摩间谍",
		["There Can Be Only One Response"] = "There Can Be Only One Response",
		["There Is No Hope"] = "There Is No Hope",
		["There's No Explanation for Fashion"] = "There's No Explanation for Fashion",
		["Therylune's Escape"] = "护送瑟瑞露尼",
		["Therzok"] = "瑟祖克",
		["They Call Him Smiling Jim"] = "微笑的吉姆",
		["They Call Me \"The Rooster\""] = "They Call Me \"The Rooster\"",
		["They Stole Me Hookah and Me Brews!"] = "They Stole Me Hookah and Me Brews!",
		["They're Alive! Maybe..."] = "They're Alive! Maybe...",
		["Thick Hydra Scales"] = "Thick Hydra Scales",
		["Thin the Flock"] = "Thin the Flock",
		["Thinning the Ranks"] = "Thinning the Ranks",
		["Thirst Unending"] = "无尽的渴求",
		["This Is Going to Be Hard"] = "不祥的感觉",
		["Thistleshrub Valley"] = "灌木谷",
		["Thorium Widget"] = "瑟银零件",
		["Those Blasted Troggs!"] = "该死的石腭怪！",
		["Threat From the Sea"] = "海中的威胁",
		["Threat of the Winterfall"] = "冬泉熊怪的威胁",
		["Three Kings of Flame"] = "烈焰之王",
		["Through the Dark Portal"] = "Through the Dark Portal",
		["Thule Ravenclaw"] = "图勒·鸦爪",
		["Thun'grim Firegaze"] = "索恩格瑞姆·火眼",
		["Thunderaan the Windseeker"] = "逐风者桑德兰",
		["Thunderbrew Lager"] = "雷霆啤酒",
		["Thunderhorn Cleansing"] = "净化雷角之井",
		["Thunderhorn Totem"] = "雷角图腾",
		["Thunderlord Clan Artifacts"] = "Thunderlord Clan Artifacts",
		["Thundris Windweaver"] = "桑迪斯·织风",
		["Thwart the Dark Conclave"] = "Thwart the Dark Conclave",
		["Thwarting Kolkar Aggression"] = "科卡尔半人马的进攻",
		["Tiara of the Deep"] = "深渊皇冠",
		["Tiara of the Oracle"] = "神谕者的皇冠",
		["Tiger Mastery"] = "猎虎",
		["Timber Worg Tails"] = "Timber Worg Tails",
		["Timberling Seeds"] = "林精的种子",
		["Timberling Sprouts"] = "林精的新芽",
		["Time To Strike"] = "进攻的时机",
		["Tinkee Steamboil"] = "丁奇·斯迪波尔",
		["To Catch A Thistlehead"] = "To Catch A Thistlehead",
		["To Gadgetzan You Go!"] = "加基森之旅！",
		["To Ironforge for Yagyin's Digest"] = "远赴铁炉堡",
		["To Kill With Purpose"] = "杀戮的理由",
		["To Legion Hold"] = "To Legion Hold",
		["To Meet Mother Kashur"] = "To Meet Mother Kashur",
		["To Netherwing Ledge!"] = "To Netherwing Ledge!",
		["To Serve Kum'isha"] = "为库米沙效力",
		["To Show Due Judgment"] = "圣骑士的审判",
		["To Steal From Thieves"] = "科娜塔一家",
		["To The Bulwark"] = "To The Bulwark",
		["To The Hinterlands"] = "去辛特兰的旅程",
		["To Winterspring!"] = "前往冬泉谷！",
		["To the Stormspire"] = "To the Stormspire",
		["To the Top"] = "登高",
		["To the Undercity for Yagyin's Digest"] = "远赴幽暗城",
		["Tomb of the Lightbringer"] = "光明使者之墓",
		["Tomber's Supplies"] = "Tomber's Supplies",
		["Tome of Divinity"] = "圣洁之书",
		["Tome of the Cabal"] = "阴谋之书",
		["Too Many Mouths to Feed"] = "Too Many Mouths to Feed",
		["Tooga's Quest"] = "图加的任务",
		["Tools for Steelgrill"] = "贝尔丁的工具",
		["Tools of the Highborne"] = "上层精灵的工具",
		["Tools of the Trade"] = "交易工具",
		["Torching Sunfury Hold"] = "Torching Sunfury Hold",
		["Torek's Assault"] = "托雷克的突袭",
		["Torgos!"] = "Torgos!",
		["Tormented By the Past"] = "记忆的折磨",
		["Tormus Deepforge"] = "托姆斯·深炉",
		["Torn Bear Pelts"] = "Torn Bear Pelts",
		["Torwa Pathfinder"] = "托尔瓦·寻路者",
		["Totem of Coo"] = "库欧图腾",
		["Totem of Tikti"] = "提克提图腾",
		["Totem of Vark"] = "瓦克图腾",
		["Totem of Yor"] = "尤尔图腾",
		["Touch of Weakness"] = "虚弱之触",
		["Towers and Bunkers"] = "哨塔和碉堡",
		["Toxic Horrors"] = "剧毒之水",
		["Toxic Test"] = "毒性测试",
		["Tracking Down the Culprits"] = "Tracking Down the Culprits",
		["Training the Beast"] = "训练野兽",
		["Traitor to the Bloodsail"] = "血帆海盗的叛徒",
		["Tramping Paws"] = "践踏之爪",
		["Trampled Under Foot"] = "踩在脚下",
		["Tran'rek"] = "特兰雷克",
		["Translate Abercrombie's Note"] = "翻译亚伯克隆比的信",
		["Translating the Journal"] = "翻译日记",
		["Translating the Ledger"] = "翻译龙语",
		["Translation to Ello"] = "翻译好的信件",
		["Translations..."] = "Translations...",
		["Trapping the Light Fantastic"] = "Trapping the Light Fantastic",
		["Travel to Azure Watch"] = "前往碧蓝岗哨",
		["Travel to Darkshire"] = "Travel to Darkshire",
		["Treant Muisek"] = "树人灵魂精华",
		["Treats for Greatfather Winter"] = "冬幕节的礼物",
		["Tree's Company"] = "间谍之树",
		["Treebole Must Know"] = "Treebole Must Know",
		["Trek to Ashenvale"] = "灰谷之旅",
		["Trelane's Defenses"] = "特雷莱恩的防御",
		["Tremors of the Earth"] = "大地的震颤",
		["Triage"] = "救伤",
		["Trial and Error"] = "Trial and Error",
		["Trial at the Field of Giants"] = "巨人旷野的试炼",
		["Triangulation Point One"] = "Triangulation Point One",
		["Triangulation Point Two"] = "Triangulation Point Two",
		["Tribal Leatherworking"] = "部族制皮",
		["Tribes at War"] = "野猪人的内战",
		["Trinkets..."] = "打开箱子…",
		["Trol'kalar"] = "托卡拉尔",
		["Troll Charm"] = "巨魔符咒",
		["Troll Juju"] = "巨魔的邪符",
		["Troll Necklace Bounty"] = "巨魔部族项链",
		["Troll Temper"] = "巨魔调和剂",
		["Troll Witchery"] = "巨魔巫术",
		["Trollbane"] = "巨魔之敌",
		["Trollbane is Looking for You"] = "Trollbane is Looking for You",
		["Trolls of a Feather"] = "巨魔的羽毛",
		["Trouble In Darkshore?"] = "黑海岸的麻烦事",
		["Trouble at Auchindoun"] = "Trouble at Auchindoun",
		["Trouble at the Docks"] = "港口的麻烦",
		["Trouble at the Underlight Mines"] = "Trouble at the Underlight Mines",
		["Trouble in Winterspring!"] = "冬泉谷的麻烦！",
		["Trouble in the Deeps"] = "帮助耶努萨克雷",
		["Troubled Spirits of Kel'Theril"] = "凯斯利尔的怨灵",
		["Troublesome Distractions"] = "Troublesome Distractions",
		["True Believers"] = "真正的信徒",
		["Trueflight Arrows"] = "Trueflight Arrows",
		["Truth or Fiction"] = "Truth or Fiction",
		["Tumors"] = "青苔之瘤",
		["Tundra MacGrann's Stolen Stash"] = "马克格拉恩的干肉",
		["Turning Point"] = "转折点",
		["Turning the Tide"] = "Turning the Tide",
		["Twilight Battle Orders"] = "暮光作战命令",
		["Twilight Falls"] = "暮光之锤的末日",
		["Twilight Geolords"] = "暮光地王",
		["Twilight Marauders"] = "圣殿骑士",
		["Twilight Ring of Lordship"] = "暮光徽记之戒",
		["Twilight of the Dawn Runner"] = "Twilight of the Dawn Runner",
		["Twisted Evils"] = "扭曲的邪恶",
		["Twisted Hatred"] = "扭曲的仇恨",
		["Two Halves Become One"] = "两半合一",
		["Tyrande and Remulos"] = "泰兰德和雷姆洛斯",
		["Ula'elek and the Brutal Gauntlets"] = "尤拉莱克和野蛮护手",
		["Ulag the Cleaver"] = "切割者奥拉格",
		["Ulathek the Traitor"] = "背叛者乌拉泰克",
		["Uldaman Reagent Run"] = "奥达曼的蘑菇",
		["Umbrafen Eel Filets"] = "Umbrafen Eel Filets",
		["Un'Goro Soil"] = "安戈洛的泥土",
		["Un-Life's Little Annoyances"] = "讨厌的蝙蝠",
		["Uncatalogued Species"] = "未归类的植物",
		["Unclaimed Baggage"] = "Unclaimed Baggage",
		["Uncle Carlin"] = "卡林叔叔",
		["Uncovering the Past"] = "发现历史",
		["Undamaged Venom Sac"] = "完好无损的毒囊",
		["Under Whose Orders?"] = "Under Whose Orders?",
		["Under the Chitin Was..."] = "壳中的东西…",
		["Underbelly Scales"] = "雏龙的鳞片",
		["Undercutting the Competition"] = "Undercutting the Competition",
		["Underground Assault"] = "地底突袭",
		["Underlight Ore Samples"] = "Underlight Ore Samples",
		["Understanding the Mok'Nathal"] = "Understanding the Mok'Nathal",
		["Underworld Loam"] = "Underworld Loam",
		["Unexpected Results"] = "Unexpected Results",
		["Unfinished Business"] = "未完的任务",
		["Unfortunate Measures"] = "令人遗憾的措施",
		["Uniting the Shattered Amulet"] = "收集破碎的护符",
		["Unlocking the Compendium"] = "Unlocking the Compendium",
		["Unruly Neighbors"] = "Unruly Neighbors",
		["Unstable Mana Crystals"] = "Unstable Mana Crystals",
		["Until Death Do Us Part"] = "至死方休",
		["Up to Snuff"] = "鼻烟",
		["Update for Sentinel Thenysil"] = "向塞恩希尔报告",
		["Ur's Treatise on Shadow Magic"] = "乌尔的暗影魔法研究论文",
		["Urgent Delivery"] = "Urgent Delivery",
		["Urgent Delivery!"] = "紧急物资！",
		["Urok Doomhowl"] = "乌洛克",
		["Ursal the Mauler"] = "大槌乌萨尔",
		["Ursangous's Paw"] = "乌萨苟斯的爪子",
		["Ursius of the Shardtooth"] = "碎齿熊尤西乌斯",
		["Us or Them"] = "Us or Them",
		["Vahlarriel's Search"] = "瓦拉里尔的搜寻",
		["Valik"] = "仆从瓦里克",
		["Vanquish the Betrayers"] = "背信弃义的人类",
		["Vanquishing Aquantion"] = "Vanquishing Aquantion",
		["Veil Lithic: Preemptive Strike"] = "Veil Lithic: Preemptive Strike",
		["Veil Rhaze: Unliving Evil"] = "Veil Rhaze: Unliving Evil",
		["Veil Shalas: Signal Fires"] = "Veil Shalas: Signal Fires",
		["Veil Skith: Darkstone of Terokk"] = "Veil Skith: Darkstone of Terokk",
		["Vejrek"] = "维吉雷克",
		["Velinde Starsong"] = "维琳德·星歌",
		["Velinde's Effects"] = "维琳德的日记",
		["Velora Nitely and the Brutal Legguards"] = "维罗拉·奈特雷和野蛮腿甲",
		["Vengeance on the Northspring"] = "对鹰身人的复仇",
		["Venom Bottles"] = "毒液瓶",
		["Venom to the Undercity"] = "送往幽暗城的毒药",
		["Venture Company Mining"] = "风险投资公司",
		["Verdant Sigil"] = "绿色符记",
		["Verifying the Corruption"] = "验证腐蚀",
		["Verog the Dervish"] = "狂热的维罗戈",
		["Vessels of Power"] = "Vessels of Power",
		["Vestments of the Wolf Spirit"] = "Vestments of the Wolf Spirit",
		["Veteran Uzzek"] = "老兵犹塞克",
		["Veteran's Battlegear"] = "精兵的装备",
		["Vibrant Plumes"] = "鲜艳的羽毛",
		["Victims of Corruption"] = "Victims of Corruption",
		["Victory for the Alliance"] = "联盟的胜利",
		["Victory for the Horde"] = "部落的胜利",
		["Vile Familiars"] = "邪灵劣魔",
		["Vile Idolatry"] = "Vile Idolatry",
		["Vile Plans"] = "Vile Plans",
		["Vile Satyr! Dryads in Danger!"] = "身陷危险的树妖！",
		["Vilebranch Hooligans"] = "邪枝窃贼",
		["Villains of Darrowshire"] = "达隆郡的恶魔",
		["Vindicator Aldar"] = "守备官奥达尔",
		["Vindicator's Rest"] = "守备官营地",
		["Vision Guide"] = "幻像指引",
		["Vision of the Dead"] = "Vision of the Dead",
		["Visit the Herbalist"] = "寻访草药师",
		["Vital Intelligence"] = "重要情报",
		["Vital Supplies"] = "重要的补给",
		["Vivian Lagrave"] = "薇薇安·拉格雷",
		["Vivian Lagrave and the Darkstone Tablet"] = "薇薇安·拉格雷和黑暗石板",
		["Void Ridge"] = "虚空山脉",
		["Voidwalkers Gone Wild"] = "Voidwalkers Gone Wild",
		["Volatile Mutations"] = "暴躁的变异体",
		["Volcanic Activity"] = "火山的活动",
		["Volunteer's Battlegear"] = "志愿兵的装备",
		["Voodoo Dues"] = "讨债行动",
		["Voodoo Feathers"] = "巫毒羽毛",
		["Voren'thal's Visions"] = "Voren'thal's Visions",
		["Vorlus Vilehoof"] = "沃鲁斯·邪蹄",
		["Vorrel's Revenge"] = "沃瑞尔的复仇",
		["Vorsha the Lasher"] = "鞭笞者沃尔沙",
		["Vulture's Vigor"] = "秃鹫的活力",
		["Vyletongue Corruption"] = "维利塔恩的污染",
		["Vyral the Vile"] = "邪恶的维拉尔",
		["Vyrin's Revenge"] = "维林的报复",
		["WANTED: Andre Firebeard"] = "通缉：安德雷·费尔比德",
		["WANTED: Baron Longshore"] = "通缉：巴隆·朗绍尔",
		["WANTED: Baron Vardus"] = "通缉：瓦杜斯男爵",
		["WANTED: Boss Grog'ak"] = "WANTED: Boss Grog'ak",
		["WANTED: Caliph Scorpidsting"] = "通缉：卡利夫·斯科比斯汀",
		["WANTED: Chok'sul"] = "通缉令：卓克苏尔",
		["WANTED: Deathclaw"] = "WANTED: Deathclaw",
		["WANTED: Murkdeep!"] = "通缉：莫克迪普！",
		["WANTED: Overseer Maltorius"] = "悬赏：工头玛托留斯",
		["WANTED: Syndicate Personnel"] = "通缉：辛迪加成员",
		["Wait for Sirra to Finish"] = "等待希拉完工",
		["Waking Legends"] = "唤醒传说",
		["Wand over Fist"] = "特雷莱恩的符咒魔杖",
		["Wand to Bethor"] = "给比索的魔杖",
		["Wandering Shay"] = "迷路的沙恩",
		["Wanted - Arnak Grimtotem"] = "通缉：阿纳克·恐怖图腾",
		["Wanted! Marez Cowl"] = "通缉：玛雷兹·考尔",
		["Wanted! Otto and Falconcrest"] = "通缉：奥图和法库雷斯特",
		["Wanted: Annihilator Servo!"] = "Wanted: Annihilator Servo!",
		["Wanted: Blacktalon the Savage"] = "Wanted: Blacktalon the Savage",
		["Wanted: Bonelashers Dead!"] = "Wanted: Bonelashers Dead!",
		["Wanted: Chieftain Mummaki"] = "Wanted: Chieftain Mummaki",
		["Wanted: DWARVES!"] = "通缉：矮人！",
		["Wanted: Durn the Hungerer"] = "Wanted: Durn the Hungerer",
		["Wanted: Gath'Ilzogg"] = "通缉：加塞尔佐格",
		["Wanted: Giselda the Crone"] = "Wanted: Giselda the Crone",
		["Wanted: Knucklerot and Luzran"] = "Wanted: Knucklerot and Luzran",
		["Wanted: Lieutenant Fangore"] = "通缉：范高雷中尉",
		["Wanted: Maggot Eye"] = "悬赏：蛆眼",
		["Wanted: Thaelis the Hungerer"] = "Wanted: Thaelis the Hungerer",
		["Wanted: Vile Priestess Hexx and Her Minions"] = "通缉：邪恶祭司海克斯和她的爪牙",
		["Wanted: Worg Master Kruush"] = "Wanted: Worg Master Kruush",
		["Wanted: Zorbo the Advisor"] = "Wanted: Zorbo the Advisor",
		["Wanted: \"Hogger\""] = "Wanted: \"Hogger\"",
		["War Banners"] = "龙喉战旗",
		["War at Sea"] = "War at Sea",
		["War on Deatholme"] = "War on Deatholme",
		["War on the Shadowsworn"] = "魔誓者之战",
		["War on the Warmaul"] = "War on the Warmaul",
		["War on the Woodpaw"] = "与豺狼人开战",
		["Warden Hamoot"] = "监护者哈穆特",
		["Warlock Training"] = "术士训练",
		["Warlord Krellian"] = "军阀克雷利安",
		["Warlord Sriss'tiz"] = "督军斯雷提兹",
		["Warlord of the Bleeding Hollow"] = "Warlord of the Bleeding Hollow",
		["Warlord's Command"] = "高图斯的命令",
		["Warn Area 52!"] = "Warn Area 52!",
		["Warn Your People"] = "Warn Your People",
		["Warning Fairbreeze Village"] = "Warning Fairbreeze Village",
		["Warning the Cenarion Circle"] = "Warning the Cenarion Circle",
		["Warp-Raider Nesaad"] = "星界强盗奈萨德",
		["Warrior Kinship"] = "战士的血脉",
		["Warrior Training"] = "战士训练",
		["Warsong Outrider Update"] = "战歌侍从的报告",
		["Warsong Runner Update"] = "战歌信使的报告",
		["Warsong Saw Blades"] = "战歌锯条",
		["Warsong Scout Update"] = "战歌斥候的报告",
		["Warsong Supplies"] = "战歌氏族的补给品",
		["Washed Ashore"] = "搁浅的巨兽",
		["Washte Pawne"] = "瓦希塔帕恩",
		["Wasteland"] = "废土",
		["Wastewander Justice"] = "废土的公正",
		["Watcher Leesa'oh"] = "观察者莉萨奥",
		["Water Elementals"] = "水元素",
		["Water Pouch Bounty"] = "收集水袋",
		["Waters of Xavian"] = "克萨维亚之水",
		["Weaken the Ramparts"] = "Weaken the Ramparts",
		["Weapons of Choice"] = "野猪人的武器",
		["Weapons of Elunite"] = "月神武器",
		["Weapons of Spirit"] = "灵魂武器",
		["Webwood Egg"] = "树林蜘蛛的卵",
		["Webwood Venom"] = "树林蜘蛛的毒囊",
		["Welcome to the Jungle"] = "欢迎来到丛林",
		["Welcome!"] = "Welcome!",
		["Welcoming the Wolf Spirit"] = "Welcoming the Wolf Spirit",
		["Well of Corruption"] = "腐化之井",
		["Wenikee Boltbucket"] = "维妮·布特巴克",
		["Westbrook Garrison Needs Help!"] = "西泉要塞",
		["Westfall Stew"] = "杂味炖肉",
		["Wharfmaster Dizzywig"] = "码头管理员迪兹维格",
		["What Are These Things?"] = "What Are These Things?",
		["What Argus Means to Me"] = "What Argus Means to Me",
		["What Book? I Don't See Any Book."] = "What Book? I Don't See Any Book.",
		["What Comes Around..."] = "伸张正义",
		["What Happens in Terokkar Stays in Terokkar"] = "What Happens in Terokkar Stays in Terokkar",
		["What Is Going On?"] = "出了什么事？",
		["What Must Be Done..."] = "必需的措施……",
		["What Niby Commands"] = "尼比的助手",
		["What Strange Creatures..."] = "What Strange Creatures...",
		["What Tomorrow Brings"] = "明天的希望",
		["What We Don't Know..."] = "What We Don't Know...",
		["What We Know..."] = "What We Know...",
		["What the Flux?"] = "绝密配方！",
		["What the Soul Sees"] = "What the Soul Sees",
		["What the Wind Carries"] = "风吹来的消息",
		["What's Wrong at Cenarion Thicket?"] = "What's Wrong at Cenarion Thicket?",
		["Wheel of the Black March"] = "黑暗战车之轮",
		["Whelps of the Wyrmcult"] = "Whelps of the Wyrmcult",
		["When Nature Goes Too Far"] = "When Nature Goes Too Far",
		["When Spirits Speak"] = "When Spirits Speak",
		["When This Mine's a-Rockin'"] = "When This Mine's a-Rockin'",
		["When Worlds Collide..."] = "When Worlds Collide...",
		["When the Cows Come Home"] = "When the Cows Come Home",
		["Where Did Those Darn Gnomes Go?"] = "Where Did Those Darn Gnomes Go?",
		["Where's Wyllithen?"] = "Where's Wyllithen?",
		["Whirlwind Weapon"] = "旋风武器",
		["Whirring Bronze Gizmo"] = "高速青铜齿轮",
		["Whiskey Slim's Lost Grog"] = "威士忌斯利姆的酒",
		["Whispers of the Raven God"] = "Whispers of the Raven God",
		["Whispers on the Wind"] = "Whispers on the Wind",
		["Whitebark's Memory"] = "Whitebark's Memory",
		["Who Are They?"] = "Who Are They?",
		["Wild Guardians"] = "冬泉谷的枭兽",
		["Wild Hearts"] = "荒野之心",
		["Wild Leather Armor"] = "蛮皮护甲",
		["Wild Leather Boots"] = "蛮皮战靴",
		["Wild Leather Helmet"] = "蛮皮头盔",
		["Wild Leather Leggings"] = "蛮皮护腿",
		["Wild Leather Shoulders"] = "蛮皮护肩",
		["Wild Leather Vest"] = "蛮皮外衣",
		["Wildeyes"] = "戈瑟奇·邪眼",
		["Wildkin E'ko"] = "枭兽魂精",
		["Wildkin of Elune"] = "艾露恩的枭兽",
		["Wildmane Cleansing"] = "净化蛮鬃之井",
		["Wildmane Totem"] = "蛮鬃图腾",
		["Williden's Journal"] = "威利德的日记",
		["Willix the Importer"] = "进口商威利克斯",
		["Wind Rider"] = "驭风者",
		["Wind Trader Lathrai"] = "星界商人拉斯莱",
		["Windows to the Source"] = "力量之源",
		["Windroc Mastery"] = "Windroc Mastery",
		["Windrunner Village"] = "风行村",
		["Winds in the Desert"] = "沙漠之风",
		["Wine Shop Advert"] = "酒店的广告",
		["Wing Commander Gryphongar"] = "空军指挥官格莱芬加尔",
		["Winter's Presents"] = "冬天的礼物",
		["Winterfall Activity"] = "冬泉熊怪的活动",
		["Winterfall E'ko"] = "寒水魂精",
		["Winterfall Firewater"] = "冬泉火酒",
		["Winterfall Intrusion"] = "冬泉熊怪的侵扰",
		["Winterfall Ritual Totem"] = "冬泉仪祭图腾",
		["Winterfall Runners"] = "冬泉信使",
		["Winterhoof Cleansing"] = "净化冰蹄之井",
		["Wisdom of Agamaggan"] = "阿迦玛甘的智慧",
		["Witherbark Cages"] = "枯木巨魔的牢笼",
		["Withered Basidium"] = "枯萎的孢芽",
		["Withered Flesh"] = "Withered Flesh",
		["Wolves Across the Border"] = "林中的群狼",
		["Wolves at Our Heels"] = "恶狼成群",
		["Woodpaw Investigation"] = "调查木爪岭",
		["Word from Azure Watch"] = "碧蓝岗哨的消息",
		["Word from the Spire"] = "Word from the Spire",
		["Words of the High Chief"] = "熊怪酋长的话",
		["Worgen in the Woods"] = "森林里的狼人",
		["Worth Its Weight in Gold"] = "证明实力",
		["Wounded Ancients"] = "受伤的古树",
		["Wrath of the Blue Flight"] = "蓝龙之怒",
		["Wrenix of Ratchet"] = "棘齿城的维尼克斯",
		["Wretched Ringleader"] = "Wretched Ringleader",
		["Writ of Safe Passage"] = "通行文书",
		["Writhing Haunt Cauldron"] = "嚎哭鬼屋的瘟疫之锅",
		["Wyrmskull Watcher"] = "Wyrmskull Watcher",
		["Xorothian Stardust"] = "克索诺斯星尘",
		["Xylem's Payment to Jediga"] = "克希雷姆的报酬",
		["Yorus Barleybrew"] = "犹鲁斯·麦酒",
		["You Have Served Us Well"] = "干得好",
		["You Survived!"] = "你活下来了！",
		["You Too Good."] = "你真棒！",
		["You're Fired!"] = "You're Fired!",
		["You're Hired!"] = "You're Hired!",
		["You're a Mean One..."] = "天寒地冻",
		["Young Crocolisk Skins"] = "小鳄鱼皮",
		["Young Lovers"] = "年轻的恋人",
		["Your Fortune Awaits You..."] = "财富在等着你……",
		["Your Place In The World"] = "起点",
		["Ysera's Tears"] = "Ysera's Tears",
		["Yuka Screwspigot"] = "尤卡·斯库比格特",
		["Zaeldarr the Outcast"] = "流亡者塞达尔",
		["Zalazane"] = "扎拉赞恩",
		["Zamek's Distraction"] = "扎米克的困扰",
		["Zandalarian Shadow Mastery Talisman"] = "赞达拉暗影大师坠饰",
		["Zando'zan"] = "赞杜沙",
		["Zanzil's Mixture and a Fool's Stout"] = "赞吉尔的药剂和蠢人酒",
		["Zanzil's Secret"] = "赞吉尔的秘密",
		["Zapped Giants"] = "被缩小的巨人",
		["Zapper Fuel"] = "除草器的燃料",
		["Zenn's Bidding"] = "赛恩的要求",
		["Zeth'Gor Must Burn!"] = "Zeth'Gor Must Burn!",
		["Zinge's Delivery"] = "给金格的货物",
		["Ziz Fizziks"] = "菲兹克斯",
		["Zombie Juice"] = "僵尸",
		["Zukk'ash Infestation"] = "祖卡什的入侵",
		["Zukk'ash Report"] = "祖卡什报告",
		["Zul'Marosh"] = "Zul'Marosh",
		["Zuluhed the Whacked"] = "疲惫的祖鲁希德",
		["\"Pretty Boy\" Duncan"] = "帅小伙子邓肯",
		["rAnS0m"] = "敲诈",
} end)

BabbleQuest:RegisterTranslations("zhTW", function() return {
    -- Quest names (3808)
        ["... and Bugs"] = "還有螃蟹!",
        ["... and a Batch of Ooze"] = "一大堆軟泥怪",
        ["...and a Time for Action"] = "……行動的時間到了",
        ["10 Tickets - Last Month's Mutton"] = "10張彩票 - 上個月的羊肉",
        ["12 Tickets - Lesser Darkmoon Prize"] = "12張彩票 - 二等暗月獎",
        ["1200 Tickets - Amulet of the Darkmoon"] = "1200張彩票 - 暗月護符",
        ["1200 Tickets - Orb of the Darkmoon"] = "1200張彩票 - 暗月寶珠",
        ["40 Tickets - Greater Darkmoon Prize"] = "40張彩票 - 一等暗月獎",
        ["40 Tickets - Schematic: Steam Tonk Controller"] = "40張彩票 - 結構圖:蒸汽坦克遙控器",
        ["5 Tickets - Darkmoon Flower"] = "5張彩票 - 暗月小花",
        ["5 Tickets - Minor Darkmoon Prize"] = "5張彩票 - 三等暗月獎",
        ["50 Tickets - Darkmoon Storage Box"] = "50張彩票 - 暗月收藏箱",
        ["A Bad Egg"] = "壞掉的蛋",
        ["A Baying of Gnolls"] = "豺狼人的咆哮",
        ["A Better Ingredient"] = "更好的材料",
        ["A Bijou for Zanza"] = "贊札的寶石",
        ["A Binding Contract"] = "一份必須遵守的契約",
        ["A Bird's-Eye View"] = "鳥眼視線",
        ["A Blue Light Bargain"] = "君王鎧甲的設計圖",
        ["A Boar's Vitality"] = "野豬的活力",
        ["A Boaring Time for Grulloc"] = "葛魯洛克的豬時光",
        ["A Broken Trap"] = "破碎的陷阱",
        ["A Bump in the Road"] = "安全隱患",
        ["A Bundle of Hides"] = "一捆獸皮",
        ["A Bundle of Trouble"] = "木材危機",
        ["A Burden of Souls"] = "靈魂的負擔",
        ["A Carefully Wrapped Present"] = "精心包裹的禮物",
        ["A Cleansing Light"] = "淨化的聖光",
        ["A Collection of Heads"] = "收集頭顱",
        ["A Convincing Disguise"] = "具說服力的偽裝",
        ["A Crew Under Fire"] = "危難中的船長",
        ["A Crumpled Up Note"] = "弄皺的便箋",
        ["A Cry For Help"] = "求救",
        ["A Cure for Zahlia"] = "給札麗亞的解藥",
        ["A Curse Upon Both of Your Clans!"] = "詛咒你們的氏族!",
        ["A Dandy's Best Friend"] = "花花公子的知音",
        ["A Dark Pact"] = "黑暗契約",
        ["A Dark Threat Looms"] = "黑暗危機逼近",
        ["A Date with Dorgok"] = "與多爾哥克的約會",
        ["A Daughter's Love"] = "女兒的愛",
        ["A Debilitating Sickness"] = "削弱力量的疾病",
        ["A Defector"] = "背叛者",
        ["A Different Approach"] = "不同的方式",
        ["A Dip in the Moonwell"] = "月井之水",
        ["A Dire Situation"] = "情況緊迫",
        ["A Discreet Inquiry"] = "謹慎的要求",
        ["A Dwarf and His Tools"] = "矮人的工具",
        ["A Fate Worse Than Death"] = "比死還糟的命運",
        ["A Favor for Evershine"] = "艾沃沙酒",
        ["A Favorite Treat"] = "最愛的一道菜",
        ["A Festive Gift"] = "節慶禮物",
        ["A Final Blow"] = "最終一擊",
        ["A Fine Egg"] = "優良的蛋",
        ["A Fine Mess"] = "一團混亂",
        ["A Fishy Peril"] = "魚人的威脅",
        ["A Fistful of Slivers"] = "一把薄片",
        ["A Free Lunch"] = "免費的午餐",
        ["A Friend in Need"] = "需要幫助的朋友",
        ["A Gaily Wrapped Present"] = "精心包裝的禮物",
        ["A Gallon of Blood"] = "聯盟之血",
        ["A Gesture of Goodwill"] = "展示好意",
        ["A Ghost in the Machine"] = "機械中的鬼魂",
        ["A Gift for Voren'thal"] = "給沃藍索的禮物",
        ["A Gnome's Assistance"] = "地精的援助",
        ["A Gnome's Respite"] = "地精學者",
        ["A Good Friend"] = "好朋友",
        ["A Good Head On Your Shoulders"] = "罩帽和護肩",
        ["A Grave Situation"] = "尋找墓碑",
        ["A Grim Discovery"] = "可怕的發現",
        ["A Grim Task"] = "艱鉅的任務",
        ["A Grunt's Work..."] = "衛兵的工作……",
        ["A Handful of Magic Dust"] = "一把魔塵",
        ["A Hasty Departure"] = "倉促的離開",
        ["A Haunted History"] = "鬧鬼的過去",
        ["A Head Full of Ivory"] = "象長牙",
        ["A Heap of Ethereals"] = "一堆伊斯利",
        ["A Helping Hand"] = "伸出援手",
        ["A Hero Is Needed"] = "需要一位英雄",
        ["A Hero's Reward"] = "英雄的獎賞",
        ["A Hero's Welcome"] = "羽月將軍的歡迎",
        ["A Host of Evil"] = "邪惡之地",
        ["A Humble Offering"] = "謙卑的提議",
        ["A Humble Task"] = "一件瑣事",
        ["A Hunter's Boast"] = "自豪的獵人",
        ["A Hunter's Challenge"] = "獵人的挑戰",
        ["A Husband's Last Battle"] = "最後一戰",
        ["A Husband's Revenge"] = "丈夫的復仇",
        ["A Job Undone"] = "未完成的工作",
        ["A Job for an Intelligent Man"] = "聰明人的工作",
        ["A King's Tribute"] = "國王的禮物",
        ["A Lack of Fear"] = "毫無畏懼",
        ["A Land Filled with Hatred"] = "充滿仇恨的土地",
        ["A Lesson Learned"] = "學到一課",
        ["A Letter Undelivered"] = "未寄出的信件",
        ["A Lingering Suspicion"] = "長久的懷疑",
        ["A Little Dash of Seasoning"] = "一點小樂趣",
        ["A Little Help From My Friends"] = "朋友的幫助",
        ["A Little Slime Goes a Long Way"] = "遠方的軟泥怪",
        ["A Lost Master"] = "丟失的主人",
        ["A Map to Where?"] = "模糊的地圖?",
        ["A Message to Telaar"] = "給泰拉的消息",
        ["A Mysterious Portent"] = "神秘的前兆",
        ["A Necessary Distraction"] = "製造混亂",
        ["A New Cloak's Sheen"] = "新披風的光輝",
        ["A New Ore Sample"] = "新的礦石樣本",
        ["A New Plague"] = "新的瘟疫",
        ["A New Threat"] = "新的威脅",
        ["A Noble Brew"] = "名釀",
        ["A Not-So-Modest Proposal"] = "一個不太謙虛的提議",
        ["A Pawn on the Eternal Board"] = "往日的回憶",
        ["A Peon's Burden"] = "苦工的重擔",
        ["A Personal Favor"] = "個人的喜好",
        ["A Pilgrim's Plight"] = "朝聖者的困境",
        ["A Pilot's Revenge"] = "駕駛員的復仇",
        ["A Plague Upon Thee"] = "瘟疫與你",
        ["A Portable Power Source"] = "攜帶式能量泉源",
        ["A Promising Start"] = "一個有希望的開始",
        ["A Proper String"] = "合適的弓弦",
        ["A Putrid Task"] = "腐爛的爪子",
        ["A Question of Gluttony"] = "暴食的問題",
        ["A Rare Bean"] = "稀有的豆子",
        ["A Recipe For Death"] = "致命配方",
        ["A Refugee's Quandary"] = "逃難者的困境",
        ["A Reliquary of Purity"] = "淨化之匣",
        ["A Restorative Draught"] = "恢復藥劑",
        ["A Rogue's Deal"] = "盜賊的交易",
        ["A Sacred Burial"] = "神聖的墓地",
        ["A Scroll from Mauren"] = "馬倫的卷軸",
        ["A Secret Revealed"] = "秘密的揭露",
        ["A Shameful Waste"] = "可恥的浪費",
        ["A Shifty Merchant"] = "狡猾的商人",
        ["A Short Incubation"] = "即將孵化",
        ["A Shred of Hope"] = "一絲希望",
        ["A Sign of Hope"] = "一線希望",
        ["A Simple Request"] = "簡單的要求",
        ["A Simple Robe"] = "一件簡單的長袍",
        ["A Small Start"] = "一個小開始",
        ["A Solvent Spirit"] = "沃納爾大師",
        ["A Somber Task"] = "陰鬱任務",
        ["A Spirit Ally?"] = "靈魂助手?",
        ["A Spirit Guide"] = "精神指引",
        ["A Sticky Situation"] = "黏著的情況",
        ["A Strange Historian"] = "古怪的歷史學家",
        ["A Strange One"] = "奇怪的傢伙",
        ["A Strange Red Key"] = "奇怪的紅鑰匙",
        ["A Strange Request"] = "奇怪的要求",
        ["A Strange Weapon"] = "奇怪的武器",
        ["A Study in Power"] = "學習力量",
        ["A Supernatural Device"] = "超自然儀器",
        ["A Swift Message"] = "快遞消息",
        ["A Tale of Sorrow"] = "悲傷的故事",
        ["A Task Unfinished"] = "未完的任務",
        ["A Taste of Flame"] = "烈焰精華",
        ["A Terrible Purpose"] = "擺脫困境",
        ["A Threat Within"] = "身邊的危機",
        ["A Threat in Feralas"] = "菲拉斯的危機",
        ["A Time for Negotiation..."] = "協商時間……",
        ["A Traitor Among Us"] = "眾人的背叛者",
        ["A Troubled Spirit"] = "困擾的靈魂",
        ["A Troubling Breeze"] = "煩惱之風",
        ["A Vengeful Fate"] = "奧爾德的報復",
        ["A Visit With The Ancestors"] = "拜訪先祖們",
        ["A Visit With the Greatmother"] = "與祖母的會面",
        ["A Visit to Gregan"] = "造訪格雷甘",
        ["A Warm Welcome"] = "溫馨款待",
        ["A Warrior's Training"] = "戰士的訓練",
        ["A Watchful Eye"] = "法師的眼線",
        ["A Yeti of Your Own"] = "你自己的機械雪人",
        ["Abandoned Hope"] = "被遺棄的希望",
        ["Abandoned Investigations"] = "放棄的調查",
        ["Abjurist Belmara"] = "貝馬拉",
        ["Above and Beyond"] = "超越",
        ["Abyssal Contacts"] = "深淵聯絡",
        ["Abyssal Crests"] = "深淵紋章",
        ["Additional Materials"] = "額外的材料",
        ["Administering the Salve"] = "使用藥膏",
        ["After the Ambush"] = "惡戰之後",
        ["Again With the Zapped Giants"] = "更多被縮小的巨人!",
        ["Against All Odds"] = "挑戰不可能",
        ["Against Lord Shalzaru"] = "擊敗沙爾札魯領主",
        ["Against the Hatecrest"] = "憎世納迦之戰",
        ["Against the Illidari"] = "對抗伊利達瑞",
        ["Against the Legion"] = "對抗軍團",
        ["Agamaggan's Agility"] = "阿迦瑪甘的敏捷",
        ["Agamaggan's Strength"] = "阿迦瑪甘的力量",
        ["Agamand Heirlooms"] = "阿加曼德家傳武器",
        ["Agents of Destruction"] = "毀滅間諜",
        ["Aggression"] = "侵略",
        ["Agitated Spirits of Skysong"] = "天歌的焦慮精靈",
        ["Agmond's Fate"] = "埃格蒙德的命運",
        ["Aiding the Outrunners"] = "幫助先驅者",
        ["Ak'Zeloth"] = "雅克塞羅斯",
        ["Akama"] = "阿卡瑪",
        ["Akama's Promise"] = "阿卡瑪的承諾",
        ["Akiris by the Bundle"] = "一捆海蛇草",
        ["Aldor No More"] = "奧多爾不再",
        ["Alien Ecology"] = "異型的生態",
        ["Alien Egg"] = "異型卵",
        ["Alien Predators"] = "外來掠奪者",
        ["Alien Spirits"] = "不同的靈魂",
        ["All Along the Watchtowers"] = "標記哨塔",
        ["All Clear!"] = "全部清除!",
        ["All That Remains"] = "剩下的一切",
        ["Allegiance to Cenarion Circle"] = "忠於塞納里奧議會",
        ["Allegiance to the Aldor"] = "向奧多爾效忠",
        ["Allegiance to the Old Gods"] = "上古諸神的僕從",
        ["Allegiance to the Scryers"] = "向占卜者效忠",
        ["Alliance Relations"] = "聯盟關係",
        ["Alliance Trauma"] = "聯盟醫療隊",
        ["Alpha Strike"] = "突然襲擊",
        ["Altered Beings"] = "變異的生物",
        ["Alther's Mill"] = "奧瑟爾伐木場",
        ["Altruis"] = "奧翠司",
        ["Amani Encroachment"] = "侵犯阿曼尼",
        ["Amani Invasion"] = "阿曼尼入侵",
        ["Ambermill Investigations"] = "調查安伯米爾",
        ["Ammo for Rumbleshot"] = "海格納的彈藥",
        ["Amongst the Ruins"] = "廢墟之間",
        ["Amulet of Secrets"] = "鐵趾的護符",
        ["An Aggressive Defense"] = "先發制人",
        ["An Alternative Alternative"] = "替代的選擇",
        ["An Ambassador of Evil"] = "邪惡的使者",
        ["An Ambitious Plan"] = "野心勃勃的計劃",
        ["An Apprentice's Enchantment"] = "學徒的魔法",
        ["An Audacious Advance"] = "大膽前進",
        ["An Audience with the Prince"] = "晉見王子",
        ["An Earnest Proposition"] = "誠摯的建議",
        ["An Easy Pickup"] = "簡單的接收任務",
        ["An Extraordinary Egg"] = "特別的蛋",
        ["An Imp's Request"] = "小鬼的要求",
        ["An Improper Burial"] = "不適當的葬禮",
        ["An Introduction"] = "介紹",
        ["An OOX of Your Own"] = "你自己的OOX",
        ["An Old Colleague"] = "老同事",
        ["An Old Gift"] = "一份多年的禮物",
        ["An Old History Book"] = "一本破舊的歷史書",
        ["An Ordinary Egg"] = "普通的蛋",
        ["An Orphan Looking For a Home"] = "領養孤兒",
        ["An Unholy Alliance"] = "邪惡的盟友",
        ["An Unnatural Drought"] = "不尋常的乾旱",
        ["An Unseen Hand"] = "看不見的手",
        ["An Unusual Patron"] = "稀有的庇護人",
        ["An Unwelcome Guest"] = "不速之客",
        ["An Unwelcome Presence"] = "不速之客",
        ["Anachronos"] = "安納克羅斯",
        ["Ancient Sinew Wrapped Lamina"] = "龍筋箭袋",
        ["Ancient Spirit"] = "遠古之靈",
        ["Andron's Payment to Jediga"] = "安德隆的報酬",
        ["Angling to Beat the Competition"] = "擊敗釣魚者的對手",
        ["Ango'rosh Encroachment"] = "安格拉斯入侵",
        ["Animist's Caress"] = "靈魂的安撫",
        ["Anok'suten"] = "安羅科舒頓",
        ["Another Heap of Ethereals"] = "另一支伊斯利勢力",
        ["Another Message to the Wildhammer"] = "又一個給蠻錘部族的警告",
        ["Another Power Source?"] = "另一個能量源?",
        ["Ansirem's Key"] = "安斯雷姆的鑰匙",
        ["Answered Questions"] = "回覆珊蒂斯",
        ["Anthion's Old Friend"] = "安希恩的老朋友",
        ["Anthion's Parting Words"] = "安希恩的離別感言",
        ["Anthion's Strange Request"] = "安希恩奇怪的要求",
        ["Apothecary Antonivich"] = "藥劑師安拓維奇",
        ["Apothecary Zamah"] = "藥劑師札瑪",
        ["Apothecary Zelana"] = "藥劑師席蓮娜",
        ["Apprentice Angler"] = "釣魚學徒",
        ["Apprentice's Duties"] = "學徒的職責",
        ["Aquatic Form"] = "水棲形態",
        ["Aquementas"] = "亞奎門塔斯",
        ["Ar'kelos the Guardian"] = "守護者阿其羅斯",
        ["Arachnophobia"] = "貝瑟萊斯",
        ["Araj's Scarab"] = "阿拉基的聖甲蟲",
        ["Arakkoa War Path"] = "阿拉卡作戰方式",
        ["Arathor Basic Care Package"] = "阿拉索基本醫療包",
        ["Arathor Standard Care Package"] = "阿拉索標準醫療包",
        ["Arcane Feedback"] = "秘法回饋",
        ["Arcane Instability"] = "秘法不穩定性",
        ["Arcane Reavers"] = "秘法搶奪者",
        ["Arcane Refreshment"] = "久違的法師",
        ["Arcane Runes"] = "秘法符文",
        ["Arcane Tomes"] = "秘法寶典",
        ["Arcanite"] = "奧金錠",
        ["Arconus the Insatiable"] = "貪求無厭的阿肯納斯",
        ["Arelion's Journal"] = "阿利恩的日記",
        ["Arelion's Mistress"] = "阿利恩的情婦",
        ["Arelion's Secret"] = "阿利恩的秘密",
        ["Arena Master"] = "競技場大師",
        ["Arikara"] = "阿利卡拉",
        ["Armaments for Deception"] = "欺騙的軍備",
        ["Armed and Ready"] = "整裝待發",
        ["Armor Kits for the Field"] = "戰場上的護甲片",
        ["Armor Scraps"] = "護甲碎塊",
        ["Arms for the Field"] = "戰場上的武器",
        ["Army of the Black Dragon"] = "黑龍軍團",
        ["Arrival in Outland"] = "抵達外域",
        ["Arrows Are For Sissies"] = "弓箭是給娘娘腔用的",
        ["Artifacts of the Blacksilt"] = "黑沙的手工藝品",
        ["Arugal Must Die"] = "除掉阿魯高",
        ["Arugal's Folly"] = "阿魯高的愚行",
        ["Arzeth's Demise"] = "阿爾塞斯的死亡",
        ["As Water Cascades"] = "清洗水晶",
        ["As the Crow Flies"] = "烏鴉高飛時",
        ["Ascension..."] = "晉升印章",
        ["Asghar's Totem"] = "阿斯格的圖騰",
        ["Ashenvale Outrunners"] = "梣谷先驅者",
        ["Assassin's Contract"] = "刺客的契約",
        ["Assassination Plot"] = "暗殺計畫",
        ["Assault on Fenris Isle"] = "突襲芬里斯島",
        ["Assault on Zeb'Nowa"] = "攻擊札布諾瓦",
        ["Assault on the Kolkar"] = "突襲科卡爾部族",
        ["Assessing the Situation"] = "評估狀況",
        ["Assessing the Threat"] = "審時度勢",
        ["Assisting the Consortium"] = "協助聯合團",
        ["Astral Knot Garment"] = "星界之衣",
        ["At War With The Scarlet Crusade"] = "與血色十字軍的戰爭",
        ["Attack on Camp Narache"] = "納拉其營地的危機",
        ["Attack on Firewing Point"] = "攻擊火翼崗哨",
        ["Attack on Zeb'Tela"] = "攻擊札布泰拉",
        ["Attack on the Tower"] = "進攻高塔",
        ["Auchindoun..."] = "奧齊頓……",
        ["Audience with the Prophet"] = "覲見預言者",
        ["Auntie Marlene"] = "瑪萊恩姑媽",
        ["Aurel Goldleaf"] = "奧莉爾·金葉",
        ["Aurius' Reckoning"] = "奧里爾斯的清算",
        ["Avenge My Village"] = "為我的村莊復仇",
        ["Avenger's Breastplate"] = "復仇者的胸甲",
        ["Avenger's Crown"] = "復仇者之冠",
        ["Avenger's Greaves"] = "復仇者的脛甲",
        ["Avenger's Legguards"] = "復仇者的腿甲",
        ["Avenger's Pauldrons"] = "復仇者的肩鎧",
        ["Avenging the Fallen"] = "死者的復仇",
        ["Avruu's Orb"] = "艾芙魯的寶珠",
        ["Azsharite"] = "艾薩拉水晶",
        ["Azure Templar"] = "碧藍聖殿騎士",
        ["Azuregos's Magical Ledger"] = "艾索雷葛斯的魔法賬本",
        ["B'naar Console Transcription"] = "巴納爾控制臺謄本",
        ["Back to Billy"] = "回去找比利",
        ["Back to Booty Bay"] = "返回藏寶海灣",
        ["Back to Darnassus"] = "返回達納蘇斯",
        ["Back to Thunder Bluff"] = "返回雷霆崖",
        ["Back to Uldaman"] = "回到奧達曼",
        ["Back to the Beginning"] = "回到原點",
        ["Back to the Chief!"] = "回去找主管!",
        ["Bad Medicine"] = "庫爾森的藥物",
        ["Badlands Reagent Run"] = "荒蕪之地的試劑",
        ["Badlands Reagent Run II"] = "荒蕪之地的試劑 II",
        ["Bailor's Ore Shipment"] = "白洛爾的礦石",
        ["Balance Must Be Preserved"] = "一定要保持平衡",
        ["Band of Unending Life"] = "不滅生命指環",
        ["Band of Vaulted Secrets"] = "魔法秘密指環",
        ["Band of Veiled Shadows"] = "矇矓之影指環",
        ["Bandits!"] = "土匪!",
        ["Bane of the Illidari"] = "伊利達瑞的剋星",
        ["Barbaric Battlements"] = "野人裝甲",
        ["Barbecued Buzzard Wings"] = "燒烤禿鷲翅膀",
        ["Baron Aquanis"] = "阿奎尼斯男爵",
        ["Baron Sablemane"] = "沙伯曼男爵",
        ["Baron Sablemane Has Requested Your Presence"] = "沙伯曼男爵請求你的出現",
        ["Baron Sablemane's Poison"] = "沙伯曼男爵的毒藥",
        ["Baron's Demise"] = "男爵之死",
        ["Barov Family Fortune"] = "巴羅夫家族的寶藏",
        ["Bartleby the Drunk"] = "醉鬼巴托比",
        ["Bartleby's Mug"] = "巴托比的酒杯",
        ["Bartolo's Yeti Fur Cloak"] = "巴圖羅的雪人毛皮披風",
        ["Bashal'Aran"] = "巴莎蘭",
        ["Bathran's Hair"] = "巴斯蘭的頭髮",
        ["Battle of Hillsbrad"] = "希爾斯布萊德之戰",
        ["Battle of Warsong Gulch"] = "峽谷之戰",
        ["Battle of the Crimson Watch"] = "赤紅守望的戰鬥",
        ["Battle-Mage Dathric"] = "戰場法師達斯立克",
        ["Beached Sea Creature"] = "擱淺的海洋生物",
        ["Beached Sea Turtle"] = "擱淺的海龜",
        ["Beads for Salfa"] = "給薩爾法的珠串",
        ["Bearers of the Plague"] = "削弱瘟疫",
        ["Beast Training"] = "訓練野獸",
        ["Beasts of the Apocalypse!"] = "天啟的野獸!",
        ["Beat Bartleby"] = "擊敗巴托比",
        ["Because Kilrath is a Coward"] = "科伊瑞斯是懦夫",
        ["Becoming a Mooncloth Tailor"] = "成為一名月布裁縫師",
        ["Becoming a Parent"] = "為人父母",
        ["Becoming a Shadoweave Tailor"] = "成為一名暗紋裁縫師",
        ["Becoming a Spellfire Tailor"] = "成為一名魔焰裁縫師",
        ["Beer Basted Boar Ribs"] = "啤酒烤豬排",
        ["Before Darkness Falls"] = "暗夜來臨前",
        ["Befouled by Satyr"] = "薩特的威脅",
        ["Begin the Attack!"] = "展開攻擊!",
        ["Beginnings"] = "開端",
        ["Behind Enemy Lines"] = "敵人身後",
        ["Behomat"] = "畢和瑪特",
        ["Bell of Dethmoora"] = "達斯莫拉之鈴",
        ["Belt of Faith"] = "信仰腰帶",
        ["Beneath Thrallmar"] = "索爾瑪的地下礦坑",
        ["Beren's Peril"] = "博倫的巢穴",
        ["Besieged!"] = "圍困!",
        ["Betina Bigglezink"] = "貝蒂娜·比格辛克",
        ["Betrayal from Within"] = "內奸",
        ["Betrayed"] = "叛徒",
        ["Better Late Than Never"] = "遲到總比不到好",
        ["Between a Rock and a Thistlefur"] = "薊皮熊怪的麻煩",
        ["Beware of Pterrordax"] = "當心翼手龍",
        ["Big Black Mace"] = "巨型黑錘",
        ["Big Game Hunter"] = "王牌獵人",
        ["Bijou's Belongings"] = "比修的裝置",
        ["Bijou's Reconnaissance Report"] = "比修的偵察報告",
        ["Binding the Dreadnaught"] = "訂做無畏護甲",
        ["Bindings of Faith"] = "信仰束腕",
        ["Bingles' Missing Supplies"] = "賓格斯的補給品",
        ["Birds of a Feather"] = "稀有的鳥類",
        ["Bitter Rivals"] = "針鋒相對",
        ["Blackfathom Villainy"] = "黑暗深淵中的惡魔",
        ["Blackhand's Command"] = "黑手的命令",
        ["Blackmoore's Legacy"] = "布拉克摩爾的餘孽",
        ["Blackrock Bounty"] = "懸賞:黑石氏族",
        ["Blackrock Menace"] = "黑石氏族的威脅",
        ["Blacksting's Bane"] = "黑刺的螫針的毀滅",
        ["Blade of Eternal Justice"] = "永恆公正之刃",
        ["Blade of Vaulted Secrets"] = "魔法秘密之刃",
        ["Bladespire Kegger"] = "劍刃氏族的喝酒大會",
        ["Blast the Infernals!"] = "引爆地獄火!",
        ["Bleeding Hollow Supply Crates"] = "血之谷補給木箱",
        ["Blessed Arcanite Barding"] = "受祝福的奧金馬鎧",
        ["Blessed Arm"] = "格瑞曼德·艾爾默",
        ["Blessing of Incineratus"] = "辛納瑞塔斯的祝福",
        ["Blessings of the Ancients"] = "先祖的祝福",
        ["Blind Cazul"] = "盲眼卡祖爾",
        ["Blisters on The Land"] = "大地上的膿皰",
        ["Blood Crystals"] = "血水晶",
        ["Blood Elf Plans"] = "血精靈計畫書",
        ["Blood Elf Spy"] = "血精靈間諜",
        ["Blood Feeders"] = "盜竊的蜘蛛",
        ["Blood Shards of Agamaggan"] = "阿迦瑪甘的血岩裂片",
        ["Blood Tinged Skies"] = "血染的天空",
        ["Blood Watch"] = "血紅守望",
        ["Blood of the Black Dragon Champion"] = "黑龍勇士之血",
        ["Bloodfury Bloodline"] = "血怒一族",
        ["Bloodgem Crystals"] = "血寶石水晶",
        ["Bloodpetal Poison"] = "血瓣花之毒",
        ["Bloodpetal Sprouts"] = "血瓣花苗",
        ["Bloodpetal Zapper"] = "血瓣花除草器",
        ["Bloodscalp Clan Heads"] = "血頂之顱",
        ["Bloodscalp Ears"] = "血頂族的耳朵",
        ["Bloodscalp Insight"] = "洞悉血頂習性",
        ["Bloody Bone Necklaces"] = "染血的白骨項鍊",
        ["Bloody Imp-ossible!"] = "血任務!",
        ["Blueleaf Tubers"] = "藍葉薯",
        ["Boat Wreckage"] = "船隻的殘骸",
        ["Bodley's Unfortunate Fate"] = "布德利不幸的命運",
        ["Body and Heart"] = "身心之力",
        ["Body of Evidence"] = "證據的屍體",
        ["Bodyguard for Hire"] = "雇傭保鏢",
        ["Boiling Blood"] = "沸騰的血",
        ["Bolstering Our Defenses"] = "增強防禦",
        ["Bone Collector"] = "集骨者",
        ["Bone Fragments"] = "骨頭碎片",
        ["Bone-Bladed Weapons"] = "骨刃武器",
        ["Bonechewer Blood"] = "噬骨者鮮血",
        ["Bonescythe Bracers"] = "骨鐮護腕",
        ["Bonescythe Breastplate"] = "骨鐮胸甲",
        ["Bonescythe Digs"] = "骨鐮掘鏟",
        ["Bonescythe Gauntlets"] = "骨鐮護手",
        ["Bonescythe Helmet"] = "骨鐮盔帽",
        ["Bonescythe Legplates"] = "骨鐮腿鎧",
        ["Bonescythe Pauldrons"] = "骨鐮肩鎧",
        ["Bonescythe Sabatons"] = "骨鐮重靴",
        ["Bonescythe Waistguard"] = "骨鐮護腰",
        ["Book of the Ancients"] = "上古之書",
        ["Bookie Herod"] = "書呆子赫羅德",
        ["Booty Bay or Bust!"] = "藏寶海灣之旅!",
        ["Bor Wishes to Speak"] = "伯爾想說話",
        ["Border Crossings"] = "越境",
        ["Botanical Legwork"] = "植物學家的跑腿任務",
        ["Botanist Taerix"] = "植物學家泰瑞茲",
        ["Boulderslide Ravine"] = "滾岩峽谷",
        ["Bound for Glory"] = "前往光榮",
        ["Bounty on Garrick Padfoot"] = "加瑞克·帕德弗特的賞金",
        ["Bounty on Murlocs"] = "懸賞魚人",
        ["Bracers of Binding"] = "地縛護腕",
        ["Brann Bronzebeard's Lost Letter"] = "布拉恩·銅鬚遺失的信件",
        ["Breaching the Path"] = "破壞農場",
        ["Break Sharptusk!"] = "打斷尖牙!",
        ["Break a Few Eggs"] = "恐龍蛋大餐",
        ["Breaking Down Netherock"] = "擊倒虛空石",
        ["Breaking the Code"] = "破解密碼",
        ["Breaking the Keystone"] = "打開鑰匙之石",
        ["Breaking the Ward"] = "破壞結界",
        ["Breastplate of Bloodthirst"] = "血嗜胸甲",
        ["Breastplate of the Chromatic Flight"] = "多彩巨龍胸甲",
        ["Bride of the Embalmer"] = "藏屍者的妻子",
        ["Bring Back the Mug"] = "歸還酒杯",
        ["Bring Down the Warbringer!"] = "擊敗戰爭使者!",
        ["Bring Me A Shrubbery!"] = "給我木槿花!",
        ["Bring Me Another Shrubbery!"] = "再給我木槿花!",
        ["Bring Me Kel'gash's Head!"] = "把卡爾喀旭的頭顱帶來!",
        ["Bring Me The Egg!"] = "我要蛋!",
        ["Bring the End"] = "寒冰之王",
        ["Bring the Light"] = "與聖光同在",
        ["Broken Alliances"] = "破碎的聯盟",
        ["Broken Tears"] = "破碎之淚",
        ["Broodling Essence"] = "雛龍精華",
        ["Brother Against Brother"] = "兄弟鬩牆",
        ["Brother Anton"] = "安東修士",
        ["Brother Carlin"] = "卡林弟兄",
        ["Brother Paxton"] = "帕克斯頓修士",
        ["Brotherhood of Thieves"] = "盜賊兄弟會",
        ["Brotherhood's End"] = "兄弟會的滅亡",
        ["Brotherly Love"] = "兄弟情深",
        ["Brumeran of the Chillwind"] = "冰風奇美拉布魯米蘭",
        ["Brutal Armor"] = "野蠻護甲",
        ["Brutal Gauntlets"] = "野蠻護手",
        ["Brutal Hauberk"] = "野蠻鍊衫",
        ["Brutal Helm"] = "野蠻頭盔",
        ["Brutal Legguards"] = "野蠻腿甲",
        ["Brutal Politics"] = "野蠻外交",
        ["Building a Perimeter"] = "建立結界",
        ["Bungle in the Jungle"] = "擒蟲先擒王",
        ["Burn It Up... For the Horde!"] = "為了部落……燒了它!",
        ["Burning Blade Medallion"] = "火刃獎章",
        ["Burning Blood"] = "燃燒之血",
        ["Burning Shadows"] = "燃影之眼",
        ["Buying Time"] = "爭取時間",
        ["Buzzbox 323"] = "傳聲盒323號",
        ["Buzzbox 411"] = "傳聲盒411號",
        ["Buzzbox 525"] = "傳聲盒525號",
        ["Buzzbox 827"] = "傳聲盒827號",
        ["By Any Means Necessary"] = "用盡所有必須的手段",
        ["C'Thun's Legacy"] = "克蘇恩的遺產",
        ["CLUCK!"] = "咕咕嘎!",
        ["Cabal Orders"] = "卡巴的命令",
        ["Cache of Mau'ari"] = "瑪艾里的容器",
        ["Call of Air"] = "風的召喚",
        ["Call of Air - Guse's Fleet"] = "天空的召喚 - 古斯的部隊",
        ["Call of Air - Ichman's Fleet"] = "天空的召喚 - 艾克曼的空軍",
        ["Call of Air - Jeztor's Fleet"] = "天空的召喚 - 傑斯托的部隊",
        ["Call of Air - Mulverick's Fleet"] = "天空的召喚 - 穆維里克的部隊",
        ["Call of Air - Slidore's Fleet"] = "天空的召喚 - 斯里多爾的空軍",
        ["Call of Air - Vipore's Fleet"] = "天空的召喚 - 維波里的空軍",
        ["Call of Earth"] = "召喚大地",
        ["Call of Fire"] = "火焰的召喚",
        ["Call of Water"] = "水之召喚",
        ["Call to Arms"] = "短兵相接",
        ["Calling in the Reserves"] = "召回衛兵",
        ["Calm Before the Storm"] = "暴風雨前的寧靜",
        ["Camp Mojache"] = "莫沙徹營地",
        ["Can't Stay Away"] = "無法置身事外",
        ["Candles of Beckoning"] = "誘靈蠟燭",
        ["Cannibalistic Cousins"] = "野蠻的親戚",
        ["Cannons of Rage"] = "狂怒的火炮",
        ["Cape of Eternal Justice"] = "永恆公正斗篷",
        ["Captain Kelisendra's Lost Rutters"] = "凱利山德拉船長遺失的航海方針",
        ["Captain Sander's Hidden Treasure"] = "桑德爾船長的寶藏",
        ["Captain Tyralius"] = "泰拉里斯上尉",
        ["Captain Vimes"] = "維米斯隊長",
        ["Captives at Deatholme"] = "死亡之域俘虜",
        ["Capture a Mine"] = "佔領礦坑",
        ["Capture the Weapons"] = "奪取武器",
        ["Capturing the Keystone"] = "取得拱心石",
        ["Capturing the Phylactery"] = "取得護符",
        ["Carendin Summons"] = "凱倫丁的召喚",
        ["Carnival Boots"] = "狂歡節長靴",
        ["Carnival Jerkins"] = "狂歡節上衣",
        ["Carrion Grubbage"] = "腐肉蟲",
        ["Carry Your Weight"] = "新的背包",
        ["Castpipe's Task"] = "卡斯派普的任務",
        ["Catalogue of the Wayward"] = "遊蕩者目錄",
        ["Catch and Release"] = "標記魚人",
        ["Catch of the Day"] = "食魚度日",
        ["Caught!"] = "被鎖起來的矮人",
        ["Cave Mushrooms"] = "洞中的蘑菇",
        ["Celebrating Good Times"] = "英雄慶典",
        ["Celestial Power"] = "天國之力",
        ["Cenarion Aid"] = "幫助塞納里奧",
        ["Cenarion Battlegear"] = "塞納里奧戰鬥工具",
        ["Cenarius' Legacy"] = "塞納留斯的遺產",
        ["Centaur Bounty"] = "懸賞半人馬",
        ["Centaur Bracers"] = "半人馬護腕",
        ["Challenge Overlord Mok'Morokk"] = "挑戰莫格穆洛克主宰",
        ["Champion's Battlegear"] = "勇士的裝備",
        ["Chapter I"] = "荊棘谷的青山 - 第一章",
        ["Chapter II"] = "荊棘谷的青山 - 第二章",
        ["Chapter III"] = "荊棘谷的青山 - 第三章",
        ["Chapter IV"] = "荊棘谷的青山 - 第四章",
        ["Chasing A-Me 01"] = "找回艾米 01",
        ["Chen's Empty Keg"] = "老陳的空酒桶",
        ["Chicken Clucking for a Mint"] = "學小雞，換糖果",
        ["Chief Engineer Scooty"] = "首席工程師斯庫提",
        ["Chieftain Oomooroo"] = "歐沐魯酋長",
        ["Children's Week"] = "兒童週",
        ["Chillwind Horns"] = "冰風奇美拉角",
        ["Chimaeric Horn"] = "奇美拉之角",
        ["Cho'war the Pillager"] = "『掠取者』喬沃",
        ["Chromatic Mantle of the Dawn"] = "多彩黎明襯肩",
        ["Circlet of Faith"] = "信仰頭環",
        ["City of Light"] = "聖光之城",
        ["Claim Rackmore's Treasure!"] = "拉克摩爾的財寶!",
        ["Claiming the Light"] = "掌握聖光",
        ["Clam Bait"] = "蚌肉魚餌",
        ["Clamlette Surprise"] = "蚌肉大餐",
        ["Claws from the Deep"] = "海中的魚人",
        ["Cleaning up the Grounds"] = "清理地面",
        ["Cleansed Water Returns to Felwood"] = "淨化過的水",
        ["Cleansing Felwood"] = "淨化費伍德",
        ["Cleansing of the Infected"] = "清除疫疾",
        ["Cleansing of the Orb of Orahil"] = "奧拉赫寶珠的淨化",
        ["Cleansing the Eye"] = "淨化帕雷斯之眼",
        ["Cleansing the Scar"] = "淨化斷崖",
        ["Cleansing the Waters"] = "淨化水源",
        ["Clearing the Way"] = "清除道路",
        ["Clefthoof Mastery"] = "裂蹄專精",
        ["Cloak of Unending Life"] = "不滅生命披風",
        ["Cloak of Veiled Shadows"] = "矇矓之影披風",
        ["Cloak of the Gathering Storm"] = "聚集風暴披風",
        ["Cloak of the Unseen Path"] = "隱秘通途披風",
        ["Cloth and Leather Armor"] = "布甲和皮甲",
        ["Clues in the Thicket"] = "樹叢裡的線索",
        ["Coarse Weightstone"] = "粗製平衡石",
        ["Codex of Defense"] = "防禦寶典",
        ["Cohlien Frostweaver"] = "考林·織霜者",
        ["Coilfang Armaments"] = "盤牙裝備",
        ["Coldridge Valley Mail Delivery"] = "寒脊山谷的送信任務",
        ["Coldtooth Supplies"] = "冷齒礦坑補給品",
        ["Collecting Kelp"] = "收集海藻",
        ["Collecting Memories"] = "收集記憶",
        ["Collection of Goods"] = "收集材料",
        ["Collection of the Corrupt Water"] = "收集墮落之水",
        ["Colonel Kurzen"] = "庫爾森上校",
        ["Colossal Menace"] = "巨大的威脅",
        ["Combining Forces"] = "結合力量",
        ["Coming of Age"] = "是時候了",
        ["Commander Gor'shak"] = "指揮官哥沙克",
        ["Compendium of the Fallen"] = "墮落者綱要",
        ["Completing the Delivery"] = "完成遞送",
        ["Components for the Enchanted Gold Bloodrobe"] = "魔化金線血袍",
        ["Components of Importance"] = "重要的材料",
        ["Concerns About Tuurem"] = "與杜瑞有關",
        ["Concerted Efforts"] = "共同的努力",
        ["Confront Yeh'kinya"] = "面對葉基亞",
        ["Conjurer Luminrath"] = "咒術師盧瑞斯",
        ["Conqueror's Breastplate"] = "征服者的胸甲",
        ["Conqueror's Crown"] = "征服者之冠",
        ["Conqueror's Greaves"] = "征服者的脛甲",
        ["Conqueror's Legguards"] = "征服者的腿甲",
        ["Conqueror's Spaulders"] = "征服者的肩甲",
        ["Conscript of the Horde"] = "部落的新兵",
        ["Consecrated Letter"] = "聖化信件",
        ["Consecrated Rune"] = "神聖符文",
        ["Consortium Crystal Collection"] = "聯合團水晶收集",
        ["Constrictor Vines"] = "蟒藤",
        ["Consult Master Gadrin"] = "請教加德林大師",
        ["Consumed by Hatred"] = "復仇的怒火",
        ["Contact from Dalaran"] = "達拉然的聯繫",
        ["Containing the Threat"] = "遏制威脅",
        ["Continue to Stormwind"] = "趕赴暴風城",
        ["Continued Threat"] = "海中的威脅",
        ["Control"] = "控制魔法",
        ["Control Four Bases"] = "控制四座基地",
        ["Cookie's Jumbo Gumbo"] = "廚師的特大燴肉",
        ["Coolant Heads Prevail"] = "至關重要的冷卻劑",
        ["Copper Modulator"] = "銅質調節器",
        ["Core of Elements"] = "元素之心",
        ["Corki's Gone Missing Again!"] = "柯爾奇又不見了!",
        ["Corki's Ransom"] = "柯爾奇的贖金",
        ["Corrupted Soil"] = "被汙染的土壤",
        ["Corruption"] = "腐蝕",
        ["Corruption of Earth and Seed"] = "大地的污染",
        ["Cortello's Riddle"] = "科泰羅的謎題",
        ["Costly Menace"] = "損失慘重",
        ["Counterattack!"] = "人馬無雙!",
        ["Counting Out Time"] = "找回時間",
        ["Courser Antlers"] = "苔蹄快步者鹿角",
        ["Covert Ops - Alpha"] = "隱秘行動:A",
        ["Covert Ops - Beta"] = "隱秘行動:B",
        ["Coyote Thieves"] = "捕獵山狗",
        ["Crackin' Some Skulls"] = "解決一些傢伙",
        ["Cracking Maury's Foot"] = "打開瑪雷的木腳",
        ["Craftsman's Writ - Brightcloth Pants"] = "工匠令狀 - 亮布便褲",
        ["Craftsman's Writ - Dense Weightstone"] = "工匠令狀 - 緻密平衡石",
        ["Craftsman's Writ - Goblin Sapper Charge"] = "工匠令狀 - 哥布林工事炸藥",
        ["Craftsman's Writ - Greater Arcane Protection Potion"] = "工匠令狀 - 強效秘法防護藥水",
        ["Craftsman's Writ - Huge Thorium Battleaxe"] = "工匠令狀 - 巨型瑟銀戰斧",
        ["Craftsman's Writ - Major Healing Potion"] = "工匠令狀 - 極效治療藥水",
        ["Craftsman's Writ - Major Mana Potion"] = "工匠令狀 - 極效法力藥水",
        ["Craftsman's Writ - Plated Armorfish"] = "工匠令狀 - 板鱗魚",
        ["Craftsman's Writ - Runecloth Bag"] = "工匠令狀 - 符文布背包",
        ["Craftsman's Writ - Runecloth Boots"] = "工匠令狀 - 符文布靴",
        ["Craftsman's Writ - Runecloth Robe"] = "工匠令狀 - 符文布袍",
        ["Craftsman's Writ - Runic Leather Pants"] = "工匠令狀 - 符文皮甲便褲",
        ["Craftsman's Writ - Stonescale Eel"] = "工匠令狀 - 石鱗鰻",
        ["Craftsman's Writ - Thorium Grenade"] = "工匠令狀 - 瑟銀手榴彈",
        ["Craftsman's Writ - Thorium Tube"] = "工匠令狀 - 瑟銀管",
        ["Craftsman's Writ - Wicked Leather Headband"] = "工匠令狀 - 邪惡皮甲頭帶",
        ["Crashing the Wickerman Festival"] = "破壞稻草人節",
        ["Creating the Pendant"] = "製造墜飾",
        ["Creature of the Void"] = "虛空中的生物",
        ["Creatures of the Eco-Domes"] = "秘境的生物",
        ["Crime and Punishment"] = "罪與罰",
        ["Crimson Crystal Clue"] = "赤紅水晶線索",
        ["Crimson Templar"] = "赤紅聖殿騎士",
        ["Critters of the Void"] = "虛空異常者",
        ["Crocolisk Boy and the Bearded Murloc"] = "鱷魚小子和有鬍子的魚人",
        ["Crocolisk Hunting"] = "捕獵鱷魚",
        ["Crossroads Conscription"] = "十字路口的徵兵行動",
        ["Crown of the Earth"] = "大地之冠",
        ["Cruel Taskmasters"] = "殘酷的工頭",
        ["Cruel's Intentions"] = "殘忍的目的",
        ["Cruelfin's Necklace"] = "酷鰭的項鍊",
        ["Crush the Bloodmaul Camp"] = "粉碎血槌營地",
        ["Crush the Bloodmaul Camp!"] = "粉碎血槌營地!",
        ["Crushridge Bounty"] = "破碎嶺巨魔",
        ["Crushridge Warmongers"] = "破碎嶺好戰者",
        ["Cry of the Thunderhawk"] = "雷鷹的嘶鳴",
        ["Crypt Fiend Parts"] = "地穴惡魔部位",
        ["Cryptstalker Armor Doesn't Make Itself..."] = "地穴行者護甲的零件……",
        ["Cryptstalker Boots"] = "地穴行者長靴",
        ["Cryptstalker Girdle"] = "地穴行者束腰",
        ["Cryptstalker Handguards"] = "地穴行者手甲",
        ["Cryptstalker Headpiece"] = "地穴行者首盔",
        ["Cryptstalker Tunic"] = "地穴行者外套",
        ["Cryptstalker Wristguards"] = "地穴行者護腕",
        ["Crystal Charge"] = "爆炸水晶",
        ["Crystal Clear"] = "清除水晶的障礙",
        ["Crystal Cluster"] = "水晶簇",
        ["Crystal Force"] = "精神水晶",
        ["Crystal Restore"] = "恢復水晶",
        ["Crystal Spire"] = "尖刺水晶",
        ["Crystal Ward"] = "防禦水晶",
        ["Crystal Yield"] = "破甲水晶",
        ["Crystals of Power"] = "能量水晶",
        ["Cuergo's Gold"] = "科爾戈的黃金",
        ["Culinary Crunch"] = "香脆料理",
        ["Culling the Flutterers"] = "撲殺翼鳥",
        ["Culling the Threat"] = "解除威脅",
        ["Culling the Wild"] = "搶救自然",
        ["Curbing the Plague"] = "遏止瘟疫",
        ["Curing the Sick"] = "消除疾病",
        ["Curse These Fat Fingers"] = "該死的胖手指!",
        ["Curse of the Violet Tower"] = "紫羅蘭之塔的詛咒",
        ["Cursed Talismans"] = "被詛咒的護符",
        ["Cutting Teeth"] = "小試身手",
        ["Cutting Your Teeth"] = "割下你的牙齒",
        ["Cutting a Path"] = "清出一條路來",
        ["Cycle of Rebirth"] = "生生不息",
        ["Cyclonian"] = "塞克隆尼亞",
        ["Da Voodoo"] = "巫毒羽毛",
        ["Dadanga is Hungry!"] = "達丹加餓了!",
        ["Daelin's Men"] = "戴林的下屬",
        ["Dagger of Veiled Shadows"] = "矇矓之影匕首",
        ["Daggerfen Deviance"] = "匕首沼地的異常",
        ["Daily Delivery"] = "日常供貨",
        ["Dalar's Analysis"] = "達拉爾的推理",
        ["Dalaran Patrols"] = "達拉然巡邏隊",
        ["Dalaran's Intentions"] = "達拉然的意圖",
        ["Dalson's Tears Cauldron"] = "達爾松之淚的瘟疫之鍋",
        ["Damaged Mask"] = "破損的面具",
        ["Damning Evidence"] = "毀滅的證據",
        ["Dancing for Marzipan"] = "跳跳舞，換糖果",
        ["Dangerous!"] = "結伴而行",
        ["Dangers of the Windfury"] = "風怒鷹身人",
        ["Dar'Khan's Lieutenants"] = "達克汗的中尉",
        ["Dark Council"] = "黑暗議會",
        ["Dark Heart"] = "黑暗之心",
        ["Dark Iron Legacy"] = "黑鐵的遺產",
        ["Dark Iron Scraps"] = "黑鐵碎塊",
        ["Dark Storms"] = "黑暗風暴",
        ["Dark Tidings"] = "黑暗的消息",
        ["Dark Vessels"] = "黑暗之瓶",
        ["Darkmoon Beast Deck"] = "暗月野獸套卡",
        ["Darkmoon Elementals Deck"] = "暗月元素套卡",
        ["Darkmoon Portals Deck"] = "暗月傳送門套卡",
        ["Darkmoon Warlords Deck"] = "暗月督軍套卡",
        ["Darnassian Intrusions"] = "達納蘇斯的入侵",
        ["Data Rescue"] = "搶救資料",
        ["Dawn's Gambit"] = "黎明先鋒",
        ["Deactivate An'owyn"] = "關閉安歐恩水晶",
        ["Deactivating the Spire"] = "關閉尖塔能源",
        ["Dead Man's Plea"] = "逝者的請求",
        ["Dead-tooth Jack"] = "蛀牙傑克",
        ["Deadly Desert Venom"] = "沙漠中的劇毒",
        ["Deadly Predators"] = "痛恨的掠奪者",
        ["Deadmire"] = "死沼巨鱷",
        ["Deadwood of the North"] = "北方的死木熊怪",
        ["Deal With the Saboteurs"] = "處理活動破壞者",
        ["Dealing with Zeb'Sora"] = "與札布索拉交涉",
        ["Dealing with the Foreman"] = "解決工頭",
        ["Dealing with the Overmaster"] = "解決征服者",
        ["Dearest Natalia"] = "親愛的娜塔莉雅",
        ["Death From Below"] = "水下伏兵",
        ["Death's Door"] = "死亡之門",
        ["Death's Embrace"] = "死亡的擁抱",
        ["Deathdealer's Boots"] = "死亡執行者的長靴",
        ["Deathdealer's Helm"] = "死亡執行者的頭盔",
        ["Deathdealer's Vest"] = "死亡執行者的外衣",
        ["Deaths in the Family"] = "阿加曼德家族",
        ["Deathstalkers in Shadowfang"] = "影牙城堡裡的亡靈哨兵",
        ["Deceive thy Enemy"] = "矇騙敵人",
        ["Decipher the Tome"] = "解譯書籍",
        ["Deciphering the Book"] = "解讀這本書",
        ["Declaration of Power"] = "宣示力量",
        ["Decoy!"] = "螳螂捕蟬!",
        ["Deep Cover"] = "臥底密探",
        ["Deep Sea Salvage"] = "深海打撈",
        ["Deepmoss Spider Eggs"] = "深苔蜘蛛的卵",
        ["Deeprun Rat Roundup"] = "捕捉礦道老鼠",
        ["Defeat Nek'rosh"] = "擊敗納克羅西",
        ["Defenders of Darrowshire"] = "達隆郡的防衛者",
        ["Defending Fairbreeze Village"] = "保衛晴風村",
        ["Defiler's Basic Care Package"] = "污染者基本醫療包",
        ["Defiler's Standard Care Package"] = "污染者的標準醫療包",
        ["Defiling Uther's Tomb"] = "褻瀆烏瑟之墓",
        ["Deliver Them From Evil..."] = "傳遞不幸的消息……",
        ["Deliver Thomas' Report"] = "傳遞湯瑪斯的報告",
        ["Deliver the Gems"] = "運送寶石",
        ["Deliver the Plans to An'telas"] = "送計畫書到安泰拉斯",
        ["Deliver the Shipment"] = "運送貨物",
        ["Deliver the Thread"] = "鬼魂的髮絲",
        ["Deliver to MacKinley"] = "給馬克基雷的貨物",
        ["Deliveries to Sven"] = "給斯溫的物資",
        ["Delivering Daffodils"] = "水仙訴衷情",
        ["Delivering the Message"] = "傳遞訊息",
        ["Delivering the Relic"] = "遞送聖物",
        ["Delivery for Marin"] = "給馬林的粉末",
        ["Delivery to Andron Gant"] = "送貨給安德隆·甘特",
        ["Delivery to Archmage Xylem"] = "送貨給大法師克希雷姆",
        ["Delivery to Jes'rimon"] = "送貨給傑斯雷蒙",
        ["Delivery to Magatha"] = "瑪加薩的石版",
        ["Delivery to Ridgewell"] = "送貨給瑞治維爾",
        ["Delivery to Silverpine Forest"] = "給銀松森林送信",
        ["Delivery to Tranquillien"] = "送貨至安寧地",
        ["Delivery to the Gnomes"] = "送貨給地精",
        ["Delivery to the North Sanctum"] = "北部聖殿的貨物",
        ["Delivery to the Sepulcher"] = "送貨到瑟伯切爾",
        ["Demon Dogs"] = "惡魔之犬",
        ["Demonic Contamination"] = "惡魔污染",
        ["Demonic Crystal Prisons"] = "惡魔水晶監牢",
        ["Desert Recipe"] = "沙漠食譜",
        ["Desperate Prayer"] = "絕望禱言",
        ["Destiny Calls"] = "命運的召喚",
        ["Destroy Morphaz"] = "消滅摩弗拉斯",
        ["Destroy Naberius!"] = "消滅納伯瑞厄斯!",
        ["Destroy the Legion"] = "摧毀軍團",
        ["Deviate Eradication"] = "清除變異者",
        ["Deviate Hides"] = "變異皮革",
        ["Devils in Westfall"] = "西部荒野中的惡魔",
        ["Devourer of Souls"] = "噬魂者",
        ["Devouring Plague"] = "噬靈瘟疫",
        ["Diabolical Plans"] = "殘忍計畫",
        ["Diagnosis: Critical"] = "診斷:關鍵",
        ["Diaphanous Wings"] = "透明之翼",
        ["Did You Get The Note?"] = "你拿到筆記了嗎?",
        ["Did You Lose This?"] = "秘銀會的認可",
        ["Dig Rat Stew"] = "掘地鼠燉肉",
        ["Digging Through Bones"] = "挖掘骨頭",
        ["Digging Through the Dirt"] = "掘墓",
        ["Digging Through the Ooze"] = "搜尋軟泥怪",
        ["Digging for Prayer Beads"] = "挖掘祈禱珠串",
        ["Dimensius the All-Devouring"] = "吞沒者戴曼希爾斯",
        ["Diplomatic Measures"] = "外交的衡量",
        ["Dirge's Kickin' Chimaerok Chops"] = "迪爾格的超美味奇美拉肉片",
        ["Discover Rolf's Fate"] = "羅爾夫的下落",
        ["Disharmony of Fire"] = "不和諧的火焰",
        ["Disharmony of Flame"] = "不和諧的烈焰",
        ["Dispelling Evil"] = "驅散邪惡",
        ["Disrupt Their Reinforcements"] = "瓦解增援系統",
        ["Disrupt the Attacks"] = "野豬人的襲擊",
        ["Disruption - Forge Camp: Mageddon"] = "瓦解 - 煉冶場:黑色祭壇",
        ["Distracting Jarven"] = "加文的愛好",
        ["Distraction at Manaforge B'naar"] = "法力熔爐巴納爾的擾亂行動",
        ["Disturbance at Umbrafen Lake"] = "昂布拉凡湖的憂慮",
        ["Divination: Gorefiend's Armor"] = "預言:血魔的護甲",
        ["Divination: Gorefiend's Cloak"] = "預言:血魔的披風",
        ["Divination: Gorefiend's Truncheon"] = "預言:血魔之杖",
        ["Divine Retribution"] = "神聖的懲戒",
        ["Divino-matic Rod"] = "探水棒",
        ["Do My Eyes Deceive Me"] = "我眼花了嗎",
        ["Dogran's Captivity"] = "多格蘭之囚",
        ["Dolanaar Delivery"] = "多蘭納爾的貨物",
        ["Doling Justice"] = "菲拉斯的正義",
        ["Don't Drink the Water"] = "別喝那裡的水",
        ["Don't Kill the Fat One"] = "別殺那個胖子",
        ["Doom Weed"] = "末日草",
        ["Doomcaller's Circlet"] = "厄運召喚者的頭環",
        ["Doomcaller's Footwraps"] = "厄運召喚者的裹足",
        ["Doomcaller's Mantle"] = "厄運召喚者的披肩",
        ["Doomrigger's Clasp"] = "末日扣環",
        ["Doomsday Candle"] = "末日蠟燭",
        ["Doorway to the Abyss"] = "通往深淵的門戶",
        ["Doras the Wind Rider Master"] = "雙足飛龍管理員朵拉斯",
        ["Dousing the Flames of Protection"] = "熄滅火焰",
        ["Down With Daellis"] = "擊倒戴利斯",
        ["Down at the Docks"] = "降帆靠港",
        ["Down the Coast"] = "清理海岸",
        ["Down the Dead Scar"] = "進入死亡之痕",
        ["Down the Scarlet Path"] = "血色之路",
        ["Dr. Boom!"] = "布姆博士!",
        ["Draconic for Dummies"] = "龍語傻瓜教程",
        ["Draenethyst Crystals"] = "德萊尼水晶",
        ["Dragonkin Menace"] = "黑龍的威脅",
        ["Dragonmaw Shinbones"] = "龍喉脛骨",
        ["Dragonscale Leatherworking"] = "龍鱗製皮",
        ["Drain Schematics"] = "排水結構圖",
        ["Drakefire Amulet"] = "龍火護符",
        ["Drape of Unyielding Strength"] = "不屈力量披氅",
        ["Drape of Vaulted Secrets"] = "魔法秘密披氅",
        ["Dreadmaul Rock"] = "巨槌石",
        ["Dreadnaught Bracers"] = "無畏護腕",
        ["Dreadnaught Breastplate"] = "無畏胸甲",
        ["Dreadnaught Gauntlets"] = "無畏護手",
        ["Dreadnaught Helmet"] = "無畏盔帽",
        ["Dreadnaught Legplates"] = "無畏腿鎧",
        ["Dreadnaught Pauldrons"] = "無畏肩鎧",
        ["Dreadnaught Sabatons"] = "無畏馬靴",
        ["Dreadnaught Waistguard"] = "無畏護腰",
        ["Dreadsteed of Xoroth"] = "克索諾斯恐懼戰馬",
        ["Dream Dust in the Swamp"] = "沼澤中的幻夢之塵",
        ["Dreamwalker Boots"] = "夢行者長靴",
        ["Dreamwalker Girdle"] = "夢行者束腰",
        ["Dreamwalker Handguards"] = "夢行者手甲",
        ["Dreamwalker Headpiece"] = "夢行者頭盔",
        ["Dreamwalker Legguards"] = "夢行者腿甲",
        ["Dreamwalker Spaulders"] = "夢行者肩甲",
        ["Dreamwalker Tunic"] = "夢行者外套",
        ["Dreamwalker Wristguards"] = "夢行者護腕",
        ["Dressing the Part"] = "適宜的服裝",
        ["Driftwood"] = "曬乾的流木",
        ["Drijya Needs Your Help"] = "迪耶亞需要你的幫助",
        ["Drill the Drillmaster"] = "殺死訓練員蘇洛克",
        ["Drowned Sorrows"] = "船長的復仇",
        ["Druid of the Claw"] = "利爪德魯伊",
        ["Dry Times"] = "旱季",
        ["Duke Nicholas Zverenhoff"] = "尼古拉斯·瑟倫霍夫公爵",
        ["Dumphry's Request"] = "戴夫利的請求",
        ["Dungar Longdrink"] = "杜加爾·朗德瑞克",
        ["Dusky Crab Cakes"] = "黑蟹蛋糕",
        ["Dust from the Drakes"] = "幼龍身上的塵",
        ["Dwarven Digging"] = "矮人的挖掘場",
        ["Dwarven Justice"] = "矮人的正義",
        ["Dwarven Outfitters"] = "矮人的交易",
        ["Eagan Peltskinner"] = "伊根·派特斯金納",
        ["Earthen Arise"] = "土靈的覺醒",
        ["Earthen Templar"] = "土色聖殿騎士",
        ["Earthshatter Boots"] = "粉碎大地長靴",
        ["Easy Strider Living"] = "燉陸行鳥",
        ["Eating Damnation"] = "吃掉精髓",
        ["Echeyakee"] = "埃其亞基",
        ["Echoes of War"] = "戰爭的回響",
        ["Egg Collection"] = "收集龍蛋",
        ["Egg Freezing"] = "冷凍龍蛋",
        ["Egg Hunt"] = "蠍卵",
        ["Eight-Legged Menaces"] = "蜘蛛的威脅",
        ["Eitrigg's Wisdom"] = "伊崔格的智慧",
        ["Elanaria"] = "艾蘭娜瑞",
        ["Electro-Shock Goodness!"] = "電擊的啊呀!",
        ["Electropellers"] = "導電器",
        ["Elekks Are Serious Business"] = "伊萊克是嚴肅的職責",
        ["Elemental Bracers"] = "元素護腕",
        ["Elemental Leatherworking"] = "元素製皮",
        ["Elemental Power Extraction"] = "元素力量粹取",
        ["Elemental War"] = "元素戰爭",
        ["Elixir of Agony"] = "苦楚藥劑",
        ["Elixir of Pain"] = "痛苦藥劑",
        ["Elixir of Suffering"] = "受難藥劑",
        ["Elixirs for the Bladeleafs"] = "刃葉的藥劑",
        ["Elmore's Task"] = "艾爾默的任務",
        ["Elune's Tear"] = "月神之淚",
        ["Elven Legends"] = "精靈的傳說",
        ["Emberstrife"] = "艾博斯塔夫",
        ["Emphasis on Sacrifice"] = "犧牲精神",
        ["Empty Stables"] = "補充坐騎",
        ["En-Ay-Es-Tee-Why"] = "蜘蛛卵",
        ["Enchanted Azsharite Fel Weaponry"] = "魔化艾薩拉水晶武器",
        ["Enchanted Thorium Platemail: Volume I"] = "附魔瑟銀鎧甲:第一卷",
        ["Enchanted Thorium Platemail: Volume II"] = "附魔瑟銀鎧甲:第二卷",
        ["Enchanted Thorium Platemail: Volume III"] = "附魔瑟銀鎧甲:第三卷",
        ["Encoded Fragments"] = "密碼碎片",
        ["Encroaching Gnolls"] = "豺狼人的入侵",
        ["Encroaching Wildlife"] = "逼近的野獸",
        ["Encroachment"] = "野豬人的進犯",
        ["Encrusted Tail Fins"] = "堅硬的尾鰭",
        ["Encrypted Letter"] = "密文信件",
        ["Encrypted Memorandum"] = "密文備忘錄",
        ["Encrypted Parchment"] = "密文羊皮紙",
        ["Encrypted Rune"] = "密文符文",
        ["Encrypted Scroll"] = "密文卷軸",
        ["Encrypted Sigil"] = "密文符記",
        ["Encrypted Tablet"] = "密文石板",
        ["Encrypted Twilight Texts"] = "暮光加密文件",
        ["Ending Their World"] = "結束他們的世界",
        ["Ending the Bloodcurse"] = "終止血咒",
        ["Enemy Booty"] = "敵人的物資",
        ["Enemy of my Enemy..."] = "敵人的敵人……",
        ["Enigma Boots"] = "神秘長靴",
        ["Enigma Circlet"] = "神秘頭環",
        ["Enigma Shoulderpads"] = "神秘肩墊",
        ["Enraged Spirits"] = "怒靈",
        ["Enraged Spirits of Air"] = "暴怒的風之靈",
        ["Enraged Spirits of Fire and Earth"] = "火與大地的暴怒之靈",
        ["Enraged Spirits of Water"] = "暴怒的水之靈",
        ["Enraged Thunder Lizards"] = "被激怒的雷霆蜥蜴",
        ["Enraged Wildkin"] = "被激怒的梟獸",
        ["Enticing Negolash"] = "引誘奈古拉什",
        ["Entry Into Karazhan"] = "卡拉贊的入口",
        ["Entry Into the Citadel"] = "進入堡壘",
        ["Envoy to the Mag'har"] = "瑪格哈使者",
        ["Epic Armaments of Battle - Exalted Amongst the Dawn"] = "史詩級軍備之戰-銀色黎明聲望崇拜",
        ["Eradicate the Burning Legion"] = "徹底消滅燃燒軍團",
        ["Erion Shadewhisper"] = "艾里安·影語",
        ["Erion's Behest"] = "艾里安的命令",
        ["Errand for Apothecary Zinge"] = "金格的貨物",
        ["Escape Through Force"] = "殺出重圍",
        ["Escape Through Stealth"] = "偷偷溜走",
        ["Escape from Durnholde"] = "逃離敦霍爾德",
        ["Escape from Firewing Point!"] = "逃出火翼崗哨!",
        ["Escape from Umbrafen"] = "逃離昂布拉凡",
        ["Escape from the Catacombs"] = "地下墓穴大逃殺",
        ["Escape from the Staging Grounds"] = "逃離軍事要塞",
        ["Escaping the Tomb"] = "逃出墓穴",
        ["Escorting Erland"] = "護送埃蘭德",
        ["Essence for the Engines"] = "引擎的精華",
        ["Essence of the Exile"] = "流放精華",
        ["Essential Artificials"] = "基礎模組",
        ["Establishing New Outposts"] = "建立新前哨",
        ["Etched Note"] = "風化便箋",
        ["Etched Parchment"] = "風蝕羊皮紙",
        ["Etched Rune"] = "風蝕符文",
        ["Etched Sigil"] = "風化符記",
        ["Etched Tablet"] = "風蝕石板",
        ["Ethereum Data"] = "伊斯利恩資料",
        ["Evershine"] = "艾沃沙酒",
        ["Everything Counts In Large Amounts"] = "多多益善",
        ["Everything Will Be Alright"] = "一切都會很好",
        ["Evil Bat Eyes"] = "邪惡的蝙蝠眼",
        ["Evil Draws Near"] = "邪惡逼近",
        ["Examine the Vessel"] = "複生之瓶",
        ["Excavation Progress Report"] = "挖掘進度報告",
        ["Excelsior"] = "刨花皮靴",
        ["Exorcising Terrordale"] = "恐懼谷的靈魂",
        ["Exorcising the Trees"] = "為樹木驅魔",
        ["Expedition Point"] = "遠征隊哨塔",
        ["Expedition Salvation"] = "搶救物資",
        ["Expert Blacksmith!"] = "鍛造專家!",
        ["Extinguish the Firegut"] = "消滅火腹巨魔",
        ["Extinguishing the Idol"] = "封印塑像",
        ["Eye of the Emberseer"] = "艾博希爾之眼",
        ["Ezekiel"] = "伊斯奇歐",
        ["FIFTY! YEP!"] = "五十個!",
        ["Faerie Dragon Muisek"] = "精靈龍靈魂精華",
        ["Failed Incursion"] = "入侵失敗",
        ["Fairbreeze Village"] = "晴風村",
        ["Falcon Watch"] = "獵鷹哨站",
        ["Falcon's Call"] = "獵鷹的召喚",
        ["Fall From Grace"] = "失落的榮耀",
        ["Fall of Dun Modr"] = "丹莫德的陷落",
        ["Fallen Sky Lake"] = "墜星湖",
        ["Fallen Sky Lords"] = "被捕的空軍指揮官",
        ["Falling to Corruption"] = "墮落熊怪",
        ["Falrin's Vendetta"] = "法琳的仇恨",
        ["Familiar Fungi"] = "熟悉的蘑菇",
        ["Family Tree"] = "族譜",
        ["Farren's Proof"] = "法爾林的證據",
        ["Farstrider Retreat"] = "遠行者居所",
        ["Favor of the Gronn"] = "古羅的支持",
        ["Favored of Elune?"] = "月神之獸?",
        ["Feast at the Blue Recluse"] = "盛筵",
        ["Featherbeard's Endorsement"] = "羽鬚的背書",
        ["Feathermoon Stronghold"] = "羽月要塞",
        ["Feathers for Grazle"] = "給格拉茲的羽毛",
        ["Feathers for Nafien"] = "給納菲恩的羽毛",
        ["Fei Fei's Treat"] = "菲菲的狗餅乾",
        ["Fel Armaments"] = "地獄部隊",
        ["Fel Embers"] = "地獄餘燼",
        ["Fel Orc Plans"] = "地獄獸人計畫",
        ["Fel Orc Scavengers"] = "地獄獸人拾荒者",
        ["Fel Spirits"] = "惡魔靈魂",
        ["Felbound Ancients"] = "被禁錮的古樹",
        ["Felendren the Banished"] = "被流放的法蘭德倫",
        ["Felling an Ancient Tree"] = "砍伐古老之樹",
        ["Felnok Steelspring"] = "菲諾克",
        ["Felspark Ravine"] = "黂閃深谷",
        ["Felstone Field Cauldron"] = "費爾斯通農場的瘟疫之鍋",
        ["Felsworn Gas Mask"] = "邪誓防毒面具",
        ["Fenwick Thatros"] = "芬維克·薩托斯",
        ["Feralas: A History"] = "菲拉斯的歷史",
        ["Ferocitas the Dream Eater"] = "『食夢者』菲羅斯塔",
        ["Fertile Spores"] = "仙人掌孢子",
        ["Fetch!"] = "去吧!",
        ["Field Duty"] = "戰地任務",
        ["Fields of Grief"] = "悲傷之地",
        ["Fierce Enemies"] = "殘暴的敵人",
        ["Fiery Blaze Enchantments"] = "黑龍之火",
        ["Fiery Menace!"] = "熔岩蜘蛛的威脅!",
        ["Fiery Plate Gauntlets"] = "熾熱鎧甲護手",
        ["Filling the Soul Gem"] = "靈魂寶石",
        ["Filthy Paws"] = "骯髒的爪子",
        ["Final Passage"] = "最後的旅程",
        ["Final Preparations"] = "最後的準備",
        ["Find Acteon!"] = "找到艾克緹昂!",
        ["Find Agmond"] = "尋找埃格蒙德",
        ["Find Bingles"] = "尋找賓格斯",
        ["Find Keltus Darkleaf"] = "找到卡特斯·暗葉",
        ["Find Myranda"] = "尋找米蘭達",
        ["Find OOX-09/HL!"] = "找到OOX-09/HL!",
        ["Find OOX-17/TN!"] = "尋找OOX-17/TN!",
        ["Find OOX-22/FE!"] = "尋找OOX-22/FE!",
        ["Find Ranshalla"] = "蘭莎爾拉",
        ["Find Spy To'gun"] = "找尋間諜·吐剛",
        ["Find the Deserter"] = "找出背棄者",
        ["Find the Gems"] = "尋找寶石",
        ["Find the Gems and Power Source"] = "尋找寶貝",
        ["Find the Lost Guards"] = "失蹤的衛兵",
        ["Find the Shattered Hand"] = "尋找破碎之手氏族",
        ["Finding the Antidote"] = "尋找解毒劑",
        ["Finding the Keymaster"] = "找到鑰匙持有者",
        ["Finding the Shadowy Figure"] = "搜尋烏鴉嶺",
        ["Finding the Source"] = "究根問底",
        ["Finding the Survivors"] = "找到生還者",
        ["Fine Gold Thread"] = "優質金線",
        ["Fiora Longears"] = "菲歐拉·長耳",
        ["Fire At Will!"] = "自由開火!",
        ["Fire Hardened Mail"] = "弗倫的鎧甲",
        ["Fire Plume Forged"] = "火羽山",
        ["Fire Sapta"] = "火焰靈契",
        ["Fire Taboo"] = "火焰管制",
        ["Firewing Signets"] = "火翼徽章",
        ["Fish in a Bucket"] = "坐享其成",
        ["Flash Bomb Recipe"] = "閃光彈的製法",
        ["Flawed Power Stone"] = "有瑕疵的能量石",
        ["Flawless Fel Essence"] = "無暇的惡魔精華",
        ["Flexing for Nougat"] = "顯肌肉，換糖果",
        ["Flight to Auberdine"] = "飛往奧伯丁",
        ["Flint Shadowmore"] = "弗林特·沙多摩爾",
        ["Flora of the Eco-Domes"] = "秘境植物群",
        ["Flute of Xavaric"] = "薩瓦里克長笛",
        ["Fly to Silvermoon City"] = "飛往銀月城",
        ["Follow the Breadcrumbs"] = "跟著痕跡走",
        ["Food for Baby"] = "小精龍的食物",
        ["Footwraps of the Oracle"] = "神諭者的裹足",
        ["For All To See"] = "萬眾敬仰",
        ["For Great Honor"] = "無上的榮耀",
        ["For Love Eternal"] = "永志不渝",
        ["For The Horde!"] = "為部落而戰!",
        ["For the Fallen"] = "為了垂死的同伴",
        ["Forbidden Knowledge"] = "禁斷的知識",
        ["Force Commander Danath"] = "軍隊指揮官達納斯·托爾貝恩",
        ["Forces of Jaedenar"] = "加德納爾的勢力",
        ["Foreboding Plans"] = "預備行動計畫",
        ["Forge Camp: Annihilated"] = "煉冶場:徹底擊潰",
        ["Forge Camp: Mageddon"] = "煉冶場:黑色祭壇",
        ["Forged Steel"] = "鍛造好的鋼錠",
        ["Forging the Mightstone"] = "鑄造力量之石",
        ["Forging the Shaft"] = "鑄造火炬桿",
        ["Forging the Weapon"] = "鑄造武器",
        ["Forgotten Rituals"] = "被遺忘的儀式",
        ["Formal Introductions"] = "正式自我介紹",
        ["Foror's Compendium"] = "弗洛爾的屠龍技術綱要",
        ["Forsaken Aid"] = "被遺忘者的援助",
        ["Forsaken Diseases"] = "被遺忘者的病菌",
        ["Forsaken Duties"] = "亡靈衛兵的職責",
        ["Forward Base: Reaver's Fall"] = "前方據點:搶奪者荒野",
        ["Foul Magics"] = "邪惡的魔法",
        ["Fouled Water Spirits"] = "污濁的水精靈",
        ["Fragmented Magic"] = "破碎的魔法",
        ["Fragments of the Orb of Orahil"] = "寶珠碎片",
        ["Fragments of the Past"] = "歷史的殘片",
        ["Frame of Atiesh"] = "阿泰絲之杖的骨架",
        ["Free From the Hold"] = "逃離監牢",
        ["Free at Last"] = "終獲自由",
        ["Freed from the Hive"] = "逃離蟲巢",
        ["Freedom for All Creatures"] = "所有生物的自由",
        ["Freedom to Ruul"] = "盧爾的自由",
        ["Fresh Meat"] = "新鮮的螃蟹腿",
        ["Fresh from the Mechanar"] = "麥克那爾的容器",
        ["From The Wreckage...."] = "海底沉船",
        ["From the Abyss"] = "來自深淵",
        ["From the Ashes"] = "來自灰燼",
        ["Frostfire Belt"] = "霜火腰帶",
        ["Frostfire Bindings"] = "霜火束腕",
        ["Frostfire Circlet"] = "霜火頭環",
        ["Frostfire Gloves"] = "霜火手套",
        ["Frostfire Leggings"] = "霜火護腿",
        ["Frostfire Robe"] = "霜火長袍",
        ["Frostfire Sandals"] = "霜火便鞋",
        ["Frostfire Shoulderpads"] = "霜火肩墊",
        ["Frostmane Hold"] = "霜鬃食人妖要塞",
        ["Frostmaul E'ko"] = "霜槌魂精",
        ["Frostmaw"] = "霜喉雪人",
        ["Frostsaber E'ko"] = "霜刃魂精",
        ["Frostsaber Provisions"] = "霜刃豹的糧食",
        ["Fruit of the Sea"] = "海中的水果",
        ["Fuel for the Zapping"] = "壓縮器的動力",
        ["Fulgor Spores"] = "明亮孢子",
        ["Full Triangle"] = "完整三角形",
        ["Fumping"] = "太鼓之音",
        ["Fungal Spores"] = "菌類孢子",
        ["Furlbrow's Deed"] = "法布隆的地契",
        ["Further Concerns"] = "衛兵湯瑪斯",
        ["Further Corruption"] = "更深重的墮落",
        ["Further Instructions"] = "新的指示",
        ["Further Mysteries"] = "更大的謎團",
        ["Gadgetzan Water Survey"] = "加基森水業公司的調查報告",
        ["Gaffer Jacks"] = "小齒輪",
        ["Gahrron's Withering Cauldron"] = "蓋羅恩農場的瘟疫之鍋",
        ["Gahz'ridian"] = "加茲瑞迪安",
        ["Gahz'rilla"] = "加茲瑞拉",
        ["Gaining Acceptance"] = "獲得信任",
        ["Gaining Access"] = "進入的方法",
        ["Gaining Mirren's Trust"] = "贏得麥倫的信任",
        ["Gakin's Summons"] = "加科因的召喚",
        ["Galaen's Fate"] = "高拉恩的命運",
        ["Galaen's Journal - The Fate of Vindicator Saruan"] = "高拉恩的日誌 - 復仇者薩魯安的命運",
        ["Galen's Escape"] = "加林的逃亡",
        ["Galgar's Cactus Apple Surprise"] = "戈加爾的清涼果",
        ["Galvan's Finest Pupil"] = "加爾文的得意門生",
        ["Gan'rul's Summons"] = "甘盧爾的召喚",
        ["Gann's Reclamation"] = "加恩的報復",
        ["Garments of Spirituality"] = "靈魂之衣",
        ["Garments of the Light"] = "聖光之衣",
        ["Garments of the Moon"] = "月光之衣",
        ["Garona: A Study on Stealth and Treachery"] = "迦羅娜:潛行與詭計研究",
        ["Gateway to the Frontier"] = "前線之門",
        ["Gather Rot Blossoms"] = "收集腐敗之花",
        ["Gather the Orbs"] = "收集寶珠",
				["Gathering Idols"] = "收集塑像",
        ["Gathering Leather"] = "收集皮革",
        ["Gathering Materials"] = "收集原料",
        ["Gathering the Cure"] = "收集解藥",
        ["Gathering the Reagents"] = "收集材料",
        ["Gauging the Resonant Frequency"] = "測量共振的頻率",
        ["Gava'xi"] = "卡沃希",
        ["Gavel of Infinite Wisdom"] = "無盡智慧裁決槌",
        ["Gearing Redridge"] = "支援赤脊山",
        ["Gelkis Alliance"] = "吉爾吉斯族的聯盟",
        ["General Drakkisath's Command"] = "達基薩斯將軍的命令",
        ["General Drakkisath's Demise"] = "達基薩斯將軍之死",
        ["Genesis Boots"] = "起源長靴",
        ["Genesis Helm"] = "起源頭盔",
        ["Genesis Shoulderpads"] = "起源肩墊",
        ["Genesis Trousers"] = "起源長褲",
        ["Genesis Vest"] = "起源外套",
        ["Gerenzo Wrenchwhistle"] = "格雷蘇",
        ["Gerenzo's Orders"] = "格雷蘇的要求",
        ["Get Me Out of Here!"] = "救我出去!",
        ["Get the Gnomes Drunk"] = "灌醉地精",
        ["Get the Goblins Drunk"] = "灌醉哥布林",
        ["Get the Scoop"] = "解封咒語",
        ["Getting Down to Business"] = "動手幹活",
        ["Getting the Bladespire Tanked"] = "灌醉劍刃巨魔",
        ["Ghost Hair Thread"] = "幽靈的髮絲",
        ["Ghost-o-plasm Round Up"] = "鬼魂電漿",
        ["Ghoulish Effigy"] = "食屍鬼假人",
        ["Give Gerard a Drink"] = "吉拉德的飲料",
        ["Gizelton Caravan"] = "基澤爾頓車隊",
        ["Gizmo for Warug"] = "瓦魯格的玩具",
        ["Glowcap Mushrooms"] = "白閃菇",
        ["Glowing Scorpid Blood"] = "閃光的蠍血",
        ["Glyphed Oaken Branch"] = "雕紋橡木樹枝",
        ["Glyphic Letter"] = "雕紋信件",
        ["Glyphic Memorandum"] = "雕紋備忘錄",
        ["Glyphic Scroll"] = "雕紋卷軸",
        ["Glyphic Tablet"] = "雕紋石板",
        ["Gnarlpine Corruption"] = "瘤背熊怪的墮落",
        ["Gnogaine"] = "諾恩",
        ["Gnome Engineering"] = "地精工程學",
        ["Gnome Improvement"] = "地精的手藝",
        ["Gnomer-gooooone!"] = "出發!諾姆瑞根!",
        ["Go to the Front"] = "到前線去",
        ["Goblin Invaders"] = "哥布林侵略者",
        ["Goblin Sponsorship"] = "哥布林贊助商",
        ["Gol'dir"] = "高迪爾",
        ["Gold Dust Exchange"] = "金砂交易",
        ["Goldenmist Village"] = "金霧村",
        ["Goldleaf's Discovery"] = "金葉的發現",
        ["Goldtooth"] = "金牙",
        ["Good Luck Charm"] = "好運符咒",
        ["Good Natured Emma"] = "善良的艾瑪",
        ["Goods from Silvermoon City"] = "銀月城的貨物",
        ["Gor'tesh the Brute Lord"] = "蠻王戈泰什",
        ["Gordo's Task"] = "葛爾多的任務",
        ["Gordunni Cobalt"] = "戈杜尼鈷礦石",
        ["Goretusk Liver Pie"] = "豬肝餡餅",
        ["Gorgrom the Dragon-Eater"] = "食龍者柯爾葛羅姆",
        ["Grand Master Dumphry"] = "戴夫利大師",
        ["Grand Master Rohok"] = "大師洛赫克",
        ["Grape Manifest"] = "葡萄出貨單",
        ["Grark Lorkrub"] = "格拉克·洛克魯布",
        ["Graverobbers"] = "盜墓賊",
        ["Greatfather Winter is Here!"] = "冬天爺爺在這裡!",
        ["Greed"] = "貪婪",
        ["Green Fireworks"] = "綠色煙火",
        ["Green Iron Bracers"] = "綠鐵護腕",
        ["Grey Iron Weapons"] = "灰鐵武器",
        ["Grillok \"Darkeye\""] = "葛銳洛克『暗眼』",
        ["Grim Message"] = "可怕的消息",
        ["Grimand Elmore"] = "祝福之臂",
        ["Grimand's Armor"] = "格瑞曼德的鎧甲",
        ["Grimand's Finest Work"] = "艾爾默的手藝",
        ["Grime-Encrusted Ring"] = "髒兮兮的戒指",
        ["Grimscale Pirates!"] = "厲鱗劫掠者!",
        ["Grimtotem Spying"] = "偵察恐怖圖騰族",
        ["Grove of the Ancients"] = "古樹之林",
        ["Gryphon Master Talonaxe"] = "獅鷲獸管理員",
        ["Gryth Thurden"] = "格萊斯·瑟登",
        ["Guarded Thunderbrew Barrel"] = "戒備森嚴",
        ["Guardians of the Altar"] = "祭壇守護者",
        ["Guarding Secrets"] = "守護秘密",
        ["Guile of the Raptor"] = "迅猛龍的狡詐",
        ["Gurf's Dignity"] = "克夫的尊嚴",
        ["Gurok the Usurper"] = "『篡位者』古羅克",
        ["Gyro... What?"] = "發條式什麼什麼儀",
        ["Gyrodrillmatic Excavationators"] = "陀螺式挖掘機",
        ["Gyromast's Retrieval"] = "基爾卡克的鑰匙復原",
        ["Gyromast's Revenge"] = "基爾卡克的報復",
        ["HELP!"] = "救命!",
        ["Halgar's Summons"] = "哈加爾的召喚",
        ["Hallow's End Treats for Jesper!"] = "史波普的萬鬼節糖果!",
        ["Hallow's End Treats for Spoops!"] = "賈斯伯的萬鬼節糖果!",
        ["Hallowed Letter"] = "神聖信件",
        ["Hallowed Rune"] = "聖化符文",
        ["Hallowed Scroll"] = "神聖卷軸",
        ["Hallowed Sigil"] = "神聖符記",
        ["Hallowed Tablet"] = "神聖石板",
        ["Hameya's Plea"] = "哈米亞的請求",
        ["Hammerfall"] = "落錘鎮",
        ["Hamuul Runetotem"] = "哈繆爾·符文圖騰",
        ["Hand of Iruxos"] = "埃盧梭斯之手",
        ["Handle With Care"] = "小心運送",
        ["Hands of the Enemy"] = "敵人之手",
        ["Harbinger of Doom"] = "厄運先驅者",
        ["Harbingers of Shadowmoon"] = "影月先驅者",
        ["Hardened Shells"] = "硬化龜殼",
        ["Harlan Needs a Resupply"] = "哈蘭需要供貨",
        ["Harnessing Shadows"] = "束縛之影",
        ["Harpies Threaten"] = "鷹身人的威脅",
        ["Harpy Lieutenants"] = "鷹身人首領",
        ["Harpy Raiders"] = "鷹身劫掠者",
        ["Harvesting the Fel Ammunition"] = "獲得地獄彈藥",
        ["Have You Ever Seen One of These?"] = "你看過他們嗎?",
        ["Haze of Evil"] = "邪惡之霧",
        ["He Called Himself Altruis..."] = "他自稱奧翠司……",
        ["Healing the Lake"] = "拯救湖泊",
        ["Healthy Dragon Scale"] = "健康的龍鱗",
        ["Heart of Rage"] = "狂怒之心",
        ["Hearts of Zeal"] = "狂熱之心",
        ["Hearts of the Pure"] = "純潔者之心",
        ["Heartswood"] = "同心樹",
        ["Heavy Grinding Stone"] = "重砂輪",
        ["Heirloom Weapon"] = "祖傳武器",
        ["Helcular's Revenge"] = "赫爾庫拉的復仇",
        ["Hellfire Fortifications"] = "地獄火防禦堡壘",
        ["Help Mama Wheeler"] = "協助威勒媽媽",
        ["Help Ranger Valanna!"] = "幫幫遊俠瓦拉娜!",
        ["Help Tavara"] = "幫助塔瓦拉",
        ["Help Watcher Biggs"] = "幫助看守者比格斯",
        ["Helping the Cenarion Post"] = "協助塞納里奧前哨",
        ["Helping the Lost Find Their Way"] = "幫迷失者找到方向",
        ["Hemet Nesingwary Jr."] = "小赫米特·奈辛瓦里",
        ["Hero of the Brood"] = "世代的拯救者",
        ["Hero of the Mag'har"] = "瑪格哈的英雄",
        ["Hero of the Sin'dorei"] = "辛多雷的英雄",
        ["Hero of the Stormpike"] = "雷矛英雄",
        ["Heroes of Darrowshire"] = "達隆郡的英雄",
        ["Heroes of Old"] = "古代英雄",
        ["Hex of Weakness"] = "虛弱妖術",
        ["Hezrul Bloodmark"] = "赫茲盧爾·血印",
        ["Hidden Enemies"] = "隱藏的敵人",
        ["Hidden Secrets"] = "隱藏的秘密",
        ["Hidden Treasures"] = "隱藏的寶藏",
        ["High Chief Winterfall"] = "冬泉酋長",
        ["High Sorcerer Andromath"] = "高階巫士安多瑪斯",
        ["High Value Targets"] = "高重要性的目標",
        ["Highperch Venom"] = "風巢雙足飛龍的毒囊",
        ["Hilary's Necklace"] = "希拉蕊的項鍊",
        ["Hinott's Assistance"] = "希諾特的幫助",
        ["Hints of a New Plague?"] = "新的瘟疫?",
        ["Hints of the Past"] = "過去的線索",
        ["Hippogryph Master Stephanos"] = "角鷹獸管理員史丹樊那斯",
        ["Hippogryph Muisek"] = "角鷹獸靈魂精華",
        ["Hitting the Motherlode"] = "摘下母礦",
        ["Hive'Ashi Scout Report"] = "亞什蟲巢偵察報告",
        ["Hive'Regal Scout Report"] = "雷戈蟲巢偵察報告",
        ["Hive'Zora Scout Report"] = "佐拉蟲巢偵察報告",
        ["Hoary Templar"] = "蒼白聖殿騎士",
        ["Holy Bologna: What the Light Won't Tell You"] = "光明不會告訴你的事情",
        ["Homeward Bound"] = "回家",
        ["Honor Students"] = "榮譽學員",
        ["Honor the Dead"] = "逝者的榮耀",
        ["Honor the Fallen"] = "榮耀失落者",
        ["Honored Amongst the Clan"] = "氏族的尊敬",
        ["Honored Amongst the Guard"] = "衛兵的尊敬",
        ["Honoring a Hero"] = "緬懷英雄",
        ["Hoodoo Hex"] = "不祥的妖術",
        ["Horde Presence"] = "部落的示威",
        ["Horde Trauma"] = "部落醫療隊",
        ["Horns of Frenzy"] = "瘋狂之角",
        ["Host of the Hidden City"] = "隱秘城市的主人",
        ["Hostile Takeover"] = "惡性競爭",
        ["Hot Fiery Death"] = "火熱的死亡",
        ["Hotter than Hell"] = "比地獄還熱",
        ["Houses of the Holy"] = "神聖之屋",
        ["How Big a Threat?"] = "熊怪的威脅",
        ["How to Break Into the Arcatraz"] = "闖入亞克崔茲的方法",
        ["Howling in the Hills"] = "山中的嚎叫",
        ["Humbert's Sword"] = "亨伯特的長劍",
        ["Humble Beginnings"] = "童年的記憶",
        ["Hungry!"] = "飢餓的虛空鰭刺",
        ["Hunt for Yenniku"] = "耶尼庫的下落",
        ["Hunt the Savages"] = "野蠻的梟獸",
        ["Hunting for Ectoplasm"] = "尋找外膜",
        ["Hunting in Stranglethorn"] = "荊棘谷狩獵",
        ["Hurley Blackbreath"] = "霍爾雷·黑鬚",
        ["Hypercapacitor Gizmo"] = "超適應齒輪",
        ["I Got Nothin' Left!"] = "我已經傾囊相授了!",
        ["I Know A Guy..."] = "我認識一個傢伙…",
        ["I Must Have Them!"] = "我一定要擁有它們!",
        ["I See Alcaz Island In Your Future..."] = "我看見你的未來有奧卡茲島……",
        ["I See Dead Draenei"] = "我看到了德萊尼的鬼魂",
        ["I Shoot Magic Into the Darkness"] = "向黑暗中發射魔法",
        ["I Was A Lot Of Things..."] = "我經歷過很多事……",
        ["I Work... For the Horde!"] = "我替……部落工作!",
        ["I'm Saved!"] = "我得救了!",
        ["I've Got a Plant"] = "我要一棵樹",
        ["Ice Thistle E'ko"] = "冰草魂精",
        ["Identify Plant Parts"] = "辨別植物組織",
        ["Identifying the Brood"] = "群龍之首",
        ["Idols of the Feralfen"] = "菲拉芬塑像",
        ["Ignition"] = "打火鑰匙",
        ["Ill Omens"] = "邪惡的預兆",
        ["Illidan's Pupil"] = "伊利丹的弟子",
        ["Illidari-Bane Shard"] = "伊利達瑞毀滅裂片",
        ["Imbuing the Headpiece"] = "浸注權杖頭",
        ["Impending Attack"] = "逼近的攻擊",
        ["Imperial Plate Armor"] = "帝國的金屬盔甲",
        ["Imperial Plate Belt"] = "君王鎧甲腰帶",
        ["Imperial Plate Boots"] = "君王鎧甲靴",
        ["Imperial Plate Bracer"] = "君王鎧甲護腕",
        ["Imperial Plate Chest"] = "君王鎧甲護胸",
        ["Imperial Plate Helm"] = "君王鎧甲頭盔",
        ["Imperial Plate Leggings"] = "君王鎧甲護腿",
        ["Imperial Plate Shoulders"] = "君王鎧甲護肩",
        ["Imperial Qiraji Regalia"] = "其拉帝王徽記",
        ["Improved Quality"] = "更高的品質",
        ["In A Scrap With The Legion"] = "與軍團一戰",
        ["In Defense of Frostwolf"] = "保衛霜狼氏族",
        ["In Defense of the King's Lands"] = "保衛國王的領土",
        ["In Dreams"] = "在夢中",
        ["In Eranikus' Own Words"] = "幫助伊蘭尼庫斯",
        ["In Favor of Elune"] = "月神的恩賜",
        ["In Favor of Spirituality"] = "部族的傳統",
        ["In Favor of the Light"] = "聖光的恩賜",
        ["In Good Hands"] = "妥善保管",
        ["In Good Taste"] = "好味道",
        ["In Need of Felblood"] = "需要惡魔鮮血",
        ["In Nightmares"] = "在噩夢中",
        ["In Pursuit of Featherbeard"] = "追蹤羽鬚",
        ["In Search of Anthion"] = "尋找安希恩",
        ["In Search of Farahlite"] = "尋找法拉萊特",
        ["In Search of Galvan"] = "尋找加爾文",
        ["In Search of Knowledge"] = "尋找知識",
        ["In Search of Menara Voidrender"] = "尋找梅納拉·沃倫德",
        ["In Search of Sedai"] = "尋找希戴",
        ["In Search of Thaelrid"] = "尋找塞爾瑞德",
        ["In Search of The Excavation Team"] = "尋找挖掘隊",
        ["In Search of The Temple"] = "調查神廟",
        ["In the Name of the Light"] = "以聖光之名",
        ["Incendius!"] = "伊森迪奧斯!",
        ["Incendosaurs? Whateverosaur is More Like It"] = "燻火龍",
        ["Incoming Gumdrop"] = "學火車，換糖果",
        ["Incriminating Documents"] = "控罪文件",
        ["Indispensable Tools"] = "必需的工具",
        ["Indurium"] = "精鐵碎片",
        ["Indurium Ore"] = "精鐵礦石",
        ["Ineptitude + Chemicals = Fun"] = "失職+藥劑=快樂",
        ["Inert Scourgestones"] = "惰性天災石",
        ["Infallible Mind"] = "清晰的思想",
        ["Infiltrating Dragonmaw Fortress"] = "滲入龍喉堡壘",
        ["Infiltrating the Castle"] = "潛入城堡",
        ["Infiltration"] = "秘密潛入",
        ["Inform Leoroxx!"] = "通知李歐羅克斯!",
        ["Information Gathering"] = "收集資訊",
        ["Ink Supplies"] = "墨水補給",
        ["Inoculation"] = "預防注射",
        ["Inquire at the Inn"] = "調查旅店",
        ["Insane Druids"] = "瘋狂的德魯伊",
        ["Insect Part Analysis"] = "昆蟲研究",
        ["Intercepting the Message"] = "攔截訊息",
        ["Into Occupied Territory"] = "進入被佔據的土地",
        ["Into The Maw of Madness"] = "深入瘋狂之口",
        ["Into The Scarlet Monastery"] = "深入血色修道院",
        ["Into The Temple of Atal'Hakkar"] = "進入阿塔哈卡神廟",
        ["Into the Breach"] = "進入裂縫中",
        ["Into the Churning Gulch"] = "進入翻騰峽谷",
        ["Into the Depths"] = "深入神廟",
        ["Into the Draenethyst Mine"] = "進入德萊尼礦坑",
        ["Into the Dream"] = "進入夢境",
        ["Into the Field"] = "進入沙漠",
        ["Into the Heart of the Labyrinth"] = "進入迷宮的中心",
        ["Invaders of Alterac Valley"] = "奧特蘭克的入侵者",
        ["Invaluable Asset Zapping"] = "傳送無價的資產",
        ["Invasion Point: Annihilator"] = "侵略點:殲滅者",
        ["Invasion Point: Cataclysm"] = "侵略點:災難",
        ["Investigate An'daroth"] = "調查安都拉斯",
        ["Investigate Echo Ridge"] = "回音山調查行動",
        ["Investigate Tuurem"] = "調查杜瑞",
        ["Investigate the Alchemist Shop"] = "調查煉金店",
        ["Investigate the Amani Catacombs"] = "調查阿曼尼地下墓穴",
        ["Investigate the Blue Recluse"] = "調查藍色隱士",
        ["Investigate the Camp"] = "調查營地",
        ["Investigate the Crash"] = "調查這場空難",
        ["Iron Coral"] = "鐵珊瑚",
        ["Ironband Wants You!"] = "鐵環挖掘場需要你!",
        ["Ironband's Compound"] = "鐵環營地",
        ["Ironband's Excavation"] = "鐵環挖掘場",
        ["Irondeep Supplies"] = "深鐵礦坑的補給",
        ["Irradiated Crystal Shards"] = "受到輻射的水晶裂片",
        ["Isha Awak"] = "依沙瓦克",
        ["Ishamuhale"] = "伊沙姆哈爾",
        ["Ishanah"] = "伊莎納",
        ["Ishanah's Help"] = "伊莎納的幫助",
        ["It's Dangerous to Go Alone"] = "結伴而行",
        ["It's Just That Easy?"] = "就這麼簡單嗎?",
        ["It's Watching You!"] = "它在看著你!",
        ["It's a Secret to Everybody"] = "無人知曉的秘密",
        ["It's a Trap!"] = "它是一個陷阱!",
        ["Items of Power"] = "強大的物品",
        ["Items of Some Consequence"] = "必備物品",
        ["Ivar the Foul"] = "邪惡的伊瓦",
        ["Iverron's Antidote"] = "埃沃隆的解藥",
        ["Ivus the Forest Lord"] = "『森林之王』伊弗斯",
        ["JOB OPPORTUNITY: Culling the Competition"] = "工作機會:肅清競爭對手",
        ["Jail Break!"] = "衝破牢籠!",
        ["James Hyal"] = "詹姆士·海爾",
        ["Jammal'an the Prophet"] = "『預言者』迦瑪蘭",
        ["Jarl Needs Eyes"] = "加爾需要蜘蛛眼",
        ["Jarl Needs a Blade"] = "加爾需要一把劍",
        ["Je'neu of the Earthen Ring"] = "陶土議會的耶努薩克雷",
        ["Jes'rimon's Payment to Jediga"] = "傑斯雷蒙的報酬",
        ["Jin'Zil's Forest Magic"] = "金吉爾的森林魔法",
        ["Jitters' Growling Gut"] = "饑腸轆轆的基特斯",
        ["Job Opening: Guard Captain of Revantusk Village"] = "職位空缺:惡齒村衛兵隊長",
        ["Jol"] = "喬歐",
        ["Jonespyre's Request"] = "奎恩提斯的請求",
        ["Jorn Skyseer"] = "喬恩·星眼",
        ["Journey into Thunder Bluff"] = "雷霆崖之旅",
        ["Journey to Astranaar"] = "通往阿斯特蘭納的旅途",
        ["Journey to Hillsbrad Foothills"] = "前往希爾斯布萊德丘陵",
        ["Journey to Honor Hold"] = "榮譽堡之行",
        ["Journey to Stonetalon Peak"] = "石爪峰之旅",
        ["Journey to Tarren Mill"] = "塔倫米爾之旅",
        ["Journey to Thrallmar"] = "前往索爾瑪",
        ["Journey to Undercity"] = "幽暗城之旅",
        ["Journey to the Crossroads"] = "十字路口之旅",
        ["Journey to the Marsh"] = "沼澤之旅",
        ["Joys of Omosh"] = "沃姆什的喜悅",
        ["Ju-Ju Heaps"] = "魂能骨堆",
        ["Judgment and Redemption"] = "審判和救贖",
        ["Juice Delivery"] = "殭屍汁",
        ["Jungle Secrets"] = "叢林中的秘密",
        ["Junkboxes Needed"] = "垃圾箱",
        ["Just Compensation"] = "公平的補償",
        ["Jyoba's Report"] = "傑巴的報告",
        ["KILL ON SIGHT: Dark Iron Dwarves"] = "格殺勿論:黑鐵矮人",
        ["KILL ON SIGHT: High Ranking Dark Iron Officials"] = "格殺勿論:高階黑鐵軍官",
        ["Kaela's Update"] = "向凱拉回報",
        ["Kamsis"] = "坎希斯",
        ["Karabor Training Grounds"] = "卡拉伯爾訓練場",
        ["Karynaku"] = "凱瑞納古",
        ["Kaya's Alive"] = "卡雅還活著",
        ["Kayneth Stillwind"] = "凱尼斯·靜風",
        ["Keanna's Log"] = "琪安娜的日誌",
        ["Keep An Eye Out"] = "海盜的眼睛",
        ["Keep Thornfang Hill Clear!"] = "清光棘牙丘陵!",
        ["Keeper of the Flame"] = "火炬的守護者",
        ["Keeping Pace"] = "跟上節奏",
        ["Keeping Up Appearances"] = "持續觀察",
        ["Ken'zigla's Draught"] = "肯茲格拉的傷藥",
        ["Khadgar"] = "卡德加",
        ["Khan Dez'hepah"] = "戴茲帕可汗",
        ["Khan Hratha"] = "赫蘭薩可汗",
        ["Khan Jehn"] = "傑恩可汗",
        ["Khan Shaka"] = "沙卡可汗",
        ["Kharan Mighthammer"] = "卡蘭·巨錘",
        ["Kharan's Tale"] = "卡蘭的故事",
        ["Kibler's Exotic Pets"] = "基布雷爾的特殊寵物",
        ["Kick Them While They're Down"] = "趁他人之危",
        ["Kidnapped Elder Torntusk!"] = "被綁架的斷齒長者!",
        ["Kill Grundig Darkcloud"] = "殺死格魯迪格·暗雲",
        ["Kill the Shadow Council!"] = "殺光暗影議會!",
        ["Killing the Crawlers"] = "殺光爬行者",
        ["Kim'jael Indeed!"] = "我就是基姆加爾!",
        ["Kim'jael's \"Missing\" Equipment"] = "基姆加爾「丟失」的裝備",
        ["Kindness"] = "好心",
        ["King of the Foulweald"] = "汙林熊怪之王",
        ["Kingly Shakedown"] = "國王的搜查",
        ["Kirith"] = "基利斯",
        ["Kirtonos the Herald"] = "傳令官基爾圖諾斯",
        ["Kitchen Assistance"] = "廚房助手",
        ["Klaven's Tower"] = "克拉文之塔",
        ["Klockmort Spannerspan"] = "科羅莫特·鋼尺",
        ["Klockmort's Creation"] = "科羅莫特的成果",
        ["Klockmort's Essentials"] = "幫助科勞莫特",
        ["Know Thine Enemy"] = "了解你的敵人",
        ["Know your Enemy"] = "認識你的敵人",
        ["Knowledge in the Deeps"] = "深淵中的知識",
        ["Knowledge of the Orb of Orahil"] = "奧拉赫寶珠的知識",
        ["Kobold Camp Cleanup"] = "剿滅狗頭人營地",
        ["Kobold Candles"] = "狗頭人的蠟燭",
        ["Kodo Hide Bag"] = "科多獸皮包",
        ["Kodo Roundup"] = "誘捕科多獸",
        ["Kolkar Leaders"] = "科卡爾首領",
        ["Krastinov's Bag of Horrors"] = "卡斯迪諾夫的恐懼之袋",
        ["Krasus's Compendium"] = "卡薩斯的手冊",
        ["Krazek's Cookery"] = "克拉茲克的烹調鍋",
        ["Kris of Unspoken Names"] = "禁斷邪語短劍",
        ["Krom'Grul"] = "克羅格盧爾",
        ["Kroshius' Infernal Core"] = "克羅蘇斯的惡魔之核",
        ["Kum'isha's Endeavors"] = "庫米沙的努力",
        ["Kurzen's Mystery"] = "庫爾森的秘密",
        ["Lack of Surplus"] = "缺乏補給",
        ["Lakota'mani"] = "拉克塔曼尼",
        ["Land Ho!"] = "法迪爾海灣",
        ["Lard Lost His Lunch"] = "拉爾德的午餐",
        ["Larion and Muigin"] = "拉里安和莫爾金",
        ["Laughing Sisters"] = "歡笑的姐妹",
        ["Laying Waste to the Unwanted"] = "將剩餘的變不需要的",
        ["Lazy Peons"] = "懶惰的苦工",
        ["Leader of the Bloodscale"] = "血鱗領導者",
        ["Leader of the Darkcrest"] = "暗羽領導者",
        ["Leaders of the Fang"] = "尖牙德魯伊",
        ["Learning from the Crystals"] = "水晶的學問",
        ["Learning the Language"] = "學習語言",
        ["Ledger from Tanaris"] = "塔納利斯的帳本",
        ["Legends of Maraudon"] = "瑪拉頓的傳說",
        ["Leonid Barthalomew"] = "萊尼德·巴薩羅梅",
        ["Lethtendris's Web"] = "蕾瑟塔蒂絲的網",
        ["Letter to Jin'Zil"] = "寫給金吉爾的信",
        ["Letter to Stormpike"] = "鐵爐堡的解碼者",
        ["Levixus the Soul Caller"] = "靈魂呼喚者勒威薩斯",
        ["Libram of Constitution"] = "體質聖契",
        ["Libram of Focus"] = "專注聖典",
        ["Libram of Protection"] = "防護聖典",
        ["Libram of Rapidity"] = "疾速聖典",
        ["Libram of Resilience"] = "韌性聖契",
        ["Libram of Rumination"] = "沉思聖契",
        ["Libram of Tenacity"] = "堅毅聖契",
        ["Libram of Voracity"] = "貪婪聖契",
        ["Lieutenant Paval Reethe"] = "帕瓦爾·雷瑟上尉",
        ["Life's Finer Pleasures"] = "生命中更棒的樂趣",
        ["Lifting the Curse"] = "解除詛咒",
        ["Limits of Physical Exhaustion"] = "體能極限",
        ["Lines of Communication"] = "聯絡中心",
        ["Linken's Adventure"] = "林克的冒險",
        ["Linken's Memory"] = "林克的記憶",
        ["Linken's Sword"] = "林克的劍",
        ["Liquid Stone"] = "盧希恩的藥水",
        ["Little Embers"] = "一些餘燼",
        ["Little Morsels"] = "一點食物",
        ["Load Lightening"] = "減輕負重",
        ["Lonebrow's Journal"] = "亨里格的日記",
        ["Long Forgotten Memories"] = "久遠的記憶",
        ["Longtail is the Lynchpin"] = "長尾是關鍵",
        ["Look To The Stars"] = "觀測星星",
        ["Look to an Old Friend"] = "老朋友",
        ["Looking Further"] = "監視",
        ["Looking to the Leadership"] = "與領導者同在",
        ["Loramus"] = "洛拉姆斯",
        ["Lord Aliden Perenolde"] = "奧里登·匹瑞諾德領主",
        ["Lord Banehollow"] = "貝恩霍勒領主",
        ["Lord Maxwell Tyrosus"] = "麥克斯韋爾·泰羅索斯領主",
        ["Lords of the Council"] = "議會領主",
        ["Lore for a Price"] = "昂貴的知識",
        ["Losing Gracefully"] = "優雅的失敗",
        ["Lost Armaments"] = "丟失的裝備",
        ["Lost But Not Forgotten"] = "丟失的孩子",
        ["Lost Deathstalkers"] = "失蹤的亡靈哨兵",
        ["Lost Necklace"] = "遺失的項鍊",
        ["Lost Thunderbrew Recipe"] = "遺失的雷酒秘方",
        ["Lost in Action"] = "無法行動",
        ["Lost in Battle"] = "在戰鬥中失蹤",
        ["Lost!"] = "幫迷失者找到方向",
        ["Love Song for Narain"] = "給納里安的情歌",
        ["Love's Gift"] = "愛的禮物",
        ["Luck Be With You"] = "祝你好運",
        ["Mac'Aree Mushroom Menagerie"] = "麥克艾瑞野生蘑菇",
        ["MacKreel's Moonshine"] = "馬克里爾的月光酒",
        ["Mace of Unending Life"] = "不滅生命之錘",
        ["Maelstrom's Wrath"] = "漩渦之怒",
        ["Magatha's Payment to Jediga"] = "瑪加薩的報酬",
        ["Mage Summoner"] = "法師召喚者",
        ["Mage Training"] = "法師訓練",
        ["Mage's Wand"] = "法師的魔杖",
        ["Mage-tastic Gizmonitor"] = "法師文檔記憶體",
        ["Magecraft"] = "法師公會",
        ["Magic Dust"] = "魔法粉末",
        ["Magic of the Arakkoa"] = "阿拉卡的魔法",
        ["Magical Analysis"] = "魔法分析",
        ["Magical Disturbances"] = "魔法干擾",
        ["Magram Alliance"] = "瑪格拉姆族的聯盟",
        ["Mahren Skyseer"] = "瑪倫·星眼",
        ["Mai'Zoth"] = "麥佐斯",
        ["Major Malfunction"] = "嚴重失靈",
        ["Make Them Listen"] = "讓他們聽話",
        ["Making Amends"] = "重修舊好",
        ["Making Sense of It"] = "分析水晶塔",
        ["Maktu's Revenge"] = "瑪克吐的復仇",
        ["Makuru's Vengeance"] = "瑪酷魯的復仇",
        ["Malaise"] = "莫名的不安",
        ["Malevolent Remnants"] = "惡意的倖存者",
        ["Malfunction at the West Sanctum"] = "西部聖殿的故障",
        ["Malin's Request"] = "馬林的要求",
        ["Mana Surges"] = "法力怒靈",
        ["Manaforge B'naar"] = "法力熔鐵爐巴納爾",
        ["Manaweave Robe"] = "魔紋長袍",
        ["Manhunt"] = "獵殺收貨人",
        ["Mantle of the Oracle"] = "神諭者的披肩",
        ["Mantles of the Dawn"] = "黎明披肩",
        ["Maps and Runes"] = "地圖與符記",
        ["Marauders of Darrowshire"] = "達隆郡的掠奪者",
        ["Marauding Crust Bursters"] = "潛行的地殼穿刺者",
        ["Marauding Wolves"] = "巡邏的狼群",
        ["Marg Speaks"] = "瑪格的囑託",
        ["Margoz"] = "瑪高茲",
        ["Mark V is Alive!"] = "充滿動力的馬克斯五號",
        ["Marking the Path"] = "記下路徑",
        ["Marks of Kil'jaeden"] = "基爾加丹印記",
        ["Marks of Sargeras"] = "薩格拉斯印記",
        ["Marla's Last Wish"] = "瑪拉的遺願",
        ["Marshal Haggard"] = "治安官哈迦德",
        ["Marshal Windsor"] = "溫德索爾元帥",
        ["Martek the Exiled"] = "『流放者』馬特克",
        ["Marvon's Workshop"] = "瑪爾馮的車間",
        ["Massacre at Gruul's Lair"] = "戈魯爾之巢大屠殺",
        ["Master Angler"] = "釣魚大師",
        ["Master of the Wild Leather"] = "蠻皮護甲大師",
        ["Mastering the Elements"] = "控制元素",
        ["Material Assistance"] = "收集材料",
        ["Material Components"] = "材料成分",
        ["Mathias and the Defias"] = "馬迪亞斯和迪菲亞盜賊",
        ["Mathiel"] = "瑪希爾",
        ["Mathiel's Armor"] = "瑪希爾的鎧甲",
        ["Mathystra Relics"] = "瑪塞斯特拉聖物",
        ["Matis the Cruel"] = "殘忍的馬帝斯",
        ["Matters of Security"] = "防禦之事",
        ["Maxnar Must Die!"] = "麥克斯納爾必須要死!",
        ["Maxwell's Mission"] = "麥克斯韋爾的任務",
        ["Mayara Brightwing"] = "瑪亞拉·布萊特文",
        ["Mazen's Behest"] = "馬森的請求",
        ["Mazzranache"] = "馬茲拉納其",
        ["Measuring Warp Energies"] = "測量扭曲能量",
        ["Meats to Orgrimmar"] = "送往奧格瑪的肉",
        ["Mechanical Repair Kits"] = "機械修理包",
        ["Medallion of Station"] = "身份勳章",
        ["Medicinal Purpose"] = "醫療用途",
        ["Medivh's Journal"] = "麥迪文的日記",
        ["Meet at the Grave"] = "墓地相見",
        ["Meeting at the Blackwing Coven"] = "黑翼集會所的集會",
        ["Meeting with the Master"] = "見到主人",
        ["Melding of Influences"] = "融合軟泥怪",
        ["Melor Sends Word"] = "梅洛的關注",
        ["Menacing Marshfangs"] = "險惡的沼牙",
        ["Mending Old Wounds"] = "修復舊創",
        ["Menethil's Gift"] = "米奈希爾的禮物",
        ["Mennet Carkad"] = "米奈特·卡加德",
        ["Mercenaries"] = "雇傭兵",
        ["Mercy for the Cursed"] = "憐憫被詛咒者",
        ["Message in a Bottle"] = "瓶中信",
        ["Message to Freewind Post"] = "給亂風崗的緊急信件",
        ["Message to Garadar"] = "給卡拉達爾的訊息",
        ["Message to Maxwell"] = "給麥斯威爾的訊息",
        ["Message to Telaar"] = "給泰拉的訊息",
        ["Message to the Daggerfen"] = "給匕首沼地的訊息",
        ["Message to the Wildhammer"] = "給蠻錘部族的警告",
        ["Messenger to Darkshire"] = "送信到夜色鎮",
        ["Messenger to Stormwind"] = "送往暴風城的信",
        ["Messenger to Thrall"] = "給索爾的消息",
        ["Messenger to Westfall"] = "送往西部荒野的信",
        ["Messenger to the Feralfen"] = "菲拉芬的信差",
        ["Metzen the Reindeer"] = "麋鹿梅特森",
        ["Michael Garrett"] = "邁克爾·加勒特",
        ["Milly Osworth"] = "米莉·奧斯沃斯",
        ["Milly's Harvest"] = "米莉的葡萄",
        ["Miner's Fortune"] = "礦工的寶貝",
        ["Minions of the Shadow Council"] = "暗影議會的爪牙",
        ["Minshina's Skull"] = "明希納的顱骨",
        ["Mirages"] = "饑腸轆轆",
        ["Mirror Lake"] = "明鏡湖",
        ["Missing Crystals"] = "遺失的水晶",
        ["Missing Friends"] = "失蹤的朋友",
        ["Missing In Action"] = "失蹤人員",
        ["Missing Mag'hari Procession"] = "失蹤的瑪格哈利隊伍",
        ["Missing Missive"] = "丟失的公文",
        ["Missing in the Ghostlands"] = "鬼魂之地的失蹤者",
        ["Mission: Gateways Murketh and Shaadraz"] = "任務:墨奇斯以及夏德拉茲入口",
        ["Mission: Possible But Not Probable"] = "基本不可能的任務",
        ["Mission: The Abyssal Shelf"] = "任務:深淵沙洲",
        ["Mission: The Murketh and Shaadraz Gateways"] = "任務:墨奇斯和夏德拉茲入口",
        ["Mist"] = "密斯特",
        ["Mo'mor the Breaker"] = "『破壞者』哞哞爾",
        ["Mok'Nathal Treats"] = "摩克納薩爾的款待",
        ["Mok'thardin's Enchantment"] = "摩克薩爾丁的魔法",
        ["Mold Rhymes With..."] = "昂貴的模具",
        ["Moonglow Vest"] = "月光外衣",
        ["Moontouched Wildkin"] = "月光羽毛",
        ["Mor'Ladim"] = "摩拉迪姆",
        ["Mor'zul Bloodbringer"] = "莫蘇爾·召血者",
        ["Morbent Fel"] = "摩本特·費爾",
        ["More Arakkoa Feathers"] = "更多的阿拉卡羽毛",
        ["More Armor Kits"] = "更多的護甲片",
        ["More Bat Eyes"] = "更多蝙蝠眼",
        ["More Booty!"] = "取之於敵",
        ["More Components of Importance"] = "更多重要的材料",
        ["More Crystal Fragments"] = "更多水晶碎片",
        ["More Dense Grinding Stones"] = "更多的緻密砂輪",
        ["More Feathers"] = "更多的羽毛",
        ["More Fertile Spores"] = "更多仙人掌孢子",
        ["More Firewing Signets"] = "更多的火翼徽章",
        ["More Glowcaps"] = "更多白閃菇",
        ["More Glowing Scorpid Blood"] = "更多閃光的蠍血",
        ["More Heads Full of Ivory"] = "更多象長牙",
        ["More Irradiated Crystal Shards"] = "更多受到輻射的水晶裂片",
        ["More Marks of Kil'jaeden"] = "更多的基爾加丹印記",
        ["More Marks of Sargeras"] = "更多的薩格拉斯印記",
        ["More Obsidian Warbeads"] = "更多黑曜石戰爭串珠",
        ["More Power!"] = "更多的能源!",
        ["More Rotting Hearts"] = "更多的腐爛之心",
        ["More Spore Sacs"] = "更多孢子囊",
        ["More Tendrils!"] = "更多藤鬚!",
        ["More Thorium Widgets"] = "更多的瑟銀零件",
        ["More Venom Sacs"] = "更多毒囊",
        ["More Warbeads"] = "更多的戰爭串珠",
        ["More Warbeads!"] = "更多的戰爭串珠",
        ["More Wastewander Justice"] = "廢土的公正",
        ["More than a Pound of Flesh"] = "一磅多的肉",
        ["Morgan Ladimore"] = "摩根·拉迪莫爾",
        ["Morgan Stern"] = "摩根·斯特恩",
        ["Morganth"] = "莫甘斯",
        ["Morrowgrain Research"] = "晨光麥研究",
        ["Morrowgrain to Darnassus"] = "達納蘇斯的晨光麥",
        ["Morrowgrain to Feathermoon Stronghold"] = "羽月要塞的晨光麥",
        ["Morrowgrain to Thunder Bluff"] = "雷霆崖的晨光麥",
        ["Mortality Wanes"] = "臨終遺言",
        ["Mother's Milk"] = "蛛后的乳汁",
        ["Mountain Giant Muisek"] = "山嶺巨人靈魂精華",
        ["Mountaineer Stormpike's Task"] = "巡山人雷矛的任務",
        ["Muck Diving"] = "摧毀菌體",
        ["Mudrock Soup and Bugs"] = "泥石龜蟹湯",
        ["Muigin and Larion"] = "莫爾金和拉里安",
        ["Mura Runetotem"] = "茉拉·符文圖騰",
        ["Murdaloc"] = "莫達洛克",
        ["Muren Stormpike"] = "穆倫·雷矛",
        ["Murkblood Corrupters"] = "黑暗之血腐敗者",
        ["Murkblood Invaders"] = "黑暗之血入侵者",
        ["Murkblood Leaders..."] = "黑暗之血領導者……",
        ["Murloc Poachers"] = "魚人偷獵者",
        ["Murlocs... Why Here? Why Now?"] = "魚人……為何此時?為何此地?",
        ["Mystery Goo"] = "神秘的粘液",
        ["Mystery Mask"] = "神秘面罩",
        ["Mythology of the Titans"] = "泰坦神話",
        ["Myzrael's Allies"] = "密斯賴爾的盟友",
        ["Naaru Technology"] = "那魯的技術",
        ["Naga at the Zoram Strand"] = "佐拉姆海岸的納迦",
        ["Naladu"] = "納拉杜",
        ["Nara Wildmane"] = "納拉·蠻鬃",
        ["Nat's Measuring Tape"] = "納特的捲尺",
        ["Natural Armor"] = "自然護甲",
        ["Natural Enemies"] = "自然天敵",
        ["Natural Materials"] = "天然材料",
        ["Natural Remedies"] = "自然治療法",
        ["Necklace Recovery"] = "搜尋項鍊",
        ["Need for a Cure"] = "救命如救火",
        ["Needs More Cowbell"] = "需要更多的鈴鐺",
        ["Neeka Bloodscar"] = "尼卡·血痕",
        ["Neeru Fireblade"] = "尼爾魯·火刃",
        ["Nefarius's Corruption"] = "奈法利斯的腐敗",
        ["Nek'rosh's Gambit"] = "納克羅什的優勢",
        ["Nekrum's Medallion"] = "耐克魯姆的徽章",
        ["Nessa Shadowsong"] = "尼莎·影歌",
        ["Nether Gas In a Fel Fire Engine"] = "虛空火焰引擎裡的虛空氣體",
        ["Nether-lace Garment"] = "虛靈長袍",
        ["Neutralizing the Nethermancers"] = "消滅虛空術師",
        ["Never Again!"] = "永遠沒有下一次!",
        ["Never Ask Me About My Business"] = "不要過問我的工作",
        ["New Life"] = "新的生命",
        ["New Opportunities"] = "新的機會",
        ["New Year Celebrations!"] = "新年慶典!",
        ["Newfound Allies"] = "新找到的盟友",
        ["News for Fizzle"] = "回覆菲茲爾",
        ["News for Rakoria"] = "給瑞克利亞的消息",
        ["News from Zangarmarsh"] = "贊格沼澤的消息",
        ["News of Dogran"] = "多格蘭的消息",
        ["News of Victory"] = "勝利的消息",
        ["Nexus-King Salhadaar"] = "奈薩斯王薩哈達爾",
        ["Night Web's Hollow"] = "夜行蜘蛛洞穴",
        ["No More Mushrooms!"] = "不要再給我蘑菇了!",
        ["No Time for Curiosity"] = "沒時間好奇了",
        ["Noble Deaths"] = "貴族之死",
        ["Noboru the Cudgel"] = "『鬥棍』諾博魯",
        ["Nogg's Ring Redo"] = "諾格的手藝",
        ["Noggenfogger Elixir"] = "諾格弗格藥劑",
        ["Noggle's Last Hope"] = "諾格的最後一線希望",
        ["Noggle's Lost Satchel"] = "諾格的背包",
        ["Nolkai's Words"] = "諾凱的話",
        ["Northfold Manor"] = "諾斯弗德農場",
        ["Not On My Watch!"] = "在我的看守下門都沒有!",
        ["Note to William"] = "給威廉·匹斯特的信",
        ["Note to the Mayor"] = "給鎮長的字條",
        ["Nothin' Says Lovin' Like a Big Stinger"] = "讓大刺針示愛",
        ["Nothing But The Truth"] = "真言藥水",
        ["Now That We're Friends..."] = "既然我們是朋友……",
        ["Now That We're Still Friends..."] = "既然我們還是朋友……",
        ["Noxious Lair Investigation"] = "腐化之巢",
        ["Nugget Slugs"] = "高強度齒輪",
        ["Oakenscowl"] = "奧肯斯古爾",
        ["Observing the Sporelings"] = "觀察孢子人",
        ["Obsidian Warbeads"] = "黑曜石戰爭串珠",
        ["Oculus Illusions"] = "黑龍幻影",
        ["Of Coursers We Know"] = "打獵者",
        ["Of Forgotten Memories"] = "遺忘的記憶",
        ["Of Lost Honor"] = "失落的榮耀",
        ["Of Love and Family"] = "愛與家庭",
        ["Of Thistleheads and Eggs..."] = "血薊與蛋",
        ["Off To Area 52"] = "前往52區",
        ["Ogre Head On A Stick = Party"] = "梟首示眾",
        ["Ogre Thieves"] = "巨魔盜賊",
        ["Oh Brother. . ."] = "我的兄弟……",
        ["Old Hillsbrad"] = "舊時的希爾斯布萊德",
        ["Old Whitebark's Pendant"] = "老白樹墜飾",
        ["Olemba Seed Oil"] = "奧萊姆貝種子油",
        ["Olemba Seeds"] = "奧萊姆貝種子",
        ["Omarion's Handbook"] = "歐瑪利安之手冊",
        ["On Guard in Stonetalon"] = "守衛石爪山",
        ["On Iron Pauldrons"] = "鐵肩鎧",
        ["On Nethery Wings"] = "乘著虛空之翼",
        ["On Spirit's Wings"] = "精靈的翅膀上",
        ["On the Wings of a Hippogryph"] = "飛快的角鷹獸",
        ["Once Were Warriors"] = "一朝為戰士",
        ["One Demon's Trash..."] = "惡魔的垃圾……",
        ["One Draenei's Junk..."] = "德萊尼的垃圾…",
        ["One Shot. One Kill."] = "一擊必殺",
        ["Ongeku"] = "盎格庫",
        ["Onin's Report"] = "奧寧的報告",
        ["Only One May Rise"] = "唯一的領袖",
        ["Onu"] = "安努",
        ["Onu is meditating"] = "正在冥想的安努",
        ["Onward to Ashenvale"] = "前進梣谷",
        ["Operation Recombobulation"] = "自動淨化裝置",
        ["Operation: Death to Angerforge"] = "行動:殺死安格弗將軍",
        ["Operative Bijou"] = "狡猾的比修",
        ["Oran's Gratitude"] = "奧蘭的感謝",
        ["Ordanus"] = "奧達努斯",
        ["Order Must Be Restored"] = "重鑄秩序",
        ["Orders from Lady Vashj"] = "瓦許女士的命令",
        ["Orendil's Cure"] = "奧雷迪爾的藥劑",
        ["Orm Stonehoof and the Brutal Helm"] = "歐姆·石蹄和野蠻頭盔",
        ["Ormer's Revenge"] = "奧莫爾的復仇",
        ["Oronok Torn-heart"] = "歐朗諾克·碎心",
        ["Oronu the Elder"] = "長者奧朗奴",
        ["Ortor My Old Friend..."] = "我的老友奧拓爾……",
        ["Oshu'gun Crystal Powder"] = "歐夏剛水晶粉末",
        ["Other Fish to Fry"] = "另一種魚",
        ["Outland Sucks!"] = "令人討厭的外域!",
        ["Outrider Advanced Care Package"] = "斥候高級護理包",
        ["Outrider Basic Care Package"] = "斥候基礎護理包",
        ["Outrider Standard Care Package"] = "斥候標準護理包",
        ["Outside Assistance"] = "外來的協助",
        ["Overlord"] = "霸主",
        ["Overlord Gorefist"] = "血拳主宰",
        ["Overlord Mok'Morokk's Concern"] = "莫格穆洛克主宰的任務",
        ["Overmaster Pyron"] = "征服者派隆",
        ["Owatanka"] = "奧瓦坦卡",
        ["Pacify the Centaur"] = "清除半人馬",
        ["Package Recovery"] = "重獲包裹",
        ["Package for Thurman"] = "薩爾曼的針線包",
        ["Paladin Training"] = "聖騎士訓練",
        ["Pamela's Doll"] = "帕米拉的洋娃娃",
        ["Panther Mastery"] = "獵豹大師",
        ["Paragons of Power: The Augur's Belt"] = "權力珍寶:占兆師腰帶",
        ["Paragons of Power: The Augur's Bracers"] = "權力珍寶:占兆師護腕",
        ["Paragons of Power: The Augur's Hauberk"] = "權力珍寶:占兆師鍊衫",
        ["Paragons of Power: The Confessor's Bindings"] = "權力珍寶:懺悔者束腕",
        ["Paragons of Power: The Confessor's Mantle"] = "權力珍寶:懺悔者披肩",
        ["Paragons of Power: The Confessor's Wraps"] = "權力珍寶:懺悔者裹帶",
        ["Paragons of Power: The Demoniac's Mantle"] = "權力珍寶:惡魔師披肩",
        ["Paragons of Power: The Demoniac's Robes"] = "權力珍寶:惡魔師長袍",
        ["Paragons of Power: The Demoniac's Wraps"] = "權力珍寶:惡魔師裹帶",
        ["Paragons of Power: The Freethinker's Armguards"] = "權力珍寶:思考者護臂",
        ["Paragons of Power: The Freethinker's Belt"] = "權力珍寶:思考者腰帶",
        ["Paragons of Power: The Freethinker's Breastplate"] = "權力珍寶:思考者胸甲",
        ["Paragons of Power: The Haruspex's Belt"] = "權力珍寶:占卜師腰帶",
        ["Paragons of Power: The Haruspex's Bracers"] = "權力珍寶:占卜師護腕",
        ["Paragons of Power: The Haruspex's Tunic"] = "權力珍寶:占卜師外套",
        ["Paragons of Power: The Illusionist's Mantle"] = "權力珍寶:幻術師披肩",
        ["Paragons of Power: The Illusionist's Robes"] = "權力珍寶:幻術師長袍",
        ["Paragons of Power: The Illusionist's Wraps"] = "權力珍寶:幻術師裹帶",
        ["Paragons of Power: The Madcap's Bracers"] = "權力珍寶:狂妄者護腕",
        ["Paragons of Power: The Madcap's Mantle"] = "權力珍寶:狂妄者披肩",
        ["Paragons of Power: The Madcap's Tunic"] = "權力珍寶:狂妄者外套",
        ["Paragons of Power: The Predator's Belt"] = "權力珍寶:捕獵者腰帶",
        ["Paragons of Power: The Predator's Bracers"] = "權力珍寶:捕獵者護腕",
        ["Paragons of Power: The Predator's Mantle"] = "權力珍寶:捕獵者披肩",
        ["Paragons of Power: The Vindicator's Armguards"] = "權力珍寶:辯護者護臂",
        ["Paragons of Power: The Vindicator's Belt"] = "權力珍寶:辯護者腰帶",
        ["Paragons of Power: The Vindicator's Breastplate"] = "權力珍寶:辯護者胸甲",
        ["Parts for Kravel"] = "給克拉維爾的零件",
        ["Parts of the Swarm"] = "蟲群的樣本",
        ["Passage to Booty Bay"] = "藏寶海灣的航道",
        ["Passing Word of a Threat"] = "亡者的警告",
        ["Passing the Burden"] = "委以重任",
        ["Past Endeavors"] = "過往的努力",
        ["Path of Defense"] = "防禦之道",
        ["Path of the Violet Protector"] = "紫羅蘭保衛者之路",
        ["Path of the Violet Restorer"] = "紫羅蘭治療師之路",
        ["Patriarch Ironjaw"] = "鐵顎元老",
        ["Patrol Schedules"] = "巡邏時間表",
        ["Patrolling Westfall"] = "西部荒野的巡邏",
        ["Pawn Captures Queen"] = "小兵捉蠍后",
        ["Pay the Baron a Visit"] = "拜訪男爵",
        ["Pearl Diving"] = "潛水采珍珠",
        ["Pelt Collection"] = "收集毛皮",
        ["Perfect Yeti Hide"] = "完美的雪人毛皮",
        ["Petty Squabbles"] = "爭論",
        ["Pick Your Part"] = "挑選你的職責",
        ["Picking Up Some Power Converters"] = "收集能量轉換器",
        ["Pie for Billy"] = "比利的餡餅",
        ["Piercing the Veil"] = "控制小鬼",
        ["Pilfered Equipment"] = "被偷走的裝備",
        ["Pirate Hats Ahoy!"] = "海盜的帽子!",
        ["Plagued Hatchlings"] = "瘟疫之龍",
        ["Plagueheart Belt"] = "瘟疫之心腰帶",
        ["Plagueheart Bindings"] = "瘟疫之心束腕",
        ["Plagueheart Leggings"] = "瘟疫之心護腿",
        ["Plainstrider Menace"] = "平原陸行鳥的威脅",
        ["Planting the Banner"] = "插上戰旗",
        ["Planting the Heart"] = "培養心臟",
        ["Plants of Zangarmarsh"] = "贊格沼澤的植物",
        ["Plea To The Alliance"] = "向聯盟求援",
        ["Plundering the Plunderers"] = "搶劫海盜",
        ["Poaching from Poachers"] = "行竊侵入者",
        ["Poison Water"] = "毒水",
        ["Poisoned Water"] = "被囚禁的水元素",
        ["Pool of Tears"] = "淚水之池",
        ["Poor Old Blanchy"] = "可憐的老布蘭契",
        ["Portals of the Legion"] = "燃燒軍團的傳送門",
        ["Portents of Uldum"] = "奧丹姆的線索",
        ["Potential Energy Source"] = "潛在的能量來源",
        ["Potential for Brain Damage = High"] = "大腦損傷的可能性＝高",
        ["Powder to Ironband"] = "鐵環的火藥粉",
        ["Power Stones"] = "能量石",
        ["Power in Uldaman"] = "奧達曼的能量源",
        ["Power over Poison"] = "解毒之術",
        ["Powering our Defenses"] = "增強我們的防禦",
        ["Practical Prey"] = "生活所需的虎皮",
        ["Prayer to Elune"] = "伊露恩祈禱文",
        ["Precarious Predicament"] = "押送囚徒",
        ["Precious and Fragile Things Need Special Handling"] = "小心輕放",
        ["Preparation for Ceremony"] = "準備典禮",
        ["Preparing for War"] = "準備作戰",
        ["Preparing the Salve"] = "準備藥膏",
        ["Presence of Might"] = "力量的證明",
        ["Presence of Sight"] = "魔法的視域",
        ["Preserving Knowledge"] = "保全書籍",
        ["Preying on the Predators"] = "捕食掠奪者",
        ["Pride of the Fel Horde"] = "地獄部落的驕傲",
        ["Pridewings of Stonetalon"] = "石爪山的雙足飛龍",
        ["Priest Training"] = "牧師訓練",
        ["Primal Magic"] = "原始魔法",
        ["Princess Must Die!"] = "公主必須死!",
        ["Prison Break In"] = "入室偷竊",
        ["Prisoner of the Bladespire"] = "劍刃囚犯",
        ["Pristine Enchanted South Seas Kelp"] = "原始南海魔化海藻",
        ["Pristine Spider Silk"] = "新鮮的蜘蛛絲",
        ["Pristine Yeti Hide"] = "原始雪人毛皮",
        ["Proof of Allegiance"] = "表明立場",
        ["Proof of Deed"] = "證明文件",
        ["Proof of Demise"] = "死亡證明",
        ["Proof of Life"] = "生命的證據",
        ["Prophetic Aura"] = "預言的光環",
        ["Prospect of Faith"] = "鐵趾的遺願",
        ["Prospector Balmoral"] = "勘察員波莫羅",
        ["Protect Kanati Greycloud"] = "保護卡納提·灰雲",
        ["Protect Kaya"] = "保護卡雅",
        ["Protect the Frontier"] = "保衛邊境",
        ["Protecting Our Own"] = "保護我們自己",
        ["Protecting the Herd"] = "保護牲畜",
        ["Protecting the Shipment"] = "護送貨物",
        ["Prove Your Hatred"] = "復仇的證明",
        ["Prove Your Worth"] = "證明你的價值",
        ["Proving Allegiance"] = "證明忠誠",
        ["Proving Grounds"] = "試煉場",
        ["Proving Your Strength"] = "證明你的力量",
        ["Proving Your Worth"] = "證明你的實力",
        ["Prowlers of the Barrens"] = "草原上的徘徊者",
        ["Psychometric Reading"] = "心靈占卜術",
        ["Purified!"] = "淨化!",
        ["Pursuing Terrorclaw"] = "抓到恐懼之爪",
        ["Pusillin and the Elder Azj'Tordin"] = "普希林和埃斯托爾迪",
        ["Put Her Down"] = "座狼之源",
        ["Put On Yer Kneepads..."] = "套上你的護膝……",
        ["Pyrewood Ambush"] = "焚木村中的伏擊",
        ["Quell The Uprising"] = "鎮壓暴動",
        ["Quenching the Blade"] = "冷卻刀刃",
        ["Questioning Reethe"] = "盤問雷瑟",
        ["Rabine Saturna"] = "拉比恩·薩圖納",
        ["Raene's Cleansing"] = "萊恩的淨化",
        ["Rage of Ages"] = "遠古之怒",
        ["Rage of Blood"] = "血之狂暴",
        ["Ragnar Thunderbrew"] = "拉格納·雷酒",
        ["Raid on the Kolkar"] = "突襲科卡爾",
        ["Raising Spirits"] = "振奮精神",
        ["Raleigh and the Undercity"] = "拉林夫與幽暗城",
        ["Ram Hide Harnesses"] = "羊皮座具",
        ["Ram Riding Harnesses"] = "山羊座具",
        ["Rampaging Giants"] = "狂暴的巨人",
        ["Rampaging Ravagers"] = "消滅劫毀者",
        ["Ramstein"] = "拉姆斯登",
        ["Ranger Sareyn"] = "遊俠塞瑞",
        ["Raptor Horns"] = "迅猛龍角",
        ["Raptor Mastery"] = "獵龍",
        ["Raptor Thieves"] = "迅猛龍小偷",
        ["Rare Fish - Brownell's Blue Striped Racer"] = "稀有魚類 - 布隆奈爾藍斑魚",
        ["Rare Fish - Dezian Queenfish"] = "稀有魚類 - 迪森皇后魚",
        ["Rare Fish - Keefer's Angelfish"] = "稀有魚類 - 基佛天使魚",
        ["Rat Catching"] = "逮捕狗頭人",
        ["Rather Be Fishin'"] = "當然是釣魚",
        ["Rattling the Rattlecages"] = "斷骨骷髏",
        ["Ravager Egg Roundup"] = "圍捕劫毀者",
        ["Raven Hill"] = "烏鴉嶺",
        ["Razorhide"] = "野豬之皮",
        ["Razormaw"] = "瑞索默",
        ["Razzeric's Tweaking"] = "拉澤瑞克的調整",
        ["Reagents for Reclaimers Inc."] = "尋物公司的委託",
        ["Rear Guard Patrol"] = "巡查後方",
        ["Reassignment"] = "人事調動",
        ["Recently Living"] = "適者生存",
        ["Reception from Tyrande"] = "泰蘭妲的接待",
        ["Recharging the Batteries"] = "補充電源",
        ["Recipe for Destruction"] = "破壞的訣竅",
        ["Recipe of the Kaldorei"] = "卡多雷的食譜",
        ["Reclaimed Treasures"] = "尋回寶物",
        ["Reclaimers' Business in Desolace"] = "尋物公司的業務",
        ["Reclaiming Felfire Hill"] = "奪回冥火嶺",
        ["Reclaiming Goods"] = "奪回雕像",
        ["Reclaiming Holy Grounds"] = "開拓神聖之地",
        ["Reclaiming Sunstrider Isle"] = "奪回逐日者之島",
        ["Reclaiming the Charred Vale"] = "奪回焦炭谷",
        ["Reclaiming the Eggs"] = "取回那些蛋",
        ["Reclaiming the Ruins"] = "奪回廢墟",
        ["Recover the Bones"] = "取回白骨",
        ["Recover the Key!"] = "找回鑰匙!",
        ["Red Leather Bandanas"] = "紅色皮質頭巾",
        ["Red Linen Goods"] = "紅色亞麻布",
        ["Red Silk Bandanas"] = "紅色絲質頭巾",
        ["Red Snapper - Very Tasty!"] = "紅鯛魚 - 非常美味!",
        ["Redeeming the Dead"] = "解救亡者",
        ["Redemption"] = "救贖",
        ["Redemption Boots"] = "救贖長靴",
        ["Redemption Girdle"] = "救贖束腰",
        ["Redemption Handguards"] = "救贖手甲",
        ["Redemption Headpiece"] = "救贖首盔",
        ["Redemption Tunic"] = "救贖外套",
        ["Redemption Wristguards"] = "救贖護腕",
        ["Redridge Goulash"] = "赤脊山燉肉",
        ["Redridge Rendezvous"] = "赤脊山的聯絡員",
        ["Refuel for the Zapping"] = "補充動力",
        ["Regthar Deathgate"] = "雷戈薩·死門",
        ["Reinforcements for Garadar"] = "卡拉達爾的援軍",
        ["Rejold's New Brew"] = "雷傑德的新酒",
        ["Release Them"] = "釋放他們",
        ["Rellian Greenspyre"] = "雷利亞·綠樹",
        ["Remorseful Highborne"] = "悔恨的高等精靈",
        ["Replacement Phial"] = "交換藥水",
        ["Replenishing the Healing Crystals"] = "補充治療水晶",
        ["Report Back to Fizzlebub"] = "向菲茲巴布報告",
        ["Report from the Northern Front"] = "北方前線的報告",
        ["Report to Anastasia"] = "向安娜斯塔西婭報告",
        ["Report to Captain Helios"] = "向希里歐斯隊長回報",
        ["Report to Captain Stoutfist"] = "向斯托菲隊長報告",
        ["Report to Doren"] = "向多倫報告",
        ["Report to Engineering"] = "回報工程師",
        ["Report to Exarch Admetius"] = "向主教阿德密特斯回報",
        ["Report to General Kirika"] = "向奇立卡將軍報告",
        ["Report to Goldshire"] = "去閃金鎮報到",
        ["Report to Gryan Stoutmantle"] = "向格里安·斯托曼報到",
        ["Report to Hadrec"] = "給哈德瑞克的報告",
        ["Report to Helgrum"] = "向赫格拉姆報到",
        ["Report to Ironforge"] = "向鐵爐堡報告",
        ["Report to Jennea"] = "向詹妮亞報告",
        ["Report to Lanthan Perilon"] = "向蘭深·佩瑞隆回報",
        ["Report to Magister Kaendris"] = "向博學者坎德立斯回報",
        ["Report to Marshal Bluewall"] = "向治安官藍牆報告",
        ["Report to Mountaineer Rockgar"] = "向巡山人羅克加報告",
        ["Report to Nazgrel"] = "向納茲格雷爾報告",
        ["Report to Orgnil"] = "向奧戈尼爾報告",
        ["Report to Sen'jin Village"] = "去森金村報到",
        ["Report to Shadow Hunter Denjai"] = "向暗影獵人丹傑回報",
        ["Report to Splintertree Post"] = "向碎木崗哨回報",
        ["Report to Stonebreaker Camp"] = "到碎石營地報到",
        ["Report to Tarren Mill"] = "向塔倫米爾報告",
        ["Report to Thomas"] = "回覆湯瑪斯",
        ["Report to Zor"] = "向佐爾報告",
        ["Report to Zurai"] = "報告祖瑞伊",
        ["Report to the Allerian Post"] = "到艾蘭里哨站報到",
        ["Request for Assistance"] = "要求幫助",
        ["Rescue Deirom!"] = "拯救迪羅姆!",
        ["Rescue Dugar!"] = "拯救杜葛爾!",
        ["Rescue From Jaedenar"] = "逃出加德納爾",
        ["Rescue OOX-09/HL!"] = "拯救OOX-09/HL!",
        ["Rescue OOX-17/TN!"] = "拯救OOX-17/TN!",
        ["Rescue OOX-22/FE!"] = "拯救OOX-22/FE!",
        ["Rescue the Survivors!"] = "德萊尼生還者",
        ["Research Notes"] = "研究報告",
        ["Researching the Corruption"] = "研究墮落",
        ["Rest and Relaxation"] = "休息和放鬆",
        ["Resting in Pieces"] = "支離破碎",
        ["Restless Activity"] = "不安的活動",
        ["Restoring Fiery Flux Supplies via Heavy Leather"] = "熾熱助熔劑的補給:重皮",
        ["Restoring Fiery Flux Supplies via Iron"] = "熾熱助熔劑的補給:鐵錠",
        ["Restoring Fiery Flux Supplies via Kingsblood"] = "熾熱助熔劑的補給:皇血草",
        ["Restoring Sanctity"] = "恢復聖潔",
        ["Restoring the Light"] = "恢復聖光",
        ["Restoring the Necklace"] = "修復項鍊",
        ["Resupplying the Excavation"] = "挖掘場的補給品",
        ["Retaking Windrunner Spire"] = "奪回風行者塔",
        ["Rethban Ore"] = "瑞斯班礦石",
        ["Retribution of the Light"] = "光明的懲戒",
        ["Retrieving the Goods"] = "回收物資",
        ["Return Trip"] = "回程",
        ["Return of the Ring"] = "歸還戒指",
        ["Return the Book"] = "歸還書籍",
        ["Return the Comb"] = "歸還梳子",
        ["Return the Reports"] = "交回報告",
        ["Return the Statuette"] = "歸還雕像",
        ["Return to Andormu"] = "回去安杜姆身邊",
        ["Return to Apothecary Zinge"] = "向藥劑師金格回報",
        ["Return to Arcanist Vandril"] = "回到秘法師范德隆那裡",
        ["Return to Bellowfiz"] = "艾沃沙酒",
        ["Return to Bodley"] = "回到布德利那裡",
        ["Return to Brock"] = "向布洛克回覆",
        ["Return to Chillwind Camp"] = "返回冰風崗",
        ["Return to Chromie"] = "返回克羅米身邊",
        ["Return to Corporal Kaleb"] = "向卡雷布下士回報",
        ["Return to Deliana"] = "回到德莉娜那裡",
        ["Return to Denalan"] = "向德納蘭回報",
        ["Return to Feathermoon Stronghold"] = "返回羽月要塞",
        ["Return to Fel'Zerul"] = "向費澤盧爾覆命",
        ["Return to Honor Hold"] = "返回榮譽堡",
        ["Return to Ironforge"] = "返回鐵爐堡",
        ["Return to Jitters"] = "基特斯的美餐",
        ["Return to Khadgar"] = "回到卡德加那裡",
        ["Return to Kristoff"] = "克里斯多夫的書",
        ["Return to Lewis"] = "返回西部荒野",
        ["Return to MacKinley"] = "向馬克基雷回報",
        ["Return to Marleth"] = "向馬萊斯回報",
        ["Return to Milton"] = "向密爾頓回覆",
        ["Return to Mokvar"] = "回到莫克瓦那裡",
        ["Return to Narain"] = "返回納里安",
        ["Return to Nathanos"] = "向納薩諾斯覆命",
        ["Return to Nessa"] = "飛回泰達希爾",
        ["Return to Obadei"] = "回去找歐拜德",
        ["Return to Onu"] = "向安努回覆",
        ["Return to Podrig"] = "向博迪瑞格回報",
        ["Return to Primal Torntusk"] = "向斷齒族長覆命",
        ["Return to Quartermaster Lymel"] = "回到軍需官里莫那裡",
        ["Return to Quinn"] = "回到奎恩身旁",
        ["Return to Rokag"] = "回到瑞克格那裡",
        ["Return to Sha'tari Base Camp"] = "回到薩塔營地",
        ["Return to Shattrath"] = "回到撒塔斯城",
        ["Return to Silvermoon"] = "回到銀月城",
        ["Return to Sven"] = "回覆斯溫",
        ["Return to Talionia"] = "返回塔萊妮亞那裡",
        ["Return to Thalodien"] = "回去找薩洛迪恩",
        ["Return to Thander"] = "回到薩德爾那裡",
        ["Return to Thrallmar"] = "返回索爾瑪",
        ["Return to Thunder Bluff"] = "返回雷霆崖",
        ["Return to Tinkee"] = "返回丁奇身邊",
        ["Return to Topher Loaal"] = "回到塔伏爾·羅歐那裡",
        ["Return to Troyas"] = "向特洛亞斯回覆",
        ["Return to Tymor"] = "向法師泰摩爾回覆",
        ["Return to Vahlarriel"] = "回覆瓦拉里爾",
        ["Return to Verner"] = "回覆弗納",
        ["Return to Witch Doctor Uzer'i"] = "向巫醫尤克里回覆",
        ["Return to the Abyssal Shelf"] = "回到深淵沙洲",
        ["Return to the Aldor"] = "回報奧多爾",
        ["Return to the Blasted Lands"] = "返回詛咒之地",
        ["Return to the Bulwark"] = "返回亡靈壁壘",
        ["Return to the Crossroads."] = "返回十字路口",
        ["Return to the Greatmother"] = "回到祖母身邊",
        ["Return to the Hinterlands"] = "返回辛特蘭",
        ["Return to the Magistrate"] = "向塞弗倫回報",
        ["Return to the Marsh"] = "回到沼澤",
        ["Return to the Scryers"] = "回到先知者身邊",
        ["Returning Home"] = "回家",
        ["Returning the Cleansed Orb"] = "歸還淨化過的寶珠",
        ["Returning the Favor"] = "回報",
        ["Returning the Lost Satchel"] = "歸還背包",
        ["Reunion"] = "團聚",
        ["Revenge of Gann"] = "加恩的復仇",
        ["Revered Among the Sha'tar"] = "薩塔的崇敬",
        ["Rhapsody Shindigger"] = "拉普索迪·鐵鏟",
        ["Rhapsody's Kalimdor Kocktail"] = "拉普索迪的卡林多雞尾酒",
        ["Rhapsody's Tale"] = "拉普索迪的故事",
        ["Ribbly Screwspigot"] = "雷布里·斯庫比格特",
        ["Ride the Lightning"] = "操控閃電",
        ["Ride to Ironforge"] = "飛往鐵爐堡",
        ["Ride to Orgrimmar"] = "飛往奧格瑪",
        ["Ride to Thunder Bluff"] = "飛往雷霆崖",
        ["Ride to the Undercity"] = "飛往幽暗城",
        ["Ridgespine Menace"] = "山脊的威脅",
        ["Rig Wars"] = "設備之戰",
        ["Rightful Repossession"] = "合法的回收",
        ["Rilli Greasygob"] = "雷里·格里斯高布",
        ["Rin'ji is Trapped!"] = "林吉被困住了!",
        ["Rin'ji's Secret"] = "林吉的秘密",
        ["Ring of Infinite Wisdom"] = "無盡智慧之戒",
        ["Ring of Unspoken Names"] = "禁斷邪語之戒",
        ["Ring of the Gathering Storm"] = "聚集風暴之戒",
        ["Ripple Delivery"] = "送回蜜酒",
        ["Ripple Recovery"] = "尋找蜜酒",
        ["Rise of the Silithid"] = "異種蠍的威脅",
        ["Rising Spirit"] = "高漲的士氣",
        ["Rite of Strength"] = "力量儀祭",
        ["Rite of Vision"] = "幻象儀祭",
        ["Rite of Wisdom"] = "智慧儀祭",
        ["Rites of the Earthmother"] = "大地之母儀祭",
        ["Rituals of Power"] = "能量儀祭",
        ["Rituals of Strength"] = "力量儀式",
        ["Riverpaw Gnoll Bounty"] = "懸賞河爪豺狼人",
        ["Rizzle's Schematics"] = "瑞茲爾的圖表",
        ["Road to Salvation"] = "救贖之路",
        ["Roadside Ambush"] = "路邊的伏擊",
        ["Rocket Car Parts"] = "火箭車零件",
        ["Rocknot's Ale"] = "羅克諾特的麥芽酒",
        ["Rogue Training"] = "盜賊訓練",
        ["Rogues of the Shattered Hand"] = "破碎之手盜賊",
        ["Rohok's Request"] = "洛赫克的請求",
        ["Roll the Bones"] = "挖骨頭",
        ["Root Samples"] = "根鬚樣本",
        ["Rot Hide Clues"] = "線索",
        ["Rot Hide Ichor"] = "腐皮豺狼人的膿液",
        ["Rot Hide Origins"] = "腐皮豺狼人的產生",
        ["Rotten Eggs"] = "惡臭雞蛋",
        ["Rotting Hearts"] = "腐爛之心",
        ["Rude Awakening"] = "突然醒來",
        ["Ruined Kegs"] = "惡臭的雞蛋",
        ["Rumors for Kravel"] = "地精的謠言",
        ["Run a Diagnostic!"] = "進行一次診斷!",
        ["Rune Covered Tablet"] = "符文雕飾石板",
        ["Rune-Inscribed Note"] = "符文便箋",
        ["Rune-Inscribed Parchment"] = "符文羊皮紙",
        ["Rune-Inscribed Tablet"] = "符文石板",
        ["Runecloth"] = "符文布",
        ["Runewarden Deryan"] = "符文守護者德蘭",
        ["Ruthless Cunning"] = "殘忍的狡猾",
        ["Ruuan Weald"] = "魯安曠野",
        ["Ruuzel"] = "盧澤爾",
        ["S-A-B-O-T-A-G-E"] = "破-壞-行-動",
        ["SI:7"] = "軍情七處",
        ["STOLEN: Smithing Tuyere and Lookout's Spyglass"] = "被盜:鼓風機和望遠鏡",
        ["Sabotage the Warp-Gate!"] = "破壞傳送門!",
        ["Sacred Cloth"] = "神聖的月布",
        ["Sacred Fire"] = "聖火",
        ["Safeguarding the Watchers"] = "保護守夜人",
        ["Safety First"] = "安全第一",
        ["Safety Is Job One"] = "安全至上",
        ["Salt Flat Venom"] = "含鹽的蠍毒",
        ["Salt of the Scorpok"] = "厚甲蠍鹽",
        ["Saltheril's Haven"] = "薩瑟里的避風港",
        ["Salvaging the Data"] = "搶救資料",
        ["Salvaging the Past"] = "搶救過去",
        ["Samophlange"] = "什麼什麼平衡器",
        ["Samophlange Manual"] = "主動式負載平衡器說明書",
        ["Sample for Helbrim"] = "給赫布瑞姆的樣本",
        ["Sara Balloo's Plea"] = "薩拉·巴魯的請求",
        ["Sarkoth"] = "薩科斯",
        ["Sathrah's Sacrifice"] = "薩絲拉的祭品",
        ["Satyr Hooves"] = "薩特之蹄",
        ["Satyr Horns"] = "薩特之角",
        ["Satyr Slaying!"] = "獵殺薩特!",
        ["Savage Flora"] = "野性植物群",
        ["Savage Fronds"] = "野性藻葉",
        ["Save Techbot's Brain!"] = "拯救尖端機器人!",
        ["Saving Princess Stillpine"] = "拯救靜松公主",
        ["Saving Sharpbeak"] = "拯救沙普比克",
        ["Saving Yenniku"] = "拯救耶尼庫",
        ["Saving the Best for Last"] = "最後的獎賞",
        ["Saving the Sporeloks"] = "拯救斯柏路克",
        ["Scalding Mornbrew Delivery"] = "熱酒快遞",
        ["Scarab Shells"] = "聖甲蟲的殼",
        ["Scaring Shaky"] = "嚇唬病鬼",
        ["Scarlet Diversions"] = "誤導血色十字軍",
        ["Scarlet Subterfuge"] = "血色幻象",
        ["Scavenging Deathknell"] = "撿破爛",
        ["Scepter of the Council"] = "議會權杖",
        ["Sceptre of Light"] = "聖光權杖",
        ["Scholomance"] = "通靈學院",
        ["Scourge of the Downs"] = "剃刀高地的天譴軍團",
        ["Scouring the Desert"] = "穿過沙漠",
        ["Scouting the Defenses"] = "偵察防禦",
        ["Scratches"] = "達成要求",
        ["Screecher Spirits"] = "尖嘯者的靈魂",
        ["Scrounging"] = "搜集行動",
        ["Scrying Goggles? No Problem!"] = "水晶球護目鏡?沒問題!",
        ["Seal of Ascension"] = "晉升印章",
        ["Sealed Azure Bag"] = "密封的藍袋子",
        ["Search More Hovels"] = "搜尋雕像",
        ["Search Stillpine Hold"] = "搜索靜松要塞",
        ["Search for Incendicite"] = "火岩礦石",
        ["Search for Tyranis"] = "尋找泰拉尼斯",
        ["Searching for Evidence"] = "尋找證據",
        ["Searching for Galaen"] = "尋找高拉恩",
        ["Searching for Scout Jyoba"] = "尋找斥候傑巴",
        ["Searching for the Lost Satchel"] = "尋找背包",
        ["Seasoned Wolf Kabobs"] = "烤狼肉串",
        ["Secret of the Circle"] = "雕像群的秘密",
        ["Secrets of the Arakkoa"] = "阿拉卡的秘密",
        ["Secrets of the Colossus - Ashi"] = "巨像的秘密 - 亞什",
        ["Secrets of the Daggerfen"] = "匕首沼地的秘密",
        ["Securing the Celestial Ridge"] = "保衛天國山脈",
        ["Securing the Lines"] = "保衛商路",
        ["Securing the Shaleskin Shale"] = "獲得岩層泥岩",
        ["Seed of Life"] = "生命之種",
        ["Seeing What Happens"] = "拭目以待",
        ["Seek Huntress Kella Nightbow"] = "尋找女獵人凱拉·夜弓",
        ["Seek Out Kirrik"] = "尋找奇瑞克",
        ["Seek Out Neltharaku"] = "尋找奈爾斯阿拉古",
        ["Seek Redemption!"] = "尋求救贖!",
        ["Seek out SI: 7"] = "軍情七處",
        ["Seek the Farstriders"] = "尋找遠行者",
        ["Seeking Strahad"] = "尋找斯坦哈德",
        ["Seeking Wisdom"] = "尋求指引",
        ["Seeking the Kor Gem"] = "尋找科爾寶石",
        ["Seeping Corruption"] = "墮落之水",
        ["Seer Udalo"] = "先知烏達羅",
        ["Selling Fish"] = "賣魚",
        ["Senir's Observations"] = "森內爾的觀察站",
        ["Sentinel Advanced Care Package"] = "哨兵高級護理包",
        ["Sentinel Basic Care Package"] = "哨兵基礎護理包",
        ["Sentinel Standard Care Package"] = "哨兵標準護理包",
        ["Separation Anxiety"] = "分離的痛苦",
        ["Serena Bloodfeather"] = "塞瑞娜·血羽",
        ["Sergra Darkthorn"] = "瑟格拉·黑棘",
        ["Serpent Wild"] = "狂熱之蛇",
        ["Serpentbloom"] = "毒蛇花",
        ["Service to the Horde"] = "為部落效力",
        ["Set Them Ablaze!"] = "燒掉它們!",
        ["Setting Up the Bomb"] = "設置炸彈",
        ["Shadow Magic"] = "暗影魔法",
        ["Shadow of the Past"] = "往日的陰影",
        ["Shadoweaver"] = "暗影蛛絲",
        ["Shadowpine Weaponry"] = "滅絕闇谷食人妖",
        ["Shadowshard Fragments"] = "裂影碎片",
        ["Shadumbra's Head"] = "薩杜布拉的頭顱",
        ["Shaman Training"] = "薩滿訓練",
        ["Shard of a Felhound"] = "地獄犬的靈魂",
        ["Shard of an Infernal"] = "地獄火的靈魂",
        ["Shards of the Felvine"] = "魔藤裂片",
        ["Shardtooth E'ko"] = "裂齒魂精",
        ["Sharing the Knowledge"] = "分享知識",
        ["Sharing the Land"] = "土地之爭",
        ["Sharptalon's Claw"] = "沙普塔隆的爪子",
        ["Shatter Point"] = "破碎崗哨",
        ["Shattering the Veil"] = "粉碎外表",
        ["Shimmer Stout"] = "微光酒",
        ["Ship Schedules"] = "船運時刻表",
        ["Shipment to Stormwind"] = "送往暴風城的貨物",
        ["Shizz Work"] = "噁心的工作",
        ["Shizzle's Flyer"] = "希茲爾的的飛行器",
        ["Shoulderpads of Faith"] = "信仰肩墊",
        ["Show Gnomercy"] = "別對地精仁慈",
        ["Show Them Gnome Mercy!"] = "給他們地精式的解脫!",
        ["Show Your Work"] = "工作成果",
        ["Showdown"] = "攤牌",
        ["Shredding Machines"] = "伐木機",
        ["Shroud of Infinite Wisdom"] = "無盡智慧罩氅",
        ["Shroud of Unspoken Names"] = "禁斷邪語罩氅",
        ["Shrouded in Nightmare"] = "夢魘的纏繞",
        ["Shutting Down Manaforge Ara"] = "關閉法力熔爐艾拉",
        ["Shutting Down Manaforge B'naar"] = "關閉法力熔爐巴納爾",
        ["Shutting Down Manaforge Coruu"] = "關閉法力熔爐寇魯",
        ["Shutting Down Manaforge Duro"] = "關閉法力熔爐杜羅",
        ["Shy-Rotam"] = "希洛塔姆",
        ["Sickle of Unyielding Strength"] = "不屈力量之鐮",
        ["Sigil of Arathor"] = "阿拉索符印",
        ["Sigil of Strom"] = "激流堡符印",
        ["Sigil of Thoradin"] = "索拉丁符印",
        ["Sigil of Trollbane"] = "托爾貝恩符印",
        ["Signal for Pickup"] = "信號發射器",
        ["Signet of Unyielding Strength"] = "不屈力量之戒",
        ["Signet of the Dukes"] = "公爵的徽記",
        ["Signet of the Unseen Path"] = "隱秘通途之戒",
        ["Signets of the Zandalar"] = "贊達拉的徽記",
        ["Signs of the Legion"] = "燃燒軍團的徵象",
        ["Silkwing Cocoons"] = "絲翼之繭",
        ["Silver Heart"] = "銀爪鐵心",
        ["Simple Letter"] = "簡要的信件",
        ["Simple Memorandum"] = "簡易備忘錄",
        ["Simple Note"] = "簡易便箋",
        ["Simple Parchment"] = "簡易羊皮紙",
        ["Simple Rune"] = "簡易符文",
        ["Simple Scroll"] = "簡易卷軸",
        ["Simple Sigil"] = "簡易符記",
        ["Simple Subterfugin'"] = "國王的財寶",
        ["Simple Tablet"] = "普通石板",
        ["Since Time Forgotten..."] = "不知道從什麼時候開始…………",
        ["Singing Blue Shards"] = "藍色歌唱水晶裂片",
        ["Single Firewing Signet"] = "單一的火翼徽章",
        ["Single Mark of Kil'jaeden"] = "單一基爾加丹印記",
        ["Single Mark of Sargeras"] = "一個薩格拉斯印記",
        ["Sister Pamela"] = "小妹妹帕米拉",
        ["Situation at Sunsail Anchorage"] = "日帆泊地的狀況",
        ["Skeletal Fragments"] = "骷髏碎片",
        ["Skirmish at Echo Ridge"] = "回音山清剿行動",
        ["Skulk Rock Clean-up"] = "清理隱匿石",
        ["Skull Rock"] = "骷髏石",
        ["Skullsplitter Tusks"] = "劈顱食人妖的獠牙",
        ["Skymistress Gloaming"] = "女飛行師·薄暮",
        ["Slain by the Wretched"] = "鄙惡者兇手",
        ["Slake That Thirst"] = "口渴的比格維茲",
        ["Slaughter at Boulder'mok"] = "圓面之地大屠殺",
        ["Slay the Brood Mother"] = "殺死幼龍之母",
        ["Slaying the Beast"] = "饑餓者塔拉加曼",
        ["Small Furry Paws"] = "毛茸茸的小爪子",
        ["Smart Drinks"] = "智慧飲料",
        ["Smith Mathiel"] = "鐵匠瑪希爾",
        ["Smooth as Butter"] = "技術高超",
        ["Snakestone of the Shadow Huntress"] = "沃許加斯的菊石",
        ["Snatch and Grab"] = "連偷帶搶",
        ["Snickerfang Jowls"] = "彎牙土狼的顎骨",
        ["Soaked Pages"] = "浸溼的書頁",
        ["Socrethar's Shadow"] = "索奎薩爾的影子",
        ["Soft Bushy Tails"] = "柔軟的狼尾",
        ["Solanian's Belongings"] = "索蘭尼亞的東西",
        ["Solomon's Law"] = "所羅門的律法",
        ["Solution to Doom"] = "化解災難",
        ["Solving the Problem"] = "解決問題",
        ["Some Assembly Required"] = "收集鱷魚皮",
        ["Someone Else's Hard Work Pays Off"] = "解決別人的難事",
        ["Soothing Spices"] = "舒心草",
        ["Soothing Turtle Bisque"] = "海龜湯",
        ["Soulbound Keepsake"] = "禁錮靈魂的遺物",
        ["Source of the Corruption"] = "腐敗根源",
        ["Southsea Freebooters"] = "南海掠劫者",
        ["Southsea Shakedown"] = "南海復仇",
        ["Southshore"] = "南海鎮",
        ["Souvenirs of Death"] = "死亡的紀念品",
        ["Spare Parts"] = "備用零件",
        ["Spawn of Jubjub"] = "啾啾的蛋",
        ["Speak to Nafien"] = "與納菲恩交談",
        ["Speak to Salfa"] = "與薩爾法交談",
        ["Speak with Anastasia"] = "安娜斯塔西婭",
        ["Speak with Bink"] = "和彬克交談",
        ["Speak with Coleman"] = "庫勒曼",
        ["Speak with Deino"] = "食人妖法師迪諾",
        ["Speak with Dillinger"] = "迪林格爾",
        ["Speak with Gramma"] = "跟湯米的祖母談話",
        ["Speak with Jennea"] = "和詹妮亞交談",
        ["Speak with Private Weeks"] = "與士兵維克斯談話",
        ["Speak with Renferrel"] = "與倫法洛會面",
        ["Speak with Rilak the Redeemed"] = "跟『贖罪者』里拉克談談",
        ["Speak with Ruga"] = "和魯迦交談",
        ["Speak with Scout Neftis"] = "與斥侯奈夫提斯談話",
        ["Speak with Sevren"] = "與塞弗倫交談",
        ["Speak with Shoni"] = "沉默的舒尼",
        ["Speak with Thun'grim"] = "和索恩格瑞姆交談",
        ["Speak with Un'thuwa"] = "安蘇瓦",
        ["Speaking of Fortitude"] = "關於堅韌的演講",
        ["Speaking with Gan'zulah"] = "甘祖拉恩",
        ["Speaking with Nezzliok"] = "奈茲里奧克",
        ["Special Delivery for Gaxim"] = "給加克希姆的特快專遞",
        ["Special Forces"] = "特種部隊",
        ["Spectrecles"] = "顯靈鏡",
        ["Spellfire Robes"] = "魔焰長袍",
        ["Spinal Dust"] = "脊骨之塵",
        ["Spinebreaker Post"] = "斷脊氏族崗哨",
        ["Spirit Calling"] = "呼喚靈魂",
        ["Spirit Totem"] = "靈魂圖騰",
        ["Spirit of the Boar"] = "野豬之靈",
        ["Spirit of the Wind"] = "風之靈",
        ["Spirits of the Drowned"] = "溺死者的靈魂",
        ["Spirits of the Feralfen"] = "菲拉芬靈魂",
        ["Spiritual Domination"] = "精神矍鑠",
        ["Spiritual Unrest"] = "永不安息的靈魂",
        ["Spleendid!"] = "美味的脾臟!",
        ["Split Bone Necklace"] = "裂骨項鍊",
        ["Sporeggar"] = "斯博格爾",
        ["Sprinkle's Secret Ingredient"] = "斯普琳科的秘密佐料",
        ["Squire Maltrake"] = "侍衛瑪特拉克",
        ["Stalking the Stalkers"] = "銀鬃捕獵者",
        ["Stalwart's Battlegear"] = "忠誠者的裝備",
        ["Standards and Practices"] = "軍旗與實行",
        ["Starfall"] = "墜星村",
        ["Stave of the Ancients"] = "上古守護者的手杖",
        ["Stealing Back the Mushrooms"] = "偷回蘑菇",
        ["Stealing Knowledge"] = "偷竊知識",
        ["Stealing Supplies"] = "偷取物資",
        ["Stealing from Thieves"] = "偷小偷的東西",
        ["Stealth Flight"] = "隱形飛行",
        ["Steelsnap"] = "鋼齒土狼",
        ["Stepping Up Security"] = "確保安全",
        ["Still Believing"] = "更多的讀物",
        ["Stillpine Hold"] = "靜松要塞",
        ["Sting of the Scorpid"] = "工蠍的尾巴",
        ["Stinger Venom"] = "刺針毒素",
        ["Stinging the Stingers"] = "以牙還牙",
        ["Stinglasher"] = "毒刺鞭笞者",
        ["Stinking Up Southshore"] = "薰死南海鎮",
        ["Stinky's Escape"] = "伊格納茲的逃亡",
        ["Stocking Jetsteam"] = "貝爾丁的補給",
        ["Stolen Booty"] = "被竊的貨物",
        ["Stolen Silver"] = "被偷走的銀幣",
        ["Stoley's Debt"] = "斯杜雷的債務",
        ["Stoley's Shipment"] = "斯杜雷的貨物",
        ["Stone Tokens"] = "石雕",
        ["Stonegear's Search"] = "迪恩·石輪的追尋",
        ["Stones of Binding"] = "禁錮之石",
        ["Stonetalon Standstill"] = "石爪山的困境",
        ["Stopping the Spread"] = "阻止蔓延",
        ["Stormers and Rumblers"] = "雷暴和磐石",
        ["Stormpike's Deciphering"] = "解碼高手",
        ["Stormpike's Delivery"] = "雷矛的包裹",
        ["Stormpike's Order"] = "雷矛的訂單",
        ["Stormwind Ho!"] = "升官之道",
        ["Stormwind Library"] = "暴風城圖書館",
        ["Stormwind Rendezvous"] = "暴風城在集合",
        ["Stout to Kadrell"] = "給卡德雷爾的酒",
        ["Strained Supplies"] = "物資短缺",
        ["Strange Alliance"] = "奇怪的聯盟",
        ["Strange Brew"] = "怪酒",
        ["Strange Energy"] = "奇怪的能量",
        ["Strange Findings"] = "奇怪的發現",
        ["Strange Sources"] = "奇怪的源頭",
        ["Stranglethorn Fever"] = "荊棘谷熱疫",
        ["Strength of One"] = "一人的力量",
        ["Striker's Diadem"] = "攻擊者的王冠",
        ["Striker's Footguards"] = "攻擊者的護足",
        ["Striker's Hauberk"] = "攻擊者鍊衫",
        ["Stromgarde Badges"] = "激流堡徽章",
        ["Study of the Elements: Rock"] = "研究石元素",
        ["Stymying the Arakkoa"] = "阻礙阿拉卡",
        ["Success!"] = "成功!",
        ["Sully Balloo's Letter"] = "蘇利·巴魯的信",
        ["Summon Felsteed"] = "召喚地獄戰馬",
        ["Summoner Kanthin's Prize"] = "召喚者卡辛恩的禮物",
        ["Summoning Shadra"] = "召喚沙德拉",
        ["Summoning the Princess"] = "召喚大地公主",
        ["Summons from Knight-Lord Bloodvalor"] = "騎士領主伯洛德瓦勒的召喚",
        ["Suncrown Village"] = "日冠村",
        ["Sunfury Briefings"] = "日怒簡報",
        ["Sunfury Signets"] = "日怒徽章",
        ["Sunken Treasure"] = "水下寶藏",
        ["Sunscorched Shells"] = "曬焦的蛋殼",
        ["Suntara Stones"] = "桑塔拉之石",
        ["Super Reaper 6000"] = "超級收割機6000",
        ["Super Sticky"] = "極度粘稠的瀝青",
        ["Superior Armaments of Battle - Exalted Amongst the Dawn"] = "精良級軍備之戰-銀色黎明聲望崇拜",
        ["Superior Armaments of Battle - Friend of the Dawn"] = "精良級軍備之戰-銀色黎明聲望友善",
        ["Superior Armaments of Battle - Honored Amongst the Dawn"] = "精良級軍備之戰-銀色黎明聲望尊敬",
        ["Superior Armaments of Battle - Revered Amongst the Dawn"] = "精良級軍備之戰-銀色黎明聲望崇敬",
        ["Supervisor Fizsprocket"] = "菲茲普羅克主管",
        ["Supplies for Nethergarde"] = "守望堡的補給物資",
        ["Supplies for the Crossroads"] = "十字路口的補給物資",
        ["Supplies from Darkshire"] = "來自夜色鎮的補給",
        ["Supplies to Auberdine"] = "奧伯丁的補給品",
        ["Supplies to Private Thorsen"] = "送補給物資給士兵托爾森",
        ["Supplies to Tannok"] = "塔諾克的補給品",
        ["Supply and Demand"] = "供與求",
        ["Supplying the Front"] = "前線的補給",
        ["Supplying the Sepulcher"] = "瑟伯切爾的補給",
        ["Surena Caledon"] = "蘇倫娜·凱爾東",
        ["Surrender to the Horde"] = "向部落投降",
        ["Survey the Land"] = "調查土地",
        ["Surveying the Ruins"] = "調察這些廢墟",
        ["Suspicious Hoofprints"] = "可疑的蹄印",
        ["Sven's Camp"] = "斯溫的營地",
        ["Sven's Revenge"] = "斯溫的復仇",
        ["Sweet Amber"] = "琥珀酒",
        ["Sweet Serenity"] = "甜美的平靜",
        ["Swift Discipline"] = "即時的懲罰",
        ["Swoop Hunting"] = "獵捕猛鷲",
        ["Syndicate Assassins"] = "辛迪加刺客",
        ["Syndicate Emblems"] = "辛迪加徽章",
        ["Synthesis of Power"] = "力量的綜合",
        ["Tabards of the Illidari"] = "伊利達瑞的外衣",
        ["Tabetha's Task"] = "塔貝薩的任務",
        ["Tablet of the Seven"] = "七賢石板",
        ["Tablets of Baa'ri"] = "巴瑞碑文",
        ["Tainted Arcane Sliver"] = "腐敗的秘法薄片",
        ["Tainted Letter"] = "受污染的信件",
        ["Tainted Memorandum"] = "受污染的備忘錄",
        ["Tainted Parchment"] = "受污染的羊皮紙",
        ["Tainted Scroll"] = "受污染的卷軸",
        ["Take Five Bases"] = "奪取五座基地",
        ["Take Four Bases"] = "奪取四座基地",
        ["Taken in the Night"] = "夜裡被劫走的人",
        ["Taking Back Silithus"] = "奪回希利蘇斯",
        ["Taking the Fall"] = "說謊",
        ["Tal the Wind Rider Master"] = "雙足飛龍管理員塔爾",
        ["Talbuk Mastery"] = "塔巴克專精",
        ["Talk to the Hand"] = "與阿格斯之手談談",
        ["Taming the Beast"] = "馴服野獸",
        ["Tanaris Field Sampling"] = "塔納利斯的樣本",
        ["Taretha's Gift"] = "塔蕾莎的禮物",
        ["Target: Dalson's Tears"] = "目標:達爾松之淚",
        ["Target: Felstone Field"] = "目標:費爾斯通農場",
        ["Target: Gahrron's Withering"] = "目標:蓋羅恩農場",
        ["Target: Hive'Ashi Defenders"] = "目標:亞什防衛者",
        ["Target: Hive'Ashi Sandstalkers"] = "目標:亞什沙行者",
        ["Target: Hive'Ashi Stingers"] = "目標:亞什毒蠍",
        ["Target: Hive'Ashi Workers"] = "目標:亞什工蠍",
        ["Target: Hive'Regal Ambushers"] = "目標:雷戈伏擊者",
        ["Target: Hive'Regal Burrowers"] = "目標:雷戈掘洞者",
        ["Target: Hive'Regal Slavemakers"] = "目標:雷戈制奴者",
        ["Target: Hive'Regal Spitfires"] = "目標:雷戈噴火者",
        ["Target: Hive'Zora Hive Sisters"] = "目標:佐拉雌蠍",
        ["Target: Hive'Zora Reavers"] = "目標:佐拉搶奪者",
        ["Target: Hive'Zora Tunnelers"] = "目標:佐拉坑道蠍",
        ["Target: Hive'Zora Waywatchers"] = "目標:佐拉守衛",
        ["Target: Writhing Haunt"] = "目標:嚎哭鬼屋",
        ["Tear of the Earthmother"] = "大地之母的眼淚",
        ["Tears of the Moon"] = "月神的淚水",
        ["Teldrassil"] = "泰達希爾",
        ["Teleport This!"] = "傳送這個!",
        ["Tenaron's Summons"] = "特納隆的召喚",
        ["Terokk's Legacy"] = "泰洛克的遺產",
        ["Terokkarantula"] = "泰洛卡狼蛛",
        ["Teron Gorefiend - Lore and Legend"] = "泰朗·血魔-傳說與傳奇",
        ["Test Flight: Razaan's Landing"] = "飛行測試:雷森平台",
        ["Test Flight: Ruuan Weald"] = "飛行測試:魯安曠野",
        ["Test Flight: The Singing Ridge"] = "飛行測試:美聲山脊",
        ["Test Flight: The Zephyrium Capacitorium"] = "測試飛行:ZC號",
        ["Test of Endurance"] = "耐力的試煉",
        ["Test of Faith"] = "信仰的試煉",
        ["Test of Lore"] = "知識試煉",
        ["Test of Strength"] = "力量的試煉",
        ["Testing an Enemy's Strength"] = "試探敵人",
        ["Testing for Corruption - Felwood"] = "墮落檢測 - 費伍德森林",
        ["Testing for Impurities - Un'Goro Crater"] = "雜質檢測 - 安戈洛環形山",
        ["Testing the Antidote"] = "測試解毒劑",
        ["Testing the Prototype"] = "測試原型",
        ["Testing the Tonic"] = "測試藥水",
        ["Testing the Vessel"] = "測試容器",
        ["Thadius Grimshade"] = "薩迪斯·格希德",
        ["Thalanaar Delivery"] = "薩蘭納爾的貨物",
        ["Tharil'zun"] = "薩瑞爾祖恩",
        ["Tharnariun's Hope"] = "薩納瑞恩的希望",
        ["That Little Extra Kick"] = "一點額外的刺激",
        ["That's Asking A Lot"] = "獅子大開口",
        ["Thazz'ril's Pick"] = "塔茲利爾的鎬",
        ["The Absent Minded Prospector"] = "健忘的勘察員",
        ["The Active Agent"] = "活躍的探子",
        ["The Admiral's Orders"] = "將軍的命令",
        ["The Affray"] = "格鬥考驗",
        ["The Agitated Ancestors"] = "焦慮的先祖們",
        ["The Agony and the Darkness"] = "苦痛的黑暗",
        ["The Algaz Gauntlet"] = "丹奧加茲告急",
        ["The All-Seeing Eye of Zuldazar"] = "祖達薩的全視之眼",
        ["The Alliance Needs Iron Bars!"] = "聯盟需要鐵錠!",
        ["The Alliance Needs Light Leather!"] = "聯盟需要輕皮!",
        ["The Alliance Needs Linen Bandages!"] = "聯盟需要亞麻繃帶!",
        ["The Alliance Needs Medium Leather!"] = "聯盟需要中皮!",
        ["The Alliance Needs More Copper Bars!"] = "聯盟需要更多銅錠!",
        ["The Alliance Needs More Linen Bandages!"] = "聯盟需要更多亞麻繃帶!",
        ["The Alliance Needs More Medium Leather!"] = "聯盟需要更多中皮!",
        ["The Alliance Needs More Silk Bandages!"] = "聯盟需要更多絲質繃帶!",
        ["The Alliance Needs More Spotted Yellowtail!"] = "聯盟需要更多斑點黃尾魚!",
        ["The Alliance Needs More Thorium Bars!"] = "聯盟需要更多瑟銀錠!",
        ["The Alliance Needs Runecloth Bandages!"] = "聯盟需要符文布繃帶!",
        ["The Alliance Needs Silk Bandages!"] = "聯盟需要絲質繃帶!",
        ["The Alliance Needs Spotted Yellowtail!"] = "聯盟需要斑點黃尾魚!",
        ["The Altar of Zul"] = "祖爾祭壇",
        ["The Ancient Egg"] = "遠古之卵",
        ["The Ancient Leaf"] = "遠古石葉",
        ["The Ancient Statuette"] = "遠古雕像",
        ["The Angry Scytheclaws"] = "狂暴的鐮爪龍",
        ["The Annals of Darrowshire"] = "達隆郡的歷史",
        ["The Annals of Kirin'Var"] = "肯瑞瓦的記錄",
        ["The Apes of Un'Goro"] = "安戈洛的猩猩",
        ["The Apple Falls"] = "詹諾克的花",
        ["The Arakkoa Threat"] = "阿拉卡的威脅",
        ["The Arcanist's Cookbook"] = "秘法師的食譜",
        ["The Archivist"] = "文獻管理員",
        ["The Archmage's Staff"] = "大法師之杖",
        ["The Argent Hold"] = "銀色黎明寶箱",
        ["The Art of Fel Reaver Maintenance"] = "惡魔搶奪者保養技術",
        ["The Art of the Armorsmith"] = "護甲鍛造師的藝術",
        ["The Art of the Imbue"] = "灌魔工藝",
        ["The Ashenvale Hunt"] = "梣谷狩獵",
        ["The Ashtongue Broken"] = "灰舌部族",
        ["The Ashtongue Corruptors"] = "灰舌墮落者",
        ["The Ashtongue Tribe"] = "灰舌部族",
        ["The Assassin"] = "刺客",
        ["The Atal'ai Exile"] = "阿塔萊流放者",
        ["The Attack!"] = "伏擊!",
        ["The Azure Key"] = "碧藍鑰匙",
        ["The Bait for Lar'korwi"] = "拉克維的誘餌",
        ["The Balance of Light and Shadow"] = "光與影的平衡",
        ["The Balance of Nature"] = "自然的平衡",
        ["The Balnir Farmstead"] = "巴尼爾農場",
        ["The Barrens Oases"] = "貧瘠之地的綠洲",
        ["The Barrens Port"] = "貧瘠之地的港口",
        ["The Basilisk's Bite"] = "石化蜥蜴的大腦",
        ["The Battle Horn"] = "戰鬥號角",
        ["The Battle Plans"] = "作戰計畫",
        ["The Battle of Alterac"] = "霜狼地圖",
        ["The Battle of Darrowshire"] = "達隆郡的戰鬥",
        ["The Battleboars"] = "鬥豬",
        ["The Bear Necessities"] = "熊的必需品",
        ["The Bearer of Bad News"] = "糟糕的消息",
        ["The Befouled Element"] = "被污染的水元素",
        ["The Best Defense"] = "最佳的防禦",
        ["The Big Bone Worm"] = "巨大白骨蟲",
        ["The Biggest of Them All"] = "最大的挑戰",
        ["The Binding"] = "誓縛",
        ["The Black Morass"] = "黑色沼澤",
        ["The Black Shield"] = "黑色盾牌",
        ["The Blackwood Corrupted"] = "黑木熊怪的墮落",
        ["The Bladespire Ogres"] = "劍刃巨魔",
        ["The Bladespire Threat"] = "劍刃的威脅",
        ["The Blightcaller Cometh"] = "凋零者",
        ["The Blood Elves"] = "血精靈",
        ["The Blood is Life"] = "血液就是生命",
        ["The Blood-Tempered Ranseur"] = "血淬三叉矛",
        ["The Bloodcurse Legacy"] = "血咒遺產",
        ["The Bloodcursed Naga"] = "血咒納迦",
        ["The Bloodmaul Ogres"] = "血槌巨魔",
        ["The Bloodsail Buccaneers"] = "血帆海盜",
        ["The Boar Hunter"] = "獵殺野豬",
        ["The Boha'mu Ruins"] = "波哈姆廢墟",
        ["The Book of Fel Names"] = "地獄之名魔典",
        ["The Book of Ur"] = "烏爾之書",
        ["The Borrower"] = "海龜照片",
        ["The Bounty of Teldrassil"] = "泰達希爾的漁業",
        ["The Branch of Cenarius"] = "塞納留斯的樹枝",
        ["The Brassbolts Brothers"] = "銅栓兄弟",
        ["The Broken Sigil"] = "破碎的符印",
        ["The Brood of Onyxia"] = "奧妮克希亞的血脈",
        ["The Call to Command"] = "上級的命令",
        ["The Calling"] = "召喚",
        ["The Caravan Road"] = "商隊通路",
        ["The Carevin Family"] = "卡爾文家族",
        ["The Caverns of Time"] = "時光之穴",
        ["The Cenarion Expedition"] = "塞納里奧遠征隊",
        ["The Challenge"] = "挑戰",
        ["The Champion of the Banshee Queen"] = "女妖之王的勇士",
        ["The Champion of the Horde"] = "部落的勇士",
        ["The Changing of Paths - Conqueror No More"] = "遠離征服者之路",
        ["The Changing of Paths - Protector No More"] = "遠離保衛者之路",
        ["The Charge of the Dragonflights"] = "守護之龍",
        ["The Chill of Death"] = "死亡之寒",
        ["The Cipher of Damnation"] = "毀滅密碼",
        ["The Cipher of Damnation - Ar'tor's Charge"] = "毀滅密碼 - 阿爾托的命令",
        ["The Cipher of Damnation - Borak's Charge"] = "毀滅密碼 - 柏爾拉克的命令",
        ["The Cipher of Damnation - Grom'tor's Charge"] = "毀滅密碼 - 葛洛姆特的命令",
        ["The Cipher of Damnation - The First Fragment Recovered"] = "毀滅密碼 - 取回第一部",
        ["The Cipher of Damnation - The Second Fragment Recovered"] = "毀滅密碼 - 取回第二部",
        ["The Cipher of Damnation - The Third Fragment Recovered"] = "毀滅密碼 - 取回第三部",
        ["The Cipher of Damnation - Truth and History"] = "毀滅密碼 - 歷史與真相",
        ["The Cliffspring River"] = "壁泉河",
        ["The Coast Isn't Clear"] = "清理海岸",
        ["The Coastal Menace"] = "海岸上的威脅",
        ["The Codex of Blood"] = "血之聖典",
        ["The Collector"] = "收貨人",
        ["The Color of Blood"] = "鮮血的顏色",
        ["The Completed Orb of Dar'Orahil"] = "達奧拉赫寶珠",
        ["The Completed Orb of Noh'Orahil"] = "諾奧拉赫寶珠",
        ["The Completed Robe"] = "完成金線血袍",
        ["The Consortium Needs You!"] = "聯合團需要你!",
        ["The Corpulent One"] = "肥仔",
        ["The Corrupter"] = "墮落者",
        ["The Corruption Abroad"] = "遙遠的旅途",
        ["The Corruption of the Jadefire"] = "碧火薩特",
        ["The Count of the Marshes"] = "沼澤的伯爵",
        ["The Cover of Darkness"] = "黑暗籠罩",
        ["The Crimson Courier"] = "紅衣信差",
        ["The Crone of the Kraul"] = "剃刀沼澤的乾癟老太婆",
        ["The Crown of Will"] = "意志之冠",
        ["The Cryo-Core"] = "寒冰核心",
        ["The Crystal of Zin-Malor"] = "辛瑪洛水晶",
        ["The Curious Visitor"] = "好奇的訪客",
        ["The Curse of the Tides"] = "海潮的詛咒",
        ["The Cursed Crew"] = "被詛咒的船員",
        ["The Damned"] = "被詛咒者",
        ["The Dark Iron War"] = "黑鐵戰爭",
        ["The Dark Missive"] = "黑暗書信",
        ["The Darkmoon Faire"] = "暗月馬戲團",
        ["The Darkreaver Menace"] = "達克雷爾的威脅",
        ["The Darkstone Tablet"] = "黑暗石板",
        ["The Daughter Who Lived"] = "倖存的女兒",
        ["The Day After"] = "災難之後",
        ["The Dead Fields"] = "亡者農場",
        ["The Dead Mire"] = "死亡污泥",
        ["The Dead Scar"] = "死亡之痕",
        ["The Deathforge"] = "死亡熔爐",
        ["The Deathstalkers"] = "亡靈哨兵",
        ["The Deathstalkers' Report"] = "亡靈哨兵的報告",
        ["The Decisive Striker"] = "決定性的打擊",
        ["The Decrepit Ferry"] = "破舊渡口",
        ["The Defense of Grom'gol"] = "格羅姆高保衛戰",
        ["The Defias Brotherhood"] = "迪菲亞兄弟會",
        ["The Demon Forge"] = "惡魔熔爐",
        ["The Demon Hunter"] = "惡魔獵人",
        ["The Demon Scarred Cloak"] = "惡魔之傷",
        ["The Demon Seed"] = "惡魔之種",
        ["The Demoniac Scryer"] = "惡魔占卜器",
        ["The Den"] = "大獸穴",
        ["The Den Mother"] = "獸穴之后",
        ["The Deserter"] = "沙漠隱士",
        ["The Deserters"] = "背叛者",
        ["The Disgraced One"] = "悔恨的戰士",
        ["The Disruption Ends"] = "野豬人的頭目",
        ["The Divination"] = "占卜",
        ["The Divination Scryer"] = "預言水晶球",
        ["The Doomed Fleet"] = "被詛咒的艦隊",
        ["The Dormant Shade"] = "潛伏的陰影",
        ["The Dragon's Eye"] = "巨龍之眼",
        ["The Dread Citadel - Naxxramas"] = "可怕的堡壘 - 納克薩瑪斯",
        ["The Dread Relic"] = "恐怖聖物",
        ["The Dreghood Elders"] = "崔互德長者",
        ["The Dunemaul Compound"] = "砂槌巨魔",
        ["The Dwarven Spy"] = "矮人間諜",
        ["The Dying Balance"] = "垂死的平衡",
        ["The Dynamic Duo"] = "最佳拍檔",
        ["The Earthbinder"] = "大地束縛者",
        ["The Eastern Kingdoms"] = "東部王國",
        ["The Eastern Plagues"] = "東部的瘟疫",
        ["The Eastern Pylon"] = "東部水晶塔",
        ["The Ectoplasmic Distiller"] = "外膜蒸餾器",
        ["The Eighteenth Pilot"] = "第十八個駕駛員",
        ["The Elder Crone"] = "長者",
        ["The Elemental Equation"] = "元素方程式",
        ["The Elusive Ironjaw"] = "難捉摸的鐵顎",
        ["The Emerald Dream..."] = "翡翠夢境……",
        ["The Emerald Dreamcatcher"] = "翡翠攝夢符",
        ["The Emitter"] = "發射器",
        ["The Enchanted Glade"] = "神諭林地",
        ["The Encroaching Wilderness"] = "失控的侵略",
        ["The Engraved Ring"] = "黛麗婭的戒指",
        ["The Ensorcelled Parchment"] = "附有魔法的羊皮紙",
        ["The Escape"] = "偷跑",
        ["The Essence of Aku'Mai"] = "阿庫麥爾水晶",
        ["The Essence of Eranikus"] = "伊蘭尼庫斯精華",
        ["The Ethereum"] = "伊斯利恩",
        ["The Everlook Report"] = "永望鎮報告",
        ["The Everstill Bridge"] = "止水湖上的橋",
        ["The Exorcism"] = "驅除魔鬼",
        ["The Exorcism of Colonel Jules"] = "喬渥上校的驅邪儀式",
        ["The Eye of Paleth"] = "帕雷斯之眼",
        ["The Eyes of Grillok"] = "葛銳洛克之眼",
        ["The Eyes of Skettis"] = "司凱堤斯之眼",
        ["The Fall of Ameth'Aran"] = "亞米薩蘭的毀滅",
        ["The Fall of Kel'Thuzad"] = "科爾蘇加德的墮落",
        ["The Fall of Ossirian"] = "奧斯里安的墮落",
        ["The Fallen Courier"] = "倒下的信差",
        ["The Fallen Exarch"] = "墮落的主教",
        ["The Family Crypt"] = "家族墓穴",
        ["The Family and the Fishing Pole"] = "釣魚世家",
        ["The Fare of Lar'korwi"] = "拉克維的食物",
        ["The Fargodeep Mine"] = "法戈第礦坑",
        ["The Farstrider Enclave"] = "遠行者營地",
        ["The Fate of Flanis"] = "弗藍尼斯的命運",
        ["The Fate of Kagrosh"] = "凱格羅西的命運",
        ["The Fate of Ramaladni"] = "羅馬拉丁尼的命運",
        ["The Fate of Tuurem"] = "杜瑞的命運",
        ["The Fate of Yenniku"] = "耶尼庫的命運",
        ["The Fate of the Kingdom"] = "王國的命運",
        ["The Feast of Winter Veil"] = "冬幕節",
        ["The Fel and the Furious"] = "狂熱的地獄",
        ["The Final Code"] = "最終的密碼",
        ["The Final Message to the Wildhammer"] = "給蠻錘部族的最後警告",
        ["The Final Piece"] = "最後一片",
        ["The Final Reagents"] = "最後的試劑",
        ["The Final Sample"] = "最後的樣本",
        ["The Final Tablets"] = "最後的石板",
        ["The Finest Down"] = "完美的羽毛",
        ["The Firewing Liaison"] = "火翼聯繫",
        ["The Firewing Point Project"] = "火翼崗哨計畫",
        ["The First Trial"] = "第一個試煉",
        ["The First and the Last"] = "第一個和最後一個",
        ["The Flame's Casing"] = "烈焰之盒",
        ["The Flawless Flame"] = "無瑕之焰",
        ["The Flesh Does Not Lie"] = "血肉不會撒謊",
        ["The Flesh Lies..."] = "地上的屍體……",
        ["The Foot of the Citadel"] = "堡壘之根",
        ["The Force of Neltharaku"] = "奈爾斯阿拉古的力量",
        ["The Forging of Quel'Serrar"] = "鑄造奎爾塞拉",
        ["The Forgotten Heirloom"] = "遺失的傳家之寶",
        ["The Forgotten Pools"] = "遺忘之池",
        ["The Formation of Felbane"] = "武器的鑄造",
        ["The Forsaken"] = "被遺忘者",
        ["The Four Dukes"] = "四個公爵",
        ["The Fragments Within"] = "水晶中的碎骨",
        ["The Fury Runs Deep"] = "積怒已久",
        ["The Giant Guardian"] = "大保姆",
        ["The Glowing Fruit"] = "發光的水果",
        ["The Glowing Shard"] = "發光的裂片",
        ["The God Hakkar"] = "神靈哈卡",
        ["The Good Stuff"] = "好東西",
        ["The Gordok Ogre Suit"] = "戈多克巨魔裝",
        ["The Gordok Taste Test"] = "戈多克好酒",
        ["The Gordunni Orb"] = "戈杜尼寶珠",
        ["The Gordunni Scroll"] = "戈杜尼卷軸",
        ["The Grand Betrayal"] = "大叛徒",
        ["The Great Fissure"] = "大裂縫",
        ["The Great Fras Siabi"] = "弗拉斯·希亞比",
        ["The Great Masquerade"] = "潛藏者",
        ["The Great Moongraze Hunt"] = "牧月大獵殺",
        ["The Great Retribution"] = "巨大的懲罰",
        ["The Great Silver Deceiver"] = "白花花的銀子",
        ["The Greatest Race of Hunters"] = "最偉大的獵手",
        ["The Green Drake"] = "神廟中的綠龍",
        ["The Green Hills of Stranglethorn"] = "荊棘谷的青山",
        ["The Greenwarden"] = "綠色守衛者",
        ["The Grizzled Den"] = "灰色洞穴",
        ["The Guns of Northwatch"] = "北方城堡的火炮",
        ["The Hammer May Fall"] = "落錘之戰",
        ["The Hand of Gul'dan"] = "古爾丹火山",
        ["The Hand of Rastakhan"] = "拉斯塔哈之手",
        ["The Hand of the Righteous"] = "正義之手",
        ["The Harvester"] = "收割者",
        ["The Haunted Isle"] = "幽靈島",
        ["The Haunted Mills"] = "鬧鬼的磨坊",
        ["The Head of the Beast"] = "禽獸的首級",
        ["The Heart of Darkness"] = "黑暗之心",
        ["The Heart of the Mountain"] = "山脈之心",
        ["The Hermit"] = "隱士",
        ["The Hidden Chamber"] = "密室",
        ["The Hidden Key"] = "隱藏的鑰匙",
        ["The Hidden Niche"] = "密室",
        ["The High Wilderness"] = "高原荒野",
        ["The Hopeless Ones..."] = "絕望者……",
        ["The Horde Needs Firebloom!"] = "部落需要火焰花!",
        ["The Horde Needs Heavy Leather!"] = "部落需要重皮!",
        ["The Horde Needs Mithril Bars!"] = "部落需要秘銀錠!",
        ["The Horde Needs More Mageweave Bandages!"] = "部落需要更多魔紋布繃帶!",
        ["The Horde Needs More Mithril Bars!"] = "部落需要更多秘銀錠!",
        ["The Horde Needs More Peacebloom!"] = "部落需要更多寧神花!",
        ["The Horde Needs More Purple Lotus!"] = "部落需要更多紫蓮花!",
        ["The Horde Needs More Rugged Leather!"] = "部落需要更多硬甲皮!",
        ["The Horde Needs More Runecloth Bandages!"] = "部落需要更多符文布繃帶!",
        ["The Horde Needs More Spotted Yellowtail!"] = "部落需要更多斑點黃尾魚!",
        ["The Horde Needs More Thick Leather!"] = "部落需要更多厚皮!",
        ["The Horde Needs Peacebloom!"] = "部落需要寧神花!",
        ["The Horde Needs Purple Lotus!"] = "部落需要紫蓮花!",
        ["The Horde Needs Rugged Leather!"] = "部落需要硬甲皮!",
        ["The Horde Needs Runecloth Bandages!"] = "部落需要符文布繃帶!",
        ["The Horde Needs Spotted Yellowtail!"] = "部落需要斑點黃尾魚!",
        ["The Horde Needs Thick Leather!"] = "部落需要厚皮!",
        ["The Horde Needs Tin Bars!"] = "部落需要錫錠!",
        ["The Horde Needs Wool Bandages!"] = "部落需要絨線繃帶!",
        ["The Horn of the Beast"] = "巨獸瑪爾戈的角",
        ["The Horrors of Pollution"] = "恐獸的污染",
        ["The Hound-Master"] = "魔犬之主",
        ["The Howling Vale"] = "狼嚎谷",
        ["The Howling Wind"] = "哀嚎之風",
        ["The Hunt Begins"] = "開始狩獵",
        ["The Hunt Completed"] = "完成狩獵",
        ["The Hunt Continues"] = "繼續狩獵",
        ["The Hunter's Charm"] = "獵人符咒",
        ["The Hunter's Way"] = "獵人之道",
        ["The Ice Guard"] = "冰霜守衛者",
        ["The Ichor of Undeath"] = "亡靈腐液",
        ["The Impotent Leader"] = "無能的領導者",
        ["The Inconsolable Chieftain"] = "極為傷心的酋長",
        ["The Infernal Orb"] = "地獄火寶珠",
        ["The Infested Protectors"] = "被寄生的保衛者",
        ["The Instigator's Enchantment"] = "教唆者的附魔",
        ["The Ironforge Brigade Needs Explosives!"] = "鐵爐堡軍旅需要炸藥!",
        ["The Islander"] = "島民",
        ["The Isle of Dread!"] = "恐怖之島!",
        ["The Jasperlode Mine"] = "玉石礦坑",
        ["The Jeremiah Blues"] = "傑雷米亞的憂傷",
        ["The Jewel of Kajaro"] = "卡亞羅的珠寶",
        ["The Karnitol Shipwreck"] = "卡尼托的海難",
        ["The Kessel Run"] = "幫凱索的忙",
        ["The Key to Freedom"] = "自由的鑰匙",
        ["The Killing Fields"] = "清理荒野",
        ["The Knife Revealed"] = "奎恩提斯的技藝",
        ["The Kolkar of Desolace"] = "淒涼之地的科卡爾部族",
        ["The Kurken is Lurkin'"] = "潛伏的克爾肯",
        ["The Kurken's Hide"] = "克爾肯的皮",
        ["The Last Barov"] = "巴羅夫的繼承人",
        ["The Last Element"] = "最後的元素",
        ["The Left Piece of Lord Valthalak's Amulet"] = "瓦薩拉克領主護符的左半塊",
        ["The Legend of Stalvan"] = "斯塔文的傳說",
        ["The Legion Reborn"] = "燃燒軍團捲土重來",
        ["The Lexicon Demonica"] = "惡魔詞典",
        ["The Lich's Identity"] = "巫妖的身份",
        ["The Light and How To Swing It"] = "聖光之力",
        ["The Longbeards"] = "長鬚兄弟",
        ["The Lord of Blackrock"] = "黑石之王",
        ["The Lost Caravan"] = "走失的商隊",
        ["The Lost Chalice"] = "丟失的酒杯",
        ["The Lost Dwarves"] = "失蹤的矮人",
        ["The Lost Fragments"] = "遺失的卷軸碎片",
        ["The Lost Ingots"] = "丟失的鐵錠",
        ["The Lost Pages"] = "丟失的書頁",
        ["The Lost Pilot"] = "失蹤的駕駛員",
        ["The Lost Report"] = "遺失的報告",
        ["The Lost Supplies"] = "遺失的補給物資",
        ["The Lost Tablets of Mosh'aru"] = "失落的摩沙魯石板",
        ["The Lost Tablets of Will"] = "意志石板",
        ["The Lost Tools"] = "遺失的工具",
        ["The Love Potion"] = "愛情藥水",
        ["The Madness Within"] = "伊莫塔爾的瘋狂",
        ["The Mag'har"] = "瑪格哈",
        ["The Magister's Apprentice"] = "博學者的學徒",
        ["The Main Course!"] = "主菜上場!",
        ["The Mark of Quality"] = "品質的保證",
        ["The Mark of the Lightbringer"] = "光明使者的印記",
        ["The Master Planner"] = "規劃大師",
        ["The Master's Glaive"] = "主宰之劍",
        ["The Master's Grand Design?"] = "大師的偉大設計?",
        ["The Master's Touch"] = "大師之觸",
        ["The Mastermind"] = "幕後的黑手",
        ["The Matron Protectorate"] = "監護者",
        ["The Medallion of Faith"] = "信仰獎章",
        ["The Mighty U'cha"] = "強大的尤爾查",
        ["The Mills Overrun"] = "磨坊告急",
        ["The Mind's Eye"] = "心靈之眼",
        ["The Mindless Ones"] = "無腦的殭屍",
        ["The Minions of Culuthas"] = "卡露薩斯的爪牙",
        ["The Missing Courier"] = "失蹤的信差",
        ["The Missing Diplomat"] = "失蹤的使節",
        ["The Missing Expedition"] = "失蹤的遠征隊",
        ["The Missing Fisherman"] = "失蹤的漁夫",
        ["The Missing Merchant"] = "失蹤的商人",
        ["The Missing Orders"] = "遺失的命令",
        ["The Missing Scout"] = "調查暗影山脊",
        ["The Missing Shipment"] = "丟失的貨物",
        ["The Missing Survey Team"] = "失蹤的調查小組",
        ["The Missing War Party"] = "失蹤的戰友",
        ["The Mistress Revealed"] = "情婦曝光",
        ["The Mithril Kid"] = "秘銀小子",
        ["The Mithril Order"] = "秘銀會",
        ["The Molten Core"] = "熔火之心",
        ["The Monogrammed Sash"] = "刺著字母的束帶",
        ["The Morrow Stone"] = "晨光石",
        ["The Moss-twined Heart"] = "佈滿苔蘚的心臟",
        ["The Mystery of Morrowgrain"] = "晨光麥的秘密",
        ["The Name of the Beast"] = "惡魔之名",
        ["The Nesingwary Safari"] = "奈辛瓦里狩獵隊",
        ["The New Frontier"] = "新的邊疆",
        ["The New Springs"] = "新的泉水",
        ["The Newest Member of the Family"] = "新的生命",
        ["The Night Watch"] = "守夜人",
        ["The Northern Pylon"] = "北部水晶塔",
        ["The Ogre Threat"] = "巨魔威脅",
        ["The Ogres of Feralas"] = "菲拉斯的巨魔",
        ["The Old Ways"] = "古老的技藝",
        ["The Only Cure is More Green Glow"] = "更多的輻射塵!",
        ["The Only Prescription"] = "獨一無二的秘笈",
        ["The Only Song I Know..."] = "竭盡所能……",
        ["The Opening of the Dark Portal"] = "黑暗之門的開啟",
        ["The Orb of Soran'ruk"] = "索蘭魯克寶珠",
        ["The Orc Report"] = "獸人的報告",
        ["The Orebor Harborage"] = "奧雷伯爾港",
        ["The Orgrimmar Legion Needs Mojo!"] = "奧格瑪軍團需要魔精油!",
        ["The Origins of Smithing"] = "鍛造的起源",
        ["The Outcast's Plight"] = "流亡者的困境",
        ["The Pack Mistress"] = "座狼的首領",
        ["The Pariah's Instructions"] = "賤民的指引",
        ["The Party Never Ends"] = "夜夜狂歡",
        ["The Path of Anguish"] = "苦痛之路",
        ["The Path of Conquest"] = "征服之路",
        ["The Path of Glory"] = "光榮之路",
        ["The Path of the Adept"] = "高手之路",
        ["The Path of the Righteous"] = "正義之路",
        ["The People's Militia"] = "西部荒野人民軍",
        ["The Perfect Poison"] = "完美的毒藥",
        ["The Perfect Stout"] = "完美烈酒",
        ["The Plagued Coast"] = "感染瘟疫的海岸",
        ["The Platinum Discs"] = "白金圓盤",
        ["The Pledge of Secrecy"] = "保密協議",
        ["The Pools of Aggonar"] = "阿葛納爾之池",
        ["The Power to Destroy..."] = "毀滅之力",
        ["The Powers Below"] = "深淵之神",
        ["The Price of Shoes"] = "馬蹄鐵的價值",
        ["The Princess Saved?"] = "拯救公主?",
        ["The Princess Trapped"] = "受困的公主",
        ["The Princess's Surprise"] = "語出驚人的公主",
        ["The Principal Source"] = "毒水之源",
        ["The Prison's Bindings"] = "監牢之鏈",
        ["The Prison's Casing"] = "監牢之壁",
        ["The Prodigal Lich"] = "流浪的巫妖",
        ["The Prodigal Lich Returns"] = "巫妖歸順",
        ["The Prophecy of Akida"] = "阿契達的預言",
        ["The Prophecy of Mosh'aru"] = "摩沙魯的預言",
        ["The Prophecy of Velen"] = "費倫的預言",
        ["The Public Servant"] = "公僕",
        ["The Purest Water"] = "純淨之水",
        ["The Qiraji Conqueror"] = "其拉蟲人的征服者",
        ["The Ranger Lord's Behest"] = "遊俠之王的命令",
        ["The Ravaged Caravan"] = "被破壞的貨車",
        ["The Real Threat"] = "真正的威脅",
        ["The Reason for the Season"] = "冬幕節的意義",
        ["The Red Crystal"] = "紅色水晶",
        ["The Red Messenger"] = "十字軍信差",
        ["The Relics of Wakening"] = "喚醒聖物",
        ["The Remains of Trey Lightforge"] = "特雷·萊弗治的殘骸",
        ["The Reports"] = "森內爾的報告",
        ["The Rescue"] = "拯救行動",
        ["The Restless Souls"] = "永不安息的靈魂",
        ["The Rethban Gauntlet"] = "往返瑞斯班洞穴",
        ["The Right Piece of Lord Valthalak's Amulet"] = "瓦薩拉克領主護符的右半塊",
        ["The Ring of Blood: Brokentoe"] = "血色競技場:斷趾",
        ["The Ring of Blood: Rokdar the Sundered Lord"] = "血色競技場:『碎裂領主』洛克達",
        ["The Ring of Blood: Skra'gath"] = "血色競技場:史卡拉克斯",
        ["The Ring of Blood: The Blue Brothers"] = "血色競技場:憂鬱兄弟黨",
        ["The Ring of Blood: The Final Challenge"] = "血色競技場:最後的挑戰",
        ["The Ring of Blood: The Warmaul Champion"] = "血色競技場:戰槌勇士",
        ["The Ring of Mmmrrrggglll"] = "魔鉤的戒指",
        ["The Rise of the Machines"] = "機器的崛起",
        ["The Road to Darnassus"] = "達納蘇斯之路",
        ["The Road to Falcon Watch"] = "通往獵鷹哨站的路",
        ["The Rock Flayer Matriarch"] = "岩石鐮奪怪女王",
        ["The Rod of Lianthe"] = "利安瑟魔棒",
        ["The Root of All Evil"] = "萬惡根源",
        ["The Royal Rescue"] = "拯救公主",
        ["The Ruins of Burning Blade"] = "燃燒之劍廢墟",
        ["The Ruins of Kel'Theril"] = "凱斯利爾廢墟",
        ["The Ruins of Solarsal"] = "索蘭薩爾廢墟",
        ["The Ruins of Stardust"] = "星塵廢墟",
        ["The Rumormonger"] = "車手的傳聞",
        ["The Rune of Summoning"] = "召喚符文",
        ["The Runed Scroll"] = "符文卷軸",
        ["The Sacred Flame"] = "神聖之火",
        ["The Sad Truth"] = "悲傷的事實",
        ["The Sanctum of the Sun"] = "太陽聖所",
        ["The Savage Guard - Arcanum of Focus"] = "野蠻護衛-專注秘藥",
        ["The Savage Guard - Arcanum of Protection"] = "野蠻護衛-保護秘藥",
        ["The Savage Guard - Arcanum of Rapidity"] = "野蠻護衛-疾速秘藥",
        ["The Savior of Kalimdor"] = "卡林多的救星",
        ["The Scarlet Crusade"] = "血色十字軍",
        ["The Scent of Lar'korwi"] = "拉克維的氣味",
        ["The Scepter of Celebras"] = "塞雷布拉斯節杖",
        ["The Scorched Grove"] = "烈焰邊境",
        ["The Scourge Cauldrons"] = "瘟疫之鍋",
        ["The Scrimshank Redemption"] = "謝申克的救贖",
        ["The Scythe of Elune"] = "月神的鐮刀",
        ["The Search Continues"] = "繼續搜尋",
        ["The Second Course..."] = "第二個課題……",
        ["The Second Rebellion"] = "以彼之道還施彼身",
        ["The Second Sample"] = "第二個樣本",
        ["The Second Trial"] = "第二個試煉",
        ["The Second and Third Fragments"] = "第二和第三個碎片",
        ["The Seer's Relic"] = "先知的聖物",
        ["The Severed Head"] = "被斬下的頭顱",
        ["The Shade of Elura"] = "艾魯拉的陰影",
        ["The Shadow Guard"] = "暗影守護者",
        ["The Shadow Tomb"] = "暗影之墓",
        ["The Shadowmoon Shuffle"] = "影月谷的潛行",
        ["The Shadowy Figure"] = "模糊的人影",
        ["The Shadowy Search Continues"] = "繼續搜尋",
        ["The Sharpest Blades"] = "最鋒利的劍",
        ["The Shattered Hand"] = "破碎之手氏族",
        ["The Shattered Necklace"] = "破碎的項鍊",
        ["The Shattered Salute"] = "碎手軍禮",
        ["The Shieldsmith"] = "鑄盾師",
        ["The Shimmering Frond"] = "發光的樹葉",
        ["The Shrine of Dath'Remar"] = "達斯雷瑪神殿",
        ["The Sigil of Krasus"] = "卡薩斯符印",
        ["The Singing Crystals"] = "歌唱水晶",
        ["The Siren's Coral"] = "海妖的珊瑚",
        ["The Sketh'lon Wreckage"] = "史凱瑟隆殘骸",
        ["The Skettis Offensive"] = "司凱堤斯的攻擊",
        ["The Slaughtered Lamb"] = "已宰的羔羊",
        ["The Sleeper Has Awakened"] = "昏昏欲睡",
        ["The Sleeping Druid"] = "沉睡的德魯伊",
        ["The Smallest Creatures"] = "最小的動物",
        ["The Smoldering Ruins of Thaurissan"] = "索瑞森廢墟",
        ["The So-Called Mark of the Lightbringer"] = "所謂的光明使者的印記",
        ["The Softest Wings"] = "最柔軟的翅膀",
        ["The Soul Devices"] = "靈魂儀器",
        ["The Spearcrafter's Hammer"] = "製矛者之錘",
        ["The Spectral Chalice"] = "鬼靈之杯",
        ["The Spider God"] = "蜘蛛之神",
        ["The Spirit Polluted"] = "被污染的靈魂",
        ["The Spirits Have Voices"] = "靈魂會說話",
        ["The Spirits of Southwind"] = "南風村的靈魂",
        ["The Spirits of Stonetalon"] = "石爪之靈",
        ["The Sporelings' Plight"] = "孢子人的困境",
        ["The Sprouted Fronds"] = "發芽的樹葉",
        ["The Spy Revealed!"] = "找出內鬼!",
        ["The Stagnant Oasis"] = "死水綠洲",
        ["The Stave of Equinex"] = "艾奎尼克斯法杖",
        ["The Stockade Riots"] = "監獄暴動",
        ["The Stolen Journal"] = "被竊取的日記",
        ["The Stolen Tome"] = "失竊的典籍",
        ["The Stone"] = "虛空石",
        ["The Stone Circle"] = "石環",
        ["The Stone Watcher"] = "石頭衛士",
        ["The Stone of the Tides"] = "海潮之石",
        ["The Stones That Bind Us"] = "禁錮我們的石頭",
        ["The Stones of Vekh'nir"] = "維克尼爾之石",
        ["The Strength of Corruption"] = "腐化的力量",
        ["The Summoning"] = "召喚",
        ["The Summoning Chamber"] = "召喚的密室",
        ["The Sun Gate"] = "太陽之門",
        ["The Sunfury Garrison"] = "日怒部隊",
        ["The Sunken Temple"] = "沉沒的神廟",
        ["The Super Snapper FX"] = "超級攝影器FX",
        ["The Swamp Talker"] = "沼澤空談者",
        ["The Swarm Grows"] = "瘋狂的蟲群",
        ["The Tear of the Moons"] = "眾月之淚",
        ["The Tempest Key"] = "風暴之鑰",
        ["The Temple of Atal'Hakkar"] = "阿塔哈卡神廟",
        ["The Temple of Telhamat"] = "特爾哈曼神廟",
        ["The Terror of Marshlight Lake"] = "恐怖的沼澤光之湖",
        ["The Test of Righteousness"] = "正義試煉",
        ["The Thandol Span"] = "薩多爾大橋",
        ["The Theramore Docks"] = "塞拉摩碼頭",
        ["The Third Fleet"] = "第三艦隊",
        ["The Throne of the Elements"] = "元素王座",
        ["The Thunderspike"] = "雷鳴之矛",
        ["The Tome of Divinity"] = "聖潔之書",
        ["The Tome of Valor"] = "勇氣之書",
        ["The Torch of Retribution"] = "懲戒火炬",
        ["The Tortured Earth"] = "痛苦的大地",
        ["The Totem of Infliction"] = "懲罰圖騰",
        ["The Totem of Kar'dash"] = "卡達許圖騰",
        ["The Totems of My Enemy"] = "敵人的圖騰",
        ["The Touch of Zanzil"] = "贊吉爾之觸",
        ["The Tower of Althalaxx"] = "奧薩拉克斯之塔",
        ["The Traitor's Destruction"] = "叛國者的毀滅",
        ["The Traitor's Shadow"] = "背叛者的陰影",
        ["The Trappings of a Vindicator"] = "復仇者的服飾",
        ["The Treasure of the Shen'dralar"] = "辛德拉的寶藏",
        ["The Trogg Threat"] = "穴居人的威脅",
        ["The Troll Cave"] = "食人妖洞穴",
        ["The Troll Witchdoctor"] = "食人妖巫醫",
        ["The True Masters"] = "真正的主人",
        ["The Truth Comes Crashing Down"] = "可怕的真相",
        ["The Truth Unorbed"] = "未知的真相",
        ["The Twilight Camp"] = "暮光之錘的營地",
        ["The Twilight Lexicon"] = "暮光詞典",
        ["The Twilight Mystery"] = "暮光的秘密",
        ["The Twin Clefts of Nagrand"] = "納葛蘭的雙子斷崖",
        ["The Twin Ziggurats"] = "雙子通靈塔",
        ["The Ultimate Bloodsport"] = "最後的浴血之戰",
        ["The Ultimate Deception"] = "最後的詭計",
        ["The Umbrafen Tribe"] = "昂布拉凡部族",
        ["The Undermarket"] = "黑市交易",
        ["The Underneath"] = "地底之下",
        ["The Unending Invasion"] = "無止盡的侵略",
        ["The Unmarred Vision of Voodress"] = "完美巫毒幻象",
        ["The Unsent Letter"] = "未寄出的信",
        ["The Unwritten Prophecy"] = "未寫下的預言",
        ["The Vengeful Harbinger"] = "復仇先驅",
        ["The Venture Co."] = "風險投資公司",
        ["The Videre Elixir"] = "視靈藥劑",
        ["The Vile Reef"] = "暗礁海",
        ["The Warchief's Mandate"] = "大酋長的命令",
        ["The Warden's Cage"] = "典獄官監牢",
        ["The Warlord's Hideout"] = "督軍的藏身之處",
        ["The Warp Rifts"] = "扭曲裂縫",
        ["The Warsong Reports"] = "戰歌報告",
        ["The Way of the Weaponsmith"] = "武器鑄造師之道",
        ["The Way to Auberdine"] = "去奧伯丁的路",
        ["The Wayward Apprentice"] = "遊蕩者學徒",
        ["The Weathered Grave"] = "飽經風霜的墓碑",
        ["The Weaver"] = "法師的頭領",
        ["The Western Pylon"] = "西部水晶塔",
        ["The Wildlife Suffers Too"] = "大自然的苦楚",
        ["The Will of the Warchief"] = "酋長的希望",
        ["The Windwatcher"] = "捕風者",
        ["The Woodland Protector"] = "森林保衛者",
        ["The Woodpaw Gnolls"] = "木爪豺狼人",
        ["The Work of Grimand Elmore"] = "格瑞曼德·艾爾默",
        ["The World At Your Feet"] = "世界在你腳下",
        ["The World's Largest Gnome!"] = "世界上最大的地精!",
        ["The Writhing Deep"] = "痛苦深淵",
        ["The Wrong Stuff"] = "奇怪的材料",
        ["The Zapthrottle Mote Extractor!"] = "快速節流微粒吸取器!",
        ["The Zhevra"] = "斑馬的威脅",
        ["The Zoram Strand"] = "佐拉姆海岸",
        ["Theldurin the Lost"] = "『迷失者』塞爾杜林",
        ["Thelsamar Blood Sausages"] = "塞爾薩瑪血腸",
        ["Theocritus' Retrieval"] = "塞歐克瑞圖斯的墜飾",
        ["Theramore Spies"] = "塞拉摩間諜",
        ["There Can Be Only One Response"] = "唯一的回應",
        ["There Is No Hope"] = "沒有希望了",
        ["There's No Explanation for Fashion"] = "流行沒有理由",
        ["Therylune's Escape"] = "護送瑟瑞露尼",
        ["Therzok"] = "瑟祖克",
        ["They Call Him Smiling Jim"] = "微笑的吉姆",
        ["They Call Me \"The Rooster\""] = "他們叫我「鬥士」",
        ["They Stole Me Hookah and Me Brews!"] = "他們偷走我的水煙筒和酒!",
        ["They're Alive! Maybe..."] = "他們還活著!或許吧……",
        ["Thick Hydra Scales"] = "厚多頭蛇鱗片",
        ["Thin the Flock"] = "抑制阿拉卡",
        ["Thinning the Ranks"] = "削弱軍隊",
        ["Thirst Unending"] = "止不了的渴",
        ["This Is Going to Be Hard"] = "不祥的感覺",
        ["Thistleshrub Valley"] = "灌木谷",
        ["Thorium Widget"] = "瑟銀零件",
        ["Those Blasted Troggs!"] = "該死的石齶怪!",
        ["Threat From the Sea"] = "海中的威脅",
        ["Threat of the Winterfall"] = "冬泉熊怪的威脅",
        ["Three Kings of Flame"] = "烈焰三巨頭",
        ["Through the Dark Portal"] = "通過黑暗之門",
        ["Thule Ravenclaw"] = "圖勒·鴉爪",
        ["Thun'grim Firegaze"] = "索恩格瑞姆·火眼",
        ["Thunderaan the Windseeker"] = "逐風者桑德蘭",
        ["Thunderbrew Lager"] = "雷霆啤酒",
        ["Thunderhorn Cleansing"] = "淨化雷角之井",
        ["Thunderhorn Totem"] = "雷角圖騰",
        ["Thunderlord Clan Artifacts"] = "雷霆王氏族手工藝品",
        ["Thundris Windweaver"] = "桑迪斯·織風",
        ["Thwart the Dark Conclave"] = "阻礙黑暗議會",
        ["Thwarting Kolkar Aggression"] = "科卡爾半人馬的進攻",
        ["Tiara of the Deep"] = "深淵冠冕",
        ["Tiara of the Oracle"] = "神諭者的冠冕",
        ["Tiger Mastery"] = "獵虎大師",
        ["Timber Worg Tails"] = "灰座狼尾巴",
        ["Timberling Seeds"] = "樹精的種子",
        ["Timberling Sprouts"] = "樹精的新芽",
        ["Time To Strike"] = "進攻的時機",
        ["Tinkee Steamboil"] = "丁奇·斯迪波爾",
        ["To Catch A Thistlehead"] = "血薊花的陷阱",
        ["To Gadgetzan You Go!"] = "加基森之旅!",
        ["To Ironforge for Yagyin's Digest"] = "遠赴鐵爐堡",
        ["To Kill With Purpose"] = "殺戮的理由",
        ["To Legion Hold"] = "前往軍團要塞",
        ["To Meet Mother Kashur"] = "與卡修爾母親會面",
        ["To Netherwing Ledge!"] = "前往虛空之翼岩架!",
        ["To Serve Kum'isha"] = "為庫米沙效力",
        ["To Show Due Judgment"] = "聖騎士的審判",
        ["To Steal From Thieves"] = "科娜塔一家",
        ["To The Bulwark"] = "前進亡靈壁壘",
        ["To The Hinterlands"] = "前往辛特蘭",
        ["To Winterspring!"] = "前往冬泉谷!",
        ["To the Stormspire"] = "到風暴之尖",
        ["To the Top"] = "登高",
        ["To the Undercity for Yagyin's Digest"] = "遠赴幽暗城",
        ["Tomb of the Lightbringer"] = "光明使者之墓",
        ["Tomber's Supplies"] = "土柏的貨物",
        ["Tome of Divinity"] = "聖潔之書",
        ["Tome of the Cabal"] = "陰謀之書",
        ["Too Many Mouths to Feed"] = "僧多粥少",
        ["Tooga's Quest"] = "圖加的任務",
        ["Tools for Steelgrill"] = "貝爾丁的工具",
        ["Tools of the Highborne"] = "高等精靈的工具",
        ["Tools of the Trade"] = "交易工具",
        ["Torching Sunfury Hold"] = "燒毀日怒要塞",
        ["Torek's Assault"] = "托雷克的突襲",
        ["Torgos!"] = "托茍斯!",
        ["Tormented By the Past"] = "記憶的折磨",
        ["Tormus Deepforge"] = "托姆斯·深爐",
        ["Torn Bear Pelts"] = "破損的熊皮",
        ["Torwa Pathfinder"] = "托爾瓦·尋路者",
        ["Totem of Coo"] = "庫的圖騰",
        ["Totem of Tikti"] = "堤克悌的圖騰",
        ["Totem of Vark"] = "瓦克的圖騰",
        ["Totem of Yor"] = "優兒的圖騰",
        ["Touch of Weakness"] = "虛弱之觸",
        ["Towers and Bunkers"] = "哨塔和碉堡",
        ["Toxic Horrors"] = "劇毒之水",
        ["Toxic Test"] = "毒性測試",
        ["Tracking Down the Culprits"] = "追蹤罪犯",
        ["Training the Beast"] = "訓練野獸",
        ["Traitor to the Bloodsail"] = "血帆的叛徒",
        ["Tramping Paws"] = "踐踏之爪",
        ["Trampled Under Foot"] = "踩在腳底下",
        ["Tran'rek"] = "特蘭雷克",
        ["Translate Abercrombie's Note"] = "翻譯亞伯克隆比的信",
        ["Translating the Journal"] = "翻譯日記",
        ["Translating the Ledger"] = "翻譯龍語",
        ["Translation to Ello"] = "翻譯好的信件",
        ["Translations..."] = "翻譯……",
        ["Trapping the Light Fantastic"] = "捕捉神奇的光球",
        ["Travel to Azure Watch"] = "前往藍色守望",
        ["Travel to Darkshire"] = "前往夜色鎮",
        ["Treant Muisek"] = "樹人靈魂精華",
        ["Treats for Greatfather Winter"] = "招待冬天爺爺",
        ["Tree's Company"] = "樹的偽裝",
        ["Treebole Must Know"] = "樹老長者必須知道",
        ["Trek to Ashenvale"] = "梣谷之旅",
        ["Trelane's Defenses"] = "特雷萊恩的防禦",
        ["Tremors of the Earth"] = "大地的震顫",
        ["Triage"] = "救死扶傷",
        ["Trial and Error"] = "錯誤的試驗",
        ["Trial at the Field of Giants"] = "巨人曠野的試煉",
        ["Triangulation Point One"] = "三角測量點之一",
        ["Triangulation Point Two"] = "三角測量點之二",
        ["Tribal Leatherworking"] = "部族製皮",
        ["Tribes at War"] = "野豬人的內戰",
        ["Trinkets..."] = "打開箱子…",
        ["Trol'kalar"] = "托卡拉爾",
        ["Troll Charm"] = "食人妖符咒",
        ["Troll Juju"] = "食人妖護符",
        ["Troll Necklace Bounty"] = "食人妖部族項鍊",
        ["Troll Temper"] = "食人妖調和劑",
        ["Troll Witchery"] = "食人妖巫術",
        ["Trollbane"] = "食人妖之敵",
        ["Trollbane is Looking for You"] = "托爾貝恩正在找你",
        ["Trolls of a Feather"] = "巨魔的羽毛",
        ["Trouble In Darkshore?"] = "黑海岸的麻煩事",
        ["Trouble at Auchindoun"] = "奧齊頓的麻煩",
        ["Trouble at the Docks"] = "港口的麻煩",
        ["Trouble at the Underlight Mines"] = "光底礦坑的麻煩",
        ["Trouble in Winterspring!"] = "冬泉谷的麻煩!",
        ["Trouble in the Deeps"] = "幫助耶努薩克雷",
        ["Troubled Spirits of Kel'Theril"] = "凱斯利爾的怨靈",
        ["Troublesome Distractions"] = "討人厭的分心",
        ["True Believers"] = "真實信仰者",
        ["Trueflight Arrows"] = "真禽之箭",
        ["Truth or Fiction"] = "是真是假",
        ["Tumors"] = "青苔之瘤",
        ["Tundra MacGrann's Stolen Stash"] = "馬克格拉恩的乾肉",
        ["Turning Point"] = "轉捩點",
        ["Turning the Tide"] = "扭轉情勢",
        ["Twilight Battle Orders"] = "暮光作戰命令",
        ["Twilight Falls"] = "暮光之錘的末日",
        ["Twilight Geolords"] = "暮光地領主",
        ["Twilight Marauders"] = "暮光掠奪者",
        ["Twilight Ring of Lordship"] = "暮光徽記之戒",
        ["Twilight of the Dawn Runner"] = "黎明行者的微光",
        ["Twisted Evils"] = "扭曲的邪惡",
        ["Twisted Hatred"] = "扭曲的仇恨",
        ["Two Halves Become One"] = "合二為一",
        ["Tyrande and Remulos"] = "泰蘭妲與雷姆洛斯",
        ["Ula'elek and the Brutal Gauntlets"] = "尤拉萊克和野蠻護手",
        ["Ulag the Cleaver"] = "『斬擊者』奧拉格",
        ["Ulathek the Traitor"] = "背叛者烏拉泰克",
        ["Uldaman Reagent Run"] = "奧達曼的蘑菇",
        ["Umbrafen Eel Filets"] = "昂布拉凡鰻魚片",
        ["Un'Goro Soil"] = "安戈洛的泥土",
        ["Un-Life's Little Annoyances"] = "討厭的蝙蝠",
        ["Uncatalogued Species"] = "未編目的品種",
        ["Unclaimed Baggage"] = "無人的行李",
        ["Uncle Carlin"] = "卡林叔叔",
        ["Uncovering the Past"] = "發現歷史",
        ["Undamaged Venom Sac"] = "完好無損的毒囊",
        ["Under Whose Orders?"] = "幕後策劃者",
        ["Under the Chitin Was..."] = "殼中的東西…",
        ["Underbelly Scales"] = "雛龍的鱗片",
        ["Undercutting the Competition"] = "暗殺競爭對手",
        ["Underground Assault"] = "地底突襲",
        ["Underlight Ore Samples"] = "光底礦物樣本",
        ["Understanding the Mok'Nathal"] = "了解摩克納薩爾",
        ["Underworld Loam"] = "地獄土壤",
        ["Unexpected Results"] = "意外的結果",
        ["Unfinished Business"] = "未完成的任務",
        ["Unfortunate Measures"] = "不幸的手段",
        ["Uniting the Shattered Amulet"] = "收集破碎的護符",
        ["Unlocking the Compendium"] = "開啟手冊",
        ["Unruly Neighbors"] = "難搞的鄰居",
        ["Unstable Mana Crystals"] = "不穩定法力水晶",
        ["Until Death Do Us Part"] = "直到死亡把我們分離",
        ["Up to Snuff"] = "鼻煙",
        ["Update for Sentinel Thenysil"] = "向塞恩希爾報告",
        ["Ur's Treatise on Shadow Magic"] = "烏爾的暗影魔法研究論文",
        ["Urgent Delivery"] = "緊急送件",
        ["Urgent Delivery!"] = "緊急送件!",
        ["Urok Doomhowl"] = "烏洛克",
        ["Ursal the Mauler"] = "『大槌』烏薩爾",
        ["Ursangous's Paw"] = "烏薩苟斯的爪子",
        ["Ursius of the Shardtooth"] = "碎齒熊尤西烏斯",
        ["Us or Them"] = "不是你死就是我活",
        ["Vahlarriel's Search"] = "瓦拉里爾的搜尋",
        ["Valik"] = "僕從瓦里克",
        ["Vanquish the Betrayers"] = "背信棄義的人類",
        ["Vanquishing Aquantion"] = "消滅海之平衡",
        ["Veil Lithic: Preemptive Strike"] = "迷霧里斯克:先發制人的攻擊",
        ["Veil Rhaze: Unliving Evil"] = "迷霧瑞漢茲:邪惡靈魂",
        ["Veil Shalas: Signal Fires"] = "迷霧撒拉斯:火源信號",
        ["Veil Skith: Darkstone of Terokk"] = "迷霧斯奇司:泰洛克黑石",
        ["Vejrek"] = "維吉雷克",
        ["Velinde Starsong"] = "維琳德·星歌",
        ["Velinde's Effects"] = "維琳德的日記",
        ["Velora Nitely and the Brutal Legguards"] = "維羅拉·奈特雷和野蠻腿甲",
        ["Vengeance on the Northspring"] = "對鷹身人的復仇",
        ["Venom Bottles"] = "毒液瓶",
        ["Venom to the Undercity"] = "送往幽暗城的毒藥",
        ["Venture Company Mining"] = "風險投資公司",
        ["Verdant Sigil"] = "綠色符記",
        ["Verifying the Corruption"] = "驗證腐蝕",
        ["Verog the Dervish"] = "狂熱的維羅戈",
        ["Vessels of Power"] = "能量容器",
        ["Vestments of the Wolf Spirit"] = "狼魂法衣",
        ["Veteran Uzzek"] = "老兵猶塞克",
        ["Veteran's Battlegear"] = "精兵的裝備",
        ["Vibrant Plumes"] = "鮮豔的羽毛",
        ["Victims of Corruption"] = "腐敗的受害者",
        ["Victory for the Alliance"] = "聯盟的勝利",
        ["Victory for the Horde"] = "部落的勝利",
        ["Vile Familiars"] = "邪靈劣魔",
        ["Vile Idolatry"] = "邪惡的塑像",
        ["Vile Plans"] = "邪惡的計畫",
        ["Vile Satyr! Dryads in Danger!"] = "邪惡的薩特!身陷危險的林精!",
        ["Vilebranch Hooligans"] = "邪枝竊賊",
        ["Villains of Darrowshire"] = "達隆郡的惡魔",
        ["Vindicator Aldar"] = "復仇者艾德",
        ["Vindicator's Rest"] = "復仇者之陵",
        ["Vision Guide"] = "幻象導覽",
        ["Vision of the Dead"] = "死者的視界",
        ["Visit the Herbalist"] = "拜訪草藥師",
        ["Vital Intelligence"] = "重要情報",
        ["Vital Supplies"] = "重要的補給",
        ["Vivian Lagrave"] = "薇薇安·拉格雷",
        ["Vivian Lagrave and the Darkstone Tablet"] = "薇薇安·拉格雷和黑暗石板",
        ["Void Ridge"] = "虛空山脈",
        ["Voidwalkers Gone Wild"] = "野放的虛空行者",
        ["Volatile Mutations"] = "暴躁突變者",
        ["Volcanic Activity"] = "火山的活動",
        ["Volunteer's Battlegear"] = "志願兵的裝備",
        ["Voodoo Dues"] = "討債行動",
        ["Voodoo Feathers"] = "巫毒羽毛",
        ["Voren'thal's Visions"] = "沃藍索的幻境",
        ["Vorlus Vilehoof"] = "沃魯斯·邪蹄",
        ["Vorrel's Revenge"] = "沃瑞爾的復仇",
        ["Vorsha the Lasher"] = "『鞭笞者』沃爾沙",
        ["Vulture's Vigor"] = "禿鷹的活力",
        ["Vyletongue Corruption"] = "維利塔恩的污染",
        ["Vyral the Vile"] = "卑鄙的維拉爾",
        ["Vyrin's Revenge"] = "維林的報復",
        ["WANTED: Andre Firebeard"] = "通緝:安德雷·火鬍",
        ["WANTED: Baron Longshore"] = "通緝:巴隆·朗紹爾",
        ["WANTED: Baron Vardus"] = "通緝:瓦杜斯男爵",
        ["WANTED: Boss Grog'ak"] = "懸賞:葛洛卡老大",
        ["WANTED: Caliph Scorpidsting"] = "通緝:卡利夫·斯科比斯汀",
        ["WANTED: Chok'sul"] = "通緝令:卓克蘇爾",
        ["WANTED: Deathclaw"] = "通緝:死亡之爪",
        ["WANTED: Murkdeep!"] = "通緝:莫克迪普!",
        ["WANTED: Overseer Maltorius"] = "懸賞:工頭瑪托留斯",
        ["WANTED: Syndicate Personnel"] = "通緝:辛迪加成員",
        ["Wait for Sirra to Finish"] = "等待希拉完工",
        ["Waking Legends"] = "喚醒傳說",
        ["Wand over Fist"] = "特雷萊恩的符咒魔杖",
        ["Wand to Bethor"] = "給比索的魔杖",
        ["Wandering Shay"] = "迷路的沙恩",
        ["Wanted - Arnak Grimtotem"] = "通緝:阿納克·恐怖圖騰",
        ["Wanted! Marez Cowl"] = "通緝:瑪雷茲·考爾",
        ["Wanted! Otto and Falconcrest"] = "通緝:奧圖和法庫雷斯特",
        ["Wanted: Annihilator Servo!"] = "懸賞:殲滅者伺服電動機!",
        ["Wanted: Blacktalon the Savage"] = "懸賞:『野蠻者』黑爪",
        ["Wanted: Bonelashers Dead!"] = "懸賞:鞭骨者的死亡!",
        ["Wanted: Chieftain Mummaki"] = "懸賞:姆瑪奇酋長",
        ["Wanted: DWARVES!"] = "通緝:矮人!",
        ["Wanted: Durn the Hungerer"] = "懸賞:『飢餓者』唐恩",
        ["Wanted: Gath'Ilzogg"] = "通緝:加塞爾佐格",
        ["Wanted: Giselda the Crone"] = "懸賞:『老巫婆』吉絲達",
        ["Wanted: Knucklerot and Luzran"] = "懸賞:納克羅和路斯萊恩",
        ["Wanted: Lieutenant Fangore"] = "通緝:范高雷中尉",
        ["Wanted: Maggot Eye"] = "懸賞:蛆眼",
        ["Wanted: Thaelis the Hungerer"] = "通緝:『飢餓者』泰利斯",
        ["Wanted: Vile Priestess Hexx and Her Minions"] = "通緝:邪惡祭司海克斯和她的爪牙",
        ["Wanted: Worg Master Kruush"] = "懸賞告示:座狼大師科洛斯",
        ["Wanted: Zorbo the Advisor"] = "懸賞:『諫言者』索爾波",
        ["Wanted: \"Hogger\""] = "通緝:霍格",
        ["War Banners"] = "龍喉戰旗",
        ["War at Sea"] = "海上之戰",
        ["War on Deatholme"] = "死亡之域戰爭",
        ["War on the Shadowsworn"] = "魔誓者之戰",
        ["War on the Warmaul"] = "戰槌之戰",
        ["War on the Woodpaw"] = "與豺狼人開戰",
        ["Warden Hamoot"] = "守望者漢姆特",
        ["Warlock Training"] = "術士訓練",
        ["Warlord Krellian"] = "督軍克雷利安",
        ["Warlord Sriss'tiz"] = "督軍司瑞史提斯",
        ["Warlord of the Bleeding Hollow"] = "血之谷的督軍",
        ["Warlord's Command"] = "高圖斯的命令",
        ["Warn Area 52!"] = "警告52區!",
        ["Warn Your People"] = "警告你的族人",
        ["Warning Fairbreeze Village"] = "警告晴風村",
        ["Warning the Cenarion Circle"] = "警告塞納里奧議會",
        ["Warp-Raider Nesaad"] = "扭曲騎士尼薩德",
        ["Warrior Kinship"] = "戰士的血脈",
        ["Warrior Training"] = "戰士訓練",
        ["Warsong Outrider Update"] = "戰歌偵察騎兵的報告",
        ["Warsong Runner Update"] = "戰歌信差的報告",
        ["Warsong Saw Blades"] = "戰歌鋸刃",
        ["Warsong Scout Update"] = "戰歌斥候報告",
        ["Warsong Supplies"] = "戰歌氏族的補給品",
        ["Washed Ashore"] = "擱淺的巨獸",
        ["Washte Pawne"] = "瓦希塔帕恩",
        ["Wasteland"] = "荒地",
        ["Wastewander Justice"] = "廢土的公正",
        ["Watcher Leesa'oh"] = "看守者里薩歐",
        ["Water Elementals"] = "水元素",
        ["Water Pouch Bounty"] = "收集水袋",
        ["Waters of Xavian"] = "薩維亞之水",
        ["Weaken the Ramparts"] = "削弱防禦",
        ["Weapons of Choice"] = "選擇武器",
        ["Weapons of Elunite"] = "月神武器",
        ["Weapons of Spirit"] = "靈魂武器",
        ["Webwood Egg"] = "樹林蜘蛛的卵",
        ["Webwood Venom"] = "樹林蜘蛛的毒囊",
        ["Welcome to the Jungle"] = "歡迎來到叢林",
        ["Welcome!"] = "羽月將軍的歡迎",
        ["Welcoming the Wolf Spirit"] = "歡迎狼魂",
        ["Well of Corruption"] = "腐化之井",
        ["Wenikee Boltbucket"] = "維妮·布特巴克",
        ["Westbrook Garrison Needs Help!"] = "西泉要塞",
        ["Westfall Stew"] = "西部荒野燉肉",
        ["Wharfmaster Dizzywig"] = "碼頭管理員迪茲維格",
        ["What Are These Things?"] = "這些是什麼東西?",
        ["What Argus Means to Me"] = "阿格斯對我的意義",
        ["What Book? I Don't See Any Book."] = "什麼書?我沒看到有什麼書啊。",
        ["What Comes Around..."] = "伸張正義",
        ["What Happens in Terokkar Stays in Terokkar"] = "把泰洛卡的事留在泰洛卡",
        ["What Is Going On?"] = "出了什麼事?",
        ["What Must Be Done..."] = "必要手段……",
        ["What Niby Commands"] = "尼比的助手",
        ["What Strange Creatures..."] = "奇怪的生物……",
        ["What Tomorrow Brings"] = "明天的希望",
        ["What We Don't Know..."] = "我們不知道的事……",
        ["What We Know..."] = "我們所知道的事……",
        ["What the Flux?"] = "絕密配方!",
        ["What the Soul Sees"] = "靈魂看見的",
        ["What the Wind Carries"] = "風吹來的消息",
        ["What's Wrong at Cenarion Thicket?"] = "塞納里奧灌木林發生了什麼事?",
        ["Wheel of the Black March"] = "黑暗戰車之輪",
        ["Whelps of the Wyrmcult"] = "卡特火龍的幼獸",
        ["When Nature Goes Too Far"] = "自然過頭時",
        ["When Spirits Speak"] = "當靈魂們說話時",
        ["When This Mine's a-Rockin'"] = "當這個礦坑在震動",
        ["When Worlds Collide..."] = "當世界衝突時……",
        ["When the Cows Come Home"] = "母牛返家",
        ["Where Did Those Darn Gnomes Go?"] = "這些該死的地精跑去哪裡了?",
        ["Where's Wyllithen?"] = "威利坦在哪裡?",
        ["Whirlwind Weapon"] = "旋風武器",
        ["Whirring Bronze Gizmo"] = "高速青銅齒輪",
        ["Whiskey Slim's Lost Grog"] = "威士卡斯利姆的酒",
        ["Whispers of the Raven God"] = "烏鴉神的秘密預言",
        ["Whispers on the Wind"] = "風中低語",
        ["Whitebark's Memory"] = "白吼的記憶",
        ["Who Are They?"] = "他們是誰?",
        ["Wild Guardians"] = "冬泉谷的梟獸",
        ["Wild Hearts"] = "荒野之心",
        ["Wild Leather Armor"] = "蠻皮護甲",
        ["Wild Leather Boots"] = "蠻皮戰靴",
        ["Wild Leather Helmet"] = "蠻皮盔帽",
        ["Wild Leather Leggings"] = "蠻皮護腿",
        ["Wild Leather Shoulders"] = "蠻皮護肩",
        ["Wild Leather Vest"] = "蠻皮外衣",
        ["Wildeyes"] = "戈瑟奇·邪眼",
        ["Wildkin E'ko"] = "梟獸魂精",
        ["Wildkin of Elune"] = "伊露恩的梟獸",
        ["Wildmane Cleansing"] = "淨化蠻鬃之井",
        ["Wildmane Totem"] = "蠻鬃圖騰",
        ["Williden's Journal"] = "威利德的日記",
        ["Willix the Importer"] = "進口商威利克斯",
        ["Wind Rider"] = "雙足飛龍",
        ["Wind Trader Lathrai"] = "風之貿易者拉斯蕊",
        ["Windows to the Source"] = "源頭的窗口",
        ["Windroc Mastery"] = "風翼專精",
        ["Windrunner Village"] = "風行者村",
        ["Winds in the Desert"] = "沙漠之風",
        ["Wine Shop Advert"] = "酒店的廣告",
        ["Wing Commander Gryphongar"] = "空軍指揮葛萊弗卡爾",
        ["Winter's Presents"] = "冬天的禮物",
        ["Winterfall Activity"] = "冬泉熊怪的活動",
        ["Winterfall E'ko"] = "寒水魂精",
        ["Winterfall Firewater"] = "冬泉火水",
        ["Winterfall Intrusion"] = "冬泉熊怪的侵擾",
        ["Winterfall Ritual Totem"] = "冬泉儀祭圖騰",
        ["Winterfall Runners"] = "冬泉信差",
        ["Winterhoof Cleansing"] = "淨化冰蹄之井",
        ["Wisdom of Agamaggan"] = "阿迦瑪甘的智慧",
        ["Witherbark Cages"] = "枯木食人妖的牢籠",
        ["Withered Basidium"] = "枯萎的孢子臺",
        ["Withered Flesh"] = "枯萎的肉體",
        ["Wolves Across the Border"] = "森林中的狼群",
        ["Wolves at Our Heels"] = "惡狼成群",
        ["Woodpaw Investigation"] = "調查木爪嶺",
        ["Word from Azure Watch"] = "藍色守望的字條",
        ["Word from the Spire"] = "塔內的消息",
        ["Words of the High Chief"] = "熊怪酋長的話",
        ["Worgen in the Woods"] = "森林裡的狼人",
        ["Worth Its Weight in Gold"] = "證明實力",
        ["Wounded Ancients"] = "受傷的古樹",
        ["Wrath of the Blue Flight"] = "藍龍之怒",
        ["Wrenix of Ratchet"] = "棘齒城的維尼克斯",
        ["Wretched Ringleader"] = "鄙惡者頭目",
        ["Writ of Safe Passage"] = "安全之路令狀",
        ["Writhing Haunt Cauldron"] = "嚎哭鬼屋的瘟疫之鍋",
        ["Wyrmskull Watcher"] = "龍骨看守者",
        ["Xorothian Stardust"] = "克索諾斯星塵",
        ["Xylem's Payment to Jediga"] = "克希雷姆的報酬",
        ["Yorus Barleybrew"] = "猶魯斯·麥酒",
        ["You Have Served Us Well"] = "幹得好",
        ["You Survived!"] = "你活下來了!",
        ["You Too Good."] = "你真棒!",
        ["You're Fired!"] = "你被開除了!",
        ["You're Hired!"] = "你被雇用了!",
        ["You're a Mean One..."] = "天寒地凍",
        ["Young Crocolisk Skins"] = "小鱷魚皮",
        ["Young Lovers"] = "年輕的戀人",
        ["Your Fortune Awaits You..."] = "財富等著你……",
        ["Your Place In The World"] = "起點",
        ["Ysera's Tears"] = "伊瑟拉的眼淚",
        ["Yuka Screwspigot"] = "尤卡·斯庫比格特",
        ["Zaeldarr the Outcast"] = "『流亡者』塞達爾",
        ["Zalazane"] = "札拉贊恩",
        ["Zamek's Distraction"] = "札米克的困擾",
        ["Zandalarian Shadow Mastery Talisman"] = "贊達拉暗影大師墜飾",
        ["Zando'zan"] = "贊杜沙",
        ["Zanzil's Mixture and a Fool's Stout"] = "贊吉爾的藥劑和蠢人酒",
        ["Zanzil's Secret"] = "贊吉爾的秘密",
        ["Zapped Giants"] = "被縮小的巨人",
        ["Zapper Fuel"] = "除草器的燃料",
        ["Zenn's Bidding"] = "賽恩的要求",
        ["Zeth'Gor Must Burn!"] = "薩斯葛爾必須被燒毀!!",
        ["Zinge's Delivery"] = "給金格的貨物",
        ["Ziz Fizziks"] = "菲茲克斯",
        ["Zombie Juice"] = "殭屍汁",
        ["Zukk'ash Infestation"] = "祖卡什的入侵",
        ["Zukk'ash Report"] = "祖卡什報告",
        ["Zul'Marosh"] = "祖瑪羅什",
        ["Zuluhed the Whacked"] = "『疲憊者』祖魯希德",
        ["\"Pretty Boy\" Duncan"] = "『漂亮男孩』鄧肯",
        ["rAnS0m"] = "贖金",
} end)
-- Translater: GriffonHeart (updater: StingerSoft)
BabbleQuest:RegisterTranslations("ruRU", function() return {
    -- Quest names (3808)
        ["... and Bugs"] = "И жуки...",
        ["... and a Batch of Ooze"] = "...и образцы слизнюков",
        ["...and a Time for Action"] = "...и время действовать",
        ["10 Tickets - Last Month's Mutton"] = "10 билетов - окорок прошлого месяца",
        ["12 Tickets - Lesser Darkmoon Prize"] = "12 билетов - малый приз Темной луны",
        ["1200 Tickets - Amulet of the Darkmoon"] = "1200 билетов - амулет Темной Луны",
        ["1200 Tickets - Orb of the Darkmoon"] = "1200 билетов - сфера Темной Луны",
        ["40 Tickets - Greater Darkmoon Prize"] = "40 билетов - большой приз Темной Луны",
        ["40 Tickets - Schematic: Steam Tonk Controller"] = "40 билетов - пульт управления паровым танком",
        ["5 Tickets - Darkmoon Flower"] = "5 билетов - цветок Темной луны",
        ["5 Tickets - Minor Darkmoon Prize"] = "5 билетов - поощрительный приз Темной Луны",
        ["50 Tickets - Darkmoon Storage Box"] = "50 билетов - ящик Темной Луны",
        ["A Bad Egg"] = "Плохое яйцо",
        ["A Baying of Gnolls"] = "Лай гноллов",
        ["A Better Ingredient"] = "Лучший ингредиент",
        ["A Bijou for Zanza"] = "Драгоценности Занзы",
        ["A Binding Contract"] = "Заключение договора",
        ["A Bird's-Eye View"] = "Птичьи Глаза",
        ["A Blue Light Bargain"] = "Выгодная сделка",
        ["A Boar's Vitality"] = "Жизненная сила кабана",
        ["A Boaring Time for Grulloc"] = "Подложим Груллоку свинью",
        ["A Broken Trap"] = "Сломанная западня",
        ["A Bump in the Road"] = "Помехи на трассе",
        ["A Bundle of Hides"] = "Связка шкур",
        ["A Bundle of Trouble"] = "Тридцать три несчастья",
        ["A Burden of Souls"] = "Урожай душ",
        ["A Carefully Wrapped Present"] = "Тщательно завернутый подарок",
        ["A Cleansing Light"] = "Очищающий Свет",
        ["A Collection of Heads"] = "Коллекция голов",
        ["A Convincing Disguise"] = "Убедительная маскировка",
        ["A Crew Under Fire"] = "На абордаж!",
        ["A Crumpled Up Note"] = "Измятая записка",
        ["A Cry For Help"] = "Крик о помощи",
        ["A Cure for Zahlia"] = "Лекарство для Залии",
        ["A Curse Upon Both of Your Clans!"] = "Чума на оба ваших клана!",
        ["A Dandy's Best Friend"] = "Лучший друг щеголя",
        ["A Dark Pact"] = "Темный пакт",
        ["A Dark Threat Looms"] = "Нависшая угроза",
        ["A Date with Dorgok"] = "Встреча с Доргоком",
        ["A Daughter's Love"] = "Дочерняя любовь",
        ["A Debilitating Sickness"] = "Изнуряющая слабость",
        ["A Defector"] = "Дезертир",
        ["A Different Approach"] = "Другой подход",
        ["A Dip in the Moonwell"] = "Проба из лунного колодца",
        ["A Dire Situation"] = "Тяжелая ситуация",
        ["A Discreet Inquiry"] = "Деликатная просьба",
        ["A Dwarf and His Tools"] = "Дворф и его инструменты",
        ["A Fate Worse Than Death"] = "Участь хуже, чем смерть",
        ["A Favor for Evershine"] = "Услуга за \"Вечное сияние\"",
        ["A Favorite Treat"] = "Любимое блюдо",
        ["A Festive Gift"] = "Праздничный дар",
        ["A Final Blow"] = "Окончательный удар",
        ["A Fine Egg"] = "Хорошее яйцо",
        ["A Fine Mess"] = "Катавасия",
        ["A Fishy Peril"] = "Водяная нечисть",
        ["A Fistful of Slivers"] = "Пригоршня осколков",
        ["A Free Lunch"] = "Бесплатный обед",
        ["A Friend in Need"] = "Друг в беде",
        ["A Gaily Wrapped Present"] = "Подарок в яркой упаковке",
        ["A Gallon of Blood"] = "Галлон крови",
        ["A Gesture of Goodwill"] = "Жест доброй воли",
        ["A Ghost in the Machine"] = "Дух из машины.",
        ["A Gift for Voren'thal"] = "Дар для Ворен-таля",
        ["A Gnome's Assistance"] = "Помощь гномов",
        ["A Gnome's Respite"] = "Отсрочка для гнома",
        ["A Good Friend"] = "Добрый друг",
        ["A Good Head On Your Shoulders"] = "Голова на плечах",
        ["A Grave Situation"] = "Замогильная история",
        ["A Grim Discovery"] = "Зловещее открытие",
        ["A Grim Task"] = "Поручение Грима",
        ["A Grunt's Work..."] = "Наряд вне очереди",
        ["A Handful of Magic Dust"] = "Магическая пыль",
        ["A Hasty Departure"] = "Поспешный отъезд",
        ["A Haunted History"] = "Призрачная история...",
        ["A Head Full of Ivory"] = "Кость на вес золота",
        ["A Heap of Ethereals"] = "Груда духов Астрала",
        ["A Helping Hand"] = "Рука помощи",
        ["A Hero Is Needed"] = "Требуется герой",
        ["A Hero's Reward"] = "Награда для героя",
        ["A Hero's Welcome"] = "Благодарность за отвагу",
        ["A Host of Evil"] = "Воинство зла",
        ["A Humble Offering"] = "Скромный подарок",
        ["A Humble Task"] = " Скромная просьба",
        ["A Hunter's Boast"] = "Похвальба охотника",
        ["A Hunter's Challenge"] = "Вызов охотнику",
        ["A Husband's Last Battle"] = "Последняя битва супруга",
        ["A Husband's Revenge"] = "Отмщение мужа",
        ["A Job Undone"] = "Несделанное дело",
        ["A Job for an Intelligent Man"] = "Работа для сообразительных",
        ["A King's Tribute"] = "Королевские почести",
        ["A Lack of Fear"] = "Бесстрашие",
        ["A Land Filled with Hatred"] = "Земли, полные ненависти",
        ["A Lesson Learned"] = "Усвоенный Урок",
        ["A Letter Undelivered"] = "Недоставленное письмо",
        ["A Lingering Suspicion"] = "Длительные подозрения",
        ["A Little Dash of Seasoning"] = "Острое блюдо",
        ["A Little Help From My Friends"] = "Дружеская помощь",
        ["A Little Slime Goes a Long Way"] = "Долгий путь слизнюка",
        ["A Lost Master"] = "Пропавший хозяин",
        ["A Map to Where?"] = "Загадочная карта",
        ["A Message to Telaar"] = "Послание в Телаар",
        ["A Mysterious Portent"] = "Таинственное знамение",
        ["A Necessary Distraction"] = "Необходимая уловка",
        ["A New Cloak's Sheen"] = "Новый сверкающий плащ",
        ["A New Ore Sample"] = "Образец новой руды",
        ["A New Plague"] = "Новая чума",
        ["A New Threat"] = "Новая угроза",
        ["A Noble Brew"] = "Благородный напиток",
        ["A Not-So-Modest Proposal"] = "Нескромное предложение",
        ["A Pawn on the Eternal Board"] = "Пешка на Доске Вечности",
        ["A Peon's Burden"] = "Ноша раба",
        ["A Personal Favor"] = "Личное одолжение",
        ["A Pilgrim's Plight"] = "Скарб пилигрима",
        ["A Pilot's Revenge"] = "Месть пилота",
        ["A Plague Upon Thee"] = "Чума на вашу лесопилку!",
        ["A Portable Power Source"] = "Портативный источник энергии",
        ["A Promising Start"] = "Многообещающее начало",
        ["A Proper String"] = "Надлежащая тетива",
        ["A Putrid Task"] = "Грязная работа",
        ["A Question of Gluttony"] = "Что они жрут?",
        ["A Rare Bean"] = "Редкий деликатес",
        ["A Recipe For Death"] = "Рецептура смерти",
        ["A Refugee's Quandary"] = "Беда беженца",
        ["A Reliquary of Purity"] = "Реликварий Чистоты",
        ["A Restorative Draught"] = "Приводящее в сознание зелье",
        ["A Rogue's Deal"] = "Выгодная сделка",
        ["A Sacred Burial"] = "Священное погребение",
        ["A Scroll from Mauren"] = "Свиток от Маурена",
        ["A Secret Revealed"] = "Раскрытая тайна",
        ["A Shameful Waste"] = "Напрасные усилия",
        ["A Shifty Merchant"] = "Сомнительный торговец",
        ["A Short Incubation"] = "Инкубатор",
        ["A Shred of Hope"] = "Проблеск надежды",
        ["A Sign of Hope"] = "Предвестник надежды",
        ["A Simple Request"] = "Приглашение",
        ["A Simple Robe"] = "Простое одеяние",
        ["A Small Start"] = "Начало положено",
        ["A Solvent Spirit"] = "Растворитель",
        ["A Somber Task"] = "Печальное задание",
        ["A Spirit Ally?"] = "Дух-союзник?",
        ["A Spirit Guide"] = "Дух-проводник",
        ["A Sticky Situation"] = "Грязное дело",
        ["A Strange Historian"] = "Странный историк",
        ["A Strange One"] = "Странная дамочка",
        ["A Strange Red Key"] = "Странный красный ключ",
        ["A Strange Request"] = "Странная просьба",
        ["A Strange Weapon"] = "Странное оружие",
        ["A Study in Power"] = "Источник силы",
        ["A Supernatural Device"] = "Сверхъестественное устройство",
        ["A Swift Message"] = "Срочное сообщение",
        ["A Tale of Sorrow"] = "Горестная повесть",
        ["A Task Unfinished"] = "Незаконченное задание",
        ["A Taste of Flame"] = "Вкус пламени",
        ["A Terrible Purpose"] = "Ужасная цель",
        ["A Threat Within"] = "Внутренняя угроза",
        ["A Threat in Feralas"] = "Опасность в Фераласе",
        ["A Time for Negotiation..."] = "Время для переговоров...",
        ["A Traitor Among Us"] = "Предатель среди нас",
        ["A Troubled Spirit"] = "Неупокоенный дух",
        ["A Troubling Breeze"] = "Ветер тревоги",
        ["A Vengeful Fate"] = "Отмщение грядет!",
        ["A Visit With The Ancestors"] = "Навестить предков",
        ["A Visit With the Greatmother"] = "Разговор с Великой матерью",
        ["A Visit to Gregan"] = "Визит к Грегану",
        ["A Warm Welcome"] = "Теплый прием",
        ["A Warrior's Training"] = "Обучение воина",
        ["A Watchful Eye"] = "Недремлющее Око",
        ["A Yeti of Your Own"] = "Твой собственный Йети.",
        ["Abandoned Hope"] = "Утраченная надежда",
        ["Abandoned Investigations"] = "Неоконченное исследование",
        ["Abjurist Belmara"] = "Отзаконница Белмара",
        ["Above and Beyond"] = "Быстрее, выше, сильнее",
        ["Abyssal Contacts"] = "Связь с Бездной",
        ["Abyssal Crests"] = "Талисманы Бездны",
        ["Additional Materials"] = "Дополнительные материалы",
        ["Administering the Salve"] = "Наложение мази",
        ["After the Ambush"] = "После засады",
        ["Again With the Zapped Giants"] = "Новая ликвидация великанов",
        ["Against All Odds"] = "Вопреки всему",
        ["Against Lord Shalzaru"] = "Борьба с лордом Шалзару",
        ["Against the Hatecrest"] = "Борьба с Гребнем Ненависти",
        ["Against the Illidari"] = "Против иллидари",
        ["Against the Legion"] = "Против Легиона",
        ["Agamaggan's Agility"] = "Ловкость Агамаггана",
        ["Agamaggan's Strength"] = "Сила Агамаггана",
        ["Agamand Heirlooms"] = "Наследние Агамондов",
        ["Agents of Destruction"] = "Пособники разрушения",
        ["Aggression"] = "Лютая злоба",
        ["Agitated Spirits of Skysong"] = "Беспокойные духи озера Небесной Песни",
        ["Agmond's Fate"] = "Судьба Эгмонда",
        ["Aiding the Outrunners"] = "Помощь Курьерам",
        ["Ak'Zeloth"] = "Ак-Зелот",
        ["Akama"] = "Акама",
        ["Akama's Promise"] = "Обещание Акамы",
        ["Akiris by the Bundle"] = "Кипы акириса",
        ["Aldor No More"] = "Больше никакого Альдора",
        ["Alien Ecology"] = "Экология чужих",
        ["Alien Egg"] = "Неизвестное яйцо",
        ["Alien Predators"] = "Чужие-хищники",
        ["Alien Spirits"] = "Неведомые духи",
        ["All Along the Watchtowers"] = "Сторожевые башни",
        ["All Clear!"] = "Все чисто!",
        ["All That Remains"] = "Останки семьи",
        ["Allegiance to Cenarion Circle"] = "Верность Кругу Кенариуса",
        ["Allegiance to the Aldor"] = "Присяга Альдору",
        ["Allegiance to the Old Gods"] = "Верность Древним богам",
        ["Allegiance to the Scryers"] = "Присяга Видящим",
        ["Alliance Relations"] = "Отношения с Альянсом",
        ["Alliance Trauma"] = "Травматологи Альянса",
        ["Alpha Strike"] = "Истребление вожаков",
        ["Altered Beings"] = "Измененные существа",
        ["Alther's Mill"] = "Лесопилка Альтера",
        ["Altruis"] = "Алтруис",
        ["Amani Encroachment"] = "Завоевание Амани",
        ["Amani Invasion"] = "Вторжение Амани",
        ["Ambermill Investigations"] = "Расследования в Янтарной Мельнице",
        ["Ammo for Rumbleshot"] = "Боеприпасы для Громострела",
        ["Amongst the Ruins"] = "Среди руин",
        ["Amulet of Secrets"] = "Амулет тайн",
        ["An Aggressive Defense"] = "Агрессивная защита",
        ["An Alternative Alternative"] = "Другая альтернатива",
        ["An Ambassador of Evil"] = "Посланник зла",
        ["An Ambitious Plan"] = "Честолюбивый план",
        ["An Apprentice's Enchantment"] = "Ученик чародея",
        ["An Audacious Advance"] = "Дерзкий набег",
        ["An Audience with the Prince"] = "Аудиенция у принца",
        ["An Earnest Proposition"] = "Серьезное предложение",
        ["An Easy Pickup"] = "Легкая доставка",
        ["An Extraordinary Egg"] = "Необычное яйцо",
        ["An Imp's Request"] = "Просьба беса",
        ["An Improper Burial"] = "Недостойные похороны",
        ["An Introduction"] = "Посвящение",
        ["An OOX of Your Own"] = "Собственный ООХ",
        ["An Old Colleague"] = "Старый коллега",
        ["An Old Gift"] = "Старый дар",
        ["An Old History Book"] = "Старый учебник истории",
        ["An Ordinary Egg"] = "Обычное яйцо",
        ["An Orphan Looking For a Home"] = "Бездомный сиротка",
        ["An Unholy Alliance"] = "Нечестивый союз",
        ["An Unnatural Drought"] = "Неестественная засуха",
        ["An Unseen Hand"] = "Невидимая длань",
        ["An Unusual Patron"] = "Необычный посетитель",
        ["An Unwelcome Guest"] = "Незваный гость",
        ["An Unwelcome Presence"] = "Нежелательное присутствие",
        ["Anachronos"] = "Анахронос",
        ["Ancient Sinew Wrapped Lamina"] = "Лист ходячего Древа, сшитый жилами",
        ["Ancient Spirit"] = "Древний дух",
        ["Andron's Payment to Jediga"] = "Плата Андрона Джедиге",
        ["Angling to Beat the Competition"] = "Не распугивайте рыбу!",
        ["Ango'rosh Encroachment"] = "Вторжение Ангороша",
        ["Animist's Caress"] = "Прикосновение анимиста",
        ["Anok'suten"] = "Аноксутен",
        ["Another Heap of Ethereals"] = "Еще одна груда духов Астрала",
        ["Another Message to the Wildhammer"] = "Еще одно письмо для Громового Молота",
        ["Another Power Source?"] = "Еще один источник энергии?",
        ["Ansirem's Key"] = "Ключ Ансарема",
        ["Answered Questions"] = "Полученные ответы",
        ["Anthion's Old Friend"] = "Старый приятель Антиона",
        ["Anthion's Parting Words"] = "Прощальные слова Антиона",
        ["Anthion's Strange Request"] = "Странная просьба Антиона",
        ["Apothecary Antonivich"] = "Аптекарь Антонивич",
        ["Apothecary Zamah"] = "Аптекарь Зама",
        ["Apothecary Zelana"] = "Аптекарь Зелана",
        ["Apprentice Angler"] = "Начинающий удильщик",
        ["Apprentice's Duties"] = "Тяжкая судьба помощника",
        ["Aquatic Form"] = "Водный облик",
        ["Aquementas"] = "Акваментас",
        ["Ar'kelos the Guardian"] = "Страж Аркелос",
        ["Arachnophobia"] = "Арахнофобия",
        ["Araj's Scarab"] = "Скарабей Араджи",
        ["Arakkoa War Path"] = "Тропа войны араккоа",
        ["Arathor Basic Care Package"] = "Полевой комплект Лиги Аратора",
        ["Arathor Standard Care Package"] = "Стандартный полевой комплект Лиги Аратора",
        ["Arcane Feedback"] = "Тайная магия",
        ["Arcane Instability"] = "Магическая нестабильность",
        ["Arcane Reavers"] = "Магический страж",
        ["Arcane Refreshment"] = "Магический напиток",
        ["Arcane Runes"] = "Чародейские руны",
        ["Arcane Tomes"] = "Чародейские фолианты",
        ["Arcanite"] = "Арканит",
        ["Arconus the Insatiable"] = "Арконус Ненасытный",
        ["Arelion's Journal"] = "Журнал Аэриона",
        ["Arelion's Mistress"] = "Любовница Арелиона",
        ["Arelion's Secret"] = "Тайна Арелиона",
        ["Arena Master"] = "Мастер Арены",
        ["Arikara"] = "Арикара",
        ["Armaments for Deception"] = "Военная хитрость",
        ["Armed and Ready"] = "Вооружен и особо опасен",
        ["Armor Kits for the Field"] = "Комплекты брони",
        ["Armor Scraps"] = "Обломки брони",
        ["Arms for the Field"] = "Нехватка оружия",
        ["Army of the Black Dragon"] = "Армия Черного дракона",
        ["Arrival in Outland"] = "Прибытие в Пустоши",
        ["Arrows Are For Sissies"] = "Стрелы - для неженок!",
        ["Artifacts of the Blacksilt"] = "Артефакты клана Черного Ила",
        ["Arugal Must Die"] = "Смерть Аругалу!",
        ["Arugal's Folly"] = "Безрассудство Аругала",
        ["Arzeth's Demise"] = "Наследие Азрета",
        ["As Water Cascades"] = "Пока струится вода...",
        ["As the Crow Flies"] = "С высоты птичьего полета",
        ["Ascension..."] = "Вознесение",
        ["Asghar's Totem"] = "Тотем Асгара",
        ["Ashenvale Outrunners"] = "Ашенвальские лазутчицы",
        ["Assassin's Contract"] = "Контракт убийцы",
        ["Assassination Plot"] = "Убийственный заговор",
        ["Assault on Fenris Isle"] = "Атака на остров Фенриса",
        ["Assault on Zeb'Nowa"] = "Нападение на Зеб-Нову",
        ["Assault on the Kolkar"] = "Нападение на клан Колкар",
        ["Assessing the Situation"] = "Оценка ситуации",
        ["Assessing the Threat"] = "Подсчет врагов",
        ["Assisting the Consortium"] = "Содействие Консорциуму",
        ["Astral Knot Garment"] = "Одеяние с астральным узлом",
        ["At War With The Scarlet Crusade"] = "Война с Алым Маршем",
        ["Attack on Camp Narache"] = "Нападение на лагерь Нарахе",
        ["Attack on Firewing Point"] = "Нападение на пик Огненных Крыльев",
        ["Attack on Zeb'Tela"] = "Нападение на Зеб-Телу",
        ["Attack on the Tower"] = "Атака на башню",
        ["Auchindoun..."] = "Аучиндон...",
        ["Audience with the Prophet"] = "Аудиенция у Пророка",
        ["Auntie Marlene"] = "Тетушка Марлен",
        ["Aurel Goldleaf"] = "Аурэль Золотой Лист",
        ["Aurius' Reckoning"] = "Слова Ауриуса",
        ["Avenge My Village"] = "Отомсти за мою деревню",
        ["Avenger's Breastplate"] = "Кираса Мстителя",
        ["Avenger's Crown"] = "Корона Мстителя",
        ["Avenger's Greaves"] = "Наголенники Мстителя",
        ["Avenger's Legguards"] = "Набедренники Мстителя",
        ["Avenger's Pauldrons"] = "Оплечье Мстителя",
        ["Avenging the Fallen"] = "Отмщение за погибших",
        ["Avruu's Orb"] = "Сфера Авруу",
        ["Azsharite"] = "Азарит",
        ["Azure Templar"] = "Лазурный храмовник",
        ["Azuregos's Magical Ledger"] = "Магическая книга Азурегоса",
        ["B'naar Console Transcription"] = "Описание панели управления Б'наара",
        ["Back to Billy"] = "Назад к Билли",
        ["Back to Booty Bay"] = "Назад в Бухту Контрабандистов",
        ["Back to Darnassus"] = "Возвращение в Дарнасс",
        ["Back to Thunder Bluff"] = "Возвращение в Громовой утес",
        ["Back to Uldaman"] = "Назад в Ульдаман",
        ["Back to the Beginning"] = "Круг замкнулся",
        ["Back to the Chief!"] = "Обратно к командующему!",
        ["Bad Medicine"] = "Дурное лекарство",
        ["Badlands Reagent Run"] = "В Бесплодные земли за реактивом",
        ["Badlands Reagent Run II"] = "В Бесплодные земли за реактивом II",
        ["Bailor's Ore Shipment"] = "Партия руды Бэйлора",
        ["Balance Must Be Preserved"] = "Необходимо поддерживать равновесие!",
        ["Band of Unending Life"] = "Кольцо Бесконечной жизни",
        ["Band of Vaulted Secrets"] = "Кольцо Погребенных тайн",
        ["Band of Veiled Shadows"] = "Кольцо Скрытых Теней",
        ["Bandits!"] = "Бандиты!",
        ["Bane of the Illidari"] = "Проклятие иллидари",
        ["Barbaric Battlements"] = "Варварские доспехи",
        ["Barbecued Buzzard Wings"] = "Жареные крылышки канюка",
        ["Baron Aquanis"] = "Барон Акванис",
        ["Baron Sablemane"] = "Барон Черногрив",
        ["Baron Sablemane Has Requested Your Presence"] = "Барон Черногрив желает вас лицезреть",
        ["Baron Sablemane's Poison"] = "Яд барона Черногрива",
        ["Baron's Demise"] = "Смерть барона",
        ["Barov Family Fortune"] = "Сокровище Бароу",
        ["Bartleby the Drunk"] = "Бартлби Пьянь",
        ["Bartleby's Mug"] = "Кружка Бартлби",
        ["Bartolo's Yeti Fur Cloak"] = "Плащ из меха йети",
        ["Bashal'Aran"] = "Башал'Аран",
        ["Bathran's Hair"] = "Батранов волос",
        ["Battle of Hillsbrad"] = "Битва за Хилсбрад",
        ["Battle of Warsong Gulch"] = "Битва за лощину Боевого Клича",
        ["Battle of the Crimson Watch"] = "Битва у Алого форпоста",
        ["Battle-Mage Dathric"] = "Боевой маг Датрик",
        ["Beached Sea Creature"] = "Останки морской твари",
        ["Beached Sea Turtle"] = "Останки морской черепахи",
        ["Beads for Salfa"] = "Бусы для Сальты",
        ["Bearers of the Plague"] = "Разносчики заразы",
        ["Beast Training"] = "Дрессировка",
        ["Beasts of the Apocalypse!"] = "Звери Судного дня!",
        ["Beat Bartleby"] = "Побить Бартлби",
        ["Because Kilrath is a Coward"] = "Потому что Килрат - трус",
        ["Becoming a Mooncloth Tailor"] = "Обучение шитью из лунной ткани",
        ["Becoming a Parent"] = "У вас появился малыш!",
        ["Becoming a Shadoweave Tailor"] = "Обучение шитью из ткани Теней",
        ["Becoming a Spellfire Tailor"] = "Обучение шитью из ткани огненных чар",
        ["Beer Basted Boar Ribs"] = "Грубинка кабана под пивом",
        ["Before Darkness Falls"] = "До наступления тьмы",
        ["Befouled by Satyr"] = "Гнусные сатиры",
        ["Begin the Attack!"] = "В атаку!",
        ["Beginnings"] = "В начале славных дел",
        ["Behind Enemy Lines"] = "В тылу врага",
        ["Behomat"] = "Бехомат",
        ["Bell of Dethmoora"] = "Колокол Детмуры",
        ["Belt of Faith"] = "Пояс Веры",
        ["Beneath Thrallmar"] = "Рядом с Траллмаром",
        ["Beren's Peril"] = "Проклятье Берена",
        ["Besieged!"] = "Окружены!",
        ["Betina Bigglezink"] = "Бетина Биггльцинк",
        ["Betrayal from Within"] = "Предатель в наших рядах",
        ["Betrayed"] = "Предательница",
        ["Better Late Than Never"] = "Лучше поздно, чем никогда",
        ["Between a Rock and a Thistlefur"] = "Между скалой и Злым Чертополохом",
        ["Beware of Pterrordax"] = "Бди: птерожуть не дремлет!",
        ["Big Black Mace"] = "Большая черная палица",
        ["Big Game Hunter"] = "Охотник на крупную дичь",
        ["Bijou's Belongings"] = "Вещи Безделушки",
        ["Bijou's Reconnaissance Report"] = "По данным разведки",
        ["Binding the Dreadnaught"] = "Броня дредноута",
        ["Bindings of Faith"] = "Поручья Веры",
        ["Bingles' Missing Supplies"] = "Пропавшее снаряжение Бинглза",
        ["Birds of a Feather"] = "Пух и перья",
        ["Bitter Rivals"] = "Злейшие соперники",
        ["Blackfathom Villainy"] = "Жестокость Черных Глубин",
        ["Blackhand's Command"] = "Приказ Черной Руки",
        ["Blackmoore's Legacy"] = "Наследие Блэкмура",
        ["Blackrock Bounty"] = "Награда за головы орков Черной Скалы",
        ["Blackrock Menace"] = "Угроза Черной Скалы",
        ["Blacksting's Bane"] = "Проклятие Черной осы",
        ["Blade of Eternal Justice"] = "Клинок Вечной справедливости",
        ["Blade of Vaulted Secrets"] = "Клинок Погребенных тайн",
        ["Bladespire Kegger"] = "Бочонок клана Стальных Игл",
        ["Blast the Infernals!"] = "Перебей демонов!",
        ["Bleeding Hollow Supply Crates"] = "Припасы Кровавой Лощины",
        ["Blessed Arcanite Barding"] = "Благословенный арканитовый чепрак",
        ["Blessed Arm"] = "Достойное оружие",
        ["Blessing of Incineratus"] = "Благословение Возжигателя",
        ["Blessings of the Ancients"] = "Благословение древних мудрецов",
        ["Blind Cazul"] = "Слепой Казул",
        ["Blisters on The Land"] = "Нарывы на теле земли",
        ["Blood Crystals"] = "Кровавые кристаллы",
        ["Blood Elf Plans"] = "Планы эльфов Крови",
        ["Blood Elf Spy"] = "Шпион эльфов Крови",
        ["Blood Feeders"] = "Кровопийцы",
        ["Blood Shards of Agamaggan"] = "Кровавые осколки Агамаггана",
        ["Blood Tinged Skies"] = "Окровавленные небеса",
        ["Blood Watch"] = "Кровавая Стража",
        ["Blood of the Black Dragon Champion"] = "Кровь могучего черного дракона",
        ["Bloodfury Bloodline"] = "Предводительница клана Смертельной Ярости",
        ["Bloodgem Crystals"] = "Кристаллы камня Крови",
        ["Bloodpetal Poison"] = "Яд кровоцвета",
        ["Bloodpetal Sprouts"] = "Побеги кровоцвета",
        ["Bloodpetal Zapper"] = "Антикровоцветный шокер",
        ["Bloodscalp Clan Heads"] = "Головы клана Кровавого Скальпа",
        ["Bloodscalp Ears"] = "Уши троллей",
        ["Bloodscalp Insight"] = "Изучение Кровавого Скальпа",
        ["Bloody Bone Necklaces"] = "Ожерелье Кровавых костей",
        ["Bloody Imp-ossible!"] = "Кровная м... есть!",
        ["Blueleaf Tubers"] = "Корни Синелиста",
        ["Boat Wreckage"] = "Разбитая лодка",
        ["Bodley's Unfortunate Fate"] = "Злосчастная доля Бодли",
        ["Body and Heart"] = "Тело и дух",
        ["Body of Evidence"] = "Вещественное доказательство",
        ["Bodyguard for Hire"] = "Наемный телохранитель",
        ["Boiling Blood"] = "Кипящая кровь",
        ["Bolstering Our Defenses"] = "Укрепим оборону",
        ["Bone Collector"] = "Собиратель костей",
        ["Bone Fragments"] = "Обломки костей",
        ["Bone-Bladed Weapons"] = "Костяные клинки",
        ["Bonechewer Blood"] = "Кровь Костеглодов",
        ["Bonescythe Bracers"] = "Боевые браслеты Костяной косы",
        ["Bonescythe Breastplate"] = "Кираса Костяной косы",
        ["Bonescythe Digs"] = "Копи Костяной Косы",
        ["Bonescythe Gauntlets"] = "Латные рукавицы Костяной косы",
        ["Bonescythe Helmet"] = "Шлем Костяной косы",
        ["Bonescythe Legplates"] = "Латные поножи Костяной косы",
        ["Bonescythe Pauldrons"] = "Оплечье Костяной косы",
        ["Bonescythe Sabatons"] = "Башмаки Костяной косы",
        ["Bonescythe Waistguard"] = "Воинский пояс Костяной косы",
        ["Book of the Ancients"] = "Книга Древних",
        ["Bookie Herod"] = "Букмекер Ирод",
        ["Booty Bay or Bust!"] = "Вперед, в Бухту Контрабандистов!",
        ["Bor Wishes to Speak"] = "Разговор с Бором",
        ["Border Crossings"] = "Пересечение границ",
        ["Botanical Legwork"] = "Сбор трав",
        ["Botanist Taerix"] = "Ботаник Таэрикс",
        ["Boulderslide Ravine"] = "Ущелье Камнепадов",
        ["Bound for Glory"] = "И всё ради славы",
        ["Bounty on Garrick Padfoot"] = "Награда за голову Гаррика Тихокрада",
        ["Bounty on Murlocs"] = "Награда за морлоков",
        ["Bracers of Binding"] = "Браслеты Стихий",
        ["Brann Bronzebeard's Lost Letter"] = "Потерянное письмо Бранна Золотой Бороды",
        ["Breaching the Path"] = "Перерезанный путь",
        ["Break Sharptusk!"] = "Сразить Остроклыка!",
        ["Break a Few Eggs"] = "Хорошенький омлет",
        ["Breaking Down Netherock"] = "Низвергнуть Хаосскала",
        ["Breaking the Code"] = "Расшифровка",
        ["Breaking the Keystone"] = "Разбить ключ-камень",
        ["Breaking the Ward"] = "Минуя охрану",
        ["Breastplate of Bloodthirst"] = "Кираса кровавой жажды",
        ["Breastplate of the Chromatic Flight"] = "Кираса Всецветных драконов",
        ["Bride of the Embalmer"] = "Невеста Бальзамировщика",
        ["Bring Back the Mug"] = "Возвращение кружки",
        ["Bring Down the Warbringer!"] = "Смерть вестнику войны!",
        ["Bring Me A Shrubbery!"] = "Принеси мне кустики!",
        ["Bring Me Another Shrubbery!"] = "Еще кустиков!",
        ["Bring Me Kel'gash's Head!"] = "Награда за голову Келгаша!",
        ["Bring Me The Egg!"] = "Принеси мне яйцо!",
        ["Bring the End"] = "Да сгинет Хладоносец!",
        ["Bring the Light"] = "Светоприношение",
        ["Broken Alliances"] = "Разорванные союзы",
        ["Broken Tears"] = "Россыпи Слез",
        ["Broodling Essence"] = "Сущность детеныша дракона",
        ["Brother Against Brother"] = "Brother Against Brother",
        ["Brother Anton"] = "Брат Антон",
        ["Brother Carlin"] = "Брат Карлин",
        ["Brother Paxton"] = "Брат Пакстон",
        ["Brotherhood of Thieves"] = "Братство воров",
        ["Brotherhood's End"] = "Гибель братства",
        ["Brotherly Love"] = "Братская любовь",
        ["Brumeran of the Chillwind"] = "Убить Брумеран",
        ["Brutal Armor"] = "Доспехи Жестокости",
        ["Brutal Gauntlets"] = "Латные рукавицы Жестокости",
        ["Brutal Hauberk"] = "Хауберк Жестокости",
        ["Brutal Helm"] = "Большой шлем Жестокости",
        ["Brutal Legguards"] = "Набедренники Жестокости",
        ["Brutal Politics"] = "Политика силы",
        ["Building a Perimeter"] = "Постройка периметра",
        ["Bungle in the Jungle"] = "Вылазка в джунгли",
        ["Burn It Up... For the Horde!"] = "Сжечь! Во имя Орды!",
        ["Burning Blade Medallion"] = "Медальон Огненного Клинка",
        ["Burning Blood"] = "Горящая кровь",
        ["Burning Shadows"] = "Пылающие тени",
        ["Buying Time"] = "Выиграть время",
        ["Buzzbox 323"] = "Жужжалка 323",
        ["Buzzbox 411"] = "Жужжалка 411",
        ["Buzzbox 525"] = "Жужжалка 525",
        ["Buzzbox 827"] = "Жужжалка 827",
        ["By Any Means Necessary"] = "Любыми средствами",
        ["C'Thun's Legacy"] = "Наследие Ка-Туна",
        ["CLUCK!"] = "Куд-кудаааа!",
        ["Cabal Orders"] = "Политические приказы",
        ["Cache of Mau'ari"] = "Сокровище Мау'ари",
        ["Call of Air"] = "Зов воздуха",
        ["Call of Air - Guse's Fleet"] = "Воздух зовет - флот Гуса",
        ["Call of Air - Ichman's Fleet"] = "Зов воздуха - флот Ичмена",
        ["Call of Air - Jeztor's Fleet"] = "Воздух зовет - флот Джезтора",
        ["Call of Air - Mulverick's Fleet"] = "Воздух зовет - флот Малверика",
        ["Call of Air - Slidore's Fleet"] = "Зов воздуха - флот Слидора",
        ["Call of Air - Vipore's Fleet"] = "Воздух зовет - флот Змейера",
        ["Call of Earth"] = "Зов Земли",
        ["Call of Fire"] = "Зов Огня",
        ["Call of Water"] = "Зов Воды",
        ["Call to Arms"] = "К оружию!",
        ["Calling in the Reserves"] = "Смена караула",
        ["Calm Before the Storm"] = "Затишье перед бурей",
        ["Camp Mojache"] = "Лагерь Моджаха",
        ["Can't Stay Away"] = "Неудержимый",
        ["Candles of Beckoning"] = "Манящие свечи",
        ["Cannibalistic Cousins"] = "Собратья-каннибалы",
        ["Cannons of Rage"] = "Пушки Ярости",
        ["Cape of Eternal Justice"] = "Накидка Вечной справедливости",
        ["Captain Kelisendra's Lost Rutters"] = "Утраченные бумаги капитана Келисендры",
        ["Captain Sander's Hidden Treasure"] = "Спрятанное сокровище капитана Сандера",
        ["Captain Tyralius"] = "Капитан Тиралиус",
        ["Captain Vimes"] = "Капитан Ваймс",
        ["Captives at Deatholme"] = "Пленники Смертхольма",
        ["Capture a Mine"] = "Захват рудника",
        ["Capture the Weapons"] = "Сдать оружие!",
        ["Capturing the Keystone"] = "Захват Ключ-камня",
        ["Capturing the Phylactery"] = "Захватить талисман",
        ["Carendin Summons"] = "Вызов Карендина",
        ["Carnival Boots"] = "Тисненые кожаные сапоги",
        ["Carnival Jerkins"] = "Кожаные куртки",
        ["Carrion Grubbage"] = "Мясо личинок-трупоедов",
        ["Carry Your Weight"] = "Переноска тяжестей",
        ["Castpipe's Task"] = "Поручение Чугунной Трубы",
        ["Catalogue of the Wayward"] = "Перечень Заблудших",
        ["Catch and Release"] = "Поймать и отпустить",
        ["Catch of the Day"] = "Дорога рыбка к обеду",
        ["Caught!"] = "Попался!",
        ["Cave Mushrooms"] = "Грибы из пещеры",
        ["Celebrating Good Times"] = "Праздник добрых времен",
        ["Celestial Power"] = "Небесная сила",
        ["Cenarion Aid"] = "Помощь Кенариуса",
        ["Cenarion Battlegear"] = "Броня Кенариуса",
        ["Cenarius' Legacy"] = "Наследие Кенариуса",
        ["Centaur Bounty"] = "Награда за кентавров",
        ["Centaur Bracers"] = "Боевые браслеты кентавров",
        ["Challenge Overlord Mok'Morokk"] = "Вызов властителю Мок-Морроку",
        ["Champion's Battlegear"] = "Броня Защитника",
        ["Chapter I"] = "Глава I",
        ["Chapter II"] = "Глава II",
        ["Chapter III"] = "Глава III",
        ["Chapter IV"] = "Глава IV",
        ["Chasing A-Me 01"] = "В поисках А-Ми 01",
        ["Chen's Empty Keg"] = "Пустой бочонок Райво",
        ["Chicken Clucking for a Mint"] = "Курочка с мятой",
        ["Chief Engineer Scooty"] = "Главный инженер Скути",
        ["Chieftain Oomooroo"] = "Вождь Умуру",
        ["Children's Week"] = "Детская неделя",
        ["Chillwind Horns"] = "Рога Холодного Ветра",
        ["Chimaeric Horn"] = "Рог химеры",
        ["Cho'war the Pillager"] = "Човар Грабитель",
        ["Chromatic Mantle of the Dawn"] = "Многоцветное оплечье Рассвета",
        ["Circlet of Faith"] = "Венец Веры",
        ["City of Light"] = "Город Света",
        ["Claim Rackmore's Treasure!"] = "Сокровища Ракмора",
        ["Claiming the Light"] = "Получение силы Света",
        ["Clam Bait"] = "Наживка из моллюска",
        ["Clamlette Surprise"] = "Мидии с сюрпризом",
        ["Claws from the Deep"] = "Угроза из глубин",
        ["Cleaning up the Grounds"] = "Расчистить почву",
        ["Cleansed Water Returns to Felwood"] = "Чистая вода возвращается в Фелвудский лес",
        ["Cleansing Felwood"] = "Очищение Фелвудского леса",
        ["Cleansing of the Infected"] = "Искоренение заражения",
        ["Cleansing of the Orb of Orahil"] = "Очищение шара Орахила",
        ["Cleansing the Eye"] = "Проклятое Око",
        ["Cleansing the Scar"] = "Поднять боевой дух",
        ["Cleansing the Waters"] = "Очищение вод",
        ["Clearing the Way"] = "Расчистка пути",
        ["Clefthoof Mastery"] = "Охота на шерсторогов",
        ["Cloak of Unending Life"] = "Плащ Бесконечной жизни",
        ["Cloak of Veiled Shadows"] = "Плащ Скрытых теней",
        ["Cloak of the Gathering Storm"] = "Плащ Надвигающейся бури",
        ["Cloak of the Unseen Path"] = "Плащ Незримого пути",
        ["Cloth and Leather Armor"] = "Броня из кожи и ткани",
        ["Clues in the Thicket"] = "Ответы в чащобе",
        ["Coarse Weightstone"] = "Зернистое грузило",
        ["Codex of Defense"] = "Кодекс Обороны",
        ["Cohlien Frostweaver"] = "Колиен Ледяной Ткач",
        ["Coilfang Armaments"] = "Оружие Спиралезуба",
        ["Coldridge Valley Mail Delivery"] = "Почта для Холодной долины",
        ["Coldtooth Supplies"] = "Припасы Ледяного Зуба",
        ["Collecting Kelp"] = "Хрустальный фукус",
        ["Collecting Memories"] = "Сбор воспоминаний",
        ["Collection of Goods"] = "Сбор необходимого",
        ["Collection of the Corrupt Water"] = "Собрать оскверненную воду",
        ["Colonel Kurzen"] = "Полковник Курзен",
        ["Colossal Menace"] = "Колоссальная угроза",
        ["Combining Forces"] = "Объединенными усилиями",
        ["Coming of Age"] = "Время пришло",
        ["Commander Gor'shak"] = "Командир Горшак",
        ["Compendium of the Fallen"] = "Перечень павших",
        ["Completing the Delivery"] = "Завершение доставки",
        ["Components for the Enchanted Gold Bloodrobe"] = "Материалы для зачарованной золотой кроводежды",
        ["Components of Importance"] = "Важная составляющая заклинания",
        ["Concerns About Tuurem"] = "Опасения за судьбу Туурема",
        ["Concerted Efforts"] = "В едином порыве",
        ["Confront Yeh'kinya"] = "Сопротивление Йекинье",
        ["Conjurer Luminrath"] = "Кудесник Люминрат",
        ["Conqueror's Breastplate"] = "Кираса Завоевателя",
        ["Conqueror's Crown"] = "Корона Завоевателя",
        ["Conqueror's Greaves"] = "Наголенники Завоевателя",
        ["Conqueror's Legguards"] = "Набедренники Завоевателя",
        ["Conqueror's Spaulders"] = "Бармы Завоевателя",
        ["Conscript of the Horde"] = "Новобранец Орды",
        ["Consecrated Letter"] = "Благословенное письмо",
        ["Consecrated Rune"] = "Священная руна",
        ["Consortium Crystal Collection"] = "Добыча артефакта для Консорциума",
        ["Constrictor Vines"] = "Удушающая лоза",
        ["Consult Master Gadrin"] = "Разговор с мастером Гэдрином",
        ["Consumed by Hatred"] = "Огонь ненависти",
        ["Contact from Dalaran"] = "Вести из Даларана",
        ["Containing the Threat"] = "Противостояние",
        ["Continue to Stormwind"] = "Продолжение пути в Штормград",
        ["Continued Threat"] = "Продолжающаяся угроза",
        ["Control"] = "Control",
        ["Control Four Bases"] = "Контроль над четырьмя базами",
        ["Cookie's Jumbo Gumbo"] = "Печенье Джамбо-Гамбо",
        ["Coolant Heads Prevail"] = "Охладить горячие головы",
        ["Copper Modulator"] = "Медный регулятор",
        ["Core of Elements"] = "Средоточие стихий",
        ["Corki's Gone Missing Again!"] = "Корки снова пропал!",
        ["Corki's Ransom"] = "Выкуп за Корки",
        ["Corrupted Soil"] = "Оскверненная почва",
        ["Corruption"] = "Скверна",
        ["Corruption of Earth and Seed"] = "Яблочко от яблоньки...",
        ["Cortello's Riddle"] = "Загадка Кортелло",
        ["Costly Menace"] = "Серьезная угроза",
        ["Counterattack!"] = "Контратака!",
        ["Counting Out Time"] = "Отсчет времени",
        ["Courser Antlers"] = "Рога и копыта",
        ["Covert Ops - Alpha"] = "План операции - альфа",
        ["Covert Ops - Beta"] = "План операции: Бета",
        ["Coyote Thieves"] = "Койоты-воры",
        ["Crackin' Some Skulls"] = "Золото за тумаки",
        ["Cracking Maury's Foot"] = "Вскрыть ногу Мори",
        ["Craftsman's Writ - Brightcloth Pants"] = "Задание мастера - панталоны из яркой ткани",
        ["Craftsman's Writ - Dense Weightstone"] = "Задание мастера - плотное грузило",
        ["Craftsman's Writ - Goblin Sapper Charge"] = "Задание мастера - гоблинский саперный заряд",
        ["Craftsman's Writ - Greater Arcane Protection Potion"] = "Задание мастера - сильное зелье чародейской защиты",
        ["Craftsman's Writ - Huge Thorium Battleaxe"] = "Задание мастера - огромный ториевый боевой топор",
        ["Craftsman's Writ - Major Healing Potion"] = "Задание мастера - хорошее лечебное зелье",
        ["Craftsman's Writ - Major Mana Potion"] = "Задание мастера - хорошее зелье маны",
        ["Craftsman's Writ - Plated Armorfish"] = "Задание мастера - латная бронерыба",
        ["Craftsman's Writ - Runecloth Bag"] = "Задание мастера - сумка из рунной ткани",
        ["Craftsman's Writ - Runecloth Boots"] = "Задание мастера - сапоги из рунной ткани",
        ["Craftsman's Writ - Runecloth Robe"] = "Задание мастера - одеяние из рунной ткани",
        ["Craftsman's Writ - Runic Leather Pants"] = "Задание мастера - рунические кожаные панталоны",
        ["Craftsman's Writ - Stonescale Eel"] = "Задание мастера - каменный угорь",
        ["Craftsman's Writ - Thorium Grenade"] = "Задание мастера - ториевая граната",
        ["Craftsman's Writ - Thorium Tube"] = "Задание мастера - ториевая труба",
        ["Craftsman's Writ - Wicked Leather Headband"] = "Задание мастера - гибельная кожаная головная повязка",
        ["Crashing the Wickerman Festival"] = "Прекращение фестиваля Плетеного Человечка",
        ["Creating the Pendant"] = "Создание подвески",
        ["Creature of the Void"] = "Тварь из Хаоса",
        ["Creatures of the Eco-Domes"] = "Существа Эко-Сфер",
        ["Crime and Punishment"] = "Преступление и наказание",
        ["Crimson Crystal Clue"] = "Ключ к разгадке алого кристалла",
        ["Crimson Templar"] = "Алый храмовник",
        ["Critters of the Void"] = "Твари из Пустоты",
        ["Crocolisk Boy and the Bearded Murloc"] = "Мальчик-кроколиск и бородатый морлок",
        ["Crocolisk Hunting"] = "Охота на кроколисков",
        ["Crossroads Conscription"] = "Рекрутский набор Перекрестка",
        ["Crown of the Earth"] = "Венец Земли",
        ["Cruel Taskmasters"] = "Безжалостные десятники",
        ["Cruel's Intentions"] = "Безжалостные намерения",
        ["Cruelfin's Necklace"] = "Ожерелье морлоков Жестокого Плавника",
        ["Crush the Bloodmaul Camp"] = "Унитожить лагерь Кровавого Молота!",
        ["Crush the Bloodmaul Camp!"] = "Унитожить лагерь Кровавого Молота!",
        ["Crushridge Bounty"] = "Награда Раздробленного Хребта",
        ["Crushridge Warmongers"] = "Наемники из клана Раздробленного Хребта",
        ["Cry of the Thunderhawk"] = "Крик грозового змея",
        ["Crypt Fiend Parts"] = "Конечности и панцири арахнидов-могильщиков",
        ["Cryptstalker Armor Doesn't Make Itself..."] = "Доспехи расхитителя гробниц на дороге не валяются...",
        ["Cryptstalker Boots"] = "Сапоги Расхитителя гробниц",
        ["Cryptstalker Girdle"] = "Тесьма Расхитителя гробниц",
        ["Cryptstalker Handguards"] = "Боевые краги Расхитителя гробниц",
        ["Cryptstalker Headpiece"] = "Головной убор Расхитителя гробниц",
        ["Cryptstalker Tunic"] = "Туника Расхитителя гробниц",
        ["Cryptstalker Wristguards"] = "Запястья Расхитителя гробниц",
        ["Crystal Charge"] = "Кристалл ожога",
        ["Crystal Clear"] = "Ясно, как день!",
        ["Crystal Cluster"] = "Гроздь кристаллов",
        ["Crystal Force"] = "Кристалл силы духа",
        ["Crystal Restore"] = "Кристалл Восстановления",
        ["Crystal Spire"] = "Кристальная Спираль",
        ["Crystal Ward"] = "Кристалл-хранитель",
        ["Crystal Yield"] = "Кристалл-губитель",
        ["Crystals of Power"] = "Кристаллы Силы",
        ["Cuergo's Gold"] = "Золото Куэрго",
        ["Culinary Crunch"] = "Хрустящий деликатес",
        ["Culling the Flutterers"] = "Ловля бражников",
        ["Culling the Threat"] = "Устранение угрозы",
        ["Culling the Wild"] = "Зачистка пустоши",
        ["Curbing the Plague"] = "Обуздание заразы",
        ["Curing the Sick"] = "Исцеление больных",
        ["Curse These Fat Fingers"] = "Отекшие пальцы",
        ["Curse of the Violet Tower"] = "Проклятие Фиолетовой Башни",
        ["Cursed Talismans"] = "Проклятые талисманы",
        ["Cutting Teeth"] = "Кабаньи клыки",
        ["Cutting Your Teeth"] = "Точи зубы!",
        ["Cutting a Path"] = "Зеленая улица",
        ["Cycle of Rebirth"] = "Цикл возрождения",
        ["Cyclonian"] = "Циклониан",
        ["Da Voodoo"] = "Вуду",
        ["Dadanga is Hungry!"] = "Даданга проголодалась!",
        ["Daelin's Men"] = "Солдаты Даэлина",
        ["Dagger of Veiled Shadows"] = "Кинжал Скрытых Теней",
        ["Daggerfen Deviance"] = "Искажение Кинжальной топи",
        ["Daily Delivery"] = "Отправка шкур",
        ["Dalar's Analysis"] = "Анализ Далара",
        ["Dalaran Patrols"] = "Даларанские патрули",
        ["Dalaran's Intentions"] = "Планы Даларана",
        ["Dalson's Tears Cauldron"] = "Котел Слез Далсона",
        ["Damaged Mask"] = "Поворежденная маска",
        ["Damning Evidence"] = "Надежное свидетельство",
        ["Dancing for Marzipan"] = "Танец за марципан",
        ["Dangerous!"] = "Вооружены и очень опасны!",
        ["Dangers of the Windfury"] = "Опасности Ярости Ветра",
        ["Dar'Khan's Lieutenants"] = "Приспешники Даркхана",
        ["Dark Council"] = "Темный совет",
        ["Dark Heart"] = "Темное сердце",
        ["Dark Iron Legacy"] = "Наследие Темной Стали",
        ["Dark Iron Scraps"] = "Пластины из темного железа",
        ["Dark Storms"] = "Темная Буря",
        ["Dark Tidings"] = "Темные вести",
        ["Dark Vessels"] = "Темные сосуды",
        ["Darkmoon Beast Deck"] = "Колода Животных Темной Луны",
        ["Darkmoon Elementals Deck"] = "Карты Темной Луны: стихии",
        ["Darkmoon Portals Deck"] = "Карты Темной Луны: порталы",
        ["Darkmoon Warlords Deck"] = "Карты Темной Луны: воины",
        ["Darnassian Intrusions"] = "Вторжение из Дарнасса",
        ["Data Rescue"] = "Спасение данных",
        ["Dawn's Gambit"] = "Рассветный гамбит",
        ["Deactivate An'owyn"] = "Отключка Ановина",
        ["Deactivating the Spire"] = "Отключить замок",
        ["Dead Man's Plea"] = "Просьба мертвеца",
        ["Dead-tooth Jack"] = "Джек Мертвозуб",
        ["Deadly Desert Venom"] = "Смертельный яд",
        ["Deadly Predators"] = "Смертельно опасные хищники",
        ["Deadmire"] = "Мертвая Топь",
        ["Deadwood of the North"] = "Беорны Мертвого леса",
        ["Deal With the Saboteurs"] = "Покончить с вредителями",
        ["Dealing with Zeb'Sora"] = "Неприятности в Зеб-Соре",
        ["Dealing with the Foreman"] = "Покончить со старшиной",
        ["Dealing with the Overmaster"] = "Покончить с Подчинителем",
        ["Dearest Natalia"] = "Дражайшая Наталиа",
        ["Death From Below"] = "Смерть со дна морского",
        ["Death's Door"] = "Врата Смерти",
        ["Death's Embrace"] = "Объятия смерти",
        ["Deathdealer's Boots"] = "Сапоги Смертеторговца",
        ["Deathdealer's Helm"] = "Большой шлем Смертеторговца",
        ["Deathdealer's Vest"] = "Жилет Смертеторговца",
        ["Deaths in the Family"] = "Смерти в семье",
        ["Deathstalkers in Shadowfang"] = "Пропавшие Странники смерти",
        ["Deceive thy Enemy"] = "Обмануть врага",
        ["Decipher the Tome"] = "Секрет фолианта",
        ["Deciphering the Book"] = "Расшифровка книги",
        ["Declaration of Power"] = "Демонстрация силы",
        ["Decoy!"] = "Утка!",
        ["Deep Cover"] = "Надежное прикрытие",
        ["Deep Sea Salvage"] = "Поиски на глубине",
        ["Deepmoss Spider Eggs"] = "Яйца мохового паука",
        ["Deeprun Rat Roundup"] = "Охота на крыс",
        ["Defeat Nek'rosh"] = "Вождь Некрош",
        ["Defenders of Darrowshire"] = "Защитники Дарроушира",
        ["Defending Fairbreeze Village"] = "Оборона деревни Легкий Ветерок",
        ["Defiler's Basic Care Package"] = "Полевой комплект Осквернителей",
        ["Defiler's Standard Care Package"] = "Стандартный полевой комплект Осквернителей",
        ["Defiling Uther's Tomb"] = "Осквернение гробницы Утера",
        ["Deliver Them From Evil..."] = "Избавь их от лукавого...",
        ["Deliver Thomas' Report"] = "Донесение Томаса",
        ["Deliver the Gems"] = "Принести самоцветы",
        ["Deliver the Plans to An'telas"] = "Донесение в Антелас",
        ["Deliver the Shipment"] = "Доставка груза",
        ["Deliver the Thread"] = "Доставка ниток",
        ["Deliver to MacKinley"] = "Ром для МакКинли",
        ["Deliveries to Sven"] = "Припасы для Свена",
        ["Delivering Daffodils"] = "Доставка нарциссов",
        ["Delivering the Message"] = "Передать послание",
        ["Delivering the Relic"] = "Доставка реликвии",
        ["Delivery for Marin"] = "Посылка для Синя",
        ["Delivery to Andron Gant"] = "Доставка Андрону Ганту",
        ["Delivery to Archmage Xylem"] = "Доставка верховному магу Ксилему",
        ["Delivery to Jes'rimon"] = "Доставка Джесримону",
        ["Delivery to Magatha"] = "Доставка Магате",
        ["Delivery to Ridgewell"] = "Доставить Риджвеллу",
        ["Delivery to Silverpine Forest"] = "Доставка в Сребролесье",
        ["Delivery to Tranquillien"] = "Посылка в Транкивиллион",
        ["Delivery to the Gnomes"] = "Заказ гномов",
        ["Delivery to the North Sanctum"] = "Послание в Северное святилище",
        ["Delivery to the Sepulcher"] = "Посылка в Гробницу",
        ["Demon Dogs"] = "Псы-демоны",
        ["Demonic Contamination"] = "Распространение демонической скверны",
        ["Demonic Crystal Prisons"] = "Тюрьма из демонических кристаллов",
        ["Desert Recipe"] = "Блюдо из червей",
        ["Desperate Prayer"] = "Отчаянная молитва",
        ["Destiny Calls"] = "Зов судьбы",
        ["Destroy Morphaz"] = "Уничтожить Морфаза",
        ["Destroy Naberius!"] = "Уничтожить Набериуса!",
        ["Destroy the Legion"] = "Уничтожить Легион!",
        ["Deviate Eradication"] = "Искоренение Скверны",
        ["Deviate Hides"] = "Скверная шкура",
        ["Devils in Westfall"] = "Демоны в Вестфоле",
        ["Devourer of Souls"] = "Пожирательница душ",
        ["Devouring Plague"] = "Всепожирающая чума",
        ["Diabolical Plans"] = "Демонические планы",
        ["Diagnosis: Critical"] = "Диагноз: критический",
        ["Diaphanous Wings"] = "Прозрачные крылья",
        ["Did You Get The Note?"] = "Где записка?",
        ["Did You Lose This?"] = "Не ее ли ищете?",
        ["Dig Rat Stew"] = "Крысиная похлебка",
        ["Digging Through Bones"] = "Костяные раскопки",
        ["Digging Through the Dirt"] = "Разрытая могила",
        ["Digging Through the Ooze"] = "Прожорливый слизнюк",
        ["Digging for Prayer Beads"] = "Откопать благословеные четки.",
        ["Dimensius the All-Devouring"] = "Дименсий Всепоглощающий",
        ["Diplomatic Measures"] = "Дипломатическая миссия",
        ["Dirge's Kickin' Chimaerok Chops"] = "Отбивные из химеры",
        ["Discover Rolf's Fate"] = "Судьба Рольфа",
        ["Disharmony of Fire"] = "Дисгармония Пламени",
        ["Disharmony of Flame"] = "Дисгармония Пламени",
        ["Dispelling Evil"] = "Борьба со злом",
        ["Disrupt Their Reinforcements"] = "Лишить Легион подкрепления!",
        ["Disrupt the Attacks"] = "Прекратить набеги",
        ["Disruption - Forge Camp: Mageddon"] = "Уничтожение - Кузнечный лагерь: Магеддон.",
        ["Distracting Jarven"] = "Отвлечь Джарвена",
        ["Distraction at Manaforge B'naar"] = "Отвлекающий маневр в Кузне маны Б'наар",
        ["Disturbance at Umbrafen Lake"] = "Неприятности на озере Болотной тени",
        ["Divination: Gorefiend's Armor"] = "Прорицание: Броня Жестокосердного.",
        ["Divination: Gorefiend's Cloak"] = "Прорицание: Плащ Жестокосердного.",
        ["Divination: Gorefiend's Truncheon"] = "Прорицание: Жезл Жестокосердного.",
        ["Divine Retribution"] = "Божественное воздаяние",
        ["Divino-matic Rod"] = "Изыскательский стержень",
        ["Do My Eyes Deceive Me"] = "Не верь глазам своим",
        ["Dogran's Captivity"] = "Догран в плену",
        ["Dolanaar Delivery"] = "Посылка в Доланаар",
        ["Doling Justice"] = "Небольшое возмездие",
        ["Don't Drink the Water"] = "Не пей эту воду!",
        ["Don't Kill the Fat One"] = "Толстяка не убивать",
        ["Doom Weed"] = "Погибельник",
        ["Doomcaller's Circlet"] = "Венец Призывателя рока",
        ["Doomcaller's Footwraps"] = "Обмотки Призывателя рока",
        ["Doomcaller's Mantle"] = "Оплечье Призывателя Рока",
        ["Doomrigger's Clasp"] = "Пряжка Роковой оснастки",
        ["Doomsday Candle"] = "Свеча Судного Дня",
        ["Doorway to the Abyss"] = "Дверь в Бездну",
        ["Doras the Wind Rider Master"] = "Дорес - мастер Крыла Ветра",
        ["Dousing the Flames of Protection"] = "Погасить Пламя Защиты",
        ["Down With Daellis"] = "Покончить с Даэллисом",
        ["Down at the Docks"] = "В порту",
        ["Down the Coast"] = "На побережье",
        ["Down the Dead Scar"] = "По Тропе Мертвых",
        ["Down the Scarlet Path"] = "По пути Алых",
        ["Dr. Boom!"] = "Доктор Бум!",
        ["Draconic for Dummies"] = "Драконий язык для чайников",
        ["Draenethyst Crystals"] = "Кристаллы дренейского аметиста",
        ["Dragonkin Menace"] = "Драконья угроза",
        ["Dragonmaw Shinbones"] = "Берцовые кости",
        ["Dragonscale Leatherworking"] = "Школа Дракона",
        ["Drain Schematics"] = "Схема системы осушения",
        ["Drakefire Amulet"] = "Амулет Пламени дракона",
        ["Drape of Unyielding Strength"] = "Пелерина Неукротимой силы",
        ["Drape of Vaulted Secrets"] = "Пелерина Погребенных тайн",
        ["Dreadmaul Rock"] = "Скала Молота Ужаса",
        ["Dreadnaught Bracers"] = "Боевые браслеты Дредноута",
        ["Dreadnaught Breastplate"] = "Кираса Дредноута",
        ["Dreadnaught Gauntlets"] = "Латные рукавицы Дредноута",
        ["Dreadnaught Helmet"] = "Шлем Дредноута",
        ["Dreadnaught Legplates"] = "Латные поножи Дредноута",
        ["Dreadnaught Pauldrons"] = "Оплечье Дредноута",
        ["Dreadnaught Sabatons"] = "Башмаки Дредноута",
        ["Dreadnaught Waistguard"] = "Воинский пояс Дредноута",
        ["Dreadsteed of Xoroth"] = "Погибельный конь Зорота",
        ["Dream Dust in the Swamp"] = "Сонная пыль в болоте",
        ["Dreamwalker Boots"] = "Сапоги сновидца",
        ["Dreamwalker Girdle"] = "Тесьма сновидца",
        ["Dreamwalker Handguards"] = "Боевые краги сновидца",
        ["Dreamwalker Headpiece"] = "Головной убор сновидца",
        ["Dreamwalker Legguards"] = "Набедренники сновидца",
        ["Dreamwalker Spaulders"] = "Бармы сновидца",
        ["Dreamwalker Tunic"] = "Туника сновидца",
        ["Dreamwalker Wristguards"] = "Запястья сновидца",
        ["Dressing the Part"] = "Костюм пирата",
        ["Driftwood"] = "Плавник",
        ["Drijya Needs Your Help"] = "Дризье нужна твоя помощь",
        ["Drill the Drillmaster"] = "Перемастерить мастера",
        ["Drowned Sorrows"] = "Затонувшие печали",
        ["Druid of the Claw"] = "Друид-медведь",
        ["Dry Times"] = "Засуха",
        ["Duke Nicholas Zverenhoff"] = "Герцог Николас Зверенхофф.",
        ["Dumphry's Request"] = "Просьба Болтуя",
        ["Dungar Longdrink"] = "Дунгар Долгопой",
        ["Dusky Crab Cakes"] = "Темные пирожки с крабами",
        ["Dust from the Drakes"] = "Пыльца волшебных драконов",
        ["Dwarven Digging"] = "Дворфийские делишки",
        ["Dwarven Justice"] = "Правосудие дворфов",
        ["Dwarven Outfitters"] = "Гномы-экипировщики",
        ["Eagan Peltskinner"] = "Эоган Меховщик",
        ["Earthen Arise"] = "Пробуждение земельника",
        ["Earthen Templar"] = "Земной храмовник",
        ["Earthshatter Boots"] = "Сапоги Землекрушителя",
        ["Easy Strider Living"] = "Спокойная жизнь долгоногов",
        ["Eating Damnation"] = "Попробовать зло на зуб",
        ["Echeyakee"] = "Эчеяки",
        ["Echoes of War"] = "Отголоски войны",
        ["Egg Collection"] = "Сбор яиц",
        ["Egg Freezing"] = "Заморозка яйца",
        ["Egg Hunt"] = "Охота за яйцами",
        ["Eight-Legged Menaces"] = "Битва с пауками",
        ["Eitrigg's Wisdom"] = "Мудрость Эйтригга",
        ["Elanaria"] = "Эланария",
        ["Electro-Shock Goodness!"] = "Слава электрошоку!",
        ["Electropellers"] = "Электропеллеры",
        ["Elekks Are Serious Business"] = "Элекки - это серьезно",
        ["Elemental Bracers"] = "Боевые браслеты Стихий",
        ["Elemental Leatherworking"] = "Школа Стихии",
        ["Elemental Power Extraction"] = "Извлечение силы Стихии",
        ["Elemental War"] = "Война духов Стихий",
        ["Elixir of Agony"] = "Эликсир Агонии",
        ["Elixir of Pain"] = "Эликсир Боли",
        ["Elixir of Suffering"] = "Эликсир Страдания",
        ["Elixirs for the Bladeleafs"] = "Эликсиры для клана Режущего Листа",
        ["Elmore's Task"] = "Просьба Альмора",
        ["Elune's Tear"] = "Слеза Элуны",
        ["Elven Legends"] = "Эльфийские легенды",
        ["Emberstrife"] = "Алый Уголь",
        ["Emphasis on Sacrifice"] = "Жертва необходима",
        ["Empty Stables"] = "Пустые стойла",
        ["En-Ay-Es-Tee-Why"] = "Товар на любителя",
        ["Enchanted Azsharite Fel Weaponry"] = "Зачарованное азаритовое оружие, отравленное Скверной",
        ["Enchanted Thorium Platemail: Volume I"] = "Заколдованная ториевая броня, том I",
        ["Enchanted Thorium Platemail: Volume II"] = "Заколдованная ториевая броня, том II",
        ["Enchanted Thorium Platemail: Volume III"] = "Заколдованная ториевая броня, том III",
        ["Encoded Fragments"] = "Зашифрованные фрагменты",
        ["Encroaching Gnolls"] = "Вторжение гноллов",
        ["Encroaching Wildlife"] = "Атака тварей",
        ["Encroachment"] = "Завоевание",
        ["Encrusted Tail Fins"] = "Средство против трения",
        ["Encrypted Letter"] = "Зашифрованное письмо",
        ["Encrypted Memorandum"] = "Зашифрованная памятная записка",
        ["Encrypted Parchment"] = "Исписанный пергамент",
        ["Encrypted Rune"] = "Зашифрованная руна",
        ["Encrypted Scroll"] = "Зашифрованный свиток",
        ["Encrypted Sigil"] = "Зашифрованный знак",
        ["Encrypted Tablet"] = "Табличка с письменами",
        ["Encrypted Twilight Texts"] = "Зашифрованные Сумеречные тексты",
        ["Ending Their World"] = "Отречемся от старого мира",
        ["Ending the Bloodcurse"] = "Избавление от проклятья",
        ["Enemy Booty"] = "Вражеский трофей",
        ["Enemy of my Enemy..."] = "Враг моего врага...",
        ["Enigma Boots"] = "Сапоги Таинства",
        ["Enigma Circlet"] = "Венец Таинства",
        ["Enigma Shoulderpads"] = "Наплечные пластины Таинства",
        ["Enraged Spirits"] = "Разъяренные духи",
        ["Enraged Spirits of Air"] = "Разъяренные духи Воздуха",
        ["Enraged Spirits of Fire and Earth"] = "Разъяренные духи Огня и Земли",
        ["Enraged Spirits of Water"] = "Разъяренные Духи Воды",
        ["Enraged Thunder Lizards"] = "Разъяренная гигантская ящерица",
        ["Enraged Wildkin"] = "Обезумевшие совиные медведи",
        ["Enticing Negolash"] = "Приманка для Неголаша",
        ["Entry Into Karazhan"] = "Вход в Каражан",
        ["Entry Into the Citadel"] = "Вход в цитадель",
        ["Envoy to the Mag'har"] = "Посол в Маг'хар",
        ["Epic Armaments of Battle - Exalted Amongst the Dawn"] = "Легендарное боевое снаряжение - Восторг Рассвета",
        ["Eradicate the Burning Legion"] = "Истребить Пылающий Легион под корень",
        ["Erion Shadewhisper"] = "Эрион Тенешепот",
        ["Erion's Behest"] = "Директива Эриона",
        ["Errand for Apothecary Zinge"] = "Посылка для аптекаря Зинг",
        ["Escape Through Force"] = "Спасение с помощью силы",
        ["Escape Through Stealth"] = "Спасение с помощью скрытности",
        ["Escape from Durnholde"] = "Побег из Дернхольда",
        ["Escape from Firewing Point!"] = "Побег с пика Огненных Крыльев",
        ["Escape from Umbrafen"] = "Спасение с озера Болотной тени",
        ["Escape from the Catacombs"] = "Бегство из Катакомб",
        ["Escape from the Staging Grounds"] = "Побег с полигона",
        ["Escaping the Tomb"] = "Побег из гробницы",
        ["Escorting Erland"] = "Сопровожая Эрланда",
        ["Essence for the Engines"] = "Эссенция для двигателей",
        ["Essence of the Exile"] = "Субстанция Изгнанников",
        ["Essential Artificials"] = "Базовый элемент",
        ["Establishing New Outposts"] = "Новые форпосты",
        ["Etched Note"] = "Нацарапанная записка",
        ["Etched Parchment"] = "Пергамент с письменами",
        ["Etched Rune"] = "Гравированная руна",
        ["Etched Sigil"] = "Гравированный знак",
        ["Etched Tablet"] = "Каменная табличка",
        ["Ethereum Data"] = "Данные Братства Астрала",
        ["Evershine"] = "\"Вечное сияние\"",
        ["Everything Counts In Large Amounts"] = "Счет идет на большие числа",
        ["Everything Will Be Alright"] = "Everything Will Be Alright",
        ["Evil Bat Eyes"] = "Глаза злобных летучих мышей",
        ["Evil Draws Near"] = "Зло приближается",
        ["Examine the Vessel"] = "Сосуд Возрождения",
        ["Excavation Progress Report"] = "Отчет о ходе раскопок",
        ["Excelsior"] = "Превосходство",
        ["Exorcising Terrordale"] = "Изгнание призраков из Дола Ужаса",
        ["Exorcising the Trees"] = "Экзорцизм для деревьев",
        ["Expedition Point"] = "Пик Экспедиции",
        ["Expedition Salvation"] = "Спасение экспедиции",
        ["Expert Blacksmith!"] = "Кузнец-эксперт!",
        ["Extinguish the Firegut"] = "Угасание Огненного Чрева",
        ["Extinguishing the Idol"] = "Уничтожить идола",
        ["Eye of the Emberseer"] = "Око Углеглаза",
        ["Ezekiel"] = "Иезекииль",
        ["FIFTY! YEP!"] = "ПЯТЬДЕСЯТ! АГА!",
        ["Faerie Dragon Muisek"] = "Уменьшенный лесной дракончик",
        ["Failed Incursion"] = "Провалившийся рейд",
        ["Fairbreeze Village"] = "Деревня Легкий Ветерок",
        ["Falcon Watch"] = "Соколиный Дозор",
        ["Falcon's Call"] = "Зов Сокола",
        ["Fall From Grace"] = "Попавший в немилость",
        ["Fall of Dun Modr"] = "Падение Дун Модра",
        ["Fallen Sky Lake"] = "Озеро Упавшего Неба",
        ["Fallen Sky Lords"] = "Свергнутые властители небес",
        ["Falling to Corruption"] = "Поддавшиеся порче",
        ["Falrin's Vendetta"] = "Кровная месть Фарлина",
        ["Familiar Fungi"] = "Знакомые грибы",
        ["Family Tree"] = "Семейное древо",
        ["Farren's Proof"] = "Доказательство Фаррена",
        ["Farstrider Retreat"] = "Приют Странников",
        ["Favor of the Gronn"] = "Благоволение гронна",
        ["Favored of Elune?"] = "Любимцы Элуны?",
        ["Feast at the Blue Recluse"] = "Праздник в \"Голубом Отшельнике\"",
        ["Featherbeard's Endorsement"] = "Встреча с Перобородом",
        ["Feathermoon Stronghold"] = "Крепость Лунного Пера",
        ["Feathers for Grazle"] = "Перья для Гразла",
        ["Feathers for Nafien"] = "Перья для Нафиэна",
        ["Fei Fei's Treat"] = "Собачья радость",
        ["Fel Armaments"] = "Латные перчатки Скверны",
        ["Fel Embers"] = "Угли Скверны",
        ["Fel Orc Plans"] = "Планы орков Скверны",
        ["Fel Orc Scavengers"] = "Падальщики орков Скверны",
        ["Fel Spirits"] = "Духи Скверны",
        ["Felbound Ancients"] = "Дерева в узах скверны",
        ["Felendren the Banished"] = "Фелендрен Изгой",
        ["Felling an Ancient Tree"] = "Свалить ходячее древо!",
        ["Felnok Steelspring"] = "Фелнок Стальная Пружина",
        ["Felspark Ravine"] = "Лощина Адской Искры",
        ["Felstone Field Cauldron"] = "Котел поля Фелстоун",
        ["Felsworn Gas Mask"] = "Респиратор Искаженных",
        ["Fenwick Thatros"] = "Фенвик Татрос",
        ["Feralas: A History"] = "\"История Фераласа\"",
        ["Ferocitas the Dream Eater"] = "Фероситас Пожиратель Снов",
        ["Fertile Spores"] = "Прорастающие споры",
        ["Fetch!"] = "Апорт!",
        ["Field Duty"] = "Рутинное задание",
        ["Fields of Grief"] = "Поля Горя",
        ["Fierce Enemies"] = "Лютые враги",
        ["Fiery Blaze Enchantments"] = "Пылающее заклятье",
        ["Fiery Menace!"] = "Огненная угроза",
        ["Fiery Plate Gauntlets"] = "Огненные пластинчатые латные рукавицы",
        ["Filling the Soul Gem"] = "Наполнение самоцвета Души",
        ["Filthy Paws"] = "Грязные лапы",
        ["Final Passage"] = "Финальное испытание",
        ["Final Preparations"] = "Последние приготовления",
        ["Find Acteon!"] = "Поиски Актеона",
        ["Find Agmond"] = "Найти Эгмонда",
        ["Find Bingles"] = "Найти Бинглза",
        ["Find Keltus Darkleaf"] = "Найти Келтуса Темного Листа",
        ["Find Myranda"] = "Найти Миранду",
        ["Find OOX-09/HL!"] = "Найти OOX-09/HL!",
        ["Find OOX-17/TN!"] = "Найди OOX-17/TN!",
        ["Find OOX-22/FE!"] = "Найти OOX-22/FE!",
        ["Find Ranshalla"] = "В поисках Раншаллы",
        ["Find Spy To'gun"] = "Найти шпиона То-гуна!",
        ["Find the Deserter"] = "Найти дезертира",
        ["Find the Gems"] = "Время собирать камни",
        ["Find the Gems and Power Source"] = "Найти самоцветы и источник энергии",
        ["Find the Lost Guards"] = "Пропавшие стражи",
        ["Find the Shattered Hand"] = "Поиски Раздробленной Руки",
        ["Finding the Antidote"] = "Поиски противоядия",
        ["Finding the Keymaster"] = "Найти Хранителя Ключей",
        ["Finding the Shadowy Figure"] = "Поиски таинственного незнакомца",
        ["Finding the Source"] = "Найти источник",
        ["Finding the Survivors"] = "Спасательная экспедиция",
        ["Fine Gold Thread"] = "Нить из чистого золота",
        ["Fiora Longears"] = "Фиора Длинноушка",
        ["Fire At Will!"] = "Стрелять по готовности!",
        ["Fire Hardened Mail"] = "Закаленный доспех",
        ["Fire Plume Forged"] = "Кузня Пламенного хребта",
        ["Fire Sapta"] = "Сапта огня",
        ["Fire Taboo"] = "Запрет на огонь",
        ["Firewing Signets"] = "Перстни Огненных Крыльев",
        ["Fish in a Bucket"] = "Рыбка в ведерке",
        ["Flash Bomb Recipe"] = "Секрет изготовления световой бомбы",
        ["Flawed Power Stone"] = "Камень силы с изъяном",
        ["Flawless Fel Essence"] = "Безупречная субстанция Скверны",
        ["Flexing for Nougat"] = "Поиграй мускулами!",
        ["Flight to Auberdine"] = "Полет в Аубердин",
        ["Flint Shadowmore"] = "Флинт Тенемор",
        ["Flora of the Eco-Domes"] = "Растительность Эко-Сфер",
        ["Flute of Xavaric"] = "Флейта Ксаварика",
        ["Fly to Silvermoon City"] = "Полет в Луносвет",
        ["Follow the Breadcrumbs"] = "Иди по крошечкам!",
        ["Food for Baby"] = "Покормить малыша",
        ["Footwraps of the Oracle"] = "Обмотки Оракула",
        ["For All To See"] = "На виду у всех",
        ["For Great Honor"] = "Ради славы",
        ["For Love Eternal"] = "Во имя вечной любви",
        ["For The Horde!"] = "Во имя Орды!",
        ["For the Fallen"] = "За павших",
        ["Forbidden Knowledge"] = "Запретное знание",
        ["Force Commander Danath"] = "Боевой командир Данат",
        ["Forces of Jaedenar"] = "Силы Джеденара",
        ["Foreboding Plans"] = "Зловещие планы",
        ["Forge Camp: Annihilated"] = "Кузнечный лагерь: приказано уничтожить",
        ["Forge Camp: Mageddon"] = "Кузнечный лагерь: Магеддон",
        ["Forged Steel"] = "Стальные слитки",
        ["Forging the Mightstone"] = "Создание камня силы",
        ["Forging the Shaft"] = "Древко факела",
        ["Forging the Weapon"] = "Ковка оружия",
        ["Forgotten Rituals"] = "Забытые обряды",
        ["Formal Introductions"] = "Формальное представление",
        ["Foror's Compendium"] = "Справочник Форора",
        ["Forsaken Aid"] = "Помощь Отрекшихся",
        ["Forsaken Diseases"] = "Чума Отрекшихся",
        ["Forsaken Duties"] = "Обязанности Отрекшихся",
        ["Forward Base: Reaver's Fall"] = "Передовая застава: Гибель Разрушителя",
        ["Foul Magics"] = "Зловещая магия",
        ["Fouled Water Spirits"] = "Смрадные духи воды",
        ["Fragmented Magic"] = "Частицы магии",
        ["Fragments of the Orb of Orahil"] = "Части шара Орахила",
        ["Fragments of the Past"] = "Фрагменты прошлого",
        ["Frame of Atiesh"] = "Основа Атиеша",
        ["Free From the Hold"] = "Свобода!",
        ["Free at Last"] = "Долгожданная свобода",
        ["Freed from the Hive"] = "Освобожденный из улья",
        ["Freedom for All Creatures"] = "Свободу всем живым существам!",
        ["Freedom to Ruul"] = "Свободу Руулу!",
        ["Fresh Meat"] = "Свежее мясо",
        ["Fresh from the Mechanar"] = "Новинка из Механара",
        ["From The Wreckage...."] = "Обломки кораблекрушения",
        ["From the Abyss"] = "Из Бездны",
        ["From the Ashes"] = "Восстать из пепла",
        ["Frostfire Belt"] = "Пояс Ледяного Пламени",
        ["Frostfire Bindings"] = "Поручья Ледяного Пламени",
        ["Frostfire Circlet"] = "Венец Ледяного Пламени",
        ["Frostfire Gloves"] = "Перчатки Ледяного Пламени",
        ["Frostfire Leggings"] = "Поножи Ледяного Пламени",
        ["Frostfire Robe"] = "Одеяние Ледяного Пламени",
        ["Frostfire Sandals"] = "Сандалии Ледяного Пламени",
        ["Frostfire Shoulderpads"] = "Наплечные пластины Ледяного Пламени",
        ["Frostmane Hold"] = "Форт Снежной Гривы",
        ["Frostmaul E'ko"] = " Камень э'ко из племени Ледяного Молота",
        ["Frostmaw"] = "Ледяная Пасть",
        ["Frostsaber E'ko"] = " Камень Э'ко саблезубов",
        ["Frostsaber Provisions"] = "Накормить саблезубов",
        ["Fruit of the Sea"] = "Дары моря",
        ["Fuel for the Zapping"] = "Энергия для уменьшения",
        ["Fulgor Spores"] = "Споры гриба-блескуна",
        ["Full Triangle"] = "Полный треугольник",
        ["Fumping"] = "Стук барабана",
        ["Fungal Spores"] = "Споры грибов",
        ["Furlbrow's Deed"] = "Документ Хмуроброва",
        ["Further Concerns"] = "Новые заботы",
        ["Further Corruption"] = "Снова порча!",
        ["Further Instructions"] = "Дальнейшие указания",
        ["Further Mysteries"] = "Все больше тайн",
        ["Gadgetzan Water Survey"] = "Исследование воды",
        ["Gaffer Jacks"] = "Суперразъемы",
        ["Gahrron's Withering Cauldron"] = "Котел пустоши Гаррона",
        ["Gahz'ridian"] = "Газриллийские украшения",
        ["Gahz'rilla"] = "Газ'рилла",
        ["Gaining Acceptance"] = "Завоевать благосклонность",
        ["Gaining Access"] = "Получение доступа",
        ["Gaining Mirren's Trust"] = "Доверие Миррена",
        ["Gakin's Summons"] = "Приглашение Гакина",
        ["Galaen's Fate"] = "Судьба Галена",
        ["Galaen's Journal - The Fate of Vindicator Saruan"] = "Дневник Галена: судьба поборника Саруана",
        ["Galen's Escape"] = "Побег Галена",
        ["Galgar's Cactus Apple Surprise"] = "Яблочный сюрприз Галгара",
        ["Galvan's Finest Pupil"] = "Лучший ученик Гальвана",
        ["Gan'rul's Summons"] = "Вызов от Гарнула",
        ["Gann's Reclamation"] = "Ответный удар Ганна",
        ["Garments of Spirituality"] = "Одеяния духовности",
        ["Garments of the Light"] = "Облачение Света",
        ["Garments of the Moon"] = "Облачение Луны",
        ["Garona: A Study on Stealth and Treachery"] = "Гарона: Исследование уловок и предательства",
        ["Gateway to the Frontier"] = "Врата пограничья",
        ["Gather Rot Blossoms"] = "Сбор цветков гнили",
        ["Gather the Orbs"] = "Собрать шары",
        ["Gathering Idols"] = "Сбор идолов",
        ["Gathering Leather"] = "Добывание шкур",
        ["Gathering Materials"] = "Сбор материалов",
        ["Gathering the Cure"] = "Сбор лекарственных ингредиентов",
        ["Gathering the Reagents"] = "Собирание реагентов",
        ["Gauging the Resonant Frequency"] = "Калибровка резонансной частоты",
        ["Gava'xi"] = "Гавакси",
        ["Gavel of Infinite Wisdom"] = "Молоток Беспредельной мудрости",
        ["Gearing Redridge"] = "Зачистка Красных гор",
        ["Gelkis Alliance"] = "Союз с кланом Джелкис",
        ["General Drakkisath's Command"] = "Приказ генерала Драккисата",
        ["General Drakkisath's Demise"] = "Кончина генерала Драккисата",
        ["Genesis Boots"] = "Сапоги Бытия",
        ["Genesis Helm"] = "Большой шлем Бытия",
        ["Genesis Shoulderpads"] = "Наплечные пластины Бытия",
        ["Genesis Trousers"] = "Брюки Бытия",
        ["Genesis Vest"] = "Жилет Бытия",
        ["Gerenzo Wrenchwhistle"] = "Геренцо Тоскливый Свист",
        ["Gerenzo's Orders"] = "Приказы Геренцо",
        ["Get Me Out of Here!"] = "Вытащи меня отсюда!",
        ["Get the Gnomes Drunk"] = "Напоить гномов",
        ["Get the Goblins Drunk"] = "Напоить гоблинов",
        ["Get the Scoop"] = "Волшебное слово",
        ["Getting Down to Business"] = "Деловая активность",
        ["Getting the Bladespire Tanked"] = "Пусть Стальные Иглы упьются!",
        ["Ghost Hair Thread"] = "Нить из призрачных волос",
        ["Ghost-o-plasm Round Up"] = "Сбор эктоплазмы",
        ["Ghoulish Effigy"] = "Фигурка вурдалака",
        ["Give Gerard a Drink"] = "Жажда Джерарда",
        ["Gizelton Caravan"] = "Караван Гизлтона",
        ["Gizmo for Warug"] = "Игрушка для Варуга",
        ["Glowcap Mushrooms"] = "Грибы-пламеневики",
        ["Glowing Scorpid Blood"] = "Светящаяся кровь скорпида",
        ["Glyphed Oaken Branch"] = "Покрытая письменами дубовая ветвь",
        ["Glyphic Letter"] = "Символьное письмо",
        ["Glyphic Memorandum"] = "Памятная записка мага",
        ["Glyphic Scroll"] = "Свиток, покрытый письменами",
        ["Glyphic Tablet"] = "Табличка с тайными знаками",
        ["Gnarlpine Corruption"] = "Порча Кривой Сосны",
        ["Gnogaine"] = "Новая формула",
        ["Gnome Engineering"] = "Гномская механика",
        ["Gnome Improvement"] = "Гномское усовершенствование",
        ["Gnomer-gooooone!"] = "Поехалиии!",
        ["Go to the Front"] = "Отправка на фронт",
        ["Goblin Invaders"] = "Вторжение гоблинов",
        ["Goblin Sponsorship"] = "Поддержка гоблинов",
        ["Gol'dir"] = "Голдир",
        ["Gold Dust Exchange"] = "Золотая пыль",
        ["Goldenmist Village"] = "Деревня Золотой Туман",
        ["Goldleaf's Discovery"] = "Открытие Золотого Листа",
        ["Goldtooth"] = "Золотой зуб",
        ["Good Luck Charm"] = "Оберег Удачи",
        ["Good Natured Emma"] = "Добросердечная Эмма",
        ["Goods from Silvermoon City"] = "Товары из Луносвета",
        ["Gor'tesh the Brute Lord"] = "Гортеш Жестокий",
        ["Gordo's Task"] = "Задание Гордо",
        ["Gordunni Cobalt"] = "Кобальт Хордунни",
        ["Goretusk Liver Pie"] = "Пирог с печенью сквернохряка",
        ["Gorgrom the Dragon-Eater"] = "Горгром Драконоед",
        ["Grand Master Dumphry"] = "Великий Мастер Болтуй",
        ["Grand Master Rohok"] = "Великий мастер Рохок",
        ["Grape Manifest"] = "Уведомление о поставке винограда",
        ["Grark Lorkrub"] = "Грарк Лоркруб",
        ["Graverobbers"] = "Грабители могил",
        ["Greatfather Winter is Here!"] = "Здравствуй, Зимний дед!",
        ["Greed"] = "Жадность",
        ["Green Fireworks"] = "Зеленые петарды",
        ["Green Iron Bracers"] = "Зеленые железные боевые браслеты",
        ["Grey Iron Weapons"] = "Оружие из серой стали",
        ["Grillok \"Darkeye\""] = "Гриллок \"Пустой Глаз\"",
        ["Grim Message"] = "Предупреждение",
        ["Grimand Elmore"] = "Гриманд Альмор",
        ["Grimand's Armor"] = "Доспехи Гриманда",
        ["Grimand's Finest Work"] = "Шедевр Гриманда",
        ["Grime-Encrusted Ring"] = "Кольцо, покрытое грязью",
        ["Grimscale Pirates!"] = "На помощь! Пираты!",
        ["Grimtotem Spying"] = "Наблюдение за Мрачным Тотемом",
        ["Grove of the Ancients"] = "Роща Древних",
        ["Gryphon Master Talonaxe"] = "Дрессировщик грифонов Разящий Коготь",
        ["Gryth Thurden"] = "Грит Турден",
        ["Guarded Thunderbrew Barrel"] = "Охраняемый бочонок Громопойла",
        ["Guardians of the Altar"] = "Стражи алтаря",
        ["Guarding Secrets"] = "Умение хранить секреты",
        ["Guile of the Raptor"] = "Коварство ящера",
        ["Gurf's Dignity"] = "Клок шерсти Гурфа",
        ["Gurok the Usurper"] = "Гурок Захватчик",
        ["Gyro... What?"] = "Гиро...чего?",
        ["Gyrodrillmatic Excavationators"] = "Сооружение автогиробуророек",
        ["Gyromast's Retrieval"] = "Помощь Штурману",
        ["Gyromast's Revenge"] = "Месть Штурмана",
        ["HELP!"] = "НА ПОМОЩЬ!",
        ["Halgar's Summons"] = "Вызов Халгара",
        ["Hallow's End Treats for Jesper!"] = "Тыквовинское угощение для Джеспера",
        ["Hallow's End Treats for Spoops!"] = "Тыквовинское угощение для Спупс",
        ["Hallowed Letter"] = "Святое письмо",
        ["Hallowed Rune"] = "Благословенная руна",
        ["Hallowed Scroll"] = "Священный свиток",
        ["Hallowed Sigil"] = "Благословенный знак",
        ["Hallowed Tablet"] = "Освященная табличка",
        ["Hameya's Plea"] = "Мольба Хамейи",
        ["Hammerfall"] = "Упавший Молот",
        ["Hamuul Runetotem"] = "Хамуул Рунный Тотем",
        ["Hand of Iruxos"] = "Рука Ируксоса",
        ["Handle With Care"] = "Не кантовать!",
        ["Hands of the Enemy"] = "Руки врага",
        ["Harbinger of Doom"] = "Вестник Рока",
        ["Harbingers of Shadowmoon"] = "Вестники Лунной Тени",
        ["Hardened Shells"] = "Крепкие панцири",
        ["Harlan Needs a Resupply"] = "Харлан нуждается в помощи",
        ["Harnessing Shadows"] = "Укрощая тени",
        ["Harpies Threaten"] = "Угроза со стороны гарпий",
        ["Harpy Lieutenants"] = "Лейтенанты гарпий",
        ["Harpy Raiders"] = "Гарпии-налетчики",
        ["Harvesting the Fel Ammunition"] = "Боеприпасы Скверны",
        ["Have You Ever Seen One of These?"] = "Видали вы такое?",
        ["Haze of Evil"] = "Туман Зла",
        ["He Called Himself Altruis..."] = "Его звали Алтруис...",
        ["Healing the Lake"] = "Исцеление озера",
        ["Healthy Dragon Scale"] = "Здоровая чешуя дракона",
        ["Heart of Rage"] = "В сердце ярости",
        ["Hearts of Zeal"] = "Сердца Доблести",
        ["Hearts of the Pure"] = "Чистые сердца",
        ["Heartswood"] = "Сердцедрево",
        ["Heavy Grinding Stone"] = "Тяжелый точильный камень",
        ["Heirloom Weapon"] = "Фамильное оружие",
        ["Helcular's Revenge"] = "Месть Хелькулара",
        ["Hellfire Fortifications"] = "Штурмовые укрепления",
        ["Help Mama Wheeler"] = "Помочь Матушке Колесник",
        ["Help Ranger Valanna!"] = "Спасти следопыта Валанну!",
        ["Help Tavara"] = "Помощь Таваре",
        ["Help Watcher Biggs"] = "Помощь Смотрящему Биггсу",
        ["Helping the Cenarion Post"] = "Помощь Заставе Кенариуса",
        ["Helping the Lost Find Their Way"] = "Возвращение заблудших душ",
        ["Hemet Nesingwary Jr."] = "Хеминг Эрнестуэй младший",
        ["Hero of the Brood"] = "Герой драконьего племени",
        ["Hero of the Mag'har"] = "Герой магхаров",
        ["Hero of the Sin'dorei"] = "Герой синдореев",
        ["Hero of the Stormpike"] = "Герой Грозовой Вершины",
        ["Heroes of Darrowshire"] = "Герои Дарроушира",
        ["Heroes of Old"] = "Герои древних времен",
        ["Hex of Weakness"] = "Обессиливающий сглаз",
        ["Hezrul Bloodmark"] = "Хэрзул Пятно Крови",
        ["Hidden Enemies"] = "Тайные враги",
        ["Hidden Secrets"] = "Великие тайны",
        ["Hidden Treasures"] = "Спрятанные сокровища",
        ["High Chief Winterfall"] = "Верховный вождь Зимнего Сна",
        ["High Sorcerer Andromath"] = "Высший волшебник Андромах",
        ["High Value Targets"] = "Высокие цели",
        ["Highperch Venom"] = "Яд из Скального гнездовья",
        ["Hilary's Necklace"] = "Ожерелье Хилари",
        ["Hinott's Assistance"] = "Помощь Хинотта",
        ["Hints of a New Plague?"] = "Новая чума зарождается?",
        ["Hints of the Past"] = "Отблески былого",
        ["Hippogryph Master Stephanos"] = "Дрессировщик гиппогрифов Стефанос",
        ["Hippogryph Muisek"] = "Уменьшенный гиппогриф",
        ["Hitting the Motherlode"] = "Попасть на главную жилу",
        ["Hive'Ashi Scout Report"] = "Донесение разведчика из Хив'Аши",
        ["Hive'Regal Scout Report"] = "Донесение разведчика из Хив'Зора",
        ["Hive'Zora Scout Report"] = "Донесение разведчика из Хив'Зора",
        ["Hoary Templar"] = "Древний храмовник",
        ["Holy Bologna: What the Light Won't Tell You"] = "Святая Болонья: О чем не говорит Свет",
        ["Homeward Bound"] = "Путь домой",
        ["Honor Students"] = "Награды ученикам",
        ["Honor the Dead"] = "Почитание мертвых",
        ["Honor the Fallen"] = "Честь Павших",
        ["Honored Amongst the Clan"] = "Уважение клана",
        ["Honored Amongst the Guard"] = "Уважение Стражи",
        ["Honoring a Hero"] = "Почести герою",
        ["Hoodoo Hex"] = "Наговор худу",
        ["Horde Presence"] = "Мощь Орды",
        ["Horde Trauma"] = "Травматология",
        ["Horns of Frenzy"] = "Рога Безумия",
        ["Host of the Hidden City"] = "Хозяин Сокрытого Города",
        ["Hostile Takeover"] = "Недружественное поглощение",
        ["Hot Fiery Death"] = "Смерть в огне",
        ["Hotter than Hell"] = "Жарче, чем в пекле",
        ["Houses of the Holy"] = "Святая вода",
        ["How Big a Threat?"] = "Насколько велика угроза?",
        ["How to Break Into the Arcatraz"] = "Как проникнуть в Аркатраз",
        ["Howling in the Hills"] = "Вой в холмах",
        ["Humbert's Sword"] = "Меч Гумберта",
        ["Humble Beginnings"] = "Скромные дары прошлого",
        ["Hungry!"] = "Моя голодный!",
        ["Hunt for Yenniku"] = "Охота во имя Йеннику",
        ["Hunt the Savages"] = "Охота на дикарей",
        ["Hunting for Ectoplasm"] = "В поисках эктоплазмы",
        ["Hunting in Stranglethorn"] = "Охота в Долине Чародеев",
        ["Hurley Blackbreath"] = "Харли Темнодув",
        ["Hypercapacitor Gizmo"] = "Механизм гипервместимости",
        ["I Got Nothin' Left!"] = "С меня больше нечего взять!",
        ["I Know A Guy..."] = "Я знаю одного парня...",
        ["I Must Have Them!"] = "Я их достану!",
        ["I See Alcaz Island In Your Future..."] = "Я вижу остров Алькац...",
        ["I See Dead Draenei"] = "I See Dead Draenei",
        ["I Shoot Magic Into the Darkness"] = "Магия против Тьмы",
        ["I Was A Lot Of Things..."] = "Множество форм сменил я...",
        ["I Work... For the Horde!"] = "Я служу... Орде!",
        ["I'm Saved!"] = "Я спасена!",
        ["I've Got a Plant"] = "Созревший план",
        ["Ice Thistle E'ko"] = "Камень Э'ко племени Ледяного Осота",
        ["Identify Plant Parts"] = "Определение растений",
        ["Identifying the Brood"] = "Корни угрозы.",
        ["Idols of the Feralfen"] = "Идолы Зверотопи",
        ["Ignition"] = "Зажигание",
        ["Ill Omens"] = "Дурные предзнаменования",
        ["Illidan's Pupil"] = "Ученик Иллидана",
        ["Illidari-Bane Shard"] = "Осколок Проклятья Иллидари",
        ["Imbuing the Headpiece"] = "Пропитка набалдашника",
        ["Impending Attack"] = "Угроза нападения",
        ["Imperial Plate Armor"] = "Имперские латы",
        ["Imperial Plate Belt"] = "Императорский пластинчатый пояс",
        ["Imperial Plate Boots"] = "Императорские пластинчатые сапоги",
        ["Imperial Plate Bracer"] = "Императорские пластинчатые боевые браслеты",
        ["Imperial Plate Chest"] = "Императорское Зерцало",
        ["Imperial Plate Helm"] = "Императорский большой пластинчатый шлем",
        ["Imperial Plate Leggings"] = "Императорские пластинчатые поножи",
        ["Imperial Plate Shoulders"] = "Императорские пластинчатые наплечники",
        ["Imperial Qiraji Regalia"] = "Кирайские императорские регалии",
        ["Improved Quality"] = "Борьба за качество",
        ["In A Scrap With The Legion"] = "Легион - на мусор!",
        ["In Defense of Frostwolf"] = "Защита клана Северного Волка",
        ["In Defense of the King's Lands"] = "Защита королевских земель",
        ["In Dreams"] = "Во сне",
        ["In Eranikus' Own Words"] = "Судя по словам Эраникуса...",
        ["In Favor of Elune"] = "Во имя Элуны",
        ["In Favor of Spirituality"] = "В пользу духовности",
        ["In Favor of the Light"] = "Во имя Света!",
        ["In Good Hands"] = "В хороших руках",
        ["In Good Taste"] = "Хороший вкус",
        ["In Need of Felblood"] = "Оскверненная кровь",
        ["In Nightmares"] = "Кошмары.",
        ["In Pursuit of Featherbeard"] = "В поисках Пероборода",
        ["In Search of Anthion"] = "В поисках Антиона",
        ["In Search of Farahlite"] = "В поисках фаралита",
        ["In Search of Galvan"] = "В поисках Гальвана",
        ["In Search of Knowledge"] = "В поисках знаний",
        ["In Search of Menara Voidrender"] = "Поиски Менары Продавца Пустоты",
        ["In Search of Sedai"] = "Найти Седаи",
        ["In Search of Thaelrid"] = "В поисках Тэлрида",
        ["In Search of The Excavation Team"] = "Пропажа изыскательской группы",
        ["In Search of The Temple"] = "В поисках Храма",
        ["In the Name of the Light"] = "Во имя Света!",
        ["Incendius!"] = "Огнеус!",
        ["Incendosaurs? Whateverosaur is More Like It"] = "Инсендозавры? Ну и название...",
        ["Incoming Gumdrop"] = "Плата за мармеладки",
        ["Incriminating Documents"] = "Обличающие бумаги",
        ["Indispensable Tools"] = "Необходимые инструменты",
        ["Indurium"] = "Индарилий",
        ["Indurium Ore"] = "Индарилиевая руда",
        ["Ineptitude + Chemicals = Fun"] = "Ineptitude + Chemicals = Fun",
        ["Inert Scourgestones"] = "Бездействующие камни Плети",
        ["Infallible Mind"] = "Непогрешимый разум",
        ["Infiltrating Dragonmaw Fortress"] = "Переполох в крепости Драконьей Пасти",
        ["Infiltrating the Castle"] = "Проникновение в замок",
        ["Infiltration"] = "Шпионская работа",
        ["Inform Leoroxx!"] = "Доложить Леороксу!",
        ["Information Gathering"] = "Сбор информации",
        ["Ink Supplies"] = "Запас чернил",
        ["Inoculation"] = "Прививка",
        ["Inquire at the Inn"] = "Расспросы в таверне",
        ["Insane Druids"] = "Безумные друиды",
        ["Insect Part Analysis"] = "Анализ частей насекомых",
        ["Intercepting the Message"] = "Перехват сообщения",
        ["Into Occupied Territory"] = "Вылазка на оккупированную территорию",
        ["Into The Maw of Madness"] = "В бездне безумия",
        ["Into The Scarlet Monastery"] = "В монастырь Алых",
        ["Into The Temple of Atal'Hakkar"] = "В храме Аталхаккара",
        ["Into the Breach"] = "Битва в проломе",
        ["Into the Churning Gulch"] = "Прогулка в Гниющую лощину",
        ["Into the Depths"] = "Во глубине болот",
        ["Into the Draenethyst Mine"] = "Копи дренейского аметиста",
        ["Into the Dream"] = "Дорога в Сон",
        ["Into the Field"] = "За образцами тканей",
        ["Into the Heart of the Labyrinth"] = "Into the Heart of the Labyrinth",
        ["Invaders of Alterac Valley"] = "Вторжение в долину Альтерака",
        ["Invaluable Asset Zapping"] = "Захват бесценного оборудования",
        ["Invasion Point: Annihilator"] = "Место вторжения: Аннигилятор",
        ["Invasion Point: Cataclysm"] = "Пункт Вторжения: Катаклизм",
        ["Investigate An'daroth"] = "Обследование Андарота",
        ["Investigate Echo Ridge"] = "Разведка в руднике Горного эха",
        ["Investigate Tuurem"] = "Исследование Туурема",
        ["Investigate the Alchemist Shop"] = "Лавка алхимика",
        ["Investigate the Amani Catacombs"] = "Обследование катакомб Амани",
        ["Investigate the Blue Recluse"] = "Синий Отшельник",
        ["Investigate the Camp"] = "Поиск лагеря",
        ["Investigate the Crash"] = "Найти место крушения",
        ["Iron Coral"] = "Железный Коралл",
        ["Ironband Wants You!"] = "Вы нужны Железняку!",
        ["Ironband's Compound"] = "Мастерская Железняка",
        ["Ironband's Excavation"] = "Раскоп Железняка",
        ["Irondeep Supplies"] = "Припасы Железного рудника",
        ["Irradiated Crystal Shards"] = "Осколки облученного кристалла",
        ["Isha Awak"] = "Иша Авак",
        ["Ishamuhale"] = "Ишамухейл",
        ["Ishanah"] = "Ишана",
        ["Ishanah's Help"] = "Помощь Ишаны",
        ["It's Dangerous to Go Alone"] = "Один в поле не воин",
        ["It's Just That Easy?"] = "Не так просто?",
        ["It's Watching You!"] = "Оно следит за тобой!",
        ["It's a Secret to Everybody"] = "Тайна, покрытая мраком",
        ["It's a Trap!"] = "Ловушка!",
        ["Items of Power"] = "Волшебные предметы",
        ["Items of Some Consequence"] = "Все по порядку",
        ["Ivar the Foul"] = "Ивар Скверный",
        ["Iverron's Antidote"] = "Противоядие Иверрона",
        ["Ivus the Forest Lord"] = "Айвус Владыка Леса",
        ["JOB OPPORTUNITY: Culling the Competition"] = "ВАКАНСИЯ: устранитель конкурентов",
        ["Jail Break!"] = "Побег!",
        ["James Hyal"] = "Джеймс Хьяль.",
        ["Jammal'an the Prophet"] = "Джаммалан-пророк",
        ["Jarl Needs Eyes"] = "Ярлу нужны глаза",
        ["Jarl Needs a Blade"] = "Ярлу нужен клинок.",
        ["Je'neu of the Earthen Ring"] = "Дженей из Кольца Земли",
        ["Jes'rimon's Payment to Jediga"] = "Плата Джесримона Джедиге",
        ["Jin'Zil's Forest Magic"] = "Лесная магия Джин'Зила",
        ["Jitters' Growling Gut"] = "Голодный Джиттерс",
        ["Job Opening: Guard Captain of Revantusk Village"] = "Требуется: капитан стражи в деревню Сломанного Клыка",
        ["Jol"] = "Джоль",
        ["Jonespyre's Request"] = "Просьба друида",
        ["Jorn Skyseer"] = "Джорн Искатель Неба",
        ["Journey into Thunder Bluff"] = "Путешествие в Громовой Утес",
        ["Journey to Astranaar"] = "Путешествие в Астранаар",
        ["Journey to Hillsbrad Foothills"] = "Путешествие в предгорья Хилсбрада",
        ["Journey to Honor Hold"] = "Путешествие в Оплот Чести",
        ["Journey to Stonetalon Peak"] = "Путешествие к пику Каменный Коготь",
        ["Journey to Tarren Mill"] = "Путешествие на мельницу Таррен",
        ["Journey to Thrallmar"] = "Путешествие в Траллмар",
        ["Journey to Undercity"] = "Путь в Подгород",
        ["Journey to the Crossroads"] = "Путешествие в Перекресток",
        ["Journey to the Marsh"] = "Путь в болото",
        ["Joys of Omosh"] = "Радость Омошей",
        ["Ju-Ju Heaps"] = "Груды джуджу",
        ["Judgment and Redemption"] = "Суд и расплата",
        ["Juice Delivery"] = "Доставка сока",
        ["Jungle Secrets"] = "Тайны джунглей",
        ["Junkboxes Needed"] = "Принести лари",
        ["Just Compensation"] = "Справедливое вознаграждение",
        ["Jyoba's Report"] = "Донесение разведчика Джиобы",
        ["KILL ON SIGHT: Dark Iron Dwarves"] = "УНИЧТОЖИТЬ НА МЕСТЕ: Дворфы Темной Стали",
        ["KILL ON SIGHT: High Ranking Dark Iron Officials"] = "УНИЧТОЖИТЬ НА МЕСТЕ: Высокопоставленные чины Темной Стали",
        ["Kaela's Update"] = "Новости для Каэлы",
        ["Kamsis"] = "Камсис",
        ["Karabor Training Grounds"] = "Тренировочные площадки Карабора",
        ["Karynaku"] = "Карунаку",
        ["Kaya's Alive"] = "Кайя жива!",
        ["Kayneth Stillwind"] = "Кайнет Штиль",
        ["Keanna's Log"] = "Записи Кеанны",
        ["Keep An Eye Out"] = "Смотри в оба",
        ["Keep Thornfang Hill Clear!"] = "Очистить холм Колючего Клыка!",
        ["Keeper of the Flame"] = "Хранитель пламени",
        ["Keeping Pace"] = "Только вперед",
        ["Keeping Up Appearances"] = "Поддерживая видимость",
        ["Ken'zigla's Draught"] = "Зелье Кен'зиглы",
        ["Khadgar"] = "Хадгар",
        ["Khan Dez'hepah"] = "Вождь Дез'хепа",
        ["Khan Hratha"] = "Вождь Храта",
        ["Khan Jehn"] = "Вождь Джехн",
        ["Khan Shaka"] = "Вождь Шака",
        ["Kharan Mighthammer"] = "Каран Могучий Молот",
        ["Kharan's Tale"] = "Рассказ Карана",
        ["Kibler's Exotic Pets"] = "Редкие звери Киблера",
        ["Kick Them While They're Down"] = "Лежачего не бьют - лежачего пинают",
        ["Kidnapped Elder Torntusk!"] = "Похищен старейшина Зазубренного Клыка!",
        ["Kill Grundig Darkcloud"] = "Убить Грюндига Темное Облако",
        ["Kill the Shadow Council!"] = "Убить Совет Теней!",
        ["Killing the Crawlers"] = "Убить крабов",
        ["Kim'jael Indeed!"] = "Оскорбленный Кимджаэль",
        ["Kim'jael's \"Missing\" Equipment"] = "\"Пропавшее\" оборудование Кимджаэля",
        ["Kindness"] = "Доброта",
        ["King of the Foulweald"] = "Король Гиблой Чащи",
        ["Kingly Shakedown"] = "Королевская облава",
        ["Kirith"] = "Кирит",
        ["Kirtonos the Herald"] = "Киртонос Глашатай",
        ["Kitchen Assistance"] = "Помощь по кухне",
        ["Klaven's Tower"] = "Башня Клейвена",
        ["Klockmort Spannerspan"] = "Клокморт Гаечный Ключ",
        ["Klockmort's Creation"] = "Творение Клокморта",
        ["Klockmort's Essentials"] = "Базовые элементы Клокморта",
        ["Know Thine Enemy"] = "Лицо врага",
        ["Know your Enemy"] = "Врага нужно знать в лицо",
        ["Knowledge in the Deeps"] = "Знание из бездны",
        ["Knowledge of the Orb of Orahil"] = "Знание шара Орахила",
        ["Kobold Camp Cleanup"] = "Зачистка лагеря кобольдов",
        ["Kobold Candles"] = "Свечи кобольдов",
        ["Kodo Hide Bag"] = "Сумка из шкуры кодоя",
        ["Kodo Roundup"] = "Отлов кодоев",
        ["Kolkar Leaders"] = "Главари клана Колкар",
        ["Krastinov's Bag of Horrors"] = "Мешок ужасов Крастинова",
        ["Krasus's Compendium"] = "Компендиум Красуса",
        ["Krazek's Cookery"] = "Горшок Кразека",
        ["Kris of Unspoken Names"] = "Крис Неназванных имен",
        ["Krom'Grul"] = "Кром-Грул",
        ["Kroshius' Infernal Core"] = "Огненное ядро Крошиуса",
        ["Kum'isha's Endeavors"] = "Попытки Кум-иши",
        ["Kurzen's Mystery"] = "Тайна Курзена",
        ["Lack of Surplus"] = "Нехватка ресурсов",
        ["Lakota'mani"] = "Лакоматани",
        ["Land Ho!"] = "Эй, там!",
        ["Lard Lost His Lunch"] = "Лярд потерял свой обед",
        ["Larion and Muigin"] = "Ларион и Майджин",
        ["Laughing Sisters"] = "Смеющиеся сестры",
        ["Laying Waste to the Unwanted"] = "Сжечь старье!",
        ["Lazy Peons"] = "Ленивые рабы",
        ["Leader of the Bloodscale"] = "Глава клана Кровавой Чешуи",
        ["Leader of the Darkcrest"] = "Предводитель Темного Гребня",
        ["Leaders of the Fang"] = "Повелители Змей",
        ["Learning from the Crystals"] = "Изучение кристаллов",
        ["Learning the Language"] = "Изучение языка",
        ["Ledger from Tanaris"] = "Учетная книга из Танариса",
        ["Legends of Maraudon"] = "Легенды Мараудона",
        ["Leonid Barthalomew"] = "Леонид Барталомей",
        ["Lethtendris's Web"] = "Сеть Летендрис",
        ["Letter to Jin'Zil"] = "Письмо Джин'Зилу",
        ["Letter to Stormpike"] = "Письмо Грозовой Вершине",
        ["Levixus the Soul Caller"] = "Левиксус Призыватель Душ",
        ["Libram of Constitution"] = "Манускрипт Здоровья",
        ["Libram of Focus"] = "Манускрипт Средоточия",
        ["Libram of Protection"] = "Манускрипт Защиты",
        ["Libram of Rapidity"] = "Манускрипт Скорости",
        ["Libram of Resilience"] = "Манускрипт Устойчивости",
        ["Libram of Rumination"] = "Манускрипт Размышления",
        ["Libram of Tenacity"] = "Манускрипт Упорства",
        ["Libram of Voracity"] = "Манускрипт Ненасытности",
        ["Lieutenant Paval Reethe"] = "Лейтенант Павал Рит",
        ["Life's Finer Pleasures"] = "Изысканные удовольствия жизни",
        ["Lifting the Curse"] = "Очищение",
        ["Limits of Physical Exhaustion"] = "Границы возможного",
        ["Lines of Communication"] = "Линии связи",
        ["Linken's Adventure"] = "Приключения Линкена",
        ["Linken's Memory"] = "Память Линкена",
        ["Linken's Sword"] = "Меч Линкена",
        ["Liquid Stone"] = "Жидкий камень",
        ["Little Embers"] = "Угольки",
        ["Little Morsels"] = "Маленькие кусочки",
        ["Load Lightening"] = "Уменьшение веса",
        ["Lonebrow's Journal"] = "Дневник Хмурня",
        ["Long Forgotten Memories"] = "Давно забытые воспоминания",
        ["Longtail is the Lynchpin"] = "За всем строит Длиннохвост",
        ["Look To The Stars"] = "Взгляни на звезды",
        ["Look to an Old Friend"] = "Помощь старого друга",
        ["Looking Further"] = "Пронизывающий взор",
        ["Looking to the Leadership"] = "Солдатская верность",
        ["Loramus"] = "Лорамус",
        ["Lord Aliden Perenolde"] = "Лорд Алиден Перенольд",
        ["Lord Banehollow"] = "Лорд Голодная Погибель",
        ["Lord Maxwell Tyrosus"] = "Лорд Максвел Тиросс",
        ["Lords of the Council"] = "Лорды Совета",
        ["Lore for a Price"] = "Мудрость за деньги",
        ["Losing Gracefully"] = "Проиграть с честью",
        ["Lost Armaments"] = "Потерянное оружие",
        ["Lost But Not Forgotten"] = "Пропавший, но не без вести",
        ["Lost Deathstalkers"] = "Пропавшие Странники смерти",
        ["Lost Necklace"] = "Потерянное ожерелье",
        ["Lost Thunderbrew Recipe"] = "Украденный рецепт Громопойла",
        ["Lost in Action"] = "Погибли при исполнении",
        ["Lost in Battle"] = "Пропавшая без вести",
        ["Lost!"] = "Потерялся!",
        ["Love Song for Narain"] = "Любовная песнь для Нарайна",
        ["Love's Gift"] = "Дар любви",
        ["Luck Be With You"] = "Да пребудет с тобой удача!",
        ["Mac'Aree Mushroom Menagerie"] = "Грибная похлебочка из Мак-Ари",
        ["MacKreel's Moonshine"] = "Самогон Маккрила",
        ["Mace of Unending Life"] = "Палица Бесконечной жизни",
        ["Maelstrom's Wrath"] = "Ярость Водоворота",
        ["Magatha's Payment to Jediga"] = "Плата Магаты Джедиге",
        ["Mage Summoner"] = "Маг-призыватель духов",
        ["Mage Training"] = "Обучение мага",
        ["Mage's Wand"] = "Магический жезл",
        ["Mage-tastic Gizmonitor"] = "Маг-тастический Гизмонитор",
        ["Magecraft"] = "Магическое искусство",
        ["Magic Dust"] = "Волшебная пыль",
        ["Magic of the Arakkoa"] = "Магия Араккоа",
        ["Magical Analysis"] = "Магический анализ",
        ["Magical Disturbances"] = "Нарушение магического равновесия",
        ["Magram Alliance"] = "Союз с кланом Маграм",
        ["Mahren Skyseer"] = "Марен Искательница Неба",
        ["Mai'Zoth"] = "Май'Зот",
        ["Major Malfunction"] = "Серьезная поломка",
        ["Make Them Listen"] = "Заставь их слушать",
        ["Making Amends"] = "Восстановление добрых отношений",
        ["Making Sense of It"] = "Давай-ка разберемся",
        ["Maktu's Revenge"] = "Месть Макту",
        ["Makuru's Vengeance"] = "Месть Макуру",
        ["Malaise"] = "Болезнь",
        ["Malevolent Remnants"] = "Зловещие останки",
        ["Malfunction at the West Sanctum"] = "Авария в Западном святилище",
        ["Malin's Request"] = "Просьба Малина",
        ["Mana Surges"] = "Волны маны",
        ["Manaforge B'naar"] = "Кузня маны Б'наар",
        ["Manaweave Robe"] = "Одеяние из ткани маны",
        ["Manhunt"] = "Самая увлекательная охота",
        ["Mantle of the Oracle"] = "Оплечье Оракула",
        ["Mantles of the Dawn"] = "Оплечья Рассвета",
        ["Maps and Runes"] = "Карты и руны",
        ["Marauders of Darrowshire"] = "Мародеры Дарроушира",
        ["Marauding Crust Bursters"] = "Хищный землерой",
        ["Marauding Wolves"] = "Волчья напасть",
        ["Marg Speaks"] = "Марг говорит",
        ["Margoz"] = "Маргоз",
        ["Mark V is Alive!"] = "Марк-V жив!",
        ["Marking the Path"] = "Осветить путь",
        ["Marks of Kil'jaeden"] = "Знаки Кил-Джедена",
        ["Marks of Sargeras"] = "Знак Саргараса",
        ["Marla's Last Wish"] = "Последнее желание Марлы",
        ["Marshal Haggard"] = "Маршал Хаггард",
        ["Marshal Windsor"] = "Маршал Виндзор",
        ["Martek the Exiled"] = "Мартек Изгнанник",
        ["Marvon's Workshop"] = "Мастерская Марвона",
        ["Massacre at Gruul's Lair"] = "Резня в логове Груула",
        ["Master Angler"] = "Лучший удильщик",
        ["Master of the Wild Leather"] = "Мастер школы Дикаря",
        ["Mastering the Elements"] = "Покорение Стихий",
        ["Material Assistance"] = "Существенная помощь",
        ["Material Components"] = "Компоненты зелья",
        ["Mathias and the Defias"] = "Матиас и братство Справедливости",
        ["Mathiel"] = "Матиль",
        ["Mathiel's Armor"] = "Доспехи Матиля",
        ["Mathystra Relics"] = "Реликвии Матистры",
        ["Matis the Cruel"] = "Матис Жестокий",
        ["Matters of Security"] = "Вопросы безопасности",
        ["Maxnar Must Die!"] = "Да сгинет Макснар!",
        ["Maxwell's Mission"] = "Миссия Максвелла",
        ["Mayara Brightwing"] = "Майара Светлое Крыло",
        ["Mazen's Behest"] = "Задание Мазена",
        ["Mazzranache"] = "Маззанач",
        ["Measuring Warp Energies"] = "Измерение энергии Искажения",
        ["Meats to Orgrimmar"] = "Мясные продукты в Оргриммар",
        ["Mechanical Repair Kits"] = "Автоматические ремонтные наборы",
        ["Medallion of Station"] = "Станционный медальон",
        ["Medicinal Purpose"] = "Ради науки",
        ["Medivh's Journal"] = "Записи Медива",
        ["Meet at the Grave"] = "Встреча на кладбище",
        ["Meeting at the Blackwing Coven"] = "Встреча в Ковене Крыльев Тьмы",
        ["Meeting with the Master"] = "Встреча с господином",
        ["Melding of Influences"] = "Слияние",
        ["Melor Sends Word"] = "Весть от Мелора",
        ["Menacing Marshfangs"] = "Опасные болотные клыки",
        ["Mending Old Wounds"] = "Исцеление старых ран",
        ["Menethil's Gift"] = "Дар Менетиля",
        ["Mennet Carkad"] = "Меннит Каркад",
        ["Mercenaries"] = "Наемники",
        ["Mercy for the Cursed"] = "Милость к проклятым",
        ["Message in a Bottle"] = "Послание в бутылке",
        ["Message to Freewind Post"] = "Письмо в форт Вольный Ветер",
        ["Message to Garadar"] = "Послание в Гарадар",
        ["Message to Maxwell"] = "Донесение Максвелла",
        ["Message to Telaar"] = "Послание в Телаар",
        ["Message to the Daggerfen"] = "Разговор с Кинжальной топью",
        ["Message to the Wildhammer"] = "Письмо для Громового Молота",
        ["Messenger to Darkshire"] = "Гонец в Темнолесье",
        ["Messenger to Stormwind"] = "Гонец в Штормград",
        ["Messenger to Thrall"] = "Донесение Траллу",
        ["Messenger to Westfall"] = "Гонец в Вестфол",
        ["Messenger to the Feralfen"] = "Посланец в Зверотопь",
        ["Metzen the Reindeer"] = "Метцен - северный олень",
        ["Michael Garrett"] = "Майкл Гарретт",
        ["Milly Osworth"] = "Милли Осворт",
        ["Milly's Harvest"] = "Урожай Милли",
        ["Miner's Fortune"] = "Удача шахтера",
        ["Minions of the Shadow Council"] = "Приспешники Совета Теней",
        ["Minshina's Skull"] = "Череп Миншины",
        ["Mirages"] = "Миражи",
        ["Mirror Lake"] = "Зеркальное озеро",
        ["Missing Crystals"] = "Пропавшие кристаллы",
        ["Missing Friends"] = "Пропавшие друзья",
        ["Missing In Action"] = "Пропавший без вести",
        ["Missing Mag'hari Procession"] = "Пропавшая похоронная процессия",
        ["Missing Missive"] = "Потерянное послание",
        ["Missing in the Ghostlands"] = "Пропавший в Призрачных землях",
        ["Mission: Gateways Murketh and Shaadraz"] = "Задание: Врата Муркет и Шаадраз",
        ["Mission: Possible But Not Probable"] = "Миссия: выполнима, но с трудом",
        ["Mission: The Abyssal Shelf"] = "Задание: Уступ Преисподней",
        ["Mission: The Murketh and Shaadraz Gateways"] = "Задание: Врата Муркет и Шаадраз",
        ["Mist"] = "Дымка",
        ["Mo'mor the Breaker"] = "Момор Разрушитель",
        ["Mok'Nathal Treats"] = "Лакомства Мок-Натал",
        ["Mok'thardin's Enchantment"] = "Чары Моктардина",
        ["Mold Rhymes With..."] = "Форма денег стоит",
        ["Moonglow Vest"] = "Жилет Лунного сияния",
        ["Moontouched Wildkin"] = "Светолунные совиные медведи",
        ["Mor'Ladim"] = "Мор'Ладим",
        ["Mor'zul Bloodbringer"] = "Морзул Кровссон",
        ["Morbent Fel"] = "Морбент Фел",
        ["More Arakkoa Feathers"] = "Больше перьев араккоа",
        ["More Armor Kits"] = "Обмен: комплекты грубой брони",
        ["More Bat Eyes"] = "Обмен: глаза летучих мышей",
        ["More Booty!"] = "Больше добычи!",
        ["More Components of Importance"] = "Еще одна важная составляющая заклинания",
        ["More Crystal Fragments"] = "Снова осколки кристалла",
        ["More Dense Grinding Stones"] = "Обмен: увесистые точильные камни",
        ["More Feathers"] = "Больше перьев",
        ["More Fertile Spores"] = "Новые прорастающие споры",
        ["More Firewing Signets"] = "Больше перстней Огненных Крыльев",
        ["More Glowcaps"] = "Нужно больше грибов!",
        ["More Glowing Scorpid Blood"] = "Обмен: светящаяся кровь скорпида",
        ["More Heads Full of Ivory"] = "Кость на вес воздуха",
        ["More Irradiated Crystal Shards"] = "И снова облученные кристаллы",
        ["More Marks of Kil'jaeden"] = "Больше знаков Кил-Джедена",
        ["More Marks of Sargeras"] = "Больше знаков Саргараса",
        ["More Obsidian Warbeads"] = "Поиски обсидиановых боевых ожерелий",
        ["More Power!"] = "Больше мощи!",
        ["More Rotting Hearts"] = "Снова гниющие сердца",
        ["More Spore Sacs"] = "Новые мешочки со спорами",
        ["More Tendrils!"] = "Еще усиков!",
        ["More Thorium Widgets"] = "Обмен: ториевые устройства",
        ["More Venom Sacs"] = "Больше ядовитых желез",
        ["More Warbeads"] = "Боевые ожерелья",
        ["More Warbeads!"] = "Боевые ожерелья!",
        ["More Wastewander Justice"] = "Новая расправа над Пустынными Странниками",
        ["More than a Pound of Flesh"] = "Не просто фунт мяса",
        ["Morgan Ladimore"] = "Морган Ладимор",
        ["Morgan Stern"] = "Морган Штерн",
        ["Morganth"] = "Моргант",
        ["Morrowgrain Research"] = "Изучение рассветницы",
        ["Morrowgrain to Darnassus"] = "Рассветница для Дарнасса",
        ["Morrowgrain to Feathermoon Stronghold"] = "Рассветница для крепости Лунного Пера",
        ["Morrowgrain to Thunder Bluff"] = "Рассветница для Громового утеса",
        ["Mortality Wanes"] = "Последнее желание",
        ["Mother's Milk"] = "Материнское молоко",
        ["Mountain Giant Muisek"] = "Уменьшенный горный великан",
        ["Mountaineer Stormpike's Task"] = "Задание Грозовой Вершины",
        ["Muck Diving"] = "Грязные делишки",
        ["Mudrock Soup and Bugs"] = "Суп из илистой черепахи с жучками",
        ["Muigin and Larion"] = "Майджин и Ларион",
        ["Mura Runetotem"] = "Мара Рунный Тотем",
        ["Murdaloc"] = "Мурдалок",
        ["Muren Stormpike"] = "Марен Грозовая Вершина",
        ["Murkblood Corrupters"] = "Разлагатели Темной Крови",
        ["Murkblood Invaders"] = "Вторжение Темной Крови",
        ["Murkblood Leaders..."] = "Главари Темной Крови",
        ["Murloc Poachers"] = "Морлоки-браконьеры",
        ["Murlocs... Why Here? Why Now?"] = "Морлоки... За что нам эта напасть?",
        ["Mystery Goo"] = "Таинственная слизь",
        ["Mystery Mask"] = "Таинственная маска",
        ["Mythology of the Titans"] = "Мифология титанов",
        ["Myzrael's Allies"] = "Союзники Мизраэли",
        ["Naaru Technology"] = "Технология наару",
        ["Naga at the Zoram Strand"] = "Наги на взморье Зорам",
        ["Naladu"] = "Наладу",
        ["Nara Wildmane"] = "Нара Дикая Грива",
        ["Nat's Measuring Tape"] = "Измерительная лента Ната",
        ["Natural Armor"] = "Природная броня",
        ["Natural Enemies"] = "Природные враги",
        ["Natural Materials"] = "Природные материалы",
        ["Natural Remedies"] = "Целительная сила природы",
        ["Necklace Recovery"] = "Пропавшее ожерелье",
        ["Need for a Cure"] = "Нужда в исцелении",
        ["Needs More Cowbell"] = "Колокольчик для коровы",
        ["Neeka Bloodscar"] = "Ника Алый Шрам",
        ["Neeru Fireblade"] = "Нееру Огненный Клинок",
        ["Nefarius's Corruption"] = "Нефариус, пораженный порчей",
        ["Nek'rosh's Gambit"] = "Огонь войны",
        ["Nekrum's Medallion"] = "Медальон Некрума",
        ["Nessa Shadowsong"] = "Несса Песня Теней",
        ["Nether Gas In a Fel Fire Engine"] = "Газ хаоса в двигателе",
        ["Nether-lace Garment"] = "Одеяние из кружева Хаоса",
        ["Neutralizing the Nethermancers"] = "Нейтрализовать чародеев Хаоса",
        ["Never Again!"] = "Больше никогда!",
        ["Never Ask Me About My Business"] = "Никогда не расспрашивай меня о моем бизнесе!",
        ["New Life"] = "Новая жизнь",
        ["New Opportunities"] = "Новые возможности",
        ["New Year Celebrations!"] = "Отмечаем Новый Год!",
        ["Newfound Allies"] = "Новые союзники",
        ["News for Fizzle"] = "Новости для Физзла",
        ["News for Rakoria"] = "Вести для Ракории",
        ["News from Zangarmarsh"] = "Новости с болот Зангара",
        ["News of Dogran"] = "Вести о Догране",
        ["News of Victory"] = "Вести о Победе",
        ["Nexus-King Salhadaar"] = "Соправитель Салхадаар",
        ["Night Web's Hollow"] = "Охота на пауков",
        ["No More Mushrooms!"] = "Довольно грибов!",
        ["No Time for Curiosity"] = "Не время для любопытства",
        ["Noble Deaths"] = "Благородная гибель",
        ["Noboru the Cudgel"] = "Нобору Дубина",
        ["Nogg's Ring Redo"] = "Переделка кольца",
        ["Noggenfogger Elixir"] = "Эликсир Ноггенфоггера",
        ["Noggle's Last Hope"] = "Последняя надежда Ноггла",
        ["Noggle's Lost Satchel"] = "Потерянная сумка Ноггла",
        ["Nolkai's Words"] = "Записи Нолкаи",
        ["Northfold Manor"] = "Поместье Северной ложбины",
        ["Not On My Watch!"] = "Только не в мою смену!",
        ["Note to William"] = "Записка для Вильяма",
        ["Note to the Mayor"] = "Записка для мэра",
        ["Nothin' Says Lovin' Like a Big Stinger"] = "Лучшее доказательство любви!",
        ["Nothing But The Truth"] = "Правда и только правда",
        ["Now That We're Friends..."] = "Теперь, когда мы друзья...",
        ["Now That We're Still Friends..."] = "Раз уж мы по-прежнему друзья...",
        ["Noxious Lair Investigation"] = "Исследование Ядовитого логова",
        ["Nugget Slugs"] = "Золотые пули",
        ["Oakenscowl"] = "Дубохмур",
        ["Observing the Sporelings"] = "Наблюдение за спорлингами",
        ["Obsidian Warbeads"] = "Обсидиановое боевое ожерелье",
        ["Oculus Illusions"] = "Иллюзиии Ока",
        ["Of Coursers We Know"] = "Охота на беговых оленей",
        ["Of Forgotten Memories"] = "Память об ушедших днях",
        ["Of Lost Honor"] = "Об утраченной чести",
        ["Of Love and Family"] = "О любви и семье",
        ["Of Thistleheads and Eggs..."] = "Выгодный обмен",
        ["Off To Area 52"] = "В Зону 52",
        ["Ogre Head On A Stick = Party"] = "Ogre Head On A Stick = Party",
        ["Ogre Thieves"] = "Нападение огров",
        ["Oh Brother. . ."] = "О, брат мой...",
        ["Old Hillsbrad"] = "Старый Хилсбрад",
        ["Old Whitebark's Pendant"] = "Подвеска Старого Белоствола",
        ["Olemba Seed Oil"] = "Масло из семян олембы",
        ["Olemba Seeds"] = "Семена олембы",
        ["Omarion's Handbook"] = "Руководство Омариона",
        ["On Guard in Stonetalon"] = "На страже в Каменном Когте",
        ["On Iron Pauldrons"] = "Железное оплечье",
        ["On Nethery Wings"] = "На крыльях Хаоса",
        ["On Spirit's Wings"] = "На крыльях Духа",
        ["On the Wings of a Hippogryph"] = "На крыльях гиппогрифа",
        ["Once Were Warriors"] = "Да, были воины в наше время...",
        ["One Demon's Trash..."] = "Мусор одного демона...",
        ["One Draenei's Junk..."] = "Дренейский хлам...",
        ["One Shot. One Kill."] = "Каждый выстрел - в цель",
        ["Ongeku"] = "Онгеку",
        ["Onin's Report"] = "Донесение Онина",
        ["Only One May Rise"] = "Кто будет избран?",
        ["Onu"] = "Ону",
        ["Onu is meditating"] = "Размышление Ону",
        ["Onward to Ashenvale"] = "Вперед, в Ашенваль",
        ["Operation Recombobulation"] = "Операция \"Перенаправление\"",
        ["Operation: Death to Angerforge"] = "Операция: смерть Кузне Гнева",
        ["Operative Bijou"] = "Агент Безделушка",
        ["Oran's Gratitude"] = "Благодарность Оран",
        ["Ordanus"] = "Хорданиус",
        ["Order Must Be Restored"] = "Порядок должен быть восстановлен",
        ["Orders from Lady Vashj"] = "Приказы госпожи Вайши",
        ["Orendil's Cure"] = "Лекарство Орендила",
        ["Orm Stonehoof and the Brutal Helm"] = "Орм Каменное Копыто и большой шлем Жестокости",
        ["Ormer's Revenge"] = "Месть Ормера",
        ["Oronok Torn-heart"] = "Оронок Вырыватель сердец",
        ["Oronu the Elder"] = "Старший Орону",
        ["Ortor My Old Friend..."] = "Ортор, мой старый друг...",
        ["Oshu'gun Crystal Powder"] = "Порошок кристалла Ошу'гуна",
        ["Other Fish to Fry"] = "Смерть земноводным!",
        ["Outland Sucks!"] = "Пустоши - отстой!",
        ["Outrider Advanced Care Package"] = "Доукомплектованная амуниция Сопровождающего",
        ["Outrider Basic Care Package"] = "Амуниция Сопровождающего",
        ["Outrider Standard Care Package"] = "Стандартная амуниция Сопровождающего",
        ["Outside Assistance"] = "Помощь извне",
        ["Overlord"] = "Владыка",
        ["Overlord Gorefist"] = "Властитель клана Кровавого Кулака",
        ["Overlord Mok'Morokk's Concern"] = "Заботы властителя Мок-Моррока",
        ["Overmaster Pyron"] = "Подчинитель Пирон",
        ["Owatanka"] = "Оватанка",
        ["Pacify the Centaur"] = "Упокоение кентавров",
        ["Package Recovery"] = "Возвращение свертка",
        ["Package for Thurman"] = "Посылка для Тармена",
        ["Paladin Training"] = "Обучение паладинов",
        ["Pamela's Doll"] = "Кукла Памелы",
        ["Panther Mastery"] = "Схватка с пантерой",
        ["Paragons of Power: The Augur's Belt"] = "Знаки Силы: пояс авгура",
        ["Paragons of Power: The Augur's Bracers"] = "Знаки Силы: браслеты авгура",
        ["Paragons of Power: The Augur's Hauberk"] = "Знаки Силы: хауберк авгура",
        ["Paragons of Power: The Confessor's Bindings"] = "Знаки Силы: пояс исповедника",
        ["Paragons of Power: The Confessor's Mantle"] = "Знаки Силы: оплечье исповедника",
        ["Paragons of Power: The Confessor's Wraps"] = "Знаки Силы: защитные поручи исповедника",
        ["Paragons of Power: The Demoniac's Mantle"] = "Знаки Силы: оплечье бесноватого",
        ["Paragons of Power: The Demoniac's Robes"] = "Знаки Силы: одеяние бесноватого",
        ["Paragons of Power: The Demoniac's Wraps"] = "Знаки Силы: защитные поручи бесноватого",
        ["Paragons of Power: The Freethinker's Armguards"] = "Знаки Силы: боевые наручи вольнодумца",
        ["Paragons of Power: The Freethinker's Belt"] = "Знаки силы: пояс вольнодумца",
        ["Paragons of Power: The Freethinker's Breastplate"] = "Знаки Силы: кираса вольнодумца",
        ["Paragons of Power: The Haruspex's Belt"] = "Знаки Силы: пояс гаруспика",
        ["Paragons of Power: The Haruspex's Bracers"] = "Знаки Силы: боевые браслеты гаруспика",
        ["Paragons of Power: The Haruspex's Tunic"] = "Знаки Силы: туника гаруспика",
        ["Paragons of Power: The Illusionist's Mantle"] = "Знаки Силы: оплечье мастера иллюзий",
        ["Paragons of Power: The Illusionist's Robes"] = "Знаки Силы: одеяние мастера иллюзий",
        ["Paragons of Power: The Illusionist's Wraps"] = "Знаки Силы: защитные поручи мастера иллюзий",
        ["Paragons of Power: The Madcap's Bracers"] = "Знаки Силы: боевые браслеты безумца",
        ["Paragons of Power: The Madcap's Mantle"] = "Знаки Силы: оплечье безумца",
        ["Paragons of Power: The Madcap's Tunic"] = "Знаки Силы: туника безумца",
        ["Paragons of Power: The Predator's Belt"] = "Знаки Силы: пояс хищника",
        ["Paragons of Power: The Predator's Bracers"] = "Знаки Силы: боевые браслеты хищника",
        ["Paragons of Power: The Predator's Mantle"] = "Знаки Силы: оплечье хищника",
        ["Paragons of Power: The Vindicator's Armguards"] = "Знаки Силы: боевые наручи блюстителя",
        ["Paragons of Power: The Vindicator's Belt"] = "Знаки Силы: пояс блюстителя",
        ["Paragons of Power: The Vindicator's Breastplate"] = "Знаки Силы: кираса блюстителя",
        ["Parts for Kravel"] = "Детали для Крейвела",
        ["Parts of the Swarm"] = "Части роя",
        ["Passage to Booty Bay"] = "Дорога до Бухты Контрабандистов",
        ["Passing Word of a Threat"] = "Слухи об угрозе",
        ["Passing the Burden"] = "Передача поручения",
        ["Past Endeavors"] = "Прежние свершения",
        ["Path of Defense"] = "Путь защиты",
        ["Path of the Violet Protector"] = "Защитник из Аметистового Ока",
        ["Path of the Violet Restorer"] = "Исцелитель из Аметистового Ока",
        ["Patriarch Ironjaw"] = "Патриарх Железнозуб",
        ["Patrol Schedules"] = "Расписание дежурств",
        ["Patrolling Westfall"] = "Патрулирование Вестфола",
        ["Pawn Captures Queen"] = "Шах королеве",
        ["Pay the Baron a Visit"] = "Визит к барону",
        ["Pearl Diving"] = "В поисках жемчуга",
        ["Pelt Collection"] = "Добывание шкур",
        ["Perfect Yeti Hide"] = "Безупречная шкура йети",
        ["Petty Squabbles"] = "Мелкие раздоры",
        ["Pick Your Part"] = "Забирай свою часть",
        ["Picking Up Some Power Converters"] = "Спасти преобразователи энергии!",
        ["Pie for Billy"] = "Пирог для Билли",
        ["Piercing the Veil"] = "Приоткрывая завесу",
        ["Pilfered Equipment"] = "Украденное снаряжение",
        ["Pirate Hats Ahoy!"] = "Пиратские шляпы",
        ["Plagued Hatchlings"] = "Проклятые детеныши",
        ["Plagueheart Belt"] = "Пояс Проклятого Сердца",
        ["Plagueheart Bindings"] = "Поручья Проклятого Сердца",
        ["Plagueheart Leggings"] = "Поножи Проклятого Сердца",
        ["Plainstrider Menace"] = "Равнинные долгоноги",
        ["Planting the Banner"] = "Водружение знамени",
        ["Planting the Heart"] = "Сердце-семя",
        ["Plants of Zangarmarsh"] = "Растения болот Зангара",
        ["Plea To The Alliance"] = "Просьба о помощи",
        ["Plundering the Plunderers"] = "Грабь награбленное",
        ["Poaching from Poachers"] = "Вор у вора...",
        ["Poison Water"] = "Отравленная вода",
        ["Poisoned Water"] = "Отравленная вода",
        ["Pool of Tears"] = "Озеро Слез",
        ["Poor Old Blanchy"] = "Бедная старушка Бинки",
        ["Portals of the Legion"] = "Порталы Легиона",
        ["Portents of Uldum"] = "Ульдумские чудеса",
        ["Potential Energy Source"] = "Потенциальный источник энергии",
        ["Potential for Brain Damage = High"] = "Potential for Brain Damage = High",
        ["Powder to Ironband"] = "Порох для Железняка",
        ["Power Stones"] = "Камни Силы",
        ["Power in Uldaman"] = "Сила Ульдамана",
        ["Power over Poison"] = "Власть над ядом",
        ["Powering our Defenses"] = "Усиление обороны",
        ["Practical Prey"] = "Полезная добыча",
        ["Prayer to Elune"] = "Молитва Элуне",
        ["Precarious Predicament"] = "Опасное положение",
        ["Precious and Fragile Things Need Special Handling"] = "Хрупкие предметы. Не кантовать!",
        ["Preparation for Ceremony"] = "Подготовка к церемонии",
        ["Preparing for War"] = "Готовься к войне",
        ["Preparing the Salve"] = "Изготовление мази",
        ["Presence of Might"] = "Явление Силы",
        ["Presence of Sight"] = "Явление Прозрения",
        ["Preserving Knowledge"] = "Сохранение знаний",
        ["Preying on the Predators"] = "Охота на хищников",
        ["Pride of the Fel Horde"] = "Элита Орды Скверны",
        ["Pridewings of Stonetalon"] = "Славнокрылы Каменного Когтя",
        ["Priest Training"] = "Обучение жреца",
        ["Primal Magic"] = "Изначальная магия",
        ["Princess Must Die!"] = "Принцесса должна умереть!",
        ["Prison Break In"] = "Взлом тюрьмы",
        ["Prisoner of the Bladespire"] = "Пленник Стальных Игл",
        ["Pristine Enchanted South Seas Kelp"] = "Чистые колдовские водоросли Южных морей",
        ["Pristine Spider Silk"] = "Чистейшая паутина",
        ["Pristine Yeti Hide"] = "Идеальная шкура йети",
        ["Proof of Allegiance"] = "Доказательство Верности",
        ["Proof of Deed"] = "Доказательство",
        ["Proof of Demise"] = "Доказательство верности",
        ["Proof of Life"] = "Доказательство жизни",
        ["Prophetic Aura"] = "Пророческая аура",
        ["Prospect of Faith"] = "Клятва верности",
        ["Prospector Balmoral"] = "Изыскатель Бальморал",
        ["Protect Kanati Greycloud"] = "Защитить Канати Серое Облако",
        ["Protect Kaya"] = "Защитить Кайю",
        ["Protect the Frontier"] = "Защита границы",
        ["Protecting Our Own"] = "Защитить свой дом",
        ["Protecting the Herd"] = "Защита стад",
        ["Protecting the Shipment"] = "Охрана груза",
        ["Prove Your Hatred"] = "Доказательство ненависти",
        ["Prove Your Worth"] = "Проявить себя",
        ["Proving Allegiance"] = "Доказательство преданности",
        ["Proving Grounds"] = "Испытательные земли",
        ["Proving Your Strength"] = "Покажи свою силу",
        ["Proving Your Worth"] = "Доказательство силы",
        ["Prowlers of the Barrens"] = "Степные хищники",
        ["Psychometric Reading"] = "Сверхзнание",
        ["Purified!"] = "Очищение явлено!",
        ["Pursuing Terrorclaw"] = "Охота на Жутеклешня",
        ["Pusillin and the Elder Azj'Tordin"] = "Пузиллин и старейший Аджитордин",
        ["Put Her Down"] = "Устранение опасности",
        ["Put On Yer Kneepads..."] = "Зачистка",
        ["Pyrewood Ambush"] = "Засада в деревне",
        ["Quell The Uprising"] = "Подавление восстания",
        ["Quenching the Blade"] = "Закалка Меча",
        ["Questioning Reethe"] = "Ответы Рита",
        ["Rabine Saturna"] = "Рабин Сатурна",
        ["Raene's Cleansing"] = "Раэна - санитар Ашенваля",
        ["Rage of Ages"] = "Вековая ярость",
        ["Rage of Blood"] = "Ярость крови",
        ["Ragnar Thunderbrew"] = "Рагнар Громопойл",
        ["Raid on the Kolkar"] = "Набег на клан Колкар",
        ["Raising Spirits"] = "Вызов духов",
        ["Raleigh and the Undercity"] = "Желание мертвого сердца",
        ["Ram Hide Harnesses"] = "Упряжь из бараньей кожи",
        ["Ram Riding Harnesses"] = "Упряжь ездовых баранов",
        ["Rampaging Giants"] = "Истребление великанов",
        ["Rampaging Ravagers"] = "Разъяренные Опустошители",
        ["Ramstein"] = "Рамштейн",
        ["Ranger Sareyn"] = "Cледопыт Сарэйн",
        ["Raptor Horns"] = "Рога ящера",
        ["Raptor Mastery"] = "Схватка с ящером",
        ["Raptor Thieves"] = "Ящеры-воры",
        ["Rare Fish - Brownell's Blue Striped Racer"] = "Редкая рыба - Синий полосатик Браунелла",
        ["Rare Fish - Dezian Queenfish"] = "Редкая рыба - дезийская ставрида",
        ["Rare Fish - Keefer's Angelfish"] = "Редкая рыба - Рыба-ангел Кифера",
        ["Rat Catching"] = "Ловля крыс",
        ["Rather Be Fishin'"] = "Без рыбалки",
        ["Rattling the Rattlecages"] = "Игрушки-погремушки",
        ["Ravager Egg Roundup"] = "Сбор яиц опустошителей",
        ["Raven Hill"] = "Вороний холм",
        ["Razorhide"] = "Иглошкура",
        ["Razormaw"] = "Острозуб",
        ["Razzeric's Tweaking"] = "Настройки Раззерика",
        ["Reagents for Reclaimers Inc."] = "Реактивы для Горной корпорации",
        ["Rear Guard Patrol"] = "Патруль в арьергарде",
        ["Reassignment"] = "Новое назначение",
        ["Recently Living"] = "Живая ветка",
        ["Reception from Tyrande"] = "Приглашение от Тиренд",
        ["Recharging the Batteries"] = "Перезарядка батарей",
        ["Recipe for Destruction"] = "Рецепт уничтожения",
        ["Recipe of the Kaldorei"] = "Рецепт кальдореев",
        ["Reclaimed Treasures"] = "Возвращенное сокровище",
        ["Reclaimers' Business in Desolace"] = "Поручение в Безлюдье от Горной корпорации",
        ["Reclaiming Felfire Hill"] = "Возрождение холма Сквернопламени",
        ["Reclaiming Goods"] = "Украденные товары",
        ["Reclaiming Holy Grounds"] = "Восстановление Святых земель",
        ["Reclaiming Sunstrider Isle"] = "Очищение острова Солнечного Скитальца",
        ["Reclaiming the Charred Vale"] = "Восстановление Горелой Долины",
        ["Reclaiming the Eggs"] = "Похищенные яйца",
        ["Reclaiming the Ruins"] = "Возвращение руин",
        ["Recover the Bones"] = "Сбор останков",
        ["Recover the Key!"] = "Отыщите ключ!",
        ["Red Leather Bandanas"] = "Красные кожаные банданы",
        ["Red Linen Goods"] = "Красный лен",
        ["Red Silk Bandanas"] = "Красные шелковые банданы",
        ["Red Snapper - Very Tasty!"] = "Деликатесный красный луциан",
        ["Redeeming the Dead"] = "Воскрешение",
        ["Redemption"] = "Искупление",
        ["Redemption Boots"] = "Сапоги Искупления",
        ["Redemption Girdle"] = "Тесьма Искупления",
        ["Redemption Handguards"] = "Боевые краги Искупления",
        ["Redemption Headpiece"] = "Головной убор Искупления",
        ["Redemption Tunic"] = "Туника Искупления",
        ["Redemption Wristguards"] = "Запястья Искупления",
        ["Redridge Goulash"] = "Гуляш по-красногорски",
        ["Redridge Rendezvous"] = "Встреча у Красных гор",
        ["Refuel for the Zapping"] = "Новая энергия для уменьшения",
        ["Regthar Deathgate"] = "Регтар Врата Погибели",
        ["Reinforcements for Garadar"] = "Подкрепления для Гарадара",
        ["Rejold's New Brew"] = "Новое пиво Реджолда",
        ["Release Them"] = "Отпусти их.",
        ["Rellian Greenspyre"] = "Релиан Зеленый Росток",
        ["Remorseful Highborne"] = "Раскаявшийся Высокорожденный",
        ["Replacement Phial"] = "Запасной фиал",
        ["Replenishing the Healing Crystals"] = "Исцеляющие кристаллы",
        ["Report Back to Fizzlebub"] = "Вернуться к Кранку Шипучке",
        ["Report from the Northern Front"] = "Донесение с северного фронта",
        ["Report to Anastasia"] = "Задание Анастасии",
        ["Report to Captain Helios"] = "Донесение капитану Хелиосу",
        ["Report to Captain Stoutfist"] = "Доклад капитану Крепкому Кулаку",
        ["Report to Doren"] = "Доклад Дорену",
        ["Report to Engineering"] = "Рапорт главному инженеру",
        ["Report to Exarch Admetius"] = "Доклад экзарху Адметиусу",
        ["Report to General Kirika"] = "Генерал Кирика",
        ["Report to Goldshire"] = "Донесение в Златоземье",
        ["Report to Gryan Stoutmantle"] = "Доклад Гриану Сильноплечему",
        ["Report to Hadrec"] = "Доложиться Хадрику",
        ["Report to Helgrum"] = "Донесение  Хелгруму",
        ["Report to Ironforge"] = "Отчет в Стальгорн",
        ["Report to Jennea"] = "Задание Джиннии",
        ["Report to Lanthan Perilon"] = "Визит к Лантану Перилону",
        ["Report to Magister Kaendris"] = "Доклад магистру Каэндрису",
        ["Report to Marshal Bluewall"] = "Маршал Синяя Стена",
        ["Report to Mountaineer Rockgar"] = "Поход Скального Панцирника",
        ["Report to Nazgrel"] = "Донесение Назгрелу",
        ["Report to Orgnil"] = "Явиться к Оргни",
        ["Report to Sen'jin Village"] = "Деревня Сенджин",
        ["Report to Shadow Hunter Denjai"] = "Донесение Ловцу Духов Денджайе",
        ["Report to Splintertree Post"] = "Явиться на заставу Расщепленного Древа",
        ["Report to Stonebreaker Camp"] = "Донесение в лагерь Каменотеса",
        ["Report to Tarren Mill"] = "Возвращение в Мельницу Таррен",
        ["Report to Thomas"] = "Доклад для Томаса",
        ["Report to Zor"] = "Сообщение для Зора",
        ["Report to Zurai"] = "Донесение Зураю",
        ["Report to the Allerian Post"] = "Послание для Аллерийской заставы.",
        ["Request for Assistance"] = "Запрос о содействии",
        ["Rescue Deirom!"] = "Спасите Дейрома!",
        ["Rescue Dugar!"] = "Спасите Дугара!",
        ["Rescue From Jaedenar"] = "Спасение из Джеденара",
        ["Rescue OOX-09/HL!"] = "Спасти OOX-09/HL!",
        ["Rescue OOX-17/TN!"] = "Спасти OOX-17/TN!",
        ["Rescue OOX-22/FE!"] = "Спасти OOX-22/FE!",
        ["Rescue the Survivors!"] = "Помощь выжившим",
        ["Research Notes"] = "Исследовательские записи",
        ["Researching the Corruption"] = "Исследование порчи",
        ["Rest and Relaxation"] = "Отдых и покой",
        ["Resting in Pieces"] = "В целости и сохранности",
        ["Restless Activity"] = "Неустанный труд",
        ["Restoring Fiery Flux Supplies via Heavy Leather"] = "Пополнить запасы огненного флюса с помощью тяжелой кожи",
        ["Restoring Fiery Flux Supplies via Iron"] = "Пополнить запасы огненного флюса с помощью железа",
        ["Restoring Fiery Flux Supplies via Kingsblood"] = "Пополнить запасы огненного флюса с помощью королевской крови",
        ["Restoring Sanctity"] = "Святотатство",
        ["Restoring the Light"] = "Возрождение Света",
        ["Restoring the Necklace"] = "Восстановить ожерелье",
        ["Resupplying the Excavation"] = "Снабжение экспедиции",
        ["Retaking Windrunner Spire"] = "Возвращение башни Летящих Ветров",
        ["Rethban Ore"] = "Ретбанская руда",
        ["Retribution of the Light"] = "Возмездие Света",
        ["Retrieving the Goods"] = "Сбор деталей",
        ["Return Trip"] = "Возвращение",
        ["Return of the Ring"] = "Возвращение кольца",
        ["Return the Book"] = "Книга Гюнтера",
        ["Return the Comb"] = "Гребень для Эвы",
        ["Return the Reports"] = "Возвращение с донесениями",
        ["Return the Statuette"] = "Возвращение статуэтки",
        ["Return to Andormu"] = "Возвращение к Андорму",
        ["Return to Apothecary Zinge"] = "Возвращение к аптекарю Зинг",
        ["Return to Arcanist Vandril"] = "Возвращение к чародею Вандрилу",
        ["Return to Bellowfiz"] = "Возвращение к Брюхинсу",
        ["Return to Bodley"] = "Возвращение к Бодли",
        ["Return to Brock"] = "Возвращение к Броку",
        ["Return to Chillwind Camp"] = "Возвращение в лагерь Холодного Ветра",
        ["Return to Chromie"] = "Возвращение к Хроми",
        ["Return to Corporal Kaleb"] = "Возвращение к капралу Калебу.",
        ["Return to Deliana"] = "Возвращение к Делиане",
        ["Return to Denalan"] = "Возвращение к Деналану",
        ["Return to Feathermoon Stronghold"] = "Возвращение в крепость Лунного Пера",
        ["Return to Fel'Zerul"] = "Возвращение к  Фелзерулу",
        ["Return to Honor Hold"] = "Возвращение в Оплот Чести",
        ["Return to Ironforge"] = "Возвращение в Стальгорн",
        ["Return to Jitters"] = "Возвращение к Джиттерсу",
        ["Return to Khadgar"] = "Возвращение в Каражан",
        ["Return to Kristoff"] = "Возвращение к Кристофу",
        ["Return to Lewis"] = "Возвращение к Льюису",
        ["Return to MacKinley"] = "Возвращение к МакКинли",
        ["Return to Marleth"] = "Возвращение к Марлетте",
        ["Return to Milton"] = "Возвращение к Милтону",
        ["Return to Mokvar"] = "Возвращение к Моквару",
        ["Return to Narain"] = "Возвращение к Нарайну",
        ["Return to Nathanos"] = "Назад к Натаносу",
        ["Return to Nessa"] = "Возвращение к Нессе",
        ["Return to Obadei"] = "Возвращение к Обадии",
        ["Return to Onu"] = "Возвращение к Ону",
        ["Return to Podrig"] = "Обратно к Подригу",
        ["Return to Primal Torntusk"] = "Возвращение к старейшей Зазубренный Клык",
        ["Return to Quartermaster Lymel"] = "Возвращение к перекупщице Лаймель",
        ["Return to Quinn"] = "Назад к Квинну",
        ["Return to Rokag"] = "Обратно к Рокагу",
        ["Return to Sha'tari Base Camp"] = "Обратно в лагерь Ша'тари",
        ["Return to Shattrath"] = "Обратно в Шаттрат",
        ["Return to Silvermoon"] = "Возвращение в Луносвет",
        ["Return to Sven"] = "Возвращение к Свену",
        ["Return to Talionia"] = "Возвращение к Талионии",
        ["Return to Thalodien"] = "Возвращение к Талодиену",
        ["Return to Thander"] = "Обратно к Тандеру",
        ["Return to Thrallmar"] = "Назад в Траллмар",
        ["Return to Thunder Bluff"] = "Возвращение в Громовой Утес",
        ["Return to Tinkee"] = "Возвращение к Тинки",
        ["Return to Topher Loaal"] = "Возвращение к Тоферу Лоаалу",
        ["Return to Troyas"] = "Возвращение к Троясу",
        ["Return to Tymor"] = "Возвращение к Тимору",
        ["Return to Vahlarriel"] = "Возвращение к Валарриэлю",
        ["Return to Verner"] = "Доставка подков",
        ["Return to Witch Doctor Uzer'i"] = "Возвращение к знахарю Узери",
        ["Return to the Abyssal Shelf"] = "Возвращение на Уступ Преисподней",
        ["Return to the Aldor"] = "Возвращение к Альдору",
        ["Return to the Blasted Lands"] = "Возвращение в Опаленные земли",
        ["Return to the Bulwark"] = "Возвращение в Бастион",
        ["Return to the Crossroads."] = "Возвращение на Перекресток",
        ["Return to the Greatmother"] = "Возвращение к Великой матери",
        ["Return to the Hinterlands"] = "Назад во Внутренние земли",
        ["Return to the Magistrate"] = "Возвращение к чиновнику",
        ["Return to the Marsh"] = "Назад в болото",
        ["Return to the Scryers"] = "Возвращение к Видящим",
        ["Returning Home"] = "Нашествие силитидов",
        ["Returning the Cleansed Orb"] = "Возвращение к Менаре",
        ["Returning the Favor"] = "Взаимная вежливость",
        ["Returning the Lost Satchel"] = "Возвращение потерянного ранца",
        ["Reunion"] = "Воссоединение",
        ["Revenge of Gann"] = "Месть Ганна",
        ["Revered Among the Sha'tar"] = "Почтительное отношение Ша'тар",
        ["Rhapsody Shindigger"] = "Рапсодия Землекоп",
        ["Rhapsody's Kalimdor Kocktail"] = "Калимдорский коктейль",
        ["Rhapsody's Tale"] = "Рапсодия о болоте",
        ["Ribbly Screwspigot"] = "Риббли Винтокран",
        ["Ride the Lightning"] = "Оседлать молнию",
        ["Ride to Ironforge"] = "Полет в Стальгорн",
        ["Ride to Orgrimmar"] = "Дорога до Оргриммара",
        ["Ride to Thunder Bluff"] = "Дорога до Громового Утеса",
        ["Ride to the Undercity"] = "Полет в Подгород",
        ["Ridgespine Menace"] = "Угроза горного хребта",
        ["Rig Wars"] = "Военная техника",
        ["Rightful Repossession"] = "Изъятие по праву",
        ["Rilli Greasygob"] = "Рилли Комок Грязи",
        ["Rin'ji is Trapped!"] = "Ринджи в ловушке",
        ["Rin'ji's Secret"] = "Секрет Ринджи",
        ["Ring of Infinite Wisdom"] = "Кольцо Бесконечной мудрости",
        ["Ring of Unspoken Names"] = "Кольцо Неназванных Имен",
        ["Ring of the Gathering Storm"] = "Кольцо Надвигающейся бури",
        ["Ripple Delivery"] = "Груз медовухи",
        ["Ripple Recovery"] = "За медовухой",
        ["Rise of the Silithid"] = "Возвышение силитидов",
        ["Rising Spirit"] = "Высокий дух",
        ["Rite of Strength"] = "Обряд Силы",
        ["Rite of Vision"] = "Обряд прозрения",
        ["Rite of Wisdom"] = "Обряд мудрости",
        ["Rites of the Earthmother"] = "Обряды Матери-Земли",
        ["Rituals of Power"] = "Обряды силы",
        ["Rituals of Strength"] = "Ритуалы Силы",
        ["Riverpaw Gnoll Bounty"] = "Награда за гноллов",
        ["Rizzle's Schematics"] = "Чертежи Риззла",
        ["Road to Salvation"] = "Путь к спасению",
        ["Roadside Ambush"] = "Засада на дороге",
        ["Rocket Car Parts"] = "Обломки болидов",
        ["Rocknot's Ale"] = "Эль для Каменного Узла",
        ["Rogue Training"] = "Обучение разбойника",
        ["Rogues of the Shattered Hand"] = "Разбойники Раздробленной Руки",
        ["Rohok's Request"] = "Просьба Рохока",
        ["Roll the Bones"] = "Игра в кости",
        ["Root Samples"] = "Образцы корней",
        ["Rot Hide Clues"] = "Необычная находка",
        ["Rot Hide Ichor"] = "Лимфа Гнилой Шкуры",
        ["Rot Hide Origins"] = "Происхождение гнилошкуров",
        ["Rotten Eggs"] = "Тухлые яйца",
        ["Rotting Hearts"] = "Гниющие сердца",
        ["Rude Awakening"] = "Резкое пробуждение",
        ["Ruined Kegs"] = "Поломанные бочки",
        ["Rumors for Kravel"] = "Сплетни для Крейвела",
        ["Run a Diagnostic!"] = "Провести диагностику",
        ["Rune Covered Tablet"] = "Руническая табличка",
        ["Rune-Inscribed Note"] = "Руническая записка",
        ["Rune-Inscribed Parchment"] = "Рунический пергамент",
        ["Rune-Inscribed Tablet"] = "Руническая табличка",
        ["Runecloth"] = "Рунная ткань",
        ["Runewarden Deryan"] = "Хранитель рун Дериан",
        ["Ruthless Cunning"] = "Безжалостное коварство",
        ["Ruuan Weald"] = "Руан Веальд",
        ["Ruuzel"] = "Руузель",
        ["S-A-B-O-T-A-G-E"] = "С-А-Б-О-Т-А-Ж",
        ["SI:7"] = "ШРУ",
        ["STOLEN: Smithing Tuyere and Lookout's Spyglass"] = "УКРАДЕНО: кузнечное сопло и подзорная труба наблюдателя",
        ["Sabotage the Warp-Gate!"] = "Саботаж в портале",
        ["Sacred Cloth"] = "Священная ткань",
        ["Sacred Fire"] = "Священное пламя",
        ["Safeguarding the Watchers"] = "Защита наблюдателей",
        ["Safety First"] = "Безопасность превыше всего",
        ["Safety Is Job One"] = "Safety Is Job One",
        ["Salt Flat Venom"] = "Яд Соляных равнин",
        ["Salt of the Scorpok"] = "Скорпоковая соль",
        ["Saltheril's Haven"] = "Гавань Салтерила",
        ["Salvaging the Data"] = "Цена знания - жизнь",
        ["Salvaging the Past"] = "Спасение прошлого",
        ["Samophlange"] = "Самофланж",
        ["Samophlange Manual"] = "Руководство по самофланжу",
        ["Sample for Helbrim"] = "Образец для Хелбрима",
        ["Sara Balloo's Plea"] = "Просьба Сары Баллу",
        ["Sarkoth"] = "Саркот",
        ["Sathrah's Sacrifice"] = "Жертвоприношение Сатры",
        ["Satyr Hooves"] = "Копыта сатиров",
        ["Satyr Horns"] = "Рога сатира",
        ["Satyr Slaying!"] = "Сатир убит!",
        ["Savage Flora"] = "Дикая флора",
        ["Savage Fronds"] = "Дикие ростки",
        ["Save Techbot's Brain!"] = "Промыть мозг Техноботу",
        ["Saving Princess Stillpine"] = "Спасение принцессы клана Безмолвной Сосны",
        ["Saving Sharpbeak"] = "Спасение Остроклюва",
        ["Saving Yenniku"] = "Спасение Йеннику",
        ["Saving the Best for Last"] = "Сладкое - на закуску",
        ["Saving the Sporeloks"] = "Спасение спорлоков",
        ["Scalding Mornbrew Delivery"] = "Жгучая бражка",
        ["Scarab Shells"] = "Панцири скарабеев",
        ["Scaring Shaky"] = "Напугать Трясуна",
        ["Scarlet Diversions"] = "Вылазка в стан Алого Марша",
        ["Scarlet Subterfuge"] = "Уловка против Алого Марша",
        ["Scavenging Deathknell"] = "Поиски старой одежды",
        ["Scepter of the Council"] = "Скипетр Совета",
        ["Sceptre of Light"] = "Скипетр Света",
        ["Scholomance"] = "Некроситет",
        ["Scourge of the Downs"] = "Плеть в холмах",
        ["Scouring the Desert"] = "Истощение пустыни",
        ["Scouting the Defenses"] = "Разведка укреплений",
        ["Scratches"] = "Рисунки",
        ["Screecher Spirits"] = "Духи визгуна",
        ["Scrounging"] = "Помогите кто чем может!",
        ["Scrying Goggles? No Problem!"] = "Гадальные очки? Без проблем!",
        ["Seal of Ascension"] = "Печать Вознесения",
        ["Sealed Azure Bag"] = "Запечатанная лазурная сумка",
        ["Search More Hovels"] = "Поиски в поселениях морлоков",
        ["Search Stillpine Hold"] = "Обыск форта Безмолвной Сосны",
        ["Search for Incendicite"] = "Поиски огневита",
        ["Search for Tyranis"] = "Поиски Тираниса",
        ["Searching for Evidence"] = "В поисках доказательств",
        ["Searching for Galaen"] = "В поисках Галена",
        ["Searching for Scout Jyoba"] = "Поиски разведчика Джиобы",
        ["Searching for the Lost Satchel"] = "В поисках потерянного ранца",
        ["Seasoned Wolf Kabobs"] = "Пряные котлеты из волчатины",
        ["Secret of the Circle"] = "Тайна камня",
        ["Secrets of the Arakkoa"] = "Тайны араккоа",
        ["Secrets of the Colossus - Ashi"] = "Тайны колосса - Аши",
        ["Secrets of the Daggerfen"] = "Тайны Кинжальной топи",
        ["Securing the Celestial Ridge"] = "Безопасность Небесного Гребня",
        ["Securing the Lines"] = "Обеспечение безопасного сообщения",
        ["Securing the Shaleskin Shale"] = "Добыча глины кожеглина",
        ["Seed of Life"] = "Семя Жизни",
        ["Seeing What Happens"] = "Посмотрим, что будет дальше",
        ["Seek Huntress Kella Nightbow"] = "Охотница Келла Лук Ночи",
        ["Seek Out Kirrik"] = "Поиски Киррика",
        ["Seek Out Neltharaku"] = "Поиски Нэльтараку",
        ["Seek Redemption!"] = "Искупи вину!",
        ["Seek out SI: 7"] = "Выход на ШРУ",
        ["Seek the Farstriders"] = "На поиски Странников",
        ["Seeking Strahad"] = "В поисках Страхада",
        ["Seeking Wisdom"] = "В поисках мудрости",
        ["Seeking the Kor Gem"] = "Поиск самоцвета Кора",
        ["Seeping Corruption"] = "Разносчик заразы",
        ["Seer Udalo"] = "Провидец Адало",
        ["Selling Fish"] = "Продажа рыбы",
        ["Senir's Observations"] = "Наблюдения Сенира",
        ["Sentinel Advanced Care Package"] = "Доукомплектованная амуниция Стража",
        ["Sentinel Basic Care Package"] = "Амуниция Стражей",
        ["Sentinel Standard Care Package"] = "Стандартная амуниция Стража",
        ["Separation Anxiety"] = "Воссоединение останков",
        ["Serena Bloodfeather"] = "Серена Кровавое Перо",
        ["Sergra Darkthorn"] = "Сергра Черный Шип",
        ["Serpent Wild"] = "Свихнувшаяся змея",
        ["Serpentbloom"] = "Змеецвет",
        ["Service to the Horde"] = "Служба Орде",
        ["Set Them Ablaze!"] = "Задай им жару!",
        ["Setting Up the Bomb"] = "Сборка бомбы",
        ["Shadow Magic"] = "Темная магия",
        ["Shadow of the Past"] = "Тень прошлого",
        ["Shadoweaver"] = "Тенешелк",
        ["Shadowpine Weaponry"] = "Оружие Тени Сосны",
        ["Shadowshard Fragments"] = "Фрагменты осколка сумрака",
        ["Shadumbra's Head"] = "Голова Шэдумбры",
        ["Shaman Training"] = "Обучение шамана",
        ["Shard of a Felhound"] = "Осколок гончей скверны",
        ["Shard of an Infernal"] = "Осколок огненного голема",
        ["Shards of the Felvine"] = "Осколки сквернита",
        ["Shardtooth E'ko"] = "Камень Э'ко из племени Сколотого Клыка",
        ["Sharing the Knowledge"] = "Наделение знаниями",
        ["Sharing the Land"] = "Недобрые соседи",
        ["Sharptalon's Claw"] = "Коготь гиппогрифа Острый Удар",
        ["Shatter Point"] = "Застава-на-Обломках",
        ["Shattering the Veil"] = "Сорвать маску",
        ["Shimmer Stout"] = "Мерцающий портер",
        ["Ship Schedules"] = "Корабельное расписание",
        ["Shipment to Stormwind"] = "Посылка в Штормград",
        ["Shizz Work"] = "Шизанутая работенка",
        ["Shizzle's Flyer"] = "Крылолет Шиззла",
        ["Shoulderpads of Faith"] = "Наплечные пластины Веры",
        ["Show Gnomercy"] = "Не ведая пощады",
        ["Show Them Gnome Mercy!"] = "Попомните гномскую доброту!",
        ["Show Your Work"] = "Покажи свою работу",
        ["Showdown"] = "Конец игры",
        ["Shredding Machines"] = "Механические измельчители",
        ["Shroud of Infinite Wisdom"] = "Накидка Бесконечной мудрости",
        ["Shroud of Unspoken Names"] = "Накидка Неназванных имен",
        ["Shrouded in Nightmare"] = "Под покровом кошмара",
        ["Shutting Down Manaforge Ara"] = "Отключить Кузню маны Ара",
        ["Shutting Down Manaforge B'naar"] = "Отключить Кузню маны Б'наар",
        ["Shutting Down Manaforge Coruu"] = "Отключить Кузню маны Коруу",
        ["Shutting Down Manaforge Duro"] = "Отключить Кузню маны Даро",
        ["Shy-Rotam"] = "Ши-Ротам",
        ["Sickle of Unyielding Strength"] = "Серп Неукротимой силы",
        ["Sigil of Arathor"] = "Печать Аратора",
        ["Sigil of Strom"] = "Печать Штрома",
        ["Sigil of Thoradin"] = "Печать Торадина",
        ["Sigil of Trollbane"] = "Печать Тролльей Погибели",
        ["Signal for Pickup"] = "Сигнал \"Взять на борт!\"",
        ["Signet of Unyielding Strength"] = "Перстень Неукротимой силы",
        ["Signet of the Dukes"] = "Перстень герцогов",
        ["Signet of the Unseen Path"] = "Перстень Незримого пути",
        ["Signets of the Zandalar"] = "Перстни Зандалара",
        ["Signs of the Legion"] = "Знаки Легиона",
        ["Silkwing Cocoons"] = "Коконы шелкокрыла",
        ["Silver Heart"] = "Серебряное сердце",
        ["Simple Letter"] = "Обычное письмо",
        ["Simple Memorandum"] = "Простая памятная записка",
        ["Simple Note"] = "Простая записка",
        ["Simple Parchment"] = "Записка на пергаменте",
        ["Simple Rune"] = "Простая руна",
        ["Simple Scroll"] = "Простой свиток",
        ["Simple Sigil"] = "Простой знак",
        ["Simple Subterfugin'"] = "Простая уловка",
        ["Simple Tablet"] = "Простая табличка",
        ["Since Time Forgotten..."] = "С незапамятных времен...",
        ["Singing Blue Shards"] = "Осколки Поющих кристаллов",
        ["Single Firewing Signet"] = "Перстень Огненных Крыльев",
        ["Single Mark of Kil'jaeden"] = "Знак Кил-Джедена",
        ["Single Mark of Sargeras"] = "Знак Саргараса",
        ["Sister Pamela"] = "Сестренка Памела",
        ["Situation at Sunsail Anchorage"] = "Проблемы на Стоянке Солнечного Паруса",
        ["Skeletal Fragments"] = "Фрагменты скелетов",
        ["Skirmish at Echo Ridge"] = "Схватка у рудника Горного эха",
        ["Skulk Rock Clean-up"] = "Зачистка Потаенной скалы",
        ["Skull Rock"] = "Скала Черепа",
        ["Skullsplitter Tusks"] = "Клыки троллей",
        ["Skymistress Gloaming"] = "Поднебесница Сумерки",
        ["Slain by the Wretched"] = "Убит Презренными",
        ["Slake That Thirst"] = "Утолить жажду",
        ["Slaughter at Boulder'mok"] = "Резня в Валунмоке",
        ["Slay the Brood Mother"] = "Убить мать драконов",
        ["Slaying the Beast"] = "Убить тварь",
        ["Small Furry Paws"] = "Маленькие мохнатые лапки",
        ["Smart Drinks"] = "Умный напиток",
        ["Smith Mathiel"] = "Кузнец Матиль",
        ["Smooth as Butter"] = "Летать как птица",
        ["Snakestone of the Shadow Huntress"] = "Змеекамень Пленяющей Духов",
        ["Snatch and Grab"] = "Держи-хватай!",
        ["Snickerfang Jowls"] = "Челюсти гиены-ухмыльника",
        ["Soaked Pages"] = "Промокшие страницы",
        ["Socrethar's Shadow"] = "Тень Сокретара",
        ["Soft Bushy Tails"] = "Мягкие, пушистые хвосты",
        ["Solanian's Belongings"] = "Вещи Соланиана",
        ["Solomon's Law"] = "Закон Соломона",
        ["Solution to Doom"] = "Лекарство от судьбы",
        ["Solving the Problem"] = "Решение проблемы",
        ["Some Assembly Required"] = "Добыча шкур",
        ["Someone Else's Hard Work Pays Off"] = "Чужими руками жар загребать...",
        ["Soothing Spices"] = "Ароматные специи",
        ["Soothing Turtle Bisque"] = "Нежный черепаховый суп",
        ["Soulbound Keepsake"] = "Книга Души",
        ["Source of the Corruption"] = "Источник Скверны",
        ["Southsea Freebooters"] = "Корсары Южного моря",
        ["Southsea Shakedown"] = "Покажи этим пиратам",
        ["Southshore"] = "Южнобережье",
        ["Souvenirs of Death"] = "Сувениры смерти",
        ["Spare Parts"] = "Запасные части",
        ["Spawn of Jubjub"] = "Потомство Жабжаб",
        ["Speak to Nafien"] = "Беседа с Нафиэном",
        ["Speak to Salfa"] = "Разговор с Сальфой",
        ["Speak with Anastasia"] = "Поговорить с Анастасией",
        ["Speak with Bink"] = "Поговорите с Бинк",
        ["Speak with Coleman"] = "Поговорить с Коулманом",
        ["Speak with Deino"] = "Поговорить с Деино",
        ["Speak with Dillinger"] = "Поговорить с Диллинджером",
        ["Speak with Gramma"] = "Разговор с бабулей",
        ["Speak with Jennea"] = "Поговорите с Джиннией",
        ["Speak with Private Weeks"] = "Поговорить с рядовым Виксом",
        ["Speak with Renferrel"] = "Беседа с Ренферрелом",
        ["Speak with Rilak the Redeemed"] = "Поговорить с Рилаком Выкупленным",
        ["Speak with Ruga"] = "Поговорить с Ругой",
        ["Speak with Scout Neftis"] = "Поговорить с разведчиком Нефтисом",
        ["Speak with Sevren"] = "Разговор с Севреном",
        ["Speak with Shoni"] = "Разговор с Шони",
        ["Speak with Thun'grim"] = "Поговорить с Тунгримом",
        ["Speak with Un'thuwa"] = "Разговор с Ун-Тувой",
        ["Speaking of Fortitude"] = "Лекция о стойкости духа",
        ["Speaking with Gan'zulah"] = "Разговор с Ган'зулахом",
        ["Speaking with Nezzliok"] = "Разговор с Неззилоком",
        ["Special Delivery for Gaxim"] = "Особая посылка для Гаксима",
        ["Special Forces"] = "Особые войска",
        ["Spectrecles"] = "Спектроскоп",
        ["Spellfire Robes"] = "Одеяние Чародейского огня",
        ["Spinal Dust"] = "Позвоночный порошок",
        ["Spinebreaker Post"] = "Застава Изломанного Хребта",
        ["Spirit Calling"] = "Зов духов",
        ["Spirit Totem"] = "Тотем Духа",
        ["Spirit of the Boar"] = "Дух кабана",
        ["Spirit of the Wind"] = "Дух Ветра",
        ["Spirits of the Drowned"] = "Духи утопших",
        ["Spirits of the Feralfen"] = "Духи Зверотопи",
        ["Spiritual Domination"] = "Духовное господство",
        ["Spiritual Unrest"] = "Духовное беспокойство",
        ["Spleendid!"] = "Умопотрошительно!",
        ["Split Bone Necklace"] = "Ожерелье Расколотых костей",
        ["Sporeggar"] = "Спороггар",
        ["Sprinkle's Secret Ingredient"] = "Маленький секрет Мороси",
        ["Squire Maltrake"] = "Оруженосец Малтрейк",
        ["Stalking the Stalkers"] = "Охота на бродяг",
        ["Stalwart's Battlegear"] = "Стойкая броня",
        ["Standards and Practices"] = "Страх и уважение",
        ["Starfall"] = "Звездопад",
        ["Stave of the Ancients"] = "Ветвь ходячего Древа",
        ["Stealing Back the Mushrooms"] = "Ворованные грибы",
        ["Stealing Knowledge"] = "Тайненькое знаньице",
        ["Stealing Supplies"] = "Похищение припасов",
        ["Stealing from Thieves"] = "Украсть у вора",
        ["Stealth Flight"] = "Тайный полет",
        ["Steelsnap"] = "Сталезуб",
        ["Stepping Up Security"] = "Обеспечение безопасности",
        ["Still Believing"] = "Не теряя веры",
        ["Stillpine Hold"] = "Форт Безмолвной Сосны",
        ["Sting of the Scorpid"] = "Жало скорпида",
        ["Stinger Venom"] = "Яд паразита",
        ["Stinging the Stingers"] = "Поделом гнусным тварям!",
        ["Stinglasher"] = "Ядохлест",
        ["Stinking Up Southshore"] = "Чем пахнет в Южнобережье",
        ["Stinky's Escape"] = "Спасение Вонючки",
        ["Stocking Jetsteam"] = "Заготовка продовольствия",
        ["Stolen Booty"] = "Украденное добро",
        ["Stolen Silver"] = "Похищенное серебро",
        ["Stoley's Debt"] = "Долг Столи",
        ["Stoley's Shipment"] = "Посылка Столи",
        ["Stone Tokens"] = "Каменные талисманы",
        ["Stonegear's Search"] = "Поиск Каменного Убора",
        ["Stones of Binding"] = "Камни Обета",
        ["Stonetalon Standstill"] = "Затруднения у  Каменного Когтя",
        ["Stopping the Spread"] = "Остановить заразу",
        ["Stormers and Rumblers"] = "Буря в пустыне",
        ["Stormpike's Deciphering"] = "Дешифрование",
        ["Stormpike's Delivery"] = "Посылка для Грозовой Вершины",
        ["Stormpike's Order"] = "Заказ Грозовой Вершины",
        ["Stormwind Ho!"] = "Ха, Штормград!",
        ["Stormwind Library"] = "Библиотека Штормграда",
        ["Stormwind Rendezvous"] = "Встреча в Штормграде",
        ["Stout to Kadrell"] = "Портер для Кэдрелла",
        ["Strained Supplies"] = "Нехватка припасов",
        ["Strange Alliance"] = "Странный союз",
        ["Strange Brew"] = "Странное пойло",
        ["Strange Energy"] = "Странная энергия",
        ["Strange Findings"] = "Странные находки",
        ["Strange Sources"] = "Выяснение причин",
        ["Stranglethorn Fever"] = "Лихорадка долины Чародеев",
        ["Strength of One"] = "Силой единой",
        ["Striker's Diadem"] = "Диадема бойца",
        ["Striker's Footguards"] = "Берцы бойца",
        ["Striker's Hauberk"] = "Хауберк Бойца",
        ["Stromgarde Badges"] = "Знаки Штромгарда",
        ["Study of the Elements: Rock"] = "Изучение стихий: Камень",
        ["Stymying the Arakkoa"] = "Сдержать араккоа",
        ["Success!"] = "Успех!",
        ["Sully Balloo's Letter"] = "Письмо Салли Баллу",
        ["Summon Felsteed"] = "Призывание жуткого коня",
        ["Summoner Kanthin's Prize"] = "Трофей призывателя Кантина",
        ["Summoning Shadra"] = "Вызов Шадры",
        ["Summoning the Princess"] = "Вызов принцессы",
        ["Summons from Knight-Lord Bloodvalor"] = "Призыв лорда-рыцаря Кровавой Доблести",
        ["Suncrown Village"] = "Деревня Солнечной короны",
        ["Sunfury Briefings"] = "Инструкции Гневного Солнца",
        ["Sunfury Signets"] = "Перстни Гневного Солнца",
        ["Sunken Treasure"] = "Утонувшее сокровище",
        ["Sunscorched Shells"] = "Высохшая скорлупа",
        ["Suntara Stones"] = "Камни Сунтары",
        ["Super Reaper 6000"] = "Супер-дровосек 6000",
        ["Super Sticky"] = "Липучка",
        ["Superior Armaments of Battle - Exalted Amongst the Dawn"] = "Превосходное боевое снаряжениее - Восторг Рассвета",
        ["Superior Armaments of Battle - Friend of the Dawn"] = "Превосходное боевое снаряжениее - Друг Рассвета",
        ["Superior Armaments of Battle - Honored Amongst the Dawn"] = "Превосходное боевое снаряжение - Уважаемый Рассветом",
        ["Superior Armaments of Battle - Revered Amongst the Dawn"] = "Превосходное боевое снаряжениее - Чтимый Рассветом",
        ["Supervisor Fizsprocket"] = "Бригадир Физспрокет",
        ["Supplies for Nethergarde"] = "Поставки для Стражей бездны",
        ["Supplies for the Crossroads"] = "Снабжение Перекрестка",
        ["Supplies from Darkshire"] = "Припасы из Темнолесья",
        ["Supplies to Auberdine"] = "Поставка для Аубердина",
        ["Supplies to Private Thorsen"] = "Припасы для рядового Торсена",
        ["Supplies to Tannok"] = "Припасы для Таннока",
        ["Supply and Demand"] = "Спрос и предложение",
        ["Supplying the Front"] = "Помощь фронту",
        ["Supplying the Sepulcher"] = "Поставка оружия",
        ["Surena Caledon"] = "Сурена Каледон",
        ["Surrender to the Horde"] = "Сдаться Орде",
        ["Survey the Land"] = "Разведка",
        ["Surveying the Ruins"] = "Исследование руин",
        ["Suspicious Hoofprints"] = "Подозрительные следы",
        ["Sven's Camp"] = "Лагерь Свена",
        ["Sven's Revenge"] = "Месть Свена",
        ["Sweet Amber"] = "Янтарное сладкое",
        ["Sweet Serenity"] = "Секрет безмятежности",
        ["Swift Discipline"] = "Суровый урок",
        ["Swoop Hunting"] = "Охота на грифов",
        ["Syndicate Assassins"] = "Убийцы Синдиката",
        ["Syndicate Emblems"] = "Эмблемы Синдиката",
        ["Synthesis of Power"] = "Преобразование силы",
        ["Tabards of the Illidari"] = "Тапперты Иллидари",
        ["Tabetha's Task"] = "Миссия Табеты",
        ["Tablet of the Seven"] = "Табличка Семерых",
        ["Tablets of Baa'ri"] = "таблички Баа'ри",
        ["Tainted Arcane Sliver"] = "Оскверненный магический осколок",
        ["Tainted Letter"] = "Тайное письмо",
        ["Tainted Memorandum"] = "Гниющая записка",
        ["Tainted Parchment"] = "Нечистый пергамент",
        ["Tainted Scroll"] = "Нечистый свиток",
        ["Take Five Bases"] = "Занять пять баз",
        ["Take Four Bases"] = "Захват четырех баз",
        ["Taken in the Night"] = "Захваченные в ночи",
        ["Taking Back Silithus"] = "Отвоевание Силитуса",
        ["Taking the Fall"] = "Взять вину на себя",
        ["Tal the Wind Rider Master"] = "Тал - мастер Крыла Ветра",
        ["Talbuk Mastery"] = "Охота на талбуков",
        ["Talk to the Hand"] = "Длань Аргуса",
        ["Taming the Beast"] = "Приручение зверя",
        ["Tanaris Field Sampling"] = "Полевые испытания в Танарисе",
        ["Taretha's Gift"] = "Подарок Тареты",
        ["Target: Dalson's Tears"] = "Цель: Слезы Далсона",
        ["Target: Felstone Field"] = "Цель: поле Фелстоун",
        ["Target: Gahrron's Withering"] = "Цель: пустошь Гаррона",
        ["Target: Hive'Ashi Defenders"] = "Цель: защитники из улья Хив-Аши",
        ["Target: Hive'Ashi Sandstalkers"] = "Цель: пескоходы из улья Хив-Аши",
        ["Target: Hive'Ashi Stingers"] = "Цель: жалоносцы из улья Хив-Аши",
        ["Target: Hive'Ashi Workers"] = "Цель: разрушители из улья Хив-Зора",
        ["Target: Hive'Regal Ambushers"] = "Цель: стерегущие из улья Хив-Регал",
        ["Target: Hive'Regal Burrowers"] = "Цель: землерои из улья Хив-Регал",
        ["Target: Hive'Regal Slavemakers"] = "Цель:  поработители из улья Хив-Зора",
        ["Target: Hive'Regal Spitfires"] = "Цель: злюки из улья Хив-Регал",
        ["Target: Hive'Zora Hive Sisters"] = "Цель: сестры-убийцы из улья Хив'Зора",
        ["Target: Hive'Zora Reavers"] = "Цель: разрушители из улья Хив-Зора",
        ["Target: Hive'Zora Tunnelers"] = "Цель: копатели из улья Хив-Зора",
        ["Target: Hive'Zora Waywatchers"] = "Цель: стражи дорог из улья Хив-Зора",
        ["Target: Writhing Haunt"] = "Цель: Призрачная ферма",
        ["Tear of the Earthmother"] = "Слеза Матери-Земли",
        ["Tears of the Moon"] = "Слезы Луны",
        ["Teldrassil"] = "Тельдрассиль",
        ["Teleport This!"] = "Телепортируй это!",
        ["Tenaron's Summons"] = "Вызов Тенарона",
        ["Terokk's Legacy"] = "Наследство Терокка",
        ["Terokkarantula"] = "Тероккарантул",
        ["Teron Gorefiend - Lore and Legend"] = "Терон Жестокосердный - Правда и Вымысел",
        ["Test Flight: Razaan's Landing"] = "Испытательный полет: лагерь Разаана",
        ["Test Flight: Ruuan Weald"] = "Испытательный полет: Руан Веальд",
        ["Test Flight: The Singing Ridge"] = "Испытательный полет: Поющий гребень",
        ["Test Flight: The Zephyrium Capacitorium"] = "Испытательный полет: Конденсаторий зефира",
        ["Test of Endurance"] = "Испытание выносливости",
        ["Test of Faith"] = "Испытание веры",
        ["Test of Lore"] = "Испытание знаний",
        ["Test of Strength"] = "Испытание силы",
        ["Testing an Enemy's Strength"] = "Испытание силы врага",
        ["Testing for Corruption - Felwood"] = "Проба - образцы из Фелвудского леса",
        ["Testing for Impurities - Un'Goro Crater"] = "Проба - образцы из кратера Ан-Горо",
        ["Testing the Antidote"] = "Проверка противоядия",
        ["Testing the Prototype"] = "Испытание прототипа",
        ["Testing the Tonic"] = "Испытание тоника",
        ["Testing the Vessel"] = "Испытание сосуда",
        ["Thadius Grimshade"] = "Тадиус Мрачная Тень",
        ["Thalanaar Delivery"] = "Посылка в Таланаар",
        ["Tharil'zun"] = "Тарил'зун",
        ["Tharnariun's Hope"] = "Надежда Тарнариуна",
        ["That Little Extra Kick"] = "Немного дополнительной силы",
        ["That's Asking A Lot"] = "Работу пополам",
        ["Thazz'ril's Pick"] = "Кирка Таззрила",
        ["The Absent Minded Prospector"] = "Рассеянный изыскатель",
        ["The Active Agent"] = "Вирус чумы",
        ["The Admiral's Orders"] = "Приказы адмирала",
        ["The Affray"] = "Побоище",
        ["The Agitated Ancestors"] = "Покой предков",
        ["The Agony and the Darkness"] = "Тьма и агония",
        ["The Algaz Gauntlet"] = "Битва при Дун Альгаз",
        ["The All-Seeing Eye of Zuldazar"] = "Всевидящее Око Зулдазара",
        ["The Alliance Needs Iron Bars!"] = "Альянсу не хватает железных слитков!",
        ["The Alliance Needs Light Leather!"] = "Альянсу не хватает легкой кожи!",
        ["The Alliance Needs Linen Bandages!"] = "Альянсу не хватает льняных бинтов!",
        ["The Alliance Needs Medium Leather!"] = "Альянсу не хватает средней кожи!",
        ["The Alliance Needs More Copper Bars!"] = "Альянсу все еще не хватает медных слитков!",
        ["The Alliance Needs More Linen Bandages!"] = "Альянсу по-прежнему не хватает льняных бинтов!",
        ["The Alliance Needs More Medium Leather!"] = "Альянсу по-прежнему не хватает средней кожи!",
        ["The Alliance Needs More Silk Bandages!"] = "Альянсу по-прежнему не хватает шелковых бинтов!",
        ["The Alliance Needs More Spotted Yellowtail!"] = "Альянсу по-прежнему не хватает пятнистого желтохвоста!",
        ["The Alliance Needs More Thorium Bars!"] = "Альянсу по-прежнему не хватает ториевых слитков!",
        ["The Alliance Needs Runecloth Bandages!"] = "Альянсу не хватает бинтов из рунной ткани!",
        ["The Alliance Needs Silk Bandages!"] = "Альянсу не хватает шелковых бинтов!",
        ["The Alliance Needs Spotted Yellowtail!"] = "Альянсу не хватает пятнистого желтохвоста!",
        ["The Altar of Zul"] = "Алтарь Зула",
        ["The Ancient Egg"] = "Древнее яйцо",
        ["The Ancient Leaf"] = "Древний лист",
        ["The Ancient Statuette"] = "Древняя статуэтка",
        ["The Angry Scytheclaws"] = "Разъяренные когтедеры",
        ["The Annals of Darrowshire"] = "Анналы Дарроушира",
        ["The Annals of Kirin'Var"] = "Летописи Кирин'Вара",
        ["The Apes of Un'Goro"] = "Обезьяны Ан-Горо",
        ["The Apple Falls"] = "Катись, яблочко...",
        ["The Arakkoa Threat"] = "Угроза Араккоа",
        ["The Arcanist's Cookbook"] = "Поваренная книга чародея",
        ["The Archivist"] = "Архивариус",
        ["The Archmage's Staff"] = "Посох Верховного Мага",
        ["The Argent Hold"] = "Серебряный Оплот",
        ["The Art of Fel Reaver Maintenance"] = "Искусство выращивания Разрушителей Скверны.",
        ["The Art of the Armorsmith"] = "Искусство изготовления брони",
        ["The Art of the Imbue"] = "Могущество камней",
        ["The Ashenvale Hunt"] = "Ашенвальская охота",
        ["The Ashtongue Broken"] = "Клан Служителей Смерти",
        ["The Ashtongue Corruptors"] = "Осквернители из клана Служителей Смерти",
        ["The Ashtongue Tribe"] = "Клан Служителей Смерти",
        ["The Assassin"] = "Убийца",
        ["The Atal'ai Exile"] = "Изгнанник Аталаи",
        ["The Attack!"] = "Нападение!",
        ["The Azure Key"] = "Лазурный ключ",
        ["The Bait for Lar'korwi"] = "Приманка для Лар-Корви",
        ["The Balance of Light and Shadow"] = "Баланс Света и Тени",
        ["The Balance of Nature"] = "Природное равновесие",
        ["The Balnir Farmstead"] = "Усадьба Бальнира",
        ["The Barrens Oases"] = "Оазисы Степей",
        ["The Barrens Port"] = "Порт в Степях",
        ["The Basilisk's Bite"] = "Вкус василиска",
        ["The Battle Horn"] = "Боевой рог",
        ["The Battle Plans"] = "Планы битвы",
        ["The Battle of Alterac"] = "Битва за Альтерак",
        ["The Battle of Darrowshire"] = "Битва при Дарроушира",
        ["The Battleboars"] = "Боевые кабаны",
        ["The Bear Necessities"] = "Вскормленные медвежатиной",
        ["The Bearer of Bad News"] = "Недобрые вести",
        ["The Befouled Element"] = "Оскверненная Стихия",
        ["The Best Defense"] = "Наилучшая защита",
        ["The Big Bone Worm"] = "Большой костяной червь",
        ["The Biggest of Them All"] = "Самый здоровенный",
        ["The Binding"] = "Оковы",
        ["The Black Morass"] = "Черные топи",
        ["The Black Shield"] = "Черный Щит",
        ["The Blackwood Corrupted"] = "Порабощенные беорны Черного Леса",
        ["The Bladespire Ogres"] = "Огры Стальных Игл",
        ["The Bladespire Threat"] = "Угроза Стальных Игл",
        ["The Blightcaller Cometh"] = "Пришествие Гнили",
        ["The Blood Elves"] = "Эльфы Крови",
        ["The Blood is Life"] = "Кровь есть жизнь",
        ["The Blood-Tempered Ranseur"] = "Закаленный кровью протазан",
        ["The Bloodcurse Legacy"] = "Наследие проклятых",
        ["The Bloodcursed Naga"] = "Проклятые наги",
        ["The Bloodmaul Ogres"] = "Огры Кровавого Молота",
        ["The Bloodsail Buccaneers"] = "Пираты Кровавого паруса",
        ["The Boar Hunter"] = "Охотник на вепрей",
        ["The Boha'mu Ruins"] = "Руины Бохаму",
        ["The Book of Fel Names"] = "The Book of Fel Names",
        ["The Book of Ur"] = "Книга Ура",
        ["The Borrower"] = "В обмен на книгу",
        ["The Bounty of Teldrassil"] = "Изобилие Тельдрассиля",
        ["The Branch of Cenarius"] = "Ветвь Кенариуса",
        ["The Brassbolts Brothers"] = "Братья Латунный Болт",
        ["The Broken Sigil"] = "Сломанная печать",
        ["The Brood of Onyxia"] = "Выводок Ониксии",
        ["The Call to Command"] = "Приказ по армии",
        ["The Calling"] = "Зов",
        ["The Caravan Road"] = "Путь каравана",
        ["The Carevin Family"] = "Семья Кэрвин",
        ["The Caverns of Time"] = "Пещеры Времени",
        ["The Cenarion Expedition"] = "Экспедиция Кенариуса",
        ["The Challenge"] = "Вызов",
        ["The Champion of the Banshee Queen"] = "Защитник королевы банши",
        ["The Champion of the Horde"] = "Защитник Орды",
        ["The Changing of Paths - Conqueror No More"] = "Изменение пути - уже не победитель",
        ["The Changing of Paths - Protector No More"] = "Изменение пути - уже не защитник",
        ["The Charge of the Dragonflights"] = "Создание драконов",
        ["The Chill of Death"] = "Смертельный холод",
        ["The Cipher of Damnation"] = "Шифр Проклятия",
        ["The Cipher of Damnation - Ar'tor's Charge"] = "Шифр Проклятия: Вклад Артора",
        ["The Cipher of Damnation - Borak's Charge"] = "Шифр Проклятия - Вклад Борака",
        ["The Cipher of Damnation - Grom'tor's Charge"] = "Шифр Проклятия: Вклад Громтора",
        ["The Cipher of Damnation - The First Fragment Recovered"] = "Шифр Проклятия: Первый Фрагмент",
        ["The Cipher of Damnation - The Second Fragment Recovered"] = "Шифр Проклятия - Второй фрагмент",
        ["The Cipher of Damnation - The Third Fragment Recovered"] = "Шифр Проклятия - Третий фрагмент",
        ["The Cipher of Damnation - Truth and History"] = "Шифр Проклятия - Правда и Миф",
        ["The Cliffspring River"] = "Река Скалистая",
        ["The Coast Isn't Clear"] = "Зачистка побережья",
        ["The Coastal Menace"] = "Опасность на побережье",
        ["The Codex of Blood"] = "The Codex of Blood",
        ["The Collector"] = "Собиратель",
        ["The Color of Blood"] = "Цвет крови",
        ["The Completed Orb of Dar'Orahil"] = "Завершение шара Дар'орахила",
        ["The Completed Orb of Noh'Orahil"] = "Завершение шара Дар'орахила",
        ["The Completed Robe"] = "Завершенное одеяние",
        ["The Consortium Needs You!"] = "Консорциум ждет вас",
        ["The Corpulent One"] = "Огромный червь",
        ["The Corrupter"] = "Осквернитель душ",
        ["The Corruption Abroad"] = "Проблема за морем",
        ["The Corruption of the Jadefire"] = "Порча Нефритового огня",
        ["The Count of the Marshes"] = "Владыка болот",
        ["The Cover of Darkness"] = "Покров Тьмы",
        ["The Crimson Courier"] = "Курьер Алых",
        ["The Crone of the Kraul"] = "Хозяйка Железной Осоки",
        ["The Crown of Will"] = "Корона Воли",
        ["The Cryo-Core"] = "Криоядро",
        ["The Crystal of Zin-Malor"] = "Кристалл Зин-Малора",
        ["The Curious Visitor"] = "Таинственный посетитель",
        ["The Curse of the Tides"] = "Проклятье Приливов",
        ["The Cursed Crew"] = "Проклятая команда",
        ["The Damned"] = "Проклятые",
        ["The Dark Iron War"] = "Война с Темной Сталью",
        ["The Dark Missive"] = "Темное послание",
        ["The Darkmoon Faire"] = "Ярмарка Темной Луны",
        ["The Darkreaver Menace"] = "Угроза Темного Губителя",
        ["The Darkstone Tablet"] = "Табличка Темного Камня",
        ["The Daughter Who Lived"] = "Выжившая дочь",
        ["The Day After"] = "На другой день",
        ["The Dead Fields"] = "Мертвые поля",
        ["The Dead Mire"] = "Мертвая трясина",
        ["The Dead Scar"] = "Тропа Мертвых",
        ["The Deathforge"] = "Кузница Смерти",
        ["The Deathstalkers"] = "Странники смерти",
        ["The Deathstalkers' Report"] = "Отчет Странников смерти",
        ["The Decisive Striker"] = "Решительный удар",
        ["The Decrepit Ferry"] = "Старая переправа",
        ["The Defense of Grom'gol"] = "Защита Громгола",
        ["The Defias Brotherhood"] = "Братство Справедливости",
        ["The Demon Forge"] = "Демонова Кузня",
        ["The Demon Hunter"] = "Охотник на демонов",
        ["The Demon Scarred Cloak"] = "Поцарапанный демоном плащ",
        ["The Demon Seed"] = "Демоново семя",
        ["The Demoniac Scryer"] = "Предсказатель Бесноватого",
        ["The Den"] = "Логово",
        ["The Den Mother"] = "Мать логова",
        ["The Deserter"] = "Дезертир",
        ["The Deserters"] = "Дезертиры",
        ["The Disgraced One"] = "Опозоренный",
        ["The Disruption Ends"] = "Конец бесчинствам",
        ["The Divination"] = "Прорицание",
        ["The Divination Scryer"] = "Магический кристалл",
        ["The Doomed Fleet"] = "Обреченный флот",
        ["The Dormant Shade"] = "Спящая тень",
        ["The Dragon's Eye"] = "Око дракона",
        ["The Dread Citadel - Naxxramas"] = "Цитадель ужаса - Наксрамас",
        ["The Dread Relic"] = "Реликвия Ужаса",
        ["The Dreghood Elders"] = "Старейшины Отбросья",
        ["The Dunemaul Compound"] = "Крепость Молота Барханов",
        ["The Dwarven Spy"] = "Дворфский шпион",
        ["The Dying Balance"] = "Гибнущее равновесие",
        ["The Dynamic Duo"] = "Динамический дуэт",
        ["The Earthbinder"] = "Связующая Землю",
        ["The Eastern Kingdoms"] = "Восточные королевства",
        ["The Eastern Plagues"] = "Чума на востоке",
        ["The Eastern Pylon"] = "Восточный пилон",
        ["The Ectoplasmic Distiller"] = "Эктоплазматический дистиллятор",
        ["The Eighteenth Pilot"] = "Восемнадцатый пилот",
        ["The Elder Crone"] = "Мудрая старуха",
        ["The Elemental Equation"] = "Уравнение стихий",
        ["The Elusive Ironjaw"] = "Неуловимый Железнозуб",
        ["The Emerald Dream..."] = "Изумрудный сон",
        ["The Emerald Dreamcatcher"] = "Изумрудный ловец снов",
        ["The Emitter"] = "Излучатель",
        ["The Enchanted Glade"] = "Зачарованная поляна",
        ["The Encroaching Wilderness"] = "Угроза хищников",
        ["The Engraved Ring"] = "Кольцо с гравировкой",
        ["The Ensorcelled Parchment"] = "Заколдованный пергамент",
        ["The Escape"] = "Вылазка",
        ["The Essence of Aku'Mai"] = "Сущность Акумы",
        ["The Essence of Eranikus"] = "Сущность Эраникуса",
        ["The Ethereum"] = "Братство Астрала",
        ["The Everlook Report"] = "Донесение из Круговзора",
        ["The Everstill Bridge"] = "Застывший мост",
        ["The Exorcism"] = "Поединок с демоном",
        ["The Exorcism of Colonel Jules"] = "Проведение экзорцизма над полковником Джулесом",
        ["The Eye of Paleth"] = "Око Палета",
        ["The Eyes of Grillok"] = "Глаза Гриллока",
        ["The Eyes of Skettis"] = "Глаза Скеттиса",
        ["The Fall of Ameth'Aran"] = "Падение Амет'Арана",
        ["The Fall of Kel'Thuzad"] = "Падение Кел-Тузеда",
        ["The Fall of Ossirian"] = "Повергнутый Оссириан",
        ["The Fallen Courier"] = "Погибший курьер",
        ["The Fallen Exarch"] = "Падший экзарх",
        ["The Family Crypt"] = "Семейный склеп",
        ["The Family and the Fishing Pole"] = "Семья и рыболовная удочка",
        ["The Fare of Lar'korwi"] = "Добыча Лар-Корви",
        ["The Fargodeep Mine"] = "Рудник Подземных глубин",
        ["The Farstrider Enclave"] = "Анклав Странников",
        ["The Fate of Flanis"] = "Судьба Фланиса",
        ["The Fate of Kagrosh"] = "Судьба Кагроша",
        ["The Fate of Ramaladni"] = "Судьба Рамаладни",
        ["The Fate of Tuurem"] = "Судьба Туурема",
        ["The Fate of Yenniku"] = "Судьба Йеннику",
        ["The Fate of the Kingdom"] = "Судьба королевства",
        ["The Feast of Winter Veil"] = "Праздник Зимнего Покрова",
        ["The Fel and the Furious"] = "Машина для убийства.",
        ["The Final Code"] = "Финальный код",
        ["The Final Message to the Wildhammer"] = "Последнее письмо для Громового Молота",
        ["The Final Piece"] = "Последний фрагмент мозаики",
        ["The Final Reagents"] = "Последние реагенты",
        ["The Final Sample"] = "Последний образчик",
        ["The Final Tablets"] = "Последние таблички",
        ["The Finest Down"] = "Прекрасное оперение",
        ["The Firewing Liaison"] = "Посредник Огненных Крыльев",
        ["The Firewing Point Project"] = "Проект пика Огненных Крыльев",
        ["The First Trial"] = "Первое испытание",
        ["The First and the Last"] = "Первый и последний",
        ["The Flame's Casing"] = "Защита пламени",
        ["The Flawless Flame"] = "Неугасимое пламя",
        ["The Flesh Does Not Lie"] = "Плоть не лжет",
        ["The Flesh Lies..."] = "Усеял мертвыми костями...",
        ["The Foot of the Citadel"] = "Вступить в Цитадель",
        ["The Force of Neltharaku"] = "Силы Нэльтараку",
        ["The Forging of Quel'Serrar"] = "Ковка Кель-Серрара",
        ["The Forgotten Heirloom"] = "Забытая вещь",
        ["The Forgotten Pools"] = "Забытые пруды",
        ["The Formation of Felbane"] = "Создание отравы Скверны",
        ["The Forsaken"] = "Отрекшиеся",
        ["The Four Dukes"] = "Четыре герцога",
        ["The Fragments Within"] = "Скрытые фрагменты",
        ["The Fury Runs Deep"] = "Праведный гнев",
        ["The Giant Guardian"] = "Великан-опекун",
        ["The Glowing Fruit"] = "Светящийся плод",
        ["The Glowing Shard"] = "Светящийся осколок",
        ["The God Hakkar"] = "Бог Хаккар",
        ["The Good Stuff"] = "Хороший товар",
        ["The Gordok Ogre Suit"] = "Броня огров Гордока",
        ["The Gordok Taste Test"] = "Лучшее пойло Гордока",
        ["The Gordunni Orb"] = "Сфера Хордунни",
        ["The Gordunni Scroll"] = "Свиток Хордунни",
        ["The Grand Betrayal"] = "Великое предательство",
        ["The Great Fissure"] = "Великий Разлом",
        ["The Great Fras Siabi"] = "Великий Фрас Сиаби",
        ["The Great Masquerade"] = "Великий Маскарад",
        ["The Great Moongraze Hunt"] = "Великая охота на лунных оленей",
        ["The Great Retribution"] = "Великое Воздаяние",
        ["The Great Silver Deceiver"] = "Обманное серебро",
        ["The Greatest Race of Hunters"] = "Величайшая гонка охотников",
        ["The Green Drake"] = "Зеленый дракон",
        ["The Green Hills of Stranglethorn"] = "Зеленые холмы долины Чародеев",
        ["The Greenwarden"] = "Зеленый Страж",
        ["The Grizzled Den"] = "Серое логово",
        ["The Guns of Northwatch"] = "Пушки Северной стражи",
        ["The Hammer May Fall"] = "Да падет молот",
        ["The Hand of Gul'dan"] = "Рука Гул-Дана",
        ["The Hand of Rastakhan"] = "Длань Растахана",
        ["The Hand of the Righteous"] = "Рука Правого",
        ["The Harvester"] = "Жнец",
        ["The Haunted Isle"] = "Остров духов",
        ["The Haunted Mills"] = "Мельницы с привидениями",
        ["The Head of the Beast"] = "Голова чудовища",
        ["The Heart of Darkness"] = "Сердце тьмы",
        ["The Heart of the Mountain"] = "Сердце горы",
        ["The Hermit"] = "Отшельник",
        ["The Hidden Chamber"] = "Тайная Комната",
        ["The Hidden Key"] = "Спрятанный ключ",
        ["The Hidden Niche"] = "Замаскированный тайник",
        ["The High Wilderness"] = "Верховые дебри",
        ["The Hopeless Ones..."] = "Отчаявшиеся",
        ["The Horde Needs Firebloom!"] = "Орде не хватает огнецвета!",
        ["The Horde Needs Heavy Leather!"] = "Орде не хватает тяжелой кожи!",
        ["The Horde Needs Mithril Bars!"] = "Орде не хватает митриловых слитков!",
        ["The Horde Needs More Mageweave Bandages!"] = "Орде опять не хватает бинтов из магической ткани!",
        ["The Horde Needs More Mithril Bars!"] = "Орде все еще не хватает митриловых слитков!",
        ["The Horde Needs More Peacebloom!"] = "Орде все еще не хватает мироцвета!",
        ["The Horde Needs More Purple Lotus!"] = "Орде все еще не хватает пурпурного лотоса!",
        ["The Horde Needs More Rugged Leather!"] = "Орде все еще не хватает прочной кожи!",
        ["The Horde Needs More Runecloth Bandages!"] = "Орде все еще не хватает бинтов из рунной ткани!",
        ["The Horde Needs More Spotted Yellowtail!"] = "Орде все еще не хватает пятнистого желтохвоста!",
        ["The Horde Needs More Thick Leather!"] = "Орде все еще не хватает плотной кожи!",
        ["The Horde Needs Peacebloom!"] = "Орде не хватает мироцвета!",
        ["The Horde Needs Purple Lotus!"] = "Орде не хватает пурпурного лотоса!",
        ["The Horde Needs Rugged Leather!"] = "Орде не хватает прочной кожи!",
        ["The Horde Needs Runecloth Bandages!"] = "Орде не хватает бинтов из рунной ткани!",
        ["The Horde Needs Spotted Yellowtail!"] = "Орде не хватает пятнистого желтохвоста!",
        ["The Horde Needs Thick Leather!"] = "Орде не хватает плотной кожи!",
        ["The Horde Needs Tin Bars!"] = "Орде не хватает оловянных слитков!",
        ["The Horde Needs Wool Bandages!"] = "Орде не хватает шерстяных бинтов!",
        ["The Horn of the Beast"] = "Рог чудовища",
        ["The Horrors of Pollution"] = "Ужасы загрязнения",
        ["The Hound-Master"] = "Псарь",
        ["The Howling Vale"] = "Воющая Долина",
        ["The Howling Wind"] = "Вой-Ветер",
        ["The Hunt Begins"] = "Охота начинается",
        ["The Hunt Completed"] = "Завершение охоты",
        ["The Hunt Continues"] = "Охота продолжается",
        ["The Hunter's Charm"] = "Талисман охотника",
        ["The Hunter's Way"] = "Путь охотника",
        ["The Ice Guard"] = "Ледяная защита",
        ["The Ichor of Undeath"] = "Лимфа нежити",
        ["The Impotent Leader"] = "Слабосильный владыка",
        ["The Inconsolable Chieftain"] = "Безутешный Вождь",
        ["The Infernal Orb"] = "Сфера Подземного огня",
        ["The Infested Protectors"] = "Зараженные защитники",
        ["The Instigator's Enchantment"] = "Чары подстрекателя",
        ["The Ironforge Brigade Needs Explosives!"] = "Взрывчатка для дружины Стальгорна",
        ["The Islander"] = "Островитянин",
        ["The Isle of Dread!"] = "Остров Ужаса!",
        ["The Jasperlode Mine"] = "Яшмовая шахта",
        ["The Jeremiah Blues"] = "Грусть Иеремии",
        ["The Jewel of Kajaro"] = "Самоцвет Каджаро",
        ["The Karnitol Shipwreck"] = "Пожитки Карнитола",
        ["The Kessel Run"] = "Кессельский путь",
        ["The Key to Freedom"] = "Ключ к свободе",
        ["The Killing Fields"] = "Убийцы на полях",
        ["The Knife Revealed"] = "Тайна ножа",
        ["The Kolkar of Desolace"] = "Кентавры Безлюдья",
        ["The Kurken is Lurkin'"] = "Куркен",
        ["The Kurken's Hide"] = "Шкура куркена",
        ["The Last Barov"] = "Последний из Бароу",
        ["The Last Element"] = "Последняя стихия",
        ["The Left Piece of Lord Valthalak's Amulet"] = "Левая часть амулета владыки Вальтхалака",
        ["The Legend of Stalvan"] = "Легенда о Сталване",
        ["The Legion Reborn"] = "Возрожденный Легион",
        ["The Lexicon Demonica"] = "Демонический словарь",
        ["The Lich's Identity"] = "Личность Короля мертвых",
        ["The Light and How To Swing It"] = "Свет и как его раскачать",
        ["The Longbeards"] = "Длиннобородые",
        ["The Lord of Blackrock"] = "Владыка Черной Скалы",
        ["The Lost Caravan"] = "Пропавший караван",
        ["The Lost Chalice"] = "Потерянная чаша",
        ["The Lost Dwarves"] = "Потерянные Дворфы",
        ["The Lost Fragments"] = "Утраченные фрагменты",
        ["The Lost Ingots"] = "Утерянные слитки",
        ["The Lost Pages"] = "Утраченные страницы",
        ["The Lost Pilot"] = "Пропавший пилот",
        ["The Lost Report"] = "Потерянный рапорт",
        ["The Lost Supplies"] = "Потерянные припасы",
        ["The Lost Tablets of Mosh'aru"] = "Утраченные таблички Мошару",
        ["The Lost Tablets of Will"] = "Утерянные таблички Воли",
        ["The Lost Tools"] = "Утраченные инструменты",
        ["The Love Potion"] = "Приворотное зелье",
        ["The Madness Within"] = "Древнее безумие",
        ["The Mag'har"] = "Магхар",
        ["The Magister's Apprentice"] = "Ученица магистра",
        ["The Main Course!"] = "Гвоздь программы",
        ["The Mark of Quality"] = "Знак качества",
        ["The Mark of the Lightbringer"] = "Знак Светоносного",
        ["The Master Planner"] = "Мастер-планировщик",
        ["The Master's Glaive"] = "Меч Властителя",
        ["The Master's Grand Design?"] = "Великий замысел господина?",
        ["The Master's Touch"] = "Разрешение учителя",
        ["The Mastermind"] = "Мозговой центр",
        ["The Matron Protectorate"] = "Матрона-защитница",
        ["The Medallion of Faith"] = "Медальон Веры",
        ["The Mighty U'cha"] = "Могучая Уча",
        ["The Mills Overrun"] = "Нападение на мельницы",
        ["The Mind's Eye"] = "Око Разума",
        ["The Mindless Ones"] = "Безмозглые твари",
        ["The Minions of Culuthas"] = "Приспешники Кулутаса",
        ["The Missing Courier"] = "Пропавший курьер",
        ["The Missing Diplomat"] = "Пропавший дипломат",
        ["The Missing Expedition"] = "Пропавшая экспедиция",
        ["The Missing Fisherman"] = "Пропавший рыбак",
        ["The Missing Merchant"] = "Пропавший торговец",
        ["The Missing Orders"] = "Пропавшие приказы",
        ["The Missing Scout"] = "Пропавший разведчик",
        ["The Missing Shipment"] = "Пропавший груз",
        ["The Missing Survey Team"] = "Пропавшие картографы",
        ["The Missing War Party"] = "Пропавший отряд",
        ["The Mistress Revealed"] = "Кем оказалась любовница",
        ["The Mithril Kid"] = "Митриловый парень",
        ["The Mithril Order"] = "Орден митрила",
        ["The Molten Core"] = "Расплавленные Недра",
        ["The Monogrammed Sash"] = "Вервие с монограммой",
        ["The Morrow Stone"] = "Завтрашний камень",
        ["The Moss-twined Heart"] = "Сердце, поросшее мхом",
        ["The Mystery of Morrowgrain"] = "Тайна рассветницы",
        ["The Name of the Beast"] = "Имя Зверя",
        ["The Nesingwary Safari"] = "Охотничий лагерь Эрнестуэя",
        ["The New Frontier"] = "Новое пограничье",
        ["The New Springs"] = "Новые источники",
        ["The Newest Member of the Family"] = "Новый член семьи",
        ["The Night Watch"] = "Ночной дозор",
        ["The Northern Pylon"] = "Северный пилон",
        ["The Ogre Threat"] = "Угроза со стороны огров",
        ["The Ogres of Feralas"] = "Огры Фераласа",
        ["The Old Ways"] = "Старые обычаи",
        ["The Only Cure is More Green Glow"] = "Сильное зеленое свечение",
        ["The Only Prescription"] = "Единственный способ",
        ["The Only Song I Know..."] = "Не разгуляешься...",
        ["The Opening of the Dark Portal"] = "Открытие Темных врат",
        ["The Orb of Soran'ruk"] = "Шар Соран'рука",
        ["The Orc Report"] = "Орочье донесение",
        ["The Orebor Harborage"] = "Гавань Оребор",
        ["The Orgrimmar Legion Needs Mojo!"] = "Амулеты для легиона Оргриммара",
        ["The Origins of Smithing"] = "Происхождение кузнечного искусства",
        ["The Outcast's Plight"] = "Затруднительное положение изгнанника",
        ["The Pack Mistress"] = "Праматерь стаи",
        ["The Pariah's Instructions"] = "Инструкции кентавра-парии",
        ["The Party Never Ends"] = "Бесконечный праздник",
        ["The Path of Anguish"] = "Путь Страданий",
        ["The Path of Conquest"] = "Путь Завоевания",
        ["The Path of Glory"] = "Путь Славы",
        ["The Path of the Adept"] = "Путь адепта",
        ["The Path of the Righteous"] = "Путь правых",
        ["The People's Militia"] = "Народное ополчение",
        ["The Perfect Poison"] = "Идеальный яд",
        ["The Perfect Stout"] = "Всем портерам портер",
        ["The Plagued Coast"] = "Чумной берег",
        ["The Platinum Discs"] = "Платиновые Диски",
        ["The Pledge of Secrecy"] = "Договор о неразглашении",
        ["The Pools of Aggonar"] = "Пруды Аггонара",
        ["The Power to Destroy..."] = "Силы разрушения...",
        ["The Powers Below"] = "Подземные Силы",
        ["The Price of Shoes"] = "Цена подков",
        ["The Princess Saved?"] = "Спасенная принцесса",
        ["The Princess Trapped"] = "Принцесса в ловушке",
        ["The Princess's Surprise"] = "Королевский сюрприз",
        ["The Principal Source"] = "Основной источник",
        ["The Prison's Bindings"] = "Тюремные кандалы",
        ["The Prison's Casing"] = "Тюремная камера",
        ["The Prodigal Lich"] = "Блудный мертвец",
        ["The Prodigal Lich Returns"] = "Возвращение блудного мертвеца",
        ["The Prophecy of Akida"] = "Пророчество Акиды",
        ["The Prophecy of Mosh'aru"] = "Пророчество Мошару",
        ["The Prophecy of Velen"] = "Пророчество Велена",
        ["The Public Servant"] = "Слуга народа",
        ["The Purest Water"] = "Чистейшая вода",
        ["The Qiraji Conqueror"] = "Победитель Кирай",
        ["The Ranger Lord's Behest"] = "Охота на cледопытов",
        ["The Ravaged Caravan"] = "Разграбленный караван",
        ["The Real Threat"] = "Настоящая угроза",
        ["The Reason for the Season"] = "Повод для праздника",
        ["The Red Crystal"] = "Красный кристалл",
        ["The Red Messenger"] = "Красный гонец",
        ["The Relics of Wakening"] = "Реликвии Пробуждения",
        ["The Remains of Trey Lightforge"] = "Останки Трея Светлой Стали",
        ["The Reports"] = "Донесения",
        ["The Rescue"] = "Спасение",
        ["The Restless Souls"] = "Мятущиеся души",
        ["The Rethban Gauntlet"] = "Ретбанский вызов",
        ["The Right Piece of Lord Valthalak's Amulet"] = "Правая часть амулета владыки Вальтхалака",
        ["The Ring of Blood: Brokentoe"] = "Кольцо Крови: Пальцехруст",
        ["The Ring of Blood: Rokdar the Sundered Lord"] = "Кольцо Крови: Рокдар Покинутый Лорд",
        ["The Ring of Blood: Skra'gath"] = "Кольцо Крови: Скрагат",
        ["The Ring of Blood: The Blue Brothers"] = "Кольцо Крови: Синие братья",
        ["The Ring of Blood: The Final Challenge"] = "Кольцо Крови: последнее испытание",
        ["The Ring of Blood: The Warmaul Champion"] = "Кольцо Крови: защитник Молота Боя",
        ["The Ring of Mmmrrrggglll"] = "Кольцо Мррргла",
        ["The Rise of the Machines"] = "Восстание машин",
        ["The Road to Darnassus"] = "Дорога в Дарнасс",
        ["The Road to Falcon Watch"] = "Дорога к Соколиному Дозору",
        ["The Rock Flayer Matriarch"] = "Матриарх камнедеров",
        ["The Rod of Lianthe"] = "Ветвь Лиантэ",
        ["The Root of All Evil"] = "Корень всех зол",
        ["The Royal Rescue"] = "Спасение принцессы",
        ["The Ruins of Burning Blade"] = "Руины Огненного Клинка",
        ["The Ruins of Kel'Theril"] = "Руины Кел-Терила",
        ["The Ruins of Solarsal"] = "Руины Соларсаля",
        ["The Ruins of Stardust"] = "Руины Звездной Пыли",
        ["The Rumormonger"] = "Сплетник",
        ["The Rune of Summoning"] = "Руна Призыва",
        ["The Runed Scroll"] = "Свиток с рунами",
        ["The Sacred Flame"] = "Священное пламя",
        ["The Sad Truth"] = "Горькая правда",
        ["The Sanctum of the Sun"] = "Святилище Солнца",
        ["The Savage Guard - Arcanum of Focus"] = "Защита Джунглей - Магический камень Сосредоточения",
        ["The Savage Guard - Arcanum of Protection"] = "Защита Джунглей - Магический камень Защиты",
        ["The Savage Guard - Arcanum of Rapidity"] = "Защита Джунглей - Магический камень Стремительности",
        ["The Savior of Kalimdor"] = "Спаситель Калимдора",
        ["The Scarlet Crusade"] = "Алый марш",
        ["The Scent of Lar'korwi"] = "Запах Лар-Корви",
        ["The Scepter of Celebras"] = "Скипетр Келебраса",
        ["The Scorched Grove"] = "Выжженная роща",
        ["The Scourge Cauldrons"] = "Котлы Плети",
        ["The Scrimshank Redemption"] = "Спасение Холстомера",
        ["The Scythe of Elune"] = "Коса Элуны",
        ["The Search Continues"] = "Поиски продолжаются",
        ["The Second Course..."] = "Смертерадон на второе",
        ["The Second Rebellion"] = "Второе восстание",
        ["The Second Sample"] = "Второй образчик",
        ["The Second Trial"] = "Второе испытание",
        ["The Second and Third Fragments"] = "Второй и третий фрагменты",
        ["The Seer's Relic"] = "Реликвия мудреца",
        ["The Severed Head"] = "Отрубленная Голова",
        ["The Shade of Elura"] = "Тень Элуры",
        ["The Shadow Guard"] = "Теневая защита",
        ["The Shadow Tomb"] = "Гробница Тени",
        ["The Shadowmoon Shuffle"] = "Уловки Лунной Тени",
        ["The Shadowy Figure"] = "Таинственный незнакомец",
        ["The Shadowy Search Continues"] = "Продолжение поисков незнакомца",
        ["The Sharpest Blades"] = "Острейшие резцы",
        ["The Shattered Hand"] = "Раздробленная Рука",
        ["The Shattered Necklace"] = "Порванное ожерелье",
        ["The Shattered Salute"] = "Приветствие Раздробленной Руки",
        ["The Shieldsmith"] = "Хороший щит",
        ["The Shimmering Frond"] = "Мерцающий росток",
        ["The Shrine of Dath'Remar"] = "Памятник Дат'Ремару",
        ["The Sigil of Krasus"] = "Печать Красуса",
        ["The Singing Crystals"] = "Поющие кристаллы",
        ["The Siren's Coral"] = "Кораллы сирен",
        ["The Sketh'lon Wreckage"] = "Руины Скетлона",
        ["The Skettis Offensive"] = "Нападение Скеттиса",
        ["The Slaughtered Lamb"] = "Зарезанный ягненок",
        ["The Sleeper Has Awakened"] = "Спящий пробудился",
        ["The Sleeping Druid"] = "Спящий друид",
        ["The Smallest Creatures"] = "Самые маленькие создания",
        ["The Smoldering Ruins of Thaurissan"] = "Дымящиеся руины Таурисана",
        ["The So-Called Mark of the Lightbringer"] = "Так называемый знак Светоносного",
        ["The Softest Wings"] = "Нежнейшие крылья",
        ["The Soul Devices"] = "Инструменты души",
        ["The Spearcrafter's Hammer"] = "Молот делателя копий",
        ["The Spectral Chalice"] = "Призрачный кубок",
        ["The Spider God"] = "Паучья богиня",
        ["The Spirit Polluted"] = "Оскверненный дух",
        ["The Spirits Have Voices"] = "У духов есть голоса",
        ["The Spirits of Southwind"] = "Духи Южного Ветра",
        ["The Spirits of Stonetalon"] = "Духи Каменного Когтя",
        ["The Sporelings' Plight"] = "Проблемы спорлингов",
        ["The Sprouted Fronds"] = "Росток папоротника",
        ["The Spy Revealed!"] = "Шпион найден!",
        ["The Stagnant Oasis"] = "Застывший оазис",
        ["The Stave of Equinex"] = "Посох Равноденствия",
        ["The Stockade Riots"] = "Бунтовщики в тюрьме",
        ["The Stolen Journal"] = "Украденные записи",
        ["The Stolen Tome"] = "Украденная книга",
        ["The Stone"] = "Камень",
        ["The Stone Circle"] = "Круглый камень",
        ["The Stone Watcher"] = "Каменный Страж",
        ["The Stone of the Tides"] = "Камень Приливов",
        ["The Stones That Bind Us"] = "Камни, что связывают нас",
        ["The Stones of Vekh'nir"] = "Камни Век'нира",
        ["The Strength of Corruption"] = "Сила порчи",
        ["The Summoning"] = "Призыв",
        ["The Summoning Chamber"] = "Чертог Призыва",
        ["The Sun Gate"] = "Солнечные Ворота",
        ["The Sunfury Garrison"] = "Гарнизон Гневного Солнца",
        ["The Sunken Temple"] = "Затонувший храм",
        ["The Super Snapper FX"] = "Супер-хвататель ФХ",
        ["The Swamp Talker"] = "Болотный Говорун",
        ["The Swarm Grows"] = "Рой растет",
        ["The Tear of the Moons"] = "Слеза Лун",
        ["The Tempest Key"] = "Ключ Урагана",
        ["The Temple of Atal'Hakkar"] = "Храм Аталхаккара",
        ["The Temple of Telhamat"] = "Храм Телхамата",
        ["The Terror of Marshlight Lake"] = "Ужас озера Болотный огонек",
        ["The Test of Righteousness"] = "Испытание доблести",
        ["The Thandol Span"] = "Мост Тандола",
        ["The Theramore Docks"] = "Доки Терамора",
        ["The Third Fleet"] = "Третья флотилия",
        ["The Throne of the Elements"] = "Трон Стихий",
        ["The Thunderspike"] = "Громовая пика",
        ["The Tome of Divinity"] = "Фолиант Божественности",
        ["The Tome of Valor"] = "Фолиант Отваги",
        ["The Torch of Retribution"] = "Факел воздаяния",
        ["The Tortured Earth"] = "Страдающие духи земли",
        ["The Totem of Infliction"] = "Тотем Кары",
        ["The Totem of Kar'dash"] = "Тотем Кардаша",
        ["The Totems of My Enemy"] = "Тотем врага моего",
        ["The Touch of Zanzil"] = "Прикосновение Занзила",
        ["The Tower of Althalaxx"] = "Башня Алталакса",
        ["The Traitor's Destruction"] = "Гибель предателя",
        ["The Traitor's Shadow"] = "Тень предателя",
        ["The Trappings of a Vindicator"] = "Вещи Поборницы",
        ["The Treasure of the Shen'dralar"] = "Сокровище Шендралар",
        ["The Trogg Threat"] = "Троггская угроза",
        ["The Troll Cave"] = "Пещера троллей",
        ["The Troll Witchdoctor"] = "Тролль-знахарь",
        ["The True Masters"] = "Подлинные хозяева",
        ["The Truth Comes Crashing Down"] = "Ошеломляющая истина",
        ["The Truth Unorbed"] = "Тайна сферы",
        ["The Twilight Camp"] = "Лагерь Сумеречного Молота",
        ["The Twilight Lexicon"] = "Сумеречный словарь",
        ["The Twilight Mystery"] = "Сумеречная тайна",
        ["The Twin Clefts of Nagrand"] = "Расселины Награнда",
        ["The Twin Ziggurats"] = "Зиккураты-близнецы",
        ["The Ultimate Bloodsport"] = "Опасный спорт",
        ["The Ultimate Deception"] = "Последняя хитрость",
        ["The Umbrafen Tribe"] = "Племя Болотной тени",
        ["The Undermarket"] = "Черный Рынок",
        ["The Underneath"] = "Из глубин",
        ["The Unending Invasion"] = "Бесконечное вторжение",
        ["The Unmarred Vision of Voodress"] = "Незамутненное ожерелье видений Вудресса",
        ["The Unsent Letter"] = "Неотправленное письмо",
        ["The Unwritten Prophecy"] = "Неписаное пророчество",
        ["The Vengeful Harbinger"] = "Мстительный предок",
        ["The Venture Co."] = "Торговая компания",
        ["The Videre Elixir"] = "Эликсир Видере",
        ["The Vile Reef"] = "Коварный риф",
        ["The Warchief's Mandate"] = "Поручение Вождя",
        ["The Warden's Cage"] = "Клетка Тюремщика",
        ["The Warlord's Hideout"] = "Убежище врага",
        ["The Warp Rifts"] = "Астральные провалы",
        ["The Warsong Reports"] = "Отчет Боевого Клича",
        ["The Way of the Weaponsmith"] = "Путь оружейника",
        ["The Way to Auberdine"] = "Дорога к Аубердину",
        ["The Wayward Apprentice"] = "Упрямая ученица",
        ["The Weathered Grave"] = "Древний могильный камень",
        ["The Weaver"] = "Ткач",
        ["The Western Pylon"] = "Западный пилон",
        ["The Wildlife Suffers Too"] = "Страдания природы",
        ["The Will of the Warchief"] = "Воля Вождя.",
        ["The Windwatcher"] = "Ветростраж",
        ["The Woodland Protector"] = "Защитница леса",
        ["The Woodpaw Gnolls"] = "Гноллы из клана Лесной Лапы",
        ["The Work of Grimand Elmore"] = "Работа Гриманда Альмора",
        ["The World At Your Feet"] = "Мир у твоих ног",
        ["The World's Largest Gnome!"] = "Гном-гигант!",
        ["The Writhing Deep"] = "Непролазные дебри",
        ["The Wrong Stuff"] = "Бросовый материал",
        ["The Zapthrottle Mote Extractor!"] = "Удаленный конденсатор выхлопов!",
        ["The Zhevra"] = "Зебри",
        ["The Zoram Strand"] = "Взморье Зорам",
        ["Theldurin the Lost"] = "Тэльдруин Потерянный",
        ["Thelsamar Blood Sausages"] = "Телcамарские кровяные колбаски",
        ["Theocritus' Retrieval"] = "Поручение Теокрита",
        ["Theramore Spies"] = "Тераморские шпионы",
        ["There Can Be Only One Response"] = "Ответ будет только один",
        ["There Is No Hope"] = "Надежды нет",
        ["There's No Explanation for Fashion"] = "Мода непредсказуема!",
        ["Therylune's Escape"] = "Спасение Тирелин",
        ["Therzok"] = "Терзок",
        ["They Call Him Smiling Jim"] = "Они зовут его Джим Улыбка",
        ["They Call Me \"The Rooster\""] = "Не все так просто",
        ["They Stole Me Hookah and Me Brews!"] = "У меня сперли кальян и выпивку!",
        ["They're Alive! Maybe..."] = "Они живы! ...Может быть.",
        ["Thick Hydra Scales"] = "Чешуя толстой гидры",
        ["Thin the Flock"] = "Уменьшить стаю",
        ["Thinning the Ranks"] = "Ослабление врага",
        ["Thirst Unending"] = "Неутолимая жажда",
        ["This Is Going to Be Hard"] = "Сложная задача",
        ["Thistleshrub Valley"] = "Терновая долина",
        ["Thorium Widget"] = "Ториевое устройство",
        ["Those Blasted Troggs!"] = "Проклятые трогги!",
        ["Threat From the Sea"] = "Угроза с моря",
        ["Threat of the Winterfall"] = "Угроза со стороны Зимнего Сна",
        ["Three Kings of Flame"] = "Три властелина огня",
        ["Through the Dark Portal"] = "Через Темные Врата",
        ["Thule Ravenclaw"] = "Туле Когтевран",
        ["Thun'grim Firegaze"] = "Тунгрим Огнегляд",
        ["Thunderaan the Windseeker"] = "Громораан Ветроносец",
        ["Thunderbrew Lager"] = "Светлое громопойло",
        ["Thunderhorn Cleansing"] = "Очищение Громового Рога",
        ["Thunderhorn Totem"] = "Тотем Громового Рога",
        ["Thunderlord Clan Artifacts"] = "Сокровища клана Повелителя Грома",
        ["Thundris Windweaver"] = "Тандрис Ветроткач",
        ["Thwart the Dark Conclave"] = "Крах темного конклава",
        ["Thwarting Kolkar Aggression"] = "Разрушение коварных планов",
        ["Tiara of the Deep"] = "Тиара Глубин",
        ["Tiara of the Oracle"] = "Тиара Оракула",
        ["Tiger Mastery"] = "Схватка с тигром",
        ["Timber Worg Tails"] = "Хвосты воргов",
        ["Timberling Seeds"] = "Саженцы древесника",
        ["Timberling Sprouts"] = "Ростки древесника",
        ["Time To Strike"] = "Время нанести удар",
        ["Tinkee Steamboil"] = "Тинки Паровой Котел",
        ["To Catch A Thistlehead"] = "Охота на Посла",
        ["To Gadgetzan You Go!"] = "Ступайте в Гатжетзан!",
        ["To Ironforge for Yagyin's Digest"] = "В Стальгорн за книгой Йагина",
        ["To Kill With Purpose"] = "Преднамеренное убийство",
        ["To Legion Hold"] = "Тайная миссия",
        ["To Meet Mother Kashur"] = "Встреча с Матерью Кашур",
        ["To Netherwing Ledge!"] = "На уступ Крыла Хаоса!",
        ["To Serve Kum'isha"] = "Служба для Кум-иши",
        ["To Show Due Judgment"] = "Демонстрация истинного правосудия",
        ["To Steal From Thieves"] = "Ограбить воров",
        ["To The Bulwark"] = "В Бастион",
        ["To The Hinterlands"] = "Во Внутренние земли",
        ["To Winterspring!"] = "В Зимние Ключи!",
        ["To the Stormspire"] = "К Штормовому Утесу",
        ["To the Top"] = "Умный в гору не пойдет...",
        ["To the Undercity for Yagyin's Digest"] = "В Подгород за книгой Йагина",
        ["Tomb of the Lightbringer"] = "Гробница Светоносца",
        ["Tomber's Supplies"] = "Припасы могильщика",
        ["Tome of Divinity"] = "Фолиант Божественности",
        ["Tome of the Cabal"] = "Фолиант Заговора",
        ["Too Many Mouths to Feed"] = "Слишком много ртов!",
        ["Tooga's Quest"] = "Задание Тооги",
        ["Tools for Steelgrill"] = "Инструменты для Стальной Решетки",
        ["Tools of the Highborne"] = "Инструменты Высокорожденных",
        ["Tools of the Trade"] = "Орудия труда",
        ["Torching Sunfury Hold"] = "Пожар в Форте Гневного Солнца",
        ["Torek's Assault"] = "Налет Торека",
        ["Torgos!"] = "Торгос!",
        ["Tormented By the Past"] = "Измученный воспоминаниями о прошлом",
        ["Tormus Deepforge"] = "Тормус Тайная Кузня",
        ["Torn Bear Pelts"] = "Разорванные шкуры",
        ["Torwa Pathfinder"] = "Торва Первопроходец",
        ["Totem of Coo"] = "Тотем Коо",
        ["Totem of Tikti"] = "Тотем Тикти",
        ["Totem of Vark"] = "Тотем Варк",
        ["Totem of Yor"] = "Тотем Йора",
        ["Touch of Weakness"] = "Внезапная слабость",
        ["Towers and Bunkers"] = "Башни и бункеры",
        ["Toxic Horrors"] = "Ядовитый Ужас",
        ["Toxic Test"] = "Испытание яда",
        ["Tracking Down the Culprits"] = "Выслеживание преступников",
        ["Training the Beast"] = "Приручение зверя",
        ["Traitor to the Bloodsail"] = "Предатель Кровавого Паруса",
        ["Tramping Paws"] = "Вытоптанные луга",
        ["Trampled Under Foot"] = "Тяжелая поступь",
        ["Tran'rek"] = "Транрек",
        ["Translate Abercrombie's Note"] = "Перевод записки Аберкромби",
        ["Translating the Journal"] = "Трудности перевода",
        ["Translating the Ledger"] = "Перевод книги",
        ["Translation to Ello"] = "Перевод для Элло",
        ["Translations..."] = "Переводы...",
        ["Trapping the Light Fantastic"] = "Ловля фантастического  света",
        ["Travel to Azure Watch"] = "В Лазурный форпост",
        ["Travel to Darkshire"] = "Путешествие в Темнолесье",
        ["Treant Muisek"] = "Уменьшенный энт",
        ["Treats for Greatfather Winter"] = "Угощение для Зимнего деда",
        ["Tree's Company"] = "У деревьев есть уши",
        ["Treebole Must Know"] = "Древоствол должен знать!",
        ["Trek to Ashenvale"] = "Путь в Ашенваль",
        ["Trelane's Defenses"] = "Оборона Трелана",
        ["Tremors of the Earth"] = "Дрожь земли",
        ["Triage"] = "Очередь на медобслуживание",
        ["Trial and Error"] = "Пробы и ошибки",
        ["Trial at the Field of Giants"] = "Испытание поля гигантов",
        ["Triangulation Point One"] = "Триангуляция: точка первая",
        ["Triangulation Point Two"] = "Триангуляция: точка вторая",
        ["Tribal Leatherworking"] = "Школа Дикаря",
        ["Tribes at War"] = "Воюющие племена",
        ["Trinkets..."] = "Безделушки...",
        ["Trol'kalar"] = "Тролькалар",
        ["Troll Charm"] = "Оберег троллей",
        ["Troll Juju"] = "Джуджу троллей",
        ["Troll Necklace Bounty"] = "Ожерелья троллей",
        ["Troll Temper"] = "Троллья добавка",
        ["Troll Witchery"] = "Тролльское колдовство",
        ["Trollbane"] = "Троллья погибель",
        ["Trollbane is Looking for You"] = "Тебя ищет Троллья Погибель",
        ["Trolls of a Feather"] = "Тролли Пера",
        ["Trouble In Darkshore?"] = "Беспорядки на Темном Берегу?",
        ["Trouble at Auchindoun"] = "Trouble at Auchindoun",
        ["Trouble at the Docks"] = "Хищение в порту",
        ["Trouble at the Underlight Mines"] = "Беда на Бессветных копях",
        ["Trouble in Winterspring!"] = "Сложности в Зимних ключах!",
        ["Trouble in the Deeps"] = "Угроза из Глубин",
        ["Troubled Spirits of Kel'Theril"] = "Беспокойные духи Кел-Терила",
        ["Troublesome Distractions"] = "Пустые хлопоты",
        ["True Believers"] = "Истинно верующие",
        ["Trueflight Arrows"] = "Стрелы, бьющие без промаха",
        ["Truth or Fiction"] = "Правда или вымысел",
        ["Tumors"] = "Опухоли",
        ["Tundra MacGrann's Stolen Stash"] = "Ограбление тайника Тундры Макгранна",
        ["Turning Point"] = "Поворотная точка",
        ["Turning the Tide"] = "Новый поворот событий",
        ["Twilight Battle Orders"] = "Боевые приказы Сумеречного Молота",
        ["Twilight Falls"] = "Наступление Сумерек",
        ["Twilight Geolords"] = "Сумеречные Повелители земли",
        ["Twilight Marauders"] = "Сумеречные мародеры",
        ["Twilight Ring of Lordship"] = "Кольцо Власти служителя Сумрака",
        ["Twilight of the Dawn Runner"] = "Сумерки \"Гонца Рассвета\"",
        ["Twisted Evils"] = "Хрустальные орнаменты",
        ["Twisted Hatred"] = "Извращенная ненависть",
        ["Two Halves Become One"] = "Вторая половина",
        ["Tyrande and Remulos"] = "Тиренд и Ремулос",
        ["Ula'elek and the Brutal Gauntlets"] = "Ула-Елек и латные рукавицы Жестокости",
        ["Ulag the Cleaver"] = "Улаг Колун",
        ["Ulathek the Traitor"] = "Улатек Предатель",
        ["Uldaman Reagent Run"] = "В Ульдаман за реактивами",
        ["Umbrafen Eel Filets"] = "Филе угрей из озера Болотной тени",
        ["Un'Goro Soil"] = "Почва Ан-Горо",
        ["Un-Life's Little Annoyances"] = "Мелочи нежизни",
        ["Uncatalogued Species"] = "Неизвестный науке вид",
        ["Unclaimed Baggage"] = "Невостребованный багаж",
        ["Uncle Carlin"] = "Дядюшка Карлин",
        ["Uncovering the Past"] = "Тайны прошлого",
        ["Undamaged Venom Sac"] = "Неповрежденная ядовитая железа",
        ["Under Whose Orders?"] = "Кто отдает приказы?",
        ["Under the Chitin Was..."] = "А под хитином было...",
        ["Underbelly Scales"] = "Брюшная чешуя",
        ["Undercutting the Competition"] = "Undercutting the Competition",
        ["Underground Assault"] = "Битва под землей",
        ["Underlight Ore Samples"] = "Образцы руды из Бессветных копей",
        ["Understanding the Mok'Nathal"] = "Как понять Мок-Натал",
        ["Underworld Loam"] = "Суглинок из Нижнего Мира",
        ["Unexpected Results"] = "Неожиданный результат",
        ["Unfinished Business"] = "Неоконченное дело",
        ["Unfortunate Measures"] = "Вынужденные меры",
        ["Uniting the Shattered Amulet"] = "Воссоединить расколотый амулет",
        ["Unlocking the Compendium"] = "Открыть Компендиум",
        ["Unruly Neighbors"] = "Беспокойные соседи",
        ["Unstable Mana Crystals"] = "Нестабильные кристаллы маны",
        ["Until Death Do Us Part"] = "Покуда смерть не разлучит нас",
        ["Up to Snuff"] = "Понюшка табака",
        ["Update for Sentinel Thenysil"] = "Новости для Стража Тенисил",
        ["Ur's Treatise on Shadow Magic"] = "Трактат Ура по Темной магии",
        ["Urgent Delivery"] = "Срочная доставка",
        ["Urgent Delivery!"] = "Срочная доставка",
        ["Urok Doomhowl"] = "Аррок Роковой Вой",
        ["Ursal the Mauler"] = "Урсал Мучитель",
        ["Ursangous's Paw"] = "Лапа Урсангуса",
        ["Ursius of the Shardtooth"] = "Урсиус из племени Сколотого клыка",
        ["Us or Them"] = "Мы и они",
        ["Vahlarriel's Search"] = "Расследование Валарриэля",
        ["Valik"] = "Вэллик",
        ["Vanquish the Betrayers"] = "Бей предателей!",
        ["Vanquishing Aquantion"] = "Победа над Аквантионом",
        ["Veil Lithic: Preemptive Strike"] = "Завеса Литик: превентивный удар",
        ["Veil Rhaze: Unliving Evil"] = "Завеса Рейз: неживое зло",
        ["Veil Shalas: Signal Fires"] = "Завеса Шалас: сигнальные огни",
        ["Veil Skith: Darkstone of Terokk"] = "Завеса Скит: Темный камень Терокка",
        ["Vejrek"] = "Веджрек",
        ["Velinde Starsong"] = "Велинда Звездная Песня",
        ["Velinde's Effects"] = "Эффекты Велинды",
        ["Velora Nitely and the Brutal Legguards"] = "Велора Нители и Набедренники Жестокости",
        ["Vengeance on the Northspring"] = "Месть клану Северного Источника",
        ["Venom Bottles"] = "Бутыли с ядом",
        ["Venom to the Undercity"] = "Яд в Подгород",
        ["Venture Company Mining"] = "Рудник Торговой компании",
        ["Verdant Sigil"] = "Зеленый знак",
        ["Verifying the Corruption"] = "Проверка на порчу",
        ["Verog the Dervish"] = "Верог Дервиш",
        ["Vessels of Power"] = "Сосуды силы",
        ["Vestments of the Wolf Spirit"] = "Одеяния духа волка",
        ["Veteran Uzzek"] = "Ветеран Уззек",
        ["Veteran's Battlegear"] = "Броня ветерана",
        ["Vibrant Plumes"] = "Радужные перья",
        ["Victims of Corruption"] = "Отравленные скверной",
        ["Victory for the Alliance"] = "Славная победа Альянса",
        ["Victory for the Horde"] = "Победа Орды",
        ["Vile Familiars"] = "Коварные фамильяры",
        ["Vile Idolatry"] = "Вражеские святыни",
        ["Vile Plans"] = "Коварные планы",
        ["Vile Satyr! Dryads in Danger!"] = "Ужасный сатир! Дриады в опасности!",
        ["Vilebranch Hooligans"] = "Хулиганы Дурной Ветви",
        ["Villains of Darrowshire"] = "Негодяи Дарроушира",
        ["Vindicator Aldar"] = "Поборник Алдар",
        ["Vindicator's Rest"] = "Покой Охранника",
        ["Vision Guide"] = "Путеводное видение",
        ["Vision of the Dead"] = "Посмотри в глаза мертвым",
        ["Visit the Herbalist"] = "Визит к травнице",
        ["Vital Intelligence"] = "Важные разведданные",
        ["Vital Supplies"] = "Важные поставки",
        ["Vivian Lagrave"] = "Вивиан Лаграв",
        ["Vivian Lagrave and the Darkstone Tablet"] = "Вивиан Лаграв и табличка Темного Камня",
        ["Void Ridge"] = "Пустынная Гряда",
        ["Voidwalkers Gone Wild"] = "Дикие демоны Хаоса",
        ["Volatile Mutations"] = "Неустойчивая мутация",
        ["Volcanic Activity"] = "Вулканическая активность",
        ["Volunteer's Battlegear"] = "Броня добровольца",
        ["Voodoo Dues"] = "Должники",
        ["Voodoo Feathers"] = "Вудуистские перья",
        ["Voren'thal's Visions"] = "Видения Ворен-Таля",
        ["Vorlus Vilehoof"] = "Ворлус Подлое Копыто",
        ["Vorrel's Revenge"] = "Месть Воррела",
        ["Vorsha the Lasher"] = "Ворша Хлестунья",
        ["Vulture's Vigor"] = "Стойкость стервятника",
        ["Vyletongue Corruption"] = "Скверна Злоязыкого",
        ["Vyral the Vile"] = "Вайрал Подлый",
        ["Vyrin's Revenge"] = "Месть Вирин",
        ["WANTED: Andre Firebeard"] = "РОЗЫСК: Андре Огнебородый",
        ["WANTED: Baron Longshore"] = "РОЗЫСК: барон Долгий Берег",
        ["WANTED: Baron Vardus"] = "РОЗЫСК: барон Вардус",
        ["WANTED: Boss Grog'ak"] = "РАЗЫСКИВАЕТСЯ: Грог'ак!",
        ["WANTED: Caliph Scorpidsting"] = "РОЗЫСК: Калиф Жало Скорпида",
        ["WANTED: Chok'sul"] = "РОЗЫСК: Чок-сул",
        ["WANTED: Deathclaw"] = "РАЗЫСКИВАЕТСЯ: Коготь Смерти",
        ["WANTED: Murkdeep!"] = "РОЗЫСК: Глубомрак!",
        ["WANTED: Overseer Maltorius"] = "РАЗЫСКИВАЕТСЯ: инспектор Мальториус",
        ["WANTED: Syndicate Personnel"] = "РОЗЫСК: сторонники Синдиката",
        ["Wait for Sirra to Finish"] = "Ожидание перевода",
        ["Waking Legends"] = "Пробуждение легенд",
        ["Wand over Fist"] = "Оружие получше кулаков",
        ["Wand to Bethor"] = "Жезл для Бетора",
        ["Wandering Shay"] = "Шай-бродяжница",
        ["Wanted - Arnak Grimtotem"] = "Разыскивается: Арнак Мрачный Тотем",
        ["Wanted! Marez Cowl"] = "Разыскивается: Марез Клобук",
        ["Wanted! Otto and Falconcrest"] = "Разыскивается: Отто и лорд Соколиный Шлем",
        ["Wanted: Annihilator Servo!"] = "В розыске: аннигиляторный сервопривод!",
        ["Wanted: Blacktalon the Savage"] = "Розыск: Чернокоготь Дикая",
        ["Wanted: Bonelashers Dead!"] = "Награда за убитых костеклювов!",
        ["Wanted: Chieftain Mummaki"] = "Разыскивается вождь Муммаки!",
        ["Wanted: DWARVES!"] = "Розыск: ДВОРФЫ!",
        ["Wanted: Durn the Hungerer"] = "Разыскивается: Дерн Ненасытный",
        ["Wanted: Gath'Ilzogg"] = "Розыск: Гатилзогг",
        ["Wanted: Giselda the Crone"] = "Разыскивается: Гизельда Мегера",
        ["Wanted: Knucklerot and Luzran"] = "Розыск: Гнилоступ и Лузран",
        ["Wanted: Lieutenant Fangore"] = "Розыск: лейтенант Фангор",
        ["Wanted: Maggot Eye"] = "Разыскивается: Червеглаз",
        ["Wanted: Thaelis the Hungerer"] = "Розыск: Таэлис Алчущий",
        ["Wanted: Vile Priestess Hexx and Her Minions"] = "Разыскивается: Недобрая жрица Проклятье и ее прислужники",
        ["Wanted: Worg Master Kruush"] = "Розыск: хозяин воргов Крууш",
        ["Wanted: Zorbo the Advisor"] = "Разыскивается: Зорбо Советчик",
        ["Wanted: \"Hogger\""] = "Разыскивается: \"Дробитель\"",
        ["War Banners"] = "Боевые знамена",
        ["War at Sea"] = "Морской бой",
        ["War on Deatholme"] = "Война со Смертхольмом",
        ["War on the Shadowsworn"] = "Война против Преданных Тени",
        ["War on the Warmaul"] = "Войной на Молот Боя",
        ["War on the Woodpaw"] = "Война с кланом Лесной Лапы",
        ["Warden Hamoot"] = "Хранитель Хэмут",
        ["Warlock Training"] = "Обучение чернокнижника",
        ["Warlord Krellian"] = "Предводитель Креллиан",
        ["Warlord Sriss'tiz"] = "Предводитель Шрисс'тиз",
        ["Warlord of the Bleeding Hollow"] = "Вождь Кровавой Лощины",
        ["Warlord's Command"] = "Приказ полководца",
        ["Warn Area 52!"] = "Предупредить Зону 52!",
        ["Warn Your People"] = "Предупреди свой народ",
        ["Warning Fairbreeze Village"] = "Предупреждение деревне Легкий Ветерок",
        ["Warning the Cenarion Circle"] = "Предупреждение Кругу Кенариуса",
        ["Warp-Raider Nesaad"] = "Всадник Искажения Несаад",
        ["Warrior Kinship"] = "Воинское испытание",
        ["Warrior Training"] = "Обучение воина",
        ["Warsong Outrider Update"] = "Сведения разведчика Боевого Клича",
        ["Warsong Runner Update"] = "Сведения гонца Боевого Клича",
        ["Warsong Saw Blades"] = "Пилы Боевого Клича",
        ["Warsong Scout Update"] = "Сведения разведчика Боевого Клича",
        ["Warsong Supplies"] = "Поставка для Боевого Клича",
        ["Washed Ashore"] = "Останки на берегу",
        ["Washte Pawne"] = "Ваште Пауни",
        ["Wasteland"] = "Пустошь",
        ["Wastewander Justice"] = "Расправа над Пустынными Странниками",
        ["Watcher Leesa'oh"] = "Наблюдательница Лисаоха",
        ["Water Elementals"] = "Духи Воды",
        ["Water Pouch Bounty"] = "Награда за воду",
        ["Waters of Xavian"] = "Воды Ксавиана",
        ["Weaken the Ramparts"] = "Ослабить оборону валов",
        ["Weapons of Choice"] = "Избранное оружие",
        ["Weapons of Elunite"] = "Оружие из элунита",
        ["Weapons of Spirit"] = "Оружие духа",
        ["Webwood Egg"] = "Яйцо лесного тенетника",
        ["Webwood Venom"] = "Яд лесного тенетника",
        ["Welcome to the Jungle"] = "Добро пожаловать в джунгли",
        ["Welcome!"] = "Добро пожаловать!",
        ["Welcoming the Wolf Spirit"] = "Приветствие духа Волка",
        ["Well of Corruption"] = "Источник порчи",
        ["Wenikee Boltbucket"] = "Венаки Охапка Болтов",
        ["Westbrook Garrison Needs Help!"] = "Вестбрукский гарнизон просит помощи!",
        ["Westfall Stew"] = "Вестфольская похлебка",
        ["Wharfmaster Dizzywig"] = "Хозяин причала Дыбоволос",
        ["What Are These Things?"] = "Что это такое?",
        ["What Argus Means to Me"] = "Что для тебя Аргус?..",
        ["What Book? I Don't See Any Book."] = "Какая книга? Не вижу никакой книги",
        ["What Comes Around..."] = "Что происходит?",
        ["What Happens in Terokkar Stays in Terokkar"] = "Что в Тероккаре происходит, там же и остается",
        ["What Is Going On?"] = "Что происходит?",
        ["What Must Be Done..."] = "Делай, что должно...",
        ["What Niby Commands"] = "Что хочет Ниби",
        ["What Strange Creatures..."] = "Что за странные создания?",
        ["What Tomorrow Brings"] = "Что ждет нас завтра",
        ["What We Don't Know..."] = "То, чего мы не знаем…",
        ["What We Know..."] = "То, что мы знаем…",
        ["What the Flux?"] = "Какой еще флюс?",
        ["What the Soul Sees"] = "Что видит душа",
        ["What the Wind Carries"] = "Что принес ветер",
        ["What's Wrong at Cenarion Thicket?"] = "Что случилось в Чащобе Кенариуса?",
        ["Wheel of the Black March"] = "Колесо Черного Похода",
        ["Whelps of the Wyrmcult"] = "Драконята Культа Змея",
        ["When Nature Goes Too Far"] = "Когда природа заходит слишком далеко",
        ["When Spirits Speak"] = "Когда говорят духи",
        ["When This Mine's a-Rockin'"] = "Весь рудник ходуном",
        ["When Worlds Collide..."] = "Война Миров",
        ["When the Cows Come Home"] = "Когда коровы возвращаются домой",
        ["Where Did Those Darn Gnomes Go?"] = "Куда подевались эти клятые гномы?",
        ["Where's Wyllithen?"] = "Где Виллитен?",
        ["Whirlwind Weapon"] = "Оружие Смерча",
        ["Whirring Bronze Gizmo"] = "Трещащий бронзовый механизм",
        ["Whiskey Slim's Lost Grog"] = "Потерянный грог Виски Слима",
        ["Whispers of the Raven God"] = "Шепот Бога-ворона",
        ["Whispers on the Wind"] = "Шепот ветра",
        ["Whitebark's Memory"] = "Память о Белостволе",
        ["Who Are They?"] = "Кто они?",
        ["Wild Guardians"] = "Одичавшие стражи",
        ["Wild Hearts"] = "Звериные сердца",
        ["Wild Leather Armor"] = "Дикарские кожаные доспехи",
        ["Wild Leather Boots"] = "Дикарские кожаные сапоги",
        ["Wild Leather Helmet"] = "Дикарский кожаный шлем",
        ["Wild Leather Leggings"] = "Дикарские кожаные поножи",
        ["Wild Leather Shoulders"] = "Дикарские кожаные наплечники",
        ["Wild Leather Vest"] = "Дикарский кожаный жилет",
        ["Wildeyes"] = "Дикоглаз",
        ["Wildkin E'ko"] = "Камень Э'ко совиных медведей",
        ["Wildkin of Elune"] = "Питомцы Элуны",
        ["Wildmane Cleansing"] = "Очищение Дикой Гривы",
        ["Wildmane Totem"] = "Тотем Дикой Гривы",
        ["Williden's Journal"] = "Дневник Вилидена",
        ["Willix the Importer"] = "Импортер Вилликс",
        ["Wind Rider"] = "Новые крылья",
        ["Wind Trader Lathrai"] = "Лайтрай торговец Ветром",
        ["Windows to the Source"] = "Постижение основ",
        ["Windroc Mastery"] = "Охота на ветрухов",
        ["Windrunner Village"] = "Деревня Летящих Ветров",
        ["Winds in the Desert"] = "Ветра пустыни",
        ["Wine Shop Advert"] = "Реклама винного магазина",
        ["Wing Commander Gryphongar"] = "Командир звена Грифонгар",
        ["Winter's Presents"] = "Подарки Зимнего деда",
        ["Winterfall Activity"] = "Боевые действия в деревне Зимнего Сна",
        ["Winterfall E'ko"] = "Камень Э'ко из племени Зимнего Сна",
        ["Winterfall Firewater"] = "Огненный эликсир Племени Зимнего Сна",
        ["Winterfall Intrusion"] = "Вторжение племени Зимнего Сна",
        ["Winterfall Ritual Totem"] = "Ритуальный тотем Зимнего Сна",
        ["Winterfall Runners"] = "Гонцы Зимнего Сна",
        ["Winterhoof Cleansing"] = "Очищение Зимнего Копыта",
        ["Wisdom of Agamaggan"] = "Мудрость Агамаггана",
        ["Witherbark Cages"] = "Тролльи клетки",
        ["Withered Basidium"] = "Высохшая базидия",
        ["Withered Flesh"] = "Иссохшее тело",
        ["Wolves Across the Border"] = "Волки на границе",
        ["Wolves at Our Heels"] = "Волки идут по пятам",
        ["Woodpaw Investigation"] = "Разведка планов Лесной Лапы",
        ["Word from Azure Watch"] = "Вести из Лазурного форпоста",
        ["Word from the Spire"] = "Весточка из замка",
        ["Words of the High Chief"] = "Слова верховного Вождя",
        ["Worgen in the Woods"] = "Воргены в лесу",
        ["Worth Its Weight in Gold"] = "На вес золота",
        ["Wounded Ancients"] = "Раны Дерев",
        ["Wrath of the Blue Flight"] = "Ярость Синих драконов",
        ["Wrenix of Ratchet"] = "Реникс Презренный",
        ["Wretched Ringleader"] = "Главарь Презренных",
        ["Writ of Safe Passage"] = "Подорожная",
        ["Writhing Haunt Cauldron"] = "Котел Призрачной фермы",
        ["Wyrmskull Watcher"] = "Страж Драконьего черепа",
        ["Xorothian Stardust"] = "Зоротианская звездная пыль",
        ["Xylem's Payment to Jediga"] = "Плата Ксилема Джедиге",
        ["Yorus Barleybrew"] = "Йорус Ячменевец",
        ["You Have Served Us Well"] = "За достойную службу",
        ["You Survived!"] = "Ты $gжив:жива;!",
        ["You Too Good."] = "Больше учить нечему",
        ["You're Fired!"] = "Уволена!",
        ["You're Hired!"] = "Тебя наняли!",
        ["You're a Mean One..."] = "Прохладное чувство юмора",
        ["Young Crocolisk Skins"] = "Шкуры молодых кроколисков",
        ["Young Lovers"] = "Юные влюбленные",
        ["Your Fortune Awaits You..."] = "Ты найдешь свою удачу...",
        ["Your Place In The World"] = "Твое место в мире",
        ["Ysera's Tears"] = "Слеза Изеры",
        ["Yuka Screwspigot"] = "Юка Винтокран",
        ["Zaeldarr the Outcast"] = "Зельдарр Изгнанник",
        ["Zalazane"] = "Залазан",
        ["Zamek's Distraction"] = "Помеха Замека",
        ["Zandalarian Shadow Mastery Talisman"] = "Зандаларский талисман Власти над Тенями",
        ["Zando'zan"] = "Зандозан",
        ["Zanzil's Mixture and a Fool's Stout"] = "Смесь Занзила и \"Дурацкое Крепкое\"",
        ["Zanzil's Secret"] = "Тайна Занзила",
        ["Zapped Giants"] = "Ликвидация великанов",
        ["Zapper Fuel"] = "Питание для шокера",
        ["Zenn's Bidding"] = "Просьба Зенна Грязного Копыта",
        ["Zeth'Gor Must Burn!"] = "Сжечь Зет-Гор!",
        ["Zinge's Delivery"] = "Посылка для Зинг",
        ["Ziz Fizziks"] = "Зиз Физзик",
        ["Zombie Juice"] = "Сок зомби",
        ["Zukk'ash Infestation"] = "Вторжение улья Цуккаш",
        ["Zukk'ash Report"] = "Донесение об улье Цуккаш",
        ["Zul'Marosh"] = "Зул'Марош",
        ["Zuluhed the Whacked"] = "Зулухед Замученный",
        ["\"Pretty Boy\" Duncan"] = "\"Красавчик\" Дункан",
        ["rAnS0m"] = "вЫкУП",
} end)

BabbleQuest:Debug()
BabbleQuest:SetStrictness(true)

AceLibrary:Register(BabbleQuest, MAJOR_VERSION, MINOR_VERSION)
BabbleQuest = nil
