function BGEOnLoad()
	-- Register command handler and new commands
	SlashCmdList["BGECOMMAND"] = BGESlashHandler;
	SLASH_BGECOMMAND1 = "/bge";
	SLASH_BGECOMMAND2 = "/bgemote";
	this:RegisterEvent("ADDON_LOADED");
end

function BGEOnEvent(event)
	if (event == "ADDON_LOADED") then
		if arg1 == "BGEmote" then
			this:UnregisterEvent("ADDON_LOADED");
			-- Setup Config
			BGEInit_Config();
			if BGEEnabled then
				if KBEmote then
					this:RegisterEvent("PLAYER_ENTERING_WORLD");
				end
				this:RegisterEvent("CHAT_MSG_SYSTEM");
				this:RegisterEvent("CHAT_MSG_BG_SYSTEM_ALLIANCE");
				this:RegisterEvent("CHAT_MSG_BG_SYSTEM_HORDE");
				this:RegisterEvent("CHAT_MSG_BG_SYSTEM_NEUTRAL");
				this:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
				-- Report load
	   	 	  	BGEChatMsg(BGE_Msg1, 1.0, 1.0, 0.0);
			else
				-- Report load
				BGEChatMsg(BGE_Msg2, 1.0, 1.0, 0.0);
			end
		end
	elseif (event == "PLAYER_ENTERING_WORLD") then
		-- Prepare for a new BG
		if BGEEnabled and KBEmote then
			BGEKBs = 0;
		end
	elseif (event == "CHAT_MSG_BG_SYSTEM_ALLIANCE" or event == "CHAT_MSG_BG_SYSTEM_HORDE" or event == "CHAT_MSG_BG_SYSTEM_NEUTRAL") then
		if BGEEnabled then
			local msg = strlower(arg1);
			if strfind(msg,"begin!") or strfind(msg,"begun!") then
				BGEBegin();
			end
			if GetRealZoneText() == "Warsong Gulch" then
				local factionName = strlower(BGEPlayerFctn);
				local i, j, playerName = string.find(arg1, "(%w+)");
				if strfind(msg,"captured the horde flag") then
					if factionName == "alliance" then -- Player is Alliance
						BGECelebrate(playerName);
					end
				elseif strfind(msg,"captured the alliance flag") then
					if factionName == "horde" then -- Player is Horde
						BGECelebrate(playerName);
					end
				end
			end
		end
	elseif (event == "CHAT_MSG_SYSTEM") then
		if BGEEnabled and IsInGuild() then
			local msg = arg1
			local _, _, player = string.find(msg, BGEJoined)
			if player and (player ~= "") and (strupper(player) ~= strupper(BGEPlayer)) then
				BGEGetJoinMsg(player);
				if BGEmote and (BGEmote ~= "") then
					BGEJoinDelay1 = (GetTime() + 15);
					BGEJoinFrame:Show();
				end
			end
		end
	elseif (event == "COMBAT_LOG_EVENT_UNFILTERED")then			--arg2 = event, arg4 = sourceName, arg7 = destName
		if arg2 == "PARTY_KILL" then
			if arg4 == BGEPlayer and UnitIsPlayer("target") and UnitIsEnemy("target","player") then
				BGEGotKB(arg7);
			end
		end
	end
end

function BGESlashHandler(msg)
	msg = string.lower(msg);
	-- check for 2 arguments first
	local firsti, lasti, command, operand = string.find (msg, "(%w+) (%w+)");
	-- if there weren't 2, then command will be nil - check for one arg    
	if not command then
      	firsti, lasti, command = string.find(msg, "(%w+)");
	end    
	-- respond to commands
    if not command then
      	BGEChatMsg(BGE_Msg3);
    elseif command == "kb" then
    	local KBtarget = UnitName("target");
    	BGEGotKB(KBtarget);
	elseif command == "rude" then
		BGERude();
	elseif command == "yay" then
		BGECelebrate();
	elseif command == "gloat" then
		BGECelebrate(BGEPlayer);
	elseif command == "flirt" then
		BGEFlirt();
	elseif command == "begin" then
		BGEBegin();
 	elseif command == "test" then
		BGEtest();
	elseif command == "dance" then
		BGEDance();
	elseif (command == "status") then
    	local txt = "";
    	if BGEEnabled then 
    		txt = "\nBGEmote: Enabled\n";
    	else 
    		txt = "\nBGEmote: Disabled\n";
    	end
    	if KBEmote then 
    		txt = txt.."KBEmote: Enabled\n";
    	else 
    		txt = txt.."KBEmote: Disabled\n";
    	end
    	BGEGetKBEmote();
    	txt = txt .. "The next Killing Blow Emote is '"..BGEmote.."'\n";
    	BGEGetRudeEmote();
    	txt = txt .. "The next Rude Emote is '"..BGEmote.."'\n";
    	BGEGetCelebrateEmote();
    	txt = txt .. "The next Celebrate Emote is '"..BGEmote.."'\n";
    	BGEGetGloatEmote();
    	txt = txt .. "The next Gloat Emote is '"..BGEPlayer.." "..BGEmote.."'\n";
    	BGEGetFlirtEmote();
    	txt = txt .. "The next Flirt Emote is '"..BGEmote.."'\n";
    	BGEGetBeginEmote();
    	txt = txt .. "The next Begin Emote is '"..BGEmote.."'\n";
		BGEChatMsg(txt);
	elseif command == "say" then
		if BGEKBSay == 1 then
			BGEKBSay = 0;
			BGESaved.BGEKBSay = 0;
		else
			BGEKBSay = 0;
			BGESaved.BGEKBSay = 0;
		end		
	elseif command == "enable" then
        BGEEnabled = true;
		this:RegisterEvent("PLAYER_ENTERING_WORLD");
		this:RegisterEvent("CHAT_MSG_BG_SYSTEM_ALLIANCE");
		this:RegisterEvent("CHAT_MSG_BG_SYSTEM_HORDE");
		this:RegisterEvent("CHAT_MSG_BG_SYSTEM_NEUTRAL");
		this:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
		BGESaved.BGESEnabled = BGEEnabled;
		BGESlashHandler("status");
	elseif command == "disable" then
        BGEEnabled = false;
		this:UnregisterEvent("PLAYER_ENTERING_WORLD");
		this:UnregisterEvent("CHAT_MSG_BG_SYSTEM_ALLIANCE");
		this:UnregisterEvent("CHAT_MSG_BG_SYSTEM_HORDE");
		this:UnregisterEvent("CHAT_MSG_BG_SYSTEM_NEUTRAL");
		this:UnregisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
		BGESaved.BGESEnabled = BGEEnabled;
		BGESlashHandler("status");
	elseif command == "kbe" then
		if KBEmote then
			this:UnregisterEvent("PLAYER_ENTERING_WORLD");
			this:UnregisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
	        KBEmote = false;
	        BGESaved.BGESKBEmote = KBEmote;
			BGEChatMsg("KBEmote disabled");
	    else
			this:RegisterEvent("PLAYER_ENTERING_WORLD");
			this:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
	    	KBEmote = true;
    		BGESaved.BGESKBEmote = KBEmote;
	    	BGEChatMsg("KBEmote enabled");
	    end
	elseif command == "kbcount" then
		local newKBs = 0;
		local name;
		local max = GetNumBattlefieldScores();
		for i=1, max do
			name = GetBattlefieldScore(i);	
			if not name then
				break;	
			elseif (name == BGEPlayer) then
				_, newKBs = GetBattlefieldScore(i);	
				break;
			end
		end
		BGEChatMsg("KBs Scored: "..newKBs.." KBs Emoted: "..BGEKBs, 1.0, 1.0, 0.0);
	else
		BGEChatMsg(BGE_Msg3);
    end
end

function BGEGotKB(victim)
	if victim and BGEEnabled and KBEmote then
		PlaySoundFile("Interface\\AddOns\\BGEmote\\Sounds\\DING.WAV");
		BGEKillingBlow(victim);
		BGEKBs = BGEKBs + 1;
		if BGEKBSay == 1 then
			SendChatMessage("PWNDZ", "SAY");
		end
	end
end

function BGEKillingBlow(pname)
	if pname then
		BGETarget = pname;
	else
		BGETarget = nil;
	end
	BGEGetKBEmote();
	DoEmote(BGEmote, BGETarget);
	BGEKBCount = (BGEKBCount + 1);
	if BGEKBCount > BGEKBMax then
		BGEKBCount = 1;
	end
	BGESaved.BGESKBCount = BGEKBCount;
end

function BGERude(pname)
	if pname then
		BGETarget = pname;
	else
		BGETarget = UnitName("target");
	end
	BGEGetRudeEmote();
	DoEmote(BGEmote, BGETarget);
	BGERudeCount = (BGERudeCount + 1);
	if BGERudeCount > BGERudeMax then
		BGERudeCount = 1;
	end
	BGESaved.BGESRudeCount = BGERudeCount;
end

function BGECelebrate(pname) --Also Gloats
	if pname then
		BGETarget = pname;
	else
		BGETarget = UnitName("target");
	end
	if pname == BGEPlayer then
		BGEGetGloatEmote();
		SendChatMessage(BGEmote,"EMOTE");
		BGEGloatCount = (BGEGloatCount + 1);
		if BGEGloatCount > BGEGloatMax then
			BGEGloatCount = 1;
		end		
	else
		BGEGetCelebrateEmote();
		DoEmote(BGEmote, BGETarget);
		BGECelCount = (BGECelCount + 1);
		if BGECelCount > BGECelMax then
			BGECelCount = 1;
		end
	end
	BGESaved.BGESGloatCount = BGEGloatCount;
	BGESaved.BGESCelCount = BGECelCount;
end

function BGEFlirt()
	BGETarget = UnitName("target");
	BGEGetFlirtEmote();
	DoEmote(BGEmote, BGETarget);
	BGEFlirtCount = (BGEFlirtCount + 1);
	if BGEFlirtCount > BGEFlirtMax then
		BGEFlirtCount = 1;
	end
	BGESaved.BGESFlirtCount = BGEFlirtCount;
end

function BGEBegin(bname)
	BGEGetBeginEmote();
	if BGEBeginCount < 10 then
		DoEmote(BGEmote, bname); -- Passing a nil name to ensure it emotes to "room"
	else
		SendChatMessage(BGEmote,"EMOTE");		
	end
	BGEBeginCount = (BGEBeginCount + 1);
	if BGEBeginCount > BGEBeginMax then
		BGEBeginCount = 1;		
	end
	BGESaved.BGESBeginCount = BGEBeginCount;
end

function BGEDance()
	BGETarget = UnitName("target");
	BGEGetDanceEmote();
	SendChatMessage(BGEmote, "SAY");
	DoEmote("DANCE", BGETarget);
	BGEDanceCount = (BGEDanceCount + 1);
	if BGEDanceCount > BGEDanceMax then
		BGEDanceCount = 1;
	end
	BGESaved.BGESDanceCount = BGEDanceCount;
end

function BGEInit_Config()
	if (not BGESaved) then
		BGESaved = {};
	end
	if (not (BGESaved.BGESEnabled)) then		-- Enable/Disable BGEmote
		BGESaved.BGESEnabled = true;
	end
	if (not (BGESaved.BGESKBemote)) then		-- Killing Blow enable/disable
		BGESaved.BGESKBEmote = true;
	end
	if (not (BGESaved.BGESKBCount)) then		-- Killing Blow count
		BGESaved.BGESKBCount =  math.random(1,BGEKBMax);		
	end
	if (not (BGESaved.BGESRudeCount)) then		-- Rude count
		BGESaved.BGESRudeCount =  math.random(1,BGERudeMax);
	end
	if (not (BGESaved.BGESCelCount)) then		-- Celebrate count
		BGESaved.BGESCelCount =  math.random(1,BGECelMax);
	end
	if (not (BGESaved.BGESGloatCount)) then	-- Gloat Count
		BGESaved.BGESGloatCount =  math.random(1,BGEGloatMax);
	end
	if (not (BGESaved.BGESFlirtCount)) then	-- Flirt count
		BGESaved.BGESFlirtCount =  math.random(1,BGEFlirtMax);
	end
	if (not (BGESaved.BGESBeginCount)) then	-- Begin count
		BGESaved.BGESBeginCount =  math.random(1,BGEBeginMax);
	end
	if (not (BGESaved.BGESDanceCount)) then 	-- Dance count
		BGESaved.BGESDanceCount =  math.random(1,BGEDanceMax);
	end
	if (not (BGESaved.BGEKBSay)) then 			-- Say "PWNDZ" toggle
		BGESaved.BGEKBSay =  0; 				-- Off by default
	end
	BGEEnabled		= BGESaved.BGESEnabled;
	KBEmote			= BGESaved.BGESKBEmote;
	BGEKBCount		= BGESaved.BGESKBCount;
	BGERudeCount	= BGESaved.BGESRudeCount;
	BGECelCount		= BGESaved.BGESCelCount;
	BGEGloatCount	= BGESaved.BGESGloatCount;
	BGEFlirtCount	= BGESaved.BGESFlirtCount;
	BGEBeginCount	= BGESaved.BGESBeginCount;
	BGEDanceCount	= BGESaved.BGESDanceCount;
	BGEKBSay		= BGESaved.BGEKBSay;
end

function BGEChatMsg(msg)
	if( DEFAULT_CHAT_FRAME ) then
		DEFAULT_CHAT_FRAME:AddMessage(msg);
	end
end

function BGEJoinOnUpdate()
	if not (BGEJoinFrame:IsVisible()) then -- Safety net, not really possible, but being safe
		return;
	end
	BGEJoinDelay2 = GetTime();
	if (BGEJoinDelay1 - BGEJoinDelay2 > 0) then
		return;
	end
	SendChatMessage(BGEmote,"GUILD");
	BGEJoinFrame:Hide();
end

function BGEFormatEmote(player)
	if player then
		BGEmote = string.gsub(BGEmote, "($P)", player);	
	end
	BGEmote = string.gsub(BGEmote, "($C)", BGEPlayerClass);
	if strlower(BGEPlayerFctn) == "alliance" then
		-- Is Alliance put down Horde
		BGEmote = string.gsub(BGEmote, "($F1)", "Alliance");
		BGEmote = string.gsub(BGEmote, "($F2)", "Horde");
		BGEmote = string.gsub(BGEmote, "($F)", "Horde");
	else
		-- Is Horde put down Alliance
		BGEmote = string.gsub(BGEmote, "($F1)", "Horde");
		BGEmote = string.gsub(BGEmote, "($F2)", "Alliamce");
		BGEmote = string.gsub(BGEmote, "($F)", "Alliamce");
	end
	if BGEPlayerSex == 3 then
		BGEmote = string.gsub(BGEmote, "($H)", "herself");	-- 3 means the toon is female
	else
		BGEmote = string.gsub(BGEmote, "($H)", "himself");	-- Not 3 means the toon is male or unknown
	end
end

function BGEGetKBEmote()
	if	BGEKBCount == 1 then BGEmote = BGEKB01;
	elseif BGEKBCount == 2  then BGEmote = BGEKB02;
	elseif BGEKBCount == 3  then BGEmote = BGEKB03;
	elseif BGEKBCount == 4  then BGEmote = BGEKB04; 
	elseif BGEKBCount == 5  then BGEmote = BGEKB05;  
	elseif BGEKBCount == 6  then BGEmote = BGEKB06;   
	elseif BGEKBCount == 7  then BGEmote = BGEKB07; 
	elseif BGEKBCount == 8  then BGEmote = BGEKB08;  
	elseif BGEKBCount == 9  then BGEmote = BGEKB09;  
	elseif BGEKBCount == 10 then BGEmote = BGEKB10;  
	elseif BGEKBCount == 11 then BGEmote = BGEKB11;  
	elseif BGEKBCount == 12 then BGEmote = BGEKB12; 
	elseif BGEKBCount == 13 then BGEmote = BGEKB13;  
	elseif BGEKBCount == 14 then BGEmote = BGEKB14;  
	elseif BGEKBCount == 15 then BGEmote = BGEKB15;  
	elseif BGEKBCount == 16 then BGEmote = BGEKB16;  
	elseif BGEKBCount == 17 then BGEmote = BGEKB17; 
	elseif BGEKBCount == 18 then BGEmote = BGEKB18;  
	elseif BGEKBCount == 19 then BGEmote = BGEKB19; 
	elseif BGEKBCount == 20 then BGEmote = BGEKB20;  
	elseif BGEKBCount == 21 then BGEmote = BGEKB21;
	elseif BGEKBCount == 22 then BGEmote = BGEKB22; 
	elseif BGEKBCount == 23 then BGEmote = BGEKB23; 
	elseif BGEKBCount == 24 then BGEmote = BGEKB24; 
	elseif BGEKBCount == 25 then BGEmote = BGEKB25; 
	elseif BGEKBCount == 26 then BGEmote = BGEKB26;
	elseif BGEKBCount == 27 then BGEmote = BGEKB27;
	elseif BGEKBCount == 28 then BGEmote = BGEKB28;
	elseif BGEKBCount == 29 then BGEmote = BGEKB29;
	elseif BGEKBCount == 30 then BGEmote = BGEKB30;
	else
		BGEmote = BGEKB31;
	end
end

function BGEGetRudeEmote()
	if	BGERudeCount == 1 then BGEmote = BGERude01;
	elseif BGERudeCount == 2  then BGEmote = BGERude02;
	elseif BGERudeCount == 3  then BGEmote = BGERude03;
	elseif BGERudeCount == 4  then BGEmote = BGERude04;
	elseif BGERudeCount == 5  then BGEmote = BGERude05;
	elseif BGERudeCount == 6  then BGEmote = BGERude06;
	elseif BGERudeCount == 7  then BGEmote = BGERude07;
	elseif BGERudeCount == 8  then BGEmote = BGERude08;
	elseif BGERudeCount == 9  then BGEmote = BGERude09; 
	elseif BGERudeCount == 10 then BGEmote = BGERude10;
	elseif BGERudeCount == 11 then BGEmote = BGERude11;
	elseif BGERudeCount == 12 then BGEmote = BGERude12;
	elseif BGERudeCount == 13 then BGEmote = BGERude13;
	elseif BGERudeCount == 14 then BGEmote = BGERude14;
	elseif BGERudeCount == 15 then BGEmote = BGERude15;
	elseif BGERudeCount == 16 then BGEmote = BGERude16;
	elseif BGERudeCount == 17 then BGEmote = BGERude17;
	elseif BGERudeCount == 18 then BGEmote = BGERude18;
	elseif BGERudeCount == 19 then BGEmote = BGERude19;
	elseif BGERudeCount == 20 then BGEmote = BGERude20;
	elseif BGERudeCount == 21 then BGEmote = BGERude21;
	elseif BGERudeCount == 22 then BGEmote = BGERude22;
	elseif BGERudeCount == 23 then BGEmote = BGERude23;
	elseif BGERudeCount == 24 then BGEmote = BGERude24;
	elseif BGERudeCount == 25 then BGEmote = BGERude25;
	else
		BGEmote = BGERude26;
	end
	if BGETarget then
		local race = UnitRace("target"); --If it's a Tauren I want to Moo at them, sometimes
		if race and race == "Tauren" then
			local ran = math.random(10,37);
			if strfind("11,13,15,17,19,21,23,25,27,29,31,35,37",ran) then --This provides about a 48% chance of mooing, that is IF the random function is truely random.
				BGEmote = "MOO";
			end
		end
	end
end

function BGEGetCelebrateEmote()
	if	BGECelCount == 1 then BGEmote = BGECel01;
	elseif BGECelCount == 2  then BGEmote = BGECel02;
	elseif BGECelCount == 3  then BGEmote = BGECel03;
	elseif BGECelCount == 4  then BGEmote = BGECel04; 
	elseif BGECelCount == 5  then BGEmote = BGECel05;  
	elseif BGECelCount == 6  then BGEmote = BGECel06;   
	elseif BGECelCount == 7  then BGEmote = BGECel07; 
	elseif BGECelCount == 8  then BGEmote = BGECel08;  
	elseif BGECelCount == 9  then BGEmote = BGECel09;  
	elseif BGECelCount == 10 then BGEmote = BGECel10;  
	elseif BGECelCount == 11 then BGEmote = BGECel11;  
	else
		BGEmote = BGECel12;
	end
end

function BGEGetGloatEmote()
	if BGEGloatCount == 1 then BGEmote = BGEGloat01;
	elseif BGEGloatCount == 2 then BGEmote = BGEGloat02;
	elseif BGEGloatCount == 3 then BGEmote = BGEGloat03;
	elseif BGEGloatCount == 4 then BGEmote = BGEGloat04;
	elseif BGEGloatCount == 5 then BGEmote = BGEGloat05;
	elseif BGEGloatCount == 6 then BGEmote = BGEGloat06;
	elseif BGEGloatCount == 7 then BGEmote = BGEGloat07;
	elseif BGEGloatCount == 8 then BGEmote = BGEGloat08;
	elseif BGEGloatCount == 9 then BGEmote = BGEGloat09;
	elseif BGEGloatCount == 10 then BGEmote = BGEGloat10;
	elseif BGEGloatCount == 11 then BGEmote = BGEGloat11;
	else
		BGEmote = BGEGloat12;
	end
	BGEFormatEmote(BGEPlayer);
end

function BGEGetFlirtEmote()
	if	BGEFlirtCount == 1 then BGEmote = BGEFlirt01;
	elseif BGEFlirtCount == 2  then BGEmote = BGEFlirt02;
	elseif BGEFlirtCount == 3  then BGEmote = BGEFlirt03;
	elseif BGEFlirtCount == 4  then BGEmote = BGEFlirt04; 
	elseif BGEFlirtCount == 5  then BGEmote = BGEFlirt05;  
	elseif BGEFlirtCount == 6  then BGEmote = BGEFlirt06;  
	elseif BGEFlirtCount == 7  then BGEmote = BGEFlirt07;  
	elseif BGEFlirtCount == 8  then BGEmote = BGEFlirt08;  
	elseif BGEFlirtCount == 9  then BGEmote = BGEFlirt09;  
	elseif BGEFlirtCount == 10 then BGEmote = BGEFlirt10;
	elseif BGEFlirtCount == 11 then BGEmote = BGEFlirt11;
	elseif BGEFlirtCount == 12 then BGEmote = BGEFlirt12;
	else
		BGEmote = BGEFlirt13;
	end
end

function BGEGetJoinMsg(NewPlayer)
	local MsgNum = math.random(1,5);
	if MsgNum == 1 then BGEmote = BGEJoinMsg01;
	elseif MsgNum == 2 then BGEmote = BGEJoinMsg02;
	elseif MsgNum == 3 then BGEmote = BGEJoinMsg03;
	elseif MsgNum == 4 then BGEmote = BGEJoinMsg04;
	else
		BGEmote = BGEJoinMsg05;
	end
	BGEFormatEmote(NewPlayer);
end

function BGEGetBeginEmote()
	if	BGEBeginCount == 1 then BGEmote = BGEBegin01;
	elseif BGEBeginCount == 2  then BGEmote = BGEBegin02;
	elseif BGEBeginCount == 3  then BGEmote = BGEBegin03;
	elseif BGEBeginCount == 4  then BGEmote = BGEBegin04; 
	elseif BGEBeginCount == 5  then BGEmote = BGEBegin05;  
	elseif BGEBeginCount == 6  then BGEmote = BGEBegin06;  
	elseif BGEBeginCount == 7  then BGEmote = BGEBegin07;  
	elseif BGEBeginCount == 8  then BGEmote = BGEBegin08;
	elseif BGEBeginCount == 9  then BGEmote = BGEBegin09;
	elseif BGEBeginCount == 10 then BGEmote = BGEBegin10;
	elseif BGEBeginCount == 11 then BGEmote = BGEBegin11;
	elseif BGEBeginCount == 12 then BGEmote = BGEBegin12;
	elseif BGEBeginCount == 13 then BGEmote = BGEBegin13;
	elseif BGEBeginCount == 14 then BGEmote = BGEBegin14;
	else
		BGEmote = BGEBegin15;
	end
	BGEFormatEmote();
end

function BGEGetDanceEmote()
	if BGEDanceCount == 1 then BGEmote = BGEDance01;
	elseif BGEDanceCount == 2 then BGEmote = BGEDance02;
	elseif BGEDanceCount == 3 then BGEmote = BGEDance03;
	elseif BGEDanceCount == 4 then BGEmote = BGEDance04;
	elseif BGEDanceCount == 5 then BGEmote = BGEDance05;
	elseif BGEDanceCount == 6 then BGEmote = BGEDance06;
	elseif BGEDanceCount == 7 then BGEmote = BGEDance07;
	elseif BGEDanceCount == 8 then BGEmote = BGEDance08;
	elseif BGEDanceCount == 9 then BGEmote = BGEDance09;
	elseif BGEDanceCount == 10 then BGEmote = BGEDance10;
	elseif BGEDanceCount == 11 then BGEmote = BGEDance11;
	elseif BGEDanceCount == 12 then BGEmote = BGEDance12;
	elseif BGEDanceCount == 13 then BGEmote = BGEDance13;
	elseif BGEDanceCount == 14 then BGEmote = BGEDance14;
	elseif BGEDanceCount == 15 then BGEmote = BGEDance15;
	elseif BGEDanceCount == 16 then BGEmote = BGEDance16;
	elseif BGEDanceCount == 17 then BGEmote = BGEDance17;
	elseif BGEDanceCount == 18 then BGEmote = BGEDance18;
	elseif BGEDanceCount == 19 then BGEmote = BGEDance19;
	elseif BGEDanceCount == 20 then BGEmote = BGEDance20;
	else
		if BGEPlayerSex == 3 then 
			BGEmote = BGEDance21f;	-- If the toon is female
		else
			BGEmote = BGEDance21m;	-- If the toon is male
		end
	end
end
