do
	local class = select(2,UnitClass("player"));
	if (class == "MAGE" or class == "WARLOCK" or class == "PRIEST") then
		return;
	end
end

local b = AzCastBar_MakeBar();
local pName = UnitName("player");
local prefix, suffix;
local spellSwingReset = {
	["Heroic Strike"] = true,
	["Slam"] = true,
};

--------------------------------------------------------------------------------------------------------
--                                           Frame Scripts                                            --
--------------------------------------------------------------------------------------------------------

local function OnUpdate(self,elapsed)
	-- Update Bar
	if (b.fadeTime == 0) then
		b.timeProgress = (GetTime() - b.startTime);
		b.timeLeft = max(0,b.maxValue - b.timeProgress);

		b.status:SetValue(b.maxValue - b.timeLeft);
		b.right:SetText(AzCastBar_FormatTime(b.timeLeft));

		if (b.timeLeft == 0) then
			b.fadeTime = b.cfg.fadeTime;
		end
	-- Fade
	elseif (b.fadeElapsed < b.fadeTime) then
		b.fadeElapsed = (b.fadeElapsed + arg1);
		b:SetAlpha(b.cfg.alpha - b.fadeElapsed / b.fadeTime * b.cfg.alpha);
	else
		b:Hide();
	end
end

--------------------------------------------------------------------------------------------------------
--                                           Event Handling                                           --
--------------------------------------------------------------------------------------------------------
local function StartSwing(time,text)
	b.maxValue = time;
	b.left:SetText(text);
	b.startTime = GetTime();
	b.status:SetMinMaxValues(0,b.maxValue);
	b.status:SetStatusBarColor(unpack(b.cfg.colNormal));
	b.fadeTime = 0;
	b.fadeElapsed = 0;
	b:SetAlpha(b.cfg.alpha);
	b:Show();
end

local function OnEvent(self,event,time,type,sourceGUID,sourceName,sourceFlags,destGUID,destName,destFlags,...)
	-- Something our Player does
	if (sourceName == pName) then
		prefix, suffix = type:match("(.-)_(.+)");
		if (prefix == "SWING") then
			StartSwing(UnitAttackSpeed("player"),"Melee Swing");
		elseif (prefix == "RANGE") and (select(2,...) == "Auto Shot") then
			StartSwing(UnitRangedDamage("player"),"Auto Shot");
		elseif (prefix == "SPELL") and (spellSwingReset[select(2,...)]) then
			StartSwing(UnitAttackSpeed("player"),"Melee Swing");
		end
	-- Something Happens to our Player
	elseif (destName == pName) then
		prefix, suffix = type:match("(.-)_(.+)");
		if (prefix == "SWING") and (suffix == "MISSED") and (b.maxValue) and (select(1,...) == "PARRY") then
			b.maxValue = (b.maxValue - (b.startTime + b.maxValue - GetTime()) * 0.5);
			b.status:SetMinMaxValues(0,b.maxValue);
			b.status:SetStatusBarColor(1.0,0.75,0.5,1.0);
		end
	else
		return;
	end
end

--------------------------------------------------------------------------------------------------------
--                                            Config Change                                           --
--------------------------------------------------------------------------------------------------------

local function OnConfigChanged(self)
	if (b.cfg.enabled) then
		b:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
	else
		b:UnregisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
	end
end

b.OnConfigChanged = OnConfigChanged;

--------------------------------------------------------------------------------------------------------
--                                              Finalise                                              --
--------------------------------------------------------------------------------------------------------

-- Init Bar
b.token = "Swing";
b:SetPoint("CENTER",0,140);
b.icon:SetTexture("Interface\\Icons\\Spell_Shadow_SoulLeech_2");
tinsert(AzCastBar_Frames,b);
-- Events
b:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
-- Specific Frame Events
b:SetScript("OnUpdate",OnUpdate);
b:SetScript("OnEvent",OnEvent);