if (select(2,UnitClass("player")) ~= "PALADIN") then
	return;
elseif (UnitLevel("player") < 40) then
	return;
end

local b = AzCastBar_MakeBar();
local LIGHTSGRACE = "Light's Grace";
local timeLeft;

--------------------------------------------------------------------------------------------------------
--                                           Event Handling                                           --
--------------------------------------------------------------------------------------------------------
local function OnEvent(self,event)
	-- End if Disabled
	if (not b.cfg) or (not b.cfg.enabled) then
		return;
	-- Aura Change
	elseif (event == "UNIT_AURA") and (arg1 == "player") then
		local name, duration, timeLeft;
		for i = 1, 40 do
			name, _, _, _, duration, timeLeft = UnitBuff("player",i);
			if (not name) then
				self.endTime = 0;
				break;
			elseif (name == LIGHTSGRACE) then
				self.endTime = (GetTime() + timeLeft);
				b.status:SetMinMaxValues(0,duration);
				break;
			end
		end
	end
end

--------------------------------------------------------------------------------------------------------
--                                            Bar OnUpdate                                            --
--------------------------------------------------------------------------------------------------------

local function OnUpdate(self,elapsed)
	timeLeft = max(0,self.endTime - GetTime());
	if (self.timeLeft ~= timeLeft) then
		b.status:SetValue(timeLeft);
		b.right:SetText(AzCastBar_FormatTime(timeLeft));

		if (timeLeft > 3) then
			if (self.timeLeft <= 3) then
				b.status:SetStatusBarColor(unpack(b.cfg.colNormal));
			end
		elseif (timeLeft > 2) then
			if (self.timeLeft > 3) then
				b.status:SetStatusBarColor(1.0,0.75,0.5,1.0);
			end
		elseif (timeLeft > 0) then
			if (self.timeLeft > 2) then
				b.status:SetStatusBarColor(1.0,0.5,0.5,1.0);
			end
		end

		self.timeLeft = timeLeft;
	end
end

--------------------------------------------------------------------------------------------------------
--                                                Code                                                --
--------------------------------------------------------------------------------------------------------

local function OnConfigChanged(self)
	if (b.cfg.enabled) then
		b:Show();
	else
		b:Hide();
	end
end

b.OnConfigChanged = OnConfigChanged;
b.OnEditMode = OnConfigChanged;

--------------------------------------------------------------------------------------------------------
--                                                Finalize                                            --
--------------------------------------------------------------------------------------------------------

-- Init AzCastBar Entry
b.token = "LightsGrace";
tinsert(AzCastBar_Frames,b);
-- Events
b:RegisterEvent("PLAYER_AURAS_CHANGED");
b:RegisterEvent("UNIT_AURA");
b:SetScript("OnUpdate",OnUpdate);
b:SetScript("OnEvent",OnEvent);
-- Secure Macro Button
local frame = CreateFrame("Button",nil,b,"SecureActionButtonTemplate");
frame:SetAttribute("type","macro");
frame:SetAttribute("macrotext","/cast [target=player] Holy Light(Rank 1)");
frame:SetPoint("TOPLEFT");
frame:SetPoint("BOTTOMRIGHT");
frame:SetFrameStrata("LOW");
frame:SetFrameLevel(frame:GetFrameLevel() - 1);
frame:Show();
-- Init Bar
b.icon:SetTexture("Interface\\Icons\\Spell_Holy_LightsGrace");
b.left:SetText(LIGHTSGRACE);
b:SetPoint("CENTER",-50);
b.status:SetMinMaxValues(0,15);
b.status:SetValue(0);
b.endTime = 0;
b.timeLeft = -1;
b.duration = 15;
b:Show();