FlightTimes_Data = {};

-- Misc
local f = {};

-- Init Specific Mod Vars
local b = AzCastBar_MakeBar();
local modName = "ACB_FlightTimes";

--------------------------------------------------------------------------------------------------------
--                                           Frame Scripts                                            --
--------------------------------------------------------------------------------------------------------

local function OnEvent(self,event)
	-- End if Disabled
	if (not b.cfg or not b.cfg.enabled) then
		return;
	-- Cancel Flight if User Accepts Summon or Leaves the World
	elseif (event == "CONFIRM_SUMMON" or event == "PLAYER_LEAVING_WORLD") and (self:IsVisible()) then
		self.fadeTime = b.cfg.fadeTime;
		AzMsg("|2FlightTimes|r Flight Timer Aborted, User Summoned or Zoned.");
	-- Vars Loaded
	elseif (event == "VARIABLES_LOADED")  then
		FlightTimes_MergeTables();
	end
end

local function OnUpdate(self,elapsed)
	-- Update
	if (self.fadeTime == -1) then
		-- Progress
		f.timeProgress = (GetTime() - f.flightStart);
		if (f.entry) then
			self.status:SetValue(f.timeProgress);
			self.right:SetText(AzCastBar_FormatTime(FlightTimes_Data[f.entry] - f.timeProgress));
		else
			self.right:SetText(AzCastBar_FormatTime(f.timeProgress));
		end
		-- Check if we landed
		if (f.timeProgress > 10) and (not UnitOnTaxi("player")) then
			FlightTimes_Data[f.from.." / "..f.dest] = f.timeProgress;
			self.fadeTime = b.cfg.fadeTime;
		end
	-- Fade
	elseif (self.fadeElapsed < self.fadeTime) then
		self.fadeElapsed = (self.fadeElapsed + elapsed);
		self:SetAlpha(1 - self.fadeElapsed / self.fadeTime);
	else
		self:Hide();
	end
end

--------------------------------------------------------------------------------------------------------
--                                           Slash Handling                                           --
--------------------------------------------------------------------------------------------------------
_G["SLASH_"..modName.."1"] = "/flight";
SlashCmdList[modName] = function(cmd)
	-- Extract Parameters
	local param1, param2 = cmd:match("^([^%s]+)%s*(.*)$");
	param1 = (param1 and param1:lower() or cmd:lower());
	-- Spam Nodes
	if (param1 == "spam") then
		AzMsg("----- |2Number of Connected Flight Paths: |1"..NumTaxiNodes().."|r -----");
		for i = 1, NumTaxiNodes() do
			AzMsg("|2"..TaxiNodeName(i).."|r Type = |1"..TaxiNodeGetType(i).."|r, Cost = "..AzMod_FormatGold(TaxiNodeCost(i))..".");
		end
	-- Routes
	elseif (param1 == "routes") then
		local counter = 0;
		for name, time in pairs(FlightTimes_Data) do
			counter = (counter + 1);
		end
		AzMsg("|2FlightTimes|r Number of recorded routes are |1"..counter.."|r.");
	-- Invalid or No Command
	else
		UpdateAddOnMemoryUsage();
		AzMsg("----- |2"..modName.."|r |1"..GetAddOnMetadata(modName,"Version").."|r ----- |1"..format("%.2f",GetAddOnMemoryUsage(modName)).." |2kb|r -----");
		AzMsg("The following |2paramters|r are valid:");
		AzMsg(" |2spam|r = Spams all the connected flight paths including prices (mostly for debug)");
		AzMsg(" |2routes|r = Lists how many routes has been recorded");
	end
end
--------------------------------------------------------------------------------------------------------
--                                     HOOK: TaxiNodeOnButtonEnter                                    --
--------------------------------------------------------------------------------------------------------
local TaxiNodeOnButtonEnter_Real = TaxiNodeOnButtonEnter;
function TaxiNodeOnButtonEnter(button)
	TaxiNodeOnButtonEnter_Real(button);
	-- If enabled, Add flight time on all flightpoints except current
	if (b.cfg.enabled) and (TaxiNodeGetType(button:GetID()) ~= "CURRENT") then
		-- Find From and Dest Nodes
		f.from, f.dest = nil, TaxiNodeName(button:GetID());
		for i = 1, NumTaxiNodes() do
			if (TaxiNodeGetType(i) == "CURRENT") then
				f.from = TaxiNodeName(i);
				break;
			end
		end
		-- Continue only if both points are found
		if (f.from and f.dest) then
			f.time1 = FlightTimes_Data[f.from.." / "..f.dest];
			f.time2 = FlightTimes_Data[f.dest.." / "..f.from];
			if (f.time1 or f.time2) then
				if (f.time1) then
					GameTooltip:AddDoubleLine("Flight Time:",AzCastBar_FormatTime(f.time1),nil,nil,nil,1,1,1);
				end
				if (f.time2) then
					GameTooltip:AddDoubleLine("Return Flight Time:",AzCastBar_FormatTime(f.time2),nil,nil,nil,1,1,1);
				end
			else
				GameTooltip:AddLine("Unknown Flight Time");
			end
			GameTooltip:Show();
		end
	end
end
--------------------------------------------------------------------------------------------------------
--                                         HOOK: TakeTaxiNode                                         --
--------------------------------------------------------------------------------------------------------
local TakeTaxiNode_Real = TakeTaxiNode;
function TakeTaxiNode(nodeId)
	-- Check if enabled
	if (b.cfg.enabled) and (TaxiNodeGetType(nodeId) ~= "CURRENT") then
		-- Find From and Dest Nodes
		f.from, f.dest = nil, TaxiNodeName(nodeId);
		for i = 1, NumTaxiNodes() do
			if (TaxiNodeGetType(i) == "CURRENT") then
				f.from = TaxiNodeName(i);
				break;
			end
		end
		-- Find Table Entry, but do only so if both points are found
		if (f.from and f.dest) then
			if (FlightTimes_Data[f.from.." / "..f.dest]) then
				f.entry = f.from.." / "..f.dest;
			elseif (FlightTimes_Data[f.dest.." / "..f.from]) then
				f.entry = f.dest.." / "..f.from;
			else
				f.entry = nil;
			end
			-- Init Bar
			f.flightStart = GetTime();
			b:InitBar();
		end
	end
	-- Take Taxi
	TakeTaxiNode_Real(nodeId);
end

--------------------------------------------------------------------------------------------------------
--                                              Finalize                                              --
--------------------------------------------------------------------------------------------------------

-- Init Bar for Flight
function b:InitBar()
	b.left:SetText(f.dest);
	b.status:SetMinMaxValues(0,f.entry and FlightTimes_Data[f.entry] or 0);
	b.status:SetValue(0);

	b.fadeTime = -1;
	b.fadeElapsed = 0;
	b:SetAlpha(b.cfg.alpha);
	b:Show();
end

function b:OnEditMode(state)
	if (not state) and (b.fadeTime == -1) then
		b:InitBar();
	end
end

b.token = "Flight"
b.icon:SetTexture("Interface\\Icons\\Ability_Druid_FlightForm");
b:SetPoint("CENTER",0,50);
b:SetScript("OnUpdate",OnUpdate);
b:SetScript("OnEvent",OnEvent);
b:RegisterEvent("PLAYER_LEAVING_WORLD");
b:RegisterEvent("CONFIRM_SUMMON");
b:RegisterEvent("VARIABLES_LOADED");
tinsert(AzCastBar_Frames,b);