AutoTurnin = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceConsole-2.0", "AceDB-2.0", "FuBarPlugin-2.0")
AutoTurnin.dewdrop = AceLibrary("Dewdrop-2.0")

--FuBar options
AutoTurnin.name = "AutoTurnin"
AutoTurnin.title = "AutoTurnin"
AutoTurnin.hasNoColor = true
AutoTurnin.cannotDetachTooltip = true
AutoTurnin.hideWithoutStandby = true
AutoTurnin.independentProfile = true
AutoTurnin.hasIcon = "Interface\\GossipFrame\\ActiveQuestIcon"

-- quest autocomplete handlers and functions
function AutoTurnin:OnEnable()
  self:RegisterEvent("QUEST_PROGRESS")
  self:RegisterEvent("QUEST_COMPLETE")
  self:RegisterEvent("GOSSIP_SHOW")
end

function AutoTurnin:OnDisable()
  self:UnregisterAllEvents()
--  self:UnregisterEvent("QUEST_PROGRESS")
--  self:UnregisterEvent("QUEST_COMPLETE")
--  self:UnregisterEvent("GOSSIP_SHOW")
end

function AutoTurnin:OnInitialize()
  local hcolor = "|cFF77BBFF"
  self:RegisterDB("AutoTurninDB", "AutoTurninDBPC")
	self:RegisterDefaults("profile", {
	})
	-- Ace Options table for the console commands & fubar menu
  self.options = {}
	-- setup options for console
	self.options.console = {
    type = "group",
    args = {
      header = {
				type = "header",
				name = hcolor.."AutoTurnin",
				icon = "Interface\\GossipFrame\\ActiveQuestIcon",
				iconHeight = 16,
				iconWidth = 16,
				order = 1
			},
      options = {
				type = "execute",
				name = nameOptions,
				desc = descOptions,
				func = function() self:OpenMenuConsole(UIParent) end,
				order = 100,
				guiHidden = true
			},
    }
  }
  -- setup options for fubar
	self.options.fubar = {
    type = "group",
    args = {
    }
  }
  self:RegisterChatCommand("/autoturnin", self.options.console)
  self.OnMenuRequest = self.options.fubar
end

function AutoTurnin:OpenMenuConsole(frame)
	self.dewdrop:Open(frame,
		'children', function(level, value)
				self.dewdrop:FeedAceOptionsTable(self.options.console)
			end,
		'cursorX', true,
		'cursorY', true
	)
end

-- the skip token allows us to avoid doing redundant GetItemCounts and table scans since you usually go through three events in completing a quest
AutoTurnin.skiptoken = false

function AutoTurnin:GOSSIP_SHOW()
  if (GetGossipAvailableQuests()) then
    AutoTurnin.skiptoken = false
    if (UnitName("target") == "Vinchaxa") then
      self:ZGHandler()
      return
    end
    local q, qname
    local qcols = 3
    local listmax = 24
    local gaq = {GetGossipAvailableQuests()}
    local c = 1
    for i=1, listmax, qcols do
      if not gaq[i] then
        break
      end
      for _,qname in pairs(AutoTurnin_AutoQuests) do
        if (gaq[i] == qname) then 
          AutoTurnin.skiptoken = true
          SelectGossipAvailableQuest(c)
          return
        end
      end
      c = c + 1
    end
    c = 1
    for i=1, listmax, qcols do
      if not gaq[i] then
        break
      end
      for qname, q in pairs(AutoTurnin_MultiQuests) do
        if (gaq[i] == qname and GetItemCount(q.turnin) >= q.amount) then
          AutoTurnin.skiptoken = true
          SelectGossipAvailableQuest(c)
          return
        end
      end
      c = c + 1
    end
    c = 1
    for i=1, listmax, qcols do
      if not gaq[i] then
        break
      end
      for qname, q in pairs(AutoTurnin_MultiQuestsPass2) do
        if (gaq[i] == qname and GetItemCount(q.turnin) >= q.amount) then
          AutoTurnin.skiptoken = true
          SelectGossipAvailableQuest(c)
          return
        end
      end
      c = c + 1
    end
  end
end

function AutoTurnin:QUEST_PROGRESS()
  if AutoTurnin.skiptoken then 
	  AutoTurnin.skiptoken = false
	  CompleteQuest() end
  local q, qname
  for _, q in pairs(AutoTurnin_AutoQuests) do
    if (string.lower(GetTitleText()) == string.lower(q)) then 
      AutoTurnin.skiptoken = true
      CompleteQuest() 
      return 
    end
  end
  for qname, q in pairs(AutoTurnin_MultiQuests) do
    if (string.lower(GetTitleText()) == string.lower(qname) and GetItemCount(q.turnin) >= q.amount) then
      AutoTurnin.skiptoken = true
      CompleteQuest()
      return
    end
  end
  for qname, q in pairs(AutoTurnin_MultiQuestsPass2) do
    if (string.lower(GetTitleText()) == string.lower(qname) and GetItemCount(q.turnin) >= q.amount) then
      AutoTurnin.skiptoken = true
      CompleteQuest()
      return
    end
  end
end

function AutoTurnin:QUEST_COMPLETE()
  if AutoTurnin.skiptoken then 
	  AutoTurnin.skiptoken = false
	  GetQuestReward(QuestFrameRewardPanel.itemChoice) 
  end
  local q, qname
  for _, q in pairs(AutoTurnin_AutoQuests) do
    if (GetTitleText() == q) then
      GetQuestReward(QuestFrameRewardPanel.itemChoice)
      return
    end
  end
  for qname, q in pairs(AutoTurnin_MultiQuests) do
    if (GetTitleText() == qname) then
      GetQuestReward(QuestFrameRewardPanel.itemChoice)
      return
    end
  end
  for qname, q in pairs(AutoTurnin_MultiQuestsPass2) do
    if (GetTitleText() == qname) then
      GetQuestReward(QuestFrameRewardPanel.itemChoice)
      return
    end
  end
end

function AutoTurnin:ZGHandler()
  local i, q, qname
  local qcols = 3
  local listmax = 24
  local c = 1
  local gaq = {GetGossipAvailableQuests()}
  for i=1, listmax, qcols do
    if not gaq[i] then
      break
    end
    for qname, q in pairs(AutoTurnin_ZGQuests) do
      if (string.lower(gaq[i]) == string.lower(qname)) then
        if ((GetItemCount(q.turnin1) >= 1) and (GetItemCount(q.turnin2) >= 1) and (GetItemCount(q.turnin3) >= 1)) then
          AutoTurnin.skiptoken = true
          SelectGossipAvailableQuest(c)
          return
        end
      end
    end
    c = c + 1
  end
end
