local isLocalized = true;
local AT_active = true;
local MessageStart, MessageEnable, MessageDisabled, MessageClass;
local checkCDSpellname = GetSpellInfo(1494); -- Spell for checking GCD (tracking humanoids)
local creature;

-- Register every creaturetype
local tracking = {
	["Beast"] = 0;
	["Humanoid"] = 0;
	["Undead"] = 0;
	["Giant"] = 0;
	["Elemental"] = 0;
	["Demon"] = 0;
	["Dragonkin"] = 0;
	["Mechanical"] = 0;
	["Critter"] = 0;
	["Not specified"] = 0;
}


-- Localization, currently enUS and deDE
function AT_Localization()
	if (GetLocale() == "enUS") then
		creature = {
			["Beast"] = "Beast";
			["Humanoid"] = "Humanoid";
			["Undead"] = "Undead";
			["Giant"] = "Giant";
			["Elemental"] = "Elemental";
			["Demon"] = "Demon";
			["Dragonkin"] = "Dragonkin";
			["Mechanical"] = "Mechanical";
			["Critter"] = "Critter";
			["Not specified"] = "Not specified";
		}
		MessageStart = "AutoTrack loaded.";
		MessageEnabled = "AutoTrack activated.";
		MessageDisabled = "AutoTrack deactivated.";
		MessageClass = "You are not a hunter, AutoTrack not active!";
	
	elseif (GetLocale() == "deDE") then
		creature = {
			["Wildtier"] = "Beast";
			["Humanoid"] = "Humanoid";
			["Untoter"] = "Undead";
			["Riese"] = "Giant";
			["Elementar"] = "Elemental";
			["D\195\164mon"] = "Demon";
			["Drachkin"] = "Dragonkin";
			["Mechanisch"] = "Mechanical";
			["Tier"] = "Critter";
			["Nicht spezifiziert"] = "Not specified";
		}
		MessageStart = "AutoTrack wurde geladen.";
		MessageEnabled = "AutoTrack aktiviert.";
		MessageDisabled = "AutoTrack deaktiviert.";
		MessageClass = "Du bist kein J\195\164, AutoTrack abgeschaltet!";
	
	else 
		isLocalized = false;
		AT_active = false;
		DEFAULT_CHAT_FRAME:AddMessage('AutoTrack critical error: No support for '..GetLocale()..'-localization.')
	end
end


function AT_Load()
	this:RegisterEvent('PLAYER_LOGIN')
	SLASH_AT1 = "/at";
	SLASH_AT2 = "/autotrack";
	DEFAULT_CHAT_FRAME:AddMessage(MessageStart)
end

SlashCmdList["AT"] = function(param)
	if ( isLocalized == true ) then 
		if ( AT_active == true ) then
			AT_active = false;
			DEFAULT_CHAT_FRAME:AddMessage(MessageDisabled);
		else
			AT_active = true;
			DEFAULT_CHAT_FRAME:AddMessage(MessageEnabled);
		end
	else
		DEFAULT_CHAT_FRAME:AddMessage('AutoTrack critical error: Localization for '..GetLocale()..' currently not supported.')
	end
end

-- Returns current tracking ID
function AT_GetCurrentTracking()
    for i=1, GetNumTrackingTypes() do
		if (select(3,GetTrackingInfo(i))) then return i end
	end
	return nil
end

function AT_CheckTrackingIDs()
	if ( isLocalized == true ) then
		for i=1, GetNumTrackingTypes() do
			name, texture, active, category = GetTrackingInfo(i);
			if ( name == GetSpellInfo(1494) ) then
				tracking["Beast"] = i;
			elseif ( name == GetSpellInfo(19883) )then
				tracking["Humanoid"] = i;
			elseif ( name == GetSpellInfo(19884) ) then 
				tracking["Undead"] = i;
			elseif ( name == GetSpellInfo(19882) ) then
				tracking["Giant"] = i;
			elseif ( name == GetSpellInfo(19880) ) then 
				tracking["Elemental"] = i;
			elseif ( name == GetSpellInfo(19878) ) then 
				tracking["Demon"] = i;
			elseif ( name == GetSpellInfo(19879) ) then
				tracking["Dragonkin"] = i;
			end
		end
	end
end

function AT_Event(event)
	if ( event == 'PLAYER_LOGIN' ) then
		local localizedClass, englishClass = UnitClass('player');
		if ( englishClass == 'HUNTER' ) then
			this:RegisterEvent('CHAT_MSG_SKILL');
			AT_Localization();
			AT_CheckTrackingIDs();
		else
			DEFAULT_CHAT_FRAME:AddMessage(MessageClass);
			AT_active = false;
		end
	elseif (event == 'CHAT_MSG_SKILL') then
		AT_CheckTrackingIDs();
	end
end

function AT_Update()
	if ( AT_active == true ) then
		local creatureType = UnitCreatureType("target");
		local friend = UnitIsFriend("player","target");
		local name, texture, active, category = GetTrackingInfo(AT_GetCurrentTracking());
		local UseTrackingID;
		local CDstart, CDduration, CDenabled;
		if ( not UnitIsFriend("player","target") ) and ( not UnitIsDead("target") ) and ( creatureType ) then
			if ( AT_GetCurrentTracking() ~= tracking[creature[creatureType]] ) then
				UseTrackingID = tracking[creature[creatureType]];
			else
				UseTrackingID = 0;
			end
			if ( UseTrackingID > 0 ) then
				CDstart, CDduration, CDenabled = GetSpellCooldown(checkCDSpellname);
				if ( CDduration == 0 ) then
					SetTracking(UseTrackingID);
				end
			end
		end
	end
end 