-- Globals
AutoSave_VariablesLoaded = false;
AutoSave_myRealm = GetCVar("realmName");

AutoRestartDetails = {
	name = "AutoSave";
	category = MYADDONS_CATEGORY_PLUGINS,
};

 --default config
AutoSaveOptions_Duration = 1;
AutoSaveOptions_Enabled = true;
AutoSaveOptions_MinimapPosition = 42;


function out(msg)
	DEFAULT_CHAT_FRAME:AddMessage(msg);
end

function AutoSave_OnLoad()
	this:RegisterForDrag("LeftButton");
	this:RegisterEvent("ADDON_LOADED");
	this:RegisterEvent("PLAYER_ENTERING_WORLD");
	this:RegisterEvent("VARIABLES_LOADED");
	
	SlashCmdList["AUTOSAVE"] = AutoSave_SlashHandler;
	SLASH_AUTOSAVE1 = "/autosave";
	SLASH_AUTOSAVE2 = "/as";
SlashCmdList["ZAPIS"] = zapis_command;
SLASH_ZAPIS1 = "/save";
end

function AutoSave_OnEvent(event)
	if (event=="PLAYER_ENTERING_WORLD") then
	end
	if (event=="VARIABLES_LOADED") then
		initAutoSave_Options();
		out("***Auto Save 1.3 successfully loaded.***");
		
		if Chronos then
			ChronosHandler();
		end
	end
end

function AutoSave_SlashHandler(msg)
	if ( msg == "reset" ) then
		AutoSaveOptions_Duration = 1;
		AutoSaveOptions_Enabled = true;
		AutoSaveOptions_MinimapPosition = 42;
		AutoSave_Options[AutoSave_myRealm].Duration = AutoSaveOptions_Duration;
		AutoSave_Options[AutoSave_myRealm].Enabled = AutoSaveOptions_Enabled;
		AutoSave_Options[AutoSave_myRealm].MinimapPosition = AutoSaveOptions_MinimapPosition;
		ASMinimap_SetPoint()
		out("AutoSave 1.3: All settings set to default!");
	else
		local frame = getglobal("AutoSave_OptionsFrame")
		if ( frame ) then
			if ( frame:IsVisible() ) then
				frame:Hide();
			else
				frame:Show();
			end
		end
	end
end


function AutoSaveOptionsFrame_OnLoad()
	this:RegisterForDrag("LeftButton");

end

--[[ Loads the current Settings on Options Frame ]]--
function AutoSaveOptionsFrame_OnShow()
	local Duration = AutoSave_Options[AutoSave_myRealm].Duration;
	local Enabled = AutoSave_Options[AutoSave_myRealm].Enabled;
	ASOptions_EditBox:SetText(Duration);
	if ( Enabled == true ) then
		ASOptions_CheckButton:SetChecked(true);
	else
		ASOptions_CheckButton:SetChecked(false);
	end
end

function AutoSaveOptionsFrame_OnUpdate(arg1)
end

function AutoSaveOptionsFrame_OnDragStart()
	AutoSave_OptionsFrame:StartMoving()
end

function AutoSaveOptionsFrame_OnDragStop()
	AutoSave_OptionsFrame:StopMovingOrSizing()
end

function AutoSaveOptionsFrame_OnMouseUp()
end


function GetCheckedValue(src)
	if ( not src ) then
		return false;
	else
		return true;
	end
end

function AutoSaveOptions_OnClick()
	local editBox = ASOptions_EditBox:GetText();
	local checkBox = GetCheckedValue(ASOptions_CheckButton:GetChecked());
	if ( editBox == nil or editBox == "") then
		out("AutoSave 1.3 Error: Please insert number in the box!");
		return;
	end
	AutoSaveOptions_Duration = editBox;
	AutoSaveOptions_Enabled = checkBox;
	AutoSaveOptions_StoreSettings();
	ChronosHandler();
end

function AutoSaveOptions_StoreSettings()
	AutoSave_Options[AutoSave_myRealm].Duration = AutoSaveOptions_Duration;
	AutoSave_Options[AutoSave_myRealm].Enabled = AutoSaveOptions_Enabled;
	out("AutoSave 1.3: Settings saved!");
end

function AutoSaveOptions_LoadSettings()
	AutoSaveOptions_Duration = AutoSave_Options[AutoSave_myRealm].Duration;
	AutoSaveOptions_Enabled = AutoSave_Options[AutoSave_myRealm].Enabled;
	AutoSaveOptions_MinimapPosition = AutoSave_Options[AutoSave_myRealm].MinimapPosition;
end

function initAutoSave_Options()
	if ( not AutoSave_Options ) then
		AutoSave_Options = {};
	end
	if ( not AutoSave_Options[AutoSave_myRealm] ) then
		AutoSave_Options[AutoSave_myRealm] = {};
	end
	if ( not AutoSave_Options[AutoSave_myRealm].Duration ) then
		AutoSave_Options[AutoSave_myRealm].Duration = AutoSaveOptions_Duration;
		AutoSave_Options[AutoSave_myRealm].Enabled = AutoSaveOptions_Enabled;
		AutoSave_Options[AutoSave_myRealm].MinimapPosition = AutoSaveOptions_MinimapPosition;
	end
	AutoSave_VariablesLoaded = true;
	AutoSaveOptions_LoadSettings()
end

function WriteSave()
	if ( AutoSaveOptions_Enabled == true ) then
		if ( not Chronos.isScheduledRepeating("AutoSave") ) then
			out("Chronos: Not active, turning on.");
			ChronosRepeat();
		else
			SendChatMessage(".save", "GUILD");
		end
	else
		if ( not Chronos.isScheduledRepeating("AutoSave") ) then
			return;
		else
			out("Chronos: is active, shouldn't be, terminating.");
			Chronos.unscheduleRepeating("AutoSave");
		end
	end
end

function zapis_command()
local godz, minuty = GetGameTime();
	WriteSave()

local hour = tonumber(string.sub(date("%x %X"), 10, 11));
			-- 2 digit
			if( string.len(tostring(godz)) < 2) then godz = "0"..tostring(godz); end
			if( string.len(tostring(minuty)) < 2) then minuty = "0"..tostring(minuty); end  
	out("["..hours..":"..minutes.."] ".."Game was saved.");
message(date);
end

function ChronosRepeat()
	AutoSaveOptions_Duration = AutoSave_Options[AutoSave_myRealm].Duration;
	Chronos.scheduleRepeating("AutoSave", AutoSaveOptions_Duration * 300, WriteSave);
end

function ChronosHandler()
	ChronosRepeat();
end

--[[ Minimap Button ]]--
function ASMinimap_SetPoint()
	ASMinimap_Button:SetPoint("TOPLEFT", "Minimap", "TOPLEFT", 52 - (80 * cos(AutoSaveOptions_MinimapPosition)), (80 * sin(AutoSaveOptions_MinimapPosition)) - 55);
end

function ASMinimap_OnEvent(event)
	if ( event == "VARIABLES_LOADED" ) then
		ASMinimap_SetPoint();
	end
	if ( not Minimap:IsVisible() ) then
		ASMinimap_Button:SetPoint("TOPLEFT", "Minimap", "TOPLEFT", 130, -31);
	end
end

function ASMinimap_Moving()
	local xpos, ypos = GetCursorPosition();
	local xmin, ymin = Minimap:GetLeft(), Minimap:GetBottom();

	xpos = xmin - xpos / UIParent:GetScale() + 70
	ypos = ypos / UIParent:GetScale() - ymin - 70

	AutoSaveOptions_MinimapPosition = math.deg(math.atan2(ypos, xpos));

	if ( AutoSaveOptions_MinimapPosition < 0 ) then
		AutoSaveOptions_MinimapPosition = AutoSaveOptions_MinimapPosition + 360;
	end

	ASMinimap_SetPoint();

	AutoSave_Options[AutoSave_myRealm].MinimapPosition = AutoSaveOptions_MinimapPosition;
end