﻿--[[
Changelog:
    Version 1.0.1
        Updated TOC Version
        Updated SilvanasAddonLib

    Version 1.0.0
		First fully woking version

Known Bugs:
    checkboxews are located in a wrong way so scaling the ui will case it tobe misplaced

Todo:
    ^^ fix that litle bug
--]]

--main global var
AutoReputationBar = {
	["NAME"] 				= "|cFF3366FFAuto Reputation Bar|r",
	["VERSION"] 			= "(|cFF9900001|cFFFFFFFF.|cFF9900000|cFFFFFFFF.|cFF9900001|cFFFFFFFF)|r",
}
--

--other vars
local AutoReputationBar_ColapsedList = {}
--

--event array
local AutoReputationBarEventArray = {}
function AutoReputationBar_Event(event,...) AutoReputationBarEventArray[event](...) end
--

-------------------
--event triggered--
-------------------
--onload
function AutoReputationBar_Load(self)
	--register events
	AutoReputationBarEventArray = {
		["VARIABLES_LOADED"]                = AutoReputationBar_Event_Variables_Loaded,
        ["COMBAT_TEXT_UPDATE"]              = AutoReputationBar_Event_Combat_Text_Update,
	}
    Silvanas.RegisterEvents(self,AutoReputationBarEventArray)
end

---on event
function AutoReputationBar_Event_Variables_Loaded()
	---relaod saved vars
	--if the saved var didnt load then set it whit default setting esle we assume all setting to exist
	if (not AutoReputationBar_SavedVars) or (not AutoReputationBar_SavedVars["VERSION"]) or (AutoReputationBar_SavedVars["VERSION"] ~= AutoReputationBar["VERSION"]) then
        AutoReputationBar_SavedVars = {
            ["ENABLED"] 	= true,
            ["ACTIVEONLY"]  = false,
            ["VERSION"]     = AutoReputationBar["VERSION"]
        }
    end
    
    --build up the buttons that show up in the reputation tab
    local frame,frame2,framet,frame2t
    
    --enable button
    frame = CreateFrame("CheckButton","AutoReputationBar_Interface_Button_Enable",ReputationFrame) 
    frame:SetWidth(20)
    frame:SetHeight(20)
    frame:SetFrameStrata("HIGH")
    frame:SetChecked(AutoReputationBar_SavedVars["ENABLED"])
    frame:RegisterForClicks("LeftButtonUp")
    frame:SetScript("OnClick",function(self,button) AutoReputationBar_Interface_Button_Enable_Clicked(self); end)
    frame:SetNormalTexture("Interface\\Buttons\\UI-CheckBox-Up")
    frame:SetPushedTexture("Interface\\Buttons\\UI-CheckBox-Down")
    frame:SetHighlightTexture("Interface\\Buttons\\UI-CheckBox-Highlight")
    frame:SetCheckedTexture("Interface\\Buttons\\UI-CheckBox-Check")
    --frame:SetDisabledCheckedTexture("Interface\\Buttons\\UI-CheckBox-Check-Disabled")
    frame:SetTextColor(0.2,0.4,0.8)
    frame:SetHighlightTextColor(1,0.8,0.2)
    frame:SetTextFontObject("GameFontHighlight")
    frame:SetText("Enable AutoReputationBar")
    frame:SetPoint("TOPLEFT",ReputationFrame,"TOPLEFT",72,-32)
    framet = frame:GetFontString()
    framet:SetJustifyH("RIGHT")
    framet:SetPoint("TOPRIGHT",frame,"TOPLEFT",184,-2)
    
    --active only button
    frame2 = CreateFrame("CheckButton","AutoReputationBar_Interface_Button_ActiveOnly",ReputationFrame) 
    frame2:SetWidth(20)
    frame2:SetHeight(20)
    frame2:SetFrameStrata("HIGH")
    frame2:SetChecked(AutoReputationBar_SavedVars["ACTIVEONLY"])
    frame2:RegisterForClicks("LeftButtonUp")
    frame2:SetScript("OnClick",function(self,button) AutoReputationBar_Interface_Button_ActiveOnly_Clicked(self); end)
    frame2:SetNormalTexture("Interface\\Buttons\\UI-CheckBox-Up")
    frame2:SetPushedTexture("Interface\\Buttons\\UI-CheckBox-Down")
    frame2:SetHighlightTexture("Interface\\Buttons\\UI-CheckBox-Highlight")
    --frame2:SetDisabledCheckedTexture("Interface\\Buttons\\UI-CheckBox-Check-Disabled")
    frame2:SetCheckedTexture("Interface\\Buttons\\UI-CheckBox-Check")
    frame2:SetTextColor(0.2,0.4,0.8)
    frame2:SetHighlightTextColor(1,0.8,0.2)
    frame2:SetDisabledTextColor(0.7,0.7,0.7)
    frame2:SetTextFontObject("GameFontHighlight")
    frame2:SetText("Switch to active factions only")
    frame2:SetPoint("TOPLEFT",frame,"TOPLEFT",0,-13)
    frame2t = frame2:GetFontString()
    frame2t:SetJustifyH("RIGHT")
    frame2t:SetPoint("TOPRIGHT",frame2,"TOPLEFT",204,-2)
    
    --loaded message
	Silvanas.Print(AutoReputationBar["NAME"] .." |cFFFFFFFFBy: ".. Silvanas.Author .." |cFFFFFFFFversion: ".. AutoReputationBar["VERSION"] .." |cFFFFFFFFloaded.|r")
end

function AutoReputationBar_Event_Combat_Text_Update(updatetype,updatefaction)
    --see if we are updating a faction
    if updatetype == "FACTION" then
        
        --see if we got the addon enabled
        if AutoReputationBar_SavedVars["ENABLED"] then
            
            --if we are not already watcinh that faction
            if updatefaction ~= GetWatchedFactionInfo() then
                --try to switch the bar
                AutoReputationBar_SetBar(updatefaction)
                
                --if we open an headers lets now close them
                if next(AutoReputationBar_ColapsedList) then
                    local factionID
                    
                    --close any colapsed headers
                    for factionID=1,GetNumFactions() do
                        --if the faction name is in out list then close it
                        if AutoReputationBar_ColapsedList[GetFactionInfo(factionID)] then
                            CollapseFactionHeader(factionID)
                        end
                    end                   
                    
                    --reset the list of closed headers
                    AutoReputationBar_ColapsedList = {}
                end
            end
        end
    end
end
--------------------
--------------------
--------------------

-----------------------
--Switching Functions--
-----------------------
function AutoReputationBar_SetBar(faction)
    local x,factionID,factionName,factionHeader,factionWatched,factionColapsed,NumFactions
    
    --parse default nr of items
    NumFactions = GetNumFactions()
    
    --go over each faction to find the ID nummer
    --set first fiction id
    factionID = 1
    while factionID <= NumFactions do
        --get factions name
        factionName,x,x,x,x,x,x,x,factionHeader,factionColapsed,factionWatched  = GetFactionInfo(factionID)
        
        --only contine if its not already watched
        if not factionWatched then
      
            --only contine if not a header
            if factionHeader then
            
                --if its closed then open it
                if factionColapsed then
                                
                    --open header
                    ExpandFactionHeader(factionID)
                    
                    --recalc the number of factions
                    NumFactions = GetNumFactions()
                    
                    --store header name to close it later
                    AutoReputationBar_ColapsedList[factionName] = true
                end
            else
                --option only show active factions
                if (AutoReputationBar_SavedVars["ACTIVEONLY"] and IsFactionInactive(factionID)) then break; end
                                
                --now lets see if its the correct name
                if factionName == faction then
                                            
                    --oke let set the bar
                    SetWatchedFactionIndex(factionID)
                    
                    --stop function
                    return
                end
            end
        end
        factionID = factionID + 1
    end
end
-----------------------
-----------------------
-----------------------

-------------
--interface--
-------------
function AutoReputationBar_Interface_Button_Enable_Clicked(self)
    --if we got the addon enabled or not
    if AutoReputationBar_SavedVars["ENABLED"] then
        --switch addon off
        AutoReputationBar_SavedVars["ENABLED"] = false
        --disable active only
        AutoReputationBar_Interface_Button_ActiveOnly:Disable()
    else
        --switch addon on
        AutoReputationBar_SavedVars["ENABLED"] = true
        --enable active only
        AutoReputationBar_Interface_Button_ActiveOnly:Enable()
    end
end

function AutoReputationBar_Interface_Button_ActiveOnly_Clicked(self)
    --toggle activeonly
    AutoReputationBar_SavedVars["ACTIVEONLY"] = not AutoReputationBar_SavedVars["ACTIVEONLY"]
end
-------------
-------------
-------------