assert (AutoFIR, "could not find AutoFIR module")

local L = Rock("LibRockLocale-1.0"):GetTranslationNamespace("AutoFIR")

local addonName = "LeaderMe"
local module = AutoFIR:NewModule(addonName)
local self = module

self.name = addonName

self:SetModuleOptions({ 
	type = "group",
	name = self.name,
	desc = string.format(L["%s config"], self.name),
	handler = self,
	order = 10,
	args = {
		whenafk	= {
			type = "boolean",
			name = L["Only accept when AFK."],
			desc = L["Only accept when AFK."],
			get = "GetValue",
			set = "ToggleValue",
			passValue = "acceptonlyafk",
			order = 100,
		},
	} 
})
self:RemoveDefaultModuleOptions("friends")
self:RemoveDefaultModuleOptions("guild")
self:RemoveDefaultModuleOptions("raid")

function module:OnInitialize()
		self.db = AutoFIR:GetDatabaseNamespace(addonName)
		
		AutoFIR:SetDatabaseNamespaceDefaults(addonName, "char", {
			["friends"] = true,
			["guild"] = true,
			["party"] = true,
			["raid"] = true,
			["acceptonlyafk"] = false,
		})
end


function module:OnEnable()
	AutoFIR:Print(string.format(L["%q enabled"], self.name))
end

function module:OnDisable()
    AutoFIR:Print(string.format(L["%q disabled"], self.name))
end

function module:PerformCommand(arg1, ...)
	if (arg1 == UnitName("player")) then
		return
	end
	
	local accept, from = AutoFIR:CheckSender(arg1, self.db.char)
	if accept and self.db.char.acceptonlyafk then
		accept = UnitIsAFK("player")
		
		if not accept then
			AutoFIR:InformSender(arg1, L["Command LeaderMe disabled while not AFK."])
		end
	end
	
	local num = 0;
	for i=1, GetNumPartyMembers() do
		if UnitIsPartyLeader("party"..i) then
			num = i
			break
		end
	end
	
	if accept then
		if IsPartyLeader() and (GetNumPartyMembers() > 0) then
			PromoteToLeader(arg1)
			AutoFIR:InformSender(arg1, L["Your leadership request has been accepted."])
		else
			if num > 0 then
				AutoFIR:InformSender(arg1, string.format(L["Sorry, I'm not leader and request forwarding to %s failed."], UnitName("party"..num)))
			end
		end
	end
end

function module:GetHelp()
	return L["Request party leadership."]
end

function module:Service()
	if UnitIsPartyLeader("player") then
		return "group"
	else
		return nil
	end
end
