assert (AutoFIR, "could not find AutoFIR module")

local L = Rock("LibRockLocale-1.0"):GetTranslationNamespace("AutoFIR")

local addonName = "InviteMe"
local module = AutoFIR:NewModule(addonName)
local self = module

self.name = addonName

self:SetModuleOptions({ 
	type = "group",
	name = self.name,
	desc = string.format(L["%s config"], self.name),
	handler = self,
	order = 10,
	args = {
		whenafk	= {
			type = "boolean",
			name = L["Only accept when AFK."],
			desc = L["Only accept when AFK."],
			get = "GetValue",
			set = "ToggleValue",
			passValue = "acceptonlyafk",
			order = 100,
		},
	} 
})
self:RemoveDefaultModuleOptions("party")
self:RemoveDefaultModuleOptions("raid")

function module:OnInitialize()
		self.db = AutoFIR:GetDatabaseNamespace(addonName)
		
		AutoFIR:SetDatabaseNamespaceDefaults(addonName, "char", {
			["friends"] = true,
			["guild"] = true,
			["party"] = true,
			["raid"] = true,
			["acceptonlyafk"] = false,
		})
end


function module:OnEnable()
	AutoFIR:Print(string.format(L["%q enabled"], self.name))
end

function module:OnDisable()
    AutoFIR:Print(string.format(L["%q disabled"], self.name))
end

function module:PerformCommand(arg1, ...)
	if (arg1 == UnitName("player")) then
		return
	end
	
	local accept, from = AutoFIR:CheckSender(arg1, self.db.char)
	if accept and self.db.char.acceptonlyafk then
		accept = UnitIsAFK("player")
		
		if not accept then
			AutoFIR:InformSender(arg1, L["Command InviteMe disabled while not AFK."])
		end
	end
	
	if accept then
		if IsPartyLeader() or (GetNumPartyMembers() == 0) then
			InviteUnit(arg1)
			AutoFIR:InformSender(arg1, L["Your invitation request has been accepted."])
		else
			for i=1, GetNumPartyMembers() do
				if UnitIsPartyLeader("party"..i) then
					AutoFIR:InformSender(arg1, string.format(L["Sorry, I'm not leader, rerequest to %s."], UnitName("party"..i)))
					break
				end
			end
		end
	end
end

function module:GetHelp()
	return L["Request invitation."]
end

function module:Service()
	return "guild"
end
