assert (AutoFIR, "could not find AutoFIR module")

local L = Rock("LibRockLocale-1.0"):GetTranslationNamespace("AutoFIR")

local addonName = "FollowSomeone"
local module = AutoFIR:NewModule(addonName)
local follower = nil
local self = module

self.name = addonName

self:SetModuleOptions({ 
	type = "group",
	name = self.name,
	desc = string.format(L["%s config"], self.name),
	handler = self,
	order = 10,
	args = {
		whenafk	= {
			type = "boolean",
			name = L["Only accept when AFK."],
			desc = L["Only accept when AFK."],
			get = "GetValue",
			set = "ToggleValue",
			passValue = "acceptonlyafk",
			order = 100,
		},
	} 
})

function module:OnInitialize()
		self.db = AutoFIR:GetDatabaseNamespace(addonName)
		
		AutoFIR:SetDatabaseNamespaceDefaults(addonName, "char", {
			["friends"] = true,
			["guild"] = true,
			["party"] = true,
			["raid"] = true,
			["acceptonlyafk"] = false,
		})
end


function module:OnEnable()
    self:AddEventListener("AUTOFOLLOW_BEGIN")
	self:AddEventListener("AUTOFOLLOW_END")
	
	AutoFIR:RegisterCommandAlias("fsome", self.name)
	AutoFIR:RegisterCommandAlias("ffs", self.name)

	AutoFIR:Print(string.format(L["%q enabled"], self.name))
end

function module:OnDisable()
	self:RemoveEventListener("AUTOFOLLOW_BEGIN")
	self:RemoveEventListener("AUTOFOLLOW_END")
	
	AutoFIR:UnregisterCommandAlias("fsome", self.name)
	AutoFIR:UnregisterCommandAlias("ffs", self.name)
	
    AutoFIR:Print(string.format(L["%q disabled"], self.name))
end

function module:AUTOFOLLOW_BEGIN()
	follower = arg1
end

function module:AUTOFOLLOW_END()
	follower = nil
end

local function GetUnitFromName(player)
	local unit = nil
	for i=1, GetNumPartyMembers() do
		if player:lower() == UnitName("party"..i):lower() then
			if unit == nil then
				unit = "party" .. i
			end
			break
		end
	end
	
	-- Raid Check
	for i=1, GetNumRaidMembers() do
		if player:lower() == UnitName("raid"..i):lower() then
			if unit == nil then
				unit = "raid" .. i
			end
			break
		end
	end
	
	return unit
end

function module:PerformCommand(sender, follow)
	if (sender == UnitName("player")) then
		return
	end

	local accept, from, unit = AutoFIR:CheckSender(sender, self.db.char)
	local followUnit = GetUnitFromName(follow)
	
	if accept and self.db.char.acceptonlyafk then
		accept = UnitIsAFK("player")
		
		if not accept then
			AutoFIR:InformSender(sender, L["Command FollowSomeone disabled while not AFK."])
		end
	end
	
	if accept and (unit == nil or followUnit == nil) then
		 AutoFIR:InformSender(sender, L["You're not allowed to make me follow anyone, because You or the target are neither my party nor my raid."])
		 return
	end

	if accept then
	    if follower ~= nil and follower:lower() == sender:lower() then
    		if CheckInteractDistance(followUnit, 4) == nil then
    			AutoFIR:InformSender(sender, (L["Can't follow %s. Come closer to %s please!"]):format(follow, follow))
    		else
    			FollowUnit(followUnit)
    			AutoFIR:InformSender(sender, (L["I'm following %s."]):format(follow))
    		end
	    else
	        local f = "nobody"
	        if follower ~= nil then
	            f = follower
	        end
	            
	        AutoFIR:InformSender(sender, (L["I follow %s, You can't control me before I follow you."]):format(f))
	    end		
	end
end

function module:GetHelp()
	return L["Makes caller to follow someone, works only if I formerly follow the caller."]
end

function module:Service()
	-- return type (eg guild, group), Unit (optional)
	return "group", "target"
end
