assert (AutoFIR, "could not find AutoFIR module")

local L = Rock("LibRockLocale-1.0"):GetTranslationNamespace("AutoFIR")

local addonName = "FollowMe"
local module = AutoFIR:NewModule(addonName)
local self = module

self.name = addonName

self:SetModuleOptions({ 
	type = "group",
	name = self.name,
	desc = string.format(L["%s config"], self.name),
	handler = self,
	order = 10,
	args = {
		whenafk	= {
			type = "boolean",
			name = L["Only accept when AFK."],
			desc = L["Only accept when AFK."],
			get = "GetValue",
			set = "ToggleValue",
			passValue = "acceptonlyafk",
			order = 100,
		},
	} 
})

function module:OnInitialize()
		self.db = AutoFIR:GetDatabaseNamespace(addonName)
		
		AutoFIR:SetDatabaseNamespaceDefaults(addonName, "char", {
			["friends"] = true,
			["guild"] = true,
			["party"] = true,
			["raid"] = true,
			["acceptonlyafk"] = false,
		})
end


function module:OnEnable()
	AutoFIR:RegisterCommandAlias("follow", self.name)
	AutoFIR:RegisterCommandAlias("ff", self.name)
	
	AutoFIR:Print(string.format(L["%q enabled"], self.name))
end

function module:OnDisable()
	AutoFIR:UnregisterCommandAlias("follow")
	AutoFIR:UnregisterCommandAlias("ff", self.name)

	AutoFIR:Print(string.format(L["%q disabled"], self.name))
end

function module:PerformCommand(arg1, ...)
	if (arg1 == UnitName("player")) then
		return
	end

	local accept, from, unit = AutoFIR:CheckSender(arg1, self.db.char)
	if accept and self.db.char.acceptonlyafk then
		accept = UnitIsAFK("player")
		
		if not accept then
			AutoFIR:InformSender(arg1, L["Command FollowMe disabled while not AFK."])
		end
	end
	
	if accept and unit == nil then
		 AutoFIR:InformSender(arg1, L["You're not allowed to make me follow You, because You're neither my party nor my raid."])
		 return
	end

	if accept then
		if CheckInteractDistance(arg1, 4) == nil then
			AutoFIR:InformSender(arg1, L["Can't follow You. Come closer please!"])
		else
			FollowUnit(unit)
			AutoFIR:InformSender(arg1, L["I'm following You."])
		end
	end
end

function module:GetHelp()
	return L["Make someone follow You."]
end

function module:Service()
	return "group"
end
