assert (AutoFIR, "could not find AutoFIR module")

local L = Rock("LibRockLocale-1.0"):GetTranslationNamespace("AutoFIR")

local addonName = "AutoSummon"
local module = AutoFIR:NewModule(addonName)
local self = module

self.name = addonName

self:SetModuleOptions({ 
	type = "group",
	name = self.name,
	desc = string.format(L["%s config"], self.name),
	handler = self,
	order = 10,
	args = {
		whenafk	= {
			type = "boolean",
			name = L["Only accept when AFK."],
			desc = L["Only accept when AFK."],
			get = "GetValue",
			set = "ToggleValue",
			passValue = "acceptonlyafk",
			order = 100,
		},
		delay = {
			type = "number",
			name = L["Delay for automated accepts."],
			desc = L["Delay for automated accepts."],
			min = 0,
			max = 60,
			step = 1,
			get = function() return self.db.char.delay end,
			set = function(v) self.db.char.delay=v end,
			order = 101,
		},
	} 
})

function module:OnInitialize()
		self.db = AutoFIR:GetDatabaseNamespace(addonName)
		
		AutoFIR:SetDatabaseNamespaceDefaults(addonName, "char", {
			["friends"] = true,
			["guild"] = true,
			["party"] = true,
			["raid"] = true,
			-- delay: time to accept invite
			--           0 = no timer, X time to trigger event auto-accept
			["delay"] = 10,
			["acceptonlyafk"] = false,
		})
end


function module:OnEnable()
	-- register Resurrect Request
	self:AddEventListener("CONFIRM_SUMMON", "SummonRequest")
    self:AddEventListener("CANCEL_SUMMON", "CancelSummon")

	AutoFIR:Print(string.format(L["%q enabled"], self.name))
end

function module:OnDisable()
	self:RemoveEventListener("CONFIRM_SUMMON")
	self:RemoveEventListener("CANCEL_SUMMON")
	
	if self:HasTimer("ScheduledSummon") then
		self:RemoveTimer("ScheduledSummon")
	end
    AutoFIR:Print(string.format(L["%q disabled"], self.name))
end

module.SummonRequest = function(self, namespace, event, arg1, ...)
	
	local accept, from = AutoFIR:CheckSender(arg1, self.db.char)
	if accept and self.db.char.acceptonlyafk then
		accept = UnitIsAFK("player")
	end
	
	if accept then
		if UnitAffectingCombat("player") then
			return
		else
			local delay = tonumber(self.db.char.delay)
			
			if delay ~= nil and delay > 0 then
				self:AddTimer("ScheduledSummon", delay, "AcceptSummon", arg1)
			else
				self:AcceptSummon(arg1)
			end
		end
	end
end

module.CancelSummon = function(self, namespace, event)
	if self:HasTimer("ScheduledSummon") then
		self:RemoveTimer("ScheduledSummon")
	end
end	

function module:AcceptSummon(requester)
	ConfirmSummon()
	StaticPopup_Hide("CONFIRM_SUMMON") 
	
	AutoFIR:InformSender(requester, L["Your summoning has been accepted automatically."]) 
end