assert (AutoFIR, "could not find AutoFIR module")

local L = Rock("LibRockLocale-1.0"):GetTranslationNamespace("AutoFIR")

local addonName = "AutoResurrect"
local module = AutoFIR:NewModule(addonName)
local self = module

self.name = addonName

self:SetModuleOptions({ 
	type = "group",
	name = self.name,
	desc = string.format(L["%s config"], self.name),
	handler = self,
	order = 10,
	args = {
		whenafk	= {
			type = "boolean",
			name = L["Only accept when AFK."],
			desc = L["Only accept when AFK."],
			get = "GetValue",
			set = "ToggleValue",
			passValue = "acceptonlyafk",
			order = 100,
		},
		delayincombat = {
			type = "boolean",
			name = L["Resurrection delay, if party is in combat."],
			desc = L["Resurrection delay, if party is in combat."],
			get = "GetValue",
			set = "ToggleValue",
			passValue = "delayincombat",
			order = 100,
		},
		delay = {
			type = "number",
			name = L["Delay for automated accepts."],
			desc = L["Delay for automated accepts."],
			min = 0,
			max = 60,
			step = 1,
			get = function() return self.db.char.delay end,
			set = function(v) self.db.char.delay=v end,
			order = 101,
		},
	} 
})

function module:OnInitialize()
		self.db = AutoFIR:GetDatabaseNamespace(addonName)
		
		AutoFIR:SetDatabaseNamespaceDefaults(addonName, "char", {
			["friends"] = true,
			["guild"] = true,
			["party"] = true,
			["raid"] = true,
			-- delay: time to accept invite
			--           0 = no timer, X time to trigger event auto-accept
			["delay"] = 0,
			["acceptonlyafk"] = false,
			-- for later use, instantly resurrect, when player is dead
			-- and group is not in battle
			["delayincombat"] = false
		})
end


function module:OnEnable()
	-- register Resurrect Request
	self:AddEventListener("RESURRECT_REQUEST", "ResurrectRequest")
	self:AddEventListener("PLAYER_UNGHOST", "CancelRequest")

	AutoFIR:Print(string.format(L["%q enabled"], self.name))
end

function module:OnDisable()
	self:RemoveEventListener("RESURRECT_REQUEST")
	self:RemoveEventListener("PLAYER_UNGHOST")
	
	if self:HasTimer("ScheduledResurrect") then
		self:RemoveTimer("ScheduledResurrect")
	end
    AutoFIR:Print(string.format(L["%q disabled"], self.name))
end

module.ResurrectRequest = function(self, namespace, event, arg1, ...)
	local accept, from = AutoFIR:CheckSender(arg1, self.db.char)
	if accept and self.db.char.acceptonlyafk then
		accept = UnitIsAFK("player")
	end
	
	if accept then
		local delay = tonumber(self.db.char.delay)
		local combat = false
		
		for i=1, GetNumPartyMembers() do
			if UnitAffectingCombat("party"..i) then
				combat = true
			end
		end
		
		if not combat then
			self:AcceptRes(arg1)
		else
			if delay ~= nil and delay > 0 then
				self:AddTimer("ScheduledResurrect", delay, "AcceptRes", arg1)
			else
				self:AcceptRes(arg1)
			end
		end
	end
end

module.CancelRequest = function(self, namespace, event)
		
	if self:HasTimer("ScheduledResurrect") then
		self:RemoveTimer("ScheduledResurrect")
	end
		
	StaticPopup_Hide("RESURRECT") 
	StaticPopup_Hide("RESURRECT_NO_SICKNESS")
	StaticPopup_Hide("RESURRECT_NO_TIMER")
end

function module:AcceptRes(requester)
	AcceptResurrect()
	StaticPopup_Hide("RESURRECT") 
	StaticPopup_Hide("RESURRECT_NO_SICKNESS")
	StaticPopup_Hide("RESURRECT_NO_TIMER")
	
	AutoFIR:InformSender(requester, L["Your ressurection has been accepted automatically."]) 
end