assert (AutoFIR, "could not find AutoFIR module")

local L = Rock("LibRockLocale-1.0"):GetTranslationNamespace("AutoFIR")
local C = Rock("LibCrayon-3.0")

local addonName = "AutoMessageAFK"
local module = AutoFIR:NewModule(addonName)
local self = module

self.name = addonName

self:SetModuleOptions({ 
	type = "group",
	name = self.name,
	desc = string.format(L["%s config"], self.name),
	handler = self,
	order = 10,
	args = {
		receivemsg	= {
			type = "boolean",
			name = L["Receive AFK/DND messages."],
			desc = L["Receive AFK/DND messages."],
			get = "GetValue",
			set = "ToggleValue",
			passValue = "receivemsg",
			order = 100,
		},
		sendmsg	= {
			type = "boolean",
			name = L["Send AFK/DND messages."],
			desc = L["Send AFK/DND messages."],
			get = "GetValue",
			set = "ToggleValue",
			passValue = "sendmsg",
			order = 101,
		},
		uierrorframe = {
			type = "boolean",
			name = L["Sends Message thru WoW UIErrorFrame."],
			desc = L["Sends Message thru WoW UIErrorFrame."],
			get = "GetValue",
			set = "ToggleValue",
			passValue = "uierrorframe",
			order = 101,
		},
	} 
})
-- remove default-opts friends and raid, we are not in a group or raid
self:RemoveDefaultModuleOptions("friends")
self:RemoveDefaultModuleOptions("guild")
self:RemoveDefaultModuleOptions("party")
self:RemoveDefaultModuleOptions("raid")

function module:OnInitialize()
	self.db = AutoFIR:GetDatabaseNamespace(addonName)
	
	AutoFIR:SetDatabaseNamespaceDefaults(addonName, "char", {
		["friends"] = true,
		["guild"] = true,
		["party"] = true,
		["raid"] = true,
		
		["sendmsg"] = true,
		["receivemsg"] = true,
		["uierrorframe"] = false,
	})
end

function module:OnEnable()
	self:AddEventListener("PLAYER_FLAGS_CHANGED", "FlagsChanged")

	AutoFIR:Print(string.format(L["%q enabled"], self.name))
	self:SetCommPrefix("ATm")
end

function module:OnDisable()
	self:RemoveEventListener("PLAYER_FLAGS_CHANGED")
	
    AutoFIR:Print(string.format(L["%q disabled"], self.name))
end

function module:PerformCommand(sender, msg)
	
	if (sender == UnitName("player")) then
		return
	end
	
	local accept, from = AutoFIR:CheckSender(sender, self.db.char)
	if accept and self.db.char.receivemsg then
		if self.db.char.uierrorframe then
			UIErrorsFrame:AddMessage(string.format(L["(Guild Message) %s is now %s"], sender, msg), 0.92, 0.15, 0.21, 1.0, UIERRORS_HOLD_TIME)
		end
		
		Rock("LibRockConsole-1.0"):Print(C:Purple(string.format(L["(Guild Message) %s is now %s"], sender, msg)))
	end
end

module.FlagsChanged = function (self, namespace, event, arg1, ...)
	
	if self.db.char.sendmsg then
		local afk = UnitIsAFK("player") or false
		local dnd = UnitIsDND("player") or false
		
		if afk then
			self:SendCommMessage("GUILD"
								,"PERFORM_COMMAND"
								,"AutoMessageAFK"
								,"AFK")
		end
		if dnd then
			self:SendCommMessage("GUILD"
								,"PERFORM_COMMAND"
								,"AutoMessageAFK"
								,"DND")
		end
	end
end
