assert (AutoFIR, "could not find AutoFIR module")

local L = Rock("LibRockLocale-1.0"):GetTranslationNamespace("AutoFIR")

local addonName = "AutoInvite"
local module = AutoFIR:NewModule(addonName)
local self = module

self.name = addonName

self:SetModuleOptions({ 
	type = "group",
	name = self.name,
	desc = string.format(L["%s config"], self.name),
	handler = self,
	order = 10,
	args = {
		whenafk	= {
			type = "boolean",
			name = L["Only accept when AFK."],
			desc = L["Only accept when AFK."],
			get = "GetValue",
			set = "ToggleValue",
			passValue = "acceptonlyafk",
			order = 100,
		},
		delay = {
			type = "number",
			name = L["Delay for automated accepts."],
			desc = L["Delay for automated accepts."],
			min = 0,
			max = 60,
			step = 1,
			get = function() return self.db.char.delay end,
			set = function(v) self.db.char.delay=v end,
			order = 101,
		},
	} 
})
-- remove default-opts friends and raid, we are not in a group or raid
self:RemoveDefaultModuleOptions("party")
self:RemoveDefaultModuleOptions("raid")

function module:OnInitialize()
	self.db = AutoFIR:GetDatabaseNamespace(addonName)
	
	AutoFIR:SetDatabaseNamespaceDefaults(addonName, "char", {
		["friends"] = true,
		["guild"] = true,
		["party"] = true,
		["raid"] = true,
		-- delay: time to accept invite
		--           0 = no timer, X time to trigger event auto-accept
		["delay"] = 10,
		["acceptonlyafk"] = false,
	})
end

function module:OnEnable()
	self:AddEventListener("PARTY_INVITE_REQUEST", "InviteRequest")
	self:AddEventListener("PARTY_INVITE_CANCEL", "CancelRequest")

	AutoFIR:Print(string.format(L["%q enabled"], self.name))
end

function module:OnDisable()
	self:RemoveEventListener("PARTY_INVITE_REQUEST")
	self:RemoveEventListener("PARTY_INVITE_CANCEL")
	
	if self:HasTimer("ScheduledInvite") then
		self:RemoveTimer("ScheduledInvite")
	end
    AutoFIR:Print(string.format(L["%q disabled"], self.name))
end

module.InviteRequest = function (self, namespace, event, arg1, ...)
	
	local accept, from = AutoFIR:CheckSender(arg1, self.db.char)
	
	if accept and self.db.char.acceptonlyafk then
		accept = UnitIsAFK("player")
	end
	
	if accept then
		local delay = tonumber(self.db.char.delay)
		if delay ~= nil and delay > 0 then
			self:AddTimer("ScheduledInvite", delay, "AcceptInvite", arg1)
		else
			self:AcceptInvite(arg1)
		end
	end
end

module.CancelRequest = function(self, namespace, event, ...)
		
	if self:HasTimer("ScheduledInvite") then
		self:RemoveTimer("ScheduledInvite")
	end
	
	StaticPopup_Hide("PARTY_INVITE")
end

function module:AcceptInvite(requester)
	if GetNumPartyMembers() == 0 then
		AcceptGroup()
		StaticPopup_Hide("PARTY_INVITE")
		
		-- Group invite accepted
		if GetNumPartyMembers() > 0 then
			AutoFIR:InformSender(requester, L["Your invitation has been accepted automatically."])
		end
	end
end


