assert (AutoFIR, "could not find AutoFIR module")

local L = Rock("LibRockLocale-1.0"):GetTranslationNamespace("AutoFIR")

local addonName = "AutoDeclineDuel"
local module = AutoFIR:NewModule(addonName)
local self = module

self.name = addonName

self:SetModuleOptions({ 
	type = "group",
	name = self.name,
	desc = string.format(L["%s config"], self.name),
	handler = self,
	order = 10,
	args = {} 
})

function module:OnInitialize()
		self.db = AutoFIR:GetDatabaseNamespace(addonName)
		
		AutoFIR:SetDatabaseNamespaceDefaults(addonName, "char", {
			["friends"] = true,
			["guild"] = true,
			["party"] = true,
			["raid"] = true,
		})
end


function module:OnEnable()
	-- register Duel Request
	self:AddEventListener("DUEL_REQUESTED", "DuelRequest")

	AutoFIR:Print(string.format(L["%q enabled"], self.name))
end

function module:OnDisable()
	self:RemoveEventListener("DUEL_REQUESTED")

	AutoFIR:Print(string.format(L["%q disabled"], self.name))
end

module.DuelRequest = function(self, namespace, event, arg1, ...)
	
	local accept, from = AutoFIR:CheckSender(arg1, self.db.char)
	
	-- ok, sender can request a duel, return
	-- player self can decide accept or cancel
	if accept then
		return
	end
	StaticPopup_Hide("DUEL_REQUESTED")
	CancelDuel()
end
