assert("AutoFIR", "could not find AutoFIR module")

AutoFIRFu = Rock:NewAddon("AutoFIRFu", "LibFuBarPlugin-3.0", "LibRockConfig-1.0", "LibRockDB-1.0", "LibRockConsole-1.0", "LibRockComm-1.0") 
local self = AutoFIRFu
local T = Rock("Tablet-2.0")
local C = Rock("LibCrayon-3.0")
local L = Rock("LibRockLocale-1.0"):GetTranslationNamespace("AutoFIR")

self.name = "FuBar - AutoFIR"
self.title = L["AutoFIR"]


AutoFIRFu:SetDatabase("AutoFIRFuBarDB")
AutoFIRFu:SetDatabaseDefaults("profile", {
	showguild = true,
	showgroup = true,
})

local AutoFIR_args = AutoFIR.options
local options = {
	name = L["Fubar_AutoFIR"],
	desc = L["A FuBar Plugin for AutoFIR."],
	type = "group",
	handler = AutoFIRFu,
	args = {
		showguild = {
			type = "boolean",
			name = L["Show available commands from guild members"],
			desc = L["Show available commands from guild members"],
			get = function() return self.db.profile.showguild end,
			set = function(v) self.db.profile.showguild=v end,
			order = 1
		},
		showgroup = {
			type = "boolean",
			name = L["Show available commands from group members"],
			desc = L["Show available commands from group members"],
			get = function() return self.db.profile.showgroup end,
			set = function(v) self.db.profile.showgroup=v end,
			order = 2
		},
	},
}
local expandTab = {}
local addonPrefix = "ATf"

-- set main-args for AutoFIR, so we can configure
-- AutoFIR from the FuBar plugin
options.args["AutoFIR"] = AutoFIR_args

AutoFIRFu:SetConfigTable(options)

AutoFIRFu:SetFuBarOption("iconPath", "Interface\\AddOns\\AutoFIR\\Icons\\icon")
AutoFIRFu:SetFuBarOption("defaultMinimapPosition", 270)
AutoFIRFu:SetFuBarOption("tooltipHiddenWhenEmpty", true)
AutoFIRFu:SetFuBarOption("clickableTooltip", true)
AutoFIRFu:SetFuBarOption("cannotDetachTooltip", true)
AutoFIRFu:SetFuBarOption("tooltipType", "Tablet-2.0")


--[[
	
	  private function set
	
]]
local function GetGroupTypeText()
	if GetNumPartyMembers() > 0 then
		return L["Group Member:"]
	else
		return "|cff9d9d9d" .. L["Solo"]
	end
end

-- prints new version text at the end of the tooltip 
local function DisplayNewVersionText()
	local newVer, ver, player = AutoFIR:NewVersionAvailable()
	if newVer then
		T:AddCategory():AddLine('text', (L["New Version available: %s (%s)"]):format(C:Red(player), C:Red(ver)),
								'size', 8,
		         				'justify', "CENTER")
	end
end

--[[

  public functions here

]]
function AutoFIRFu:OnEnable()
	self:SetCommPrefix(addonPrefix)
	self:UpdateFuBarPlugin()
end

function AutoFIRFu:OnDisable()

end


function AutoFIRFu:OnFuBarClick()
	if AutoFIR:IsActive() then
		if IsControlKeyDown() and IsAltKeyDown() then
			AutoFIR:ToggleActive(false)
		end
	else
		AutoFIR:ToggleActive(true)
	end
	self:UpdateFuBarPlugin()
end 

function AutoFIRFu:OnUpdateFuBarText()
	if AutoFIR:IsActive() then
		self:SetFuBarIcon("Interface\\AddOns\\AutoFIR\\Icons\\icon")
	else
		self:SetFuBarIcon("Interface\\AddOns\\AutoFIR\\Icons\\icondis")
	end

	if self:IsFuBarTextShown() then
		self:SetFuBarText(L["AutoFIR"])
	end
end 

function AutoFIRFu:OnUpdateFuBarTooltip()
	if not AutoFIR:IsActive() then
		return
	end
	
	if self.db.profile.showguild then
		if IsInGuild() and GetNumPartyMembers() == 0 then
			local gCat = T:AddCategory('text', L["Guild"])

			GuildRoster(); --Update the guild list
			for i=1, GetNumGuildMembers() do --for each guild member
				local player, _, _, _, _, _, _, _, online,_ = GetGuildRosterInfo(i)
				if online and player ~= UnitName("player") then
					if expandTab[player] == nil then
						expandTab[player] = false
					end
					self:DisplayGroupPlayerData(gCat, player, "GUILD")
				end
			end
		end
	end

	if self.db.profile.showgroup then
		local pCat = T:AddCategory(
					'text', GetGroupTypeText(),
					'showWithoutChildren', true
					)
	
		for i=1, GetNumPartyMembers() do
			local player = UnitName("party" .. i)
			if expandTab[player] == nil then
				expandTab[player] = false
			end
			self:DisplayGroupPlayerData(pCat, player, "GROUP")
		end
	end
	
	DisplayNewVersionText()
	
	T:SetHint((L["%s to toggle AutoFIR activation."]):format(C:Gold(L["Ctrl-Alt-Click"])))
end 

function AutoFIRFu:ExpandPlayer(player)
	expandTab[player] = not expandTab[player]
end

function AutoFIRFu:DisplayExpandTab(cat, player, tab)
	for command, arg in pairs(tab) do
		if not arg then
			cat:AddLine('text', command,
						'indentation', 20,
						'func', function()
									self:SendCommMessage("WHISPER"
														,player
														,"PERFORM_COMMAND"
														,command)
								end)
		else
			if UnitExists(arg) and UnitIsFriend("player", arg) and UnitIsPlayer(arg) then
				cat:AddLine('text', command .. ' ' .. UnitName(arg),
							'indentation', 20,
							'func', function() 
										self:SendCommMessage("WHISPER"
															,player
															,"PERFORM_COMMAND"
															,command
															,UnitName(arg))
									end)
			end
		end
	end
end

function AutoFIRFu:DisplayGroupPlayerData(cat, player, typ)
	local t = AutoFIR:GetPlayerFuncs(player)
	
	if t == nil or t[typ] == nil then
		cat:AddLine('text', C:Red(player))
	else
		if t["enabled"] == false then
			cat:AddLine('text', C:Silver(player))
		else
			cat:AddLine('text', C:Green(player),
						'child_indentation', 20,
						'showWithoutChildren', true,
						'hideBlankLine', true,
						'func', 'ExpandPlayer', 'arg1', self, 'arg2', player,
						'hasCheck', true,
						'checked', true,
						'checkIcon', not expandTab[player] and "Interface\\Buttons\\UI-PlusButton-Up" or "Interface\\Buttons\\UI-MinusButton-Up"
					)
			if expandTab[player] then
				self:DisplayExpandTab(cat, player, t[typ])
			end
		end
	end
end
