--[[
	Changelog:
	
	02.12.2007: final candidate release, some fixes
	04.12.2007: solve comm problems with FuBar plugin
	11.12.2007: fix problem in FuBar plugin, add forgotten param in UnitIsFriend()
	23.12.2007: fix problems with automatic dependency download
	20.01.2008: fix errors with TabletLib and standalone addon without fubar
	            fix dependencies in embeds.xml
				fix errors in svn:externals tag
	22.02.2008: add new module AutoDeclineDuel
	25.02.2008: add new module AutoMessageAFK (sends a chat or UIErrorFrame message, if 
	                                           a guild mate goes afk or dnd)
    26.02.2008: fix arg error in AutoMessageAFK
]]

local MAJOR_VERSION = "1.0"
local MINOR_VERSION = tonumber(("$Revision: 75198 $"):match("(%d+)")) or 0

AutoFIR = Rock:NewAddon("AutoFIR", "LibRockDB-1.0", "LibRockEvent-1.0", "LibRockConsole-1.0", "LibRockHook-1.0", "LibRockModuleCore-1.0", "LibRockConfig-1.0", "LibRockTimer-1.0", "LibRockComm-1.0");
AutoFIR:SetModuleMixins("LibRockEvent-1.0", "LibRockConsole-1.0", "LibRockHook-1.0", "LibRockTimer-1.0", "LibRockComm-1.0") 

local self = AutoFIR
AutoFIR.version = MAJOR_VERSION .. "r"..MINOR_VERSION
AutoFIR.revision = MINOR_VERSION
AutoFIR.date = ("$Date: 2008-05-26 14:41:33 -0400 (Mon, 26 May 2008) $"):match("%d%d%d%d%-%d%d%-%d%d")

AutoFIR:SetDatabase("AutoFIRDB", "AutoFIRDBPerChar")
AutoFIR:SetDatabaseDefaults("char", {
	showincmsg = false,
	showreplymsg = false,
	replymsgprefix = "[ATF]",
	ffcompat = true,
	global = {
		friends = true,
		guild = true,
		party = true,
		raid = true,
	},
	globallist = {}
})

local L = Rock("LibRockLocale-1.0"):GetTranslationNamespace("AutoFIR")
local chatPrefix = "!atf"
local ffPrefix = "!ff"
local addonPrefix = "ATF"
local fuAddonPrefix = "ATf"
local msgAddonPrefix = "ATm"
local commandAlias = {}
local commTab = {}
local foreignVer = {}

AutoFIR.OnCommReceive = {}
AutoFIR.options = {
	 type = "group"
	,name = L["AutoFIR"]
	,desc = L["This addon automates invites, summons and resurrects, other players can make You follow them and request group invitations"]
	,icon = "Interface\\AddOns\\AutoFIR\\Icons\\icon"
	,handler = AutoFIR
	,args = {
		showinc = {
			type = "boolean",
			name = L["Show incoming requests"],
			desc = L["Show incoming requests"],
			get = function() return self.db.char.showincmsg end,
			set = function(v) self.db.char.showincmsg=v end,
			order = 100
		},
		showout = {
			type = "boolean",
			name = L["Show replies"],
			desc = L["Show replies"],
			get = function() return self.db.char.showreplymsg end,
			set = function(v) self.db.char.showreplymsg=v end,
			order = 101
		},
		prefix = {
			type = "string",
			name = L["Prefix for replies"],
			desc = L["Prefix for replies"],
			usage = "...",
			get = function() return self.db.char.replymsgprefix end,
			set = function(v) self.db.char.replymsgprefix=v end,
			validate = function(v) 
				         if v == nil or #v == 0 then
				         	return false, L["Prefix must not be empty"]
				         else
				         	return true
				         end
					   end, 
			order = 110,
		},
		ffcompat = {
			type = "boolean",
			name = L["enable FollowFelankor compability"],
			desc = L["enable FollowFelankor compability"],
			get = function() return self.db.char.ffcompat end,
			set = function(v) self.db.char.ffcompat=v end,
			order = 120,
		},
		guild = {
			type = "boolean",
			name = string.format(L["%s: accept requests from guild"],L["AutoFIR"]),
			desc = string.format(L["%s: accept requests from guild"],L["AutoFIR"]),
			get = function() return self.db.char.global.guild end,
			set = function(v) self.db.char.global.guild=v end,
			order = 141,
		},
		party = {
			type = "boolean",
			name = string.format(L["%s: accept requests from raid"],L["AutoFIR"]),
			desc = string.format(L["%s: accept requests from raid"],L["AutoFIR"]),
			get = function() return self.db.char.global.party end,
			set = function(v) self.db.char.global.party=v end,
			order = 142,
		},
		raid = {
			type = "boolean",
			name = string.format(L["%s: accept requests from party"],L["AutoFIR"]),
			desc = string.format(L["%s: accept requests from party"],L["AutoFIR"]),
			get = function() return self.db.char.global.raid end,
			set = function(v) self.db.char.global.raid=v end,
			order = 143,
		},
		friends = {
			type = "boolean",
			name = string.format(L["%s: accept requests from friendlist"],L["AutoFIR"]),
			desc = string.format(L["%s: accept requests from friendlist"],L["AutoFIR"]),
			get = function() return self.db.char.global.friends end,
			set = function(v) self.db.char.global.friends=v end,
			order = 144,
		},
		lists = {
			type = "group",
			name = L["Black-/Whitelisting"],
			desc = L["Black-/Whitelisting"],
			order = 100,
			args = {
				showbl = {
					type = "execute",
					name = string.format(L["%s show"], L["Blacklist"]),
					desc = string.format(L["%s show"], L["Blacklist"]),
					func = "ShowGlobalBlacklist",
					order = 110,
				}, 
				showwl = {
					type = "execute",
					name = string.format(L["%s show"], L["Whitelist"]),
					desc = string.format(L["%s show"], L["Whitelist"]),
					func = "ShowGlobalWhitelist",
					order = 111,
				}, 
				addbl = {
					type = "text",
					name = string.format(L["Add player to list"], L["Blacklist"]),
					desc = string.format(L["Add player to list"], L["Blacklist"]),
					usage = "...",
					get = false,
					set = function(v) self:GlobalListAdd(v, 'B') end,
					order = 112,
				}, 
				addwl = {
					type = "text",
					name = string.format(L["Add player to list"], L["Whitelist"]),
					desc = string.format(L["Add player to list"], L["Whitelist"]),
					usage = "...",
					get = false,
					set = function(v) self:GlobalListAdd(v, 'W') end,
					order = 113,
				},
				remove = {
					type = "text",
					name = L["Remove player from list"],
					desc = L["Remove player from list"],
					usage = "...",
					get = false,
					set = function(v) self:GlobalListRemove(v) end,
					order = 113,
				}
			}
		}
	}
}

Rock("LibRockComm-1.0"):AddAddonVersionReceptor(function(player, addon, version)
	if addon == 'AutoFIR' then
		if version and version ~= true then
			local rev = tonumber(version:sub(string.find(version, "r")+1)) or 0
			
			if rev > MINOR_VERSION and
			  (foreignVer["revision"] == nil or foreignVer["revision"] < rev) then
				foreignVer["player"] = player
				foreignVer["version"] = version
				foreignVer["revision"] = rev
			end
		end
	end
end)

--[[
 
	private function set
	
  ]]
local function CheckChatMessage(msg)
	local msg = string.gsub(msg, "_", " ")
	local chatMsg = false
	local cleanMsg
	
	if msg:sub(1, chatPrefix:len()) == chatPrefix then
		cleanMsg = msg:gsub(chatPrefix, "", 1):trim()
		chatMsg = true
	end
	
	if self.db.char.ffcompat and
	   msg:sub(1, ffPrefix:len()) == ffPrefix then
		cleanMsg = msg:gsub(ffPrefix, "", 1):trim()
		chatMsg = true
	end
	
	return chatMsg, cleanMsg
end

local function PerformMessage(sender, msg, msgFromAddon)
	local chk, from = self:CheckSender(sender)
	
	local t = {}
	for v in string.gmatch(msg:trim(), "[^ ]+") do
	  tinsert(t, v)
	end
	local command = tremove(t,1)
		
	if chk then
		if self.db.char.showincmsg and msgFromAddon then
			self:Print(string.format(L["%s sent: %q"], sender, msg))
		end
		
		for name, module in self:IterateModulesWithMethod(true, "PerformCommand") do
			if name:lower() == command:lower() then
				module:PerformCommand(sender, unpack(t))
				return
			end
		end
		-- check command alias table
		if commandAlias[command] ~= nil then
			local mod = commandAlias[command]
			
			if self:HasModule(mod) and self:IsModuleActive(mod) then
				self:GetModule(mod):PerformCommand(sender, unpack(t))
				return
			end
		end
		
		-- when here, command is not correct
		self:InformSenderHelp(sender)
	else	
		if self.db.char.showincmsg then
			self:Print(string.format("%s sent: %q, request ignored.", sender, msg))
		end
	end
end

local function ChatHandler(this, ...)
	if arg1 and arg1~="" then
		local chatMsg,_ = CheckChatMessage(arg1)
		if chatMsg and
		   not self.db.char.showincmsg and
		   event == "CHAT_MSG_WHISPER" then
		   	return
		end

		if (string.sub(arg1,1,string.len(self.db.char.replymsgprefix)) == self.db.char.replymsgprefix and 
			event == "CHAT_MSG_WHISPER_INFORM") then
			return
		end
	end
		
	return self.hooks["ChatFrame_MessageEventHandler"](this, ...)
end

function AutoFIR.OnCommReceive:PERFORM_COMMAND(prefix, distribution, sender, command, target)
	if target == nil then
		PerformMessage(sender, command, true)
	else
		PerformMessage(sender, command .. " " .. target, true)		
	end
end

function AutoFIR.OnCommReceive:AVAILABLE_COMMANDS(prefix, distribution, sender, commands)
	if not commTab[sender] then
		commTab[sender] = {
			["enabled"] = true,
		}
	end
	
	local dist = distribution
	if dist == "WHISPER" then
		dist = "GUILD"
	end
	
	commTab[sender][dist] = commands
	-- send request return to sender with own commands
	if distribution == "GUILD" then
		self:BroadcastServices("WHISPER", sender)
	end
end

function AutoFIR:OnInitialize()
	-- global options set
	self:SetConfigTable(self.options)
	self:SetConfigSlashCommand("/AutoFIR", "/atf")
end
	

function AutoFIR:OnEnable()	
	--hook whisper-events thru our own function
	self:AddHook("ChatFrame_MessageEventHandler", "ChatHandler")

    self:AddEventListener("CHAT_MSG_WHISPER")
    self:AddEventListener("PARTY_MEMBERS_CHANGED")
    self:AddEventListener("PARTY_MEMBER_DISABLE")
	self:AddEventListener("PARTY_MEMBER_ENABLE")
	
	self:AddEventListener("LibRockEvent-1.0", "FullyInitialized")

	-- sets communication prefix
	self:SetCommPrefix(addonPrefix)
	
	-- hook communication
	self:AddCommListener(addonPrefix, "WHISPER")
	self:AddCommListener(addonPrefix, "GROUP")
 	self:AddCommListener(addonPrefix, "GUILD")
 	
	-- communication from AutoMessageAFK
 	self:AddCommListener(msgAddonPrefix, "GUILD")
	
	-- register listener for communication with the fubar-plugin
	self:AddCommListener(fuAddonPrefix, "WHISPER")
	
	self:AddMemoizations("PERFORM_COMMAND", "AVAILABLE_COMMANDS")
end

function AutoFIR:OnDisable()
    -- Called when the addon is disabled
	self:RemoveAllHooks()
    self:RemoveEventListener("CHAT_MSG_WHISPER")
    self:RemoveEventListener("PARTY_MEMBERS_CHANGED")
    self:RemoveEventListener("PARTY_MEMBER_DISABLE")
    self:RemoveEventListener("PARTY_MEMBER_ENABLE")
	
	-- remove registered comm listeners  
	self:RemoveAllCommListeners()
end

function AutoFIR:CHAT_MSG_WHISPER()
	local chatMsg, cleanMsg = CheckChatMessage(arg1) 
	
	if chatMsg then
		PerformMessage(arg2, cleanMsg, false)
	end
end

function AutoFIR:PARTY_MEMBERS_CHANGED()
	self:BroadcastServices("GROUP")
end

function AutoFIR:PARTY_MEMBER_DISABLE()
	-- disable communication tab
	if commTab[arg1] ~= nil then
		commTab[arg1]["enabled"] = false
	end
end

function AutoFIR:PARTY_MEMBER_ENABLE()
 	-- enable communication tab
	if commTab[arg1] ~= nil then
		commTab[arg1]["enabled"] = true
	end
	self:BroadcastServices("GROUP")
end

function AutoFIR:FullyInitialized()
	if IsInGuild() then
		self:BroadcastServices("GUILD")
	end
	
	if GetNumPartyMembers() > 0 then
		self:BroadcastServices("GROUP")
	end
end

function AutoFIR:BroadcastServices(channel, target)
	local ch = channel:upper()
	if ch == nil then
		return
	elseif ch == "WHISPER" then
		ch = "GUILD"
	end
	
	local cTab = {}
	for name, module in self:IterateModulesWithMethod(true, "Service") do
		local typ, arg = module:Service()
		if typ ~= nil and typ:upper() == ch then
			if arg == nil then arg = false end
			cTab[name] = arg
		end
	end
	if channel == "WHISPER" then
		self:SendCommMessage(channel, target, "AVAILABLE_COMMANDS", cTab)
	else
		self:SendCommMessage(channel, "AVAILABLE_COMMANDS", cTab)
		-- checks, if a new version available
		Rock("LibRockComm-1.0"):QueryAddonVersion("AutoFIR", channel)	
	end
end

function AutoFIR:GetPlayerFuncs(player)
	if commTab[player] ~= nil then
		return commTab[player]
	else
		return nil
	end
end

function AutoFIR:CheckSender(sender, addonTab)
	
 	local globTab = self.db.char.global
	
	-- return values
	local retValue, retValueFrom, unit = false, "", nil
	-- local check vars
	local bl, guild, friend, party, raid = nil, false, false, false, false

	-- FIRST and main check, Black-/Whitelisting
	-- t = type of listing (b blacklist, w whitelist)
    -- listing char ist index of array
	local t = self.db.char.globallist[sender]
	if t ~= nil then
		if string.upper(t) == "B" then
			bl = false
		else
		    -- always accept from whitelist
			bl = true
		end
	end

	-- g = guild, p = party, r = raid, f = friend
	local g, p, r, f = globTab.guild, globTab.party, globTab.raid, globTab.friends
	if addonTab ~= nil then
		-- override global settings
		g, p, r, f = addonTab.guild,addonTab.party,addonTab.raid,addonTab.friends
	end
	
	-- Guild Check
	if IsInGuild() then
		GuildRoster(); --Update the guild list
		for i=1, GetNumGuildMembers() do --for each guild member
			local senderName = GetGuildRosterInfo(i); --Get guild member name
			if (senderName == sender) then --If the player is a guild member
				guild = true
				retValueFrom = strjoin(",", retValueFrom, "Guild")
				break
			end
		end
	end
	
	-- Check Friendslist
	ShowFriends()
	for i=1, GetNumFriends() do
		local friendName = GetFriendInfo(i)
		if sender == friendName then
			friend = true
			retValueFrom = strjoin(",", retValueFrom, "Friend")
			break
		end
	end

		-- Party Check
	for i=1, GetNumPartyMembers() do
		if sender == UnitName("party"..i) then
			party = true
			retValueFrom = strjoin(",", retValueFrom, "Party")
			if unit == nil then
				unit = "party" .. i
			end
			break
		end
	end
	
	-- Raid Check
	for i=1, GetNumRaidMembers() do
		if sender == UnitName("raid"..i) then
			raid = true
			retValueFrom = strjoin(",", retValueFrom, "Raid")
			if unit == nil then
				unit = "raid" .. i
			end
			break
		end
	end

	if bl ~= nil and (not bl) then
		return false, "Blocked from BL", nil
	end
		
	if bl then
		return true, "Accept from WL", unit
	end
	
	if (r and raid)   or
	   (p and party)  or
	   (f and friend) or
	   (g and guild)  then
		return true, retValueFrom, unit
	end
	
	return false, "check failed", nil
		
end

function AutoFIR:InformSender(sender, msg)
	local msg = msg
	msg = self.db.char.replymsgprefix .. ': ' .. msg
	
	ChatThrottleLib:SendChatMessage("NORMAL", nil, msg, "WHISPER", nil, sender)
	
	if self.db.char.showreplymsg then
		self:Print(string.format(L["Sent message to %q: %q"], sender, msg))
	end
end

function AutoFIR:InformSenderHelp(sender)

	ChatThrottleLib:SendChatMessage("NORMAL", nil, L["help:"], "WHISPER", nil, sender)
	for name, module in self:IterateModulesWithMethod(true, "GetHelp") do
		ChatThrottleLib:SendChatMessage("NORMAL", nil, name:lower() .. ": " .. module:GetHelp(), "WHISPER", nil, sender)
	end
	ChatThrottleLib:SendChatMessage("NORMAL", nil, string.format(L["Usage: /w %s !atf <command>"], UnitName("player")), "WHISPER", nil, sender)
	
end

function AutoFIR:NewVersionAvailable()
	if foreignVer["revision"] ~= nil and foreignVer["revision"] > MINOR_VERSION then
		return true, foreignVer["version"], foreignVer["player"]
	end
	return false
end
--[[

  function pack for processing black/-whitelisting

  ]]	

local function GlobalList(typeList)
	
	-- Type B == blacklist, W == whitelist
	local tList = typeList
	local tString
	local count = 0
	
	if tList == nil then
		tList = 'B'
	end
	
	if tList == 'B' then
		self:Print(L["Players on blacklist:"])
	else
		self:Print(L["Players on whitelist:"])
	end
	
	for char, tp in pairs(self.db.char.globallist) do
		if tp == tList then
			count = count + 1
			self:Print(char)
		end
	end
	
	if count == 0 then
		self:Print(L["List empty."])
	end
end

--[[ Wrapper for showblacklist ]]
function AutoFIR:ShowGlobalBlacklist()
	GlobalList('B')
end

--[[ Wrapper for showblacklist ]]
function AutoFIR:ShowGlobalWhitelist()
	GlobalList('W')
end

function AutoFIR:GlobalListAdd(player, typeList)
	
	local tList
	
	if typeList == 'B' then
		tList = L["Blacklist"]
	else
		tList = L["Whitelist"]
	end

	self.db.char.globallist[player] = typeList
	self:Print(string.format(L["Player %s added to %s"], player, tList))
end

function AutoFIR:GlobalListRemove(player)
		
	local tList
	
	if self.db.char.globallist[player] ~= nil then

		if self.db.char.globallist[player] == 'B' then
			tList = L["Blacklist"]
		else
			tList = L["Whitelist"]
		end

		self.db.char.globallist[player] = nil
		self:Print(string.format(L["Player %s removed from %s"], player, tList))
	else
		self:Print(string.format(L["Player %q not found on list."], player))
	end
end

function AutoFIR:RegisterCommandAlias(alias, module)
	if alias ~= nil and module ~= nil then
		if commandAlias[alias] ~= nil then
			error(("alias %q defined for module %q"):format(alias, commandAlias[alias]))
		end
		
		commandAlias[alias] = module
	end
end

function AutoFIR:UnregisterCommandAlias(alias)
	commandAlias[alias] = nil
end

--[[
	Module Prototype functions
]]

function AutoFIR.modulePrototype:SetModuleOptions(opts)
	
	local atf_args = AutoFIR.options.args
	local mod_name = self.name

	if not opts.handler then
		opts.handler = self
	end

	--[[
	--	default args for each module, all other can set per opts
	--]]
	add_args = {
		enable = {
			type = "boolean",
			name = string.format(L["%s enable"], mod_name),
			desc = string.format(L["%s enable"], mod_name),
			get = "IsModuleActive",
			set = "ToggleModuleActive",
			handler = AutoFIR,
			passValue = self,
			order = 1,
		},
		guild = {
			type = "boolean",
			name = string.format(L["%s: accept requests from guild"], mod_name),
			desc = string.format(L["%s: accept requests from guild"], mod_name),
			get = "GetValue",
			set = "ToggleValue",
			passValue = "guild",
			order = 10,
		},
		party = {
			type = "boolean",
			name = string.format(L["%s: accept requests from party"], mod_name),
			desc = string.format(L["%s: accept requests from party"], mod_name),
			get = "GetValue",
			set = "ToggleValue",
			passValue = "party",
			order = 11,
		},
		raid = {
			type = "boolean",
			name = string.format(L["%s: accept requests from raid"], mod_name),
			desc = string.format(L["%s: accept requests from raid"], mod_name),
			get = "GetValue",
			set = "ToggleValue",
			passValue = "raid",
			order = 12,
		},
		friends = {
			type = "boolean",
			name = string.format(L["%s: accept requests from friendlist"], mod_name),
			desc = string.format(L["%s: accept requests from friendlist"], mod_name),
			get = "GetValue",
			set = "ToggleValue",
			passValue = "friends",
			order = 13,
		},
	}
	
	for k,v in pairs(add_args) do
		if opts.args[k] == nil then
			opts.args[k] = v
		end
	end
	
	atf_args[mod_name] = opts
end

function AutoFIR.modulePrototype:GetValue(valType)
	return self.db.char[valType]
end

function AutoFIR.modulePrototype:ToggleValue(valType)
	self.db.char[valType] = not self.db.char[valType] 
end

function AutoFIR.modulePrototype:RemoveDefaultModuleOptions(option)
	local atf = AutoFIR.options.args
	local name = self.name
	
	if atf[name].args[option] then
		atf[name].args[option] = nil
	end
end


		