-------------------------------------------------------------------------------
-- AutoBuff FuBar support
-------------------------------------------------------------------------------

if (AceLibrary("AceAddon-2.0") == nil or not IsAddOnLoaded("AutoBuff")) then return; end

local AutoBuff_Fu;
local Tablet;

AutoBuff_FU_ICON_ON = "Interface\\AddOns\\AutoBuff\\ABEnabled.tga";
AutoBuff_FU_ICON_OFF = "Interface\\AddOns\\AutoBuff\\ABDisabled.tga";

Tablet = AceLibrary("Tablet-2.0");
AutoBuff_Fu = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0");
AutoBuff_Fu.hasIcon = AutoBuff_FU_ICON_ON;
AutoBuff_Fu.hasNoColor = true;
AutoBuff_Fu.hasNoText = true;
AutoBuff_Fu.cannotDetachTooltip = true;
AutoBuff_Fu.defaultMinimapPosition = 220;
AutoBuff_Fu.title = "AutoBuffFu";
AutoBuff_Fu.version = "20100-3";
AutoBuff_Fu.name = "AutoBuffFu";
AutoBuff_Fu.category = "Interface";
AutoBuff_Fu.description = "FuBar Support for AutoBuff";

function AutoBuff_Fu:OnInitialize()
  if(FuBar2DB.profiles.Default.detached.AutoBuff) then
    AutoBuff_Fu.hideWithoutStandby = true;
  end
end

function AutoBuff_Fu:OnTooltipUpdate()
  if (Tablet) then
    Tablet:SetHint("|cffeda55fClick|r to open the options interface.");
  end
end

function AutoBuff_Fu:OnClick()
  AutoBuffOptionsButton_OnClick(arg1);
end

function AutoBuff_Fu:OnTextUpdate()
end

function AutoBuff_Fu_SetIcon()
	if (AutoBuff_Fu and AutoBuff_Options) then
    if (not AutoBuff_Data[vC]['e'] == 1) then
      AutoBuff_Fu:SetIcon(AutoBuff_FU_ICON_ON);
	  else
      AutoBuff_Fu:SetIcon(AutoBuff_FU_ICON_OFF);
	  end
	end
end
