local _G = getfenv(0)
local VERSION = tonumber(("$Revision: 71277 $"):match("%d+"))
local L = AceLibrary("AceLocale-2.2"):new("AuldLangSyne_Fu")

local tablet = AceLibrary("Tablet-2.0")
local dewdrop = AceLibrary("Dewdrop-2.0")
local friends = AceLibrary("LibFriends-1.0")
local guild = AceLibrary("LibGuild-1.0")
local roster = AceLibrary("Roster-2.1")

local AuldLangSyne = AuldLangSyne
local Fu
local new, del, newHash, newSet, deepCopy, deepDel, clear
if AuldLangSyne then
	Fu = AuldLangSyne:NewModule("Fu", "AceHook-2.1", "AceEvent-2.0", "FuBarPlugin-2.0")
	if AuldLangSyne.revision < VERSION then
		AuldLangSyne.version = "r" .. VERSION
		AuldLangSyne.revision = VERSION
		AuldLangSyne.date = ("$Date: 2008-04-24 13:24:41 -0400 (Thu, 24 Apr 2008) $"):match("%d%d%d%d%-%d%d%-%d%d")
	end
	new, del, newHash, newSet, deepCopy, deepDel, clear = AuldLangSyne.new, AuldLangSyne.del, AuldLangSyne.newHash, AuldLangSyne.newSet, AuldLangSyne.deepCopy, AuldLangSyne.deepDel, AuldLangSyne.clear
else
	Fu = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceHook-2.1", "AceConsole-2.0", "FuBarPlugin-2.0", "AceDB-2.0")
	AuldLangSyne_Fu = Fu -- since this isn't a module in this branch, global for access
	do
		local list = setmetatable({}, {__mode='k'})
		function new(...)
			local t = next(list)
			if t then
				list[t] = nil
				for i = 1, select('#', ...) do
					t[i] = select(i, ...)
				end
				return t
			else
				return { ... }
			end
		end
		function del(t)
			for k in pairs(t) do
				t[k] = nil
			end
			t[''] = true
			t[''] = nil
			list[t] = true
			return nil
		end
	end
end

Fu.name = "AuldLangSyneFu"
Fu.title = "AuldLangSyneFu"
Fu.clickableTooltip = true
Fu.hasIcon = "Interface\\FriendsFrame\\FriendsFrameScrollIcon"
Fu.hideWithoutStandby = true
Fu.independentProfile = true

function Fu:OnInitialize(name)
	local profiledefaults = {
		friends = {
			show = true,
			showtotal = true,
			sort = 'NAME',
			offline = false,
			columns = {
				name = true,
				level = true,
				class = false,
				zone = true,
				status = true,
				note = true,
			},
			colors = {
				name = 'class',
				level = 'level',
				class = 'class',
				zone = 'none',
			},
		},
		guild = {
			show = true,
			showname = true,
			showtotal = true,
			sort = 'NAME',
			offline = false,
			motd = true,
			columns = {
				name = true,
				level = true,
				class = false,
				zone = true,
				status = true,
				rank = true,
				note = true,
			},
			colors = {
				name = 'class',
				level = 'level',
				class = 'class',
				zone = 'none',
				rank = 'none',
			},
		},
	}
	
	if AuldLangSyne then
		self.db = AuldLangSyne:AcquireDBNamespace("Fu")
		AuldLangSyne:RegisterDefaults("Fu", "profile", profiledefaults)
	else
		self:RegisterDB("AuldLangSyneFuDB")
		self:RegisterDefaults("profile", profiledefaults)
	end
	
	local function makeGetter(kind, option)
		return function(key) return self.db.profile[kind][option][key] end
	end
	local function makeSetter(kind, option)
		return function(key, t) self.db.profile[kind][option][key] = t; self:Update() end
	end
	local function makeColumnsGroup(kind)
		group = {
			type = "group",
			name = L["Columns"], desc = L["Columns"],
			pass = true,
			get = makeGetter(kind, 'columns'),
			set = makeSetter(kind, 'columns'),
			args = {},
		}
		for column in pairs(self.db.profile[kind].columns) do
			group.args[column] = {type="toggle", name=column, desc=column,}
		end
		return group
	end
	local colorChoices = {'class', 'level', 'none'}
	local function makeColorsGroup(kind)
		group = {
			type = "group",
			name = L["Colors"], desc = L["Colors"],
			pass = true,
			get = makeGetter(kind, 'colors'),
			set = makeSetter(kind, 'colors'),
			args = {},
		}
		for column in pairs(self.db.profile[kind].colors) do
			group.args[column] = {type='text', name=column, desc=column, validate=colorChoices,}
		end
		return group
	end
	self.menu = {
		handler = Fu,
		name = "FuBar", type = "group",
		desc = L["FuBar plugin options"],
		args = {
			friends = {
				type = "group",
				name = L["Friends"], desc = L["Friends"],
				args = {
					show = {
						type = 'toggle',
						name = L["Show"], desc = L["Show"],
						get = function() return self.db.profile.friends.show end,
						set = function(t) self.db.profile.friends.show = t; self:Update() end,
						order = 1,
					},
					showtotal = {
						type = 'toggle',
						name = L["Show Total"], desc = L["Show the total in the fubar plugin"],
						get = function() return self.db.profile.friends.showtotal end,
						set = function(t) self.db.profile.friends.showtotal = t; self:Update() end,
						order = 2,
					},
					offline = {
						type = 'toggle',
						name = L["Offline"], desc = L["Offline"],
						get = function() return self.db.profile.friends.offline end,
						set = function(t) self.db.profile.friends.offline = t; self:UpdateTooltip() end,
					},
					sort = {
						type = 'text',
						name = L["Sort"], desc = L["Sort"],
						get = function() return self.db.profile.friends.sort end,
						set = function(t) self.db.profile.friends.sort = t; self:Update() end,
						validate = {'NAME', 'LEVEL', 'ONLINE', 'ZONE', 'CLASS'},
					},
					columns = makeColumnsGroup('friends'),
					colors = makeColorsGroup('friends'),
				},
			},
			guild = {
				type = "group",
				name = L["Guild"], desc = L["Guild"],
				args = {
					show = {
						type = 'toggle',
						name = L["Show"], desc = L["Show"],
						get = function() return self.db.profile.guild.show end,
						set = function(t) self.db.profile.guild.show = t; self:Update() end,
						order = 1,
					},
					showname = {
						type = 'toggle',
						name = L["Show name"], desc = L["Show name"],
						get = function() return self.db.profile.guild.showname end,
						set = function(t) self.db.profile.guild.showname = t; self:Update() end,
						order = 2,
					},
					showtotal = {
						type = 'toggle',
						name = L["Show Total"], desc = L["Show the total in the fubar plugin"],
						get = function() return self.db.profile.guild.showtotal end,
						set = function(t) self.db.profile.guild.showtotal = t; self:Update() end,
						order = 2,
					},
					offline = {
						type = 'toggle',
						name = L["Offline"], desc = L["Offline"],
						get = function() return self.db.profile.guild.offline end,
						set = function(t) self.db.profile.guild.offline = t; self:UpdateTooltip() end,
					},
					motd = {
						type = 'toggle',
						name = L["MotD"], desc = L["Message of the Day"],
						get = function() return self.db.profile.guild.motd end,
						set = function(t) self.db.profile.guild.motd = t; self:Update() end,
					},
					sort = {
						type = 'text',
						name = L["Sort"], desc = L["Sort"],
						get = function() return self.db.profile.guild.sort end,
						set = function(t) self.db.profile.guild.sort = t; self:Update() end,
						validate = {'NAME', 'LEVEL', 'ZONE', 'CLASS', 'RANK'},
					},
					columns = makeColumnsGroup('guild'),
					colors = makeColorsGroup('guild'),
				},
			},
			fubar = {
				type = "group",
				name = "FuBar",
				desc = L["FuBar options"],
				args = AceLibrary("FuBarPlugin-2.0"):GetAceOptionsDataTable(self),
				order = 300,
			},
		},
	}
	
	if AuldLangSyne then
		self.OnMenuRequest = AuldLangSyne.menu
	else
		self.OnMenuRequest = self.menu
	end
	
	self.db.profile.friends.sort = (self.db.profile.friends.sort):upper()
	self.db.profile.guild.sort = (self.db.profile.guild.sort):upper()
end

function Fu:OnEnable(first)
	friends.RegisterCallback(self, "Update")
	guild.RegisterCallback(self, "Update")
	self:RegisterBucketEvent("RosterLib_RosterChanged", 1, "Update")
end

------------------------------------------------------------------------
-- FuBar methods
------------------------------------------------------------------------

function Fu:OnClick()
	if IsAltKeyDown() then
		ToggleFriendsFrame(3) --guild
	else
		ToggleFriendsFrame(1) --friends
	end
end

function Fu:OnTextUpdate()
	local t
	if self.db.profile.friends.show or self.db.profile.guild.show then
		t = ''
		if self.db.profile.friends.show then
			t = t..'|cffff8800'..friends:GetNumOnline()..(self.db.profile.friends.showtotal and ('/'..friends:GetNumTotal()) or '')..'|r'
		end
		if IsInGuild() then
			t = t..'|cff00ff00'
			if self.db.profile.friends.show and self.db.profile.guild.show then
				t = t..' '
			end
			if self.db.profile.guild.showname then
				t = t..(guild:GetGuildName() or UNKNOWN)..' '
			end
			if self.db.profile.guild.show then
				t = t..guild:GetNumOnline()..(self.db.profile.guild.showtotal and ('/'..guild:GetNumTotal()) or '')
			end
			t = t..'|r'
		end
	else
		t = 'Auld'
	end
	self:SetText(t)
end

do
	local function editNote(name, type)
		local notes = AuldLangSyne and (AuldLangSyne:HasModule("Note") and AuldLangSyne:GetModule("Note")) or AuldLangSyne_Note
		if notes then
			if notes.editFrame:IsVisible() and notes.editFrame.name == name then
				notes.editFrame.name = ""
				notes.editFrame.type = ""
				notes.editFrame:Hide()
			else
				notes.editFrame.name = name
				notes.editFrame.type = type
				
				notes.editFrame.editbox:SetText(notes.db.realm[type][name] or '')
				notes.editFrame.edit_text:SetText(format(AceLibrary("AceLocale-2.2"):new("AuldLangSyne_Note")["Editing note for %s"], name))
				notes.editFrame:Show()
			end
		end
	end
	function click(name, type)
		if IsAltKeyDown() then
			InviteUnit(name)
		elseif IsControlKeyDown() then
			editNote(name, type)
		else
			SetItemRef("player:"..name, "|Hplayer:"..name.."|h["..name.."|h", "LeftButton")
		end
	end
	function Fu:OnTooltipUpdate()
		tablet:SetHint(L["|cffeda55fClick|r to open the friends panel.  |cffeda55fAlt-Click|r to open the guild panel.  |cffeda55fClick|r a line to whisper a player. |cffeda55fControl-Click|r a line to edit a note. |cffeda55fAlt-Click|r a line to invite to a group."])
		
		local notes = AuldLangSyne and (AuldLangSyne:HasModule("Note") and AuldLangSyne:GetModule("Note").db.realm) or (AuldLangSyne_Note and AuldLangSyne_Note.db.realm)
		local info = AuldLangSyne and (AuldLangSyne:HasModule("Info") and AuldLangSyne:GetModule("Info").db.realm) or (AuldLangSyne_Info and AuldLangSyne_Info.db.realm)
		local fopts = self.db.profile.friends
		if fopts.show then
			local friendcols = new()
			if fopts.columns.name then table.insert(friendcols, 'Name') end
			if fopts.columns.level then table.insert(friendcols, 'Level') end
			if fopts.columns.class then table.insert(friendcols, 'Class') end
			if fopts.columns.zone then table.insert(friendcols, 'Zone') end
			if fopts.columns.status then table.insert(friendcols, 'Status') end
			if notes and fopts.columns.note then table.insert(friendcols, 'Note') end
			local header = new()
			for i,col in ipairs(friendcols) do
				if i==1 then
					header['text'] = L[col]
				else
					header['text'..i] = L[col]
				end
			end
			
			local cat = tablet:AddCategory('id', 'friends', 'columns', #friendcols, 'text', L["Friends"])
			cat:AddLine(header)
			local tmp = new()
			for name in friends:GetIterator(fopts.sort, fopts.offline) do
				local online = friends:IsFriendOnline(name)
				if fopts.offline or online then
					tmp.name = name
					tmp.level = friends:GetLevel(name)
					tmp.class = friends:GetClass(name)
					tmp.zone = friends:GetZone(name)
					tmp.status = friends:GetStatus(name)
					if notes and notes.friend[name] and notes.friend[name] ~= '' then
						local note = notes.friend[name]
						if strlen(note) > 50 then
							note = strsub(note, 0, 30)..'...'
						end
						tmp.note = "|cffff8800{"..note.."}|r "
					else
						tmp.note = ''
					end
					line = new()
					for i,col in ipairs(friendcols) do
						col = string.lower(col)
						local key
						local r, g, b = 1, 1, 1
						if i==1 then key = 'text' else key = 'text'..i end
						if fopts.colors[col] == 'class' then
							r,g,b = friends:GetClassColor(name)
						elseif fopts.colors[col] == 'level' then
							local c = GetDifficultyColor(tmp.level)
							r,g,b = c.r, c.g, c.b
						end
						if not online then
							r, g, b = r * 0.5, g * 0.5, b * 0.5
						end
						line[key] = tmp[col]
						line[key..'R'], line[key..'G'], line[key..'B'] = r, g, b
					end
					line['func'] = click; line['arg1'] = name; line['arg2'] = 'friend'
					line['hasCheck'] = true
					if roster:GetUnitIDFromName(name) then
						line['checked'] = true
					end
					cat:AddLine(line)
					del(line)
				end
			end
			del(tmp)
			del(header)
			del(friendcols)
		end
		
		local gopts = self.db.profile.guild
		if IsInGuild() and gopts.show then
			local guildcols = new()
			if gopts.columns.name then table.insert(guildcols, 'Name') end
			if gopts.columns.level then table.insert(guildcols, 'Level') end
			if gopts.columns.class then table.insert(guildcols, 'Class') end
			if gopts.columns.zone then table.insert(guildcols, 'Zone') end
			if gopts.columns.rank then table.insert(guildcols, 'Rank') end
			if gopts.columns.status then table.insert(guildcols, 'Status') end
			if gopts.columns.note then table.insert(guildcols, 'Note') end
			local header = new()
			for i,col in ipairs(guildcols) do
				if i==1 then
					header['text'] = L[col]
				else
					header['text'..i] = L[col]
				end
			end
			
			if gopts.motd then
				cat = tablet:AddCategory('id', 'motd', 'text', L["MotD"])
				cat:AddLine('text', GetGuildRosterMOTD(), 'wrap', true)
			end
			
			cat = tablet:AddCategory('id', 'guild', 'columns', #guildcols, 'text', L["Guild"])
			cat:AddLine(header)
			local tmp = new()
			for name in guild:GetIterator(gopts.sort, gopts.offline) do
				local online = guild:IsMemberOnline(name)
				if gopts.offline or online then
					tmp.name = name
					tmp.level = guild:GetLevel(name)
					tmp.class = guild:GetClass(name)
					tmp.zone = guild:GetZone(name)
					tmp.status = guild:GetStatus(name)
					tmp.rank = guild:GetRank(name)
					local n = ''
					if notes and notes.guild[name] and notes.guild[name] ~= '' then
						local note = notes.guild[name]
						if strlen(note) > 30 then
							note = strsub(note, 0, 30)..'...'
						end
						n = n .. "|cff00aa00{"..note.."}|r "
					end
					local gnote = guild:GetNote(name)
					if gnote and gnote ~= '' then
						n = n .. "|cff00ff00["..gnote.."]|r "
					end
					local gonote = guild:GetOfficerNote(name)
					if gonote and gonote ~= '' then
						n = n .. "|cff00ffff["..gonote.."]|r "
					end
					tmp.note = n
					
					line = new()
					for i,col in ipairs(guildcols) do
						col = string.lower(col)
						local key
						local r, g, b = 1, 1, 1
						if i==1 then key = 'text' else key = 'text'..i end
						if gopts.colors[col] == 'class' then
							r,g,b = guild:GetClassColor(name)
						elseif gopts.colors[col] == 'level' then
							local c = GetDifficultyColor(tmp.level)
							r,g,b = c.r, c.g, c.b
						end
						if not online then
							r, g, b = r * 0.5, g * 0.5, b * 0.5
						end
						line[key] = tmp[col]
						line[key..'R'], line[key..'G'], line[key..'B'] = r, g, b
					end
					line['func'] = click; line['arg1'] = name; line['arg2'] = 'guild'
					line['hasCheck'] = true
					if roster:GetUnitIDFromName(name) then
						line['checked'] = true
					end
					cat:AddLine(line)
					del(line)
				end
			end
			del(tmp)
			del(header)
			del(guildcols)
		end
	end
end
