Audio_Local_VolumeBarMask_Scripts = {}
Audio_Local_DraggingVolumeBar = nil
Audio_Local_VolumeBars = {}

--Set up binding calls
function Audio_Hook_BindVolumeBar(bar,mask)
	mask:RegisterForClicks("AnyUp","AnyDown")
	Audio_SetupScripts(mask, Audio_Local_VolumeBarMask_Scripts)
	Audio_Local_VolumeBars[mask] = bar
end

--Handle the volume control being clicked
function Audio_Local_VolumeBarMask_Scripts:OnClick(self)
    local _,y = GetCursorPosition()
	y = y / self:GetEffectiveScale() - self:GetBottom()
	Audio_SetVolume(y/(self:GetHeight()))
end

function Audio_Local_VolumeBarMask_Scripts:OnMouseDown(self)
	Audio_OnDragStart(self)
end

function Audio_Local_VolumeBarMask_Scripts:OnMouseUp(self)
	Audio_OnDragEnd(self)
end

function Audio_Local_VolumeBarMask_Scripts:OnHide(self)
	Audio_OnDragEnd(self)
end

function Audio_Local_VolumeBarMask_Scripts:OnUpdate(self,elapsed)
	Audio_OnDragUpdate(self,elapsed)
end

--DRAG
function Audio_OnDragStart(self)
	Audio_Local_DraggingVolumeBar = self
end

function Audio_OnDragEnd(self)
	Audio_Local_DraggingVolumeBar = nil
end

Audio_Local_UpdateInterval = 0.1; 
function Audio_OnDragUpdate(self,elapsed)
	if self.TimeSinceLastUpdate == nil then self.TimeSinceLastUpdate = 0 end
	self.TimeSinceLastUpdate = self.TimeSinceLastUpdate + elapsed; 	
	  while (self.TimeSinceLastUpdate > Audio_Local_UpdateInterval) do
		 if Audio_Local_DraggingVolumeBar ~= nil then
			local _,y = GetCursorPosition()
			y = math.min((Audio_Local_DraggingVolumeBar:GetHeight()),math.max(0,y / Audio_UI_Control:GetEffectiveScale() - Audio_Local_DraggingVolumeBar:GetBottom()))
			Audio_SetVolume(y/(Audio_Local_DraggingVolumeBar:GetHeight()))
		end
		self.TimeSinceLastUpdate = self.TimeSinceLastUpdate - Audio_Local_UpdateInterval;
	 end
end