--BINDINGS
BINDING_HEADER_AUDIO_BINDING = "Audio"
BINDING_NAME_AUDIO_BINDING_TEMPMUTE = "Temporary Mute"
BINDING_NAME_AUDIO_BINDING_TOGGLEMUTE = "Toggle Mute"

--CODE
Audio_Local_Events = {}
Audio_Local_BindingBasedMute = false

--Make sure it looks tidy at the start
function Audio_Local_Events:VARIABLES_LOADED(...)
  Audio_RefreshAudio()
end

--Event for this function is terrble so hook it
--Have setting values go through triggers so that our UI matches whatever else messes w/ the volume
--Have to put this outside of SetVolume because it is a post hook :/
function Audio_SetCVar(name,val)
  if name == "Sound_MasterVolume" then
	if val ~= 0 then
		Audio_UnMute()
	else
		Audio_Mute()
	end
    Audio_RefreshAudio()
  end
end

--Set up and register functions and hooks
function Audio_OnLoad()
  Audio_Hook_BindVolumeBar(Audio_UI_Control_Volume, Audio_UI_Control_VolumeMask)
  Audio_Hook_BindMuteButton(Audio_UI_Mute)
  hooksecurefunc("SetCVar", Audio_SetCVar)
  Audio_SetupEvents(Audio_UI_Control, Audio_Local_Events)
end

function Audio_SetupEvents(frame,table,event)
  frame:SetScript("OnEvent", function(self, event, ...)
    table[event](self, ...); -- call one of the functions above
  end);
  for k, v in pairs(table) do
    frame:RegisterEvent(k); -- Register all events for which handlers have been defined
  end
end

function Audio_SetupScripts(frame,table)
  for k, v in pairs(table) do
	frame:SetScript(k, function(...)
		v(frame,...); -- call one of the functions above
	end);
  end
end

--Fixes up how the UI should be looking
function Audio_RefreshAudio()
  for mask,bar in pairs(Audio_Local_VolumeBars) do
	  local h = (mask:GetHeight())*GetCVar("Sound_MasterVolume")
	  --if you set height to 0 it goes to default height...
	  if h == 0 then
		bar:Hide()
	  else
		bar:SetHeight(h)
		bar:Show()
	  end
  end
  for _,mute in pairs(Audio_Local_MuteButtons) do
	  mute:SetChecked(Audio_Saved_Muted)
  end
end

--Toggles if audio is muted
function Audio_ToggleMute()
	if Audio_Saved_Muted then
		Audio_UnMute()
	else
		Audio_Mute()
	end
end

--Ground zero for messing with volume
function Audio_SetVolume(val)
	--Make it look muted if you set it to zero
	if val == 0 then
		Audio_Saved_Muted = true
		--Only save new volume if it is a different volume from current one (prevents multiple 0 sets)
		local checkVolume = GetCVar("Sound_MasterVolume")
		if checkVolume ~= Audio_Saved_MutedVolume then
			Audio_Saved_MutedVolume = checkVolume
		end
	else
		Audio_Saved_Muted = false
	end
	SetCVar("Sound_MasterVolume",val)
end

--Mutes audio if it is not already
function Audio_Mute()
	if not Audio_Saved_Muted then
		Audio_SetVolume(0)
	end
end

--Unmutes audio if it is not already
function Audio_UnMute()
	if Audio_Saved_Muted then
		Audio_SetVolume(Audio_Saved_MutedVolume)
	end
end

--Pumps out text to chat frame
function Audio_Out(text)
  SELECTED_CHAT_FRAME:AddMessage(text);
end