--[[
	Informant - An addon for World of Warcraft that shows pertinent information about
	an item in a tooltip when you hover over the item in the game.
	Version: 5.0.0 (BillyGoat)
	Revision: $Id: InfData.lua 3471 2008-09-08 04:24:40Z Hirsute $
	URL: http://auctioneeraddon.com/dl/Informant/

	Informant ItemData

	License:
		This program is free software; you can redistribute it and/or
		modify it under the terms of the GNU General Public License
		as published by the Free Software Foundation; either version 2
		of the License, or (at your option) any later version.

		This program is distributed in the hope that it will be useful,
		but WITHOUT ANY WARRANTY; without even the implied warranty of
		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
		GNU General Public License for more details.

		You should have received a copy of the GNU General Public License
		along with this program(see GPL.txt); if not, write to the Free Software
		Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

	Note:
		This AddOn's source code is specifically designed to work with
		World of Warcraft's interpreted AddOn system.
		You have an implicit licence to use this AddOn with these facilities
		since that is its designated purpose as per:
		http://www.fsf.org/licensing/licenses/gpl-faq.html#InterpreterIncompat
		Many thanks to the folks at http://www.wowhead.com for providing much of this data.
--]]
-- Numeric Codes and the Skills associated with them.
Informant.SetSkills({
	[171]="Alchemy",
	[164]="Blacksmithing",
	[185]="Cooking",
	[333]="Enchanting",
	[202]="Engineering",
	[129]="FirstAid",
	[356]="Fishing",
	[182]="Herbalism",
	[755]="Jewelcrafting",
	[165]="Leatherworking",
	[186]="Mining",
	[762]="Riding",
	[197]="Tailoring",
	[-11]="Druid",
	[-8]="Mage",
	[237]="Mage",
	[-2]="Paladin",
	[-5]="Priest",
	[40]="Rogue",
	[-4]="Rogue",
	[-7]="Shaman",
	[354]="Warlock",
	[-9]="Warlock",
})

-- A list of items with skill or other requirements
Informant.SetRequirements({
	[118]="171:1",
	[724]="185:50",
	[733]="185:75",
	[787]="185:1",
	[858]="171:55",
	[929]="171:110",
	[1017]="185:100",
	[1082]="185:100",
	[1113]="237:0",
	[1114]="237:0",
	[1251]="129:1",
	[1254]="354:0",
	[1487]="237:0",
	[1710]="171:155",
	[2136]="237:0",
	[2288]="237:0",
	[2300]="165:40",
	[2302]="165:1",
	[2303]="165:15",
	[2304]="165:1",
	[2307]="165:90",
	[2308]="165:85",
	[2309]="165:55",
	[2310]="165:60",
	[2311]="165:60",
	[2312]="165:75",
	[2313]="165:100",
	[2314]="165:120",
	[2315]="165:100",
	[2316]="165:110",
	[2317]="165:100",
	[2318]="165:1",
	[2319]="165:100",
	[2454]="171:1",
	[2455]="171:25",
	[2456]="171:40",
	[2457]="171:50",
	[2458]="171:50",
	[2459]="171:60",
	[2568]="197:10",
	[2569]="197:65",
	[2570]="197:1",
	[2572]="197:40",
	[2575]="197:40",
	[2576]="197:1",
	[2577]="197:40",
	[2578]="197:70",
	[2579]="197:70",
	[2580]="197:60",
	[2581]="129:40",
	[2582]="197:85",
	[2583]="197:95",
	[2584]="197:75",
	[2585]="197:105",
	[2587]="197:100",
	[2679]="185:1",
	[2680]="185:10",
	[2681]="185:1",
	[2682]="185:85",
	[2683]="185:75",
	[2684]="185:50",
	[2685]="185:110",
	[2687]="185:80",
	[2840]="186:1",
	[2841]="186:65",
	[2842]="186:75",
	[2844]="164:15",
	[2845]="164:20",
	[2847]="164:25",
	[2848]="164:110",
	[2849]="164:115",
	[2850]="164:120",
	[2851]="164:35",
	[2852]="164:1",
	[2853]="164:1",
	[2854]="164:90",
	[2857]="164:70",
	[2862]="164:1",
	[2863]="164:65",
	[2864]="164:80",
	[2865]="164:105",
	[2866]="164:105",
	[2868]="164:120",
	[2869]="164:130",
	[2870]="164:145",
	[2871]="164:125",
	[2888]="185:10",
	[2892]="40:130",
	[2893]="40:170",
	[2996]="197:1",
	[2997]="197:75",
	[3220]="185:60",
	[3239]="164:1",
	[3240]="164:65",
	[3241]="164:125",
	[3382]="171:15",
	[3383]="171:90",
	[3384]="171:110",
	[3385]="171:120",
	[3386]="171:120",
	[3387]="171:250",
	[3388]="171:125",
	[3389]="171:130",
	[3390]="171:140",
	[3391]="171:150",
	[3469]="164:20",
	[3470]="164:25",
	[3471]="164:35",
	[3472]="164:40",
	[3473]="164:45",
	[3474]="164:60",
	[3478]="164:75",
	[3480]="164:110",
	[3481]="164:125",
	[3482]="164:130",
	[3483]="164:135",
	[3484]="164:145",
	[3485]="164:150",
	[3486]="164:125",
	[3487]="164:95",
	[3488]="164:35",
	[3489]="164:70",
	[3490]="164:125",
	[3491]="164:130",
	[3492]="164:145",
	[3530]="129:80",
	[3531]="129:115",
	[3575]="186:125",
	[3576]="186:65",
	[3577]="186:155",
	[3662]="185:80",
	[3663]="185:90",
	[3664]="185:120",
	[3665]="185:130",
	[3666]="185:110",
	[3719]="165:150",
	[3726]="185:110",
	[3727]="185:125",
	[3728]="185:150",
	[3729]="185:175",
	[3772]="237:0",
	[3775]="40:1",
	[3776]="40:230",
	[3823]="171:165",
	[3824]="171:165",
	[3825]="171:175",
	[3826]="171:180",
	[3827]="171:160",
	[3828]="171:195",
	[3829]="171:200",
	[3835]="164:165",
	[3836]="164:170",
	[3837]="164:190",
	[3840]="164:160",
	[3841]="164:175",
	[3842]="164:155",
	[3843]="164:170",
	[3844]="164:180",
	[3845]="164:195",
	[3846]="164:185",
	[3847]="164:200",
	[3848]="164:105",
	[3849]="164:160",
	[3850]="164:175",
	[3851]="164:155",
	[3852]="164:170",
	[3853]="164:180",
	[3854]="164:200",
	[3855]="164:185",
	[3856]="164:200",
	[3859]="186:165",
	[3860]="186:175",
	[3928]="171:215",
	[4231]="165:35",
	[4233]="165:100",
	[4234]="165:150",
	[4236]="165:150",
	[4237]="165:25",
	[4238]="197:45",
	[4239]="165:55",
	[4240]="197:80",
	[4241]="197:95",
	[4242]="165:75",
	[4243]="165:85",
	[4244]="165:100",
	[4245]="197:150",
	[4246]="165:80",
	[4247]="165:145",
	[4248]="165:120",
	[4249]="165:125",
	[4250]="165:120",
	[4251]="165:130",
	[4252]="165:140",
	[4253]="165:135",
	[4254]="165:150",
	[4255]="165:155",
	[4256]="165:175",
	[4257]="165:160",
	[4258]="165:170",
	[4259]="165:180",
	[4260]="165:195",
	[4262]="165:185",
	[4264]="165:200",
	[4265]="165:150",
	[4304]="165:200",
	[4305]="197:125",
	[4307]="197:35",
	[4308]="197:60",
	[4309]="197:70",
	[4310]="197:85",
	[4311]="197:100",
	[4312]="197:80",
	[4313]="197:95",
	[4314]="197:110",
	[4315]="197:120",
	[4316]="197:110",
	[4317]="197:125",
	[4318]="197:130",
	[4319]="197:145",
	[4320]="197:125",
	[4321]="197:140",
	[4322]="197:165",
	[4323]="197:170",
	[4324]="197:150",
	[4325]="197:175",
	[4326]="197:185",
	[4327]="197:200",
	[4328]="197:180",
	[4329]="197:200",
	[4330]="197:110",
	[4331]="197:125",
	[4332]="197:135",
	[4333]="197:155",
	[4334]="197:170",
	[4335]="197:185",
	[4336]="197:200",
	[4339]="197:175",
	[4343]="197:30",
	[4344]="197:1",
	[4357]="202:1",
	[4358]="202:1",
	[4359]="202:30",
	[4360]="202:30",
	[4361]="202:50",
	[4362]="202:50",
	[4363]="202:65",
	[4364]="202:75",
	[4365]="202:75",
	[4366]="202:85",
	[4367]="202:100",
	[4368]="202:100",
	[4369]="202:105",
	[4370]="202:105",
	[4371]="202:105",
	[4372]="202:120",
	[4373]="202:120",
	[4374]="202:120",
	[4375]="202:125",
	[4376]="202:125",
	[4377]="202:125",
	[4378]="202:125",
	[4379]="202:130",
	[4380]="202:140",
	[4381]="202:140",
	[4382]="202:145",
	[4383]="202:145",
	[4384]="202:150",
	[4385]="202:150",
	[4386]="202:155",
	[4387]="202:160",
	[4388]="202:160",
	[4389]="202:170",
	[4390]="202:175",
	[4391]="202:175",
	[4392]="202:185",
	[4393]="202:185",
	[4394]="202:190",
	[4395]="202:195",
	[4396]="202:200",
	[4397]="202:200",
	[4398]="202:200",
	[4401]="202:75",
	[4403]="202:165",
	[4404]="202:90",
	[4405]="202:60",
	[4406]="202:110",
	[4407]="202:180",
	[4455]="165:165",
	[4456]="165:165",
	[4457]="185:175",
	[4592]="185:50",
	[4593]="185:100",
	[4594]="185:175",
	[4596]="171:50",
	[4623]="171:215",
	[4852]="202:185",
	[5081]="165:40",
	[5095]="185:50",
	[5232]="354:0",
	[5237]="40:100",
	[5349]="237:0",
	[5350]="237:0",
	[5472]="185:10",
	[5473]="185:20",
	[5474]="185:35",
	[5476]="185:50",
	[5477]="185:50",
	[5478]="185:90",
	[5479]="185:100",
	[5480]="185:110",
	[5507]="202:135",
	[5513]="237:0",
	[5514]="237:0",
	[5522]="354:0",
	[5525]="185:50",
	[5526]="185:90",
	[5527]="185:125",
	[5540]="164:110",
	[5541]="164:140",
	[5542]="197:90",
	[5631]="171:60",
	[5633]="171:175",
	[5634]="171:150",
	[5739]="165:190",
	[5762]="197:70",
	[5763]="197:115",
	[5764]="197:175",
	[5765]="197:185",
	[5766]="197:135",
	[5770]="197:150",
	[5780]="165:90",
	[5781]="165:95",
	[5782]="165:170",
	[5783]="165:190",
	[5957]="165:1",
	[5958]="165:105",
	[5961]="165:115",
	[5962]="165:160",
	[5963]="165:170",
	[5964]="165:175",
	[5965]="165:185",
	[5966]="165:190",
	[5996]="171:90",
	[5997]="171:1",
	[6037]="186:230",
	[6038]="185:175",
	[6040]="164:185",
	[6041]="164:190",
	[6042]="164:150",
	[6043]="164:165",
	[6048]="171:135",
	[6049]="171:165",
	[6050]="171:190",
	[6051]="171:100",
	[6052]="171:190",
	[6149]="171:205",
	[6214]="164:65",
	[6218]="333:1",
	[6219]="202:50",
	[6238]="197:30",
	[6239]="197:55",
	[6240]="197:55",
	[6241]="197:30",
	[6242]="197:70",
	[6263]="197:100",
	[6264]="197:115",
	[6290]="185:1",
	[6316]="185:50",
	[6338]="164:100",
	[6339]="333:100",
	[6350]="164:95",
	[6370]="171:80",
	[6371]="171:130",
	[6372]="171:100",
	[6373]="171:140",
	[6384]="197:120",
	[6385]="197:120",
	[6450]="129:150",
	[6451]="129:180",
	[6452]="129:80",
	[6453]="129:130",
	[6466]="165:90",
	[6467]="165:105",
	[6468]="165:115",
	[6533]="202:150",
	[6657]="185:85",
	[6662]="171:90",
	[6709]="165:90",
	[6712]="202:100",
	[6714]="202:100",
	[6731]="164:100",
	[6786]="197:40",
	[6787]="197:110",
	[6795]="197:160",
	[6796]="197:175",
	[6836]="197:250",
	[6887]="185:225",
	[6888]="185:1",
	[6890]="185:40",
	[6947]="40:1",
	[6949]="40:120",
	[6950]="40:160",
	[6951]="40:170",
	[7026]="197:15",
	[7046]="197:140",
	[7047]="197:145",
	[7048]="197:145",
	[7049]="197:150",
	[7050]="197:160",
	[7051]="197:170",
	[7052]="197:175",
	[7053]="197:175",
	[7054]="197:190",
	[7055]="197:175",
	[7056]="197:180",
	[7057]="197:180",
	[7058]="197:185",
	[7059]="197:190",
	[7060]="197:190",
	[7061]="197:195",
	[7062]="197:195",
	[7063]="197:205",
	[7064]="197:210",
	[7065]="197:165",
	[7068]="171:300",
	[7071]="164:150",
	[7076]="171:275",
	[7078]="171:275",
	[7080]="171:275",
	[7082]="171:275",
	[7148]="202:165",
	[7166]="164:30",
	[7189]="202:130",
	[7191]="202:275",
	[7276]="165:1",
	[7277]="165:1",
	[7278]="165:30",
	[7279]="165:30",
	[7280]="165:35",
	[7281]="165:70",
	[7282]="165:95",
	[7283]="165:100",
	[7284]="165:120",
	[7285]="165:120",
	[7348]="165:125",
	[7349]="165:135",
	[7352]="165:135",
	[7358]="165:140",
	[7359]="165:145",
	[7371]="165:150",
	[7372]="165:150",
	[7373]="165:165",
	[7374]="165:175",
	[7375]="165:175",
	[7377]="165:180",
	[7378]="165:185",
	[7386]="165:190",
	[7387]="165:195",
	[7390]="165:200",
	[7391]="165:200",
	[7506]="202:125",
	[7676]="185:60",
	[7913]="164:160",
	[7914]="164:160",
	[7915]="164:175",
	[7916]="164:180",
	[7917]="164:185",
	[7918]="164:205",
	[7919]="164:205",
	[7920]="164:210",
	[7921]="164:210",
	[7922]="164:215",
	[7924]="164:215",
	[7926]="164:220",
	[7927]="164:220",
	[7928]="164:225",
	[7929]="164:0",
	[7930]="164:230",
	[7931]="164:230",
	[7932]="164:235",
	[7933]="164:235",
	[7934]="164:245",
	[7935]="164:0",
	[7936]="164:0",
	[7937]="164:0",
	[7938]="164:225",
	[7939]="164:245",
	[7941]="164:210",
	[7942]="164:220",
	[7943]="164:225",
	[7944]="164:240",
	[7945]="164:230",
	[7946]="164:245",
	[7947]="164:255",
	[7954]="164:235",
	[7955]="164:30",
	[7956]="164:125",
	[7957]="164:130",
	[7958]="164:135",
	[7959]="164:250",
	[7960]="164:260",
	[7961]="164:245",
	[7963]="164:200",
	[7964]="164:200",
	[7965]="164:200",
	[7966]="164:200",
	[7967]="164:215",
	[7969]="164:235",
	[8007]="237:0",
	[8008]="237:0",
	[8067]="202:1",
	[8068]="202:75",
	[8069]="202:125",
	[8075]="237:0",
	[8076]="237:0",
	[8077]="237:0",
	[8078]="237:0",
	[8079]="237:0",
	[8170]="165:250",
	[8172]="165:200",
	[8173]="165:200",
	[8174]="165:200",
	[8175]="165:205",
	[8176]="165:205",
	[8185]="165:235",
	[8187]="165:205",
	[8189]="165:210",
	[8191]="165:230",
	[8192]="165:210",
	[8193]="165:230",
	[8197]="165:235",
	[8198]="165:210",
	[8200]="165:215",
	[8201]="165:220",
	[8202]="165:240",
	[8203]="165:220",
	[8204]="165:225",
	[8205]="165:220",
	[8206]="165:245",
	[8207]="165:240",
	[8208]="165:250",
	[8209]="165:235",
	[8210]="165:220",
	[8211]="165:225",
	[8212]="165:250",
	[8213]="165:245",
	[8214]="165:225",
	[8215]="165:250",
	[8216]="165:240",
	[8217]="165:225",
	[8218]="165:225",
	[8345]="165:225",
	[8346]="165:230",
	[8347]="165:225",
	[8348]="165:250",
	[8349]="165:250",
	[8364]="185:175",
	[8367]="165:255",
	[8544]="129:210",
	[8545]="129:240",
	[8926]="40:200",
	[8927]="40:240",
	[8928]="40:280",
	[8949]="171:185",
	[8951]="171:195",
	[8956]="171:205",
	[8984]="40:210",
	[8985]="40:250",
	[9030]="171:210",
	[9036]="171:210",
	[9060]="164:200",
	[9061]="171:210",
	[9088]="171:240",
	[9144]="171:225",
	[9149]="171:225",
	[9154]="171:230",
	[9155]="171:235",
	[9172]="171:235",
	[9179]="171:235",
	[9186]="40:240",
	[9187]="171:240",
	[9197]="171:240",
	[9206]="171:245",
	[9210]="171:245",
	[9224]="171:250",
	[9233]="171:250",
	[9264]="171:250",
	[9312]="202:150",
	[9313]="202:150",
	[9318]="202:150",
	[9366]="164:205",
	[9998]="197:205",
	[9999]="197:205",
	[10001]="197:210",
	[10002]="197:210",
	[10003]="197:215",
	[10004]="197:215",
	[10007]="197:215",
	[10008]="197:215",
	[10009]="197:215",
	[10018]="197:225",
	[10019]="197:225",
	[10021]="197:225",
	[10023]="197:225",
	[10024]="197:230",
	[10025]="197:245",
	[10026]="197:230",
	[10027]="197:230",
	[10028]="197:235",
	[10029]="197:235",
	[10030]="197:240",
	[10031]="197:240",
	[10033]="197:240",
	[10034]="197:240",
	[10035]="197:245",
	[10036]="197:250",
	[10040]="197:250",
	[10041]="197:250",
	[10042]="197:225",
	[10044]="197:245",
	[10045]="197:1",
	[10046]="197:20",
	[10047]="197:75",
	[10048]="197:120",
	[10050]="197:225",
	[10051]="197:235",
	[10052]="197:220",
	[10053]="197:235",
	[10054]="197:230",
	[10055]="197:235",
	[10056]="197:215",
	[10421]="164:1",
	[10423]="164:155",
	[10498]="202:175",
	[10499]="202:175",
	[10500]="202:205",
	[10501]="202:220",
	[10502]="202:225",
	[10503]="202:230",
	[10504]="202:245",
	[10505]="202:175",
	[10506]="202:230",
	[10507]="202:175",
	[10508]="202:205",
	[10510]="202:220",
	[10512]="202:210",
	[10513]="202:245",
	[10514]="202:215",
	[10518]="202:225",
	[10542]="202:205",
	[10543]="202:205",
	[10545]="202:210",
	[10546]="202:210",
	[10548]="202:240",
	[10558]="202:150",
	[10559]="202:195",
	[10560]="202:200",
	[10561]="202:215",
	[10562]="202:235",
	[10576]="202:250",
	[10577]="202:205",
	[10586]="202:235",
	[10587]="202:230",
	[10588]="202:245",
	[10592]="171:200",
	[10644]="202:205",
	[10645]="202:240",
	[10646]="202:205",
	[10713]="202:205",
	[10716]="202:205",
	[10720]="202:210",
	[10721]="202:215",
	[10724]="202:225",
	[10725]="202:230",
	[10726]="202:235",
	[10727]="202:240",
	[10841]="185:175",
	[10918]="40:140",
	[10920]="40:180",
	[10921]="40:220",
	[10922]="40:260",
	[11128]="164:150",
	[11130]="333:150",
	[11144]="164:200",
	[11145]="333:200",
	[11287]="333:10",
	[11288]="333:70",
	[11289]="333:155",
	[11290]="333:175",
	[11371]="186:230",
	[11590]="202:200",
	[11604]="164:285",
	[11605]="164:280",
	[11606]="164:270",
	[11607]="164:275",
	[11608]="164:265",
	[11811]="333:265",
	[11825]="202:205",
	[11826]="202:205",
	[12190]="171:230",
	[12209]="185:125",
	[12210]="185:175",
	[12212]="185:175",
	[12213]="185:175",
	[12214]="185:175",
	[12215]="185:200",
	[12216]="185:225",
	[12217]="185:200",
	[12218]="185:225",
	[12224]="185:1",
	[12259]="164:180",
	[12260]="164:190",
	[12359]="186:250",
	[12360]="171:275",
	[12404]="164:250",
	[12405]="164:250",
	[12406]="164:250",
	[12408]="164:255",
	[12409]="164:280",
	[12410]="164:280",
	[12414]="164:300",
	[12415]="164:270",
	[12416]="164:260",
	[12417]="164:295",
	[12418]="164:285",
	[12419]="164:290",
	[12420]="164:300",
	[12422]="164:300",
	[12424]="164:265",
	[12425]="164:270",
	[12426]="164:295",
	[12427]="164:295",
	[12428]="164:265",
	[12429]="164:300",
	[12610]="164:300",
	[12611]="164:300",
	[12612]="164:0",
	[12613]="164:300",
	[12614]="164:300",
	[12618]="164:300",
	[12619]="164:300",
	[12620]="164:300",
	[12624]="164:270",
	[12625]="164:290",
	[12628]="164:285",
	[12631]="164:290",
	[12632]="164:295",
	[12633]="164:300",
	[12636]="164:300",
	[12639]="164:300",
	[12640]="164:300",
	[12641]="164:300",
	[12643]="164:250",
	[12644]="164:250",
	[12645]="164:275",
	[12655]="333:250",
	[12773]="164:275",
	[12774]="164:275",
	[12775]="164:280",
	[12776]="164:280",
	[12777]="164:280",
	[12781]="164:285",
	[12782]="164:290",
	[12783]="164:300",
	[12784]="164:300",
	[12790]="164:300",
	[12792]="164:290",
	[12794]="164:300",
	[12796]="164:300",
	[12797]="164:300",
	[12798]="164:300",
	[12803]="171:275",
	[12808]="171:275",
	[12810]="333:250",
	[13423]="171:250",
	[13442]="171:255",
	[13443]="171:260",
	[13444]="171:295",
	[13445]="171:265",
	[13446]="171:275",
	[13447]="171:270",
	[13452]="171:280",
	[13453]="171:275",
	[13454]="171:285",
	[13455]="171:280",
	[13456]="171:290",
	[13457]="171:290",
	[13458]="171:290",
	[13459]="171:290",
	[13461]="171:290",
	[13462]="171:285",
	[13503]="171:350",
	[13506]="171:300",
	[13510]="171:300",
	[13511]="171:300",
	[13512]="171:300",
	[13513]="171:300",
	[13602]="354:0",
	[13603]="354:0",
	[13699]="354:0",
	[13700]="354:0",
	[13701]="354:0",
	[13851]="185:175",
	[13856]="197:255",
	[13857]="197:260",
	[13858]="197:260",
	[13860]="197:265",
	[13863]="197:275",
	[13864]="197:280",
	[13865]="197:285",
	[13866]="197:295",
	[13867]="197:300",
	[13868]="197:255",
	[13869]="197:255",
	[13870]="197:265",
	[13871]="197:280",
	[13927]="185:225",
	[13928]="185:240",
	[13929]="185:240",
	[13930]="185:225",
	[13931]="185:250",
	[13932]="185:250",
	[13933]="185:275",
	[13934]="185:275",
	[13935]="185:275",
	[14042]="197:260",
	[14043]="197:270",
	[14044]="197:275",
	[14045]="197:280",
	[14046]="197:260",
	[14048]="197:250",
	[14100]="197:270",
	[14101]="197:270",
	[14103]="197:275",
	[14104]="197:290",
	[14106]="197:300",
	[14107]="197:275",
	[14108]="197:285",
	[14111]="197:290",
	[14112]="197:300",
	[14128]="197:300",
	[14130]="197:300",
	[14132]="197:275",
	[14134]="197:275",
	[14136]="197:285",
	[14137]="197:290",
	[14138]="197:300",
	[14139]="197:300",
	[14140]="197:300",
	[14141]="197:275",
	[14142]="197:270",
	[14143]="197:265",
	[14144]="197:290",
	[14146]="197:300",
	[14152]="197:300",
	[14153]="197:300",
	[14154]="197:300",
	[14155]="197:300",
	[14156]="197:300",
	[14342]="197:250",
	[14529]="129:260",
	[14530]="129:290",
	[15045]="165:260",
	[15046]="165:270",
	[15047]="165:300",
	[15048]="165:285",
	[15049]="165:295",
	[15050]="165:290",
	[15051]="165:300",
	[15052]="165:300",
	[15053]="165:285",
	[15054]="165:270",
	[15055]="165:300",
	[15056]="165:285",
	[15057]="165:275",
	[15058]="165:295",
	[15059]="165:300",
	[15060]="165:285",
	[15061]="165:270",
	[15062]="165:300",
	[15063]="165:290",
	[15064]="165:275",
	[15065]="165:285",
	[15066]="165:290",
	[15067]="165:270",
	[15068]="165:300",
	[15069]="165:285",
	[15070]="165:295",
	[15071]="165:275",
	[15072]="165:280",
	[15073]="165:275",
	[15074]="165:265",
	[15075]="165:290",
	[15076]="165:265",
	[15077]="165:255",
	[15078]="165:275",
	[15079]="165:285",
	[15080]="165:295",
	[15081]="165:300",
	[15082]="165:280",
	[15083]="165:260",
	[15084]="165:265",
	[15085]="165:300",
	[15086]="165:280",
	[15087]="165:290",
	[15088]="165:300",
	[15090]="165:300",
	[15091]="165:270",
	[15092]="165:275",
	[15093]="165:280",
	[15094]="165:290",
	[15095]="165:300",
	[15096]="165:300",
	[15138]="165:300",
	[15407]="165:250",
	[15564]="165:250",
	[15802]="197:290",
	[15846]="202:250",
	[15869]="164:100",
	[15870]="164:150",
	[15871]="164:200",
	[15872]="164:275",
	[15992]="202:250",
	[15993]="202:260",
	[15994]="202:260",
	[15995]="202:260",
	[15996]="202:265",
	[15997]="202:285",
	[15999]="202:270",
	[16000]="202:275",
	[16004]="202:275",
	[16005]="202:285",
	[16006]="202:285",
	[16007]="202:300",
	[16008]="202:290",
	[16009]="202:290",
	[16022]="202:300",
	[16023]="202:275",
	[16040]="202:300",
	[16206]="164:275",
	[16207]="333:290",
	[16766]="185:225",
	[16892]="354:0",
	[16893]="354:0",
	[16895]="354:0",
	[16896]="354:0",
	[16979]="197:300",
	[16980]="197:300",
	[16982]="165:295",
	[16983]="165:300",
	[16984]="165:300",
	[16988]="164:300",
	[16989]="164:295",
	[17013]="164:300",
	[17014]="164:295",
	[17015]="164:300",
	[17016]="164:300",
	[17193]="164:300",
	[17197]="185:1",
	[17198]="185:35",
	[17222]="185:200",
	[17704]="164:190",
	[17708]="171:190",
	[17716]="202:190",
	[17721]="165:190",
	[17723]="197:190",
	[17771]="186:300",
	[18045]="185:225",
	[18168]="202:300",
	[18232]="202:300",
	[18238]="165:200",
	[18251]="165:300",
	[18253]="171:300",
	[18254]="185:275",
	[18258]="197:275",
	[18262]="164:300",
	[18263]="197:300",
	[18282]="202:300",
	[18283]="202:300",
	[18294]="171:215",
	[18405]="197:300",
	[18407]="197:300",
	[18408]="197:300",
	[18409]="197:300",
	[18413]="197:300",
	[18486]="197:300",
	[18504]="165:300",
	[18506]="165:300",
	[18508]="165:300",
	[18509]="165:300",
	[18510]="165:300",
	[18511]="165:300",
	[18587]="202:265",
	[18588]="202:200",
	[18594]="202:275",
	[18631]="202:260",
	[18634]="202:260",
	[18637]="202:275",
	[18638]="202:290",
	[18639]="202:300",
	[18641]="202:250",
	[18645]="202:265",
	[18660]="202:260",
	[18662]="165:150",
	[18948]="165:155",
	[18984]="202:260",
	[18986]="202:260",
	[19026]="202:250",
	[19043]="164:290",
	[19044]="165:290",
	[19047]="197:290",
	[19048]="164:300",
	[19049]="165:300",
	[19050]="197:300",
	[19051]="164:290",
	[19052]="165:290",
	[19056]="197:290",
	[19057]="164:300",
	[19058]="165:300",
	[19059]="197:300",
	[19148]="164:300",
	[19149]="165:300",
	[19156]="197:300",
	[19157]="165:300",
	[19162]="165:300",
	[19163]="165:300",
	[19164]="164:300",
	[19165]="197:300",
	[19166]="164:300",
	[19167]="164:300",
	[19168]="164:300",
	[19169]="164:300",
	[19170]="164:300",
	[19440]="129:300",
	[19682]="197:300",
	[19683]="197:300",
	[19684]="197:300",
	[19685]="165:300",
	[19686]="165:300",
	[19687]="165:300",
	[19688]="165:300",
	[19689]="165:300",
	[19690]="164:300",
	[19691]="164:300",
	[19692]="164:300",
	[19693]="164:300",
	[19694]="164:300",
	[19695]="164:300",
	[19931]="171:300",
	[19998]="202:300",
	[19999]="202:300",
	[20002]="171:275",
	[20004]="171:290",
	[20007]="171:275",
	[20008]="171:285",
	[20039]="164:300",
	[20074]="185:150",
	[20295]="165:300",
	[20296]="165:280",
	[20380]="165:300",
	[20452]="185:285",
	[20475]="202:335",
	[20476]="165:300",
	[20477]="165:300",
	[20478]="165:300",
	[20479]="165:300",
	[20480]="165:300",
	[20481]="165:300",
	[20537]="197:300",
	[20538]="197:300",
	[20539]="197:300",
	[20549]="164:300",
	[20550]="164:300",
	[20551]="164:300",
	[20575]="165:100",
	[20744]="333:45",
	[20745]="333:150",
	[20746]="333:200",
	[20747]="333:250",
	[20748]="333:300",
	[20749]="333:300",
	[20750]="333:275",
	[20816]="755:1",
	[20817]="755:50",
	[20818]="755:50",
	[20820]="755:60",
	[20821]="755:30",
	[20823]="755:70",
	[20826]="755:90",
	[20827]="755:80",
	[20828]="755:100",
	[20830]="755:110",
	[20831]="755:150",
	[20832]="755:120",
	[20833]="755:125",
	[20844]="40:280",
	[20906]="755:1",
	[20907]="755:50",
	[20909]="755:110",
	[20950]="755:120",
	[20954]="755:125",
	[20955]="755:135",
	[20956]="755:0",
	[20958]="755:150",
	[20959]="755:170",
	[20960]="755:170",
	[20961]="755:180",
	[20963]="755:150",
	[20964]="755:210",
	[20966]="755:160",
	[20967]="755:190",
	[20969]="755:225",
	[21023]="185:300",
	[21072]="185:80",
	[21154]="197:250",
	[21217]="185:175",
	[21277]="202:250",
	[21278]="165:300",
	[21340]="197:260",
	[21341]="197:280",
	[21342]="197:300",
	[21542]="197:250",
	[21546]="171:250",
	[21557]="202:125",
	[21558]="202:125",
	[21559]="202:125",
	[21569]="202:225",
	[21570]="202:275",
	[21571]="202:225",
	[21574]="202:225",
	[21576]="202:225",
	[21589]="202:175",
	[21590]="202:175",
	[21592]="202:175",
	[21714]="202:275",
	[21716]="202:275",
	[21718]="202:275",
	[21748]="755:200",
	[21752]="755:225",
	[21753]="755:250",
	[21754]="755:245",
	[21755]="755:220",
	[21756]="755:200",
	[21758]="755:215",
	[21760]="755:225",
	[21763]="755:235",
	[21764]="755:235",
	[21765]="755:240",
	[21766]="755:250",
	[21767]="755:260",
	[21768]="755:275",
	[21769]="755:260",
	[21774]="755:275",
	[21775]="755:280",
	[21777]="755:285",
	[21778]="755:285",
	[21779]="755:310",
	[21780]="755:0",
	[21784]="755:300",
	[21789]="755:300",
	[21790]="755:280",
	[21791]="755:290",
	[21792]="755:305",
	[21793]="755:0",
	[21835]="40:340",
	[21840]="197:300",
	[21841]="197:315",
	[21842]="197:325",
	[21843]="197:340",
	[21844]="197:345",
	[21845]="197:350",
	[21846]="197:355",
	[21847]="197:365",
	[21848]="197:375",
	[21849]="197:310",
	[21850]="197:310",
	[21851]="197:320",
	[21852]="197:325",
	[21853]="197:335",
	[21854]="197:340",
	[21855]="197:345",
	[21858]="197:375",
	[21859]="197:340",
	[21860]="197:350",
	[21861]="197:360",
	[21862]="197:360",
	[21863]="197:355",
	[21864]="197:365",
	[21865]="197:375",
	[21866]="197:350",
	[21867]="197:360",
	[21868]="197:370",
	[21869]="197:355",
	[21870]="197:365",
	[21871]="197:375",
	[21872]="197:375",
	[21873]="197:355",
	[21874]="197:365",
	[21875]="197:375",
	[21876]="197:375",
	[21884]="171:350",
	[21885]="171:350",
	[21886]="171:300",
	[21887]="165:300",
	[21927]="40:320",
	[21931]="755:1",
	[21932]="755:5",
	[21933]="755:50",
	[21934]="755:30",
	[21990]="129:330",
	[21991]="129:360",
	[22018]="237:0",
	[22019]="237:0",
	[22044]="237:0",
	[22053]="40:290",
	[22054]="40:330",
	[22055]="40:300",
	[22116]="354:0",
	[22128]="354:0",
	[22191]="164:300",
	[22194]="164:300",
	[22195]="164:300",
	[22196]="164:300",
	[22197]="164:300",
	[22198]="164:300",
	[22246]="197:225",
	[22248]="197:275",
	[22249]="197:300",
	[22251]="197:275",
	[22252]="197:300",
	[22383]="164:300",
	[22384]="164:300",
	[22385]="164:300",
	[22448]="333:300",
	[22449]="333:335",
	[22451]="171:350",
	[22452]="171:350",
	[22456]="171:300",
	[22457]="171:300",
	[22459]="333:350",
	[22460]="333:325",
	[22461]="333:300",
	[22462]="333:350",
	[22463]="333:375",
	[22521]="333:310",
	[22522]="333:340",
	[22573]="186:300",
	[22574]="186:300",
	[22645]="185:60",
	[22646]="354:0",
	[22652]="197:300",
	[22654]="197:300",
	[22655]="197:300",
	[22658]="197:300",
	[22660]="197:300",
	[22661]="165:300",
	[22662]="165:300",
	[22663]="165:300",
	[22664]="165:300",
	[22665]="165:300",
	[22666]="165:300",
	[22669]="164:300",
	[22670]="164:300",
	[22671]="164:300",
	[22756]="197:300",
	[22757]="197:300",
	[22758]="197:300",
	[22759]="165:300",
	[22760]="165:300",
	[22761]="165:300",
	[22762]="164:300",
	[22763]="164:300",
	[22764]="164:300",
	[22823]="171:305",
	[22824]="171:305",
	[22825]="171:310",
	[22826]="171:315",
	[22827]="171:320",
	[22828]="171:320",
	[22829]="171:325",
	[22830]="171:325",
	[22831]="171:330",
	[22832]="171:340",
	[22833]="171:345",
	[22834]="171:345",
	[22835]="171:350",
	[22836]="171:350",
	[22837]="171:350",
	[22838]="171:350",
	[22839]="171:350",
	[22840]="171:355",
	[22841]="171:360",
	[22842]="171:360",
	[22844]="171:360",
	[22845]="171:360",
	[22846]="171:360",
	[22847]="171:360",
	[22848]="171:365",
	[22849]="171:365",
	[22850]="171:300",
	[22851]="171:300",
	[22853]="171:300",
	[22854]="171:300",
	[22861]="171:300",
	[22866]="171:300",
	[22871]="171:335",
	[22895]="237:0",
	[23094]="755:300",
	[23095]="755:305",
	[23096]="755:315",
	[23097]="755:325",
	[23098]="755:300",
	[23099]="755:305",
	[23100]="755:315",
	[23101]="755:325",
	[23103]="755:300",
	[23104]="755:305",
	[23105]="755:315",
	[23106]="755:325",
	[23108]="755:300",
	[23109]="755:305",
	[23110]="755:315",
	[23111]="755:325",
	[23113]="755:300",
	[23114]="755:305",
	[23115]="755:315",
	[23116]="755:325",
	[23118]="755:300",
	[23119]="755:305",
	[23120]="755:315",
	[23121]="755:325",
	[23445]="186:300",
	[23446]="186:325",
	[23447]="186:350",
	[23448]="186:350",
	[23449]="186:375",
	[23482]="164:300",
	[23484]="164:305",
	[23487]="164:315",
	[23488]="164:315",
	[23489]="164:325",
	[23490]="164:320",
	[23491]="164:310",
	[23493]="164:300",
	[23494]="164:315",
	[23497]="164:310",
	[23498]="164:315",
	[23499]="164:320",
	[23502]="164:325",
	[23503]="164:330",
	[23504]="164:330",
	[23505]="164:335",
	[23506]="164:335",
	[23507]="164:340",
	[23508]="164:335",
	[23509]="164:360",
	[23510]="164:355",
	[23511]="164:355",
	[23512]="164:365",
	[23513]="164:365",
	[23514]="164:360",
	[23515]="164:350",
	[23516]="164:355",
	[23517]="164:360",
	[23518]="164:360",
	[23519]="164:365",
	[23520]="164:365",
	[23521]="164:365",
	[23522]="164:370",
	[23523]="164:360",
	[23524]="164:360",
	[23525]="164:365",
	[23526]="164:370",
	[23527]="164:370",
	[23528]="164:300",
	[23529]="164:350",
	[23530]="164:360",
	[23531]="164:365",
	[23532]="164:365",
	[23533]="164:365",
	[23534]="164:365",
	[23535]="164:365",
	[23536]="164:365",
	[23537]="164:365",
	[23538]="164:365",
	[23539]="164:365",
	[23540]="164:365",
	[23541]="164:365",
	[23542]="164:365",
	[23543]="164:365",
	[23544]="164:365",
	[23546]="164:365",
	[23554]="164:365",
	[23555]="164:365",
	[23556]="164:365",
	[23559]="164:325",
	[23563]="164:350",
	[23564]="164:375",
	[23565]="164:375",
	[23571]="171:350",
	[23573]="186:375",
	[23575]="164:340",
	[23576]="164:375",
	[23736]="202:300",
	[23737]="202:325",
	[23742]="202:320",
	[23746]="202:350",
	[23747]="202:360",
	[23748]="202:375",
	[23758]="202:340",
	[23761]="202:340",
	[23762]="202:350",
	[23763]="202:360",
	[23764]="202:335",
	[23765]="202:360",
	[23766]="202:375",
	[23767]="202:325",
	[23768]="202:335",
	[23769]="202:0",
	[23771]="202:335",
	[23772]="202:310",
	[23774]="202:325",
	[23775]="202:0",
	[23781]="202:300",
	[23782]="202:300",
	[23783]="202:300",
	[23784]="202:325",
	[23785]="202:340",
	[23786]="202:340",
	[23787]="202:340",
	[23793]="165:325",
	[23819]="202:350",
	[23820]="202:0",
	[23821]="202:305",
	[23824]="202:355",
	[23825]="202:350",
	[23826]="202:325",
	[23827]="202:340",
	[23828]="202:375",
	[23829]="202:375",
	[23831]="202:295",
	[23832]="202:295",
	[23835]="202:340",
	[23836]="202:350",
	[23838]="202:375",
	[23839]="202:375",
	[23841]="202:325",
	[24027]="755:350",
	[24028]="755:350",
	[24029]="755:350",
	[24030]="755:350",
	[24031]="755:350",
	[24032]="755:350",
	[24033]="755:350",
	[24035]="755:350",
	[24036]="755:350",
	[24037]="755:350",
	[24039]="755:350",
	[24047]="755:350",
	[24048]="755:350",
	[24050]="755:350",
	[24051]="755:350",
	[24052]="755:350",
	[24053]="755:350",
	[24054]="755:350",
	[24055]="755:350",
	[24056]="755:350",
	[24057]="755:350",
	[24058]="755:350",
	[24059]="755:350",
	[24060]="755:350",
	[24061]="755:350",
	[24062]="755:350",
	[24065]="755:350",
	[24066]="755:350",
	[24067]="755:350",
	[24074]="755:310",
	[24075]="755:310",
	[24076]="755:320",
	[24077]="755:335",
	[24078]="755:335",
	[24079]="755:350",
	[24080]="755:355",
	[24082]="755:355",
	[24085]="755:360",
	[24086]="755:365",
	[24087]="755:345",
	[24088]="755:355",
	[24089]="755:365",
	[24092]="755:360",
	[24093]="755:360",
	[24095]="755:360",
	[24097]="755:360",
	[24098]="755:360",
	[24105]="185:1",
	[24106]="755:355",
	[24110]="755:355",
	[24114]="755:360",
	[24116]="755:360",
	[24117]="755:365",
	[24121]="755:365",
	[24122]="755:370",
	[24123]="755:370",
	[24124]="755:370",
	[24125]="755:370",
	[24126]="755:370",
	[24127]="755:370",
	[24128]="755:370",
	[24249]="197:350",
	[24250]="197:350",
	[24251]="197:350",
	[24252]="197:350",
	[24253]="197:350",
	[24254]="197:350",
	[24255]="197:365",
	[24256]="197:365",
	[24257]="197:365",
	[24258]="197:365",
	[24259]="197:365",
	[24260]="197:365",
	[24261]="197:375",
	[24262]="197:375",
	[24263]="197:375",
	[24264]="197:375",
	[24266]="197:375",
	[24267]="197:375",
	[24268]="197:300",
	[24270]="197:340",
	[24271]="197:350",
	[24272]="197:350",
	[24273]="197:335",
	[24274]="197:375",
	[24275]="197:335",
	[24276]="197:375",
	[25438]="755:20",
	[25439]="755:20",
	[25498]="755:1",
	[25521]="164:350",
	[25650]="165:300",
	[25651]="165:325",
	[25652]="165:325",
	[25653]="165:350",
	[25654]="165:300",
	[25655]="165:310",
	[25656]="165:320",
	[25657]="165:335",
	[25659]="165:335",
	[25660]="165:325",
	[25661]="165:310",
	[25662]="165:300",
	[25668]="165:320",
	[25669]="165:300",
	[25670]="165:315",
	[25671]="165:330",
	[25673]="165:300",
	[25674]="165:310",
	[25675]="165:320",
	[25676]="165:330",
	[25679]="165:300",
	[25680]="165:350",
	[25681]="165:350",
	[25682]="165:350",
	[25683]="165:350",
	[25685]="165:340",
	[25686]="165:350",
	[25687]="165:350",
	[25689]="165:360",
	[25690]="165:355",
	[25691]="165:355",
	[25692]="165:340",
	[25693]="165:350",
	[25694]="165:340",
	[25695]="165:350",
	[25696]="165:360",
	[25697]="165:360",
	[25843]="164:300",
	[25844]="164:350",
	[25845]="164:375",
	[25880]="755:50",
	[25881]="755:110",
	[25882]="755:175",
	[25883]="755:225",
	[25884]="755:0",
	[25886]="202:335",
	[25890]="755:365",
	[25893]="755:365",
	[25894]="755:365",
	[25895]="755:365",
	[25896]="755:365",
	[25897]="755:365",
	[25898]="755:365",
	[25899]="755:365",
	[25901]="755:365",
	[27635]="185:1",
	[27636]="185:50",
	[27651]="185:300",
	[27655]="185:300",
	[27656]="185:310",
	[27657]="185:315",
	[27658]="185:325",
	[27659]="185:325",
	[27660]="185:325",
	[27661]="185:300",
	[27662]="185:300",
	[27663]="185:310",
	[27664]="185:320",
	[27665]="185:320",
	[27666]="185:325",
	[27667]="185:350",
	[28100]="171:300",
	[28101]="171:310",
	[28102]="171:300",
	[28103]="171:300",
	[28104]="171:315",
	[28290]="755:325",
	[28420]="164:300",
	[28421]="164:350",
	[28425]="164:350",
	[28426]="164:375",
	[28427]="164:375",
	[28428]="164:350",
	[28429]="164:375",
	[28430]="164:375",
	[28431]="164:350",
	[28432]="164:375",
	[28433]="164:375",
	[28434]="164:350",
	[28435]="164:375",
	[28436]="164:375",
	[28437]="164:350",
	[28438]="164:375",
	[28439]="164:375",
	[28440]="164:350",
	[28441]="164:375",
	[28442]="164:375",
	[28483]="164:350",
	[28484]="164:375",
	[28485]="164:375",
	[28595]="755:305",
	[29157]="755:180",
	[29158]="755:200",
	[29159]="755:280",
	[29160]="755:290",
	[29201]="164:100",
	[29202]="164:200",
	[29203]="164:300",
	[29204]="164:350",
	[29483]="165:340",
	[29485]="165:340",
	[29486]="165:340",
	[29487]="165:340",
	[29488]="165:340",
	[29489]="165:350",
	[29490]="165:350",
	[29491]="165:350",
	[29492]="165:350",
	[29493]="165:350",
	[29494]="165:350",
	[29495]="165:350",
	[29496]="165:350",
	[29497]="165:350",
	[29498]="165:350",
	[29499]="165:350",
	[29500]="165:350",
	[29502]="165:365",
	[29503]="165:365",
	[29504]="165:365",
	[29505]="165:365",
	[29506]="165:365",
	[29507]="165:365",
	[29508]="165:365",
	[29509]="165:365",
	[29510]="165:365",
	[29511]="165:365",
	[29512]="165:365",
	[29514]="165:365",
	[29515]="165:375",
	[29516]="165:375",
	[29517]="165:375",
	[29519]="165:375",
	[29520]="165:375",
	[29521]="165:375",
	[29522]="165:375",
	[29523]="165:375",
	[29524]="165:375",
	[29525]="165:375",
	[29526]="165:375",
	[29527]="165:375",
	[29528]="165:340",
	[29529]="165:365",
	[29530]="165:345",
	[29531]="165:350",
	[29532]="165:370",
	[29533]="165:335",
	[29534]="165:335",
	[29535]="165:365",
	[29536]="165:365",
	[29540]="165:325",
	[29964]="165:260",
	[29970]="165:260",
	[29971]="165:260",
	[29973]="165:330",
	[29974]="165:330",
	[29975]="165:330",
	[30031]="164:375",
	[30032]="164:375",
	[30033]="164:375",
	[30034]="164:375",
	[30035]="197:375",
	[30036]="197:375",
	[30037]="197:375",
	[30038]="197:375",
	[30039]="165:375",
	[30040]="165:375",
	[30041]="165:375",
	[30042]="165:375",
	[30043]="165:375",
	[30044]="165:375",
	[30045]="165:375",
	[30046]="165:375",
	[30069]="164:260",
	[30070]="164:260",
	[30071]="164:260",
	[30072]="164:260",
	[30073]="164:260",
	[30074]="164:330",
	[30076]="164:330",
	[30077]="164:330",
	[30086]="164:330",
	[30087]="164:330",
	[30088]="164:330",
	[30089]="164:330",
	[30093]="164:330",
	[30155]="185:300",
	[30419]="755:75",
	[30420]="755:105",
	[30421]="755:230",
	[30422]="755:265",
	[30459]="197:0",
	[30460]="197:0",
	[30461]="197:0",
	[30463]="197:0",
	[30464]="197:0",
	[30465]="197:0",
	[30542]="202:350",
	[30544]="202:350",
	[30703]="237:0",
	[30804]="755:65",
	[30816]="185:1",
	[30825]="755:360",
	[30831]="197:350",
	[30837]="197:350",
	[30838]="197:360",
	[30839]="197:370",
	[31079]="755:325",
	[31080]="171:325",
	[31154]="755:80",
	[31364]="164:375",
	[31367]="164:375",
	[31368]="164:375",
	[31369]="164:375",
	[31370]="164:375",
	[31371]="164:375",
	[31398]="755:375",
	[31399]="755:375",
	[31672]="185:335",
	[31673]="185:335",
	[31676]="171:345",
	[31677]="171:360",
	[31679]="171:335",
	[31860]="755:325",
	[31861]="755:350",
	[31862]="755:325",
	[31863]="755:350",
	[31864]="755:325",
	[31865]="755:350",
	[31866]="755:325",
	[31867]="755:350",
	[31868]="755:350",
	[31869]="755:325",
	[32062]="171:310",
	[32063]="171:320",
	[32067]="171:320",
	[32068]="171:330",
	[32193]="755:375",
	[32194]="755:375",
	[32195]="755:375",
	[32196]="755:375",
	[32197]="755:375",
	[32198]="755:375",
	[32199]="755:375",
	[32200]="755:375",
	[32201]="755:375",
	[32202]="755:375",
	[32203]="755:375",
	[32204]="755:375",
	[32205]="755:375",
	[32206]="755:375",
	[32207]="755:375",
	[32208]="755:375",
	[32209]="755:375",
	[32210]="755:375",
	[32211]="755:375",
	[32212]="755:375",
	[32213]="755:375",
	[32214]="755:375",
	[32215]="755:375",
	[32216]="755:375",
	[32217]="755:375",
	[32218]="755:375",
	[32219]="755:375",
	[32220]="755:375",
	[32221]="755:375",
	[32222]="755:375",
	[32223]="755:375",
	[32224]="755:375",
	[32225]="755:375",
	[32226]="755:375",
	[32389]="197:375",
	[32390]="197:375",
	[32391]="197:375",
	[32392]="197:375",
	[32393]="165:375",
	[32394]="165:375",
	[32395]="165:375",
	[32396]="165:375",
	[32397]="165:375",
	[32398]="165:375",
	[32399]="165:375",
	[32400]="165:375",
	[32401]="164:375",
	[32402]="164:375",
	[32403]="164:375",
	[32404]="164:375",
	[32409]="755:365",
	[32410]="755:365",
	[32413]="202:335",
	[32420]="197:375",
	[32423]="202:335",
	[32461]="202:350",
	[32472]="202:350",
	[32473]="202:350",
	[32474]="202:350",
	[32475]="202:350",
	[32476]="202:350",
	[32478]="202:350",
	[32479]="202:350",
	[32480]="202:350",
	[32494]="202:350",
	[32495]="202:350",
	[32508]="755:340",
	[32568]="164:375",
	[32570]="164:375",
	[32571]="164:375",
	[32573]="164:375",
	[32574]="165:375",
	[32575]="165:375",
	[32577]="165:375",
	[32579]="165:375",
	[32580]="165:375",
	[32581]="165:375",
	[32582]="165:375",
	[32583]="165:375",
	[32584]="197:375",
	[32585]="197:375",
	[32586]="197:375",
	[32587]="197:375",
	[32756]="202:375",
	[32772]="755:325",
	[32774]="755:330",
	[32776]="755:365",
	[32833]="755:325",
	[32836]="755:350",
	[32839]="171:300",
	[32849]="171:300",
	[32850]="171:300",
	[32851]="171:300",
	[32852]="171:300",
	[32854]="164:365",
	[33048]="185:320",
	[33052]="185:350",
	[33053]="185:350",
	[33092]="202:330",
	[33093]="202:345",
	[33122]="165:360",
	[33131]="755:360",
	[33133]="755:360",
	[33134]="755:360",
	[33135]="755:360",
	[33140]="755:360",
	[33143]="755:360",
	[33144]="755:360",
	[33173]="164:365",
	[33185]="164:335",
	[33204]="165:365",
	[33208]="171:375",
	[33782]="755:350",
	[33791]="164:35",
	[33825]="185:325",
	[33866]="185:300",
	[33867]="185:300",
	[33872]="185:325",
	[33874]="185:300",
	[33924]="185:1",
	[34060]="202:350",
	[34061]="202:375",
	[34085]="197:250",
	[34086]="165:285",
	[34087]="197:250",
	[34099]="165:315",
	[34100]="165:315",
	[34105]="165:350",
	[34106]="165:350",
	[34113]="202:360",
	[34207]="165:350",
	[34220]="755:365",
	[34330]="165:350",
	[34353]="202:375",
	[34354]="202:375",
	[34355]="202:375",
	[34356]="202:375",
	[34357]="202:375",
	[34358]="755:365",
	[34359]="755:365",
	[34360]="755:365",
	[34361]="755:365",
	[34362]="755:365",
	[34363]="755:365",
	[34364]="197:365",
	[34365]="197:365",
	[34366]="197:365",
	[34367]="197:365",
	[34369]="165:365",
	[34370]="165:365",
	[34371]="165:365",
	[34372]="165:365",
	[34373]="165:365",
	[34374]="165:365",
	[34375]="165:365",
	[34376]="165:365",
	[34377]="164:365",
	[34378]="164:365",
	[34379]="164:365",
	[34380]="164:365",
	[34411]="185:325",
	[34440]="171:325",
	[34482]="165:300",
	[34490]="165:360",
	[34504]="202:335",
	[34832]="185:100",
	[34847]="202:375",
	[35128]="186:375",
	[35181]="202:375",
	[35182]="202:375",
	[35183]="202:375",
	[35184]="202:375",
	[35185]="202:375",
	[35315]="755:350",
	[35316]="755:350",
	[35318]="755:350",
	[35501]="755:370",
	[35503]="755:370",
	[35563]="185:250",
	[35565]="185:250",
	[35581]="202:355",
	[35693]="755:375",
	[35694]="755:375",
	[35700]="755:375",
	[35702]="755:375",
	[35703]="755:375",
	[35707]="755:350",
	[35748]="171:375",
	[35749]="171:375",
	[35750]="171:375",
	[35751]="171:375",
	[35758]="755:375",
	[35759]="755:375",
	[35760]="755:375",
	[35761]="755:375",
	[35945]="755:350",
	[37503]="755:375",
	[38225]="197:375",
	[38277]="197:250",
	[38278]="197:245",
})

-- A list of vendors in the game, with their ID numbers
Informant.SetVendors({
	[54]="Corina Steele <Weaponsmith>",
	[66]="Tharynn Bouden <Trade Supplies>",
	[74]="Kurran Steele <Cloth & Leather Armor Merchant>",
	[78]="Janos Hammerknuckle <Weaponsmith>",
	[151]="Brog Hamfist <General Supplies>",
	[152]="Brother Danil <General Supplies>",
	[167]="Morhan Coppertongue <Metalsmith>",
	[190]="Dermot Johns <Cloth & Leather Armor Merchant>",
	[222]="Nillen Andemar <Macecrafter>",
	[225]="Gavin Gnarltree <Weaponsmith>",
	[226]="Morg Gnarltree <Armorer>",
	[227]="Mabel Solaj <General Goods>",
	[228]="Avette Fellwood <Bowyer>",
	[233]="Farmer Saldean <>",
	[258]="Joshua Maclure <Vintner>",
	[274]="Barkeep Hann <Bartender>",
	[277]="Roberto Pupellyverbos <Merlot Connoisseur>",
	[295]="Innkeeper Farley <Innkeeper>",
	[340]="Kendor Kabonka <Master of Cooking Recipes>",
	[372]="Karm Ironquill <Mining Supplies>",
	[384]="Katie Hunter <Horse Breeder>",
	[465]="Barkeep Dobbins <Bartender>",
	[483]="Elaine Trias <Mistress of Cheese>",
	[491]="Quartermaster Lewis <Quartermaster>",
	[734]="Corporal Bluth <Camp Trader>",
	[777]="Amy Davenport <Tradeswoman>",
	[789]="Kimberly Hiett <Fletcher>",
	[790]="Karen Taylor <Blacksmithing & Mining Supplies>",
	[791]="Lindsay Ashlock <General Supplies>",
	[793]="Kara Adams <Shield Crafter>",
	[829]="Adlin Pridedrift <General Supplies>",
	[836]="Durnan Furcutter <Cloth & Leather Armor Merchant>",
	[843]="Gina MacGregor <Trade Supplies>",
	[844]="Antonio Perelli <Traveling Salesman>",
	[894]="Homer Stonefield <Fruit Seller>",
	[896]="Veldan Lightfoot <Leather Armor Merchant>",
	[945]="Rybrad Coldbank <Weaponsmith>",
	[954]="Kat Sampson <Leather Armor Merchant>",
	[955]="Sergeant De Vries <Morale Officer>",
	[956]="Dorin Songblade <Armorer>",
	[958]="Dawn Brightstar <Arcane Goods>",
	[959]="Morley Eberlein <Clothier>",
	[960]="Gunder Thornbush <Tradesman>",
	[980]="Grimnal <Mail & Plate Merchant>",
	[981]="Hartash <Weapon Merchant>",
	[982]="Thultash <Food & Drink Vendor>",
	[983]="Thultazor <Alchemy Supplies & Reagents>",
	[984]="Thralosh <Cloth & Leather Armor Merchant>",
	[989]="Banalash <Trade Supplies>",
	[1104]="Grundel Harkin <Armorer>",
	[1146]="Vharr <Superior Weaponsmith>",
	[1147]="Hragran <Cloth & Leather Armor Merchant>",
	[1148]="Nerrist <Trade Goods>",
	[1149]="Uthok <General Supplies>",
	[1198]="Rallic Finn <Bowyer>",
	[1213]="Godric Rothgar <Armorer & Shieldcrafter>",
	[1214]="Aldren Cordon <Clothier>",
	[1237]="Kazan Mogosh <Food & Drink Merchant>",
	[1238]="Gamili Frosthide <Cloth & Leather Armor Merchant>",
	[1240]="Boran Ironclink <Armorer>",
	[1243]="Hegnar Rumbleshot <Gunsmith>",
	[1247]="Innkeeper Belm <Innkeeper>",
	[1249]="Quartermaster Hudson <Armorer & Shieldcrafter>",
	[1250]="Drake Lindgren <General & Trade Supplies>",
	[1257]="Keldric Boucher <Alchemy Supplies & Reagents>",
	[1273]="Grawn Thromwyn <Weaponsmith>",
	[1275]="Kyra Boucher <Reagents>",
	[1285]="Thurman Mullby <General Goods>",
	[1286]="Edna Mullby <Trade Supplies>",
	[1287]="Marda Weller <Weapons Merchant>",
	[1289]="Gunther Weller <Weapons Merchant>",
	[1291]="Carla Granger <Cloth Armor Merchant>",
	[1292]="Maris Granger <Skinning Trainer>",
	[1294]="Aldric Moore <Mail Armor Merchant>",
	[1295]="Lara Moore <Leather Armor Merchant>",
	[1296]="Felder Stover <Weaponsmith>",
	[1297]="Lina Stover <Bow & Gun Merchant>",
	[1298]="Frederick Stover <Bow & Arrow Merchant>",
	[1299]="Lisbeth Schneider <Clothier>",
	[1301]="Julia Gallina <Wine Vendor>",
	[1302]="Bernard Gump <Florist>",
	[1303]="Felicia Gump <Herbalism Supplies>",
	[1304]="Darian Singh <Fireworks Vendor>",
	[1305]="Jarel Moor <Bartender>",
	[1307]="Charys Yserian <Arcane Trinkets Vendor>",
	[1308]="Owen Vaughn <Reagents>",
	[1309]="Wynne Larson <Robe Merchant>",
	[1310]="Evan Larson <Hatter>",
	[1311]="Joachim Brenlow <Bartender>",
	[1312]="Ardwyn Cailen <Wand Merchant>",
	[1313]="Maria Lumere <Alchemy Supplies>",
	[1314]="Duncan Cullen <Light Armor Merchant>",
	[1315]="Allan Hafgan <Staves Merchant>",
	[1316]="Adair Gilroy <Librarian>",
	[1318]="Jessara Cordell <Enchanting Supplies>",
	[1319]="Bryan Cross <Shield Merchant>",
	[1320]="Seoman Griffith <Leather Armor Merchant>",
	[1321]="Alyssa Griffith <Bag Vendor>",
	[1322]="Maxton Strang <Mail Armor Merchant>",
	[1323]="Osric Strang <Heavy Armor Merchant>",
	[1324]="Heinrich Stone <Blade Merchant>",
	[1325]="Jasper Fel <Shady Dealer>",
	[1326]="Sloan McCoy <Poison Supplies>",
	[1328]="Elly Langston <Barmaid>",
	[1333]="Gerik Koen <Two Handed Weapon Merchant>",
	[1339]="Mayda Thane <Cobbler>",
	[1341]="Wilhelm Strang <Mail Armor Merchant>",
	[1347]="Alexandra Bolero <Tailoring Supplies>",
	[1348]="Gregory Ardus <Staff & Mace Merchant>",
	[1349]="Agustus Moulaine <Mail Armor Merchant>",
	[1350]="Theresa Moulaine <Robe Vendor>",
	[1351]="Brother Cassius <Reagents>",
	[1362]="Gothor Brumn <Armorer>",
	[1381]="Krakk <Superior Armorer>",
	[1407]="Sranda <Light Armor & Weapons Merchant>",
	[1441]="Brak Durnad <Weaponsmith>",
	[1448]="Neal Allen <Engineering Supplies & General Goods>",
	[1450]="Brahnmar <Armorer>",
	[1452]="Gruham Rumdnul <General Supplies>",
	[1453]="Dewin Shimmerdawn <Alchemy Supplies>",
	[1454]="Jennabink Powerseam <Tailoring Supplies & Specialty Goods>",
	[1456]="Kersok Prond <Tradesman>",
	[1457]="Samor Festivus <Shady Dealer>",
	[1459]="Naela Trance <Bowyer>",
	[1460]="Unger Statforth <Horse Breeder>",
	[1461]="Murndan Derth <Gunsmith>",
	[1462]="Edwina Monzor <Fletcher>",
	[1463]="Falkan Armonis <Reagents>",
	[1464]="Innkeeper Helbrek <Innkeeper>",
	[1465]="Drac Roughcut <Tradesman>",
	[1469]="Vrok Blunderblast <Gunsmith>",
	[1471]="Jannos Ironwill <Superior Macecrafter>",
	[1474]="Rann Flamespinner <Tailoring Supplies>",
	[1645]="Quartermaster Hicks <Master Weaponsmith>",
	[1650]="Terry Palin <Lumberjack>",
	[1668]="William MacGregor <Bowyer>",
	[1669]="Defias Profiteer <Free Wheeling Merchant>",
	[1670]="Mike Miller <Bread Merchant>",
	[1671]="Lamar Veisilli <Fruit Seller>",
	[1672]="Lohgan Eva <Tailoring Supplies>",
	[1673]="Alyssa Eva <Reagents>",
	[1678]="Vernon Hale <Fishing Supplies>",
	[1682]="Yanni Stoutheart <General Supplies>",
	[1684]="Khara Deepwater <Fishing Supplies>",
	[1685]="Xandar Goodbeard <General Supplies>",
	[1686]="Irene Sureshot <Gunsmith>",
	[1687]="Cliff Hadin <Bowyer>",
	[1690]="Thrawn Boltar <Blacksmithing Supplies>",
	[1691]="Kreg Bilmn <General Supplies>",
	[1692]="Golorn Frostbeard <Tradesman>",
	[1694]="Loslor Rudge <Engineering Supplies>",
	[1695]="Rendow <Leather Armor Merchant>",
	[1697]="Keeg Gibn <Ale & Wine>",
	[1698]="Frast Dokner <Apprentice Weaponsmith>",
	[2046]="Andrew Krighton <Armorer & Shieldcrafter>",
	[2084]="Natheril Raincaller <General Goods>",
	[2113]="Archibald Kava <Cloth & Leather Armor Merchant>",
	[2115]="Joshua Kien <General Supplies>",
	[2116]="Blacksmith Rand <Apprentice Armorer>",
	[2117]="Harold Raims <Apprentice Weaponsmith>",
	[2118]="Abigail Shiel <Trade Supplies>",
	[2134]="Mrs. Winters <General Supplies>",
	[2135]="Abe Winters <Apprentice Armorer>",
	[2136]="Oliver Dwor <Apprentice Weaponsmith>",
	[2137]="Eliza Callen <Leather Armor Merchant>",
	[2140]="Edwin Harly <General Supplies>",
	[2225]="Zora Guthrek <Trade Goods>",
	[2264]="Hillsbrad Tailor <>",
	[2265]="Hillsbrad Apprentice Blacksmith <>",
	[2303]="Lyranne Feathersong <Food & Drink>",
	[2352]="Innkeeper Anderson <Innkeeper>",
	[2357]="Merideth Carlson <Horse Breeder>",
	[2364]="Neema <Waitress>",
	[2365]="Bront Coldcleave <Butcher>",
	[2366]="Barkeep Kelly <Bartender>",
	[2380]="Nandar Branson <Alchemy Supplies>",
	[2381]="Micha Yance <Trade Goods>",
	[2383]="Lindea Rabonne <Fishing Supplies>",
	[2388]="Innkeeper Shay <Innkeeper>",
	[2393]="Christoph Jeffcoat <Tradesman>",
	[2394]="Mallen Swain <Tailoring Supplies>",
	[2397]="Derak Nightfall <Cook>",
	[2401]="Kayren Soothallow <General Goods>",
	[2480]="Bro\'kin <Alchemy Supplies>",
	[2481]="Bliztik <Alchemy Supplies>",
	[2482]="Zarena Cromwind <Superior Weaponsmith>",
	[2483]="Jaquilina Dramet <Superior Axecrafter>",
	[2622]="Sly Garrett <Shady Goods>",
	[2626]="Old Man Heming <Fishing Supplies>",
	[2663]="Narkk <Pirate Supplies>",
	[2664]="Kelsey Yance <Cook>",
	[2668]="Danielle Zipstitch <Tailoring Supplies>",
	[2669]="Sheri Zipstitch <Tailoring Supplies>",
	[2670]="Xizk Goodstitch <Tailoring Supplies>",
	[2672]="Cowardly Crosby <Tailoring Supplies>",
	[2679]="Wenna Silkbeard <Special Goods Dealer>",
	[2682]="Fradd Swiftgear <Engineering Supplies>",
	[2683]="Namdo Bizzfizzle <Engineering Supplies>",
	[2684]="Rizz Loosebolt <Engineering Supplies>",
	[2685]="Mazk Snipeshot <Engineering Supplies>",
	[2687]="Gnaz Blunderflame <Engineering Supplies>",
	[2688]="Ruppo Zipcoil <Engineering Supplies>",
	[2697]="Clyde Ranthal <Leatherworking Supplies>",
	[2698]="George Candarte <Leatherworking Supplies>",
	[2699]="Rikqiz <Leatherworking Supplies>",
	[2803]="Malygen <General Goods>",
	[2805]="Deneb Walker <Scrolls & Potions>",
	[2806]="Bale <General Goods>",
	[2808]="Vikki Lonsav <General Goods>",
	[2810]="Hammon Karwn <Superior Tradesman>",
	[2812]="Drovnar Strongbrew <Alchemy Supplies>",
	[2814]="Narj Deepslice <Butcher>",
	[2816]="Androd Fadran <Leatherworking Supplies>",
	[2819]="Tunkk <Leatherworking Supplies>",
	[2820]="Graud <General Goods>",
	[2821]="Keena <Trade Goods>",
	[2832]="Nixxrax Fillamug <Food & Drink>",
	[2838]="Crazk Sparks <Fireworks Merchant>",
	[2839]="Haren Kanmae <Superior Bowyer>",
	[2840]="Kizz Bluntstrike <Macecrafter>",
	[2842]="Wigcik <Superior Fisherman>",
	[2843]="Jutak <Blade Trader>",
	[2844]="Hurklor <Blacksmithing Supplies>",
	[2845]="Fargon Mortalak <Superior Armorer>",
	[2846]="Blixrez Goodstitch <Leatherworking Supplies>",
	[2847]="Jansen Underwood <Blacksmithing Supplies>",
	[2848]="Glyx Brewright <Alchemy Supplies>",
	[2849]="Qixdi Goodstitch <Cloth Armor & Accessories>",
	[2908]="Grawl <General Goods>",
	[2997]="Jyn Stonehoof <Weapons Merchant>",
	[2999]="Taur Stonehoof <Blacksmithing Supplies>",
	[3000]="Gibbert <Weapon Merchant>",
	[3002]="Kurm Stonehoof <Mining Supplies>",
	[3003]="Fyr Mistrunner <Bread Vendor>",
	[3005]="Mahu <Leatherworking & Tailoring Supplies>",
	[3010]="Mani Winterhoof <Alchemy Supplies>",
	[3012]="Nata Dawnstrider <Enchanting Supplies>",
	[3014]="Nida Winterhoof <Herbalism Supplies>",
	[3015]="Kuna Thunderhorn <Bowyer & Fletching Goods>",
	[3016]="Tand <Basket Weaver>",
	[3017]="Nan Mistrunner <Fruit Vendor>",
	[3018]="Hogor Thunderhoof <Guns Merchant>",
	[3019]="Delgo Ragetotem <Axe Merchant>",
	[3020]="Etu Ragetotem <Mace & Staff Merchant>",
	[3021]="Kard Ragetotem <Sword & Dagger Merchant>",
	[3022]="Sunn Ragetotem <Staff Merchant>",
	[3023]="Sura Wildmane <War Harness Vendor>",
	[3025]="Kaga Mistrunner <Meat Vendor>",
	[3027]="Naal Mistrunner <Cooking Supplies>",
	[3029]="Sewa Mistrunner <Fishing Supplies>",
	[3044]="Miles Welsh <Priest Trainer>",
	[3053]="Synge <Gun Merchant>",
	[3072]="Kawnie Softbreeze <General Goods>",
	[3073]="Marjak Keenblade <Weaponsmith>",
	[3074]="Varia Hardhide <Leather Armor Merchant>",
	[3075]="Bronk Steelrage <Armorer & Shieldcrafter>",
	[3076]="Moorat Longstride <General Goods>",
	[3077]="Mahnott Roughwound <Weaponsmith>",
	[3078]="Kennah Hawkseye <Gunsmith>",
	[3079]="Varg Windwhisper <Leather Armor Merchant>",
	[3080]="Harant Ironbrace <Armorer & Shieldcrafter>",
	[3081]="Wunna Darkmane <Trade Goods>",
	[3085]="Gloria Femmel <Cooking Supplies>",
	[3086]="Gretchen Vogel <Waitress>",
	[3088]="Henry Chapal <Gunsmith>",
	[3089]="Sherman Femmel <Butcher>",
	[3090]="Gerald Crawley <Poison Supplies>",
	[3091]="Franklin Hamar <Tailoring Supplies>",
	[3092]="Tagain <Cloth Armor Merchant>",
	[3093]="Grod <Leather Armor Merchant>",
	[3095]="Fela <Heavy Armor Merchant>",
	[3096]="Captured Servant of Azora <Specialist Tailoring Supplies>",
	[3097]="Bernard Brubaker <Leather Armor Merchant>",
	[3133]="Herble Baubbletump <Engineering & Mining Supplies>",
	[3134]="Kzixx <Rare Goods>",
	[3135]="Malissa <Poison Supplies>",
	[3138]="Scott Carevin <Mushroom Seller>",
	[3158]="Duokna <General Goods>",
	[3159]="Kzan Thornslash <Weaponsmith>",
	[3160]="Huklah <Cloth & Leather Armor Merchant>",
	[3161]="Rarc <Armorer & Shieldcrafter>",
	[3162]="Burdrak Harglhelm <Leather Armor Merchant>",
	[3163]="Uhgar <Weaponsmith>",
	[3164]="Jark <General Goods>",
	[3165]="Ghrawt <Bowyer>",
	[3166]="Cutac <Cloth & Leather Armor Merchant>",
	[3167]="Wuark <Armorer & Shieldcrafter>",
	[3168]="Flakk <Trade Supplies>",
	[3177]="Turuk Amberstill <Dwarven Weaponsmith>",
	[3178]="Stuart Fleming <Fishing Supplies>",
	[3180]="Dark Iron Entrepreneur <Speciality Goods>",
	[3186]="K\'waii <General Goods>",
	[3187]="Tai\'tasi <Trade Supplies>",
	[3291]="Greishan Ironstove <Traveling Merchant>",
	[3298]="Gabrielle Chase <Food & Drink>",
	[3312]="Olvia <Meat Vendor>",
	[3313]="Trak\'gen <General Goods>",
	[3314]="Urtharo <Weapon Merchant>",
	[3315]="Tor\'phan <Cloth & Leather Armor Merchant>",
	[3316]="Handor <Cloth & Leather Armor Merchant>",
	[3317]="Ollanus <Light Armor Merchant>",
	[3319]="Sana <Mail Armor Merchant>",
	[3321]="Morgum <Leather Armor Merchant>",
	[3322]="Kaja <Guns & Ammunition>",
	[3323]="Horthus <Reagents>",
	[3329]="Kor\'jus <Mushroom Vendor>",
	[3330]="Muragus <Staff Merchant>",
	[3331]="Kareth <Blade Merchant>",
	[3333]="Shankys <Fishing Supplies>",
	[3334]="Rekkul <Poison Supplies>",
	[3335]="Hagrus <Reagents>",
	[3342]="Shan\'ti <Fruit Vendor>",
	[3343]="Grelkor <Blacksmithing Supplies>",
	[3346]="Kithas <Enchanting Supplies>",
	[3348]="Kor\'geld <Alchemy Supplies>",
	[3349]="Ukra\'nor <Staff Merchant>",
	[3350]="Asoran <General Goods>",
	[3351]="Magenius <Reagents>",
	[3356]="Sumi <Blacksmithing Supplies>",
	[3358]="Gorina <Mining Supplies>",
	[3359]="Kiro <War Harness Maker>",
	[3360]="Koru <Mace & Staves Vendor>",
	[3361]="Shoma <Weapon Vendor>",
	[3364]="Borya <Tailoring Supplies>",
	[3366]="Tamar <Leatherworking Supplies>",
	[3367]="Felika <Trade Supplies>",
	[3368]="Borstan <Meat Vendor>",
	[3369]="Gotri <Bag Vendor>",
	[3400]="Xen\'to <Cooking Supplies>",
	[3405]="Zeal\'aya <Herbalism Supplies>",
	[3409]="Zendo\'jian <Weapon Vendor>",
	[3410]="Jin\'sora <Bow Merchant>",
	[3411]="Denni\'ka <Butcher>",
	[3413]="Sovik <Engineering Supplies>",
	[3477]="Hraq <Blacksmithing Supplies>",
	[3479]="Nargal Deatheye <Weaponsmith>",
	[3480]="Moorane Hearthgrain <Baker>",
	[3481]="Barg <General Supplies>",
	[3482]="Tari\'qa <Trade Supplies>",
	[3483]="Jahan Hawkwing <Leather & Mail Armor Merchant>",
	[3485]="Wrahk <Tailoring Supplies>",
	[3487]="Kalyimah Stormcloud <Bags & Sacks>",
	[3488]="Uthrok <Bowyer & Gunsmith>",
	[3489]="Zargh <Butcher>",
	[3490]="Hula\'mahi <Reagents, Herbs & Poison Supplies>",
	[3491]="Ironzar <Weaponsmith>",
	[3492]="Vexspindle <Cloth & Leather Armor Merchant>",
	[3493]="Grazlix <Armorer & Shieldcrafter>",
	[3495]="Gagsprocket <Engineering Supplies>",
	[3497]="Kilxx <Fisherman>",
	[3498]="Jazzik <General Supplies>",
	[3499]="Ranik <Trade Supplies>",
	[3500]="Tarhus <Reagents>",
	[3518]="Thomas Miller <Baker>",
	[3522]="Constance Brisboise <Apprentice Clothier>",
	[3528]="Pyrewood Armorer <>",
	[3530]="Pyrewood Tailor <>",
	[3532]="Pyrewood Leatherworker <>",
	[3534]="Wallace the Blind <Weaponsmith>",
	[3536]="Kris Legace <Freewheeling Tradeswoman>",
	[3537]="Zixil <Merchant Supreme>",
	[3539]="Ott <Weaponsmith>",
	[3540]="Hal McAllister <Fish Merchant>",
	[3541]="Sarah Raycroft <General Goods>",
	[3542]="Jaysin Lanyda <Poisons & Reagents>",
	[3543]="Robert Aebischer <Superior Armorsmith>",
	[3544]="Jason Lemieux <Mushroom Seller>",
	[3546]="Bernie Heisten <Food & Drink>",
	[3547]="Hamlin Atkins <Mushroom Farmer>",
	[3548]="Selina Weston <Alchemy & Herbalism Supplies>",
	[3550]="Martine Tramblay <Fishing Supplies>",
	[3551]="Patrice Dwyer <Poison Supplies>",
	[3552]="Alexandre Lefevre <Leather Armor Merchant>",
	[3553]="Sebastian Meloche <Armorer>",
	[3554]="Andrea Boynton <Clothier>",
	[3556]="Andrew Hilbert <Trade Supplies>",
	[3561]="Kyrai <Poison Supplies>",
	[3562]="Alaindia <Reagents>",
	[3572]="Zizzek <Fishing Supplies>",
	[3577]="Dalaran Brewmaster <>",
	[3578]="Dalaran Miner <>",
	[3587]="Lyrai <General Supplies>",
	[3588]="Khardan Proudblade <Weaponsmith>",
	[3589]="Keina <Bowyer>",
	[3590]="Janna Brightmoon <Clothier>",
	[3591]="Freja Nightwing <Leather Armor Merchant>",
	[3592]="Andiss <Armorer & Shieldcrafter>",
	[3608]="Aldia <General Supplies>",
	[3609]="Shalomon <Weaponsmith>",
	[3610]="Jeena Featherbow <Bowyer>",
	[3611]="Brannol Eaglemoon <Clothier>",
	[3612]="Sinda <Leather Armor Merchant>",
	[3613]="Meri Ironweave <Armorer & Shieldcrafter>",
	[3614]="Narret Shadowgrove <Trade Supplies>",
	[3621]="Kurll <Food & Drink>",
	[3625]="Rarck <General Goods>",
	[3658]="Lizzarik <Weapon Dealer>",
	[3682]="Vrang Wildgore <Weaponsmith & Armorcrafter>",
	[3683]="Kiknikle <Stylish Clothier>",
	[3684]="Pizznukle <Leather Armor Merchant>",
	[3689]="Laer Stepperunner <Food & Drink>",
	[3700]="Jadenvis Seawatcher <Reagents>",
	[3705]="Gahroot <Butcher>",
	[3708]="Gruna <Food & Drink>",
	[3779]="Syurana <Trade Supplies>",
	[3881]="Grimtak <Butcher>",
	[3882]="Zlagk <Butcher>",
	[3883]="Moodan Sungrain <Baker>",
	[3884]="Jhawna Oatwind <Baker>",
	[3933]="Hai\'zan <Butcher>",
	[3934]="Innkeeper Boorand Plainswind <Innkeeper>",
	[3935]="Toddrick <Butcher>",
	[3937]="Kira Songshine <Traveling Baker>",
	[3948]="Honni Goldenoat <Baker>",
	[3951]="Bhaldaran Ravenshade <Bowyer>",
	[3952]="Aeolynn <Clothier>",
	[3953]="Tandaan Lightmane <Leather Armor Merchant>",
	[3954]="Dalria <Trade Goods>",
	[3955]="Shandrina <Trade Goods>",
	[3956]="Harklan Moongrove <Alchemy Supplies>",
	[3958]="Lardan <Leatherworking Supplies>",
	[3959]="Nantar <Baker>",
	[3960]="Ulthaan <Butcher>",
	[3961]="Maliynn <Food & Drink Vendor>",
	[3962]="Haljan Oakheart <General Goods>",
	[3969]="Fahran Silentblade <Tools & Supplies>",
	[3970]="Llana <Reagent Supplies>",
	[4043]="Galthuk <Two-Handed Weapons Merchant>",
	[4082]="Grawnal <General Goods>",
	[4083]="Jeeda <Apprentice Witch Doctor>",
	[4084]="Chylina <General Supplies>",
	[4085]="Nizzik <Venture Armor Salesman>",
	[4086]="Veenix <Venture Co. Merchant>",
	[4164]="Cylania <Night Elf Armorer>",
	[4165]="Elissa Dumas <Portal Trainer>",
	[4167]="Dendrythis <Food & Drink Vendor>",
	[4168]="Elynna <Tailoring Supplies>",
	[4169]="Jaeana <Meat Vendor>",
	[4170]="Ellandrieth <General Goods>",
	[4171]="Merelyssa <Blade Merchant>",
	[4172]="Anadyia <Robe Vendor>",
	[4173]="Landria <Bow Merchant>",
	[4175]="Vinasia <Cloth Armor Merchant>",
	[4177]="Melea <Mail Armor Merchant>",
	[4180]="Ealyshia Dewwhisper <Two Handed Weapon Merchant>",
	[4181]="Fyrenna <Food & Drink Vendor>",
	[4182]="Dalmond <General Goods>",
	[4183]="Naram Longclaw <Weaponsmith>",
	[4184]="Geenia Sunshadow <Speciality Dress Maker>",
	[4185]="Shaldyn <Clothier>",
	[4186]="Mavralyn <Leather Armor & Leatherworking Supplies>",
	[4187]="Harlon Thornguard <Armorer & Shieldsmith>",
	[4188]="Illyanie <Cloth Armor Merchant>",
	[4189]="Valdaron <Tailoring Supplies>",
	[4190]="Kyndri <Baker>",
	[4191]="Allyndia <Food & Drink Vendor>",
	[4192]="Taldan <Drink Vendor>",
	[4194]="Ullanna <Trade Supplies>",
	[4195]="Tiyani <Food & Drink Vendor>",
	[4200]="Laird <Fish Vendor>",
	[4203]="Ariyell Skyshadow <Weapon Merchant>",
	[4216]="Chardryn <Herbalism Supplies>",
	[4217]="Mathrengyl Bearwalker <Druid Trainer>",
	[4220]="Cyroen <Reagents>",
	[4221]="Talaelar <Fish Vendor>",
	[4222]="Voloren <Fishing Supplies>",
	[4223]="Fyldan <Cooking Supplies>",
	[4225]="Saenorion <Leatherworking Supplies>",
	[4226]="Ulthir <Alchemy Supplies>",
	[4228]="Vaean <Enchanting Supplies>",
	[4229]="Mythrin\'dir <Trade Supplies>",
	[4230]="Yldan <Bag Merchant>",
	[4231]="Kieran <Weapon Merchant>",
	[4232]="Glorandiir <Axe Merchant>",
	[4233]="Mythidan <Mace & Staff Merchant>",
	[4234]="Andrus <Staff Merchant>",
	[4235]="Turian <Thrown Weapons Merchant>",
	[4236]="Cyridan <Leather Armor Merchant>",
	[4240]="Caynrus <Shield Merchant>",
	[4241]="Mydrannul <General Goods>",
	[4255]="Brogus Thunderbrew <Food & Drink>",
	[4256]="Golnir Bouldertoe <Mining Supplies>",
	[4257]="Lana Thunderbrew <Blacksmithing Supplies>",
	[4259]="Thurgrum Deepforge <Blacksmithing Supplies>",
	[4265]="Nyoma <Cooking Supplies>",
	[4266]="Danlyia <Food & Drink Vendor>",
	[4305]="Kriggon Talsone <Fisherman>",
	[4307]="Heldan Galesong <Fisherman>",
	[4453]="Wizzle Brassbolts <>",
	[4553]="Ronald Burch <Cooking Supplies>",
	[4554]="Tawny Grisette <Mushroom Vendor>",
	[4555]="Eleanor Rusk <General Goods>",
	[4556]="Gordon Wendham <Weapons Merchant>",
	[4557]="Louis Warren <Weapons Merchant>",
	[4558]="Lauren Newcomb <Light Armor Merchant>",
	[4559]="Timothy Weldon <Heavy Armor Merchant>",
	[4560]="Walter Ellingson <Heavy Armor Merchant>",
	[4561]="Daniel Bartlett <Trade Supplies>",
	[4562]="Thomas Mordan <Reagents>",
	[4569]="Charles Seaton <Blade Merchant>",
	[4570]="Sydney Upton <Staff Merchant>",
	[4571]="Morley Bates <Fungus Vendor>",
	[4574]="Lizbeth Cromwell <Fishing Supplies>",
	[4575]="Hannah Akeley <Reagents>",
	[4577]="Millie Gregorian <Tailoring Supplies>",
	[4580]="Lucille Castleton <Robe Vendor>",
	[4581]="Salazar Bloch <Book Dealer>",
	[4585]="Ezekiel Graves <Poison Supplies>",
	[4587]="Elizabeth Van Talen <Engineering Supplies>",
	[4589]="Joseph Moore <Leatherworking Supplies>",
	[4590]="Jonathan Chambers <Bag Vendor>",
	[4592]="Nathaniel Steenwick <Thrown Weapons Merchant>",
	[4597]="Samuel Van Brunt <Blacksmithing Supplies>",
	[4599]="Sarah Killian <Mining Supplies>",
	[4600]="Geoffrey Hartwell <Weapon Merchant>",
	[4601]="Francis Eliot <Weapon Merchant>",
	[4602]="Benijah Fenner <Weapon Merchant>",
	[4603]="Nicholas Atwood <Gun Merchant>",
	[4604]="Abigail Sawyer <Bow Merchant>",
	[4610]="Algernon <Alchemy Supplies>",
	[4615]="Katrina Alliestar <Herbalism Supplies>",
	[4617]="Thaddeus Webb <Enchanting Supplies>",
	[4775]="Felicia Doan <Trade Supplies>",
	[4782]="Truk Wildbeard <Bartender>",
	[4875]="Turhaw <Butcher>",
	[4876]="Jawn Highmesa <General Goods>",
	[4877]="Jandia <Trade Supplies>",
	[4878]="Montarr <Lorekeeper>",
	[4879]="Ogg\'marr <Butcher>",
	[4883]="Krak <Armorer>",
	[4884]="Zulrg <Weaponsmith>",
	[4885]="Gregor MacVince <Horse Breeder>",
	[4886]="Hans Weston <Armorer & Shieldsmith>",
	[4888]="Marie Holdston <Weaponsmith>",
	[4889]="Torq Ironblast <Gunsmith>",
	[4890]="Piter Verance <Weaponsmith & Armorer>",
	[4891]="Dwane Wertle <Chef>",
	[4892]="Jensen Farran <Bowyer>",
	[4893]="Bartender Lillian <Bartender>",
	[4894]="Craig Nollward <Cook>",
	[4896]="Charity Mipsy <General Goods>",
	[4897]="Helenia Olden <Trade Supplies>",
	[4899]="Uma Bartulm <Herbalism & Alchemy Supplies>",
	[4954]="Uttnar <Butcher>",
	[4981]="Ben Trias <Apprentice of Cheese>",
	[5049]="Lyesa Steelbrow <Guild Tabard Vendor>",
	[5100]="Fillius Fizzlespinner <Trade Supplies>",
	[5101]="Bryllia Ironbrand <General Goods>",
	[5102]="Dolman Steelfury <Weapon Merchant>",
	[5103]="Grenil Steelfury <Weapon Merchant>",
	[5106]="Bromiir Ormsen <Heavy Armor Merchant>",
	[5107]="Mangorn Flinthammer <Heavy Armor Merchant>",
	[5108]="Raena Flinthammer <Light Armor Merchant>",
	[5109]="Myra Tyrngaarde <Bread Vendor>",
	[5110]="Barim Jurgenstaad <Reagents>",
	[5111]="Innkeeper Firebrew <Innkeeper>",
	[5112]="Gwenna Firebrew <Barmaid>",
	[5119]="Hegnar Swiftaxe <Axe Merchant>",
	[5120]="Brenwyn Wintersteel <Blade Merchant>",
	[5121]="Kelomir Ironhand <Maces & Staves>",
	[5122]="Skolmin Goldfury <Bow Merchant>",
	[5123]="Bretta Goldfury <Gun Merchant>",
	[5124]="Sognar Cliffbeard <Meat Vendor>",
	[5125]="Dolkin Craghelm <Mail Armor Merchant>",
	[5126]="Olthran Craghelm <Heavy Armor Merchant>",
	[5128]="Bombus Finespindle <Leatherworking Supplies>",
	[5129]="Lissyphus Finespindle <Light Armor Merchant>",
	[5132]="Pithwick <Bag Vendor>",
	[5133]="Harick Boulderdrum <Wands Merchant>",
	[5134]="Jonivera Farmountain <General Goods>",
	[5135]="Svalbrad Farmountain <Trade Goods>",
	[5138]="Gwina Stonebranch <Herbalism Supplies>",
	[5139]="Kurdrum Barleybeard <Reagents & Poison Supplies>",
	[5140]="Edris Barleybeard <Barmaid>",
	[5151]="Ginny Longberry <Reagents>",
	[5152]="Bingus <Weapon Merchant>",
	[5154]="Poranna Snowbraid <Tailoring Supplies>",
	[5155]="Ingrys Stonebrow <Cloth Armor Merchant>",
	[5156]="Maeva Snowbraid <Robe Merchant>",
	[5158]="Tilli Thistlefuzz <Enchanting Supplies>",
	[5160]="Emrul Riknussun <Cooking Supplies>",
	[5162]="Tansy Puddlefizz <Fishing Supplies>",
	[5163]="Burbik Gearspanner <Trade Supplies>",
	[5169]="Tynnus Venomsprout <Shady Dealer>",
	[5170]="Hjoldir Stoneblade <Blade Merchant>",
	[5173]="Alexander Calder <Warlock Trainer>",
	[5175]="Gearcutter Cogspinner <Engineering Supplies>",
	[5178]="Soolie Berryfizz <Alchemy Supplies>",
	[5188]="Garyl <Tabard Vendor>",
	[5189]="Thrumn <Tabard Vendor>",
	[5190]="Merill Pleasance <Tabard Vendor>",
	[5191]="Shalumon <Tabard Vendor>",
	[5193]="Rebecca Laughlin <Tabard Vendor>",
	[5411]="Krinkle Goodsteel <Blacksmithing Supplies>",
	[5483]="Erika Tate <Cooking Supplies>",
	[5494]="Catherine Leland <Fishing Supplies>",
	[5503]="Eldraeith <Herbalism Supplies>",
	[5508]="Strumner Flintheel <Armorer>",
	[5509]="Kathrum Axehand <Axe Merchant>",
	[5510]="Thulman Flintcrag <Guns Vendor>",
	[5512]="Kaita Deepforge <Blacksmithing Supplies>",
	[5514]="Brooke Stonebraid <Mining Supplies>",
	[5519]="Billibub Cogspinner <Engineering Supplies>",
	[5520]="Spackle Thornberry <Demon Trainer>",
	[5565]="Jillian Tanner <Leatherworking Supplies>",
	[5569]="Fizzlebang Booms <Fireworks Vendor>",
	[5570]="Bruuk Barleybeard <Bartender>",
	[5594]="Alchemist Pestlezugg <Alchemy Supplies>",
	[5611]="Barkeep Morag <>",
	[5620]="Bartender Wental <Food & Drink>",
	[5688]="Innkeeper Renee <Innkeeper>",
	[5698]="Joanna Whitehall <>",
	[5748]="Killian Sanatha <Fisherman>",
	[5749]="Kayla Smithe <Demon Trainer>",
	[5750]="Gina Lang <Demon Trainer>",
	[5753]="Martha Strain <Demon Trainer>",
	[5754]="Zane Bradford <Wand Vendor>",
	[5757]="Lilly <Enchanting Supplies>",
	[5758]="Leo Sarn <Enchanting Supplies>",
	[5783]="Kalldan Felmoon <Specialist Leatherworking Supplies>",
	[5812]="Tumi <Heavy Armor Merchant>",
	[5814]="Innkeeper Thulbek <Innkeeper>",
	[5815]="Kurgul <Demon Trainer>",
	[5816]="Katis <Wand Merchant>",
	[5817]="Shimra <Trade Supplies>",
	[5819]="Mirelle Tremayne <Heavy Armor Merchant>",
	[5820]="Gillian Moore <Leather Armor Merchant>",
	[5821]="Sheldon Von Croy <Cloth Armor Merchant>",
	[5848]="Malgin Barleybrew <Bael'dun Morale Officer>",
	[5870]="Krond <Butcher>",
	[5871]="Larhka <Beverage Merchant>",
	[5886]="Gwyn Farrow <Mushroom Merchant>",
	[5940]="Harn Longcast <Fishing Supplies>",
	[5942]="Zansoa <Fishing Supplies>",
	[5944]="Yonada <Tailoring & Leatherworking Supplies>",
	[6027]="Kitha <Demon Trainer>",
	[6028]="Burkrum <Heavy Armor Merchant>",
	[6091]="Dellylah <Food & Drink Vendor>",
	[6272]="Innkeeper Janene <Innkeeper>",
	[6298]="Thelgrum Stonehammer <Mining Supplies>",
	[6300]="Elisa Steelhand <Blacksmithing Supplies>",
	[6301]="Gorbold Steelhand <Trade Supplies>",
	[6328]="Dannie Fizzwizzle <Demon Trainer>",
	[6373]="Dane Winslow <Demon Trainer>",
	[6374]="Cylina Darkheart <Demon Trainer>",
	[6376]="Wren Darkspring <Demon Trainer>",
	[6382]="Jubahl Corpseseeker <Demon Trainer>",
	[6495]="Riznek <Drink Vendor>",
	[6496]="Brivelthwerp <Ice Cream Vendor>",
	[6567]="Ghok\'kah <Tailoring Supplies>",
	[6568]="Vizzklick <Tailoring Supplies>",
	[6574]="Jun\'ha <Tailoring Supplies>",
	[6576]="Brienna Starglow <Tailoring Supplies>",
	[6727]="Innkeeper Brianna <Innkeeper>",
	[6730]="Jinky Twizzlefixxit <Engineering Supplies>",
	[6731]="Harlown Darkweave <Leatherworking Supplies>",
	[6734]="Innkeeper Hearthstove <Innkeeper>",
	[6735]="Innkeeper Saelienne <Innkeeper>",
	[6736]="Innkeeper Keldamyr <Innkeeper>",
	[6737]="Innkeeper Shaussiy <Innkeeper>",
	[6738]="Innkeeper Kimlya <Innkeeper>",
	[6739]="Innkeeper Bates <Innkeeper>",
	[6740]="Innkeeper Allison <Innkeeper>",
	[6741]="Innkeeper Norman <Innkeeper>",
	[6746]="Innkeeper Pala <Innkeeper>",
	[6747]="Innkeeper Kauth <Innkeeper>",
	[6777]="Zan Shivsproket <Speciality Engineer>",
	[6779]="Smudge Thunderwood <Poison Supplies>",
	[6790]="Innkeeper Trelayne <Innkeeper>",
	[6791]="Innkeeper Wiley <Innkeeper>",
	[6807]="Innkeeper Skindle <Innkeeper>",
	[6928]="Innkeeper Grosk <Innkeeper>",
	[6929]="Innkeeper Gryshka <Innkeeper>",
	[6930]="Innkeeper Karakul <Innkeeper>",
	[7485]="Nargatt <Food & Drink>",
	[7714]="Innkeeper Byula <Innkeeper>",
	[7731]="Innkeeper Jayka <Innkeeper>",
	[7733]="Innkeeper Fizzgrimble <Innkeeper>",
	[7736]="Innkeeper Shyria <Innkeeper>",
	[7737]="Innkeeper Greul <Innkeeper>",
	[7744]="Innkeeper Thulfram <Innkeeper>",
	[7852]="Pratt McGrubben <Leatherworking Supplies>",
	[7854]="Jangdor Swiftstrider <Leatherworking Supplies>",
	[7879]="Quintis Jonespyre <>",
	[7940]="Darnall <Tailoring Supplies>",
	[7941]="Mardrack Greenwell <Food & Drink>",
	[7942]="Faralorn <General Supplies>",
	[7943]="Harklane <Fish Vendor>",
	[7945]="Savanne <Fishing Supplies>",
	[7947]="Vivianna <Trade Supplies>",
	[7976]="Thalgus Thunderfist <Weapon Merchant>",
	[7978]="Bimble Longberry <Fruit Vendor>",
	[8116]="Ziggle Sparks <Holiday Fireworks Vendor>",
	[8117]="Wizbang Booms <Holiday Fireworks Vendor>",
	[8118]="Lillian Singh <Holiday Fireworks Vendor>",
	[8121]="Jaxxil Sparks <Holiday Fireworks Vendor>",
	[8122]="Kizzak Sparks <Holiday Fireworks Vendor>",
	[8125]="Dirge Quikcleave <Butcher>",
	[8129]="Wrinkle Goodsteel <Superior Armorer>",
	[8131]="Blizrik Buckshot <Gunsmith>",
	[8137]="Gikkix <Fisherman>",
	[8139]="Jabbey <General Goods>",
	[8143]="Loorana <Food & Drink>",
	[8145]="Sheendra Tallgrass <Trade Supplies>",
	[8150]="Janet Hommers <Food & Drink>",
	[8152]="Harnor <Food & Drink>",
	[8157]="Logannas <Alchemy Supplies>",
	[8158]="Bronk <Alchemy Supplies>",
	[8159]="Worb Strongstitch <Light Armor Merchant>",
	[8160]="Nioma <Leatherworking Supplies>",
	[8161]="Harggan <Blacksmithing Supplies>",
	[8176]="Gharash <Blacksmithing Supplies>",
	[8177]="Rartar <Alchemy Supplies>",
	[8178]="Nina Lightbrew <Alchemy Supplies>",
	[8305]="Kixxle <Potions & Herbs>",
	[8307]="Tarban Hearthgrain <Baker>",
	[8358]="Hewa <Cloth Armor Merchant>",
	[8359]="Ahanu <Leather Armor Merchant>",
	[8360]="Elki <Mail Armor Merchant>",
	[8361]="Chepi <Reagents>",
	[8362]="Kuruk <General Goods>",
	[8363]="Shadi Mistrunner <Trade Supplies>",
	[8364]="Pakwa <Bag Vendor>",
	[8398]="Ohanko <Two Handed Weapon Merchant>",
	[8403]="Jeremiah Payson <Cockroach Vendor>",
	[8404]="Xan\'tish <Snake Vendor>",
	[8508]="Gretta Ganter <Fishing Supplies>",
	[8678]="Jubie Gadgetspring <Engineering Supplies>",
	[8679]="Knaz Blunderflame <Engineering Supplies>",
	[8681]="Outfitter Eric <Speciality Tailoring Supplies>",
	[8878]="Muuran <Superior Macecrafter>",
	[8931]="Innkeeper Heather <Innkeeper>",
	[8934]="Christopher Hewen <Trade Supplies>",
	[9087]="Bashana Runetotem <>",
	[9099]="Sraaz <Pie Vendor>",
	[9179]="Jazzrik <Blacksmithing Supplies>",
	[9356]="Innkeeper Shul\'kar <Innkeeper>",
	[9501]="Innkeeper Adegwa <Innkeeper>",
	[9544]="Yuka Screwspigot <>",
	[9548]="Cawind Trueaim <Gunsmith & Bowyer>",
	[9549]="Borand <Bowyer>",
	[9551]="Starn <Gunsmith & Bowyer>",
	[9552]="Zanara <Bowyer>",
	[9553]="Nadia Vernon <Bowyer>",
	[9555]="Mu\'uta <Bowyer>",
	[9636]="Kireena <Trade Goods>",
	[9676]="Tink Sprocketwhistle <Engineering Supplies>",
	[10118]="Nessa Shadowsong <Fishing Supplies>",
	[10216]="Gubber Blump <>",
	[10293]="Dulciea Frostmoon <Cloth Armor Merchant>",
	[10361]="Gruul Darkblade <Weaponsmith>",
	[10364]="Yaelika Farclaw <Reagents & Poison Supplies>",
	[10367]="Shrye Ragefist <Food & Drink>",
	[10369]="Trayexir <Weapon Merchant>",
	[10379]="Altsoba Ragetotem <Weapon Merchant>",
	[10380]="Sanuye Runetotem <Leather Armor Merchant>",
	[10856]="Argent Quartermaster Hasana <The Argent Dawn>",
	[10857]="Argent Quartermaster Lightspark <The Argent Dawn>",
	[11038]="Caretaker Alen <The Argent Dawn>",
	[11056]="Alchemist Arbington <>",
	[11057]="Apothecary Dithers <>",
	[11103]="Innkeeper Lyshaerya <Innkeeper>",
	[11106]="Innkeeper Sikewa <Innkeeper>",
	[11116]="Innkeeper Abeqwa <Innkeeper>",
	[11118]="Innkeeper Vizzie <Innkeeper>",
	[11137]="Xai\'ander <Weaponsmith>",
	[11182]="Nixxrak <Heavy Armor Merchant>",
	[11183]="Blixxrak <Light Armor Merchant>",
	[11184]="Wixxrak <Weaponsmith & Gunsmith>",
	[11185]="Xizzer Fizzbolt <Engineering Supplies>",
	[11186]="Lunnix Sprocketslip <Mining Supplies>",
	[11187]="Himmik <Food & Drink>",
	[11188]="Evie Whirlbrew <Alchemy Supplies>",
	[11189]="Qia <Trade Supplies>",
	[11287]="Baker Masterson <>",
	[11536]="Quartermaster Miranda Breechlock <The Argent Dawn>",
	[11555]="Gorn One Eye <>",
	[11557]="Meilosh <>",
	[11703]="Graw Cornerstone <Mail Armor Merchant>",
	[11874]="Masat T\'andr <Superior Leatherworker>",
	[12019]="Dargon <Food & Drink Merchant>",
	[12021]="Daeolyn Summerleaf <General Goods>",
	[12022]="Lorelae Wintersong <Trade Supplies>",
	[12023]="Kharedon <Light Armor Merchant>",
	[12024]="Meliri <Weaponsmith>",
	[12026]="My\'lanna <Food & Drink Merchant>",
	[12027]="Tukk <General Goods>",
	[12028]="Lah\'Mawhani <Trade Supplies>",
	[12029]="Narianna <Bowyer>",
	[12031]="Mai\'Lahii <Fishing Supplies>",
	[12033]="Wulan <Cooking Supplies>",
	[12043]="Kulwia <Trade Supplies>",
	[12045]="Hae\'Wilani <Axecrafter>",
	[12096]="Stormpike Quartermaster <>",
	[12097]="Frostwolf Quartermaster <>",
	[12196]="Innkeeper Kaylisk <Innkeeper>",
	[12245]="Vendor-Tron 1000 <>",
	[12246]="Super-Seller 680 <>",
	[12384]="Augustus the Touched <>",
	[12776]="Hraug <Demon Trainer>",
	[12777]="Captain Dirgehammer <Armor Quartermaster>",
	[12781]="Master Sergeant Biggins <Officer Accessories Quartermaster>",
	[12783]="Lieutenant Karter <Mount Vendor>",
	[12792]="Lady Palanseer <Armor Quartermaster>",
	[12793]="Brave Stonehide <Officer Accessories Quartermaster>",
	[12796]="Raider Bork <Mount Quartermaster>",
	[12799]="Sergeant Ba\'sha <Accessories Quartermaster>",
	[12805]="Officer Areyn <Accessories Quartermaster>",
	[12807]="Greshka <Demon Trainer>",
	[12941]="Jase Farlane <Trade Supplies>",
	[12942]="Leonard Porter <Leatherworking Supplies>",
	[12943]="Werg Thickblade <Leatherworking Supplies>",
	[12956]="Zannok Hidepiercer <Leatherworking Supplies>",
	[12957]="Blimo Gadgetspring <Trade Supplies>",
	[12958]="Gigget Zipcoil <Trade Supplies>",
	[12959]="Nergal <General Goods>",
	[12960]="Christi Galvanis <General Goods>",
	[12962]="Wik\'Tar <Fish Merchant & Supplies>",
	[13216]="Gaelden Hammersmith <Stormpike Supply Officer>",
	[13217]="Thanthaldis Snowgleam <Stormpike Supply Officer>",
	[13218]="Grunnda Wolfheart <Frostwolf Supply Officer>",
	[13219]="Jekyll Flandring <Frostwolf Supply Officer>",
	[13418]="Kaymard Copperpinch <Smokywood Pastures>",
	[13420]="Penney Copperpinch <Smokywood Pastures>",
	[13429]="Nardstrum Copperpinch <Smokywood Pastures>",
	[13430]="Jaycrue Copperpinch <Smokywood Pastures>",
	[13431]="Whulwert Copperpinch <Smokywood Pastures>",
	[13432]="Seersa Copperpinch <Smokywood Pastures>",
	[13433]="Wulmort Jinglepocket <Smokywood Pastures>",
	[13434]="Macey Jinglepocket <Smokywood Pastures>",
	[13435]="Khole Jinglepocket <Smokywood Pastures>",
	[13436]="Guchie Jinglepocket <Smokywood Pastures>",
	[13476]="Balai Lok\'Wein <Potions, Scrolls & Reagents>",
	[14301]="Brinna Valanaar <Bowyer>",
	[14371]="Shen\'dralar Provisioner <>",
	[14450]="Orphan Matron Nightingale <>",
	[14480]="Alowicious Czervik <Sweet Treats>",
	[14481]="Emmithue Smails <Sweet Treats>",
	[14624]="Master Smith Burninate <The Thorium Brotherhood>",
	[14637]="Zorbin Fandazzle <>",
	[14731]="Lard <Innkeeper>",
	[14737]="Smith Slagtree <Blacksmithing Supplies>",
	[14738]="Otho Moji\'ko <Cooking Supplies>",
	[14739]="Mystic Yayo\'jin <Reagents>",
	[14740]="Katoom the Angler <Fishing Trainer & Supplies>",
	[14753]="Illiyana Moonblaze <Silverwing Supply Officer>",
	[14754]="Kelm Hargunth <Warsong Supply Officer>",
	[14844]="Sylannia <Darkmoon Faire Drink Vendor>",
	[14846]="Lhara <Darkmoon Faire Exotic Goods>",
	[14847]="Professor Thaddeus Paleo <Darkmoon Faire Cards & Exotic Goods>",
	[14961]="Mirvyna Jinglepocket <Smokywood Pastures>",
	[14962]="Dillord Copperpinch <Smokywood Pastures>",
	[14963]="Gapp Jinglepocket <Smokywood Pastures>",
	[14964]="Hecht Copperpinch <Smokywood Pastures>",
	[15006]="Deze Snowbane <Arathi Basin Battlemaster>",
	[15011]="Wagner Hammerstrike <>",
	[15012]="Javnir Nashak <>",
	[15124]="Targot Jinglepocket <Smokywood Pastures>",
	[15125]="Kosco Copperpinch <Smokywood Pastures>",
	[15126]="Rutherford Twing <Defilers Supply Officer>",
	[15127]="Samuel Hawke <League of Arathor Supply Officer>",
	[15165]="Haughty Modiste <Fashion Designer>",
	[15174]="Calandrath <Innkeeper>",
	[15175]="Khur Hornstriker <Reagents>",
	[15176]="Vargus <Blacksmith>",
	[15179]="Mishta <Trade Supplies>",
	[15287]="Shara Sunwing <General Supplies>",
	[15315]="Mylini Frostmoon <Weapon Merchant>",
	[15353]="Katrina Shimmerstar <Hallow's End Treats>",
	[15354]="Rachelle Gothena <Hallow's End Treats>",
	[15397]="Marniel Amberlight <Innkeeper>",
	[15400]="Arathel Sunforge <Blacksmithing Trainer>",
	[15419]="Kania <Enchanting Supplies>",
	[15433]="Innkeeper Delaniel <Innkeeper>",
	[15471]="Lieutenant General Andorov <>",
	[15494]="Yasmine Teli\'Larien <Demon Trainer>",
	[16015]="Vi\'el <Exotic Reagent Merchant>",
	[16186]="Vara <Cloth & Leather Merchant>",
	[16187]="Quartermaster Lymel <General Goods>",
	[16191]="Sathren Azuredawn <General Goods>",
	[16224]="Rathis Tomber <Trade Supplies>",
	[16253]="Master Chef Mouldier <Cooking Trainer & Supplies>",
	[16256]="Jessica Chambers <Innkeeper>",
	[16257]="Geron <Weapon Merchant>",
	[16258]="Farsil <Armor & Shield Merchant>",
	[16259]="Sheri <General Goods>",
	[16260]="Areyn <General Goods>",
	[16261]="Sathiel <Trade Supplies>",
	[16262]="Landraelanis <Tradesman>",
	[16263]="Paelarin <Bowyer>",
	[16267]="Daestra <Demon Trainer>",
	[16268]="Eralan <Poison Supplies>",
	[16274]="Narina <Bowyer>",
	[16366]="Sempstress Ambershine <Tailoring Trainer>",
	[16367]="Botanist Tyniarrel <Herbalism Trainer & Supplies>",
	[16376]="Craftsman Wilhelm <Brotherhood of the Light>",
	[16388]="Koren <The Blacksmith>",
	[16442]="Vinemaster Suntouched <Wine & Spirits Merchant>",
	[16443]="Zalene Firstlight <Food & Drink>",
	[16444]="Halis Dawnstrider <General Goods>",
	[16458]="Innkeeper Faralia <Innkeeper>",
	[16542]="Innkeeper Kalarin <Innkeeper>",
	[16543]="Garon Hutchins <>",
	[16553]="Caregiver Chellan <Innkeeper>",
	[16583]="Rohok <Master Blacksmithing Trainer>",
	[16585]="Cookie One-Eye <Food & Drink>",
	[16588]="Apothecary Antonivich <Master Alchemy Trainer>",
	[16602]="Floyd Pinkus <Innkeeper>",
	[16610]="Kredis <Tabard Vendor>",
	[16611]="Zalle <Reagents>",
	[16612]="Velanni <Alchemy Supplies & Reagents>",
	[16613]="Parnis <Tradesman>",
	[16618]="Innkeeper Velandra <Innkeeper>",
	[16619]="Celana <Bowyer>",
	[16620]="Mathaleron <Gunsmith>",
	[16623]="Zyandrel <Cloth Armor Merchant>",
	[16624]="Gelanthis <Jewelcrafting Supplies>",
	[16625]="Keeli <Mail Armor Merchant>",
	[16626]="Tynna <Plate Armor Merchant>",
	[16631]="Andra <Clothier>",
	[16632]="Oss <Wand Vendor>",
	[16635]="Lyna <Enchanting Supplies>",
	[16636]="Zathanna <Wand Vendor>",
	[16637]="Welethelon <Blunt Weapon Merchant>",
	[16638]="Deynna <Tailoring Supplies>",
	[16641]="Melaris <Alchemy Supplies>",
	[16649]="Torian <Demon Trainer>",
	[16650]="Bithrus <Fireworks Vendor>",
	[16657]="Feera <Engineering Supplies>",
	[16664]="Zelan <Mining Supplies>",
	[16666]="Feledis <Axe Vendor>",
	[16670]="Eriden <Blacksmithing Supplies>",
	[16677]="Quelis <Cooking Supplies>",
	[16678]="Rahein <Blade Vendor>",
	[16683]="Darlia <Poison Supplies>",
	[16689]="Zaralda <Leatherworking Supplies>",
	[16690]="Rathin <Bag Vendor>",
	[16691]="Noraelath <Leather Armor Merchant>",
	[16693]="Winthren <Shield Merchant>",
	[16705]="Altaa <Alchemy Supplies>",
	[16706]="Musal <Alchemy Supplies & Reagents>",
	[16708]="Dekin <Fishing Supplies>",
	[16709]="Cuzi <Bag Vendor>",
	[16713]="Arras <Blacksmithing Supplies>",
	[16714]="Ven <Blade Vendor>",
	[16715]="Avelii <Bowyer>",
	[16716]="Gornii <Cloth Armor Merchant>",
	[16718]="Phea <Cooking Supplies>",
	[16722]="Egomis <Enchanting Supplies>",
	[16732]="Onnis <General Goods>",
	[16735]="Muhaa <Gunsmith>",
	[16739]="Caregiver Breel <Innkeeper>",
	[16747]="Mahri <Leather Armor Merchant>",
	[16748]="Haferet <Leatherworking Supplies>",
	[16750]="Yil <Mail Armor Merchant>",
	[16751]="Merran <Mining Supplies>",
	[16753]="Gotaan <Plate Armor Merchant>",
	[16757]="Bildine <Reagents>",
	[16762]="Treall <Shield Merchant>",
	[16765]="Ellomin <Blunt Weapon Merchant>",
	[16766]="Issca <Tabard Vendor>",
	[16767]="Neii <Tailoring Supplies>",
	[16768]="Nurguni <Tradesman>",
	[16769]="Firewing Warlock <>",
	[16782]="Yatheon <Engineering Supplies>",
	[16798]="Provisioner Anir <Food & Drink Vendor>",
	[16823]="Humphry <Master Blacksmithing Trainer>",
	[16826]="Sid Limbardi <Innkeeper>",
	[16829]="Magus Zabraxis <Reagents>",
	[16917]="Aurok <Armorsmith>",
	[16918]="Jel <Cloth & Leather Merchant>",
	[16919]="Mura <Weaponsmith>",
	[16920]="Ryosh <General Supplies>",
	[17078]="Jimmy McWeaksauce <Cool Guy>",
	[17101]="Diktynna <Fishing Trainer & Supplies>",
	[17222]="Artificer Daelo <Engineering Trainer>",
	[17245]="Blacksmith Calypso <Blacksmithing Trainer & Supplies>",
	[17246]="\"Cookie\" McWeaksauce <Cooking Trainer & Supplies>",
	[17277]="Provisioner Valine <Food & Drink>",
	[17412]="Phaedra <Weapon Merchant>",
	[17421]="Clopper Wizbang <Explorers' League>",
	[17446]="Parkat Steelfur <General Goods>",
	[17486]="Ziz <Tradesman>",
	[17489]="Logan Daniel <General Goods>",
	[17490]="Ergh of the Stillpine <Trade Supplies>",
	[17512]="Arred <Jewelcrafting Supplies>",
	[17518]="Ythyar <>",
	[17553]="Caregiver Topher Loaal <Innkeeper>",
	[17585]="Quartermaster Urgronn <Thrallmar Quartermaster>",
	[17598]="Renn\'az <Ammunition Vendor>",
	[17630]="Innkeeper Jovia <Innkeeper>",
	[17655]="Blacksmith Frances <Blacksmithing Supplies>",
	[17656]="Heron Skygaze <Food & Drink>",
	[17657]="Logistics Officer Ulrike <Honor Hold Quartermaster>",
	[17667]="Beega <Bowyer>",
	[17904]="Fedryen Swiftspear <Cenarion Expedition Quartermaster>",
	[17929]="Kioni <Cloth & Leather Merchant>",
	[17930]="Nabek <Weapons & Armor Merchant>",
	[18005]="Haalrun <Alchemy Supplies>",
	[18006]="Noraani <Reagent Merchant>",
	[18009]="Puluu <>",
	[18010]="Maktu <Armor Merchant>",
	[18011]="Zurai <Merchant>",
	[18015]="Gambarinka <Tradesman>",
	[18017]="Seer Janidi <Reagents>",
	[18018]="Zurjaya <Fishing Trainer>",
	[18019]="Timothy Daniels <The Specialist>",
	[18243]="Lorti <Merchant>",
	[18245]="Merajit <Innkeeper>",
	[18251]="Caregiver Abidaar <Innkeeper>",
	[18255]="Apprentice Darius <>",
	[18277]="Kinamisa <Leatherworking Supplies>",
	[18278]="Pilot Marsha <Engineering Supplies>",
	[18347]="Olirea <Fishing Supplies>",
	[18426]="Terellia <Trade Supplies>",
	[18427]="Fazu <Tradesman>",
	[18484]="Wind Trader Lathrai <>",
	[18525]="G\'eras <>",
	[18542]="Alexston Chrome <Tavern of Time>",
	[18749]="Dalinna <Master Tailoring Trainer>",
	[18751]="Kalaen <Master Jewelcrafting Trainer>",
	[18752]="Zebig <Master Engineering Trainer>",
	[18753]="Felannia <Master Enchanting Trainer>",
	[18754]="Barim Spilthoof <Master Leatherworking Trainer>",
	[18756]="Haris Pilton <Socialite>",
	[18771]="Brumman <Master Leatherworking Trainer>",
	[18772]="Hama <Master Tailoring Trainer>",
	[18773]="Johan Barnes <Master Enchanting Trainer>",
	[18774]="Tatiana <Master Jewelcrafting Trainer>",
	[18775]="Lebowski <Master Engineering Trainer>",
	[18802]="Alchemist Gribble <Master Alchemy Trainer>",
	[18810]="Otonambusi <General Goods>",
	[18811]="Meriaad <General Goods>",
	[18821]="Quartermaster Jaffrey Noreliqe <>",
	[18822]="Quartermaster Davian Vaclav <>",
	[18898]="Explodyne Fizzlespurt <Arena Vendor>",
	[18905]="Innkeeper Bazil Olof\'tazun <Innkeeper>",
	[18906]="Caregiver Ophera Windfury <Innkeeper>",
	[18907]="Innkeeper Coryth Stoktron <Innkeeper>",
	[18908]="Innkeeper Kerp <Innkeeper>",
	[18911]="Juno Dufrain <Fishing Supplies>",
	[18913]="Matron Tikkit <Innkeeper>",
	[18914]="Caregiver Isel <Innkeeper>",
	[18926]="Sleyin <Weapon Vendor>",
	[18929]="Kyrenna <Cheese Vendor>",
	[18947]="Solanin <Bag Vendor>",
	[18951]="Erilia <Enchanting Vendor>",
	[18954]="Sailor Melinan <Drink Vendor>",
	[18957]="Innkeeper Grilka <Innkeeper>",
	[18959]="Dod\'ss <General Goods>",
	[18960]="Rungor <Trade Goods>",
	[18962]="Bar Talet <Bowyer>",
	[18987]="Gaston <Chef>",
	[18988]="Baxter <Chef>",
	[18990]="Burko <Medic>",
	[18991]="Aresella <Medic>",
	[18993]="Naka <Cooking Supplies>",
	[18997]="Fallesh Sunfallow <Weapon Merchant>",
	[18998]="Lursa Sunfallow <Reagents>",
	[19001]="Talaara <Weapon Merchant>",
	[19004]="Vodesiin <Reagents>",
	[19011]="Osrok the Immovable <Armorsmith & Blacksmithing Supplies>",
	[19012]="Sparik <Armorsmith & Blacksmithing Supplies>",
	[19013]="Vanteg <Reagents & Poison Supplies>",
	[19014]="Ogir <Reagents & Poison Supplies>",
	[19015]="Mathar G\'ochar <Trade Supplies>",
	[19017]="Borto <Trade Supplies>",
	[19020]="Matron Qualia <General Goods>",
	[19021]="Nancila <General Goods>",
	[19038]="Supply Officer Mills <Rations>",
	[19042]="Leeli Longhaggle <Trade Goods>",
	[19043]="Ahemen <Staff Vendor>",
	[19045]="Oloraak <Fish Merchant>",
	[19047]="Lissaf <Blade Merchant>",
	[19049]="Karokka <Poison Supplies>",
	[19050]="Garul <Food & Drink>",
	[19053]="Fabian Lanzonelli <General Goods & Bags>",
	[19056]="Cecil Meyers <Blacksmithing Supplies>",
	[19065]="Inessera <Jewelcrafting Supplies Vendor>",
	[19074]="Skreah <Alchemy Supplies>",
	[19182]="Shaarubo <Bartender>",
	[19186]="Kylene <Barmaid>",
	[19194]="Ernie Packwell <Trade Goods>",
	[19195]="Jim Saltit <Cooking Supplies>",
	[19196]="Cro Threadstrong <Leatherworking Supplies>",
	[19197]="Eral <General Goods>",
	[19213]="Eiin <Specialty Tailoring Supplies>",
	[19223]="Granny Smith <Fruit Seller>",
	[19232]="Innkeeper Haelthol <Innkeeper>",
	[19234]="Yurial Soulwater <Enchanting Supplies>",
	[19235]="Amshesha Stilldark <Reagents>",
	[19236]="Quelama Lightblade <Wand Vendor>",
	[19238]="Urumir Stavebright <Staff Vendor>",
	[19239]="Mahir Redstroke <Dagger Vendor>",
	[19240]="Selanam the Blade <Sword Vendor>",
	[19243]="Nalama the Merchant <General Goods>",
	[19244]="Trader Endernor <Trade Goods>",
	[19245]="Vinemaster Alamaro <Wine Vendor>",
	[19296]="Innkeeper Biribi <Innkeeper>",
	[19314]="Supply Officer Shandria <General Goods & Repairs>",
	[19315]="Supply Officer Isabel <General Goods & Repairs>",
	[19330]="Lisrythe Bloodwatch <Fence>",
	[19333]="Grokom Deatheye <Weaponsmith>",
	[19339]="Korthul <Bowyer & Gunsmith>",
	[19342]="Krek Cragcrush <Blacksmithing Supplies>",
	[19343]="Trop Rendlimb <General Goods>",
	[19345]="Kalara <Trade Goods>",
	[19348]="Targrom <Food & Drink>",
	[19351]="Daggle Ironshaper <Guns & Ammunition>",
	[19352]="Dreg Cloudsweeper <Innkeeper>",
	[19370]="Ordinn Thunderfist <Hammersmith>",
	[19371]="Dalin Stouthammer <Cooking Supplies>",
	[19372]="Oran Blusterbrew <Trade Goods>",
	[19373]="Mari Stonehand <Armorsmith>",
	[19374]="Salle Sunforge <General Goods>",
	[19383]="Captured Gnome <Item Repair>",
	[19435]="Dark Cleric Malod <Healing & Sustenance>",
	[19436]="Supply Master Broog <Supplies>",
	[19450]="Pol Snowhoof <Trade Goods>",
	[19451]="Quartermaster Gorman <Rations>",
	[19452]="Quartermaster Drake <Supplies>",
	[19470]="Gholah <Innkeeper>",
	[19471]="Old Orok <Fruit & Fungus>",
	[19472]="Threlc <Fishmonger>",
	[19473]="Raiza <Throwing Weapons & Ammunition>",
	[19474]="Karnaze <General Goods>",
	[19479]="Orgatha <Axesmith>",
	[19495]="Innkeeper Shaunessy <Innkeeper>",
	[19497]="Caoileann <Trade Goods>",
	[19498]="Tanaide <General Goods>",
	[19499]="Cahill <Weaponsmith>",
	[19517]="Alorra <Armorer>",
	[19518]="Feranin <Food & Drink>",
	[19520]="Lelagar <Blacksmithing Supplies>",
	[19521]="Arrond <Tailoring Supplies>",
	[19526]="Dunaman <Weapons Vendor>",
	[19528]="Nanomah <Provisions Merchant>",
	[19530]="Darmend <Blacksmithing Supplies>",
	[19531]="Eyonix <Innkeeper>",
	[19532]="Dearny <Leatherworking Merchant>",
	[19533]="Dealer Aljaan <Trade Goods>",
	[19534]="Dealer Digriz <General Goods>",
	[19535]="Dealer Zijaad <Arcane Goods>",
	[19537]="Dealer Malij <Enchanting Supplies>",
	[19538]="Dealer Senzik <Gems & Jewelcrafting Supplies>",
	[19539]="Jazdalaad <Master Jewelcrafting Trainer>",
	[19540]="Asarnan <Master Enchanting Trainer>",
	[19559]="Mondul <Food & Drink>",
	[19560]="Lukra <General Goods>",
	[19561]="Hagash the Blind <Bowyer>",
	[19562]="Peon Bolgar <Trade Goods>",
	[19572]="Gant <Food & Drink>",
	[19573]="Dash <Trade Supplies>",
	[19574]="Kizzie <General Supplies>",
	[19575]="Qiff  <Engineering Supplies>",
	[19617]="Boots <B.O.O.M. Master Mixologist>",
	[19625]="Alorya <General Goods>",
	[19649]="Dorni <General Goods>",
	[19661]="Viggz Shinesparked <Engineering Supplies>",
	[19662]="Aaron Hollman <Blacksmithing Supplies>",
	[19663]="Madame Ruby <Enchanting Supplies>",
	[19664]="Muffin Man Moser <Bread Merchant>",
	[19678]="Fantei <Reagents>",
	[19679]="\"Slim\" <Shady Dealer>",
	[19694]="Loolruna <Armorer>",
	[19718]="Provisioner Tsaalt <>",
	[19722]="Muheru the Weaver <Tailoring Supplies>",
	[19772]="Spirit Sage Gartok <>",
	[19773]="Spirit Sage Zran <>",
	[19836]="Mixie Farshot <Gun Merchant>",
	[19837]="Daga Ramba <Potions>",
	[19857]="Meminnie <Arena Vendor>",
	[19879]="Horvon the Armorer <Armorsmith>",
	[19932]="Andormu <Keepers of Time>",
	[20028]="Doba <Cooking Supplies>",
	[20080]="Galgrom <Provisioner>",
	[20081]="Bortega <Reagents & Poison Supplies>",
	[20082]="Yarley <Armorer>",
	[20092]="Dealer Hazzin <General Provisioner>",
	[20096]="Uriku <Cooking Supplies>",
	[20097]="Nula the Butcher <Cooking Supplies>",
	[20112]="Wind Trader Tuluman <Weapon Merchant>",
	[20121]="Fingin <Poison Supplies>",
	[20194]="Dealer Dunar <General Provisioner>",
	[20231]="Supply Officer Pestle <General Goods & Repairs>",
	[20242]="Karaaz <Consortium Quartermaster>",
	[20249]="Cymbre Starsong <General Goods>",
	[20250]="Rashere Pridehoof <Trade Goods>",
	[20278]="Vixton Pinchwhistle <Arena Vendor>",
	[20377]="Barkeep Kelly <Bartender>",
	[20378]="Chef Jessen <Speciality Meat & Slop>",
	[20463]="Apprentice Andrethan <>",
	[20613]="Arodis Sunblade <Keeper of Sha'tari Artifacts>",
	[20616]="Asuur <Keeper of Sha'tari Artifacts>",
	[20807]="Inscriber Saalyn <Aldor Inscriptions>",
	[20890]="Siflaed Coldhammer <Tinker>",
	[20891]="Skraa <Trade Goods>",
	[20892]="Ruogo <General Goods>",
	[20893]="Morula <Food & Drink>",
	[20915]="Noko Moonwhisper <Reagents>",
	[20916]="Xerintha Ravenoak <Food & Drink>",
	[20917]="Zinyen Swiftstrider <Weapon Vendor>",
	[20980]="Dealer Rashaad <Exotic Creatures>",
	[20981]="Dealer Najeeb <Spare Parts>",
	[20986]="Dealer Tariq <Shady Dealer>",
	[20989]="Dealer Sadaqat <Potent Potables>",
	[21082]="Krugash <General Goods>",
	[21083]="Erool <Trade Goods>",
	[21084]="Braagor <Butcher>",
	[21085]="Ragar <Leatherworking Supplies>",
	[21086]="Ruka <Smashing Weapons>",
	[21110]="Fizit \"Doc\" Clocktock <Innkeeper>",
	[21111]="Bembil Knockhammer <General Goods>",
	[21112]="Bossi Pentapiston <Engineering Supplies>",
	[21113]="Sassa Weldwell <Trade Goods>",
	[21145]="Little Azimi <Food Vendor>",
	[21183]="Oronok Torn-heart <Hermit & Trader>",
	[21209]="Dumphry <Master Blacksmithing Trainer>",
	[21432]="Almaador <Sha'tari Quartermaster>",
	[21474]="Coreiel <Blade Merchant>",
	[21483]="Tasaldan <Ammunition>",
	[21484]="Embelar <Food & Drink>",
	[21485]="Aldraan <Blade Merchant>",
	[21487]="Cendrii <Food & Drink>",
	[21488]="Banro <Ammunition>",
	[21643]="Alurmi <Keepers of Time Quartermaster>",
	[21655]="Nakodu <Lower City Quartermaster>",
	[21744]="Roldemar <Innkeeper>",
	[21746]="Caretaker Aluuro <Innkeeper>",
	[21905]="Veynna Dawnstar <Keeper of Sha'tari Heirlooms>",
	[21906]="Kelara <Keeper of Sha'tari Heirlooms>",
	[22099]="Wyrmcult Provisioner <>",
	[22225]="Reagan Mancuso <Gem Vendor>",
	[22227]="Markus Scylan <Gem Vendor>",
	[22264]="Ogri\'la Steelshaper <Blacksmithing Supplies>",
	[22266]="Ogri\'la Grubgiver <Food Vendor>",
	[22270]="Ogri\'la Merchant <General Goods>",
	[22271]="Ogri\'la Trader <Trade Goods>",
	[22476]="Aundro <Blacksmithing Supplies>",
	[22479]="Sab\'aoth <Reagents & Poison Supplies>",
	[22491]="Kerpow Blastwrench <Weapon Merchant>",
	[22922]="Innkeeper Aelerya <Innkeeper>",
	[23007]="Paulsta\'ats <Consortium Quartermaster>",
	[23009]="Bessbi Jinglepocket <Smokywood Pastures>",
	[23010]="Wolgren Jinglepocket <Smokywood Pastures>",
	[23011]="Morshelz Copperpinch <Smokywood Pastures>",
	[23012]="Hotoppik Copperpinch <Smokywood Pastures>",
	[23064]="Eebee Jinglepocket <Smokywood Pastures>",
	[23065]="Olnayvi Copperpinch <Smokywood Pastures>",
	[23110]="Ogri\'la Keg King <Drink Vendor>",
	[23112]="Mingo <Reagents>",
	[23143]="Horus <Innkeeper>",
	[23144]="Gug <Armorsmith>",
	[23145]="Rumpus <Reagents & Poison Supplies>",
	[23151]="The Rulkster <>",
	[23157]="Aluyen <Reagents>",
	[23208]="Skyguard Pyrotechnician <>",
	[23244]="Aether-tech Adept <>",
	[23245]="Aether-tech Master <>",
	[23263]="Brendan Turner <Meat Vendor>",
	[23363]="Sahaak <Keeper of Scrolls>",
	[23373]="Mortog Steamhead <>",
	[23396]="Krixel Pinchwhistle <Arena Vendor>",
	[23405]="Flaskataur <>",
	[23446]="Lieutenant Tristia <Armor Quartermaster>",
	[23447]="Sergeant Kien <Armor Quartermaster>",
	[23481]="Keiran Donoghue <Sausage Vendor>",
	[23483]="Arcanist Xorith <Scryer Apothecary>",
	[23484]="Haldor the Compulsive <Aldor Apothecary>",
	[23510]="Thunderbrew Apprentice <Thunderbrew Brew Vendor>",
	[23521]="Anne Summers <Cheese Vendor>",
	[23522]="Arlen Lochlan <Bread Vendor>",
	[23525]="Brother Cartwright <Wine Vendor>",
	[23535]="Matero Zeshuwal <Demon Trainer>",
	[23560]="Provisioner Ameenah <Reagents>",
	[23571]="Razbo Rustgear <Weapon & Armor Merchant>",
	[23573]="Krixil Slogswitch <Food & Drink>",
	[23603]="Uta Roughdough <Bread Vendor>",
	[23604]="Agnes Farwithers <Cheese Vendor>",
	[23605]="Bron <Sausage Vendor>",
	[23606]="Suntouched Apprentice <Wine Vendor>",
	[23710]="Belbi Quikswitch <Token Redeemer>",
	[23724]="Samir <>",
	[23748]="Kurzel <Food & Drink>",
	[23896]="\"Dirty\" Michael Crowe <Fish Merchant>",
	[23995]="Axle <Innkeeper>",
	[24208]="\"Little\" Logok <Innkeeper>",
	[24392]="Leeni \"Smiley\" Smalls <Arena Vendor>",
	[24408]="Gunter <Food Vendor>",
	[24468]="Pol Amberstill <Ram Racing Apprentice>",
	[24495]="Blix Fixwidget <Token Redeemer>",
	[24510]="Driz Tumblequick <Ram Racing Apprentice>",
	[24520]="Doris Volanthius <Armor Quartermaster>",
	[24545]="Thunderbrew \"Apprentice\" <Thunderbrew Brew Vendor>",
	[24667]="Sergeant Thunderhorn <Weapons Quartermaster>",
	[24668]="Lady Palanseer <Armor Quartermaster>",
	[24670]="Lieutenant Tristia <Armor Quartermaster>",
	[24671]="Captain O\'Neal <Weapons Quartermaster>",
	[24672]="Captain Dirgehammer <Armor Quartermaster>",
	[24834]="Galley Chief Grace <The Lady Mehley>",
	[24843]="Engineer Combs <The Lady Mehley>",
	[24934]="Snack-O-Matic IV <>",
	[24935]="Vend-O-Tron D-Luxe <>",
	[24975]="Mar\'nah <Alchemist>",
	[24993]="Galley Chief Mariss <The Moonspray>",
	[24995]="Merchant Fallel Stargazer <The Moonspray>",
	[25010]="Engineer Brightbuckle <The Bravery>",
	[25012]="Galley Chief Gathers <The Bravery>",
	[25019]="Merchant Felagunne <Feathermoon Ferry>",
	[25020]="Galley Chief Alunwea <Feathermoon Ferry>",
	[25032]="Eldara Dawnrunner <Shattered Sun Quartermaster>",
	[25034]="Tradesman Portanuus <Trade Supplies>",
	[25035]="Tyrael Flamekissed <General Goods>",
	[25036]="Caregiver Inaara <Innkeeper>",
	[25039]="Kaalif <Reagent Vendor>",
	[25043]="Sereth Duskbringer <Poison Supplier>",
	[25046]="Smith Hauthaa <Weapons & Armorsmith>",
	[25051]="Merchant Frostwalker <Elune's Blessing>",
	[25052]="Galley Chief Halumvorea <Elune's Blessing>",
	[25082]="Engineer Torquespindle <The Maiden's Fancy>",
	[25089]="Galley Chief Steelbelly <The Maiden's Fancy>",
	[25176]="Grikkin Copperspring <Arena Vendor>",
	[25177]="Evee Copperspring <Arena Vendor>",
	[25178]="Ecton Brasstumbler <Arena Vendor>",
	[25179]="Frixee Brasstumbler <Arena Vendor>",
	[25195]="Marksman Bova <Specialty Ammunition Vendor>",
	[25196]="Archer Delvinar <Specialty Ammunition Vendor>",
	[25515]="[PH] Festival Fire Juggler <>",
	[25633]="Arcanist Evandor <Reagent Supplies>",
	[25634]="Smith Vedral <Equipment Repairs>",
	[25950]="Shaani <Jewelcrafting Supplies>",
	[26089]="Kayri <Exotic Gear Purveyor>",
	[26090]="Karynna <Exotic Gear Purveyor>",
	[26091]="Olus <Exotic Gear Purveyor>",
	[26092]="Soryn <Exotic Gear Purveyor>",
	[26123]="Midsummer Supplier <>",
	[26124]="Midsummer Merchant <>",
	[26300]="Accessories Vendor <>",
	[26301]="Cloth Armor Vendor <>",
	[26302]="Enchantments Vendor <>",
	[26303]="Gems Vendor <>",
	[26304]="General Goods Vendor <>",
	[26305]="Leather Armor Vendor <>",
	[26306]="Mail Armor Vendor <>",
	[26308]="Plate Armor Vendor <>",
	[26309]="Weapons Vendor <>",
	[26352]="Big Zokk Torquewrench <Arena Vendor>",
	[26378]="Evee Copperspring <Arena Vendor>",
	[26383]="Grikkin Copperspring <Arena Vendor>",
	[26384]="Frixee Brasstumbler <Arena Vendor>",
	[26393]="Captain Dirgehammer <Armor Quartermaster>",
	[26394]="Captain O\'Neal <Weapons Quartermaster>",
	[26395]="Lieutenant Tristia <Armor Quartermaster>",
	[26396]="Sergeant Thunderhorn <Weapons Quartermaster>",
	[26397]="Lady Palanseer <Armor Quartermaster>",
	[26398]="Doris Volanthius <Armor Quartermaster>",
	[26724]="[DND] TAR Pedestal - Armor, Cloth <>",
	[26738]="[DND] TAR Pedestal - Accessories <>",
	[26739]="[DND] TAR Pedestal - Enchantments <>",
	[26740]="[DND] TAR Pedestal - Gems <>",
	[26741]="[DND] TAR Pedestal - General Goods <>",
	[26742]="[DND] TAR Pedestal - Armor, Leather <>",
	[26743]="[DND] TAR Pedestal - Armor, Mail <>",
	[26744]="[DND] TAR Pedestal - Armor, Plate <>",
	[26745]="[DND] TAR Pedestal - Weapons <>",
	[26747]="[DND] TAR Pedestal - Arena Organizer <>",
	[26748]="[DND] TAR Pedestal - Beastmaster <>",
	[26749]="[DND] TAR Pedestal - Paymaster <>",
	[26751]="[DND] TAR Pedestal - Trainer, Druid <>",
	[26752]="[DND] TAR Pedestal - Trainer, Hunter <>",
	[26753]="[DND] TAR Pedestal - Trainer, Mage <>",
	[26754]="[DND] TAR Pedestal - Trainer, Paladin <>",
	[26755]="[DND] TAR Pedestal - Trainer, Priest <>",
	[26756]="[DND] TAR Pedestal - Trainer, Rogue <>",
	[26757]="[DND] TAR Pedestal - Trainer, Shaman <>",
	[26758]="[DND] TAR Pedestal - Trainer, Warlock <>",
	[26759]="[DND] TAR Pedestal - Trainer, Warrior <>",
	[26765]="[DND] TAR Pedestal - Fight Promoter <>",
	[27478]="Larkin Thunderbrew <Brew of the Month Club>",
	[27489]="Ray\'ma <Brew of the Month Club>",
	[27666]="Ontuvo <Jewelcrafting Supplies>",
	[27667]="Anwehu <Weapons & Armorsmith>",
	[27668]="Ontok Shatterhorn <Arena Vendor>",
	[27711]="Technician Halmaha <Engineering Supplies>",
	[27721]="Drelik Blastpipe <Arena Vendor>",
	[27722]="Drolig Blastpipe <Arena Vendor>",
	[28225]="Griz Gutshank <Arena Vendor>",
	[28344]="Blazzle <Blacksmithing Supplies>",
})

-- The base item data
Informant.SetDatabase({
	[25]=":7:2:1:1:::1:0:", -- Worn Shortsword
	[35]=":9:2:1:1:::1:0:", -- Bent Staff
	[36]=":7:2:1:1:::1:0:", -- Worn Mace
	[37]=":7:2:1:1:::1:0:", -- Worn Axe
	[38]="1:1:4:1:1:::1:0:18672", -- Recruit\'s Shirt
	[39]="5:1:4:0:1:::1:0:18672", -- Recruit\'s Pants
	[40]="5:1:4:1:1:::1:0:18672", -- Recruit\'s Boots
	[43]="5:1:4:1:1:::1:0:18672", -- Squire\'s Boots
	[44]="4:1:4:0:1:::1:0:18672", -- Squire\'s Pants
	[45]="1:1:4:1:1:::1:0:18672", -- Squire\'s Shirt
	[47]=":1:4:1:1:::1:0:", -- Footpad\'s Shoes
	[48]=":1:4:0:1:::1:0:", -- Footpad\'s Pants
	[49]=":1:4:1:1:::1:0:", -- Footpad\'s Shirt
	[51]="5:1:4:1:1:::1:0:18672", -- Neophyte\'s Boots
	[52]="5:1:4:0:1:::1:0:18672", -- Neophyte\'s Pants
	[53]="1:1:4:1:1:::1:0:18672", -- Neophyte\'s Shirt
	[55]="5:1:4:1:1:::1:0:18672", -- Apprentice\'s Boots
	[56]="5:1:4:0:1:::1:0:18672", -- Apprentice\'s Robe
	[57]="5:1:4:0:1:::1:0:18672", -- Acolyte\'s Robe
	[59]="5:1:4:1:1:::1:0:18672", -- Acolyte\'s Shoes
	[60]=":12:4:1:1:::1:0:", -- Layered Tunic
	[61]=":12:4:1:1:::1:0:", -- Dwarven Leather Pants
	[79]=":10:4:1:1:::1:0:", -- Dwarven Cloth Britches
	[80]=":7:4:1:1:::1:0:", -- Soft Fur-lined Shoes
	[85]="63:12:4:1:1:::1:0:3074,4558,2113,3160", -- Dirty Leather Vest
	[117]="25:1:0:1:20:::5:0:3025,3705,15397,4954,7731,4875,11187,3881,3960,11118,2388,3489,23263,10367,3411,6928,5124,17630,982,4891,2814,8125,5870,16618,15174,4255,17553,12959,5620,6929,12097,5611,23481,3621,4894,5111,4782,12096,14624,9356,3933,3935,3312,24208,16443,7733,4169,23605,7485,12196,4879,17656,2365,16739,4084,1464,3368,3882,19182,3089", -- Tough Jerky
	[118]=":5:0:1:5::171:1:0:", -- Minor Healing Potion
	[120]=":1:4:0:1:::1:0:", -- Thug Pants
	[121]=":1:4:1:1:::1:0:", -- Thug Boots
	[127]=":1:4:1:1:::1:0:", -- Trapper\'s Shirt
	[129]=":1:4:1:1:::1:0:", -- Rugged Trapper\'s Boots
	[139]=":1:4:0:1:::1:0:", -- Brawler\'s Pants
	[140]=":1:4:1:1:::1:0:", -- Brawler\'s Boots
	[147]=":1:4:0:1:::1:0:", -- Rugged Trapper\'s Pants
	[148]=":1:4:1:1:::1:0:", -- Rugged Trapper\'s Shirt
	[153]=":1:4:0:1:::1:0:", -- Primitive Kilt
	[154]=":1:4:1:1:::1:0:", -- Primitive Mantle
	[159]="25:1:0:1:20::185,202:5:0:6734,8307,2352,15433,7736,5688,24993,829,24934,6790,10367,151,19617,2397,6928,2303,982,11103,295,3076,21145,12246,18993,16191,3689,4190,227,4553,25012,3186,6727,17246,12959,5611,17421,734,18810,12021,16256,23573,25020,5111,5140,8139,3546,16259,152,5112,7733,2084,6747,16253,1250,8152,18811,12019,1448,2115,14738,17489,3961,3498,1464,19182,11116,15397,7731,3072,4875,1697,1328,19195,3625,3481,11118,15287,2806,2908,465,1691,16920,4182,3400,4571,1149,7943,7744,3883,3577,1452,3934,4167,491,3587,3937,2832,15174,955,17553,16718,4981,6495,3350,3621,14371,12096,5871,14624,2140,9356,3164,1237,274,16677,11287,4876,258,3608,2381,3298,4879,17656,5134,24834,4084,3882,25052,4181,3027,6746,8150,7941,4893,1285,11555,20028,6737,18987,8143,14731,4223,5814,4266,20096,6738,2134,4191,3959,2364,6740,6741,16618,4192,2803,16732,3313,4255,5620,8931,12097,791,6807,19371,3884,2664,6736,1682,3086,4555,2401,16443,3085,20097,4082,3158,7942,12196,1247,4241,12027,6930,16739,16553,2808,25089,3962,6735,5483,11038,11187,3881,12033,5160,2388,8137,12960,4265,3411,6739,16542,23995,12026,8362,17630,5101,4170,3541,8125,16458,11106,4195,6929,16260,17446,16444,4896,4782,16187,4554,7714,6091,24208,4169,2366,7485,6791,2820,7737,6272,3708,9501,1685", -- Refreshing Spring Water
	[182]="::12:1:1:::1:0:", -- Garrick\'s Head
	[193]="49:9:4:1:1:::1:0:4558,2113,3160", -- Tattered Cloth Vest
	[194]="49:9:4:1:1:::1:0:4558,2113,3160", -- Tattered Cloth Pants
	[195]="37:7:4:1:1:::1:0:4558,2113,3160", -- Tattered Cloth Boots
	[200]="2270:454:4:1:1:::1:0:3317,4188,4175,3092,1291,16623,3492,8358,16716,3952,2849,5155,5821", -- Thick Cloth Vest
	[201]="2278:455:4:1:1:::1:0:3317,4188,4175,3092,1291,16623,3492,8358,16716,3952,2849,5155,5821", -- Thick Cloth Pants
	[202]="1715:343:4:1:1:::1:0:3317,4188,4175,3092,1291,16623,3492,8358,16716,3952,2849,5155,5821", -- Thick Cloth Shoes
	[203]="1147:229:4:1:1:::1:0:3317,4188,4175,3092,1291,16623,3492,8358,16716,3952,2849,5155,5821", -- Thick Cloth Gloves
	[209]="61:12:4:1:1:::1:0:3074,4558,2113,3160", -- Dirty Leather Pants
	[210]="45:9:4:1:1:::1:0:3074,4558,2113,3160", -- Dirty Leather Boots
	[236]="2795:559:4:1:1:::1:0:3536,3953,16691,4236,1695,3321,3097,16747,3492,3093,1295,5783,8359,5820", -- Cured Leather Armor
	[237]="2806:561:4:1:1:::1:0:3536,3953,16691,4236,1695,3321,3097,16747,3492,3093,1295,5783,8359,5820", -- Cured Leather Pants
	[238]="2112:422:4:1:1:::1:0:3536,3953,16691,4236,1695,3321,3097,16747,3492,3093,1295,5783,8359,5820", -- Cured Leather Boots
	[239]="1413:282:4:1:1:::1:0:3536,3953,16691,4236,1695,3321,3097,16747,3492,3093,1295,5783,8359,5820", -- Cured Leather Gloves
	[285]="3555:711:4:1:1:::1:0:5819,5812,16750,5125,4177,956,3319,3682,8360,1341,16625,3543,1294,3493", -- Scalemail Vest
	[286]="3229:645:4:1:1:::1:0:5819,5812,16750,5125,4177,956,3319,3682,8360,1341,16625,3543,1294,3493", -- Scalemail Pants
	[287]="2442:488:4:1:1:::1:0:5819,5812,16750,5125,4177,956,3319,3682,8360,1341,16625,3543,1294,3493", -- Scalemail Boots
	[414]="125:6:0:1:20:::5:0:4255,6746,4981,483,5620,2352,4894,23604,4782,23521,3546,24934,18929,6790,10367,1237,465,17630,2364,4891,295,3298,6930,9501,11106,16553,11116", -- Dalaran Sharp
	[422]="500:25:0:1:20:::5:0:4255,6746,4981,483,5620,2352,4894,23604,4782,23521,3546,24934,18929,6790,10367,1237,465,17630,2364,4891,295,3298,6930,9501,11106,16553,11116", -- Dwarven Mild
	[537]=":87:15:0:5:::1:0:", -- Dull Frenzy Scale
	[555]=":8:15:0:10:::1:0:", -- Rough Vulture Feathers
	[556]=":106:15:0:5:::1:0:", -- Buzzard Beak
	[647]=":70024:2:4:1:::1:0:", -- Destiny
	[710]=":72:4:1:1:::1:0:", -- Bracers of the People\'s Militia
	[711]="26:5:4:1:1:::1:0:4558,2113,3160", -- Tattered Cloth Gloves
	[714]="32:6:4:1:1:::1:0:3074,4558,2113,3160", -- Dirty Leather Gloves
	[718]="1614:322:4:1:1:::1:0:5819,5812,16750,5125,4177,956,3319,3682,8360,1341,16625,3543,1294,3493", -- Scalemail Gloves
	[719]=":4:4:1:1:::1:0:", -- Rabbit Handler Gloves
	[720]=":1070:4:3:1:::1:0:", -- Brawler Gloves
	[723]=":15:7:1:10::185:1:0:", -- Goretusk Liver
	[724]=":25:0:1:20:::1:0:", -- Goretusk Liver Pie
	[725]="::12:1:20:::1:0:", -- Gnoll Paw
	[727]=":245:2:2:1:::1:0:", -- Notched Shortsword
	[728]="200:50:9:1:1:::1:0:340", -- Recipe: Westfall Stew
	[729]=":17:7:1:10::185:1:0:", -- Stringy Vulture Meat
	[730]=":16:7:1:10::185:1:0:", -- Murloc Eye
	[731]=":27:7:1:10::185:1:0:", -- Goretusk Snout
	[732]=":6:12:1:10:::1:0:", -- Okra
	[733]=":100:0:1:20:::1:0:", -- Westfall Stew
	[735]="::12:1:1:::1:0:", -- Rolf and Malakai\'s Medallions
	[737]="::12:1:1:::1:0:", -- Holy Spring Water
	[738]="::12:1:20:::1:0:", -- Sack of Barley
	[739]="::12:1:20:::1:0:", -- Sack of Corn
	[740]="::12:1:20:::1:0:", -- Sack of Rye
	[742]="::12:1:1:::1:0:", -- A Sycamore Branch
	[743]="::12:1:1:::1:0:", -- Bundle of Charred Oak
	[744]=":10000:4:2:1:::1:0:", -- Thunderbrew\'s Boot Flask
	[745]="::12:1:1:::1:0:", -- Marshal McBride\'s Documents
	[748]="::12:1:1:::1:0:", -- Stormwind Armor Marker
	[750]="::12:1:20:::1:0:", -- Tough Wolf Meat
	[752]="::12:1:20:::1:0:", -- Red Burlap Bandana
	[753]=":3842:2:2:1:::1:0:", -- Dragonmaw Shortsword
	[754]=":23556:2:3:1:::1:0:", -- Shortsword of Vengeance
	[755]=":1:15:0:5:::1:0:", -- Melted Candle
	[756]=":4963:2:2:1:::1:0:", -- Tunnel Pick
	[763]=":58:4:1:1:::1:0:", -- Ice-covered Bracers
	[765]="40:10:7:1:20::171:1:0:16224,16641,3548,1313,16705,3490", -- Silverleaf
	[766]=":57:2:1:1:::1:0:", -- Flanged Mace
	[767]=":100:2:1:1:::1:0:", -- Long Bo Staff
	[768]=":113:2:1:1:::1:0:", -- Lumberjack Axe
	[769]=":3:7:1:10::185:1:0:", -- Chunk of Boar Meat
	[770]=":316:15:0:10:::1:0:", -- Pointy Crocolisk Tooth
	[771]=":38:15:0:5:::1:0:", -- Chipped Boar Tusk
	[772]="::12:1:20:::1:0:", -- Large Candle
	[773]="::12:1:20:::1:0:", -- Gold Dust
	[774]=":15:3:2:20::164,202,755:1:0:", -- Malachite
	[776]=":5765:2:3:1:::1:0:", -- Vendetta
	[777]=":21:15:0:10:::1:0:", -- Prowler Teeth
	[778]=":55:2:1:1:::1:0:", -- Kobold Excavation Pick
	[779]=":18:15:0:5:::1:0:", -- Shiny Seashell
	[780]="::12:1:20:::1:0:", -- Torn Murloc Fin
	[781]=":110:2:1:1:::1:0:", -- Stone Gnoll Hammer
	[782]="::12:1:20:::1:0:", -- Painted Gnoll Armband
	[783]=":50:7:1:10::165:1:0:", -- Light Hide
	[785]="80:20:7:1:20::171,185:1:0:16224,4878,1313,844,4083,14846,8305,1302,16641,3548,16705,3490", -- Mageroyal
	[787]="25:1:0:1:20:::5:0:25089,11187,24993,1678,14731,8137,5814,10367,6738,3497,7943,4305,23896,16618,25012,12962,17553,4255,6727,8931,4307,6807,2842,25020,4200,3086,3540,19045,6791,3178,17656,16739,24834,1684,4221,25052", -- Slitherskin Mackerel
	[789]=":1969:2:2:1:::1:0:", -- Stout Battlehammer
	[790]=":2020:2:2:1:::1:0:", -- Forester\'s Axe
	[791]=":7069:2:3:1:::1:0:", -- Gnarled Ash Staff
	[792]="208:41:4:1:1:::1:0:1238,4164,959,3530,3611,4175,3092,2264,1291,16716,3952,17929,74,5821", -- Knitted Sandals
	[793]="139:27:4:1:1:::1:0:1238,4164,959,3530,3611,4175,3092,2264,1291,16716,3952,17929,74,5821", -- Knitted Gloves
	[794]="280:56:4:1:1:::1:0:1238,4164,959,3530,3611,4175,3092,2264,1291,16716,3952,17929,74,5821", -- Knitted Pants
	[795]="281:56:4:1:1:::1:0:1238,4164,959,3530,3611,4175,3092,2264,1291,16716,3952,17929,74,5821", -- Knitted Tunic
	[796]="264:52:4:1:1:::1:0:1238,4164,3953,4236,3612,3162,16747,17929,74,3532,1295,896,5820", -- Rough Leather Boots
	[797]="177:35:4:1:1:::1:0:1238,4164,3953,4236,3612,3162,16747,17929,74,3532,1295,896,5820", -- Rough Leather Gloves
	[798]="355:71:4:1:1:::1:0:1238,4164,3953,4236,3612,3162,16747,17929,74,3532,1295,896,5820", -- Rough Leather Pants
	[799]="356:71:4:1:1:::1:0:1238,4164,3953,4236,3612,3162,16747,17929,74,3532,1295,896,5820", -- Rough Leather Vest
	[804]=":2500:1:1:1:::1:0:", -- Large Blue Sack
	[805]=":250:1:1:1:::1:0:", -- Small Red Pouch
	[809]=":39125:2:4:1:::1:0:", -- Bloodrazor
	[810]=":45267:2:4:1:::1:0:", -- Hammer of the Northern Wind
	[811]=":54123:2:4:1:::1:0:", -- Axe of the Deep Woods
	[812]=":57018:2:4:1:::1:0:", -- Glowing Brightwood Staff
	[814]=":25:7:1:20::202:1:0:", -- Flask of Oil
	[816]=":305:2:2:1:::1:0:", -- Small Hand Blade
	[818]=":100:3:2:20::164,202,755:1:0:", -- Tigerseye
	[820]=":947:2:2:1:::1:0:", -- Slicer Blade
	[821]=":249:4:2:1:::1:0:", -- Riverpaw Leather Vest
	[826]=":732:2:2:1:::1:0:", -- Brutish Riverpaw Axe
	[827]=":971:2:2:1:::1:0:", -- Wicked Blackjack
	[828]=":250:1:1:1:::1:0:", -- Small Blue Pouch
	[829]="::12:1:20:::1:0:", -- Red Leather Bandana
	[832]=":203:4:2:1:::1:0:", -- Silver Defias Belt
	[833]=":28000:4:4:1:::1:0:", -- Lifestone
	[835]=":23:0:1:1:::1:0:", -- Large Rope Net
	[837]="1125:225:4:1:1:::1:0:3317,4175,5108,1214,16716,5821,3683,4164,3092,16631,3952,8358,16623,1291,4185,3554,4558", -- Heavy Weave Armor
	[838]="1129:225:4:1:1:::1:0:3317,4175,5108,1214,16716,5821,3683,4164,3092,16631,3952,8358,16623,1291,4185,3554,4558", -- Heavy Weave Pants
	[839]="566:113:4:1:1:::1:0:3317,4175,5108,1214,16716,5821,3683,4164,3092,16631,3952,8358,16623,1291,4185,3554,4558", -- Heavy Weave Gloves
	[840]="853:170:4:1:1:::1:0:3317,4175,5108,1214,16716,5821,3683,4164,3092,16631,3952,8358,16623,1291,4185,3554,4558", -- Heavy Weave Shoes
	[841]="::12:1:1:::1:0:", -- Furlbrow\'s Pocket Watch
	[843]="1077:215:4:1:1:::1:0:3953,4236,3684,3483,5108,16747,4186,3093,3552,954,1295,8359,5820,16691,4164,3321,1669,10380,4558,896", -- Tanned Leather Boots
	[844]="721:144:4:1:1:::1:0:3953,4236,3684,3483,5108,16747,4186,3093,3552,954,1295,8359,5820,16691,4164,3321,1669,10380,4558,896", -- Tanned Leather Gloves
	[845]="1447:289:4:1:1:::1:0:3953,4236,3684,3483,5108,16747,4186,3093,3552,954,1295,8359,5820,16691,4164,3321,1669,10380,4558,896", -- Tanned Leather Pants
	[846]="1452:290:4:1:1:::1:0:3953,4236,3684,3483,5108,16747,4186,3093,3552,954,1295,8359,5820,16691,4164,3321,1669,10380,4558,896", -- Tanned Leather Jerkin
	[847]="1749:349:4:1:1:::1:0:5819,167,16750,4187,11703,4177,3483,3319,8360,3528,4164,3553,5812,1362,5107,4560,16625,1294", -- Chainmail Armor
	[848]="1755:351:4:1:1:::1:0:5819,167,16750,4187,11703,4177,3483,3319,8360,3528,4164,5812,3553,1362,5107,4560,16625,1294", -- Chainmail Pants
	[849]="1327:265:4:1:1:::1:0:5819,167,16750,4187,11703,4177,3483,3319,8360,3528,4164,5812,3553,1362,5107,4560,16625,1294", -- Chainmail Boots
	[850]="883:176:4:1:1:::1:0:5819,167,16750,4187,11703,4177,3483,3319,8360,3528,4164,5812,3553,1362,5107,4560,16625,1294", -- Chainmail Gloves
	[851]="2023:404:2:1:1:::1:0:3534,5120,3331,2997,3361,3479,3021,1289,16714,4183,3314,3658,4569,4203,4557,4171,1287,5103,4231", -- Cutlass
	[852]="1739:347:2:1:1:::1:0:2840,3534,2997,4602,3479,1348,1289,17412,4183,4233,3314,3658,5121,3360,4203,4557,222,1287,5103,3020,4231,16765", -- Mace
	[853]="2409:481:2:1:1:::1:0:3534,2997,3479,4601,1289,3019,16714,4183,3314,3658,4203,5119,4557,3409,5103,1287,4232,4231", -- Hatchet
	[854]="3023:604:2:1:1:::1:0:3534,2997,4602,3479,19238,1348,1289,17412,4183,4233,3314,3658,5121,3360,4203,4557,3409,1287,5103,3020,4231,16765", -- Quarter Staff
	[856]=":875:1:1:1:::1:0:", -- Blue Leather Bag
	[857]=":2500:1:1:1:::1:0:", -- Large Red Sack
	[858]="100:25:0:1:5:::1:0:14847,1257,3548,844,958,3658,2140", -- Lesser Healing Potion
	[859]=":87:4:1:1:::1:0:", -- Fine Cloth Shirt
	[860]=":89:4:1:1:::1:0:", -- Cavalier\'s Boots
	[862]=":38222:4:3:1:::1:0:", -- Runed Ring
	[863]=":8964:2:2:1:::1:0:", -- Gloom Reaper
	[864]=":9716:2:2:1:::1:0:", -- Knightly Longsword
	[865]=":5096:2:2:1:::1:0:", -- Leaden Mace
	[866]=":16640:2:2:1:::1:0:", -- Monk\'s Staff
	[867]=":5344:4:4:1:::1:0:", -- Gloves of Holy Might
	[868]=":21533:2:4:1:::1:0:", -- Ardent Custodian
	[869]=":18529:2:4:1:::1:0:", -- Dazzling Longsword
	[870]=":21528:2:4:1:::1:0:", -- Fiery War Axe
	[871]=":29628:2:4:1:::1:0:", -- Flurry Axe
	[872]=":2414:2:3:1:::1:0:", -- Rockslicer
	[873]=":21770:2:4:1:::1:0:", -- Staff of Jordan
	[878]=":56:7:0:10:::1:0:", -- Fist-sized Spinneret
	[880]=":2692:2:2:1:::1:0:", -- Staff of Horrors
	[884]="::12:1:20:::1:0:", -- Ghoul Rib
	[885]=":2301:2:2:1:::1:0:", -- Black Metal Axe
	[886]=":2949:2:2:1:::1:0:", -- Black Metal Shortsword
	[887]=":82:15:0:5:::1:0:", -- Pound of Flesh
	[888]=":980:4:3:1:::1:0:", -- Naga Battle Gloves
	[889]="::12:1:1:::1:0:", -- A Dusty Unsent Letter
	[890]=":3517:2:3:1:::1:0:", -- Twisted Chanter\'s Staff
	[892]=":370:4:2:1:::1:0:", -- Gnoll Casting Gloves
	[893]=":137:15:0:10:::1:0:", -- Dire Wolf Fang
	[897]=":1022:4:2:1:::1:0:", -- Madwolf Bracers
	[899]=":1248:2:2:1:::1:0:", -- Venom Web Fang
	[910]="::12:1:1:::1:0:", -- An Undelivered Letter
	[911]=":3324:2:2:1:::1:0:", -- Ironwood Treebranch
	[914]=":2669:4:2:1:::1:0:", -- Large Ogre Chain Armor
	[915]="::12:1:20:::1:0:", -- Red Silk Bandana
	[916]="::12:1:1:::1:0:", -- A Torn Journal Page
	[918]=":1250:1:1:1:::1:0:", -- Deviate Hide Pack
	[920]=":2821:2:2:1:::1:0:", -- Wicked Spiked Mace
	[921]="::12:1:1:::1:0:", -- A Faded Journal Page
	[922]="12039:2407:2:1:1:::1:0:16714,5120,1441,3331,4569,3361,4086,4203,3021,4171,3539,225,1289,1287,11137", -- Dacian Falx
	[923]="8744:1748:2:1:1:::1:0:16714,5120,1441,3331,4569,3361,4086,4203,3021,4171,3539,225,1289,1287,11137", -- Longsword
	[924]="10973:2194:2:1:1:::1:0:1441,4602,4086,1348,1289,17412,11137,4233,3360,5121,4203,3539,225,1287,3020,16765", -- Maul
	[925]="7797:1559:2:1:1:::1:0:1441,4602,4086,1348,1289,17412,11137,4233,3360,5121,4203,3539,225,1287,3020,16765", -- Flail
	[926]="9785:1957:2:1:1:::1:0:16714,1441,5119,4086,4203,4601,3539,225,1289,3409,1287,11137,3019,4232", -- Battle Axe
	[927]="6954:1390:2:1:1:::1:0:16714,1441,5119,4086,4203,4601,3539,225,1289,3409,1287,11137,3019,4232", -- Double Axe
	[928]="9860:1972:2:1:1:::1:0:1441,4602,4086,19238,1348,1289,17412,11137,4233,3360,5121,4203,3539,225,3409,1287,3020,16765", -- Long Staff
	[929]="300:75:0:1:5::197:1:0:3534,2805,3956,4878,13476,1453,4083,1307,8305,18810,1457,2481,3134", -- Healing Potion
	[932]=":637:1:1:1:::1:0:", -- Fel Steed Saddlebags
	[933]=":2500:1:1:1:::1:0:", -- Large Rucksack
	[934]=":10682:2:3:1:::1:0:", -- Stalvan\'s Reaper
	[935]=":1742:2:3:1:::1:0:", -- Night Watch Shortsword
	[936]=":11620:2:3:1:::1:0:", -- Midnight Mace
	[937]=":14577:2:3:1:::1:0:", -- Black Duskwood Staff
	[938]="::12:1:1:::1:0:", -- Muddy Journal Pages
	[939]="::12:1:1:::1:0:", -- A Bloodstained Journal Page
	[940]=":12566:4:4:1:::1:0:", -- Robes of Insight
	[942]=":4500:4:4:1:::1:0:", -- Freezing Band
	[943]=":42863:2:4:1:::1:0:", -- Warden Staff
	[944]=":80153:2:4:1:::1:0:", -- Elemental Mage Staff
	[954]="200:50:0:1:5:::1:0:14847,16224,2805,4878,13476,1316,958,4581", -- Scroll of Strength
	[955]="150:37:0:1:5:::1:0:14847,16224,1316,958,4581", -- Scroll of Intellect
	[957]="::12:1:1:::1:0:", -- William\'s Shipment
	[961]=":2:0:1:10:::1:0:", -- Healing Herb
	[962]="::12:1:1:::1:0:", -- Pork Belly Pie
	[981]="::12:1:1:::1:0:", -- Bernice\'s Necklace
	[983]=":21:4:1:1:::1:0:", -- Red Linen Sash
	[1006]="::12:1:1:::1:0:", -- Brass Collar
	[1008]=":144:2:1:1:::1:0:", -- Well-used Sword
	[1009]=":490:2:2:1:::1:0:", -- Compact Hammer
	[1010]=":99:2:1:1:::1:0:", -- Gnarled Short Staff
	[1011]=":80:2:1:1:::1:0:", -- Sharp Axe
	[1013]="::12:1:20:::1:0:", -- Iron Rivet
	[1015]=":24:7:1:10::185:1:0:", -- Lean Wolf Flank
	[1017]=":100:0:1:20:::1:0:", -- Seasoned Wolf Kabob
	[1019]="::12:1:20:::1:0:", -- Red Linen Bandana
	[1074]=":491:15:0:5:::1:0:", -- Hard Spider Leg Tip
	[1075]="::12:1:20:::1:0:", -- Shadowhide Pendant
	[1076]=":650:4:2:1:::1:0:", -- Defias Renegade Ring
	[1077]=":25:4:2:1:::1:0:", -- Defias Mage Ring
	[1080]=":78:7:1:10::185:1:0:", -- Tough Condor Meat
	[1081]=":50:7:1:10::185:1:0:", -- Crisp Spider Meat
	[1082]=":150:0:1:20:::1:0:", -- Redridge Goulash
	[1083]="::12:1:1:::1:0:", -- Glyph of Azora
	[1113]="::0:1:20:::1:0:", -- Conjured Bread
	[1114]="::0:1:20:::1:0:", -- Conjured Rye
	[1116]=":1250:4:2:1:::1:0:", -- Ring of Pure Silver
	[1121]=":1075:4:3:1:::1:0:", -- Feet of the Lynx
	[1127]=":25:0:1:10:::1:0:", -- Flash Bundle
	[1129]="::12:1:20:::1:0:", -- Ghoul Fang
	[1130]="::12:1:20:::1:0:", -- Vial of Spider Venom
	[1131]=":1136:4:2:1:::1:0:", -- Totem of Infliction
	[1132]="100000::15:3:1:::1:0:3362", -- Horn of the Timber Wolf
	[1154]=":102:4:1:1:::1:0:", -- Belt of the People\'s Militia
	[1155]=":5954:2:3:1:::1:0:", -- Rod of the Sleepwalker
	[1156]=":812:4:3:1:::1:0:", -- Lavishly Jeweled Ring
	[1158]=":146:2:1:1:::1:0:", -- Solid Metal Club
	[1159]=":32:2:1:1:::1:0:", -- Militia Quarterstaff
	[1161]=":25:2:1:1:::1:0:", -- Militia Shortsword
	[1166]=":16:4:1:1:::1:0:", -- Dented Buckler
	[1168]=":42296:4:4:1:::1:0:", -- Skullflame Shield
	[1169]=":18815:4:4:1:::1:0:", -- Blackskull Shield
	[1171]=":55:4:1:1:::1:0:", -- Well-stitched Robe
	[1172]=":968:4:2:1:::1:0:", -- Grayson\'s Torch
	[1173]=":52:4:1:1:::1:0:", -- Weather-worn Boots
	[1175]=":28:15:0:1:::1:0:", -- A Gold Tooth
	[1177]=":3:0:1:10:::1:0:", -- Oil of Olaf
	[1178]=":7:0:1:20:::1:0:", -- Explosive Rocket
	[1179]="125:6:0:1:20::185:5:0:6734,2352,15433,7736,5688,24993,24934,6790,10367,19617,6928,2303,982,11103,295,21145,16191,3689,4190,227,25012,6727,12959,17421,5611,734,18810,12021,16256,23573,25020,5111,5140,8139,3546,5112,7733,6747,8152,18811,12019,1448,17489,3961,3498,1464,19182,11116,15397,7731,4875,1697,1328,3481,11118,2806,465,4182,4571,7943,7744,3883,3577,1452,3934,4167,491,3937,2832,15174,955,17553,4981,6495,3621,14371,12096,5871,14624,2140,9356,1237,274,11287,4876,258,3298,4879,17656,24834,4084,3882,25052,4181,6746,8150,7941,4893,1285,6737,8143,14731,5814,4266,6738,4191,3959,2364,6740,6741,16618,4192,2803,16732,3313,4255,5620,8931,12097,791,6807,3884,6736,1682,3086,4555,2401,16443,4082,7942,12196,12027,1247,6930,16739,16553,25089,3962,6735,11038,11187,3881,2388,8137,12960,3411,6739,16542,23995,12026,8362,17630,3541,8125,16458,11106,4195,6929,16444,4782,16187,4554,7714,6091,24208,4169,2366,7485,6791,6272,7737,3708,1685,9501", -- Ice Cold Milk
	[1180]="150:37:0:1:5:::1:0:14847,16224,1316,958,4581", -- Scroll of Stamina
	[1181]="100:25:0:1:5:::1:0:14847,16224,1316,958,4581", -- Scroll of Spirit
	[1182]=":44:4:1:1:::1:0:", -- Brass-studded Bracers
	[1183]=":29:4:1:1:::1:0:", -- Elastic Wristguards
	[1187]=":1081:15:2:1:::1:0:", -- Spiked Collar
	[1189]=":625:4:2:1:::1:0:", -- Overseer\'s Ring
	[1190]=":418:4:2:1:::1:0:", -- Overseer\'s Cloak
	[1191]=":82:0:1:1:::1:0:", -- Bag of Marbles
	[1193]=":355:4:1:1:::1:0:", -- Banded Buckler
	[1194]="104:20:2:1:1:::1:0:78,945,3159,2997,4556,5102,3588,3314,2117,3073,16919,4231", -- Bastard Sword
	[1195]=":47:2:1:1:::1:0:", -- Kobold Mining Shovel
	[1196]="2214:442:2:1:1:::1:0:3534,2997,3479,4601,1289,3019,16714,4183,3314,3658,4203,5119,4557,3409,5103,1287,4232,4231", -- Tabar
	[1197]="2667:533:2:1:1:::1:0:2840,3534,2997,4602,3479,1348,1289,17412,4183,4233,3314,3658,5121,3360,4203,4557,222,1287,5103,3020,4231,16765", -- Giant Mace
	[1198]="2677:535:2:1:1:::1:0:3534,5120,3331,2997,3361,3479,3021,1289,16714,4183,3314,3658,4569,4203,4557,4171,1287,5103,4231", -- Claymore
	[1200]="82:16:4:1:1:::1:0:16693,2116,3075,4559,3161", -- Large Wooden Shield
	[1201]="473:94:4:1:1:::1:0:5106,16762,4240,17930,1249,1292,2046,3613", -- Dull Heater Shield
	[1202]="1839:367:4:1:1:::1:0:16693,4559,4187,3319,8360,16762,5107,4560,3528", -- Wall Shield
	[1203]=":23505:4:3:1:::1:0:", -- Aegis of Stormwind
	[1204]=":12577:4:4:1:::1:0:", -- The Green Tower
	[1205]="500:25:0:1:20:::5:0:6734,2352,15433,7736,5688,24993,24934,6790,10367,19617,6928,2303,982,11103,295,21145,12246,16191,3689,4190,227,25012,6727,12959,15125,5611,734,12021,16256,23573,25020,5111,5140,8139,3546,5112,7733,2084,6747,8152,18811,12019,1448,17489,3961,3498,15124,1464,19182,11116,15397,7731,4875,1697,1328,3625,11118,2806,2908,465,4571,1149,7943,7744,3883,3577,1452,3934,4167,3937,2832,15174,955,17553,4981,6495,3350,3621,14371,12096,5871,14624,9356,1237,274,11287,4876,258,3298,4879,17656,5134,24834,4084,3882,25052,4181,6746,8150,7941,4893,1285,11555,6737,8143,14731,5814,4266,6738,4191,3959,2364,6740,6741,16618,4192,2803,16732,3313,4255,5620,8931,12097,791,6807,3884,6736,3086,4555,2401,16443,14963,4082,7942,12196,1247,4241,12027,6930,16739,16553,2808,25089,3962,6735,11038,11187,3881,2388,8137,12960,3411,6739,16542,23995,12026,8362,17630,5101,4170,3541,8125,16458,11106,4195,14964,6929,4896,4782,4554,7714,6091,24208,4169,2366,7485,6791,2820,6272,7737,3708,9501", -- Melon Juice
	[1206]=":400:3:2:20::164,202,755,165:1:0:", -- Moss Agate
	[1207]=":9892:2:2:1:::1:0:", -- Murphstar
	[1208]="::12:1:1:::1:0:", -- Maybell\'s Love Letter
	[1210]=":250:3:2:20::164,202,755,165:1:0:", -- Shadowgem
	[1211]=":347:4:2:1:::1:0:", -- Gnoll War Harness
	[1212]=":21:15:0:5:::1:0:", -- Gnoll Spittle
	[1213]=":87:4:1:1:::1:0:", -- Gnoll Kindred Bracers
	[1214]=":930:2:2:1:::1:0:", -- Gnoll Punisher
	[1215]=":469:4:2:1:::1:0:", -- Support Girdle
	[1218]=":2064:2:2:1:::1:0:", -- Heavy Gnoll War Club
	[1219]=":823:2:2:1:::1:0:", -- Redridge Machete
	[1220]=":1807:2:2:1:::1:0:", -- Lupine Axe
	[1221]="::12:1:20:::1:0:", -- Underbelly Whelp Scale
	[1251]=":8:0:1:20:::1:0:", -- Linen Bandage
	[1252]="::12:1:1:::1:0:", -- Gramma Stonefield\'s Note
	[1254]="::4:1:1:::1:0:", -- Lesser Firestone
	[1256]="::12:1:20:::1:0:", -- Crystal Kelp Frond
	[1257]="::12:1:1:::1:0:", -- Invisibility Liquor
	[1260]="::12:1:1:::1:0:", -- Tharil\'zun\'s Head
	[1261]="::12:1:20:::1:0:", -- Midnight Orb
	[1262]=":111:0:1:1:::1:0:", -- Keg of Thunderbrew Lager
	[1263]=":79064:2:4:1:::1:0:", -- Brain Hacker
	[1264]=":3671:2:2:1:::1:0:", -- Headbasher
	[1265]=":11775:2:3:1:::1:0:", -- Scorpion Sting
	[1270]=":213:4:2:1:::1:0:", -- Finely Woven Cloak
	[1273]=":1656:4:2:1:::1:0:", -- Forest Chain
	[1274]=":8:12:1:20:::1:0:", -- Hops
	[1275]=":1668:4:2:1:::1:0:", -- Deputy Chain Coat
	[1276]=":2220:4:2:1:::1:0:", -- Fire Hardened Buckler
	[1280]=":3696:4:2:1:::1:0:", -- Cloaked Hood
	[1282]=":2825:4:2:1:::1:0:", -- Sparkmetal Coif
	[1283]="::12:1:1:::1:0:", -- Verner\'s Note
	[1284]="::12:1:1:::1:0:", -- Crate of Horseshoes
	[1287]=":703:2:2:1:::1:0:", -- Giant Tarantula Fang
	[1288]=":185:7:1:5::171,129:1:0:", -- Large Venom Sac
	[1292]=":3300:2:3:1:::1:0:", -- Butcher\'s Cleaver
	[1293]="::12:1:1:::1:0:", -- The State of Lakeshire
	[1294]="::12:1:1:::1:0:", -- The General\'s Response
	[1296]=":1681:2:2:1:::1:0:", -- Blackrock Mace
	[1297]=":2038:4:2:1:::1:0:", -- Robes of the Shadowcaster
	[1299]=":390:4:2:1:::1:0:", -- Lesser Belt of the Spire
	[1300]=":1854:2:2:1:::1:0:", -- Lesser Staff of the Spire
	[1302]=":262:4:2:1:::1:0:", -- Black Whelp Gloves
	[1303]=":418:4:2:1:::1:0:", -- Bridgeworker\'s Gloves
	[1304]=":279:4:2:1:::1:0:", -- Riding Gloves
	[1306]=":352:4:2:1:::1:0:", -- Wolfmane Wristguards
	[1307]="::12:1:1:::1:0:", -- Gold Pickup Schedule
	[1309]="::12:1:1:::1:0:", -- Oslow\'s Toolbox
	[1310]=":715:4:2:1:::1:0:", -- Smith\'s Trousers
	[1314]=":362:4:2:1:::1:0:", -- Ghoul Fingers
	[1315]=":13000:4:4:1:::1:0:", -- Lei of Lilies
	[1317]=":3500:2:2:1:::1:0:", -- Hardened Root Staff
	[1318]=":3066:2:3:1:::1:0:", -- Night Reaver
	[1319]=":462:4:2:1:::1:0:", -- Ring of Iron Will
	[1322]=":68:0:1:10:::1:0:", -- Fishliver Oil
	[1325]="::12:1:1:::1:0:", -- Daffodil Bouquet
	[1326]=":10:0:1:20:::1:0:", -- Sauteed Sunfish
	[1327]="::12:1:1:::1:0:", -- Wiley\'s Note
	[1349]="::12:1:1:::1:0:", -- Abercrombie\'s Crate
	[1351]=":768:4:2:1:::1:0:", -- Fingerbone Bracers
	[1353]="::12:1:1:::1:0:", -- Shaw\'s Report
	[1355]=":201:4:2:1:::1:0:", -- Buckskin Cape
	[1357]="::12:1:1:::1:0:", -- Captain Sander\'s Treasure Map
	[1358]="::12:1:1:::1:0:", -- A Clue to Sander\'s Treasure
	[1359]=":19:4:1:1:::1:0:", -- Lion-stamped Gloves
	[1360]=":42:4:1:1:::1:0:", -- Stormwind Chain Gloves
	[1361]="::12:1:1:::1:0:", -- Another Clue to Sander\'s Treasure
	[1362]="::12:1:1:::1:0:", -- Final Clue to Sander\'s Treasure
	[1364]=":8:4:0:1:::1:0:", -- Ragged Leather Vest
	[1366]=":2:4:0:1:::1:0:", -- Ragged Leather Pants
	[1367]=":2:4:0:1:::1:0:", -- Ragged Leather Boots
	[1368]=":2:4:0:1:::1:0:", -- Ragged Leather Gloves
	[1369]=":4:4:0:1:::1:0:", -- Ragged Leather Belt
	[1370]=":2:4:0:1:::1:0:", -- Ragged Leather Bracers
	[1372]=":2:4:0:1:::1:0:", -- Ragged Cloak
	[1374]=":3:4:0:1:::1:0:", -- Frayed Shoes
	[1376]=":4:4:0:1:::1:0:", -- Frayed Cloak
	[1377]=":1:4:0:1:::1:0:", -- Frayed Gloves
	[1378]=":1:4:0:1:::1:0:", -- Frayed Pants
	[1380]=":4:4:0:1:::1:0:", -- Frayed Robe
	[1381]="::12:1:1:::1:0:", -- A Mysterious Message
	[1382]=":24:2:1:1:::1:0:", -- Rock Mace
	[1383]=":25:2:1:1:::1:0:", -- Stone Tomahawk
	[1384]=":11:2:1:1:::1:0:", -- Dull Blade
	[1386]=":32:2:1:1:::1:0:", -- Thistlewood Axe
	[1387]=":1578:2:2:1:::1:0:", -- Ghoulfang
	[1388]=":14:2:1:1:::1:0:", -- Crooked Staff
	[1389]=":58:2:1:1:::1:0:", -- Kobold Mining Mallet
	[1391]=":1392:2:2:1:::1:0:", -- Riverpaw Mystic Staff
	[1394]=":740:2:2:1:::1:0:", -- Driftwood Club
	[1395]="5:1:4:0:1:::1:0:18672", -- Apprentice\'s Pants
	[1396]="4:1:4:0:1:::1:0:18672", -- Acolyte\'s Pants
	[1399]=":12:0:1:20:::1:0:", -- Magic Candle
	[1401]=":14:0:1:20:::1:0:", -- Green Tea Leaf
	[1404]=":10306:4:2:1:::1:0:", -- Tidal Charm
	[1405]=":1184:2:2:1:::1:0:", -- Foamspittle Staff
	[1406]=":2079:2:2:1:::1:0:", -- Pearl-encrusted Spear
	[1407]="::12:1:1:::1:0:", -- Solomon\'s Plea to Westfall
	[1408]="::12:1:1:::1:0:", -- Stoutmantle\'s Response to Solomon
	[1409]="::12:1:1:::1:0:", -- Solomon\'s Plea to Darkshire
	[1410]="::12:1:1:::1:0:", -- Ebonlocke\'s Response to Solomon
	[1411]=":68:2:0:1:::1:0:", -- Withered Staff
	[1412]=":49:2:0:1:::1:0:", -- Crude Bastard Sword
	[1413]=":55:2:0:1:::1:0:", -- Feeble Sword
	[1414]=":97:2:0:1:::1:0:", -- Cracked Sledge
	[1415]=":72:2:0:1:::1:0:", -- Carpenter\'s Mallet
	[1416]=":72:2:0:1:::1:0:", -- Rusty Hatchet
	[1417]=":65:2:0:1:::1:0:", -- Beaten Battle Axe
	[1418]=":9:4:0:1:::1:0:", -- Worn Leather Belt
	[1419]=":19:4:0:1:::1:0:", -- Worn Leather Boots
	[1420]=":18:4:0:1:::1:0:", -- Worn Leather Bracers
	[1421]=":28:4:0:1:::1:0:", -- Worn Hide Cloak
	[1422]=":6:4:0:1:::1:0:", -- Worn Leather Gloves
	[1423]=":19:4:0:1:::1:0:", -- Worn Leather Pants
	[1425]=":37:4:0:1:::1:0:", -- Worn Leather Vest
	[1427]=":29:4:0:1:::1:0:", -- Patchwork Shoes
	[1429]=":7:4:0:1:::1:0:", -- Patchwork Cloak
	[1430]=":7:4:0:1:::1:0:", -- Patchwork Gloves
	[1431]=":20:4:0:1:::1:0:", -- Patchwork Pants
	[1433]=":14:4:0:1:::1:0:", -- Patchwork Armor
	[1434]=":43:0:1:20:::1:0:", -- Glowing Wax Stick
	[1436]=":458:4:2:1:::1:0:", -- Frontier Britches
	[1438]=":70:4:1:1:::1:0:", -- Warrior\'s Shield
	[1440]=":1230:2:2:1:::1:0:", -- Gnoll Skull Basher
	[1443]=":21125:4:4:1:::1:0:", -- Jeweled Amulet of Cainwyn
	[1445]=":584:4:1:1:::1:0:", -- Blackrock Pauldrons
	[1446]=":568:4:2:1:::1:0:", -- Blackrock Boots
	[1447]=":22775:4:4:1:::1:0:", -- Ring of Saviors
	[1448]=":405:4:2:1:::1:0:", -- Blackrock Gauntlets
	[1449]=":1875:4:2:1:::1:0:", -- Minor Channeling Ring
	[1451]="::12:1:1:::1:0:", -- Bottle of Zombie Juice
	[1453]="::12:1:1:::1:0:", -- Spectral Comb
	[1454]=":3937:2:3:1:::1:0:", -- Axe of the Enforcer
	[1455]=":2931:2:2:1:::1:0:", -- Blackrock Champion\'s Axe
	[1457]=":1850:2:2:1:::1:0:", -- Shadowhide Mace
	[1458]=":2623:2:2:1:::1:0:", -- Shadowhide Maul
	[1459]=":2380:2:2:1:::1:0:", -- Shadowhide Scalper
	[1460]=":1768:2:2:1:::1:0:", -- Shadowhide Two-handed Sword
	[1461]=":3387:2:2:1:::1:0:", -- Slayer\'s Battle Axe
	[1462]=":1306:4:2:1:::1:0:", -- Ring of the Shadow
	[1464]=":71:15:0:5:::1:0:", -- Buzzard Talon
	[1465]=":9825:2:2:1:::1:0:", -- Tigerbane
	[1467]="::12:1:20:::1:0:", -- Spotted Sunfish
	[1468]=":28:7:1:10::185:1:0:", -- Murloc Fin
	[1469]=":1180:2:2:1:::1:0:", -- Scimitar of Atun
	[1470]=":875:1:1:1:::1:0:", -- Murloc Skin Bag
	[1473]=":1497:2:2:1:::1:0:", -- Riverside Staff
	[1475]=":82:7:1:5::129:1:0:", -- Small Venom Sac
	[1476]=":6:15:0:5:::1:0:", -- Snapped Spider Limb
	[1477]="350:87:0:1:5:::1:0:14847,12246", -- Scroll of Agility II
	[1478]="250:62:0:1:5:::1:0:2805,4878,13476,1316,4581", -- Scroll of Protection II
	[1479]=":47:4:1:1:::1:0:", -- Salma\'s Oven Mitts
	[1480]=":954:2:2:1:::1:0:", -- Fist of the People\'s Militia
	[1481]=":3337:2:3:1:::1:0:", -- Grimclaw
	[1482]=":2964:2:3:1:::1:0:", -- Shadowfang
	[1483]=":2025:2:3:1:::1:0:", -- Face Smasher
	[1484]=":2922:2:3:1:::1:0:", -- Witching Stave
	[1485]=":1410:2:0:1:::1:0:", -- Pitchfork
	[1486]=":1202:4:3:1:::1:0:", -- Tree Bark Jacket
	[1487]="::0:1:20:::1:0:", -- Conjured Pumpernickel
	[1488]=":3379:4:3:1:::1:0:", -- Avenger\'s Armor
	[1489]=":1553:4:3:1:::1:0:", -- Gloomshroud Armor
	[1490]=":8910:4:2:1:::1:0:", -- Guardian Talisman
	[1491]=":2207:4:3:1:::1:0:", -- Ring of Precision
	[1493]=":3922:2:3:1:::1:0:", -- Heavy Marauder Scimitar
	[1495]=":59:4:0:1:::1:0:", -- Calico Shoes
	[1497]=":71:4:0:1:::1:0:", -- Calico Cloak
	[1498]=":57:4:0:1:::1:0:", -- Calico Gloves
	[1499]=":51:4:0:1:::1:0:", -- Calico Pants
	[1501]=":80:4:0:1:::1:0:", -- Calico Tunic
	[1502]=":60:4:0:1:::1:0:", -- Warped Leather Belt
	[1503]=":109:4:0:1:::1:0:", -- Warped Leather Boots
	[1504]=":32:4:0:1:::1:0:", -- Warped Leather Bracers
	[1505]=":48:4:0:1:::1:0:", -- Warped Cloak
	[1506]=":51:4:0:1:::1:0:", -- Warped Leather Gloves
	[1507]=":123:4:0:1:::1:0:", -- Warped Leather Pants
	[1509]=":59:4:0:1:::1:0:", -- Warped Leather Vest
	[1510]=":150:2:0:1:::1:0:", -- Heavy Hammer
	[1511]=":194:2:0:1:::1:0:", -- Commoner\'s Sword
	[1512]=":194:2:0:1:::1:0:", -- Crude Battle Axe
	[1513]=":293:2:0:1:::1:0:", -- Old Greatsword
	[1514]=":294:2:0:1:::1:0:", -- Rusty Warhammer
	[1515]=":196:2:0:1:::1:0:", -- Rough Wooden Staff
	[1516]=":237:2:0:1:::1:0:", -- Worn Hatchet
	[1518]="::12:1:1:::1:0:", -- Ghost Hair Comb
	[1519]="::12:1:20:::1:0:", -- Bloodscalp Ear
	[1520]=":71:15:0:5:::1:0:", -- Troll Sweat
	[1521]=":19205:2:2:1:::1:0:", -- Lumbering Ogre Axe
	[1522]=":10224:2:2:1:::1:0:", -- Headhunting Spear
	[1523]=":10261:2:2:1:::1:0:", -- Huge Stone Club
	[1524]="::12:1:20:::1:0:", -- Skullsplitter Tusk
	[1528]="::12:1:20:::1:0:", -- Handful of Oats
	[1529]=":700:3:2:20::164,202,755,165,197:1:0:", -- Jade
	[1532]="::12:1:20:::1:0:", -- Shrunken Head
	[1537]=":62:1:1:1:::1:0:", -- Old Blanchy\'s Feed Pouch
	[1539]=":1572:2:2:1:::1:0:", -- Gnarled Hermit\'s Staff
	[1547]=":2795:4:2:1:::1:0:", -- Shield of the Faith
	[1557]=":919:4:2:1:::1:0:", -- Buckler of the Seas
	[1560]=":513:4:2:1:::1:0:", -- Bluegill Sandals
	[1561]=":268:4:2:1:::1:0:", -- Harvester\'s Robe
	[1566]=":1132:2:2:1:::1:0:", -- Edge of the People\'s Militia
	[1596]="::12:1:1:::1:0:", -- Ghost Hair Thread
	[1598]="::12:1:20:::1:0:", -- Rot Blossom
	[1602]=":11685:2:3:1:::1:0:", -- Sickle Axe
	[1604]=":19464:2:2:1:::1:0:", -- Chromatic Sword
	[1607]=":43420:2:3:1:::1:0:", -- Soulkeeper
	[1608]=":18940:2:2:1:::1:0:", -- Skullcrusher Mace
	[1613]=":19139:2:2:1:::1:0:", -- Spiritchaser Staff
	[1624]=":6172:4:2:1:::1:0:", -- Skullsplitter Helm
	[1625]=":14754:2:2:1:::1:0:", -- Exquisite Flamberge
	[1630]=":66:15:0:5:::1:0:", -- Broken Electro-lantern
	[1637]="::12:1:1:::1:0:", -- Letter to Ello
	[1639]=":28460:2:2:1:::1:0:", -- Grinning Axe
	[1640]=":15637:2:2:1:::1:0:", -- Monstrous War Axe
	[1645]="2000:100:0:1:20:::5:0:6734,2352,15433,7736,5688,24993,24934,6790,10367,19617,6928,2303,982,11103,295,21145,12246,16191,3689,4190,25012,6727,12959,15125,5611,734,12021,16256,23573,25020,5111,5140,8139,3546,5112,7733,2084,6747,8152,12019,3961,15124,1464,19182,11116,15397,7731,4875,1697,1328,3625,11118,2806,2908,465,4571,1149,7943,7744,3883,3577,3934,4167,3937,2832,15174,955,17553,4981,6495,3350,3621,14371,12096,5871,14624,9356,1237,274,11287,258,3298,4879,17656,5134,24834,3882,25052,4181,6746,8150,7941,4893,1285,11555,6737,8143,14731,5814,4266,6738,4191,3959,2364,6740,6741,16618,4192,2803,16732,3313,4255,5620,8931,12097,6807,3884,6736,3086,4555,2401,16443,14963,7942,12196,4241,12027,1247,6930,16739,16553,2808,25089,6735,11038,11187,3881,2388,8137,12960,3411,16542,6739,23995,12026,8362,17630,5101,4170,3541,8125,16458,11106,4195,14964,6929,4896,4782,4554,7714,6091,24208,4169,2366,7485,6791,2820,6272,7737,3708,9501", -- Moonberry Juice
	[1652]=":5000:1:1:1:::1:0:", -- Sturdy Lunchbox
	[1656]="::12:1:1:::1:0:", -- Translated Letter
	[1659]=":2136:4:2:1:::1:0:", -- Engineering Gloves
	[1664]=":14695:2:2:1:::1:0:", -- Spellforce Rod
	[1677]=":10093:4:2:1:::1:0:", -- Drake-scale Vest
	[1678]=":4581:4:3:1:::1:0:", -- Black Ogre Kickers
	[1679]=":9635:2:2:1:::1:0:", -- Korg Bat
	[1680]=":18234:2:2:1:::1:0:", -- Headchopper
	[1685]=":6250:1:1:1:::1:0:", -- Troll-hide Bag
	[1686]=":733:15:0:10:::1:0:", -- Bristly Whisker
	[1687]=":243:15:0:5:::1:0:", -- Retractable Claw
	[1688]=":806:15:0:5:::1:0:", -- Long Soft Tail
	[1696]=":606:15:0:5:::1:0:", -- Curved Raptor Talon
	[1697]=":445:15:0:10:::1:0:", -- Keen Raptor Tooth
	[1701]=":376:15:0:5:::1:0:", -- Curved Basilisk Claw
	[1702]=":320:15:0:5:::1:0:", -- Intact Basilisk Spine
	[1703]=":81:0:1:10:::1:0:", -- Crystal Basilisk Spine
	[1705]=":600:3:2:20::164,202,755:1:0:", -- Lesser Moonstone
	[1706]=":86:15:0:10:::1:0:", -- Azuredeep Shards
	[1707]="1000:62:0:1:20:::5:0:4255,6746,4981,483,5620,2352,4894,23604,4782,23521,3546,24934,18929,6790,10367,1237,465,17630,2364,4891,295,3298,6930,9501,11106,16553,11116", -- Stormwind Brie
	[1708]="1000:50:0:1:20:::5:0:6734,2352,15433,7736,5688,24993,24934,6790,10367,19617,6928,2303,982,11103,295,21145,12246,16191,3689,4190,25012,6727,12959,15125,5611,734,12021,16256,23573,25020,5111,5140,8139,3546,5112,7733,2084,6747,8152,12019,3961,15124,1464,19182,11116,15397,7731,4875,1697,1328,3625,11118,2806,2908,465,4571,1149,7943,7744,3883,3577,3934,4167,3937,2832,15174,955,17553,4981,6495,3350,3621,14371,12096,5871,14624,9356,1237,274,11287,258,3298,4879,17656,5134,24834,3882,25052,4181,6746,8150,7941,4893,1285,11555,6737,8143,14731,5814,4266,6738,4191,3959,2364,6740,6741,16618,4192,2803,16732,3313,4255,5620,8931,12097,6807,3884,6736,3086,4555,2401,16443,14963,7942,12196,4241,12027,1247,6930,16739,16553,2808,25089,6735,11038,11187,3881,2388,8137,12960,3411,16542,6739,23995,12026,8362,17630,5101,4170,3541,8125,16458,11106,4195,14964,6929,4896,4782,4554,7714,6091,24208,4169,2366,7485,6791,2820,6272,7737,3708,9501", -- Sweet Nectar
	[1710]="500:125:0:1:5:::1:0:2380,2848,12245,2480,2812,4899", -- Greater Healing Potion
	[1711]="300:75:0:1:5:::1:0:14847,2805,12246,4878,13476,1316,4581", -- Scroll of Stamina II
	[1712]="250:62:0:1:5:::1:0:2805,4878,13476,1316,4581", -- Scroll of Spirit II
	[1713]=":5350:4:3:1:::1:0:", -- Ankh of Life
	[1714]=":2535:4:3:1:::1:0:", -- Necklace of Calisea
	[1715]=":10301:4:3:1:::1:0:", -- Polished Jazeraint Armor
	[1716]=":5067:4:3:1:::1:0:", -- Robe of the Magi
	[1717]=":3108:4:3:1:::1:0:", -- Double Link Tunic
	[1718]=":8040:4:3:1:::1:0:", -- Basilisk Hide Pants
	[1720]=":26209:2:3:1:::1:0:", -- Tanglewood Staff
	[1721]=":35815:2:3:1:::1:0:", -- Viking Warhammer
	[1722]=":19407:2:3:1:::1:0:", -- Thornstone Sledgehammer
	[1725]=":5000:1:1:1:::1:0:", -- Large Knapsack
	[1726]=":12183:2:3:1:::1:0:", -- Poison-tipped Bone Spear
	[1727]=":4562:2:3:1:::1:0:", -- Sword of Decay
	[1728]=":72936:2:4:1:::1:0:", -- Teebu\'s Blazing Longsword
	[1729]=":500:1:1:1:::1:0:", -- Gunnysack of the Night Watch
	[1730]=":48:4:0:1:::1:0:", -- Worn Mail Belt
	[1731]=":92:4:0:1:::1:0:", -- Worn Mail Boots
	[1732]=":73:4:0:1:::1:0:", -- Worn Mail Bracers
	[1733]=":88:4:0:1:::1:0:", -- Worn Cloak
	[1734]=":39:4:0:1:::1:0:", -- Worn Mail Gloves
	[1735]=":89:4:0:1:::1:0:", -- Worn Mail Pants
	[1737]=":139:4:0:1:::1:0:", -- Worn Mail Vest
	[1738]=":147:4:0:1:::1:0:", -- Laced Mail Belt
	[1739]=":255:4:0:1:::1:0:", -- Laced Mail Boots
	[1740]=":97:4:0:1:::1:0:", -- Laced Mail Bracers
	[1741]=":112:4:0:1:::1:0:", -- Laced Cloak
	[1742]=":129:4:0:1:::1:0:", -- Laced Mail Gloves
	[1743]=":299:4:0:1:::1:0:", -- Laced Mail Pants
	[1744]=":260:4:0:1:::1:0:", -- Laced Mail Shoulderpads
	[1745]=":198:4:0:1:::1:0:", -- Laced Mail Vest
	[1746]=":332:4:0:1:::1:0:", -- Linked Chain Belt
	[1747]=":302:4:0:1:::1:0:", -- Linked Chain Boots
	[1748]=":232:4:0:1:::1:0:", -- Linked Chain Bracers
	[1749]=":263:4:0:1:::1:0:", -- Linked Chain Cloak
	[1750]=":298:4:0:1:::1:0:", -- Linked Chain Gloves
	[1751]=":676:4:0:1:::1:0:", -- Linked Chain Pants
	[1752]=":286:4:0:1:::1:0:", -- Linked Chain Shoulderpads
	[1753]=":439:4:0:1:::1:0:", -- Linked Chain Vest
	[1754]=":359:4:0:1:::1:0:", -- Reinforced Chain Belt
	[1755]=":597:4:0:1:::1:0:", -- Reinforced Chain Boots
	[1756]=":438:4:0:1:::1:0:", -- Reinforced Chain Bracers
	[1757]=":483:4:0:1:::1:0:", -- Reinforced Chain Cloak
	[1758]=":534:4:0:1:::1:0:", -- Reinforced Chain Gloves
	[1759]=":732:4:0:1:::1:0:", -- Reinforced Chain Pants
	[1760]=":609:4:0:1:::1:0:", -- Reinforced Chain Shoulderpads
	[1761]=":892:4:0:1:::1:0:", -- Reinforced Chain Vest
	[1764]=":113:4:0:1:::1:0:", -- Canvas Shoes
	[1766]=":131:4:0:1:::1:0:", -- Canvas Cloak
	[1767]=":101:4:0:1:::1:0:", -- Canvas Gloves
	[1768]=":217:4:0:1:::1:0:", -- Canvas Pants
	[1769]=":163:4:0:1:::1:0:", -- Canvas Shoulderpads
	[1770]=":143:4:0:1:::1:0:", -- Canvas Vest
	[1772]=":247:4:0:1:::1:0:", -- Brocade Shoes
	[1774]=":281:4:0:1:::1:0:", -- Brocade Cloak
	[1775]=":212:4:0:1:::1:0:", -- Brocade Gloves
	[1776]=":257:4:0:1:::1:0:", -- Brocade Pants
	[1777]=":222:4:0:1:::1:0:", -- Brocade Shoulderpads
	[1778]=":337:4:0:1:::1:0:", -- Brocade Vest
	[1780]=":489:4:0:1:::1:0:", -- Cross-stitched Sandals
	[1782]=":542:4:0:1:::1:0:", -- Cross-stitched Cloak
	[1783]=":247:4:0:1:::1:0:", -- Cross-stitched Gloves
	[1784]=":546:4:0:1:::1:0:", -- Cross-stitched Pants
	[1785]=":464:4:0:1:::1:0:", -- Cross-stitched Shoulderpads
	[1786]=":683:4:0:1:::1:0:", -- Cross-stitched Vest
	[1787]=":102:4:0:1:::1:0:", -- Patched Leather Belt
	[1788]=":177:4:0:1:::1:0:", -- Patched Leather Boots
	[1789]=":136:4:0:1:::1:0:", -- Patched Leather Bracers
	[1790]=":93:4:0:1:::1:0:", -- Patched Cloak
	[1791]=":90:4:0:1:::1:0:", -- Patched Leather Gloves
	[1792]=":208:4:0:1:::1:0:", -- Patched Leather Pants
	[1793]=":207:4:0:1:::1:0:", -- Patched Leather Shoulderpads
	[1794]=":277:4:0:1:::1:0:", -- Patched Leather Jerkin
	[1795]=":235:4:0:1:::1:0:", -- Rawhide Belt
	[1796]=":400:4:0:1:::1:0:", -- Rawhide Boots
	[1797]=":161:4:0:1:::1:0:", -- Rawhide Bracers
	[1798]=":223:4:0:1:::1:0:", -- Rawhide Cloak
	[1799]=":211:4:0:1:::1:0:", -- Rawhide Gloves
	[1800]=":479:4:0:1:::1:0:", -- Rawhide Pants
	[1801]=":418:4:0:1:::1:0:", -- Rawhide Shoulderpads
	[1802]=":337:4:0:1:::1:0:", -- Rawhide Tunic
	[1803]=":465:4:0:1:::1:0:", -- Tough Leather Belt
	[1804]=":478:4:0:1:::1:0:", -- Tough Leather Boots
	[1805]=":351:4:0:1:::1:0:", -- Tough Leather Bracers
	[1806]=":466:4:0:1:::1:0:", -- Tough Cloak
	[1807]=":388:4:0:1:::1:0:", -- Tough Leather Gloves
	[1808]=":856:4:0:1:::1:0:", -- Tough Leather Pants
	[1809]=":440:4:0:1:::1:0:", -- Tough Leather Shoulderpads
	[1810]=":648:4:0:1:::1:0:", -- Tough Leather Armor
	[1811]=":451:2:0:1:::1:0:", -- Blunt Claymore
	[1812]=":453:2:0:1:::1:0:", -- Short-handled Battle Axe
	[1813]=":523:2:0:1:::1:0:", -- Chipped Quarterstaff
	[1814]=":603:2:0:1:::1:0:", -- Battered Mallet
	[1815]=":366:2:0:1:::1:0:", -- Ornamental Mace
	[1816]=":486:2:0:1:::1:0:", -- Unbalanced Axe
	[1817]=":501:2:0:1:::1:0:", -- Stock Shortsword
	[1818]=":1221:2:0:1:::1:0:", -- Standard Claymore
	[1819]=":768:2:0:1:::1:0:", -- Gouging Pick
	[1820]=":963:2:0:1:::1:0:", -- Wooden Maul
	[1821]=":988:2:0:1:::1:0:", -- Warped Blade
	[1822]=":1096:2:0:1:::1:0:", -- Cedar Walking Stick
	[1823]=":779:2:0:1:::1:0:", -- Bludgeoning Cudgel
	[1824]=":1104:2:0:1:::1:0:", -- Shiny War Axe
	[1825]=":1548:2:0:1:::1:0:", -- Bulky Bludgeon
	[1826]=":1765:2:0:1:::1:0:", -- Rock Maul
	[1827]=":1282:2:0:1:::1:0:", -- Meat Cleaver
	[1828]=":1609:2:0:1:::1:0:", -- Stone War Axe
	[1829]=":1563:2:0:1:::1:0:", -- Short Cutlass
	[1830]=":1783:2:0:1:::1:0:", -- Long Bastard Sword
	[1831]=":1790:2:0:1:::1:0:", -- Oaken War Staff
	[1832]=":362:4:2:1:::1:0:", -- Lucky Trousers
	[1835]="31:6:4:1:1:::1:0:3074,4558,2113,3160", -- Dirty Leather Belt
	[1836]="31:6:4:1:1:::1:0:3074,4558,2113,3160", -- Dirty Leather Bracers
	[1839]="185:37:4:1:1:::1:0:1238,4164,3953,4236,3612,3162,16747,17929,74,3532,1295,896,5820", -- Rough Leather Belt
	[1840]="185:37:4:1:1:::1:0:1238,4164,3953,4236,3612,3162,16747,17929,74,3532,1295,896,5820", -- Rough Leather Bracers
	[1843]="726:145:4:1:1:::1:0:3953,4236,3684,3483,5108,16747,4186,3093,3552,954,1295,8359,5820,16691,4164,3321,1669,10380,4558,896", -- Tanned Leather Belt
	[1844]="728:145:4:1:1:::1:0:3953,4236,3684,3483,5108,16747,4186,3093,3552,954,1295,8359,5820,16691,4164,3321,1669,10380,4558,896", -- Tanned Leather Bracers
	[1845]="877:175:4:1:1:::1:0:5819,167,16750,4187,11703,4177,3483,3319,8360,3528,4164,3553,5812,1362,5107,4560,16625,1294", -- Chainmail Belt
	[1846]="881:176:4:1:1:::1:0:5819,167,16750,4187,11703,4177,3483,3319,8360,3528,4164,5812,3553,1362,5107,4560,16625,1294", -- Chainmail Bracers
	[1849]="1388:277:4:1:1:::1:0:3536,3953,16691,4236,1695,3321,3097,16747,3492,3093,1295,5783,8359,5820", -- Cured Leather Belt
	[1850]="1393:278:4:1:1:::1:0:3536,3953,16691,4236,1695,3321,3097,16747,3492,3093,1295,5783,8359,5820", -- Cured Leather Bracers
	[1852]="1684:336:4:1:1:::1:0:5819,5812,16750,5125,4177,956,3319,3682,8360,1341,16625,3543,1294,3493", -- Scalemail Bracers
	[1853]="1690:338:4:1:1:::1:0:5819,5812,16750,5125,4177,956,3319,3682,8360,1341,16625,3543,1294,3493", -- Scalemail Belt
	[1875]="::12:1:1:::1:0:", -- Thistlenettle\'s Badge
	[1893]=":1775:2:2:1:::1:0:", -- Miner\'s Revenge
	[1894]="::12:1:20:::1:0:", -- Miners\' Union Card
	[1913]=":148:2:1:1:::1:0:", -- Studded Blackjack
	[1917]=":251:2:2:1:::1:0:", -- Jeweled Dagger
	[1922]="::12:1:1:::1:0:", -- Supplies for Sven
	[1923]="::12:1:1:::1:0:", -- Ambassador\'s Satchel
	[1925]=":787:2:2:1:::1:0:", -- Defias Rapier
	[1926]=":687:2:2:1:::1:0:", -- Weighted Sap
	[1927]=":690:2:2:1:::1:0:", -- Deadmines Cleaver
	[1928]=":996:2:2:1:::1:0:", -- Defias Mage Staff
	[1929]=":434:4:2:1:::1:0:", -- Silk-threaded Trousers
	[1930]=":327:4:2:1:::1:0:", -- Stonemason Cloak
	[1931]="::12:1:1:::1:0:", -- Huge Gnoll Claw
	[1933]=":905:2:2:1:::1:0:", -- Staff of Conjuring
	[1934]=":731:4:2:1:::1:0:", -- Stonemason Trousers
	[1935]=":2974:2:3:1:::1:0:", -- Assassin\'s Blade
	[1936]=":1114:2:2:1:::1:0:", -- Goblin Screwdriver
	[1937]=":2040:2:3:1:::1:0:", -- Buzz Saw
	[1938]=":1962:2:2:1:::1:0:", -- Block Mallet
	[1939]="675:168:12:1:1:::1:0:465", -- Skin of Sweet Rum
	[1941]="815:203:12:1:1:::1:0:277", -- Cask of Merlot
	[1942]="1265:316:12:1:1:::1:0:274", -- Bottle of Moonshine
	[1943]=":713:4:2:1:::1:0:", -- Goblin Mail Leggings
	[1944]=":259:4:2:1:::1:0:", -- Metalworking Gloves
	[1945]=":267:4:2:1:::1:0:", -- Woodworking Gloves
	[1946]="::12:1:1:::1:0:", -- Mary\'s Looking Glass
	[1951]=":1258:2:2:1:::1:0:", -- Blackwater Cutlass
	[1955]=":1573:4:2:1:::1:0:", -- Dragonmaw Chain Boots
	[1956]="::12:1:1:::1:0:", -- Faded Shadowhide Pendant
	[1958]=":975:2:2:1:::1:0:", -- Petrified Shinbone
	[1959]=":1223:2:2:1:::1:0:", -- Cold Iron Pick
	[1962]="::12:1:1:::1:0:", -- Glowing Shadowhide Pendant
	[1965]=":36:4:1:1:::1:0:", -- White Wolf Gloves
	[1968]="::12:1:1:::1:0:", -- Ogre\'s Monocle
	[1970]=":120:0:1:10:::1:0:", -- Restoring Balm
	[1971]="::12:1:1:::1:0:", -- Furlbrow\'s Deed
	[1972]="::12:1:1:::1:0:", -- Westfall Deed
	[1973]=":4618:4:3:1:::1:0:", -- Orb of Deception
	[1974]=":464:4:3:1:::1:0:", -- Mindthrust Bracers
	[1975]=":5744:2:3:1:::1:0:", -- Pysan\'s Old Greatsword
	[1976]=":6340:2:3:1:::1:0:", -- Slaghammer
	[1978]=":981:4:3:1:::1:0:", -- Wolfclaw Gloves
	[1979]=":23274:4:4:1:::1:0:", -- Wall of the Dead
	[1980]=":6200:4:4:1:::1:0:", -- Underworld Band
	[1981]=":14113:4:4:1:::1:0:", -- Icemail Jerkin
	[1982]=":29513:2:4:1:::1:0:", -- Nightblade
	[1986]=":14861:2:2:1:::1:0:", -- Gutrender
	[1987]="::12:1:1:::1:0:", -- Krazek\'s Fixed Pot
	[1988]=":2852:4:2:1:::1:0:", -- Chief Brigadier Gauntlets
	[1990]=":10077:2:2:1:::1:0:", -- Ballast Maul
	[1991]=":8357:2:2:1:::1:0:", -- Goblin Power Shovel
	[1992]=":5468:4:3:1:::1:0:", -- Swampchill Fetish
	[1993]=":2100:4:2:1:::1:0:", -- Ogremind Ring
	[1994]=":16696:2:2:1:::1:0:", -- Ebonclaw Reaver
	[1996]=":1720:4:2:1:::1:0:", -- Voodoo Band
	[1997]=":2539:4:2:1:::1:0:", -- Pressed Felt Robe
	[1998]=":7239:2:2:1:::1:0:", -- Bloodscalp Channeling Staff
	[2000]=":8827:2:2:1:::1:0:", -- Archeus
	[2004]="::12:1:1:::1:0:", -- Grelin Whitebeard\'s Journal
	[2005]="::12:1:1:::1:0:", -- The First Troll Legend
	[2006]="::12:1:1:::1:0:", -- The Second Troll Legend
	[2007]="::12:1:1:::1:0:", -- The Third Troll Legend
	[2008]="::12:1:1:::1:0:", -- The Fourth Troll Legend
	[2011]=":3840:2:3:1:::1:0:", -- Twisted Sabre
	[2013]=":3644:2:2:1:::1:0:", -- Cryptbone Staff
	[2014]=":4869:2:2:1:::1:0:", -- Black Metal Greatsword
	[2015]=":4443:2:2:1:::1:0:", -- Black Metal War Axe
	[2017]=":895:4:2:1:::1:0:", -- Glowing Leather Bracers
	[2018]=":3269:2:2:1:::1:0:", -- Skeletal Longsword
	[2020]=":1050:2:2:1:::1:0:", -- Hollowfang Blade
	[2021]=":1025:4:2:1:::1:0:", -- Green Carapace Shield
	[2024]="6079:1215:2:1:1:::1:0:5120,3331,2997,3361,3021,1289,16714,4569,4203,4557,4171,225,5103,1287,3491,4231", -- Espadon
	[2025]="5305:1061:2:1:1:::1:0:16714,2997,5119,4203,4557,4601,225,1289,3409,1287,5103,3019,4232,4231,3491", -- Bearded Axe
	[2026]="6286:1257:2:1:1:::1:0:2997,4602,1348,1289,17412,4233,3360,5121,4203,4557,225,5103,1287,3020,3491,4231,16765", -- Rock Hammer
	[2027]="3816:763:2:1:1:::1:0:5120,3331,2997,3361,3021,1289,16714,4569,4203,4557,4171,225,5103,1287,3491,4231", -- Scimitar
	[2028]="5065:1013:2:1:1:::1:0:2997,4602,1348,1289,17412,4233,3360,5121,4203,4557,225,5103,1287,3020,3491,4231,16765", -- Hammer
	[2029]="4420:884:2:1:1:::1:0:16714,2997,5119,4203,4557,4601,225,1289,3409,1287,5103,3019,4232,4231,3491", -- Cleaver
	[2030]="5545:1109:2:1:1:::1:0:2997,4602,19238,1348,1289,17412,4233,3360,5121,4203,4557,225,3409,1287,5103,3020,3491,4231,16765", -- Gnarled Staff
	[2032]=":1665:4:2:1:::1:0:", -- Gallan Cuffs
	[2033]=":967:4:2:1:::1:0:", -- Ambassador\'s Boots
	[2034]=":1035:4:2:1:::1:0:", -- Scholarly Robes
	[2035]=":2300:2:2:1:::1:0:", -- Sword of the Night Sky
	[2036]=":258:4:2:1:::1:0:", -- Dusty Mining Gloves
	[2037]=":469:4:2:1:::1:0:", -- Tunneler\'s Boots
	[2039]=":750:4:3:1:::1:0:", -- Plains Ring
	[2040]=":15296:4:3:1:::1:0:", -- Troll Protector
	[2041]=":1412:4:3:1:::1:0:", -- Tunic of Westfall
	[2042]=":3639:2:3:1:::1:0:", -- Staff of Westfall
	[2043]=":1500:4:3:1:::1:0:", -- Ring of Forlorn Spirits
	[2044]=":8829:2:3:1:::1:0:", -- Crescent of Forlorn Spirits
	[2046]=":2461:2:2:1:::1:0:", -- Bluegill Kukri
	[2047]=":26:2:1:1:::1:0:", -- Anvilmar Hand Axe
	[2048]=":26:2:1:1:::1:0:", -- Anvilmar Hammer
	[2054]=":16:2:1:1:::1:0:", -- Trogg Hand Axe
	[2055]=":16:2:1:1:::1:0:", -- Small Wooden Hammer
	[2057]=":16:2:1:1:::1:0:", -- Pitted Defias Shortsword
	[2058]=":4197:2:2:1:::1:0:", -- Kazon\'s Maul
	[2059]=":863:4:3:1:::1:0:", -- Sentry Cloak
	[2064]=":191:2:1:1:::1:0:", -- Trogg Club
	[2065]=":113:2:1:1:::1:0:", -- Rockjaw Blade
	[2066]=":81:2:1:1:::1:0:", -- Skull Hatchet
	[2067]=":186:2:1:1:::1:0:", -- Frostbit Staff
	[2069]=":122:4:1:1:::1:0:", -- Black Bear Hide Vest
	[2070]="25:1:0:1:20:::5:0:4255,6746,4981,483,5620,2352,4894,23604,4782,23521,3546,24934,18929,6790,10367,1237,465,17630,2364,4891,295,3298,6930,9501,11106,16553,11116", -- Darnassian Bleu
	[2072]=":4414:2:2:1:::1:0:", -- Dwarven Magestaff
	[2073]=":742:2:2:1:::1:0:", -- Dwarven Hatchet
	[2074]=":1054:2:2:1:::1:0:", -- Solid Shortblade
	[2075]=":386:2:2:1:::1:0:", -- Priest\'s Mace
	[2077]=":5059:2:2:1:::1:0:", -- Magician Staff
	[2078]=":1070:2:2:1:::1:0:", -- Northern Shortsword
	[2079]=":934:2:2:1:::1:0:", -- Sergeant\'s Warhammer
	[2080]=":6590:2:2:1:::1:0:", -- Hillborne Axe
	[2082]=":250:1:1:1:::1:0:", -- Wizbang\'s Gunnysack
	[2084]=":5709:2:2:1:::1:0:", -- Darksteel Bastard Sword
	[2085]=":15:15:0:5:::1:0:", -- Chunk of Flesh
	[2087]=":252:4:2:1:::1:0:", -- Hard Crawler Carapace
	[2088]=":729:2:2:1:::1:0:", -- Long Crawler Limb
	[2089]=":1113:2:2:1:::1:0:", -- Scrimshaw Dagger
	[2091]=":213:0:1:10:::1:0:", -- Magic Dust
	[2092]=":7:2:1:1:::1:0:", -- Worn Dagger
	[2098]=":3021:2:3:1:::1:0:", -- Double-barreled Shotgun
	[2099]=":45040:2:4:1:::1:0:", -- Dwarven Hand Cannon
	[2100]=":24540:2:4:1:::1:0:", -- Precisely Calibrated Boomstick
	[2101]="4:1:11:1:1:::1:0:17667,1287,4602,16919,16715,7976", -- Light Quiver
	[2102]="4:1:11:1:1:::1:0:2685,6028", -- Small Ammo Pouch
	[2105]=":1:4:1:1:::1:0:", -- Thug Shirt
	[2108]=":8:4:1:1:::1:0:", -- Frostmane Leather Vest
	[2109]=":14:4:1:1:::1:0:", -- Frostmane Chain Vest
	[2110]=":6:4:1:1:::1:0:", -- Light Magesmith Robe
	[2112]=":54:4:1:1:::1:0:", -- Lumberjack Jerkin
	[2113]="::12:1:1:::1:0:", -- Calor\'s Note
	[2114]=":31:4:1:1:::1:0:", -- Snowy Robe
	[2117]="37:7:4:1:1:::1:0:1238,3590,190,4175,16918,836", -- Thin Cloth Shoes
	[2119]="25:5:4:1:1:::1:0:1238,3590,190,4175,16918,836", -- Thin Cloth Gloves
	[2120]="50:10:4:1:1:::1:0:1238,3590,190,4175,16918,836", -- Thin Cloth Pants
	[2121]="50:10:4:1:1:::1:0:1238,3590,190,4175,16918,836", -- Thin Cloth Armor
	[2122]="32:6:4:1:1:::1:0:1238,4236,190,3591,16918,836", -- Cracked Leather Belt
	[2123]="49:9:4:1:1:::1:0:1238,4236,190,3591,16918,836", -- Cracked Leather Boots
	[2124]="33:6:4:1:1:::1:0:1238,4236,190,3591,16918,836", -- Cracked Leather Bracers
	[2125]="33:6:4:1:1:::1:0:1238,4236,190,3591,16918,836", -- Cracked Leather Gloves
	[2126]="60:12:4:1:1:::1:0:1238,4236,190,3591,16918,836", -- Cracked Leather Pants
	[2127]="60:12:4:1:1:::1:0:1238,4236,190,3591,16918,836", -- Cracked Leather Vest
	[2129]="77:15:4:1:1:::1:0:16762,4240,3592,1104,16917,1213", -- Large Round Shield
	[2130]="54:10:2:1:1:::1:0:78,945,3159,2997,4556,5102,3588,3314,2117,3073,16919,4231", -- Club
	[2131]="54:10:2:1:1:::1:0:78,945,3159,2997,4556,5102,3588,3314,2117,3073,16919,4231", -- Shortsword
	[2132]="102:20:2:1:1:::1:0:78,945,3159,2997,4556,5102,3588,3314,2117,3073,16919,4231", -- Short Staff
	[2133]=":15:4:1:1:::1:0:", -- Small Shield
	[2134]="82:16:2:1:1:::1:0:78,945,3159,2997,4556,5102,3588,3314,2117,3073,16919,4231", -- Hand Axe
	[2136]="::0:1:20:::1:0:", -- Conjured Purified Water
	[2137]=":25:2:1:1:::1:0:", -- Whittling Knife
	[2138]=":38:2:0:1:::1:0:", -- Sharpened Letter Opener
	[2139]="57:11:2:1:1:::1:0:78,945,3159,2997,4556,5102,3588,3314,2117,3073,16919,4231", -- Dirk
	[2140]=":323:2:2:1:::1:0:", -- Carving Knife
	[2141]="5224:1044:4:1:1:::1:0:1314,3953,4236,3315,1695,3316,5820", -- Cuirboulli Vest
	[2142]="2621:524:4:1:1:::1:0:1314,3953,4236,3315,1695,3316,5820", -- Cuirboulli Belt
	[2143]="3945:789:4:1:1:::1:0:1314,3953,4236,3315,1695,3316,5820", -- Cuirboulli Boots
	[2144]="2639:527:4:1:1:::1:0:1314,3953,4236,3315,1695,3316,5820", -- Cuirboulli Bracers
	[2145]="2649:529:4:1:1:::1:0:1314,3953,4236,3315,1695,3316,5820", -- Cuirboulli Gloves
	[2146]="4809:961:4:1:1:::1:0:1314,3953,4236,3315,1695,3316,5820", -- Cuirboulli Pants
	[2148]="2908:581:4:1:1:::1:0:5819,1323,5812,4883,5125,1450,1349,4177,4886,3095,1341,4085,6028,226", -- Polished Scale Belt
	[2149]="4398:879:4:1:1:::1:0:5819,1323,5812,4883,5125,1450,1349,4177,4886,3095,1341,4085,6028,226", -- Polished Scale Boots
	[2150]="2930:586:4:1:1:::1:0:5819,1323,5812,4883,5125,1450,1349,4177,4886,3095,1341,4085,6028,226", -- Polished Scale Bracers
	[2151]="2941:588:4:1:1:::1:0:5819,1323,5812,4883,5125,1450,1349,4177,4886,3095,1341,4085,6028,226", -- Polished Scale Gloves
	[2152]="5906:1181:4:1:1:::1:0:5819,1323,5812,4883,5125,1450,1349,4177,4886,3095,1341,4085,6028,226", -- Polished Scale Leggings
	[2153]="5928:1185:4:1:1:::1:0:5819,1323,5812,4883,5125,1450,1349,4177,4886,3095,1341,4085,6028,226", -- Polished Scale Vest
	[2154]="::15:0:1:::1:0:", -- The Story of Morgan Ladimore
	[2156]="3078:615:4:1:1:::1:0:1314,3315,4188,4175,3092,3316,3952,2849,5821", -- Padded Boots
	[2158]="2066:413:4:1:1:::1:0:1314,3315,4188,4175,3092,3316,3952,2849,5821", -- Padded Gloves
	[2159]="4148:829:4:1:1:::1:0:1314,3315,4188,4175,3092,3316,3952,2849,5821", -- Padded Pants
	[2160]="4163:832:4:1:1:::1:0:1314,3315,4188,4175,3092,3316,3952,2849,5821", -- Padded Armor
	[2161]="::12:1:1:::1:0:", -- Book from Sven\'s Farm
	[2162]="::12:1:1:::1:0:", -- Sarah\'s Ring
	[2163]=":46710:2:4:1:::1:0:", -- Shadowblade
	[2164]=":27032:2:4:1:::1:0:", -- Gut Ripper
	[2165]=":45:4:1:1:::1:0:", -- Old Blanchy\'s Blanket
	[2166]=":811:4:2:1:::1:0:", -- Foreman\'s Leggings
	[2167]=":339:4:2:1:::1:0:", -- Foreman\'s Gloves
	[2168]=":469:4:2:1:::1:0:", -- Foreman\'s Boots
	[2169]=":1887:2:3:1:::1:0:", -- Buzzer Blade
	[2172]=":7:4:1:1:::1:0:", -- Rustic Belt
	[2173]=":6:4:1:1:::1:0:", -- Old Leather Belt
	[2175]=":2683:2:2:1:::1:0:", -- Shadowhide Battle Axe
	[2186]=":6:4:1:1:::1:0:", -- Outfitter Belt
	[2187]="::12:1:1:::1:0:", -- A Stack of Letters
	[2188]="::12:1:1:::1:0:", -- A Letter to Grelin Whitebeard
	[2194]=":3276:2:3:1:::1:0:", -- Diamond Hammer
	[2195]=":25:2:1:1:::1:0:", -- Anvilmar Knife
	[2203]=":1492:2:2:1:::1:0:", -- Brashclaw\'s Chopper
	[2204]=":1133:2:2:1:::1:0:", -- Brashclaw\'s Skewer
	[2205]=":3961:2:3:1:::1:0:", -- Duskbringer
	[2207]="2391:478:2:1:1:::1:0:3534,5120,3331,2997,3361,3479,3021,1289,16714,4183,3314,3658,4569,4203,4557,4171,1287,5103,4231", -- Jambiya
	[2208]="3651:730:2:1:1:::1:0:5120,3331,2997,3361,3021,1289,16714,4569,4203,4557,4171,225,5103,1287,3491,4231", -- Poniard
	[2209]="7116:1423:2:1:1:::1:0:16714,5120,1441,3331,4569,3361,4086,4203,3021,4171,3539,225,1289,1287,11137", -- Kris
	[2210]=":3:4:0:1:::1:0:", -- Battered Buckler
	[2211]=":7:4:0:1:::1:0:", -- Bent Large Shield
	[2212]=":16:4:0:1:::1:0:", -- Cracked Buckler
	[2213]=":24:4:0:1:::1:0:", -- Worn Large Shield
	[2214]=":182:4:0:1:::1:0:", -- Wooden Buckler
	[2215]=":81:4:0:1:::1:0:", -- Wooden Shield
	[2216]=":210:4:0:1:::1:0:", -- Simple Buckler
	[2217]=":243:4:0:1:::1:0:", -- Rectangular Shield
	[2218]=":501:2:2:1:::1:0:", -- Craftsman\'s Dagger
	[2219]=":457:4:0:1:::1:0:", -- Small Round Shield
	[2220]=":519:4:0:1:::1:0:", -- Box Shield
	[2221]=":910:4:0:1:::1:0:", -- Targe Shield
	[2222]=":1005:4:0:1:::1:0:", -- Tower Shield
	[2223]="::12:1:1:::1:0:", -- The Collector\'s Schedule
	[2224]=":24:2:1:1:::1:0:", -- Militia Dagger
	[2225]=":183:2:1:1:::1:0:", -- Sharp Kitchen Knife
	[2226]=":4118:2:2:1:::1:0:", -- Ogremage Staff
	[2227]=":4133:2:2:1:::1:0:", -- Heavy Ogre War Axe
	[2230]=":714:4:2:1:::1:0:", -- Gloves of Brawn
	[2231]=":4386:4:2:1:::1:0:", -- Inferno Robe
	[2232]=":813:4:2:1:::1:0:", -- Dark Runner Boots
	[2233]=":1690:4:2:1:::1:0:", -- Shadow Weaver Leggings
	[2234]=":1806:4:2:1:::1:0:", -- Nightwalker Armor
	[2235]=":1281:2:2:1:::1:0:", -- Brackclaw
	[2236]=":3386:2:3:1:::1:0:", -- Blackfang
	[2237]=":75:4:1:1:::1:0:", -- Patched Pants
	[2238]=":60:4:1:1:::1:0:", -- Urchin\'s Pants
	[2239]="::12:1:1:::1:0:", -- The Collector\'s Ring
	[2240]=":121:4:1:1:::1:0:", -- Rugged Cape
	[2241]=":408:4:2:1:::1:0:", -- Desperado Cape
	[2243]=":65783:2:4:1:::1:0:", -- Hand of Edward the Odd
	[2244]=":51858:2:4:1:::1:0:", -- Krol Blade
	[2245]=":27636:4:4:1:::1:0:", -- Helm of Narv
	[2246]=":30000:4:4:1:::1:0:", -- Myrmidon\'s Signet
	[2249]=":91:4:1:1:::1:0:", -- Militia Buckler
	[2250]="::12:1:1:::1:0:", -- Dusky Crab Cakes
	[2251]=":12:7:1:10::185:1:0:", -- Gooey Spider Leg
	[2252]="::12:1:1:::1:0:", -- Miscellaneous Goblin Supplies
	[2254]=":506:2:2:1:::1:0:", -- Icepane Warhammer
	[2256]=":2996:2:3:1:::1:0:", -- Skeletal Club
	[2257]=":189:2:1:1:::1:0:", -- Frostmane Staff
	[2258]=":83:2:1:1:::1:0:", -- Frostmane Shortsword
	[2259]=":75:2:1:1:::1:0:", -- Frostmane Club
	[2260]=":106:2:1:1:::1:0:", -- Frostmane Hand Axe
	[2262]=":8746:4:3:1:::1:0:", -- Mark of Kern
	[2263]=":2619:2:2:1:::1:0:", -- Phytoblade
	[2264]=":1957:4:3:1:::1:0:", -- Mantle of Thieves
	[2265]=":477:2:2:1:::1:0:", -- Stonesplinter Axe
	[2266]=":479:2:2:1:::1:0:", -- Stonesplinter Dagger
	[2267]=":711:2:2:1:::1:0:", -- Stonesplinter Mace
	[2268]=":146:2:1:1:::1:0:", -- Stonesplinter Blade
	[2271]=":3255:2:3:1:::1:0:", -- Staff of the Blessed Seer
	[2274]=":289:4:2:1:::1:0:", -- Sapper\'s Gloves
	[2276]=":4093:4:3:1:::1:0:", -- Swampwalker Boots
	[2277]=":3620:4:3:1:::1:0:", -- Necromancer Leggings
	[2278]=":2326:4:3:1:::1:0:", -- Forest Tracker Epaulets
	[2280]=":4828:2:3:1:::1:0:", -- Kam\'s Walking Stick
	[2281]=":300:2:2:1:::1:0:", -- Rodentia Flint Axe
	[2282]=":139:2:1:1:::1:0:", -- Rodentia Shortsword
	[2283]=":140:4:2:1:::1:0:", -- Rat Cloth Belt
	[2284]=":211:4:2:1:::1:0:", -- Rat Cloth Cloak
	[2287]="125:6:0:1:20:::5:0:3025,3705,15397,4954,7731,4875,11187,3881,3960,11118,2388,3489,23263,10367,3411,6928,5124,17630,982,4891,2814,8125,5870,16618,15174,4255,17553,12959,5620,6929,12097,5611,23481,3621,4894,5111,4782,12096,14624,9356,3933,3935,3312,24208,16443,7733,4169,23605,7485,12196,4879,17656,2365,16739,4084,1464,3368,3882,19182,3089", -- Haunch of Meat
	[2288]="::0:1:20:::1:0:", -- Conjured Fresh Water
	[2289]="350:87:0:1:5:::1:0:14847,12246", -- Scroll of Strength II
	[2290]="300:75:0:1:5:::1:0:14847,2805,12246,4878,13476,1316,4581", -- Scroll of Intellect II
	[2291]=":44580:2:4:1:::1:0:", -- Kang the Decapitator
	[2292]=":1334:4:3:1:::1:0:", -- Necrology Robes
	[2295]=":70:15:0:5:::1:0:", -- Large Boar Tusk
	[2296]=":50:7:1:10:::1:0:", -- Great Goretusk Snout
	[2299]=":8757:2:3:1:::1:0:", -- Burning War Axe
	[2300]=":192:4:2:1:::1:0:", -- Embossed Leather Vest
	[2302]=":29:4:1:1:::1:0:", -- Handstitched Leather Boots
	[2303]=":71:4:1:1:::1:0:", -- Handstitched Leather Pants
	[2304]=":15:0:1:10:::1:0:", -- Light Armor Kit
	[2307]=":243:4:1:1:::1:0:", -- Fine Leather Boots
	[2308]=":214:4:2:1:::1:0:", -- Fine Leather Cloak
	[2309]=":268:4:2:1:::1:0:", -- Embossed Leather Boots
	[2310]=":89:4:1:1:::1:0:", -- Embossed Leather Cloak
	[2311]=":150:4:1:1:::1:0:", -- White Leather Jerkin
	[2312]=":181:4:2:1::165:1:0:", -- Fine Leather Gloves
	[2313]=":200:0:1:10:::1:0:", -- Medium Armor Kit
	[2314]=":743:4:1:1:::1:0:", -- Toughened Leather Armor
	[2315]=":307:4:1:1:::1:0:", -- Dark Leather Boots
	[2316]=":326:4:1:1:::1:0:", -- Dark Leather Cloak
	[2317]=":689:4:2:1:::1:0:", -- Dark Leather Tunic
	[2318]=":15:7:1:20::164,202,165,197:1:0:", -- Light Leather
	[2319]="200:50:7:1:20::164,202,165,197:1:0:14846", -- Medium Leather
	[2320]="10:2:7:1:20::165,197:1:0:16768,26744,4589,26751,7947,24843,4225,3096,6731,18749,4775,843,12942,17490,8681,26765,5783,2670,12956,1692,11557,21085,18427,3955,25082,17486,4897,16366,2699,4189,3954,2821,16224,18772,1250,2846,3614,3168,26747,4877,2668,12022,9636,3556,19196,26753,26742,25051,19450,5128,6576,1347,15179,3485,1672,5135,12245,3499,12958,15165,16613,16767,19532,26724,16748,2819,2672,26749,19722,1286,26755,26738,16638,1148,2669,2381,777,4194,6301,16689,12028,19372,18277,16261,5163,26758,1456,4577,8363,5154,7940,18009,3958,2816,12043,960,66,26754,26752,26743,6568,25010,2225,4561,3482,2697,8934,26756,11189,4168,26759,989,1465,3779,16262,11874,12943,3081,12941,3091,26739,26741,6574,12957,18754,7854,3187,19213,7852,26748,19521,3364,18426,2810,5565,2394,8160,1474,24995,26745,4229,26757,3366,1454,5944,6567,3005,5100,2118,8145,2393,19244,18771,24935,3367,2698,26740,5817,25019", -- Coarse Thread
	[2321]="100:25:7:1:20::164,165,197:1:0:16768,26744,4589,26751,7947,24843,4225,3096,6731,18749,4775,843,12942,17490,8681,26765,5783,2670,12956,11557,21085,18427,3955,25082,17486,4897,16366,2699,4189,3954,2821,16224,18772,2846,26747,4877,2668,12022,9636,3556,19196,26753,26742,25051,19450,5128,6576,1347,15179,3485,1672,5135,12245,3499,12958,15165,16613,16767,19532,26724,16748,2819,2672,26749,19722,1286,26755,26738,16638,1148,2669,2381,777,4194,6301,16689,12028,19372,18277,5163,26758,1456,4577,8363,5154,7940,18009,3958,2816,12043,960,26754,26752,26743,6568,25010,2225,4561,3482,2697,8934,26756,11189,4168,26759,989,1465,3779,12943,11874,12941,3091,26739,26741,6574,12957,18754,7854,19213,7852,26748,19521,3364,18426,2810,5565,2394,8160,1474,24995,26745,4229,26757,3366,1454,5944,6567,3005,5100,8145,2393,19244,18771,24935,3367,2698,26740,5817,25019", -- Fine Thread
	[2324]="25:6:7:1:10::165,197:1:0:6301,26744,26751,7947,24843,12028,3096,18749,843,16261,17490,8681,4577,1456,26758,26765,5154,2670,1692,11557,7940,960,12043,66,26754,26752,18427,26743,2225,25010,6568,3482,25082,26756,8934,16366,4189,26759,4168,16224,1465,16262,18772,1250,3081,3614,3168,26747,26741,26739,3091,4877,2668,12022,6574,9636,3556,19213,3187,26753,26742,25051,26748,19521,3364,6576,18426,1347,3485,5135,1672,2394,3499,15165,1474,24995,26745,26757,16767,1454,5944,6567,26724,2672,3005,26749,19722,26755,26738,5100,2118,16638,8145,2393,2669,2381,24935,777,4194,26740,5817,25019", -- Bleach
	[2325]="1000:250:7:1:10::165,197:1:0:16768,26744,4589,26751,7947,24843,4225,3096,6731,18749,4775,12942,8681,26765,5783,2670,12956,11557,21085,3955,25082,17486,4897,16366,2699,4189,3954,2821,18772,2846,26747,2668,12022,19196,26753,26742,25051,19450,5128,6576,1347,15179,3485,1672,5135,12245,12958,15165,16613,16767,19532,26724,16748,2819,2672,26749,19722,1286,26755,26738,16638,1148,2669,6301,16689,12028,19372,18277,5163,26758,4577,8363,5154,7940,18009,3958,2816,26752,26754,6568,25010,2225,26743,4561,2697,8934,26756,11189,4168,26759,989,3779,12943,11874,12941,3091,26739,26741,6574,12957,18754,7854,19213,7852,19521,26748,3364,2810,5565,2394,8160,1474,24995,4229,26757,26745,3366,1454,5944,6567,3005,8145,19244,18771,24935,3367,26740,2698,5817,25019", -- Black Dye
	[2326]=":29:4:1:1:::1:0:", -- Ivy-weave Bracers
	[2327]=":36:4:1:1:::1:0:", -- Sturdy Leather Bracers
	[2361]=":9:2:1:1:::1:0:", -- Battleworn Hammer
	[2362]=":1:4:0:1:::1:0:", -- Worn Wooden Shield
	[2364]="296:59:4:1:1:::1:0:16186,3317,4558,3166,3522,16623", -- Woven Vest
	[2366]="298:59:4:1:1:::1:0:16186,3317,4558,3166,3522,16623", -- Woven Pants
	[2367]="224:44:4:1:1:::1:0:16186,3317,4558,3166,3522,16623", -- Woven Boots
	[2369]="150:30:4:1:1:::1:0:16186,3317,4558,3166,3522,16623", -- Woven Gloves
	[2370]="378:75:4:1:1:::1:0:16691,3166,3321,16186,3093,4558,3079,2137", -- Battered Leather Harness
	[2371]="189:37:4:1:1:::1:0:16691,3166,3321,16186,3093,4558,3079,2137", -- Battered Leather Belt
	[2372]="344:68:4:1:1:::1:0:16691,3166,3321,16186,3093,4558,3079,2137", -- Battered Leather Pants
	[2373]="259:51:4:1:1:::1:0:16691,3166,3321,16186,3093,4558,3079,2137", -- Battered Leather Boots
	[2374]="173:34:4:1:1:::1:0:16691,3166,3321,16186,3093,4558,3079,2137", -- Battered Leather Bracers
	[2375]="174:34:4:1:1:::1:0:16691,3166,3321,16186,3093,4558,3079,2137", -- Battered Leather Gloves
	[2376]="448:89:4:1:1:::1:0:16693,3080,16258,4559,2135,3167,3319", -- Worn Heater Shield
	[2377]=":89:4:1:1:::1:0:", -- Round Buckler
	[2378]="::12:1:20:::1:0:", -- Skeleton Finger
	[2379]="76:15:4:1:1:::1:0:3592,1104,4177,16917,1213", -- Tarnished Chain Vest
	[2380]="38:7:4:1:1:::1:0:3592,1104,4177,16917,1213", -- Tarnished Chain Belt
	[2381]="76:15:4:1:1:::1:0:3592,1104,4177,16917,1213", -- Tarnished Chain Leggings
	[2382]="::12:1:1:::1:0:", -- The Embalmer\'s Heart
	[2383]="58:11:4:1:1:::1:0:3592,1104,4177,16917,1213", -- Tarnished Chain Boots
	[2384]="38:7:4:1:1:::1:0:3592,1104,4177,16917,1213", -- Tarnished Chain Bracers
	[2385]="38:7:4:1:1:::1:0:3592,1104,4177,16917,1213", -- Tarnished Chain Gloves
	[2386]="78:15:4:1:1:::1:0:2116,3075,4559,3161", -- Rusted Chain Vest
	[2387]="39:7:4:1:1:::1:0:2116,3075,4559,3161", -- Rusted Chain Belt
	[2388]="78:15:4:1:1:::1:0:2116,3075,4559,3161", -- Rusted Chain Leggings
	[2389]="59:11:4:1:1:::1:0:2116,3075,4559,3161", -- Rusted Chain Boots
	[2390]="39:7:4:1:1:::1:0:2116,3075,4559,3161", -- Rusted Chain Bracers
	[2391]="39:7:4:1:1:::1:0:2116,3075,4559,3161", -- Rusted Chain Gloves
	[2392]="413:82:4:1:1:::1:0:5819,4164,17930,1249,5812,16750,2046,4177,5106,3613,1294,1240", -- Light Mail Armor
	[2393]="207:41:4:1:1:::1:0:5819,4164,17930,1249,5812,16750,2046,4177,5106,3613,1294,1240", -- Light Mail Belt
	[2394]="416:83:4:1:1:::1:0:5819,4164,17930,1249,5812,16750,2046,4177,5106,3613,1294,1240", -- Light Mail Leggings
	[2395]="323:64:4:1:1:::1:0:5819,4164,17930,1249,5812,16750,2046,4177,5106,3613,1294,1240", -- Light Mail Boots
	[2396]="215:43:4:1:1:::1:0:5819,4164,17930,1249,5812,16750,2046,4177,5106,3613,1294,1240", -- Light Mail Bracers
	[2397]="216:43:4:1:1:::1:0:5819,4164,17930,1249,5812,16750,2046,4177,5106,3613,1294,1240", -- Light Mail Gloves
	[2398]="434:86:4:1:1:::1:0:16693,4559,3167,3319,3080,16258,16625,2135", -- Light Chain Armor
	[2399]="218:43:4:1:1:::1:0:16693,4559,3167,3319,3080,16258,16625,2135", -- Light Chain Belt
	[2400]="437:87:4:1:1:::1:0:16693,4559,3167,3319,3080,16258,16625,2135", -- Light Chain Leggings
	[2401]="331:66:4:1:1:::1:0:16693,4559,3167,3319,3080,16258,16625,2135", -- Light Chain Boots
	[2402]="220:44:4:1:1:::1:0:16693,4559,3167,3319,3080,16258,16625,2135", -- Light Chain Bracers
	[2403]="221:44:4:1:1:::1:0:16693,4559,3167,3319,3080,16258,16625,2135", -- Light Chain Gloves
	[2406]=":25:9:2:1:::1:0:", -- Pattern: Fine Leather Boots
	[2407]=":162:9:2:1:::1:0:", -- Pattern: White Leather Jerkin
	[2408]=":125:9:2:1:::1:0:", -- Pattern: Fine Leather Gloves
	[2409]=":350:9:2:1:::1:0:", -- Pattern: Dark Leather Tunic
	[2411]="100000::15:3:1:::1:0:1460", -- Black Stallion Bridle
	[2414]="100000::15:3:1:::1:0:1460,384,2357,4885", -- Pinto Bridle
	[2417]="15673:3134:4:1:1:::1:0:5819,8129,1323,5812,5125,1349,1322,4177,2845,3095,1381", -- Augmented Chain Vest
	[2418]="15732:3146:4:1:1:::1:0:5819,8129,1323,5812,5125,1349,1322,4177,2845,3095,1381", -- Augmented Chain Leggings
	[2419]="7895:1579:4:1:1:::1:0:5819,8129,1323,5812,5125,1349,1322,4177,2845,3095,1381", -- Augmented Chain Belt
	[2420]="11938:2387:4:1:1:::1:0:5819,8129,1323,5812,5125,1349,1322,23571,4177,4890,2845,3095,1339,1381", -- Augmented Chain Boots
	[2421]="7952:1590:4:1:1:::1:0:5819,8129,1323,5812,5125,1349,1322,4177,2845,3095,1381", -- Augmented Chain Bracers
	[2422]="7981:1596:4:1:1:::1:0:5819,8129,1323,5812,5125,1349,1322,4177,2845,3095,1381", -- Augmented Chain Gloves
	[2423]="42770:8554:4:1:1:::1:0:5819,8129,1323,5812,5508,1349,4177,3095,980,16626,5126,11182,16753", -- Brigandine Vest
	[2424]="21461:4292:4:1:1:::1:0:5819,8129,1323,5812,5508,1349,4177,3095,980,16626,5126,11182,16753", -- Brigandine Belt
	[2425]="43077:8615:4:1:1:::1:0:5819,8129,1323,5812,5508,1349,4177,3095,980,16626,5126,11182,16753", -- Brigandine Leggings
	[2426]="32569:6513:4:1:1:::1:0:5819,8129,1323,5812,5508,1349,23571,4177,4890,3095,1339,980,16626,5126,11182,16753", -- Brigandine Boots
	[2427]="20146:4029:4:1:1:::1:0:5819,8129,1323,5812,5508,1349,4177,3095,980,16626,5126,11182,16753", -- Brigandine Bracers
	[2428]="20222:4044:4:1:1:::1:0:5819,8129,1323,5812,5508,1349,4177,3095,980,16626,5126,11182,16753", -- Brigandine Gloves
	[2429]="10139:2027:4:1:1:::1:0:1314,3315,4175,3092,3316,8159,1407,2849,1147,5155,5821,10293", -- Russet Vest
	[2431]="10215:2043:4:1:1:::1:0:1314,3315,4175,3092,3316,8159,1407,2849,1147,5155,5821,10293", -- Russet Pants
	[2432]="7691:1538:4:1:1:::1:0:1314,3315,23571,4175,3092,3316,4890,8159,1407,1339,2849,1147,5155,5821,10293", -- Russet Boots
	[2434]="5166:1033:4:1:1:::1:0:1314,3315,4175,3092,3316,8159,1407,2849,1147,5155,5821,10293", -- Russet Gloves
	[2435]="27683:5536:4:1:1:::1:0:1314,3315,11183,5129,4175,3092,984,3316,2849,5155,12023,5821,10293", -- Embroidered Armor
	[2437]="27891:5578:4:1:1:::1:0:1314,3315,11183,5129,4175,3092,984,3316,2849,5155,12023,5821,10293", -- Embroidered Pants
	[2438]="20996:4199:4:1:1:::1:0:11183,5129,4175,984,4890,2849,5821,10293,1314,3315,23571,3092,3316,1339,12023,5155", -- Embroidered Boots
	[2440]="14099:2819:4:1:1:::1:0:1314,3315,11183,5129,4175,3092,984,3316,2849,5155,12023,5821,10293", -- Embroidered Gloves
	[2445]="3433:686:4:1:1:::1:0:4240,16693,1319,3319,8360,16762,3493,5126,793", -- Large Metal Shield
	[2446]="6182:1236:4:1:1:::1:0:5819,4240,16693,1323,5812,1450,1349,1319,4886,3095,16762,6028,5126,226", -- Kite Shield
	[2447]="40:10:7:1:20::171:1:0:16224,16641,3548,1313,16705,3490", -- Peacebloom
	[2448]="16159:3231:4:1:1:::1:0:5819,4240,8129,1323,5812,5125,1349,1322,1319,4177,2845,3095,1381,5126", -- Heavy Pavise
	[2449]="80:20:7:1:20::171:1:0:16224,4878,1313,844,4083,14846,8305,1302,16641,3548,16705,3490", -- Earthroot
	[2450]=":25:7:1:20::171:1:0:", -- Briarthorn
	[2451]="43629:8725:4:1:1:::1:0:5819,4240,8129,1323,5812,5508,1349,1319,4177,3095,980,16626,5126,11182,16753", -- Crested Heater Shield
	[2452]=":15:7:1:20::171,185:1:0:", -- Swiftthistle
	[2453]="100:25:7:1:20::171:1:0:16224,4878,1313,844,4083,14846,8305,1302,16641,3548,16705,3490", -- Bruiseweed
	[2454]=":20:0:1:20:::1:0:", -- Elixir of Lion\'s Strength
	[2455]="40:10:0:1:5:::1:0:16612,958,3658,16706", -- Minor Mana Potion
	[2456]=":15:0:1:5:::1:0:", -- Minor Rejuvenation Potion
	[2457]=":15:0:1:20::165:1:0:", -- Elixir of Minor Agility
	[2458]=":15:0:1:20:::1:0:", -- Elixir of Minor Fortitude
	[2459]=":25:0:1:5::164,165:1:0:", -- Swiftness Potion
	[2463]="13695:2739:4:1:1:::1:0:1314,4236,3315,1320,5129,3316,8159,1407,1147,5820", -- Studded Doublet
	[2464]="6872:1374:4:1:1:::1:0:1314,4236,3315,1320,5129,3316,8159,1407,1147,5820", -- Studded Belt
	[2465]="12477:2495:4:1:1:::1:0:1314,4236,3315,1320,5129,3316,8159,1407,1147,5820", -- Studded Pants
	[2466]="::12:1:20:::1:0:", -- Skullsplitter Fetish
	[2467]="9430:1886:4:1:1:::1:0:1314,4236,3315,1320,23571,5129,3316,4890,8159,1407,1339,1147,5820", -- Studded Boots
	[2468]="6311:1262:4:1:1:::1:0:1314,4236,3315,1320,5129,3316,8159,1407,1147,5820", -- Studded Bracers
	[2469]="6335:1267:4:1:1:::1:0:1314,4236,3315,1320,5129,3316,8159,1407,1147,5820", -- Studded Gloves
	[2470]="33952:6790:4:1:1:::1:0:1314,4236,3315,11183,1320,5129,984,3316,12023,5820", -- Reinforced Leather Vest
	[2471]="17041:3408:4:1:1:::1:0:1314,4236,3315,11183,1320,5129,984,3316,12023,5820", -- Reinforced Leather Belt
	[2472]="34212:6842:4:1:1:::1:0:1314,4236,3315,11183,1320,5129,984,3316,12023,5820", -- Reinforced Leather Pants
	[2473]="25753:5150:4:1:1:::1:0:1314,4236,3315,11183,1320,23571,5129,984,3316,4890,1339,12023,5820", -- Reinforced Leather Boots
	[2474]="17233:3446:4:1:1:::1:0:1314,4236,3315,11183,1320,5129,984,3316,12023,5820", -- Reinforced Leather Bracers
	[2475]="17298:3459:4:1:1:::1:0:1314,4236,3315,11183,1320,5129,984,3316,12023,5820", -- Reinforced Leather Gloves
	[2476]="::12:1:20:::1:0:", -- Chilled Basilisk Haunch
	[2479]="108:21:2:1:1:::1:0:78,945,3159,2997,4556,5102,3588,3314,2117,3073,16919,4231", -- Broad Axe
	[2480]="72:14:2:1:1:::1:0:78,945,3159,2997,4556,5102,3588,3314,2117,3073,16919,4231", -- Large Club
	[2488]="536:107:2:1:1:::1:0:17930,1698,2997,4556,5102,3077,3163,54,2265,2136,10369,3314,1273,18926,16257,4231,3609", -- Gladius
	[2489]="343:68:2:1:1:::1:0:17930,1698,2997,4556,5102,3077,3163,54,2265,2136,10369,3314,1273,18926,16257,4231,3609", -- Two-handed Sword
	[2490]="540:108:2:1:1:::1:0:17930,3177,1698,2997,4556,5102,3077,3163,54,2265,2136,10369,3314,1273,18926,16257,4231,3609", -- Tomahawk
	[2491]="484:96:2:1:1:::1:0:17930,3177,1698,2997,4556,5102,3077,3163,54,2265,2136,10369,3314,1273,18926,16257,4231,3609", -- Large Axe
	[2492]="285:57:2:1:1:::1:0:17930,3177,1698,2997,4556,5102,3077,3163,54,1348,2265,2136,10369,3314,1273,18926,222,16257,4231,3609", -- Cudgel
	[2493]="701:140:2:1:1:::1:0:17930,3177,1698,2997,4556,5102,3077,3163,54,1348,2265,2136,10369,3314,1273,18926,222,16257,4231,3609", -- Wooden Mallet
	[2494]="402:80:2:1:1:::1:0:17930,1698,2997,4556,5102,3077,3163,54,2265,2136,10369,3314,1273,18926,16257,4231,3609", -- Stiletto
	[2495]="505:101:2:1:1:::1:0:17930,1698,2997,4556,5102,3077,3163,19238,54,2265,2136,10369,3314,1273,18926,3409,16257,4231,3609", -- Walking Stick
	[2504]="29:5:2:1:1:::1:0:17667,12029,16619,16274,16263,16715,1297", -- Worn Shortbow
	[2505]="60:12:2:1:1:::1:0:17667,12029,16619,16274,16263,16715,1297", -- Polished Shortbow
	[2506]="285:57:2:1:1:::1:0:17667,10369,3589,1198,1297,16619,12029,3610,16274,3165,16715,16263", -- Hornwood Recurve Bow
	[2507]="1752:350:2:1:1:::1:0:3589,9553,1198,1297,9549,1668,16619,12029,16274,1459,17667,10369,3951,4203,1687,3409,3610,3165,3488,16715,16263", -- Laminated Recurve Bow
	[2508]="27:5:2:1:1:::1:0:5510", -- Old Blunderbuss
	[2509]="414:82:2:1:1:::1:0:1469,3078,5123,2997,9551,16620,7976,1297,3322,3018,16735,5510,1243,16274,3488,4603", -- Ornate Blunderbuss
	[2510]="41:8:2:1:1:::1:0:3018,3078,5123,5510,1243,4603", -- Solid Blunderbuss
	[2511]="1324:264:2:1:1:::1:0:1469,1686,2997,9551,16620,7976,1297,3322,3018,16735,16274,3488,3088", -- Hunter\'s Boomstick
	[2512]="10::6:1:200:::200:0:1285,1198,4173,1668,829,151,2134,3951,4203,3076,5122,16191,1687,3610,9555,16715,2839,16732,3313,3186,9551,791,17421,18810,16619,12029,9548,1682,16274,16259,152,17667,4555,4082,3158,1250,18811,2115,7942,17489,12027,4241,3498,19561,16919,3589,4604,9553,3072,4602,7976,3481,1462,3410,6028,3015,15287,12960,10369,19020,1691,16920,789,8362,4182,4170,9552,4892,3409,14301,3488,491,1298,3587,16260,16444,17446,1297,228,9549,16187,2140,1459,3164,17598,3608,4084,1287,3165,1685,16263", -- Rough Arrow
	[2515]="50::6:1:200:::200:0:1285,1198,11555,4173,1668,3951,4203,5122,12246,16191,1687,3610,227,9555,2803,16715,2839,16732,3313,12959,9551,791,17421,734,18810,12021,12029,16619,9548,8139,1682,16274,17667,4555,2401,2084,4082,18811,1448,7942,17489,12027,4241,3498,19561,16919,2808,3589,4604,15397,3962,9553,4602,11038,7976,3481,3625,1462,3410,6028,3015,12960,2806,2908,10369,19020,789,8362,4182,5101,4170,1149,3541,9552,4892,3409,1452,14301,3488,491,1298,15174,3350,1297,16444,228,9549,4896,16187,14624,2140,1459,17598,4876,5134,2820,4084,1287,1685,3165,16263", -- Sharp Arrow
	[2516]="10::6:1:200:::200:0:1285,3053,829,11184,1469,151,2134,3076,16191,5510,3088,16732,3313,3186,1461,9551,2997,791,17421,18810,2685,9548,1682,16274,16259,152,4555,5123,1686,4082,3158,1250,18811,2115,7942,17489,12027,3018,4241,3498,4889,4603,3072,7976,3481,6028,12960,3078,1691,8362,4182,4170,3488,3587,491,16260,16620,16444,3322,17446,1297,16735,16187,2140,3164,8131,3608,4084,1685,1243", -- Light Shot
	[2519]="50::6:1:200:::200:0:1285,11555,3053,11184,1469,12246,16191,227,5510,2803,3088,16732,3313,12959,1461,9551,2997,791,17421,734,18810,12021,2685,9548,8139,1682,16274,4555,2401,2084,5123,1686,4082,18811,1448,7942,17489,12027,3018,4241,3498,4889,4603,2808,15397,3962,11038,7976,3481,3625,6028,12960,2806,3078,2908,8362,4182,5101,4170,1149,3541,1452,3488,491,15174,3350,16620,16444,3322,1297,4896,16735,16187,14624,2140,4876,8131,5134,2820,4084,1685,1243", -- Heavy Shot
	[2520]="24629:4925:2:1:1:::1:0:5120,21474,1324,3331,3361,3021,4884,1146,4600,11137,2843,4888,19240,16714,15315,2482,21086,16678,4171,5170,3000,19047,1645", -- Broadsword
	[2521]="30896:6179:2:1:1:::1:0:1333,5120,21474,4884,1146,4600,11137,2843,4888,19240,15315,4180,2482,21086,16678,5170,3000,4043,19047,8398,1645", -- Flamberge
	[2522]="22548:4509:2:1:1:::1:0:12045,4884,19479,1146,2483,11137,3019,4888,15315,10379,2482,23571,16666,5509,21086,5119,3000,4232,1645", -- Crescent Axe
	[2523]="28286:5657:2:1:1:::1:0:1333,12045,4884,19479,1146,2483,4600,11137,3019,4888,15315,10379,4180,2482,23571,16666,5509,5119,21086,3000,4043,8398,4232,1645", -- Bullova
	[2524]="19192:3838:2:1:1:::1:0:4884,1471,1146,16637,11137,4888,10379,8878,2482,5121,21086,3000,19370,5152,16765,1645", -- Truncheon
	[2525]="26490:5298:2:1:1:::1:0:1333,4884,1471,1146,16637,4600,11137,4888,10379,4180,8878,2482,5121,21086,3000,4043,19370,8398,5152,16765,1645", -- War Hammer
	[2526]="19336:3867:2:1:1:::1:0:19239,5120,21474,1324,3331,3361,3021,4884,1146,4600,11137,2843,4888,19240,16714,15315,2482,21086,16678,4171,5170,3000,19047,1645", -- Main Gauche
	[2527]="29356:5871:2:1:1:::1:0:3349,19238,4884,1471,1146,19043,16637,11137,4888,10379,8878,2482,5121,3022,3330,21086,4570,1315,3000,19370,4234,5152,1645,16765", -- Battle Staff
	[2528]="51836:10367:2:1:1:::1:0:5120,21474,981,1324,3331,3361,3021,1296,11184,4600,2843,19240,16714,15315,16388,12024,16678,1407,4171,5170,3000,19047,10361", -- Falchion
	[2529]="65032:13006:2:1:1:::1:0:1333,5120,21474,981,1296,11184,4600,2843,19240,15315,4180,16388,12024,16678,1407,5170,4043,3000,19047,8398,10361", -- Zweihander
	[2530]="52220:10444:2:1:1:::1:0:981,12045,1296,19479,11184,2483,3019,15315,10379,23571,16388,16666,12024,5509,5119,1407,3000,4232,10361", -- Francisca
	[2531]="56170:11234:2:1:1:::1:0:1333,981,12045,1296,19479,11184,2483,4600,3019,15315,10379,4180,23571,16388,16666,5509,12024,5119,1407,3000,4043,4232,8398,10361", -- Great Axe
	[2532]="52608:10521:2:1:1:::1:0:981,1296,1471,11184,16637,10379,8878,16388,12024,5121,21086,1407,3000,19370,5152,16765,10361", -- Morning Star
	[2533]="61108:12221:2:1:1:::1:0:1333,981,1296,1471,11184,16637,4600,10379,4180,8878,16388,12024,5121,21086,1407,3000,4043,19370,8398,5152,16765,10361", -- War Maul
	[2534]="45431:9086:2:1:1:::1:0:19239,5120,21474,981,1324,3331,3361,3021,1296,11184,4600,2843,19240,16714,15315,16388,12024,16678,1407,4171,5170,3000,19047,10361", -- Rondel
	[2535]="61557:12311:2:1:1:::1:0:981,3349,19238,1296,1471,19043,11184,16637,10379,8878,16388,12024,5121,3022,3330,21086,1407,4570,1315,3000,19370,4234,5152,16765,10361", -- War Staff
	[2536]="::12:1:20:::1:0:", -- Trogg Stone Tooth
	[2545]=":1797:4:2:1:::1:0:", -- Malleable Chain Leggings
	[2546]=":55:4:1:1:::1:0:", -- Royal Frostmane Girdle
	[2547]=":7:4:1:1:::1:0:", -- Boar Handler Gloves
	[2548]="::12:1:1:::1:0:", -- Barrel of Barleybrew Scalder
	[2549]=":5016:2:3:1:::1:0:", -- Staff of the Shade
	[2553]=":25:9:2:1:::1:0:", -- Recipe: Elixir of Minor Agility
	[2555]=":40:9:2:1:::1:0:", -- Recipe: Swiftness Potion
	[2560]="::12:1:1:::1:0:", -- Jitters\' Completed Journal
	[2561]="::12:1:1:::1:0:", -- Chok\'sul\'s Head
	[2562]=":575:4:1:1:::1:0:", -- Bouquet of Scarlet Begonias
	[2563]="::12:1:1:::1:0:", -- Strange Smelling Powder
	[2564]=":6817:4:3:1:::1:0:", -- Elven Spirit Claws
	[2565]=":3113:4:3:1:::1:0:", -- Rod of Molten Fire
	[2566]=":1322:4:2:1:::1:0:", -- Sacrificial Robes
	[2567]=":2509:2:3:1:::1:0:", -- Evocator\'s Blade
	[2568]=":31:4:1:1:::1:0:", -- Brown Linen Vest
	[2569]=":87:4:1:1:::1:0:", -- Linen Boots
	[2570]=":11:4:1:1:::1:0:", -- Linen Cloak
	[2571]=":17:4:1:1:::1:0:", -- Viny Wrappings
	[2572]=":99:4:2:1:::1:0:", -- Red Linen Robe
	[2575]=":25:4:1:1:::1:0:", -- Red Linen Shirt
	[2576]=":75:4:1:1:::1:0:", -- White Linen Shirt
	[2577]=":75:4:1:1:::1:0:", -- Blue Linen Shirt
	[2578]=":224:4:2:1:::1:0:", -- Barbaric Linen Vest
	[2579]=":37:4:1:1:::1:0:", -- Green Linen Shirt
	[2580]=":67:4:1:1:::1:0:", -- Reinforced Linen Cape
	[2581]=":20:0:1:20:::1:0:", -- Heavy Linen Bandage
	[2582]=":216:4:1:1:::1:0:", -- Green Woolen Vest
	[2583]=":359:4:2:1:::1:0:", -- Woolen Boots
	[2584]=":142:4:1:1:::1:0:", -- Woolen Cape
	[2585]=":638:4:2:1:::1:0:", -- Gray Woolen Robe
	[2587]=":200:4:1:1:::1:0:", -- Gray Woolen Shirt
	[2589]="55:13:7:1:20::164,202,129,197:1:0:16631", -- Linen Cloth
	[2590]=":5:15:0:5:::1:0:", -- Forest Spider Webbing
	[2591]=":5:15:0:5:::1:0:", -- Dirty Trogg Cloth
	[2592]="135:33:7:1:20::164,202,129,197:1:0:16631", -- Wool Cloth
	[2593]="150:37:0:1:20::185:1:0:2832,18954,955,17553,16442,5848,1305,5611,1697,277,1328,5570,5111,5140,1301,1311,19245,19186,19617,5112,465,258,23525,23606,18542", -- Flask of Port
	[2594]="1500:375:0:1:20::185:1:0:2832,18954,955,17553,16442,5848,1305,5611,1697,277,1328,5570,5111,5140,1301,1311,19245,19186,19617,5112,465,258,23525,23606,20377,1464,18542", -- Flagon of Mead
	[2595]="2000:500:0:1:20:::1:0:2832,18954,955,17553,16442,5848,1305,5611,1697,277,1328,5570,5111,5140,1301,1311,19245,19186,19617,5112,465,258,23525,23606,18542", -- Jug of Bourbon
	[2596]="120:30:0:1:20::185:1:0:2832,18954,955,17553,16442,5848,1305,5611,1697,277,1328,5570,5111,5140,1301,1311,19245,19186,19617,5112,465,258,23525,23606,18542", -- Skin of Dwarven Stout
	[2598]=":30:9:2:1:::1:0:", -- Pattern: Red Linen Robe
	[2601]=":100:9:2:1:::1:0:", -- Pattern: Gray Woolen Robe
	[2604]="50:12:7:1:10::202,165,197:1:0:16768,26744,4589,26751,7947,24843,4225,3096,6731,18749,4775,843,12942,17490,8681,26765,5783,2670,12956,1692,11557,21085,18427,3955,25082,17486,4897,16366,2699,4189,3954,2821,16224,18772,1250,2846,3614,3168,26747,2668,12022,19196,26753,26742,25051,19450,5128,6576,1347,15179,3485,1672,5135,12245,12958,15165,16613,16767,19532,26724,16748,2819,2672,26749,19722,1286,26755,26738,16638,1148,2669,4194,6301,16689,12028,19372,18277,16261,5163,26758,4577,8363,5154,7940,18009,3958,2816,66,26754,26752,26743,6568,25010,2225,4561,3482,2697,8934,26756,11189,4168,26759,989,1465,3779,16262,12943,11874,3081,12941,3091,26739,26741,6574,12957,18754,7854,3187,19213,7852,26748,19521,3364,18426,2810,5565,2394,8160,1474,24995,26745,4229,26757,3366,1454,5944,6567,3005,2118,8145,19244,18771,24935,3367,2698,26740,5817,25019", -- Red Dye
	[2605]="100:25:7:1:10::164,202,165,197:1:0:6301,4589,16689,4225,3096,6731,18749,843,12942,18277,17490,8681,4577,5783,5154,2670,12956,11557,7940,3958,2816,21085,18427,2225,6568,3482,2697,8934,16366,2699,4189,4168,16224,1465,18772,2846,11874,12943,3091,6574,2668,18754,19196,19213,7854,7852,19521,3364,5128,6576,18426,1347,3485,5135,1672,5565,2394,8160,15165,1474,16767,3366,19532,1454,5944,6567,16748,2819,2672,3005,19722,16638,2669,18771,4194,2698,5817", -- Green Dye
	[2606]="::12:1:1:::1:0:", -- Lurker Venom
	[2607]="::12:1:1:::1:0:", -- Mo\'grosh Crystal
	[2608]=":63:15:0:5:::1:0:", -- Threshadon Ambergris
	[2609]="::12:1:1:::1:0:", -- Disarming Colloid
	[2610]="::12:1:1:::1:0:", -- Disarming Mixture
	[2611]="::12:1:20:::1:0:", -- Crude Flint
	[2612]="163:32:4:1:1:::1:0:5156,1350,4580,3315,4172,1309,3092", -- Plain Robe
	[2613]="608:121:4:1:1:::1:0:5156,1350,4580,3315,4172,1309,3092", -- Double-stitched Robes
	[2614]="1162:232:4:1:1:::1:0:5156,1350,4580,3315,4172,1309,3092", -- Robe of Apprenticeship
	[2615]="5092:1018:4:1:1:::1:0:5156,1350,4580,3315,4172,1309,3092", -- Chromatic Robe
	[2616]="2660:532:4:1:1:::1:0:5156,1350,4580,3315,4172,1309,3092", -- Shimmering Silk Robes
	[2617]="10992:2198:4:1:1:::1:0:5156,1350,4580,3315,4172,1309,3092", -- Burning Robes
	[2618]="26640:5328:4:1:1:::1:0:5156,1350,4580,3315,4172,1309,3092", -- Silver Dress Robes
	[2619]="::12:1:1:::1:0:", -- Grelin\'s Report
	[2620]=":3013:4:2:1:::1:0:", -- Augural Shroud
	[2621]=":2357:4:2:1:::1:0:", -- Cowl of Necromancy
	[2622]=":2603:4:2:1:::1:0:", -- Nimar\'s Tribal Headdress
	[2623]=":3554:4:2:1:::1:0:", -- Holy Diadem
	[2624]=":3852:4:2:1:::1:0:", -- Thinking Cap
	[2625]="::12:1:1:::1:0:", -- Menethil Statuette
	[2628]="::12:1:1:::1:0:", -- Senir\'s Report
	[2629]="::13:1:1:::1:0:", -- Intrepid Strongbox Key
	[2632]=":605:2:2:1:::1:0:", -- Curved Dagger
	[2633]=":25:0:1:10:::1:0:", -- Jungle Remedy
	[2634]="::12:1:1:::1:0:", -- Venom Fern Extract
	[2635]=":16:4:0:1:::1:0:", -- Loose Chain Belt
	[2636]="::12:1:20:::1:0:", -- Carved Stone Idol
	[2637]="::12:1:1:::1:0:", -- Ironband\'s Progress Report
	[2639]="::12:1:1:::1:0:", -- Merrin\'s Letter
	[2640]="::12:1:20:::1:0:", -- Miners\' Gear
	[2642]=":33:4:0:1:::1:0:", -- Loose Chain Boots
	[2643]=":28:4:0:1:::1:0:", -- Loose Chain Bracers
	[2644]=":7:4:0:1:::1:0:", -- Loose Chain Cloak
	[2645]=":11:4:0:1:::1:0:", -- Loose Chain Gloves
	[2646]=":32:4:0:1:::1:0:", -- Loose Chain Pants
	[2648]=":58:4:0:1:::1:0:", -- Loose Chain Vest
	[2649]=":1:4:0:1:::1:0:", -- Flimsy Chain Belt
	[2650]=":3:4:0:1:::1:0:", -- Flimsy Chain Boots
	[2651]=":3:4:0:1:::1:0:", -- Flimsy Chain Bracers
	[2652]=":4:4:0:1:::1:0:", -- Flimsy Chain Cloak
	[2653]=":3:4:0:1:::1:0:", -- Flimsy Chain Gloves
	[2654]=":2:4:0:1:::1:0:", -- Flimsy Chain Pants
	[2656]=":9:4:0:1:::1:0:", -- Flimsy Chain Vest
	[2657]=":875:1:1:1:::1:0:", -- Red Leather Bag
	[2658]="::12:1:1:::1:0:", -- Ados Fragment
	[2659]="::12:1:1:::1:0:", -- Modr Fragment
	[2660]="::12:1:1:::1:0:", -- Golm Fragment
	[2661]="::12:1:1:::1:0:", -- Neru Fragment
	[2662]=":8750:11:2:1:::1:0:", -- Ribbly\'s Quiver
	[2663]=":8750:11:2:1:::1:0:", -- Ribbly\'s Bandolier
	[2665]="20:5:7:1:20::185:1:0:1303", -- Stormwind Seasoning Herbs
	[2666]="::12:1:1:::1:0:", -- Barrel of Thunder Ale
	[2667]="::12:1:1:::1:0:", -- MacGrann\'s Dried Meats
	[2671]="::12:1:20:::1:0:", -- Wendigo Mane
	[2672]=":4:7:1:10::185:1:0:", -- Stringy Wolf Meat
	[2673]=":10:7:1:10::185:1:0:", -- Coyote Meat
	[2674]=":12:7:1:10::185:1:0:", -- Crawler Meat
	[2675]=":11:7:1:10::185:1:0:", -- Crawler Claw
	[2676]="::12:1:20:::1:0:", -- Shimmerweed
	[2677]=":15:7:1:10::185:1:0:", -- Boar Ribs
	[2678]="10::7:1:20::185:5:0:8307,16768,6301,26744,3027,26751,7947,24843,19372,12028,20028,18987,4775,843,5163,24993,16261,17490,1456,26758,26765,8363,4223,2397,20096,1692,18009,960,12043,66,26754,26752,18993,18427,3955,26743,2225,25010,4553,4561,25012,17246,3482,19371,25082,26756,8934,17486,4897,11189,25020,26759,2664,3954,989,2821,16224,1465,3085,16262,3779,16253,20097,1250,14738,3081,3614,12941,3168,26747,26741,26739,4877,12022,25089,12957,9636,5483,3556,19195,3187,12033,26753,26742,5160,25051,26748,19450,4265,2810,15179,18426,5135,12245,3400,3499,12958,24995,16613,26745,26757,4229,16718,26724,26749,1286,26755,26738,5100,2118,16677,1148,8145,2393,19244,2381,777,24935,4194,3367,26740,24834,5817,25052,25019", -- Mild Spices
	[2679]=":5:0:1:20:::1:0:", -- Charred Wolf Meat
	[2680]=":10:0:1:20:::1:0:", -- Spiced Wolf Meat
	[2681]=":6:0:1:20:::1:0:", -- Roasted Boar Meat
	[2682]=":25:0:1:20:::1:0:", -- Cooked Crab Claw
	[2683]=":25:0:1:20:::1:0:", -- Crab Cake
	[2684]=":20:0:1:20:::1:0:", -- Coyote Steak
	[2685]=":75:0:1:20:::1:0:", -- Succulent Pork Ribs
	[2686]="50:12:0:1:10:::1:0:7744,1247,1682", -- Thunder Ale
	[2687]=":25:0:1:20:::1:0:", -- Dry Pork Ribs
	[2690]=":7:4:1:1:::1:0:", -- Latched Belt
	[2691]=":10:4:1:1:::1:0:", -- Outfitter Boots
	[2692]="40:10:7:1:20::185:1:0:8307,16768,6301,26744,3027,26751,7947,24843,19372,12028,20028,18987,4775,843,5163,24993,17490,1456,26758,26765,8363,4223,2397,20096,18009,960,12043,26754,26752,18993,18427,3955,26743,2225,25010,4553,4561,25012,17246,3482,19371,25082,26756,8934,17486,4897,11189,25020,26759,2664,3954,989,2821,16224,1465,3085,3779,16253,20097,14738,12941,26747,26741,26739,4877,12022,25089,12957,9636,5483,3556,19195,12033,26753,26742,5160,25051,26748,19450,4265,2810,15179,18426,5135,12245,3400,3499,12958,24995,16613,26745,26757,4229,16718,26724,26749,1286,26755,26738,5100,16677,8145,1148,2393,19244,2381,777,24935,4194,3367,26740,24834,5817,25052,25019", -- Hot Spices
	[2694]=":539:4:2:1:::1:0:", -- Settler\'s Leggings
	[2696]="::12:1:1:::1:0:", -- Cask of Evershine
	[2697]="400:100:9:1:1:::1:0:340", -- Recipe: Goretusk Liver Pie
	[2698]="400:100:9:1:1:::1:0:340", -- Recipe: Cooked Crab Claw
	[2699]="800:200:9:1:1:::1:0:340", -- Recipe: Redridge Goulash
	[2700]="400:100:9:1:1:::1:0:340", -- Recipe: Succulent Pork Ribs
	[2701]="1600:400:9:1:1:::1:0:340", -- Recipe: Seasoned Wolf Kabob
	[2702]="::12:1:20:::1:0:", -- Lightforge Ingot
	[2712]="::12:1:1:::1:0:", -- Crate of Lightforge Ingots
	[2713]="::12:1:1:::1:0:", -- Ol\' Sooty\'s Head
	[2719]="::13:1:1:::1:0:", -- Small Brass Key
	[2720]="::12:1:1:::1:0:", -- Muddy Note
	[2721]=":1982:4:3:1:::1:0:", -- Holy Shroud
	[2722]="::12:1:1:::1:0:", -- Wine Ticket
	[2723]="50:12:0:1:20:::1:0:2832,18954,955,17553,16442,5848,1305,5611,1697,277,1328,5570,5111,5140,1301,1311,19245,19186,19617,5112,465,258,23525,23606,18542", -- Bottle of Pinot Noir
	[2724]="::12:1:1:::1:0:", -- Cloth Request
	[2725]=":375:12:1:10:::1:0:", -- Green Hills of Stranglethorn - Page 1
	[2728]=":375:12:1:10:::1:0:", -- Green Hills of Stranglethorn - Page 4
	[2730]=":375:12:1:10:::1:0:", -- Green Hills of Stranglethorn - Page 6
	[2732]=":375:12:1:10:::1:0:", -- Green Hills of Stranglethorn - Page 8
	[2734]=":375:12:1:10:::1:0:", -- Green Hills of Stranglethorn - Page 10
	[2735]=":375:12:1:10:::1:0:", -- Green Hills of Stranglethorn - Page 11
	[2738]=":375:12:1:10:::1:0:", -- Green Hills of Stranglethorn - Page 14
	[2740]=":375:12:1:10:::1:0:", -- Green Hills of Stranglethorn - Page 16
	[2742]=":375:12:1:10:::1:0:", -- Green Hills of Stranglethorn - Page 18
	[2744]=":375:12:1:10:::1:0:", -- Green Hills of Stranglethorn - Page 20
	[2745]=":375:12:1:10:::1:0:", -- Green Hills of Stranglethorn - Page 21
	[2748]=":375:12:1:10:::1:0:", -- Green Hills of Stranglethorn - Page 24
	[2749]=":375:12:1:10:::1:0:", -- Green Hills of Stranglethorn - Page 25
	[2750]=":375:12:1:10:::1:0:", -- Green Hills of Stranglethorn - Page 26
	[2751]=":375:12:1:10:::1:0:", -- Green Hills of Stranglethorn - Page 27
	[2754]=":13:2:1:1:::1:0:", -- Tarnished Bastard Sword
	[2756]="::12:1:1:::1:0:", -- Green Hills of Stranglethorn - Chapter I
	[2757]="::12:1:1:::1:0:", -- Green Hills of Stranglethorn - Chapter II
	[2758]="::12:1:1:::1:0:", -- Green Hills of Stranglethorn - Chapter III
	[2759]="::12:1:1:::1:0:", -- Green Hills of Stranglethorn - Chapter IV
	[2760]="::12:1:1:::1:0:", -- Thurman\'s Sewing Kit
	[2763]=":240:2:0:1:::1:0:", -- Fisherman Knife
	[2764]=":440:2:0:1:::1:0:", -- Small Dagger
	[2765]=":811:2:0:1:::1:0:", -- Hunting Knife
	[2766]=":1564:2:0:1:::1:0:", -- Deft Stiletto
	[2770]="20:5:7:1:20::186:1:0:16224", -- Copper Ore
	[2771]="100:25:7:1:20::186:1:0:16224", -- Tin Ore
	[2772]=":150:7:1:20::333,186:1:0:", -- Iron Ore
	[2773]=":39:2:0:1:::1:0:", -- Cracked Shortbow
	[2774]=":28:2:0:1:::1:0:", -- Rust-covered Blunderbuss
	[2775]="300:75:7:2:20::186:1:0:16224", -- Silver Ore
	[2776]=":500:7:2:20::186:1:0:", -- Gold Ore
	[2777]=":147:2:0:1:::1:0:", -- Feeble Shortbow
	[2778]=":147:2:0:1:::1:0:", -- Cheap Blunderbuss
	[2779]="::12:1:1:::1:0:", -- Tear of Tilloa
	[2780]=":374:2:0:1:::1:0:", -- Light Hunting Bow
	[2781]=":335:2:0:1:::1:0:", -- Dirty Blunderbuss
	[2782]=":751:2:0:1:::1:0:", -- Mishandled Recurve Bow
	[2783]=":590:2:0:1:::1:0:", -- Shoddy Blunderbuss
	[2784]="::12:1:1:::1:0:", -- Musquash Root
	[2785]=":1062:2:0:1:::1:0:", -- Stiff Recurve Bow
	[2786]=":1173:2:0:1:::1:0:", -- Oiled Blunderbuss
	[2787]=":10:2:1:1:::1:0:", -- Trogg Dagger
	[2788]="::12:1:1:::1:0:", -- Black Claw Stout
	[2794]="::12:1:1:::1:0:", -- An Old History Book
	[2795]="::12:1:1:::1:0:", -- Book: Stresses of Iron
	[2797]="::12:1:1:::1:0:", -- Heart of Mokk
	[2798]=":25:12:1:20:::1:0:", -- Rethban Ore
	[2799]=":67:12:1:20:::1:0:", -- Gorilla Fang
	[2800]=":1525:4:3:1:::1:0:", -- Black Velvet Robes
	[2801]=":90978:2:4:1:::1:0:", -- Blade of Hanna
	[2802]=":1625:4:3:1:::1:0:", -- Blazing Emblem
	[2805]=":1882:4:2:1:::1:0:", -- Yeti Fur Cloak
	[2806]="::12:1:1:::1:0:", -- Package for Stormpike
	[2807]=":2452:2:3:1:::1:0:", -- Guillotine Axe
	[2815]=":19778:2:3:1:::1:0:", -- Curve-bladed Ripper
	[2816]=":7324:2:3:1:::1:0:", -- Death Speaker Scepter
	[2817]=":201:4:2:1:::1:0:", -- Soft Leather Tunic
	[2818]=":363:4:2:1:::1:0:", -- Stretched Leather Trousers
	[2819]=":3830:2:2:1:::1:0:", -- Cross Dagger
	[2820]=":4662:4:2:1:::1:0:", -- Nifty Stopwatch
	[2821]=":1118:2:2:1:::1:0:", -- Mo\'grosh Masher
	[2822]=":1402:2:2:1:::1:0:", -- Mo\'grosh Toothpick
	[2823]=":1618:2:2:1:::1:0:", -- Mo\'grosh Can Opener
	[2824]=":32032:2:4:1:::1:0:", -- Hurricane
	[2825]=":14722:2:4:1:::1:0:", -- Bow of Searing Arrows
	[2828]="::12:1:1:::1:0:", -- Nissa\'s Remains
	[2829]="::12:1:1:::1:0:", -- Gregor\'s Remains
	[2830]="::12:1:1:::1:0:", -- Thurman\'s Remains
	[2831]="::12:1:1:::1:0:", -- Devlin\'s Remains
	[2832]="::12:1:1:::1:0:", -- Verna\'s Westfall Stew Recipe
	[2833]="::12:1:1:::1:0:", -- The Lich\'s Spellbook
	[2834]="::12:1:20:::1:0:", -- Embalming Ichor
	[2835]=":2:7:1:20::164,202,755:1:0:", -- Rough Stone
	[2836]=":15:7:1:20::164,202,755:1:0:", -- Coarse Stone
	[2837]="::12:1:1:::1:0:", -- Thurman\'s Letter
	[2838]=":60:7:1:20::164,202,755:1:0:", -- Heavy Stone
	[2839]="::12:1:1:::1:0:", -- A Letter to Yvette
	[2840]=":10:7:1:20::164,202,755,165,186:1:0:", -- Copper Bar
	[2841]=":50:7:1:20::164,202,755:1:0:", -- Bronze Bar
	[2842]=":100:7:2:20::164,202,755:1:0:", -- Silver Bar
	[2843]="::12:1:20:::1:0:", -- Dirty Knucklebones
	[2844]=":106:2:1:1:::1:0:", -- Copper Mace
	[2845]=":109:2:1:1:::1:0:", -- Copper Axe
	[2846]="::12:1:20:::1:0:", -- Tirisfal Pumpkin
	[2847]=":110:2:1:1:::1:0:", -- Copper Shortsword
	[2848]=":1119:2:1:1:::1:0:", -- Bronze Mace
	[2849]=":1269:2:1:1:::1:0:", -- Bronze Axe
	[2850]=":1439:2:1:1:::1:0:", -- Bronze Shortsword
	[2851]=":56:4:1:1:::1:0:", -- Copper Chain Belt
	[2852]=":67:4:1:1:::1:0:", -- Copper Chain Pants
	[2853]=":17:4:1:1:::1:0:", -- Copper Bracers
	[2854]=":225:4:1:1:::1:0:", -- Runed Copper Bracers
	[2855]="::12:1:20:::1:0:", -- Putrid Claw
	[2856]="::12:1:20:::1:0:", -- Iron Pike
	[2857]=":198:4:1:1:::1:0:", -- Runed Copper Belt
	[2858]="::12:1:20:::1:0:", -- Darkhound Blood
	[2859]="::12:1:20:::1:0:", -- Vile Fin Scale
	[2862]=":3:0:1:20:::1:0:", -- Rough Sharpening Stone
	[2863]=":10:0:1:20:::1:0:", -- Coarse Sharpening Stone
	[2864]=":630:4:2:1:::1:0:", -- Runed Copper Breastplate
	[2865]=":962:4:2:1:::1:0:", -- Rough Bronze Leggings
	[2866]=":753:4:1:1:::1:0:", -- Rough Bronze Cuirass
	[2868]=":807:4:2:1:::1:0:", -- Patterned Bronze Bracers
	[2869]=":1831:4:2:1:::1:0:", -- Silvered Bronze Breastplate
	[2870]=":2935:4:3:1:::1:0:", -- Shining Silver Breastplate
	[2871]=":40:0:1:20:::1:0:", -- Heavy Sharpening Stone
	[2872]="::12:1:20:::1:0:", -- Vicious Night Web Spider Venom
	[2874]="::12:1:1:::1:0:", -- An Unsent Letter
	[2875]="::12:1:20:::1:0:", -- Scarlet Insignia Ring
	[2876]="::12:1:20:::1:0:", -- Duskbat Pelt
	[2877]=":8524:2:3:1:::1:0:", -- Combatant Claymore
	[2878]=":5143:2:3:1:::1:0:", -- Bearded Boneaxe
	[2879]=":3121:4:3:1:::1:0:", -- Antipodean Rod
	[2880]="100:25:7:1:10::164,202:1:0:16768,26744,8161,26751,7947,5512,24843,4775,843,17490,26765,25634,16823,1692,9544,22476,6777,18427,3955,19056,14637,22264,19879,3133,3343,16751,16657,17421,25082,17486,4897,3954,5175,27711,2821,16224,4587,20082,2682,17245,17655,1250,1448,3614,3168,26747,4877,2847,12022,4599,9636,2999,3556,19012,26753,26742,9676,25051,17222,19450,15179,20981,4256,5135,12245,19342,19011,3499,12958,19520,16613,23144,2684,2844,15176,5514,26724,26749,5519,4259,14624,16782,1286,26755,26738,1148,19383,790,15400,2687,2381,777,16376,23724,8679,3002,8678,2688,4194,6301,12028,19372,11186,18484,16261,5163,19530,1456,26758,8363,16664,18009,960,12043,18775,66,26754,26752,18752,26743,25010,2225,4561,4597,3482,8934,26756,2685,6300,18278,11189,26759,20463,16583,989,11185,14737,20890,1465,6730,3495,3779,16262,3413,3081,16670,12941,16713,26741,26739,21209,12957,8176,3187,19662,26748,1694,18426,2810,1690,3167,4257,6298,24995,26745,26757,4229,28344,9179,372,3358,3356,5411,4453,5100,2118,2683,8145,2393,19244,3477,24935,3367,26740,3578,5817,25019", -- Weak Flux
	[2881]=":150:9:2:1:::1:0:", -- Plans: Runed Copper Breastplate
	[2882]=":300:9:2:1:::1:0:", -- Plans: Silvered Bronze Shoulders
	[2883]=":375:9:2:1:::1:0:", -- Plans: Deadly Bronze Poniard
	[2885]="::12:1:1:::1:0:", -- Scarlet Crusade Documents
	[2886]=":5:7:1:10::185:1:0:", -- Crag Boar Rib
	[2888]=":10:0:1:20:::1:0:", -- Beer Basted Boar Ribs
	[2889]="240:60:9:1:1:::1:0:340", -- Recipe: Beer Basted Boar Ribs
	[2892]=":30:0:1:20:::1:0:", -- Deadly Poison
	[2893]=":55:0:1:20:::1:0:", -- Deadly Poison II
	[2894]="50:12:0:1:10::185:1:0:7744,1247,1682", -- Rhapsody Malt
	[2898]=":32:4:1:1:::1:0:", -- Mountaineer Chestpiece
	[2899]=":169:4:2:1:::1:0:", -- Wendigo Collar
	[2900]=":89:4:1:1:::1:0:", -- Stone Buckler
	[2901]="81:16:2:1:1:::1:0:16768,26744,8161,26751,7947,5512,24843,4775,843,17490,26765,25634,16823,1692,9544,22476,6777,18427,3955,19056,14637,22264,19879,3133,3343,16751,16657,21112,17421,25082,17486,4897,3954,5175,27711,2821,16224,4587,20082,2682,17245,17655,1250,1448,3614,3168,26747,4877,2847,12022,4599,9636,2999,3556,19012,26753,26742,9676,25051,17222,19450,15179,20981,4256,5135,12245,19342,19011,3499,12958,19520,16613,19661,23144,2684,2844,15176,5514,26724,26749,5519,4259,14624,16782,1286,26755,26738,1148,19383,790,15400,2687,2381,777,16376,23724,8679,3002,8678,2688,4194,6301,12028,19372,11186,18484,16261,5163,19530,1456,26758,8363,16664,18009,960,12043,18775,66,26754,26752,18752,26743,25010,2225,4561,4597,3482,8934,26756,2685,6300,18278,11189,26759,20463,16583,989,11185,14737,20890,1465,6730,3495,3779,16262,3413,3081,16670,12941,16713,26741,26739,21209,12957,8176,3187,19662,26748,1694,18426,2810,1690,3167,4257,6298,24995,26745,26757,4229,28344,9179,372,3358,19575,3356,5411,4453,5100,2118,2683,8145,2393,19244,3477,24935,3367,26740,3578,5817,25019", -- Mining Pick
	[2902]=":1305:4:2:1:::1:0:", -- Cloak of the Faith
	[2903]=":515:2:2:1:::1:0:", -- Daryl\'s Hunting Bow
	[2904]=":595:2:2:1:::1:0:", -- Daryl\'s Hunting Rifle
	[2905]=":42:4:1:1:::1:0:", -- Goat Fur Cloak
	[2906]=":1810:4:2:1:::1:0:", -- Darkshire Mail Leggings
	[2907]=":1755:2:2:1:::1:0:", -- Dwarven Tree Chopper
	[2908]=":1409:2:2:1:::1:0:", -- Thornblade
	[2909]="::12:1:20:::1:0:", -- Red Wool Bandana
	[2910]=":1257:4:2:1:::1:0:", -- Gold Militia Boots
	[2911]=":524:4:3:1:::1:0:", -- Keller\'s Girdle
	[2912]=":6731:2:3:1:::1:0:", -- Claw of the Shadowmancer
	[2913]=":1153:4:2:1:::1:0:", -- Silk Mantle of Gamn
	[2915]=":55289:2:4:1:::1:0:", -- Taran Icebreaker
	[2916]=":4405:4:2:1:::1:0:", -- Gold Lion Shield
	[2917]=":665:4:2:1:::1:0:", -- Tranquil Ring
	[2924]=":16:7:1:10::185:1:0:", -- Crocolisk Meat
	[2925]="::12:1:20:::1:0:", -- Crocolisk Skin
	[2926]="::12:1:1:::1:0:", -- Head of Bazil Thredd
	[2928]="20:5:15:1:20::-4:1:0:16768,6301,26744,26751,7947,24843,19372,12028,4775,1325,5163,26758,3561,26765,8363,5139,4585,18009,12043,16268,26754,26752,3955,26743,2225,25010,4561,3334,12097,18019,25082,26756,8934,17486,4897,11189,26759,3954,989,3135,2821,15175,3779,18006,12941,3542,26747,26741,26739,12022,16829,12957,2622,3556,26753,5169,26742,25051,26748,3490,16683,19450,15179,2810,12245,5135,3499,12958,20121,24995,16613,26745,4229,26757,10364,3969,6779,26724,3090,1457,26749,12096,1286,1326,26755,26738,8145,1148,19244,3551,24935,777,3367,26740,5817,25019", -- Dust of Decay
	[2930]="50:12:15:1:20::-4:1:0:16829,2622,12097,10364,3969,18019,6779,3090,1457,1325,5169,12096,3561,3490,16683,1326,5139,3135,15175,4585,16268,3551,18006,20121,3542,3334", -- Essence of Pain
	[2931]="1000:250:15:1:20:::1:0:19239,16829,2622,20986,20915,1325,5169,3561,16683,3490,20081,5139,16588,4585,16268,19679,23373,19013,19049,20121,3334,10364,12097,3969,25633,18019,6779,22479,23145,1457,3090,25043,12096,1326,3135,15175,20194,18802,3551,18006,19014,3542", -- Maiden\'s Anguish
	[2933]=":3750:4:3:1:::1:0:", -- Seal of Wrynn
	[2934]=":7:7:1:20::165:1:0:", -- Ruined Leather Scraps
	[2939]="::12:1:1:::1:0:", -- Crocolisk Tear
	[2940]=":43:15:0:5:::1:0:", -- Bloody Bear Paw
	[2941]=":3552:2:3:1:::1:0:", -- Prison Shank
	[2942]=":3663:2:3:1:::1:0:", -- Iron Knuckles
	[2943]=":537:4:2:1:::1:0:", -- Eye of Paleth
	[2944]="::4:2:1:::1:0:", -- Cursed Eye of Paleth
	[2946]="::15:1:200:::200:0:", -- Broken Balanced Throwing Dagger
	[2947]="::15:1:200:::200:0:", -- Broken Small Throwing Knife
	[2949]=":1039:4:2:1:::1:0:", -- Mariner Boots
	[2950]=":3476:2:2:1:::1:0:", -- Icicle Rod
	[2951]=":656:4:3:1:::1:0:", -- Ring of the Underwood
	[2953]=":1857:4:2:1:::1:0:", -- Watch Master\'s Cloak
	[2954]=":2485:4:2:1:::1:0:", -- Night Watch Pantaloons
	[2955]=":3449:4:2:1:::1:0:", -- First Mate Hat
	[2956]="::12:1:1:::1:0:", -- Report on the Defias Brotherhood
	[2957]=":119:4:2:1:::1:0:", -- Journeyman\'s Vest
	[2958]=":94:4:2:1:::1:0:", -- Journeyman\'s Pants
	[2959]=":32:4:1:1:::1:0:", -- Journeyman\'s Boots
	[2960]=":22:4:1:1:::1:0:", -- Journeyman\'s Gloves
	[2961]=":155:4:2:1:::1:0:", -- Burnt Leather Vest
	[2962]=":120:4:2:1:::1:0:", -- Burnt Leather Breeches
	[2963]=":41:4:1:1:::1:0:", -- Burnt Leather Boots
	[2964]=":36:4:1:1:::1:0:", -- Burnt Leather Gloves
	[2965]=":189:4:2:1:::1:0:", -- Warrior\'s Tunic
	[2966]=":146:4:2:1:::1:0:", -- Warrior\'s Pants
	[2967]=":66:4:1:1:::1:0:", -- Warrior\'s Boots
	[2968]=":34:4:1:1:::1:0:", -- Warrior\'s Gloves
	[2969]=":381:4:2:1:::1:0:", -- Spellbinder Vest
	[2970]=":333:4:2:1:::1:0:", -- Spellbinder Pants
	[2971]=":109:4:1:1:::1:0:", -- Spellbinder Boots
	[2972]=":72:4:1:1:::1:0:", -- Spellbinder Gloves
	[2973]=":484:4:2:1:::1:0:", -- Hunting Tunic
	[2974]=":392:4:2:1:::1:0:", -- Hunting Pants
	[2975]=":128:4:1:1:::1:0:", -- Hunting Boots
	[2976]=":172:4:2:1:::1:0:", -- Hunting Gloves
	[2977]=":476:4:2:1:::1:0:", -- Veteran Armor
	[2978]=":415:4:2:1:::1:0:", -- Veteran Leggings
	[2979]=":157:4:1:1:::1:0:", -- Veteran Boots
	[2980]=":209:4:2:1:::1:0:", -- Veteran Gloves
	[2981]=":648:4:2:1:::1:0:", -- Seer\'s Robe
	[2982]=":566:4:2:1:::1:0:", -- Seer\'s Pants
	[2983]=":280:4:2:1:::1:0:", -- Seer\'s Boots
	[2984]=":215:4:2:1:::1:0:", -- Seer\'s Gloves
	[2985]=":822:4:2:1:::1:0:", -- Inscribed Leather Breastplate
	[2986]=":718:4:2:1:::1:0:", -- Inscribed Leather Pants
	[2987]=":408:4:2:1:::1:0:", -- Inscribed Leather Boots
	[2988]=":314:4:2:1:::1:0:", -- Inscribed Leather Gloves
	[2989]=":1001:4:2:1:::1:0:", -- Burnished Tunic
	[2990]=":933:4:2:1:::1:0:", -- Burnished Leggings
	[2991]=":705:4:2:1:::1:0:", -- Burnished Boots
	[2992]=":408:4:2:1:::1:0:", -- Burnished Gloves
	[2996]="160:40:7:1:10::197:1:0:16631", -- Bolt of Linen Cloth
	[2997]="400:100:7:1:10::165,197:1:0:16631", -- Bolt of Woolen Cloth
	[2998]="::12:1:1:::1:0:", -- A Simple Compass
	[2999]="::12:1:1:::1:0:", -- Steelgrill\'s Tools
	[3000]=":119:4:2:1:::1:0:", -- Brood Mother Carapace
	[3008]=":34:4:1:1:::1:0:", -- Wendigo Fur Cloak
	[3010]=":101:15:0:5:::1:0:", -- Fine Sand
	[3011]=":2847:4:2:1:::1:0:", -- Feathered Headdress
	[3012]="200:50:0:1:5:::1:0:14847,16224,2805,4878,13476,1316,958,4581", -- Scroll of Agility
	[3013]="100:25:0:1:5:::1:0:14847,16224,1316,958,4581", -- Scroll of Protection
	[3014]="::12:1:20:::1:0:", -- Battleworn Axe
	[3016]="::12:1:1:::1:0:", -- Gunther\'s Spellbook
	[3017]="::12:1:1:::1:0:", -- Sevren\'s Orders
	[3018]=":625:4:2:1:::1:0:", -- Hide of Lupos
	[3019]=":423:4:2:1:::1:0:", -- Noble\'s Robe
	[3020]=":2655:4:3:1:::1:0:", -- Enduring Cap
	[3021]=":2421:2:3:1:::1:0:", -- Ranger Bow
	[3022]=":1085:4:2:1:::1:0:", -- Bluegill Breeches
	[3023]="3772:754:2:1:1:::1:0:1461,9551,16620,1297,3322,3053,16735,9548,11184,16274,5123,1686,8131,3018,4889,3088,4603", -- Large Bore Blunderbuss
	[3024]="7098:1419:2:1:1:::1:0:5123,1461,9551,16620,8131,1297,3322,3018,4889,3053,16735,11184,9548,4603", -- BKP 2700 \"Enforcer\"
	[3025]="18479:3695:2:1:1:::1:0:22491,9548,11184,19836,8131,3322", -- BKP 42 \"Ultra\"
	[3026]="3812:762:2:1:1:::1:0:4604,9553,4173,1668,3410,3015,19020,3951,4203,9552,5122,4892,1687,3409,9555,3488,14301,16715,2839,1298,9551,1297,228,9549,12029,16619,9548,16274,1459,17667,16263,19561", -- Reinforced Bow
	[3027]="6349:1269:2:1:1:::1:0:4604,9551,4173,1297,228,16619,12029,3410,9548,16274,3015,17667,19020,9552,5122,4892,9555,14301,16715,19561,16263,2839,1298", -- Heavy Recurve Bow
	[3030]="300::6:1:200:::200:0:1285,11555,4173,5122,12246,16191,227,9555,2803,16715,2839,16732,3313,12959,9551,734,12021,12029,16619,9548,8139,16274,17667,4555,2401,2084,1448,7942,17489,12027,4241,19561,16919,2808,15397,3962,4604,11038,4602,7976,3625,3410,1462,6028,3015,12960,2806,2908,19020,8362,789,5101,4170,1149,9552,3541,4892,1452,14301,1298,15174,3350,1297,228,4896,14624,17598,4876,5134,2820,1287,16263", -- Razor Arrow
	[3033]="300::6:1:200:::200:0:2808,3962,15397,1285,11038,11555,3625,3053,11184,6028,12960,2806,2908,8362,5101,1149,4170,3541,12246,16191,227,1452,2803,3088,16732,3313,15174,12959,1461,3350,9551,16620,734,1297,3322,12021,2685,4896,16735,8139,9548,14624,16274,4555,2401,2084,5123,1686,4876,8131,1448,7942,17489,12027,4241,3018,4889,5134,2820,4603", -- Solid Shot
	[3035]="::12:1:1:::1:0:", -- Laced Pumpkin
	[3036]=":515:2:2:1:::1:0:", -- Heavy Shortbow
	[3037]=":4814:2:2:1:::1:0:", -- Whipwood Recurve Bow
	[3039]=":1610:2:2:1:::1:0:", -- Short Ash Bow
	[3040]=":940:2:2:1:::1:0:", -- Hunter\'s Muzzle Loader
	[3041]=":3769:2:2:1:::1:0:", -- \"Mage-Eye\" Blunderbuss
	[3042]=":4577:2:2:1:::1:0:", -- BKP \"Sparrow\" Smallbore
	[3045]=":1574:4:2:1:::1:0:", -- Lambent Scale Boots
	[3047]=":1052:4:2:1:::1:0:", -- Lambent Scale Gloves
	[3048]=":1919:4:2:1:::1:0:", -- Lambent Scale Legguards
	[3049]=":2119:4:2:1:::1:0:", -- Lambent Scale Breastplate
	[3053]=":2140:4:2:1:::1:0:", -- Humbert\'s Chestpiece
	[3055]=":1526:4:2:1:::1:0:", -- Forest Leather Chestpiece
	[3056]=":1532:4:2:1:::1:0:", -- Forest Leather Pants
	[3057]=":903:4:2:1:::1:0:", -- Forest Leather Boots
	[3058]=":682:4:2:1:::1:0:", -- Forest Leather Gloves
	[3065]=":658:4:2:1:::1:0:", -- Bright Boots
	[3066]=":497:4:2:1:::1:0:", -- Bright Gloves
	[3067]=":1275:4:2:1:::1:0:", -- Bright Pants
	[3069]=":1412:4:2:1:::1:0:", -- Bright Robe
	[3070]=":7:4:1:1:::1:0:", -- Ensign Cloak
	[3071]=":231:2:1:1:::1:0:", -- Striking Hatchet
	[3072]=":1207:4:2:1:::1:0:", -- Smoldering Robe
	[3073]=":1211:4:2:1:::1:0:", -- Smoldering Pants
	[3074]=":476:4:2:1:::1:0:", -- Smoldering Gloves
	[3075]=":15073:4:4:1:::1:0:", -- Eye of Flame
	[3076]=":636:4:2:1:::1:0:", -- Smoldering Boots
	[3078]=":2777:2:3:1:::1:0:", -- Naga Heartpiercer
	[3079]=":297:2:2:1:::1:0:", -- Skorn\'s Rifle
	[3080]="::12:1:1:::1:0:", -- Candle of Beckoning
	[3081]="::12:1:1:::1:0:", -- Nether Gem
	[3082]="::12:1:1:::1:0:", -- Dargol\'s Skull
	[3083]="::12:1:20:::1:0:", -- Restabilization Cog
	[3084]="::12:1:20:::1:0:", -- Gyromechanic Gear
	[3085]="::12:1:1:::1:0:", -- Barrel of Shimmer Stout
	[3086]="::12:1:1:::1:0:", -- Cask of Shimmer Stout
	[3087]=":11:0:1:10:::1:0:", -- Mug of Shimmer Stout
	[3103]=":466:2:2:1:::1:0:", -- Coldridge Hammer
	[3107]="::15:1:200:::200:0:", -- Broken Keen Throwing Knife
	[3108]="::15:1:200:::200:0:", -- Broken Heavy Throwing Dagger
	[3110]="::12:1:20:::1:0:", -- Tunnel Rat Ear
	[3111]="::15:1:200:::200:0:", -- Broken Crude Throwing Axe
	[3117]="::12:1:1:::1:0:", -- Hildelve\'s Journal
	[3131]="::15:1:200:::200:0:", -- Broken Weighted Throwing Axe
	[3135]="::15:1:200:::200:0:", -- Broken Sharp Throwing Axe
	[3137]="::15:1:200:::200:0:", -- Broken Deadly Throwing Axe
	[3151]=":87:4:1:1:::1:0:", -- Siege Brigade Vest
	[3152]=":28:4:1:1:::1:0:", -- Driving Gloves
	[3153]=":33:4:1:1:::1:0:", -- Oil-stained Cloak
	[3154]=":1094:2:2:1:::1:0:", -- Thelsamar Axe
	[3155]="::12:1:1:::1:0:", -- Remedy of Arugal
	[3156]="::12:1:20:::1:0:", -- Glutton Shackle
	[3157]="::12:1:20:::1:0:", -- Darksoul Shackle
	[3158]=":60:4:1:1:::1:0:", -- Burnt Hide Bracers
	[3160]=":470:4:2:1:::1:0:", -- Ironplate Buckler
	[3161]=":295:4:2:1:::1:0:", -- Robe of the Keeper
	[3162]="::12:1:20:::1:0:", -- Notched Rib
	[3163]="::12:1:20:::1:0:", -- Blackened Skull
	[3164]=":33:7:1:10::171:1:0:", -- Discolored Worg Heart
	[3165]="::12:1:1:::1:0:", -- Quinn\'s Potion
	[3166]=":407:4:2:1:::1:0:", -- Ironheart Chain
	[3167]=":68:15:0:10:::1:0:", -- Thick Spider Hair
	[3169]=":18:15:0:10:::1:0:", -- Chipped Bear Tooth
	[3170]=":47:15:0:10:::1:0:", -- Large Bear Tooth
	[3171]=":6:15:0:5:::1:0:", -- Broken Boar Tusk
	[3172]=":18:7:1:10::185:1:0:", -- Boar Intestines
	[3173]=":15:7:1:10::185:1:0:", -- Bear Meat
	[3174]=":16:7:1:10::185:1:0:", -- Spider Ichor
	[3175]=":100:15:0:10:::1:0:", -- Ruined Dragonhide
	[3176]=":75:15:0:10:::1:0:", -- Small Claw
	[3177]=":50:15:0:10:::1:0:", -- Tiny Fang
	[3179]=":125:15:0:10:::1:0:", -- Cracked Dragon Molting
	[3180]=":168:15:0:5:::1:0:", -- Flecked Raptor Scale
	[3181]=":23:15:0:5:::1:0:", -- Partially Digested Meat
	[3182]=":387:7:1:10::165,197:1:0:", -- Spider\'s Silk
	[3183]="::12:1:1:::1:0:", -- Mangy Claw
	[3184]=":1394:2:2:1:::1:0:", -- Hook Dagger
	[3185]=":8088:2:2:1:::1:0:", -- Acrobatic Staff
	[3186]=":4436:2:2:1:::1:0:", -- Viking Sword
	[3187]=":14870:2:2:1:::1:0:", -- Sacrificial Kris
	[3188]=":879:2:2:1:::1:0:", -- Coral Claymore
	[3189]=":99:2:1:1:::1:0:", -- Wood Chopper
	[3190]=":99:2:1:1:::1:0:", -- Beatstick
	[3191]=":4629:2:3:1:::1:0:", -- Arced War Axe
	[3192]=":495:2:2:1:::1:0:", -- Short Bastard Sword
	[3193]=":2072:2:2:1:::1:0:", -- Oak Mallet
	[3194]=":2496:2:3:1:::1:0:", -- Black Malice
	[3195]=":1372:2:2:1:::1:0:", -- Barbaric Battle Axe
	[3196]=":1377:2:2:1:::1:0:", -- Edged Bastard Sword
	[3197]=":9295:2:2:1:::1:0:", -- Stonecutter Claymore
	[3198]=":2742:2:2:1:::1:0:", -- Battering Hammer
	[3199]=":2262:2:2:1:::1:0:", -- Battle Slayer
	[3200]=":19:4:1:1:::1:0:", -- Burnt Leather Bracers
	[3201]=":4496:2:2:1:::1:0:", -- Barbarian War Axe
	[3202]=":584:4:2:1:::1:0:", -- Forest Leather Bracers
	[3203]=":5436:2:3:1:::1:0:", -- Dense Triangle Mace
	[3204]=":751:4:2:1:::1:0:", -- Deepwood Bracers
	[3205]=":230:4:2:1:::1:0:", -- Inscribed Leather Bracers
	[3206]=":4582:2:2:1:::1:0:", -- Cavalier Two-hander
	[3207]=":87:4:1:1:::1:0:", -- Hunting Bracers
	[3208]=":25378:2:2:1:::1:0:", -- Conk Hammer
	[3209]=":6783:2:2:1:::1:0:", -- Ancient War Sword
	[3210]=":5627:2:2:1:::1:0:", -- Brutal War Axe
	[3211]=":373:4:2:1:::1:0:", -- Burnished Bracers
	[3212]=":929:4:2:1:::1:0:", -- Lambent Scale Bracers
	[3213]=":89:4:1:1:::1:0:", -- Veteran Bracers
	[3214]=":34:4:1:1:::1:0:", -- Warrior\'s Bracers
	[3216]=":55:4:1:1:::1:0:", -- Warm Winter Robe
	[3217]=":135:4:2:1:::1:0:", -- Foreman Belt
	[3218]="::12:1:20:::1:0:", -- Pyrewood Shackle
	[3220]=":40:0:1:20:::1:0:", -- Blood Sausage
	[3223]=":306:2:2:1:::1:0:", -- Frostmane Scepter
	[3224]=":28:4:1:1:::1:0:", -- Silver-lined Bracers
	[3225]=":109:2:1:1:::1:0:", -- Bloodstained Knife
	[3227]=":2633:2:2:1:::1:0:", -- Nightbane Staff
	[3228]=":1098:4:3:1:::1:0:", -- Jimmied Handcuffs
	[3229]=":424:4:2:1:::1:0:", -- Tarantula Silk Sash
	[3230]=":922:4:3:1:::1:0:", -- Black Wolf Bracers
	[3231]=":1266:4:2:1:::1:0:", -- Cutthroat Pauldrons
	[3233]=":212:1:1:1:::1:0:", -- Gnoll Hide Sack
	[3234]="::12:1:1:::1:0:", -- Deliah\'s Ring
	[3235]=":412:4:2:1:::1:0:", -- Ring of Scorn
	[3236]="::12:1:20:::1:0:", -- Rot Hide Ichor
	[3237]="::12:1:1:::1:0:", -- Sample Ichor
	[3238]="::12:1:1:::1:0:", -- Johaan\'s Findings
	[3239]=":3:0:1:20:::1:0:", -- Rough Weightstone
	[3240]=":10:0:1:20:::1:0:", -- Coarse Weightstone
	[3241]=":40:0:1:20:::1:0:", -- Heavy Weightstone
	[3248]="::12:1:1:::1:0:", -- Translated Letter from The Embalmer
	[3250]="::12:1:1:::1:0:", -- Bethor\'s Scroll
	[3251]="::12:1:1:::1:0:", -- Bethor\'s Potion
	[3252]="::12:1:1:::1:0:", -- Deathstalker Report
	[3253]="::12:1:20:::1:0:", -- Grizzled Bear Heart
	[3254]="::12:1:20:::1:0:", -- Skittering Blood
	[3255]="::12:1:1:::1:0:", -- Berard\'s Journal
	[3256]="::12:1:20:::1:0:", -- Lake Skulker Moss
	[3257]="::12:1:20:::1:0:", -- Lake Creeper Moss
	[3258]="::12:1:1:::1:0:", -- Hardened Tumor
	[3260]=":6:4:1:1:::1:0:", -- Scarlet Initiate Robes
	[3261]=":7:4:1:1:::1:0:", -- Webbed Cloak
	[3262]=":10:2:1:1:::1:0:", -- Putrid Wooden Hammer
	[3263]=":4:4:1:1:::1:0:", -- Webbed Pants
	[3264]="::12:1:20:::1:0:", -- Duskbat Wing
	[3265]="::12:1:20:::1:0:", -- Scavenger Paw
	[3266]="::12:1:20:::1:0:", -- Scarlet Armband
	[3267]=":25:2:1:1:::1:0:", -- Forsaken Shortsword
	[3268]=":25:2:1:1:::1:0:", -- Forsaken Dagger
	[3269]=":25:2:1:1:::1:0:", -- Forsaken Maul
	[3270]=":10:4:1:1:::1:0:", -- Flax Vest
	[3272]=":13:4:1:1:::1:0:", -- Zombie Skin Leggings
	[3273]=":15:4:1:1:::1:0:", -- Rugged Mail Vest
	[3274]=":7:4:1:1:::1:0:", -- Flax Boots
	[3275]=":5:4:1:1:::1:0:", -- Flax Gloves
	[3276]=":15:4:1:1:::1:0:", -- Deathguard Buckler
	[3277]=":30:2:1:1:::1:0:", -- Executor Staff
	[3279]=":105:4:1:1:::1:0:", -- Battle Chain Boots
	[3280]=":33:4:1:1:::1:0:", -- Battle Chain Bracers
	[3281]=":56:4:1:1:::1:0:", -- Battle Chain Gloves
	[3282]=":235:4:2:1:::1:0:", -- Battle Chain Pants
	[3283]=":295:4:2:1:::1:0:", -- Battle Chain Tunic
	[3284]=":88:4:1:1:::1:0:", -- Tribal Boots
	[3285]=":36:4:1:1:::1:0:", -- Tribal Bracers
	[3286]=":59:4:1:1:::1:0:", -- Tribal Gloves
	[3287]=":199:4:2:1:::1:0:", -- Tribal Pants
	[3288]=":250:4:2:1:::1:0:", -- Tribal Vest
	[3289]=":57:4:1:1:::1:0:", -- Ancestral Boots
	[3290]=":48:4:1:1:::1:0:", -- Ancestral Gloves
	[3291]=":202:4:2:1:::1:0:", -- Ancestral Woollies
	[3292]=":203:4:2:1:::1:0:", -- Ancestral Tunic
	[3293]=":11:2:1:1:::1:0:", -- Deadman Cleaver
	[3294]=":11:2:1:1:::1:0:", -- Deadman Club
	[3295]=":10:2:1:1:::1:0:", -- Deadman Blade
	[3296]=":10:2:1:1:::1:0:", -- Deadman Dagger
	[3297]="::12:1:20:::1:0:", -- Fel Moss
	[3299]=":48:15:0:10:::1:0:", -- Fractured Canine
	[3300]=":9:15:0:5:::1:0:", -- Rabbit\'s Foot
	[3301]=":102:15:0:10:::1:0:", -- Sharp Canine
	[3302]=":319:4:2:1:::1:0:", -- Brackwater Boots
	[3303]=":70:4:1:1:::1:0:", -- Brackwater Bracers
	[3304]=":106:4:1:1:::1:0:", -- Brackwater Gauntlets
	[3305]=":492:4:2:1:::1:0:", -- Brackwater Leggings
	[3306]=":654:4:2:1:::1:0:", -- Brackwater Vest
	[3307]=":215:4:2:1:::1:0:", -- Barbaric Cloth Boots
	[3308]=":144:4:2:1:::1:0:", -- Barbaric Cloth Gloves
	[3309]=":333:4:2:1:::1:0:", -- Barbaric Loincloth
	[3310]=":442:4:2:1:::1:0:", -- Barbaric Cloth Vest
	[3311]=":152:4:1:1:::1:0:", -- Ceremonial Leather Ankleguards
	[3312]=":70:4:1:1:::1:0:", -- Ceremonial Leather Bracers
	[3313]=":519:4:2:1:::1:0:", -- Ceremonial Leather Harness
	[3314]=":171:4:2:1:::1:0:", -- Ceremonial Leather Gloves
	[3315]=":455:4:2:1:::1:0:", -- Ceremonial Leather Loincloth
	[3317]="::12:1:1:::1:0:", -- A Talking Head
	[3318]="::12:1:1:::1:0:", -- Alaric\'s Remains
	[3319]=":110:2:1:1:::1:0:", -- Short Sabre
	[3321]=":41:4:1:1:::1:0:", -- Gray Fur Booties
	[3322]=":11:4:1:1:::1:0:", -- Wispy Cloak
	[3323]=":15:4:1:1:::1:0:", -- Ghostly Bracers
	[3324]=":1120:4:2:1:::1:0:", -- Ghostly Mantle
	[3325]=":140:2:1:1:::1:0:", -- Vile Fin Battle Axe
	[3327]=":141:2:1:1:::1:0:", -- Vile Fin Oracle Staff
	[3328]=":46:4:1:1:::1:0:", -- Spider Web Robe
	[3329]=":179:2:1:1:::1:0:", -- Spiked Wooden Plank
	[3330]=":281:4:2:1:::1:0:", -- Dargol\'s Hauberk
	[3331]=":67:4:1:1:::1:0:", -- Melrache\'s Cape
	[3332]=":48:4:1:1:::1:0:", -- Perrine\'s Boots
	[3334]=":68:2:1:1:::1:0:", -- Farmer\'s Shovel
	[3335]=":46:2:1:1:::1:0:", -- Farmer\'s Broom
	[3336]=":3986:2:2:1:::1:0:", -- Flesh Piercer
	[3337]="::12:1:20:::1:0:", -- Dragonmaw War Banner
	[3339]="::12:1:1:::1:0:", -- Dwarven Tinder
	[3340]=":31:12:1:10:::1:0:", -- Incendicite Ore
	[3341]=":1621:4:2:1:::1:0:", -- Gauntlets of Ogre Strength
	[3342]=":137:4:1:1:::1:0:", -- Captain Sander\'s Shirt
	[3343]=":450:1:1:1:::1:0:", -- Captain Sander\'s Booty Bag
	[3344]=":146:4:2:1:::1:0:", -- Captain Sander\'s Sash
	[3345]=":2720:4:2:1:::1:0:", -- Silk Wizard Hat
	[3347]="::12:1:1:::1:0:", -- Bundle of Crocolisk Skins
	[3348]="::12:1:20:::1:0:", -- Giant Crocolisk Skin
	[3349]="::12:1:1:::1:0:", -- Sida\'s Bag
	[3352]=":1250:1:1:1:::1:0:", -- Ooze-covered Bag
	[3353]="::12:1:1:::1:0:", -- Rune-inscribed Pendant
	[3354]="::12:1:20:::1:0:", -- Dalaran Pendant
	[3355]="200:50:7:1:20::171:1:0:16641,4878,1313,16705,844,4083,14846,8305,1302", -- Wild Steelbloom
	[3356]="120:30:7:1:20::171,333,165:1:0:16641,4878,1313,16705,844,4083,14846,8305,1302", -- Kingsblood
	[3357]="300:75:7:1:20::171:1:0:16641,4878,1313,16705,844,4083,14846,8305,1302", -- Liferoot
	[3358]="700:175:7:1:20::171:1:0:14846", -- Khadgar\'s Whisker
	[3360]=":625:4:1:1:::1:0:", -- Stitches\' Femur
	[3363]=":1:4:0:1:::1:0:", -- Frayed Belt
	[3365]=":3:4:0:1:::1:0:", -- Frayed Bracers
	[3369]=":25:7:1:20::171:1:0:", -- Grave Moss
	[3370]=":10:4:0:1:::1:0:", -- Patchwork Belt
	[3371]="20:1:7:1:20::171,333:5:0:16768,26744,24975,1453,26751,7947,24843,2480,4775,843,17490,26765,4899,2848,16612,1692,5178,16705,18427,3955,3014,25633,18019,25082,2812,17486,4897,5138,3954,4216,3135,2821,16224,15175,3348,1250,5594,3614,3168,4615,26747,4877,12022,16829,9636,3556,4610,26753,5169,26742,3548,25051,958,19450,15179,5135,12245,3499,12958,20121,16613,1313,10364,26724,3090,26749,19837,19074,12096,1286,1326,26755,26738,1148,8305,16706,3551,2381,777,2380,20989,4194,16367,6301,12028,19372,16261,5163,1325,3561,26758,1456,8363,5139,4585,983,18009,8178,960,16268,11188,12043,66,26754,26752,3405,26743,25010,2225,4561,3334,3482,8158,12097,18005,3010,8934,26756,11189,26759,989,1465,3779,16262,18006,3081,16641,12941,3542,26739,26741,12957,2622,3187,26748,16683,3490,18426,2810,844,8157,24995,26745,4229,26757,1257,3969,6779,1457,2481,8177,4226,14847,5100,3956,2118,8145,2393,19244,24935,3367,5503,26740,5817,25019", -- Empty Vial
	[3372]="200:10:7:1:20::171,333:5:0:16768,26744,24975,1453,26751,7947,24843,2480,4775,26765,4899,2848,16612,5178,16705,3955,3014,25633,18019,25082,2812,17486,4897,5138,3954,4216,3135,2821,15175,3348,5594,4615,26747,4877,12022,16829,9636,3556,4610,26753,5169,26742,3548,25051,958,19450,15179,5135,12245,3499,12958,20121,16613,1313,10364,26724,3090,26749,19074,19837,12096,1286,1326,26755,26738,1148,8305,16706,3551,2381,777,2380,20989,16367,6301,12028,19372,5163,1325,3561,26758,1456,8363,5139,4585,983,18009,8178,16268,11188,12043,960,26754,26752,3405,26743,25010,2225,3334,4561,8158,12097,18005,3010,8934,26756,11189,26759,989,3779,18006,16641,12941,3542,26739,26741,12957,2622,26748,16683,3490,2810,844,8157,24995,4229,26757,26745,1257,3969,6779,1457,2481,8177,4226,14847,3956,5100,8145,2393,19244,24935,3367,5503,26740,5817,25019", -- Leaded Vial
	[3373]=":14:4:0:1:::1:0:", -- Patchwork Bracers
	[3374]=":45:4:0:1:::1:0:", -- Calico Belt
	[3375]=":30:4:0:1:::1:0:", -- Calico Bracers
	[3376]=":86:4:0:1:::1:0:", -- Canvas Belt
	[3377]=":99:4:0:1:::1:0:", -- Canvas Bracers
	[3378]=":132:4:0:1:::1:0:", -- Brocade Belt
	[3379]=":152:4:0:1:::1:0:", -- Brocade Bracers
	[3380]=":365:4:0:1:::1:0:", -- Cross-stitched Belt
	[3381]=":303:4:0:1:::1:0:", -- Cross-stitched Bracers
	[3382]=":10:0:1:20:::1:0:", -- Weak Troll\'s Blood Potion
	[3383]=":100:0:1:20::165,197:1:0:", -- Elixir of Wisdom
	[3384]=":20:0:1:5:::1:0:", -- Minor Magic Resistance Potion
	[3385]="120:30:0:1:5:::1:0:14847,2805,3956,13476,2481,4083,1307,3134", -- Lesser Mana Potion
	[3386]=":35:0:1:20:::1:0:", -- Potion of Curing
	[3387]=":30:0:1:5:::1:0:", -- Limited Invulnerability Potion
	[3388]=":40:0:1:20:::1:0:", -- Strong Troll\'s Blood Potion
	[3389]=":40:0:1:20::165:1:0:", -- Elixir of Defense
	[3390]=":35:0:1:20::165:1:0:", -- Elixir of Lesser Agility
	[3391]=":20:0:1:20::164,755:1:0:", -- Elixir of Ogre\'s Strength
	[3392]=":1663:4:2:1:::1:0:", -- Ringed Helm
	[3393]=":250:9:1:1:::1:0:", -- Recipe: Minor Magic Resistance Potion
	[3394]=":250:9:1:1:::1:0:", -- Recipe: Potion of Curing
	[3395]=":250:9:2:1:::1:0:", -- Recipe: Limited Invulnerability Potion
	[3396]=":250:9:2:1:::1:0:", -- Recipe: Elixir of Lesser Agility
	[3397]="::12:1:20:::1:0:", -- Young Crocolisk Skin
	[3399]=":81:15:0:5:::1:0:", -- Vulture Talon
	[3400]=":2761:2:2:1:::1:0:", -- Lucine Longsword
	[3401]=":81:15:0:5:::1:0:", -- Rough Crocolisk Scale
	[3402]=":602:15:0:5:::1:0:", -- Soft Patch of Fur
	[3403]=":321:15:0:5:::1:0:", -- Ivory Boar Tusk
	[3404]=":181:7:1:10::185:1:0:", -- Buzzard Wing
	[3405]="::12:1:1:::1:0:", -- Raven Claw Talisman
	[3406]="::12:1:1:::1:0:", -- Black Feather Quill
	[3407]="::12:1:1:::1:0:", -- Sapphire of Sky
	[3408]="::12:1:1:::1:0:", -- Rune of Nesting
	[3409]="::12:1:20:::1:0:", -- Nightsaber Fang
	[3411]="::12:1:20:::1:0:", -- Strigid Owl Feather
	[3412]="::12:1:20:::1:0:", -- Webwood Spider Silk
	[3413]=":3229:2:3:1:::1:0:", -- Doomspike
	[3414]=":4029:2:3:1:::1:0:", -- Crested Scepter
	[3415]=":3598:2:3:1:::1:0:", -- Staff of the Friar
	[3416]=":2213:4:3:1:::1:0:", -- Martyr\'s Chain
	[3417]=":4629:2:3:1:::1:0:", -- Onyx Claymore
	[3418]="::12:1:20:::1:0:", -- Fel Cone
	[3419]="500:125:4:1:1:::1:0:3014,1303,1302", -- Red Rose
	[3420]="5000:1250:4:1:1:::1:0:3014,1303,1302", -- Black Rose
	[3421]="200:50:4:1:1:::1:0:3014,1303,1302", -- Simple Wildflowers
	[3422]="2000:500:4:1:1:::1:0:3014,1303,1302", -- Beautiful Wildflowers
	[3423]="20000:5000:4:1:1:::1:0:3014,1303,1302", -- Bouquet of White Roses
	[3424]="500000:125000:4:1:1:::1:0:3014,1303,1302", -- Bouquet of Black Roses
	[3425]="::12:1:1:::1:0:", -- Woven Wand
	[3426]="4000:1000:4:1:1:::1:0:1299", -- Bold Yellow Shirt
	[3427]="6000:1500:4:1:1:::1:0:1299", -- Stylish Black Shirt
	[3428]="400:100:4:1:1:::1:0:3683,3317,16631,5108,1291,1214,16623,8358,16716,4185,4558,3554,1299", -- Common Gray Shirt
	[3429]=":586:4:2:1:::1:0:", -- Guardsman Belt
	[3430]=":11027:2:2:1:::1:0:", -- Sniper Rifle
	[3431]=":1335:4:2:1:::1:0:", -- Bone-studded Leather
	[3434]=":3:0:1:10:::1:0:", -- Slumber Sand
	[3435]=":19:4:1:1:::1:0:", -- Zombie Skin Bracers
	[3437]=":24:4:1:1:::1:0:", -- Clasped Belt
	[3439]=":30:4:1:1:::1:0:", -- Zombie Skin Boots
	[3440]=":640:2:2:1:::1:0:", -- Bonecracker
	[3442]=":44:4:1:1:::1:0:", -- Apprentice Sash
	[3443]=":138:2:1:1:::1:0:", -- Ceremonial Tomahawk
	[3444]=":90:4:1:1:::1:0:", -- Tiller\'s Vest
	[3445]=":226:2:1:1:::1:0:", -- Ceremonial Knife
	[3446]=":592:2:2:1:::1:0:", -- Darkwood Staff
	[3447]=":34:4:1:1:::1:0:", -- Cryptwalker Boots
	[3448]=":6:0:1:20:::1:0:", -- Senggin Root
	[3449]=":207:4:2:1:::1:0:", -- Mystic Shawl
	[3450]=":443:4:2:1:::1:0:", -- Faerleia\'s Shield
	[3451]=":607:4:2:1:::1:0:", -- Nightglow Concoction
	[3452]=":2322:2:2:1:::1:0:", -- Ceranium Rod
	[3453]=":46:4:1:1:::1:0:", -- Quilted Bracers
	[3454]=":105:4:1:1:::1:0:", -- Reconnaissance Boots
	[3455]=":188:2:1:1:::1:0:", -- Deathstalker Shortsword
	[3456]=":6375:15:3:1:::1:0:", -- Dog Whistle
	[3457]=":444:4:2:1:::1:0:", -- Stamped Trousers
	[3458]=":334:4:2:1:::1:0:", -- Rugged Mail Gloves
	[3460]="::12:1:1:::1:0:", -- Johaan\'s Special Drink
	[3461]=":1006:4:2:1:::1:0:", -- High Robe of the Adjudicator
	[3462]=":2283:2:2:1:::1:0:", -- Talonstrike
	[3463]=":9:15:2:200:::1:0:", -- Broken Silver Star
	[3464]=":8:6:2:200:::1:0:", -- Feathered Arrow
	[3465]=":9:6:2:200:::1:0:", -- Exploding Shot
	[3466]="2000:500:7:1:10::164:1:0:16768,26744,8161,26751,7947,5512,24843,4775,26765,25634,16823,9544,22476,6777,3955,19056,14637,22264,19879,3133,3343,16751,16657,17421,25082,17486,4897,3954,5175,27711,2821,4587,20082,2682,17245,17655,1448,26747,4877,2847,12022,4599,9636,2999,19012,26753,26742,9676,25051,17222,19450,15179,20981,4256,5135,12245,19342,19011,12958,19520,16613,23144,2684,2844,15176,5514,26724,26749,5519,4259,14624,16782,1286,26755,26738,1148,19383,790,15400,2687,2381,16376,23724,8679,3002,8678,2688,6301,12028,19372,11186,18484,5163,19530,26758,1456,8363,16664,18009,960,18775,26754,26752,18752,26743,25010,2225,4561,4597,8934,26756,2685,6300,18278,11189,26759,20463,16583,989,11185,14737,20890,6730,3495,3779,3413,16670,12941,16713,26741,26739,21209,12957,8176,19662,26748,1694,2810,1690,3167,4257,6298,24995,26745,4229,26757,28344,9179,372,3358,3356,4453,5411,5100,2683,8145,2393,19244,3477,24935,3367,26740,3578,5817,25019", -- Strong Flux
	[3467]="::13:1:1:::1:0:", -- Dull Iron Key
	[3468]="::12:1:1:::1:0:", -- Renferrel\'s Findings
	[3469]=":49:4:1:1:::1:0:", -- Copper Chain Boots
	[3470]=":5:7:1:20::164:1:0:", -- Rough Grinding Stone
	[3471]=":142:4:2:1:::1:0:", -- Copper Chain Vest
	[3472]=":71:4:1:1:::1:0:", -- Runed Copper Gauntlets
	[3473]=":299:4:2:1:::1:0:", -- Runed Copper Pants
	[3474]=":216:4:2:1:::1:0:", -- Gemmed Copper Gauntlets
	[3475]=":21810:4:4:1:::1:0:", -- Cloak of Flames
	[3476]="::12:1:20:::1:0:", -- Gray Bear Tongue
	[3477]="::12:1:1:::1:0:", -- Creeper Ichor
	[3478]=":10:7:1:20::164:1:0:", -- Coarse Grinding Stone
	[3480]=":532:4:1:1:::1:0:", -- Rough Bronze Shoulders
	[3481]=":1284:4:2:1:::1:0:", -- Silvered Bronze Shoulders
	[3482]=":1317:4:2:1:::1:0:", -- Silvered Bronze Boots
	[3483]=":965:4:2:1:::1:0:", -- Silvered Bronze Gauntlets
	[3484]=":1767:4:2:1:::1:0:", -- Green Iron Boots
	[3485]=":1295:4:2:1:::1:0:", -- Green Iron Gauntlets
	[3486]=":100:7:1:20::164:1:0:", -- Heavy Grinding Stone
	[3487]=":1498:2:2:1:::1:0:", -- Heavy Copper Broadsword
	[3488]=":613:2:2:1:::1:0:", -- Copper Battle Axe
	[3489]=":937:2:2:1:::1:0:", -- Thick War Axe
	[3490]=":2731:2:2:1:::1:0:", -- Deadly Bronze Poniard
	[3491]=":2741:2:2:1:::1:0:", -- Heavy Bronze Mace
	[3492]=":4552:2:2:1:::1:0:", -- Mighty Iron Hammer
	[3493]=":3426:2:2:1:::1:0:", -- Raptor\'s End
	[3495]="::12:1:1:::1:0:", -- Elixir of Suffering
	[3496]="::12:1:20:::1:0:", -- Mountain Lion Blood
	[3497]="::12:1:1:::1:0:", -- Elixir of Pain
	[3498]="::12:1:1:::1:0:", -- Taretha\'s Necklace
	[3499]="::13:1:1:::1:0:", -- Burnished Gold Key
	[3502]="::12:1:20:::1:0:", -- Mudsnout Blossoms
	[3505]="::12:1:20:::1:0:", -- Alterac Signet Ring
	[3506]="::12:1:1:::1:0:", -- Mudsnout Composite
	[3508]="::12:1:1:::1:0:", -- Mudsnout Mixture
	[3509]="::12:1:20:::1:0:", -- Daggerspine Scale
	[3510]="::12:1:20:::1:0:", -- Torn Fin Eye
	[3511]=":214:4:2:1:::1:0:", -- Cloak of the People\'s Militia
	[3514]="::12:1:1:::1:0:", -- Mor\'Ladim\'s Skull
	[3515]="::12:1:1:::1:0:", -- Ataeric\'s Staff
	[3517]="::12:1:1:::1:0:", -- Keg of Shindigger Stout
	[3518]="::12:1:1:::1:0:", -- Decrypted Letter
	[3520]="::12:1:1:::1:0:", -- Tainted Keg
	[3521]="::12:1:1:::1:0:", -- Cleverly Encrypted Letter
	[3530]=":25:0:1:20:::1:0:", -- Wool Bandage
	[3531]=":57:0:1:20:::1:0:", -- Heavy Wool Bandage
	[3550]="::12:1:1:::1:0:", -- Targ\'s Head
	[3551]="::12:1:1:::1:0:", -- Muckrake\'s Head
	[3552]="::12:1:1:::1:0:", -- Glommus\'s Head
	[3553]="::12:1:1:::1:0:", -- Mug\'thol\'s Head
	[3554]="::12:1:1:::1:0:", -- Crown of Will
	[3555]=":1032:4:2:1:::1:0:", -- Robe of Solomon
	[3556]=":1285:4:2:1:::1:0:", -- Dread Mage Hat
	[3558]=":1044:4:2:1:::1:0:", -- Fen Keeper Robe
	[3559]=":473:4:2:1:::1:0:", -- Night Watch Gauntlets
	[3560]=":2102:4:2:1:::1:0:", -- Mantle of Honor
	[3561]=":895:4:2:1:::1:0:", -- Resilient Poncho
	[3562]=":823:4:2:1:::1:0:", -- Belt of Vindication
	[3563]=":557:4:2:1:::1:0:", -- Seafarer\'s Pantaloons
	[3564]="::12:1:1:::1:0:", -- Shipment of Iron
	[3565]=":280:4:2:1:::1:0:", -- Beerstained Gloves
	[3566]=":2023:4:2:1:::1:0:", -- Raptorbane Armor
	[3567]=":922:2:2:1:::1:0:", -- Dwarven Fishing Pole
	[3569]=":1262:4:2:1:::1:0:", -- Vicar\'s Robe
	[3570]=":839:2:2:1:::1:0:", -- Bonegrinding Pestle
	[3571]=":2118:2:2:1:::1:0:", -- Trogg Beater
	[3572]=":972:2:2:1:::1:0:", -- Daryl\'s Shortsword
	[3573]=":212:11:1:1:::1:0:", -- Hunting Quiver
	[3574]=":212:11:1:1:::1:0:", -- Hunting Ammo Sack
	[3575]=":200:7:1:20::171,164,202,755,186:1:0:", -- Iron Bar
	[3576]=":35:7:1:20::186:1:0:", -- Tin Bar
	[3577]=":600:7:2:20::164,202,755,197:1:0:", -- Gold Bar
	[3578]=":340:4:2:1:::1:0:", -- Harvester\'s Pants
	[3581]=":1046:2:2:1:::1:0:", -- Serrated Knife
	[3582]=":315:4:2:1:::1:0:", -- Acidproof Cloak
	[3583]=":57:4:1:1:::1:0:", -- Weathered Belt
	[3585]=":953:4:2:1:::1:0:", -- Camouflaged Tunic
	[3586]=":1034:2:2:1:::1:0:", -- Logsplitter
	[3587]="14314:2862:4:1:1:::1:0:1314,3315,11183,5129,4175,3092,984,3316,2849,5155,12023,5821,10293", -- Embroidered Belt
	[3588]="14366:2873:4:1:1:::1:0:1314,3315,11183,5129,4175,3092,984,3316,2849,5155,12023,5821,10293", -- Embroidered Bracers
	[3589]="577:115:4:1:1:::1:0:3317,4175,5108,1214,16716,5821,3683,4164,3092,16631,3952,8358,16623,1291,4185,3554,4558", -- Heavy Weave Belt
	[3590]="579:115:4:1:1:::1:0:3317,4175,5108,1214,16716,5821,3683,4164,3092,16631,3952,8358,16623,1291,4185,3554,4558", -- Heavy Weave Bracers
	[3591]="2097:419:4:1:1:::1:0:1314,3315,4188,4175,3092,3316,3952,2849,5821", -- Padded Belt
	[3592]="2104:420:4:1:1:::1:0:1314,3315,4188,4175,3092,3316,3952,2849,5821", -- Padded Bracers
	[3593]="5478:1095:4:1:1:::1:0:1314,3315,4175,3092,3316,8159,1407,2849,1147,5155,5821,10293", -- Russet Belt
	[3594]="5497:1099:4:1:1:::1:0:1314,3315,4175,3092,3316,8159,1407,2849,1147,5155,5821,10293", -- Russet Bracers
	[3595]="24:4:4:1:1:::1:0:4558,2113,3160", -- Tattered Cloth Belt
	[3596]="24:4:4:1:1:::1:0:4558,2113,3160", -- Tattered Cloth Bracers
	[3597]="1081:216:4:1:1:::1:0:3317,4188,4175,3092,1291,16623,3492,8358,16716,3952,2849,5155,5821", -- Thick Cloth Belt
	[3598]="1085:217:4:1:1:::1:0:3317,4188,4175,3092,1291,16623,3492,8358,16716,3952,2849,5155,5821", -- Thick Cloth Bracers
	[3599]="24:4:4:1:1:::1:0:1238,3590,190,4175,16918,836", -- Thin Cloth Belt
	[3600]="24:4:4:1:1:::1:0:1238,3590,190,4175,16918,836", -- Thin Cloth Bracers
	[3601]="::12:1:1:::1:0:", -- Syndicate Missive
	[3602]="145:29:4:1:1:::1:0:1238,4164,959,3530,3611,4175,3092,2264,1291,16716,3952,17929,74,5821", -- Knitted Belt
	[3603]="146:29:4:1:1:::1:0:1238,4164,959,3530,3611,4175,3092,2264,1291,16716,3952,17929,74,5821", -- Knitted Bracers
	[3604]=":500:11:2:1:::1:0:", -- Bandolier of the Night Watch
	[3605]=":500:11:2:1:::1:0:", -- Quiver of the Night Watch
	[3606]="147:29:4:1:1:::1:0:16186,3317,4558,3166,3522,16623", -- Woven Belt
	[3607]="148:29:4:1:1:::1:0:16186,3317,4558,3166,3522,16623", -- Woven Bracers
	[3608]=":500:9:2:1:::1:0:", -- Plans: Mighty Iron Hammer
	[3609]=":25:9:2:1:::1:0:", -- Plans: Copper Chain Vest
	[3610]=":50:9:2:1:::1:0:", -- Plans: Gemmed Copper Gauntlets
	[3611]=":500:9:2:1:::1:0:", -- Plans: Green Iron Boots
	[3612]=":500:9:2:1:::1:0:", -- Plans: Green Iron Gauntlets
	[3613]="::12:1:1:::1:0:", -- Valdred\'s Hands
	[3614]="::12:1:1:::1:0:", -- Yowler\'s Paw
	[3615]="::12:1:1:::1:0:", -- Kurzen\'s Head
	[3616]="::12:1:1:::1:0:", -- Mind\'s Eye
	[3617]="::12:1:1:::1:0:", -- Pendant of Shadow
	[3618]="::12:1:1:::1:0:", -- Gobbler\'s Head
	[3619]="::12:1:1:::1:0:", -- Snellig\'s Snuffbox
	[3621]="::12:1:1:::1:0:", -- Ivar\'s Head
	[3622]="::12:1:1:::1:0:", -- Essence of Nightlash
	[3623]="::12:1:1:::1:0:", -- Thule\'s Head
	[3625]="::12:1:1:::1:0:", -- Nek\'rosh\'s Head
	[3626]="::12:1:1:::1:0:", -- Head of Baron Vardus
	[3627]="::12:1:1:::1:0:", -- Fang of Vagash
	[3628]="::12:1:1:::1:0:", -- Hand of Dextren Ward
	[3629]="::12:1:1:::1:0:", -- Mistmantle Family Ring
	[3630]="::12:1:1:::1:0:", -- Head of Targorr
	[3631]="::12:1:1:::1:0:", -- Bellygrub\'s Tusk
	[3632]="::12:1:1:::1:0:", -- Fangore\'s Paw
	[3633]="::12:1:1:::1:0:", -- Head of Gath\'Ilzogg
	[3634]="::12:1:1:::1:0:", -- Head of Grimson
	[3635]="::12:1:1:::1:0:", -- Maggot Eye\'s Paw
	[3636]="::12:1:1:::1:0:", -- Scale of Old Murk-Eye
	[3637]="::12:1:1:::1:0:", -- Head of VanCleef
	[3638]="::12:1:1:::1:0:", -- Sarltooth\'s Talon
	[3639]="::12:1:1:::1:0:", -- Ear of Balgaras
	[3640]="::12:1:1:::1:0:", -- Head of Deepfury
	[3641]=":15:4:1:1:::1:0:", -- Journeyman\'s Bracers
	[3642]=":22:4:1:1:::1:0:", -- Ancestral Bracers
	[3643]=":71:4:1:1:::1:0:", -- Spellbinder Bracers
	[3644]=":47:4:1:1:::1:0:", -- Barbaric Cloth Bracers
	[3645]=":189:4:2:1:::1:0:", -- Seer\'s Cuffs
	[3647]=":434:4:2:1:::1:0:", -- Bright Bracers
	[3649]=":115:4:1:1:::1:0:", -- Tribal Buckler
	[3650]=":68:4:1:1:::1:0:", -- Battle Shield
	[3651]=":435:4:2:1:::1:0:", -- Veteran Shield
	[3652]=":364:4:2:1:::1:0:", -- Hunting Buckler
	[3653]=":438:4:2:1:::1:0:", -- Ceremonial Buckler
	[3654]=":367:4:2:1:::1:0:", -- Brackwater Shield
	[3655]=":1022:4:2:1:::1:0:", -- Burnished Shield
	[3656]=":2116:4:2:1:::1:0:", -- Lambent Scale Shield
	[3657]="::12:1:1:::1:0:", -- Hillsbrad Town Registry
	[3658]="::12:1:10:::1:0:", -- Recovered Tome
	[3659]="::12:1:1:::1:0:", -- Worn Leather Book
	[3660]="::12:1:1:::1:0:", -- Tomes of Alterac
	[3661]=":9:2:1:1:::1:0:", -- Handcrafted Staff
	[3662]=":25:0:1:20:::1:0:", -- Crocolisk Steak
	[3663]=":125:0:1:20:::1:0:", -- Murloc Fin Soup
	[3664]=":100:0:1:20:::1:0:", -- Crocolisk Gumbo
	[3665]=":150:0:1:20:::1:0:", -- Curiously Tasty Omelet
	[3666]=":100:0:1:20:::1:0:", -- Gooey Spider Cake
	[3667]=":25:7:1:10::185:1:0:", -- Tender Crocolisk Meat
	[3668]="::12:1:1:::1:0:", -- Assassin\'s Contract
	[3669]=":195:15:0:5:::1:0:", -- Gelatinous Goo
	[3670]=":70:15:0:5:::1:0:", -- Large Slimy Bone
	[3671]=":201:15:0:5:::1:0:", -- Lifeless Skull
	[3672]="::12:1:1:::1:0:", -- Head of Nagaz
	[3673]=":45:15:0:100:::1:0:", -- Broken Arrow
	[3674]=":95:15:0:5:::1:0:", -- Decomposed Boot
	[3676]=":106:15:0:10:::1:0:", -- Slimy Ichor
	[3678]="400:100:9:1:1:::1:0:340", -- Recipe: Crocolisk Steak
	[3679]="400:100:9:1:1:::1:0:340", -- Recipe: Blood Sausage
	[3680]="1600:400:9:1:1:::1:0:340", -- Recipe: Murloc Fin Soup
	[3681]="1600:400:9:1:1:::1:0:340", -- Recipe: Crocolisk Gumbo
	[3682]="1600:400:9:1:1:::1:0:2821,1148,340", -- Recipe: Curiously Tasty Omelet
	[3683]="1600:400:9:1:1:::1:0:340", -- Recipe: Gooey Spider Cake
	[3684]="::12:1:1:::1:0:", -- Perenolde Tiara
	[3685]=":71:7:1:10::185:1:0:", -- Raptor Egg
	[3688]="::12:1:1:::1:0:", -- Bloodstone Oval
	[3689]="::12:1:1:::1:0:", -- Bloodstone Marble
	[3690]="::12:1:1:::1:0:", -- Bloodstone Shard
	[3691]="::12:1:1:::1:0:", -- Bloodstone Wedge
	[3692]="::12:1:30:::1:0:", -- Hillsbrad Human Skull
	[3693]="::12:1:1:::1:0:", -- Humbert\'s Sword
	[3701]="::12:1:1:::1:0:", -- Darthalia\'s Sealed Commendation
	[3702]=":498:15:0:10:::1:0:", -- Bear Gall Bladder
	[3703]="145:36:0:1:10:::1:0:20377,2388", -- Southshore Stout
	[3704]="::13:1:1:::1:0:", -- Rusted Iron Key
	[3706]="::12:1:1:::1:0:", -- Ensorcelled Parchment
	[3708]="::12:1:1:::1:0:", -- Helcular\'s Rod
	[3710]="::12:1:1:::1:0:", -- Rod of Helcular
	[3711]="::12:1:1:::1:0:", -- Belamoore\'s Research Journal
	[3712]=":87:7:1:10::185:1:0:", -- Turtle Meat
	[3713]="160:40:7:1:20::185:1:0:8307,16768,26744,26751,7947,24843,4775,24993,26765,2397,18993,3955,4553,25012,17246,25082,17486,4897,25020,20092,3954,2821,16253,20194,19015,14738,26747,4877,12022,9636,19195,19497,26753,26742,25051,16602,19450,16826,19017,15179,5135,12245,3400,21083,12958,16613,16718,19562,26724,26749,1286,26755,19573,26738,16677,1148,2381,24834,25052,22099,6301,3027,19197,12028,19372,20028,18987,25034,19533,5163,26758,1456,8363,4223,20096,18009,960,26752,26754,20891,25010,2225,26743,4561,19371,8934,26756,11189,18907,2664,26759,989,20250,22271,3779,3085,20097,12941,26739,26741,25089,12957,5483,12033,5160,26748,20081,4265,2810,19345,24995,4229,26757,26745,19042,19194,18015,18960,5100,8145,2393,19244,24935,21113,3367,26740,5817,25019", -- Soothing Spices
	[3714]="::12:1:20:::1:0:", -- Worn Stone Token
	[3715]="::12:1:20:::1:0:", -- Bracers of Earth Binding
	[3716]="::12:1:20:::1:0:", -- Murloc Head
	[3717]="::12:1:1:::1:0:", -- Sack of Murloc Heads
	[3718]="::12:1:1:::1:0:", -- Foreboding Plans
	[3719]=":822:4:1:1:::1:0:", -- Hillman\'s Cloak
	[3720]="::12:1:20:::1:0:", -- Yeti Fur
	[3721]="::12:1:1:::1:0:", -- Farren\'s Report
	[3722]=":213:15:0:5:::1:0:", -- Familiar Hide
	[3723]=":68:15:0:5:::1:0:", -- Familiar Fang
	[3724]=":81:15:0:5:::1:0:", -- Familiar Claw
	[3725]=":166:15:0:5:::1:0:", -- Familiar Horn
	[3726]=":125:0:1:20:::1:0:", -- Big Bear Steak
	[3727]=":125:0:1:20:::1:0:", -- Hot Lion Chops
	[3728]=":300:0:1:20:::1:0:", -- Tasty Lion Steak
	[3729]=":300:0:1:20:::1:0:", -- Soothing Turtle Bisque
	[3730]=":45:7:1:10::185:1:0:", -- Big Bear Meat
	[3731]=":55:7:1:10::185:1:0:", -- Lion Meat
	[3732]=":801:4:1:1:::1:0:", -- Hooded Cowl
	[3733]=":1269:4:2:1:::1:0:", -- Orcish War Chain
	[3734]="1600:400:9:1:1:::1:0:12246,3960", -- Recipe: Big Bear Steak
	[3735]="1800:450:9:1:1:::1:0:3489,12245", -- Recipe: Hot Lion Chops
	[3736]=":500:9:1:1:::1:0:", -- Recipe: Tasty Lion Steak
	[3737]=":550:9:1:1:::1:0:", -- Recipe: Soothing Turtle Bisque
	[3739]=":1250:4:2:1:::1:0:", -- Skull Ring
	[3740]=":2452:2:2:1:::1:0:", -- Decapitating Sword
	[3741]=":923:4:2:1:::1:0:", -- Stomping Boots
	[3742]=":2862:2:2:1:::1:0:", -- Bow of Plunder
	[3743]=":2451:4:2:1:::1:0:", -- Sentry Buckler
	[3745]="::12:1:20:::1:0:", -- Rune of Opening
	[3747]=":1092:4:2:1:::1:0:", -- Meditative Sash
	[3748]=":1305:4:3:1:::1:0:", -- Feline Mantle
	[3749]=":1320:4:2:1:::1:0:", -- High Apothecary Cloak
	[3750]=":2209:4:2:1:::1:0:", -- Ribbed Breastplate
	[3751]=":2661:4:2:1:::1:0:", -- Mercenary Leggings
	[3752]=":746:4:2:1:::1:0:", -- Grunt Vest
	[3753]=":1635:4:2:1:::1:0:", -- Shepherd\'s Girdle
	[3754]=":1492:4:2:1:::1:0:", -- Shepherd\'s Gloves
	[3755]=":5447:2:2:1:::1:0:", -- Fish Gutter
	[3758]=":1817:4:2:1:::1:0:", -- Crusader Belt
	[3759]=":1216:4:2:1:::1:0:", -- Insulated Sage Gloves
	[3760]=":1500:4:2:1:::1:0:", -- Band of the Undercity
	[3761]=":3306:4:2:1:::1:0:", -- Deadskull Shield
	[3763]=":6761:4:2:1:::1:0:", -- Lunar Buckler
	[3764]=":3181:4:2:1:::1:0:", -- Mantis Boots
	[3765]=":4811:4:2:1:::1:0:", -- Brigand\'s Pauldrons
	[3766]=":30:15:0:10:::1:0:", -- Gryphon Feather Quill
	[3767]=":23:15:0:5:::1:0:", -- Fine Parchment
	[3769]=":13:15:0:5:::1:0:", -- Broken Wand
	[3770]="500:25:0:1:20:::5:0:3025,3705,15397,4954,7731,4875,11187,3881,3960,11118,2388,3489,23263,10367,3411,6928,5124,17630,982,4891,2814,8125,5870,16618,15174,4255,17553,14964,12959,5620,6929,12097,15125,5611,23481,3621,4894,5111,4782,12096,14624,9356,3933,3935,3312,24208,16443,7733,4169,14963,23605,7485,12196,4879,17656,2365,16739,4084,15124,1464,3368,3882,19182,3089", -- Mutton Chop
	[3771]="1000:50:0:1:20:::5:0:3025,3705,15397,4954,7731,4875,11187,3881,3960,11118,2388,3489,23263,10367,3411,6928,5124,17630,982,4891,2814,8125,5870,16618,15174,4255,17553,14964,12959,5620,6929,12097,15125,5611,23481,3621,4894,5111,4782,12096,14624,9356,3933,3935,3312,24208,16443,7733,4169,14963,23605,7485,12196,4879,17656,2365,16739,4084,15124,1464,3368,3882,19182,3089", -- Wild Hog Shank
	[3772]="::0:1:20:::1:0:", -- Conjured Spring Water
	[3775]=":13:0:1:20:::1:0:", -- Crippling Poison
	[3776]="700:175:0:1:20:::1:0:23405,26304,23151,17078", -- Crippling Poison II
	[3777]="40:10:15:1:20:::1:0:19239,16829,2622,20986,20915,1325,5169,3561,16683,3490,20081,5139,16588,4585,16268,19679,23373,19013,19049,20121,3334,10364,12097,3969,25633,18019,6779,22479,23145,1457,3090,25043,12096,1326,3135,15175,20194,18802,3551,18006,19014,3542", -- Lethargy Root
	[3778]=":1541:2:0:1:::1:0:", -- Taut Compound Bow
	[3779]=":2835:2:0:1:::1:0:", -- Hefty War Axe
	[3780]=":1877:2:0:1:::1:0:", -- Long-barreled Musket
	[3781]=":3125:2:0:1:::1:0:", -- Broad Claymore
	[3782]=":3451:2:0:1:::1:0:", -- Large War Club
	[3783]=":3048:2:0:1:::1:0:", -- Light Scimitar
	[3784]=":4208:2:0:1:::1:0:", -- Metal Stave
	[3785]=":3650:2:0:1:::1:0:", -- Keen Axe
	[3786]=":3957:2:0:1:::1:0:", -- Shiny Dirk
	[3787]=":4289:2:0:1:::1:0:", -- Stone Club
	[3792]=":521:4:0:1:::1:0:", -- Interlaced Belt
	[3793]=":648:4:0:1:::1:0:", -- Interlaced Boots
	[3794]=":775:4:0:1:::1:0:", -- Interlaced Bracers
	[3795]=":982:4:0:1:::1:0:", -- Interlaced Cloak
	[3796]=":493:4:0:1:::1:0:", -- Interlaced Gloves
	[3797]=":1692:4:0:1:::1:0:", -- Interlaced Pants
	[3798]=":902:4:0:1:::1:0:", -- Interlaced Shoulderpads
	[3799]=":1461:4:0:1:::1:0:", -- Interlaced Vest
	[3800]=":1068:4:0:1:::1:0:", -- Hardened Leather Belt
	[3801]=":1031:4:0:1:::1:0:", -- Hardened Leather Boots
	[3802]=":627:4:0:1:::1:0:", -- Hardened Leather Bracers
	[3803]=":1086:4:0:1:::1:0:", -- Hardened Cloak
	[3804]=":765:4:0:1:::1:0:", -- Hardened Leather Gloves
	[3805]=":1049:4:0:1:::1:0:", -- Hardened Leather Pants
	[3806]=":1272:4:0:1:::1:0:", -- Hardened Leather Shoulderpads
	[3807]=":1162:4:0:1:::1:0:", -- Hardened Leather Tunic
	[3808]=":770:4:0:1:::1:0:", -- Double Mail Belt
	[3809]=":962:4:0:1:::1:0:", -- Double Mail Boots
	[3810]=":1145:4:0:1:::1:0:", -- Double Mail Bracers
	[3811]=":1064:4:0:1:::1:0:", -- Double-stitched Cloak
	[3812]=":971:4:0:1:::1:0:", -- Double Mail Gloves
	[3813]=":1772:4:0:1:::1:0:", -- Double Mail Pants
	[3814]=":1891:4:0:1:::1:0:", -- Double Mail Shoulderpads
	[3815]=":1475:4:0:1:::1:0:", -- Double Mail Vest
	[3816]=":2102:4:0:1:::1:0:", -- Reflective Heater
	[3817]=":1585:4:0:1:::1:0:", -- Reinforced Buckler
	[3818]=":125:7:1:20::171:1:0:", -- Fadeleaf
	[3819]=":100:7:1:20::171,333:1:0:", -- Wintersbite
	[3820]=":100:7:1:20::171:1:0:", -- Stranglekelp
	[3821]=":150:7:1:20::171,185:1:0:", -- Goldthorn
	[3822]=":6481:2:2:1:::1:0:", -- Runic Darkblade
	[3823]=":100:0:1:5::164:1:0:", -- Lesser Invisibility Potion
	[3824]=":150:0:1:5::171,164,755,165,197:1:0:", -- Shadow Oil
	[3825]=":110:0:1:20:::1:0:", -- Elixir of Fortitude
	[3826]=":105:0:1:20:::1:0:", -- Mighty Troll\'s Blood Potion
	[3827]="480:120:0:1:5::755,197:1:0:2380,2848,12245,2480,2812,4899", -- Mana Potion
	[3828]=":150:0:1:20:::1:0:", -- Elixir of Detect Lesser Invisibility
	[3829]=":150:0:1:5::164,333,202,197:1:0:", -- Frost Oil
	[3830]=":500:9:1:1:::1:0:", -- Recipe: Elixir of Fortitude
	[3831]=":550:9:1:1:::1:0:", -- Recipe: Mighty Troll\'s Blood Potion
	[3832]=":550:9:2:1:::1:0:", -- Recipe: Elixir of Detect Lesser Invisibility
	[3833]=":24:4:1:1:::1:0:", -- Adept\'s Cloak
	[3834]=":32:4:1:1:::1:0:", -- Sturdy Cloth Trousers
	[3835]=":1106:4:1:1:::1:0:", -- Green Iron Bracers
	[3836]=":3053:4:2:1:::1:0:", -- Green Iron Helm
	[3837]=":4405:4:2:1:::1:0:", -- Golden Scale Coif
	[3838]="::12:1:20:::1:0:", -- Shadowmaw Claw
	[3839]="::12:1:1:::1:0:", -- Pristine Tigress Fang
	[3840]=":2571:4:2:1:::1:0:", -- Green Iron Shoulders
	[3841]=":3106:4:2:1:::1:0:", -- Golden Scale Shoulders
	[3842]=":2906:4:2:1:::1:0:", -- Green Iron Leggings
	[3843]=":3882:4:2:1:::1:0:", -- Golden Scale Leggings
	[3844]=":5658:4:3:1:::1:0:", -- Green Iron Hauberk
	[3845]=":6558:4:2:1:::1:0:", -- Golden Scale Cuirass
	[3846]=":3937:4:2:1:::1:0:", -- Polished Steel Boots
	[3847]=":4977:4:2:1:::1:0:", -- Golden Scale Boots
	[3848]=":1426:2:2:1:::1:0:", -- Big Bronze Knife
	[3849]=":5468:2:2:1:::1:0:", -- Hardened Iron Shortsword
	[3850]=":7304:2:2:1:::1:0:", -- Jade Serpentblade
	[3851]=":6258:2:2:1:::1:0:", -- Solid Iron Maul
	[3852]=":8361:2:2:1:::1:0:", -- Golden Iron Destroyer
	[3853]=":10153:2:2:1:::1:0:", -- Moonsteel Broadsword
	[3854]=":14120:2:2:1:::1:0:", -- Frost Tiger Blade
	[3855]=":11248:2:2:1:::1:0:", -- Massive Iron Axe
	[3856]=":14221:2:2:1:::1:0:", -- Shadow Crescent Axe
	[3857]="500:125:7:1:10::186:1:0:16768,26744,8161,26751,7947,5512,24843,4775,26765,25634,16823,22476,3955,19056,22264,19879,3133,3343,16751,25082,17486,4897,3954,2821,20082,17245,17655,26747,4877,2847,12022,4599,9636,2999,19012,26753,26742,25051,19450,15179,20981,4256,5135,12245,19342,19011,12958,19520,16613,23144,2844,15176,5514,26724,26749,4259,14624,1286,26755,26738,1148,790,15400,2381,16376,23724,3002,6301,12028,19372,11186,5163,19530,26758,1456,8363,16664,18009,960,26752,26754,25010,2225,26743,4561,4597,8934,26756,6300,11189,20463,16583,26759,989,14737,3779,16670,12941,16713,26739,26741,21209,12957,8176,19662,26748,2810,1690,3167,4257,6298,24995,4229,26757,26745,28344,9179,372,3358,3356,5411,5100,8145,2393,19244,3477,24935,3367,26740,3578,5817,25019", -- Coal
	[3858]=":250:7:1:20::171,186:1:0:", -- Mithril Ore
	[3859]=":60:7:1:20::164,202:1:0:", -- Steel Bar
	[3860]=":400:7:1:20::171,164,202,755:1:0:", -- Mithril Bar
	[3862]="::12:1:1:::1:0:", -- Aged Gorilla Sinew
	[3863]="::12:1:20:::1:0:", -- Jungle Stalker Feather
	[3864]=":800:3:2:20::164,202,755,165,197:1:0:", -- Citrine
	[3866]=":1000:9:2:1:::1:0:", -- Plans: Jade Serpentblade
	[3867]=":950:9:2:1:::1:0:", -- Plans: Golden Iron Destroyer
	[3868]=":1250:9:2:1:::1:0:", -- Plans: Frost Tiger Blade
	[3869]=":1250:9:2:1:::1:0:", -- Plans: Shadow Crescent Axe
	[3870]=":750:9:2:1:::1:0:", -- Plans: Green Iron Shoulders
	[3871]=":850:9:3:1:::1:0:", -- Plans: Golden Scale Shoulders
	[3872]=":800:9:2:1:::1:0:", -- Plans: Golden Scale Leggings
	[3873]=":1100:9:2:1:::1:0:", -- Plans: Golden Scale Cuirass
	[3874]=":1100:9:2:1:::1:0:", -- Plans: Polished Steel Boots
	[3875]=":1250:9:3:1:::1:0:", -- Plans: Golden Scale Boots
	[3876]="::12:1:1:::1:0:", -- Fang of Bhag\'thera
	[3877]="::12:1:1:::1:0:", -- Talon of Tethis
	[3879]="::12:1:1:::1:0:", -- Paw of Sin\'Dall
	[3880]="::12:1:1:::1:0:", -- Head of Bangalash
	[3882]=":13:15:0:10:::1:0:", -- Buzzard Feather
	[3889]="7923:1584:4:1:1:::1:0:1314,1310,3315,4175,3092,3316,8159,1407,2849,1147,5155,5821,10293", -- Russet Hat
	[3890]="10201:2040:4:1:1:::1:0:1314,4236,1310,3315,1320,5129,3316,8159,1407,1147,5820", -- Studded Hat
	[3891]="12285:2457:4:1:1:::1:0:5819,8129,1310,1323,5812,5125,1349,1322,4177,2845,3095,1381", -- Augmented Chain Helm
	[3892]="21940:4388:4:1:1:::1:0:1314,1310,3315,11183,5129,4175,3092,984,3316,2849,5155,12023,5821,10293", -- Embroidered Hat
	[3893]="27523:5504:4:1:1:::1:0:1314,4236,1310,3315,11183,1320,5129,984,3316,12023,5820", -- Reinforced Leather Cap
	[3894]="29986:5997:4:1:1:::1:0:5819,8129,1310,1323,5812,5508,1349,4177,3095,980,16626,5126,11182,16753", -- Brigandine Helm
	[3897]="::12:1:1:::1:0:", -- Dizzy\'s Eye
	[3898]="::12:1:1:::1:0:", -- Library Scrip
	[3899]=":25:15:0:1:::1:0:", -- Legends of the Gurubashi, Volume 3
	[3900]="::12:1:20:::1:0:", -- Pupellyverbos Port
	[3901]="::12:1:20:::1:0:", -- Bloodscalp Tusk
	[3902]=":1317:2:2:1:::1:0:", -- Staff of Nobles
	[3904]="::12:1:1:::1:0:", -- Gan\'zulah\'s Head
	[3905]="::12:1:1:::1:0:", -- Nezzliok\'s Head
	[3906]="::12:1:20:::1:0:", -- Balia\'mah Trophy
	[3907]="::12:1:20:::1:0:", -- Ziata\'jai Trophy
	[3908]="::12:1:20:::1:0:", -- Zul\'Mamwe Trophy
	[3909]="::12:1:1:::1:0:", -- Broken Armor of Ana\'thek
	[3910]="::12:1:20:::1:0:", -- Snuff
	[3911]="::12:1:20:::1:0:", -- Pulsing Blue Shard
	[3912]="::12:1:1:::1:0:", -- Soul Gem
	[3913]="::12:1:1:::1:0:", -- Filled Soul Gem
	[3914]=":6250:1:1:1:::1:0:", -- Journeyman\'s Backpack
	[3915]="::12:1:25:::1:0:", -- Bloody Bone Necklace
	[3916]="::12:1:25:::1:0:", -- Split Bone Necklace
	[3917]="::12:1:20:::1:0:", -- Singing Blue Crystal
	[3918]="::12:1:20:::1:0:", -- Singing Crystal Shard
	[3919]="::12:1:20:::1:0:", -- Mistvale Giblets
	[3920]="::12:1:1:::1:0:", -- Bloodsail Charts
	[3921]="::12:1:1:::1:0:", -- Bloodsail Orders
	[3922]="::12:1:1:::1:0:", -- Shaky\'s Payment
	[3923]="::12:1:20:::1:0:", -- Water Elemental Bracers
	[3924]="::12:1:1:::1:0:", -- Maury\'s Clubbed Foot
	[3925]="::12:1:1:::1:0:", -- Jon-Jon\'s Golden Spyglass
	[3926]="::12:1:1:::1:0:", -- Chucky\'s Huge Ring
	[3927]="2000:150:0:1:20:::5:0:4255,6746,4981,483,5620,2352,4894,23604,4782,23521,3546,24934,18929,6790,10367,1237,465,17630,2364,4891,295,3298,6930,9501,11106,16553,11116", -- Fine Aged Cheddar
	[3928]="1000:250:0:1:5:::1:0:14847,18908,18905,8177,8158,983,8178,8157,11188", -- Superior Healing Potion
	[3930]="::13:1:1:::1:0:", -- Maury\'s Key
	[3931]=":185:15:0:5:::1:0:", -- Poisoned Spider Fang
	[3932]="::12:1:1:::1:0:", -- Smotts\' Chest
	[3935]="::2:1:1:::1:0:", -- Smotts\' Cutlass
	[3936]=":985:4:0:1:::1:0:", -- Crochet Belt
	[3937]=":2018:4:0:1:::1:0:", -- Crochet Boots
	[3938]=":1189:4:0:1:::1:0:", -- Crochet Bracers
	[3939]=":2256:4:0:1:::1:0:", -- Crochet Cloak
	[3940]=":1630:4:0:1:::1:0:", -- Crochet Gloves
	[3941]=":2598:4:0:1:::1:0:", -- Crochet Pants
	[3942]=":2636:4:0:1:::1:0:", -- Crochet Shoulderpads
	[3943]=":2244:4:0:1:::1:0:", -- Crochet Vest
	[3944]=":2277:4:0:1:::1:0:", -- Twill Belt
	[3945]=":3852:4:0:1:::1:0:", -- Twill Boots
	[3946]=":2432:4:0:1:::1:0:", -- Twill Bracers
	[3947]=":3258:4:0:1:::1:0:", -- Twill Cloak
	[3948]=":3092:4:0:1:::1:0:", -- Twill Gloves
	[3949]=":6517:4:0:1:::1:0:", -- Twill Pants
	[3950]=":4157:4:0:1:::1:0:", -- Twill Shoulderpads
	[3951]=":5897:4:0:1:::1:0:", -- Twill Vest
	[3960]="::12:1:1:::1:0:", -- Bag of Water Elemental Bracers
	[3961]=":1503:4:0:1:::1:0:", -- Thick Leather Belt
	[3962]=":3080:4:0:1:::1:0:", -- Thick Leather Boots
	[3963]=":1402:4:0:1:::1:0:", -- Thick Leather Bracers
	[3964]=":2127:4:0:1:::1:0:", -- Thick Cloak
	[3965]=":2221:4:0:1:::1:0:", -- Thick Leather Gloves
	[3966]=":2625:4:0:1:::1:0:", -- Thick Leather Pants
	[3967]=":2904:4:0:1:::1:0:", -- Thick Leather Shoulderpads
	[3968]=":3331:4:0:1:::1:0:", -- Thick Leather Tunic
	[3969]=":3256:4:0:1:::1:0:", -- Smooth Leather Belt
	[3970]=":4296:4:0:1:::1:0:", -- Smooth Leather Boots
	[3971]=":3811:4:0:1:::1:0:", -- Smooth Leather Bracers
	[3972]=":3891:4:0:1:::1:0:", -- Smooth Cloak
	[3973]=":3657:4:0:1:::1:0:", -- Smooth Leather Gloves
	[3974]=":5487:4:0:1:::1:0:", -- Smooth Leather Pants
	[3975]=":3896:4:0:1:::1:0:", -- Smooth Leather Shoulderpads
	[3976]=":6979:4:0:1:::1:0:", -- Smooth Leather Armor
	[3985]="::4:2:1:::1:0:", -- Monogrammed Sash
	[3986]=":5332:4:0:1:::1:0:", -- Protective Pavise
	[3987]=":6837:4:0:1:::1:0:", -- Deflecting Tower
	[3989]=":3154:4:0:1:::1:0:", -- Blocking Targe
	[3990]=":8237:4:0:1:::1:0:", -- Crested Buckler
	[3992]=":3082:4:0:1:::1:0:", -- Laminated Scale Belt
	[3993]=":4940:4:0:1:::1:0:", -- Laminated Scale Boots
	[3994]=":4404:4:0:1:::1:0:", -- Laminated Scale Bracers
	[3995]=":4171:4:0:1:::1:0:", -- Laminated Scale Cloak
	[3996]=":4660:4:0:1:::1:0:", -- Laminated Scale Gloves
	[3997]=":7929:4:0:1:::1:0:", -- Laminated Scale Pants
	[3998]=":5656:4:0:1:::1:0:", -- Laminated Scale Shoulderpads
	[3999]=":7109:4:0:1:::1:0:", -- Laminated Scale Armor
	[4000]=":1797:4:0:1:::1:0:", -- Overlinked Chain Belt
	[4001]=":3170:4:0:1:::1:0:", -- Overlinked Chain Boots
	[4002]=":2463:4:0:1:::1:0:", -- Overlinked Chain Bracers
	[4003]=":2714:4:0:1:::1:0:", -- Overlinked Chain Cloak
	[4004]=":2357:4:0:1:::1:0:", -- Overlinked Chain Gloves
	[4005]=":3478:4:0:1:::1:0:", -- Overlinked Chain Pants
	[4006]=":2434:4:0:1:::1:0:", -- Overlinked Chain Shoulderpads
	[4007]=":3696:4:0:1:::1:0:", -- Overlinked Chain Armor
	[4016]="::12:1:20:::1:0:", -- Zanzil\'s Mixture
	[4017]=":6910:2:0:1:::1:0:", -- Sharp Shortsword
	[4018]=":6372:2:0:1:::1:0:", -- Whetted Claymore
	[4019]=":8336:2:0:1:::1:0:", -- Heavy Flint Axe
	[4020]=":11189:2:0:1:::1:0:", -- Splintering Battle Axe
	[4021]=":7198:2:0:1:::1:0:", -- Blunting Mace
	[4022]=":12059:2:0:1:::1:0:", -- Crushing Maul
	[4023]=":6216:2:0:1:::1:0:", -- Fine Pointed Dagger
	[4024]=":9822:2:0:1:::1:0:", -- Heavy War Staff
	[4025]=":5070:2:0:1:::1:0:", -- Balanced Long Bow
	[4026]=":4362:2:0:1:::1:0:", -- Sentinel Musket
	[4027]="::12:1:1:::1:0:", -- Catelyn\'s Blade
	[4028]="::12:1:1:::1:0:", -- Bundle of Akiris Reeds
	[4029]="::12:1:20:::1:0:", -- Akiris Reed
	[4034]="::12:1:1:::1:0:", -- Stone of the Tides
	[4035]=":1989:4:2:1:::1:0:", -- Silver-thread Robe
	[4036]=":681:4:2:1:::1:0:", -- Silver-thread Cuffs
	[4037]=":1821:4:2:1:::1:0:", -- Silver-thread Pants
	[4038]=":3562:4:2:1:::1:0:", -- Nightsky Robe
	[4039]=":2215:4:2:1:::1:0:", -- Nightsky Cowl
	[4040]=":1347:4:2:1:::1:0:", -- Nightsky Gloves
	[4041]=":3149:4:2:1:::1:0:", -- Aurora Cowl
	[4042]=":2107:4:2:1:::1:0:", -- Aurora Gloves
	[4043]=":1958:4:2:1:::1:0:", -- Aurora Bracers
	[4044]=":4584:4:2:1:::1:0:", -- Aurora Pants
	[4045]=":2683:4:2:1:::1:0:", -- Mistscape Bracers
	[4046]=":6783:4:2:1:::1:0:", -- Mistscape Pants
	[4047]=":3959:4:2:1:::1:0:", -- Mistscape Boots
	[4048]=":1767:4:2:1:::1:0:", -- Emblazoned Hat
	[4049]=":888:4:2:1:::1:0:", -- Emblazoned Bracers
	[4050]=":2375:4:2:1:::1:0:", -- Emblazoned Leggings
	[4051]=":1670:4:2:1:::1:0:", -- Emblazoned Boots
	[4052]=":2699:4:2:1:::1:0:", -- Insignia Cap
	[4053]="::12:1:20:::1:0:", -- Large River Crocolisk Skin
	[4054]=":3626:4:2:1:::1:0:", -- Insignia Leggings
	[4055]=":2481:4:2:1:::1:0:", -- Insignia Boots
	[4056]="::12:1:1:::1:0:", -- Cortello\'s Riddle
	[4057]=":4032:4:2:1:::1:0:", -- Insignia Chestguard
	[4058]=":6056:4:2:1:::1:0:", -- Glyphed Breastplate
	[4059]=":2234:4:2:1:::1:0:", -- Glyphed Bracers
	[4060]=":5648:4:2:1:::1:0:", -- Glyphed Leggings
	[4061]=":3306:4:2:1:::1:0:", -- Imperial Leather Bracers
	[4062]=":8359:4:2:1:::1:0:", -- Imperial Leather Pants
	[4063]=":3596:4:2:1:::1:0:", -- Imperial Leather Gloves
	[4064]=":2987:4:2:1:::1:0:", -- Emblazoned Buckler
	[4065]=":5311:4:2:1:::1:0:", -- Combat Shield
	[4066]=":4845:4:2:1:::1:0:", -- Insignia Buckler
	[4067]=":6381:4:2:1:::1:0:", -- Glyphed Buckler
	[4068]=":6918:4:2:1:::1:0:", -- Chief Brigadier Shield
	[4069]=":11900:4:2:1:::1:0:", -- Blackforge Buckler
	[4070]=":7527:4:2:1:::1:0:", -- Jouster\'s Crest
	[4071]=":2939:4:2:1:::1:0:", -- Glimmering Mail Breastplate
	[4072]=":1340:4:2:1:::1:0:", -- Glimmering Mail Gauntlets
	[4073]=":2230:4:2:1:::1:0:", -- Glimmering Mail Greaves
	[4074]=":4785:4:2:1:::1:0:", -- Mail Combat Armor
	[4075]=":1984:4:2:1:::1:0:", -- Mail Combat Gauntlets
	[4076]=":3301:4:2:1:::1:0:", -- Mail Combat Boots
	[4077]=":3298:4:2:1:::1:0:", -- Mail Combat Headguard
	[4078]=":4672:4:2:1:::1:0:", -- Chief Brigadier Coif
	[4079]=":6753:4:2:1:::1:0:", -- Chief Brigadier Leggings
	[4080]=":7469:4:2:1:::1:0:", -- Blackforge Cowl
	[4082]=":11699:4:2:1:::1:0:", -- Blackforge Breastplate
	[4083]=":4328:4:2:1:::1:0:", -- Blackforge Gauntlets
	[4084]=":10136:4:2:1:::1:0:", -- Blackforge Leggings
	[4085]="::12:1:1:::1:0:", -- Krazek\'s Crock Pot
	[4086]=":6386:2:2:1:::1:0:", -- Flash Rifle
	[4087]=":8722:2:2:1:::1:0:", -- Trueshot Bow
	[4088]=":18523:2:2:1:::1:0:", -- Dreadblade
	[4089]=":15060:2:2:1:::1:0:", -- Ricochet Blunderbuss
	[4090]=":20736:2:3:1:::1:0:", -- Mug O\' Hurt
	[4091]=":22479:2:3:1:::1:0:", -- Widowmaker
	[4092]=":1296:15:0:5:::1:0:", -- Prismatic Basilisk Scale
	[4093]=":713:15:0:5:::1:0:", -- Large Basilisk Tail
	[4094]="::12:1:1:::1:0:", -- Tablet Shard
	[4096]=":608:15:1:10::165:1:0:", -- Coarse Gorilla Hair
	[4097]=":305:15:0:10:::1:0:", -- Chipped Gorilla Tooth
	[4098]="::12:1:1:::1:0:", -- Carefully Folded Note
	[4099]=":1131:15:0:5:::1:0:", -- Tuft of Gorilla Hair
	[4100]=":23:15:0:10:::1:0:", -- Crumpled Note
	[4101]=":26:15:0:10:::1:0:", -- Ripped Note
	[4102]=":33:15:0:10:::1:0:", -- Torn Note
	[4103]="::13:1:1:::1:0:", -- Shackle Key
	[4104]="::12:1:20:::1:0:", -- Snapjaw Crocolisk Skin
	[4105]="::12:1:20:::1:0:", -- Elder Crocolisk Skin
	[4106]="::12:1:20:::1:0:", -- Tumbled Crystal
	[4107]=":2136:4:2:1:::1:0:", -- Tiger Hunter Gloves
	[4108]=":5403:4:2:1:::1:0:", -- Panther Hunter Leggings
	[4109]=":4393:4:2:1:::1:0:", -- Excelsior Boots
	[4110]=":11999:2:2:1:::1:0:", -- Master Hunter\'s Bow
	[4111]=":12043:2:2:1:::1:0:", -- Master Hunter\'s Rifle
	[4112]=":4182:4:2:1:::1:0:", -- Choker of the High Shaman
	[4113]=":4853:4:2:1:::1:0:", -- Medicine Blanket
	[4114]=":3866:4:2:1:::1:0:", -- Darktide Cape
	[4115]=":5783:4:2:1:::1:0:", -- Grom\'gol Buckler
	[4116]=":12337:2:2:1:::1:0:", -- Olmann Sewar
	[4117]=":3119:4:2:1:::1:0:", -- Scorching Sash
	[4118]=":7313:4:2:1:::1:0:", -- Poobah\'s Nose Ring
	[4119]=":7271:4:2:1:::1:0:", -- Raptor Hunter Tunic
	[4120]=":5031:4:3:1:::1:0:", -- Robe of Crystal Waters
	[4121]=":1380:4:2:1:::1:0:", -- Gemmed Gloves
	[4122]=":8384:2:2:1:::1:0:", -- Bookmaker\'s Scepter
	[4123]=":3804:4:2:1:::1:0:", -- Frost Metal Pauldrons
	[4124]=":3991:4:2:1:::1:0:", -- Cap of Harmony
	[4125]=":3142:4:2:1:::1:0:", -- Tranquil Orb
	[4126]=":6396:2:2:1:::1:0:", -- Guerrilla Cleaver
	[4127]=":8073:2:2:1:::1:0:", -- Shrapnel Blaster
	[4128]=":14588:2:2:1:::1:0:", -- Silver Spade
	[4129]=":9444:4:2:1:::1:0:", -- Collection Plate
	[4130]=":2171:4:2:1:::1:0:", -- Smotts\' Compass
	[4131]=":3815:4:2:1:::1:0:", -- Belt of Corruption
	[4132]=":2681:4:2:1:::1:0:", -- Darkspear Armsplints
	[4133]=":1794:4:2:1:::1:0:", -- Darkspear Cuffs
	[4134]=":26994:2:3:1:::1:0:", -- Nimboya\'s Mystical Staff
	[4135]=":1130:4:2:1:::1:0:", -- Bloodbone Band
	[4136]=":6022:4:2:1:::1:0:", -- Darkspear Boots
	[4137]=":4010:4:2:1:::1:0:", -- Darkspear Shoes
	[4138]=":10140:4:2:1:::1:0:", -- Blackwater Tunic
	[4139]=":2749:4:2:1:::1:0:", -- Junglewalker Sandals
	[4140]=":1875:4:2:1:::1:0:", -- Palm Frond Mantle
	[4197]=":2765:4:3:1:::1:0:", -- Berylline Pads
	[4213]=":2500:9:2:1:::1:0:", -- Grimoire of Doom
	[4231]=":110:7:1:20::165:1:0:", -- Cured Light Hide
	[4232]=":125:7:1:10::165:1:0:", -- Medium Hide
	[4233]=":200:7:1:20::165:1:0:", -- Cured Medium Hide
	[4234]="600:150:7:1:20::164,202,165,197:1:0:14846", -- Heavy Leather
	[4235]=":200:7:1:10::165:1:0:", -- Heavy Hide
	[4236]=":225:7:1:20::165:1:0:", -- Cured Heavy Hide
	[4237]=":35:4:1:1:::1:0:", -- Handstitched Leather Belt
	[4238]=":200:1:1:1:::1:0:", -- Linen Bag
	[4239]=":71:4:1:1:::1:0:", -- Embossed Leather Gloves
	[4240]=":300:1:1:1:::1:0:", -- Woolen Bag
	[4241]=":450:1:1:1:::1:0:", -- Green Woolen Bag
	[4242]=":347:4:2:1:::1:0:", -- Embossed Leather Pants
	[4243]=":461:4:2:1::165:1:0:", -- Fine Leather Tunic
	[4244]=":723:4:2:1:::1:0:", -- Hillman\'s Leather Vest
	[4245]=":2000:1:1:1:::1:0:", -- Small Silk Pack
	[4246]=":125:4:1:1::165:1:0:", -- Fine Leather Belt
	[4247]=":1049:4:2:1:::1:0:", -- Hillman\'s Leather Gloves
	[4248]=":791:4:2:1:::1:0:", -- Dark Leather Gloves
	[4249]=":703:4:2:1:::1:0:", -- Dark Leather Belt
	[4250]=":705:4:2:1:::1:0:", -- Hillman\'s Belt
	[4251]=":1200:4:2:1:::1:0:", -- Hillman\'s Shoulders
	[4252]=":1457:4:2:1:::1:0:", -- Dark Leather Shoulders
	[4253]=":962:4:3:1:::1:0:", -- Toughened Leather Gloves
	[4254]=":1071:4:2:1:::1:0:", -- Barbaric Gloves
	[4255]=":2366:4:2:1::164:1:0:", -- Green Leather Armor
	[4256]=":3477:4:2:1:::1:0:", -- Guardian Armor
	[4257]=":1311:4:2:1:::1:0:", -- Green Leather Belt
	[4258]=":1592:4:2:1:::1:0:", -- Guardian Belt
	[4259]=":1934:4:2:1:::1:0:", -- Green Leather Bracers
	[4260]=":2559:4:2:1:::1:0:", -- Guardian Leather Bracers
	[4261]=":32:4:1:1:::1:0:", -- Solliden\'s Trousers
	[4262]=":2652:4:3:1:::1:0:", -- Gem-studded Leather Belt
	[4263]=":94:4:1:1:::1:0:", -- Standard Issue Shield
	[4264]=":2804:4:2:1:::1:0:", -- Barbaric Belt
	[4265]=":650:0:1:10:::1:0:", -- Heavy Armor Kit
	[4278]=":25:12:1:20:::1:0:", -- Lesser Bloodstone Ore
	[4289]="50:12:7:1:20::165:1:0:16768,6301,26744,4589,26751,16689,7947,24843,19372,12028,4225,6731,4775,843,12942,5163,16261,18277,17490,1456,26758,26765,5783,8363,12956,1692,3958,18009,2816,960,21085,12043,66,26754,26752,18427,3955,26743,2225,25010,4561,3482,14846,2697,25082,26756,8934,17486,4897,2699,11189,26759,3954,989,2821,16224,1465,16262,3779,1250,2846,11874,12943,3081,3614,12941,3168,26747,26741,26739,4877,12022,18754,12957,9636,3556,19196,3187,7854,26753,26742,7852,25051,26748,19450,5128,2810,15179,18426,5135,12245,5565,8160,3499,12958,24995,16613,26745,26757,4229,3366,19532,5944,26724,16748,2819,3005,26749,1286,26755,26738,5100,2118,8145,1148,2393,19244,2381,777,24935,18771,4194,3367,2698,26740,5817,25019", -- Salt
	[4290]=":715:4:2:1:::1:0:", -- Dust Bowl
	[4291]="500:125:7:1:20::165,197:1:0:16768,26744,4589,26751,7947,24843,4225,3096,6731,18749,4775,12942,8681,26765,5783,2670,12956,11557,21085,3955,25082,17486,4897,16366,2699,4189,3954,2821,18772,2846,26747,4877,2668,12022,9636,19196,26753,26742,25051,19450,5128,6576,1347,15179,3485,1672,5135,12245,12958,15165,16613,16767,19532,26724,16748,2819,2672,26749,19722,1286,26755,26738,16638,1148,2669,2381,6301,16689,12028,19372,18277,5163,26758,1456,4577,8363,5154,7940,18009,3958,960,2816,26752,26754,6568,25010,2225,26743,4561,2697,8934,26756,11189,4168,26759,989,3779,12943,11874,12941,3091,26739,26741,6574,12957,18754,7854,19213,7852,26748,19521,3364,2810,5565,2394,8160,1474,24995,4229,26757,26745,3366,1454,5944,6567,3005,5100,8145,2393,19244,18771,24935,3367,2698,26740,5817,25019", -- Silken Thread
	[4292]=":200:9:2:1:::1:0:", -- Pattern: Green Woolen Bag
	[4293]=":162:9:2:1:::1:0:", -- Pattern: Hillman\'s Leather Vest
	[4294]=":400:9:2:1:::1:0:", -- Pattern: Hillman\'s Belt
	[4296]=":525:9:2:1:::1:0:", -- Pattern: Dark Leather Shoulders
	[4297]=":500:9:2:1:::1:0:", -- Pattern: Barbaric Gloves
	[4298]=":162:9:3:1:::1:0:", -- Pattern: Guardian Belt
	[4299]=":500:9:2:1:::1:0:", -- Pattern: Guardian Armor
	[4300]=":700:9:2:1:::1:0:", -- Pattern: Guardian Leather Bracers
	[4301]=":875:9:3:1:::1:0:", -- Pattern: Barbaric Belt
	[4302]=":146:2:1:1:::1:0:", -- Small Green Dagger
	[4303]=":398:2:2:1:::1:0:", -- Cranial Thumper
	[4304]="1200:300:7:1:20::164,202,165,197:1:0:14846", -- Thick Leather
	[4305]="2400:600:7:1:10::165,197:1:0:16631", -- Bolt of Silk Cloth
	[4306]="600:150:7:1:20::164,202,129,197:1:0:16631", -- Silk Cloth
	[4307]=":29:4:1:1:::1:0:", -- Heavy Linen Gloves
	[4308]=":45:4:1:1:::1:0:", -- Green Linen Bracers
	[4309]=":226:4:2:1:::1:0:", -- Handstitched Linen Britches
	[4310]=":180:4:2:1:::1:0:", -- Heavy Woolen Gloves
	[4311]=":475:4:2:1:::1:0:", -- Heavy Woolen Cloak
	[4312]=":237:4:2:1:::1:0:", -- Soft-soled Linen Boots
	[4313]=":416:4:2:1:::1:0:", -- Red Woolen Boots
	[4314]=":331:4:1:1:::1:0:", -- Double-stitched Woolen Shoulders
	[4315]=":425:4:1:1:::1:0:", -- Reinforced Woolen Shoulders
	[4316]=":743:4:2:1:::1:0:", -- Heavy Woolen Pants
	[4317]=":1076:4:2:1:::1:0:", -- Phoenix Pants
	[4318]=":610:4:2:1:::1:0:", -- Gloves of Meditation
	[4319]=":815:4:2:1:::1:0:", -- Azure Silk Gloves
	[4320]=":979:4:3:1:::1:0:", -- Spidersilk Boots
	[4321]=":1120:4:2:1:::1:0:", -- Spider Silk Slippers
	[4322]=":1810:4:2:1:::1:0:", -- Enchanter\'s Cowl
	[4323]=":1999:4:2:1:::1:0:", -- Shadow Hood
	[4324]=":1874:4:2:1:::1:0:", -- Azure Silk Vest
	[4325]=":2272:4:2:1:::1:0:", -- Boots of the Enchanter
	[4326]=":2496:4:2:1:::1:0:", -- Long Silken Cloak
	[4327]=":3788:4:3:1:::1:0:", -- Icy Cloak
	[4328]=":1524:4:2:1:::1:0:", -- Spider Belt
	[4329]=":2120:4:2:1:::1:0:", -- Star Belt
	[4330]=":250:4:1:1:::1:0:", -- Stylish Red Shirt
	[4331]=":526:4:2:1:::1:0:", -- Phoenix Gloves
	[4332]=":500:4:1:1:::1:0:", -- Bright Yellow Shirt
	[4333]=":1200:4:1:1:::1:0:", -- Dark Silk Shirt
	[4334]=":550:4:1:1:::1:0:", -- Formal White Shirt
	[4335]=":1500:4:1:1:::1:0:", -- Rich Purple Silk Shirt
	[4336]=":1500:4:1:1:::1:0:", -- Black Swashbuckler\'s Shirt
	[4337]=":750:7:1:10::202,165,197:1:0:", -- Thick Spider\'s Silk
	[4338]="1000:250:7:1:20::164,202,129,165,197:1:0:16631", -- Mageweave Cloth
	[4339]=":1250:7:1:10::202,197:1:0:", -- Bolt of Mageweave
	[4340]="350:87:7:1:10::165,197:1:0:16768,26744,4589,26751,7947,24843,4225,3096,6731,18749,4775,12942,8681,26765,5783,2670,12956,11557,21085,3955,25082,17486,4897,16366,2699,4189,3954,2821,18772,2846,26747,2668,12022,19196,26753,26742,25051,19450,5128,6576,1347,15179,3485,1672,5135,12245,12958,15165,16613,16767,19532,26724,16748,2819,2672,26749,19722,1286,26755,26738,16638,1148,2669,6301,16689,12028,19372,18277,5163,26758,4577,8363,5154,7940,18009,3958,2816,26752,26754,6568,25010,2225,26743,4561,2697,8934,26756,11189,4168,26759,989,3779,12943,11874,12941,3091,26739,26741,6574,12957,18754,7854,19213,7852,19521,26748,3364,2810,5565,2394,8160,1474,24995,4229,26757,26745,3366,1454,5944,6567,3005,8145,19244,18771,24935,3367,26740,2698,5817,25019", -- Gray Dye
	[4341]="500:125:7:1:10::197:1:0:16768,26744,4589,26751,7947,24843,4225,3096,6731,18749,4775,12942,8681,26765,5783,2670,12956,11557,21085,3955,25082,17486,4897,16366,2699,4189,3954,2821,18772,2846,26747,2668,12022,19196,26753,26742,25051,19450,5128,6576,1347,15179,3485,1672,5135,12245,12958,15165,16613,16767,19532,26724,16748,2819,2672,26749,19722,1286,26755,26738,16638,1148,2669,6301,16689,12028,19372,18277,5163,26758,4577,8363,5154,7940,18009,3958,2816,26752,26754,6568,25010,2225,26743,4561,2697,8934,26756,11189,4168,26759,989,3779,12943,11874,12941,3091,26739,26741,6574,12957,18754,7854,19213,7852,19521,26748,3364,2810,5565,2394,8160,1474,24995,4229,26757,26745,3366,1454,5944,6567,3005,8145,19244,18771,24935,3367,26740,2698,5817,25019", -- Yellow Dye
	[4342]="2500:625:7:1:10::171,202,165,197:1:0:16768,26744,4589,26751,7947,24843,4225,3096,6731,18749,4775,12942,8681,26765,5783,2670,12956,11557,21085,3955,25082,17486,4897,16366,2699,4189,3954,2821,18772,2846,26747,2668,12022,19196,26753,26742,25051,19450,5128,6576,1347,15179,3485,1672,5135,12245,12958,15165,16613,16767,19532,26724,16748,2819,2672,26749,19722,1286,26755,26738,16638,1148,2669,6301,16689,12028,19372,18277,5163,26758,4577,8363,5154,7940,18009,3958,2816,26752,26754,6568,25010,2225,26743,4561,2697,8934,26756,11189,4168,26759,989,3779,12943,11874,12941,3091,26739,26741,6574,12957,18754,7854,19213,7852,19521,26748,3364,2810,5565,2394,8160,1474,24995,4229,26757,26745,3366,1454,5944,6567,3005,8145,19244,18771,24935,3367,26740,2698,5817,25019", -- Purple Dye
	[4343]=":60:4:1:1:::1:0:", -- Brown Linen Pants
	[4344]=":11:4:1:1:::1:0:", -- Brown Linen Shirt
	[4345]=":100:9:2:1:::1:0:", -- Pattern: Red Woolen Boots
	[4346]=":100:9:2:1:::1:0:", -- Pattern: Heavy Woolen Cloak
	[4347]=":150:9:2:1:::1:0:", -- Pattern: Reinforced Woolen Shoulders
	[4348]=":175:9:2:1:::1:0:", -- Pattern: Phoenix Gloves
	[4349]=":175:9:2:1:::1:0:", -- Pattern: Phoenix Pants
	[4350]=":200:9:2:1:::1:0:", -- Pattern: Spider Silk Slippers
	[4351]=":225:9:2:1:::1:0:", -- Pattern: Shadow Hood
	[4352]=":275:9:2:1:::1:0:", -- Pattern: Boots of the Enchanter
	[4353]=":300:9:2:1:::1:0:", -- Pattern: Spider Belt
	[4354]=":350:9:3:1:::1:0:", -- Pattern: Rich Purple Silk Shirt
	[4355]="1500:375:9:1:1:::1:0:2381,6567", -- Pattern: Icy Cloak
	[4356]=":375:9:2:1:::1:0:", -- Pattern: Star Belt
	[4357]="16:4:7:1:20::202:1:0:18484,9676,17222,1694,18775,9544,6777,18752,14637,2684,3133,16657,17421,18278,2685,5519,16782,27711,5175,11185,4453,20890,4587,6730,3495,2683,2682,19383,1448,2687,8678,3413,8679,2688", -- Rough Blasting Powder
	[4358]=":30:7:1:20:::1:0:", -- Rough Dynamite
	[4359]=":12:7:1:10::202:1:0:", -- Handful of Copper Bolts
	[4360]=":60:7:1:10:::1:0:", -- Rough Copper Bomb
	[4361]="480:120:7:1:10::202:1:0:18484,9676,17222,1694,18775,9544,6777,18752,14637,2684,3133,16657,17421,18278,2685,5519,16782,27711,5175,11185,4453,20890,4587,6730,3495,2683,2682,19383,1448,2687,8678,3413,8679,2688", -- Copper Tube
	[4362]=":187:2:2:1:::1:0:", -- Rough Boomstick
	[4363]="200:50:7:1:10::202:1:0:18484,9676,17222,1694,18775,9544,6777,18752,14637,2684,3133,16657,17421,18278,2685,5519,16782,27711,5175,11185,4453,20890,4587,6730,3495,2683,2682,19383,1448,2687,8678,3413,8679,2688", -- Copper Modulator
	[4364]="48:12:7:1:20::202:1:0:18484,9676,17222,1694,18775,9544,6777,18752,14637,2684,3133,16657,17421,18278,2685,5519,16782,27711,5175,11185,4453,20890,4587,6730,3495,2683,2682,19383,1448,2687,8678,3413,8679,2688", -- Coarse Blasting Powder
	[4365]=":75:7:1:20:::1:0:", -- Coarse Dynamite
	[4366]=":75:15:1:10:::1:0:", -- Target Dummy
	[4367]=":150:7:1:10:::1:0:", -- Small Seaforium Charge
	[4368]=":408:4:2:1::202:1:0:", -- Flying Tiger Goggles
	[4369]=":1179:2:2:1:::1:0:", -- Deadly Blunderbuss
	[4370]=":175:7:1:10:::1:0:", -- Large Copper Bomb
	[4371]="800:200:7:1:10::202:1:0:18484,9676,17222,1694,18775,9544,6777,18752,14637,2684,3133,16657,17421,18278,2685,5519,16782,27711,5175,11185,4453,20890,4587,6730,3495,2683,2682,19383,1448,2687,8678,3413,8679,2688", -- Bronze Tube
	[4372]=":1800:2:2:1:::1:0:", -- Lovingly Crafted Boomstick
	[4373]=":722:4:2:1:::1:0:", -- Shadow Goggles
	[4374]=":200:7:1:10:::1:0:", -- Small Bronze Bomb
	[4375]=":115:7:1:10::202:1:0:", -- Whirring Bronze Gizmo
	[4376]=":200:7:1:1:::1:0:", -- Flame Deflector
	[4377]=":150:7:1:20::202:1:0:", -- Heavy Blasting Powder
	[4378]="1400:350:7:1:20:::1:0:3180", -- Heavy Dynamite
	[4379]=":2357:2:2:1:::1:0:", -- Silver-plated Shotgun
	[4380]=":500:7:1:10:::1:0:", -- Big Bronze Bomb
	[4381]=":600:4:2:1:::1:0:", -- Minor Recombobulator
	[4382]="2400:600:7:1:10::202:1:0:18484,9676,17222,1694,18775,9544,6777,18752,14637,2684,3133,16657,17421,18278,2685,5519,16782,27711,5175,11185,4453,20890,4587,6730,3495,2683,2682,19383,1448,2687,8678,3413,8679,2688", -- Bronze Framework
	[4383]=":3183:2:2:1:::1:0:", -- Moonsight Rifle
	[4384]=":1000:15:1:5:::1:0:", -- Explosive Sheep
	[4385]=":1410:4:2:1::202:1:0:", -- Green Tinted Goggles
	[4386]=":175:7:1:1:::1:0:", -- Ice Deflector
	[4387]=":400:7:1:10::202:1:0:", -- Iron Strut
	[4388]=":1000:7:1:1:::1:0:", -- Discombobulator Ray
	[4389]="3000:750:7:1:10::202:1:0:18484,9676,17222,1694,18775,9544,6777,18752,14637,2684,3133,16657,17421,18278,2685,5519,16782,27711,5175,11185,4453,20890,4587,6730,3495,2683,2682,19383,1448,2687,8678,3413,8679,2688", -- Gyrochronatom
	[4390]=":500:7:1:10:::1:0:", -- Iron Grenade
	[4391]=":4000:15:1:5:::1:0:", -- Compact Harvest Reaper Kit
	[4392]=":2500:15:1:10:::1:0:", -- Advanced Target Dummy
	[4393]=":2632:4:2:1:::1:0:", -- Craftsman\'s Monocle
	[4394]=":750:7:1:10::202:1:0:", -- Big Iron Bomb
	[4395]=":1600:15:1:10:::1:0:", -- Goblin Land Mine
	[4396]=":6000:4:1:1:::1:0:", -- Mechanical Dragonling
	[4397]=":5000:4:1:1:::1:0:", -- Gnomish Cloaking Device
	[4398]=":900:7:1:10:::1:0:", -- Large Seaforium Charge
	[4399]="200:50:7:1:10::202:1:0:16768,6301,26744,26751,7947,24843,19372,12028,4775,5163,18484,1456,26758,26765,8363,18009,960,18775,9544,26754,26752,6777,18752,3955,14637,26743,2225,25010,4561,3133,16657,17421,25082,26756,8934,17486,4897,2685,11189,18278,26759,3954,5175,989,27711,11185,2821,4587,20890,6730,2682,3779,3495,1448,3413,12941,26747,26741,26739,4877,12022,12957,9636,26753,26742,9676,17222,25051,26748,19450,1694,15179,2810,12245,5135,12958,24995,16613,26745,26757,4229,2684,26724,26749,5519,16782,1286,4453,26755,26738,5100,2683,8145,19383,1148,2393,19244,2687,2381,24935,8679,8678,2688,3367,26740,5817,25019", -- Wooden Stock
	[4400]="2000:500:7:1:10::202:1:0:16768,6301,26744,26751,7947,24843,19372,12028,4775,5163,18484,1456,26758,26765,8363,18009,960,18775,9544,26754,26752,6777,18752,3955,14637,26743,2225,25010,4561,3133,16657,17421,25082,26756,8934,17486,4897,2685,11189,18278,26759,3954,5175,989,27711,11185,2821,4587,20890,6730,2682,3779,3495,1448,3413,12941,26747,26741,26739,4877,12022,12957,9636,26753,26742,9676,17222,25051,26748,19450,1694,15179,2810,12245,5135,12958,24995,16613,26745,26757,4229,2684,26724,26749,5519,16782,1286,4453,26755,26738,5100,2683,8145,19383,1148,2393,19244,2687,2381,24935,8679,8678,2688,3367,26740,5817,25019", -- Heavy Stock
	[4401]=":100:15:1:1:::1:0:", -- Mechanical Squirrel Box
	[4402]=":250:7:1:5::171,185,202:1:0:", -- Small Flame Sac
	[4403]=":2000:7:1:1:::1:0:", -- Portable Bronze Mortar
	[4404]="100:25:7:1:20::202:1:0:18484,9676,17222,1694,18775,9544,6777,18752,14637,2684,3133,16657,17421,18278,2685,5519,16782,27711,5175,11185,4453,20890,4587,6730,3495,2683,2682,19383,1448,2687,8678,3413,8679,2688", -- Silver Contact
	[4405]=":125:0:1:5:::1:0:", -- Crude Scope
	[4406]=":600:0:1:5:::1:0:", -- Standard Scope
	[4407]=":1200:0:2:5::202:1:0:", -- Accurate Scope
	[4408]=":162:9:2:1:::1:0:", -- Schematic: Mechanical Squirrel
	[4409]=":200:9:2:1:::1:0:", -- Schematic: Small Seaforium Charge
	[4410]=":250:9:2:1:::1:0:", -- Schematic: Shadow Goggles
	[4411]=":275:9:2:1:::1:0:", -- Schematic: Flame Deflector
	[4412]=":375:9:2:1:::1:0:", -- Schematic: Moonsight Rifle
	[4413]=":450:9:2:1:::1:0:", -- Schematic: Discombobulator Ray
	[4414]=":462:9:2:1:::1:0:", -- Schematic: Portable Bronze Mortar
	[4415]=":550:9:3:1:::1:0:", -- Schematic: Craftsman\'s Monocle
	[4416]=":600:9:2:1:::1:0:", -- Schematic: Goblin Land Mine
	[4417]=":675:9:2:1:::1:0:", -- Schematic: Large Seaforium Charge
	[4419]="450:112:0:1:5:::1:0:14847", -- Scroll of Intellect III
	[4421]="400:100:0:1:5:::1:0:14847,12246", -- Scroll of Protection III
	[4422]="450:112:0:1:5:::1:0:14847", -- Scroll of Stamina III
	[4424]="400:100:0:1:5:::1:0:14847,12246", -- Scroll of Spirit III
	[4425]="500:125:0:1:5:::1:0:14847,20092", -- Scroll of Agility III
	[4426]="500:125:0:1:5:::1:0:14847,20092", -- Scroll of Strength III
	[4428]=":331:15:0:5:::1:0:", -- Spider Palp
	[4429]="::12:1:1:::1:0:", -- Deepfury\'s Orders
	[4430]=":4307:4:2:1:::1:0:", -- Ethereal Talisman
	[4432]="::12:1:1:::1:0:", -- Sully Balloo\'s Letter
	[4433]="::12:1:1:::1:0:", -- Waterlogged Envelope
	[4434]=":572:4:2:1:::1:0:", -- Scarecrow Trousers
	[4435]="::12:1:20:::1:0:", -- Mote of Myzrael
	[4436]=":331:4:2:1:::1:0:", -- Jewel-encrusted Sash
	[4437]=":1855:2:2:1:::1:0:", -- Channeler\'s Staff
	[4438]=":1693:4:3:1:::1:0:", -- Pugilist Bracers
	[4439]=":1788:2:2:1:::1:0:", -- Bruiser Club
	[4440]="::12:1:1:::1:0:", -- Sigil of Strom
	[4441]="::12:1:1:::1:0:", -- MacKreel\'s Moonshine
	[4443]=":3472:4:2:1:::1:0:", -- Grim Pauldrons
	[4444]=":1490:4:2:1:::1:0:", -- Black Husk Shield
	[4445]=":2068:2:2:1:::1:0:", -- Flesh Carver
	[4446]=":3594:2:3:1:::1:0:", -- Blackvenom Blade
	[4447]=":902:4:2:1:::1:0:", -- Cloak of Night
	[4448]=":1992:4:2:1:::1:0:", -- Husk of Naraxis
	[4449]=":3332:2:2:1:::1:0:", -- Naraxis\' Fang
	[4450]="::12:1:20:::1:0:", -- Sigil Fragment
	[4453]="::12:1:1:::1:0:", -- Sigil of Thoradin
	[4454]=":3800:2:3:1:::1:0:", -- Talon of Vultros
	[4455]=":3096:4:2:1:::1:0:", -- Raptor Hide Harness
	[4456]=":1553:4:2:1:::1:0:", -- Raptor Hide Belt
	[4457]=":300:0:1:20:::1:0:", -- Barbecued Buzzard Wing
	[4458]="::12:1:1:::1:0:", -- Sigil of Arathor
	[4459]=":150:15:0:10:::1:0:", -- Brittle Dragon Bone
	[4460]=":175:15:0:10:::1:0:", -- Ripped Wing Webbing
	[4461]=":208:7:1:10::165:1:0:", -- Raptor Hide
	[4462]=":1425:4:2:1:::1:0:", -- Cloak of Rot
	[4463]=":953:4:2:1:::1:0:", -- Beaded Raptor Collar
	[4464]=":2380:4:2:1:::1:0:", -- Trouncing Boots
	[4465]=":1585:4:2:1:::1:0:", -- Bonefist Gauntlets
	[4466]="::12:1:1:::1:0:", -- Sigil of Trollbane
	[4467]="::12:1:1:::1:0:", -- Sigil of Ignaeus
	[4468]="::12:1:1:::1:0:", -- Sheathed Trol\'kalar
	[4469]="::12:1:1:::1:0:", -- Rod of Order
	[4470]="38:9:7:1:20::185,333,202:1:0:20231,1318,19315,151,19540,5158,16635,22270,19679,3076,18753,12246,19534,16191,227,5758,19374,3186,12959,17421,734,19560,18810,12021,20092,4228,8139,19625,16259,2084,20194,1250,18811,19015,1448,17489,3498,19243,25035,15397,19537,19497,3625,15419,3481,16602,19450,16826,19343,19017,2806,2908,19020,1691,4182,21083,1149,1452,491,15174,20892,3350,19562,14624,2140,19573,3164,4876,3608,16722,19452,5134,4084,19314,22099,19663,3346,19197,1285,11555,19372,3012,25034,19533,20249,2134,19498,5757,19436,18011,20891,19574,2803,16732,3313,20080,21082,791,18773,18907,1682,4555,20250,2401,22271,4082,7942,4241,12027,21183,2808,3962,11038,19234,19474,18959,20081,12960,4617,19345,8362,5101,21111,4170,3541,1650,23143,16260,19042,19194,16444,17446,19053,18015,19649,4896,18960,16187,19021,18951,21113,2820,1685", -- Simple Wood
	[4471]="135:33:7:1:1:::1:0:19197,1285,19372,11555,25034,19533,20231,19315,20249,151,2134,19498,22270,19679,3076,19436,12246,18011,19534,16191,20891,227,2803,19574,16732,19374,3313,3186,20080,21082,12959,791,17421,734,19560,18810,12021,20092,18907,8139,1682,19625,16259,4555,2401,20250,2084,22271,20194,4082,1250,18811,19015,1448,7942,17489,12027,4241,21183,3498,19243,25035,2808,15397,3962,11038,19497,19474,3625,18959,3481,16602,19450,16826,20081,19343,19017,12960,2806,2908,19020,1691,4182,8362,19345,5101,21083,1149,4170,21111,3541,23143,1452,491,15174,20892,3350,19562,16260,19194,19042,17446,16444,19053,19649,18015,18960,4896,16187,14624,2140,19573,3164,19021,4876,3608,19452,5134,21113,2820,4084,1685,19314,22099", -- Flint and Tinder
	[4472]="::12:1:1:::1:0:", -- Scroll of Myzrael
	[4473]="::12:1:1:::1:0:", -- Eldritch Shackles
	[4474]=":4207:2:2:1:::1:0:", -- Ravenwood Bow
	[4476]=":2734:4:2:1:::1:0:", -- Beastwalker Robe
	[4477]=":4390:4:2:1:::1:0:", -- Nefarious Buckler
	[4478]=":10176:4:2:1:::1:0:", -- Iridescent Scale Leggings
	[4479]=":178:0:1:10:::1:0:", -- Burning Charm
	[4480]=":185:0:1:10:::1:0:", -- Thundering Charm
	[4481]=":176:0:1:10:::1:0:", -- Cresting Charm
	[4482]="::12:1:1:::1:0:", -- Sealed Folder
	[4483]="::13:1:1:::1:0:", -- Burning Key
	[4484]="::13:1:1:::1:0:", -- Cresting Key
	[4485]="::13:1:1:::1:0:", -- Thundering Key
	[4487]="::12:1:1:::1:0:", -- Maiden\'s Folly Charts
	[4488]="::12:1:1:::1:0:", -- Spirit of Silverpine Charts
	[4489]="::12:1:1:::1:0:", -- Maiden\'s Folly Log
	[4490]="::12:1:1:::1:0:", -- Spirit of Silverpine Log
	[4491]="::12:1:1:::1:0:", -- Goggles of Gem Hunting
	[4492]="::12:1:20:::1:0:", -- Elven Gem
	[4493]="::12:1:1:::1:0:", -- Elven Gems
	[4494]="::12:1:1:::1:0:", -- Seahorn\'s Sealed Letter
	[4495]="::12:1:20:::1:0:", -- Bloodstone Amulet
	[4496]="500:125:1:1:1:::1:0:19197,1285,3487,3481,3016,1321,12960,151,16709,1691,2134,4182,8362,4170,3076,16191,491,16732,3369,4230,3313,3186,5132,791,17421,16260,19560,18810,17446,16444,16187,1682,2140,16690,16259,3164,4555,4082,18947,3608,4590,1250,18811,7942,17489,4241,12027,3498,4084,1685,8364", -- Small Brown Pouch
	[4497]="20000:5000:1:1:1:::1:0:2808,19197,3962,15397,1285,11038,11555,3487,3625,3016,1321,12960,2806,2908,16709,8362,5101,1149,4170,3541,12246,16191,227,1452,2803,16732,3369,4230,3313,15174,5132,12959,3350,734,19560,12021,4896,8139,14624,16690,4555,2401,2084,4876,18947,4590,1448,7942,17489,4241,12027,5134,2820,8364", -- Heavy Brown Bag
	[4498]="2500:625:1:1:1:::1:0:19197,1285,11555,3487,151,16709,2134,3076,12246,16191,227,2803,16732,3313,3186,5132,12959,791,17421,734,19560,18810,12021,8139,1682,16690,16259,4555,2401,2084,18947,4082,4590,1250,18811,1448,7942,17489,12027,4241,3498,8364,2808,15397,3962,11038,3481,3625,3016,1321,12960,2806,2908,1691,8362,4182,5101,4170,1149,3541,1452,4230,3369,491,15174,3350,16260,16444,17446,4896,16187,14624,2140,3164,4876,3608,5134,2820,4084,1685", -- Brown Leather Satchel
	[4499]="100000:25000:1:1:1:::1:0:5132,19197,16709,1321,4590,3369,4230,8364,16690", -- Huge Brown Sack
	[4500]=":8750:1:2:1:::1:0:", -- Traveler\'s Backpack
	[4502]="::12:1:1:::1:0:", -- Sample Elven Gem
	[4503]="::12:1:20:::1:0:", -- Witherbark Tusk
	[4504]=":1475:4:2:1:::1:0:", -- Dwarven Guard Cloak
	[4505]=":1974:4:2:1:::1:0:", -- Swampland Trousers
	[4506]="::12:1:20:::1:0:", -- Stromgarde Badge
	[4507]=":9938:4:3:1:::1:0:", -- Pit Fighter\'s Shield
	[4508]=":9351:4:3:1:::1:0:", -- Blood-tinged Armor
	[4509]=":2794:4:2:1:::1:0:", -- Seawolf Gloves
	[4510]="::12:1:1:::1:0:", -- Befouled Bloodstone Orb
	[4511]=":11256:2:2:1:::1:0:", -- Black Water Hammer
	[4512]="::12:1:20:::1:0:", -- Highland Raptor Eye
	[4513]="::12:1:20:::1:0:", -- Raptor Heart
	[4514]="::12:1:1:::1:0:", -- Sara Balloo\'s Plea
	[4515]="::12:1:1:::1:0:", -- Marez\'s Head
	[4516]="::12:1:1:::1:0:", -- Otto\'s Head
	[4517]="::12:1:1:::1:0:", -- Falconcrest\'s Head
	[4518]="::12:1:1:::1:0:", -- Torn Scroll Fragment
	[4519]="::12:1:1:::1:0:", -- Crumpled Scroll Fragment
	[4520]="::12:1:1:::1:0:", -- Singed Scroll Fragment
	[4521]="::12:1:20:::1:0:", -- Alterac Granite
	[4522]="::12:1:20:::1:0:", -- Witherbark Medicine Pouch
	[4525]="::12:1:1:::1:0:", -- Trelane\'s Wand of Invocation
	[4526]="::12:1:1:::1:0:", -- Raptor Talon Amulet
	[4527]="::12:1:1:::1:0:", -- Azure Agate
	[4528]="::12:1:1:::1:0:", -- Tor\'gan\'s Orb
	[4529]="::12:1:1:::1:0:", -- Enchanted Agate
	[4530]="::12:1:1:::1:0:", -- Trelane\'s Phylactery
	[4531]="::12:1:1:::1:0:", -- Trelane\'s Orb
	[4532]="::12:1:1:::1:0:", -- Trelane\'s Ember Agate
	[4533]="::12:1:1:::1:0:", -- Sealed Letter to Archmage Malin
	[4534]=":1173:4:2:1:::1:0:", -- Steel-clasped Bracers
	[4535]=":882:4:2:1:::1:0:", -- Ironforge Memorial Ring
	[4536]="25:1:0:1:20::185:5:0:4255,6735,12097,734,7736,894,23573,12096,1671,24934,5814,7714,19223,16542,16443,4191,17630,7978,4891,3342,3017,3961,21145,3934", -- Shiny Red Apple
	[4537]="125:6:0:1:20:::5:0:4255,6735,12097,734,7736,894,23573,12096,1671,24934,5814,7714,16542,16443,4191,17630,7978,4891,3342,3017,3961,21145,3934", -- Tel\'Abim Banana
	[4538]="500:25:0:1:20:::5:0:4255,14964,6735,12097,15125,734,7736,894,23573,12096,1671,24934,5814,7714,16542,16443,4191,14963,17630,7978,4891,3342,3017,3961,21145,15124,3934", -- Snapvine Watermelon
	[4539]="1000:50:0:1:20::185:5:0:4255,14964,6735,12097,15125,734,7736,894,23573,12096,1671,24934,5814,7714,19223,16542,16443,4191,14963,17630,7978,4891,3342,3017,3961,21145,15124,3934", -- Goldenbark Apple
	[4540]="25:1:0:1:20:::5:0:6734,233,8307,7941,1285,2352,6737,15433,24993,3291,829,8143,24934,10367,23603,4266,3003,3959,2364,6740,11103,16191,3689,4190,3518,25012,3313,4255,5620,3884,16256,4894,25020,6736,3546,152,3086,6747,3158,2115,1247,16739,1670,25089,3072,3480,8362,17630,4891,7744,3883,16458,3587,3937,2832,23522,3948,1237,11287,7485,6272,7737,24834,3708,25052,5109", -- Tough Hunk of Bread
	[4541]="125:6:0:1:20:::5:0:6734,233,1670,8307,25089,7941,2352,6737,3480,15433,24993,3291,8143,24934,10367,23603,4266,3003,3959,17630,2364,4891,6740,11103,7744,3883,3689,16458,4190,3518,25012,3937,2832,4255,5620,23522,3884,3948,16256,4894,25020,6736,3546,3086,1237,11287,6747,7485,1247,7737,6272,16739,24834,3708,5109,25052", -- Freshly Baked Bread
	[4542]="500:25:0:1:20:::5:0:6734,233,1670,8307,25089,7941,2352,6737,3480,15433,24993,3291,8143,24934,10367,23603,4266,3003,3959,17630,2364,4891,6740,11103,7744,3883,3689,16458,4190,3518,25012,3937,2832,4255,5620,23522,3884,3948,16256,4894,25020,6736,3546,3086,1237,11287,6747,7485,1247,7737,6272,16739,24834,3708,5109,25052", -- Moist Cornbread
	[4543]=":4098:4:2:1:::1:0:", -- White Drakeskin Cap
	[4544]="1000:50:0:1:20:::5:0:6734,233,1670,8307,25089,7941,2352,6737,3480,15433,24993,3291,8143,24934,10367,23603,4266,3003,3959,17630,2364,4891,6740,11103,7744,3883,3689,16458,4190,3518,25012,3937,2832,4255,5620,23522,3884,3948,16256,4894,25020,6736,3546,3086,1237,11287,6747,7485,1247,7737,6272,16739,24834,3708,5109,25052", -- Mulgore Spice Bread
	[4545]=":2202:4:2:1:::1:0:", -- Radiant Silver Bracers
	[4546]=":533:0:1:1:::1:0:", -- Call of the Raptor
	[4547]=":8319:2:2:1:::1:0:", -- Gnomish Zapper
	[4548]=":15028:2:2:1:::1:0:", -- Servomechanic Sledgehammer
	[4549]=":2092:4:2:1:::1:0:", -- Seafire Band
	[4550]=":2092:4:2:1:::1:0:", -- Coldwater Ring
	[4551]="::12:1:1:::1:0:", -- Or\'Kalar\'s Head
	[4552]=":530:15:0:10:::1:0:", -- Smooth Stone Chip
	[4553]=":411:15:0:5:::1:0:", -- Jagged Piece of Stone
	[4554]=":708:15:0:5:::1:0:", -- Shiny Polished Stone
	[4555]=":155:15:0:5:::1:0:", -- Thick Scaly Tail
	[4556]=":903:15:0:5:::1:0:", -- Speckled Shell Fragment
	[4557]=":225:15:0:10:::1:0:", -- Fiery Gland
	[4558]=":1565:15:0:1:::1:0:", -- Empty Barrel
	[4560]=":37:2:1:1:::1:0:", -- Fine Scimitar
	[4561]=":309:2:2:1:::1:0:", -- Scalping Tomahawk
	[4562]=":298:2:2:1:::1:0:", -- Severing Axe
	[4563]=":110:2:1:1:::1:0:", -- Billy Club
	[4564]=":610:2:2:1:::1:0:", -- Spiked Club
	[4565]=":38:2:1:1:::1:0:", -- Simple Dagger
	[4566]=":631:2:2:1:::1:0:", -- Sturdy Quarterstaff
	[4567]=":1049:2:2:1:::1:0:", -- Merc Sword
	[4568]=":1695:2:2:1:::1:0:", -- Grunt Axe
	[4569]=":612:2:2:1:::1:0:", -- Staunch Hammer
	[4570]=":922:2:2:1:::1:0:", -- Birchwood Maul
	[4571]=":979:2:2:1:::1:0:", -- War Knife
	[4575]=":1487:2:2:1:::1:0:", -- Medicine Staff
	[4576]=":1184:2:2:1:::1:0:", -- Light Bow
	[4577]=":357:2:2:1:::1:0:", -- Compact Shotgun
	[4580]=":787:15:0:10:::1:0:", -- Sabertooth Fang
	[4581]=":862:15:0:5:::1:0:", -- Patch of Fine Fur
	[4582]=":745:12:1:5:::1:0:", -- Soft Bushy Tail
	[4583]=":812:15:0:5:::1:0:", -- Thick Furry Mane
	[4584]=":937:15:0:5:::1:0:", -- Large Trophy Paw
	[4585]=":583:15:0:5:::1:0:", -- Dripping Spider Mandible
	[4586]=":713:15:0:5:::1:0:", -- Smooth Raptor Skin
	[4587]=":807:15:0:10:::1:0:", -- Tribal Raptor Feathers
	[4588]=":900:15:0:5:::1:0:", -- Pristine Raptor Skull
	[4589]=":530:7:1:10::197:1:0:", -- Long Elegant Feather
	[4590]=":655:15:0:5:::1:0:", -- Curved Yellow Bill
	[4591]=":413:15:0:5:::1:0:", -- Eagle Eye
	[4592]="20:1:0:1:20:::5:0:25089,11187,24993,1678,14731,8137,5814,10367,6738,3497,7943,4305,23896,16618,25012,12962,17553,4255,6727,8931,4307,6807,2842,25020,4200,3086,3540,19045,6791,3178,17656,16739,24834,1684,4221,25052", -- Longjaw Mud Snapper
	[4593]="500:4:0:1:20:::5:0:25089,11187,24993,1678,14731,8137,5814,10367,6738,3497,7943,4305,23896,16618,25012,12962,17553,4255,6727,8931,4307,6807,2842,25020,4200,3086,3540,19045,6791,3178,17656,16739,24834,1684,4221,25052", -- Bristle Whisker Catfish
	[4594]="1000:6:0:1:20:::5:0:25089,11187,24993,1678,14731,8137,5814,10367,6738,3497,7943,4305,23896,16618,25012,12962,17553,4255,6727,8931,4307,6807,2842,25020,4200,3086,3540,19045,6791,3178,17656,16739,24834,1684,4221,25052", -- Rockscale Cod
	[4595]="300:75:0:1:10:::1:0:2832", -- Junglevine Wine
	[4596]=":25:0:1:5:::1:0:", -- Discolored Healing Potion
	[4597]=":250:9:2:1:::1:0:", -- Recipe: Discolored Healing Potion
	[4598]=":212:0:1:10:::1:0:", -- Goblin Fishing Pole
	[4599]="2000:100:0:1:20:::5:0:3025,3705,15397,4954,7731,4875,11187,3881,3960,11118,2388,3489,23263,10367,3411,6928,5124,17630,982,4891,2814,8125,5870,16618,15174,4255,17553,14964,12959,5620,6929,12097,15125,5611,23481,3621,4894,5111,4782,12096,14624,9356,3933,3935,3312,24208,16443,7733,4169,14963,23605,7485,12196,4879,17656,2365,16739,4084,15124,1464,3368,3882,19182,3089", -- Cured Ham Steak
	[4600]="340:85:0:1:20:::1:0:2832,19617,25089,20377,24993,25020,5570,4782,24834,25052,25012", -- Cherry Grog
	[4601]="2000:100:0:1:20:::5:0:6734,233,1670,8307,25089,7941,2352,6737,3480,15433,24993,3291,8143,24934,10367,23603,4266,3003,3959,17630,2364,4891,6740,11103,7744,3883,3689,16458,4190,3518,25012,3937,2832,4255,5620,23522,3884,3948,16256,4894,25020,6736,3546,3086,1237,11287,6747,7485,1247,7737,6272,16739,24834,3708,5109,25052", -- Soft Banana Bread
	[4602]="2000:100:0:1:20:::5:0:4255,14964,6735,12097,15125,734,7736,894,23573,12096,1671,24934,5814,7714,16542,16443,4191,14963,17630,7978,4891,3342,3017,3961,21145,15124,3934", -- Moon Harvest Pumpkin
	[4603]=":4:7:1:20::185:1:0:", -- Raw Spotted Yellowtail
	[4604]="25:1:0:1:20:::5:0:8150,12384,12097,11038,3547,5688,12096,3544,4554,10367,2806,5886,6739,3329,8152,3138,4571,17656,6741,2803", -- Forest Mushroom Cap
	[4605]="125:6:0:1:20:::5:0:8150,12384,12097,11038,3547,5688,12096,3544,4554,10367,2806,5886,6739,3329,8152,3138,4571,17656,6741,2803", -- Red-speckled Mushroom
	[4606]="500:25:0:1:20:::5:0:14964,8150,12384,12097,15125,11038,3547,5688,12096,3544,4554,10367,2806,5886,6739,14963,3329,8152,4571,3138,17656,6741,15124,2803", -- Spongy Morel
	[4607]="1000:50:0:1:20:::5:0:14964,8150,12384,12097,15125,11038,3547,5688,12096,3544,4554,10367,2806,5886,6739,14963,3329,8152,4571,3138,17656,6741,15124,2803", -- Delicious Cave Mold
	[4608]="2000:100:0:1:20:::5:0:14964,8150,12384,12097,15125,11038,3547,5688,12096,3544,4554,10367,2806,5886,6739,14963,3329,8152,4571,3138,17656,6741,15124,2803", -- Raw Black Truffle
	[4609]="1000:250:9:1:1:::1:0:2814,12246", -- Recipe: Barbecued Buzzard Wing
	[4610]="::12:1:20:::1:0:", -- Carved Stone Urn
	[4611]=":50:7:1:20::202:1:0:", -- Blue Pearl
	[4612]="::12:1:20:::1:0:", -- Black Drake\'s Heart
	[4613]="::12:1:1:::1:0:", -- Corroded Black Box
	[4614]="::4:2:1:::1:0:", -- Pendant of Myzrael
	[4615]="::12:1:1:::1:0:", -- Blacklash\'s Bindings
	[4616]=":3:2:1:1:::1:0:", -- Ryedol\'s Lucky Pick
	[4621]="::12:1:1:::1:0:", -- Ambassador Infernus\' Bracer
	[4622]="::12:1:1:::1:0:", -- Sealed Note to Advisor Belgrum
	[4623]=":375:0:1:5:::1:0:", -- Lesser Stoneshield Potion
	[4624]=":550:9:1:1:::1:0:", -- Recipe: Lesser Stoneshield Potion
	[4625]=":250:7:1:20::171,333,197:1:0:", -- Firebloom
	[4626]="::12:1:20:::1:0:", -- Small Stone Shard
	[4627]="::12:1:5:::1:0:", -- Large Stone Slab
	[4628]="::12:1:20:::1:0:", -- Bracers of Rock Binding
	[4629]="::12:1:20:::1:0:", -- Supply Crate
	[4630]="::12:1:20:::1:0:", -- Scrap Metal
	[4631]="::12:1:1:::1:0:", -- Tablet of Ryun\'eh
	[4632]=":50:15:2:1:::1:0:", -- Ornate Bronze Lockbox
	[4633]=":70:15:2:1:::1:0:", -- Heavy Bronze Lockbox
	[4634]=":87:15:2:1:::1:0:", -- Iron Lockbox
	[4635]="::12:1:1:::1:0:", -- Hammertoe\'s Amulet
	[4636]=":110:15:2:1:::1:0:", -- Strong Iron Lockbox
	[4637]=":150:15:2:1:::1:0:", -- Steel Lockbox
	[4638]=":200:15:2:1:::1:0:", -- Reinforced Steel Lockbox
	[4639]=":162:12:1:1:::1:0:", -- Enchanted Sea Kelp
	[4640]="::12:1:1:::1:0:", -- Sign of the Earth
	[4641]="::12:1:1:::1:0:", -- Hand of Dagun
	[4643]=":1824:4:2:1:::1:0:", -- Grimsteel Cape
	[4644]="::12:1:1:::1:0:", -- The Legacy Heart
	[4645]="::12:1:1:::1:0:", -- Chains of Hematus
	[4646]="::12:1:1:::1:0:", -- Star of Xil\'yeh
	[4647]="::12:1:1:::1:0:", -- Yagyin\'s Digest
	[4648]="::12:1:1:::1:0:", -- Sigil of the Hammer
	[4649]="::12:1:1:::1:0:", -- Bonegrip\'s Note
	[4650]="::12:1:1:::1:0:", -- Bel\'dugur\'s Note
	[4652]=":10126:4:2:1:::1:0:", -- Salbac Shield
	[4653]=":7178:4:2:1:::1:0:", -- Ironheel Boots
	[4654]="::12:1:1:::1:0:", -- Mysterious Fossil
	[4655]=":71:7:1:10::185:1:0:", -- Giant Clam Meat
	[4656]=":1:0:1:20:::1:0:", -- Small Pumpkin
	[4658]=":23:4:1:1:::1:0:", -- Warrior\'s Cloak
	[4659]=":23:4:1:1:::1:0:", -- Warrior\'s Girdle
	[4660]=":324:4:2:1:::1:0:", -- Walking Boots
	[4661]=":929:4:2:1:::1:0:", -- Bright Mantle
	[4662]=":24:4:1:1:::1:0:", -- Journeyman\'s Cloak
	[4663]=":23:4:1:1:::1:0:", -- Journeyman\'s Belt
	[4665]=":22:4:1:1:::1:0:", -- Burnt Cloak
	[4666]=":26:4:1:1:::1:0:", -- Burnt Leather Belt
	[4668]=":32:4:1:1:::1:0:", -- Battle Chain Cloak
	[4669]=":42:4:1:1:::1:0:", -- Battle Chain Girdle
	[4671]=":32:4:1:1:::1:0:", -- Ancestral Cloak
	[4672]=":28:4:1:1:::1:0:", -- Ancestral Belt
	[4674]=":32:4:1:1:::1:0:", -- Tribal Cloak
	[4675]=":35:4:1:1:::1:0:", -- Tribal Belt
	[4676]=":278:4:2:1:::1:0:", -- Skeletal Gauntlets
	[4677]=":70:4:1:1:::1:0:", -- Veteran Cloak
	[4678]=":108:4:1:1:::1:0:", -- Veteran Girdle
	[4680]=":91:4:1:1:::1:0:", -- Brackwater Cloak
	[4681]=":109:4:1:1:::1:0:", -- Brackwater Girdle
	[4683]=":92:4:1:1:::1:0:", -- Spellbinder Cloak
	[4684]=":61:4:1:1:::1:0:", -- Spellbinder Belt
	[4686]=":67:4:1:1:::1:0:", -- Barbaric Cloth Cloak
	[4687]=":67:4:1:1:::1:0:", -- Barbaric Cloth Belt
	[4689]=":85:4:1:1:::1:0:", -- Hunting Cloak
	[4690]=":71:4:1:1:::1:0:", -- Hunting Belt
	[4692]=":69:4:1:1:::1:0:", -- Ceremonial Cloak
	[4693]=":86:4:1:1:::1:0:", -- Ceremonial Leather Belt
	[4694]=":515:4:1:1:::1:0:", -- Burnished Pauldrons
	[4695]=":327:4:2:1:::1:0:", -- Burnished Cloak
	[4696]=":5537:4:3:1:::1:0:", -- Lapidis Tankard of Tidesippe
	[4697]=":435:4:2:1:::1:0:", -- Burnished Girdle
	[4698]=":301:4:1:1:::1:0:", -- Seer\'s Mantle
	[4699]=":221:4:2:1:::1:0:", -- Seer\'s Belt
	[4700]=":379:4:1:1:::1:0:", -- Inscribed Leather Spaulders
	[4701]=":252:4:2:1:::1:0:", -- Inscribed Cloak
	[4702]="::12:1:20:::1:0:", -- Prospector\'s Pick
	[4703]="::12:1:20:::1:0:", -- Broken Tools
	[4705]=":1449:4:2:1:::1:0:", -- Lambent Scale Pauldrons
	[4706]=":687:4:2:1:::1:0:", -- Lambent Scale Cloak
	[4707]=":881:4:2:1:::1:0:", -- Lambent Scale Girdle
	[4708]=":462:4:2:1:::1:0:", -- Bright Belt
	[4709]=":982:4:2:1:::1:0:", -- Forest Leather Mantle
	[4710]=":561:4:2:1:::1:0:", -- Forest Cloak
	[4711]=":1112:4:2:1:::1:0:", -- Glimmering Cloak
	[4712]=":1228:4:2:1:::1:0:", -- Glimmering Mail Girdle
	[4713]=":926:4:2:1:::1:0:", -- Silver-thread Cloak
	[4714]=":681:4:2:1:::1:0:", -- Silver-thread Sash
	[4715]=":1026:4:2:1:::1:0:", -- Emblazoned Cloak
	[4716]=":1658:4:2:1:::1:0:", -- Combat Cloak
	[4717]=":2014:4:2:1:::1:0:", -- Mail Combat Belt
	[4718]=":2223:4:2:1:::1:0:", -- Nightsky Mantle
	[4719]=":1676:4:2:1:::1:0:", -- Nightsky Cloak
	[4720]=":1234:4:2:1:::1:0:", -- Nightsky Sash
	[4721]=":2809:4:2:1:::1:0:", -- Insignia Mantle
	[4722]=":1694:4:2:1:::1:0:", -- Insignia Cloak
	[4723]=":1703:4:2:1:::1:0:", -- Humbert\'s Pants
	[4724]=":1763:4:2:1:::1:0:", -- Humbert\'s Helm
	[4725]=":4736:4:2:1:::1:0:", -- Chief Brigadier Pauldrons
	[4726]=":2340:4:2:1:::1:0:", -- Chief Brigadier Cloak
	[4727]=":2791:4:2:1:::1:0:", -- Chief Brigadier Girdle
	[4729]=":3036:4:2:1:::1:0:", -- Aurora Mantle
	[4731]=":3824:4:2:1:::1:0:", -- Glyphed Epaulets
	[4732]=":2632:4:2:1:::1:0:", -- Glyphed Cloak
	[4733]=":7957:4:2:1:::1:0:", -- Blackforge Pauldrons
	[4734]=":4208:4:2:1:::1:0:", -- Mistscape Mantle
	[4735]=":3621:4:2:1:::1:0:", -- Mistscape Cloak
	[4736]=":2616:4:2:1:::1:0:", -- Mistscape Sash
	[4737]=":5743:4:2:1:::1:0:", -- Imperial Leather Spaulders
	[4738]=":3294:4:2:1:::1:0:", -- Imperial Leather Belt
	[4739]="::12:1:20:::1:0:", -- Plainstrider Meat
	[4740]="::12:1:20:::1:0:", -- Plainstrider Feather
	[4741]=":5438:4:2:1:::1:0:", -- Stromgarde Cavalry Leggings
	[4742]="::12:1:20:::1:0:", -- Mountain Cougar Pelt
	[4743]=":5430:4:3:1:::1:0:", -- Pulsating Crystalline Shard
	[4744]=":1986:4:2:1:::1:0:", -- Arcane Runed Bracers
	[4745]=":3230:4:2:1:::1:0:", -- War Rider Bracers
	[4746]=":4324:4:2:1:::1:0:", -- Doomsayer\'s Robe
	[4751]="::12:1:20:::1:0:", -- Windfury Talon
	[4752]="::12:1:20:::1:0:", -- Azure Feather
	[4753]="::12:1:20:::1:0:", -- Bronze Feather
	[4755]="::12:1:1:::1:0:", -- Water Pitcher
	[4757]=":4:15:0:5:::1:0:", -- Cracked Egg Shells
	[4758]="::12:1:20:::1:0:", -- Prairie Wolf Paw
	[4759]="::12:1:20:::1:0:", -- Plainstrider Talon
	[4765]="2878:575:2:2:1:::1:0:167,3682,3658,3479", -- Enamelled Broadsword
	[4766]="2407:481:2:2:1:::1:0:167,3682,3658,3479", -- Feral Blade
	[4767]=":139:4:2:1:::1:0:", -- Coppercloth Gloves
	[4768]=":139:4:2:1:::1:0:", -- Adept\'s Gloves
	[4769]="::12:1:20:::1:0:", -- Trophy Swoop Quill
	[4770]="::12:1:20:::1:0:", -- Bristleback Belt
	[4771]=":211:4:2:1:::1:0:", -- Harvest Cloak
	[4772]=":56:4:1:1:::1:0:", -- Warm Cloak
	[4775]=":28:15:0:5:::1:0:", -- Cracked Bill
	[4776]=":41:15:0:10:::1:0:", -- Ruffled Feather
	[4777]="7040:1408:2:2:1:::1:0:3682,2840,3534,222,844,3658", -- Ironwood Maul
	[4778]="7351:1470:2:2:1:::1:0:3682,2840,3534,222,844,3658", -- Heavy Spiked Mace
	[4779]=":13:15:0:10:::1:0:", -- Dull Kodo Tooth
	[4780]=":56:15:0:5:::1:0:", -- Kodo Horn Fragment
	[4781]="2736:547:4:2:1:::1:0:3683,3554,3091,1214", -- Whispering Vest
	[4782]="2077:415:4:2:1:::1:0:3683,3554,3091,1214", -- Solstice Robe
	[4783]="::12:1:1:::1:0:", -- Totem of Hawkwind
	[4784]=":360:15:0:5:::1:0:", -- Lifeless Stone
	[4785]=":469:4:2:1:::1:0:", -- Brimstone Belt
	[4786]="1394:278:4:2:1:::1:0:3683,3554,3091,1214", -- Wise Man\'s Belt
	[4787]=":577:15:0:5:::1:0:", -- Burning Pitch
	[4788]="2634:526:4:2:1:::1:0:3552,954,3684,1669", -- Agile Boots
	[4789]="1999:399:4:2:1:::1:0:3552,954,3684,1669", -- Stable Boots
	[4790]="4159:831:4:2:1:::1:0:1454,3096", -- Inferno Cloak
	[4791]=":133:0:1:20:::1:0:", -- Enchanted Water
	[4792]="3280:656:4:2:1:::1:0:1454,3096", -- Spirit Cloak
	[4793]="3720:744:4:2:1:::1:0:1454,3096", -- Sylvan Cloak
	[4794]="3515:703:4:2:1:::1:0:3536,844,3097,3492", -- Wolf Bracers
	[4795]="3528:705:4:2:1:::1:0:3536,844,3097,3492", -- Bear Bracers
	[4796]="3540:708:4:2:1:::1:0:3536,844,3097,3492", -- Owl Bracers
	[4797]="4263:852:4:2:1:::1:0:3682,3543,3493,226", -- Fiery Cloak
	[4798]="3871:774:4:2:1:::1:0:3682,3543,3493,226", -- Heavy Runed Cloak
	[4799]="3043:608:4:2:1:::1:0:3682,3543,3493,226", -- Antiquated Cloak
	[4800]="6110:1222:4:2:1:::1:0:3682,3543,3493,226", -- Mighty Chain Pants
	[4801]="::12:1:20:::1:0:", -- Stalker Claws
	[4802]="::12:1:20:::1:0:", -- Cougar Claws
	[4803]="::12:1:20:::1:0:", -- Prairie Alpha Tooth
	[4804]="::12:1:1:::1:0:", -- Prairie Wolf Heart
	[4805]="::12:1:1:::1:0:", -- Flatland Cougar Femur
	[4806]="::12:1:1:::1:0:", -- Plainstrider Scale
	[4807]="::12:1:1:::1:0:", -- Swoop Gizzard
	[4808]="::12:1:20:::1:0:", -- Well Stone
	[4809]="::12:1:20:::1:0:", -- Ambercorn
	[4810]=":3352:4:2:1:::1:0:", -- Boulder Pads
	[4813]=":33:15:0:10:::1:0:", -- Small Leather Collar
	[4814]=":6:15:0:5:::1:0:", -- Discolored Fang
	[4816]="7519:1503:4:2:1:::1:0:3682,3543,3493,226", -- Legionnaire\'s Leggings
	[4817]="12311:2462:2:2:1:::1:0:3534,3539,1441,844,4890,4086", -- Blessed Claymore
	[4818]="14273:2854:2:2:1:::1:0:3534,3539,1441,844,4890,4086", -- Executioner\'s Sword
	[4819]="::12:1:1:::1:0:", -- Fizsprocket\'s Clipboard
	[4820]="8321:1664:4:2:1:::1:0:3493,793", -- Guardian Buckler
	[4821]="6541:1308:4:2:1:::1:0:3493,793", -- Bear Buckler
	[4822]="6746:1349:4:2:1:::1:0:3493,793", -- Owl\'s Disk
	[4823]="::12:1:1:::1:0:", -- Water of the Seers
	[4824]="16856:3371:2:2:1:::1:0:3539,3180,1307,4890", -- Blurred Axe
	[4825]="20472:4094:2:2:1:::1:0:3539,3180,1307,4890", -- Callous Axe
	[4826]="15436:3087:2:2:1:::1:0:3539,3180,1307,4890", -- Marauder Axe
	[4827]="3749:749:4:2:1:::1:0:3537,1454,2679,4085,1307,3134", -- Wizard\'s Belt
	[4828]="3420:684:4:2:1:::1:0:3537,1454,2679,4085,1307,3134", -- Nightwind Belt
	[4829]="4154:830:4:2:1:::1:0:3537,1454,2679,4085,1307,3134", -- Dreamer\'s Belt
	[4830]="9475:1895:4:2:1:::1:0:3536,2679,4085,3180,4890", -- Saber Leggings
	[4831]="7859:1571:4:2:1:::1:0:3536,2679,4085,3180,4890", -- Stalking Pants
	[4832]="10498:2099:4:2:1:::1:0:3536,2679,4085,3180,4890", -- Mystic Sarong
	[4833]="8658:1731:4:2:1:::1:0:2679,4085,3180,3543", -- Glorious Shoulders
	[4834]="::12:1:1:::1:0:", -- Venture Co. Documents
	[4835]="10551:2110:4:2:1:::1:0:2679,4085,3180,3543", -- Elite Shoulders
	[4836]="8002:2000:4:2:1:::1:0:3537,3134,4086", -- Fireproof Orb
	[4837]="8002:2000:4:2:1:::1:0:3537,3134,4086", -- Strength of Will
	[4838]="8002:2000:4:2:1:::1:0:3537,3134,4086", -- Orb of Power
	[4840]=":142:2:1:1:::1:0:", -- Long Bayonet
	[4841]="::12:1:1:::1:0:", -- Horn of Arra\'chea
	[4843]="::12:1:1:::1:0:", -- Amethyst Runestone
	[4844]="::12:1:1:::1:0:", -- Opal Runestone
	[4845]="::12:1:1:::1:0:", -- Diamond Runestone
	[4846]="::12:1:1:::1:0:", -- Cog #5
	[4847]="::12:1:1:::1:0:", -- Lotwil\'s Shackles of Elemental Binding
	[4848]="::12:1:20:::1:0:", -- Battleboar Snout
	[4849]="::12:1:20:::1:0:", -- Battleboar Flank
	[4850]="::12:1:1:::1:0:", -- Bristleback Attack Plans
	[4851]="::12:1:1:::1:0:", -- Dirt-stained Map
	[4852]=":300:7:1:5:::1:0:", -- Flash Bomb
	[4854]="::4:1:1:::1:0:", -- Demon Scarred Cloak
	[4859]="::12:1:1:::1:0:", -- Burning Blade Medallion
	[4860]=":741:15:0:5:::1:0:", -- Glistening Frenzy Scale
	[4861]=":119:4:2:1:::1:0:", -- Sleek Feathered Tunic
	[4862]="::12:1:20:::1:0:", -- Scorpid Worker Tail
	[4863]="::12:1:20:::1:0:", -- Gnomish Tools
	[4864]="::12:1:10:::1:0:", -- Minshina\'s Skull
	[4865]=":5:15:0:5:::1:0:", -- Ruined Pelt
	[4866]="::12:1:1:::1:0:", -- Zalazane\'s Head
	[4867]=":8:15:0:5:::1:0:", -- Broken Scorpid Leg
	[4869]="::12:1:1:::1:0:", -- Fizzle\'s Claw
	[4870]="::12:1:20:::1:0:", -- Canvas Scraps
	[4871]="::12:1:20:::1:0:", -- Searing Collar
	[4872]=":95:15:0:5:::1:0:", -- Dry Scorpid Eye
	[4873]=":15:15:0:5:::1:0:", -- Dry Hardened Barnacle
	[4874]=":46:15:0:5:::1:0:", -- Clean Fishbones
	[4875]=":13:15:0:5:::1:0:", -- Slimy Bone
	[4876]=":78:15:0:5:::1:0:", -- Bloody Leather Boot
	[4877]=":10:15:0:5:::1:0:", -- Stone Arrowhead
	[4878]=":56:15:0:1:::1:0:", -- Broken Bloodstained Bow
	[4879]=":7:15:0:5:::1:0:", -- Squashed Rabbit Carcass
	[4880]=":86:15:0:5:::1:0:", -- Broken Spear
	[4881]="::12:1:1:::1:0:", -- Aged Envelope
	[4882]="::13:1:1:::1:0:", -- Benedict\'s Key
	[4883]="::12:1:1:::1:0:", -- Admiral Proudmoore\'s Orders
	[4886]="::12:1:20:::1:0:", -- Venomtail Poison Sac
	[4887]="::12:1:20:::1:0:", -- Intact Makrura Eye
	[4888]="::12:1:20:::1:0:", -- Crawler Mucus
	[4890]="::12:1:20:::1:0:", -- Taillasher Egg
	[4891]="::12:1:1:::1:0:", -- Kron\'s Amulet
	[4892]="::12:1:20:::1:0:", -- Durotar Tiger Fur
	[4893]="::12:1:20:::1:0:", -- Savannah Lion Tusk
	[4894]="::12:1:20:::1:0:", -- Plainstrider Kidney
	[4895]="::12:1:1:::1:0:", -- Thunder Lizard Horn
	[4896]="::12:1:20:::1:0:", -- Kodo Liver
	[4897]="::12:1:20:::1:0:", -- Thunderhawk Saliva Gland
	[4898]="::12:1:20:::1:0:", -- Lightning Gland
	[4903]="::12:1:1:::1:0:", -- Eye of Burning Shadow
	[4904]="::12:1:20:::1:0:", -- Venomtail Antidote
	[4905]="::12:1:1:::1:0:", -- Sarkoth\'s Mangled Claw
	[4906]=":22:4:1:1:::1:0:", -- Rainwalker Boots
	[4907]=":13:4:1:1:::1:0:", -- Woodland Tunic
	[4908]=":6:4:1:1:::1:0:", -- Nomadic Bracers
	[4909]=":369:4:2:1:::1:0:", -- Kodo Hunter\'s Leggings
	[4910]=":7:4:1:1:::1:0:", -- Painted Chain Gloves
	[4911]=":15:4:1:1:::1:0:", -- Thick Bark Buckler
	[4913]=":7:4:1:1:::1:0:", -- Painted Chain Belt
	[4914]=":6:4:1:1:::1:0:", -- Battleworn Leather Gloves
	[4915]=":7:4:1:1:::1:0:", -- Soft Wool Boots
	[4916]=":9:4:1:1:::1:0:", -- Soft Wool Vest
	[4917]=":14:4:1:1:::1:0:", -- Battleworn Chain Leggings
	[4918]="::12:1:20:::1:0:", -- Sack of Supplies
	[4919]=":5:4:1:1:::1:0:", -- Soft Wool Belt
	[4920]=":7:4:1:1:::1:0:", -- Battleworn Cape
	[4921]=":12:4:1:1:::1:0:", -- Dust-covered Leggings
	[4922]=":15:4:1:1:::1:0:", -- Jagged Chain Vest
	[4923]=":25:2:1:1:::1:0:", -- Primitive Hatchet
	[4924]=":25:2:1:1:::1:0:", -- Primitive Club
	[4925]=":26:2:1:1:::1:0:", -- Primitive Hand Blade
	[4926]="::12:1:1:::1:0:", -- Chen\'s Empty Keg
	[4928]=":20:4:1:1:::1:0:", -- Sandrunner Wristguards
	[4929]=":58:4:1:1:::1:0:", -- Light Scorpid Armor
	[4931]=":134:2:1:1:::1:0:", -- Hickory Shortbow
	[4932]=":179:2:1:1:::1:0:", -- Harpy Wing Clipper
	[4933]=":32:4:1:1:::1:0:", -- Seasoned Fighter\'s Cloak
	[4935]=":23:4:1:1:::1:0:", -- Wide Metal Girdle
	[4936]=":23:4:1:1:::1:0:", -- Dirt-trodden Boots
	[4937]=":71:4:1:1:::1:0:", -- Charging Buckler
	[4938]=":236:2:1:1:::1:0:", -- Blemished Wooden Staff
	[4939]=":395:2:2:1:::1:0:", -- Steady Bastard Sword
	[4940]=":36:4:1:1:::1:0:", -- Veiled Grips
	[4941]=":11:0:1:20:::1:0:", -- Really Sticky Glue
	[4942]=":89:4:1:1:::1:0:", -- Tiger Hide Boots
	[4944]=":72:4:1:1:::1:0:", -- Handsewn Cloak
	[4945]=":37:0:1:1:::1:0:", -- Faintly Glowing Skull
	[4946]=":67:4:1:1:::1:0:", -- Lightweight Boots
	[4947]=":325:2:2:1:::1:0:", -- Jagged Dagger
	[4948]=":326:2:2:1:::1:0:", -- Stinging Mace
	[4949]=":1706:2:2:1:::1:0:", -- Orcish Cleaver
	[4951]=":13:4:1:1:::1:0:", -- Squealer\'s Belt
	[4952]=":63:0:1:10:::1:0:", -- Stormstout
	[4953]=":88:0:1:10:::1:0:", -- Trogg Ale
	[4954]=":6:4:1:1:::1:0:", -- Nomadic Belt
	[4957]=":250:1:1:1:::1:0:", -- Old Moneybag
	[4958]=":23:4:1:1:::1:0:", -- Sun-beaten Cloak
	[4960]=":12:6:1:200:::1:0:", -- Flash Pellet
	[4961]=":183:2:1:1:::1:0:", -- Dreamwatcher Staff
	[4962]=":20:4:1:1:::1:0:", -- Double-layered Gloves
	[4963]=":24:4:1:1:::1:0:", -- Thunderhorn Cloak
	[4964]=":503:2:2:1:::1:0:", -- Goblin Smasher
	[4967]=":116:4:1:1:::1:0:", -- Tribal Warrior\'s Shield
	[4968]=":91:4:1:1:::1:0:", -- Bound Harness
	[4969]=":42:4:1:1:::1:0:", -- Fortified Bindings
	[4970]=":54:4:1:1:::1:0:", -- Rough-hewn Kodo Leggings
	[4971]=":383:2:2:1:::1:0:", -- Skorn\'s Hammer
	[4972]=":64:4:1:1:::1:0:", -- Cliff Runner Boots
	[4973]=":35:4:1:1:::1:0:", -- Plains Hunter Wristguards
	[4974]=":388:2:2:1:::1:0:", -- Compact Fighting Knife
	[4975]=":7773:4:3:1:::1:0:", -- Vigilant Buckler
	[4976]=":5486:4:2:1:::1:0:", -- Mistspray Kilt
	[4977]=":11893:2:2:1:::1:0:", -- Sword of Hammerfall
	[4978]=":7976:2:2:1:::1:0:", -- Ryedol\'s Hammer
	[4979]=":2587:4:2:1:::1:0:", -- Enchanted Stonecloth Bracers
	[4980]=":2209:4:2:1:::1:0:", -- Prospector Gloves
	[4982]=":961:4:0:1:::1:0:", -- Ripped Prospector Belt
	[4983]=":16837:2:2:1:::1:0:", -- Rock Pulverizer
	[4984]=":5630:4:2:1:::1:0:", -- Skull of Impending Doom
	[4986]="::12:1:1:::1:0:", -- Flawed Power Stone
	[4987]=":15584:2:2:1:::1:0:", -- Dwarf Captain\'s Sword
	[4992]="::12:1:1:::1:0:", -- Recruitment Letter
	[4995]="::12:1:1:::1:0:", -- Signed Recruitment Letter
	[4998]=":837:4:2:1:::1:0:", -- Blood Ring
	[4999]=":1052:4:2:1:::1:0:", -- Azora\'s Will
	[5001]=":1038:4:2:1:::1:0:", -- Heart Ring
	[5002]=":1535:4:2:1:::1:0:", -- Glowing Green Talisman
	[5003]=":1713:4:2:1:::1:0:", -- Crystal Starfire Medallion
	[5005]=":1840:4:2:1:::1:0:", -- Emberspark Pendant
	[5006]="::12:1:1:::1:0:", -- Khazgorm\'s Journal
	[5007]=":1632:4:2:1:::1:0:", -- Band of Thorns
	[5009]=":1696:4:2:1:::1:0:", -- Mindbender Loop
	[5011]=":1912:4:2:1:::1:0:", -- Welken Ring
	[5012]="::12:1:20:::1:0:", -- Fungal Spores
	[5016]=":2955:4:2:1:::1:0:", -- Artisan\'s Trousers
	[5017]="::12:1:20:::1:0:", -- Nitroglycerin
	[5018]="::12:1:20:::1:0:", -- Wood Pulp
	[5019]="::12:1:20:::1:0:", -- Sodium Nitrate
	[5020]=":3:13:1:1:::1:0:", -- Kolkar Booty Key
	[5021]="::12:1:1:::1:0:", -- Explosive Stick of Gann
	[5022]="::12:1:1:::1:0:", -- Barak\'s Head
	[5023]="::12:1:1:::1:0:", -- Verog\'s Head
	[5025]="::12:1:1:::1:0:", -- Hezrul\'s Head
	[5026]="::12:1:1:::1:0:", -- Fire Tar
	[5027]="::12:1:1:::1:0:", -- Rendered Spores
	[5028]=":5537:4:2:1:::1:0:", -- Lord Sakrasis\' Scepter
	[5029]=":5282:4:2:1:::1:0:", -- Talisman of the Naga Lord
	[5030]="::12:1:20:::1:0:", -- Centaur Bracers
	[5038]="::12:1:1:::1:0:", -- Tear of the Moons
	[5040]="::2:1:1:::1:0:", -- Shadow Hunter Knife
	[5042]="50:12:15:1:10:::1:0:3186,3313,19197,1285,16260,17421,18810,17446,16444,3481,16187,1682,2140,16259,151,3164,1691,2134,8362,4182,3608,1250,4170,3076,17489,4241,16191,1685,491,16732", -- Red Ribboned Wrapping Paper
	[5043]="::15:1:1:::1:0:", -- Red Ribboned Gift
	[5044]="::15:1:1:::1:0:", -- Blue Ribboned Gift
	[5048]="50:12:15:1:10:::1:0:3313,4555,19197,8362,1285,791,4082,18811,7942,17489,12027,3498,16191,4084,16732,12960", -- Blue Ribboned Wrapping Paper
	[5050]="::13:1:1:::1:0:", -- Ignition Key
	[5051]=":1:12:1:20::185:1:0:", -- Dig Rat
	[5052]="::15:1:1:::1:0:", -- Unconscious Dig Rat
	[5054]="::12:1:1:::1:0:", -- Samophlange
	[5055]="::12:1:20:::1:0:", -- Intact Raptor Horn
	[5056]="::12:1:20:::1:0:", -- Root Sample
	[5057]=":1:0:1:20:::1:0:", -- Ripe Watermelon
	[5058]="::12:1:20:::1:0:", -- Silithid Egg
	[5059]="::15:1:1:::1:0:", -- Digging Claw
	[5060]="1500::15:1:1:::1:0:16829,2622,12097,10364,3969,18019,6779,3090,1457,1325,5169,12096,3561,3490,16683,1326,5139,3135,15175,4585,16268,3551,18006,20121,3542,3334", -- Thieves\' Tools
	[5061]="::12:1:20:::1:0:", -- Stolen Silver
	[5062]="::12:1:20:::1:0:", -- Raptor Head
	[5063]="::12:1:1:::1:0:", -- Kreenig Snarlsnout\'s Tusk
	[5064]="::12:1:20:::1:0:", -- Witchwing Talon
	[5065]="::12:1:20:::1:0:", -- Harpy Lieutenant Ring
	[5066]=":21:0:1:10:::1:0:", -- Fissure Plant
	[5067]="::12:1:1:::1:0:", -- Serena\'s Head
	[5068]="::12:1:1:::1:0:", -- Dried Seeds
	[5069]=":293:2:2:1:::1:0:", -- Fire Wand
	[5071]=":443:2:2:1:::1:0:", -- Shadow Wand
	[5072]="::12:1:1:::1:0:", -- Lok\'s Skull
	[5073]="::12:1:1:::1:0:", -- Nak\'s Skull
	[5074]="::12:1:1:::1:0:", -- Kuz\'s Skull
	[5075]=":25:12:1:10:::1:0:", -- Blood Shard
	[5076]="::12:1:20:::1:0:", -- Shipment of Boots
	[5077]="::12:1:20:::1:0:", -- Telescopic Lens
	[5078]="::12:1:20:::1:0:", -- Theramore Medal
	[5079]=":4642:4:2:1:::1:0:", -- Cold Basilisk Eye
	[5080]="::12:1:10:::1:0:", -- Gazlowe\'s Ledger
	[5081]=":250:1:1:1:::1:0:", -- Kodo Hide Bag
	[5082]=":25:7:1:10::165:1:0:", -- Thin Kodo Leather
	[5083]=":50:9:2:1:::1:0:", -- Pattern: Kodo Hide Bag
	[5084]="::12:1:1:::1:0:", -- Baron Longshore\'s Head
	[5085]="::12:1:20:::1:0:", -- Bristleback Quilboar Tusk
	[5086]="::12:1:20:::1:0:", -- Zhevra Hooves
	[5087]="::12:1:20:::1:0:", -- Plainstrider Beak
	[5088]="::12:1:1:::1:0:", -- Control Console Operating Manual
	[5089]="::13:1:1:::1:0:", -- Console Key
	[5092]=":240:2:1:1:::1:0:", -- Charred Razormane Wand
	[5093]=":247:2:1:1:::1:0:", -- Razormane Backstabber
	[5094]=":233:4:1:1:::1:0:", -- Razormane War Shield
	[5095]=":3:0:1:20:::1:0:", -- Rainbow Fin Albacore
	[5096]="::12:1:20:::1:0:", -- Prowler Claws
	[5097]="::12:1:1:::1:0:", -- Cats Eye Emerald
	[5098]="::12:1:20:::1:0:", -- Altered Snapjaw Shell
	[5099]="::12:1:1:::1:0:", -- Hoof of Lakota\'mani
	[5100]="::12:1:1:::1:0:", -- Echeyakee\'s Hide
	[5101]="::12:1:1:::1:0:", -- Ishamuhale\'s Fang
	[5102]="::12:1:1:::1:0:", -- Owatanka\'s Tailspike
	[5103]="::12:1:1:::1:0:", -- Washte Pawne\'s Feather
	[5104]="::12:1:1:::1:0:", -- Heart of Isha Awak
	[5107]=":139:4:1:1:::1:0:", -- Deckhand\'s Shirt
	[5109]=":223:4:1:1:::1:0:", -- Stonesplinter Rags
	[5110]=":257:4:1:1:::1:0:", -- Dalaran Wizard\'s Robe
	[5111]=":212:4:2:1:::1:0:", -- Rathorian\'s Cape
	[5112]=":730:2:2:1:::1:0:", -- Ritual Blade
	[5113]=":250:15:0:5:::1:0:", -- Mark of the Syndicate
	[5114]=":96:15:0:5:::1:0:", -- Severed Talon
	[5115]=":101:15:0:5:::1:0:", -- Broken Wishbone
	[5116]=":303:7:1:10::165:1:0:", -- Long Tail Feather
	[5117]=":825:12:1:10:::1:0:", -- Vibrant Plume
	[5118]=":71:15:0:10:::1:0:", -- Large Flat Tooth
	[5119]=":118:15:0:10:::1:0:", -- Fine Loose Hair
	[5120]=":193:15:0:5:::1:0:", -- Long Tail Hair
	[5121]=":162:15:0:5:::1:0:", -- Dirty Kodo Scale
	[5122]=":287:15:0:10:::1:0:", -- Thick Kodo Hair
	[5123]=":117:15:0:5:::1:0:", -- Steel Arrowhead
	[5124]=":117:15:0:10:::1:0:", -- Small Raptor Tooth
	[5125]=":155:15:0:5:::1:0:", -- Charged Scale
	[5128]=":202:15:0:5:::1:0:", -- Shed Lizard Skin
	[5133]=":300:15:0:5:::1:0:", -- Seeping Gizzard
	[5134]=":92:12:1:5:::1:0:", -- Small Furry Paw
	[5135]=":142:15:0:5:::1:0:", -- Thin Black Claw
	[5136]=":177:15:0:5:::1:0:", -- Torn Furry Ear
	[5137]=":217:15:0:5:::1:0:", -- Bright Eyeball
	[5138]="::12:1:1:::1:0:", -- Harvester\'s Head
	[5140]="25:6:15:1:20::-4:1:0:19239,16829,2622,20986,20915,23405,1325,5169,3561,16683,3490,20081,5139,16588,4585,16268,19679,23373,19013,19049,20121,3334,10364,12097,3969,25633,18019,6779,22479,23145,3090,1457,25043,26304,12096,1326,3135,15175,20194,23151,18802,3551,18006,19014,3542", -- Flash Powder
	[5143]="::12:1:20:::1:0:", -- Thunder Lizard Blood
	[5164]="::12:1:1:::1:0:", -- Thunderhawk Wings
	[5165]="::12:1:20:::1:0:", -- Sunscale Feather
	[5166]="::12:1:20:::1:0:", -- Webwood Venom Sac
	[5167]="::12:1:20:::1:0:", -- Webwood Egg
	[5168]="::12:1:20:::1:0:", -- Timberling Seed
	[5169]="::12:1:20:::1:0:", -- Timberling Sprout
	[5170]="::12:1:20:::1:0:", -- Mossy Tumor
	[5173]="100:25:15:1:20::-4:1:0:19239,16829,2622,20986,20915,1325,5169,3561,16683,3490,20081,5139,16588,4585,16268,19679,23373,19013,19049,20121,3334,10364,12097,3969,25633,18019,6779,22479,23145,1457,3090,25043,12096,1326,3135,15175,20194,18802,3551,18006,19014,3542", -- Deathweed
	[5175]="::15:1:1:::1:0:", -- Earth Totem
	[5176]="::15:1:1:::1:0:", -- Fire Totem
	[5177]="::15:1:1:::1:0:", -- Water Totem
	[5178]="::15:1:1:::1:0:", -- Air Totem
	[5179]="::12:1:1:::1:0:", -- Moss-twined Heart
	[5180]=":2777:4:2:1:::1:0:", -- Necklace of Harmony
	[5181]=":1778:4:2:1:::1:0:", -- Vibrant Silk Cape
	[5182]=":1769:2:2:1:::1:0:", -- Shiver Blade
	[5183]=":1575:4:3:1:::1:0:", -- Pulsating Hydra Heart
	[5184]="::12:1:1:::1:0:", -- Filled Crystal Phial
	[5185]="::12:1:1:::1:0:", -- Crystal Phial
	[5186]="::12:1:1:::1:0:", -- Partially Filled Vessel
	[5187]=":2163:2:3:1:::1:0:", -- Rhahk\'Zor\'s Hammer
	[5188]="::12:1:1:::1:0:", -- Filled Vessel
	[5189]="::12:1:1:::1:0:", -- Glowing Fruit
	[5190]="::12:1:1:::1:0:", -- Shimmering Frond
	[5191]=":2964:2:3:1:::1:0:", -- Cruel Barb
	[5192]=":2163:2:3:1:::1:0:", -- Thief\'s Blade
	[5193]=":940:4:3:1:::1:0:", -- Cape of the Brotherhood
	[5194]=":3079:2:3:1:::1:0:", -- Taskmaster Axe
	[5195]=":437:4:3:1:::1:0:", -- Gold-flecked Gloves
	[5196]=":2196:2:3:1:::1:0:", -- Smite\'s Reaver
	[5197]=":1917:2:3:1:::1:0:", -- Cookie\'s Tenderizer
	[5198]=":1660:2:3:1:::1:0:", -- Cookie\'s Stirring Rod
	[5199]=":966:4:3:1:::1:0:", -- Smelting Pants
	[5200]=":2787:2:3:1:::1:0:", -- Impaling Harpoon
	[5201]=":3161:2:3:1:::1:0:", -- Emberstone Staff
	[5202]=":1147:4:3:1:::1:0:", -- Corsair\'s Overshirt
	[5203]="::12:1:20:::1:0:", -- Flatland Prowler Claw
	[5204]="::12:1:20:::1:0:", -- Bloodfeather Belt
	[5205]=":31:0:1:10:::1:0:", -- Sprouted Frond
	[5206]=":37:0:1:10:::1:0:", -- Bogling Root
	[5207]=":1081:2:2:1:::1:0:", -- Opaque Wand
	[5208]="3340:668:2:1:1:::1:0:5754,1312,19236,16769,16632,5816,16636,5133", -- Smoldering Wand
	[5209]="3855:771:2:1:1:::1:0:5754,1312,19236,16769,16632,5816,16636,5133", -- Gloom Wand
	[5210]="5808:1161:2:1:1:::1:0:5754,1312,19236,16769,16632,5816,16636,5133", -- Burning Wand
	[5211]="5830:1166:2:1:1:::1:0:5754,1312,19236,16769,16632,5816,16636,5133", -- Dusk Wand
	[5212]=":672:2:2:1:::1:0:", -- Blazing Wand
	[5213]=":5218:2:2:1:::1:0:", -- Scorching Wand
	[5214]=":3935:2:2:1:::1:0:", -- Wand of Eventide
	[5215]=":8656:2:2:1:::1:0:", -- Ember Wand
	[5216]=":11821:2:2:1:::1:0:", -- Umbral Wand
	[5217]="::12:1:1:::1:0:", -- Tainted Heart
	[5218]="::12:1:1:::1:0:", -- Cleansed Timberling Heart
	[5219]="::12:1:1:::1:0:", -- Inscribed Bark
	[5221]="::12:1:1:::1:0:", -- Melenas\' Head
	[5232]="::0:1:1:::1:0:", -- Minor Soulstone
	[5233]="::12:1:1:::1:0:", -- Stone of Relu
	[5234]="::12:1:1:::1:0:", -- Flagongut\'s Fossil
	[5236]="14394:2878:2:1:1:::1:0:5754,1312,19236,16769,16632,5816,16636,5133", -- Combustible Wand
	[5237]=":18:0:1:20:::1:0:", -- Mind-numbing Poison
	[5238]="35727:7145:2:1:1:::1:0:5754,1312,19236,16769,16632,5816,16636,5133", -- Pitchwood Wand
	[5239]="38731:7746:2:1:1:::1:0:5754,1312,19236,16769,16632,5816,16636,5133", -- Blackbone Wand
	[5240]=":1244:2:2:1:::1:0:", -- Torchlight Wand
	[5241]=":821:2:2:1:::1:0:", -- Dwarven Flamestick
	[5242]=":623:2:2:1:::1:0:", -- Cinder Wand
	[5243]=":1312:2:3:1:::1:0:", -- Firebelcher
	[5244]=":3465:2:2:1:::1:0:", -- Consecrated Wand
	[5245]=":5091:2:2:1:::1:0:", -- Summoner\'s Wand
	[5246]=":3490:2:2:1:::1:0:", -- Excavation Rod
	[5247]=":7961:2:2:1:::1:0:", -- Rod of Sorrow
	[5248]=":6849:2:2:1:::1:0:", -- Flash Wand
	[5249]=":8658:2:2:1:::1:0:", -- Burning Sliver
	[5250]=":2646:2:2:1:::1:0:", -- Charred Wand
	[5251]="::12:1:1:::1:0:", -- Phial of Scrying
	[5252]=":1175:2:2:1:::1:0:", -- Wand of Decay
	[5253]=":7952:2:2:1:::1:0:", -- Goblin Igniter
	[5254]=":618:4:3:1:::1:0:", -- Rugged Spaulders
	[5256]=":7227:2:2:1:::1:0:", -- Kovork\'s Rattle
	[5257]=":3159:4:3:1:::1:0:", -- Dark Hooded Cape
	[5263]=":1:15:0:10:::1:0:", -- Pocket Lint
	[5266]=":11157:4:3:1:::1:0:", -- Eye of Adaegus
	[5267]=":53869:2:3:1:::1:0:", -- Scarlet Kris
	[5268]=":218:15:0:5:::1:0:", -- Cracked Silithid Shell
	[5269]=":95:15:0:5:::1:0:", -- Silithid Ichor
	[5270]="::12:1:20:::1:0:", -- Death Cap
	[5271]="::12:1:20:::1:0:", -- Scaber Stalk
	[5272]="::12:1:1:::1:0:", -- Insane Scribbles
	[5273]="::12:1:20:::1:0:", -- Mathystra Relic
	[5274]=":1003:4:2:1:::1:0:", -- Rose Mantle
	[5275]=":176:4:2:1:::1:0:", -- Binding Girdle
	[5279]=":1437:2:2:1:::1:0:", -- Harpy Skinner
	[5299]=":359:4:2:1:::1:0:", -- Gloves of the Moon
	[5302]=":929:4:2:1:::1:0:", -- Cobalt Buckler
	[5306]=":1710:2:2:1:::1:0:", -- Wind Rider Staff
	[5309]=":1038:2:2:1:::1:0:", -- Privateer Musket
	[5310]=":555:4:2:1:::1:0:", -- Sea Dog Britches
	[5311]=":601:4:2:1:::1:0:", -- Buckled Boots
	[5312]=":420:4:2:1:::1:0:", -- Riveted Gauntlets
	[5313]=":650:4:2:1:::1:0:", -- Totemic Clan Ring
	[5314]=":423:4:2:1:::1:0:", -- Boar Hunter\'s Cape
	[5315]=":214:4:2:1:::1:0:", -- Timberland Armguards
	[5316]=":1355:4:2:1:::1:0:", -- Barkshell Tunic
	[5317]=":1360:4:2:1:::1:0:", -- Dry Moss Tunic
	[5318]=":1789:2:2:1:::1:0:", -- Zhovur Axe
	[5319]=":323:4:1:1:::1:0:", -- Bashing Pauldrons
	[5320]=":372:4:2:1:::1:0:", -- Padded Lamellar Boots
	[5321]=":1484:2:2:1:::1:0:", -- Elegant Shortsword
	[5322]=":4016:2:2:1:::1:0:", -- Demolition Hammer
	[5323]=":1632:4:2:1:::1:0:", -- Everglow Lantern
	[5324]=":776:2:2:1:::1:0:", -- Engineer\'s Hammer
	[5325]=":498:4:2:1:::1:0:", -- Welding Shield
	[5326]=":776:2:2:1:::1:0:", -- Flaring Baton
	[5327]=":519:4:2:1:::1:0:", -- Greasy Tinker\'s Pants
	[5328]=":205:4:2:1:::1:0:", -- Cinched Belt
	[5329]=":15:15:0:20:::1:0:", -- Cat Figurine
	[5332]=":15:15:1:1:::1:0:", -- Glowing Cat Figurine
	[5334]="::12:1:1:::1:0:", -- 99-Year-Old Port
	[5335]="::15:1:1:::1:0:", -- A Sack of Coins
	[5336]="::12:1:20:::1:0:", -- Grell Earring
	[5337]=":167:4:2:1:::1:0:", -- Wayfaring Gloves
	[5338]="::12:1:1:::1:0:", -- Ancient Moonstone Seal
	[5339]="::12:1:20:::1:0:", -- Serpentbloom
	[5340]=":919:2:2:1:::1:0:", -- Cauldron Stirrer
	[5341]=":369:4:2:1:::1:0:", -- Spore-covered Tunic
	[5342]=":88:0:1:10:::1:0:", -- Raptor Punch
	[5343]=":306:4:2:1:::1:0:", -- Barkeeper\'s Cloak
	[5344]=":562:2:2:1:::1:0:", -- Pointed Axe
	[5345]=":705:2:2:1:::1:0:", -- Stonewood Hammer
	[5346]=":425:2:2:1:::1:0:", -- Orcish Battle Bow
	[5347]="15713:3142:2:1:1:::1:0:5754,1312,19236,16769,16632,5816,16636,5133", -- Pestilent Wand
	[5348]="::12:1:20:::1:0:", -- Worn Parchment
	[5349]="::0:1:20:::1:0:", -- Conjured Muffin
	[5350]="::0:1:20:::1:0:", -- Conjured Water
	[5351]=":403:4:2:1:::1:0:", -- Bounty Hunter\'s Ring
	[5352]="::12:1:1:::1:0:", -- Book: The Powers Below
	[5354]="::12:1:1:::1:0:", -- Letter to Delgren
	[5355]=":947:4:2:1:::1:0:", -- Beastmaster\'s Girdle
	[5356]=":2594:2:2:1:::1:0:", -- Branding Rod
	[5357]=":2221:4:2:1:::1:0:", -- Ward of the Vale
	[5359]="::12:1:1:::1:0:", -- Lorgalis Manuscript
	[5360]="::12:1:20:::1:0:", -- Highborne Relic
	[5361]=":16:15:0:10:::1:0:", -- Fishbone Toothpick
	[5362]=":18:15:0:5:::1:0:", -- Chew Toy
	[5363]=":20:15:0:5:::1:0:", -- Folded Handkerchief
	[5364]=":27:15:0:5:::1:0:", -- Dry Salt Lick
	[5366]="::12:1:1:::1:0:", -- Glowing Soul Gem
	[5367]=":22:15:0:5:::1:0:", -- Primitive Rock Tool
	[5368]=":48:15:0:5:::1:0:", -- Empty Wallet
	[5369]=":32:15:0:5:::1:0:", -- Gnawed Bone
	[5370]=":37:15:0:5:::1:0:", -- Bent Spoon
	[5371]=":48:15:0:5:::1:0:", -- Piece of Coral
	[5373]=":72:15:1:5::165:1:0:", -- Lucky Charm
	[5374]=":87:15:0:5:::1:0:", -- Small Pocket Watch
	[5375]=":95:15:0:5:::1:0:", -- Scratching Stick
	[5376]=":66:15:0:5:::1:0:", -- Broken Mirror
	[5377]=":57:15:0:5:::1:0:", -- Scallop Shell
	[5379]="::15:0:200:::1:0:", -- Broken Boot Knife
	[5382]="::12:1:1:::1:0:", -- Anaya\'s Pendant
	[5383]="::12:1:1:::1:0:", -- Athrikus Narassin\'s Head
	[5385]="::12:1:20:::1:0:", -- Crawler Leg
	[5386]="::12:1:20:::1:0:", -- Fine Moonstalker Pelt
	[5387]="::4:2:1:::1:0:", -- Enchanted Moonstalker Cloak
	[5388]="::12:1:1:::1:0:", -- Ran Bloodtooth\'s Skull
	[5390]="::12:1:1:::1:0:", -- Fandral\'s Message
	[5391]="::12:1:1:::1:0:", -- Rare Earth
	[5392]=":25:2:1:1:::1:0:", -- Thistlewood Dagger
	[5393]=":32:2:1:1:::1:0:", -- Thistlewood Staff
	[5394]=":6:4:1:1:::1:0:", -- Archery Training Gloves
	[5395]=":16:4:1:1:::1:0:", -- Woodland Shield
	[5396]="::13:1:1:::1:0:", -- Key to Searing Gorge
	[5397]="::15:1:1:::1:0:", -- Defias Gunpowder
	[5398]=":13:4:1:1:::1:0:", -- Canopy Leggings
	[5399]=":11:4:1:1:::1:0:", -- Tracking Boots
	[5404]=":938:4:3:1:::1:0:", -- Serpent\'s Shoulders
	[5405]=":7:4:1:1:::1:0:", -- Draped Cloak
	[5411]="::4:1:1:::1:0:", -- Winterhoof Cleansing Totem
	[5412]="::12:1:20:::1:0:", -- Thresher Eye
	[5413]="::12:1:20:::1:0:", -- Moonstalker Fang
	[5414]="::12:1:20:::1:0:", -- Grizzled Scalp
	[5415]="::12:1:1:::1:0:", -- Thunderhorn Cleansing Totem
	[5416]="::12:1:1:::1:0:", -- Wildmane Cleansing Totem
	[5419]=":13:4:1:1:::1:0:", -- Feral Bracers
	[5420]=":227:4:2:1:::1:0:", -- Banshee Armor
	[5421]=":650:0:1:1:::1:0:", -- Fiery Blaze Enchantment
	[5422]=":692:4:2:1:::1:0:", -- Brambleweed Leggings
	[5423]=":2084:2:3:1:::1:0:", -- Boahn\'s Fang
	[5424]="::12:1:1:::1:0:", -- Ancient Statuette
	[5425]=":504:4:3:1:::1:0:", -- Runescale Girdle
	[5426]=":1686:2:3:1:::1:0:", -- Serpent\'s Kiss
	[5427]=":147:15:0:5:::1:0:", -- Crude Pocket Watch
	[5428]=":322:15:0:5:::1:0:", -- An Exotic Cookbook
	[5429]=":137:15:0:5:::1:0:", -- A Pretty Rock
	[5430]=":277:15:0:5:::1:0:", -- Intricate Bauble
	[5431]=":155:15:0:5:::1:0:", -- Empty Hip Flask
	[5432]=":330:15:0:5:::1:0:", -- Hickory Pipe
	[5433]=":138:15:0:5:::1:0:", -- Rag Doll
	[5435]=":272:15:0:5:::1:0:", -- Shiny Dinglehopper
	[5437]="::12:1:20:::1:0:", -- Bathran\'s Hair
	[5439]="100:25:11:1:1:::1:0:3589,4604,9553,1198,4173,1668,1462,3410,6028,3015,10369,19020,789,3951,4203,9552,5122,4892,1687,3610,3409,9555,3488,14301,16715,2839,1298,9551,1297,228,9549,12029,16619,9548,16274,1459,17667,17598,3165,16919,19561,16263", -- Small Quiver
	[5440]="::12:1:1:::1:0:", -- Bottle of Disease
	[5441]="1000:250:11:1:1:::1:0:1469,3078,5123,1686,2997,9551,16620,7976,1297,3322,3018,16735,5510,1243,16274,3488,3088,4603", -- Small Shot Pouch
	[5442]="::12:1:1:::1:0:", -- Head of Arugal
	[5443]=":1067:4:3:1:::1:0:", -- Gold-plated Buckler
	[5444]=":436:4:3:1:::1:0:", -- Miner\'s Cape
	[5445]="::12:1:1:::1:0:", -- Ring of Zoram
	[5446]=":13:15:0:20:::1:0:", -- Broken Elemental Bracer
	[5447]=":20:15:0:20:::1:0:", -- Damaged Elemental Bracer
	[5448]=":17:15:0:20:::1:0:", -- Fractured Elemental Bracer
	[5451]=":22:15:0:20:::1:0:", -- Crushed Elemental Bracer
	[5455]="::12:1:1:::1:0:", -- Divined Scroll
	[5456]="::12:1:1:::1:0:", -- Divining Scroll
	[5457]=":23:0:1:10:::1:0:", -- Severed Voodoo Claw
	[5458]=":27:4:1:1:::1:0:", -- Dirtwood Belt
	[5459]=":472:2:2:1:::1:0:", -- Defender Axe
	[5460]="::12:1:1:::1:0:", -- Orendil\'s Cure
	[5461]="::12:1:1:::1:0:", -- Branch of Cenarius
	[5462]="::12:1:1:::1:0:", -- Dartol\'s Rod of Transformation
	[5463]="::12:1:1:::1:0:", -- Glowing Gem
	[5464]="::12:1:1:::1:0:", -- Iron Shaft
	[5465]=":3:7:1:10::185:1:0:", -- Small Spider Leg
	[5466]=":8:7:1:10::185:1:0:", -- Scorpid Stinger
	[5467]=":7:7:1:10::185:1:0:", -- Kodo Meat
	[5468]=":12:7:1:10::185:1:0:", -- Soft Frenzy Flesh
	[5469]=":9:7:1:10::185:1:0:", -- Strider Meat
	[5470]=":28:7:1:10::185:1:0:", -- Thunder Lizard Tail
	[5471]=":30:7:1:10::185:1:0:", -- Stag Meat
	[5472]=":10:0:1:20:::1:0:", -- Kaldorei Spider Kabob
	[5473]=":10:0:1:20:::1:0:", -- Scorpid Surprise
	[5474]=":9:0:1:20:::1:0:", -- Roasted Kodo Meat
	[5475]="::13:1:1:::1:0:", -- Wooden Key
	[5476]=":3:0:1:20:::1:0:", -- Fillet of Frenzy
	[5477]=":18:0:1:20:::1:0:", -- Strider Stew
	[5478]=":70:0:1:20:::1:0:", -- Dig Rat Stew
	[5479]=":125:0:1:20:::1:0:", -- Crispy Lizard Tail
	[5480]=":95:0:1:20:::1:0:", -- Lean Venison
	[5481]="::12:1:20:::1:0:", -- Satyr Horns
	[5482]=":10:9:1:1:::1:0:", -- Recipe: Kaldorei Spider Kabob
	[5483]="140:35:9:1:1:::1:0:3881", -- Recipe: Scorpid Surprise
	[5484]="240:60:9:1:1:::1:0:3081", -- Recipe: Roasted Kodo Meat
	[5485]="400:100:9:1:1:::1:0:4200", -- Recipe: Fillet of Frenzy
	[5486]="440:110:9:1:1:::1:0:3482", -- Recipe: Strider Stew
	[5487]=":200:9:1:1:::1:0:", -- Recipe: Dig Rat Stew
	[5488]="400:100:9:1:1:::1:0:3482", -- Recipe: Crispy Lizard Tail
	[5489]="1200:300:9:1:1:::1:0:3960,12245", -- Recipe: Lean Venison
	[5490]="::12:1:20:::1:0:", -- Wrathtail Head
	[5493]="::12:1:1:::1:0:", -- Elune\'s Tear
	[5494]="::12:1:20:::1:0:", -- Handful of Stardust
	[5498]=":200:3:2:20::164,755,165,197:1:0:", -- Small Lustrous Pearl
	[5500]=":750:3:2:20::164,333,165,197:1:0:", -- Iridescent Pearl
	[5503]=":16:7:1:10::185:1:0:", -- Clam Meat
	[5504]=":22:7:1:10::185:1:0:", -- Tangy Clam Meat
	[5505]="::12:1:1:::1:0:", -- Teronis\' Journal
	[5506]=":71:15:0:5:::1:0:", -- Beady Eye Stalk
	[5507]=":600:7:1:1:::1:0:", -- Ornate Spyglass
	[5508]="::12:1:1:::1:0:", -- Fallen Moonstone
	[5509]="::0:1:1:::1:0:", -- Healthstone
	[5510]="::0:1:1:::1:0:", -- Greater Healthstone
	[5511]="::0:1:1:::1:0:", -- Lesser Healthstone
	[5512]="::0:1:1:::1:0:", -- Minor Healthstone
	[5513]="::0:1:1:::1:0:", -- Mana Jade
	[5514]="::4:1:1:::1:0:", -- Mana Agate
	[5516]=":317:2:0:1:::1:0:", -- Threshadon Fang
	[5519]="::12:1:1:::1:0:", -- Iron Pommel
	[5520]="::12:1:1:::1:0:", -- Velinde\'s Journal
	[5521]="::13:1:1:::1:0:", -- Velinde\'s Key
	[5522]="::4:1:1:::1:0:", -- Spellstone
	[5523]=":15:7:1:1:::1:0:", -- Small Barnacled Clam
	[5524]=":21:7:1:1:::1:0:", -- Thick-shelled Clam
	[5525]=":20:0:1:20:::1:0:", -- Boiled Clams
	[5526]=":75:0:1:20:::1:0:", -- Clam Chowder
	[5527]=":95:0:1:20:::1:0:", -- Goblin Deviled Clams
	[5528]="800:200:9:1:1:::1:0:4305,4307", -- Recipe: Clam Chowder
	[5529]=":125:15:0:20:::1:0:", -- Tomb Dust
	[5530]=":125:15:0:20:::1:0:", -- Blinding Powder
	[5533]="::12:1:1:::1:0:", -- Ilkrud Magthrull\'s Tome
	[5534]="::12:1:1:::1:0:", -- Parker\'s Lunch
	[5535]="::12:1:1:::1:0:", -- Compendium of the Fallen
	[5536]="::12:1:1:::1:0:", -- Mythology of the Titans
	[5537]="::12:1:1:::1:0:", -- Sarilus Foulborne\'s Head
	[5538]="::12:1:1:::1:0:", -- Vorrel\'s Wedding Ring
	[5539]="::12:1:1:::1:0:", -- Letter of Commendation
	[5540]=":2107:2:2:1:::1:0:", -- Pearl-handled Dagger
	[5541]=":3694:2:2:1:::1:0:", -- Iridescent Hammer
	[5542]=":370:4:2:1:::1:0:", -- Pearl-clasped Cloak
	[5543]=":450:9:2:1:::1:0:", -- Plans: Iridescent Hammer
	[5544]="::12:1:1:::1:0:", -- Dal Bloodclaw\'s Skull
	[5547]="::12:1:1:::1:0:", -- Reconstructed Rod
	[5565]="5000:1250:15:1:5::-9:1:0:26744,4878,26751,24843,20915,4220,26758,26765,19235,5139,16588,3323,16612,8361,1308,4083,983,3700,25039,19679,26754,26752,23373,18017,26743,25010,16757,3500,5151,3970,12097,1463,25633,18019,25082,26756,20092,26759,17518,16611,2805,18243,3335,3562,15175,1275,18006,19014,4562,3542,26747,26741,26739,4575,16829,1307,14739,23405,26753,26742,25051,26748,958,3490,20081,13476,3351,19004,18998,17078,23157,1673,1351,19013,24995,26745,26757,23112,1257,10364,19535,23560,22479,26724,23145,26749,26304,12096,16015,5110,26755,26738,23151,16706,18802,24935,19718,26740,19678,25019", -- Infernal Stone
	[5566]=":105:15:0:5:::1:0:", -- Broken Antler
	[5567]=":196:15:0:5:::1:0:", -- Silver Hook
	[5568]=":4:6:1:200:::1:0:", -- Smooth Pebble
	[5569]=":203:15:0:5:::1:0:", -- Seaweed
	[5570]="::12:1:20:::1:0:", -- Deepmoss Egg
	[5571]=":250:1:1:1:::1:0:", -- Small Black Pouch
	[5572]=":250:1:1:1:::1:0:", -- Small Green Pouch
	[5573]=":875:1:1:1:::1:0:", -- Green Leather Bag
	[5574]=":875:1:1:1:::1:0:", -- White Leather Bag
	[5575]=":2500:1:1:1:::1:0:", -- Large Green Sack
	[5576]=":2500:1:1:1:::1:0:", -- Large Brown Sack
	[5578]=":300:9:2:1:::1:0:", -- Plans: Silvered Bronze Breastplate
	[5579]=":32:2:1:1:::1:0:", -- Militia Warhammer
	[5580]=":25:2:1:1:::1:0:", -- Militia Hammer
	[5581]=":32:2:1:1:::1:0:", -- Smooth Walking Staff
	[5582]="::12:1:20:::1:0:", -- Stonetalon Sap
	[5583]="::12:1:20:::1:0:", -- Fey Dragon Scale
	[5584]="::12:1:20:::1:0:", -- Twilight Whisker
	[5585]="::12:1:20:::1:0:", -- Courser Eye
	[5586]=":26:2:1:1:::1:0:", -- Thistlewood Blade
	[5587]=":512:2:2:1:::1:0:", -- Thornroot Club
	[5588]="::12:1:1:::1:0:", -- Lydon\'s Toxin
	[5589]=":41:4:1:1:::1:0:", -- Moss-covered Gauntlets
	[5590]=":36:4:1:1:::1:0:", -- Cord Bracers
	[5591]=":54:4:1:1:::1:0:", -- Rain-spotted Cape
	[5592]=":54:4:1:1:::1:0:", -- Shackled Girdle
	[5593]=":116:4:1:1:::1:0:", -- Crag Buckler
	[5594]="::12:1:1:::1:0:", -- Letter to Jin\'Zil
	[5595]=":235:2:1:1:::1:0:", -- Thicket Hammer
	[5596]=":141:2:1:1:::1:0:", -- Ashwood Bow
	[5601]=":22:15:0:10:::1:0:", -- Hatched Egg Sac
	[5602]=":63:15:0:10:::1:0:", -- Sticky Spider Webbing
	[5604]=":380:2:2:1:::1:0:", -- Elven Wand
	[5605]=":150:2:1:1:::1:0:", -- Pruning Knife
	[5606]=":23:4:1:1:::1:0:", -- Gardening Gloves
	[5608]=":3463:4:2:1:::1:0:", -- Living Cowl
	[5609]=":447:4:2:1:::1:0:", -- Steadfast Cinch
	[5610]=":208:4:2:1:::1:0:", -- Gustweald Cloak
	[5611]=":452:4:2:1:::1:0:", -- Tear of Grief
	[5612]=":72:4:1:1:::1:0:", -- Ivy Cuffs
	[5613]=":2635:2:2:1:::1:0:", -- Staff of the Purifier
	[5614]=":6147:2:2:1:::1:0:", -- Seraph\'s Strike
	[5615]=":1776:2:2:1:::1:0:", -- Woodsman Sword
	[5616]=":22738:2:3:1:::1:0:", -- Gutwrencher
	[5617]=":247:4:2:1:::1:0:", -- Vagabond Leggings
	[5618]=":57:4:1:1:::1:0:", -- Scout\'s Cloak
	[5619]="::12:1:1:::1:0:", -- Jade Phial
	[5620]="::12:1:20:::1:0:", -- Vial of Innocent Blood
	[5621]="::12:1:1:::1:0:", -- Tourmaline Phial
	[5622]=":556:4:2:1:::1:0:", -- Clergy Ring
	[5623]="::12:1:1:::1:0:", -- Amethyst Phial
	[5624]=":2927:4:2:1:::1:0:", -- Circlet of the Order
	[5626]=":1717:2:2:1:::1:0:", -- Skullchipper
	[5627]=":1379:2:2:1:::1:0:", -- Relic Blade
	[5628]="::12:1:1:::1:0:", -- Zamah\'s Note
	[5629]=":347:4:2:1:::1:0:", -- Hammerfist Gloves
	[5630]=":348:4:2:1:::1:0:", -- Windfelt Gloves
	[5631]=":30:0:1:5:::1:0:", -- Rage Potion
	[5633]=":150:0:1:5::165:1:0:", -- Great Rage Potion
	[5634]=":75:0:1:5:::1:0:", -- Free Action Potion
	[5635]=":45:7:1:5::171,164:1:0:", -- Sharp Claw
	[5636]=":75:15:0:10:::1:0:", -- Delicate Feather
	[5637]=":75:7:1:5::171,164,333,755,165:1:0:", -- Large Fang
	[5638]="::12:1:1:::1:0:", -- Toxic Fogger
	[5639]="::12:1:1:::1:0:", -- Filled Jade Phial
	[5640]="100:25:9:1:1:::1:0:3499,3335,1685,1669", -- Recipe: Rage Potion
	[5642]="1800:450:9:1:1:::1:0:5178,12245,3348,4226", -- Recipe: Free Action Potion
	[5643]="2000:500:9:1:1:::1:0:3335,12245,4226", -- Recipe: Great Rage Potion
	[5645]="::12:1:1:::1:0:", -- Filled Tourmaline Phial
	[5646]="::12:1:1:::1:0:", -- Vial of Blessed Water
	[5655]="100000::15:3:1:::1:0:1460,384,2357,4885", -- Chestnut Mare Bridle
	[5656]="100000::15:3:1:::1:0:1460,384,2357,4885", -- Brown Horse Bridle
	[5659]="::12:1:20:::1:0:", -- Smoldering Embers
	[5664]="::12:1:20:::1:0:", -- Corroded Shrapnel
	[5665]="100000::15:3:1:::1:0:3362", -- Horn of the Dire Wolf
	[5668]="100000::15:3:1:::1:0:3362", -- Horn of the Brown Wolf
	[5669]="::12:1:1:::1:0:", -- Dust Devil Debris
	[5675]="::12:1:20:::1:0:", -- Crystalized Scales
	[5686]="::12:1:1:::1:0:", -- Ordanus\' Head
	[5687]="::13:1:1:::1:0:", -- Gatekeeper\'s Key
	[5689]="::13:1:1:::1:0:", -- Sleepers\' Key
	[5690]="::13:1:1:::1:0:", -- Claw Key
	[5691]="::13:1:1:::1:0:", -- Barrow Key
	[5692]="::12:1:1:::1:0:", -- Remote Detonator (Red)
	[5693]="::12:1:1:::1:0:", -- Remote Detonator (Blue)
	[5694]="::12:1:1:::1:0:", -- NG-5 Explosives (Red)
	[5695]="::12:1:1:::1:0:", -- NG-5 Explosives (Blue)
	[5717]="::12:1:1:::1:0:", -- Venture Co. Letters
	[5718]="::12:1:1:::1:0:", -- Venture Co. Engineering Plans
	[5731]="::12:1:1:::1:0:", -- Scroll of Messaging
	[5732]="::12:1:1:::1:0:", -- NG-5
	[5733]="::12:1:1:::1:0:", -- Unidentified Ore
	[5734]="::12:1:1:::1:0:", -- Super Reaper 6000 Blueprints
	[5735]="::12:1:1:::1:0:", -- Sealed Envelope
	[5736]="::12:1:1:::1:0:", -- Gerenzo\'s Mechanical Arm
	[5737]="::12:1:1:::1:0:", -- Covert Ops Plans: Alpha & Beta
	[5738]="::15:1:1:::1:0:", -- Covert Ops Pack
	[5739]=":2739:4:1:1:::1:0:", -- Barbaric Harness
	[5740]="100:25:0:1:5:::1:0:8117,1304,3180,8118,2838,8116,8122,23208,8121,5569,16650", -- Red Fireworks Rocket
	[5741]=":111:15:0:20:::1:0:", -- Rock Chip
	[5749]=":2664:2:2:1:::1:0:", -- Scythe Axe
	[5750]=":641:4:2:1:::1:0:", -- Warchief\'s Girdle
	[5751]=":822:4:2:1:::1:0:", -- Webwing Cloak
	[5752]=":3109:2:2:1:::1:0:", -- Wyvern Tailspike
	[5753]=":1884:4:2:1:::1:0:", -- Ruffled Chaplet
	[5754]=":2538:4:2:1:::1:0:", -- Wolfpack Medallion
	[5755]=":4127:4:2:1:::1:0:", -- Onyx Shredder Plate
	[5756]=":10026:2:3:1:::1:0:", -- Sliverblade
	[5757]=":1363:2:2:1:::1:0:", -- Hardwood Cudgel
	[5758]=":250:15:2:1:::1:0:", -- Mithril Lockbox
	[5759]=":375:15:2:1:::1:0:", -- Thorium Lockbox
	[5760]=":500:15:2:1:::1:0:", -- Eternium Lockbox
	[5761]=":30:2:1:1:::1:0:", -- Anvilmar Sledge
	[5762]=":250:1:1:1:::1:0:", -- Red Linen Bag
	[5763]=":700:1:1:1:::1:0:", -- Red Woolen Bag
	[5764]=":3000:1:1:1:::1:0:", -- Green Silk Pack
	[5765]=":4000:1:1:1:::1:0:", -- Black Silk Pack
	[5766]=":1338:4:2:1:::1:0:", -- Lesser Wizard\'s Robe
	[5767]=":44:4:1:1:::1:0:", -- Violet Robes
	[5770]=":1807:4:2:1:::1:0:", -- Robes of Arcana
	[5771]="200:50:9:1:1:::1:0:3556,4189,16224,843,3005", -- Pattern: Red Linen Bag
	[5772]="500:125:9:1:1:::1:0:3364,3537,3683,1454,3485,5944,4189,777,3005,1474,4577", -- Pattern: Red Woolen Bag
	[5773]=":250:9:2:1:::1:0:", -- Pattern: Robes of Arcana
	[5774]=":275:9:2:1:::1:0:", -- Pattern: Green Silk Pack
	[5775]=":350:9:2:1:::1:0:", -- Pattern: Black Silk Pack
	[5776]=":30:2:1:1:::1:0:", -- Elder\'s Cane
	[5777]=":30:2:1:1:::1:0:", -- Brave\'s Axe
	[5778]=":30:2:1:1:::1:0:", -- Primitive Walking Stick
	[5779]=":30:2:1:1:::1:0:", -- Forsaken Bastard Sword
	[5780]=":260:4:2:1:::1:0:", -- Murloc Scale Belt
	[5781]=":601:4:2:1:::1:0:", -- Murloc Scale Breastplate
	[5782]=":3211:4:2:1:::1:0:", -- Thick Murloc Armor
	[5783]=":2316:4:2:1:::1:0:", -- Murloc Scale Bracers
	[5784]=":75:7:1:10::165:1:0:", -- Slimy Murloc Scale
	[5785]=":500:7:1:10::165:1:0:", -- Thick Murloc Scale
	[5786]="550:137:9:1:1:::1:0:3556,4186,843", -- Pattern: Murloc Scale Belt
	[5787]="600:150:9:1:1:::1:0:3556,4186,843", -- Pattern: Murloc Scale Breastplate
	[5788]="650:162:9:2:1:::1:0:2381,2393,2846", -- Pattern: Thick Murloc Armor
	[5789]="2800:700:9:2:1:::1:0:2846,4897", -- Pattern: Murloc Scale Bracers
	[5790]="::12:1:1:::1:0:", -- Lonebrow\'s Journal
	[5791]="::12:1:1:::1:0:", -- Henrig Lonebrow\'s Journal
	[5792]="::12:1:1:::1:0:", -- Razorflank\'s Medallion
	[5793]="::12:1:1:::1:0:", -- Razorflank\'s Heart
	[5794]="::12:1:20:::1:0:", -- Salty Scorpid Venom
	[5795]="::12:1:20:::1:0:", -- Hardened Tortoise Shell
	[5796]="::12:1:20:::1:0:", -- Encrusted Tail Fin
	[5797]="::12:1:20:::1:0:", -- Indurium Flake
	[5798]="::12:1:20:::1:0:", -- Rocket Car Parts
	[5799]="::12:1:1:::1:0:", -- Kravel\'s Parts Order
	[5800]="::12:1:1:::1:0:", -- Kravel\'s Parts
	[5801]="::12:1:20:::1:0:", -- Kraul Guano
	[5802]="::12:1:1:::1:0:", -- Delicate Car Parts
	[5803]="::12:1:20:::1:0:", -- Speck of Dream Dust
	[5804]="::12:1:1:::1:0:", -- Goblin Rumors
	[5805]="::12:1:20:::1:0:", -- Heart of Zeal
	[5806]="::12:1:1:::1:0:", -- Fool\'s Stout
	[5807]="::12:1:1:::1:0:", -- Fool\'s Stout Report
	[5808]="::12:1:20:::1:0:", -- Pridewing Venom Sac
	[5809]="::12:1:20:::1:0:", -- Highperch Venom Sac
	[5810]="::12:1:1:::1:0:", -- Fresh Carcass
	[5811]="::12:1:1:::1:0:", -- Frostmaw\'s Mane
	[5812]=":1129:4:2:1:::1:0:", -- Robes of Antiquity
	[5813]=":7088:2:2:1:::1:0:", -- Emil\'s Brand
	[5814]=":2351:4:2:1:::1:0:", -- Snapbrook Armor
	[5815]=":5871:2:2:1:::1:0:", -- Glacial Stone
	[5816]=":405:0:1:1:::1:0:", -- Light of Elune
	[5817]=":3226:2:2:1:::1:0:", -- Lunaris Bow
	[5818]=":3239:2:2:1:::1:0:", -- Moonbeam Wand
	[5819]=":3201:4:3:1:::1:0:", -- Sunblaze Coif
	[5820]=":1623:4:2:1:::1:0:", -- Faerie Mantle
	[5824]="::12:1:1:::1:0:", -- Tablet of Will
	[5825]="::12:1:1:::1:0:", -- Treshala\'s Pendant
	[5826]="::12:1:1:::1:0:", -- Kravel\'s Scheme
	[5827]="::12:1:1:::1:0:", -- Fizzle Brassbolts\' Letter
	[5829]=":804:15:0:5:::1:0:", -- Razor-sharp Beak
	[5830]="::12:1:1:::1:0:", -- Kenata\'s Head
	[5831]="::12:1:1:::1:0:", -- Fardel\'s Head
	[5832]="::12:1:1:::1:0:", -- Marcel\'s Head
	[5833]="::12:1:20:::1:0:", -- Indurium Ore
	[5834]="::12:1:1:::1:0:", -- Mok\'Morokk\'s Snuff
	[5835]="::12:1:1:::1:0:", -- Mok\'Morokk\'s Grog
	[5836]="::12:1:1:::1:0:", -- Mok\'Morokk\'s Strongbox
	[5837]="::12:1:1:::1:0:", -- Steelsnap\'s Rib
	[5838]="::12:1:1:::1:0:", -- Kodo Skin Scroll
	[5839]=":1:15:0:1:::1:0:", -- Journal Page
	[5840]="::12:1:20:::1:0:", -- Searing Tongue
	[5841]="::12:1:20:::1:0:", -- Searing Heart
	[5842]="::12:1:1:::1:0:", -- Unrefined Ore Sample
	[5843]="::12:1:1:::1:0:", -- Grenka\'s Claw
	[5844]="::12:1:1:::1:0:", -- Fragments of Rok\'Alim
	[5846]="::12:1:1:::1:0:", -- Korran\'s Sealed Note
	[5847]="::12:1:20:::1:0:", -- Mirefin Head
	[5848]="::12:1:20:::1:0:", -- Hollow Vulture Bone
	[5849]="::12:1:1:::1:0:", -- Crate of Crash Helmets
	[5850]="::12:1:1:::1:0:", -- Belgrom\'s Sealed Note
	[5851]="::13:1:1:::1:0:", -- Cozzle\'s Key
	[5852]="::12:1:1:::1:0:", -- Fuel Regulator Blueprints
	[5853]="::12:1:20:::1:0:", -- Intact Silithid Carapace
	[5854]="::12:1:20:::1:0:", -- Silithid Talon
	[5855]="::12:1:20:::1:0:", -- Silithid Heart
	[5860]="::12:1:1:::1:0:", -- Legacy of the Aspects
	[5861]="::12:1:1:::1:0:", -- Beginnings of the Undead Threat
	[5862]="::12:1:1:::1:0:", -- Seaforium Booster
	[5863]="::15:1:1:::1:0:", -- Guild Charter
	[5864]="100000::15:3:1:::1:0:1261", -- Gray Ram
	[5865]="::12:1:1:::1:0:", -- Modified Seaforium Booster
	[5866]="::12:1:1:::1:0:", -- Sample of Indurium Ore
	[5867]="::12:1:1:::1:0:", -- Etched Phial
	[5868]="::12:1:1:::1:0:", -- Filled Etched Phial
	[5869]="::12:1:1:::1:0:", -- Cloven Hoof
	[5871]=":318:15:0:5:::1:0:", -- Large Hoof
	[5872]="100000::15:3:1:::1:0:1261", -- Brown Ram
	[5873]="100000::15:3:1:::1:0:1261", -- White Ram
	[5876]="::12:1:20:::1:0:", -- Blueleaf Tuber
	[5877]="::12:1:1:::1:0:", -- Cracked Silithid Carapace
	[5879]="::12:1:20:::1:0:", -- Twilight Pendant
	[5880]="::0:1:1:::1:0:", -- Crate With Holes
	[5881]="::12:1:1:::1:0:", -- Head of Kelris
	[5882]="::12:1:1:::1:0:", -- Captain\'s Documents
	[5883]="::12:1:20:::1:0:", -- Forked Mudrock Tongue
	[5884]="::12:1:20:::1:0:", -- Unpopped Darkmist Eye
	[5897]="::12:1:1:::1:0:", -- Snufflenose Owner\'s Manual
	[5917]="::12:1:1:::1:0:", -- Spy\'s Report
	[5918]="::12:1:1:::1:0:", -- Defiant Orc Head
	[5919]="::12:1:1:::1:0:", -- Blackened Iron Shield
	[5936]=":20:4:1:1:::1:0:", -- Animal Skin Belt
	[5938]="::12:1:20:::1:0:", -- Pristine Crawler Leg
	[5939]=":20:4:1:1:::1:0:", -- Sewing Gloves
	[5940]=":154:4:1:1:::1:0:", -- Bone Buckler
	[5941]=":115:4:1:1:::1:0:", -- Brass Scale Pants
	[5942]="::12:1:1:::1:0:", -- Jeweled Pendant
	[5943]=":1008:4:3:1:::1:0:", -- Rift Bracers
	[5944]=":331:4:2:1:::1:0:", -- Greaves of the People\'s Militia
	[5945]="::12:1:1:::1:0:", -- Deadmire\'s Tooth
	[5946]="::12:1:1:::1:0:", -- Sealed Note to Elling
	[5947]="::12:1:1:::1:0:", -- Defias Docket
	[5948]="::12:1:1:::1:0:", -- Letter to Jorgen
	[5950]="::12:1:1:::1:0:", -- Reethe\'s Badge
	[5951]=":41:0:1:10:::1:0:", -- Moist Towelette
	[5952]="::12:1:20:::1:0:", -- Corrupted Brain Stem
	[5956]="18:3:2:1:1:::1:0:16768,26744,8161,26751,7947,5512,24843,4775,843,17490,26765,25634,16823,1692,9544,22476,6777,18427,3955,19056,14637,22264,19879,3133,3343,16657,21112,17421,25082,17486,4897,3954,5175,27711,2821,16224,4587,20082,2682,17245,17655,1250,1448,3614,3168,26747,4877,2847,12022,9636,2999,3556,19012,26753,26742,9676,25051,17222,19450,15179,5135,12245,19342,19011,3499,12958,19520,16613,19661,23144,2684,2844,15176,26724,26749,5519,4259,14624,16782,1286,26755,26738,1148,19383,790,15400,2687,2381,777,16376,23724,8679,8678,2688,4194,6301,12028,19372,18484,16261,5163,19530,1456,26758,8363,18009,960,12043,18775,66,26754,26752,18752,26743,25010,2225,4561,4597,3482,8934,26756,2685,6300,18278,11189,26759,20463,16583,989,11185,14737,20890,1465,6730,3495,3779,16262,3081,3413,16670,12941,16713,26741,26739,21209,12957,8176,3187,19662,26748,1694,18426,2810,1690,4257,24995,26745,4229,26757,28344,9179,19575,3356,4453,5411,5100,2118,2683,8145,2393,19244,3477,24935,3367,26740,5817,25019", -- Blacksmith Hammer
	[5957]=":40:4:1:1:::1:0:", -- Handstitched Leather Vest
	[5958]=":829:4:2:1:::1:0:", -- Fine Leather Pants
	[5959]="::12:1:20:::1:0:", -- Acidic Venom Sac
	[5960]="::12:1:1:::1:0:", -- Sealed Note to Watcher Backus
	[5961]=":1089:4:2:1:::1:0:", -- Dark Leather Pants
	[5962]=":2794:4:2:1:::1:0:", -- Guardian Pants
	[5963]=":3151:4:2:1:::1:0:", -- Barbaric Leggings
	[5964]=":2609:4:2:1:::1:0:", -- Barbaric Shoulders
	[5965]=":2536:4:2:1:::1:0:", -- Guardian Cloak
	[5966]=":1374:4:1:1::164:1:0:", -- Guardian Gloves
	[5967]=":209:4:2:1:::1:0:", -- Girdle of Nobility
	[5969]=":625:4:2:1:::1:0:", -- Regent\'s Cloak
	[5970]=":502:4:3:1:::1:0:", -- Serpent Gloves
	[5971]=":909:4:2:1:::1:0:", -- Feathered Cape
	[5972]=":375:9:2:1:::1:0:", -- Pattern: Fine Leather Pants
	[5973]="650:162:9:1:1:::1:0:2821,2810,12245,3958,4877", -- Pattern: Barbaric Leggings
	[5974]=":350:9:2:1:::1:0:", -- Pattern: Guardian Cloak
	[5975]=":532:4:2:1:::1:0:", -- Ruffian Belt
	[5976]="10000:2500:4:1:1:::1:0:5191,5049,16766,5188,16610,5193,5190,5189", -- Guild Tabard
	[5996]=":95:0:1:20:::1:0:", -- Elixir of Water Breathing
	[5997]=":5:0:1:20:::1:0:", -- Elixir of Minor Defense
	[5998]="::12:1:1:::1:0:", -- Stormpike\'s Request
	[6016]="::12:1:1:::1:0:", -- Wolf Heart Sample
	[6037]=":1250:7:2:20::164,333,202,755,197:1:0:", -- Truesilver Bar
	[6038]=":312:0:1:20:::1:0:", -- Giant Clam Scorcho
	[6039]="5000:1250:9:1:1:::1:0:2664", -- Recipe: Giant Clam Scorcho
	[6040]=":1649:4:1:1:::1:0:", -- Golden Scale Bracers
	[6041]=":1500:0:1:5:::1:0:", -- Steel Weapon Chain
	[6042]=":250:0:1:5:::1:0:", -- Iron Shield Spike
	[6043]=":500:0:1:5:::1:0:", -- Iron Counterweight
	[6044]=":450:9:2:1:::1:0:", -- Plans: Iron Shield Spike
	[6045]=":650:9:2:1:::1:0:", -- Plans: Iron Counterweight
	[6046]=":950:9:2:1:::1:0:", -- Plans: Steel Weapon Chain
	[6047]="4400:1100:9:1:1:::1:0:5411", -- Plans: Golden Scale Coif
	[6048]=":100:0:1:5::333,197:1:0:", -- Shadow Protection Potion
	[6049]=":170:0:1:5:::1:0:", -- Fire Protection Potion
	[6050]=":300:0:1:5:::1:0:", -- Frost Protection Potion
	[6051]=":62:0:1:5:::1:0:", -- Holy Protection Potion
	[6052]=":300:0:1:5:::1:0:", -- Nature Protection Potion
	[6053]="800:200:9:1:1:::1:0:1685,3490,3134", -- Recipe: Holy Protection Potion
	[6054]="900:225:9:1:1:::1:0:3956,2393", -- Recipe: Shadow Protection Potion
	[6055]="1500:375:9:1:1:::1:0:2380,4083", -- Recipe: Fire Protection Potion
	[6056]="2000:500:9:1:1:::1:0:2848,2812", -- Recipe: Frost Protection Potion
	[6057]="2000:500:9:1:1:::1:0:2848,8158,8157,5594", -- Recipe: Nature Protection Potion
	[6058]=":6:4:1:1:::1:0:", -- Blackened Leather Belt
	[6059]=":13:4:1:1:::1:0:", -- Nomadic Vest
	[6060]=":4:4:1:1:::1:0:", -- Flax Bracers
	[6061]=":23:4:1:1:::1:0:", -- Graystone Bracers
	[6062]=":28:4:1:1:::1:0:", -- Heavy Cord Bracers
	[6063]=":23:4:1:1:::1:0:", -- Cold Steel Gauntlets
	[6064]="::12:1:1:::1:0:", -- Miniature Platinum Discs
	[6065]="::12:1:1:::1:0:", -- Khadgar\'s Essays on Dimensional Convergence
	[6066]="::12:1:1:::1:0:", -- Khan Dez\'hepah\'s Head
	[6067]="::12:1:20:::1:0:", -- Centaur Ear
	[6068]="1500:375:9:1:1:::1:0:4878,2481,12245", -- Recipe: Shadow Oil
	[6069]="::12:1:20:::1:0:", -- Crudely Dried Meat
	[6070]=":6:4:1:1:::1:0:", -- Wolfskin Bracers
	[6071]="::12:1:20:::1:0:", -- Draenethyst Crystal
	[6072]="::12:1:1:::1:0:", -- Khan Jehn\'s Head
	[6073]="::12:1:1:::1:0:", -- Khan Shaka\'s Head
	[6074]="::0:1:1:::1:0:", -- War Horn Mouthpiece
	[6076]=":9:4:1:1:::1:0:", -- Tapered Pants
	[6077]="::12:1:1:::1:0:", -- Maraudine Key Fragment
	[6078]=":15:4:1:1:::1:0:", -- Pikeman Shield
	[6079]="::12:1:20:::1:0:", -- Crude Charm
	[6080]="::12:1:20:::1:0:", -- Shadow Panther Heart
	[6081]="::12:1:1:::1:0:", -- Mire Lord Fungus
	[6082]="::12:1:1:::1:0:", -- Green Whelp Blood
	[6083]="::12:1:20:::1:0:", -- Broken Tears
	[6084]=":291:4:2:1:::1:0:", -- Stormwind Guard Leggings
	[6085]=":243:4:2:1:::1:0:", -- Footman Tunic
	[6086]="::12:1:1:::1:0:", -- Faustin\'s Truth Serum
	[6087]=":1728:4:3:1:::1:0:", -- Chausses of Westfall
	[6089]="::12:1:1:::1:0:", -- Zraedus\'s Brew
	[6091]="::12:1:1:::1:0:", -- Crate of Power Stones
	[6092]=":421:4:2:1:::1:0:", -- Black Whelp Boots
	[6093]=":4418:2:2:1:::1:0:", -- Orc Crusher
	[6094]=":1278:2:2:1:::1:0:", -- Piercing Axe
	[6095]=":688:4:2:1:::1:0:", -- Wandering Boots
	[6096]="1:1:4:1:1:::1:0:18672", -- Apprentice\'s Shirt
	[6097]="1:1:4:1:1:::1:0:18672", -- Acolyte\'s Shirt
	[6098]="4:1:4:0:1:::1:0:18672", -- Neophyte\'s Robe
	[6117]=":1:4:1:1:::1:0:", -- Squire\'s Shirt
	[6118]=":1:4:0:1:::1:0:", -- Squire\'s Pants
	[6119]=":1:4:0:1:::1:0:", -- Neophyte\'s Robe
	[6120]=":1:4:1:1:::1:0:", -- Recruit\'s Shirt
	[6121]=":1:4:0:1:::1:0:", -- Recruit\'s Pants
	[6122]=":1:4:1:1:::1:0:", -- Recruit\'s Boots
	[6123]=":1:4:0:1:::1:0:", -- Novice\'s Robe
	[6124]=":1:4:0:1:::1:0:", -- Novice\'s Pants
	[6125]=":1:4:1:1:::1:0:", -- Brawler\'s Harness
	[6126]=":1:4:0:1:::1:0:", -- Trapper\'s Pants
	[6127]=":1:4:1:1:::1:0:", -- Trapper\'s Boots
	[6129]=":1:4:0:1:::1:0:", -- Acolyte\'s Robe
	[6134]=":1:4:1:1:::1:0:", -- Primitive Mantle
	[6135]=":1:4:0:1:::1:0:", -- Primitive Kilt
	[6136]=":1:4:1:1:::1:0:", -- Thug Shirt
	[6137]=":1:4:0:1:::1:0:", -- Thug Pants
	[6138]=":1:4:1:1:::1:0:", -- Thug Boots
	[6139]=":1:4:0:1:::1:0:", -- Novice\'s Robe
	[6140]=":1:4:0:1:::1:0:", -- Apprentice\'s Robe
	[6144]=":1:4:0:1:::1:0:", -- Neophyte\'s Robe
	[6145]="::12:1:1:::1:0:", -- Clarice\'s Pendant
	[6146]="::12:1:20:::1:0:", -- Sundried Driftwood
	[6147]=":37:4:1:1:::1:0:", -- Ratty Old Belt
	[6148]=":44:4:1:1:::1:0:", -- Web-covered Boots
	[6149]="480:120:0:1:5::755:1:0:18908,18906,8158,983,8178,18810,8157,11188,18905,8177", -- Greater Mana Potion
	[6150]=":22:15:0:20:::1:0:", -- A Frayed Knot
	[6166]="::12:1:20:::1:0:", -- Coyote Jawbone
	[6167]="::12:1:1:::1:0:", -- Neeka\'s Report
	[6168]="::12:1:20:::1:0:", -- Sawtooth Snapper Claw
	[6169]="::12:1:20:::1:0:", -- Unprepared Sawtooth Flank
	[6170]="::12:1:1:::1:0:", -- Wizards\' Reagents
	[6171]=":6:4:1:1:::1:0:", -- Wolf Handler Gloves
	[6172]="::12:1:1:::1:0:", -- Lost Supplies
	[6173]=":7:4:1:1:::1:0:", -- Snow Boots
	[6175]="::12:1:20:::1:0:", -- Atal\'ai Artifact
	[6176]=":15:4:1:1:::1:0:", -- Dwarven Kite Shield
	[6177]=":69:4:1:1:::1:0:", -- Ironwrought Bracers
	[6178]="::12:1:1:::1:0:", -- Shipment to Nethergarde
	[6179]=":369:4:2:1:::1:0:", -- Privateer\'s Cape
	[6180]=":423:4:2:1:::1:0:", -- Slarkskin
	[6181]="::12:1:20:::1:0:", -- Fetish of Hakkar
	[6184]="::12:1:20:::1:0:", -- Monstrous Crawler Leg
	[6185]=":7:4:1:1:::1:0:", -- Bear Shawl
	[6186]=":1373:2:2:1:::1:0:", -- Trogg Slicer
	[6187]=":613:4:2:1:::1:0:", -- Dwarven Defender
	[6188]=":305:4:2:1:::1:0:", -- Mud Stompers
	[6189]=":624:4:1:1:::1:0:", -- Durable Chain Shoulders
	[6190]="::12:1:1:::1:0:", -- Draenethyst Shard
	[6191]=":616:4:2:1:::1:0:", -- Kimbra Boots
	[6193]="::12:1:1:::1:0:", -- Bundle of Atal\'ai Artifacts
	[6194]=":5308:2:2:1:::1:0:", -- Barreling Reaper
	[6195]=":416:4:2:1:::1:0:", -- Wax-polished Armor
	[6196]="::2:0:1:::1:0:", -- Noboru\'s Cudgel
	[6197]=":929:4:2:1:::1:0:", -- Loch Croc Hide Vest
	[6198]=":1113:4:2:1:::1:0:", -- Jurassic Wristguards
	[6199]=":650:4:2:1:::1:0:", -- Black Widow Band
	[6200]=":1223:4:2:1:::1:0:", -- Garneg\'s War Belt
	[6201]=":54:4:1:1:::1:0:", -- Lithe Boots
	[6202]=":37:4:1:1:::1:0:", -- Fingerless Gloves
	[6203]=":121:4:1:1:::1:0:", -- Thuggish Shield
	[6204]=":2065:4:2:1:::1:0:", -- Tribal Worg Helm
	[6205]=":922:2:2:1:::1:0:", -- Burrowing Shovel
	[6206]=":555:2:1:1:::1:0:", -- Rock Chipper
	[6211]=":450:9:1:1:::1:0:", -- Recipe: Elixir of Ogre\'s Strength
	[6212]="::12:1:1:::1:0:", -- Head of Jammal\'an
	[6214]=":595:2:1:1:::1:0:", -- Heavy Copper Maul
	[6215]=":602:2:2:1:::1:0:", -- Balanced Fighting Stick
	[6217]="124:24:7:1:1::333:1:0:19663,16768,6301,26744,3346,26751,7947,24843,19372,12028,3012,4775,843,5163,16261,17490,1318,1456,26758,26765,8363,19540,1692,5757,5158,18009,960,16635,12043,66,18753,26754,26752,18427,3955,26743,2225,25010,5758,4561,3482,25082,26756,8934,17486,4897,18773,11189,26759,4228,3954,989,2821,16224,1465,3779,16262,1250,3081,3614,12941,3168,26747,26741,26739,4877,12022,12957,9636,19537,19234,3556,15419,3187,26753,26742,25051,26748,19450,4617,2810,15179,18426,5135,12245,3499,12958,24995,16613,26745,26757,4229,26724,26749,1286,26755,26738,5100,2118,8145,1148,2393,19244,2381,777,16722,24935,18951,4194,3367,26740,5817,25019", -- Copper Rod
	[6218]=":24:7:1:1::333:1:0:", -- Runed Copper Rod
	[6219]=":144:2:1:1:::1:0:", -- Arclight Spanner
	[6220]=":4893:2:3:1:::1:0:", -- Meteor Shard
	[6223]=":4797:4:2:1:::1:0:", -- Crest of Darkshire
	[6226]=":1068:4:3:1:::1:0:", -- Bloody Apron
	[6238]=":98:4:2:1:::1:0:", -- Brown Linen Robe
	[6239]=":160:4:2:1:::1:0:", -- Red Linen Vest
	[6240]=":161:4:2:1:::1:0:", -- Blue Linen Vest
	[6241]=":99:4:2:1:::1:0:", -- White Linen Robe
	[6242]=":243:4:2:1:::1:0:", -- Blue Linen Robe
	[6245]="::12:1:1:::1:0:", -- Karnitol\'s Satchel
	[6246]="::12:1:20:::1:0:", -- Hatefury Claw
	[6247]="::12:1:20:::1:0:", -- Hatefury Horn
	[6248]="::12:1:20:::1:0:", -- Scorpashi Venom
	[6249]="::12:1:20:::1:0:", -- Aged Kodo Hide
	[6250]="::12:1:20:::1:0:", -- Felhound Brain
	[6251]="::12:1:20:::1:0:", -- Nether Wing
	[6252]="::12:1:20:::1:0:", -- Doomwarder Blood
	[6253]="::12:1:1:::1:0:", -- Leftwitch\'s Package
	[6256]="23:4:2:1:1:::1:0:16768,6301,26744,3029,26751,7947,24843,19372,12028,12031,4775,843,5163,16261,17490,26758,26765,8363,14740,5942,5162,1692,3497,18009,12043,66,26754,26752,10118,18427,3955,26743,2225,25010,4561,8508,3482,10216,25082,26756,8934,17486,4897,11189,7945,26759,16708,3954,3333,989,19472,2821,16224,1465,16262,3779,1250,3081,3614,12941,3168,3550,2626,5494,26747,26741,26739,12022,4574,12957,3556,17101,3187,26753,26742,1678,25051,26748,19450,2810,15179,18426,5135,12245,18347,3499,5940,12958,24995,16613,26745,26757,4229,12962,18911,18018,3572,2383,26724,26749,1286,26755,26738,2118,8145,1148,19244,777,24935,3178,4222,4194,3367,26740,1684,5817,25019", -- Fishing Pole
	[6257]="::12:1:20:::1:0:", -- Roc Gizzard
	[6258]="::12:1:20:::1:0:", -- Ironfur Liver
	[6259]="::12:1:20:::1:0:", -- Groddoc Liver
	[6260]="50:12:7:1:10::197:1:0:6301,4589,16689,4225,3096,6731,18749,843,12942,16261,18277,17490,8681,4577,5783,5154,2670,12956,1692,11557,7940,3958,2816,21085,66,18427,2225,6568,3482,2697,8934,16366,2699,4189,4168,16224,1465,16262,18772,1250,2846,11874,12943,3081,3614,3168,3091,6574,2668,18754,19196,19213,3187,7854,7852,19521,3364,5128,6576,18426,1347,3485,5135,1672,5565,2394,8160,15165,1474,16767,3366,19532,1454,5944,6567,16748,2819,2672,3005,19722,2118,16638,2669,18771,4194,2698,5817", -- Blue Dye
	[6261]="1000:250:7:1:10::197:1:0:4589,16689,4225,3096,6731,18749,12942,18277,8681,4577,5783,5154,2670,12956,11557,7940,3958,2816,21085,6568,2697,16366,2699,4189,4168,18772,2846,11874,12943,3091,6574,2668,18754,19196,19213,7854,7852,19521,3364,5128,6576,1347,3485,1672,5565,2394,8160,15165,1474,16767,19532,3366,1454,5944,6567,16748,2672,2819,3005,19722,16638,2669,18771,2698", -- Orange Dye
	[6263]=":589:4:2:1:::1:0:", -- Blue Overalls
	[6264]=":884:4:2:1:::1:0:", -- Greater Adept\'s Robe
	[6265]="::15:1:1::-9:1:0:23405,26304,23151,17078", -- Soul Shard
	[6266]=":205:4:2:1:::1:0:", -- Disciple\'s Vest
	[6267]=":149:4:2:1:::1:0:", -- Disciple\'s Pants
	[6268]=":234:4:2:1:::1:0:", -- Pioneer Tunic
	[6269]=":193:4:2:1:::1:0:", -- Pioneer Trousers
	[6270]="200:50:9:1:1:::1:0:66,3364,4189,3522,3485", -- Pattern: Blue Linen Vest
	[6271]=":50:9:2:1:::1:0:", -- Pattern: Red Linen Vest
	[6272]="300:75:9:1:1:::1:0:3556,3499,4168,3485,1250", -- Pattern: Blue Linen Robe
	[6274]="400:100:9:1:1:::1:0:2394,3364,843,1347,5944", -- Pattern: Blue Overalls
	[6275]="800:200:9:1:1:::1:0:3499,1474,1454,4168,4577,2669", -- Pattern: Greater Adept\'s Robe
	[6281]="::12:1:20:::1:0:", -- Rattlecage Skull
	[6282]=":2244:4:2:1:::1:0:", -- Sacred Burial Trousers
	[6283]="::12:1:1:::1:0:", -- The Book of Ur
	[6284]="::12:1:1:::1:0:", -- Runes of Summoning
	[6285]="::12:1:1:::1:0:", -- Egalin\'s Grimoire
	[6286]="::12:1:1:::1:0:", -- Pure Hearts
	[6287]="::12:1:1:::1:0:", -- Atal\'ai Tablet Fragment
	[6288]="::12:1:20:::1:0:", -- Atal\'ai Tablet
	[6289]=":1:7:1:20::185:1:0:", -- Raw Longjaw Mud Snapper
	[6290]=":1:0:1:20:::1:0:", -- Brilliant Smallfish
	[6291]=":1:7:1:20::185:1:0:", -- Raw Brilliant Smallfish
	[6292]=":8:4:1:1:::1:0:", -- 10 Pound Mud Snapper
	[6293]=":33:15:0:10:::1:0:", -- Dried Bat Blood
	[6294]=":10:4:1:1:::1:0:", -- 12 Pound Mud Snapper
	[6295]=":12:4:1:1:::1:0:", -- 15 Pound Mud Snapper
	[6296]=":28:15:0:10:::1:0:", -- Patch of Bat Hair
	[6297]=":7:15:0:10:::1:0:", -- Old Skull
	[6298]=":130:15:0:20:::1:0:", -- Bloody Bat Fang
	[6299]=":1:0:1:20:::1:0:", -- Sickly Looking Fish
	[6300]=":443:15:0:10:::1:0:", -- Husk Fragment
	[6301]=":20:15:0:1:::1:0:", -- Old Teamster\'s Skull
	[6302]=":628:15:0:5:::1:0:", -- Delicate Insect Wing
	[6303]=":1:7:1:20::185:1:0:", -- Raw Slitherskin Mackerel
	[6304]=":25:15:0:1:::1:0:", -- Damp Diary Page (Day 4)
	[6305]=":25:15:0:1:::1:0:", -- Damp Diary Page (Day 87)
	[6306]=":25:15:0:1:::1:0:", -- Damp Diary Page (Day 512)
	[6307]=":1:15:1:1:::1:0:", -- Message in a Bottle
	[6308]=":2:7:1:20::185:1:0:", -- Raw Bristle Whisker Catfish
	[6309]=":100:4:1:1:::1:0:", -- 17 Pound Catfish
	[6310]=":150:4:1:1:::1:0:", -- 19 Pound Catfish
	[6311]=":187:4:1:1:::1:0:", -- 22 Pound Catfish
	[6312]="::12:1:1:::1:0:", -- Dalin\'s Heart
	[6313]="::12:1:1:::1:0:", -- Comar\'s Heart
	[6314]=":1217:4:3:1:::1:0:", -- Wolfmaster Cape
	[6315]=":2546:2:2:1:::1:0:", -- Steelarrow Crossbow
	[6316]=":3:0:1:20:::1:0:", -- Loch Frenzy Delight
	[6317]=":2:7:1:20::185:1:0:", -- Raw Loch Frenzy
	[6318]=":4803:2:3:1:::1:0:", -- Odo\'s Ley Staff
	[6319]=":964:4:3:1:::1:0:", -- Girdle of the Blindwatcher
	[6320]=":2711:4:3:1:::1:0:", -- Commander\'s Crest
	[6321]=":1650:4:3:1:::1:0:", -- Silverlaine\'s Family Seal
	[6323]=":3134:2:3:1:::1:0:", -- Baron\'s Scepter
	[6324]=":1892:4:3:1:::1:0:", -- Robes of Arugal
	[6325]="40:10:9:1:1:::1:0:4574,8508,3029,66,5940,1684,3550,5494,4265", -- Recipe: Brilliant Smallfish
	[6326]="40:10:9:1:1:::1:0:5942,4305,5162,10118,3550", -- Recipe: Slitherskin Mackerel
	[6327]=":12823:2:3:1:::1:0:", -- The Pacifier
	[6328]="400:100:9:1:1:::1:0:66,5748,3027,5940,4574,5162,1684,4265", -- Recipe: Longjaw Mud Snapper
	[6329]="400:100:9:1:1:::1:0:1684", -- Recipe: Loch Frenzy Delight
	[6330]="1200:300:9:1:1:::1:0:2397,3027,3029,3497,5494,4553,2383", -- Recipe: Bristle Whisker Catfish
	[6331]=":9466:2:3:1:::1:0:", -- Howling Blade
	[6332]=":1153:4:3:1:::1:0:", -- Black Pearl Ring
	[6333]=":1929:2:2:1:::1:0:", -- Spikelash Dagger
	[6335]=":1581:4:2:1:::1:0:", -- Grizzled Boots
	[6336]=":305:4:2:1:::1:0:", -- Infantry Tunic
	[6337]=":245:4:2:1:::1:0:", -- Infantry Leggings
	[6338]=":125:7:1:1::333:1:0:", -- Silver Rod
	[6339]=":24:7:1:1::333:1:0:", -- Runed Silver Rod
	[6340]=":1260:4:3:1:::1:0:", -- Fenrus\' Hide
	[6341]=":666:4:3:1:::1:0:", -- Eerie Stable Lantern
	[6342]="300:75:9:2:1:::1:0:19663,3346,19537,3012,19234,18773,15419,1318,4228,19540,4617,5158,5757,16635,16722,18753,18951,5758", -- Formula: Enchant Chest - Minor Mana
	[6344]=":100:9:2:1:::1:0:", -- Formula: Enchant Bracer - Minor Spirit
	[6346]="400:100:9:2:1:::1:0:3346,5757", -- Formula: Enchant Chest - Lesser Mana
	[6347]=":100:9:2:1:::1:0:", -- Formula: Enchant Bracer - Minor Strength
	[6348]=":125:9:2:1:::1:0:", -- Formula: Enchant Weapon - Minor Beastslayer
	[6349]="500:125:9:1:1:::1:0:3346,5158,3012,5758", -- Formula: Enchant 2H Weapon - Lesser Intellect
	[6350]=":295:4:1:1:::1:0:", -- Rough Bronze Boots
	[6351]=":1:15:1:1:::1:0:", -- Dented Crate
	[6352]=":1:15:1:1:::1:0:", -- Waterlogged Crate
	[6353]=":1:15:1:1:::1:0:", -- Small Chest
	[6354]=":1:15:1:1:::1:0:", -- Small Locked Chest
	[6355]=":1:15:1:1:::1:0:", -- Sturdy Locked Chest
	[6356]=":1:15:1:1:::1:0:", -- Battered Chest
	[6357]=":1:15:1:1:::1:0:", -- Sealed Crate
	[6358]=":4:7:1:20::171:1:0:", -- Oily Blackmouth
	[6359]=":5:7:1:20::171:1:0:", -- Firefin Snapper
	[6360]=":2581:2:2:1:::1:0:", -- Steelscale Crushfish
	[6361]=":2:7:1:20::185:1:0:", -- Raw Rainbow Fin Albacore
	[6362]=":4:7:1:20::185:1:0:", -- Raw Rockscale Cod
	[6363]=":250:4:1:1:::1:0:", -- 26 Pound Catfish
	[6364]=":375:4:1:1:::1:0:", -- 32 Pound Catfish
	[6365]="902:180:2:1:1:::1:0:18018,18911,4574,8508,3029,3572,2383,17101,12031,7945,16708,1678,3333,19472,14740,5942,5162,3497,18347,3178,5940,4222,10118,3550,1684,2626,5494,12962", -- Strong Fishing Pole
	[6366]=":1066:2:1:1:::1:0:", -- Darkwood Fishing Pole
	[6367]=":3378:2:1:1:::1:0:", -- Big Iron Fishing Pole
	[6368]="400:100:9:1:1:::1:0:5942,3497,4307,5748,3178,4305,10118,3333,5494,4553", -- Recipe: Rainbow Fin Albacore
	[6369]="2200:550:9:1:1:::1:0:4574,5162,4307,2383,3178,12033,2664,3333,12962", -- Recipe: Rockscale Cod
	[6370]=":10:7:1:20::171,333:1:0:", -- Blackmouth Oil
	[6371]=":12:7:1:20::171,333,197:1:0:", -- Fire Oil
	[6372]=":35:0:1:5:::1:0:", -- Swim Speed Potion
	[6373]=":35:0:1:20:::1:0:", -- Elixir of Firepower
	[6375]=":250:9:2:1:::1:0:", -- Formula: Enchant Bracer - Lesser Spirit
	[6377]="1000:250:9:2:1:::1:0:3537,3012", -- Formula: Enchant Boots - Minor Agility
	[6378]=":292:4:2:1:::1:0:", -- Seer\'s Cape
	[6379]=":244:4:2:1:::1:0:", -- Inscribed Leather Belt
	[6380]=":654:4:2:1:::1:0:", -- Inscribed Buckler
	[6381]=":625:4:2:1:::1:0:", -- Bright Cloak
	[6382]=":523:4:2:1:::1:0:", -- Forest Leather Belt
	[6383]=":1519:4:2:1:::1:0:", -- Forest Buckler
	[6384]=":250:4:1:1:::1:0:", -- Stylish Blue Shirt
	[6385]=":250:4:1:1:::1:0:", -- Stylish Green Shirt
	[6386]=":2692:4:2:1:::1:0:", -- Glimmering Mail Legguards
	[6387]=":1228:4:2:1:::1:0:", -- Glimmering Mail Bracers
	[6388]=":2043:4:2:1:::1:0:", -- Glimmering Mail Pauldrons
	[6389]=":2245:4:2:1:::1:0:", -- Glimmering Mail Coif
	[6390]=":150:9:2:1:::1:0:", -- Pattern: Stylish Blue Shirt
	[6391]=":150:9:2:1:::1:0:", -- Pattern: Stylish Green Shirt
	[6392]=":1000:4:3:1:::1:0:", -- Belt of Arugal
	[6393]=":760:4:2:1:::1:0:", -- Silver-thread Gloves
	[6394]=":1041:4:2:1:::1:0:", -- Silver-thread Boots
	[6395]=":1264:4:2:1:::1:0:", -- Silver-thread Amice
	[6396]=":2814:4:2:1:::1:0:", -- Emblazoned Chestpiece
	[6397]=":986:4:2:1:::1:0:", -- Emblazoned Gloves
	[6398]=":989:4:2:1:::1:0:", -- Emblazoned Belt
	[6399]=":1639:4:2:1:::1:0:", -- Emblazoned Shoulders
	[6400]=":3089:4:2:1:::1:0:", -- Glimmering Shield
	[6401]="1100:275:9:1:1:::1:0:2394,12246,2669", -- Pattern: Dark Silk Shirt
	[6402]=":4699:4:2:1:::1:0:", -- Mail Combat Leggings
	[6403]=":1772:4:2:1:::1:0:", -- Mail Combat Armguards
	[6404]=":3242:4:2:1:::1:0:", -- Mail Combat Spaulders
	[6405]=":3168:4:2:1:::1:0:", -- Nightsky Trousers
	[6406]=":1970:4:2:1:::1:0:", -- Nightsky Boots
	[6407]=":1198:4:2:1:::1:0:", -- Nightsky Wristbands
	[6408]=":1654:4:2:1:::1:0:", -- Insignia Gloves
	[6409]=":1660:4:2:1:::1:0:", -- Insignia Belt
	[6410]=":1515:4:2:1:::1:0:", -- Insignia Bracers
	[6411]=":7268:4:2:1:::1:0:", -- Chief Brigadier Armor
	[6412]=":4711:4:2:1:::1:0:", -- Chief Brigadier Boots
	[6413]=":2497:4:2:1:::1:0:", -- Chief Brigadier Bracers
	[6414]=":2055:4:3:1:::1:0:", -- Seal of Sylvanas
	[6415]=":4565:4:2:1:::1:0:", -- Aurora Robe
	[6416]=":2728:4:2:1:::1:0:", -- Aurora Boots
	[6417]=":2536:4:2:1:::1:0:", -- Aurora Cloak
	[6418]=":1697:4:2:1:::1:0:", -- Aurora Sash
	[6419]=":2299:4:2:1:::1:0:", -- Glyphed Mitts
	[6420]=":3739:4:2:1:::1:0:", -- Glyphed Boots
	[6421]=":2317:4:2:1:::1:0:", -- Glyphed Belt
	[6422]=":3768:4:2:1:::1:0:", -- Glyphed Helm
	[6423]=":7233:4:2:1:::1:0:", -- Blackforge Greaves
	[6424]=":3825:4:2:1:::1:0:", -- Blackforge Cape
	[6425]=":4478:4:2:1:::1:0:", -- Blackforge Girdle
	[6426]=":4162:4:2:1:::1:0:", -- Blackforge Bracers
	[6427]=":7016:4:2:1:::1:0:", -- Mistscape Robe
	[6428]=":2795:4:2:1:::1:0:", -- Mistscape Gloves
	[6429]=":4544:4:2:1:::1:0:", -- Mistscape Wizard Hat
	[6430]=":9098:4:2:1:::1:0:", -- Imperial Leather Breastplate
	[6431]=":5436:4:2:1:::1:0:", -- Imperial Leather Boots
	[6432]=":3741:4:2:1:::1:0:", -- Imperial Cloak
	[6433]=":4953:4:2:1:::1:0:", -- Imperial Leather Helm
	[6435]="::12:1:20:::1:0:", -- Infused Burning Gem
	[6436]="::12:1:1:::1:0:", -- Burning Gem
	[6438]=":362:15:0:5:::1:0:", -- Dull Elemental Bracer
	[6439]=":237:15:0:5:::1:0:", -- Broken Binding Bracer
	[6440]=":15812:4:3:1:::1:0:", -- Brainlash
	[6441]="::12:1:1:::1:0:", -- Shadowstalker Scalp
	[6442]="::12:1:1:::1:0:", -- Oracle Crystal
	[6443]="::12:1:20:::1:0:", -- Deviate Hide
	[6444]=":228:15:0:5:::1:0:", -- Forked Tongue
	[6445]=":88:15:0:5:::1:0:", -- Brittle Molting
	[6446]=":532:1:3:1:::1:0:", -- Snakeskin Bag
	[6447]=":1124:4:3:1:::1:0:", -- Worn Turtle Shell Shield
	[6448]=":2331:2:3:1:::1:0:", -- Tail Spike
	[6449]=":701:4:3:1:::1:0:", -- Glowing Lizardscale Cloak
	[6450]=":170:0:1:20:::1:0:", -- Silk Bandage
	[6451]=":400:0:1:20:::1:0:", -- Heavy Silk Bandage
	[6452]=":28:0:1:20:::1:0:", -- Anti-Venom
	[6453]=":62:0:1:20:::1:0:", -- Strong Anti-Venom
	[6454]=":225:9:2:1:::1:0:", -- Manual: Strong Anti-Venom
	[6455]=":4:15:0:5:::1:0:", -- Old Wagonwheel
	[6456]=":3:15:0:10:::1:0:", -- Acidic Slime
	[6457]=":4:15:0:5:::1:0:", -- Rusted Engineering Parts
	[6458]=":1:0:1:20:::1:0:", -- Oil Covered Fish
	[6459]=":1122:4:3:1:::1:0:", -- Savage Trodders
	[6460]=":844:4:3:1:::1:0:", -- Cobrahn\'s Grasp
	[6461]=":1190:4:3:1:::1:0:", -- Slime-encrusted Pads
	[6462]="::12:1:1:::1:0:", -- Secure Crate
	[6463]=":1527:4:3:1:::1:0:", -- Deep Fathom Ring
	[6464]="::12:1:20:::1:0:", -- Wailing Essence
	[6465]=":922:4:3:1:::1:0:", -- Robe of the Moccasin
	[6466]=":330:4:2:1:::1:0:", -- Deviate Scale Cloak
	[6467]=":420:4:2:1:::1:0:", -- Deviate Scale Gloves
	[6468]=":658:4:3:1:::1:0:", -- Deviate Scale Belt
	[6469]=":2240:2:3:1:::1:0:", -- Venomstrike
	[6470]=":20:7:1:20::165:1:0:", -- Deviate Scale
	[6471]=":500:7:1:20::165:1:0:", -- Perfect Deviate Scale
	[6472]=":3018:2:3:1:::1:0:", -- Stinging Viper
	[6473]=":1212:4:3:1:::1:0:", -- Armor of the Fang
	[6474]="550:137:9:1:1:::1:0:5783", -- Pattern: Deviate Scale Cloak
	[6475]="1500:375:9:1:1:::1:0:5783", -- Pattern: Deviate Scale Gloves
	[6476]=":500:9:2:1:::1:0:", -- Pattern: Deviate Scale Belt
	[6477]=":274:4:2:1:::1:0:", -- Grassland Sash
	[6479]="::12:1:1:::1:0:", -- Malem Pendant
	[6480]=":713:4:2:1:::1:0:", -- Slick Deviate Leggings
	[6481]=":642:4:2:1:::1:0:", -- Dagmire Gauntlets
	[6482]=":728:4:2:1:::1:0:", -- Firewalker Boots
	[6486]="::12:1:20:::1:0:", -- Singed Scale
	[6487]="::12:1:20:::1:0:", -- Vile Familiar Head
	[6488]="::12:1:1:::1:0:", -- Simple Tablet
	[6502]=":1140:4:2:1:::1:0:", -- Violet Scale Armor
	[6503]=":763:4:2:1:::1:0:", -- Harlequin Robes
	[6504]=":2933:2:3:1:::1:0:", -- Wingblade
	[6505]=":3680:2:3:1:::1:0:", -- Crescent Staff
	[6506]=":87:4:1:1:::1:0:", -- Infantry Boots
	[6507]=":44:4:1:1:::1:0:", -- Infantry Bracers
	[6508]=":34:4:1:1:::1:0:", -- Infantry Cloak
	[6509]=":45:4:1:1:::1:0:", -- Infantry Belt
	[6510]=":54:4:1:1:::1:0:", -- Infantry Gauntlets
	[6511]=":121:4:2:1:::1:0:", -- Journeyman\'s Robe
	[6512]=":191:4:2:1:::1:0:", -- Disciple\'s Robe
	[6513]=":28:4:1:1:::1:0:", -- Disciple\'s Sash
	[6514]=":42:4:1:1:::1:0:", -- Disciple\'s Cloak
	[6515]=":37:4:1:1:::1:0:", -- Disciple\'s Gloves
	[6517]=":35:4:1:1:::1:0:", -- Pioneer Belt
	[6518]=":70:4:1:1:::1:0:", -- Pioneer Boots
	[6519]=":36:4:1:1:::1:0:", -- Pioneer Bracers
	[6520]=":33:4:1:1:::1:0:", -- Pioneer Cloak
	[6521]=":47:4:1:1:::1:0:", -- Pioneer Gloves
	[6522]=":4:0:1:20::171,185:1:0:", -- Deviate Fish
	[6523]="1422:284:4:1:1:::1:0:3359,3023", -- Buckled Harness
	[6524]="2871:574:4:1:1:::1:0:3359,3023", -- Studded Leather Harness
	[6525]="5168:1033:4:1:1:::1:0:3359,3023", -- Grunt\'s Harness
	[6526]="12487:2497:4:1:1:::1:0:3359,3023", -- Battle Harness
	[6527]=":187:4:2:1:::1:0:", -- Ancestral Robe
	[6528]=":358:4:2:1:::1:0:", -- Spellbinder Robe
	[6529]="50:12:0:1:20:::1:0:6301,4574,3029,12028,3556,17101,12031,843,16261,17490,3187,1678,14740,5942,5162,18426,1692,3497,5135,12043,18347,66,5940,3499,10118,18427,2225,12962,18911,18018,8508,3572,3482,10216,2383,8934,7945,16708,3333,19472,16224,1465,2118,16262,1250,777,3178,3081,3614,4222,4194,3168,3550,1684,2626,5494,5817", -- Shiny Bauble
	[6530]="100:25:0:1:20::202:1:0:16768,6301,26744,3029,26751,7947,24843,19372,12028,12031,4775,843,5163,17490,1456,26758,26765,8363,14740,5942,5162,3497,18009,960,12043,26754,26752,10118,18427,3955,26743,2225,25010,4561,8508,3482,25082,26756,8934,17486,4897,11189,7945,26759,16708,3954,3333,989,19472,2821,16224,1465,3779,12941,3550,2626,5494,26747,26741,26739,4877,12022,4574,12957,9636,3556,17101,26753,26742,1678,25051,26748,19450,2810,15179,18426,12245,5135,18347,3499,5940,12958,24995,16613,26745,26757,4229,12962,18911,18018,3572,2383,26724,26749,1286,26755,26738,5100,8145,1148,2393,19244,2381,777,24935,3178,4222,4194,3367,26740,1684,5817,25019", -- Nightcrawlers
	[6531]=":417:4:2:1:::1:0:", -- Barbaric Cloth Robe
	[6532]="250:62:0:1:20:::1:0:16768,6301,26744,19197,3029,26751,7947,24843,19372,12028,25034,19533,12031,4775,5163,1456,26758,26765,8363,14740,5942,5162,3497,18009,960,26754,26752,20891,10118,3955,26743,2225,25010,4561,8508,25082,26756,8934,17486,4897,11189,7945,20092,26759,16708,18907,3954,3333,989,19472,2821,20250,22271,3779,20194,19015,12941,3550,2626,5494,26747,26741,26739,4877,12022,4574,12957,9636,19497,17101,26753,26742,1678,25051,16602,26748,19450,20081,16826,19017,2810,15179,19345,5135,12245,21083,18347,5940,12958,24995,16613,26745,26757,4229,12962,18911,18018,3572,19562,19194,19042,2383,26724,18015,18960,26749,1286,26755,19573,26738,5100,1148,8145,2393,19244,2381,24935,3178,4222,21113,3367,26740,1684,5817,25019,22099", -- Bright Baubles
	[6533]="250:62:0:1:20:::1:0:18018,18911,4574,8508,3029,3572,2383,17101,12031,7945,16708,1678,3333,19472,14740,5942,5162,3497,18347,3178,5940,4222,10118,3550,1684,2626,5494,12962", -- Aquadynamic Fish Attractor
	[6534]="::12:1:1:::1:0:", -- Forged Steel Bars
	[6535]="::12:1:1:::1:0:", -- Tablet of Verga
	[6536]=":488:4:2:1:::1:0:", -- Willow Vest
	[6537]=":210:4:2:1:::1:0:", -- Willow Boots
	[6538]=":492:4:2:1:::1:0:", -- Willow Robe
	[6539]=":162:4:2:1:::1:0:", -- Willow Belt
	[6540]=":431:4:2:1:::1:0:", -- Willow Pants
	[6541]=":163:4:2:1:::1:0:", -- Willow Gloves
	[6542]=":219:4:2:1:::1:0:", -- Willow Cape
	[6543]=":147:4:2:1:::1:0:", -- Willow Bracers
	[6545]=":676:4:2:1:::1:0:", -- Soldier\'s Armor
	[6546]=":533:4:2:1:::1:0:", -- Soldier\'s Leggings
	[6547]=":267:4:2:1:::1:0:", -- Soldier\'s Gauntlets
	[6548]=":233:4:2:1:::1:0:", -- Soldier\'s Girdle
	[6549]=":102:4:1:1:::1:0:", -- Soldier\'s Cloak
	[6550]=":204:4:2:1:::1:0:", -- Soldier\'s Wristguards
	[6551]=":409:4:2:1:::1:0:", -- Soldier\'s Boots
	[6552]=":601:4:2:1:::1:0:", -- Bard\'s Tunic
	[6553]=":525:4:2:1:::1:0:", -- Bard\'s Trousers
	[6554]=":229:4:2:1:::1:0:", -- Bard\'s Gloves
	[6555]=":104:4:1:1:::1:0:", -- Bard\'s Cloak
	[6556]=":174:4:2:1:::1:0:", -- Bard\'s Bracers
	[6557]=":302:4:2:1:::1:0:", -- Bard\'s Boots
	[6558]=":180:4:2:1:::1:0:", -- Bard\'s Belt
	[6559]=":533:4:2:1:::1:0:", -- Bard\'s Buckler
	[6560]=":616:4:2:1:::1:0:", -- Soldier\'s Shield
	[6561]=":675:4:2:1:::1:0:", -- Seer\'s Padded Armor
	[6562]=":508:4:2:1:::1:0:", -- Shimmering Boots
	[6563]=":295:4:2:1:::1:0:", -- Shimmering Bracers
	[6564]=":512:4:2:1:::1:0:", -- Shimmering Cloak
	[6565]=":394:4:2:1:::1:0:", -- Shimmering Gloves
	[6566]=":411:4:1:1:::1:0:", -- Shimmering Amice
	[6567]=":1036:4:2:1:::1:0:", -- Shimmering Armor
	[6568]=":920:4:2:1:::1:0:", -- Shimmering Trousers
	[6569]=":1044:4:2:1:::1:0:", -- Shimmering Robe
	[6570]=":363:4:2:1:::1:0:", -- Shimmering Sash
	[6571]=":1167:4:2:1:::1:0:", -- Scouting Buckler
	[6572]=":1323:4:2:1:::1:0:", -- Defender Shield
	[6573]=":938:4:2:1:::1:0:", -- Defender Boots
	[6574]=":568:4:2:1:::1:0:", -- Defender Bracers
	[6575]=":431:4:2:1:::1:0:", -- Defender Cloak
	[6576]=":572:4:2:1:::1:0:", -- Defender Girdle
	[6577]=":649:4:2:1:::1:0:", -- Defender Gauntlets
	[6578]=":1303:4:2:1:::1:0:", -- Defender Leggings
	[6579]=":667:4:1:1:::1:0:", -- Defender Spaulders
	[6580]=":1312:4:2:1:::1:0:", -- Defender Tunic
	[6581]=":422:4:2:1:::1:0:", -- Scouting Belt
	[6582]=":731:4:2:1:::1:0:", -- Scouting Boots
	[6583]=":425:4:2:1:::1:0:", -- Scouting Bracers
	[6584]=":1416:4:2:1:::1:0:", -- Scouting Tunic
	[6585]=":446:4:2:1:::1:0:", -- Scouting Cloak
	[6586]=":505:4:2:1:::1:0:", -- Scouting Gloves
	[6587]=":1146:4:2:1:::1:0:", -- Scouting Trousers
	[6588]=":458:4:1:1:::1:0:", -- Scouting Spaulders
	[6590]=":1830:4:2:1:::1:0:", -- Battleforge Boots
	[6591]=":1007:4:2:1:::1:0:", -- Battleforge Wristguards
	[6592]=":2448:4:2:1:::1:0:", -- Battleforge Armor
	[6593]=":923:4:2:1:::1:0:", -- Battleforge Cloak
	[6594]=":1121:4:2:1:::1:0:", -- Battleforge Girdle
	[6595]=":1125:4:2:1:::1:0:", -- Battleforge Gauntlets
	[6596]=":2258:4:2:1:::1:0:", -- Battleforge Legguards
	[6597]=":1707:4:2:1:::1:0:", -- Battleforge Shoulderguards
	[6598]=":2426:4:2:1:::1:0:", -- Dervish Buckler
	[6599]=":2678:4:2:1:::1:0:", -- Battleforge Shield
	[6600]=":867:4:2:1:::1:0:", -- Dervish Belt
	[6601]=":1437:4:2:1:::1:0:", -- Dervish Boots
	[6602]=":874:4:2:1:::1:0:", -- Dervish Bracers
	[6603]=":2335:4:2:1:::1:0:", -- Dervish Tunic
	[6604]=":960:4:2:1:::1:0:", -- Dervish Cape
	[6605]=":971:4:2:1:::1:0:", -- Dervish Gloves
	[6607]=":2202:4:2:1:::1:0:", -- Dervish Leggings
	[6608]=":1328:4:2:1:::1:0:", -- Bright Armor
	[6609]=":2148:4:2:1:::1:0:", -- Sage\'s Cloth
	[6610]=":2156:4:2:1:::1:0:", -- Sage\'s Robe
	[6611]=":812:4:2:1:::1:0:", -- Sage\'s Sash
	[6612]=":1112:4:2:1:::1:0:", -- Sage\'s Boots
	[6613]=":744:4:2:1:::1:0:", -- Sage\'s Bracers
	[6614]=":1120:4:2:1:::1:0:", -- Sage\'s Cloak
	[6615]=":824:4:2:1:::1:0:", -- Sage\'s Gloves
	[6616]=":2204:4:2:1:::1:0:", -- Sage\'s Pants
	[6617]=":1371:4:2:1:::1:0:", -- Sage\'s Mantle
	[6622]=":49863:2:3:1:::1:0:", -- Sword of Zeal
	[6624]="::12:1:1:::1:0:", -- Ken\'zigla\'s Draught
	[6625]="::12:1:1:::1:0:", -- Dirt-caked Pendant
	[6626]="::12:1:1:::1:0:", -- Dogran\'s Pendant
	[6627]=":2620:4:3:1:::1:0:", -- Mutant Scale Breastplate
	[6628]=":370:4:2:1:::1:0:", -- Raven\'s Claws
	[6629]=":756:4:3:1:::1:0:", -- Sporid Cape
	[6630]=":2067:4:3:1:::1:0:", -- Seedcloud Buckler
	[6631]=":4053:2:3:1:::1:0:", -- Living Root
	[6632]=":511:4:3:1:::1:0:", -- Feyscale Cloak
	[6633]=":2558:2:3:1:::1:0:", -- Butcher\'s Slicer
	[6634]="::12:1:20:::1:0:", -- Ritual Salve
	[6635]="::0:1:1:::1:0:", -- Earth Sapta
	[6636]="::0:1:1:::1:0:", -- Fire Sapta
	[6637]="::0:1:1:::1:0:", -- Water Sapta
	[6640]="::12:1:20:::1:0:", -- Felstalker Hoof
	[6641]=":4410:2:3:1:::1:0:", -- Haunting Blade
	[6642]=":1880:4:3:1:::1:0:", -- Phantom Armor
	[6643]=":6:15:1:1:::1:0:", -- Bloated Smallfish
	[6645]=":25:15:1:1:::1:0:", -- Bloated Mud Snapper
	[6647]=":40:15:1:1:::1:0:", -- Bloated Catfish
	[6651]=":234:2:1:1:::1:0:", -- Broken Wine Bottle
	[6652]="::12:1:1:::1:0:", -- Reagent Pouch
	[6653]="::4:1:1:::1:0:", -- Torch of the Dormant Flame
	[6654]="::4:1:1:::1:0:", -- Torch of the Eternal Flame
	[6655]="::12:1:1:::1:0:", -- Glowing Ember
	[6656]="::12:1:1:::1:0:", -- Rough Quartz
	[6657]=":5:0:1:20:::1:0:", -- Savory Deviate Delight
	[6658]="::12:1:1:::1:0:", -- Example Collar
	[6659]=":541:4:2:1:::1:0:", -- Scarab Trousers
	[6660]=":36157:2:3:1:::1:0:", -- Julie\'s Dagger
	[6661]=":115:9:2:1:::1:0:", -- Recipe: Savory Deviate Delight
	[6662]=":95:0:1:20:::1:0:", -- Elixir of Giant Growth
	[6663]=":150:9:2:1:::1:0:", -- Recipe: Elixir of Giant Growth
	[6664]=":892:4:2:1:::1:0:", -- Voodoo Mantle
	[6665]=":895:4:2:1:::1:0:", -- Hexed Bracers
	[6666]=":830:4:2:1:::1:0:", -- Dredge Boots
	[6667]=":992:4:2:1:::1:0:", -- Engineer\'s Cloak
	[6668]=":1245:4:2:1:::1:0:", -- Draftsman Boots
	[6669]=":1378:4:2:1:::1:0:", -- Sacred Band
	[6670]=":1672:4:2:1:::1:0:", -- Panther Armor
	[6671]=":2068:4:2:1:::1:0:", -- Juggernaut Leggings
	[6672]=":500:9:2:1:::1:0:", -- Schematic: Flash Bomb
	[6675]=":1049:4:2:1:::1:0:", -- Tempered Bracers
	[6676]=":2246:4:2:1:::1:0:", -- Constable Buckler
	[6677]=":2401:2:2:1:::1:0:", -- Spellcrafter Wand
	[6678]=":677:4:2:1:::1:0:", -- Band of Elven Grace
	[6679]=":5823:2:3:1:::1:0:", -- Armor Piercer
	[6681]=":6249:2:3:1:::1:0:", -- Thornspike
	[6682]=":2281:4:3:1:::1:0:", -- Death Speaker Robes
	[6684]="::12:1:1:::1:0:", -- Snufflenose Command Stick
	[6685]=":1573:4:3:1:::1:0:", -- Death Speaker Mantle
	[6686]=":3152:4:3:1:::1:0:", -- Tusken Helm
	[6687]=":9930:2:3:1:::1:0:", -- Corpsemaker
	[6688]=":2471:4:3:1:::1:0:", -- Whisperwind Headdress
	[6689]=":8267:2:3:1:::1:0:", -- Wind Spirit Staff
	[6690]=":4015:4:3:1:::1:0:", -- Ferine Leggings
	[6691]=":8866:2:3:1:::1:0:", -- Swinetusk Shank
	[6692]=":9788:2:3:1:::1:0:", -- Pronged Reaver
	[6693]=":1816:4:3:1:::1:0:", -- Agamaggan\'s Clutch
	[6694]=":6309:4:3:1:::1:0:", -- Heart of Agamaggan
	[6695]=":3002:4:3:1:::1:0:", -- Stygian Bone Amulet
	[6696]=":5086:2:3:1:::1:0:", -- Nightstalker Bow
	[6697]=":2041:4:3:1:::1:0:", -- Batwing Mantle
	[6709]=":545:4:2:1:::1:0:", -- Moonglow Vest
	[6710]=":137:9:2:1:::1:0:", -- Pattern: Moonglow Vest
	[6712]=":12:15:1:1:::1:0:", -- Practice Lock
	[6713]=":10:4:1:1:::1:0:", -- Ripped Pants
	[6714]=":75:7:1:20:::1:0:", -- Ez-Thro Dynamite
	[6715]=":21:7:1:1:::1:0:", -- Ruined Jumper Cables
	[6716]=":200:9:2:1:::1:0:", -- Schematic: EZ-Thro Dynamite
	[6717]="::12:1:20:::1:0:", -- Gaffer Jack
	[6718]="::12:1:20:::1:0:", -- Electropeller
	[6719]=":1097:4:2:1:::1:0:", -- Windborne Belt
	[6720]=":3219:4:2:1:::1:0:", -- Spirit Hunter Headdress
	[6721]=":1419:4:2:1:::1:0:", -- Chestplate of Kor
	[6722]=":1331:4:2:1:::1:0:", -- Beastial Manacles
	[6723]=":8155:4:3:1:::1:0:", -- Medal of Courage
	[6725]=":6105:4:3:1:::1:0:", -- Marbled Buckler
	[6726]=":2388:4:2:1:::1:0:", -- Razzeric\'s Customized Seatbelt
	[6727]=":2996:4:2:1:::1:0:", -- Razzeric\'s Racing Grips
	[6729]=":7187:2:2:1:::1:0:", -- Fizzle\'s Zippy Lighter
	[6731]=":871:4:2:1:::1:0:", -- Ironforge Breastplate
	[6732]=":2421:4:2:1:::1:0:", -- Gnomish Mechanic\'s Gloves
	[6735]=":150:9:2:1:::1:0:", -- Plans: Ironforge Breastplate
	[6737]=":2805:4:2:1:::1:0:", -- Dryleaf Pants
	[6738]=":7040:2:2:1:::1:0:", -- Bleeding Crescent
	[6739]=":2991:2:2:1:::1:0:", -- Cliffrunner\'s Aim
	[6740]=":1001:4:2:1:::1:0:", -- Azure Sash
	[6741]=":3014:2:1:1:::1:0:", -- Orcish War Sword
	[6742]=":2830:4:3:1:::1:0:", -- Stonefist Girdle
	[6743]=":1462:4:2:1:::1:0:", -- Sustaining Ring
	[6744]=":1190:4:2:1:::1:0:", -- Gloves of Kapelan
	[6745]=":1791:4:2:1:::1:0:", -- Swiftrunner Cape
	[6746]=":7076:4:2:1:::1:0:", -- Basalt Buckler
	[6747]=":5015:4:2:1:::1:0:", -- Enforcer Pauldrons
	[6748]=":897:4:2:1:::1:0:", -- Monkey Ring
	[6749]=":897:4:2:1:::1:0:", -- Tiger Band
	[6750]=":897:4:2:1:::1:0:", -- Snake Hoop
	[6751]=":1411:4:2:1:::1:0:", -- Mourning Shawl
	[6752]=":1602:4:2:1:::1:0:", -- Lancer Boots
	[6753]="::12:1:20:::1:0:", -- Feather Charm
	[6755]="::15:1:1:::1:0:", -- A Small Container of Gems
	[6756]=":1375:1:1:1:::1:0:", -- Jewelry Box
	[6757]=":4630:4:2:1:::1:0:", -- Jaina\'s Signet Ring
	[6767]="::12:1:1:::1:0:", -- Tyranis\' Pendant
	[6773]=":7366:4:2:1:::1:0:", -- Gelkis Marauder Chain
	[6774]=":2885:4:2:1:::1:0:", -- Uthek\'s Finger
	[6776]="::12:1:1:::1:0:", -- Tome of Valor
	[6780]=":1560:4:2:1:::1:0:", -- Lilac Sash
	[6781]="::12:1:1:::1:0:", -- Bartleby\'s Mug
	[6782]="::12:1:1:::1:0:", -- Marshal Haggard\'s Badge
	[6783]="::13:1:1:::1:0:", -- Dead-tooth\'s Key
	[6784]=":2032:4:2:1:::1:0:", -- Braced Handguards
	[6785]="::12:1:1:::1:0:", -- Powers of the Void
	[6786]=":59:4:1:1:::1:0:", -- Simple Dress
	[6787]=":466:4:1:1:::1:0:", -- White Woolen Dress
	[6788]=":3331:4:2:1:::1:0:", -- Magram Hunter\'s Belt
	[6789]=":4012:4:2:1:::1:0:", -- Ceremonial Centaur Blanket
	[6790]=":1540:4:2:1:::1:0:", -- Ring of Calm
	[6791]=":3464:4:2:1:::1:0:", -- Hellion Boots
	[6792]=":4738:4:2:1:::1:0:", -- Sanguine Pauldrons
	[6793]=":3157:4:2:1:::1:0:", -- Auric Bracers
	[6794]=":2641:4:2:1:::1:0:", -- Stormfire Gauntlets
	[6795]=":500:4:1:1:::1:0:", -- White Swashbuckler\'s Shirt
	[6796]=":750:4:1:1:::1:0:", -- Red Swashbuckler\'s Shirt
	[6797]=":6362:2:2:1:::1:0:", -- Eyepoker
	[6798]=":6386:2:2:1:::1:0:", -- Blasting Hackbut
	[6799]="::12:1:1:::1:0:", -- Vejrek\'s Head
	[6800]="::12:1:20:::1:0:", -- Umbral Ore
	[6801]=":4456:4:2:1:::1:0:", -- Baroque Apron
	[6802]=":18255:2:3:1:::1:0:", -- Sword of Omen
	[6803]=":4885:4:3:1:::1:0:", -- Prophetic Cane
	[6804]=":8060:2:3:1:::1:0:", -- Windstorm Hammer
	[6805]="::12:1:1:::1:0:", -- Horn of Vorlus
	[6806]=":10209:2:3:1:::1:0:", -- Dancing Flame
	[6807]=":62:0:1:20:::1:0:", -- Frog Leg Stew
	[6808]="::12:1:20:::1:0:", -- Elunite Ore
	[6809]="::12:1:1:::1:0:", -- Elura\'s Medallion
	[6810]="::12:1:1:::1:0:", -- Surena\'s Choker
	[6811]=":25:0:1:20:::1:0:", -- Aquadynamic Fish Lens
	[6812]="::12:1:1:::1:0:", -- Case of Elunite
	[6826]=":548:15:0:10:::1:0:", -- Brilliant Scale
	[6827]=":150:15:1:1:::1:0:", -- Box of Supplies
	[6828]=":6268:4:2:1:::1:0:", -- Visionary Buckler
	[6829]=":18714:2:3:1:::1:0:", -- Sword of Serenity
	[6830]=":23476:2:3:1:::1:0:", -- Bonebiter
	[6831]=":17522:2:3:1:::1:0:", -- Black Menace
	[6832]=":3770:4:2:1:::1:0:", -- Cloak of Blight
	[6833]=":500:4:1:1:::1:0:", -- White Tuxedo Shirt
	[6834]=":1:4:1:1:::1:0:", -- Black Tuxedo
	[6835]=":504:4:1:1:::1:0:", -- Black Tuxedo Pants
	[6836]=":1:4:1:1:::1:0:", -- Dress Shoes
	[6838]="::12:1:20:::1:0:", -- Scorched Spider Fang
	[6839]="::12:1:20:::1:0:", -- Charred Horn
	[6840]="::12:1:20:::1:0:", -- Galvanized Horn
	[6841]="::12:1:1:::1:0:", -- Vial of Phlogiston
	[6842]="::12:1:1:::1:0:", -- Furen\'s Instructions
	[6843]="::12:1:1:::1:0:", -- Cask of Scalder
	[6844]="::12:1:20:::1:0:", -- Burning Blood
	[6845]="::12:1:20:::1:0:", -- Burning Rock
	[6846]="::12:1:1:::1:0:", -- Defias Script
	[6847]="::12:1:1:::1:0:", -- Dark Iron Script
	[6848]="::12:1:20:::1:0:", -- Searing Coral
	[6849]="::12:1:20:::1:0:", -- Sunscorched Shell
	[6851]="::12:1:1:::1:0:", -- Essence of the Exile
	[6866]="::12:1:1:::1:0:", -- Symbol of Life
	[6887]=":5:0:1:20:::1:0:", -- Spotted Yellowtail
	[6888]=":10:0:1:20:::1:0:", -- Herb Baked Egg
	[6889]=":4:7:1:10::185:1:0:", -- Small Egg
	[6890]=":6:0:1:20:::1:0:", -- Smoked Bear Meat
	[6892]="250:62:9:1:1:::1:0:3556,1465", -- Recipe: Smoked Bear Meat
	[6893]="::13:1:1:::1:0:", -- Workshop Key
	[6894]="::12:1:1:::1:0:", -- Whirlwind Heart
	[6895]="::12:1:1:::1:0:", -- Jordan\'s Smithing Hammer
	[6898]=":4132:4:2:1:::1:0:", -- Orb of Soran\'ruk
	[6900]=":4685:4:3:1:::1:0:", -- Enchanted Gold Bloodrobe
	[6901]=":1523:4:3:1:::1:0:", -- Glowing Thresher Cape
	[6902]=":1052:4:3:1:::1:0:", -- Bands of Serra\'kis
	[6903]=":1859:4:3:1:::1:0:", -- Gaze Dreamer Pants
	[6904]=":4665:2:3:1:::1:0:", -- Bite of Serra\'kis
	[6905]=":4813:2:3:1:::1:0:", -- Reef Axe
	[6906]=":1275:4:3:1:::1:0:", -- Algae Fists
	[6907]=":1873:4:3:1:::1:0:", -- Tortoise Armor
	[6908]=":626:4:3:1:::1:0:", -- Ghamoo-ra\'s Bind
	[6909]=":7155:2:3:1:::1:0:", -- Strike of the Hydra
	[6910]=":2298:4:3:1:::1:0:", -- Leech Pants
	[6911]=":1442:4:3:1:::1:0:", -- Moss Cinch
	[6912]="::12:1:1:::1:0:", -- Heartswood
	[6913]="::12:1:1:::1:0:", -- Heartswood Core
	[6914]="::12:1:20:::1:0:", -- Soran\'ruk Fragment
	[6915]="::12:1:1:::1:0:", -- Large Soran\'ruk Fragment
	[6926]="::12:1:1:::1:0:", -- Furen\'s Notes
	[6928]="::12:1:1:::1:0:", -- Bloodstone Choker
	[6929]="::12:1:1:::1:0:", -- Bath\'rah\'s Parchment
	[6930]="::12:1:20:::1:0:", -- Rod of Channeling
	[6931]="::12:1:1:::1:0:", -- Moldy Tome
	[6947]=":5:0:1:20:::1:0:", -- Instant Poison
	[6948]="::15:1:1:::1:0:", -- Hearthstone
	[6949]=":20:0:1:20:::1:0:", -- Instant Poison II
	[6950]=":30:0:1:20:::1:0:", -- Instant Poison III
	[6951]=":75:0:1:20:::1:0:", -- Mind-numbing Poison II
	[6952]="::12:1:20:::1:0:", -- Thick Bear Fur
	[6953]=":7459:2:3:1:::1:0:", -- Verigan\'s Fist
	[6966]=":693:2:2:1:::1:0:", -- Elunite Axe
	[6967]=":696:2:2:1:::1:0:", -- Elunite Sword
	[6968]=":698:2:2:1:::1:0:", -- Elunite Hammer
	[6969]=":701:2:2:1:::1:0:", -- Elunite Dagger
	[6970]=":906:4:2:1:::1:0:", -- Furen\'s Favor
	[6971]=":2221:4:2:1:::1:0:", -- Fire Hardened Coif
	[6972]=":3242:4:3:1:::1:0:", -- Fire Hardened Hauberk
	[6973]=":2465:4:2:1:::1:0:", -- Fire Hardened Leggings
	[6974]=":1497:4:2:1:::1:0:", -- Fire Hardened Gauntlets
	[6975]=":16766:2:3:1:::1:0:", -- Whirlwind Axe
	[6976]=":17264:2:3:1:::1:0:", -- Whirlwind Warhammer
	[6977]=":17325:2:3:1:::1:0:", -- Whirlwind Sword
	[6978]=":672:2:2:1:::1:0:", -- Umbral Axe
	[6979]=":675:2:2:1:::1:0:", -- Haggard\'s Axe
	[6980]=":677:2:2:1:::1:0:", -- Haggard\'s Dagger
	[6981]=":680:2:2:1:::1:0:", -- Umbral Dagger
	[6982]=":683:2:2:1:::1:0:", -- Umbral Mace
	[6983]=":685:2:2:1:::1:0:", -- Haggard\'s Hammer
	[6984]=":688:2:2:1:::1:0:", -- Umbral Sword
	[6985]=":690:2:2:1:::1:0:", -- Haggard\'s Sword
	[6986]=":50:15:0:10:::1:0:", -- Crimson Lotus
	[6989]="::12:1:20:::1:0:", -- Vial of Hatefury Blood
	[6990]="::12:1:1:::1:0:", -- Lesser Infernal Stone
	[6991]="::12:1:20:::1:0:", -- Smoldering Coal
	[6992]="::12:1:1:::1:0:", -- Jordan\'s Ore Shipment
	[6993]="::12:1:1:::1:0:", -- Jordan\'s Refined Ore Shipment
	[6994]="::12:1:1:::1:0:", -- Whitestone Oak Lumber
	[6995]="::12:1:1:::1:0:", -- Corrupted Kor Gem
	[6996]="::12:1:1:::1:0:", -- Jordan\'s Weapon Notes
	[6997]="::12:1:1:::1:0:", -- Tattered Manuscript
	[6998]=":774:4:2:1:::1:0:", -- Nimbus Boots
	[6999]="::12:1:1:::1:0:", -- Tome of the Cabal
	[7000]=":650:4:2:1:::1:0:", -- Heartwood Girdle
	[7001]=":3535:2:3:1:::1:0:", -- Gravestone Scepter
	[7002]=":3028:4:3:1:::1:0:", -- Arctic Buckler
	[7003]=":981:4:2:1:::1:0:", -- Beetle Clasps
	[7004]=":985:4:2:1:::1:0:", -- Prelacy Cape
	[7005]="82:16:2:1:1:::1:0:16768,6301,26744,4589,26751,16689,7947,24843,19372,12028,4225,6731,4775,843,12942,5163,16261,18277,17490,26758,26765,5783,8363,12956,1692,3958,18009,2816,21085,12043,66,26754,26752,18427,3955,26743,2225,25010,4561,3482,2697,25082,26756,8934,17486,4897,2699,11189,26759,3954,989,2821,16224,1465,3779,16262,1250,2846,11874,12943,3081,3614,12941,3168,26747,26741,26739,12022,18754,12957,3556,19196,3187,7854,26753,26742,7852,25051,26748,19450,5128,2810,15179,18426,5135,12245,5565,8160,3499,12958,24995,16613,26745,26757,4229,3366,19532,5944,26724,16748,2819,3005,26749,1286,26755,26738,2118,8145,1148,19244,777,24935,18771,4194,3367,2698,26740,5817,25019", -- Skinning Knife
	[7006]="::12:1:1:::1:0:", -- Reconstructed Tome
	[7026]=":22:4:1:1:::1:0:", -- Linen Belt
	[7046]=":1494:4:2:1:::1:0:", -- Azure Silk Pants
	[7047]=":825:4:2:1:::1:0:", -- Hands of Darkness
	[7048]=":745:4:1:1:::1:0:", -- Azure Silk Hood
	[7049]=":914:4:2:1:::1:0:", -- Truefaith Gloves
	[7050]=":999:4:1:1:::1:0:", -- Silk Headband
	[7051]=":2696:4:2:1:::1:0:", -- Earthen Vest
	[7052]=":1488:4:2:1:::1:0:", -- Azure Silk Belt
	[7053]=":2240:4:2:1:::1:0:", -- Azure Silk Cloak
	[7054]=":4701:4:3:1:::1:0:", -- Robe of Power
	[7055]=":1504:4:2:1:::1:0:", -- Crimson Silk Belt
	[7056]=":2314:4:2:1:::1:0:", -- Crimson Silk Cloak
	[7057]=":2323:4:2:1:::1:0:", -- Green Silken Shoulders
	[7058]=":2052:4:1:1:::1:0:", -- Crimson Silk Vest
	[7059]=":2781:4:2:1:::1:0:", -- Crimson Silk Shoulders
	[7060]=":2791:4:2:1:::1:0:", -- Azure Shoulders
	[7061]=":2017:4:2:1:::1:0:", -- Earthen Silk Belt
	[7062]=":2430:4:1:1:::1:0:", -- Crimson Silk Pantaloons
	[7063]=":4741:4:2:1:::1:0:", -- Crimson Silk Robe
	[7064]=":2569:4:2:1:::1:0:", -- Crimson Silk Gloves
	[7065]=":2398:4:2:1:::1:0:", -- Green Silk Armor
	[7067]=":400:7:1:10::171,164,333,202,755,165,197:1:0:", -- Elemental Earth
	[7068]=":400:7:1:10::171,164,333,202,197:1:0:", -- Elemental Fire
	[7069]=":400:7:1:10::164,202,197:1:0:", -- Elemental Air
	[7070]=":400:7:1:10::171,164,755,165,197:1:0:", -- Elemental Water
	[7071]=":100:7:1:5::165,197:1:0:", -- Iron Buckle
	[7072]=":150:7:1:10::197:1:0:", -- Naga Scale
	[7073]=":6:15:0:5:::1:0:", -- Broken Fang
	[7074]=":4:15:0:5:::1:0:", -- Chipped Claw
	[7075]=":400:7:1:10::164,333,202,755,165:1:0:", -- Core of Earth
	[7076]=":400:7:2:10::171,164,333,202,755,165,197:1:0:", -- Essence of Earth
	[7077]=":400:7:1:10::171,164,333,202,755,165,197:1:0:", -- Heart of Fire
	[7078]=":400:7:2:10::171,164,333,202,755,165,197:1:0:", -- Essence of Fire
	[7079]=":400:7:1:10::333,202,755,165,197:1:0:", -- Globe of Water
	[7080]=":400:7:2:10::171,164,333,202,165,197:1:0:", -- Essence of Water
	[7081]=":400:7:1:10::164,333,755,165:1:0:", -- Breath of Wind
	[7082]=":400:7:2:10::171,333,202,755,165,197:1:0:", -- Essence of Air
	[7083]="::12:1:1:::1:0:", -- Purified Kor Gem
	[7084]=":350:9:2:1:::1:0:", -- Pattern: Crimson Silk Shoulders
	[7085]=":350:9:2:1:::1:0:", -- Pattern: Azure Shoulders
	[7086]=":375:9:2:1:::1:0:", -- Pattern: Earthen Silk Belt
	[7087]="1200:300:9:1:1:::1:0:2670,12246", -- Pattern: Crimson Silk Cloak
	[7088]="5000:1250:9:1:1:::1:0:6568", -- Pattern: Crimson Silk Robe
	[7089]="1500:375:9:1:1:::1:0:6574,6576", -- Pattern: Azure Silk Cloak
	[7090]=":250:9:2:1:::1:0:", -- Pattern: Green Silk Armor
	[7091]=":250:9:2:1:::1:0:", -- Pattern: Truefaith Gloves
	[7092]=":250:9:2:1:::1:0:", -- Pattern: Hands of Darkness
	[7094]=":174:2:1:1:::1:0:", -- Driftwood Branch
	[7095]=":32:4:1:1:::1:0:", -- Bog Boots
	[7096]=":5:15:0:5:::1:0:", -- Plucked Feather
	[7097]=":1:0:1:20:::1:0:", -- Leg Meat
	[7098]=":6:15:0:5:::1:0:", -- Splintered Tusk
	[7099]=":6:15:0:5:::1:0:", -- Severed Pincer
	[7100]=":7:15:0:5:::1:0:", -- Sticky Ichor
	[7101]=":5:15:0:5:::1:0:", -- Bug Eye
	[7106]=":1234:4:2:1:::1:0:", -- Zodiac Gloves
	[7107]=":1858:4:2:1:::1:0:", -- Belt of the Stars
	[7108]=":209:4:2:1:::1:0:", -- Infantry Shield
	[7110]=":2070:4:2:1:::1:0:", -- Silver-thread Armor
	[7111]=":3329:4:2:1:::1:0:", -- Nightsky Armor
	[7112]=":4547:4:2:1:::1:0:", -- Aurora Armor
	[7113]=":6707:4:2:1:::1:0:", -- Mistscape Armor
	[7114]="1000:250:9:1:1:::1:0:9636,2679", -- Pattern: Azure Silk Gloves
	[7115]=":683:2:2:1:::1:0:", -- Heirloom Axe
	[7116]=":685:2:2:1:::1:0:", -- Heirloom Dagger
	[7117]=":688:2:2:1:::1:0:", -- Heirloom Hammer
	[7118]=":690:2:2:1:::1:0:", -- Heirloom Sword
	[7119]="::12:1:1:::1:0:", -- Twitching Antenna
	[7120]=":896:4:2:1:::1:0:", -- Ruga\'s Bulwark
	[7126]="::12:1:20:::1:0:", -- Smoky Iron Ingot
	[7127]="::12:1:20:::1:0:", -- Powdered Azurite
	[7128]="::12:1:20:::1:0:", -- Uncloven Satyr Hoof
	[7129]=":1546:4:2:1:::1:0:", -- Brutal Gauntlets
	[7130]=":2328:4:2:1:::1:0:", -- Brutal Helm
	[7131]="::12:1:20:::1:0:", -- Dragonmaw Shinbone
	[7132]=":2338:4:2:1:::1:0:", -- Brutal Legguards
	[7133]=":3098:4:3:1:::1:0:", -- Brutal Hauberk
	[7134]="::12:1:20:::1:0:", -- Sturdy Dragonmaw Shinbone
	[7135]="::12:0:20:::1:0:", -- Broken Dragonmaw Shinbone
	[7146]="::13:2:1:::1:0:", -- The Scarlet Key
	[7148]=":21:4:1:1:::1:0:", -- Goblin Jumper Cables
	[7166]=":194:2:1:1:::1:0:", -- Copper Dagger
	[7189]=":4712:4:2:1:::1:0:", -- Goblin Rocket Boots
	[7190]="::15:0:1:::1:0:", -- Scorched Rocket Boots
	[7191]="::7:1:5::202:1:0:", -- Fused Wiring
	[7206]="::12:1:1:::1:0:", -- Mirror Lake Water Sample
	[7207]="::12:1:1:::1:0:", -- Jennea\'s Flask
	[7208]="::13:1:1:::1:0:", -- Tazan\'s Key
	[7209]="::15:1:1:::1:0:", -- Tazan\'s Satchel
	[7226]="::12:1:1:::1:0:", -- Mage-tastic Gizmonitor
	[7227]="::12:1:1:::1:0:", -- Balnir Snapdragons
	[7228]="500:25:0:1:20:::5:0:14480,18913,6496,15353,14481,18914,24934,15354", -- Tigule and Foror\'s Strawberry Ice Cream
	[7229]=":285:4:2:1:::1:0:", -- Explorer\'s Vest
	[7230]=":3103:2:3:1:::1:0:", -- Smite\'s Mighty Hammer
	[7231]="::12:1:1:::1:0:", -- Astor\'s Letter of Introduction
	[7247]="::15:1:1:::1:0:", -- Chest of Containment Coffers
	[7249]="::12:1:20:::1:0:", -- Charged Rift Gem
	[7266]="::12:1:1:::1:0:", -- Ur\'s Treatise on Shadow Magic
	[7267]="::12:1:20:::1:0:", -- Pristine Spider Silk
	[7268]="::12:1:1:::1:0:", -- Xavian Water Sample
	[7269]="::12:1:1:::1:0:", -- Deino\'s Flask
	[7270]="::12:1:20:::1:0:", -- Laughing Sister\'s Hair
	[7272]="::12:1:1:::1:0:", -- Bolt Charged Bramble
	[7273]="::12:1:20:::1:0:", -- Witherbark Totem Stick
	[7274]="::12:1:1:::1:0:", -- Rituals of Power
	[7276]=":34:4:1:1:::1:0:", -- Handstitched Leather Cloak
	[7277]=":28:4:1:1:::1:0:", -- Handstitched Leather Bracers
	[7278]=":25:11:1:1:::1:0:", -- Light Leather Quiver
	[7279]=":25:11:1:1:::1:0:", -- Small Leather Ammo Pouch
	[7280]=":162:4:2:1:::1:0:", -- Rugged Leather Pants
	[7281]=":85:4:1:1:::1:0:", -- Light Leather Bracers
	[7282]=":599:4:2:1:::1:0:", -- Light Leather Pants
	[7283]=":415:4:2:1:::1:0:", -- Black Whelp Cloak
	[7284]=":586:4:2:1:::1:0:", -- Red Whelp Gloves
	[7285]=":589:4:2:1:::1:0:", -- Nimble Leather Gloves
	[7286]=":25:7:1:10::165:1:0:", -- Black Whelp Scale
	[7287]=":100:15:1:5::165:1:0:", -- Red Whelp Scale
	[7288]=":125:9:2:1:::1:0:", -- Pattern: Rugged Leather Pants
	[7289]="650:162:9:1:1:::1:0:2697", -- Pattern: Black Whelp Cloak
	[7290]="1600:400:9:1:1:::1:0:2679", -- Pattern: Red Whelp Gloves
	[7291]="::12:1:1:::1:0:", -- Infernal Orb
	[7292]="::12:1:20:::1:0:", -- Filled Containment Coffer
	[7293]="::12:1:20:::1:0:", -- Dalaran Mana Gem
	[7294]="::12:1:1:::1:0:", -- Andron\'s Ledger
	[7295]="::12:1:1:::1:0:", -- Tazan\'s Logbook
	[7296]=":56:15:0:5:::1:0:", -- Extinguished Torch
	[7297]="::4:1:1:::1:0:", -- Morbent\'s Bane
	[7298]=":469:2:2:1:::1:0:", -- Blade of Cunning
	[7306]="::12:1:1:::1:0:", -- Fenwick\'s Head
	[7307]=":62:0:1:20:::1:0:", -- Flesh Eating Worm
	[7308]="::12:1:1:::1:0:", -- Cantation of Manifestation
	[7309]="::12:1:1:::1:0:", -- Dalaran Status Report
	[7326]=":696:2:2:1:::1:0:", -- Thun\'grim\'s Axe
	[7327]=":698:2:2:1:::1:0:", -- Thun\'grim\'s Dagger
	[7328]=":701:2:2:1:::1:0:", -- Thun\'grim\'s Mace
	[7329]=":703:2:2:1:::1:0:", -- Thun\'grim\'s Sword
	[7330]=":3923:4:2:1:::1:0:", -- Infiltrator Buckler
	[7331]=":4330:4:2:1:::1:0:", -- Phalanx Shield
	[7332]=":6692:4:2:1:::1:0:", -- Regal Armor
	[7334]=":1544:4:2:1:::1:0:", -- Efflorescent Robe
	[7335]=":1937:4:2:1:::1:0:", -- Grizzly Tunic
	[7336]=":1509:4:2:1:::1:0:", -- Wildwood Chain
	[7337]="1000000:250000:4:1:1:::1:0:16624,2849,17512", -- The Rock
	[7338]="10000:2500:4:1:1:::1:0:16624,2849,17512", -- Mood Ring
	[7339]="250000:62500:4:1:1:::1:0:16624,2849,17512", -- Miniscule Diamond Ring
	[7340]="500000:125000:4:1:1:::1:0:16624,2849,17512", -- Flawless Diamond Solitaire
	[7341]="50000:12500:4:1:1:::1:0:16624,2849,17512", -- Cubic Zirconia Ring
	[7342]="100000:25000:4:1:1:::1:0:16624,2849,17512", -- Silver Piffeny Band
	[7343]="::12:1:1:::1:0:", -- Bingles\' Wrench
	[7344]=":5000:4:2:1:::1:0:", -- Torch of Holy Flame
	[7345]="::12:1:1:::1:0:", -- Bingles\' Screwdriver
	[7346]="::12:1:1:::1:0:", -- Bingles\' Hammer
	[7348]=":690:4:2:1:::1:0:", -- Fletcher\'s Gloves
	[7349]=":861:4:2:1:::1:0:", -- Herbalist\'s Gloves
	[7350]=":29:4:1:1:::1:0:", -- Disciple\'s Bracers
	[7351]=":58:4:1:1:::1:0:", -- Disciple\'s Boots
	[7352]=":1306:4:2:1:::1:0:", -- Earthen Leather Shoulders
	[7353]=":2998:4:2:1:::1:0:", -- Elder\'s Padded Armor
	[7354]=":1865:4:2:1:::1:0:", -- Elder\'s Boots
	[7355]=":1031:4:2:1:::1:0:", -- Elder\'s Bracers
	[7356]=":1411:4:2:1:::1:0:", -- Elder\'s Cloak
	[7357]=":1875:4:2:1:::1:0:", -- Elder\'s Hat
	[7358]=":885:4:2:1:::1:0:", -- Pilferer\'s Gloves
	[7359]=":978:4:2:1:::1:0:", -- Heavy Earthen Gloves
	[7360]=":400:9:2:1:::1:0:", -- Pattern: Dark Leather Gloves
	[7361]="1800:450:9:2:1:::1:0:6731", -- Pattern: Herbalist\'s Gloves
	[7362]="2000:500:9:1:1:::1:0:3537", -- Pattern: Earthen Leather Shoulders
	[7363]=":525:9:2:1:::1:0:", -- Pattern: Pilferer\'s Gloves
	[7364]=":550:9:2:1:::1:0:", -- Pattern: Heavy Earthen Gloves
	[7365]="::12:1:1:::1:0:", -- Gnoam Sprecklesprocket
	[7366]=":1098:4:2:1:::1:0:", -- Elder\'s Gloves
	[7367]=":1818:4:2:1:::1:0:", -- Elder\'s Mantle
	[7368]=":2677:4:2:1:::1:0:", -- Elder\'s Pants
	[7369]=":2955:4:2:1:::1:0:", -- Elder\'s Robe
	[7370]=":1012:4:2:1:::1:0:", -- Elder\'s Sash
	[7371]="2000:500:11:2:1:::1:0:17667,1287,4602,16919,16715,7976", -- Heavy Quiver
	[7372]=":500:11:2:1:::1:0:", -- Heavy Leather Ammo Pouch
	[7373]=":3097:4:2:1:::1:0:", -- Dusky Leather Leggings
	[7374]=":3760:4:2:1:::1:0:", -- Dusky Leather Armor
	[7375]=":3774:4:2:1:::1:0:", -- Green Whelp Armor
	[7376]="::12:1:1:::1:0:", -- Bingles\' Blastencapper
	[7377]=":2269:4:2:1:::1:0:", -- Frost Leather Cloak
	[7378]=":2146:4:2:1:::1:0:", -- Dusky Bracers
	[7386]=":2387:4:2:1:::1:0:", -- Green Whelp Bracers
	[7387]=":2587:4:2:1::202:1:0:", -- Dusky Belt
	[7390]=":4237:4:2:1:::1:0:", -- Dusky Boots
	[7391]=":4253:4:2:1:::1:0:", -- Swift Boots
	[7392]=":200:7:1:5::333,165:1:0:", -- Green Whelp Scale
	[7406]=":1372:4:2:1:::1:0:", -- Infiltrator Cord
	[7407]=":3666:4:2:1:::1:0:", -- Infiltrator Armor
	[7408]=":2281:4:2:1:::1:0:", -- Infiltrator Shoulders
	[7409]=":2289:4:2:1:::1:0:", -- Infiltrator Boots
	[7410]=":1174:4:2:1:::1:0:", -- Infiltrator Bracers
	[7411]=":1415:4:2:1:::1:0:", -- Infiltrator Cloak
	[7412]=":1302:4:2:1:::1:0:", -- Infiltrator Gloves
	[7413]=":2157:4:2:1:::1:0:", -- Infiltrator Cap
	[7414]=":3176:4:2:1:::1:0:", -- Infiltrator Pants
	[7415]=":1484:4:2:1:::1:0:", -- Dervish Spaulders
	[7416]=":1442:4:2:1:::1:0:", -- Phalanx Bracers
	[7417]=":2903:4:2:1:::1:0:", -- Phalanx Boots
	[7418]=":4256:4:2:1:::1:0:", -- Phalanx Breastplate
	[7419]=":1326:4:2:1:::1:0:", -- Phalanx Cloak
	[7420]=":2658:4:2:1:::1:0:", -- Phalanx Headguard
	[7421]=":1778:4:2:1:::1:0:", -- Phalanx Gauntlets
	[7422]=":1622:4:2:1:::1:0:", -- Phalanx Girdle
	[7423]=":3941:4:2:1:::1:0:", -- Phalanx Leggings
	[7424]=":2709:4:2:1:::1:0:", -- Phalanx Spaulders
	[7428]=":250:7:1:10::165:1:0:", -- Shadowcat Hide
	[7429]=":4620:4:2:1:::1:0:", -- Twilight Armor
	[7430]=":4194:4:2:1:::1:0:", -- Twilight Robe
	[7431]=":3899:4:2:1:::1:0:", -- Twilight Pants
	[7432]=":2718:4:2:1:::1:0:", -- Twilight Cowl
	[7433]=":1684:4:2:1:::1:0:", -- Twilight Gloves
	[7434]=":2536:4:2:1:::1:0:", -- Twilight Boots
	[7435]=":2749:4:2:1:::1:0:", -- Twilight Mantle
	[7436]=":2111:4:2:1:::1:0:", -- Twilight Cape
	[7437]=":1554:4:2:1:::1:0:", -- Twilight Cuffs
	[7438]=":1560:4:2:1:::1:0:", -- Twilight Belt
	[7439]=":5425:4:2:1:::1:0:", -- Sentinel Breastplate
	[7440]=":5042:4:2:1:::1:0:", -- Sentinel Trousers
	[7441]=":3514:4:2:1:::1:0:", -- Sentinel Cap
	[7442]="::12:1:1:::1:0:", -- Gyromast\'s Key
	[7443]=":2243:4:2:1:::1:0:", -- Sentinel Gloves
	[7444]=":3377:4:2:1:::1:0:", -- Sentinel Boots
	[7445]=":3660:4:2:1:::1:0:", -- Sentinel Shoulders
	[7446]=":2474:4:2:1:::1:0:", -- Sentinel Cloak
	[7447]=":2068:4:2:1:::1:0:", -- Sentinel Bracers
	[7448]=":2076:4:2:1:::1:0:", -- Sentinel Girdle
	[7449]=":625:9:2:1:::1:0:", -- Pattern: Dusky Leather Leggings
	[7450]=":500:9:2:1:::1:0:", -- Pattern: Green Whelp Armor
	[7451]="2800:700:9:2:1:::1:0:7854,4589,7852,12245,4225", -- Pattern: Green Whelp Bracers
	[7452]=":875:9:3:1:::1:0:", -- Pattern: Dusky Boots
	[7453]=":875:9:2:1:::1:0:", -- Pattern: Swift Boots
	[7454]=":5915:4:2:1:::1:0:", -- Knight\'s Breastplate
	[7455]=":5937:4:2:1:::1:0:", -- Knight\'s Legguards
	[7456]=":4139:4:2:1:::1:0:", -- Knight\'s Headguard
	[7457]=":2564:4:2:1:::1:0:", -- Knight\'s Gauntlets
	[7458]=":3983:4:2:1:::1:0:", -- Knight\'s Boots
	[7459]=":4317:4:2:1:::1:0:", -- Knight\'s Pauldrons
	[7460]=":2000:4:2:1:::1:0:", -- Knight\'s Cloak
	[7461]=":2429:4:2:1:::1:0:", -- Knight\'s Bracers
	[7462]=":2682:4:2:1:::1:0:", -- Knight\'s Girdle
	[7463]=":6202:4:2:1:::1:0:", -- Sentinel Buckler
	[7464]="::12:1:1:::1:0:", -- Glyphs of Summoning
	[7465]=":6747:4:2:1:::1:0:", -- Knight\'s Crest
	[7468]=":6763:4:2:1:::1:0:", -- Regal Robe
	[7469]=":6284:4:2:1:::1:0:", -- Regal Leggings
	[7470]=":3668:4:2:1:::1:0:", -- Regal Wizard Hat
	[7471]=":2455:4:2:1:::1:0:", -- Regal Gloves
	[7472]=":3423:4:2:1:::1:0:", -- Regal Boots
	[7473]=":3710:4:2:1:::1:0:", -- Regal Mantle
	[7474]=":3281:4:2:1:::1:0:", -- Regal Cloak
	[7475]=":2371:4:2:1:::1:0:", -- Regal Cuffs
	[7476]=":2203:4:2:1:::1:0:", -- Regal Sash
	[7477]=":8125:4:2:1:::1:0:", -- Ranger Tunic
	[7478]=":6991:4:2:1:::1:0:", -- Ranger Leggings
	[7479]=":4873:4:2:1:::1:0:", -- Ranger Helm
	[7480]=":3019:4:2:1:::1:0:", -- Ranger Gloves
	[7481]=":4908:4:2:1:::1:0:", -- Ranger Boots
	[7482]=":4926:4:2:1:::1:0:", -- Ranger Shoulders
	[7483]=":3390:4:2:1:::1:0:", -- Ranger Cloak
	[7484]=":3062:4:2:1:::1:0:", -- Ranger Wristguards
	[7485]=":3073:4:2:1:::1:0:", -- Ranger Cord
	[7486]=":9325:4:2:1:::1:0:", -- Captain\'s Breastplate
	[7487]=":8665:4:2:1:::1:0:", -- Captain\'s Leggings
	[7488]=":6038:4:2:1:::1:0:", -- Captain\'s Circlet
	[7489]=":3740:4:2:1:::1:0:", -- Captain\'s Gauntlets
	[7490]=":5680:4:2:1:::1:0:", -- Captain\'s Boots
	[7491]=":6158:4:2:1:::1:0:", -- Captain\'s Shoulderguards
	[7492]=":3015:4:2:1:::1:0:", -- Captain\'s Cloak
	[7493]=":3268:4:2:1:::1:0:", -- Captain\'s Bracers
	[7494]=":3543:4:2:1:::1:0:", -- Captain\'s Waistguard
	[7495]=":9558:4:2:1:::1:0:", -- Captain\'s Buckler
	[7496]=":8882:4:2:1:::1:0:", -- Field Plate Shield
	[7498]="::12:1:1:::1:0:", -- Top of Gelkak\'s Key
	[7499]="::12:1:1:::1:0:", -- Middle of Gelkak\'s Key
	[7500]="::12:1:1:::1:0:", -- Bottom of Gelkak\'s Key
	[7506]=":500:4:2:1:::1:0:", -- Gnomish Universal Remote
	[7507]=":400:4:2:1:::1:0:", -- Arcane Orb
	[7508]=":400:4:2:1:::1:0:", -- Ley Orb
	[7509]=":553:4:2:1:::1:0:", -- Manaweave Robe
	[7510]=":556:4:2:1:::1:0:", -- Lesser Spellfire Robes
	[7511]=":1938:4:2:1:::1:0:", -- Astral Knot Robe
	[7512]=":1945:4:2:1:::1:0:", -- Nether-lace Robe
	[7513]=":9805:2:3:1:::1:0:", -- Ragefire Wand
	[7514]=":9842:2:3:1:::1:0:", -- Icefury Wand
	[7515]=":5382:4:3:1:::1:0:", -- Celestial Orb
	[7516]="::15:1:1:::1:0:", -- Tabetha\'s Instructions
	[7517]=":9372:4:2:1:::1:0:", -- Gossamer Tunic
	[7518]=":9406:4:2:1:::1:0:", -- Gossamer Robe
	[7519]=":7635:4:2:1:::1:0:", -- Gossamer Pants
	[7520]=":5747:4:2:1:::1:0:", -- Gossamer Headpiece
	[7521]=":3560:4:2:1:::1:0:", -- Gossamer Gloves
	[7522]=":4963:4:2:1:::1:0:", -- Gossamer Boots
	[7523]=":4993:4:2:1:::1:0:", -- Gossamer Shoulderpads
	[7524]=":4297:4:2:1:::1:0:", -- Gossamer Cape
	[7525]=":3106:4:2:1:::1:0:", -- Gossamer Bracers
	[7526]=":3367:4:2:1:::1:0:", -- Gossamer Belt
	[7527]=":11284:4:2:1:::1:0:", -- Cabalist Chestpiece
	[7528]=":9894:4:2:1:::1:0:", -- Cabalist Leggings
	[7529]=":6897:4:2:1:::1:0:", -- Cabalist Helm
	[7530]=":4273:4:2:1:::1:0:", -- Cabalist Gloves
	[7531]=":6434:4:2:1:::1:0:", -- Cabalist Boots
	[7532]=":6975:4:2:1:::1:0:", -- Cabalist Spaulders
	[7533]=":4446:4:2:1:::1:0:", -- Cabalist Cloak
	[7534]=":4016:4:2:1:::1:0:", -- Cabalist Bracers
	[7535]=":4353:4:2:1:::1:0:", -- Cabalist Belt
	[7536]=":13048:4:2:1:::1:0:", -- Champion\'s Wall Shield
	[7537]=":14012:4:2:1:::1:0:", -- Gothic Shield
	[7538]=":12322:4:2:1:::1:0:", -- Champion\'s Armor
	[7539]=":12692:4:2:1:::1:0:", -- Champion\'s Leggings
	[7540]=":8845:4:2:1:::1:0:", -- Champion\'s Helmet
	[7541]=":5479:4:2:1:::1:0:", -- Champion\'s Gauntlets
	[7542]=":8284:4:2:1:::1:0:", -- Champion\'s Greaves
	[7543]=":8123:4:2:1:::1:0:", -- Champion\'s Pauldrons
	[7544]=":4296:4:2:1:::1:0:", -- Champion\'s Cape
	[7545]=":4658:4:2:1:::1:0:", -- Champion\'s Bracers
	[7546]=":5050:4:2:1:::1:0:", -- Champion\'s Girdle
	[7549]=":6420:4:2:1:::1:0:", -- Fairy\'s Embrace
	[7551]=":7145:4:2:1:::1:0:", -- Entwined Opaline Talisman
	[7552]=":2542:4:2:1:::1:0:", -- Falcon\'s Hook
	[7553]=":2542:4:2:1:::1:0:", -- Band of the Unicorn
	[7554]=":1039:4:2:1:::1:0:", -- Willow Branch
	[7555]=":7123:4:2:1:::1:0:", -- Regal Star
	[7556]=":5387:4:2:1:::1:0:", -- Twilight Orb
	[7557]=":7596:4:2:1:::1:0:", -- Gossamer Rod
	[7558]=":1609:4:2:1:::1:0:", -- Shimmering Stave
	[7559]=":666:4:2:1:::1:0:", -- Runic Cane
	[7560]="1200:300:9:1:1:::1:0:6730,5175", -- Schematic: Gnomish Universal Remote
	[7561]="2000:500:9:1:1:::1:0:3537,12246,3134,4086", -- Schematic: Goblin Jumper Cables
	[7566]="::12:1:1:::1:0:", -- Agamand Family Sword
	[7567]="::12:1:1:::1:0:", -- Agamand Family Axe
	[7568]="::12:1:1:::1:0:", -- Agamand Family Dagger
	[7569]="::12:1:1:::1:0:", -- Agamand Family Mace
	[7586]="::12:1:1:::1:0:", -- Tharnariun\'s Hope
	[7587]="::12:1:1:::1:0:", -- Thun\'grim\'s Instructions
	[7606]=":557:4:2:1:::1:0:", -- Polar Gauntlets
	[7607]=":1399:2:2:1:::1:0:", -- Sable Wand
	[7608]=":1106:4:2:1:::1:0:", -- Seer\'s Fine Stein
	[7609]=":4210:4:2:1:::1:0:", -- Elder\'s Amber Stave
	[7610]=":5811:4:2:1:::1:0:", -- Aurora Sphere
	[7611]=":7364:4:2:1:::1:0:", -- Mistscape Stave
	[7613]="2000:500:9:1:1:::1:0:2679,2698,12245", -- Pattern: Green Leather Armor
	[7626]="::12:1:1:::1:0:", -- Bundle of Furs
	[7627]="::12:1:1:::1:0:", -- Dolanaar Delivery
	[7628]="::12:1:1:::1:0:", -- Nondescript Letter
	[7629]="::12:1:1:::1:0:", -- Ukor\'s Burden
	[7646]="::12:1:1:::1:0:", -- Crate of Inn Supplies
	[7666]="::12:2:1:::1:0:", -- Shattered Necklace
	[7667]="::12:1:1:::1:0:", -- Talvash\'s Phial of Scrying
	[7668]="::15:1:1:::1:0:", -- Bloodstained Journal
	[7669]="::12:1:1:::1:0:", -- Shattered Necklace Ruby
	[7670]="::12:1:1:::1:0:", -- Shattered Necklace Sapphire
	[7671]="::12:1:1:::1:0:", -- Shattered Necklace Topaz
	[7672]="::12:1:1:::1:0:", -- Shattered Necklace Power Source
	[7673]=":8990:4:3:1:::1:0:", -- Talvash\'s Enhancing Necklace
	[7674]="::12:1:1:::1:0:", -- Delivery to Mathias
	[7675]="::12:1:1:::1:0:", -- Defias Shipping Schedule
	[7676]=":30:0:1:10:::1:0:", -- Thistle Tea
	[7678]=":50:9:1:1:::1:0:", -- Recipe: Thistle Tea
	[7682]=":7678:2:3:1:::1:0:", -- Torturing Poker
	[7683]=":7916:2:3:1:::1:0:", -- Bloody Brass Knuckles
	[7684]=":2621:4:3:1:::1:0:", -- Bloodmage Mantle
	[7685]=":5468:4:3:1:::1:0:", -- Orb of the Forgotten Seer
	[7686]=":4308:4:3:1:::1:0:", -- Ironspine\'s Eye
	[7687]=":8836:2:3:1:::1:0:", -- Ironspine\'s Fist
	[7688]=":5320:4:3:1:::1:0:", -- Ironspine\'s Ribcage
	[7689]=":11124:2:3:1:::1:0:", -- Morbid Dawn
	[7690]=":2232:4:3:1:::1:0:", -- Ebon Vise
	[7691]=":2689:4:3:1:::1:0:", -- Embalmed Shroud
	[7708]=":6649:2:3:1:::1:0:", -- Necrotic Wand
	[7709]=":3559:4:3:1:::1:0:", -- Blighted Leggings
	[7710]=":12279:2:3:1:::1:0:", -- Loksey\'s Training Stick
	[7711]=":1405:4:3:1:::1:0:", -- Robe of Doan
	[7712]=":1057:4:3:1:::1:0:", -- Mantle of Doan
	[7713]=":4777:2:3:1:::1:0:", -- Illusionary Rod
	[7714]=":3835:2:3:1:::1:0:", -- Hypnotic Blade
	[7715]="::12:1:1:::1:0:", -- Onin\'s Report
	[7717]=":18923:2:3:1:::1:0:", -- Ravager
	[7718]=":6867:4:3:1:::1:0:", -- Herod\'s Shoulder
	[7719]=":6863:4:3:1:::1:0:", -- Raging Berserker\'s Helm
	[7720]=":5356:4:3:1:::1:0:", -- Whitemane\'s Chapeau
	[7721]=":17922:2:3:1:::1:0:", -- Hand of Righteousness
	[7722]=":9295:4:3:1:::1:0:", -- Triune Amulet
	[7723]=":22567:2:3:1:::1:0:", -- Mograine\'s Might
	[7724]=":5436:4:3:1:::1:0:", -- Gauntlets of Divinity
	[7726]=":11681:4:3:1:::1:0:", -- Aegis of the Scarlet Commander
	[7727]=":2488:4:3:1:::1:0:", -- Watchman Pauldrons
	[7728]=":3223:4:3:1:::1:0:", -- Beguiler Robes
	[7729]=":5514:2:3:1:::1:0:", -- Chesterfall Musket
	[7730]=":10146:2:3:1:::1:0:", -- Cobalt Crusher
	[7731]=":3482:4:3:1:::1:0:", -- Ghostshard Talisman
	[7733]="::12:1:1:::1:0:", -- Staff of Prehistoria
	[7734]=":15495:4:3:1:::1:0:", -- Six Demon Bag
	[7735]="::12:1:1:::1:0:", -- Jannok\'s Rose
	[7736]=":11971:2:3:1:::1:0:", -- Fight Club
	[7737]="::12:1:1:::1:0:", -- Sethir\'s Journal
	[7738]=":211:4:2:1:::1:0:", -- Evergreen Gloves
	[7739]=":318:4:2:1:::1:0:", -- Timberland Cape
	[7740]="::12:1:1:::1:0:", -- Gni\'kiv Medallion
	[7741]="::12:1:1:::1:0:", -- The Shaft of Tsol
	[7742]="2400:600:9:1:1:::1:0:6777", -- Schematic: Gnomish Cloaking Device
	[7746]=":8430:4:2:1:::1:0:", -- Explorers\' League Commendation
	[7747]=":7754:4:2:1:::1:0:", -- Vile Protector
	[7749]=":4885:4:2:1:::1:0:", -- Omega Orb
	[7750]=":1712:4:2:1:::1:0:", -- Mantle of Woe
	[7751]=":1614:4:2:1:::1:0:", -- Vorrel\'s Boots
	[7752]=":6903:2:3:1:::1:0:", -- Dreamslayer
	[7753]=":7874:2:3:1:::1:0:", -- Bloodspiller
	[7754]=":1959:4:3:1:::1:0:", -- Harbinger Boots
	[7755]=":4140:4:3:1:::1:0:", -- Flintrock Shoulders
	[7756]=":1927:4:3:1:::1:0:", -- Dog Training Gloves
	[7757]=":12875:2:3:1:::1:0:", -- Windweaver Staff
	[7758]=":15074:2:3:1:::1:0:", -- Ruthless Shiv
	[7759]=":6724:4:3:1:::1:0:", -- Archon Chestpiece
	[7760]=":6074:4:3:1:::1:0:", -- Warchief Kilt
	[7761]=":11290:2:3:1:::1:0:", -- Steelclaw Reaver
	[7766]="::12:1:1:::1:0:", -- Empty Brown Waterskin
	[7767]="::12:1:1:::1:0:", -- Empty Blue Waterskin
	[7768]="::12:1:1:::1:0:", -- Empty Red Waterskin
	[7769]="::12:1:1:::1:0:", -- Filled Brown Waterskin
	[7770]="::12:1:1:::1:0:", -- Filled Blue Waterskin
	[7771]="::12:1:1:::1:0:", -- Filled Red Waterskin
	[7786]=":5605:2:3:1:::1:0:", -- Headsplitter
	[7787]=":3960:4:3:1:::1:0:", -- Resplendent Guardian
	[7806]=":10:0:1:20:::1:0:", -- Lollipop
	[7807]=":10:0:1:20:::1:0:", -- Candy Bar
	[7808]=":10:0:1:20:::1:0:", -- Chocolate Square
	[7809]=":1024:4:1:1:::1:0:", -- Easter Dress
	[7810]="::12:1:1:::1:0:", -- Vial of Purest Water
	[7811]="::12:1:1:::1:0:", -- Remaining Drops of Purest Water
	[7812]="::12:1:1:::1:0:", -- Corrupt Manifestation\'s Bracers
	[7813]="::12:1:1:::1:0:", -- Shard of Water
	[7846]="::12:1:20:::1:0:", -- Crag Coyote Fang
	[7847]="::12:1:20:::1:0:", -- Buzzard Gizzard
	[7848]="::12:1:20:::1:0:", -- Rock Elemental Shard
	[7866]="::12:1:1:::1:0:", -- Empty Thaumaturgy Vessel
	[7867]="::12:1:20:::1:0:", -- Vessel of Dragon\'s Blood
	[7870]="::12:1:1:::1:0:", -- Thaumaturgy Vessel Lockbox
	[7871]="::12:1:1:::1:0:", -- Token of Thievery
	[7886]="::12:1:1:::1:0:", -- Untranslated Journal
	[7887]="::12:1:1:::1:0:", -- Necklace and Gem Salvage
	[7888]=":8990:4:3:1:::1:0:", -- Jarkal\'s Enhancing Necklace
	[7907]="::15:1:1:::1:0:", -- Certificate of Thievery
	[7908]="::12:1:1:::1:0:", -- Klaven Mortwake\'s Journal
	[7909]=":1000:3:2:20::164,333,202,755:1:0:", -- Aquamarine
	[7910]=":5000:3:2:20::164,202,755,197:1:0:", -- Star Ruby
	[7911]=":500:7:2:20::186:1:0:", -- Truesilver Ore
	[7912]=":100:7:1:20::164,202,755:1:0:", -- Solid Stone
	[7913]=":2500:4:2:1:::1:0:", -- Barbaric Iron Shoulders
	[7914]=":3331:4:2:1:::1:0:", -- Barbaric Iron Breastplate
	[7915]=":3337:4:2:1:::1:0:", -- Barbaric Iron Helm
	[7916]=":3700:4:2:1:::1:0:", -- Barbaric Iron Boots
	[7917]=":2711:4:2:1:::1:0:", -- Barbaric Iron Gloves
	[7918]=":6466:4:2:1:::1:0:", -- Heavy Mithril Shoulder
	[7919]=":4359:4:2:1:::1:0:", -- Heavy Mithril Gauntlet
	[7920]=":8053:4:2:1:::1:0:", -- Mithril Scale Pants
	[7921]=":9427:4:2:1:::1:0:", -- Heavy Mithril Pants
	[7922]=":4152:4:1:1:::1:0:", -- Steel Plate Helm
	[7923]="::13:1:1:::1:0:", -- Defias Tower Key
	[7924]=":4103:4:2:1:::1:0:", -- Mithril Scale Bracers
	[7926]=":10416:4:2:1:::1:0:", -- Ornate Mithril Pants
	[7927]=":5257:4:2:1:::1:0:", -- Ornate Mithril Gloves
	[7928]=":8484:4:2:1:::1:0:", -- Ornate Mithril Shoulder
	[7929]=":7739:4:2:1:::1:0:", -- Orcish War Leggings
	[7930]=":12330:4:2:1:::1:0:", -- Heavy Mithril Breastplate
	[7931]=":7955:4:2:1:::1:0:", -- Mithril Coif
	[7932]=":8662:4:2:1:::1:0:", -- Mithril Scale Shoulders
	[7933]=":10077:4:2:1:::1:0:", -- Heavy Mithril Boots
	[7934]=":10114:4:2:1:::1:0:", -- Heavy Mithril Helm
	[7935]=":14645:4:2:1:::1:0:", -- Ornate Mithril Breastplate
	[7936]=":11771:4:2:1:::1:0:", -- Ornate Mithril Boots
	[7937]=":11813:4:2:1:::1:0:", -- Ornate Mithril Helm
	[7938]=":7090:4:3:1:::1:0:", -- Truesilver Gauntlets
	[7939]=":19074:4:3:1:::1:0:", -- Truesilver Breastplate
	[7941]=":12520:2:2:1:::1:0:", -- Heavy Mithril Axe
	[7942]=":14659:2:2:1:::1:0:", -- Blue Glittering Axe
	[7943]=":15892:2:2:1:::1:0:", -- Wicked Mithril Blade
	[7944]=":20092:2:2:1:::1:0:", -- Dazzling Mithril Rapier
	[7945]=":17291:2:2:1:::1:0:", -- Big Black Mace
	[7946]=":21661:2:2:1:::1:0:", -- Runed Mithril Hammer
	[7947]=":24892:2:2:1:::1:0:", -- Ebon Shiv
	[7954]=":23160:2:3:1:::1:0:", -- The Shatterer
	[7955]=":241:2:1:1:::1:0:", -- Copper Claymore
	[7956]=":1944:2:1:1:::1:0:", -- Bronze Warhammer
	[7957]=":2205:2:1:1:::1:0:", -- Bronze Greatsword
	[7958]=":2435:2:1:1:::1:0:", -- Bronze Battle Axe
	[7959]=":33858:2:3:1:::1:0:", -- Blight
	[7960]=":38548:2:3:1:::1:0:", -- Truesilver Champion
	[7961]=":25508:2:3:1:::1:0:", -- Phantom Blade
	[7963]=":6488:4:2:1:::1:0:", -- Steel Breastplate
	[7964]=":40:0:1:20:::1:0:", -- Solid Sharpening Stone
	[7965]=":40:0:1:20:::1:0:", -- Solid Weightstone
	[7966]=":200:7:1:20::164:1:0:", -- Solid Grinding Stone
	[7967]=":250:0:2:5:::1:0:", -- Mithril Shield Spike
	[7968]="::12:1:1:::1:0:", -- Southsea Treasure
	[7969]=":250:0:2:1:::1:0:", -- Mithril Spurs
	[7970]="::0:1:1:::1:0:", -- E.C.A.C.
	[7971]=":1000:3:2:20::164,333,755,165,197:1:0:", -- Black Pearl
	[7972]=":400:7:1:10::171,164,333,202,197:1:0:", -- Ichor of Undeath
	[7973]=":46:7:1:1:::1:0:", -- Big-mouth Clam
	[7974]=":50:7:1:10::185:1:0:", -- Zesty Clam Meat
	[7975]=":1500:9:2:1:::1:0:", -- Plans: Heavy Mithril Pants
	[7976]=":2000:9:3:1:::1:0:", -- Plans: Mithril Shield Spike
	[7978]=":750:9:2:1:::1:0:", -- Plans: Barbaric Iron Shoulders
	[7979]=":750:9:2:1:::1:0:", -- Plans: Barbaric Iron Breastplate
	[7980]=":850:9:2:1:::1:0:", -- Plans: Barbaric Iron Helm
	[7981]=":1100:9:2:1:::1:0:", -- Plans: Barbaric Iron Boots
	[7982]=":1100:9:2:1:::1:0:", -- Plans: Barbaric Iron Gloves
	[7983]=":2000:9:2:1:::1:0:", -- Plans: Ornate Mithril Pants
	[7984]=":2000:9:2:1:::1:0:", -- Plans: Ornate Mithril Gloves
	[7985]=":2000:9:2:1:::1:0:", -- Plans: Ornate Mithril Shoulder
	[7989]=":2500:9:2:1:::1:0:", -- Plans: Mithril Spurs
	[7990]=":2500:9:2:1:::1:0:", -- Plans: Heavy Mithril Helm
	[7991]=":2500:9:3:1:::1:0:", -- Plans: Mithril Scale Shoulders
	[7992]=":2000:9:2:1:::1:0:", -- Plans: Blue Glittering Axe
	[7993]=":2500:9:2:1:::1:0:", -- Plans: Dazzling Mithril Rapier
	[7995]="6000:1500:9:1:1:::1:0:8176,8161", -- Plans: Mithril Scale Bracers
	[7997]=":81:4:0:1:::1:0:", -- Red Defias Mask
	[8006]=":12472:2:3:1:::1:0:", -- The Ziggler
	[8007]="::0:1:1:::1:0:", -- Mana Citrine
	[8008]="::0:1:1:::1:0:", -- Mana Ruby
	[8009]="::12:1:20:::1:0:", -- Dentrium Power Stone
	[8026]="::12:1:1:::1:0:", -- Garrett Family Treasure
	[8027]="::12:1:1:::1:0:", -- Krom Stoutarm\'s Treasure
	[8028]=":2500:9:3:1:::1:0:", -- Plans: Runed Mithril Hammer
	[8029]=":2000:9:2:1:::1:0:", -- Plans: Wicked Mithril Blade
	[8030]="10000:2500:9:1:1:::1:0:11278", -- Plans: Ebon Shiv
	[8046]="::9:1:1:::1:0:", -- Kearnen\'s Journal
	[8047]="::12:1:20:::1:0:", -- Magenta Fungus Cap
	[8048]="::12:1:1:::1:0:", -- Emerald Dreamcatcher
	[8049]="::12:1:1:::1:0:", -- Gnarlpine Necklace
	[8050]="::12:1:1:::1:0:", -- Tallonkai\'s Jewel
	[8051]="::12:1:1:::1:0:", -- Flare Gun
	[8052]="::12:1:20:::1:0:", -- An\'Alleum Power Stone
	[8053]="::12:1:1:::1:0:", -- Obsidian Power Source
	[8066]="::12:1:1:::1:0:", -- Fizzule\'s Whistle
	[8067]="::6:1:200:::1:0:", -- Crafted Light Shot
	[8068]="::6:1:200:::1:0:", -- Crafted Heavy Shot
	[8069]="::6:1:200:::1:0:", -- Crafted Solid Shot
	[8070]="::12:1:1:::1:0:", -- Reward Voucher
	[8071]=":1534:2:2:1:::1:0:", -- Sizzle Stick
	[8072]="::13:1:1:::1:0:", -- Silixiz\'s Tower Key
	[8073]="::12:1:1:::1:0:", -- Cache of Zanzil\'s Altered Mixture
	[8074]="::12:1:1:::1:0:", -- Gallywix\'s Head
	[8075]="::0:1:20:::1:0:", -- Conjured Sourdough
	[8076]="::0:1:20:::1:0:", -- Conjured Sweet Roll
	[8077]="::0:1:20:::1:0:", -- Conjured Mineral Water
	[8078]="::0:1:20:::1:0:", -- Conjured Sparkling Water
	[8079]="::0:1:20:::1:0:17078", -- Conjured Crystal Water
	[8080]=":10477:4:0:1:::1:0:", -- Light Plate Chestpiece
	[8081]=":4989:4:0:1:::1:0:", -- Light Plate Belt
	[8082]=":5570:4:0:1:::1:0:", -- Light Plate Boots
	[8083]=":3980:4:0:1:::1:0:", -- Light Plate Bracers
	[8084]=":4758:4:0:1:::1:0:", -- Light Plate Gloves
	[8085]=":9194:4:0:1:::1:0:", -- Light Plate Pants
	[8086]=":6516:4:0:1:::1:0:", -- Light Plate Shoulderpads
	[8087]="::15:1:1:::1:0:", -- Sample of Zanzil\'s Altered Mixture
	[8088]="23470:4694:4:1:1:::1:0:5819,8129,1323,5812,5508,1349,4177,3095,980,16626,5126,11182,16753", -- Platemail Belt
	[8089]="35075:7015:4:1:1:::1:0:5819,8129,1323,5812,5508,1349,4177,3095,980,16626,5126,11182,16753", -- Platemail Boots
	[8090]="23653:4730:4:1:1:::1:0:5819,8129,1323,5812,5508,1349,4177,3095,980,16626,5126,11182,16753", -- Platemail Bracers
	[8091]="23742:4748:4:1:1:::1:0:5819,8129,1323,5812,5508,1349,4177,3095,980,16626,5126,11182,16753", -- Platemail Gloves
	[8092]="35479:7095:4:1:1:::1:0:5819,8129,1323,5812,5508,1349,4177,3095,980,16626,5126,11182,16753", -- Platemail Helm
	[8093]="47577:9515:4:1:1:::1:0:5819,8129,1323,5812,5508,1349,4177,3095,980,16626,5126,11182,16753", -- Platemail Leggings
	[8094]="47759:9551:4:1:1:::1:0:5819,8129,1323,5812,5508,1349,4177,3095,980,16626,5126,11182,16753", -- Platemail Armor
	[8095]="::0:1:1:::1:0:", -- Hinott\'s Oil
	[8106]=":10438:4:2:1:::1:0:", -- Hibernal Armor
	[8107]=":5938:4:2:1:::1:0:", -- Hibernal Boots
	[8108]=":3594:4:2:1:::1:0:", -- Hibernal Bracers
	[8109]=":5012:4:2:1:::1:0:", -- Hibernal Cloak
	[8110]=":3622:4:2:1:::1:0:", -- Hibernal Gloves
	[8111]=":5890:4:2:1:::1:0:", -- Hibernal Mantle
	[8112]=":8436:4:2:1:::1:0:", -- Hibernal Pants
	[8113]=":9694:4:2:1:::1:0:", -- Hibernal Robe
	[8114]=":3677:4:2:1:::1:0:", -- Hibernal Sash
	[8115]=":5980:4:2:1:::1:0:", -- Hibernal Cowl
	[8116]=":4632:4:2:1:::1:0:", -- Heraldic Belt
	[8117]=":7161:4:2:1:::1:0:", -- Heraldic Boots
	[8118]=":4436:4:2:1:::1:0:", -- Heraldic Bracers
	[8119]=":12726:4:2:1:::1:0:", -- Heraldic Breastplate
	[8120]=":4965:4:2:1:::1:0:", -- Heraldic Cloak
	[8121]=":4843:4:2:1:::1:0:", -- Heraldic Gloves
	[8122]=":7875:4:2:1:::1:0:", -- Heraldic Headpiece
	[8123]=":11276:4:2:1:::1:0:", -- Heraldic Leggings
	[8124]=":7932:4:2:1:::1:0:", -- Heraldic Spaulders
	[8125]=":6367:4:2:1:::1:0:", -- Myrmidon\'s Bracers
	[8126]=":15656:4:2:1:::1:0:", -- Myrmidon\'s Breastplate
	[8127]=":5937:4:2:1:::1:0:", -- Myrmidon\'s Cape
	[8128]=":6229:4:2:1:::1:0:", -- Myrmidon\'s Gauntlets
	[8129]=":6253:4:2:1:::1:0:", -- Myrmidon\'s Girdle
	[8130]=":9459:4:2:1:::1:0:", -- Myrmidon\'s Greaves
	[8131]=":10115:4:2:1:::1:0:", -- Myrmidon\'s Helm
	[8132]=":14485:4:2:1:::1:0:", -- Myrmidon\'s Leggings
	[8133]=":10517:4:2:1:::1:0:", -- Myrmidon\'s Pauldrons
	[8134]=":15993:4:2:1:::1:0:", -- Myrmidon\'s Defender
	[8135]=":11234:4:2:1:::1:0:", -- Chromite Shield
	[8136]="::12:1:1:::1:0:", -- Gargantuan Tumor
	[8137]=":4940:4:2:1:::1:0:", -- Chromite Bracers
	[8138]=":13416:4:2:1:::1:0:", -- Chromite Chestplate
	[8139]=":5375:4:2:1:::1:0:", -- Chromite Gauntlets
	[8140]=":4994:4:2:1:::1:0:", -- Chromite Girdle
	[8141]=":8058:4:2:1:::1:0:", -- Chromite Greaves
	[8142]=":8087:4:2:1:::1:0:", -- Chromite Barbute
	[8143]=":12647:4:2:1:::1:0:", -- Chromite Legplates
	[8144]=":8796:4:2:1:::1:0:", -- Chromite Pauldrons
	[8146]=":500:7:1:5::164,165:1:0:", -- Wicked Claw
	[8149]="::12:1:1:::1:0:", -- Voodoo Charm
	[8150]=":250:7:1:20::185,202,165:1:0:", -- Deeprock Salt
	[8151]=":250:7:1:20::202,755,165:1:0:", -- Flask of Mojo
	[8152]=":500:7:1:20::755,165:1:0:", -- Flask of Big Mojo
	[8153]=":5:7:1:20::171,164,333,202,165,197:1:0:", -- Wildvine
	[8154]=":250:7:1:20::165:1:0:", -- Scorpid Scale
	[8155]="::12:1:1:::1:0:", -- Sathrah\'s Sacrifice
	[8156]=":3907:4:2:1:::1:0:", -- Jouster\'s Wristguards
	[8157]=":9096:4:2:1:::1:0:", -- Jouster\'s Chestplate
	[8158]=":3936:4:2:1:::1:0:", -- Jouster\'s Gauntlets
	[8159]=":3950:4:2:1:::1:0:", -- Jouster\'s Girdle
	[8160]=":5901:4:2:1:::1:0:", -- Jouster\'s Greaves
	[8161]=":5922:4:2:1:::1:0:", -- Jouster\'s Visor
	[8162]=":8575:4:2:1:::1:0:", -- Jouster\'s Legplates
	[8163]=":6442:4:2:1:::1:0:", -- Jouster\'s Pauldrons
	[8165]=":500:7:1:20::165:1:0:", -- Worn Dragonscale
	[8167]=":100:7:1:20::165:1:0:", -- Turtle Scale
	[8168]=":100:7:1:20::164,165:1:0:", -- Jet Black Feather
	[8169]=":500:7:1:10::165:1:0:", -- Thick Hide
	[8170]="2000:500:7:1:20::164,333,202,165,197:1:0:14846", -- Rugged Leather
	[8171]=":500:7:1:10::165:1:0:", -- Rugged Hide
	[8172]=":500:7:1:20::165:1:0:", -- Cured Thick Hide
	[8173]=":1000:0:1:10:::1:0:", -- Thick Armor Kit
	[8174]=":4131:4:2:1:::1:0:", -- Comfortable Leather Hat
	[8175]=":5971:4:2:1:::1:0:", -- Nightscape Tunic
	[8176]=":4495:4:2:1:::1:0:", -- Nightscape Headband
	[8177]=":71:2:1:1:::1:0:", -- Practice Sword
	[8178]=":306:2:2:1:::1:0:", -- Training Sword
	[8179]=":28:2:1:1:::1:0:", -- Cadet\'s Bow
	[8180]=":240:2:2:1:::1:0:", -- Hunting Bow
	[8181]=":79:2:1:1:::1:0:", -- Hunting Rifle
	[8182]=":40:2:1:1:::1:0:", -- Pellet Rifle
	[8183]=":2426:2:2:1:::1:0:", -- Precision Bow
	[8184]=":2947:2:2:1:::1:0:", -- Firestarter
	[8185]=":10952:4:2:1:::1:0:", -- Turtle Scale Leggings
	[8186]=":2231:2:2:1:::1:0:", -- Dire Wand
	[8187]=":3477:4:2:1:::1:0:", -- Turtle Scale Gloves
	[8188]=":6414:2:2:1:::1:0:", -- Explosive Shotgun
	[8189]=":7567:4:2:1:::1:0:", -- Turtle Scale Breastplate
	[8190]=":37286:2:3:1:::1:0:", -- Hanzo Sword
	[8191]=":7780:4:2:1:::1:0:", -- Turtle Scale Helm
	[8192]=":4782:4:2:1:::1:0:", -- Nightscape Shoulders
	[8193]=":8708:4:2:1:::1:0:", -- Nightscape Pants
	[8194]=":13877:2:2:1:::1:0:", -- Goblin Nutcracker
	[8196]=":13979:2:2:1:::1:0:", -- Ebon Scimitar
	[8197]=":7158:4:2:1:::1:0:", -- Nightscape Boots
	[8198]=":4013:4:2:1:::1:0:", -- Turtle Scale Bracers
	[8199]=":24661:2:2:1:::1:0:", -- Battlefield Destroyer
	[8200]=":7275:4:2:1:::1:0:", -- Big Voodoo Robe
	[8201]=":5350:4:2:1:::1:0:", -- Big Voodoo Mask
	[8202]=":9022:4:2:1:::1:0:", -- Big Voodoo Pants
	[8203]=":8628:4:2:1:::1:0:", -- Tough Scorpid Breastplate
	[8204]=":4676:4:2:1:::1:0:", -- Tough Scorpid Gloves
	[8205]=":4346:4:2:1:::1:0:", -- Tough Scorpid Bracers
	[8206]=":12704:4:2:1:::1:0:", -- Tough Scorpid Leggings
	[8207]=":8978:4:2:1:::1:0:", -- Tough Scorpid Shoulders
	[8208]=":10272:4:2:1:::1:0:", -- Tough Scorpid Helm
	[8209]=":8375:4:2:1:::1:0:", -- Tough Scorpid Boots
	[8210]=":5537:4:2:1:::1:0:", -- Wild Leather Shoulders
	[8211]=":8002:4:2:1:::1:0:", -- Wild Leather Vest
	[8212]=":11585:4:2:1:::1:0:", -- Wild Leather Leggings
	[8213]=":8150:4:2:1:::1:0:", -- Wild Leather Boots
	[8214]=":6230:4:2:1:::1:0:", -- Wild Leather Helmet
	[8215]=":7213:4:2:1:::1:0:", -- Wild Leather Cloak
	[8216]=":6323:4:2:1:::1:0:", -- Big Voodoo Cloak
	[8217]=":1000:11:2:1:::1:0:", -- Quickdraw Quiver
	[8218]=":1000:11:2:1:::1:0:", -- Thick Leather Ammo Pouch
	[8223]=":10066:2:3:1:::1:0:", -- Blade of the Basilisk
	[8224]=":7655:2:2:1:::1:0:", -- Silithid Ripper
	[8225]=":9222:2:3:1:::1:0:", -- Tainted Pierce
	[8226]=":5747:2:3:1:::1:0:", -- The Butcher
	[8244]=":10000:12:3:20:::1:0:", -- Flawless Draenethyst Sphere
	[8245]=":12923:4:2:1:::1:0:", -- Imperial Red Tunic
	[8246]=":7917:4:2:1:::1:0:", -- Imperial Red Boots
	[8247]=":4997:4:2:1:::1:0:", -- Imperial Red Bracers
	[8248]=":7032:4:2:1:::1:0:", -- Imperial Red Cloak
	[8249]=":5336:4:2:1:::1:0:", -- Imperial Red Gloves
	[8250]=":8034:4:2:1:::1:0:", -- Imperial Red Mantle
	[8251]=":12080:4:2:1:::1:0:", -- Imperial Red Pants
	[8252]=":13623:4:2:1:::1:0:", -- Imperial Red Robe
	[8253]=":5107:4:2:1:::1:0:", -- Imperial Red Sash
	[8254]=":8640:4:2:1:::1:0:", -- Imperial Red Circlet
	[8255]=":6010:4:2:1:::1:0:", -- Serpentskin Girdle
	[8256]=":10261:4:2:1:::1:0:", -- Serpentskin Boots
	[8257]=":6053:4:2:1:::1:0:", -- Serpentskin Bracers
	[8258]=":17396:4:2:1:::1:0:", -- Serpentskin Armor
	[8259]=":7315:4:2:1:::1:0:", -- Serpentskin Cloak
	[8260]=":6938:4:2:1:::1:0:", -- Serpentskin Gloves
	[8261]=":10617:4:2:1:::1:0:", -- Serpentskin Helm
	[8262]=":14606:4:2:1:::1:0:", -- Serpentskin Leggings
	[8263]=":10373:4:2:1:::1:0:", -- Serpentskin Spaulders
	[8264]=":7857:4:2:1:::1:0:", -- Ebonhold Wristguards
	[8265]=":19914:4:2:1:::1:0:", -- Ebonhold Armor
	[8266]=":7468:4:2:1:::1:0:", -- Ebonhold Cloak
	[8267]=":8928:4:2:1:::1:0:", -- Ebonhold Gauntlets
	[8268]=":8960:4:2:1:::1:0:", -- Ebonhold Girdle
	[8269]=":14362:4:2:1:::1:0:", -- Ebonhold Boots
	[8270]=":14351:4:2:1:::1:0:", -- Ebonhold Helmet
	[8271]=":20358:4:2:1:::1:0:", -- Ebonhold Leggings
	[8272]=":13697:4:2:1:::1:0:", -- Ebonhold Shoulderpads
	[8273]=":6290:4:2:1:::1:0:", -- Valorous Wristguards
	[8274]=":17940:4:2:1:::1:0:", -- Valorous Chestguard
	[8275]=":22028:4:2:1:::1:0:", -- Ebonhold Buckler
	[8276]=":6867:4:2:1:::1:0:", -- Valorous Gauntlets
	[8277]=":6381:4:2:1:::1:0:", -- Valorous Girdle
	[8278]=":9567:4:2:1:::1:0:", -- Valorous Greaves
	[8279]=":10371:4:2:1:::1:0:", -- Valorous Helm
	[8280]=":14881:4:2:1:::1:0:", -- Valorous Legguards
	[8281]=":10450:4:2:1:::1:0:", -- Valorous Pauldrons
	[8282]=":15695:4:2:1:::1:0:", -- Valorous Shield
	[8283]=":16550:4:2:1:::1:0:", -- Arcane Armor
	[8284]=":10514:4:2:1:::1:0:", -- Arcane Boots
	[8285]=":6637:4:2:1:::1:0:", -- Arcane Bands
	[8286]=":9427:4:2:1:::1:0:", -- Arcane Cloak
	[8287]=":7087:4:2:1:::1:0:", -- Arcane Gloves
	[8288]=":11876:4:2:1:::1:0:", -- Arcane Pads
	[8289]=":16688:4:2:1:::1:0:", -- Arcane Leggings
	[8290]=":16982:4:2:1:::1:0:", -- Arcane Robe
	[8291]=":6784:4:2:1:::1:0:", -- Arcane Sash
	[8292]=":11476:4:2:1:::1:0:", -- Arcane Cover
	[8293]=":8542:4:2:1:::1:0:", -- Traveler\'s Belt
	[8294]=":12652:4:2:1:::1:0:", -- Traveler\'s Boots
	[8295]=":7988:4:2:1:::1:0:", -- Traveler\'s Bracers
	[8296]=":20145:4:2:1:::1:0:", -- Traveler\'s Jerkin
	[8297]=":9113:4:2:1:::1:0:", -- Traveler\'s Cloak
	[8298]=":8565:4:2:1:::1:0:", -- Traveler\'s Gloves
	[8299]=":14354:4:2:1:::1:0:", -- Traveler\'s Helm
	[8300]=":20172:4:2:1:::1:0:", -- Traveler\'s Leggings
	[8301]=":14463:4:2:1:::1:0:", -- Traveler\'s Spaulders
	[8302]=":11060:4:2:1:::1:0:", -- Hero\'s Bracers
	[8303]=":25164:4:2:1:::1:0:", -- Hero\'s Breastplate
	[8304]=":10513:4:2:1:::1:0:", -- Hero\'s Cape
	[8305]=":11743:4:2:1:::1:0:", -- Hero\'s Gauntlets
	[8306]=":11787:4:2:1:::1:0:", -- Hero\'s Belt
	[8307]=":18717:4:2:1:::1:0:", -- Hero\'s Boots
	[8308]=":18703:4:2:1:::1:0:", -- Hero\'s Band
	[8309]=":25377:4:2:1:::1:0:", -- Hero\'s Leggings
	[8310]=":19420:4:2:1:::1:0:", -- Hero\'s Pauldrons
	[8311]=":10287:4:2:1:::1:0:", -- Alabaster Plate Vambraces
	[8312]=":25918:4:2:1:::1:0:", -- Alabaster Breastplate
	[8313]=":28565:4:2:1:::1:0:", -- Hero\'s Buckler
	[8314]=":9405:4:2:1:::1:0:", -- Alabaster Plate Gauntlets
	[8315]=":8908:4:2:1:::1:0:", -- Alabaster Plate Girdle
	[8316]=":14110:4:2:1:::1:0:", -- Alabaster Plate Greaves
	[8317]=":15013:4:2:1:::1:0:", -- Alabaster Plate Helmet
	[8318]=":22622:4:2:1:::1:0:", -- Alabaster Plate Leggings
	[8319]=":16037:4:2:1:::1:0:", -- Alabaster Plate Pauldrons
	[8320]=":22092:4:2:1:::1:0:", -- Alabaster Shield
	[8343]="2000:500:7:1:20::165,197:1:0:16768,26744,4589,26751,7947,24843,4225,3096,6731,18749,4775,12942,8681,26765,5783,2670,12956,11557,21085,3955,25082,17486,4897,16366,2699,4189,3954,2821,18772,2846,26747,2668,12022,19196,26753,26742,25051,19450,5128,6576,1347,15179,3485,1672,5135,12245,12958,15165,16613,16767,19532,26724,16748,2819,2672,26749,19722,1286,26755,26738,16638,1148,2669,6301,16689,12028,19372,18277,5163,26758,4577,8363,5154,7940,18009,3958,2816,26752,26754,6568,25010,2225,26743,4561,2697,8934,26756,11189,4168,26759,989,3779,12943,11874,12941,3091,26739,26741,6574,12957,18754,7854,19213,7852,19521,26748,3364,2810,5565,2394,8160,1474,24995,4229,26757,26745,3366,1454,5944,6567,3005,8145,19244,18771,24935,3367,26740,2698,5817,25019", -- Heavy Silken Thread
	[8344]="::12:1:1:::1:0:", -- Silvery Spinnerets
	[8345]=":7421:4:3:1:::1:0:", -- Wolfshead Helm
	[8346]=":5363:4:3:1:::1:0:", -- Gauntlets of the Sea
	[8347]=":5980:4:3:1:::1:0:", -- Dragonscale Gauntlets
	[8348]=":10819:4:3:1:::1:0:", -- Helm of Fire
	[8349]=":14478:4:3:1:::1:0:", -- Feathered Breastplate
	[8350]=":1130:4:2:1:::1:0:", -- The 1 Ring
	[8363]="::12:1:1:::1:0:", -- Shaman Voodoo Charm
	[8364]=":6:0:1:20:::1:0:", -- Mithril Head Trout
	[8365]=":4:7:1:20::185:1:0:", -- Raw Mithril Head Trout
	[8366]=":100:15:1:1:::1:0:", -- Bloated Trout
	[8367]=":18455:4:3:1:::1:0:", -- Dragonscale Breastplate
	[8368]=":1000:7:1:10::165:1:0:", -- Thick Wolfhide
	[8383]="::15:1:1:::1:0:", -- Plain Letter
	[8384]=":875:9:3:1:::1:0:", -- Pattern: Comfortable Leather Hat
	[8385]="3500:875:9:1:1:::1:0:7854,7852", -- Pattern: Turtle Scale Gloves
	[8386]=":1000:9:2:1:::1:0:", -- Pattern: Big Voodoo Robe
	[8387]=":1000:9:2:1:::1:0:", -- Pattern: Big Voodoo Mask
	[8389]=":1250:9:2:1:::1:0:", -- Pattern: Big Voodoo Pants
	[8390]=":1250:9:2:1:::1:0:", -- Pattern: Big Voodoo Cloak
	[8391]="::12:1:20:::1:0:", -- Snickerfang Jowl
	[8392]="::12:1:20:::1:0:", -- Blasted Boar Lung
	[8393]="::12:1:20:::1:0:", -- Scorpok Pincer
	[8394]="::12:1:20:::1:0:", -- Basilisk Brain
	[8395]=":1000:9:2:1:::1:0:", -- Pattern: Tough Scorpid Breastplate
	[8396]="::12:1:20:::1:0:", -- Vulture Gizzard
	[8397]=":1000:9:2:1:::1:0:", -- Pattern: Tough Scorpid Bracers
	[8398]=":1125:9:2:1:::1:0:", -- Pattern: Tough Scorpid Gloves
	[8399]=":1250:9:2:1:::1:0:", -- Pattern: Tough Scorpid Boots
	[8400]=":1250:9:2:1:::1:0:", -- Pattern: Tough Scorpid Shoulders
	[8401]=":1375:9:2:1:::1:0:", -- Pattern: Tough Scorpid Leggings
	[8402]=":1375:9:2:1:::1:0:", -- Pattern: Tough Scorpid Helm
	[8403]="::9:2:1:::1:0:", -- Pattern: Wild Leather Shoulders
	[8404]="::9:2:1:::1:0:", -- Pattern: Wild Leather Vest
	[8405]="::9:2:1:::1:0:", -- Pattern: Wild Leather Helmet
	[8406]="::9:2:1:::1:0:", -- Pattern: Wild Leather Boots
	[8407]="::9:2:1:::1:0:", -- Pattern: Wild Leather Leggings
	[8408]="::9:2:1:::1:0:", -- Pattern: Wild Leather Cloak
	[8409]="4000:1000:9:2:1:::1:0:8160,7854", -- Pattern: Nightscape Shoulders
	[8410]="::0:1:1:::1:0:", -- R.O.I.D.S.
	[8411]="::0:1:1:::1:0:", -- Lung Juice Cocktail
	[8412]="::0:1:1:::1:0:", -- Ground Scorpok Assay
	[8423]="::0:1:1:::1:0:", -- Cerebral Cortex Compound
	[8424]="::0:1:1:::1:0:", -- Gizzard Gum
	[8425]="::15:0:20:::1:0:", -- Parrot Droppings
	[8426]="::15:0:20:::1:0:", -- Large Ruffled Feather
	[8427]="::15:0:20:::1:0:", -- Mutilated Rat Carcass
	[8428]="::12:1:1:::1:0:", -- Laden Dew Gland
	[8429]=":31:15:0:10:::1:0:", -- Punctured Dew Gland
	[8430]=":46:15:0:10:::1:0:", -- Empty Dew Gland
	[8431]="::12:1:1:::1:0:", -- Spool of Light Chartreuse Silk Thread
	[8432]="::0:1:1:::1:0:", -- Eau de Mixilpixil
	[8443]="::12:1:20:::1:0:", -- Gahz\'ridian Ornament
	[8444]="::13:1:1:::1:0:", -- Executioner\'s Key
	[8463]="::12:1:1:::1:0:", -- Warchief\'s Orders
	[8483]=":171:12:1:20:::1:0:", -- Wastewander Water Pouch
	[8484]=":68:15:1:1:::1:0:", -- Gadgetzan Water Co. Care Package
	[8485]="4000:1000:15:1:1:::1:0:6367", -- Cat Carrier (Bombay)
	[8486]="4000:1000:15:1:1:::1:0:6367", -- Cat Carrier (Cornish Rex)
	[8487]="4000:1000:15:1:1:::1:0:6367", -- Cat Carrier (Orange Tabby)
	[8488]="4000:1000:15:1:1:::1:0:6367", -- Cat Carrier (Silver Tabby)
	[8489]="6000:1500:15:1:1:::1:0:8666", -- Cat Carrier (White Kitten)
	[8490]="6000:1500:15:1:1:::1:0:20980", -- Cat Carrier (Siamese)
	[8491]=":1500:15:1:1:::1:0:", -- Cat Carrier (Black Tabby)
	[8492]=":1000:15:1:1:::1:0:", -- Parrot Cage (Green Wing Macaw)
	[8494]=":1000:15:1:1:::1:0:", -- Parrot Cage (Hyacinth Macaw)
	[8495]="4000:1000:15:1:1:::1:0:20980,2663", -- Parrot Cage (Senegal)
	[8496]="4000:1000:15:1:1:::1:0:2663", -- Parrot Cage (Cockatiel)
	[8497]="2000:500:15:1:1:::1:0:1263", -- Rabbit Crate (Snowshoe)
	[8498]=":2500:15:1:1:::1:0:", -- Tiny Emerald Whelpling
	[8499]=":2500:15:1:1:::1:0:", -- Tiny Crimson Whelpling
	[8500]="5000:1250:15:1:1:::1:0:8665", -- Great Horned Owl
	[8501]="5000:1250:15:1:1:::1:0:8665", -- Hawk Owl
	[8508]=":178:15:0:5:::1:0:", -- Large Fin
	[8523]="1000::12:1:1:::1:0:7683", -- Field Testing Kit
	[8524]="::12:2:1:::1:0:", -- Model 4711-FTZ Power Source
	[8525]="::12:1:1:::1:0:", -- Zinge\'s Purchase Order
	[8526]="::12:1:1:::1:0:", -- Violet Tragan
	[8527]="::12:1:1:::1:0:", -- Sealed Field Testing Kit
	[8528]="::12:1:1:::1:0:", -- Violet Powder
	[8529]="3500:175:0:1:20:::5:0:7564", -- Noggenfogger Elixir
	[8544]=":340:0:1:20:::1:0:", -- Mageweave Bandage
	[8545]=":800:0:1:20:::1:0:", -- Heavy Mageweave Bandage
	[8548]="::12:1:1:::1:0:", -- Divino-matic Rod
	[8563]="100000::15:3:1:::1:0:7955", -- Red Mechanostrider
	[8564]=":200:12:1:1:::1:0:", -- Hippogryph Egg
	[8584]="::12:1:1:::1:0:", -- Untapped Dowsing Widget
	[8585]="::12:1:1:::1:0:", -- Tapped Dowsing Widget
	[8586]="::15:4:1:::1:0:", -- Whistle of the Mottled Red Raptor
	[8587]="::12:1:20:::1:0:", -- Centipaar Insect Parts
	[8588]="100000::15:3:1:::1:0:7952", -- Whistle of the Emerald Raptor
	[8591]="100000::15:3:1:::1:0:7952", -- Whistle of the Turquoise Raptor
	[8592]="100000::15:3:1:::1:0:7952", -- Whistle of the Violet Raptor
	[8593]="::12:1:1:::1:0:", -- Scrimshank\'s Surveying Gear
	[8594]="::12:1:1:::1:0:", -- Insect Analysis Report
	[8595]="100000::15:3:1:::1:0:7955", -- Blue Mechanostrider
	[8603]="::12:1:1:::1:0:", -- Thistleshrub Dew
	[8623]="::12:2:1:::1:0:", -- OOX-17/TN Distress Beacon
	[8624]="1000:250:4:1:1:::1:0:8117,8121,8118,8116,8122", -- Red Sparkler
	[8625]="1000:250:4:1:1:::1:0:8117,8121,8118,8116,8122", -- White Sparkler
	[8626]="1000:250:4:1:1:::1:0:8117,8121,8118,8116,8122", -- Blue Sparkler
	[8627]="::15:1:1:::1:0:", -- Reins of the Night saber
	[8628]="::15:1:1:::1:0:", -- Reins of the Spotted Nightsaber
	[8629]="100000::15:3:1:::1:0:4730", -- Reins of the Striped Nightsaber
	[8631]="100000::15:3:1:::1:0:4730", -- Reins of the Striped Frostsaber
	[8632]="100000::15:3:1:::1:0:4730", -- Reins of the Spotted Frostsaber
	[8643]=":2500:12:1:1:::1:0:", -- Extraordinary Egg
	[8644]=":1500:12:1:1:::1:0:", -- Fine Egg
	[8645]=":750:12:1:1:::1:0:", -- Ordinary Egg
	[8646]=":250:12:1:1:::1:0:", -- Bad Egg
	[8647]="::12:1:1:::1:0:", -- Egg Crate
	[8663]="::4:2:1:::1:0:", -- Mithril Insignia
	[8683]=":1:12:1:20:::1:0:", -- Clara\'s Fresh Apple
	[8684]="::12:1:20:::1:0:", -- Hinterlands Honey Ripple
	[8685]="::12:1:1:::1:0:", -- Dran\'s Ripple Delivery
	[8686]="::12:1:1:::1:0:", -- Mithril Pendant
	[8687]="::12:1:1:::1:0:", -- Sealed Description of Thredd\'s Visitor
	[8703]=":6492:4:2:1:::1:0:", -- Signet of Expertise
	[8704]="::12:2:1:::1:0:", -- OOX-09/HL Distress Beacon
	[8705]="::12:2:1:::1:0:", -- OOX-22/FE Distress Beacon
	[8707]="::12:1:1:::1:0:", -- Gahz\'rilla\'s Electrified Scale
	[8708]="::2:4:1:::1:0:", -- Hammer of Expertise
	[8723]="::12:1:1:::1:0:", -- Caliph Scorpidsting\'s Head
	[8724]="::12:1:1:::1:0:", -- Rin\'ji\'s Secret
	[8746]=":682:4:0:1:::1:0:", -- Interlaced Cowl
	[8747]=":1036:4:0:1:::1:0:", -- Hardened Leather Helm
	[8748]=":775:4:0:1:::1:0:", -- Double Mail Coif
	[8749]=":1604:4:0:1:::1:0:", -- Crochet Hat
	[8750]=":1863:4:0:1:::1:0:", -- Thick Leather Hat
	[8751]=":2618:4:0:1:::1:0:", -- Overlinked Coif
	[8752]=":5217:4:0:1:::1:0:", -- Laminated Scale Circlet
	[8753]=":5198:4:0:1:::1:0:", -- Smooth Leather Helmet
	[8754]=":3937:4:0:1:::1:0:", -- Twill Cover
	[8755]=":6512:4:0:1:::1:0:", -- Light Plate Helmet
	[8766]="4000:200:0:1:20:::5:0:6734,14962,19559,2352,15433,7736,5688,19050,24993,20231,19315,24934,6790,10367,19528,19617,16798,19435,6928,2303,982,11103,295,19470,19679,21145,3689,4190,25012,25036,6727,18908,12959,15125,5611,734,16256,19572,23573,16585,25020,5111,5140,20916,23110,3546,14961,22922,5112,7733,6747,8152,12019,23748,3961,18905,15124,1464,19182,17277,11116,15397,7731,4875,1697,21487,1328,11118,16602,16826,18251,2806,465,4571,21110,7943,7744,3883,3577,3934,4167,3937,2832,20893,15174,955,17553,4981,6495,3621,14371,12096,5871,14624,9356,1237,274,11287,258,3298,4879,17656,19718,24834,19314,3882,25052,4181,6746,8150,7941,4893,19518,6737,21746,8143,14731,5814,19245,4266,21084,19451,6738,4191,3959,2364,6740,6741,16618,4192,2803,4255,20080,5620,8931,18906,12097,6807,3884,19296,18907,6736,18245,3086,4555,16443,14963,12196,1247,21183,6930,16739,16553,25089,6735,11038,18957,19348,11187,3881,2388,19232,8137,3411,6739,19495,16542,21484,23995,12026,17630,8125,16458,23143,11106,4195,14964,6929,18913,4782,18914,4554,7714,6091,21744,24208,4169,19352,2366,7485,6791,7737,6272,3708,9501", -- Morning Glory Dew
	[8827]=":125:0:1:20:::1:0:", -- Elixir of Water Walking
	[8831]=":300:7:1:20::171,333,197:1:0:", -- Purple Lotus
	[8836]=":95:7:1:20::171:1:0:", -- Arthas\' Tears
	[8838]=":60:7:1:20::171,333:1:0:", -- Sungrass
	[8839]=":375:7:1:20::171:1:0:", -- Blindweed
	[8845]="1500:375:7:1:20::171:1:0:14846", -- Ghost Mushroom
	[8846]="1000:250:7:1:20::171:1:0:16015", -- Gromsblood
	[8923]="200:50:15:1:20::-4:1:0:19239,16829,2622,20986,20915,1325,5169,3561,16683,3490,20081,5139,16588,4585,16268,19679,23373,19013,19049,20121,3334,10364,12097,3969,25633,18019,6779,22479,23145,1457,3090,25043,12096,1326,3135,15175,20194,18802,3551,18006,19014,3542", -- Essence of Agony
	[8924]="100:25:15:1:20::-4:1:0:19239,16829,2622,20986,20915,1325,5169,3561,16683,3490,20081,5139,16588,4585,16268,19679,23373,19013,19049,20121,3334,10364,12097,3969,25633,18019,6779,22479,23145,1457,3090,25043,12096,1326,3135,15175,20194,18802,3551,18006,19014,3542", -- Dust of Deterioration
	[8925]="2500:125:7:1:20::171,333:5:0:16768,26744,24975,1453,26751,7947,24843,2480,20915,4775,26765,4899,2848,16612,19679,5178,16705,3955,3014,25633,18019,25082,2812,17486,4897,5138,3954,4216,3135,2821,15175,20194,3348,5594,4615,26747,19239,12022,16829,20986,4610,26753,5169,26742,3548,25051,958,19450,15179,5135,12245,12958,19049,20121,16613,1313,10364,22479,26724,23145,3090,26749,19837,25043,19074,12096,1286,1326,26755,26738,1148,8305,16706,18802,3551,2380,20989,16367,6301,12028,19372,5163,1325,3561,26758,8363,16588,5139,4585,983,18009,8178,16268,11188,26754,23373,26752,3405,26743,25010,2225,3334,4561,8158,12097,18005,3010,8934,26756,11189,26759,989,3779,18006,16641,19014,12941,3542,26739,26741,12957,2622,26748,16683,3490,20081,2810,844,8157,19013,24995,26745,4229,26757,1257,3969,6779,1457,2481,8177,4226,14847,3956,8145,19244,24935,3367,5503,26740,5817,25019", -- Crystal Vial
	[8926]=":75:0:1:20:::1:0:", -- Instant Poison IV
	[8927]=":100:0:1:20:::1:0:", -- Instant Poison V
	[8928]="500:125:0:1:20:::1:0:17078", -- Instant Poison VI
	[8932]="4000:200:0:1:20:::5:0:6746,2352,21746,19232,24934,6790,10367,465,17630,2364,4891,21110,295,11106,20080,4255,483,4981,5620,19296,4894,23604,20916,4782,23521,18929,3546,1237,21744,3298,22266,19718,6930,9501,11116,16553", -- Alterac Swiss
	[8948]="4000:200:0:1:20:::5:0:14962,14964,8150,12384,12097,15125,11038,3547,5688,19471,12096,3544,14961,4554,10367,2806,5886,6739,24408,14963,3329,8152,4571,3138,23748,17656,22266,6741,15124,2803", -- Dried King Bolete
	[8949]=":200:0:1:20::165:1:0:", -- Elixir of Agility
	[8950]="4000:200:0:1:20:::5:0:6734,233,8307,19664,19518,7941,2352,6737,15433,21746,24993,3291,8143,24934,10367,23603,4266,19451,3003,3959,2364,6740,11103,3689,4190,3518,25012,4255,5620,3884,16256,4894,25020,18907,6736,3546,18245,22922,3086,6747,1247,16739,1670,25089,3480,19348,19232,18251,19038,19495,17630,4891,7744,3883,16458,3937,20893,2832,23522,3948,21744,1237,19352,11287,9099,7485,6272,7737,24834,3708,25052,5109", -- Homemade Cherry Pie
	[8951]=":200:0:1:20::165:1:0:", -- Elixir of Greater Defense
	[8952]="4000:200:0:1:20:::5:0:14962,19559,3705,4954,3960,20231,19315,3489,23263,10367,19528,21084,16798,19435,6928,5124,982,19470,19679,16618,25036,4255,18908,12959,5620,18906,12097,15125,5611,19572,4894,16585,5111,14961,3933,3935,7733,16443,14963,20097,12196,23748,22266,18905,16739,15124,1464,19182,17277,3089,3025,15397,7731,4875,18957,19348,20378,11187,3881,11118,2388,16602,16826,19038,3411,17630,4891,2814,8125,5870,23143,15174,20893,14964,17553,18913,6929,23481,3621,4782,12096,14624,18914,9356,3312,24208,4169,19352,23605,7485,4879,17656,2365,19718,4084,3368,3882,19314", -- Roasted Quail
	[8953]="4000:200:0:1:20:::5:0:14962,6735,18957,21487,7736,19050,894,21746,19471,19232,24934,5814,19223,16542,16798,21484,4191,17630,4891,3017,21145,3934,25036,4255,14964,12097,15125,734,19572,23573,12096,1671,14961,7714,21744,16443,14963,7978,3342,3961,22266,19718,15124,17277", -- Deep Fried Plantains
	[8956]=":200:0:1:5:::1:0:", -- Oil of Immolation
	[8957]="4000:200:0:1:20:::5:0:25089,11187,24993,1678,14731,8137,5814,10367,6738,3497,7943,4305,23896,16618,25012,12962,25036,17553,4255,6727,8931,4307,6807,19296,2842,25020,4200,19472,3086,3540,19045,3178,6791,23748,17656,22266,1684,16739,24834,4221,25052", -- Spinefin Halibut
	[8959]=":160:7:1:20:::1:0:", -- Raw Spinefin Halibut
	[8973]="::12:1:20:::1:0:", -- Thick Yeti Hide
	[8984]=":100:0:1:20:::1:0:", -- Deadly Poison III
	[8985]=":150:0:1:20:::1:0:", -- Deadly Poison IV
	[9030]=":200:0:1:5:::1:0:", -- Restorative Potion
	[9036]=":20:0:1:5:::1:0:", -- Magic Resistance Potion
	[9060]=":1000:7:1:20::202:1:0:", -- Inlaid Mithril Cylinder
	[9061]=":250:7:1:20::185,202:1:0:", -- Goblin Rocket Fuel
	[9088]=":250:0:1:20:::1:0:", -- Gift of Arthas
	[9144]=":250:0:1:5:::1:0:", -- Wildvine Potion
	[9149]=":250:4:2:1::171:1:0:", -- Philosopher\'s Stone
	[9153]="::12:1:1:::1:0:", -- Rig Blueprints
	[9154]=":300:0:1:20:::1:0:", -- Elixir of Detect Undead
	[9155]=":400:0:1:20:::1:0:", -- Arcane Elixir
	[9172]=":500:0:1:5:::1:0:", -- Invisibility Potion
	[9173]="::12:1:1:::1:0:", -- Goblin Transponder
	[9179]=":1000:0:1:20:::1:0:", -- Elixir of Greater Intellect
	[9186]="700:175:0:1:20:::1:0:23405,26304,23151,17078", -- Mind-numbing Poison III
	[9187]=":600:0:1:20:::1:0:", -- Elixir of Greater Agility
	[9189]="::12:1:1:::1:0:", -- Shay\'s Bell
	[9197]=":600:0:1:20:::1:0:", -- Elixir of Dream Vision
	[9206]=":700:0:1:20:::1:0:", -- Elixir of Giants
	[9210]=":750:7:1:10::197:1:0:", -- Ghost Dye
	[9214]=":2500:15:2:1:::1:0:", -- Grimoire of Inferno
	[9224]=":700:0:1:20::333:1:0:", -- Elixir of Demonslaying
	[9233]=":500:0:1:20:::1:0:", -- Elixir of Detect Demon
	[9234]="::12:1:1:::1:0:", -- Tiara of the Deep
	[9235]="::12:1:1:::1:0:", -- Pratt\'s Letter
	[9236]="::12:1:1:::1:0:", -- Jangdor\'s Letter
	[9237]="::12:1:20:::1:0:", -- Woodpaw Gnoll Mane
	[9238]="::12:1:20:::1:0:", -- Uncracked Scarab Shell
	[9240]="::12:2:1:::1:0:", -- Mallet of Zul\'Farrak
	[9241]="::12:1:1:::1:0:", -- Sacred Mallet
	[9242]=":2421:15:0:1:::1:0:", -- Ancient Tablet
	[9243]=":8155:4:2:1:::1:0:", -- Shriveled Heart
	[9244]="::12:1:1:::1:0:", -- Stoley\'s Shipment
	[9245]="::12:1:1:::1:0:", -- Stoley\'s Bottle
	[9246]="::12:1:1:::1:0:", -- Firebeard\'s Head
	[9247]="::12:1:20:::1:0:", -- Hatecrest Naga Scale
	[9248]="::12:1:1:::1:0:", -- Mysterious Relic
	[9249]=":1553:13:2:1:::1:0:", -- Captain\'s Key
	[9250]="::12:1:1:::1:0:", -- Ship Schedule
	[9251]=":62:12:1:1:::1:0:", -- Upper Map Fragment
	[9252]=":62:12:1:1:::1:0:", -- Lower Map Fragment
	[9253]=":62:12:1:1:::1:0:", -- Middle Map Fragment
	[9254]="::12:1:1:::1:0:", -- Cuergo\'s Treasure Map
	[9255]="::12:1:1:::1:0:", -- Lahassa Essence
	[9256]="::12:1:1:::1:0:", -- Imbel Essence
	[9257]="::12:1:1:::1:0:", -- Samha Essence
	[9258]="::12:1:1:::1:0:", -- Byltan Essence
	[9259]=":64:15:1:20:::1:0:", -- Troll Tribal Necklace
	[9260]="1600:400:0:1:10::171:1:0:14322", -- Volatile Rum
	[9261]=":250:15:0:10:::1:0:", -- Lead Ore
	[9262]=":1000:7:1:20::171:1:0:", -- Black Vitriol
	[9263]="::12:1:1:::1:0:", -- Troyas\' Stave
	[9264]=":35:0:1:20:::1:0:", -- Elixir of Shadow Power
	[9265]=":15:12:2:1:::1:0:", -- Cuergo\'s Hidden Treasure
	[9266]="::12:1:1:::1:0:", -- Woodpaw Battle Plans
	[9275]="::13:1:1:::1:0:", -- Cuergo\'s Key
	[9276]=":100:15:1:1:::1:0:", -- Pirate\'s Footlocker
	[9277]="::12:1:1:::1:0:", -- Techbot\'s Memory Core
	[9278]="::12:1:20:::1:0:", -- Essential Artificial
	[9279]=":45:12:1:1:::1:0:", -- White Punch Card
	[9280]="::12:1:1:::1:0:", -- Yellow Punch Card
	[9281]="::12:1:1:::1:0:", -- Red Punch Card
	[9282]="::12:1:1:::1:0:", -- Blue Punch Card
	[9283]="::12:1:1:::1:0:", -- Empty Leaden Collection Phial
	[9284]="::12:1:1:::1:0:", -- Full Leaden Collection Phial
	[9285]=":4204:4:2:1:::1:0:", -- Field Plate Vambraces
	[9286]=":10571:4:2:1:::1:0:", -- Field Plate Armor
	[9287]=":4235:4:2:1:::1:0:", -- Field Plate Gauntlets
	[9288]=":4250:4:2:1:::1:0:", -- Field Plate Girdle
	[9289]=":6350:4:2:1:::1:0:", -- Field Plate Boots
	[9290]=":6883:4:2:1:::1:0:", -- Field Plate Helmet
	[9291]=":9251:4:2:1:::1:0:", -- Field Plate Leggings
	[9292]=":6436:4:2:1:::1:0:", -- Field Plate Pauldrons
	[9293]=":1250:9:2:1:::1:0:", -- Recipe: Magic Resistance Potion
	[9294]=":2000:9:2:1:::1:0:", -- Recipe: Wildvine Potion
	[9295]=":2000:9:2:1:::1:0:", -- Recipe: Invisibility Potion
	[9296]=":2000:9:2:1:::1:0:", -- Recipe: Gift of Arthas
	[9297]=":2500:9:2:1:::1:0:", -- Recipe: Elixir of Dream Vision
	[9298]=":2250:9:2:1:::1:0:", -- Recipe: Elixir of Giants
	[9299]="::15:1:1:::1:0:", -- Thermaplugg\'s Safe Combination
	[9300]="10000:2500:9:1:1:::1:0:8177,8178", -- Recipe: Elixir of Demonslaying
	[9301]="10000:2500:9:2:1:::1:0:4610,1313", -- Recipe: Elixir of Shadow Power
	[9302]="9000:2250:9:1:1:::1:0:8158,8157", -- Recipe: Ghost Dye
	[9303]="8000:2000:9:1:1:::1:0:5594", -- Recipe: Philosopher\'s Stone
	[9304]="8000:2000:9:1:1:::1:0:5594", -- Recipe: Transmute Iron to Gold
	[9305]="8000:2000:9:1:1:::1:0:5594", -- Recipe: Transmute Mithril to Truesilver
	[9306]="::12:1:1:::1:0:", -- Stave of Equinex
	[9307]="::12:1:1:::1:0:", -- A Sparkling Stone
	[9308]=":38:12:1:20:::1:0:", -- Grime-Encrusted Object
	[9309]="::12:1:20:::1:0:", -- Robo-mechanical Guts
	[9312]="20:5:0:1:5:::1:0:8117,8121,15011,8118,8116,8122,15012", -- Blue Firework
	[9313]="20:5:0:1:5:::1:0:8117,8121,15011,8118,8116,8122,15012", -- Green Firework
	[9314]="50:12:0:1:5:::1:0:8117,8118,8116,8122,23208,8121,15011,15012", -- Red Streaks Firework
	[9315]="40:10:0:1:5:::1:0:8117,8121,15011,8118,8116,8122,15012", -- Yellow Rose Firework
	[9316]="::12:1:1:::1:0:", -- Prismatic Punch Card
	[9317]="100:25:0:1:5:::1:0:8117,8121,8118,8116,8122", -- Red, White and Blue Firework
	[9318]="20:5:0:1:5:::1:0:8117,8121,15011,8118,8116,8122,15012", -- Red Firework
	[9319]="::0:1:1:::1:0:", -- Nimboya\'s Laden Pike
	[9320]="::12:1:20:::1:0:", -- Witherbark Skull
	[9321]="::12:1:1:::1:0:", -- Venom Bottle
	[9322]="::12:1:20:::1:0:", -- Undamaged Venom Sac
	[9323]="::12:1:1:::1:0:", -- Gadrin\'s Parchment
	[9324]="::12:1:1:::1:0:", -- Shadra\'s Venom
	[9326]="::12:1:1:::1:0:", -- Grime-Encrusted Ring
	[9327]=":625:12:2:1:::1:0:", -- Security DELTA Data Access Card
	[9328]="::12:1:1:::1:0:", -- Super Snapper FX
	[9329]="::12:1:1:::1:0:", -- A Short Note
	[9330]="::12:1:1:::1:0:", -- Snapshot of Gammerita
	[9331]="::12:1:1:::1:0:", -- Feralas: A History
	[9332]=":38:15:0:20:::1:0:", -- Crusted Bandages
	[9333]=":73:4:0:20:::1:0:", -- Tarnished Silver Necklace
	[9334]=":47:15:0:10:::1:0:", -- Cracked Pottery
	[9335]=":52:15:0:5:::1:0:", -- Broken Obsidian Club
	[9336]=":1288:15:0:5:::1:0:", -- Gold-capped Troll Tusk
	[9355]=":376:15:0:20:::1:0:", -- Hoop Earring
	[9356]=":217:15:0:5:::1:0:", -- A Wooden Leg
	[9357]=":227:15:0:10:::1:0:", -- A Parrot Skeleton
	[9358]=":228:15:0:20:::1:0:", -- A Head Rag
	[9359]=":19577:2:3:1:::1:0:", -- Wirt\'s Third Leg
	[9360]=":400:0:1:1:::1:0:", -- Cuergo\'s Gold
	[9361]=":400:0:1:1:::1:0:", -- Cuergo\'s Gold with Worm
	[9362]="::4:2:1:::1:0:", -- Brilliant Gold Ring
	[9363]=":12:15:1:1:::1:0:", -- Sparklematic-Wrapped Box
	[9364]="::12:1:1:::1:0:", -- Heavy Leaden Collection Phial
	[9365]="::12:1:1:::1:0:", -- High Potency Radioactive Fallout
	[9366]=":3689:4:2:1:::1:0:", -- Golden Scale Gauntlets
	[9367]=":1250:9:2:1:::1:0:", -- Plans: Golden Scale Gauntlets
	[9368]="::12:1:1:::1:0:", -- Jer\'kai\'s Signet Ring
	[9369]="::12:1:20:::1:0:", -- Iridescent Sprite Darter Wing
	[9370]="::12:1:1:::1:0:", -- Gordunni Scroll
	[9371]="::12:1:1:::1:0:", -- Gordunni Orb
	[9372]=":61936:2:4:1:::1:0:", -- Sul\'thraze the Lasher
	[9375]=":4220:4:3:1:::1:0:", -- Expert Goldminer\'s Helmet
	[9378]=":11380:2:3:1:::1:0:", -- Shovelphlange\'s Mining Axe
	[9379]=":26383:2:3:1:::1:0:", -- Sang\'thraze the Deflector
	[9381]=":8628:2:3:1:::1:0:", -- Earthen Rod
	[9382]=":3608:4:2:1:::1:0:", -- Tromping Miner\'s Boots
	[9383]=":16895:2:3:1:::1:0:", -- Obsidian Cleaver
	[9384]=":9789:2:3:1:::1:0:", -- Stonevault Shiv
	[9385]=":12281:2:3:1:::1:0:", -- Archaic Defender
	[9386]=":9859:2:3:1:::1:0:", -- Excavator\'s Brand
	[9387]=":7208:4:3:1:::1:0:", -- Revelosh\'s Boots
	[9388]=":3835:4:3:1:::1:0:", -- Revelosh\'s Armguards
	[9389]=":5198:4:3:1:::1:0:", -- Revelosh\'s Spaulders
	[9390]=":2576:4:3:1:::1:0:", -- Revelosh\'s Gloves
	[9391]=":12831:2:3:1:::1:0:", -- The Shoveler
	[9392]=":12980:2:3:1:::1:0:", -- Annealed Blade
	[9393]=":7882:4:3:1:::1:0:", -- Beacon of Hope
	[9394]=":2397:4:3:1:::1:0:", -- Horned Viking Helmet
	[9395]=":1565:4:3:1:::1:0:", -- Gloves of Old
	[9396]=":7319:4:3:1:::1:0:", -- Legguards of the Vault
	[9397]=":3672:4:3:1:::1:0:", -- Energy Cloak
	[9398]=":1493:4:3:1:::1:0:", -- Worn Running Boots
	[9399]=":3:6:2:200:::1:0:", -- Precision Arrow
	[9400]=":3248:2:3:1:::1:0:", -- Baelog\'s Shortbow
	[9401]=":5070:2:3:1:::1:0:", -- Nordic Longshank
	[9402]=":25308:4:3:1:::1:0:", -- Earthborn Kilt
	[9403]=":2662:4:3:1:::1:0:", -- Battered Viking Shield
	[9404]=":2819:4:3:1:::1:0:", -- Olaf\'s All Purpose Shield
	[9405]=":2055:4:3:1:::1:0:", -- Girdle of Golem Strength
	[9406]=":4161:4:3:1:::1:0:", -- Spirewind Fetter
	[9407]=":5094:4:3:1:::1:0:", -- Stoneweaver Leggings
	[9408]=":18639:2:3:1:::1:0:", -- Ironshod Bludgeon
	[9409]=":4490:4:3:1:::1:0:", -- Ironaya\'s Bracers
	[9410]=":6662:4:3:1:::1:0:", -- Cragfists
	[9411]=":8587:4:3:1:::1:0:", -- Rockshard Pauldrons
	[9412]=":16681:2:3:1:::1:0:", -- Galgann\'s Fireblaster
	[9413]=":32249:2:3:1:::1:0:", -- The Rockpounder
	[9414]=":10374:4:3:1:::1:0:", -- Oilskin Leggings
	[9415]=":8997:4:3:1:::1:0:", -- Grimlok\'s Tribal Vestments
	[9416]=":28218:2:3:1:::1:0:", -- Grimlok\'s Charge
	[9418]=":32851:2:3:1:::1:0:", -- Stoneslayer
	[9419]=":21692:2:3:1:::1:0:", -- Galgann\'s Firehammer
	[9420]=":4083:4:3:1:::1:0:", -- Adventurer\'s Pith Helmet
	[9421]="::0:1:1:::1:0:", -- Major Healthstone
	[9422]=":13052:2:3:1:::1:0:", -- Shadowforge Bushmaster
	[9423]=":25464:2:3:1:::1:0:", -- The Jackhammer
	[9424]=":13594:2:3:1:::1:0:", -- Ginn-su Sword
	[9425]=":21489:2:3:1:::1:0:", -- Pendulum of Doom
	[9426]=":10275:2:3:1:::1:0:", -- Monolithic Bow
	[9427]=":14853:2:3:1:::1:0:", -- Stonevault Bonebreaker
	[9428]=":2096:4:3:1:::1:0:", -- Unearthed Bands
	[9429]=":5236:4:3:1:::1:0:", -- Miner\'s Hat of the Deep
	[9430]=":8553:4:3:1:::1:0:", -- Spaulders of a Lost Age
	[9431]=":4885:4:3:1:::1:0:", -- Papal Fez
	[9432]=":5327:4:3:1:::1:0:", -- Skullplate Bracers
	[9433]=":4133:4:3:1:::1:0:", -- Forgotten Wraps
	[9434]=":5648:4:3:1:::1:0:", -- Elemental Raiment
	[9435]=":2916:4:3:1:::1:0:", -- Reticulated Bone Gauntlets
	[9436]="::12:1:1:::1:0:", -- Faranell\'s Parcel
	[9437]="::12:1:20:::1:0:", -- Untested Basilisk Sample
	[9438]="::12:1:20:::1:0:", -- Acceptable Scorpid Sample
	[9439]="::12:1:20:::1:0:", -- Untested Hyena Sample
	[9440]="::12:1:20:::1:0:", -- Acceptable Basilisk Sample
	[9441]="::12:1:20:::1:0:", -- Acceptable Hyena Sample
	[9442]="::12:1:20:::1:0:", -- Untested Scorpid Sample
	[9444]=":1120:4:1:1:::1:0:", -- Techbot CPU Shell
	[9445]=":2260:4:3:1:::1:0:", -- Grubbis Paws
	[9446]=":7564:2:3:1:::1:0:", -- Electrocutioner Leg
	[9447]=":3237:4:3:1:::1:0:", -- Electrocutioner Lagnut
	[9448]=":1385:4:3:1:::1:0:", -- Spidertank Oilrag
	[9449]=":9564:2:3:1:::1:0:", -- Manual Crowd Pummeler
	[9450]=":2618:4:3:1:::1:0:", -- Gnomebot Operating Boots
	[9451]=":25:0:1:20:::1:0:", -- Bubbling Water
	[9452]=":8210:2:3:1:::1:0:", -- Hydrocane
	[9453]=":6592:2:3:1:::1:0:", -- Toxic Revenger
	[9454]=":1984:4:3:1:::1:0:", -- Acidic Walkers
	[9455]=":1826:4:3:1:::1:0:", -- Emissary Cuffs
	[9456]=":6652:2:3:1:::1:0:", -- Glass Shooter
	[9457]=":8902:2:3:1:::1:0:", -- Royal Diplomatic Scepter
	[9458]=":6918:4:3:1:::1:0:", -- Thermaplugg\'s Central Core
	[9459]=":13560:2:3:1:::1:0:", -- Thermaplugg\'s Left Arm
	[9460]="::12:1:20:::1:0:", -- Grimtotem Horn
	[9461]=":4586:4:3:1:::1:0:", -- Charged Gear
	[9462]="::12:1:1:::1:0:", -- Crate of Grimtotem Horns
	[9463]="::12:1:20:::1:0:", -- Gordunni Cobalt
	[9465]=":18561:2:3:1:::1:0:", -- Digmaster 5000
	[9466]="::12:1:1:::1:0:", -- Orwin\'s Shovel
	[9467]=":22418:2:3:1:::1:0:", -- Gahz\'rilla Fang
	[9468]="::12:1:1:::1:0:", -- Sharpbeak\'s Feather
	[9469]=":14634:4:3:1:::1:0:", -- Gahz\'rilla Scale Armor
	[9470]=":7858:4:3:1:::1:0:", -- Bad Mojo Mask
	[9471]="::12:1:1:::1:0:", -- Nekrum\'s Medallion
	[9472]="::13:1:1:::1:0:", -- Hexx\'s Key
	[9473]=":13241:4:3:1:::1:0:", -- Jinxed Hoodoo Skin
	[9474]=":13290:4:3:1:::1:0:", -- Jinxed Hoodoo Kilt
	[9475]=":33346:2:3:1:::1:0:", -- Diabolic Skiver
	[9476]=":15010:4:3:1:::1:0:", -- Big Bad Pauldrons
	[9477]=":35936:2:3:1:::1:0:", -- The Chief\'s Enforcer
	[9478]=":28853:2:3:1:::1:0:", -- Ripsaw
	[9479]=":10858:4:3:1:::1:0:", -- Embrace of the Lycan
	[9480]=":31725:2:3:1:::1:0:", -- Eyegouger
	[9481]=":34067:2:3:1:::1:0:", -- The Minotaur
	[9482]=":29585:2:3:1:::1:0:", -- Witch Doctor\'s Cane
	[9483]=":19139:2:3:1:::1:0:", -- Flaming Incinerator
	[9484]=":10962:4:3:1:::1:0:", -- Spellshock Leggings
	[9485]=":5288:2:3:1:::1:0:", -- Vibroblade
	[9486]=":5483:2:3:1:::1:0:", -- Supercharger Battle Axe
	[9487]=":3632:2:3:1:::1:0:", -- Hi-tech Supergun
	[9488]=":4419:2:3:1:::1:0:", -- Oscillating Power Hammer
	[9489]=":3690:2:2:1:::1:0:", -- Gyromatic Icemaker
	[9490]=":6122:2:3:1:::1:0:", -- Gizmotron Megachopper
	[9491]=":1308:4:3:1:::1:0:", -- Hotshot Pilot\'s Gloves
	[9492]=":3172:4:3:1:::1:0:", -- Electromagnetic Gigaflux Reactivator
	[9507]="::12:1:1:::1:0:", -- A Carefully-packed Crate
	[9508]=":2352:4:3:1:::1:0:", -- Mechbuilder\'s Overalls
	[9509]=":2683:4:3:1:::1:0:", -- Petrolspill Leggings
	[9510]=":2945:4:3:1:::1:0:", -- Caverndeep Trudgers
	[9511]=":21060:2:3:1:::1:0:", -- Bloodletter Scalpel
	[9512]=":6341:4:3:1:::1:0:", -- Blackmetal Cape
	[9513]=":620:2:2:1:::1:0:", -- Ley Staff
	[9514]=":306:2:2:1:::1:0:", -- Arcane Staff
	[9515]=":2011:4:2:1:::1:0:", -- Nether-lace Tunic
	[9516]=":2071:4:2:1:::1:0:", -- Astral Knot Blouse
	[9517]=":15737:2:3:1:::1:0:", -- Celestial Stave
	[9518]=":1900:4:2:1:::1:0:", -- Mud\'s Crushers
	[9519]=":2288:4:2:1:::1:0:", -- Durtfeet Stompers
	[9520]=":11461:2:2:1:::1:0:", -- Silent Hunter
	[9521]=":14382:2:2:1:::1:0:", -- Skullsplitter
	[9522]=":4938:4:2:1:::1:0:", -- Energized Stone Circle
	[9523]="::12:1:20:::1:0:", -- Troll Temper
	[9527]=":21613:2:2:1:::1:0:", -- Spellshifter Rod
	[9528]="::12:1:1:::1:0:", -- Edana\'s Dark Heart
	[9530]="::12:1:1:::1:0:", -- Horn of Hatetalon
	[9531]=":9195:4:2:1:::1:0:", -- Gemshale Pauldrons
	[9533]=":7092:4:3:1:::1:0:", -- Masons Fraternity Ring
	[9534]=":8847:4:3:1:::1:0:", -- Engineer\'s Guild Headpiece
	[9535]=":1406:4:2:1:::1:0:", -- Fire-welded Bracers
	[9536]=":1411:4:2:1:::1:0:", -- Fairywing Mantle
	[9538]=":6463:4:3:1:::1:0:", -- Talvash\'s Gold Ring
	[9539]=":50:15:1:1:::1:0:", -- Box of Rations
	[9540]=":150:15:1:1:::1:0:", -- Box of Spells
	[9541]=":200:15:1:1:::1:0:", -- Box of Goodies
	[9542]="::12:1:1:::1:0:", -- Simple Letter
	[9543]="::12:1:1:::1:0:", -- Simple Rune
	[9544]="::12:1:1:::1:0:", -- Simple Memorandum
	[9545]="::12:1:1:::1:0:", -- Simple Sigil
	[9546]="::12:1:1:::1:0:", -- Simple Scroll
	[9547]="::12:1:1:::1:0:", -- Simple Note
	[9548]="::12:1:1:::1:0:", -- Hallowed Letter
	[9550]="::12:1:1:::1:0:", -- Encrypted Rune
	[9551]="::12:1:1:::1:0:", -- Encrypted Sigil
	[9552]="::12:1:1:::1:0:", -- Rune-Inscribed Note
	[9553]="::12:1:1:::1:0:", -- Etched Parchment
	[9554]="::12:1:1:::1:0:", -- Encrypted Tablet
	[9555]="::12:1:1:::1:0:", -- Encrypted Letter
	[9556]="::12:1:1:::1:0:", -- Hallowed Rune
	[9557]="::12:1:1:::1:0:", -- Hallowed Sigil
	[9558]="::12:1:1:::1:0:", -- Encrypted Memorandum
	[9559]="::12:1:1:::1:0:", -- Encrypted Scroll
	[9560]="::12:1:1:::1:0:", -- Encrypted Parchment
	[9561]="::12:1:1:::1:0:", -- Hallowed Tablet
	[9562]="::12:1:1:::1:0:", -- Rune-Inscribed Tablet
	[9563]="::12:1:1:::1:0:", -- Consecrated Rune
	[9564]="::12:1:1:::1:0:", -- Etched Tablet
	[9565]="::12:1:1:::1:0:", -- Etched Note
	[9566]="::12:1:1:::1:0:", -- Etched Rune
	[9567]="::12:1:1:::1:0:", -- Etched Sigil
	[9568]="::12:1:1:::1:0:", -- Rune-Inscribed Parchment
	[9569]="::12:1:1:::1:0:", -- Hallowed Scroll
	[9570]="::12:1:1:::1:0:", -- Consecrated Letter
	[9571]="::12:1:1:::1:0:", -- Glyphic Letter
	[9573]="::12:1:1:::1:0:", -- Glyphic Memorandum
	[9574]="::12:1:1:::1:0:", -- Glyphic Scroll
	[9575]="::12:1:1:::1:0:", -- Glyphic Tablet
	[9576]="::12:1:1:::1:0:", -- Tainted Letter
	[9577]="::12:1:1:::1:0:", -- Tainted Memorandum
	[9578]="::12:1:1:::1:0:", -- Tainted Scroll
	[9579]="::12:1:1:::1:0:", -- Tainted Parchment
	[9580]="::12:1:1:::1:0:", -- Verdant Sigil
	[9581]="::12:1:1:::1:0:", -- Verdant Note
	[9587]=":6250:1:1:1:::1:0:", -- Thawpelt Sack
	[9588]=":6463:4:3:1:::1:0:", -- Nogg\'s Gold Ring
	[9589]="::12:1:20:::1:0:", -- Encrusted Minerals
	[9590]="::12:1:2:::1:0:", -- Splintered Log
	[9591]="::12:1:20:::1:0:", -- Resilient Sinew
	[9592]="::12:1:40:::1:0:", -- Metallic Fragments
	[9593]="::12:1:20:::1:0:", -- Treant Muisek
	[9594]="::12:1:20:::1:0:", -- Wildkin Muisek
	[9595]="::12:1:20:::1:0:", -- Hippogryph Muisek
	[9596]="::12:1:20:::1:0:", -- Faerie Dragon Muisek
	[9597]="::12:1:20:::1:0:", -- Mountain Giant Muisek
	[9598]=":94:4:2:1:::1:0:", -- Sleeping Robes
	[9599]=":142:4:2:1:::1:0:", -- Barkmail Leggings
	[9600]=":93:4:1:1:::1:0:", -- Lace Pants
	[9601]=":87:4:1:1:::1:0:", -- Cushioned Boots
	[9602]=":301:2:2:1:::1:0:", -- Brushwood Blade
	[9603]=":302:2:2:1:::1:0:", -- Gritroot Staff
	[9604]=":5632:2:2:1:::1:0:", -- Mechanic\'s Pipehammer
	[9605]=":1356:4:2:1:::1:0:", -- Repairman\'s Cape
	[9606]="::12:1:1:::1:0:", -- Treant Muisek Vessel
	[9607]=":1762:4:2:1:::1:0:", -- Bastion of Stormwind
	[9608]=":5028:2:2:1:::1:0:", -- Shoni\'s Disarming Tool
	[9609]=":1009:4:2:1:::1:0:", -- Shilly Mitts
	[9618]="::12:1:1:::1:0:", -- Wildkin Muisek Vessel
	[9619]="::12:1:1:::1:0:", -- Hippogryph Muisek Vessel
	[9620]="::12:1:1:::1:0:", -- Faerie Dragon Muisek Vessel
	[9621]="::12:1:1:::1:0:", -- Mountain Giant Muisek Vessel
	[9622]=":5665:4:2:1:::1:0:", -- Reedknot Ring
	[9623]=":4198:4:3:1:::1:0:", -- Civinad Robes
	[9624]=":5267:4:3:1:::1:0:", -- Triprunner Dungarees
	[9625]=":6344:4:3:1:::1:0:", -- Dual Reinforced Leggings
	[9626]=":16243:2:2:1:::1:0:", -- Dwarven Charge
	[9627]=":2542:4:2:1:::1:0:", -- Explorer\'s League Lodestar
	[9628]="::12:1:1:::1:0:", -- Neeru\'s Herb Pouch
	[9629]="::12:1:1:::1:0:", -- A Shrunken Head
	[9630]=":5780:4:2:1:::1:0:", -- Pratt\'s Handcrafted Boots
	[9631]=":3868:4:2:1:::1:0:", -- Pratt\'s Handcrafted Gloves
	[9632]=":3883:4:2:1:::1:0:", -- Jangdor\'s Handcrafted Gloves
	[9633]=":5847:4:2:1:::1:0:", -- Jangdor\'s Handcrafted Boots
	[9634]=":3381:4:2:1:::1:0:", -- Skilled Handling Gloves
	[9635]=":4713:4:2:1:::1:0:", -- Master Apothecary Cape
	[9636]=":3154:4:2:1:::1:0:", -- Swashbuckler Sash
	[9637]=":8296:4:2:1:::1:0:", -- Shinkicker Boots
	[9638]=":6875:4:2:1:::1:0:", -- Chelonian Cuffs
	[9639]=":24111:2:3:1:::1:0:", -- The Hand of Antu\'sul
	[9640]=":8519:4:3:1:::1:0:", -- Vice Grips
	[9641]=":13041:4:3:1:::1:0:", -- Lifeblood Amulet
	[9642]=":2092:4:2:1:::1:0:", -- Band of the Great Tortoise
	[9643]=":15988:4:2:1:::1:0:", -- Optomatic Deflector
	[9644]=":9885:4:2:1:::1:0:", -- Thermotastic Egg Timer
	[9645]=":6768:4:2:1:::1:0:", -- Gnomish Inventor Boots
	[9646]=":11863:4:2:1:::1:0:", -- Gnomish Water Sinking Device
	[9647]=":7962:4:2:1:::1:0:", -- Failed Flying Experiment
	[9648]=":6392:4:2:1:::1:0:", -- Chainlink Towel
	[9649]=":15875:4:3:1:::1:0:", -- Royal Highmark Vestments
	[9650]=":21619:4:3:1:::1:0:", -- Honorguard Chestpiece
	[9651]=":32193:2:3:1:::1:0:", -- Gryphon Rider\'s Stormhammer
	[9652]=":16159:4:3:1:::1:0:", -- Gryphon Rider\'s Leggings
	[9653]=":6745:4:2:1:::1:0:", -- Speedy Racer Goggles
	[9654]=":16929:2:2:1:::1:0:", -- Cairnstone Sliver
	[9655]=":7092:4:2:1:::1:0:", -- Seedtime Hoop
	[9656]=":7482:4:2:1:::1:0:", -- Granite Grips
	[9657]=":5333:4:2:1:::1:0:", -- Vinehedge Cinch
	[9658]=":4086:4:2:1:::1:0:", -- Boots of the Maharishi
	[9660]=":4227:4:2:1:::1:0:", -- Stargazer Cloak
	[9661]=":9051:4:2:1:::1:0:", -- Earthclasp Barrier
	[9662]=":7437:4:2:1:::1:0:", -- Rushridge Boots
	[9663]=":9969:4:2:1:::1:0:", -- Dawnrider\'s Chestpiece
	[9664]=":8738:4:2:1:::1:0:", -- Sentinel\'s Guard
	[9665]=":4827:4:2:1:::1:0:", -- Wingcrest Gloves
	[9666]=":7266:4:2:1:::1:0:", -- Stronghorn Girdle
	[9678]=":17486:2:2:1:::1:0:", -- Tok\'kar\'s Murloc Basher
	[9679]=":17550:2:2:1:::1:0:", -- Tok\'kar\'s Murloc Chopper
	[9680]=":14090:2:2:1:::1:0:", -- Tok\'kar\'s Murloc Shanker
	[9681]=":50:0:1:20:::1:0:", -- Grilled King Crawler Legs
	[9682]=":3832:4:2:1:::1:0:", -- Leather Chef\'s Belt
	[9683]=":38459:2:3:1:::1:0:", -- Strength of the Treant
	[9684]=":30875:2:3:1:::1:0:", -- Force of the Hippogryph
	[9686]=":31097:2:3:1:::1:0:", -- Spirit of the Faerie Dragon
	[9687]=":1554:4:2:1:::1:0:", -- Grappler\'s Belt
	[9698]=":1505:4:2:1:::1:0:", -- Gloves of Insight
	[9699]=":1812:4:2:1:::1:0:", -- Garrison Cloak
	[9703]=":4272:4:2:1:::1:0:", -- Scorched Cape
	[9704]=":3573:4:2:1:::1:0:", -- Rustler Gloves
	[9705]=":3586:4:2:1:::1:0:", -- Tharg\'s Shoelace
	[9706]=":9212:4:2:1:::1:0:", -- Tharg\'s Disk
	[9718]=":11421:2:3:1:::1:0:", -- Reforged Blade of Heroes
	[9719]=":6250:7:3:1:::1:0:", -- Broken Blade of Heroes
	[9738]="::12:1:20:::1:0:", -- Gem of Cobrahn
	[9739]="::12:1:20:::1:0:", -- Gem of Anacondra
	[9740]="::12:1:20:::1:0:", -- Gem of Pythas
	[9741]="::12:1:20:::1:0:", -- Gem of Serpentis
	[9742]=":49:4:1:1:::1:0:", -- Simple Cord
	[9743]=":67:4:1:1:::1:0:", -- Simple Shoes
	[9744]=":45:4:1:1:::1:0:", -- Simple Bands
	[9745]=":54:4:1:1:::1:0:", -- Simple Cape
	[9746]=":56:4:1:1:::1:0:", -- Simple Gloves
	[9747]=":227:4:2:1:::1:0:", -- Simple Britches
	[9748]=":274:4:2:1:::1:0:", -- Simple Robe
	[9749]=":275:4:2:1:::1:0:", -- Simple Blouse
	[9750]=":57:4:1:1:::1:0:", -- Gypsy Sash
	[9751]=":86:4:1:1:::1:0:", -- Gypsy Sandals
	[9752]=":58:4:1:1:::1:0:", -- Gypsy Bands
	[9753]=":248:4:2:1:::1:0:", -- Gypsy Buckler
	[9754]=":56:4:1:1:::1:0:", -- Gypsy Cloak
	[9755]=":73:4:1:1:::1:0:", -- Gypsy Gloves
	[9756]=":294:4:2:1:::1:0:", -- Gypsy Trousers
	[9757]=":364:4:2:1:::1:0:", -- Gypsy Tunic
	[9758]=":73:4:1:1:::1:0:", -- Cadet Belt
	[9759]=":138:4:1:1:::1:0:", -- Cadet Boots
	[9760]=":73:4:1:1:::1:0:", -- Cadet Bracers
	[9761]=":59:4:1:1:::1:0:", -- Cadet Cloak
	[9762]=":92:4:1:1:::1:0:", -- Cadet Gauntlets
	[9763]=":336:4:2:1:::1:0:", -- Cadet Leggings
	[9764]=":300:4:2:1:::1:0:", -- Cadet Shield
	[9765]=":406:4:2:1:::1:0:", -- Cadet Vest
	[9766]=":362:4:2:1:::1:0:", -- Greenweave Sash
	[9767]=":616:4:2:1:::1:0:", -- Greenweave Sandals
	[9768]=":317:4:2:1:::1:0:", -- Greenweave Bracers
	[9769]=":1637:4:2:1:::1:0:", -- Greenweave Branch
	[9770]=":417:4:2:1:::1:0:", -- Greenweave Cloak
	[9771]=":532:4:2:1:::1:0:", -- Greenweave Gloves
	[9772]=":1328:4:2:1:::1:0:", -- Greenweave Leggings
	[9773]=":1369:4:2:1:::1:0:", -- Greenweave Robe
	[9774]=":1374:4:2:1:::1:0:", -- Greenweave Vest
	[9775]=":316:4:2:1:::1:0:", -- Bandit Cinch
	[9776]=":547:4:2:1:::1:0:", -- Bandit Boots
	[9777]=":318:4:2:1:::1:0:", -- Bandit Bracers
	[9778]=":940:4:2:1:::1:0:", -- Bandit Buckler
	[9779]=":334:4:2:1:::1:0:", -- Bandit Cloak
	[9780]=":370:4:2:1:::1:0:", -- Bandit Gloves
	[9781]=":982:4:2:1:::1:0:", -- Bandit Pants
	[9782]=":1113:4:2:1:::1:0:", -- Bandit Jerkin
	[9783]=":812:4:2:1:::1:0:", -- Raider\'s Chestpiece
	[9784]=":533:4:2:1:::1:0:", -- Raider\'s Boots
	[9785]=":269:4:2:1:::1:0:", -- Raider\'s Bracers
	[9786]=":234:4:2:1:::1:0:", -- Raider\'s Cloak
	[9787]=":358:4:2:1:::1:0:", -- Raider\'s Gauntlets
	[9788]=":312:4:2:1:::1:0:", -- Raider\'s Belt
	[9789]=":742:4:2:1:::1:0:", -- Raider\'s Legguards
	[9790]=":794:4:2:1:::1:0:", -- Raider\'s Shield
	[9791]=":1644:4:2:1:::1:0:", -- Ivycloth Tunic
	[9792]=":823:4:2:1:::1:0:", -- Ivycloth Boots
	[9793]=":550:4:2:1:::1:0:", -- Ivycloth Bracelets
	[9794]=":829:4:2:1:::1:0:", -- Ivycloth Cloak
	[9795]=":626:4:2:1:::1:0:", -- Ivycloth Gloves
	[9796]=":1038:4:2:1:::1:0:", -- Ivycloth Mantle
	[9797]=":1528:4:2:1:::1:0:", -- Ivycloth Pants
	[9798]=":1686:4:2:1:::1:0:", -- Ivycloth Robe
	[9799]=":635:4:2:1:::1:0:", -- Ivycloth Sash
	[9800]=":2027:4:2:1:::1:0:", -- Ivy Orb
	[9801]=":708:4:2:1:::1:0:", -- Superior Belt
	[9802]=":1205:4:2:1:::1:0:", -- Superior Boots
	[9803]=":729:4:2:1:::1:0:", -- Superior Bracers
	[9804]=":1874:4:2:1:::1:0:", -- Superior Buckler
	[9805]=":709:4:2:1:::1:0:", -- Superior Cloak
	[9806]=":834:4:2:1:::1:0:", -- Superior Gloves
	[9807]=":1255:4:2:1:::1:0:", -- Superior Shoulders
	[9808]=":1848:4:2:1:::1:0:", -- Superior Leggings
	[9809]=":1855:4:2:1:::1:0:", -- Superior Tunic
	[9810]=":1231:4:2:1:::1:0:", -- Fortified Boots
	[9811]=":725:4:2:1:::1:0:", -- Fortified Bracers
	[9812]=":570:4:2:1:::1:0:", -- Fortified Cloak
	[9813]=":826:4:2:1:::1:0:", -- Fortified Gauntlets
	[9814]=":733:4:2:1:::1:0:", -- Fortified Belt
	[9815]=":1664:4:2:1:::1:0:", -- Fortified Leggings
	[9816]=":1781:4:2:1:::1:0:", -- Fortified Shield
	[9817]=":1426:4:2:1:::1:0:", -- Fortified Spaulders
	[9818]=":1682:4:2:1:::1:0:", -- Fortified Chain
	[9819]=":2726:4:2:1:::1:0:", -- Durable Tunic
	[9820]=":1541:4:2:1:::1:0:", -- Durable Boots
	[9821]=":871:4:2:1:::1:0:", -- Durable Bracers
	[9822]=":1192:4:2:1:::1:0:", -- Durable Cape
	[9823]=":965:4:2:1:::1:0:", -- Durable Gloves
	[9824]=":1599:4:2:1:::1:0:", -- Durable Shoulders
	[9825]=":2355:4:2:1:::1:0:", -- Durable Pants
	[9826]=":2600:4:2:1:::1:0:", -- Durable Robe
	[9827]=":1114:4:2:1:::1:0:", -- Scaled Leather Belt
	[9828]=":1845:4:2:1:::1:0:", -- Scaled Leather Boots
	[9829]=":1020:4:2:1:::1:0:", -- Scaled Leather Bracers
	[9830]=":3489:4:2:1:::1:0:", -- Scaled Shield
	[9831]=":1233:4:2:1:::1:0:", -- Scaled Cloak
	[9832]=":1248:4:2:1:::1:0:", -- Scaled Leather Gloves
	[9833]=":3031:4:2:1:::1:0:", -- Scaled Leather Leggings
	[9834]=":2074:4:2:1:::1:0:", -- Scaled Leather Shoulders
	[9835]=":3053:4:2:1:::1:0:", -- Scaled Leather Tunic
	[9836]=":3677:4:2:1:::1:0:", -- Banded Armor
	[9837]=":1287:4:2:1:::1:0:", -- Banded Bracers
	[9838]=":1174:4:2:1:::1:0:", -- Banded Cloak
	[9839]=":1426:4:2:1:::1:0:", -- Banded Gauntlets
	[9840]=":1432:4:2:1:::1:0:", -- Banded Girdle
	[9841]=":3163:4:2:1:::1:0:", -- Banded Leggings
	[9842]=":2391:4:2:1:::1:0:", -- Banded Pauldrons
	[9843]=":3739:4:2:1:::1:0:", -- Banded Shield
	[9844]=":3709:4:2:1:::1:0:", -- Conjurer\'s Vest
	[9845]=":2136:4:2:1:::1:0:", -- Conjurer\'s Shoes
	[9846]=":1429:4:2:1:::1:0:", -- Conjurer\'s Bracers
	[9847]=":1779:4:2:1:::1:0:", -- Conjurer\'s Cloak
	[9848]=":1584:4:2:1:::1:0:", -- Conjurer\'s Gloves
	[9849]=":2385:4:2:1:::1:0:", -- Conjurer\'s Hood
	[9850]=":2394:4:2:1:::1:0:", -- Conjurer\'s Mantle
	[9851]=":3524:4:2:1:::1:0:", -- Conjurer\'s Breeches
	[9852]=":3820:4:2:1:::1:0:", -- Conjurer\'s Robe
	[9853]=":1368:4:2:1:::1:0:", -- Conjurer\'s Cinch
	[9854]=":4935:4:2:1:::1:0:", -- Archer\'s Jerkin
	[9855]=":1895:4:2:1:::1:0:", -- Archer\'s Belt
	[9856]=":2839:4:2:1:::1:0:", -- Archer\'s Boots
	[9857]=":1570:4:2:1:::1:0:", -- Archer\'s Bracers
	[9858]=":4882:4:2:1:::1:0:", -- Archer\'s Buckler
	[9859]=":2872:4:2:1:::1:0:", -- Archer\'s Cap
	[9860]=":1906:4:2:1:::1:0:", -- Archer\'s Cloak
	[9861]=":1753:4:2:1:::1:0:", -- Archer\'s Gloves
	[9862]=":4260:4:2:1:::1:0:", -- Archer\'s Trousers
	[9863]=":3207:4:2:1:::1:0:", -- Archer\'s Shoulderpads
	[9864]=":3527:4:2:1:::1:0:", -- Renegade Boots
	[9865]=":1942:4:2:1:::1:0:", -- Renegade Bracers
	[9866]=":5605:4:2:1:::1:0:", -- Renegade Chestguard
	[9867]=":1779:4:2:1:::1:0:", -- Renegade Cloak
	[9868]=":2160:4:2:1:::1:0:", -- Renegade Gauntlets
	[9869]=":2225:4:2:1:::1:0:", -- Renegade Belt
	[9870]=":3686:4:2:1:::1:0:", -- Renegade Circlet
	[9871]=":5425:4:2:1:::1:0:", -- Renegade Leggings
	[9872]=":4101:4:2:1:::1:0:", -- Renegade Pauldrons
	[9873]=":5828:4:2:1:::1:0:", -- Renegade Shield
	[9874]=":5801:4:2:1:::1:0:", -- Sorcerer Drape
	[9875]=":2139:4:2:1:::1:0:", -- Sorcerer Sash
	[9876]=":3146:4:2:1:::1:0:", -- Sorcerer Slippers
	[9877]=":2708:4:2:1:::1:0:", -- Sorcerer Cloak
	[9878]=":3425:4:2:1:::1:0:", -- Sorcerer Hat
	[9879]=":1964:4:2:1:::1:0:", -- Sorcerer Bracelets
	[9880]=":2130:4:2:1:::1:0:", -- Sorcerer Gloves
	[9881]=":3464:4:2:1:::1:0:", -- Sorcerer Mantle
	[9882]=":6209:4:2:1:::1:0:", -- Sorcerer Sphere
	[9883]=":5026:4:2:1:::1:0:", -- Sorcerer Pants
	[9884]=":5448:4:2:1:::1:0:", -- Sorcerer Robe
	[9885]=":4180:4:2:1:::1:0:", -- Huntsman\'s Boots
	[9886]=":2589:4:2:1:::1:0:", -- Huntsman\'s Bands
	[9887]=":7071:4:2:1:::1:0:", -- Huntsman\'s Armor
	[9889]=":4240:4:2:1:::1:0:", -- Huntsman\'s Cap
	[9890]=":2919:4:2:1:::1:0:", -- Huntsman\'s Cape
	[9891]=":2636:4:2:1:::1:0:", -- Huntsman\'s Belt
	[9892]=":2857:4:2:1:::1:0:", -- Huntsman\'s Gloves
	[9893]=":6689:4:2:1:::1:0:", -- Huntsman\'s Leggings
	[9894]=":4661:4:2:1:::1:0:", -- Huntsman\'s Shoulders
	[9895]=":5221:4:2:1:::1:0:", -- Jazeraint Boots
	[9896]=":2913:4:2:1:::1:0:", -- Jazeraint Bracers
	[9897]=":7368:4:2:1:::1:0:", -- Jazeraint Chestguard
	[9898]=":2718:4:2:1:::1:0:", -- Jazeraint Cloak
	[9899]=":7920:4:2:1:::1:0:", -- Jazeraint Shield
	[9900]=":3195:4:2:1:::1:0:", -- Jazeraint Gauntlets
	[9901]=":3295:4:2:1:::1:0:", -- Jazeraint Belt
	[9902]=":5357:4:2:1:::1:0:", -- Jazeraint Helm
	[9903]=":7743:4:2:1:::1:0:", -- Jazeraint Leggings
	[9904]=":5420:4:2:1:::1:0:", -- Jazeraint Pauldrons
	[9905]=":8251:4:2:1:::1:0:", -- Royal Blouse
	[9906]=":3043:4:2:1:::1:0:", -- Royal Sash
	[9907]=":4581:4:2:1:::1:0:", -- Royal Boots
	[9908]=":4257:4:2:1:::1:0:", -- Royal Cape
	[9909]=":2848:4:2:1:::1:0:", -- Royal Bands
	[9910]=":3087:4:2:1:::1:0:", -- Royal Gloves
	[9911]=":7228:4:2:1:::1:0:", -- Royal Trousers
	[9912]=":5037:4:2:1:::1:0:", -- Royal Amice
	[9913]=":8491:4:2:1:::1:0:", -- Royal Gown
	[9914]=":7557:4:2:1:::1:0:", -- Royal Scepter
	[9915]=":5091:4:2:1:::1:0:", -- Royal Headband
	[9916]=":3566:4:2:1:::1:0:", -- Tracker\'s Belt
	[9917]=":5519:4:2:1:::1:0:", -- Tracker\'s Boots
	[9918]=":10212:4:2:1:::1:0:", -- Brigade Defender
	[9919]=":4119:4:2:1:::1:0:", -- Tracker\'s Cloak
	[9920]=":3721:4:2:1:::1:0:", -- Tracker\'s Gloves
	[9921]=":6050:4:2:1:::1:0:", -- Tracker\'s Headband
	[9922]=":8745:4:2:1:::1:0:", -- Tracker\'s Leggings
	[9923]=":6095:4:2:1:::1:0:", -- Tracker\'s Shoulderpads
	[9924]=":10276:4:2:1:::1:0:", -- Tracker\'s Tunic
	[9925]=":3790:4:2:1:::1:0:", -- Tracker\'s Wristguards
	[9926]=":6368:4:2:1:::1:0:", -- Brigade Boots
	[9927]=":3927:4:2:1:::1:0:", -- Brigade Bracers
	[9928]=":9930:4:2:1:::1:0:", -- Brigade Breastplate
	[9929]=":3662:4:2:1:::1:0:", -- Brigade Cloak
	[9930]=":4287:4:2:1:::1:0:", -- Brigade Gauntlets
	[9931]=":4303:4:2:1:::1:0:", -- Brigade Girdle
	[9932]=":6995:4:2:1:::1:0:", -- Brigade Circlet
	[9933]=":9394:4:2:1:::1:0:", -- Brigade Leggings
	[9934]=":6577:4:2:1:::1:0:", -- Brigade Pauldrons
	[9935]=":10097:4:2:1:::1:0:", -- Embossed Plate Shield
	[9936]=":6403:4:2:1:::1:0:", -- Abjurer\'s Boots
	[9937]=":4004:4:2:1:::1:0:", -- Abjurer\'s Bands
	[9938]=":6029:4:2:1:::1:0:", -- Abjurer\'s Cloak
	[9939]=":4317:4:2:1:::1:0:", -- Abjurer\'s Gloves
	[9940]=":6954:4:2:1:::1:0:", -- Abjurer\'s Hood
	[9941]=":6523:4:2:1:::1:0:", -- Abjurer\'s Mantle
	[9942]=":9341:4:2:1:::1:0:", -- Abjurer\'s Pants
	[9943]=":11271:4:2:1:::1:0:", -- Abjurer\'s Robe
	[9944]=":8570:4:2:1:::1:0:", -- Abjurer\'s Crystal
	[9945]=":4124:4:2:1:::1:0:", -- Abjurer\'s Sash
	[9946]=":11396:4:2:1:::1:0:", -- Abjurer\'s Tunic
	[9947]=":5193:4:2:1:::1:0:", -- Chieftain\'s Belt
	[9948]=":8365:4:2:1:::1:0:", -- Chieftain\'s Boots
	[9949]=":4855:4:2:1:::1:0:", -- Chieftain\'s Bracers
	[9950]=":13418:4:2:1:::1:0:", -- Chieftain\'s Breastplate
	[9951]=":5436:4:2:1:::1:0:", -- Chieftain\'s Cloak
	[9952]=":5255:4:2:1:::1:0:", -- Chieftain\'s Gloves
	[9953]=":8467:4:2:1:::1:0:", -- Chieftain\'s Headdress
	[9954]=":12126:4:2:1:::1:0:", -- Chieftain\'s Leggings
	[9955]=":8531:4:2:1:::1:0:", -- Chieftain\'s Shoulders
	[9956]=":5130:4:2:1:::1:0:", -- Warmonger\'s Bracers
	[9957]=":13753:4:2:1:::1:0:", -- Warmonger\'s Chestpiece
	[9958]=":14724:4:2:1:::1:0:", -- Warmonger\'s Buckler
	[9959]=":4803:4:2:1:::1:0:", -- Warmonger\'s Cloak
	[9960]=":5623:4:2:1:::1:0:", -- Warmonger\'s Gauntlets
	[9961]=":5644:4:2:1:::1:0:", -- Warmonger\'s Belt
	[9962]=":9218:4:2:1:::1:0:", -- Warmonger\'s Greaves
	[9963]=":9211:4:2:1:::1:0:", -- Warmonger\'s Circlet
	[9964]=":13190:4:2:1:::1:0:", -- Warmonger\'s Leggings
	[9965]=":9973:4:2:1:::1:0:", -- Warmonger\'s Pauldrons
	[9966]=":11800:4:2:1:::1:0:", -- Embossed Plate Armor
	[9967]=":5105:4:2:1:::1:0:", -- Embossed Plate Gauntlets
	[9968]=":4744:4:2:1:::1:0:", -- Embossed Plate Girdle
	[9969]=":6925:4:2:1:::1:0:", -- Embossed Plate Helmet
	[9970]=":10029:4:2:1:::1:0:", -- Embossed Plate Leggings
	[9971]=":6978:4:2:1:::1:0:", -- Embossed Plate Pauldrons
	[9972]=":4357:4:2:1:::1:0:", -- Embossed Plate Bracers
	[9973]=":6510:4:2:1:::1:0:", -- Embossed Plate Boots
	[9974]=":16449:4:2:1:::1:0:", -- Overlord\'s Shield
	[9978]="::12:1:1:::1:0:", -- Gahz\'ridian Detector
	[9998]=":4815:4:2:1:::1:0:", -- Black Mageweave Vest
	[9999]=":4833:4:2:1:::1:0:", -- Black Mageweave Leggings
	[10000]="::12:1:1:::1:0:", -- Margol\'s Horn
	[10001]=":5257:4:2:1:::1:0:", -- Black Mageweave Robe
	[10002]=":5276:4:2:1:::1:0:", -- Shadoweave Pants
	[10003]=":2859:4:2:1:::1:0:", -- Black Mageweave Gloves
	[10004]=":5738:4:2:1:::1:0:", -- Shadoweave Robe
	[10005]="::12:1:1:::1:0:", -- Margol\'s Gigantic Horn
	[10007]=":5800:4:2:1:::1:0:", -- Red Mageweave Vest
	[10008]=":4365:4:2:1:::1:0:", -- White Bandit Mask
	[10009]=":5284:4:2:1:::1:0:", -- Red Mageweave Pants
	[10018]=":3275:4:2:1:::1:0:", -- Red Mageweave Gloves
	[10019]=":3944:4:3:1:::1:0:", -- Dreamweave Gloves
	[10021]=":7946:4:3:1:::1:0:", -- Dreamweave Vest
	[10022]="::12:1:1:::1:0:", -- Proof of Deed
	[10023]=":3334:4:2:1:::1:0:", -- Shadoweave Gloves
	[10024]=":5421:4:2:1:::1:0:", -- Black Mageweave Headband
	[10025]=":6790:4:2:1:::1:0:", -- Shadoweave Mask
	[10026]=":5459:4:2:1::202:1:0:", -- Black Mageweave Boots
	[10027]=":5479:4:2:1:::1:0:", -- Black Mageweave Shoulders
	[10028]=":5938:4:2:1:::1:0:", -- Shadoweave Shoulders
	[10029]=":5391:4:2:1:::1:0:", -- Red Mageweave Shoulders
	[10030]=":6007:4:2:1:::1:0:", -- Admiral\'s Hat
	[10031]=":6030:4:2:1:::1:0:", -- Shadoweave Boots
	[10033]=":6075:4:2:1:::1:0:", -- Red Mageweave Headband
	[10034]=":2000:4:1:1:::1:0:", -- Tuxedo Shirt
	[10035]=":1735:4:1:1:::1:0:", -- Tuxedo Pants
	[10036]=":1741:4:1:1:::1:0:", -- Tuxedo Jacket
	[10040]=":1767:4:1:1:::1:0:", -- White Wedding Dress
	[10041]=":8593:4:3:1:::1:0:", -- Dreamweave Circlet
	[10042]=":6644:4:2:1:::1:0:", -- Cindercloth Robe
	[10043]=":2033:4:2:1:::1:0:", -- Pious Legwraps
	[10044]=":6765:4:2:1:::1:0:", -- Cindercloth Boots
	[10045]=":23:4:1:1:::1:0:", -- Simple Linen Pants
	[10046]=":32:4:1:1:::1:0:", -- Simple Linen Boots
	[10047]=":164:4:1:1:::1:0:", -- Simple Kilt
	[10048]=":935:4:2:1:::1:0:", -- Colorful Kilt
	[10050]=":2500:1:1:1:::1:0:", -- Mageweave Bag
	[10051]=":2500:1:1:1:::1:0:", -- Red Mageweave Bag
	[10052]=":1500:4:1:1:::1:0:", -- Orange Martial Shirt
	[10053]=":4499:4:1:1:::1:0:", -- Simple Black Dress
	[10054]=":3000:4:1:1:::1:0:", -- Lavender Mageweave Shirt
	[10055]=":3000:4:1:1:::1:0:", -- Pink Mageweave Shirt
	[10056]=":1500:4:1:1:::1:0:", -- Orange Mageweave Shirt
	[10057]=":12711:4:2:1:::1:0:", -- Duskwoven Tunic
	[10058]=":7083:4:2:1:::1:0:", -- Duskwoven Sandals
	[10059]=":4739:4:2:1:::1:0:", -- Duskwoven Bracers
	[10060]=":6668:4:2:1:::1:0:", -- Duskwoven Cape
	[10061]=":7661:4:2:1:::1:0:", -- Duskwoven Turban
	[10062]=":4758:4:2:1:::1:0:", -- Duskwoven Gloves
	[10063]=":7165:4:2:1:::1:0:", -- Duskwoven Amice
	[10064]=":10775:4:2:1:::1:0:", -- Duskwoven Pants
	[10065]=":12153:4:2:1:::1:0:", -- Duskwoven Robe
	[10066]=":4220:4:2:1:::1:0:", -- Duskwoven Sash
	[10067]=":5295:4:2:1:::1:0:", -- Righteous Waistguard
	[10068]=":9128:4:2:1:::1:0:", -- Righteous Boots
	[10069]=":5335:4:2:1:::1:0:", -- Righteous Bracers
	[10070]=":15482:4:2:1:::1:0:", -- Righteous Armor
	[10071]=":6450:4:2:1:::1:0:", -- Righteous Cloak
	[10072]=":6177:4:2:1:::1:0:", -- Righteous Gloves
	[10073]=":9858:4:2:1:::1:0:", -- Righteous Helmet
	[10074]=":13985:4:2:1:::1:0:", -- Righteous Leggings
	[10075]=":9369:4:2:1:::1:0:", -- Righteous Spaulders
	[10076]=":6571:4:2:1:::1:0:", -- Lord\'s Armguards
	[10077]=":16968:4:2:1:::1:0:", -- Lord\'s Breastplate
	[10078]=":18642:4:2:1:::1:0:", -- Lord\'s Crest
	[10079]=":6370:4:2:1:::1:0:", -- Lord\'s Cape
	[10080]=":7319:4:2:1:::1:0:", -- Lord\'s Gauntlets
	[10081]=":7345:4:2:1:::1:0:", -- Lord\'s Girdle
	[10082]=":10752:4:2:1:::1:0:", -- Lord\'s Boots
	[10083]=":10745:4:2:1:::1:0:", -- Lord\'s Crown
	[10084]=":15246:4:2:1:::1:0:", -- Lord\'s Legguards
	[10085]=":11529:4:2:1:::1:0:", -- Lord\'s Pauldrons
	[10086]=":14768:4:2:1:::1:0:", -- Gothic Plate Armor
	[10087]=":5973:4:2:1:::1:0:", -- Gothic Plate Gauntlets
	[10088]=":5551:4:2:1:::1:0:", -- Gothic Plate Girdle
	[10089]=":8296:4:2:1:::1:0:", -- Gothic Sabatons
	[10090]=":8992:4:2:1:::1:0:", -- Gothic Plate Helmet
	[10091]=":13023:4:2:1:::1:0:", -- Gothic Plate Leggings
	[10092]=":9785:4:2:1:::1:0:", -- Gothic Plate Spaulders
	[10093]=":18903:4:2:1:::1:0:", -- Revenant Deflector
	[10094]=":5828:4:2:1:::1:0:", -- Gothic Plate Vambraces
	[10095]=":10295:4:2:1:::1:0:", -- Councillor\'s Boots
	[10096]=":6130:4:2:1:::1:0:", -- Councillor\'s Cuffs
	[10097]=":10992:4:2:1:::1:0:", -- Councillor\'s Circlet
	[10098]=":8737:4:2:1:::1:0:", -- Councillor\'s Cloak
	[10099]=":6568:4:2:1:::1:0:", -- Councillor\'s Gloves
	[10100]=":11109:4:2:1:::1:0:", -- Councillor\'s Shoulders
	[10101]=":15756:4:2:1:::1:0:", -- Councillor\'s Pants
	[10102]=":15020:4:2:1:::1:0:", -- Councillor\'s Robes
	[10103]=":5687:4:2:1:::1:0:", -- Councillor\'s Sash
	[10104]=":15137:4:2:1:::1:0:", -- Councillor\'s Tunic
	[10105]=":19942:4:2:1:::1:0:", -- Wanderer\'s Armor
	[10106]=":12120:4:2:1:::1:0:", -- Wanderer\'s Boots
	[10107]=":7218:4:2:1:::1:0:", -- Wanderer\'s Bracers
	[10108]=":8203:4:2:1:::1:0:", -- Wanderer\'s Cloak
	[10109]=":7273:4:2:1:::1:0:", -- Wanderer\'s Belt
	[10110]=":7948:4:2:1:::1:0:", -- Wanderer\'s Gloves
	[10111]=":13444:4:2:1:::1:0:", -- Wanderer\'s Hat
	[10112]=":19071:4:2:1:::1:0:", -- Wanderer\'s Leggings
	[10113]=":13541:4:2:1:::1:0:", -- Wanderer\'s Shoulders
	[10118]=":23382:4:2:1:::1:0:", -- Ornate Breastplate
	[10119]=":16676:4:2:1:::1:0:", -- Ornate Greaves
	[10120]=":8797:4:2:1:::1:0:", -- Ornate Cloak
	[10121]=":10515:4:2:1:::1:0:", -- Ornate Gauntlets
	[10122]=":9007:4:2:1:::1:0:", -- Ornate Girdle
	[10123]=":15239:4:2:1:::1:0:", -- Ornate Circlet
	[10124]=":20396:4:2:1:::1:0:", -- Ornate Legguards
	[10125]=":14551:4:2:1:::1:0:", -- Ornate Pauldrons
	[10126]=":8865:4:2:1:::1:0:", -- Ornate Bracers
	[10127]=":7656:4:2:1:::1:0:", -- Revenant Bracers
	[10128]=":20838:4:2:1:::1:0:", -- Revenant Chestplate
	[10129]=":8253:4:2:1:::1:0:", -- Revenant Gauntlets
	[10130]=":8283:4:2:1:::1:0:", -- Revenant Girdle
	[10131]=":12376:4:2:1:::1:0:", -- Revenant Boots
	[10132]=":13289:4:2:1:::1:0:", -- Revenant Helmet
	[10133]=":18887:4:2:1:::1:0:", -- Revenant Leggings
	[10134]=":13386:4:2:1:::1:0:", -- Revenant Shoulders
	[10135]=":17950:4:2:1:::1:0:", -- High Councillor\'s Tunic
	[10136]=":8530:4:2:1:::1:0:", -- High Councillor\'s Bracers
	[10137]=":13021:4:2:1:::1:0:", -- High Councillor\'s Boots
	[10138]=":12274:4:2:1:::1:0:", -- High Councillor\'s Cloak
	[10139]=":13294:4:2:1:::1:0:", -- High Councillor\'s Circlet
	[10140]=":8773:4:2:1:::1:0:", -- High Councillor\'s Gloves
	[10141]=":18094:4:2:1:::1:0:", -- High Councillor\'s Pants
	[10142]=":12495:4:2:1:::1:0:", -- High Councillor\'s Mantle
	[10143]=":17176:4:2:1:::1:0:", -- High Councillor\'s Robe
	[10144]=":8164:4:2:1:::1:0:", -- High Councillor\'s Sash
	[10145]=":9755:4:2:1:::1:0:", -- Mighty Girdle
	[10146]=":15638:4:2:1:::1:0:", -- Mighty Boots
	[10147]=":10319:4:2:1:::1:0:", -- Mighty Armsplints
	[10148]=":11273:4:2:1:::1:0:", -- Mighty Cloak
	[10149]=":10541:4:2:1:::1:0:", -- Mighty Gauntlets
	[10150]=":16087:4:2:1:::1:0:", -- Mighty Helmet
	[10151]=":22114:4:2:1:::1:0:", -- Mighty Tunic
	[10152]=":21901:4:2:1:::1:0:", -- Mighty Leggings
	[10153]=":16264:4:2:1:::1:0:", -- Mighty Spaulders
	[10154]=":12880:4:2:1:::1:0:", -- Mercurial Girdle
	[10155]=":19476:4:2:1:::1:0:", -- Mercurial Greaves
	[10156]=":12794:4:2:1:::1:0:", -- Mercurial Bracers
	[10157]=":27117:4:2:1:::1:0:", -- Mercurial Breastplate
	[10158]=":26964:4:2:1:::1:0:", -- Mercurial Guard
	[10159]=":11444:4:2:1:::1:0:", -- Mercurial Cloak
	[10160]=":18599:4:2:1:::1:0:", -- Mercurial Circlet
	[10161]=":12277:4:2:1:::1:0:", -- Mercurial Gauntlets
	[10162]=":25325:4:2:1:::1:0:", -- Mercurial Legguards
	[10163]=":18893:4:2:1:::1:0:", -- Mercurial Pauldrons
	[10164]=":25915:4:2:1:::1:0:", -- Templar Chestplate
	[10165]=":10983:4:2:1:::1:0:", -- Templar Gauntlets
	[10166]=":10399:4:2:1:::1:0:", -- Templar Girdle
	[10167]=":16470:4:2:1:::1:0:", -- Templar Boots
	[10168]=":17523:4:2:1:::1:0:", -- Templar Crown
	[10169]=":24903:4:2:1:::1:0:", -- Templar Legplates
	[10170]=":17651:4:2:1:::1:0:", -- Templar Pauldrons
	[10171]=":10591:4:2:1:::1:0:", -- Templar Bracers
	[10172]=":9603:4:2:1:::1:0:", -- Mystical Mantle
	[10173]=":5718:4:2:1:::1:0:", -- Mystical Bracers
	[10174]=":8121:4:2:1:::1:0:", -- Mystical Cape
	[10175]=":9011:4:2:1:::1:0:", -- Mystical Headwrap
	[10176]=":5689:4:2:1:::1:0:", -- Mystical Gloves
	[10177]=":12833:4:2:1:::1:0:", -- Mystical Leggings
	[10178]=":14475:4:2:1:::1:0:", -- Mystical Robe
	[10179]=":8632:4:2:1:::1:0:", -- Mystical Boots
	[10180]=":5141:4:2:1:::1:0:", -- Mystical Belt
	[10181]=":14640:4:2:1:::1:0:", -- Mystical Armor
	[10182]=":18370:4:2:1:::1:0:", -- Swashbuckler\'s Breastplate
	[10183]=":10954:4:2:1:::1:0:", -- Swashbuckler\'s Boots
	[10184]=":6523:4:2:1:::1:0:", -- Swashbuckler\'s Bracers
	[10185]=":7412:4:2:1:::1:0:", -- Swashbuckler\'s Cape
	[10186]=":6966:4:2:1:::1:0:", -- Swashbuckler\'s Gloves
	[10187]=":11785:4:2:1:::1:0:", -- Swashbuckler\'s Eyepatch
	[10188]=":16717:4:2:1:::1:0:", -- Swashbuckler\'s Leggings
	[10189]=":11872:4:2:1:::1:0:", -- Swashbuckler\'s Shoulderpads
	[10190]=":6669:4:2:1:::1:0:", -- Swashbuckler\'s Belt
	[10191]=":7777:4:2:1:::1:0:", -- Crusader\'s Armguards
	[10192]=":13212:4:2:1:::1:0:", -- Crusader\'s Boots
	[10193]=":19776:4:2:1:::1:0:", -- Crusader\'s Armor
	[10194]=":7345:4:2:1:::1:0:", -- Crusader\'s Cloak
	[10195]=":19221:4:2:1:::1:0:", -- Crusader\'s Shield
	[10196]=":7593:4:2:1:::1:0:", -- Crusader\'s Gauntlets
	[10197]=":7623:4:2:1:::1:0:", -- Crusader\'s Belt
	[10198]=":12167:4:2:1:::1:0:", -- Crusader\'s Helm
	[10199]=":17261:4:2:1:::1:0:", -- Crusader\'s Leggings
	[10200]=":12314:4:2:1:::1:0:", -- Crusader\'s Pauldrons
	[10201]=":10411:4:2:1:::1:0:", -- Overlord\'s Greaves
	[10202]=":7020:4:2:1:::1:0:", -- Overlord\'s Vambraces
	[10203]=":18195:4:2:1:::1:0:", -- Overlord\'s Chestplate
	[10204]=":19888:4:2:1:::1:0:", -- Heavy Lamellar Shield
	[10205]=":7596:4:2:1:::1:0:", -- Overlord\'s Gauntlets
	[10206]=":7125:4:2:1:::1:0:", -- Overlord\'s Girdle
	[10207]=":11694:4:2:1:::1:0:", -- Overlord\'s Crown
	[10208]=":16777:4:2:1:::1:0:", -- Overlord\'s Legplates
	[10209]=":12604:4:2:1:::1:0:", -- Overlord\'s Spaulders
	[10210]=":12845:4:2:1:::1:0:", -- Elegant Mantle
	[10211]=":12276:4:2:1:::1:0:", -- Elegant Boots
	[10212]=":11069:4:2:1:::1:0:", -- Elegant Cloak
	[10213]=":7850:4:2:1:::1:0:", -- Elegant Bracers
	[10214]=":8271:4:2:1:::1:0:", -- Elegant Gloves
	[10215]=":16212:4:2:1:::1:0:", -- Elegant Robes
	[10216]=":7180:4:2:1:::1:0:", -- Elegant Belt
	[10217]=":16116:4:2:1:::1:0:", -- Elegant Leggings
	[10218]=":16399:4:2:1:::1:0:", -- Elegant Tunic
	[10219]=":12011:4:2:1:::1:0:", -- Elegant Circlet
	[10220]=":20938:4:2:1:::1:0:", -- Nightshade Tunic
	[10221]=":9148:4:2:1:::1:0:", -- Nightshade Girdle
	[10222]=":14462:4:2:1:::1:0:", -- Nightshade Boots
	[10223]=":9466:4:2:1:::1:0:", -- Nightshade Armguards
	[10224]=":10755:4:2:1:::1:0:", -- Nightshade Cloak
	[10225]=":10012:4:2:1:::1:0:", -- Nightshade Gloves
	[10226]=":16046:4:2:1:::1:0:", -- Nightshade Helmet
	[10227]=":21769:4:2:1:::1:0:", -- Nightshade Leggings
	[10228]=":15940:4:2:1:::1:0:", -- Nightshade Spaulders
	[10229]=":10331:4:2:1:::1:0:", -- Engraved Bracers
	[10230]=":25686:4:2:1:::1:0:", -- Engraved Breastplate
	[10231]=":9816:4:2:1:::1:0:", -- Engraved Cape
	[10232]=":11732:4:2:1:::1:0:", -- Engraved Gauntlets
	[10233]=":11106:4:2:1:::1:0:", -- Engraved Girdle
	[10234]=":17801:4:2:1:::1:0:", -- Engraved Boots
	[10235]=":16896:4:2:1:::1:0:", -- Engraved Helm
	[10236]=":22616:4:2:1:::1:0:", -- Engraved Leggings
	[10237]=":16287:4:2:1:::1:0:", -- Engraved Pauldrons
	[10238]=":13362:4:2:1:::1:0:", -- Heavy Lamellar Boots
	[10239]=":8733:4:2:1:::1:0:", -- Heavy Lamellar Vambraces
	[10240]=":22009:4:2:1:::1:0:", -- Heavy Lamellar Chestpiece
	[10241]=":14716:4:2:1:::1:0:", -- Heavy Lamellar Helm
	[10242]=":9360:4:2:1:::1:0:", -- Heavy Lamellar Gauntlets
	[10243]=":8863:4:2:1:::1:0:", -- Heavy Lamellar Girdle
	[10244]=":21069:4:2:1:::1:0:", -- Heavy Lamellar Leggings
	[10245]=":14932:4:2:1:::1:0:", -- Heavy Lamellar Pauldrons
	[10246]=":18058:4:2:1:::1:0:", -- Master\'s Vest
	[10247]=":13238:4:2:1:::1:0:", -- Master\'s Boots
	[10248]=":8737:4:2:1:::1:0:", -- Master\'s Bracers
	[10249]=":12974:4:2:1:::1:0:", -- Master\'s Cloak
	[10250]=":13380:4:2:1:::1:0:", -- Master\'s Hat
	[10251]=":8952:4:2:1:::1:0:", -- Master\'s Gloves
	[10252]=":18207:4:2:1:::1:0:", -- Master\'s Leggings
	[10253]=":13523:4:2:1:::1:0:", -- Master\'s Mantle
	[10254]=":18580:4:2:1:::1:0:", -- Master\'s Robe
	[10255]=":8330:4:2:1:::1:0:", -- Master\'s Belt
	[10256]=":10309:4:2:1:::1:0:", -- Adventurer\'s Bracers
	[10257]=":15735:4:2:1:::1:0:", -- Adventurer\'s Boots
	[10258]=":12292:4:2:1:::1:0:", -- Adventurer\'s Cape
	[10259]=":10569:4:2:1:::1:0:", -- Adventurer\'s Belt
	[10260]=":10752:4:2:1:::1:0:", -- Adventurer\'s Gloves
	[10261]=":16187:4:2:1:::1:0:", -- Adventurer\'s Bandana
	[10262]=":21954:4:2:1:::1:0:", -- Adventurer\'s Legguards
	[10263]=":16306:4:2:1:::1:0:", -- Adventurer\'s Shoulders
	[10264]=":22406:4:2:1:::1:0:", -- Adventurer\'s Tunic
	[10265]=":12964:4:2:1:::1:0:", -- Masterwork Bracers
	[10266]=":27085:4:2:1:::1:0:", -- Masterwork Breastplate
	[10267]=":12880:4:2:1:::1:0:", -- Masterwork Cape
	[10268]=":13283:4:2:1:::1:0:", -- Masterwork Gauntlets
	[10269]=":13152:4:2:1:::1:0:", -- Masterwork Girdle
	[10270]=":20158:4:2:1:::1:0:", -- Masterwork Boots
	[10271]=":27321:4:2:1:::1:0:", -- Masterwork Shield
	[10272]=":18780:4:2:1:::1:0:", -- Masterwork Circlet
	[10273]=":25473:4:2:1:::1:0:", -- Masterwork Legplates
	[10274]=":19008:4:2:1:::1:0:", -- Masterwork Pauldrons
	[10275]=":28357:4:2:1:::1:0:", -- Emerald Breastplate
	[10276]=":17200:4:2:1:::1:0:", -- Emerald Sabatons
	[10277]=":12294:4:2:1:::1:0:", -- Emerald Gauntlets
	[10278]=":10981:4:2:1:::1:0:", -- Emerald Girdle
	[10279]=":19543:4:2:1:::1:0:", -- Emerald Helm
	[10280]=":27515:4:2:1:::1:0:", -- Emerald Legplates
	[10281]=":19689:4:2:1:::1:0:", -- Emerald Pauldrons
	[10282]=":11813:4:2:1:::1:0:", -- Emerald Vambraces
	[10283]="::12:1:1:::1:0:", -- Wolf Heart Samples
	[10285]=":1000:7:1:10::202,197:1:0:", -- Shadow Silk
	[10286]=":400:7:1:10::171,202,755,197:1:0:", -- Heart of the Wild
	[10287]=":964:4:2:1:::1:0:", -- Greenweave Mantle
	[10288]=":1410:4:2:1:::1:0:", -- Sage\'s Circlet
	[10289]=":1557:4:2:1:::1:0:", -- Durable Hat
	[10290]="2500:625:7:1:10::197:1:0:4589,16689,4225,3096,6731,18749,12942,18277,8681,4577,5783,5154,2670,12956,11557,7940,3958,2816,21085,6568,2697,16366,2699,4189,4168,18772,2846,11874,12943,3091,6574,2668,18754,19196,19213,7854,7852,19521,3364,5128,6576,1347,3485,1672,5565,2394,8160,15165,1474,16767,19532,3366,1454,5944,6567,16748,2672,2819,3005,19722,16638,2669,18771,2698", -- Pink Dye
	[10298]=":1243:4:2:1:::1:0:", -- Gnomeregan Band
	[10299]=":3778:4:2:1:::1:0:", -- Gnomeregan Amulet
	[10300]=":1250:9:2:1:::1:0:", -- Pattern: Red Mageweave Vest
	[10301]=":1250:9:2:1:::1:0:", -- Pattern: White Bandit Mask
	[10302]=":1250:9:2:1:::1:0:", -- Pattern: Red Mageweave Pants
	[10305]="550:100:0:1:5:::1:0:14847", -- Scroll of Protection IV
	[10306]="550:100:0:1:5:::1:0:14847,20092", -- Scroll of Spirit IV
	[10307]="600:112:0:1:5:::1:0:14847,20092", -- Scroll of Stamina IV
	[10308]="600:112:0:1:5:::1:0:14847,20092", -- Scroll of Intellect IV
	[10309]="650:125:0:1:5:::1:0:14847", -- Scroll of Agility IV
	[10310]="650:125:0:1:5:::1:0:14847", -- Scroll of Strength IV
	[10311]="3000:750:9:1:1:::1:0:3005,4168", -- Pattern: Orange Martial Shirt
	[10312]=":1500:9:2:1:::1:0:", -- Pattern: Red Mageweave Gloves
	[10314]="4000:1000:9:1:1:::1:0:3364,8681", -- Pattern: Lavender Mageweave Shirt
	[10315]=":1750:9:2:1:::1:0:", -- Pattern: Red Mageweave Shoulders
	[10316]=":200:9:2:1:::1:0:", -- Pattern: Colorful Kilt
	[10317]="4000:1000:9:1:1:::1:0:3364,8681", -- Pattern: Pink Mageweave Shirt
	[10318]="7000:1750:9:1:1:::1:0:2672", -- Pattern: Admiral\'s Hat
	[10320]=":1750:9:2:1:::1:0:", -- Pattern: Red Mageweave Headband
	[10321]="4500:1125:9:1:1:::1:0:8681,4577", -- Pattern: Tuxedo Shirt
	[10323]="4500:1125:9:1:1:::1:0:8681,4577", -- Pattern: Tuxedo Pants
	[10325]="10000:2500:9:1:1:::1:0:3005,1347", -- Pattern: White Wedding Dress
	[10326]="5000:1250:9:1:1:::1:0:8681,4577", -- Pattern: Tuxedo Jacket
	[10327]="::12:1:1:::1:0:", -- Horn of Echeyakee
	[10328]=":6992:4:3:1:::1:0:", -- Scarlet Chestpiece
	[10329]=":2507:4:2:1:::1:0:", -- Scarlet Belt
	[10330]=":9587:4:3:1:::1:0:", -- Scarlet Leggings
	[10331]=":2729:4:2:1:::1:0:", -- Scarlet Gauntlets
	[10332]=":3790:4:3:1:::1:0:", -- Scarlet Boots
	[10333]=":2314:4:2:1:::1:0:", -- Scarlet Wristguards
	[10338]="::12:1:1:::1:0:", -- Fresh Zhevra Carcass
	[10358]=":2421:4:2:1:::1:0:", -- Duracin Bracers
	[10359]=":2430:4:2:1:::1:0:", -- Everlast Boots
	[10360]="5000:1250:15:1:1:::1:0:8404", -- Black Kingsnake
	[10361]="5000:1250:15:1:1:::1:0:8404", -- Brown Snake
	[10362]=":24760:4:2:1:::1:0:", -- Ornate Shield
	[10363]=":27396:4:2:1:::1:0:", -- Engraved Wall
	[10364]=":24938:4:2:1:::1:0:", -- Templar Shield
	[10365]=":26276:4:2:1:::1:0:", -- Emerald Shield
	[10366]=":28849:4:2:1:::1:0:", -- Demon Guard
	[10367]=":27639:4:2:1:::1:0:", -- Hyperion Shield
	[10368]=":29156:4:2:1:::1:0:", -- Imbued Plate Armor
	[10369]=":12984:4:2:1:::1:0:", -- Imbued Plate Gauntlets
	[10370]=":12295:4:2:1:::1:0:", -- Imbued Plate Girdle
	[10371]=":19474:4:2:1:::1:0:", -- Imbued Plate Greaves
	[10372]=":20525:4:2:1:::1:0:", -- Imbued Plate Helmet
	[10373]=":29298:4:2:1:::1:0:", -- Imbued Plate Leggings
	[10374]=":20676:4:2:1:::1:0:", -- Imbued Plate Pauldrons
	[10375]=":12525:4:2:1:::1:0:", -- Imbued Plate Vambraces
	[10376]=":21868:4:2:1:::1:0:", -- Commander\'s Boots
	[10377]=":14042:4:2:1:::1:0:", -- Commander\'s Vambraces
	[10378]=":30662:4:2:1:::1:0:", -- Commander\'s Armor
	[10379]=":22418:4:2:1:::1:0:", -- Commander\'s Helm
	[10380]=":14904:4:2:1:::1:0:", -- Commander\'s Gauntlets
	[10381]=":14246:4:2:1:::1:0:", -- Commander\'s Girdle
	[10382]=":30689:4:2:1:::1:0:", -- Commander\'s Leggings
	[10383]=":21121:4:2:1:::1:0:", -- Commander\'s Pauldrons
	[10384]=":29882:4:2:1:::1:0:", -- Hyperion Armor
	[10385]=":21575:4:2:1:::1:0:", -- Hyperion Greaves
	[10386]=":14548:4:2:1:::1:0:", -- Hyperion Gauntlets
	[10387]=":14405:4:2:1:::1:0:", -- Hyperion Girdle
	[10388]=":22117:4:2:1:::1:0:", -- Hyperion Helm
	[10389]=":30056:4:2:1:::1:0:", -- Hyperion Legplates
	[10390]=":22285:4:2:1:::1:0:", -- Hyperion Pauldrons
	[10391]=":14420:4:2:1:::1:0:", -- Hyperion Vambraces
	[10392]="5000:1250:15:1:1:::1:0:8404,20980", -- Crimson Snake
	[10393]="5000:1250:15:1:1:::1:0:20980,8403", -- Cockroach
	[10394]="5000:1250:15:1:1:::1:0:8401", -- Prairie Dog Whistle
	[10398]=":1000:15:1:1:::1:0:", -- Mechanical Chicken
	[10399]=":1467:4:3:1:::1:0:", -- Blackened Defias Armor
	[10400]=":563:4:2:1:::1:0:", -- Blackened Defias Leggings
	[10401]=":255:4:2:1:::1:0:", -- Blackened Defias Gloves
	[10402]=":385:4:2:1:::1:0:", -- Blackened Defias Boots
	[10403]=":541:4:3:1:::1:0:", -- Blackened Defias Belt
	[10404]=":864:4:2:1:::1:0:", -- Durable Belt
	[10405]=":409:4:1:1:::1:0:", -- Bandit Shoulders
	[10406]=":1976:4:2:1:::1:0:", -- Scaled Leather Headband
	[10407]=":432:4:1:1:::1:0:", -- Raider\'s Shoulderpads
	[10408]=":2390:4:2:1:::1:0:", -- Banded Helm
	[10409]=":2409:4:2:1:::1:0:", -- Banded Boots
	[10410]=":1256:4:3:1:::1:0:", -- Leggings of the Fang
	[10411]=":945:4:3:1:::1:0:", -- Footpads of the Fang
	[10412]=":486:4:3:1:::1:0:", -- Belt of the Fang
	[10413]=":369:4:3:1:::1:0:", -- Gloves of the Fang
	[10414]="::12:1:1:::1:0:", -- Sample Snapjaw Shell
	[10418]=":16464:4:2:1:::1:0:", -- Glimmering Mithril Insignia
	[10420]="::12:1:1:::1:0:", -- Skull of the Coldbringer
	[10421]=":32:4:1:1:::1:0:", -- Rough Copper Vest
	[10423]=":2842:4:2:1:::1:0:", -- Silvered Bronze Leggings
	[10424]=":750:9:2:1:::1:0:", -- Plans: Silvered Bronze Leggings
	[10438]="::12:1:1:::1:0:", -- Felix\'s Box
	[10439]="::12:1:1:::1:0:", -- Durnan\'s Scalding Mornbrew
	[10440]="::12:1:1:::1:0:", -- Nori\'s Mug
	[10441]="::12:1:1:::1:0:", -- Glowing Shard
	[10442]="::12:1:1:::1:0:", -- Mysterious Artifact
	[10443]="::12:1:1:::1:0:", -- Singed Letter
	[10444]="::12:1:1:::1:0:", -- Standard Issue Flare Gun
	[10445]="::12:1:1:::1:0:", -- Drawing Kit
	[10446]="::12:1:1:::1:0:", -- Heart of Obsidion
	[10447]="::12:1:1:::1:0:", -- Head of Lathoric the Black
	[10450]=":396:12:0:20:::1:0:", -- Undamaged Hippogryph Feather
	[10454]="::12:2:1:::1:0:", -- Essence of Eranikus
	[10455]=":6464:4:2:1:::1:0:", -- Chained Essence of Eranikus
	[10456]="::15:1:1:::1:0:", -- A Bulging Coin Purse
	[10457]=":142:15:0:5:::1:0:", -- Empty Sea Snail Shell
	[10458]="::12:1:1:::1:0:", -- Prayer to Elune
	[10459]="::12:1:1:::1:0:", -- Chief Sharptusk Thornmantle\'s Head
	[10460]=":629:15:1:1:::1:0:", -- Hakkari Blood
	[10461]=":3082:4:2:1:::1:0:", -- Shadowy Bracers
	[10462]=":3609:4:2:1:::1:0:", -- Shadowy Belt
	[10463]=":1750:9:2:1:::1:0:", -- Pattern: Shadoweave Mask
	[10464]="::12:1:1:::1:0:", -- Staff of Command
	[10465]="::12:1:1:::1:0:", -- Egg of Hakkar
	[10466]="::12:1:1:::1:0:", -- Atal\'ai Stone Circle
	[10467]="::15:1:1:::1:0:", -- Trader\'s Satchel
	[10479]=":24:15:2:1:::1:0:", -- Kovic\'s Trading Satchel
	[10498]=":16:7:1:1:::1:0:", -- Gyromatic Micro-Adjustor
	[10499]=":2105:4:2:1:::1:0:", -- Bright-Eye Goggles
	[10500]=":3478:4:2:1::202:1:0:", -- Fire Goggles
	[10501]=":4398:4:2:1:::1:0:", -- Catseye Ultra Goggles
	[10502]=":4088:4:2:1::202:1:0:", -- Spellpower Goggles Xtreme
	[10503]=":5169:4:2:1:::1:0:", -- Rose Colored Goggles
	[10504]=":7770:4:3:1:::1:0:", -- Green Lens
	[10505]=":250:7:1:20::202:1:0:", -- Solid Blasting Powder
	[10506]=":5227:4:2:1:::1:0:", -- Deepdive Helmet
	[10507]=":350:7:1:20::202:1:0:", -- Solid Dynamite
	[10508]=":8959:2:2:1:::1:0:", -- Mithril Blunderbuss
	[10509]="::12:1:4:::1:0:", -- Heart of Flame
	[10510]=":11369:2:2:1:::1:0:", -- Mithril Heavy-bore Rifle
	[10511]="::12:1:4:::1:0:", -- Golem Oil
	[10512]=":2:6:2:200:::1:0:", -- Hi-Impact Mithril Slugs
	[10513]=":5:6:2:200:::1:0:", -- Mithril Gyro-Shot
	[10514]=":750:7:1:10:::1:0:", -- Mithril Frag Bomb
	[10515]="::4:1:1:::1:0:", -- Torch of Retribution
	[10518]=":4696:4:2:1:::1:0:", -- Parachute Cloak
	[10538]="::12:1:1:::1:0:", -- Tablet of Beth\'Amara
	[10539]="::12:1:1:::1:0:", -- Tablet of Jin\'yael
	[10540]="::12:1:1:::1:0:", -- Tablet of Markri
	[10541]="::12:1:1:::1:0:", -- Tablet of Sael\'hai
	[10542]=":5255:4:2:1:::1:0:", -- Goblin Mining Helmet
	[10543]=":3517:4:2:1::202:1:0:", -- Goblin Construction Helmet
	[10544]=":25:2:1:1:::1:0:", -- Thistlewood Maul
	[10545]=":3929:4:2:1:::1:0:", -- Gnomish Goggles
	[10546]=":1500:0:1:5::202:1:0:", -- Deadly Scope
	[10547]=":81:2:1:1:::1:0:", -- Camping Knife
	[10548]=":2500:0:1:5:::1:0:", -- Sniper Scope
	[10549]=":162:4:2:1:::1:0:", -- Rancher\'s Trousers
	[10550]=":48:4:1:1:::1:0:", -- Wooly Mittens
	[10551]="::12:1:10:::1:0:", -- Thorium Plated Dagger
	[10552]="::12:1:1:::1:0:", -- Symbol of Ragnaros
	[10553]=":131:4:2:1:::1:0:", -- Foreman Vest
	[10554]=":119:4:2:1:::1:0:", -- Foreman Pants
	[10556]="::12:1:1:::1:0:", -- Stone Circle
	[10558]=":250:7:1:20::202:1:0:", -- Gold Power Core
	[10559]=":750:7:1:10::202:1:0:", -- Mithril Tube
	[10560]=":1000:7:1:10::202:1:0:", -- Unstable Trigger
	[10561]=":1000:7:1:10::202:1:0:", -- Mithril Casing
	[10562]=":750:7:1:10:::1:0:", -- Hi-Explosive Bomb
	[10563]="::12:1:1:::1:0:", -- Rubbing: Rune of Beth\'Amara
	[10564]="::12:1:1:::1:0:", -- Rubbing: Rune of Jin\'yael
	[10565]="::12:1:1:::1:0:", -- Rubbing: Rune of Markri
	[10566]="::12:1:1:::1:0:", -- Rubbing: Rune of Sael\'hai
	[10567]=":8725:2:3:1:::1:0:", -- Quillshooter
	[10569]="::15:1:1:::1:0:", -- Hoard of the Black Dragonflight
	[10570]=":15875:2:3:1:::1:0:", -- Manslayer
	[10571]=":10927:2:3:1:::1:0:", -- Ebony Boneclub
	[10572]=":9592:2:3:1:::1:0:", -- Freezing Shard
	[10573]=":13754:2:3:1:::1:0:", -- Boneslasher
	[10574]=":3775:4:3:1:::1:0:", -- Corpseshroud
	[10575]="::15:1:10:::1:0:", -- Black Dragonflight Molt
	[10576]=":6000:4:2:1::202:1:0:", -- Mithril Mechanical Dragonling
	[10577]=":2000:4:1:1::202:1:0:", -- Goblin Mortar
	[10578]=":3377:4:3:1:::1:0:", -- Thoughtcast Boots
	[10581]=":5310:4:3:1:::1:0:", -- Death\'s Head Vestment
	[10582]=":3606:4:3:1:::1:0:", -- Briar Tredders
	[10583]=":6191:4:3:1:::1:0:", -- Quillward Harness
	[10584]=":2905:4:3:1:::1:0:", -- Stormgale Fists
	[10585]=":750:4:1:10:::1:0:", -- Goblin Radio
	[10586]=":750:7:1:10::202:1:0:", -- The Big One
	[10587]=":1500:4:1:1:::1:0:", -- Goblin Bomb Dispenser
	[10588]=":5834:4:2:1:::1:0:", -- Goblin Rocket Helmet
	[10589]="::12:1:1:::1:0:", -- Oathstone of Ysera\'s Dragonflight
	[10590]="::12:1:1:::1:0:", -- Pocked Black Box
	[10592]=":150:0:1:20::202:1:0:", -- Catseye Elixir
	[10593]="::12:2:20:::1:0:", -- Imperfect Draenethyst Fragment
	[10597]="::12:1:1:::1:0:", -- Head of Magus Rimtori
	[10598]="::12:1:1:::1:0:", -- Hetaera\'s Bloodied Head
	[10599]="::12:1:1:::1:0:", -- Hetaera\'s Beaten Head
	[10600]="::12:1:1:::1:0:", -- Hetaera\'s Bruised Head
	[10601]=":500:9:2:1:::1:0:", -- Schematic: Bright-Eye Goggles
	[10602]="3000:750:9:1:1:::1:0:9544,8679", -- Schematic: Deadly Scope
	[10603]=":825:9:2:1:::1:0:", -- Schematic: Catseye Ultra Goggles
	[10604]=":825:9:2:1:::1:0:", -- Schematic: Mithril Heavy-bore Rifle
	[10605]=":875:9:3:1:::1:0:", -- Schematic: Spellpower Goggles Xtreme
	[10606]=":875:9:2:1:::1:0:", -- Schematic: Parachute Cloak
	[10607]="3600:900:9:1:1:::1:0:8678", -- Schematic: Deepdive Helmet
	[10608]=":950:9:3:1:::1:0:", -- Schematic: Sniper Scope
	[10609]="4000:1000:9:1:1:::1:0:2688", -- Schematic: Mithril Mechanical Dragonling
	[10610]="::12:1:1:::1:0:", -- Hetaera\'s Blood
	[10620]=":250:7:1:20::171,186:1:0:", -- Thorium Ore
	[10621]="::15:1:1:::1:0:", -- Runed Scroll
	[10622]="::12:1:1:::1:0:", -- Kadrak\'s Flag
	[10623]=":24748:2:3:1:::1:0:", -- Winter\'s Bite
	[10624]=":17249:2:3:1:::1:0:", -- Stinging Bow
	[10625]=":27366:2:3:1:::1:0:", -- Stealthblade
	[10626]=":36732:2:3:1:::1:0:", -- Ragehammer
	[10627]=":26974:2:3:1:::1:0:", -- Bludgeon of the Grinning Dog
	[10628]=":29245:2:3:1:::1:0:", -- Deathblow
	[10629]=":8066:4:3:1:::1:0:", -- Mistwalker Boots
	[10630]=":8664:4:3:1:::1:0:", -- Soulcatcher Halo
	[10631]=":6086:4:3:1:::1:0:", -- Murkwater Gauntlets
	[10632]=":7624:4:3:1:::1:0:", -- Slimescale Bracers
	[10633]=":20447:4:3:1:::1:0:", -- Silvershell Leggings
	[10634]=":10812:4:3:1:::1:0:", -- Mindseye Circle
	[10635]=":14:4:1:1:::1:0:", -- Painted Chain Leggings
	[10636]=":6:4:1:1:::1:0:", -- Nomadic Gloves
	[10637]=":139:4:2:1:::1:0:", -- Brewer\'s Gloves
	[10638]=":210:4:2:1:::1:0:", -- Long Draping Cape
	[10639]="::12:1:20:::1:0:", -- Hyacinth Mushroom
	[10640]="::12:1:20:::1:0:", -- Webwood Ichor
	[10641]="::12:1:20:::1:0:", -- Moonpetal Lily
	[10642]="::12:1:1:::1:0:", -- Iverron\'s Antidote
	[10643]="::12:1:1:::1:0:", -- Sealed Letter to Ag\'tor
	[10644]=":500:9:1:1:::1:0:", -- Recipe: Goblin Rocket Fuel
	[10645]=":750:4:1:1:::1:0:", -- Gnomish Death Ray
	[10646]=":500:7:1:10:::1:0:", -- Goblin Sapper Charge
	[10647]="2000:500:7:1:10::202:1:0:18484,9676,17222,1694,18775,9544,6777,18752,14637,19661,3133,2684,21112,16657,17421,18278,19575,2685,1316,5519,5175,16782,27711,11185,4453,4581,20890,4587,6730,3495,2683,2682,19383,1448,2687,8678,3413,8679,2688", -- Engineer\'s Ink
	[10648]="500:125:7:1:10::202:1:0:18484,9676,17222,1694,18775,9544,6777,18752,14637,19661,23363,3133,2684,21112,16657,17421,18278,19575,2685,1316,5519,5175,16782,27711,11185,4453,4581,20890,4587,6730,3495,2683,2682,19383,1448,2687,8679,8678,3413,2688", -- Blank Parchment
	[10649]="::12:1:1:::1:0:", -- Nightmare Shard
	[10652]=":36370:2:3:1:::1:0:", -- Will of the Mountain Giant
	[10653]=":1639:4:2:1:::1:0:", -- Trailblazer Boots
	[10654]=":965:4:2:1:::1:0:", -- Jutebraid Gloves
	[10655]=":9:4:1:1:::1:0:", -- Sedgeweed Britches
	[10656]=":14:4:1:1:::1:0:", -- Barkmail Vest
	[10657]=":933:4:2:1:::1:0:", -- Talbar Mantle
	[10658]=":1249:4:2:1:::1:0:", -- Quagmire Galoshes
	[10659]=":4662:4:2:1:::1:0:", -- Shard of Afrasa
	[10660]="::12:1:1:::1:0:", -- First Mosh\'aru Tablet
	[10661]="::12:1:1:::1:0:", -- Second Mosh\'aru Tablet
	[10662]="::12:1:1:::1:0:", -- Filled Egg of Hakkar
	[10663]="::0:1:1:::1:0:", -- Essence of Hakkar
	[10664]="::12:1:1:::1:0:", -- A Note to Magus Rimtori
	[10678]="::12:1:1:::1:0:", -- Magatha\'s Note
	[10679]="::12:1:1:::1:0:", -- Andron\'s Note
	[10680]="::12:1:1:::1:0:", -- Jes\'rimon\'s Note
	[10681]="::12:1:1:::1:0:", -- Xylem\'s Note
	[10682]="::12:1:1:::1:0:", -- Belnistrasz\'s Oathstone
	[10684]="2000:500:0:1:1:::1:0:7772", -- Colossal Parachute
	[10686]=":25395:4:3:1:::1:0:", -- Aegis of Battle
	[10687]="::0:1:1:::1:0:", -- Empty Vial Labeled #1
	[10688]="::0:1:1:::1:0:", -- Empty Vial Labeled #2
	[10689]="::0:1:1:::1:0:", -- Empty Vial Labeled #3
	[10690]="::0:1:1:::1:0:", -- Empty Vial Labeled #4
	[10691]="::12:1:1:::1:0:", -- Filled Vial Labeled #1
	[10692]="::12:1:1:::1:0:", -- Filled Vial Labeled #2
	[10693]="::12:1:1:::1:0:", -- Filled Vial Labeled #3
	[10694]="::12:1:1:::1:0:", -- Filled Vial Labeled #4
	[10695]="::15:1:1:::1:0:", -- Box of Empty Vials
	[10696]=":41891:2:2:1:::1:0:", -- Enchanted Azsharite Felbane Sword
	[10697]=":42044:2:2:1:::1:0:", -- Enchanted Azsharite Felbane Dagger
	[10698]=":52747:2:2:1:::1:0:", -- Enchanted Azsharite Felbane Staff
	[10699]="::12:1:1:::1:0:", -- Yeh\'kinya\'s Bramble
	[10700]=":4983:4:2:1:::1:0:", -- Encarmine Boots
	[10701]=":7536:4:2:1:::1:0:", -- Boots of Zua\'tec
	[10702]=":5379:4:2:1:::1:0:", -- Enormous Ogre Boots
	[10703]=":16792:2:2:1:::1:0:", -- Fiendish Skiv
	[10704]=":13649:2:2:1:::1:0:", -- Chillnail Splinter
	[10705]=":3666:4:2:1:::1:0:", -- Firwillow Wristbands
	[10706]=":5521:4:2:1:::1:0:", -- Nightscale Girdle
	[10707]=":13576:4:2:1:::1:0:", -- Steelsmith Greaves
	[10708]=":8982:4:2:1:::1:0:", -- Skullspell Orb
	[10709]=":10953:4:2:1:::1:0:", -- Pyrestone Orb
	[10710]=":6130:4:3:1:::1:0:", -- Dragonclaw Ring
	[10711]=":8377:4:3:1:::1:0:", -- Dragon\'s Blood Necklace
	[10712]="::12:1:1:::1:0:", -- Cuely\'s Elixir
	[10713]=":500:9:1:1:::1:0:", -- Plans: Inlaid Mithril Cylinder
	[10714]="::12:1:20:::1:0:", -- Crystallized Azsharite
	[10715]="::12:1:1:::1:0:", -- Kim\'Jael\'s Scope
	[10716]=":750:4:1:1:::1:0:", -- Gnomish Shrink Ray
	[10717]="::12:1:1:::1:0:", -- Kim\'Jael\'s Compass
	[10718]="::12:1:1:::1:0:", -- Kim\'Jael\'s Wizzlegoober
	[10720]=":750:4:1:1:::1:0:", -- Gnomish Net-o-Matic Projector
	[10721]=":3317:4:2:1:::1:0:", -- Gnomish Harm Prevention Belt
	[10722]="::12:1:1:::1:0:", -- Kim\'Jael\'s Stuffed Chicken
	[10724]=":4697:4:2:1:::1:0:", -- Gnomish Rocket Boots
	[10725]=":1500:4:1:1:::1:0:", -- Gnomish Battle Chicken
	[10726]=":5520:4:2:1:::1:0:", -- Gnomish Mind Control Cap
	[10727]=":2000:4:1:1:::1:0:", -- Goblin Dragon Gun
	[10728]="1500:375:9:1:1:::1:0:2663", -- Pattern: Black Swashbuckler\'s Shirt
	[10738]="::12:1:1:::1:0:", -- Shipment to Galvan
	[10739]=":5292:4:2:1:::1:0:", -- Ring of Fortitude
	[10740]=":18712:4:2:1:::1:0:", -- Centurion Legplates
	[10741]=":10063:4:2:1:::1:0:", -- Lordrec Helmet
	[10742]=":9589:4:2:1:::1:0:", -- Dragonflight Leggings
	[10743]=":10830:4:2:1:::1:0:", -- Drakefire Headguard
	[10744]=":24159:2:2:1:::1:0:", -- Axe of the Ebon Drake
	[10745]=":8498:4:2:1:::1:0:", -- Kaylari Shoulders
	[10746]=":8007:4:2:1:::1:0:", -- Runesteel Vambraces
	[10747]=":2327:4:2:1:::1:0:", -- Teacher\'s Sash
	[10748]=":4380:4:2:1:::1:0:", -- Wanderlust Boots
	[10749]=":18436:4:3:1:::1:0:", -- Avenguard Helm
	[10750]=":35315:2:3:1:::1:0:", -- Lifeforce Dirk
	[10751]=":10634:4:3:1:::1:0:", -- Gemburst Circlet
	[10752]="::15:2:1:::1:0:", -- Emerald Encrusted Chest
	[10753]="::12:1:1:::1:0:", -- Amulet of Grol
	[10754]="::12:1:1:::1:0:", -- Amulet of Sevine
	[10755]="::12:1:1:::1:0:", -- Amulet of Allistarj
	[10757]="::15:1:1:::1:0:", -- Ward of the Defiler
	[10758]=":20144:2:3:1:::1:0:", -- X\'caliboar
	[10759]="::12:1:1:::1:0:", -- Severed Horn of the Defiler
	[10760]=":2914:4:3:1:::1:0:", -- Swine Fists
	[10761]=":17193:2:3:1:::1:0:", -- Coldrage Dagger
	[10762]=":6903:4:3:1:::1:0:", -- Robes of the Lich
	[10763]=":9079:4:3:1:::1:0:", -- Icemetal Barbute
	[10764]=":10434:4:3:1:::1:0:", -- Deathchill Armor
	[10765]=":4041:4:3:1:::1:0:", -- Bonefingers
	[10766]=":9660:2:3:1:::1:0:", -- Plaguerot Sprig
	[10767]=":9652:4:3:1:::1:0:", -- Savage Boar\'s Guard
	[10768]=":4541:4:3:1:::1:0:", -- Boar Champion\'s Belt
	[10769]=":5277:4:3:1:::1:0:", -- Glowing Eye of Mordresh
	[10770]=":7835:4:3:1:::1:0:", -- Mordresh\'s Lifeless Skull
	[10771]=":2910:4:3:1:::1:0:", -- Deathmage Sash
	[10772]=":14604:2:3:1:::1:0:", -- Glutton\'s Cleaver
	[10773]="::15:2:1:::1:0:", -- Hakkari Urn
	[10774]=":5957:4:3:1:::1:0:", -- Fleshhide Shoulders
	[10775]=":11161:4:3:1:::1:0:", -- Carapace of Tuten\'kash
	[10776]=":4800:4:3:1:::1:0:", -- Silky Spider Cape
	[10777]=":4014:4:3:1:::1:0:", -- Arachnid Gloves
	[10778]=":16930:4:2:1:::1:0:", -- Necklace of Sanctuary
	[10779]=":8807:4:2:1:::1:0:", -- Demon\'s Blood
	[10780]=":5542:4:2:1:::1:0:", -- Mark of Hakkar
	[10781]=":15072:4:2:1:::1:0:", -- Hakkari Breastplate
	[10782]=":4539:4:2:1:::1:0:", -- Hakkari Shroud
	[10783]=":11476:4:3:1:::1:0:", -- Atal\'ai Spaulders
	[10784]=":18432:4:3:1:::1:0:", -- Atal\'ai Breastplate
	[10785]=":15840:4:3:1:::1:0:", -- Atal\'ai Leggings
	[10786]=":14373:4:3:1:::1:0:", -- Atal\'ai Boots
	[10787]=":6382:4:3:1:::1:0:", -- Atal\'ai Gloves
	[10788]=":11275:4:3:1:::1:0:", -- Atal\'ai Girdle
	[10789]="::12:1:1:::1:0:", -- Manual of Engineering Disciplines
	[10790]="::12:1:1:::1:0:", -- Gnome Engineer Membership Card
	[10791]="::12:1:1:::1:0:", -- Goblin Engineer Membership Card
	[10792]="::12:1:1:::1:0:", -- Nixx\'s Pledge of Secrecy
	[10793]="::12:1:1:::1:0:", -- Overspark\'s Pledge of Secrecy
	[10794]="::12:1:1:::1:0:", -- Oglethorpe\'s Pledge of Secrecy
	[10795]=":5542:4:3:1:::1:0:", -- Drakeclaw Band
	[10796]=":8982:4:3:1:::1:0:", -- Drakestone
	[10797]=":35069:2:3:1:::1:0:", -- Firebreather
	[10798]=":11024:4:3:1:::1:0:", -- Atal\'alarion\'s Tusk Ring
	[10799]=":39288:2:3:1:::1:0:", -- Headspike
	[10800]=":7562:4:3:1:::1:0:", -- Darkwater Bracers
	[10801]=":11704:4:3:1:::1:0:", -- Slitherscale Boots
	[10802]=":9397:4:3:1:::1:0:", -- Wingveil Cloak
	[10803]=":35329:2:3:1:::1:0:", -- Blade of the Wretched
	[10804]=":35462:2:3:1:::1:0:", -- Fist of the Damned
	[10805]=":35594:2:3:1:::1:0:", -- Eater of the Dead
	[10806]=":15146:4:3:1:::1:0:", -- Vestments of the Atal\'ai Prophet
	[10807]=":15202:4:3:1:::1:0:", -- Kilt of the Atal\'ai Prophet
	[10808]=":7629:4:3:1:::1:0:", -- Gloves of the Atal\'ai Prophet
	[10818]="::12:1:1:::1:0:", -- Yeh\'kinya\'s Scroll
	[10819]="::12:1:20:::1:0:", -- Wildkin Feather
	[10820]=":138:4:2:1:::1:0:", -- Jackseed Belt
	[10821]=":208:4:2:1:::1:0:", -- Sower\'s Cloak
	[10822]=":2500:15:1:1:::1:0:", -- Dark Whelpling
	[10823]=":17796:2:3:1:::1:0:", -- Vanquisher\'s Sword
	[10824]=":5930:4:3:1:::1:0:", -- Amberglow Talisman
	[10826]=":25501:2:2:1:::1:0:", -- Staff of Lore
	[10827]=":10238:4:2:1:::1:0:", -- Surveyor\'s Tunic
	[10828]=":40427:2:3:1:::1:0:", -- Dire Nail
	[10829]=":10680:4:3:1:::1:0:", -- Dragon\'s Eye
	[10830]=":750:0:1:10:::1:0:", -- M73 Frag Grenade
	[10831]="::15:1:1:::1:0:", -- Fel Orb
	[10832]="::12:1:1:::1:0:", -- Fel Tracker Owner\'s Manual
	[10833]=":8597:4:3:1:::1:0:", -- Horns of Eranikus
	[10834]="::15:1:1:::1:0:", -- Felhound Tracker Kit
	[10835]=":24645:4:3:1:::1:0:", -- Crest of Supremacy
	[10836]=":28989:2:3:1:::1:0:", -- Rod of Corrosion
	[10837]=":38801:2:3:1:::1:0:", -- Tooth of Eranikus
	[10838]=":34665:2:3:1:::1:0:", -- Might of Hakkar
	[10839]="::15:0:1:::1:0:", -- Crystallized Note
	[10840]="::15:0:1:::1:0:", -- Crystallized Note
	[10841]=":85:0:1:20:::1:0:", -- Goldthorn Tea
	[10842]=":17595:4:3:1:::1:0:", -- Windscale Sarong
	[10843]=":10595:4:3:1:::1:0:", -- Featherskin Cape
	[10844]=":44314:2:3:1:::1:0:", -- Spire of Hakkar
	[10845]=":24908:4:3:1:::1:0:", -- Warrior\'s Embrace
	[10846]=":16143:4:3:1:::1:0:", -- Bloodshot Greaves
	[10847]=":56921:2:4:1:::1:0:", -- Dragon\'s Call
	[10858]="3000:750:9:1:1:::1:0:8878,1471,9179", -- Plans: Solid Iron Maul
	[10918]=":42:0:1:20:::1:0:", -- Wound Poison
	[10919]=":215:4:2:1:::1:0:", -- Apothecary Gloves
	[10920]=":67:0:1:20:::1:0:", -- Wound Poison II
	[10921]=":125:0:1:20:::1:0:", -- Wound Poison III
	[10922]="700:175:0:1:20:::1:0:17078", -- Wound Poison IV
	[10938]="800::7:2:10::333:1:0:19663,3346,19537,3012,19234,18773,15419,1318,4228,19540,4617,5158,5757,16635,16722,18753,18951,5758", -- Lesser Magic Essence
	[10939]="::7:2:10::333:1:0:", -- Greater Magic Essence
	[10940]="800::7:1:20::333:1:0:19663,3346,19537,3012,19234,18773,15419,1318,4228,19540,4617,5158,5757,16635,16722,18753,18951,5758", -- Strange Dust
	[10958]="::12:1:1:::1:0:", -- Hilary\'s Necklace
	[10959]=":8750:1:2:1:::1:0:", -- Demon Hide Sack
	[10978]="::7:3:20::333:1:0:", -- Small Glimmering Shard
	[10998]="::7:2:10::333:1:0:", -- Lesser Astral Essence
	[10999]="::12:1:1:::1:0:", -- Ironfel
	[11000]="::13:1:1:::1:0:", -- Shadowforge Key
	[11018]=":146:12:1:100:::1:0:", -- Un\'Goro Soil
	[11020]="10000::12:1:1:::1:0:4217,7879,9087", -- Evergreen Pouch
	[11022]="1000:250:12:1:20:::1:0:4217,7879,9087", -- Packet of Tharlendris Seeds
	[11023]="10000:2500:15:1:1:::1:0:6548", -- Ancona Chicken
	[11024]="::12:1:1:::1:0:", -- Evergreen Herb Casing
	[11026]="10000:2500:15:1:1:::1:0:14860", -- Tree Frog Box
	[11027]="10000:2500:15:1:1:::1:0:14860", -- Wood Frog Box
	[11038]=":200:9:2:1:::1:0:", -- Formula: Enchant 2H Weapon - Lesser Spirit
	[11039]="800:200:9:2:1:::1:0:3954,12043", -- Formula: Enchant Cloak - Minor Agility
	[11040]=":1:12:1:20::197:1:0:", -- Morrowgrain
	[11058]="::12:1:1:::1:0:", -- Sha\'ni\'s Nose-Ring
	[11078]="::13:1:20:::1:0:", -- Relic Coffer Key
	[11079]="::15:1:1:::1:0:", -- Gor\'tesh\'s Lopped Off Head
	[11080]="::12:1:1:::1:0:", -- Gor\'tesh\'s Lopped Off Head
	[11081]=":200:9:2:1:::1:0:", -- Formula: Enchant Shield - Lesser Protection
	[11082]="::7:2:10::333:1:0:", -- Greater Astral Essence
	[11083]="::7:1:20::333,755:1:0:", -- Soul Dust
	[11084]="::7:3:20::333:1:0:", -- Large Glimmering Shard
	[11086]=":27403:2:3:1:::1:0:", -- Jang\'thraze the Protector
	[11098]=":500:9:2:1:::1:0:", -- Formula: Enchant Cloak - Lesser Shadow Resistance
	[11101]="2500:625:9:2:1:::1:0:3954,12043", -- Formula: Enchant Bracer - Lesser Strength
	[11102]="::12:1:1:::1:0:", -- Unhatched Sprite Darter Egg
	[11103]="::12:1:1:::1:0:", -- Seed Voucher
	[11104]="::12:1:1:::1:0:", -- Large Compass
	[11105]="::12:1:1:::1:0:", -- Curled Map Parchment
	[11106]="::13:1:1:::1:0:", -- Lion-headed Key
	[11107]="::12:1:1:::1:0:", -- A Small Pack
	[11108]="::12:1:1:::1:0:", -- Faded Photograph
	[11109]="25:6:0:1:1:::1:0:233", -- Special Chicken Feed
	[11110]=":2:15:1:1:::1:0:", -- Chicken Egg
	[11112]="::12:1:1:::1:0:", -- Research Equipment
	[11113]="::12:1:1:::1:0:", -- Crate of Foodstuffs
	[11114]="::12:1:20:::1:0:", -- Dinosaur Bone
	[11116]="::15:2:1:::1:0:", -- A Mangled Journal
	[11118]=":10795:4:3:1:::1:0:", -- Archaedic Stone
	[11119]="::12:1:20:::1:0:", -- Milly\'s Harvest
	[11120]=":30144:2:2:1:::1:0:", -- Belgrom\'s Hammer
	[11121]=":3529:2:3:1:::1:0:", -- Darkwater Talwar
	[11122]=":7162:4:2:1:::1:0:", -- Carrot on a Stick
	[11123]=":15037:4:3:1:::1:0:", -- Rainstrider Leggings
	[11124]=":16980:4:3:1:::1:0:", -- Helm of Exile
	[11125]="::12:1:1:::1:0:", -- Grape Manifest
	[11126]="::12:1:1:::1:0:", -- Tablet of Kurniya
	[11127]="::12:1:20:::1:0:", -- Scavenged Goods
	[11128]=":500:7:1:1::333:1:0:", -- Golden Rod
	[11129]="::12:1:20:::1:0:", -- Essence of the Elements
	[11130]=":500:7:1:1::333:1:0:", -- Runed Golden Rod
	[11131]="::12:1:1:::1:0:", -- Hive Wall Sample
	[11132]="::12:1:1:::1:0:", -- Unused Scraping Vial
	[11133]="::12:1:1:::1:0:", -- Linken\'s Training Sword
	[11134]="::7:2:10::333:1:0:", -- Lesser Mystic Essence
	[11135]="::7:2:10::333:1:0:", -- Greater Mystic Essence
	[11136]="::12:1:1:::1:0:", -- Linken\'s Tempered Sword
	[11137]="::7:1:20::333,755,197:1:0:", -- Vision Dust
	[11138]="::7:3:20::333:1:0:", -- Small Glowing Shard
	[11139]="::7:3:20::333:1:0:", -- Large Glowing Shard
	[11140]="::13:1:1:::1:0:", -- Prison Cell Key
	[11141]="2000::12:1:1:::1:0:7775", -- Bait
	[11142]="::12:1:1:::1:0:", -- Broken Samophlange
	[11143]="::12:1:20:::1:0:", -- Nugget Slug
	[11144]=":1000:7:1:1::333:1:0:", -- Truesilver Rod
	[11145]=":1250:7:1:1::333:1:0:", -- Runed Truesilver Rod
	[11146]="::12:1:1:::1:0:", -- Broken and Battered Samophlange
	[11147]="::12:1:1:::1:0:", -- Samophlange Manual Cover
	[11148]="::0:1:20:::1:0:", -- Samophlange Manual Page
	[11149]="::12:1:1:::1:0:", -- Samophlange Manual
	[11150]=":750:9:2:1:::1:0:", -- Formula: Enchant Gloves - Mining
	[11151]=":750:9:2:1:::1:0:", -- Formula: Enchant Gloves - Herbalism
	[11152]=":750:9:2:1:::1:0:", -- Formula: Enchant Gloves - Fishing
	[11162]="::12:1:1:::1:0:", -- Linken\'s Superior Sword
	[11163]="3000:750:9:2:1:::1:0:2821,2381", -- Formula: Enchant Bracer - Lesser Deflection
	[11164]=":750:9:2:1:::1:0:", -- Formula: Enchant Weapon - Lesser Beastslayer
	[11165]=":750:9:2:1:::1:0:", -- Formula: Enchant Weapon - Lesser Elemental Slayer
	[11166]=":1000:9:2:1:::1:0:", -- Formula: Enchant Gloves - Skinning
	[11167]=":1000:9:2:1:::1:0:", -- Formula: Enchant Boots - Lesser Spirit
	[11168]=":1000:9:2:1:::1:0:", -- Formula: Enchant Shield - Lesser Block
	[11169]="::12:1:1:::1:0:", -- Book of Aquor
	[11172]="::12:1:20:::1:0:", -- Silvery Claws
	[11173]="::12:1:1:::1:0:", -- Irontree Heart
	[11174]="::7:2:10::333:1:0:", -- Lesser Nether Essence
	[11175]="::7:2:10::333:1:0:", -- Greater Nether Essence
	[11176]="::7:1:20::171,333,197:1:0:", -- Dream Dust
	[11177]="::7:3:20::333:1:0:", -- Small Radiant Shard
	[11178]="::7:3:20::333,755:1:0:", -- Large Radiant Shard
	[11179]="::12:1:1:::1:0:", -- Golden Flame
	[11184]="::12:1:100::164:1:0:", -- Blue Power Crystal
	[11185]="::12:1:100::164:1:0:", -- Green Power Crystal
	[11186]="::12:1:100::164:1:0:", -- Red Power Crystal
	[11187]=":5:4:1:1:::1:0:", -- Stemleaf Bracers
	[11188]="::12:1:100::164:1:0:", -- Yellow Power Crystal
	[11189]=":10:4:1:1:::1:0:", -- Woodland Robes
	[11190]=":5:4:1:1:::1:0:", -- Viny Gloves
	[11191]=":45:4:1:1:::1:0:", -- Farmer\'s Boots
	[11192]=":4:4:1:1:::1:0:", -- Outfitter Gloves
	[11193]=":16938:4:2:1:::1:0:", -- Blazewind Breastplate
	[11194]=":20405:4:2:1:::1:0:", -- Prismscale Hauberk
	[11195]=":23897:4:2:1:::1:0:", -- Warforged Chestplate
	[11196]=":16875:4:2:1:::1:0:", -- Mindburst Medallion
	[11197]="::13:1:1:::1:0:", -- Dark Keeper Key
	[11202]=":1100:9:2:1:::1:0:", -- Formula: Enchant Shield - Stamina
	[11203]=":1100:9:2:1:::1:0:", -- Formula: Enchant Gloves - Advanced Mining
	[11204]=":1100:9:2:1:::1:0:", -- Formula: Enchant Bracer - Greater Spirit
	[11205]=":1250:9:2:1:::1:0:", -- Formula: Enchant Gloves - Advanced Herbalism
	[11206]=":1250:9:2:1:::1:0:", -- Formula: Enchant Cloak - Lesser Agility
	[11207]=":3000:9:2:1:::1:0:", -- Formula: Enchant Weapon - Fiery Weapon
	[11208]=":1350:9:2:1:::1:0:", -- Formula: Enchant Weapon - Demonslaying
	[11222]="::12:1:1:::1:0:", -- Head of Krom\'zar
	[11223]="5800:1450:9:2:1:::1:0:989,4229", -- Formula: Enchant Bracer - Deflection
	[11224]=":1450:9:2:1:::1:0:", -- Formula: Enchant Shield - Frost Resistance
	[11225]=":1550:9:2:1:::1:0:", -- Formula: Enchant Bracer - Greater Stamina
	[11226]=":1550:9:2:1:::1:0:", -- Formula: Enchant Gloves - Riding Skill
	[11227]="::12:1:1:::1:0:", -- Piece of Krom\'zar\'s Banner
	[11229]=":1696:4:2:1:::1:0:", -- Brightscale Girdle
	[11230]="::12:1:1:::1:0:", -- Encased Fiery Essence
	[11231]="::12:1:10:::1:0:", -- Altered Black Dragonflight Molt
	[11242]="::12:1:1:::1:0:", -- Evoroot
	[11243]="::12:1:20:::1:0:", -- Videre Elixir
	[11262]=":8142:4:3:1:::1:0:", -- Orb of Lorica
	[11263]=":10103:2:3:1:::1:0:", -- Nether Force Wand
	[11265]=":16485:2:2:1:::1:0:", -- Cragwood Maul
	[11266]="::12:1:20:::1:0:", -- Fractured Elemental Shard
	[11267]="::12:1:1:::1:0:", -- Elemental Shard Sample
	[11268]="::12:1:1:::1:0:", -- Head of Argelmach
	[11269]="::12:1:10:::1:0:", -- Intact Elemental Core
	[11270]="::12:1:1:::1:0:", -- Nixx\'s Signed Pledge
	[11282]="::12:1:1:::1:0:", -- Oglethorpe\'s Signed Pledge
	[11283]="::12:1:1:::1:0:", -- Overspark\'s Signed Pledge
	[11284]="1000:1:6:1:200:::200:0:19197,19694,1285,11555,20231,3053,19315,11184,20249,19351,19473,19498,22270,19679,19436,12246,18011,23373,19534,16191,2803,19574,16732,19374,3313,20080,21082,12959,1461,9551,734,19560,12021,2685,20092,18907,9548,8139,19339,19625,4555,2401,21483,2084,5123,20194,7942,12027,3018,4241,4889,21183,19243,4603,25035,2808,15397,11038,19474,3625,18959,21488,16602,6028,16826,19343,12960,2806,2908,19020,8362,5101,1149,4170,21111,3541,23143,15174,20892,3350,16620,1297,3322,19053,19649,4896,16735,14624,19021,8131,19452,5134,19718,2820,19314,22099", -- Accurate Slugs
	[11285]="1000:2:6:1:200:::200:0:19197,19694,1285,11555,4173,20231,19315,20249,19351,19473,19498,22270,19679,19436,5122,12246,18011,23373,19534,16191,9555,2803,19574,2839,16732,19374,3313,20080,21082,12959,9551,734,19560,12021,20092,18907,9548,8139,19339,19625,4555,2401,21483,2084,20194,7942,12027,4241,21183,19561,16919,19243,25035,2808,4604,15397,11038,19474,3625,18959,21488,1462,3410,16602,6028,16826,3015,19343,12960,2806,2908,19020,789,8362,5101,1149,4170,21111,3541,9552,4892,23143,14301,1298,15174,20892,3350,228,19053,19649,4896,14624,17598,19021,19452,5134,19718,2820,19314,22099", -- Jagged Arrow
	[11286]="::12:1:1:::1:0:", -- Thorium Shackles
	[11287]=":508:2:2:1:::1:0:", -- Lesser Magic Wand
	[11288]=":1535:2:2:1:::1:0:", -- Greater Magic Wand
	[11289]=":3581:2:2:1:::1:0:", -- Lesser Mystic Wand
	[11290]=":5263:2:2:1:::1:0:", -- Greater Mystic Wand
	[11291]="4500:1125:7:1:20::333,202:1:0:19663,3346,19537,3012,19234,18773,15419,1318,4228,19540,4617,5158,5757,16635,16722,18753,18951,5758", -- Star Wood
	[11302]=":7130:4:3:1:::1:0:", -- Uther\'s Strength
	[11303]="3185:637:2:2:1:::1:0:5122,4604,3410,14846,1198,4173,3015,1298", -- Fine Shortbow
	[11304]="4862:972:2:2:1:::1:0:3534,9553,9551,228,9549,1668,1687,3488,1459", -- Fine Longbow
	[11305]="25814:5162:2:2:1:::1:0:9551,14846,3951,9552,4892,14301,9555,2839", -- Dense Shortbow
	[11306]="19468:3893:2:2:1:::1:0:5122,4604,24408,3410,14846,4173,3015,1298", -- Sturdy Recurve
	[11307]="67952:13590:2:2:1:::1:0:5122,4604,3410,3015,1298", -- Massive Longbow
	[11308]="78829:15765:2:2:1:::1:0:12029,9548,19499,14846,4173", -- Sylvan Shortbow
	[11309]="::12:1:1:::1:0:", -- The Heart of the Mountain
	[11310]=":6598:4:3:1:::1:0:", -- Flameseer Mantle
	[11311]=":6132:4:3:1:::1:0:", -- Emberscale Cape
	[11312]="::12:1:1:::1:0:", -- Lost Thunderbrew Recipe
	[11313]="::12:1:1:::1:0:", -- Ribbly\'s Head
	[11315]="::12:1:100:::1:0:", -- Bloodpetal Sprout
	[11316]="::12:1:20:::1:0:", -- Bloodpetal
	[11318]="::12:1:20:::1:0:", -- Atal\'ai Haze
	[11319]="::12:1:1:::1:0:", -- Unloaded Zapper
	[11320]="::12:1:1:::1:0:", -- Bloodpetal Zapper
	[11324]=":6250:1:1:1:::1:0:", -- Explorer\'s Knapsack
	[11325]="600:150:0:1:20:::1:0:9499", -- Dark Iron Ale Mug
	[11362]="1000:250:11:1:1:::1:0:3589,4604,9553,1198,4602,4173,7976,1668,1462,3410,6028,3015,10369,19020,789,3951,4203,9552,5122,4892,1687,3610,3409,9555,3488,14301,16715,2839,1298,9551,1297,228,9549,12029,16619,9548,16274,1459,17667,17598,1287,3165,16919,19561,16263", -- Medium Quiver
	[11363]="1000:250:11:1:1:::1:0:2685,6028", -- Medium Shot Pouch
	[11366]="::12:1:1:::1:0:", -- Helendis Riverhorn\'s Letter
	[11367]="::12:1:1:::1:0:", -- Solomon\'s Plea to Bolvar
	[11368]="::12:1:1:::1:0:", -- Bolvar\'s Decree
	[11370]=":500:7:1:20::186:1:0:", -- Dark Iron Ore
	[11371]=":600:7:1:20::164,202,755:1:0:", -- Dark Iron Bar
	[11382]=":750:3:2:20::164,333,755:1:0:", -- Blood of the Mountain
	[11384]=":70:15:0:20:::1:0:", -- Broken Basilisk Teeth
	[11385]=":145:15:0:20:::1:0:", -- Basilisk Scale
	[11386]=":676:15:0:10:::1:0:", -- Squishy Basilisk Eye
	[11387]=":1013:15:0:5:::1:0:", -- Basilisk Heart
	[11388]=":1563:15:0:5:::1:0:", -- Basilisk Venom
	[11389]=":2163:15:0:5:::1:0:", -- Shimmering Basilisk Skin
	[11390]=":80:15:0:20:::1:0:", -- Broken Bat Fang
	[11391]=":205:15:0:10:::1:0:", -- Spined Bat Wing
	[11392]=":403:15:0:5:::1:0:", -- Severed Bat Claw
	[11393]=":780:15:0:10:::1:0:", -- Small Bat Skull
	[11394]=":580:15:0:10:::1:0:", -- Bat Heart
	[11395]=":830:15:0:10:::1:0:", -- Bat Ear
	[11402]=":1205:15:0:10:::1:0:", -- Sleek Bat Pelt
	[11403]=":1592:15:0:10:::1:0:", -- Large Bat Fang
	[11404]=":2080:12:1:10:::1:0:", -- Evil Bat Eye
	[11405]="::12:1:20:::1:0:", -- Giant Silver Vein
	[11406]=":168:15:0:5:::1:0:", -- Rotting Bear Carcass
	[11407]=":108:12:1:10:::1:0:", -- Torn Bear Pelt
	[11408]=":898:15:0:10:::1:0:", -- Bear Jaw
	[11409]=":503:15:0:10:::1:0:", -- Bear Organ
	[11410]=":578:15:0:10:::1:0:", -- Savage Bear Claw
	[11411]=":1484:2:0:1:::1:0:", -- Large Bear Bone
	[11412]="::12:1:1:::1:0:", -- Nagmara\'s Vial
	[11413]="::12:1:1:::1:0:", -- Nagmara\'s Filled Vial
	[11414]=":1828:15:0:10:::1:0:", -- Grizzled Mane
	[11415]=":200:0:1:20:::1:0:", -- Mixed Berries
	[11416]=":328:15:0:10:::1:0:", -- Delicate Ribcage
	[11417]=":1204:15:0:5:::1:0:", -- Feathery Wing
	[11418]=":604:15:0:5:::1:0:", -- Hollow Wing Bone
	[11419]=":1900:15:0:10:::1:0:", -- Mysterious Unhatched Egg
	[11420]=":1712:15:0:10:::1:0:", -- Elegant Writing Tool
	[11422]="::15:1:1:::1:0:", -- Goblin Engineer\'s Renewal Gift
	[11423]="::15:1:1:::1:0:", -- Gnome Engineer\'s Renewal Gift
	[11444]="4000:200:0:1:20:::5:0:9499", -- Grim Guzzler Boar
	[11445]="::12:1:1:::1:0:", -- Flute of the Ancients
	[11446]="::12:1:1:::1:0:", -- A Crumpled Up Note
	[11462]="::12:1:1:::1:0:", -- Discarded Knife
	[11463]="::12:2:1:::1:0:", -- Undelivered Parcel
	[11464]="::12:1:1:::1:0:", -- Marshal Windsor\'s Lost Information
	[11465]="::12:1:1:::1:0:", -- Marshal Windsor\'s Lost Information
	[11466]="::12:1:1:::1:0:", -- Raschal\'s Report
	[11467]="::12:1:50:::1:0:", -- Blackrock Medallion
	[11468]="::12:1:20:::1:0:", -- Dark Iron Fanny Pack
	[11469]=":3563:4:2:1:::1:0:", -- Bloodband Bracers
	[11470]="::12:1:1:::1:0:", -- Tablet Transcript
	[11471]="::12:1:1:::1:0:", -- Fragile Sprite Darter Egg
	[11472]="::12:1:10:::1:0:", -- Silvermane Stalker Flank
	[11474]=":500:15:1:1:::1:0:", -- Sprite Darter Egg
	[11475]=":7:4:1:1:::1:0:", -- Wine-stained Cloak
	[11476]="::12:1:1:::1:0:", -- U\'cha\'s Pelt
	[11477]="::12:1:10:::1:0:", -- White Ravasaur Claw
	[11478]="::12:1:10:::1:0:", -- Un\'Goro Gorilla Pelt
	[11479]="::12:1:10:::1:0:", -- Un\'Goro Stomper Pelt
	[11480]="::12:1:10:::1:0:", -- Un\'Goro Thunderer Pelt
	[11482]="::12:1:1:::1:0:", -- Crystal Pylon User\'s Manual
	[11502]=":6510:4:2:1:::1:0:", -- Loreskin Shoulders
	[11503]="::12:1:20:::1:0:", -- Blood Amber
	[11504]="::12:1:1:::1:0:", -- Piece of Threshadon Carcass
	[11509]="::12:1:5:::1:0:", -- Ravasaur Pheromone Gland
	[11510]="::12:1:1:::1:0:", -- Lar\'korwi\'s Head
	[11511]="::12:1:1:::1:0:", -- Cenarion Beacon
	[11512]="::12:1:20:::1:0:", -- Patch of Tainted Skin
	[11513]=":1:12:1:20:::1:0:", -- Tainted Vitriol
	[11514]=":1:12:1:20:::1:0:", -- Fel Creep
	[11515]=":1:12:1:20:::1:0:", -- Corrupted Soul Shard
	[11516]="::12:1:100:::1:0:", -- Cenarion Plant Salve
	[11522]="::4:1:1:::1:0:", -- Silver Totem of Aquementas
	[11562]=":1000:12:1:20:::1:0:", -- Crystal Restore
	[11563]=":1000:12:1:20:::1:0:", -- Crystal Force
	[11564]=":1000:12:1:20:::1:0:", -- Crystal Ward
	[11565]=":1000:12:1:20:::1:0:", -- Crystal Yield
	[11566]=":1000:12:1:20:::1:0:", -- Crystal Charge
	[11567]=":1000:12:1:20:::1:0:", -- Crystal Spire
	[11568]="::15:1:1:::1:0:", -- Torwa\'s Pouch
	[11569]="::12:1:1:::1:0:", -- Preserved Threshadon Meat
	[11570]="::12:1:1:::1:0:", -- Preserved Pheromone Mixture
	[11582]="::15:1:1:::1:0:", -- Fel Salve
	[11583]="::12:1:10:::1:0:", -- Cactus Apple
	[11584]=":1:0:1:20:::1:0:", -- Cactus Apple Surprise
	[11590]=":250:7:1:5:::1:0:", -- Mechanical Repair Kit
	[11602]="::13:1:1:::1:0:", -- Grim Guzzler Key
	[11603]=":30656:2:3:1:::1:0:", -- Vilerend Slicer
	[11604]=":34000:4:3:1:::1:0:", -- Dark Iron Plate
	[11605]=":18822:4:2:1:::1:0:", -- Dark Iron Shoulders
	[11606]=":19256:4:2:1:::1:0:", -- Dark Iron Mail
	[11607]=":51225:2:3:1:::1:0:", -- Dark Iron Sunderer
	[11608]=":45760:2:3:1:::1:0:", -- Dark Iron Pulverizer
	[11610]=":3000:9:3:1:::1:0:", -- Plans: Dark Iron Pulverizer
	[11611]=":3000:9:3:1:::1:0:", -- Plans: Dark Iron Sunderer
	[11612]=":3000:9:3:1:::1:0:", -- Plans: Dark Iron Plate
	[11614]=":3000:9:2:1:::1:0:", -- Plans: Dark Iron Mail
	[11615]=":3000:9:2:1:::1:0:", -- Plans: Dark Iron Shoulders
	[11617]="::12:1:1:::1:0:", -- Eridan\'s Supplies
	[11622]="::0:2:1:::1:0:", -- Lesser Arcanum of Rumination
	[11623]=":9999:4:3:1:::1:0:", -- Spritecaster Cape
	[11624]=":9079:4:3:1:::1:0:", -- Kentic Amice
	[11625]=":10452:4:3:1:::1:0:", -- Enthralled Sphere
	[11626]=":9698:4:3:1:::1:0:", -- Blackveil Cape
	[11627]=":14668:4:3:1:::1:0:", -- Fleetfoot Greaves
	[11628]=":24433:2:3:1:::1:0:", -- Houndmaster\'s Bow
	[11629]=":24527:2:3:1:::1:0:", -- Houndmaster\'s Rifle
	[11630]=":5:6:3:200:::1:0:", -- Rockshard Pellets
	[11631]=":19893:4:3:1:::1:0:", -- Stoneshell Guard
	[11632]=":16349:4:3:1:::1:0:", -- Earthslag Shoulders
	[11633]=":24633:4:3:1:::1:0:", -- Spiderfang Carapace
	[11634]=":7063:4:3:1:::1:0:", -- Silkweb Gloves
	[11635]=":35451:2:3:1:::1:0:", -- Hookfang Shanker
	[11642]="::0:2:1:::1:0:", -- Lesser Arcanum of Constitution
	[11643]="::0:2:1:::1:0:", -- Lesser Arcanum of Tenacity
	[11644]="::0:2:1:::1:0:", -- Lesser Arcanum of Resilience
	[11645]="::0:2:1:::1:0:", -- Lesser Arcanum of Voracity
	[11646]="::0:2:1:::1:0:", -- Lesser Arcanum of Voracity
	[11647]="::0:2:1:::1:0:", -- Lesser Arcanum of Voracity
	[11648]="::0:2:1:::1:0:", -- Lesser Arcanum of Voracity
	[11649]="::0:2:1:::1:0:", -- Lesser Arcanum of Voracity
	[11662]=":7462:4:3:1:::1:0:", -- Ban\'thok Sash
	[11665]=":8532:4:3:1:::1:0:", -- Ogreseer Fists
	[11668]="::12:1:1:::1:0:", -- Flute of Xavaric
	[11669]=":17157:4:3:1:::1:0:", -- Naglering
	[11674]="::12:1:20:::1:0:", -- Jadefire Felbind
	[11675]=":14464:4:3:1:::1:0:", -- Shadefiend Boots
	[11677]=":11655:4:3:1:::1:0:", -- Graverot Cape
	[11678]=":27293:4:3:1:::1:0:", -- Carapace of Anub\'shiah
	[11679]=":11738:4:3:1:::1:0:", -- Rubicund Armguards
	[11682]="::12:1:1:::1:0:", -- Eridan\'s Vial
	[11684]=":63086:2:4:1:::1:0:", -- Ironfoe
	[11685]=":13941:4:3:1:::1:0:", -- Splinthide Shoulders
	[11686]=":9329:4:3:1:::1:0:", -- Girdle of Beastial Fury
	[11702]=":36752:2:3:1:::1:0:", -- Grizzle\'s Skinner
	[11703]=":12986:4:3:1:::1:0:", -- Stonewall Girdle
	[11722]=":16610:4:3:1:::1:0:", -- Dregmetal Spaulders
	[11723]="::12:1:1:::1:0:", -- Goodsteel\'s Balanced Flameberge
	[11724]="::12:1:1:::1:0:", -- Overdue Package
	[11725]="::12:1:20:::1:0:", -- Solid Crystal Leg Shaft
	[11726]=":33533:4:4:1:::1:0:", -- Savage Gladiator Chain
	[11727]="::12:1:1:::1:0:", -- Goodsteel Ledger
	[11728]=":25336:4:3:1:::1:0:", -- Savage Gladiator Leggings
	[11729]=":19073:4:3:1:::1:0:", -- Savage Gladiator Helm
	[11730]=":12762:4:3:1:::1:0:", -- Savage Gladiator Grips
	[11731]=":19300:4:3:1:::1:0:", -- Savage Gladiator Greaves
	[11732]="::9:2:1:::1:0:", -- Libram of Rumination
	[11733]="::9:2:1:::1:0:", -- Libram of Constitution
	[11734]="::9:2:1:::1:0:", -- Libram of Tenacity
	[11735]=":16670:4:3:1:::1:0:", -- Ragefury Eyepatch
	[11736]="::9:2:1:::1:0:", -- Libram of Resilience
	[11737]="::9:2:1:::1:0:", -- Libram of Voracity
	[11742]=":8750:1:2:1:::1:0:", -- Wayfarer\'s Knapsack
	[11743]=":36881:2:3:1:::1:0:", -- Rockfist
	[11744]=":39242:2:3:1:::1:0:", -- Bloodfist
	[11745]=":13865:4:3:1:::1:0:", -- Fists of Phalanx
	[11746]=":20718:4:3:1:::1:0:", -- Golem Skull Helm
	[11747]=":16659:4:3:1:::1:0:", -- Flamestrider Robes
	[11748]=":25083:2:3:1:::1:0:", -- Pyric Caduceus
	[11749]=":20141:4:3:1:::1:0:", -- Searingscale Leggings
	[11750]=":43234:2:3:1:::1:0:", -- Kindling Stave
	[11751]="::12:1:5:::1:0:", -- Burning Essence
	[11752]="::12:1:5:::1:0:", -- Black Blood of the Tormented
	[11753]="::12:1:1:::1:0:", -- Eye of Kajal
	[11754]="::12:2:20::164,755,165:1:0:", -- Black Diamond
	[11755]=":14627:4:3:1:::1:0:", -- Verek\'s Collar
	[11764]=":10398:4:3:1:::1:0:", -- Cinderhide Armsplints
	[11765]=":12525:4:3:1:::1:0:", -- Pyremail Wristguards
	[11766]=":8606:4:3:1:::1:0:", -- Flameweave Cuffs
	[11767]=":15202:4:3:1:::1:0:", -- Emberplate Armguards
	[11768]=":8669:4:3:1:::1:0:", -- Incendic Bracers
	[11782]=":12720:4:3:1:::1:0:", -- Boreal Mantle
	[11783]=":12767:4:3:1:::1:0:", -- Chillsteel Girdle
	[11784]=":33835:2:3:1:::1:0:", -- Arbiter\'s Blade
	[11785]=":29083:4:3:1:::1:0:", -- Rock Golem Bulwark
	[11786]=":50740:2:3:1:::1:0:", -- Stone of the Earth
	[11787]=":23986:4:3:1:::1:0:", -- Shalehusk Boots
	[11802]=":31459:4:3:1:::1:0:", -- Lavacrest Leggings
	[11803]=":50177:2:3:1:::1:0:", -- Force of Magma
	[11804]="::12:1:1:::1:0:", -- Spraggle\'s Canteen
	[11805]=":40439:2:3:1:::1:0:", -- Rubidium Hammer
	[11807]=":9153:4:3:1:::1:0:", -- Sash of the Burning Heart
	[11808]=":19292:4:4:1:::1:0:", -- Circle of Flame
	[11809]=":51287:2:3:1:::1:0:", -- Flame Wrath
	[11810]=":10000:4:3:1:::1:0:", -- Force of Will
	[11811]=":1500:4:3:1:::1:0:", -- Smoking Heart of the Mountain
	[11812]=":13979:4:3:1:::1:0:", -- Cape of the Fire Salamander
	[11813]=":3000:9:2:1:::1:0:", -- Formula: Smoking Heart of the Mountain
	[11814]=":13083:4:3:1:::1:0:", -- Molten Fists
	[11815]=":10000:4:3:1:::1:0:", -- Hand of Justice
	[11816]=":48882:2:3:1:::1:0:", -- Angerforge\'s Battle Axe
	[11817]=":39254:2:3:1:::1:0:", -- Lord General\'s Sword
	[11818]="::12:1:1:::1:0:", -- Grimesilt Outhouse Key
	[11819]=":10000:4:3:1:::1:0:", -- Second Wind
	[11820]=":26761:4:3:1:::1:0:", -- Royal Decorated Armor
	[11821]=":22385:4:3:1:::1:0:", -- Warstrife Leggings
	[11822]=":14153:4:3:1:::1:0:", -- Omnicast Boots
	[11823]=":23677:4:3:1:::1:0:", -- Luminary Kilt
	[11824]=":13657:4:3:1:::1:0:", -- Cyclopean Band
	[11825]=":2500:15:1:1:::1:0:", -- Pet Bombling
	[11826]=":2500:15:1:1:::1:0:", -- Lil\' Smoky
	[11827]=":675:9:2:1:::1:0:", -- Schematic: Lil\' Smoky
	[11828]=":675:9:2:1:::1:0:", -- Schematic: Pet Bombling
	[11829]="::12:1:20:::1:0:", -- Un\'Goro Ash
	[11830]="::12:1:20:::1:0:", -- Webbed Diemetradon Scale
	[11831]="::12:1:20:::1:0:", -- Webbed Pterrordax Scale
	[11832]=":10000:4:3:1:::1:0:", -- Burst of Knowledge
	[11833]="::12:1:1:::1:0:", -- Gorishi Queen Lure
	[11834]="::12:1:20:::1:0:", -- Super Sticky Tar
	[11835]="::12:1:1:::1:0:", -- Gorishi Queen Brain
	[11837]="::12:1:1:::1:0:", -- Gorishi Scent Gland
	[11839]=":11191:4:3:1:::1:0:", -- Chief Architect\'s Monocle
	[11840]=":7137:4:1:1:::1:0:", -- Master Builder\'s Shirt
	[11841]=":15032:4:3:1:::1:0:", -- Senior Designer\'s Pantaloons
	[11842]=":17050:4:3:1:::1:0:", -- Lead Surveyor\'s Mantle
	[11843]="::12:1:1:::1:0:", -- Bank Voucher
	[11844]="::12:1:1:::1:0:", -- Pestlezugg\'s Un\'Goro Report
	[11845]=":62:1:1:1:::1:0:", -- Handmade Leather Bag
	[11846]=":30:0:1:20:::1:0:", -- Wizbang\'s Special Brew
	[11847]=":7:4:1:1:::1:0:", -- Battered Cloak
	[11848]=":5:4:1:1:::1:0:", -- Flax Belt
	[11849]=":7:4:1:1:::1:0:", -- Rustmetal Bracers
	[11850]=":7:4:1:1:::1:0:", -- Short Duskbat Cape
	[11851]=":12:4:1:1:::1:0:", -- Scavenger Tunic
	[11852]=":14:4:1:1:::1:0:", -- Roamer\'s Leggings
	[11853]=":388:4:2:1:::1:0:", -- Rambling Boots
	[11854]=":1494:2:2:1:::1:0:", -- Samophlange Screwdriver
	[11855]=":782:4:2:1:::1:0:", -- Tork Wrench
	[11856]=":15775:2:2:1:::1:0:", -- Ceremonial Elven Blade
	[11857]=":21377:2:2:1:::1:0:", -- Sanctimonial Rod
	[11858]=":4768:4:2:1:::1:0:", -- Battlehard Cape
	[11859]=":7135:4:2:1:::1:0:", -- Jademoon Orb
	[11860]=":12971:2:2:1:::1:0:", -- Charged Lightning Rod
	[11861]=":5207:4:2:1:::1:0:", -- Girdle of Reprisal
	[11862]=":7042:4:2:1:::1:0:", -- White Bone Band
	[11863]=":27191:2:2:1:::1:0:", -- White Bone Shredder
	[11864]=":34108:2:2:1:::1:0:", -- White Bone Spear
	[11865]=":8708:4:2:1:::1:0:", -- Rancor Boots
	[11866]=":9819:4:3:1:::1:0:", -- Nagmara\'s Whipping Belt
	[11867]=":8769:4:2:1:::1:0:", -- Maddening Gauntlets
	[11868]=":6542:4:2:1:::1:0:", -- Choking Band
	[11869]=":6542:4:2:1:::1:0:", -- Sha\'ni\'s Ring
	[11870]=":10287:4:2:1:::1:0:", -- Oblivion Orb
	[11871]=":10666:4:2:1:::1:0:", -- Snarkshaw Spaulders
	[11872]=":14962:4:2:1:::1:0:", -- Eschewal Greaves
	[11873]=":9662:4:2:1:::1:0:", -- Ethereal Mist Cape
	[11874]=":12124:4:2:1:::1:0:", -- Clouddrift Mantle
	[11875]=":5776:4:2:1:::1:0:", -- Breezecloud Bracers
	[11876]=":16287:4:2:1:::1:0:", -- Plainstalker Tunic
	[11882]=":20520:4:2:1:::1:0:", -- Outrider Leggings
	[11883]="::15:1:1:::1:0:", -- A Dingy Fanny Pack
	[11884]=":1846:4:2:1:::1:0:", -- Moonlit Amice
	[11885]=":711:12:1:1:::1:0:", -- Shadowforge Torch
	[11886]="::12:1:1:::1:0:", -- Urgent Message
	[11887]=":12:15:1:1:::1:0:", -- Cenarion Circle Cache
	[11888]=":4879:4:2:1:::1:0:", -- Quintis\' Research Gloves
	[11889]=":12830:4:2:1:::1:0:", -- Bark Iron Pauldrons
	[11902]=":34194:2:2:1:::1:0:", -- Linken\'s Sword of Mastery
	[11904]=":13815:4:2:1:::1:0:", -- Spirit of Aquementas
	[11905]=":6203:4:2:1:::1:0:", -- Linken\'s Boomerang
	[11906]=":32723:2:2:1:::1:0:", -- Beastsmasher
	[11907]=":41050:2:2:1:::1:0:", -- Beastslayer
	[11908]=":9887:4:2:1:::1:0:", -- Archaeologist\'s Quarry Boots
	[11909]=":8267:4:2:1:::1:0:", -- Excavator\'s Utility Belt
	[11910]=":21604:4:2:1:::1:0:", -- Bejeweled Legguards
	[11911]=":12392:4:2:1:::1:0:", -- Treetop Leggings
	[11912]="::15:1:1:::1:0:", -- Package of Empty Ooze Containers
	[11913]=":14045:4:2:1:::1:0:", -- Clayridge Helm
	[11914]="::0:1:20:::1:0:", -- Empty Cursed Ooze Jar
	[11915]=":20124:4:2:1:::1:0:", -- Shizzle\'s Drizzle Blocker
	[11916]=":11834:4:2:1:::1:0:", -- Shizzle\'s Muzzle
	[11917]=":6335:4:2:1:::1:0:", -- Shizzle\'s Nozzle Wiper
	[11918]=":9537:4:2:1:::1:0:", -- Grotslab Gloves
	[11919]=":16720:4:2:1:::1:0:", -- Cragplate Greaves
	[11920]=":40732:2:3:1:::1:0:", -- Wraith Scythe
	[11921]=":54167:2:3:1:::1:0:", -- Impervious Giant
	[11922]=":43491:2:3:1:::1:0:", -- Blood-etched Blade
	[11923]=":43649:2:3:1:::1:0:", -- The Hammer of Grace
	[11924]=":20475:4:3:1:::1:0:", -- Robes of the Royal Crown
	[11925]=":16484:4:3:1:::1:0:", -- Ghostshroud
	[11926]=":24590:4:3:1:::1:0:", -- Deathdealer Breastplate
	[11927]=":28799:4:3:1:::1:0:", -- Legplates of the Eternal Guardian
	[11928]=":22045:4:3:1:::1:0:", -- Thaurissan\'s Royal Scepter
	[11929]=":16581:4:3:1:::1:0:", -- Haunting Specter Leggings
	[11930]=":14588:4:3:1:::1:0:", -- The Emperor\'s New Cape
	[11931]=":58103:2:3:1:::1:0:", -- Dreadforge Retaliator
	[11932]=":58322:2:3:1:::1:0:", -- Guiding Stave of Wisdom
	[11933]=":19646:4:3:1:::1:0:", -- Imperial Jewel
	[11934]=":19921:4:3:1:::1:0:", -- Emperor\'s Seal
	[11935]=":13162:4:3:1:::1:0:", -- Magmus Stone
	[11936]=":284:4:2:1:::1:0:", -- Relic Hunter Belt
	[11937]=":187:15:1:1:::1:0:", -- Fat Sack of Coins
	[11938]=":213:15:1:1:::1:0:", -- Sack of Gems
	[11939]=":671:15:0:20:::1:0:", -- Shiny Bracelet
	[11940]=":389:15:0:20:::1:0:", -- Sparkly Necklace
	[11941]=":5896:15:0:10:::1:0:", -- False Documents
	[11942]=":5303:15:0:10:::1:0:", -- Legal Documents
	[11943]=":21485:15:0:1:::1:0:", -- Deed to Thandol Span
	[11944]=":8821:15:0:1:::1:0:", -- Dark Iron Baby Booties
	[11945]=":6592:4:3:1:::1:0:", -- Dark Iron Ring
	[11946]=":7912:4:3:1:::1:0:", -- Fire Opal Necklace
	[11947]="::12:1:20:::1:0:", -- Filled Cursed Ooze Jar
	[11948]="::0:1:20:::1:0:", -- Empty Tainted Ooze Jar
	[11949]="::12:1:20:::1:0:", -- Filled Tainted Ooze Jar
	[11950]="::0:1:20:::1:0:", -- Windblossom Berries
	[11951]="::0:1:20:::1:0:", -- Whipper Root Tuber
	[11952]="::0:1:20:::1:0:", -- Night Dragon\'s Breath
	[11953]="::0:1:20:::1:0:", -- Empty Pure Sample Jar
	[11954]="::12:1:20:::1:0:", -- Filled Pure Sample Jar
	[11955]="::15:1:1:::1:0:", -- Bag of Empty Ooze Containers
	[11962]=":7939:4:3:1:::1:0:", -- Manacle Cuffs
	[11963]=":10025:4:2:1:::1:0:", -- Penance Spaulders
	[11964]=":30156:2:2:1:::1:0:", -- Swiftstrike Cudgel
	[11965]=":464:4:2:1:::1:0:", -- Quartz Ring
	[11966]=":164:15:1:1:::1:0:", -- Small Sack of Coins
	[11967]=":1087:4:2:1:::1:0:", -- Zircon Band
	[11968]=":997:4:2:1:::1:0:", -- Amber Hoop
	[11969]=":1721:4:2:1:::1:0:", -- Jacinth Circle
	[11970]=":1710:4:2:1:::1:0:", -- Spinel Ring
	[11971]=":3969:4:2:1:::1:0:", -- Amethyst Band
	[11972]=":4649:4:2:1:::1:0:", -- Carnelian Loop
	[11973]=":3971:4:2:1:::1:0:", -- Hematite Link
	[11974]=":4971:4:2:1:::1:0:", -- Aquamarine Ring
	[11975]=":4739:4:2:1:::1:0:", -- Topaz Ring
	[11976]=":7778:4:2:1:::1:0:", -- Sardonyx Knuckle
	[11977]=":7896:4:2:1:::1:0:", -- Serpentine Loop
	[11978]=":7414:4:2:1:::1:0:", -- Jasper Link
	[11979]=":7471:4:2:1:::1:0:", -- Peridot Circle
	[11980]=":10539:4:2:1:::1:0:", -- Opal Ring
	[11981]=":496:4:2:1:::1:0:", -- Lead Band
	[11982]=":1062:4:2:1:::1:0:", -- Viridian Band
	[11983]=":1130:4:2:1:::1:0:", -- Chrome Ring
	[11984]=":2189:4:2:1:::1:0:", -- Cobalt Ring
	[11985]=":2144:4:2:1:::1:0:", -- Cerulean Ring
	[11986]=":1745:4:2:1:::1:0:", -- Thallium Hoop
	[11987]=":2885:4:2:1:::1:0:", -- Iridium Circle
	[11988]=":7113:4:2:1:::1:0:", -- Tellurium Band
	[11989]=":7471:4:2:1:::1:0:", -- Vanadium Loop
	[11990]=":8306:4:2:1:::1:0:", -- Selenium Loop
	[11991]=":6317:4:2:1:::1:0:", -- Quicksilver Ring
	[11992]=":7396:4:2:1:::1:0:", -- Vermilion Band
	[11993]=":874:4:2:1:::1:0:", -- Clay Ring
	[11994]=":1312:4:2:1:::1:0:", -- Coral Band
	[11995]=":914:4:2:1:::1:0:", -- Ivory Band
	[11996]=":1713:4:2:1:::1:0:", -- Basalt Ring
	[11997]=":6469:4:2:1:::1:0:", -- Greenstone Circle
	[11998]=":2896:4:2:1:::1:0:", -- Jet Loop
	[11999]=":5538:4:2:1:::1:0:", -- Lodestone Hoop
	[12000]=":41054:2:2:1:::1:0:", -- Limb Cleaver
	[12001]=":4971:4:2:1:::1:0:", -- Onyx Ring
	[12002]=":6322:4:2:1:::1:0:", -- Marble Circle
	[12003]=":250:0:1:20:::1:0:", -- Dark Dwarven Lager
	[12004]=":9163:4:2:1:::1:0:", -- Obsidian Band
	[12005]=":8813:4:2:1:::1:0:", -- Granite Ring
	[12006]=":1064:4:2:1:::1:0:", -- Meadow Ring
	[12007]=":1064:4:2:1:::1:0:", -- Prairie Ring
	[12008]=":895:4:2:1:::1:0:", -- Savannah Ring
	[12009]=":2174:4:2:1:::1:0:", -- Tundra Ring
	[12010]=":2469:4:2:1:::1:0:", -- Fen Ring
	[12011]=":4649:4:2:1:::1:0:", -- Forest Hoop
	[12012]=":2463:4:2:1:::1:0:", -- Marsh Ring
	[12013]=":4649:4:2:1:::1:0:", -- Desert Ring
	[12014]=":6289:4:2:1:::1:0:", -- Arctic Ring
	[12015]=":8811:4:2:1:::1:0:", -- Swamp Ring
	[12016]=":7781:4:2:1:::1:0:", -- Jungle Ring
	[12017]=":8963:4:2:1:::1:0:", -- Prismatic Band
	[12018]=":13842:4:2:1:::1:0:", -- Conservator Helm
	[12019]=":4220:4:2:1:::1:0:", -- Cerulean Talisman
	[12020]=":3969:4:2:1:::1:0:", -- Thallium Choker
	[12021]=":16291:4:2:1:::1:0:", -- Shieldplate Sabatons
	[12022]=":4718:4:2:1:::1:0:", -- Iridium Chain
	[12023]=":4971:4:2:1:::1:0:", -- Tellurium Necklace
	[12024]=":5396:4:2:1:::1:0:", -- Vanadium Talisman
	[12025]=":5282:4:2:1:::1:0:", -- Selenium Chain
	[12026]=":7757:4:2:1:::1:0:", -- Quicksilver Pendant
	[12027]=":6257:4:2:1:::1:0:", -- Vermilion Necklace
	[12028]=":4007:4:2:1:::1:0:", -- Basalt Necklace
	[12029]=":5395:4:2:1:::1:0:", -- Greenstone Talisman
	[12030]=":7143:4:2:1:::1:0:", -- Jet Chain
	[12031]=":7894:4:2:1:::1:0:", -- Lodestone Necklace
	[12032]=":5396:4:2:1:::1:0:", -- Onyx Choker
	[12033]="::15:1:1:::1:0:", -- Thaurissan Family Jewels
	[12034]=":5012:4:2:1:::1:0:", -- Marble Necklace
	[12035]=":5513:4:2:1:::1:0:", -- Obsidian Pendant
	[12036]=":5982:4:2:1:::1:0:", -- Granite Necklace
	[12037]=":87:7:1:10::185:1:0:", -- Mystery Meat
	[12038]=":9092:4:2:1:::1:0:", -- Lagrave\'s Seal
	[12039]=":4224:4:2:1:::1:0:", -- Tundra Necklace
	[12040]=":4164:4:2:1:::1:0:", -- Forest Pendant
	[12041]=":14446:4:2:1:::1:0:", -- Windshear Leggings
	[12042]=":4749:4:2:1:::1:0:", -- Marsh Chain
	[12043]=":5396:4:2:1:::1:0:", -- Desert Choker
	[12044]=":5145:4:2:1:::1:0:", -- Arctic Pendant
	[12045]=":7767:4:2:1:::1:0:", -- Swamp Pendant
	[12046]=":5757:4:2:1:::1:0:", -- Jungle Necklace
	[12047]=":4996:4:2:1:::1:0:", -- Spectral Necklace
	[12048]=":6507:4:2:1:::1:0:", -- Prismatic Pendant
	[12049]=":16850:4:2:1:::1:0:", -- Splintsteel Armor
	[12050]=":8963:4:2:1:::1:0:", -- Hazecover Boots
	[12051]=":8996:4:2:1:::1:0:", -- Brazen Gauntlets
	[12052]=":837:4:2:1:::1:0:", -- Ring of the Moon
	[12053]=":837:4:2:1:::1:0:", -- Volcanic Rock Ring
	[12054]=":837:4:2:1:::1:0:", -- Demon Band
	[12055]=":8375:4:2:1:::1:0:", -- Stardust Band
	[12056]=":8375:4:2:1:::1:0:", -- Ring of the Heavens
	[12057]=":8375:4:2:1:::1:0:", -- Dragonscale Band
	[12058]=":8376:4:2:1:::1:0:", -- Demonic Bone Ring
	[12059]=":12377:4:3:1:::1:0:", -- Conqueror\'s Medallion
	[12060]="::12:1:1:::1:0:", -- Shindrell\'s Note
	[12061]=":40212:2:2:1:::1:0:", -- Blade of Reckoning
	[12062]=":40365:2:2:1:::1:0:", -- Skilled Fighting Blade
	[12065]=":7953:4:2:1:::1:0:", -- Ward of the Elements
	[12066]=":11149:4:2:1:::1:0:", -- Shaleskin Cape
	[12082]=":13726:4:2:1:::1:0:", -- Wyrmhide Spaulders
	[12083]=":7348:4:2:1:::1:0:", -- Valconian Sash
	[12102]=":9042:4:2:1:::1:0:", -- Ring of the Aristocrat
	[12103]=":12157:4:3:1:::1:0:", -- Star of Mystaria
	[12108]=":23055:4:2:1:::1:0:", -- Basaltscale Armor
	[12109]=":11569:4:2:1:::1:0:", -- Azure Moon Amice
	[12110]=":11610:4:2:1:::1:0:", -- Raincaster Drape
	[12111]=":13672:4:2:1:::1:0:", -- Lavaplate Gauntlets
	[12112]=":10407:4:2:1:::1:0:", -- Crypt Demon Bracers
	[12113]=":10444:4:2:1:::1:0:", -- Sunborne Cape
	[12114]=":8734:4:2:1:::1:0:", -- Nightfall Gloves
	[12115]=":12341:4:2:1:::1:0:", -- Stalwart Clutch
	[12122]="::15:2:1:::1:0:", -- Kum\'isha\'s Junk
	[12144]="::15:1:1:::1:0:", -- Eggscilloscope
	[12162]="3000:750:9:1:1:::1:0:5512,3356,2843", -- Plans: Hardened Iron Shortsword
	[12163]="4400:1100:9:1:1:::1:0:2482", -- Plans: Moonsteel Broadsword
	[12164]="4400:1100:9:1:1:::1:0:1146,2483", -- Plans: Massive Iron Axe
	[12184]=":87:7:1:10::185:1:0:", -- Raptor Flesh
	[12185]=":12895:4:2:1:::1:0:", -- Bloodsail Admiral\'s Hat
	[12190]=":250:0:1:5:::1:0:", -- Dreamless Sleep Potion
	[12191]="::12:1:1:::1:0:", -- Silver Dawning\'s Lockbox
	[12192]="::12:1:1:::1:0:", -- Mist Veil\'s Lockbox
	[12202]=":87:7:1:10::185:1:0:", -- Tiger Meat
	[12203]=":87:7:1:10::185:1:0:", -- Red Wolf Meat
	[12204]=":112:7:1:10::185:1:0:", -- Heavy Kodo Meat
	[12205]=":112:7:1:10::185:1:0:", -- White Spider Meat
	[12206]=":112:7:1:10::185:1:0:", -- Tender Crab Meat
	[12207]=":150:7:1:10::185:1:0:", -- Giant Egg
	[12208]=":150:7:1:10::185:1:0:", -- Tender Wolf Meat
	[12209]=":95:0:1:20:::1:0:", -- Lean Wolf Steak
	[12210]=":300:0:1:20:::1:0:", -- Roast Raptor
	[12212]=":300:0:1:20:::1:0:", -- Jungle Stew
	[12213]=":300:0:1:20:::1:0:", -- Carrion Surprise
	[12214]=":300:0:1:20:::1:0:", -- Mystery Stew
	[12215]=":300:0:1:20:::1:0:", -- Heavy Kodo Stew
	[12216]=":300:0:1:20:::1:0:", -- Spiced Chili Crab
	[12217]=":300:0:1:20:::1:0:", -- Dragonbreath Chili
	[12218]=":300:0:1:20:::1:0:", -- Monster Omelet
	[12219]="::12:1:1:::1:0:", -- Unadorned Seal of Ascension
	[12220]="::12:1:20:::1:0:", -- Intact Elemental Bracer
	[12223]=":4:7:1:10::185:1:0:", -- Meaty Bat Wing
	[12224]=":10:0:1:20:::1:0:", -- Crispy Bat Wing
	[12225]=":188:2:1:1:::1:0:", -- Blump Family Fishing Pole
	[12226]="25:6:9:1:1:::1:0:2118", -- Recipe: Crispy Bat Wing
	[12227]="1600:400:9:1:1:::1:0:12246", -- Recipe: Lean Wolf Steak
	[12228]="5000:1250:9:1:1:::1:0:2821,4879,2810,1148,12245,734,4897", -- Recipe: Roast Raptor
	[12229]="5000:1250:9:1:1:::1:0:12246,8145,7947", -- Recipe: Hot Wolf Ribs
	[12230]="::12:1:20:::1:0:", -- Felwood Slime Sample
	[12231]="3000:750:9:1:1:::1:0:1148,12245,734", -- Recipe: Jungle Stew
	[12232]="5000:1250:9:1:1:::1:0:4879,9636,989,12245", -- Recipe: Carrion Surprise
	[12233]="3000:750:9:1:1:::1:0:12246,8150,4897", -- Recipe: Mystery Stew
	[12234]="::12:1:20:::1:0:", -- Corrupted Felwood Sample
	[12235]="::12:1:20:::1:0:", -- Un\'Goro Slime Sample
	[12236]="::12:1:20:::1:0:", -- Pure Un\'Goro Sample
	[12237]="::12:1:20:::1:0:", -- Fine Crab Chunks
	[12238]=":2:0:1:20:::1:0:", -- Darkshore Grouper
	[12239]="7000:1750:9:1:1:::1:0:12246,4879,4897", -- Recipe: Dragonbreath Chili
	[12240]="7000:1750:9:1:1:::1:0:9636,8150,12245", -- Recipe: Heavy Kodo Stew
	[12241]="::12:1:20:::1:0:", -- Collected Dragon Egg
	[12242]="::12:1:1:::1:0:", -- Sea Creature Bones
	[12243]=":45980:2:3:1:::1:0:", -- Smoldering Claw
	[12247]="28373:5674:2:2:1:::1:0:3539,225,4235", -- Broad Bladed Knife
	[12248]="32030:6406:2:2:1:::1:0:4888,1146,14846,2843", -- Daring Dirk
	[12249]="30195:6039:2:2:1:::1:0:12045,3539,225,4232,3019", -- Merciless Axe
	[12250]="40342:8068:2:2:1:::1:0:12045,4888,4884,1146,2483", -- Midnight Axe
	[12251]="53897:10779:2:2:1:::1:0:4884,2482,19043,14846", -- Big Stick
	[12252]="63095:12619:2:2:1:::1:0:19238,2482", -- Staff of Protection
	[12253]="17728:3545:4:2:1:::1:0:11874,8159", -- Brilliant Red Cloak
	[12254]="22416:4483:4:2:1:::1:0:11874,12023,8159", -- Well Oiled Cloak
	[12255]="34988:6997:4:2:1:::1:0:3315,984", -- Pale Leggings
	[12256]="43828:8765:4:2:1:::1:0:4175,984,3316", -- Cindercloth Leggings
	[12257]="19430:3886:4:2:1:::1:0:2845", -- Heavy Notched Belt
	[12259]=":8072:2:2:1:::1:0:", -- Glinting Steel Dagger
	[12260]=":10395:2:2:1:::1:0:", -- Searing Golden Blade
	[12261]=":950:9:2:1:::1:0:", -- Plans: Searing Golden Blade
	[12262]="::12:1:1:::1:0:", -- Empty Worg Pup Cage
	[12263]="::12:1:1:::1:0:", -- Caged Worg Pup
	[12264]=":1500:15:1:1:::1:0:", -- Worg Carrier
	[12282]=":8:2:1:1:::1:0:", -- Worn Battleaxe
	[12283]="::12:1:20:::1:0:", -- Broodling Essence
	[12284]="::12:1:1:::1:0:", -- Draco-Incarcinatrix 900
	[12286]="::12:1:1:::1:0:", -- Eggscilloscope Prototype
	[12287]="::12:1:1:::1:0:", -- Collectronic Module
	[12288]="::12:1:1:::1:0:", -- Encased Corrupt Ooze
	[12289]="::12:1:1:::1:0:", -- Sea Turtle Remains
	[12291]="::12:1:1:::1:0:", -- Merged Ooze Sample
	[12292]="::12:1:1:::1:0:", -- Strangely Marked Box
	[12293]="::12:1:1:::1:0:", -- Fine Gold Thread
	[12295]=":282:4:2:1:::1:0:", -- Leggings of the People\'s Militia
	[12296]=":722:2:2:1:::1:0:", -- Spark of the People\'s Militia
	[12299]=":16:4:1:1:::1:0:", -- Netted Gloves
	[12300]="::12:1:1:::1:0:", -- Orb of Draconic Energy
	[12301]="::13:1:1:::1:0:", -- Bamboo Cage Key
	[12302]="::15:4:1:::1:0:", -- Reins of the Frostsaber
	[12303]="::15:4:1:::1:0:", -- Reins of the Nightsaber
	[12323]="::12:1:1:::1:0:", -- Unforged Seal of Ascension
	[12324]="::12:1:1:::1:0:", -- Forged Seal of Ascension
	[12330]="::15:4:1:::1:0:", -- Horn of the Red Wolf
	[12334]="::12:1:20:::1:0:", -- Frostmaul Shards
	[12335]="::12:2:1:::1:0:", -- Gemstone of Smolderthorn
	[12336]="::12:2:1:::1:0:", -- Gemstone of Spirestone
	[12337]="::12:2:1:::1:0:", -- Gemstone of Bloodaxe
	[12339]="::12:1:1:::1:0:", -- Vaelan\'s Gift
	[12341]="::12:1:1:::1:0:", -- Blackwood Fruit Sample
	[12342]="::12:1:1:::1:0:", -- Blackwood Grain Sample
	[12343]="::12:1:1:::1:0:", -- Blackwood Nut Sample
	[12344]="::4:3:1:::1:0:", -- Seal of Ascension
	[12345]="::12:1:1:::1:0:", -- Bijou\'s Belongings
	[12346]="::12:1:1:::1:0:", -- Empty Cleansing Bowl
	[12347]="::12:1:1:::1:0:", -- Filled Cleansing Bowl
	[12349]="::12:1:1:::1:0:", -- Cliffspring River Sample
	[12350]="::12:1:1:::1:0:", -- Empty Sampling Tube
	[12351]="::15:4:1:::1:0:", -- Horn of the Arctic Wolf
	[12352]="::12:1:1:::1:0:", -- Doomrigger\'s Clasp
	[12353]="::15:4:1:::1:0:", -- White Stallion Bridle
	[12354]="::15:4:1:::1:0:", -- Palomino Bridle
	[12355]="::12:1:1:::1:0:", -- Talisman of Corruption
	[12356]="::12:1:20:::1:0:", -- Highperch Wyvern Egg
	[12358]="::12:1:1:::1:0:", -- Darkstone Tablet
	[12359]=":600:7:1:20::171,164,333,202,755:1:0:", -- Thorium Bar
	[12360]=":5000:7:2:20::164,202,755,186,197:1:0:", -- Arcanite Bar
	[12361]=":7000:3:2:20::164,202,755:1:0:", -- Blue Sapphire
	[12363]=":2000:3:2:20::171,755:1:0:", -- Arcane Crystal
	[12364]=":10000:3:2:20::164,202,755,197:1:0:", -- Huge Emerald
	[12365]=":250:7:1:20::164,202,755:1:0:", -- Dense Stone
	[12366]="::12:1:20:::1:0:", -- Thick Yeti Fur
	[12367]="::12:1:20:::1:0:", -- Pristine Yeti Horn
	[12368]="::12:1:1:::1:0:", -- Dawn\'s Gambit
	[12382]="::13:2:1:::1:0:", -- Key to the City
	[12383]="::12:1:20:::1:0:", -- Moontouched Feather
	[12384]="::12:1:1:::1:0:", -- Cache of Mau\'ari
	[12402]="::12:1:1:::1:0:", -- Ancient Egg
	[12404]=":75:0:1:20:::1:0:", -- Dense Sharpening Stone
	[12405]=":16170:4:2:1:::1:0:", -- Thorium Armor
	[12406]=":8160:4:2:1:::1:0:", -- Thorium Belt
	[12408]=":8797:4:2:1:::1:0:", -- Thorium Bracers
	[12409]=":18054:4:2:1:::1:0:", -- Thorium Boots
	[12410]=":18117:4:2:1:::1:0:", -- Thorium Helm
	[12411]="::12:1:1:::1:0:", -- Third Mosh\'aru Tablet
	[12412]="::12:1:1:::1:0:", -- Fourth Mosh\'aru Tablet
	[12414]=":30408:4:2:1:::1:0:", -- Thorium Leggings
	[12415]=":17003:4:2:1:::1:0:", -- Radiant Breastplate
	[12416]=":7596:4:2:1:::1:0:", -- Radiant Belt
	[12417]=":17034:4:2:1:::1:0:", -- Radiant Circlet
	[12418]=":10242:4:2:1:::1:0:", -- Radiant Gloves
	[12419]=":16421:4:2:1:::1:0:", -- Radiant Boots
	[12420]=":24462:4:2:1:::1:0:", -- Radiant Leggings
	[12422]=":28357:4:2:1:::1:0:", -- Imperial Plate Chest
	[12424]=":9738:4:2:1:::1:0:", -- Imperial Plate Belt
	[12425]=":10638:4:2:1:::1:0:", -- Imperial Plate Bracers
	[12426]=":21069:4:2:1:::1:0:", -- Imperial Plate Boots
	[12427]=":21145:4:2:1:::1:0:", -- Imperial Plate Helm
	[12428]=":15103:4:2:1:::1:0:", -- Imperial Plate Shoulders
	[12429]=":30289:4:2:1:::1:0:", -- Imperial Plate Leggings
	[12430]="::12:1:20:::1:0:", -- Frostsaber E\'ko
	[12431]="::12:1:20:::1:0:", -- Winterfall E\'ko
	[12432]="::12:1:20:::1:0:", -- Shardtooth E\'ko
	[12433]="::12:1:20:::1:0:", -- Wildkin E\'ko
	[12434]="::12:1:20:::1:0:", -- Chillwind E\'ko
	[12435]="::12:1:20:::1:0:", -- Ice Thistle E\'ko
	[12436]="::12:1:20:::1:0:", -- Frostmaul E\'ko
	[12437]="::12:1:1:::1:0:", -- Ridgewell\'s Crate
	[12438]="::12:1:1:::1:0:", -- Tinkee\'s Letter
	[12444]="::12:1:20:::1:0:", -- Uncracked Chillwind Horn
	[12445]="::12:1:1:::1:0:", -- Felnok\'s Package
	[12446]=":19:2:1:1:::1:0:", -- Anvilmar Musket
	[12447]=":19:2:1:1:::1:0:", -- Thistlewood Bow
	[12448]=":19:2:1:1:::1:0:", -- Light Hunting Rifle
	[12449]=":19:2:1:1:::1:0:", -- Primitive Bow
	[12450]=":1500:12:1:20:::1:0:", -- Juju Flurry
	[12451]=":1500:12:1:20:::1:0:", -- Juju Power
	[12455]=":1500:12:1:20:::1:0:", -- Juju Ember
	[12457]=":1500:12:1:20:::1:0:", -- Juju Chill
	[12458]=":1500:12:1:20:::1:0:", -- Juju Guile
	[12459]=":1500:12:1:20:::1:0:", -- Juju Escape
	[12460]=":1500:12:1:20:::1:0:", -- Juju Might
	[12462]=":20274:4:4:1:::1:0:", -- Embrace of the Wind Serpent
	[12463]=":42446:2:3:1:::1:0:", -- Drakefang Butcher
	[12464]=":8520:4:3:1:::1:0:", -- Bloodfire Talons
	[12465]=":10261:4:3:1:::1:0:", -- Nightfall Drape
	[12466]=":6865:4:3:1:::1:0:", -- Dawnspire Cord
	[12467]="::12:1:1:::1:0:", -- Alien Egg
	[12470]=":8784:4:3:1:::1:0:", -- Sandstalker Ankleguards
	[12471]=":8409:4:3:1:::1:0:", -- Desertwalker Cane
	[12472]="::12:1:1:::1:0:", -- Krakle\'s Thermometer
	[12522]=":182:4:2:1:::1:0:", -- Bingles\' Flying Gloves
	[12524]="::12:1:1:::1:0:", -- Blue-feathered Amulet
	[12525]="::12:1:1:::1:0:", -- Jaron\'s Supplies
	[12527]=":35332:2:3:1:::1:0:", -- Ribsplitter
	[12528]=":37833:2:3:1:::1:0:", -- The Judge\'s Gavel
	[12529]=":1500:15:1:1:::1:0:", -- Smolderweb Carrier
	[12530]="::12:1:20:::1:0:", -- Spire Spider Egg
	[12531]=":28883:2:3:1:::1:0:", -- Searing Needle
	[12532]=":48501:2:3:1:::1:0:", -- Spire of the Stoneshaper
	[12533]="::15:1:1:::1:0:", -- Roughshod Pike
	[12534]="::12:1:1:::1:0:", -- Omokk\'s Head
	[12535]=":34926:2:3:1:::1:0:", -- Doomforged Straightedge
	[12542]=":12356:4:3:1:::1:0:", -- Funeral Pyre Vestment
	[12543]=":7156:4:3:1:::1:0:", -- Songstone of Ironforge
	[12544]=":7407:4:3:1:::1:0:", -- Thrall\'s Resolve
	[12545]=":7082:4:3:1:::1:0:", -- Eye of Orgrimmar
	[12546]=":7463:4:3:1:::1:0:", -- Aristocratic Cuffs
	[12547]=":10519:4:3:1:::1:0:", -- Mar Alom\'s Grip
	[12548]=":7102:4:3:1:::1:0:", -- Magni\'s Will
	[12549]=":13670:4:3:1:::1:0:", -- Braincage
	[12550]=":11378:4:3:1:::1:0:", -- Runed Golem Shackles
	[12551]=":11594:4:3:1:::1:0:", -- Stoneshield Cloak
	[12552]=":10980:4:3:1:::1:0:", -- Blisterbane Wrap
	[12553]=":17699:4:3:1:::1:0:", -- Swiftwalker Boots
	[12554]=":9474:4:3:1:::1:0:", -- Hands of the Exalted Herald
	[12555]=":19923:4:3:1:::1:0:", -- Battlechaser\'s Greaves
	[12556]=":14317:4:3:1:::1:0:", -- High Priestess Boots
	[12557]=":25096:4:3:1:::1:0:", -- Ebonsteel Spaulders
	[12558]="::12:1:1:::1:0:", -- Blue-feathered Necklace
	[12562]="::12:1:1:::1:0:", -- Important Blackrock Documents
	[12563]="::12:1:1:::1:0:", -- Warlord Goretooth\'s Command
	[12564]="::12:1:1:::1:0:", -- Assassination Note
	[12565]="::15:1:1:::1:0:", -- Winna\'s Kitten Carrier
	[12566]="::12:1:1:::1:0:", -- Hardened Flasket
	[12567]="::12:1:1:::1:0:", -- Filled Flasket
	[12582]=":51199:2:3:1:::1:0:", -- Keris of Zul\'Serak
	[12583]=":66915:2:3:1:::1:0:", -- Blackhand Doomsaw
	[12584]="::2:4:1:::1:0:12784", -- Grand Marshal\'s Longsword
	[12586]="::0:1:50:::1:0:", -- Immature Venom Sac
	[12587]=":18929:4:3:1:::1:0:", -- Eye of Rend
	[12588]=":22903:4:3:1:::1:0:", -- Bonespike Shoulder
	[12589]=":9899:4:3:1:::1:0:", -- Dustfeather Sash
	[12590]=":68066:2:4:1:::1:0:", -- Felstriker
	[12592]=":85722:2:4:1:::1:0:", -- Blackblade of Shahram
	[12602]=":31693:4:3:1:::1:0:", -- Draconian Deflector
	[12603]=":24189:4:3:1:::1:0:", -- Nightbrace Tunic
	[12604]=":14368:4:3:1:::1:0:", -- Starfire Tiara
	[12605]=":29106:2:3:1:::1:0:", -- Serpentine Skuller
	[12606]=":12233:4:3:1:::1:0:", -- Crystallized Girdle
	[12607]=":8048:12:3:20::165:1:0:", -- Brilliant Chromatic Scale
	[12608]=":13232:4:3:1:::1:0:", -- Butcher\'s Apron
	[12609]=":19795:4:3:1:::1:0:", -- Polychromatic Visionwrap
	[12610]=":21392:4:2:1:::1:0:", -- Runic Plate Shoulders
	[12611]=":21473:4:2:1:::1:0:", -- Runic Plate Boots
	[12612]=":21854:4:2:1:::1:0:", -- Runic Plate Helm
	[12613]=":29704:4:2:1:::1:0:", -- Runic Breastplate
	[12614]=":29815:4:2:1:::1:0:", -- Runic Plate Leggings
	[12618]=":37759:4:3:1:::1:0:", -- Enchanted Thorium Breastplate
	[12619]=":37893:4:3:1:::1:0:", -- Enchanted Thorium Leggings
	[12620]=":28084:4:3:1:::1:0:", -- Enchanted Thorium Helm
	[12621]=":45085:2:3:1:::1:0:", -- Demonfork
	[12622]="::12:1:10:::1:0:", -- Shardtooth Meat
	[12623]="::12:1:10:::1:0:", -- Chillwind Meat
	[12624]=":20642:4:3:1:::1:0:", -- Wildthorn Mail
	[12625]=":22847:4:3:1:::1:0:", -- Dawnbringer Shoulders
	[12626]=":9191:4:3:1:::1:0:", -- Funeral Cuffs
	[12627]="::12:1:1:::1:0:", -- Temporal Displacer
	[12628]=":29121:4:3:1:::1:0:", -- Demon Forged Breastplate
	[12630]="::12:1:1:::1:0:", -- Head of Rend Blackhand
	[12631]=":15698:4:3:1:::1:0:", -- Fiery Plate Gauntlets
	[12632]=":14099:4:3:1:::1:0:", -- Storm Gauntlets
	[12633]=":25955:4:3:1:::1:0:", -- Whitesoul Helm
	[12634]=":15310:4:3:1:::1:0:", -- Chiselbrand Girdle
	[12635]="::12:1:1:::1:0:", -- Simple Parchment
	[12636]=":23452:4:3:1:::1:0:", -- Helm of the Great Chief
	[12637]=":18157:4:3:1:::1:0:", -- Backusarian Gauntlets
	[12638]="::12:1:20:::1:0:", -- Andorhal Watch
	[12639]=":25061:4:4:1:::1:0:", -- Stronghold Gauntlets
	[12640]=":36930:4:4:1:::1:0:", -- Lionheart Helm
	[12641]=":39455:4:4:1:::1:0:", -- Invulnerable Mail
	[12642]="::12:1:1:::1:0:", -- Cleansed Infernal Orb
	[12643]=":75:0:1:20:::1:0:", -- Dense Weightstone
	[12644]=":200:7:1:20::164:1:0:", -- Dense Grinding Stone
	[12645]=":500:0:2:5:::1:0:", -- Thorium Shield Spike
	[12646]="::12:1:1:::1:0:", -- Infus Emerald
	[12647]="::12:1:1:::1:0:", -- Felhas Ruby
	[12648]="::12:1:1:::1:0:", -- Imprisoned Felhound Spirit
	[12649]="::12:1:1:::1:0:", -- Imprisoned Infernal Spirit
	[12650]="::0:1:1:::1:0:", -- Attuned Dampener
	[12651]=":36055:2:3:1:::1:0:", -- Blackcrow
	[12652]="::12:1:1:::1:0:", -- Bijou\'s Reconnaissance Report
	[12653]=":36318:2:3:1:::1:0:", -- Riphook
	[12654]=":62:6:3:200:::1:0:", -- Doomshot
	[12655]=":500:7:1:20::164,202:1:0:", -- Enchanted Thorium Bar
	[12662]=":600:7:2:20::164,755,197:1:0:", -- Demonic Rune
	[12663]="::12:1:1:::1:0:", -- Glyphed Oaken Branch
	[12682]=":3000:9:2:1:::1:0:", -- Plans: Thorium Armor
	[12683]=":3000:9:2:1:::1:0:", -- Plans: Thorium Belt
	[12684]=":3000:9:2:1:::1:0:", -- Plans: Thorium Bracers
	[12685]=":3000:9:2:1:::1:0:", -- Plans: Radiant Belt
	[12687]=":3000:9:2:1:::1:0:", -- Plans: Imperial Plate Shoulders
	[12688]=":3000:9:2:1:::1:0:", -- Plans: Imperial Plate Belt
	[12689]=":3500:9:2:1:::1:0:", -- Plans: Radiant Breastplate
	[12690]=":3000:9:2:1:::1:0:", -- Plans: Imperial Plate Bracers
	[12691]=":4000:9:2:1:::1:0:", -- Plans: Wildthorn Mail
	[12692]=":4000:9:2:1:::1:0:", -- Plans: Thorium Shield Spike
	[12693]=":5000:9:2:1:::1:0:", -- Plans: Thorium Boots
	[12694]=":5000:9:2:1:::1:0:", -- Plans: Thorium Helm
	[12695]=":5000:9:2:1:::1:0:", -- Plans: Radiant Gloves
	[12696]=":5000:9:3:1:::1:0:", -- Plans: Demon Forged Breastplate
	[12697]=":5500:9:2:1:::1:0:", -- Plans: Radiant Boots
	[12698]=":5500:9:3:1:::1:0:", -- Plans: Dawnbringer Shoulders
	[12699]=":5000:9:3:1:::1:0:", -- Plans: Fiery Plate Gauntlets
	[12700]=":6250:9:2:1:::1:0:", -- Plans: Imperial Plate Boots
	[12701]=":6250:9:2:1:::1:0:", -- Plans: Imperial Plate Helm
	[12702]=":6250:9:2:1:::1:0:", -- Plans: Radiant Circlet
	[12703]="40000:10000:9:3:1:::1:0:11278", -- Plans: Storm Gauntlets
	[12704]=":7500:9:2:1:::1:0:", -- Plans: Thorium Leggings
	[12705]=":7500:9:2:1:::1:0:", -- Plans: Imperial Plate Chest
	[12706]=":7500:9:2:1:::1:0:", -- Plans: Runic Plate Shoulders
	[12707]=":7500:9:2:1:::1:0:", -- Plans: Runic Plate Boots
	[12708]="::12:1:1:::1:0:", -- Crossroads\' Supply Crates
	[12709]=":52195:2:3:1:::1:0:", -- Finkle\'s Skinner
	[12710]="::12:1:1:::1:0:", -- Glowing Hunk of the Beast\'s Flesh
	[12711]=":10000:9:3:1:::1:0:", -- Plans: Whitesoul Helm
	[12712]="::12:1:1:::1:0:", -- Warosh\'s Mojo
	[12713]=":10000:9:2:1:::1:0:", -- Plans: Radiant Leggings
	[12714]=":10000:9:2:1:::1:0:", -- Plans: Runic Plate Helm
	[12715]=":10000:9:2:1:::1:0:", -- Plans: Imperial Plate Leggings
	[12716]=":15000:9:3:1:::1:0:", -- Plans: Helm of the Great Chief
	[12717]=":15000:9:4:1:::1:0:", -- Plans: Lionheart Helm
	[12718]=":15000:9:2:1:::1:0:", -- Plans: Runic Breastplate
	[12719]=":15000:9:2:1:::1:0:", -- Plans: Runic Plate Leggings
	[12720]=":20000:9:4:1:::1:0:", -- Plans: Stronghold Gauntlets
	[12721]="::12:1:1:::1:0:", -- Good Luck Half-Charm
	[12722]="::12:1:1:::1:0:", -- Good Luck Other-Half-Charm
	[12723]="::12:1:1:::1:0:", -- Good Luck Charm
	[12724]="::12:1:1:::1:0:", -- Janice\'s Parcel
	[12725]=":15000:9:3:1:::1:0:", -- Plans: Enchanted Thorium Helm
	[12726]=":15000:9:3:1:::1:0:", -- Plans: Enchanted Thorium Leggings
	[12727]=":15000:9:3:1:::1:0:", -- Plans: Enchanted Thorium Breastplate
	[12728]=":20000:9:4:1:::1:0:", -- Plans: Invulnerable Mail
	[12730]="::12:1:1:::1:0:", -- Warosh\'s Scroll
	[12731]="::12:4:1:::1:0:", -- Pristine Hide of the Beast
	[12732]="::12:1:20:::1:0:", -- Incendia Agave
	[12733]="::12:1:1:::1:0:", -- Sacred Frostsaber Meat
	[12734]="::12:1:10:::1:0:", -- Enchanted Scarlet Thread
	[12735]="::12:2:20:::1:0:", -- Frayed Abomination Stitching
	[12736]="::12:1:10:::1:0:", -- Frostwhisper\'s Embalming Fluid
	[12737]="::12:1:20:::1:0:", -- Gloom Weed
	[12738]="::13:1:1:::1:0:", -- Dalson Outhouse Key
	[12739]="::13:1:1:::1:0:", -- Dalson Cabinet Key
	[12740]="::12:1:1:::1:0:", -- Fifth Mosh\'aru Tablet
	[12741]="::12:1:1:::1:0:", -- Sixth Mosh\'aru Tablet
	[12752]=":21359:4:4:1:::1:0:", -- Cap of the Scarlet Savant
	[12753]="::12:2:10::164,165:1:0:", -- Skin of Shadow
	[12756]=":32687:4:4:1:::1:0:", -- Leggings of Arcana
	[12757]=":32813:4:4:1:::1:0:", -- Breastplate of Bloodthirst
	[12765]="::12:1:1:::1:0:", -- Secret Note #1
	[12766]="::12:1:1:::1:0:", -- Secret Note #2
	[12768]="::12:1:1:::1:0:", -- Secret Note #3
	[12770]="::12:1:1:::1:0:", -- Bijou\'s Information
	[12771]="::12:1:1:::1:0:", -- Empty Firewater Flask
	[12772]=":38871:2:2:1:::1:0:", -- Inlaid Thorium Hammer
	[12773]=":33080:2:2:1:::1:0:", -- Ornate Thorium Handaxe
	[12774]=":36044:2:3:1:::1:0:", -- Dawn\'s Edge
	[12775]=":39949:2:2:1:::1:0:", -- Huge Thorium Battleaxe
	[12776]=":48125:2:3:1:::1:0:", -- Enchanted Battlehammer
	[12777]=":38648:2:3:1:::1:0:", -- Blazing Rapier
	[12780]="::12:1:1:::1:0:", -- General Drakkisath\'s Command
	[12781]=":42721:2:3:1:::1:0:", -- Serenity
	[12782]=":56808:2:3:1:::1:0:", -- Corruption
	[12783]=":52397:2:3:1:::1:0:", -- Heartseeker
	[12784]=":65736:2:3:1:::1:0:", -- Arcanite Reaper
	[12785]="::12:1:1:::1:0:", -- Incendia Powder
	[12790]=":67161:2:3:1:::1:0:", -- Arcanite Champion
	[12791]=":39411:2:3:1:::1:0:", -- Barman Shanker
	[12792]=":39255:2:2:1:::1:0:", -- Volcanic Hammer
	[12793]=":19846:4:3:1:::1:0:", -- Mixologist\'s Tunic
	[12794]=":50676:2:3:1:::1:0:", -- Masterwork Stormhammer
	[12796]=":63825:2:3:1:::1:0:", -- Hammer of the Titans
	[12797]=":51252:2:3:1:::1:0:", -- Frostguard
	[12798]=":51438:2:3:1:::1:0:", -- Annihilator
	[12799]=":7000:3:2:20::164,202,755:1:0:", -- Large Opal
	[12800]=":10000:3:2:20::164,202,755,197:1:0:", -- Azerothian Diamond
	[12803]=":500:7:2:10::171,164,333,202,755,165,197:1:0:", -- Living Essence
	[12804]=":2000:7:1:20::171,164,202,755,165,197:1:0:", -- Powerful Mojo
	[12806]="::12:3:1:::1:0:", -- Unforged Rune Covered Breastplate
	[12807]="::12:1:1:::1:0:", -- Scourge Banner
	[12808]=":1000:7:2:10::171,164,333,202,755,197:1:0:", -- Essence of Undeath
	[12809]=":10000:7:2:20::164,165,197:1:0:", -- Guardian Stone
	[12810]="2000:500:7:1:20::164,202,165,197:1:0:14846", -- Enchanted Leather
	[12811]=":20000:7:2:20::164,333,197:1:0:", -- Righteous Orb
	[12812]="::12:3:1:::1:0:", -- Unfired Plate Gauntlets
	[12813]="::12:1:1:::1:0:", -- Flask of Mystery Goo
	[12814]="::12:1:1:::1:0:", -- Flame in a Bottle
	[12815]="::12:1:1:::1:0:", -- Beacon Torch
	[12819]="16000:4000:9:2:1:::1:0:11278", -- Plans: Ornate Thorium Handaxe
	[12820]="::0:1:10:::1:0:", -- Winterfall Firewater
	[12821]=":4000:9:3:1:::1:0:", -- Plans: Dawn\'s Edge
	[12822]="::12:1:20:::1:0:", -- Toxic Horror Droplet
	[12823]="20000:5000:9:1:1:::1:0:11278", -- Plans: Huge Thorium Battleaxe
	[12824]=":5000:9:2:1:::1:0:", -- Plans: Enchanted Battlehammer
	[12825]=":5000:9:2:1:::1:0:", -- Plans: Blazing Rapier
	[12827]=":5000:9:2:1:::1:0:", -- Plans: Serenity
	[12828]=":5500:9:2:1:::1:0:", -- Plans: Volcanic Hammer
	[12829]="::12:1:1:::1:0:", -- Winterfall Crate
	[12830]=":5500:9:1:1:::1:0:", -- Plans: Corruption
	[12833]=":20000:9:3:1:::1:0:", -- Plans: Hammer of the Titans
	[12834]=":20000:9:3:1:::1:0:", -- Plans: Arcanite Champion
	[12835]=":20000:9:3:1:::1:0:", -- Plans: Annihilator
	[12836]=":20000:9:3:1:::1:0:", -- Plans: Frostguard
	[12837]=":20000:9:3:1:::1:0:", -- Plans: Masterwork Stormhammer
	[12838]=":20000:9:3:1:::1:0:", -- Plans: Arcanite Reaper
	[12839]=":20000:9:3:1:::1:0:", -- Plans: Heartseeker
	[12840]="::12:1:250:::1:0:", -- Minion\'s Scourgestone
	[12841]="::12:1:250:::1:0:", -- Invader\'s Scourgestone
	[12842]="::12:1:1:::1:0:", -- Crudely-written Log
	[12843]="::12:2:250:::1:0:", -- Corruptor\'s Scourgestone
	[12844]="::12:2:250:::1:0:", -- Argent Dawn Valor Token
	[12845]="::12:1:1:::1:0:", -- Medallion of Faith
	[12846]="::4:1:1:::1:0:", -- Argent Dawn Commission
	[12847]="::12:1:1:::1:0:", -- Soul Stained Pike
	[12848]="::12:1:1:::1:0:", -- Blood Stained Pike
	[12849]="::12:2:1:::1:0:", -- Demon Kissed Sack
	[12871]=":8048:15:4:1:::1:0:", -- Chromatic Carapace
	[12884]="::12:1:1:::1:0:", -- Arnak\'s Hoof
	[12885]="::12:1:1:::1:0:", -- Pamela\'s Doll
	[12886]="::0:1:1:::1:0:", -- Pamela\'s Doll\'s Head
	[12887]="::12:1:1:::1:0:", -- Pamela\'s Doll\'s Left Side
	[12888]="::12:1:1:::1:0:", -- Pamela\'s Doll\'s Right Side
	[12891]="::12:1:1:::1:0:", -- Jaron\'s Pick
	[12894]="::12:1:1:::1:0:", -- Joseph\'s Wedding Ring
	[12895]=":48071:4:4:1:::1:0:", -- Breastplate of the Chromatic Flight
	[12896]="::12:1:1:::1:0:", -- First Relic Fragment
	[12897]="::12:1:1:::1:0:", -- Second Relic Fragment
	[12898]="::12:1:1:::1:0:", -- Third Relic Fragment
	[12899]="::12:1:1:::1:0:", -- Fourth Relic Fragment
	[12900]="::12:1:1:::1:0:", -- Annals of Darrowshire
	[12903]=":42407:4:4:1:::1:0:", -- Legguards of the Chromatic Defier
	[12905]=":15798:4:3:1:::1:0:", -- Wildfire Cape
	[12906]="::12:1:1:::1:0:", -- Purified Moonwell Water
	[12907]="::12:1:1:::1:0:", -- Corrupt Moonwell Water
	[12922]="::0:1:1:::1:0:", -- Empty Canteen
	[12923]="::12:1:1:::1:0:", -- Awbee\'s Scale
	[12924]="::15:1:5:::1:0:", -- Ritual Candle
	[12925]="::12:1:1:::1:0:", -- Arikara Serpent Skin
	[12926]=":14907:4:3:1:::1:0:", -- Flaming Band
	[12927]=":18492:4:3:1:::1:0:", -- Truestrike Shoulders
	[12928]="::12:1:1:::1:0:", -- Umi\'s Mechanical Yeti
	[12929]=":19646:4:3:1:::1:0:", -- Emberfury Talisman
	[12930]=":10000:4:3:1:::1:0:", -- Briarwood Reed
	[12935]=":36536:4:3:1:::1:0:", -- Warmaster Legguards
	[12936]=":18440:4:3:1:::1:0:", -- Battleborn Armbraces
	[12938]="::12:1:20::171,755:1:0:", -- Blood of Heroes
	[12939]=":54330:2:3:1:::1:0:", -- Dal\'Rend\'s Tribal Guardian
	[12940]=":49334:2:3:1:::1:0:", -- Dal\'Rend\'s Sacred Charge
	[12942]="::13:1:1:::1:0:", -- Panther Cage Key
	[12945]=":39686:4:4:1:::1:0:", -- Legplates of the Chromatic Defier
	[12946]="::12:1:1:::1:0:", -- Hypercapacitor Gizmo
	[12952]=":25957:4:3:1:::1:0:", -- Gyth\'s Skull
	[12953]=":22374:4:3:1:::1:0:", -- Dragoneye Coif
	[12954]="::12:1:1:::1:0:", -- Davil\'s Libram
	[12955]="::12:1:1:::1:0:", -- Redpath\'s Shield
	[12956]="::12:1:1:::1:0:", -- Skull of Horgus
	[12957]="::12:1:1:::1:0:", -- Shattered Sword of Marduk
	[12958]="50000:12500:9:1:1:::1:0:5594", -- Recipe: Transmute Arcanite
	[12960]=":17752:4:3:1:::1:0:", -- Tribal War Feathers
	[12963]=":24947:4:3:1:::1:0:", -- Blademaster Leggings
	[12964]=":30051:4:3:1:::1:0:", -- Tristam Legguards
	[12965]=":20111:4:3:1:::1:0:", -- Spiritshroud Leggings
	[12966]=":12617:4:3:1:::1:0:", -- Blackmist Armguards
	[12967]=":15196:4:3:1:::1:0:", -- Bloodmoon Cloak
	[12968]=":15254:4:3:1:::1:0:", -- Frostweaver Cape
	[12969]=":63799:2:3:1:::1:0:", -- Seeping Willow
	[12973]="::15:1:1:::1:0:", -- Scarlet Cannonball
	[12974]=":6105:2:3:1:::1:0:", -- The Black Knight
	[12975]=":2205:2:3:1:::1:0:", -- Prospector Axe
	[12976]=":1770:2:3:1:::1:0:", -- Ironpatch Blade
	[12977]=":355:4:3:1:::1:0:", -- Magefist Gloves
	[12978]=":534:4:3:1:::1:0:", -- Stormbringer Belt
	[12979]=":617:4:3:1:::1:0:", -- Firebane Cloak
	[12982]=":851:4:3:1:::1:0:", -- Silver-linked Footguards
	[12983]=":2362:2:3:1:::1:0:", -- Rakzur Club
	[12984]=":1423:2:3:1:::1:0:", -- Skycaller
	[12985]=":1153:4:3:1:::1:0:", -- Ring of Defense
	[12987]=":906:4:3:1:::1:0:", -- Darkweave Breeches
	[12988]=":1137:4:3:1:::1:0:", -- Starsight Tunic
	[12989]=":2854:2:3:1:::1:0:", -- Gargoyle\'s Bite
	[12990]=":2589:2:3:1:::1:0:", -- Razor\'s Edge
	[12992]=":3260:2:3:1:::1:0:", -- Searing Blade
	[12994]=":788:4:3:1:::1:0:", -- Thorbia\'s Gauntlets
	[12996]=":1527:4:3:1:::1:0:", -- Band of Purification
	[12997]=":1920:4:3:1:::1:0:", -- Redbeard Crest
	[12998]=":1020:4:3:1:::1:0:", -- Magician\'s Mantle
	[12999]=":853:4:3:1:::1:0:", -- Drakewing Bands
	[13000]=":60815:2:3:1:::1:0:", -- Staff of Hale Magefire
	[13001]=":10648:4:3:1:::1:0:", -- Maiden\'s Circle
	[13002]=":14617:4:3:1:::1:0:", -- Lady Alizabeth\'s Pendant
	[13003]=":49640:2:3:1:::1:0:", -- Lord Alexander\'s Battle Axe
	[13004]=":33591:2:3:1:::1:0:", -- Torch of Austen
	[13005]=":1331:4:3:1:::1:0:", -- Amy\'s Blanket
	[13006]=":51132:2:3:1:::1:0:", -- Mass of McGowan
	[13007]=":13585:4:3:1:::1:0:", -- Mageflame Cloak
	[13008]=":12815:4:3:1:::1:0:", -- Dalewind Trousers
	[13009]=":15167:4:3:1:::1:0:", -- Cow King\'s Hide
	[13010]=":2241:4:3:1:::1:0:", -- Dreamsinger Legguards
	[13011]=":1031:4:3:1:::1:0:", -- Silver-lined Belt
	[13012]=":1241:4:3:1:::1:0:", -- Yorgen Bracers
	[13013]=":12355:4:3:1:::1:0:", -- Elder Wizard\'s Mantle
	[13014]=":34705:2:3:1:::1:0:", -- Axe of Rin\'ji
	[13015]=":52106:2:3:1:::1:0:", -- Serathil
	[13016]=":4771:2:3:1:::1:0:", -- Killmaim
	[13017]=":17209:2:3:1:::1:0:", -- Hellslayer Battle Axe
	[13018]=":31967:2:3:1:::1:0:", -- Executioner\'s Cleaver
	[13019]=":4765:2:3:1:::1:0:", -- Harpyclaw Short Bow
	[13020]=":8985:2:3:1:::1:0:", -- Skystriker Bow
	[13021]=":16694:2:3:1:::1:0:", -- Needle Threader
	[13022]=":27990:2:3:1:::1:0:", -- Gryphonwing Long Bow
	[13023]=":38435:2:3:1:::1:0:", -- Eaglehorn Long Bow
	[13024]=":4863:2:3:1:::1:0:", -- Beazel\'s Basher
	[13025]=":10464:2:3:1:::1:0:", -- Deadwood Sledge
	[13026]=":19441:2:3:1:::1:0:", -- Heaven\'s Light
	[13027]=":33832:2:3:1:::1:0:", -- Bonesnapper
	[13028]=":50800:2:3:1:::1:0:", -- Bludstone Hammer
	[13029]=":5613:4:3:1:::1:0:", -- Umbral Crystal
	[13030]=":13113:4:3:1:::1:0:", -- Basilisk Bone
	[13031]=":1401:4:3:1:::1:0:", -- Orb of Mistmantle
	[13032]=":4138:2:3:1:::1:0:", -- Sword of Corruption
	[13033]=":8094:2:3:1:::1:0:", -- Zealot Blade
	[13034]=":14710:2:3:1:::1:0:", -- Speedsteel Rapier
	[13035]=":25141:2:3:1:::1:0:", -- Serpent Slicer
	[13036]=":40988:2:3:1:::1:0:", -- Assassination Blade
	[13037]=":4729:2:3:1:::1:0:", -- Crystalpine Stinger
	[13038]=":9630:2:3:1:::1:0:", -- Swiftwind
	[13039]=":17892:2:3:1:::1:0:", -- Skull Splitting Crossbow
	[13040]=":29444:2:3:1:::1:0:", -- Heartseeking Crossbow
	[13041]=":4516:2:3:1:::1:0:", -- Guardian Blade
	[13042]=":17596:2:3:1:::1:0:", -- Sword of the Magistrate
	[13043]=":32389:2:3:1:::1:0:", -- Blade of the Titans
	[13044]=":52800:2:3:1:::1:0:", -- Demonslayer
	[13045]=":10809:2:3:1:::1:0:", -- Viscous Hammer
	[13046]=":35042:2:3:1:::1:0:", -- Blanchard\'s Stout
	[13047]=":56588:2:3:1:::1:0:", -- Twig of the World Tree
	[13048]=":5971:2:3:1:::1:0:", -- Looming Gavel
	[13049]=":6191:2:3:1:::1:0:", -- Deanship Claymore
	[13051]=":22911:2:3:1:::1:0:", -- Witchfury
	[13052]=":41677:2:3:1:::1:0:", -- Warmonger
	[13053]=":59186:2:3:1:::1:0:", -- Doombringer
	[13054]=":15805:2:3:1:::1:0:", -- Grim Reaper
	[13055]=":29367:2:3:1:::1:0:", -- Bonechewer
	[13056]=":48330:2:3:1:::1:0:", -- Frenzied Striker
	[13057]=":5382:2:3:1:::1:0:", -- Bloodpike
	[13058]=":21833:2:3:1:::1:0:", -- Khoo\'s Point
	[13059]=":38719:2:3:1:::1:0:", -- Stoneraven
	[13060]=":60784:2:3:1:::1:0:", -- The Needler
	[13062]=":2991:2:3:1:::1:0:", -- Thunderwood
	[13063]=":5851:2:3:1:::1:0:", -- Starfaller
	[13064]=":11487:2:3:1:::1:0:", -- Jaina\'s Firestarter
	[13065]=":20945:2:3:1:::1:0:", -- Wand of Allistarj
	[13066]=":15716:4:3:1:::1:0:", -- Wyrmslayer Spaulders
	[13067]=":25098:4:3:1:::1:0:", -- Hydralick Armor
	[13068]=":8358:4:3:1:::1:0:", -- Obsidian Greaves
	[13070]=":24606:4:3:1:::1:0:", -- Sapphiron\'s Scale Boots
	[13071]=":7148:4:3:1:::1:0:", -- Plated Fist of Hakoo
	[13072]=":18351:4:3:1:::1:0:", -- Stonegrip Gauntlets
	[13073]=":15861:4:3:1:::1:0:", -- Mugthol\'s Helm
	[13074]=":14043:4:3:1:::1:0:", -- Golem Shard Leggings
	[13075]=":34795:4:3:1:::1:0:", -- Direwing Legguards
	[13076]=":8300:4:3:1:::1:0:", -- Giantslayer Bracers
	[13077]=":14478:4:3:1:::1:0:", -- Girdle of Uther
	[13079]=":3359:4:3:1:::1:0:", -- Shield of Thorsen
	[13081]=":7123:4:3:1:::1:0:", -- Skullance Shield
	[13082]=":13235:4:3:1:::1:0:", -- Mountainside Buckler
	[13083]=":32348:4:3:1:::1:0:", -- Garrett Family Crest
	[13084]=":6614:4:3:1:::1:0:", -- Kaleidoscope Chain
	[13085]=":9137:4:3:1:::1:0:", -- Horizon Choker
	[13086]="1000000::15:4:1:::1:0:10618", -- Reins of the Winterspring Frostsaber
	[13087]=":5896:4:3:1:::1:0:", -- River Pride Choker
	[13088]=":7413:4:3:1:::1:0:", -- Gazlowe\'s Charm
	[13089]=":8039:4:3:1:::1:0:", -- Skibi\'s Pendant
	[13091]=":10637:4:3:1:::1:0:", -- Medallion of Grand Marshal Morris
	[13093]=":3381:4:3:1:::1:0:", -- Blush Ember Ring
	[13094]=":2646:4:3:1:::1:0:", -- The Queen\'s Jewel
	[13095]=":6646:4:3:1:::1:0:", -- Assault Band
	[13096]=":7913:4:3:1:::1:0:", -- Band of the Hierophant
	[13097]=":2164:4:3:1:::1:0:", -- Thunderbrow Ring
	[13098]=":15282:4:3:1:::1:0:", -- Painweaver Band
	[13099]=":1431:4:3:1:::1:0:", -- Moccasins of the White Hare
	[13100]=":5421:4:3:1:::1:0:", -- Furen\'s Boots
	[13101]=":14318:4:3:1:::1:0:", -- Wolfrunner Shoes
	[13102]=":6879:4:3:1:::1:0:", -- Cassandra\'s Grace
	[13103]=":3453:4:3:1:::1:0:", -- Pads of the Venom Spider
	[13105]=":2147:4:3:1:::1:0:", -- Sutarn\'s Ring
	[13106]=":1216:4:3:1:::1:0:", -- Glowing Magical Bracelets
	[13107]=":10528:4:3:1:::1:0:", -- Magiskull Cuffs
	[13108]=":2446:4:3:1:::1:0:", -- Tigerstrike Mantle
	[13109]=":8152:4:3:1:::1:0:", -- Blackflame Cape
	[13110]=":4968:4:3:1:::1:0:", -- Wolffear Harness
	[13111]=":13993:4:3:1:::1:0:", -- Sandals of the Insurgent
	[13112]=":9625:4:3:1:::1:0:", -- Winged Helm
	[13113]=":18492:4:3:1:::1:0:", -- Feathermoon Headdress
	[13114]=":2574:4:3:1:::1:0:", -- Troll\'s Bane Leggings
	[13115]=":6991:4:3:1:::1:0:", -- Sheepshear Mantle
	[13116]=":18705:4:3:1:::1:0:", -- Spaulders of the Unseen
	[13117]=":3830:4:3:1:::1:0:", -- Ogron\'s Sash
	[13118]=":10601:4:3:1:::1:0:", -- Serpentine Sash
	[13119]=":3063:4:3:1:::1:0:", -- Enchanted Kodo Bracers
	[13120]=":9505:4:3:1:::1:0:", -- Deepfury Bracers
	[13121]=":3428:4:3:1:::1:0:", -- Wing of the Whelpling
	[13122]=":11489:4:3:1:::1:0:", -- Dark Phantom Cape
	[13123]=":31130:4:3:1:::1:0:", -- Dreamwalker Armor
	[13124]=":3996:4:3:1:::1:0:", -- Ravasaur Scale Boots
	[13125]=":12954:4:3:1:::1:0:", -- Elven Chain Boots
	[13126]=":10374:4:3:1:::1:0:", -- Battlecaller Gauntlets
	[13127]=":3021:4:3:1:::1:0:", -- Frostreaver Crown
	[13128]=":10543:4:3:1:::1:0:", -- High Bergg Helm
	[13129]=":7621:4:3:1:::1:0:", -- Firemane Leggings
	[13130]=":25065:4:3:1:::1:0:", -- Windrunner Legguards
	[13131]=":2312:4:3:1:::1:0:", -- Sparkleshell Mantle
	[13132]=":7340:4:3:1:::1:0:", -- Skeletal Shoulders
	[13133]=":22291:4:3:1:::1:0:", -- Drakesfire Epaulets
	[13134]=":7716:4:3:1:::1:0:", -- Belt of the Gladiator
	[13135]=":14001:4:3:1:::1:0:", -- Lordly Armguards
	[13136]=":1456:2:3:1:::1:0:", -- Lil Timmy\'s Peashooter
	[13137]=":5874:2:3:1:::1:0:", -- Ironweaver
	[13138]=":11532:2:3:1:::1:0:", -- The Silencer
	[13139]=":21029:2:3:1:::1:0:", -- Guttbuster
	[13140]="::13:1:1:::1:0:", -- Blood Red Key
	[13141]=":12093:4:3:1:::1:0:", -- Tooth of Gnarr
	[13142]=":18442:4:3:1:::1:0:", -- Brigam Girdle
	[13143]=":21372:4:4:1:::1:0:", -- Mark of the Dragon Lord
	[13144]=":6865:4:3:1:::1:0:", -- Serenity Belt
	[13145]=":4760:4:3:1:::1:0:", -- Enormous Ogre Belt
	[13146]=":34704:2:3:1:::1:0:", -- Shell Launcher Shotgun
	[13148]=":60480:2:3:1:::1:0:", -- Chillpike
	[13155]="::12:1:20:::1:0:", -- Resonating Skull
	[13156]="::0:1:1:::1:0:", -- Mystic Crystal
	[13157]="::12:1:20:::1:0:", -- Fetid Skull
	[13158]="::12:1:1:::1:0:", -- Words of the High Chief
	[13159]="::12:1:20:::1:0:", -- Bone Dust
	[13161]=":63494:2:3:1:::1:0:", -- Trindlehaven Staff
	[13162]=":17945:4:3:1:::1:0:", -- Reiver Claws
	[13163]=":64835:2:3:1:::1:0:", -- Relentless Scythe
	[13164]=":10539:4:3:1:::1:0:", -- Heart of the Scale
	[13166]=":24811:4:3:1:::1:0:", -- Slamshot Shoulders
	[13167]=":59410:2:3:1:::1:0:", -- Fist of Omokk
	[13168]=":33398:4:3:1:::1:0:", -- Plate of the Shaman King
	[13169]=":23948:4:3:1:::1:0:", -- Tressermane Leggings
	[13170]=":19230:4:3:1:::1:0:", -- Skyshroud Leggings
	[13171]=":7000:4:2:1:::1:0:", -- Smokey\'s Lighter
	[13172]="::12:1:1:::1:0:", -- Siabi\'s Premium Tobacco
	[13173]=":11:15:3:200:::1:0:", -- Broken Flightblade Throwing Axe
	[13174]="::12:1:30:::1:0:", -- Plagued Flesh Sample
	[13175]=":30619:2:2:1:::1:0:", -- Voone\'s Twitchbow
	[13176]="::12:1:1:::1:0:", -- Scourge Data
	[13177]=":16396:4:3:1:::1:0:", -- Talisman of Evasion
	[13178]=":13782:4:3:1:::1:0:", -- Rosewine Circle
	[13179]=":14916:4:3:1:::1:0:", -- Brazecore Armguards
	[13180]="::12:1:50:::1:0:", -- Stratholme Holy Water
	[13181]=":8797:4:3:1:::1:0:", -- Demonskin Gloves
	[13182]=":44142:2:3:1:::1:0:", -- Phase Blade
	[13183]=":51771:2:3:1:::1:0:", -- Venomspitter
	[13184]=":13170:4:3:1:::1:0:", -- Fallbrush Handgrips
	[13185]=":15858:4:3:1:::1:0:", -- Sunderseer Mantle
	[13186]="::12:1:1:::1:0:", -- Empty Felstone Field Bottle
	[13187]="::12:1:1:::1:0:", -- Empty Dalson\'s Tears Bottle
	[13188]="::12:1:1:::1:0:", -- Empty Writhing Haunt Bottle
	[13189]="::12:1:1:::1:0:", -- Empty Gahrron\'s Withering Bottle
	[13190]="::12:1:1:::1:0:", -- Filled Felstone Field Bottle
	[13191]="::12:1:1:::1:0:", -- Filled Dalson\'s Tears Bottle
	[13192]="::12:1:1:::1:0:", -- Filled Writhing Haunt Bottle
	[13193]="::12:1:1:::1:0:", -- Filled Gahrron\'s Withering Bottle
	[13194]="::13:1:1:::1:0:", -- Felstone Field Cauldron Key
	[13195]="::13:1:1:::1:0:", -- Dalson\'s Tears Cauldron Key
	[13196]="::13:1:1:::1:0:", -- Gahrron\'s Withering Cauldron Key
	[13197]="::13:1:1:::1:0:", -- Writhing Haunt Cauldron Key
	[13198]=":50851:2:3:1:::1:0:", -- Hurd Smasher
	[13199]=":4399:4:3:1:::1:0:", -- Crushridge Bindings
	[13202]="::12:1:1:::1:0:", -- Extended Annals of Darrowshire
	[13203]=":15529:4:3:1:::1:0:", -- Armswake Cloak
	[13204]=":51945:2:3:1:::1:0:", -- Bashguuder
	[13205]=":33829:4:3:1:::1:0:", -- Rhombeard Protector
	[13206]=":19198:4:3:1:::1:0:", -- Wolfshear Leggings
	[13207]="::12:1:1:::1:0:", -- Shadow Lord Fel\'dan\'s Head
	[13208]=":12091:4:3:1:::1:0:", -- Bleak Howler Armguards
	[13209]="::4:3:1:::1:0:", -- Seal of the Dawn
	[13210]=":18024:4:3:1:::1:0:", -- Pads of the Dread Wolf
	[13211]=":14474:4:3:1:::1:0:", -- Slashclaw Bracers
	[13212]=":10670:4:3:1:::1:0:", -- Halycon\'s Spiked Collar
	[13213]=":9633:4:3:1:::1:0:", -- Smolderweb\'s Eye
	[13216]=":12795:4:2:1:::1:0:", -- Crown of the Penitent
	[13217]=":8814:4:2:1:::1:0:", -- Band of the Penitent
	[13218]=":51556:2:3:1:::1:0:", -- Fang of the Crystal Spider
	[13243]=":34046:4:3:1:::1:0:", -- Argent Defender
	[13244]=":14482:4:3:1:::1:0:", -- Gilded Gauntlets
	[13245]=":1064:4:3:1:::1:0:", -- Kresh\'s Back
	[13246]=":49997:2:3:1:::1:0:", -- Argent Avenger
	[13248]=":29670:2:3:1:::1:0:", -- Burstshot Harquebus
	[13249]=":63199:2:3:1:::1:0:", -- Argent Crusader
	[13250]="::12:1:1:::1:0:", -- Head of Balnazzar
	[13251]="::12:1:1:::1:0:", -- Head of Baron Rivendare
	[13252]=":12434:4:3:1:::1:0:", -- Cloudrunner Girdle
	[13253]=":9983:4:3:1:::1:0:", -- Hands of Power
	[13254]=":25883:4:3:1:::1:0:", -- Astral Guard
	[13255]=":14366:4:3:1:::1:0:", -- Trueaim Gauntlets
	[13257]=":18088:4:3:1:::1:0:", -- Demonic Runed Spaulders
	[13258]=":12885:4:3:1:::1:0:", -- Slaghide Gauntlets
	[13259]=":27105:4:3:1:::1:0:", -- Ribsteel Footguards
	[13260]=":21787:4:3:1:::1:0:", -- Wind Dancer Boots
	[13261]=":10452:4:3:1:::1:0:", -- Globe of D\'sak
	[13282]=":13684:4:3:1:::1:0:", -- Ogreseer Tower Boots
	[13283]=":14907:4:3:1:::1:0:", -- Magus Ring
	[13284]=":19785:4:3:1:::1:0:", -- Swiftdart Battleboots
	[13285]=":54924:2:3:1:::1:0:", -- The Blackrock Slicer
	[13286]=":44106:2:3:1:::1:0:", -- Rivenspike
	[13287]="2500:625:9:2:1:::1:0:2819", -- Pattern: Raptor Hide Harness
	[13288]="2500:625:9:2:1:::1:0:2816", -- Pattern: Raptor Hide Belt
	[13289]="::12:1:1:::1:0:", -- Egan\'s Blaster
	[13302]="::13:1:20:::1:0:", -- Market Row Postbox Key
	[13303]="::13:1:20:::1:0:", -- Crusaders\' Square Postbox Key
	[13304]="::13:1:20:::1:0:", -- Festival Lane Postbox Key
	[13305]="::13:1:20:::1:0:", -- Elders\' Square Postbox Key
	[13306]="::13:1:20:::1:0:", -- King\'s Square Postbox Key
	[13307]="::13:1:20:::1:0:", -- Fras Siabi\'s Postbox Key
	[13308]="1800:450:9:1:1:::1:0:2684,12246", -- Schematic: Ice Deflector
	[13309]="1000:250:9:1:1:::1:0:6730,2682", -- Schematic: Lovingly Crafted Boomstick
	[13310]="2000:500:9:1:1:::1:0:2685,12246", -- Schematic: Accurate Scope
	[13311]="10000:2500:9:1:1:::1:0:2687", -- Schematic: Mechanical Dragonling
	[13313]="::12:1:1:::1:0:", -- Sacred Highborne Writings
	[13314]=":28178:4:4:1:::1:0:", -- Alanna\'s Embrace
	[13315]=":11396:4:2:1:::1:0:", -- Testament of Hope
	[13317]="::15:4:1:::1:0:", -- Whistle of the Ivory Raptor
	[13320]="5000::12:1:1:::1:0:11057,11056", -- Arcane Quickener
	[13321]="100000::15:3:1:::1:0:7955", -- Green Mechanostrider
	[13322]="100000::15:3:1:::1:0:7955", -- Unpainted Mechanostrider
	[13326]="::15:4:1:::1:0:", -- White Mechanostrider Mod A
	[13327]="::15:4:1:::1:0:", -- Icy Blue Mechanostrider Mod A
	[13328]="::15:4:1:::1:0:", -- Black Ram
	[13329]="::15:4:1:::1:0:", -- Frost Ram
	[13331]="100000::15:3:1:::1:0:4731", -- Red Skeletal Horse
	[13332]="100000::15:3:1:::1:0:4731", -- Blue Skeletal Horse
	[13333]="100000::15:3:1:::1:0:4731", -- Brown Skeletal Horse
	[13334]="1000000::15:4:1:::1:0:4731", -- Green Skeletal Warhorse
	[13335]="::15:4:1:::1:0:", -- Deathcharger\'s Reins
	[13340]=":14850:4:3:1:::1:0:", -- Cape of the Black Baron
	[13344]=":15490:4:3:1:::1:0:", -- Dracorian Gauntlets
	[13345]=":15457:4:3:1:::1:0:", -- Seal of Rivendare
	[13346]=":20807:4:3:1:::1:0:", -- Robes of the Exalted
	[13347]="::4:1:1:::1:0:", -- Crystal of Zin-Malor
	[13348]=":65497:2:3:1:::1:0:", -- Demonshear
	[13349]=":52589:2:3:1:::1:0:", -- Scepter of the Unholy
	[13350]="::12:1:1:::1:0:", -- Insignia of the Black Guard
	[13351]="::12:1:1:::1:0:", -- Crimson Hammersmith\'s Apron
	[13352]="::12:1:1:::1:0:", -- Vosh\'gajin\'s Snakestone
	[13353]=":10452:4:4:1:::1:0:", -- Book of the Dead
	[13354]="::12:1:200:::1:0:", -- Ectoplasmic Resonator
	[13356]="::12:1:200:::1:0:", -- Somatic Intensifier
	[13357]="::12:1:200:::1:0:", -- Osseous Agitator
	[13358]=":18933:4:3:1:::1:0:", -- Wyrmtongue Shoulders
	[13359]=":22804:4:3:1:::1:0:", -- Crown of Tyranny
	[13360]=":50868:2:3:1:::1:0:", -- Gift of the Elven Magi
	[13361]=":51060:2:3:1:::1:0:", -- Skullforge Reaver
	[13362]=":2000:15:0:20:::1:0:", -- Letter from the Front
	[13363]=":2000:15:0:20:::1:0:", -- Municipal Proclamation
	[13364]=":2000:15:0:20:::1:0:", -- Fras Siabi\'s Advertisement
	[13365]=":2000:15:0:20:::1:0:", -- Town Meeting Notice
	[13366]=":3000:15:0:20:::1:0:", -- Ingenious Toy
	[13367]="::15:0:1:::1:0:", -- Wrapped Gift
	[13368]=":51689:2:3:1:::1:0:", -- Bonescraper
	[13369]=":15775:4:3:1:::1:0:", -- Fire Striders
	[13370]="::12:1:1:::1:0:", -- Vitreous Focuser
	[13371]=":6657:4:2:1:::1:0:", -- Father Flame
	[13372]=":63769:2:3:1:::1:0:", -- Slavedriver\'s Cane
	[13373]=":14846:4:3:1:::1:0:", -- Band of Flesh
	[13374]=":14315:4:3:1:::1:0:", -- Soulstealer Mantle
	[13375]=":30656:4:3:1:::1:0:", -- Crest of Retribution
	[13376]=":13738:4:3:1:::1:0:", -- Royal Tribunal Cloak
	[13377]=":7:6:3:200:::1:0:", -- Miniature Cannon Balls
	[13378]=":21972:4:3:1:::1:0:", -- Songbird Blouse
	[13379]=":10734:4:3:1:::1:0:", -- Piccolo of the Flaming Fire
	[13380]=":37124:2:3:1:::1:0:", -- Willey\'s Portable Howitzer
	[13381]=":26032:4:3:1:::1:0:", -- Master Cannoneer Boots
	[13382]=":10850:4:3:1:::1:0:", -- Cannonball Runner
	[13383]=":26864:4:3:1:::1:0:", -- Woollies of the Prancing Minstrel
	[13384]=":15819:4:3:1:::1:0:", -- Rainbow Girdle
	[13385]=":13237:4:3:1:::1:0:", -- Tome of Knowledge
	[13386]=":15182:4:3:1:::1:0:", -- Archivist Cape
	[13387]=":15238:4:3:1:::1:0:", -- Foresight Girdle
	[13388]=":20392:4:3:1:::1:0:", -- The Postmaster\'s Tunic
	[13389]=":21000:4:3:1:::1:0:", -- The Postmaster\'s Trousers
	[13390]=":15806:4:3:1:::1:0:", -- The Postmaster\'s Band
	[13391]=":15861:4:3:1:::1:0:", -- The Postmaster\'s Treads
	[13392]=":12211:4:3:1:::1:0:", -- The Postmaster\'s Seal
	[13393]=":60240:2:3:1:::1:0:", -- Malown\'s Slam
	[13394]=":31808:4:3:1:::1:0:", -- Skul\'s Cold Embrace
	[13395]=":11403:4:3:1:::1:0:", -- Skul\'s Fingerbone Claws
	[13396]=":30853:2:3:1:::1:0:", -- Skul\'s Ghastly Touch
	[13397]=":14680:4:3:1:::1:0:", -- Stoneskin Gargoyle Cape
	[13398]=":18674:4:3:1:::1:0:", -- Boots of the Shrieker
	[13399]=":46312:2:3:1:::1:0:", -- Gargoyle Shredder Talons
	[13400]=":16361:4:3:1:::1:0:", -- Vambraces of the Sadist
	[13401]=":49675:2:3:1:::1:0:", -- The Cruel Hand of Timmy
	[13402]=":21168:4:3:1:::1:0:", -- Timmy\'s Galoshes
	[13403]=":9401:4:3:1:::1:0:", -- Grimgore Noose
	[13404]=":15895:4:3:1:::1:0:", -- Mask of the Unforgiven
	[13405]=":22885:4:3:1:::1:0:", -- Wailing Nightbane Pauldrons
	[13408]=":44142:2:3:1:::1:0:", -- Soul Breaker
	[13409]=":8860:4:3:1:::1:0:", -- Tearfall Bracers
	[13422]=":10:7:1:20::171:1:0:", -- Stonescale Eel
	[13423]=":125:7:1:20::171:1:0:", -- Stonescale Oil
	[13442]=":500:0:1:5:::1:0:", -- Mighty Rage Potion
	[13443]="1600:400:0:1:5:::1:0:14847", -- Superior Mana Potion
	[13444]="6000:1500:0:1:5::333:1:0:20989,20092,19837,15471", -- Major Mana Potion
	[13445]=":500:0:1:20:::1:0:", -- Elixir of Superior Defense
	[13446]="4000:1000:0:1:5::333:1:0:20989,20092,19837,15471", -- Major Healing Potion
	[13447]=":1250:0:1:20:::1:0:", -- Elixir of the Sages
	[13448]="::12:1:1:::1:0:", -- The Deed to Caer Darrow
	[13450]="::12:1:1:::1:0:", -- The Deed to Southshore
	[13451]="::12:1:1:::1:0:", -- The Deed to Tarren Mill
	[13452]=":1250:0:1:20:::1:0:", -- Elixir of the Mongoose
	[13453]=":1250:0:1:20:::1:0:", -- Elixir of Brute Force
	[13454]=":750:0:1:20:::1:0:", -- Greater Arcane Elixir
	[13455]=":750:0:1:5:::1:0:", -- Greater Stoneshield Potion
	[13456]=":750:0:1:5:::1:0:", -- Greater Frost Protection Potion
	[13457]=":750:0:1:5:::1:0:", -- Greater Fire Protection Potion
	[13458]=":750:0:1:5:::1:0:", -- Greater Nature Protection Potion
	[13459]=":100:0:1:5:::1:0:", -- Greater Shadow Protection Potion
	[13461]=":750:0:1:5:::1:0:", -- Greater Arcane Protection Potion
	[13462]=":750:0:1:5:::1:0:", -- Purification Potion
	[13463]="400:100:7:1:20::171:1:0:14846", -- Dreamfoil
	[13464]="400:100:7:1:20::171:1:0:14846", -- Golden Sansam
	[13465]="600:150:7:1:20::171:1:0:14846", -- Mountain Silversage
	[13466]=":250:7:1:20::171:1:0:", -- Plaguebloom
	[13467]="1000:250:7:1:20::171,333,202:1:0:20989,24975", -- Icecap
	[13468]="4000:1000:7:2:20::171,197:1:0:14846", -- Black Lotus
	[13469]="::12:1:1:::1:0:", -- Head of Weldon Barov
	[13470]="::12:1:1:::1:0:", -- Head of Alexi Barov
	[13471]="::12:1:1:::1:0:", -- The Deed to Brill
	[13473]=":7164:4:2:1:::1:0:", -- Felstone Good Luck Charm
	[13474]=":24725:2:2:1:::1:0:", -- Farmer Dalson\'s Shotgun
	[13475]=":8109:4:2:1:::1:0:", -- Dalson Family Wedding Ring
	[13476]=":3000:9:2:1:::1:0:", -- Recipe: Mighty Rage Potion
	[13477]=":3000:9:1:1:::1:0:", -- Recipe: Superior Mana Potion
	[13478]="13000:3250:9:1:1:::1:0:5178,3348", -- Recipe: Elixir of Superior Defense
	[13479]=":3500:9:2:1:::1:0:", -- Recipe: Elixir of the Sages
	[13480]=":3750:9:1:1:::1:0:", -- Recipe: Major Healing Potion
	[13481]=":3750:9:2:1:::1:0:", -- Recipe: Elixir of Brute Force
	[13482]="15000::9:2:1:::1:0:11536,10856,10857", -- Recipe: Transmute Air to Fire
	[13483]="15000::9:2:1:::1:0:9499", -- Recipe: Transmute Fire to Earth
	[13484]="15000::9:2:1:::1:0:11557", -- Recipe: Transmute Earth to Water
	[13485]="15000::9:2:1:::1:0:11278", -- Recipe: Transmute Water to Air
	[13486]=":3750:9:2:1:::1:0:", -- Recipe: Transmute Undeath to Water
	[13487]=":3750:9:2:1:::1:0:", -- Recipe: Transmute Water to Undeath
	[13488]=":3750:9:2:1:::1:0:", -- Recipe: Transmute Life to Earth
	[13489]=":3750:9:2:1:::1:0:", -- Recipe: Transmute Earth to Life
	[13490]=":4000:9:2:1:::1:0:", -- Recipe: Greater Stoneshield Potion
	[13491]=":4000:9:2:1:::1:0:", -- Recipe: Elixir of the Mongoose
	[13492]=":5000:9:2:1:::1:0:", -- Recipe: Purification Potion
	[13493]=":5000:9:2:1:::1:0:", -- Recipe: Greater Arcane Elixir
	[13494]=":6000:9:2:1:::1:0:", -- Recipe: Greater Fire Protection Potion
	[13495]=":6000:9:2:1:::1:0:", -- Recipe: Greater Frost Protection Potion
	[13496]=":6000:9:2:1:::1:0:", -- Recipe: Greater Nature Protection Potion
	[13497]=":6000:9:2:1:::1:0:", -- Recipe: Greater Arcane Protection Potion
	[13498]=":34808:4:3:1:::1:0:", -- Handcrafted Mastersmith Leggings
	[13499]=":6000:9:2:1:::1:0:", -- Recipe: Greater Shadow Protection Potion
	[13501]="30000:7500:9:2:1:::1:0:11278", -- Recipe: Major Mana Potion
	[13502]=":18989:4:3:1:::1:0:", -- Handcrafted Mastersmith Girdle
	[13503]=":25000:4:4:1::171:1:0:", -- Alchemist\'s Stone
	[13505]=":82215:2:4:1:::1:0:", -- Runeblade of Baron Rivendare
	[13506]=":5000:0:1:5:::1:0:", -- Flask of Petrification
	[13507]="::12:1:1:::1:0:", -- Cliffwatcher Longhorn Report
	[13508]=":4778:15:2:1:::1:0:", -- Eye of Arachnida
	[13509]=":5393:0:2:1:::1:0:", -- Clutch of Foresight
	[13510]=":5000:0:1:5::164:1:0:", -- Flask of the Titans
	[13511]=":5000:0:1:5:::1:0:", -- Flask of Distilled Wisdom
	[13512]=":5000:0:1:5::164:1:0:", -- Flask of Supreme Power
	[13513]=":5000:0:1:5:::1:0:", -- Flask of Chromatic Resistance
	[13514]=":5820:0:2:1:::1:0:", -- Wail of the Banshee
	[13515]=":9600:4:3:1:::1:0:", -- Ramstein\'s Lightning Bolts
	[13517]="80000:20000:9:1:1:::1:0:21432", -- Recipe: Alchemist\'s Stone
	[13518]=":10000:9:2:1:::1:0:", -- Recipe: Flask of Petrification
	[13519]=":10000:9:2:1:::1:0:", -- Recipe: Flask of the Titans
	[13520]=":10000:9:2:1:::1:0:", -- Recipe: Flask of Distilled Wisdom
	[13521]=":10000:9:2:1:::1:0:", -- Recipe: Flask of Supreme Power
	[13522]=":10000:9:2:1:::1:0:", -- Recipe: Flask of Chromatic Resistance
	[13523]="::12:1:1:::1:0:", -- Blood of Innocents
	[13524]=":12458:4:3:1:::1:0:", -- Skull of Burning Shadows
	[13525]=":8110:4:2:1:::1:0:", -- Darkbind Fingers
	[13526]=":10177:4:2:1:::1:0:", -- Flamescarred Girdle
	[13527]=":21414:4:2:1:::1:0:", -- Lavawalker Greaves
	[13528]=":12306:4:2:1:::1:0:", -- Twilight Void Bracers
	[13529]=":31195:4:3:1:::1:0:", -- Husk of Nerub\'enkan
	[13530]=":12232:4:2:1:::1:0:", -- Fangdrip Runners
	[13531]=":20464:4:2:1:::1:0:", -- Crypt Stalker Leggings
	[13532]=":12324:4:2:1:::1:0:", -- Darkspinner Claws
	[13533]=":21607:4:2:1:::1:0:", -- Acid-etched Pauldrons
	[13534]=":37728:2:3:1:::1:0:", -- Banshee Finger
	[13535]=":16829:4:2:1:::1:0:", -- Coldtouch Phantom Wraps
	[13536]="::12:1:1:::1:0:", -- Horn of Awakening
	[13537]=":10594:4:2:1:::1:0:", -- Chillhide Bracers
	[13538]=":19223:4:2:1:::1:0:", -- Windshrieker Pauldrons
	[13539]=":15022:4:2:1:::1:0:", -- Banshee\'s Touch
	[13542]="::12:1:1:::1:0:", -- Demon Box
	[13544]="::4:2:1:::1:0:", -- Spectral Essence
	[13545]="::12:1:20:::1:0:", -- Shellfish
	[13546]=":62:0:1:20:::1:0:", -- Bloodbelly Fish
	[13562]="::12:1:1:::1:0:", -- Remains of Trey Lightforge
	[13582]="::15:3:1:::1:0:", -- Zergling Leash
	[13583]="::15:3:1:::1:0:", -- Panda Collar
	[13584]="::15:3:1:::1:0:", -- Diablo Stone
	[13585]="::12:1:1:::1:0:", -- Keepsake of Remembrance
	[13602]="::4:1:1:::1:0:", -- Greater Spellstone
	[13603]="::4:1:1:::1:0:", -- Major Spellstone
	[13624]="::12:1:1:::1:0:", -- Soulbound Keepsake
	[13626]="::12:1:1:::1:0:", -- Human Head of Ras Frostwhisper
	[13699]="::4:1:1:::1:0:", -- Firestone
	[13700]="::4:1:1:::1:0:", -- Greater Firestone
	[13701]="::4:1:1:::1:0:", -- Major Firestone
	[13702]="::12:1:20:::1:0:", -- Doom Weed
	[13703]="::12:1:20:::1:0:", -- Kodo Bone
	[13704]="::13:1:1:::1:0:", -- Skeleton Key
	[13724]="6000:300:0:1:20:::5:0:11536,10856,10857", -- Enriched Manna Biscuit
	[13725]="::12:1:1:::1:0:", -- Krastinov\'s Bag of Horrors
	[13752]="::12:1:1:::1:0:", -- Soulbound Keepsake
	[13754]=":6:7:1:20::185:1:0:", -- Raw Glossy Mightfish
	[13755]=":7:0:1:20::185:1:0:", -- Winter Squid
	[13756]=":9:7:1:20::185:1:0:", -- Raw Summer Bass
	[13757]=":10:7:1:20::185:1:0:", -- Lightning Eel
	[13758]=":4:7:1:20::185:1:0:", -- Raw Redgill
	[13759]=":10:7:1:20::185:1:0:", -- Raw Nightfin Snapper
	[13760]=":10:7:1:20::185:1:0:", -- Raw Sunscale Salmon
	[13761]="::12:1:1:::1:0:", -- Frozen Eggs
	[13810]="6000:300:0:1:20:::5:0:11536,10856,10857", -- Blessed Sunfruit
	[13813]="6000:300:0:1:20:::5:0:11536,10856,10857", -- Blessed Sunfruit Juice
	[13815]="::12:1:1:::1:0:", -- Some Rune
	[13816]=":10561:2:0:1:::1:0:", -- Fine Longsword
	[13817]=":18797:2:0:1:::1:0:", -- Tapered Greatsword
	[13818]=":13431:2:0:1:::1:0:", -- Jagged Axe
	[13819]=":19881:2:0:1:::1:0:", -- Balanced War Axe
	[13820]=":12042:2:0:1:::1:0:", -- Clout Mace
	[13821]=":17993:2:0:1:::1:0:", -- Bulky Maul
	[13822]=":11442:2:0:1:::1:0:", -- Spiked Dagger
	[13823]=":13107:2:0:1:::1:0:", -- Stout War Staff
	[13824]=":9015:2:0:1:::1:0:", -- Recurve Long Bow
	[13825]=":10168:2:0:1:::1:0:", -- Primed Musket
	[13850]="::12:1:1:::1:0:", -- Rumbleshot\'s Ammo
	[13851]=":312:0:1:20:::1:0:", -- Hot Wolf Ribs
	[13852]="::12:1:1:::1:0:", -- The Grand Crusader\'s Command
	[13853]="::12:1:10:::1:0:", -- Slab of Carrion Worm Meat
	[13856]=":5112:4:2:1:::1:0:", -- Runecloth Belt
	[13857]=":10878:4:2:1:::1:0:", -- Runecloth Tunic
	[13858]=":10917:4:2:1:::1:0:", -- Runecloth Robe
	[13860]=":8741:4:2:1:::1:0:", -- Runecloth Cloak
	[13863]=":6617:4:2:1:::1:0:", -- Runecloth Gloves
	[13864]=":9553:4:2:1:::1:0:", -- Runecloth Boots
	[13865]=":13555:4:2:1:::1:0:", -- Runecloth Pants
	[13866]=":11358:4:2:1:::1:0:", -- Runecloth Headband
	[13867]=":12138:4:2:1:::1:0:", -- Runecloth Shoulders
	[13868]=":9665:4:2:1:::1:0:", -- Frostweave Robe
	[13869]=":9702:4:2:1:::1:0:", -- Frostweave Tunic
	[13870]=":5471:4:2:1:::1:0:", -- Frostweave Gloves
	[13871]=":13436:4:2:1:::1:0:", -- Frostweave Pants
	[13872]="::12:1:20:::1:0:", -- Bundle of Wood
	[13873]="::13:1:1:::1:0:", -- Viewing Room Key
	[13874]=":1:15:1:1:::1:0:", -- Heavy Crate
	[13875]=":1:15:1:1:::1:0:", -- Ironbound Locked Chest
	[13876]=":25:15:1:1:::1:0:", -- 40 Pound Grouper
	[13877]=":30:15:1:1:::1:0:", -- 47 Pound Grouper
	[13878]=":32:15:1:1:::1:0:", -- 53 Pound Grouper
	[13879]=":35:15:1:1:::1:0:", -- 59 Pound Grouper
	[13880]=":37:15:1:1:::1:0:", -- 68 Pound Grouper
	[13881]=":100:15:1:1:::1:0:", -- Bloated Redgill
	[13882]=":60:4:1:1:::1:0:", -- 42 Pound Redgill
	[13883]=":60:4:1:1:::1:0:", -- 45 Pound Redgill
	[13884]=":75:4:1:1:::1:0:", -- 49 Pound Redgill
	[13885]=":50:4:1:1:::1:0:", -- 34 Pound Redgill
	[13886]=":50:4:1:1:::1:0:", -- 37 Pound Redgill
	[13887]=":75:4:1:1:::1:0:", -- 52 Pound Redgill
	[13888]=":12:7:1:20::185:1:0:", -- Darkclaw Lobster
	[13889]=":5:7:1:20::185:1:0:", -- Raw Whitescale Salmon
	[13890]=":70:12:1:20:::1:0:", -- Plated Armorfish
	[13891]=":100:15:1:1:::1:0:", -- Bloated Salmon
	[13892]="::12:1:1:::1:0:", -- Kodo Kombobulator
	[13893]=":15:0:1:20::185:1:0:", -- Large Raw Mightfish
	[13895]="506622:101324:4:1:1:::1:0:4184", -- Formal Dangui
	[13896]="55103:11020:4:1:1:::1:0:1299,5821,4184", -- Dark Green Wedding Hanbok
	[13897]="2977:595:4:1:1:::1:0:1299,5821,4184", -- White Traditional Hanbok
	[13898]="288699:57739:4:1:1:::1:0:1299,5821,4184", -- Royal Dangui
	[13899]="17641:3528:4:1:1:::1:0:4184", -- Red Traditional Hanbok
	[13900]="137214:27442:4:1:1:::1:0:4184", -- Green Wedding Hanbok
	[13901]=":25:4:1:1:::1:0:", -- 15 Pound Salmon
	[13902]=":25:4:1:1:::1:0:", -- 18 Pound Salmon
	[13903]=":25:4:1:1:::1:0:", -- 22 Pound Salmon
	[13904]=":25:4:1:1:::1:0:", -- 25 Pound Salmon
	[13905]=":25:4:1:1:::1:0:", -- 29 Pound Salmon
	[13907]=":50:15:1:1:::1:0:", -- 7 Pound Lobster
	[13908]=":55:15:1:1:::1:0:", -- 9 Pound Lobster
	[13909]=":55:15:1:1:::1:0:", -- 12 Pound Lobster
	[13910]=":62:15:1:1:::1:0:", -- 15 Pound Lobster
	[13911]=":80:15:1:1:::1:0:", -- 19 Pound Lobster
	[13912]=":90:15:1:1:::1:0:", -- 21 Pound Lobster
	[13913]=":100:15:1:1:::1:0:", -- 22 Pound Lobster
	[13914]=":125:4:1:1:::1:0:", -- 70 Pound Mightfish
	[13915]=":125:4:1:1:::1:0:", -- 85 Pound Mightfish
	[13916]=":150:4:1:1:::1:0:", -- 92 Pound Mightfish
	[13917]=":200:4:1:1:::1:0:", -- 103 Pound Mightfish
	[13918]=":1:15:1:1:::1:0:", -- Reinforced Locked Chest
	[13920]="::12:1:1:::1:0:", -- Healthy Dragon Scale
	[13926]=":10000:3:2:20::333,197:1:0:", -- Golden Pearl
	[13927]=":8:0:1:20:::1:0:", -- Cooked Glossy Mightfish
	[13928]=":8:0:1:20:::1:0:", -- Grilled Squid
	[13929]=":10:0:1:20:::1:0:", -- Hot Smoked Bass
	[13930]=":5:0:1:20:::1:0:", -- Filet of Redgill
	[13931]=":12:0:1:20:::1:0:", -- Nightfin Soup
	[13932]=":12:0:1:20:::1:0:", -- Poached Sunscale Salmon
	[13933]=":14:0:1:20:::1:0:", -- Lobster Stew
	[13934]=":18:0:1:20:::1:0:", -- Mightfish Steak
	[13935]=":10:0:1:20:::1:0:", -- Baked Salmon
	[13937]=":81129:2:4:1:::1:0:", -- Headmaster\'s Charge
	[13938]=":36646:2:3:1:::1:0:", -- Bonecreeper Stylus
	[13939]="16000:4000:9:1:1:::1:0:8137", -- Recipe: Spotted Yellowtail
	[13940]="16000:4000:9:1:1:::1:0:2664", -- Recipe: Cooked Glossy Mightfish
	[13941]="16000:4000:9:1:1:::1:0:2664", -- Recipe: Filet of Redgill
	[13942]="16000:4000:9:1:1:::1:0:8137", -- Recipe: Grilled Squid
	[13943]="16000:4000:9:1:1:::1:0:2664", -- Recipe: Hot Smoked Bass
	[13944]=":24996:4:3:1:::1:0:", -- Tombstone Breastplate
	[13945]="20000:5000:9:1:1:::1:0:8137", -- Recipe: Nightfin Soup
	[13946]="20000:5000:9:1:1:::1:0:8137", -- Recipe: Poached Sunscale Salmon
	[13947]="20000:5000:9:1:1:::1:0:8145,7947", -- Recipe: Lobster Stew
	[13948]="20000:5000:9:1:1:::1:0:8145,7947", -- Recipe: Mightfish Steak
	[13949]="20000:5000:9:1:1:::1:0:8145,7947", -- Recipe: Baked Salmon
	[13950]=":15335:4:3:1:::1:0:", -- Detention Strap
	[13951]=":18059:4:3:1:::1:0:", -- Vigorsteel Vambraces
	[13952]=":52850:2:3:1:::1:0:", -- Iceblade Hacker
	[13953]=":53034:2:3:1:::1:0:", -- Silent Fang
	[13954]=":19687:4:3:1:::1:0:", -- Verdant Footpads
	[13955]=":27607:4:3:1:::1:0:", -- Stoneform Shoulders
	[13956]=":10574:4:3:1:::1:0:", -- Clutch of Andros
	[13957]=":12001:4:3:1:::1:0:", -- Gargoyle Slashers
	[13958]=":9505:4:3:1:::1:0:", -- Wyrmthalak\'s Shackles
	[13959]=":16794:4:3:1:::1:0:", -- Omokk\'s Girth Restrainer
	[13960]=":12828:4:3:1:::1:0:", -- Heart of the Fiend
	[13961]=":18028:4:3:1:::1:0:", -- Halycon\'s Muzzle
	[13962]=":12064:4:3:1:::1:0:", -- Vosh\'gajin\'s Strand
	[13963]=":14533:4:3:1:::1:0:", -- Voone\'s Vice Grips
	[13964]=":49986:2:3:1:::1:0:", -- Witchblade
	[13965]=":16250:4:3:1:::1:0:", -- Blackhand\'s Breadth
	[13966]=":16250:4:3:1:::1:0:", -- Mark of Tyranny
	[13967]=":22537:4:3:1:::1:0:", -- Windreaver Greaves
	[13968]=":16250:4:3:1:::1:0:", -- Eye of the Beast
	[13969]=":15470:4:3:1:::1:0:", -- Loomguard Armbraces
	[13982]=":62847:2:3:1:::1:0:", -- Warblade of Caer Darrow
	[13983]=":62240:2:3:1:::1:0:", -- Gravestone War Axe
	[13984]=":52029:2:3:1:::1:0:", -- Darrowspike
	[13986]=":15723:4:3:1:::1:0:", -- Crown of Caer Darrow
	[14002]=":33050:4:3:1:::1:0:", -- Darrowshire Strongguard
	[14022]=":8991:4:3:1:::1:0:", -- Barov Peasant Caller
	[14023]=":8991:4:3:1:::1:0:", -- Barov Peasant Caller
	[14024]=":50623:2:3:1:::1:0:", -- Frightalon
	[14025]=":188:4:2:1:::1:0:", -- Mystic\'s Belt
	[14042]=":10561:4:2:1:::1:0:", -- Cindercloth Vest
	[14043]=":5955:4:2:1:::1:0:", -- Cindercloth Gloves
	[14044]=":9503:4:2:1::165:1:0:", -- Cindercloth Cloak
	[14045]=":13481:4:2:1:::1:0:", -- Cindercloth Pants
	[14046]=":5000:1:1:1:::1:0:", -- Runecloth Bag
	[14047]=":400:7:1:20::164,202,129,165,197:1:0:", -- Runecloth
	[14048]=":2000:7:1:10::165,197:1:0:", -- Bolt of Runecloth
	[14086]=":45:4:1:1:::1:0:", -- Beaded Sandals
	[14087]=":16:4:1:1:::1:0:", -- Beaded Cuffs
	[14088]=":24:4:1:1:::1:0:", -- Beaded Cloak
	[14089]=":30:4:1:1:::1:0:", -- Beaded Gloves
	[14090]=":119:4:2:1:::1:0:", -- Beaded Britches
	[14091]=":120:4:2:1:::1:0:", -- Beaded Robe
	[14093]=":21:4:1:1:::1:0:", -- Beaded Cord
	[14094]=":121:4:2:1:::1:0:", -- Beaded Wraps
	[14095]=":36:4:1:1:::1:0:", -- Native Bands
	[14096]=":325:4:2:1:::1:0:", -- Native Vest
	[14097]=":236:4:2:1:::1:0:", -- Native Pants
	[14098]=":43:4:1:1:::1:0:", -- Native Cloak
	[14099]=":47:4:1:1:::1:0:", -- Native Sash
	[14100]=":12089:4:2:1:::1:0:", -- Brightcloth Robe
	[14101]=":6066:4:2:1:::1:0:", -- Brightcloth Gloves
	[14102]=":60:4:1:1:::1:0:", -- Native Handwraps
	[14103]=":9716:4:2:1:::1:0:", -- Brightcloth Cloak
	[14104]=":15484:4:2:1:::1:0:", -- Brightcloth Pants
	[14106]=":17434:4:2:1:::1:0:", -- Felcloth Robe
	[14107]=":13141:4:2:1:::1:0:", -- Felcloth Pants
	[14108]=":11112:4:2:1:::1:0:", -- Felcloth Boots
	[14109]=":341:4:2:1:::1:0:", -- Native Robe
	[14110]=":84:4:1:1:::1:0:", -- Native Sandals
	[14111]=":10775:4:2:1:::1:0:", -- Felcloth Hood
	[14112]=":12596:4:2:1:::1:0:", -- Felcloth Shoulders
	[14113]=":139:4:2:1:::1:0:", -- Aboriginal Sash
	[14114]=":242:4:2:1:::1:0:", -- Aboriginal Footwraps
	[14115]=":70:4:1:1:::1:0:", -- Aboriginal Bands
	[14116]=":106:4:1:1:::1:0:", -- Aboriginal Cape
	[14117]=":163:4:2:1:::1:0:", -- Aboriginal Gloves
	[14119]=":378:4:2:1:::1:0:", -- Aboriginal Loincloth
	[14120]=":577:4:2:1:::1:0:", -- Aboriginal Robe
	[14121]=":579:4:2:1:::1:0:", -- Aboriginal Vest
	[14122]=":219:4:2:1:::1:0:", -- Ritual Bands
	[14123]=":287:4:2:1:::1:0:", -- Ritual Cape
	[14124]=":292:4:2:1:::1:0:", -- Ritual Gloves
	[14125]=":676:4:2:1:::1:0:", -- Ritual Leggings
	[14126]=":396:4:1:1:::1:0:", -- Ritual Amice
	[14127]=":1000:4:2:1:::1:0:", -- Ritual Shroud
	[14128]=":16093:4:2:1:::1:0:", -- Wizardweave Robe
	[14129]=":415:4:2:1:::1:0:", -- Ritual Sandals
	[14130]=":12330:4:2:1:::1:0:", -- Wizardweave Turban
	[14131]=":242:4:2:1:::1:0:", -- Ritual Belt
	[14132]=":12441:4:2:1:::1:0:", -- Wizardweave Leggings
	[14133]=":950:4:2:1:::1:0:", -- Ritual Tunic
	[14134]=":11280:4:3:1:::1:0:", -- Cloak of Fire
	[14136]=":17025:4:3:1:::1:0:", -- Robe of Winter Night
	[14137]=":18113:4:3:1:::1:0:", -- Mooncloth Leggings
	[14138]=":20042:4:3:1:::1:0:", -- Mooncloth Vest
	[14139]=":15297:4:3:1:::1:0:", -- Mooncloth Shoulders
	[14140]=":15565:4:3:1:::1:0:", -- Mooncloth Circlet
	[14141]=":12859:4:2:1:::1:0:", -- Ghostweave Vest
	[14142]=":6087:4:2:1:::1:0:", -- Ghostweave Gloves
	[14143]=":5763:4:2:1:::1:0:", -- Ghostweave Belt
	[14144]=":14374:4:2:1:::1:0:", -- Ghostweave Pants
	[14145]=":1238:2:3:1:::1:0:", -- Cursed Felblade
	[14146]=":13132:4:4:1:::1:0:", -- Gloves of Spell Mastery
	[14147]=":374:4:3:1:::1:0:", -- Cavedweller Bracers
	[14148]=":250:4:3:1:::1:0:", -- Crystalline Cuffs
	[14149]=":377:4:3:1:::1:0:", -- Subterranean Cape
	[14150]=":504:4:3:1:::1:0:", -- Robe of Evocation
	[14151]=":1267:2:3:1:::1:0:", -- Chanting Blade
	[14152]=":26866:4:4:1:::1:0:", -- Robe of the Archmage
	[14153]=":26965:4:4:1:::1:0:", -- Robe of the Void
	[14154]=":27066:4:4:1:::1:0:", -- Truefaith Vestments
	[14155]=":20000:1:2:1:::1:0:", -- Mooncloth Bag
	[14156]=":40000:1:3:1:::1:0:", -- Bottomless Bag
	[14157]=":434:4:1:1:::1:0:", -- Pagan Mantle
	[14158]=":1236:4:2:1:::1:0:", -- Pagan Vest
	[14159]=":570:4:2:1:::1:0:", -- Pagan Shoes
	[14160]=":251:4:2:1:::1:0:", -- Pagan Bands
	[14161]=":337:4:2:1:::1:0:", -- Pagan Cape
	[14162]=":445:4:2:1:::1:0:", -- Pagan Mitts
	[14163]=":1168:4:2:1:::1:0:", -- Pagan Wraps
	[14164]=":312:4:2:1:::1:0:", -- Pagan Belt
	[14165]=":1041:4:2:1:::1:0:", -- Pagan Britches
	[14166]=":238:4:2:1:::1:0:", -- Buccaneer\'s Bracers
	[14167]=":358:4:2:1:::1:0:", -- Buccaneer\'s Cape
	[14168]=":276:4:2:1:::1:0:", -- Buccaneer\'s Gloves
	[14169]=":286:4:1:1:::1:0:", -- Aboriginal Shoulder Pads
	[14170]=":331:4:1:1:::1:0:", -- Buccaneer\'s Mantle
	[14171]=":738:4:2:1:::1:0:", -- Buccaneer\'s Pants
	[14172]=":837:4:2:1:::1:0:", -- Buccaneer\'s Robes
	[14173]=":281:4:2:1:::1:0:", -- Buccaneer\'s Cord
	[14174]=":368:4:2:1:::1:0:", -- Buccaneer\'s Boots
	[14175]=":847:4:2:1:::1:0:", -- Buccaneer\'s Vest
	[14176]=":920:4:2:1:::1:0:", -- Watcher\'s Boots
	[14177]=":631:4:2:1:::1:0:", -- Watcher\'s Cuffs
	[14178]=":1532:4:2:1:::1:0:", -- Watcher\'s Cap
	[14179]=":747:4:2:1:::1:0:", -- Watcher\'s Cape
	[14180]=":1870:4:2:1:::1:0:", -- Watcher\'s Jerkin
	[14181]=":775:4:2:1:::1:0:", -- Watcher\'s Handwraps
	[14182]=":1167:4:2:1:::1:0:", -- Watcher\'s Mantle
	[14183]=":1710:4:2:1:::1:0:", -- Watcher\'s Leggings
	[14184]=":1716:4:2:1:::1:0:", -- Watcher\'s Robes
	[14185]=":647:4:2:1:::1:0:", -- Watcher\'s Cinch
	[14186]=":1179:4:2:1:::1:0:", -- Raincaller Mantle
	[14187]=":717:4:2:1:::1:0:", -- Raincaller Cuffs
	[14188]=":982:4:2:1:::1:0:", -- Raincaller Cloak
	[14189]=":1588:4:2:1:::1:0:", -- Raincaller Cap
	[14190]=":1932:4:2:1:::1:0:", -- Raincaller Vest
	[14191]=":881:4:2:1:::1:0:", -- Raincaller Mitts
	[14192]=":1946:4:2:1:::1:0:", -- Raincaller Robes
	[14193]=":2006:4:2:1:::1:0:", -- Raincaller Pants
	[14194]=":756:4:2:1:::1:0:", -- Raincaller Cord
	[14195]=":1252:4:2:1:::1:0:", -- Raincaller Boots
	[14196]=":1673:4:2:1:::1:0:", -- Thistlefur Sandals
	[14197]=":925:4:2:1:::1:0:", -- Thistlefur Bands
	[14198]=":1531:4:2:1:::1:0:", -- Thistlefur Cloak
	[14199]=":1240:4:2:1:::1:0:", -- Thistlefur Gloves
	[14200]=":2258:4:2:1:::1:0:", -- Thistlefur Cap
	[14201]=":2060:4:2:1:::1:0:", -- Thistlefur Mantle
	[14202]=":3336:4:2:1:::1:0:", -- Thistlefur Jerkin
	[14203]=":2754:4:2:1:::1:0:", -- Thistlefur Pants
	[14204]=":3041:4:2:1:::1:0:", -- Thistlefur Robe
	[14205]=":1042:4:2:1:::1:0:", -- Thistlefur Belt
	[14206]=":1046:4:2:1:::1:0:", -- Vital Bracelets
	[14207]=":3076:4:2:1:::1:0:", -- Vital Leggings
	[14208]=":2316:4:2:1:::1:0:", -- Vital Headband
	[14209]=":1196:4:2:1:::1:0:", -- Vital Sash
	[14210]=":1637:4:2:1:::1:0:", -- Vital Cape
	[14211]=":1325:4:2:1:::1:0:", -- Vital Handwraps
	[14212]=":2194:4:2:1:::1:0:", -- Vital Shoulders
	[14213]=":3553:4:2:1:::1:0:", -- Vital Raiment
	[14214]=":2009:4:2:1:::1:0:", -- Vital Boots
	[14215]=":3579:4:2:1:::1:0:", -- Vital Tunic
	[14216]=":4887:4:2:1:::1:0:", -- Geomancer\'s Jerkin
	[14217]=":1638:4:2:1:::1:0:", -- Geomancer\'s Cord
	[14218]=":2713:4:2:1:::1:0:", -- Geomancer\'s Boots
	[14219]=":2046:4:2:1:::1:0:", -- Geomancer\'s Cloak
	[14220]=":3442:4:2:1:::1:0:", -- Geomancer\'s Cap
	[14221]=":1511:4:2:1:::1:0:", -- Geomancer\'s Bracers
	[14222]=":1834:4:2:1:::1:0:", -- Geomancer\'s Gloves
	[14223]=":2699:4:2:1:::1:0:", -- Geomancer\'s Spaulders
	[14224]=":3901:4:2:1:::1:0:", -- Geomancer\'s Trousers
	[14225]=":4694:4:2:1:::1:0:", -- Geomancer\'s Wraps
	[14226]=":1731:4:2:1:::1:0:", -- Embersilk Bracelets
	[14227]=":2500:7:1:10::202,165,197:1:0:", -- Ironweb Spider Silk
	[14228]=":3560:4:2:1:::1:0:", -- Embersilk Coronet
	[14229]=":2387:4:2:1:::1:0:", -- Embersilk Cloak
	[14230]=":5164:4:2:1:::1:0:", -- Embersilk Tunic
	[14231]=":1905:4:2:1:::1:0:", -- Embersilk Mitts
	[14232]=":3097:4:2:1:::1:0:", -- Embersilk Mantle
	[14233]=":4476:4:2:1:::1:0:", -- Embersilk Leggings
	[14234]=":5240:4:2:1:::1:0:", -- Embersilk Robes
	[14235]=":1789:4:2:1:::1:0:", -- Embersilk Cord
	[14236]=":2909:4:2:1:::1:0:", -- Embersilk Boots
	[14237]=":7206:4:2:1:::1:0:", -- Darkmist Armor
	[14238]=":3691:4:2:1:::1:0:", -- Darkmist Boots
	[14239]=":3176:4:2:1:::1:0:", -- Darkmist Cape
	[14240]=":2294:4:2:1:::1:0:", -- Darkmist Bands
	[14241]=":2311:4:2:1:::1:0:", -- Darkmist Handguards
	[14242]=":5413:4:2:1:::1:0:", -- Darkmist Pants
	[14243]=":4075:4:2:1:::1:0:", -- Darkmist Mantle
	[14244]=":6870:4:2:1:::1:0:", -- Darkmist Wraps
	[14245]=":2346:4:2:1:::1:0:", -- Darkmist Girdle
	[14246]=":4451:4:2:1:::1:0:", -- Darkmist Wizard Hat
	[14247]=":4467:4:2:1:::1:0:", -- Lunar Mantle
	[14248]=":2373:4:2:1:::1:0:", -- Lunar Bindings
	[14249]=":7559:4:2:1:::1:0:", -- Lunar Vest
	[14250]=":3873:4:2:1:::1:0:", -- Lunar Slippers
	[14251]=":3332:4:2:1:::1:0:", -- Lunar Cloak
	[14252]=":4914:4:2:1:::1:0:", -- Lunar Coronet
	[14253]=":2819:4:2:1:::1:0:", -- Lunar Handwraps
	[14254]=":7698:4:2:1:::1:0:", -- Lunar Raiment
	[14255]=":2629:4:2:1:::1:0:", -- Lunar Belt
	[14256]="8000:2000:7:1:20::165,197:1:0:16015", -- Felcloth
	[14257]=":6194:4:2:1:::1:0:", -- Lunar Leggings
	[14258]=":3109:4:2:1:::1:0:", -- Bloodwoven Cord
	[14259]=":5056:4:2:1:::1:0:", -- Bloodwoven Boots
	[14260]=":2900:4:2:1:::1:0:", -- Bloodwoven Bracers
	[14261]=":4044:4:2:1:::1:0:", -- Bloodwoven Cloak
	[14262]=":3156:4:2:1:::1:0:", -- Bloodwoven Mitts
	[14263]=":5987:4:2:1:::1:0:", -- Bloodwoven Mask
	[14264]=":8013:4:2:1:::1:0:", -- Bloodwoven Pants
	[14265]=":9853:4:2:1:::1:0:", -- Bloodwoven Wraps
	[14266]=":5606:4:2:1:::1:0:", -- Bloodwoven Pads
	[14267]=":9926:4:2:1:::1:0:", -- Bloodwoven Jerkin
	[14268]=":3486:4:2:1:::1:0:", -- Gaea\'s Cuffs
	[14269]=":5669:4:2:1:::1:0:", -- Gaea\'s Slippers
	[14270]=":4877:4:2:1:::1:0:", -- Gaea\'s Cloak
	[14271]=":6599:4:2:1:::1:0:", -- Gaea\'s Circlet
	[14272]=":3821:4:2:1:::1:0:", -- Gaea\'s Handwraps
	[14273]=":6375:4:2:1:::1:0:", -- Gaea\'s Amice
	[14274]=":10448:4:2:1:::1:0:", -- Gaea\'s Leggings
	[14275]=":11115:4:2:1:::1:0:", -- Gaea\'s Raiment
	[14276]=":3598:4:2:1:::1:0:", -- Gaea\'s Belt
	[14277]=":10131:4:2:1:::1:0:", -- Gaea\'s Tunic
	[14278]=":6725:4:2:1:::1:0:", -- Opulent Mantle
	[14279]=":4206:4:2:1:::1:0:", -- Opulent Bracers
	[14280]=":5919:4:2:1:::1:0:", -- Opulent Cape
	[14281]=":8178:4:2:1:::1:0:", -- Opulent Crown
	[14282]=":4552:4:2:1:::1:0:", -- Opulent Gloves
	[14283]=":11646:4:2:1:::1:0:", -- Opulent Leggings
	[14284]=":13135:4:2:1:::1:0:", -- Opulent Robes
	[14285]=":6905:4:2:1:::1:0:", -- Opulent Boots
	[14286]=":4620:4:2:1:::1:0:", -- Opulent Belt
	[14287]=":13283:4:2:1:::1:0:", -- Opulent Tunic
	[14288]=":14132:4:2:1:::1:0:", -- Arachnidian Armor
	[14289]=":5131:4:2:1:::1:0:", -- Arachnidian Girdle
	[14290]=":7725:4:2:1:::1:0:", -- Arachnidian Footpads
	[14291]=":4830:4:2:1:::1:0:", -- Arachnidian Bracelets
	[14292]=":6795:4:2:1:::1:0:", -- Arachnidian Cape
	[14293]=":9857:4:2:1:::1:0:", -- Arachnidian Circlet
	[14294]=":5223:4:2:1:::1:0:", -- Arachnidian Gloves
	[14295]=":13237:4:2:1:::1:0:", -- Arachnidian Legguards
	[14296]=":7568:4:2:1:::1:0:", -- Arachnidian Pauldrons
	[14297]=":13556:4:2:1:::1:0:", -- Arachnidian Robes
	[14298]=":9629:4:2:1:::1:0:", -- Bonecaster\'s Spaulders
	[14299]=":8602:4:2:1:::1:0:", -- Bonecaster\'s Boots
	[14300]=":7685:4:2:1:::1:0:", -- Bonecaster\'s Cape
	[14301]=":5451:4:2:1:::1:0:", -- Bonecaster\'s Bindings
	[14302]=":6517:4:2:1:::1:0:", -- Bonecaster\'s Gloves
	[14303]=":16209:4:2:1:::1:0:", -- Bonecaster\'s Shroud
	[14304]=":6194:4:2:1:::1:0:", -- Bonecaster\'s Belt
	[14305]=":14349:4:2:1:::1:0:", -- Bonecaster\'s Sarong
	[14306]=":16831:4:2:1:::1:0:", -- Bonecaster\'s Vest
	[14307]=":12064:4:2:1:::1:0:", -- Bonecaster\'s Crown
	[14308]=":17188:4:2:1:::1:0:", -- Celestial Tunic
	[14309]=":6867:4:2:1:::1:0:", -- Celestial Belt
	[14310]=":11615:4:2:1:::1:0:", -- Celestial Slippers
	[14311]=":6524:4:2:1:::1:0:", -- Celestial Bindings
	[14312]=":13077:4:2:1:::1:0:", -- Celestial Crown
	[14313]=":9298:4:2:1:::1:0:", -- Celestial Cape
	[14314]=":7854:4:2:1:::1:0:", -- Celestial Handwraps
	[14315]=":16550:4:2:1:::1:0:", -- Celestial Kilt
	[14316]=":11271:4:2:1:::1:0:", -- Celestial Pauldrons
	[14317]=":16062:4:2:1:::1:0:", -- Celestial Silk Robes
	[14318]=":16569:4:2:1:::1:0:", -- Resplendent Tunic
	[14319]=":11401:4:2:1:::1:0:", -- Resplendent Boots
	[14320]=":6855:4:2:1:::1:0:", -- Resplendent Bracelets
	[14321]=":9438:4:2:1:::1:0:", -- Resplendent Cloak
	[14322]=":12785:4:2:1:::1:0:", -- Resplendent Circlet
	[14323]=":8322:4:2:1:::1:0:", -- Resplendent Gauntlets
	[14324]=":16706:4:2:1:::1:0:", -- Resplendent Sarong
	[14325]=":12751:4:2:1:::1:0:", -- Resplendent Epaulets
	[14326]=":17533:4:2:1:::1:0:", -- Resplendent Robes
	[14327]=":7659:4:2:1:::1:0:", -- Resplendent Belt
	[14328]=":18134:4:2:1:::1:0:", -- Eternal Chestguard
	[14329]=":13115:4:2:1:::1:0:", -- Eternal Boots
	[14330]=":8655:4:2:1:::1:0:", -- Eternal Bindings
	[14331]=":11654:4:2:1:::1:0:", -- Eternal Cloak
	[14332]=":13616:4:2:1:::1:0:", -- Eternal Crown
	[14333]=":8989:4:2:1:::1:0:", -- Eternal Gloves
	[14334]=":18041:4:2:1:::1:0:", -- Eternal Sarong
	[14335]=":13578:4:2:1:::1:0:", -- Eternal Spaulders
	[14336]=":16880:4:2:1:::1:0:", -- Eternal Wraps
	[14337]=":8253:4:2:1:::1:0:", -- Eternal Cord
	[14338]="::12:1:1:::1:0:", -- Empty Water Tube
	[14339]="::12:1:1:::1:0:", -- Moonwell Water Tube
	[14340]=":20305:4:3:1:::1:0:", -- Freezing Lich Robes
	[14341]="5000:1250:7:1:20::165,197:1:0:16768,26744,4589,26751,7947,24843,4225,3096,6731,18749,4775,12942,8681,26765,5783,2670,12956,11557,21085,3955,25082,17486,4897,16366,2699,4189,20092,3954,2821,20194,18772,2846,19015,26747,2668,12022,19497,19196,26753,26742,25051,16602,19450,16826,19017,5128,6576,1347,15179,3485,1672,5135,12245,21083,12958,15165,16613,16767,19532,19562,26724,16748,2819,2672,26749,19722,1286,26755,19573,26738,16638,1148,2669,22099,6301,19197,16689,12028,19372,25034,19533,18277,5163,26758,4577,8363,5154,7940,18009,3958,2816,26754,26752,20891,26743,6568,25010,2225,4561,2697,8934,26756,11189,4168,18907,26759,989,20250,22271,3779,11874,12943,12941,3091,26739,26741,6574,12957,18754,7854,19213,7852,26748,19521,20081,3364,2810,19345,5565,2394,8160,1474,24995,26745,4229,26757,3366,1454,5944,19042,19194,6567,18015,3005,18960,8145,19244,18771,24935,21113,3367,2698,26740,5817,25019", -- Rune Thread
	[14342]=":4000:7:1:20::165,197:1:0:", -- Mooncloth
	[14343]="::7:3:20::333:1:0:", -- Small Brilliant Shard
	[14344]="::7:3:20::333,197:1:0:", -- Large Brilliant Shard
	[14364]=":325:4:2:1:::1:0:", -- Mystic\'s Slippers
	[14365]=":214:4:2:1:::1:0:", -- Mystic\'s Cape
	[14366]=":189:4:2:1:::1:0:", -- Mystic\'s Bracelets
	[14367]=":252:4:2:1:::1:0:", -- Mystic\'s Gloves
	[14368]=":346:4:1:1:::1:0:", -- Mystic\'s Shoulder Pads
	[14369]=":809:4:2:1:::1:0:", -- Mystic\'s Wrap
	[14370]=":473:4:2:1:::1:0:", -- Mystic\'s Woolies
	[14371]=":816:4:2:1:::1:0:", -- Mystic\'s Robe
	[14372]=":1430:4:2:1:::1:0:", -- Sanguine Armor
	[14373]=":525:4:2:1:::1:0:", -- Sanguine Belt
	[14374]=":699:4:2:1:::1:0:", -- Sanguine Sandals
	[14375]=":528:4:2:1:::1:0:", -- Sanguine Cuffs
	[14376]=":552:4:2:1:::1:0:", -- Sanguine Cape
	[14377]=":602:4:2:1:::1:0:", -- Sanguine Handwraps
	[14378]=":997:4:2:1:::1:0:", -- Sanguine Mantle
	[14379]=":1615:4:2:1:::1:0:", -- Sanguine Trousers
	[14380]=":1473:4:2:1:::1:0:", -- Sanguine Robe
	[14381]="::12:1:1:::1:0:", -- Grimtotem Satchel
	[14395]="::12:1:1:::1:0:", -- Spells of Shadow
	[14396]="::12:1:1:::1:0:", -- Incantations from the Nether
	[14397]=":1600:4:2:1:::1:0:", -- Resilient Mantle
	[14398]=":2355:4:2:1:::1:0:", -- Resilient Tunic
	[14399]=":1465:4:2:1:::1:0:", -- Resilient Boots
	[14400]=":1215:4:2:1:::1:0:", -- Resilient Cape
	[14401]=":1786:4:2:1:::1:0:", -- Resilient Cap
	[14402]=":838:4:2:1:::1:0:", -- Resilient Bands
	[14403]=":1017:4:2:1:::1:0:", -- Resilient Handgrips
	[14404]=":2472:4:2:1:::1:0:", -- Resilient Leggings
	[14405]=":2480:4:2:1:::1:0:", -- Resilient Robe
	[14406]=":935:4:2:1:::1:0:", -- Resilient Cord
	[14407]=":4266:4:2:1:::1:0:", -- Stonecloth Vest
	[14408]=":2275:4:2:1:::1:0:", -- Stonecloth Boots
	[14409]=":1707:4:2:1:::1:0:", -- Stonecloth Cape
	[14410]=":2710:4:2:1:::1:0:", -- Stonecloth Circlet
	[14411]=":1387:4:2:1:::1:0:", -- Stonecloth Gloves
	[14412]=":2298:4:2:1:::1:0:", -- Stonecloth Epaulets
	[14413]=":3947:4:2:1:::1:0:", -- Stonecloth Robe
	[14414]=":1276:4:2:1:::1:0:", -- Stonecloth Belt
	[14415]=":3410:4:2:1:::1:0:", -- Stonecloth Britches
	[14416]=":1285:4:2:1:::1:0:", -- Stonecloth Bindings
	[14417]=":5888:4:2:1:::1:0:", -- Silksand Tunic
	[14418]=":3098:4:2:1:::1:0:", -- Silksand Boots
	[14419]=":1919:4:2:1:::1:0:", -- Silksand Bracers
	[14420]=":2889:4:2:1:::1:0:", -- Silksand Cape
	[14421]=":3945:4:2:1:::1:0:", -- Silksand Circlet
	[14422]=":2263:4:2:1:::1:0:", -- Silksand Gloves
	[14423]=":3406:4:2:1:::1:0:", -- Silksand Shoulder Pads
	[14424]=":5316:4:2:1:::1:0:", -- Silksand Legwraps
	[14425]=":6223:4:2:1:::1:0:", -- Silksand Wraps
	[14426]=":2125:4:2:1:::1:0:", -- Silksand Girdle
	[14427]=":9124:4:2:1:::1:0:", -- Windchaser Wraps
	[14428]=":4717:4:2:1:::1:0:", -- Windchaser Footpads
	[14429]=":2644:4:2:1:::1:0:", -- Windchaser Cuffs
	[14430]=":3686:4:2:1:::1:0:", -- Windchaser Cloak
	[14431]=":2877:4:2:1:::1:0:", -- Windchaser Handguards
	[14432]=":4679:4:2:1:::1:0:", -- Windchaser Amice
	[14433]=":6764:4:2:1:::1:0:", -- Windchaser Woolies
	[14434]=":8706:4:2:1:::1:0:", -- Windchaser Robes
	[14435]=":2778:4:2:1:::1:0:", -- Windchaser Cinch
	[14436]=":5270:4:2:1:::1:0:", -- Windchaser Coronet
	[14437]=":12002:4:2:1:::1:0:", -- Venomshroud Vest
	[14438]=":6192:4:2:1:::1:0:", -- Venomshroud Boots
	[14439]=":3836:4:2:1:::1:0:", -- Venomshroud Armguards
	[14440]=":5347:4:2:1:::1:0:", -- Venomshroud Cape
	[14441]=":7167:4:2:1:::1:0:", -- Venomshroud Mask
	[14442]=":4481:4:2:1:::1:0:", -- Venomshroud Mitts
	[14443]=":6745:4:2:1:::1:0:", -- Venomshroud Mantle
	[14444]=":10955:4:2:1:::1:0:", -- Venomshroud Leggings
	[14445]=":12353:4:2:1:::1:0:", -- Venomshroud Silk Robes
	[14446]=":4248:4:2:1:::1:0:", -- Venomshroud Belt
	[14447]=":8801:4:2:1:::1:0:", -- Highborne Footpads
	[14448]=":5555:4:2:1:::1:0:", -- Highborne Bracelets
	[14449]=":10125:4:2:1:::1:0:", -- Highborne Crown
	[14450]=":7364:4:2:1:::1:0:", -- Highborne Cloak
	[14451]=":5537:4:2:1:::1:0:", -- Highborne Gloves
	[14452]=":8836:4:2:1:::1:0:", -- Highborne Pauldrons
	[14453]=":15677:4:2:1:::1:0:", -- Highborne Robes
	[14454]=":5598:4:2:1:::1:0:", -- Highborne Cord
	[14455]=":15792:4:2:1:::1:0:", -- Highborne Padded Armor
	[14456]=":17574:4:2:1:::1:0:", -- Elunarian Vest
	[14457]=":7575:4:2:1:::1:0:", -- Elunarian Cuffs
	[14458]=":12573:4:2:1:::1:0:", -- Elunarian Boots
	[14459]=":10798:4:2:1:::1:0:", -- Elunarian Cloak
	[14460]=":13196:4:2:1:::1:0:", -- Elunarian Diadem
	[14461]=":8711:4:2:1:::1:0:", -- Elunarian Handgrips
	[14462]=":17483:4:2:1:::1:0:", -- Elunarian Sarong
	[14463]=":13160:4:2:1:::1:0:", -- Elunarian Spaulders
	[14464]=":18088:4:2:1:::1:0:", -- Elunarian Silk Robes
	[14465]=":8596:4:2:1:::1:0:", -- Elunarian Belt
	[14466]=":3000:9:2:1:::1:0:", -- Pattern: Frostweave Tunic
	[14467]=":3000:9:2:1:::1:0:", -- Pattern: Frostweave Robe
	[14468]="12000:3000:9:1:1:::1:0:11189", -- Pattern: Runecloth Bag
	[14469]="12000:3000:9:1:1:::1:0:7940", -- Pattern: Runecloth Robe
	[14470]=":3000:9:2:1:::1:0:", -- Pattern: Runecloth Tunic
	[14471]=":3000:9:2:1:::1:0:", -- Pattern: Cindercloth Vest
	[14472]="12000:3000:9:1:1:::1:0:7940", -- Pattern: Runecloth Cloak
	[14473]=":3000:9:2:1:::1:0:", -- Pattern: Ghostweave Belt
	[14474]=":3000:9:2:1:::1:0:", -- Pattern: Frostweave Gloves
	[14476]=":3500:9:2:1:::1:0:", -- Pattern: Cindercloth Gloves
	[14477]=":3500:9:2:1:::1:0:", -- Pattern: Ghostweave Gloves
	[14478]=":3500:9:2:1:::1:0:", -- Pattern: Brightcloth Robe
	[14479]=":3500:9:2:1:::1:0:", -- Pattern: Brightcloth Gloves
	[14480]=":4000:9:2:1:::1:0:", -- Pattern: Ghostweave Vest
	[14481]=":4000:9:1:1:::1:0:", -- Pattern: Runecloth Gloves
	[14482]=":4000:9:2:1:::1:0:", -- Pattern: Cindercloth Cloak
	[14483]="16000:4000:9:1:1:::1:0:12022", -- Pattern: Felcloth Pants
	[14484]=":4000:9:2:1:::1:0:", -- Pattern: Brightcloth Cloak
	[14485]=":4000:9:2:1:::1:0:", -- Pattern: Wizardweave Leggings
	[14486]=":10000:9:3:1:::1:0:", -- Pattern: Cloak of Fire
	[14487]=":49623:2:3:1:::1:0:", -- Bonechill Hammer
	[14488]=":5000:9:1:1:::1:0:", -- Pattern: Runecloth Boots
	[14489]=":5000:9:2:1:::1:0:", -- Pattern: Frostweave Pants
	[14490]=":5000:9:2:1:::1:0:", -- Pattern: Cindercloth Pants
	[14491]=":5000:9:2:1:::1:0:", -- Pattern: Runecloth Pants
	[14492]=":5000:9:2:1:::1:0:", -- Pattern: Felcloth Boots
	[14493]=":5000:9:3:1:::1:0:", -- Pattern: Robe of Winter Night
	[14494]=":5500:9:2:1:::1:0:", -- Pattern: Brightcloth Pants
	[14495]=":5500:9:2:1:::1:0:", -- Pattern: Ghostweave Pants
	[14496]=":5500:9:2:1:::1:0:", -- Pattern: Felcloth Hood
	[14497]=":5500:9:3:1:::1:0:", -- Pattern: Mooncloth Leggings
	[14498]=":6250:9:2:1:::1:0:", -- Pattern: Runecloth Headband
	[14499]=":7500:9:2:1:::1:0:", -- Pattern: Mooncloth Bag
	[14500]=":7500:9:2:1:::1:0:", -- Pattern: Wizardweave Robe
	[14501]=":7500:9:3:1:::1:0:", -- Pattern: Mooncloth Vest
	[14502]=":12169:4:3:1:::1:0:", -- Frostbite Girdle
	[14503]=":18323:4:3:1:::1:0:", -- Death\'s Clutch
	[14504]=":10000:9:2:1:::1:0:", -- Pattern: Runecloth Shoulders
	[14505]=":10000:9:2:1:::1:0:", -- Pattern: Wizardweave Turban
	[14506]=":10000:9:2:1:::1:0:", -- Pattern: Felcloth Robe
	[14507]=":10000:9:3:1:::1:0:", -- Pattern: Mooncloth Shoulders
	[14508]=":15000:9:2:1:::1:0:", -- Pattern: Felcloth Shoulders
	[14509]=":15000:9:3:1:::1:0:", -- Pattern: Mooncloth Circlet
	[14510]=":15000:9:3:1:::1:0:", -- Pattern: Bottomless Bag
	[14511]=":15000:9:4:1:::1:0:", -- Pattern: Gloves of Spell Mastery
	[14512]=":15000:9:4:1:::1:0:", -- Pattern: Truefaith Vestments
	[14513]=":15000:9:4:1:::1:0:", -- Pattern: Robe of the Archmage
	[14514]=":15000:9:4:1:::1:0:", -- Pattern: Robe of the Void
	[14522]=":29200:4:3:1:::1:0:", -- Maelstrom Leggings
	[14523]="::12:1:1:::1:0:", -- Demon Pick
	[14525]=":17330:4:3:1:::1:0:", -- Boneclenched Gauntlets
	[14526]="20000:5000:9:1:1:::1:0:11189", -- Pattern: Mooncloth
	[14528]=":31870:4:3:1:::1:0:", -- Rattlecage Buckler
	[14529]=":425:0:1:20:::1:0:", -- Runecloth Bandage
	[14530]="4000:1000:0:1:20:::1:0:15471,17078", -- Heavy Runecloth Bandage
	[14531]=":59891:2:3:1:::1:0:", -- Frightskull Shaft
	[14536]=":31164:4:3:1:::1:0:", -- Bonebrace Hauberk
	[14537]=":27688:4:3:1:::1:0:", -- Corpselight Greaves
	[14538]=":15908:4:3:1:::1:0:", -- Deadwalker Mantle
	[14539]=":19956:4:3:1:::1:0:", -- Bone Ring Helm
	[14540]="::12:1:1:::1:0:", -- Taragaman the Hungerer\'s Heart
	[14541]=":66079:2:3:1:::1:0:", -- Barovian Family Sword
	[14542]="::12:1:1:::1:0:", -- Kravel\'s Crate
	[14543]=":9770:4:3:1:::1:0:", -- Darkshade Gloves
	[14544]="::12:1:1:::1:0:", -- Lieutenant\'s Insignia
	[14545]=":24612:4:3:1:::1:0:", -- Ghostloom Leggings
	[14546]="::12:1:1:::1:0:", -- Roon\'s Kodo Horn
	[14547]="::12:1:1:::1:0:", -- Hand of Iruxos
	[14548]=":23116:4:3:1:::1:0:", -- Royal Cap Spaulders
	[14549]=":13637:4:4:1:::1:0:", -- Boots of Avoidance
	[14551]=":10601:4:4:1:::1:0:", -- Edgemaster\'s Handguards
	[14552]=":26860:4:4:1:::1:0:", -- Stockade Pauldrons
	[14553]=":17125:4:4:1:::1:0:", -- Sash of Mercy
	[14554]=":48787:4:4:1:::1:0:", -- Cloudkeeper Legplates
	[14555]=":70900:2:4:1:::1:0:", -- Alcor\'s Sunrazor
	[14557]=":17880:4:4:1:::1:0:", -- The Lion Horn of Stormwind
	[14558]=":10500:4:4:1:::1:0:", -- Lady Maye\'s Pendant
	[14559]=":279:4:2:1:::1:0:", -- Prospector\'s Sash
	[14560]=":484:4:2:1:::1:0:", -- Prospector\'s Boots
	[14561]=":245:4:2:1:::1:0:", -- Prospector\'s Cuffs
	[14562]=":1039:4:2:1:::1:0:", -- Prospector\'s Chestpiece
	[14563]=":275:4:2:1:::1:0:", -- Prospector\'s Cloak
	[14564]=":304:4:2:1:::1:0:", -- Prospector\'s Mitts
	[14565]=":809:4:2:1:::1:0:", -- Prospector\'s Woolies
	[14566]=":1010:4:2:1:::1:0:", -- Prospector\'s Pads
	[14567]=":529:4:2:1:::1:0:", -- Bristlebark Belt
	[14568]=":797:4:2:1:::1:0:", -- Bristlebark Boots
	[14569]=":472:4:2:1:::1:0:", -- Bristlebark Bindings
	[14570]=":1870:4:2:1:::1:0:", -- Bristlebark Blouse
	[14571]=":496:4:2:1:::1:0:", -- Bristlebark Cape
	[14572]=":609:4:2:1:::1:0:", -- Bristlebark Gloves
	[14573]=":1289:4:2:1:::1:0:", -- Bristlebark Amice
	[14574]=":1568:4:2:1:::1:0:", -- Bristlebark Britches
	[14576]=":48770:2:3:1:::1:0:", -- Ebon Hilt of Marduk
	[14577]=":20844:4:3:1:::1:0:", -- Skullsmoke Pants
	[14578]=":983:4:2:1:::1:0:", -- Dokebi Cord
	[14579]=":1791:4:2:1:::1:0:", -- Dokebi Boots
	[14580]=":818:4:2:1:::1:0:", -- Dokebi Bracers
	[14581]=":2912:4:2:1:::1:0:", -- Dokebi Chestguard
	[14582]=":1089:4:2:1:::1:0:", -- Dokebi Cape
	[14583]=":1333:4:2:1:::1:0:", -- Dokebi Gloves
	[14584]=":2673:4:2:1:::1:0:", -- Dokebi Hat
	[14585]=":2687:4:2:1:::1:0:", -- Dokebi Leggings
	[14587]=":2030:4:2:1:::1:0:", -- Dokebi Mantle
	[14588]=":1989:4:2:1:::1:0:", -- Hawkeye\'s Cord
	[14589]=":3294:4:2:1:::1:0:", -- Hawkeye\'s Shoes
	[14590]=":1821:4:2:1:::1:0:", -- Hawkeye\'s Bracers
	[14591]=":4180:4:2:1:::1:0:", -- Hawkeye\'s Helm
	[14592]=":5594:4:2:1:::1:0:", -- Hawkeye\'s Tunic
	[14593]=":2210:4:2:1:::1:0:", -- Hawkeye\'s Cloak
	[14594]=":2236:4:2:1:::1:0:", -- Hawkeye\'s Gloves
	[14595]=":4500:4:2:1:::1:0:", -- Hawkeye\'s Breeches
	[14596]=":3388:4:2:1:::1:0:", -- Hawkeye\'s Epaulets
	[14598]=":2655:4:2:1:::1:0:", -- Warden\'s Waistband
	[14599]=":4663:4:2:1:::1:0:", -- Warden\'s Footpads
	[14600]=":2675:4:2:1:::1:0:", -- Warden\'s Wristbands
	[14601]=":7307:4:2:1:::1:0:", -- Warden\'s Wraps
	[14602]=":2995:4:2:1:::1:0:", -- Warden\'s Cloak
	[14603]=":4383:4:2:1:::1:0:", -- Warden\'s Mantle
	[14604]=":5986:4:2:1:::1:0:", -- Warden\'s Wizard Hat
	[14605]=":6868:4:2:1:::1:0:", -- Warden\'s Woolies
	[14606]=":2955:4:2:1:::1:0:", -- Warden\'s Gloves
	[14607]=":5581:4:2:1:::1:0:", -- Hawkeye\'s Buckler
	[14608]=":3162:4:2:1:::1:0:", -- Dokebi Buckler
	[14610]="::12:1:1:::1:0:", -- Araj\'s Scarab
	[14611]=":31394:4:3:1:::1:0:", -- Bloodmail Hauberk
	[14612]=":31503:4:3:1:::1:0:", -- Bloodmail Legguards
	[14613]="::12:1:1:::1:0:", -- Taelan\'s Hammer
	[14614]=":15863:4:3:1:::1:0:", -- Bloodmail Belt
	[14615]=":14404:4:3:1:::1:0:", -- Bloodmail Gauntlets
	[14616]=":21785:4:3:1:::1:0:", -- Bloodmail Boots
	[14617]=":6250:4:1:1:::1:0:", -- Sawbones Shirt
	[14619]="::12:1:20:::1:0:", -- Skeletal Fragments
	[14620]=":17226:4:3:1:::1:0:", -- Deathbone Girdle
	[14621]=":25741:4:3:1:::1:0:", -- Deathbone Sabatons
	[14622]=":17357:4:3:1:::1:0:", -- Deathbone Gauntlets
	[14623]=":34649:4:3:1:::1:0:", -- Deathbone Legguards
	[14624]=":34776:4:3:1:::1:0:", -- Deathbone Chestplate
	[14625]="::12:1:1:::1:0:", -- Symbol of Lost Honor
	[14626]=":20021:4:3:1:::1:0:", -- Necropile Robe
	[14627]="800:200:9:1:1:::1:0:2668", -- Pattern: Bright Yellow Shirt
	[14628]="::12:1:1:::1:0:", -- Imbued Skeletal Fragments
	[14629]=":10389:4:3:1:::1:0:", -- Necropile Cuffs
	[14630]="1000:250:9:1:1:::1:0:2670,12246", -- Pattern: Enchanter\'s Cowl
	[14631]=":15694:4:3:1:::1:0:", -- Necropile Boots
	[14632]=":21000:4:3:1:::1:0:", -- Necropile Leggings
	[14633]=":15806:4:3:1:::1:0:", -- Necropile Mantle
	[14634]="2500:625:9:2:1:::1:0:2480", -- Recipe: Frost Oil
	[14635]="3000:750:9:1:1:::1:0:2699,12245", -- Pattern: Gem-studded Leather Belt
	[14636]=":12048:4:3:1:::1:0:", -- Cadaverous Belt
	[14637]=":24189:4:3:1:::1:0:", -- Cadaverous Armor
	[14638]=":24282:4:3:1:::1:0:", -- Cadaverous Leggings
	[14639]="1500:375:9:1:1:::1:0:2682,2683,3495", -- Schematic: Minor Recombobulator
	[14640]=":12233:4:3:1:::1:0:", -- Cadaverous Gloves
	[14641]=":18420:4:3:1:::1:0:", -- Cadaverous Walkers
	[14644]="::12:1:1:::1:0:", -- Skeleton Key Mold
	[14645]="::12:1:1:::1:0:", -- Unfinished Skeleton Key
	[14646]="::12:1:1:::1:0:", -- Goldshire Gift Voucher
	[14647]="::12:1:1:::1:0:", -- Kharanos Gift Voucher
	[14648]="::12:1:1:::1:0:", -- Dolanaar Gift Voucher
	[14649]="::12:1:1:::1:0:", -- Razor Hill Gift Voucher
	[14650]="::12:1:1:::1:0:", -- Bloodhoof Village Gift Voucher
	[14651]="::12:1:1:::1:0:", -- Brill Gift Voucher
	[14652]=":4216:4:2:1:::1:0:", -- Scorpashi Sash
	[14653]=":6854:4:2:1:::1:0:", -- Scorpashi Slippers
	[14654]=":3931:4:2:1:::1:0:", -- Scorpashi Wristbands
	[14655]=":10392:4:2:1:::1:0:", -- Scorpashi Breastplate
	[14656]=":4300:4:2:1:::1:0:", -- Scorpashi Cape
	[14657]=":4195:4:2:1:::1:0:", -- Scorpashi Gloves
	[14658]=":7884:4:2:1:::1:0:", -- Scorpashi Skullcap
	[14659]=":9382:4:2:1:::1:0:", -- Scorpashi Leggings
	[14660]=":7063:4:2:1:::1:0:", -- Scorpashi Shoulder Pads
	[14661]=":5461:4:2:1:::1:0:", -- Keeper\'s Cord
	[14662]=":9413:4:2:1:::1:0:", -- Keeper\'s Hooves
	[14663]=":5141:4:2:1:::1:0:", -- Keeper\'s Bindings
	[14664]=":15058:4:2:1:::1:0:", -- Keeper\'s Armor
	[14665]=":6214:4:2:1:::1:0:", -- Keeper\'s Cloak
	[14666]=":6367:4:2:1:::1:0:", -- Keeper\'s Gloves
	[14667]=":10770:4:2:1:::1:0:", -- Keeper\'s Wreath
	[14668]=":13597:4:2:1:::1:0:", -- Keeper\'s Woolies
	[14669]=":9654:4:2:1:::1:0:", -- Keeper\'s Mantle
	[14670]=":20396:4:2:1:::1:0:", -- Pridelord Armor
	[14671]=":13012:4:2:1:::1:0:", -- Pridelord Boots
	[14672]=":7309:4:2:1:::1:0:", -- Pridelord Bands
	[14673]=":8303:4:2:1:::1:0:", -- Pridelord Cape
	[14674]=":8270:4:2:1:::1:0:", -- Pridelord Girdle
	[14675]=":8182:4:2:1:::1:0:", -- Pridelord Gloves
	[14676]=":13841:4:2:1:::1:0:", -- Pridelord Halo
	[14677]=":18524:4:2:1:::1:0:", -- Pridelord Pants
	[14678]=":13156:4:2:1:::1:0:", -- Pridelord Pauldrons
	[14679]="::12:1:1:::1:0:", -- Of Love and Family
	[14680]=":21805:4:2:1:::1:0:", -- Indomitable Vest
	[14681]=":15980:4:2:1:::1:0:", -- Indomitable Boots
	[14682]=":9906:4:2:1:::1:0:", -- Indomitable Armguards
	[14683]=":11932:4:2:1:::1:0:", -- Indomitable Cloak
	[14684]=":10477:4:2:1:::1:0:", -- Indomitable Belt
	[14685]=":10810:4:2:1:::1:0:", -- Indomitable Gauntlets
	[14686]=":16495:4:2:1:::1:0:", -- Indomitable Headdress
	[14687]=":21778:4:2:1:::1:0:", -- Indomitable Leggings
	[14688]=":16168:4:2:1:::1:0:", -- Indomitable Epaulets
	[14722]=":424:4:2:1:::1:0:", -- War Paint Anklewraps
	[14723]=":290:4:2:1:::1:0:", -- War Paint Bindings
	[14724]=":253:4:2:1:::1:0:", -- War Paint Cloak
	[14725]=":292:4:2:1:::1:0:", -- War Paint Waistband
	[14726]=":337:4:2:1:::1:0:", -- War Paint Gloves
	[14727]=":778:4:2:1:::1:0:", -- War Paint Legguards
	[14728]=":485:4:1:1:::1:0:", -- War Paint Shoulder Pads
	[14729]=":870:4:2:1:::1:0:", -- War Paint Shield
	[14730]=":1223:4:2:1:::1:0:", -- War Paint Chestpiece
	[14742]=":1118:4:2:1:::1:0:", -- Hulking Boots
	[14743]=":583:4:2:1:::1:0:", -- Hulking Bands
	[14744]=":2310:4:2:1:::1:0:", -- Hulking Chestguard
	[14745]=":444:4:2:1:::1:0:", -- Hulking Cloak
	[14746]=":589:4:2:1:::1:0:", -- Hulking Belt
	[14747]=":668:4:2:1:::1:0:", -- Hulking Gauntlets
	[14748]=":1550:4:2:1:::1:0:", -- Hulking Leggings
	[14749]=":1325:4:2:1:::1:0:", -- Hulking Spaulders
	[14750]=":1068:4:2:1:::1:0:", -- Slayer\'s Cuffs
	[14751]=":3454:4:2:1:::1:0:", -- Slayer\'s Surcoat
	[14752]=":978:4:2:1:::1:0:", -- Slayer\'s Cape
	[14753]=":2610:4:2:1:::1:0:", -- Slayer\'s Skullcap
	[14754]=":1193:4:2:1:::1:0:", -- Slayer\'s Gloves
	[14755]=":1118:4:2:1:::1:0:", -- Slayer\'s Sash
	[14756]=":1860:4:2:1:::1:0:", -- Slayer\'s Slippers
	[14757]=":3298:4:2:1:::1:0:", -- Slayer\'s Pants
	[14758]=":2267:4:2:1:::1:0:", -- Slayer\'s Shoulderguards
	[14759]=":2010:4:2:1:::1:0:", -- Enduring Bracers
	[14760]=":6263:4:2:1:::1:0:", -- Enduring Breastplate
	[14761]=":2024:4:2:1:::1:0:", -- Enduring Belt
	[14762]=":4074:4:2:1:::1:0:", -- Enduring Boots
	[14763]=":1685:4:2:1:::1:0:", -- Enduring Cape
	[14764]=":2250:4:2:1:::1:0:", -- Enduring Gauntlets
	[14765]=":4428:4:2:1:::1:0:", -- Enduring Circlet
	[14766]=":5486:4:2:1:::1:0:", -- Enduring Breeches
	[14767]=":4478:4:2:1:::1:0:", -- Enduring Pauldrons
	[14768]=":8566:4:2:1:::1:0:", -- Ravager\'s Armor
	[14769]=":5554:4:2:1:::1:0:", -- Ravager\'s Sandals
	[14770]=":3172:4:2:1:::1:0:", -- Ravager\'s Armguards
	[14771]=":3030:4:2:1:::1:0:", -- Ravager\'s Cloak
	[14772]=":3284:4:2:1:::1:0:", -- Ravager\'s Handwraps
	[14773]=":3052:4:2:1:::1:0:", -- Ravager\'s Cord
	[14774]=":6252:4:2:1:::1:0:", -- Ravager\'s Crown
	[14775]=":8367:4:2:1:::1:0:", -- Ravager\'s Woolies
	[14776]=":6326:4:2:1:::1:0:", -- Ravager\'s Mantle
	[14777]=":9710:4:2:1:::1:0:", -- Ravager\'s Shield
	[14778]=":4933:4:2:1:::1:0:", -- Khan\'s Bindings
	[14779]=":13347:4:2:1:::1:0:", -- Khan\'s Chestpiece
	[14780]=":14289:4:2:1:::1:0:", -- Khan\'s Buckler
	[14781]=":4617:4:2:1:::1:0:", -- Khan\'s Cloak
	[14782]=":5004:4:2:1:::1:0:", -- Khan\'s Gloves
	[14783]=":5424:4:2:1:::1:0:", -- Khan\'s Belt
	[14784]=":8202:4:2:1:::1:0:", -- Khan\'s Greaves
	[14785]=":9558:4:2:1:::1:0:", -- Khan\'s Helmet
	[14786]=":11841:4:2:1:::1:0:", -- Khan\'s Legguards
	[14787]=":8323:4:2:1:::1:0:", -- Khan\'s Mantle
	[14788]=":6408:4:2:1:::1:0:", -- Protector Armguards
	[14789]=":17541:4:2:1:::1:0:", -- Protector Breastplate
	[14790]=":18781:4:2:1:::1:0:", -- Protector Buckler
	[14791]=":6056:4:2:1:::1:0:", -- Protector Cape
	[14792]=":6960:4:2:1:::1:0:", -- Protector Gauntlets
	[14793]=":6985:4:2:1:::1:0:", -- Protector Waistband
	[14794]=":10563:4:2:1:::1:0:", -- Protector Ankleguards
	[14795]=":12690:4:2:1:::1:0:", -- Protector Helm
	[14796]=":16983:4:2:1:::1:0:", -- Protector Legguards
	[14797]=":11427:4:2:1:::1:0:", -- Protector Pads
	[14798]=":24037:4:2:1:::1:0:", -- Bloodlust Breastplate
	[14799]=":17308:4:2:1:::1:0:", -- Bloodlust Boots
	[14800]=":25826:4:2:1:::1:0:", -- Bloodlust Buckler
	[14801]=":8156:4:2:1:::1:0:", -- Bloodlust Cape
	[14802]=":9749:4:2:1:::1:0:", -- Bloodlust Gauntlets
	[14803]=":9087:4:2:1:::1:0:", -- Bloodlust Belt
	[14804]=":16296:4:2:1:::1:0:", -- Bloodlust Helm
	[14805]=":20577:4:2:1:::1:0:", -- Bloodlust Britches
	[14806]=":15560:4:2:1:::1:0:", -- Bloodlust Epaulets
	[14807]=":8211:4:2:1:::1:0:", -- Bloodlust Bracelets
	[14808]=":11581:4:2:1:::1:0:", -- Warstrike Belt
	[14809]=":18905:4:2:1:::1:0:", -- Warstrike Sabatons
	[14810]=":11669:4:2:1:::1:0:", -- Warstrike Armsplints
	[14811]=":25972:4:2:1:::1:0:", -- Warstrike Chestguard
	[14812]=":27804:4:2:1:::1:0:", -- Warstrike Buckler
	[14813]=":10601:4:2:1:::1:0:", -- Warstrike Cape
	[14814]=":19435:4:2:1:::1:0:", -- Warstrike Helmet
	[14815]=":12830:4:2:1:::1:0:", -- Warstrike Gauntlets
	[14816]=":25752:4:2:1:::1:0:", -- Warstrike Legguards
	[14817]=":19471:4:2:1:::1:0:", -- Warstrike Shoulder Pads
	[14821]=":9258:4:2:1:::1:0:", -- Symbolic Breastplate
	[14825]=":8595:4:2:1:::1:0:", -- Symbolic Crest
	[14826]=":4068:4:2:1:::1:0:", -- Symbolic Gauntlets
	[14827]=":4083:4:2:1:::1:0:", -- Symbolic Belt
	[14828]=":6590:4:2:1:::1:0:", -- Symbolic Greaves
	[14829]=":8837:4:2:1:::1:0:", -- Symbolic Legplates
	[14830]=":6640:4:2:1:::1:0:", -- Symbolic Pauldrons
	[14831]=":7197:4:2:1:::1:0:", -- Symbolic Crown
	[14832]=":4160:4:2:1:::1:0:", -- Symbolic Vambraces
	[14833]=":5260:4:2:1:::1:0:", -- Tyrant\'s Gauntlets
	[14834]=":4889:4:2:1:::1:0:", -- Tyrant\'s Armguards
	[14835]=":14337:4:2:1:::1:0:", -- Tyrant\'s Chestpiece
	[14838]=":5090:4:2:1:::1:0:", -- Tyrant\'s Belt
	[14839]=":8212:4:2:1:::1:0:", -- Tyrant\'s Greaves
	[14840]=":13869:4:2:1:::1:0:", -- Tyrant\'s Legplates
	[14841]=":7484:4:2:1:::1:0:", -- Tyrant\'s Epaulets
	[14842]=":12483:4:2:1:::1:0:", -- Tyrant\'s Shield
	[14843]=":8796:4:2:1:::1:0:", -- Tyrant\'s Helm
	[14844]=":20075:4:2:1:::1:0:", -- Sunscale Chestguard
	[14846]=":7981:4:2:1:::1:0:", -- Sunscale Gauntlets
	[14847]=":7487:4:2:1:::1:0:", -- Sunscale Belt
	[14848]=":11972:4:2:1:::1:0:", -- Sunscale Sabatons
	[14849]=":14448:4:2:1:::1:0:", -- Sunscale Helmet
	[14850]=":18275:4:2:1:::1:0:", -- Sunscale Legplates
	[14851]=":12954:4:2:1:::1:0:", -- Sunscale Spaulders
	[14852]=":19420:4:2:1:::1:0:", -- Sunscale Shield
	[14853]=":7346:4:2:1:::1:0:", -- Sunscale Wristguards
	[14854]=":28358:4:2:1:::1:0:", -- Vanguard Breastplate
	[14855]=":11444:4:2:1:::1:0:", -- Vanguard Gauntlets
	[14856]=":10835:4:2:1:::1:0:", -- Vanguard Girdle
	[14857]=":16185:4:2:1:::1:0:", -- Vanguard Sabatons
	[14858]=":20507:4:2:1:::1:0:", -- Vanguard Headdress
	[14859]=":25936:4:2:1:::1:0:", -- Vanguard Legplates
	[14860]=":18380:4:2:1:::1:0:", -- Vanguard Pauldrons
	[14861]=":8880:4:2:1:::1:0:", -- Vanguard Vambraces
	[14862]=":28887:4:2:1:::1:0:", -- Warleader\'s Breastplate
	[14863]=":13995:4:2:1:::1:0:", -- Warleader\'s Gauntlets
	[14864]=":13380:4:2:1:::1:0:", -- Warleader\'s Belt
	[14865]=":20993:4:2:1:::1:0:", -- Warleader\'s Greaves
	[14866]=":21662:4:2:1:::1:0:", -- Warleader\'s Crown
	[14867]=":29048:4:2:1:::1:0:", -- Warleader\'s Leggings
	[14868]=":22112:4:2:1:::1:0:", -- Warleader\'s Shoulders
	[14869]=":13336:4:2:1:::1:0:", -- Warleader\'s Bracers
	[14872]="::12:1:1:::1:0:", -- Tirion\'s Gift
	[14894]="::0:1:1:::1:0:", -- Lily Root
	[14895]=":8583:4:2:1:::1:0:", -- Saltstone Surcoat
	[14896]=":5970:4:2:1:::1:0:", -- Saltstone Sabatons
	[14897]=":4025:4:2:1:::1:0:", -- Saltstone Gauntlets
	[14898]=":4039:4:2:1:::1:0:", -- Saltstone Girdle
	[14899]=":6517:4:2:1:::1:0:", -- Saltstone Helm
	[14900]=":7521:4:2:1:::1:0:", -- Saltstone Legplates
	[14901]=":6104:4:2:1:::1:0:", -- Saltstone Shoulder Pads
	[14902]=":7482:4:2:1:::1:0:", -- Saltstone Shield
	[14903]=":3825:4:2:1:::1:0:", -- Saltstone Armsplints
	[14904]=":16179:4:2:1:::1:0:", -- Brutish Breastplate
	[14905]=":5662:4:2:1:::1:0:", -- Brutish Gauntlets
	[14906]=":5262:4:2:1:::1:0:", -- Brutish Belt
	[14907]=":10696:4:2:1:::1:0:", -- Brutish Helmet
	[14908]=":14342:4:2:1:::1:0:", -- Brutish Legguards
	[14909]=":8554:4:2:1:::1:0:", -- Brutish Shoulders
	[14910]=":5339:4:2:1:::1:0:", -- Brutish Armguards
	[14911]=":9305:4:2:1:::1:0:", -- Brutish Boots
	[14912]=":15232:4:2:1:::1:0:", -- Brutish Shield
	[14913]=":11698:4:2:1:::1:0:", -- Jade Greaves
	[14914]=":6318:4:2:1:::1:0:", -- Jade Bracers
	[14915]=":20246:4:2:1:::1:0:", -- Jade Breastplate
	[14916]=":17254:4:2:1:::1:0:", -- Jade Deflector
	[14917]=":6920:4:2:1:::1:0:", -- Jade Gauntlets
	[14918]=":6432:4:2:1:::1:0:", -- Jade Belt
	[14919]=":13480:4:2:1:::1:0:", -- Jade Circlet
	[14920]=":17053:4:2:1:::1:0:", -- Jade Legplates
	[14921]=":11191:4:2:1:::1:0:", -- Jade Epaulets
	[14922]=":14451:4:2:1:::1:0:", -- Lofty Sabatons
	[14923]=":8104:4:2:1:::1:0:", -- Lofty Armguards
	[14924]=":24555:4:2:1:::1:0:", -- Lofty Breastplate
	[14925]=":18448:4:2:1:::1:0:", -- Lofty Helm
	[14926]=":9852:4:2:1:::1:0:", -- Lofty Gauntlets
	[14927]=":9329:4:2:1:::1:0:", -- Lofty Belt
	[14928]=":22179:4:2:1:::1:0:", -- Lofty Legguards
	[14929]=":15719:4:2:1:::1:0:", -- Lofty Shoulder Pads
	[14930]=":22950:4:2:1:::1:0:", -- Lofty Shield
	[14931]=":30265:4:2:1:::1:0:", -- Heroic Armor
	[14932]=":20583:4:2:1:::1:0:", -- Heroic Greaves
	[14933]=":13876:4:2:1:::1:0:", -- Heroic Gauntlets
	[14934]=":11887:4:2:1:::1:0:", -- Heroic Girdle
	[14935]=":20760:4:2:1:::1:0:", -- Heroic Skullcap
	[14936]=":28227:4:2:1:::1:0:", -- Heroic Legplates
	[14937]=":19923:4:2:1:::1:0:", -- Heroic Pauldrons
	[14938]=":11387:4:2:1:::1:0:", -- Heroic Bracers
	[14939]=":11888:4:2:1:::1:0:", -- Warbringer\'s Chestguard
	[14940]=":7090:4:2:1:::1:0:", -- Warbringer\'s Sabatons 
	[14941]=":4427:4:2:1:::1:0:", -- Warbringer\'s Armsplints
	[14942]=":4443:4:2:1:::1:0:", -- Warbringer\'s Gauntlets
	[14943]=":4460:4:2:1:::1:0:", -- Warbringer\'s Belt
	[14944]=":8395:4:2:1:::1:0:", -- Warbringer\'s Crown
	[14945]=":11257:4:2:1:::1:0:", -- Warbringer\'s Legguards
	[14946]=":7251:4:2:1:::1:0:", -- Warbringer\'s Spaulders
	[14947]=":11198:4:2:1:::1:0:", -- Warbringer\'s Shield
	[14948]=":18028:4:2:1:::1:0:", -- Bloodforged Chestpiece
	[14949]=":6876:4:2:1:::1:0:", -- Bloodforged Gauntlets
	[14950]=":6390:4:2:1:::1:0:", -- Bloodforged Belt
	[14951]=":10309:4:2:1:::1:0:", -- Bloodforged Sabatons
	[14952]=":12792:4:2:1:::1:0:", -- Bloodforged Helmet
	[14953]=":16028:4:2:1:::1:0:", -- Bloodforged Legplates
	[14954]=":15234:4:2:1:::1:0:", -- Bloodforged Shield
	[14955]=":9463:4:2:1:::1:0:", -- Bloodforged Shoulder Pads
	[14956]=":5471:4:2:1:::1:0:", -- Bloodforged Bindings
	[14957]=":12617:4:2:1:::1:0:", -- High Chief\'s Sabatons
	[14958]=":22643:4:2:1:::1:0:", -- High Chief\'s Armor
	[14959]=":9052:4:2:1:::1:0:", -- High Chief\'s Gauntlets
	[14960]=":8572:4:2:1:::1:0:", -- High Chief\'s Belt
	[14961]=":16172:4:2:1:::1:0:", -- High Chief\'s Crown
	[14962]=":20458:4:2:1:::1:0:", -- High Chief\'s Legguards
	[14963]=":14501:4:2:1:::1:0:", -- High Chief\'s Pauldrons
	[14964]=":21741:4:2:1:::1:0:", -- High Chief\'s Shield
	[14965]=":7833:4:2:1:::1:0:", -- High Chief\'s Bindings
	[14966]=":30083:4:2:1:::1:0:", -- Glorious Breastplate
	[14967]=":12087:4:2:1:::1:0:", -- Glorious Gauntlets
	[14968]=":11444:4:2:1:::1:0:", -- Glorious Belt
	[14969]=":21381:4:2:1:::1:0:", -- Glorious Headdress
	[14970]=":27297:4:2:1:::1:0:", -- Glorious Legplates
	[14971]=":19346:4:2:1:::1:0:", -- Glorious Shoulder Pads
	[14972]=":18316:4:2:1:::1:0:", -- Glorious Sabatons
	[14973]=":27810:4:2:1:::1:0:", -- Glorious Shield
	[14974]=":10576:4:2:1:::1:0:", -- Glorious Bindings
	[14975]=":29662:4:2:1:::1:0:", -- Exalted Harness
	[14976]=":14191:4:2:1:::1:0:", -- Exalted Gauntlets
	[14977]=":14049:4:2:1:::1:0:", -- Exalted Girdle
	[14978]=":21873:4:2:1:::1:0:", -- Exalted Sabatons
	[14979]=":22251:4:2:1:::1:0:", -- Exalted Helmet
	[14980]=":30244:4:2:1:::1:0:", -- Exalted Legplates
	[14981]=":22417:4:2:1:::1:0:", -- Exalted Epaulets
	[14982]=":28601:4:2:1:::1:0:", -- Exalted Shield
	[14983]=":14054:4:2:1:::1:0:", -- Exalted Armsplints
	[15002]="::12:1:1:::1:0:", -- Nimboya\'s Pike
	[15003]=":20:4:1:1:::1:0:", -- Primal Belt
	[15004]=":42:4:1:1:::1:0:", -- Primal Boots
	[15005]=":28:4:1:1:::1:0:", -- Primal Bands
	[15006]=":73:4:1:1:::1:0:", -- Primal Buckler
	[15007]=":24:4:1:1:::1:0:", -- Primal Cape
	[15008]=":37:4:1:1:::1:0:", -- Primal Mitts
	[15009]=":162:4:2:1:::1:0:", -- Primal Leggings
	[15010]=":163:4:2:1:::1:0:", -- Primal Wraps
	[15011]=":184:4:2:1:::1:0:", -- Lupine Cord
	[15012]=":296:4:2:1:::1:0:", -- Lupine Slippers
	[15013]=":86:4:1:1:::1:0:", -- Lupine Cuffs
	[15014]=":585:4:2:1:::1:0:", -- Lupine Buckler
	[15015]=":86:4:1:1:::1:0:", -- Lupine Cloak
	[15016]=":200:4:2:1:::1:0:", -- Lupine Handwraps
	[15017]=":611:4:2:1:::1:0:", -- Lupine Leggings
	[15018]=":706:4:2:1:::1:0:", -- Lupine Vest
	[15019]=":366:4:1:1:::1:0:", -- Lupine Mantle
	[15042]="::12:1:1:::1:0:", -- Empty Termite Jar
	[15043]="::12:1:100:::1:0:", -- Plagueland Termites
	[15044]="::12:1:1:::1:0:", -- Barrel of Plagueland Termites
	[15045]=":19938:4:3:1:::1:0:", -- Green Dragonscale Breastplate
	[15046]=":22482:4:3:1:::1:0:", -- Green Dragonscale Leggings
	[15047]=":28812:4:3:1:::1:0:", -- Red Dragonscale Breastplate
	[15048]=":24409:4:3:1:::1:0:", -- Blue Dragonscale Breastplate
	[15049]=":20543:4:3:1:::1:0:", -- Blue Dragonscale Shoulders
	[15050]=":26071:4:3:1:::1:0:", -- Black Dragonscale Breastplate
	[15051]=":21736:4:3:1:::1:0:", -- Black Dragonscale Shoulders
	[15052]=":29774:4:3:1:::1:0:", -- Black Dragonscale Leggings
	[15053]=":17275:4:2:1:::1:0:", -- Volcanic Breastplate
	[15054]=":14559:4:2:1:::1:0:", -- Volcanic Leggings
	[15055]=":15470:4:2:1:::1:0:", -- Volcanic Shoulders
	[15056]=":20966:4:3:1:::1:0:", -- Stormshroud Armor
	[15057]=":18728:4:3:1:::1:0:", -- Stormshroud Pants
	[15058]=":17631:4:3:1:::1:0:", -- Stormshroud Shoulders
	[15059]=":24776:4:3:1:::1:0:", -- Living Breastplate
	[15060]=":21277:4:3:1:::1:0:", -- Living Leggings
	[15061]=":13803:4:3:1:::1:0:", -- Living Shoulders
	[15062]=":25709:4:3:1:::1:0:", -- Devilsaur Leggings
	[15063]=":11701:4:3:1:::1:0:", -- Devilsaur Gauntlets
	[15064]=":19717:4:3:1:::1:0:", -- Warbear Harness
	[15065]=":22233:4:3:1:::1:0:", -- Warbear Woolies
	[15066]=":23650:4:3:1:::1:0:", -- Ironfeather Breastplate
	[15067]=":12758:4:3:1:::1:0:", -- Ironfeather Shoulders
	[15068]=":20359:4:2:1:::1:0:", -- Frostsaber Tunic
	[15069]=":17013:4:2:1:::1:0:", -- Frostsaber Leggings
	[15070]=":9504:4:2:1:::1:0:", -- Frostsaber Gloves
	[15071]=":11443:4:2:1:::1:0:", -- Frostsaber Boots
	[15072]=":16234:4:2:1:::1:0:", -- Chimeric Leggings
	[15073]=":11530:4:2:1:::1:0:", -- Chimeric Boots
	[15074]=":6867:4:2:1:::1:0:", -- Chimeric Gloves
	[15075]=":18449:4:2:1:::1:0:", -- Chimeric Vest
	[15076]=":16604:4:2:1:::1:0:", -- Heavy Scorpid Vest
	[15077]=":7615:4:2:1:::1:0:", -- Heavy Scorpid Bracers
	[15078]=":9649:4:2:1:::1:0:", -- Heavy Scorpid Gauntlet
	[15079]=":21760:4:2:1:::1:0:", -- Heavy Scorpid Leggings
	[15080]=":18230:4:2:1:::1:0:", -- Heavy Scorpid Helm
	[15081]=":19566:4:2:1:::1:0:", -- Heavy Scorpid Shoulders
	[15082]=":10375:4:2:1:::1:0:", -- Heavy Scorpid Belt
	[15083]=":6872:4:2:1:::1:0:", -- Wicked Leather Gauntlets
	[15084]=":7311:4:2:1:::1:0:", -- Wicked Leather Bracers
	[15085]=":21952:4:2:1:::1:0:", -- Wicked Leather Armor
	[15086]=":13154:4:2:1:::1:0:", -- Wicked Leather Headband
	[15087]=":17892:4:2:1:::1:0:", -- Wicked Leather Pants
	[15088]=":9901:4:2:1:::1:0:", -- Wicked Leather Belt
	[15090]=":20514:4:2:1:::1:0:", -- Runic Leather Armor
	[15091]=":7195:4:2:1:::1:0:", -- Runic Leather Gauntlets
	[15092]=":7656:4:2:1:::1:0:", -- Runic Leather Bracers
	[15093]=":8368:4:2:1:::1:0:", -- Runic Leather Belt
	[15094]=":14155:4:2:1:::1:0:", -- Runic Leather Headband
	[15095]=":20885:4:2:1:::1:0:", -- Runic Leather Pants
	[15096]=":16161:4:2:1:::1:0:", -- Runic Leather Shoulders
	[15102]="::15:1:1:::1:0:", -- Un\'Goro Tested Sample
	[15103]="::15:1:1:::1:0:", -- Corrupt Tested Sample
	[15104]=":3825:4:3:1:::1:0:", -- Wingborne Boots
	[15105]=":14397:2:2:1:::1:0:", -- Staff of Noh\'Orahil
	[15106]=":14447:2:2:1:::1:0:", -- Staff of Dar\'Orahil
	[15107]=":5000:4:3:1:::1:0:", -- Orb of Noh\'Orahil
	[15108]=":5000:4:3:1:::1:0:", -- Orb of Dar\'Orahil
	[15109]=":3344:2:2:1:::1:0:", -- Staff of Soran\'ruk
	[15110]=":351:4:2:1:::1:0:", -- Rigid Belt
	[15111]=":609:4:2:1:::1:0:", -- Rigid Moccasins
	[15112]=":354:4:2:1:::1:0:", -- Rigid Bracelets
	[15113]=":1361:4:2:1:::1:0:", -- Rigid Buckler
	[15114]=":372:4:2:1:::1:0:", -- Rigid Cape
	[15115]=":474:4:2:1:::1:0:", -- Rigid Gloves
	[15116]=":1163:4:2:1:::1:0:", -- Rigid Shoulders
	[15117]=":1219:4:2:1:::1:0:", -- Rigid Leggings
	[15118]=":1562:4:2:1:::1:0:", -- Rigid Tunic
	[15119]=":13683:4:2:1:::1:0:", -- Highborne Pants
	[15120]=":787:4:2:1:::1:0:", -- Robust Girdle
	[15121]=":1433:4:2:1:::1:0:", -- Robust Boots
	[15122]=":701:4:2:1:::1:0:", -- Robust Bracers
	[15123]=":2463:4:2:1:::1:0:", -- Robust Buckler
	[15124]=":847:4:2:1:::1:0:", -- Robust Cloak
	[15125]=":991:4:2:1:::1:0:", -- Robust Gloves
	[15126]=":1989:4:2:1:::1:0:", -- Robust Leggings
	[15127]=":1647:4:2:1:::1:0:", -- Robust Shoulders
	[15128]=":2425:4:2:1:::1:0:", -- Robust Tunic
	[15129]=":1825:4:2:1:::1:0:", -- Robust Helm
	[15130]=":3252:4:2:1:::1:0:", -- Cutthroat\'s Vest
	[15131]=":2023:4:2:1:::1:0:", -- Cutthroat\'s Boots
	[15132]=":1017:4:2:1:::1:0:", -- Cutthroat\'s Armguards
	[15133]=":3827:4:2:1:::1:0:", -- Cutthroat\'s Buckler
	[15134]=":3295:4:2:1:::1:0:", -- Cutthroat\'s Hat
	[15135]=":1357:4:2:1:::1:0:", -- Cutthroat\'s Cape
	[15136]=":1249:4:2:1:::1:0:", -- Cutthroat\'s Belt
	[15137]=":1516:4:2:1:::1:0:", -- Cutthroat\'s Mitts
	[15138]=":15198:4:3:1:::1:0:", -- Onyxia Scale Cloak
	[15139]=":3055:4:2:1:::1:0:", -- Cutthroat\'s Pants
	[15140]=":2530:4:2:1:::1:0:", -- Cutthroat\'s Mantle
	[15142]=":2603:4:2:1:::1:0:", -- Ghostwalker Boots
	[15143]=":1439:4:2:1:::1:0:", -- Ghostwalker Bindings
	[15144]=":4232:4:2:1:::1:0:", -- Ghostwalker Rags
	[15145]=":4943:4:2:1:::1:0:", -- Ghostwalker Buckler
	[15146]=":3730:4:2:1:::1:0:", -- Ghostwalker Crown
	[15147]=":1754:4:2:1:::1:0:", -- Ghostwalker Cloak
	[15148]=":1614:4:2:1:::1:0:", -- Ghostwalker Belt
	[15149]=":1960:4:2:1:::1:0:", -- Ghostwalker Gloves
	[15150]=":2951:4:2:1:::1:0:", -- Ghostwalker Pads
	[15151]=":3949:4:2:1:::1:0:", -- Ghostwalker Legguards
	[15152]=":4449:4:2:1:::1:0:", -- Nocturnal Shoes
	[15153]=":2626:4:2:1:::1:0:", -- Nocturnal Cloak
	[15154]=":2372:4:2:1:::1:0:", -- Nocturnal Sash
	[15155]=":2571:4:2:1:::1:0:", -- Nocturnal Gloves
	[15156]=":5266:4:2:1:::1:0:", -- Nocturnal Cap
	[15157]=":6200:4:2:1:::1:0:", -- Nocturnal Leggings
	[15158]=":4320:4:2:1:::1:0:", -- Nocturnal Shoulder Pads
	[15159]=":6743:4:2:1:::1:0:", -- Nocturnal Tunic
	[15160]=":2430:4:2:1:::1:0:", -- Nocturnal Wristbands
	[15161]=":3319:4:2:1:::1:0:", -- Imposing Belt
	[15162]=":5829:4:2:1:::1:0:", -- Imposing Boots
	[15163]=":3344:4:2:1:::1:0:", -- Imposing Bracers
	[15164]=":9135:4:2:1:::1:0:", -- Imposing Vest
	[15165]=":3744:4:2:1:::1:0:", -- Imposing Cape
	[15166]=":3945:4:2:1:::1:0:", -- Imposing Gloves
	[15167]=":7484:4:2:1:::1:0:", -- Imposing Bandana
	[15168]=":7951:4:2:1:::1:0:", -- Imposing Pants
	[15169]=":5542:4:2:1:::1:0:", -- Imposing Shoulders
	[15170]=":13104:4:2:1:::1:0:", -- Potent Armor
	[15171]=":8697:4:2:1:::1:0:", -- Potent Boots
	[15172]=":4706:4:2:1:::1:0:", -- Potent Bands
	[15173]=":5387:4:2:1:::1:0:", -- Potent Cape
	[15174]=":6017:4:2:1:::1:0:", -- Potent Gloves
	[15175]=":9692:4:2:1:::1:0:", -- Potent Helmet
	[15176]=":12121:4:2:1:::1:0:", -- Potent Pants
	[15177]=":8525:4:2:1:::1:0:", -- Potent Shoulders
	[15178]=":4936:4:2:1:::1:0:", -- Potent Belt
	[15179]=":18593:4:2:1:::1:0:", -- Praetorian Padded Armor
	[15180]=":6686:4:2:1:::1:0:", -- Praetorian Girdle
	[15181]=":11312:4:2:1:::1:0:", -- Praetorian Boots
	[15182]=":5996:4:2:1:::1:0:", -- Praetorian Wristbands
	[15183]=":6751:4:2:1:::1:0:", -- Praetorian Cloak
	[15184]=":7197:4:2:1:::1:0:", -- Praetorian Gloves
	[15185]=":12906:4:2:1:::1:0:", -- Praetorian Coif
	[15186]=":15373:4:2:1:::1:0:", -- Praetorian Leggings
	[15187]=":10918:4:2:1:::1:0:", -- Praetorian Pauldrons
	[15188]=":8702:4:2:1:::1:0:", -- Grand Armguards
	[15189]=":15723:4:2:1:::1:0:", -- Grand Boots
	[15190]=":9614:4:2:1:::1:0:", -- Grand Cloak
	[15191]=":9035:4:2:1:::1:0:", -- Grand Belt
	[15192]=":10596:4:2:1:::1:0:", -- Grand Gauntlets
	[15193]=":16397:4:2:1:::1:0:", -- Grand Crown
	[15194]=":21643:4:2:1:::1:0:", -- Grand Legguards
	[15195]=":22020:4:2:1:::1:0:", -- Grand Breastplate
	[15196]="::4:1:1:::1:0:12805,12781", -- Private\'s Tabard
	[15197]="::4:1:1:::1:0:12799,12793", -- Scout\'s Tabard
	[15198]="::4:1:1:::1:0:12805,12781", -- Knight\'s Colors
	[15199]="::4:1:1:::1:0:12799,12793", -- Stone Guard\'s Herald
	[15200]="::4:3:1:::1:0:12799,12793", -- Senior Sergeant\'s Insignia
	[15202]=":516:4:2:1:::1:0:", -- Wildkeeper Leggings
	[15203]=":621:4:2:1:::1:0:", -- Guststorm Legguards
	[15204]=":779:2:2:1:::1:0:", -- Moonstone Wand
	[15205]=":1063:2:2:1:::1:0:", -- Owlsight Rifle
	[15206]=":857:4:2:1:::1:0:", -- Jadefinger Baton
	[15207]=":914:4:2:1:::1:0:", -- Steelcap Shield
	[15208]="::12:1:1:::1:0:", -- Cenarion Moondust
	[15209]="::12:1:1:::1:0:", -- Relic Bundle
	[15210]=":825:2:2:1:::1:0:", -- Raider Shortsword
	[15211]=":1917:2:2:1:::1:0:", -- Militant Shortsword
	[15212]=":3450:2:2:1:::1:0:", -- Fighter Broadsword
	[15213]=":8165:2:2:1:::1:0:", -- Mercenary Blade
	[15214]=":11356:2:2:1:::1:0:", -- Nobles Brand
	[15215]=":16744:2:2:1:::1:0:", -- Furious Falchion
	[15216]=":25932:2:2:1:::1:0:", -- Rune Sword
	[15217]=":30996:2:2:1:::1:0:", -- Widow Blade
	[15218]=":37048:2:2:1:::1:0:", -- Crystal Sword
	[15219]=":41376:2:2:1:::1:0:", -- Dimensional Blade
	[15220]=":40552:2:2:1:::1:0:", -- Battlefell Sabre
	[15221]=":43545:2:2:1:::1:0:", -- Holy War Sword
	[15222]=":1219:2:2:1:::1:0:", -- Barbed Club
	[15223]=":2376:2:2:1:::1:0:", -- Jagged Star
	[15224]=":2695:2:2:1:::1:0:", -- Battlesmasher
	[15225]=":5958:2:2:1:::1:0:", -- Sequoia Hammer
	[15226]=":8755:2:2:1:::1:0:", -- Giant Club
	[15227]=":21925:2:2:1:::1:0:", -- Diamond-Tip Bludgeon
	[15228]=":28308:2:2:1:::1:0:", -- Smashing Star
	[15229]=":31924:2:2:1:::1:0:", -- Blesswind Hammer
	[15230]=":2755:2:2:1:::1:0:", -- Ridge Cleaver
	[15231]=":5033:2:2:1:::1:0:", -- Splitting Hatchet
	[15232]=":6112:2:2:1:::1:0:", -- Hacking Cleaver
	[15233]=":10476:2:2:1:::1:0:", -- Savage Axe
	[15234]=":11354:2:2:1:::1:0:", -- Greater Scythe
	[15235]=":21091:2:2:1:::1:0:", -- Crescent Edge
	[15236]=":27485:2:2:1:::1:0:", -- Moon Cleaver
	[15237]=":30526:2:2:1:::1:0:", -- Corpse Harvester
	[15238]=":36496:2:2:1:::1:0:", -- Warlord\'s Axe
	[15239]=":40954:2:2:1:::1:0:", -- Felstone Reaver
	[15240]=":42810:2:2:1:::1:0:", -- Demon\'s Claw
	[15241]=":3012:2:2:1:::1:0:", -- Battle Knife
	[15242]=":4426:2:2:1:::1:0:", -- Honed Stiletto
	[15243]=":7871:2:2:1:::1:0:", -- Deadly Kris
	[15244]=":12769:2:2:1:::1:0:", -- Razor Blade
	[15245]=":23284:2:2:1:::1:0:", -- Vorpal Dagger
	[15246]=":42614:2:2:1:::1:0:", -- Demon Blade
	[15247]=":43935:2:2:1:::1:0:", -- Bloodstrike Dagger
	[15248]=":1791:2:2:1:::1:0:", -- Gleaming Claymore
	[15249]=":3877:2:2:1:::1:0:", -- Polished Zweihander
	[15250]=":6895:2:2:1:::1:0:", -- Glimmering Flamberge
	[15251]=":17685:2:2:1:::1:0:", -- Headstriker Sword
	[15252]=":27906:2:2:1:::1:0:", -- Tusker Sword
	[15253]=":31547:2:2:1:::1:0:", -- Beheading Blade
	[15254]=":35584:2:2:1:::1:0:", -- Dark Espadon
	[15255]=":42545:2:2:1:::1:0:", -- Gallant Flamberge
	[15256]=":47531:2:2:1:::1:0:", -- Massacre Sword
	[15257]=":51499:2:2:1:::1:0:", -- Shin Blade
	[15258]=":53805:2:2:1:::1:0:", -- Divine Warblade
	[15259]=":3306:2:2:1:::1:0:", -- Hefty Battlehammer
	[15260]=":11556:2:2:1:::1:0:", -- Stone Hammer
	[15261]=":13530:2:2:1:::1:0:", -- Sequoia Branch
	[15262]=":21552:2:2:1:::1:0:", -- Greater Maul
	[15263]=":28889:2:2:1:::1:0:", -- Royal Mallet
	[15264]=":41517:2:2:1:::1:0:", -- Backbreaker
	[15265]=":46823:2:2:1:::1:0:", -- Painbringer
	[15266]=":52538:2:2:1:::1:0:", -- Fierce Mauler
	[15267]=":54186:2:2:1:::1:0:", -- Brutehammer
	[15268]=":1024:2:2:1:::1:0:", -- Twin-bladed Axe
	[15269]=":3036:2:2:1:::1:0:", -- Massive Battle Axe
	[15270]=":22775:2:2:1:::1:0:", -- Gigantic War Axe
	[15271]=":43701:2:2:1:::1:0:", -- Colossal Great Axe
	[15272]=":51740:2:2:1:::1:0:", -- Razor Axe
	[15273]=":51401:2:2:1:::1:0:", -- Death Striker
	[15274]=":31666:2:2:1:::1:0:", -- Diviner Long Staff
	[15275]=":35714:2:2:1:::1:0:", -- Thaumaturgist Staff
	[15276]=":45263:2:2:1:::1:0:", -- Magus Long Staff
	[15277]="100000::15:3:1:::1:0:3685", -- Gray Kodo
	[15278]=":50286:2:2:1:::1:0:", -- Solstice Staff
	[15279]=":18267:2:2:1:::1:0:", -- Ivory Wand
	[15280]=":20603:2:2:1:::1:0:", -- Wizard\'s Hand
	[15281]=":26110:2:2:1:::1:0:", -- Glowstar Rod
	[15282]=":30628:2:2:1:::1:0:", -- Dragon Finger
	[15283]=":32459:2:2:1:::1:0:", -- Lunar Wand
	[15284]=":3039:2:2:1:::1:0:", -- Long Battle Bow
	[15285]=":4061:2:2:1:::1:0:", -- Archer\'s Longbow
	[15286]=":5568:2:2:1:::1:0:", -- Long Redwood Bow
	[15287]=":12516:2:2:1:::1:0:", -- Crusader Bow
	[15288]=":32585:2:2:1:::1:0:", -- Blasthorn Bow
	[15289]=":34505:2:2:1:::1:0:", -- Archstrike Bow
	[15290]="100000::15:3:1:::1:0:3685", -- Brown Kodo
	[15291]=":19591:2:2:1:::1:0:", -- Harpy Needler
	[15292]="::15:4:1:::1:0:", -- Green Kodo
	[15293]="::15:4:1:::1:0:", -- Teal Kodo
	[15294]=":20135:2:2:1:::1:0:", -- Siege Bow
	[15295]=":22712:2:2:1:::1:0:", -- Quillfire Bow
	[15296]=":31193:2:2:1:::1:0:", -- Hawkeye Bow
	[15297]=":45:4:1:1:::1:0:", -- Grizzly Bracers
	[15298]=":305:4:2:1:::1:0:", -- Grizzly Buckler
	[15299]=":42:4:1:1:::1:0:", -- Grizzly Cape
	[15300]=":86:4:1:1:::1:0:", -- Grizzly Gloves
	[15301]=":108:4:1:1:::1:0:", -- Grizzly Slippers
	[15302]=":47:4:1:1:::1:0:", -- Grizzly Belt
	[15303]=":299:4:2:1:::1:0:", -- Grizzly Pants
	[15304]=":414:4:2:1:::1:0:", -- Grizzly Jerkin
	[15305]=":412:4:2:1:::1:0:", -- Feral Shoes
	[15306]=":208:4:2:1:::1:0:", -- Feral Bindings
	[15307]=":815:4:2:1:::1:0:", -- Feral Buckler
	[15308]=":241:4:2:1:::1:0:", -- Feral Cord
	[15309]=":220:4:2:1:::1:0:", -- Feral Cloak
	[15310]=":279:4:2:1:::1:0:", -- Feral Gloves
	[15311]=":982:4:2:1:::1:0:", -- Feral Harness
	[15312]=":745:4:2:1:::1:0:", -- Feral Leggings
	[15313]=":514:4:1:1:::1:0:", -- Feral Shoulder Pads
	[15314]="::12:1:1:::1:0:", -- Bundle of Relics
	[15322]=":7745:2:2:1:::1:0:", -- Smoothbore Gun
	[15323]=":17791:2:2:1:::1:0:", -- Percussion Shotgun
	[15324]=":25565:2:2:1:::1:0:", -- Burnside Rifle
	[15325]=":31785:2:2:1:::1:0:", -- Sharpshooter Harquebus
	[15326]=":1:15:1:200:::200:0:", -- Broken Gleaming Throwing Axe
	[15327]=":1:15:1:200:::200:0:", -- Broken Wicked Throwing Dagger
	[15328]="::13:1:1:::1:0:", -- Joseph\'s Key
	[15329]=":623:4:2:1:::1:0:", -- Wrangler\'s Belt
	[15330]=":1059:4:2:1:::1:0:", -- Wrangler\'s Boots
	[15331]=":555:4:2:1:::1:0:", -- Wrangler\'s Wristbands
	[15332]=":2263:4:2:1:::1:0:", -- Wrangler\'s Buckler
	[15333]=":537:4:2:1:::1:0:", -- Wrangler\'s Cloak
	[15334]=":828:4:2:1:::1:0:", -- Wrangler\'s Gloves
	[15335]=":580:2:2:1:::1:0:", -- Briarsteel Shortsword
	[15336]=":1669:4:2:1:::1:0:", -- Wrangler\'s Leggings
	[15337]=":2027:4:2:1:::1:0:", -- Wrangler\'s Wraps
	[15338]=":1387:4:2:1:::1:0:", -- Wrangler\'s Mantle
	[15339]=":2466:4:2:1:::1:0:", -- Pathfinder Hat
	[15340]=":1016:4:2:1:::1:0:", -- Pathfinder Cloak
	[15341]=":1697:4:2:1:::1:0:", -- Pathfinder Footpads
	[15342]=":2907:4:2:1:::1:0:", -- Pathfinder Guard
	[15343]=":1139:4:2:1:::1:0:", -- Pathfinder Gloves
	[15344]=":2516:4:2:1:::1:0:", -- Pathfinder Pants
	[15345]=":1894:4:2:1:::1:0:", -- Pathfinder Shoulder Pads
	[15346]=":2788:4:2:1:::1:0:", -- Pathfinder Vest
	[15347]=":955:4:2:1:::1:0:", -- Pathfinder Belt
	[15348]=":792:4:2:1:::1:0:", -- Pathfinder Bracers
	[15349]=":1550:4:2:1:::1:0:", -- Headhunter\'s Belt
	[15350]=":2385:4:2:1:::1:0:", -- Headhunter\'s Slippers
	[15351]=":1090:4:2:1:::1:0:", -- Headhunter\'s Bands
	[15352]=":4101:4:2:1:::1:0:", -- Headhunter\'s Buckler
	[15353]=":3467:4:2:1:::1:0:", -- Headhunter\'s Headdress
	[15354]=":1600:4:2:1:::1:0:", -- Headhunter\'s Cloak
	[15355]=":1620:4:2:1:::1:0:", -- Headhunter\'s Mitts
	[15356]=":3935:4:2:1:::1:0:", -- Headhunter\'s Armor
	[15357]=":2693:4:2:1:::1:0:", -- Headhunter\'s Spaulders
	[15358]=":3604:4:2:1:::1:0:", -- Headhunter\'s Woolies
	[15359]=":5955:4:2:1:::1:0:", -- Trickster\'s Vest
	[15360]=":2372:4:2:1:::1:0:", -- Trickster\'s Bindings
	[15361]=":2204:4:2:1:::1:0:", -- Trickster\'s Sash
	[15362]=":3871:4:2:1:::1:0:", -- Trickster\'s Boots
	[15363]=":4894:4:2:1:::1:0:", -- Trickster\'s Headdress
	[15364]=":2431:4:2:1:::1:0:", -- Trickster\'s Cloak
	[15365]=":2415:4:2:1:::1:0:", -- Trickster\'s Handwraps
	[15366]=":5250:4:2:1:::1:0:", -- Trickster\'s Leggings
	[15367]=":6246:4:2:1:::1:0:", -- Trickster\'s Protector
	[15368]=":3674:4:2:1:::1:0:", -- Trickster\'s Pauldrons
	[15369]=":3097:4:2:1:::1:0:", -- Wolf Rider\'s Belt
	[15370]=":5439:4:2:1:::1:0:", -- Wolf Rider\'s Boots
	[15371]=":3467:4:2:1:::1:0:", -- Wolf Rider\'s Cloak
	[15372]=":3383:4:2:1:::1:0:", -- Wolf Rider\'s Gloves
	[15373]=":6930:4:2:1:::1:0:", -- Wolf Rider\'s Headgear
	[15374]=":7363:4:2:1:::1:0:", -- Wolf Rider\'s Leggings
	[15375]=":5132:4:2:1:::1:0:", -- Wolf Rider\'s Shoulder Pads
	[15376]=":8653:4:2:1:::1:0:", -- Wolf Rider\'s Padded Armor
	[15377]=":3191:4:2:1:::1:0:", -- Wolf Rider\'s Wristbands
	[15378]=":4358:4:2:1:::1:0:", -- Rageclaw Belt
	[15379]=":7654:4:2:1:::1:0:", -- Rageclaw Boots
	[15380]=":4391:4:2:1:::1:0:", -- Rageclaw Bracers
	[15381]=":12593:4:2:1:::1:0:", -- Rageclaw Chestguard
	[15382]=":5043:4:2:1:::1:0:", -- Rageclaw Cloak
	[15383]=":5313:4:2:1:::1:0:", -- Rageclaw Gloves
	[15384]=":9155:4:2:1:::1:0:", -- Rageclaw Helm
	[15385]=":11449:4:2:1:::1:0:", -- Rageclaw Leggings
	[15386]=":7287:4:2:1:::1:0:", -- Rageclaw Shoulder Pads
	[15387]=":5584:4:2:1:::1:0:", -- Jadefire Bracelets
	[15388]=":6357:4:2:1:::1:0:", -- Jadefire Belt
	[15389]=":10146:4:2:1:::1:0:", -- Jadefire Sabatons
	[15390]=":16175:4:2:1:::1:0:", -- Jadefire Chestguard
	[15391]=":12178:4:2:1:::1:0:", -- Jadefire Cap
	[15392]=":6382:4:2:1:::1:0:", -- Jadefire Cloak
	[15393]=":6479:4:2:1:::1:0:", -- Jadefire Gloves
	[15394]=":14615:4:2:1:::1:0:", -- Jadefire Pants
	[15395]=":10379:4:2:1:::1:0:", -- Jadefire Epaulets
	[15396]=":582:2:2:1:::1:0:", -- Curvewood Dagger
	[15397]=":731:2:2:1:::1:0:", -- Oakthrush Staff
	[15398]=":108:4:1:1:::1:0:", -- Sandcomber Boots
	[15399]=":151:4:2:1:::1:0:", -- Dryweed Belt
	[15400]=":109:4:1:1:::1:0:", -- Clamshell Bracers
	[15401]=":73:4:1:1:::1:0:", -- Welldrip Gloves
	[15402]=":110:4:1:1:::1:0:", -- Noosegrip Gauntlets
	[15403]=":280:4:2:1:::1:0:", -- Ridgeback Bracers
	[15404]=":337:4:2:1:::1:0:", -- Breakwater Girdle
	[15405]=":245:4:2:1:::1:0:", -- Shucking Gloves
	[15406]=":402:4:2:1:::1:0:", -- Crustacean Boots
	[15407]=":500:7:1:20::202,165:1:0:", -- Cured Rugged Hide
	[15408]=":500:7:1:20::165:1:0:", -- Heavy Scorpid Scale
	[15409]=":1000:7:1:20::165:1:0:", -- Refined Deeprock Salt
	[15410]=":5000:7:3:20::165:1:0:", -- Scale of Onyxia
	[15411]=":10283:4:3:1:::1:0:", -- Mark of Fordring
	[15412]=":500:7:1:20::165:1:0:", -- Green Dragonscale
	[15413]=":35470:4:3:1:::1:0:", -- Ornate Adamantium Breastplate
	[15414]=":1500:7:1:20::165:1:0:", -- Red Dragonscale
	[15415]=":500:7:1:20::165:1:0:", -- Blue Dragonscale
	[15416]=":1000:7:1:20::165:1:0:", -- Black Dragonscale
	[15417]=":500:7:1:20::164,165:1:0:", -- Devilsaur Leather
	[15418]=":66242:2:3:1:::1:0:", -- Shimmering Platinum Warhammer
	[15419]=":600:7:1:20::165:1:0:", -- Warbear Leather
	[15420]=":100:7:1:50::165:1:0:", -- Ironfeather
	[15421]=":16070:4:3:1:::1:0:", -- Shroud of the Exile
	[15422]=":500:7:1:20::165:1:0:", -- Frostsaber Leather
	[15423]=":500:7:1:20::165:1:0:", -- Chimera Leather
	[15424]=":1404:2:2:1:::1:0:", -- Axe of Orgrimmar
	[15425]=":8273:4:2:1:::1:0:", -- Peerless Bracers
	[15426]=":13419:4:2:1:::1:0:", -- Peerless Boots
	[15427]=":8536:4:2:1:::1:0:", -- Peerless Cloak
	[15428]=":8024:4:2:1:::1:0:", -- Peerless Belt
	[15429]=":9049:4:2:1:::1:0:", -- Peerless Gloves
	[15430]=":15435:4:2:1:::1:0:", -- Peerless Headband
	[15431]=":19673:4:2:1:::1:0:", -- Peerless Leggings
	[15432]=":14104:4:2:1:::1:0:", -- Peerless Shoulders
	[15433]=":21099:4:2:1:::1:0:", -- Peerless Armor
	[15434]=":10588:4:2:1:::1:0:", -- Supreme Sash
	[15435]=":16380:4:2:1:::1:0:", -- Supreme Shoes
	[15436]=":10519:4:2:1:::1:0:", -- Supreme Bracers
	[15437]=":12845:4:2:1:::1:0:", -- Supreme Cape
	[15438]=":11039:4:2:1:::1:0:", -- Supreme Gloves
	[15439]=":16841:4:2:1:::1:0:", -- Supreme Crown
	[15440]=":22238:4:2:1:::1:0:", -- Supreme Leggings
	[15441]=":16737:4:2:1:::1:0:", -- Supreme Shoulders
	[15442]=":22996:4:2:1:::1:0:", -- Supreme Breastplate
	[15443]=":1119:2:2:1:::1:0:", -- Kris of Orgrimmar
	[15444]=":1404:2:2:1:::1:0:", -- Staff of Orgrimmar
	[15445]=":1127:2:2:1:::1:0:", -- Hammer of Orgrimmar
	[15447]="::12:1:1:::1:0:", -- Living Rot
	[15448]="::12:1:1:::1:0:", -- Coagulated Rot
	[15449]=":425:4:2:1:::1:0:", -- Ghastly Trousers
	[15450]=":534:4:2:1:::1:0:", -- Dredgemire Leggings
	[15451]=":643:4:2:1:::1:0:", -- Gargoyle Leggings
	[15452]=":215:4:2:1:::1:0:", -- Featherbead Bracers
	[15453]=":270:4:2:1:::1:0:", -- Savannah Bracers
	[15454]="::12:1:1:::1:0:", -- Mortar and Pestle
	[15455]=":3541:4:2:1:::1:0:", -- Dustfall Robes
	[15456]=":4442:4:2:1:::1:0:", -- Lightstep Leggings
	[15457]=":1134:4:2:1:::1:0:", -- Desert Shoulders
	[15458]=":1423:4:2:1:::1:0:", -- Tundra Boots
	[15459]=":1142:4:2:1:::1:0:", -- Grimtoll Wristguards
	[15461]=":841:4:2:1:::1:0:", -- Lightheel Boots
	[15462]=":653:4:2:1:::1:0:", -- Loamflake Bracers
	[15463]=":787:4:2:1:::1:0:", -- Palestrider Gloves
	[15464]=":4504:2:2:1:::1:0:", -- Brute Hammer
	[15465]=":2713:2:2:1:::1:0:", -- Stingshot Wand
	[15466]=":2324:4:2:1:::1:0:", -- Clink Shield
	[15467]=":8630:4:2:1:::1:0:", -- Inventor\'s League Ring
	[15468]=":1207:4:2:1:::1:0:", -- Windsong Drape
	[15469]=":1009:4:2:1:::1:0:", -- Windsong Cinch
	[15470]=":2432:4:2:1:::1:0:", -- Plainsguard Leggings
	[15471]=":2034:4:2:1:::1:0:", -- Brawnhide Armor
	[15472]=":33:4:1:1:::1:0:", -- Charger\'s Belt
	[15473]=":65:4:1:1:::1:0:", -- Charger\'s Boots
	[15474]=":24:4:1:1:::1:0:", -- Charger\'s Bindings
	[15475]=":24:4:1:1:::1:0:", -- Charger\'s Cloak
	[15476]=":44:4:1:1:::1:0:", -- Charger\'s Handwraps
	[15477]=":192:4:2:1:::1:0:", -- Charger\'s Pants
	[15478]=":52:4:1:1:::1:0:", -- Charger\'s Shield
	[15479]=":179:4:2:1:::1:0:", -- Charger\'s Armor
	[15480]=":84:4:1:1:::1:0:", -- War Torn Girdle
	[15481]=":127:4:1:1:::1:0:", -- War Torn Greaves
	[15482]=":54:4:1:1:::1:0:", -- War Torn Bands
	[15483]=":42:4:1:1:::1:0:", -- War Torn Cape
	[15484]=":68:4:1:1:::1:0:", -- War Torn Handgrips
	[15485]=":344:4:2:1:::1:0:", -- War Torn Pants
	[15486]=":245:4:2:1:::1:0:", -- War Torn Shield
	[15487]=":479:4:2:1:::1:0:", -- War Torn Tunic
	[15488]=":967:4:2:1:::1:0:", -- Bloodspattered Surcoat
	[15489]=":363:4:2:1:::1:0:", -- Bloodspattered Sabatons
	[15490]=":105:4:1:1:::1:0:", -- Bloodspattered Cloak
	[15491]=":211:4:2:1:::1:0:", -- Bloodspattered Gloves
	[15492]=":212:4:2:1:::1:0:", -- Bloodspattered Sash
	[15493]=":647:4:2:1:::1:0:", -- Bloodspattered Loincloth
	[15494]=":693:4:2:1:::1:0:", -- Bloodspattered Shield
	[15495]=":220:4:2:1:::1:0:", -- Bloodspattered Wristbands
	[15496]=":462:4:1:1:::1:0:", -- Bloodspattered Shoulder Pads
	[15497]=":387:4:2:1:::1:0:", -- Outrunner\'s Cord
	[15498]=":674:4:2:1:::1:0:", -- Outrunner\'s Slippers
	[15499]=":307:4:2:1:::1:0:", -- Outrunner\'s Cuffs
	[15500]=":1378:4:2:1:::1:0:", -- Outrunner\'s Chestguard
	[15501]=":269:4:2:1:::1:0:", -- Outrunner\'s Cloak
	[15502]=":411:4:2:1:::1:0:", -- Outrunner\'s Gloves
	[15503]=":1091:4:2:1:::1:0:", -- Outrunner\'s Legguards
	[15504]=":1168:4:2:1:::1:0:", -- Outrunner\'s Shield
	[15505]=":561:4:1:1:::1:0:", -- Outrunner\'s Pauldrons
	[15506]=":723:4:2:1:::1:0:", -- Grunt\'s AnkleWraps
	[15507]=":364:4:2:1:::1:0:", -- Grunt\'s Bracers
	[15508]=":365:4:2:1:::1:0:", -- Grunt\'s Cape
	[15509]=":485:4:2:1:::1:0:", -- Grunt\'s Handwraps
	[15510]=":423:4:2:1:::1:0:", -- Grunt\'s Belt
	[15511]=":1474:4:2:1:::1:0:", -- Grunt\'s Legguards
	[15512]=":1578:4:2:1:::1:0:", -- Grunt\'s Shield
	[15513]=":1264:4:2:1:::1:0:", -- Grunt\'s Pauldrons
	[15514]=":1902:4:2:1:::1:0:", -- Grunt\'s Chestpiece
	[15515]=":845:4:2:1:::1:0:", -- Spiked Chain Belt
	[15516]=":1588:4:2:1:::1:0:", -- Spiked Chain Slippers
	[15517]=":850:4:2:1:::1:0:", -- Spiked Chain Wristbands
	[15518]=":2825:4:2:1:::1:0:", -- Spiked Chain Breastplate
	[15519]=":607:4:2:1:::1:0:", -- Spiked Chain Cloak
	[15520]=":879:4:2:1:::1:0:", -- Spiked Chain Gauntlets
	[15521]=":1942:4:2:1:::1:0:", -- Spiked Chain Leggings
	[15522]=":2516:4:2:1:::1:0:", -- Spiked Chain Shield
	[15523]=":1474:4:2:1:::1:0:", -- Spiked Chain Shoulder Pads
	[15524]=":2876:4:2:1:::1:0:", -- Sentry\'s Surcoat
	[15525]=":1634:4:2:1:::1:0:", -- Sentry\'s Slippers
	[15526]=":704:4:2:1:::1:0:", -- Sentry\'s Cape
	[15527]=":1020:4:2:1:::1:0:", -- Sentry\'s Gloves
	[15528]=":931:4:2:1:::1:0:", -- Sentry\'s Sash
	[15529]=":2487:4:2:1:::1:0:", -- Sentry\'s Leggings
	[15530]=":3222:4:2:1:::1:0:", -- Sentry\'s Shield
	[15531]=":2076:4:2:1:::1:0:", -- Sentry\'s Shoulderguards
	[15532]=":944:4:2:1:::1:0:", -- Sentry\'s Armsplints
	[15533]=":2290:4:2:1:::1:0:", -- Sentry\'s Headdress
	[15534]=":2308:4:2:1:::1:0:", -- Wicked Chain Boots
	[15535]=":1270:4:2:1:::1:0:", -- Wicked Chain Bracers
	[15536]=":4107:4:2:1:::1:0:", -- Wicked Chain Chestpiece
	[15537]=":1163:4:2:1:::1:0:", -- Wicked Chain Cloak
	[15538]=":1412:4:2:1:::1:0:", -- Wicked Chain Gauntlets
	[15539]=":1282:4:2:1:::1:0:", -- Wicked Chain Waistband
	[15540]=":2827:4:2:1:::1:0:", -- Wicked Chain Helmet
	[15541]=":3441:4:2:1:::1:0:", -- Wicked Chain Legguards
	[15542]=":2365:4:2:1:::1:0:", -- Wicked Chain Shoulder Pads
	[15543]=":4179:4:2:1:::1:0:", -- Wicked Chain Shield
	[15544]=":2448:4:2:1:::1:0:", -- Thick Scale Sabatons
	[15545]=":1348:4:2:1:::1:0:", -- Thick Scale Bracelets
	[15546]=":4794:4:2:1:::1:0:", -- Thick Scale Breastplate
	[15547]=":1234:4:2:1:::1:0:", -- Thick Scale Cloak
	[15548]=":1649:4:2:1:::1:0:", -- Thick Scale Gauntlets
	[15549]=":1504:4:2:1:::1:0:", -- Thick Scale Belt
	[15550]=":3316:4:2:1:::1:0:", -- Thick Scale Crown
	[15551]=":4438:4:2:1:::1:0:", -- Thick Scale Legguards
	[15552]=":5226:4:2:1:::1:0:", -- Thick Scale Shield
	[15553]=":3061:4:2:1:::1:0:", -- Thick Scale Shoulder Pads
	[15554]=":1853:4:2:1:::1:0:", -- Pillager\'s Girdle
	[15555]=":2802:4:2:1:::1:0:", -- Pillager\'s Boots
	[15556]=":1697:4:2:1:::1:0:", -- Pillager\'s Bracers
	[15557]=":5486:4:2:1:::1:0:", -- Pillager\'s Chestguard
	[15558]=":4128:4:2:1:::1:0:", -- Pillager\'s Crown
	[15559]=":1450:4:2:1:::1:0:", -- Pillager\'s Cloak
	[15560]=":1937:4:2:1:::1:0:", -- Pillager\'s Gloves
	[15561]=":4705:4:2:1:::1:0:", -- Pillager\'s Leggings
	[15562]=":3558:4:2:1:::1:0:", -- Pillager\'s Pauldrons
	[15563]=":5562:4:2:1:::1:0:", -- Pillager\'s Shield
	[15564]=":1000:0:1:10:::1:0:", -- Rugged Armor Kit
	[15565]=":4274:4:2:1:::1:0:", -- Marauder\'s Boots
	[15566]=":2178:4:2:1:::1:0:", -- Marauder\'s Bracers
	[15567]=":6666:4:2:1:::1:0:", -- Marauder\'s Tunic
	[15568]=":1814:4:2:1:::1:0:", -- Marauder\'s Cloak
	[15569]=":7162:4:2:1:::1:0:", -- Marauder\'s Crest
	[15570]=":2431:4:2:1:::1:0:", -- Marauder\'s Gauntlets
	[15571]=":2218:4:2:1:::1:0:", -- Marauder\'s Belt
	[15572]=":4714:4:2:1:::1:0:", -- Marauder\'s Circlet
	[15573]=":5840:4:2:1:::1:0:", -- Marauder\'s Leggings
	[15574]=":5150:4:2:1:::1:0:", -- Marauder\'s Shoulder Pads
	[15575]=":2300:4:2:1:::1:0:", -- Sparkleshell Belt
	[15576]=":4462:4:2:1:::1:0:", -- Sparkleshell Sabatons
	[15577]=":2317:4:2:1:::1:0:", -- Sparkleshell Bracers
	[15578]=":6962:4:2:1:::1:0:", -- Sparkleshell Breastplate
	[15579]=":2122:4:2:1:::1:0:", -- Sparkleshell Cloak
	[15580]=":4871:4:2:1:::1:0:", -- Sparkleshell Headwrap
	[15581]=":2794:4:2:1:::1:0:", -- Sparkleshell Gauntlets
	[15582]=":6544:4:2:1:::1:0:", -- Sparkleshell Legguards
	[15583]=":5344:4:2:1:::1:0:", -- Sparkleshell Shoulder Pads
	[15584]=":7594:4:2:1:::1:0:", -- Sparkleshell Shield
	[15585]=":1447:4:2:1:::1:0:", -- Pardoc Grips
	[15587]=":1822:4:2:1:::1:0:", -- Ringtail Girdle
	[15588]=":2194:4:2:1:::1:0:", -- Bracesteel Belt
	[15589]=":5462:4:2:1:::1:0:", -- Steadfast Stompers
	[15590]=":2674:4:2:1:::1:0:", -- Steadfast Bracelets
	[15591]=":8740:4:2:1:::1:0:", -- Steadfast Breastplate
	[15592]=":8465:4:2:1:::1:0:", -- Steadfast Buckler
	[15593]=":5532:4:2:1:::1:0:", -- Steadfast Coronet
	[15594]=":2520:4:2:1:::1:0:", -- Steadfast Cloak
	[15595]=":2950:4:2:1:::1:0:", -- Steadfast Gloves
	[15596]=":6909:4:2:1:::1:0:", -- Steadfast Legplates
	[15597]=":5642:4:2:1:::1:0:", -- Steadfast Shoulders
	[15598]=":2763:4:2:1:::1:0:", -- Steadfast Girdle
	[15599]=":6631:4:2:1:::1:0:", -- Ancient Greaves
	[15600]=":3787:4:2:1:::1:0:", -- Ancient Vambraces
	[15601]=":10345:4:2:1:::1:0:", -- Ancient Chestpiece
	[15602]=":7211:4:2:1:::1:0:", -- Ancient Crown
	[15603]=":3546:4:2:1:::1:0:", -- Ancient Cloak
	[15604]=":11158:4:2:1:::1:0:", -- Ancient Defender
	[15605]=":3858:4:2:1:::1:0:", -- Ancient Gauntlets
	[15606]=":3585:4:2:1:::1:0:", -- Ancient Belt
	[15607]=":9306:4:2:1:::1:0:", -- Ancient Legguards
	[15608]=":7035:4:2:1:::1:0:", -- Ancient Pauldrons
	[15609]=":11806:4:2:1:::1:0:", -- Bonelink Armor
	[15610]=":4354:4:2:1:::1:0:", -- Bonelink Bracers
	[15611]=":4369:4:2:1:::1:0:", -- Bonelink Cape
	[15612]=":4285:4:2:1:::1:0:", -- Bonelink Gauntlets
	[15613]=":3688:4:2:1:::1:0:", -- Bonelink Belt
	[15614]=":7026:4:2:1:::1:0:", -- Bonelink Sabatons
	[15615]=":7584:4:2:1:::1:0:", -- Bonelink Helmet
	[15616]=":10151:4:2:1:::1:0:", -- Bonelink Legplates
	[15617]=":7107:4:2:1:::1:0:", -- Bonelink Epaulets
	[15618]=":11782:4:2:1:::1:0:", -- Bonelink Wall Shield
	[15619]=":5987:4:2:1:::1:0:", -- Gryphon Mail Belt
	[15620]=":5564:4:2:1:::1:0:", -- Gryphon Mail Bracelets
	[15621]=":15766:4:2:1:::1:0:", -- Gryphon Mail Buckler
	[15622]=":14834:4:2:1:::1:0:", -- Gryphon Mail Breastplate
	[15623]=":10715:4:2:1:::1:0:", -- Gryphon Mail Crown
	[15624]=":4971:4:2:1:::1:0:", -- Gryphon Cloak
	[15625]=":5818:4:2:1:::1:0:", -- Gryphon Mail Gauntlets
	[15626]=":8798:4:2:1:::1:0:", -- Gryphon Mail Greaves
	[15627]=":14493:4:2:1:::1:0:", -- Gryphon Mail Legguards
	[15628]=":9570:4:2:1:::1:0:", -- Gryphon Mail Pauldrons
	[15629]=":6374:4:2:1:::1:0:", -- Formidable Bracers
	[15630]=":10312:4:2:1:::1:0:", -- Formidable Sabatons
	[15631]=":16672:4:2:1:::1:0:", -- Formidable Chestpiece
	[15632]=":4997:4:2:1:::1:0:", -- Formidable Cape
	[15633]=":16210:4:2:1:::1:0:", -- Formidable Crest
	[15634]=":11441:4:2:1:::1:0:", -- Formidable Circlet
	[15635]=":5896:4:2:1:::1:0:", -- Formidable Gauntlets
	[15636]=":6333:4:2:1:::1:0:", -- Formidable Belt
	[15637]=":14557:4:2:1:::1:0:", -- Formidable Legguards
	[15638]=":9615:4:2:1:::1:0:", -- Formidable Shoulder Pads
	[15639]=":7040:4:2:1:::1:0:", -- Ironhide Bracers
	[15640]=":20233:4:2:1:::1:0:", -- Ironhide Breastplate
	[15641]=":7587:4:2:1:::1:0:", -- Ironhide Belt
	[15642]=":12162:4:2:1:::1:0:", -- Ironhide Greaves
	[15643]=":6675:4:2:1:::1:0:", -- Ironhide Cloak
	[15644]=":8130:4:2:1:::1:0:", -- Ironhide Gauntlets
	[15645]=":14577:4:2:1:::1:0:", -- Ironhide Helmet
	[15646]=":19507:4:2:1:::1:0:", -- Ironhide Legguards
	[15647]=":13125:4:2:1:::1:0:", -- Ironhide Pauldrons
	[15648]=":22212:4:2:1:::1:0:", -- Ironhide Shield
	[15649]=":7808:4:2:1:::1:0:", -- Merciless Bracers
	[15650]=":22230:4:2:1:::1:0:", -- Merciless Surcoat
	[15651]=":15785:4:2:1:::1:0:", -- Merciless Crown
	[15652]=":7139:4:2:1:::1:0:", -- Merciless Cloak
	[15653]=":8053:4:2:1:::1:0:", -- Merciless Gauntlets
	[15654]=":8569:4:2:1:::1:0:", -- Merciless Belt
	[15655]=":19862:4:2:1:::1:0:", -- Merciless Legguards
	[15656]=":13366:4:2:1:::1:0:", -- Merciless Epaulets
	[15657]=":22625:4:2:1:::1:0:", -- Merciless Shield
	[15658]=":17851:4:2:1:::1:0:", -- Impenetrable Sabatons
	[15659]=":9508:4:2:1:::1:0:", -- Impenetrable Bindings
	[15660]=":25412:4:2:1:::1:0:", -- Impenetrable Breastplate
	[15661]=":9036:4:2:1:::1:0:", -- Impenetrable Cloak
	[15662]=":10801:4:2:1:::1:0:", -- Impenetrable Gauntlets
	[15663]=":10226:4:2:1:::1:0:", -- Impenetrable Belt
	[15664]=":19071:4:2:1:::1:0:", -- Impenetrable Helmet
	[15665]=":25520:4:2:1:::1:0:", -- Impenetrable Legguards
	[15666]=":18375:4:2:1:::1:0:", -- Impenetrable Pauldrons
	[15667]=":27798:4:2:1:::1:0:", -- Impenetrable Wall
	[15668]=":11697:4:2:1:::1:0:", -- Magnificent Bracers
	[15669]=":26609:4:2:1:::1:0:", -- Magnificent Breastplate
	[15670]=":19753:4:2:1:::1:0:", -- Magnificent Helmet
	[15671]=":9782:4:2:1:::1:0:", -- Magnificent Cloak
	[15672]=":12164:4:2:1:::1:0:", -- Magnificent Gauntlets
	[15673]=":11075:4:2:1:::1:0:", -- Magnificent Belt
	[15674]=":18464:4:2:1:::1:0:", -- Magnificent Greaves
	[15675]=":26976:4:2:1:::1:0:", -- Magnificent Guard
	[15676]=":25039:4:2:1:::1:0:", -- Magnificent Leggings
	[15677]=":18933:4:2:1:::1:0:", -- Magnificent Shoulders
	[15678]=":19525:4:2:1:::1:0:", -- Triumphant Sabatons
	[15679]=":12658:4:2:1:::1:0:", -- Triumphant Bracers
	[15680]=":26811:4:2:1:::1:0:", -- Triumphant Chestpiece
	[15681]=":11406:4:2:1:::1:0:", -- Triumphant Cloak
	[15682]=":13149:4:2:1:::1:0:", -- Triumphant Gauntlets
	[15683]=":12666:4:2:1:::1:0:", -- Triumphant Girdle
	[15684]=":20135:4:2:1:::1:0:", -- Triumphant Skullcap
	[15685]=":26587:4:2:1:::1:0:", -- Triumphant Legplates
	[15686]=":20099:4:2:1:::1:0:", -- Triumphant Shoulder Pads
	[15687]=":27239:4:2:1:::1:0:", -- Triumphant Shield
	[15689]=":4040:4:2:1:::1:0:", -- Trader\'s Ring
	[15690]=":4912:4:2:1:::1:0:", -- Kodobone Necklace
	[15691]=":6909:2:2:1:::1:0:", -- Sidegunner Shottie
	[15692]=":6935:2:2:1:::1:0:", -- Kodo Brander
	[15693]=":14533:4:2:1:::1:0:", -- Grand Shoulders
	[15694]=":13264:4:2:1:::1:0:", -- Merciless Greaves
	[15695]=":5984:4:2:1:::1:0:", -- Studded Ring Shield
	[15696]="::12:1:1:::1:0:", -- Ruined Tome
	[15697]=":2826:4:2:1:::1:0:", -- Kodo Rustler Boots
	[15698]=":4273:4:2:1:::1:0:", -- Wrangling Spaulders
	[15699]=":25:15:1:1:::1:0:", -- Small Brown-wrapped Package
	[15702]=":7396:4:2:1:::1:0:", -- Chemist\'s Ring
	[15703]=":9645:4:2:1:::1:0:", -- Chemist\'s Smock
	[15704]=":6145:4:2:1:::1:0:", -- Hunter\'s Insignia Medal
	[15705]=":33774:2:2:1:::1:0:", -- Tidecrest Blade
	[15706]=":33905:2:2:1:::1:0:", -- Hunt Tracker Blade
	[15707]=":7215:4:2:1:::1:0:", -- Brantwood Sash
	[15708]=":9053:4:2:1:::1:0:", -- Blight Leather Gloves
	[15709]=":12796:4:2:1:::1:0:", -- Gearforge Girdle
	[15710]="::12:1:1:::1:0:", -- Cenarion Lunardust
	[15722]="::12:1:1:::1:0:", -- Spraggle\'s Canteen
	[15723]=":2825:0:2:1:::1:0:", -- Tea with Sugar
	[15724]="12000:3000:9:1:1:::1:0:12956", -- Pattern: Heavy Scorpid Bracers
	[15725]="12000:3000:9:1:1:::1:0:12943,12942", -- Pattern: Wicked Leather Gauntlets
	[15726]="12000:3000:9:1:1:::1:0:11874", -- Pattern: Green Dragonscale Breastplate
	[15727]=":3000:9:2:1:::1:0:", -- Pattern: Heavy Scorpid Vest
	[15728]=":3000:9:2:1:::1:0:", -- Pattern: Wicked Leather Bracers
	[15729]="12000:3000:9:1:1:::1:0:12957", -- Pattern: Chimeric Gloves
	[15730]=":3000:9:3:1:::1:0:", -- Pattern: Red Dragonscale Breastplate
	[15731]=":3500:9:2:1:::1:0:", -- Pattern: Runic Leather Gauntlets
	[15732]=":3500:9:2:1:::1:0:", -- Pattern: Volcanic Leggings
	[15733]=":3500:9:3:1:::1:0:", -- Pattern: Green Dragonscale Leggings
	[15734]="14000:3500:9:1:1:::1:0:7854,7852", -- Pattern: Living Shoulders
	[15735]="14000:3500:9:1:1:::1:0:12958", -- Pattern: Ironfeather Shoulders
	[15736]="::12:1:1:::1:0:", -- Smokey\'s Special Compound
	[15737]=":4000:9:2:1:::1:0:", -- Pattern: Chimeric Boots
	[15738]=":4000:9:2:1:::1:0:", -- Pattern: Heavy Scorpid Gauntlets
	[15739]=":4000:9:2:1:::1:0:", -- Pattern: Runic Leather Bracers
	[15740]="16000:4000:9:1:1:::1:0:11189", -- Pattern: Frostsaber Boots
	[15741]="16000:4000:9:1:1:::1:0:12943,12942", -- Pattern: Stormshroud Pants
	[15742]=":4000:9:1:1:::1:0:", -- Pattern: Warbear Harness
	[15743]=":5000:9:2:1:::1:0:", -- Pattern: Heavy Scorpid Belt
	[15744]=":5000:9:2:1:::1:0:", -- Pattern: Wicked Leather Headband
	[15745]=":5000:9:2:1:::1:0:", -- Pattern: Runic Leather Belt
	[15746]=":5000:9:2:1:::1:0:", -- Pattern: Chimeric Leggings
	[15747]=":5000:9:2:1:::1:0:", -- Pattern: Frostsaber Leggings
	[15748]=":5000:9:2:1:::1:0:", -- Pattern: Heavy Scorpid Leggings
	[15749]=":5000:9:2:1:::1:0:", -- Pattern: Volcanic Breastplate
	[15750]="::12:1:1:::1:0:", -- Sceptre of Light
	[15751]="20000:5000:9:1:1:::1:0:12957", -- Pattern: Blue Dragonscale Breastplate
	[15752]=":5000:9:3:1:::1:0:", -- Pattern: Living Leggings
	[15753]=":5000:9:3:1:::1:0:", -- Pattern: Stormshroud Armor
	[15754]=":5000:9:1:1:::1:0:", -- Pattern: Warbear Woolies
	[15755]=":5500:9:2:1:::1:0:", -- Pattern: Chimeric Vest
	[15756]=":5500:9:1:1:::1:0:", -- Pattern: Runic Leather Headband
	[15757]=":5500:9:2:1:::1:0:", -- Pattern: Wicked Leather Pants
	[15758]="22000:5500:9:1:1:::1:0:12959", -- Pattern: Devilsaur Gauntlets
	[15759]="22000:5500:9:1:1:::1:0:9499", -- Pattern: Black Dragonscale Breastplate
	[15760]=":5500:9:3:1:::1:0:", -- Pattern: Ironfeather Breastplate
	[15761]=":6250:9:2:1:::1:0:", -- Pattern: Frostsaber Gloves
	[15762]="25000:6250:9:1:1:::1:0:12956", -- Pattern: Heavy Scorpid Helm
	[15763]=":6250:9:3:1:::1:0:", -- Pattern: Blue Dragonscale Shoulders
	[15764]=":6250:9:3:1:::1:0:", -- Pattern: Stormshroud Shoulders
	[15765]=":7500:9:2:1:::1:0:", -- Pattern: Runic Leather Pants
	[15766]="::12:1:1:::1:0:", -- Gem of the Serpent
	[15767]="::13:1:1:::1:0:", -- Hameya\'s Key
	[15768]=":7500:9:2:1:::1:0:", -- Pattern: Wicked Leather Belt
	[15770]=":7500:9:3:1:::1:0:", -- Pattern: Black Dragonscale Shoulders
	[15771]=":7500:9:3:1:::1:0:", -- Pattern: Living Breastplate
	[15772]=":7500:9:3:1:::1:0:", -- Pattern: Devilsaur Leggings
	[15773]=":10000:9:2:1:::1:0:", -- Pattern: Wicked Leather Armor
	[15774]=":10000:9:2:1:::1:0:", -- Pattern: Heavy Scorpid Shoulders
	[15775]=":10000:9:2:1:::1:0:", -- Pattern: Volcanic Shoulders
	[15776]=":10000:9:2:1:::1:0:", -- Pattern: Runic Leather Armor
	[15777]=":15000:9:2:1:::1:0:", -- Pattern: Runic Leather Shoulders
	[15778]=":1250:15:2:1:::1:0:", -- Mechanical Yeti
	[15779]=":15000:9:2:1:::1:0:", -- Pattern: Frostsaber Tunic
	[15781]=":15000:9:3:1:::1:0:", -- Pattern: Black Dragonscale Leggings
	[15782]=":43142:2:2:1:::1:0:", -- Beaststalker Blade
	[15783]=":43292:2:2:1:::1:0:", -- Beasthunter Dagger
	[15784]=":11541:4:2:1:::1:0:", -- Crystal Breeze Mantle
	[15785]="::12:1:1:::1:0:", -- Zaeldarr\'s Head
	[15786]=":19381:4:2:1:::1:0:", -- Fernpulse Jerkin
	[15787]=":23343:4:2:1:::1:0:", -- Willow Band Hauberk
	[15788]="::12:1:1:::1:0:", -- Everlook Report
	[15789]=":9967:4:2:1:::1:0:", -- Deep River Cloak
	[15790]="::12:1:1:::1:0:", -- Studies in Spirit Speaking
	[15791]=":7521:4:2:1:::1:0:", -- Turquoise Sash
	[15792]=":14154:4:2:1:::1:0:", -- Plow Wood Spaulders
	[15793]=":50:15:0:20:::1:0:", -- A Chewed Bone
	[15794]=":39:4:0:1:::1:0:", -- Ripped Ogre Loincloth
	[15795]=":13431:4:2:1:::1:0:", -- Emerald Mist Gauntlets
	[15796]=":12063:4:2:1:::1:0:", -- Seaspray Bracers
	[15797]=":14206:4:2:1:::1:0:", -- Shining Armplates
	[15798]=":50:15:0:20:::1:0:", -- Chipped Ogre Teeth
	[15799]=":7108:4:2:1:::1:0:", -- Heroic Commendation Medal
	[15800]=":36082:2:2:1:::1:0:", -- Intrepid Shortsword
	[15801]=":36221:2:2:1:::1:0:", -- Valiant Shortsword
	[15802]=":11648:4:3:1:::1:0:", -- Mooncloth Boots
	[15803]="::12:1:1:::1:0:", -- Book of the Ancients
	[15804]=":9781:4:2:1:::1:0:", -- Cerise Drape
	[15805]=":14662:4:3:1:::1:0:", -- Penelope\'s Rose
	[15806]=":49514:2:3:1:::1:0:", -- Mirah\'s Song
	[15807]="294:58:2:1:1:::1:0:17667,1287,4602,16919,16715,7976", -- Light Crossbow
	[15808]="3641:728:2:1:1:::1:0:17667,1287,4602,16919,16715,7976", -- Fine Light Crossbow
	[15809]="14691:2938:2:1:1:::1:0:17667,1287,4602,16919,16715,7976", -- Heavy Crossbow
	[15810]="10145:2029:2:1:1:::1:0:4601,1289", -- Short Spear
	[15811]="27133:5426:2:1:1:::1:0:4601,1289", -- Heavy Spear
	[15812]=":10076:4:2:1:::1:0:", -- Orchid Amice
	[15813]=":10113:4:2:1:::1:0:", -- Gold Link Belt
	[15814]=":41911:2:2:1:::1:0:", -- Hameya\'s Slayer
	[15815]=":12619:4:2:1:::1:0:", -- Hameya\'s Cloak
	[15822]=":11446:4:2:1:::1:0:", -- Shadowskin Spaulders
	[15823]=":9191:4:2:1:::1:0:", -- Bricksteel Gauntlets
	[15824]=":15385:4:2:1:::1:0:", -- Astoria Robes
	[15825]=":19302:4:2:1:::1:0:", -- Traphook Jerkin
	[15826]="::12:1:1:::1:0:", -- Curative Animal Salve
	[15827]=":23338:4:2:1:::1:0:", -- Jadescale Breastplate
	[15842]="::12:1:1:::1:0:", -- Empty Dreadmist Peak Sampler
	[15843]="::12:1:1:::1:0:", -- Filled Dreadmist Peak Sampler
	[15844]="::12:1:1:::1:0:", -- Empty Cliffspring Falls Sampler
	[15845]="::12:1:1:::1:0:", -- Filled Cliffspring Falls Sampler
	[15846]=":7500:7:1:1:::1:0:", -- Salt Shaker
	[15847]="::12:1:1:::1:0:", -- Quel\'Thalas Registry
	[15848]="::12:1:1:::1:0:", -- Crate of Ghost Magnets
	[15849]="::12:1:20:::1:0:", -- Ghost-o-plasm
	[15850]="::12:1:1:::1:0:", -- Patch of Duskwing\'s Fur
	[15851]="::12:1:20:::1:0:", -- Lunar Fungus
	[15852]="::12:1:20:::1:0:", -- Kodo Horn
	[15853]=":51418:2:3:1:::1:0:", -- Windreaper
	[15854]=":64502:2:3:1:::1:0:", -- Dancing Sliver
	[15855]=":7888:4:3:1:::1:0:", -- Ring of Protection
	[15856]=":8788:4:3:1:::1:0:", -- Archlight Talisman
	[15857]=":15335:4:3:1:::1:0:", -- Magebane Scion
	[15858]=":7516:4:2:1:::1:0:", -- Freewind Gloves
	[15859]=":11317:4:2:1:::1:0:", -- Seapost Girdle
	[15860]=":13997:4:2:1:::1:0:", -- Blinkstrike Armguards
	[15861]=":14969:4:2:1:::1:0:", -- Swiftfoot Treads
	[15862]=":28789:2:2:1:::1:0:", -- Blitzcleaver
	[15863]=":28896:2:2:1:::1:0:", -- Grave Scepter
	[15864]=":2043:4:2:1:::1:0:", -- Condor Bracers
	[15865]=":6562:4:2:1:::1:0:", -- Anchorhold Buckler
	[15866]=":562:4:2:1:::1:0:", -- Veildust Medicine Bag
	[15867]=":7464:4:2:1:::1:0:", -- Prismcharm
	[15868]="::12:1:1:::1:0:", -- The Grand Crusader\'s Command
	[15869]=":50:13:2:20:::1:0:", -- Silver Skeleton Key
	[15870]=":300:13:2:20:::1:0:", -- Golden Skeleton Key
	[15871]=":625:13:2:20:::1:0:", -- Truesilver Skeleton Key
	[15872]=":625:13:2:20:::1:0:", -- Arcanite Skeleton Key
	[15873]=":8144:4:3:1:::1:0:", -- Ragged John\'s Neverending Cup
	[15874]="::15:1:1:::1:0:", -- Soft-shelled Clam
	[15875]="::12:1:1:::1:0:", -- Rotten Apple
	[15876]="::12:1:1:::1:0:", -- Nathanos\' Chest
	[15877]="::12:1:1:::1:0:", -- Shrine Bauble
	[15878]="::13:1:1:::1:0:", -- Rackmore\'s Silver Key
	[15879]="::12:1:1:::1:0:", -- Overlord Ror\'s Claw
	[15880]="::12:1:1:::1:0:", -- Head of Ramstein the Gorger
	[15881]="::13:1:1:::1:0:", -- Rackmore\'s Golden Key
	[15882]="::12:1:1:::1:0:", -- Half Pendant of Aquatic Endurance
	[15883]="::12:1:1:::1:0:", -- Half Pendant of Aquatic Agility
	[15884]="::12:1:1:::1:0:", -- Augustus\' Receipt Book
	[15885]="::12:1:1:::1:0:", -- Pendant of the Sea Lion
	[15886]="::12:1:1:::1:0:", -- Timolain\'s Phylactery
	[15887]=":27581:4:2:1:::1:0:", -- Heroic Guard
	[15890]=":25831:4:2:1:::1:0:", -- Vanguard Shield
	[15891]=":2014:4:2:1:::1:0:", -- Hulking Shield
	[15892]=":3582:4:2:1:::1:0:", -- Slayer\'s Shield
	[15893]=":1082:4:2:1:::1:0:", -- Prospector\'s Buckler
	[15894]=":1802:4:2:1:::1:0:", -- Bristlebark Buckler
	[15895]=":53:4:1:1:::1:0:", -- Burnt Buckler
	[15902]="80000:20000:15:1:1:::1:0:12384", -- A Crazy Grab Bag
	[15903]="8118:1623:2:1:1:::1:0:19047,3361,7976,4203", -- Right-Handed Claw
	[15904]="21708:4341:2:1:1:::1:0:19047,3361,7976,4203", -- Right-Handed Blades
	[15905]="2130:426:2:1:1:::1:0:19047,3361,7976,4203", -- Right-Handed Brass Knuckles
	[15906]="2138:427:2:1:1:::1:0:19047,3361,7976,4203", -- Left-Handed Brass Knuckles
	[15907]="8237:1647:2:1:1:::1:0:19047,3361,7976,4203", -- Left-Handed Claw
	[15908]="::12:1:1:::1:0:", -- Taming Rod
	[15909]="22107:4421:2:1:1:::1:0:19047,3361,7976,4203", -- Left-Handed Blades
	[15911]="::12:1:1:::1:0:", -- Taming Rod
	[15912]=":1148:4:2:1:::1:0:", -- Buccaneer\'s Orb
	[15913]="::12:1:1:::1:0:", -- Taming Rod
	[15914]="::12:1:1:::1:0:", -- Taming Rod
	[15915]="::12:1:1:::1:0:", -- Taming Rod
	[15916]="::12:1:1:::1:0:", -- Taming Rod
	[15917]="::12:1:1:::1:0:", -- Taming Rod
	[15918]=":4848:4:2:1:::1:0:", -- Conjurer\'s Sphere
	[15919]="::12:1:1:::1:0:", -- Taming Rod
	[15920]="::12:1:1:::1:0:", -- Taming Rod
	[15921]="::12:1:1:::1:0:", -- Taming Rod
	[15922]="::12:1:1:::1:0:", -- Taming Rod
	[15923]="::12:1:1:::1:0:", -- Taming Rod
	[15924]="::12:1:10:::1:0:", -- Soft-shelled Clam Meat
	[15925]=":439:4:2:1:::1:0:", -- Journeyman\'s Stave
	[15926]=":802:4:2:1:::1:0:", -- Spellbinder Orb
	[15927]=":1864:4:2:1:::1:0:", -- Bright Sphere
	[15928]=":2387:4:2:1:::1:0:", -- Silver-thread Rod
	[15929]=":4396:4:2:1:::1:0:", -- Nightsky Orb
	[15930]=":9146:4:2:1:::1:0:", -- Imperial Red Scepter
	[15931]=":10646:4:2:1:::1:0:", -- Arcane Star
	[15932]=":527:4:2:1:::1:0:", -- Disciple\'s Stein
	[15933]=":620:4:2:1:::1:0:", -- Simple Branch
	[15934]=":2596:4:2:1:::1:0:", -- Sage\'s Stave
	[15935]=":3323:4:2:1:::1:0:", -- Durable Rod
	[15936]=":8950:4:2:1:::1:0:", -- Duskwoven Branch
	[15937]=":7922:4:2:1:::1:0:", -- Hibernal Sphere
	[15938]=":9550:4:2:1:::1:0:", -- Mystical Orb
	[15939]=":10455:4:2:1:::1:0:", -- Councillor\'s Scepter
	[15940]=":10957:4:2:1:::1:0:", -- Elegant Scepter
	[15941]=":12345:4:2:1:::1:0:", -- High Councillor\'s Scepter
	[15942]=":12757:4:2:1:::1:0:", -- Master\'s Rod
	[15943]=":26800:4:2:1:::1:0:", -- Imbued Shield
	[15944]=":512:4:2:1:::1:0:", -- Ancestral Orb
	[15945]=":837:4:2:1:::1:0:", -- Runic Stave
	[15946]=":802:4:2:1:::1:0:", -- Mystic\'s Sphere
	[15947]=":1887:4:2:1:::1:0:", -- Sanguine Star
	[15962]=":2716:4:2:1:::1:0:", -- Satyr\'s Rod
	[15963]=":4887:4:2:1:::1:0:", -- Stonecloth Branch
	[15964]=":6364:4:2:1:::1:0:", -- Silksand Star
	[15965]=":7996:4:2:1:::1:0:", -- Windchaser Orb
	[15966]=":9137:4:2:1:::1:0:", -- Venomshroud Orb
	[15967]=":10304:4:2:1:::1:0:", -- Highborne Star
	[15968]=":802:4:2:1:::1:0:", -- Elunarian Sphere
	[15969]=":425:4:2:1:::1:0:", -- Beaded Orb
	[15970]=":587:4:2:1:::1:0:", -- Native Branch
	[15971]=":1064:4:2:1:::1:0:", -- Aboriginal Rod
	[15972]=":1171:4:2:1:::1:0:", -- Ritual Stein
	[15973]=":2313:4:2:1:::1:0:", -- Watcher\'s Star
	[15974]=":1461:4:2:1:::1:0:", -- Pagan Rod
	[15975]=":2421:4:2:1:::1:0:", -- Raincaller Scepter
	[15976]=":4146:4:2:1:::1:0:", -- Thistlefur Branch
	[15977]=":4614:4:2:1:::1:0:", -- Vital Orb
	[15978]=":5385:4:2:1:::1:0:", -- Geomancer\'s Rod
	[15979]=":7215:4:2:1:::1:0:", -- Embersilk Stave
	[15980]=":7469:4:2:1:::1:0:", -- Darkmist Orb
	[15981]=":7215:4:2:1:::1:0:", -- Lunar Sphere
	[15982]=":8142:4:2:1:::1:0:", -- Bloodwoven Rod
	[15983]=":8387:4:2:1:::1:0:", -- Gaea\'s Scepter
	[15984]=":9614:4:2:1:::1:0:", -- Opulent Scepter
	[15985]=":9887:4:2:1:::1:0:", -- Arachnidian Branch
	[15986]=":10813:4:2:1:::1:0:", -- Bonecaster\'s Star
	[15987]=":10996:4:2:1:::1:0:", -- Astral Orb
	[15988]=":12471:4:2:1:::1:0:", -- Resplendent Orb
	[15989]=":12498:4:2:1:::1:0:", -- Eternal Rod
	[15990]=":6850:4:2:1:::1:0:", -- Enduring Shield
	[15991]=":26309:4:2:1:::1:0:", -- Warleader\'s Shield
	[15992]=":250:7:1:20::202:1:0:", -- Dense Blasting Powder
	[15993]=":1500:7:1:10:::1:0:", -- Thorium Grenade
	[15994]=":2500:7:1:10::202:1:0:", -- Thorium Widget
	[15995]=":19739:2:2:1:::1:0:", -- Thorium Rifle
	[15996]=":2500:15:1:1:::1:0:", -- Lifelike Mechanical Toad
	[15997]="4000:10:6:2:200:::1:0:17078", -- Thorium Shells
	[15998]="::12:1:1:::1:0:", -- Lewis\' Note
	[15999]=":9003:4:2:1:::1:0:", -- Spellpower Goggles Xtreme Plus
	[16000]=":3750:7:1:10::202:1:0:", -- Thorium Tube
	[16001]="::12:1:1:::1:0:", -- SI:7 Insignia (Fredo)
	[16002]="::12:1:1:::1:0:", -- SI:7 Insignia (Turyen)
	[16003]="::12:1:1:::1:0:", -- SI:7 Insignia (Rutger)
	[16004]=":29152:2:3:1:::1:0:", -- Dark Iron Rifle
	[16005]=":1250:7:1:10:::1:0:", -- Dark Iron Bomb
	[16006]=":10000:7:1:10::202:1:0:", -- Delicate Arcanite Converter
	[16007]=":39231:2:3:1:::1:0:", -- Flawless Arcanite Rifle
	[16008]=":11739:4:2:1:::1:0:", -- Master Engineer\'s Goggles
	[16009]=":5930:4:2:1:::1:0:", -- Voice Amplification Modulator
	[16022]=":40000:4:3:1:::1:0:", -- Arcanite Dragonling
	[16023]=":10000:15:1:10:::1:0:", -- Masterwork Target Dummy
	[16039]=":53598:2:3:1:::1:0:", -- Ta\'Kierthan Songblade
	[16040]=":4000:7:1:10:::1:0:", -- Arcane Bomb
	[16041]=":3000:9:1:1:::1:0:", -- Schematic: Thorium Grenade
	[16042]=":3000:9:1:1:::1:0:", -- Schematic: Thorium Widget
	[16043]=":3000:9:2:1:::1:0:", -- Schematic: Thorium Rifle
	[16044]=":4000:9:2:1:::1:0:", -- Schematic: Lifelike Mechanical Toad
	[16045]=":4000:9:2:1:::1:0:", -- Schematic: Spellpower Goggles Xtreme Plus
	[16046]="16000:4000:9:1:1:::1:0:11185", -- Schematic: Masterwork Target Dummy
	[16047]=":4000:9:1:1:::1:0:", -- Schematic: Thorium Tube
	[16048]=":4000:9:2:1:::1:0:", -- Schematic: Dark Iron Rifle
	[16049]=":5000:9:2:1:::1:0:", -- Schematic: Dark Iron Bomb
	[16050]="20000:5000:9:1:1:::1:0:11185", -- Schematic: Delicate Arcanite Converter
	[16051]=":5000:9:2:1:::1:0:", -- Schematic: Thorium Shells
	[16052]=":5000:9:2:1:::1:0:", -- Schematic: Voice Amplification Modulator
	[16053]=":5000:9:2:1:::1:0:", -- Schematic: Master Engineer\'s Goggles
	[16054]=":6000:9:2:1:::1:0:", -- Schematic: Arcanite Dragonling
	[16055]=":6000:9:2:1:::1:0:", -- Schematic: Arcane Bomb
	[16056]=":6000:9:2:1:::1:0:", -- Schematic: Flawless Arcanite Rifle
	[16058]=":10156:4:3:1:::1:0:", -- Fordring\'s Seal
	[16059]="400:100:4:1:1:::1:0:3683,3317,16631,5108,1291,1214,16623,8358,16716,4185,4558,3554", -- Common Brown Shirt
	[16060]="400:100:4:1:1:::1:0:3683,3317,16631,5108,1291,1214,16623,8358,16716,4185,4558,3554", -- Common White Shirt
	[16072]="10000:2500:9:1:1:::1:0:12033,3955", -- Expert Cookbook
	[16083]="10000:2500:9:1:1:::1:0:2626", -- Expert Fishing - The Bass and You
	[16084]="10000:2500:9:1:1:::1:0:2805,13476", -- Expert First Aid - Under Wraps
	[16110]="12000:3000:9:1:1:::1:0:2806,11187,2803", -- Recipe: Monster Omelet
	[16111]="12000:3000:9:1:1:::1:0:4305,989,1149", -- Recipe: Spiced Chili Crab
	[16112]="2200:550:9:1:1:::1:0:2805,13476", -- Manual: Heavy Silk Bandage
	[16113]="5000:1250:9:1:1:::1:0:2805,13476", -- Manual: Mageweave Bandage
	[16114]="::12:1:1:::1:0:", -- Foreman\'s Blackjack
	[16115]="::12:1:1:::1:0:", -- Osric\'s Crate
	[16166]="25:1:0:1:20:::5:0:6091,4266,12026,4191,7941,2303,12019,3961,4167,4181,4195", -- Bean Soup
	[16167]="125:6:0:1:20:::5:0:6091,4266,12026,4191,7941,2303,12019,3961,4167,4181,4195", -- Versicolor Treat
	[16168]="2000:100:0:1:20:::5:0:6091,4266,12026,4191,7941,2303,12019,3961,4167,4181,4195", -- Heaven Peach
	[16169]="1000:62:0:1:20:::5:0:6091,4266,12026,4191,7941,2303,12019,3961,4167,4181,4195", -- Wild Ricecake
	[16170]="500:25:0:1:20:::5:0:6091,4266,12026,4191,7941,2303,12019,3961,4167,4181,4195", -- Steamed Mandu
	[16171]=":200:0:1:20:::1:0:", -- Shinsollo
	[16189]="::12:1:1:::1:0:", -- Maggran\'s Reserve Letter
	[16190]="::12:1:1:::1:0:", -- Bloodfury Ripper\'s Remains
	[16192]="::12:1:1:::1:0:", -- Besseleth\'s Fang
	[16202]="::7:2:10::333:1:0:", -- Lesser Eternal Essence
	[16203]="::7:2:10::333,197:1:0:", -- Greater Eternal Essence
	[16204]="::7:1:20::333:1:0:", -- Illusion Dust
	[16205]="::12:1:10:::1:0:", -- Gaea Seed
	[16206]=":1000:7:1:1::333:1:0:", -- Arcanite Rod
	[16207]=":1250:7:1:1::333:1:0:", -- Runed Arcanite Rod
	[16208]="::12:1:1:::1:0:", -- Enchanted Gaea Seeds
	[16209]="::12:1:1:::1:0:", -- Podrig\'s Order
	[16210]="::12:1:1:::1:0:", -- Gordon\'s Crate
	[16214]=":3000:9:2:1:::1:0:", -- Formula: Enchant Bracer - Greater Intellect
	[16215]=":3000:9:2:1:::1:0:", -- Formula: Enchant Boots - Greater Stamina
	[16216]=":3000:9:2:1:::1:0:", -- Formula: Enchant Cloak - Greater Resistance
	[16217]="12000:3000:9:1:1:::1:0:4229,4561", -- Formula: Enchant Shield - Greater Stamina
	[16218]=":3500:9:2:1:::1:0:", -- Formula: Enchant Bracer - Superior Spirit
	[16219]=":3500:9:2:1:::1:0:", -- Formula: Enchant Gloves - Greater Agility
	[16220]=":4000:9:2:1:::1:0:", -- Formula: Enchant Boots - Spirit
	[16221]="16000:4000:9:1:1:::1:0:11189", -- Formula: Enchant Chest - Major Health
	[16222]=":5000:9:2:1:::1:0:", -- Formula: Enchant Shield - Superior Spirit
	[16223]=":5000:9:2:1:::1:0:", -- Formula: Enchant Weapon - Icy Chill
	[16224]="20000:5000:9:1:1:::1:0:12022", -- Formula: Enchant Cloak - Superior Defense
	[16242]=":5500:9:2:1:::1:0:", -- Formula: Enchant Chest - Major Mana
	[16243]="22000:5500:9:1:1:::1:0:12022", -- Formula: Runed Arcanite Rod
	[16244]=":6000:9:2:1:::1:0:", -- Formula: Enchant Gloves - Greater Strength
	[16245]=":6000:9:2:1:::1:0:", -- Formula: Enchant Boots - Greater Agility
	[16246]=":6000:9:2:1:::1:0:", -- Formula: Enchant Bracer - Superior Strength
	[16247]=":6000:9:2:1:::1:0:", -- Formula: Enchant 2H Weapon - Superior Impact
	[16248]=":6000:9:2:1:::1:0:", -- Formula: Enchant Weapon - Unholy
	[16249]=":7500:9:2:1:::1:0:", -- Formula: Enchant 2H Weapon - Major Intellect
	[16250]=":7500:9:2:1:::1:0:", -- Formula: Enchant Weapon - Superior Striking
	[16251]=":7500:9:2:1:::1:0:", -- Formula: Enchant Bracer - Superior Stamina
	[16252]=":7500:9:2:1:::1:0:", -- Formula: Enchant Weapon - Crusader
	[16253]=":7500:9:2:1:::1:0:", -- Formula: Enchant Chest - Greater Stats
	[16254]=":7500:9:3:1:::1:0:", -- Formula: Enchant Weapon - Lifestealing
	[16255]=":7500:9:2:1:::1:0:", -- Formula: Enchant 2H Weapon - Major Spirit
	[16262]="::12:1:1:::1:0:", -- Nessa\'s Collection
	[16263]="::12:1:1:::1:0:", -- Laird\'s Response
	[16282]="::12:1:1:::1:0:", -- Bundle of Hides
	[16283]="::12:1:1:::1:0:", -- Ahanu\'s Leather Goods
	[16302]="100:25:9:1:1:::1:0:12807,5753,6382,6376,12776,5520,16649,6027,6374,5750,16267,15494,6328,5815,5749,6373,23535", -- Grimoire of Firebolt (Rank 2)
	[16303]="::12:2:1:::1:0:", -- Ursangous\'s Paw
	[16304]="::12:2:1:::1:0:", -- Shadumbra\'s Head
	[16305]="::12:2:1:::1:0:", -- Sharptalon\'s Claw
	[16306]="::12:1:1:::1:0:", -- Zargh\'s Meats
	[16307]="::12:1:1:::1:0:", -- Gryshka\'s Letter
	[16309]="::4:3:1:::1:0:", -- Drakefire Amulet
	[16310]="::12:1:1:::1:0:", -- Brock\'s List
	[16311]="::12:1:1:::1:0:", -- Honorary Picks
	[16312]="::12:1:10:::1:0:", -- Incendrites
	[16313]="::12:1:1:::1:0:", -- Felix\'s Chest
	[16314]="::12:1:1:::1:0:", -- Felix\'s Bucket of Bolts
	[16316]="1500:375:9:1:1:::1:0:12807,5753,6382,6376,12776,5520,16649,6027,6374,5750,16267,15494,6328,5815,5749,6373,23535", -- Grimoire of Firebolt (Rank 3)
	[16317]="5000:1250:9:1:1:::1:0:12807,5753,6382,6376,12776,5520,16649,6027,6374,5750,16267,15494,6328,5815,5749,6373,23535", -- Grimoire of Firebolt (Rank 4)
	[16318]="10000:2500:9:1:1:::1:0:12807,5753,6382,6376,12776,5520,16649,6027,6374,5750,16267,15494,6328,5815,5749,6373,23535", -- Grimoire of Firebolt (Rank 5)
	[16319]="14000:3500:9:1:1:::1:0:12807,5753,6382,6376,12776,5520,16649,6027,6374,5750,16267,15494,6328,5815,5749,6373,23535", -- Grimoire of Firebolt (Rank 6)
	[16320]="24000:6000:9:1:1:::1:0:12807,5753,6382,6376,12776,5520,16649,6027,6374,5750,16267,15494,6328,5815,5749,6373,23535", -- Grimoire of Firebolt (Rank 7)
	[16321]="100:25:9:1:1:::1:0:12807,5753,6382,6376,12776,5520,16649,6027,6374,5750,16267,15494,6328,5815,5749,6373,23535", -- Grimoire of Blood Pact (Rank 1)
	[16322]="900:225:9:1:1:::1:0:12807,5753,6382,6376,12776,5520,16649,6027,6374,5750,16267,15494,6328,5815,5749,6373,23535", -- Grimoire of Blood Pact (Rank 2)
	[16323]="4000:1000:9:1:1:::1:0:12807,5753,6382,6376,12776,5520,16649,6027,6374,5750,16267,15494,6328,5815,5749,6373,23535", -- Grimoire of Blood Pact (Rank 3)
	[16324]="10000:2500:9:1:1:::1:0:12807,5753,6382,6376,12776,5520,16649,6027,6374,5750,16267,15494,6328,5815,5749,6373,23535", -- Grimoire of Blood Pact (Rank 4)
	[16325]="15000:3750:9:1:1:::1:0:12807,5753,6382,6376,12776,5520,16649,6027,6374,5750,16267,15494,6328,5815,5749,6373,23535", -- Grimoire of Blood Pact (Rank 5)
	[16326]="900:225:9:1:1:::1:0:12807,5753,6382,6376,12776,5520,16649,6027,6374,5750,16267,15494,6328,5815,5749,6373,23535", -- Grimoire of Fire Shield (Rank 1)
	[16327]="3000:750:9:1:1:::1:0:12807,5753,6382,6376,12776,5520,16649,6027,6374,5750,16267,15494,6328,5815,5749,6373,23535", -- Grimoire of Fire Shield (Rank 2)
	[16328]="8000:2000:9:1:1:::1:0:12807,5753,6382,6376,12776,5520,16649,6027,6374,5750,16267,15494,6328,5815,5749,6373,23535", -- Grimoire of Fire Shield (Rank 3)
	[16329]="12000:3000:9:1:1:::1:0:12807,5753,6382,6376,12776,5520,16649,6027,6374,5750,16267,15494,6328,5815,5749,6373,23535", -- Grimoire of Fire Shield (Rank 4)
	[16330]="20000:5000:9:1:1:::1:0:12807,5753,6382,6376,12776,5520,16649,6027,6374,5750,16267,15494,6328,5815,5749,6373,23535", -- Grimoire of Fire Shield (Rank 5)
	[16331]="600:150:9:1:1:::1:0:12807,5753,6382,6376,12776,5520,16649,6027,6374,5750,16267,15494,6328,5815,5749,6373,23535", -- Grimoire of Phase Shift
	[16332]="::12:1:1:::1:0:", -- Thazz\'ril\'s Pick
	[16333]="::12:1:1:::1:0:", -- Samuel\'s Remains
	[16335]="::4:3:1:::1:0:12799,12793", -- Senior Sergeant\'s Insignia
	[16341]="::4:3:1:::1:0:12799,12793", -- Sergeant\'s Cloak
	[16342]="::4:3:1:::1:0:12805,12781", -- Sergeant\'s Cape
	[16345]="::2:4:1:::1:0:12794", -- High Warlord\'s Blade
	[16346]="2000:500:9:1:1:::1:0:16267,12807,6328,5753,6382,5815,5520,16649,6027,6374,5750,23535", -- Grimoire of Torment (Rank 2)
	[16347]="6000:1500:9:1:1:::1:0:16267,12807,6328,5753,6382,5815,5520,16649,6027,6374,5750,23535", -- Grimoire of Torment (Rank 3)
	[16348]="11000:2750:9:1:1:::1:0:16267,12807,6328,5753,6382,5815,5520,16649,6027,6374,5750,23535", -- Grimoire of Torment (Rank 4)
	[16349]="15000:3750:9:1:1:::1:0:16267,12807,6328,5753,6382,5815,5520,16649,6027,6374,5750,23535", -- Grimoire of Torment (Rank 5)
	[16350]="26000:6500:9:1:1:::1:0:16267,12807,6328,5753,6382,5815,5520,16649,6027,6374,5750,23535", -- Grimoire of Torment (Rank 6)
	[16351]="1200:300:9:1:1:::1:0:16267,12807,6328,5753,6382,5815,5520,16649,6027,6374,5750,23535", -- Grimoire of Sacrifice (Rank 1)
	[16352]="3000:750:9:1:1:::1:0:16267,12807,6328,5753,6382,5815,5520,16649,6027,6374,5750,23535", -- Grimoire of Sacrifice (Rank 2)
	[16353]="7000:1750:9:1:1:::1:0:16267,12807,6328,5753,6382,5815,5520,16649,6027,6374,5750,23535", -- Grimoire of Sacrifice (Rank 3)
	[16354]="11000:2750:9:1:1:::1:0:16267,12807,6328,5753,6382,5815,5520,16649,6027,6374,5750,23535", -- Grimoire of Sacrifice (Rank 4)
	[16355]="14000:3500:9:1:1:::1:0:16267,12807,6328,5753,6382,5815,5520,16649,6027,6374,5750,23535", -- Grimoire of Sacrifice (Rank 5)
	[16356]="22000:5500:9:1:1:::1:0:16267,12807,6328,5753,6382,5815,5520,16649,6027,6374,5750,23535", -- Grimoire of Sacrifice (Rank 6)
	[16357]="1500:375:9:1:1:::1:0:16267,12807,6328,5753,6382,5815,5520,16649,6027,6374,5750,23535", -- Grimoire of Consume Shadows (Rank 1)
	[16358]="4000:1000:9:1:1:::1:0:16267,12807,6328,5753,6382,5815,5520,16649,6027,6374,5750,23535", -- Grimoire of Consume Shadows (Rank 2)
	[16359]="8000:2000:9:1:1:::1:0:16267,12807,6328,5753,6382,5815,5520,16649,6027,6374,5750,23535", -- Grimoire of Consume Shadows (Rank 3)
	[16360]="11000:2750:9:1:1:::1:0:16267,12807,6328,5753,6382,5815,5520,16649,6027,6374,5750,23535", -- Grimoire of Consume Shadows (Rank 4)
	[16361]="15000:3750:9:1:1:::1:0:16267,12807,6328,5753,6382,5815,5520,16649,6027,6374,5750,23535", -- Grimoire of Consume Shadows (Rank 5)
	[16362]="24000:6000:9:1:1:::1:0:16267,12807,6328,5753,6382,5815,5520,16649,6027,6374,5750,23535", -- Grimoire of Consume Shadows (Rank 6)
	[16363]="3000:750:9:1:1:::1:0:16267,12807,6328,5753,6382,5815,5520,16649,6027,6374,5750,23535", -- Grimoire of Suffering (Rank 1)
	[16364]="9000:2250:9:1:1:::1:0:16267,12807,6328,5753,6382,5815,5520,16649,6027,6374,5750,23535", -- Grimoire of Suffering (Rank 2)
	[16365]="14000:3500:9:1:1:::1:0:16267,12807,6328,5753,6382,5815,5520,16649,6027,6374,5750,23535", -- Grimoire of Suffering (Rank 3)
	[16366]="26000:6500:9:1:1:::1:0:16267,12807,6328,5753,6382,5815,5520,16649,6027,6374,5750,23535", -- Grimoire of Suffering (Rank 4)
	[16368]="5000:1250:9:1:1:::1:0:5815,16267,12807,5520,16649,5753,6382,23535", -- Grimoire of Lash of Pain (Rank 2)
	[16369]=":7575:4:3:1:::1:0:", -- Knight-Lieutenant\'s Silk Boots
	[16371]="9000:2250:9:1:1:::1:0:5815,16267,12807,5520,16649,5753,6382,23535", -- Grimoire of Lash of Pain (Rank 3)
	[16372]="12000:3000:9:1:1:::1:0:5815,16267,12807,5520,16649,5753,6382,23535", -- Grimoire of Lash of Pain (Rank 4)
	[16373]="18000:4500:9:1:1:::1:0:5815,16267,12807,5520,16649,5753,6382,23535", -- Grimoire of Lash of Pain (Rank 5)
	[16374]="26000:6500:9:1:1:::1:0:5815,16267,12807,5520,16649,5753,6382,23535", -- Grimoire of Lash of Pain (Rank 6)
	[16375]="2500:625:9:1:1:::1:0:5815,16267,12807,5520,16649,5753,6382,23535", -- Grimoire of Soothing Kiss (Rank 1)
	[16376]="8000:2000:9:1:1:::1:0:5815,16267,12807,5520,16649,5753,6382,23535", -- Grimoire of Soothing Kiss (Rank 2)
	[16377]="13000:3250:9:1:1:::1:0:5815,16267,12807,5520,16649,5753,6382,23535", -- Grimoire of Soothing Kiss (Rank 3)
	[16378]="24000:6000:9:1:1:::1:0:5815,16267,12807,5520,16649,5753,6382,23535", -- Grimoire of Soothing Kiss (Rank 4)
	[16379]="4000:1000:9:1:1:::1:0:5815,16267,12807,5520,16649,5753,6382,23535", -- Grimoire of Seduction
	[16380]="7000:1750:9:1:1:::1:0:5815,16267,12807,5520,16649,5753,6382,23535", -- Grimoire of Lesser Invisibility
	[16381]="10000:2500:9:1:1:::1:0:5815,16267,12807,5520,16649,5753,6382,23535", -- Grimoire of Devour Magic (Rank 2)
	[16382]="13000:3250:9:1:1:::1:0:5815,16267,12807,5520,16649,5753,6382,23535", -- Grimoire of Devour Magic (Rank 3)
	[16383]="20000:5000:9:1:1:::1:0:5815,16267,12807,5520,16649,5753,6382,23535", -- Grimoire of Devour Magic (Rank 4)
	[16384]="7000:1750:9:1:1:::1:0:5815,16267,12807,5520,16649,5753,6382,23535", -- Grimoire of Tainted Blood (Rank 1)
	[16385]="11000:2750:9:1:1:::1:0:5815,16267,12807,5520,16649,5753,6382,23535", -- Grimoire of Tainted Blood (Rank 2)
	[16386]="14000:3500:9:1:1:::1:0:5815,16267,12807,5520,16649,5753,6382,23535", -- Grimoire of Tainted Blood (Rank 3)
	[16387]="22000:5500:9:1:1:::1:0:5815,16267,12807,5520,16649,5753,6382,23535", -- Grimoire of Tainted Blood (Rank 4)
	[16388]="9000:2250:9:1:1:::1:0:5815,16267,12807,5520,16649,5753,6382,23535", -- Grimoire of Spell Lock (Rank 1)
	[16389]="18000:4500:9:1:1:::1:0:5815,16267,12807,5520,16649,5753,6382,23535", -- Grimoire of Spell Lock (Rank 2)
	[16390]="11000:2750:9:1:1:::1:0:5815,16267,12807,5520,16649,5753,6382,23535", -- Grimoire of Paranoia
	[16391]=":5087:4:3:1:::1:0:", -- Knight-Lieutenant\'s Silk Gloves
	[16392]=":9574:4:3:1:::1:0:", -- Knight-Lieutenant\'s Leather Boots
	[16393]=":9609:4:3:1:::1:0:", -- Knight-Lieutenant\'s Dragonhide Footwraps
	[16396]=":6650:4:3:1:::1:0:", -- Knight-Lieutenant\'s Leather Gauntlets
	[16397]=":6673:4:3:1:::1:0:", -- Knight-Lieutenant\'s Dragonhide Gloves
	[16401]=":12237:4:3:1:::1:0:", -- Knight-Lieutenant\'s Chain Boots
	[16403]=":7401:4:3:1:::1:0:", -- Knight-Lieutenant\'s Chain Gauntlets
	[16405]=":13027:4:3:1:::1:0:", -- Knight-Lieutenant\'s Plate Boots
	[16406]=":8785:4:3:1:::1:0:", -- Knight-Lieutenant\'s Plate Gauntlets
	[16408]="::12:2:1:::1:0:", -- Befouled Water Globe
	[16409]=":13227:4:3:1:::1:0:", -- Knight-Lieutenant\'s Lamellar Sabatons
	[16410]=":8919:4:3:1:::1:0:", -- Knight-Lieutenant\'s Lamellar Gauntlets
	[16413]=":10524:4:3:1:::1:0:", -- Knight-Captain\'s Silk Raiment
	[16414]=":10562:4:3:1:::1:0:", -- Knight-Captain\'s Silk Leggings
	[16415]=":7950:4:3:1:::1:0:", -- Lieutenant Commander\'s Silk Spaulders
	[16416]=":7978:4:3:1:::1:0:", -- Lieutenant Commander\'s Crown
	[16417]=":13345:4:3:1:::1:0:", -- Knight-Captain\'s Leather Armor
	[16418]=":10045:4:3:1:::1:0:", -- Lieutenant Commander\'s Leather Veil
	[16419]=":13441:4:3:1:::1:0:", -- Knight-Captain\'s Leather Legguards
	[16420]=":10116:4:3:1:::1:0:", -- Lieutenant Commander\'s Leather Spaulders
	[16421]=":13536:4:3:1:::1:0:", -- Knight-Captain\'s Dragonhide Tunic
	[16422]=":13583:4:3:1:::1:0:", -- Knight-Captain\'s Dragonhide Leggings
	[16423]=":9251:4:3:1:::1:0:", -- Lieutenant Commander\'s Dragonhide Epaulets
	[16424]=":9286:4:3:1:::1:0:", -- Lieutenant Commander\'s Dragonhide Shroud
	[16425]=":14915:4:3:1:::1:0:", -- Knight-Captain\'s Chain Hauberk
	[16426]=":14972:4:3:1:::1:0:", -- Knight-Captain\'s Chain Leggings
	[16427]=":11632:4:3:1:::1:0:", -- Lieutenant Commander\'s Chain Pauldrons
	[16428]=":11623:4:3:1:::1:0:", -- Lieutenant Commander\'s Chain Helmet
	[16429]=":13585:4:3:1:::1:0:", -- Lieutenant Commander\'s Plate Helm
	[16430]=":18215:4:3:1:::1:0:", -- Knight-Captain\'s Plate Chestguard
	[16431]=":18281:4:3:1:::1:0:", -- Knight-Captain\'s Plate Leggings
	[16432]=":13734:4:3:1:::1:0:", -- Lieutenant Commander\'s Plate Pauldrons
	[16433]=":18415:4:3:1:::1:0:", -- Knight-Captain\'s Lamellar Breastplate
	[16434]=":13835:4:3:1:::1:0:", -- Lieutenant Commander\'s Lamellar Headguard
	[16435]=":18547:4:3:1:::1:0:", -- Knight-Captain\'s Lamellar Leggings
	[16436]=":13934:4:3:1:::1:0:", -- Lieutenant Commander\'s Lamellar Shoulders
	[16437]="::4:4:1:::1:0:12785", -- Marshal\'s Silk Footwraps
	[16440]="::4:4:1:::1:0:12785", -- Marshal\'s Silk Gloves
	[16441]="::4:4:1:::1:0:12785", -- Field Marshal\'s Coronet
	[16442]="::4:4:1:::1:0:12785", -- Marshal\'s Silk Leggings
	[16443]="::4:4:1:::1:0:12785", -- Field Marshal\'s Silk Vestments
	[16444]="::4:4:1:::1:0:12785", -- Field Marshal\'s Silk Spaulders
	[16446]="::4:4:1:::1:0:12785", -- Marshal\'s Leather Footguards
	[16448]="::4:4:1:::1:0:12785", -- Marshal\'s Dragonhide Gauntlets
	[16449]="::4:4:1:::1:0:12785", -- Field Marshal\'s Dragonhide Spaulders
	[16450]="::4:4:1:::1:0:12785", -- Marshal\'s Dragonhide Legguards
	[16451]="::4:4:1:::1:0:12785", -- Field Marshal\'s Dragonhide Helmet
	[16452]="::4:4:1:::1:0:12785", -- Field Marshal\'s Dragonhide Breastplate
	[16453]="::4:4:1:::1:0:12785", -- Field Marshal\'s Leather Chestpiece
	[16454]="::4:4:1:::1:0:12785", -- Marshal\'s Leather Handgrips
	[16455]="::4:4:1:::1:0:12785", -- Field Marshal\'s Leather Mask
	[16456]="::4:4:1:::1:0:12785", -- Marshal\'s Leather Leggings
	[16457]="::4:4:1:::1:0:12785", -- Field Marshal\'s Leather Epaulets
	[16459]="::4:4:1:::1:0:12785", -- Marshal\'s Dragonhide Boots
	[16462]="::4:4:1:::1:0:12785", -- Marshal\'s Chain Boots
	[16463]="::4:4:1:::1:0:12785", -- Marshal\'s Chain Grips
	[16465]="::4:4:1:::1:0:12785", -- Field Marshal\'s Chain Helm
	[16466]="::4:4:1:::1:0:12785", -- Field Marshal\'s Chain Breastplate
	[16467]="::4:4:1:::1:0:12785", -- Marshal\'s Chain Legguards
	[16468]="::4:4:1:::1:0:12785", -- Field Marshal\'s Chain Spaulders
	[16471]="::4:4:1:::1:0:12785", -- Marshal\'s Lamellar Gloves
	[16472]="::4:4:1:::1:0:12785", -- Marshal\'s Lamellar Boots
	[16473]="::4:4:1:::1:0:12785", -- Field Marshal\'s Lamellar Chestplate
	[16474]="::4:4:1:::1:0:12785", -- Field Marshal\'s Lamellar Faceguard
	[16475]="::4:4:1:::1:0:12785", -- Marshal\'s Lamellar Legplates
	[16476]="::4:4:1:::1:0:12785", -- Field Marshal\'s Lamellar Pauldrons
	[16477]="::4:4:1:::1:0:12785", -- Field Marshal\'s Plate Armor
	[16478]="::4:4:1:::1:0:12785", -- Field Marshal\'s Plate Helm
	[16479]="::4:4:1:::1:0:12785", -- Marshal\'s Plate Legguards
	[16480]="::4:4:1:::1:0:12785", -- Field Marshal\'s Plate Shoulderguards
	[16483]="::4:4:1:::1:0:12785", -- Marshal\'s Plate Boots
	[16484]="::4:4:1:::1:0:12785", -- Marshal\'s Plate Gauntlets
	[16485]=":7660:4:3:1:::1:0:", -- Blood Guard\'s Silk Footwraps
	[16486]="::4:3:1:::1:0:12799,12793", -- First Sergeant\'s Silk Cuffs
	[16487]=":5145:4:3:1:::1:0:", -- Blood Guard\'s Silk Gloves
	[16489]=":7774:4:3:1:::1:0:", -- Champion\'s Silk Hood
	[16490]=":10404:4:3:1:::1:0:", -- Legionnaire\'s Silk Pants
	[16491]=":10716:4:3:1:::1:0:", -- Legionnaire\'s Silk Robes
	[16492]=":8066:4:3:1:::1:0:", -- Champion\'s Silk Shoulderpads
	[16494]=":10154:4:3:1:::1:0:", -- Blood Guard\'s Dragonhide Boots
	[16496]=":6168:4:3:1:::1:0:", -- Blood Guard\'s Dragonhide Gauntlets
	[16497]="::4:3:1:::1:0:12799,12793", -- First Sergeant\'s Leather Armguards
	[16498]=":9325:4:3:1:::1:0:", -- Blood Guard\'s Leather Treads
	[16499]=":6240:4:3:1:::1:0:", -- Blood Guard\'s Leather Vices
	[16501]=":9431:4:3:1:::1:0:", -- Champion\'s Dragonhide Spaulders
	[16502]=":12623:4:3:1:::1:0:", -- Legionnaire\'s Dragonhide Trousers
	[16503]=":9502:4:3:1:::1:0:", -- Champion\'s Dragonhide Helm
	[16504]=":12718:4:3:1:::1:0:", -- Legionnaire\'s Dragonhide Breastplate
	[16505]=":12766:4:3:1:::1:0:", -- Legionnaire\'s Leather Hauberk
	[16506]=":9609:4:3:1:::1:0:", -- Champion\'s Leather Headguard
	[16507]=":9903:4:3:1:::1:0:", -- Champion\'s Leather Mantle
	[16508]=":13252:4:3:1:::1:0:", -- Legionnaire\'s Leather Leggings
	[16509]=":13938:4:3:1:::1:0:", -- Blood Guard\'s Plate Boots
	[16510]="::4:3:1:::1:0:", -- Blood Guard\'s Plate Gloves
	[16513]=":18886:4:3:1:::1:0:", -- Legionnaire\'s Plate Armor
	[16514]=":14187:4:3:1:::1:0:", -- Champion\'s Plate Headguard
	[16515]=":19019:4:3:1:::1:0:", -- Legionnaire\'s Plate Legguards
	[16516]=":12928:4:3:1:::1:0:", -- Champion\'s Plate Pauldrons
	[16518]=":11237:4:3:1:::1:0:", -- Blood Guard\'s Mail Walkers
	[16519]=":7487:4:3:1:::1:0:", -- Blood Guard\'s Mail Grips
	[16521]=":11316:4:3:1:::1:0:", -- Champion\'s Mail Helm
	[16522]=":15145:4:3:1:::1:0:", -- Legionnaire\'s Mail Chestpiece
	[16523]=":15615:4:3:1:::1:0:", -- Legionnaire\'s Mail Leggings
	[16524]=":11806:4:3:1:::1:0:", -- Champion\'s Mail Shoulders
	[16525]=":15728:4:3:1:::1:0:", -- Legionnaire\'s Chain Breastplate
	[16526]=":11839:4:3:1:::1:0:", -- Champion\'s Chain Headguard
	[16527]=":15843:4:3:1:::1:0:", -- Legionnaire\'s Chain Leggings
	[16528]=":11978:4:3:1:::1:0:", -- Champion\'s Chain Pauldrons
	[16530]=":8007:4:3:1:::1:0:", -- Blood Guard\'s Chain Gauntlets
	[16531]=":12107:4:3:1:::1:0:", -- Blood Guard\'s Chain Boots
	[16532]="::4:3:1:::1:0:12799,12793", -- First Sergeant\'s Mail Wristguards
	[16533]="::4:4:1:::1:0:12795", -- Warlord\'s Silk Cowl
	[16534]="::4:4:1:::1:0:12795", -- General\'s Silk Trousers
	[16535]="::4:4:1:::1:0:12795", -- Warlord\'s Silk Raiment
	[16536]="::4:4:1:::1:0:12795", -- Warlord\'s Silk Amice
	[16539]="::4:4:1:::1:0:12795", -- General\'s Silk Boots
	[16540]="::4:4:1:::1:0:12795", -- General\'s Silk Handguards
	[16541]="::4:4:1:::1:0:12795", -- Warlord\'s Plate Armor
	[16542]="::4:4:1:::1:0:12795", -- Warlord\'s Plate Headpiece
	[16543]="::4:4:1:::1:0:12795", -- General\'s Plate Leggings
	[16544]="::4:4:1:::1:0:12795", -- Warlord\'s Plate Shoulders
	[16545]="::4:4:1:::1:0:12795", -- General\'s Plate Boots
	[16548]="::4:4:1:::1:0:12795", -- General\'s Plate Gauntlets
	[16549]="::4:4:1:::1:0:12795", -- Warlord\'s Dragonhide Hauberk
	[16550]="::4:4:1:::1:0:12795", -- Warlord\'s Dragonhide Helmet
	[16551]="::4:4:1:::1:0:12795", -- Warlord\'s Dragonhide Epaulets
	[16552]="::4:4:1:::1:0:12795", -- General\'s Dragonhide Leggings
	[16554]="::4:4:1:::1:0:12795", -- General\'s Dragonhide Boots
	[16555]="::4:4:1:::1:0:12795", -- General\'s Dragonhide Gloves
	[16558]="::4:4:1:::1:0:12795", -- General\'s Leather Treads
	[16560]="::4:4:1:::1:0:12795", -- General\'s Leather Mitts
	[16561]="::4:4:1:::1:0:12795", -- Warlord\'s Leather Helm
	[16562]="::4:4:1:::1:0:12795", -- Warlord\'s Leather Spaulders
	[16563]="::4:4:1:::1:0:12795", -- Warlord\'s Leather Breastplate
	[16564]="::4:4:1:::1:0:12795", -- General\'s Leather Legguards
	[16565]="::4:4:1:::1:0:12795", -- Warlord\'s Chain Chestpiece
	[16566]="::4:4:1:::1:0:12795", -- Warlord\'s Chain Helmet
	[16567]="::4:4:1:::1:0:12795", -- General\'s Chain Legguards
	[16568]="::4:4:1:::1:0:12795", -- Warlord\'s Chain Shoulders
	[16569]="::4:4:1:::1:0:12795", -- General\'s Chain Boots
	[16571]="::4:4:1:::1:0:12795", -- General\'s Chain Gloves
	[16573]="::4:4:1:::1:0:12795", -- General\'s Mail Boots
	[16574]="::4:4:1:::1:0:12795", -- General\'s Mail Gauntlets
	[16577]="::4:4:1:::1:0:12795", -- Warlord\'s Mail Armor
	[16578]="::4:4:1:::1:0:12795", -- Warlord\'s Mail Helm
	[16579]="::4:4:1:::1:0:12795", -- General\'s Mail Leggings
	[16580]="::4:4:1:::1:0:12795", -- Warlord\'s Mail Spaulders
	[16581]="::12:1:20:::1:0:", -- Resonite Crystal
	[16583]="10000:2500:15:1:5:::1:0:26744,4878,26751,24843,20915,4220,26758,26765,19235,5139,16588,3323,16612,8361,1308,4083,983,3700,25039,19679,26754,26752,23373,18017,26743,25010,16757,3500,5151,3970,12097,1463,25633,18019,25082,26756,20092,26759,17518,16611,2805,18243,3335,3562,15175,1275,18006,19014,4562,3542,26747,26741,26739,4575,16829,1307,14739,23405,26753,26742,25051,26748,958,3490,20081,13476,3351,19004,18998,17078,23157,1673,1351,19013,24995,26745,26757,23112,1257,10364,19535,23560,22479,26724,23145,26749,12096,16015,5110,26755,26738,23151,16706,18802,24935,19718,26740,19678,25019", -- Demonic Figurine
	[16602]="::12:1:20:::1:0:", -- Troll Charm
	[16603]="::12:1:1:::1:0:", -- Enchanted Resonite Crystal
	[16604]=":17:4:2:1:::1:0:", -- Moon Robes of Elune
	[16605]=":17:4:2:1:::1:0:", -- Friar\'s Robes of the Light
	[16606]=":17:4:2:1:::1:0:", -- Juju Hex Robes
	[16607]=":17:4:2:1:::1:0:", -- Acolyte\'s Sacrificial Robes
	[16608]=":213:4:2:1:::1:0:", -- Aquarius Belt
	[16622]=":27307:2:2:1:::1:0:", -- Thornflinger
	[16623]=":7783:4:2:1:::1:0:", -- Opaline Medallion
	[16642]="::12:1:1:::1:0:", -- Shredder Operating Manual - Chapter 1
	[16643]="::12:1:1:::1:0:", -- Shredder Operating Manual - Chapter 2
	[16644]="::12:1:1:::1:0:", -- Shredder Operating Manual - Chapter 3
	[16645]=":62:12:1:1:::1:0:", -- Shredder Operating Manual - Page 1
	[16646]=":62:12:1:1:::1:0:", -- Shredder Operating Manual - Page 2
	[16647]=":62:12:1:1:::1:0:", -- Shredder Operating Manual - Page 3
	[16648]=":62:12:1:1:::1:0:", -- Shredder Operating Manual - Page 4
	[16649]=":62:12:1:1:::1:0:", -- Shredder Operating Manual - Page 5
	[16650]=":62:12:1:1:::1:0:", -- Shredder Operating Manual - Page 6
	[16651]=":62:12:1:1:::1:0:", -- Shredder Operating Manual - Page 7
	[16652]=":62:12:1:1:::1:0:", -- Shredder Operating Manual - Page 8
	[16653]=":62:12:1:1:::1:0:", -- Shredder Operating Manual - Page 9
	[16654]=":62:12:1:1:::1:0:", -- Shredder Operating Manual - Page 10
	[16655]=":62:12:1:1:::1:0:", -- Shredder Operating Manual - Page 11
	[16656]=":62:12:1:1:::1:0:", -- Shredder Operating Manual - Page 12
	[16658]=":1649:4:2:1:::1:0:", -- Wildhunter Cloak
	[16659]=":856:4:2:1:::1:0:", -- Deftkin Belt
	[16660]=":2200:4:2:1:::1:0:", -- Driftmire Shield
	[16661]=":1035:4:2:1:::1:0:", -- Soft Willow Cape
	[16662]="::12:1:1:::1:0:", -- Fragment of the Dragon\'s Eye
	[16663]="::12:1:1:::1:0:", -- Blood of the Black Dragon Champion
	[16665]="::9:2:1:::1:0:17078", -- Tome of Tranquilizing Shot
	[16666]=":32368:4:3:1:::1:0:", -- Vest of Elements
	[16667]=":24035:4:3:1:::1:0:", -- Coif of Elements
	[16668]=":29493:4:3:1:::1:0:", -- Kilt of Elements
	[16669]=":21995:4:3:1:::1:0:", -- Pauldrons of Elements
	[16670]=":21027:4:3:1:::1:0:", -- Boots of Elements
	[16671]=":12586:4:3:1:::1:0:", -- Bindings of Elements
	[16672]=":14059:4:3:1:::1:0:", -- Gauntlets of Elements
	[16673]=":13440:4:3:1:::1:0:", -- Cord of Elements
	[16674]=":30993:4:3:1:::1:0:", -- Beaststalker\'s Tunic
	[16675]=":21421:4:3:1:::1:0:", -- Beaststalker\'s Boots
	[16676]=":14268:4:3:1:::1:0:", -- Beaststalker\'s Gloves
	[16677]=":23186:4:3:1:::1:0:", -- Beaststalker\'s Cap
	[16678]=":30607:4:3:1:::1:0:", -- Beaststalker\'s Pants
	[16679]=":22822:4:3:1:::1:0:", -- Beaststalker\'s Mantle
	[16680]=":13788:4:3:1:::1:0:", -- Beaststalker\'s Belt
	[16681]=":13055:4:3:1:::1:0:", -- Beaststalker\'s Bindings
	[16682]=":14582:4:3:1:::1:0:", -- Magister\'s Boots
	[16683]=":8765:4:3:1:::1:0:", -- Magister\'s Bindings
	[16684]=":9093:4:3:1:::1:0:", -- Magister\'s Gloves
	[16685]=":8694:4:3:1:::1:0:", -- Magister\'s Belt
	[16686]=":14836:4:3:1:::1:0:", -- Magister\'s Crown
	[16687]=":19585:4:3:1:::1:0:", -- Magister\'s Leggings
	[16688]=":20202:4:3:1:::1:0:", -- Magister\'s Robes
	[16689]=":14597:4:3:1:::1:0:", -- Magister\'s Mantle
	[16690]=":20355:4:3:1:::1:0:", -- Devout Robe
	[16691]=":14005:4:3:1:::1:0:", -- Devout Sandals
	[16692]=":9372:4:3:1:::1:0:", -- Devout Gloves
	[16693]=":15230:4:3:1:::1:0:", -- Devout Crown
	[16694]=":20106:4:3:1:::1:0:", -- Devout Skirt
	[16695]=":14925:4:3:1:::1:0:", -- Devout Mantle
	[16696]=":9058:4:3:1:::1:0:", -- Devout Belt
	[16697]=":8577:4:3:1:::1:0:", -- Devout Bracers
	[16698]=":15511:4:3:1:::1:0:", -- Dreadmist Mask
	[16699]=":20475:4:3:1:::1:0:", -- Dreadmist Leggings
	[16700]=":21665:4:3:1:::1:0:", -- Dreadmist Robe
	[16701]=":15650:4:3:1:::1:0:", -- Dreadmist Mantle
	[16702]=":8593:4:3:1:::1:0:", -- Dreadmist Belt
	[16703]=":8138:4:3:1:::1:0:", -- Dreadmist Bracers
	[16704]=":13639:4:3:1:::1:0:", -- Dreadmist Sandals
	[16705]=":9127:4:3:1:::1:0:", -- Dreadmist Wraps
	[16706]=":25058:4:3:1:::1:0:", -- Wildheart Vest
	[16707]=":18612:4:3:1:::1:0:", -- Shadowcraft Cap
	[16708]=":18175:4:3:1:::1:0:", -- Shadowcraft Spaulders
	[16709]=":24666:4:3:1:::1:0:", -- Shadowcraft Pants
	[16710]=":10446:4:3:1:::1:0:", -- Shadowcraft Bracers
	[16711]=":17505:4:3:1:::1:0:", -- Shadowcraft Boots
	[16712]=":11714:4:3:1:::1:0:", -- Shadowcraft Gloves
	[16713]=":11197:4:3:1:::1:0:", -- Shadowcraft Belt
	[16714]=":10602:4:3:1:::1:0:", -- Wildheart Bracers
	[16715]=":17766:4:3:1:::1:0:", -- Wildheart Boots
	[16716]=":11621:4:3:1:::1:0:", -- Wildheart Belt
	[16717]=":12244:4:3:1:::1:0:", -- Wildheart Gloves
	[16718]=":19354:4:3:1:::1:0:", -- Wildheart Spaulders
	[16719]=":26260:4:3:1:::1:0:", -- Wildheart Kilt
	[16720]=":20037:4:3:1:::1:0:", -- Wildheart Cowl
	[16721]=":27173:4:3:1:::1:0:", -- Shadowcraft Tunic
	[16722]=":14266:4:3:1:::1:0:", -- Lightforge Bracers
	[16723]=":15180:4:3:1:::1:0:", -- Lightforge Belt
	[16724]=":16001:4:3:1:::1:0:", -- Lightforge Gauntlets
	[16725]=":23910:4:3:1:::1:0:", -- Lightforge Boots
	[16726]=":35078:4:3:1:::1:0:", -- Lightforge Breastplate
	[16727]=":26005:4:3:1:::1:0:", -- Lightforge Helm
	[16728]=":34398:4:3:1:::1:0:", -- Lightforge Legplates
	[16729]=":25488:4:3:1:::1:0:", -- Lightforge Spaulders
	[16730]=":35611:4:3:1:::1:0:", -- Breastplate of Valor
	[16731]=":26399:4:3:1:::1:0:", -- Helm of Valor
	[16732]=":35849:4:3:1:::1:0:", -- Legplates of Valor
	[16733]=":26562:4:3:1:::1:0:", -- Spaulders of Valor
	[16734]=":25389:4:3:1:::1:0:", -- Boots of Valor
	[16735]=":15379:4:3:1:::1:0:", -- Bracers of Valor
	[16736]=":16359:4:3:1:::1:0:", -- Belt of Valor
	[16737]=":17239:4:3:1:::1:0:", -- Gauntlets of Valor
	[16738]=":4235:4:2:1:::1:0:", -- Witherseed Gloves
	[16739]=":7969:4:2:1:::1:0:", -- Rugwood Mantle
	[16740]=":1032:4:2:1:::1:0:", -- Shredder Operating Gloves
	[16741]=":1295:4:2:1:::1:0:", -- Oilrag Handwraps
	[16742]="::12:1:1:::1:0:", -- Warsong Saw Blades
	[16743]="::12:1:20:::1:0:", -- Logging Rope
	[16744]="::12:1:20:::1:0:", -- Warsong Oil
	[16745]="::12:1:1:::1:0:", -- Warsong Axe Shipment
	[16746]="::12:1:20:::1:0:", -- Warsong Report
	[16747]=":27:15:0:20:::1:0:", -- Broken Lock
	[16748]=":15:15:0:20:::1:0:", -- Padded Lining
	[16762]="::12:1:1:::1:0:", -- Fathom Core
	[16763]="::12:1:1:::1:0:", -- Warsong Runner Update
	[16764]="::12:1:1:::1:0:", -- Warsong Scout Update
	[16765]="::12:1:1:::1:0:", -- Warsong Outrider Update
	[16766]=":100:0:1:20:::1:0:", -- Undermine Clam Chowder
	[16767]="3000:750:9:1:1:::1:0:8139", -- Recipe: Undermine Clam Chowder
	[16768]="150000:37500:4:2:1:::1:0:11555", -- Furbolg Medicine Pouch
	[16769]="133081:26616:2:2:1:::1:0:11555", -- Furbolg Medicine Totem
	[16782]="::12:2:1:::1:0:", -- Strange Water Globe
	[16783]="::12:1:20:::1:0:", -- Bundle of Reports
	[16784]="::12:1:20:::1:0:", -- Sapphire of Aku\'Mai
	[16785]="::12:1:1:::1:0:", -- Rokaro\'s Letter
	[16786]="::12:1:20:::1:0:", -- Black Dragonspawn Eye
	[16787]="::4:1:1:::1:0:", -- Amulet of Draconic Subversion
	[16788]=":5095:4:2:1:::1:0:", -- Captain Rackmore\'s Wheel
	[16789]=":5992:2:2:1:::1:0:", -- Captain Rackmore\'s Tiller
	[16790]="::15:1:1:::1:0:", -- Damp Note
	[16791]=":1912:4:2:1:::1:0:", -- Silkstream Cuffs
	[16793]=":4353:4:2:1:::1:0:", -- Arcmetal Shoulders
	[16794]=":2899:4:2:1:::1:0:", -- Gripsteel Wristguards
	[16795]=":22128:4:4:1:::1:0:", -- Arcanist Crown
	[16796]=":27491:4:4:1:::1:0:", -- Arcanist Leggings
	[16797]=":20698:4:4:1:::1:0:", -- Arcanist Mantle
	[16798]=":27704:4:4:1:::1:0:", -- Arcanist Robes
	[16799]=":13905:4:4:1:::1:0:", -- Arcanist Bindings
	[16800]=":20935:4:4:1:::1:0:", -- Arcanist Boots
	[16801]=":14010:4:4:1:::1:0:", -- Arcanist Gloves
	[16802]=":14063:4:4:1:::1:0:", -- Arcanist Belt
	[16803]=":21174:4:4:1:::1:0:", -- Felheart Slippers
	[16804]=":14168:4:4:1:::1:0:", -- Felheart Bracers
	[16805]=":14221:4:4:1:::1:0:", -- Felheart Gloves
	[16806]=":14274:4:4:1:::1:0:", -- Felheart Belt
	[16807]=":21491:4:4:1:::1:0:", -- Felheart Shoulder Pads
	[16808]=":21569:4:4:1:::1:0:", -- Felheart Horns
	[16809]=":28865:4:4:1:::1:0:", -- Felheart Robes
	[16810]=":28972:4:4:1:::1:0:", -- Felheart Pants
	[16811]=":21806:4:4:1:::1:0:", -- Boots of Prophecy
	[16812]=":14591:4:4:1:::1:0:", -- Gloves of Prophecy
	[16813]=":22537:4:4:1:::1:0:", -- Circlet of Prophecy
	[16814]=":30156:4:4:1:::1:0:", -- Pants of Prophecy
	[16815]=":27382:4:4:1:::1:0:", -- Robes of Prophecy
	[16816]=":20616:4:4:1:::1:0:", -- Mantle of Prophecy
	[16817]=":13797:4:4:1:::1:0:", -- Girdle of Prophecy
	[16818]=":15636:4:4:1:::1:0:", -- Netherwind Belt
	[16819]=":13902:4:4:1:::1:0:", -- Vambraces of Prophecy
	[16820]=":34888:4:4:1:::1:0:", -- Nightslayer Chestpiece
	[16821]=":26266:4:4:1:::1:0:", -- Nightslayer Cover
	[16822]=":35154:4:4:1:::1:0:", -- Nightslayer Pants
	[16823]=":26463:4:4:1:::1:0:", -- Nightslayer Shoulder Pads
	[16824]=":26562:4:4:1:::1:0:", -- Nightslayer Boots
	[16825]=":17775:4:4:1:::1:0:", -- Nightslayer Bracelets
	[16826]=":17839:4:4:1:::1:0:", -- Nightslayer Gloves
	[16827]=":17906:4:4:1:::1:0:", -- Nightslayer Belt
	[16828]=":17972:4:4:1:::1:0:", -- Cenarion Belt
	[16829]=":27773:4:4:1:::1:0:", -- Cenarion Boots
	[16830]=":18580:4:4:1:::1:0:", -- Cenarion Bracers
	[16831]=":18646:4:4:1:::1:0:", -- Cenarion Gloves
	[16832]=":31689:4:4:1:::1:0:", -- Bloodfang Spaulders
	[16833]=":37559:4:4:1:::1:0:", -- Cenarion Vestments
	[16834]=":28266:4:4:1:::1:0:", -- Cenarion Helm
	[16835]=":34223:4:4:1:::1:0:", -- Cenarion Leggings
	[16836]=":25767:4:4:1:::1:0:", -- Cenarion Spaulders
	[16837]=":31178:4:4:1:::1:0:", -- Earthfury Boots
	[16838]=":20771:4:4:1:::1:0:", -- Earthfury Belt
	[16839]=":20851:4:4:1:::1:0:", -- Earthfury Gauntlets
	[16840]=":20931:4:4:1:::1:0:", -- Earthfury Bracers
	[16841]=":42021:4:4:1:::1:0:", -- Earthfury Vestments
	[16842]=":31632:4:4:1:::1:0:", -- Earthfury Helmet
	[16843]=":42336:4:4:1:::1:0:", -- Earthfury Legguards
	[16844]=":32013:4:4:1:::1:0:", -- Earthfury Epaulets
	[16845]=":43794:4:4:1:::1:0:", -- Giantstalker\'s Breastplate
	[16846]=":32965:4:4:1:::1:0:", -- Giantstalker\'s Helmet
	[16847]=":44113:4:4:1:::1:0:", -- Giantstalker\'s Leggings
	[16848]=":33352:4:4:1:::1:0:", -- Giantstalker\'s Epaulets
	[16849]=":33469:4:4:1:::1:0:", -- Giantstalker\'s Boots
	[16850]=":22294:4:4:1:::1:0:", -- Giantstalker\'s Bracers
	[16851]=":22373:4:4:1:::1:0:", -- Giantstalker\'s Belt
	[16852]=":22453:4:4:1:::1:0:", -- Giantstalker\'s Gloves
	[16853]=":52573:4:4:1:::1:0:", -- Lawbringer Chestguard
	[16854]=":39494:4:4:1:::1:0:", -- Lawbringer Helm
	[16855]=":47908:4:4:1:::1:0:", -- Lawbringer Legplates
	[16856]=":36002:4:4:1:::1:0:", -- Lawbringer Spaulders
	[16857]=":24275:4:4:1:::1:0:", -- Lawbringer Bracers
	[16858]=":24369:4:4:1:::1:0:", -- Lawbringer Belt
	[16859]=":36416:4:4:1:::1:0:", -- Lawbringer Boots
	[16860]=":24554:4:4:1:::1:0:", -- Lawbringer Gauntlets
	[16861]=":25318:4:4:1:::1:0:", -- Bracers of Might
	[16862]=":37829:4:4:1:::1:0:", -- Sabatons of Might
	[16863]=":25505:4:4:1:::1:0:", -- Gauntlets of Might
	[16864]=":25596:4:4:1:::1:0:", -- Belt of Might
	[16865]=":51088:4:4:1:::1:0:", -- Breastplate of Might
	[16866]=":38382:4:4:1:::1:0:", -- Helm of Might
	[16867]=":51461:4:4:1:::1:0:", -- Legplates of Might
	[16868]=":38657:4:4:1:::1:0:", -- Pauldrons of Might
	[16869]="::12:1:1:::1:0:", -- The Skull of Scryer
	[16870]="::12:1:1:::1:0:", -- The Skull of Somnus
	[16871]="::12:1:1:::1:0:", -- The Skull of Chronalis
	[16872]="::12:1:1:::1:0:", -- The Skull of Axtroz
	[16873]=":2469:4:2:1:::1:0:", -- Braidfur Gloves
	[16882]="::15:1:1:::1:0:", -- Battered Junkbox
	[16883]="::15:1:1:::1:0:", -- Worn Junkbox
	[16884]="::15:1:1:::1:0:", -- Sturdy Junkbox
	[16885]="::15:1:1:::1:0:", -- Heavy Junkbox
	[16886]=":5492:2:3:1:::1:0:", -- Outlaw Sabre
	[16887]=":1988:4:3:1:::1:0:", -- Witch\'s Finger
	[16888]="::12:1:1:::1:0:", -- Dull Drakefire Amulet
	[16889]=":3093:2:2:1:::1:0:", -- Polished Walking Staff
	[16890]=":2483:2:2:1:::1:0:", -- Slatemetal Cutlass
	[16891]=":1697:2:2:1:::1:0:", -- Claystone Shortsword
	[16892]="::0:1:1:::1:0:", -- Lesser Soulstone
	[16893]="::0:1:1:::1:0:", -- Soulstone
	[16894]=":1993:2:2:1:::1:0:", -- Clear Crystal Rod
	[16895]="::0:1:1:::1:0:", -- Greater Soulstone
	[16896]="::0:1:1:::1:0:", -- Major Soulstone
	[16897]=":39996:4:4:1:::1:0:", -- Stormrage Chestguard
	[16898]=":30106:4:4:1:::1:0:", -- Stormrage Boots
	[16899]=":20146:4:4:1:::1:0:", -- Stormrage Handguards
	[16900]=":30331:4:4:1:::1:0:", -- Stormrage Cover
	[16901]=":40592:4:4:1:::1:0:", -- Stormrage Legguards
	[16902]=":30554:4:4:1:::1:0:", -- Stormrage Pauldrons
	[16903]=":20444:4:4:1:::1:0:", -- Stormrage Belt
	[16904]=":20519:4:4:1:::1:0:", -- Stormrage Bracers
	[16905]=":41189:4:4:1:::1:0:", -- Bloodfang Chestpiece
	[16906]=":31001:4:4:1:::1:0:", -- Bloodfang Boots
	[16907]=":20742:4:4:1:::1:0:", -- Bloodfang Gloves
	[16908]=":31226:4:4:1:::1:0:", -- Bloodfang Hood
	[16909]=":38795:4:4:1:::1:0:", -- Bloodfang Pants
	[16910]=":19472:4:4:1:::1:0:", -- Bloodfang Belt
	[16911]=":19547:4:4:1:::1:0:", -- Bloodfang Bracers
	[16912]=":23547:4:4:1:::1:0:", -- Netherwind Boots
	[16913]=":15756:4:4:1:::1:0:", -- Netherwind Gloves
	[16914]=":23725:4:4:1:::1:0:", -- Netherwind Crown
	[16915]=":31753:4:4:1:::1:0:", -- Netherwind Pants
	[16916]=":31873:4:4:1:::1:0:", -- Netherwind Robes
	[16917]=":23992:4:4:1:::1:0:", -- Netherwind Mantle
	[16918]=":16055:4:4:1:::1:0:", -- Netherwind Bindings
	[16919]=":24173:4:4:1:::1:0:", -- Boots of Transcendence
	[16920]=":16175:4:4:1:::1:0:", -- Handguards of Transcendence
	[16921]=":24350:4:4:1:::1:0:", -- Halo of Transcendence
	[16922]=":32587:4:4:1:::1:0:", -- Leggings of Transcendence
	[16923]=":32707:4:4:1:::1:0:", -- Robes of Transcendence
	[16924]=":24618:4:4:1:::1:0:", -- Pauldrons of Transcendence
	[16925]=":16902:4:4:1:::1:0:", -- Belt of Transcendence
	[16926]=":16962:4:4:1:::1:0:", -- Bindings of Transcendence
	[16927]=":25533:4:4:1:::1:0:", -- Nemesis Boots
	[16928]=":15456:4:4:1:::1:0:", -- Nemesis Gloves
	[16929]=":23274:4:4:1:::1:0:", -- Nemesis Skullcap
	[16930]=":31152:4:4:1:::1:0:", -- Nemesis Leggings
	[16931]=":31273:4:4:1:::1:0:", -- Nemesis Robes
	[16932]=":23542:4:4:1:::1:0:", -- Nemesis Spaulders
	[16933]=":15755:4:4:1:::1:0:", -- Nemesis Belt
	[16934]=":15815:4:4:1:::1:0:", -- Nemesis Bracers
	[16935]=":23812:4:4:1:::1:0:", -- Dragonstalker\'s Bracers
	[16936]=":23900:4:4:1:::1:0:", -- Dragonstalker\'s Belt
	[16937]=":36145:4:4:1:::1:0:", -- Dragonstalker\'s Spaulders
	[16938]=":48160:4:4:1:::1:0:", -- Dragonstalker\'s Legguards
	[16939]=":36252:4:4:1:::1:0:", -- Dragonstalker\'s Helm
	[16940]=":24258:4:4:1:::1:0:", -- Dragonstalker\'s Gauntlets
	[16941]=":37656:4:4:1:::1:0:", -- Dragonstalker\'s Greaves
	[16942]=":50167:4:4:1:::1:0:", -- Dragonstalker\'s Breastplate
	[16943]=":25171:4:4:1:::1:0:", -- Bracers of Ten Storms
	[16944]=":25261:4:4:1:::1:0:", -- Belt of Ten Storms
	[16945]=":38196:4:4:1:::1:0:", -- Epaulets of Ten Storms
	[16946]=":50882:4:4:1:::1:0:", -- Legplates of Ten Storms
	[16947]=":38293:4:4:1:::1:0:", -- Helmet of Ten Storms
	[16948]=":23182:4:4:1:::1:0:", -- Gauntlets of Ten Storms
	[16949]=":35063:4:4:1:::1:0:", -- Greaves of Ten Storms
	[16950]=":46724:4:4:1:::1:0:", -- Breastplate of Ten Storms
	[16951]=":27514:4:4:1:::1:0:", -- Judgement Bindings
	[16952]=":27620:4:4:1:::1:0:", -- Judgement Belt
	[16953]=":41273:4:4:1:::1:0:", -- Judgement Spaulders
	[16954]=":55341:4:4:1:::1:0:", -- Judgement Legplates
	[16955]=":41584:4:4:1:::1:0:", -- Judgement Crown
	[16956]=":28040:4:4:1:::1:0:", -- Judgement Gauntlets
	[16957]=":43025:4:4:1:::1:0:", -- Judgement Sabatons
	[16958]=":57681:4:4:1:::1:0:", -- Judgement Breastplate
	[16959]=":29111:4:4:1:::1:0:", -- Bracelets of Wrath
	[16960]=":29217:4:4:1:::1:0:", -- Waistband of Wrath
	[16961]=":43651:4:4:1:::1:0:", -- Pauldrons of Wrath
	[16962]=":58516:4:4:1:::1:0:", -- Legplates of Wrath
	[16963]=":43961:4:4:1:::1:0:", -- Helm of Wrath
	[16964]=":29637:4:4:1:::1:0:", -- Gauntlets of Wrath
	[16965]=":44276:4:4:1:::1:0:", -- Sabatons of Wrath
	[16966]=":59351:4:4:1:::1:0:", -- Breastplate of Wrath
	[16967]="::4:1:1:::1:0:", -- Feralas Ahi
	[16968]="::12:1:1:::1:0:", -- Sar\'theris Striker
	[16969]="::12:1:1:::1:0:", -- Savage Coast Blue Sailfin
	[16970]="::12:1:1:::1:0:", -- Misty Reed Mahi Mahi
	[16971]=":300:0:1:20:::1:0:", -- Clamlette Surprise
	[16972]="::12:1:1:::1:0:", -- Karang\'s Banner
	[16973]="::12:1:1:::1:0:", -- Vial of Dire Water
	[16974]="::12:1:1:::1:0:", -- Empty Water Vial
	[16975]=":813:4:3:1:::1:0:", -- Warsong Sash
	[16976]="::12:1:1:::1:0:", -- Murgut\'s Totem
	[16977]=":1536:4:3:1:::1:0:", -- Warsong Boots
	[16978]=":1233:4:3:1:::1:0:", -- Warsong Gauntlets
	[16979]=":13894:4:4:1:::1:0:", -- Flarecore Gloves
	[16980]=":20632:4:4:1:::1:0:", -- Flarecore Mantle
	[16981]=":292:4:2:1:::1:0:", -- Owlbeard Bracers
	[16982]=":24397:4:4:1:::1:0:", -- Corehound Boots
	[16983]=":25709:4:4:1:::1:0:", -- Molten Helm
	[16984]=":31533:4:4:1:::1:0:", -- Black Dragonscale Boots
	[16985]=":847:4:2:1:::1:0:", -- Windseeker Boots
	[16986]=":850:4:2:1:::1:0:", -- Sandspire Gloves
	[16987]=":884:4:2:1:::1:0:", -- Screecher Belt
	[16988]=":29333:4:4:1:::1:0:", -- Fiery Chain Shoulders
	[16989]=":18610:4:4:1:::1:0:", -- Fiery Chain Girdle
	[16990]=":998:4:2:1:::1:0:", -- Spritekin Cloak
	[16991]="::12:1:1:::1:0:", -- Triage Bandage
	[16992]=":30874:2:2:1:::1:0:", -- Smokey\'s Explosive Launcher
	[16993]=":30989:2:2:1:::1:0:", -- Smokey\'s Fireshooter
	[16994]=":10368:4:2:1:::1:0:", -- Duskwing Gloves
	[16995]=":15609:4:2:1:::1:0:", -- Duskwing Mantle
	[16996]=":38648:2:3:1:::1:0:", -- Gorewood Bow
	[16997]=":38790:2:3:1:::1:0:", -- Stormrager
	[16998]=":33222:4:3:1:::1:0:", -- Sacred Protector
	[16999]=":10709:4:3:1:::1:0:", -- Royal Seal of Alexis
	[17001]=":10314:4:2:1:::1:0:", -- Elemental Circle
	[17002]=":43287:2:2:1:::1:0:", -- Ichor Spitter
	[17003]=":43439:2:2:1:::1:0:", -- Skullstone Hammer
	[17004]=":54493:2:2:1:::1:0:", -- Sarah\'s Guide
	[17005]=":1632:4:2:1:::1:0:", -- Boorguard Tunic
	[17006]=":1966:4:2:1:::1:0:", -- Cobalt Legguards
	[17007]=":11697:4:4:1:::1:0:", -- Stonerender Gauntlets
	[17008]="::15:1:1:::1:0:", -- Small Scroll
	[17009]="::12:1:1:::1:0:", -- Ambassador Malcin\'s Head
	[17010]=":2000:7:3:10::164,202,165,186,197:1:0:", -- Fiery Core
	[17011]=":2000:7:3:10::164,202,165,197:1:0:", -- Lava Core
	[17012]=":1000:7:1:20::164,165,197:1:0:", -- Core Leather
	[17013]=":46272:4:4:1:::1:0:", -- Dark Iron Leggings
	[17014]=":22242:4:4:1:::1:0:", -- Dark Iron Bracers
	[17015]=":53430:2:3:1:::1:0:", -- Dark Iron Reaver
	[17016]=":53627:2:3:1:::1:0:", -- Dark Iron Destroyer
	[17017]="180000:45000:9:1:1:::1:0:12944", -- Pattern: Flarecore Mantle
	[17018]="80000:20000:9:1:1:::1:0:12944", -- Pattern: Flarecore Gloves
	[17020]="1000:250:15:1:20::202,-8:1:0:26744,4878,26751,24843,20915,4220,26758,26765,19235,5139,16588,3323,16612,8361,1308,4083,983,3700,25039,19679,26754,26752,23373,18017,26743,25010,16757,3500,5151,3970,12097,1463,25633,18019,25082,26756,20092,26759,17518,16611,2805,18243,3335,3562,15175,1275,18006,19014,4562,3542,26747,26741,26739,4575,16829,1307,14739,23405,26753,26742,25051,26748,958,3490,20081,13476,3351,19004,18998,17078,23157,1673,1351,19013,24995,26745,26757,23112,1257,10364,19535,23560,22479,26724,23145,26749,26304,12096,16015,5110,26755,26738,23151,16706,18802,24935,19718,26740,19678,25019", -- Arcane Powder
	[17021]="700:175:15:1:20::-11:1:0:26744,4878,26751,24843,20915,4220,26758,26765,19235,5139,16588,3323,16612,8361,1308,4083,983,3700,25039,19679,26754,26752,23373,18017,26743,25010,16757,3500,5151,3970,12097,1463,25633,18019,25082,26756,20092,26759,17518,16611,2805,18243,3335,3562,15175,1275,18006,19014,4562,3542,26747,26741,26739,4575,16829,1307,14739,23405,26753,26742,25051,26748,958,3490,20081,13476,3351,19004,18998,17078,23157,1673,1351,19013,24995,26745,26757,23112,1257,10364,19535,23560,22479,26724,23145,26749,12096,16015,5110,26755,26738,23151,16706,18802,24935,19718,26740,19678,25019", -- Wild Berries
	[17022]="150000:37500:9:1:1:::1:0:12944", -- Pattern: Corehound Boots
	[17023]="160000:40000:9:1:1:::1:0:12944", -- Pattern: Molten Helm
	[17025]="160000:40000:9:1:1:::1:0:12944", -- Pattern: Black Dragonscale Boots
	[17026]="1000:250:15:1:20::-11:1:0:26744,4878,26751,24843,20915,4220,26758,26765,19235,5139,16588,3323,16612,8361,1308,4083,983,3700,25039,19679,26754,26752,23373,18017,26743,25010,16757,3500,5151,3970,12097,1463,25633,18019,25082,26756,20092,26759,17518,16611,2805,18243,3335,3562,15175,1275,18006,19014,4562,3542,26747,26741,26739,4575,16829,1307,14739,23405,26753,26742,25051,26748,958,3490,20081,13476,3351,19004,18998,17078,23157,1673,1351,19013,24995,26745,26757,23112,1257,10364,19535,23560,22479,26724,23145,26749,12096,16015,5110,26755,26738,23151,16706,18802,24935,19718,26740,19678,25019", -- Wild Thornroot
	[17028]="700:175:15:1:20::-5:1:0:26744,4878,26751,24843,20915,4220,26758,26765,19235,5139,16588,3323,16612,8361,1308,4083,983,3700,25039,19679,26754,26752,23373,18017,26743,25010,16757,3500,5151,3970,12097,1463,25633,18019,25082,26756,20092,26759,17518,16611,2805,18243,3335,3562,15175,1275,18006,19014,4562,3542,26747,26741,26739,4575,16829,1307,14739,23405,26753,26742,25051,26748,958,3490,20081,13476,3351,19004,18998,17078,23157,1673,1351,19013,24995,26745,26757,23112,1257,10364,19535,23560,22479,26724,23145,26749,12096,16015,5110,26755,26738,23151,16706,18802,24935,19718,26740,19678,25019", -- Holy Candle
	[17029]="1000:250:15:1:20::-5:1:0:26744,4878,26751,24843,20915,4220,26758,26765,19235,5139,16588,3323,16612,8361,1308,4083,983,3700,25039,19679,26754,26752,23373,18017,26743,25010,16757,3500,5151,3970,12097,1463,25633,18019,25082,26756,20092,26759,17518,16611,2805,18243,3335,3562,15175,1275,18006,19014,4562,3542,26747,26741,26739,4575,16829,1307,14739,23405,26753,26742,25051,26748,958,3490,20081,13476,3351,19004,18998,17078,23157,1673,1351,19013,24995,26745,26757,23112,1257,10364,19535,23560,22479,26724,23145,26749,26304,12096,16015,5110,26755,26738,23151,16706,18802,24935,19718,26740,19678,25019", -- Sacred Candle
	[17030]="2000:500:15:1:10::-7:1:0:26744,4878,26751,24843,20915,4220,26758,26765,19235,5139,16588,3323,16612,8361,1308,4083,983,3700,25039,19679,26754,26752,23373,18017,26743,25010,16757,3500,5151,3970,12097,1463,25633,18019,25082,26756,20092,26759,17518,16611,2805,18243,3335,3562,15175,1275,18006,19014,4562,3542,26747,26741,26739,4575,16829,1307,14739,23405,26753,26742,25051,26748,958,3490,20081,13476,3351,19004,18998,17078,23157,1673,1351,19013,24995,26745,26757,23112,1257,10364,19535,23560,22479,26724,23145,26749,26304,12096,16015,5110,26755,26738,23151,16706,18802,24935,19718,26740,19678,25019", -- Ankh
	[17031]="1000:250:15:1:20::-8:1:0:26744,4878,26751,24843,20915,4220,26758,26765,19235,5139,16588,3323,16612,8361,1308,4083,983,3700,25039,19679,26754,26752,23373,18017,26743,25010,16757,3500,5151,3970,12097,1463,25633,18019,25082,26756,20092,26759,17518,16611,2805,18243,3335,3562,15175,1275,18006,19014,4562,3542,26747,26741,26739,4575,16829,1307,14739,23405,26753,26742,25051,26748,958,3490,20081,13476,3351,19004,18998,17078,23157,1673,1351,19013,24995,26745,26757,23112,1257,10364,19535,23560,22479,26724,23145,26749,12096,16015,5110,26755,26738,23151,16706,18802,24935,19718,26740,19678,25019", -- Rune of Teleportation
	[17032]="2000:500:15:1:20::-8:1:0:26744,4878,26751,24843,20915,4220,26758,26765,19235,5139,16588,3323,16612,8361,1308,4083,983,3700,25039,19679,26754,26752,23373,18017,26743,25010,16757,3500,5151,3970,12097,1463,25633,18019,25082,26756,20092,26759,17518,16611,2805,18243,3335,3562,15175,1275,18006,19014,4562,3542,26747,26741,26739,4575,16829,1307,14739,23405,26753,26742,25051,26748,958,3490,20081,13476,3351,19004,18998,17078,23157,1673,1351,19013,24995,26745,26757,23112,1257,10364,19535,23560,22479,26724,23145,26749,12096,16015,5110,26755,26738,23151,16706,18802,24935,19718,26740,19678,25019", -- Rune of Portals
	[17033]="2000:500:15:1:5::-2:1:0:26744,4878,26751,24843,20915,4220,26758,26765,19235,5139,16588,3323,16612,8361,1308,4083,983,3700,25039,19679,26754,26752,23373,18017,26743,25010,16757,3500,5151,3970,12097,1463,25633,18019,25082,26756,20092,26759,17518,16611,2805,18243,3335,3562,15175,1275,18006,19014,4562,3542,26747,26741,26739,4575,16829,1307,14739,23405,26753,26742,25051,26748,958,3490,20081,13476,3351,19004,18998,17078,23157,1673,1351,19013,24995,26745,26757,23112,1257,10364,19535,23560,22479,26724,23145,26749,26304,12096,16015,5110,26755,26738,23151,16706,18802,24935,19718,26740,19678,25019", -- Symbol of Divinity
	[17034]="200:50:15:1:20::333,-11:1:0:26744,4878,26751,24843,4220,26758,26765,5139,3323,16612,8361,1308,4083,983,3700,26754,26752,26743,25010,16757,3500,5151,3970,12097,1463,25633,25082,18019,26756,26759,16611,2805,18243,3562,3335,15175,1275,18006,4562,3542,26747,26741,26739,4575,16829,1307,14739,23405,26753,26742,25051,26748,3490,958,20081,13476,3351,19004,17078,1673,1351,24995,26745,23112,26757,1257,10364,23560,22479,26724,26749,12096,16015,5110,26755,26738,23151,16706,24935,19718,26740,19678,25019", -- Maple Seed
	[17035]="400:100:15:1:20::333,-11:1:0:26744,4878,26751,24843,4220,26758,26765,5139,3323,16612,8361,1308,4083,983,3700,26754,26752,26743,25010,16757,3500,5151,3970,12097,1463,25633,25082,18019,26756,26759,16611,2805,18243,3562,3335,15175,1275,18006,4562,3542,26747,26741,26739,4575,16829,1307,14739,23405,26753,26742,25051,26748,3490,958,20081,13476,3351,19004,17078,1673,1351,24995,26745,23112,26757,1257,10364,23560,22479,26724,26749,12096,16015,5110,26755,26738,23151,16706,24935,19718,26740,19678,25019", -- Stranglethorn Seed
	[17036]="800:200:15:1:20::-11:1:0:26744,4878,26751,24843,4220,26758,26765,5139,3323,16612,8361,1308,4083,983,3700,26754,26752,26743,25010,16757,3500,5151,3970,12097,1463,25633,25082,18019,26756,26759,16611,2805,18243,3562,3335,15175,1275,18006,4562,3542,26747,26741,26739,4575,16829,1307,14739,23405,26753,26742,25051,26748,3490,958,20081,13476,3351,19004,17078,1673,1351,24995,26745,23112,26757,1257,10364,23560,22479,26724,26749,12096,16015,5110,26755,26738,23151,16706,24935,19718,26740,19678,25019", -- Ashwood Seed
	[17037]="1400:350:15:1:20::-11:1:0:26744,4878,26751,24843,20915,4220,26758,26765,19235,5139,16588,3323,16612,8361,1308,4083,983,3700,25039,19679,26754,26752,23373,18017,26743,25010,16757,3500,5151,3970,12097,1463,25633,18019,25082,26756,20092,26759,17518,16611,2805,18243,3335,3562,15175,1275,18006,19014,4562,3542,26747,26741,26739,4575,16829,1307,14739,23405,26753,26742,25051,26748,958,3490,20081,13476,3351,19004,18998,17078,23157,1673,1351,19013,24995,26745,26757,23112,1257,10364,19535,23560,22479,26724,23145,26749,12096,16015,5110,26755,26738,23151,16706,18802,24935,19718,26740,19678,25019", -- Hornbeam Seed
	[17038]="2000:500:15:1:20::-11:1:0:26744,4878,26751,24843,20915,4220,26758,26765,19235,5139,16588,3323,16612,8361,1308,4083,983,3700,25039,19679,26754,26752,23373,18017,26743,25010,16757,3500,5151,3970,12097,1463,25633,18019,25082,26756,20092,26759,17518,16611,2805,18243,3335,3562,15175,1275,18006,19014,4562,3542,26747,26741,26739,4575,16829,1307,14739,23405,26753,26742,25051,26748,958,3490,20081,13476,3351,19004,18998,17078,23157,1673,1351,19013,24995,26745,26757,23112,1257,10364,19535,23560,22479,26724,23145,26749,12096,16015,5110,26755,26738,23151,16706,18802,24935,19718,26740,19678,25019", -- Ironwood Seed
	[17039]=":8317:2:2:1:::1:0:", -- Skullbreaker
	[17042]=":5706:2:2:1:::1:0:", -- Nail Spitter
	[17043]=":3055:4:2:1:::1:0:", -- Zealot\'s Robe
	[17044]=":15038:4:3:1:::1:0:", -- Will of the Martyr
	[17045]=":14846:4:3:1:::1:0:", -- Blood of the Martyr
	[17046]=":4796:2:2:1:::1:0:", -- Gutterblade
	[17047]=":1313:4:2:1:::1:0:", -- Luminescent Amice
	[17048]=":400:0:1:10:::1:0:", -- Rumsey Rum
	[17049]="90000:22500:9:3:1:::1:0:12944", -- Plans: Fiery Chain Girdle
	[17050]=":12536:4:3:1:::1:0:", -- Chan\'s Imperial Robes
	[17051]="70000:17500:9:3:1:::1:0:12944", -- Plans: Dark Iron Bracers
	[17052]="180000:45000:9:3:1:::1:0:12944", -- Plans: Dark Iron Leggings
	[17053]="200000:50000:9:3:1:::1:0:12944", -- Plans: Fiery Chain Shoulders
	[17054]=":28788:2:3:1:::1:0:", -- Joonho\'s Mercy
	[17055]=":28892:2:3:1:::1:0:", -- Changuk Smasher
	[17056]="30:7:15:1:20::165,-8,-5:1:0:26304", -- Light Feather
	[17057]="30:7:15:1:20::-7:1:0:26304", -- Shiny Fish Scales
	[17058]="30:7:15:1:20::-7:1:0:26304", -- Fish Oil
	[17059]="220000:55000:9:3:1:::1:0:12944", -- Plans: Dark Iron Reaver
	[17060]="220000:55000:9:3:1:::1:0:12944", -- Plans: Dark Iron Destroyer
	[17061]=":12888:4:3:1:::1:0:", -- Juno\'s Shadow
	[17062]="2200:550:9:1:1:::1:0:4574,5162,4307,2383,3178,12033,2664,3333,12962", -- Recipe: Mithril Head Trout
	[17063]=":23961:4:4:1:::1:0:", -- Band of Accuria
	[17064]=":45914:4:4:1:::1:0:", -- Shard of the Scale
	[17065]=":33381:4:4:1:::1:0:", -- Medallion of Steadfast Might
	[17066]=":45228:4:4:1:::1:0:", -- Drillborer Disk
	[17067]=":75452:4:4:1:::1:0:", -- Ancient Cornerstone Grimoire
	[17068]=":78453:2:4:1:::1:0:", -- Deathbringer
	[17069]=":54968:2:4:1:::1:0:", -- Striker\'s Mark
	[17070]=":76483:2:4:1:::1:0:", -- Fang of the Mystics
	[17071]=":75814:2:4:1:::1:0:", -- Gutgore Ripper
	[17072]=":57776:2:4:1:::1:0:", -- Blastershot Launcher
	[17073]=":91903:2:4:1:::1:0:", -- Earthshaker
	[17074]=":88668:2:4:1:::1:0:", -- Shadowstrike
	[17075]=":81686:2:4:1:::1:0:", -- Vis\'kag the Bloodletter
	[17076]=":106067:2:4:1:::1:0:", -- Bonereaver\'s Edge
	[17077]=":53771:2:4:1:::1:0:", -- Crimson Shocker
	[17078]=":24190:4:4:1:::1:0:", -- Sapphiron Drape
	[17082]=":46146:4:4:1:::1:0:", -- Shard of the Flame
	[17102]=":23363:4:4:1:::1:0:", -- Cloak of the Shrouded Mists
	[17103]=":75431:2:4:1:::1:0:", -- Azuresong Mageblade
	[17104]=":100375:2:4:1:::1:0:", -- Spinal Reaper
	[17105]=":74149:2:4:1:::1:0:", -- Aurastone Hammer
	[17106]=":51180:4:4:1:::1:0:", -- Malistar\'s Defender
	[17107]=":23523:4:4:1:::1:0:", -- Dragon\'s Blood Cape
	[17109]=":33625:4:4:1:::1:0:", -- Choker of Enlightenment
	[17110]=":24648:4:4:1:::1:0:", -- Seal of the Archmagus
	[17111]=":34648:4:4:1:::1:0:", -- Blazefury Medallion
	[17112]=":73242:2:4:1:::1:0:", -- Empyrean Demolisher
	[17113]=":93061:2:4:1:::1:0:", -- Amberseal Keeper
	[17114]="::12:1:1:::1:0:", -- Araj\'s Phylactery Shard
	[17117]="::12:1:1:::1:0:", -- Rat Catcher\'s Flute
	[17118]="::12:1:1:::1:0:", -- Carton of Mystery Meat
	[17119]="125:6:0:1:20:::5:0:13018", -- Deeprun Rat Kabob
	[17124]="::12:1:100:::1:0:", -- Syndicate Emblem
	[17125]="::12:1:1:::1:0:", -- Seal of Ravenholdt
	[17126]="::12:1:1:::1:0:", -- Elegant Letter
	[17182]=":160402:2:5:1:::1:0:", -- Sulfuras, Hand of Ragnaros
	[17183]="36:7:4:1:1:::1:0:16693,2116,3075,4559,3161", -- Dented Buckler
	[17184]="36:7:4:1:1:::1:0:16762,4240,3592,1104,16917,1213", -- Small Shield
	[17185]="260:52:4:1:1:::1:0:16693,3080,16258,4559,2135,3167,3319", -- Round Buckler
	[17186]="260:52:4:1:1:::1:0:5106,16762,4240,17930,1249,1292,2046,3613", -- Small Targe
	[17187]="1161:232:4:1:1:::1:0:16693,4559,4187,3319,8360,16762,5107,4560,3528", -- Banded Buckler
	[17188]="2447:489:4:1:1:::1:0:4240,16693,1319,3319,8360,16762,3493,5126,793", -- Ringed Buckler
	[17189]="13054:2610:4:1:1:::1:0:5819,4240,8129,1323,5812,5125,1349,1322,1319,4177,2845,3095,1381,5126", -- Metal Buckler
	[17190]="37647:7529:4:1:1:::1:0:5819,4240,8129,1323,5812,5508,1349,1319,4177,3095,980,16626,5126,11182,16753", -- Ornate Buckler
	[17191]="::12:3:1:::1:0:", -- Scepter of Celebras
	[17192]="4820:964:4:1:1:::1:0:5819,4240,16693,1323,5812,1450,1349,1319,4886,3095,16762,6028,5126,226", -- Reinforced Targe
	[17193]=":95427:2:4:1:::1:0:", -- Sulfuron Hammer
	[17194]="10::15:1:20::185:5:0:13429,23010,13435,23064,13420,23012,13432,13433", -- Holiday Spices
	[17195]="::15:1:20:::1:0:", -- Fake Mistletoe
	[17196]="50:12:0:1:20::185:1:0:13429,23010,13435,23064,13420,23012,13432,13433", -- Holiday Spirits
	[17197]=":10:0:1:20:::1:0:", -- Gingerbread Cookie
	[17198]=":9:0:1:20:::1:0:", -- Egg Nog
	[17200]="25:6:9:1:1:::1:0:13429,23010,13435,23064,13420,23012,13432,13433", -- Recipe: Gingerbread Cookie
	[17201]="240:60:9:1:1:::1:0:13429,23010,13435,23064,13420,23012,13432,13433", -- Recipe: Egg Nog
	[17202]="10::15:1:20::202:5:0:13429,23010,13435,23064,13420,23012,13432,13433", -- Snowball
	[17203]=":100000:7:4:20::164:1:0:", -- Sulfuron Ingot
	[17204]=":200000:7:5:1:::1:0:", -- Eye of Sulfuras
	[17222]=":300:0:1:20:::1:0:", -- Spider Sausage
	[17223]=":87372:2:4:1:::1:0:", -- Thunderstrike
	[17224]="::12:2:1:::1:0:", -- Scrying Scope
	[17302]="::15:1:1:::1:0:", -- Blue Ribboned Holiday Gift
	[17303]="10:2:15:1:10:::1:0:13429,23010,13435,23064,13420,23012,13432,13433", -- Blue Ribboned Wrapping Paper
	[17304]="10:2:15:1:10:::1:0:13429,23010,13435,23064,13420,23012,13432,13433", -- Green Ribboned Wrapping Paper
	[17305]="::15:1:1:::1:0:", -- Green Ribboned Holiday Gift
	[17306]="::12:1:100:::1:0:", -- Stormpike Soldier\'s Blood
	[17307]="10:2:15:1:10:::1:0:13429,23010,13435,23064,13420,23012,13432,13433", -- Purple Ribboned Wrapping Paper
	[17308]="::15:1:1:::1:0:", -- Purple Ribboned Holiday Gift
	[17309]="::12:1:20:::1:0:", -- Discordant Bracers
	[17310]="::12:1:1:::1:0:", -- Aspect of Neptulon
	[17322]="::12:1:1:::1:0:", -- Eye of the Emberseer
	[17326]="::12:1:100:::1:0:", -- Stormpike Soldier\'s Flesh
	[17327]="::12:1:100:::1:0:", -- Stormpike Lieutenant\'s Flesh
	[17328]="::12:1:100:::1:0:", -- Stormpike Commander\'s Flesh
	[17329]="::12:1:1:::1:0:", -- Hand of Lucifron
	[17330]="::12:1:1:::1:0:", -- Hand of Sulfuron
	[17331]="::12:1:1:::1:0:", -- Hand of Gehennas
	[17332]="::12:1:1:::1:0:", -- Hand of Shazzrah
	[17333]="::12:1:1:::1:0:", -- Aqual Quintessence
	[17344]="25:1:0:1:20:::5:0:13429,23010,13435,23064,13420,23012,13432,13433", -- Candy Cane
	[17345]="::12:1:20:::1:0:", -- Silithid Goo
	[17346]="::12:1:1:::1:0:", -- Encrusted Silithid Object
	[17348]="1000:250:0:1:10:::1:0:14753,13218,13217,13219,13216,14754", -- Major Healing Draught
	[17349]="500:125:0:1:10:::1:0:14753,15127,13218,13217,13219,13216,14754,15126", -- Superior Healing Draught
	[17351]="1000:250:0:1:10:::1:0:14753,13218,13217,13219,13216,14754", -- Major Mana Draught
	[17352]="500:125:0:1:10:::1:0:14753,15127,13218,13217,13219,13216,14754,15126", -- Superior Mana Draught
	[17355]="::12:1:1:::1:0:", -- Rabine\'s Letter
	[17364]="::12:2:1:::1:0:", -- Scrying Scope
	[17384]="::15:3:1:::1:0:", -- Zinfizzlex\'s Portable Shredder Unit
	[17402]="2000:500:0:1:20:::1:0:23065,23009,13418,13434,23011,13431,13430,13436", -- Greatfather\'s Winter Ale
	[17403]="150:37:0:1:20:::1:0:23065,23009,13418,13434,23011,13431,13430,13436", -- Steamwheedle Fizzy Spirits
	[17404]="125:6:0:1:20:::5:0:23065,23009,13418,13434,23011,13431,13430,13436", -- Blended Bean Brew
	[17405]="1000:50:15:1:20:::5:0:23065,23009,13418,13434,23011,13431,13430,13436", -- Green Garden Tea
	[17406]="125:6:0:1:20:::5:0:23065,23009,13418,13434,23011,13431,13430,13436", -- Holiday Cheesewheel
	[17407]="1000:50:0:1:20:::5:0:23065,23009,13418,13434,23011,13431,13430,13436", -- Graccu\'s Homemade Meat Pie
	[17408]="2000:100:0:1:20:::5:0:23065,23009,13418,13434,23011,13431,13430,13436", -- Spicy Beefstick
	[17410]="::15:3:1:::1:0:", -- Zinfizzlex\'s Portable Shredder Unit
	[17411]="::12:1:1:::1:0:", -- Steamsaw
	[17413]=":7750:9:3:1:::1:0:", -- Codex: Prayer of Fortitude
	[17414]=":14750:9:3:1:::1:0:", -- Codex: Prayer of Fortitude II
	[17422]=":2:12:1:100:::1:0:", -- Armor Scraps
	[17423]="::12:1:100:::1:0:", -- Storm Crystal
	[17502]="::12:1:100:::1:0:", -- Frostwolf Soldier\'s Medal
	[17503]="::12:1:100:::1:0:", -- Frostwolf Lieutenant\'s Medal
	[17504]="::12:1:100:::1:0:", -- Frostwolf Commander\'s Medal
	[17508]=":7880:4:2:1:::1:0:", -- Forcestone Buckler
	[17522]=":2:12:1:20:::1:0:", -- Irondeep Supplies
	[17523]=":11453:4:2:1:::1:0:", -- Smokey\'s Drape
	[17542]=":2:12:1:20:::1:0:", -- Coldtooth Supplies
	[17562]=":7863:4:3:1:::1:0:", -- Knight-Lieutenant\'s Dreadweave Boots
	[17564]=":5280:4:3:1:::1:0:", -- Knight-Lieutenant\'s Dreadweave Gloves
	[17566]=":7977:4:3:1:::1:0:", -- Lieutenant Commander\'s Headguard
	[17567]=":10675:4:3:1:::1:0:", -- Knight-Captain\'s Dreadweave Leggings
	[17568]=":9949:4:3:1:::1:0:", -- Knight-Captain\'s Dreadweave Robe
	[17569]=":7491:4:3:1:::1:0:", -- Lieutenant Commander\'s Dreadweave Mantle
	[17570]=":7519:4:3:1:::1:0:", -- Champion\'s Dreadweave Hood
	[17571]=":10064:4:3:1:::1:0:", -- Legionnaire\'s Dreadweave Leggings
	[17572]=":10102:4:3:1:::1:0:", -- Legionnaire\'s Dreadweave Robe
	[17573]=":7605:4:3:1:::1:0:", -- Champion\'s Dreadweave Shoulders
	[17576]=":7690:4:3:1:::1:0:", -- Blood Guard\'s Dreadweave Boots
	[17577]=":5146:4:3:1:::1:0:", -- Blood Guard\'s Dreadweave Gloves
	[17578]="::4:4:1:::1:0:12785", -- Field Marshal\'s Coronal
	[17579]="::4:4:1:::1:0:12785", -- Marshal\'s Dreadweave Leggings
	[17580]="::4:4:1:::1:0:12785", -- Field Marshal\'s Dreadweave Shoulders
	[17581]="::4:4:1:::1:0:12785", -- Field Marshal\'s Dreadweave Robe
	[17583]="::4:4:1:::1:0:12785", -- Marshal\'s Dreadweave Boots
	[17584]="::4:4:1:::1:0:12785", -- Marshal\'s Dreadweave Gloves
	[17586]="::4:4:1:::1:0:12795", -- General\'s Dreadweave Boots
	[17588]="::4:4:1:::1:0:12795", -- General\'s Dreadweave Gloves
	[17590]="::4:4:1:::1:0:12795", -- Warlord\'s Dreadweave Mantle
	[17591]="::4:4:1:::1:0:12795", -- Warlord\'s Dreadweave Hood
	[17592]="::4:4:1:::1:0:12795", -- Warlord\'s Dreadweave Robe
	[17593]="::4:4:1:::1:0:12795", -- General\'s Dreadweave Pants
	[17594]=":7633:4:3:1:::1:0:", -- Knight-Lieutenant\'s Satin Boots
	[17596]=":5126:4:3:1:::1:0:", -- Knight-Lieutenant\'s Satin Gloves
	[17598]=":7746:4:3:1:::1:0:", -- Lieutenant Commander\'s Diadem
	[17599]=":10367:4:3:1:::1:0:", -- Knight-Captain\'s Satin Leggings
	[17600]=":10680:4:3:1:::1:0:", -- Knight-Captain\'s Satin Robes
	[17601]=":8039:4:3:1:::1:0:", -- Lieutenant Commander\'s Satin Amice
	[17602]="::4:4:1:::1:0:12785", -- Field Marshal\'s Headdress
	[17603]="::4:4:1:::1:0:12785", -- Marshal\'s Satin Pants
	[17604]="::4:4:1:::1:0:12785", -- Field Marshal\'s Satin Mantle
	[17605]="::4:4:1:::1:0:12785", -- Field Marshal\'s Satin Vestments
	[17607]="::4:4:1:::1:0:12785", -- Marshal\'s Satin Sandals
	[17608]="::4:4:1:::1:0:12785", -- Marshal\'s Satin Gloves
	[17610]=":7517:4:3:1:::1:0:", -- Champion\'s Satin Cowl
	[17611]=":10061:4:3:1:::1:0:", -- Legionnaire\'s Satin Trousers
	[17612]=":10100:4:3:1:::1:0:", -- Legionnaire\'s Satin Vestments
	[17613]=":7603:4:3:1:::1:0:", -- Champion\'s Satin Shoulderpads
	[17616]=":7895:4:3:1:::1:0:", -- Blood Guard\'s Satin Boots
	[17617]=":5282:4:3:1:::1:0:", -- Blood Guard\'s Satin Gloves
	[17618]="::4:4:1:::1:0:12795", -- General\'s Satin Boots
	[17620]="::4:4:1:::1:0:12795", -- General\'s Satin Gloves
	[17622]="::4:4:1:::1:0:12795", -- Warlord\'s Satin Mantle
	[17623]="::4:4:1:::1:0:12795", -- Warlord\'s Satin Cowl
	[17624]="::4:4:1:::1:0:12795", -- Warlord\'s Satin Robes
	[17625]="::4:4:1:::1:0:12795", -- General\'s Satin Leggings
	[17626]="::12:1:1:::1:0:", -- Frostwolf Muzzle
	[17642]="::12:1:100:::1:0:", -- Alterac Ram Hide
	[17643]="::12:1:100:::1:0:", -- Frostwolf Hide
	[17662]="::12:1:1:::1:0:", -- Stolen Treats
	[17682]=":8750:9:3:1:::1:0:", -- Book: Gift of the Wild
	[17683]=":14750:9:3:1:::1:0:", -- Book: Gift of the Wild II
	[17684]="::12:1:30:::1:0:", -- Theradric Crystal Carving
	[17685]="::15:1:1:::1:0:", -- Smokywood Pastures Sampler
	[17686]=":10192:2:2:1:::1:0:", -- Master Hunter\'s Bow
	[17687]=":10231:2:2:1:::1:0:", -- Master Hunter\'s Rifle
	[17688]=":5695:4:2:1:::1:0:", -- Jungle Boots
	[17689]="::12:1:1:::1:0:", -- Stormpike Training Collar
	[17690]="::4:2:1:::1:0:", -- Frostwolf Insignia Rank 1
	[17691]="::4:2:1:::1:0:", -- Stormpike Insignia Rank 1
	[17692]=":881:4:2:1:::1:0:", -- Horn Ring
	[17693]="::12:1:1:::1:0:", -- Coated Cerulean Vial
	[17694]=":881:4:2:1:::1:0:", -- Band of the Fist
	[17695]=":930:4:2:1:::1:0:", -- Chestnut Mantle
	[17696]="::12:1:1:::1:0:", -- Filled Cerulean Vial
	[17702]="::12:1:1:::1:0:", -- Celebrian Rod
	[17703]="::12:1:1:::1:0:", -- Celebrian Diamond
	[17704]=":9178:2:2:1:::1:0:", -- Edge of Winter
	[17705]=":32854:2:3:1:::1:0:", -- Thrash Blade
	[17706]=":950:9:2:1:::1:0:", -- Plans: Edge of Winter
	[17707]=":11631:4:3:1:::1:0:", -- Gemshard Heart
	[17708]=":35:0:1:20:::1:0:", -- Elixir of Frost Power
	[17709]=":500:9:1:1:::1:0:", -- Recipe: Elixir of Frost Power
	[17710]=":35483:2:3:1:::1:0:", -- Charstone Dirk
	[17711]=":24928:4:3:1:::1:0:", -- Elemental Rockridge Leggings
	[17712]="::15:1:1:::1:0:", -- Winter Veil Disguise Kit
	[17713]=":14641:4:3:1:::1:0:", -- Blackstone Ring
	[17714]=":11086:4:3:1:::1:0:", -- Bracers of the Stone Princess
	[17715]=":11125:4:3:1:::1:0:", -- Eye of Theradras
	[17716]=":7500:7:1:1:::1:0:", -- Snowmaster 9000
	[17717]=":26426:2:3:1:::1:0:", -- Megashot Rifle
	[17718]=":22630:4:3:1:::1:0:", -- Gizlock\'s Hypertech Buckler
	[17719]=":32106:2:3:1:::1:0:", -- Inventor\'s Focal Sword
	[17720]=":600:9:2:1:::1:0:", -- Schematic: Snowmaster 9000
	[17721]=":2268:4:2:1:::1:0:", -- Gloves of the Greatfather
	[17722]=":700:9:2:1:::1:0:", -- Pattern: Gloves of the Greatfather
	[17723]=":750:4:1:1:::1:0:", -- Green Holiday Shirt
	[17724]=":375:9:1:1:::1:0:", -- Pattern: Green Holiday Shirt
	[17725]=":750:9:2:1:::1:0:", -- Formula: Enchant Weapon - Winter\'s Might
	[17726]="::15:1:1:::1:0:", -- Smokywood Pastures Special Gift
	[17727]="::15:1:1:::1:0:", -- Smokywood Pastures Gift Pack
	[17728]=":12458:4:3:1:::1:0:", -- Albino Crocscale Boots
	[17730]=":42952:2:3:1:::1:0:", -- Gatorbite Axe
	[17732]=":10383:4:3:1:::1:0:", -- Rotgrip Mantle
	[17733]=":34735:2:3:1:::1:0:", -- Fist of Stone
	[17734]=":18265:4:3:1:::1:0:", -- Helm of the Mountain
	[17735]="::15:1:1:::1:0:", -- The Feast of Winter Veil
	[17736]=":10532:4:3:1:::1:0:", -- Rockgrip Gauntlets
	[17737]=":10163:4:3:1:::1:0:", -- Cloud Stone
	[17738]=":33351:2:3:1:::1:0:", -- Claw of Celebras
	[17739]=":9085:4:3:1:::1:0:", -- Grovekeeper\'s Drape
	[17740]=":11401:4:3:1:::1:0:", -- Soothsayer\'s Headdress
	[17741]=":11516:4:3:1:::1:0:", -- Nature\'s Embrace
	[17742]=":14450:4:3:1:::1:0:", -- Fungus Shroud Armor
	[17743]=":40748:2:3:1:::1:0:", -- Resurgence Rod
	[17744]=":9031:4:3:1:::1:0:", -- Heart of Noxxion
	[17745]=":22520:2:3:1:::1:0:", -- Noxious Shooter
	[17746]=":10608:4:3:1:::1:0:", -- Noxxion\'s Shackles
	[17747]=":500:0:1:5:::1:0:", -- Razorlash Root
	[17748]=":9107:4:3:1:::1:0:", -- Vinerot Sandals
	[17749]=":11425:4:3:1:::1:0:", -- Phytoskin Spaulders
	[17750]=":6115:4:3:1:::1:0:", -- Chloromesh Girdle
	[17751]=":15344:4:3:1:::1:0:", -- Brusslehide Leggings
	[17752]=":28785:2:3:1:::1:0:", -- Satyr\'s Lash
	[17753]=":26046:2:3:1:::1:0:", -- Verdant Keeper\'s Aim
	[17754]=":17394:4:3:1:::1:0:", -- Infernal Trickster Leggings
	[17755]=":5818:4:3:1:::1:0:", -- Satyrmane Sash
	[17756]="::12:1:20:::1:0:", -- Shadowshard Fragment
	[17757]="::12:1:1:::1:0:", -- Amulet of Spirits
	[17758]="::12:1:1:::1:0:", -- Amulet of Union
	[17759]=":10307:4:2:1:::1:0:", -- Mark of Resolution
	[17760]="::12:1:1:::1:0:", -- Seed of Life
	[17761]="::12:1:1:::1:0:", -- Gem of the First Khan
	[17762]="::12:1:1:::1:0:", -- Gem of the Second Khan
	[17763]="::12:1:1:::1:0:", -- Gem of the Third Khan
	[17764]="::12:1:1:::1:0:", -- Gem of the Fourth Khan
	[17765]="::12:1:1:::1:0:", -- Gem of the Fifth Khan
	[17766]=":44863:2:3:1:::1:0:", -- Princess Theradras\' Scepter
	[17767]=":13610:4:3:1:::1:0:", -- Bloomsprout Headpiece
	[17768]=":7891:4:2:1:::1:0:", -- Woodseed Hoop
	[17770]=":6778:4:2:1:::1:0:", -- Branchclaw Gauntlets
	[17771]=":100000:7:5:20:::1:0:", -- Elementium Bar
	[17772]=":7132:4:2:1:::1:0:", -- Zealous Shadowshard Pendant
	[17773]=":7132:4:2:1:::1:0:", -- Prodigious Shadowshard Pendant
	[17774]=":6133:4:2:1:::1:0:", -- Mark of the Chosen
	[17775]=":7841:4:2:1:::1:0:", -- Acumen Robes
	[17776]=":7377:4:2:1:::1:0:", -- Sprightring Helm
	[17777]=":11011:4:2:1:::1:0:", -- Relentless Chain
	[17778]=":4605:4:2:1:::1:0:", -- Sagebrush Girdle
	[17779]=":9689:4:2:1:::1:0:", -- Hulkstone Pauldrons
	[17780]=":46796:2:4:1:::1:0:", -- Blade of Eternal Darkness
	[17781]="::12:1:1:::1:0:", -- The Pariah\'s Instructions
	[17782]=":33625:4:5:1:::1:0:", -- Talisman of Binding Shard
	[17849]="::12:1:1:::1:0:", -- Stormpike Banner
	[17850]="::12:1:1:::1:0:", -- Frostwolf Banner
	[17900]="::4:2:1:::1:0:", -- Stormpike Insignia Rank 2
	[17901]="::4:2:1:::1:0:", -- Stormpike Insignia Rank 3
	[17902]="::4:3:1:::1:0:", -- Stormpike Insignia Rank 4
	[17903]="::4:3:1:::1:0:", -- Stormpike Insignia Rank 5
	[17904]="::4:4:1:::1:0:", -- Stormpike Insignia Rank 6
	[17905]="::4:2:1:::1:0:", -- Frostwolf Insignia Rank 2
	[17906]="::4:2:1:::1:0:", -- Frostwolf Insignia Rank 3
	[17907]="::4:3:1:::1:0:", -- Frostwolf Insignia Rank 4
	[17908]="::4:3:1:::1:0:", -- Frostwolf Insignia Rank 5
	[17909]="::4:4:1:::1:0:", -- Frostwolf Insignia Rank 6
	[17922]=":125:4:2:1:::1:0:", -- Lionfur Armor
	[17943]=":35234:2:3:1:::1:0:", -- Fist of Stone
	[17962]=":4762:15:2:1:::1:0:", -- Blue Sack of Gems
	[17963]=":213:15:2:1:::1:0:", -- Green Sack of Gems
	[17964]=":5512:15:2:1:::1:0:", -- Gray Sack of Gems
	[17965]=":213:15:2:1:::1:0:", -- Yellow Sack of Gems
	[17966]=":8750:1:2:1:::1:0:", -- Onyxia Hide Backpack
	[17968]=":5000:7:3:20:::1:0:", -- Charged Scale of Onyxia
	[17969]=":4773:15:2:1:::1:0:", -- Red Sack of Gems
	[17982]=":23961:4:3:1:::1:0:", -- Ragnaros Core
	[18022]=":10709:4:3:1:::1:0:", -- Royal Seal of Alexis
	[18042]="4000:10:6:2:200:::1:0:17078", -- Thorium Headed Arrow
	[18043]=":15495:4:3:1:::1:0:", -- Coal Miner Boots
	[18044]=":41478:2:3:1:::1:0:", -- Hurley\'s Tankard
	[18045]=":300:0:1:20:::1:0:", -- Tender Wolf Steak
	[18046]="12000:3000:9:1:1:::1:0:8125,7733,4782", -- Recipe: Tender Wolf Steak
	[18047]=":22776:4:3:1:::1:0:", -- Flame Walkers
	[18048]=":49204:2:3:1:::1:0:", -- Mastersmith\'s Hammer
	[18082]=":28161:2:3:1:::1:0:", -- Zum\'rah\'s Vexing Cane
	[18083]=":4522:4:3:1:::1:0:", -- Jumanza Grips
	[18102]=":15444:4:3:1:::1:0:", -- Dragonrider Boots
	[18103]=":15252:4:3:1:::1:0:", -- Band of Rumination
	[18104]=":15557:4:3:1:::1:0:", -- Feralsurge Girdle
	[18142]="::12:1:100:::1:0:", -- Severed Night Elf Head
	[18143]="::12:1:100:::1:0:", -- Tuft of Gnome Hair
	[18144]="::12:1:100:::1:0:", -- Human Bone Chip
	[18145]="::12:1:100:::1:0:", -- Tauren Hoof
	[18146]="::12:1:100:::1:0:", -- Darkspear Troll Mojo
	[18147]="::12:1:100:::1:0:", -- Forsaken Heart
	[18148]="::12:1:1:::1:0:", -- Skull of Korrak
	[18149]="::12:2:1:::1:0:", -- Rune of Recall
	[18150]="::12:2:1:::1:0:", -- Rune of Recall
	[18151]="::12:1:1:::1:0:", -- Filled Amethyst Phial
	[18152]="::12:1:1:::1:0:", -- Amethyst Phial
	[18160]="200:50:9:2:1:::1:0:6779", -- Recipe: Thistle Tea
	[18168]=":47292:4:4:1:::1:0:", -- Force Reactive Disk
	[18169]="100000:25000:0:2:1:::1:0:11536,10856,10857", -- Flame Mantle of the Dawn
	[18170]="100000:25000:0:2:1:::1:0:11536,10856,10857", -- Frost Mantle of the Dawn
	[18171]="100000:25000:0:2:1:::1:0:11536,10856,10857", -- Arcane Mantle of the Dawn
	[18172]="100000:25000:0:2:1:::1:0:11536,10856,10857", -- Nature Mantle of the Dawn
	[18173]="100000:25000:0:2:1:::1:0:11536,10856,10857", -- Shadow Mantle of the Dawn
	[18182]="400000:100000:0:2:1:::1:0:11536,10856,10857", -- Chromatic Mantle of the Dawn
	[18202]=":73256:2:4:1:::1:0:", -- Eskhandar\'s Left Claw
	[18203]=":73522:2:4:1:::1:0:", -- Eskhandar\'s Right Claw
	[18204]=":22136:4:4:1:::1:0:", -- Eskhandar\'s Pelt
	[18205]=":33287:4:4:1:::1:0:", -- Eskhandar\'s Collar
	[18206]="::12:1:100:::1:0:", -- Dwarf Spine
	[18207]="::12:1:100:::1:0:", -- Orc Tooth
	[18208]=":22741:4:4:1:::1:0:", -- Drape of Benediction
	[18222]=":3070:15:0:20:::1:0:", -- Thorny Vine
	[18223]=":6142:15:0:20:::1:0:", -- Serrated Petal
	[18224]=":1728:15:0:40:::1:0:", -- Lasher Root
	[18225]=":140:15:0:5:::1:0:", -- Worn Running Shoes
	[18226]=":408:15:0:5:::1:0:", -- A Sealed Pact
	[18227]=":248:15:0:5:::1:0:", -- Nubless Pacifier
	[18228]=":2500:15:0:1:::1:0:", -- Autographed Picture of Foror & Tigule
	[18229]=":790:15:0:1:::1:0:", -- Nat Pagle\'s Guide to Extreme Anglin\'
	[18230]=":509:15:0:5:::1:0:", -- Broken I.W.I.N. Button
	[18231]=":361:4:0:1:::1:0:", -- Sleeveless T-Shirt
	[18232]=":10000:15:1:5:::1:0:", -- Field Repair Bot 74A
	[18233]=":130:15:0:5:::1:0:", -- Tear Stained Handkerchief
	[18234]=":225:15:0:5:::1:0:", -- Document from Boomstick Imports
	[18236]=":2716:15:0:20:::1:0:", -- Gordok Chew Toy
	[18237]=":1622:15:0:20:::1:0:", -- Mastiff Jawbone
	[18238]=":3321:4:3:1:::1:0:", -- Shadowskin Gloves
	[18239]="3500:875:9:1:1:::1:0:2699", -- Pattern: Shadowskin Gloves
	[18240]="::7:2:20::165,197:1:0:", -- Ogre Tannin
	[18241]="::15:4:1:::1:0:", -- Black War Steed Bridle
	[18242]="::15:4:1:::1:0:", -- Reins of the Black War Tiger
	[18243]="::15:4:1:::1:0:", -- Black Battlestrider
	[18244]="::15:4:1:::1:0:", -- Black War Ram
	[18245]="::15:4:1:::1:0:", -- Horn of the Black War Wolf
	[18246]="::15:4:1:::1:0:", -- Whistle of the Black War Raptor
	[18247]="::15:4:1:::1:0:", -- Black War Kodo
	[18248]="::15:4:1:::1:0:", -- Red Skeletal Warhorse
	[18249]="::13:1:1:::1:0:", -- Crescent Key
	[18250]="::13:2:1:::1:0:", -- Gordok Shackle Key
	[18251]=":5000:0:3:10:::1:0:", -- Core Armor Kit
	[18252]=":50000:9:3:1:::1:0:", -- Pattern: Core Armor Kit
	[18253]=":15:0:1:5:::1:0:", -- Major Rejuvenation Potion
	[18254]=":18:0:1:20:::1:0:", -- Runn Tum Tuber Surprise
	[18255]=":15:0:1:20::185:1:0:", -- Runn Tum Tuber
	[18256]="20000:1000:7:1:20::171,333:5:0:16768,6301,19197,24975,1453,7947,19372,12028,2480,25034,19533,4775,5163,8363,4899,16588,2848,16612,983,8178,18009,11188,5178,20891,16705,3955,2225,4561,3014,8158,25633,18005,3010,2812,8934,17486,4897,11189,20092,18907,3954,989,2821,20250,22271,3779,3348,20194,19015,5594,16641,12941,12022,16829,12957,19497,4610,3548,16602,958,19450,20081,16826,19017,2810,15179,844,19345,5135,12245,21083,8157,12958,16613,4229,1257,1313,19562,19194,19042,18015,2481,18960,19074,19837,8177,1286,19573,4226,14847,3956,1148,8145,8305,19244,16706,18802,2380,20989,3367,21113,5817,22099", -- Imbued Vial
	[18257]=":50000:9:3:1:::1:0:", -- Recipe: Major Rejuvenation Potion
	[18258]="::12:2:1:::1:0:", -- Gordok Ogre Suit
	[18259]=":7500:9:3:1:::1:0:", -- Formula: Enchant Weapon - Spell Power
	[18260]=":7500:9:3:1:::1:0:", -- Formula: Enchant Weapon - Healing Power
	[18261]="::12:1:1:::1:0:", -- Book of Incantations
	[18262]=":1250:0:2:20:::1:0:", -- Elemental Sharpening Stone
	[18263]=":14690:4:4:1:::1:0:", -- Flarecore Wraps
	[18264]=":25000:9:3:1:::1:0:", -- Plans: Elemental Sharpening Stone
	[18265]=":30000:9:3:1:::1:0:", -- Pattern: Flarecore Wraps
	[18266]="::13:1:1:::1:0:", -- Gordok Courtyard Key
	[18267]=":5000:9:2:1:::1:0:", -- Recipe: Runn Tum Tuber Surprise
	[18268]="::13:1:1:::1:0:", -- Gordok Inner Door Key
	[18269]="1500:375:0:2:10:::1:0:14322", -- Gordok Green Grog
	[18282]=":55617:2:4:1:::1:0:", -- Core Marksman Rifle
	[18283]=":25000:0:3:5:::1:0:", -- Biznicks 247x128 Accurascope
	[18284]="1500:375:0:2:10:::1:0:14322", -- Kreeg\'s Stout Beatdown
	[18285]=":4558:15:0:20:::1:0:", -- Crystallized Mana Shard
	[18286]=":2953:15:0:20:::1:0:", -- Condensed Mana Fragment
	[18287]="200:50:0:1:20:::1:0:14322", -- Evermurky
	[18288]="1000:250:0:1:20:::1:0:14322", -- Molasses Firewater
	[18289]=":9701:4:3:1:::1:0:", -- Barbed Thorn Necklace
	[18290]=":30000:9:3:1:::1:0:", -- Schematic: Biznicks 247x128 Accurascope
	[18291]=":30000:9:3:1:::1:0:", -- Schematic: Force Reactive Disk
	[18292]=":30000:9:3:1:::1:0:", -- Schematic: Core Marksman Rifle
	[18294]=":250:0:1:20:::1:0:", -- Elixir of Greater Water Breathing
	[18295]=":11582:4:3:1:::1:0:", -- Phasing Boots
	[18296]=":12322:4:3:1:::1:0:", -- Marksman Bands
	[18297]="::15:1:5:::1:0:", -- Thornling Seed
	[18298]=":20685:4:3:1:::1:0:", -- Unbridled Leggings
	[18299]="::12:1:1:::1:0:", -- Hydrospawn Essence
	[18300]=":200:0:1:20:::1:0:", -- Hyjal Nectar
	[18301]=":29363:2:2:1:::1:0:", -- Lethtendris\'s Wand
	[18302]=":7530:4:2:1:::1:0:", -- Band of Vigor
	[18305]=":25157:4:2:1:::1:0:", -- Breakwater Legguards
	[18306]=":7215:4:2:1:::1:0:", -- Gloves of Shadowy Mist
	[18307]=":11163:4:2:1:::1:0:", -- Riptide Shoes
	[18308]=":14006:4:2:1:::1:0:", -- Clever Hat
	[18309]=":11808:4:3:1:::1:0:", -- Gloves of Restoration
	[18310]=":47406:2:3:1:::1:0:", -- Fiendish Machete
	[18311]=":56644:2:3:1:::1:0:", -- Quel\'dorai Channeling Rod
	[18312]=":33429:4:3:1:::1:0:", -- Energized Chestplate
	[18313]=":23920:4:3:1:::1:0:", -- Helm of Awareness
	[18314]=":12100:4:3:1:::1:0:", -- Ring of Demonic Guile
	[18315]=":12100:4:3:1:::1:0:", -- Ring of Demonic Potency
	[18317]=":12503:4:3:1:::1:0:", -- Tempest Talisman
	[18318]=":22057:4:3:1:::1:0:", -- Merciful Greaves
	[18319]=":20989:4:3:1:::1:0:", -- Fervent Helm
	[18321]=":49320:2:3:1:::1:0:", -- Energetic Rod
	[18322]=":17677:4:3:1:::1:0:", -- Waterspout Boots
	[18323]=":32988:2:3:1:::1:0:", -- Satyr\'s Bow
	[18324]=":55189:2:3:1:::1:0:", -- Waveslicer
	[18325]=":16617:4:3:1:::1:0:", -- Felhide Cap
	[18326]=":16440:4:3:1:::1:0:", -- Razor Gauntlets
	[18327]=":9376:4:3:1:::1:0:", -- Whipvine Cord
	[18328]=":14116:4:3:1:::1:0:", -- Shadewood Cloak
	[18329]="::0:2:1:::1:0:", -- Arcanum of Rapidity
	[18330]="::0:2:1:::1:0:", -- Arcanum of Focus
	[18331]="::0:2:1:::1:0:", -- Arcanum of Protection
	[18332]="::9:2:1:::1:0:", -- Libram of Rapidity
	[18333]="::9:2:1:::1:0:", -- Libram of Focus
	[18334]="::9:2:1:::1:0:", -- Libram of Protection
	[18335]="::12:3:20::755:1:0:", -- Pristine Black Diamond
	[18336]="::12:1:1:::1:0:", -- Gauntlet of Gordok Might
	[18337]=":8103:4:2:1:::1:0:", -- Orphic Bracers
	[18338]=":36595:2:3:1:::1:0:", -- Wand of Arcane Potency
	[18339]=":11370:4:2:1:::1:0:", -- Eidolon Cloak
	[18340]=":28853:4:3:1:::1:0:", -- Eidolon Talisman
	[18343]=":14615:4:2:1:::1:0:", -- Petrified Band
	[18344]=":11587:4:3:1:::1:0:", -- Stonebark Gauntlets
	[18345]=":14727:4:2:1:::1:0:", -- Murmuring Ring
	[18346]=":16345:4:2:1:::1:0:", -- Threadbare Trousers
	[18347]=":41589:2:2:1:::1:0:", -- Well Balanced Axe
	[18348]=":75990:2:4:1:::1:0:", -- Quel\'Serrar
	[18349]=":12568:4:2:1:::1:0:", -- Gauntlets of Accuracy
	[18350]=":12615:4:2:1:::1:0:", -- Amplifying Cloak
	[18351]=":14855:4:2:1:::1:0:", -- Magically Sealed Bracers
	[18352]=":27109:4:2:1:::1:0:", -- Petrified Bark Shield
	[18353]=":53142:2:2:1:::1:0:", -- Stoneflower Staff
	[18354]=":17466:4:3:1:::1:0:", -- Pimgib\'s Collar
	[18356]="::12:3:1:::1:0:", -- Garona: A Study on Stealth and Treachery
	[18357]="::12:3:1:::1:0:", -- Codex of Defense
	[18358]="::12:3:1:::1:0:", -- The Arcanist\'s Cookbook
	[18359]="::12:3:1:::1:0:", -- The Light and How to Swing It
	[18360]="::12:3:1:::1:0:", -- Harnessing Shadows
	[18361]="::12:3:1:::1:0:", -- The Greatest Race of Hunters
	[18362]="::12:3:1:::1:0:", -- Holy Bologna: What the Light Won\'t Tell You
	[18363]="::12:3:1:::1:0:", -- Frost Shock and You
	[18364]="::12:3:1:::1:0:", -- The Emerald Dream
	[18365]="::15:0:1:::1:0:", -- A Thoroughly Read Copy of \"Nat Pagle\'s Extreme\' Anglin.\"
	[18366]=":17257:4:3:1:::1:0:", -- Gordok\'s Handguards
	[18367]=":14762:4:3:1:::1:0:", -- Gordok\'s Gauntlets
	[18368]=":12348:4:3:1:::1:0:", -- Gordok\'s Gloves
	[18369]=":9915:4:3:1:::1:0:", -- Gordok\'s Handwraps
	[18370]=":21612:4:3:1:::1:0:", -- Vigilance Charm
	[18371]=":20737:4:3:1:::1:0:", -- Mindtap Talisman
	[18372]=":52881:2:3:1:::1:0:", -- Blade of the New Moon
	[18373]=":26535:4:3:1:::1:0:", -- Chestplate of Tranquility
	[18374]=":19970:4:3:1:::1:0:", -- Flamescarred Shoulders
	[18375]=":13360:4:3:1:::1:0:", -- Bracers of the Eclipse
	[18376]=":53632:2:3:1:::1:0:", -- Timeworn Mace
	[18377]=":12175:4:3:1:::1:0:", -- Quickdraw Gloves
	[18378]=":29332:4:3:1:::1:0:", -- Silvermoon Leggings
	[18379]=":22182:4:3:1:::1:0:", -- Odious Greaves
	[18380]=":34486:4:3:1:::1:0:", -- Eldritch Reinforced Legplates
	[18381]=":21635:4:3:1:::1:0:", -- Evil Eye Pendant
	[18382]=":14891:4:3:1:::1:0:", -- Fluctuating Cloak
	[18383]=":17301:4:3:1:::1:0:", -- Force Imbued Gauntlets
	[18384]=":26209:4:3:1:::1:0:", -- Bile-etched Spaulders
	[18385]=":20080:4:3:1:::1:0:", -- Robe of Everlasting Night
	[18386]=":19882:4:3:1:::1:0:", -- Padre\'s Trousers
	[18387]=":9840:4:3:1:::1:0:", -- Brightspark Gloves
	[18388]=":39093:2:3:1:::1:0:", -- Stoneshatter
	[18389]=":15692:4:3:1:::1:0:", -- Cloak of the Cosmos
	[18390]=":25891:4:3:1:::1:0:", -- Tanglemoss Leggings
	[18391]=":13171:4:3:1:::1:0:", -- Eyestalk Cord
	[18392]=":52875:2:3:1:::1:0:", -- Distracting Dagger
	[18393]=":15701:4:3:1:::1:0:", -- Warpwood Binding
	[18394]=":15974:4:3:1:::1:0:", -- Demon Howl Wristguards
	[18395]=":36645:4:3:1:::1:0:", -- Emerald Flame Ring
	[18396]=":53627:2:3:1:::1:0:", -- Mind Carver
	[18397]=":22464:4:3:1:::1:0:", -- Elder Magus Pendant
	[18398]=":27103:4:3:1:::1:0:", -- Tidal Loop
	[18399]=":27103:4:3:1:::1:0:", -- Ocean\'s Breeze
	[18400]=":14853:4:2:1:::1:0:", -- Ring of Living Stone
	[18401]="::12:4:1:::1:0:", -- Foror\'s Compendium of Dragon Slaying
	[18402]=":18662:4:2:1:::1:0:", -- Glowing Crystal Ring
	[18403]=":49060:4:4:1:::1:0:", -- Dragonslayer\'s Signet
	[18404]=":6714:4:4:1:::1:0:", -- Onyxia Tooth Pendant
	[18405]=":13747:4:4:1:::1:0:", -- Belt of the Archmage
	[18406]=":46030:4:4:1:::1:0:", -- Onyxia Blood Talisman
	[18407]=":10386:4:3:1:::1:0:", -- Felcloth Gloves
	[18408]=":10422:4:3:1:::1:0:", -- Inferno Gloves
	[18409]=":10460:4:3:1:::1:0:", -- Mooncloth Gloves
	[18410]=":45516:2:2:1:::1:0:", -- Sprinter\'s Sword
	[18411]=":13704:4:2:1:::1:0:", -- Spry Boots
	[18412]="::12:1:1:::1:0:", -- Core Fragment
	[18413]=":15916:4:3:1:::1:0:", -- Cloak of Warding
	[18414]=":30000:9:4:1:::1:0:", -- Pattern: Belt of the Archmage
	[18415]=":10000:9:3:1:::1:0:", -- Pattern: Felcloth Gloves
	[18416]=":10000:9:3:1:::1:0:", -- Pattern: Inferno Gloves
	[18417]=":10000:9:3:1:::1:0:", -- Pattern: Mooncloth Gloves
	[18418]=":10000:9:3:1:::1:0:", -- Pattern: Cloak of Warding
	[18420]=":64117:2:3:1:::1:0:", -- Bonecrusher
	[18421]=":23168:4:3:1:::1:0:", -- Backwood Helm
	[18422]="::12:4:1:::1:0:", -- Head of Onyxia
	[18423]="::12:4:1:::1:0:", -- Head of Onyxia
	[18424]=":19520:4:3:1:::1:0:", -- Sedge Boots
	[18425]=":5537:4:2:1:::1:0:", -- Kreeg\'s Mug
	[18426]="::12:1:1:::1:0:", -- Lethtendris\'s Web
	[18427]="::4:3:1:::1:0:12799,12793", -- Sergeant\'s Cloak
	[18428]="::4:3:1:::1:0:12799,12793", -- Senior Sergeant\'s Insignia
	[18429]="::4:3:1:::1:0:12799,12793", -- First Sergeant\'s Plate Bracers
	[18430]="::4:3:1:::1:0:12799,12793", -- First Sergeant\'s Plate Bracers
	[18432]="::4:3:1:::1:0:12799,12793", -- First Sergeant\'s Mail Wristguards
	[18434]="::4:3:1:::1:0:12799,12793", -- First Sergeant\'s Dragonhide Armguards
	[18435]="::4:3:1:::1:0:12799,12793", -- First Sergeant\'s Leather Armguards
	[18436]="::4:3:1:::1:0:12799,12793", -- First Sergeant\'s Dragonhide Armguards
	[18437]="::4:3:1:::1:0:12799,12793", -- First Sergeant\'s Silk Cuffs
	[18440]="::4:3:1:::1:0:12805,12781", -- Sergeant\'s Cape
	[18441]="::4:3:1:::1:0:12805,12781", -- Sergeant\'s Cape
	[18442]="::4:3:1:::1:0:12805,12781", -- Master Sergeant\'s Insignia
	[18443]="::4:3:1:::1:0:12805,12781", -- Master Sergeant\'s Insignia
	[18444]="::4:3:1:::1:0:12805,12781", -- Master Sergeant\'s Insignia
	[18445]="::4:3:1:::1:0:12805,12781", -- Sergeant Major\'s Plate Wristguards
	[18447]="::4:3:1:::1:0:12805,12781", -- Sergeant Major\'s Plate Wristguards
	[18448]="::4:3:1:::1:0:12805,12781", -- Sergeant Major\'s Chain Armguards
	[18449]="::4:3:1:::1:0:12805,12781", -- Sergeant Major\'s Chain Armguards
	[18450]=":17016:4:2:1:::1:0:", -- Robe of Combustion
	[18451]=":10673:4:2:1:::1:0:", -- Hyena Hide Belt
	[18452]="::4:3:1:::1:0:12805,12781", -- Sergeant Major\'s Leather Armsplints
	[18453]="::4:3:1:::1:0:12805,12781", -- Sergeant Major\'s Leather Armsplints
	[18454]="::4:3:1:::1:0:12805,12781", -- Sergeant Major\'s Dragonhide Armsplints
	[18455]="::4:3:1:::1:0:12805,12781", -- Sergeant Major\'s Dragonhide Armsplints
	[18456]="::4:3:1:::1:0:12805,12781", -- Sergeant Major\'s Silk Cuffs
	[18457]="::4:3:1:::1:0:12805,12781", -- Sergeant Major\'s Silk Cuffs
	[18458]=":12212:4:2:1:::1:0:", -- Modest Armguards
	[18459]=":14383:4:2:1:::1:0:", -- Gallant\'s Wristguards
	[18460]=":30762:2:2:1:::1:0:", -- Unsophisticated Hand Cannon
	[18461]="::4:3:1:::1:0:12799,12793", -- Sergeant\'s Cloak
	[18462]=":41319:2:2:1:::1:0:", -- Jagged Bone Fist
	[18463]=":41472:2:2:1:::1:0:", -- Ogre Pocket Knife
	[18464]=":29135:4:2:1:::1:0:", -- Gordok Nose Ring
	[18465]="::4:3:1:::1:0:", -- Royal Seal of Eldre\'Thalas
	[18466]="::4:3:1:::1:0:", -- Royal Seal of Eldre\'Thalas
	[18467]="::4:3:1:::1:0:", -- Royal Seal of Eldre\'Thalas
	[18468]="::4:3:1:::1:0:", -- Royal Seal of Eldre\'Thalas
	[18469]="::4:3:1:::1:0:", -- Royal Seal of Eldre\'Thalas
	[18470]="::4:3:1:::1:0:", -- Royal Seal of Eldre\'Thalas
	[18471]="::4:3:1:::1:0:", -- Royal Seal of Eldre\'Thalas
	[18472]="::4:3:1:::1:0:", -- Royal Seal of Eldre\'Thalas
	[18473]="::4:3:1:::1:0:", -- Royal Seal of Eldre\'Thalas
	[18475]=":804:4:2:1:::1:0:", -- Oddly Magical Belt
	[18476]=":1514:4:2:1:::1:0:", -- Mud Stained Boots
	[18477]=":2027:4:2:1:::1:0:", -- Shaggy Leggings
	[18478]=":2035:4:2:1:::1:0:", -- Hyena Hide Jerkin
	[18479]=":1838:4:2:1:::1:0:", -- Carrion Scorpid Helm
	[18480]=":2148:4:2:1:::1:0:", -- Scarab Plate Helm
	[18481]=":5145:2:2:1:::1:0:", -- Skullcracking Mace
	[18482]=":3098:2:2:1:::1:0:", -- Ogre Toothpick Shooter
	[18483]=":37839:2:3:1:::1:0:", -- Mana Channeling Wand
	[18484]=":51975:2:3:1:::1:0:", -- Cho\'Rush\'s Blade
	[18485]=":33383:4:3:1:::1:0:", -- Observer\'s Shield
	[18486]=":20939:4:3:1:::1:0:", -- Mooncloth Robe
	[18487]="40000:10000:9:1:1:::1:0:14371", -- Pattern: Mooncloth Robe
	[18488]="::12:1:1:::1:0:", -- Heated Ancient Blade
	[18489]="::12:4:1:::1:0:", -- Unfired Ancient Blade
	[18490]=":18015:4:3:1:::1:0:", -- Insightful Hood
	[18491]=":40695:2:3:1:::1:0:", -- Lorespinner
	[18492]="::12:1:1:::1:0:", -- Treated Ancient Blade
	[18493]=":25113:4:3:1:::1:0:", -- Bulky Iron Spaulders
	[18494]=":21743:4:3:1:::1:0:", -- Denwatcher\'s Shoulders
	[18495]=":1509:4:3:1:::1:0:", -- Redoubt Cloak
	[18496]=":14542:4:3:1:::1:0:", -- Heliotrope Cloak
	[18497]=":9731:4:3:1:::1:0:", -- Sublime Wristguards
	[18498]=":48836:2:3:1:::1:0:", -- Hedgecutter
	[18499]=":3225:4:3:1:::1:0:", -- Barrier Shield
	[18500]=":3134:4:3:1:::1:0:", -- Tarnished Elven Ring
	[18501]="::12:1:1:::1:0:", -- Felvine Shard
	[18502]=":65385:2:3:1:::1:0:", -- Monstrous Glaive
	[18503]=":36748:4:3:1:::1:0:", -- Kromcrush\'s Chestplate
	[18504]=":13171:4:3:1:::1:0:", -- Girdle of Insight
	[18505]=":13218:4:3:1:::1:0:", -- Mugger\'s Belt
	[18506]=":19897:4:3:1:::1:0:", -- Mongoose Boots
	[18507]=":15974:4:3:1:::1:0:", -- Boots of the Full Moon
	[18508]=":16031:4:3:1:::1:0:", -- Swift Flight Bracers
	[18509]=":21451:4:4:1:::1:0:", -- Chromatic Cloak
	[18510]=":19477:4:4:1:::1:0:", -- Hide of the Wild
	[18511]=":19553:4:4:1:::1:0:", -- Shifting Cloak
	[18512]=":4000:7:1:5::165:1:0:", -- Larval Acid
	[18513]="::12:4:1:::1:0:", -- A Dull and Flat Elven Blade
	[18514]=":15000:9:3:1:::1:0:", -- Pattern: Girdle of Insight
	[18515]=":15000:9:3:1:::1:0:", -- Pattern: Mongoose Boots
	[18516]=":15000:9:3:1:::1:0:", -- Pattern: Swift Flight Bracers
	[18517]=":40000:9:4:1:::1:0:", -- Pattern: Chromatic Cloak
	[18518]=":40000:9:4:1:::1:0:", -- Pattern: Hide of the Wild
	[18519]=":40000:9:4:1:::1:0:", -- Pattern: Shifting Cloak
	[18520]=":6579:2:3:1:::1:0:", -- Barbarous Blade
	[18521]=":2767:4:3:1:::1:0:", -- Grimy Metal Boots
	[18522]=":3625:4:3:1:::1:0:", -- Band of the Ogre King
	[18523]=":3481:4:3:1:::1:0:", -- Brightly Glowing Stone
	[18524]=":3203:4:3:1:::1:0:", -- Leggings of Destruction
	[18525]=":1339:4:3:1:::1:0:", -- Bracers of Prosperity
	[18526]=":1613:4:3:1:::1:0:", -- Crown of the Ogre King
	[18527]=":1619:4:3:1:::1:0:", -- Harmonious Gauntlets
	[18528]=":1976:4:3:1:::1:0:", -- Cyclone Spaulders
	[18529]=":1861:4:3:1:::1:0:", -- Elemental Plate Girdle
	[18530]=":2921:4:3:1:::1:0:", -- Ogre Forged Hauberk
	[18531]=":6109:2:3:1:::1:0:", -- Unyielding Maul
	[18532]=":2016:4:3:1:::1:0:", -- Mindsurge Robe
	[18533]=":1805:4:3:1:::1:0:", -- Gordok Bracers of Power
	[18534]=":6435:2:3:1:::1:0:", -- Rod of the Ogre Magi
	[18535]=":30231:4:3:1:::1:0:", -- Milli\'s Shield
	[18536]=":38664:4:3:1:::1:0:", -- Milli\'s Lexicon
	[18537]=":6613:4:3:1:::1:0:", -- Counterattack Lodestone
	[18538]=":8707:2:4:1:::1:0:", -- Treant\'s Bane
	[18539]="::12:1:1:::1:0:", -- Reliquary of Purity
	[18540]="::12:1:1:::1:0:", -- Sealed Reliquary of Purity
	[18541]=":23110:4:4:1:::1:0:", -- Puissant Cape
	[18542]=":94273:2:4:1:::1:0:", -- Typhoon
	[18543]=":63728:4:4:1:::1:0:", -- Ring of Entropy
	[18544]=":19705:4:4:1:::1:0:", -- Doomhide Gauntlets
	[18545]=":30875:4:4:1:::1:0:", -- Leggings of Arcane Supremacy
	[18546]=":34859:4:4:1:::1:0:", -- Infernal Headcage
	[18547]=":28041:4:4:1:::1:0:", -- Unmelting Ice Girdle
	[18562]=":100000:7:4:20::186:1:0:", -- Elementium Ore
	[18563]="::15:5:1:::1:0:", -- Bindings of the Windseeker
	[18564]="::15:5:1:::1:0:", -- Bindings of the Windseeker
	[18567]="150000:37500:7:1:10::186:1:0:2847,21209,8161,5512,2999,8176,19012,19530,19662,25634,16823,1690,4257,19342,19011,22476,19520,19056,19879,22264,23144,2844,3343,4597,15176,28344,9179,6300,4259,20463,16583,14624,3356,14737,5411,20082,17655,17245,790,15400,3477,23724,16376,16670,16713", -- Elemental Flux
	[18585]=":14853:4:3:1:::1:0:", -- Band of Allegiance
	[18586]=":14853:4:3:1:::1:0:", -- Lonetree\'s Circle
	[18587]=":2000:7:1:1:::1:0:", -- Goblin Jumper Cables XL
	[18588]=":200:7:1:20:::1:0:", -- Ez-Thro Dynamite II
	[18590]="::12:1:30:::1:0:", -- Raging Beast\'s Blood
	[18591]="::12:1:1:::1:0:", -- Case of Blood
	[18592]=":20000:9:4:1:::1:0:", -- Plans: Sulfuron Hammer
	[18594]=":3000:7:1:10:::1:0:", -- Powerful Seaforium Charge
	[18597]="::15:1:1:::1:0:", -- Orcish Orphan Whistle
	[18598]="::15:1:1:::1:0:", -- Human Orphan Whistle
	[18600]=":12000:9:3:1:::1:0:", -- Tome of Arcane Brilliance
	[18601]="::12:1:1:::1:0:", -- Glowing Crystal Prison
	[18602]=":25000:4:3:1:::1:0:", -- Tome of Sacrifice
	[18603]="::12:1:15:::1:0:", -- Satyr Blood
	[18604]="::12:1:5:::1:0:", -- Tears of the Hederine
	[18605]="::12:1:1:::1:0:", -- Imprisoned Doomguard
	[18606]="::0:1:1:::1:0:12805,12781", -- Alliance Battle Standard
	[18607]="::0:1:1:::1:0:12799,12793", -- Horde Battle Standard
	[18608]="::2:4:1:::1:0:", -- Benediction
	[18609]="::2:4:1:::1:0:", -- Anathema
	[18610]=":37:2:1:1:::1:0:", -- Keen Machete
	[18611]=":27:4:1:1:::1:0:", -- Gnarlpine Leggings
	[18612]=":35:4:1:1:::1:0:", -- Bloody Chain Boots
	[18622]="::12:1:1:::1:0:", -- Flawless Fel Essence (Jaedenar)
	[18623]="::12:1:1:::1:0:", -- Flawless Fel Essence (Dark Portal)
	[18624]="::12:1:1:::1:0:", -- Flawless Fel Essence (Azshara)
	[18625]="::12:1:1:::1:0:", -- Kroshius\' Infernal Core
	[18626]="::12:1:1:::1:0:", -- Fel Fire
	[18628]="::12:4:1:::1:0:", -- Thorium Brotherhood Contract
	[18629]="500000::12:1:1:::1:0:14437", -- Black Lodestone
	[18631]=":3000:7:1:10::202:1:0:", -- Truesilver Transformer
	[18632]="1000:50:0:1:20:::5:0:14480,15353,15354,14481", -- Moonbrook Riot Taffy
	[18633]="125:6:0:1:20:::5:0:14480,15353,15354,14481", -- Styleen\'s Sour Suckerpop
	[18634]=":12500:4:3:1:::1:0:", -- Gyrofreeze Ice Reflector
	[18635]="2000:100:0:1:20:::5:0:14480,15353,15354,14481", -- Bellara\'s Nutterbar
	[18636]=":100:7:1:1:::1:0:", -- Ruined Jumper Cables XL
	[18637]=":600:4:2:1:::1:0:", -- Major Recombobulator
	[18638]=":12500:4:3:1:::1:0:", -- Hyper-Radiant Flame Reflector
	[18639]=":12500:4:3:1:::1:0:", -- Ultra-Flash Shadow Reflector
	[18640]="::0:1:4:::1:0:", -- Happy Fun Rock
	[18641]=":500:7:1:20:::1:0:", -- Dense Dynamite
	[18642]="::12:1:1:::1:0:", -- Jaina\'s Autograph
	[18643]="::12:1:1:::1:0:", -- Cairne\'s Hoofprint
	[18645]=":1500:7:1:1:::1:0:", -- Gnomish Alarm-O-Bot
	[18646]="::4:4:1:::1:0:", -- The Eye of Divinity
	[18647]="1800:450:9:1:1:::1:0:3413", -- Schematic: Red Firework
	[18648]="1800:450:9:1:1:::1:0:3495,2838", -- Schematic: Green Firework
	[18649]="1800:450:9:1:1:::1:0:1304,5175", -- Schematic: Blue Firework
	[18650]="5000:1250:9:1:1:::1:0:8131", -- Schematic: EZ-Thro Dynamite II
	[18651]=":3000:9:1:1:::1:0:", -- Schematic: Truesilver Transformer
	[18652]="12000:3000:9:1:1:::1:0:11185", -- Schematic: Gyrofreeze Ice Reflector
	[18653]=":4000:9:2:1:::1:0:", -- Schematic: Goblin Jumper Cables XL
	[18654]=":4000:9:2:1:::1:0:", -- Schematic: Gnomish Alarm-O-Bot
	[18655]=":4000:9:2:1:::1:0:", -- Schematic: Major Recombobulator
	[18656]="16000:4000:9:1:1:::1:0:11185", -- Schematic: Powerful Seaforium Charge
	[18657]=":5000:9:2:1:::1:0:", -- Schematic: Hyper-Radiant Flame Reflector
	[18658]=":6000:9:2:1:::1:0:", -- Schematic: Ultra-Flash Shadow Reflector
	[18659]="::12:4:1:::1:0:", -- Splinter of Nordrassil
	[18660]=":7500:7:2:1:::1:0:", -- World Enlarger
	[18661]=":3000:9:2:1:::1:0:", -- Schematic: World Enlarger
	[18662]="20:5:0:1:5:::1:0:14860", -- Heavy Leather Ball
	[18663]="1500000::12:1:1:::1:0:14437", -- J\'eevee\'s Jar
	[18664]=":25:15:1:1:::1:0:", -- A Treatise on Military Ranks
	[18665]="::4:4:1:::1:0:", -- The Eye of Shadow
	[18670]="500000::12:1:1:::1:0:14437", -- Xorothian Glyphs
	[18671]=":47747:2:3:1:::1:0:", -- Baron Charr\'s Sceptre
	[18672]=":17855:4:2:1:::1:0:", -- Elemental Ember
	[18673]=":30782:4:3:1:::1:0:", -- Avalanchion\'s Stony Hide
	[18674]=":22003:4:2:1:::1:0:", -- Hardened Stone Band
	[18675]=":25:15:1:1:::1:0:", -- Military Ranks of the Horde & Alliance
	[18676]=":15529:4:3:1:::1:0:", -- Sash of the Windreaver
	[18677]=":12059:4:2:1:::1:0:", -- Zephyr Cloak
	[18678]=":26635:4:3:1:::1:0:", -- Tempestria\'s Frozen Necklace
	[18679]=":25136:4:2:1:::1:0:", -- Frigid Ring
	[18680]=":36594:2:3:1:::1:0:", -- Ancient Bone Bow
	[18681]=":14693:4:3:1:::1:0:", -- Burial Shawl
	[18682]=":24583:4:3:1:::1:0:", -- Ghoul Skin Leggings
	[18683]=":49347:2:3:1:::1:0:", -- Hammer of the Vesper
	[18684]=":36141:4:3:1:::1:0:", -- Dimly Opalescent Ring
	[18686]=":22869:4:3:1:::1:0:", -- Bone Golem Shoulders
	[18687]="1500000::12:1:1:::1:0:14522", -- Xorothian Stardust
	[18688]="::12:1:1:::1:0:", -- Imp in a Jar
	[18689]=":15347:4:3:1:::1:0:", -- Phantasmal Cloak
	[18690]=":35939:4:3:1:::1:0:", -- Wraithplate Leggings
	[18691]=":31400:4:3:1:::1:0:", -- Dark Advisor\'s Pendant
	[18692]=":25109:4:3:1:::1:0:", -- Death Knight Sabatons
	[18693]=":10652:4:3:1:::1:0:", -- Shivery Handwraps
	[18694]=":24158:4:3:1:::1:0:", -- Shadowy Mail Greaves
	[18695]=":34450:4:3:1:::1:0:", -- Spellbound Tome
	[18696]=":31173:4:3:1:::1:0:", -- Intricately Runed Shield
	[18697]=":10867:4:3:1:::1:0:", -- Coldstone Slippers
	[18698]=":14454:4:3:1:::1:0:", -- Tattered Leather Hood
	[18699]=":15380:4:3:1:::1:0:", -- Icy Tomb Spaulders
	[18700]=":10910:4:3:1:::1:0:", -- Malefic Bracers
	[18701]=":36410:4:3:1:::1:0:", -- Innervating Band
	[18702]=":17064:4:3:1:::1:0:", -- Belt of the Ordained
	[18703]="::12:4:1:::1:0:", -- Ancient Petrified Leaf
	[18704]="::12:4:1:::1:0:", -- Mature Blue Dragon Sinew
	[18705]="::12:4:1:::1:0:", -- Mature Black Dragon Sinew
	[18706]=":10031:4:2:1:::1:0:", -- Arena Master
	[18707]="::12:4:1:::1:0:", -- Ancient Rune Etched Stave
	[18708]="::12:1:1:::1:0:", -- Petrified Bark
	[18709]=":5758:4:3:1:::1:0:", -- Arena Wristguards
	[18710]=":7224:4:3:1:::1:0:", -- Arena Bracers
	[18711]=":8700:4:3:1:::1:0:", -- Arena Bands
	[18712]=":10245:4:3:1:::1:0:", -- Arena Vambraces
	[18713]="::2:4:1:::1:0:", -- Rhok\'delar, Longbow of the Ancient Keepers
	[18714]="::11:4:1:::1:0:", -- Ancient Sinew Wrapped Lamina
	[18715]="::2:4:1:::1:0:", -- Lok\'delar, Stave of the Ancient Keepers
	[18716]=":18015:4:3:1:::1:0:", -- Ash Covered Boots
	[18717]=":61940:2:3:1:::1:0:", -- Hammer of the Grand Crusader
	[18718]=":26065:4:3:1:::1:0:", -- Grand Crusader\'s Helm
	[18719]="::12:1:1:::1:0:", -- The Traitor\'s Heart
	[18720]=":15036:4:3:1:::1:0:", -- Shroud of the Nathrezim
	[18721]=":14689:4:3:1:::1:0:", -- Barrage Girdle
	[18722]=":17539:4:3:1:::1:0:", -- Death Grips
	[18723]=":41953:4:3:1:::1:0:", -- Animated Chain Necklace
	[18724]="::12:4:1:::1:0:", -- Enchanted Black Dragon Sinew
	[18725]=":59927:2:3:1:::1:0:", -- Peacemaker
	[18726]=":12029:4:3:1:::1:0:", -- Magistrate\'s Cuffs
	[18727]=":14487:4:3:1:::1:0:", -- Crimson Felt Hat
	[18728]=":32466:4:3:1:::1:0:", -- Anastari Heirloom
	[18729]=":38302:2:3:1:::1:0:", -- Screeching Bow
	[18730]=":10250:4:3:1:::1:0:", -- Shadowy Laced Handwraps
	[18731]="2000:500:9:1:1:::1:0:5128,3366", -- Pattern: Heavy Leather Ball
	[18734]=":16031:4:3:1:::1:0:", -- Pale Moon Cloak
	[18735]=":16086:4:3:1:::1:0:", -- Maleki\'s Footwraps
	[18736]=":24346:4:3:1:::1:0:", -- Plaguehound Leggings
	[18737]=":48882:2:3:1:::1:0:", -- Bone Slicing Hatchet
	[18738]=":36303:2:3:1:::1:0:", -- Carapace Spine Crossbow
	[18739]=":34010:4:3:1:::1:0:", -- Chitinous Plate Legguards
	[18740]=":9754:4:3:1:::1:0:", -- Thuzadin Sash
	[18741]=":17704:4:3:1:::1:0:", -- Morlune\'s Bracer
	[18742]=":22503:4:3:1:::1:0:", -- Stratholme Militia Shoulderguard
	[18743]=":14275:4:3:1:::1:0:", -- Gracious Cape
	[18744]=":11371:4:3:1:::1:0:", -- Plaguebat Fur Gloves
	[18745]=":17228:4:3:1:::1:0:", -- Sacred Cloth Leggings
	[18746]="::12:1:1:::1:0:", -- Divination Scryer
	[18749]="::12:1:1:::1:0:", -- Charger\'s Lost Soul
	[18752]="::12:1:1:::1:0:", -- Exorcism Censer
	[18753]="::12:1:1:::1:0:", -- Arcanite Barding
	[18754]=":18806:4:3:1:::1:0:", -- Fel Hardened Bracers
	[18755]=":40213:2:3:1:::1:0:", -- Xorothian Firestick
	[18756]=":31160:4:3:1:::1:0:", -- Dreadguard\'s Protector
	[18757]=":15069:4:3:1:::1:0:", -- Diabolic Mantle
	[18758]=":50416:2:3:1:::1:0:", -- Specter\'s Blade
	[18759]=":63257:2:3:1:::1:0:", -- Malicious Axe
	[18760]=":30866:4:3:1:::1:0:", -- Necromantic Band
	[18761]=":38238:2:3:1:::1:0:", -- Oblivion\'s Touch
	[18762]=":27631:4:3:1:::1:0:", -- Shard of the Green Flame
	[18766]="1000000::15:4:1:::1:0:4730", -- Reins of the Swift Frostsaber
	[18767]="1000000::15:4:1:::1:0:4730", -- Reins of the Swift Mistsaber
	[18769]="::12:3:1:::1:0:", -- Enchanted Thorium Platemail
	[18770]="::12:3:1:::1:0:", -- Enchanted Thorium Platemail
	[18771]="::12:3:1:::1:0:", -- Enchanted Thorium Platemail
	[18772]="1000000::15:4:1:::1:0:7955", -- Swift Green Mechanostrider
	[18773]="1000000::15:4:1:::1:0:7955", -- Swift White Mechanostrider
	[18774]="1000000::15:4:1:::1:0:7955", -- Swift Yellow Mechanostrider
	[18775]="::12:1:1:::1:0:", -- Manna-Enriched Horse Feed
	[18776]="1000000::15:4:1:::1:0:384,2357,4885", -- Swift Palomino
	[18777]="1000000::15:4:1:::1:0:384,2357,4885", -- Swift Brown Steed
	[18778]="1000000::15:4:1:::1:0:384,2357,4885", -- Swift White Steed
	[18779]="::12:3:1:::1:0:", -- Bottom Half of Advanced Armorsmithing: Volume I
	[18780]="::12:3:1:::1:0:", -- Top Half of Advanced Armorsmithing: Volume I
	[18781]="::12:3:1:::1:0:", -- Bottom Half of Advanced Armorsmithing: Volume II
	[18782]="::12:3:1:::1:0:", -- Top Half of Advanced Armorsmithing: Volume II
	[18783]="::12:3:1:::1:0:", -- Bottom Half of Advanced Armorsmithing: Volume III
	[18784]="::12:3:1:::1:0:", -- Top Half of Advanced Armorsmithing: Volume III
	[18785]="1000000::15:4:1:::1:0:1261", -- Swift White Ram
	[18786]="1000000::15:4:1:::1:0:1261", -- Swift Brown Ram
	[18787]="1000000::15:4:1:::1:0:1261", -- Swift Gray Ram
	[18788]="1000000::15:4:1:::1:0:7952", -- Swift Blue Raptor
	[18789]="1000000::15:4:1:::1:0:7952", -- Swift Olive Raptor
	[18790]="1000000::15:4:1:::1:0:7952", -- Swift Orange Raptor
	[18791]="1000000::15:4:1:::1:0:4731", -- Purple Skeletal Warhorse
	[18792]="::12:1:1:::1:0:", -- Blessed Arcanite Barding
	[18793]="1000000::15:4:1:::1:0:3685", -- Great White Kodo
	[18794]="1000000::15:4:1:::1:0:3685", -- Great Brown Kodo
	[18795]="1000000::15:4:1:::1:0:3685", -- Great Gray Kodo
	[18796]="1000000::15:4:1:::1:0:3362", -- Horn of the Swift Brown Wolf
	[18797]="1000000::15:4:1:::1:0:3362", -- Horn of the Swift Timber Wolf
	[18798]="1000000::15:4:1:::1:0:3362", -- Horn of the Swift Gray Wolf
	[18799]="::12:1:1:::1:0:", -- Charger\'s Redeemed Soul
	[18802]="60000:5000:12:1:5:::3:0:14437", -- Shadowy Potion
	[18803]=":94876:2:4:1:::1:0:", -- Finkle\'s Lava Dredger
	[18804]="::12:1:1:::1:0:", -- Lord Grayson\'s Satchel
	[18805]=":76460:2:4:1:::1:0:", -- Core Hound Tooth
	[18806]=":41261:4:4:1:::1:0:", -- Core Forged Greaves
	[18807]=":25796:4:3:1:::1:0:", -- Helm of Latent Power
	[18808]=":15859:4:4:1:::1:0:", -- Gloves of the Hypnotic Flame
	[18809]=":14578:4:4:1:::1:0:", -- Sash of Whispered Secrets
	[18810]=":27440:4:4:1:::1:0:", -- Wild Growth Spaulders
	[18811]=":22035:4:4:1:::1:0:", -- Fireproof Cloak
	[18812]=":22119:4:4:1:::1:0:", -- Wristguards of True Flight
	[18813]=":89103:4:4:1:::1:0:", -- Ring of Binding
	[18814]=":89135:4:4:1:::1:0:", -- Choker of the Fire Lord
	[18815]=":64095:4:4:1:::1:0:", -- Essence of the Pure Flame
	[18816]=":80298:2:4:1:::1:0:", -- Perdition\'s Blade
	[18817]=":35861:4:4:1:::1:0:", -- Crown of Destruction
	[18818]="::12:1:1:::1:0:", -- Mor\'zul\'s Instructions
	[18819]="::12:1:1:::1:0:", -- Rohan\'s Exorcism Censer
	[18820]=":66290:4:4:1:::1:0:", -- Talisman of Ephemeral Power
	[18821]=":64030:4:4:1:::1:0:", -- Quick Strike Ring
	[18822]=":94642:2:4:1:::1:0:", -- Obsidian Edged Blade
	[18823]=":19235:4:4:1:::1:0:", -- Aged Core Leather Gloves
	[18824]=":40964:4:4:1:::1:0:", -- Magma Tempered Boots
	[18825]="::4:4:1:::1:0:12784", -- Grand Marshal\'s Aegis
	[18826]="::4:4:1:::1:0:12794", -- High Warlord\'s Shield Wall
	[18827]="::2:4:1:::1:0:12784", -- Grand Marshal\'s Handaxe
	[18828]="::2:4:1:::1:0:12794", -- High Warlord\'s Cleaver
	[18829]=":32943:4:4:1:::1:0:", -- Deep Earth Spaulders
	[18830]="::2:4:1:::1:0:12784", -- Grand Marshal\'s Sunderer
	[18831]="::2:4:1:::1:0:12794", -- High Warlord\'s Battle Axe
	[18832]=":72832:2:4:1:::1:0:", -- Brutality Blade
	[18833]="::2:4:1:::1:0:12784", -- Grand Marshal\'s Bullseye
	[18834]="::4:3:1:::1:0:12799,12793", -- Insignia of the Horde
	[18835]="::2:4:1:::1:0:12794", -- High Warlord\'s Recurve
	[18836]="::2:4:1:::1:0:12784", -- Grand Marshal\'s Repeater
	[18837]="::2:4:1:::1:0:12794", -- High Warlord\'s Crossbow
	[18838]="::2:4:1:::1:0:12784", -- Grand Marshal\'s Dirk
	[18839]="1000:250:0:1:10:::1:0:12793,12781", -- Combat Healing Potion
	[18840]="::2:4:1:::1:0:12794", -- High Warlord\'s Razor
	[18841]="1000:250:0:1:10:::1:0:12793,12781", -- Combat Mana Potion
	[18842]=":97012:2:4:1:::1:0:", -- Staff of Dominance
	[18843]="::2:4:1:::1:0:12784", -- Grand Marshal\'s Right Hand Blade
	[18844]="::2:4:1:::1:0:12794", -- High Warlord\'s Right Claw
	[18845]="::4:3:1:::1:0:12799,12793", -- Insignia of the Horde
	[18846]="::4:3:1:::1:0:12799,12793", -- Insignia of the Horde
	[18847]="::2:4:1:::1:0:12784", -- Grand Marshal\'s Left Hand Blade
	[18848]="::2:4:1:::1:0:12794", -- High Warlord\'s Left Claw
	[18849]="::4:3:1:::1:0:12799,12793", -- Insignia of the Horde
	[18850]="::4:3:1:::1:0:12799,12793", -- Insignia of the Horde
	[18851]="::4:3:1:::1:0:12799,12793", -- Insignia of the Horde
	[18852]="::4:3:1:::1:0:12799,12793", -- Insignia of the Horde
	[18853]="::4:3:1:::1:0:12799,12793", -- Insignia of the Horde
	[18854]="::4:3:1:::1:0:12805,12781", -- Insignia of the Alliance
	[18855]="::2:4:1:::1:0:12784", -- Grand Marshal\'s Hand Cannon
	[18856]="::4:3:1:::1:0:12805,12781", -- Insignia of the Alliance
	[18857]="::4:3:1:::1:0:12805,12781", -- Insignia of the Alliance
	[18858]="::4:3:1:::1:0:12805,12781", -- Insignia of the Alliance
	[18859]="::4:3:1:::1:0:12805,12781", -- Insignia of the Alliance
	[18860]="::2:4:1:::1:0:12794", -- High Warlord\'s Street Sweeper
	[18861]=":48152:4:4:1:::1:0:", -- Flamewaker Legplates
	[18862]="::4:3:1:::1:0:12805,12781", -- Insignia of the Alliance
	[18863]="::4:3:1:::1:0:12805,12781", -- Insignia of the Alliance
	[18864]="::4:3:1:::1:0:12805,12781", -- Insignia of the Alliance
	[18865]="::2:4:1:::1:0:12784", -- Grand Marshal\'s Punisher
	[18866]="::2:4:1:::1:0:12794", -- High Warlord\'s Bludgeon
	[18867]="::2:4:1:::1:0:12784", -- Grand Marshal\'s Battle Hammer
	[18868]="::2:4:1:::1:0:12794", -- High Warlord\'s Pulverizer
	[18869]="::2:4:1:::1:0:12784", -- Grand Marshal\'s Glaive
	[18870]=":30139:4:4:1:::1:0:", -- Helm of the Lifegiver
	[18871]="::2:4:1:::1:0:12794", -- High Warlord\'s Pig Sticker
	[18872]=":27356:4:4:1:::1:0:", -- Manastorm Leggings
	[18873]="::2:4:1:::1:0:12784", -- Grand Marshal\'s Stave
	[18874]="::2:4:1:::1:0:12794", -- High Warlord\'s War Staff
	[18875]=":35039:4:4:1:::1:0:", -- Salamander Scale Pants
	[18876]="::2:4:1:::1:0:12784", -- Grand Marshal\'s Claymore
	[18877]="::2:4:1:::1:0:12794", -- High Warlord\'s Greatsword
	[18878]=":71794:2:4:1:::1:0:", -- Sorcerous Dagger
	[18879]=":53364:4:4:1:::1:0:", -- Heavy Dark Iron Ring
	[18880]="::12:1:1:::1:0:", -- Darkreaver\'s Head
	[18902]="1000000::15:4:1:::1:0:4730", -- Reins of the Swift Stormsaber
	[18904]="::12:1:1:::1:0:", -- Zorbin\'s Ultra-Shrinker
	[18922]="::12:1:1:::1:0:", -- Secret Plans: Fiery Flux
	[18944]=":123:12:1:100:::1:0:", -- Incendosaur Scale
	[18945]=":100:12:1:100:::1:0:", -- Dark Iron Residue
	[18946]="::12:1:1:::1:0:", -- Head of Overseer Maltorius
	[18947]="::12:1:20:::1:0:", -- Rage Scar Yeti Hide
	[18948]=":1589:4:3:1:::1:0:", -- Barbaric Bracers
	[18949]="2000:500:9:1:1:::1:0:4589,4225", -- Pattern: Barbaric Bracers
	[18952]="::12:1:1:::1:0:", -- Simone\'s Head
	[18953]="::12:1:1:::1:0:", -- Klinfran\'s Head
	[18954]="::12:1:1:::1:0:", -- Solenor\'s Head
	[18955]="::12:1:1:::1:0:", -- Artorius\'s Head
	[18956]="::12:1:20:::1:0:", -- Miniaturization Residue
	[18957]=":250:2:2:1:::1:0:", -- Brushwood Blade
	[18958]="::12:1:20:::1:0:", -- Water Elemental Core
	[18959]="::12:1:1:::1:0:", -- Smithing Tuyere
	[18960]="::12:1:1:::1:0:", -- Lookout\'s Spyglass
	[18961]="::12:1:20:::1:0:", -- Zukk\'ash Carapace
	[18962]="::12:1:1:::1:0:", -- Stinglasher\'s Glands
	[18969]="::12:1:1:::1:0:", -- Pristine Yeti Hide
	[18972]="::12:1:1:::1:0:", -- Perfect Yeti Hide
	[18984]=":5000:4:2:1:::1:0:", -- Dimensional Ripper - Everlook
	[18986]=":5000:4:2:1:::1:0:", -- Ultrasafe Transporter: Gadgetzan
	[18987]="::12:1:1:::1:0:", -- Blackhand\'s Command
	[19002]="::12:4:1:::1:0:", -- Head of Nefarian
	[19003]="::12:4:1:::1:0:", -- Head of Nefarian
	[19004]="::0:1:1:::1:0:", -- Minor Healthstone
	[19005]="::0:1:1:::1:0:", -- Minor Healthstone
	[19006]="::0:1:1:::1:0:", -- Lesser Healthstone
	[19007]="::0:1:1:::1:0:", -- Lesser Healthstone
	[19008]="::0:1:1:::1:0:", -- Healthstone
	[19009]="::0:1:1:::1:0:", -- Healthstone
	[19010]="::0:1:1:::1:0:", -- Greater Healthstone
	[19011]="::0:1:1:::1:0:", -- Greater Healthstone
	[19012]="::0:1:1:::1:0:", -- Major Healthstone
	[19013]="::0:1:1:::1:0:", -- Major Healthstone
	[19016]="::12:5:1:::1:0:", -- Vessel of Rebirth
	[19017]="::12:1:1:::1:0:", -- Essence of the Firelord
	[19019]=":123140:2:5:1:::1:0:", -- Thunderfury, Blessed Blade of the Windseeker
	[19020]="::12:1:1:::1:0:", -- Camp Mojache Zukk\'ash Report
	[19022]=":28580:2:2:1:::1:0:", -- Nat Pagle\'s Extreme Angler FC-5000
	[19023]="::12:1:1:::1:0:", -- Katoom\'s Best Lure
	[19024]=":10031:4:3:1:::1:0:", -- Arena Grand Master
	[19025]="::12:1:1:::1:0:", -- Skylord Plume
	[19026]=":250:0:1:10:::1:0:", -- Snake Burst Firework
	[19027]="5000:1250:9:1:1:::1:0:14637", -- Schematic: Snake Burst Firework
	[19028]=":1078:4:1:1:::1:0:", -- Elegant Dress
	[19029]="::15:4:1:::1:0:13218,13219", -- Horn of the Frostwolf Howler
	[19030]="::15:4:1:::1:0:13217,13216", -- Stormpike Battle Charger
	[19031]="::4:1:1:::1:0:13218,13219", -- Frostwolf Battle Tabard
	[19032]="::4:1:1:::1:0:13217,13216", -- Stormpike Battle Tabard
	[19033]="::12:1:1:::1:0:", -- Slagtree\'s Lost Tools
	[19034]="::12:1:1:::1:0:", -- Lard\'s Lunch
	[19035]=":250:15:2:1:::1:0:", -- Lard\'s Special Picnic Basket
	[19036]="::12:1:1:::1:0:", -- Final Message to the Wildhammer
	[19037]=":10266:4:2:1:::1:0:", -- Emerald Peak Spaulders
	[19038]=":11145:4:2:1:::1:0:", -- Ring of Subtlety
	[19039]=":7403:4:2:1:::1:0:", -- Zorbin\'s Water Resistant Hat
	[19040]=":19817:2:2:1:::1:0:", -- Zorbin\'s Mega-Slicer
	[19041]=":9946:4:2:1:::1:0:", -- Pratt\'s Handcrafted Tunic
	[19042]=":9984:4:2:1:::1:0:", -- Jangdor\'s Handcrafted Tunic
	[19043]=":13291:4:3:1:::1:0:", -- Heavy Timbermaw Belt
	[19044]=":11116:4:3:1:::1:0:", -- Might of the Timbermaw
	[19045]="::0:3:1:::1:0:13217,13216", -- Stormpike Battle Standard
	[19046]="::0:3:1:::1:0:13218,13219", -- Frostwolf Battle Standard
	[19047]=":9232:4:3:1:::1:0:", -- Wisdom of the Timbermaw
	[19048]=":24376:4:3:1:::1:0:", -- Heavy Timbermaw Boots
	[19049]=":13531:4:3:1:::1:0:", -- Timbermaw Brawlers
	[19050]=":16295:4:3:1:::1:0:", -- Mantle of the Timbermaw
	[19051]=":16483:4:3:1:::1:0:", -- Girdle of the Dawn
	[19052]=":17621:4:3:1:::1:0:", -- Dawn Treaders
	[19056]=":12941:4:3:1:::1:0:", -- Argent Boots
	[19057]=":17744:4:3:1:::1:0:", -- Gloves of the Dawn
	[19058]=":18977:4:3:1:::1:0:", -- Golden Mantle of the Dawn
	[19059]=":15238:4:3:1:::1:0:", -- Argent Shoulders
	[19060]="2000:100:0:1:20:::5:0:14753,14754", -- Warsong Gulch Enriched Ration
	[19061]="1500:75:0:1:20:::5:0:14753,14754", -- Warsong Gulch Iron Ration
	[19062]="1000:50:0:1:20:::5:0:14753,14754", -- Warsong Gulch Field Ration
	[19064]="::13:1:1:::1:0:", -- Shackle Key
	[19066]="2000:100:0:1:20:::5:0:14753,14754", -- Warsong Gulch Runecloth Bandage
	[19067]="1500:75:0:1:20:::5:0:14753,14754", -- Warsong Gulch Mageweave Bandage
	[19068]="1000:50:0:1:20:::5:0:14753,14754", -- Warsong Gulch Silk Bandage
	[19069]="::12:1:1:::1:0:", -- Huntsman Malkhor\'s Skull
	[19070]="::12:1:1:::1:0:", -- Huntsman Malkhor\'s Bones
	[19071]="::12:1:10:::1:0:", -- Vessel of Tainted Blood
	[19083]="::4:3:1:::1:0:13218,13219", -- Frostwolf Legionnaire\'s Cloak
	[19084]="::4:3:1:::1:0:13217,13216", -- Stormpike Soldier\'s Cloak
	[19085]="::4:3:1:::1:0:13218,13219", -- Frostwolf Advisor\'s Cloak
	[19086]="::4:3:1:::1:0:13217,13216", -- Stormpike Sage\'s Cloak
	[19087]="::4:3:1:::1:0:13218,13219", -- Frostwolf Plate Belt
	[19088]="::4:3:1:::1:0:13218,13219", -- Frostwolf Mail Belt
	[19089]="::4:3:1:::1:0:13218,13219", -- Frostwolf Leather Belt
	[19090]="::4:3:1:::1:0:13218,13219", -- Frostwolf Cloth Belt
	[19091]="::4:3:1:::1:0:13217,13216", -- Stormpike Plate Girdle
	[19092]="::4:3:1:::1:0:13217,13216", -- Stormpike Mail Girdle
	[19093]="::4:3:1:::1:0:13217,13216", -- Stormpike Leather Girdle
	[19094]="::4:3:1:::1:0:13217,13216", -- Stormpike Cloth Girdle
	[19095]="::4:3:1:::1:0:13218,13219", -- Frostwolf Legionnaire\'s Pendant
	[19096]="::4:3:1:::1:0:13218,13219", -- Frostwolf Advisor\'s Pendant
	[19097]="::4:3:1:::1:0:13217,13216", -- Stormpike Soldier\'s Pendant
	[19098]="::4:3:1:::1:0:13217,13216", -- Stormpike Sage\'s Pendant
	[19099]="::2:3:1:::1:0:13218,13219", -- Glacial Blade
	[19100]="::2:3:1:::1:0:13217,13216", -- Electrified Dagger
	[19101]="::2:3:1:::1:0:13218,13219", -- Whiteout Staff
	[19102]="::2:3:1:::1:0:13217,13216", -- Crackling Staff
	[19103]="::2:3:1:::1:0:13218,13219", -- Frostbite
	[19104]="::2:3:1:::1:0:13217,13216", -- Stormstrike Hammer
	[19105]="::4:3:1:::1:0:", -- Frost Runed Headdress
	[19106]=":66021:2:3:1:::1:0:", -- Ice Barbed Spear
	[19107]=":39756:2:3:1:::1:0:", -- Bloodseeker
	[19108]=":39896:2:3:1:::1:0:", -- Wand of Biting Cold
	[19109]=":33920:4:3:1:::1:0:", -- Deep Rooted Ring
	[19110]="::2:3:1:::1:0:", -- Cold Forged Blade
	[19111]=":22580:4:3:1:::1:0:", -- Winteraxe Epaulets
	[19112]=":17650:4:3:1:::1:0:", -- Frozen Steel Vambraces
	[19113]=":12583:4:3:1:::1:0:", -- Yeti Hide Bracers
	[19114]=":18282:2:2:1:::1:0:", -- Highland Bow
	[19115]=":11003:4:2:1:::1:0:", -- Flask of Forest Mojo
	[19116]=":4590:4:2:1:::1:0:", -- Greenleaf Handwraps
	[19117]=":16127:4:2:1:::1:0:", -- Laquered Wooden Plate Legplates
	[19118]=":17344:2:2:1:::1:0:", -- Nature\'s Breath
	[19119]=":5803:4:2:1:::1:0:", -- Owlbeast Hide Gloves
	[19120]=":16283:4:2:1:::1:0:", -- Rune of the Guard Captain
	[19121]=":9007:4:3:1:::1:0:", -- Deep Woodlands Cloak
	[19123]=":4114:4:2:1:::1:0:", -- Everwarm Handwraps
	[19124]=":14453:4:2:1:::1:0:", -- Slagplate Leggings
	[19125]=":6652:4:2:1:::1:0:", -- Seared Mail Girdle
	[19126]=":7833:4:2:1:::1:0:", -- Slagplate Gauntlets
	[19127]=":12258:4:2:1:::1:0:", -- Charred Leather Tunic
	[19128]=":13358:4:2:1:::1:0:", -- Seared Mail Vest
	[19130]=":54431:2:4:1:::1:0:", -- Cold Snap
	[19131]=":21586:4:4:1:::1:0:", -- Snowblind Shoes
	[19132]=":21400:4:4:1:::1:0:", -- Crystal Adorned Crown
	[19133]=":29722:4:4:1:::1:0:", -- Fel Infused Leggings
	[19134]=":17969:4:4:1:::1:0:", -- Flayed Doomguard Belt
	[19135]=":14066:4:4:1:::1:0:", -- Blacklight Bracer
	[19136]=":15029:4:4:1:::1:0:", -- Mana Igniting Cord
	[19137]=":28803:4:4:1:::1:0:", -- Onslaught Girdle
	[19138]=":79853:4:4:1:::1:0:", -- Band of Sulfuras
	[19139]=":28496:4:4:1:::1:0:", -- Fireguard Shoulders
	[19140]=":60256:4:4:1:::1:0:", -- Cauterizing Band
	[19141]=":16612:4:2:1:::1:0:", -- Luffa
	[19142]=":18903:4:4:1:::1:0:", -- Fire Runed Grimoire
	[19143]=":27183:4:4:1:::1:0:", -- Flameguard Gauntlets
	[19144]=":34596:4:4:1:::1:0:", -- Sabatons of the Flamewalker
	[19145]=":29952:4:4:1:::1:0:", -- Robe of Volatile Power
	[19146]=":18542:4:4:1:::1:0:", -- Wristguards of Stability
	[19147]=":91453:4:4:1:::1:0:", -- Ring of Spell Power
	[19148]=":35881:4:4:1:::1:0:", -- Dark Iron Helm
	[19149]=":17185:4:4:1:::1:0:", -- Lava Belt
	[19150]="::15:1:1:::1:0:", -- Sentinel Basic Care Package
	[19151]="::15:1:1:::1:0:", -- Sentinel Standard Care Package
	[19152]="::15:1:1:::1:0:", -- Sentinel Advanced Care Package
	[19153]="::15:1:1:::1:0:", -- Outrider Advanced Care Package
	[19154]="::15:1:1:::1:0:", -- Outrider Basic Care Package
	[19155]="::15:1:1:::1:0:", -- Outrider Standard Care Package
	[19156]=":28236:4:4:1:::1:0:", -- Flarecore Robe
	[19157]=":22350:4:4:1:::1:0:", -- Chromatic Gauntlets
	[19159]=":21141:4:3:1:::1:0:", -- Woven Ivy Necklace
	[19160]="::4:1:1:::1:0:", -- Contest Winner\'s Tabard
	[19162]=":19474:4:4:1:::1:0:", -- Corehound Belt
	[19163]=":19544:4:4:1:::1:0:", -- Molten Belt
	[19164]=":27616:4:4:1:::1:0:", -- Dark Iron Gauntlets
	[19165]=":31491:4:4:1:::1:0:", -- Flarecore Leggings
	[19166]=":75133:2:4:1:::1:0:", -- Black Amnesty
	[19167]=":94248:2:4:1:::1:0:", -- Blackfury
	[19168]=":71993:2:4:1:::1:0:", -- Blackguard
	[19169]=":90341:2:4:1:::1:0:", -- Nightfall
	[19170]=":72552:2:4:1:::1:0:", -- Ebon Hand
	[19182]=":25:15:1:200:::1:0:", -- Darkmoon Faire Prize Ticket
	[19183]="::0:1:200:::1:0:", -- Hourglass Sand
	[19202]="22000:5500:9:1:1:::1:0:11557", -- Plans: Heavy Timbermaw Belt
	[19203]="22000:5500:9:1:1:::1:0:11536,10856,10857", -- Plans: Girdle of the Dawn
	[19204]="40000:10000:9:1:1:::1:0:11557", -- Plans: Heavy Timbermaw Boots
	[19205]="40000:10000:9:1:1:::1:0:11536,10856,10857", -- Plans: Gloves of the Dawn
	[19206]="60000:15000:9:1:1:::1:0:12944", -- Plans: Dark Iron Helm
	[19207]="80000:20000:9:1:1:::1:0:12944", -- Plans: Dark Iron Gauntlets
	[19208]="70000:17500:9:1:1:::1:0:12944", -- Plans: Black Amnesty
	[19209]="70000:17500:9:1:1:::1:0:12944", -- Plans: Blackfury
	[19210]="120000:30000:9:1:1:::1:0:12944", -- Plans: Ebon Hand
	[19211]="120000:30000:9:1:1:::1:0:12944", -- Plans: Blackguard
	[19212]="120000:30000:9:1:1:::1:0:12944", -- Plans: Nightfall
	[19213]="::12:2:250:::1:0:", -- Silverwing Talisman of Merit
	[19215]="22000:5500:9:1:1:::1:0:11557", -- Pattern: Wisdom of the Timbermaw
	[19216]="22000:5500:9:1:1:::1:0:11536,10856,10857", -- Pattern: Argent Boots
	[19217]="40000:10000:9:1:1:::1:0:11536,10856,10857", -- Pattern: Argent Shoulders
	[19218]="40000:10000:9:1:1:::1:0:11557", -- Pattern: Mantle of the Timbermaw
	[19219]="60000:15000:9:1:1:::1:0:12944", -- Pattern: Flarecore Robe
	[19220]="90000:22500:9:1:1:::1:0:12944", -- Pattern: Flarecore Leggings
	[19221]="50:12:0:1:10:::1:0:14844", -- Darkmoon Special Reserve
	[19222]="10:2:0:1:10:::1:0:20377,14844", -- Cheap Beer
	[19223]="25:1:0:1:20:::5:0:14845", -- Darkmoon Dog
	[19224]="1000:50:0:1:20:::5:0:14845", -- Red Hot Wings
	[19225]="4000:200:0:1:20:::5:0:14845", -- Deep Fried Candybar
	[19227]=":12500:12:3:1:::1:0:", -- Ace of Beasts
	[19228]=":100000:12:4:1:::1:0:", -- Beasts Deck
	[19229]="::15:1:1:::1:0:", -- Sayge\'s Fortune #1
	[19230]=":12500:12:3:1:::1:0:", -- Two of Beasts
	[19231]=":12500:12:3:1:::1:0:", -- Three of Beasts
	[19232]=":12500:12:3:1:::1:0:", -- Four of Beasts
	[19233]=":12500:12:3:1:::1:0:", -- Five of Beasts
	[19234]=":12500:12:3:1:::1:0:", -- Six of Beasts
	[19235]=":12500:12:3:1:::1:0:", -- Seven of Beasts
	[19236]=":12500:12:3:1:::1:0:", -- Eight of Beasts
	[19237]="::15:1:1:::1:0:", -- Sayge\'s Fortune #19
	[19238]="::15:1:1:::1:0:", -- Sayge\'s Fortune #3
	[19239]="::15:1:1:::1:0:", -- Sayge\'s Fortune #4
	[19240]="::15:1:1:::1:0:", -- Sayge\'s Fortune #5
	[19241]="::15:1:1:::1:0:", -- Sayge\'s Fortune #6
	[19242]="::15:1:1:::1:0:", -- Sayge\'s Fortune #7
	[19243]="::15:1:1:::1:0:", -- Sayge\'s Fortune #8
	[19244]="::15:1:1:::1:0:", -- Sayge\'s Fortune #9
	[19245]="::15:1:1:::1:0:", -- Sayge\'s Fortune #10
	[19246]="::15:1:1:::1:0:", -- Sayge\'s Fortune #11
	[19247]="::15:1:1:::1:0:", -- Sayge\'s Fortune #12
	[19248]="::15:1:1:::1:0:", -- Sayge\'s Fortune #13
	[19249]="::15:1:1:::1:0:", -- Sayge\'s Fortune #14
	[19250]="::15:1:1:::1:0:", -- Sayge\'s Fortune #15
	[19251]="::15:1:1:::1:0:", -- Sayge\'s Fortune #16
	[19252]="::15:1:1:::1:0:", -- Sayge\'s Fortune #18
	[19253]="::15:1:1:::1:0:", -- Sayge\'s Fortune #17
	[19254]="::15:1:1:::1:0:", -- Sayge\'s Fortune #21
	[19255]="::15:1:1:::1:0:", -- Sayge\'s Fortune #22
	[19256]="::15:1:1:::1:0:", -- Sayge\'s Fortune #2
	[19257]=":100000:12:4:1:::1:0:", -- Warlords Deck
	[19258]=":12500:12:3:1:::1:0:", -- Ace of Warlords
	[19259]=":12500:12:3:1:::1:0:", -- Two of Warlords
	[19260]=":12500:12:3:1:::1:0:", -- Three of Warlords
	[19261]=":12500:12:3:1:::1:0:", -- Four of Warlords
	[19262]=":12500:12:3:1:::1:0:", -- Five of Warlords
	[19263]=":12500:12:3:1:::1:0:", -- Six of Warlords
	[19264]=":12500:12:3:1:::1:0:", -- Seven of Warlords
	[19265]=":12500:12:3:1:::1:0:", -- Eight of Warlords
	[19266]="::15:1:1:::1:0:", -- Sayge\'s Fortune #20
	[19267]=":100000:12:4:1:::1:0:", -- Elementals Deck
	[19268]=":12500:12:3:1:::1:0:", -- Ace of Elementals
	[19269]=":12500:12:3:1:::1:0:", -- Two of Elementals
	[19270]=":12500:12:3:1:::1:0:", -- Three of Elementals
	[19271]=":12500:12:3:1:::1:0:", -- Four of Elementals
	[19272]=":12500:12:3:1:::1:0:", -- Five of Elementals
	[19273]=":12500:12:3:1:::1:0:", -- Six of Elementals
	[19274]=":12500:12:3:1:::1:0:", -- Seven of Elementals
	[19275]=":12500:12:3:1:::1:0:", -- Eight of Elementals
	[19276]=":12500:12:3:1:::1:0:", -- Ace of Portals
	[19277]=":100000:12:4:1:::1:0:", -- Portals Deck
	[19278]=":12500:12:3:1:::1:0:", -- Two of Portals
	[19279]=":12500:12:3:1:::1:0:", -- Three of Portals
	[19280]=":12500:12:3:1:::1:0:", -- Four of Portals
	[19281]=":12500:12:3:1:::1:0:", -- Five of Portals
	[19282]=":12500:12:3:1:::1:0:", -- Six of Portals
	[19283]=":12500:12:3:1:::1:0:", -- Seven of Portals
	[19284]=":12500:12:3:1:::1:0:", -- Eight of Portals
	[19287]=":100000:4:4:1:::1:0:", -- Darkmoon Card: Heroism
	[19288]=":100000:4:4:1:::1:0:", -- Darkmoon Card: Blue Dragon
	[19289]=":100000:4:4:1:::1:0:", -- Darkmoon Card: Maelstrom
	[19290]=":100000:4:4:1:::1:0:", -- Darkmoon Card: Twisting Nether
	[19291]=":25000:1:1:1:::1:0:", -- Darkmoon Storage Box
	[19292]=":4022:2:1:1:::1:0:", -- Last Month\'s Mutton
	[19293]=":19376:2:1:1:::1:0:", -- Last Year\'s Mutton
	[19295]=":750:4:1:1:::1:0:", -- Darkmoon Flower
	[19296]=":250:15:2:1:::1:0:", -- Greater Darkmoon Prize
	[19297]=":110:15:2:1:::1:0:", -- Lesser Darkmoon Prize
	[19298]=":50:15:2:1:::1:0:", -- Minor Darkmoon Prize
	[19299]="500:25:0:1:20:::5:0:14844", -- Fizzy Faire Drink
	[19300]="2000:100:0:1:20:::5:0:14844", -- Bottled Winterspring Water
	[19301]="7000:350:0:1:20:::5:0:13218,13217,13219,13216", -- Alterac Manna Biscuit
	[19302]="50000:12500:4:3:1:::1:0:14846", -- Darkmoon Ring
	[19303]="50000:12500:4:3:1:::1:0:14846", -- Darkmoon Necklace
	[19304]="125:6:0:1:20:::5:0:14845", -- Spiced Beef Jerky
	[19305]="500:25:0:1:20:::5:0:14845", -- Pickled Kodo Foot
	[19306]="2000:100:0:1:20:::5:0:14845", -- Crunchy Frog
	[19307]="8000:100:0:1:100:::20:0:13218,13217,13219,13216", -- Alterac Heavy Runecloth Bandage
	[19308]="::4:4:1:::1:0:13218,13217,13219,13216", -- Tome of Arcane Domination
	[19309]="::4:4:1:::1:0:13218,13217,13219,13216", -- Tome of Shadow Force
	[19310]="::4:4:1:::1:0:13218,13217,13219,13216", -- Tome of the Ice Lord
	[19311]="::4:4:1:::1:0:13218,13217,13219,13216", -- Tome of Fiery Arcana
	[19312]="::4:4:1:::1:0:13218,13217,13219,13216", -- Lei of the Lifegiver
	[19315]="::4:4:1:::1:0:13218,13217,13219,13216", -- Therazane\'s Touch
	[19316]="6000:7:6:2:200:::200:0:13218,13217,13219,13216", -- Ice Threaded Arrow
	[19317]="6000:7:6:2:200:::200:0:13218,13217,13219,13216", -- Ice Threaded Bullet
	[19318]="5000:250:0:1:20:::5:0:13218,13217,13219,13216", -- Bottled Alterac Spring Water
	[19319]="::11:3:1:::1:0:13218,13217,13219,13216", -- Harpy Hide Quiver
	[19320]="::11:3:1:::1:0:13218,13217,13219,13216", -- Gnoll Skin Bandolier
	[19321]="::4:4:1:::1:0:13218,13217,13219,13216", -- The Immovable Object
	[19323]="::2:4:1:::1:0:13218,13217,13219,13216", -- The Unstoppable Force
	[19324]="::2:4:1:::1:0:13218,13217,13219,13216", -- The Lobotomizer
	[19325]="::4:4:1:::1:0:13218,13217,13219,13216", -- Don Julio\'s Band
	[19326]="22000:5500:9:1:1:::1:0:11557", -- Pattern: Might of the Timbermaw
	[19327]="40000:10000:9:1:1:::1:0:11557", -- Pattern: Timbermaw Brawlers
	[19328]="22000:5500:9:1:1:::1:0:11536,10856,10857", -- Pattern: Dawn Treaders
	[19329]="40000:10000:9:1:1:::1:0:11536,10856,10857", -- Pattern: Golden Mantle of the Dawn
	[19330]="60000:15000:9:1:1:::1:0:12944", -- Pattern: Lava Belt
	[19331]="90000:22500:9:1:1:::1:0:12944", -- Pattern: Chromatic Gauntlets
	[19332]="90000:22500:9:1:1:::1:0:12944", -- Pattern: Corehound Belt
	[19333]="90000:22500:9:1:1:::1:0:12944", -- Pattern: Molten Belt
	[19334]=":100551:2:4:1:::1:0:", -- The Untamed Blade
	[19335]=":80731:2:4:1:::1:0:", -- Spineshatter
	[19336]=":72039:4:4:1:::1:0:", -- Arcane Infused Gem
	[19337]=":72039:4:4:1:::1:0:", -- The Black Book
	[19338]="::12:1:1:::1:0:", -- Free Ticket Voucher
	[19339]=":72039:4:4:1:::1:0:", -- Mind Quickening Gem
	[19340]=":72039:4:4:1:::1:0:", -- Rune of Metamorphosis
	[19341]=":72039:4:4:1:::1:0:", -- Lifegiving Gem
	[19342]=":72039:4:4:1:::1:0:", -- Venomous Totem
	[19343]=":72039:4:4:1:::1:0:", -- Scrolls of Blinding Light
	[19344]=":72039:4:4:1:::1:0:", -- Natural Alignment Crystal
	[19345]=":72039:4:4:1:::1:0:", -- Aegis of Preservation
	[19346]=":79053:2:4:1:::1:0:", -- Dragonfang Blade
	[19347]=":82129:2:4:1:::1:0:", -- Claw of Chromaggus
	[19348]=":50969:4:4:1:::1:0:", -- Red Dragonscale Protector
	[19349]=":52946:4:4:1:::1:0:", -- Elementium Reinforced Bulwark
	[19350]=":60867:2:4:1:::1:0:", -- Heartstriker
	[19351]=":81453:2:4:1:::1:0:", -- Maladath, Runed Blade of the Black Flight
	[19352]=":85814:2:4:1:::1:0:", -- Chromatically Tempered Sword
	[19353]=":105206:2:4:1:::1:0:", -- Drake Talon Cleaver
	[19354]=":91123:2:4:1:::1:0:", -- Draconic Avenger
	[19355]=":95910:2:4:1:::1:0:", -- Shadow Wing Focus Staff
	[19356]=":102955:2:4:1:::1:0:", -- Staff of the Shadow Flame
	[19357]=":96642:2:4:1:::1:0:", -- Herald of Woe
	[19358]=":91409:2:4:1:::1:0:", -- Draconic Maul
	[19360]=":83625:2:4:1:::1:0:", -- Lok\'amir il Romathis
	[19361]=":60230:2:4:1:::1:0:", -- Ashjre\'thul, Crossbow of Smiting
	[19362]=":74238:2:4:1:::1:0:", -- Doom\'s Edge
	[19363]=":84569:2:4:1:::1:0:", -- Crul\'shorukh, Edge of Chaos
	[19364]=":106097:2:4:1:::1:0:", -- Ashkandi, Greatsword of the Brotherhood
	[19365]=":79672:2:4:1:::1:0:", -- Claw of the Black Drake
	[19366]=":203059:4:4:1:::1:0:", -- Master Dragonslayer\'s Orb
	[19367]=":60199:2:4:1:::1:0:", -- Dragon\'s Touch
	[19368]=":62010:2:4:1:::1:0:", -- Dragonbreath Hand Cannon
	[19369]=":16212:4:4:1:::1:0:", -- Gloves of Rapid Evolution
	[19370]=":24405:4:4:1:::1:0:", -- Mantle of the Blackwing Cabal
	[19371]=":88355:4:4:1:::1:0:", -- Pendant of the Fallen Dragon
	[19372]=":43435:4:4:1:::1:0:", -- Helm of Endless Rage
	[19373]=":38038:4:4:1:::1:0:", -- Black Brood Pauldrons
	[19374]=":15284:4:4:1:::1:0:", -- Bracers of Arcane Accuracy
	[19375]=":25143:4:4:1:::1:0:", -- Mish\'undare, Circlet of the Mind Flayer
	[19376]=":111528:4:4:1:::1:0:", -- Archimtiros\' Ring of Reckoning
	[19377]=":105328:4:4:1:::1:0:", -- Prestor\'s Talisman of Connivery
	[19378]=":25432:4:4:1:::1:0:", -- Cloak of the Brood Lord
	[19379]=":205863:4:4:1:::1:0:", -- Neltharion\'s Tear
	[19380]=":25624:4:4:1:::1:0:", -- Therazane\'s Link
	[19381]=":32152:4:4:1:::1:0:", -- Boots of the Shadow Flame
	[19382]=":128280:4:4:1:::1:0:", -- Pure Elementium Band
	[19383]=":128862:4:4:1:::1:0:", -- Master Dragonslayer\'s Medallion
	[19384]=":130616:4:4:1:::1:0:", -- Master Dragonslayer\'s Ring
	[19385]=":33472:4:4:1:::1:0:", -- Empowered Leggings
	[19386]=":25195:4:4:1:::1:0:", -- Elementium Threaded Cloak
	[19387]=":44162:4:4:1:::1:0:", -- Chromatic Boots
	[19388]=":16916:4:4:1:::1:0:", -- Angelista\'s Grasp
	[19389]=":31832:4:4:1:::1:0:", -- Taut Dragonhide Shoulderpads
	[19390]=":21297:4:4:1:::1:0:", -- Taut Dragonhide Gloves
	[19391]=":25645:4:4:1:::1:0:", -- Shimmering Geta
	[19392]=":30198:4:4:1:::1:0:", -- Girdle of the Fallen Crusader
	[19393]=":25828:4:4:1:::1:0:", -- Primalist\'s Linked Waistguard
	[19394]=":40037:4:4:1:::1:0:", -- Drake Talon Pauldrons
	[19395]=":103103:4:4:1:::1:0:", -- Rejuvenating Gem
	[19396]=":19250:4:4:1:::1:0:", -- Taut Dragonhide Belt
	[19397]=":107438:4:4:1:::1:0:", -- Ring of Blackrock
	[19398]=":23275:4:4:1:::1:0:", -- Cloak of Firemaw
	[19399]=":31153:4:4:1:::1:0:", -- Black Ash Robe
	[19400]=":16061:4:4:1:::1:0:", -- Firemaw\'s Clutch
	[19401]=":48361:4:4:1:::1:0:", -- Primalist\'s Linked Legguards
	[19402]=":56624:4:4:1:::1:0:", -- Legguards of the Fallen Crusader
	[19403]=":105328:4:4:1:::1:0:", -- Band of Forced Concentration
	[19405]=":40891:4:4:1:::1:0:", -- Malfurion\'s Blessed Bulwark
	[19406]=":91160:4:4:1:::1:0:", -- Drake Fang Talisman
	[19407]=":16473:4:4:1:::1:0:", -- Ebony Flame Gloves
	[19422]="::12:1:1:::1:0:", -- Darkmoon Faire Fortune
	[19423]="::15:1:1:::1:0:", -- Sayge\'s Fortune #23
	[19424]="::15:1:1:::1:0:", -- Sayge\'s Fortune #24
	[19425]="::15:2:1:::1:0:", -- Mysterious Lockbox
	[19426]=":25000:4:4:1:::1:0:", -- Orb of the Darkmoon
	[19430]=":24972:4:4:1:::1:0:", -- Shroud of Pure Thought
	[19431]=":103117:4:4:1:::1:0:", -- Styleen\'s Impeding Scarab
	[19432]=":147286:4:4:1:::1:0:", -- Circle of Applied Force
	[19433]=":46932:4:4:1:::1:0:", -- Emberweave Leggings
	[19434]=":80863:4:4:1:::1:0:", -- Band of Dark Dominion
	[19435]=":55695:2:4:1:::1:0:", -- Essence Gatherer
	[19436]=":22359:4:4:1:::1:0:", -- Cloak of Draconic Might
	[19437]=":22443:4:4:1:::1:0:", -- Boots of Pure Thought
	[19438]=":22804:4:4:1:::1:0:", -- Ringo\'s Blizzard Boots
	[19439]=":38148:4:4:1:::1:0:", -- Interlaced Shadow Jerkin
	[19440]=":500:0:1:10:::1:0:", -- Powerful Anti-Venom
	[19441]=":1500:7:1:5::129:1:0:", -- Huge Venom Sac
	[19442]="100000:25000:9:1:1:::1:0:11536,10856,10857", -- Formula: Powerful Anti-Venom
	[19443]="::15:1:1:::1:0:", -- Sayge\'s Fortune #25
	[19444]="30000:7500:9:1:1:::1:0:12944", -- Formula: Enchant Weapon - Strength
	[19445]="30000:7500:9:1:1:::1:0:11557", -- Formula: Enchant Weapon - Agility
	[19446]="30000:7500:9:1:1:::1:0:11536,10856,10857", -- Formula: Enchant Bracer - Mana Regeneration
	[19447]="60000:15000:9:1:1:::1:0:11536,10856,10857", -- Formula: Enchant Bracer - Healing
	[19448]="80000:20000:9:1:1:::1:0:12944", -- Formula: Enchant Weapon - Mighty Spirit
	[19449]="100000:25000:9:1:1:::1:0:12944", -- Formula: Enchant Weapon - Mighty Intellect
	[19450]="::15:1:1:::1:0:", -- A Jubling\'s Tiny Home
	[19451]="::15:1:1:::1:0:", -- Sayge\'s Fortune #26
	[19452]="::15:1:1:::1:0:", -- Sayge\'s Fortune #27
	[19453]="::15:1:1:::1:0:", -- Sayge\'s Fortune #28
	[19454]="::15:1:1:::1:0:", -- Sayge\'s Fortune #29
	[19462]="::15:1:1:::1:0:", -- Unhatched Jubling Egg
	[19483]="::15:1:1:::1:0:13218,13219", -- Peeling the Onion
	[19484]="::15:1:1:::1:0:13217,13216", -- The Frostwolf Artichoke
	[19491]=":25000:4:4:1:::1:0:", -- Amulet of the Darkmoon
	[19505]="::4:1:1:::1:0:14754", -- Warsong Battle Tabard
	[19506]="::4:1:1:::1:0:14753", -- Silverwing Battle Tabard
	[19507]=":1701:4:2:1:::1:0:", -- Inquisitor\'s Shawl
	[19508]=":1423:4:2:1:::1:0:", -- Branded Leather Bracers
	[19509]=":2583:4:2:1:::1:0:", -- Dusty Mail Boots
	[19510]="::4:3:1:::1:0:14754", -- Legionnaire\'s Band
	[19511]="::4:3:1:::1:0:14754", -- Legionnaire\'s Band
	[19512]="::4:3:1:::1:0:14754", -- Legionnaire\'s Band
	[19513]="::4:3:1:::1:0:14754", -- Legionnaire\'s Band
	[19514]="::4:3:1:::1:0:14753", -- Protector\'s Band
	[19515]="::4:3:1:::1:0:14753", -- Protector\'s Band
	[19516]="::4:3:1:::1:0:14753", -- Protector\'s Band
	[19517]="::4:3:1:::1:0:14753", -- Protector\'s Band
	[19518]="::4:3:1:::1:0:14754", -- Advisor\'s Ring
	[19519]="::4:3:1:::1:0:14754", -- Advisor\'s Ring
	[19520]="::4:3:1:::1:0:14754", -- Advisor\'s Ring
	[19521]="::4:3:1:::1:0:14754", -- Advisor\'s Ring
	[19522]="::4:3:1:::1:0:14753", -- Lorekeeper\'s Ring
	[19523]="::4:3:1:::1:0:14753", -- Lorekeeper\'s Ring
	[19524]="::4:3:1:::1:0:14753", -- Lorekeeper\'s Ring
	[19525]="::4:3:1:::1:0:14753", -- Lorekeeper\'s Ring
	[19526]="::4:3:1:::1:0:14754", -- Battle Healer\'s Cloak
	[19527]="::4:3:1:::1:0:14754", -- Battle Healer\'s Cloak
	[19528]="::4:3:1:::1:0:14754", -- Battle Healer\'s Cloak
	[19529]="::4:3:1:::1:0:14754", -- Battle Healer\'s Cloak
	[19530]="::4:3:1:::1:0:14753", -- Caretaker\'s Cape
	[19531]="::4:3:1:::1:0:14753", -- Caretaker\'s Cape
	[19532]="::4:3:1:::1:0:14753", -- Caretaker\'s Cape
	[19533]="::4:3:1:::1:0:14753", -- Caretaker\'s Cape
	[19534]="::4:3:1:::1:0:14754", -- Scout\'s Medallion
	[19535]="::4:3:1:::1:0:14754", -- Scout\'s Medallion
	[19536]="::4:3:1:::1:0:14754", -- Scout\'s Medallion
	[19537]="::4:3:1:::1:0:14754", -- Scout\'s Medallion
	[19538]="::4:3:1:::1:0:14753", -- Sentinel\'s Medallion
	[19539]="::4:3:1:::1:0:14753", -- Sentinel\'s Medallion
	[19540]="::4:3:1:::1:0:14753", -- Sentinel\'s Medallion
	[19541]="::4:3:1:::1:0:14753", -- Sentinel\'s Medallion
	[19542]="::2:3:1:::1:0:14754", -- Scout\'s Blade
	[19543]="::2:3:1:::1:0:14754", -- Scout\'s Blade
	[19544]="::2:3:1:::1:0:14754", -- Scout\'s Blade
	[19545]="::2:3:1:::1:0:14754", -- Scout\'s Blade
	[19546]="::2:3:1:::1:0:14753", -- Sentinel\'s Blade
	[19547]="::2:3:1:::1:0:14753", -- Sentinel\'s Blade
	[19548]="::2:3:1:::1:0:14753", -- Sentinel\'s Blade
	[19549]="::2:3:1:::1:0:14753", -- Sentinel\'s Blade
	[19550]="::2:3:1:::1:0:14754", -- Legionnaire\'s Sword
	[19551]="::2:3:1:::1:0:14754", -- Legionnaire\'s Sword
	[19552]="::2:3:1:::1:0:14754", -- Legionnaire\'s Sword
	[19553]="::2:3:1:::1:0:14754", -- Legionnaire\'s Sword
	[19554]="::2:3:1:::1:0:14753", -- Protector\'s Sword
	[19555]="::2:3:1:::1:0:14753", -- Protector\'s Sword
	[19556]="::2:3:1:::1:0:14753", -- Protector\'s Sword
	[19557]="::2:3:1:::1:0:14753", -- Protector\'s Sword
	[19558]="::2:3:1:::1:0:14754", -- Outrider\'s Bow
	[19559]="::2:3:1:::1:0:14754", -- Outrider\'s Bow
	[19560]="::2:3:1:::1:0:14754", -- Outrider\'s Bow
	[19561]="::2:3:1:::1:0:14754", -- Outrider\'s Bow
	[19562]="::2:3:1:::1:0:14753", -- Outrunner\'s Bow
	[19563]="::2:3:1:::1:0:14753", -- Outrunner\'s Bow
	[19564]="::2:3:1:::1:0:14753", -- Outrunner\'s Bow
	[19565]="::2:3:1:::1:0:14753", -- Outrunner\'s Bow
	[19566]="::2:3:1:::1:0:14754", -- Advisor\'s Gnarled Staff
	[19567]="::2:3:1:::1:0:14754", -- Advisor\'s Gnarled Staff
	[19568]="::2:3:1:::1:0:14754", -- Advisor\'s Gnarled Staff
	[19569]="::2:3:1:::1:0:14754", -- Advisor\'s Gnarled Staff
	[19570]="::2:3:1:::1:0:14753", -- Lorekeeper\'s Staff
	[19571]="::2:3:1:::1:0:14753", -- Lorekeeper\'s Staff
	[19572]="::2:3:1:::1:0:14753", -- Lorekeeper\'s Staff
	[19573]="::2:3:1:::1:0:14753", -- Lorekeeper\'s Staff
	[19574]="::4:2:1:::1:0:", -- Strength of Mugamba
	[19575]="::4:3:1:::1:0:", -- Strength of Mugamba
	[19576]="::4:3:1:::1:0:", -- Strength of Mugamba
	[19577]="::4:4:1:::1:0:", -- Rage of Mugamba
	[19578]="::4:4:1:::1:0:14753,14754", -- Berserker Bracers
	[19579]="::4:2:1:::1:0:", -- Heathen\'s Brand
	[19580]="::4:4:1:::1:0:14753,14754", -- Berserker Bracers
	[19581]="::4:4:1:::1:0:14753,14754", -- Berserker Bracers
	[19582]="::4:4:1:::1:0:14753,14754", -- Windtalker\'s Wristguards
	[19583]="::4:4:1:::1:0:14753,14754", -- Windtalker\'s Wristguards
	[19584]="::4:4:1:::1:0:14753,14754", -- Windtalker\'s Wristguards
	[19585]="::4:3:1:::1:0:", -- Heathen\'s Brand
	[19586]="::4:3:1:::1:0:", -- Heathen\'s Brand
	[19587]="::4:4:1:::1:0:14753,14754", -- Forest Stalker\'s Bracers
	[19588]="::4:4:1:::1:0:", -- Hero\'s Brand
	[19589]="::4:4:1:::1:0:14753,14754", -- Forest Stalker\'s Bracers
	[19590]="::4:4:1:::1:0:14753,14754", -- Forest Stalker\'s Bracers
	[19591]="::4:2:1:::1:0:", -- The Eye of Zuldazar
	[19592]="::4:3:1:::1:0:", -- The Eye of Zuldazar
	[19593]="::4:3:1:::1:0:", -- The Eye of Zuldazar
	[19594]="::4:4:1:::1:0:", -- The All-Seeing Eye of Zuldazar
	[19595]="::4:4:1:::1:0:14753,14754", -- Dryad\'s Wrist Bindings
	[19596]="::4:4:1:::1:0:14753,14754", -- Dryad\'s Wrist Bindings
	[19597]="::4:4:1:::1:0:14753,14754", -- Dryad\'s Wrist Bindings
	[19598]="::4:2:1:::1:0:", -- Pebble of Kajaro
	[19599]="::4:3:1:::1:0:", -- Pebble of Kajaro
	[19600]="::4:3:1:::1:0:", -- Pebble of Kajaro
	[19601]="::4:4:1:::1:0:", -- Jewel of Kajaro
	[19602]="::4:2:1:::1:0:", -- Kezan\'s Taint
	[19603]="::4:3:1:::1:0:", -- Kezan\'s Taint
	[19604]="::4:3:1:::1:0:", -- Kezan\'s Taint
	[19605]="::4:4:1:::1:0:", -- Kezan\'s Unstoppable Taint
	[19606]="::4:2:1:::1:0:", -- Vision of Voodress
	[19607]="::4:3:1:::1:0:", -- Vision of Voodress
	[19608]="::4:3:1:::1:0:", -- Vision of Voodress
	[19609]="::4:4:1:::1:0:", -- Unmarred Vision of Voodress
	[19610]="::4:2:1:::1:0:", -- Enchanted South Seas Kelp
	[19611]="::4:3:1:::1:0:", -- Enchanted South Seas Kelp
	[19612]="::4:3:1:::1:0:", -- Enchanted South Seas Kelp
	[19613]="::4:4:1:::1:0:", -- Pristine Enchanted South Seas Kelp
	[19614]="::4:2:1:::1:0:", -- Zandalarian Shadow Talisman
	[19615]="::4:3:1:::1:0:", -- Zandalarian Shadow Talisman
	[19616]="::4:3:1:::1:0:", -- Zandalarian Shadow Talisman
	[19617]="::4:4:1:::1:0:", -- Zandalarian Shadow Mastery Talisman
	[19618]="::4:2:1:::1:0:", -- Maelstrom\'s Tendril
	[19619]="::4:3:1:::1:0:", -- Maelstrom\'s Tendril
	[19620]="::4:3:1:::1:0:", -- Maelstrom\'s Tendril
	[19621]="::4:4:1:::1:0:", -- Maelstrom\'s Wrath
	[19682]=":20986:4:3:1:::1:0:", -- Bloodvine Vest
	[19683]=":21065:4:3:1:::1:0:", -- Bloodvine Leggings
	[19684]=":15856:4:3:1:::1:0:", -- Bloodvine Boots
	[19685]=":26526:4:3:1:::1:0:", -- Primal Batskin Jerkin
	[19686]=":13312:4:3:1:::1:0:", -- Primal Batskin Gloves
	[19687]=":13361:4:3:1:::1:0:", -- Primal Batskin Bracers
	[19688]=":26819:4:3:1:::1:0:", -- Blood Tiger Breastplate
	[19689]=":20188:4:3:1:::1:0:", -- Blood Tiger Shoulders
	[19690]=":33265:4:3:1:::1:0:", -- Bloodsoul Breastplate
	[19691]=":25148:4:3:1:::1:0:", -- Bloodsoul Shoulders
	[19692]=":16749:4:3:1:::1:0:", -- Bloodsoul Gauntlets
	[19693]=":35490:4:3:1:::1:0:", -- Darksoul Breastplate
	[19694]=":35628:4:3:1:::1:0:", -- Darksoul Leggings
	[19695]=":26773:4:3:1:::1:0:", -- Darksoul Shoulders
	[19696]="::0:1:20:::1:0:", -- Harvest Bread
	[19697]="::4:1:1:::1:0:", -- Bounty of the Harvest
	[19698]="::12:2:250:::1:0:", -- Zulian Coin
	[19699]="::12:2:250:::1:0:", -- Razzashi Coin
	[19700]="::12:2:250:::1:0:", -- Hakkari Coin
	[19701]="::12:2:250:::1:0:", -- Gurubashi Coin
	[19702]="::12:2:250:::1:0:", -- Vilebranch Coin
	[19703]="::12:2:250:::1:0:", -- Witherbark Coin
	[19704]="::12:2:250:::1:0:", -- Sandfury Coin
	[19705]="::12:2:250:::1:0:", -- Skullsplitter Coin
	[19706]="::12:2:250:::1:0:", -- Bloodscalp Coin
	[19707]="::12:3:250:::1:0:", -- Red Hakkari Bijou
	[19708]="::12:3:250:::1:0:", -- Blue Hakkari Bijou
	[19709]="::12:3:250:::1:0:", -- Yellow Hakkari Bijou
	[19710]="::12:3:250:::1:0:", -- Orange Hakkari Bijou
	[19711]="::12:3:250:::1:0:", -- Green Hakkari Bijou
	[19712]="::12:3:250:::1:0:", -- Purple Hakkari Bijou
	[19713]="::12:3:250:::1:0:", -- Bronze Hakkari Bijou
	[19714]="::12:3:250:::1:0:", -- Silver Hakkari Bijou
	[19715]="::12:3:250:::1:0:", -- Gold Hakkari Bijou
	[19716]="::12:4:250:::1:0:", -- Primal Hakkari Bindings
	[19717]="::12:4:250:::1:0:", -- Primal Hakkari Armsplint
	[19718]="::12:4:250:::1:0:", -- Primal Hakkari Stanchion
	[19719]="::12:4:250:::1:0:", -- Primal Hakkari Girdle
	[19720]="::12:4:250:::1:0:", -- Primal Hakkari Sash
	[19721]="::12:4:250:::1:0:", -- Primal Hakkari Shawl
	[19722]="::12:4:250:::1:0:", -- Primal Hakkari Tabard
	[19723]="::12:4:250:::1:0:", -- Primal Hakkari Kossack
	[19724]="::12:4:250:::1:0:", -- Primal Hakkari Aegis
	[19725]="::12:1:20:::1:0:", -- Arathi Resource Crate
	[19726]=":500:7:2:20::164,202,165,197:1:0:", -- Bloodvine
	[19727]=":15000:7:3:1:::1:0:", -- Blood Scythe
	[19764]="50000:12500:9:1:1:::1:0:14921", -- Pattern: Bloodvine Vest
	[19765]="50000:12500:9:1:1:::1:0:14921", -- Pattern: Bloodvine Leggings
	[19766]="50000:12500:9:1:1:::1:0:14921", -- Pattern: Bloodvine Boots
	[19767]=":2000:7:1:20::165:1:0:", -- Primal Bat Leather
	[19768]=":2000:7:1:20::165:1:0:", -- Primal Tiger Leather
	[19769]="50000:12500:9:1:1:::1:0:14921", -- Pattern: Primal Batskin Jerkin
	[19770]="50000:12500:9:1:1:::1:0:14921", -- Pattern: Primal Batskin Gloves
	[19771]="50000:12500:9:1:1:::1:0:14921", -- Pattern: Primal Batskin Bracers
	[19772]="50000:12500:9:1:1:::1:0:14921", -- Pattern: Blood Tiger Breastplate
	[19773]="50000:12500:9:1:1:::1:0:14921", -- Pattern: Blood Tiger Shoulders
	[19774]=":5000:3:2:20::164,202:1:0:", -- Souldarite
	[19775]="::15:1:1:::1:0:", -- Sealed Azure Bag
	[19776]="50000:12500:9:1:1:::1:0:14921", -- Plans: Bloodsoul Breastplate
	[19777]="50000:12500:9:1:1:::1:0:14921", -- Plans: Bloodsoul Shoulders
	[19778]="50000:12500:9:1:1:::1:0:14921", -- Plans: Bloodsoul Gauntlets
	[19779]="50000:12500:9:1:1:::1:0:14921", -- Plans: Darksoul Breastplate
	[19780]="50000:12500:9:1:1:::1:0:14921", -- Plans: Darksoul Leggings
	[19781]="50000:12500:9:1:1:::1:0:14921", -- Plans: Darksoul Shoulders
	[19782]="::0:3:1:::1:0:", -- Presence of Might
	[19783]="::0:3:1:::1:0:", -- Syncretist\'s Sigil
	[19784]="::0:3:1:::1:0:", -- Death\'s Embrace
	[19785]="::0:3:1:::1:0:", -- Falcon\'s Call
	[19786]="::0:3:1:::1:0:", -- Vodouisant\'s Vigilant Embrace
	[19787]="::0:3:1:::1:0:", -- Presence of Sight
	[19788]="::0:3:1:::1:0:", -- Hoodoo Hex
	[19789]="::0:3:1:::1:0:", -- Prophetic Aura
	[19790]="::0:3:1:::1:0:", -- Animist\'s Caress
	[19802]="::12:4:1:::1:0:", -- Heart of Hakkar
	[19803]="::15:2:20:::1:0:", -- Brownell\'s Blue Striped Racer
	[19805]="::15:2:20:::1:0:", -- Keefer\'s Angelfish
	[19806]="::15:2:20:::1:0:", -- Dezian Queenfish
	[19807]="::12:1:20:::1:0:", -- Speckled Tastyfish
	[19808]=":15556:2:2:1:::1:0:", -- Rockhide Strongfish
	[19812]="::4:3:1:::1:0:", -- Rune of the Dawn
	[19813]="::12:2:1:::1:0:", -- Punctured Voodoo Doll
	[19814]="::12:2:1:::1:0:", -- Punctured Voodoo Doll
	[19815]="::12:2:1:::1:0:", -- Punctured Voodoo Doll
	[19816]="::12:2:1:::1:0:", -- Punctured Voodoo Doll
	[19817]="::12:2:1:::1:0:", -- Punctured Voodoo Doll
	[19818]="::12:2:1:::1:0:", -- Punctured Voodoo Doll
	[19819]="::12:2:1:::1:0:", -- Punctured Voodoo Doll
	[19820]="::12:2:1:::1:0:", -- Punctured Voodoo Doll
	[19821]="::12:2:1:::1:0:", -- Punctured Voodoo Doll
	[19822]="::4:4:1:::1:0:", -- Zandalar Vindicator\'s Breastplate
	[19823]="::4:4:1:::1:0:", -- Zandalar Vindicator\'s Belt
	[19824]="::4:4:1:::1:0:", -- Zandalar Vindicator\'s Armguards
	[19825]="::4:4:1:::1:0:", -- Zandalar Freethinker\'s Breastplate
	[19826]="::4:4:1:::1:0:", -- Zandalar Freethinker\'s Belt
	[19827]="::4:4:1:::1:0:", -- Zandalar Freethinker\'s Armguards
	[19828]="::4:4:1:::1:0:", -- Zandalar Augur\'s Hauberk
	[19829]="::4:4:1:::1:0:", -- Zandalar Augur\'s Belt
	[19830]="::4:4:1:::1:0:", -- Zandalar Augur\'s Bracers
	[19831]="::4:4:1:::1:0:", -- Zandalar Predator\'s Mantle
	[19832]="::4:4:1:::1:0:", -- Zandalar Predator\'s Belt
	[19833]="::4:4:1:::1:0:", -- Zandalar Predator\'s Bracers
	[19834]="::4:4:1:::1:0:", -- Zandalar Madcap\'s Tunic
	[19835]="::4:4:1:::1:0:", -- Zandalar Madcap\'s Mantle
	[19836]="::4:4:1:::1:0:", -- Zandalar Madcap\'s Bracers
	[19838]="::4:4:1:::1:0:", -- Zandalar Haruspex\'s Tunic
	[19839]="::4:4:1:::1:0:", -- Zandalar Haruspex\'s Belt
	[19840]="::4:4:1:::1:0:", -- Zandalar Haruspex\'s Bracers
	[19841]="::4:4:1:::1:0:", -- Zandalar Confessor\'s Mantle
	[19842]="::4:4:1:::1:0:", -- Zandalar Confessor\'s Bindings
	[19843]="::4:4:1:::1:0:", -- Zandalar Confessor\'s Wraps
	[19845]="::4:4:1:::1:0:", -- Zandalar Illusionist\'s Mantle
	[19846]="::4:4:1:::1:0:", -- Zandalar Illusionist\'s Wraps
	[19848]="::4:4:1:::1:0:", -- Zandalar Demoniac\'s Wraps
	[19849]="::4:4:1:::1:0:", -- Zandalar Demoniac\'s Mantle
	[19850]="::12:1:1:::1:0:", -- Uther\'s Tribute
	[19851]="::12:1:1:::1:0:", -- Grom\'s Tribute
	[19852]=":73811:2:4:1:::1:0:", -- Ancient Hakkari Manslayer
	[19853]=":55563:2:4:1:::1:0:", -- Gurubashi Dwarf Destroyer
	[19854]=":92937:2:4:1:::1:0:", -- Zin\'rokh, Destroyer of Worlds
	[19855]=":52235:4:4:1:::1:0:", -- Bloodsoaked Legplates
	[19856]=":48628:4:4:1:::1:0:", -- The Eye of Hakkar
	[19857]=":22550:4:4:1:::1:0:", -- Cloak of Consumption
	[19858]="::12:2:250:::1:0:", -- Zandalar Honor Token
	[19859]=":75706:2:4:1:::1:0:", -- Fang of the Faceless
	[19861]=":57183:2:4:1:::1:0:", -- Touch of Chaos
	[19862]=":48971:4:4:1:::1:0:", -- Aegis of the Blood God
	[19863]=":61286:4:3:1:::1:0:", -- Primalist\'s Seal
	[19864]=":77063:2:4:1:::1:0:", -- Bloodcaller
	[19865]=":77328:2:4:1:::1:0:", -- Warblade of the Hakkari
	[19866]=":70360:2:4:1:::1:0:", -- Warblade of the Hakkari
	[19867]=":70626:2:4:1:::1:0:", -- Bloodlord\'s Defender
	[19869]=":14200:4:3:1:::1:0:", -- Blooddrenched Grips
	[19870]=":17104:4:3:1:::1:0:", -- Hakkari Loa Cloak
	[19871]=":50287:4:3:1:::1:0:", -- Talisman of Protection
	[19872]="::15:4:1:::1:0:", -- Swift Razzashi Raptor
	[19873]=":48660:4:3:1:::1:0:", -- Overlord\'s Crimson Band
	[19874]=":90591:2:4:1:::1:0:", -- Halberd of Smiting
	[19875]=":26132:4:3:1:::1:0:", -- Bloodstained Coif
	[19876]=":85311:4:4:1:::1:0:", -- Soul Corrupter\'s Necklace
	[19877]=":29245:4:3:1:::1:0:", -- Animist\'s Leggings
	[19878]=":30760:4:3:1:::1:0:", -- Bloodsoaked Pauldrons
	[19880]="::12:1:1:::1:0:", -- Gurubashi Head Collection
	[19881]="::12:1:20:::1:0:", -- Channeler\'s Head
	[19882]="::12:1:20:::1:0:", -- The Hexxer\'s Head
	[19883]="::12:1:1:::1:0:", -- Sacred Cord
	[19884]=":87276:2:4:1:::1:0:", -- Jin\'do\'s Judgement
	[19885]=":44203:4:4:1:::1:0:", -- Jin\'do\'s Evil Eye
	[19886]=":16849:4:3:1:::1:0:", -- The Hexxer\'s Cover
	[19887]=":33827:4:3:1:::1:0:", -- Bloodstained Legplates
	[19888]=":16975:4:3:1:::1:0:", -- Overlord\'s Embrace
	[19889]=":28398:4:3:1:::1:0:", -- Blooddrenched Leggings
	[19890]=":71409:2:4:1:::1:0:", -- Jin\'do\'s Hexxer
	[19891]=":63628:4:4:1:::1:0:", -- Jin\'do\'s Bag of Whammies
	[19892]=":21535:4:3:1:::1:0:", -- Animist\'s Boots
	[19893]=":55355:4:3:1:::1:0:", -- Zanzil\'s Seal
	[19894]=":20364:4:3:1:::1:0:", -- Bloodsoaked Gauntlets
	[19895]=":23224:4:3:1:::1:0:", -- Bloodtinged Kilt
	[19896]=":72049:2:4:1:::1:0:", -- Thekal\'s Grasp
	[19897]=":21693:4:4:1:::1:0:", -- Betrayer\'s Boots
	[19898]=":55035:4:3:1:::1:0:", -- Seal of Jin
	[19899]=":21077:4:3:1:::1:0:", -- Ritualistic Legguards
	[19900]=":66122:2:3:1:::1:0:", -- Zulian Stone Axe
	[19901]=":53102:2:3:1:::1:0:", -- Zulian Slicer
	[19902]="::15:4:1:::1:0:", -- Swift Zulian Tiger
	[19903]=":68651:2:4:1:::1:0:", -- Fang of Venoxis
	[19904]=":41348:4:4:1:::1:0:", -- Runed Bloodstained Hauberk
	[19905]=":45253:4:3:1:::1:0:", -- Zanzil\'s Band
	[19906]=":20294:4:3:1:::1:0:", -- Blooddrenched Footpads
	[19907]=":16295:4:3:1:::1:0:", -- Zulian Tigerhide Cloak
	[19908]=":52467:2:3:1:::1:0:", -- Sceptre of Smiting
	[19909]=":87773:2:4:1:::1:0:", -- Will of Arlokk
	[19910]=":70474:2:4:1:::1:0:", -- Arlokk\'s Grasp
	[19912]=":43548:4:3:1:::1:0:", -- Overlord\'s Onyx Band
	[19913]=":29103:4:3:1:::1:0:", -- Bloodsoaked Greaves
	[19914]=":8750:1:3:1:::1:0:", -- Panther Hide Sack
	[19915]=":36742:4:3:1:::1:0:", -- Zulian Defender
	[19918]=":93051:2:4:1:::1:0:", -- Jeklik\'s Crusher
	[19919]=":23814:4:3:1:::1:0:", -- Bloodstained Greaves
	[19920]=":56037:4:3:1:::1:0:", -- Primalist\'s Band
	[19921]=":51094:2:3:1:::1:0:", -- Zulian Hacker
	[19922]=":63655:4:3:1:::1:0:", -- Arlokk\'s Hoodoo Stick
	[19923]=":44030:4:3:1:::1:0:", -- Jeklik\'s Opaline Talisman
	[19925]=":43635:4:3:1:::1:0:", -- Band of Jin
	[19927]=":52265:2:4:1:::1:0:", -- Mar\'li\'s Touch
	[19928]=":20444:4:3:1:::1:0:", -- Animist\'s Spaulders
	[19929]=":11356:4:3:1:::1:0:", -- Bloodtinged Gloves
	[19930]=":73852:4:3:1:::1:0:", -- Mar\'li\'s Eye
	[19931]="::12:3:20:::1:0:", -- Gurubashi Mojo Madness
	[19933]=":2080:15:1:10:::1:0:", -- Glowing Scorpid Blood
	[19934]=":1400:15:0:10:::1:0:", -- Large Scorpid Claw
	[19935]=":830:15:0:10:::1:0:", -- Empty Venom Sac
	[19936]=":830:15:0:10:::1:0:", -- Dried Scorpid Carapace
	[19937]=":780:15:0:10:::1:0:", -- Small Scorpid Claw
	[19938]=":580:15:0:10:::1:0:", -- Heavy Scorpid Leg
	[19939]="::12:2:1:::1:0:", -- Gri\'lek\'s Blood
	[19940]="::12:2:1:::1:0:", -- Renataki\'s Tooth
	[19941]="::12:2:1:::1:0:", -- Wushoolay\'s Mane
	[19942]="::12:2:1:::1:0:", -- Hazza\'rah\'s Dream Thread
	[19943]=":2000:7:1:20::171:1:0:", -- Massive Mojo
	[19944]=":86115:2:4:1:::1:0:", -- Nat Pagle\'s Fish Terminator
	[19945]=":25933:4:4:1:::1:0:", -- Foror\'s Eyepatch
	[19946]=":67629:2:3:1:::1:0:", -- Tigule\'s Harpoon
	[19947]=":86528:4:3:1:::1:0:", -- Nat Pagle\'s Broken Reel
	[19948]=":111303:4:4:1:::1:0:", -- Zandalarian Hero Badge
	[19949]=":111303:4:4:1:::1:0:", -- Zandalarian Hero Medallion
	[19950]=":111303:4:4:1:::1:0:", -- Zandalarian Hero Charm
	[19951]="::4:4:1:::1:0:", -- Gri\'lek\'s Charm of Might
	[19952]="::4:4:1:::1:0:", -- Gri\'lek\'s Charm of Valor
	[19953]="::4:4:1:::1:0:", -- Renataki\'s Charm of Beasts
	[19954]="::4:4:1:::1:0:", -- Renataki\'s Charm of Trickery
	[19955]="::4:4:1:::1:0:", -- Wushoolay\'s Charm of Nature
	[19956]="::4:4:1:::1:0:", -- Wushoolay\'s Charm of Spirits
	[19957]="::4:4:1:::1:0:", -- Hazza\'rah\'s Charm of Destruction
	[19958]="::4:4:1:::1:0:", -- Hazza\'rah\'s Charm of Healing
	[19959]="::4:4:1:::1:0:", -- Hazza\'rah\'s Charm of Magic
	[19961]=":53080:2:3:1:::1:0:", -- Gri\'lek\'s Grinder
	[19962]=":66605:2:3:1:::1:0:", -- Gri\'lek\'s Carver
	[19963]=":68686:2:3:1:::1:0:", -- Pitchfork of Madness
	[19964]=":55154:2:3:1:::1:0:", -- Renataki\'s Soul Conduit
	[19965]=":55358:2:3:1:::1:0:", -- Wushoolay\'s Poker
	[19967]=":41821:2:3:1:::1:0:", -- Thoughtblighter
	[19968]=":55966:2:3:1:::1:0:", -- Fiery Retributer
	[19969]=":3360:4:2:1:::1:0:", -- Nat Pagle\'s Extreme Anglin\' Boots
	[19970]=":2175:2:3:1:::1:0:", -- Arcanite Fishing Pole
	[19971]=":2000:0:2:5:::1:0:", -- High Test Eternium Fishing Line
	[19972]=":3396:4:2:1:::1:0:", -- Lucky Fishing Hat
	[19973]="::12:1:1:::1:0:", -- Nat\'s Measuring Tape
	[19974]="10000:2500:12:1:20:::1:0:12919", -- Mudskunk Lure
	[19975]="::12:1:20:::1:0:", -- Zulian Mudskunk
	[19978]="::15:1:1:::1:0:", -- Fishing Tournament!
	[19979]=":25000:4:3:1:::1:0:", -- Hook of the Master Angler
	[19982]=":9444:4:3:1:::1:0:", -- Duskbat Drape
	[19984]=":11893:4:3:1:::1:0:", -- Ebon Mask
	[19990]=":25000:4:3:1:::1:0:", -- Blessed Prayer Beads
	[19991]=":10000:4:3:1:::1:0:", -- Devilsaur Eye
	[19992]=":10000:4:3:1:::1:0:", -- Devilsaur Tooth
	[19993]=":42730:2:3:1:::1:0:", -- Hoodoo Hunting Bow
	[19994]="::0:1:20:::1:0:", -- Harvest Fruit
	[19995]="::0:1:20:::1:0:", -- Harvest Boar
	[19996]="::0:1:20:::1:0:", -- Harvest Fish
	[19997]="::0:1:20:::1:0:", -- Harvest Nectar
	[19998]=":19457:4:3:1:::1:0:", -- Bloodvine Lens
	[19999]=":15625:4:3:1:::1:0:", -- Bloodvine Goggles
	[20000]="120000:30000:9:1:1:::1:0:14921", -- Schematic: Bloodvine Goggles
	[20001]="50000:12500:9:1:1:::1:0:14921", -- Schematic: Bloodvine Lens
	[20002]=":1000:0:1:5:::1:0:", -- Greater Dreamless Sleep Potion
	[20004]=":1000:0:1:20:::1:0:", -- Major Troll\'s Blood Potion
	[20006]=":8375:4:3:1:::1:0:", -- Circle of Hope
	[20007]=":1000:0:1:20:::1:0:", -- Mageblood Potion
	[20008]=":600:0:1:5:::1:0:", -- Living Action Potion
	[20009]="::12:1:1:::1:0:", -- For the Light!
	[20010]="::12:1:1:::1:0:", -- The Horde\'s Hellscream
	[20011]="50000:12500:9:1:1:::1:0:14921", -- Recipe: Mageblood Potion
	[20012]="50000:12500:9:1:1:::1:0:14921", -- Recipe: Greater Dreamless Sleep Potion
	[20013]="50000:12500:9:1:1:::1:0:14921", -- Recipe: Living Action Potion
	[20014]="50000:12500:9:1:1:::1:0:14921", -- Recipe: Major Troll\'s Blood Potion
	[20015]=":1658:15:0:10:::1:0:", -- Elder Raptor Feathers
	[20016]=":3635:15:0:1:::1:0:", -- Trophy Raptor Skull
	[20017]="::15:1:5:::1:0:", -- Perfect Courser Antler
	[20019]="::15:1:1:::1:0:", -- Tooth of Morphaz
	[20022]="::13:1:1:::1:0:", -- Azure Key
	[20023]="::12:1:20:::1:0:", -- Encoded Fragment
	[20025]="::12:1:1:::1:0:", -- Blood of Morphaz
	[20027]="::12:1:10:::1:0:", -- Healthy Courser Gland
	[20028]="::12:1:20:::1:0:", -- Glittering Dust
	[20029]="::12:1:20:::1:0:", -- Enchanted Coral
	[20030]=":1580:15:0:1:::1:0:", -- Pet Rock
	[20031]="::0:1:20:::1:0:", -- Essence Mango
	[20032]=":27040:4:4:1:::1:0:", -- Flowing Ritual Robes
	[20033]="::4:4:1:::1:0:", -- Zandalar Demoniac\'s Robe
	[20034]="::4:4:1:::1:0:", -- Zandalar Illusionist\'s Robe
	[20035]=":30651:2:3:1:::1:0:", -- Glacial Spike
	[20036]=":2750:4:3:1:::1:0:", -- Fire Ruby
	[20037]=":15003:4:3:1:::1:0:", -- Arcane Crystal Pendant
	[20038]=":52549:2:4:1:::1:0:", -- Mandokir\'s Sting
	[20039]=":38754:4:4:1:::1:0:", -- Dark Iron Boots
	[20040]="80000:20000:9:1:1:::1:0:12944", -- Plans: Dark Iron Boots
	[20041]="::4:3:1:::1:0:15127", -- Highlander\'s Plate Girdle
	[20042]="::4:3:1:::1:0:15127", -- Highlander\'s Lamellar Girdle
	[20043]="::4:3:1:::1:0:15127", -- Highlander\'s Chain Girdle
	[20044]="::4:3:1:::1:0:15127", -- Highlander\'s Mail Girdle
	[20045]="::4:3:1:::1:0:15127", -- Highlander\'s Leather Girdle
	[20046]="::4:3:1:::1:0:15127", -- Highlander\'s Lizardhide Girdle
	[20047]="::4:3:1:::1:0:15127", -- Highlander\'s Cloth Girdle
	[20048]="::4:3:1:::1:0:15127", -- Highlander\'s Plate Greaves
	[20049]="::4:3:1:::1:0:15127", -- Highlander\'s Lamellar Greaves
	[20050]="::4:3:1:::1:0:15127", -- Highlander\'s Chain Greaves
	[20051]="::4:3:1:::1:0:15127", -- Highlander\'s Mail Greaves
	[20052]="::4:3:1:::1:0:15127", -- Highlander\'s Leather Boots
	[20053]="::4:3:1:::1:0:15127", -- Highlander\'s Lizardhide Boots
	[20054]="::4:3:1:::1:0:15127", -- Highlander\'s Cloth Boots
	[20055]="::4:4:1:::1:0:15127", -- Highlander\'s Chain Pauldrons
	[20056]="::4:4:1:::1:0:15127", -- Highlander\'s Mail Pauldrons
	[20057]="::4:4:1:::1:0:15127", -- Highlander\'s Plate Spaulders
	[20058]="::4:4:1:::1:0:15127", -- Highlander\'s Lamellar Spaulders
	[20059]="::4:4:1:::1:0:15127", -- Highlander\'s Leather Shoulders
	[20060]="::4:4:1:::1:0:15127", -- Highlander\'s Lizardhide Shoulders
	[20061]="::4:4:1:::1:0:15127", -- Highlander\'s Epaulets
	[20062]=":100:0:1:20:::1:0:", -- Arathi Basin Enriched Ration
	[20063]=":50:0:1:20:::1:0:", -- Arathi Basin Field Ration
	[20064]=":75:0:1:20:::1:0:", -- Arathi Basin Iron Ration
	[20065]=":75:0:1:20:::1:0:", -- Arathi Basin Mageweave Bandage
	[20066]=":100:0:1:20:::1:0:", -- Arathi Basin Runecloth Bandage
	[20067]=":50:0:1:20:::1:0:", -- Arathi Basin Silk Bandage
	[20068]="::4:4:1:::1:0:15126", -- Deathguard\'s Cloak
	[20069]="::2:4:1:::1:0:15127", -- Ironbark Staff
	[20070]="::2:4:1:::1:0:15127", -- Sageclaw
	[20071]="::4:3:1:::1:0:15127", -- Talisman of Arathor
	[20072]="::4:3:1:::1:0:15126", -- Defiler\'s Talisman
	[20073]="::4:4:1:::1:0:15127", -- Cloak of the Honor Guard
	[20074]=":300:0:1:20:::1:0:", -- Heavy Crocolisk Stew
	[20075]="2000:500:9:1:1:::1:0:4879", -- Recipe: Heavy Crocolisk Stew
	[20076]="::0:3:1:::1:0:", -- Zandalar Signet of Mojo
	[20077]="::0:3:1:::1:0:", -- Zandalar Signet of Might
	[20078]="::0:3:1:::1:0:", -- Zandalar Signet of Serenity
	[20079]="::0:2:1:::1:0:", -- Spirit of Zanza
	[20080]="::0:2:1:::1:0:", -- Sheen of Zanza
	[20081]="::0:2:1:::1:0:", -- Swiftness of Zanza
	[20082]=":24229:2:3:1:::1:0:", -- Woestave
	[20083]=":40524:2:3:1:::1:0:", -- Hunting Spear
	[20085]="::15:1:1:::1:0:", -- Arcane Shard
	[20086]=":1:15:2:200:::1:0:", -- Broken Dusksteel Throwing Knife
	[20087]="::15:1:20:::1:0:", -- Wavethrasher Scales
	[20088]="::4:3:1:::1:0:15127", -- Highlander\'s Chain Girdle
	[20089]="::4:3:1:::1:0:15127", -- Highlander\'s Chain Girdle
	[20090]="::4:3:1:::1:0:15127", -- Highlander\'s Padded Girdle
	[20091]="::4:3:1:::1:0:15127", -- Highlander\'s Chain Greaves
	[20092]="::4:3:1:::1:0:15127", -- Highlander\'s Chain Greaves
	[20093]="::4:3:1:::1:0:15127", -- Highlander\'s Padded Greaves
	[20094]="::4:3:1:::1:0:15127", -- Highlander\'s Cloth Boots
	[20095]="::4:3:1:::1:0:15127", -- Highlander\'s Cloth Boots
	[20096]="::4:3:1:::1:0:15127", -- Highlander\'s Cloth Boots
	[20097]="::4:3:1:::1:0:15127", -- Highlander\'s Cloth Girdle
	[20098]="::4:3:1:::1:0:15127", -- Highlander\'s Cloth Girdle
	[20099]="::4:3:1:::1:0:15127", -- Highlander\'s Cloth Girdle
	[20100]="::4:3:1:::1:0:15127", -- Highlander\'s Lizardhide Boots
	[20101]="::4:3:1:::1:0:15127", -- Highlander\'s Lizardhide Boots
	[20102]="::4:3:1:::1:0:15127", -- Highlander\'s Lizardhide Boots
	[20103]="::4:3:1:::1:0:15127", -- Highlander\'s Lizardhide Girdle
	[20104]="::4:3:1:::1:0:15127", -- Highlander\'s Lizardhide Girdle
	[20105]="::4:3:1:::1:0:15127", -- Highlander\'s Lizardhide Girdle
	[20106]="::4:3:1:::1:0:15127", -- Highlander\'s Lamellar Girdle
	[20107]="::4:3:1:::1:0:15127", -- Highlander\'s Lamellar Girdle
	[20108]="::4:3:1:::1:0:15127", -- Highlander\'s Lamellar Girdle
	[20109]="::4:3:1:::1:0:15127", -- Highlander\'s Lamellar Greaves
	[20110]="::4:3:1:::1:0:15127", -- Highlander\'s Lamellar Greaves
	[20111]="::4:3:1:::1:0:15127", -- Highlander\'s Lamellar Greaves
	[20112]="::4:3:1:::1:0:15127", -- Highlander\'s Leather Boots
	[20113]="::4:3:1:::1:0:15127", -- Highlander\'s Leather Boots
	[20114]="::4:3:1:::1:0:15127", -- Highlander\'s Leather Boots
	[20115]="::4:3:1:::1:0:15127", -- Highlander\'s Leather Girdle
	[20116]="::4:3:1:::1:0:15127", -- Highlander\'s Leather Girdle
	[20117]="::4:3:1:::1:0:15127", -- Highlander\'s Leather Girdle
	[20118]="::4:3:1:::1:0:15127", -- Highlander\'s Mail Girdle
	[20119]="::4:3:1:::1:0:15127", -- Highlander\'s Mail Girdle
	[20120]="::4:3:1:::1:0:15127", -- Highlander\'s Mail Girdle
	[20121]="::4:3:1:::1:0:15127", -- Highlander\'s Mail Greaves
	[20122]="::4:3:1:::1:0:15127", -- Highlander\'s Mail Greaves
	[20123]="::4:3:1:::1:0:15127", -- Highlander\'s Mail Greaves
	[20124]="::4:3:1:::1:0:15127", -- Highlander\'s Plate Girdle
	[20125]="::4:3:1:::1:0:15127", -- Highlander\'s Plate Girdle
	[20126]="::4:3:1:::1:0:15127", -- Highlander\'s Mail Girdle
	[20127]="::4:3:1:::1:0:15127", -- Highlander\'s Plate Greaves
	[20128]="::4:3:1:::1:0:15127", -- Highlander\'s Plate Greaves
	[20129]="::4:3:1:::1:0:15127", -- Highlander\'s Mail Greaves
	[20130]=":10000:4:3:1:::1:0:", -- Diamond Flask
	[20131]="::4:1:1:::1:0:", -- Battle Tabard of the Defilers
	[20132]="::4:1:1:::1:0:", -- Arathor Battle Tabard
	[20134]=":30246:4:4:1:::1:0:", -- Skyfury Helm
	[20150]="::4:3:1:::1:0:15126", -- Defiler\'s Chain Girdle
	[20151]="::4:3:1:::1:0:15126", -- Defiler\'s Chain Girdle
	[20152]="::4:3:1:::1:0:15126", -- Defiler\'s Chain Girdle
	[20153]="::4:3:1:::1:0:15126", -- Defiler\'s Chain Girdle
	[20154]="::4:3:1:::1:0:15126", -- Defiler\'s Chain Greaves
	[20155]="::4:3:1:::1:0:15126", -- Defiler\'s Chain Greaves
	[20156]="::4:3:1:::1:0:15126", -- Defiler\'s Chain Greaves
	[20157]="::4:3:1:::1:0:15126", -- Defiler\'s Chain Greaves
	[20158]="::4:4:1:::1:0:15126", -- Defiler\'s Chain Pauldrons
	[20159]="::4:3:1:::1:0:15126", -- Defiler\'s Cloth Boots
	[20160]="::4:3:1:::1:0:15126", -- Defiler\'s Cloth Boots
	[20161]="::4:3:1:::1:0:15126", -- Defiler\'s Cloth Boots
	[20162]="::4:3:1:::1:0:15126", -- Defiler\'s Cloth Boots
	[20163]="::4:3:1:::1:0:15126", -- Defiler\'s Cloth Girdle
	[20164]="::4:3:1:::1:0:15126", -- Defiler\'s Cloth Girdle
	[20165]="::4:3:1:::1:0:15126", -- Defiler\'s Cloth Girdle
	[20166]="::4:3:1:::1:0:15126", -- Defiler\'s Cloth Girdle
	[20167]="::4:3:1:::1:0:15126", -- Defiler\'s Lizardhide Boots
	[20168]="::4:3:1:::1:0:15126", -- Defiler\'s Lizardhide Boots
	[20169]="::4:3:1:::1:0:15126", -- Defiler\'s Lizardhide Boots
	[20170]="::4:3:1:::1:0:15126", -- Defiler\'s Lizardhide Boots
	[20171]="::4:3:1:::1:0:15126", -- Defiler\'s Lizardhide Girdle
	[20172]="::4:3:1:::1:0:15126", -- Defiler\'s Lizardhide Girdle
	[20173]="::4:3:1:::1:0:15126", -- Defiler\'s Lizardhide Girdle
	[20174]="::4:3:1:::1:0:15126", -- Defiler\'s Lizardhide Girdle
	[20175]="::4:4:1:::1:0:15126", -- Defiler\'s Lizardhide Shoulders
	[20176]="::4:4:1:::1:0:15126", -- Defiler\'s Epaulets
	[20177]="::4:3:1:::1:0:15126", -- Defiler\'s Lamellar Girdle
	[20178]="::4:3:1:::1:0:15126", -- Defiler\'s Lamellar Girdle
	[20179]="::4:3:1:::1:0:15126", -- Defiler\'s Lamellar Girdle
	[20180]="::4:3:1:::1:0:15126", -- Defiler\'s Lamellar Girdle
	[20181]="::4:3:1:::1:0:15126", -- Defiler\'s Lamellar Greaves
	[20182]="::4:3:1:::1:0:15126", -- Defiler\'s Lamellar Greaves
	[20183]="::4:3:1:::1:0:15126", -- Defiler\'s Lamellar Greaves
	[20184]="::4:4:1:::1:0:15126", -- Defiler\'s Lamellar Spaulders
	[20185]="::4:3:1:::1:0:15126", -- Defiler\'s Lamellar Greaves
	[20186]="::4:3:1:::1:0:15126", -- Defiler\'s Leather Boots
	[20187]="::4:3:1:::1:0:15126", -- Defiler\'s Leather Boots
	[20188]="::4:3:1:::1:0:15126", -- Defiler\'s Leather Boots
	[20189]="::4:3:1:::1:0:15126", -- Defiler\'s Leather Boots
	[20190]="::4:3:1:::1:0:15126", -- Defiler\'s Leather Girdle
	[20191]="::4:3:1:::1:0:15126", -- Defiler\'s Leather Girdle
	[20192]="::4:3:1:::1:0:15126", -- Defiler\'s Leather Girdle
	[20193]="::4:3:1:::1:0:15126", -- Defiler\'s Leather Girdle
	[20194]="::4:4:1:::1:0:15126", -- Defiler\'s Leather Shoulders
	[20195]="::4:3:1:::1:0:15126", -- Defiler\'s Mail Girdle
	[20196]="::4:3:1:::1:0:15126", -- Defiler\'s Mail Girdle
	[20197]="::4:3:1:::1:0:15126", -- Defiler\'s Padded Girdle
	[20198]="::4:3:1:::1:0:15126", -- Defiler\'s Mail Girdle
	[20199]="::4:3:1:::1:0:15126", -- Defiler\'s Mail Greaves
	[20200]="::4:3:1:::1:0:15126", -- Defiler\'s Mail Greaves
	[20201]="::4:3:1:::1:0:15126", -- Defiler\'s Mail Greaves
	[20202]="::4:3:1:::1:0:15126", -- Defiler\'s Mail Greaves
	[20203]="::4:4:1:::1:0:15126", -- Defiler\'s Mail Pauldrons
	[20204]="::4:3:1:::1:0:15126", -- Defiler\'s Plate Girdle
	[20205]="::4:3:1:::1:0:15126", -- Defiler\'s Plate Girdle
	[20206]="::4:3:1:::1:0:15126", -- Defiler\'s Plate Girdle
	[20207]="::4:3:1:::1:0:15126", -- Defiler\'s Mail Girdle
	[20208]="::4:3:1:::1:0:15126", -- Defiler\'s Plate Greaves
	[20209]="::4:3:1:::1:0:15126", -- Defiler\'s Plate Greaves
	[20210]="::4:3:1:::1:0:15126", -- Defiler\'s Mail Greaves
	[20211]="::4:3:1:::1:0:15126", -- Defiler\'s Plate Greaves
	[20212]="::4:4:1:::1:0:15126", -- Defiler\'s Plate Spaulders
	[20213]=":20119:4:3:1:::1:0:", -- Belt of Shrunken Heads
	[20214]="::2:4:1:::1:0:15126", -- Mindfang
	[20215]=":17271:4:3:1:::1:0:", -- Belt of Shriveled Heads
	[20216]=":14445:4:3:1:::1:0:", -- Belt of Preserved Heads
	[20217]=":11598:4:3:1:::1:0:", -- Belt of Tiny Heads
	[20218]=":14590:4:3:1:::1:0:", -- Faded Hakkari Cloak
	[20219]=":14641:4:3:1:::1:0:", -- Tattered Hakkari Cape
	[20220]="::2:4:1:::1:0:15126", -- Ironbark Staff
	[20222]="2000:100:0:1:20:::5:0:15126", -- Defiler\'s Enriched Ration
	[20223]="1000:50:0:1:20:::5:0:15126", -- Defiler\'s Field Ration
	[20224]="1500:75:0:1:20:::5:0:15126", -- Defiler\'s Iron Ration
	[20225]="2000:100:0:1:20:::5:0:15127", -- Highlander\'s Enriched Ration
	[20226]="1000:50:0:1:20:::5:0:15127", -- Highlander\'s Field Ration
	[20227]="1500:75:0:1:20:::5:0:15127", -- Highlander\'s Iron Ration
	[20228]="::15:1:1:::1:0:", -- Defiler\'s Advanced Care Package
	[20229]="::15:1:1:::1:0:", -- Defiler\'s Basic Care Package
	[20230]="::15:1:1:::1:0:", -- Defiler\'s Standard Care Package
	[20231]="::15:1:1:::1:0:", -- Arathor Advanced Care Package
	[20232]="1500:75:0:1:20:::5:0:15126", -- Defiler\'s Mageweave Bandage
	[20233]="::15:1:1:::1:0:", -- Arathor Basic Care Package
	[20234]="2000:100:0:1:20:::5:0:15126", -- Defiler\'s Runecloth Bandage
	[20235]="1000:50:0:1:20:::5:0:15126", -- Defiler\'s Silk Bandage
	[20236]="::15:1:1:::1:0:", -- Arathor Standard Care Package
	[20237]="1500:75:0:1:20:::5:0:15127", -- Highlander\'s Mageweave Bandage
	[20243]="2000:100:0:1:20:::5:0:15127", -- Highlander\'s Runecloth Bandage
	[20244]="1000:50:0:1:20:::5:0:15127", -- Highlander\'s Silk Bandage
	[20253]="16000:4000:9:1:1:::1:0:11557", -- Pattern: Warbear Harness
	[20254]="20000:5000:9:1:1:::1:0:11557", -- Pattern: Warbear Woolies
	[20255]=":12425:4:3:1:::1:0:", -- Whisperwalk Boots
	[20256]="::12:2:250:::1:0:", -- Warsong Gulch Ribbon of Sacrifice
	[20257]=":23207:4:4:1:::1:0:", -- Seafury Gauntlets
	[20258]=":63375:2:3:1:::1:0:", -- Zulian Ceremonial Staff
	[20259]=":12724:4:3:1:::1:0:", -- Shadow Panther Hide Gloves
	[20260]=":31854:4:3:1:::1:0:", -- Seafury Leggings
	[20261]=":12821:4:3:1:::1:0:", -- Shadow Panther Hide Belt
	[20262]=":24182:4:3:1:::1:0:", -- Seafury Boots
	[20263]=":27080:4:3:1:::1:0:", -- Gurubashi Helm
	[20264]=":25299:4:4:1:::1:0:", -- Peacekeeper Gauntlets
	[20265]=":28353:4:3:1:::1:0:", -- Peacekeeper Boots
	[20266]=":38019:4:3:1:::1:0:", -- Peacekeeper Leggings
	[20295]=":31083:4:3:1:::1:0:", -- Blue Dragonscale Leggings
	[20296]=":12590:4:3:1:::1:0:", -- Green Dragonscale Gauntlets
	[20310]="::12:1:1:::1:0:", -- Flayed Demon Skin
	[20369]=":9975:4:3:1:::1:0:", -- Azurite Fists
	[20371]="::15:3:1:::1:0:", -- Blue Murloc Egg
	[20373]="::12:1:20:::1:0:", -- Stonelash Scorpid Stinger
	[20374]="::12:1:20:::1:0:", -- Stonelash Pincer Stinger
	[20375]="::12:1:20:::1:0:", -- Stonelash Flayer Stinger
	[20376]="::12:1:20:::1:0:", -- Sand Skitterer Fang
	[20377]="::12:1:20:::1:0:", -- Rock Stalker Fang
	[20378]="::12:1:20:::1:0:", -- Twilight Tablet Fragment
	[20379]="::12:1:1:::1:0:", -- Noggle\'s Satchel
	[20380]=":43614:4:4:1:::1:0:", -- Dreamscale Breastplate
	[20381]=":5000:7:2:20::165:1:0:", -- Dreamscale
	[20382]="60000:15000:9:1:1:::1:0:15293", -- Pattern: Dreamscale Breastplate
	[20383]="::12:1:1:::1:0:", -- Head of the Broodlord Lashlayer
	[20384]="::12:1:200:::1:0:", -- Silithid Carapace Fragment
	[20385]="::12:1:1:::1:0:", -- Deathclasp\'s Pincer
	[20387]="1000::12:1:1:::1:0:15197", -- Forsaken Stink Bomb Cluster
	[20388]="::0:1:20:::1:0:", -- Lollipop
	[20389]="::0:1:20:::1:0:", -- Candy Corn
	[20390]="::0:1:20:::1:0:", -- Candy Bar
	[20391]=":1:4:1:1:::1:0:", -- Flimsy Male Gnome Mask
	[20392]=":1:4:1:1:::1:0:", -- Flimsy Female Gnome Mask
	[20393]="::15:1:1:::1:0:", -- Treat Bag
	[20394]="::12:1:1:::1:0:", -- Twilight Lexicon - Chapter 1
	[20395]="::12:1:1:::1:0:", -- Twilight Lexicon - Chapter 2
	[20396]="::12:1:1:::1:0:", -- Twilight Lexicon - Chapter 3
	[20397]="::0:1:1:::1:0:", -- Hallowed Wand - Pirate
	[20398]="::0:1:1:::1:0:", -- Hallowed Wand - Ninja
	[20399]="::0:1:1:::1:0:", -- Hallowed Wand - Leper Gnome
	[20400]=":20000:1:2:1:::1:0:", -- Pumpkin Bag
	[20401]="::12:1:1:::1:0:", -- Restored Twilight Tablet
	[20402]="::15:2:1:::1:0:", -- Agent of Nozdormu
	[20403]="::15:2:1:::1:0:", -- Proxy of Nozdormu
	[20404]="::12:1:250:::1:0:", -- Encrypted Twilight Text
	[20405]="::12:1:1:::1:0:", -- Decoded Tablet Transcription
	[20406]=":1929:4:2:1:::1:0:", -- Twilight Cultist Mantle
	[20407]=":2581:4:2:1:::1:0:", -- Twilight Cultist Robe
	[20408]=":1942:4:2:1:::1:0:", -- Twilight Cultist Cowl
	[20409]="::0:1:1:::1:0:", -- Hallowed Wand - Ghost
	[20410]="::0:1:1:::1:0:", -- Hallowed Wand - Bat
	[20411]="::0:1:1:::1:0:", -- Hallowed Wand - Skeleton
	[20413]="::0:1:1:::1:0:", -- Hallowed Wand - Random
	[20414]="::0:1:1:::1:0:", -- Hallowed Wand - Wisp
	[20415]="::15:1:1:::1:0:", -- The War of the Shifting Sands
	[20416]="::12:1:20:::1:0:", -- Crest of Beckoning: Fire
	[20418]="::12:1:20:::1:0:", -- Crest of Beckoning: Thunder
	[20419]="::12:1:20:::1:0:", -- Crest of Beckoning: Earth
	[20420]="::12:1:20:::1:0:", -- Crest of Beckoning: Water
	[20422]="::4:1:1:::1:0:", -- Twilight Cultist Medallion of Station
	[20424]=":175:7:1:20::185:1:0:", -- Sandworm Meat
	[20425]="::2:3:1:::1:0:14754", -- Advisor\'s Gnarled Staff
	[20426]="::4:3:1:::1:0:14754", -- Advisor\'s Ring
	[20427]="::4:3:1:::1:0:14754", -- Battle Healer\'s Cloak
	[20428]="::4:3:1:::1:0:14753", -- Caretaker\'s Cape
	[20429]="::4:3:1:::1:0:14754", -- Legionnaire\'s Band
	[20430]="::2:3:1:::1:0:14754", -- Legionnaire\'s Sword
	[20431]="::4:3:1:::1:0:14753", -- Lorekeeper\'s Ring
	[20432]="::12:1:20:::1:0:", -- Signet of Beckoning: Fire
	[20433]="::12:1:20:::1:0:", -- Signet of Beckoning: Thunder
	[20434]="::2:3:1:::1:0:14753", -- Lorekeeper\'s Staff
	[20435]="::12:1:20:::1:0:", -- Signet of Beckoning: Stone
	[20436]="::12:1:20:::1:0:", -- Signet of Beckoning: Water
	[20437]="::2:3:1:::1:0:14754", -- Outrider\'s Bow
	[20438]="::2:3:1:::1:0:14753", -- Outrunner\'s Bow
	[20439]="::4:3:1:::1:0:14753", -- Protector\'s Band
	[20440]="::2:3:1:::1:0:14753", -- Protector\'s Sword
	[20441]="::2:3:1:::1:0:14754", -- Scout\'s Blade
	[20442]="::4:3:1:::1:0:14754", -- Scout\'s Medallion
	[20443]="::2:3:1:::1:0:14753", -- Sentinel\'s Blade
	[20444]="::4:3:1:::1:0:14753", -- Sentinel\'s Medallion
	[20447]="::12:1:20:::1:0:", -- Scepter of Beckoning: Fire
	[20448]="::12:1:20:::1:0:", -- Scepter of Beckoning: Thunder
	[20449]="::12:1:20:::1:0:", -- Scepter of Beckoning: Stone
	[20450]="::12:1:20:::1:0:", -- Scepter of Beckoning: Water
	[20451]="::4:1:1:::1:0:", -- Twilight Cultist Ring of Lordship
	[20452]=":250:0:1:20:::1:0:", -- Smoked Desert Dumplings
	[20453]="::12:1:1:::1:0:", -- Geologist\'s Transcription Kit
	[20454]="::12:1:1:::1:0:", -- Hive\'Zora Rubbing
	[20455]="::12:1:1:::1:0:", -- Hive\'Ashi Rubbing
	[20456]="::12:1:1:::1:0:", -- Hive\'Regal Rubbing
	[20457]="::12:1:1:::1:0:", -- Hive\'Ashi Silithid Brain
	[20458]="::12:1:1:::1:0:", -- Hive\'Zora Silithid Brain
	[20459]="::12:1:1:::1:0:", -- Hive\'Regal Silithid Brain
	[20461]="::15:1:1:::1:0:", -- Brann Bronzebeard\'s Lost Letter
	[20463]="::12:1:1:::1:0:", -- Glyphed Crystal Prism
	[20464]="::15:1:1:::1:0:", -- Glyphs of Calling
	[20465]="::12:1:1:::1:0:", -- Crystal Unlocking Mechanism
	[20466]="::12:1:1:::1:0:", -- Vyral\'s Signet Ring
	[20467]="::12:1:1:::1:0:", -- Torn Recipe Page
	[20469]=":12:15:1:1:::1:0:", -- Decoded True Believer Clippings
	[20470]="::12:1:1:::1:0:", -- Solanian\'s Scrying Orb
	[20471]="::12:1:1:::1:0:", -- Scroll of Scourge Magic
	[20472]="::12:1:1:::1:0:", -- Solanian\'s Journal
	[20474]="::1:1:1:::1:0:", -- Sunstrider Book Satchel
	[20475]=":6250:0:1:1:::1:0:", -- Adamantite Arrow Maker
	[20476]=":15292:4:3:1:::1:0:", -- Sandstalker Bracers
	[20477]=":15755:4:3:1:::1:0:", -- Sandstalker Gauntlets
	[20478]=":31624:4:3:1:::1:0:", -- Sandstalker Breastplate
	[20479]=":31734:4:3:1:::1:0:", -- Spitfire Breastplate
	[20480]=":15924:4:3:1:::1:0:", -- Spitfire Gauntlets
	[20481]=":15980:4:3:1:::1:0:", -- Spitfire Bracers
	[20482]="::12:1:20:::1:0:", -- Arcane Sliver
	[20483]="::15:1:1:::1:0:", -- Tainted Arcane Sliver
	[20490]="::12:1:1:::1:0:", -- Ironforge Mint
	[20491]="::12:1:1:::1:0:", -- Undercity Mint
	[20492]="::12:1:1:::1:0:", -- Stormwind Nougat
	[20493]="::12:1:1:::1:0:", -- Orgrimmar Nougat
	[20494]="::12:1:1:::1:0:", -- Gnomeregan Gumdrop
	[20495]="::12:1:1:::1:0:", -- Darkspear Gumdrop
	[20496]="::12:1:1:::1:0:", -- Darnassus Marzipan
	[20497]="::12:1:1:::1:0:", -- Thunder Bluff Marzipan
	[20498]=":1000:7:1:20::165:1:0:", -- Silithid Chitin
	[20499]=":500:15:0:20:::1:0:", -- Broken Silithid Chitin
	[20500]=":2000:7:1:20::165:1:0:", -- Light Silithid Carapace
	[20501]=":2000:7:1:20::165:1:0:", -- Heavy Silithid Carapace
	[20503]=":10000:4:3:1:::1:0:", -- Enamored Water Spirit
	[20504]=":37873:2:3:1:::1:0:", -- Lightforged Blade
	[20505]=":15457:4:3:1:::1:0:", -- Chivalrous Signet
	[20506]="40000:10000:9:1:1:::1:0:15293", -- Pattern: Spitfire Bracers
	[20507]="40000:10000:9:1:1:::1:0:15293", -- Pattern: Spitfire Gauntlets
	[20508]="40000:10000:9:1:1:::1:0:15293", -- Pattern: Spitfire Breastplate
	[20509]="40000:10000:9:1:1:::1:0:15293", -- Pattern: Sandstalker Bracers
	[20510]="40000:10000:9:1:1:::1:0:15293", -- Pattern: Sandstalker Gauntlets
	[20511]="40000:10000:9:1:1:::1:0:15293", -- Pattern: Sandstalker Breastplate
	[20512]=":10000:4:3:1:::1:0:", -- Sanctified Orb
	[20513]="::12:2:20:::1:0:", -- Abyssal Crest
	[20514]="::12:3:20:::1:0:", -- Abyssal Signet
	[20515]="::12:4:20:::1:0:", -- Abyssal Scepter
	[20516]="::0:1:5:::1:0:", -- Bobbing Apple
	[20517]=":17113:4:3:1:::1:0:", -- Razorsteel Shoulders
	[20518]=":500:12:1:20:::1:0:", -- Scroll: Create Crest of Beckoning
	[20519]="::12:1:20:::1:0:", -- Southsea Pirate Hat
	[20520]=":2000:7:2:20::164,197:1:0:", -- Dark Rune
	[20521]=":17358:4:3:1:::1:0:", -- Fury Visor
	[20526]=":500:12:1:20:::1:0:", -- Scroll: Create Crest of Beckoning
	[20527]=":500:12:1:20:::1:0:", -- Scroll: Create Crest of Beckoning
	[20528]=":500:12:1:20:::1:0:", -- Scroll: Create Crest of Beckoning
	[20530]=":12735:4:3:1:::1:0:", -- Robes of Servitude
	[20531]=":750:12:1:20:::1:0:", -- Scroll: Create Signet of Beckoning
	[20532]=":750:12:1:20:::1:0:", -- Scroll: Create Signet of Beckoning
	[20533]=":750:12:1:20:::1:0:", -- Scroll: Create Signet of Beckoning
	[20534]=":3975:4:3:1:::1:0:", -- Abyss Shard
	[20535]=":750:12:1:20:::1:0:", -- Scroll: Create Signet of Beckoning
	[20536]=":40671:2:3:1:::1:0:", -- Soul Harvester
	[20537]=":15963:4:3:1:::1:0:", -- Runed Stygian Boots
	[20538]=":21361:4:3:1:::1:0:", -- Runed Stygian Leggings
	[20539]=":10717:4:3:1:::1:0:", -- Runed Stygian Belt
	[20540]=":1250:12:1:20:::1:0:", -- Scroll: Create Scepter of Beckoning
	[20541]=":500:12:1:20:::1:0:", -- Decoded Twilight Text
	[20542]=":1250:12:1:20:::1:0:", -- Scroll: Create Scepter of Beckoning
	[20543]=":1250:12:1:20:::1:0:", -- Scroll: Create Scepter of Beckoning
	[20544]=":1250:12:1:20:::1:0:", -- Scroll: Create Scepter of Beckoning
	[20545]=":500:12:1:20:::1:0:", -- Decoded Twilight Text
	[20546]=":10000:9:3:1:::1:0:", -- Pattern: Runed Stygian Leggings
	[20547]=":10000:9:3:1:::1:0:", -- Pattern: Runed Stygian Boots
	[20548]=":10000:9:3:1:::1:0:", -- Pattern: Runed Stygian Belt
	[20549]=":18192:4:3:1:::1:0:", -- Darkrune Gauntlets
	[20550]=":36308:4:3:1:::1:0:", -- Darkrune Breastplate
	[20551]=":27279:4:3:1:::1:0:", -- Darkrune Helm
	[20552]=":500:12:1:20:::1:0:", -- Decoded Twilight Text
	[20553]=":15000:9:3:1:::1:0:", -- Plans: Darkrune Gauntlets
	[20554]=":15000:9:3:1:::1:0:", -- Plans: Darkrune Breastplate
	[20555]=":15000:9:3:1:::1:0:", -- Plans: Darkrune Helm
	[20556]=":40667:2:3:1:::1:0:", -- Wildstaff
	[20557]="3500:175:0:1:100:::5:0:15353,15354", -- Hallow\'s End Pumpkin Treat
	[20558]="::12:2:100:::1:0:", -- Warsong Gulch Mark of Honor
	[20559]="::12:2:100:::1:0:", -- Arathi Basin Mark of Honor
	[20560]="::12:2:100:::1:0:", -- Alterac Valley Mark of Honor
	[20561]=":1:4:1:1:::1:0:", -- Flimsy Male Dwarf Mask
	[20562]=":1:4:1:1:::1:0:", -- Flimsy Female Dwarf Mask
	[20563]=":1:4:1:1:::1:0:", -- Flimsy Female Nightelf Mask
	[20564]=":1:4:1:1:::1:0:", -- Flimsy Male Nightelf Mask
	[20565]=":1:4:1:1:::1:0:", -- Flimsy Female Human Mask
	[20566]=":1:4:1:1:::1:0:", -- Flimsy Male Human Mask
	[20567]=":1:4:1:1:::1:0:", -- Flimsy Female Troll Mask
	[20568]=":1:4:1:1:::1:0:", -- Flimsy Male Troll Mask
	[20569]=":1:4:1:1:::1:0:", -- Flimsy Female Orc Mask
	[20570]=":1:4:1:1:::1:0:", -- Flimsy Male Orc Mask
	[20571]=":1:4:1:1:::1:0:", -- Flimsy Female Tauren Mask
	[20572]=":1:4:1:1:::1:0:", -- Flimsy Male Tauren Mask
	[20573]=":1:4:1:1:::1:0:", -- Flimsy Male Undead Mask
	[20574]=":1:4:1:1:::1:0:", -- Flimsy Female Undead Mask
	[20575]=":743:4:2:1:::1:0:", -- Black Whelp Tunic
	[20576]="1400:350:9:1:1:::1:0:777", -- Pattern: Black Whelp Tunic
	[20577]=":72906:2:4:1:::1:0:", -- Nightmare Blade
	[20578]=":73189:2:4:1:::1:0:", -- Emerald Dragonfang
	[20579]=":22041:4:4:1:::1:0:", -- Green Dragonskin Cloak
	[20580]=":73748:2:4:1:::1:0:", -- Hammer of Bestial Fury
	[20581]=":92539:2:4:1:::1:0:", -- Staff of Rampant Growth
	[20582]=":62802:4:4:1:::1:0:", -- Trance Stone
	[20599]=":55093:2:4:1:::1:0:", -- Polished Ironwood Crossbow
	[20600]=":98660:4:4:1:::1:0:", -- Malfurion\'s Signet Ring
	[20601]=":12:15:1:1:::1:0:", -- Sack of Spoils
	[20602]=":12:15:1:1:::1:0:", -- Chest of Spoils
	[20603]=":12:15:1:1:::1:0:", -- Bag of Spoils
	[20604]="500::12:1:1:::1:0:15199", -- Stink Bomb Cleaner
	[20605]="::12:1:1:::1:0:", -- Rotten Eggs
	[20606]="::15:1:10:::1:0:", -- Amber Voodoo Feather
	[20607]="::15:1:10:::1:0:", -- Blue Voodoo Feather
	[20608]="::15:1:10:::1:0:", -- Green Voodoo Feather
	[20610]="::15:1:20:::1:0:", -- Bloodshot Spider Eye
	[20611]="::15:1:20:::1:0:", -- Thick Black Claw
	[20612]="::15:1:10:::1:0:", -- Inert Scourgestone
	[20613]="::15:1:20:::1:0:", -- Rotting Wood
	[20614]="::15:1:20:::1:0:", -- Bloodvenom Essence
	[20615]=":19996:4:4:1:::1:0:", -- Dragonspur Wraps
	[20616]=":28254:4:4:1:::1:0:", -- Dragonbone Wristguards
	[20617]=":44264:4:4:1:::1:0:", -- Ancient Corroded Leggings
	[20618]=":14810:4:4:1:::1:0:", -- Gloves of Delusional Power
	[20619]=":38954:4:4:1:::1:0:", -- Acid Inscribed Greaves
	[20620]="::15:1:5:::1:0:", -- Holy Mightstone
	[20621]=":33455:4:4:1:::1:0:", -- Boots of the Endless Moor
	[20622]=":114103:4:4:1:::1:0:", -- Dragonheart Necklace
	[20623]=":29073:4:4:1:::1:0:", -- Circlet of Restless Dreams
	[20624]=":143303:4:4:1:::1:0:", -- Ring of the Unliving
	[20625]=":15433:4:4:1:::1:0:", -- Belt of the Dark Bog
	[20626]=":15488:4:4:1:::1:0:", -- Black Bark Wristbands
	[20627]=":38863:4:4:1:::1:0:", -- Dark Heart Pants
	[20628]=":29608:4:4:1:::1:0:", -- Deviate Growth Cap
	[20629]=":35813:4:4:1:::1:0:", -- Malignant Footguards
	[20630]=":27991:4:4:1:::1:0:", -- Gauntlets of the Shining Light
	[20631]=":23655:4:4:1:::1:0:", -- Mendicant\'s Slippers
	[20632]=":101281:4:4:1:::1:0:", -- Mindtear Band
	[20633]=":30139:4:4:1:::1:0:", -- Unnatural Leather Spaulders
	[20634]=":30247:4:4:1:::1:0:", -- Boots of Fright
	[20635]=":31990:4:4:1:::1:0:", -- Jade Inlaid Vestments
	[20636]=":89103:4:4:1:::1:0:", -- Hibernation Crystal
	[20637]=":38649:4:4:1:::1:0:", -- Acid Inscribed Pauldrons
	[20638]=":45658:4:4:1:::1:0:", -- Leggings of the Demented Mind
	[20639]=":53469:4:4:1:::1:0:", -- Strangely Glyphed Legplates
	[20640]=":8405:4:2:1:::1:0:", -- Southsea Head Bucket
	[20641]=":4829:4:2:1:::1:0:", -- Southsea Mojo Boots
	[20642]=":7539:4:2:1:::1:0:", -- Antiquated Nobleman\'s Tunic
	[20643]=":7094:4:2:1:::1:0:", -- Undercity Reservist\'s Cap
	[20644]="::12:4:1:::1:0:", -- Nightmare Engulfed Object
	[20645]=":21785:4:2:1:::1:0:", -- Nature\'s Whisper
	[20646]=":35956:2:3:1:::1:0:", -- Sandstrider\'s Mark
	[20647]=":48117:2:3:1:::1:0:", -- Black Crystal Dagger
	[20648]=":52827:2:3:1:::1:0:", -- Cold Forged Hammer
	[20649]=":22425:4:2:1:::1:0:", -- Sunprism Pendant
	[20650]=":14980:4:2:1:::1:0:", -- Desert Wind Gauntlets
	[20652]=":12858:4:2:1:::1:0:", -- Abyssal Cloth Slippers
	[20653]=":15141:4:2:1:::1:0:", -- Abyssal Plate Gauntlets
	[20654]=":60175:2:3:1:::1:0:", -- Amethyst War Staff
	[20655]=":8054:4:2:1:::1:0:", -- Abyssal Cloth Handwraps
	[20656]=":18269:4:2:1:::1:0:", -- Abyssal Mail Sabatons
	[20657]=":48687:2:3:1:::1:0:", -- Crystal Tipped Stiletto
	[20658]=":15272:4:2:1:::1:0:", -- Abyssal Leather Boots
	[20659]=":12263:4:2:1:::1:0:", -- Abyssal Mail Handguards
	[20660]=":61543:2:3:1:::1:0:", -- Stonecutting Glaive
	[20661]=":10295:4:2:1:::1:0:", -- Abyssal Leather Gloves
	[20662]=":21659:4:2:1:::1:0:", -- Abyssal Plate Greaves
	[20663]=":37336:2:3:1:::1:0:", -- Deep Strike Bow
	[20664]=":8909:4:2:1:::1:0:", -- Abyssal Cloth Sash
	[20665]=":25775:4:3:1:::1:0:", -- Abyssal Leather Leggings
	[20666]=":51740:2:3:1:::1:0:", -- Hardened Steel Warhammer
	[20667]=":11258:4:2:1:::1:0:", -- Abyssal Leather Belt
	[20668]=":31268:4:3:1:::1:0:", -- Abyssal Mail Legguards
	[20669]=":65379:2:3:1:::1:0:", -- Darkstone Claymore
	[20670]=":12679:4:2:1:::1:0:", -- Abyssal Mail Clutch
	[20671]=":34239:4:3:1:::1:0:", -- Abyssal Plate Legplates
	[20672]=":36826:2:3:1:::1:0:", -- Sparkling Crystal Wand
	[20673]=":15048:4:2:1:::1:0:", -- Abyssal Plate Girdle
	[20674]=":19792:4:3:1:::1:0:", -- Abyssal Cloth Pants
	[20675]=":49664:2:3:1:::1:0:", -- Soulrender
	[20676]=":500:12:1:20:::1:0:", -- Decoded Twilight Text
	[20677]=":500:12:1:20:::1:0:", -- Decoded Twilight Text
	[20678]=":500:12:1:20:::1:0:", -- Decoded Twilight Text
	[20679]=":500:12:1:20:::1:0:", -- Decoded Twilight Text
	[20680]=":24739:4:3:1:::1:0:", -- Abyssal Mail Pauldrons
	[20681]=":13734:4:3:1:::1:0:", -- Abyssal Leather Bracers
	[20682]=":73553:4:4:1:::1:0:", -- Elemental Focus Band
	[20683]=":28999:4:3:1:::1:0:", -- Abyssal Plate Epaulets
	[20684]=":16664:4:3:1:::1:0:", -- Abyssal Mail Armguards
	[20685]=":61617:4:4:1:::1:0:", -- Wavefront Necklace
	[20686]=":17224:4:3:1:::1:0:", -- Abyssal Cloth Amice
	[20687]=":20282:4:3:1:::1:0:", -- Abyssal Plate Vambraces
	[20688]=":47483:4:4:1:::1:0:", -- Earthen Guard
	[20689]=":21761:4:3:1:::1:0:", -- Abyssal Leather Shoulders
	[20690]=":10538:4:3:1:::1:0:", -- Abyssal Cloth Wristbands
	[20691]=":20361:4:4:1:::1:0:", -- Windshear Cape
	[20692]=":13362:4:2:1:::1:0:", -- Multicolored Band
	[20693]=":11985:4:2:1:::1:0:", -- Weighted Cloak
	[20694]=":17828:4:2:1:::1:0:", -- Glowing Black Orb
	[20695]=":36253:4:3:1:::1:0:", -- Abyssal War Beads
	[20696]=":63158:2:3:1:::1:0:", -- Crystal Spiked Maul
	[20697]=":15213:4:3:1:::1:0:", -- Crystalline Threaded Cape
	[20698]=":67873:2:4:1:::1:0:", -- Elemental Attuned Blade
	[20699]=":35767:4:3:1:::1:0:", -- Cenarion Reservist\'s Legplates
	[20700]=":35901:4:3:1:::1:0:", -- Cenarion Reservist\'s Legplates
	[20701]=":30885:4:3:1:::1:0:", -- Cenarion Reservist\'s Legguards
	[20702]=":31824:4:3:1:::1:0:", -- Cenarion Reservist\'s Legguards
	[20703]=":26616:4:3:1:::1:0:", -- Cenarion Reservist\'s Leggings
	[20704]=":26711:4:3:1:::1:0:", -- Cenarion Reservist\'s Leggings
	[20705]=":21444:4:3:1:::1:0:", -- Cenarion Reservist\'s Pants
	[20706]=":21520:4:3:1:::1:0:", -- Cenarion Reservist\'s Pants
	[20707]=":21597:4:3:1:::1:0:", -- Cenarion Reservist\'s Pants
	[20708]=":2:15:1:1:::1:0:", -- Tightly Sealed Trunk
	[20709]=":50:0:1:10:::1:0:", -- Rumsey Rum Light
	[20710]=":25873:4:3:1:::1:0:", -- Crystal Encrusted Greaves
	[20711]=":25973:4:3:1:::1:0:", -- Crystal Lined Greaves
	[20712]=":14926:4:3:1:::1:0:", -- Wastewalker\'s Gauntlets
	[20713]=":14983:4:3:1:::1:0:", -- Desertstalkers\'s Gauntlets
	[20714]=":18801:4:3:1:::1:0:", -- Sandstorm Boots
	[20715]=":18873:4:3:1:::1:0:", -- Dunestalker\'s Boots
	[20716]=":10103:4:3:1:::1:0:", -- Sandworm Skin Gloves
	[20717]=":10141:4:3:1:::1:0:", -- Desert Bloom Gloves
	[20720]=":54064:2:3:1:::1:0:", -- Dark Whisper Blade
	[20721]=":38790:4:3:1:::1:0:", -- Band of the Cultist
	[20722]=":40843:2:3:1:::1:0:", -- Crystal Slugthrower
	[20723]=":43760:2:2:1:::1:0:", -- Brann\'s Trusty Pick
	[20724]=":54892:2:2:1:::1:0:", -- Corrupted Blackwood Staff
	[20725]="::7:4:20::164,333:1:0:", -- Nexus Crystal
	[20726]=":25000:9:3:1:::1:0:", -- Formula: Enchant Gloves - Threat
	[20727]=":25000:9:3:1:::1:0:", -- Formula: Enchant Gloves - Shadow Power
	[20728]=":25000:9:3:1:::1:0:", -- Formula: Enchant Gloves - Frost Power
	[20729]=":25000:9:3:1:::1:0:", -- Formula: Enchant Gloves - Fire Power
	[20730]=":25000:9:3:1:::1:0:", -- Formula: Enchant Gloves - Healing Power
	[20731]=":25000:9:3:1:::1:0:", -- Formula: Enchant Gloves - Superior Agility
	[20732]="100000:25000:9:1:1:::1:0:15419", -- Formula: Enchant Cloak - Greater Fire Resistance
	[20733]="100000:25000:9:1:1:::1:0:15419", -- Formula: Enchant Cloak - Greater Nature Resistance
	[20734]=":25000:9:3:1:::1:0:", -- Formula: Enchant Cloak - Stealth
	[20735]=":25000:9:3:1:::1:0:", -- Formula: Enchant Cloak - Subtlety
	[20736]=":25000:9:3:1:::1:0:", -- Formula: Enchant Cloak - Dodge
	[20741]="::15:1:1:::1:0:", -- Deadwood Ritual Totem
	[20742]="::15:1:1:::1:0:", -- Winterfall Ritual Totem
	[20743]="::12:1:10:::1:0:", -- Unstable Mana Crystal
	[20744]=":500:0:1:1:::1:0:", -- Minor Wizard Oil
	[20745]=":1000:0:1:1:::1:0:", -- Minor Mana Oil
	[20746]=":1000:0:1:1:::1:0:", -- Lesser Wizard Oil
	[20747]=":1000:0:1:1:::1:0:", -- Lesser Mana Oil
	[20748]=":1000:0:1:1:::1:0:", -- Brilliant Mana Oil
	[20749]=":1000:0:1:1:::1:0:", -- Brilliant Wizard Oil
	[20750]=":1000:0:1:1:::1:0:", -- Wizard Oil
	[20752]="3000:750:9:1:1:::1:0:19663,3346,19537,3012,19234,18773,15419,1318,4228,19540,4617,5158,5757,16635,16722,18753,18951,5758", -- Formula: Minor Mana Oil
	[20753]="4000:1000:9:1:1:::1:0:19663,3346,19537,3012,19234,18773,15419,1318,4228,19540,4617,5158,5757,16635,16722,18753,18951,5758", -- Formula: Lesser Wizard Oil
	[20754]="10000:2500:9:1:1:::1:0:15419", -- Formula: Lesser Mana Oil
	[20755]="20000:5000:9:1:1:::1:0:15419", -- Formula: Wizard Oil
	[20756]="40000:10000:9:1:1:::1:0:14921", -- Formula: Brilliant Wizard Oil
	[20757]="40000:10000:9:1:1:::1:0:14921", -- Formula: Brilliant Mana Oil
	[20758]="500:125:9:1:1:::1:0:19663,3346,19537,3012,19234,18773,15419,1318,4228,19540,4617,5158,5757,16635,16722,18753,18951,5758", -- Formula: Minor Wizard Oil
	[20759]="::12:1:1:::1:0:", -- Otembe\'s Hammer
	[20760]="::12:1:1:::1:0:", -- Chieftain Zul\'Marosh\'s Head
	[20761]="120000:30000:9:1:1:::1:0:12944", -- Recipe: Transmute Elemental Fire
	[20763]=":312:15:0:5:::1:0:", -- Broken Weapon
	[20764]="::12:1:1:::1:0:", -- Prospector Anvilward\'s Head
	[20765]="::12:1:1:::1:0:", -- Incriminating Documents
	[20766]="::15:1:1:::1:0:", -- Slimy Bag
	[20767]="::15:1:1:::1:0:", -- Scum Covered Bag
	[20768]="::15:1:1:::1:0:", -- Oozing Bag
	[20769]=":2500:15:1:1:::1:0:", -- Disgusting Oozeling
	[20770]=":450:15:0:10:::1:0:", -- Bubbling Green Ichor
	[20771]="::12:1:20:::1:0:", -- Tainted Soil Sample
	[20772]="::12:1:20:::1:0:", -- Springpaw Pelt
	[20797]="::12:1:20:::1:0:", -- Lynx Collar
	[20799]="::12:1:1:::1:0:", -- Felendren\'s Head
	[20800]="::12:2:20:::1:0:", -- Cenarion Logistics Badge
	[20801]="::12:2:20:::1:0:", -- Cenarion Tactical Badge
	[20802]="::12:2:20:::1:0:", -- Cenarion Combat Badge
	[20803]="::12:1:1:::1:0:", -- Twilight Battle Orders
	[20804]="::12:1:1:::1:0:", -- Erona\'s Package
	[20805]=":12:15:1:1:::1:0:", -- Followup Logistics Assignment
	[20806]="::12:2:1:::1:0:", -- Logistics Task Briefing X
	[20807]="::12:2:1:::1:0:", -- Logistics Task Briefing I
	[20808]=":12:15:1:1:::1:0:", -- Combat Assignment
	[20809]=":12:15:1:1:::1:0:", -- Tactical Assignment
	[20810]="::12:1:1:::1:0:", -- Signed Field Duty Papers
	[20812]=":5:15:0:10:::1:0:", -- Tattered Pelt
	[20813]=":4:15:0:10:::1:0:", -- Lynx Tooth
	[20815]="800:200:7:1:1:::1:0:3133,19539,16768,16751,4599,372,5514,17486,18774,3358,11186,17512,19538,16224,18751,16664,16262,20981,4256,790,3167,3002,16624,19065,18427,6298,3578,16613", -- Jeweler\'s Kit
	[20816]=":20:7:1:20::202,755:1:0:", -- Delicate Copper Wire
	[20817]=":100:7:1:20::755:1:0:", -- Bronze Setting
	[20818]=":625:4:2:1:::1:0:", -- Elegant Silver Ring
	[20820]=":1064:4:2:1:::1:0:", -- Simple Pearl Ring
	[20821]=":1064:4:2:1:::1:0:", -- Inlaid Malachite Ring
	[20823]=":837:4:2:1:::1:0:", -- Gloom Band
	[20824]="25000:6250:7:1:1:::1:0:3133,19539,16768,16751,4599,372,5514,17486,18774,3358,11186,17512,19538,16224,18751,16664,16262,20981,4256,790,3167,3002,16624,19065,18427,6298,3578,16613", -- Simple Grinder
	[20826]=":2207:4:3:1:::1:0:", -- Heavy Silver Ring
	[20827]=":875:4:2:1:::1:0:", -- Ring of Silver Might
	[20828]=":677:4:2:1:::1:0:", -- Ring of Twilight Shadows
	[20830]=":1535:4:2:1:::1:0:", -- Amulet of the Moon
	[20831]=":1535:4:2:1:::1:0:", -- Heavy Golden Necklace of Battle
	[20832]=":1800:4:3:1:::1:0:", -- Moonsoul Crown
	[20833]=":1540:4:2:1:::1:0:", -- Wicked Moonstone Ring
	[20835]=":25:2:1:1:::1:0:", -- Sunstrider Sword
	[20836]=":25:2:1:1:::1:0:", -- Sunstrider Dagger
	[20837]=":26:2:1:1:::1:0:", -- Sunstrider Axe
	[20838]=":19:2:1:1:::1:0:", -- Sunstrider Bow
	[20839]=":32:2:1:1:::1:0:", -- Sunstrider Staff
	[20840]=":26:2:1:1:::1:0:", -- Sunstrider Mace
	[20841]=":16:4:1:1:::1:0:", -- Sunstrider Shield
	[20842]=":5:15:0:10:::1:0:", -- Frayed Tender Vine
	[20843]=":6:15:0:10:::1:0:", -- Smashed Petal
	[20844]="600:150:0:1:20:::1:0:17078", -- Deadly Poison V
	[20845]=":4:15:0:10:::1:0:", -- Torn Wyrm Scale
	[20846]=":5:15:0:10:::1:0:", -- Faintly Glowing Eye
	[20847]=":6:15:0:10:::1:0:", -- Wraith Fragment
	[20848]=":5:15:0:10:::1:0:", -- Sparkling Dust
	[20849]="84:16:2:1:1:::1:0:15289", -- Arcane Forged Shortsword
	[20850]="84:16:2:1:1:::1:0:15289", -- Arcane Forged Axe
	[20851]="85:17:2:1:1:::1:0:15289", -- Arcane Forged Mace
	[20852]="85:17:2:1:1:::1:0:15289", -- Arcane Forged Dirk
	[20853]="107:21:2:1:1:::1:0:15289", -- Mana Gathering Staff
	[20854]="1800:450:9:1:1:::1:0:16624,17512,4229,4561", -- Design: Amulet of the Moon
	[20855]="1500:375:9:1:1:::1:0:3499,3954", -- Design: Wicked Moonstone Ring
	[20856]="1500:375:9:1:1:::1:0:16624,17512,3367,1286", -- Design: Heavy Golden Necklace of Battle
	[20857]="25:1:0:1:20:::5:0:16920,15287", -- Honey Bread
	[20858]="::12:2:250:::1:0:", -- Stone Scarab
	[20859]="::12:2:250:::1:0:", -- Gold Scarab
	[20860]="::12:2:250:::1:0:", -- Silver Scarab
	[20861]="::12:2:250:::1:0:", -- Bronze Scarab
	[20862]="::12:2:250:::1:0:", -- Crystal Scarab
	[20863]="::12:2:250:::1:0:", -- Clay Scarab
	[20864]="::12:2:250:::1:0:", -- Bone Scarab
	[20865]="::12:2:250:::1:0:", -- Ivory Scarab
	[20866]="::12:3:250:::1:0:", -- Azure Idol
	[20867]="::12:3:250:::1:0:", -- Onyx Idol
	[20868]="::12:3:250:::1:0:", -- Lambent Idol
	[20869]="::12:3:250:::1:0:", -- Amber Idol
	[20870]="::12:3:250:::1:0:", -- Jasper Idol
	[20871]="::12:3:250:::1:0:", -- Obsidian Idol
	[20872]="::12:3:250:::1:0:", -- Vermillion Idol
	[20873]="::12:3:250:::1:0:", -- Alabaster Idol
	[20874]="::12:3:250:::1:0:", -- Idol of the Sun
	[20875]="::12:3:250:::1:0:", -- Idol of Night
	[20876]="::12:3:250:::1:0:", -- Idol of Death
	[20877]="::12:3:250:::1:0:", -- Idol of the Sage
	[20878]="::12:3:250:::1:0:", -- Idol of Rebirth
	[20879]="::12:3:250:::1:0:", -- Idol of Life
	[20881]="::12:3:250:::1:0:", -- Idol of Strife
	[20882]="::12:3:250:::1:0:", -- Idol of War
	[20884]="::12:3:250:::1:0:", -- Qiraji Magisterial Ring
	[20885]="::12:3:250:::1:0:", -- Qiraji Martial Drape
	[20886]="::12:4:250:::1:0:", -- Qiraji Spiked Hilt
	[20888]="::12:3:250:::1:0:", -- Qiraji Ceremonial Ring
	[20889]="::12:3:250:::1:0:", -- Qiraji Regal Drape
	[20890]="::12:4:250:::1:0:", -- Qiraji Ornate Hilt
	[20891]=":1:4:0:1:::1:0:", -- Neophyte\'s Robe
	[20892]=":1:4:0:1:::1:0:", -- Acolyte\'s Robe
	[20893]=":1:4:0:1:::1:0:", -- Apprentice\'s Robe
	[20894]=":1:4:0:1:::1:0:", -- Apprentice\'s Pants
	[20895]=":1:4:1:1:::1:0:", -- Apprentice\'s Boots
	[20896]=":1:4:0:1:::1:0:", -- Lookout\'s Pants
	[20897]=":1:4:0:1:::1:0:", -- Lookout\'s Tunic
	[20898]=":1:4:0:1:::1:0:", -- Lookout\'s Shoes
	[20899]=":1:4:0:1:::1:0:", -- Warder\'s Pants
	[20900]=":1:4:0:1:::1:0:", -- Warder\'s Boots
	[20901]=":1:4:0:1:::1:0:", -- Warder\'s Shirt
	[20906]=":250:4:2:1:::1:0:", -- Braided Copper Ring
	[20907]=":300:4:2:1:::1:0:", -- Solid Bronze Ring
	[20909]=":1010:4:2:1:::1:0:", -- Barbaric Iron Collar
	[20910]="63:12:2:1:1:::1:0:15289", -- Stiff Shortbow
	[20911]="37:7:4:1:1:::1:0:15292", -- Light Guard
	[20912]="84:16:4:1:1:::1:0:15292", -- Large Shield
	[20914]="39:7:4:1:1:::1:0:15292", -- Unadorned Chain Belt
	[20915]="60:12:4:1:1:::1:0:15292", -- Unadorned Chain Boots
	[20916]="36:7:4:1:1:::1:0:15292", -- Unadorned Chain Bracers
	[20917]="36:7:4:1:1:::1:0:15292", -- Unadorned Chain Gloves
	[20918]="72:14:4:1:1:::1:0:15292", -- Unadorned Chain Leggings
	[20919]="73:14:4:1:1:::1:0:15292", -- Unadorned Chain Vest
	[20920]="30:6:4:1:1:::1:0:15291", -- Sun Cured Belt
	[20921]="46:9:4:1:1:::1:0:15291", -- Sun Cured Boots
	[20922]="30:6:4:1:1:::1:0:15291", -- Sun Cured Bracers
	[20923]="30:6:4:1:1:::1:0:15291", -- Sun Cured Gloves
	[20924]="62:12:4:1:1:::1:0:15291", -- Sun Cured Pants
	[20925]="62:12:4:1:1:::1:0:15291", -- Sun Cured Vest
	[20926]="::12:4:250:::1:0:", -- Vek\'nilash\'s Circlet
	[20927]="::12:4:250:::1:0:", -- Ouro\'s Intact Hide
	[20928]="::12:4:250:::1:0:", -- Qiraji Bindings of Command
	[20929]="::12:4:250:::1:0:", -- Carapace of the Old God
	[20930]="::12:4:250:::1:0:", -- Vek\'lor\'s Diadem
	[20931]="::12:4:250:::1:0:", -- Skin of the Great Sandworm
	[20932]="::12:4:250:::1:0:", -- Qiraji Bindings of Dominance
	[20933]="::12:4:250:::1:0:", -- Husk of the Old God
	[20934]="::12:1:20:::1:0:", -- Wraith Essence
	[20935]="::12:1:1:::1:0:", -- Tainted Wraith Essence
	[20938]="::12:1:1:::1:0:", -- Falconwing Square Gift Voucher
	[20939]="::12:2:1:::1:0:", -- Logistics Task Briefing II
	[20940]="::12:2:1:::1:0:", -- Logistics Task Briefing III
	[20941]="::12:2:1:::1:0:", -- Combat Task Briefing XII
	[20942]="::12:2:1:::1:0:", -- Combat Task Briefing III
	[20943]="::12:2:1:::1:0:", -- Tactical Task Briefing X
	[20944]="::12:2:1:::1:0:", -- Tactical Task Briefing IX
	[20945]="::12:2:1:::1:0:", -- Tactical Task Briefing II
	[20947]="::12:2:1:::1:0:", -- Tactical Task Briefing IV
	[20948]="::12:2:1:::1:0:", -- Tactical Task Briefing V
	[20949]="::12:1:1:::1:0:", -- Magical Ledger
	[20950]=":1535:4:2:1:::1:0:", -- Pendant of the Agate Shield
	[20951]="::12:1:1:::1:0:", -- Narain\'s Scrying Goggles
	[20954]=":5681:2:2:1:::1:0:", -- Heavy Iron Knuckles
	[20955]=":665:4:2:1:::1:0:", -- Golden Dragon Ring
	[20958]=":1130:4:2:1:::1:0:", -- Blazing Citrine Ring
	[20959]=":1720:4:2:1:::1:0:", -- The Jade Eye
	[20960]=":1720:4:2:1:::1:0:", -- Engraved Truesilver Ring
	[20961]=":1720:4:2:1:::1:0:", -- Citrine Ring of Rapid Healing
	[20963]=":900:7:1:20::755:1:0:", -- Mithril Filigree
	[20964]=":6646:4:3:1:::1:0:", -- Aquamarine Signet
	[20966]=":3482:4:2:1:::1:0:", -- Jade Pendant of Blasting
	[20967]=":3482:4:2:1:::1:0:", -- Citrine Pendant of Golden Healing
	[20969]=":5989:4:3:1:::1:0:", -- Ruby Crown of Restoration
	[20970]="1500:375:9:1:1:::1:0:1448,4877", -- Design: Pendant of the Agate Shield
	[20971]="1500:375:9:1:1:::1:0:2381,2393", -- Design: Heavy Iron Knuckles
	[20973]="2000:500:9:1:1:::1:0:2381,9636", -- Design: Blazing Citrine Ring
	[20974]=":625:9:2:1:::1:0:", -- Design: Jade Pendant of Blasting
	[20975]="2500:625:9:1:1:::1:0:16624,4775,5163,17512", -- Design: The Jade Eye
	[20976]="::9:2:1:::1:0:", -- Design: Citrine Pendant of Golden Healing
	[20980]=":5:2:1:1:::1:0:", -- Warder\'s Shortbow
	[20981]=":7:2:1:1:::1:0:", -- Neophyte\'s Mace
	[20982]=":7:2:1:1:::1:0:", -- Sharp Dagger
	[20983]=":7:2:1:1:::1:0:", -- Acolyte\'s Dagger
	[20985]="38:7:4:1:1:::1:0:15291", -- Light Cloth Shoes
	[20986]="51:10:4:1:1:::1:0:15291", -- Light Cloth Pants
	[20987]="25:5:4:1:1:::1:0:15291", -- Light Cloth Gloves
	[20988]="25:5:4:1:1:::1:0:15291", -- Light Cloth Bracers
	[20989]="25:5:4:1:1:::1:0:15291", -- Light Cloth Belt
	[20990]="52:10:4:1:1:::1:0:15291", -- Light Cloth Armor
	[20991]=":7:4:1:1:::1:0:", -- Daylight Cloak
	[20992]=":4:4:1:1:::1:0:", -- Sunrise Bracers
	[20993]=":6:4:1:1:::1:0:", -- Lynxskin Gloves
	[20994]=":14:4:1:1:::1:0:", -- Green Chain Vest
	[20995]=":4:4:1:1:::1:0:", -- Well Watcher Gloves
	[20996]=":6:4:1:1:::1:0:", -- Sunspire Cord
	[20997]=":11:4:1:1:::1:0:", -- Green Chain Boots
	[20998]=":4:4:1:1:::1:0:", -- Wyrm Sash
	[20999]=":7:4:1:1:::1:0:", -- Green Chain Gauntlets
	[21000]=":6:4:1:1:::1:0:", -- Vigorous Bracers
	[21001]=":10:4:1:1:::1:0:", -- Striding Pants
	[21002]=":1:4:0:1:::1:0:", -- Unkempt Belt
	[21003]=":3:4:0:1:::1:0:", -- Unkempt Bracers
	[21004]=":5:4:0:1:::1:0:", -- Unkempt Cloak
	[21005]=":1:4:0:1:::1:0:", -- Unkempt Gloves
	[21006]=":2:4:0:1:::1:0:", -- Unkempt Pants
	[21007]=":4:4:0:1:::1:0:", -- Unkempt Robe
	[21008]=":3:4:0:1:::1:0:", -- Unkempt Shoes
	[21009]=":4:4:0:1:::1:0:", -- Scraggy Leather Belt
	[21010]=":2:4:0:1:::1:0:", -- Scraggy Leather Boots
	[21011]=":2:4:0:1:::1:0:", -- Scraggy Leather Bracers
	[21012]=":2:4:0:1:::1:0:", -- Scraggy Leather Gloves
	[21013]=":2:4:0:1:::1:0:", -- Scraggy Leather Pants
	[21014]=":8:4:0:1:::1:0:", -- Scraggy Leather Vest
	[21015]=":1:4:0:1:::1:0:", -- Shoddy Chain Belt
	[21016]=":9:4:0:1:::1:0:", -- Shoddy Chain Vest
	[21017]=":2:4:0:1:::1:0:", -- Shoddy Chain Pants
	[21018]=":3:4:0:1:::1:0:", -- Shoddy Chain Gloves
	[21019]=":3:4:0:1:::1:0:", -- Shoddy Chain Bracers
	[21020]=":3:4:0:1:::1:0:", -- Shoddy Chain Boots
	[21021]=":7:4:0:1:::1:0:", -- Battered Shield
	[21022]=":3:4:0:1:::1:0:", -- Weather Beaten Buckler
	[21023]=":250:0:1:20:::1:0:", -- Dirge\'s Kickin\' Chimaerok Chops
	[21024]="::7:1:20::185:1:0:", -- Chimaerok Tenderloin
	[21025]=":1250:9:4:1:::1:0:", -- Recipe: Dirge\'s Kickin\' Chimaerok Chops
	[21027]="::12:1:1:::1:0:", -- Lakmaeran\'s Carcass
	[21028]="::12:1:1:::1:0:", -- 500 Pound Chicken
	[21029]="::12:1:1:::1:0:", -- Ransom Letter
	[21030]="2000:100:0:1:20:::5:0:6091,4266,12026,4191,7941,2303,12019,3961,4167,4181,4195", -- Darnassus Kimchi Pie
	[21031]="4000:200:0:1:20:::5:0:6091,4266,12026,4191,7941,2303,12019,3961,4167,4181,4195", -- Cabbage Kimchi
	[21032]="::12:1:1:::1:0:", -- Meridith\'s Love Letter
	[21033]="4000:200:0:1:20:::5:0:6091,4266,12026,4191,7941,2303,12019,3961,4167,4181,4195", -- Radish Kimchi
	[21037]="::15:1:1:::1:0:", -- Crude Map
	[21039]=":1:4:1:1:::1:0:", -- Narain\'s Turban
	[21040]=":1:4:1:1:::1:0:", -- Narain\'s Robe
	[21041]="::12:1:1:::1:0:", -- Bag of Gold
	[21042]="::15:1:1:::1:0:", -- Narain\'s Special Kit
	[21071]=":25:7:1:20::185:1:0:", -- Raw Sagefish
	[21072]=":40:0:1:20:::1:0:", -- Smoked Sagefish
	[21099]="500:125:9:1:1:::1:0:8307,3027,16718,17246,5483,19195,12033,5160,2664,4223,4265,2397,3085,16677,16253,3400,2381,14738,4553", -- Recipe: Smoked Sagefish
	[21100]="::12:1:100:::1:0:", -- Coin of Ancestry
	[21103]="::15:1:1:::1:0:", -- Draconic for Dummies
	[21104]="::15:1:1:::1:0:", -- Draconic for Dummies
	[21105]="::15:1:1:::1:0:", -- Draconic for Dummies
	[21106]="::15:1:1:::1:0:", -- Draconic for Dummies
	[21107]="::15:1:1:::1:0:", -- Draconic for Dummies
	[21108]="::15:1:1:::1:0:", -- Draconic for Dummies
	[21109]="::15:1:1:::1:0:", -- Draconic for Dummies
	[21110]="::15:1:1:::1:0:", -- Draconic for Dummies
	[21111]="::12:1:1:::1:0:", -- Draconic For Dummies: Volume II
	[21112]="::12:1:1:::1:0:", -- Magical Book Binding
	[21113]=":2:15:1:1:::1:0:", -- Watertight Trunk
	[21114]=":50:0:1:10:::1:0:", -- Rumsey Rum Dark
	[21115]="::4:3:1:::1:0:15126", -- Defiler\'s Talisman
	[21116]="::4:3:1:::1:0:15126", -- Defiler\'s Talisman
	[21117]="::4:3:1:::1:0:15127", -- Talisman of Arathor
	[21118]="::4:3:1:::1:0:15127", -- Talisman of Arathor
	[21119]="::4:3:1:::1:0:15127", -- Talisman of Arathor
	[21120]="::4:3:1:::1:0:15126", -- Defiler\'s Talisman
	[21126]=":85698:2:4:1:::1:0:", -- Death\'s Sting
	[21128]=":97775:2:4:1:::1:0:", -- Staff of the Qiraji Prophets
	[21130]="::15:1:1:::1:0:", -- Diary of Weavil
	[21131]=":12:15:1:1:::1:0:", -- Followup Combat Assignment
	[21132]=":12:15:1:1:::1:0:", -- Logistics Assignment
	[21133]=":12:15:1:1:::1:0:", -- Followup Tactical Assignment
	[21134]=":110377:2:4:1:::1:0:", -- Dark Edge of Insanity
	[21136]="::12:1:1:::1:0:", -- Arcanite Buoy
	[21137]="::12:1:1:::1:0:", -- Blue Scepter Shard
	[21138]="::12:1:1:::1:0:", -- Red Scepter Shard
	[21139]="::12:1:1:::1:0:", -- Green Scepter Shard
	[21142]="::15:1:1:::1:0:", -- From the Desk of Lord Victor Nefarius
	[21143]="::12:1:1:::1:0:", -- Unsigned Field Duty Papers
	[21144]="::12:1:1:::1:0:", -- Demon Summoning Torch
	[21145]="::12:1:1:::1:0:", -- Essence of Xandivious
	[21146]="::12:1:1:::1:0:", -- Fragment of the Nightmare\'s Corruption
	[21147]="::12:1:1:::1:0:", -- Fragment of the Nightmare\'s Corruption
	[21148]="::12:1:1:::1:0:", -- Fragment of the Nightmare\'s Corruption
	[21149]="::12:1:1:::1:0:", -- Fragment of the Nightmare\'s Corruption
	[21150]=":2:15:1:1:::1:0:", -- Iron Bound Trunk
	[21151]="200:50:0:1:10:::1:0:20377", -- Rumsey Rum Black Label
	[21153]=":125:7:1:20::185:1:0:", -- Raw Greater Sagefish
	[21154]=":1:4:1:1:::1:0:", -- Festival Dress
	[21155]="::12:1:1:::1:0:", -- Timbermaw Offering of Peace
	[21156]=":12:15:1:1:::1:0:", -- Scarab Bag
	[21157]=":1:4:1:1:::1:0:", -- Festive Green Dress
	[21158]="::12:1:1:::1:0:", -- Hive\'Zora Scout Report
	[21160]="::12:1:1:::1:0:", -- Hive\'Regal Scout Report
	[21161]="::12:1:1:::1:0:", -- Hive\'Ashi Scout Report
	[21162]=":25:15:1:1:::1:0:", -- Bloated Oily Blackmouth
	[21164]=":100:15:1:1:::1:0:", -- Bloated Rockscale Cod
	[21165]="::12:2:1:::1:0:", -- Tactical Task Briefing VI
	[21166]="::12:2:1:::1:0:", -- Tactical Task Briefing VII
	[21167]="::12:2:1:::1:0:", -- Tactical Task Briefing VIII
	[21171]="::15:1:1:::1:0:", -- Filled Festive Mug
	[21174]="::15:1:1:::1:0:", -- Empty Festive Mug
	[21175]="::15:1:1:::1:0:", -- The Scepter of the Shifting Sands
	[21176]="::15:5:1:::1:0:", -- Black Qiraji Resonating Crystal
	[21177]="3000:37:15:1:100::-2:20:0:26744,4878,26751,24843,20915,4220,26758,26765,19235,5139,16588,3323,16612,8361,1308,4083,983,3700,25039,19679,26754,26752,23373,18017,26743,25010,16757,3500,5151,3970,12097,1463,25633,18019,25082,26756,20092,26759,17518,16611,2805,18243,3335,3562,15175,1275,18006,19014,4562,3542,26747,26741,26739,4575,16829,1307,14739,23405,26753,26742,25051,26748,958,3490,20081,13476,3351,19004,18998,17078,23157,1673,1351,19013,24995,26745,26757,23112,1257,10364,19535,23560,22479,26724,23145,26749,26304,12096,16015,5110,26755,26738,23151,16706,18802,24935,19718,26740,19678,25019", -- Symbol of Kings
	[21178]=":13268:4:3:1:::1:0:", -- Gloves of Earthen Power
	[21179]=":10709:4:3:1:::1:0:", -- Band of Earthen Wrath
	[21180]=":21612:4:4:1:::1:0:", -- Earthstrike
	[21181]=":21612:4:3:1:::1:0:", -- Grace of Earth
	[21182]=":10709:4:3:1:::1:0:", -- Band of Earthen Might
	[21183]=":20620:4:3:1:::1:0:", -- Earthpower Vest
	[21184]=":23671:4:4:1:::1:0:", -- Deeprock Bracers
	[21185]=":10452:4:4:1:::1:0:", -- Earthcalm Orb
	[21186]=":13550:4:4:1:::1:0:", -- Rockfury Bracers
	[21187]=":15299:4:3:1:::1:0:", -- Earthweave Cloak
	[21188]=":89953:2:4:1:::1:0:", -- Fist of Cenarius
	[21189]=":188888:4:4:1:::1:0:", -- Might of Cenarius
	[21190]=":188888:4:4:1:::1:0:", -- Wrath of Cenarius
	[21191]="::15:1:1:::1:0:", -- Carefully Wrapped Present
	[21196]="::4:4:1:::1:0:", -- Signet Ring of the Bronze Dragonflight
	[21197]="::4:4:1:::1:0:", -- Signet Ring of the Bronze Dragonflight
	[21198]="::4:4:1:::1:0:", -- Signet Ring of the Bronze Dragonflight
	[21199]="::4:4:1:::1:0:", -- Signet Ring of the Bronze Dragonflight
	[21200]="::4:4:1:::1:0:", -- Signet Ring of the Bronze Dragonflight
	[21201]="::4:4:1:::1:0:", -- Signet Ring of the Bronze Dragonflight
	[21202]="::4:4:1:::1:0:", -- Signet Ring of the Bronze Dragonflight
	[21203]="::4:4:1:::1:0:", -- Signet Ring of the Bronze Dragonflight
	[21204]="::4:4:1:::1:0:", -- Signet Ring of the Bronze Dragonflight
	[21205]="::4:4:1:::1:0:", -- Signet Ring of the Bronze Dragonflight
	[21206]="::4:4:1:::1:0:", -- Signet Ring of the Bronze Dragonflight
	[21207]="::4:4:1:::1:0:", -- Signet Ring of the Bronze Dragonflight
	[21208]="::4:4:1:::1:0:", -- Signet Ring of the Bronze Dragonflight
	[21209]="::4:4:1:::1:0:", -- Signet Ring of the Bronze Dragonflight
	[21210]="::4:4:1:::1:0:", -- Signet Ring of the Bronze Dragonflight
	[21211]="::12:1:1:::1:0:", -- Pouch of Reindeer Dust
	[21212]="::0:1:20:::1:0:", -- Fresh Holly
	[21213]="::15:2:20:::1:0:", -- Preserved Holly
	[21214]=":100000:9:3:1:::1:0:", -- Tome of Frostbolt XI
	[21215]="::0:1:20:::1:0:", -- Graccu\'s Mince Meat Fruitcake
	[21216]="::15:1:1:::1:0:", -- Smokywood Pastures Extra-Special Gift
	[21217]=":125:0:1:20:::1:0:", -- Sagefish Delight
	[21218]="::15:3:1:::1:0:", -- Blue Qiraji Resonating Crystal
	[21219]="5000:1250:9:1:1:::1:0:8307,3027,16718,17246,5483,19195,12033,5160,2664,4223,4265,2397,3085,16677,16253,3400,2381,14738,4553", -- Recipe: Sagefish Delight
	[21220]="::12:4:1:::1:0:", -- Head of Ossirian the Unscarred
	[21221]="::12:4:1:::1:0:", -- Eye of C\'Thun
	[21222]=":1750:15:0:10:::1:0:", -- Armored Chitin
	[21223]=":1500:15:0:10:::1:0:", -- Black Stone
	[21224]=":3000:15:0:10:::1:0:", -- Ancient Armor Fragment
	[21225]=":2500:15:0:10:::1:0:", -- Heavy Silithid Husk
	[21226]=":4000:15:0:10:::1:0:", -- Runic Stone
	[21227]=":7500:15:0:10:::1:0:", -- Ancient Hero\'s Skull
	[21228]=":2:15:1:1:::1:0:", -- Mithril Bound Trunk
	[21229]="::15:1:50:::1:0:", -- Qiraji Lord\'s Insignia
	[21230]="::15:1:1:::1:0:", -- Ancient Qiraji Artifact
	[21232]="::15:4:1:::1:0:", -- Imperial Qiraji Armaments
	[21235]="::0:1:20:::1:0:", -- Winter Veil Roast
	[21237]="::15:4:1:::1:0:", -- Imperial Qiraji Regalia
	[21241]="::0:1:20:::1:0:", -- Winter Veil Eggnog
	[21242]=":82145:2:4:1:::1:0:", -- Blessed Qiraji War Axe
	[21243]=":100:15:1:1:::1:0:", -- Bloated Mightfish
	[21244]=":82758:2:4:1:::1:0:", -- Blessed Qiraji Pugio
	[21245]="::12:2:1:::1:0:", -- Tactical Task Briefing I
	[21248]="::12:2:1:::1:0:", -- Combat Task Briefing IV
	[21249]="::12:2:1:::1:0:", -- Combat Task Briefing V
	[21250]="::12:2:1:::1:0:", -- Combat Task Briefing VI
	[21251]="::12:2:1:::1:0:", -- Combat Task Briefing VII
	[21252]="::12:2:1:::1:0:", -- Combat Task Briefing VIII
	[21253]="::12:2:1:::1:0:", -- Combat Task Briefing IX
	[21254]="::0:1:5:::1:0:", -- Winter Veil Cookie
	[21255]="::12:2:1:::1:0:", -- Combat Task Briefing X
	[21256]="::12:2:1:::1:0:", -- Combat Task Briefing XI
	[21257]="::12:2:1:::1:0:", -- Logistics Task Briefing IV
	[21258]="::12:2:1:::1:0:", -- Logistics Task Briefing IV
	[21259]="::12:2:1:::1:0:", -- Logistics Task Briefing V
	[21260]="::12:2:1:::1:0:", -- Logistics Task Briefing VI
	[21261]="::12:2:1:::1:0:", -- Logistics Task Briefing VI
	[21262]="::12:2:1:::1:0:", -- Logistics Task Briefing VIII
	[21263]="::12:2:1:::1:0:", -- Logistics Task Briefing VII
	[21264]="::12:2:1:::1:0:", -- Logistics Task Briefing VII
	[21265]="::12:2:1:::1:0:", -- Logistics Task Briefing IX
	[21266]=":12:15:1:1:::1:0:", -- Logistics Assignment
	[21267]="::15:1:1:::1:0:", -- Toasting Goblet
	[21268]=":86208:2:4:1:::1:0:", -- Blessed Qiraji War Hammer
	[21269]=":55371:4:4:1:::1:0:", -- Blessed Qiraji Bulwark
	[21270]="::15:1:1:::1:0:", -- Gently Shaken Gift
	[21271]="::15:1:1:::1:0:", -- Gently Shaken Gift
	[21272]=":65581:2:4:1:::1:0:", -- Blessed Qiraji Musket
	[21273]=":109680:2:4:1:::1:0:", -- Blessed Qiraji Acolyte Staff
	[21275]=":99954:2:4:1:::1:0:", -- Blessed Qiraji Augur Staff
	[21277]=":1250:15:1:1:::1:0:", -- Tranquil Mechanical Yeti
	[21278]=":9126:4:3:1:::1:0:", -- Stormshroud Gloves
	[21279]=":100000:9:3:1:::1:0:", -- Tome of Fireball XII
	[21280]=":100000:9:3:1:::1:0:", -- Tome of Arcane Missiles VIII
	[21281]=":100000:9:3:1:::1:0:", -- Grimoire of Shadow Bolt X
	[21282]=":100000:9:3:1:::1:0:", -- Grimoire of Immolate VIII
	[21283]=":100000:9:3:1:::1:0:", -- Grimoire of Corruption VII
	[21284]=":100000:9:3:1:::1:0:", -- Codex of Greater Heal V
	[21285]=":100000:9:3:1:::1:0:", -- Codex of Renew X
	[21287]=":100000:9:3:1:::1:0:", -- Codex of Prayer of Healing V
	[21288]=":100000:9:3:1:::1:0:", -- Libram: Blessing of Wisdom VI
	[21289]=":100000:9:3:1:::1:0:", -- Libram: Blessing of Might VII
	[21290]=":100000:9:3:1:::1:0:", -- Libram: Holy Light IX
	[21291]=":100000:9:3:1:::1:0:", -- Tablet of Healing Wave X
	[21292]=":100000:15:3:1:::1:0:", -- Tablet of Strength of Earth Totem V
	[21293]=":100000:15:3:1:::1:0:", -- Tablet of Grace of Air Totem III
	[21294]=":100000:9:3:1:::1:0:", -- Book of Healing Touch XI
	[21295]=":100000:9:3:1:::1:0:", -- Book of Starfire VII
	[21296]=":100000:9:3:1:::1:0:", -- Book of Rejuvenation XI
	[21297]=":100000:9:3:1:::1:0:", -- Manual of Heroic Strike IX
	[21298]=":100000:9:3:1:::1:0:", -- Manual of Battle Shout VII
	[21299]=":100000:9:3:1:::1:0:", -- Manual of Revenge VI
	[21300]=":100000:9:3:1:::1:0:", -- Handbook of Backstab IX
	[21301]="::15:1:1:::1:0:", -- Green Helper Box
	[21302]=":100000:9:3:1:::1:0:", -- Handbook of Deadly Poison V
	[21303]=":100000:9:3:1:::1:0:", -- Handbook of Feint V
	[21304]=":100000:9:3:1:::1:0:", -- Guide: Multi-Shot V
	[21305]="::15:1:1:::1:0:", -- Red Helper Box
	[21306]=":100000:9:3:1:::1:0:", -- Guide: Serpent Sting IX
	[21307]=":100000:9:3:1:::1:0:", -- Guide: Aspect of the Hawk VII
	[21308]="::15:1:1:::1:0:", -- Jingling Bell
	[21309]="::15:1:1:::1:0:", -- Snowman Kit
	[21310]="::15:1:1:::1:0:", -- Gaily Wrapped Present
	[21311]=":8473:4:2:1:::1:0:", -- Earth Warder\'s Vest
	[21312]=":6377:4:2:1:::1:0:", -- Belt of the Den Watcher
	[21314]="::15:1:1:::1:0:", -- Metzen\'s Letters and Notes
	[21315]="::15:1:1:::1:0:", -- Smokywood Satchel
	[21316]=":21713:4:2:1:::1:0:", -- Leggings of the Ursa
	[21317]=":11675:4:2:1:::1:0:", -- Helm of the Pathfinder
	[21318]=":7444:4:2:1:::1:0:", -- Earth Warder\'s Gloves
	[21319]=":9339:4:2:1:::1:0:", -- Gloves of the Pathfinder
	[21320]=":22497:4:2:1:::1:0:", -- Vest of the Den Watcher
	[21321]="::15:3:1:::1:0:", -- Red Qiraji Resonating Crystal
	[21322]=":26439:4:2:1:::1:0:", -- Ursa\'s Embrace
	[21323]="::15:3:1:::1:0:", -- Green Qiraji Resonating Crystal
	[21324]="::15:3:1:::1:0:", -- Yellow Qiraji Resonating Crystal
	[21325]="::15:2:1:::1:0:", -- Mechanical Greench
	[21326]=":8991:4:4:1:::1:0:", -- Defender of the Timbermaw
	[21327]="::15:1:1:::1:0:", -- Ticking Present
	[21328]="::15:1:1:::1:0:", -- Wand of Holiday Cheer
	[21329]=":43010:4:4:1:::1:0:", -- Conqueror\'s Crown
	[21330]=":41773:4:4:1:::1:0:", -- Conqueror\'s Spaulders
	[21331]=":62274:4:4:1:::1:0:", -- Conqueror\'s Breastplate
	[21332]=":58117:4:4:1:::1:0:", -- Conqueror\'s Legguards
	[21333]=":42255:4:4:1:::1:0:", -- Conqueror\'s Greaves
	[21334]=":35991:4:4:1:::1:0:", -- Doomcaller\'s Robes
	[21335]=":24374:4:4:1:::1:0:", -- Doomcaller\'s Mantle
	[21336]=":33714:4:4:1:::1:0:", -- Doomcaller\'s Trousers
	[21337]=":25378:4:4:1:::1:0:", -- Doomcaller\'s Circlet
	[21338]=":24648:4:4:1:::1:0:", -- Doomcaller\'s Footwraps
	[21340]=":5000:1:2:1:::1:0:", -- Soul Pouch
	[21341]=":20000:1:3:1:::1:0:", -- Felcloth Bag
	[21342]=":80000:1:4:1:::1:0:", -- Core Felcloth Bag
	[21343]=":37212:4:4:1:::1:0:", -- Enigma Robes
	[21344]=":25198:4:4:1:::1:0:", -- Enigma Boots
	[21345]=":25947:4:4:1:::1:0:", -- Enigma Shoulderpads
	[21346]=":35883:4:4:1:::1:0:", -- Enigma Leggings
	[21347]=":27007:4:4:1:::1:0:", -- Enigma Circlet
	[21348]=":24526:4:4:1:::1:0:", -- Tiara of the Oracle
	[21349]=":23821:4:4:1:::1:0:", -- Footwraps of the Oracle
	[21350]=":23913:4:4:1:::1:0:", -- Mantle of the Oracle
	[21351]=":35581:4:4:1:::1:0:", -- Vestments of the Oracle
	[21352]=":33203:4:4:1:::1:0:", -- Trousers of the Oracle
	[21353]=":31246:4:4:1:::1:0:", -- Genesis Helm
	[21354]=":30349:4:4:1:::1:0:", -- Genesis Shoulderpads
	[21355]=":30464:4:4:1:::1:0:", -- Genesis Boots
	[21356]=":42134:4:4:1:::1:0:", -- Genesis Trousers
	[21357]=":45491:4:4:1:::1:0:", -- Genesis Vest
	[21358]="12000:3000:9:1:1:::1:0:6568", -- Pattern: Soul Pouch
	[21359]=":30922:4:4:1:::1:0:", -- Deathdealer\'s Boots
	[21360]=":32073:4:4:1:::1:0:", -- Deathdealer\'s Helm
	[21361]=":31974:4:4:1:::1:0:", -- Deathdealer\'s Spaulders
	[21362]=":44219:4:4:1:::1:0:", -- Deathdealer\'s Leggings
	[21363]="::15:1:1:::1:0:", -- Festive Gift
	[21364]=":47900:4:4:1:::1:0:", -- Deathdealer\'s Vest
	[21365]=":39091:4:4:1:::1:0:", -- Striker\'s Footguards
	[21366]=":40364:4:4:1:::1:0:", -- Striker\'s Diadem
	[21367]=":40683:4:4:1:::1:0:", -- Striker\'s Pauldrons
	[21368]=":49042:4:4:1:::1:0:", -- Striker\'s Leggings
	[21370]=":53161:4:4:1:::1:0:", -- Striker\'s Hauberk
	[21371]=":20000:9:3:1:::1:0:", -- Pattern: Core Felcloth Bag
	[21372]=":37349:4:4:1:::1:0:", -- Stormcaller\'s Diadem
	[21373]=":36438:4:4:1:::1:0:", -- Stormcaller\'s Footguards
	[21374]=":53975:4:4:1:::1:0:", -- Stormcaller\'s Hauberk
	[21375]=":50365:4:4:1:::1:0:", -- Stormcaller\'s Leggings
	[21376]=":36851:4:4:1:::1:0:", -- Stormcaller\'s Pauldrons
	[21377]=":200:12:1:250:::1:0:", -- Deadwood Headdress Feather
	[21378]="::12:2:1:::1:0:", -- Logistics Task Briefing I
	[21379]="::12:2:1:::1:0:", -- Logistics Task Briefing II
	[21380]="::12:2:1:::1:0:", -- Logistics Task Briefing III
	[21381]="::12:2:1:::1:0:", -- Logistics Task Briefing IX
	[21382]="::12:2:1:::1:0:", -- Logistics Task Briefing V
	[21383]=":200:12:1:250:::1:0:", -- Winterfall Spirit Beads
	[21384]="::12:2:1:::1:0:", -- Logistics Task Briefing VIII
	[21385]="::12:2:1:::1:0:", -- Logistics Task Briefing X
	[21386]=":12:15:1:1:::1:0:", -- Followup Logistics Assignment
	[21387]=":47159:4:4:1:::1:0:", -- Avenger\'s Crown
	[21388]=":41438:4:4:1:::1:0:", -- Avenger\'s Greaves
	[21389]=":61776:4:4:1:::1:0:", -- Avenger\'s Breastplate
	[21390]=":57649:4:4:1:::1:0:", -- Avenger\'s Legguards
	[21391]=":41916:4:4:1:::1:0:", -- Avenger\'s Pauldrons
	[21392]="::2:4:1:::1:0:", -- Sickle of Unyielding Strength
	[21393]="::4:4:1:::1:0:", -- Signet of Unyielding Strength
	[21394]="::4:4:1:::1:0:", -- Drape of Unyielding Strength
	[21395]="::2:4:1:::1:0:", -- Blade of Eternal Justice
	[21396]="::4:4:1:::1:0:", -- Ring of Eternal Justice
	[21397]="::4:4:1:::1:0:", -- Cape of Eternal Justice
	[21398]="::2:4:1:::1:0:", -- Hammer of the Gathering Storm
	[21399]="::4:4:1:::1:0:", -- Ring of the Gathering Storm
	[21400]="::4:4:1:::1:0:", -- Cloak of the Gathering Storm
	[21401]="::2:4:1:::1:0:", -- Scythe of the Unseen Path
	[21402]="::4:4:1:::1:0:", -- Signet of the Unseen Path
	[21403]="::4:4:1:::1:0:", -- Cloak of the Unseen Path
	[21404]="::2:4:1:::1:0:", -- Dagger of Veiled Shadows
	[21405]="::4:4:1:::1:0:", -- Band of Veiled Shadows
	[21406]="::4:4:1:::1:0:", -- Cloak of Veiled Shadows
	[21407]="::2:4:1:::1:0:", -- Mace of Unending Life
	[21408]="::4:4:1:::1:0:", -- Band of Unending Life
	[21409]="::4:4:1:::1:0:", -- Cloak of Unending Life
	[21410]="::2:4:1:::1:0:", -- Gavel of Infinite Wisdom
	[21411]="::4:4:1:::1:0:", -- Ring of Infinite Wisdom
	[21412]="::4:4:1:::1:0:", -- Shroud of Infinite Wisdom
	[21413]="::2:4:1:::1:0:", -- Blade of Vaulted Secrets
	[21414]="::4:4:1:::1:0:", -- Band of Vaulted Secrets
	[21415]="::4:4:1:::1:0:", -- Drape of Vaulted Secrets
	[21416]="::2:4:1:::1:0:", -- Kris of Unspoken Names
	[21417]="::4:4:1:::1:0:", -- Ring of Unspoken Names
	[21418]="::4:4:1:::1:0:", -- Shroud of Unspoken Names
	[21436]="::15:1:100:::1:0:", -- Alliance Commendation Signet
	[21438]="::15:1:100:::1:0:", -- Horde Commendation Signet
	[21452]=":96177:2:4:1:::1:0:", -- Staff of the Ruins
	[21453]=":40467:4:4:1:::1:0:", -- Mantle of the Horusath
	[21454]=":35033:4:4:1:::1:0:", -- Runic Stone Shoulders
	[21455]=":22403:4:3:1:::1:0:", -- Southwind Helm
	[21456]=":23424:4:4:1:::1:0:", -- Sandstorm Cloak
	[21457]=":27585:4:4:1:::1:0:", -- Bracers of Brutality
	[21458]=":20174:4:4:1:::1:0:", -- Gauntlets of New Life
	[21459]=":60738:2:4:1:::1:0:", -- Crossbow of Imminent Doom
	[21460]=":42586:4:4:1:::1:0:", -- Helm of Domination
	[21461]=":29522:4:4:1:::1:0:", -- Leggings of the Black Blizzard
	[21462]=":14816:4:4:1:::1:0:", -- Gloves of Dark Wisdom
	[21463]=":22311:4:4:1:::1:0:", -- Ossirian\'s Binding
	[21464]=":14931:4:4:1:::1:0:", -- Shackles of the Unscarred
	[21466]=":72521:2:4:1:::1:0:", -- Stinger of Ayamiss
	[21467]=":36399:4:4:1:::1:0:", -- Thick Silithid Chestguard
	[21468]=":17462:4:3:1:::1:0:", -- Mantle of Maz\'Nadir
	[21469]=":14605:4:3:1:::1:0:", -- Gauntlets of Southwind
	[21470]=":17592:4:3:1:::1:0:", -- Cloak of the Savior
	[21471]=":88787:4:4:1:::1:0:", -- Talon of Furious Concentration
	[21472]=":22251:4:4:1:::1:0:", -- Dustwind Turban
	[21473]=":82878:4:3:1:::1:0:", -- Eye of Moam
	[21474]=":22909:4:3:1:::1:0:", -- Chitinous Shoulderguards
	[21475]=":42918:4:3:1:::1:0:", -- Legplates of the Destroyer
	[21476]=":36919:4:3:1:::1:0:", -- Obsidian Scaled Leggings
	[21477]=":88503:4:3:1:::1:0:", -- Ring of Fury
	[21478]=":57620:2:4:1:::1:0:", -- Bow of Taut Sinew
	[21479]=":27139:4:4:1:::1:0:", -- Gauntlets of the Immovable
	[21480]=":18501:4:3:1:::1:0:", -- Scaled Silithid Gauntlets
	[21481]=":29346:4:3:1:::1:0:", -- Boots of the Desert Protector
	[21482]=":25412:4:3:1:::1:0:", -- Boots of the Fiery Sands
	[21483]=":75303:4:3:1:::1:0:", -- Ring of the Desert Winds
	[21484]=":21244:4:3:1:::1:0:", -- Helm of Regrowth
	[21485]=":45658:4:4:1:::1:0:", -- Buru\'s Skull Fragment
	[21486]=":25208:4:4:1:::1:0:", -- Gloves of the Swarm
	[21487]=":21566:4:4:1:::1:0:", -- Slimy Scaled Gauntlets
	[21488]=":67812:4:3:1:::1:0:", -- Fetish of Chitinous Spikes
	[21489]=":17319:4:3:1:::1:0:", -- Quicksand Waders
	[21490]=":31182:4:3:1:::1:0:", -- Slime Kickers
	[21491]=":14931:4:3:1:::1:0:", -- Scaled Bracers of the Gorger
	[21492]=":91625:2:4:1:::1:0:", -- Manslayer of the Qiraji
	[21493]=":27587:4:4:1:::1:0:", -- Boots of the Vanguard
	[21494]=":14736:4:3:1:::1:0:", -- Southwind\'s Grasp
	[21495]=":41405:4:3:1:::1:0:", -- Legplates of the Qiraji Command
	[21496]=":11872:4:3:1:::1:0:", -- Bracers of Qiraji Command
	[21497]=":26928:4:3:1:::1:0:", -- Boots of the Qiraji General
	[21498]=":74888:2:4:1:::1:0:", -- Qiraji Sacrificial Dagger
	[21499]=":30059:4:4:1:::1:0:", -- Vestments of the Shifting Sands
	[21500]=":12041:4:3:1:::1:0:", -- Belt of the Inquisition
	[21501]=":13668:4:3:1:::1:0:", -- Toughened Silithid Hide Gloves
	[21502]=":16466:4:3:1:::1:0:", -- Sand Reaver Wristguards
	[21503]=":19392:4:3:1:::1:0:", -- Belt of the Sand Reaver
	[21504]=":111628:4:4:1:::1:0:", -- Charm of the Shifting Sands
	[21505]=":111628:4:4:1:::1:0:", -- Choker of the Shifting Sands
	[21506]=":111628:4:4:1:::1:0:", -- Pendant of the Shifting Sands
	[21507]=":111628:4:4:1:::1:0:", -- Amulet of the Shifting Sands
	[21508]="::12:2:20:::1:0:", -- Mark of Cenarius
	[21509]="::15:1:1:::1:0:", -- Ahn\'Qiraj War Effort Supplies
	[21510]="::15:1:1:::1:0:", -- Ahn\'Qiraj War Effort Supplies
	[21511]="::15:1:1:::1:0:", -- Ahn\'Qiraj War Effort Supplies
	[21512]="::15:1:1:::1:0:", -- Ahn\'Qiraj War Effort Supplies
	[21513]="::15:1:1:::1:0:", -- Ahn\'Qiraj War Effort Supplies
	[21514]="::12:2:1:::1:0:", -- Logistics Task Briefing XI
	[21515]="::12:2:20:::1:0:", -- Mark of Remulos
	[21517]=":24982:4:4:1:::1:0:", -- Gnomish Turban of Psychic Might
	[21519]="::15:1:20:::1:0:", -- Mistletoe
	[21520]=":85129:2:4:1:::1:0:", -- Ravencrest\'s Legacy
	[21521]=":77306:2:4:1:::1:0:", -- Runesword of the Red
	[21522]=":79748:2:4:1:::1:0:", -- Shadowsong\'s Sorrow
	[21523]=":80049:2:4:1:::1:0:", -- Fang of Korialstrasz
	[21524]=":1:4:2:1:::1:0:", -- Red Winter Hat
	[21525]=":1:4:2:1:::1:0:", -- Green Winter Hat
	[21526]=":828085:4:4:1:::1:0:", -- Band of Icy Depths
	[21527]=":32868:4:4:1:::1:0:", -- Darkwater Robes
	[21528]="::15:2:1:::1:0:", -- Colossal Bag of Loot
	[21529]=":90788:4:4:1:::1:0:", -- Amulet of Shadow Shielding
	[21530]=":49843:4:4:1:::1:0:", -- Onyx Embedded Leggings
	[21531]=":103030:4:4:1:::1:0:", -- Drake Tooth Necklace
	[21532]=":31380:4:4:1:::1:0:", -- Drudge Boots
	[21533]="::12:1:1:::1:0:", -- Colossus of Zora\'s Husk
	[21534]="::12:1:1:::1:0:", -- Colossus of Ashi\'s Husk
	[21535]="::12:1:1:::1:0:", -- Colossus of Regal\'s Husk
	[21536]="::15:1:20:::1:0:", -- Elune Stone
	[21537]="::0:1:20:::1:0:", -- Festival Dumplings
	[21538]=":1:4:1:1:::1:0:", -- Festive Pink Dress
	[21539]=":1:4:1:1:::1:0:", -- Festive Purple Dress
	[21540]="::15:2:1:::1:0:", -- Elune\'s Lantern
	[21541]=":1:4:1:1:::1:0:", -- Festive Black Pant Suit
	[21542]=":1:4:1:1:::1:0:", -- Festival Suit
	[21543]=":1:4:1:1:::1:0:", -- Festive Teal Pant Suit
	[21544]=":1:4:1:1:::1:0:", -- Festive Blue Pant Suit
	[21545]="::12:1:1:::1:0:", -- Smokywood Supplies
	[21546]=":35:0:1:20:::1:0:", -- Elixir of Greater Firepower
	[21547]=":2500:9:2:1:::1:0:", -- Recipe: Elixir of Greater Firepower
	[21548]=":15000:9:3:1:::1:0:", -- Pattern: Stormshroud Gloves
	[21552]="2000:5:0:1:20:::5:0:25089,11187,24993,1678,14731,8137,5814,10367,6738,3497,7943,4305,23896,16618,25012,12962,17553,4255,6727,8931,4307,6807,2842,25020,4200,3086,3540,19045,6791,3178,17656,16739,24834,1684,4221,25052", -- Striped Yellowtail
	[21557]="25:6:15:1:20:::1:0:15898", -- Small Red Rocket
	[21558]="25:6:15:1:20:::1:0:15898", -- Small Blue Rocket
	[21559]="25:6:15:1:20:::1:0:15898", -- Small Green Rocket
	[21561]="25:6:15:1:20:::1:0:15898", -- Small White Rocket
	[21562]="25:6:15:1:20:::1:0:15898", -- Small Yellow Rocket
	[21563]="::4:4:1:::1:0:13218,13217,13219,13216", -- Don Rodrigo\'s Band
	[21565]="::4:3:1:::1:0:14753,14754", -- Rune of Perfection
	[21566]="::4:3:1:::1:0:14753,14754", -- Rune of Perfection
	[21567]="::4:3:1:::1:0:14753,14754", -- Rune of Duty
	[21568]="::4:3:1:::1:0:14753,14754", -- Rune of Duty
	[21569]="::15:1:1:::1:0:", -- Firework Launcher
	[21570]="::15:1:1:::1:0:", -- Cluster Launcher
	[21571]="100:25:15:1:20:::1:0:15898", -- Blue Rocket Cluster
	[21574]="100:25:15:1:20:::1:0:15898", -- Green Rocket Cluster
	[21576]="100:25:15:1:20:::1:0:15898", -- Red Rocket Cluster
	[21579]=":108030:4:4:1:::1:0:", -- Vanquished Tentacle of C\'Thun
	[21581]=":31789:4:4:1:::1:0:", -- Gauntlets of Annihilation
	[21582]=":18128:4:4:1:::1:0:", -- Grasp of the Old God
	[21583]=":27295:4:4:1:::1:0:", -- Cloak of Clarity
	[21585]=":18333:4:4:1:::1:0:", -- Dark Storm Gauntlets
	[21586]=":23611:4:4:1:::1:0:", -- Belt of Never-ending Agony
	[21589]=":12:15:1:20:::1:0:", -- Large Blue Rocket
	[21590]=":12:15:1:20:::1:0:", -- Large Green Rocket
	[21592]=":12:15:1:20:::1:0:", -- Large Red Rocket
	[21593]=":12:15:1:20:::1:0:", -- Large White Rocket
	[21595]=":12:15:1:20:::1:0:", -- Large Yellow Rocket
	[21596]=":89033:4:4:1:::1:0:", -- Ring of the Godslayer
	[21597]=":72651:4:4:1:::1:0:", -- Royal Scepter of Vek\'lor
	[21598]=":29215:4:4:1:::1:0:", -- Royal Qiraji Belt
	[21599]=":24994:4:4:1:::1:0:", -- Vek\'lor\'s Gloves of Devastation
	[21600]=":25090:4:4:1:::1:0:", -- Boots of Epiphany
	[21601]=":79025:4:4:1:::1:0:", -- Ring of Emperor Vek\'lor
	[21602]=":21633:4:4:1:::1:0:", -- Qiraji Execution Bracers
	[21603]=":63026:2:4:1:::1:0:", -- Wand of Qiraji Nobility
	[21604]=":17433:4:4:1:::1:0:", -- Bracelets of Royal Redemption
	[21605]=":21869:4:4:1:::1:0:", -- Gloves of the Hidden Temple
	[21606]=":30903:4:4:1:::1:0:", -- Belt of the Fallen Emperor
	[21607]=":26433:4:4:1:::1:0:", -- Grasp of the Fallen Emperor
	[21608]=":102777:4:4:1:::1:0:", -- Amulet of Vek\'nilash
	[21609]=":22184:4:4:1:::1:0:", -- Regenerating Belt of Vek\'nilash
	[21610]=":56995:4:4:1:::1:0:", -- Wormscale Blocker
	[21611]=":17874:4:4:1:::1:0:", -- Burrower Bracers
	[21615]=":24614:4:4:1:::1:0:", -- Don Rigoberto\'s Lost Hat
	[21616]=":59764:2:4:1:::1:0:", -- Huhuran\'s Stinger
	[21617]=":19998:4:4:1:::1:0:", -- Wasphide Gauntlets
	[21618]=":29040:4:4:1:::1:0:", -- Hive Defiler Wristguards
	[21619]=":16561:4:4:1:::1:0:", -- Gloves of the Messiah
	[21620]=":88661:4:4:1:::1:0:", -- Ring of the Martyr
	[21621]=":25024:4:4:1:::1:0:", -- Cloak of the Golden Hive
	[21622]=":83720:2:4:1:::1:0:", -- Sharpened Silithid Femur
	[21623]=":29577:4:4:1:::1:0:", -- Gauntlets of the Righteous Champion
	[21624]=":25297:4:4:1:::1:0:", -- Gauntlets of Kalimdor
	[21625]=":83030:4:4:1:::1:0:", -- Scarab Brooch
	[21626]=":50964:4:4:1:::1:0:", -- Slime-coated Leggings
	[21627]=":25286:4:4:1:::1:0:", -- Cloak of Untold Secrets
	[21635]=":100824:2:4:1:::1:0:", -- Barb of the Sand Reaver
	[21639]=":42897:4:4:1:::1:0:", -- Pauldrons of the Unrelenting
	[21640]="::15:1:1:::1:0:", -- Lunar Festival Fireworks Pack
	[21645]=":31380:4:4:1:::1:0:", -- Hive Tunneler\'s Boots
	[21647]=":86370:4:4:1:::1:0:", -- Fetish of the Sand Reaver
	[21648]=":25088:4:4:1:::1:0:", -- Recomposed Boots
	[21650]=":79141:2:4:1:::1:0:", -- Ancient Qiraji Ripper
	[21651]=":47667:4:4:1:::1:0:", -- Scaled Sand Reaver Leggings
	[21652]=":55824:4:4:1:::1:0:", -- Silithid Carapace Chestguard
	[21663]=":33225:4:4:1:::1:0:", -- Robes of the Guardian Saint
	[21664]=":86443:4:4:1:::1:0:", -- Barbed Choker
	[21665]=":31373:4:4:1:::1:0:", -- Mantle of Wicked Revenge
	[21666]=":91352:4:4:1:::1:0:", -- Sartura\'s Might
	[21667]=":54142:4:4:1:::1:0:", -- Legplates of Blazing Light
	[21668]=":46588:4:4:1:::1:0:", -- Scaled Leggings of Qiraji Fury
	[21669]=":29227:4:4:1:::1:0:", -- Creeping Vine Helm
	[21670]=":80303:4:4:1:::1:0:", -- Badge of the Swarmguard
	[21671]=":31415:4:4:1:::1:0:", -- Robes of the Battleguard
	[21672]=":19707:4:4:1:::1:0:", -- Gloves of Enforcement
	[21673]=":79132:2:4:1:::1:0:", -- Silithid Claw
	[21674]=":27960:4:4:1:::1:0:", -- Gauntlets of Steadfast Determination
	[21675]=":19933:4:4:1:::1:0:", -- Thick Qirajihide Belt
	[21676]=":32009:4:4:1:::1:0:", -- Leggings of the Festering Swarm
	[21677]=":96853:4:4:1:::1:0:", -- Ring of the Qiraji Fury
	[21678]=":99641:4:4:1:::1:0:", -- Necklace of Purity
	[21679]=":106933:2:4:1:::1:0:", -- Kalimdor\'s Revenge
	[21680]=":41536:4:4:1:::1:0:", -- Vest of Swift Execution
	[21681]=":91369:4:4:1:::1:0:", -- Ring of the Devoured
	[21682]=":20921:4:4:1:::1:0:", -- Bile-Covered Gauntlets
	[21683]=":44157:4:4:1:::1:0:", -- Mantle of the Desert Crusade
	[21684]=":38221:4:4:1:::1:0:", -- Mantle of the Desert\'s Fury
	[21685]=":87120:4:4:1:::1:0:", -- Petrified Scarab
	[21686]=":25548:4:4:1:::1:0:", -- Mantle of Phrenic Power
	[21687]=":102995:4:4:1:::1:0:", -- Ukko\'s Ring of Darkness
	[21688]=":40213:4:4:1:::1:0:", -- Boots of the Fallen Hero
	[21689]=":19260:4:4:1:::1:0:", -- Gloves of Ebru
	[21690]=":73749:4:4:1:::1:0:", -- Angelista\'s Charm
	[21691]=":27324:4:4:1:::1:0:", -- Ooze-ridden Gauntlets
	[21692]=":27429:4:4:1:::1:0:", -- Triad Girdle
	[21693]=":29332:4:4:1:::1:0:", -- Guise of the Devourer
	[21694]=":23555:4:4:1:::1:0:", -- Ternary Mantle
	[21695]=":90277:4:4:1:::1:0:", -- Angelista\'s Touch
	[21696]=":31641:4:4:1:::1:0:", -- Robes of the Triumvirate
	[21697]=":23819:4:4:1:::1:0:", -- Cape of the Trinity
	[21698]=":38927:4:4:1:::1:0:", -- Leggings of Immersion
	[21699]=":36256:4:4:1:::1:0:", -- Barrage Shoulders
	[21700]=":90535:4:4:1:::1:0:", -- Pendant of the Qiraji Guardian
	[21701]=":24238:4:4:1:::1:0:", -- Cloak of Concentrated Hatred
	[21702]=":78630:4:4:1:::1:0:", -- Amulet of Foul Warding
	[21703]=":101707:2:4:1:::1:0:", -- Hammer of Ji\'zhi
	[21704]=":42787:4:4:1:::1:0:", -- Boots of the Redeemed Prophecy
	[21705]=":37039:4:4:1:::1:0:", -- Boots of the Fallen Prophet
	[21706]=":43087:4:4:1:::1:0:", -- Boots of the Unwavering Will
	[21707]=":85399:4:4:1:::1:0:", -- Ring of Swarming Thought
	[21708]=":18740:4:4:1:::1:0:", -- Beetle Scaled Wristguards
	[21709]=":113642:4:4:1:::1:0:", -- Ring of the Fallen God
	[21710]=":26680:4:4:1:::1:0:", -- Cloak of the Fallen God
	[21711]="::0:1:1:::1:0:", -- Lunar Festival Invitation
	[21712]=":115200:4:4:1:::1:0:", -- Amulet of the Fallen God
	[21713]="1000:250:2:1:1:::1:0:15864", -- Elune\'s Candle
	[21714]=":50:15:1:20:::1:0:", -- Large Blue Rocket Cluster
	[21715]=":78119:2:4:1:::1:0:", -- Sand Polished Hammer
	[21716]=":50:15:1:20:::1:0:", -- Large Green Rocket Cluster
	[21718]=":50:15:1:20:::1:0:", -- Large Red Rocket Cluster
	[21721]="15:3:0:1:10:::1:0:15898", -- Moonglow
	[21722]=":1250:9:2:1:::1:0:", -- Pattern: Festival Dress
	[21723]=":1250:9:2:1:::1:0:", -- Pattern: Festival Suit
	[21724]=":175:9:2:1:::1:0:", -- Schematic: Small Blue Rocket
	[21725]=":175:9:2:1:::1:0:", -- Schematic: Small Green Rocket
	[21726]=":175:9:2:1:::1:0:", -- Schematic: Small Red Rocket
	[21727]=":275:9:2:1:::1:0:", -- Schematic: Large Blue Rocket
	[21728]=":275:9:2:1:::1:0:", -- Schematic: Large Green Rocket
	[21729]=":275:9:2:1:::1:0:", -- Schematic: Large Red Rocket
	[21730]=":875:9:2:1:::1:0:", -- Schematic: Blue Rocket Cluster
	[21731]=":875:9:2:1:::1:0:", -- Schematic: Green Rocket Cluster
	[21732]=":875:9:2:1:::1:0:", -- Schematic: Red Rocket Cluster
	[21733]=":4000:9:2:1:::1:0:", -- Schematic: Large Blue Rocket Cluster
	[21734]=":4000:9:2:1:::1:0:", -- Schematic: Large Green Rocket Cluster
	[21735]=":4000:9:2:1:::1:0:", -- Schematic: Large Red Rocket Cluster
	[21737]=":4000:9:2:1:::1:0:", -- Schematic: Cluster Launcher
	[21738]=":875:9:2:1:::1:0:", -- Schematic: Firework Launcher
	[21740]="::15:1:1:::1:0:", -- Small Rocket Recipes
	[21741]="::15:1:1:::1:0:", -- Cluster Rocket Recipes
	[21742]="::15:1:1:::1:0:", -- Large Rocket Recipes
	[21743]="::15:1:1:::1:0:", -- Large Cluster Rocket Recipes
	[21744]="::0:1:20:::1:0:", -- Lucky Rocket Cluster
	[21745]="::0:1:20:::1:0:", -- Elder\'s Moonstone
	[21746]="::15:1:1:::1:0:", -- Lucky Red Envelope
	[21747]="300:75:15:1:20:::1:0:15898", -- Festival Firecracker
	[21748]=":1500:4:2:1:::1:0:", -- Figurine - Jade Owl
	[21749]="::12:2:1:::1:0:", -- Combat Task Briefing I
	[21750]="::12:2:1:::1:0:", -- Combat Task Briefing II
	[21751]="::12:2:1:::1:0:", -- Tactical Task Briefing III
	[21752]=":1250:7:1:20::755:1:0:", -- Thorium Setting
	[21753]=":5000:4:3:1:::1:0:", -- Gem Studded Band
	[21754]=":4307:4:2:1:::1:0:", -- The Aquamarine Ward
	[21755]=":4307:4:2:1:::1:0:", -- Aquamarine Pendant of the Warrior
	[21756]=":1500:4:2:1:::1:0:", -- Figurine - Golden Hare
	[21757]="::12:1:10:::1:0:", -- Grimscale Murloc Head
	[21758]=":1500:4:2:1:::1:0:", -- Figurine - Black Pearl Panther
	[21760]=":1500:4:2:1:::1:0:", -- Figurine - Truesilver Crab
	[21761]="::13:1:20:::1:0:", -- Scarab Coffer Key
	[21762]="::13:1:20:::1:0:", -- Greater Scarab Coffer Key
	[21763]=":1500:4:2:1:::1:0:", -- Figurine - Truesilver Boar
	[21764]=":6420:4:2:1:::1:0:", -- Ruby Pendant of Fire
	[21765]=":2542:4:2:1:::1:0:", -- Truesilver Healing Ring
	[21766]=":7500:4:3:1:::1:0:", -- Opal Necklace of Impact
	[21767]=":8375:4:2:1:::1:0:", -- Simple Opal Ring
	[21768]=":12500:4:3:1:::1:0:", -- Sapphire Signet
	[21769]=":1500:4:2:1:::1:0:", -- Figurine - Ruby Serpent
	[21770]="::12:1:1:::1:0:", -- Ring of Mmmrrrggglll
	[21771]="::12:1:10:::1:0:", -- Captain Kelisendra\'s Cargo
	[21774]=":11416:4:3:1:::1:0:", -- Emerald Crown of Destruction
	[21775]=":8375:4:2:1:::1:0:", -- Onslaught Ring
	[21776]="::12:1:1:::1:0:", -- Captain Kelisendra\'s Lost Rutters
	[21777]=":3750:4:2:1:::1:0:", -- Figurine - Emerald Owl
	[21778]=":18662:4:2:1:::1:0:", -- Ring of Bitter Shadows
	[21779]=":21305:4:3:1:::1:0:", -- Band of Natural Fire
	[21781]="::12:1:1:::1:0:", -- Thaelis\'s Head
	[21783]="::12:1:1:::1:0:", -- Magister Duskwither\'s Journal
	[21784]=":15000:4:3:1:::1:0:", -- Figurine - Black Diamond Crab
	[21789]=":15000:4:3:1:::1:0:", -- Figurine - Dark Iron Scorpid
	[21790]=":7767:4:2:1:::1:0:", -- Sapphire Pendant of Winter Night
	[21791]=":12503:4:3:1:::1:0:", -- Living Emerald Pendant
	[21792]=":25218:4:3:1:::1:0:", -- Necklace of the Diamond Tower
	[21800]=":39523:2:3:1:::1:0:", -- Silithid Husked Launcher
	[21801]=":39677:2:3:1:::1:0:", -- Antenna of Invigoration
	[21802]=":53107:2:3:1:::1:0:", -- The Lost Kris of Zedd
	[21803]=":27935:4:3:1:::1:0:", -- Helm of the Holy Avenger
	[21804]=":24080:4:3:1:::1:0:", -- Coif of Elemental Fury
	[21805]=":28147:4:3:1:::1:0:", -- Polished Obsidian Pauldrons
	[21806]=":69942:2:3:1:::1:0:", -- Gavel of Qiraji Authority
	[21807]="::12:1:1:::1:0:", -- Unmarked Letter
	[21808]="::12:1:10:::1:0:", -- Arcane Core
	[21809]=":48655:4:3:1:::1:0:", -- Fury of the Forgotten Swarm
	[21810]=":17039:4:3:1:::1:0:", -- Treads of the Wandering Nomad
	[21812]="::15:1:1:::1:0:", -- Box of Chocolates
	[21813]="::15:1:1:::1:0:", -- Bag of Candies
	[21814]=":56555:4:4:1:::1:0:", -- Breastplate of Annihilation
	[21815]="10::15:1:10:::10:0:6734,6746,6735,7731,2352,6737,7736,5688,11118,2388,14731,6790,5814,6739,6928,6738,6740,11103,295,7744,6741,16458,3934,11106,15174,6727,6929,8931,6807,16256,5111,6736,22922,7714,9356,7733,6747,12196,6791,1247,6930,7737,6272,1464,9501,11116,4603", -- Love Token
	[21816]="::15:1:1:::1:0:", -- Heart Candy
	[21817]="::15:1:1:::1:0:", -- Heart Candy
	[21818]="::15:1:1:::1:0:", -- Heart Candy
	[21819]="::15:1:1:::1:0:", -- Heart Candy
	[21820]="::15:1:1:::1:0:", -- Heart Candy
	[21821]="::15:1:1:::1:0:", -- Heart Candy
	[21822]="::15:1:1:::1:0:", -- Heart Candy
	[21823]="::15:1:1:::1:0:", -- Heart Candy
	[21829]="100:25:15:1:1:::1:0:6734,6746,6735,7731,2352,6737,7736,5688,11118,2388,14731,6790,5814,6739,6928,6738,6740,11103,295,7744,6741,16458,3934,11106,15174,6727,6929,8931,6807,16256,5111,6736,22922,7714,9356,7733,6747,12196,6791,1247,6930,7737,6272,1464,9501,11116,4603", -- Perfume Bottle
	[21830]="::15:1:10:::1:0:", -- Empty Wrapper
	[21831]="::15:1:1:::1:0:", -- Wrappered Gift
	[21833]="100:25:15:1:1:::1:0:6734,6746,6735,7731,2352,6737,7736,5688,11118,2388,14731,6790,5814,6739,6928,6738,6740,11103,295,7744,6741,16458,3934,11106,15174,6727,6929,8931,6807,16256,5111,6736,22922,7714,9356,7733,6747,12196,6791,1247,6930,7737,6272,1464,9501,11116,4603", -- Cologne Bottle
	[21835]=":125:0:1:20:::1:0:", -- Anesthetic Poison
	[21836]=":96853:4:4:1:::1:0:", -- Ritssyn\'s Ring of Chaos
	[21837]=":79716:2:4:1:::1:0:", -- Anubisath Warhammer
	[21838]=":31996:4:4:1:::1:0:", -- Garb of Royal Ascension
	[21839]=":92916:2:4:1:::1:0:", -- Scepter of the False Prophet
	[21840]=":4000:7:1:10::202,197:1:0:", -- Bolt of Netherweave
	[21841]=":10000:1:2:1:::1:0:", -- Netherweave Bag
	[21842]=":8000:7:2:20::197:1:0:", -- Bolt of Imbued Netherweave
	[21843]=":10000:1:2:1:::1:0:", -- Imbued Netherweave Bag
	[21844]=":8000:7:1:10::165,197:1:0:", -- Bolt of Soulcloth
	[21845]=":4000:7:3:20::197:1:0:", -- Primal Mooncloth
	[21846]=":21632:4:4:1:::1:0:", -- Spellfire Belt
	[21847]=":21712:4:4:1:::1:0:", -- Spellfire Gloves
	[21848]=":43584:4:4:1:::1:0:", -- Spellfire Robe
	[21849]=":12261:4:2:1:::1:0:", -- Netherweave Bracers
	[21850]=":12306:4:2:1:::1:0:", -- Netherweave Belt
	[21851]=":13059:4:2:1:::1:0:", -- Netherweave Gloves
	[21852]=":26926:4:2:1:::1:0:", -- Netherweave Pants
	[21853]=":21336:4:2:1:::1:0:", -- Netherweave Boots
	[21854]=":29267:4:2:1:::1:0:", -- Netherweave Robe
	[21855]=":30091:4:2:1:::1:0:", -- Netherweave Tunic
	[21856]=":99282:2:4:1:::1:0:", -- Neretzek, The Blood Drinker
	[21858]=":20000:1:3:1:::1:0:", -- Spellfire Bag
	[21859]=":31883:4:3:1:::1:0:", -- Imbued Netherweave Pants
	[21860]=":24616:4:3:1:::1:0:", -- Imbued Netherweave Boots
	[21861]=":34308:4:3:1:::1:0:", -- Imbued Netherweave Robe
	[21862]=":34437:4:3:1:::1:0:", -- Imbued Netherweave Tunic
	[21863]=":20474:4:4:1:::1:0:", -- Soulcloth Gloves
	[21864]=":30824:4:4:1:::1:0:", -- Soulcloth Shoulders
	[21865]=":41251:4:4:1:::1:0:", -- Soulcloth Vest
	[21866]=":17197:4:3:1:::1:0:", -- Arcanoweave Bracers
	[21867]=":26309:4:3:1:::1:0:", -- Arcanoweave Boots
	[21868]=":35486:4:3:1:::1:0:", -- Arcanoweave Robe
	[21869]=":32801:4:4:1:::1:0:", -- Frozen Shadoweave Shoulders
	[21870]=":32921:4:4:1:::1:0:", -- Frozen Shadoweave Boots
	[21871]=":44055:4:4:1:::1:0:", -- Frozen Shadoweave Robe
	[21872]=":40000:1:3:1:::1:0:", -- Ebon Shadowbag
	[21873]=":24089:4:4:1:::1:0:", -- Primal Mooncloth Belt
	[21874]=":33398:4:4:1:::1:0:", -- Primal Mooncloth Shoulders
	[21875]=":46852:4:4:1:::1:0:", -- Primal Mooncloth Robe
	[21876]=":50000:1:3:1:::1:0:", -- Primal Mooncloth Bag
	[21877]=":800:7:1:20::164,202,129,197:1:0:", -- Netherweave Cloth
	[21881]=":5000:7:1:10::197:1:0:", -- Netherweb Spider Silk
	[21882]=":2500:7:1:20::197:1:0:", -- Soul Essence
	[21884]=":4000:7:2:20::171,164,333,202,755,165,186,197:1:0:", -- Primal Fire
	[21885]=":4000:7:2:20::171,164,333,202,755,165,197:1:0:", -- Primal Water
	[21886]=":4000:7:2:20::171,164,333,202,755,165,197:1:0:", -- Primal Life
	[21887]="5000:1250:7:1:20::164,202,165,197:1:0:14846", -- Knothide Leather
	[21888]=":15430:4:4:1:::1:0:", -- Gloves of the Immortal
	[21889]=":28578:4:4:1:::1:0:", -- Gloves of the Redeemed Prophecy
	[21890]=":24445:4:4:1:::1:0:", -- Gloves of the Fallen Prophet
	[21891]=":99378:4:4:1:::1:0:", -- Shard of the Fallen Star
	[21892]="40000:10000:9:1:1:::1:0:19213,16638,16767", -- Pattern: Bolt of Imbued Netherweave
	[21893]="40000:10000:9:1:1:::1:0:19213,19015", -- Pattern: Imbued Netherweave Bag
	[21894]="40000:10000:9:1:1:::1:0:16638,19015,16767,19017", -- Pattern: Bolt of Soulcloth
	[21895]="40000:10000:9:1:1:::1:0:22208", -- Pattern: Primal Mooncloth
	[21896]="40000:10000:9:1:1:::1:0:19213,16638,16767", -- Pattern: Netherweave Robe
	[21897]="40000:10000:9:1:1:::1:0:19213,16638,16767", -- Pattern: Netherweave Tunic
	[21898]="60000:15000:9:1:1:::1:0:18011,19722", -- Pattern: Imbued Netherweave Pants
	[21899]="60000:15000:9:1:1:::1:0:18011,19722", -- Pattern: Imbued Netherweave Boots
	[21900]="60000:15000:9:1:1:::1:0:19521", -- Pattern: Imbued Netherweave Robe
	[21901]="60000:15000:9:1:1:::1:0:19521", -- Pattern: Imbued Netherweave Tunic
	[21902]="80000:20000:9:1:1:::1:0:19015,19017", -- Pattern: Soulcloth Gloves
	[21903]=":15000:9:4:1:::1:0:", -- Pattern: Soulcloth Shoulders
	[21904]=":15000:9:4:1:::1:0:", -- Pattern: Soulcloth Vest
	[21905]=":15000:9:2:1:::1:0:", -- Pattern: Arcanoweave Bracers
	[21906]=":15000:9:2:1:::1:0:", -- Pattern: Arcanoweave Boots
	[21907]=":20000:9:2:1:::1:0:", -- Pattern: Arcanoweave Robe
	[21908]="60000:15000:9:1:1:::1:0:22213", -- Pattern: Spellfire Belt
	[21909]="60000:15000:9:1:1:::1:0:22213", -- Pattern: Spellfire Gloves
	[21910]="60000:15000:9:1:1:::1:0:22213", -- Pattern: Spellfire Robe
	[21911]="60000:15000:9:3:1:::1:0:22213", -- Pattern: Spellfire Bag
	[21912]="60000:15000:9:1:1:::1:0:22212", -- Pattern: Frozen Shadoweave Shoulders
	[21913]="60000:15000:9:1:1:::1:0:22212", -- Pattern: Frozen Shadoweave Robe
	[21914]="60000:15000:9:1:1:::1:0:22212", -- Pattern: Frozen Shadoweave Boots
	[21915]="60000::9:3:1:::1:0:22212", -- Pattern: Ebon Shadowbag
	[21916]="60000:15000:9:1:1:::1:0:22208", -- Pattern: Primal Mooncloth Belt
	[21917]="60000:15000:9:1:1:::1:0:22208", -- Pattern: Primal Mooncloth Robe
	[21918]="60000:15000:9:1:1:::1:0:22208", -- Pattern: Primal Mooncloth Shoulders
	[21919]="60000:15000:9:3:1:::1:0:22208", -- Pattern: Primal Mooncloth Bag
	[21920]="::15:1:1:::1:0:", -- Creased Letter
	[21921]="::15:1:1:::1:0:", -- Carefully Penned Note
	[21925]="::15:1:1:::1:0:", -- Immaculate Letter
	[21926]="::15:1:1:::1:0:", -- Slightly Creased Note
	[21927]="500:125:0:1:20:::1:0:23405,26304,23151", -- Instant Poison VII
	[21928]="::12:1:20:::1:0:", -- Winterspring Blood Sample
	[21929]=":2500:3:2:20::202,755:1:0:", -- Flame Spessarite
	[21931]=":250:4:2:1:::1:0:", -- Woven Copper Ring
	[21932]=":250:4:2:1:::1:0:", -- Heavy Copper Ring
	[21933]=":750:4:2:1:::1:0:", -- Thick Bronze Necklace
	[21934]=":1500:4:2:1:::1:0:", -- Ornate Tigerseye Necklace
	[21935]="::12:1:20:::1:0:", -- Stable Ectoplasm
	[21936]="::12:1:20:::1:0:", -- Frozen Ectoplasm
	[21937]="::12:1:20:::1:0:", -- Scorched Ectoplasm
	[21938]="::12:1:1:::1:0:", -- Magma Core
	[21939]="400000:100000:12:1:1:::1:0:16015", -- Fel Elemental Rod
	[21940]=":1250:9:2:1:::1:0:", -- Design: Golden Hare
	[21941]="5000:1250:9:1:1:::1:0:989,4897", -- Design: Black Pearl Panther
	[21942]="6000:1500:9:1:1:::1:0:2821,2810", -- Design: Ruby Crown of Restoration
	[21943]="6000:1500:9:1:1:::1:0:1148,4897", -- Design: Truesilver Crab
	[21944]=":1875:9:2:1:::1:0:", -- Design: Truesilver Boar
	[21945]=":1875:9:2:1:::1:0:", -- Design: The Aquamarine Ward
	[21946]="::12:1:1:::1:0:", -- Ectoplasmic Distiller
	[21947]=":1875:9:2:1:::1:0:", -- Design: Gem Studded Band
	[21948]="7500:1875:9:1:1:::1:0:16624,5163,17512,8363", -- Design: Opal Necklace of Impact
	[21949]=":2500:9:2:1:::1:0:", -- Design: Ruby Serpent
	[21952]="10000:2500:9:1:1:::1:0:15179", -- Design: Emerald Crown of Destruction
	[21953]=":3125:9:2:1:::1:0:", -- Design: Emerald Owl
	[21954]="10000:2500:9:1:1:::1:0:12941", -- Design: Ring of Bitter Shadows
	[21955]="::9:2:1:::1:0:", -- Design: Black Diamond Crab
	[21956]="::9:2:1:::1:0:", -- Design: Dark Iron Scorpid
	[21957]="13500:3375:9:1:1:::1:0:11189", -- Design: Necklace of the Diamond Tower
	[21960]="::15:1:20:::1:0:", -- Handmade Woodcraft
	[21975]="::15:1:1:::1:0:", -- Pledge of Adoration: Stormwind
	[21979]="::15:1:1:::1:0:", -- Gift of Adoration: Darnassus
	[21980]="::15:1:1:::1:0:", -- Gift of Adoration: Ironforge
	[21981]="::15:1:1:::1:0:", -- Gift of Adoration: Stormwind
	[21982]="::12:1:25:::1:0:", -- Ogre Warbeads
	[21983]="::12:1:1:::1:0:", -- Incomplete Banner of Provocation
	[21984]="::12:1:1:::1:0:", -- Left Piece of Lord Valthalak\'s Amulet
	[21985]="::12:1:1:::1:0:", -- Sealed Blood Container
	[21986]="::12:1:1:::1:0:", -- Banner of Provocation
	[21987]="::12:1:1:::1:0:", -- Incendicite of Incendius
	[21988]="::12:1:1:::1:0:", -- Ember of Emberseer
	[21989]="::12:1:1:::1:0:", -- Cinder of Cynders
	[21990]=":1275:0:1:20:::1:0:", -- Netherweave Bandage
	[21991]="12000:3000:0:1:20:::1:0:23405,26304,23151", -- Heavy Netherweave Bandage
	[21992]="20000:5000:9:1:1:::1:0:18990,18991", -- Manual: Netherweave Bandage
	[21993]="40000:10000:9:1:1:::1:0:18990,18991", -- Manual: Heavy Netherweave Bandage
	[21994]=":18406:4:3:1:::1:0:", -- Belt of Heroism
	[21995]=":34276:4:4:1:::1:0:", -- Boots of Heroism
	[21996]=":18543:4:3:1:::1:0:", -- Bracers of Heroism
	[21997]=":46128:4:4:1:::1:0:", -- Breastplate of Heroism
	[21998]=":17731:4:4:1:::1:0:", -- Gauntlets of Heroism
	[21999]=":34787:4:4:1:::1:0:", -- Helm of Heroism
	[22000]=":37912:4:3:1:::1:0:", -- Legplates of Heroism
	[22001]=":28117:4:3:1:::1:0:", -- Spaulders of Heroism
	[22002]=":13464:4:3:1:::1:0:", -- Darkmantle Belt
	[22003]=":25261:4:4:1:::1:0:", -- Darkmantle Boots
	[22004]=":13913:4:3:1:::1:0:", -- Darkmantle Bracers
	[22005]=":26102:4:4:1:::1:0:", -- Darkmantle Cap
	[22006]=":12034:4:4:1:::1:0:", -- Darkmantle Gloves
	[22007]=":25791:4:3:1:::1:0:", -- Darkmantle Pants
	[22008]=":19166:4:3:1:::1:0:", -- Darkmantle Spaulders
	[22009]=":31970:4:4:1:::1:0:", -- Darkmantle Tunic
	[22010]=":15451:4:3:1:::1:0:", -- Beastmaster\'s Belt
	[22011]=":15508:4:3:1:::1:0:", -- Beastmaster\'s Bindings
	[22012]="50000:12500:9:1:1:::1:0:18990,18991", -- Master First Aid - Doctor in the House
	[22013]=":29212:4:4:1:::1:0:", -- Beastmaster\'s Cap
	[22014]="1333333:333333:12:1:1:::1:0:11536,10856,10857", -- Hallowed Brazier
	[22015]=":14941:4:4:1:::1:0:", -- Beastmaster\'s Gloves
	[22016]=":23809:4:3:1:::1:0:", -- Beastmaster\'s Mantle
	[22017]=":32137:4:3:1:::1:0:", -- Beastmaster\'s Pants
	[22018]="::0:1:20:::1:0:23405,23151", -- Conjured Glacier Water
	[22019]="::0:1:20:::1:0:23405,23151", -- Conjured Croissant
	[22044]="::0:1:1:::1:0:", -- Mana Emerald
	[22046]="::12:1:1:::1:0:", -- Right Piece of Lord Valthalak\'s Amulet
	[22047]="::12:1:1:::1:0:", -- Top Piece of Lord Valthalak\'s Amulet
	[22048]="::12:1:1:::1:0:", -- Lord Valthalak\'s Amulet
	[22049]="::12:1:1:::1:0:", -- Brazier of Beckoning
	[22050]="::12:1:1:::1:0:", -- Brazier of Beckoning
	[22051]="::12:1:1:::1:0:", -- Brazier of Beckoning
	[22052]="::12:1:1:::1:0:", -- Brazier of Beckoning
	[22053]=":150:0:1:20:::1:0:", -- Deadly Poison VI
	[22054]="600:150:0:1:20:::1:0:23405,26304,23151", -- Deadly Poison VII
	[22055]="700:175:0:1:20:::1:0:23405,26304,23151", -- Wound Poison V
	[22056]="::12:1:1:::1:0:", -- Brazier of Beckoning
	[22057]="::12:1:1:::1:0:", -- Brazier of Invocation
	[22059]="::15:1:1:::1:0:", -- Valentine\'s Day Card
	[22060]=":41015:4:4:1:::1:0:", -- Beastmaster\'s Tunic
	[22061]=":31009:4:4:1:::1:0:", -- Beastmaster\'s Boots
	[22062]=":11049:4:3:1:::1:0:", -- Sorcerer\'s Belt
	[22063]=":11088:4:3:1:::1:0:", -- Sorcerer\'s Bindings
	[22064]=":20800:4:4:1:::1:0:", -- Sorcerer\'s Boots
	[22065]=":20873:4:4:1:::1:0:", -- Sorcerer\'s Crown
	[22066]=":9623:4:4:1:::1:0:", -- Sorcerer\'s Gloves
	[22067]=":20624:4:3:1:::1:0:", -- Sorcerer\'s Leggings
	[22068]=":15749:4:3:1:::1:0:", -- Sorcerer\'s Mantle
	[22069]=":26269:4:4:1:::1:0:", -- Sorcerer\'s Robes
	[22070]=":10578:4:3:1:::1:0:", -- Deathmist Belt
	[22071]=":10618:4:3:1:::1:0:", -- Deathmist Bracers
	[22072]=":21591:4:3:1:::1:0:", -- Deathmist Leggings
	[22073]=":16043:4:3:1:::1:0:", -- Deathmist Mantle
	[22074]=":20067:4:4:1:::1:0:", -- Deathmist Mask
	[22075]=":26852:4:4:1:::1:0:", -- Deathmist Robe
	[22076]=":20213:4:4:1:::1:0:", -- Deathmist Sandals
	[22077]=":10299:4:4:1:::1:0:", -- Deathmist Wraps
	[22078]=":10891:4:3:1:::1:0:", -- Virtuous Belt
	[22079]=":10929:4:3:1:::1:0:", -- Virtuous Bracers
	[22080]=":20505:4:4:1:::1:0:", -- Virtuous Crown
	[22081]=":10448:4:4:1:::1:0:", -- Virtuous Gloves
	[22082]=":16572:4:3:1:::1:0:", -- Virtuous Mantle
	[22083]=":27632:4:4:1:::1:0:", -- Virtuous Robe
	[22084]=":19333:4:4:1:::1:0:", -- Virtuous Sandals
	[22085]=":21034:4:3:1:::1:0:", -- Virtuous Skirt
	[22086]=":18341:4:3:1:::1:0:", -- Soulforge Belt
	[22087]=":34151:4:4:1:::1:0:", -- Soulforge Boots
	[22088]=":18477:4:3:1:::1:0:", -- Soulforge Bracers
	[22089]=":45966:4:4:1:::1:0:", -- Soulforge Breastplate
	[22090]=":17667:4:4:1:::1:0:", -- Soulforge Gauntlets
	[22091]=":34662:4:4:1:::1:0:", -- Soulforge Helm
	[22092]=":37780:4:3:1:::1:0:", -- Soulforge Legplates
	[22093]=":28020:4:3:1:::1:0:", -- Soulforge Spaulders
	[22094]="::12:1:25:::1:0:", -- Bloodkelp
	[22095]=":16158:4:3:1:::1:0:", -- Bindings of The Five Thunders
	[22096]=":30451:4:4:1:::1:0:", -- Boots of The Five Thunders
	[22097]=":30427:4:4:1:::1:0:", -- Coif of The Five Thunders
	[22098]=":16334:4:3:1:::1:0:", -- Cord of The Five Thunders
	[22099]=":15558:4:4:1:::1:0:", -- Gauntlets of The Five Thunders
	[22100]=":30953:4:3:1:::1:0:", -- Kilt of The Five Thunders
	[22101]=":23106:4:3:1:::1:0:", -- Pauldrons of The Five Thunders
	[22102]=":38368:4:4:1:::1:0:", -- Vest of The Five Thunders
	[22103]="::0:1:1:::1:0:", -- Master Healthstone
	[22104]="::0:1:1:::1:0:", -- Master Healthstone
	[22105]="::0:1:1:::1:0:", -- Master Healthstone
	[22106]=":13023:4:3:1:::1:0:", -- Feralheart Belt
	[22107]=":24438:4:4:1:::1:0:", -- Feralheart Boots
	[22108]=":13122:4:3:1:::1:0:", -- Feralheart Bracers
	[22109]=":24619:4:4:1:::1:0:", -- Feralheart Cowl
	[22110]=":12546:4:4:1:::1:0:", -- Feralheart Gloves
	[22111]=":26883:4:3:1:::1:0:", -- Feralheart Kilt
	[22112]=":19976:4:3:1:::1:0:", -- Feralheart Spaulders
	[22113]=":33313:4:4:1:::1:0:", -- Feralheart Vest
	[22114]="::15:3:1:::1:0:", -- Pink Murloc Egg
	[22115]="::12:1:1:::1:0:", -- Extra-Dimensional Ghost Revealer
	[22116]="::0:1:1:::1:0:", -- Master Soulstone
	[22117]="::15:1:20:::1:0:", -- Pledge of Loyalty: Stormwind
	[22119]="::15:1:20:::1:0:", -- Pledge of Loyalty: Ironforge
	[22120]="::15:1:20:::1:0:", -- Pledge of Loyalty: Darnassus
	[22121]="::15:1:20:::1:0:", -- Pledge of Loyalty: Undercity
	[22122]="::15:1:20:::1:0:", -- Pledge of Loyalty: Thunder Bluff
	[22123]="::15:1:20:::1:0:", -- Pledge of Loyalty: Orgrimmar
	[22128]="::4:1:1:::1:0:", -- Master Firestone
	[22131]="::15:1:1:::1:0:", -- Stormwind Gift Collection
	[22132]="::15:1:1:::1:0:", -- Ironforge Gift Collection
	[22133]="::15:1:1:::1:0:", -- Darnassus Gift Collection
	[22134]="::15:1:1:::1:0:", -- Undercity Gift Collection
	[22135]="::15:1:1:::1:0:", -- Thunder Bluff Gift Collection
	[22136]="::15:1:1:::1:0:", -- Orgrimmar Gift Collection
	[22137]=":12:15:1:1:::1:0:", -- Ysida\'s Satchel
	[22138]="::12:1:50:::1:0:", -- Blackrock Bracer
	[22139]="::12:1:1:::1:0:", -- Ysida\'s Locket
	[22140]="::15:1:20:::1:0:", -- Sentinel\'s Card
	[22141]="::15:1:20:::1:0:", -- Ironforge Guard\'s Card
	[22142]="::15:1:20:::1:0:", -- Grunt\'s Card
	[22143]="::15:1:20:::1:0:", -- Stormwind Guard\'s Card
	[22144]="::15:1:20:::1:0:", -- Bluffwatcher\'s Card
	[22145]="::15:1:20:::1:0:", -- Guardian\'s Moldy Card
	[22146]=":100000:9:3:1:::1:0:", -- Book: Gift of the Wild III
	[22147]="5000:1250:15:1:20::-11:1:0:26744,4878,26751,24843,20915,4220,26758,26765,19235,5139,16588,3323,16612,8361,1308,4083,983,3700,25039,19679,26754,26752,23373,18017,26743,25010,16757,3500,5151,3970,12097,1463,25633,18019,25082,26756,20092,26759,17518,16611,2805,18243,3335,3562,15175,1275,18006,19014,4562,3542,26747,26741,26739,4575,16829,1307,14739,23405,26753,26742,25051,26748,958,3490,20081,13476,3351,19004,18998,17078,23157,1673,1351,19013,24995,26745,26757,23112,1257,10364,19535,23560,22479,26724,23145,26749,26304,12096,16015,5110,26755,26738,23151,16706,18802,24935,19718,26740,19678,25019", -- Flintweed Seed
	[22148]="1500:375:15:1:20::-11:1:0:26744,4878,26751,24843,20915,4220,26758,26765,19235,5139,16588,3323,16612,8361,1308,4083,983,3700,25039,19679,26754,26752,23373,18017,26743,25010,16757,3500,5151,3970,12097,1463,25633,18019,25082,26756,20092,26759,17518,16611,2805,18243,3335,3562,15175,1275,18006,19014,4562,3542,26747,26741,26739,4575,16829,1307,14739,23405,26753,26742,25051,26748,958,3490,20081,13476,3351,19004,18998,17078,23157,1673,1351,19013,24995,26745,26757,23112,1257,10364,19535,23560,22479,26724,23145,26749,26304,12096,16015,5110,26755,26738,23151,16706,18802,24935,19718,26740,19678,25019", -- Wild Quillvine
	[22149]=":10283:4:3:1:::1:0:", -- Beads of Ogre Mojo
	[22150]=":10283:4:3:1:::1:0:", -- Beads of Ogre Might
	[22153]=":100000:9:3:1:::1:0:", -- Tome of Arcane Brilliance 2
	[22154]="::15:1:1:::1:0:", -- Pledge of Adoration: Ironforge
	[22155]="::15:1:1:::1:0:", -- Pledge of Adoration: Darnassus
	[22156]="::15:1:1:::1:0:", -- Pledge of Adoration: Orgrimmar
	[22157]="::15:1:1:::1:0:", -- Pledge of Adoration: Undercity
	[22158]="::15:1:1:::1:0:", -- Pledge of Adoration: Thunder Bluff
	[22159]="::15:1:1:::1:0:", -- Pledge of Friendship: Darnassus
	[22160]="::15:1:1:::1:0:", -- Pledge of Friendship: Ironforge
	[22161]="::15:1:1:::1:0:", -- Pledge of Friendship: Orgrimmar
	[22162]="::15:1:1:::1:0:", -- Pledge of Friendship: Thunder Bluff
	[22163]="::15:1:1:::1:0:", -- Pledge of Friendship: Undercity
	[22164]="::15:1:1:::1:0:", -- Gift of Adoration: Orgrimmar
	[22165]="::15:1:1:::1:0:", -- Gift of Adoration: Thunder Bluff
	[22166]="::15:1:1:::1:0:", -- Gift of Adoration: Undercity
	[22167]="::15:1:1:::1:0:", -- Gift of Friendship: Darnassus
	[22168]="::15:1:1:::1:0:", -- Gift of Friendship: Ironforge
	[22169]="::15:1:1:::1:0:", -- Gift of Friendship: Orgrimmar
	[22170]="::15:1:1:::1:0:", -- Gift of Friendship: Stormwind
	[22171]="::15:1:1:::1:0:", -- Gift of Friendship: Thunder Bluff
	[22172]="::15:1:1:::1:0:", -- Gift of Friendship: Undercity
	[22173]="::15:1:20:::1:0:", -- Dwarven Homebrew
	[22174]="::15:1:20:::1:0:", -- Romantic Poem
	[22175]="::15:1:20:::1:0:", -- Freshly Baked Pie
	[22176]="::15:1:20:::1:0:", -- Homemade Bread
	[22177]="::15:1:20:::1:0:", -- Freshly Picked Flowers
	[22178]="::15:1:1:::1:0:", -- Pledge of Friendship: Stormwind
	[22179]="54000:13500:9:1:1:::1:0:12807,5753,6382,6376,12776,5520,16649,6027,6374,5750,16267,15494,6328,5815,5749,6373,23535", -- Grimoire of Firebolt (Rank 8)
	[22180]="26000:6500:9:1:1:::1:0:12807,5753,6382,6376,12776,5520,16649,6027,6374,5750,16267,15494,6328,5815,5749,6373,23535", -- Grimoire of Blood Pact (Rank 6)
	[22181]="36000:9000:9:1:1:::1:0:12807,5753,6382,6376,12776,5520,16649,6027,6374,5750,16267,15494,6328,5815,5749,6373,23535", -- Grimoire of Fire Shield (Rank 6)
	[22182]="67000:16750:9:1:1:::1:0:16267,12807,6328,5753,6382,5815,5520,16649,6027,6374,5750,23535", -- Grimoire of Torment (Rank 7)
	[22183]="32000:8000:9:1:1:::1:0:16267,12807,6328,5753,6382,5815,5520,16649,6027,6374,5750,23535", -- Grimoire of Suffering (Rank 5)
	[22184]="44000:11000:9:1:1:::1:0:16267,12807,6328,5753,6382,5815,5520,16649,6027,6374,5750,23535", -- Grimoire of Consume Shadows (Rank 7)
	[22185]="36000:9000:9:1:1:::1:0:16267,12807,6328,5753,6382,5815,5520,16649,6027,6374,5750,23535", -- Grimoire of Sacrifice (Rank 7)
	[22186]="54000:13500:9:1:1:::1:0:5815,16267,12807,5520,16649,5753,6382,23535", -- Grimoire of Lash of Pain (Rank 7)
	[22187]="67000:16750:9:1:1:::1:0:5815,16267,12807,5520,16649,5753,6382,23535", -- Grimoire of Soothing Kiss (Rank 5)
	[22188]="29000:7250:9:1:1:::1:0:5815,16267,12807,5520,16649,5753,6382,23535", -- Grimoire of Devour Magic (Rank 5)
	[22189]="67000:16750:9:1:1:::1:0:5815,16267,12807,5520,16649,5753,6382,23535", -- Grimoire of Devour Magic (Rank 6)
	[22190]="36000:9000:9:1:1:::1:0:5815,16267,12807,5520,16649,5753,6382,23535", -- Grimoire of Tainted Blood (Rank 5)
	[22191]=":47549:4:4:1:::1:0:", -- Obsidian Mail Tunic
	[22192]="::0:1:20:::1:0:", -- Bloodkelp Elixir of Dodging
	[22193]="::0:1:20:::1:0:", -- Bloodkelp Elixir of Resistance
	[22194]=":23455:4:4:1:::1:0:", -- Black Grasp of the Destroyer
	[22195]=":17221:4:3:1:::1:0:", -- Light Obsidian Belt
	[22196]=":56466:4:4:1:::1:0:", -- Thick Obsidian Breastplate
	[22197]=":18915:4:3:1:::1:0:", -- Heavy Obsidian Belt
	[22198]=":47188:4:4:1:::1:0:", -- Jagged Obsidian Shield
	[22200]="::15:1:20:::1:0:", -- Silver Shafted Arrow
	[22201]="::12:1:1:::1:0:", -- Reliquary of Purity
	[22202]=":2500:7:1:10::164:1:0:", -- Small Obsidian Shard
	[22203]=":5000:7:1:10::164:1:0:", -- Large Obsidian Shard
	[22204]=":12403:4:3:1:::1:0:", -- Wristguards of Renown
	[22205]=":14998:4:3:1:::1:0:", -- Black Steel Bindings
	[22206]="::4:2:1:::1:0:", -- Bouquet of Red Roses
	[22207]=":15047:4:3:1:::1:0:", -- Sash of the Grand Hunt
	[22208]=":57079:2:3:1:::1:0:", -- Lavastone Hammer
	[22209]="50000:12500:9:1:1:::1:0:15176", -- Plans: Heavy Obsidian Belt
	[22212]=":18636:4:3:1:::1:0:", -- Golem Fitted Pauldrons
	[22214]="50000:12500:9:1:1:::1:0:15176", -- Plans: Light Obsidian Belt
	[22216]="::12:1:1:::1:0:", -- Venoxis\'s Venom Sac
	[22217]="::12:1:1:::1:0:", -- Kurinnaxx\'s Venom Sac
	[22218]="::15:1:20:::1:0:", -- Handful of Rose Petals
	[22219]="50000:12500:9:1:1:::1:0:15471", -- Plans: Jagged Obsidian Shield
	[22220]=":12500:9:3:1:::1:0:", -- Plans: Black Grasp of the Destroyer
	[22221]="80000:20000:9:1:1:::1:0:15471", -- Plans: Obsidian Mail Tunic
	[22222]=":20000:9:3:1:::1:0:", -- Plans: Thick Obsidian Breastplate
	[22223]=":19722:4:3:1:::1:0:", -- Foreman\'s Head Protector
	[22224]="::12:1:1:::1:0:", -- Jeering Spectre\'s Essence
	[22225]=":14937:4:3:1:::1:0:", -- Dragonskin Cowl
	[22226]="::12:1:1:::1:0:", -- Druidical Remains
	[22227]="::12:1:1:::1:0:", -- Starbreeze Village Relic
	[22228]="::12:1:1:::1:0:", -- Brilliant Sword of Zealotry
	[22229]="::12:1:1:::1:0:", -- Soul Ashes of the Banished
	[22231]=":15880:4:3:1:::1:0:", -- Kayser\'s Boots of Precision
	[22232]=":14421:4:3:1:::1:0:", -- Marksman\'s Girdle
	[22234]=":9713:4:3:1:::1:0:", -- Mantle of Lost Hope
	[22235]="::15:1:1:::1:0:", -- Truesilver Shafted Arrow
	[22236]="::0:1:20:::1:0:", -- Buttermilk Delight
	[22237]="::0:1:20:::1:0:", -- Dark Desire
	[22238]="::0:1:20:::1:0:", -- Very Berry Cream
	[22239]="::0:1:20:::1:0:", -- Sweet Surprise
	[22240]=":14972:4:3:1:::1:0:", -- Greaves of Withering Despair
	[22241]=":15739:4:3:1:::1:0:", -- Dark Warder\'s Pauldrons
	[22242]=":11923:4:3:1:::1:0:", -- Verek\'s Leash
	[22243]=":250:1:2:1:::1:0:", -- Small Soul Pouch
	[22244]=":1000:1:2:1:::1:0:", -- Box of Souls
	[22245]=":12375:4:3:1:::1:0:", -- Soot Encrusted Footwear
	[22246]=":2500:1:2:1:::1:0:", -- Enchanted Mageweave Pouch
	[22247]=":16087:4:3:1:::1:0:", -- Faith Healer\'s Boots
	[22248]=":10000:1:2:1:::1:0:", -- Enchanted Runecloth Bag
	[22249]=":30000:1:2:1:::1:0:", -- Big Bag of Enchantment
	[22250]="1000:250:1:2:1:::1:0:3405,5503,3548,16367,5138,4615,4216,4899", -- Herb Pouch
	[22251]=":10000:1:2:1:::1:0:", -- Cenarion Herb Bag
	[22252]=":30000:1:2:1:::1:0:", -- Satchel of Cenarius
	[22253]=":34450:4:3:1:::1:0:", -- Tome of the Lost
	[22254]=":30655:2:3:1:::1:0:", -- Wand of Eternal Light
	[22255]=":32802:4:3:1:::1:0:", -- Magma Forged Band
	[22256]=":8236:4:3:1:::1:0:", -- Mana Shaping Handwraps
	[22257]=":36127:4:3:1:::1:0:", -- Bloodclot Band
	[22259]="::0:1:10:::1:0:", -- Unbestowed Friendship Bracelet
	[22260]="::15:1:100:::1:0:", -- Friendship Bracelet
	[22261]="::15:1:10:::1:0:", -- Love Fool
	[22262]="::15:1:1:::1:0:", -- Alliance Gift Collection
	[22263]="::15:1:1:::1:0:", -- Horde Gift Collection
	[22264]="::15:1:1:::1:0:", -- Carefully Written Letter
	[22265]="::15:1:1:::1:0:", -- Lovingly Composed Letter
	[22266]=":43878:2:3:1:::1:0:", -- Flarethorn
	[22267]=":16084:4:3:1:::1:0:", -- Spellweaver\'s Turban
	[22268]=":66290:4:3:1:::1:0:", -- Draconic Infused Emblem
	[22269]=":16199:4:3:1:::1:0:", -- Shadow Prowler\'s Cloak
	[22270]=":20755:4:3:1:::1:0:", -- Entrenching Boots
	[22271]=":22328:4:3:1:::1:0:", -- Leggings of Frenzied Magic
	[22272]=":15152:4:3:1:::1:0:", -- Forest\'s Embrace
	[22274]=":15270:4:3:1:::1:0:", -- Grizzled Pelt
	[22275]=":15383:4:3:1:::1:0:", -- Firemoss Boots
	[22276]=":1:4:1:1:::1:0:", -- Lovely Red Dress
	[22277]=":1:4:1:1:::1:0:", -- Red Dinner Suit
	[22278]=":1:4:1:1:::1:0:", -- Lovely Blue Dress
	[22279]=":1:4:1:1:::1:0:", -- Lovely Black Dress
	[22280]=":1:4:1:1:::1:0:", -- Lovely Purple Dress
	[22281]=":1:4:1:1:::1:0:", -- Blue Dinner Suit
	[22282]=":1:4:1:1:::1:0:", -- Purple Dinner Suit
	[22283]="::15:1:1:::1:0:", -- Sack of Homemade Bread
	[22284]="::15:1:1:::1:0:", -- Bundle of Cards
	[22285]="::15:1:1:::1:0:", -- Stormwind Pledge Collection
	[22286]="::15:1:1:::1:0:", -- Ironforge Pledge Collection
	[22287]="::15:1:1:::1:0:", -- Parcel of Cards
	[22288]="::15:1:1:::1:0:", -- Case of Homebrew
	[22289]="::15:1:1:::1:0:", -- Stack of Cards
	[22290]="::15:1:1:::1:0:", -- Darnassus Pledge Collection
	[22291]="::15:1:1:::1:0:", -- Box of Woodcrafts
	[22292]="::15:1:1:::1:0:", -- Box of Fresh Pies
	[22293]="::15:1:1:::1:0:", -- Package of Cards
	[22294]="::15:1:1:::1:0:", -- Orgrimmar Pledge Collection
	[22295]="::15:1:1:::1:0:", -- Satchel of Cards
	[22296]="::15:1:1:::1:0:", -- Basket of Flowers
	[22297]="::15:1:1:::1:0:", -- Thunder Bluff Pledge Collection
	[22298]="::15:1:1:::1:0:", -- Book of Romantic Poems
	[22299]="::15:1:1:::1:0:", -- Sheaf of Cards
	[22300]="::15:1:1:::1:0:", -- Undercity Pledge Collection
	[22301]=":20983:4:3:1:::1:0:", -- Ironweave Robe
	[22302]=":15795:4:3:1:::1:0:", -- Ironweave Cowl
	[22303]=":20853:4:3:1:::1:0:", -- Ironweave Pants
	[22304]=":10322:4:3:1:::1:0:", -- Ironweave Gloves
	[22305]=":15538:4:3:1:::1:0:", -- Ironweave Mantle
	[22306]=":10396:4:3:1:::1:0:", -- Ironweave Belt
	[22307]="6000:1500:9:1:1:::1:0:19663,3346,19537,3012,19234,18773,15419,1318,4228,19540,4617,5158,5757,16635,16722,18753,18951,5758", -- Pattern: Enchanted Mageweave Pouch
	[22308]="20000:5000:9:1:1:::1:0:15419", -- Pattern: Enchanted Runecloth Bag
	[22309]=":12500:9:2:1:::1:0:", -- Pattern: Big Bag of Enchantment
	[22310]="20000:5000:9:1:1:::1:0:15179", -- Pattern: Cenarion Herb Bag
	[22311]=":14758:4:3:1:::1:0:", -- Ironweave Boots
	[22312]="50000:12500:9:1:1:::1:0:15179", -- Pattern: Satchel of Cenarius
	[22313]=":9912:4:3:1:::1:0:", -- Ironweave Bracers
	[22314]=":62189:2:3:1:::1:0:", -- Huntsman\'s Harpoon
	[22315]=":49937:2:3:1:::1:0:", -- Hammer of Revitalization
	[22317]=":50306:2:3:1:::1:0:", -- Lefty\'s Brass Knuckle
	[22318]=":37869:2:3:1:::1:0:", -- Malgen\'s Long Bow
	[22319]=":38664:4:3:1:::1:0:", -- Tome of Divine Right
	[22320]=":12:15:1:1:::1:0:", -- Mux\'s Quality Goods
	[22321]=":10539:4:3:1:::1:0:", -- Heart of Wyrmthalak
	[22322]=":51234:2:3:1:::1:0:", -- The Jaw Breaker
	[22324]="4000:200:0:1:20:::5:0:11118", -- Winter Kimchi
	[22325]=":12019:4:3:1:::1:0:", -- Belt of the Trickster
	[22326]=":15282:4:3:1:::1:0:", -- Amalgam\'s Band
	[22327]=":2535:4:3:1:::1:0:", -- Amulet of the Redeemed
	[22328]=":34980:4:3:1:::1:0:", -- Legplates of Vigilance
	[22329]=":34450:4:3:1:::1:0:", -- Scepter of Interminable Focus
	[22330]=":14701:4:3:1:::1:0:", -- Shroud of Arcane Mastery
	[22331]=":36253:4:3:1:::1:0:", -- Band of the Steadfast Hero
	[22332]=":50053:2:3:1:::1:0:", -- Blade of Necromancy
	[22333]=":62803:2:3:1:::1:0:", -- Hammer of Divine Might
	[22334]=":13782:4:3:1:::1:0:", -- Band of Mending
	[22335]=":64130:2:3:1:::1:0:", -- Lord Valthalak\'s Staff of Command
	[22336]=":32957:4:3:1:::1:0:", -- Draconian Aegis of the Legion
	[22337]=":15506:4:3:1:::1:0:", -- Shroud of Domination
	[22338]="::12:1:30:::1:0:", -- Volcanic Ash
	[22339]=":15282:4:3:1:::1:0:", -- Rune Band of Wizardry
	[22340]=":65328:4:3:1:::1:0:", -- Pendant of Celerity
	[22342]=":21605:4:3:1:::1:0:", -- Leggings of Torment
	[22343]=":16260:4:3:1:::1:0:", -- Handguards of Savagery
	[22344]="::15:1:1:::1:0:", -- Brazier of Invocation: User\'s Manual
	[22345]=":14620:4:3:1:::1:0:", -- Totem of Rebirth
	[22347]=":38332:2:3:1:::1:0:", -- Fahrad\'s Reloading Repeater
	[22348]=":64134:2:3:1:::1:0:", -- Doomulus Prime
	[22349]="::15:4:1:::1:0:", -- Desecrated Breastplate
	[22350]="::15:4:1:::1:0:", -- Desecrated Tunic
	[22351]="::15:4:1:::1:0:", -- Desecrated Robe
	[22352]="::15:4:1:::1:0:", -- Desecrated Legplates
	[22353]="::15:4:1:::1:0:", -- Desecrated Helmet
	[22354]="::15:4:1:::1:0:", -- Desecrated Pauldrons
	[22355]="::15:4:1:::1:0:", -- Desecrated Bracers
	[22356]="::15:4:1:::1:0:", -- Desecrated Waistguard
	[22357]="::15:4:1:::1:0:", -- Desecrated Gauntlets
	[22358]="::15:4:1:::1:0:", -- Desecrated Sabatons
	[22359]="::15:4:1:::1:0:", -- Desecrated Legguards
	[22360]="::15:4:1:::1:0:", -- Desecrated Headpiece
	[22361]="::15:4:1:::1:0:", -- Desecrated Spaulders
	[22362]="::15:4:1:::1:0:", -- Desecrated Wristguards
	[22363]="::15:4:1:::1:0:", -- Desecrated Girdle
	[22364]="::15:4:1:::1:0:", -- Desecrated Handguards
	[22365]="::15:4:1:::1:0:", -- Desecrated Boots
	[22366]="::15:4:1:::1:0:", -- Desecrated Leggings
	[22367]="::15:4:1:::1:0:", -- Desecrated Circlet
	[22368]="::15:4:1:::1:0:", -- Desecrated Shoulderpads
	[22369]="::15:4:1:::1:0:", -- Desecrated Bindings
	[22370]="::15:4:1:::1:0:", -- Desecrated Belt
	[22371]="::15:4:1:::1:0:", -- Desecrated Gloves
	[22372]="::15:4:1:::1:0:", -- Desecrated Sandals
	[22373]="::12:3:200:::1:0:", -- Wartorn Leather Scrap
	[22374]="::12:3:200:::1:0:", -- Wartorn Chain Scrap
	[22375]="::12:3:200:::1:0:", -- Wartorn Plate Scrap
	[22376]="::12:3:200:::1:0:", -- Wartorn Cloth Scrap
	[22377]=":54468:2:3:1:::1:0:", -- The Thunderwood Poker
	[22378]=":54665:2:3:1:::1:0:", -- Ravenholdt Slicer
	[22379]=":54862:2:3:1:::1:0:", -- Shivsprocket\'s Shiv
	[22380]=":55053:2:3:1:::1:0:", -- Simone\'s Cultivating Hammer
	[22381]="::12:1:20:::1:0:", -- Silithus Venom Sample
	[22382]="::12:1:1:::1:0:", -- Sealed Venom Container
	[22383]=":73223:2:4:1:::1:0:", -- Sageblade
	[22384]=":72503:2:4:1:::1:0:", -- Persuader
	[22385]=":44234:4:4:1:::1:0:", -- Titanic Leggings
	[22388]=":15000:9:4:1:::1:0:", -- Plans: Titanic Leggings
	[22389]=":20000:9:4:1:::1:0:", -- Plans: Sageblade
	[22390]=":20000:9:4:1:::1:0:", -- Plans: Persuader
	[22392]="25000:6250:9:1:1:::1:0:11557", -- Formula: Enchant 2H Weapon - Agility
	[22393]=":14750:9:3:1:::1:0:", -- Codex: Prayer of Shadow Protection
	[22394]=":64707:2:3:1:::1:0:", -- Staff of Metanoia
	[22395]=":12973:4:3:1:::1:0:", -- Totem of Rage
	[22396]=":25392:4:4:1:::1:0:", -- Totem of Life
	[22397]=":13067:4:3:1:::1:0:", -- Idol of Ferocity
	[22398]=":15755:4:3:1:::1:0:", -- Idol of Rejuvenation
	[22399]=":25666:4:4:1:::1:0:", -- Idol of Health
	[22400]=":13208:4:3:1:::1:0:", -- Libram of Truth
	[22401]=":15924:4:3:1:::1:0:", -- Libram of Hope
	[22402]=":25942:4:4:1:::1:0:", -- Libram of Grace
	[22403]=":41953:4:3:1:::1:0:", -- Diana\'s Pearl Necklace
	[22404]=":52913:2:3:1:::1:0:", -- Willey\'s Back Scratcher
	[22405]=":14415:4:3:1:::1:0:", -- Mantle of the Scarlet Crusade
	[22406]=":61968:2:3:1:::1:0:", -- Redemption
	[22407]=":18658:4:3:1:::1:0:", -- Helm of the New Moon
	[22408]=":38489:2:3:1:::1:0:", -- Ritssyn\'s Wand of Bad Mojo
	[22409]=":25755:4:3:1:::1:0:", -- Tunic of the Crescent Moon
	[22410]=":15509:4:3:1:::1:0:", -- Gauntlets of Deftness
	[22411]=":27190:4:3:1:::1:0:", -- Helm of the Executioner
	[22412]=":15624:4:3:1:::1:0:", -- Thuzadin Mantle
	[22413]="::12:1:20:::1:0:", -- Sin\'dorei Armaments
	[22414]="::12:1:1:::1:0:", -- Antheol\'s Elemental Grimoire
	[22416]=":68505:4:4:1:::1:0:", -- Dreadnaught Breastplate
	[22417]=":66097:4:4:1:::1:0:", -- Dreadnaught Legplates
	[22418]=":49653:4:4:1:::1:0:", -- Dreadnaught Helmet
	[22419]=":48830:4:4:1:::1:0:", -- Dreadnaught Pauldrons
	[22420]=":49006:4:4:1:::1:0:", -- Dreadnaught Sabatons
	[22421]=":33715:4:4:1:::1:0:", -- Dreadnaught Gauntlets
	[22422]=":31441:4:4:1:::1:0:", -- Dreadnaught Waistguard
	[22423]=":31561:4:4:1:::1:0:", -- Dreadnaught Bracers
	[22424]=":31681:4:4:1:::1:0:", -- Redemption Wristguards
	[22425]=":65783:4:4:1:::1:0:", -- Redemption Tunic
	[22426]=":31919:4:4:1:::1:0:", -- Redemption Handguards
	[22427]=":63714:4:4:1:::1:0:", -- Redemption Legguards
	[22428]=":47873:4:4:1:::1:0:", -- Redemption Headpiece
	[22429]=":47082:4:4:1:::1:0:", -- Redemption Spaulders
	[22430]=":47257:4:4:1:::1:0:", -- Redemption Boots
	[22431]=":32516:4:4:1:::1:0:", -- Redemption Girdle
	[22432]="::12:1:20:::1:0:", -- Devilsaur Barb
	[22433]=":15282:4:3:1:::1:0:", -- Don Mauricio\'s Band of Domination
	[22434]="::15:1:10:::1:0:", -- Bloodcap
	[22435]="::15:1:10:::1:0:", -- Gorishi Sting
	[22436]=":58712:4:4:1:::1:0:", -- Cryptstalker Tunic
	[22437]=":56644:4:4:1:::1:0:", -- Cryptstalker Legguards
	[22438]=":39580:4:4:1:::1:0:", -- Cryptstalker Headpiece
	[22439]=":39109:4:4:1:::1:0:", -- Cryptstalker Spaulders
	[22440]=":39260:4:4:1:::1:0:", -- Cryptstalker Boots
	[22441]=":26691:4:4:1:::1:0:", -- Cryptstalker Handguards
	[22442]=":26794:4:4:1:::1:0:", -- Cryptstalker Girdle
	[22443]=":26896:4:4:1:::1:0:", -- Cryptstalker Wristguards
	[22444]="::15:1:10:::1:0:", -- Putrid Vine
	[22445]="::7:1:20::164,333,202,165,197:1:0:", -- Arcane Dust
	[22446]="::7:2:10::333,197:1:0:", -- Greater Planar Essence
	[22447]="::7:2:10::333:1:0:", -- Lesser Planar Essence
	[22448]="::7:3:20::333,202,165:1:0:", -- Small Prismatic Shard
	[22449]="::7:3:20::164,333,202:1:0:", -- Large Prismatic Shard
	[22450]="::7:4:20::164,333,165,197:1:0:", -- Void Crystal
	[22451]=":4000:7:2:20::171,164,333,202,755,165,197:1:0:", -- Primal Air
	[22452]=":4000:7:2:20::171,164,333,202,755,165,186,197:1:0:", -- Primal Earth
	[22456]=":4000:7:2:20::171,164,333,202,755,165,197:1:0:", -- Primal Shadow
	[22457]=":4000:7:2:20::171,164,333,202,755,165,197:1:0:", -- Primal Mana
	[22458]=":37892:2:3:1:::1:0:", -- Moonshadow Stave
	[22459]="::3:4:1:::1:0:", -- Void Sphere
	[22460]="::3:3:1:::1:0:", -- Prismatic Sphere
	[22461]=":1250:7:1:1::333:1:0:", -- Runed Fel Iron Rod
	[22462]=":32000:7:2:1::333:1:0:", -- Runed Adamantite Rod
	[22463]=":40000:7:3:1:::1:0:", -- Runed Eternium Rod
	[22464]=":56155:4:4:1:::1:0:", -- Earthshatter Tunic
	[22465]=":54191:4:4:1:::1:0:", -- Earthshatter Legguards
	[22466]=":40797:4:4:1:::1:0:", -- Earthshatter Headpiece
	[22467]=":40302:4:4:1:::1:0:", -- Earthshatter Spaulders
	[22468]=":40453:4:4:1:::1:0:", -- Earthshatter Boots
	[22469]=":27502:4:4:1:::1:0:", -- Earthshatter Handguards
	[22470]=":28338:4:4:1:::1:0:", -- Earthshatter Girdle
	[22471]=":28438:4:4:1:::1:0:", -- Earthshatter Wristguards
	[22472]=":19500:4:3:1:::1:0:", -- Boots of Ferocity
	[22473]="::12:1:1:::1:0:", -- Antheol\'s Disciplinary Rod
	[22476]=":50184:4:4:1:::1:0:", -- Bonescythe Breastplate
	[22477]=":48416:4:4:1:::1:0:", -- Bonescythe Legplates
	[22478]=":32973:4:4:1:::1:0:", -- Bonescythe Helmet
	[22479]=":32436:4:4:1:::1:0:", -- Bonescythe Pauldrons
	[22480]=":32562:4:4:1:::1:0:", -- Bonescythe Sabatons
	[22481]=":22238:4:4:1:::1:0:", -- Bonescythe Gauntlets
	[22482]=":22321:4:4:1:::1:0:", -- Bonescythe Waistguard
	[22483]=":22406:4:4:1:::1:0:", -- Bonescythe Bracers
	[22484]="::15:2:250:::1:0:", -- Necrotic Rune
	[22487]="::12:1:1:::1:0:", -- Aldaron\'s Head
	[22488]=":48769:4:4:1:::1:0:", -- Dreamwalker Tunic
	[22489]=":47055:4:4:1:::1:0:", -- Dreamwalker Legguards
	[22490]=":35416:4:4:1:::1:0:", -- Dreamwalker Headpiece
	[22491]=":34830:4:4:1:::1:0:", -- Dreamwalker Spaulders
	[22492]=":34955:4:4:1:::1:0:", -- Dreamwalker Boots
	[22493]=":23864:4:4:1:::1:0:", -- Dreamwalker Handguards
	[22494]=":23950:4:4:1:::1:0:", -- Dreamwalker Girdle
	[22495]=":24035:4:4:1:::1:0:", -- Dreamwalker Wristguards
	[22496]=":40143:4:4:1:::1:0:", -- Frostfire Robe
	[22497]=":38726:4:4:1:::1:0:", -- Frostfire Leggings
	[22498]=":26376:4:4:1:::1:0:", -- Frostfire Circlet
	[22499]=":25946:4:4:1:::1:0:", -- Frostfire Shoulderpads
	[22500]=":26046:4:4:1:::1:0:", -- Frostfire Sandals
	[22501]=":17787:4:4:1:::1:0:", -- Frostfire Gloves
	[22502]=":18344:4:4:1:::1:0:", -- Frostfire Belt
	[22503]=":18412:4:4:1:::1:0:", -- Frostfire Bindings
	[22504]=":38446:4:4:1:::1:0:", -- Plagueheart Robe
	[22505]=":37094:4:4:1:::1:0:", -- Plagueheart Leggings
	[22506]=":27923:4:4:1:::1:0:", -- Plagueheart Circlet
	[22507]=":27462:4:4:1:::1:0:", -- Plagueheart Shoulderpads
	[22508]=":27560:4:4:1:::1:0:", -- Plagueheart Sandals
	[22509]=":18818:4:4:1:::1:0:", -- Plagueheart Gloves
	[22510]=":18886:4:4:1:::1:0:", -- Plagueheart Belt
	[22511]=":18955:4:4:1:::1:0:", -- Plagueheart Bindings
	[22512]=":39571:4:4:1:::1:0:", -- Robe of Faith
	[22513]=":38179:4:4:1:::1:0:", -- Leggings of Faith
	[22514]=":28737:4:4:1:::1:0:", -- Circlet of Faith
	[22515]=":28260:4:4:1:::1:0:", -- Shoulderpads of Faith
	[22516]=":28358:4:4:1:::1:0:", -- Sandals of Faith
	[22517]=":19361:4:4:1:::1:0:", -- Gloves of Faith
	[22518]=":18071:4:4:1:::1:0:", -- Belt of Faith
	[22519]=":18139:4:4:1:::1:0:", -- Bindings of Faith
	[22520]="::15:4:1:::1:0:", -- The Phylactery of Kel\'Thuzad
	[22521]=":1500:0:1:1:::1:0:", -- Superior Mana Oil
	[22522]=":1500:0:1:1:::1:0:", -- Superior Wizard Oil
	[22523]="::15:2:250:::1:0:", -- Insignia of the Dawn
	[22524]="::15:2:250:::1:0:", -- Insignia of the Crusade
	[22525]=":200:12:1:250:::1:0:", -- Crypt Fiend Parts
	[22526]=":200:12:1:250:::1:0:", -- Bone Fragments
	[22527]=":200:12:1:250:::1:0:", -- Core of Elements
	[22528]=":200:12:1:250:::1:0:", -- Dark Iron Scraps
	[22529]=":200:12:1:250:::1:0:", -- Savage Frond
	[22530]=":15000:9:2:1:::1:0:", -- Formula: Enchant Bracer - Major Defense
	[22531]="60000:15000:9:1:1:::1:0:17657", -- Formula: Enchant Bracer - Superior Healing
	[22532]=":15000:9:2:1:::1:0:", -- Formula: Enchant Bracer - Restore Mana Prime
	[22533]=":15000:9:2:1:::1:0:", -- Formula: Enchant Bracer - Fortitude
	[22534]=":20000:9:2:1:::1:0:", -- Formula: Enchant Bracer - Spellpower
	[22535]="100000:25000:9:1:1:::1:0:17518", -- Formula: Enchant Ring - Striking
	[22536]="100000:25000:9:1:1:::1:0:21643", -- Formula: Enchant Ring - Spellpower
	[22537]="100000:25000:9:1:1:::1:0:21432", -- Formula: Enchant Ring - Healing Power
	[22538]="200000:50000:9:1:1:::1:0:21655", -- Formula: Enchant Ring - Stats
	[22539]="60000:15000:9:1:1:::1:0:18664", -- Formula: Enchant Shield - Intellect
	[22540]=":15000:9:2:1:::1:0:", -- Formula: Enchant Shield - Shield Block
	[22541]=":20000:9:2:1:::1:0:", -- Formula: Enchant Shield - Resistance
	[22542]=":10000:9:2:1:::1:0:", -- Formula: Enchant Boots - Vitality
	[22543]=":15000:9:2:1:::1:0:", -- Formula: Enchant Boots - Fortitude
	[22544]=":15000:9:2:1:::1:0:", -- Formula: Enchant Boots - Dexterity
	[22545]=":15000:9:2:1:::1:0:", -- Formula: Enchant Boots - Surefooted
	[22547]="60000:15000:9:1:1:::1:0:17657", -- Formula: Enchant Chest - Exceptional Stats
	[22548]=":15000:9:2:1:::1:0:", -- Formula: Enchant Cloak - Major Resistance
	[22549]="::12:1:1:::1:0:", -- Quartermaster Lymel\'s Bill of Lading
	[22550]="::12:1:1:::1:0:", -- Quartermaster Lymel\'s Goods
	[22551]=":15000:9:2:1:::1:0:", -- Formula: Enchant Weapon - Major Intellect
	[22552]="60000:15000:9:1:1:::1:0:23007,20242", -- Formula: Enchant Weapon - Major Striking
	[22553]=":20000:9:2:1:::1:0:", -- Formula: Enchant Weapon - Potency
	[22554]=":15000:9:2:1:::1:0:", -- Formula: Enchant 2H Weapon - Savagery
	[22555]=":20000:9:2:1:::1:0:", -- Formula: Enchant Weapon - Major Spellpower
	[22556]=":15000:9:2:1:::1:0:", -- Formula: Enchant 2H Weapon - Major Agility
	[22557]=":25000:9:2:1:::1:0:", -- Formula: Enchant Weapon - Battlemaster
	[22558]=":25000:9:2:1:::1:0:", -- Formula: Enchant Weapon - Spellsurge
	[22559]=":15000:9:3:1:::1:0:", -- Formula: Enchant Weapon - Mongoose
	[22560]=":15000:9:3:1:::1:0:", -- Formula: Enchant Weapon - Sunfire
	[22561]=":15000:9:3:1:::1:0:", -- Formula: Enchant Weapon - Soulfrost
	[22562]="50000:12500:9:1:1:::1:0:19663,16722,16635", -- Formula: Superior Mana Oil
	[22563]="70000:17500:9:1:1:::1:0:19663,16722,16635", -- Formula: Superior Wizard Oil
	[22565]="60000:15000:9:1:1:::1:0:19663,16722,16635", -- Formula: Large Prismatic Shard
	[22566]="::12:1:20:::1:0:", -- Phantasmal Substance
	[22567]="::12:1:20:::1:0:", -- Gargoyle Fragment
	[22568]="::15:1:1:::1:0:", -- Sealed Craftsman\'s Writ
	[22570]="::12:1:20:::1:0:", -- Plagued Blood Sample
	[22571]=":62:1:1:1:::1:0:", -- Courier\'s Bag
	[22572]="1600:400:7:1:10::333:1:0:14847,20981,20986", -- Mote of Air
	[22573]="1600:400:7:1:10::171,164,333,202:1:0:14847,20981,20986", -- Mote of Earth
	[22574]="1600:400:7:1:10::171,333,202:1:0:14847,20981,20986", -- Mote of Fire
	[22575]="1600:400:7:1:10:::1:0:14847,20981,20986", -- Mote of Life
	[22576]="1600:400:7:1:10:::1:0:14847,20981,20986", -- Mote of Mana
	[22577]="1600:400:7:1:10:::1:0:14847,20981,20986", -- Mote of Shadow
	[22578]="1600:400:7:1:10::171,333,755:1:0:14847,20981,20986", -- Mote of Water
	[22579]="::12:1:10:::1:0:", -- Plagued Murloc Spine
	[22580]="::12:1:20:::1:0:", -- Crystallized Mana Essence
	[22583]="::12:1:1:::1:0:", -- Rathis Tomber\'s Supplies
	[22589]=":184558:2:5:1:::1:0:", -- Atiesh, Greatstaff of the Guardian
	[22590]="::12:1:1:::1:0:", -- Night Elf Plans: An\'daroth
	[22591]="::12:1:1:::1:0:", -- Night Elf Plans: An\'owyn
	[22592]="::12:1:1:::1:0:", -- Night Elf Plans: Scrying on the Sin\'dorei
	[22593]="::15:1:1:::1:0:", -- Writ of Safe Passage
	[22594]="::12:1:1:::1:0:", -- Night Elf Plans
	[22595]="::15:1:1:::1:0:", -- Call to Arms Announcement
	[22597]="::12:1:1:::1:0:", -- The Lady\'s Necklace
	[22598]="::12:1:20:::1:0:", -- Stone of Light
	[22599]="::12:1:20:::1:0:", -- Stone of Flame
	[22600]="::12:1:1:::1:0:", -- Craftsman\'s Writ - Dense Weightstone
	[22601]="::12:1:1:::1:0:", -- Craftsman\'s Writ - Imperial Plate Chest
	[22602]="::12:1:1:::1:0:", -- Craftsman\'s Writ - Volcanic Hammer
	[22603]="::12:1:1:::1:0:", -- Craftsman\'s Writ - Huge Thorium Battleaxe
	[22604]="::12:1:1:::1:0:", -- Craftsman\'s Writ - Radiant Circlet
	[22605]="::12:1:1:::1:0:", -- Craftsman\'s Writ - Wicked Leather Headband
	[22606]="::12:1:1:::1:0:", -- Craftsman\'s Writ - Rugged Armor Kit
	[22607]="::12:1:1:::1:0:", -- Craftsman\'s Writ - Wicked Leather Belt
	[22608]="::12:1:1:::1:0:", -- Craftsman\'s Writ - Runic Leather Pants
	[22609]="::12:1:1:::1:0:", -- Craftsman\'s Writ - Brightcloth Pants
	[22610]="::12:1:1:::1:0:", -- Craftsman\'s Writ - Runecloth Boots
	[22611]="::12:1:1:::1:0:", -- Craftsman\'s Writ - Runecloth Bag
	[22612]="::12:1:1:::1:0:", -- Craftsman\'s Writ - Runecloth Robe
	[22613]="::12:1:1:::1:0:", -- Craftsman\'s Writ - Goblin Sapper Charge
	[22614]="::12:1:1:::1:0:", -- Craftsman\'s Writ - Thorium Grenade
	[22615]="::12:1:1:::1:0:", -- Craftsman\'s Writ - Gnomish Battle Chicken
	[22616]="::12:1:1:::1:0:", -- Craftsman\'s Writ - Thorium Tube
	[22617]="::12:1:1:::1:0:", -- Craftsman\'s Writ - Major Mana Potion
	[22618]="::12:1:1:::1:0:", -- Craftsman\'s Writ - Major Healing Potion
	[22620]="::12:1:1:::1:0:", -- Craftsman\'s Writ - Greater Arcane Protection Potion
	[22621]="::12:1:1:::1:0:", -- Craftsman\'s Writ - Flask of Petrification
	[22622]="::12:1:1:::1:0:", -- Craftsman\'s Writ - Stonescale Eel
	[22623]="::12:1:1:::1:0:", -- Craftsman\'s Writ - Plated Armorfish
	[22624]="::12:1:1:::1:0:", -- Craftsman\'s Writ - Lightning Eel
	[22627]="::12:1:1:::1:0:", -- The Lady\'s Necklace
	[22628]="::12:1:1:::1:0:", -- Renzithen\'s Restorative Draught
	[22629]="::12:1:1:::1:0:", -- Sealed Sin\'dorei Orders
	[22630]=":185158:2:5:1:::1:0:", -- Atiesh, Greatstaff of the Guardian
	[22631]=":172821:2:5:1:::1:0:", -- Atiesh, Greatstaff of the Guardian
	[22632]=":173474:2:5:1:::1:0:", -- Atiesh, Greatstaff of the Guardian
	[22633]="::12:1:20:::1:0:", -- Troll Juju
	[22634]="::12:1:20:::1:0:", -- Underlight Ore
	[22635]="::0:3:1:::1:0:", -- Savage Guard
	[22636]="::0:3:1:::1:0:", -- Ice Guard
	[22637]="::15:3:1:::1:0:", -- Primal Hakkari Idol
	[22638]="::0:3:1:::1:0:", -- Shadow Guard
	[22639]="::12:1:10:::1:0:", -- Zeb\'Sora Troll Ear
	[22640]="::12:1:1:::1:0:", -- Head of Kel\'gash the Wicked
	[22641]=":146:12:1:10:::1:0:", -- Rotting Heart
	[22642]=":146:12:1:10:::1:0:", -- Spinal Dust
	[22644]=":12:7:1:10::185:1:0:", -- Crunchy Spider Leg
	[22645]=":25:0:1:20:::1:0:", -- Crunchy Spider Surprise
	[22646]="::4:1:1:::1:0:", -- Master Spellstone
	[22647]="400:100:9:1:1:::1:0:18427,16253", -- Recipe: Crunchy Spider Surprise
	[22648]=":12:15:1:1:::1:0:", -- Hive\'Ashi Dossier
	[22649]=":12:15:1:1:::1:0:", -- Hive\'Regal Dossier
	[22650]=":12:15:1:1:::1:0:", -- Hive\'Zora Dossier
	[22651]="::4:4:1:::1:0:14754", -- Outrider\'s Plate Legguards
	[22652]=":33356:4:4:1:::1:0:", -- Glacial Vest
	[22653]="::12:1:1:::1:0:", -- Dar\'Khan\'s Head
	[22654]=":16804:4:4:1:::1:0:", -- Glacial Gloves
	[22655]=":16865:4:4:1:::1:0:", -- Glacial Wrists
	[22656]=":49612:2:4:1:::1:0:", -- The Purifier
	[22657]=":33625:4:4:1:::1:0:", -- Amulet of the Dawn
	[22658]=":25580:4:4:1:::1:0:", -- Glacial Cloak
	[22659]=":33625:4:4:1:::1:0:", -- Medallion of the Dawn
	[22660]=":17213:4:3:1:::1:0:", -- Gaea\'s Embrace
	[22661]=":43100:4:4:1:::1:0:", -- Polar Tunic
	[22662]=":21628:4:4:1:::1:0:", -- Polar Gloves
	[22663]=":22267:4:4:1:::1:0:", -- Polar Bracers
	[22664]=":48533:4:4:1:::1:0:", -- Icy Scale Breastplate
	[22665]=":24360:4:4:1:::1:0:", -- Icy Scale Bracers
	[22666]=":24455:4:4:1:::1:0:", -- Icy Scale Gauntlets
	[22667]=":12789:4:4:1:::1:0:", -- Bracers of Hope
	[22668]=":16048:4:4:1:::1:0:", -- Bracers of Subterfuge
	[22669]=":57715:4:4:1:::1:0:", -- Icebane Breastplate
	[22670]=":29130:4:4:1:::1:0:", -- Icebane Gauntlets
	[22671]=":29240:4:4:1:::1:0:", -- Icebane Bracers
	[22672]="::4:4:1:::1:0:14753", -- Sentinel\'s Plate Legguards
	[22673]="::4:4:1:::1:0:14754", -- Outrider\'s Chain Leggings
	[22674]="::12:1:8:::1:0:", -- Wavefront Medallion
	[22675]="::12:1:1:::1:0:", -- Bundle of Medallions
	[22676]="::4:4:1:::1:0:14754", -- Outrider\'s Mail Leggings
	[22677]="::12:1:5:::1:0:", -- Catlord Claws
	[22678]=":111303:4:4:1:::1:0:", -- Talisman of Ascendance
	[22679]=":8750:1:3:1:::1:0:", -- Supply Bag
	[22680]=":10709:4:3:1:::1:0:", -- Band of Resolution
	[22681]=":10709:4:3:1:::1:0:", -- Band of Piety
	[22682]=":20000:7:3:20::164,165,197:1:0:", -- Frozen Rune
	[22683]="90000:22500:9:1:1:::1:0:15179", -- Pattern: Gaea\'s Embrace
	[22688]=":52177:2:3:1:::1:0:", -- Verimonde\'s Last Resort
	[22689]=":19639:4:3:1:::1:0:", -- Sanctified Leather Helm
	[22690]=":31542:4:3:1:::1:0:", -- Leggings of the Plague Hunter
	[22691]=":110631:2:4:1:::1:0:", -- Corrupted Ashbringer
	[22693]="::12:1:1:::1:0:", -- Infused Crystal
	[22699]=":61463:4:4:1:::1:0:", -- Icebane Leggings
	[22700]=":35244:4:4:1:::1:0:", -- Glacial Leggings
	[22701]=":44212:4:4:1:::1:0:", -- Polar Leggings
	[22702]=":53243:4:4:1:::1:0:", -- Icy Scale Leggings
	[22706]="::12:1:1:::1:0:", -- Dar\'Khan\'s Journal
	[22707]=":98660:4:4:1:::1:0:", -- Ramaladni\'s Icy Grasp
	[22708]="::12:1:1:::1:0:", -- Fate of Ramaladni
	[22710]=":30:7:1:20:::1:0:", -- Bloodthistle
	[22711]=":22162:4:3:1:::1:0:", -- Cloak of the Hakkari Worshippers
	[22712]=":16737:4:3:1:::1:0:", -- Might of the Tribe
	[22713]=":55994:2:3:1:::1:0:", -- Zulian Scepter of Rites
	[22714]=":19782:4:3:1:::1:0:", -- Sacrificial Gauntlets
	[22715]=":16919:4:3:1:::1:0:", -- Gloves of the Tormented
	[22716]=":11320:4:3:1:::1:0:", -- Belt of Untapped Power
	[22717]="::12:1:1:::1:0:", -- Letter from Silvermoon
	[22718]=":21379:4:3:1:::1:0:", -- Blooddrenched Mask
	[22719]="::15:1:1:::1:0:", -- Omarion\'s Handbook
	[22720]=":17224:4:3:1:::1:0:", -- Zulian Headdress
	[22721]=":64030:4:4:1:::1:0:", -- Band of Servitude
	[22722]=":64030:4:4:1:::1:0:", -- Seal of the Gurubashi Berserker
	[22723]="::12:1:1:::1:0:", -- A Letter from the Keeper of the Rolls
	[22725]=":38790:4:3:1:::1:0:", -- Band of Cenarius
	[22726]="::15:5:40:::1:0:", -- Splinter of Atiesh
	[22727]="::15:5:1:::1:0:", -- Frame of Atiesh
	[22728]=":5000:15:1:1:::1:0:", -- Steam Tonk Controller
	[22729]="8000:2000:9:1:1:::1:0:3413,5175", -- Schematic: Steam Tonk Controller
	[22730]=":18480:4:4:1:::1:0:", -- Eyestalk Waist Cord
	[22731]=":27821:4:4:1:::1:0:", -- Cloak of the Devoured
	[22732]=":86443:4:4:1:::1:0:", -- Mark of C\'Thun
	[22733]="::12:1:1:::1:0:", -- Staff Head of Atiesh
	[22734]="::12:1:1:::1:0:", -- Base of Atiesh
	[22735]="::12:1:1:::1:0:", -- Research Notes
	[22737]="::15:5:1:::1:0:", -- Atiesh, Greatstaff of the Guardian
	[22739]=":14750:9:3:1:::1:0:", -- Tome of Polymorph: Turtle
	[22740]="::4:4:1:::1:0:14754", -- Outrider\'s Leather Pants
	[22741]="::4:4:1:::1:0:14754", -- Outrider\'s Lizardhide Pants
	[22742]=":1:4:1:1:::1:0:", -- Bloodsail Shirt
	[22743]=":1:15:1:1:::1:0:", -- Bloodsail Sash
	[22744]=":1:4:1:1:::1:0:", -- Bloodsail Boots
	[22745]=":1:4:1:1:::1:0:", -- Bloodsail Pants
	[22746]=":12:15:1:1:::1:0:", -- Buccaneer\'s Uniform
	[22747]="::4:4:1:::1:0:14754", -- Outrider\'s Silk Leggings
	[22748]="::4:4:1:::1:0:14753", -- Sentinel\'s Chain Leggings
	[22749]="::4:4:1:::1:0:14753", -- Sentinel\'s Leather Pants
	[22750]="::4:4:1:::1:0:14753", -- Sentinel\'s Lizardhide Pants
	[22752]="::4:4:1:::1:0:14753", -- Sentinel\'s Silk Leggings
	[22753]="::4:4:1:::1:0:14753", -- Sentinel\'s Lamellar Legguards
	[22754]="::12:1:1:::1:0:", -- Eternal Quintessence
	[22755]="::12:1:1:::1:0:", -- Blazing Torch
	[22756]=":23205:4:3:1:::1:0:", -- Sylvan Vest
	[22757]=":17465:4:3:1:::1:0:", -- Sylvan Crown
	[22758]=":17528:4:3:1:::1:0:", -- Sylvan Shoulders
	[22759]=":20424:4:3:1:::1:0:", -- Bramblewood Helm
	[22760]=":20503:4:3:1:::1:0:", -- Bramblewood Boots
	[22761]=":13719:4:3:1:::1:0:", -- Bramblewood Belt
	[22762]=":38562:4:3:1:::1:0:", -- Ironvine Breastplate
	[22763]=":19465:4:3:1:::1:0:", -- Ironvine Gloves
	[22764]=":19537:4:3:1:::1:0:", -- Ironvine Belt
	[22766]="50000:12500:9:1:1:::1:0:15176", -- Plans: Ironvine Breastplate
	[22767]="50000:12500:9:1:1:::1:0:15176", -- Plans: Ironvine Gloves
	[22768]="50000:12500:9:1:1:::1:0:15176", -- Plans: Ironvine Belt
	[22769]="50000:12500:9:1:1:::1:0:15293", -- Pattern: Bramblewood Belt
	[22770]="50000:12500:9:1:1:::1:0:15293", -- Pattern: Bramblewood Boots
	[22771]="50000:12500:9:1:1:::1:0:15293", -- Pattern: Bramblewood Helm
	[22772]="50000:12500:9:1:1:::1:0:15179", -- Pattern: Sylvan Shoulders
	[22773]="50000:12500:9:1:1:::1:0:15179", -- Pattern: Sylvan Crown
	[22774]="50000:12500:9:1:1:::1:0:15179", -- Pattern: Sylvan Vest
	[22775]="300:75:12:1:1:::1:0:16442", -- Suntouched Special Reserve
	[22776]="100:25:12:1:1:::1:0:16443", -- Springpaw Appetizers
	[22777]="150:37:12:1:1:::1:0:16444", -- Bundle of Fireworks
	[22778]=":700:0:1:5:::1:0:", -- Scourgebane Infusion
	[22779]=":700:0:1:5:::1:0:", -- Scourgebane Draught
	[22783]=":1387:2:2:1:::1:0:", -- Sunwell Blade
	[22784]=":802:4:2:1:::1:0:", -- Sunwell Orb
	[22785]="2000:500:7:1:20::171:1:0:20989,24975", -- Felweed
	[22786]="2000:500:7:1:20::171:1:0:20989,24975", -- Dreaming Glory
	[22787]="2400:600:7:1:20::171:1:0:14846", -- Ragveil
	[22788]=":750:7:1:20:::1:0:", -- Flame Cap
	[22789]="2000:500:7:1:20::171:1:0:14846", -- Terocone
	[22790]="3000:750:7:1:20::171:1:0:14846", -- Ancient Lichen
	[22791]="4000:1000:7:1:20::171,333:1:0:20989,24975,14846", -- Netherbloom
	[22792]="5000:1250:7:1:20::171,333:1:0:14846", -- Nightmare Vine
	[22793]="10000:2500:7:1:20::171:1:0:20989,24975,14846", -- Mana Thistle
	[22794]="40000:10000:7:1:20::171,333,197:1:0:14846", -- Fel Lotus
	[22795]="::0:1:20:::1:0:", -- Fel Blossom
	[22796]="::12:1:1:::1:0:", -- Apothecary\'s Poison
	[22797]=":1250:7:1:20:::1:0:", -- Nightmare Seed
	[22798]=":111458:2:4:1:::1:0:", -- Might of Menethil
	[22799]=":111889:2:4:1:::1:0:", -- Soulseeker
	[22800]=":105618:2:4:1:::1:0:", -- Brimstone Staff
	[22801]=":106023:2:4:1:::1:0:", -- Spire of Twilight
	[22802]=":90536:2:4:1:::1:0:", -- Kingsfall
	[22803]=":83651:2:4:1:::1:0:", -- Midnight Haze
	[22804]=":85783:2:4:1:::1:0:", -- Maexxna\'s Fang
	[22806]=":84594:2:4:1:::1:0:", -- Widow\'s Remorse
	[22807]=":86747:2:4:1:::1:0:", -- Wraith Blade
	[22808]=":89393:2:4:1:::1:0:", -- The Castigator
	[22809]=":112147:2:4:1:::1:0:", -- Maul of the Redeemed Crusader
	[22810]=":66096:2:4:1:::1:0:", -- Toxin Injector
	[22811]=":67768:2:4:1:::1:0:", -- Soulstring
	[22812]=":72327:2:4:1:::1:0:", -- Nerubian Slavemaker
	[22813]=":111341:2:4:1:::1:0:", -- Claymore of Unholy Might
	[22815]=":112134:2:4:1:::1:0:", -- Severance
	[22816]=":91970:2:4:1:::1:0:", -- Hatchet of Sundered Bone
	[22818]=":53656:4:4:1:::1:0:", -- The Plague Bearer
	[22819]=":58990:4:4:1:::1:0:", -- Shield of Condemnation
	[22820]=":63364:2:4:1:::1:0:", -- Wand of Fates
	[22821]=":69654:2:4:1:::1:0:", -- Doomfinger
	[22823]=":2500:0:1:20:::1:0:", -- Elixir of Camouflage
	[22824]=":2500:0:1:20::164,333:1:0:", -- Elixir of Major Strength
	[22825]=":2500:0:1:20:::1:0:", -- Elixir of Healing Power
	[22826]=":2500:0:1:5:::1:0:", -- Sneaking Potion
	[22827]=":2500:0:1:20:::1:0:", -- Elixir of Major Frost Power
	[22828]=":2500:0:1:5:::1:0:", -- Insane Strength Potion
	[22829]="20000:5000:0:1:5::202:1:0:14847,20989,26304", -- Super Healing Potion
	[22830]=":4000:0:1:20:::1:0:", -- Elixir of the Searching Eye
	[22831]=":4000:0:1:20::164:1:0:", -- Elixir of Major Agility
	[22832]="20000:5000:0:1:5::202:1:0:14847,20989,26304", -- Super Mana Potion
	[22833]=":2500:0:1:20:::1:0:", -- Elixir of Major Firepower
	[22834]=":4000:0:1:20:::1:0:", -- Elixir of Major Defense
	[22835]=":6000:0:1:20:::1:0:", -- Elixir of Major Shadow Power
	[22836]=":5000:0:1:5:::1:0:", -- Major Dreamless Sleep Potion
	[22837]=":5000:0:1:5:::1:0:", -- Heroic Potion
	[22838]="20000:5000:0:1:5:::1:0:23405,23151", -- Haste Potion
	[22839]="20000:5000:0:1:5:::1:0:23405,23151", -- Destruction Potion
	[22840]=":6000:0:1:20:::1:0:", -- Elixir of Major Mageblood
	[22841]=":6000:0:1:5:::1:0:", -- Major Fire Protection Potion
	[22842]=":6000:0:1:5:::1:0:", -- Major Frost Protection Potion
	[22843]="::4:3:1:::1:0:12795", -- Blood Guard\'s Chain Greaves
	[22844]=":6000:0:1:5:::1:0:", -- Major Nature Protection Potion
	[22845]="24000:6000:0:1:5:::1:0:20989", -- Major Arcane Protection Potion
	[22846]="24000:6000:0:1:5:::1:0:20989", -- Major Shadow Protection Potion
	[22847]=":6000:0:1:5:::1:0:", -- Major Holy Protection Potion
	[22848]=":7000:0:1:20:::1:0:", -- Elixir of Empowerment
	[22849]="28000:7000:0:1:5:::1:0:23405,23151", -- Ironshield Potion
	[22850]=":7000:0:1:5:::1:0:", -- Super Rejuvenation Potion
	[22851]=":20000:0:1:5:::1:0:", -- Flask of Fortification
	[22852]="::4:3:1:::1:0:12795", -- Blood Guard\'s Dragonhide Treads
	[22853]=":20000:0:1:5:::1:0:", -- Flask of Mighty Restoration
	[22854]=":20000:0:1:5:::1:0:", -- Flask of Relentless Assault
	[22855]="::4:3:1:::1:0:12795", -- Blood Guard\'s Dreadweave Walkers
	[22856]="::4:3:1:::1:0:12795", -- Blood Guard\'s Leather Walkers
	[22857]="::4:3:1:::1:0:12795", -- Blood Guard\'s Mail Greaves
	[22858]="::4:3:1:::1:0:12795", -- Blood Guard\'s Plate Greaves
	[22859]="::4:3:1:::1:0:12795", -- Blood Guard\'s Satin Walkers
	[22860]="::4:3:1:::1:0:12795", -- Blood Guard\'s Silk Walkers
	[22861]=":20000:0:1:5:::1:0:", -- Flask of Blinding Light
	[22862]="::4:3:1:::1:0:12795", -- Blood Guard\'s Chain Vices
	[22863]="::4:3:1:::1:0:12795", -- Blood Guard\'s Dragonhide Grips
	[22864]="::4:3:1:::1:0:12795", -- Blood Guard\'s Leather Grips
	[22865]="::4:3:1:::1:0:12795", -- Blood Guard\'s Dreadweave Handwraps
	[22866]=":20000:0:1:5:::1:0:", -- Flask of Pure Death
	[22867]="::4:3:1:::1:0:12795", -- Blood Guard\'s Mail Vices
	[22868]="::4:3:1:::1:0:12795", -- Blood Guard\'s Plate Gauntlets
	[22869]="::4:3:1:::1:0:12795", -- Blood Guard\'s Satin Handwraps
	[22870]="::4:3:1:::1:0:12795", -- Blood Guard\'s Silk Handwraps
	[22871]=":5000:0:1:5:::1:0:", -- Shrouding Potion
	[22872]="::4:3:1:::1:0:12795", -- Legionnaire\'s Plate Hauberk
	[22873]="::4:3:1:::1:0:12795", -- Legionnaire\'s Plate Leggings
	[22874]="::4:3:1:::1:0:12795", -- Legionnaire\'s Chain Hauberk
	[22875]="::4:3:1:::1:0:12795", -- Legionnaire\'s Chain Legguards
	[22876]="::4:3:1:::1:0:12795", -- Legionnaire\'s Mail Hauberk
	[22877]="::4:3:1:::1:0:12795", -- Legionnaire\'s Dragonhide Chestpiece
	[22878]="::4:3:1:::1:0:12795", -- Legionnaire\'s Dragonhide Leggings
	[22879]="::4:3:1:::1:0:12795", -- Legionnaire\'s Leather Chestpiece
	[22880]="::4:3:1:::1:0:12795", -- Legionnaire\'s Leather Legguards
	[22881]="::4:3:1:::1:0:12795", -- Legionnaire\'s Dreadweave Legguards
	[22882]="::4:3:1:::1:0:12795", -- Legionnaire\'s Satin Legguards
	[22883]="::4:3:1:::1:0:12795", -- Legionnaire\'s Silk Legguards
	[22884]="::4:3:1:::1:0:12795", -- Legionnaire\'s Dreadweave Tunic
	[22885]="::4:3:1:::1:0:12795", -- Legionnaire\'s Satin Tunic
	[22886]="::4:3:1:::1:0:12795", -- Legionnaire\'s Silk Tunic
	[22887]="::4:3:1:::1:0:12795", -- Legionnaire\'s Mail Legguards
	[22888]="::12:1:1:::1:0:", -- Azure Watch Gift Voucher
	[22889]="::12:1:10:::1:0:", -- Vial of Moth Blood
	[22890]=":10000:9:3:1:::1:0:", -- Tome of Frost Ward V
	[22891]=":10000:9:3:1:::1:0:", -- Grimoire of Shadow Ward IV
	[22892]="::12:1:10:::1:0:", -- Dim Necrotic Stone
	[22893]="::12:1:1:::1:0:", -- Luzran\'s Head
	[22894]="::12:1:1:::1:0:", -- Knucklerot\'s Head
	[22895]="::0:1:20:::1:0:17078", -- Conjured Cinnamon Roll
	[22897]=":10000:9:3:1:::1:0:", -- Tome of Conjure Food VII
	[22900]="30000:7500:9:1:1:::1:0:16641,16705,18802,16588", -- Recipe: Elixir of Camouflage
	[22901]="30000:7500:9:1:1:::1:0:18017,19042", -- Recipe: Sneaking Potion
	[22902]="40000:10000:9:1:1:::1:0:18017,18005", -- Recipe: Elixir of Major Frost Power
	[22903]=":10000:9:2:1:::1:0:", -- Recipe: Insane Strength Potion
	[22904]=":10000:9:2:1:::1:0:", -- Recipe: Elixir of the Searching Eye
	[22905]="50000:12500:9:1:1:::1:0:17657", -- Recipe: Elixir of Major Agility
	[22906]="::9:2:1:::1:0:18382", -- Recipe: Shrouding Potion
	[22907]="50000:12500:9:1:1:::1:0:19837,18005", -- Recipe: Super Mana Potion
	[22908]="60000:15000:9:2:1:::1:0:19331", -- Recipe: Elixir of Major Firepower
	[22909]="50000:12500:9:1:1:::1:0:19837,18005", -- Recipe: Elixir of Major Defense
	[22910]="80000:20000:9:2:1:::1:0:21655", -- Recipe: Elixir of Major Shadow Power
	[22911]="50000:12500:9:1:1:::1:0:19837,19042", -- Recipe: Major Dreamless Sleep Potion
	[22912]=":20000:9:2:1:::1:0:", -- Recipe: Heroic Potion
	[22913]=":20000:9:2:1:::1:0:", -- Recipe: Haste Potion
	[22914]=":20000:9:2:1:::1:0:", -- Recipe: Destruction Potion
	[22915]="80000:20000:9:2:1:::1:0:21432", -- Recipe: Transmute Primal Air to Fire
	[22916]="::9:2:1:::1:0:18382", -- Recipe: Transmute Primal Earth to Water
	[22917]="80000:20000:9:2:1:::1:0:20241", -- Recipe: Transmute Primal Fire to Earth
	[22918]="80000:20000:9:2:1:::1:0:17904", -- Recipe: Transmute Primal Water to Air
	[22919]=":25000:9:2:1:::1:0:", -- Recipe: Elixir of Major Mageblood
	[22920]=":15000:9:2:1:::1:0:", -- Recipe: Major Fire Protection Potion
	[22921]=":15000:9:2:1:::1:0:", -- Recipe: Major Frost Protection Potion
	[22922]="100000:25000:9:1:1:::1:0:17904", -- Recipe: Major Nature Protection Potion
	[22923]=":25000:9:2:1:::1:0:", -- Recipe: Major Arcane Protection Potion
	[22924]=":25000:9:2:1:::1:0:", -- Recipe: Major Shadow Protection Potion
	[22925]=":25000:9:2:1:::1:0:", -- Recipe: Major Holy Protection Potion
	[22926]=":25000:9:2:1:::1:0:", -- Recipe: Elixir of Empowerment
	[22927]=":15000:9:2:1:::1:0:", -- Recipe: Ironshield Potion
	[22930]="::12:1:1:::1:0:", -- A Bloodstained Envelope
	[22932]="::12:1:1:::1:0:", -- A Torn Letter
	[22934]="::12:1:10:::1:0:", -- Lasher Sample
	[22935]=":88355:4:4:1:::1:0:", -- Touch of Frost
	[22936]=":30895:4:4:1:::1:0:", -- Wristguards of Vengeance
	[22937]=":72651:4:4:1:::1:0:", -- Gem of Nerubis
	[22938]=":26523:4:4:1:::1:0:", -- Cryptfiend Silk Cloak
	[22939]=":60256:4:4:1:::1:0:", -- Band of Unanswered Prayers
	[22940]=":46667:4:4:1:::1:0:", -- Icebane Pauldrons
	[22941]=":33516:4:4:1:::1:0:", -- Polar Shoulder Pads
	[22942]=":87803:2:4:1:::1:0:", -- The Widow\'s Embrace
	[22943]=":102777:4:4:1:::1:0:", -- Malice Stone Pendant
	[22944]="::12:1:1:::1:0:", -- A Crumpled Missive
	[22945]="::12:1:1:::1:0:", -- A Careworn Note
	[22946]="::12:1:1:::1:0:", -- A Ragged Page
	[22947]=":88355:4:4:1:::1:0:", -- Pendant of Forgotten Names
	[22948]="::12:1:1:::1:0:", -- A Smudged Document
	[22949]="::12:1:1:::1:0:", -- Cracked Necrotic Crystal
	[22950]="::12:1:1:::1:0:", -- Faint Necrotic Crystal
	[22951]=":27:4:1:1:::1:0:", -- Springpaw Hide Leggings
	[22952]=":16:4:1:1:::1:0:", -- Springpaw Hide Cloak
	[22953]=":33:4:1:1:::1:0:", -- Fur Lined Chain Shirt
	[22954]=":91160:4:4:1:::1:0:", -- Kiss of the Spider
	[22955]="::12:1:1:::1:0:", -- Neutralizing Agent
	[22956]=":57:2:1:1:::1:0:", -- Rusty Mace
	[22957]=":57:2:1:1:::1:0:", -- Rusty Sin\'dorei Sword
	[22958]=":182:2:1:1:::1:0:", -- Farstrider Sword
	[22959]=":183:2:1:1:::1:0:", -- Smooth Metal Staff
	[22960]=":26713:4:4:1:::1:0:", -- Cloak of Suturing
	[22961]=":113642:4:4:1:::1:0:", -- Band of Reanimation
	[22962]="::12:1:1:::1:0:", -- Inoculating Crystal
	[22963]=":149:2:1:1:::1:0:", -- Ranger\'s Pocketknife
	[22964]=":24:4:1:1:::1:0:", -- Sunsail Bracers
	[22965]=":20:4:1:1:::1:0:", -- Longshoreman\'s Bindings
	[22966]=":16:4:1:1:::1:0:", -- Silk Wristbands
	[22967]=":41269:4:4:1:::1:0:", -- Icy Scale Spaulders
	[22968]=":25550:4:4:1:::1:0:", -- Glacial Mantle
	[22969]=":230:2:2:1:::1:0:", -- Ven\'jashi\'s Bow
	[22970]="::12:1:1:::1:0:", -- A Bloodstained Envelope
	[22971]=":231:2:2:1:::1:0:", -- Hoodoo Wand
	[22972]="::12:1:1:::1:0:", -- A Careworn Note
	[22973]="::12:1:1:::1:0:", -- A Crumpled Missive
	[22974]="::12:1:1:::1:0:", -- A Ragged Page
	[22975]="::12:1:1:::1:0:", -- A Smudged Document
	[22976]=":250:1:1:1:::1:0:", -- Magister\'s Pouch
	[22977]="::12:1:1:::1:0:", -- A Torn Letter
	[22978]="::12:1:10:::1:0:", -- Emitter Spare Part
	[22979]=":403:4:2:1:::1:0:", -- Slayer\'s Band
	[22980]=":2493:2:3:1:::1:0:", -- Staff of the Sun
	[22981]=":128862:4:4:1:::1:0:", -- Gluth\'s Missing Collar
	[22982]=":1507:2:3:1:::1:0:", -- Farstrider\'s Longbow
	[22983]=":26999:4:4:1:::1:0:", -- Rime Covered Mantle
	[22984]=":1879:2:3:1:::1:0:", -- Dawnblade
	[22985]="2038:407:4:2:1:::1:0:16528", -- Suncrown Hauberk
	[22986]="1364:272:4:2:1:::1:0:16528", -- Apothecary\'s Robe
	[22987]="1712:342:4:2:1:::1:0:16528", -- Deathstalker\'s Vest
	[22988]=":85160:2:4:1:::1:0:", -- The End of Dreams
	[22990]="2883:576:4:3:1:::1:0:16528", -- Tranquillien Champion\'s Cloak
	[22991]="1042:208:4:2:1:::1:0:16528", -- Apprentice Boots
	[22992]="1308:261:4:2:1:::1:0:16528", -- Bogwalker Boots
	[22993]="1582:316:4:2:1:::1:0:16528", -- Volunteer\'s Greaves
	[22994]=":91352:4:4:1:::1:0:", -- Digested Hand of Power
	[22995]=":2448:2:3:1:::1:0:", -- Sin\'dorei Warblade
	[22996]=":911:4:2:1:::1:0:", -- Reforged Quel\'dorei Crest
	[22997]=":1072:2:2:1:::1:0:", -- Ley-Keeper\'s Wand
	[22998]=":717:4:2:1:::1:0:", -- Ghostclaw Leggings
	[22999]=":2500:4:1:1:::1:0:", -- Tabard of the Argent Dawn
	[23000]=":63636:4:4:1:::1:0:", -- Plated Abomination Ribcage
	[23001]=":91160:4:4:1:::1:0:", -- Eye of Diminution
	[23002]="::15:1:1:::1:0:", -- Turtle Box
	[23003]="::12:1:1:::1:0:", -- Blood Elf Plans
	[23004]=":25159:4:4:1:::1:0:", -- Idol of Longevity
	[23005]=":25253:4:4:1:::1:0:", -- Totem of Flowing Water
	[23006]=":25351:4:4:1:::1:0:", -- Libram of Light
	[23007]="::15:1:1:::1:0:", -- Piglet\'s Collar
	[23008]="::12:1:1:::1:0:", -- Sealed Research Report
	[23009]=":64100:2:4:1:::1:0:", -- Wand of the Whispering Dead
	[23010]="::12:1:1:::1:0:", -- Sealed Research Report
	[23011]="::12:1:1:::1:0:", -- Sealed Research Report
	[23012]="::12:1:1:::1:0:", -- Sealed Research Report
	[23013]="::12:1:1:::1:0:", -- Sealed Research Report
	[23014]=":85238:2:4:1:::1:0:", -- Iblis, Blade of the Fallen Seraph
	[23015]="::15:1:1:::1:0:", -- Rat Cage
	[23016]="::12:1:1:::1:0:", -- Sealed Research Report
	[23017]=":27110:4:4:1:::1:0:", -- Veil of Eclipse
	[23018]=":60256:4:4:1:::1:0:", -- Signet of the Fallen Defender
	[23019]=":47692:4:4:1:::1:0:", -- Icebane Helmet
	[23020]=":34249:4:4:1:::1:0:", -- Polar Helmet
	[23021]=":18331:4:4:1:::1:0:", -- The Soul Harvester\'s Bindings
	[23022]="::15:1:1:::1:0:", -- Curmudgeon\'s Payoff
	[23023]=":86443:4:4:1:::1:0:", -- Sadist\'s Collar
	[23024]="::12:1:1:::1:0:", -- Prepared Field Duty Papers
	[23025]=":60256:4:4:1:::1:0:", -- Seal of the Damned
	[23027]=":91160:4:4:1:::1:0:", -- Warmth of Forgiveness
	[23028]=":98660:4:4:1:::1:0:", -- Hailstone Band
	[23029]=":72651:4:4:1:::1:0:", -- Noth\'s Frigid Heart
	[23030]=":25734:4:4:1:::1:0:", -- Cloak of the Scourge
	[23031]=":60256:4:4:1:::1:0:", -- Band of the Inevitable
	[23032]=":25926:4:4:1:::1:0:", -- Glacial Headdress
	[23033]=":40081:4:4:1:::1:0:", -- Icy Scale Coif
	[23035]=":26915:4:4:1:::1:0:", -- Preceptor\'s Hat
	[23036]=":88355:4:4:1:::1:0:", -- Necklace of Necropsy
	[23037]=":60256:4:4:1:::1:0:", -- Ring of Spiritual Fervor
	[23038]=":60256:4:4:1:::1:0:", -- Band of Unnatural Forces
	[23039]=":113747:2:4:1:::1:0:", -- The Eye of Nerub
	[23040]=":91160:4:4:1:::1:0:", -- Glyph of Deflection
	[23041]=":91160:4:4:1:::1:0:", -- Slayer\'s Crest
	[23042]=":91160:4:4:1:::1:0:", -- Loatheb\'s Reflection
	[23043]=":57405:4:4:1:::1:0:", -- The Face of Death
	[23044]=":83837:2:4:1:::1:0:", -- Harbinger of Doom
	[23045]=":27117:4:4:1:::1:0:", -- Shroud of Dominion
	[23046]=":91160:4:4:1:::1:0:", -- The Restrained Essence of Sapphiron
	[23047]=":91160:4:4:1:::1:0:", -- Eye of the Dead
	[23048]=":72651:4:4:1:::1:0:", -- Sapphiron\'s Right Eye
	[23049]=":72651:4:4:1:::1:0:", -- Sapphiron\'s Left Eye
	[23050]=":28385:4:4:1:::1:0:", -- Cloak of the Necropolis
	[23053]=":86443:4:4:1:::1:0:", -- Stormrage\'s Talisman of Seething
	[23054]=":95047:2:4:1:::1:0:", -- Gressil, Dawn of Ruin
	[23055]="::7:1:10:::1:0:", -- Word of Thawing
	[23056]=":95737:2:4:1:::1:0:", -- Hammer of the Twisting Nether
	[23057]=":102777:4:4:1:::1:0:", -- Gem of Trapped Innocents
	[23059]=":60256:4:4:1:::1:0:", -- Ring of the Dreadnaught
	[23060]=":60256:4:4:1:::1:0:", -- Bonescythe Ring
	[23061]=":60256:4:4:1:::1:0:", -- Ring of Faith
	[23062]=":60256:4:4:1:::1:0:", -- Frostfire Ring
	[23063]=":60256:4:4:1:::1:0:", -- Plagueheart Ring
	[23064]=":60256:4:4:1:::1:0:", -- Ring of the Dreamwalker
	[23065]=":60256:4:4:1:::1:0:", -- Ring of the Earthshatterer
	[23066]=":60256:4:4:1:::1:0:", -- Ring of Redemption
	[23067]=":60256:4:4:1:::1:0:", -- Ring of the Cryptstalker
	[23068]=":61207:4:4:1:::1:0:", -- Legplates of Carnage
	[23069]=":35844:4:4:1:::1:0:", -- Necro-Knight\'s Garb
	[23070]=":35976:4:4:1:::1:0:", -- Leggings of Polarity
	[23071]=":44201:4:4:1:::1:0:", -- Leggings of Apocalypse
	[23072]=":33544:4:4:1:::1:0:", -- Fists of the Unrelenting
	[23073]=":33391:4:4:1:::1:0:", -- Boots of Displacement
	[23075]=":57402:4:4:1:::1:0:", -- Death\'s Bargain
	[23077]=":2500:3:2:20::202,755:1:0:", -- Blood Garnet
	[23078]=":18870:4:3:1:::1:0:", -- Gauntlets of Undead Slaying
	[23079]=":2500:3:2:20::202,755:1:0:", -- Deep Peridot
	[23081]=":12591:4:3:1:::1:0:", -- Handwraps of Undead Slaying
	[23082]=":15167:4:3:1:::1:0:", -- Handguards of Undead Slaying
	[23083]="::15:3:1:::1:0:26124,26123", -- Captured Flame
	[23084]=":10187:4:3:1:::1:0:", -- Gloves of Undead Cleansing
	[23085]=":20451:4:3:1:::1:0:", -- Robe of Undead Cleansing
	[23087]=":36057:4:3:1:::1:0:", -- Breastplate of Undead Slaying
	[23088]=":31018:4:3:1:::1:0:", -- Chestguard of Undead Slaying
	[23089]=":25944:4:3:1:::1:0:", -- Tunic of Undead Slaying
	[23090]=":18332:4:3:1:::1:0:", -- Bracers of Undead Slaying
	[23091]=":10454:4:3:1:::1:0:", -- Bracers of Undead Cleansing
	[23092]=":15737:4:3:1:::1:0:", -- Wristguards of Undead Slaying
	[23093]=":13162:4:3:1:::1:0:", -- Wristwraps of Undead Slaying
	[23094]="10000:2500:3:2:1:::1:0:19538", -- Teardrop Blood Garnet
	[23095]="10000:2500:3:2:1:::1:0:19538", -- Bold Blood Garnet
	[23096]="10000:2500:3:2:1:::1:0:19538", -- Runed Blood Garnet
	[23097]="10000:2500:3:2:1:::1:0:19538", -- Delicate Blood Garnet
	[23098]="10000:2500:3:2:1:::1:0:19538", -- Inscribed Flame Spessarite
	[23099]="10000:2500:3:2:1:::1:0:19538", -- Luminous Flame Spessarite
	[23100]="10000:2500:3:2:1:::1:0:19538", -- Glinting Flame Spessarite
	[23101]="10000:2500:3:2:1:::1:0:19538", -- Potent Flame Spessarite
	[23103]="10000:2500:3:2:1:::1:0:19538", -- Radiant Deep Peridot
	[23104]="10000:2500:3:2:1:::1:0:19538", -- Jagged Deep Peridot
	[23105]="10000:2500:3:2:1:::1:0:19538", -- Enduring Deep Peridot
	[23106]="10000:2500:3:2:1:::1:0:19538", -- Dazzling Deep Peridot
	[23107]=":2500:3:2:20::755:1:0:", -- Shadow Draenite
	[23108]="10000:2500:3:2:1:::1:0:19538", -- Glowing Shadow Draenite
	[23109]="10000:2500:3:2:1:::1:0:19538", -- Royal Shadow Draenite
	[23110]="10000:2500:3:2:1:::1:0:19538", -- Shifting Shadow Draenite
	[23111]="10000:2500:3:2:1:::1:0:19538", -- Sovereign Shadow Draenite
	[23112]=":2500:3:2:20::202,755:1:0:", -- Golden Draenite
	[23113]="10000:2500:3:2:1:::1:0:19538", -- Brilliant Golden Draenite
	[23114]="10000:2500:3:2:1:::1:0:19538", -- Gleaming Golden Draenite
	[23115]="10000:2500:3:2:1:::1:0:19538", -- Thick Golden Draenite
	[23116]="10000:2500:3:2:1:::1:0:19538", -- Rigid Golden Draenite
	[23117]=":2500:3:2:20::755:1:0:", -- Azure Moonstone
	[23118]="10000:2500:3:2:1:::1:0:19538", -- Solid Azure Moonstone
	[23119]="10000:2500:3:2:1:::1:0:19538", -- Sparkling Azure Moonstone
	[23120]="10000:2500:3:2:1:::1:0:19538", -- Stormy Azure Moonstone
	[23121]="10000:2500:3:2:1:::1:0:19538", -- Lustrous Azure Moonstone
	[23122]=":40:0:2:20:::1:0:", -- Consecrated Sharpening Stone
	[23123]=":40:0:2:20:::1:0:", -- Blessed Wizard Oil
	[23124]=":61095:2:3:1:::1:0:", -- Staff of Balzaphon
	[23125]=":41953:4:3:1:::1:0:", -- Chains of the Lich
	[23126]=":9847:4:3:1:::1:0:", -- Waistband of Balzaphon
	[23127]=":15448:4:3:1:::1:0:", -- Cloak of Revanchion
	[23128]=":10198:4:3:1:::1:0:", -- The Shadow\'s Grasp
	[23129]=":10507:4:3:1:::1:0:", -- Bracers of Mending
	[23130]="40000:10000:9:1:1:::1:0:18751,18774", -- Design: Teardrop Blood Garnet
	[23131]="50000:12500:9:1:1:::1:0:18751,18774", -- Design: Bold Blood Garnet
	[23132]=":53100:2:3:1:::1:0:", -- Lord Blackwood\'s Blade
	[23133]="60000:15000:9:2:1:::1:0:19331", -- Design: Runed Blood Garnet
	[23134]="60000:15000:9:2:1:::1:0:23007,20242", -- Design: Delicate Blood Garnet
	[23135]="40000:10000:9:1:1:::1:0:18751,18774", -- Design: Inscribed Flame Spessarite
	[23136]="50000:12500:9:2:1:::1:0:23007,20242", -- Design: Luminous Flame Spessarite
	[23137]="60000:15000:9:1:1:::1:0:18751,18774", -- Design: Glinting Flame Spessarite
	[23138]="60000:15000:9:2:1:::1:0:21655", -- Design: Potent Flame Spessarite
	[23139]=":31549:4:3:1:::1:0:", -- Lord Blackwood\'s Buckler
	[23140]="40000:10000:9:1:1:::1:0:18751,18774", -- Design: Radiant Deep Peridot
	[23141]="50000:12500:9:1:1:::1:0:18751,18774", -- Design: Jagged Deep Peridot
	[23142]="60000:15000:9:2:1:::1:0:17657", -- Design: Enduring Deep Peridot
	[23143]="60000:15000:9:2:1:::1:0:19331", -- Design: Dazzling Deep Peridot
	[23144]="40000:10000:9:1:1:::1:0:18751,18774", -- Design: Glowing Shadow Draenite
	[23145]="50000:12500:9:2:1:::1:0:19321", -- Design: Royal Shadow Draenite
	[23146]="60000:15000:9:2:1:::1:0:23007,20242", -- Design: Shifting Shadow Draenite
	[23147]="60000:15000:9:2:1:::1:0:18751,18774", -- Design: Sovereign Shadow Draenite
	[23148]="40000:10000:9:1:1:::1:0:18751,18774", -- Design: Brilliant Golden Draenite
	[23149]="50000:12500:9:2:1:::1:0:19321", -- Design: Gleaming Golden Draenite
	[23150]="60000:15000:9:2:1:::1:0:23007,20242", -- Design: Thick Golden Draenite
	[23151]="60000:15000:9:2:1:::1:0:18751,18774", -- Design: Rigid Golden Draenite
	[23152]="40000:10000:9:1:1:::1:0:18751,18774", -- Design: Solid Azure Moonstone
	[23153]="50000:12500:9:2:1:::1:0:18751,18774", -- Design: Sparkling Azure Moonstone
	[23154]=":15000:9:2:1:::1:0:", -- Design: Stormy Azure Moonstone
	[23155]="60000:15000:9:2:1:::1:0:23007,20242", -- Design: Lustrous Azure Moonstone
	[23156]=":13113:4:3:1:::1:0:", -- Blackwood\'s Thigh
	[23160]="4000:200:0:1:20:::5:0:2482,11038,5173,3044,16543,14450,4165,5698,15006", -- Friendship Bread
	[23161]="4000:200:0:1:20:::5:0:2482,11038,5173,3044,16543,14450,4165,5698,15006", -- Freshly-Squeezed Lemonade
	[23165]="::12:1:5:::1:0:", -- Headhunter Axe
	[23166]="::12:1:5:::1:0:", -- Hexxer Stave
	[23167]="::12:1:5:::1:0:", -- Shadowcaster Mace
	[23168]=":2665:2:3:1:::1:0:", -- Scorn\'s Focal Dagger
	[23169]=":3482:4:3:1:::1:0:", -- Scorn\'s Icy Choker
	[23170]=":2684:4:3:1:::1:0:", -- The Frozen Clutch
	[23171]=":4213:2:3:1:::1:0:", -- The Axe of Severing
	[23173]=":1357:4:3:1:::1:0:", -- Abomination Skin Leggings
	[23177]=":10536:2:3:1:::1:0:", -- Lady Falther\'ess\' Finger
	[23178]=":4230:4:3:1:::1:0:", -- Mantle of Lady Falther\'ess
	[23179]="::12:1:1:::1:0:", -- Flame of Orgrimmar
	[23180]="::12:1:1:::1:0:", -- Flame of Thunder Bluff
	[23181]="::12:1:1:::1:0:", -- Flame of the Undercity
	[23182]="::12:1:1:::1:0:", -- Flame of Stormwind
	[23183]="::12:1:1:::1:0:", -- Flame of Ironforge
	[23184]="::12:1:1:::1:0:", -- Flame of Darnassus
	[23191]="::12:1:1:::1:0:", -- Crystal Controlling Orb
	[23192]=":7143:4:2:1:::1:0:", -- Tabard of the Scarlet Crusade
	[23194]="::0:1:3:::1:0:", -- Lesser Mark of the Dawn
	[23195]="::0:1:3:::1:0:", -- Mark of the Dawn
	[23196]="::0:1:3:::1:0:", -- Greater Mark of the Dawn
	[23197]=":15690:4:3:1:::1:0:", -- Idol of the Moon
	[23198]=":15749:4:3:1:::1:0:", -- Idol of Brutality
	[23199]=":15808:4:3:1:::1:0:", -- Totem of the Storm
	[23200]=":15867:4:3:1:::1:0:", -- Totem of Sustaining
	[23201]=":15925:4:3:1:::1:0:", -- Libram of Divinity
	[23203]=":16043:4:3:1:::1:0:", -- Libram of Fervor
	[23205]="::12:1:10:::1:0:", -- Hellfire Spineleaf
	[23206]="::4:4:1:::1:0:", -- Mark of the Champion
	[23207]="::4:4:1:::1:0:", -- Mark of the Champion
	[23211]="::0:1:20:::5:0:26124,26123", -- Toasted Smorc
	[23215]="::0:1:5:::1:0:26124,26123", -- Bag of Smorc Ingredients
	[23217]="::12:1:50:::1:0:", -- Ravager Egg
	[23218]="::12:1:10:::1:0:", -- Condensed Voidwalker Essence
	[23219]=":31190:4:4:1:::1:0:", -- Girdle of the Mentor
	[23220]=":35572:4:4:1:::1:0:", -- Crystal Webbed Robe
	[23221]=":87413:2:4:1:::1:0:", -- Misplaced Servo Arm
	[23226]=":45674:4:4:1:::1:0:", -- Ghoul Skin Tunic
	[23228]="::12:1:1:::1:0:", -- Old Whitebark\'s Pendant
	[23237]=":60256:4:4:1:::1:0:", -- Ring of the Eternal Flame
	[23238]=":55321:4:4:1:::1:0:", -- Stygian Buckler
	[23239]="::12:1:20:::1:0:", -- Plump Buzzard Wing
	[23242]=":94813:2:4:1:::1:0:", -- Claw of the Frost Wyrm
	[23243]="::4:3:1:::1:0:12795", -- Champion\'s Plate Shoulders
	[23244]="::4:3:1:::1:0:12795", -- Champion\'s Plate Helm
	[23246]="::0:1:20:::5:0:26124,26123", -- Fiery Festival Brew
	[23247]="::15:1:250:::1:0:", -- Burning Blossom
	[23248]="::12:1:10:::1:0:", -- Purified Helboar Meat
	[23249]="::12:1:1:::1:0:", -- Amani Invasion Plans
	[23250]="::15:1:1:::1:0:", -- Prismatic Shell
	[23251]="::4:3:1:::1:0:12795", -- Champion\'s Chain Helm
	[23252]="::4:3:1:::1:0:12795", -- Champion\'s Chain Shoulders
	[23253]="::4:3:1:::1:0:12795", -- Champion\'s Dragonhide Headguard
	[23254]="::4:3:1:::1:0:12795", -- Champion\'s Dragonhide Shoulders
	[23255]="::4:3:1:::1:0:12795", -- Champion\'s Dreadweave Cowl
	[23256]="::4:3:1:::1:0:12795", -- Champion\'s Dreadweave Spaulders
	[23257]="::4:3:1:::1:0:12795", -- Champion\'s Leather Helm
	[23258]="::4:3:1:::1:0:12795", -- Champion\'s Leather Shoulders
	[23259]="::4:3:1:::1:0:12795", -- Champion\'s Mail Headguard
	[23260]="::4:3:1:::1:0:12795", -- Champion\'s Mail Pauldrons
	[23261]="::4:3:1:::1:0:12795", -- Champion\'s Satin Hood
	[23262]="::4:3:1:::1:0:12795", -- Champion\'s Satin Mantle
	[23263]="::4:3:1:::1:0:12795", -- Champion\'s Silk Cowl
	[23264]="::4:3:1:::1:0:12795", -- Champion\'s Silk Mantle
	[23265]=":58:4:1:1:::1:0:", -- Blackened Chain Girdle
	[23266]=":98:4:1:1:::1:0:", -- Ranger\'s Vest
	[23267]=":59:4:1:1:::1:0:", -- Satin Lined Boots
	[23268]="::12:1:1:::1:0:", -- Purification Mixture
	[23269]="::12:1:20:::1:0:", -- Felblood Sample
	[23270]="::12:1:10:::1:0:", -- Tainted Helboar Meat
	[23272]="::4:3:1:::1:0:12785", -- Knight-Captain\'s Lamellar Breastplate
	[23273]="::4:3:1:::1:0:12785", -- Knight-Captain\'s Lamellar Leggings
	[23274]="::4:3:1:::1:0:12785", -- Knight-Lieutenant\'s Lamellar Gauntlets
	[23275]="::4:3:1:::1:0:12785", -- Knight-Lieutenant\'s Lamellar Sabatons
	[23276]="::4:3:1:::1:0:12785", -- Lieutenant Commander\'s Lamellar Headguard
	[23277]="::4:3:1:::1:0:12785", -- Lieutenant Commander\'s Lamellar Shoulders
	[23278]="::4:3:1:::1:0:12785", -- Knight-Lieutenant\'s Chain Greaves
	[23279]="::4:3:1:::1:0:12785", -- Knight-Lieutenant\'s Chain Vices
	[23280]="::4:3:1:::1:0:12785", -- Knight-Lieutenant\'s Dragonhide Grips
	[23281]="::4:3:1:::1:0:12785", -- Knight-Lieutenant\'s Dragonhide Treads
	[23282]="::4:3:1:::1:0:12785", -- Knight-Lieutenant\'s Dreadweave Handwraps
	[23283]="::4:3:1:::1:0:12785", -- Knight-Lieutenant\'s Dreadweave Walkers
	[23284]="::4:3:1:::1:0:12785", -- Knight-Lieutenant\'s Leather Grips
	[23285]="::4:3:1:::1:0:12785", -- Knight-Lieutenant\'s Leather Walkers
	[23286]="::4:3:1:::1:0:12785", -- Knight-Lieutenant\'s Plate Gauntlets
	[23287]="::4:3:1:::1:0:12785", -- Knight-Lieutenant\'s Plate Greaves
	[23288]="::4:3:1:::1:0:12785", -- Knight-Lieutenant\'s Satin Handwraps
	[23289]="::4:3:1:::1:0:12785", -- Knight-Lieutenant\'s Satin Walkers
	[23290]="::4:3:1:::1:0:12785", -- Knight-Lieutenant\'s Silk Handwraps
	[23291]="::4:3:1:::1:0:12785", -- Knight-Lieutenant\'s Silk Walkers
	[23292]="::4:3:1:::1:0:12785", -- Knight-Captain\'s Chain Hauberk
	[23293]="::4:3:1:::1:0:12785", -- Knight-Captain\'s Chain Legguards
	[23294]="::4:3:1:::1:0:12785", -- Knight-Captain\'s Dragonhide Chestpiece
	[23295]="::4:3:1:::1:0:12785", -- Knight-Captain\'s Dragonhide Leggings
	[23296]="::4:3:1:::1:0:12785", -- Knight-Captain\'s Dreadweave Legguards
	[23297]="::4:3:1:::1:0:12785", -- Knight-Captain\'s Dreadweave Tunic
	[23298]="::4:3:1:::1:0:12785", -- Knight-Captain\'s Leather Chestpiece
	[23299]="::4:3:1:::1:0:12785", -- Knight-Captain\'s Leather Legguards
	[23300]="::4:3:1:::1:0:12785", -- Knight-Captain\'s Plate Hauberk
	[23301]="::4:3:1:::1:0:12785", -- Knight-Captain\'s Plate Leggings
	[23302]="::4:3:1:::1:0:12785", -- Knight-Captain\'s Satin Legguards
	[23303]="::4:3:1:::1:0:12785", -- Knight-Captain\'s Satin Tunic
	[23304]="::4:3:1:::1:0:12785", -- Knight-Captain\'s Silk Legguards
	[23305]="::4:3:1:::1:0:12785", -- Knight-Captain\'s Silk Tunic
	[23306]="::4:3:1:::1:0:12785", -- Lieutenant Commander\'s Chain Helm
	[23307]="::4:3:1:::1:0:12785", -- Lieutenant Commander\'s Chain Shoulders
	[23308]="::4:3:1:::1:0:12785", -- Lieutenant Commander\'s Dragonhide Headguard
	[23309]="::4:3:1:::1:0:12785", -- Lieutenant Commander\'s Dragonhide Shoulders
	[23310]="::4:3:1:::1:0:12785", -- Lieutenant Commander\'s Dreadweave Cowl
	[23311]="::4:3:1:::1:0:12785", -- Lieutenant Commander\'s Dreadweave Spaulders
	[23312]="::4:3:1:::1:0:12785", -- Lieutenant Commander\'s Leather Helm
	[23313]="::4:3:1:::1:0:12785", -- Lieutenant Commander\'s Leather Shoulders
	[23314]="::4:3:1:::1:0:12785", -- Lieutenant Commander\'s Plate Helmet
	[23315]="::4:3:1:::1:0:12785", -- Lieutenant Commander\'s Plate Shoulders
	[23316]="::4:3:1:::1:0:12785", -- Lieutenant Commander\'s Satin Hood
	[23317]="::4:3:1:::1:0:12785", -- Lieutenant Commander\'s Satin Mantle
	[23318]="::4:3:1:::1:0:12785", -- Lieutenant Commander\'s Silk Cowl
	[23319]="::4:3:1:::1:0:12785", -- Lieutenant Commander\'s Silk Mantle
	[23320]=":100000:9:3:1:::1:0:", -- Tablet of Flame Shock VI
	[23321]="5:1:4:0:1:::1:0:18672", -- Recruit\'s Robe
	[23322]=":1:4:0:1:::1:0:", -- Acolyte\'s Robe
	[23323]=":1:4:1:1:::1:0:", -- Crown of the Fire Festival
	[23324]="::4:1:1:::1:0:26124,26123", -- Mantle of the Fire Festival
	[23326]="::0:1:20:::1:0:26124,26123", -- Midsummer Sausage
	[23327]="::0:1:20:::5:0:26124,26123", -- Fire-toasted Bun
	[23329]=":5:0:1:5:::1:0:", -- Enriched Lasher Root
	[23331]=":4:15:0:20:::1:0:", -- Broken Vine
	[23332]=":3:15:0:40:::1:0:", -- Withered Lasher Root
	[23333]=":5:15:0:20:::1:0:", -- Shattered Power Core
	[23334]=":10:0:1:5:::1:0:", -- Cracked Power Core
	[23336]="::12:1:6:::1:0:", -- Helboar Blood Sample
	[23337]="::12:1:1:::1:0:", -- Cenarion Antidote
	[23338]="::12:1:1:::1:0:", -- Eroded Leather Case
	[23339]="::12:1:1:::1:0:", -- Arelion\'s Journal
	[23343]="::12:1:1:::1:0:", -- Torn Pilgrim\'s Pack
	[23344]=":1:4:0:1:::1:0:", -- Scout\'s Pants
	[23345]=":1:4:1:1:::1:0:", -- Scout\'s Shirt
	[23346]=":9:2:1:1:::1:0:", -- Battleworn Claymore
	[23347]=":5:2:1:1:::1:0:", -- Weathered Crossbow
	[23348]=":1:4:1:1:::1:0:", -- Scout\'s Boots
	[23353]=":3:15:0:20:::1:0:", -- Mana Residue
	[23354]=":6:0:1:5:::1:0:", -- Crystalized Mana Residue
	[23355]=":200:12:0:10:::1:0:", -- Toxic Helboar Meat
	[23358]="::12:1:1:::1:0:", -- Signaling Gem
	[23361]="::0:1:1:::1:0:", -- Cleansing Vial
	[23367]=":9:4:1:1:::1:0:", -- Light Silk Robe
	[23370]=":38:2:1:1:::1:0:", -- Ley-Keeper\'s Blade
	[23371]=":48:2:1:1:::1:0:", -- Velania\'s Walking Stick
	[23372]=":72:2:1:1:::1:0:", -- Bloodhawk Claymore
	[23373]=":58:2:1:1:::1:0:", -- Long Knife
	[23375]=":19:4:1:1:::1:0:", -- Black Leather Vest
	[23376]=":11:4:1:1:::1:0:", -- Gatewatcher\'s Chain Gloves
	[23377]=":15:4:1:1:::1:0:", -- Guard\'s Leggings
	[23379]="::15:2:1:::1:0:", -- Cinder Bracers
	[23380]=":25:15:0:20:::1:0:", -- Broken Power Core
	[23381]=":10:0:1:5:::1:0:", -- Chipped Power Core
	[23383]=":15:15:0:10:::1:0:", -- Ripped Wyrm Scale
	[23384]=":15:15:0:10:::1:0:", -- Dimly Glowing Eye
	[23385]=":15:15:0:20:::1:0:", -- Dormant Mana Powder
	[23386]=":17:0:1:5:::1:0:", -- Condensed Mana Powder
	[23387]="::12:1:10:::1:0:", -- Bonestripper Tail Feather
	[23389]=":15:1:1:1:::1:0:", -- Empty Draenei Supply Pouch
	[23390]=":31:2:1:1:::1:0:", -- Exodar Bastard Sword
	[23391]=":25:2:1:1:::1:0:", -- Exodar Dagger
	[23392]=":25:2:1:1:::1:0:", -- Exodar Maul
	[23393]=":25:2:1:1:::1:0:", -- Exodar Shortsword
	[23394]="::12:1:1:::1:0:", -- Healing Salve
	[23395]=":73:4:1:1:::1:0:", -- Farstrider\'s Buckler
	[23396]=":115:2:1:1:::1:0:", -- Slightly Used Ranger\'s Blade
	[23397]=":23:4:1:1:::1:0:", -- Satin Lined Gloves
	[23398]=":86:2:1:1:::1:0:", -- Worn Ranger\'s Bow
	[23399]=":100:4:2:1:::1:0:", -- Fallen Apprentice\'s Robe
	[23400]=":255:4:2:1:::1:0:", -- Sylastor\'s Cloak
	[23401]=":802:4:2:1:::1:0:", -- Divining Crystal
	[23402]=":577:2:2:1:::1:0:", -- Arcanist\'s Dagger
	[23403]=":347:4:2:1:::1:0:", -- Salvaged Mail Leggings
	[23404]=":218:4:2:1:::1:0:", -- Padded Running Shoes
	[23405]=":194:4:2:1:::1:0:", -- Farstrider\'s Tunic
	[23406]=":368:4:2:1:::1:0:", -- Sentry Bracers
	[23407]=":246:4:2:1:::1:0:", -- Supple Cotton Bracer
	[23408]=":309:4:2:1:::1:0:", -- Farstrider\'s Bracers
	[23409]=":1072:2:2:1:::1:0:", -- Well Crafted Long Bow
	[23410]=":1435:2:2:1:::1:0:", -- Well Crafted Sword
	[23411]=":1800:2:2:1:::1:0:", -- Well Crafted Staff
	[23412]=":429:4:2:1:::1:0:", -- Troll Kickers
	[23413]=":286:4:2:1:::1:0:", -- Troll Kickers
	[23414]=":359:4:2:1:::1:0:", -- Troll Kickers
	[23415]=":726:2:2:1:::1:0:", -- Survival Knife
	[23417]="::0:1:1:::1:0:", -- Sanctified Crystal
	[23423]=":297:2:2:1:::1:0:", -- Mercenary Greatsword
	[23424]=":1000:7:1:20::186:1:0:", -- Fel Iron Ore
	[23425]=":1500:7:1:20::186:1:0:", -- Adamantite Ore
	[23426]=":2500:7:2:20::186:1:0:", -- Khorium Ore
	[23427]=":1250:7:2:20::333,186:1:0:", -- Eternium Ore
	[23429]=":303:2:2:1:::1:0:", -- Mercenary Clout
	[23430]=":243:2:2:1:::1:0:", -- Mercenary Sword
	[23431]=":244:2:2:1:::1:0:", -- Mercenary Stiletto
	[23435]="::0:1:20:::5:0:26124,26123", -- Elderberry Pie
	[23436]="120000:30000:3:3:20::202,755:1:0:14847", -- Living Ruby
	[23437]="120000:30000:3:3:20::202,755:1:0:14847", -- Talasite
	[23438]="120000:30000:3:3:20::202,755:1:0:14847", -- Star of Elune
	[23439]="120000:30000:3:3:20::202,755:1:0:14847", -- Noble Topaz
	[23440]="120000:30000:3:3:20::202,755:1:0:14847", -- Dawnstone
	[23441]="120000:30000:3:3:20::202,755:1:0:14847", -- Nightseye
	[23442]="::12:1:1:::1:0:", -- Glowing Sanctified Crystal
	[23444]=":110:0:1:5:::1:0:", -- Goldenmist Special Brew
	[23445]=":2000:7:1:20::164,202,755,186:1:0:", -- Fel Iron Bar
	[23446]=":3000:7:1:20::164,202,755,186:1:0:", -- Adamantite Bar
	[23447]=":2500:7:2:20::164,755,186:1:0:", -- Eternium Bar
	[23448]=":22500:7:2:20::164,202,755:1:0:", -- Felsteel Bar
	[23449]=":12500:7:2:20::164,202,755,186:1:0:", -- Khorium Bar
	[23451]="::2:4:1:::1:0:12784", -- Grand Marshal\'s Mageblade
	[23452]="::4:4:1:::1:0:12784", -- Grand Marshal\'s Tome of Power
	[23453]="::4:4:1:::1:0:12784", -- Grand Marshal\'s Tome of Restoration
	[23454]="::2:4:1:::1:0:12784", -- Grand Marshal\'s Warhammer
	[23455]="::2:4:1:::1:0:12784", -- Grand Marshal\'s Demolisher
	[23456]="::2:4:1:::1:0:12784", -- Grand Marshal\'s Swiftblade
	[23464]="::2:4:1:::1:0:12794", -- High Warlord\'s Battle Mace
	[23465]="::2:4:1:::1:0:12794", -- High Warlord\'s Destroyer
	[23466]="::2:4:1:::1:0:12794", -- High Warlord\'s Spellblade
	[23467]="::2:4:1:::1:0:12794", -- High Warlord\'s Quickblade
	[23468]="::4:4:1:::1:0:12794", -- High Warlord\'s Tome of Destruction
	[23469]="::4:4:1:::1:0:12794", -- High Warlord\'s Tome of Mending
	[23473]=":1:4:1:1:::1:0:", -- Recruit\'s Shirt
	[23474]=":1:4:0:1:::1:0:", -- Recruit\'s Pants
	[23475]=":1:4:1:1:::1:0:", -- Recruit\'s Boots
	[23476]=":1:4:1:1:::1:0:", -- Squire\'s Shirt
	[23477]=":1:4:0:1:::1:0:", -- Squire\'s Pants
	[23478]=":1:4:0:1:::1:0:", -- Recruit\'s Pants
	[23479]=":1:4:0:1:::1:0:", -- Recruit\'s Robe
	[23480]="::12:1:1:::1:0:", -- Lit Torch
	[23482]=":20269:4:2:1:::1:0:", -- Fel Iron Plate Gloves
	[23483]="::12:1:20:::1:0:", -- Haal\'eshi Scroll
	[23484]=":20969:4:2:1:::1:0:", -- Fel Iron Plate Belt
	[23485]="::12:1:1:::1:0:", -- Empty Birdcage
	[23486]="::12:1:1:::1:0:", -- Caged Female Kaliri Hatchling
	[23487]=":33419:4:2:1:::1:0:", -- Fel Iron Plate Boots
	[23488]=":44805:4:2:1:::1:0:", -- Fel Iron Plate Pants
	[23489]=":47475:4:2:1:::1:0:", -- Fel Iron Breastplate
	[23490]=":39760:4:2:1:::1:0:", -- Fel Iron Chain Tunic
	[23491]=":18866:4:2:1:::1:0:", -- Fel Iron Chain Gloves
	[23492]="::0:1:20:::1:0:", -- Suntouched Special Reserve
	[23493]=":27683:4:2:1:::1:0:", -- Fel Iron Chain Coif
	[23494]=":19615:4:2:1:::1:0:", -- Fel Iron Chain Bracers
	[23495]="::0:1:20:::1:0:", -- Springpaw Appetizer
	[23497]=":58164:2:2:1:::1:0:", -- Fel Iron Hatchet
	[23498]=":60063:2:2:1:::1:0:", -- Fel Iron Hammer
	[2349