----------------------------------------------------------------------------------
-- Variables
----------------------------------------------------------------------------------

GLOBAL_AUCTION_COUNT			= 000;
GLOBAL_AUCTION_COUNT_SUCCESS		= 000;
GLOBAL_AUCTION_MIN_INCOME		= 000;
GLOBAL_AUCTION_MAX_INCOME		= 000;
GLOBAL_AUCTION_GRT_INCOME		= 000;

FRAME_WIDTH				= 310;
FRAME_BORDER				= 5;
TOOLTIP_SPACE_WIDTH			= 15;

----------------------------------------------------------------------------------
-- Code
----------------------------------------------------------------------------------

function AuctionMoneyFrame_BaseFrame_OnEnter()
	AuctionMoneyFrame:Show();
end

function AuctionMoneyFrame_BaseFrame_OnLeave()
	AuctionMoneyFrame:Hide();
end

function AuctionMoney_Update()

	-- Variables
	local name, texture, count, quality, canUse, level, minBid, minIncrement, buyoutPrice, bidAmount, highBidder, owner;

	-- Get the number of items we have up for auction.
	local numBatchAuctions, totalAuctions	= GetNumAuctionItems("owner");

	-- Set the item count.
	GLOBAL_AUCTION_COUNT			= totalAuctions;
	GLOBAL_AUCTION_COUNT_SUCCESS		= 0;
	GLOBAL_AUCTION_MIN_INCOME		= 0;
	GLOBAL_AUCTION_MAX_INCOME		= 0;
	GLOBAL_AUCTION_GRT_INCOME		= 0;

	-- Loop through the items.
	for i = 1, GLOBAL_AUCTION_COUNT do

		-- Get the items.
		name, texture, count, quality, canUse, level, minBid, minIncrement, buyoutPrice, bidAmount, highBidder, owner = GetAuctionItemInfo("owner", i);

		-- Update our values.
		GLOBAL_AUCTION_MIN_INCOME 	= GLOBAL_AUCTION_MIN_INCOME + max(bidAmount, minBid);
		GLOBAL_AUCTION_MAX_INCOME	= GLOBAL_AUCTION_MAX_INCOME + buyoutPrice;
		GLOBAL_AUCTION_GRT_INCOME	= GLOBAL_AUCTION_GRT_INCOME + bidAmount;

		if (bidAmount > 0) then
			GLOBAL_AUCTION_COUNT_SUCCESS = GLOBAL_AUCTION_COUNT_SUCCESS + 1;
		end

	end

	-- Update our money panel in the Auction House frame.
	AuctionMoney_UpdateValues(GLOBAL_AUCTION_MIN_INCOME, GLOBAL_AUCTION_MAX_INCOME, GLOBAL_AUCTION_GRT_INCOME, GLOBAL_AUCTION_COUNT, GLOBAL_AUCTION_COUNT_SUCCESS);

	-- And realign everything.
	AuctionMoney_RealignInterface();

end

function AuctionMoney_UpdateValues(min, max, grt, count, success)
	MoneyFrame_Update("AuctionMoneyFrame_MoneyFrame_MinimumProfit", min);
	MoneyFrame_Update("AuctionMoneyFrame_MoneyFrame_MaximumProfit", max);

	MoneyFrame_Update("AuctionMoneyFrame_MoneyFrame_MinGain", min);
	MoneyFrame_Update("AuctionMoneyFrame_MoneyFrame_MaxGain", max);
	MoneyFrame_Update("AuctionMoneyFrame_MoneyFrame_GrtGain", grt);

	AuctionMoneyFrame_FontString_SuccessfulAuctions_Value:SetText("|cffffffff" .. success ..  " of " .. count .. "|r");
end

function AuctionMoney_ModifyBlizzardAuctionUI()
	----------------------------------------------------------------------------
	-- Base Frame
	----------------------------------------------------------------------------

	-- Create the Base frame.
	CreateFrame("Frame", "AuctionMoneyFrame_BaseFrame", AuctionFrameAuctions, nil);
	AuctionMoneyFrame_BaseFrame:EnableMouse(true);
	AuctionMoneyFrame_BaseFrame:SetScript("OnEnter", AuctionMoneyFrame_BaseFrame_OnEnter);
	AuctionMoneyFrame_BaseFrame:SetScript("OnLeave", AuctionMoneyFrame_BaseFrame_OnLeave);

	AuctionMoneyFrame_BaseFrame:SetWidth(400);
	AuctionMoneyFrame_BaseFrame:SetHeight(100);

	-- Set the Alpha.
	AuctionMoneyFrame_BaseFrame:SetAlpha(0.65);

	----------------------------------------------------------------------------
	-- Minimum Profit FontString
	----------------------------------------------------------------------------

	-- Create a FontString on Blizzard's AuctionFrameAuctions.
	AuctionMoneyFrame_BaseFrame:CreateFontString("AuctionMoneyFrame_FontString_MinimumProfit", "OVERLAY", "GameFontNormal");

	-- Set the actual text.
	AuctionMoneyFrame_FontString_MinimumProfit:SetText("|cffffffffPotential Income:|r");

	----------------------------------------------------------------------------
	-- Maximum Profit FontString
	----------------------------------------------------------------------------

	-- Create a FontString on Blizzard's AuctionFrameAuctions.
	AuctionMoneyFrame_BaseFrame:CreateFontString("AuctionMoneyFrame_FontString_MaximumProfit", "OVERLAY", "GameFontNormal");

	-- Set the actual text.
	AuctionMoneyFrame_FontString_MaximumProfit:SetText("|cffffffffto |r");

	----------------------------------------------------------------------------
	-- Minimum Profit SmallMoneyFrame
	----------------------------------------------------------------------------

	-- Create the SmallMoneyFrame.
	CreateFrame("Frame", "AuctionMoneyFrame_MoneyFrame_MinimumProfit", AuctionMoneyFrame_BaseFrame, "SmallMoneyFrameTemplate");
	MoneyFrame_SetType("AUCTION", AuctionMoneyFrame_MoneyFrame_MinimumProfit);

	----------------------------------------------------------------------------
	-- Maximum Profit SmallMoneyFrame
	----------------------------------------------------------------------------

	-- Create the SmallMoneyFrame.
	CreateFrame("Frame", "AuctionMoneyFrame_MoneyFrame_MaximumProfit", AuctionMoneyFrame_BaseFrame, "SmallMoneyFrameTemplate");
	MoneyFrame_SetType("AUCTION", AuctionMoneyFrame_MoneyFrame_MaximumProfit);

	----------------------------------------------------------------------------
	----------------------------------------------------------------------------

	-- Align the interface.
	AuctionMoney_RealignInterface();
end

function AuctionMoney_RealignInterface()
	-- Adjust the Base frame.
	AuctionMoneyFrame_BaseFrame:SetPoint("LEFT", AuctionFrameMoneyFrame, "RIGHT", 5, 0);
	
	-- Adjust the MinimumProfit string.
	AuctionMoneyFrame_FontString_MinimumProfit:SetPoint("LEFT", AuctionMoneyFrame_BaseFrame, "LEFT", 0, 0);

	-- Adjust the MinimumProfit moneyframe.
	AuctionMoneyFrame_MoneyFrame_MinimumProfit:SetPoint("LEFT", AuctionMoneyFrame_FontString_MinimumProfit, "RIGHT", 0, 0);

	-- Adjust the MaximumProfit string.
	AuctionMoneyFrame_FontString_MaximumProfit:SetPoint("LEFT", AuctionMoneyFrame_MoneyFrame_MinimumProfit, "RIGHT", -10, 0);

	-- Adjust the MaximumProfit moneyframe.
	AuctionMoneyFrame_MoneyFrame_MaximumProfit:SetPoint("LEFT", AuctionMoneyFrame_FontString_MaximumProfit, "RIGHT", 0, 0);

	-- Calculate the real size of the frame.
	local width = AuctionMoneyFrame_MoneyFrame_MaximumProfit:GetRight() - AuctionMoneyFrame_FontString_MinimumProfit:GetLeft();
	local height = AuctionMoneyFrame_FontString_MinimumProfit:GetTop() - AuctionMoneyFrame_FontString_MinimumProfit:GetBottom();

	AuctionMoneyFrame_BaseFrame:SetWidth(width);
	AuctionMoneyFrame_BaseFrame:SetHeight(height);

	AuctionMoneyFrame:SetPoint("BOTTOMLEFT", AuctionMoneyFrame_BaseFrame, "TOPLEFT", 0, 0);

	-----------------------------------------------------------------------------------

	AuctionMoneyFrame_FontString_SuccessfulAuctions:SetPoint("TOPLEFT", AuctionMoneyFrame, "TOPLEFT", 10, -10);
	AuctionMoneyFrame_FontString_SuccessfulAuctionsTip:SetPoint("TOPLEFT", AuctionMoneyFrame_FontString_SuccessfulAuctions, "BOTTOMLEFT", 0, -FRAME_BORDER);

	AuctionMoneyFrame_FontString_MinGain:SetPoint("TOPLEFT", AuctionMoneyFrame_FontString_SuccessfulAuctionsTip, "BOTTOMLEFT", 0, -FRAME_BORDER);
	AuctionMoneyFrame_FontString_MinGainTip:SetPoint("TOPLEFT", AuctionMoneyFrame_FontString_MinGain, "BOTTOMLEFT", 0, -FRAME_BORDER);

	AuctionMoneyFrame_FontString_MaxGain:SetPoint("TOPLEFT", AuctionMoneyFrame_FontString_MinGainTip, "BOTTOMLEFT", 0, -FRAME_BORDER);
	AuctionMoneyFrame_FontString_MaxGainTip:SetPoint("TOPLEFT", AuctionMoneyFrame_FontString_MaxGain, "BOTTOMLEFT", 0, -FRAME_BORDER);

	AuctionMoneyFrame_FontString_GrtGain:SetPoint("TOPLEFT", AuctionMoneyFrame_FontString_MaxGainTip, "BOTTOMLEFT", 0, -FRAME_BORDER);
	AuctionMoneyFrame_FontString_GrtGainTip:SetPoint("TOPLEFT", AuctionMoneyFrame_FontString_GrtGain, "BOTTOMLEFT", 0, -FRAME_BORDER);

	------------------------------------------------------------------------------------

	AuctionMoneyFrame_FontString_SuccessfulAuctions_Value:SetPoint("CENTER", AuctionMoneyFrame_FontString_SuccessfulAuctions, "CENTER", 0, 0);
	AuctionMoneyFrame_FontString_SuccessfulAuctions_Value:SetPoint("RIGHT", AuctionMoneyFrame, "RIGHT", -FRAME_BORDER * 2, 0);

	AuctionMoneyFrame_MoneyFrame_MinGain:SetPoint("CENTER", AuctionMoneyFrame_FontString_MinGain, "CENTER", 0, 0);
	AuctionMoneyFrame_MoneyFrame_MinGain:SetPoint("RIGHT", AuctionMoneyFrame, "RIGHT", -FRAME_BORDER * 2);

	AuctionMoneyFrame_MoneyFrame_MaxGain:SetPoint("CENTER", AuctionMoneyFrame_FontString_MaxGain, "CENTER", 0, 0);
	AuctionMoneyFrame_MoneyFrame_MaxGain:SetPoint("RIGHT", AuctionMoneyFrame, "RIGHT", -FRAME_BORDER * 2);

	AuctionMoneyFrame_MoneyFrame_GrtGain:SetPoint("CENTER", AuctionMoneyFrame_FontString_GrtGain, "CENTER", 0, 0);
	AuctionMoneyFrame_MoneyFrame_GrtGain:SetPoint("RIGHT", AuctionMoneyFrame, "RIGHT", -FRAME_BORDER * 2);

	-------------------------------------------------------------------------------------

	AuctionMoneyFrame:SetHeight((AuctionMoneyFrame:GetTop() - AuctionMoneyFrame_FontString_GrtGainTip:GetBottom()) + (FRAME_BORDER * 2));
end

function AuctionMoneyFrame_Initialize()
	AuctionMoneyFrame:CreateFontString("AuctionMoneyFrame_FontString_SuccessfulAuctions", "ARTWORK", "GameFontNormal");
	AuctionMoneyFrame_FontString_SuccessfulAuctions:SetText("|cff00FF00Successful Auctions|r");
	AuctionMoneyFrame_FontString_SuccessfulAuctions:SetFont(STANDARD_TEXT_FONT, 15, OUTLINE, MONOCHROME);

	AuctionMoneyFrame:CreateFontString("AuctionMoneyFrame_FontString_SuccessfulAuctions_Value", "ARTWORK", "GameFontNormal");

	AuctionMoneyFrame:CreateFontString("AuctionMoneyFrame_FontString_MaxGain", "ARTWORK", "GameFontNormal");
	AuctionMoneyFrame_FontString_MaxGain:SetText("|cff00FF00Maximum Gain|r");
	AuctionMoneyFrame_FontString_MaxGain:SetFont(STANDARD_TEXT_FONT, 15, OUTLINE, MONOCHROME);

	AuctionMoneyFrame:CreateFontString("AuctionMoneyFrame_FontString_GrtGain", "ARTWORK", "GameFontNormal");
	AuctionMoneyFrame_FontString_GrtGain:SetText("|cff00FF00Guaranteed Gain|r");
	AuctionMoneyFrame_FontString_GrtGain:SetFont(STANDARD_TEXT_FONT, 15, OUTLINE, MONOCHROME);

	AuctionMoneyFrame:CreateFontString("AuctionMoneyFrame_FontString_MinGain", "ARTWORK", "GameFontNormal");
	AuctionMoneyFrame_FontString_MinGain:SetText("|cff00FF00Minimum Gain|r");
	AuctionMoneyFrame_FontString_MinGain:SetFont(STANDARD_TEXT_FONT, 15, OUTLINE, MONOCHROME);

	AuctionMoneyFrame:CreateFontString("AuctionMoneyFrame_FontString_SuccessfulAuctionsTip", "ARTWORK", "GameFontNormal");
	AuctionMoneyFrame_FontString_SuccessfulAuctionsTip:SetText("|cffffffffThe number of active auctions which another|nplayer has placed a bid on.|r");
	AuctionMoneyFrame_FontString_SuccessfulAuctionsTip:SetJustifyH("LEFT");

	AuctionMoneyFrame:CreateFontString("AuctionMoneyFrame_FontString_MaxGainTip", "ARTWORK", "GameFontNormal");
	AuctionMoneyFrame_FontString_MaxGainTip:SetText("|cffffffffThe maximum potential gain based on the|nbuyout of your auctions.|r");
	AuctionMoneyFrame_FontString_MaxGainTip:SetJustifyH("LEFT");

	AuctionMoneyFrame:CreateFontString("AuctionMoneyFrame_FontString_GrtGainTip", "ARTWORK", "GameFontNormal");
	AuctionMoneyFrame_FontString_GrtGainTip:SetText("|cffffffffThe guaranteed gain based on active auctions|nwhich another player has placed a bid on.|r");
	AuctionMoneyFrame_FontString_GrtGainTip:SetJustifyH("LEFT");

	AuctionMoneyFrame:CreateFontString("AuctionMoneyFrame_FontString_MinGainTip", "ARTWORK", "GameFontNormal");
	AuctionMoneyFrame_FontString_MinGainTip:SetText("|cffffffffThe minimum potential gain based on the|nstarting bid of your auctions.|r");
	AuctionMoneyFrame_FontString_MinGainTip:SetJustifyH("LEFT");

	CreateFrame("Frame", "AuctionMoneyFrame_MoneyFrame_MinGain", AuctionMoneyFrame, "SmallMoneyFrameTemplate");
	MoneyFrame_SetType("AUCTION", AuctionMoneyFrame_MoneyFrame_MinGain);

	CreateFrame("Frame", "AuctionMoneyFrame_MoneyFrame_MaxGain", AuctionMoneyFrame, "SmallMoneyFrameTemplate");
	MoneyFrame_SetType("AUCTION", AuctionMoneyFrame_MoneyFrame_MaxGain);

	CreateFrame("Frame", "AuctionMoneyFrame_MoneyFrame_GrtGain", AuctionMoneyFrame, "SmallMoneyFrameTemplate");
	MoneyFrame_SetType("AUCTION", AuctionMoneyFrame_MoneyFrame_GrtGain);
end

function AuctionMoneyFrame_OnEvent(this, event, arg1, ...)
	if (event == "ADDON_LOADED") then
		if (arg1 == "AuctionMoney") then
			AuctionMoneyFrame_Initialize();
		end

		if (arg1 == "Blizzard_AuctionUI") then
			-- Modify Blizzard's UI.
			AuctionMoney_ModifyBlizzardAuctionUI();
		end
	end

	if (event == "AUCTION_OWNED_LIST_UPDATE") then
		-- Update.
		AuctionMoney_Update();
	end
end

----------------------------------------------------------------------------------
-- Frame Initialization
----------------------------------------------------------------------------------

-- Create a simple frame.
CreateFrame("Frame", "AuctionMoneyFrame", UIParent, nil);

-- Set the OnEvent function for our frame.
AuctionMoneyFrame:SetScript("OnEvent", AuctionMoneyFrame_OnEvent);

-- Register our desired events.
AuctionMoneyFrame:RegisterEvent("ADDON_LOADED");
AuctionMoneyFrame:RegisterEvent("AUCTION_OWNED_LIST_UPDATE");

-- Set our size.
AuctionMoneyFrame:SetWidth(FRAME_WIDTH);
AuctionMoneyFrame:SetHeight(200);

-- Set our position.
AuctionMoneyFrame:SetPoint("CENTER", nil, "CENTER", 0, 0);

-- Set our Backdrop.
AuctionMoneyFrame:SetBackdrop({bgFile = "Interface/Tooltips/UI-Tooltip-Background", 
                                            edgeFile = "Interface/Tooltips/UI-Tooltip-Border", 
                                            tile = true, tileSize = 16, edgeSize = 16, 
                                            insets = { left = 5, right = 5, top = 5, bottom = 5 }});

-- Make it similar to Blizzard's.
AuctionMoneyFrame:SetBackdropBorderColor(1, 1, 1);
AuctionMoneyFrame:SetBackdropColor(0.09, 0.09, 0.19);

-- Set our strata.
AuctionMoneyFrame:SetFrameStrata("TOOLTIP");

-- Our frame should be hidden for now.
AuctionMoneyFrame:Hide();

----------------------------------------------------------------------------------
----------------------------------------------------------------------------------