﻿local L = AceLibrary("AceLocale-2.2"):new("AspectsBar")
local inCombat = false

L:RegisterTranslations("enUS", function() return {
	["AspectsBar"] = true,
	["Config"] = true,
	["Set Config"] = true,
	["Scale"] = true,
	["Set Scale"] = true,
	["Alpha"] = true,
	["Set Alpha"] = true,
	["Button"] = true,
	["Select button displayed"] = true,
	["Show %s button"] = true,
	["Bar Config"] = true,
	["Set Bar Appearnce"] = true,
	["Direct"] = true,
	["Set Direct"] = true,
	["Vertical"] = true,
	["Horizontal"] = true,
	["Order"] = true,
	["Set Order"] = true,
	["Normal"] = true,
	["Reverse"] = true,
	["Show"] = true,
	["Config %s Button"] = true,
	["Adjust button order"] = true,
	["Binding"] = true,
	["Set %s button binding key"] = true,
	["Help"] = true,
	["To move bar, Ctrl+Right Drag button\nTo change button order, use button show function."] = true,
} end)

L:RegisterTranslations("koKR", function() return {
	["AspectsBar"] = "상바",
	["Config"] = "설정",
	["Set Config"] = "설정을 변경합니다",
	["Scale"] = "크기",
	["Set Scale"] = "크기를 조절합니다",
	["Alpha"] = "투명도",
	["Set Alpha"] = "투명도를 조절합니다",
	["Button"] = "버튼",
	["Select button displayed"] = "버튼의 표시 여부를 선택합니다",
	["Show %s button"] = "%s 버튼을 표시합니다",
	["Bar Config"] = "바 설정",
	["Set Bar Appearnce"] = "바의 외양을 설정합니다",
	["Direct"] = "방향",
	["Set Direct"] = "바의 방향을 설정합니다",
	["Vertical"] = "수직",
	["Horizontal"] = "수평",
	["Order"] = "순서",
	["Set Order"] = "버튼의 배열 순서를 설정합니다",
	["Normal"] = "정상",
	["Reverse"] = "역순",
	["Show"] = "표시",
	["Config %s Button"] = "%s 버튼에 대한 설정을 변경합니다",
	["Adjust button order"] = "버튼의 순서를 조정합니다",
	["Binding"] = "단축키",
	["Set %s button binding key"] = "%s 버튼에 대한 단축키를 설정합니다",
	["Help"] = "도움말",
	["To move bar, Ctrl+Right Drag button\nTo change button order, use button show function."] = "바를 이동하기 위해서는 버튼을 Ctrl 우클릭으로 드래그 하세요.\n버튼 순서를 조정하기 위해서는 버튼 표시 기능을 활용하세요.",
} end)

AspectsBar = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceEvent-2.0", "AceDB-2.0");
local BS = LibStub:GetLibrary("LibBabble-Spell-3.0"):GetLookupTable()

local AspectsBarOptionTable = {
	name = L["AspectsBar"],
	desc = L["AspectsBar"],
	type = "group",
	args = {
		Help = {
			name = L["Help"],
			desc = L["Help"],
			type = 'execute',
			func = function()
				AspectsBar:Print(L["To move bar, Ctrl+Right Drag button\nTo change button order, use button show function."])
			end,
		},
		Config = {
			name = L["Config"],
			desc = L["Set Config"],
			type = "group",
			args = {
				Scale = {
					name = L["Scale"],
					desc = L["Set Scale"],
					type = "range",
					min = 0.1,
					max = 2.5,
					step = 0.1,
					get = function() return AspectsBar.db.profile.Scale end,
					set = function(v)
						AspectsBar.db.profile.Scale = v
						AspectsBar:SetUp()
						AspectsBarFrame:Show();
					end,
				},
				Alpha = {
					name = L["Alpha"],
					desc = L["Set Alpha"],
					type = "range",
					min = 0.0,
					max = 1.0,
					step = 0.05,
					get = function() return AspectsBar.db.profile.Alpha end,
					set = function(v)
						AspectsBar.db.profile.Alpha = v
						AspectsBar:SetUp()
						AspectsBarFrame:Show();
					end,
				},
				Bar = {
					name = L["Bar Config"],
					desc = L["Set Bar Appearnce"],
					type = "group",
					args = {
						Direct = {
							name = L["Direct"],
							desc = L["Set Direct"],
							type = "text",
							get = function() return AspectsBar.db.profile.Direct end,
							set = function(v) 
								AspectsBar.db.profile.Direct = v
								AspectsBar:SetUp()
								AspectsBarFrame:Show();
							end,
							validate = {["Vertical"] = L["Vertical"], ["Horizontal"] = L["Horizontal"]}
						},
						Order = {
							name = L["Order"],
							desc = L["Set Order"],
							type = "text",
							get = function() return AspectsBar.db.profile.Reverse end,
							set = function(v) 
								AspectsBar.db.profile.Reverse = v
								AspectsBar:SetUp()
								AspectsBarFrame:Show();
							end,
							validate = {["Normal"] = L["Normal"], ["Reverse"] = L["Reverse"]}
						},
					},
				},
				Button = {
					name = L["Button"],
					desc = L["Select button displayed"],
					type = 'group',
					args = {
						Hawk = {
							name = BS["Aspect of the Hawk"],
							desc = (L["Config %s Button"]):format( BS["Aspect of the Hawk"]),
							order = 1,
							type = 'group',
							args = {
								Show = {
									name = L["Show"],
									desc = (L["Show %s button"]):format(BS["Aspect of the Hawk"]),
									disabled = function() return InCombatLockdown() end,
									type = 'toggle',
									get = function() return AspectsBar.db.profile.Hawk.Show end,
									set = function()
										AspectsBar.db.profile.Hawk.Show = not AspectsBar.db.profile.Hawk.Show
										AspectsBar:SetButtonNum(AspectsBar.db.profile.Hawk.Show, BS["Aspect of the Hawk"])
									end
								},
								Binding = {
									name = L["Binding"],
									desc = (L["Set %s button binding key"]):format(BS["Aspect of the Hawk"]),
									type = 'text',
									validate = 'keybinding',
									disabled = function() return InCombatLockdown() end,
									get = function() return GetBindingKey("SPELL "..BS["Aspect of the Hawk"]) end,
									set = function(v)
										AspectsBar:SetBinding(BS["Aspect of the Hawk"], v)
									end,
								},
							},
						},
						Monkey = {
							name = BS["Aspect of the Monkey"],
							desc = (L["Config %s Button"]):format( BS["Aspect of the Monkey"]),
							order = 2,
							type = 'group',
							args = {
								Show = {
									name = L["Show"],
									desc = (L["Show %s button"]):format(BS["Aspect of the Monkey"]),
									type = 'toggle',
									disabled = function() return InCombatLockdown() end,
									get = function() return AspectsBar.db.profile.Monkey.Show end,
									set = function()
										AspectsBar.db.profile.Monkey.Show = not AspectsBar.db.profile.Monkey.Show
										AspectsBar:SetButtonNum(AspectsBar.db.profile.Monkey.Show, BS["Aspect of the Monkey"])
									end
								},
								Binding = {
									name = L["Binding"],
									desc = (L["Set %s button binding key"]):format(BS["Aspect of the Monkey"]),
									type = 'text',
									validate = 'keybinding',
									disabled = function() return InCombatLockdown() end,
									get = function() return GetBindingKey("SPELL "..BS["Aspect of the Monkey"]) end,
									set = function(v)
										AspectsBar:SetBinding(BS["Aspect of the Monkey"], v)
									end,
								},
							},
						},
						Cheetah = {
							name = BS["Aspect of the Cheetah"],
							desc = (L["Config %s Button"]):format( BS["Aspect of the Cheetah"]),
							order = 3,
							type = 'group',
							args = {
								Show = {
									name = L["Show"],
									desc = (L["Show %s button"]):format(BS["Aspect of the Cheetah"]),
									type = 'toggle',
									disabled = function() return InCombatLockdown() end,
									get = function() return AspectsBar.db.profile.Cheetah.Show end,
									set = function()
										AspectsBar.db.profile.Cheetah.Show = not AspectsBar.db.profile.Cheetah.Show
										AspectsBar:SetButtonNum(AspectsBar.db.profile.Cheetah.Show, BS["Aspect of the Cheetah"])
									end
								},
								Binding = {
									name = L["Binding"],
									desc = (L["Set %s button binding key"]):format(BS["Aspect of the Cheetah"]),
									type = 'text',
									validate = 'keybinding',
									disabled = function() return InCombatLockdown() end,
									get = function() return GetBindingKey("SPELL "..BS["Aspect of the Cheetah"]) end,
									set = function(v)
										AspectsBar:SetBinding(BS["Aspect of the Cheetah"], v)
									end,
								},
							},
						},
						Pack = {
							name = BS["Aspect of the Pack"],
							desc = (L["Config %s Button"]):format( BS["Aspect of the Pack"]),
							order = 4,
							type = 'group',
							args = {
								Show = {
									name = L["Show"],
									desc = (L["Show %s button"]):format(BS["Aspect of the Pack"]),
									type = 'toggle',
									disabled = function() return InCombatLockdown() end,
									get = function() return AspectsBar.db.profile.Pack.Show end,
									set = function()
										AspectsBar.db.profile.Pack.Show = not AspectsBar.db.profile.Pack.Show
										AspectsBar:SetButtonNum(AspectsBar.db.profile.Pack.Show, BS["Aspect of the Pack"])
									end
								},
								Binding = {
									name = L["Binding"],
									desc = (L["Set %s button binding key"]):format(BS["Aspect of the Pack"]),
									type = 'text',
									validate = 'keybinding',
									disabled = function() return InCombatLockdown() end,
									get = function() return GetBindingKey("SPELL "..BS["Aspect of the Pack"]) end,
									set = function(v)
										AspectsBar:SetBinding(BS["Aspect of the Pack"], v)
									end,
								},
							},
						},
						Beast = {
							name = BS["Aspect of the Beast"],
							desc = (L["Config %s Button"]):format( BS["Aspect of the Beast"]),
							order = 5,
							type = 'group',
							args = {
								Show = {
									name = L["Show"],
									desc = (L["Show %s button"]):format(BS["Aspect of the Beast"]),
									type = 'toggle',
									disabled = function() return InCombatLockdown() end,
									get = function() return AspectsBar.db.profile.Beast.Show end,
									set = function()
										AspectsBar.db.profile.Beast.Show = not AspectsBar.db.profile.Beast.Show
										AspectsBar:SetButtonNum(AspectsBar.db.profile.Beast.Show, BS["Aspect of the Beast"])
									end
								},
								Binding = {
									name = L["Binding"],
									desc = (L["Set %s button binding key"]):format(BS["Aspect of the Beast"]),
									type = 'text',
									validate = 'keybinding',
									disabled = function() return InCombatLockdown() end,
									get = function() return GetBindingKey("SPELL "..BS["Aspect of the Beast"]) end,
									set = function(v)
										AspectsBar:SetBinding(BS["Aspect of the Beast"], v)
									end,
								},
							},
						},
						Wild = {
							name = BS["Aspect of the Wild"],
							desc = (L["Config %s Button"]):format( BS["Aspect of the Wild"]),
							order = 6,
							type = 'group',
							args = {
								Show = {
									name = L["Show"],
									desc = (L["Show %s button"]):format(BS["Aspect of the Wild"]),
									type = 'toggle',
									disabled = function() return InCombatLockdown() end,
									get = function() return AspectsBar.db.profile.Wild.Show end,
									set = function()
										AspectsBar.db.profile.Wild.Show = not AspectsBar.db.profile.Wild.Show
										AspectsBar:SetButtonNum(AspectsBar.db.profile.Wild.Show, BS["Aspect of the Wild"])
									end
								},
								Binding = {
									name = L["Binding"],
									desc = (L["Set %s button binding key"]):format(BS["Aspect of the Wild"]),
									type = 'text',
									validate = 'keybinding',
									disabled = function() return InCombatLockdown() end,
									get = function() return GetBindingKey("SPELL "..BS["Aspect of the Wild"]) end,
									set = function(v)
										AspectsBar:SetBinding(BS["Aspect of the Wild"], v)
									end,
								},
							},
						},
						Viper = {
							name = BS["Aspect of the Viper"],
							desc = (L["Config %s Button"]):format( BS["Aspect of the Viper"]),
							order = 7,
							type = 'group',
							args = {
								Show = {
									name = L["Show"],
									desc = (L["Show %s button"]):format(BS["Aspect of the Viper"]),
									type = 'toggle',
									disabled = function() return InCombatLockdown() end,
									get = function() return AspectsBar.db.profile.Viper.Show end,
									set = function()
										AspectsBar.db.profile.Viper.Show = not AspectsBar.db.profile.Viper.Show
										AspectsBar:SetButtonNum(AspectsBar.db.profile.Viper.Show, BS["Aspect of the Viper"])
									end
								},
								Binding = {
									name = L["Binding"],
									desc = (L["Set %s button binding key"]):format(BS["Aspect of the Viper"]),
									type = 'text',
									validate = 'keybinding',
									disabled = function() return InCombatLockdown() end,
									get = function() return GetBindingKey("SPELL "..BS["Aspect of the Viper"]) end,
									set = function(v)
										AspectsBar:SetBinding(BS["Aspect of the Viper"], v)
									end,
								},
							},
						},
					},
				},
			},
		},
	}
}

function AspectsBar:OnInitialize()
	local defaults = {
		Scale = 1,
		Alpha = 1,
		Direct = "Horizontal",
		Reverse = "Normal",
		Hawk = {Show = true, Order = 1},
		Monkey = {Show = true, Order = 2},
		Cheetah = {Show = true, Order = 3},
		Pack = {Show = true, Order = 4},
		Beast = {Show = true, Order = 5},
		Wild = {Show = true, Order = 6},
		Viper = {Show = true, Order = 7},
		Number = 7,
		AspectsList = {
			[1] = BS["Aspect of the Hawk"],
			[2] = BS["Aspect of the Monkey"],
			[3] = BS["Aspect of the Cheetah"],
			[4] = BS["Aspect of the Pack"],
			[5] = BS["Aspect of the Beast"],
			[6] = BS["Aspect of the Wild"],
			[7] = BS["Aspect of the Viper"],
			[8] = nil,
		}
	}

	self:RegisterDB("AspectsBarDB")
	self:RegisterDefaults('profile', defaults)
	self:RegisterChatCommand('/abar', AspectsBarOptionTable)

	AspectsBar:SetUp()
end

function AspectsBar:SetTooltip()
	if (this:GetAttribute("id")) then
		GameTooltip_SetDefaultAnchor(GameTooltip, this);
		GameTooltip:SetSpell(this:GetAttribute("id"), SpellBookFrame.bookType);
		GameTooltip:Show();
	end
end

function AspectsBar:SetButtonNum(value, asp)
	if value == true then
		AspectsBar.db.profile.Number = AspectsBar.db.profile.Number  + 1
		if not AspectsBar.db.profile.AspectsList then
			AspectsBar.db.profile.AspectsList = { }
		end
		AspectsBar.db.profile.AspectsList[AspectsBar.db.profile.Number] = asp
--		tinsert(AspectsBar.db.profile.AspectsList, AspectsBar.db.profile.Number, asp)
		getglobal("AspectsBarButton"..AspectsBar.db.profile.Number):Show()
	else
		AspectsBar.db.profile.Number = AspectsBar.db.profile.Number  - 1
		getglobal("AspectsBarButton"..AspectsBar.db.profile.Number + 1):Hide()
		for k, v in pairs(AspectsBar.db.profile.AspectsList) do
			if v == asp then
--				tremove(AspectsBar.db.profile.AspectsList, k)
				for i = k, 7 do
					AspectsBar.db.profile.AspectsList[i] = AspectsBar.db.profile.AspectsList[i+1]
				end
			end
		end
	end
	AspectsBar:UPDATE()
end

function AspectsBar:SetBinding(asp, bind)
	local clear1, clear2 = GetBindingKey("SPELL "..asp)
	if clear1 then
		SetBinding(clear1)
	end
	if clear2 then
		SetBinding(clear2)
	end
	SetBinding(bind)
	SetBindingSpell(bind, asp)
	SaveBindings(GetCurrentBindingSet())
end

function AspectsBar:SetOrder(as, o)
	
end

function AspectsBar:GetSpellID(spell, rank)
	local i = 1;
	local spellID, highestRank;
	while true do
		local spellName, spellRank = GetSpellName(i, SpellBookFrame.bookType);
		if (not spellName) then
			break;
		end
		if (spellName == spell) then
			if (rank) then
				if (spellRank == rank) then
					return i;
				end
			else
				spellID = i;
				highestRank = spellRank;
			end
		end
		i = i + 1;
		if (i > 250) then
			break;
		end
	end			
	return spellID, highestRank;
end

function AspectsBar:OnEnable()
	self:RegisterEvent("SPELLS_CHANGED", "UPDATE")
	self:RegisterEvent("PLAYER_AURAS_CHANGED", "UPDATE")
	self:RegisterEvent("SPELL_UPDATE_COOLDOWN")
	self:RegisterEvent("PLAYER_REGEN_ENABLED")
	self:RegisterEvent("PLAYER_REGEN_DISABLED")
end

function AspectsBar:PLAYER_REGEN_ENABLED()
	inCombat = false
end

function AspectsBar:PLAYER_REGEN_DISABLED()
	inCombat = true
end

function AspectsBar:SetUp()
	-- This function cannot be performed in combat.
        if (InCombatLockdown() == nil) then
		if (AspectsBar.db.profile) then
			if AspectsBar.db.profile.Number > 1 then
				if (AspectsBar.db.profile.Direct == "Vertical" and AspectsBar.db.profile.Reverse == "Normal") then
					for i = 2, AspectsBar.db.profile.Number do
						local button = getglobal("AspectsBarButton"..i);
						button:ClearAllPoints();
						button:SetPoint("TOP", "AspectsBarButton"..i - 1, "BOTTOM", 0, 1);
					end
				elseif (AspectsBar.db.profile.Direct == "Vertical" and AspectsBar.db.profile.Reverse == "Reverse") then
					for i = 2, AspectsBar.db.profile.Number do
						local button = getglobal("AspectsBarButton"..i);
						button:ClearAllPoints();
						button:SetPoint("BOTTOM", "AspectsBarButton"..i - 1, "TOP", 0, 1);
					end
				elseif (AspectsBar.db.profile.Direct == "Horizontal" and AspectsBar.db.profile.Reverse == "Normal") then
					for i = 2, AspectsBar.db.profile.Number do
						local button = getglobal("AspectsBarButton"..i);
						button:ClearAllPoints();
						button:SetPoint("LEFT", "AspectsBarButton"..i - 1, "RIGHT", 1, 0);
					end
				elseif (AspectsBar.db.profile.Direct == "Horizontal" and AspectsBar.db.profile.Reverse == "Reverse") then
					for i = 2, AspectsBar.db.profile.Number do
						local button = getglobal("AspectsBarButton"..i);
						button:ClearAllPoints();
						button:SetPoint("RIGHT", "AspectsBarButton"..i - 1, "LEFT", 1, 0);
					end
				else
					for i = 2, AspectsBar.db.profile.Number do
						local button = getglobal("AspectsBarButton"..i);
						button:ClearAllPoints();
						button:SetPoint("LEFT", "AspectsBarButton"..i - 1, "RIGHT", 1, 0);
					end
				end
			end
			if AspectsBar.db.profile.Scale then
				AspectsBarFrame:SetScale(AspectsBar.db.profile.Scale)
			else
				AspectsBarFrame:SetScale(1)
			end
			if AspectsBar.db.profile.Alpha then
				AspectsBarFrame:SetAlpha(AspectsBar.db.profile.Alpha)
			else
				AspectsBarFrame:SetAlpha(1)
			end

		end
	end
end

function AspectsBar:UPDATE()
	local i, button, p, l;
	if (AspectsBar.db.profile and not inCombat) then
		i = 0;
		-- This function cannot be performed in combat.
		if (InCombatLockdown() == nil) then
			for key in pairs(AspectsBar.db.profile.AspectsList) do
				if getglobal("AspectsBarButton"..key) then
					getglobal("AspectsBarButton"..key):Hide();
				end
			end
			AspectsBar:SetUp()
			AspectsBarFrame:Show();
		end
		for key, value in pairs(AspectsBar.db.profile.AspectsList) do
			local id = AspectsBar:GetSpellID(value);
			if (id) then
				i = i + 1;
 				button = getglobal("AspectsBarButton"..i);
				-- This function cannot be performed in combat.
        			if (InCombatLockdown() == nil) then
					if button then
						button:SetAttribute("type", "spell");
						button:SetAttribute("spell", value);
					end
				end

  				local texture = GetSpellTexture(id, BOOKTYPE_SPELL);
				for z = 0, 7 do
					if (GetPlayerBuffTexture(z) == texture) then
						texture = "Interface\\Icons\\Spell_Nature_WispSplode";
					end
				end
				if button then
					getglobal("AspectsBarButton"..i.."Icon"):SetTexture(texture);
					button:SetAttribute("id",id);

					-- This function cannot be performed in combat.
					if (InCombatLockdown() == nil) then
						if ( i > AspectsBar.db.profile.Number ) then
							button:SetAlpha(0);
							button:Hide();
						else
							button:Show();
							button:SetAlpha(AspectsBar.db.profile.Alpha)
						end
					end
				end
			end
		end
		-- This function cannot be performed in combat.
		if ((i == 0) and (InCombatLockdown() == nil)) then
			AspectsBarFrame:Hide();
		end
	end
end

function AspectsBar:SPELL_UPDATE_COOLDOWN()
	for i = 1, AspectsBar.db.profile.Number do
		button = getglobal("AspectsBarButton"..i);
		if (button:GetAttribute("id")) then
			local cooldown = getglobal(button:GetName().."Cooldown");
			local start, duration, enable = GetSpellCooldown(button:GetAttribute("id"), SpellBookFrame.bookType);
			if (start > 0 and duration > 0) then
				cooldown:SetCooldown(start, duration);
			end
		end
	end
end
