-------------------------------------------------------------------------------
-- Constants
-------------------------------------------------------------------------------

ASPECTED_ACTIVE_NORMAL = "Interface\\Icons\\Spell_Nature_WispSplode";
ASPECTED_ACTIVE_PRIEST = "Interface\\Icons\\Spell_Shadow_ChillTouch";

-------------------------------------------------------------------------------
-- Variables
-------------------------------------------------------------------------------

Aspected_ClassSpells = {};
Aspected_SpellButtons = {};
Aspected_FormID = {};
Aspected_PageID = {};
Aspected_OldPageID = nil;
Aspected_SwapPage = false;
AspectedVersion = "2.0.12.0"

-------------------------------------------------------------------------------
-- Functions
-------------------------------------------------------------------------------

-- Executed on load, calls general set-up functions
function Aspected_OnLoad()
	local class = UnitClass("player");

	-- Store the spell list for later
	Aspected_ClassSpells = ASPECTED_SPELLS[class];

  if (not Aspected_ClassSpells) then
    return;
  end

	Aspected_Original_GetNumShapeshiftForms = GetNumShapeshiftForms;
	GetNumShapeshiftForms = Aspected_GetNumShapeshiftForms;
	Aspected_Original_GetShapeshiftFormInfo = GetShapeshiftFormInfo;
	GetShapeshiftFormInfo = Aspected_GetShapeshiftFormInfo;
	Aspected_Original_GetShapeshiftForm = GetShapeshiftForm;
	GetShapeshiftForm = Aspected_GetShapeshiftForm;

	this:RegisterEvent("PLAYER_AURAS_CHANGED");
	this:RegisterEvent("ACTIONBAR_PAGE_CHANGED");
	this:RegisterEvent("PLAYER_LOGIN");
	this:RegisterEvent("ADDON_LOADED");
	this:RegisterEvent("ACTIONBAR_UPDATE_USABLE");
	this:RegisterEvent("ACTIONBAR_UPDATE_COOLDOWN");
  this:RegisterEvent("TRAINER_CLOSED");
  this:RegisterEvent("UPDATE_BINDINGS");

  DEFAULT_CHAT_FRAME:AddMessage("Aspected Again version "..AspectedVersion.." loaded.");
end

-- Handles events, only called when the player's buffs or pages change
function Aspected_OnEvent(event)
  if (event == "ADDON_LOADED") then
    this:UnregisterEvent("ADDON_LOADED");
    Aspected_InitButtons();
  elseif (event == "PLAYER_LOGIN") then
    this:UnregisterEvent("PLAYER_LOGIN");
    Aspected_InitButtons();
    Aspected_UpdateButtons();
    Aspected_UpdateBindings();
    Aspected_UpdateCooldown();
  elseif (event == "PLAYER_AURAS_CHANGED") then
    Aspected_UpdateButtons();
  elseif (event == "UPDATE_BINDINGS") then
    Aspected_UpdateBindings();
  elseif (event == "TRAINER_CLOSED") then
    Aspected_UpdateButtons();
    Aspected_UpdateBindings();
  elseif (event=="ACTIONBAR_UPDATE_USABLE" or event == "ACTIONBAR_UPDATE_COOLDOWN") then
    Aspected_UpdateCooldown();
  end
end

-- Generate the tooltip for the new buttons
function Aspected_OnEnter()
  local id = this:GetID();
  local spellname = Aspected_SpellButtons[id];
  local spellid = Aspected_GetAspectID(spellname)
  GameTooltip:SetOwner(this, "ANCHOR_PRESERVE");
  if (spellid > -1) then
    GameTooltip:SetSpell(spellid,1);
    GameTooltip:Show();
  end
end

-- Count the number of shapeshift forms provided by Blizzard, 
-- then add our own. 
function Aspected_GetNumShapeshiftForms()
  local numForms = Aspected_Original_GetNumShapeshiftForms();
	for n = 1, #Aspected_ClassSpells do
    local spell = Aspected_ClassSpells[n];
		if ( Aspected_GetAspectID(spell) > -1 ) then
      numForms = numForms + 1;
      Aspected_FormID[spell] = numForms;
    end
  end
	return numForms;
end

-- Rename the Blizzard shapeshift buttons and 
-- replace them with our own
function Aspected_InitButtons()
  local i = Aspected_Original_GetNumShapeshiftForms() + 1;
  local j = Aspected_GetNumShapeshiftForms();
  if (i > 1) then
    local h = i - 1;
    local ab = getglobal("AspectedButton"..i);
    local ssb = getglobal("ShapeshiftButton"..h);
    ab:SetPoint("TOPLEFT",ssb,"TOPRIGHT",7,0);
  end
  for n = i,j do
    local ab = getglobal("AspectedButton"..n);
    local ssb = getglobal("ShapeshiftButton"..n);
    setglobal("OldShapeshiftButton"..n,ssb);
    setglobal("ShapeshiftButton"..n,ab);
		ab:CreateFontString("ShapeshiftButton"..n.."HotKeyRound","ARTWORK","NumberFontNormalSmallGray");
		setglobal("AspectedButton"..n.."NormalTexture",getglobal("ShapeshiftButton"..n.."NormalTexture"));
    ssb:Hide();
		ab:SetNormalTexture(nil);
  end
	ShapeshiftBarFrame:Show();
end

-- Map the spells to the buttons
function Aspected_UpdateButtons()
  if (not InCombatLockdown()) then
    local i = Aspected_Original_GetNumShapeshiftForms() + 1;
    local n = 1;
    ShapeshiftBar_Update();
    ShapeshiftBarMiddle:Hide();
    for n = 1, #Aspected_ClassSpells do
      local spell = Aspected_ClassSpells[n];
      local button = getglobal("AspectedButton"..i);
      local ssb = getglobal("ShapeshiftButton"..i);
      local icon = getglobal("AspectedButton"..i.."Icon");
      local id = Aspected_GetAspectID(spell);
      if (id > -1) then
        Aspected_SpellButtons[i] = spell;
        local texture, name, isActive, isCastable = Aspected_GetShapeshiftFormInfo(i);
        if (isActive) then
          button:SetChecked(1);
        else
          button:SetChecked(0);
        end
        button:Enable();
        button:Show();
        icon:SetTexture(texture);
        button:SetAttribute("type1","spell");
        button:SetAttribute("spell1",spell);
        i = i + 1;
      else
        button:Hide();
      end
    end
	  ShapeshiftBarFrame:Show();
  end
end

-- Replace Blizzard's bindings of Shapeshift buttons with our own
function Aspected_UpdateBindings()
  local blizforms = Aspected_Original_GetNumShapeshiftForms();
  local totalforms = Aspected_GetNumShapeshiftForms();
  ClearOverrideBindings(AspectedBarFrame);
  for n = 1,totalforms do
    local button = getglobal("AspectedButton"..n);
    local key1, key2 = GetBindingKey("SHAPESHIFTBUTTON"..n);
    if (n > blizforms) then 
      if (key1) then
        SetOverrideBindingClick(AspectedBarFrame,true,key1,"AspectedButton"..n);
      end
      if (key2) then
        SetOverrideBindingClick(AspectedBarFrame,true,key2,"AspectedButton"..n);
      end
    end
  end
end

-- Update cooldown on Aspected buttons
function Aspected_UpdateCooldown()
  for n = 1, 10 do
    local child = getglobal("AspectedButton"..n);
    if (child) then
      local isEnabled = child:IsEnabled();
      if (isEnabled) then
        local cooldown = getglobal(child:GetName().."Cooldown");
        local spellname = Aspected_SpellButtons[child:GetID()];
	      local id = Aspected_GetAspectID(spellname);
	      if (id > -1) then
          local start, duration, enable = GetSpellCooldown(id,BOOKTYPE_SPELL);
          CooldownFrame_SetTimer(cooldown, start, duration, enable);
        end
      end
    end
  end
end

-------------------------
-- Low level functions --
-------------------------
-- Get texture information for each spell button
function Aspected_GetShapeshiftFormInfo(buttonid)
	local name, texture = Aspected_GetAspectFromID(buttonid);
	if ( name ) then
		local isActive = Aspected_IsAspectActive(texture);
    local isCastable = true;
		-- Fix to darken it while active
		if ( isActive ) then
			if ( UnitClass("player") == ASPECTED_CLASS_PRIEST ) then
				texture = ASPECTED_ACTIVE_PRIEST;
			else
				texture = ASPECTED_ACTIVE_NORMAL;
			end
		end
		return texture, name, isActive, isCastable;
  else
    return Aspected_Original_GetShapeshiftFormInfo(buttonid);
  end
end

-- Return spell id from spell name
function Aspected_GetAspectID(aspect)
	local i = 1;
	local valid = -1;
	local spellName, spellRank = GetSpellName(i, BOOKTYPE_SPELL)
	while spellName do
		if ( spellName == aspect) then
			valid = i;
    elseif ( valid > -1 ) then
			return valid;
		end
		i = i + 1;
		spellName, spellRank = GetSpellName(i, BOOKTYPE_SPELL)
	end
	return valid;
end

-- Return spell name and texture from button id
function Aspected_GetAspectFromID(buttonid)
	for spell,i in pairs(Aspected_FormID) do
		if ( i == buttonid ) then
      local texture = GetSpellTexture(Aspected_GetAspectID(spell), BOOKTYPE_SPELL);
			return spell, texture;
		end
	end
	return nil;
end

-- Returns whether the player has the aspect on or not, based on his buffs
function Aspected_IsAspectActive(texture)
	for id = 0, 15 do
		if ( GetPlayerBuffTexture(id) == texture ) then
			return true;
		end
	end
	return false;
end

function Aspected_GetShapeshiftForm(var)
  for i = 1,10 do
    local texture,name,isActive = Aspected_GetShapeshiftFormInfo(i);  
    if (isActive) then
      return i;
    end
  end  
  return Aspected_Original_GetShapeshiftForm(var);
end
