--[[
	Armory Addon for World of Warcraft(tm).
	Revision: $Id: ArmoryTitan.lua,v 1.8, 2008-06-26 09:44:20Z, Maxim Baars$
    URL: http://www.wow-neighbours.com

	License:
		This program is free software; you can redistribute it and/or
		modify it under the terms of the GNU General Public License
		as published by the Free Software Foundation; either version 2
		of the License, or (at your option) any later version.

		This program is distributed in the hope that it will be useful,
		but WITHOUT ANY WARRANTY; without even the implied warranty of
		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
		GNU General Public License for more details.

		You should have received a copy of the GNU General Public License
		along with this program(see GPL.txt); if not, write to the Free Software
		Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

	Note:
		This AddOn's source code is specifically designed to work with
		World of Warcraft's interpreted AddOn system.
		You have an implicit licence to use this AddOn with these facilities
		since that is it's designated purpose as per:
		http://www.fsf.org/licensing/licenses/gpl-faq.html#InterpreterIncompat
--]] 

local Orig_TitanPanelButton_SetButtonIcon = TitanPanelButton_SetButtonIcon;
function TitanPanelButton_SetButtonIcon(...)
    if ( Armory.dbLoaded ) then
        Armory:SetPortraitTexture(TitanPanelArmoryButtonIcon, "player");
    end
    return Orig_TitanPanelButton_SetButtonIcon(...);
end


function TitanPanelArmoryButton_OnLoad()
	this.registry = { 
		id = ARMORY_ID,
		version = Armory.version,
		menuText = ARMORY_TITLE,
		category = "Information",
		tooltipTitle = ARMORY_TITLE,
		tooltipTextFunction = "TitanPanelArmoryButton_GetTooltipText",
		iconWidth = 16,
		savedVariables = { ShowIcon = true }
	};
	
	table.insert(TITAN_PANEL_NONMOVABLE_PLUGINS, ARMORY_ID);
end

function TitanPanelArmoryButton_OnClick(button)
	if ( button == "LeftButton" ) then
		Armory:Toggle();
	end
end
 
function TitanPanelArmoryButton_GetTooltipText()
    local realm, character = Armory:GetPaperDollLastViewed();

    return ARMORY_TOOLTIP1.."\t"..HIGHLIGHT_FONT_COLOR_CODE..character.."\n"..
           ARMORY_TOOLTIP2.."\t"..HIGHLIGHT_FONT_COLOR_CODE..realm.."\n"..
           GREEN_FONT_COLOR_CODE..ARMORY_TOOLTIP_HINT1.."\n"..
           GREEN_FONT_COLOR_CODE..ARMORY_TOOLTIP_HINT2;
end

function TitanPanelRightClickMenu_PrepareArmoryMenu()
    ArmoryMenu_Initialize();
    
    if ( UIDROPDOWNMENU_MENU_LEVEL == 1 ) then 
        TitanPanelRightClickMenu_AddSpacer();
        TitanPanelRightClickMenu_AddCommand(TITAN_PANEL_MENU_HIDE, ARMORY_ID, TITAN_PANEL_MENU_FUNC_HIDE);
    end
end
