--[[
	Armory Addon for World of Warcraft(tm).
	Revision: $Id: ArmoryFu.lua,v 1.8, 2008-07-10 12:14:48Z, Maxim Baars$
    URL: http://www.wow-neighbours.com

	License:
		This program is free software; you can redistribute it and/or
		modify it under the terms of the GNU General Public License
		as published by the Free Software Foundation; either version 2
		of the License, or (at your option) any later version.

		This program is distributed in the hope that it will be useful,
		but WITHOUT ANY WARRANTY; without even the implied warranty of
		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
		GNU General Public License for more details.

		You should have received a copy of the GNU General Public License
		along with this program(see GPL.txt); if not, write to the Free Software
		Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

	Note:
		This AddOn's source code is specifically designed to work with
		World of Warcraft's interpreted AddOn system.
		You have an implicit licence to use this AddOn with these facilities
		since that is it's designated purpose as per:
		http://www.fsf.org/licensing/licenses/gpl-faq.html#InterpreterIncompat
--]] 

ArmoryFu = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0", "AceEvent-2.0", "AceDB-2.0");

local ArmoryFu = ArmoryFu;
local Tablet = AceLibrary("Tablet-2.0");

ArmoryFu.name = ARMORY_TITLE;
ArmoryFu.version = Armory.version;
ArmoryFu.description = ARMORY_DESCRIPTION;
ArmoryFu.category = "Inventory";
ArmoryFu.hasIcon = true;
ArmoryFu.hasNoText = true;
ArmoryFu.defaultPosition = "RIGHT";
ArmoryFu.defaultMinimapPosition = 285;
ArmoryFu.independentProfile = true;

function ArmoryFu:OnInitialize()
    local options = { handle="ArmoryFu", type="group", args={} };
    
    self.OnMenuRequest = options;
    self:RegisterDB("ArmoryFuDB");
    self:ScheduleRepeatingEvent(self.Update, 1, self);
	
	self:SetOption(options["args"], 1, "ARMORY_CMD_SET_SEARCHALL");
	self:SetOption(options["args"], 2, "ARMORY_CMD_SET_LASTVIEWED");
	self:SetOption(options["args"], 3, "ARMORY_CMD_SET_PERCHARACTER");
	self:SetOption(options["args"], 4, "ARMORY_CMD_SET_SHOWALTEQUIP");
	self:SetOption(options["args"], 5, "ARMORY_CMD_SET_SHOWUNEQUIP");
	self:SetOption(options["args"], 6, "ARMORY_CMD_SET_SHOWEQCTOOLTIPS");
	self:SetOption(options["args"], 7, "ARMORY_CMD_SET_SHOWITEMCOUNT");
	self:SetOption(options["args"], 8, "ARMORY_CMD_CHECK");
	self:SetOption(options["args"], 9, "ARMORY_CMD_RESET_FRAME");
	
	options["args"][ARMORY_SHARE_LABEL] = {
	    order = 10,
	    type = "group",
        name = ARMORY_SHARE_LABEL,
        desc = ARMORY_SHARE_TITLE,
        args = {}
    };
    options = options["args"][ARMORY_SHARE_LABEL];

   	self:SetOption(options["args"],  1, "ARMORY_CMD_SET_SHARESKILLS");
   	self:SetOption(options["args"],  2, "ARMORY_CMD_SET_SHAREQUESTS");
   	self:SetOption(options["args"],  3, "ARMORY_CMD_SET_SHARECHARACTER");
   	self:SetOption(options["args"],  4, "ARMORY_CMD_SET_SHAREALT");
   	self:SetOption(options["args"],  5, "ARMORY_CMD_SET_SHAREININSTANCE");
   	self:SetOption(options["args"],  6, "ARMORY_CMD_SET_SHAREINCOMBAT");
   	self:SetOption(options["args"],  7, "ARMORY_CMD_SET_SHOWSHAREMSG");
   	self:SetOption(options["args"],  8, "ARMORY_CMD_SET_SHAREALL");
   	self:SetOption(options["args"],  9, "ARMORY_CMD_SET_SHAREGUILD");
    self:SetOption(options["args"], 10, "ARMORY_CMD_LOOKUP");
end

function ArmoryFu:SetOption(args, order, label)
    local entry = Armory.options[label];
    local info = { order=order };
    
    info.type = entry.type;
    info.name = getglobal(label.."_MENUTEXT");
    info.desc = getglobal(label.."_TOOLTIP") or Armory:Proper(getglobal(label.."_TEXT"));
    if ( entry.type == "toggle" ) then
        info.set = entry.set;
        info.get = entry.get;
    else
        info.func = entry.run;
    end
    info.disabled = entry.disabled;
    
    args[label] = info;
end

function ArmoryFu:OnClick()
	Armory:Toggle();
end

function ArmoryFu:OnDataUpdate()
    if ( Armory.dbLoaded ) then
	    self:SetIcon(Armory:GetPortraitTexture("player"));
	end
end

function ArmoryFu:OnTooltipUpdate()
    local realm, character = Armory:GetPaperDollLastViewed();
    local cat = Tablet:AddCategory(
            "columns", 2,
            "child_textR", NORMAL_FONT_COLOR.r, "child_textG", NORMAL_FONT_COLOR.g, "child_textB", NORMAL_FONT_COLOR.b,
            "child_text2R", HIGHLIGHT_FONT_COLOR.r, "child_text2G", HIGHLIGHT_FONT_COLOR.g, "child_text2B", HIGHLIGHT_FONT_COLOR.b,
            "child_justify2", "RIGHT"
        );

    cat:AddLine("text", ARMORY_TOOLTIP1, "text2", character);
    cat:AddLine("text", ARMORY_TOOLTIP2, "text2", realm);
    if ( not self:IsTooltipDetached() ) then
        cat:AddLine("text", GREEN_FONT_COLOR_CODE..ARMORY_TOOLTIP_HINT1.."\n"..ARMORY_TOOLTIP_HINT2);
    end
end
