--[[
    Armory Addon for World of Warcraft(tm).
    Revision: $Id: ArmoryReputationFrame.lua,v 1.7, 2008-07-03 11:23:10Z, Maxim Baars$
    URL: http://www.wow-neighbours.com

    License:
        This program is free software; you can redistribute it and/or
        modify it under the terms of the GNU General Public License
        as published by the Free Software Foundation; either version 2
        of the License, or (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program(see GPL.txt); if not, write to the Free Software
        Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

    Note:
        This AddOn's source code is specifically designed to work with
        World of Warcraft's interpreted AddOn system.
        You have an implicit licence to use this AddOn with these facilities
        since that is it's designated purpose as per:
        http://www.fsf.org/licensing/licenses/gpl-faq.html#InterpreterIncompat
--]] 

ARMORY_NUM_FACTIONS_DISPLAYED = 15;
ARMORY_REPUTATIONFRAME_FACTIONHEIGHT = 26;

function ArmoryReputationFrame_OnLoad()
    this:RegisterEvent("PLAYER_ENTERING_WORLD");
    this:RegisterEvent("UPDATE_FACTION");
end

function ArmoryReputationFrame_OnEvent(event)
    if ( not Armory:CanHandleEvents() ) then
        return;
    elseif ( event == "PLAYER_ENTERING_WORLD" ) then
        this:UnregisterEvent("PLAYER_ENTERING_WORLD");
        Armory:Execute(ArmoryReputationFrame_UpdateFactions);
    elseif ( event == "UPDATE_FACTION" ) then
        Armory:Execute(ArmoryReputationFrame_UpdateFactions);
        Armory:Execute(ArmoryReputationFrame_Update);
    end
end

function ArmoryReputationFrame_OnShow()
    ArmoryReputationFrame_UpdateFactions();
    ArmoryReputationFrame_Update();
end

function ArmoryReputationFrame_UpdateFactions()
    -- SetFactions will trigger UPDATE_FACTION
    ArmoryReputationFrame:UnregisterEvent("UPDATE_FACTION");
    Armory:SetFactions();
    ArmoryReputationFrame:RegisterEvent("UPDATE_FACTION");
end

function ArmoryReputationFrame_Update()
    local numFactions = Armory:GetNumFactions();
    local factionIndex, factionName, factionStanding, factionBar, factionHeader, color, tooltipStanding;
    local name, description, standingID, barMin, barMax, barValue, atWarWith, canToggleAtWar, isHeader, isCollapsed, isWatched;
    local atWarIndicator, rightBarTexture;

    -- Update scroll frame
    if ( not FauxScrollFrame_Update(ArmoryReputationListScrollFrame, numFactions, ARMORY_NUM_FACTIONS_DISPLAYED, ARMORY_REPUTATIONFRAME_FACTIONHEIGHT ) ) then
        ArmoryReputationListScrollFrameScrollBar:SetValue(0);
    end
    local factionOffset = FauxScrollFrame_GetOffset(ArmoryReputationListScrollFrame);

    local gender = Armory:UnitSex("player");
    for i=1, ARMORY_NUM_FACTIONS_DISPLAYED, 1 do
        factionIndex = factionOffset + i;
        factionBar = getglobal("ArmoryReputationBar"..i);
        factionHeader = getglobal("ArmoryReputationHeader"..i);
        if ( factionIndex <= numFactions ) then
            name, description, standingID, barMin, barMax, barValue, atWarWith, canToggleAtWar, isHeader, isCollapsed, isWatched = Armory:GetFactionInfo(factionIndex);

            if ( isHeader ) then
                factionHeader:SetText(name);
                if ( isCollapsed ) then
                    factionHeader:SetNormalTexture("Interface\\Buttons\\UI-PlusButton-Up");
                else
                    factionHeader:SetNormalTexture("Interface\\Buttons\\UI-MinusButton-Up"); 
                end
                factionHeader.index = factionIndex;
                factionHeader.isCollapsed = isCollapsed;
                factionBar:Hide();
                factionHeader:Show();
            else
                factionStanding = GetText("FACTION_STANDING_LABEL"..standingID, gender);
                factionName = getglobal("ArmoryReputationBar"..i.."FactionName");
                factionName:SetText(name);
                getglobal("ArmoryReputationBar"..i.."FactionStanding"):SetText(factionStanding);

                atWarIndicator = getglobal("ArmoryReputationBar"..i.."AtWarCheck");
                rightBarTexture = getglobal("ArmoryReputationBar"..i.."ReputationBarRight");

                if ( atWarWith ) then
                    atWarIndicator:Show();
                else
                    atWarIndicator:Hide();
                end

                -- Normalize values
                barMax = barMax - barMin;
                barValue = barValue - barMin;
                barMin = 0;

                factionBar.id = factionIndex;
                factionBar.standingText = factionStanding;
                factionBar.tooltip = HIGHLIGHT_FONT_COLOR_CODE.." "..barValue.." / "..barMax..FONT_COLOR_CODE_CLOSE;
                factionBar:SetMinMaxValues(0, barMax);
                factionBar:SetValue(barValue);
                color = FACTION_BAR_COLORS[standingID];
                factionBar:SetStatusBarColor(color.r, color.g, color.b);
                factionBar:SetID(factionIndex);
                factionBar:Show();
                factionHeader:Hide();

                -- Update details if this is the selected faction
                if ( factionIndex == ArmoryReputationFrame.selectedFaction ) then
                    if ( ArmoryReputationDetailFrame:IsShown() ) then
                        ArmoryReputationDetailFactionName:SetText(name);
                        ArmoryReputationDetailFactionDescription:SetText(description);
                    end
                    getglobal("ArmoryReputationBar"..i.."Highlight1"):Show();
                    getglobal("ArmoryReputationBar"..i.."Highlight2"):Show();
                else
                    getglobal("ArmoryReputationBar"..i.."Highlight1"):Hide();
                    getglobal("ArmoryReputationBar"..i.."Highlight2"):Hide();
                end
            end
        else
            factionHeader:Hide();
            factionBar:Hide();
        end
    end
    if ( ArmoryReputationFrame.selectedFaction == 0 ) then
        ArmoryReputationDetailFrame:Hide();
    end
end

function ArmoryReputationBar_OnClick()
    if ( ArmoryReputationDetailFrame:IsShown() and (ArmoryReputationFrame.selectedFaction == this.id) ) then
        ArmoryReputationDetailFrame:Hide();
    else
        ArmoryReputationFrame.selectedFaction = this.id;
        ArmoryReputationDetailFrame:Show();
        ArmoryReputationFrame_Update();
    end
end
