--[[
    Armory Addon for World of Warcraft(tm).
    Revision: $Id: ArmoryInventoryIconViewFrame.lua,v 1.12, 2008-08-01 14:54:39Z, Maxim Baars$
    URL: http://www.wow-neighbours.com

    License:
        This program is free software; you can redistribute it and/or
        modify it under the terms of the GNU General Public License
        as published by the Free Software Foundation; either version 2
        of the License, or (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program(see GPL.txt); if not, write to the Free Software
        Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

    Note:
        This AddOn's source code is specifically designed to work with
        World of Warcraft's interpreted AddOn system.
        You have an implicit licence to use this AddOn with these facilities
        since that is it's designated purpose as per:
        http://www.fsf.org/licensing/licenses/gpl-faq.html#InterpreterIncompat
--]] 

ARMORY_MAX_CONTAINER_COLUMNS = 7;
ARMORY_MAX_CONTAINER_ITEMS = 50;
ARMORY_CONTAINER_OFFSET_X = 22;
ARMORY_CONTAINER_OFFSET_Y = -5;
ARMORY_CONTAINER_ROW_HEIGHT = 37;

ArmoryContainers = { BACKPACK_CONTAINER, 1, 2, 3, 4, KEYRING_CONTAINER, BANK_CONTAINER, 5, 6, 7, 8, 9, 10, 11, ARMORY_MAIL_CONTAINER, ARMORY_AUCTIONS_CONTAINER };

function ArmoryInventoryIconViewFrame_OnLoad()
    ArmoryInventoryIconViewFrameScrollBarScrollDownButton:SetScript("OnClick", ArmoryInventoryIconViewFrameDownArrow_OnClick);
    ArmoryInventoryIconViewFrameScrollBar:SetValue(0);
    for i = 1, #ArmoryContainers do
        getglobal("ArmoryInventoryContainer"..i.."Label"):SetID(ArmoryContainers[i]);
    end 
end

function ArmoryInventoryIconViewFrame_OnShow()
    Armory:SetInventoryItemNameFilter("");
    Armory:SetInventorySearchAllFilter(nil);
    ArmoryInventoryIconViewFrame_Update();
end

function ArmoryInventoryIconViewFrameDownArrow_OnClick()
    local parent = this:GetParent();
    parent:SetValue(parent:GetValue() + (parent:GetHeight() / 2));
end

function ArmoryInventoryContainerItemButton_OnEnter(self)
    local containerName = self:GetParent():GetName();
    local containerButton = getglobal(containerName.."Label");
    local containerId = containerButton:GetID();
    local itemIndex = self:GetID();
    Armory:SetBagItem(containerId, itemIndex);
end

function ArmoryInventoryIconViewFrame_ShowContainer(containerFrame)
    local containerName = containerFrame:GetName();
    local label = getglobal(containerName.."Label");
    local id = label:GetID();
    local containerTitle, numSlots, isCollapsed = Armory:GetInventoryContainerInfo(id);

    if ( id == KEYRING_CONTAINER ) then
        numSlots = Armory:GetKeyRingSize();
        containerTitle = KEYRING;
    elseif ( id == BANK_CONTAINER ) then
        containerTitle = ARMORY_BANK_CONTAINER_NAME;
    elseif ( id == ARMORY_MAIL_CONTAINER ) then
        containerTitle = INBOX;
    elseif ( id == ARMORY_AUCTIONS_CONTAINER ) then
        containerTitle = AUCTIONS;
    elseif ( containerTitle ) then
        local prefix = "";
        if ( id > NUM_BAG_SLOTS ) then
            prefix = ARMORY_BANK_CONTAINER_NAME.." #"..(id - NUM_BAG_SLOTS).." - ";
        elseif ( id > 0 ) then
            prefix = "#"..id.." - ";
        end
        containerTitle = prefix..format(CONTAINER_SLOTS, numSlots, containerTitle);
    else
		containerTitle = UNKNOWN;
    end

  	if ( numSlots > ARMORY_MAX_CONTAINER_ITEMS ) then
		numSlots = ARMORY_MAX_CONTAINER_ITEMS;
		containerTitle = format("%s (%d+)", containerTitle, numSlots);
	end 

    label:SetText(containerTitle);

    if ( isCollapsed ) then
        label:SetNormalTexture("Interface\\Buttons\\UI-PlusButton-Up");
    else
        label:SetNormalTexture("Interface\\Buttons\\UI-MinusButton-Up");
    end
    label.isCollapsed = isCollapsed;

    local itemButton, itemTexture;
    local rows = 0;
    local texture, itemCount, locked, quality, readable;

    for i = 1, numSlots do
        itemButton = getglobal(containerName.."Item"..i);
        if ( not itemButton ) then
            itemButton = CreateFrame("CheckButton", containerName.."Item"..i, containerFrame, "ArmoryInventoryFrameItemButtonTemplate");
        end
        itemTexture = getglobal(containerName.."Item"..i.."IconTexture");
        if ( not isCollapsed ) then
            itemButton:SetID(i);
            -- Set first button
            if ( i == 1 ) then
                itemButton:SetPoint("TOPLEFT", containerName.."Label", "BOTTOMLEFT", ARMORY_CONTAINER_OFFSET_X, 0);
                rows = 1;
            else
                if ( mod((i - 1), ARMORY_MAX_CONTAINER_COLUMNS) == 0 ) then
                    itemButton:SetPoint("TOPLEFT", containerName.."Item"..(i - ARMORY_MAX_CONTAINER_COLUMNS), "BOTTOMLEFT", 0, 0);
                    rows = rows + 1;
                else
                    itemButton:SetPoint("TOPLEFT", containerName.."Item"..(i - 1), "TOPRIGHT", 0, 0);    
                end
            end

            texture, itemCount, locked, quality, readable = Armory:GetContainerItemInfo(id, i);

            if ( texture ) then
                SetItemButtonTexture(itemButton, texture);
                itemTexture:SetTexCoord(0, 1, 0, 1);
                itemButton.hasItem = 1;
            else
                SetItemButtonTexture(itemButton, "Interface\\Buttons\\UI-EmptySlot-Disabled");
                SetItemButtonCount(itemButton, nil);
                itemTexture:SetTexCoord(0.203125, 0.796875, 0.1875, 0.78125);
                itemButton.hasItem = nil;
            end
            SetItemButtonCount(itemButton, itemCount);
            Armory:SetItemLink(itemButton, Armory:GetContainerItemLink(id, i));

            itemButton:Show();
        else
            itemButton:Hide();
        end
    end
    for i = numSlots + 1, ARMORY_MAX_CONTAINER_ITEMS do
        itemButton = getglobal(containerName.."Item"..i);
        if ( itemButton ) then
            itemButton:Hide();
        end
    end
    containerFrame:SetHeight((rows * ARMORY_CONTAINER_ROW_HEIGHT) + label:GetHeight() - ARMORY_CONTAINER_OFFSET_Y);
    containerFrame:Show();
    ArmoryInventoryIconViewFrame_SetScroll();
end

function ArmoryInventoryIconViewFrame_CheckContainerSize(label, size)
	if ( size > ARMORY_MAX_CONTAINER_ITEMS ) then
		numSlots = ARMORY_MAX_CONTAINER_ITEMS;
		label = format("%s (%d+)", label, numSlots);
	end 
	return label, numSlots;
end

function ArmoryInventoryIconViewFrame_Update()
    local containerFrame, previousContainer, size, isCollapsed;

    ArmoryInventoryCollapseAllButton.isCollapsed = 1;
    ArmoryInventoryCollapseAllButton:SetNormalTexture("Interface\\Buttons\\UI-PlusButton-Up");

    for i = 1, #ArmoryContainers do
        containerFrame = getglobal("ArmoryInventoryContainer"..i);
        _, size, isCollapsed = Armory:GetInventoryContainerInfo(ArmoryContainers[i]);

        if ( size and size > 0 ) then
            if ( not isCollapsed and ArmoryInventoryCollapseAllButton.isCollapsed ) then
                ArmoryInventoryCollapseAllButton.isCollapsed = nil;
                ArmoryInventoryCollapseAllButton:SetNormalTexture("Interface\\Buttons\\UI-MinusButton-Up");
            end

            ArmoryInventoryIconViewFrame_ShowContainer(containerFrame);
            if ( previousContainer ) then
                containerFrame:SetPoint("TOPLEFT", previousContainer, "BOTTOMLEFT", 0, 0);
            end
            previousContainer = containerFrame:GetName();
        else
            containerFrame:Hide();
        end
    end
end

function ArmoryInventoryIconViewFrame_SetScroll()
    local frameHeight = ArmoryInventoryIconViewFrame:GetHeight();
    local containerFrame;

    for i = 1, #ArmoryContainers do
        containerFrame = getglobal("ArmoryInventoryContainer"..i);
        if ( containerFrame:IsShown() ) then
            frameHeight = frameHeight - containerFrame:GetHeight();
        end
    end

    -- Show or hide the scrollbar
    if ( frameHeight > 0 ) then
        ArmoryInventoryIconViewFrameScrollBar:Hide();
        ArmoryInventoryIconViewFrameScrollBarTop:Hide();
        ArmoryInventoryIconViewFrameScrollBarBottom:Hide();
    else
        ArmoryInventoryIconViewFrameScrollBar:Show();
        ArmoryInventoryIconViewFrameScrollBarTop:Show();
        ArmoryInventoryIconViewFrameScrollBarBottom:Show();
    end
end
