--[[
    Armory Addon for World of Warcraft(tm).
    Revision: $Id: ArmoryInventoryFrame.lua,v 1.16, 2008-07-25 19:47:42Z, Maxim Baars$
    URL: http://www.wow-neighbours.com

    License:
        This program is free software; you can redistribute it and/or
        modify it under the terms of the GNU General Public License
        as published by the Free Software Foundation; either version 2
        of the License, or (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program(see GPL.txt); if not, write to the Free Software
        Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

    Note:
        This AddOn's source code is specifically designed to work with
        World of Warcraft's interpreted AddOn system.
        You have an implicit licence to use this AddOn with these facilities
        since that is it's designated purpose as per:
        http://www.fsf.org/licensing/licenses/gpl-faq.html#InterpreterIncompat
--]] 

ARMORY_MAIL_CONTAINER = -3;
ARMORY_AUCTIONS_CONTAINER = -4;

function ArmoryInventoryFrame_Toggle()
    if ( ArmoryInventoryFrame:IsShown() ) then
        HideUIPanel(ArmoryInventoryFrame);
    else
        ArmoryCloseChildWindows();
        ShowUIPanel(ArmoryInventoryFrame);
    end
end

function ArmoryInventoryFrame_OnLoad()
    this:RegisterEvent("PLAYER_ENTERING_WORLD");
    this:RegisterEvent("BAG_UPDATE");
    this:RegisterEvent("BANKFRAME_OPENED");
    this:RegisterEvent("BANKFRAME_CLOSED");
    this:RegisterEvent("PLAYERBANKSLOTS_CHANGED");
    this:RegisterEvent("MAIL_CLOSED");
    this:RegisterEvent("AUCTION_OWNED_LIST_UPDATE");

    SetPortraitToTexture("ArmoryInventoryFramePortrait", "Interface\\Buttons\\Button-Backpack-Up");
    
    -- Tab Handling code
    PanelTemplates_SetNumTabs(this, 2);
    PanelTemplates_SetTab(this, 1);
end

function ArmoryInventoryFrame_OnEvent(event)
    if ( not Armory:CanHandleEvents() ) then
        return;
    elseif ( event == "PLAYER_ENTERING_WORLD" ) then
        this:UnregisterEvent("PLAYER_ENTERING_WORLD");
        Armory:Execute(ArmoryInventoryFrame_UpdateContainer, BACKPACK_CONTAINER);
        Armory:Execute(ArmoryInventoryFrame_UpdateContainer, KEYRING_CONTAINER);
        for i = 1, NUM_BAG_SLOTS do
            Armory:Execute(ArmoryInventoryFrame_UpdateContainer, i);
        end
        return;
       elseif ( event == "BAG_UPDATE" and arg1 <= NUM_BAG_SLOTS ) then
        Armory:Execute(ArmoryInventoryFrame_UpdateContainer, arg1);
       elseif ( event == "BAG_UPDATE" and this.bankOpen ) then
        -- Must execute immediately
        ArmoryInventoryFrame_UpdateContainer(arg1);
    elseif ( event == "PLAYERBANKSLOTS_CHANGED" and arg1 <= NUM_BANKGENERIC_SLOTS ) then
        -- Must execute immediately
        ArmoryInventoryFrame_UpdateContainer(BANK_CONTAINER);
    elseif ( event == "BANKFRAME_OPENED" ) then
        this.bankOpen = true;
        -- Must execute immediately
        ArmoryInventoryFrame_UpdateContainer(BANK_CONTAINER);
        for i = NUM_BAG_SLOTS + 1, NUM_BAG_SLOTS + NUM_BANKBAGSLOTS do
            ArmoryInventoryFrame_UpdateContainer(i);
        end
    elseif ( event == "BANKFRAME_CLOSED" ) then
        this.bankOpen = false;
        return;
    elseif ( event == "MAIL_CLOSED" ) then
        Armory:Execute(ArmoryInventoryFrame_UpdateContainer, ARMORY_MAIL_CONTAINER);
    elseif ( event == "AUCTION_OWNED_LIST_UPDATE" ) then
        Armory:Execute(ArmoryInventoryFrame_UpdateContainer, ARMORY_AUCTIONS_CONTAINER);
    end

    if ( ArmoryInventoryFrame:IsShown() ) then
        Armory:Execute(ArmoryInventoryFrame_Update);
    end
end

function ArmoryInventoryFrame_UpdateContainer(id)
    Armory:SetContainer(id);
    Armory.tooltipItemLink = nil;
    Armory.tooltipItemCounts = nil;
end

function ArmoryInventoryFrameButton_OnClick(self)
    local id = self:GetID();
    if ( ArmoryInventoryListViewFrame:IsShown() ) then
        if ( self.isCollapsed ) then
            Armory:ExpandInventoryHeader(id);
        else
            Armory:CollapseInventoryHeader(id);
        end
    else
        if ( self.isCollapsed ) then
            Armory:ExpandContainer(id);
        else
            Armory:CollapseContainer(id);
        end
    end
    ArmoryInventoryFrame_Update();
end

function ArmoryInventoryFrame_OnShow()
    if ( Armory:GetInventoryListViewMode() ) then
        PanelTemplates_SetTab(this, 2);
    else
        PanelTemplates_SetTab(this, 1);
    end
    ArmoryInventoryFrame_Update();
end

function ArmoryInventoryFrame_Update()
    if ( Armory:GetInventoryListViewMode() ) then
        ArmoryInventoryIconViewFrame:Hide();
        if ( ArmoryInventoryListViewFrame:IsShown() ) then
            ArmoryInventoryListViewFrame_Update();
        else
            ArmoryInventoryListViewFrame:Show();
        end
    else
        ArmoryInventoryListViewFrame:Hide();
        if ( ArmoryInventoryIconViewFrame:IsShown() ) then
            ArmoryInventoryIconViewFrame_Update();
        else
            ArmoryInventoryIconViewFrame:Show();
        end
    end    
end

function ArmoryInventoryFrameTab_OnClick()
    PanelTemplates_SetTab(ArmoryInventoryFrame, this:GetID());
    ArmoryInventoryFrameEnableListView(this:GetID() == 2);
end

function ArmoryInventoryFrameEnableListView(checked)
    Armory:SetInventoryListViewMode(checked);
    ArmoryInventoryFrame_Update();
end

function ArmoryInventoryMoneyFrame_OnShow(event)
    MoneyFrame_Update("ArmoryInventoryMoneyFrame", Armory:GetMoney());
end

function ArmoryInventoryMoneyFrame_OnEnter(self)
    local currentRealm, currentCharacter = Armory:GetPaperDollLastViewed();
    local currentFaction = Armory:UnitFactionGroup("player");
    local money = 0;
    for _, character in ipairs(Armory:CharacterList(currentRealm)) do
        Armory:LoadProfile(currentRealm, character);
        if ( Armory:UnitFactionGroup("player") == currentFaction ) then
            money = money + Armory:GetMoney();
        end
    end
    Armory:LoadProfile(currentRealm, currentCharacter);

    GameTooltip:AddLine(format(ARMORY_MONEY_TOTAL, currentRealm, currentFaction), "", 1, 1, 1);
    SetTooltipMoney(GameTooltip, money);
    GameTooltip:Show();
end
