local ArenaUnitFramesOptions_SelectedButton = 1;
local ArenaUnitFramesOptions_SelectedModifier = 1;
local ArenaUnitFramesOptions_Modifiers = {
	[1] = "none",
	[2] = "shift",
	[3] = "ctrl",
	[4] = "alt",
};

function ArenaUnitFramesOptionsFrameButtonsDropDown_Initialize()
	local i, v;

	for i, v in ipairs(ARENA_UNIT_FRAMES_BUTTON_LABELS) do
		UIDropDownMenu_AddButton( {
			text = v,
			value = i,
			func = ArenaUnitFramesOptionsFrameButtonsDropDown_OnClick,
		} );
	end

end

function ArenaUnitFramesOptionsFrameButtonsDropDown_OnClick()

	UIDropDownMenu_SetSelectedID( ArenaUnitFramesButtonConfigButtonsDropDown, this.value );
	ArenaUnitFramesOptions_SelectedButton = UIDropDownMenu_GetSelectedID( ArenaUnitFramesButtonConfigButtonsDropDown );

	ArenaUnitFramesOptions_ShowButton();
end

function ArenaUnitFramesOptionsFrameModifierDropDown_Initialize()
	local i, v;
	for i, v in ipairs(ARENA_UNIT_FRAMES_MODIFIER_LABELS) do
		UIDropDownMenu_AddButton( {
			text = v,
			value = i,
			func = ArenaUnitFramesOptionsFrameModifierDropDown_OnClick,
		} );
	end

end

function ArenaUnitFramesOptionsFrameModifierDropDown_OnClick()

	UIDropDownMenu_SetSelectedID( ArenaUnitFramesButtonConfigModifierDropDown, this.value );
	ArenaUnitFramesOptions_SelectedModifier = UIDropDownMenu_GetSelectedID( ArenaUnitFramesButtonConfigModifierDropDown );

	ArenaUnitFramesOptions_ShowButton();
end

function ArenaUnitFramesOptions_ShowButton()

	local modifier, frame, click, class, classText, macroFontString, i;
	local numMacros = 0;

	for i = 1, 10 do
		getglobal("ArenaUnitFramesOptionsFrameClass"..i.."Class"):SetText("");
		getglobal("ArenaUnitFramesOptionsFrameClass"..i.."Macro"):SetText("");
	end


	modifier = ArenaUnitFramesOptions_Modifiers[ArenaUnitFramesOptions_SelectedModifier];
	if ( not ArenaUnitFrames_Config["buttons"][ArenaUnitFramesOptions_SelectedButton][modifier] ) then
		ArenaUnitFrames_Config["buttons"][ArenaUnitFramesOptions_SelectedButton][modifier] = {};
	end
	click = ArenaUnitFrames_Config["buttons"][ArenaUnitFramesOptions_SelectedButton][modifier];

	i = 2;
	for class, classText in pairs(ARENA_UNIT_FRAMES_CLASSES) do
		if ( class == "default" ) then
			frame = ArenaUnitFramesOptionsFrameClass1;
			ArenaUnitFramesOptionsFrameClass1Class:SetText(classText);
			ArenaUnitFramesOptionsFrameClass1.class = class;
			macroFontString = ArenaUnitFramesOptionsFrameClass1Macro;
		else
			frame = getglobal("ArenaUnitFramesOptionsFrameClass"..i);
			getglobal("ArenaUnitFramesOptionsFrameClass"..i.."Class"):SetText(classText);
			getglobal("ArenaUnitFramesOptionsFrameClass"..i).class = class;
			macroFontString = getglobal("ArenaUnitFramesOptionsFrameClass"..i.."Macro");
			i = i + 1;
		end

		frame:SetHeight(35);
		if ( click[class] ) then
			if ( click[class].action == "default" ) then
				macroFontString:SetText(USE.." "..DEFAULT);
				macroFontString:SetTextColor(0.5, 0.5, 0.5);
			elseif ( click[class].action == "target" ) then
				macroFontString:SetText(TARGET..ARENA_UNIT_FRAMES_UNIT);
				macroFontString:SetTextColor(1.0, 1.0, 1.0);

			elseif ( click[class].action == "focus" ) then
				macroFontString:SetText(FOCUS..ARENA_UNIT_FRAMES_UNIT);
				macroFontString:SetTextColor(1.0, 1.0, 1.0);

			elseif ( click[class].action == "cast" ) then
				macroFontString:SetText(ARENA_UNIT_FRAMES_CAST.." "..click[class].spell);
				macroFontString:SetTextColor(1.0, 1.0, 0.0);

			elseif ( click[class].action == "macro" ) then
				frame:SetHeight(75);
				numMacros = numMacros + 1;
				macroFontString:SetText(click[class].macro);
				macroFontString:SetTextColor(.8, .8, .8);
			end

		elseif ( class ~= "default" ) then
			macroFontString:SetText(USE.." "..DEFAULT);
			macroFontString:SetTextColor(0.5, 0.5, 0.5);
		else
			macroFontString:SetText(NONE);
			macroFontString:SetTextColor(0.5, 0.5, 0.5);
		end
	end

	ArenaUnitFramesButtonConfigScrollBarChildFrame:SetHeight(35 * 11 + numMacros * 40);

	-- hide this until death knights
	if ( i == 11 ) then
		ArenaUnitFramesOptionsFrameClass11:Hide();
	end
end

function ArenaUnitFramesOptions_EditButton(class)
	ArenaUnitFramesOptionsEditFrame.class = class;
	ArenaUnitFramesOptionsEditFrame:Show();
end

function ArenaUnitFramesEditFrame_OnShow()

	local modifier = ArenaUnitFramesOptions_Modifiers[ArenaUnitFramesOptions_SelectedModifier];
	local modifierText = "";

	-- set frame header text
	if ( modifier ~= "none" ) then	
		modifierText = "["..ARENA_UNIT_FRAMES_MODIFIER_LABELS[ArenaUnitFramesOptions_SelectedModifier].."] ";
	end
	ArenaUnitFramesOptionsEditFrameTitle:SetText(
		modifierText..ARENA_UNIT_FRAMES_BUTTON_LABELS[ArenaUnitFramesOptions_SelectedButton]..
		" - "..ARENA_UNIT_FRAMES_CLASSES[this.class]
	);

	local classAction = ArenaUnitFrames_Config["buttons"][ArenaUnitFramesOptions_SelectedButton][modifier][this.class];

	-- new?
	if ( not classAction ) then
		ArenaUnitFrames_Config["buttons"][ArenaUnitFramesOptions_SelectedButton][modifier][this.class] = {};
		classAction = ArenaUnitFrames_Config["buttons"][ArenaUnitFramesOptions_SelectedButton][modifier][this.class];
		classAction.action = "default";
	end

	-- set edit boxes
	if ( classAction.spell ) then
		ArenaUnitFramesOptionsEditFrameSpellEditBox:SetText(classAction.spell);
	else
		ArenaUnitFramesOptionsEditFrameSpellEditBox:SetText("");
	end
	if ( classAction.macro ) then
		ArenaUnitFramesOptionsEditFrameScrollFrameText:SetText(classAction.macro);
	else
		ArenaUnitFramesOptionsEditFrameScrollFrameText:SetText("");
	end

	-- default action's first radio is "none" class specific actions first radio is "default"
	if ( this.class == "default" ) then
		ArenaUnitFramesOptionsEditFrameDefaultRadioText:SetText(NONE);
	else
		ArenaUnitFramesOptionsEditFrameDefaultRadioText:SetText(DEFAULT);
	end

	if ( classAction.action == "default" ) then
		ArenaUnitFramesOptionsEditFrameRadio_OnClick(1);
	elseif ( classAction.action == "target" ) then
		ArenaUnitFramesOptionsEditFrameRadio_OnClick(2);
	elseif ( classAction.action == "focus" ) then
		ArenaUnitFramesOptionsEditFrameRadio_OnClick(3);
	elseif ( classAction.action == "cast" ) then
		ArenaUnitFramesOptionsEditFrameRadio_OnClick(4);
	elseif ( classAction.action == "macro" ) then
		ArenaUnitFramesOptionsEditFrameRadio_OnClick(5);
	end

end

function ArenaUnitFramesEditFrame_OnHide()
	--ArenaUnitFramesOptionsFrame:Show();
	ArenaUnitFramesOptions_ShowButton();
end

function ArenaUnitFramesOptionsEditFrameRadio_OnClick(id)
	ArenaUnitFramesOptionsEditFrameDefaultRadio:SetChecked(0);
	ArenaUnitFramesOptionsEditFrameTargetRadio:SetChecked(0);
	ArenaUnitFramesOptionsEditFrameFocusRadio:SetChecked(0);
	ArenaUnitFramesOptionsEditFrameCastRadio:SetChecked(0);
	ArenaUnitFramesOptionsEditFrameMacroRadio:SetChecked(0);

	local modifier = ArenaUnitFramesOptions_Modifiers[ArenaUnitFramesOptions_SelectedModifier];
	local classAction = ArenaUnitFrames_Config["buttons"][ArenaUnitFramesOptions_SelectedButton][modifier][ArenaUnitFramesOptionsEditFrame.class];

	if ( id == 1 ) then
		ArenaUnitFramesOptionsEditFrameDefaultRadio:SetChecked(1);
		classAction.action = "default";

	elseif ( id == 2 ) then
		ArenaUnitFramesOptionsEditFrameTargetRadio:SetChecked(1);
		classAction.action = "target";

	elseif ( id == 3 ) then
		ArenaUnitFramesOptionsEditFrameFocusRadio:SetChecked(1);
		classAction.action = "focus";

	elseif ( id == 4 ) then
		ArenaUnitFramesOptionsEditFrameCastRadio:SetChecked(1);
		classAction.action = "cast";
		if ( not classAction.spell ) then
			classAction.spell = "";
		end

	elseif ( id == 5 ) then
		ArenaUnitFramesOptionsEditFrameMacroRadio:SetChecked(1);
		classAction.action = "macro";
		if ( not classAction.macro ) then
			classAction.macro = "";
		end
	end
end

function ArenaUnitFramesOptionsEditFrameDoneButton_OnClick()
	local modifier = ArenaUnitFramesOptions_Modifiers[ArenaUnitFramesOptions_SelectedModifier];
	local class = ArenaUnitFramesOptionsEditFrame.class;
	local classAction = ArenaUnitFrames_Config["buttons"][ArenaUnitFramesOptions_SelectedButton][modifier][class];

	classAction.spell = ArenaUnitFramesOptionsEditFrameSpellEditBox:GetText();
	classAction.macro = ArenaUnitFramesOptionsEditFrameScrollFrameText:GetText();

	-- delete empty tables
	if (	classAction.action == "default" and
		(not classAction.spell or classAction.spell == "" ) and
		(not classAction.macro or classAction.macro == "" )
	) then
		ArenaUnitFrames_Config["buttons"][ArenaUnitFramesOptions_SelectedButton][modifier][class] = nil;
	end
	local n = 0;
	for _ in pairs(ArenaUnitFrames_Config["buttons"][ArenaUnitFramesOptions_SelectedButton][modifier]) do
		n = n + 1;
	end
	if ( n == 0 ) then
		ArenaUnitFrames_Config["buttons"][ArenaUnitFramesOptions_SelectedButton][modifier] = nil;
	end

	HideUIPanel(this:GetParent());
end

function ArenaUnitFramesInterfaceOptionsPanel_OnLoad(panel)
	panel.name = ARENA_UNIT_FRAMES;
	InterfaceOptions_AddCategory(panel);
end

function ArenaUnitFramesInterfaceAlertsPanel_OnLoad(panel)
	panel.name = ARENA_UNIT_FRAMES_ALERTS;
	panel.parent = ARENA_UNIT_FRAMES;
	InterfaceOptions_AddCategory(panel);
end

function ArenaUnitFramesInterfaceButtonsPanel_OnLoad(panel)
	panel.name = ARENA_UNIT_FRAMES_BUTTONS;
	panel.parent = ARENA_UNIT_FRAMES;
	InterfaceOptions_AddCategory(panel);
end

function ArenaUnitFramesInterfaceBuffsPanel_OnLoad(panel)
	panel.name = ARENA_UNIT_FRAMES_BUFF_DISPLAY;
	panel.parent = ARENA_UNIT_FRAMES;
	InterfaceOptions_AddCategory(panel);
end

function ArenaUnitFramesInterfaceButtonsPanel_OnShow()
	UIDropDownMenu_Initialize( ArenaUnitFramesButtonConfigButtonsDropDown, ArenaUnitFramesOptionsFrameButtonsDropDown_Initialize );
	UIDropDownMenu_SetWidth( 110, ArenaUnitFramesButtonConfigButtonsDropDown );
	UIDropDownMenu_SetSelectedID( ArenaUnitFramesButtonConfigButtonsDropDown, ArenaUnitFramesOptions_SelectedButton );

	UIDropDownMenu_Initialize( ArenaUnitFramesButtonConfigModifierDropDown, ArenaUnitFramesOptionsFrameModifierDropDown_Initialize );
	UIDropDownMenu_SetWidth( 60, ArenaUnitFramesButtonConfigModifierDropDown );
	UIDropDownMenu_SetSelectedID( ArenaUnitFramesButtonConfigModifierDropDown, ArenaUnitFramesOptions_SelectedModifier );

	ArenaUnitFramesOptions_ShowButton();
end

function ArenaUnitFramesOptionsBuffsListsRadio_OnClick(id)
	ArenaUnitFrames_Config["lists"]["buffs"]["which"] = id;
	if ( id == 1 ) then
		ArenaUnitFramesOptionsBuffsBlackListRadio:SetChecked(1);
		ArenaUnitFramesOptionsBuffsWhiteListRadio:SetChecked(0);
	else
		ArenaUnitFramesOptionsBuffsBlackListRadio:SetChecked(0);
		ArenaUnitFramesOptionsBuffsWhiteListRadio:SetChecked(1);
	end
end

function ArenaUnitFramesOptionsDebuffsListsRadio_OnClick(id)
	ArenaUnitFrames_Config["lists"]["debuffs"]["which"] = id;
	if ( id == 1 ) then
		ArenaUnitFramesOptionsDebuffsBlackListRadio:SetChecked(1);
		ArenaUnitFramesOptionsDebuffsWhiteListRadio:SetChecked(0);
	else
		ArenaUnitFramesOptionsDebuffsBlackListRadio:SetChecked(0);
		ArenaUnitFramesOptionsDebuffsWhiteListRadio:SetChecked(1);
	end
end

function ArenaUnitFramesInterfaceBuffsPanel_OnShow()

	ArenaUnitFramesOptionsBuffsWhiteListRadio:SetChecked(0);
	ArenaUnitFramesOptionsBuffsBlackListRadio:SetChecked(0);

	ArenaUnitFramesOptionsDebuffsWhiteListRadio:SetChecked(0);
	ArenaUnitFramesOptionsDebuffsBlackListRadio:SetChecked(0);

	if ( ArenaUnitFrames_Config["lists"]["buffs"]["which"] == 1 ) then
		ArenaUnitFramesOptionsBuffsBlackListRadio:SetChecked(1);
	else
		ArenaUnitFramesOptionsBuffsWhiteListRadio:SetChecked(1);
	end

	if ( ArenaUnitFrames_Config["lists"]["debuffs"]["which"] == 1 ) then
		ArenaUnitFramesOptionsDebuffsBlackListRadio:SetChecked(1);
	else
		ArenaUnitFramesOptionsDebuffsWhiteListRadio:SetChecked(1);
	end
end