local ArenaUnitFrames_Opponents = {};
local ArenaUnitFrames_Pending = false;
local ArenaUnitFrames_LastMsg = "";
local ArenaUnitMasterFrame_UpdateTime = 0;
local ArenaUnitFrames_Debug = false;
local ArenaUnitFrames_TeamSize = 0;
local ArenaUnitFrames_Found = 0;
local ArenaUnitFrames_Spec = {};
local ArenaUnitFrames_StopChecking = false;
local ArenaUnitFrames_Party = {};
local ArenaUnitFrames_Tracked = {};
local ArenaUnitFrames_BuffFilter = {};
local ArenaUnitFrames_DebuffFilter = {};
local ArenaUnitFrames_Targets = {
	[1] = {
		"mouseover",
		"target",
		"focus",
	},
	[2] = {
		"mouseover",
		"target",
		"focus",
		"pet",
		"party1",
		"party2",
		"party3",
		"party4",
		"partypet1",
		"partypet2",
		"partypet3",
		"partypet4",
	},
};

ArenaUnitFrames_Config = {};
ArenaUnitFrames_Defaults = {
	["options"] = {
		["lock"] = false,
		["autofocus"] = false,
		["buffscan"] = true,
		["scale"] = .5,
	},
	["lists"] = {
		["buffs"] = {
			["which"] = 1,
			["white"] = "",
			["black"] = "",
		},
		["debuffs"] = {
			["which"] = 1,
			["white"] = "",
			["black"] = "",
		},
	},
	["alerts"] = {
		["lowHealth"] = false,
		["lowHealthPct"] = 40,
		["opponentDeaths"] = false,
		["schoolLocks"] = false,
		["invulns"] = false,
		["soundfx"] = false,
		["friendlySilences"] = false,
		["hostileSilences"] = false,
	},
	["buttons"] = {
		[1] = {
			["none"] = {
				["default"] = {
					action = "target",
				},
			},
		},
		[2] = {
			["none"] = {
				["default"] = {
					action = "focus",
				},
			},
		},
		[3] = {
		},
		[4] = {
		},
		[5] = {
		},
	},
};

BINDING_HEADER_AUF = ARENA_UNIT_FRAMES;

setglobal("BINDING_NAME_CLICK ArenaUnitFrame1Button:LeftButton", ARENA_UNIT_FRAMES_BUTTON_LABELS[1]..ARENA_UNIT_FRAMES_UNIT.." 1");
setglobal("BINDING_NAME_CLICK ArenaUnitFrame2Button:LeftButton", ARENA_UNIT_FRAMES_BUTTON_LABELS[1]..ARENA_UNIT_FRAMES_UNIT.." 2");
setglobal("BINDING_NAME_CLICK ArenaUnitFrame3Button:LeftButton", ARENA_UNIT_FRAMES_BUTTON_LABELS[1]..ARENA_UNIT_FRAMES_UNIT.." 3");
setglobal("BINDING_NAME_CLICK ArenaUnitFrame4Button:LeftButton", ARENA_UNIT_FRAMES_BUTTON_LABELS[1]..ARENA_UNIT_FRAMES_UNIT.." 4");
setglobal("BINDING_NAME_CLICK ArenaUnitFrame5Button:LeftButton", ARENA_UNIT_FRAMES_BUTTON_LABELS[1]..ARENA_UNIT_FRAMES_UNIT.." 5");

setglobal("BINDING_NAME_CLICK ArenaUnitFrame1Button:RightButton", ARENA_UNIT_FRAMES_BUTTON_LABELS[2]..ARENA_UNIT_FRAMES_UNIT.." 1");
setglobal("BINDING_NAME_CLICK ArenaUnitFrame2Button:RightButton", ARENA_UNIT_FRAMES_BUTTON_LABELS[2]..ARENA_UNIT_FRAMES_UNIT.." 2");
setglobal("BINDING_NAME_CLICK ArenaUnitFrame3Button:RightButton", ARENA_UNIT_FRAMES_BUTTON_LABELS[2]..ARENA_UNIT_FRAMES_UNIT.." 3");
setglobal("BINDING_NAME_CLICK ArenaUnitFrame4Button:RightButton", ARENA_UNIT_FRAMES_BUTTON_LABELS[2]..ARENA_UNIT_FRAMES_UNIT.." 4");
setglobal("BINDING_NAME_CLICK ArenaUnitFrame5Button:RightButton", ARENA_UNIT_FRAMES_BUTTON_LABELS[2]..ARENA_UNIT_FRAMES_UNIT.." 5");

setglobal("BINDING_NAME_CLICK ArenaUnitFrame1Button:MiddleButton", ARENA_UNIT_FRAMES_BUTTON_LABELS[3]..ARENA_UNIT_FRAMES_UNIT.." 1");
setglobal("BINDING_NAME_CLICK ArenaUnitFrame2Button:MiddleButton", ARENA_UNIT_FRAMES_BUTTON_LABELS[3]..ARENA_UNIT_FRAMES_UNIT.." 2");
setglobal("BINDING_NAME_CLICK ArenaUnitFrame3Button:MiddleButton", ARENA_UNIT_FRAMES_BUTTON_LABELS[3]..ARENA_UNIT_FRAMES_UNIT.." 3");
setglobal("BINDING_NAME_CLICK ArenaUnitFrame4Button:MiddleButton", ARENA_UNIT_FRAMES_BUTTON_LABELS[3]..ARENA_UNIT_FRAMES_UNIT.." 4");
setglobal("BINDING_NAME_CLICK ArenaUnitFrame5Button:MiddleButton", ARENA_UNIT_FRAMES_BUTTON_LABELS[3]..ARENA_UNIT_FRAMES_UNIT.." 5");

setglobal("BINDING_NAME_CLICK ArenaUnitFrame1Button:Button4", ARENA_UNIT_FRAMES_BUTTON_LABELS[4]..ARENA_UNIT_FRAMES_UNIT.." 1");
setglobal("BINDING_NAME_CLICK ArenaUnitFrame2Button:Button4", ARENA_UNIT_FRAMES_BUTTON_LABELS[4]..ARENA_UNIT_FRAMES_UNIT.." 2");
setglobal("BINDING_NAME_CLICK ArenaUnitFrame3Button:Button4", ARENA_UNIT_FRAMES_BUTTON_LABELS[4]..ARENA_UNIT_FRAMES_UNIT.." 3");
setglobal("BINDING_NAME_CLICK ArenaUnitFrame4Button:Button4", ARENA_UNIT_FRAMES_BUTTON_LABELS[4]..ARENA_UNIT_FRAMES_UNIT.." 4");
setglobal("BINDING_NAME_CLICK ArenaUnitFrame5Button:Button4", ARENA_UNIT_FRAMES_BUTTON_LABELS[4]..ARENA_UNIT_FRAMES_UNIT.." 5");

setglobal("BINDING_NAME_CLICK ArenaUnitFrame1Button:Button5", ARENA_UNIT_FRAMES_BUTTON_LABELS[5]..ARENA_UNIT_FRAMES_UNIT.." 1");
setglobal("BINDING_NAME_CLICK ArenaUnitFrame2Button:Button5", ARENA_UNIT_FRAMES_BUTTON_LABELS[5]..ARENA_UNIT_FRAMES_UNIT.." 2");
setglobal("BINDING_NAME_CLICK ArenaUnitFrame3Button:Button5", ARENA_UNIT_FRAMES_BUTTON_LABELS[5]..ARENA_UNIT_FRAMES_UNIT.." 3");
setglobal("BINDING_NAME_CLICK ArenaUnitFrame4Button:Button5", ARENA_UNIT_FRAMES_BUTTON_LABELS[5]..ARENA_UNIT_FRAMES_UNIT.." 4");
setglobal("BINDING_NAME_CLICK ArenaUnitFrame5Button:Button5", ARENA_UNIT_FRAMES_BUTTON_LABELS[5]..ARENA_UNIT_FRAMES_UNIT.." 5");

local ArenaUnitFrames_UnitsClassIcon = {
	["WARRIOR"] = { right = 0, left = 0.25, top = 0, bottom = 0.25 },
	["MAGE"] = { right = 0.25, left = 0.5, top = 0, bottom = 0.25 },
	["ROGUE"] = { right = 0.5, left = 0.75, top = 0, bottom = 0.25 },
	["DRUID"] = { right = 0.75, left = 1, top = 0, bottom = 0.25 },
	["HUNTER"] = { right = 0, left = 0.25, top = 0.25, bottom = 0.5 },
	["SHAMAN"] = { right = 0.25, left = 0.5, top = 0.25, bottom = 0.5 },
	["PRIEST"] = { right = 0.5, left = 0.75, top = 0.25, bottom = 0.5 },
	["WARLOCK"] = { right = 0.75, left = 1, top = 0.25, bottom = 0.5 },
	["PALADIN"] = { right = 0, left = 0.25, top = 0.5, bottom = 0.75 },
};
local ArenaUnitFrames_SchoolLock = {
	["WARRIOR"] = 4,
	["MAGE"] = 8,
	["ROGUE"] = 5,
	["DRUID"] = 4,
	["HUNTER"] = 0,
	["SHAMAN"] = 2,
	["PRIEST"] = 0,
	["WARLOCK"] = 6,
	["PALADIN"] = 0,
	["pet"] = 5;
};
local ArenaUnitFrames_ClassColors = {};

local ArenaUnitFrames_Events = {};

local _G = getfenv(0);
local bit_bor = _G.bit.bor;
local bit_band = _G.bit.band;
local strfind = _G.string.find;
local strmatch = _G.strmatch;

local COMBATLOG_OBJECT_REACTION_HOSTILE = COMBATLOG_OBJECT_REACTION_HOSTILE;
local COMBATLOG_OBJECT_REACTION_FRIENDLY = COMBATLOG_OBJECT_REACTION_FRIENDLY;
local COMBATLOG_OBJECT_AFFILIATION_MINE = COMBATLOG_OBJECT_AFFILIATION_MINE;
local AURA_TYPE_DEBUFF = "DEBUFF";
local AURA_TYPE_BUFF = "BUFF";

function ArenaUnitFrames_CombatLog(_, _, _, event, srcGUID, srcName, srcFlags, dstGUID, dstName, dstFlags, ...)

	if ( event == "SPELL_AURA_APPLIED" ) then

		local spell = select(2, ...);
		local type = select(4, ...);

		-- hostile unit get a buff or debuff?
		if ( bit.band(dstFlags, COMBATLOG_OBJECT_REACTION_HOSTILE) > 0 ) then

			if ( strfind(dstName, "-") ) then
				dstName = strmatch(dstName, "^([^-]+)-.*");
			end

			if ( type == AURA_TYPE_DEBUFF ) then

				-- opponent afflicted by a CC ability?
				if ( ArenaUnitFrames_Opponents[dstName] ) then
					if ( ARENA_UNIT_FRAMES_EFFECT[spell] ) then
						ArenaUnitFrames_Opponents[dstName].cc[spell] = {
							icon = ARENA_UNIT_FRAMES_EFFECT[spell].icon,
							expire = GetTime() + ARENA_UNIT_FRAMES_EFFECT[spell].duration
						};
					end
					ArenaUnitFramesUpdateFramePortrait(dstName);
				end

				-- hostile silences alert
				if ( ArenaUnitFrames_Config["alerts"]["hostileSilences"] ) then

					if ( ArenaUnitFrames_Opponents[dstName] and ARENA_UNIT_FRAMES_SILENCES[spell] ) then

						ArenaUnitFrames_Alert(
							ArenaUnitFrames_ClassColors[ArenaUnitFrames_Opponents[dstName].class]..
							ARENA_UNIT_FRAMES_CLASSES[ArenaUnitFrames_Opponents[dstName].class]..
							"|r ("..dstName..") "..
							ARENA_UNIT_FRAMES_SILENCED_ALERT..ARENA_UNIT_FRAMES_SILENCES[spell]..
							" "..SECONDS_ABBR
						);
						if ( ArenaUnitFrames_Config["alerts"]["soundfx"] ) then
							PlaySoundFile("Interface\\AddOns\\ArenaUnitFrames\\Sounds\\terranerror1.wav");
						end
					end
				end

			elseif ( type == AURA_TYPE_BUFF ) then

				-- invulns alert
				if ( ArenaUnitFrames_Config["alerts"]["invulns"] ) then

					if ( ArenaUnitFrames_Opponents[dstName] ) then

						if ( ARENA_UNIT_FRAMES_INVULNS[spell] ) then

							ArenaUnitFrames_Alert(
								string.format(
									ARENA_UNIT_FRAMES_INVULN_WARNING,
									ArenaUnitFrames_ClassColors[ArenaUnitFrames_Opponents[dstName].class]..
									ARENA_UNIT_FRAMES_CLASSES[ArenaUnitFrames_Opponents[dstName].class].."|r",
									dstName,
									spell
								),
								1
							);

							if ( ArenaUnitFrames_Config["alerts"]["soundfx"] ) then
								PlaySoundFile("Interface\\AddOns\\ArenaUnitFrames\\Sounds\\shield.wav");
							end
						end
					end
				end

			end


		-- friendly unit get a buff or debuff?
		elseif ( bit.band(dstFlags, COMBATLOG_OBJECT_REACTION_FRIENDLY) > 0 and bit.band(dstFlags, COMBATLOG_OBJECT_AFFILIATION_MINE) == 0 ) then

			if ( type == AURA_TYPE_DEBUFF ) then

				-- friendly silences alert
				if ( ArenaUnitFrames_Config["alerts"]["friendlySilences"] ) then

					if ( ArenaUnitFrames_Party[dstName] and ARENA_UNIT_FRAMES_SILENCES[spell] ) then
						ArenaUnitFrames_Alert(
							string.format(
								ARENA_UNIT_FRAMES_SILENCED_WARNING,
								ArenaUnitFrames_ClassColors[ArenaUnitFrames_Party[dstName]]..dstName.."|r ",
								ARENA_UNIT_FRAMES_SILENCES[spell]
							),
							1
						);
						if ( ArenaUnitFrames_Config["alerts"]["soundfx"] ) then
							PlaySoundFile("Interface\\AddOns\\ArenaUnitFrames\\Sounds\\terranunderattack.wav");
						end
					end
				end
			end
		end


	elseif ( event == "SPELL_AURA_REMOVED" or event == "SPELL_AURA_DISPELLED" ) then

		-- hostile unit?
		if ( bit.band(dstFlags, COMBATLOG_OBJECT_REACTION_HOSTILE) > 0 ) then

			local spell = select(2, ...);
			local type = select(4, ...);

			if ( type == AURA_TYPE_DEBUFF ) then

				if ( strfind(dstName, "-") ) then
					dstName = strmatch(dstName, "^([^-]+)-.*");
				end

				-- opponent's CC removed?
				if ( ArenaUnitFrames_Opponents[dstName] ) then
					if ( ARENA_UNIT_FRAMES_EFFECT[spell] ) then
						ArenaUnitFrames_Opponents[dstName].cc[spell] = nil;
					end
					ArenaUnitFramesUpdateFramePortrait(dstName);
				end
			end
		end


	elseif ( event == "SPELL_CAST_START" ) then

		-- opponent begins to cast?
		if ( bit.band(srcFlags, COMBATLOG_OBJECT_REACTION_HOSTILE) > 0 ) then

			local spell = select(2, ...);

			if ( strfind(srcName, "-") ) then
				srcName = strmatch(srcName, "^([^-]+)-.*");
			end

			if ( ArenaUnitFrames_Opponents[srcName] ) then

				if ( ArenaUnitFrames_Opponents[srcName].path ) then
					-- opponent has a unit id available, use spell bar
					ArenaUnitFramesUpdateSpellBar(srcName, ArenaUnitFrames_Opponents[srcName].path);

				elseif ( ArenaUnitFrames_Opponents[srcName].id ) then
					-- no unitid to opponent, so just flash spell name for 1 second
					getglobal("ArenaUnitFrame"..ArenaUnitFrames_Opponents[srcName].id.."Spell"):SetText(spell);
					getglobal("ArenaUnitFrame"..ArenaUnitFrames_Opponents[srcName].id).spellTime = GetTime() + 1;
				end

				-- if opponent is somehow casting a spell when he/she should be school locked, end countdown
				if ( ArenaUnitFrames_Opponents[srcName].countdown ) then
					ArenaUnitFrames_Opponents[srcName].countdown = nil;
				end
			end
		end


	elseif ( event == "SPELL_INTERRUPT" ) then

		local spell = select(2, ...);
		local duration;

		if ( ARENA_UNIT_FRAMES_INTERRUPTS[spell] ) then
			duration = ARENA_UNIT_FRAMES_INTERRUPTS[spell];
		end

		-- hostile unit interrupted
		if ( bit.band(dstFlags, COMBATLOG_OBJECT_REACTION_HOSTILE) > 0 ) then

			if ( strfind(dstName, "-") ) then
				dstName = strmatch(dstName, "^([^-]+)-.*");
			end

			if ( ArenaUnitFrames_Opponents[dstName] and ArenaUnitFrames_Party[srcName] ) then

				if ( not duration ) then
					duration = ArenaUnitFrames_SchoolLock[ArenaUnitFrames_Party[srcName]];
				end

				if ( ArenaUnitFrames_Opponents[dstName].class == "PALADIN" ) then
					duration = duration *.7;
				end
				ArenaUnitFrames_Opponents[dstName].countdown = duration + GetTime();

				local countdown = getglobal("ArenaUnitFrame"..ArenaUnitFrames_Opponents[dstName].id.."Countdown");
				countdown:SetText(math.ceil(duration));
				countdown:Show();
				CooldownFrame_SetTimer(
					getglobal("ArenaUnitFrame"..ArenaUnitFrames_Opponents[dstName].id.."Cooldown"),
					GetTime(), 
					duration, 1
				);

				-- hostile school lock alert
				if ( ArenaUnitFrames_Config["alerts"]["schoolLocks"] ) then
					ArenaUnitFrames_Alert(
						ArenaUnitFrames_ClassColors[ArenaUnitFrames_Opponents[dstName].class]..
						ARENA_UNIT_FRAMES_CLASSES[ArenaUnitFrames_Opponents[dstName].class]..
						"|r ("..dstName..") "..
						ARENA_UNIT_FRAMES_INTERRUPT_ALERT..srcName..
						" ("..math.ceil(duration).." "..SECONDS_ABBR..")"
					);
					if ( ArenaUnitFrames_Config["alerts"]["soundfx"] ) then
						PlaySoundFile("Interface\\AddOns\\ArenaUnitFrames\\Sounds\\terranerror1.wav");
					end
				end
			end


		-- friendly interrupted
		elseif ( bit.band(dstFlags, COMBATLOG_OBJECT_REACTION_FRIENDLY) > 0 and bit.band(dstFlags, COMBATLOG_OBJECT_AFFILIATION_MINE) == 0 ) then
			if ( ArenaUnitFrames_Config["alerts"]["friendlySchoolLocks"] ) then

				if ( strfind(srcName, "-") ) then
					srcName = strmatch(srcName, "^([^-]+)-.*");
				end

				if ( ArenaUnitFrames_Party[dstName] and ArenaUnitFrames_Opponents[srcName] ) then

					if ( not duration ) then
						duration = ArenaUnitFrames_SchoolLock[ArenaUnitFrames_Opponents[srcName].class];
					end

					if ( ArenaUnitFrames_Party[dstName] == "PALADIN" ) then
						duration = duration * .7;
					end
					duration = math.ceil(duration);

					ArenaUnitFrames_Alert(
						string.format(
							ARENA_UNIT_FRAMES_LOCKED_WARNING,
							ArenaUnitFrames_ClassColors[ArenaUnitFrames_Party[dstName]]..dstName.."|r ",
							duration
						),
						1
					);
					if ( ArenaUnitFrames_Config["alerts"]["soundfx"] ) then
						PlaySoundFile("Interface\\AddOns\\ArenaUnitFrames\\Sounds\\terranunderattack.wav");
					end
				end
			end

		end


	elseif ( event == "PARTY_KILL" ) then

		if ( strfind(dstName, "-") ) then
			dstName = strmatch(dstName, "^([^-]+)-.*");
		end

--		if ( ArenaUnitFrames_Opponents[dstName] and ArenaUnitFrames_Opponents[dstName].class ~= "HUNTER" ) then
		if ( ArenaUnitFrames_Opponents[dstName] ) then
			ArenaUnitFrames_HostileDeath(dstName);
		end
	end
end

function ArenaUnitFrames_Events:UNIT_HEALTH(arg1)
	if ( arg1 == "target" or arg1 == "mouseover" or arg1 == "focus" ) then
		ArenaUnitFramesUpdateFrameBars(UnitName(arg1), arg1);
	end
end

function ArenaUnitFrames_Events:UNIT_MANA(arg1)
	if ( arg1 == "target" or arg1 == "focus" ) then
		ArenaUnitFramesUpdateFrameBars(UnitName(arg1), arg1);
	end
end
ArenaUnitFrames_Events.UNIT_RAGE = ArenaUnitFrames_Events.UNIT_MANA;
ArenaUnitFrames_Events.UNIT_ENERGY = ArenaUnitFrames_Events.UNIT_MANA;

function ArenaUnitFrames_Events:UNIT_AURA(arg1)
	if ( (arg1 == "target" or arg1 == "focus" ) and ArenaUnitFrames_Opponents[UnitName(arg1)] ) then
		ArenaUnitFramesUpdateDebuffs(UnitName(arg1), arg1);
	end
end
ArenaUnitFrames_Events.UNIT_AURASTATE = ArenaUnitFrames_Events.UNIT_AURA;

function ArenaUnitFrames_Events:UPDATE_MOUSEOVER_UNIT()
--	ArenaUnitFramesIsHostile("mouseover");
	ArenaUnitFrames_Events:UNIT_TARGET();
	ArenaUnitFramesUpdateUnit("mouseover");
end

function ArenaUnitFrames_Events:UNIT_TARGET()
	local i, unit, path, depth, pathName;

	-- unit == "target", "focus"
	for _, unit in ipairs(ArenaUnitFrames_Targets[1]) do
		pathName = UnitName(unit);

		-- if unit is opponent
		if ( ArenaUnitFrames_Opponents[pathName] ) then
			ArenaUnitFrames_Opponents[pathName].path = unit;
			ArenaUnitFrames_Opponents[pathName].depth = 1;
			ArenaUnitFramesUpdateToT(pathName);
			getglobal("ArenaUnitFrame"..ArenaUnitFrames_Opponents[pathName].id):SetAlpha(1);
--debugmsg(pathName..": "..GetTime());
		elseif ( pathName ) then
			ArenaUnitFramesIsHostile(unit, pathName);
		end
	end

	for depth = 2, 3 do
		-- unit == "party1", "party2", "partypet1", "target" etc
		for _, unit in ipairs(ArenaUnitFrames_Targets[2]) do
			path = unit..string.rep("target", depth - 1);		-- append "target" depth - 1 times to unit
			pathName = UnitName(path);
			if ( ArenaUnitFrames_Opponents[pathName] and ( not ArenaUnitFrames_Opponents[pathName].path or ArenaUnitFrames_Opponents[pathName].depth >= depth ) ) then
--debugmsg(pathName..": "..GetTime());
				ArenaUnitFrames_Opponents[pathName].path = path;
				ArenaUnitFrames_Opponents[pathName].depth = depth;
				ArenaUnitFramesUpdateToT(pathName);
				getglobal("ArenaUnitFrame"..ArenaUnitFrames_Opponents[pathName].id):SetAlpha(1);

			elseif ( pathName and not ArenaUnitFrames_Opponents[pathName] and not ArenaUnitFrame5.name ) then
				ArenaUnitFramesIsHostile(path, pathName);
			end
		end
	end

	ArenaUnitFramesSetAssistButtons();
end

function ArenaUnitFrames_Events:CHAT_MSG_ADDON(arg1, arg2)
	if ( arg1 ~= "ArenaUnitFrames" ) then
		return
	end

	local vars = {};
	local v;
	for v in string.gmatch(arg2, "([^,]+)") do
		table.insert(vars, v);
	end

	-- new opponent
	if ( vars[1] == "0" and not ArenaUnitFrames_Opponents[vars[2]] ) then

		if ( ArenaUnitFrame5.name ) then
			-- we have 5 targets already
			return
		end

		ArenaUnitFrames_Opponents[vars[2]] = {
			hp = tonumber(vars[4]),
			mana = tonumber(vars[5]),
			class = vars[3],
			cc = {},
		};

		-- find next available unit frame and set values
		ArenaUnitFramesNewOpponent(vars[2]);

	-- update opponent
	elseif ( vars[1] == "1" ) then

		-- update only if unit exists and we don't have a path to it
		if ( ArenaUnitFrames_Opponents[vars[2]] and not ArenaUnitFrames_Opponents[vars[2]].path ) then
			ArenaUnitFrames_Opponents[vars[2]].hp = tonumber(vars[3]);
			ArenaUnitFrames_Opponents[vars[2]].mana = tonumber(vars[4]);
			ArenaUnitFramesUpdateFrameBars(vars[2]);
		end
	end
end

function ArenaUnitFrames_Events:PLAYER_TARGET_CHANGED()
--debugmsg("PLAYER TARGET CHANGED: "..GetTime());
	-- force an update to remove old target
--	ArenaUnitMasterFrame_OnUpdate(1)

--	ArenaUnitFramesIsHostile("target");
	ArenaUnitFrames_Events:UNIT_TARGET();
	ArenaUnitFramesUpdateUnit("target");

	ArenaUnitFramesSetHighlight();
end

function ArenaUnitFrames_Events:PLAYER_FOCUS_CHANGED()
	ArenaUnitFrames_Events:UNIT_TARGET();
	ArenaUnitFramesUpdateUnit("focus");

	ArenaUnitFramesSetHighlight();
end

function ArenaUnitFrames_HostileDeath(name)
	ArenaUnitFrames_Opponents[name].hp = 0;
	ArenaUnitFramesUpdateFrameBars(name);

	if ( ArenaUnitFrames_Config["alerts"]["opponentDeaths"] ) then
		ArenaUnitFrames_Alert(
			ArenaUnitFrames_ClassColors[ArenaUnitFrames_Opponents[name].class]..
			ARENA_UNIT_FRAMES_CLASSES[ArenaUnitFrames_Opponents[name].class]..
			"|r ("..name..") "..SPELL_TARGET_TYPE_DEAD1_DESC
		);

		if ( ArenaUnitFrames_Config["alerts"]["soundfx"] ) then
			PlaySoundFile("Interface\\AddOns\\ArenaUnitFrames\\Sounds\\outstanding.wav");
		end
	end
end

function ArenaUnitFrames_Events:PLAYER_REGEN_ENABLED()
	if ( ArenaUnitFrames_Pending ) then
		ArenaUnitFramesSetMacros();
	end
end

-- code here needs to be run after everybody joins but before combat
-- "The Arena battle has begun!" == system neutral
function ArenaUnitFrames_Events:CHAT_MSG_BG_SYSTEM_NEUTRAL()

	-- put group member names and classes in a table for speed
	local i, name;
	for i = 1, 4 do
		name = UnitName("party"..i);
		if ( name ) then
			_, ArenaUnitFrames_Party[name] = UnitClass("party"..i);
		end

		name = UnitName("partypet"..i);
		if ( name ) then
			_, ArenaUnitFrames_Party[name] = "pet";
		end
	end
	_, ArenaUnitFrames_Party[UnitName("player")] = UnitClass("player");
	name = UnitName("pet");
	if ( name ) then
		_, ArenaUnitFrames_Party[name] = "pet";
	end

	if ( not InCombatLockdown() ) then

		-- set assist button icons
		local i, j, color, class, coords;
		for i = 1, 5 do
			for j = 1, 4 do
				_, class = UnitClass("party"..j);
				if ( class ) then
					coords = ArenaUnitFrames_UnitsClassIcon[class];
					getglobal("ArenaUnitFrame"..i.."AssistButton"..j.."Icon"):SetTexCoord(coords.right, coords.left, coords.top, coords.bottom);
				end
				getglobal("ArenaUnitFrame"..i.."AssistButton"..j):SetAlpha(0);
			end
		end

		-- show tracking mouseover onupdate frame.  putting this here because it seems to bug out after player entering world
		_, class = UnitClass("player");
		if ( class == "HUNTER" or class == "DRUID" ) then
			ArenaUnitFramesTrackingFrame:Show();
		end

		-- if one of player's party members gets mistaken for an opponent, reset opponents
		for name in pairs(ArenaUnitFrames_Opponents) do
			if ( ArenaUnitFrames_Party[name] ) then
				ArenaUnitFramesReset();
			end
			if ( ArenaUnitFrames_Tracked[name] ) then
				ArenaUnitFrames_Tracked[name] = nil;
				ArenaUnitFrames_SetTrackingPortraits();
			end
		end
	end
end

function ArenaUnitFrames_Events:PLAYER_ENTERING_WORLD()
	local i;
	local instance, instanceType = IsInInstance();
	if ( instance and instanceType == "arena" ) then

		-- we're in the arena

		-- get team size
		local i, x, status, id, size;
		for i=1, MAX_BATTLEFIELD_QUEUES do
			status, _, id, _, _, x = GetBattlefieldStatus(i);
			if ( id ~= 0 or status == "active" ) then
				size = x;
			end
		end
		if ( not size ) then
			size = 5;
		end

		if ( size < 5 ) then
			for i = (size + 1), 5 do
				getglobal("ArenaUnitFrame"..i):Hide();
			end
		end

		-- adjust frame size to team size
		ArenaUnitMasterFrame:SetHeight(24 + 92 * size);

		ArenaUnitFrames_TeamSize = size;

		ArenaUnitFrames_Party = {};

		ArenaUnitFramesRegister(true);

	else
		ArenaUnitFrames_TeamSize = 5;
		ArenaUnitMasterFrame:SetHeight(484);
		for i = 1, 5 do
			getglobal("ArenaUnitFrame"..i):Show();
		end

		if ( ArenaUnitFrames_Debug ) then
			ArenaUnitFramesRegister(true);
			ArenaUnitFrames_Events:CHAT_MSG_BG_SYSTEM_NEUTRAL();
		else
			ArenaUnitFramesRegister(false);
		end
	end
end

function ArenaUnitFrames_Events:VARIABLES_LOADED()

	local function RecursiveCopy(s, d)
		local k, v;
		for k, v in pairs(s) do
			if ( type(v) == "table" ) then
				if ( not d[k] ) then
					d[k] = {};
				end
				RecursiveCopy(v, d[k]);
			elseif ( type(d[k]) == "nil" ) then
				d[k] = v;
			end
		end
	end
	RecursiveCopy(ArenaUnitFrames_Defaults, ArenaUnitFrames_Config);

	ArenaUnitMasterFrame:SetScale(ArenaUnitFrames_Config["options"]["scale"]);
	ArenaUnitFrames_SetBuffFilter();
end

function ArenaUnitMasterFrame_OnLoad()
	this:RegisterEvent("PLAYER_ENTERING_WORLD");
	this:RegisterEvent("VARIABLES_LOADED");

	-- using SetScripts to allow the _Events and _Opponents tables to be local
	this:SetScript("OnEvent", function(this, event, ...)
		ArenaUnitFrames_Events[event](nil, ...);
	end);

	-- UNIT_SPELLCAST_* events get own handler for speed and clarity
	ArenaUnitMasterFrameSpellcastListener:SetScript("OnEvent", function(this, event, ...)
		local name = UnitName(arg1);
		if ( ArenaUnitFrames_Opponents[name] ) then
			ArenaUnitFramesUpdateSpellBar(name, arg1);
		end
	end);

	-- combat log event gets own frame to make it as efficient as possible
	ArenaUnitMasterFrameLogListener:SetScript("OnEvent", ArenaUnitFrames_CombatLog);

	-- set class colors
	local class, v, r, g, b;
	for class, v in pairs(RAID_CLASS_COLORS) do

		r = string.format("%x", (v.r * 100) * 2.55);
		if ( #r == 1 ) then
			r = "0"..r;
		end
		g = string.format("%x", (v.g * 100) * 2.55);
		if ( #g == 1 ) then
			g = "0"..g;
		end
		b = string.format("%x", (v.b * 100) * 2.55);
		if ( #b == 1 ) then
			b = "0"..b;
		end

		ArenaUnitFrames_ClassColors[class] = "|cff"..r..g..b;
	end

	local caps = string.upper(ARENA_UNIT_FRAMES_SLASHCMD);
	SlashCmdList[caps] = ArenaUnitFramesCmdLine;
	SLASH_AUF1 = "/"..ARENA_UNIT_FRAMES_SLASHCMD;

	if (DEFAULT_CHAT_FRAME) then
		DEFAULT_CHAT_FRAME:AddMessage(ARENA_UNIT_FRAMES_ONLOAD);
	end

end

function ArenaUnitFramesRegister(toggle)
	if ( toggle ) then
		this:RegisterEvent("UPDATE_MOUSEOVER_UNIT");
		this:RegisterEvent("PLAYER_TARGET_CHANGED");
		this:RegisterEvent("PLAYER_FOCUS_CHANGED");
		this:RegisterEvent("UNIT_HEALTH");
		this:RegisterEvent("UNIT_AURA");
		this:RegisterEvent("UNIT_AURASTATE");
		this:RegisterEvent("UNIT_TARGET");
		this:RegisterEvent("UNIT_MANA");
		this:RegisterEvent("UNIT_RAGE");
		this:RegisterEvent("UNIT_ENERGY");
		this:RegisterEvent("PLAYER_REGEN_ENABLED");
		this:RegisterEvent("CHAT_MSG_ADDON");
		this:RegisterEvent("CHAT_MSG_BG_SYSTEM_NEUTRAL");

		ArenaUnitMasterFrameSpellcastListener:RegisterEvent("UNIT_SPELLCAST_START");
		ArenaUnitMasterFrameSpellcastListener:RegisterEvent("UNIT_SPELLCAST_STOP");
		ArenaUnitMasterFrameSpellcastListener:RegisterEvent("UNIT_SPELLCAST_FAILED");
		ArenaUnitMasterFrameSpellcastListener:RegisterEvent("UNIT_SPELLCAST_INTERRUPTED");
		ArenaUnitMasterFrameSpellcastListener:RegisterEvent("UNIT_SPELLCAST_DELAYED");
		ArenaUnitMasterFrameSpellcastListener:RegisterEvent("UNIT_SPELLCAST_CHANNEL_START");
		ArenaUnitMasterFrameSpellcastListener:RegisterEvent("UNIT_SPELLCAST_CHANNEL_UPDATE");
		ArenaUnitMasterFrameSpellcastListener:RegisterEvent("UNIT_SPELLCAST_CHANNEL_STOP");

		ArenaUnitMasterFrameLogListener:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");

		ArenaUnitMasterFrame:Show();

	else
		this:UnregisterEvent("UPDATE_MOUSEOVER_UNIT");
		this:UnregisterEvent("PLAYER_TARGET_CHANGED");
		this:UnregisterEvent("PLAYER_FOCUS_CHANGED");
		this:UnregisterEvent("UNIT_HEALTH");
		this:UnregisterEvent("UNIT_AURA");
		this:UnregisterEvent("UNIT_AURASTATE");
		this:UnregisterEvent("UNIT_TARGET");
		this:UnregisterEvent("UNIT_MANA");
		this:UnregisterEvent("UNIT_RAGE");
		this:UnregisterEvent("UNIT_ENERGY");
		this:UnregisterEvent("PLAYER_REGEN_ENABLED");
		this:UnregisterEvent("CHAT_MSG_ADDON");
		this:UnregisterEvent("CHAT_MSG_BG_SYSTEM_NEUTRAL");

		ArenaUnitMasterFrameSpellcastListener:UnregisterEvent("UNIT_SPELLCAST_START");
		ArenaUnitMasterFrameSpellcastListener:UnregisterEvent("UNIT_SPELLCAST_STOP");
		ArenaUnitMasterFrameSpellcastListener:UnregisterEvent("UNIT_SPELLCAST_FAILED");
		ArenaUnitMasterFrameSpellcastListener:UnregisterEvent("UNIT_SPELLCAST_INTERRUPTED");
		ArenaUnitMasterFrameSpellcastListener:UnregisterEvent("UNIT_SPELLCAST_DELAYED");
		ArenaUnitMasterFrameSpellcastListener:UnregisterEvent("UNIT_SPELLCAST_CHANNEL_START");
		ArenaUnitMasterFrameSpellcastListener:UnregisterEvent("UNIT_SPELLCAST_CHANNEL_UPDATE");
		ArenaUnitMasterFrameSpellcastListener:UnregisterEvent("UNIT_SPELLCAST_CHANNEL_STOP");

		ArenaUnitMasterFrameLogListener:UnregisterEvent("COMBAT_LOG_EVENT_UNFILTERED");

		ArenaUnitMasterFrame:SetHeight(484);
		ArenaUnitMasterFrame:Hide();
		ArenaUnitFramesReset();
	end
end

-- this must be called after every alpha change
function ArenaUnitFramesSetAssistButtons()
	local name, v, j, target;

	for name, v in pairs(ArenaUnitFrames_Opponents) do
		for j = 1, 4 do

			target = UnitName("party"..j.."target");

			if ( target == name ) then
				getglobal("ArenaUnitFrame"..v.id.."AssistButton"..j):SetAlpha(1);
			else
				getglobal("ArenaUnitFrame"..v.id.."AssistButton"..j):SetAlpha(0);
			end
		end
	end
end

function ArenaUnitFramesReset()
	ArenaUnitFrames_Opponents = {};
	ArenaUnitFrames_Tracked = {};
	ArenaUnitFrames_Found = 0;
	ArenaUnitFrames_StopChecking = false;
	ArenaUnitFrames_Spec = {};

	local i;
	for i = 1, 5 do
		getglobal("ArenaUnitFrame"..i).name = nil;
		getglobal("ArenaUnitFrame"..i):SetAlpha(0);
		getglobal("ArenaUnitFrame"..i.."DeadText"):Hide();
		getglobal("ArenaUnitFrame"..i.."Portrait"):SetVertexColor(1, .5, .5);
		getglobal("ArenaUnitFrame"..i.."Spec"):SetText("");
	end
end

function ArenaUnitFramesCmdLine(arg)
	_, _, arg1, arg2 = string.find(arg, "^%s*(%S+)%s+(.+)$");
	if (not arg1) then
		arg1 = arg;
	end
	arg1 = string.lower(arg1);

	if ( arg1 == "debug" ) then
		if ( not ArenaUnitFrames_Debug ) then
			ArenaUnitFrames_Debug = true;
			DEFAULT_CHAT_FRAME:AddMessage("debug mode on", 0, 1, 1);
		else
			ArenaUnitFrames_Debug = nil;
			DEFAULT_CHAT_FRAME:AddMessage("debug mode off", 0, 1, 1);
		end
	elseif ( arg1 == "reset" ) then
		if ( arg2 == "frame" ) then
			ArenaUnitMasterFrame:ClearAllPoints();
			ArenaUnitMasterFrame:SetPoint("CENTER", UIParent, "CENTER", 0, 0);
		else
			ArenaUnitFramesReset();
		end
	else
		ArenaUnitMasterFrame:Show();
	end
end

function ArenaUnitFramesSetHighlight()
	local targetName = UnitName("target");
	local focusName = UnitName("focus");

	local i;
	for i = 1, 5 do
		if ( ArenaUnitFrames_Opponents[targetName] and ArenaUnitFrames_Opponents[targetName].id == i ) then
			getglobal("ArenaUnitFrame"..i):SetBackdropColor(0.0, 1.0, 1.0, 0.4);
		elseif ( ArenaUnitFrames_Opponents[focusName] and ArenaUnitFrames_Opponents[focusName].id == i ) then
			getglobal("ArenaUnitFrame"..i):SetBackdropColor(1.0, 1.0, 1.0, 0.2);
		else
			getglobal("ArenaUnitFrame"..i):SetBackdropColor(1.0, 1.0, 1.0, 0.0);
		end
	end

end

-- check if the unit should have/has a frame.  Add to or update frame as needed
function ArenaUnitFramesIsHostile(unit, name)
	if ( not name ) then
		name = UnitName(unit);
	end

	-- if unit is not in array yet
	if ( not ArenaUnitFrames_Opponents[name] ) then

		-- if unit exists, and is an enemy, and is a player, and unit is not mind controlled
		if (	UnitExists(unit) and
			UnitIsEnemy("player", unit) and
			( UnitIsPlayer(unit) or ArenaUnitFrames_Debug ) and
			not UnitIsCharmed(unit)
		) then

			-- add unit to frames
			ArenaUnitFramesNewOpponent(name, unit);
			ArenaUnitFramesSetAssistButtons();
		end
	else
		-- else update opponent
		ArenaUnitFramesUpdateUnit(unit, name);
--		if ( unit ~= "mouseover" ) then
			getglobal("ArenaUnitFrame"..ArenaUnitFrames_Opponents[name].id):SetAlpha(1);
			ArenaUnitFrames_Opponents[name].path = unit;
			if ( unit == "target" or unit == "focus" or unit == "mouseover" ) then
				ArenaUnitFrames_Opponents[name].depth = 1;
			else
				ArenaUnitFrames_Opponents[name].depth = 2;
			end
			ArenaUnitFrames_Opponents[name].tot = "";
			ArenaUnitFramesSetAssistButtons();
--		end
	end		
end

function ArenaUnitFramesNewOpponent(name, unit)

	if ( ArenaUnitFrame5.name ) then
		-- we have 5 targets already
		return
	end

	if ( unit ) then
		-- set values in opponent array
		if ( not name ) then
			name = UnitName(unit);
		end
		if ( name == UNKNOWN ) then
			return
		end
		local _, class = UnitClass(unit);
		local hp = UnitHealth(unit);
		if ( not hp ) then
			hp = 100;
		end
		local mana = 0;
		if ( UnitManaMax(unit) > 0 ) then
			mana = 100 / UnitManaMax(unit) * UnitMana(unit);
		end
		ArenaUnitFrames_Opponents[name] = {
			hp = hp,
			mana = mana,
			class = class,
			cc = {},
		};
--		if ( unit ~= "mouseover" ) then
			ArenaUnitFrames_Opponents[name].path = unit;
			if ( unit == "target" or unit == "focus" or unit == "mouseover" ) then
				ArenaUnitFrames_Opponents[name].depth = 1;
			else
				ArenaUnitFrames_Opponents[name].depth = 2;
			end
--		end

		-- send opponent data to party
		ArenaUnitFramesSendOpponent(name);
	end
	
	local i, button;

	for i = 1, 5 do
		button = getglobal("ArenaUnitFrame"..i);
		if ( not button.name ) then

			ArenaUnitFrames_Opponents[name].id = i;
			getglobal("ArenaUnitFrame"..i.."Name"):SetText(name);
			button.name = name;

			getglobal("ArenaUnitFrame"..i.."HealthBar"):Show();
			getglobal("ArenaUnitFrame"..i.."ManaBar"):Show();

			if ( ArenaUnitFrames_Opponents[name].class == "WARRIOR" ) then
				getglobal("ArenaUnitFrame"..i.."ManaBar"):SetStatusBarColor(1, 0, 0);
				getglobal("ArenaUnitFrame"..i.."MPBG"):SetVertexColor(1, 0, 0, 0.2);

			elseif ( ArenaUnitFrames_Opponents[name].class == "ROGUE" ) then
				getglobal("ArenaUnitFrame"..i.."ManaBar"):SetStatusBarColor(1, 1, 0);
				getglobal("ArenaUnitFrame"..i.."MPBG"):SetVertexColor(1, 1, 0, 0.2);

			else
				getglobal("ArenaUnitFrame"..i.."ManaBar"):SetStatusBarColor(0, 0, 1);
				getglobal("ArenaUnitFrame"..i.."MPBG"):SetVertexColor(0, 0, 1, 0.2);
			end

			if ( ArenaUnitFrames_Opponents[name].path ) then
				button:SetAlpha(1);
			else
				button:SetAlpha(.5);
			end

			-- set HP/Mana/Portrait
			ArenaUnitFramesUpdateFrameBars(name);
			ArenaUnitFramesUpdateFramePortrait(name);

			-- set on-click functionality (target opponent)
			ArenaUnitFramesSetMacros();

			-- update assist buttons
			ArenaUnitFramesSetAssistButtons();

			ArenaUnitFrames_Found = ArenaUnitFrames_Found + 1;

			if ( ArenaUnitFrames_Tracked[name] ) then
				ArenaUnitFrames_Tracked[name] = nil;
				ArenaUnitFrames_SetTrackingPortraits();
			end

			break;
		end
	end
end

function ArenaUnitFramesSetMacros()
	if ( InCombatLockdown() ) then
		ArenaUnitFrames_Pending = true;
		return
	else
		ArenaUnitFrames_Pending = false;
	end

	local name, opponent, button, text, i, classAction, mod;
	local mods = { "shift", "ctrl", "alt" };

	for name, opponent in pairs(ArenaUnitFrames_Opponents) do
		if ( not opponent.macro ) then
			button = getglobal("ArenaUnitFrame"..opponent.id.."Button");
			button:SetAttribute("*type*", "macro");

			for i = 1, 5 do
				for modifier in pairs(ArenaUnitFrames_Config["buttons"][i]) do

					text = nil;

					if (	ArenaUnitFrames_Config["buttons"][i][modifier][opponent.class] and
						ArenaUnitFrames_Config["buttons"][i][modifier][opponent.class].action ~= "default"
					) then
						classAction = ArenaUnitFrames_Config["buttons"][i][modifier][opponent.class];

					elseif ( ArenaUnitFrames_Config["buttons"][i][modifier]["default"] and
						 ArenaUnitFrames_Config["buttons"][i][modifier]["default"].action ~= "default"
					) then
						classAction = ArenaUnitFrames_Config["buttons"][i][modifier]["default"];
					end

					if ( classAction ) then

						if ( classAction.action == "target" ) then
							if ( ArenaUnitFrames_Config["options"]["autofocus"] ) then
								text = "/targetexact "..name.."\n/focus [target=focus,noexists]";
							else
								text = "/targetexact "..name;
							end

						elseif ( classAction.action == "focus" ) then
--							text = "/focus [target="..name.."]";
							text = "/targetexact "..name.."\n/focus\n/targetlasttarget";

						elseif ( classAction.action == "cast" ) then
--							text = "/cast [target="..name.."] "..classAction.spell;
							text = "/targetexact "..name.."\n/cast "..classAction.spell.."\n/targetlasttarget";

						elseif ( classAction.action == "macro" ) then
							text = string.gsub(classAction.macro, "%$unit", name);
						end

					end
					if ( text ) then
						if ( modifier == "none" ) then
							button:SetAttribute("macrotext"..i, text);
						else
							button:SetAttribute(modifier.."-macrotext"..i, text);
						end
--debugmsg("("..i..") "..modifier..": "..text);
					end
				end
			end
			opponent.macro = true;
			getglobal("ArenaUnitFrame"..opponent.id.."Portrait"):SetVertexColor(1, 1, 1);
		end
	end
end

function ArenaUnitFramesUpdateDebuffs(name, unit)
	local i, spellName, icon, cc, new, cooldown, duration, timeLeft, startCooldownTime, count, show;

	count = 0;
	for i = 1, MAX_TARGET_DEBUFFS do
		spellName, _, icon, _, _, duration, timeLeft = UnitDebuff(unit, i);

		-- is this debuff CC?  handle CC buff tracking in case combat log event doesn't
		if ( ARENA_UNIT_FRAMES_EFFECT[spellName] ) then
			cc = true;

			-- is it new?
			if ( not ArenaUnitFrames_Opponents[name].cc[spellName] ) then
				ArenaUnitFrames_Opponents[name].cc[spellName] = {
					icon = ARENA_UNIT_FRAMES_EFFECT[spellName].icon,
					expire = GetTime() + ARENA_UNIT_FRAMES_EFFECT[spellName].duration
				};
				new = true;
			end
		end

		show = true;
		if ( ArenaUnitFrames_Config["lists"]["debuffs"]["which"] == 1 ) then
			-- black list
			if ( ArenaUnitFrames_DebuffFilter[spellName] ) then
				show = false;
			end
		else
			-- white list
			if ( not ArenaUnitFrames_DebuffFilter[spellName] ) then
				show = false;
			end
		end

		if ( icon and show ) then
			count = count + 1;
			button = getglobal("ArenaUnitFrame"..ArenaUnitFrames_Opponents[name].id.."Debuff"..count);
			getglobal("ArenaUnitFrame"..ArenaUnitFrames_Opponents[name].id.."Debuff"..count.."Icon"):SetTexture(icon);


			cooldown = getglobal("ArenaUnitFrame"..ArenaUnitFrames_Opponents[name].id.."Debuff"..count.."Cooldown");
			if ( duration ) then
				if ( duration > 0 ) then
					cooldown:Show();
					startCooldownTime = GetTime()-(duration-timeLeft);
					CooldownFrame_SetTimer(cooldown, startCooldownTime, duration, 1);
				else
					cooldown:Hide();
				end
			else
				cooldown:Hide();
			end

			button:Show();
			button.debuffName = spellName;
		end

		if ( count >= 6 ) then
			break;
		end
	end

	if ( count < 6 ) then
		for i = (count + 1), 6 do
			getglobal("ArenaUnitFrame"..ArenaUnitFrames_Opponents[name].id.."Debuff"..i):Hide();
		end
	end


	-- Buffs
	count = 0;
	for i = 1, MAX_TARGET_BUFFS do
		spellName, _, icon = UnitBuff(unit, i);

		show = true;
		if ( ArenaUnitFrames_Config["lists"]["buffs"]["which"] == 1 ) then
			-- black list
			if ( ArenaUnitFrames_BuffFilter[spellName] ) then
				show = false;
			end
		else
			-- white list
			if ( not ArenaUnitFrames_BuffFilter[spellName] ) then
				show = false;
			end
		end

		if ( icon and show ) then
			count = count + 1;

			button = getglobal("ArenaUnitFrame"..ArenaUnitFrames_Opponents[name].id.."Buff"..count);
			getglobal("ArenaUnitFrame"..ArenaUnitFrames_Opponents[name].id.."Buff"..count.."Icon"):SetTexture(icon);
			button:Show();
			button.buffName = spellName;

		end

		if ( count >= 6 ) then
			break;
		end
	end

	if ( count < 6 ) then
		for i = (count + 1), 6 do
			getglobal("ArenaUnitFrame"..ArenaUnitFrames_Opponents[name].id.."Buff"..i):Hide();
		end
	end


	-- if no cc icon found, but cc spell found in array, then clear array
	if ( not cc and next(ArenaUnitFrames_Opponents[name].cc) ) then
		ArenaUnitFrames_Opponents[name].cc = {};
		new = true;
	end

	-- update portrait if needed
	if ( new ) then
		ArenaUnitFramesUpdateFramePortrait(name);
	end
end

function ArenaUnitFramesCheckSpec(unit)
	if ( ArenaUnitFrames_StopChecking ) then
		return
	end
	if ( InCombatLockdown() ) then
		ArenaUnitFrames_StopChecking = true;
	end

	local i, spell;
	for i = 1, MAX_TARGET_BUFFS do
		spell = UnitBuff(unit, i);
		if ( ARENA_UNIT_FRAMES_SPEC[spell] and not ArenaUnitFrames_Spec[spell] ) then
			DEFAULT_CHAT_FRAME:AddMessage(	ARENA_UNIT_FRAMES_SPEC[spell].spec.." "..
							ARENA_UNIT_FRAMES_CLASSES[ARENA_UNIT_FRAMES_SPEC[spell].class]..
							ARENA_UNIT_FRAMES_DETECTED
			);
			ArenaUnitFrames_Spec[spell] = true;
		end
	end
end

function ArenaUnitFramesUpdateUnit(unit, name)
	if ( not name ) then
		name = UnitName(unit);
	end

	if ( not name or not ArenaUnitFrames_Opponents[name] ) then
		return
	end

	-- hp/mana bars
	ArenaUnitFramesUpdateFrameBars(name, unit);

	-- cast bar
	ArenaUnitFramesUpdateSpellBar(name, unit);

--	if ( unit ~= "mouseover" ) then
		-- debuffs
		ArenaUnitFramesUpdateDebuffs(name, unit);
--	end

	-- send data to group if nobody has this opponent targeted
--	if ( ( not ArenaUnitFrames_Opponents[name].path and unit == "mouseover" ) or unit == "focus" ) then
	if ( unit == "mouseover" or unit == "focus" ) then
		ArenaUnitFramesSendUpdate(name);
	end
end

function ArenaUnitFramesUpdateFrameBars(name, unit)
	if ( not ArenaUnitFrames_Opponents[name] ) then
		return
	end
	if ( unit and UnitExists(unit) and UnitIsVisible(unit) ) then
		ArenaUnitFrames_Opponents[name].hp = UnitHealth(unit);
		if ( UnitManaMax(unit) > 0 ) then
			ArenaUnitFrames_Opponents[name].mana = 100 / UnitManaMax(unit) * UnitMana(unit);
		else
			ArenaUnitFrames_Opponents[name].mana = 0;
		end

		-- set druid power bar to appropriate color
		if ( ArenaUnitFrames_Opponents[name].class == "DRUID" ) then
			local type = UnitPowerType(unit);

			if ( type == 1 ) then
				getglobal("ArenaUnitFrame"..ArenaUnitFrames_Opponents[name].id.."ManaBar"):SetStatusBarColor(1, 0, 0);
				getglobal("ArenaUnitFrame"..ArenaUnitFrames_Opponents[name].id.."MPBG"):SetVertexColor(1, 0, 0, 0.2);
			elseif ( type == 3 ) then
				getglobal("ArenaUnitFrame"..ArenaUnitFrames_Opponents[name].id.."ManaBar"):SetStatusBarColor(1, 1, 0);
				getglobal("ArenaUnitFrame"..ArenaUnitFrames_Opponents[name].id.."MPBG"):SetVertexColor(1, 1, 0, 0.2);
			else
				getglobal("ArenaUnitFrame"..ArenaUnitFrames_Opponents[name].id.."ManaBar"):SetStatusBarColor(0, 0, 1);
				getglobal("ArenaUnitFrame"..ArenaUnitFrames_Opponents[name].id.."MPBG"):SetVertexColor(0, 0, 1, 0.2);
			end
		end

		-- low health alert and hp not 0
		if ( ArenaUnitFrames_Config["alerts"]["lowHealth"] and ArenaUnitFrames_Opponents[name].hp > 0 ) then

			-- if health below threshold
			if ( ArenaUnitFrames_Opponents[name].hp <= ArenaUnitFrames_Config["alerts"]["lowHealthPct"] ) then

				-- if not already alerted
				if ( not ArenaUnitFrames_Opponents[name].lowHealthAlerted ) then

					-- if not alerted in the last 10 seconds
					if ( not ArenaUnitFrames_Opponents[name].lowHealthAlertedTime or ArenaUnitFrames_Opponents[name].lowHealthAlertedTime < time() - 10 ) then

						-- alert player
						ArenaUnitFrames_Alert(
							ArenaUnitFrames_ClassColors[ArenaUnitFrames_Opponents[name].class]..
							ARENA_UNIT_FRAMES_CLASSES[ArenaUnitFrames_Opponents[name].class]..
							"|r ("..name..") "..ARENA_UNIT_FRAMES_LOWHP_MSG
						);
						if ( ArenaUnitFrames_Config["alerts"]["soundfx"] ) then
							PlaySoundFile("Interface\\AddOns\\ArenaUnitFrames\\Sounds\\gogogo.wav");
						end

						ArenaUnitFrames_Opponents[name].lowHealthAlerted = true;
						ArenaUnitFrames_Opponents[name].lowHealthAlertedTime = time();
					end
				end
			else
				-- if alerted, and unit healed above low health pct + 19, reset alerted
				if (	ArenaUnitFrames_Opponents[name].lowHealthAlerted and 
					ArenaUnitFrames_Opponents[name].hp > (ArenaUnitFrames_Config["alerts"]["lowHealthPct"] + 19)
				) then
					ArenaUnitFrames_Opponents[name].lowHealthAlerted = nil;
				end

			end
		end
	end

	getglobal("ArenaUnitFrame"..ArenaUnitFrames_Opponents[name].id.."HealthBar"):SetValue(ArenaUnitFrames_Opponents[name].hp);
	getglobal("ArenaUnitFrame"..ArenaUnitFrames_Opponents[name].id.."ManaBar"):SetValue(ArenaUnitFrames_Opponents[name].mana);

	if ( (ArenaUnitFrames_Opponents[name].hp <= 0) ) then
		getglobal("ArenaUnitFrame"..ArenaUnitFrames_Opponents[name].id.."DeadText"):Show();
		getglobal("ArenaUnitFrame"..ArenaUnitFrames_Opponents[name].id.."ManaBar"):SetValue(0);
	else
		getglobal("ArenaUnitFrame"..ArenaUnitFrames_Opponents[name].id.."DeadText"):Hide();
	end
end

function ArenaUnitFramesUpdateSpellBar(name, unit)
	local spellName, _, spell, texture, startTime, endTime = UnitCastingInfo(unit);
	local channeling;
	if ( not spellName ) then
		spellName, _, spell, texture, startTime, endTime = UnitChannelInfo(unit);
		if ( not spellName ) then
			if ( ArenaUnitFrames_Opponents[name].spell ) then
				ArenaUnitFrames_Opponents[name].spell = nil;
				spellBar = getglobal("ArenaUnitFrame"..ArenaUnitFrames_Opponents[name].id.."SpellBar");

				spellBar.casting = nil;
				spellBar.channeling = nil;
				spellBar:Hide();
			end
			return
		else
			channeling = 1;
		end
	end

	if (	not ArenaUnitFrames_Opponents[name].spell or ArenaUnitFrames_Opponents[name].spell ~= spell or
		not ArenaUnitFrames_Opponents[name].startTime or ArenaUnitFrames_Opponents[name].startTime ~= startTime or
		not ArenaUnitFrames_Opponents[name].endTime or ArenaUnitFrames_Opponents[name].endTime ~= endTime
	) then
		ArenaUnitFrames_Opponents[name].spell = spell;
		ArenaUnitFrames_Opponents[name].startTime = startTime;
		ArenaUnitFrames_Opponents[name].endTime = endTime;
	else
		return
	end

	if ( ArenaUnitFrames_Opponents[name].spell ) then
		local spellBar = getglobal("ArenaUnitFrame"..ArenaUnitFrames_Opponents[name].id.."SpellBar");
		spellBar.startTime = ArenaUnitFrames_Opponents[name].startTime / 1000;
		spellBar.maxValue = ArenaUnitFrames_Opponents[name].endTime / 1000;
		spellBar.endTime = endTime / 1000;
		spellBar:SetMinMaxValues(spellBar.startTime, spellBar.maxValue);
		spellBar:SetValue(GetTime());
		spellBar:SetAlpha(1.0);
		getglobal("ArenaUnitFrame"..ArenaUnitFrames_Opponents[name].id.."SpellBarIcon"):SetTexture(texture);
		spellBar.holdTime = 0;
		spellBar.channeling = channeling;
		if ( not channeling ) then
			getglobal("ArenaUnitFrame"..ArenaUnitFrames_Opponents[name].id.."SpellBarSpark"):Show();
			spellBar:SetStatusBarColor(1.0, 0.7, 0.0);
			spellBar.casting = 1;
		else
			getglobal("ArenaUnitFrame"..ArenaUnitFrames_Opponents[name].id.."SpellBarSpark"):Hide();
			spellBar:SetStatusBarColor(0.0, 1.0, 0.0);
			spellBar.casting = nil;
		end
		getglobal("ArenaUnitFrame"..ArenaUnitFrames_Opponents[name].id.."SpellBarText"):SetText(ArenaUnitFrames_Opponents[name].spell);
		spellBar:Show();
	else
		getglobal("ArenaUnitFrame"..ArenaUnitFrames_Opponents[name].id.."SpellBar"):Hide();
	end
end

-- check for and remove expired CC debuffs.  If removed, update portrait
function ArenaUnitFramesCheckCC(name)
	local spell, spellInfo, change;
	local now = GetTime();

	-- iterate through all CC effects that are on this opponent
	for spell, spellInfo in pairs(ArenaUnitFrames_Opponents[name].cc) do
		-- remove expired effects (just in case "fades" or "is removed" is not seen)
		if ( spellInfo.expire < now ) then
			ArenaUnitFrames_Opponents[name].cc[spell] = nil;
			change = true;
		end
	end

	if ( change ) then
		ArenaUnitFramesUpdateFramePortrait(name);
	end
end

function ArenaUnitFramesUpdateFramePortrait(name)

	local portrait = getglobal("ArenaUnitFrame"..ArenaUnitFrames_Opponents[name].id.."Portrait");

	local spell, spellInfo;

	-- set portrait/icon to the next CC effect, if one
	spell, spellInfo = next(ArenaUnitFrames_Opponents[name].cc);
	if ( spell ) then
		portrait:SetTexture(spellInfo.icon);
		portrait:SetTexCoord(0, 1, 0, 1);
		return
	end

	-- set portrait to class icon
	local info = {};
	info = ArenaUnitFrames_UnitsClassIcon[ArenaUnitFrames_Opponents[name].class];
	portrait:SetTexture("Interface\\Glues\\CharacterCreate\\UI-CharacterCreate-Classes.blp");
	if ( info ) then
		portrait:SetTexCoord(info.right, info.left, info.top, info.bottom);
	end
end

function ArenaUnitFramesSendOpponent(name)
	local msg =	"0,"..
			name..","..
			ArenaUnitFrames_Opponents[name].class..","..
			ArenaUnitFrames_Opponents[name].hp..","..
			math.floor(ArenaUnitFrames_Opponents[name].mana);

	if ( msg ~= ArenaUnitFrames_LastMsg ) then
		SendAddonMessage("ArenaUnitFrames", msg, "PARTY");
		ArenaUnitFrames_LastMsg = msg;
	end
end

function ArenaUnitFramesSendUpdate(name)
	local msg = "1,"..name..","..ArenaUnitFrames_Opponents[name].hp..","..ArenaUnitFrames_Opponents[name].mana;
	if ( msg ~= ArenaUnitFrames_LastMsg ) then
		SendAddonMessage("ArenaUnitFrames", msg, "PARTY");
		ArenaUnitFrames_LastMsg = msg;
	end
end

function ArenaUnitFrameTemplate_OnUpdate()
	if ( this.spellTime > 0 ) then

		local timeNow = GetTime();

		if ( this.spellTime < timeNow ) then
			this.spellTime = 0;
			getglobal("ArenaUnitFrame"..this:GetID().."Spell"):SetText("");
		end
	end
end

-- every .2 seconds, iterate through all opponents and:
-- check if opponents that are reached by something like "party1targettarget" are no longer reachable, and darken frame if so
-- opponents with a depth of 2+ need to be updated very frequently this way, as events won't trigger for their hp/buffs/etc
-- check for expired debuffs, in case there is no path to them and we are too far to get chat messages
function ArenaUnitMasterFrame_OnUpdate(arg1)
	ArenaUnitMasterFrame_UpdateTime = ArenaUnitMasterFrame_UpdateTime + arg1;
	if ( ArenaUnitMasterFrame_UpdateTime > .2 ) then
		ArenaUnitMasterFrame_UpdateTime = 0;

		local name, opponent, i;
		local now = GetTime();

		for name, opponent in pairs(ArenaUnitFrames_Opponents) do

			-- depth 1 means "target" or "focus"
			-- depth 2 means "partyXtarget" or "targettarget" or "focustarget"
			-- depth 3+ means "partyXtargettarget" and so on
			if ( opponent.path
				--and opponent.depth > 0
			) then

				-- is this path no longer valid?  then darken frame
				if ( UnitName(opponent.path) ~= name ) then
					opponent.path = nil;
					opponent.depth = nil;
					getglobal("ArenaUnitFrame"..opponent.id):SetAlpha(.5);
					getglobal("ArenaUnitFrame"..ArenaUnitFrames_Opponents[name].id.."ToT"):SetText("");

					for i = 1, 6 do
						getglobal("ArenaUnitFrame"..opponent.id.."Debuff"..i):Hide();
						getglobal("ArenaUnitFrame"..opponent.id.."Buff"..i):Hide();
					end
					ArenaUnitFramesSetAssistButtons();
				else
					-- units with a depth greater than one must be updated very frequently
					-- mouseover units do not trigger events, either
					if ( opponent.depth > 1 or opponent.path == "mouseover" ) then
						ArenaUnitFramesUpdateUnit(opponent.path);
					end

					if ( ArenaUnitFrames_Config["options"]["buffscan"] ) then
						ArenaUnitFramesCheckSpec(opponent.path);
					end

					-- update target of target
					ArenaUnitFramesUpdateToT(name);
				end

				if ( ArenaUnitFrames_Debug ) then
					getglobal("ArenaUnitFrame"..opponent.id.."Debug"):SetText(opponent.path);
				end
			end

			-- check for expired CC debuffs on units not targeted or focused
			if ( opponent.path ~= 1 and next(ArenaUnitFrames_Opponents[name].cc)) then
				ArenaUnitFramesCheckCC(name);
			end

			-- check countdown
			if ( opponent.countdown and opponent.countdown > now ) then
				getglobal("ArenaUnitFrame"..opponent.id.."Countdown"):SetText(math.ceil(opponent.countdown - now));
			elseif ( getglobal("ArenaUnitFrame"..opponent.id.."Countdown"):IsVisible() ) then
				getglobal("ArenaUnitFrame"..opponent.id.."Countdown"):Hide();
				getglobal("ArenaUnitFrame"..opponent.id.."Cooldown"):Hide()
			end
		end
	end
end

function ArenaUnitFramesUpdateToT(name)
	local path = ArenaUnitFrames_Opponents[name].path.."target";
	local target = UnitName(path);

	if ( target ~= ArenaUnitFrames_Opponents[name].tot ) then
		-- new target
		local label = getglobal("ArenaUnitFrame"..ArenaUnitFrames_Opponents[name].id.."ToT");

		ArenaUnitFrames_Opponents[name].tot = target;
		label:SetText(target);
		
		if ( target ) then
			if ( UnitIsEnemy(path, "player") ) then
				label:SetTextColor(1, .5, .5);
			elseif ( UnitIsFriend("player", path) ) then
				label:SetTextColor(.5, 1, .5);
			else
				label:SetTextColor(1, 1, 0);
			end
		end
	end
end

function ArenaUnitFrames_Alert(msg, type)
	-- 1 == red message
	if ( type == 1 ) then
		ArenaUnitFramesAlertFrame:AddMessage( msg, 1.0, 0.5, 0.5, 1.0, 0 );
	else
		-- else green message
		ArenaUnitFramesAlertFrame:AddMessage( msg, 0.0, 1.0, 0.0, 1.0, 0 );
	end
end

function ArenaUnitFramesTrackingFrame_OnUpdate()
	if ( ArenaUnitFrames_Found == ArenaUnitFrames_TeamSize ) then
		this:Hide();
		return
	end

	-- if cursor not in minimap
	if ( GetMouseFocus() and GetMouseFocus():GetName() ~= "Minimap" ) then
		return
	end

	local text = GameTooltipTextLeft1:GetText();
	if ( text and text ~= "" and not ArenaUnitFrames_Opponents[text] and not ArenaUnitFrames_Tracked[text] ) then

		local people = {};
		local name, updatePortraits, colorlessName;

		if ( not string.find(text, "%\n") ) then
			if ( string.find(text, "|") ) then
				text = string.match(text, "^|c........([^|]+)");
			end
			people[text] = true;
		else
			-- replacing \n's with @s before gmatching because of what seems to be a bug
			text = gsub(text, "%\n", "@");
			for name in string.gmatch(text, "([^@]+)") do
				if ( string.find(name, "|") ) then
					colorlessName = string.match(name, "^|c........([^|]+)");
					people[colorlessName] = true;
				else
					people[name] = true;
				end
			end
		end
		for name in pairs(people) do
			if (	not ArenaUnitFrames_Opponents[name] 
				and not ArenaUnitFrames_Tracked[name]
				and name ~= UnitName("party1")
				and name ~= UnitName("party2")
				and name ~= UnitName("party3")
				and name ~= UnitName("party4")
				and name ~= UNKNOWN
				and not string.find(name, " ")
			) then
				ArenaUnitFrames_Tracked[name] = true;
				updatePortraits = true;
			end
		end

		if ( updatePortraits ) then
			ArenaUnitFrames_SetTrackingPortraits();
		end
	end
end

function ArenaUnitFrames_SetTrackingPortraits()

	local i, name, frame, button, portrait, n;

	-- clear any tracked/unused frames
	for i = 1, 5 do
		frame = getglobal("ArenaUnitFrame"..i);
		if ( not frame.name ) then

			-- hide everything if not in combat, and just hide no longer tracked units if in combat
			if ( InCombatLockdown() ) then

				-- if unit is no longer tracked
				if ( not ArenaUnitFrames_Tracked[getglobal("ArenaUnitFrame"..i.."Name"):GetText()] ) then
					frame:SetAlpha(0);
				end
			else

				getglobal("ArenaUnitFrame"..i.."Name"):SetText();
				portrait = getglobal("ArenaUnitFrame"..i.."Portrait");
				portrait:SetTexture("");

				button = getglobal("ArenaUnitFrame"..i.."Button");
				button:SetAttribute("*type*", "macro");
				button:SetAttribute("macrotext1", "");

				getglobal("ArenaUnitFrame"..i.."HealthBar"):Hide();
				getglobal("ArenaUnitFrame"..i.."ManaBar"):Hide();
				getglobal("ArenaUnitFrame"..i.."MPBG"):SetVertexColor(.5, .5, .5, 0.2);

				frame:SetAlpha(0);
			end
		end
	end

	if ( InCombatLockdown() ) then
		return
	end

	-- set tracked frames
	n = 0;
	for name in pairs(ArenaUnitFrames_Tracked) do

		if ( n >= ArenaUnitFrames_TeamSize ) then
			return
		end

		for i = (ArenaUnitFrames_TeamSize - n), 1, -1 do

			frame = getglobal("ArenaUnitFrame"..i);
			if ( not frame.name ) then

				getglobal("ArenaUnitFrame"..i.."Name"):SetText(name);
				portrait = getglobal("ArenaUnitFrame"..i.."Portrait");
				portrait:SetTexture("Interface\\Icons\\INV_Misc_QuestionMark.blp");
				portrait:SetTexCoord(0, 1, 0, 1);

				button = getglobal("ArenaUnitFrame"..i.."Button");
				button:SetAttribute("*type*", "macro");
				button:SetAttribute("macrotext1", "/targetexact "..name);

				getglobal("ArenaUnitFrame"..i.."HealthBar"):Hide();
				getglobal("ArenaUnitFrame"..i.."ManaBar"):Hide();
				getglobal("ArenaUnitFrame"..i.."MPBG"):SetVertexColor(.5, .5, .5, 0.2);

				frame:SetAlpha(.5);

				n = n + 1;

				break;
			end
		end
	end
end

function ArenaUnitFrames_SetBuffFilter()

	local buff, list;

	-- buffs

	if ( ArenaUnitFrames_Config["lists"]["buffs"]["which"] == 1 ) then
		list = "black";
	else
		list = "white";
	end

	ArenaUnitFrames_BuffFilter = {};
	for buff in string.gmatch(ArenaUnitFrames_Config["lists"]["buffs"][list], "[^\n]+") do
		if ( buff and buff ~= "" ) then
			buff = strtrim(buff);
			ArenaUnitFrames_BuffFilter[buff] = 1;
		end
	end


	-- debuffs

	if ( ArenaUnitFrames_Config["lists"]["debuffs"]["which"] == 1 ) then
		list = "black";
	else
		list = "white";
	end

	ArenaUnitFrames_DebuffFilter = {};
	for buff in string.gmatch(ArenaUnitFrames_Config["lists"]["debuffs"][list], "[^\n]+") do
		if ( buff and buff ~= "" ) then
			buff = strtrim(buff);
			ArenaUnitFrames_DebuffFilter[buff] = 1;
		end
	end

end