--[[
	Copyright (C) 2007 Nymbia

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along
	with this program; if not, write to the Free Software Foundation, Inc.,
	51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
]]

local _G = getfenv(0)
local getpoints
if AceLibrary and AceLibrary:HasInstance(("Glory-2.0")) then
	local glory = AceLibrary("Glory-2.0")
	function getpoints(rating, size)
		return glory:GetArenaPointsFromRating(rating,size)
	end
else
	local ratios = {
		[2] = 0.76,
		[3] = 0.88,
		[5] = 1,
	}
	function getpoints(rating, teamsize)
		local points
		if rating > 1500 then 
			points = 1511.26 / (1 + 1639.28 * math.exp(-0.00412 * rating))
		else
			points = 0.22 * rating + 14
		end
		return math.floor(0.5 + points * ratios[teamsize])
	end
end
do
	PVPTeam1DataRatingLabel:ClearAllPoints()
	PVPTeam1DataRatingLabel:SetPoint("RIGHT",PVPTeam1DataName,"RIGHT",0,0)
	PVPTeam1DataRating:SetWidth(90)
	PVPTeam2DataRatingLabel:ClearAllPoints()
	PVPTeam2DataRatingLabel:SetPoint("RIGHT",PVPTeam2DataName,"RIGHT",0,0)
	PVPTeam2DataRating:SetWidth(90)
	PVPTeam3DataRatingLabel:ClearAllPoints()
	PVPTeam3DataRatingLabel:SetPoint("RIGHT",PVPTeam3DataName,"RIGHT",0,0)
	PVPTeam3DataRating:SetWidth(90)
	local teams = {}
	local old_PVPTeam_Update = PVPTeam_Update
	function PVPTeam_Update(...)
		old_PVPTeam_Update(...)
		for i = 1,3 do
			local teamName, teamSize = GetArenaTeam(i)
			if teamName then
				teams[teamName] = tonumber(teamSize)
			end
		end
		for i = 1,3 do
			local rating = tonumber(_G["PVPTeam"..i.."DataRating"]:GetText())
			if rating then
				local teamname = _G["PVPTeam"..i.."DataName"]:GetText()
				if not teams[teamname] then
					return
				end
				_G["PVPTeam"..i.."DataRating"]:SetText(rating..(" (%d)"):format(getpoints(rating, teams[teamname])))
			end
		end
	end
end
if InspectPVPTeam_Update then
	local old_InspectPVPTeam_Update = InspectPVPTeam_Update
	local initinspect
	local inspectteams = {}
	function InspectPVPTeam_Update(...)
		old_InspectPVPTeam_Update(...)
		if not initinspect then
			InspectPVPTeam1DataRatingLabel:ClearAllPoints()
			InspectPVPTeam1DataRatingLabel:SetPoint("RIGHT",InspectPVPTeam1DataName,"RIGHT",0,0)
			InspectPVPTeam1DataRating:SetWidth(90)
			InspectPVPTeam2DataRatingLabel:ClearAllPoints()
			InspectPVPTeam2DataRatingLabel:SetPoint("RIGHT",InspectPVPTeam2DataName,"RIGHT",0,0)
			InspectPVPTeam2DataRating:SetWidth(90)
			InspectPVPTeam3DataRatingLabel:ClearAllPoints()
			InspectPVPTeam3DataRatingLabel:SetPoint("RIGHT",InspectPVPTeam3DataName,"RIGHT",0,0)
			InspectPVPTeam3DataRating:SetWidth(90)
			initinspect = true
		end
		for k in pairs(inspectteams) do
			inspectteams[k] = nil
		end
		for i = 1,3 do
			local teamName, teamSize = GetInspectArenaTeamData(i)
			if teamName then
				inspectteams[teamName] = tonumber(teamSize)
			end
		end
		for i = 1,3 do
			local rating = tonumber(_G["InspectPVPTeam"..i.."DataRating"]:GetText())
			if rating then
				local teamname = _G["InspectPVPTeam"..i.."DataName"]:GetText()
				if not inspectteams[teamname] then
					return
				end
				_G["InspectPVPTeam"..i.."DataRating"]:SetText(rating..(" (%d)"):format(getpoints(rating, inspectteams[teamname])))
			end
		end
	end
end
