ArenaMaster = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceEvent-2.0", "AceDB-2.0")
local L = AceLibrary("AceLocale-2.2"):new("ArenaMaster")
local BZ = AceLibrary("Babble-Zone-2.2")

function ArenaMaster:OnInitialize()
	self.list = {}
	self.livelist={}
	self.livelistclass={}
	self.liveliststatus={}
	self.targetok={0,0,0,0,0}
	self.zoneCheck=false
	self.prefixAM="ArenaMaster"
  self:ResetList()
  self.zoneCheck=false
  self.dummy=false
  ArenaMaster:RegisterDB("ArenaMasterDB")
	ArenaMaster:RegisterDefaults("profile", {
		height=240,
		width=460,
		scale=0.6,
		pointx=0,
		pointy=0,
		r=0,
		g=0,
		b=0,
		alpha=1,
		fontsize=39,
		border=true,
		padding=35,
		}
	)   
	self:SetFrame()
	
	local options = { 
    type="group",
    args = {
    	show = {
				type="toggle",
				name="Show",
				desc="Show",
				get=function() return ArenaMaster.frame:IsVisible() end,
				set=function(v) if ArenaMaster.frame:IsVisible() then ArenaMaster.frame:Hide() else ArenaMaster.frame:Show() end end,
				order=1,
    	},
    	border={
    		type="toggle",
				name="Border",
				desc="Show Border",
				get=function() return self.db.profile.border end,
				set=function(v) self.db.profile.border = not self.db.profile.border end,
				order=3,
    	},
    	height = {
				type="range",
				name="Height",
				desc="Height",
				get=function() return self.db.profile.height end,
    		set=function(v) self.db.profile.height = v 
    						self:FrameRefresh()
    						end,
				min=1,
				max=1000,
				step=1,
    	},
    	width = {
				type="range",
				name="Width",
				desc="Width",
				get=function() return self.db.profile.width end,
    		set=function(v) self.db.profile.width = v 
    					self:FrameRefresh()
    					end,
				min=1,
				max=1000,
				step=1,
    	},
    	scale = {
				type="range",
				name="Scale",
				desc="Scale",
				get=function() return self.db.profile.scale end,
    		set=function(v) self.db.profile.scale = v 
    					self:FrameRefresh()
    					end,
				min=0.1,
				max=10,
				step=0.1,
    	},
    fontsize = {
				type="range",
				name="Font Size",
				desc="Font Size",
				get=function() return self.db.profile.fontsize end,
    		set=function(v) self.db.profile.fontsize = v 
    					self:FrameRefresh()
    					end,
				min=1,
				max=100,
				step=1,
    	},
    padding = {
				type="range",
				name="Padding",
				desc="Padding",
				get=function() return self.db.profile.padding end,
    		set=function(v) self.db.profile.padding = v 
    					self:FrameRefresh()
    					end,
				min=1,
				max=100,
				step=1,
    	},
    	pick = {
					type = 'execute',
					name = "Background color",
					desc = "Pick a color",
					order=2,
					func = function()
						ColorPickerFrame.func = function()
							self.db.profile.r, self.db.profile.g, self.db.profile.b = ColorPickerFrame:GetColorRGB();
							self.db.profile.alpha = OpacitySliderFrame:GetValue()
							self:FrameRefresh()
						end
						ColorPickerFrame.opacityFunc = function()
							self.db.profile.r, self.db.profile.g, self.db.profile.b = ColorPickerFrame:GetColorRGB();
							self.db.profile.alpha = OpacitySliderFrame:GetValue()
							self:FrameRefresh()
						end
						ColorPickerFrame.cancelFunc = function()
							self.db.profile.r,self.db.profile.g,self.db.profile.b = self.oldrgb
							self.db.profile.alpha = self.oldopac
							self:FrameRefresh()
						end
						ColorPickerFrame:SetColorRGB(self.db.profile.r, self.db.profile.g, self.db.profile.b);
						ColorPickerFrame.previousValues = {self.db.profile.r, self.db.profile.g, self.db.profile.b}
						self.oldrgb = {self.db.profile.r, self.db.profile.g, self.db.profile.b}
						self.oldopac = self.db.profile.alpha
						ColorPickerFrame.hasOpacity = true
						ColorPickerFrame.opacity = self.db.profile.alpha
						ColorPickerFrame:Show()
					end,
				},
			dummy = {
			type='toggle',
			name='Dummy enemies',
			desc='Fill with dummy enemies',
			order=2000,
			get= function() return self.dummy end,
			set=function(v) 
				if v then self:Dummy() else self:ResetList() end 
				self.dummy = not self.dummy
				self:FrameRefresh()
			end,
			},
		}
	}
	ArenaMaster:RegisterChatCommand({"/arenamaster", "/am"}, options)

end

function ArenaMaster:OnDisable()
	self:ResetList()
end


function ArenaMaster:OnEnable()
    self:ResetList()
    self.zoneCheck=false
	self:RegisterEvent("PLAYER_ENTERING_WORLD")
end

function ArenaMaster:PLAYER_ENTERING_WORLD()
	self.zoneCheck=false
	self:ScheduleEvent(self.ZoneCheck, 5, self)
end

function ArenaMaster:CHAT_MSG_COMBAT_HOSTILE_DEATH(msg)
  for i=1,table.getn(self.livelist) do
		if msg == string.format(UNITDIESOTHER, self.livelist[i]) then
			self.liveliststatus[i]=0
		end
   end
end

function ArenaMaster:ZoneCheck()

	self.zoneCheck=false
	self:ResetList()
 	self:RegisterEvent("CHAT_MSG_ADDON")
 	self:RegisterEvent("UNIT_HEALTH")
 	self:RegisterEvent("CHAT_MSG_COMBAT_HOSTILE_DEATH")
 	self:RegisterEvent("UPDATE_MOUSEOVER_UNIT") 
	self:RegisterEvent("PLAYER_TARGET_CHANGED")
	
	if GetMinimapZoneText() == BZ["Ruins of Lordaeron"] or GetMinimapZoneText() == BZ["Nagrand Arena"] or GetMinimapZoneText() == BZ["Blade's Edge Arena"] then
		self.zoneCheck=true
		self.frame:Show()
		if not self:IsEventScheduled("arenarefresh") then
		self:ScheduleRepeatingEvent("arenarefresh", function() self:FrameRefresh() end, .1)
		end

	else 
	  self:UnregisterEvent("UPDATE_MOUSEOVER_UNIT")
	  self:UnregisterEvent("PLAYER_TARGET_CHANGED")
	  self:UnregisterEvent("UNIT_HEALTH")
	  self:UnregisterEvent("CHAT_MSG_ADDON")
	  self:UnregisterEvent("CHAT_MSG_COMBAT_HOSTILE_DEATH")
	  self:CancelScheduledEvent("arenarefresh")
		self.frame:Hide()
	end
end


function ArenaMaster:UPDATE_MOUSEOVER_UNIT()
	if self.zoneCheck==true  then
   		if self:CheckList(UnitName("mouseover")) then 
   	 		if not UnitIsFriend("player","mouseover") then
   	 		  local class=L:GetReverseTranslation(UnitClass("mouseover"))
   	 			if (UnitCreatureType("mouseover")== L["Humanoid"] or class=="Druid" or class=="Shaman") and not strfind(UnitName("mouseover"), " ") then
   					self:AddToList(UnitName("mouseover"))
   					local name=UnitName("mouseover")
   					table.insert(self.livelist, name)
   					table.insert(self.livelistclass, class)
    				table.insert(self.liveliststatus, UnitHealth("mouseover"))
    				SendAddonMessage("ArenaMaster", name.." "..class, "BATTLEGROUND")
   				end
   			end
		elseif UnitHealth("mouseover") > 0 then self:HandleFD(UnitName("mouseover"),0,"alive",UnitHealth("mouseover"))
		elseif UnitHealth("mouseover") <= 0 and UnitDebuff("mouseover",1)~=nil and L:GetReverseTranslation(UnitClass("mouseover"))=="Hunter" then self:HandleFD(UnitName("mouseover"),0,"FD",UnitHealth("mouseover"))	
		elseif UnitHealth("mouseover") <= 0 then self:HandleFD(UnitName("target"),0,"dead",0)
		end
	end
end


function ArenaMaster:PLAYER_TARGET_CHANGED()
 if UnitName("target")~=nil then
	if self.zoneCheck==true  then
   		if self:CheckList(UnitName("target")) then 
   	 		if not UnitIsFriend("player","target") then
   	 			local class=L:GetReverseTranslation(UnitClass("target"))
   	 			if (UnitCreatureType("target")== L["Humanoid"] or class=="Druid" or class=="Shaman") and not strfind(UnitName("target"), " ") then
   					self:AddToList(UnitName("target"))
   					local name=UnitName("target")
   					table.insert(self.livelist, name)
   					table.insert(self.livelistclass, class)
    				table.insert(self.liveliststatus, UnitHealth("target"))
    				SendAddonMessage("ArenaMaster", name.." "..class, "BATTLEGROUND")
   				end
   			end
		elseif UnitHealth("target") > 0 then self:HandleFD(UnitName("target"),0,"alive",UnitHealth("target"))
		elseif UnitHealth("target") <= 0 and UnitDebuff("target",1)~=nil and L:GetReverseTranslation(UnitClass("target"))=="Hunter" then self:HandleFD(UnitName("target"),0,"FD",UnitHealth("target"))	
		elseif UnitHealth("target") <= 0 then self:HandleFD(UnitName("target"),0,"dead",0)
		end
	end
 end
end

function ArenaMaster:UNIT_HEALTH()
 if UnitName("target")~=nil and arg1=="target" then
	if self.zoneCheck==true  then
   		if self:CheckList(UnitName("target")) then 
   	 		if not UnitIsFriend("player","target") then
   	 			local class=L:GetReverseTranslation(UnitClass("target"))
   	 			if (UnitCreatureType("target")== L["Humanoid"] or class=="Druid" or class=="Shaman") and not strfind(UnitName("target"), " ") then
   					self:AddToList(UnitName("target"))
   					local name=UnitName("target")
   					table.insert(self.livelist, name)
   					table.insert(self.livelistclass, class)
    				table.insert(self.liveliststatus, UnitHealth("target"))
    				SendAddonMessage("ArenaMaster", name.." "..class, "BATTLEGROUND")
   				end
   			end
		elseif UnitHealth("target") > 0 then self:HandleFD(UnitName("target"),0,"alive",UnitHealth("target"))
		elseif UnitHealth("target") <= 0 and UnitDebuff("target",1)~=nil and L:GetReverseTranslation(UnitClass("target"))=="Hunter" then self:HandleFD(UnitName("target"),0,"FD",UnitHealth("target"))
		elseif UnitHealth("target") <= 0 then self:HandleFD(UnitName("target"),0,"dead",0)	
		end
	end
 end
end


function ArenaMaster:CHAT_MSG_ADDON()
	local prefix, message, dist, sender = arg1, arg2, arg3, arg4
	if (prefix==self.prefixAM) then
		if (sender==UnitName("player")) then return end
		if self.zoneCheck==true then
			local limit,limit2=string.find(message," ")
			if limit==nil then return end
			local name=string.sub(message,0,limit-1)
			local class=string.sub(message,limit+1)
			
			if strfind(class,"alive") then 
				local a=string.gsub(class, "alive", "")
				self:HandleFD(name,1,"alive",tonumber(a))
			elseif class=="FD" then self:HandleFD(name,1,"FD")
			elseif class=="dead" then self:HandleFD(name,1,"dead",0)
   		elseif self:CheckList(name) then
   					self:AddToList(name)
   					table.insert(self.livelist, name)
   					table.insert(self.livelistclass, class)
    				table.insert(self.liveliststatus, 100)
			end
  	 end
	end	
end

function ArenaMaster:GetColor(class)
	local temp="|cffffffff"
	if class=="Druid" then temp="|cffff7c0a" end
	if class=="Hunter" then temp="|cffaad372" end
	if class=="Mage" then temp="|cff68ccef" end
	if class=="Paladin" then temp="|cfff48cba" end
	if class=="Priest" then temp="|cffffffff" end
	if class=="Rogue" then temp="|cfffff468" end
	if class=="Shaman" then temp="|cff00dbba" end
	if class=="Warlock" then temp="|cff9382c9" end
	if class=="Warrior" then temp="|cffc69b6d" end
	if class=="dead" then temp="|cff465945" end
	return temp
end

function ArenaMaster:AddToList(name)
	table.insert(self.list, name)
	local i=table.getn(self.list)
end

function ArenaMaster:CheckList(name)
  local result=true
	for i=1,table.getn(self.list) do
	   if self.list[i]==name then 
	  	 result=false 
	   end
	end
	return result
end


function ArenaMaster:ResetList()
	self.list= {}
	self.livelist={}
	self.livelistclass={}
	self.liveliststatus={}
	self.targetok={0,0,0,0,0}
	if self.frame ~= nil then 
		for i=1,5 do
			self.frame.buttons[i].text:SetText("")
		end
	end
end

function ArenaMaster:HandleFD(name,nobroadcast,status,perc)

	if status=="alive" then
		for i=1,table.getn(self.list) do
			if self.list[i]==name then
				if self.liveliststatus[i] ~= perc then
					self.liveliststatus[i]=perc
					if nobroadcast==0 then SendAddonMessage(self.prefixAM, name.." ".."alive"..perc, "BATTLEGROUND") end
				end
			end
		end
		
		
	elseif status=="FD" then
		for i=1,table.getn(self.list) do
			if self.list[i]==name then
				if self.liveliststatus[i]>=0 then
					self.liveliststatus[i]=-1
					if nobroadcast==0 then SendAddonMessage(self.prefixAM, name.." ".."FD", "BATTLEGROUND") end
				end
			end
		end		
		
	elseif status=="dead" then
		for i=1,table.getn(self.list) do
			if self.list[i]==name then
				if self.liveliststatus[i]>0 then
					self.liveliststatus[i]=0
					if nobroadcast==0 then SendAddonMessage(self.prefixAM, name.." ".."dead", "BATTLEGROUND") end
				end
			end
		end	 
	end
end


function ArenaMaster:SetFrame()
	local width=self.db.profile.width
	local height=self.db.profile.height
	self.frame=CreateFrame("Frame","AMF",UIParent,nil)
	self.frame:SetWidth(width)  
	self.frame:SetHeight(height) 
	self.frame:SetScale(self.db.profile.scale)
	self.frame:SetPoint("CENTER", UIParent, "CENTER", self.db.profile.pointx, self.db.profile.pointy)
	
	if self.db.profile.border then self.frame:SetBackdrop({bgFile = "Interface/Tooltips/UI-Tooltip-Background", 
                                            edgeFile = "Interface/Tooltips/UI-Tooltip-Border", 
                                           tile = true, tileSize = 16, edgeSize = 16, 
                                           insets = { left = 4, right = 4, top = 4, bottom = 4 }});
  end
	self.frame:SetBackdropColor(self.db.profile.r,self.db.profile.g,self.db.profile.b,self.db.profile.alpha);
	self.frame:EnableMouse(true)
	self.frame:SetClampedToScreen()
	self.frame:SetMovable(true)
	self.frame:RegisterForDrag("LeftButton")
	self.frame:SetScript("OnDragStart", function() if not InCombatLockdown() and IsAltKeyDown() then this:StartMoving() end end)
	self.frame:SetScript("OnDragStop", function() if not InCombatLockdown() then this:StopMovingOrSizing() self:SavePos() end end)
		
	
	local header=CreateFrame("Button", "Target", self.frame, "SecureActionButtonTemplate")
	header:SetHeight(height/6)
	header:SetWidth(width)
	header:RegisterForClicks("LeftButtonUp")
	header:SetPoint("TOPLEFT",self.frame,"TOPLEFT",0,0)
			
	header.text = header:CreateFontString("htext","BACKGROUND")
	header.text:SetFont(GameFontNormal:GetFont(), self.db.profile.fontsize)
	header.text:SetJustifyH("CENTER")
	header.text:SetText(" ")
	header.text:ClearAllPoints()
	header.text:SetAllPoints(header)
	header.text:SetText("Arena Master")
	header:EnableMouse(true)
	header:SetMovable(true)
	header:RegisterForDrag("LeftButton")
	header:SetScript("OnDragStart", function() if not InCombatLockdown() and IsAltKeyDown() then self.frame:StartMoving() end end)
	header:SetScript("OnDragStop", function() if not InCombatLockdown() then self.frame:StopMovingOrSizing() self:SavePos() end end)
	self.frame.header=header
	
	self.frame.buttons={}
	for i=1,5 do
		local b=CreateFrame("Button", "Target", self.frame, "SecureActionButtonTemplate")
		b:SetHeight(height/6)
		b:SetWidth(width)
		b:RegisterForClicks("LeftButtonUp")
		b:SetAttribute("type1", "macro")
		b:SetAttribute("macrotext", "/target ".."Athou")
		b:SetPoint("TOPLEFT",self.frame,"TOPLEFT",width/10,-self.db.profile.padding*i)
	
		b.text = b:CreateFontString("text"..i,"BACKGROUND")
		b.text:SetFont(GameFontNormal:GetFont(), self.db.profile.fontsize)
		b.text:SetJustifyH("LEFT")
		b.text:SetText(" ")
		b.text:ClearAllPoints()
		b.text:SetAllPoints(b)
		

		table.insert(self.frame.buttons,b)

	end
	self.frame:Hide()
end

function ArenaMaster:FrameRefresh()
	local width=self.db.profile.width
	local height=self.db.profile.height
	self.frame:SetWidth(width)  
	self.frame:SetHeight(height) 
	self.frame:SetScale(self.db.profile.scale)
	self.frame.header.text:SetFont(GameFontNormal:GetFont(), self.db.profile.fontsize)
	self.frame:SetBackdropColor(self.db.profile.r,self.db.profile.g,self.db.profile.b,self.db.profile.alpha);
        for i=1,table.getn(self.livelist) do
        		self.frame.buttons[i].text:SetFont(GameFontNormal:GetFont(), self.db.profile.fontsize)
        		self.frame.buttons[i]:SetPoint("TOPLEFT",self.frame,"TOPLEFT",width/10,-self.db.profile.padding*i)
            local name=self.livelist[i]
            local class=self.livelistclass[i]
						local color=self:GetColor(class)
            if self.liveliststatus[i]==0 then color=self:GetColor("dead") end
            local class=L:GetTranslation(class)
            if not InCombatLockdown() then self.targetok[i]=1 end
            local notar=""
            if self.targetok[i]==0 then notar="[x] " end
            if self.liveliststatus[i]==-1 then 
        			self.frame.buttons[i].text:SetText(notar..color..class.." ** FD ** ("..name..")|r")
        			if self.targetok[i]==1 then self.frame.buttons[i]:SetAttribute("macrotext", "/target "..name) end
						else
							self.frame.buttons[i].text:SetText(notar..color..class.." ("..name..") "..self.liveliststatus[i].."%|r")
							if self.targetok[i]==1 then self.frame.buttons[i]:SetAttribute("macrotext", "/target "..name) end
						end
        end
        if table.getn(self.livelist) == 5 then return end
        for i=table.getn(self.livelist)+1,5 do
        	self.frame.buttons[i]:SetText("")
        end
end

function ArenaMaster:SavePos()
	local point,relativeTo,relativePoint,xOfs,yOfs = self.frame:GetPoint()
	self.db.profile.pointx=xOfs
	self.db.profile.pointy=yOfs
end

function ArenaMaster:Dummy()

	self.list={"Player1", "Player2", "Player3", "Player4", "Player5" }
	self.livelist={"Player1", "Player2", "Player3", "Player4", "Player5" }
	self.livelistclass={"Rogue", "Warlock", "Priest", "Paladin", "Shaman"}
	self.liveliststatus = {100,98,54,12,59}
end
