-------------------------------------------------------------------------------------------------------
-- Arcanum

-- Addon pour Mage inspiré du célébre Necrosis
-- Gestion des buffs, des portails et Compteur de Composants

-- Remerciements aux auteurs de Necrosis

-- Auteur Lenny415

-- Serveur:
-- Uliss, Nausicaa, Solcarlus, Thémys on Medivh EU
------------------------------------------------------------------------------------------------------


------------------------------------------------------------------------------------------------------

-- FONCTIONS GENERALES EN RELATION AVEC LE FICHIER XML

------------------------------------------------------------------------------------------------------


Default_ArcanumConfig = {
	Version = ArcanumData.Version;
	ChatType = true;
	Tooltip = 1;
	PortalMessage = true;
    MountMessage = true;
    InsideDisplay = 1;
    Display = {true, --DisplayHearthstone
    true,--DisplayManaGem
    true,--DisplayEvocation
    true,--DisplayIceBlock
    true,--DisplayColdSnap
    true,--DisplayIntell
    true,--DisplayArmor
    true,--DisplayBandage
    };
    
    DisplayHealthMana = true;
    HealthColor = {
    r = 0,
    g = 1,
    b = 0,
    };
    ManaColor = {
    r = 0,
    g = 0,
    b = 1,
    };
    ButtonColor = {
    r = 0,
    g = 1,
    b = 1,
    };
    
    MinimapIcon = true;
    MinimapIconPos = 360;
    
    EvocationLimit = 20;
	LevelBuff = true;
    ConsumeFood =  2;
    ConsumeGems = 1;
    RandMount =  false;
	
	ReagentSort = true;
	ReagentContainer = 3;
	ReagentBuy = true;
	Powder = 20;
	Teleport = 10;
	Portal = 10;
	
	InterfaceVersion = 1;
    BuffType = 0;
	BuffButton =  true;
	ArmorButton =  true;
	MagicButton =  true;
	PortalButton =  true;
	MountButton =  true;
    JobButton =  true;
    WardButton =  true;
	FoodButton =  true;
	WaterButton =  true;
	ManaGemButton =  true;
    LeftClick = 1;
    MiddleClick = 2;
    RightClick = 3;
    ButtonsOrder = {1,2,3,4,5,6,7,8,9,10};
	
    LastBuff = 12;
    LastArmor = 2;
    LastMagic = 7;
    LastPortal = 1;
    LastMount = 1;
    LastJob = 1;
    LastWard = 57;
    
	ArcanumLockServ = true;
	Toggle = true;
	NoDragAll = false;
	BuffMenuPos = 1;
	ArmorMenuPos = 1;
	MagicMenuPos = 1;
	PortalMenuPos = 2;
    MountMenuPos = 2;
    JobMenuPos = 2;
    WardMenuPos = 2;
    ArcanumButtonxPos = 550;
    ArcanumButtonyPos = 450;
	ArcanumButtonScale = 100;
    ArcanumScale =  100;
	ArcanumAngle = 108;
    
    MenuScale = 100;
    MenuPosition = 100;
	
	ArcanumLanguage = GetLocale();
}

-- Variables utilisés pour la gestion des composants
-- (principalement comptage)
local ArcanumArcanePowder = nil;
local ArcanumArcanePowder2 = nil;
local ArcanumRuneOfTeleportation = nil;
local ArcanumRuneOfPortals = nil;
local ArcanumLightFeathers = nil;
local ReagentBought = false;

local LastItemsCount = nil;
local FoodLocationCount, WaterLocationCount;
local WaterCount = nil;
local WaterLocation = {nil,nil,nil};
local FoodCount = nil;
local FoodLocation = {nil,nil,nil};
local ManaGemCount = nil;
local ManaGemExists = {nil, nil, nil, nil, nil};
local ManaGemLocation = {{nil,nil}, {nil,nil}, {nil,nil}, {nil,nil}};

-- test manne
local ManneLocationCount;
local ManneCount = nil;
local ManneLocation = {nil,nil,nil};
-- test manne fin

local LastArmor;
local LastBuff;
local LastMagic;
local LastMount;
local LastPortal;
local LastWard;

local IceblockDone = false;
local IceblockWait = false;
local IceblockWaitTimer = nil;
local HearthstoneLocation = {nil,nil};
local MountLocation = {nil,nil};
local CompleteMountName = {nil};
local MountName = {nil};
local MountIcon = {nil};
local AQMountLocation = {nil,nil};
local AQMountName = {nil};
local AQMountIcon = {nil};
local MountAQ = nil;

local Combat = false;

local MerchantOpened = false;
local PlayerName, PlayerLevel = nil;
local Loaded = false;
local PlayerZone = nil;
local playerClass, englishClass = nil;

local TPMess = 0;
local RandMount = 0;
Dest = {"Darnassus", "Ironforge", "Stormwind", "Exodar", "Theramore", "Orgrimmar", "Thunder Bluff", "Undercity", "SilverMoon", "Stonard", "Shattrath"};

-- Menus : Permet l'affichage des menus de buff...
local BuffShow = false;
local BuffMenuShow = false;
local ArmorShow = false;
local ArmorMenuShow = false;
local MagicShow = false;
local MagicMenuShow = false;
local PortalShow = false;
local PortalMenuShow = false;
local MountShow = false;
local MountMenuShow = false;
local JobShow = false;
local JobMenuShow = false;
local WardShow = false;
local WardMenuShow = false;

-- Menus : Permet la disparition progressive du menu des buffs (transparence)
local AlphaBuffMenu = 1;
local AlphaBuffVar = 0;
local BuffVisible = false;

-- Menus : Permet la disparition progressive du menu des armures (transparence)
local AlphaArmorMenu = 1;
local AlphaArmorVar = 0;
local ArmorVisible = false;

-- Menus : Permet la disparition progressive du menu des magies (transparence)
local AlphaMagicMenu = 1;
local AlphaMagicVar = 0;
local MagicVisible = false;

-- Menus : Permet la disparition progressive du menu des portails (transparence)
local AlphaPortalMenu = 1;
local AlphaPortalVar = 0;
local PortalVisible = false;

-- Menus : Permet la disparition progressive du menu des montures (transparence)
local AlphaMountMenu = 1;
local AlphaMountVar = 0;
local MountVisible = false;

-- Menus : Permet la disparition progressive du menu des métiers (transparence)
local AlphaJobMenu = 1;
local AlphaJobVar = 0;
local JobVisible = false;

-- Menus : Permet la disparition progressive du menu des Gardien (transparence)
local AlphaWardMenu = 1;
local AlphaWardVar = 0;
local WardVisible = false;

local AlphaDisplay = 1;
local AlphaDisplayVar = 0;
local DisplayFadingLimit = 0;
local DisplayFadingWay = -1;

-- Liste des boutons disponible dans chaque menu
BuffMenuCreate = {};
ArmorMenuCreate = {};
MagicMenuCreate = {};
PortalMenuCreate = {};
MountMenuCreate = {};
WardMenuCreate = {};
JobMenuCreate = {};
JobTable = {};

local xBuffMenuPos = nil;
local xArmorMenuPos = nil;
local xMagicMenuPos = nil;
local xPortalMenuPos = nil;
local xMountMenuPos = nil;
local xJobMenuPos = nil;
local xWardMenuPos = nil;
local yBuffMenuPos = nil;
local yArmorMenuPos = nil;
local yMagicMenuPos = nil;
local yPortalMenuPos = nil;
local yMountMenuPos = nil;
local yJobMenuPos = nil;
local yWardMenuPos = nil;

local UIPath = "Interface\\AddOns\\Arcanum\\UI\\"
        
local ArcanumLeftButtonClick = {};
local ArcanumMiddleButtonClick = {};
local ArcanumRightButtonClick = {};
local ArcanumInsideDisplayClick = {};
local ArcanumBuffMenuClick = {};
local ArcanumArmorMenuClick = {};
local ArcanumMagicMenuClick = {};
local ArcanumPortalMenuClick = {};
local ArcanumMountMenuClick = {};
local ArcanumJobMenuClick = {};
local ArcanumWardMenuClick = {};
local ArcanumConsumeFoodClick = {};
local ArcanumConsumeGemsClick = {};

local Buff_Minlvl = {1, 4, 17, 32, 46};
local Amplify_Minlvl = {18, 30, 42, 54};
local Dampen_Minlvl = {12, 24, 36, 48, 60};
local Water_Minlvl = {0, 5, 15, 25, 35, 45, 55, 60, 65};

local ArcanumTradeNB = 1;
local ArcanumTradeFoodNB = 1;
local ArcanumTradeWaterNB = 1;
local ArcanumTradeNow = false;
local ArcanumTradeOpened = false;
local ArcanumTradeAccept = false;
local ArcanumTradeAcceptT = 0;
local ArcanumTradeAcceptTimer = 1.5;

local IceblockReady = false;
local IceblockCounter = 0;

local SelectedOrderButton;

local ArcanumT = 0;
local ArcanumButtonDisplayT = 1;
local ArcanumButtonDisplayTimer = 10;
local ArcanumButtonDisplayValue = 1;
local ArcanumButtonDisplayImage = nil;
local ArcanumButtonDisplayFlashing = false;
local ArcanumButtonDisplayTexture;

local ArcanumButtonDisplayTexture = {nil, nil, nil, nil, nil, nil, nil, nil};
local CoolDown = {
    {nil, true, HearthstoneLocation[1], HearthstoneLocation[2]},
    {nil, true, ManaGemLocation[1][1], ManaGemLocation[1][2]},
    {nil, true, ARCANUM_SPELL_TABLE.ID[42], nil},
    {nil, true, ARCANUM_SPELL_TABLE.ID[37], nil},
    {nil, true, ARCANUM_SPELL_TABLE.ID[38], nil},
    {nil, true, ARCANUM_SPELL_TABLE.ID[57], nil},
    {nil, true, ARCANUM_SPELL_TABLE.ID[58], nil},
    {nil, true, ARCANUM_SPELL_TABLE.ID[39], nil},
    {nil, true, nil, nil},
    {nil, true, nil, nil},
    };
    
local ArcanumButtonClick;
local ButtonQueuedAttribute;
local Mounted = 0;

------------------------------------------------------------------------------------------------------

-- FONCTIONS DE L'INTERFACE

------------------------------------------------------------------------------------------------------

-- Fonction applique au chargement
function Arcanum_OnLoad()
	playerClass, englishClass = UnitClass("player");
	if englishClass == "MAGE" then
		this:RegisterForDrag("LeftButton");
		this:RegisterForClicks("LeftButtonUp", "MiddleButtonUp", "RightButtonUp");
	
		-- Enregistrement des événements interceptés par ARCANUM
		this:RegisterEvent("PLAYER_ENTERING_WORLD");
        this:RegisterEvent("PLAYER_LEAVING_WORLD");
        this:RegisterEvent("BAG_UPDATE");
		this:RegisterEvent("CHAT_MSG_SPELL_PERIODIC_SELF_BUFFS");
		this:RegisterEvent("CHAT_MSG_SPELL_AURA_GONE_SELF");
		this:RegisterEvent("CHAT_MSG_SPELL_BREAK_AURA");
		this:RegisterEvent("PLAYER_REGEN_DISABLED");
		this:RegisterEvent("PLAYER_REGEN_ENABLED");
        this:RegisterEvent("UNIT_SPELLCAST_FAILED");
        this:RegisterEvent("UNIT_SPELLCAST_INTERRUPTED");
        this:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED");
        this:RegisterEvent("UNIT_SPELLCAST_SENT");
		this:RegisterEvent("LEARNED_SPELL_IN_TAB");
		this:RegisterEvent("CHAT_MSG_SPELL_SELF_DAMAGE");
        this:RegisterEvent("CHAT_MSG_SPELL_PERIODIC_CREATURE_DAMAGE");
        this:RegisterEvent("CHAT_MSG_SPELL_AURA_GONE_OTHER");
		this:RegisterEvent("PLAYER_TARGET_CHANGED");
		this:RegisterEvent("TRADE_REQUEST");
		this:RegisterEvent("TRADE_REQUEST_CANCEL");
		this:RegisterEvent("TRADE_SHOW");
		this:RegisterEvent("TRADE_CLOSED");
        this:RegisterEvent("TRADE_ACCEPT_UPDATE");
        this:RegisterEvent("TRADE_PLAYER_ITEM_CHANGED");
		this:RegisterEvent("MERCHANT_SHOW");
        this:RegisterEvent("MERCHANT_CLOSED");
		this:RegisterEvent("PLAYER_LEVEL_UP");

	
		-- Enregistrement des commandes console
		SlashCmdList["Arcanum"] = Arcanum_Slash;
		SLASH_Arcanum1 = "/arcanum";
		SLASH_Arcanum2 = "/arca";
	end
end

-- Fonction d'initialisation
function Arcanum_Initialize()
	if englishClass == "MAGE" then
		-- On charge (ou on créé) la configuration pour le joueur et on l'affiche sur la console
		if ArcanumConfig == nil or ArcanumConfig.Version ~= Default_ArcanumConfig.Version then
			ArcanumConfig = {};
			ArcanumConfig = Default_ArcanumConfig;
            if (ArcanumConfig.ArcanumLanguage == "enUS") or (ArcanumConfig.ArcanumLanguage == "enGB") then
                Arcanum_Localization_Dialog_En();
            elseif (ArcanumConfig.ArcanumLanguage == "deDE") then
                Arcanum_Localization_Dialog_De();
            else
                Arcanum_Localization_Dialog_Fr();
            end
			Arcanum_Msg(ARCANUM_MESSAGE.Interface.DefaultConfig, "USER");
			ArcanumButton:ClearAllPoints();
		else
            if (ArcanumConfig.ArcanumLanguage == "enUS") or (ArcanumConfig.ArcanumLanguage == "enGB") then
                Arcanum_Localization_Dialog_En();
            elseif (ArcanumConfig.ArcanumLanguage == "deDE") then
                Arcanum_Localization_Dialog_De();
            else
                Arcanum_Localization_Dialog_Fr();
            end
			Arcanum_Msg(ARCANUM_MESSAGE.Interface.UserConfig, "USER");
		end
		
		-- Recupertation du nom du joueur
		PlayerName = UnitName("player");
		PlayerLevel = UnitLevel("player");

        Arcanum_LoadConfig();
		-- Chargement des sorts du joueur
		Arcanum_SpellSetup();
        
        if ARCANUM_SPELL_TABLE.ID[2] == nil then
            ArcanumConfig.LastArmor = 1;
        end
		
        if ArcanumConfig.NoDragAll then
            Arcanum_NoDrag();
            ArcanumButton:RegisterForDrag("");
        else
            Arcanum_Drag();
            ArcanumButton:RegisterForDrag("LeftButton");
        end
        Arcanum_BagExplore();
		--Chargements de l'UI et décompte des composants
		Arcanum_InitButtons();
		if (ArcanumConfig.ArcanumLockServ == false) then
			Arcanum_UpdateMenuPos();
		else
			Arcanum_UpdateButtonsScale();
		end
        Arcanum_ButtonAttribute();
		Arcanum_ButtonSetup();
        Arcanum_LoadIcons();
        ArcanumMinimapButtonTexture:SetTexture(ARCANUM_SPELL_TABLE.Texture[12]);
        ArcanumMinimapButtonTexture2:SetTexture(UIPath.."ButtonCircle");
        ArcanumMinimapButtonTexture2:SetVertexColor(ArcanumConfig.ButtonColor.r, ArcanumConfig.ButtonColor.g, ArcanumConfig.ButtonColor.b);
        
        ArcanumButtonTexture:SetTexture(UIPath.."ArcanumN");
        ArcanumOrderButtonTexture:SetTexture(UIPath.."ArcanumN");
        ArcanumOrderButtonTexture2:SetTexture(UIPath.."Overlay");
        ArcanumButtonTexture3:SetTexture(UIPath.."Overlay");
        
		if ArcanumConfig.Toggle == false then
			Arcanum_HideUI();
			Arcanum_Msg(ARCANUM_MESSAGE.Interface.InitOff, "USER");
		else
			Arcanum_Msg(ARCANUM_MESSAGE.Interface.InitOn, "USER");
		end
	else
        ArcanumConfig = {};
		Arcanum_HideUI();
	end
end

-- Fonction permettant le dplacement d'lments de Arcanum sur l'écran
function Arcanum_OnDragStart(button)
	if (button == "ArcanumIcon") then GameTooltip:Hide(); end

	button:StartMoving();
end

-- Fonction arrêtant le déplacement d'éléments de ARCANUM sur l'écran
function Arcanum_OnDragStop(button)
	if (button == "ArcanumIcon") then Arcanum_BuildTooltip("OVERALL"); end
    button:StopMovingOrSizing();
end

-- Fonction lance  la mise  jour de l'interface (main) -- toutes les 0,1 secondes environ
function Arcanum_OnUpdate()
	--Si c'est la premiere update on initialize
	if Loaded == false then
		Arcanum_Initialize();
		Loaded = true;
	end

	if englishClass == "MAGE" then
        Arcanum_MenuFading();
        Arcanum_DisplayFading();
        ArcanumT =  ArcanumT + arg1;
        if ArcanumT >= ArcanumButtonDisplayT then
            ArcanumButtonDisplayT = ArcanumButtonDisplayT + 0.5;
            Arcanum_Cooldown();
            ArcanumButton_TextDisplay();
        end
        
        if ArcanumT >= ArcanumButtonDisplayTimer then
            ArcanumButton_ImageDisplay();
            ArcanumT = 0;
            ArcanumButtonDisplayT = 1;
        end
        
        if ArcanumTradeAccept == true then
            ArcanumTradeAcceptT = ArcanumTradeAcceptT + arg1
            if ArcanumTradeAcceptT > ArcanumTradeAcceptTimer then
                ArcanumTradeAccept = false
--~                 AcceptTrade();
            end
        end
        
        if IceblockDone == true then
            IceblockCounter = IceblockCounter + arg1;
            if IceblockCounter >= 3 then
                IceblockReady = true;
                IceblockCounter = 0;
            end
        end
        
		-- On met  jour la localisation du joueur
		PlayerZone = GetRealZoneText();
	end
end

function Arcanum_OnEvent(event)
	if (not Loaded) or englishClass ~= "MAGE" then 
		return;
	end
    if (event == "PLAYER_ENTERING_WORLD") then
        this:RegisterEvent("BAG_UPDATE");
		this:RegisterEvent("CHAT_MSG_SPELL_PERIODIC_SELF_BUFFS");
		this:RegisterEvent("CHAT_MSG_SPELL_AURA_GONE_SELF");
		this:RegisterEvent("CHAT_MSG_SPELL_BREAK_AURA");
		this:RegisterEvent("PLAYER_REGEN_DISABLED");
		this:RegisterEvent("PLAYER_REGEN_ENABLED");
        this:RegisterEvent("UNIT_SPELLCAST_FAILED");
        this:RegisterEvent("UNIT_SPELLCAST_INTERRUPTED");
        this:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED");
        this:RegisterEvent("UNIT_SPELLCAST_SENT");
		this:RegisterEvent("LEARNED_SPELL_IN_TAB");
		this:RegisterEvent("CHAT_MSG_SPELL_SELF_DAMAGE");
        this:RegisterEvent("CHAT_MSG_SPELL_PERIODIC_CREATURE_DAMAGE");
        this:RegisterEvent("CHAT_MSG_SPELL_AURA_GONE_OTHER");
		this:RegisterEvent("PLAYER_TARGET_CHANGED");
		this:RegisterEvent("TRADE_REQUEST");
		this:RegisterEvent("TRADE_REQUEST_CANCEL");
		this:RegisterEvent("TRADE_SHOW");
		this:RegisterEvent("TRADE_CLOSED");
        this:RegisterEvent("TRADE_ACCEPT_UPDATE");
        this:RegisterEvent("TRADE_PLAYER_ITEM_CHANGED");
		this:RegisterEvent("MERCHANT_SHOW");
        this:RegisterEvent("MERCHANT_CLOSED");
		this:RegisterEvent("PLAYER_LEVEL_UP");

    elseif (event == "PLAYER_LEAVING_WORLD") then
        this:UnregisterEvent("BAG_UPDATE");
		this:UnregisterEvent("CHAT_MSG_SPELL_PERIODIC_SELF_BUFFS");
		this:UnregisterEvent("CHAT_MSG_SPELL_AURA_GONE_SELF");
		this:UnregisterEvent("CHAT_MSG_SPELL_BREAK_AURA");
		this:UnregisterEvent("PLAYER_REGEN_DISABLED");
		this:UnregisterEvent("PLAYER_REGEN_ENABLED");
        this:UnregisterEvent("UNIT_SPELLCAST_FAILED");
        this:UnregisterEvent("UNIT_SPELLCAST_INTERRUPTED");
        this:UnregisterEvent("UNIT_SPELLCAST_SUCCEEDED");
        this:UnregisterEvent("UNIT_SPELLCAST_SENT");
		this:UnregisterEvent("LEARNED_SPELL_IN_TAB");
		this:UnregisterEvent("CHAT_MSG_SPELL_SELF_DAMAGE");
        this:UnregisterEvent("CHAT_MSG_SPELL_PERIODIC_CREATURE_DAMAGE");
        this:UnregisterEvent("CHAT_MSG_SPELL_AURA_GONE_OTHER");
		this:UnregisterEvent("PLAYER_TARGET_CHANGED");
		this:UnregisterEvent("TRADE_REQUEST");
		this:UnregisterEvent("TRADE_REQUEST_CANCEL");
		this:UnregisterEvent("TRADE_SHOW");
		this:UnregisterEvent("TRADE_CLOSED");
        this:UnregisterEvent("TRADE_ACCEPT_UPDATE");
        this:UnregisterEvent("TRADE_PLAYER_ITEM_CHANGED");
		this:UnregisterEvent("MERCHANT_SHOW");
        this:UnregisterEvent("MERCHANT_CLOSED");
		this:UnregisterEvent("PLAYER_LEVEL_UP");
    
  -- Changement de couleur suivant le mode Combat
    elseif (event == "PLAYER_REGEN_DISABLED") then
        Arcanum_CombatDisableIcons();
    elseif (event == "PLAYER_REGEN_ENABLED") then
        Arcanum_CombatEnableIcons();
    -- Si un nouveau sort est apris, on rafraichie le tableau des sorts
    elseif (event == "LEARNED_SPELL_IN_TAB") then
        Arcanum_SpellSetup();
        Arcanum_ButtonAttribute();
        Arcanum_ButtonSetup();
        Arcanum_CreateMenu();
        Arcanum_LoadIcons();
	elseif (event == "UNIT_SPELLCAST_SUCCEEDED") then
		SpellCastUnit, SpellCastName = arg1, arg2
        Arcanum_SpellManagement2();
	elseif (event == "UNIT_SPELLCAST_SENT") then
		_, SpellCastName, SpellCastRank, _ = arg1, arg2, arg3, arg4;
		SpellTargetName = UnitName("target");
		if not SpellTargetName then
			SpellTargetName = "";
		end
		SpellTargetLevel = UnitLevel("target");
		if not SpellTargetLevel then
			SpellTargetLevel = "";
		end
        Arcanum_SpellManagement();
	elseif (event == "UNIT_SPELLCAST_FAILED") or (event == "UNIT_SPELLCAST_INTERRUPTED") then
		if arg1 == "player" then
			SpellCastName = nil;
			SpellCastRank = nil;
			SpellTargetName = nil;
			SpellTargetLevel = nil;
		end
    elseif event == "CHAT_MSG_SPELL_PERIODIC_CREATURE_DAMAGE" then
        
    elseif event == "CHAT_MSG_SPELL_AURA_GONE_OTHER" then

    elseif event == "TRADE_REQUEST" or event == "TRADE_SHOW" then
        if ArcanumTradeNow == true then
            Arcanum_Trade();
            ArcanumTradeOpened = true;
            ArcanumTradeAcceptT = 0;
            ArcanumtTradeAccept = true;
            ArcanumTradeNow = false;
        end
    elseif event == "TRADE_REQUEST_CANCEL" or event == "TRADE_CLOSED" then
        ArcanumTradeNB = 1;
        ArcanumTradeFoodNB = 1;
        ArcanumTradeWaterNB = 1;
        ArcanumTradeOpened = false;
    elseif event=="TRADE_ACCEPT_UPDATE" then
    elseif event=="TRADE_PLAYER_ITEM_CHANGED" then
        ArcanumTradeNB = ArcanumTradeNB + 1;
    elseif (event == "BAG_UPDATE") then
        if arg1 ~= nil then
            Arcanum_BagExplore();
            Arcanum_CreateMenu();
            Arcanum_LoadIconsV();
            Arcanum_EDIcons();
            Arcanum_UpdateManaGem();
            if (ArcanumConfig.Powder > ArcanumArcanePowder or ArcanumConfig.Teleport > ArcanumRuneOfTeleportation or ArcanumConfig.Portal > ArcanumRuneOfPortals) then
                ReagentBought = false;
            end
        end
    elseif (event == "MERCHANT_SHOW") then
        MerchantOpened = true;
        if ArcanumConfig.ReagentBuy == true then
            if ReagentBought == false then
                Arcanum_AutoBuy();
            end
        end
    elseif (event == "MERCHANT_CLOSED") then
        MerchantOpened = false;
    elseif (event == "PLAYER_LEVEL_UP") then
        PlayerLevel = UnitLevel("player");
    end
end

-- Gestion du clic sur Arcanum
-- Clique gauche: Passe Arcanum en mode buff Individuel/Classe
-- Clique droit: Pierre de Foyer

function Arcanum_OnClick(button)
    if (button == "LeftButton") then
	    Arcanum_Click(ArcanumConfig.LeftClick);
    elseif (button == "MiddleButton") then
        Arcanum_Click(ArcanumConfig.MiddleClick);
    elseif (button == "RightButton") then
        Arcanum_Click(ArcanumConfig.RightClick);
    end
end

-- Création et Affichage des bulles d'aides
function Arcanum_BuildTooltip(button, anchor, type)
	--on verifie que les aides sont activés
	if (ArcanumConfig.Tooltip == 1) then
		-- Definie à qui apartient la bulle d'aide
		GameTooltip:SetOwner(button, anchor);
		if (type == "Mount") then
            if MountName[ArcanumConfig.LastMount] ~= nil then
                GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TRANSLATION.Mounting.." "..MountName[ArcanumConfig.LastMount].."\n"..ARCANUM_MESSAGE.Tooltip.MiddleClick..ARCANUM_TRANSLATION.Hearth));
             else
                GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_MESSAGE.Tooltip.MiddleClick..ARCANUM_TRANSLATION.Hearth));
             end
            if (CoolDown[1][1] ~= nil) then
				GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_MESSAGE.Tooltip.Cooldown..CoolDown[1][1]));
			end
        elseif (type == "Mount1") then
            if ArcanumConfig.LastMount ==1 then
                GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TRANSLATION.Mounting.." "..MountName[1]));
            else
                GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TRANSLATION.Mounting.." "..MountName[1]));
            end
        elseif (type == "Mount2") then
            if ArcanumConfig.LastMount == 2 then
                GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TRANSLATION.Mounting.." "..MountName[2]));
            else
                GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TRANSLATION.Mounting.." "..MountName[2]));
            end
        elseif (type == "Mount3") then
            if ArcanumConfig.LastMount == 3 then
                GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TRANSLATION.Mounting.." "..MountName[3]));
            else
                GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TRANSLATION.Mounting.." "..MountName[3]));
            end
        elseif (type == "Mount4") then
            if ArcanumConfig.LastMount == 4 then
                GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TRANSLATION.Mounting.." "..MountName[4]));
            else
                GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TRANSLATION.Mounting.." "..MountName[4]));
            end
        elseif (type == "Mount5") then
            if ArcanumConfig.LastMount == 5 then
                GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TRANSLATION.Mounting.." "..MountName[5]));
            else
                GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TRANSLATION.Mounting.." "..MountName[5]));
            end
        elseif (type == "Mount6") then
            if ArcanumConfig.LastMount == 6 then
                GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TRANSLATION.Mounting.." "..MountName[6]));
            else
                GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TRANSLATION.Mounting.." "..MountName[6]));
            end
        elseif (type == "Mount7") then
            if ArcanumConfig.LastMount == 7 then
                GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TRANSLATION.Mounting.." "..MountName[7]));
            else
                GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TRANSLATION.Mounting.." "..MountName[7]));
            end
        elseif (type == "Mount8") then
            if ArcanumConfig.LastMount == 8 then
                GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TRANSLATION.Mounting.." "..MountName[8]));
            else
                GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TRANSLATION.Mounting.." "..MountName[9]));
            end
        elseif (type == "Mount9") then
            if ArcanumConfig.LastMount == 9 then
                GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TRANSLATION.Mounting.." "..MountName[9]));
            else
                GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TRANSLATION.Mounting.." "..MountName[9]));
            end
        elseif (type == "Mount10") then
            if ArcanumConfig.LastMount == 10 then
                GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TRANSLATION.Mounting.." "..MountName[10]));
            else
                GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TRANSLATION.Mounting.." "..MountName[10]));
            end
        elseif (type == "Buff") and ArcanumConfig.LastBuff ~= 0 then
			GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TOOLTIP_DATA.LastSpell.."\n"..ARCANUM_SPELL_TABLE.Name[ArcanumConfig.LastBuff].."\nMana : "..ARCANUM_SPELL_TABLE.Mana[ArcanumConfig.LastBuff]));
            if ArcanumConfig.LastBuff == 12 then
                if ARCANUM_SPELL_TABLE.ID[13] ~= nil then
                    GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TOOLTIP_DATA.LastSpell2.."\n"..ARCANUM_SPELL_TABLE.Name[13].."\nMana : "..ARCANUM_SPELL_TABLE.Mana[13]));
                end
            else
                GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TOOLTIP_DATA.LastSpell2.."\n"..ARCANUM_SPELL_TABLE.Name[12].."\nMana : "..ARCANUM_SPELL_TABLE.Mana[12]));
            end
		elseif (type == "ArcaneIntellect") then
			GameTooltip:AddLine(Arcanum_ColoredMsg("Mana : "..ARCANUM_SPELL_TABLE.Mana[12]));
		elseif (type == "ArcaneBrilliance") then
			GameTooltip:AddLine(Arcanum_ColoredMsg("Mana : "..ARCANUM_SPELL_TABLE.Mana[13]));
		elseif (type == "Magic") and ArcanumConfig.LastMagic ~= 0 then
			GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TOOLTIP_DATA.LastSpell.."\n"..ARCANUM_SPELL_TABLE.Name[ArcanumConfig.LastMagic].."\nMana : "..ARCANUM_SPELL_TABLE.Mana[ArcanumConfig.LastMagic]));
            if ArcanumConfig.LastMagic == 6 then
                if ARCANUM_SPELL_TABLE.ID[7] ~= nil then
                    GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TOOLTIP_DATA.LastSpell2.."\n"..ARCANUM_SPELL_TABLE.Name[7].."\nMana : "..ARCANUM_SPELL_TABLE.Mana[7]));
                end
            else
                GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TOOLTIP_DATA.LastSpell2.."\n"..ARCANUM_SPELL_TABLE.Name[6].."\nMana : "..ARCANUM_SPELL_TABLE.Mana[6]));
            end
		elseif (type == "AmplifyMagic") then
			GameTooltip:AddLine(Arcanum_ColoredMsg("Mana : "..ARCANUM_SPELL_TABLE.Mana[7]));
		elseif (type == "DampenMagic") then
			GameTooltip:AddLine(Arcanum_ColoredMsg("Mana : "..ARCANUM_SPELL_TABLE.Mana[6]));
		elseif (type == "Armor") and ArcanumConfig.LastArmor ~= 0 then
			GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TOOLTIP_DATA.LastSpell.."\n"..ARCANUM_SPELL_TABLE.Name[ArcanumConfig.LastArmor].."\nMana : "..ARCANUM_SPELL_TABLE.Mana[ArcanumConfig.LastArmor]));
            if ArcanumConfig.LastArmor == 2 then
                if ARCANUM_SPELL_TABLE.ID[3] ~= nil then
                    GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TOOLTIP_DATA.LastSpell2.."\n"..ARCANUM_SPELL_TABLE.Name[3].."\nMana : "..ARCANUM_SPELL_TABLE.Mana[3]));
                end
            elseif ArcanumConfig.LastArmor == 3 then
                GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TOOLTIP_DATA.LastSpell2.."\n"..ARCANUM_SPELL_TABLE.Name[2].."\nMana : "..ARCANUM_SPELL_TABLE.Mana[2]));
            elseif ArcanumConfig.LastArmor == 4 then
                GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TOOLTIP_DATA.LastSpell2.."\n"..ARCANUM_SPELL_TABLE.Name[3].."\nMana : "..ARCANUM_SPELL_TABLE.Mana[3]));
            end
		elseif (type == "FrostArmor") then
			if (ARCANUM_SPELL_TABLE.ID[2] ~= nil) then
				GameTooltip:AddLine(Arcanum_ColoredMsg("Mana : "..ARCANUM_SPELL_TABLE.Mana[2]));
			elseif (ARCANUM_SPELL_TABLE.ID[1] ~= nil) then
				GameTooltip:AddLine(Arcanum_ColoredMsg("Mana : "..ARCANUM_SPELL_TABLE.Mana[1]));
			end
		elseif (type == "MageArmor") then
			GameTooltip:AddLine(Arcanum_ColoredMsg("Mana : "..ARCANUM_SPELL_TABLE.Mana[3]));
        elseif (type == "FireArmor") then
			GameTooltip:AddLine(Arcanum_ColoredMsg("Mana : "..ARCANUM_SPELL_TABLE.Mana[4]));
		elseif (type == "Food") then
			GameTooltip:AddLine(Arcanum_ColoredMsg("Mana : "..ARCANUM_SPELL_TABLE.Mana[8]));
		elseif (type == "Water") then
			GameTooltip:AddLine(Arcanum_ColoredMsg("Mana : "..ARCANUM_SPELL_TABLE.Mana[9]));
		elseif (type == "ManaGem") then
			if (ARCANUM_SPELL_TABLE.ID[53] ~= nil and ManaGemExists[1] == false) then
				GameTooltip:AddLine(Arcanum_ColoredMsg("Mana : "..ARCANUM_SPELL_TABLE.Mana[53]));
			elseif (ARCANUM_SPELL_TABLE.ID[52] ~= nil and ManaGemExists[2] == false) then
				GameTooltip:AddLine(Arcanum_ColoredMsg("Mana : "..ARCANUM_SPELL_TABLE.Mana[52]));
			elseif (ARCANUM_SPELL_TABLE.ID[51] ~= nil and ManaGemExists[3] == false) then
				GameTooltip:AddLine(Arcanum_ColoredMsg("Mana : "..ARCANUM_SPELL_TABLE.Mana[51]));
			elseif (ARCANUM_SPELL_TABLE.ID[50] ~= nil and ManaGemExists[4] == false) then
				GameTooltip:AddLine(Arcanum_ColoredMsg("Mana : "..ARCANUM_SPELL_TABLE.Mana[50]));
			elseif (ARCANUM_SPELL_TABLE.ID[49] ~= nil and ManaGemExists[5] == false) then
				GameTooltip:AddLine(Arcanum_ColoredMsg("Mana : "..ARCANUM_SPELL_TABLE.Mana[49]));
			end
		elseif (type == "Portal") and ArcanumConfig.LastPortal ~= 0 then
			GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TOOLTIP_DATA.LastSpell.."\n"..ARCANUM_SPELL_TABLE.Name[ArcanumConfig.LastPortal].."\nMana : "..ARCANUM_SPELL_TABLE.Mana[ArcanumConfig.LastPortal]));
		elseif (type == "Teleport1") then
			if (ARCANUM_SPELL_TABLE.ID[15] ~= nil) then
				GameTooltip:AddLine(Arcanum_ColoredMsg("Mana : "..ARCANUM_SPELL_TABLE.Mana[15]));
			elseif (ARCANUM_SPELL_TABLE.ID[19] ~= nil) then
				GameTooltip:AddLine(Arcanum_ColoredMsg("Mana : "..ARCANUM_SPELL_TABLE.Mana[19]));
			end
		elseif (type == "Teleport2") then
			if (ARCANUM_SPELL_TABLE.ID[16] ~= nil) then
				GameTooltip:AddLine(Arcanum_ColoredMsg("Mana : "..ARCANUM_SPELL_TABLE.Mana[16]));
			elseif (ARCANUM_SPELL_TABLE.ID[20] ~= nil) then
				GameTooltip:AddLine(Arcanum_ColoredMsg("Mana : "..ARCANUM_SPELL_TABLE.Mana[20]));
			end   
		elseif (type == "Teleport3") then
			if (ARCANUM_SPELL_TABLE.ID[17] ~= nil) then
				GameTooltip:AddLine(Arcanum_ColoredMsg("Mana : "..ARCANUM_SPELL_TABLE.Mana[17]));
			elseif (ARCANUM_SPELL_TABLE.ID[21] ~= nil) then
				GameTooltip:AddLine(Arcanum_ColoredMsg("Mana : "..ARCANUM_SPELL_TABLE.Mana[21]));
			end
        elseif (type == "Teleport4") then
			if (ARCANUM_SPELL_TABLE.ID[18] ~= nil) then
				GameTooltip:AddLine(Arcanum_ColoredMsg("Mana : "..ARCANUM_SPELL_TABLE.Mana[18]));
			elseif (ARCANUM_SPELL_TABLE.ID[22] ~= nil) then
				GameTooltip:AddLine(Arcanum_ColoredMsg("Mana : "..ARCANUM_SPELL_TABLE.Mana[22]));
			end
		elseif (type == "Teleport5") then
			if (ARCANUM_SPELL_TABLE.ID[45] ~= nil) then
				GameTooltip:AddLine(Arcanum_ColoredMsg("Mana : "..ARCANUM_SPELL_TABLE.Mana[45]));
			elseif (ARCANUM_SPELL_TABLE.ID[47] ~= nil) then
				GameTooltip:AddLine(Arcanum_ColoredMsg("Mana : "..ARCANUM_SPELL_TABLE.Mana[47]));
			end		
        elseif (type == "Teleport6") then
			if (ARCANUM_SPELL_TABLE.ID[40] ~= nil) then
				GameTooltip:AddLine(Arcanum_ColoredMsg("Mana : "..ARCANUM_SPELL_TABLE.Mana[40]));
		end
 		elseif (type == "Portal1") then
			if (ARCANUM_SPELL_TABLE.ID[23] ~= nil) then
				GameTooltip:AddLine(Arcanum_ColoredMsg("Mana : "..ARCANUM_SPELL_TABLE.Mana[23]));
			elseif (ARCANUM_SPELL_TABLE.ID[27] ~= nil) then
				GameTooltip:AddLine(Arcanum_ColoredMsg("Mana : "..ARCANUM_SPELL_TABLE.Mana[27]));
			end
		elseif (type == "Portal2") then
			if (ARCANUM_SPELL_TABLE.ID[24] ~= nil) then
				GameTooltip:AddLine(Arcanum_ColoredMsg("Mana : "..ARCANUM_SPELL_TABLE.Mana[24]));
			elseif (ARCANUM_SPELL_TABLE.ID[28] ~= nil) then
				GameTooltip:AddLine(Arcanum_ColoredMsg("Mana : "..ARCANUM_SPELL_TABLE.Mana[28]));
			end
		elseif (type == "Portal3") then
			if (ARCANUM_SPELL_TABLE.ID[25] ~= nil) then
				GameTooltip:AddLine(Arcanum_ColoredMsg("Mana : "..ARCANUM_SPELL_TABLE.Mana[25]));
			elseif (ARCANUM_SPELL_TABLE.ID[29] ~= nil) then
				GameTooltip:AddLine(Arcanum_ColoredMsg("Mana : "..ARCANUM_SPELL_TABLE.Mana[29]));
			end
    elseif (type == "Portal4") then
			if (ARCANUM_SPELL_TABLE.ID[26] ~= nil) then
				GameTooltip:AddLine(Arcanum_ColoredMsg("Mana : "..ARCANUM_SPELL_TABLE.Mana[26]));
			elseif (ARCANUM_SPELL_TABLE.ID[30] ~= nil) then
				GameTooltip:AddLine(Arcanum_ColoredMsg("Mana : "..ARCANUM_SPELL_TABLE.Mana[30]));
			end
	elseif (type == "Portal5") then
			if (ARCANUM_SPELL_TABLE.ID[44] ~= nil) then
				GameTooltip:AddLine(Arcanum_ColoredMsg("Mana : "..ARCANUM_SPELL_TABLE.Mana[44]));
		        elseif (ARCANUM_SPELL_TABLE.ID[46] ~= nil) then
				GameTooltip:AddLine(Arcanum_ColoredMsg("Mana : "..ARCANUM_SPELL_TABLE.Mana[46]));
			end		
    elseif (type == "Portal6") then
			if (ARCANUM_SPELL_TABLE.ID[41] ~= nil) then
				GameTooltip:AddLine(Arcanum_ColoredMsg("Mana : "..ARCANUM_SPELL_TABLE.Mana[41]));
			end
	elseif (type == "Portal7") then
			if (ARCANUM_SPELL_TABLE.ID[43] ~= nil) then
				GameTooltip:AddLine(Arcanum_ColoredMsg("Mana : "..ARCANUM_SPELL_TABLE.Mana[43]));
			end		
    elseif (type == "Ward") and ArcanumConfig.LastWard ~= 0 then
			GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TOOLTIP_DATA.LastSpell.."\n"..ARCANUM_SPELL_TABLE.Name[ArcanumConfig.LastWard].."\nMana : "..ARCANUM_SPELL_TABLE.Mana[ArcanumConfig.LastWard]));
            if ArcanumConfig.LastWard == 57 then
                if ARCANUM_SPELL_TABLE.ID[58] ~= nil then
                    GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TOOLTIP_DATA.LastSpell2.."\n"..ARCANUM_SPELL_TABLE.Name[58].."\nMana : "..ARCANUM_SPELL_TABLE.Mana[58]));
                end
            else
                GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TOOLTIP_DATA.LastSpell2.."\n"..ARCANUM_SPELL_TABLE.Name[57].."\nMana : "..ARCANUM_SPELL_TABLE.Mana[57]));
            end
        elseif (type == "Ward1") then
            GameTooltip:AddLine(Arcanum_ColoredMsg("Mana : "..ARCANUM_SPELL_TABLE.Mana[57]));
        elseif (type == "Ward2") then
            GameTooltip:AddLine(Arcanum_ColoredMsg("Mana : "..ARCANUM_SPELL_TABLE.Mana[58]));    
			-- Soit c'est le bouton principal
		elseif (type == "Main") then
			GameTooltip:AddLine(Arcanum_MsgAddColor("<white>"..ArcanumArcanePowder).." "..Arcanum_ColoredMsg(ARCANUM_ITEM.ArcanePowder));
			GameTooltip:AddLine(Arcanum_MsgAddColor("<white>"..ArcanumRuneOfTeleportation).." "..Arcanum_ColoredMsg(ARCANUM_ITEM.RuneOfTeleportation));
			GameTooltip:AddLine(Arcanum_MsgAddColor("<white>"..ArcanumRuneOfPortals).." "..Arcanum_ColoredMsg(ARCANUM_ITEM.RuneOfPortals));
			GameTooltip:AddLine(Arcanum_MsgAddColor("<white>"..ArcanumLightFeathers).." "..Arcanum_ColoredMsg(ARCANUM_ITEM.LightFeathers));
			GameTooltip:AddLine(" ");
			GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_MESSAGE.Tooltip.LeftClick..ARCANUM_CLICK[ArcanumConfig.LeftClick]));
            GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_MESSAGE.Tooltip.MiddleClick..ARCANUM_CLICK[ArcanumConfig.MiddleClick]));
			GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_MESSAGE.Tooltip.RightClick..ARCANUM_CLICK[ArcanumConfig.RightClick]));
        elseif (type == "Minimap") then
            GameTooltip:AddLine(Arcanum_ColoredMsg("Arcanum").."|CFFFFFFFF: ".."\n"..ARCANUM_MESSAGE.Tooltip.Minimap);
        end
		-- On affiche
		GameTooltip:Show();
	
	elseif (ArcanumConfig.Tooltip == 2) then
		-- Definie  qui apartient la bulle d'aide
		GameTooltip:SetOwner(button, anchor);
		if (type == "Mount") then
			if MountName[ArcanumConfig.LastMount] ~= nil then
                GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TRANSLATION.Mounting.." "..MountName[ArcanumConfig.LastMount].."\n"..ARCANUM_MESSAGE.Tooltip.MiddleClick..ARCANUM_TRANSLATION.Hearth));
             else
                GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_MESSAGE.Tooltip.MiddleClick..ARCANUM_TRANSLATION.Hearth));
             end
            if (CoolDown[1][1] ~= nil) then
				GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_MESSAGE.Tooltip.Cooldown..CoolDown[1][1]));
			end
        elseif (type == "Mount1") then
			GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TRANSLATION.Mounting.." "..MountName[1]));
        elseif (type == "Mount2") then
			GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TRANSLATION.Mounting.." "..MountName[2]));
        elseif (type == "Mount3") then
			GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TRANSLATION.Mounting.." "..MountName[3]));
        elseif (type == "Mount4") then
			GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TRANSLATION.Mounting.." "..MountName[4]));
        elseif (type == "Mount5") then
			GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TRANSLATION.Mounting.." "..MountName[5]));
        elseif (type == "Mount6") then
			GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TRANSLATION.Mounting.." "..MountName[6]));
        elseif (type == "Mount7") then
			GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TRANSLATION.Mounting.." "..MountName[7]));
        elseif (type == "Mount8") then
			GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TRANSLATION.Mounting.." "..MountName[8]));
        elseif (type == "Mount9") then
			GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TRANSLATION.Mounting.." "..MountName[9]));
        elseif (type == "Mount10") then
			GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TRANSLATION.Mounting.." "..MountName[10]));
        elseif (type == "Buff") and ArcanumConfig.LastBuff ~= 0 then
			GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TOOLTIP_DATA.LastSpell.."\n"..ARCANUM_SPELL_TABLE.Name[ArcanumConfig.LastBuff].."\nMana : "..ARCANUM_SPELL_TABLE.Mana[ArcanumConfig.LastBuff]));
            if ArcanumConfig.LastBuff == 12 then
                if ARCANUM_SPELL_TABLE.ID[13] ~= nil then
                    GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TOOLTIP_DATA.LastSpell2.."\n"..ARCANUM_SPELL_TABLE.Name[13].."\nMana : "..ARCANUM_SPELL_TABLE.Mana[13]));
                end
            else
                GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TOOLTIP_DATA.LastSpell2.."\n"..ARCANUM_SPELL_TABLE.Name[12].."\nMana : "..ARCANUM_SPELL_TABLE.Mana[12]));
            end
        elseif (type == "ArcaneIntellect") then
			GameTooltip:SetSpell(ARCANUM_SPELL_TABLE.ID[12],1);
		elseif (type == "ArcaneBrilliance") then
			GameTooltip:SetSpell(ARCANUM_SPELL_TABLE.ID[13],1);
		elseif (type == "Magic") and ArcanumConfig.LastMagic ~= 0 then
			GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TOOLTIP_DATA.LastSpell.."\n"..ARCANUM_SPELL_TABLE.Name[ArcanumConfig.LastMagic].."\nMana : "..ARCANUM_SPELL_TABLE.Mana[ArcanumConfig.LastMagic]));
            if ArcanumConfig.LastMagic == 6 then
                if ARCANUM_SPELL_TABLE.ID[7] ~= nil then
                    GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TOOLTIP_DATA.LastSpell2.."\n"..ARCANUM_SPELL_TABLE.Name[7].."\nMana : "..ARCANUM_SPELL_TABLE.Mana[7]));
                end
            else
                GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TOOLTIP_DATA.LastSpell2.."\n"..ARCANUM_SPELL_TABLE.Name[6].."\nMana : "..ARCANUM_SPELL_TABLE.Mana[6]));
            end
        elseif (type == "AmplifyMagic") then
			GameTooltip:SetSpell(ARCANUM_SPELL_TABLE.ID[7],1);
		elseif (type == "DampenMagic") then
			GameTooltip:SetSpell(ARCANUM_SPELL_TABLE.ID[6],1);
		elseif (type == "Armor") and ArcanumConfig.LastArmor ~= 0 then
			GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TOOLTIP_DATA.LastSpell.."\n"..ARCANUM_SPELL_TABLE.Name[ArcanumConfig.LastArmor].."\nMana : "..ARCANUM_SPELL_TABLE.Mana[ArcanumConfig.LastArmor]));
            if ArcanumConfig.LastArmor == 2 then
                if ARCANUM_SPELL_TABLE.ID[3] ~= nil then
                    GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TOOLTIP_DATA.LastSpell2.."\n"..ARCANUM_SPELL_TABLE.Name[3].."\nMana : "..ARCANUM_SPELL_TABLE.Mana[3]));
                end
            elseif ArcanumConfig.LastArmor == 3 then
                GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TOOLTIP_DATA.LastSpell2.."\n"..ARCANUM_SPELL_TABLE.Name[2].."\nMana : "..ARCANUM_SPELL_TABLE.Mana[2]));
            end
        elseif (type == "FrostArmor") then
			if (ARCANUM_SPELL_TABLE.Mana[2] ~= nil) then
				GameTooltip:SetSpell(ARCANUM_SPELL_TABLE.ID[2],1);
			elseif (ARCANUM_SPELL_TABLE.Mana[1] ~= nil) then
				GameTooltip:SetSpell(ARCANUM_SPELL_TABLE.ID[1],1);
			end
		elseif (type == "MageArmor") then
			GameTooltip:SetSpell(ARCANUM_SPELL_TABLE.ID[3],1);
		elseif (type == "FireArmor") then
			GameTooltip:SetSpell(ARCANUM_SPELL_TABLE.ID[4],1);
		elseif (type == "Food") then
			GameTooltip:SetSpell(ARCANUM_SPELL_TABLE.ID[8],1);
		elseif (type == "Water") then
			GameTooltip:SetSpell(ARCANUM_SPELL_TABLE.ID[9],1);
		elseif (type == "ManaGem") then
			if (ARCANUM_SPELL_TABLE.ID[53] ~= nil and ManaGemExists[1] == false) then
				GameTooltip:SetSpell(ARCANUM_SPELL_TABLE.ID[53],1);
			elseif (ARCANUM_SPELL_TABLE.ID[52] ~= nil and ManaGemExists[2] == false) then
				GameTooltip:SetSpell(ARCANUM_SPELL_TABLE.ID[52],1);
			elseif (ARCANUM_SPELL_TABLE.ID[51] ~= nil and ManaGemExists[3] == false) then
				GameTooltip:SetSpell(ARCANUM_SPELL_TABLE.ID[51],1);
			elseif (ARCANUM_SPELL_TABLE.ID[50] ~= nil and ManaGemExists[4] == false) then
				GameTooltip:SetSpell(ARCANUM_SPELL_TABLE.ID[50],1);
            elseif (ARCANUM_SPELL_TABLE.ID[49] ~= nil and ManaGemExists[5] == false) then
				GameTooltip:SetSpell(ARCANUM_SPELL_TABLE.ID[49],1);
			end
		elseif (type == "Portal") and ArcanumConfig.LastPortal ~= 0 then
			GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TOOLTIP_DATA.LastSpell.."\n"..ARCANUM_SPELL_TABLE.Name[ArcanumConfig.LastPortal].."\nMana : "..ARCANUM_SPELL_TABLE.Mana[ArcanumConfig.LastPortal]));
		elseif (type == "Teleport1") then
			if (ARCANUM_SPELL_TABLE.ID[15] ~= nil) then
				GameTooltip:SetSpell(ARCANUM_SPELL_TABLE.ID[15],1);
			elseif (ARCANUM_SPELL_TABLE.ID[19] ~= nil) then
				GameTooltip:SetSpell(ARCANUM_SPELL_TABLE.ID[19],1);
			end
		elseif (type == "Teleport2") then
			if (ARCANUM_SPELL_TABLE.ID[16] ~= nil) then
				GameTooltip:SetSpell(ARCANUM_SPELL_TABLE.ID[16],1);
			elseif (ARCANUM_SPELL_TABLE.ID[20] ~= nil) then
				GameTooltip:SetSpell(ARCANUM_SPELL_TABLE.ID[20],1);
			end   
		elseif (type == "Teleport3") then
			if (ARCANUM_SPELL_TABLE.ID[17] ~= nil) then
				GameTooltip:SetSpell(ARCANUM_SPELL_TABLE.ID[17],1);
			elseif (ARCANUM_SPELL_TABLE.ID[21] ~= nil) then
				GameTooltip:SetSpell(ARCANUM_SPELL_TABLE.ID[21],1);
			end
        elseif (type == "Teleport4") then
			if (ARCANUM_SPELL_TABLE.ID[18] ~= nil) then
				GameTooltip:SetSpell(ARCANUM_SPELL_TABLE.ID[18],1);
			elseif (ARCANUM_SPELL_TABLE.ID[22] ~= nil) then
				GameTooltip:SetSpell(ARCANUM_SPELL_TABLE.ID[22],1);
			end
		elseif (type == "Teleport5") then
			if (ARCANUM_SPELL_TABLE.ID[45] ~= nil) then
				GameTooltip:SetSpell(ARCANUM_SPELL_TABLE.ID[45],1);
				elseif (ARCANUM_SPELL_TABLE.ID[47] ~= nil) then
				GameTooltip:SetSpell(ARCANUM_SPELL_TABLE.ID[47],1);
			end	
		elseif (type == "Teleport6") then
			if (ARCANUM_SPELL_TABLE.ID[40] ~= nil) then
				GameTooltip:SetSpell(ARCANUM_SPELL_TABLE.ID[40],1);
			end
   		elseif (type == "Portal1") then
			if (ARCANUM_SPELL_TABLE.ID[23] ~= nil) then
				GameTooltip:SetSpell(ARCANUM_SPELL_TABLE.ID[23],1);
			elseif (ARCANUM_SPELL_TABLE.ID[27] ~= nil) then
				GameTooltip:SetSpell(ARCANUM_SPELL_TABLE.ID[27],1);
			end
		elseif (type == "Portal2") then
			if (ARCANUM_SPELL_TABLE.ID[24] ~= nil) then
				GameTooltip:SetSpell(ARCANUM_SPELL_TABLE.ID[24],1);
			elseif (ARCANUM_SPELL_TABLE.ID[28] ~= nil) then
				GameTooltip:SetSpell(ARCANUM_SPELL_TABLE.ID[28],1);
			end
		elseif (type == "Portal3") then
			if (ARCANUM_SPELL_TABLE.ID[25] ~= nil) then
				GameTooltip:SetSpell(ARCANUM_SPELL_TABLE.ID[25],1);
			elseif (ARCANUM_SPELL_TABLE.ID[29] ~= nil) then
				GameTooltip:SetSpell(ARCANUM_SPELL_TABLE.ID[29],1);
			end
        elseif (type == "Portal4") then
			if (ARCANUM_SPELL_TABLE.ID[26] ~= nil) then
				GameTooltip:SetSpell(ARCANUM_SPELL_TABLE.ID[26],1);
			elseif (ARCANUM_SPELL_TABLE.ID[30] ~= nil) then
				GameTooltip:SetSpell(ARCANUM_SPELL_TABLE.ID[30],1);
			end
		elseif (type == "Portal5") then
			if (ARCANUM_SPELL_TABLE.ID[44] ~= nil) then
				GameTooltip:SetSpell(ARCANUM_SPELL_TABLE.ID[44],1);
				elseif (ARCANUM_SPELL_TABLE.ID[46] ~= nil) then
				GameTooltip:SetSpell(ARCANUM_SPELL_TABLE.ID[46],1);
			end	
        elseif (type == "Portal6") then
			if (ARCANUM_SPELL_TABLE.ID[41] ~= nil) then
				GameTooltip:SetSpell(ARCANUM_SPELL_TABLE.ID[41],1);
			end
		elseif (type == "Portal7") then
			if (ARCANUM_SPELL_TABLE.ID[43] ~= nil) then
				GameTooltip:SetSpell(ARCANUM_SPELL_TABLE.ID[43],1);
			end		
	  		
        elseif (type == "Ward") and ArcanumConfig.LastWard ~= 0 then
			GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TOOLTIP_DATA.LastSpell.."\n"..ARCANUM_SPELL_TABLE.Name[ArcanumConfig.LastWard].."\nMana : "..ARCANUM_SPELL_TABLE.Mana[ArcanumConfig.LastWard]));
            if ArcanumConfig.LastWard == 57 then
                if ARCANUM_SPELL_TABLE.ID[58] ~= nil then
                    GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TOOLTIP_DATA.LastSpell2.."\n"..ARCANUM_SPELL_TABLE.Name[58].."\nMana : "..ARCANUM_SPELL_TABLE.Mana[58]));
                end
            else
                GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_TOOLTIP_DATA.LastSpell2.."\n"..ARCANUM_SPELL_TABLE.Name[57].."\nMana : "..ARCANUM_SPELL_TABLE.Mana[57]));
            end
        elseif (type == "Ward1") then
            GameTooltip:SetSpell(ARCANUM_SPELL_TABLE.ID[57],1);
        elseif (type == "Ward2") then
            GameTooltip:SetSpell(ARCANUM_SPELL_TABLE.ID[58],1);
		-- Soit c'est le bouton principal
		elseif (type == "Main") then
			GameTooltip:AddLine(Arcanum_MsgAddColor("<white>"..ArcanumArcanePowder).." "..Arcanum_ColoredMsg(ARCANUM_ITEM.ArcanePowder));
			GameTooltip:AddLine(Arcanum_MsgAddColor("<white>"..ArcanumRuneOfTeleportation).." "..Arcanum_ColoredMsg(ARCANUM_ITEM.RuneOfTeleportation));
			GameTooltip:AddLine(Arcanum_MsgAddColor("<white>"..ArcanumRuneOfPortals).." "..Arcanum_ColoredMsg(ARCANUM_ITEM.RuneOfPortals));
			GameTooltip:AddLine(Arcanum_MsgAddColor("<white>"..ArcanumLightFeathers).." "..Arcanum_ColoredMsg(ARCANUM_ITEM.LightFeathers));
			GameTooltip:AddLine(" ");
			GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_MESSAGE.Tooltip.LeftClick..ARCANUM_CLICK[ArcanumConfig.LeftClick]));
            GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_MESSAGE.Tooltip.MiddleClick..ARCANUM_CLICK[ArcanumConfig.MiddleClick]));
			GameTooltip:AddLine(Arcanum_ColoredMsg(ARCANUM_MESSAGE.Tooltip.RightClick..ARCANUM_CLICK[ArcanumConfig.RightClick]));
        elseif (type == "Minimap") then
            GameTooltip:AddLine("|CFF0050FFAr|CFF0080FFca|CFF00B0FFnum|CFFFFFFFF: ".."\n"..ARCANUM_MESSAGE.Tooltip.Minimap);
        end
		-- On affiche
		GameTooltip:Show();
	end
end

function Arcanum_CallToolTip(Id)
    ToolTipList = {
    {},
    {},
    {},
    {"Buff", "ArcaneIntellect", "ArcaneBrilliance"},
    {"Armor", "FrostArmor", "MageArmor"},
    {"Magic", "DampenMagic", "AmplifyMagic"},
    {},
    {"Portal", "Teleport1", "Portal1"}, 
    {"Job", "Teleport2", "Portal2"},
    {"Ward", "Teleport3", "Portal3"},
    };
    if ArcanumConfig.InterfaceVersion == 1 then
        Arcanum_BuildTooltip(this,"ANCHOR_CURSOR",ToolTipList[Id][1]);
    else
        if ArcanumConfig.BuffType == 0 then
            Arcanum_BuildTooltip(this,"ANCHOR_CURSOR",ToolTipList[Id][2]);
        else
            Arcanum_BuildTooltip(this,"ANCHOR_CURSOR",ToolTipList[Id][3]);
        end
    end
end
------------------------------------------------------------------------------------------------------

-- FONCTIONS DE CHARGEMENT DE LA CONFIGURATION

------------------------------------------------------------------------------------------------------

function Arcanum_LoadConfig()
	if (ArcanumConfig.ChatType) then ArcanumChatType_Button:SetChecked(1); end
	if (ArcanumConfig.PortalMessage) then ArcanumPortalMessage_Button:SetChecked(1); end
    if (ArcanumConfig.MountMessage) then ArcanumMountMessage_Button:SetChecked(1); end
    if (ArcanumConfig.Display[1]) then ArcanumDisplayHearthStone_Button:SetChecked(1); end
    if (ArcanumConfig.Display[2]) then ArcanumDisplayManaGem_Button:SetChecked(1); end
    if (ArcanumConfig.Display[3]) then ArcanumDisplayEvocation_Button:SetChecked(1); end
    if (ArcanumConfig.Display[4]) then ArcanumDisplayIceBlock_Button:SetChecked(1); end
    if (ArcanumConfig.Display[5]) then ArcanumDisplayColdSnap_Button:SetChecked(1); end
    if (ArcanumConfig.Display[6]) then ArcanumDisplayIntell_Button:SetChecked(1); end
    if (ArcanumConfig.Display[7]) then ArcanumDisplayArmor_Button:SetChecked(1); end
    if (ArcanumConfig.Display[8]) then ArcanumDisplayBandage_Button:SetChecked(1); end
	
	if (ArcanumConfig.Toggle) then ArcanumToggle_Button:SetChecked(1); end
	if (ArcanumConfig.NoDragAll) then
		ArcanumLock_Button:SetChecked(1);
		Arcanum_NoDrag();
		ArcanumButton:RegisterForDrag("");
	end
	if (ArcanumConfig.ArcanumLockServ) then ArcanumIconsLock_Button:SetChecked(1); end
	if (ArcanumConfig.BuffMenuPos == "Left") then
        ArcanumBuffMenu_LeftButton:SetChecked(1);
    elseif (ArcanumConfig.BuffMenuPos == "Right") then
        ArcanumBuffMenu_RightButton:SetChecked(1);
    elseif (ArcanumConfig.BuffMenuPos == "Up") then
        ArcanumBuffMenu_UpButton:SetChecked(1);
    elseif (ArcanumConfig.BuffMenuPos == "Down") then
        ArcanumBuffMenu_DownButton:SetChecked(1);
    end
    
    
	if (ArcanumConfig.ArmorMenuPos == "y") then ArcanumArmorMenu_Button:SetChecked(1); end
	if (ArcanumConfig.MagicMenuPos == "y") then ArcanumMagicMenu_Button:SetChecked(1); end
	if (ArcanumConfig.PortalMenuPos == "y") then ArcanumPortalMenu_Button:SetChecked(1); end
    if (ArcanumConfig.MountMenuPos == "y") then ArcanumMountMenu_Button:SetChecked(1); end
    if (ArcanumConfig.JobMenuPos == "y") then ArcanumJobMenu_Button:SetChecked(1); end
    if (ArcanumConfig.WardMenuPos == "y") then ArcanumWardMenu_Button:SetChecked(1); end
    
	if (ArcanumConfig.ReagentSort) then ArcanumReagentSort_Button:SetChecked(1); end
	if (ArcanumConfig.ReagentBuy) then ArcanumReagentBuy_Button:SetChecked(1); end
	
	if (ArcanumConfig.LevelBuff) then ArcanumLevelBuff_Button:SetChecked(1); end
    if (ArcanumConfig.RandMount) then ArcanumRandMount_Button:SetChecked(1); end
	
	if (ArcanumConfig.InterfaceVersion == 1)then
		ArcanumInterfaceVersion_Button:SetChecked(1);
	else
		ArcanumInterfaceVersion2_Button:SetChecked(1);
	end
	if (ArcanumConfig.BuffButton) then ArcanumBuffButton_Button:SetChecked(1); end
	if (ArcanumConfig.ArmorButton) then ArcanumArmorButton_Button:SetChecked(1); end
	if (ArcanumConfig.MagicButton) then ArcanumMagicButton_Button:SetChecked(1); end
	if (ArcanumConfig.PortalButton) then ArcanumPortalButton_Button:SetChecked(1); end
	if (ArcanumConfig.MountButton) then ArcanumMountButton_Button:SetChecked(1); end
	if (ArcanumConfig.FoodButton) then ArcanumFoodButton_Button:SetChecked(1); end
	if (ArcanumConfig.WaterButton) then ArcanumWaterButton_Button:SetChecked(1); end
	if (ArcanumConfig.ManaGemButton) then ArcanumManaGemButton_Button:SetChecked(1); end
    if (ArcanumConfig.JobButton) then ArcanumJobButton_Button:SetChecked(1); end
    if (ArcanumConfig.WardButton) then ArcanumWardButton_Button:SetChecked(1); end
    if (ArcanumConfig.MinimapIcon) then ArcanumMinimapIcon_Button:SetChecked(1); end
	
	if ArcanumConfig.ArcanumLanguage == "deDE" then
		ArcanumLanguage_Slider:SetValue(3);
	elseif ArcanumConfig.ArcanumLanguage == "enUS" then
		ArcanumLanguage_Slider:SetValue(2);
	else
		ArcanumLanguage_Slider:SetValue(1);
	end
	ArcanumLanguage_SliderText:SetText(Arcanum_ColoredMsg("Langue / Language / Sprache"));
	ArcanumLanguage_SliderLow:SetText("");
	ArcanumLanguage_SliderHigh:SetText("");
	
	-- Paramtères des glissières
	ArcanumTooltip_SliderText:SetText(Arcanum_ColoredMsg("Tooltips"));
	ArcanumTooltip_SliderLow:SetText("");
	ArcanumTooltip_SliderHigh:SetText("");
	ArcanumTooltip_Slider:SetValue(ArcanumConfig.Tooltip);
	
    ArcanumEvocationLimit_Slider:SetValue(ArcanumConfig.EvocationLimit);
    ArcanumEvocationLimit_SliderLow:SetText("0 %");
	ArcanumEvocationLimit_SliderHigh:SetText("100 %");
    
	ArcanumBag_Slider:SetValue(4 - ArcanumConfig.ReagentContainer);
	ArcanumBag_SliderLow:SetText("5");
	ArcanumBag_SliderHigh:SetText("1");
    ArcanumPowder_EditBox:SetTextColor(0,0.5,1);
	ArcanumPowder_EditBox:SetNumber(ArcanumConfig.Powder);
	ArcanumPowder_EditBox:SetNumeric(true);
    ArcanumTeleport_EditBox:SetTextColor(0,0.5,1);
	ArcanumTeleport_EditBox:SetNumber(ArcanumConfig.Teleport);
	ArcanumTeleport_EditBox:SetNumeric(true);
    ArcanumPortal_EditBox:SetTextColor(0,0.5,1);
	ArcanumPortal_EditBox:SetNumber(ArcanumConfig.Portal);
	ArcanumPortal_EditBox:SetNumeric(true);

	ArcanumButtonRotate_Slider:SetValue(ArcanumConfig.ArcanumAngle);
	ArcanumButtonRotate_SliderLow:SetText("0");
	ArcanumButtonRotate_SliderHigh:SetText("360");
	ArcanumButtonScale_Slider:SetValue(ArcanumConfig.ArcanumScale);
	ArcanumButtonScale_SliderLow:SetText("50 %");
	ArcanumButtonScale_SliderHigh:SetText("150 %");
	ArcanumButton:SetScale(ArcanumConfig.ArcanumScale / 100);
    ArcanumButton2Scale_Slider:SetValue(ArcanumConfig.ArcanumButtonScale);
    ArcanumButton2Scale_SliderLow:SetText("50 %");
	ArcanumButton2Scale_SliderHigh:SetText("150 %");
    ArcanumButton1:SetScale(ArcanumConfig.ArcanumButtonScale / 100);
    ArcanumButton2:SetScale(ArcanumConfig.ArcanumButtonScale / 100);
    ArcanumButton3:SetScale(ArcanumConfig.ArcanumButtonScale / 100);
    ArcanumButton4:SetScale(ArcanumConfig.ArcanumButtonScale / 100);
    ArcanumButton5:SetScale(ArcanumConfig.ArcanumButtonScale / 100);
    ArcanumButton6:SetScale(ArcanumConfig.ArcanumButtonScale / 100);
    ArcanumButton7:SetScale(ArcanumConfig.ArcanumButtonScale / 100);
    ArcanumButton8:SetScale(ArcanumConfig.ArcanumButtonScale / 100);
    ArcanumButton9:SetScale(ArcanumConfig.ArcanumButtonScale / 100);
    ArcanumButton10:SetScale(ArcanumConfig.ArcanumButtonScale / 100);
    
    ArcanumMinimapRotate_Slider:SetValue(ArcanumConfig.MinimapIconPos);
    ArcanumMinimapRotate_SliderLow:SetText("0");
	ArcanumMinimapRotate_SliderHigh:SetText("360");
    
    ArcanumMenuScale_Slider:SetValue(ArcanumConfig.MenuScale);
	ArcanumMenuScale_SliderLow:SetText("50 %");
	ArcanumMenuScale_SliderHigh:SetText("150 %");
	ArcanumMenuPosition_Slider:SetValue(ArcanumConfig.MenuPosition);
	ArcanumMenuPosition_SliderLow:SetText("50 %");
	ArcanumMenuPosition_SliderHigh:SetText("150 %");
    ArcanumButton4Menu1:SetScale(ArcanumConfig.MenuScale / 100);
    ArcanumButton4Menu2:SetScale(ArcanumConfig.MenuScale / 100);
    ArcanumButton5Menu1:SetScale(ArcanumConfig.MenuScale / 100);
    ArcanumButton5Menu2:SetScale(ArcanumConfig.MenuScale / 100);
    ArcanumButton5Menu3:SetScale(ArcanumConfig.MenuScale / 100);
    ArcanumButton6Menu1:SetScale(ArcanumConfig.MenuScale / 100);
    ArcanumButton6Menu2:SetScale(ArcanumConfig.MenuScale / 100);
    ArcanumButton7Menu1:SetScale(ArcanumConfig.MenuScale / 100);
    ArcanumButton7Menu2:SetScale(ArcanumConfig.MenuScale / 100);
    ArcanumButton7Menu3:SetScale(ArcanumConfig.MenuScale / 100);
    ArcanumButton7Menu4:SetScale(ArcanumConfig.MenuScale / 100);
    ArcanumButton7Menu5:SetScale(ArcanumConfig.MenuScale / 100);
    ArcanumButton7Menu6:SetScale(ArcanumConfig.MenuScale / 100);
    ArcanumButton7Menu7:SetScale(ArcanumConfig.MenuScale / 100);
    ArcanumButton7Menu8:SetScale(ArcanumConfig.MenuScale / 100);
    ArcanumButton7Menu9:SetScale(ArcanumConfig.MenuScale / 100);
    ArcanumButton7Menu10:SetScale(ArcanumConfig.MenuScale / 100);
    ArcanumButton8Menu1:SetScale(ArcanumConfig.MenuScale / 100);
    ArcanumButton8Menu2:SetScale(ArcanumConfig.MenuScale / 100);
    ArcanumButton8Menu3:SetScale(ArcanumConfig.MenuScale / 100);
    ArcanumButton8Menu4:SetScale(ArcanumConfig.MenuScale / 100);
    ArcanumButton8Menu5:SetScale(ArcanumConfig.MenuScale / 100);
    ArcanumButton8Menu6:SetScale(ArcanumConfig.MenuScale / 100);
    ArcanumButton8Menu7:SetScale(ArcanumConfig.MenuScale / 100);
    ArcanumButton8Menu8:SetScale(ArcanumConfig.MenuScale / 100);
    ArcanumButton8Menu9:SetScale(ArcanumConfig.MenuScale / 100);
    ArcanumButton8Menu10:SetScale(ArcanumConfig.MenuScale / 100);
    ArcanumButton8Menu11:SetScale(ArcanumConfig.MenuScale / 100);
    ArcanumButton8Menu12:SetScale(ArcanumConfig.MenuScale / 100);
    ArcanumButton8Menu13:SetScale(ArcanumConfig.MenuScale / 100);
    ArcanumButton9Menu1:SetScale(ArcanumConfig.MenuScale / 100);
    ArcanumButton9Menu2:SetScale(ArcanumConfig.MenuScale / 100);
    ArcanumButton9Menu3:SetScale(ArcanumConfig.MenuScale / 100);
    ArcanumButton9Menu4:SetScale(ArcanumConfig.MenuScale / 100);
    ArcanumButton9Menu5:SetScale(ArcanumConfig.MenuScale / 100);
    ArcanumButton9Menu6:SetScale(ArcanumConfig.MenuScale / 100);
    ArcanumButton9Menu7:SetScale(ArcanumConfig.MenuScale / 100);
    ArcanumButton10Menu1:SetScale(ArcanumConfig.MenuScale / 100);
    ArcanumButton10Menu2:SetScale(ArcanumConfig.MenuScale / 100);
    
    ArcanumHealthColorTexture:SetVertexColor(ArcanumConfig.HealthColor.r,ArcanumConfig.HealthColor.g,ArcanumConfig.HealthColor.b);
    ArcanumManaColorTexture:SetVertexColor(ArcanumConfig.ManaColor.r,ArcanumConfig.ManaColor.g,ArcanumConfig.ManaColor.b);
    ArcanumButtonColorTexture:SetVertexColor(ArcanumConfig.ButtonColor.r,ArcanumConfig.ButtonColor.g,ArcanumConfig.ButtonColor.b);
    if (ArcanumConfig.DisplayHealthMana) then ArcanumDisplayHealthMana_Button:SetChecked(1); end
    
	Arcanum_LanguageInitialize();
end

function Arcanum_LanguageInitialize()
    ArcanumLocalization();
	-- Localisation du XML
	ArcanumVersion:SetText(Arcanum_ColoredMsg(ArcanumData.AppName).."|CFFFFFFFF "..ArcanumData.Version.." by "..ArcanumData.Author);
	
	ArcanumGeneralPageText:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.Menu1));
	ArcanumMessagePlayer_Section:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.MessageMenu1));
	ArcanumChatType_Option:SetText(ARCANUM_CONFIGURATION.ChatType);
	ArcanumPortalMessage_Option:SetText(ARCANUM_CONFIGURATION.PortalMessage);
    ArcanumMountMessage_Option:SetText(ARCANUM_CONFIGURATION.MountMessage);
    ArcanumButtonDisplay_Section:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.ArcanumButtonDisplay));
    ArcanumInsideDisplayDD:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.InsideDisplay));
    ArcanumDisplayHearthStone_Option:SetText(ARCANUM_CONFIGURATION.DisplayHearthStone);
    ArcanumDisplayManaGem_Option:SetText(ARCANUM_CONFIGURATION.DisplayManaGem);
    ArcanumDisplayEvocation_Option:SetText(ARCANUM_CONFIGURATION.DisplayEvocation);
    ArcanumDisplayIceBlock_Option:SetText(ARCANUM_CONFIGURATION.DisplayIceBlock);
    ArcanumDisplayColdSnap_Option:SetText(ARCANUM_CONFIGURATION.DisplayColdSnap);
    ArcanumDisplayIntell_Option:SetText(ARCANUM_CONFIGURATION.DisplayIntell);
    ArcanumDisplayArmor_Option:SetText(ARCANUM_CONFIGURATION.DisplayArmor);
    ArcanumDisplayBandage_Option:SetText(ARCANUM_CONFIGURATION.DisplayBandage);
    ArcanumHealthColor_Option:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.HealthColor));
	ArcanumManaColor_Option:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.ManaColor));
    ArcanumButtonColor_Option:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.ButtonColor));
    ArcanumDisplayHealthMana_Option:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.DisplayHealthMana));

	ArcanumLevelBuff_Option:SetText(ARCANUM_CONFIGURATION.LevelBuff);
    ArcanumEvocationLimit_SliderText:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.EvocationLimit));
    ArcanumConsumeFood_Option:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.ConsumeFood));
    ArcanumConsumeGems_Option:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.ConsumeGems));
    ArcanumRandMount_Option:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.RandMount));
	ArcanumDeleteFood_Button:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.DeleteFood));
	ArcanumDeleteWater_Button:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.DeleteWater));
	ArcanumDeleteManaGem_Button:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.DeleteManaGem));
    ArcanumBindings_Button:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.Bindings));

	ArcanumReagentSort_Option:SetText(ARCANUM_CONFIGURATION.ReagentSort);
	ArcanumBag_SliderText:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.ReagentBag));
	ArcanumReagentBuy_Option:SetText(ARCANUM_CONFIGURATION.ReagentBuy);
	ArcanumReagent_Section:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.Reagent));
	ArcanumPowder_Section:SetText(ARCANUM_CONFIGURATION.Powder);
	ArcanumTeleport_Section:SetText(ARCANUM_CONFIGURATION.Teleport);
	ArcanumPortal_Section:SetText(ARCANUM_CONFIGURATION.Portal);

	ArcanumToggle_Option:SetText(ARCANUM_CONFIGURATION.Toggle);
	ArcanumInterfaceVersion_Option:SetText(ARCANUM_CONFIGURATION.InterfaceVersion);
	ArcanumInterfaceVersion2_Option:SetText(ARCANUM_CONFIGURATION.InterfaceVersion2);
	ArcanumLock_Option:SetText(ARCANUM_CONFIGURATION.Lock);
	ArcanumIconsLock_Option:SetText(ARCANUM_CONFIGURATION.IconsLock);
	ArcanumButtonRotate_SliderText:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.ArcanumRotation));
	ArcanumButtonScale_SliderText:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.ArcanumSize));
    ArcanumButton2Scale_SliderText:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.ButtonSize));

    ArcanumButton_Option:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.Button));
    ArcanumOrder_Option:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.Order));
    ArcanumBuffButton_Option:SetText(ARCANUM_CONFIGURATION.BuffButton);
	ArcanumArmorButton_Option:SetText(ARCANUM_CONFIGURATION.ArmorButton);
	ArcanumMagicButton_Option:SetText(ARCANUM_CONFIGURATION.MagicButton);
	ArcanumPortalButton_Option:SetText(ARCANUM_CONFIGURATION.PortalButton);
	ArcanumMountButton_Option:SetText(ARCANUM_CONFIGURATION.MountButton);
	ArcanumFoodButton_Option:SetText(ARCANUM_CONFIGURATION.FoodButton);
	ArcanumWaterButton_Option:SetText(ARCANUM_CONFIGURATION.WaterButton);
    ArcanumMinimapIcon_Option:SetText(ARCANUM_CONFIGURATION.MinimapIcon);
	ArcanumManaGemButton_Option:SetText(ARCANUM_CONFIGURATION.ManaGemButton);
    ArcanumJobButton_Option:SetText(ARCANUM_CONFIGURATION.JobButton);
	ArcanumWardButton_Option:SetText(ARCANUM_CONFIGURATION.WardButton);
    ArcanumLeftClick:SetText(Arcanum_ColoredMsg(ARCANUM_MESSAGE.Tooltip.LeftClick));
    ArcanumMiddleClick:SetText(Arcanum_ColoredMsg(ARCANUM_MESSAGE.Tooltip.MiddleClick));
    ArcanumRightClick:SetText(Arcanum_ColoredMsg(ARCANUM_MESSAGE.Tooltip.RightClick));
    ArcanumMinimapRotate_SliderText:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.ArcanumMinimapIconPos.." "..ArcanumConfig.MinimapIconPos.."°"));
    
    ArcanumMenuPosition_Section:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.MenuPosition));
	ArcanumBuffMenu_Option:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.BuffMenu));
	ArcanumArmorMenu_Option:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.ArmorMenu));
	ArcanumMagicMenu_Option:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.MagicMenu));
	ArcanumPortalMenu_Option:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.PortalMenu));
    ArcanumMountMenu_Option:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.MountMenu));
    ArcanumJobMenu_Option:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.JobMenu));
    ArcanumWardMenu_Option:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.WardMenu));
    ArcanumMenuScale_SliderText:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.MenuScale));
	ArcanumMenuPosition_SliderText:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.MenuPosition));
    
    ClearTable(ArcanumLeftButtonClick);
    for i = 1, table.getn(ARCANUM_CLICK) do
        table.insert(ArcanumLeftButtonClick, ARCANUM_CLICK[i]);
    end
    ClearTable(ArcanumMiddleButtonClick);
    for i = 1, table.getn(ARCANUM_CLICK) do
        table.insert(ArcanumMiddleButtonClick, ARCANUM_CLICK[i]);
    end
    ClearTable(ArcanumRightButtonClick);
    for i = 1, table.getn(ARCANUM_CLICK) do
        table.insert(ArcanumRightButtonClick, ARCANUM_CLICK[i]);
    end
    ClearTable(ArcanumInsideDisplayClick);
    for i = 1, table.getn(ARCANUM_INSIDE_DISPLAY) do
        table.insert(ArcanumInsideDisplayClick, ARCANUM_INSIDE_DISPLAY[i]);
    end
    UIDropDownMenu_SetSelectedID(ArcanumLeftClickDropDown, ArcanumConfig.LeftClick);
    UIDropDownMenu_SetSelectedID(ArcanumMiddleClickDropDown, ArcanumConfig.MiddleClick);
    UIDropDownMenu_SetSelectedID(ArcanumRightClickDropDown, ArcanumConfig.RightClick);
    UIDropDownMenu_SetText(ARCANUM_CLICK[ArcanumConfig.LeftClick], ArcanumLeftClickDropDown);
    UIDropDownMenu_SetText(ARCANUM_CLICK[ArcanumConfig.MiddleClick], ArcanumMiddleClickDropDown);
    UIDropDownMenu_SetText(ARCANUM_CLICK[ArcanumConfig.RightClick], ArcanumRightClickDropDown);
    
    UIDropDownMenu_SetSelectedID(ArcanumInsideDisplayDropDown, ArcanumConfig.InsideDisplay);
    UIDropDownMenu_SetText(ARCANUM_INSIDE_DISPLAY[ArcanumConfig.InsideDisplay], ArcanumInsideDisplayDropDown);
    
    ClearTable(ArcanumBuffMenuClick);
    for i = 1, table.getn(ARCANUM_MENU_POS) do
        table.insert(ArcanumBuffMenuClick, ARCANUM_MENU_POS[i]);
    end
    ClearTable(ArcanumArmorMenuClick);
    for i = 1, table.getn(ARCANUM_MENU_POS) do
        table.insert(ArcanumArmorMenuClick, ARCANUM_MENU_POS[i]);
    end
    ClearTable(ArcanumMagicMenuClick);
    for i = 1, table.getn(ARCANUM_MENU_POS) do
        table.insert(ArcanumMagicMenuClick, ARCANUM_MENU_POS[i]);
    end
    ClearTable(ArcanumPortalMenuClick);
    for i = 1, table.getn(ARCANUM_MENU_POS) do
        table.insert(ArcanumPortalMenuClick, ARCANUM_MENU_POS[i]);
    end
    ClearTable(ArcanumMountMenuClick);
    for i = 1, table.getn(ARCANUM_MENU_POS) do
        table.insert(ArcanumMountMenuClick, ARCANUM_MENU_POS[i]);
    end
    ClearTable(ArcanumJobMenuClick);
    for i = 1, table.getn(ARCANUM_MENU_POS) do
        table.insert(ArcanumJobMenuClick, ARCANUM_MENU_POS[i]);
    end
    ClearTable(ArcanumWardMenuClick);
    for i = 1, table.getn(ARCANUM_MENU_POS) do
        table.insert(ArcanumWardMenuClick, ARCANUM_MENU_POS[i]);
    end
    UIDropDownMenu_SetSelectedID(ArcanumBuffMenuDropDown, ArcanumConfig.BuffMenuPos);
    UIDropDownMenu_SetText(ARCANUM_MENU_POS[ArcanumConfig.BuffMenuPos], ArcanumBuffMenuDropDown);
    UIDropDownMenu_SetSelectedID(ArcanumArmorMenuDropDown, ArcanumConfig.ArmorMenuPos);
    UIDropDownMenu_SetText(ARCANUM_MENU_POS[ArcanumConfig.ArmorMenuPos], ArcanumArmorMenuDropDown);
    UIDropDownMenu_SetSelectedID(ArcanumMagicMenuDropDown, ArcanumConfig.MagicMenuPos);
    UIDropDownMenu_SetText(ARCANUM_MENU_POS[ArcanumConfig.MagicMenuPos], ArcanumMagicMenuDropDown);
    UIDropDownMenu_SetSelectedID(ArcanumPortalMenuDropDown, ArcanumConfig.PortalMenuPos);
    UIDropDownMenu_SetText(ARCANUM_MENU_POS[ArcanumConfig.PortalMenuPos], ArcanumPortalMenuDropDown);
    UIDropDownMenu_SetSelectedID(ArcanumMountMenuDropDown, ArcanumConfig.MountMenuPos);
    UIDropDownMenu_SetText(ARCANUM_MENU_POS[ArcanumConfig.MountMenuPos], ArcanumMountMenuDropDown);
    UIDropDownMenu_SetSelectedID(ArcanumJobMenuDropDown, ArcanumConfig.JobMenuPos);
    UIDropDownMenu_SetText(ARCANUM_MENU_POS[ArcanumConfig.JobMenuPos], ArcanumJobMenuDropDown);
    UIDropDownMenu_SetSelectedID(ArcanumWardMenuDropDown, ArcanumConfig.WardMenuPos);
    UIDropDownMenu_SetText(ARCANUM_MENU_POS[ArcanumConfig.WardMenuPos], ArcanumWardMenuDropDown);
    
    ClearTable(ArcanumConsumeFoodClick);
    for i = 1, table.getn(ARCANUM_CONSUME_FOOD) do
        table.insert(ArcanumConsumeFoodClick, ARCANUM_CONSUME_FOOD[i]);
    end
    ClearTable(ArcanumConsumeGemsClick);
    for i = 1, table.getn(ARCANUM_CONSUME_GEMS) do
        table.insert(ArcanumConsumeGemsClick, ARCANUM_CONSUME_GEMS[i]);
    end
    UIDropDownMenu_SetSelectedID(ArcanumConsumeFoodDropDown, ArcanumConfig.ConsumeFood);
    UIDropDownMenu_SetText(ARCANUM_CONSUME_FOOD[ArcanumConfig.ConsumeFood], ArcanumConsumeFoodDropDown);
    UIDropDownMenu_SetSelectedID(ArcanumConsumeGemsDropDown, ArcanumConfig.ConsumeGems);
    UIDropDownMenu_SetText(ARCANUM_CONSUME_GEMS[ArcanumConfig.ConsumeGems], ArcanumConsumeGemsDropDown);
end

------------------------------------------------------------------------------------------------------

-- FONCTIONS DE GESTION DES FENETRES DE CONFIGURATION

------------------------------------------------------------------------------------------------------

function ArcanumGeneralTab_OnClick(id)
	local TabName;
	for index = 1, 7, 1 do
		TabName = getglobal("ArcanumGeneralTab"..index);
		if index == id then
			TabName:SetChecked(1);
		else
			TabName:SetChecked(nil);
		end
	end
	if id == 1 then
		ShowUIPanel(ArcanumMessageMenu);
		HideUIPanel(ArcanumSpellsMenu);
		HideUIPanel(ArcanumReagentMenu);
		HideUIPanel(ArcanumGraphOptionMenu);
		HideUIPanel(ArcanumButtonOptionMenu);
        HideUIPanel(ArcanumMenuOptionMenu);
        HideUIPanel(ArcanumSkinMenu);
		ArcanumGeneralIcon:SetTexture("Interface\\QuestFrame\\UI-QuestLog-BookIcon");
		ArcanumGeneralPageText:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.Menu1));
	elseif id == 2 then
		HideUIPanel(ArcanumMessageMenu);
		ShowUIPanel(ArcanumSpellsMenu);
		HideUIPanel(ArcanumReagentMenu);
		HideUIPanel(ArcanumGraphOptionMenu);
		HideUIPanel(ArcanumButtonOptionMenu);
        HideUIPanel(ArcanumMenuOptionMenu);
        HideUIPanel(ArcanumSkinMenu);
		ArcanumGeneralIcon:SetTexture("Interface\\QuestFrame\\UI-QuestLog-BookIcon");
		ArcanumGeneralPageText:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.Menu2));
	elseif id == 3 then
		HideUIPanel(ArcanumMessageMenu);
		HideUIPanel(ArcanumSpellsMenu);
		ShowUIPanel(ArcanumReagentMenu);
		HideUIPanel(ArcanumGraphOptionMenu);
		HideUIPanel(ArcanumButtonOptionMenu);
        HideUIPanel(ArcanumMenuOptionMenu);
        HideUIPanel(ArcanumSkinMenu);
		ArcanumGeneralIcon:SetTexture("Interface\\QuestFrame\\UI-QuestLog-BookIcon");
		ArcanumGeneralPageText:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.Menu3));
	elseif id == 4 then
		HideUIPanel(ArcanumMessageMenu);
		HideUIPanel(ArcanumSpellsMenu);
		HideUIPanel(ArcanumReagentMenu);
		ShowUIPanel(ArcanumGraphOptionMenu);
		HideUIPanel(ArcanumButtonOptionMenu);
        HideUIPanel(ArcanumMenuOptionMenu);
        HideUIPanel(ArcanumSkinMenu);
		ArcanumGeneralIcon:SetTexture("Interface\\QuestFrame\\UI-QuestLog-BookIcon");
		ArcanumGeneralPageText:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.Menu4));
	elseif id == 5 then
		HideUIPanel(ArcanumMessageMenu);
		HideUIPanel(ArcanumSpellsMenu);
		HideUIPanel(ArcanumReagentMenu);
		HideUIPanel(ArcanumGraphOptionMenu);
		ShowUIPanel(ArcanumButtonOptionMenu);
        HideUIPanel(ArcanumMenuOptionMenu);
        HideUIPanel(ArcanumSkinMenu);
		ArcanumGeneralIcon:SetTexture("Interface\\QuestFrame\\UI-QuestLog-BookIcon");
		ArcanumGeneralPageText:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.Menu5));
    elseif id == 6 then
		HideUIPanel(ArcanumMessageMenu);
		HideUIPanel(ArcanumSpellsMenu);
		HideUIPanel(ArcanumReagentMenu);
		HideUIPanel(ArcanumGraphOptionMenu);
		HideUIPanel(ArcanumButtonOptionMenu);
        ShowUIPanel(ArcanumMenuOptionMenu);
        HideUIPanel(ArcanumSkinMenu);
		ArcanumGeneralIcon:SetTexture("Interface\\QuestFrame\\UI-QuestLog-BookIcon");
		ArcanumGeneralPageText:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.Menu6));
    elseif id == 7 then
		HideUIPanel(ArcanumMessageMenu);
		HideUIPanel(ArcanumSpellsMenu);
		HideUIPanel(ArcanumReagentMenu);
		HideUIPanel(ArcanumGraphOptionMenu);
		HideUIPanel(ArcanumButtonOptionMenu);
        HideUIPanel(ArcanumMenuOptionMenu);
        ShowUIPanel(ArcanumSkinMenu);
		ArcanumGeneralIcon:SetTexture("Interface\\QuestFrame\\UI-QuestLog-BookIcon");
		ArcanumGeneralPageText:SetText(Arcanum_ColoredMsg(ARCANUM_CONFIGURATION.Menu7));
	end
end

------------------------------------------------------------------------------------------------------

-- FONCTION DE GESTION DES COMPOS A ACHETER

------------------------------------------------------------------------------------------------------
function Arcanum_AutoBuy()
	local ReagentCount = {ArcanumConfig.Powder - ArcanumArcanePowder, ArcanumConfig.Teleport - ArcanumRuneOfTeleportation, ArcanumConfig.Portal - ArcanumRuneOfPortals};
	local ReagentName = {ARCANUM_ITEM.ArcanePowder, ARCANUM_ITEM.RuneOfTeleportation, ARCANUM_ITEM.RuneOfPortals};
	local ReagentBuyCount = 0;
    if ARCANUM_SPELL_TABLE.ID[13] == nil then
        ReagentCount[1] = 0;
    end
    local NbTeleport = 0;
	-- Pour chaque sort de teleportation connu, on incremente NbTeleport
	for i = 27, 40 do
	  if    ARCANUM_SPELL_TABLE.ID[i] ~= nil then
	    NbTeleport = NbTeleport + 1;
	  end
	end
	-- si on ne connait aucun sort de teleportation, on force la rune de teleportation a 0
	if NbTeleport == 0 then  
	 ReagentCount[2] = 0;
	 end
    if (ARCANUM_SPELL_TABLE.ID[20] == nil and ARCANUM_SPELL_TABLE.ID[21] == nil and ARCANUM_SPELL_TABLE.ID[22] == nil) and (ARCANUM_SPELL_TABLE.ID[23] == nil and ARCANUM_SPELL_TABLE.ID[24] == nil and ARCANUM_SPELL_TABLE.ID[25] == nil) then
        ReagentCount[3] = 0;
    end
    if ReagentCount[1] ~= 0 or ReagentCount[2] ~= 0 or ReagentCount[3] ~= 0 then
        local NumItems = GetMerchantNumItems()
        for j = 1, NumItems do
            for i = 1, 3 do
                local slotItemString = GetMerchantItemInfo(j)
                if slotItemString == ReagentName[i] and ReagentCount[i] > 0 then
                    Arcanum_Msg(ARCANUM_MESSAGE.Autobuy..ReagentCount[i].." "..ReagentName[i], "USER");
                    ReagentBuyCount = ReagentCount[i] / 10;
                    for k = 1, ReagentBuyCount do
                        BuyMerchantItem(j, 10);
                        ReagentCount[i] = ReagentCount[i] - 10;
                    end
                    if ReagentCount[i] > 0 then
                        BuyMerchantItem(j, ReagentCount[i]);
                        ReagentCount[i] = ReagentCount[i] - ReagentCount[i];
                    end
                    --CloseMerchant();
                    ReagentBought = true;
                end
            end
        end
        if ArcanumConfig.ReagentSort == true then
            Arcanum_ReagentSwitch();
        end
    end
end

function Arcanum_Trade()
    if UnitExists("target") and UnitIsFriend("player","target") and UnitIsPlayer("target") and not UnitIsUnit("player","target") then
        if (FoodCount > 0 or WaterCount > 0)  and ArcanumTradeNB <= 6 then
            if ArcanumTradeOpened == false then
                InitiateTrade("target");
            end
            Arcanum_FoodWaterSweep(UnitLevel("target"));
            local playerClass, englishClass = UnitClass("target");

            if englishClass ~= "WARRIOR" or englishClass ~= "ROGUE" then
                if table.getn(FoodLocation) >= ceil((ArcanumTradeNB) / 2) then
                    PickupContainerItem(FoodLocation[ceil((ArcanumTradeNB) / 2)][1], FoodLocation[ceil((ArcanumTradeNB) / 2)][2]);
                    if CursorHasItem() then
                        DropItemOnUnit("target");
                    end
                end
                if table.getn(WaterLocation) >= ceil((ArcanumTradeNB) / 2) then
                    PickupContainerItem(WaterLocation[ceil((ArcanumTradeNB) / 2)][1], WaterLocation[ceil((ArcanumTradeNB) / 2)][2]);
                    if CursorHasItem() then
                        DropItemOnUnit("target");
                    end
                end
            else
                PickupContainerItem(FoodLocation[ArcanumTradeNB][1], FoodLocation[ArcanumTradeNB][2]);
                if CursorHasItem() then
                    DropItemOnUnit("target");
                end
            end
            ArcanumTradeAcceptT = 0;
            ArcanumTradeAccept = true;
        end
    end
end

function ArcanumTradeFood()
    if UnitExists("target") and UnitIsFriend("player","target") and UnitIsPlayer("target") and not UnitIsUnit("player","target") then
        Arcanum_FoodWaterSweep(UnitLevel("target"));
        PickupContainerItem(FoodLocation[ArcanumTradeFoodNB][1], FoodLocation[ArcanumTradeFoodNB][2]);
        if CursorHasItem() then
            DropItemOnUnit("target");
        end
        ArcanumTradeAcceptT = 0;
        ArcanumTradeAccept = true;
        ArcanumTradeFoodNB = ArcanumTradeFoodNB + 1;
    end
end

function ArcanumTradeWater()
    if UnitExists("target") and UnitIsFriend("player","target") and UnitIsPlayer("target") and not UnitIsUnit("player","target") then
        Arcanum_FoodWaterSweep(UnitLevel("target"));
        PickupContainerItem(WaterLocation[ArcanumTradeWaterNB][1], WaterLocation[ArcanumTradeWaterNB][2]);
        if CursorHasItem() then
            DropItemOnUnit("target");
        end            
        ArcanumTradeAcceptT = 0;
        ArcanumTradeAccept = true;
        ArcanumTradeWaterNB = ArcanumTradeWaterNB + 1;
    end
end

function Arcanum_FoodWaterSweep(Level)

    local FoodLevel, WaterLevel;
    FoodLocationCount = 0;
    WaterLocationCount = 0;
    local FoodWaterLevel;
    
    for j = ARCANUM_SPELL_TABLE.Rank[8], 1, -1 do
        if Level >= Water_Minlvl[j] then
            FoodWaterLevel = j;
            break;
        end
    end

		
    ClearTable(FoodLocation);
    ClearTable(WaterLocation);
    for container = 0, 4, 1 do
        for slot = 1, GetContainerNumSlots(container), 1 do
            --Arcanum_MoneyToggle();
            ArcanumTooltip:SetBagItem(container, slot);
            local itemName = ArcanumTooltipTextLeft1:GetText();
            if itemName == ARCANUM_FOOD[FoodWaterLevel] then
                local _, itemCount = GetContainerItemInfo(container, slot);
                table.insert(FoodLocation, {container, slot, itemCount});
                FoodLocationCount = FoodLocationCount + 1;
            elseif itemName == ARCANUM_WATER[FoodWaterLevel] then
                local _, itemCount = GetContainerItemInfo(container, slot);
                table.insert(WaterLocation, {container, slot, itemCount});
                WaterLocationCount = WaterLocationCount + 1;
			elseif itemName == ARCANUM_MANNE[1] then
                local _, itemCount = GetContainerItemInfo(container, slot); 
                table.insert(ManneLocation, {container, slot, itemCount});
                ManneLocationCount = ManneLocationCount + 1;
            end
        end
    end
    if FoodLocationCount > 0 then
        for i = 1, FoodLocationCount - 1 do
            local j = i + 1;
            while FoodLocation[i][3] < 20 do
                FoodWaterSwitch(FoodLocation, i, j)
                j = j + 1;
            end
        end
    end
    if WaterLocationCount > 0 then
        for i = 1, WaterLocationCount - 1 do
            local j = i + 1;
            while WaterLocation[i][3] < 20 do
                FoodWaterSwitch(WaterLocation, i, j)
                j = j + 1;
            end
        end
    end
	if ManneLocationCount > 0 then
        for i = 1, ManneLocationCount - 1 do
            local j = i + 1;
            while ManneLocation[i][3] < 20 do
                FoodWaterSwitch(ManneLocation, i, j)
                j = j + 1;
            end
        end
    end
end

function FoodWaterSwitch(table, a, b)
    local _, itemCount = GetContainerItemInfo(table[b][1], table[b][2]);
    table[a][3] = itemCount;
    _, itemCount = GetContainerItemInfo(table[a][1], table[a][2]);
    table[b][3] = itemCount;
    PickupContainerItem(table[a][1], table[a][2]);
    PickupContainerItem(table[b][1], table[b][2]);
end
------------------------------------------------------------------------------------------------------

-- FONCTIONS DE GESTION DES SACS (LOCALISATION ET COMPTABILISATION DES COMPOSANTS, OBJETS INVOQUES)

------------------------------------------------------------------------------------------------------

-- destroy water, food and managem item
function Arcanum_DeleteItem(Type)
   	for container = 0, 4, 1 do
		for slot = 1, GetContainerNumSlots(container), 1 do
            if (Type == "Food") then
                for i = 1, table.getn(ARCANUM_FOOD) do
                    Arcanum_MoneyToggle();
			        ArcanumTooltip:SetBagItem(container, slot);
			        local itemName = ArcanumTooltipTextLeft1:GetText();
                    if (itemName == ARCANUM_FOOD[i]) then
                       PickupContainerItem(container, slot);
                        if (CursorHasItem()) then DeleteCursorItem(); end
                    end
                end
            elseif (Type == "Water") then
                for i = 1, table.getn(ARCANUM_WATER) do
                    Arcanum_MoneyToggle();
			        ArcanumTooltip:SetBagItem(container, slot);
			        local itemName = ArcanumTooltipTextLeft1:GetText();
                    if (itemName == ARCANUM_WATER[i]) then
                        PickupContainerItem(container, slot);
                        if (CursorHasItem()) then DeleteCursorItem(); end
                    end
                end
            else
                for i = 1, table.getn(ARCANUM_MANAGEM) do
                    Arcanum_MoneyToggle();
			        ArcanumTooltip:SetBagItem(container, slot);
			        local itemName = ArcanumTooltipTextLeft1:GetText();
                    if (itemName == ARCANUM_MANAGEM[i]) then
                        PickupContainerItem(container, slot);
                        if (CursorHasItem()) then DeleteCursorItem(); end
                    end
                end
            end
        end
    end
	
end

function Arcanum_ReagentSwitch()
	local offset = 0;
	for container = 0, 4, 1 do
		if (container ~= ArcanumConfig.ReagentContainer) then
			for slot = 1, GetContainerNumSlots(container), 1 do
				Arcanum_MoneyToggle();
				ArcanumTooltip:SetBagItem(container, slot);
				local itemInfo = tostring(ArcanumTooltipTextLeft1:GetText());
				if (itemInfo == ARCANUM_ITEM.ArcanePowder or itemInfo == ARCANUM_ITEM.RuneOfTeleportation or itemInfo == ARCANUM_ITEM.RuneOfPortals) then
					Arcanum_FindSlot(container, slot, offset);
					offset = offset + 1;
				end
			end
		end
	end
	-- Aprs avoir tout dplacer, il faut retrouver les emplacements des pierres, etc, etc...
	Arcanum_BagExplore();
end

-- Pendant le dplacement des fragments, il faut trouver un nouvel emplacement aux objets dplacs :)
function Arcanum_FindSlot(Index, Slot, offset)
	for slot = 1, GetContainerNumSlots(ArcanumConfig.ReagentContainer), 1 do
		Arcanum_MoneyToggle();
 		ArcanumTooltip:SetBagItem(ArcanumConfig.ReagentContainer, slot);
 		local itemInfo = tostring(ArcanumTooltipTextLeft1:GetText());
		if (itemInfo ~= ARCANUM_ITEM.ArcanePowder and itemInfo ~= ARCANUM_ITEM.RuneOfTeleportation and itemInfo ~= ARCANUM_ITEM.RuneOfPortals) then
			PickupContainerItem(Index, Slot);
			PickupContainerItem(ArcanumConfig.ReagentContainer, slot + offset);
			break;
		end
	end
end

function Arcanum_BagExplore()
	LastItemsCount = {ArcanumArcanePowder, ArcanumRuneOfTeleportation, ArcanumRuneOfPortals, ArcanumLightFeathers, FoodCount, WaterCount};
	ArcanumArcanePowder = 0;
	ArcanumRuneOfTeleportation = 0;
	ArcanumRuneOfPortals = 0;
	ArcanumLightFeathers = 0;
	ManaGemCount = 0;
	FoodCount = 0;
	WaterCount = 0;
	ManneCount = 0;	
	ManaGemExists = {false, false, false, false, false};
	ClearTable(FoodLocation);
	ClearTable(WaterLocation);
	MountLocation = {nil, nil};
	CompleteMountName = {nil};
	MountName = {nil};
	MountIcon = {nil};
	AQMountLocation = {nil, nil};
	AQMountName = {nil};
	AQMountIcon = {nil};
	for container = 0, 4, 1 do
		for slot = 1, GetContainerNumSlots(container), 1 do
			Arcanum_MoneyToggle();
			ArcanumTooltip:SetBagItem(container, slot);
			local itemName = ArcanumTooltipTextLeft1:GetText();
			if itemName then
				-- On prend le nombre d'item en stack sur le slot
				local texture, itemCount, locked, quality, readable = GetContainerItemInfo(container, slot);
				if itemName == ARCANUM_ITEM.Hearthstone then
                    ArcanumButtonDisplayTexture[1] = texture;
                    HearthstoneLocation = {container,slot}; 
                end
				if itemName == ARCANUM_ITEM.ArcanePowder then ArcanumArcanePowder = ArcanumArcanePowder + itemCount; end
				if itemName == ARCANUM_ITEM.RuneOfTeleportation then ArcanumRuneOfTeleportation = ArcanumRuneOfTeleportation + itemCount; end
				if itemName == ARCANUM_ITEM.RuneOfPortals  then ArcanumRuneOfPortals = ArcanumRuneOfPortals + itemCount; end
				if itemName == ARCANUM_ITEM.LightFeathers  then ArcanumLightFeathers = ArcanumLightFeathers + itemCount; end
				--Recherche de la monture
				for i = 1, table.getn(MOUNT), 1 do
					for j = 1, table.getn(MOUNT[i]), 1 do
						if (itemName == MOUNT[i][j]) then
							table.insert(MountLocation, {container,slot});
							table.insert(CompleteMountName, itemName);
							table.insert(MountIcon, texture);
							for k = 1, table.getn(MOUNT_PREFIX) do
								itemName = string.gsub(itemName, MOUNT_PREFIX[k] , "");
							end
                            table.insert(MountName, itemName);
						end
					end
				end
				--Recherche de la monture qiraji
				for i = 1, table.getn(QIRAJ_MOUNT), 1 do
					if (itemName == QIRAJ_MOUNT[i]) then
                        table.insert(AQMountLocation, {container,slot});
                        table.insert(AQMountName, itemName);
                        table.insert(AQMountIcon, texture);
                        if quality == 5 then
                            table.insert(MountLocation, {container,slot});
                            table.insert(MountName, itemName);
                            table.insert(MountIcon, texture);
                            MountAQ = table.getn(AQMountLocation);
                        end
                        break;
                    end
				end
                
				--Recherche de la gemme de mana
                if (itemName == ARCANUM_MANAGEM[5]) then
					ManaGemLocation[1] = {container,slot};
					ManaGemExists[1] = true;
					ManaGemCount = ManaGemCount + 1;
				end
				if (itemName == ARCANUM_MANAGEM[4]) then
					ManaGemLocation[2] = {container,slot};
					ManaGemExists[2] = true;
					ManaGemCount = ManaGemCount + 1;
				end
				if (itemName == ARCANUM_MANAGEM[3]) then
					ManaGemLocation[3] = {container,slot};
					ManaGemExists[3] = true;
					ManaGemCount = ManaGemCount + 1;
				end
				if (itemName == ARCANUM_MANAGEM[2]) then
					ManaGemLocation[4] = {container,slot};
					ManaGemExists[4] = true;
					ManaGemCount = ManaGemCount + 1;
				end
				if (itemName == ARCANUM_MANAGEM[1]) then
					ManaGemLocation[5] = {container,slot};
					ManaGemExists[5] = true;
					ManaGemCount = ManaGemCount + 1;
				end
				--Recherche du pain
				local rank = ARCANUM_SPELL_TABLE.Rank[8];
				if itemName == ARCANUM_FOOD[rank] then
					table.insert(FoodLocation, {container, slot, itemCount});
					FoodCount = FoodCount + itemCount;
				end
				--Recherche de l'eau
				local rank = ARCANUM_SPELL_TABLE.Rank[9];
				if itemName == ARCANUM_WATER[rank] then
					table.insert(WaterLocation, {container, slot,itemCount});
					WaterCount = WaterCount + itemCount;
 				end
				--Recherche Biscuit de manne
				if itemName == ARCANUM_MANNE[1] then
					table.insert(ManneLocation, {container, slot,itemCount});
					ManneCount = ManneCount + itemCount;
					WaterCount = WaterCount + itemCount;					
					FoodCount  = FoodCount  + itemCount;					
				end	
			end
		end
	end
    for i = 1, table.getn(AQMountLocation) do
        if i ~= MountAQ then
            table.insert(MountLocation, {AQMountLocation[i][1],AQMountLocation[i][2]});
            table.insert(MountName, AQMountName[i]);
            table.insert(MountIcon, AQMountIcon[i]);
        end
    end
    if ArcanumConfig.LastMount > table.getn(MountName) and table.getn(MountName) > 0 then
        ArcanumConfig.LastMount = 1;
    elseif table.getn(MountName) == 0 then
        ArcanumConfig.LastMount = 0;
    end
end

function ClearTable(Table)
	for i = 0, table.getn(Table) do
		table.remove(Table)
	end
end

-- Fonction pour gérer les actions effectuées par Arcanum au clic sur un boutton
function Arcanum_UseItem(type,button)
    if MerchantOpened == false then
        -- Fonction pour utiliser une pierre de foyer dans l'inventaire
        if (type == "Hearthstone") then
            -- Trouve les items utilisés par Arcanum
            if (HearthstoneLocation[1] ~= nil) then
                -- on l'utilise
                UseContainerItem(HearthstoneLocation[1], HearthstoneLocation[2]);
            -- soit il n'y en a pas dans l'inventaire, on affiche un message d'erreur
            else
                Arcanum_Msg(ARCANUM_MESSAGE.Error.NoHearthstone, "USER");
            end
        end
        
        if (type == "Evocation") then
            if ARCANUM_SPELL_TABLE.ID[42] ~= nil then
                if (math.ceil(UnitMana("player") / UnitManaMax("player") * 100)) <= ArcanumConfig.EvocationLimit then
                    CastSpell(ARCANUM_SPELL_TABLE.ID[42], "spell");
                end
            end
        end
        
        if (type == "Iceblock") then
            if ARCANUM_SPELL_TABLE.ID[37] ~= nil then
                if IceblockDone == true and IceblockReady == true then
                    CastSpell(ARCANUM_SPELL_TABLE.ID[37], "spell");
                    IceblockDone = false;
                elseif IceblockDone == false then
                    if CoolDown[5][1] == nil then
                        SpellStopCasting();
                        CastSpell(ARCANUM_SPELL_TABLE.ID[37], "spell");
                        IceblockDone = true;
                    else
                        if ARCANUM_SPELL_TABLE.ID[38] ~= nil then
                            if CoolDown[4][1] == nil then
                                SpellStopCasting();
                                CastSpell(ARCANUM_SPELL_TABLE.ID[38], "spell");
                            end
                        end
                    end
                end
            end 
        end
            
        -- Si on clic sur le bouton de nourriture
        if (type == "Food") then
            if (button == "RightButton") then
                if (UnitExists("target") and UnitIsPlayer("target")) then
                    for i = ARCANUM_SPELL_TABLE.Rank[8], 1, -1 do
                        if UnitLevel("target") >= Water_Minlvl[i] then
                            local FoodName = ARCANUM_SPELL_TABLE.Name[8].."("..ARCANUM_TRANSLATION.Rank.." "..i..")";
                            CastSpellByName(FoodName, "spell");
                            break;
                        end
                    end
                else
                    CastSpell(ARCANUM_SPELL_TABLE.ID[8], "spell");
                end
            elseif (button == "LeftButton") then
                if ManneCount ~= 0 then
                    if ArcanumConfig.ConsumeFood == 2 then
                        UseContainerItem(ManneLocation[1][1], ManneLocation[1][2]);
                    else
                        UseContainerItem(ManneLocation[table.getn(ManneLocation)][1], ManneLocation[table.getn(ManneLocation)][2]);
                    end
				else
					if FoodCount ~= 0 then
						if ArcanumConfig.ConsumeFood == 2 then
							UseContainerItem(FoodLocation[1][1], FoodLocation[1][2]);
						else
							UseContainerItem(FoodLocation[table.getn(FoodLocation)][1], FoodLocation[table.getn(FoodLocation)][2]);
						end
					end
				end
            else
                ArcanumTradeFood();
            end
        end
    
        -- Si on clic sur le bouton d'eau
        if (type == "Water") then
            if (button == "RightButton") then
                if (UnitExists("target") and UnitIsPlayer("target")) then
                    for i = ARCANUM_SPELL_TABLE.Rank[9], 1, -1 do
                        if UnitLevel("target") >= Water_Minlvl[i] then
                            local WaterName = ARCANUM_SPELL_TABLE.Name[9].."("..ARCANUM_TRANSLATION.Rank.." "..i..")";
                            CastSpellByName(WaterName, "spell");
                            break;
                        end
                    end
                else
                    CastSpell(ARCANUM_SPELL_TABLE.ID[9], "spell");
                end
            elseif (button == "LeftButton") then
                if ManneCount ~= 0 then
                    if ArcanumConfig.ConsumeFood == 2 then
                        UseContainerItem(ManneLocation[1][1], ManneLocation[1][2]);
                    else
                        UseContainerItem(ManneLocation[table.getn(ManneLocation)][1], ManneLocation[table.getn(ManneLocation)][2]);
                    end
                else
					if WaterCount ~= 0 then
	                    if ArcanumConfig.ConsumeFood == 2 then
	                        UseContainerItem(WaterLocation[1][1], WaterLocation[1][2]);
	                    else
	                        UseContainerItem(WaterLocation[table.getn(WaterLocation)][1], WaterLocation[table.getn(WaterLocation)][2]);
	                    end
	                end
				end	
            else
                ArcanumTradeWater();
            end
        end
            
        -- Si on clic sur le bouton de la gemme de mana
        if (type == "ManaGem") then
            if (button == "RightButton") then
			    if (ARCANUM_SPELL_TABLE.ID[53] ~= nil and ManaGemExists[1] == false) then
                    CastSpell(ARCANUM_SPELL_TABLE.ID[53], "spell");
                elseif (ARCANUM_SPELL_TABLE.ID[52] ~= nil and ManaGemExists[2] == false) then
                    CastSpell(ARCANUM_SPELL_TABLE.ID[52], "spell");
                elseif (ARCANUM_SPELL_TABLE.ID[51] ~= nil and ManaGemExists[3] == false) then
                    CastSpell(ARCANUM_SPELL_TABLE.ID[51], "spell");
                elseif (ARCANUM_SPELL_TABLE.ID[50] ~= nil and ManaGemExists[4] == false) then
                    CastSpell(ARCANUM_SPELL_TABLE.ID[50], "spell");
                elseif (ARCANUM_SPELL_TABLE.ID[49] ~= nil and ManaGemExists[5] == false) then
                    CastSpell(ARCANUM_SPELL_TABLE.ID[49], "spell");
                end
            elseif ArcanumConfig.ConsumeGems == 1 then
                if (ManaGemExists[1] == true) then
                    UseContainerItem(ManaGemLocation[1][1], ManaGemLocation[1][2]);
                    if UnitMana("player") ~= UnitManaMax("player") then
                        ManaGemCount = ManaGemCount - 1;
                    end
                elseif (ManaGemExists[2] == true) then
                    UseContainerItem(ManaGemLocation[2][1], ManaGemLocation[2][2]);
                    if UnitMana("player") ~= UnitManaMax("player") then
                        ManaGemCount = ManaGemCount - 1;
                    end
                elseif (ManaGemExists[3] == true) then
                    UseContainerItem(ManaGemLocation[3][1], ManaGemLocation[3][2]);
                    if UnitMana("player") ~= UnitManaMax("player") then
                        ManaGemCount = ManaGemCount - 1;
                    end
                elseif (ManaGemExists[4] == true) then
                    UseContainerItem(ManaGemLocation[4][1], ManaGemLocation[4][2]);
                    if UnitMana("player") ~= UnitManaMax("player") then
                        ManaGemCount = ManaGemCount - 1;
                    end
				elseif (ManaGemExists[5] == true) then
                    UseContainerItem(ManaGemLocation[5][1], ManaGemLocation[4][2]);
                    if UnitMana("player") ~= UnitManaMax("player") then
                        ManaGemCount = ManaGemCount - 1;
                    end	
                end
            elseif ArcanumConfig.ConsumeGems == 2 then
			    if (ManaGemExists[5] == true) then
                    UseContainerItem(ManaGemLocation[5][1], ManaGemLocation[4][2]);
                    if UnitMana("player") ~= UnitManaMax("player") then
                        ManaGemCount = ManaGemCount - 1;
                    end
                elseif (ManaGemExists[4] == true) then
                    UseContainerItem(ManaGemLocation[4][1], ManaGemLocation[4][2]);
                    if UnitMana("player") ~= UnitManaMax("player") then
                        ManaGemCount = ManaGemCount - 1;
                    end
                elseif (ManaGemExists[3] == true) then
                    UseContainerItem(ManaGemLocation[3][1], ManaGemLocation[3][2]);
                    if UnitMana("player") ~= UnitManaMax("player") then
                        ManaGemCount = ManaGemCount - 1;
                    end
                elseif (ManaGemExists[2] == true) then
                    UseContainerItem(ManaGemLocation[2][1], ManaGemLocation[2][2]);
                    if UnitMana("player") ~= UnitManaMax("player") then
                        ManaGemCount = ManaGemCount - 1;
                    end
                elseif (ManaGemExists[1] == true) then
                    UseContainerItem(ManaGemLocation[1][1], ManaGemLocation[1][2]);
                    if UnitMana("player") ~= UnitManaMax("player") then
                        ManaGemCount = ManaGemCount - 1;
                    end
                end 
            end
        end
    end
end

---------------------------------------------------------------------------------------------

-- FONCTIONS DE RECENSEMENT DES SORTS

---------------------------------------------------------------------------------------------

-- Créé la liste des sorts connus par le mage, et les classe par rangs.
function Arcanum_SpellSetup()
	
	local CurrentSpells = {
		ID = {},
		Name = {},
		subName = {},
	};
	
	local spellID = 1;
	local Invisible = 0;
	local InvisibleID = 0;
    JobTable = {};
    
    ARCANUM_PROFESSIONS.ID = {};
    ARCANUM_PROFESSIONS.Texture = {};

	-- On va parcourir tous les sorts possedés par le Mage
	while true do
		local spellName, subSpellName = GetSpellName(spellID, BOOKTYPE_SPELL);
		if not spellName then
			do break end
		end

		if (spellName) then
			-- Pour les sorts avec des rangs numérotés, on compare pour chaque sort les rangs 1 à 1
			-- Le rang suprieur est conservé
			if (string.find(subSpellName, ARCANUM_TRANSLATION.Rank)) then
				local found = false;
            local rank = tonumber(strmatch(subSpellName, "[1-9]*[0-9]"));
					if rank == nil then
						rank = 1;
					end
					for index = 1, #CurrentSpells.Name do
						if string.find(CurrentSpells.Name[index],spellName) then
							found = true;
						if (CurrentSpells.subName[index] < rank) then
							CurrentSpells.ID[index] = spellID;
						CurrentSpells.subName[index] = rank;
						end
					break;
					end
				end 
				-- Les plus grands rangs de chacun des sorts à rang numérotés sont insérés dans la table
				if (not found) then
					table.insert(CurrentSpells.ID, spellID);
					table.insert(CurrentSpells.Name, spellName);
					table.insert(CurrentSpells.subName, rank);
				end
			else
				table.insert(CurrentSpells.ID, spellID);
				table.insert(CurrentSpells.Name, spellName);
				table.insert(CurrentSpells.subName, 0);
                for i = 1, #ARCANUM_PROFESSIONS.Name do
                    if spellName == ARCANUM_PROFESSIONS.Name[i] then
                        table.insert(JobTable,i);
                        ARCANUM_PROFESSIONS.ID[i] = spellID;
                        ARCANUM_PROFESSIONS.Texture[i] = GetSpellTexture(spellID, BOOKTYPE_SPELL);
                    end
                end
			end
		end
		spellID = spellID + 1;
	end
    
	-- On met à jour la liste des sorts d'Arcanum en fonction de la liste complete des sorts de mage
    for spell = 1, #ARCANUM_SPELL_TABLE.Name do
        local find = false;
		for index = 1, #CurrentSpells.Name do
			if (CurrentSpells.Name[index] == ARCANUM_SPELL_TABLE.Name[spell]) then
				ARCANUM_SPELL_TABLE.ID[spell] = CurrentSpells.ID[index];
				ARCANUM_SPELL_TABLE.Rank[spell] = CurrentSpells.subName[index];
				ARCANUM_SPELL_TABLE.Mana[spell] = Arcanum_ManaCost(CurrentSpells.ID[index]);
                ARCANUM_SPELL_TABLE.Texture[spell] = GetSpellTexture(CurrentSpells.ID[index], BOOKTYPE_SPELL);
			end
		end
	end
    
    --On met à jour le "Dernier Portail" si il etait non défini  
    if ArcanumConfig.LastPortal == 1 then
        for i = 15, 19 do
            if ARCANUM_SPELL_TABLE.ID[i] ~= nil then
                ArcanumConfig.LastPortal = i;
                break;
            end
        end
    end

    if ARCANUM_SPELL_TABLE.ID[2] == nil then
        ArcanumConfig.LastArmor = 1;
    end
	
    if ARCANUM_SPELL_TABLE.ID[58] == nil then
        ArcanumConfig.Lastward = 57;
    end
    
    
    ArcanumButtonDisplayTexture = {
        ArcanumButtonDisplayTexture[1],
        ArcanumButtonDisplayTexture[2],
        ARCANUM_SPELL_TABLE.Texture[42],
        ARCANUM_SPELL_TABLE.Texture[37],
        ARCANUM_SPELL_TABLE.Texture[38],
        ARCANUM_SPELL_TABLE.Texture[57],
        ARCANUM_SPELL_TABLE.Texture[58],
        ARCANUM_SPELL_TABLE.Texture[12],
		ARCANUM_SPELL_TABLE.Texture[57],
        ARCANUM_SPELL_TABLE.Texture[39],
    };
end

function Arcanum_ManaCost(spellID)
	Arcanum_MoneyToggle();
	ArcanumTooltip:SetSpell(spellID,1);
	local _, _, ManaCost = string.find(ArcanumTooltipTextLeft2:GetText(), "(%d+)");
	Arcanum_MoneyToggle();
	return tonumber(ManaCost);
end

function Arcanum_MoneyToggle()
	for index=1, 10 do
		local text = getglobal("ArcanumTooltipTextLeft"..index);
        if text ~= nil then
		text:SetText(nil);
		text = getglobal("ArcanumTooltipTextRight"..index);
		text:SetText(nil);
        end
	end
	ArcanumTooltip:Hide();
	ArcanumTooltip:SetOwner(WorldFrame, "ANCHOR_NONE"); 
end

------------------------------------------------------------------------------------------------------

-- FONCTION DE GESTION DES COMMANDES SLASH

------------------------------------------------------------------------------------------------------

-- Gestion de la commande
function Arcanum_Slash(msg)
    if msg == "" then
        if (ArcanumGeneralFrame:IsVisible()) then
            HideUIPanel(ArcanumGeneralFrame);
            return;
        else
            ShowUIPanel(ArcanumGeneralFrame);
            ArcanumGeneralTab_OnClick(1);
            return;
        end
    elseif msg == "buttonswitch" then
        if (ArcanumConfig.InterfaceVersion == 2) then
            if (ArcanumConfig.BuffType == 0) then
                --On passe de 'Solo' à 'en groupe'
                if (ARCANUM_SPELL_TABLE.ID[3] ~= nil or ARCANUM_SPELL_TABLE.ID[13] ~= nil or ARCANUM_SPELL_TABLE.ID[7] ~= nil or ARCANUM_SPELL_TABLE.ID[20] ~= nil or ARCANUM_SPELL_TABLE.ID[21] ~= nil or ARCANUM_SPELL_TABLE.ID[22] ~= nil or ARCANUM_SPELL_TABLE.ID[23] ~= nil or ARCANUM_SPELL_TABLE.ID[24] ~= nil or ARCANUM_SPELL_TABLE.ID[25] ~= nil) then
                    ArcanumConfig.BuffType = 1;
                    Arcanum_Arcanum2ButtonSetup();
                    Arcanum_LoadIconsV2();
                end
            else
                --On passe de 'en groupe' à 'Solo'
                ArcanumConfig.BuffType = 0;
                Arcanum_Arcanum2ButtonSetup();
                Arcanum_LoadIconsV2();
            end
            Arcanum_LoadOrderIcons();
		    GameTooltip:Hide();
        end
    elseif msg == "tradefood" then
        ArcanumTradeFood();
    elseif msg == "tradewater" then
        ArcanumTradeWater();
    end
end

------------------------------------------------------------------------------------------------------

-- FONCTION DE GETION DE L'ICONE DE LA MINIMAP

------------------------------------------------------------------------------------------------------

function Arcanum_MinimapMoveButton()
	ArcanumMinimapButton:SetPoint("TOPLEFT", "Minimap", "TOPLEFT", 52 - (80 * cos(ArcanumConfig.MinimapIconPos)), (80 * sin(ArcanumConfig.MinimapIconPos)) - 52);
end

function ArcanumIconDragging()
	local xpos,ypos = GetCursorPosition()
	local xmin,ymin = Minimap:GetLeft(), Minimap:GetBottom()

	xpos = xmin-xpos/Minimap:GetEffectiveScale()+70
	ypos = ypos/Minimap:GetEffectiveScale()-ymin-70

	ArcanumConfig.IconPos = math.deg(math.atan2(ypos,xpos))
	
    move_button();
end

function move_button()
    local xpos,ypos
	local angle = ArcanumConfig.IconPos or 0

	if ItemRack_Settings.SquareMinimap=="ON" then
		-- brute force method until trig solution figured out - min/max a point on a circle beyond square
		xpos = 110 * cos(angle)
		ypos = 110 * sin(angle)
		xpos = math.max(-82,math.min(xpos,84))
		ypos = math.max(-86,math.min(ypos,82))
	else
		xpos = 80*cos(angle)
		ypos = 80*sin(angle)
	end

	ArcanumMinimapButton:SetPoint("TOPLEFT","Minimap","TOPLEFT",52-xpos,ypos-52)
end

------------------------------------------------------------------------------------------------------

-- FONCTIONS DE GESTION DES BOUTONS DE L'UI

------------------------------------------------------------------------------------------------------

function Arcanum_ButtonSetup()
    if ArcanumConfig.Toggle == true then
        if ArcanumConfig.MinimapIcon == true then
            ShowUIPanel(ArcanumMinimapButton);
        else
            HideUIPanel(ArcanumMinimapButton);
        end
        if (ArcanumConfig.InterfaceVersion == 1) then
            Arcanum_ArcanumButtonSetup();
        else
            Arcanum_Arcanum2ButtonSetup();
        end
	end
end

function Arcanum_ArcanumButtonSetup()
    Arcanum_HideUI2();
    ShowUIPanel(ArcanumButton);
	if (ARCANUM_SPELL_TABLE.ID[8] ~= nil and ArcanumConfig.FoodButton == true) then
		ShowUIPanel(ArcanumButton1);
        ShowUIPanel(OrderButton1);
    else
        HideUIPanel(ArcanumButton1);
        HideUIPanel(OrderButton1);
	end
	if (ARCANUM_SPELL_TABLE.ID[9] ~=nil and ArcanumConfig.WaterButton == true) then
		ShowUIPanel(ArcanumButton2);
        ShowUIPanel(OrderButton2);
    else
        HideUIPanel(ArcanumButton2);
        HideUIPanel(OrderButton2);
	end
	if ((ARCANUM_SPELL_TABLE.ID[49] ~= nil or ARCANUM_SPELL_TABLE.ID[50] ~= nil or ARCANUM_SPELL_TABLE.ID[51] ~= nil or ARCANUM_SPELL_TABLE.ID[52] ~= nil or ARCANUM_SPELL_TABLE.ID[53] ~= nil) and ArcanumConfig.ManaGemButton == true) then
		ShowUIPanel(ArcanumButton3);
        ShowUIPanel(OrderButton3);
    else
        HideUIPanel(ArcanumButton3);
        HideUIPanel(OrderButton3);
	end
    if (table.getn(BuffMenuCreate) > 0 and ArcanumConfig.BuffButton == true) then
		ShowUIPanel(ArcanumButton4);
        ShowUIPanel(OrderButton4);
    else
        HideUIPanel(ArcanumButton4);
        HideUIPanel(OrderButton4);
	end
    if (table.getn(ArmorMenuCreate) > 0 and ArcanumConfig.ArmorButton == true) then
		ShowUIPanel(ArcanumButton5);
        ShowUIPanel(OrderButton5);
    else
        HideUIPanel(ArcanumButton5);
        HideUIPanel(OrderButton5);
	end
	if (table.getn(MagicMenuCreate) > 0 and ArcanumConfig.MagicButton == true) then
		ShowUIPanel(ArcanumButton6);
        ShowUIPanel(OrderButton6);
    else
        HideUIPanel(ArcanumButton6);
        HideUIPanel(OrderButton6);
	end
    if (table.getn(MountMenuCreate) > 0 and ArcanumConfig.MountButton == true) then
		ShowUIPanel(ArcanumButton7);
        ShowUIPanel(OrderButton7);
    else
        HideUIPanel(ArcanumButton7);
        HideUIPanel(OrderButton7);
	end
	if (table.getn(PortalMenuCreate) > 0 and ArcanumConfig.PortalButton == true) then
        ShowUIPanel(ArcanumButton8);
        ShowUIPanel(OrderButton8);
    else
        HideUIPanel(ArcanumButton8);
        HideUIPanel(OrderButton8);
	end
    if (table.getn(JobMenuCreate) > 0 and ArcanumConfig.JobButton == true) then
		ShowUIPanel(ArcanumButton9);
        ShowUIPanel(OrderButton9);
    else
        HideUIPanel(ArcanumButton9);
        HideUIPanel(OrderButton9);
	end
    if (table.getn(WardMenuCreate) > 0 and ArcanumConfig.WardButton == true) then
		ShowUIPanel(ArcanumButton10);
        ShowUIPanel(OrderButton10);
    else
        HideUIPanel(ArcanumButton10);
        HideUIPanel(OrderButton10);
	end
end

function Arcanum_Arcanum2ButtonSetup()
    Arcanum_HideUI1();
    ShowUIPanel(ArcanumButton);
	if (ARCANUM_SPELL_TABLE.ID[8] ~= nil and ArcanumConfig.FoodButton == true) then
        ShowUIPanel(ArcanumButton1);
        ShowUIPanel(OrderButton1);
    else
		HideUIPanel(ArcanumButton1);
        HideUIPanel(OrderButton1);
	end
	if (ARCANUM_SPELL_TABLE.ID[9] ~=nil and ArcanumConfig.WaterButton == true) then
        ShowUIPanel(ArcanumButton2);
        ShowUIPanel(OrderButton2);
    else
        HideUIPanel(ArcanumButton2);
        HideUIPanel(OrderButton2);
    end
	if ((ARCANUM_SPELL_TABLE.ID[49] ~= nil or ARCANUM_SPELL_TABLE.ID[50] ~= nil or ARCANUM_SPELL_TABLE.ID[51] ~= nil or ARCANUM_SPELL_TABLE.ID[52] ~= nil or ARCANUM_SPELL_TABLE.ID[53] ~= nil) and ArcanumConfig.ManaGemButton == true) then
        ShowUIPanel(ArcanumButton3);
        ShowUIPanel(OrderButton3);
    else
        HideUIPanel(ArcanumButton3);
        HideUIPanel(OrderButton3);
	end
	if (ArcanumConfig.LastMount ~= 0 and ArcanumConfig.MountButton == true) then
        ShowUIPanel(ArcanumButton7);
        ShowUIPanel(OrderButton7);
    else
        HideUIPanel(ArcanumButton7);
        HideUIPanel(OrderButton7);
	end
	if (ArcanumConfig.BuffType == 0) then
        HideUIPanel(ArcanumButton52);
		if ((ARCANUM_SPELL_TABLE.ID[1] ~= nil or ARCANUM_SPELL_TABLE.ID[2] ~= nil) and ArcanumConfig.ArmorButton == true) then
            ShowUIPanel(ArcanumButton51);
            ShowUIPanel(OrderButton5);
        else
            HideUIPanel(ArcanumButton51);
            HideUIPanel(OrderButton5);
		end
        HideUIPanel(ArcanumButton42);
		if (ARCANUM_SPELL_TABLE.ID[12] ~= nil and ArcanumConfig.BuffButton == true) then
            ShowUIPanel(ArcanumButton41);
            ShowUIPanel(OrderButton4);
        else
            HideUIPanel(ArcanumButton41);
            HideUIPanel(OrderButton4);
		end
        HideUIPanel(ArcanumButton62);
		if (ARCANUM_SPELL_TABLE.ID[6] ~= nil and ArcanumConfig.MagicButton == true) then
            ShowUIPanel(ArcanumButton61);
            ShowUIPanel(OrderButton6);
        else
            HideUIPanel(ArcanumButton61);
            HideUIPanel(OrderButton6);
		end
        HideUIPanel(ArcanumButton82);
        HideUIPanel(ArcanumButton92);
        HideUIPanel(ArcanumButton102);
		if (ArcanumConfig.PortalButton == true) then
			if (ARCANUM_SPELL_TABLE.ID[15] ~= nil or ARCANUM_SPELL_TABLE.ID[19] ~= nil) then
                ShowUIPanel(ArcanumButton81);

                ShowUIPanel(OrderButton8);
            else
                HideUIPanel(ArcanumButton81);
                HideUIPanel(OrderButton8);
			end
			if (ARCANUM_SPELL_TABLE.ID[16] ~= nil or ARCANUM_SPELL_TABLE.ID[20] ~= nil) then
                ShowUIPanel(ArcanumButton91);
                ShowUIPanel(OrderButton9);
            else
                HideUIPanel(ArcanumButton91);
                HideUIPanel(OrderButton9);
			end
			if (ARCANUM_SPELL_TABLE.ID[17] ~= nil or ARCANUM_SPELL_TABLE.ID[21] ~= nil) then
                ShowUIPanel(ArcanumButton101);
                ShowUIPanel(OrderButton10);
            else
                HideUIPanel(ArcanumButton101);
                HideUIPanel(OrderButton10);
			end
		end
	else
        HideUIPanel(ArcanumButton51);
		if (ARCANUM_SPELL_TABLE.ID[3] ~= nil and ArcanumConfig.ArmorButton == true) then
		    ShowUIPanel(ArcanumButton52);
            ShowUIPanel(OrderButton5);
        else
            HideUIPanel(ArcanumButton52);
            HideUIPanel(OrderButton5);
		end
        HideUIPanel(ArcanumButton41);
		if (ARCANUM_SPELL_TABLE.ID[13] ~= nil and ArcanumConfig.BuffButton == true) then
			ShowUIPanel(ArcanumButton42);
            ShowUIPanel(OrderButton4);
        else
            HideUIPanel(ArcanumButton42);
            HideUIPanel(OrderButton4);
		end
        HideUIPanel(ArcanumButton61);
		if (ARCANUM_SPELL_TABLE.ID[7] ~= nil and ArcanumConfig.MagicButton == true) then
			ShowUIPanel(ArcanumButton62);
            ShowUIPanel(OrderButton6);
        else
            HideUIPanel(ArcanumButton62);
            HideUIPanel(OrderButton6);
		end
        HideUIPanel(ArcanumButton81);
        HideUIPanel(ArcanumButton91);
        HideUIPanel(ArcanumButton101);
		if (ArcanumConfig.PortalButton == true) then
			if (ARCANUM_SPELL_TABLE.ID[23] ~= nil or ARCANUM_SPELL_TABLE.ID[27] ~= nil) then
				ShowUIPanel(ArcanumButton82);
                ShowUIPanel(OrderButton8);
            else
                HideUIPanel(ArcanumButton82);
                HideUIPanel(OrderButton8);
			end
			if (ARCANUM_SPELL_TABLE.ID[24] ~= nil or ARCANUM_SPELL_TABLE.ID[28] ~= nil) then
				ShowUIPanel(ArcanumButton92);
                ShowUIPanel(OrderButton9);
            else
                HideUIPanel(ArcanumButton92);
                HideUIPanel(OrderButton9);
			end
			if (ARCANUM_SPELL_TABLE.ID[25] ~= nil or ARCANUM_SPELL_TABLE.ID[29] ~= nil) then
				ShowUIPanel(ArcanumButton102);
                ShowUIPanel(OrderButton10);
            else
                HideUIPanel(ArcanumButton102);
                HideUIPanel(OrderButton10);
			end
		end
	end
end

function Arcanum_HideUI1()
	HideUIPanel(ArcanumButton1);
	HideUIPanel(ArcanumButton2);
	HideUIPanel(ArcanumButton3);
	HideUIPanel(ArcanumButton4);
	HideUIPanel(ArcanumButton5);
	HideUIPanel(ArcanumButton6);
	HideUIPanel(ArcanumButton7);
	HideUIPanel(ArcanumButton8);
    HideUIPanel(ArcanumButton9);
	HideUIPanel(ArcanumButton10);
end

function Arcanum_HideUI2()
	HideUIPanel(ArcanumButton11);
	HideUIPanel(ArcanumButton21);
	HideUIPanel(ArcanumButton31);
	HideUIPanel(ArcanumButton41);
	HideUIPanel(ArcanumButton51);
	HideUIPanel(ArcanumButton61);
	HideUIPanel(ArcanumButton71);
	HideUIPanel(ArcanumButton81);
    HideUIPanel(ArcanumButton91);
	HideUIPanel(ArcanumButton101);
    HideUIPanel(ArcanumButton12);
	HideUIPanel(ArcanumButton22);
	HideUIPanel(ArcanumButton32);
	HideUIPanel(ArcanumButton42);
	HideUIPanel(ArcanumButton52);
	HideUIPanel(ArcanumButton62);
	HideUIPanel(ArcanumButton72);
	HideUIPanel(ArcanumButton82);
    HideUIPanel(ArcanumButton92);
	HideUIPanel(ArcanumButton102);
end

function Arcanum_HideUI()
    HideUIPanel(ArcanumMinimapButton);
    HideUIPanel(ArcanumButton);
    if (ArcanumConfig.InterfaceVersion == 1) then
        Arcanum_HideUI2();
    else
        Arcanum_HideUI1();
    end
end

function Arcanum_InitButtons()
    ArcanumButton:SetPoint("CENTER", "UIParent", "BOTTOMLEFT", ArcanumConfig.ArcanumButtonxPos, ArcanumConfig.ArcanumButtonyPos);
	ArcanumButton1:SetPoint("CENTER", "ArcanumButton", "CENTER", 0, 48);
	ArcanumButton2:SetPoint("CENTER", "ArcanumButton", "CENTER", 28, 39);
	ArcanumButton3:SetPoint("CENTER", "ArcanumButton", "CENTER", 45, 15);
	ArcanumButton4:SetPoint("CENTER", "ArcanumButton", "CENTER", 45, -15);
   	ArcanumButton5:SetPoint("CENTER", "ArcanumButton", "CENTER", 28, -39);
	ArcanumButton6:SetPoint("CENTER", "ArcanumButton", "CENTER", 0, -48);
	ArcanumButton7:SetPoint("CENTER", "ArcanumButton", "CENTER", -28, 39);
    ArcanumButton8:SetPoint("CENTER", "ArcanumButton", "CENTER", -45, 15);
	ArcanumButton9:SetPoint("CENTER", "ArcanumButton", "CENTER", -45, -15);
	ArcanumButton10:SetPoint("CENTER", "ArcanumButton", "CENTER", -28, -39);
    
	ArcanumButton41:SetPoint("CENTER", "ArcanumButton", "CENTER", 45, 15);
   	ArcanumButton51:SetPoint("CENTER", "ArcanumButton", "CENTER", 45, -15);
	ArcanumButton61:SetPoint("CENTER", "ArcanumButton", "CENTER", 28, -39);
--~ 	ArcanumButton71:SetPoint("CENTER", "ArcanumButton", "CENTER", -28, 39);
	ArcanumButton81:SetPoint("CENTER", "ArcanumButton", "CENTER", -45, 15);
	ArcanumButton91:SetPoint("CENTER", "ArcanumButton", "CENTER", -45, -15);
	ArcanumButton101:SetPoint("CENTER", "ArcanumButton", "CENTER", -28, -39);
	ArcanumButton42:SetPoint("CENTER", "ArcanumButton", "CENTER", 45, 15);
   	ArcanumButton52:SetPoint("CENTER", "ArcanumButton", "CENTER", 45, -15);
	ArcanumButton62:SetPoint("CENTER", "ArcanumButton", "CENTER", 28, -39);
--~ 	ArcanumButton72:SetPoint("CENTER", "ArcanumButton", "CENTER", -28, 39);
	ArcanumButton82:SetPoint("CENTER", "ArcanumButton", "CENTER", -45, 15);
	ArcanumButton92:SetPoint("CENTER", "ArcanumButton", "CENTER", -45, -15);
	ArcanumButton102:SetPoint("CENTER", "ArcanumButton", "CENTER", -28, -39);
end

function Arcanum_ButtonAttribute()
    ButtonQueuedAttribute = {
        {nil, nil},
        {nil, nil},
        {nil, nil},
        {ArcanumConfig.LastBuff, nil},
        {ArcanumConfig.LastArmor, nil},
        {ArcanumConfig.LastMagic, nil},
        {ArcanumConfig.LastMount, nil},
        {ArcanumConfig.LastPortal, nil},
        {ArcanumConfig.LastJob, nil},
        {ArcanumConfig.LastWard, nil},
    };

    Arcanum_Bindings();
    Arcanum_UpdateCentralButon();

    ArcanumButton1:SetAttribute("type1", "item");
    ArcanumButton1:SetAttribute("item1", ARCANUM_FOOD[ARCANUM_SPELL_TABLE.Rank[8]]);
    ArcanumButton1:SetAttribute("type2", "spell");
    ArcanumButton1:SetAttribute("spell2", ARCANUM_SPELL_TABLE.Name[8]);
    ArcanumButton1:SetAttribute("type3", "macro");
    ArcanumButton1:SetAttribute("macrotext", "/arca tradefood");

    ArcanumButton2:SetAttribute("type1", "item");
    ArcanumButton2:SetAttribute("item1", ARCANUM_WATER[ARCANUM_SPELL_TABLE.Rank[9]]);
    ArcanumButton2:SetAttribute("type2", "spell");
    ArcanumButton2:SetAttribute("spell2", ARCANUM_SPELL_TABLE.Name[9]);
    ArcanumButton2:SetAttribute("type3", "macro");
    ArcanumButton2:SetAttribute("macrotext", "/arca tradewater");

    Arcanum_UpdateManaGem();
    
    Arcanum_UpdateBuffButton();
    
    Arcanum_UpdateArmorButton();
    
    Arcanum_UpdateMagicButton();

    if #MountMenuCreate > 0 then
        ArcanumButton7:SetAttribute("type1", "item");
        ArcanumButton7:SetAttribute("bag1", MountLocation[1][1]);
        ArcanumButton7:SetAttribute("slot1", MountLocation[1][2]);
        ArcanumButton7:SetAttribute("type3", "item");
        ArcanumButton7:SetAttribute("item3", ARCANUM_ITEM.Hearthstone);
    end
    for i = 1, 7 do
        if i <= #MountLocation then
            getglobal("ArcanumButton7Menu"..i):SetAttribute("type1", "item");
            getglobal("ArcanumButton7Menu"..i):SetAttribute("bag1", MountLocation[i][1]);
            getglobal("ArcanumButton7Menu"..i):SetAttribute("slot1", MountLocation[i][2]);
        end
    end
    
    ArcanumButton8:SetAttribute("type1", "spell");
    ArcanumButton8:SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[ArcanumConfig.LastPortal]);
    for i = 1, 13 do
        if i <= 4 then
            getglobal("ArcanumButton8Menu"..i):SetAttribute("type1", "spell");
            if ARCANUM_SPELL_TABLE.ID[i+14] ~= nil then
                getglobal("ArcanumButton8Menu"..i):SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[i+14]);
            elseif ARCANUM_SPELL_TABLE.ID[i+18] ~= nil then
                getglobal("ArcanumButton8Menu"..i):SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[i+18]);
            end
		elseif i == 5 then
            getglobal("ArcanumButton8Menu"..i):SetAttribute("type1", "spell");
            if ARCANUM_SPELL_TABLE.ID[45] ~= nil then
                getglobal("ArcanumButton8Menu"..i):SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[45]);
			elseif ARCANUM_SPELL_TABLE.ID[47] ~= nil then
                getglobal("ArcanumButton8Menu"..i):SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[47]);
            end  	
        elseif i == 6 then
            getglobal("ArcanumButton8Menu"..i):SetAttribute("type1", "spell");
            if ARCANUM_SPELL_TABLE.ID[40] ~= nil then
                getglobal("ArcanumButton8Menu"..i):SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[40]);
            end
        elseif i >= 7 and i <= 10 then
            getglobal("ArcanumButton8Menu"..i):SetAttribute("type1", "spell");
            if ARCANUM_SPELL_TABLE.ID[23] ~= nil then
                getglobal("ArcanumButton8Menu"..i):SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[i+16]);
            elseif ARCANUM_SPELL_TABLE.ID[27] ~= nil then
                getglobal("ArcanumButton8Menu"..i):SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[i+20]);
            end
		elseif i == 11 then
            getglobal("ArcanumButton8Menu"..i):SetAttribute("type1", "spell");
            if ARCANUM_SPELL_TABLE.ID[44] ~= nil then
                getglobal("ArcanumButton8Menu"..i):SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[44]);
				elseif ARCANUM_SPELL_TABLE.ID[46] ~= nil then
                getglobal("ArcanumButton8Menu"..i):SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[46]);
            end	
        elseif i == 12 then
            getglobal("ArcanumButton8Menu"..i):SetAttribute("type1", "spell");
            if ARCANUM_SPELL_TABLE.ID[41] ~= nil then
                getglobal("ArcanumButton8Menu"..i):SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[41]);
            end
        elseif i == 13 then
            getglobal("ArcanumButton8Menu"..i):SetAttribute("type1", "spell");
            if ARCANUM_SPELL_TABLE.ID[43] ~= nil then
                getglobal("ArcanumButton8Menu"..i):SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[43]);
            end           
        end
    end
    
    ArcanumButton9:SetAttribute("type1", "spell");
    ArcanumButton9:SetAttribute("spell", ARCANUM_PROFESSIONS.Name[JobTable[ArcanumConfig.LastJob]]);
    for i = 1, 7 do
        getglobal("ArcanumButton9Menu"..i):SetAttribute("type1", "spell");
        getglobal("ArcanumButton9Menu"..i):SetAttribute("spell", ARCANUM_PROFESSIONS.Name[JobTable[i]]);
    end
    
    Arcanum_UpdateWardButton();
    
    
--~     UI2
    ArcanumButton41:SetAttribute("type", "spell");
    ArcanumButton41:SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[12]);
    ArcanumButton42:SetAttribute("type", "spell");
    ArcanumButton42:SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[13]);
    
    if ARCANUM_SPELL_TABLE.ID[2] ~= nil then
        ArcanumButton51:SetAttribute("type", "spell");
        ArcanumButton51:SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[2]);
    else
        ArcanumButton51:SetAttribute("type", "spell");
        ArcanumButton51:SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[1]);
    end
    ArcanumButton52:SetAttribute("type", "spell");
    ArcanumButton52:SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[3]);
    
    ArcanumButton61:SetAttribute("type", "spell");
    ArcanumButton61:SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[6]);
    ArcanumButton62:SetAttribute("type", "spell");
    ArcanumButton62:SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[7]);
    
    ArcanumButton71:SetAttribute("type", "spell");
    ArcanumButton71:SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[12]);
    
    if ARCANUM_SPELL_TABLE.ID[15] ~= nil then
        ArcanumButton81:SetAttribute("type", "spell");
        ArcanumButton81:SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[15]);
        ArcanumButton82:SetAttribute("type", "spell");
        ArcanumButton82:SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[23]);
    elseif ARCANUM_SPELL_TABLE.ID[19] ~= nil then
        ArcanumButton81:SetAttribute("type", "spell");
        ArcanumButton81:SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[19]);
        ArcanumButton82:SetAttribute("type", "spell");
        ArcanumButton82:SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[27]);
    end
    
    if ARCANUM_SPELL_TABLE.ID[16] ~= nil then
        ArcanumButton91:SetAttribute("type", "spell");
        ArcanumButton91:SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[16]);
        ArcanumButton92:SetAttribute("type", "spell");
        ArcanumButton92:SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[24]);
    elseif ARCANUM_SPELL_TABLE.ID[20] ~= nil then
        ArcanumButton91:SetAttribute("type", "spell");
        ArcanumButton91:SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[20]);
        ArcanumButton92:SetAttribute("type", "spell");
        ArcanumButton92:SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[28]);
    end
    
    if ARCANUM_SPELL_TABLE.ID[17] ~= nil then
        ArcanumButton101:SetAttribute("type", "spell");
        ArcanumButton101:SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[17]);
        ArcanumButton102:SetAttribute("type", "spell");
        ArcanumButton102:SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[25]);
    elseif ARCANUM_SPELL_TABLE.ID[21] ~= nil then
        ArcanumButton101:SetAttribute("type", "spell");
        ArcanumButton101:SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[21]);
        ArcanumButton102:SetAttribute("type", "spell");
        ArcanumButton102:SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[29]);
    end
end

function Arcanum_UpdateCentralButon()
    local EatDrink;
	if ManneCount > 0 and ((UnitHealth("Player") <= UnitHealthMax("Player")) or (UnitMana("Player") <= UnitManaMax("Player"))) then
		EatDrink = "/use "..ARCANUM_MANNE[1]
	elseif ARCANUM_FOOD[ARCANUM_SPELL_TABLE.Rank[8]] ~= nil and (UnitHealth("Player") < UnitHealthMax("Player")) then
		EatDrink = "/use "..ARCANUM_FOOD[ARCANUM_SPELL_TABLE.Rank[8]]
        if ARCANUM_WATER[ARCANUM_SPELL_TABLE.Rank[9]] ~= nil and (UnitMana("Player") < UnitManaMax("Player")) then
           EatDrink = EatDrink.."\n/use "..ARCANUM_WATER[ARCANUM_SPELL_TABLE.Rank[9]]
        end
	elseif ARCANUM_WATER[ARCANUM_SPELL_TABLE.Rank[9]] ~= nil and (UnitMana("Player") < UnitManaMax("Player")) then
        EatDrink = "/use "..ARCANUM_WATER[ARCANUM_SPELL_TABLE.Rank[9]]
    end


    ArcanumButtonClick = {
    {"spell","spell",ARCANUM_SPELL_TABLE.Name[42]},
    {"macro","macrotext",EatDrink},
    {"macro","macrotext","/arca buttonswitch"},
    {"macro","macrotext","/arca"},
    {"item","item",ARCANUM_MANAGEM[5]},
    {"spell","spell",ARCANUM_SPELL_TABLE.Name[37]},
    {"item","item",ARCANUM_ITEM.Hearthstone},
    {"spell","spell",ARCANUM_SPELL_TABLE.Name[38]},
    };

    ArcanumButton:SetAttribute("type1", ArcanumButtonClick[ArcanumConfig.LeftClick][1]);
    ArcanumButton:SetAttribute(ArcanumButtonClick[ArcanumConfig.LeftClick][2].."1", ArcanumButtonClick[ArcanumConfig.LeftClick][3]);
    ArcanumButton:SetAttribute("type2", ArcanumButtonClick[ArcanumConfig.RightClick][1]);
    ArcanumButton:SetAttribute(ArcanumButtonClick[ArcanumConfig.RightClick][2].."2", ArcanumButtonClick[ArcanumConfig.RightClick][3]);
    ArcanumButton:SetAttribute("type3", ArcanumButtonClick[ArcanumConfig.MiddleClick][1]);
    ArcanumButton:SetAttribute(ArcanumButtonClick[ArcanumConfig.MiddleClick][2].."3", ArcanumButtonClick[ArcanumConfig.MiddleClick][3]);

end

function Arcanum_UpdateManaGem()
  --Recherche de la prochaine gem à utiliser
    if ManaGemCount > 0 then
        for i = 1, 5 do
            if ArcanumConfig.ConsumeGems == 1 then
                if ManaGemExists[i] == true then
                    ArcanumButton3:SetAttribute("type1", "item");
                    ArcanumButton3:SetAttribute("item1", ARCANUM_MANAGEM[(6-i)]);
                    break;
                end
                else    
                if ManaGemExists[(6-i)] == true then
                    ArcanumButton3:SetAttribute("type1", "item");
                    ArcanumButton3:SetAttribute("item1", ARCANUM_MANAGEM[i]);
                    break;
                end
            end        
        end  
    end

  --Recherche de la prochaine gem à summoner              
    for i = 1, 5 do
        if (ManaGemExists[i] == false) and (ARCANUM_SPELL_TABLE.ID[(54-i)] ~= nil) then
            ArcanumButton3:SetAttribute("type2", "spell");
            ArcanumButton3:SetAttribute("spell2", ARCANUM_SPELL_TABLE.Name[(54-i)]);
            break;
        end
    end
end


function Arcanum_UpdateBuffButton()
    if ArcanumConfig.LastBuff == 12 then
        LastBuff = 13;
    elseif ArcanumConfig.LastBuff == 13 then
        LastBuff = 12;
    end
    ButtonQueuedAttribute[4][2] = LastBuff;
    ArcanumButton4:SetAttribute("type1", "spell");
    ArcanumButton4:SetAttribute("spell1", ARCANUM_SPELL_TABLE.Name[ArcanumConfig.LastBuff]);
    ArcanumButton4:SetAttribute("type3", "spell");
    ArcanumButton4:SetAttribute("spell3", ARCANUM_SPELL_TABLE.Name[LastBuff]);
    ArcanumButton4Menu1:SetAttribute("type", "spell");
    ArcanumButton4Menu1:SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[12]);--.."("..ARCANUM_TRANSLATION.Rank.." "..ARCANUM_SPELL_TABLE.Rank[4]..")");
    ArcanumButton4Menu2:SetAttribute("type", "spell");
    ArcanumButton4Menu2:SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[13]);
end

function Arcanum_UpdateArmorButton()
    if ArcanumConfig.LastArmor == 2 then
        LastArmor = 3;
    elseif ArcanumConfig.LastArmor == 3 then
        LastArmor = 2;
    end
    ButtonQueuedAttribute[5][2] = LastArmor;
    ArcanumButton5:SetAttribute("type1", "spell");
    ArcanumButton5:SetAttribute("spell1", ARCANUM_SPELL_TABLE.Name[ArcanumConfig.LastArmor]);
    ArcanumButton5:SetAttribute("type3", "spell");
    ArcanumButton5:SetAttribute("spell3", ARCANUM_SPELL_TABLE.Name[LastArmor]);
    if (ARCANUM_SPELL_TABLE.ID[2] ~= nil) then
        ArcanumButton5Menu1:SetAttribute("type", "spell");
        ArcanumButton5Menu1:SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[2]);
    else
        ArcanumButton5Menu1:SetAttribute("type", "spell");
        ArcanumButton5Menu1:SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[1]);
    end
    ArcanumButton5Menu2:SetAttribute("type", "spell");
    ArcanumButton5Menu2:SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[3]);
    ArcanumButton5Menu3:SetAttribute("type", "spell");
    ArcanumButton5Menu3:SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[4]);
end

function Arcanum_UpdateMagicButton()
    if ArcanumConfig.LastMagic == 6 then
        LastMagic = 7;
    elseif ArcanumConfig.LastMagic == 7 then
        LastMagic = 6;
    end
    ButtonQueuedAttribute[6][2] = LastMagic;
    ArcanumButton6:SetAttribute("type1", "spell");
    ArcanumButton6:SetAttribute("spell1", ARCANUM_SPELL_TABLE.Name[ArcanumConfig.LastMagic]);
    ArcanumButton6:SetAttribute("type3", "spell");
    ArcanumButton6:SetAttribute("spell3", ARCANUM_SPELL_TABLE.Name[LastMagic]);
    ArcanumButton6Menu1:SetAttribute("type", "spell");
    ArcanumButton6Menu1:SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[6]);
    ArcanumButton6Menu2:SetAttribute("type", "spell");
    ArcanumButton6Menu2:SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[7]);
end


function Arcanum_UpdateWardButton()
    if ArcanumConfig.LastWard == 57 then
        LastWard = 58;
    elseif ArcanumConfig.LastWard == 58 then
        LastWard = 57;
    end
    ButtonQueuedAttribute[10][2] = LastWard;
    ArcanumButton10:SetAttribute("type1", "spell");
    ArcanumButton10:SetAttribute("spell1", ARCANUM_SPELL_TABLE.Name[ArcanumConfig.LastWard]);
    ArcanumButton10:SetAttribute("type3", "spell");
    ArcanumButton10:SetAttribute("spell3", ARCANUM_SPELL_TABLE.Name[LastWard]);
    ArcanumButton10Menu1:SetAttribute("type", "spell");
    ArcanumButton10Menu1:SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[57]);
    ArcanumButton10Menu2:SetAttribute("type", "spell");
    ArcanumButton10Menu2:SetAttribute("spell", ARCANUM_SPELL_TABLE.Name[58]);
end

function Arcanum_Bindings()
	ArcanumBinding = {
--~         {BINDING_NAME_ACTIVATE, "CLICK SecureButtonName1:LeftButton"},
        {BINDING_NAME_STEED, "CLICK ArcanumButton7:LeftButton"},
        {BINDING_NAME_FROSTARMOR, "CLICK ArcanumButton5Menu1:LeftButton"},--
        {BINDING_NAME_MAGEARMOR, "CLICK ArcanumButton5Menu2:LeftButton"},--
        {BINDING_NAME_FIREARMOR, "CLICK ArcanumButton5Menu3:LeftButton"},--
        {BINDING_NAME_ARCANEINTELLECT, "CLICK ArcanumButton4Menu1:LeftButton"},--
        {BINDING_NAME_ARCANEBRILLIANCE, "CLICK ArcanumButton4Menu2:LeftButton"},--
        {BINDING_NAME_AMPLIFYMAGIC, "CLICK ArcanumButton6Menu1:LeftButton"},--
        {BINDING_NAME_DAMPENMAGIC, "CLICK ArcanumButton6Menu2:LeftButton"},--
        {BINDING_NAME_CONJUREFOOD, "CLICK ArcanumButton1:RightButton"},--
        {BINDING_NAME_USEFOOD, "CLICK ArcanumButton1:LeftButton"},--
        {BINDING_NAME_CONJUREWATER, "CLICK ArcanumButton2:RightButton"},--
        {BINDING_NAME_USEWATER, "CLICK ArcanumButton2:LeftButton"},--
        {BINDING_NAME_USEFOODWATER, "CLICK ArcanumButton1:LeftButton"},
        {BINDING_NAME_CONJUREMANAGEM, "CLICK ArcanumButton3:RightButton"},--
        {BINDING_NAME_USEMANAGEM, "CLICK ArcanumButton3:LeftButton"},--
--~         {BINDING_NAME_EVOCATION, "CLICK SecureButtonName1:LeftButton"},
        {BINDING_NAME_TELEPORT1, "CLICK ArcanumButton8Menu1:LeftButton"},--
        {BINDING_NAME_TELEPORT2, "CLICK ArcanumButton8Menu2:LeftButton"},--
        {BINDING_NAME_TELEPORT3, "CLICK ArcanumButton8Menu3:LeftButton"},--
        {BINDING_NAME_TELEPORT4, "CLICK ArcanumButton8Menu4:LeftButton"},--
        {BINDING_NAME_TELEPORT5, "CLICK ArcanumButton8Menu5:LeftButton"},--
        {BINDING_NAME_TELEPORT6, "CLICK ArcanumButton8Menu6:LeftButton"},--        
        {BINDING_NAME_PORTAL1, "CLICK ArcanumButton8Menu7:LeftButton"},--
        {BINDING_NAME_PORTAL2, "CLICK ArcanumButton8Menu8:LeftButton"},--
        {BINDING_NAME_PORTAL3, "CLICK ArcanumButton8Menu9:LeftButton"},--
        {BINDING_NAME_PORTAL4, "CLICK ArcanumButton8Menu10:LeftButton"},--
        {BINDING_NAME_PORTAL5, "CLICK ArcanumButton8Menu11:LeftButton"},--
        {BINDING_NAME_PORTAL6, "CLICK ArcanumButton8Menu12:LeftButton"},--
        {BINDING_NAME_PORTAL7, "CLICK ArcanumButton8Menu13:LeftButton"},--        
        {BINDING_NAME_WARD1, "CLICK ArcanumButton10Menu1:LeftButton"},--
        {BINDING_NAME_WARD2, "CLICK ArcanumButton10Menu2:LeftButton"},--
	}
end
------------------------------------------------------------------------------------------------------

-- FONCTIONS DE GESTION DES ICONES DE L'UI

------------------------------------------------------------------------------------------------------

function Arcanum_LoadIconsV2()
    ArcanumButton41Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[12]);
    ArcanumButton42Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[13]);
    
    ArcanumButton51Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[2]);
    ArcanumButton52Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[3]);
    
    ArcanumButton61Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[6]);
    ArcanumButton62Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[7]);
    
    if ArcanumConfig.BuffType == 0 then
        for i = 15, 16 do
            if (ARCANUM_SPELL_TABLE.ID[i] ~= nil) then
                getglobal("ArcanumButton"..(i-7).."1Texture"):SetTexture(ARCANUM_SPELL_TABLE.Texture[i]);
            elseif (ARCANUM_SPELL_TABLE.ID[i+3] ~= nil) then
                getglobal("ArcanumButton"..(i-7).."1Texture"):SetTexture(ARCANUM_SPELL_TABLE.Texture[i+4]);
            end
        end
    else
        for i = 23, 27 do
            if (ARCANUM_SPELL_TABLE.ID[i] ~= nil) then
                getglobal("ArcanumButton"..(i-15).."2Texture"):SetTexture(ARCANUM_SPELL_TABLE.Texture[i]);
            elseif (ARCANUM_SPELL_TABLE.ID[i+3] ~= nil) then
                getglobal("ArcanumButton"..(i-15).."2Texture"):SetTexture(ARCANUM_SPELL_TABLE.Texture[i+4]);
            end
        end
    end
end

function Arcanum_LoadIconsV1()
    ArcanumButton4Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[ArcanumConfig.LastBuff]);
    ArcanumButton4Menu1Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[12]);
    ArcanumButton4Menu2Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[13]);
    
    ArcanumButton5Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[ArcanumConfig.LastArmor]);
    
    if (ARCANUM_SPELL_TABLE.ID[2] ~= nil) then
        ArcanumButton5Menu1Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[2]);
    else
        ArcanumButton5Menu1Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[1]);
    end
    
    ArcanumButton5Menu2Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[3]);
    ArcanumButton5Menu3Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[4]);
    
    ArcanumButton6Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[ArcanumConfig.LastMagic]);
    ArcanumButton6Menu1Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[6]);
    ArcanumButton6Menu2Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[7]);
    
    ArcanumButton8Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[ArcanumConfig.LastPortal]);
    for i = 15, 18 do
        if (ARCANUM_SPELL_TABLE.ID[i] ~= nil) then
            getglobal("ArcanumButton8Menu"..(i-14).."Texture"):SetTexture(ARCANUM_SPELL_TABLE.Texture[i]);
        elseif (ARCANUM_SPELL_TABLE.ID[i+4] ~= nil) then
            getglobal("ArcanumButton8Menu"..(i-14).."Texture"):SetTexture(ARCANUM_SPELL_TABLE.Texture[i+4]);
        end
    end
	getglobal("ArcanumButton8Menu5Texture"):SetTexture(ARCANUM_SPELL_TABLE.Texture[45]);
    getglobal("ArcanumButton8Menu6Texture"):SetTexture(ARCANUM_SPELL_TABLE.Texture[40]);
    for i = 23, 26 do
        if (ARCANUM_SPELL_TABLE.ID[i] ~= nil) then
            getglobal("ArcanumButton8Menu"..(i-16).."Texture"):SetTexture(ARCANUM_SPELL_TABLE.Texture[i]);
        elseif (ARCANUM_SPELL_TABLE.ID[i+4] ~= nil) then
            getglobal("ArcanumButton8Menu"..(i-16).."Texture"):SetTexture(ARCANUM_SPELL_TABLE.Texture[i+4]);
        end
    end
	getglobal("ArcanumButton8Menu11Texture"):SetTexture(ARCANUM_SPELL_TABLE.Texture[44]);
    getglobal("ArcanumButton8Menu12Texture"):SetTexture(ARCANUM_SPELL_TABLE.Texture[41]);
    getglobal("ArcanumButton8Menu13Texture"):SetTexture(ARCANUM_SPELL_TABLE.Texture[43]);
   
    
            
    ArcanumButton9Texture:SetTexture(ARCANUM_PROFESSIONS.Texture[JobTable[ArcanumConfig.LastJob]]);
    for i = 1, #JobTable do
        getglobal("ArcanumButton9Menu"..(i).."Texture"):SetTexture(ARCANUM_PROFESSIONS.Texture[JobTable[i]]);
    end
    
    ArcanumButton10Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[ArcanumConfig.LastWard]);
    ArcanumButton10Menu1Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[57]);
    ArcanumButton10Menu2Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[58]);
end

function Arcanum_LoadIconsV()

    
    CoolDown[1][3] = HearthstoneLocation[1];
    CoolDown[1][4] = HearthstoneLocation[2];
    CoolDown[2][3] = ManaGemLocation[1][1];
    CoolDown[2][4] = ManaGemLocation[1][2];
    CoolDown[3][3] = ARCANUM_SPELL_TABLE.ID[42];
    CoolDown[4][3] = ARCANUM_SPELL_TABLE.ID[37];
    CoolDown[5][3] = ARCANUM_SPELL_TABLE.ID[38];
    CoolDown[6][3] = ARCANUM_SPELL_TABLE.ID[57];
    CoolDown[7][3] = ARCANUM_SPELL_TABLE.ID[58];
    CoolDown[8][3] = ARCANUM_SPELL_TABLE.ID[39];
    CoolDown[9][3] = nil;
    CoolDown[10][3] = nil;
    
    for i = 1, 10 do
        getglobal("ArcanumButton"..i.."Texture2"):SetTexture(UIPath.."ButtonCircle");
        --getglobal("ArcanumButton"..i.."Texture2"):SetTexCoord(0,1,0,1);
        getglobal("OrderButton"..i.."Texture2"):SetTexture(UIPath.."ButtonCircle");
        --getglobal("OrderButton"..i.."Texture2"):SetTexCoord(0.07,0.93,0.07,0.93);
        if i == 4 or i == 6 or i == 10 then
            for j = 1, 2 do
                getglobal("ArcanumButton"..i.."Menu"..j.."Texture2"):SetTexture(UIPath.."ButtonCircle");
                --getglobal("ArcanumButton"..i.."Menu"..j.."Texture2"):SetTexCoord(0.07,0.93,0.07,0.93);
            end
        elseif i == 5 then
            for j = 1, 3 do
                getglobal("ArcanumButton"..i.."Menu"..j.."Texture2"):SetTexture(UIPath.."ButtonCircle");
                --getglobal("ArcanumButton"..i.."Menu"..j.."Texture2"):SetTexCoord(0.07,0.93,0.07,0.93);
            end
        elseif i == 7 then
            for j = 1, 10 do
                getglobal("ArcanumButton"..i.."Menu"..j.."Texture2"):SetTexture(UIPath.."ButtonCircle");
                --getglobal("ArcanumButton"..i.."Menu"..j.."Texture2"):SetTexCoord(0.07,0.93,0.07,0.93);
            end
        elseif i == 8 then
            for j = 1, 13 do
                getglobal("ArcanumButton"..i.."Menu"..j.."Texture2"):SetTexture(UIPath.."ButtonCircle");
                --getglobal("ArcanumButton"..i.."Menu"..j.."Texture2"):SetTexCoord(0.07,0.93,0.07,0.93);
            end
        elseif i == 9 then
            for j = 1, #JobTable do
                getglobal("ArcanumButton"..i.."Menu"..j.."Texture2"):SetTexture(UIPath.."ButtonCircle");
                --getglobal("ArcanumButton"..i.."Menu"..j.."Texture2"):SetTexCoord(0.07,0.93,0.07,0.93);
            end
            
        end
    end
    for i = 4, 10 do
        getglobal("ArcanumButton"..i.."1Texture2"):SetTexture(UIPath.."ButtonCircle");
        getglobal("ArcanumButton"..i.."2Texture2"):SetTexture(UIPath.."ButtonCircle");
    end
    
    if ARCANUM_SPELL_TABLE.Rank[8] ~= nil then
        ArcanumButton1Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[8]);
        OrderButton1Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[8]);
    end
    
    if ARCANUM_SPELL_TABLE.Rank[9] ~= nil then
        ArcanumButton2Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[9]);
        OrderButton2Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[9]);
    end
    
    Arcanum_ManaGemIcons();
    
    if ArcanumConfig.LastMount ~= 0 then
        ArcanumButton7Texture:SetTexture(MountIcon[ArcanumConfig.LastMount]);
        OrderButton7Texture:SetTexture(MountIcon[ArcanumConfig.LastMount]);
	end
    for i = 1, 10 do
        getglobal("ArcanumButton7Menu"..i.."Texture"):SetTexture(MountIcon[i]);
    end
end

function Arcanum_LoadIcons()
    Arcanum_LoadIconsV();
    Arcanum_LoadIconsV1();
    Arcanum_LoadIconsV2();
    Arcanum_LoadOrderIcons();
    Arcanum_EDIcons();
end

function Arcanum_LoadOrderIcons()
    if ArcanumConfig.InterfaceVersion == 1 then
        OrderButton4Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[ArcanumConfig.LastBuff]);
        OrderButton5Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[ArcanumConfig.LastArmor]);
        OrderButton6Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[ArcanumConfig.LastMagic]);   
        OrderButton8Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[ArcanumConfig.LastPortal]);
        OrderButton9Texture:SetTexture(ARCANUM_PROFESSIONS.Texture[JobTable[ArcanumConfig.LastJob]]);
        OrderButton10Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[ArcanumConfig.LastWard]);
    else
        OrderButton4Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[12 + ArcanumConfig.BuffType]);
        OrderButton5Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[2 + ArcanumConfig.BuffType]);
        OrderButton6Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[6 + ArcanumConfig.BuffType]);
        if ArcanumConfig.BuffType == 0 then
        for i = 15, 18 do
            if (ARCANUM_SPELL_TABLE.ID[i] ~= nil) then
                getglobal("OrderButton"..(i-7).."Texture"):SetTexture(ARCANUM_SPELL_TABLE.Texture[i]);
            elseif (ARCANUM_SPELL_TABLE.ID[i+4] ~= nil) then
                getglobal("OrderButton"..(i-7).."Texture"):SetTexture(ARCANUM_SPELL_TABLE.Texture[i+4]);
            end
        end
    else
        for i = 23, 26 do
            if (ARCANUM_SPELL_TABLE.ID[i] ~= nil) then
                getglobal("OrderButton"..(i-15).."Texture"):SetTexture(ARCANUM_SPELL_TABLE.Texture[i]);
            elseif (ARCANUM_SPELL_TABLE.ID[i+4] ~= nil) then
                getglobal("OrderButton"..(i-15).."Texture"):SetTexture(ARCANUM_SPELL_TABLE.Texture[i+4]);
            end
        end
    end
    end
end

function Arcanum_ManaGemIcons()
    if (ManaGemExists[1] == true) then
        ArcanumButton3Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[53]);
        OrderButton3Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[53]);
        ArcanumButtonDisplayTexture[2] = ARCANUM_SPELL_TABLE.Texture[53];
    elseif (ManaGemExists[2] == true) then
        ArcanumButton3Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[52]);
        OrderButton3Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[52]);
        ArcanumButtonDisplayTexture[2] = ARCANUM_SPELL_TABLE.Texture[52];
	elseif (ManaGemExists[3] == true) then
        ArcanumButton3Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[51]);
        OrderButton3Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[51]);
        ArcanumButtonDisplayTexture[2] = ARCANUM_SPELL_TABLE.Texture[51];
	elseif (ManaGemExists[4] == true) then
        ArcanumButton3Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[50]);
        OrderButton3Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[50]);
        ArcanumButtonDisplayTexture[2] = ARCANUM_SPELL_TABLE.Texture[50];
	elseif (ManaGemExists[5] == true) then
        ArcanumButton3Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[49]);
        OrderButton3Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[49]);
        ArcanumButtonDisplayTexture[2] = ARCANUM_SPELL_TABLE.Texture[49];
	else
        if (ARCANUM_SPELL_TABLE.ID[53] ~= nil) then
            ArcanumButton3Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[53]);
            OrderButton3Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[53]);
            ArcanumButtonDisplayTexture[2] = ARCANUM_SPELL_TABLE.Texture[53];
		elseif (ARCANUM_SPELL_TABLE.ID[52] ~= nil) then
            ArcanumButton3Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[52]);
            OrderButton3Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[52]);
            ArcanumButtonDisplayTexture[2] = ARCANUM_SPELL_TABLE.Texture[52];
		elseif (ARCANUM_SPELL_TABLE.ID[51] ~= nil) then
            ArcanumButton3Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[51]);
            OrderButton3Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[51]);
            ArcanumButtonDisplayTexture[2] = ARCANUM_SPELL_TABLE.Texture[51];
		elseif (ARCANUM_SPELL_TABLE.ID[50] ~= nil) then	
            ArcanumButton3Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[50]);
            OrderButton3Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[50]);
            ArcanumButtonDisplayTexture[2] = ARCANUM_SPELL_TABLE.Texture[50];
		elseif (ARCANUM_SPELL_TABLE.ID[49] ~= nil) then	
            ArcanumButton3Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[49]);
            OrderButton3Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[49]);
            ArcanumButtonDisplayTexture[2] = ARCANUM_SPELL_TABLE.Texture[49];
		end
	end
end

function Arcanum_EDIconsV()
    if ARCANUM_SPELL_TABLE.Rank[8] ~= nil then
        if FoodCount == 0 then
            ArcanumFoodCount:SetText("");
            ArcanumButton1Texture:SetDesaturated(1);
        else
            ArcanumFoodCount:SetText(FoodCount);
            ArcanumButton1Texture:SetDesaturated(nil);
        end
    end
    if ARCANUM_SPELL_TABLE.Rank[9] ~= nil then
        if WaterCount == 0 then
            ArcanumWaterCount:SetText("");
            ArcanumButton2Texture:SetDesaturated(1);
        else
            ArcanumWaterCount:SetText(WaterCount);
            ArcanumButton2Texture:SetDesaturated(nil);
        end
    end
    if (ManaGemExists[1] == true or ManaGemExists[2] == true or ManaGemExists[3] == true or ManaGemExists[4] == true or ManaGemExists[5] == true) then
        ArcanumButton3Texture:SetDesaturated(nil);
	else
        ArcanumButton3Texture:SetDesaturated(1);
	end
end

function Arcanum_EDIconsV1()

    ArcanumArcanePowder2 = 0;

    if ArcanumArcanePowder == 0 then
        ArcanumButton4Text:SetText("");
        ArcanumArcanePowderCount:SetText("");
        ArcanumButton4Menu2Texture:SetDesaturated(1);
        if ArcanumConfig.LastBuff == 13 then
            ArcanumButton4Texture:SetDesaturated(1);
        else
            ArcanumButton4Texture:SetDesaturated(nil);
        end 
    else
        ArcanumArcanePowderCount:SetText(ArcanumArcanePowder);
        ArcanumButton4Menu2Texture:SetDesaturated(nil);
        ArcanumButton4Texture:SetDesaturated(nil);
        if ArcanumConfig.LastBuff == 13 then
            ArcanumButton4Text:SetText(ArcanumArcanePowder);
        else
            ArcanumButton4Text:SetText("");
        end     
    end
    
    if ArcanumConfig.LastPortal >= 15 and ArcanumConfig.LastPortal <= 22 then
        if ArcanumRuneOfTeleportation == 0 then
            ArcanumButton8Text:SetText("");
            ArcanumButton8Texture:SetDesaturated(1);
        else
            ArcanumButton8Text:SetText(ArcanumRuneOfTeleportation);
            ArcanumButton8Texture:SetDesaturated(nil);
        end
	elseif ArcanumConfig.LastPortal == 45 then
        if ArcanumRuneOfTeleportation == 0 then
            ArcanumButton8Text:SetText("");
            ArcanumButton8Texture:SetDesaturated(1);
        else
            ArcanumButton8Text:SetText(ArcanumRuneOfTeleportation);
            ArcanumButton8Texture:SetDesaturated(nil);
        end	
	elseif ArcanumConfig.LastPortal == 47 then
        if ArcanumRuneOfTeleportation == 0 then
            ArcanumButton8Text:SetText("");
            ArcanumButton8Texture:SetDesaturated(1);
        else
            ArcanumButton8Text:SetText(ArcanumRuneOfTeleportation);
            ArcanumButton8Texture:SetDesaturated(nil);
        end
    elseif ArcanumConfig.LastPortal >= 23 and ArcanumConfig.LastPortal <= 40 then
        if ArcanumRuneOfPortals == 0 then
            ArcanumButton8Text:SetText("");
            ArcanumButton8Texture:SetDesaturated(1);
        else
            ArcanumButton8Text:SetText(ArcanumRuneOfPortals);
            ArcanumButton8Texture:SetDesaturated(nil);
        end
	elseif ArcanumConfig.LastPortal == 44 then
        if ArcanumRuneOfPortals == 0 then
            ArcanumButton8Text:SetText("");
            ArcanumButton8Texture:SetDesaturated(1);
        else
            ArcanumButton8Text:SetText(ArcanumRuneOfPortals);
            ArcanumButton8Texture:SetDesaturated(nil);
        end
   	elseif ArcanumConfig.LastPortal == 46 then
        if ArcanumRuneOfPortals == 0 then
            ArcanumButton8Text:SetText("");
            ArcanumButton8Texture:SetDesaturated(1);
        else
            ArcanumButton8Text:SetText(ArcanumRuneOfPortals);
            ArcanumButton8Texture:SetDesaturated(nil);
        end	
    elseif ArcanumConfig.LastPortal == 43 then
        if ArcanumArcanePowder < 2 then
            ArcanumButton8Text:SetText("");
            ArcanumButton8Texture:SetDesaturated(1);
        else
            ArcanumArcanePowder2 = (ArcanumArcanePowder / 2);
            ArcanumButton8Text:SetText(ArcanumArcanePowder2);
            ArcanumButton8Texture:SetDesaturated(nil);
        end    
    end
    
    if ArcanumRuneOfTeleportation == 0 then
        ArcanumTeleport1Count:SetText("");
        ArcanumTeleport2Count:SetText("");
        ArcanumTeleport3Count:SetText("");
        ArcanumTeleport4Count:SetText("");
        ArcanumTeleport5Count:SetText("");
		ArcanumTeleport6Count:SetText("");
        ArcanumButton8Menu1Texture:SetDesaturated(1);
        ArcanumButton8Menu2Texture:SetDesaturated(1);
        ArcanumButton8Menu3Texture:SetDesaturated(1);
        ArcanumButton8Menu4Texture:SetDesaturated(1);
        ArcanumButton8Menu5Texture:SetDesaturated(1);
		ArcanumButton8Menu6Texture:SetDesaturated(1);
    else
        ArcanumTeleport1Count:SetText(ArcanumRuneOfTeleportation);
        ArcanumTeleport2Count:SetText(ArcanumRuneOfTeleportation);
        ArcanumTeleport3Count:SetText(ArcanumRuneOfTeleportation);
        ArcanumTeleport4Count:SetText(ArcanumRuneOfTeleportation);
        ArcanumTeleport5Count:SetText(ArcanumRuneOfTeleportation);
		ArcanumTeleport6Count:SetText(ArcanumRuneOfTeleportation);
        ArcanumButton8Menu1Texture:SetDesaturated(nil);
        ArcanumButton8Menu2Texture:SetDesaturated(nil);
        ArcanumButton8Menu3Texture:SetDesaturated(nil);
        ArcanumButton8Menu4Texture:SetDesaturated(nil);
        ArcanumButton8Menu5Texture:SetDesaturated(nil);
		ArcanumButton8Menu6Texture:SetDesaturated(nil);
     end
    if ArcanumRuneOfPortals == 0 then
        ArcanumPortal1Count:SetText("");
        ArcanumPortal2Count:SetText("");
        ArcanumPortal3Count:SetText("");
        ArcanumPortal4Count:SetText("");
        ArcanumPortal5Count:SetText("");
		ArcanumPortal7Count:SetText("");
        ArcanumButton8Menu7Texture:SetDesaturated(1);
        ArcanumButton8Menu8Texture:SetDesaturated(1);
        ArcanumButton8Menu9Texture:SetDesaturated(1);
        ArcanumButton8Menu10Texture:SetDesaturated(1);
        ArcanumButton8Menu11Texture:SetDesaturated(1);
		ArcanumButton8Menu12Texture:SetDesaturated(1);
    else
        ArcanumPortal1Count:SetText(ArcanumRuneOfPortals);
        ArcanumPortal2Count:SetText(ArcanumRuneOfPortals);
        ArcanumPortal3Count:SetText(ArcanumRuneOfPortals);
        ArcanumPortal4Count:SetText(ArcanumRuneOfPortals);
        ArcanumPortal5Count:SetText(ArcanumRuneOfPortals);
		ArcanumPortal7Count:SetText(ArcanumRuneOfPortals);
        ArcanumButton8Menu7Texture:SetDesaturated(nil);
        ArcanumButton8Menu8Texture:SetDesaturated(nil);
        ArcanumButton8Menu9Texture:SetDesaturated(nil);
        ArcanumButton8Menu10Texture:SetDesaturated(nil);
        ArcanumButton8Menu11Texture:SetDesaturated(nil);
		ArcanumButton8Menu12Texture:SetDesaturated(nil);
    end
    if ArcanumArcanePowder < 2 then
    	ArcanumPortal7Count:SetText("");
    	ArcanumButton8Menu13Texture:SetDesaturated(1);
    else
    	ArcanumArcanePowder2 = (ArcanumArcanePowder /2);
    	ArcanumPortal7Count:SetText(ArcanumArcanePowder2);
    	ArcanumButton8Menu13Texture:SetDesaturated(nil);
    end
    
end


function Arcanum_EDIconsV2()
    ArcanumButton41Text:SetText("");
    ArcanumButton41Texture:SetDesaturated(nil);
    if ArcanumRuneOfTeleportation == 0 then
        ArcanumButton81Text:SetText("");
        ArcanumButton91Text:SetText("");
        ArcanumButton101Text:SetText("");
        ArcanumButton81Texture:SetDesaturated(1);
        ArcanumButton91Texture:SetDesaturated(1);
        ArcanumButton101Texture:SetDesaturated(1);
    else
        ArcanumButton81Text:SetText(ArcanumRuneOfTeleportation);
        ArcanumButton91Text:SetText(ArcanumRuneOfTeleportation);
        ArcanumButton101Text:SetText(ArcanumRuneOfTeleportation);
        ArcanumButton81Texture:SetDesaturated(nil);
        ArcanumButton91Texture:SetDesaturated(nil);
        ArcanumButton101Texture:SetDesaturated(nil);
    end
    if ArcanumArcanePowder == 0 then
        ArcanumButton42Text:SetText("");
        ArcanumButton42Texture:SetDesaturated(1);
    else
        ArcanumButton42Text:SetText(ArcanumArcanePowder);
        ArcanumButton42Texture:SetDesaturated(nil);
    end
    if ArcanumRuneOfPortals == 0 then
        ArcanumButton82Text:SetText("");
        ArcanumButton92Text:SetText("");
        ArcanumButton102Text:SetText("");
        ArcanumButton82Texture:SetDesaturated(1);
        ArcanumButton92Texture:SetDesaturated(1);
        ArcanumButton102Texture:SetDesaturated(1);
    else
        ArcanumButton82Text:SetText(ArcanumRuneOfPortals);
        ArcanumButton92Text:SetText(ArcanumRuneOfPortals);
        ArcanumButton102Text:SetText(ArcanumRuneOfPortals);
        ArcanumButton82Texture:SetDesaturated(nil);
        ArcanumButton92Texture:SetDesaturated(nil);
        ArcanumButton102Texture:SetDesaturated(nil);
    end
end


function Arcanum_EDIcons()
    Arcanum_EDIconsV();
    Arcanum_EDIconsV1();
    Arcanum_EDIconsV2();
end


function Arcanum_CombatDisableIcons()
    Combat = true;
    if ARCANUM_SPELL_TABLE.ID[8] ~= nil then
        ArcanumButton1Texture:SetDesaturated(1);
    end
    if ARCANUM_SPELL_TABLE.ID[9] ~= nil then
        ArcanumButton2Texture:SetDesaturated(1);
    end
	if ArcanumConfig.LastMount ~= 0 then
        getglobal("ArcanumButton7Menu"..ArcanumConfig.LastMount.."Texture"):SetDesaturated(1);
    end
    ArcanumButtonTexture:SetTexture(UIPath.."ArcanumC");
end

function Arcanum_CombatEnableIcons()
    Combat = false;
    if FoodCount ~= 0 and ARCANUM_SPELL_TABLE.ID[8] ~= nil then
        ArcanumButton1Texture:SetDesaturated(nil);
    end
    if WaterCount ~= 0 and ARCANUM_SPELL_TABLE.ID[9] ~= nil then
        ArcanumButton2Texture:SetDesaturated(nil);
    end
    if ArcanumConfig.LastMount ~= 0 then
        getglobal("ArcanumButton7Menu"..ArcanumConfig.LastMount.."Texture"):SetDesaturated(nil);
    end
    ArcanumButtonTexture:SetTexture(UIPath.."ArcanumN");
    Arcanum_UpdateQueuedAttribute();
end
------------------------------------------------------------------------------------------------------

-- FONCTIONS DE GESTION DES COMPORTEMENTS DES BOUTONS DE L'UI

------------------------------------------------------------------------------------------------------

-- Fonction (XML) pour rétablir les points d'attache par dfaut des boutons
function Arcanum_ClearAllPoints()
	ArcanumButton1:ClearAllPoints();
	ArcanumButton2:ClearAllPoints();
	ArcanumButton3:ClearAllPoints();
	ArcanumButton4:ClearAllPoints();
	ArcanumButton5:ClearAllPoints();
	ArcanumButton6:ClearAllPoints();
	ArcanumButton7:ClearAllPoints();
    ArcanumButton8:ClearAllPoints();
    ArcanumButton9:ClearAllPoints();
    ArcanumButton10:ClearAllPoints();
end

-- Fonction (XML) pour étendre la propriété NoDrag() du bouton principal d'Arcanum sur tous ses boutons
function Arcanum_NoDrag()
	ArcanumButton1:RegisterForDrag("");
	ArcanumButton2:RegisterForDrag("");
	ArcanumButton3:RegisterForDrag("");
	ArcanumButton4:RegisterForDrag("");
	ArcanumButton5:RegisterForDrag("");
	ArcanumButton6:RegisterForDrag("");
	ArcanumButton7:RegisterForDrag("");
    ArcanumButton8:RegisterForDrag("");
    ArcanumButton9:RegisterForDrag("");
    ArcanumButton10:RegisterForDrag("");
end

-- Fonction (XML) inverse de celle du dessus
function Arcanum_Drag()
    ArcanumButton1:RegisterForDrag("LeftButton");
	ArcanumButton2:RegisterForDrag("LeftButton");
	ArcanumButton3:RegisterForDrag("LeftButton");
	ArcanumButton4:RegisterForDrag("LeftButton");
	ArcanumButton5:RegisterForDrag("LeftButton");
	ArcanumButton6:RegisterForDrag("LeftButton");
	ArcanumButton7:RegisterForDrag("LeftButton");
    ArcanumButton8:RegisterForDrag("LeftButton");
    ArcanumButton9:RegisterForDrag("LeftButton");
    ArcanumButton10:RegisterForDrag("LeftButton");
end

function Arcanum_MovableIcons()
		ArcanumButton1:SetPoint("CENTER", "UIParent", "CENTER", -161,-100);
		ArcanumButton2:SetPoint("CENTER", "UIParent", "CENTER",-125,-100);
		ArcanumButton3:SetPoint("CENTER", "UIParent", "CENTER", -89,-100);
		ArcanumButton4:SetPoint("CENTER", "UIParent", "CENTER", -53,-100);
		ArcanumButton5:SetPoint("CENTER", "UIParent", "CENTER", -17,-100);
		ArcanumButton6:SetPoint("CENTER", "UIParent", "CENTER", 17,-100);
		ArcanumButton7:SetPoint("CENTER", "UIParent", "CENTER", 53,-100);
        ArcanumButton8:SetPoint("CENTER", "UIParent", "CENTER", 89,-100);
		ArcanumButton9:SetPoint("CENTER", "UIParent", "CENTER", 125,-100);
		ArcanumButton10:SetPoint("CENTER", "UIParent", "CENTER", 161, -100);
end

function Arcanum_UpdateButtonsScale()
	local NBRScale = (100 + (ArcanumConfig.ArcanumScale - ArcanumConfig.ArcanumButtonScale + 15)) / 100;
    if ArcanumConfig.ArcanumScale < ArcanumConfig.ArcanumButtonScale then
        NBRScale = 1.15;
	end
	if ArcanumConfig.ArcanumLockServ then
		Arcanum_ClearAllPoints();
        Arcanum_NoDrag();
--~         indexScale = -18;
--~         for index = 1, 10, 1 do
--~             if ArcanumConfig.ButtonsOrder[index] == 4 or ArcanumConfig.ButtonsOrder[index] == 5 or
--~             ArcanumConfig.ButtonsOrder[index] == 6 or ArcanumConfig.ButtonsOrder[index] == 10 then
--~                 getglobal("ArcanumButton"..ArcanumConfig.ButtonsOrder[index].."1"):SetPoint("CENTER", "ArcanumButton", "CENTER", ((40 * NBRScale) * cos(ArcanumConfig.ArcanumAngle-indexScale)), ((40 * NBRScale) * sin(ArcanumConfig.ArcanumAngle-indexScale)));
--~                 getglobal("ArcanumButton"..ArcanumConfig.ButtonsOrder[index].."2"):SetPoint("CENTER", "ArcanumButton", "CENTER", ((40 * NBRScale) * cos(ArcanumConfig.ArcanumAngle-indexScale)), ((40 * NBRScale) * sin(ArcanumConfig.ArcanumAngle-indexScale)));
--~                 getglobal("ArcanumButton"..ArcanumConfig.ButtonsOrder[index]):SetPoint("CENTER", "ArcanumButton", "CENTER", ((40 * NBRScale) * cos(ArcanumConfig.ArcanumAngle-indexScale)), ((40 * NBRScale) * sin(ArcanumConfig.ArcanumAngle-indexScale)));
--~                 getglobal("ArcanumButton"..ArcanumConfig.ButtonsOrder[index]):SetPoint("CENTER", "ArcanumButton", "CENTER", ((40 * NBRScale) * cos(ArcanumConfig.ArcanumAngle-indexScale)), ((40 * NBRScale) * sin(ArcanumConfig.ArcanumAngle-indexScale)));
--~             end
--~             getglobal("OrderButton"..ArcanumConfig.ButtonsOrder[index]):SetPoint("CENTER", "ArcanumOrderButton", "CENTER", (32 * cos(ArcanumConfig.ArcanumAngle-indexScale)), (32 * sin(ArcanumConfig.ArcanumAngle-indexScale)));
        local indexScale = 90;
		
        for index = 1, 10 do
          if ArcanumConfig.ButtonsOrder[index] > 3 then
            getglobal("ArcanumButton"..ArcanumConfig.ButtonsOrder[index].."1"):SetPoint("CENTER", "ArcanumButton", "CENTER", ((40 * NBRScale) * cos(ArcanumConfig.ArcanumAngle-indexScale)), ((40 * NBRScale) * sin(ArcanumConfig.ArcanumAngle-indexScale)));
                getglobal("ArcanumButton"..ArcanumConfig.ButtonsOrder[index].."2"):SetPoint("CENTER", "ArcanumButton", "CENTER", ((40 * NBRScale) * cos(ArcanumConfig.ArcanumAngle-indexScale)), ((40 * NBRScale) * sin(ArcanumConfig.ArcanumAngle-indexScale)));
              end	
          indexScale = indexScale + 36;         
        end
            
        indexScale = -18;
        for index = 1, 10, 1 do
            getglobal("ArcanumButton"..ArcanumConfig.ButtonsOrder[index]):SetPoint("CENTER", "ArcanumButton", "CENTER", ((40 * NBRScale) * cos(ArcanumConfig.ArcanumAngle-indexScale)), ((40 * NBRScale) * sin(ArcanumConfig.ArcanumAngle-indexScale)));
            getglobal("OrderButton"..ArcanumConfig.ButtonsOrder[index]):SetPoint("CENTER", "ArcanumOrderButton", "CENTER", (32 * cos(ArcanumConfig.ArcanumAngle-indexScale)), (32 * sin(ArcanumConfig.ArcanumAngle-indexScale)));
			
            
            if ArcanumConfig.ButtonsOrder[index] == 4 and BuffMenuCreate ~= {} then
				xBuffMenuPos = ((40 * NBRScale) * cos(ArcanumConfig.ArcanumAngle-indexScale));
                yBuffMenuPos = ((40 * NBRScale) * sin(ArcanumConfig.ArcanumAngle-indexScale));
			end	
			if ArcanumConfig.ButtonsOrder[index] == 5 and ArmorMenuCreate ~= {} then
                xArmorMenuPos = ((40 * NBRScale) * cos(ArcanumConfig.ArcanumAngle-indexScale));
                yArmorMenuPos = ((40 * NBRScale) * sin(ArcanumConfig.ArcanumAngle-indexScale));
			end
			if ArcanumConfig.ButtonsOrder[index] == 6 and MagicMenuCreate ~= {} then
                xMagicMenuPos = ((40 * NBRScale) * cos(ArcanumConfig.ArcanumAngle-indexScale));
                yMagicMenuPos = ((40 * NBRScale) * sin(ArcanumConfig.ArcanumAngle-indexScale));
			end
			if ArcanumConfig.ButtonsOrder[index] == 7 and MountMenuCreate ~= {} then
                xMountMenuPos = ((40 * NBRScale) * cos(ArcanumConfig.ArcanumAngle-indexScale));
                yMountMenuPos = ((40 * NBRScale) * sin(ArcanumConfig.ArcanumAngle-indexScale));
			end	
			if ArcanumConfig.ButtonsOrder[index] == 8 and PortalMenuCreate ~= {} then
                xPortalMenuPos = ((40 * NBRScale) * cos(ArcanumConfig.ArcanumAngle-indexScale));
                yPortalMenuPos = ((40 * NBRScale) * sin(ArcanumConfig.ArcanumAngle-indexScale));
            end
			if ArcanumConfig.ButtonsOrder[index] == 9 and JobMenuCreate ~= {} then
                xJobMenuPos = ((40 * NBRScale) * cos(ArcanumConfig.ArcanumAngle-indexScale));
                yJobMenuPos = ((40 * NBRScale) * sin(ArcanumConfig.ArcanumAngle-indexScale)); 
			end
            if ArcanumConfig.ButtonsOrder[index] == 10 and WardMenuCreate ~= {} then
                xWardMenuPos = ((40 * NBRScale) * cos(ArcanumConfig.ArcanumAngle-indexScale));
                yWardMenuPos = ((40 * NBRScale) * sin(ArcanumConfig.ArcanumAngle-indexScale)); 
			end
            indexScale = indexScale + 36;
        end
	end
	Arcanum_CreateMenu();
end


function Arcanum_UpdateScale()
    for i = 1, 10 do
--~         if i == 7 then
--~             getglobal("ArcanumButton7Menu"..ArcanumConfig.LastMount):SetScale(ArcanumConfig.ArcanumButtonScale / 100 *34 /40);
--~         elseif i == 8 then
--~             getglobal("ArcanumButton8Menu"..ArcanumConfig.LastPortal):SetScale(ArcanumConfig.ArcanumButtonScale / 100 *34 /40);
--~         elseif i == 9 then
--~             getglobal("ArcanumButton9Menu"..ArcanumConfig.LastJob):SetScale(ArcanumConfig.ArcanumButtonScale / 100 *34 /40);
--~         else
            getglobal("ArcanumButton"..i):SetScale(ArcanumConfig.ArcanumButtonScale / 100);
--~         end
    end
    for i = 4, 10 do
        getglobal("ArcanumButton"..i.."1"):SetScale(ArcanumConfig.ArcanumButtonScale / 100);
        getglobal("ArcanumButton"..i.."2"):SetScale(ArcanumConfig.ArcanumButtonScale / 100);
    end
end
function Arcanum_MenuPos(button)
	local a, b, c, x, y = button:GetPoint("CENTER");
	x = ((32 * x) / 40);
	y = ((32 * y) / 40);
	return x, y;
end

function Arcanum_IntSign(Value)
	local Result;
	if math.abs(Value) == Value then
		Result = 1;
	else
		Result = -1;
	end
	return Result;
end

function Arcanum_UpdateMenuPos()
	local a, b, c, x, y = ArcanumButton4:GetPoint("CENTER");
	local a1, b1, c1, x1, y1 = ArcanumButton:GetPoint("CENTER");
	xBuffMenuPos = x-x1;
	yBuffMenuPos = y-y1;
	a, b, c, x, y = ArcanumButton5:GetPoint("CENTER");
	xArmorMenuPos = x-x1;
	yArmorMenuPos = y-y1;
	a, b, c, x, y = ArcanumButton6:GetPoint("CENTER");
	xMagicMenuPos = x-x1;
	yMagicMenuPos = y-y1;
    a, b, c, x, y = ArcanumButton8:GetPoint("CENTER");
	xPortalMenuPos = x-x1;
	yPortalMenuPos = y-y1;
    a, b, c, x, y = ArcanumButton7:GetPoint("CENTER");
	xMountMenuPos = x-x1;
	yMountMenuPos = y-y1;
    a, b, c, x, y = ArcanumButton9:GetPoint("CENTER");
	xJobMenuPos = x-x1;
	yJobMenuPos = y-y1;
    a, b, c, x, y = ArcanumButton10:GetPoint("CENTER");
	xWardMenuPos = x-x1;
	yWardMenuPos = y-y1;
	Arcanum_CreateMenu();
end

------------------------------------------------------------------------------------------------------

-- FONCTIONS DE GESTION DES BOUTONS MENUS DE L'UI

------------------------------------------------------------------------------------------------------

-- A chaque changement du livre des sorts, au démarrage du mod, ainsi qu'au changement de sens du menu on reconstruit les menus des sorts
function Arcanum_CreateMenu()
	BuffMenuCreate = {};
	ArmorMenuCreate = {};
	MagicMenuCreate = {};
	PortalMenuCreate = {};
    MountMenuCreate = {};
    JobMenuCreate = {};
    WardMenuCreate = {};
	local menuVariable = nil;
	local BuffButtonPosition = 0;
	local ArmorButtonPosition = 0;
	local MagicButtonPosition = 0;
	local PortalButtonPosition = 0;
    local MountButtonPosition = 0;
    local JobButtonPosition = 0;
    local WardButtonPosition = 0;
    
	-- On cache toutes les icones des buffs
	for i = 1, 2, 1 do
		menuVariable = getglobal("ArcanumButton4Menu"..i);
		menuVariable:Hide();
	end
	-- On cache toutes les icones des armures
	for i = 1, 3, 1 do
		menuVariable = getglobal("ArcanumButton5Menu"..i);
		menuVariable:Hide();
	end
	-- On cache toutes les icones des magies
	for i = 1, 2, 1 do
		menuVariable = getglobal("ArcanumButton6Menu"..i);
		menuVariable:Hide();
	end
	-- On cache toutes les icones des portails
	for i = 1, 13, 1 do
        if i ~= ArcanumConfig.LastPortal then
            menuVariable = getglobal("ArcanumButton8Menu"..i);
            menuVariable:Hide();
        end
	end
    -- On cache toutes les icones des montures
	for i = 1, 10, 1 do
        if i ~= ArcanumConfig.LastMount then
            menuVariable = getglobal("ArcanumButton7Menu"..i);
            menuVariable:Hide();
        end
	end
    -- On cache toutes les icones des métiers
	for i = 1, 8, 1 do
        if i ~= ArcanumConfig.LastJob then
            menuVariable = getglobal("ArcanumButton9Menu"..i);
            menuVariable:Hide();
        end
	end
        -- On cache toutes les icones des gardiens
	for i = 1, 2, 1 do
		menuVariable = getglobal("ArcanumButton10Menu"..i);
		menuVariable:Hide();
	end
	
	-- Affichage des boutons des buffs si les sorts existent
	if (ARCANUM_SPELL_TABLE.ID[12] ~= nil) then
		menuVariable = getglobal("ArcanumButton4Menu"..BuffButtonPosition + 1);
		menuVariable:ClearAllPoints();
		menuVariable:SetPoint("CENTER", "ArcanumButton4", "CENTER", 3000, 3000);
		BuffButtonPosition = 1;
		table.insert(BuffMenuCreate, menuVariable);
	end
	if (ARCANUM_SPELL_TABLE.ID[13] ~= nil) then
		menuVariable = getglobal("ArcanumButton4Menu"..BuffButtonPosition + 1);
		menuVariable:ClearAllPoints();
		if BuffButtonPosition == 0 then
			menuVariable:SetPoint("CENTER", "ArcanumButton4", "CENTER", 3000, 3000);
		else
			if ArcanumConfig.BuffMenuPos == 1 then
				menuVariable:SetPoint("CENTER", "ArcanumButton4Menu"..BuffButtonPosition, "CENTER", 32, 0);
			elseif ArcanumConfig.BuffMenuPos == 2 then
                menuVariable:SetPoint("CENTER", "ArcanumButton4Menu"..BuffButtonPosition, "CENTER", -32, 0);
            elseif ArcanumConfig.BuffMenuPos == 3 then
                menuVariable:SetPoint("CENTER", "ArcanumButton4Menu"..BuffButtonPosition, "CENTER", 0, 32);
            elseif ArcanumConfig.BuffMenuPos == 4 then
				menuVariable:SetPoint("CENTER", "ArcanumButton4Menu"..BuffButtonPosition, "CENTER", 0, -32);
			end
		end
		BuffButtonPosition = 2;
		table.insert(BuffMenuCreate, menuVariable);
	end
	-- Maintenant que tous les boutons sont placés les uns à côté des autres (hors de l'écran), on affiche les disponibles
	for i = 1, #BuffMenuCreate do
		ShowUIPanel(BuffMenuCreate[i]);
	end
		
	-- Affichage des boutons des armures si les sorts existent
	if (ARCANUM_SPELL_TABLE.ID[2] ~= nil or ARCANUM_SPELL_TABLE.ID[1] ~= nil) then
		menuVariable = getglobal("ArcanumButton5Menu"..ArmorButtonPosition + 1);
		menuVariable:ClearAllPoints();
		menuVariable:SetPoint("CENTER", "ArcanumButton5", "CENTER", 3000, 3000);
		ArmorButtonPosition = 1;
		table.insert(ArmorMenuCreate, menuVariable);
	end
	if (ARCANUM_SPELL_TABLE.ID[3] ~= nil) then
		menuVariable = getglobal("ArcanumButton5Menu"..ArmorButtonPosition + 1);
		menuVariable:ClearAllPoints();
		if ArmorButtonPosition == 0 then
			menuVariable:SetPoint("CENTER", "ArcanumButton5", "CENTER", 3000, 3000);
		else
			if ArcanumConfig.ArmorMenuPos == 1 then
				menuVariable:SetPoint("CENTER", "ArcanumButton5Menu"..ArmorButtonPosition, "CENTER", 32, 0);
			elseif ArcanumConfig.ArmorMenuPos == 2 then
                menuVariable:SetPoint("CENTER", "ArcanumButton5Menu"..ArmorButtonPosition, "CENTER", -32, 0);
            elseif ArcanumConfig.ArmorMenuPos == 3 then
                menuVariable:SetPoint("CENTER", "ArcanumButton5Menu"..ArmorButtonPosition, "CENTER", 0, 32);
            elseif ArcanumConfig.ArmorMenuPos == 4 then
				menuVariable:SetPoint("CENTER", "ArcanumButton5Menu"..ArmorButtonPosition, "CENTER", 0, -32);
			end
		end
		ArmorButtonPosition = 2;
		table.insert(ArmorMenuCreate, menuVariable);
	end
    if (ARCANUM_SPELL_TABLE.ID[4] ~= nil) then
		menuVariable = getglobal("ArcanumButton5Menu"..ArmorButtonPosition + 1);
		menuVariable:ClearAllPoints();
		if ArmorButtonPosition == 0 then
			menuVariable:SetPoint("CENTER", "ArcanumButton5", "CENTER", 3000, 3000);
		else
			if ArcanumConfig.ArmorMenuPos == 1 then
				menuVariable:SetPoint("CENTER", "ArcanumButton5Menu"..ArmorButtonPosition, "CENTER", 32, 0);
			elseif ArcanumConfig.ArmorMenuPos == 2 then
                menuVariable:SetPoint("CENTER", "ArcanumButton5Menu"..ArmorButtonPosition, "CENTER", -32, 0);
            elseif ArcanumConfig.ArmorMenuPos == 3 then
                menuVariable:SetPoint("CENTER", "ArcanumButton5Menu"..ArmorButtonPosition, "CENTER", 0, 32);
            elseif ArcanumConfig.ArmorMenuPos == 4 then
				menuVariable:SetPoint("CENTER", "ArcanumButton5Menu"..ArmorButtonPosition, "CENTER", 0, -32);
			end
		end
		ArmorButtonPosition = 3;
		table.insert(ArmorMenuCreate, menuVariable);
	end
	-- Maintenant que tous les boutons sont placés les uns à côté des autres (hors de l'écran), on affiche les disponibles
	for i = 1, #ArmorMenuCreate do
		ShowUIPanel(ArmorMenuCreate[i]);
	end
	
	-- Affichage des boutons des magies si les sorts existent
	if (ARCANUM_SPELL_TABLE.ID[6] ~= nil) then
		menuVariable = getglobal("ArcanumButton6Menu"..MagicButtonPosition + 1);
		menuVariable:ClearAllPoints();
		menuVariable:SetPoint("CENTER", "ArcanumButton6", "CENTER", 3000, 3000);
		MagicButtonPosition = 1;
		table.insert(MagicMenuCreate, menuVariable);
	end
	if (ARCANUM_SPELL_TABLE.ID[7] ~= nil) then
		menuVariable = getglobal("ArcanumButton6Menu"..MagicButtonPosition + 1);
		menuVariable:ClearAllPoints();
		if MagicButtonPosition == 0 then
			menuVariable:SetPoint("CENTER", "ArcanumButton6", "CENTER", 3000, 3000);
		else
			if ArcanumConfig.MagicMenuPos == 1 then
				menuVariable:SetPoint("CENTER", "ArcanumButton6Menu"..MagicButtonPosition, "CENTER", 32, 0);
			elseif ArcanumConfig.MagicMenuPos == 2 then
                menuVariable:SetPoint("CENTER", "ArcanumButton6Menu"..MagicButtonPosition, "CENTER", -32, 0);
            elseif ArcanumConfig.MagicMenuPos == 3 then
                menuVariable:SetPoint("CENTER", "ArcanumButton6Menu"..MagicButtonPosition, "CENTER", 0, 32);
            elseif ArcanumConfig.MagicMenuPos == 4 then
				menuVariable:SetPoint("CENTER", "ArcanumButton6Menu"..MagicButtonPosition, "CENTER", 0, -32);
			end
		end
		MagicButtonPosition = 2;
		table.insert(MagicMenuCreate, menuVariable);
	end
	-- Maintenant que tous les boutons sont placés les uns à côté des autres (hors de l'écran), on affiche les disponibles
	for i = 1, #MagicMenuCreate do
		ShowUIPanel(MagicMenuCreate[i]);
	end
	
	-- Affichage des boutons des portails si les sorts existent
	for i = 15, 18 do
        if (ARCANUM_SPELL_TABLE.ID[i] ~= nil or ARCANUM_SPELL_TABLE.ID[i+4] ~= nil) then
            menuVariable = getglobal("ArcanumButton8Menu"..i-14);
            menuVariable:ClearAllPoints();
            if PortalButtonPosition == 0 then
                menuVariable:SetPoint("CENTER", "ArcanumButton8", "CENTER", 3000, 3000);
            else
                if ArcanumConfig.PortalMenuPos == 1 then
                    menuVariable:SetPoint("CENTER", "ArcanumButton8Menu"..PortalButtonPosition, "CENTER", 32, 0);
                elseif ArcanumConfig.PortalMenuPos == 2 then
                    menuVariable:SetPoint("CENTER", "ArcanumButton8Menu"..PortalButtonPosition, "CENTER", -32, 0);
                elseif ArcanumConfig.PortalMenuPos == 3 then
                    menuVariable:SetPoint("CENTER", "ArcanumButton8Menu"..PortalButtonPosition, "CENTER", 0, 32);
                elseif ArcanumConfig.PortalMenuPos == 4 then
                    menuVariable:SetPoint("CENTER", "ArcanumButton8Menu"..PortalButtonPosition, "CENTER", 0, -32);
                end
            end
            if PortalButtonPosition ~= i-14 then
                PortalButtonPosition = i - 14;
            else
                PortalButtonPosition = PortalButtonPosition + 1;
            end
            table.insert(PortalMenuCreate, menuVariable);
        end
	end
	-- On attribue le sort de teleportation Pierreche ou Theramore au bouton 5. 
    if (ARCANUM_SPELL_TABLE.ID[45] ~= nil or ARCANUM_SPELL_TABLE.ID[47] ~= nil) then
		  menuVariable = getglobal("ArcanumButton8Menu5");
		  menuVariable:ClearAllPoints();
		  if PortalButtonPosition == 0 then
			  menuVariable:SetPoint("CENTER", "ArcanumButton8", "CENTER", 3000, 3000);
		  else
			  if ArcanumConfig.PortalMenuPos == 1 then
				  menuVariable:SetPoint("CENTER", "ArcanumButton8Menu"..PortalButtonPosition, "CENTER", 32, 0);
			  elseif ArcanumConfig.PortalMenuPos == 2 then
                  menuVariable:SetPoint("CENTER", "ArcanumButton8Menu"..PortalButtonPosition, "CENTER", -32, 0);
              elseif ArcanumConfig.PortalMenuPos == 3 then
                  menuVariable:SetPoint("CENTER", "ArcanumButton8Menu"..PortalButtonPosition, "CENTER", 0, 32);
              elseif ArcanumConfig.PortalMenuPos == 4 then
				  menuVariable:SetPoint("CENTER", "ArcanumButton8Menu"..PortalButtonPosition, "CENTER", 0, -32);
			  end
		end
		  PortalButtonPosition = 5;
		  table.insert(PortalMenuCreate, menuVariable);
		end  

    if (ARCANUM_SPELL_TABLE.ID[40] ~= nil) then
		  menuVariable = getglobal("ArcanumButton8Menu6");
		  menuVariable:ClearAllPoints();
		  if PortalButtonPosition == 0 then
			  menuVariable:SetPoint("CENTER", "ArcanumButton8", "CENTER", 3000, 3000);
		  else
			  if ArcanumConfig.PortalMenuPos == 1 then
				  menuVariable:SetPoint("CENTER", "ArcanumButton8Menu"..PortalButtonPosition, "CENTER", 32, 0);
			  elseif ArcanumConfig.PortalMenuPos == 2 then
          menuVariable:SetPoint("CENTER", "ArcanumButton8Menu"..PortalButtonPosition, "CENTER", -32, 0);
        elseif ArcanumConfig.PortalMenuPos == 3 then
          menuVariable:SetPoint("CENTER", "ArcanumButton8Menu"..PortalButtonPosition, "CENTER", 0, 32);
        elseif ArcanumConfig.PortalMenuPos == 4 then
				  menuVariable:SetPoint("CENTER", "ArcanumButton8Menu"..PortalButtonPosition, "CENTER", 0, -32);
			  end
		  end
		  PortalButtonPosition = 6;
		  table.insert(PortalMenuCreate, menuVariable);
	  end
	for i = 23, 26 do
        if (ARCANUM_SPELL_TABLE.ID[i] ~= nil or ARCANUM_SPELL_TABLE.ID[i+4] ~= nil) then
            menuVariable = getglobal("ArcanumButton8Menu"..i-16);
            menuVariable:ClearAllPoints();
            if PortalButtonPosition == 0 then
                menuVariable:SetPoint("CENTER", "ArcanumButton8", "CENTER", 3000, 3000);
            else
                if ArcanumConfig.PortalMenuPos == 1 then
                    menuVariable:SetPoint("CENTER", "ArcanumButton8Menu"..PortalButtonPosition, "CENTER", 32, 0);
                elseif ArcanumConfig.PortalMenuPos == 2 then
                    menuVariable:SetPoint("CENTER", "ArcanumButton8Menu"..PortalButtonPosition, "CENTER", -32, 0);
                elseif ArcanumConfig.PortalMenuPos == 3 then
                    menuVariable:SetPoint("CENTER", "ArcanumButton8Menu"..PortalButtonPosition, "CENTER", 0, 32);
                elseif ArcanumConfig.PortalMenuPos == 4 then
                    menuVariable:SetPoint("CENTER", "ArcanumButton8Menu"..PortalButtonPosition, "CENTER", 0, -32);
                end
            end
            if PortalButtonPosition ~= i-16 then
                PortalButtonPosition = i - 16;
            else
                PortalButtonPosition = PortalButtonPosition + 1;
            end
            table.insert(PortalMenuCreate, menuVariable);
        end
	end
    -- On attribue le sort de portailche ou Theramore au bouton 11.  	
    if (ARCANUM_SPELL_TABLE.ID[44] ~= nil or ARCANUM_SPELL_TABLE.ID[46] ~= nil) then
		  menuVariable = getglobal("ArcanumButton8Menu11");
		  menuVariable:ClearAllPoints();
		  if PortalButtonPosition == 0 then
			  menuVariable:SetPoint("CENTER", "ArcanumButton8", "CENTER", 3000, 3000);
		  else
			  if ArcanumConfig.PortalMenuPos == 1 then
				  menuVariable:SetPoint("CENTER", "ArcanumButton8Menu"..PortalButtonPosition, "CENTER", 32, 0);
			  elseif ArcanumConfig.PortalMenuPos == 2 then
          menuVariable:SetPoint("CENTER", "ArcanumButton8Menu"..PortalButtonPosition, "CENTER", -32, 0);
        elseif ArcanumConfig.PortalMenuPos == 3 then
          menuVariable:SetPoint("CENTER", "ArcanumButton8Menu"..PortalButtonPosition, "CENTER", 0, 32);
        elseif ArcanumConfig.PortalMenuPos == 4 then
				  menuVariable:SetPoint("CENTER", "ArcanumButton8Menu"..PortalButtonPosition, "CENTER", 0, -32);
			  end
		  end
		  PortalButtonPosition = 11;
		  table.insert(PortalMenuCreate, menuVariable);
	end  
    if (ARCANUM_SPELL_TABLE.ID[41] ~= nil) then
		  menuVariable = getglobal("ArcanumButton8Menu12");
		  menuVariable:ClearAllPoints();
		  if PortalButtonPosition == 0 then
			  menuVariable:SetPoint("CENTER", "ArcanumButton8", "CENTER", 3000, 3000);
		  else
			  if ArcanumConfig.PortalMenuPos == 1 then
				  menuVariable:SetPoint("CENTER", "ArcanumButton8Menu"..PortalButtonPosition, "CENTER", 32, 0);
			  elseif ArcanumConfig.PortalMenuPos == 2 then
          menuVariable:SetPoint("CENTER", "ArcanumButton8Menu"..PortalButtonPosition, "CENTER", -32, 0);
        elseif ArcanumConfig.PortalMenuPos == 3 then
          menuVariable:SetPoint("CENTER", "ArcanumButton8Menu"..PortalButtonPosition, "CENTER", 0, 32);
        elseif ArcanumConfig.PortalMenuPos == 4 then
				  menuVariable:SetPoint("CENTER", "ArcanumButton8Menu"..PortalButtonPosition, "CENTER", 0, -32);
			  end
		  end
		  PortalButtonPosition = 12;
		  table.insert(PortalMenuCreate, menuVariable);
	end  
    	
	-- Rituel de refresh
	if (ARCANUM_SPELL_TABLE.ID[43] ~= nil) then
		menuVariable = getglobal("ArcanumButton8Menu13");
		menuVariable:ClearAllPoints();
		if PortalButtonPosition == 0 then
			menuVariable:SetPoint("CENTER", "ArcanumButton8", "CENTER", 3000, 3000);
		else
			if ArcanumConfig.PortalMenuPos == 1 then
				menuVariable:SetPoint("CENTER", "ArcanumButton8Menu"..PortalButtonPosition, "CENTER", 32, 0);
			elseif ArcanumConfig.PortalMenuPos == 2 then
                menuVariable:SetPoint("CENTER", "ArcanumButton8Menu"..PortalButtonPosition, "CENTER", -32, 0);
            elseif ArcanumConfig.PortalMenuPos == 3 then
                menuVariable:SetPoint("CENTER", "ArcanumButton8Menu"..PortalButtonPosition, "CENTER", 0, 32);
            elseif ArcanumConfig.PortalMenuPos == 4 then
				menuVariable:SetPoint("CENTER", "ArcanumButton8Menu"..PortalButtonPosition, "CENTER", 0, -32);
			end
		end
		PortalButtonPosition = 13;
		table.insert(PortalMenuCreate, menuVariable);
	end
	
	-- Maintenant que tous les boutons sont placés les uns à côté des autres (hors de l'écran), on affiche les disponibles
	for i = 1, #PortalMenuCreate do
		ShowUIPanel(PortalMenuCreate[i]);
	end
    
    -- Affichage des boutons des montures en fonction du nombre de monture présente
    local MountNB;
    if #MountLocation > 10 then
        MountNB = 10;
    else
        MountNB = #MountLocation;
    end
	for i = 1, MountNB do
        menuVariable = getglobal("ArcanumButton7Menu"..i);
        menuVariable:ClearAllPoints();
        if MountButtonPosition == 0 then
            menuVariable:SetPoint("CENTER", "ArcanumButton7", "CENTER", 3000, 3000);
        else
            if ArcanumConfig.MountMenuPos == 1 then
                menuVariable:SetPoint("CENTER", "ArcanumButton7Menu"..MountButtonPosition, "CENTER", 32, 0);
            elseif ArcanumConfig.MountMenuPos == 2 then
                menuVariable:SetPoint("CENTER", "ArcanumButton7Menu"..MountButtonPosition, "CENTER", -32, 0);
            elseif ArcanumConfig.MountMenuPos == 3 then
                menuVariable:SetPoint("CENTER", "ArcanumButton7Menu"..MountButtonPosition, "CENTER", 0, 32);
            elseif ArcanumConfig.MountMenuPos == 4 then
                menuVariable:SetPoint("CENTER", "ArcanumButton7Menu"..MountButtonPosition, "CENTER", 0, -32);
            end
        end
        MountButtonPosition = i;
        table.insert(MountMenuCreate, menuVariable);
	end
	-- Maintenant que tous les boutons sont placés les uns à côté des autres (hors de l'écran), on affiche les disponibles
	for i = 1, #MountMenuCreate do
		ShowUIPanel(MountMenuCreate[i]);
	end
    
    
    -- Affichage des boutons des métiers en fonction du nombre de métiers
	for i = 1, #JobTable do
        menuVariable = getglobal("ArcanumButton9Menu"..i);
        menuVariable:ClearAllPoints();
        if JobButtonPosition == 0 then
            menuVariable:SetPoint("CENTER", "ArcanumButton9", "CENTER", 3000, 3000);
        else
            if ArcanumConfig.JobMenuPos == 1 then
                menuVariable:SetPoint("CENTER", "ArcanumButton9Menu"..JobButtonPosition, "CENTER", 32, 0);
            elseif ArcanumConfig.JobMenuPos == 2 then
                menuVariable:SetPoint("CENTER", "ArcanumButton9Menu"..JobButtonPosition, "CENTER", -32, 0);
            elseif ArcanumConfig.JobMenuPos == 3 then
                menuVariable:SetPoint("CENTER", "ArcanumButton9Menu"..JobButtonPosition, "CENTER", 0, 32);
            elseif ArcanumConfig.JobMenuPos == 4 then
                menuVariable:SetPoint("CENTER", "ArcanumButton9Menu"..JobButtonPosition, "CENTER", 0, -32);
            end
        end
        JobButtonPosition = i;
        table.insert(JobMenuCreate, menuVariable);
	end
	-- Maintenant que tous les boutons sont placés les uns à côté des autres (hors de l'écran), on affiche les disponibles
	for i = 1, #JobMenuCreate do
		ShowUIPanel(JobMenuCreate[i]);
	end
    
    -- Affichage des boutons des gardien en fonction du nombre de gardiens
	if ARCANUM_SPELL_TABLE.ID[57] ~= nil then
		menuVariable = getglobal("ArcanumButton10Menu"..WardButtonPosition + 1);
		menuVariable:ClearAllPoints();
		menuVariable:SetPoint("CENTER", "ArcanumButton10", "CENTER", 3000, 3000);
		WardButtonPosition = 1;
		table.insert(WardMenuCreate, menuVariable);
	end
	if (ARCANUM_SPELL_TABLE.ID[58] ~= nil) then
		menuVariable = getglobal("ArcanumButton10Menu"..WardButtonPosition + 1);
		menuVariable:ClearAllPoints();
		if WardButtonPosition == 0 then
			menuVariable:SetPoint("CENTER", "ArcanumButton10", "CENTER", 3000, 3000);
		else
			if ArcanumConfig.WardMenuPos == 1 then
				menuVariable:SetPoint("CENTER", "ArcanumButton10Menu"..WardButtonPosition, "CENTER", 32, 0);
			elseif ArcanumConfig.WardMenuPos == 2 then
                menuVariable:SetPoint("CENTER", "ArcanumButton10Menu"..WardButtonPosition, "CENTER", -32, 0);
            elseif ArcanumConfig.WardMenuPos == 3 then
                menuVariable:SetPoint("CENTER", "ArcanumButton10Menu"..WardButtonPosition, "CENTER", 0, 32);
            elseif ArcanumConfig.WardMenuPos == 4 then
				menuVariable:SetPoint("CENTER", "ArcanumButton10Menu"..WardButtonPosition, "CENTER", 0, -32);
			end
		end
		WardButtonPosition = 2;
		table.insert(WardMenuCreate, menuVariable);
	end
	-- Maintenant que tous les boutons sont placés les uns à côté des autres (hors de l'écran), on affiche les disponibles
	for i = 1, #WardMenuCreate do
		ShowUIPanel(WardMenuCreate[i]);
	end
end

-- Ouverture du menu des buffs
function Arcanum_BuffMenu(button)
	if (button == "RightButton") then
        BuffMenuShow = not BuffMenuShow;
        if not BuffMenuShow then
            BuffShow = false;
            BuffVisible = false;
--~             BuffMenuCreate[1]:ClearAllPoints();
--~             BuffMenuCreate[1]:SetPoint("CENTER", "ArcanumButton4", "CENTER", 3000, 3000);
            AlphaBuffMenu = 1;
        else
            BuffShow = true;
            -- Si clic milieu, le menu de buff reste ouvert
            if button == "MiddleButton" then
                BuffVisible = true;
            end
            -- S'il n'existe aucun buff on ne fait rien
            if BuffMenuCreate == nil then
                return;
            end
            -- Sinon on affiche les icones
            ArcanumButton4Menu1:SetAlpha(1);
            ArcanumButton4Menu2:SetAlpha(1);
            if Combat == false then
                BuffMenuCreate[1]:ClearAllPoints();
                BuffMenuCreate[1]:SetPoint("CENTER", "ArcanumButton4", "CENTER", (ArcanumConfig.MenuPosition * xBuffMenuPos / 100), ArcanumConfig.MenuPosition * yBuffMenuPos / 100);
            end
            AlphaBuffVar = GetTime() + 6;
        end
    else
        BuffMenuShow = not BuffMenuShow;
        BuffShow = false;
        BuffVisible = false;
--~         BuffMenuCreate[1]:ClearAllPoints();
--~         BuffMenuCreate[1]:SetPoint("CENTER", "ArcanumButton4", "CENTER", 3000, 3000);
        AlphaBuffMenu = 1;
    end
end

-- Gestion des casts du menu des buffs
function Arcanum_BuffCast(type, Shortcut)
	local TargetEnemy = false;
	if (not (UnitIsFriend("player", "target"))) then
		TargetUnit("player");
		TargetEnemy = true;
	end
	if (type == 4) then
		if ArcanumConfig.LevelBuff == true then
			if (UnitExists("target")) then
				for i = ARCANUM_SPELL_TABLE.Rank[4], 1, -1 do
					if UnitLevel("target") >= Buff_Minlvl[i] then
						local BuffName = ARCANUM_SPELL_TABLE.Name[12].."("..ARCANUM_TRANSLATION.Rank.." "..i..")";
						CastSpellByName(BuffName, "spell");
						break;
					end
				end
			end
		else
			CastSpell(ARCANUM_SPELL_TABLE.ID[12], "spell");
		end
	else
		CastSpell(ARCANUM_SPELL_TABLE.ID[type], "spell");
	end
	
    if Shortcut == true then
        ArcanumConfig.LastBuff = type;
        if ArcanumConfig.InterfaceVersion == 1 then
            ArcanumButton4Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[ArcanumConfig.LastBuff]);
            OrderButton4Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[ArcanumConfig.LastBuff]);
            if ArcanumArcanePowder == 0 then
                ArcanumButton4Text:SetText("");
                if ArcanumConfig.LastBuff == 13 then
                    ArcanumButton4Texture:SetDesaturated(1);
                else
                    ArcanumButton4Texture:SetDesaturated(nil);
                end 
            else
                ArcanumButton4Texture:SetDesaturated(nil);
                if ArcanumConfig.LastBuff == 13 then
                    ArcanumButton4Text:SetText(ArcanumArcanePowder);
                else
                    ArcanumButton4Text:SetText("");
                end     
            end
        end
    end
    
	if TargetEnemy then TargetLastTarget(); end
	AlphaBuffMenu = 1;
	AlphaBuffVar = GetTime() + 3;
end

-- Ouverture du menu des armures
function Arcanum_ArmorMenu(button)
    if button == "RightButton" then
        ArmorMenuShow = not ArmorMenuShow;
        if not ArmorMenuShow then
            ArmorShow = false;
            ArmorVisible = false;
--~             ArmorMenuCreate[1]:ClearAllPoints();
--~             ArmorMenuCreate[1]:SetPoint("CENTER", "ArcanumButton5", "CENTER", 3000, 3000);
            AlphaArmorMenu = 1;
        else
            ArmorShow = true;
            -- Si clic milieu, le menu de buff reste ouvert
            if button == "MiddleButton" then
                ArmorVisible = true;
            end
            -- S'il n'existe aucun buff on ne fait rien
            if ArmorMenuCreate == nil then
                return;
            end
            -- Sinon on affiche les icones
            ArcanumButton5Menu1:SetAlpha(1);
            ArcanumButton5Menu2:SetAlpha(1);
            ArcanumButton5Menu3:SetAlpha(1);
            if Combat == false then
                ArmorMenuCreate[1]:ClearAllPoints();
                ArmorMenuCreate[1]:SetPoint("CENTER", "ArcanumButton5", "CENTER", ArcanumConfig.MenuPosition * xArmorMenuPos / 100, ArcanumConfig.MenuPosition * yArmorMenuPos / 100);
            end
            AlphaArmorVar = GetTime() + 6;
        end
    else
        ArmorMenuShow = not ArmorMenuShow;
        ArmorShow = false;
        ArmorVisible = false;
--~         ArmorMenuCreate[1]:ClearAllPoints();
--~         ArmorMenuCreate[1]:SetPoint("CENTER", "ArcanumButton5", "CENTER", 3000, 3000);
        AlphaArmorMenu = 1;
    end
end

-- Gestion des casts du menu des buffs
function Arcanum_ArmorCast(type, Shortcut)
	-- Si le mage possède l'armure de glace
	if (ARCANUM_SPELL_TABLE.ID[type] ~= nil) then
		CastSpell(ARCANUM_SPELL_TABLE.ID[type], "spell");
	else
		CastSpell(ARCANUM_SPELL_TABLE.ID[1], "spell");
	end
    
    if Shortcut == true then
    	if (ARCANUM_SPELL_TABLE.ID[type] ~= nil) then
            ArcanumConfig.LastArmor = type;
        else
            ArcanumConfig.LastArmor = 1;
        end
        if ArcanumConfig.InterfaceVersion == 1 then
            ArcanumButton5Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[ArcanumConfig.LastArmor]);
            OrderButton5Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[ArcanumConfig.LastArmor]);
        end
    end
    
	AlphaArmorMenu = 1;
	AlphaArmorVar = GetTime() + 3;
end

-- Ouverture du menu des armures
function Arcanum_MagicMenu(button)
	if button == "RightButton" then
        MagicMenuShow = not MagicMenuShow;
        if not MagicMenuShow then
            MagicShow = false;
            MagicVisible = false;
--~             MagicMenuCreate[1]:ClearAllPoints();
--~             MagicMenuCreate[1]:SetPoint("CENTER", "ArcanumButton6", "CENTER", 3000, 3000);
            AlphaMagicMenu = 1;
        else
            MagicShow = true;
            -- Si clic milieu, le menu de buff reste ouvert
            if button == "MiddleButton" then
                MagicVisible = true;
            end
            -- S'il n'existe aucun buff on ne fait rien
            if MagicMenuCreate == nil then
                return;
            end
            -- Sinon on affiche les icones
            ArcanumButton6Menu1:SetAlpha(1);
            ArcanumButton6Menu2:SetAlpha(1);
            if Combat == false then
                MagicMenuCreate[1]:ClearAllPoints();
                MagicMenuCreate[1]:SetPoint("CENTER", "ArcanumButton6", "CENTER", ArcanumConfig.MenuPosition * xMagicMenuPos / 100, ArcanumConfig.MenuPosition * yMagicMenuPos / 100);
            end
            AlphaMagicVar = GetTime() + 6;
        end
    else
        MagicMenuShow = not MagicMenuShow;
        MagicShow = false;
        MagicVisible = false;
--~         MagicMenuCreate[1]:ClearAllPoints();
--~         MagicMenuCreate[1]:SetPoint("CENTER", "ArcanumButton6", "CENTER", 3000, 3000);
        AlphaMagicMenu = 1;
    end
end

-- Gestion des casts du menu des buffs
function Arcanum_MagicCast(type, Shortcut)
	local TargetEnemy = false;
	if (not (UnitIsFriend("player", "target"))) and type ~= 9 then
		TargetUnit("player");
		TargetEnemy = true;
	end
--~     if ArcanumConfig.LevelBuff == true then
--~ 		if (UnitExists("target")) then
--~ 			for i = ARCANUM_SPELL_TABLE.Rank[type], 1, -1 do
--~                 if type == 7 then
--~                     if UnitLevel("target") >= Amplify_Minlvl[i] then
--~                         local BuffName = ARCANUM_SPELL_TABLE.Name[7].."("..ARCANUM_TRANSLATION.Rank.." "..i..")";
--~                         CastSpellByName(BuffName, "spell");
--~                         break;
--~                     end
--~                 elseif type == 6 then
--~                     if UnitLevel("target") >= Dampen_Minlvl[i] then
--~                         local BuffName = ARCANUM_SPELL_TABLE.Name[6].."("..ARCANUM_TRANSLATION.Rank.." "..i..")";
--~                         CastSpellByName(BuffName, "spell");
--~                         break;
--~                     end
--~                 end
--~ 			end
--~ 		end
--~ 	else
		CastSpell(ARCANUM_SPELL_TABLE.ID[type], "spell");
--~ 	end
	
    if Shortcut == true then
        ArcanumConfig.LastMagic = type;
        if ArcanumConfig.InterfaceVersion == 1 then
            ArcanumButton6Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[ArcanumConfig.LastMagic]);
            OrderButton6Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[ArcanumConfig.LastMagic]);
        end
    end
    
	if TargetEnemy then TargetLastTarget(); end
	AlphaMagicMenu = 1;
	AlphaMagicVar = GetTime() + 3;
end

-- Ouverture du menu des portails
function Arcanum_PortalMenu(button)
	if button == "RightButton" then
        PortalMenuShow = not PortalMenuShow;
        if not PortalMenuShow then
            PortalShow = false;
            PortalVisible = false;
--~             PortalMenuCreate[1]:ClearAllPoints();
--~             PortalMenuCreate[1]:SetPoint("CENTER", "ArcanumButton8", "CENTER", 3000, 3000);
            AlphaPortalMenu = 1;
        else
            PortalShow = true;
            -- Si clic milieu, le menu des portails reste ouvert
            if button == "MiddleButton" then
                PortalVisible = true;
            end
            -- S'il n'existe aucun portail on ne fait rien
            if PortalMenuCreate[1] == nil then
                return;
            end
            -- Sinon on affiche les icones
            ArcanumButton8Menu1:SetAlpha(1);
            ArcanumButton8Menu2:SetAlpha(1);
            ArcanumButton8Menu3:SetAlpha(1);
            ArcanumButton8Menu4:SetAlpha(1);
            ArcanumButton8Menu5:SetAlpha(1);
            ArcanumButton8Menu6:SetAlpha(1);
            ArcanumButton8Menu7:SetAlpha(1);
            ArcanumButton8Menu8:SetAlpha(1);
            ArcanumButton8Menu9:SetAlpha(1);
            ArcanumButton8Menu10:SetAlpha(1);
            ArcanumButton8Menu11:SetAlpha(1);
            ArcanumButton8Menu12:SetAlpha(1);
            ArcanumButton8Menu13:SetAlpha(1);                        
            if Combat == false then
                PortalMenuCreate[1]:ClearAllPoints();
                PortalMenuCreate[1]:SetPoint("CENTER", "ArcanumButton8", "CENTER", ArcanumConfig.MenuPosition * xPortalMenuPos / 100, ArcanumConfig.MenuPosition * yPortalMenuPos / 100);
            end
            AlphaPortalVar = GetTime() + 6;
        end
    else
        PortalMenuShow = not PortalMenuShow;
        PortalShow = false;
        PortalVisible = false;
--~         PortalMenuCreate[1]:ClearAllPoints();
--~         PortalMenuCreate[1]:SetPoint("CENTER", "ArcanumButton8", "CENTER", 3000, 3000);
        AlphaPortalMenu = 1;
    end
end

-- Gestion des casts du menu des portails
function Arcanum_PortalCast(type)
    getglobal("ArcanumButton8Menu"..ArcanumConfig.LastPortal):SetScale(ArcanumConfig.ArcanumButtonScale / 100);
    ArcanumConfig.LastPortal = type;
    OrderButton8Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[ArcanumConfig.LastPortal + 13]);
	
    AlphaPortalMenu = 1;
	AlphaPortalVar = GetTime() + 3;
	
    Arcanum_UpdateButtonsScale();
end

function Arcanum_MountMenu(button)
    if button == "RightButton" then
        MountMenuShow = not MountMenuShow;
        if not MountMenuShow then
            MountShow = false;
            MountVisible = false;
--~             MountMenuCreate[1]:ClearAllPoints();
--~             MountMenuCreate[1]:SetPoint("CENTER", "ArcanumButton7", "CENTER", 3000, 3000);
            AlphaMountMenu = 1;
        else
            MountShow = true;
            -- Si clic milieu, le menu des montures reste ouvert
            if button == "MiddleButton" then
                MountVisible = true;
            end
            -- S'il n'existe aucune monture on ne fait rien
            if MountMenuCreate[1] == nil then
                return;
            end
            -- Sinon on affiche les icones
            ArcanumButton7Menu1:SetAlpha(1);
            ArcanumButton7Menu2:SetAlpha(1);
            ArcanumButton7Menu3:SetAlpha(1);
            ArcanumButton7Menu4:SetAlpha(1);
            ArcanumButton7Menu5:SetAlpha(1);
            ArcanumButton7Menu6:SetAlpha(1);
            ArcanumButton7Menu7:SetAlpha(1);
            ArcanumButton7Menu8:SetAlpha(1);
            ArcanumButton7Menu9:SetAlpha(1);
            ArcanumButton7Menu10:SetAlpha(1);
            if Combat == false then
                MountMenuCreate[1]:ClearAllPoints();
                MountMenuCreate[1]:SetPoint("CENTER", "ArcanumButton7", "CENTER", ArcanumConfig.MenuPosition * xMountMenuPos / 100, ArcanumConfig.MenuPosition * yMountMenuPos / 100);
            end
            AlphaMountVar = GetTime() + 6;
        end
    elseif button == "LeftButton" then
        Arcanum_MountManagement();
    else
        MountMenuShow = not MountMenuShow;
        MountShow = false;
        MountVisible = false;
--~         MountMenuCreate[1]:ClearAllPoints();
--~         MountMenuCreate[1]:SetPoint("CENTER", "ArcanumButton7", "CENTER", 3000, 3000);
        AlphaMountMenu = 1;
    end
end

function Arcanum_MountCast(type)
    if MountLocation[type][1] ~= nil then
        local Mounted = nil;
        for i = 0, 23 do
            buffIndex, untilCancelled = GetPlayerBuff(i, "HELPFUL|PASSIVE");
            if ( buffIndex < 0 ) then
                break;
            elseif ( untilCancelled ) then
                ArcanumTooltip:SetPlayerBuff(buffIndex);
                if (ArcanumTooltipTextLeft2:IsShown()) then
                    text = ArcanumTooltipTextLeft2:GetText();
                    if (text) then
                        _, _, speed = string.find(text, MOUNT_SPEED);
                        if (speed) then
                            Mounted = i;
                        end
                    end
                end
            end
        end
        if Mounted == nil then
            if ArcanumConfig.RandMount == true then
                local randnum;
                if GetRealZoneText() == "Ahn'Qiraj" then
                    randnum = random(1, #AQMountLocation);
                else
                    randnum = random(1, #MountLocation - #AQMountLocation);
                end
                if #AQMountLocation > 1 then
                    while randnum == RandMount do
                        if GetRealZoneText() == "Ahn'Qiraj" then
                            randnum = random(1, #AQMountLocation);
                        else
                            randnum = random(1, #MountLocation - #AQMountLocation);
                        end
                    end
                end
                RandMount = randnum;
                if GetRealZoneText() == "Ahn'Qiraj" then

                else

                end
                getglobal("ArcanumButton7Menu"..ArcanumConfig.LastMount):SetScale(ArcanumConfig.ArcanumButtonScale / 100);
                ArcanumConfig.LastMount = RandMount;
                OrderButton7Texture:SetTexture(MountIcon[RandMount]);
            else
                getglobal("ArcanumButton7Menu"..ArcanumConfig.LastMount):SetScale(ArcanumConfig.ArcanumButtonScale / 100);
                ArcanumConfig.LastMount = type;
                OrderButton7Texture:SetTexture(MountIcon[type]);
            end
        else
            CancelPlayerBuff(Mounted);
        end
        AlphaMountMenu = 1;
        AlphaMountVar = GetTime() + 3;
        
        Arcanum_UpdateButtonsScale();
        
       
	end
end

function Arcanum_JobMenu(button)
    if button == "RightButton" then
        JobMenuShow = not JobMenuShow;
        if not JobMenuShow then
            JobShow = false;
            JobVisible = false;
--~             JobMenuCreate[1]:ClearAllPoints();
--~             JobMenuCreate[1]:SetPoint("CENTER", "ArcanumButton9", "CENTER", 3000, 3000);
            AlphaJobMenu = 1;
        else
            JobShow = true;
            -- Si clic milieu, le menu des monture reste ouvert
            if button == "MiddleButton" then
                JobVisible = true;
            end
            -- S'il n'existe aucune monture on ne fait rien
            if JobMenuCreate[1] == nil then
                return;
            end
            -- Sinon on affiche les icones
            ArcanumButton9Menu1:SetAlpha(1);
            ArcanumButton9Menu2:SetAlpha(1);
            ArcanumButton9Menu3:SetAlpha(1);
            ArcanumButton9Menu4:SetAlpha(1);
            ArcanumButton9Menu5:SetAlpha(1);
            ArcanumButton9Menu6:SetAlpha(1);
            ArcanumButton9Menu7:SetAlpha(1);
            ArcanumButton9Menu8:SetAlpha(1);
            if Combat == false then
                JobMenuCreate[1]:ClearAllPoints();
                JobMenuCreate[1]:SetPoint("CENTER", "ArcanumButton9", "CENTER", ArcanumConfig.MenuPosition * xJobMenuPos / 100, ArcanumConfig.MenuPosition * yJobMenuPos / 100);
            end
            AlphaJobVar = GetTime() + 6;
        end
    else
        JobMenuShow = not JobMenuShow;
        JobShow = false;
        JobVisible = false;
--~         JobMenuCreate[1]:ClearAllPoints();
--~         JobMenuCreate[1]:SetPoint("CENTER", "ArcanumButton9", "CENTER", 3000, 3000);
        AlphaJobMenu = 1;
    end
end

function Arcanum_JobCast(type)
    if ArcanumConfig.InterfaceVersion == 1 then
        getglobal("ArcanumButton9Menu"..ArcanumConfig.LastJob):SetScale(ArcanumConfig.ArcanumButtonScale / 100);
        ArcanumConfig.LastJob = type;
        OrderButton9Texture:SetTexture(ARCANUM_PROFESSIONS.Texture[JobTable[ArcanumConfig.LastJob]]);
    end
    
	AlphaJobMenu = 1;
	AlphaJobVar = GetTime() + 3;
    
    Arcanum_UpdateButtonsScale();
end

function Arcanum_WardMenu(button)
	if button == "RightButton" then
        WardMenuShow = not WardMenuShow;
        if not WardMenuShow then
            WardShow = false;
            WardVisible = false;
--~             WardMenuCreate[1]:ClearAllPoints();
--~             WardMenuCreate[1]:SetPoint("CENTER", "ArcanumButton10", "CENTER", 3000, 3000);
            AlphaWardMenu = 1;
        else
            WardShow = true;
            -- Si clic milieu, le menu des monture reste ouvert
            if button == "MiddleButton" then
                WardVisible = true;
            end
            -- S'il n'existe aucune monture on ne fait rien
            if WardMenuCreate[1] == nil then
                return;
            end
            -- Sinon on affiche les icones
            ArcanumButton10Menu1:SetAlpha(1);
            ArcanumButton10Menu2:SetAlpha(1);
            if Combat == false then
                WardMenuCreate[1]:ClearAllPoints();
                WardMenuCreate[1]:SetPoint("CENTER", "ArcanumButton10", "CENTER", ArcanumConfig.MenuPosition * xWardMenuPos / 100, ArcanumConfig.MenuPosition * yWardMenuPos / 100);
            end
            AlphaWardVar = GetTime() + 6;
        end
    else
        WardMenuShow = not WardMenuShow;
        WardShow = false;
        WardVisible = false;
--~         WardMenuCreate[1]:ClearAllPoints();
--~         WardMenuCreate[1]:SetPoint("CENTER", "ArcanumButton10", "CENTER", 3000, 3000);
        AlphaWardMenu = 1;
	end
end

function Arcanum_WardCast(type, Shortcut)
    
    if Shortcut == true then
        ArcanumConfig.LastWard = type;
        if ArcanumConfig.InterfaceVersion == 1 then
            ArcanumButton10Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[ArcanumConfig.LastWard]);
            OrderButton10Texture:SetTexture(ARCANUM_SPELL_TABLE.Texture[ArcanumConfig.LastWard]);
        end
    end
    
	AlphaWardMenu = 1;
	AlphaWardVar = GetTime() + 3;
end

function Arcanum_UpdateButtonAttribute(button, value, value2)
    if Combat == false then
        getglobal("ArcanumButton"..button):SetAttribute("type1", "spell");
        getglobal("ArcanumButton"..button):SetAttribute("spell1", ARCANUM_SPELL_TABLE.Name[value]);
        getglobal("ArcanumButton"..button):SetAttribute("type3", "spell");
        getglobal("ArcanumButton"..button):SetAttribute("spell3", ARCANUM_SPELL_TABLE.Name[value2]);   
        getglobal("ArcanumButton"..button.."Texture"):SetTexture(ARCANUM_SPELL_TABLE.Texture[value]);
        getglobal("OrderButton"..button.."Texture"):SetTexture(ARCANUM_SPELL_TABLE.Texture[value]);
    else
        ButtonQueuedAttribute[button][1] = value;
        ButtonQueuedAttribute[button][2] = value2;
    end
end

function Arcanum_UpdateQueuedAttribute()
    for i = 1, 10 do
        if i == 9 then
            getglobal("ArcanumButton"..i):SetAttribute("type1", "spell");
            getglobal("ArcanumButton"..i):SetAttribute("spell", ARCANUM_PROFESSIONS.Name[JobTable[ButtonQueuedAttribute[i][1]]]);
            getglobal("ArcanumButton"..i.."Texture"):SetTexture(ARCANUM_PROFESSIONS.Texture[JobTable[ButtonQueuedAttribute[i][1]]]);
            getglobal("ArcanumButton"..i.."Texture"):SetTexture(ARCANUM_PROFESSIONS.Texture[JobTable[ButtonQueuedAttribute[i][1]]]);
        elseif i > 3 then
            getglobal("ArcanumButton"..i):SetAttribute("type1", "spell");
            getglobal("ArcanumButton"..i):SetAttribute("spell1", ARCANUM_SPELL_TABLE.Name[ButtonQueuedAttribute[i][1]]);
            getglobal("ArcanumButton"..i):SetAttribute("type3", "spell");
            getglobal("ArcanumButton"..i):SetAttribute("spell3", ARCANUM_SPELL_TABLE.Name[ButtonQueuedAttribute[i][2]]);
            getglobal("ArcanumButton"..i.."Texture"):SetTexture(ARCANUM_SPELL_TABLE.Texture[ButtonQueuedAttribute[i][1]]);
            getglobal("OrderButton"..i.."Texture"):SetTexture(ARCANUM_SPELL_TABLE.Texture[ButtonQueuedAttribute[i][1]]);
        end
    end
end

function Arcanum_UpdateButtonAttribute2(button, value)
    if Combat == false then
        getglobal("ArcanumButton"..button):SetAttribute("type1", "spell");
        getglobal("ArcanumButton"..button):SetAttribute("spell", ARCANUM_PROFESSIONS.Name[JobTable[value]]);
        getglobal("ArcanumButton"..button.."Texture"):SetTexture(ARCANUM_PROFESSIONS.Texture[JobTable[value]]);
        getglobal("ArcanumButton"..button.."Texture"):SetTexture(ARCANUM_PROFESSIONS.Texture[JobTable[value]]);
    else
        ButtonQueuedAttribute[button][1] = value;
    end
end



function Arcanum_SpellManagement()
	local ville;
    if SpellCastName == ARCANUM_SPELL_TABLE.Name[15] then
        ArcanumConfig.LastPortal = 15;
        if ArcanumConfig.InterfaceVersion == 1 then
            Arcanum_UpdateButtonAttribute(8, ArcanumConfig.LastPortal, nil);
        end
    elseif SpellCastName == ARCANUM_SPELL_TABLE.Name[16] then
		ArcanumConfig.LastPortal = 16;
        if ArcanumConfig.InterfaceVersion == 1 then
            Arcanum_UpdateButtonAttribute(8, ArcanumConfig.LastPortal, nil);
        end
	elseif SpellCastName == ARCANUM_SPELL_TABLE.Name[17] then
        ArcanumConfig.LastPortal = 17;
        if ArcanumConfig.InterfaceVersion == 1 then
            Arcanum_UpdateButtonAttribute(8, ArcanumConfig.LastPortal, nil);
        end
	elseif SpellCastName == ARCANUM_SPELL_TABLE.Name[18] then
        ArcanumConfig.LastPortal = 18;
        if ArcanumConfig.InterfaceVersion == 1 then
            Arcanum_UpdateButtonAttribute(8, ArcanumConfig.LastPortal, nil);
        end
	elseif SpellCastName == ARCANUM_SPELL_TABLE.Name[45] then
        ArcanumConfig.LastPortal = 45;
        if ArcanumConfig.InterfaceVersion == 1 then
            Arcanum_UpdateButtonAttribute(8, ArcanumConfig.LastPortal, nil);
        end		
	elseif SpellCastName == ARCANUM_SPELL_TABLE.Name[19] then
        ArcanumConfig.LastPortal = 19;
        if ArcanumConfig.InterfaceVersion == 1 then
            Arcanum_UpdateButtonAttribute(8, ArcanumConfig.LastPortal, nil);
        end
    elseif SpellCastName == ARCANUM_SPELL_TABLE.Name[20] then
        ArcanumConfig.LastPortal = 20;
        if ArcanumConfig.InterfaceVersion == 1 then
            Arcanum_UpdateButtonAttribute(8, ArcanumConfig.LastPortal, nil);
        end
	elseif SpellCastName == ARCANUM_SPELL_TABLE.Name[21] then
        ArcanumConfig.LastPortal = 21;
        if ArcanumConfig.InterfaceVersion == 1 then
            Arcanum_UpdateButtonAttribute(8, ArcanumConfig.LastPortal, nil);
        end
    elseif SpellCastName == ARCANUM_SPELL_TABLE.Name[22] then
        ArcanumConfig.LastPortal = 22;
        if ArcanumConfig.InterfaceVersion == 1 then
            Arcanum_UpdateButtonAttribute(8, ArcanumConfig.LastPortal, nil);
        end
	elseif SpellCastName == ARCANUM_SPELL_TABLE.Name[47] then
        ArcanumConfig.LastPortal = 47;
        if ArcanumConfig.InterfaceVersion == 1 then
            Arcanum_UpdateButtonAttribute(8, ArcanumConfig.LastPortal, nil);
        end	
	elseif SpellCastName == ARCANUM_SPELL_TABLE.Name[40] then
        ArcanumConfig.LastPortal = 40;
        if ArcanumConfig.InterfaceVersion == 1 then
            Arcanum_UpdateButtonAttribute(8, ArcanumConfig.LastPortal, nil);
        end	
    elseif SpellCastName == ARCANUM_SPELL_TABLE.Name[23] then
        ville = 1;
        ArcanumConfig.LastPortal = 23;
        if ArcanumConfig.InterfaceVersion == 1 then
            Arcanum_UpdateButtonAttribute(8, ArcanumConfig.LastPortal, nil);
        end
    elseif SpellCastName == ARCANUM_SPELL_TABLE.Name[24] then
		ville = 2;
        ArcanumConfig.LastPortal = 24;
        if ArcanumConfig.InterfaceVersion == 1 then
            Arcanum_UpdateButtonAttribute(8, ArcanumConfig.LastPortal, nil);
        end
	elseif SpellCastName == ARCANUM_SPELL_TABLE.Name[25] then
        ville = 3;
        ArcanumConfig.LastPortal = 25;
        if ArcanumConfig.InterfaceVersion == 1 then
            Arcanum_UpdateButtonAttribute(8, ArcanumConfig.LastPortal, nil);
        end
	elseif SpellCastName == ARCANUM_SPELL_TABLE.Name[26] then
        ville = 4;
        ArcanumConfig.LastPortal = 26;
        if ArcanumConfig.InterfaceVersion == 1 then
            Arcanum_UpdateButtonAttribute(8, ArcanumConfig.LastPortal, nil);
        end
	elseif SpellCastName == ARCANUM_SPELL_TABLE.Name[44] then
		ville = 5;
        ArcanumConfig.LastPortal = 44;
        if ArcanumConfig.InterfaceVersion == 1 then
            Arcanum_UpdateButtonAttribute(8, ArcanumConfig.LastPortal, nil);
        end	
	elseif SpellCastName == ARCANUM_SPELL_TABLE.Name[27] then
		ville = 6;
        ArcanumConfig.LastPortal = 27;
        if ArcanumConfig.InterfaceVersion == 1 then
            Arcanum_UpdateButtonAttribute(8, ArcanumConfig.LastPortal, nil);
        end
    elseif SpellCastName == ARCANUM_SPELL_TABLE.Name[28] then
		ville = 7;
        ArcanumConfig.LastPortal = 28;
        if ArcanumConfig.InterfaceVersion == 1 then
            Arcanum_UpdateButtonAttribute(8, ArcanumConfig.LastPortal, nil);
        end
	elseif SpellCastName == ARCANUM_SPELL_TABLE.Name[29] then
		ville = 8;
        ArcanumConfig.LastPortal = 29;
        if ArcanumConfig.InterfaceVersion == 1 then
            Arcanum_UpdateButtonAttribute(8, ArcanumConfig.LastPortal, nil);
        end
	elseif SpellCastName == ARCANUM_SPELL_TABLE.Name[30] then
		ville = 9;
        ArcanumConfig.LastPortal = 30;
        if ArcanumConfig.InterfaceVersion == 1 then
            Arcanum_UpdateButtonAttribute(8, ArcanumConfig.LastPortal, nil);
        end
    elseif SpellCastName == ARCANUM_SPELL_TABLE.Name[46] then
		ville = 10;
        ArcanumConfig.LastPortal = 46;
        if ArcanumConfig.InterfaceVersion == 1 then
            Arcanum_UpdateButtonAttribute(8, ArcanumConfig.LastPortal, nil);
        end
	elseif SpellCastName == ARCANUM_SPELL_TABLE.Name[41] then
		ville = 11;
        ArcanumConfig.LastPortal = 41;
        if ArcanumConfig.InterfaceVersion == 1 then
            Arcanum_UpdateButtonAttribute(8, ArcanumConfig.LastPortal, nil);
        end
    elseif SpellCastName == ARCANUM_SPELL_TABLE.Name[43] then
		ville = 12;
        ArcanumConfig.LastPortal = 43;
        if ArcanumConfig.InterfaceVersion == 1 then
            Arcanum_UpdateButtonAttribute(8, ArcanumConfig.LastPortal, nil);
        end	
		
	end
	if (SpellCastName) then
		if (ville) then
			if (ville < 12) then
				if ArcanumConfig.PortalMessage == true then
                			local tempnum = random(1, #ARCANUM_PORTAL_MESSAGES);
                			while tempnum == TPMess and #ARCANUM_PORTAL_MESSAGES >= 2 do
                			    tempnum = random(1, #ARCANUM_PORTAL_MESSAGES);
                			end
                			TPMess = tempnum;
                			for i = 1, #ARCANUM_PORTAL_MESSAGES[tempnum] do
                			    Arcanum_Msg(Arcanum_MsgReplace(ARCANUM_PORTAL_MESSAGES[tempnum][i], ville), "WORLD");
                			end
                		end
                	else
                		if ArcanumConfig.PortalMessage == true then
                 			local tempnum = random(1, #ARCANUM_RITUAL_MESSAGES);
                			while tempnum == TPMess and #ARCANUM_RITUAL_MESSAGES >= 2 do
                			    tempnum = random(1, #ARCANUM_RITUAL_MESSAGES);
                			end
                			TPMess = tempnum;
                			for i = 1, #ARCANUM_RITUAL_MESSAGES[tempnum] do
                			    Arcanum_Msg(ARCANUM_RITUAL_MESSAGES[tempnum][i], "WORLD");
                			end            			
                		end               	
            		end
		end
	end
	SpellCastName = nil;
	SpellCastRank = nil;
	return;
end


function Arcanum_SpellManagement2()
    if SpellCastName == ARCANUM_SPELL_TABLE.Name[1] then
        ArcanumConfig.LastArmor = 1;
        LastArmor = 0;
    elseif SpellCastName == ARCANUM_SPELL_TABLE.Name[2] then
        ArcanumConfig.LastArmor = 2;
        LastArmor = 3;
        if ArcanumConfig.InterfaceVersion == 1 then
            Arcanum_UpdateButtonAttribute(5, ArcanumConfig.LastArmor, LastArmor);
        end
    elseif SpellCastName == ARCANUM_SPELL_TABLE.Name[3] then
        ArcanumConfig.LastArmor = 3;
        LastArmor = 2;
        if ArcanumConfig.InterfaceVersion == 1 then
            Arcanum_UpdateButtonAttribute(5, ArcanumConfig.LastArmor, LastArmor);
        end
    elseif SpellCastName == ARCANUM_SPELL_TABLE.Name[4] then
        ArcanumConfig.LastArmor = 4;
        LastArmor = 3;
        if ArcanumConfig.InterfaceVersion == 1 then
            Arcanum_UpdateButtonAttribute(5, ArcanumConfig.LastArmor, LastArmor);
        end
    elseif SpellCastName == ARCANUM_SPELL_TABLE.Name[12] then
        ArcanumConfig.LastBuff = 12;
        LastBuff = 13;
        if ArcanumConfig.InterfaceVersion == 1 then
            Arcanum_UpdateButtonAttribute(4, ArcanumConfig.LastBuff, LastBuff);
            if ArcanumArcanePowder == 0 then
                ArcanumButton4Text:SetText("");
                if ArcanumConfig.LastBuff == 13 then
                    ArcanumButton4Texture:SetDesaturated(1);
                else
                    ArcanumButton4Texture:SetDesaturated(nil);
                end 
            else
                ArcanumButton4Texture:SetDesaturated(nil);
                if ArcanumConfig.LastBuff == 13 then
                    ArcanumButton4Text:SetText(ArcanumArcanePowder);
                else
                    ArcanumButton4Text:SetText("");
                end     
            end
        end
    elseif SpellCastName == ARCANUM_SPELL_TABLE.Name[13] then
        ArcanumConfig.LastBuff = 13;
        LastBuff = 12;
        if ArcanumConfig.InterfaceVersion == 1 then
            Arcanum_UpdateButtonAttribute(4, ArcanumConfig.LastBuff, LastBuff);
            if ArcanumArcanePowder == 0 then
                ArcanumButton4Text:SetText("");
                if ArcanumConfig.LastBuff == 13 then
                    ArcanumButton4Texture:SetDesaturated(1);
                else
                    ArcanumButton4Texture:SetDesaturated(nil);
                end 
            else
                ArcanumButton4Texture:SetDesaturated(nil);
                if ArcanumConfig.LastBuff == 13 then
                    ArcanumButton4Text:SetText(ArcanumArcanePowder);
                else
                    ArcanumButton4Text:SetText("");
                end     
            end
        end
    elseif SpellCastName == ARCANUM_SPELL_TABLE.Name[6] then
        ArcanumConfig.LastMagic = 6;
        LastMagic = 7;
        if ArcanumConfig.InterfaceVersion == 1 then
            Arcanum_UpdateButtonAttribute(6, ArcanumConfig.LastMagic, LastMagic);
        end
    elseif SpellCastName == ARCANUM_SPELL_TABLE.Name[7] then
        ArcanumConfig.LastMagic = 7;
        LastMagic = 6;
        if ArcanumConfig.InterfaceVersion == 1 then
            Arcanum_UpdateButtonAttribute(6, ArcanumConfig.LastMagic, LastMagic);
        end
    elseif SpellCastName == ARCANUM_PROFESSIONS.Name[JobTable[1]] then
        ArcanumConfig.LastJob = 1;
        if ArcanumConfig.InterfaceVersion == 1 then
            Arcanum_UpdateButtonAttribute2(9, ArcanumConfig.LastJob);
        end
    elseif SpellCastName == ARCANUM_PROFESSIONS.Name[JobTable[2]] then
        ArcanumConfig.LastJob = 2;
        if ArcanumConfig.InterfaceVersion == 1 then
            Arcanum_UpdateButtonAttribute2(9, ArcanumConfig.LastJob);
        end
    elseif SpellCastName == ARCANUM_PROFESSIONS.Name[JobTable[3]] then
        ArcanumConfig.LastJob = 3;
        if ArcanumConfig.InterfaceVersion == 1 then
            Arcanum_UpdateButtonAttribute2(9, ArcanumConfig.LastJob);
        end
    elseif SpellCastName == ARCANUM_PROFESSIONS.Name[JobTable[4]] then
        ArcanumConfig.LastJob = 4;
        if ArcanumConfig.InterfaceVersion == 1 then
            Arcanum_UpdateButtonAttribute2(9, ArcanumConfig.LastJob);
        end
        elseif SpellCastName == ARCANUM_PROFESSIONS.Name[JobTable[5]] then
        ArcanumConfig.LastJob = 5;
        if ArcanumConfig.InterfaceVersion == 1 then
            Arcanum_UpdateButtonAttribute2(9, ArcanumConfig.LastJob);
        end
    elseif SpellCastName == ARCANUM_PROFESSIONS.Name[JobTable[6]] then
        ArcanumConfig.LastJob = 6;
        if ArcanumConfig.InterfaceVersion == 1 then
            Arcanum_UpdateButtonAttribute2(9, ArcanumConfig.LastJob);
        end
    elseif SpellCastName == ARCANUM_PROFESSIONS.Name[JobTable[7]] then
        ArcanumConfig.LastJob = 7;
        if ArcanumConfig.InterfaceVersion == 1 then
            Arcanum_UpdateButtonAttribute2(9, ArcanumConfig.LastJob);
        end
    elseif SpellCastName == ARCANUM_PROFESSIONS.Name[JobTable[8]] then
        ArcanumConfig.LastJob = 8;
        if ArcanumConfig.InterfaceVersion == 1 then
            Arcanum_UpdateButtonAttribute2(9, ArcanumConfig.LastJob);
        end
    elseif SpellCastName == ARCANUM_SPELL_TABLE.Name[57] then
        ArcanumConfig.LastWard = 57;
        LastWard = 58;
        if ArcanumConfig.InterfaceVersion == 1 then
            Arcanum_UpdateButtonAttribute(10, ArcanumConfig.LastWard, LastWard);
        end
    elseif SpellCastName == ARCANUM_SPELL_TABLE.Name[58] then
        ArcanumConfig.LastWard = 58;
        LastWard = 57;
        if ArcanumConfig.InterfaceVersion == 1 then
            Arcanum_UpdateButtonAttribute(10, ArcanumConfig.LastWard, LastWard);
        end
    
    
    elseif SpellCastName == ARCANUM_SPELL_TABLE.Name[52] then
        
    elseif SpellCastName == ARCANUM_SPELL_TABLE.Name[51] then
    
    elseif SpellCastName == ARCANUM_SPELL_TABLE.Name[50] then
    
    elseif SpellCastName == ARCANUM_SPELL_TABLE.Name[49] then
    
    end
end

function Arcanum_MountManagement()
    if Combat == false then
        if MountLocation[ArcanumConfig.LastMount][1] ~= nil then
            Mounted = 0;
            for i = 1, 23 do
                buffIndex, untilCancelled = GetPlayerBuff(i, "HELPFUL|PASSIVE");
                if ( buffIndex < 0 ) then
                    break;
                elseif ( untilCancelled ) then
                    ArcanumTooltip:SetPlayerBuff(buffIndex);
                    if (ArcanumTooltipTextLeft2:IsShown()) then
                        text = ArcanumTooltipTextLeft2:GetText();
                        if (text) then
                            _, _, speed = string.find(text, MOUNT_SPEED);
                            if (speed) then
                                Mounted = buffIndex;
                                break;
                            end
                        end
                    end
                end
            end
            if Mounted == 0 then
                if ArcanumConfig.RandMount == true then
                    local randnum;
                    if GetRealZoneText() == "Ahn'Qiraj" then
                        randnum = random(1, table.getn(AQMountLocation));
                    else
                         randnum = random(1, table.getn(MountLocation) - table.getn(AQMountLocation));
                    end
                    if table.getn(AQMountLocation) > 1 then
                        while randnum == RandMount do
                            if GetRealZoneText() == "Ahn'Qiraj" then
                                randnum = random(1, table.getn(AQMountLocation));
                            else
                                randnum = random(1, table.getn(MountLocation) - table.getn(AQMountLocation));
                            end
                        end
                    end
                    RandMount = randnum;
                    if GetRealZoneText() == "Ahn'Qiraj" then
                        ArcanumButton7:SetAttribute("type1", "item");
                        ArcanumButton7:SetAttribute("bag1", AQMountLocation[RandMount][1])
                        ArcanumButton7:SetAttribute("slot1", AQMountLocation[RandMount][2])
                    else
                        ArcanumButton7:SetAttribute("type1", "item");
                        ArcanumButton7:SetAttribute("bag1", MountLocation[RandMount][1])
                        ArcanumButton7:SetAttribute("slot1", MountLocation[RandMount][2])
                    end
                    ArcanumConfig.LastMount = RandMount;
                else
                    ArcanumButton7:SetAttribute("type1", "item");
                    ArcanumButton7:SetAttribute("bag1", MountLocation[ArcanumConfig.LastMount][1]);
                    ArcanumButton7:SetAttribute("slot1", MountLocation[ArcanumConfig.LastMount][2]);
--~                     ArcanumButton7:SetAttribute("type3", "item");
--~                     ArcanumButton7:SetAttribute("item3", ARCANUM_ITEM.Hearthstone);
                end
                ArcanumButton7Texture:SetTexture(MountIcon[ArcanumConfig.LastMount]);
                OrderButton7Texture:SetTexture(MountIcon[ArcanumConfig.LastMount]);
            else
                CancelPlayerBuff(Mounted);
                ArcanumButton7:SetAttribute("type1", "item");
                ArcanumButton7:SetAttribute("bag1", nil);
                ArcanumButton7:SetAttribute("slot1", nil);
            end
            AlphaMountMenu = 1;
            AlphaMountVar = GetTime() + 3;
        end
		if ArcanumConfig.MountMessage == true then
			local tempnum = random(1, #ARCANUM_MOUNT_MESSAGES);
			while tempnum == TPMess and #ARCANUM_MOUNT_MESSAGES >= 2 do
				tempnum = random(1, #ARCANUM_MOUNT_MESSAGES);
			end
			TPMess = tempnum;
			for i = 1, #ARCANUM_MOUNT_MESSAGES[tempnum] do
				Arcanum_Msg(ARCANUM_MOUNT_MESSAGES[tempnum][i], "WORLD");
			end
		end	
    end
end

function Arcanum_MountPostClick()
    if Mounted ~=0 then
        ArcanumButton7:SetAttribute("type1", "item");
        ArcanumButton7:SetAttribute("bag1", MountLocation[ArcanumConfig.LastMount][1]);
        ArcanumButton7:SetAttribute("slot1", MountLocation[ArcanumConfig.LastMount][2]);
        Mounted = 0;
    end
end
------------------------------------------------------------------------------------------------------

-- FONCTION DE GESTION DES COMBOBOX

------------------------------------------------------------------------------------------------------

function ArcanumInsideDisplayDropDown_Initialize()
	local index;
	local info = {};
	
	for i in pairs(ArcanumInsideDisplayClick) do
		info.text = ArcanumInsideDisplayClick[i];
		info.checked = nil;
		info.func = ArcanumInsideDisplayDropDown_OnClick;
		UIDropDownMenu_AddButton(info);
	end
end

function ArcanumInsideDisplayDropDown_OnClick()
	UIDropDownMenu_SetSelectedID(ArcanumInsideDisplayDropDown, this:GetID());
    ArcanumConfig.InsideDisplay = this:GetID();
end

function ArcanumLeftClickDropDown_Initialize()
	local index;
	local info = {};
	
	for i in pairs(ArcanumLeftButtonClick) do
		info.text = ArcanumLeftButtonClick[i];
		info.checked = nil;
		info.func = ArcanumLeftClickDropDown_OnClick;
		UIDropDownMenu_AddButton(info);
	end
end

function ArcanumLeftClickDropDown_OnClick()
	UIDropDownMenu_SetSelectedID(ArcanumLeftClickDropDown, this:GetID());
    ArcanumConfig.LeftClick = this:GetID();
    Arcanum_UpdateCentralButon();
end

function ArcanumMiddleClickDropDown_Initialize()
	local index;
	local info = {};
	
	for i in pairs(ArcanumMiddleButtonClick) do
		info.text = ArcanumMiddleButtonClick[i];
		info.checked = nil;
		info.func = ArcanumMiddleClickDropDown_OnClick;
		UIDropDownMenu_AddButton(info);
	end
end

function ArcanumMiddleClickDropDown_OnClick()
	UIDropDownMenu_SetSelectedID(ArcanumMiddleClickDropDown, this:GetID());
    ArcanumConfig.MiddleClick = this:GetID();
    Arcanum_UpdateCentralButon();
end

function ArcanumRightClickDropDown_Initialize()
	local index;
	local info = {};
	
	for i in pairs(ArcanumRightButtonClick) do
		info.text = ArcanumRightButtonClick[i];
		info.checked = nil;
		info.func = ArcanumRightClickDropDown_OnClick;
		UIDropDownMenu_AddButton(info);
	end
end

function ArcanumRightClickDropDown_OnClick()
	UIDropDownMenu_SetSelectedID(ArcanumRightClickDropDown, this:GetID());
    ArcanumConfig.RightClick = this:GetID();
    Arcanum_UpdateCentralButon();
end

function ArcanumBuffMenuDropDown_Initialize()
	local index;
	local info = {};
	
	for i in pairs(ArcanumBuffMenuClick) do
		info.text = ArcanumBuffMenuClick[i];
		info.checked = nil;
		info.func = ArcanumBuffMenuDropDown_OnClick;
		UIDropDownMenu_AddButton(info);
	end
end

function ArcanumBuffMenuDropDown_OnClick()
	UIDropDownMenu_SetSelectedID(ArcanumBuffMenuDropDown, this:GetID());
    ArcanumConfig.BuffMenuPos = this:GetID();
    Arcanum_CreateMenu();
end
function ArcanumArmorMenuDropDown_Initialize()
	local index;
	local info = {};
	
	for i in pairs(ArcanumArmorMenuClick) do
		info.text = ArcanumArmorMenuClick[i];
		info.checked = nil;
		info.func = ArcanumArmorMenuDropDown_OnClick;
		UIDropDownMenu_AddButton(info);
	end
end

function ArcanumArmorMenuDropDown_OnClick()
	UIDropDownMenu_SetSelectedID(ArcanumArmorMenuDropDown, this:GetID());
    ArcanumConfig.ArmorMenuPos = this:GetID();
    Arcanum_CreateMenu();
end
function ArcanumMagicMenuDropDown_Initialize()
	local index;
	local info = {};
	
	for i in pairs(ArcanumMagicMenuClick) do
		info.text = ArcanumMagicMenuClick[i];
		info.checked = nil;
		info.func = ArcanumMagicMenuDropDown_OnClick;
		UIDropDownMenu_AddButton(info);
	end
end

function ArcanumMagicMenuDropDown_OnClick()
	UIDropDownMenu_SetSelectedID(ArcanumMagicMenuDropDown, this:GetID());
    ArcanumConfig.MagicMenuPos = this:GetID();
    Arcanum_CreateMenu();
end
function ArcanumPortalMenuDropDown_Initialize()
	local index;
	local info = {};
	
	for i in pairs(ArcanumPortalMenuClick) do
		info.text = ArcanumPortalMenuClick[i];
		info.checked = nil;
		info.func = ArcanumPortalMenuDropDown_OnClick;
		UIDropDownMenu_AddButton(info);
	end
end

function ArcanumPortalMenuDropDown_OnClick()
	UIDropDownMenu_SetSelectedID(ArcanumPortalMenuDropDown, this:GetID());
    ArcanumConfig.PortalMenuPos = this:GetID();
    Arcanum_CreateMenu();
end
function ArcanumMountMenuDropDown_Initialize()
	local index;
	local info = {};
	
	for i in pairs(ArcanumMountMenuClick) do
		info.text = ArcanumMountMenuClick[i];
		info.checked = nil;
		info.func = ArcanumMountMenuDropDown_OnClick;
		UIDropDownMenu_AddButton(info);
	end
end

function ArcanumMountMenuDropDown_OnClick()
	UIDropDownMenu_SetSelectedID(ArcanumMountMenuDropDown, this:GetID());
    ArcanumConfig.MountMenuPos = this:GetID();
    Arcanum_CreateMenu();
end
function ArcanumJobMenuDropDown_Initialize()
	local index;
	local info = {};
	
	for i in pairs(ArcanumJobMenuClick) do
		info.text = ArcanumJobMenuClick[i];
		info.checked = nil;
		info.func = ArcanumJobMenuDropDown_OnClick;
		UIDropDownMenu_AddButton(info);
	end
end

function ArcanumJobMenuDropDown_OnClick()
	UIDropDownMenu_SetSelectedID(ArcanumJobMenuDropDown, this:GetID());
    ArcanumConfig.JobMenuPos = this:GetID();
    Arcanum_CreateMenu();
end
function ArcanumWardMenuDropDown_Initialize()
	local index;
	local info = {};
	
	for i in pairs(ArcanumWardMenuClick) do
		info.text = ArcanumWardMenuClick[i];
		info.checked = nil;
		info.func = ArcanumWardMenuDropDown_OnClick;
		UIDropDownMenu_AddButton(info);
	end
end

function ArcanumWardMenuDropDown_OnClick()
	UIDropDownMenu_SetSelectedID(ArcanumWardMenuDropDown, this:GetID());
    ArcanumConfig.WardMenuPos = this:GetID();
    Arcanum_CreateMenu();
end

function ArcanumConsumeFoodDropDown_Initialize()
	local index;
	local info = {};
	
	for i in pairs(ArcanumConsumeFoodClick) do
		info.text = ArcanumConsumeFoodClick[i];
		info.checked = nil;
		info.func = ArcanumConsumeFoodDropDown_OnClick;
		UIDropDownMenu_AddButton(info);
	end
end

function ArcanumConsumeFoodDropDown_OnClick()
	UIDropDownMenu_SetSelectedID(ArcanumConsumeFoodDropDown, this:GetID());
    ArcanumConfig.ConsumeFood = this:GetID();
end

function ArcanumConsumeGemsDropDown_Initialize()
	local index;
	local info = {};
	
	for i in pairs(ArcanumConsumeGemsClick) do
		info.text = ArcanumConsumeGemsClick[i];
		info.checked = nil;
		info.func = ArcanumConsumeGemsDropDown_OnClick;
		UIDropDownMenu_AddButton(info);
	end
end

function ArcanumConsumeGemsDropDown_OnClick()
	UIDropDownMenu_SetSelectedID(ArcanumConsumeGemsDropDown, this:GetID());
    ArcanumConfig.ConsumeGems = this:GetID();
end
------------------------------------------------------------------------------------------------------

-- FONCTIONS

------------------------------------------------------------------------------------------------------
function Arcanum_FillClickTable(table)
    ClearTable(table);
    for i = 1, table.getn(ARCANUM_CLICK) do
        table.insert(table, ARCANUM_CLICK[i]);
    end
end

function Arcanum_Click(button)
    if (button == 1) then
        Arcanum_UseItem("Evocation");
    elseif (button == 2) then
        if (UnitHealth("Player") < UnitHealthMax("Player")) then
            Arcanum_UseItem("Food", "LeftButton");
        end
        if (UnitMana("Player") < UnitManaMax("Player")) then
            Arcanum_UseItem("Water", "LeftButton");
        end
    elseif (button == 3) then
        if (ArcanumConfig.InterfaceVersion == 2) then
            if (ArcanumConfig.BuffType == 0) then
                --On passe de 'Solo' à 'en groupe'
                if (ARCANUM_SPELL_TABLE.ID[3] ~= nil or ARCANUM_SPELL_TABLE.ID[13] ~= nil or ARCANUM_SPELL_TABLE.ID[7] ~= nil or ARCANUM_SPELL_TABLE.ID[20] ~= nil or ARCANUM_SPELL_TABLE.ID[21] ~= nil or ARCANUM_SPELL_TABLE.ID[22] ~= nil or ARCANUM_SPELL_TABLE.ID[23] ~= nil or ARCANUM_SPELL_TABLE.ID[24] ~= nil or ARCANUM_SPELL_TABLE.ID[25] ~= nil) then
                    ArcanumConfig.BuffType = 1;
                    Arcanum_ArcanumButtonSetup();
                    Arcanum_LoadIconsV2();
                end
            else
                --On passe de 'en groupe' à 'Solo'
                ArcanumConfig.BuffType = 0;
                Arcanum_ArcanumButtonSetup();
                Arcanum_LoadIconsV2();
            end
		    GameTooltip:Hide();
        end
    elseif (button == 4) then
        if (ArcanumGeneralFrame:IsVisible()) then
            HideUIPanel(ArcanumGeneralFrame);
            return;
        else
            ShowUIPanel(ArcanumGeneralFrame);
            ArcanumGeneralTab_OnClick(1);
            return;
        end
        GameTooltip:Hide();
    elseif (button == 5) then
        Arcanum_UseItem("ManaGem", "LeftButton");
    elseif (button == 6) then
        Arcanum_UseItem("Iceblock");
    elseif (button == 7) then
        Arcanum_Trade();
        ArcanumTradeNow = true;
    elseif (button == 8) then
        Arcanum_UseItem("Hearthstone");
    end
end


function Arcanum_Cooldown()
    local start, duration;
 
    CoolDown[2][3], CoolDown[2][4] = nil;
    for i = 1, 5 do
        if (ManaGemExists[i] == true) then
            CoolDown[2][3] = ManaGemLocation[i][1];
            CoolDown[2][4] = ManaGemLocation[i][2];
        end
    end
    
    for i = 1, table.getn(CoolDown) - 3 do
        start, duration = 0;
        if (CoolDown[i][3] ~= nil) then
            if (CoolDown[i][4] == nil) then
                start, duration = GetSpellCooldown(CoolDown[i][3], "spell");
            else
                start, duration = GetContainerItemCooldown(CoolDown[i][3], CoolDown[i][4]);
            end
            if (start > 0 and duration > 0) then
                cooldown = duration - GetTime() + start;
                if cooldown > 60 then
                    CoolDown[i][1] = tostring(math.ceil(cooldown / 60)).."m";
                else
                    CoolDown[i][1] = tostring(math.ceil(cooldown)).."s";
                end
                if CoolDown[i][2] == true and cooldown > 10 then
                    CoolDown[i][2] = false;
                end
            else
                CoolDown[i][1] = nil;
            end
        end
    end

    CoolDown[8][1] = nil;
    CoolDown[9][1] = nil;
    CoolDown[10][1] = nil;
    --Temps restant d'intell et armure
    for i = 0, 23 do
        buffIndex, untilCancelled = GetPlayerBuff(i, "HELPFUL|HARMFUL|PASSIVE");
        if ( buffIndex < 0 ) then
            break;
        elseif ( untilCancelled ) then
            ArcanumTooltip:SetPlayerBuff(buffIndex);
            if (ArcanumTooltipTextLeft1:IsShown()) then
                local text = ArcanumTooltipTextLeft1:GetText();
                local time = GetPlayerBuffTimeLeft(buffIndex)
                if time ~= nil then
                    if time > 60 then
                        time = tostring(math.ceil(time / 60)).."m";
                    else
                        time = tostring(math.ceil(time)).."s";
                    end
                end
                if (text) then
                    if (text == ARCANUM_SPELL_TABLE.Name[1] or text == ARCANUM_SPELL_TABLE.Name[2]) then
                        ArcanumButtonDisplayTexture[7] = ARCANUM_SPELL_TABLE.Texture[1];
                        CoolDown[9][1] = time;
                        if CoolDown[9][2] == true then
                            CoolDown[9][2] = false;
                        end
                    elseif (text == ARCANUM_SPELL_TABLE.Name[3]) then
                        ArcanumButtonDisplayTexture[7] = ARCANUM_SPELL_TABLE.Texture[3];
                        CoolDown[9][1] = time;
                        if CoolDown[9][2] == true then
                            CoolDown[9][2] = false;
                        end
                    elseif (text == ARCANUM_SPELL_TABLE.Name[12]) then
                        ArcanumButtonDisplayTexture[6] = ARCANUM_SPELL_TABLE.Texture[12];
                        CoolDown[8][1] = time;
                        if CoolDown[8][2] == true then
                            CoolDown[8][2] = false;
                        end
                    elseif (text == ARCANUM_SPELL_TABLE.Name[13]) then
                        ArcanumButtonDisplayTexture[6] = ARCANUM_SPELL_TABLE.Texture[13];
                        CoolDown[8][1] = time;
                        if CoolDown[8][2] == true then
                            CoolDown[8][2] = false;
                        end
                    elseif (text == ARCANUM_BANDAGE) then
                        CoolDown[10][1] = time;
                        if CoolDown[10][2] == true then
                            CoolDown[10][2] = false;
                        end
                    end
                end
            end
        end
    end
end

function Arcanum_MenuFading()
    local curTime = GetTime();
	-- Gestion du menu des Intelligences
	if BuffShow then
		if GetTime() >= AlphaBuffVar and AlphaBuffMenu > 0 and (not BuffVisible) then
			AlphaBuffVar = GetTime() + 0.1;
			ArcanumButton4Menu1:SetAlpha(AlphaBuffMenu);
			ArcanumButton4Menu2:SetAlpha(AlphaBuffMenu);
			AlphaBuffMenu = AlphaBuffMenu - 0.1;
		end
		if AlphaBuffMenu <= 0 then
			Arcanum_BuffMenu();
		end
	end
	--Gestion du menu des armures
	if ArmorShow then
		if GetTime() >= AlphaArmorVar and AlphaArmorMenu > 0 and (not ArmorVisible) then
			AlphaArmorVar = GetTime() + 0.1;
			ArcanumButton5Menu1:SetAlpha(AlphaArmorMenu);
			ArcanumButton5Menu2:SetAlpha(AlphaArmorMenu);
            ArcanumButton5Menu3:SetAlpha(AlphaArmorMenu);
			AlphaArmorMenu = AlphaArmorMenu - 0.1;
		end
		if AlphaArmorMenu <= 0 then
			Arcanum_ArmorMenu();
		end
	end
	--Gestion du menu des magies
	if MagicShow then
		if GetTime() >= AlphaMagicVar and AlphaMagicMenu > 0 and (not MagicVisible) then
			AlphaMagicVar = GetTime() + 0.1;
			ArcanumButton6Menu1:SetAlpha(AlphaMagicMenu);
			ArcanumButton6Menu2:SetAlpha(AlphaMagicMenu);
			AlphaMagicMenu = AlphaMagicMenu - 0.1;
		end
		if AlphaMagicMenu <= 0 then
			Arcanum_MagicMenu();
		end
	end
	-- Gestion du menu des portails
	if PortalShow then
		if GetTime() >= AlphaPortalVar and AlphaPortalMenu > 0 and (not PortalVisible) then
			AlphaPortalVar = GetTime() + 0.1;
            for i = 1, 13 do
                getglobal("ArcanumButton8Menu"..i):SetAlpha(AlphaPortalMenu);
            end
			AlphaPortalMenu = AlphaPortalMenu - 0.1;
		end
		if AlphaPortalMenu <= 0 then
			Arcanum_PortalMenu();
		end
	end
    -- Gestion du menu des montures
	if MountShow then
		if GetTime() >= AlphaMountVar and AlphaMountMenu > 0 and (not MountVisible) then
			AlphaMountVar = GetTime() + 0.1;
            for i = 1, 10 do
                getglobal("ArcanumButton7Menu"..i):SetAlpha(AlphaMountMenu);
            end
			AlphaMountMenu = AlphaMountMenu - 0.1;
		end
		if AlphaMountMenu <= 0 then
			Arcanum_MountMenu();
		end
	end
    -- Gestion du menu des métiers
	if JobShow then
		if GetTime() >= AlphaJobVar and AlphaJobMenu > 0 and (not JobVisible) then
			AlphaJobVar = GetTime() + 0.1;
            for i = 1, 8 do
                getglobal("ArcanumButton9Menu"..i):SetAlpha(AlphaJobMenu);
            end
			AlphaJobMenu = AlphaJobMenu - 0.1;
		end
		if AlphaJobMenu <= 0 then
			Arcanum_JobMenu();
		end
	end
    -- Gestion du menu des gardiens
	if WardShow then
		if GetTime() >= AlphaWardVar and AlphaWardMenu > 0 and (not WardVisible) then
			AlphaWardVar = GetTime() + 0.1;
			ArcanumButton10Menu1:SetAlpha(AlphaWardMenu);
			ArcanumButton10Menu2:SetAlpha(AlphaWardMenu);
			AlphaWardMenu = AlphaWardMenu - 0.1;
		end
		if AlphaWardMenu <= 0 then
			Arcanum_WardMenu();
		end
	end
end

function Arcanum_SelectButtonOrder(Id)
    SelectedOrderButton = Id;
    for i = 1, 10 do
        Button = getglobal("OrderButton"..i.."Texture2");
        Button:SetTexture(UIPath.."ButtonCircle");
    end
    Button = getglobal("OrderButton"..Id.."Texture2");
    Button:SetVertexColor(ArcanumConfig.ButtonColor.r, ArcanumConfig.ButtonColor.g, ArcanumConfig.ButtonColor.b);
end

function Arcanum_SwitchButtonOrder(Way)
    if SelectedOrderButton ~= nil then
        local Temp = Arcanum_FindButton(SelectedOrderButton);
        if Temp == 1 and Way == -1 then
            ArcanumConfig.ButtonsOrder[Temp] = ArcanumConfig.ButtonsOrder[10];
            ArcanumConfig.ButtonsOrder[10] = SelectedOrderButton;
        elseif Temp == 10 and Way == 1 then
            ArcanumConfig.ButtonsOrder[Temp] = ArcanumConfig.ButtonsOrder[1];
            ArcanumConfig.ButtonsOrder[1] = SelectedOrderButton;
        else
            ArcanumConfig.ButtonsOrder[Temp] = ArcanumConfig.ButtonsOrder[Temp + Way];
            ArcanumConfig.ButtonsOrder[Temp + Way] = SelectedOrderButton;
        end
        Arcanum_UpdateButtonsScale();
    end
end

function Arcanum_FindButton(Id)
    for i = 1, table.getn(ArcanumConfig.ButtonsOrder) do
        if ArcanumConfig.ButtonsOrder[i] == Id then
            return i;
        end
    end
end







function Arcanum_ButtonMouseOver(button, menu)
    local Button;
    if menu == nil then
        if button <= 10 or button >= 41 then
            Button = getglobal("ArcanumButton"..button.."Texture2");
        else
            Button = getglobal("OrderButton"..(button-10).."Texture2");
        end
    else
        Button = getglobal("ArcanumButton"..button.."Menu"..menu.."Texture2");
    end
    Button:SetVertexColor(ArcanumConfig.ButtonColor.r, ArcanumConfig.ButtonColor.g, ArcanumConfig.ButtonColor.b);
end

function Arcanum_ButtonNormal(button, menu)
    local Button;
    if menu == nil then
        if button <= 10 or button >= 41 then
            Button = getglobal("ArcanumButton"..button.."Texture2");
        else
            Button = getglobal("OrderButton"..(button-10).."Texture2");
        end
    else
        Button = getglobal("ArcanumButton"..button.."Menu"..menu.."Texture2");
    end
    if SelectOrderButton ~= nil then
        if button ~= (SelectedOrderButton + 10) then
            Button:SetVertexColor(1, 1, 1);
        end
    else
        Button:SetVertexColor(1, 1, 1);
    end
end



--Affichage dans la sphere des fin de cooldown,de la vie et de la mana

function ArcanumButton_TextDisplay()
    local ArcanumButtonDisplay = {
        tostring(UnitHealth("player")),
        floor(UnitHealth("player") / UnitHealthMax("player") * 100),
        tostring(UnitMana("player")),
        floor(UnitMana("player") / UnitManaMax("player") * 100),
        CoolDown[3][1],
        CoolDown[2][1],
        CoolDown[4][1],
        CoolDown[5][1],
        IntellCooldown,
        ArmorCooldown,
        BandageCooldown,
    };
    
    if Combat == false then
        Arcanum_UpdateCentralButon();
    end
    
    local ArcanumButtonDisplayPrefix = {"|CFF00FF00", "|CFF00FF00", "|CFF0000FF", "|CFF0000FF", ""};
    local ArcanumButtonDisplaySuffix = {"", "%", "", "%", ""};
    
    if ArcanumConfig.DisplayHealthMana == true then
        local p = UnitHealth("player") / UnitHealthMax("player");
        p = floor(UnitMana("player") / UnitManaMax("player"));
        Arcanum_DisplayMana(ArcanumButtonDisplay[4]);
        Arcanum_DisplayHealth(ArcanumButtonDisplay[2]);
    else
        Arcanum_DisplayMana(0);
        Arcanum_DisplayHealth(0);
    end
    
    if ArcanumButtonDisplayImage == nil and ArcanumConfig.InsideDisplay < 6 and ArcanumButtonDisplay[ArcanumConfig.InsideDisplay] ~= nil then
        ArcanumButtonText:SetText(ArcanumButtonDisplayPrefix[ArcanumConfig.InsideDisplay]..ArcanumButtonDisplay[ArcanumConfig.InsideDisplay]..ArcanumButtonDisplaySuffix[ArcanumConfig.InsideDisplay]);
    else
        ArcanumButtonText:SetText("");
    end
    
    if (CoolDown[2][1] ~= nil) then
		ArcanumManaGemCooldown:SetText(CoolDown[2][1]);
	elseif ManaGemCount ~= 0 then
		ArcanumManaGemCooldown:SetText(ManaGemCount);
	else
		ArcanumManaGemCooldown:SetText("");
	end
    
    if (CoolDown[6][1] ~= nil) then
		ArcanumButton10Text:SetText(CoolDown[6][1]);
    elseif (CoolDown[7][1] ~= nil) then
		ArcanumButton10Text:SetText(CoolDown[7][1]);
	else
		ArcanumButton10Text:SetText("");
	end
end

function ArcanumButton_ImageDisplay()
    ArcanumButtonDisplayImage = Arcanum_DisplayNextImage();
    ArcanumButton_TextDisplay();
    if ArcanumButtonDisplayImage ~= nil then
        ArcanumButtonTexture2:SetTexture(ArcanumButtonDisplayTexture[ArcanumButtonDisplayImage]);
        CoolDown[ArcanumButtonDisplayImage][2] = true;
    else
        ArcanumButtonTexture2:SetTexture(nil);
    end
end

function Arcanum_DisplayNextImage()
    local Next = nil;
    for j = 1, 8 do
        if ArcanumConfig.Display[j] == true then
            if CoolDown[j][1] == nil and CoolDown[j][2] == false then
                Next = j;
                return Next;
            end
        end
    end
    return Next;
end

function Arcanum_DisplayNext(start)
    local Next = nil;
    for i = 1, 2 do
        for j = start + 1, 9 do
            if ArcanumConfig.Display[j] == true then
                if ArcanumButtonDisplay[j] ~= nil then
                    if ArcanumConfig.DisplayWhenReady == true then
                    else
                        Next = j;
                        return Next;
                    end
                else
                    Next = j;
                    return Next;
                end
            end
        end
        start = 0;
    end
    return Next;
end

function Arcanum_DisplayFading()
    --if ArcanumConfig.DisplayWhenReady == true and ArcanumButtonDisplay[ArcanumButtonDisplayValue] ~= nil then
        if DisplayFadingLimit == 0 then
            if AlphaDisplay <= DisplayFadingLimit then
                DisplayFadingWay = - DisplayFadingWay;
                DisplayFadingLimit = 1;
            end
        else
            if AlphaDisplay >= DisplayFadingLimit then
                DisplayFadingWay = - DisplayFadingWay;
                DisplayFadingLimit = 0;
            end
        end
        if GetTime() >= AlphaDisplayVar then
			AlphaDisplayVar = GetTime() + 0.1;
            ArcanumButtonTexture2:SetAlpha(AlphaDisplay);
            AlphaDisplay = AlphaDisplay + (DisplayFadingWay * (0.1/1));
            if AlphaDisplay < 0 then
                AlphaDisplay = 0;
            elseif AlphaDisplay > 1 then
                AlphaDisplay = 1;
            end
		end
    --end
end

function Arcanum_RotateTexture(t, angle)
    local H = 1 / (2 * cos(45));
    local ULx, ULy, LLx, LLy, URx, URy, LRx, LRy;
    ULx, ULy = H * cos(angle - 135) + 0.5, H * sin(angle - 135) + 0.5;
	LLx, LLy = H * cos(angle + 135) + 0.5, H * sin(angle + 135) + 0.5;
	URx, URy = H * cos(angle - 45) + 0.5, H * sin(angle - 45) + 0.5;
	LRx, LRy = H * cos(angle + 45) + 0.5, H * sin(angle + 45) + 0.5;
	t:SetTexCoord(ULx, ULy, LLx, LLy, URx, URy, LRx, LRy);
end

function Arcanum_DisplayMana(p)
    for i = 1, 100 do
        angle = - 1.8 * (i-1);
        Arcanum_RotateTexture(getglobal("ArcanumButtonManaTexture"..i), angle)
        if i <= (100-p) then
            getglobal("ArcanumButtonManaTexture"..i):SetTexture(nil);
        else
            getglobal("ArcanumButtonManaTexture"..i):SetTexture(UIPath.."Circle");
        end
        if p >= 50 then
            getglobal("ArcanumButtonManaTexture"..i):SetVertexColor(ArcanumConfig.ManaColor.r, ArcanumConfig.ManaColor.g, ArcanumConfig.ManaColor.b);
        else
            getglobal("ArcanumButtonManaTexture"..i):SetVertexColor(ArcanumConfig.ManaColor.r+1, ArcanumConfig.ManaColor.g, ArcanumConfig.ManaColor.b);
        end
        getglobal("ArcanumButtonManaTexture"..i):SetBlendMode("BLEND");
    end
end

function Arcanum_DisplayHealth(p)
    for i = 1, 100 do
        angle = 1.8 * i;
        Arcanum_RotateTexture(getglobal("ArcanumButtonHealthTexture"..i), angle)
        if i <= (100-p) then
            getglobal("ArcanumButtonHealthTexture"..i):SetTexture(nil);
        else
            getglobal("ArcanumButtonHealthTexture"..i):SetTexture(UIPath.."Circle");
        end
        getglobal("ArcanumButtonHealthTexture"..i):SetVertexColor(ArcanumConfig.HealthColor.r, ArcanumConfig.HealthColor.g, ArcanumConfig.HealthColor.b);
        getglobal("ArcanumButtonHealthTexture"..i):SetBlendMode("BLEND");
    end
end


------------------------------------------------------------------------------------------------------

-- FONCTION DE GESTION DES COLORPICKER

------------------------------------------------------------------------------------------------------

function Arcanum_HealthColor()
    ArcanumConfig.HealthColor.r,ArcanumConfig.HealthColor.g,ArcanumConfig.HealthColor.b = ColorPickerFrame:GetColorRGB();
    ArcanumHealthColorTexture:SetVertexColor(ArcanumConfig.HealthColor.r,ArcanumConfig.HealthColor.g,ArcanumConfig.HealthColor.b);
end

function Arcanum_ManaColor()
    ArcanumConfig.ManaColor.r,ArcanumConfig.ManaColor.g,ArcanumConfig.ManaColor.b = ColorPickerFrame:GetColorRGB();
    ArcanumManaColorTexture:SetVertexColor(ArcanumConfig.ManaColor.r,ArcanumConfig.ManaColor.g,ArcanumConfig.ManaColor.b);
end

function Arcanum_ButtonColor()
    ArcanumConfig.ButtonColor.r,ArcanumConfig.ButtonColor.g,ArcanumConfig.ButtonColor.b = ColorPickerFrame:GetColorRGB();
    ArcanumButtonColorTexture:SetVertexColor(ArcanumConfig.ButtonColor.r,ArcanumConfig.ButtonColor.g,ArcanumConfig.ButtonColor.b);
    ArcanumMinimapButtonTexture2:SetVertexColor(ArcanumConfig.ButtonColor.r, ArcanumConfig.ButtonColor.g, ArcanumConfig.ButtonColor.b);
end

function Arcanum_CancelHealthColor()
	local color = ColorPickerFrame.previousValues;
    ArcanumConfig.HealthColor = color;
    ArcanumHealthColorTexture:SetVertexColor(ArcanumConfig.HealthColor.r,ArcanumConfig.HealthColor.g,ArcanumConfig.HealthColor.b);
end

function Arcanum_CancelManaColor()
	local color = ColorPickerFrame.previousValues;
    ArcanumConfig.ManaColor = color;
    ArcanumManaColorTexture:SetVertexColor(ArcanumConfig.ManaColor.r,ArcanumConfig.ManaColor.g,ArcanumConfig.ManaColor.b);
end

function Arcanum_CancelButtonColor()
	local color = ColorPickerFrame.previousValues;
    ArcanumConfig.ButtonColor = color;
    ArcanumButtonColorTexture:SetVertexColor(ArcanumConfig.ButtonColor.r,ArcanumConfig.ButtonColor.g,ArcanumConfig.ButtonColor.b);
end

function Arcanum_HealthColorClick()
    local color = {};
    color.r = ArcanumConfig.HealthColor.r;
    color.g = ArcanumConfig.HealthColor.g;
    color.b = ArcanumConfig.HealthColor.b;
    ColorPickerFrame.previousValues = color;
    ColorPickerFrame.cancelFunc = Arcanum_CancelHealthColor;
    ColorPickerFrame.func = Arcanum_HealthColor;
    ColorPickerFrame:SetColorRGB(color.r, color.g, color.b);
    ColorPickerFrame:Show();
end

function Arcanum_ManaColorClick()
    local color = {};
    color.r = ArcanumConfig.ManaColor.r;
    color.g = ArcanumConfig.ManaColor.g;
    color.b = ArcanumConfig.ManaColor.b;
    ColorPickerFrame.previousValues = color;
    ColorPickerFrame.cancelFunc = Arcanum_CancelManaColor;
    ColorPickerFrame.func = Arcanum_ManaColor;
    ColorPickerFrame:SetColorRGB(color.r, color.g, color.b);
    ColorPickerFrame:Show();
end

function Arcanum_ButtonColorClick()
    local color = {};
    color.r = ArcanumConfig.ButtonColor.r;
    color.g = ArcanumConfig.ButtonColor.g;
    color.b = ArcanumConfig.ButtonColor.b;
    ColorPickerFrame.previousValues = color;
    ColorPickerFrame.cancelFunc = Arcanum_CancelButtonColor;
    ColorPickerFrame.func = Arcanum_ButtonColor;
    ColorPickerFrame:SetColorRGB(color.r, color.g, color.b);
    ColorPickerFrame:Show();
end

