Aperture = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceDB-2.0");

Aperture:RegisterDB("ApertureDB");

Aperture:RegisterDefaults("profile", {
	top = 0,
	bottom = 0,
	left = 0,
	right = 0
});

function Aperture:OnEnable(first)
	WorldFrame:SetPoint("TOPLEFT", Aperture.db.profile.left, -Aperture.db.profile.top);
	WorldFrame:SetPoint("TOPRIGHT", -Aperture.db.profile.right, -Aperture.db.profile.top);
	WorldFrame:SetPoint("BOTTOMLEFT", Aperture.db.profile.left, Aperture.db.profile.bottom);
	WorldFrame:SetPoint("BOTTOMRIGHT", -Aperture.db.profile.right, Aperture.db.profile.bottom);
	
	if first then
		ViewportOverlay = WorldFrame:CreateTexture(nil, "BACKGROUND");
		ViewportOverlay:SetTexture(0, 0, 0, 1);
		ViewportOverlay:SetPoint("TOPLEFT", UIParent, "TOPLEFT", -1, 1);
		ViewportOverlay:SetPoint("BOTTOMRIGHT", UIParent, "BOTTOMRIGHT", 1, -1);
	end
end;

function Aperture:OnDisable()
	WorldFrame:SetPoint("TOPLEFT", 0, 0);
	WorldFrame:SetPoint("TOPRIGHT", 0, 0);
	WorldFrame:SetPoint("BOTTOMLEFT", 0, 0);
	WorldFrame:SetPoint("BOTTOMRIGHT", 0, 0);
end;

function Aperture.ValidateNumber(v)
	return string.find(v, "^%d+$");
end;

function Aperture.SetBorder(border, value)
	Aperture.db.profile[border] = tonumber(value);
	Aperture:OnEnable();
end;

local options = {
	type = "group",
	args = {
		top = {
			name = "Top border",
			type = "text",
			desc = "Set the top border.",
			usage = "<number>",
			get = function()
				return Aperture.db.profile.top;
			end,
			set = function(v)
				Aperture.SetBorder("top", v);
			end,
			validate = Aperture.ValidateNumber
		},
		right = {
			name = "Right border",
			type = "text",
			desc = "Set the right border.",
			usage = "<number>",
			get = function()
				return Aperture.db.profile.right;
			end,
			set = function(v)
				Aperture.SetBorder("right", v);
			end,
			validate = ValidateNumber
		},
		bottom = {
			name = "Bottom border",
			type = "text",
			desc = "Set the bottom border.",
			usage = "<number>",
			get = function()
				return Aperture.db.profile.bottom;
			end,
			set = function(v)
				Aperture.SetBorder("bottom", v);
			end,
			validate = ValidateNumber
		},
		left = {
			name = "Left border",
			type = "text",
			desc = "Set the left border.",
			usage = "<number>",
			get = function()
				return Aperture.db.profile.left;
			end,
			set = function(v)
				Aperture.SetBorder("left", v);
			end,
			validate = ValidateNumber
		}
	}
}

Aperture:RegisterChatCommand({"/aperture"}, options)