--<< ====================================================================== >>--
-- Class Setup                                                                --
--<< ====================================================================== >>--
Antagonist = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceDB-2.0", "AceConsole-2.0", "AceDebug-2.0", "CandyBar-2.0")

-- embedded libs
local L = AceLibrary("AceLocale-2.2"):new("Antagonist")
local LSM = LibStub("LibSharedMedia-3.0")
local bitband = bit.band
local playerGUID = UnitGUID("player")

Antagonist.spells = {}

function Antagonist:OnInitialize()
	local defaults = {
		combatonly = false,
		pvponly = false,
		fadeonkill = true,
		fadeondeath = true,
		cdlimit = 60, 
		positions = {},
		filter = {casts = {}, buffs = {}, cooldowns = {}},

		-- title
		titletext = {[1] = "", [2] = "", [3] = ""},
		titlecolors = {[1] = {0.71,0.1,0}, [2] = {0,0.6,0}, [3] = {0.46,0.53,1}}, 
		titlesize = 18,
		-- group
                targetonly = {casts = true, buffs = true, cooldowns = true},
		enabled = {casts = true, buffs = true, cooldowns = true},
		showunder = {casts = 1, buffs = 2, cooldowns = 3},
		pattern = {casts = "$n : $s", buffs = "$n : $s", cooldowns = "$n : $s (CD)"},
                soundalert = {casts = true, buffs = false, cooldowns = false},
		
		-- bar
		barscale = 1,
		barcolor = "group",
		barheight = 15,
		barwidth = 200,
		textsize = 10,
		texture = "Blizzard",
		reverse = {casts = false, buffs = false, cooldowns = false},
		growup = {[1] = false, [2] = false, [3] = false},
	}

	self:RegisterDB("AntagonistDB")
	self:RegisterDefaults('profile', defaults)
	self:RegisterOpts()

	-- init formating tables
	self.colors = {
		["casts"] = "red",
		["cooldowns"] = "blue",
		["buffs"] = "green",
	}


	-- create anchors
	self.anchors = {}
	self.titles = {}
	local yoff = 0
	for i=1, 3 do
		local titlecolors = self.db.profile.titlecolors[i]
		yoff = yoff - 50
		self.anchors[i] = self:CreateAnchor(i, titlecolors[1], titlecolors[2] , titlecolors[3], yoff)
		self.titles[i] = self:CreateTitle(self.db.profile.titletext[i], self.anchors[i], titlecolors[1], titlecolors[2] , titlecolors[3])

		self:RegisterCandyBarGroup("Antagonist-"..i)
		self:SetCandyBarGroupPoint("Antagonist-"..i, "TOP", self.anchors[i], "BOTTOM", 0, 0)
		self:SetCandyBarGroupGrowth("Antagonist-"..i, self.db.profile.growup[i]) 
	end
end

function Antagonist:OnEnable()
	self.bars = {}
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
	LSM.RegisterCallback(self, "LibSharedMedia_Registered", "UpdateMedia")
	LSM.RegisterCallback(self, "LibSharedMedia_SetGlobal", "UpdateMedia")
end

function Antagonist:OnDisable()
	self:UnregisterAllEvents("Antagonist")
	self:KillAllBars()
	self.bars = nil	
end

function Antagonist:RunTest()
	if not self:IsActive() then self:Print("Activate the addon before attempting to run test bars.") return end
	local time = 5
	for k in pairs(self.db.profile.enabled) do
		local id = "Antagonist-Test"..k
		local icon = "Interface\\Icons\\Spell_Nature_Drowsy"
		local barcolor = self.colors[k]
		
		local anchor = self.db.profile.showunder[k]
		if self.db.profile.titletext[anchor] then self.titles[anchor]:Show() end
		
		self:RegisterCandyBar(id, time, L["TestBarText"], icon, barcolor, barcolor, barcolor, "red")
		self:SetCandyBarTexture(id, LSM:Fetch("statusbar", self.db.profile.texture))
		self:SetCandyBarReversed(id, self.db.profile.reverse[k])
		self:SetCandyBarHeight(id, self.db.profile.barheight)
		self:SetCandyBarWidth(id, self.db.profile.barwidth)
		self:SetCandyBarFontSize(id, self.db.profile.textsize)
		self:SetCandyBarScale(id, self.db.profile.barscale)
		self:SetCandyBarCompletion(id, function(anchor) Antagonist:UpdateTitle(anchor) end, anchor)
		self:RegisterCandyBarWithGroup(id, "Antagonist-"..anchor)
		-- start this bitch!
		self:StartCandyBar(id, true)
		time = time + 5
	end
end

function Antagonist:UpdateMedia()
	for _,id in pairs(self.bars) do
		self:SetCandyBarTexture(id, LSM:Fetch("statusbar", self.db.profile.texture))
	end
end

function Antagonist:COMBAT_LOG_EVENT_UNFILTERED(timestamp, eventType, srcGUID, srcName, srcFlags, dstGUID, dstName, dstFlags, spellID, spellName, spellSchool, detail1, detail2, detail3 )
	if self.db.profile.combatonly and not UnitAffectingCombat("player") then return end 
	if self.db.profile.pvponly and not UnitIsPVP("player") then return end
	if self.spells.blacklist and self.spells.blacklist[spellID] then return end

	local isSourceEnemy = (bitband(srcFlags, COMBATLOG_OBJECT_REACTION_HOSTILE) == COMBATLOG_OBJECT_REACTION_HOSTILE)
	local isDestEnemy = (bitband(dstFlags, COMBATLOG_OBJECT_REACTION_HOSTILE) == COMBATLOG_OBJECT_REACTION_HOSTILE)

	if ((eventType == "SPELL_CAST_START") and isSourceEnemy and self.db.profile.enabled.casts) then
		local spell = GetSpellInfo(spellID)
		if self.spells.casts[spell] and not self.db.profile.filter['casts'][spell] then 
			if self.db.profile.targetonly.casts then
				if (srcGUID == UnitGUID("target")) then self:StartBar(srcName, srcGUID, spellID, "casts") end 
			else 
				self:StartBar(srcName, srcGUID, spellID, "casts")
			end
		end
	return end

	if ((eventType == "SPELL_INTERRUPT") and isDestEnemy) then
		self:KillBar(dstName, dstGUID, detail1, "casts")
		self:UpdateTitle(self.db.profile.showunder.casts)
	return end

	if ((eventType == "SPELL_CAST_SUCCESS") and isSourceEnemy and self.db.profile.enabled.cooldowns) then
		local spell = GetSpellInfo(spellID)
		if self.spells.cooldowns[spell] and not self.db.profile.filter['cooldowns'][spell]then
			if self.db.profile.targetonly.cooldowns then
				if (srcGUID == UnitGUID("target")) then self:StartBar(srcName, srcGUID, spellID, "cooldowns") end
			else
				self:StartBar(srcName, srcGUID, spellID, "cooldowns")
			end
		end
	return end

	if (eventType == "SPELL_AURA_APPLIED" and detail1 == "BUFF" and isDestEnemy and self.db.profile.enabled.cooldowns) then
		local spell = GetSpellInfo(spellID)
		if self.spells.buffs[spell] and not self.db.profile.filter['buffs'][spell] then
			if self.db.profile.targetonly.buffs then
				if (dstGUID == UnitGUID("target")) then self:StartBar(dstName, dstGUID, spellID, "buffs") end
			else
				self:StartBar(dstName, dstGUID, spellID, "buffs")
			end
		end
	return end
		
	if ((eventType == "SPELL_AURA_REMOVED") and isDestEnemy) then
		self:KillBar(dstName, dstGUID, spellID, "buffs")
		self:UpdateTitle(self.db.profile.showunder.buffs)
	return end

	if (eventType == "UNIT_DIED") then 
		if ((dstGUID == playerGUID) and self.db.profile.fadeondeath) then self:KillAllBars() return end
		if self.db.profile.fadeonkill then self:KillBars(dstGUID) return end
	return end
end

--<< ====================================================================== >>--
-- Timer Processing                                                           --
--<< ====================================================================== >>--
function Antagonist:StartBar(unitName, unitGUID, spellID, group, left)
	local id = "Antagonist-"..unitGUID.."-"..spellID.."-"..group
	local spell,_,icon = GetSpellInfo(spellID)
	local time = self.spells[group][spell][1] 
	if group == "cooldowns" and time > self.db.profile.cdlimit then return end
	if string.find(unitName,"-") then unitName = string.gsub(unitName,"-.*","") end

	local barcolor = "white"
	if self.db.profile.barcolor == "class"  then
		if self.spells[group][spell] then
			if self.spells[group][spell][2] ~= "general" then barcolor = self.spells[group][spell][2] end
		end
	elseif self.db.profile.barcolor == "school" then
		if self.spells[group][spell] then 
			barcolor = self:GetSchoolColor(self.spells[group][spell][3])
		end
	elseif self.db.profile.barcolor == "group" then
		barcolor = self.colors[group]
	end
	
	local text = self.db.profile.pattern[group]
	text = gsub(text, "$n", unitName)
	text = gsub(text, "$s", spell)
	
	local anchor = self.db.profile.showunder[group]
	if self.db.profile.titletext[anchor] then self.titles[anchor]:Show() end
	
	self:RegisterCandyBar(id, time, text, icon, barcolor, barcolor, barcolor, "red")
	self:SetCandyBarTexture(id, LSM:Fetch("statusbar", self.db.profile.texture))
	self:SetCandyBarReversed(id, self.db.profile.reverse[group])
	self:SetCandyBarHeight(id, self.db.profile.barheight)
	self:SetCandyBarWidth(id, self.db.profile.barwidth)
	self:SetCandyBarFontSize(id, self.db.profile.textsize)
	self:SetCandyBarScale(id, self.db.profile.barscale)
	self:SetCandyBarOnClick(id, function(id,button,unitName,unitGUID,spellID,group) self:OnClick(id,button,unitName,unitGUID,spellID,group) end, unitName,unitGUID,spellID,group)
	self:SetCandyBarCompletion(id, function(unitName,unitGUID,spellID,group) self:BarEnd(unitName,unitGUID,spellID,group) end, unitName,unitGUID,spellID,group)
	self:RegisterCandyBarWithGroup(id, "Antagonist-"..anchor)
	self:StartCandyBar(id, true)
	if left then self:SetCandyBarTimeLeft(id, left) end 
	self.bars[id] = id

        if self.db.profile.soundalert[group] then PlaySound("RaidWarning") end
end

function Antagonist:BarEnd(unitName,unitGUID,spellID ,group) 
	local spell = GetSpellInfo(spellID)
	local anchor = self.db.profile.showunder[group]
	
	self.bars["Antagonist-"..unitGUID.."-"..spellID.."-"..group] = nil
	self:UpdateTitle(anchor)
	--self:Debug("Bar finish:", unit.."-"..spell.."-"..group)
end
-- Fired when a bar is clicked
function Antagonist:OnClick(id, button, unitName, unitGUID, spellID, group)
	local spell = GetSpellInfo(spellID)

	if IsShiftKeyDown() and button == "RightButton" then
		self:KillGroup(group)

	elseif IsControlKeyDown() and button == "LeftButton" then
		self.db.profile.filter[group][spell] = true
		self:KillBar(unitName, unitGUID, spellID, group)
		self:UpdateTitle(self.db.profile.showunder[group])
		self:Print(L["Now filtering spell:"], spell)

	elseif button == "RightButton" then
		self:KillBar(nil, nil, nil, id)
		self:UpdateTitles()
	end
end

function Antagonist:GetSchoolColor(school)
	if not school then return end

	if school == "fire" then return "red"
	elseif school == "frost" then return "blue"
	elseif school == "nature" then return "green"
	elseif school == "shadow" then return "warlock"
	elseif school == "arcane" then return "white"
	elseif school == "holy" then return "yellow"
	elseif school == "physical" then return "druid"
	elseif school == "magic" then return "cyan"
	else return "white" end
end

function Antagonist:KillBar(unitName, unitGUID, spellID, group, id)
	if not id and unitGUID and spellID then id = "Antagonist-"..unitGUID.."-"..spellID.."-"..group end
	if id then
		self:SetCandyBarFade(id, 1)
		self:SetCandyBarColor(id, "red")
		self:StopCandyBar(id)
		self.bars[id] = nil
	end
end

function Antagonist:KillBars(unitGUID)
	for i in pairs(self.bars) do
		if string.find(i, unitGUID) then
			self:KillBar(nil, nil, nil, nil,i)
		end
	end
	self:UpdateTitles()
end

function Antagonist:KillAllBars()
	for i in pairs(self.bars) do
		self:KillBar(nil, nil, nil, nil,i)
	end
	self:HideTitles()
end

function Antagonist:KillGroup(group)
	for i in pairs(self.bars) do
		if string.find(i, group) then
			self:KillBar(nil, nil, nil, nil,i)
		end
	end
	--self:Debug("Group killed.", group)
	self:UpdateTitle(self.db.profile.showunder[group])
end

function Antagonist:ToggleAnchors()
	if self.anchors[1]:IsVisible() then
		for k, v in pairs(self.anchors) do
			v:Hide()
		end
	else
		for k, v in pairs(self.anchors) do
			v:Show()
		end
	end
end

function Antagonist:CreateAnchor(id, cRed, cGreen, cBlue, yoff)
	local f = CreateFrame("Button", nil, UIParent)
	f:SetWidth(100)
	f:SetHeight(25)
	
	f.owner = self
	
	if not self.db.profile.positions[id] then self.db.profile.positions[id] = {} end

	if self.db.profile.positions[id].point and self.db.profile.positions[id].relPoint and self.db.profile.positions[id].x and self.db.profile.positions[id].y then
		f:ClearAllPoints()
		f:SetPoint(self.db.profile.positions[id].point, UIParent, self.db.profile.positions[id].relPoint, self.db.profile.positions[id].x, self.db.profile.positions[id].y)
	else
		f:SetPoint("TOP", UIErrorsFrame, "BOTTOM", 0, yoff)
	end
	
	f:SetScript("OnDragStart", function() this:StartMoving() end )
	f:SetScript("OnDragStop",
		function()
			this:StopMovingOrSizing()
			local point, _, relPoint, x, y = this:GetPoint()
			this.owner.db.profile.positions[id].point = point
			this.owner.db.profile.positions[id].relPoint = relPoint
			this.owner.db.profile.positions[id].x = math.floor(x)
			this.owner.db.profile.positions[id].y = math.floor(y)
        end)

	f:SetBackdrop({bgFile = "Interface/Tooltips/UI-Tooltip-Background",
                                            edgeFile = "Interface/Tooltips/UI-Tooltip-Border",
                                            tile = false, tileSize = 16, edgeSize = 16,
                                            insets = { left = 5, right =5, top = 5, bottom = 5 }})
	f:SetBackdropColor(cRed,cGreen,cBlue,.6)
	f:SetMovable(true)
	f:RegisterForDrag("LeftButton")

	f.Text = f:CreateFontString(nil, "OVERLAY")
	f.Text:SetFontObject(GameFontNormalSmall)
	f.Text:ClearAllPoints()
	f.Text:SetTextColor(1, 1, 1, 1)
	f.Text:SetWidth(100)
	f.Text:SetHeight(25)
	f.Text:SetPoint("TOPLEFT", f, "TOPLEFT")
	f.Text:SetJustifyH("CENTER")
	f.Text:SetJustifyV("MIDDLE")
	f.Text:SetText("Antagonist : "..id)
	
	f:Hide()

	return f
end

function Antagonist:UpdateTitle(anchor)
	if not anchor then return end
	for i in pairs(self.bars) do
		if self:IsCandyBarRegisteredWithGroup(i, "Antagonist-"..anchor) then 
			return 
		end
	end
	self.titles[anchor]:Hide()
end

function Antagonist:UpdateTitles()
	self:UpdateTitle(1)
	self:UpdateTitle(2)
	self:UpdateTitle(3)
end

function Antagonist:HideTitles()
	self.titles[1]:Hide()
	self.titles[2]:Hide()
	self.titles[3]:Hide()
end

function Antagonist:CreateTitle(text, pframe, cRed,cGreen,cBlue)
	local f = CreateFrame("Button",nil,UIParent)
	f:EnableMouse(false)
	f:ClearAllPoints()
	f:SetWidth(200)
	f:SetHeight(25)
	f:SetPoint("TOP", pframe, "TOP", 0,0)

	f.Text = f:CreateFontString(nil, "OVERLAY")
	f.Text:SetFont(L["Fonts\\skurri.ttf"], self.db.profile.titlesize, "OUTLINE")
	f.Text:ClearAllPoints()
	f.Text:SetTextColor(cRed,cGreen,cBlue, 1)
	f.Text:SetWidth(200)
	f.Text:SetHeight(25)
	f.Text:SetPoint("CENTER", f, "CENTER")
	f.Text:SetJustifyH("CENTER")
	f.Text:SetJustifyV("MIDDLE")
	if text ~= "nil" then	f.Text:SetText(text) end
	
	f:Hide()

	return f
end
