local aUF = CreateFrame("Frame", "aUF", UIParent)
local aUF_DefaultFrameNames = {"PlayerFrame", "PetFrame", "PetTargetFrame","TargetFrame", "TargetFrame", "TargetTargetFrame", "FocusFrame", "FocusTargetFrame"}
local aUF_FrameNames = {"player", "pet", "pettarget", "target", "targettarget", "focus", "focustarget"}
local aUF_Frames = {}
local aUF_FrameTemporaryVariables = {
	["locked"] = true,
	["moveframe"] = nil,
}
local aUF_FrameLayout1920x1080WideVariables = {
	["player"] = {
		["cnameTop"] = true,
		["portrait"] = true,
		["portraitRight"] = false,
		["posAnchor"] = "BOTTOM",
		["posX"] = -466,
		["posY"] = 232,
		["resource"] = true,
		["scale"] = 1,
	},
	["pet"] = {
		["cnameTop"] = true,
		["portrait"] = true,
		["portraitRight"] = false,
		["posAnchor"] = "CENTER",
		["posX"] = -532,
		["posY"] = -219,
		["resource"] = true,
		["scale"] = 1,
	},
	["pettarget"] = {
		["cnameTop"] = false,
		["portrait"] = false,
		["portraitRight"] = true,
		["posAnchor"] = "CENTER",
		["posX"] = -467,
		["posY"] = -283,
		["resource"] = false,
		["scale"] = 1,
	},
	["target"] = {
		["cnameTop"] = true,
		["portrait"] = true,
		["portraitRight"] = true,
		["posAnchor"] = "BOTTOM",
		["posX"] = 201,
		["posY"] = 232,
		["resource"] = true,
		["scale"] = 1,
	},
	["targettarget"] = {
		["cnameTop"] = false,
		["portrait"] = false,
		["portraitRight"] = true,
		["posAnchor"] = "BOTTOM",
		["posX"] = -100,
		["posY"] = 216,
		["resource"] = false,
		["scale"] = 1,
	},
	["focus"] = {
		["cnameTop"] = true,
		["portrait"] = true,
		["portraitRight"] = true,
		["posAnchor"] = "CENTER",
		["posX"] = 267,
		["posY"] = -219,
		["resource"] = true,
		["scale"] = 1,
	},
	["focustarget"] = {
		["cnameTop"] = false,
		["portrait"] = false,
		["portraitRight"] = true,
		["posAnchor"] = "CENTER",
		["posX"] = 267,
		["posY"] = -283,
		["resource"] = false,
		["scale"] = 1,
	},
}
local aUF_FrameDefaultVariables = {
	["player"] = {
		["cnameTop"] = true,
		["portrait"] = true,
		["portraitRight"] = false,
		["posAnchor"] = nil,
		["posX"] = nil,
		["posY"] = nil,
		["resource"] = true,
		["scale"] = 1,
	},
	["pet"] = {
		["cnameTop"] = true,
		["portrait"] = true,
		["portraitRight"] = false,
		["posAnchor"] = nil,
		["posX"] = nil,
		["posY"] = nil,
		["resource"] = true,
		["scale"] = 1,
	},
	["pettarget"] = {
		["cnameTop"] = false,
		["portrait"] = false,
		["portraitRight"] = true,
		["posAnchor"] = nil,
		["posX"] = nil,
		["posY"] = nil,
		["resource"] = false,
		["scale"] = 1,
	},
	["target"] = {
		["cnameTop"] = true,
		["portrait"] = true,
		["portraitRight"] = true,
		["posAnchor"] = nil,
		["posX"] = nil,
		["posY"] = nil,
		["resource"] = true,
		["scale"] = 1,
	},
	["targettarget"] = {
		["cnameTop"] = false,
		["portrait"] = false,
		["portraitRight"] = true,
		["posAnchor"] = nil,
		["posX"] = nil,
		["posY"] = nil,
		["resource"] = false,
		["scale"] = 1,
	},
	["focus"] = {
		["cnameTop"] = true,
		["portrait"] = true,
		["portraitRight"] = true,
		["posAnchor"] = nil,
		["posX"] = nil,
		["posY"] = nil,
		["resource"] = true,
		["scale"] = 1,
	},
	["focustarget"] = {
		["cnameTop"] = false,
		["portrait"] = false,
		["portraitRight"] = true,
		["posAnchor"] = nil,
		["posX"] = nil,
		["posY"] = nil,
		["resource"] = false,
		["scale"] = 1,
	},
}
aUF_FrameVariables = {}
local events = {}
local lastUpdate = 0

SLASH_aUF1 = "/aUF"

local textureLoc = "Interface\\Addons\\AnonymousLib\\Textures\\"
local textureBg = "minimalist"
local textureBorder = "white16x16"

local fontLoc = "Interface\\Addons\\AnonymousLib\\Fonts\\"
local fontFile = "ClearFontBold.ttf"

local resourceColors = {{0, 0, 1, 1}, {0.8, 0, 0, 1}, {0.8, 0.4, 0, 1}, {1, 1, 0, 1}}

local function SetUIScripts(frame)
	local scriptframe = _G["aUF_" ..frame]
	scriptframe:SetScript("OnEnter", function (self)
		GameTooltip_SetDefaultAnchor(GameTooltip, UIParent)
		GameTooltip:SetUnit(frame)
		
		local gtt = {}
		for i = 1, GameTooltip:NumLines() do
			local mytext = _G["GameTooltipTextLeft"..i]
			local text = mytext:GetText()
			table.insert(gtt, text)
		end
		
		GameTooltip:ClearLines()
		
		for i = 1, #gtt do
			local r, g, b = 1, 1, 1
			if i == 1 then
				local reaction = UnitReaction("player", frame);
				r, g, b = FACTION_BAR_COLORS[reaction].r, FACTION_BAR_COLORS[reaction].g, FACTION_BAR_COLORS[reaction].b;
				
				if UnitIsPlayer(frame) then
					if UnitIsFriend("player", frame) and (UnitIsPVP(frame) or UnitIsPVPFreeForAll(frame)) then
						r, g, b = FACTION_BAR_COLORS[5].r, FACTION_BAR_COLORS[5].g, FACTION_BAR_COLORS[5].b;
					elseif UnitIsFriend("player", frame) and (not UnitIsPVP(frame) or not UnitIsPVPFreeForAll(frame)) then
						r, g, b = 1, 1, 1;
					elseif UnitIsEnemy("player", frame) and (UnitIsPVP(frame) or UnitIsPVPFreeForAll(frame)) and (UnitIsPVP("player") or UnitIsPVPFreeForAll("player")) then
						r, g, b = FACTION_BAR_COLORS[3].r, FACTION_BAR_COLORS[3].g, FACTION_BAR_COLORS[3].b;
					else
						r, g, b = FACTION_BAR_COLORS[4].r, FACTION_BAR_COLORS[4].g, FACTION_BAR_COLORS[4].b;
					end
				end
			end
			GameTooltip:AddLine(gtt[i], r, g, b)
		end
		
		GameTooltip:Show()
	end)
	scriptframe:SetScript("OnLeave", function (self)
		GameTooltip:Hide()
	end)
	scriptframe:SetScript("OnMouseDown", function(self, button)
		if button == "LeftButton" and not aUF_FrameTemporaryVariables["locked"] and not aUF_FrameTemporaryVariables["moveframe"] then
			scriptframe:StartMoving()
			aUF_FrameTemporaryVariables["moveframe"] = nil
		end
	end)
	scriptframe:SetScript("OnMouseUp", function(self, button)
		if button == "LeftButton" and not aUF_FrameTemporaryVariables["locked"] and not aUF_FrameTemporaryVariables["moveframe"] then
			scriptframe:StopMovingOrSizing()
			aUF_FrameTemporaryVariables["moveframe"] = nil
		elseif button == "RightButton" and aUF_FrameTemporaryVariables["locked"] then
			local mframe = frame:sub(1,1):upper()..frame:sub(2).. "Frame"
			ToggleDropDownMenu(1, nil, _G[mframe.."DropDown"], scriptframe, 62.5, 0)
		end
	end)
	scriptframe:SetScript("OnHide", function(self)
		if aUF_FrameTemporaryVariables["locked"] or not aUF_FrameTemporaryVariables["moveframe"] then
			scriptframe:StopMovingOrSizing()
			aUF_FrameTemporaryVariables["moveframe"] = nil
		end
	end)
	scriptframe:SetAttribute("type1", "target")
	scriptframe:SetAttribute("alt-type1", "focus")
	scriptframe:SetAttribute("unit", frame)
end

local function aUF_DisableFrame(frame)
	if _G[frame] ~= nil then
		_G[frame]:SetScript("OnEvent", nil)
		_G[frame]:Hide()
	end
end

local function aUF_CreateFrame(frame)
	local fwidth, fheight = 1, 1
	aUF_Frames[frame] = CreateFrame("Button", "aUF_" ..frame, UIParent, "SecureActionButtonTemplate")
	aUF_Frames[frame]:SetMovable(true)
	aUF_Frames[frame]:EnableMouse(true)
	aUF_Frames[frame]:SetWidth(fwidth)
	aUF_Frames[frame]:SetHeight(fheight)
	aUF_Frames[frame]:SetPoint("TOPLEFT", UIParent, "CENTER")
	aUF_Frames[frame]:Show()
	
	aUF_Frames[frame.. "HealthFrame"] = CreateFrame("Frame", "aUF_" ..frame.. "HealthFrame", aUF_Frames[frame])
	aUF_Frames[frame.. "HealthFrame"]:SetWidth(200)
	aUF_Frames[frame.. "HealthFrame"]:SetHeight(32)
	aUF_Frames[frame.. "HealthFrame"]:SetFrameLevel(1)
	if not aUF_FrameVariables[frame]["portraitRight"] then
		aUF_Frames[frame.. "HealthFrame"]:SetPoint("TOPRIGHT", aUF_Frames[frame], "TOPRIGHT", 0, 0)
	else
		aUF_Frames[frame.. "HealthFrame"]:SetPoint("TOPLEFT", aUF_Frames[frame], "TOPLEFT", 0, 0)
	end
	aUF_Frames[frame.. "HealthFrame"]:SetBackdrop({
		bgFile = textureLoc..textureBg,
		edgeFile = textureLoc..textureBorder,
		edgeSize = 1
	})
	aUF_Frames[frame.. "HealthFrame"]:SetBackdropColor(0.4, 0.4, 0.4, 1)
	aUF_Frames[frame.. "HealthFrame"]:SetBackdropBorderColor(0, 0, 0, 1)
	aUF_Frames[frame.. "HealthFrame"]:Show()
	
	aUF_Frames[frame.. "HealthBar"] = CreateFrame("Frame", "aUF_" ..frame.. "HealthBar", aUF_Frames[frame])
	aUF_Frames[frame.. "HealthBar"]:SetWidth((UnitHealth(frame) / UnitHealthMax(frame)) * 200)
	aUF_Frames[frame.. "HealthBar"]:SetHeight(32)
	aUF_Frames[frame.. "HealthBar"]:SetFrameLevel(2)
	if not aUF_FrameVariables[frame]["portraitRight"] then
		aUF_Frames[frame.. "HealthBar"]:SetPoint("TOPLEFT", aUF_Frames[frame.. "HealthFrame"], "TOPLEFT", 0, 0)
	else
		aUF_Frames[frame.. "HealthBar"]:SetPoint("TOPRIGHT", aUF_Frames[frame.. "HealthFrame"], "TOPRIGHT", 0, 0)
	end
	aUF_Frames[frame.. "HealthBar"]:SetBackdrop({
		bgFile = textureLoc..textureBg,
		edgeFile = textureLoc..textureBorder,
		edgeSize = 1
	})
	aUF_Frames[frame.. "HealthBar"]:SetBackdropColor(0, 1, 0, 1)
	aUF_Frames[frame.. "HealthBar"]:SetBackdropBorderColor(0, 0, 0, 1)
	aUF_Frames[frame.. "HealthBar"]:Show()
	
	aUF_Frames[frame.. "HealthText"] = aUF_Frames[frame.. "HealthBar"]:CreateFontString("aUF_" ..frame.. "HealthText", "OVERLAY")
	aUF_Frames[frame.. "HealthText"]:SetFont(fontLoc..fontFile, 12, "")
	aUF_Frames[frame.. "HealthText"]:SetShadowOffset(1, -1)
	aUF_Frames[frame.. "HealthText"]:SetShadowColor(0, 0, 0, 0.8)
	aUF_Frames[frame.. "HealthText"]:SetPoint("CENTER", aUF_Frames[frame.. "HealthFrame"], "CENTER", 0, 1)
	aUF_Frames[frame.. "HealthText"]:SetText("0 / 0 (0%)")
	aUF_Frames[frame.. "HealthText"]:Show()
	fwidth = fwidth + 200
	fheight = fheight + 32
	
	aUF_Frames[frame.. "ResourceFrame"] = CreateFrame("Frame", "aUF_" ..frame.. "ResourceFrame", aUF_Frames[frame.. "HealthFrame"])
	aUF_Frames[frame.. "ResourceFrame"]:SetWidth(200)
	aUF_Frames[frame.. "ResourceFrame"]:SetHeight(32)
	aUF_Frames[frame.. "ResourceFrame"]:SetFrameLevel(1)
	if not aUF_FrameVariables[frame]["portraitRight"] then
		aUF_Frames[frame.. "ResourceFrame"]:SetPoint("TOPLEFT", aUF_Frames[frame.. "HealthFrame"], "BOTTOMLEFT", 0, 0)
	else
		aUF_Frames[frame.. "ResourceFrame"]:SetPoint("TOPLEFT", aUF_Frames[frame.. "HealthFrame"], "BOTTOMLEFT", 0, 0)
	end
	aUF_Frames[frame.. "ResourceFrame"]:SetBackdrop({
		bgFile = textureLoc..textureBg,
		edgeFile = textureLoc..textureBorder,
		edgeSize = 1
	})
	aUF_Frames[frame.. "ResourceFrame"]:SetBackdropColor(0.4, 0.4, 0.4, 1)
	aUF_Frames[frame.. "ResourceFrame"]:SetBackdropBorderColor(0, 0, 0, 1)
	aUF_Frames[frame.. "ResourceFrame"]:Show()
	
	aUF_Frames[frame.. "ResourceBar"] = CreateFrame("Frame", "aUF_" ..frame.. "ResourceBar", aUF_Frames[frame.. "HealthFrame"])
	aUF_Frames[frame.. "ResourceBar"]:SetWidth((UnitMana(frame) / UnitManaMax(frame)) * 200)
	aUF_Frames[frame.. "ResourceBar"]:SetHeight(32)
	aUF_Frames[frame.. "ResourceBar"]:SetFrameLevel(2)
	if not aUF_FrameVariables[frame]["portraitRight"] then
		aUF_Frames[frame.. "ResourceBar"]:SetPoint("TOPLEFT", aUF_Frames[frame.. "ResourceFrame"], "TOPLEFT", 0, 0)
	else
		aUF_Frames[frame.. "ResourceBar"]:SetPoint("TOPRIGHT", aUF_Frames[frame.. "ResourceFrame"], "TOPRIGHT", 0, 0)
	end
	aUF_Frames[frame.. "ResourceBar"]:SetBackdrop({
		bgFile = textureLoc..textureBg,
		edgeFile = textureLoc..textureBorder,
		edgeSize = 1
	})
	aUF_Frames[frame.. "ResourceBar"]:SetBackdropColor(0.4, 0.4, 0.4, 1)
	aUF_Frames[frame.. "ResourceBar"]:SetBackdropBorderColor(0, 0, 0, 1)
	aUF_Frames[frame.. "ResourceBar"]:Show()
	
	aUF_Frames[frame.. "ResourceText"] = aUF_Frames[frame.. "ResourceBar"]:CreateFontString("aUF_" ..frame.. "ResourceText", "OVERLAY")
	aUF_Frames[frame.. "ResourceText"]:SetFont(fontLoc..fontFile, 12, "")
	aUF_Frames[frame.. "ResourceText"]:SetShadowOffset(1, -1)
	aUF_Frames[frame.. "ResourceText"]:SetShadowColor(0, 0, 0, 0.8)
	aUF_Frames[frame.. "ResourceText"]:SetPoint("CENTER", aUF_Frames[frame.. "ResourceFrame"], "CENTER", 0, 1)
	aUF_Frames[frame.. "ResourceText"]:SetText("0 / 0 (0%)")
	aUF_Frames[frame.. "ResourceText"]:Show()
	if aUF_FrameVariables[frame]["resource"] then
		aUF_Frames[frame.. "ResourceFrame"]:Show()
		fheight = fheight + 32
	else
		aUF_Frames[frame.. "ResourceFrame"]:Hide()
	end
	
	aUF_Frames[frame.. "CNameText"] = aUF_Frames[frame]:CreateFontString("aUF_" ..frame.. "CNameText", "OVERLAY")
	aUF_Frames[frame.. "CNameText"]:SetFont(fontLoc..fontFile, 18, "")
	aUF_Frames[frame.. "CNameText"]:SetShadowOffset(1, -1)
	aUF_Frames[frame.. "CNameText"]:SetShadowColor(0, 0, 0, 0.8)
	local cframe, cpos1, cpos2, cpos3, cpos4, cxaxis, cyaxis = "HealthFrame", "TOP", "LEFT", "CEN", "TER", -(aUF_Frames[frame.. "CNameText"]:GetStringWidth() / 2), 40
	if not aUF_FrameVariables[frame]["cnameTop"] then
		cpos1 = "BOTTOM"
		if aUF_FrameVariables[frame]["resource"] then
			cframe = "ResourceFrame"
		else
			cframe = "HealthFrame"
		end
		cyaxis = -37
	end
	aUF_Frames[frame.. "CNameText"]:SetPoint(string.format("%s%s", cpos1, cpos2), aUF_Frames[string.format("%s%s", frame, cframe)], string.format("%s%s", cpos3, cpos4), cxaxis, cyaxis)
	aUF_Frames[frame.. "CNameText"]:SetText(frame)
	aUF_Frames[frame.. "CNameText"]:Show()
	
	aUF_Frames[frame.. "PortraitFrame"] = CreateFrame("Frame", "aUF_" ..frame.. "PortraitFrame", aUF_Frames[frame])
	aUF_Frames[frame.. "PortraitFrame"]:SetWidth(64)
	aUF_Frames[frame.. "PortraitFrame"]:SetHeight(64)
	aUF_Frames[frame.. "PortraitFrame"]:SetFrameLevel(1)
	if not aUF_FrameVariables[frame]["portraitRight"] then
		aUF_Frames[frame.. "PortraitFrame"]:SetPoint("TOPRIGHT", aUF_Frames[frame.. "HealthFrame"], "TOPLEFT", -1, 0)
	else
		aUF_Frames[frame.. "PortraitFrame"]:SetPoint("TOPLEFT", aUF_Frames[frame.. "HealthFrame"], "TOPRIGHT", 1, 0)
	end
	aUF_Frames[frame.. "PortraitFrame"]:SetBackdrop({
		bgFile = textureLoc..textureBg,
		edgeFile = textureLoc..textureBorder,
		edgeSize = 1
	})
	aUF_Frames[frame.. "PortraitFrame"]:SetBackdropColor(0.4, 0.4, 0.4, 0.6)
	aUF_Frames[frame.. "PortraitFrame"]:SetBackdropBorderColor(0, 0, 0, 1)
	aUF_Frames[frame.. "PortraitFrame"]:Show()
	
	aUF_Frames[frame.. "Portrait"] = CreateFrame("PlayerModel", "aUF_" ..frame.. "Portrait", aUF_Frames[frame])
	aUF_Frames[frame.. "Portrait"]:SetWidth(62)
	aUF_Frames[frame.. "Portrait"]:SetHeight(62)
	aUF_Frames[frame.. "Portrait"]:SetFrameLevel(2)
	aUF_Frames[frame.. "Portrait"]:SetPoint("TOPLEFT", aUF_Frames[frame.. "PortraitFrame"], "TOPLEFT", 1, -1)
	if not UnitExists(frame) or not UnitIsConnected(frame) or not UnitIsVisible(frame) then
		aUF_Frames[frame.. "Portrait"]:SetModelScale(4.25)
		aUF_Frames[frame.. "Portrait"]:SetPosition(0, 0, -0.75)
		aUF_Frames[frame.. "Portrait"]:SetModel("Interface\\Buttons\\talktomequestionmark.mdx")
	else
		aUF_Frames[frame.. "Portrait"]:SetUnit(frame)
		aUF_Frames[frame.. "Portrait"]:SetCamera(0)
	end
	aUF_Frames[frame.. "Portrait"]:Show()
	if aUF_FrameVariables[frame]["portrait"] then
		aUF_Frames[frame.. "PortraitFrame"]:Show()
		fwidth = fwidth + 64
		fheight = 64
	else
		aUF_Frames[frame.. "PortraitFrame"]:Hide()
	end
	
	aUF_Frames[frame]:SetWidth(fwidth)
	aUF_Frames[frame]:SetHeight(fheight)
	local frameAnchor, frameX, frameY = aUF_FrameVariables[frame]["posAnchor"], aUF_FrameVariables[frame]["posX"], aUF_FrameVariables[frame]["posY"]
	if frameAnchor and frameX and frameY then
		aUF_Frames[frame]:SetPoint("TOPLEFT", UIParent, frameAnchor, frameX, frameY)
	else
		aUF_Frames[frame]:SetPoint("TOPLEFT", UIParent, "CENTER", -(fwidth / 2), 0)
	end
	aUF_Frames[frame]:Show()
	
	SetUIScripts(frame)
end

local function InitializeVariables()
	for k, v in pairs(aUF_FrameDefaultVariables) do
		if not aUF_FrameVariables[k] then
			aUF_FrameVariables[k] = v
		end
	end
	
	for f = 1, #aUF_FrameNames do
		aUF_DisableFrame(aUF_DefaultFrameNames[f])
		aUF_CreateFrame(aUF_FrameNames[f])
	end
end

function events:ADDON_LOADED(name)
	if name == 'AnonymousUF' then
		print("aUF (Version: |cFFF0F000" .. GetAddOnMetadata("AnonymousUF", "Version") .. "|r)  Loaded - /aUF")
		InitializeVariables()
	end
end

function events:UNIT_PORTRAIT_UPDATE(unit)
	if unit == nil or not aUF_FrameVariables[unit]["portrait"] then return end
	
	if aUF_Frames[unit.. "Portrait"] then
		if not aUF_FrameTemporaryVariables["locked"] or not UnitExists(unit) or not UnitIsConnected(unit) or not UnitIsVisible(unit) then
			aUF_Frames[unit.. "Portrait"]:SetModelScale(4.25)
			aUF_Frames[unit.. "Portrait"]:SetPosition(0, 0, -0.75)
			aUF_Frames[unit.. "Portrait"]:SetModel("Interface\\Buttons\\talktomequestionmark.mdx")
		else
			aUF_Frames[unit.. "Portrait"]:SetUnit(unit)
			aUF_Frames[unit.. "Portrait"]:SetCamera(0)
		end
		
		aUF_Frames[unit.. "Portrait"]:Show()
	end
end

function events:PLAYER_TARGET_CHANGED()
	unit = "target"
	if unit == nil or not aUF_FrameVariables[unit]["portrait"] then return end
	
	if aUF_Frames[unit.. "Portrait"] then
		if not aUF_FrameTemporaryVariables["locked"] or not UnitExists(unit) or not UnitIsConnected(unit) or not UnitIsVisible(unit) then
			aUF_Frames[unit.. "Portrait"]:SetModelScale(4.25)
			aUF_Frames[unit.. "Portrait"]:SetPosition(0, 0, -0.75)
			aUF_Frames[unit.. "Portrait"]:SetModel("Interface\\Buttons\\talktomequestionmark.mdx")
		else
			aUF_Frames[unit.. "Portrait"]:SetUnit(unit)
			aUF_Frames[unit.. "Portrait"]:SetCamera(0)
		end
		
		aUF_Frames[unit.. "Portrait"]:Show()
	end
end

function events:PLAYER_FOCUS_CHANGED()
	unit = "focus"
	if unit == nil or not aUF_FrameVariables[unit]["portrait"] then return end
	
	if aUF_Frames[unit.. "Portrait"] then
		if not aUF_FrameTemporaryVariables["locked"] or not UnitExists(unit) or not UnitIsConnected(unit) or not UnitIsVisible(unit) then
			aUF_Frames[unit.. "Portrait"]:SetModelScale(4.25)
			aUF_Frames[unit.. "Portrait"]:SetPosition(0, 0, -0.75)
			aUF_Frames[unit.. "Portrait"]:SetModel("Interface\\Buttons\\talktomequestionmark.mdx")
		else
			aUF_Frames[unit.. "Portrait"]:SetUnit(unit)
			aUF_Frames[unit.. "Portrait"]:SetCamera(0)
		end
		
		aUF_Frames[unit.. "Portrait"]:Show()
	end
end

aUF:SetScript("OnUpdate", function(self, elapsed)
	lastUpdate = lastUpdate + elapsed
    if lastUpdate >= 0.05 then
		for f = 1, #aUF_FrameNames do
			local unit = aUF_FrameNames[f]
			if UnitExists(unit) or not aUF_FrameTemporaryVariables["locked"] then
				local healthPercentage = (UnitHealth(unit) / UnitHealthMax(unit))
				if UnitHealthMax(unit) == 0 then healthPercentage = 0 end
				aUF_Frames[unit.. "HealthText"]:SetText(string.format("%s / %s (%d%%)", ReadableNumber(UnitHealth(unit), 1), ReadableNumber(UnitHealthMax(unit), 1), healthPercentage * 100))
				if healthPercentage == 0 then resourcePercentage = 0.01 end
				aUF_Frames[unit.. "HealthBar"]:SetWidth(healthPercentage * 200)
				local playerclass, PLAYERCLASS = UnitClass(unit)
				if playerclass ~= nil and string.upper(playerclass) ~= PLAYERCLASS then PLAYERCLASS = string.upper(playerclass) end
				local classColor = RAID_CLASS_COLORS[PLAYERCLASS]
				if classColor == nil then
					if UnitIsFriend("player", unit) == nil and UnitIsEnemy("player", unit) == nil then
						classColor = {["r"] = 1, ["g"] = 1, ["b"] = 0}
					elseif UnitIsFriend("player", unit) then
						classColor = {["r"] = 0, ["g"] = 1, ["b"] = 0}
					elseif UnitIsEnemy("player", unit) then
						classColor = {["r"] = 1, ["g"] = 0, ["b"] = 0}
					end
				end
				if aUF_FrameTemporaryVariables["locked"] then
					aUF_Frames[unit.. "HealthFrame"]:SetBackdropColor(classColor.r - 0.2, classColor.g - 0.2, classColor.b - 0.2, 1)
					aUF_Frames[unit.. "HealthBar"]:SetBackdropColor(classColor.r, classColor.g, classColor.b, 1)
				else
					aUF_Frames[unit.. "HealthFrame"]:SetBackdropColor(0.4, 0.4, 0.4, 1)
					aUF_Frames[unit.. "HealthBar"]:SetBackdropColor(0.4, 0.4, 0.4, 1)
					aUF_Frames[unit.. "HealthBar"]:SetWidth(200)
					aUF_Frames[unit.. "HealthText"]:SetText(string.format("%s / %s (%d%%)", 0, 0, 0))
				end
				aUF_Frames[unit.. "HealthFrame"]:SetBackdropBorderColor(0, 0, 0, 1)
				aUF_Frames[unit.. "HealthBar"]:SetBackdropBorderColor(0, 0, 0, 1)
				
				if aUF_FrameVariables[unit]["resource"] then
					local resourcePercentage = (UnitMana(unit) / UnitManaMax(unit))
					if UnitManaMax(unit) == 0 then resourcePercentage = 0 end
					aUF_Frames[unit.. "ResourceText"]:SetText(string.format("%s / %s (%d%%)", ReadableNumber(UnitMana(unit), 1), ReadableNumber(UnitManaMax(unit), 1), resourcePercentage * 100))
					if resourcePercentage == 0 then resourcePercentage = 0.01 end
					local resourceColor = {}
					resourceColor.r, resourceColor.g, resourceColor.b, resourceColor.a = unpack(resourceColors[UnitPowerType(unit) + 1])
					aUF_Frames[unit.. "ResourceBar"]:SetWidth(resourcePercentage * 200)
					if aUF_FrameTemporaryVariables["locked"] == true then
						if UnitPowerType(unit) == 0 then
							aUF_Frames[unit.. "ResourceFrame"]:SetBackdropColor(resourceColor.r - 0.5, resourceColor.g - 0.5, resourceColor.b - 0.5, 1)
						else
							aUF_Frames[unit.. "ResourceFrame"]:SetBackdropColor(resourceColor.r - 0.3, resourceColor.g - 0.3, resourceColor.b - 0.3, 1)
						end
						aUF_Frames[unit.. "ResourceBar"]:SetBackdropColor(resourceColor.r, resourceColor.g, resourceColor.b, 1)
					else
						aUF_Frames[unit.. "ResourceFrame"]:SetBackdropColor(0.4, 0.4, 0.4, 1)
						aUF_Frames[unit.. "ResourceBar"]:SetBackdropColor(0.4, 0.4, 0.4, 1)
						aUF_Frames[unit.. "ResourceBar"]:SetWidth(200)
						aUF_Frames[unit.. "ResourceText"]:SetText(string.format("%s / %s (%d%%)", 0, 0, 0))
					end
					aUF_Frames[unit.. "ResourceFrame"]:SetBackdropBorderColor(0, 0, 0, 1)
					aUF_Frames[unit.. "ResourceBar"]:SetBackdropBorderColor(0, 0, 0, 1)
					aUF_Frames[unit.. "ResourceFrame"]:Show()
					aUF_Frames[unit.. "ResourceBar"]:Show()
					aUF_Frames[unit.. "ResourceText"]:Show()
				else
					aUF_Frames[unit.. "ResourceFrame"]:Hide()
					aUF_Frames[unit.. "ResourceBar"]:Hide()
					aUF_Frames[unit.. "ResourceText"]:Hide()
				end
				
				if not aUF_FrameTemporaryVariables["locked"] then
					aUF_Frames[unit.. "CNameText"]:SetText(string.format("%s", unit))
				else
					if UnitIsAFK(unit) then
						aUF_Frames[unit.. "CNameText"]:SetText(string.format("<AFK>%s", UnitName(unit)))
					elseif UnitIsDND(unit) then
						aUF_Frames[unit.. "CNameText"]:SetText(string.format("<DND>%s", UnitName(unit)))
					else
						aUF_Frames[unit.. "CNameText"]:SetText(string.format("%s", UnitName(unit)))
					end
				end
				local cframe, cpos1, cpos2, cpos3, cpos4, cxaxis, cyaxis = "HealthFrame", "TOP", "LEFT", "CEN", "TER", -(aUF_Frames[unit.. "CNameText"]:GetStringWidth() / 2), 40
				if not aUF_FrameVariables[unit]["cnameTop"] then
					cpos1 = "BOTTOM"
					if aUF_FrameVariables[unit]["resource"] then
						cframe = "ResourceFrame"
					else
						cframe = "HealthFrame"
					end
					cyaxis = -37
				end
				aUF_Frames[unit.. "CNameText"]:SetPoint(string.format("%s%s", cpos1, cpos2), aUF_Frames[string.format("%s%s", unit, cframe)], string.format("%s%s", cpos3, cpos4), cxaxis, cyaxis)
				
				if aUF_FrameTemporaryVariables["locked"] then
					if aUF_FrameVariables[unit]["portrait"] then
						aUF_Frames[unit.. "PortraitFrame"]:Show()
						aUF_Frames[unit.. "Portrait"]:SetCamera(0)
						aUF_Frames[unit.. "Portrait"]:Show()
					else
						aUF_Frames[unit.. "PortraitFrame"]:Hide()
					end
				else
					if aUF_FrameVariables[unit]["portrait"] then
						aUF_Frames[unit.. "PortraitFrame"]:Show()
						aUF_Frames[unit.. "Portrait"]:SetModelScale(4.25)
						aUF_Frames[unit.. "Portrait"]:SetPosition(0, 0, -0.75)
						aUF_Frames[unit.. "Portrait"]:SetModel("Interface\\Buttons\\talktomequestionmark.mdx")
						aUF_Frames[unit.. "Portrait"]:Show()
					else
						aUF_Frames[unit.. "PortraitFrame"]:Hide()
					end
				end
				
				if aUF_FrameTemporaryVariables["locked"] then
					local _, _, relativePoint, xOfs, yOfs = aUF_Frames[unit]:GetPoint(1)
					aUF_FrameVariables[unit]["posAnchor"] = relativePoint
					aUF_FrameVariables[unit]["posX"] = xOfs
					aUF_FrameVariables[unit]["posY"] = yOfs
				end
				
				aUF_Frames[unit]:Show()
			else
				aUF_Frames[unit]:Hide()
			end
		end
		
        lastUpdate = 0
    end
end)

aUF:SetScript("OnEvent", function(self, event, ...) events[event](self, ...) end)
for event in pairs(events) do
	aUF:RegisterEvent(event)
end

function SlashCmdList.aUF(msg, editbox)
	msg = {strsplit(" ", strlower(msg))}
	if msg[1] == "layout" then
		if string.lower(tostring(msg[2])) == "1920x1080wide" then
			aUF_FrameVariables = aUF_FrameLayout1920x1080WideVariables
			SetCVar("useUIScale", 1);
			SetCVar("uiScale", 0.64);
			for f = 1, #aUF_FrameNames do
				local unit = aUF_FrameNames[f]
				local frameAnchor, frameX, frameY, frameWidth = aUF_FrameLayout1920x1080WideVariables[unit]["posAnchor"], aUF_FrameLayout1920x1080WideVariables[unit]["posX"], aUF_FrameLayout1920x1080WideVariables[unit]["posY"], aUF_Frames[unit]:GetWidth()
				if frameAnchor and frameX and frameY then
					aUF_Frames[unit]:SetPoint("TOPLEFT", UIParent, frameAnchor, frameX, frameY)
				else
					aUF_Frames[unit]:SetPoint("TOPLEFT", UIParent, "CENTER", -(frameWidth / 2), 0)
				end
			end
			print("aUF - Has been set to layout: |cFFC0C0001920x1080 (Wide) & 0.64 UI Scale")
		else
			print("aUF (Version: |cFFF0F000" .. GetAddOnMetadata("AnonymousUF", "Version") .. "|r) - Layouts:")
			print("  /auf layout 1920x1080Wide - Sets the aUF UI to the preset 1020x1080 (Wide) & 0.64 UI Scale layout")
		end
	elseif msg[1] == "reset" then
		aUF_FrameVariables = aUF_FrameDefaultVariables
		for f = 1, #aUF_FrameNames do
			local unit = aUF_FrameNames[f]
			local frameAnchor, frameX, frameY, frameWidth = aUF_FrameVariables[unit]["posAnchor"], aUF_FrameVariables[unit]["posX"], aUF_FrameVariables[unit]["posY"], aUF_Frames[unit]:GetWidth()
			if frameAnchor and frameX and frameY then
				aUF_Frames[unit]:SetPoint("TOPLEFT", UIParent, frameAnchor, frameX, frameY)
			else
				aUF_Frames[unit]:SetPoint("TOPLEFT", UIParent, "CENTER", -(frameWidth / 2), 0)
			end
		end
		print("aUF - Has been: |cFFC0C000Reset")
	elseif msg[1] == "edit" then
		aUF_FrameTemporaryVariables["locked"] = not aUF_FrameTemporaryVariables["locked"]
		for f = 1, #aUF_FrameNames do
			local unit = aUF_FrameNames[f]
			if aUF_FrameVariables[unit]["portrait"] then
				if UnitExists(unit) and aUF_FrameTemporaryVariables["locked"] then
					aUF_Frames[unit.. "Portrait"]:SetUnit(unit)
					aUF_Frames[unit.. "Portrait"]:SetCamera(0)
				else
					aUF_Frames[unit.. "Portrait"]:SetModelScale(4.25)
					aUF_Frames[unit.. "Portrait"]:SetPosition(0, 0, -0.75)
					aUF_Frames[unit.. "Portrait"]:SetModel("Interface\\Buttons\\talktomequestionmark.mdx")
				end
				aUF_Frames[unit.. "Portrait"]:Show()
			end
		end
		print("aUF - Edit Mode: " .. (aUF_FrameTemporaryVariables["locked"] and "|cFFC00000Off" or "|cFF00C000On"))
	else
		print("aUF (Version: |cFFF0F000" .. GetAddOnMetadata("AnonymousUF", "Version") .. "|r) - Commands:")
		print("  /auf layout - Sets the aUF UI to a preset layout")
		print("  /auf reset - Reset the aUF UI to the default settings")
		print("  /auf edit - Toggles the edit mode on the aUF UI so that it can or cannot be moved")
	end
end