function print(msg)
	DEFAULT_CHAT_FRAME:AddMessage(msg)
end

function ReadableNumber(num, places)
	local ret
	local placeValue = ("%%.%df"):format(places or 0)
	
	if num < 1 then
		return 0
	elseif num >= 1000000000000 then
		ret = placeValue:format(num / 1000000000000) .. " Tril" -- Trillion
	elseif num >= 1000000000 then
		ret = placeValue:format(num / 1000000000) .. " Bil" -- Billion
	elseif num >= 1000000 then
		ret = placeValue:format(num / 1000000) .. " Mil" -- Million
	elseif num >= 1000 then
		ret = placeValue:format(num / 1000) .. " K" -- Thousand
	else
		ret = num -- Hundreds
	end
	
	return ret
end

function GetSpecialization(inspect)
	local spec, talents, count = 0, {}, 0
	
	for i = 1, GetNumTalentTabs(inspect) do
		local _,_,spent,_ = GetTalentTabInfo(i, inspect)
		tinsert(talents, spent)
	end
	
	for t = 1, #talents do
		count = talents[t]
		if count > 0 then
			if spec == 0 then
				spec = t
			else
				if count > talents[spec] then
					spec = t
				end
			end
		end
	end
	
	return spec
end

function GetSpecializationName(inspect)
	local spec, talents, count = 0, {}, 0
	
	for i = 1, GetNumTalentTabs(inspect) do
		local _,_,spent,_ = GetTalentTabInfo(i, inspect)
		tinsert(talents, spent)
	end
	
	for t = 1, #talents do
		count = talents[t]
		if count > 0 then
			if spec == 0 then
				spec = t
			else
				if count > talents[spec] then
					spec = t
				end
			end
		end
	end
	
	if spec == 0 then
		return	"No Talents"
	end
	
	return select(1, GetTalentTabInfo(spec, inspect))
end

function GetTalents(inspect)
	local talents
	
	for i = 1, GetNumTalentTabs(inspect) do
		local _,_,spent,_ = GetTalentTabInfo(i, inspect)
		
		if talents == nil then
			talents = spent
		else
			talents = talents.. "/" ..spent
		end
	end
	
	return talents
end