-- local L = AceLibrary("AceLocale-2.2"):new("AnnounceIt")

local annmenuitems = {
	type = "group",
	args = { },
}

local Dewdrop = AceLibrary("Dewdrop-2.0")  -- dewdrop is for the menu functions (only needed if FuBar is not there)

AnnounceIt = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceDB-2.0","FuBarPlugin-2.0")
local tablet = AceLibrary("Tablet-2.0")

AnnounceIt.version = "2.0.0"
AnnounceIt.hasIcon = true
AnnounceIt.Name = "AnnounceIt"

AnnounceIt:RegisterDB("AnnounceItDB")
AnnounceIt:RegisterDefaults('profile', {
	messagelimit = 20,
	fieldlimit = 5,
	messages = { },
	chattypes = {
		TEST = false,
		GROUP = false,
		GUILD = false,
		WHISPER = false,
		RECRUIT = false,
		SAY = false,
		YELL = false,
		BATTLEGROUND = false,
        TRADE = false,
	},
})

function AnnounceIt:OnInitialize()
	if IsAddOnLoaded("Fubar") then
		AnnounceIt:InitMenu()
		AnnounceIt.OnMenuRequest = annmenuitems
		AnnounceIt.defaultPosition = "LEFT"
		AnnounceIt.defaultMinimapPosition = 200
		AnnounceIt.cannotDetachTooltip = false
		AnnounceIt.hideWithoutStandby = true
		AnnounceIt.clickableTooltip = false
	end
end

function AnnounceIt:OnDisable()
    if not self.is_fubar_loaded then
        tablet:Close(tabletParent)
    end
end

-- build/rebuild the menu when called
function AnnounceIt:InitMenu()
	local menucount = 0
	for z,value in pairs(self.db.profile.messages) do
		annmenuitems.args[z] = {}
		annmenuitems.args[z].type = "group"
		annmenuitems.args[z].name = self.db.profile.messages[z].title
		annmenuitems.args[z].desc = "Menu for this message"
		annmenuitems.args[z].args = {}
		for sendchannel,senditemvalue in pairs(self.db.profile.messages[z].chan) do 	
			annmenuitems.args[z].args[sendchannel] = {}
			annmenuitems.args[z].args[sendchannel].type = "execute"
			annmenuitems.args[z].args[sendchannel].name = sendchannel
			annmenuitems.args[z].args[sendchannel].desc = "Send this message to "..sendchannel
			annmenuitems.args[z].args[sendchannel].func = function() AnnounceIt:SendMessage(z,sendchannel) end
			menucount = menucount + 1
		end
		menucount = menucount + 1
		annmenuitems.args[z].args[menucount] = {}
		annmenuitems.args[z].args[menucount].type = "header"
		annmenuitems.args[z].args[menucount].order = 101
		menucount = menucount + 1
		annmenuitems.args[z].args[menucount] = {}
		annmenuitems.args[z].args[menucount].type = "execute"
		annmenuitems.args[z].args[menucount].name = "Edit this Message"
		annmenuitems.args[z].args[menucount].order = 102
		annmenuitems.args[z].args[menucount].desc = "Send this message to "
		annmenuitems.args[z].args[menucount].func = function() AnnounceIt:EditMessage(z) end	
		menucount = menucount + 1
		annmenuitems.args[z].args[menucount] = {}
		annmenuitems.args[z].args[menucount].type = "execute"
		annmenuitems.args[z].args[menucount].name = "Delete this Message"
		annmenuitems.args[z].args[menucount].order = 103
		annmenuitems.args[z].args[menucount].desc = "Delete the message you have selected"
		annmenuitems.args[z].args[menucount].func = function() AnnounceIt:DeleteMessage(z) end	
	end
	annmenuitems.args.newmessage = {}
	annmenuitems.args.newmessage.type = "execute"
	annmenuitems.args.newmessage.name = "Add New Message"
	annmenuitems.args.newmessage.desc = "Add New Message"
	annmenuitems.args.newmessage.order = 102
	annmenuitems.args.newmessage.func = function() AnnounceIt:NewMessage() end
end

-- create a new message and edit it
function AnnounceIt:NewMessage()
	for index,value in pairs(self.db.profile.chattypes) do
		getglobal("AnnounceItSetMessage_Chan"..index):SetChecked(false)
	end
	local i
	for i=1,self.db.profile.fieldlimit,1 do
		getglobal("AnnounceItSetMessage_Text"..i):SetText("")
	end
	AnnounceItSetMessage_Label:SetText("New Message")
	active_message_id = "New"
	AnnounceItSetMessage_Header4:SetText(AnnounceIt.Name.." "..AnnounceIt.version)
	AnnounceItSetMessage:Show()
end


-- populate and open the edit box with the selected message
function AnnounceIt:EditMessage(messageID)
	for index,value in pairs(self.db.profile.chattypes) do
		getglobal("AnnounceItSetMessage_Chan"..index):SetChecked(false)
	end
	for index,value in pairs(self.db.profile.messages[messageID].chan) do
		getglobal("AnnounceItSetMessage_Chan"..index):SetChecked(true)
	end
	
	local i
	for i=1,self.db.profile.fieldlimit,1 do
		getglobal("AnnounceItSetMessage_Text"..i):SetText(self.db.profile.messages[messageID].text[i])
	end
	AnnounceItSetMessage_Label:SetText(self.db.profile.messages[messageID].title)
	active_message_id = messageID
	AnnounceItSetMessage_Header4:SetText(AnnounceIt.Name.." "..AnnounceIt.version)
	AnnounceItSetMessage:Show()
end

-- Take the message and send it
function AnnounceIt:SendMessage(selectedmessage,selectedchannel)
	if ( selectedchannel == "TEST" ) then
		DEFAULT_CHAT_FRAME:AddMessage("Testing: "..self.db.profile.messages[selectedmessage].title, 1.0, 0.0, 0.0)
		for index,value in pairs(self.db.profile.messages[selectedmessage].text) do
			if self.db.profile.messages[selectedmessage].text[index] ~= "" then
				DEFAULT_CHAT_FRAME:AddMessage(self.db.profile.messages[selectedmessage].text[index], 1.0, 0.0, 0.0)
			end
		end
	else
		local channelid = "nochannel"
		local errormessage = nil
		local messagechannel = selectedchannel
		if ( selectedchannel == "RECRUIT" ) then
			channelid = GetChannelName("GuildRecruitment - City")
			messagechannel = "CHANNEL"
		end
		if ( selectedchannel == "WHISPER" ) then
			if ChatFrameEditBox:IsVisible() then
				channelid = ChatFrameEditBox:GetAttribute("channelTarget")
				channelType = ChatFrameEditBox:GetAttribute("chatType")
				if(channelType == "REPLY") then
					channelid = ChatEdit_GetLastTellTarget(ChatFrameEditBox)
				elseif(channelType == "WHISPER") then
					channelid = ChatFrameEditBox:GetAttribute("tellTarget")
				end
			else
				errormessage = "You are not in whisper or reply mode."
			end
		end	
		if ( selectedchannel == "GROUP" ) then
			if ( GetNumPartyMembers() > 1 ) then
				if ( UnitInRaid("player") ) then
					messagechannel = "RAID"
				else
					messagechannel = "PARTY"
				end
			else
				errormessage = "You are not in a party or raid."
			end
		end
        if ( selectedchannel == "TRADE" ) then
			channelid = GetChannelName("Trade - City")
			messagechannel = "CHANNEL"
        end
		if (errormessage) then
			DEFAULT_CHAT_FRAME:AddMessage("AnnounceIt Error: "..errormessage, 1.0, 0.0, 0.0)
			errormessage = nil
		else
			for index,value in pairs(self.db.profile.messages[selectedmessage].text) do
				SendChatMessage(self.db.profile.messages[selectedmessage].text[index], messagechannel, nil, channelid)
			end
		end
	end
end

-- save the edit box values to the addon variables
function AnnounceIt:Save()
	if (active_message_id == "New") then
		active_message_id = AnnounceItSetMessage_Label:GetText()
		self.db.profile.messages[active_message_id] = {}
	end
	self.db.profile.messages[active_message_id].title = AnnounceItSetMessage_Label:GetText()
	self.db.profile.messages[active_message_id].chan = {}
	for index,value in pairs(self.db.profile.chattypes) do
		if (getglobal("AnnounceItSetMessage_Chan"..index):GetChecked()) then	
			self.db.profile.messages[active_message_id].chan[index] = true
		end
	end
	local i
	self.db.profile.messages[active_message_id].text = {}
	for i=1,self.db.profile.fieldlimit,1 do
		self.db.profile.messages[active_message_id].text[i] = getglobal("AnnounceItSetMessage_Text"..i):GetText()
	end 
	active_message_id = nil
	AnnounceIt:InitMenu()
end

-- simple deletion of a message
function AnnounceIt:DeleteMessage(deleteid)
	self.db.profile.messages[deleteid] = nil
	annmenuitems.args[deleteid] = nil
	AnnounceIt:InitMenu()
end

-- menu for minimap button
function AnnounceIt:OnMenuRequest()
	AnnounceIt:InitMenu()
	Dewdrop:FeedAceOptionsTable(annmenuitems)
end
function AnnounceIt:OnTextUpdate()
	self:SetText(AnnounceIt.Name)
end
function AnnounceIt:OnTooltipUpdate()
	tablet:SetTitle(AnnounceIt.Name.." |cFF0000FF"..AnnounceIt.version)
end

