------------------------------------------------------------------------
--	AnkhCooldownTimer
--	by Phanx < addons AT phanx net >
--	This addon is not to be redistributed, including as part of a
--	compilation, without the prior permission of the author.
------------------------------------------------------------------------

AnkhCooldownTimer = {}

local L = ANKHCOOLDOWNTIMER_LOCAL

L.TITLE	= GetAddOnMetadata("AnkhCooldownTimer", "Title")
L.DESC	= GetAddOnMetadata("AnkhCooldownTimer", "Notes")
L.VERSION	= GetAddOnMetadata("AnkhCooldownTimer", "Version")

L.ANKH				= GetItemInfo(17030) or L.ANKH
L.REINCARNATION 		= GetSpellInfo(20608)
L.IMPROVED_REINCARNATION = GetSpellInfo(16184)

L.COLOR = "|cff7fff7f"
L.NA = "|cffaaaaaa"..L.NA.."|r"
L.ENABLED = "|cff7fff7f"..L.ENABLED.."|r"
L.DISABLED = "|cffff7f7f"..L.DISABLED.."|r"

local doDebug = false
local testInterval = 5
local updateInterval = 1

local resTime = 0

local defaults = {
	version = L.VERSION,
	enabled = true,
	showgui = true,
	lockgui = false,
	guiscale = 1,
	tooltip = false,
	ankhs = 0,
	warn = 5,
	buy = 0,
	quiet = false,
	alive = true,
	last = 0,
}

------------------------------------------------------------------------
-- Y helo thar!
------------------------------------------------------------------------
function AnkhCooldownTimer:OnLoad()

	SLASH_ANKHCOOLDOWNTIMER1 = "/ankhcooldowntimer"
	SLASH_ANKHCOOLDOWNTIMER2 = "/ankhct"
	SLASH_ANKHCOOLDOWNTIMER3 = "/act"
	SLASH_ANKHCOOLDOWNTIMER4 = "/at"
	SlashCmdList["ANKHCOOLDOWNTIMER"] = function(msg) self:SlashCommand(msg) end

    StaticPopupDialogs["ANKHCOOLDOWNTIMER_WARNING"] = {
        text = L.POP_BUY.."\n\n%s\n%s",
        button1 = TEXT(OKAY),
        showAlert = 0,
        timeout = 0,
        hideOnEscape = 1
    }

	this:RegisterEvent("VARIABLES_LOADED")
end

------------------------------------------------------------------------
-- OnUpdate
------------------------------------------------------------------------
function AnkhCooldownTimer:OnUpdate(elapsed)
	if not ( AnkhCooldownTimerDB and AnkhCooldownTimerDB.enabled and AnkhCooldownTimerDB.show ) then
		AnkhCooldownTimerFrame:Hide()
		return
	end

	this.TimeSinceLastUpdate = this.TimeSinceLastUpdate + elapsed

	while this.TimeSinceLastUpdate > updateInterval do
		local coolText, ankhText = self:GetFormattedStrings()

		if this.guiStyle == "new" then
			AnkhCooldownTimerFrame_Text:SetText(string.format("%s (%s)", coolText, ankhText))
			AnkhCooldownTimerFrame:SetWidth(36 + AnkhCooldownTimerFrame_Text:GetWidth())
		elseif this.guiStyle == "old" then
			AnkhCooldownTimerFrame_AnkhText:SetText(string.format("%s: %s", L.ANKHS, ankhText))
			AnkhCooldownTimerFrame_CoolText:SetText(string.format("%s: %s", L.COOLDOWN, coolText))
		end

		this.TimeSinceLastUpdate = this.TimeSinceLastUpdate - updateInterval
	end

end

------------------------------------------------------------------------
-- OnEvent
------------------------------------------------------------------------
function AnkhCooldownTimer:OnEvent()
    self:Debug("event: "..event)

	if event == "VARIABLES_LOADED" then
		self:InitializeConfig()

	elseif event == "UNIT_INVENTORY_CHANGED" then
		if arg1 == "player" then
			self:ReincarnationTest()
		end

	elseif event == "BAG_UPDATE" then
		self:ReincarnationTest()

	elseif event == "PLAYER_ENTERING_WORLD" then
		self:CheckAnkhs()

	elseif event == "PLAYER_ALIVE" then
		self:PlayerAlive()

	elseif event == "PLAYER_DEAD" then
		self:PlayerDead()

	elseif event == "MERCHANT_SHOW" then
		self:BuyAnkhs()

	end
end

------------------------------------------------------------------------
-- Color-coded display strings
------------------------------------------------------------------------
function AnkhCooldownTimer:GetFormattedStrings()
	local cool = self:GetCurrentCooldown()
	local coolColor = "|cff999999"
	local coolText = L.NA
	if cool then
		if cool == 0 then
			coolColor = "|cff20ff20"
			coolText = L.READY
		elseif cool > 0 then
			coolColor = "|cffff2020"
			coolText = date("%M:%S", cool)
		end
	end
	coolText = string.format("%s%s|r", coolColor, coolText)

	local ankhColor = "|cffffff99"
	if AnkhCooldownTimerDB.ankhs == 0 then
		ankhColor = "|cffff2020"
	elseif AnkhCooldownTimerDB.warn ~= 0 then
		if AnkhCooldownTimerDB.ankhs <= AnkhCooldownTimerDB.warn then
			ankhColor = "|cff20ff20"
		end
	end
	local ankhText = string.format("%s%s|r", ankhColor, AnkhCooldownTimerDB.ankhs)

	return coolText, ankhText
end

------------------------------------------------------------------------
-- GUI tooltip
------------------------------------------------------------------------
function AnkhCooldownTimer:OnEnter()
	local cooldown, ankhs = self:GetFormattedStrings()
	local ability = self:GetAbilityCooldown()
	local last = self:GetLastReincarnation()

	GameTooltip:SetOwner(this)
	GameTooltip:AddLine(L.TITLE)
	GameTooltip:AddDoubleLine(L.ANKHS, ankhs)
	GameTooltip:AddDoubleLine(L.COOLDOWN, "|cffffffff"..cooldown.."|r")
	GameTooltip:AddDoubleLine(L.ABILITY, "|cffffffff"..(ability ~= 0 and (ability.." "..L.MIN) or L.NA).."|r")
	GameTooltip:AddDoubleLine(L.LAST, "|cffffffff"..((last and last ~= 0) and date("%c", tonumber(last) + 1100304000) or L.NA).."|r")
	GameTooltip:Show()
end

------------------------------------------------------------------------
-- Cooldown
------------------------------------------------------------------------
function AnkhCooldownTimer:GetCurrentCooldown()
	local currentCooldown = nil

	if UnitLevel("player") >= 30 then
		local i = 1
		while true do
			local spellName = GetSpellName(i, BOOKTYPE_SPELL)
			if not spellName then break end
			if spellName == L.REINCARNATION then
				local start, duration = GetSpellCooldown(i, BOOKTYPE_SPELL)
				if ( start > 0 ) and ( duration > 0 ) then
					currentCooldown = duration - ( GetTime() - start )
				else
					currentCooldown = 0
				end
				spellID = i
				break
			end
			i = i + 1
		end
	end

	return currentCooldown
end

function AnkhCooldownTimer:GetAbilityCooldown()
	if self:GetCurrentCooldown() == nil then
		AnkhCooldownTimerDB.ability = 0
		return
	end

	local talentPoints = 0
	for talent = 1, GetNumTalentTabs(), 1 do
		for talentIdx = 1, GetNumTalents(talent), 1 do
			nameTalent,_,_,_,currRank,_,_,_ = GetTalentInfo(talent, talentIdx)
			if nameTalent and (nameTalent == L.IMPROVED_REINCARNATION) then
				talentPoints = currRank
				break
			end
		end
	end

	local hasRelic = 0
	if IsEquippedItem(22345) then
		hasRelic = 1
	end

	return 60 - (10 * talentPoints) - (10 * hasRelic)
end

function AnkhCooldownTimer:PrintCooldown()
	local curr = self:GetCurrentCooldown()
	local abil = self:GetAbilityCooldown()
	local text = ""
	if abil > 0 then
		if curr > 0 then
			rem = string.format(L.TEXT_REMAINING, curr)
			text = string.format(L.TEXT_COOLDOWN, abil, rem)
		else
			text = string.format(L.TEXT_COOLDOWN, abil, string.lower(L.READY))
		end
	else
		text = L.TEXT_NOABILITY
	end
	self:Print(text)
end

------------------------------------------------------------------------
-- Reincarnation Test
------------------------------------------------------------------------
function AnkhCooldownTimer:ReincarnationTest()
	self:Debug("Testing for Reincarnation...")
	local num = self:GetAnkhs()
	if num ~= AnkhCooldownTimerDB.ankhs then
		self:Debug("Ankhs don't match! ("..num.." is not "..AnkhCooldownTimerDB.ankhs..") Test starting...")
		if num == (AnkhCooldownTimerDB.ankhs - 1) then
			if not AnkhCooldownTimerDB.alive then
				self:SetLastReincarnation(tostring(time() - 1100304000))
				self:Debug("Reincarnation test passed in .alive")
			elseif ( GetTime() - resTime ) < testInterval then
				self:SetLastReincarnation(tostring(time() - 1100304000))
				self:Debug("Reincarnation test passed in testInterval")
			else
				self:Debug("Reincarnation test failed.")
			end
		end
		self:UpdateAnkhs()
	else
		self:Debug("Ankhs match; test skipped.")
	end
end

------------------------------------------------------------------------
-- Last Reincarnation
------------------------------------------------------------------------
function AnkhCooldownTimer:SetLastReincarnation(v)
	AnkhCooldownTimerDB.last = v
	self:Debug("Last Reincarnation time set to "..date("%c", tonumber(AnkhCooldownTimerDB.last) + 1100304000))
end

function AnkhCooldownTimer:GetLastReincarnation()
	return AnkhCooldownTimerDB.last
end

function AnkhCooldownTimer:PrintLastReincarnation()
	if AnkhCooldownTimerDB.last ~= 0 then
		local lastDate = tonumber(AnkhCooldownTimerDB.last) + 1100304000
		self:Print(string.format(L.TEXT_LAST, date("%x", lastDate), date("%X", lastDate)))
	else
		self:Print(L.TEXT_NOLAST)
	end
end
------------------------------------------------------------------------
-- Ankh Counting
------------------------------------------------------------------------
function AnkhCooldownTimer:UpdateAnkhs()
	local num = GetItemCount(17030)
	if AnkhCooldownTimerDB.ankhs ~= num then
		AnkhCooldownTimerDB.ankhs = num
		self:CheckAnkhs()
	end
	self:Debug("updating ankh count ("..num..")")
end

function AnkhCooldownTimer:GetAnkhs()
	return GetItemCount(17030)
end

function AnkhCooldownTimer:PrintAnkhs()
	self:Print(string.format(L.TEXT_HAVEANKHS, AnkhCooldownTimerDB.ankhs))
end

------------------------------------------------------------------------
-- Low Ankh Warning
------------------------------------------------------------------------
function AnkhCooldownTimer:SetWarning(v, loud)
	if v then
		if tonumber(v) >= 0 and tonumber(v) <= 20 then
			AnkhCooldownTimerDB.warn = tonumber(v)
			if loud then
				if tonumber(v) == 0 then
					self:Print(string.format(L.TEXT_WARNSET, L.DISABLED))
				else
					self:Print(string.format(L.TEXT_WARNSETTO, v))
				end
			end
		else
			self:Print(string.format(L.TEXT_INVALID, v))
		end
	else
		self:PrintWarning()
	end
end

function AnkhCooldownTimer:IsWarning()
	return AnkhCooldownTimerDB.warn > 0 and UnitLevel("player") >= 30
end

function AnkhCooldownTimer:GetWarning()
	return AnkhCooldownTimerDB.warn
end

function AnkhCooldownTimer:PrintWarning()
	if AnkhCooldownTimerDB.warn == 0 then
		self:Print(string.format(L.TEXT_WARNSET, L.DISABLED))
	else
		self:Print(string.format(L.TEXT_WARNSETTO, AnkhCooldownTimerDB.warn))
	end
end

function AnkhCooldownTimer:CheckAnkhs()
	if self:IsWarning() then
--		if AnkhCooldownTimer.ankhs == 0 then
--			self:UpdateAnkhs()
--			return
--		end
		if AnkhCooldownTimerDB.ankhs < AnkhCooldownTimerDB.warn then
			StaticPopup_Show("ANKHCOOLDOWNTIMER_WARNING", string.format(L.POP_HAVE, AnkhCooldownTimerDB.ankhs), string.format(L.POP_PREF, AnkhCooldownTimerDB.warn))
		end
	end
	self:Debug("Checked ankhs against warning threshold.")
end

function AnkhCooldownTimer:CheckAnkhsTest()
	StaticPopup_Show("ANKHCOOLDOWNTIMER_WARNING", string.format(L.POP_HAVE, AnkhCooldownTimerDB.ankhs), string.format(L.POP_PREF, AnkhCooldownTimerDB.warn))
end

------------------------------------------------------------------------
-- Automatic Ankh Purchase
------------------------------------------------------------------------
function AnkhCooldownTimer:SetBuying(v, loud)
	if v then
		if tonumber(v) >= 0 and tonumber(v) <= 20 then
			AnkhCooldownTimerDB.buy = tonumber(v)
			if loud then
				if tonumber(v) == 0 then
					self:Print(string.format(L.TEXT_BUYSET, L.DISABLED))
				else
					self:Print(string.format(L.TEXT_BUYSETTO, v))
				end
			end
		else
			self:Print(string.format(L.TEXT_INVALID, v))
		end
	else
		self:PrintBuying()
	end
end

function AnkhCooldownTimer:IsBuying()
	return AnkhCooldownTimerDB.buy > 0
end

function AnkhCooldownTimer:GetBuying()
	return AnkhCooldownTimerDB.buy
end

function AnkhCooldownTimer:PrintBuying()
	if AnkhCooldownTimerDB.warn == 0 then
		self:Print(string.format(L.TEXT_BUYSET, L.DISABLED))
	else
		self:Print(string.format(L.TEXT_BUYSETTO, AnkhCooldownTimerDB.buy))
	end
end

function AnkhCooldownTimer:BuyAnkhs()
	if self:IsBuying() then
		for i = 1, GetMerchantNumItems() do
			local itemName = GetMerchantItemInfo(i)
			if itemName == L.ANKH then
				local need = AnkhCooldownTimerDB.buy - AnkhCooldownTimerDB.ankhs
				if need > 0 then
					self:Debug("Have "..AnkhCooldownTimerDB.ankhs..", want "..AnkhCooldownTimerDB.buy.. ", buying "..need..".")
					if not AnkhCooldownTimerDB.quiet then self:Print(string.format(L.BUY_SOME, need)) end
					while need > 5 do
						BuyMerchantItem(i, 5)
						need = need - 5
					end
					BuyMerchantItem(i, need)
				else
					if not AnkhCooldownTimerDB.quiet then self:Print(string.format(L.BUY_NONE, tostring(AnkhCooldownTimerDB.buy))) end
				end
				return
			end
		end
	end
end

------------------------------------------------------------------------
-- STFU!
------------------------------------------------------------------------
function AnkhCooldownTimer:ToggleQuiet(loud)
	if AnkhCooldownTimerDB.quiet then
		AnkhCooldownTimerDB.quiet = false
	else
		AnkhCooldownTimerDB.quiet = true
	end
	if loud then self:Print(string.format(L.TEXT_QUIET, AnkhCooldownTimerDB.quiet and L.ENABLED or L.DISABLED)) end
end

function AnkhCooldownTimer:IsQuiet()
	return AnkhCooldownTimerDB.quiet
end

------------------------------------------------------------------------
-- GUI Visiblity
------------------------------------------------------------------------
function AnkhCooldownTimer:ToggleGUIShown(loud)
	if AnkhCooldownTimerDB.show then
		AnkhCooldownTimerDB.show = false
		AnkhCooldownTimerFrame:Hide()
	else
		AnkhCooldownTimerDB.show = true
		AnkhCooldownTimerFrame:Show()
	end
	if loud then self:Print(string.format(L.TEXT_SHOW, AnkhCooldownTimerDB.show and L.ENABLED or L.DISABLED)) end
end

function AnkhCooldownTimer:IsGUIShown()
	return AnkhCooldownTimerDB.show
end

------------------------------------------------------------------------
-- GUI Mobility
------------------------------------------------------------------------
function AnkhCooldownTimer:ToggleGUILocked(loud)
	if AnkhCooldownTimerDB.lock then
		AnkhCooldownTimerDB.lock = false
	else
		AnkhCooldownTimerDB.lock = true
	end
	if loud then self:Print(string.format(L.TEXT_LOCK, AnkhCooldownTimerDB.lock and L.ENABLED or L.DISABLED)) end
end

function AnkhCooldownTimer:IsGUILocked()
	return AnkhCooldownTimerDB.lock
end

------------------------------------------------------------------------
-- Enable/Disable Addon
------------------------------------------------------------------------
function AnkhCooldownTimer:ToggleEnabled(loud)
	if AnkhCooldownTimerDB.enabled then
		self:UnregisterEvents()
		AnkhCooldownTimerDB.enabled = false
		AnkhCooldownTimerFrame:Hide()
	else
		self:RegisterEvents()
		AnkhCooldownTimerDB.enabled = true
		AnkhCooldownTimerFrame:Show()
	end
	if loud then self:Print(string.format(L.TEXT_STATUS, AnkhCooldownTimerDB.enabled and L.ENABLED or L.DISABLED)) end
end

function AnkhCooldownTimer:IsEnabled()
	return AnkhCooldownTimerDB.enabled
end

------------------------------------------------------------------------
-- Slash Commands
------------------------------------------------------------------------
function AnkhCooldownTimer:SlashCommand(txt)
	if not txt or string.len(txt) <= 0 then
		self:ShowHelp()
		return
	end

	local _, _, cmd, arg = string.find(string.lower(txt),"([%w%p]+)%s*(.*)$")

	if not arg or string.len(arg) <= 0 then
		arg = nil
	end

	if cmd == L.CMD_COOLDOWN or cmd == "cool" or cmd == "cd" then
		self:PrintCooldown()

	elseif cmd == L.CMD_LAST then
		self:PrintLastReincarnation()

	elseif cmd == L.CMD_ANKHS then
		self:PrintAnkhs()

	elseif cmd == L.CMD_WARN then
		if arg then
			self:SetWarning(arg, true)
		else
			self:PrintWarning()
		end

	elseif cmd == L.CMD_BUY then
		if arg then
			self:SetBuying(arg, true)
		else
			self:PrintBuying()
		end

	elseif cmd == L.CMD_QUIET then
		self:ToggleQuiet(true)

	elseif cmd == L.CMD_SHOW then
		self:ToggleGUIShown(true)

	elseif cmd == L.CMD_LOCK then
		self:ToggleGUILocked(true)

	elseif cmd == L.CMD_ENABLE or cmd == L.CMD_DISABLE then
		self:ToggleEnabled(true)

	elseif cmd == "version" then
		self:Print("Version "..L.VERSION..", by Phanx <phanx1337@gmail.com>")

	elseif cmd == "debug" then
		doDebug = not doDebug
		self:Print("Debugging "..(doDebug and L.ENABLED or L.DISABLED)..".")
	else
		self:ShowHelp()
	end

end

------------------------------------------------------------------------
-- ZOMG Help!
------------------------------------------------------------------------
function AnkhCooldownTimer:ShowHelp()
	self:Print(L.DESC)
	self:PrintM("", L.HELP_USAGE)
	self:PrintM(L.CMD_COOLDOWN, "- "..L.HELP_COOLDOWN)
	self:PrintM(L.CMD_LAST, "- "..L.HELP_LAST)
	self:PrintM(L.CMD_ANKHS, "- "..L.HELP_ANKHS)
	self:PrintM(L.CMD_WARN, "- "..L.HELP_WARN..string.format(" (%s)", self:IsWarning() and L.ENABLED.." - "..AnkhCooldownTimerDB.warn or L.DISABLED))
	self:PrintM(L.CMD_BUY, "- "..L.HELP_BUY..string.format(" (%s)", self:IsBuying() and L.ENABLED.." - "..AnkhCooldownTimerDB.buy or L.DISABLED))
	self:PrintM(L.CMD_QUIET, "- "..L.HELP_QUIET..string.format(" (%s)", self:IsQuiet() and L.ENABLED or L.DISABLED))
	self:PrintM(L.CMD_SHOW, "- "..L.HELP_SHOW..string.format(" (%s)", self:IsGUIShown() and L.ENABLED or L.DISABLED))
	self:PrintM(L.CMD_LOCK, "- "..L.HELP_LOCK..string.format(" (%s)", self:IsGUILocked() and L.ENABLED or L.DISABLED))
	self:PrintM(L.CMD_ENABLE, "- "..L.HELP_ENABLE..string.format(" (%s)", self:IsEnabled() and L.ENABLED or L.DISABLED))
end

------------------------------------------------------------------------
-- Message Output
------------------------------------------------------------------------
function AnkhCooldownTimer:Print(msg)
	if not msg or msg == "" then return end
	DEFAULT_CHAT_FRAME:AddMessage("|cff7fff7f"..L.TITLE..": |r"..msg)
end

function AnkhCooldownTimer:PrintM(pre, msg)
	if not msg or msg == "" then return end
	if not pre then pre = "" end
	DEFAULT_CHAT_FRAME:AddMessage("    |cff7fff7f"..pre.."|r "..msg)
end

function AnkhCooldownTimer:Debug(msg)
	if doDebug then
		DEFAULT_CHAT_FRAME:AddMessage("|cff7fff7f(DEBUG) "..L.TITLE..": |r"..msg)
	end
end

------------------------------------------------------------------------
-- Event Registration
------------------------------------------------------------------------
function AnkhCooldownTimer:RegisterEvents()
	this:RegisterEvent("PLAYER_LOGIN")
	this:RegisterEvent("PLAYER_ENTERING_WORLD")
	this:RegisterEvent("UNIT_INVENTORY_CHANGED")
	this:RegisterEvent("BAG_UPDATE")
	this:RegisterEvent("PLAYER_ALIVE")
	this:RegisterEvent("PLAYER_DEAD")
	this:RegisterEvent("SPELLS_CHANGED")
	this:RegisterEvent("CHARACTER_POINTS_CHANGED")
	this:RegisterEvent("MERCHANT_SHOW")
	self:Debug("Events registered.")
end

function AnkhCooldownTimer:UnregisterEvents()
	this:UnregisterEvent("PLAYER_LOGIN")
	this:UnregisterEvent("PLAYER_ENTERING_WORLD")
	this:UnregisterEvent("PLAYER_LEAVING_WORLD")
	this:UnregisterEvent("UNIT_INVENTORY_CHANGED")
	this:UnregisterEvent("BAG_UPDATE")
	this:UnregisterEvent("PLAYER_ALIVE")
	this:UnregisterEvent("PLAYER_DEAD")
	this:UnregisterEvent("SPELLS_CHANGED")
	this:UnregisterEvent("CHARACTER_POINTS_CHANGED")
	this:UnregisterEvent("MERCHANT_SHOW")
	self:Debug("Events unregistered.")
end

------------------------------------------------------------------------
-- Miscellaneous Status Changes
------------------------------------------------------------------------
function AnkhCooldownTimer:PlayerAlive()
	AnkhCooldownTimerDB.alive = true
	resTime = GetTime()
	self:Debug("Alive!")
end

function AnkhCooldownTimer:PlayerDead()
	AnkhCooldownTimerDB.alive = false
	self:Debug("Dead!")
end

------------------------------------------------------------------------
-- Variable Initilialization
------------------------------------------------------------------------
function AnkhCooldownTimer:InitializeConfig()

	-- BETA reset saved variables - start
	if AnkhCooldownTimerDB and AnkhCooldownTimerDB.version ~= L.VERSION then
		AnkhCooldownTimerDB = defaults
	end
	-- BETA reset saved variables - end

	if not AnkhCooldownTimerDB then
		AnkhCooldownTimerDB = defaults
		self:Print(string.format(L.LOAD_NEW, UnitName("player"), GetRealmName()))
	end

	if AnkhCooldownTimerDB.version < L.VERSION then
		local temp = defaults
		for k, v in pairs(AnkhCooldownTimerDB) do
			if defaults[k] then
				temp[k] = v
			end
		end
		temp.version = L.VERSION
		AnkhCooldownTimerDB = temp
		self:Print(L.LOAD_OLD)
	end

	local _, class = UnitClass("player")
	if class ~= "SHAMAN" then
		self:UnregisterEvents()
		AnkhCooldownTimerDB.enabled = false
		AnkhCooldownTimerFrame:Hide()
		self:Print(string.format(L.LOAD_CLASS, string.lower(class)))
		return
	end

	self:RegisterEvents()
end