﻿local L = AceLibrary("AceLocale-2.2"):new("Altoholic")
local BB = LibStub("LibBabble-Boss-3.0"):GetLookupTable()
local BZ = LibStub("LibBabble-Zone-3.0"):GetLookupTable()
local BF = LibStub("LibBabble-Faction-3.0"):GetLookupTable()
local BI = LibStub("LibBabble-Inventory-3.0"):GetLookupTable()

-- Simplified loot table containing item ID's only, based on AtlasLoot v4.05.00 
Altoholic.LootTable = {
			
	-- to do: manually find the item id's of lv70 reputation pvp for honor hold items.
	-- to do: HardModeArena & HardModeArena2 from sets_en.lua

	-- Vanilla WoW Raid 40
	[BZ["Molten Core"]] = {
		[BB["Lucifron"]] = {	16800, 16805, 16829, 16837, 16863, 16859, 17329, 18872, 19145, 19146,
								18875, 18870, 18861, 17109, 18879, 19147, 18878, 17077, 16665 },
		[BB["Magmadar"]] = {	16796, 16814, 16810, 16822, 16847, 16835, 16843, 16855, 16867, 19136,
								18823, 18829, 19144, 19143, 18861, 18824, 17065, 18821, 18820, 19142,
								18203, 18822, 17073, 17069	},
		[BB["Gehennas"]] = {	16812, 16826, 16849, 16839, 16862, 16860, 17331, 19145, 18872, 19146,
								18875, 18870, 18861, 18879, 19147, 18878, 17077	},
		[BB["Garr"]] = {	16795, 16813, 16808, 16846, 16834, 16821, 16842, 16866, 16854, 18564,
								19019, 19136, 18823, 18829, 19144, 19143, 18861, 18824, 18821, 18820,
								19142, 17071, 18832, 18822, 17105, 17066 },
		[BB["Shazzrah"]] = {	16801, 16803, 16811, 16831, 16852, 16824, 17332, 19145, 18872, 19146,
								18875, 18870, 18861, 18879, 19147, 18878, 17077	},
		[BB["Baron Geddon"]] = { 16797, 16807, 16836, 16856, 16844, 18563, 19019, 19136, 18823, 18829,
								19144, 19143, 18861, 18824, 17110, 18821, 18820, 19142, 18822 },
		[BB["Golemagg the Incinerator"]] = { 16798, 16815, 16809, 16820, 16833, 16845, 16841, 16865, 16853, 17203,
								17182, 19136, 18823, 18829, 19144, 19143, 18861, 18824, 18821, 18820,
								19142, 17103, 18822, 18842, 17072 },
		[BB["Sulfuron Harbinger"]] = { 16816, 16823, 16848, 16868, 17330, 19145, 18872, 19146, 18875, 18870,
								18861, 18879, 19147, 18878, 17074, 17077 },
		[BB["Majordomo Executus"]] = {	18811, 18808, 18809, 19139, 18810, 18812, 18806, 19140, 18805, 18803,
								18703, 18715, 18713, 18714, 18646, 18608, 18609	},
		[BB["Ragnaros"]] = {	16915, 16922, 16930, 16909, 16901, 16938, 16946, 16962, 16954, 17204, 
								17182, 19017, 19019, 17102, 17107, 18817, 19137, 18814, 19138, 17063,
								17082, 18815, 18816, 17076, 17104, 17106, 21110	},
		[L["Trash Mobs"]] = { 16802, 16817, 16806, 16827, 16828, 16851, 16838, 16864, 16858, 17010, 
								17011, 11382, 17012, 16799, 16819, 16804, 16825, 16830, 16850, 16840, 
								16861, 16857 },
		[L["Random Boss"]] = { 18264, 18262, 18292, 18282, 18291, 18168, 18290, 18283, 18259, 18252, 
								18251, 18265, 18263, 21371, 21342, 18257, 18253, 18260 }
	},
	[BZ["Blackwing Lair"]] = {
		[BB["Razorgore the Untamed"]] = { 16918, 16926, 16934, 16911, 16904, 16935, 16943, 16959, 16951, 19337, 
								19336, 19370, 19369, 19334, 19335 },
		[BB["Vaelastrasz the Corrupt"]] = { 16818, 16925, 16933, 16936, 16903, 16910, 16944, 16960, 16952, 19339, 
								19340, 19372, 19371, 19346, 19348 },
		[BB["Broodlord Lashlayer"]] = { 16912, 16919, 16927, 16898, 16906, 16941, 16949, 16965, 16957, 20383, 
								19342, 19341, 19374, 19373, 19351, 19350 },
		[BB["Firemaw"]] = { 16913, 16920, 16928, 16907, 16940, 16899, 16948, 16964, 16956, 19365, 
								19355, 19353, 19343, 19344, 19398, 19400, 19399, 19396, 19401, 19394, 
								19402, 19397, 19395 },
		[BB["Ebonroc"]] = { 16913, 16920, 16928, 16907, 16940, 16899, 16948, 16964, 16956, 19345, 
								19407, 19405, 19396, 19394, 19403, 19397, 19406, 19395, 19353, 19355, 
								19368	},
		[BB["Flamegor"]] = {	16913, 16920, 16928, 16907, 16940, 16899, 16948, 16964, 16956, 19430, 
								19396, 19433, 19394, 19397, 19432, 19395, 19431, 19353, 19357, 19355, 
								19367	},
		[BB["Chromaggus"]] = { 16917, 16924, 16932, 16937, 16902, 16832, 16945, 16953, 16961, 19386, 
								19388, 19385, 19391, 19389, 19390, 19393, 19392, 19387, 19347, 19352, 
								19349, 19361 },
		[BB["Nefarian"]] = {	16916, 16931, 16923, 16905, 16897, 16942, 16950, 16966, 16958, 19003, 
								19383, 19384, 19366, 19378, 19375, 19381, 19380, 19377, 19382, 19376, 
								19379, 19364, 19363, 19360, 19356, 21138 },
		[L["Trash Mobs"]] = { 19436, 19437, 19438, 19439, 19434, 19362, 19354, 19358, 19435, 18562 }
	},
	[BZ["Onyxia's Lair"]] = { 
		[BB["Onyxia"]] = { 16914, 16921, 16929, 16900, 16908, 16939, 16947, 16963, 16955, 18705, 
								18713, 15410, 17078, 18205, 18813, 17064, 17067, 17075, 17068, 17966, 
								18423, 18404, 18403, 18406	}
	},
	[BZ["Temple of Ahn'Qiraj"] .. " (AQ40)"] = { 
		[BB["The Prophet Skeram"]] = { 21708, 21698, 21699, 21705, 21814, 21704, 21706, 21701, 21702, 21700, 
								21707, 21703, 21128, 21237, 21273, 21275, 21268, 21232, 21242, 21272, 
								21244, 21269, 22222, 22196	},
		[BB["Vem"]] = {	21689, 21691, 21688, 21690	},
		[BB["Princess Yauj"]] = { 21686, 21682, 21684, 21683, 21687},
		[BB["Lord Kri"]] = { 21680, 21603, 21681, 21685 },
		[BB["The Bug Family"]] = { 21697, 21694, 21696, 21693, 21692, 21695, 21237, 21232 },
		[BB["Battleguard Sartura"]] = { 21671, 21676, 21648, 21669, 21672, 21675, 21668, 21674, 21667, 21678, 
								21670, 21666, 21673, 21237, 21273, 21275, 21268, 21232, 21242, 21272, 
								21244, 21269 },
		[BB["Fankriss the Unyielding"]] = {	21627, 21663, 21665, 21645, 21651, 21639, 21652, 21650, 21635, 21647, 
								21664, 22402, 22396, 21237, 21273, 21275, 21268, 21232, 21242, 21272, 
								21244, 21269 },
		[BB["Viscidus"]] = {	21624, 21626, 21623, 21622, 21677, 21625, 22399, 20932, 20928, 21237, 
								21273, 21275, 21268, 21232, 21242, 21272, 21244, 21269 },
		[BB["Princess Huhuran"]] = { 21619, 21621, 21617, 21618, 21616, 21620, 20932, 20928, 21237, 21273, 
								21275, 21268, 21232, 21242, 21272, 21244, 21269 },
		[BB["The Twin Emperors"]] = { 20930, 21600, 21602, 21599, 21598, 21597, 21601, 20735, 21232, 21242, 
								21272, 21244, 21269, 20926, 21604, 21605, 21609, 21607, 21606, 21679, 
								21608, 20726, 21237, 21273, 21275, 21268 },
		[BB["Ouro"]] = { 		21615, 21611, 23557, 21610, 23558, 23570, 20927, 20931, 21237, 21273, 
								21275, 21268, 21232, 21242, 21272, 21244, 21269 },
		[BB["C'Thun"]] = {	21583, 22731, 21585, 22730, 21582, 21586, 21581, 21126, 21134, 21839, 
								22732, 21596, 21579, 20933, 20929, 21221, 21710, 21712, 21709, 22734, 
								22632, 22589, 22631, 22630 },
		[L["Trash Mobs"]] = { 21838, 21888, 21889, 21856, 21837, 21836, 21891, 22202, 22203, 21218, 
								21324, 21323, 21321, 20876, 20879, 20875, 20878, 20881, 20877, 20874,
								20882, 21762, 20864, 20861, 20863, 20862, 20859, 20865, 20860, 20858 },
		[L["Druid Set"]] = { 21357, 21353, 21356, 21354, 21355 },
		[L["Hunter Set"]] = { 21370, 21366, 21368, 21367, 21365 },
		[L["Mage Set"]] = { 21343, 21347, 21346, 21345, 21344 },
		[L["Paladin Set"]] = { 21389, 21387, 21390, 21391, 21388 },
		[L["Priest Set"]] = { 21351, 21348, 21352, 21350, 21349 },
		[L["Rogue Set"]] = { 21364, 21360, 21362, 21361, 21359 },
		[L["Shaman Set"]] = { 21374, 21372, 21375, 21376, 21373 },
		[L["Warlock Set"]] = { 21334, 21337, 21336, 21335, 21338 },
		[L["Warrior Set"]] = { 21331, 21329, 21332, 21330, 21333 },
		[L["Legendary Mount"]] = { 21176 }
	},
	[BZ["Naxxramas"]] = { 
		[BB["Patchwerk"]] = { 22726, 22727, 22368, 22361, 22354, 22960, 22815, 22820, 22818, 22961 },
		[BB["Grobbulus"]] = { 22726, 22727, 22368, 22361, 22354, 22968, 22967, 22803, 22988, 22810 },
		[BB["Gluth"]] = { 22726, 22727, 22983, 22813, 23075, 22994, 22981, 22368, 22361, 22354, 
								22369, 22362, 22355, 22370, 22363, 22356, 22372, 22365, 22358 },
		[BB["Thaddius"]] = {	22726, 22727, 22367, 22360, 22353, 23070, 23000, 22808, 22801, 23001 },
		[BB["Anub'Rekhan"]] = { 22726, 22727, 22369, 22362, 22355, 22938, 22936, 22937, 22939, 22935 },
		[BB["Grand Widow Faerlina"]] = { 22726, 22727, 22369, 22362, 22355, 22941, 22940, 22806, 22942, 22943 },
		[BB["Maexxna"]] = { 22726, 22727, 22371, 22364, 22357, 23220, 22804, 22807, 22947, 22954 },
		[BB["Instructor Razuvious"]] = { 22726, 22727, 22372, 22365, 22358, 23017, 23219, 23014, 23009, 23004, 23018 },
		[BB["Gothik the Harvester"]] = { 22726, 22727, 22372, 22365, 22358, 23032, 23021, 23020, 23073, 23023 },
		[BB["The Four Horsemen"]] = { 22726, 22727, 22351, 22350, 22349, 23071, 22809, 22691, 22811, 23025, 23027 },
		[BB["Noth the Plaguebringer"]] = { 22726, 22727, 22370, 22363, 22356, 23030, 22816, 23005, 23006, 23029, 
								23031, 23028 },
		[BB["Heigan the Unclean"]] = { 22726, 22727, 22370, 22363, 22356, 23035, 23033, 23019, 23068, 23036 },
		[BB["Loatheb"]] = { 22726, 22727, 22366, 22359, 22352, 23039, 22800, 23037, 23038, 23042 },
		[BB["Sapphiron"]] = { 23050, 23045, 23072, 23043, 23242, 23049, 23048, 23040, 23047, 23046, 
								23041, 23545, 23547, 23549, 23548 },
		[BB["Kel'Thuzad"]] = { 22802, 23054, 23577, 23056, 22798, 22799, 22821, 22812, 22819, 23057, 
								23053, 22520, 23207, 23206, 23064, 23067, 23062, 23066, 23061, 23060, 
								23065, 23063, 23059, 22733, 22632, 22589, 22631, 22630 },
		[L["Trash Mobs"]] = { 23069, 23226, 23663, 23664, 23665, 23666, 23667, 23668, 23044, 23221, 
								23238, 23237, 22376, 22373, 22374, 22375, 22708, 23055 },
		[L["Legendaries"]] = { 22632, 22589, 22631, 22630 }
	},
	
	-- Vanilla WoW Raid 20
	[BZ["Zul'Gurub"]] = { 
		[BB["High Priestess Jeklik"]] = { 19717, 19716, 19718, 19721, 19720, 19719, 19724, 19723, 19722, 19943, 
								19881, 19918, 19928, 20262, 20265, 19923, 19920, 19915 },
		[BB["High Priest Venoxis"]] = { 19716, 19718, 19717, 19720, 19721, 19719, 19722, 19723, 19724, 19943, 
								19881, 22216, 19904, 19903, 19907, 19906, 19905, 19900 },
		[BB["High Priestess Mar'li"]] = { 19720, 19719, 19721, 19718, 19716, 19717, 19722, 19723, 19724, 19943, 
								19881, 20032, 19927, 19919, 19871, 19925, 19930 },
		[BB["Bloodlord Mandokir"]] = { 19723, 19724, 19722, 19720, 19719, 19721, 19716, 19718, 19717, 22637,
								19943, 19867, 19866, 19874, 20038, 19872, 19870, 19895, 19869, 19877, 
								19878, 19873, 19893, 19863 },
		[BB["Gri'lek"]] = { 19961, 19962, 19939 },
		[BB["Hazza'rah"]] = { 19968, 19967, 19942 },
		[BB["Renataki"]] = { 19964, 19963, 19940 },
		[BB["Wushoolay"]] = { 19965, 19993, 19941 },
		[BB["Gahz'ranka"]] = { 19945, 19944, 19947, 19946, 22739 },
		[BB["High Priest Thekal"]] = { 19720, 19721, 19719, 19716, 19718, 19717, 19943, 19881, 19897, 19896, 
								19902, 19898, 19899, 20260, 20266, 19901 },
		[BB["High Priestess Arlokk"]] = { 19721, 19720, 19719, 19716, 19717, 19718, 19722, 19723, 19724, 19943, 
								19881, 19910, 19909, 19913, 19912, 19922, 19914 },
		[BB["Jin'do the Hexxer"]] = { 19723, 19722, 19724, 19721, 19719, 19720, 19716, 19717, 19718, 22637,
								19943, 19885, 19891, 19890, 19884, 19888, 19886, 19929, 19889, 19892, 
								19875, 19887, 19894 },
		[BB["Hakkar"]] = {		19857, 20257, 20264, 19855, 19876, 19856, 19859, 19864, 19865, 19854, 
								19852, 19862, 19853, 19861, 19802, 19950, 19949, 19948, 19943 },
		[L["Muddy Churning Waters"]] = { 19975 },
		[L["Shared"]] = { 22721, 22722, 22711, 22712, 22720, 22716, 22718, 22715, 22714, 22713 },
		[L["Trash Mobs"]] = { 20259, 20261, 20263, 19908, 19921, 20258, 19727, 19726, 19774, 19767, 
								19768, 19821, 19816, 19818, 19815, 19820, 19814, 19817, 19819, 19813,
								19708, 19713, 19715, 19711, 19710, 19712, 19707, 19714, 19709, 19706, 
								19701, 19700, 19699, 19704, 19705, 19702, 19698 },
		[L["Enchants"]] = {	19790, 19785, 19787, 19783, 19789, 19784, 19786, 19788, 19782, 20077, 
								20076, 20078, 22635 },
		[L["Druid Set"]] = { 19955, 19613, 19838, 19839, 19840 },
		[L["Hunter Set"]] = { 19953, 19621, 19831, 19832, 19833 },
		[L["Mage Set"]] = { 19959, 19601, 20034, 19845, 19846 },
		[L["Paladin Set"]] = { 19952, 19588, 19825, 19826, 19827 },
		[L["Priest Set"]] = { 19958, 19594, 19841, 19842, 19843 },
		[L["Rogue Set"]] = { 19954, 19617, 19834, 19835, 19836 },
		[L["Shaman Set"]] = { 19956, 19609, 19828, 19829, 19830 },
		[L["Warlock Set"]] = { 19957, 19605, 20033, 19849, 19848 },
		[L["Warrior Set"]] = { 19951, 19577, 19822, 19823, 19824 }
	},
	[BZ["Ruins of Ahn'Qiraj"] .. " (AQ20)"] = { 
		[BB["Kurinnaxx"]] = { 21499, 21498, 21500, 21501, 21502, 21503, 22217, 20889, 20885, 20884, 20888 },
		[L["Rajaxx's Captains"]] = { 21810, 21809, 21806 },
		[BB["General Rajaxx"]] = { 21493, 21492, 21496, 21494, 21497, 21495, 20889, 20885, 20884, 20888 },
		[BB["Lieutenant General Andorov"]] = { 22221, 22219, 22191, 22198  },
		[BB["Moam"]] = { 21472, 21467, 21479, 21471, 21470, 21468, 21455, 21474, 21469, 21476, 
								21475, 21477, 21473, 20886, 20890, 20884, 20888, 22220, 22194 },
		[BB["Buru the Gorger"]] = { 21487, 21486, 21485, 21489, 21491, 21490, 21488, 20886, 20890, 20889, 
								20885, 20884, 20888 },
		[BB["Ayamiss the Hunter"]] = { 21479, 21466, 21478, 21484, 21480, 21482, 21481, 21483, 20886, 20890, 
								20889, 20885, 20884, 20888 },
		[BB["Ossirian the Unscarred"]] = { 21456, 21464, 21462, 21461, 21458, 21454, 21463, 21460, 21453, 21457, 
								21715, 21459, 21452, 21220, 21504, 21507, 21505, 21506, 20886, 20890, 
								20884, 20888 },
		[L["Trash Mobs"]] = { 20873, 20869, 20866, 20870, 20868, 20871, 20867, 20872, 22202, 22203, 
								20864, 20861, 20863, 20862, 20859, 20865, 20860, 20858, 21761 },
		[L["Class Books"]] = { 21294, 21296, 21295, 21306, 21304, 21307, 21279, 21214, 21280, 21288, 
								21289, 21290, 21284, 21287, 21285, 21300, 21303, 21302, 21291, 21292, 
								21293, 21281, 21283, 21282, 21298, 21299, 21297 },
		[L["Druid Set"]] = { 21407, 21409, 21408 },
		[L["Hunter Set"]] = { 21401, 21403, 21402 },
		[L["Mage Set"]] = { 21413, 21415, 21414 },
		[L["Paladin Set"]] = { 21395, 21397, 21396 },
		[L["Priest Set"]] = { 21410, 21412, 21411 },
		[L["Rogue Set"]] = { 21404, 21406, 21405 },
		[L["Shaman Set"]] = { 21398, 21400, 21399 },
		[L["Warlock Set"]] = { 21416, 21418, 21417 },
		[L["Warrior Set"]] = { 21392, 21394, 21393 }
	},

	-- Vanilla WoW 5-men
	[BZ["Gnomeregan"]] = { 
		["Namdo Bizzfizzle"] = { 14639 },
		[BB["Techbot"]] = { 9444, 9277 },
		[BB["Grubbis"]] = { 9445 },
		[BB["Viscous Fallout"]] = { 9454, 9453, 9452 },
		[BB["Electrocutioner 6000"]] = { 9448, 9447, 9446, 6893 },
		[BB["Crowd Pummeler 9-60"]] = { 9450, 9449 },
		[BB["Dark Iron Ambassador"]] = { 9455, 9457, 9456 },
		[BB["Mekgineer Thermaplugg"]] = { 9492, 9461, 9459, 9458, 9299, 4415, 4413, 4411, 7742 },
		[L["Trash Mobs"]] = { 9508, 9491, 9509, 9510, 9327, 9326, 9362, 9538, 9490, 9485, 9486, 9488, 9487 }
	},
	[BZ["The Stockade"]] = { 
		[BB["Targorr the Dread"]] = { 3630 },
		[BB["Kam Deepfury"]] = { 2280, 3640 },
		[BB["Bazil Thredd"]] = { 2926 },
		[BB["Dextren Ward"]] = { 3628 },
		[BB["Bruegal Ironknuckle"]] = { 3228, 2942, 2941 },
		[L["Trash Mobs"]] = { 2909 }
	},
	[BZ["Blackfathom Deeps"]] = { 
		[BB["Ghamoo-ra"]] = { 6908, 6907 },
		[BB["Lady Sarevess"]] = { 888, 11121, 3078 },
		[BB["Gelihast"]] = { 6906, 6905, 1470 },
		[BB["Baron Aquanis"]] = { 16782, 16886, 16887 },
		[BB["Twilight Lord Kelris"]] = { 6903, 1155, 5881 },
		[BB["Old Serra'kis"]] = { 6901, 6902, 6904 },
		[BB["Aku'mai"]] = { 6910, 6911, 6909 },
		[L["Trash Mobs"]] = { 1486, 3416, 1491, 2567, 3413, 3417, 1454, 1481, 3414, 3415, 2271 },
		[L["Quest Items"]] = { 5359, 16762 }
	},
	[BZ["Wailing Caverns"]] = {
		["Kalldan Felmoon"] = { 6474, 6475 },
		[BB["Mad Magglish"]] = { 5334 },
		[BB["Trigore the Lasher"]] = { 5425, 5426 },
		[BB["Boahn"]] = {	5422, 5423 },
		[BB["Lord Cobrahn"]] = { 6460, 6465, 10410 },
		[BB["Lady Anacondra"]] = {5404, 10412, 6446 },
		[BB["Kresh"]] = { 13245, 6447 },
		[BB["Lord Pythas"]] = { 6472, 6473 },
		[BB["Skum"]] = { 6448, 6449 },
		[BB["Lord Serpentis"]] = { 5970, 10411, 6459, 6469 },
		[BB["Verdan the Everliving"]] = {	6629, 6630, 6631 },
		[BB["Mutanus the Devourer"]] = { 6461, 6627, 6463, 10441 },
		[BB["Deviate Faerie Dragon"]] = { 6632, 5243 },
		[L["Druid of the Fang (Trash Mob)"]] = { 10413	}
	},
	[BZ["The Deadmines"]] = {
		[BB["Marisa du'Paige"]] = { 3019, 4660 },
		[BB["Brainwashed Noble"]] = { 5967, 3902 },
		[BB["Foreman Thistlenettle"]] = { 1875 },
		[BB["Rhahk'Zor"]] = { 872, 5187 },
		[BB["Miner Johnson"]] = { 5443, 5444	},
		[BB["Sneed's Shredder"]] = { 2169, 1937, 7365	},
		[BB["Sneed"]] = { 5194, 5195 },
		[BB["Gilnid"]] = { 5199, 1156 },
		[BB["Captain Greenskin"]] = { 10403, 5200, 5201 },
		[BB["Edwin VanCleef"]] = { 5193, 5202, 10399, 5191, 2874, 3637 },
		[BB["Mr. Smite"]] = { 5192, 5196, 7230 },
		[BB["Cookie"]] = { 5197, 5198, 8490 },
		[L["Trash Mobs"]] = { 10400, 10401, 10402 }
	},
	[BZ["The Temple of Atal'Hakkar"]] = {
		[L["Spawn Of Hakkar"]] = {	10802, 10801 },
		[L["Troll Mini bosses"]] = { 10787, 10783, 10785, 10784, 10786, 10788, 20606, 20607, 20608 },
		[BB["Atal'alarion"]] = {	10800, 10798, 10799 },
		[BB["Dreamscythe"]] = { 12465, 12466, 12464, 10795, 10796, 10797, 12463, 12243	},
		[BB["Weaver"]] = {	12465, 12466, 12464, 10795, 10796, 10797, 12463, 12243 },
		[BB["Avatar of Hakkar"]] = { 12462, 10843, 10842, 10846, 10845, 10838, 10844, 10663 },
		[BB["Jammal'an the Prophet"]] = {	10806, 10808, 10807, 6212 },
		[BB["Ogom the Wretched"]] = { 10803, 10805, 10804 },
		[BB["Morphaz"]] = { 12465, 12466, 12464, 10795, 10796, 10797, 12463, 12243, 20022, 20085, 20025, 20019	},
		[BB["Hazzas"]] = {	12465, 12466, 12464, 10795, 10796, 10797, 12463, 12243 },
		[BB["Shade of Eranikus"]] = { 10847, 10833, 10829, 10828, 10837, 10835, 10836, 10454, 10455 },
		[L["Trash Mobs"]] = { 10630, 10629, 10632, 10631, 10633, 10634, 15733, 16216, 11318, 6181,
								10625, 10628, 10623, 10626, 10627, 10624 }
	},	
	[BZ["Maraudon"]] = {
		[BB["Kolk"] .. " (1st Khan)"] = { 17761 },
		[BB["Gelk"] .. " (2nd Khan)"] = { 17762 },
		[BB["Magra"] .. " (3rd Khan)"] = { 17763 },
		[BB["Maraudos"] .. " (4th Khan)"] = { 17764 },
		[BB["Veng"] .. " (5th Khan)"] = { 17765 },
		[BB["Noxxion"]] = { 17746, 17744, 17745, 17702 },
		[BB["Razorlash"]] = {	17750, 17748, 17749, 17751 },
		[BB["Lord Vyletongue"]] = {	17755, 17754, 17752, 17703 },
		[BB["Meshlok the Harvester"]] = { 17741, 17742, 17767 },
		[BB["Celebras the Cursed"]] = { 17739, 17740, 17738 },
		[BB["Landslide"]] = { 17736, 17734, 17737, 17943	},
		[BB["Tinkerer Gizlock"]] = { 17719, 17718, 17717 },
		[BB["Rotgrip"]] = { 17732, 17728, 17730 },
		[BB["Princess Theradras"]] = {	17780, 17715, 17714, 17711, 17707, 17713, 17766, 17710 }
	},
	[BZ["Zul'Farrak"]] = {	
		[BB["Antu'sul"]] = { 9640, 9641, 9639, 9379, 9372 },
		[BB["Theka the Martyr"]] = { 10660	},
		[BB["Witch Doctor Zum'rah"]] = { 18083, 18082	},
		[BB["Nekrum Gutchewer"]] = { 9471	},
		[BB["Shadowpriest Sezz'ziz"]] = {	9470, 9473, 9474, 9475 },
		[BB["Dustwraith"]] = { 12471 },
		[BB["Sergeant Bly"]] = {	8548 },
		[BB["Sandfury Executioner"]] = { 8444 },
		[BB["Hydromancer Velratha"]] = { 9234, 10661 },
		[BB["Gahz'rilla"]] = { 9469, 9467, 8707 },
		[BB["Chief Ukorz Sandscalp"]] = {	9479, 9476, 9478, 9477, 11086, 9372 },
		[BB["Zerillis"]] = { 12470 },
		[L["Trash Mobs"]] = { 9512, 9484,  862, 6440, 9243, 9523, 9238, 5616, 9511, 9481, 
								9480, 9482, 9483, 2040, }
	},
	[BZ["Razorfen Downs"]] = {	
		[BB["Tuten'kash"]] = { 10775, 10776, 10777 },
		[L["Henry Stern"]] = { 3831, 10841 },
		[BB["Mordresh Fire Eye"]] = { 10769, 10770, 10771 },
		[BB["Glutton"]] = { 10772, 10774 },
		[BB["Ragglesnout"]] = { 10768, 10758, 10767 },
		[BB["Amnennar the Coldbringer"]] = { 10762, 10765, 10764, 10763, 10761, 10420 },
		[BB["Plaguemaw the Rotting"]] = {	10760, 10766 },
		[L["Trash Mobs"]] = { 10574, 10581, 10578, 10583, 10582, 10584, 10571, 10573, 10570, 10567, 10572 }
	},
	[BZ["Uldaman"]] = {
		[L["Magregan Deepshadow"]] = { 4635 },
		[L["Tablet of Ryuneh"]] = { 4631	},
		[L["Krom Stoutarm Chest"]] = { 8027	},
		[L["Garrett Family Chest"]] = { 8026 },
		[BB["Digmaster Shovelphlange"]] = { 9375, 9378, 9382 },
		[BB["Baelog"]] = {	9399, 9400, 9401 },
		[L["Eric The Swift"]] = { 9394, 9398, 2459 },
		[L["Olaf"]] = { 9404, 9403, 1177	},
		[L["Baelog's Chest"]] = { 7740 },
		[L["Conspicuous Urn"]] = {	7671 },
		[BB["Revelosh"]] = { 9390, 9389, 9388, 9387, 7741 },
		[BB["Ironaya"]] = { 9407, 9408, 9409 },
		[BB["Obsidian Sentinel"]] = { 8053 },
		[BB["Ancient Stone Keeper"]] = { 9410, 9411 },
		[BB["Galgann Firehammer"]] = {	11310, 11311, 9412, 9419 },
		[L["Tablet of Will"]] = { 5824 },
		[L["Shadowforge Cache"]] = { 7669 },
		[BB["Grimlok"]] = { 9415, 9414, 9416, 7670 },
		[BB["Archaedas"]] = { 11118, 9418, 9413, 7672 },
		[L["Trash Mobs"]] = { 9397, 9431, 9429, 9420, 9406, 9428, 9430, 9396, 9432, 9393, 
								7666, 7673, 9384, 9392, 9424, 9465, 9383, 9425, 9386, 9427, 
								9423, 9391, 9381, 9426, 9422	}
	},
	[BZ["Scarlet Monastery"]] = {
		[BB["Houndmaster Loksey"]] = { 7756, 7710, 3456 },
		[BB["Arcanist Doan"]] = { 34227, 7712, 7711, 7714, 7713, 7146	},
		[BB["Herod"]] = { 7719, 7718, 10330, 7717, 23192 },
		[BB["High Inquisitor Fairbanks"]] = { 19507, 19508, 19509 },
		[BB["Scarlet Commander Mograine"]] = { 7724, 10330, 7723, 7726 },
		[BB["High Inquisitor Whitemane"]] = { 7720, 7721, 7722, 20976 },
		[BB["Interrogator Vishas"]] = { 7682, 7683	},
		[BB["Ironspine"]] = { 7686, 7687, 7688 },
		[BB["Azshir the Sleepless"]] = { 7709, 7731, 7708 },
		[BB["Fallen Champion"]] = { 7689, 7690, 7691 },
		[BB["Bloodmage Thalnos"]] = { 7684, 7685 },
		[L["Trash Mobs"]] = { 7728, 7755, 7727, 7760, 7754, 5819, 7759, 10328, 10332, 2262, 
								1992, 10333, 10331, 10329, 5756, 8226, 8225, 7761, 7786, 7753, 
								7752, 7736, 7730, 7758, 7757, 7787, 7729}
	},
	
	[BZ["Razorfen Kraul"]] = {	
		[L["Roogug"]] = {	6841 },
		[L["Aggem Thorncurse"]] = { 6681	},
		[BB["Death Speaker Jargba"]] = { 6682, 6685, 2816 },
		[L["Razorfen Spearhide"]] = { 6679 },
		[BB["Overlord Ramtusk"]] = { 6686, 6687	},
		[BB["Agathelos the Raging"]] = { 6690, 6691 },
		[BB["Blind Hunter"]] = { 6695, 6696, 6697 },
		[BB["Charlga Razorflank"]] = { 6693, 6692, 6694, 17008, 5793, 5792 },
		[BB["Earthcaller Halmgar"]] = { 6688, 6689	},
		[L["Trash Mobs"]] = { 2264, 1978, 1488, 4438, 2039,  776, 1727, 1975, 1976, 2549 },
	},
	[BZ["Blackrock Depths"]] = {	
		[L["Pyron"]] = { 14486 },
		[BB["Lord Roccor"]] = { 22234, 11632, 22397, 11631, 11630, 11813, 11811 },
		[BB["High Interrogator Gerstahn"]] = { 11626, 11624, 22240, 11625, 11140 },
		["Arena"] = { 11677, 11675, 11731, 11678, 11685, 11686, 11679, 11730, 11726, 22271, 
							11729, 11722, 11703, 22270, 22257, 22266, 11702, 11610, 11634, 11633, 
							11635, 11662, 11665, 11728, 11824	},
		[L["Theldren"]] = { 22330, 22305, 22317, 22318, 22047	},
		[BB["Houndmaster Grebmar"]] = { 11623, 11626, 11627, 11628, 11629 },
		[BB["Pyromancer Loregrain"]] = { 11747, 11749, 11750, 11748, 11207	},
		[L["The Vault"]] = { 11309, 22256, 11929, 11926, 22205, 22255, 11920, 11923, 22254, 11752, 
							11751, 11753 },
		[BB["Warder Stilgiss"]] = { 11782, 22241, 11783, 11784	},
		[BB["Verek"]] = { 22242, 11755	},
		[BB["Fineous Darkvire"]] = { 11839, 11841, 11842, 22223, 11840, 10999	},
		[BB["Lord Incendius"]] = { 11768, 11766, 11764, 11765, 11767, 19268, 21987, 11126	},
		[BB["Bael'Gar"]] = { 11807, 11802, 11805, 11803 },
		[BB["General Angerforge"]] = { 11821, 11820, 11810, 11817, 11816, 11464 },
		[BB["Golem Lord Argelmach"]] = { 11822, 11823, 11669, 11819, 21956, 11268, 11465 },
		[BB["Hurley Blackbreath"]] = {	11735, 18043, 22275, 18044, 11312 },
		[BB["Phalanx"]] = { 22212, 11745, 11744	},
		[BB["Ribbly Screwspigot"]] = { 11612, 2662, 2663, 11742, 11313 },
		[BB["Plugger Spazzring"]] = { 12793, 12791, 13483, 18653, 15759, 11602, 11325 },
		[BB["Ambassador Flamelash"]] = { 11808, 11812, 11814, 11832, 11809, 23320 },
		[BB["Panzor the Invincible"]] = { 22245, 11787, 11786, 11785	},
		[L["Summoner's Tomb"]] = { 11929, 11925, 11926, 11927, 11922, 11920, 11923, 11921 },
		[BB["Magmus"]] = {	11746, 11935, 22395, 22400, 22208 },
		[BB["Emperor Dagran Thaurissan"]] = { 11684, 11930, 11924, 22204, 22207, 11933, 11934, 11815, 11931, 11932,
								11928, 12033, 21524	},
		[BB["Princess Moira Bronzebeard"]] = { 12554, 12556, 12557, 12553 },
		[L["Trash Mobs"]] = { 12552, 12551, 12542, 12546, 12550, 12547, 12549, 12555, 12531, 12535, 
								12527, 12528, 12532, 15781, 15770, 16053, 16049, 16048, 18654, 18661, 
								11754, 11078, 18945, 11468, 11446	},
		[L["Plans"]] = { 11614, 11615	}
	},
	[BZ["Ragefire Chasm"]] = {	
		[BB["Taragaman the Hungerer"]] = { 14148, 14149, 14145, 14540 },
		[BB["Jergosh the Invoker"]] = { 14150, 14147, 14151	},
		[L["Zelemar the Wrathful"]] = { 24225 }
	},
	[BZ["Shadowfang Keep"]] = {	
		[BB["Deathsworn Captain"]] = {	6641, 6642 },
		[L["Rethilgore"]] = { 5254	},
		[L["Fel Steed"]] = {	6341, 932 },
		[BB["Razorclaw the Butcher"]] = { 6226, 6633, 1292 },
		[BB["Baron Silverlaine"]] = { 6321, 6323 },
		[BB["Commander Springvale"]] = { 3191, 6320 },
		[BB["Odo the Blindwatcher"]] = { 6318, 6319 },
		[BB["Fenrus the Devourer"]] = { 6340, 3230	},
		[BB["Arugal's Voidwalker"]] = { 5943	},
		[BB["Wolf Master Nandos"]] = {	6314, 3748 },
		[BB["Archmage Arugal"]] = {	6324, 6392, 6220 },
		[L["Quest Items"]] = { 24224, 6895, 6283 },
		[L["Trash Mobs"]] = { 2292, 1974, 1489, 1935, 1482, 2205, 1318, 2807, 1483, 3194, 1484 }
	},
	[BZ["Dire Maul (East)"]] = {
		[BB["Pusillin"]] = { 18267, 18261, 18249 },
		[BB["Zevrim Thornhoof"]] = { 18319, 18313, 18323, 18306, 18308 },
		[BB["Lethtendris"]] = { 18325, 18311, 18302, 18301, 18426 },
		[BB["Hydrospawn"]] = { 18322, 18317, 18324, 18307, 18305 },
		[BB["Pimgib"]] = {	18354 },
		[BB["Alzzin the Wildshaper"]] = {	18328, 18327, 18309, 18318, 18312, 18326, 18501, 18315, 18314, 18310, 18321 },
		[BB["Isalien"]] = { 22304, 22472, 22401, 22345, 22315, 22314, 21984, 22046 },
		[L["Trash Mobs"]] = { 18295, 18298, 18296, 18289 }
	},
	[BZ["Dire Maul (North)"]] = {
		[BB["Guard Mol'dar"]] = { 18496, 18497, 18494, 18493, 18498, 18268, 18450, 18451, 18458, 18459, 
									18464, 18462, 18463, 18460	},
		[BB["Stomper Kreeg"]] = { 18425, 18269, 18284	},
		[BB["Guard Fengus"]] = { 18450, 18451, 18458, 18459, 18464, 18462, 18463, 18460, 18266 },
		[BB["Knot Thimblejack's Cache"]] = { 18517, 18518, 18519, 18414, 18418, 18415, 18416, 18417, 18514, 18515, 
									18516, 18240, 18509, 18510, 18511, 18405, 18413, 18407, 18408, 18409, 
									18504, 18506, 18508	},
		[BB["Guard Slip'kik"]] = { 18496, 18497, 18494, 18493, 18498, 18450, 18451, 18458, 18459, 18464, 
									18462, 18463, 18460 },
		[BB["Captain Kromcrush"]] = { 18507, 18505, 18503, 18502 },
		[BB["King Gordok"]] = { 18526, 18525, 18527, 18524, 18521, 18522, 18523, 18520, 19258, 18780, 12727 },
		[BB["Cho'Rush the Observer"]] = { 18490, 18484, 18485, 18483 },
		[L["Tribute Run"]] = { 18538, 18495, 18532, 18528, 18530, 18533, 18529, 18500, 18537, 18531, 
									18534, 18499, 18475, 18478, 18477, 18476, 18479, 18480, 18481, 18482, 
									18655}
	},
	[BZ["Dire Maul (West)"]] = {
		[BB["Tendris Warpwood"]] = { 18390, 18393, 18353, 18352 },
		[BB["Illyanna Ravenoak"]] = { 18386, 18383, 18349, 18347 },
		[BB["Magister Kalendris"]] = { 18374, 18397, 18371, 18350, 18351, 22309 },
		[BB["Tsu'zee"]] = { 18387, 18346, 18345 },
		[BB["Immol'thar"]] = { 18389, 18385, 18377, 18391, 18394, 18379, 18384, 18381, 18370, 18372 },
		[BB["Lord Hel'nurath"]] = { 18757, 18754, 18756, 18755	},
		[BB["Prince Tortheldrin"]] = {	18382, 18373, 18375, 18378, 18380, 18395, 21525, 18336, 18392, 18396, 
								18376, 18388 },
		[L["Shen'dralar Provisioner"]] = { 18487 },
		[L["Trash Mobs"]] = { 18344, 18340, 18338 }
	},
	[BZ["Dire Maul"]] = {
		[L["Books"]] = { 18364, 18361, 18358, 18359, 18362, 18356, 18363, 18360, 18357, 18333, 18334, 18332, 18401 },
		[L["Trinkets"]] = { 18470, 18473, 18468, 18472, 18469, 18465, 18471, 18467, 18466, 18348 },
	},
	[BZ["Upper Blackrock Spire"]] = {	
		[BB["Pyroguard Emberseer"]] = { 12905, 12927, 12929, 12926, 17322, 21988, 16672 },
		[BB["Solakar Flamewreath"]] = { 12609, 12589, 12603, 12606, 18657, 18638, 16695 },
		[BB["Jed Runewatcher"]] = { 12604, 12930, 12605 },
		[BB["Goraluk Anvilcrack"]] = {	18047, 13502, 13498, 18048, 12837, 12794, 12834, 12790, 18779, 12727,
										21525, 12806, 12696 },
		[BB["Warchief Rend Blackhand"]] = { 12590, 22247, 18102, 12587, 12588, 18104, 12936, 12935, 18103, 16733, 
										12940, 12939, 12583, 12630 },
		[BB["Gyth"]] = { 12871, 12945, 12903, 12895, 22225, 12960, 12953, 12952, 13522, 16669 },
		[BB["The Beast"]] = { 12731, 12752, 12757, 12756, 12967, 12968, 12965, 22311, 12966, 12963,
										12964, 12709, 12969, 16729, 24101, 19227	},
		[BB["Lord Valthalak"]] = { 22337, 22302, 22342, 22343, 22340, 22339, 22335, 22336 },
		[BB["General Drakkisath"]] = {	12592, 22269, 22267, 13142, 13141, 13098, 22268, 22253, 12602, 15730,
						15047, 13519, 16688, 16700, 16690, 16706, 16721, 16674, 16666, 16730,
						16726, 16663},
		[L["Trash Mobs"]] = { 13260, 24102, 16247, 12607, 12219 }
	},
	[BZ["Stratholme"]] = {
		[BB["Skul"]] = { 13395, 13394, 13396 },
		[BB["Fras Siabi"]] = { 13171, 13172 },
		[BB["Hearthsinger Forresten"]] = { 13378, 13383, 13384, 13379, 16682 },
		[BB["The Unforgiven"]] = { 13409, 13404, 13405, 13408, 16717 },
		[BB["Timmy the Cruel"]] = { 13403, 13402, 13400, 13401, 16724 },
		[BB["Crimson Hammersmith"]] = { 18781, 12726, 13351, 12824 },
		[L["Plans"]] = { 12827, 12830 },
		[BB["Cannon Master Willey"]] = { 22405, 22407, 18721, 13381, 22403, 13382, 22404, 22406, 13380, 13377, 
									12839, 12783, 16708, 21524 },
		[BB["Archivist Galford"]] = { 13386, 18716, 13387, 13385, 22897, 12811, 14679, 16692	},
		[BB["Balnazzar"]] = { 13353, 14512, 14154, 18720, 13369, 13358, 13359, 18718, 12103, 13360, 
									13348, 18717, 16725, 13520, 13250 },
		[L["Sothos & Jarien"]] = { 22301, 22328, 22327, 22334, 22329, 21984, 22046	},
		[BB["Stonespine"]] = { 13397, 13954, 13399	},
		[BB["Baroness Anastari"]] = { 18730, 18728, 13534, 18729, 13535, 13537, 13538, 13539, 13514, 16704 },
		[BB["Black Guard Swordsmith"]] = { 18783, 12725, 13350, 12825 },
		[BB["Postmaster Malown"]] = { 13390, 13388, 13389, 13391, 13392 },
		[BB["Nerub'enkan"]] = { 18740, 18739, 13529, 18738, 13530, 13531, 13532, 13533, 13508, 16675 },
		[BB["Maleki the Pallid"]] = { 18734, 18735, 13524, 18737, 13525, 13526, 13528, 13527, 13509, 16691, 
									12833, 12796 },
		[BB["Magistrate Barthilas"]] = { 13376, 18727, 18726, 18722, 23198, 18725, 12382 },
		[BB["Ramstein the Gorger"]] = { 13374, 18723, 13373, 13515, 13372, 13375, 16737 },
		[BB["Baron Rivendare"]] = { 13505, 13335, 13340, 22412, 13346, 22409, 13344, 22410, 22411, 13345, 
									13368, 13361, 13349, 22408, 16687, 16699, 16694, 16709, 16719, 16668, 
									16678, 16732, 16728, 13251, 13246, 13249, 13243	},
		[L["Trash Mobs"]] = { 18743, 17061, 18745, 18744, 18736, 18742, 18741, 16249, 16248, 18658, 
									16052, 15777, 15768, 14495, 16697, 16702, 16685, 16714, 16681, 16671, 
									16736, 16723, 12811, 12735	}
	},
	[BZ["Lower Blackrock Spire"]] = {
		["Roughshod Pike"] = { 12812, 12631, 12699, 12533, 12740, 12741, 12345 },
		[BB["Highlord Omokk"]] = { 13170, 13169, 13168, 13166, 13167, 12336, 12534, 16670 },
		[BB["Spirestone Battle Lord"]] = { 13284, 13285 },
		[BB["Spirestone Lord Magus"]] = { 13282, 13283, 13261 },
		[BB["Shadow Hunter Vosh'gajin"]] = {	12626, 13257, 13255, 12651, 12653, 12654, 13352, 12821, 16712 },
		[BB["War Master Voone"]] = { 22231, 13179, 13177, 12582, 28972, 21524, 12335, 16676 },
		[BB["Mor Grayhoof"]] = {	22306, 22325, 22319, 22398, 22322, 21984, 22046 },
		[BB["Mother Smolderweb"]] = { 13244, 13213, 13183, 16715 },
		[BB["Crystal Fang"]] = {	13185, 13184, 13218 },
		[BB["Urok Doomhowl"]] = { 13258, 22232, 13259, 13178, 18784, 12725, 12712, 15867 },
		[BB["Quartermaster Zigris"]] = { 13253, 13252, 12835, 12798, 21955	},
		[BB["Gizrul the Slavener"]] = { 13206, 13208, 13205, 16718 },
		[BB["Halycon"]] = { 22313, 13210, 13211, 13212 },
		[BB["Overlord Wyrmthalak"]] = { 13143, 13162, 13164, 22321, 13163, 13148, 13161, 12337, 16679	},
		[BB["Bannok Grimaxe"]] = { 12634, 12637, 12621, 12838, 12784 },
		[BB["Spirestone Butcher"]] = { 12608, 13286 },
		[BB["Ghok Bashguud"]] = { 13203, 13198, 13204	},
		[BB["Burning Felguard"]] = { 13181, 13182 },
		[L["Trash Mobs"]] = { 14513, 14152, 13494, 16250, 16244, 15749, 15775, 12219, 21982	}
	},
	[BZ["Scholomance"]] = {
		[BB["Kirtonos the Herald"]] = { 13956, 13957, 13969, 13967, 13955, 13960, 14024, 13983, 16734 },
		[BB["Jandice Barov"]] = { 18689, 14543, 14545, 14548, 18690, 14541, 22394, 13725, 13523, 16701 },
		[BB["Rattlegore"]] = { 14538, 14539, 18686, 14537, 14531, 14528, 13873, 16711, 18782, 12726 },
		[BB["Death Knight Darkreaver"]] = { 18760, 18758, 18759, 18761, 18749	},
		[BB["Vectus"]] = {	14577, 18691 },
		[BB["Marduk Blackpool"]] = { 18692, 14576 },
		[BB["Ras Frostwhisper"]] = { 13314, 14340, 18693, 14503, 14502, 18694, 14522, 14525, 18695, 13952, 
							14487, 18696, 16689, 13521, 13626, 13986, 13984, 13982, 14002, 12736	},
		[BB["Kormok"]] = { 22303, 22326, 22331, 22332, 22333, 21984, 22046	},
		[BB["Instructor Malicia"]] = { 16710, 18681, 14633, 14626, 14629, 14631, 14632, 18682, 14637, 14638, 
							14640, 14636, 14641, 14612, 14616, 14615, 14614, 14611, 14621, 14620, 
							14622, 14624, 14623, 18684, 23201, 23200, 18683, 18680	},
		[BB["Doctor Theolen Krastinov"]] = {	16684, 18681, 14633, 14626, 14629, 14631, 14632, 18682, 14637, 14638, 
							14640, 14636, 14641, 14612, 14616, 14615, 14614, 14611, 14621, 14620, 
							14622, 14624, 14623, 18684, 23201, 23200, 18683, 18680, 13523},
		[BB["Lorekeeper Polkelt"]] = { 16705, 18681, 14633, 14626, 14629, 14631, 14632, 18682, 14637, 14638, 
							14640, 14636, 14641, 14612, 14616, 14615, 14614, 14611, 14621, 14620, 
							14622, 14624, 14623, 18684, 23201, 23200, 18683, 18680},
		[BB["The Ravenian"]] = { 16716, 18681, 14633, 14626, 14629, 14631, 14632, 18682, 14637, 14638, 
							14640, 14636, 14641, 14612, 14616, 14615, 14614, 14611, 14621, 14620, 
							14622, 14624, 14623, 18684, 23201, 23200, 18683, 18680	},
		[BB["Lord Alexei Barov"]] = { 16722, 18681, 14633, 14626, 14629, 14631, 14632, 18682, 14637, 14638, 
							14640, 14636, 14641, 14612, 14616, 14615, 14614, 14611, 14621, 14620, 
							14622, 14624, 14623, 18684, 23201, 23200, 18683, 18680 },
		[BB["Lady Illucia Barov"]] = {	18681, 14633, 14626, 14629, 14631, 14632, 18682, 14637, 14638, 14640, 
							14636, 14641, 14612, 14616, 14615, 14614, 14611, 14621, 14620, 14622, 
							14624, 14623, 18684, 23201, 23200, 18683, 18680},
		[BB["Darkmaster Gandling"]] = { 13937, 14514, 14153, 13398, 13944, 13950, 13951, 22433, 13964, 13953, 
							13938, 21525, 16698, 16686, 16693, 16720, 16677, 16707, 16731, 16727, 
							16667, 19276, 13501 },
		[L["Trash Mobs"]] = { 18697, 18698, 18699, 18700, 14536, 18702, 18701, 16254, 16255, 15773, 
							15776, 12753, 13920, 16705, 16684, 16685, 16710, 16716, 16722 }
	},
	
	-- BC 5-men
	-- ** Hellfire Peninsula: Hellfire Citadel **
	[BZ["Hellfire Ramparts"]] = {
		[BB["Watchkeeper Gargolmar"]] = {	24024, 24023, 24022, 24021, 24020, 23881 },
		[BB["Watchkeeper Gargolmar"] .. L[" (Heroic)"]] = { 29434, 30593, 30594, 30592, 27448, 27451, 27450, 27447, 27449, 23881	},
		[BB["Omor the Unscarred"]] = { 24090, 24091, 24073, 24096, 24094, 24069, 23886	},
		[BB["Omor the Unscarred"] .. L[" (Heroic)"]] = { 29434, 27466, 27462, 27467, 27478, 27539, 27906, 27464, 27895, 27477, 
											27463, 27476, 23886, 30593, 30594, 30592, 27465 },
		[L["Fel Iron Chest"]] = { 24150, 24083, 24063, 24046, 24064, 24045, 24154, 24151, 24044, 24155 },
		[L["Fel Iron Chest"] .. L[" (Heroic)"]] = { 29434, 29264, 32077, 29238, 29346, 27452, 27461, 27456, 27454, 27458, 
											27455, 27459, 27457, 30593, 30594, 30592, 27453, 27460 }
	},
	[BZ["The Blood Furnace"]] = {
		[BB["The Maker"]] = {	24388, 24387, 24385, 24386, 24384 },
		[BB["The Maker"] .. L[" (Heroic)"]] = { 29434, 30601, 30600, 30602, 27485, 27488, 27483, 27487, 27484 },
		[BB["Broggok"]] = { 24392, 24393, 24391, 24390, 24389 },
		[BB["Broggok"] .. L[" (Heroic)"]] = { 29434, 30601, 30600, 30602, 27848, 27492, 27489, 27491, 27490	},
		[BB["Keli'dan the Breaker"]] = { 24397, 24395, 24398, 24396, 24394	},
		[BB["Keli'dan the Breaker"] .. L[" (Heroic)"]] = { 29434, 32080, 29245, 29239, 29347, 27506, 27514, 27522, 27494, 27505, 
								27788, 27495, 28121, 30601, 30600, 30602, 28264, 27497, 27512, 27507, 33814 }
	},
	[BZ["The Shattered Halls"]] = {	
		[BB["Grand Warlock Nethekurse"]] = { 24312, 27519, 27517, 27521, 27520, 27518, 21525, 23735 },
		[BB["Grand Warlock Nethekurse"] .. L[" (Heroic)"]] = { 29434, 24312, 30548, 30547, 30546, 27519, 27517, 27521,
									27520, 27518, 23735, 25462, 21525	},
		[BB["Blood Guard Porung"] .. L[" (Heroic)"]] = { 29434, 30548, 30547, 30546, 30709, 30707, 30708, 30705, 30710 },
		[BB["Warbringer O'mrogg"]] = { 27525, 27868, 27524, 27526, 30829, 27802 },
		[BB["Warbringer O'mrogg"] .. L[" (Heroic)"]] = { 29434, 30548, 30547, 30546, 27525, 27868, 27524, 27526, 30829, 27802	},
		[BB["Warchief Kargath Bladefist"]] = { 27527, 27529, 27534, 27533, 27538, 27540, 23723, 27536, 27537, 27531, 
											27474, 27528, 27535	},
		[BB["Warchief Kargath Bladefist"] .. L[" (Heroic)"]] = { 29434, 29255, 29263, 29254, 29348, 27527, 27529, 27534, 27533, 27538, 
					27540, 23723, 33815, 30548, 30547, 30546, 27536, 27537, 27531, 27474, 27528, 27535	},
		[L["Trash Mobs"]] = { 22554 }
	},
	
	-- ** Zangarmarsh: Coiffang Reservoir **
	[BZ["The Slave Pens"]] = {	
		[BB["Mennu the Betrayer"]] = { 24359, 24357, 24360, 24356, 24361, 29674 },
		[BB["Mennu the Betrayer"] .. L[" (Heroic)"]] = {	29434, 30604, 30605, 30603, 27542, 27545, 27541, 27546, 27544, 27543, 29674 },
		[BB["Rokmar the Crackler"]] = { 24379, 24376, 24378, 24380, 24381 },
		[BB["Rokmar the Crackler"] .. L[" (Heroic)"]] = { 29434, 30604, 30605, 30603, 27550, 27547, 28124, 27549, 27548, 27551 },
		[BB["Quagmirran"]] = { 24362, 24365, 24366, 24363, 24364 },
		[BB["Quagmirran"] .. L[" (Heroic)"]] = { 29434, 29242, 30538, 32078, 29349, 27712, 27800, 28337, 27672, 27742, 
							33821, 30604, 30605, 30603, 27796, 27713, 27740, 27683, 27714, 27673, 27741 }
	},
	[BZ["The Underbog"]] = {
		[BB["Hungarfen"]] = { 24450, 24452, 24451, 24413, 27631 },
		[BB["Hungarfen"] .. L[" (Heroic)"]] = { 29434, 30606, 30607, 30608, 27746, 27745, 27743, 27748, 27744, 27747	},
		[BB["Ghaz'an"]] = { 24459, 24458, 24460, 24462, 24461 },
		[BB["Ghaz'an"] .. L[" (Heroic)"]] = { 29434, 30606, 30607, 30608, 27760, 27759, 27755, 27758, 27761, 27757 },
		[BB["Swamplord Musel'ek"]] = { 24454, 24455, 24457, 24456, 24453 },
		[BB["Swamplord Musel'ek"] .. L[" (Heroic)"]] = {	29434, 30606, 30607, 30608, 27764, 27763, 27765, 27766, 27762, 27767 },
		[BB["The Black Stalker"]] = { 24481, 24466, 24465, 24463, 24464, 24248 },
		[BB["The Black Stalker"] .. L[" (Heroic)"]] = { 29434, 29265, 30541, 32081, 29350, 27781, 27768, 27938, 27773, 27779, 
						27780, 27896, 27770, 30606, 30607, 30608, 27907, 27771, 27769, 27772, 24248, 33826 }
	},
	[BZ["The Steamvault"]] = {
		[BB["Hydromancer Thespia"]] = { 27789, 27787, 27783, 27784, 29673, 30828, 27508 },
		[BB["Hydromancer Thespia"] .. L[" (Heroic)"]] = { 29434, 30550, 30551, 30549, 27789, 27787, 27783, 27784, 29673, 30828, 27508 },
		[BB["Mekgineer Steamrigger"]] = { 27793, 27790, 27792, 27791, 27794, 23887	},
		[BB["Mekgineer Steamrigger"] .. L[" (Heroic)"]] = {	29434, 30550, 30551, 30549, 27793, 27790, 27792, 27791, 27794, 23887 },
		[BB["Warlord Kalithresh"]] = { 24313, 27804, 27799, 27795, 27806, 27805, 27738, 27737, 27801, 27510, 
										27874, 28203, 27475 },
		[BB["Warlord Kalithresh"] .. L[" (Heroic)"]] = {	29434, 30543, 29243, 29463, 29351, 27804, 27799, 27795, 27806, 27805, 
										31721, 33827, 24313, 30550, 30551, 30549, 27738, 27737, 27801, 27510, 
										27874, 28203, 27475 },
		[L["Trash Mobs"]] = { 24159, 22533, 24367, 24368 }
	},
	
	-- ** Terrokar Forest: Aunchindoun **
	[BZ["Mana-Tombs"]] = {	
		[BB["Pandemonius"]] = { 25941, 25942, 25940, 25943, 28166, 25939 },
		[BB["Pandemonius"] .. L[" (Heroic)"]] = { 29434, 30584, 30585, 30583, 27816, 27818, 27813, 27815, 27814, 27817 },
		[BB["Tavarok"]] = { 25945, 25946, 25947, 25952, 25944, 25950 },
		[BB["Tavarok"] .. L[" (Heroic)"]] = { 29434, 30584, 30585, 30583, 27824, 27821, 27825, 27826, 27823, 27822 },
		[BB["Nexus-Prince Shaffar"]] = { 25957, 25955, 25956, 25954, 25962, 25953, 22921, 28490	},
		[BB["Nexus-Prince Shaffar"] .. L[" (Heroic)"]] = { 29434, 29240, 30535, 29352, 32082, 27831, 27843, 27827, 27835, 27844, 
								27798, 33835, 28490, 30584, 30585, 30583, 27837, 27828, 28400, 27829, 
								27840, 27842, 22921 },
		[L["Yor (Heroic Summon)"]] = { 29434, 31919, 31920, 31921, 31922, 31923, 31924, 31554, 31562, 31570, 
								31578, 30584, 30585, 30583	},
		[L["Trash Mobs"]] = { 23615, 22543 },
	},
	[BZ["Auchenai Crypts"]] = {
		[BB["Shirrak the Dead Watcher"]] = {	27410, 27409, 27408, 26055, 25964 },
		[BB["Shirrak the Dead Watcher"] .. L[" (Heroic)"]] = {	29434, 30587, 30588, 30586, 27866, 27493, 27865, 27845, 27847, 27846 },
		[BB["Exarch Maladaar"]] = {	27411, 27415, 27414, 27413, 27416, 27412, 21525 },
		[BB["Exarch Maladaar"] .. L[" (Heroic)"]] = { 29434, 29354, 29257, 29244, 27867, 27871, 27869, 27523, 27872, 21525, 
										33836, 30587, 30588, 30586, 27870 },
		[L["Avatar of the Martyred"]] = { 27878, 28268, 27876, 27937, 27877, 27797 },
		[L["Trash Mobs"]] = { 23605, 22544 }
	},
	[BZ["Sethekk Halls"]] = {	
		[BB["Darkweaver Syth"]] = {	27919, 27914, 27915, 27918, 27917, 27916, 24160, 27633 },
		[BB["Darkweaver Syth"] .. L[" (Heroic)"]] = {	29434, 30553, 30554, 30552, 27919, 27914, 27915, 27918, 27917, 27916, 
										24160, 27633, 25461 },
		[BB["Talon King Ikiss"]] = { 27946, 27981, 27985, 27925, 27980, 27986, 27632, 27991, 27948, 27838, 
										27875, 27776, 27936 },
		[BB["Talon King Ikiss"] .. L[" (Heroic)"]] = { 29434, 29249, 29259, 32073, 29355, 27946, 27981, 27985, 27925, 27980, 
										27986, 27991, 30553, 30554, 30552, 27948, 27838, 27875, 27776, 27936, 
										27632, 33834 },
		[L["Anzu the Raven God (Heroic Summon)"]] = { 29434, 32768, 30553, 30554, 30552, 32769, 32778, 32779, 32781, 32780 },
		[L["Trash Mobs"]] = { 25731, 29669 }
	},
	[BZ["Shadow Labyrinth"]] = {	
		[BB["Ambassador Hellmaw"]] = { 27889, 27888, 27884, 27886, 27887, 27885 },
		[BB["Ambassador Hellmaw"] .. L[" (Heroic)"]] = { 29434, 30563, 30559, 30560, 27889, 27888, 27884, 27886, 27887, 27885 },
		[BB["Blackheart the Inciter"]] = { 27892, 27893, 28134, 27891, 27890, 25728, 30808, 27468 },
		[BB["Blackheart the Inciter"] .. L[" (Heroic)"]] = { 29434, 30563, 30559, 30560, 27892, 27893, 28134, 27891, 27890, 25728, 
									30808, 27468 },
		[BB["Grandmaster Vorpil"]] = { 27897, 27900, 27901, 27898, 21525, 30827, 27775	},
		[BB["Grandmaster Vorpil"] .. L[" (Heroic)"]] = { 29434, 30563, 30559, 30560, 27897, 27900, 27901, 27898, 21525, 30827, 27775 },
		[BB["Murmur"]] = { 24309, 27902, 27912, 27913, 27905, 27903, 27910, 27778, 28232, 28230, 
									27908, 27909, 27803	},
		[BB["Murmur"] .. L[" (Heroic)"]] = { 29434, 29241, 30532, 29357, 29261, 29353, 27902, 27912, 27913, 27905, 
								27903, 27910, 31722, 30563, 30559, 30560, 24309, 27778, 28232, 28230, 
								27908, 27909, 27803, 33840	},
		[L["Trash Mobs"]] = { 23607 }
	},
	   
	-- ** Tanaris: Caverns of Time **
	[BZ["Old Hillsbrad Foothills"]] = {	
		[BB["Lieutenant Drake"]] = { 27423, 27418, 27417, 27420, 27436 },
		[BB["Lieutenant Drake"] .. L[" (Heroic)"]] = { 29434, 30589, 30591, 30590, 28212, 28214, 28215, 28211, 28213, 28210 },
		[BB["Captain Skarloc"]] = {	27428, 27430, 27427, 27424, 27426, 21524, 22927 },
		[BB["Captain Skarloc"] .. L[" (Heroic)"]] = {	29434, 30589, 30591, 30590, 28218, 28220, 28219, 28221, 28217, 28216, 
									21524, 22927 },
		[BB["Epoch Hunter"]] = {	24173, 27433, 27434, 27440, 27432, 27431 },
		[BB["Epoch Hunter"] .. L[" (Heroic)"]] = { 29434, 29250, 29246, 29357, 30534, 30536, 27911, 28344, 28233, 27904, 
									28227, 28223, 28226, 28222, 30589, 30591, 30590, 24173, 28191, 28224, 
									28401, 28225, 33847	},
		[L["Trash Mobs"]] = { 25729 },
		[L["Thomas Yance"]] = { 25725 },
		[L["Aged Dalaran Wizard"]] = { 22539 }
	},
	[BZ["The Black Morass"]] = {	
		[BB["Chrono Lord Deja"]] = { 27988, 27994, 27995, 27993, 27996, 27987, 29675 },
		[BB["Chrono Lord Deja"] .. L[" (Heroic)"]] = { 29434, 30558, 30556, 30555, 27988, 27994, 27995, 27993, 27996, 27987, 29675 },
		[BB["Temporus"]] = { 28185, 28186, 28034, 28187, 28184, 28033 },
		[BB["Temporus"] .. L[" (Heroic)"]] = { 29434, 30558, 30556, 30555, 28185, 28186, 28034, 28187, 28184, 28033 },
		[BB["Aeonus"]] = {	28206, 28194, 28207, 28190, 28189, 28188, 28193, 27509, 27873, 28192, 
									27977, 27839 },
		[BB["Aeonus"] .. L[" (Heroic)"]] = { 29434, 30531, 29247, 29253, 29356, 28206, 28194, 28207, 28190, 28189, 
							28188, 33858, 30558, 30556, 30555, 28193, 27509, 27873, 28192, 27977, 27839 },
		[L["Trash Mobs"]] = { 25730 }
	},
	
	-- ** Netherstorm: Tempest Keep **
	[BZ["The Mechanar"]] = {	
		[L["Cache of the Legion"]] = { 29434, 28249, 28250, 28252, 28251, 28248	},
		[BB["Mechano-Lord Capacitus"]] = { 28256, 28255, 28254, 28257, 28253, 35582 },
		[BB["Mechano-Lord Capacitus"] .. L[" (Heroic)"]] = { 29434, 30565, 30566, 30564, 28256, 28255, 28254, 28257, 28253, 35582 },
		[BB["Nethermancer Sepethrea"]] = { 28262, 28259, 28260, 28263, 28258, 21524, 22920 },
		[BB["Nethermancer Sepethrea"] .. L[" (Heroic)"]] = { 29434, 30565, 30566, 30564, 28262, 28259, 28260, 28263, 28258, 21524, 22920},
		[BB["Pathaleon the Calculator"]] = {	28269, 28266, 28265, 28288, 27899, 28267, 28286, 21907, 31086, 28278, 
													28202, 28204, 28275, 28285 },
		[BB["Pathaleon the Calculator"] .. L[" (Heroic)"]] = {	29434, 29251, 32076, 30533, 29362, 28269, 28266, 28265, 28288, 27899, 
													28267, 28286, 21907, 30565, 30566, 30564, 28278, 28202, 28204, 28275, 
													28285, 33860, 31086 },
		[L["Trash Mobs"]] = { 22920, 21906 }
	},
	[BZ["The Botanica"]] = {	
		[BB["Commander Sarannis"]] = { 28301, 28304, 28306, 28296, 28311, 28769 },
		[BB["Commander Sarannis"] .. L[" (Heroic)"]] = {	29434, 30574, 30572, 30573, 28301, 28304, 28306, 28296, 28311 },
		[BB["High Botanist Freywinn"]] = { 28317, 28318, 28321, 28315, 28316, 23617, 21524, 31744 },
		[BB["High Botanist Freywinn"] .. L[" (Heroic)"]] = { 29434, 30574, 30572, 30573, 28317, 28318, 28321, 28315, 28316, 
												21524, 23617, 31744 },
		[BB["Thorngrin the Tender"]] = { 24310, 28324, 28327, 28323, 28322, 28325 },
		[BB["Thorngrin the Tender"] .. L[" (Heroic)"]] = { 29434, 30574, 30572, 30573, 24310, 28324, 28327, 28323, 28322, 28325 },
		[BB["Laj"]] = { 28328, 28338, 28340, 28339, 27739 },
		[BB["Laj"] .. L[" (Heroic)"]] = { 29434, 30574, 30572, 30573, 28328, 28338, 28340, 28339, 27739 },
		[BB["Warp Splinter"]] = { 24311, 28371, 28342, 28347, 28343, 28370, 28345, 28367, 28341, 31085, 
									28229, 28348, 28349, 28228, 28350 },
		[BB["Warp Splinter"] .. L[" (Heroic)"]] = { 29434, 29258, 29262, 32072, 29359, 24311, 28371, 28342, 28347, 28343, 
									28370, 28345, 28367, 28341, 30574, 30572, 30573, 28229, 28348, 28349, 
									28228, 28350, 31085, 33859	},
		[L["Trash Mobs"]] = { 24172 }
	},
	[BZ["The Arcatraz"]] = {	
		[BB["Zereketh the Unbound"]] = { 28373, 28374, 28384, 28375, 28372	},
		[BB["Zereketh the Unbound"] .. L[" (Heroic)"]] = { 29434, 30582, 30575, 30581, 28373, 28374, 28384, 28375, 28372 },
		[BB["Wrath-Scryer Soccothrates"]] = { 28396, 28398, 28394, 28393, 28397 },
		[BB["Wrath-Scryer Soccothrates"] .. L[" (Heroic)"]] = { 29434, 30582, 30575, 30581, 28396, 28398, 28394, 28393, 28397	},
		[BB["Dalliah the Doomsayer"]] = { 24308, 28391, 28390, 28387, 28392, 28386 },
		[BB["Dalliah the Doomsayer"] .. L[" (Heroic)"]] = {	29434, 30582, 30575, 30581, 24308, 28391, 28390, 28387, 28392, 28386 },
		[BB["Harbinger Skyriss"]] = { 28406, 28419, 28407, 28418, 28412, 28416, 28415, 28413, 28414, 28231, 
								28403, 28205 },
		[BB["Harbinger Skyriss"] .. L[" (Heroic)"]] = { 29434, 29241, 29248, 29252, 29360, 28406, 28419, 28407, 28418, 28412, 
						28416, 33861, 30582, 30575, 30581, 28415, 28413, 28414, 28231, 28403, 28205 },
		[L["Trash Mobs"]] = { 23606, 22556, 29672, 21905 }
	},
	
	-- ** Isle of Quel'Danas **
	[BZ["Magisters' Terrace"]] = {
		[BB["Selin Fireheart"]] = { 34702, 34697, 34698, 34701, 34700, 34699, 35275 },
		[BB["Selin Fireheart"] .. L[" (Heroic)"]] = { 29434, 34602, 34601, 34604, 34603, 34702, 34697, 34698, 34701, 34700, 
									34699, 35275 },
		[BB["Vexallus"]] = { 34708, 34705, 34707, 34704, 34706, 34703 },
		[BB["Vexallus"] .. L[" (Heroic)"]] = { 29434, 34607, 34605, 34606, 34608, 34708, 34705, 34707, 34704, 34706, 34703 },
		[BB["Priestess Delrissa"]] = { 34792, 34788, 34791, 34789, 34790, 34783, 35756, 35275 },
		[BB["Priestess Delrissa"] .. L[" (Heroic)"]] = { 29434, 34473, 34471, 34470, 34472, 34792, 34788, 34791, 34789, 34790, 
									34783, 35756, 35275 },
		[BB["Kael'thas Sunstrider"]] = { 34810, 34808, 34809, 34799, 34807, 34625, 35311, 34793, 34796, 34795, 
									34798, 34794, 34797, 35504, 35304, 34157, 35487, 35488, 35489 },
		[BB["Kael'thas Sunstrider"] .. L[" (Heroic)"]] = { 29434, 34610, 34613, 34614, 34615, 34612, 34611, 34609, 34616, 34810, 
									34808, 34809, 34799, 34807, 34625, 35513, 34793, 34796, 34795, 34798, 
									34794, 34797, 35504, 35311, 35304 },
		[L["Trash Mobs"]] = { 35516 }
	},

	-- ** BC 10-men **
	[BZ["Karazhan"]] = {
		[BB["Attumen the Huntsman"]] = {	28477, 28507, 28508, 28453, 28506, 28503, 28454, 28502, 28505, 29434,
								28509, 28510, 28504, 30480, 23809	},
		[BB["Moroes"]] = {		28529, 28570, 28565, 28545, 28567, 28566, 28569, 29434, 28530, 28528,
								28525, 28568, 28524, 22559 },
		[BB["Hyakiss the Lurker"]] = { 30675, 30676, 30677, 30678	},
		[BB["Rokad the Ravager"]] = { 30684, 30685, 30686, 30687 },
		[BB["Shadikith the Glider"]] = { 30680, 30681, 30682, 30683 },
		[BB["Maiden of Virtue"]] = { 28511, 28515, 28517, 28514, 28521, 28520, 28519, 28512, 28518, 29434, 
								28516, 28523, 28522 },
		[L["Opera (Shared Drops)"]] = { 29434, 28594, 28591, 28589, 28593, 28590, 28592 },
		[BB["The Crone"]] = { 28586, 28585, 28587, 28588	},
		[BB["Romulo & Julianne"]] = { 28578, 28579, 28572, 28573 },
		[BB["The Big Bad Wolf"]] = { 28582, 28583, 28584, 28581 },
		[BB["The Curator"]] = { 28612, 28647, 28631, 28621, 28649, 28633, 29434, 29757, 29758, 29756 },
		[BB["Terestian Illhoof"]] = { 28660, 28653, 28652, 28654, 28655, 28656, 28662, 29434, 28661, 28785, 
								28657, 28658, 28659, 22561	},
		[BB["Shade of Aran"]] = { 28672, 28726, 28670, 28663, 28669, 28671, 28666, 29434, 23933, 28674, 
								28675, 28727, 28728, 28673, 22560 },
		[BB["Netherspite"]] = { 28744, 28742, 28732, 28741, 28735, 28740, 28743, 28733, 29434, 28731, 
								28730, 28734, 28729 },
		[BB["Chess Event"]] = { 28756, 28755, 28750, 28752, 28751, 28746, 28748, 28747, 29434, 28745, 
								28753, 28749, 28754 },
		[BB["Nightbane"]] = {	28602, 28600, 28601, 28599, 28610, 28597, 28608, 29434, 31751, 24139, 
								28609, 28603, 28604, 28611, 28606 },
		[BB["Prince Malchezaar"]] = { 28765, 28766, 28764, 28762, 28763, 28757, 28770, 28768, 28767, 28773, 
								28771, 28772, 29434, 29760, 29761, 29759 },
		[L["Trash Mobs"]] = { 30642, 30668, 30673, 30644, 30674, 30643, 30641, 23857, 23864, 23862, 
								23865, 21882, 30666, 30667, 21903, 21904, 22545	}
	},
	[BZ["Zul'Aman"]] = {	
		[BB["Nalorakk"]] = { 29434, 33203, 33285, 33211, 33206, 33327, 33191, 33640, 33307 },
		[BB["Akil'zon"]] = { 29434, 33286, 33215, 33216, 33281, 33293, 33214, 33283, 33307 },
		[BB["Jan'alai"]] = { 29434, 33357, 33356, 33329, 33328, 33354, 33326, 33332, 33307 },
		[BB["Halazzi"]] = { 29434, 33317, 33300, 33322, 33533, 33299, 33303, 33297, 33307	},
		[BB["Hex Lord Malacrass"]] = { 29434, 33592, 33453, 33463, 33432, 33464, 33421, 33446, 33307, 33829, 
								34029, 33828, 33389, 33298, 33388, 33465 },
		[BB["Zul'jin"]] = { 29434, 33471, 33479, 33469, 33473, 33466, 33830, 33831, 33307, 33467, 
								33478, 33476, 33468, 33474, 33102 },
		[L["Timed Chest"]] = {	33590, 33591, 33489, 33480, 33483, 33971, 33805, 33481, 33497, 33500, 
							33496, 33499, 33498, 33495, 33493, 33492, 33490, 33494, 33491, 33809 },
		[L["Trash Mobs"]] = { 33993, 33865, 33930, 33932, 33931, 33933 }
	},

	-- ** BC 25-men **
	-- ** T4 raid dungeons **
	[BZ["Gruul's Lair"]] = {	
		[BB["High King Maulgar"]] = { 28797, 28799, 28796, 28801, 28795, 28800, 29763, 29764, 29762 },
		[BB["Gruul the Dragonkiller"]] = { 28804, 28803, 28828, 28827, 28810, 28824, 28822, 28823, 28830, 31750, 
								29766, 29767, 29765, 28802, 28794, 28825, 28826	}
	},
	[BZ["Magtheridon's Lair"]] = {	
		[BB["Magtheridon"]] = { 28777, 28780, 28776, 28778, 28775, 28779, 28789, 28781, 28774, 28782, 
								29458, 28783, 29754, 29753, 29755, 32385, 28791, 28790, 28793, 28792, 34845, 34846 }
	},
	
	-- ** T5 raid dungeons **
	[BZ["Serpentshrine Cavern"]] = {	
		[BB["Hydross the Unstable"]] = { 30056, 32516, 30050, 30055, 30047, 30054, 30048, 30053, 30052, 33055, 
								30664, 30629, 30049, 30051	},
		[BB["The Lurker Below"]] = { 30064, 30067, 30062, 30060, 30066, 30065, 30057, 30059, 30061, 33054, 
								30665, 30063, 30058	},
		[BB["Leotheras the Blind"]] = { 30092, 30097, 30091, 30096, 30627, 30095, 30239, 30240, 30241	},
		[BB["Fathom-Lord Karathress"]] = { 30100, 30101, 30099, 30663, 30626, 30090, 30245, 30246, 30247	},
		[BB["Morogrim Tidewalker"]] = { 30098, 30079, 30075, 30085, 30068, 30084, 30081, 30008, 30083, 33058, 
								30720, 30082, 30080 },
		[BB["Lady Vashj"]] = { 30107, 30111, 30106, 30104, 30102, 30112, 30109, 30110, 30621, 30103, 
								30108, 30105, 30242, 30243, 30244, 29906 },
		[L["Trash Mobs"]] = {	30027, 30022, 30620, 30023, 30021, 30025, 30324, 30322, 30323, 30321, 
								30280, 30282, 30283, 30281, 30308, 30304, 30305, 30307, 30306, 30301, 
								30303, 30302, 30183, 32897 }
	},
	[BZ["The Eye"]] = {	
		[BB["Al'ar"]] = { 29925, 29918, 29947, 29921, 29922, 29920, 30448, 30447, 29923, 32944, 
								29948, 29924, 29949 },
		[BB["Void Reaver"]] = { 29986, 29984, 29985, 29983, 32515, 30619, 30450, 30248, 30249, 30250 },
		[BB["High Astromancer Solarian"]] = { 29977, 29972, 29966, 29976, 29951, 29965, 29950, 32267, 30446, 30449, 
								29962, 29981, 29982 },
		[BB["Kael'thas Sunstrider"]] = { 29992, 29989, 29994, 29990, 29987, 29995, 29991, 29998, 29997, 29993, 
								29996, 29988, 30236, 30237, 30238, 32458, 32405, 30018, 30017, 30007, 
								30015, 29905 },
		[L["Trash Mobs"]] = { 30024, 30020, 30029, 30026, 30030, 30028, 30324, 30322, 30323, 30321, 
								30280, 30282, 30283, 30281, 30308, 30304, 30305, 30307, 30306, 30301, 
								30303, 30302, 30183, 32897	},
		[L["Legendaries"]] = {	30312, 30311, 30317, 30316, 30313, 30314, 30318, 30319 }
	},
	
	-- ** T6 raid dungeons **
	[BZ["Hyjal Summit"]] = {
		[BB["Rage Winterchill"]] = { 30871, 30870, 30863, 30868, 30864, 30869, 30873, 30866, 30862, 30861, 
								30865, 30872, 32459 },
		[BB["Anetheron"]] = { 30884, 30888, 30885, 30879, 30886, 30887, 30880, 30878, 30874, 30881, 
								30883, 30882 },
		[BB["Kaz'rogal"]] = { 30895, 30916, 30894, 30917, 30914, 30891, 30892, 30919, 30893, 30915, 
								30918, 30889 },
		[BB["Azgalor"]] = { 30899, 30898, 30900, 30896, 30897, 30901, 31092, 31094, 31093	},
		[BB["Archimonde"]] = { 30913, 30912, 30905, 30907, 30904, 30903, 30911, 30910, 30902, 30908, 
								30909, 30906, 31097, 31095, 31096 },
		[L["Trash Mobs"]] = { 32590, 34010, 32609, 32592, 32591, 32589, 34009, 32946, 32945, 32428, 
								32897, 32285, 32296, 32303, 32295, 32298, 32297, 32289, 32307 } 
	},
	[BZ["Black Temple"]] = {	
		[BB["High Warlord Naj'entus"]] = { 32239, 32240, 32377, 32241, 32234, 32242, 32232, 32243, 32245, 32238, 
								32247, 32237, 32236, 32248	},
		[BB["Supremus"]] = { 32256, 32252, 32259, 32251, 32258, 32250, 32260, 32261, 32257, 32254, 
								32262, 32255, 32253 },
		[BB["Teron Gorefiend"]] = { 32323, 32329, 32327, 32324, 32328, 32510, 32280, 32512, 32330, 32348, 
								32326, 32325 },
		[BB["Gurtogg Bloodboil"]] = { 32337, 32338, 32340, 32339, 32334, 32342, 32333, 32341, 32335, 32501, 
								32269, 32344, 32343 },
		[BB["Shade of Akama"]] = { 32273, 32270, 32513, 32265, 32271, 32264, 32275, 32276, 32279, 32278, 
								32263, 32268, 32266, 32361	},
		["Essence of Souls"] = { 32353, 32351, 32347, 32352, 32517, 32346, 32354, 32345, 32349, 32362, 
								32350, 32332, 32363 },
		[BB["Mother Shahraz"]] = { 32367, 32366, 32365, 32370, 32368, 32369, 31101, 31103, 31102 },
		[BB["Illidari Council"]] = { 32331, 32519, 32518, 32376, 32373, 32505, 31098, 31100, 31099	},
		[BB["Illidan Stormrage"]] = { 32524, 32525, 32235, 32521, 32497, 32483, 32496, 32837, 32838, 31089, 
								31091, 31090, 32471, 32500, 32374, 32375, 32336	},
		[L["Trash Mobs"]] = { 32590, 34012, 32609, 32593, 32592, 32608, 32606, 32591, 32589, 
								32526, 32528, 32527, 34009, 32943, 34011, 32228, 32231, 32229, 32249, 
								32230, 32227, 32428, 32897	},
		[L["Patterns"]] = { 32738, 32739, 32736, 32737, 32748, 32744, 32750, 32751, 32749, 32745, 
								32746, 32747, 32754, 32755, 32753, 32752 }
	},
	[BZ["Sunwell Plateau"]] = {
		[BB["Kalecgos"]] = { 34170, 34386, 34169, 34384, 34168, 34167, 34382, 34166, 34165, 34164, 
								34848, 34851, 34852 },
		[BB["Brutallus"]] = { 34181, 34180, 34381, 34178, 34177, 34179, 34176, 34853, 34854, 34855 },
		[BB["Felmyst"]] = { 34188, 34385, 34186, 34383, 34184, 34352, 34185, 34182, 
								34856, 34857, 34858 },
		[BB["The Eredar Twins"]] = { 34205, 34190, 34210, 34202, 34393, 34209, 34195, 34392, 34194, 34208, 
								34390, 34192, 34388, 35290, 35291, 35292, 34204, 34189, 34206, 34197, 
								34199, 34203, 34198, 34196, 34391, 34193, 34389 },
		[BB["M'uru"]] = { 34233, 34399, 34212, 34398, 34211, 34397, 34234, 34408, 34229, 34396, 
								34228, 34215, 34394, 34240, 34216, 34395, 34213, 34230, 35282, 35283, 
								35284, 34427, 34430, 34429, 34428, 34214, 34231, 34232 },
		[BB["Kil'jaeden"]] = { 34241, 34242, 34339, 34405, 34340, 34342, 34406, 34344, 34244, 34404, 
								34245, 34403, 34333, 34332, 34402, 34343, 34243, 34401, 34345, 34400, 
								34341, 34334, 34329, 34247, 34335, 34331, 34336, 34337 },
		[L["Trash Mobs"]] = { 34233, 34351, 34407, 34183, 34350, 34409, 35733, 34346, 34349, 34348, 
								34347, 34664, 35273, 32228, 32231, 32229, 32249, 32230, 32227,
								35208, 35210, 35209, 35211 },
		[L["Patterns"] .. " & " .. L["Plans"]] = { 35212, 35216, 35213, 35217, 35214, 35218, 35215, 35219, 35204, 35206, 
								35205, 35207, 35198, 35201, 35199, 35202, 35200, 35203, 35186, 35187, 
								35189, 35190, 35191, 35192, 35193, 35194, 35195, 35196, 35197 }
	},	

	-- ** Reputations **
	
	-- FACTION_STANDING_LABEL1 = "Hated"			Constants taken from WoWUI's GlobalStrings.lua
	-- FACTION_STANDING_LABEL2 = "Hostile"
	-- FACTION_STANDING_LABEL3 = "Unfriendly"
	-- FACTION_STANDING_LABEL4 = "Neutral"
	-- FACTION_STANDING_LABEL5 = "Friendly"
	-- FACTION_STANDING_LABEL6 = "Honored"
	-- FACTION_STANDING_LABEL7 = "Revered"
	-- FACTION_STANDING_LABEL8 = "Exalted"
	
	-- ** Wow **
	[BF["Argent Dawn"]] = {	
		[L["Token Hand-Ins"]] = { 22689, 22690, 22681, 22680, 22688, 22679, 22638, 22523, 22667, 22668, 
								22657, 22659, 22678, 22656, 22636, 22524 },
		[FACTION_STANDING_LABEL5] = { 13724 },
		[FACTION_STANDING_LABEL6] = { 13482, 19203, 19446, 19442, 19328, 19216	},
		[FACTION_STANDING_LABEL7] = { 18171, 18169, 18170, 18172, 18173, 19205, 19447, 19329, 19217, 13810, 13813 },
		[FACTION_STANDING_LABEL8] = { 18182 }
	},	
	[BF["Brood of Nozdormu"]] = {	
		[FACTION_STANDING_LABEL4] = { 21201, 21206, 21196 },
		[FACTION_STANDING_LABEL5] = { 21202, 21207, 21197 },
		[FACTION_STANDING_LABEL6] = { 21203, 21208, 21198	},
		[FACTION_STANDING_LABEL7] = { 21204, 21209, 21199	},
		[FACTION_STANDING_LABEL8] = { 21205, 21210, 21200	}
	},	
	[BF["Bloodsail Buccaneers"]] = {	
		[FACTION_STANDING_LABEL4] = { 22742, 22743, 22745, 22744 },
		[FACTION_STANDING_LABEL5] = { 12185 }
	},	
	[BF["Cenarion Circle"]] = {	
		[FACTION_STANDING_LABEL5] = { 22209, 22768, 20732, 22769, 20509, 20506, 22772, 22310, 20802, 20800, 
								21515, 21187, 21178, 21179, 20801, 21508 },
		[FACTION_STANDING_LABEL6] = { 22767, 22214, 20733, 22770, 20510, 20507, 22773, 21183, 21182, 21181 },
		[FACTION_STANDING_LABEL7] = { 22766, 22219, 22771, 20511, 20508, 22683, 22312, 22774, 21186, 21184, 
								21189, 21185 },
		[FACTION_STANDING_LABEL8] = { 22221, 20382, 21190, 21180, 21188 }
	},	
	[BF["Darkmoon Faire"]] = {	
		[L["Items"]] = { 19491, 19426, 19296, 19297, 19298, 19291, 19293, 22729, 19292, 19295, 
								19182, 19303, 19302, 11026, 11027, 19450 },
		[L["Beasts Deck"]] = { 19288 },
		[L["Elementals Deck"]] = { 19289 },
		[L["Warlords Deck"]] = { 19287 },
		[L["Portals Deck"]] = { 19290 },
		[L["Furies Deck"]] = { 31858 },
		[L["Storms Deck"]] = { 31857 },
		[L["Blessings Deck"]] = { 31856 },
		[L["Lunacy Deck"]] = { 31859 }
	},	
	[BF["The Defilers"]] = {	
		[FACTION_STANDING_LABEL8] = { 20131 }
	},	
	[BF["Frostwolf Clan"]] = {	
		[L["Quest rewards"]] = { 20648, 19106, 19108, 19107 },
		[FACTION_STANDING_LABEL4] = { 17690 },
		[FACTION_STANDING_LABEL5] = { 17905 },
		[FACTION_STANDING_LABEL6] = { 17906 },
		[FACTION_STANDING_LABEL7] = { 17907 },
		[FACTION_STANDING_LABEL8] = { 17908, 17909 }
	},	
	[BF["Gelkis Clan Centaur"]] = {	
		[L["Quest rewards"]] = { 6773, 6774 }
	},	
	[BF["The League of Arathor"]] = {	
		[FACTION_STANDING_LABEL8] = { 20132 }
	},	
	[BF["Magram Clan Centaur"]] = {	
		[FACTION_STANDING_LABEL5] = { 6789, 6788 }
	},
	[BF["Stormpike Guard"]] = {	
		[L["Quest rewards"]] = { 20648, 19106, 19108, 19107 },
		[FACTION_STANDING_LABEL4] = { 17691 },
		[FACTION_STANDING_LABEL5] = { 17900 },
		[FACTION_STANDING_LABEL6] = { 17901 },
		[FACTION_STANDING_LABEL7] = { 17902 },
		[FACTION_STANDING_LABEL8] = { 17903, 17904 }
	},
	[BF["Thorium Brotherhood"]] = {	
		[FACTION_STANDING_LABEL5] = { 17051, 20761, 19444, 17023, 17022, 17018 },
		[FACTION_STANDING_LABEL6] = { 17060, 17059, 17049, 19206, 19448, 17025, 19330, 17017, 19219 },
		[FACTION_STANDING_LABEL7] = { 18592, 17052, 17053, 19209, 19208, 19207, 19449, 19331, 19332, 19333, 19220 },
		[FACTION_STANDING_LABEL8] = { 19211, 20040, 19210, 19212 }
	},
	[BF["Timbermaw Hold"]] = {	
		[FACTION_STANDING_LABEL5] = { 13484, 22392, 20254, 20253 },
		[FACTION_STANDING_LABEL6] = { 16768, 16769, 19202, 19445, 19326, 19215 },
		[FACTION_STANDING_LABEL7] = { 19204, 19327, 19218 },
		[FACTION_STANDING_LABEL8] = { 21326 }
	},
	[BF["Hydraxian Waterlords"]] = {	
		[FACTION_STANDING_LABEL6] = { 18399, 18398, 17333 },
		[FACTION_STANDING_LABEL7] = { 22754 }
	},
	[BF["Wintersaber Trainers"]] = {	
		[FACTION_STANDING_LABEL8] = { 13086 }
	},
	[BF["Zandalar Tribe"]] = {	
		[FACTION_STANDING_LABEL5] = { 20012, 19778, 19781, 20757, 20001, 19771, 19766 },
		[FACTION_STANDING_LABEL6] = { 20014, 19777, 19780, 20756, 20000, 19773, 19770, 19765, 20031 },
		[FACTION_STANDING_LABEL7] = { 20080, 20079, 20081, 20011, 19776, 19779, 19772, 19769, 19764 },
		[FACTION_STANDING_LABEL8] = { 20077, 20076, 20078, 20013 }
	},
	
	-- ** BC **
	[BF["The Aldor"]] = {	
		[FACTION_STANDING_LABEL5] = { 23149, 23601, 30842 },
		[FACTION_STANDING_LABEL6] = { 29129, 28881, 28878, 28885, 28882, 23145, 23603, 29704, 29693, 30843, 24293 },
		[FACTION_STANDING_LABEL7] = { 29127, 29128, 29130, 24177, 23604, 29703, 29691, 25721 },
		[FACTION_STANDING_LABEL8] = { 29123, 29124, 28886, 28887, 28888, 28889, 23602, 29702, 29689, 24295, 
								30844, 31779 }
	},
	[BF["Ashtongue Deathsworn"]] = {	
		[FACTION_STANDING_LABEL5] = { 32444, 32442, 32436, 32435, 32430, 32429, 32440, 32438 },
		[FACTION_STANDING_LABEL6] = { 32443, 32441, 32433, 32434, 32431, 32432, 32447, 32439, 32437	},
		[FACTION_STANDING_LABEL8] = { 32486, 32487, 32488, 32489, 32490, 32492, 32491, 32493, 32485 }
	},	
	[BF["Cenarion Expedition"]] = {	
		[FACTION_STANDING_LABEL5] = { 25737, 24417, 23814, 24429 },
		[FACTION_STANDING_LABEL6] = { 25838, 25836, 25835, 25735, 25736, 29194, 25869, 32070, 23618, 28632, 
								25526, 29720, 30623 },
		[FACTION_STANDING_LABEL7] = { 31392, 31391, 29174, 29173, 31949, 24183, 29192, 22918, 28271	},
		[FACTION_STANDING_LABEL8] = { 33999, 29170, 29172, 29171, 31390, 31402, 33149, 31356, 22922, 29721, 31804 }
	},	
	[BF["The Consortium"]] = {	
		[FACTION_STANDING_LABEL5] = { 25732, 28274, 23146, 23136 },
		[FACTION_STANDING_LABEL6] = { 29457, 29456, 29118, 25733, 23134, 23155, 23150, 22552, 25908, 25902, 24314 },
		[FACTION_STANDING_LABEL7] = { 29117, 29116, 29115, 24178, 25734, 22535, 23874, 25903, 33156, 33305 },
		[FACTION_STANDING_LABEL8] = { 29122, 29119, 29121, 33622, 31776 }
	},	
	[BF["Honor Hold"]] = {	
		[FACTION_STANDING_LABEL5] = { 29213, 23142, 22531, 24007, 24008 },
		[FACTION_STANDING_LABEL6] = { 25826, 25825, 29214, 29215, 29196, 25870, 22905, 29719, 30622	},
		[FACTION_STANDING_LABEL7] = { 29169, 29166, 32883, 24180, 29189, 22547, 34218 },
		[FACTION_STANDING_LABEL8] = { 29153, 29156, 29151, 33150, 23619, 29722, 23999 }
	},	
	[BF["Keepers of Time"]] = {	
		[FACTION_STANDING_LABEL6] = { 29198, 28272, 22536, 25910, 33160, 29713, 30635 },
		[FACTION_STANDING_LABEL7] = { 29184, 29185, 24181, 24174, 29186, 33158	},
		[FACTION_STANDING_LABEL8] = { 29183, 29181, 29182, 33152, 31355, 31777 }
	},	
	[BF["Kurenai"]] = {	
		[FACTION_STANDING_LABEL5] = { 29217 },
		[FACTION_STANDING_LABEL6] = { 29144, 29219, 34175, 34173, 30444 },
		[FACTION_STANDING_LABEL7] = { 29148, 29142, 29146, 29218, 30443 },
		[FACTION_STANDING_LABEL8] = { 29227, 29229, 29230, 29231, 31830, 31832, 31834, 31836, 29140, 29136, 
								29138, 31774 }
	},	
	[BF["Lower City"]] = {	
		[FACTION_STANDING_LABEL5] = { 23138},
		[FACTION_STANDING_LABEL6] = { 29199, 22538, 30833, 30633 },
		[FACTION_STANDING_LABEL7] = { 30836, 30835, 30841, 24179, 24175, 30846, 22910, 33157, 34200	},
		[FACTION_STANDING_LABEL8] = { 30834, 30832, 30830, 33148, 31357, 31778	}
	},	
	[BF["The Mag'har"]] = {	
		[FACTION_STANDING_LABEL5] = { 25741 },
		[FACTION_STANDING_LABEL6] = { 29143, 25742, 34174, 34172, 29664 },
		[FACTION_STANDING_LABEL7] = { 29147, 29141, 29145, 25743, 22917 },
		[FACTION_STANDING_LABEL8] = { 29102, 29104, 29105, 29103, 31829, 31831, 31833, 31835, 29139, 29135, 
							29137, 31773 }
	},
	[BF["Netherwing"]] = {	
		[FACTION_STANDING_LABEL5] = { 32694 },
		[FACTION_STANDING_LABEL6] = { 32695, 32863 },
		[FACTION_STANDING_LABEL7] = { 32864 },
		[FACTION_STANDING_LABEL8] = { 32858, 32859, 32857, 32860, 32861, 32862 }
	},
	[BF["Ogri'la"]] = {	
		[FACTION_STANDING_LABEL5] = { 32910, 32909 },
		[FACTION_STANDING_LABEL6] = { 32784, 32783 },
		[FACTION_STANDING_LABEL7] = { 32653, 32654, 32652, 32650 },
		[FACTION_STANDING_LABEL8] = { 32647, 32648, 32651, 32645, 32828 }
	},
	[BF["The Scale of the Sands"]] = {	
		[FACTION_STANDING_LABEL5] = { 29298, 29294, 29302, 29307, 32274, 32283, 32277, 32282, 32284, 32281,
							32288, 32286, 32287, 32290, 32293, 32291, 32294 },
		[FACTION_STANDING_LABEL6] = { 29299, 29295, 29303, 29306, 35763, 32306, 32305, 32304, 35762, 32299, 
							32301, 32300, 32311, 35765, 32312, 32310, 35764, 31737, 31735 },
		[FACTION_STANDING_LABEL7] = { 29300, 29296, 29304, 29308, 32292, 32308, 32309, 32302 },
		[FACTION_STANDING_LABEL8] = { 29301, 29297, 29305, 29309 }
	},
	[BF["The Scryers"]] = {	
		[FACTION_STANDING_LABEL5] = { 23133, 23597 },
		[FACTION_STANDING_LABEL6] = { 28907, 28908, 28904, 28903, 23143, 23598, 29701, 29682, 24292 },
		[FACTION_STANDING_LABEL7] = { 29131, 29134, 29132, 29133, 24176, 22908, 23599, 29700, 29684, 25722 },
		[FACTION_STANDING_LABEL8] = { 29126, 29125, 28910, 28911, 28912, 28909, 23600, 29698, 29677, 24294, 31780 }
	},
	[BF["The Sha'tar"]] = {
		[FACTION_STANDING_LABEL5] =  { 25904 },
		[FACTION_STANDING_LABEL6] = { 30826, 29195, 28273, 33155, 29717, 30634 },
		[FACTION_STANDING_LABEL7] = { 29180, 29179, 24182, 29191, 22915, 28281, 13517, 22537, 33159	},
		[FACTION_STANDING_LABEL8] = { 29177, 29175, 29176, 33153, 31354, 31781 }
	},
	[L["Shattrath"]] = {	
		["Flasks"] = { 32898, 32899, 32901, 32900 }
	},
	[BF["Sha'tari Skyguard"]] = {	
		[FACTION_STANDING_LABEL5] = { 32722 },
		[FACTION_STANDING_LABEL6] = { 32721 },
		[FACTION_STANDING_LABEL7] = { 32539, 32538 },
		[FACTION_STANDING_LABEL8] = { 32770, 32771, 32319, 32314, 32317, 32316, 32318, 32445 }
	},
	[BF["Sporeggar"]] = {	
		[FACTION_STANDING_LABEL5] = { 27689, 30156, 25548, 24539 },
		[FACTION_STANDING_LABEL6] = { 25827, 25828, 25550 },
		[FACTION_STANDING_LABEL7] = { 29150, 29149, 22916, 38229 },
		[FACTION_STANDING_LABEL8] = { 34478, 22906, 31775 }
	},
	[BF["Thrallmar"]] = {	
		[FACTION_STANDING_LABEL5] = { 25738, 31359, 24000, 24006, 24009 },
		[FACTION_STANDING_LABEL6] = { 25824, 25823, 25739, 25740, 29197, 29232, 24001, 31361, 30637 },
		[FACTION_STANDING_LABEL7] = { 29168, 29167, 32882, 31358, 29190, 24003, 34201 },
		[FACTION_STANDING_LABEL8] = { 29155, 29165, 29152, 33151, 24002, 31362, 24004 }
	},
	[BF["Tranquillien"]] = {	
		[FACTION_STANDING_LABEL5] = { 22991, 22992, 22993, 28164 },
		[FACTION_STANDING_LABEL6] = { 28155, 28158, 28162 },
		[FACTION_STANDING_LABEL7] = { 22986, 22987, 22985 },
		[FACTION_STANDING_LABEL8] = { 22990 }
	},
	[BF["The Violet Eye"]] = {	
		[L["Quest rewards"]] = { 31113 },
		[FACTION_STANDING_LABEL5] = { 29280, 29284, 29288, 29276 },
		[FACTION_STANDING_LABEL6] = { 31395, 31393, 31401, 29187, 33209, 29281, 29285, 29289, 29277 },
		[FACTION_STANDING_LABEL7] = { 34581, 34582, 31394, 33205, 29282, 29286, 29291, 29278 },
		[FACTION_STANDING_LABEL8] = { 33124, 33165, 29283, 29287, 29290, 29279 }
	},
	
	-- ** 2.4: sun offensive **
	[BF["Shattered Sun Offensive"]] = {
		[FACTION_STANDING_LABEL5] = { 35244, 35254, 35255, 35246, 35256, 35262, 35248, 35260, 35263, 35264, 
								35249, 35250, 35261, 34780 },
		[FACTION_STANDING_LABEL6] = { 35238, 35251, 35266, 35239, 35240, 35253, 35268, 35269, 35254, 35500, 34872 },
		[FACTION_STANDING_LABEL7] = { 35252, 35769, 35768, 35767, 35259, 35241, 35766, 35271, 34665, 34667, 
								34672, 34666, 34671, 34670, 34673, 34674, 29193, 35708, 35505, 35502, 
								35697, 35695, 35696, 35699, 35698 },
		[FACTION_STANDING_LABEL8] = { 34678, 34679, 34680, 34677, 34676, 34675, 35247, 35257, 35267, 35258, 
								35242, 35243, 35265, 35270, 35755, 35752, 35754, 35753, 35221, 35322, 35323, 35325, 37504 }
	},
	
	-- ** Miscellaneous **
	[L["Outdoor Bosses"]] = {	
		[BB["Azuregos"]] = { 18541, 18208, 19132, 18545, 19131, 18547, 17070, 18202, 18542, 19130, 
						18704, 18714 },
		[BB["Doom Lord Kazzak"]] = { 30735, 30734, 30737, 30739, 30740, 30741, 30736, 30738, 30733, 30732 },
		[BB["Doomwalker"]] = { 30729, 30725, 30727, 30730, 30728, 30731, 30726, 30723, 30722, 30724 },
		[BB["Lethon"]] = { 20579, 20618, 20615, 20617, 20616, 20619, 20582, 20580, 20581, 20644, 
								20600, 20626, 20625, 20628, 20627, 20629, 20630	},
		[BB["Emeriss"]] = {	20579, 20618, 20615, 20617, 20616, 20619, 20582, 20580, 20581, 20644, 
								20600, 20623, 20621, 20622, 20624, 20599 },
		[BB["Taerar"]] = {	20579, 20618, 20615, 20617, 20616, 20619, 20582, 20580, 20581, 20644, 
								20600, 20631, 20633, 20634, 20632, 20577 },
		[BB["Ysondre"]] = { 20579, 20618, 20615, 20617, 20616, 20619, 20582, 20580, 20581, 20644, 
								20600, 20635, 20638, 20637, 20639, 20636, 20578	},
		[L["Highlord Kruul"]] = { 18204, 19135, 19133, 18544, 19134, 18546, 17111, 18543, 17112, 17113, 
								18665, 18608, 18609 }
	},
	[L["Bash'ir Landing"]] = {	
		[L["Skyguard Raid"]] = { 32596, 32600, 32599, 32597, 32634, 32637, 32635, 32636, 32639, 32638, 
								32641, 32640, 32759, 32630, 32631, 32627, 32625, 32629, 32628, 32626, 32624 },
		[L["Stasis Chambers"]] = { 32522, 31577, 31569, 31553, 31561},
	},
	[L["Skettis"]] = {	
		[L["Darkscreecher Akkarai"]] = {	32529, 32715, 31558, 31555, 31566, 31563, 31574, 31571, 31582, 31579, 32514 },
		[L["Karrog"]] = {	32533, 32717, 31558, 31555, 31566, 31563, 31574, 31571, 31582, 31579, 32514 },
		[L["Gezzarak the Huntress"]] = { 32531, 32716, 31558, 31555, 31566, 31563, 31574, 31571, 31582, 31579, 32514 },
		[L["Vakkiz the Windrager"]] = {	32532, 32718, 31558, 31555, 31566, 31563, 31574, 31571, 31582, 31579, 32514 },
		[L["Terokk"]] = { 32540, 32541, 31556, 31564, 31572, 31580, 32535, 32534, 32782, 32536, 32537 }
	},
	[L["Ethereum Prison"]] = {	
		[L["Armbreaker Huffaz"]] = { 31943, 31939, 31938, 31936, 31935, 31937, 31957, 31928, 31929, 31925, 31926, 31927 },
		[L["Fel Tinkerer Zortan"]] = { 31573, 31939, 31938, 31936, 31935, 31937, 31957, 31928, 31929, 31925, 31926, 31927 },
		[L["Forgosh"]] = { 31940, 31939, 31938, 31936, 31935, 31937, 31957, 31928, 31929, 31925, 31926, 31927 },
		[L["Gul'bor"]] = { 31940, 31939, 31938, 31936, 31935, 31937, 31957, 31928, 31929, 31925, 31926, 31927 },
		[L["Malevus the Mad"]] = { 31581, 31939, 31938, 31936, 31935, 31937, 31957, 31928, 31929, 31925, 31926, 31927 },
		[L["Porfus the Gem Gorger"]] = { 31557, 31939, 31938, 31936, 31935, 31937, 31957, 31928, 31929, 31925, 31926, 31927 },
		[L["Wrathbringer Laz-tarash"]] = { 32520, 31939, 31938, 31936, 31935, 31937, 31957, 31928, 31929, 31925, 31926, 31927 }
	},
	[L["Abyssal Council"] .. " (" .. BZ["Silithus"] .. ")"] = {	
		[L["Crimson Templar (Fire)"]] = { 20657, 20655, 20656	},
		[L["Azure Templar (Water)"]] = { 20654, 20652, 20653 },
		[L["Hoary Templar (Wind)"]] = { 20658, 20659, 20660 },
		[L["Earthen Templar (Earth)"]] = { 20661, 20662, 20663 },
		[L["The Duke of Cinders (Fire)"]] = { 20665, 20666, 20514, 20664, 21989 },
		[L["The Duke of Fathoms (Water)"]] = { 20668, 20669, 20514, 20667 },
		[L["The Duke of Zephyrs (Wind)"]] = { 20674, 20675, 20514, 20673 },
		[L["The Duke of Shards (Earth)"]] = { 20671, 20672, 20514, 20670 },
		[BB["Prince Skaldrenox"] .. " (Fire)"] = { 20682, 20515, 20681, 20680	},
		[BB["Lord Skwol"] .. " (Water)"] = {	20685, 20515, 20684, 20683 },
		[BB["High Marshal Whirlaxis"] .. " (Wind)"] = { 20691, 20515, 20690, 20689 },
		[BB["Baron Kazum"] .. " (Earth)"] = { 20688, 20515, 20686, 20687 }
	},
	[L["Elemental Invasion"]] = {	
		[BB["Baron Charr"] .. " (" .. BZ["Un'Goro Crater"] .. ")"] = {	18671, 19268, 18672 },
		[BB["Princess Tempestria"] .. " (" .. BZ["Winterspring"] .. ")"] = { 18678, 19268, 21548, 18679 },
		[BB["Avalanchion"] .. " (" .. BZ["Azshara"] .. ")"] = { 18673, 19268, 18674 },
		[BB["The Windreaver"] .. " (" .. BZ["Silithus"] .. ")"] = { 18676, 19268, 21548, 18677 }
	},
	[L["Gurubashi Arena"]] = {	
		[L["Booty Run"]] = { 18709, 18710, 18711, 18712, 18706, 19024 }
	},
	[L["Fishing Extravaganza"]] = {	
		[L["First Prize"]] = { 19970, 19979	},
		[L["Rare Fish"]] = { 19805, 19803, 19806, 19808 },
		[L["Rare Fish Rewards"]] = { 19972, 19969, 19971 }
	},
	[L["Children's Week"]] = {	
		[BZ["Azeroth"]] = { 23007, 23015, 23002, 23022 },
		[BZ["Outland"]] = { 32616, 32622, 32617	}
	},
	[L["Love is in the air"]] = {	
		[L["Gift of Adoration"]] = { 34480, 22279, 22235, 22200, 22261, 22218, 21813, 34258 },
		[L["Box of Chocolates"]] = { 22237, 22238, 22236, 22239 },
		[L["Quest rewards"]] = { 22276, 22278, 22280, 22277, 22281, 22282	}
	},
	[L["Hallow's End"]] = {	
		[L["Various Locations"]] = { 33117, 20400, 18633, 18632, 18635, 20557 },
		[L["Treat Bag"]] = {	20410, 20409, 20399, 20398, 20397, 20413, 20411, 20414, 20389, 20388, 
									20390, 20561, 20391, 20566, 20564, 20570, 20572, 20568, 20573, 20562, 
									20392, 20565, 20563, 20569, 20571, 20567, 20574 },
		[L["Headless Horseman"]] = { 33808, 34075, 34073, 34074, 33292, 33154, 34068, 33226, 33182, 33184, 
									33176, 33183, 33189 }
	},
	[L["Feast of Winter Veil"]] = {	
		[L["Various Locations"]] = { 21525, 21524, 17712, 17202, 34191, 21212, 21519 },
		[L["Smokywood Pastures Vendor"]] = { 34262, 34319, 34261, 34413, 17201, 17200, 17344, 17406, 17407, 17408, 
								34410, 17404, 17405, 34412, 17196, 17403, 17402, 17194, 17303, 17304, 17307 },
		[L["Gaily Wrapped Present"]] = { 21301, 21308, 21305, 21309	},
		[L["Festive Gift"]] = {	21328 },
		[L["Winter Veil Gift"]] = { 34425 },
		[L["Gently Shaken Gift"]] = {	21235, 21241 },
		[L["Ticking Present"]] = {	21325, 21213, 17706, 17725, 17720, 17722, 17709, 17724 },
		[L["Carefully Wrapped Present"]] = { 21254 },
		[L["Smokywood Pastures Extra-Special Gift"]] = { 21215 }
	},
	[L["Noblegarden"]] = {	
		[L["Brightly Colored Egg"]] = { 19028, 6833, 6835, 7807, 7808, 7806 }
	},	
	[L["Harvest Festival"]] = {	
		[L["Quest rewards"]] = { 19697, 20009, 20010 },
		[L["Food"]] = { 19994, 19995, 19996, 19997 }
	},
	[L["Scourge Invasion"]] = {	
		[L["Miscellaneous"]] = { 23123, 23122, 22999, 23194, 23195, 23196	},
		[L["Cloth Set"]] = {	23085, 23091, 23084 },
		[L["Leather Set"]] = { 23089, 23093, 23081 },
		[L["Mail Set"]] = { 23088, 23092, 23082 },
		[L["Plate Set"]] = {	23087, 23090, 23078 },
		[L["Balzaphon"]] = {	23126, 23125, 23124 },
		[L["Lord Blackwood"]] = { 23156, 23132, 23139 },
		[L["Revanchion"]] = { 23127, 23129, 23128	},
		[L["Scorn"]] = { 23170, 23169, 23168 },
		[L["Sever"]] = { 23173, 23171 },
		[L["Lady Falther'ess"]] = { 23178, 23177 }
	},
	[L["Lunar Festival"]] = {	
		[L["Miscellaneous"]] = { 21540, 21157, 21538, 21539, 21541, 21544, 21543, 21537, 21713, 21100 },
		[L["Fireworks Pack"]] = { 21558, 21559, 21557, 21561, 21562, 21589, 21590, 21592, 21593, 21595 },
		[L["Lucky Red Envelope"]] = { 21744, 21745 },
		[BI["Engineering"]] = { 21738, 21724, 21725, 21726, 21727, 21728, 21729, 21737, 21730, 21731, 
									21732, 21733, 21734, 21735 },
		[BI["Tailoring"]] = { 21722, 21723 }
	},
	[L["Midsummer Fire Festival"]] = {	
		[L["Miscellaneous"]] = { 34686, 23379, 23083, 23247, 23246, 23435, 23327, 23326, 
									23211, 34684, 23323, 23324, 34685, 34683 },
		[L["Lord Ahune"]] = { 35494, 35495, 35496, 35497, 35498, 35514, 35723, 34955, 35279, 35280 },
		[L["Lord Ahune"] .. L[" (Heroic)"]] = { 35507, 35509, 35508, 35511, 35498, 34955, 35723, 35279, 35280, 35497, 
									35496, 35494, 35495, 35514 }
	},
	[L["Shartuul"]] = {	
		[L["Blade Edge Mountains"]] = { 32941, 32676, 32675, 32677, 32678, 32672, 32673, 32674, 32670, 32671, 
									32679, 32942, 32655, 32656, 32665, 32664, 32658, 32659, 32660, 32663, 
									32661, 32662 }
	},
	[L["Brewfest"]] = {	
		[L["Miscellaneous"]] = { 33927, 33047, 33968, 33864, 33967, 33969, 33862, 33863, 33868, 33966, 
									33978, 33977, 33976, 32912, 34140, 32233, 33455, 34063, 34064, 33023, 
									33024, 33025, 33026, 33043, 33929 },
		[L["Barleybrew Brewery"]] = { 33030, 33028, 33029 },
		[L["Thunderbrew Brewery"]] = { 33031, 33032, 33033	},
		[L["Gordok Brewery"]] = { 33034, 33036, 33035 },
		["Coren Direbrew"] = { 37127, 38289, 38290, 38288, 38287, 37597 },
		[L["Drohn's Distillery"]] = { 34017, 34018, 34019 },
		[L["T'chali's Voodoo Brewery"]] = { 34020, 34021, 34022 }
	},
	
	-- ** Crafts **
	[L["Crafted Weapons"]] = {	
		[L["Master Swordsmith"]] = { 28425, 28426, 28427, 28428, 28429, 28430 },
		[L["Master Axesmith"]] = {	28431, 28432, 28433, 28434, 28435, 28436 },
		[L["Master Hammersmith"]] = {	28437, 28438, 28439, 28440, 28441, 28442 },
		[L["Blacksmithing (Lv 60)"]] = {	19166, 22383, 19168, 19169, 22384, 19170, 17193, 19167, 22198 },
		[L["Blacksmithing (Lv 70)"]] = {	23554, 23555, 23540, 23541, 23542, 23543, 23556, 23544, 23546, 32854 },
		[L["Engineering (Lv 60)"]] = { 18282, 18168 },
		[L["Engineering (Lv 70)"]] = { 32756 }
	},
	[L["Blacksmithing Plate Sets"]] = {	
		[L["Imperial Plate"]] = { 12427, 12428, 12422, 12425, 12424, 12429, 12426 },
		[L["The Darksoul"]] = { 19695, 19693, 19694 },
		[L["Fel Iron Plate"]] = { 23489, 23482, 23484, 23488, 23487	},
		[L["Adamantite Battlegear"]] = {	23507, 23506, 23508 },
		[L["Flame Guard"]] = { 23516, 23513, 23515, 23514 },
		[L["Enchanted Adamantite Armor"]] = { 23509, 23510, 23512, 23511 },
		[L["Khorium Ward"]] = {	23524, 23523, 23525 },
		[L["Faith in Felsteel"]] = { 23519, 23517, 23518 },
		[L["Burning Rage"]] = {	23521, 33173, 23522, 23520 }
	},
	[L["Blacksmithing Mail Sets"]] = {	
		[L["Bloodsoul Embrace"]] = { 19691, 19690, 19692 },
		[L["Fel Iron Chain"]] = { 23493, 23490, 23494, 23491 }
	},
	[L["Tailoring Sets"]] = {	
		[L["Bloodvine Garb"]] = { 19682, 19683, 19684 },
		[L["Netherweave Vestments"]] = { 21855, 21854, 21849, 21851, 21850, 21852, 21853 },
		[L["Imbued Netherweave"]] = { 21862, 21861, 21859, 21860 },
		[L["Arcanoweave Vestments"]] = { 21868, 21866, 21867 },
		[L["The Unyielding"]] = { 24249, 24255	},
		[L["Whitemend Wisdom"]] = { 24264, 24261 },
		[L["Spellstrike Infusion"]] = { 24266, 24262	},
		[L["Battlecast Garb"]] = {	24267, 24263 },
		[L["Soulcloth Embrace"]] = { 21864, 21865, 21863 },
		[L["Primal Mooncloth"]] = { 21874, 21875, 21873	},
		[L["Shadow's Embrace"]] = { 21869, 21871, 21870	},
		[L["Wrath of Spellfire"]] = { 21848, 21847, 21846 }
	},
	[L["Leatherworking Leather Sets"]] = {	
		[L["Volcanic Armor"]] = { 15055, 15053, 15054 },
		[L["Ironfeather Armor"]] = { 15067, 15066	},
		[L["Stormshroud Armor"]] = { 15058, 15056, 21278, 15057 },
		[L["Devilsaur Armor"]] = {	15063, 15062 },
		[L["Blood Tiger Harness"]] = { 19689, 19688 },
		[L["Primal Batskin"]] = { 19685, 19687, 19686 },
		[L["Wild Draenish Armor"]] = { 25676, 25674, 25675, 25673 },
		[L["Thick Draenic Armor"]] = { 25671, 25669, 25670, 25668 },
		[L["Fel Skin"]] = { 25685, 25687, 25686 },
		[L["Strength of the Clefthoof"]] = { 25689, 25690, 25691	},
		[L["Primal Intent"]] = { 29525, 29527, 29526	},
		[L["Windhawk Armor"]] = { 29522, 29523, 29524 }
	},
	[L["Leatherworking Mail Sets"]] = {	
		[L["Green Dragon Mail"]] = { 15045, 20296, 15046 },
		[L["Blue Dragon Mail"]] = { 15049, 15048, 20295 },
		[L["Black Dragon Mail"]] = { 15051, 15050, 15052, 16984 },
		[L["Scaled Draenic Armor"]] = { 25660, 25661, 25662, 25659 },
		[L["Felscale Armor"]] = { 25657, 25654, 25656, 25655 },
		[L["Felstalker Armor"]] = { 25696, 25697, 25695	},
		[L["Fury of the Nether"]] = {	25694, 25692, 25693 },
		[L["Netherscale Armor"]] = { 29515, 29517, 29516 },
		[L["Netherstrike Armor"]] = { 29519, 29521, 29520 }
	},
	[BI["Alchemy"]] = {	
		[L["Apprentice"]] = { 2454, 5997, 118, 3382, 2455, 2456 },
		[L["Apprentice"]] = { 4596, 2457, 2458, 858, 5631, 2459, 6370, 6662, 5996, 3383,
								6051, 6372, 929, 3384, 3385, 3386 },
		[L["Expert"]] = {	3388, 6371, 3389, 6048, 6373, 3390, 3391, 5634, 1710, 3827, 
							3823, 3824, 6049, 3825, 5633, 3826, 8949, 6050, 17708, 6052, 
							3828, 8951 },
		[L["Artisan"]] = { 10592, 3829, 6149, 8956, 9061, 9036, 9030, 18294, 4623, 3928, 
							3577, 6037, 9149, 9144, 12190, 9154, 9155, 9179, 9172, 9197, 9187, 9088, 
							9210, 9206, 9224, 9233, 21546, 9264, 13423, 3387, 13442, 13443, 13445, 13447 },
		[L["Master"]] = { 12360, 7078, 12803, 7080, 7076, 7076, 7080, 7082, 12808, 13453,
							20002, 20007, 13446, 13452, 13455, 13454, 20008, 13462, 13461, 13457,
							13456, 13458, 13459, 20004, 13444, 7068, 18253, 19931, 13513, 13511,
							13506, 13512, 13510, 28103, 28102, 28100, 22823, 22824, 22825, 32062, 
							28101, 28104, 22826, 32063, 32067, 22827, 22828, 34440, 31080, 22830, 
							22829, 32068, 22831, 31679, 22871, 22832, 22834, 22833, 31676, 13503, 
							23571, 21884, 21885, 22452, 22451, 22839, 22835, 22838, 22837, 22836, 
							22840, 31677, 22845, 22841, 22842, 22847, 22844, 22846, 32839, 32849, 
							32850, 32851, 32852, 22848, 22849, 35751, 35748, 35750, 35749, 21886, 
							22457, 22452, 21884, 21885, 22456, 22850, 33208, 22861, 22851, 22853, 
							22866, 22854 }
	},
	[BI["Jewelcrafting"]] = {	
		[L["Apprentice"]] = { 20816, 25498, 20906, 21931, 21932, 25438, 25439, 20821, 21934 },
		[L["Apprentice"]] = { 20817, 25880, 20818, 20907, 21933, 20820, 30804, 20823, 30419, 31154, 
							20827, 20826, 20828, 30420, 25881, 20830, 20909, 20832, 20950 },
		[L["Expert"]] = {	20954, 20833, 20955, 20963, 20958, 20831, 20966, 20960, 20959, 25882, 
							29157, 20961, 20967 },
		[L["Artisan"]] = { 29158, 21756, 21748, 20964, 21758, 21755, 25883, 21752, 20969, 21760, 
							30421, 21763, 21764, 21765, 21754, 21753, 21766, 21769, 21767, 30422 },
		[L["Master"]] = { 21774, 21768, 29159, 21775, 21790, 21777, 21778, 21791, 29160, 23113, 
							23108, 23098, 23103, 23118, 23094, 21784, 21789, 23095, 28595, 23114, 
							23104, 23099, 23109, 23119, 21792, 21779, 24074, 24075, 23105, 23100, 
							23096, 23110, 23120, 23115, 24076, 32833, 31079, 31862, 23106, 23097, 
							31860, 31864, 23121, 23101, 23116, 28290, 23111, 31866, 31869, 32772, 
							32774, 24078, 24077, 32508, 24087, 31863, 24027, 24031, 24047, 35945, 
							24065, 24028, 24062, 24036, 24050, 24061, 24056, 31861, 31865, 24058, 
							24067, 24060, 24037, 24053, 24059, 32836, 24066, 35707, 24051, 24057, 
							24030, 24055, 24048, 24033, 24054, 24035, 33782, 24039, 24032, 24029, 
							24052, 31867, 31868, 24079, 24088, 24080, 24082, 24110, 24106, 33140, 
							33131, 33133, 33144, 33135, 33134, 33143, 24114, 24116, 24085, 24092, 
							24097, 24093, 24098, 24095, 30825, 24086, 24089, 25897, 25899, 24121, 
							34220, 32776, 25890, 24117, 25895, 25901, 25893, 25896, 32409, 25894, 
							25898, 32410, 34360, 34361, 34358, 34362, 34359, 34363, 24123, 24122, 
							35503, 35501, 24125, 24124, 24126, 24128, 24127, 32213, 32193, 32197, 
							32204, 32225, 32194, 32223, 35700, 35693, 35694, 35703, 35702, 32199, 
							35759, 32207, 32220, 32215, 32210, 32214, 32217, 32226, 32219, 32202, 
							32209, 32218, 35761, 32224, 35760, 32206, 32216, 32196, 32212, 32205, 
							32200, 32211, 32201, 35758, 32203, 32198, 32195, 32208, 32221, 32222, 
							31398, 31399, 35318, 35315, 35316 }
	},	
	[BI["Enchanting"]] = {	
		[L["Apprentice"]] = { 6218, 11287, 20744 },
		[L["Apprentice"]] = { 11288, 6339 },
		[L["Expert"]] = {	20745, 11130, 11289, 11290 },
		[L["Artisan"]] = { 20746, 11145, 12810, 12655, 20747, 11811 },
		[L["Master"]] = { 20750, 16207, 22448, 20748, 20749, 22461, 22521, 22460, 22448, 22449, 
							22522, 22459, 22462, 22449, 22463 }
	},
	[BI["Blacksmithing"]] = {	
		[L["Apprentice"]] = { 10421, 2862, 3239, 2853, 2852, 2844, 2845, 3469, 3470, 2847, 
								7955, 7166, 3488, 3471, 33791, 2851, 3472, 3473 },
		[L["Apprentice"]] = { 3474, 2863, 3240, 6214, 3489, 2857, 3478, 2864, 2854, 6350, 
								3487, 15869, 6338, 29201, 6731, 3848, 2865, 2866, 5540, 2848, 
								3480, 2849, 2868, 2850 },
		[L["Expert"]] = {	2871, 3241, 3486, 3490, 3481, 7956, 3491, 3482, 2869, 7957, 
								3483, 7958, 5541, 2870, 3484, 3492, 7071, 15870, 11128, 3485, 
								6042, 3842, 10423, 3851, 7914, 7913, 3840, 3849, 3835, 6043, 
								3852, 3843, 3836, 7915, 3841, 3850, 3844, 7916, 12259, 3853, 
								7917, 3855, 3846, 6040, 17704, 3837, 12260, 6041, 3845 },
		[L["Artisan"]] = { 7966, 7964, 7965, 15871, 11144, 29202, 3854, 3847, 3856, 7963, 
								9060, 9366, 7919, 7918, 7921, 7920, 7941, 7924, 7967, 7922, 
								7927, 7926, 7942, 7938, 7928, 7943, 7930, 7931, 7945, 7933, 
								7932, 7969, 7954, 7944, 7934, 7939, 7961, 7946, 12644, 12404,
								12643, 12405, 12406, 7959, 12408, 7947, 30069, 30071, 30073, 30072, 
								30070, 12416, 7960, 11608, 12424, 12428, 12624, 11606, 12425, 12415 },
		[L["Master"]] = { 15872, 16206, 11607, 12645, 12774, 12773, 11605, 12409, 12410, 12777, 
								12776, 12775, 11604, 12628, 12418, 12781, 12625, 12631, 19051, 19043, 
								12419, 12782, 12792, 17014, 16989, 12632, 12426, 12427, 12417, 25843, 
								23528, 28420, 18262, 23493, 23482, 19166, 22194, 19167, 19168, 20039, 
								19164, 19148, 17013, 19170, 16988, 22671, 22669, 22670, 12641, 22198, 
								12640, 19169, 22191, 22384, 22383, 12639, 22196, 22385, 12798, 12790, 
								12784, 19690, 19692, 19691, 17016, 17015, 20550, 20549, 20551, 19693, 
								19694, 19695, 12618, 12620, 12619, 12797, 19057, 12796, 12783, 22197, 
								19048, 12636, 22764, 22762, 22763, 22195, 12794, 12633, 29203, 12422, 
								12429, 12420, 12611, 12614, 12610, 12414, 17193, 23484, 23491, 23497, 
								23494, 23498, 23487, 23488, 23490, 23499, 23559, 23502, 23489, 30093, 
								30074, 30089, 30088, 30086, 30087, 30076, 30077, 23503, 23504, 33185, 
								23506, 23508, 23505, 23575, 23507, 23529, 28421, 25844, 25521, 28483, 
								28437, 28425, 28428, 28434, 23563, 28431, 28440, 29204, 23515, 23510, 
								23511, 23516, 23509, 23517, 23518, 23514, 23524, 23523, 23530, 23537, 
								23539, 23538, 23555, 23554, 23542, 23546, 23531, 23540, 23543, 23532, 
								32854, 23556, 23535, 23541, 23536, 23544, 23533, 23534, 23512, 23519, 
								23513, 23525, 23520, 23521, 33173, 34378, 34377, 34379, 34380, 23527, 
								23522, 23526, 23576, 25845, 30034, 28432, 28427, 28426, 28436, 30033, 
								28484, 28485, 32571, 32573, 28441, 28438, 28439, 23565, 31369, 31371, 
								31370, 28429, 28430, 28435, 30032, 30031, 32403, 32401, 32404, 32402, 
								28442, 32568, 32570, 23564, 28433, 31364, 31368, 31367 },
		[L["Armorsmith"]] = { 7938, 7939, 30069, 30070, 30074, 30076, 28483, 23563, 28484,
								28485, 23565, 23564 },
		[L["Weaponsmith"]] = { 7954, 7961, 7959, 30071, 30073, 30072, 7960 },
		[L["Master Axesmith"]] = {	30088, 30087, 28434, 28431, 28432, 28436, 28435, 28433 },
		[L["Master Hammersmith"]] = {	30093, 30089, 28437, 28440, 28441, 28438, 28439, 28442 },
		[L["Master Swordsmith"]] = { 30086, 30077, 28425, 28428, 28427, 28426, 28429, 28430	}
	},
	[BI["Leatherworking"]] = {	
		[L["Apprentice"]] = { 2318, 2304, 2302, 7277, 7276, 5957, 2303, 4237, 7278, 7279, 
								4231, 7280, 2300, 5081 },
		[L["Apprentice"]] = { 2309, 4239, 2310, 2311, 7281, 4242, 2312, 4246, 2308, 4243, 
								6709, 6466, 5780, 2307, 7282, 5781, 2319, 4233, 2313, 7283, 
								20575, 2317, 4244, 2315, 6467, 5958, 2316, 6468, 5961, 4250, 
								7285, 7284, 2314, 4248 },
		[L["Expert"]] = {	4249, 7348, 4251, 4253, 7352, 7349, 4252, 7358, 7359, 4247, 
								4234, 18662, 4236, 4254, 7372, 7371, 4265, 3719, 18948, 4255, 
								4257, 5962, 7373, 4456, 4455, 5963, 4258, 5782, 5964, 7374, 
								7375, 4256, 7377, 4259, 4262, 7378, 5965, 17721, 7386, 5783, 
								5739, 5966, 7387, 4260 },
		[L["Artisan"]] = { 8172, 4304, 18238, 4264, 8174, 7390, 7391, 8173, 8176, 8175, 
								8187, 8192, 8198, 8189, 8200, 8201, 8205, 8203, 8210, 8347, 
								8345, 8217, 8218, 8204, 8214, 8211, 8346, 8193, 8191, 8197, 
								8209, 8185, 8216, 8202, 8207, 8206, 8213, 8170, 15407, 15564,
								8349, 8348, 8208, 8215, 8212, 8367, 15077, 29964, 29971, 15045,
								29970, 15083, 15074, 15076, 15084, 15046, 15067, 15061, 15091, 15054 },
		[L["Master"]] = { 18258, 15057, 15064, 15073, 15071, 15078, 15092, 20296, 15072, 15082, 
								15093, 15086, 34086, 15048, 15060, 15056, 15065, 15069, 15079, 15053, 
								15050, 19052, 15063, 15066, 19044, 15075, 15094, 15087, 16982, 15049, 
								15058, 15070, 15080, 25679, 21887, 25654, 34482, 25662, 25669, 25673, 
								25650, 16984, 18509, 19157, 19162, 20380, 18510, 22665, 22664, 22666, 
								19149, 19163, 16983, 22663, 22662, 22661, 18511, 15052, 15051, 19688, 
								19689, 20295, 22761, 22760, 22759, 18251, 15062, 18504, 19058, 15059, 
								18506, 15138, 19687, 19686, 19685, 15047, 20476, 20478, 20477, 20481, 
								20479, 20480, 21278, 18508, 19049, 15068, 15081, 15090, 15095, 15096, 
								15055, 15085, 15088, 25655, 25661, 25674, 34099, 34100, 25670, 25656, 
								25668, 25675, 23793, 29540, 25652, 25651, 25660, 25671, 25676, 29975, 
								29974, 29973, 29534, 29533, 25657, 25659, 29528, 29488, 29485, 29486, 
								29487, 29483, 25685, 25694, 25692, 29530, 29531, 34207, 34330, 29500, 
								29499, 29498, 29497, 29496, 29495, 29491, 29490, 29489, 25686, 25687, 
								25695, 29494, 29493, 29492, 25693, 34106, 34105, 25653, 25681, 25683, 
								25682, 25680, 25691, 25690, 33122, 34490, 25697, 25696, 25689, 29529, 
								29536, 29535, 29503, 29502, 29512, 29506, 29505, 29508, 29511, 29510, 
								33204, 29514, 29504, 29507, 29509, 34369, 34373, 34374, 34370, 34371, 
								34372, 34375, 34376, 29532, 30040, 30042, 30046, 32574, 30041, 32398, 
								30045, 30039, 32582, 32399, 29516, 29517, 29515, 32400, 30043, 32577, 
								32579, 30044, 29520, 29521, 29519, 29526, 29527, 29525, 32393, 32396, 
								32394, 32395, 32583, 32575, 32580, 32581, 32397, 29524, 29523, 29522 },
		[L["Dragonscale"]] = { 8347, 8367, 29971, 20296, 20295, 29975, 29516, 29517, 29515, 29520,
								29521, 29519 },
		[L["Elemental"]] = { 8346, 8348, 29964, 29973, 29526, 29527, 29525 },
		[L["Tribal"]] = { 8345, 8349, 29970, 29974, 29524, 29523, 29522 }
	},
	[BI["Tailoring"]] = {	
		[L["Apprentice"]] = { 2996, 4344, 2570, 10045, 2576, 2568, 7026, 10046, 6238, 6241, 
								4343, 4307, 2572, 2577, 2575, 6786, 4238 },
		[L["Apprentice"]] = { 6240, 6239, 4308, 2580, 2569, 2578, 6242, 4309, 2579, 5762, 
								2997, 10047, 2584, 4312, 4240, 4310, 2582, 5542, 4313, 2583, 
								4241, 2587, 6263, 4311, 2585, 4316, 4314, 4330, 6787, 6264, 
								5763, 10048, 4315, 6384, 6385 },
		[L["Expert"]] = {	4305, 4320, 4331, 4317, 4318, 4332, 5766, 7046, 4321, 7048, 
								4319, 7047, 4324, 5770, 7049, 4245, 4333, 7050, 6795, 4322, 
								7065, 4334, 7051, 4323, 4339, 6796, 7052, 7053, 4325, 7055, 
								5764, 7056, 7057, 4328, 4335, 7058, 4326, 5765, 17723, 7054, 
								7060, 7059, 7062, 7061 },
		[L["Artisan"]] = { 4336, 4327, 4329, 9999, 9998, 7063, 10001, 7064, 10002, 10008,
								10056, 10003, 10009, 10007, 10004, 10052, 10019, 10021, 10042, 22246,
								10018, 10023, 10050, 10054, 10026, 10024, 10027, 10055, 10053, 10029,
								10028, 10051, 10034, 10030, 10033, 10031, 10035, 10044, 10025, 34087, 
								34085, 14048, 10040, 10041, 21154, 21542, 10036, 14342, 13868, 13869, 
								13856, 14042, 13858, 13857, 21340, 14046, 13870, 14143, 13860, 14101, 
								14100, 14043, 14142 },
		[L["Master"]] = { 18258, 14134, 14103, 22251, 14044, 22248, 14107, 14141, 13863, 14132, 
								14045, 13871, 13864, 21341, 14136, 14108, 13865, 15802, 19056, 14137, 
								19047, 14104, 14111, 14144, 13866, 24268, 21840, 18405, 21342, 16979, 
								19165, 16980, 19156, 22658, 22654, 22652, 22655, 14146, 14152, 14153, 
								14154, 19059, 19684, 19683, 19682, 14156, 18413, 18407, 22660, 18408, 
								19050, 14140, 18409, 18486, 14139, 14138, 20539, 20537, 20538, 22757, 
								22758, 22756, 22249, 14106, 14112, 14155, 13867, 22252, 14128, 14130, 
								18263, 21850, 21849, 21841, 21851, 21842, 21852, 24273, 24275, 21853, 
								21843, 21859, 24270, 21854, 21844, 21855, 21845, 24272, 24271, 21866, 
								24251, 24250, 30831, 24253, 24252, 30837, 21860, 24249, 24254, 21869, 
								21873, 21863, 21846, 21867, 30838, 21861, 21862, 24257, 21870, 24256, 
								24260, 21874, 24258, 21864, 21847, 24255, 24259, 34367, 34365, 34366, 
								34364, 21868, 30839, 24267, 24263, 30038, 30036, 30037, 30035, 32586, 
								21871, 24276, 32587, 32420, 21875, 24274, 21865, 32392, 32390, 32389, 
								32391, 21848, 24266, 24262, 32585, 32584, 24264, 24261, 21872, 21876, 
								21858, 30463, 30464, 30465, 30460, 30461, 30459 },
		[L["Mooncloth"]] = { 21873, 21874, 21875 },
		[L["Shadoweave"]] = { 21869, 21870, 21871 },
		[L["Spellfire"]] = { 21846, 21847, 21848 }
	},
	[BI["Engineering"]] = {	
		[L["Apprentice"]] = { 4357, 8067, 4358, 4359, 4360 },
		[L["Apprentice"]] = { 6219, 4362, 4361, 4405, 4363, 4364, 8068, 4365, 4401, 4366, 4404, 6714, 
								6712, 4368, 4367, 4371, 4370, 4369, 4406, 4374, 4372, 4373 },
		[L["Expert"]] = { 8069, 4377, 4378, 21558, 21559, 21557, 4376, 4375, 7506, 4379, 
								5507, 4380, 4381, 4382, 4383, 6533, 9312, 9313, 9318, 10558, 4385, 
								4384, 4386, 4387, 4388, 7148, 4403, 4389, 10505, 10507, 21589, 21590,
								21592, 4391, 10498, 4390, 10499, 4407, 4392, 4852, 4393, 4394, 17716,
								10559, 4395 },
		[L["Artisan"]] = { 18588, 4398, 11590, 10560, 4397, 4396, 10577, 10644, 10713, 11826,
								11825, 10646, 10500, 10543, 10542, 10508, 10716, 10577, 10512, 10545,
								10546, 10720, 10561, 10514, 10721, 10501, 10510, 21571, 21574, 21576,
								10724, 7189, 10518, 10502, 21569, 10587, 10506, 10503, 10725, 10562,
								10586, 10726, 10645, 10727, 10548, 10513, 10504, 10588, 15992, 18641,
								19026, 10576, 15846, 21277, 18660, 18631, 18634, 15995, 15993, 15994,
								18984, 18986, 18645, 18587, 15996, 15999 },
		[L["Master"]] = { 7191, 21714, 21716, 21718, 18594, 18637, 16004, 21570, 16023, 16000, 
								15997, 16005, 16006, 18638, 16008, 16009, 23832, 23831, 23783, 23781, 
								23782, 18282, 18168, 16022, 18283, 19999, 19998, 16007, 18639, 16040, 
								23736, 18232, 23821, 23772, 23742, 23784, 23774, 23826, 23767, 23737, 
								23841, 33092, 32423, 20475, 34504, 23771, 25886, 23768, 23764, 32413, 
								23827, 23758, 23761, 23787, 23785, 23786, 23835, 33093, 23819, 30542, 
								30544, 23836, 23825, 23762, 23746, 32478, 32494, 32461, 32476, 32472, 
								32475, 32480, 32495, 32474, 32473, 32479, 34060, 23824, 35581, 23747, 
								23763, 23765, 34113, 23838, 23839, 23829, 23828, 32756, 34061, 23748, 
								23766, 34847, 34357, 35182, 35185, 34355, 34354, 35181, 35184, 34353, 
								34356, 35183 },
		[L["Gnomish"]] = { 10713, 11826, 10716, 10545, 10720, 10721, 10724, 10725, 10726, 10645, 
								18660, 18986, 18645, 23841, 23835, 30544, 23825, 23829, 23828 },
		[L["Goblin"]] = { 10577, 10644, 11825, 10646, 10543, 10542, 10577, 7189, 10587, 10586, 
								10727, 10588, 18984, 18587, 23826, 23827, 30542, 23836, 23838, 23839 }
	},	
	[L["Mining"]] = {	
		[L["Apprentice"]] = { 2840 },
		[L["Apprentice"]] = { 3576, 2841, 2842 },
		[L["Expert"]] = {	3575, 3577, 3859, 3860 },
		[L["Artisan"]] = { 6037, 11371, 12359 },
		[L["Master"]] = { 22573, 22574, 23445, 17771, 23446, 23447, 23448, 35128, 23449, 23573 }
	},	
	[BI["Cooking"]] = {	
		[L["Apprentice"]] = { 30816, 6290, 2679, 12224, 17197, 6888, 27635, 2681, 24105, 787,
								33924, 5472, 2680, 2888, 5473, 17198, 5474, 6890 },
		[L["Apprentice"]] = { 27636, 5525, 2684, 5476, 724, 6316, 4592, 5095, 5477, 3220, 
								22645, 7676, 2683, 733, 3662, 2687, 21072, 2682, 6657, 5526, 
								5478, 3663, 34832, 1082, 4593, 5479, 1017, 2685, 3726, 3666, 
								5480, 3664 },
		[L["Expert"]] = {	5527, 12209, 3727, 3665, 20074, 3728, 10841, 4594, 4457, 12213,
								6038, 13851, 12212, 8364, 12214, 12210, 21217, 3729 },
		[L["Artisan"]] = { 12217, 12215, 17222, 13927, 13930, 12218, 12216, 6887, 18045, 16766, 
								13928, 13929, 35563, 35565, 13931, 13932, 13935, 13933, 13934, 18254, 20452 },
		[L["Master"]] = { 27661, 33867, 27651, 30155, 27662, 27655, 33866, 21023, 33874, 27663, 
								27656, 27657, 33048, 27664, 27665, 34411, 33825, 33872, 27666, 27658, 
								27660, 27659, 31673, 31672, 27667, 33052, 33053 }
	},	
	[BI["First Aid"]] = {	
		[L["Apprentice"]] = { 1251, 2581 },
		[L["Apprentice"]] = { 6452, 3530, 3531 },
		[L["Expert"]] = {	6453, 6450, 6451 },
		[L["Artisan"]] = { 8544, 8545, 14529, 14530 },
		[L["Master"]] = { 19440, 21990, 21991 }
	},	
	
	-- ** Sets & PVP ***
	[BZ["Alterac Valley"]] = {	
		[L["Miscellaneous"].." (" .. FACTION_ALLIANCE .. ")"] = { 19045, 19032 },
		[L["Miscellaneous"].." (" .. FACTION_HORDE .. ")"] = {	19046, 19031 },
		[L["Miscellaneous"]] = { 19316, 17348, 17349, 19301, 19307, 19317, 17351, 17352, 19318	},
		[L["Superior Rewards"].." (" .. FACTION_ALLIANCE .. ")"] = { 19086, 19084, 19094, 19093, 19092, 19091, 19098, 19097, 19100, 19104, 
										19102, 19320, 19319 },
		[L["Superior Rewards"].." (" .. FACTION_HORDE .. ")"] = {	19085, 19083, 19090, 19089, 19088, 19087, 19096, 19095, 19099, 19103, 
										19101, 19320, 19319 },
		[L["Epic Rewards"].." (" .. FACTION_ALLIANCE .. ")"] = { 19030 },
		[L["Epic Rewards"].." (" .. FACTION_HORDE .. ")"] = { 19029 },
		[L["Epic Rewards"]] = {	19325, 19312, 19308, 19309, 19324, 19321, 21563, 19315, 19311, 19310, 19323 }
	},
	[BZ["Arathi Basin"]] = {
		[L["Miscellaneous"].." (" .. FACTION_ALLIANCE .. ")"] = {	17349, 17352, 20225, 20227, 20226, 20243, 20237, 20244 },
		[L["Miscellaneous"].." (" .. FACTION_HORDE .. ")"] = {	17349, 17352, 20222, 20224, 20223, 20234, 20232, 20235 },
		[L["Lv 20-29 Rewards"].." (" .. FACTION_ALLIANCE .. ")"] = {	20099, 20096, 20117, 20105, 20120, 20090, 20114, 20102, 20123, 20093, 
										20108, 20126, 20111, 20129, 21119 },
		[L["Lv 20-29 Rewards"].." (" .. FACTION_HORDE .. ")"] = {	20164, 20162, 20191, 20172, 20152, 20197, 20188, 20169, 20201, 20157, 
										20178, 20207, 20182, 20210, 21120 },
		[L["Lv 30-39 Rewards"].." (" .. FACTION_ALLIANCE .. ")"] = {	20098, 20095, 20116, 20104, 20113, 20101, 21118 }, 
		[L["Lv 30-39 Rewards"].." (" .. FACTION_HORDE .. ")"] = {	20166, 20161, 20192, 20173, 20187, 20168, 21116 },
		[L["Lv 40-49 Rewards"].." (" .. FACTION_ALLIANCE .. ")"] = {	20097, 20094, 20115, 20103, 20112, 20100, 20089, 20088, 20119, 20118, 
										20092, 20091, 20122, 20121, 20107, 20106, 20125, 20124, 20110, 20109, 
										20128, 20127, 21117 }, 
		[L["Lv 40-49 Rewards"].." (" .. FACTION_HORDE .. ")"] = {	20165, 20160, 20193, 20174, 20189, 20170, 20153, 20151, 20198, 20196, 
										20156, 20155, 20200, 20202, 20180, 20179, 20206, 20205, 20183, 20185, 
										20209, 20211, 21115 },
		[L["Lv 50-59 Rewards"].." (" .. FACTION_ALLIANCE .. ")"] = {	20047, 20054, 20045, 20046, 20052, 20053, 20043, 20050, 20042, 20041, 
										20049, 20048, 20071 }, 
		[L["Lv 50-59 Rewards"].." (" .. FACTION_HORDE .. ")"] = {	20163, 20159, 20190, 20171, 20186, 20167, 20150, 20195, 20154, 20199, 
										20204, 20208, 20072 },
		[L["Lv 60 Rewards"].." (" .. FACTION_ALLIANCE .. ")"] = {	20073, 20061, 20059, 20060, 20055, 20056, 20058, 20057, 20070, 20069 }, 
		[L["Lv 60 Rewards"].." (" .. FACTION_HORDE .. ")"] = {	20068, 20176, 20194, 20175, 20158, 20203, 20212, 20214, 20220 },
		[L["PVP Cloth Set"].." (" .. FACTION_ALLIANCE .. ")"] = { 20061, 20047, 20054	},
		[L["PVP Cloth Set"].." (" .. FACTION_HORDE .. ")"] = { 20176, 20163, 20159 },
		[L["PVP Leather Sets"].." (" .. FACTION_ALLIANCE .. ")"] = { 20059, 20045, 20052, 20060, 20046, 20053 },
		[L["PVP Leather Sets"].." (" .. FACTION_HORDE .. ")"] = { 20194, 20190, 20186, 20175, 20171, 20167 },
		[L["PVP Mail Sets"].." (" .. FACTION_ALLIANCE .. ")"] = { 20055, 20043, 20050, 20056, 20044, 20051 },
		[L["PVP Mail Sets"].." (" .. FACTION_HORDE .. ")"] = { 20158, 20150, 20154, 20203, 20195, 20199 },
		[L["PVP Plate Sets"].." (" .. FACTION_ALLIANCE .. ")"] = { 20057, 20041, 20048, 20058, 20042, 20049 },
		[L["PVP Plate Sets"].." (" .. FACTION_HORDE .. ")"] = { 20212, 20204, 20208 }
	},
	[BZ["Warsong Gulch"]] = {	
		[L["Miscellaneous"].." (" .. FACTION_ALLIANCE .. ")"] = {	19506 },
		[L["Miscellaneous"].." (" .. FACTION_HORDE .. ")"] = {	19505 },
		[L["Miscellaneous"]] = { 17348, 17349, 19060, 19062, 19067, 17351, 17352, 19061, 19066, 19068 },
		[L["Lv 10-19 Rewards"].." (" .. FACTION_ALLIANCE .. ")"] = {	20428, 20444, 20431, 20439, 20443, 20440, 20434, 20438 },
		[L["Lv 10-19 Rewards"].." (" .. FACTION_HORDE .. ")"] = {	20427, 20442, 20426, 20429, 20441, 20430, 20425, 20437 },
		[L["Lv 20-29 Rewards"].." (" .. FACTION_ALLIANCE .. ")"] = {	19533, 19541, 19525, 19517, 21568, 21566, 19549, 19557, 19573, 19565 },
		[L["Lv 20-29 Rewards"].." (" .. FACTION_HORDE .. ")"] = {	19529, 19537, 19521, 19513, 21568, 21566, 19545, 19553, 19569, 19561 },
		[L["Lv 30-39 Rewards"].." (" .. FACTION_ALLIANCE .. ")"] = {	19532, 19540, 19524, 19515, 19548, 19556, 19572, 19564 }, 
		[L["Lv 30-39 Rewards"].." (" .. FACTION_HORDE .. ")"] = {	19528, 19536, 19520, 19512, 19544, 19552, 19568, 19560 },
		[L["Lv 40-49 Rewards"].." (" .. FACTION_ALLIANCE .. ")"] = {	19597, 19590, 19584, 19581, 19531, 19539, 19523, 19516, 21567, 21565, 
													19547, 19555, 19571, 19563 }, 
		[L["Lv 40-49 Rewards"].." (" .. FACTION_HORDE .. ")"] = {	19597, 19590, 19584, 19581, 19527, 19535, 19519, 19511, 21567, 21565, 
													19543, 19551, 19567, 19559 },
		[L["Lv 50-59 Rewards"].." (" .. FACTION_ALLIANCE .. ")"] = {	19596, 19589, 19583, 19580, 19530, 19538, 19522, 19514, 19546, 19554, 19570, 19562 }, 
		[L["Lv 50-59 Rewards"].." (" .. FACTION_HORDE .. ")"] = {	19596, 19589, 19583, 19580, 19526, 19534, 19518, 19510, 19542, 19550, 
													19566, 19558 },
		[L["Lv 60 Rewards"].." (" .. FACTION_ALLIANCE .. ")"] = {	19595, 22752, 19587, 22749, 22750, 19582, 22748, 30497, 19578, 22753, 22672 }, 
		[L["Lv 60 Rewards"].." (" .. FACTION_HORDE .. ")"] = {	19595, 22747, 19587, 22740, 22741, 19582, 22673, 22676, 19578, 30498, 22651 }
	},
	[L["World PVP"]] = {	
		[L["Hellfire Fortifications"]] = { 27833, 27786, 28360, 27830, 27785, 27777, 24520, 24579, 24522, 24581 },
		[L["Twin Spire Ruins"]] = { 27990, 27984, 27922, 27929, 27939, 27983, 27920, 27927, 27930	},
		[L["Spirit Towers (Terrokar)"]] = { 28553, 28557, 28759, 28574, 28575, 28577, 28560, 28761, 32947, 28555, 
								28556, 28760, 28561, 28576, 28758, 28559, 32948	},
		[L["Halaa (Nagrand)"]] = {	28915, 27679, 27649, 27648, 27650, 27647, 27652, 27654, 27653, 24208, 
								29228, 27680, 27638, 27645, 27637, 27646, 27643, 27644, 27639, 33783, 
								32071, 30611, 30615, 30598, 30597, 30599, 30612, 30571, 30570, 30568 }
	},

	[L["Arena Season 1"]] = {	
		[L["Druid Set"]] = { 28127, 28129, 28130, 28126, 28128, 28137, 28139, 28140, 28136, 28138,
								31376, 31378, 31379, 31375, 31377 },
		[L["Hunter Set"]] = { 28331, 28333, 28334, 28335, 28332 },
		[L["Mage Set"]] = { 25855, 25854, 25856, 25857, 25858 },
		[L["Paladin Set"]] = { 27704, 27706, 27702, 27703, 27705, 27881, 27883, 27879, 27880, 27882, 
								31616, 31619, 31613, 31614, 31618 },
		[L["Priest Set"]] = { 27708, 27710, 27711, 27707, 27709, 31410, 31412, 31413, 31409, 31411 },
		[L["Rogue Set"]] = {	25830, 25832, 25831, 25834, 25833 },
		[L["Shaman Set"]] = { 25998, 25999, 25997, 26000, 26001,27471, 27473, 27469, 27470, 27472, 
								31400, 31407, 31396, 31397, 31406 },
		[L["Warlock Set"]] = { 24553, 24554, 24552, 24556, 24555, 30187, 30186, 30200, 30188, 30201 },
		[L["Warrior Set"]] = { 24545, 24546, 24544, 24549, 24547 },
		[L["Weapons"]] = { 28313, 28314, 28297, 28312, 28310, 28295, 28307, 24550, 28308, 28309, 
								28298, 32450, 32451, 28305, 28302, 28299, 28476, 28300, 24557, 28358, 
								28319, 28294, 28320, 28346, 32452, 33945, 33942, 28355, 33936, 28356, 
								33948, 33939, 33951, 28357 }
	},
	[L["Arena Season 2"]] = {	
		[L["Druid Set"]] = { 31968, 31971, 31972, 31967, 31969, 32057, 32059, 32060, 32056, 32058, 
								31988, 31990, 31991, 31987, 31989 },
		[L["Hunter Set"]] = { 31962, 31964, 31960, 31961, 31963 },
		[L["Mage Set"]] = { 32048, 32047, 32050, 32049, 32051 },
		[L["Paladin Set"]] = { 31997, 31996, 31992, 31993, 31995, 32041, 32043, 32039, 32040, 32042, 
								32022, 32024, 32020, 32021, 32023 },
		[L["Priest Set"]] = { 32035, 32037, 32038, 32034, 32036, 32016, 32018, 32019, 32015, 32017 },
		[L["Rogue Set"]] = {	31999, 32001, 32002, 31998, 32000 },
		[L["Shaman Set"]] = { 32006, 32008, 32004, 32005, 32007, 32011, 32013, 32009, 32010, 32012, 
								32031, 32033, 32029, 32030, 32032 },
		[L["Warlock Set"]] = { 31974, 31976, 31977, 31973, 31975, 31980, 31979, 31982, 31981, 31983 },
		[L["Warrior Set"]] = { 30488, 30490, 30486, 30487, 30489 },
		[L["Weapons"]] = { 32028, 32003, 32053, 32044, 32046, 32052, 32027, 31984, 31965, 31985, 
								31966, 32963, 32964, 32026, 31958, 31959, 32014, 32025, 32055, 33313, 
								33309, 32045, 32054, 31986, 32962, 31978, 32961, 33946, 33943, 33076, 
								33937, 33077, 33949, 33940, 33952, 33078 }
	},
	[L["Arena Season 3"]] = {	
		[L["Druid Set"]] = { 33672, 33674, 33675, 33671, 33673, 33768, 33770, 33771, 33767, 33769, 
								33691, 33693, 33694, 33690, 33692 },
		[L["Hunter Set"]] = { 33666, 33668, 33664, 33665, 33667 },
		[L["Mage Set"]] = { 33758, 33757, 33760, 33759, 33761 },
		[L["Paladin Set"]] = { 33697, 33699, 33695, 33696, 33698, 33751, 33753, 33749, 33750, 33752, 
								33724, 33726, 33722, 33723, 33725 },
		[L["Priest Set"]] = { 33745, 33747, 33748, 33744, 33746, 33718, 33720, 33721, 33717, 33719  },
		[L["Rogue Set"]] = {	33701, 33703, 33704, 33700, 33702 },
		[L["Shaman Set"]] = { 33708, 33710, 33706, 33707, 33709, 33713, 33715, 33711, 33712, 33714, 
								33740, 33742, 33738, 33739, 33741 },
		[L["Warlock Set"]] = { 33677, 33679, 33680, 33676, 33678, 33683, 33682, 33685, 33684, 33686 },
		[L["Warrior Set"]] = { 33730, 33732, 33728, 33729, 33731 },
		[L["Weapons"]] = { 33737, 33705, 34016, 33763, 33754, 33801, 33756, 33762, 33734, 33688, 
								33669, 34015, 33689, 33670, 34014, 33687, 33743, 33733, 33662, 33663, 
								33727, 34540, 33716, 33766, 33661, 33735, 33755, 33765, 34529, 33006, 
								34530, 34059, 34066, 33764, 33681, 34033, 33736, 33947, 33944, 33841, 
								33938, 33842, 33950, 33941, 33953, 33843 }
	},
	[L["Arena Season 4"]] = {	
		[L["Druid Set"]] = { 34999, 35001, 35002, 34998, 35000, 35112, 35114, 35115, 35111, 35113, 
								35023, 35025, 35026, 35022, 35024 },
		[L["Hunter Set"]] = { 34992, 34994, 34990, 34991, 34993 },
		[L["Mage Set"]] = { 35097, 35096, 35099, 35098, 35100 },
		[L["Paladin Set"]] = { 35029, 35031, 35027, 5028, 35030, 35090, 35092, 35088, 35089, 35091, 
								35061, 35063, 35059, 35060, 35062 },
		[L["Priest Set"]] = { 35084, 35086, 35087, 35083, 35085, 35054, 35056, 35057, 35053, 35055 },
		[L["Rogue Set"]] = {	35033, 35035, 35036, 35032, 35034 },
		[L["Shaman Set"]] = { 35044, 35046, 35042, 35043, 35045, 35050, 35052, 35048, 35049, 35051, 
								35079, 35081, 35077, 35078, 35080 },
		[L["Warlock Set"]] = { 35004, 35006, 35007, 35003, 35005, 35010, 35009, 35012, 35011, 35013 },
		[L["Warrior Set"]] = { 35068, 35070, 35066, 35067, 35069 },
		[L["Weapons"]] = { 35076, 35038, 35037, 35102, 37739, 35093, 35058, 35095, 35101, 35072, 
								35015, 34996, 34995, 35017, 34997, 35110, 35014, 35082, 37740, 35071, 
								34988, 34989, 35064, 34987, 35103, 35109, 34986, 35073, 35094, 35108, 
								35047, 35018, 35075, 34985, 35065, 35107, 35008, 35016, 35074, 35019, 
								35020, 35021, 35039, 35040, 35041, 35104, 35105, 35106 }
	},
	
	[L["Level 60 Honor PVP"]] = {	
		[L["Druid Set"]] = { 16451, 16449, 16452, 16448, 16450, 16459, 23308, 23309, 23294, 23280, 
								23295, 23281, 16550, 16551, 16549, 16555, 16552, 16554, 23253, 23254, 
								22877, 22863, 22878, 22852 },
		[L["Hunter Set"]] = { 16465, 16468, 16466, 16463, 16467, 16462, 23306, 23307, 23292, 23279, 
								23293, 23278, 16566, 16568, 16565, 16571, 16567, 16569, 23251, 23252, 
								22874, 22862, 22875, 22843 },
		[L["Mage Set"]] = { 16441, 16444, 16443, 16440, 16442, 16437, 23318, 23319, 23305, 23290, 
								23304, 23291, 16533, 16536, 16535, 16540, 16534, 16539, 23263, 23264, 
								22886, 22870, 22883, 22860 },
		[L["Paladin Set"]] = { 16474, 16476, 16473, 16471, 16475, 16472, 23276, 23277, 23272, 23274, 
								23273, 23275, 29616, 29617, 29615, 29613, 29614, 29612, 29604, 29605, 
								29602, 29600, 29603, 29601 },
		[L["Priest Set"]] = { 17602, 17604, 17605, 17608, 17603, 17607, 23316, 23317, 23303, 23288, 
								23302, 23289, 17623, 17622, 17624, 17620, 17625, 17618, 23261, 23262, 
								22885, 22869, 22882, 22859 },
		[L["Rogue Set"]] = {	16455, 16457, 16453, 16454, 16456, 16446, 23312, 23313, 23298, 23284, 
								23299, 23285, 16561, 16562, 16563, 16560, 16564, 16558, 23257, 23258, 
								22879, 22864, 22880, 22856 },
		[L["Shaman Set"]] = { 29610, 29611, 29609, 29607, 29608, 29606, 29598, 29599, 29596, 29595, 
								29597, 29594, 16578, 16580, 16577, 16574, 16579, 16573, 23259, 23260, 
								22876, 22867, 22887, 22857 },
		[L["Warlock Set"]] = { 17578, 17580, 17581, 17584, 17579, 17583, 23310, 23311, 23297, 23282, 
								23296, 23283, 17591, 17590, 17592, 17588, 17593, 17586, 23255, 23256, 
								22884, 22865, 22881, 22855 },
		[L["Warrior Set"]] = { 16478, 16480, 16477, 16484, 16479, 16483, 23314, 23315, 23300, 23286, 
								23301, 23287, 16542, 16544, 16541, 16548, 16543, 16545, 23244, 23243, 
								22872, 22868, 22873, 22858 },
		[L["Weapons"] .. " (" .. FACTION_ALLIANCE .. ")"] = { 18843, 18847, 23451, 18838, 12584, 23456, 18876, 18827, 18830, 23454, 
								18865, 18867, 23455, 18869, 18873, 18825, 18833, 18836, 18855, 23452, 23453 },
		[L["Weapons"] .. " (" .. FACTION_HORDE .. ")"] = { 18844, 18848, 23466, 18840, 16345, 23467, 18877, 18828, 18831, 23464, 
								18866, 18868, 23465, 18871, 18874, 18826, 18835, 18837, 18860, 23468, 23469 },
		[L["Accessories"] .. " (" .. FACTION_ALLIANCE .. ")"] = { 29465, 29467, 29468, 29471, 35906, 18863, 18856, 18859, 18864, 18862, 
								18857, 29593, 18858, 18854, 18440, 18441, 16342, 18457, 18456, 18455, 
								18454, 18453, 18452, 18449, 18448, 18447, 18445, 18442, 18444, 18443, 
								15196, 15198, 18606, 18839, 18841, 32455 },
		[L["Accessories"] .. " (" .. FACTION_HORDE .. ")"] = { 29466, 29469, 29470, 29472, 34129, 18853, 18846, 18850, 29592, 18851, 
								18849, 18845, 18852, 18834, 18427, 16341, 18461, 18437, 16486, 18436, 
								18434, 18435, 16497, 18432, 16532, 18430, 18429, 15200, 18428, 16335, 
								15197, 15199, 18607, 18839, 18841, 32455 }
	},
	[L["Level 70 Reputation PVP"]] = {	
		[L["Druid Set"]] = { 35357, 35359, 35360, 35356, 35358, 35372, 35374, 35375, 35371, 35373, 
								35362, 35364, 35365, 35361, 35363 },
		[L["Hunter Set"]] = { 35378, 35380, 35376, 35377, 35379 },
		[L["Mage Set"]] = { 35344, 35343, 35346, 35345, 35347 },
		[L["Paladin Set"]] = { 35414, 35416, 35412, 35413, 35415, 35404, 35406, 35402, 35403, 35405 },
		[L["Priest Set"]] = { 35339, 35341, 35342, 35338, 35340, 35333, 35336, 35337, 35335, 35334 },
		[L["Rogue Set"]] = {	35367, 35369, 35370, 35366, 35368 },
		[L["Shaman Set"]] = { 35383, 35385, 35381, 35382, 35384, 35388, 35390, 35386, 35387, 35389, 
								35393, 35395, 35391, 35392, 35394 },
		[L["Warlock Set"]] = { 35329, 35331, 35332, 35328, 35330 },
		[L["Warrior Set"]] = { 35409, 35411, 35407, 35408, 35410 }
	},
	[L["Level 70 Honor PVP"]] = {	
		[L["Weapons"] .. " (" .. FACTION_ALLIANCE .. ")"] = { 28953, 28947, 28957, 28954, 28955, 28956, 28952, 28943, 28944, 28946, 
								28945, 28950, 28951, 28942, 28948, 28949, 28959, 28940, 28960, 28941	},
		[L["Weapons"] .. " (" .. FACTION_HORDE .. ")"] = {	28928, 28922, 28931, 28929, 28930, 28937, 28926, 28293, 28920, 28921, 
								28918, 28924, 28925, 28917, 28919, 28923, 28935, 28939, 28933, 28938 },
		[L["Accessories"] .. " (" .. FACTION_ALLIANCE .. ")"] = { 25829, 28235, 28237, 28238, 28236, 30349, 28234, 30351, 30348, 30350, 
								28246, 28247 },
		[L["Accessories"] .. " (" .. FACTION_HORDE .. ")"] = { 24551, 28241, 28243, 28239, 28242, 30346, 28240, 30345, 30343, 30344, 
								28246, 28247 },
		[L["Accessories"]] = {	28362, 28119, 28363, 31853, 31839, 31855, 31841, 32453, 28118, 28120, 
								28123, 31838, 31852, 31840, 31854 },
		[L["Non Set Accessories"]] = { 28378, 28377, 33920, 33921, 33922, 35317, 35319, 33923, 33056, 33064,
								33057, 34576, 34577, 34578, 35326, 34579, 34580, 33853, 33918, 35320, 33919 },
		[L["Non Set Cloth"]] = { 33883, 33882, 33884, 33901, 33900, 33902, 33913, 33912, 33914 },
		[L["Non Set Leather"]] = {	33881, 33879, 33880, 33887, 33885, 33886, 33893, 33891, 33892, 33917, 
								33915, 33916 },
		[L["Non Set Mail"]] = {	33876, 33877, 33878, 33894, 33895, 33896, 33897, 33898, 33899, 33906, 
								33907, 33908 },
		[L["Non Set Plate"]] = { 33889, 33888, 33890, 33904, 33903, 33905, 33813, 33811, 33812, 33910, 
								33909, 33911 }
	},

	-- Tier 0 (dungeon 1) is already in the level 60 instances (strat, scholo ..)
	[L["Tier 0.5 Quests"]] = { 
		[L["Druid Set"]] = { 22109, 22112, 22113, 22108, 22110, 22106, 22111, 22107 },
		[L["Hunter Set"]] = { 22013, 22016, 22060, 22011, 22015, 22010, 22017, 22061 },
		[L["Mage Set"]] = { 22065, 22068, 22069, 22063, 22066, 22062, 22067, 22064 },
		[L["Paladin Set"]] = { 22091, 22093, 22089, 22088, 22090, 22086, 22092, 22087 },
		[L["Priest Set"]] = { 22080, 22082, 22083, 22079, 22081, 22078, 22085, 22084 },
		[L["Rogue Set"]] = { 22005, 22008, 22009, 22004, 22006, 22002, 22007, 22003 },
		[L["Shaman Set"]] = { 22097, 22101, 22102, 22095, 22099, 22098, 22100, 22096 },
		[L["Warlock Set"]] = { 22074, 22073, 22075, 22071, 22077, 22070, 22072, 22076 },
		[L["Warrior Set"]] = { 21999, 22001, 21997, 21996, 21998, 21994, 22000, 21995 }
	},	
	-- Dungeon 3 (level 70) is already in the BC 5-men
	
	-- Tier 1 is already in MC
	-- Tier 2 is already in BWL, Ony
	
	[L["Tier 3 (Naxxramas Tokens)"]] = {
		[L["Druid Set"]] = { 22490, 22491, 22488, 22495, 22493, 22494, 22489, 22492, 23064 },
		[L["Hunter Set"]] = { 22438, 22439, 22436, 22443, 22441, 22442, 22437, 22440, 23067 },
		[L["Mage Set"]] = { 22498, 22499, 22496, 22503, 22501, 22502, 22497, 22500, 23062 },
		[L["Paladin Set"]] = { 22428, 22429, 22425, 22424, 22426, 22431, 22427, 22430, 23066 },
		[L["Priest Set"]] = { 22514, 22515, 22512, 22519, 22517, 22518, 22513, 22516, 23061 },
		[L["Rogue Set"]] = { 22478, 22479, 22476, 22483, 22481, 22482, 22477, 22480, 23060 },
		[L["Shaman Set"]] = { 22466, 22467, 22464, 22471, 22469, 22470, 22465, 22468, 23065 },
		[L["Warlock Set"]] = { 22506, 22507, 22504, 22511, 22509, 22510, 22505, 22508, 23063 },
		[L["Warrior Set"]] = { 22418, 22419, 22416, 22423, 22421, 22422, 22417, 22420, 23059 }
	},
	[L["Tier 4 Tokens"]] = {
		[BB["Prince Malchezaar"] .. " (" .. BZ["Karazhan"] .. ")"] = { 29098, 29086, 29093, 29081, 29076, 29068, 29073, 
						29061, 29049, 29058, 29044, 29040, 29028, 29035, 28963, 29011, 29021 },		-- T4 helm
		[BB["High King Maulgar"] .. " (" .. BZ["Gruul's Lair"] .. ")"] = { 29100, 29089, 29095, 29084, 29079, 29070, 29075, 
						29064, 29054, 29060, 29047, 29043, 29031, 29037, 28967, 29016, 29023 },		-- T4 shoulder
		[BB["Magtheridon"] .. " (" .. BZ["Magtheridon's Lair"] .. ")"] = { 29096, 29087, 29091, 29082, 29077, 29066, 29071, 
						29062, 29050, 29056, 29045, 29038, 29029, 29033, 28964, 29012, 29019 },		-- T4 chest
		[BB["The Curator"] .. " (" .. BZ["Karazhan"] .. ")"] = { 29097, 29090, 29092, 29085, 29080, 29067, 29072, 
						29065, 29055, 29057, 29048, 29039, 29032, 29034, 28968, 29017, 29020 },		-- T4 gloves
		[BB["Gruul the Dragonkiller"] .. " (" .. BZ["Gruul's Lair"] .. ")"] = { 29099, 29088, 29094, 29083, 29078, 29069, 29074, 
						29063, 29053, 29059, 29046, 29042, 29030, 29036, 28966, 29015, 29022 }		-- T4 leggings
	},
	[L["Tier 5 Tokens"]] = {
		[BB["Lady Vashj"] .. " (" .. BZ["Serpentshrine Cavern"] .. ")"] = { 30228, 30219, 30233, 30141, 30206, 30125, 30131,
						30136, 30152, 30161, 30146, 30190, 30166, 30171, 30212, 30115, 30120 },		-- T5 helm
		[BB["Void Reaver"] .. " (" .. BZ["The Eye"] .. ")"] = { 30230, 30221, 30235, 30143, 30210, 30127, 30133, 
						30138, 30154, 30163, 30149, 30194, 30168, 30173, 30215, 30117, 30122 },		-- T5 shoulders
		[BB["Kael'thas Sunstrider"] .. " (" .. BZ["The Eye"] .. ")"] = { 30222, 30216, 30231, 30139, 30196, 30123, 30129, 
						30134, 30150, 30159, 30144, 30185, 30164, 30169, 30214, 30113, 30118 }, 	-- T5 chest
		[BB["Leotheras the Blind"] .. " (" .. BZ["Serpentshrine Cavern"] .. ")"] = { 30223, 30217, 30232, 30140, 30205, 30124, 30130, 
						30135, 30151, 30160, 30145, 30189, 30165, 30170, 30211, 30114, 30119 },		-- T5 gloves
		[BB["Fathom-Lord Karathress"] .. " (" .. BZ["Serpentshrine Cavern"] .. ")"] = { 30229, 30220, 30234, 30142, 30207, 30126, 30132, 
						30137, 30153, 30162, 30148, 30192, 30167, 30172, 30213, 30116, 30121 }		-- T5 leggings
	},
	[L["Tier 6 Tokens"]] = {
		[BB["Azgalor"] .. " (" .. BZ["Hyjal Summit"] .. ")"] = { 31034, 31032, 31035, 31001, 31055, 30985, 30982, 
						30983, 31060, 31061, 31026, 31011, 31007, 31008, 31050, 30970, 30969 },		-- T6 gloves
		[BB["Archimonde"] .. " (" .. BZ["Hyjal Summit"] .. ")"] = { 31039, 31037, 31040, 31003, 31056, 30987, 30989,
						30988, 31063, 31064, 31027, 31015, 31012, 31014, 31051, 30974, 30972 },		-- T6 helm
		[BB["Mother Shahraz"] .. " (" .. BZ["Black Temple"] .. ")"] = { 31048, 31047, 31049, 31006, 31059, 30997, 30998,
						30996, 31069, 31070, 31030, 31024, 31022, 31023, 31054, 30980, 30979 },		-- T6 shoulders
		[BB["Illidari Council"] .. " (" .. BZ["Black Temple"] .. ")"] = { 31044, 31045, 31046, 31005, 31058, 30995, 30993, 
						30994, 31068, 31067, 31029, 31021, 31019, 31020, 31053, 30978, 30977 },		-- T6 leggings
		[BB["Illidan Stormrage"] .. " (" .. BZ["Black Temple"] .. ")"] = { 31042, 31041, 31043, 31004, 31057, 30991, 30990, 
						30992, 31066, 31065, 31028, 31018, 31016, 31017, 31052, 30976, 30975 },		-- T6 chest
		[BB["Kalecgos"] .. " (" .. BZ["Sunwell Plateau"] .. ")"] = { 34444, 34445, 34446, 34443, 34447, 34433, 34431, 
						34432, 34435, 34434, 34448, 34439, 34438, 34437, 34436, 34442, 34441 },		-- T6 bracers
		[BB["Brutallus"] .. " (" .. BZ["Sunwell Plateau"] .. ")"] = { 34556, 34554, 34555, 34549, 34557, 34488, 34485, 
						34487, 34527, 34528, 34558, 34545, 34543, 34542, 34541, 34547, 34546 },		-- T6 belt
		[BB["Felmyst"] .. " (" .. BZ["Sunwell Plateau"] .. ")"] = { 34573, 34571, 34572, 34570, 34574, 34560, 34561, 
						34559, 34562, 34563, 34575, 34567, 34565, 34566, 34564, 34568, 34569 }		-- T6 boots
	},
	
	[L["Blizzard Collectables"]] = {	
		[L["WoW Collector Edition"]] = {	13582, 13583, 13584 },
		[L["BC Collector Edition (Europe)"]] = { 25535, 30360 },
		[L["Blizzcon 2005"]] = { 20371 },
		[L["Blizzcon 2007"]] = { 33079 },
		["Worldwide Invitational Paris 2008"] = { 39656 },
		[L["Christmas Gift 2006"]] = { 22114 }
	},
	[L["Upper Deck"]] = {
		[L["Loot Card Items"]] = { 23705, 23713, 23720, 32588, 32566, 32542, 33225, 33224, 33223, 33219, 
					34493, 34492, 34499, 35226, 35225, 35223, 23709, 23714, 23716, 35227, 
					38050, 38301, 38233, 38312, 23709, 38313, 38309, 38310, 38314, 38314, 
					38311, 23716, 23714 }
	},
	
	[L["Heroic Mode Tokens"]] = {	
		[L["Fire Resistance Gear"]] = { 30762, 30764, 30761, 30763, 30776, 30780, 30778, 30779, 30773, 30774, 
								30772, 30770, 30769, 30767, 30766, 30768 },
		[BI["Cloth"] .. " (" .. BZ["Shattrath City"] ..  ")"] = { 32090, 32089, 33588, 33589, 33587, 33586, 33291, 33584, 33585 },
		[BI["Cloth"] .. " (" .. BZ["Isle of Quel'Danas"] ..  ")"] = { 34924, 34917, 34936, 34938, 34925, 34937, 34918, 34919, 34926	},
		[BI["Leather"] .. " (" .. BZ["Shattrath City"] ..  ")"] = { 32088, 33972, 32087, 33287, 33973, 33566, 33579, 33578, 33580, 33557, 
								33540, 33974, 33539, 33559, 33583, 33552, 33538, 33582, 33222, 33577 },
		[BI["Leather"] .. " (" .. BZ["Isle of Quel'Danas"] ..  ")"] = { 34906, 34903, 34900, 34927, 34904, 34902, 34901,
								34911, 34929, 34905, 34910, 34928 },
		[BI["Mail"] .. " (" .. BZ["Shattrath City"] ..  ")"] = { 32086, 32085, 33970, 33965, 33535, 33532, 33529, 33528, 33534, 33531, 
								33386, 33536, 33280, 33530, 33527, 33537, 33324 },
		[BI["Mail"] .. " (" .. BZ["Isle of Quel'Danas"] ..  ")"] = { 34912, 34933, 34930, 34916, 34935, 34932, 34914, 34931, 34934 },
		[BI["Plate"] .. " (" .. BZ["Shattrath City"] ..  ")"] = {	33810, 32083, 32084, 33514, 33522, 33516, 33513, 33520, 33517, 33512, 
								33519, 33331, 33524, 33279, 33501, 33518, 33515, 33207, 33523 },
		[BI["Plate"] .. " (" .. BZ["Isle of Quel'Danas"] ..  ")"] = { 34942, 34939, 34921, 34945, 34944, 34941, 34923, 34922, 34946, 34943, 
								34940, 34947 },
		[L["Cloaks"] .. " (" .. BZ["Shattrath City"] ..  ")"] = { 29375, 29382, 35321, 33304, 35324, 33484, 29385, 33333, 29369, 33593	},
		[L["Relics"] .. " (" .. BZ["Shattrath City"] ..  ")"] = { 29390, 33508, 33509, 33510, 33506, 33507, 33505, 29389, 33503, 33504, 
								33502, 29388 },
		[L["Accessories"] .. " (" .. BZ["Shattrath City"] ..  ")"] = {	33296, 29381, 29374, 29386, 29368, 29373, 29379, 29367, 29384, 23572, 
								35326, 34049, 34163, 34162, 33832, 34050, 29383, 29376, 29387, 29370, 30183 },
		[L["Accessories"] .. " (" .. BZ["Isle of Quel'Danas"] ..  ")"] = { 34887, 34890, 34889, 34888, 32227, 32228, 32229,
								32231, 32249, 32230, 35318, 35315, 35316},
		[L["Weapons"] .. " (" .. BZ["Shattrath City"] ..  ")"] = {	29275, 33192, 29268, 29267, 29266, 33334, 29270, 29273, 29272, 29269, 
								29271, 29274, 33325 },
		[L["Weapons"] .. " (" .. BZ["Isle of Quel'Danas"] ..  ")"] = {	34894, 34896, 34895, 34893, 34951, 34950, 34949, 34952, 34891, 34898, 34892 }
	},

	[L["World Drops"]] = {
		[L["Level 30-39"]] = { 867, 1981, 1980, 869, 1982, 870, 868, 873, 1204, 2825 },
		[L["Level 40-49"]] = { 3075, 940, 14551, 17007, 14549, 1315, 942, 1447, 2164,  2163, 
								809, 871, 2291, 810, 2915, 812, 943, 1169, 1979, 2824, 2100 },
		[L["Level 50-60"]] = { 3475, 14553, 2245, 14552, 14554, 1443, 14558, 2246, 833, 14557,
								1728, 14555, 2244, 2801, 647, 811, 1263, 2243, 944, 1168, 2099 },
		[L["Level 70"]] = { 34703, 28189, 31329, 31340, 31343, 31333, 31330, 31328, 31335, 31320,
								31338, 31321, 31319, 31339, 31326, 31331, 31336, 31332, 31318, 31342, 
								31322, 31334, 34622, 31323 }
	}
}
