
local AlphaQuestHelper_Frame = CreateFrame("Frame");
local qhFrame = QuestHelper.map_overlay;
local updateLimit, updateTimer = 0.2, 0;

local function AlphaQuestHelper_OnEvent(_, event)
	-- Quick Fix for Cartographer compatibility
	-- QuestHelper also needs to reassign WorldMapButton as the .map_overlay parent in order for icons and ants to remain visible
	if ( Cartographer ) then
		qhFrame:SetParent(WorldMapButton);
	end

	qhFrameOriP = qhFrame:GetParent();
	if ( not qhFrameOriP ) then
		qhFrameOriP = WorldMapButton;
	end
end

-- atm, AlphaMap is the only other AddOn trying to display QH off the World Map, so I've left it implemented this way ;p
local function AlphaQuestHelper_OnUpdate(_, elapsed)
	updateTimer = updateTimer + elapsed;

	if ( updateTimer > updateLimit ) then
		local qhFrameP = qhFrame:GetParent();
		if ( ( AlphaMapFrame:IsVisible() ) and ( not AlphaMapAlphaMapFrame:IsVisible() ) and ( not qhFrameOriP:IsVisible() ) ) then
			if ( ( qhFrameP ~= AlphaMapFrame ) and ( not QuestHelper_Pref.hide ) ) then
				qhFrame:ClearAllPoints();
				qhFrame:SetParent(AlphaMapFrame);
				qhFrame:SetFrameLevel( AlphaMapFrame:GetFrameLevel() + 3 );
				qhFrame:SetAllPoints(AlphaMapFrame);
				qhFrame:Show();
			end

		elseif ( ( qhFrameP ~= qhFrameOriP ) and ( not QuestHelper_Pref.hide ) ) then
			qhFrame:ClearAllPoints();
			qhFrame:SetParent(qhFrameOriP);
			qhFrame:SetFrameLevel( qhFrameOriP:GetFrameLevel() + 1 );
			qhFrame:SetAllPoints();
			qhFrame:Show();
		end
	end
end

AlphaQuestHelper_Frame:SetScript("OnEvent", AlphaQuestHelper_OnEvent);
AlphaQuestHelper_Frame:SetScript("OnUpdate", AlphaQuestHelper_OnUpdate);
AlphaQuestHelper_Frame:RegisterEvent("VARIABLES_LOADED");
