
local amOri_MobMap_DisplayPositionData;
local amOri_MobMap_HideAllDots;
local amOri_MobMap_SwitchMapAndDisplay;
local amOri_MobMap_UpdatePositions;

local AlphaMobMap_Frame = CreateFrame("Frame");
local WorldMapWasNotVisible;



local function amNew_MobMap_UpdatePositions(...)
	local tmpF;

	if ( ( AlphaMapFrame:IsVisible() ) and ( not AlphaMapAlphaMapFrame:IsVisible() ) and ( not WorldMapFrame:IsVisible() ) ) then
		tmpF = WorldMapFrame.Show;
		WorldMapFrame.Show = function() return; end
	end
	amOri_MobMap_UpdatePositions(...);
	if ( tmpF ) then
		WorldMapFrame.Show = tmpF;
	end
end

local function amNew_MobMap_SwitchMapAndDisplay(...)
	local tmpF;

	if ( ( AlphaMapFrame:IsVisible() ) and ( not AlphaMapAlphaMapFrame:IsVisible() ) and ( not WorldMapFrame:IsVisible() ) ) then
		tmpF = ShowUIPanel;
		ShowUIPanel = function() return; end
	end
	amOri_MobMap_SwitchMapAndDisplay(...);
	if ( tmpF ) then
		ShowUIPanel = tmpF;
	end
end

local function amDummyTrue()
	return true;
end

local function AlphaMobMap_OnEvent(_, event)
	if ( event == "VARIABLES_LOADED" ) then
		amOri_MobMap_DisplayPositionData = MobMap_DisplayPositionData;
		MobMap_DisplayPositionData = amNew_MobMap_DisplayPositionData;
		amOri_MobMap_HideAllDots = MobMap_HideAllDots;
		MobMap_HideAllDots = amNew_MobMap_HideAllDots;
		amOri_MobMap_SwitchMapAndDisplay = MobMap_SwitchMapAndDisplay;
		MobMap_SwitchMapAndDisplay = amNew_MobMap_SwitchMapAndDisplay;
		amOri_MobMap_UpdatePositions = MobMap_UpdatePositions;
		MobMap_UpdatePositions = amNew_MobMap_UpdatePositions;

	elseif ( event == "WORLD_MAP_UPDATE" ) then
		if ( ( mobmap_enabled ) and ( ( MobMapMobSearchFrame ) or ( MobMapPickupListFrame ) ) ) then
			if ( ( AlphaMapFrame:IsVisible() ) and ( not AlphaMapAlphaMapFrame:IsVisible() ) ) then
				if(mobmap_lastzone~=MobMap_GetCurrentMapZoneName()) then
					local tmpF = WorldMapFrame.IsVisible;
					WorldMapFrame.IsVisible = amDummyTrue;
					mobmap_lastzone = MobMap_GetCurrentMapZoneName();
					MobMap_Display();
					WorldMapFrame.IsVisible = tmpF;
				end
			end
		end
	end
end


local function AM_MobMap_DisplayDotTooltip()
	if ( mobmap_show_world_map_tooltips )  then
		if ( this.idtable ) then
			AlphaMapTooltip:SetOwner(this, "ANCHOR_TOPLEFT");
			AlphaMapTooltip:AddDoubleLine("Position:", this.xcoord..", "..this.ycoord, 1, 1, 1, 1, 1, 1);
			local k,v;
			for k, v in pairs(this.idtable) do
				AlphaMapTooltip:AddLine(MobMap_GetMobName(v));
			end		
			AlphaMapTooltip:Show();
		end
		if ( this.ihidtable ) then
			AlphaMapTooltip:SetOwner(this, "ANCHOR_TOPLEFT");
			AlphaMapTooltip:AddDoubleLine("Position:", this.xcoord..", "..this.ycoord, 1, 1, 1, 1, 1, 1);
			local k,v;
			for k, v in pairs(this.ihidtable) do
				local itemname=MobMap_GetItemNameByIHID(v);
				local itemid, quality = MobMap_GetItemDataByIHID(v);
				AlphaMapTooltip:AddLine(MobMap_ConstructColorizedItemName(quality, itemname));
			end
			AlphaMapTooltip:Show();
		end
	end
end

local function AM_MobMap_HideDotTooltip()
	AlphaMapTooltip:Hide();
end

local function AM_MobMapDotFrame_OnClick()
	if ( MN_ThottInterface_Local ) then
		local desc;
		local additional;
		if ( this.idtable ) then
			desc = this.xcoord.. ", " .. this.ycoord;
			for k, v in pairs(this.idtable) do
				if ( not additional ) then
					desc = desc .. " : " .. MobMap_GetMobName(v);
					additional = true;
				else
					desc = desc .. ", " .. MobMap_GetMobName(v);
				end
			end		
			AlphaMapTooltip:Show();
		end
		if ( this.ihidtable ) then
			desc = this.xcoord..", "..this.ycoord.."\n";
			for k, v in pairs(this.ihidtable) do
				local itemname=MobMap_GetItemNameByIHID(v);
				local itemid, quality = MobMap_GetItemDataByIHID(v);
				if ( not additional ) then
					desc = desc .. " : " .. MobMap_ConstructColorizedItemName(quality, itemname);
					additional = true;
				else
					desc = desc .. ", " .. MobMap_ConstructColorizedItemName(quality, itemname);
				end
			end
		end
		if ( not desc ) then desc = "MobMap"; end
		MN_ThottInterface_Local(this.xcoord, this.ycoord, desc, "MobMap");
	end
end

local function AM_MobMap_DisplayPositionData(posdata, mobid, ihid, ...)
	local frame, texture, texture2;
	for k, v in pairs(posdata) do
		for x = v.x1, v.x2, 1 do
			frame = getglobal("AM_MobMapDot" .. x .. "_" .. v.y);
			if ( not frame ) then 
				frame = CreateFrame("Button", "AM_MobMapDot" ..x.. "_" .. v.y, AlphaMapUnits, "MobMapDotFrameTemplate");
				frame:SetScript("OnEnter", AM_MobMap_DisplayDotTooltip);
				frame:SetScript("OnLeave", AM_MobMap_HideDotTooltip);
				frame:SetScript("OnClick", AM_MobMapDotFrame_OnClick);
				frame:RegisterForClicks("LeftButtonUp");
			end
			frame:ClearAllPoints();
			frame:SetPoint("TOPLEFT", AlphaMapUnits, "TOPLEFT", x*frame:GetWidth(), -v.y*frame:GetHeight());
			frame:SetFrameLevel(AlphaMapFrame:GetFrameLevel()+2); 
--			frame:SetAlpha(mobmap_dot_transparency);
			frame.xcoord=x;
			frame.ycoord=v.y;

			if ( mobid ) then
				if ( not frame.idtable ) then
					frame.idtable = {};
				end
				table.insert(frame.idtable, mobid);
			end

			if ( ihid ) then
				if ( not frame.ihidtable ) then
					frame.ihidtable={};
				end
				table.insert(frame.ihidtable, ihid);
			end

			texture  = getglobal(frame:GetName() .. "Texture");
			texture2 = getglobal(frame:GetName() .. "Texture2");
			texture:SetVertexColor(mobmap_outer_dot_color.r, mobmap_outer_dot_color.g, mobmap_outer_dot_color.b);
			texture:SetAlpha(mobmap_outer_dot_color.a);
			texture2:SetVertexColor(mobmap_inner_dot_color.r, mobmap_inner_dot_color.g, mobmap_inner_dot_color.b);
			texture2:SetAlpha(mobmap_inner_dot_color.a);

			frame:Show();
		end
	end
end

AlphaMobMap_Frame:SetScript("OnEvent", AlphaMobMap_OnEvent);
AlphaMobMap_Frame:RegisterEvent("VARIABLES_LOADED");
AlphaMobMap_Frame:RegisterEvent("WORLD_MAP_UPDATE");

-- Hooked Functions
function amNew_MobMap_HideAllDots(...)
	amOri_MobMap_HideAllDots(...);
	local frame;

	for x=1,99,1 do
		for y=1,99,1 do
			frame=getglobal("AM_MobMapDot"..x.."_"..y);
			if ( frame ) then 
				frame:Hide();
				frame.idtable=nil;
				frame.ihidtable=nil;
			end
		end
	end
end

function amNew_MobMap_DisplayPositionData(posdata, mobid, ihid, ...)
	amOri_MobMap_DisplayPositionData(posdata, mobid, ihid, ...);

	if ( not posdata ) then return; end

	AM_MobMap_DisplayPositionData(posdata, mobid, ihid, ...);
end
