-- [[
-- AlphaMap v2.11.11100 Traditional Chinese Localization File
-- Initial Translated by: Arith Hsu (2006/07/21)
-- Maintained by: Arith Hsu
-- Last Updated: 2006/07/26
-- Comments:
--    2006/07/27 Arith: 翻譯這個插件的文字，工作量是很龐大的，特別是要去查詢各副本裡的 boss 名稱，還有一些對應的任務名稱和
--                      一些任務注意事項等。期望看到後續有人熱心維護這個翻譯，但是請尊重各個維護翻譯的人的辛勞，你可以把你
--                      的名字加在檔頭，但是請勿移除其他人的名字。
--                      使用簡體中文的朋友如果是拿這個正體中文檔案直接轉簡體，我也沒什麼意見，但是請一樣保留原翻譯者的記錄
--                      另外請注意，正體中文和簡體中文的翻譯還是有諸多的不一致，請自行修正。
-- Revision History:
--    7/26: Complete about 95% translations.
-- ]]

if ( GetLocale() == "zhTW" ) then

	AM_TYP_WORLDBOSSES	= "非副本地圖";

	AM_ALPHAMAP_WORLDBOSSES_LIST = {

			{	name = "艾索雷葛斯",				-- Azuregos
				type = AM_TYP_WORLDBOSSES,
				displayname = "艾索雷葛斯",
				filename = "AM_Azuregos_Map",
				location = "艾薩拉 (大約位置 56, 81)",
				minimapZoom = 1.5385,
				minimapXOffset = 0,
				minimapYOffset = 0,
				area = "Aszhara",				-- Deliberately spelt Aszhara !
				levels = "60",
				players = AM_NO_LIMIT,
				prereq = "",
				general = "",
				wmData = { minX = 0.485, maxX = 0.62743, minY = 0.71498, maxY = 0.917 },
				amData = { minX = 0.005, maxX = 0.995, minY = 0.005, maxY = 0.995 },
				dtl1 = { text = "艾索雷葛斯", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "對話後啟動戰鬥", lootid = "AAzuregos", leaveGap = 1 }
			},

			{	name = "四巨龍: 暮色森林",		-- Four Dragons
				type = AM_TYP_WORLDBOSSES,
				displayname = "四巨龍: 暮色森林",
				filename = "AM_Dragon_Duskwood_Map",
				location = "暮色森林 : 黎明森林 (46, 36)",
				minimapZoom = 2.11,
				minimapXOffset = 54,
				minimapYOffset = 0,
				area = "Duskwood",
				levels = "60",
				players = AM_NO_LIMIT,
				prereq = "",
				general = "",
				wmData = { minX = 0.421, maxX = .526, minY = 0.292, maxY = 0.54 },
				amData = { minX = 0.29, maxX = .85, minY = 0.115, maxY = 0.97 },
				dtl1 = { text = "逼近", colour = AM_GREEN, coords = { {48, 96} }, symbol = { AM_ENTRANCE },
						tooltiptxt = "", leaveGap = 1 },
				dtl2 = { text = "翡翠傳送門", colour = AM_GREEN, coords = { {54, 47} }, symbol = { "1" },
						tooltiptxt = "首領\n伊索德雷", special = AM_WANDERS, leaveGap = 1 },
				dtl3 = { text = "艾莫莉絲", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "DEmeriss" },
				dtl4 = { text = "雷索", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "DLethon" },
				dtl5 = { text = "泰拉爾", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "DTaerar" },
				dtl6 = { text = "伊索德雷", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "DYsondre" },
			},

			{	name = "四巨龍: 辛特蘭",			-- Four Dragons
				type = AM_TYP_WORLDBOSSES,
				displayname = "四巨龍: 辛特蘭",
				filename = "AM_Dragon_Hinterlands_Map",
				location = "辛特蘭 : 瑟拉丹 (46, 36)",
				minimapZoom = 2,
				minimapXOffset = 0,
				minimapYOffset = 0,
				area = "Hinterlands",
				levels = "60",
				players = AM_NO_LIMIT,
				prereq = "",
				general = "三人一組徘徊的 62 & 61 級菁英",
				wmData = { minX = 0.561, maxX = .697, minY = 0.159, maxY = 0.362 },
				amData = { minX = 0.005, maxX = .995, minY = 0.005, maxY = 0.995 },
				dtl1 = { text = "逼近", colour = AM_GREEN, coords = { {37, 98} }, symbol = { AM_ENTRANCE },
						tooltiptxt = "", leaveGap = 1 },
				dtl2 = { text = "雷索", colour = AM_RED, coords = { {52.5, 59} }, symbol = { "1" },
						tooltiptxt = "Lvl62 菁英龍族", special = AM_WANDERS },
				dtl3 = { text = "尋夢者", colour = AM_RED, coords = { {51, 49} }, symbol = { "2" },
						tooltiptxt = "Lvl62 菁英龍族" },
				dtl4 = { text = "翡翠傳送門", colour = AM_GREEN, coords = { {46, 39} }, symbol = { "3" },
						tooltiptxt = "首領\n泰拉爾", leaveGap = 1 },
				dtl5 = { text = "艾莫莉絲", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "DEmeriss" },
				dtl6 = { text = "雷索", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "DLethon" },
				dtl7 = { text = "泰拉爾", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "DTaerar" },
				dtl8 = { text = "伊索德雷", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "DYsondre" },
			},

			{	name = "四巨龍: 菲拉斯",			-- Four Dragons
				type = AM_TYP_WORLDBOSSES,
				displayname = "四巨龍: 菲拉斯",
				filename = "AM_Dragon_Feralas_Map",
				location = "菲拉斯 : 夢境之樹 (51, 9)",	-- Jademir Lake
				minimapZoom = 2,
				minimapXOffset = 0,
				minimapYOffset = 0,
				area = "Feralas",
				levels = "60",
				players = AM_NO_LIMIT,
				prereq = "",
				general = "三人一組徘徊的 62 & 61 級菁英",
				wmData = { minX = 0.47695, maxX = .55113, minY = 0.04585, maxY = 0.15963 },
				amData = { minX = 0.005, maxX = .995, minY = 0.005, maxY = 0.995 },
				dtl1 = { text = "睡夢咆哮者", colour = AM_RED, coords = { {36, 63} }, symbol = { "1" },
						tooltiptxt = "Lvl62 菁英龍族\n在島上巡邏", special = AM_WANDERS },
				dtl2 = { text = "萊薩拉斯", colour = AM_RED, coords = { {46, 68} }, symbol = { "2" },
						tooltiptxt = "Lvl62 菁英龍族\nP在島上巡邏", special = AM_WANDERS },
				dtl3 = { text = "翡翠傳送門", colour = AM_GREEN, coords = { {45, 57} }, symbol = { "3" },
						tooltiptxt = "首領\n艾莫莉絲", leaveGap = 1 },
				dtl4 = { text = "艾莫莉絲", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "DEmeriss" },
				dtl5 = { text = "雷索", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "DLethon" },
				dtl6 = { text = "泰拉爾", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "DTaerar" },
				dtl7 = { text = "伊索德雷", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "DYsondre" },
			},

			{	name = "四巨龍: 梣谷",		-- Four Dragons
				type = AM_TYP_WORLDBOSSES,
				displayname = "四巨龍: 梣谷",
				filename = "AM_Dragon_Ashenvale_Map",
				location = "梣谷 : 大樹蔭 (93, 36)",
				minimapZoom = 2,
				minimapXOffset = 0,
				minimapYOffset = 0,
				area = "Ashenvale",
				levels = "60",
				players = AM_NO_LIMIT,
				prereq = "",
				general = "三人一組徘徊的 62 & 61 級菁英",
				wmData = { minX = 0.895, maxX = .984, minY = 0.299, maxY = 0.4286 },
				amData = { minX = 0.005, maxX = .995, minY = 0.005, maxY = 0.995 },
				dtl1 = { text = "范迪姆", colour = AM_RED, coords = { {57, 75} }, symbol = { "1" },
						tooltiptxt = "Lvl62 菁英龍族", special = AM_WANDERS },
				dtl2 = { text = "巡夢者", colour = AM_RED, coords = { {50.4, 57} }, symbol = { "2" },
						tooltiptxt = "Lvl62 菁英龍族" },
				dtl3 = { text = "翡翠傳送門", colour = AM_GREEN, coords = { {50.8, 48} }, symbol = { "3" },
						tooltiptxt = "首領\n雷索", leaveGap = 1 },
				dtl4 = { text = "艾莫莉絲", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "DEmeriss" },
				dtl5 = { text = "雷索", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "DLethon" },
				dtl6 = { text = "泰拉爾", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "DTaerar" },
				dtl7 = { text = "伊索德雷", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "DYsondre" },
			},

			{	name = "Doom Lord Kazzak",			-- Lord Kazzak
				type = AM_TYP_WORLDBOSSES,
				displayname = "毀滅之王卡札克",
				filename = "AM_DoomKazzak_Map",
				location = "地獄火半島",
				minimapZoom = 1.4,
				minimapXOffset = 0,
				minimapYOffset = 0,
				area = "Hellfire",
				levels = "70",
				players = AM_NO_LIMIT,
				prereq = "",
				general = "",
				wmData = { minX = 0.555, maxX = 0.703, minY = 0.05885, maxY = 0.27653 },
				amData = { minX = 0.00, maxX = 0.99, minY = 0.01, maxY = 0.98 },
				dtl1 = { text = "毀滅之王卡札克", colour = AM_RED, coords = { {51.8, 44.1} }, symbol = { "1" },
						tooltiptxt = "", lootid = "KKazzak", leaveGap = 1 },
				dtl2 = { text = "GY", colour = AM_GREEN, coords = { {60, 76} }, symbol = { "GY" },
						tooltiptxt = "", leaveGap = 1 }
			},

			{	name = "HighlordKruul",			-- HighlordKruul
				type = AM_TYP_WORLDBOSSES,
				displayname = "卡魯歐領主",
				filename = "AM_DoomKazzak_Map",
				location = "詛咒之地",
				minimapZoom = 1.42,
				minimapXOffset = 0,
				minimapYOffset = 0,
				area = "BlastedLands",
				levels = "70",
				players = AM_NO_LIMIT,
				prereq = "",
				general = "",
				wmData = { minX = 0.3196, maxX = 0.496, minY = 0.468, maxY = 0.80 },
				amData = { minX = 0.10, maxX = 0.91, minY = 0.01, maxY = 0.99 },
				dtl1 = { text = "Draco the Decrepit", colour = AM_GREEN, coords = { {21, 10} }, symbol = { "1" },
						tooltiptxt = "", leaveGap = 1 },
				dtl2 = { text = "卡魯歐領主", colour = AM_RED, coords = { {32.5, 84.5} }, symbol = { "2" },
						tooltiptxt = "Boss", lootid = "KKruul", leaveGap = 1 },
			},

			{	name = "Doomwalker",			-- Doomwalker
				type = AM_TYP_WORLDBOSSES,
				displayname = "厄運行者",
				filename = "AM_DoomKazzak_Map",
				location = "影月谷",
				minimapZoom = 1.0,
				minimapXOffset = 0,
				minimapYOffset = 0,
				area = "ShadowmoonValley",
				levels = "70",
				players = AM_NO_LIMIT,
				prereq = "",
				general = "",
				wmData = { minX = 0.555, maxX = 0.703, minY = 0.05885, maxY = 0.27653 },
				amData = { minX = 0.00, maxX = 0.99, minY = 0.01, maxY = 0.98 },
				dtl1 = { text = "厄運行者", colour = AM_RED, coords = { {51.8, 44.1} }, symbol = { "1" },
						tooltiptxt = "Boss", lootid = "DDoomwalker", leaveGap = 1 },
			},

		};

end