--------------------------------------------------------------------------
-- localization.lua
--------------------------------------------------------------------------

AM_TYP_WORLDBOSSES	= "World Bosses";

-- For these the filenames refer to data entries in the "Constants.lua" file which defines which of the IN-GAME Minimap textures to use
-- the Zoom and Offsets allow the Minimap textures to be zoomed in and repositioned slightly in the AlphaMapAlphaMapFrame
-- the wmData and amData allow the positioning of Player/Party/Raid dots on the map and relate GetPlayerCoordinates to frame coordinates on the map

AM_ALPHAMAP_WORLDBOSSES_LIST = {

		{	name = "Azuregos",				-- Azuregos
			type = AM_TYP_WORLDBOSSES,
			displayname = "Azuregos",
			filename = "AM_Azuregos_Map",
			location = "Azshara (Approx. 56, 81)",
			minimapZoom = 1.5385,
			minimapXOffset = 0,
			minimapYOffset = 0,
			area = "Aszhara",				-- Deliberately spelt Aszhara !
			levels = "60",
			players = AM_NO_LIMIT,
			prereq = "",
			general = "",
			wmData = { minX = 0.485, maxX = 0.62743, minY = 0.71498, maxY = 0.917 },
			amData = { minX = 0.005, maxX = 0.995, minY = 0.005, maxY = 0.995 },
			dtl1 = { text = "Azuregos", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "Talk with to trigger combat", lootid = "AAzuregos", leaveGap = 1 }
		},

		{	name = "Four Dragons: Duskwood",		-- Four Dragons
			type = AM_TYP_WORLDBOSSES,
			displayname = "Four Dragons: Duskwood",
			filename = "AM_Dragon_Duskwood_Map",
			location = "Duskwood : Twighlight Grove (46, 36)",
			minimapZoom = 2.11,
			minimapXOffset = 54,
			minimapYOffset = 0,
			area = "Duskwood",
			levels = "60",
			players = AM_NO_LIMIT,
			prereq = "",
			general = "",
			wmData = { minX = 0.421, maxX = .526, minY = 0.292, maxY = 0.54 },
			amData = { minX = 0.29, maxX = .85, minY = 0.115, maxY = 0.97 },
			dtl1 = { text = "Approach", colour = AM_GREEN, coords = { {48, 96} }, symbol = { AM_ENTRANCE },
					tooltiptxt = "", leaveGap = 1 },
			dtl2 = { text = "Emerald Gate", colour = AM_GREEN, coords = { {54, 47} }, symbol = { "1" },
					tooltiptxt = "Boss\nYsondre", special = AM_WANDERS, leaveGap = 1 },
			dtl3 = { text = "Emeriss", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "DEmeriss" },
			dtl4 = { text = "Lethon", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "DLethon" },
			dtl5 = { text = "Taerar", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "DTaerar" },
			dtl6 = { text = "Ysondre", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "DYsondre" },
		},

		{	name = "Four Dragons: Hinterlands",			-- Four Dragons
			type = AM_TYP_WORLDBOSSES,
			displayname = "Four Dragons: Hinterlands",
			filename = "AM_Dragon_Hinterlands_Map",
			location = "Hinterlands : Seradane (46, 36)",
			minimapZoom = 2,
			minimapXOffset = 0,
			minimapYOffset = 0,
			area = "Hinterlands",
			levels = "60",
			players = AM_NO_LIMIT,
			prereq = "",
			general = "Wandering trios of level 62 & 61 Elites",
			wmData = { minX = 0.561, maxX = .697, minY = 0.159, maxY = 0.362 },
			amData = { minX = 0.005, maxX = .995, minY = 0.005, maxY = 0.995 },
			dtl1 = { text = "Approach", colour = AM_GREEN, coords = { {37, 98} }, symbol = { AM_ENTRANCE },
					tooltiptxt = "", leaveGap = 1 },
			dtl2 = { text = "Rothos", colour = AM_RED, coords = { {52.5, 59} }, symbol = { "1" },
					tooltiptxt = "Lvl62 Elite Dragonkin", special = AM_WANDERS },
			dtl3 = { text = "Dreamtracker", colour = AM_RED, coords = { {51, 49} }, symbol = { "2" },
					tooltiptxt = "Lvl62 Elite Dragonkin" },
			dtl4 = { text = "Emerald Gate", colour = AM_GREEN, coords = { {46, 39} }, symbol = { "3" },
					tooltiptxt = "Boss\nTaerar", leaveGap = 1 },
			dtl5 = { text = "Emeriss", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "DEmeriss" },
			dtl6 = { text = "Lethon", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "DLethon" },
			dtl7 = { text = "Taerar", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "DTaerar" },
			dtl8 = { text = "Ysondre", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "DYsondre" },
		},

		{	name = "Four Dragons: Feralas",			-- Four Dragons
			type = AM_TYP_WORLDBOSSES,
			displayname = "Four Dragons: Feralas",
			filename = "AM_Dragon_Feralas_Map",
			location = "Feralas : Dream Bough (51, 9)",	-- Jademir Lake
			minimapZoom = 2,
			minimapXOffset = 0,
			minimapYOffset = 0,
			area = "Feralas",
			levels = "60",
			players = AM_NO_LIMIT,
			prereq = "",
			general = "Wandering trios of level 62 & 61 Elites",
			wmData = { minX = 0.47695, maxX = .55113, minY = 0.04585, maxY = 0.15963 },
			amData = { minX = 0.005, maxX = .995, minY = 0.005, maxY = 0.995 },
			dtl1 = { text = "Dreamroarer", colour = AM_RED, coords = { {36, 63} }, symbol = { "1" },
					tooltiptxt = "Lvl62 Elite Dragonkin\nPatrols round Island", special = AM_WANDERS },
			dtl2 = { text = "Lethlas", colour = AM_RED, coords = { {46, 68} }, symbol = { "2" },
					tooltiptxt = "Lvl62 Elite Dragonkin\nPatrols round Island", special = AM_WANDERS },
			dtl3 = { text = "Emerald Gate", colour = AM_GREEN, coords = { {45, 57} }, symbol = { "3" },
					tooltiptxt = "Boss\nEmeriss", leaveGap = 1 },
			dtl4 = { text = "Emeriss", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "DEmeriss" },
			dtl5 = { text = "Lethon", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "DLethon" },
			dtl6 = { text = "Taerar", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "DTaerar" },
			dtl7 = { text = "Ysondre", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "DYsondre" },
		},

		{	name = "Four Dragons: Ashenvale",		-- Four Dragons
			type = AM_TYP_WORLDBOSSES,
			displayname = "Four Dragons: Ashenvale",
			filename = "AM_Dragon_Ashenvale_Map",
			location = "Ashenvale : Bough Shadow (93, 36)",
			minimapZoom = 2,
			minimapXOffset = 0,
			minimapYOffset = 0,
			area = "Ashenvale",
			levels = "60",
			players = AM_NO_LIMIT,
			prereq = "",
			general = "Wandering trios of level 62 & 61 Elites",
			wmData = { minX = 0.895, maxX = .984, minY = 0.299, maxY = 0.4286 },
			amData = { minX = 0.005, maxX = .995, minY = 0.005, maxY = 0.995 },
			dtl1 = { text = "Phantim", colour = AM_RED, coords = { {57, 75} }, symbol = { "1" },
					tooltiptxt = "Lvl62 Elite Dragonkin", special = AM_WANDERS },
			dtl2 = { text = "Dreamstalker", colour = AM_RED, coords = { {50.4, 57} }, symbol = { "2" },
					tooltiptxt = "Lvl62 Elite Dragonkin" },
			dtl3 = { text = "Emerald Gate", colour = AM_GREEN, coords = { {50.8, 48} }, symbol = { "3" },
					tooltiptxt = "Boss\nLethon", leaveGap = 1 },
			dtl4 = { text = "Emeriss", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "DEmeriss" },
			dtl5 = { text = "Lethon", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "DLethon" },
			dtl6 = { text = "Taerar", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "DTaerar" },
			dtl7 = { text = "Ysondre", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "DYsondre" },
		},

		{	name = "Doom Lord Kazzak",			-- Lord Kazzak
			type = AM_TYP_WORLDBOSSES,
			displayname = "Doom Lord Kazzak",
			filename = "AM_DoomKazzak_Map",
			location = "Hellfire Peninsula",
			minimapZoom = 1.4,
			minimapXOffset = 0,
			minimapYOffset = 0,
			area = "Hellfire",
			levels = "70",
			players = AM_NO_LIMIT,
			prereq = "",
			general = "",
			wmData = { minX = 0.555, maxX = 0.703, minY = 0.05885, maxY = 0.27653 },
			amData = { minX = 0.00, maxX = 0.99, minY = 0.01, maxY = 0.98 },
			dtl1 = { text = "Doom Lord Kazzak", colour = AM_RED, coords = { {51.8, 44.1} }, symbol = { "1" },
					tooltiptxt = "Boss", lootid = "KKazzak", leaveGap = 1 },
			dtl2 = { text = "GY", colour = AM_GREEN, coords = { {60, 76} }, symbol = { "GY" },
					tooltiptxt = "", leaveGap = 1 }
		},

		{	name = "HighlordKruul",			-- HighlordKruul
			type = AM_TYP_WORLDBOSSES,
			displayname = "Highlord Kruul",
			filename = "AM_Kazzak_Map",
			location = "Blasted Lands",
			minimapZoom = 1.42,
			minimapXOffset = 46,
			minimapYOffset = 0,
			area = "BlastedLands",
			levels = "70",
			players = AM_NO_LIMIT,
			prereq = "",
			general = "",
			wmData = { minX = 0.3196, maxX = 0.496, minY = 0.468, maxY = 0.80 },
			amData = { minX = 0.10, maxX = 0.91, minY = 0.01, maxY = 0.99 },
			dtl1 = { text = "Draco the Decrepit", colour = AM_GREEN, coords = { {21, 10} }, symbol = { "1" },
					tooltiptxt = "", leaveGap = 1 },
			dtl2 = { text = "Highlord Kruul", colour = AM_RED, coords = { {32.5, 84.5} }, symbol = { "2" },
					tooltiptxt = "Boss", lootid = "KKruul", leaveGap = 1 },
		},

		{	name = "Doomwalker",			-- Doomwalker
			type = AM_TYP_WORLDBOSSES,
			displayname = "Doomwalker",
			filename = "AM_Doomwalker_Map",
			location = "Shadowmoon Valley",
			minimapZoom = 1.0,
			minimapXOffset = 0,
			minimapYOffset = 0,
			area = "ShadowmoonValley",
			levels = "70",
			players = AM_NO_LIMIT,
			prereq = "",
			general = "",
			wmData = { minX = 0.572, maxX = 0.73, minY = 0.289, maxY = 0.559 },
			amData = { minX = 0.01, maxX = 0.8, minY = 0.01, maxY = 0.95 },
			dtl1 = { text = "Doomwalker", colour = AM_RED, coords = { {64, 53.9} }, symbol = { "1" },
					tooltiptxt = "Boss", lootid = "DDoomwalker", leaveGap = 1 },
		},

};


